<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Entradas extends CI_Controller
{

    function __construct()
    {
        parent::__construct();
        $this->load->library('grocery_CRUD');
        $this->load->model('proceso_model');
        $this->load->model('gsatelite');
        $this->load->model('cotizaciones_model', 'cotModel');
        $this->load->model('facturacion_model');
    }

    function index()
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $this->_cargarvista();
        }
    }

    function caracteristicas(){
        satelite_validar();
        $this->load->library('../controllers/inventario/mantenimiento');
        $this->mantenimiento->caracteristicas("facturacion/entradas/caracteristicas");
    }
    function caracteristicas_ver($car_id){
        satelite_validar();
        $this->load->library('../controllers/inventario/mantenimiento');
        $this->mantenimiento->caracteristicas_ver($car_id, "facturacion/entradas/");
    }
    function caracteristicas_eliminar($car_id){
        satelite_validar();
        $this->load->library('../controllers/inventario/mantenimiento');
        $this->mantenimiento->caracteristicas_eliminar($car_id, "facturacion/entradas/");
    }
    function caracteristicas_editar($car_id){
        satelite_validar();
        $this->load->library('../controllers/inventario/mantenimiento');
        $this->mantenimiento->caracteristicas_editar($car_id, "facturacion/entradas/");
    }
    function caracteristicas_agregar(){
        satelite_validar();
        $this->load->library('../controllers/inventario/mantenimiento');
        $this->mantenimiento->caracteristicas_agregar("facturacion/entradas/");
    }
    
    function giro_comercial(){
        satelite_validar();
        $this->load->library('../controllers/cotizaciones/mantenimientos');
        $this->mantenimientos->giro_comercial();
    }

    function unidad_medidas(){
        satelite_validar();
        $this->load->library('../controllers/inventario/mantenimiento');
        $this->mantenimiento->medida_producto();
    }

    function marcas(){
        satelite_validar();
        $this->load->library('../controllers/inventario/mantenimiento');
        $this->mantenimiento->marca_producto('inventario');
    }

    function vendedores()
    {
        satelite_validar();

        $this->load->library('../controllers/cotizaciones/mantenimientos');
        $this->mantenimientos->vendedores('facturacion');
    }

    function retenciones()
    {
        satelite_validar();

        $this->load->library('../controllers/modulo_compras/catalogos');
        $this->catalogos->retenciones('retenciones');
    }
    function agregar_retencion()
    {
        satelite_validar();
        $this->load->library('../controllers/modulo_compras/catalogos');
        $info = $this->catalogos->agregar_retencion(true);
        $data['html'] = $this->load->view('modulo_compras/catalogos/agregar_retencion', $info, true);
        $this->_cargarvista(null, $data);
    }
    function editar_retencion($id)
    {
        satelite_validar();
        $this->load->library('../controllers/modulo_compras/catalogos');
        $info = $this->catalogos->editar_retencion($id, true);
        $data['html'] = $this->load->view('modulo_compras/catalogos/editar_retencion', $info, true);
        $this->_cargarvista(null, $data);
    }

    function ver_retencion($id)
    {
        satelite_validar();
        $this->load->library('../controllers/modulo_compras/catalogos');
        $info = $this->catalogos->ver_retencion($id, true);
        $data['html'] = $this->load->view('modulo_compras/catalogos/ver_retencion', $info, true);
        $this->_cargarvista(null, $data);
    }

    function supervisores()
    {
        satelite_validar();

        $this->load->library('../controllers/cotizaciones/mantenimientos');
        $this->mantenimientos->supervisores('facturacion');
    }

    function ingresar_vendedores()
    {
        satelite_validar();
        $this->load->library('../controllers/cotizaciones/mantenimientos');
        $info = $this->mantenimientos->ingresar_vendedores(true, 'facturacion/entradas/ingresar_vendedores');
        // $data['html'] = $this->load->view('cotizaciones/mantenimientos/ingresar_vendedores', $info, true);
        // $this->_cargarvista(null, $data);
    }

    function ingresar_supervisores()
    {
        satelite_validar();
        $this->load->library('../controllers/cotizaciones/mantenimientos');
        $info = $this->mantenimientos->ingresar_supervisores(true);
        $data['html'] = $this->load->view('cotizaciones/mantenimientos/ingresar_supervisores', $info, true);
        $this->_cargarvista(null, $data);
    }

    function editar_vendedores($id_vendedor)
    {
        satelite_validar();
        $this->load->library('../controllers/cotizaciones/mantenimientos');
        $info = $this->mantenimientos->editar_vendedores($id_vendedor, 'facturacion/entradas/editar_vendedores');
        // $data['html'] = $this->load->view('cotizaciones/mantenimientos/editar_vendedores', $info, true);
        // $this->_cargarvista(null, $data);
    }

    function editar_supervisores($id_supervisor)
    {
        satelite_validar();
        $this->load->library('../controllers/cotizaciones/mantenimientos');
        $info = $this->mantenimientos->editar_supervisores($id_supervisor, true);
        $data['html'] = $this->load->view('cotizaciones/mantenimientos/editar_supervisores', $info, true);
        $this->_cargarvista(null, $data);
    }

    function clientes()
    {
        satelite_validar();
        $this->load->library('../controllers/cotizaciones/mantenimientos');
        $this->mantenimientos->clientes('no', 'facturacion');
    }

    function nuevo_cliente($frommodal = null){
        satelite_validar();
        $this->load->library('../controllers/cotizaciones/mantenimientos');
        $info = $this->mantenimientos->nuevo_cliente(null, null, true);
        $info['from_fact'] = 1;
        
        $referers = array('crear_factura', 'agregar_alumno', 'editar_alumno');
        $cumple_http_referer = false;
        
        foreach ($referers as $referer) {
            if (substr_count($_SERVER['HTTP_REFERER'], $referer)) {
                $cumple_http_referer = true;
                break;
            }
        }

        if ($cumple_http_referer || $frommodal != null) {
            $info['esmodal'] = 2;
        }
        $data['html'] = $this->load->view('cotizaciones/mantenimientos/nuevo_cliente', $info, true);
        //Si se llama desde la vista crear factura se carga un iframe (Added on 22/7/19 by Raul E.)
        if ($cumple_http_referer || $frommodal != null) {
            $this->gsatelite->cargar_vista_masterpage('cotizaciones/mantenimientos/nuevo_cliente', $data);
        } else {
            $this->_cargarvista(null, $data);
        }
    }

    function editar_cliente($id_cliente){
        satelite_validar();
        $this->load->library('../controllers/cotizaciones/mantenimientos');
        $info = $this->mantenimientos->editar_cliente($id_cliente, null, true);
        $data['html'] = $this->load->view('cotizaciones/mantenimientos/editar_cliente', $info, true);
        $this->_cargarvista(null, $data);
    }

    /**
     * mantenimiento de codigo arancelarios
     * se tomara para caso de ALFAGEOMATIC que quieren colocar la cuenta contable en el item de la factura al momento de impresion, a nivel informativo, y no poseen modulo de conta. 
     * se usara la pantalla de codigo arancelario para colocar la cuenta contable por lo que el mantenimiento no tendra la misma estructura (no usareemos porcentaaje)
    */
    function cod_arancel() {
        satelite_validar();
        try {            
            $permisos = $this->gsatelite->get_permisos_opcion();
            $crud = new grocery_CRUD();
            $crud->set_subject('');
            $crud->set_table('cda_codigo_arancelario');
            $crud->required_fields('cda_codigo. cda_estado');
            $crud->columns('cda_codigo', 'cda_descripcion', 'cda_estado');
            $crud->display_as('cda_codigo', 'Código');
            $crud->display_as('cda_descripcion', 'Nombre');
            $crud->display_as('cda_estado', 'Estado');
            $crud->add_fields('cda_codigo', 'cda_descripcion', 'cda_estado', 'cda_usu_modificacion', 'cda_fecha_modificacion', 'cda_usu_creacion', 'cda_fecha_creacion');
            $crud->edit_fields('cda_codigo', 'cda_descripcion', 'cda_estado', 'cda_usu_modificacion', 'cda_fecha_modificacion');
            $crud->set_rules('cda_codigo', 'código', 'trim|required|campo_unico[cda_codigo_arancelario.cda_codigo]');
            $crud->field_type('cda_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('cda_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('cda_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('cda_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
            $urlx = explode('/', uri_string());
            if (end($urlx) == 'add') {
                $crud->field_type('cda_estado', 'hidden', 1);
            } else {
                $crud->field_type('cda_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }
            if (!$permisos["permite_editar"]) {
                $crud->unset_edit();
            }
            if (!$permisos["permite_eliminar"]) {
                $crud->unset_delete();
            }
            if (!$permisos["permite_agregar"]) {
                $crud->unset_add();
            }
            if (!$permisos["permite_ver"]) {
                $crud->unset_read();
            }
            $output = $crud->render();
            $data['titulo_personal'] = "Código Servicios";
            $this->_cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }


    /**
     * @author René Castaneda
     * @return Mantenimiento tipo factura
     */
    function tipo_factura()
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            try {

                $crud = new grocery_CRUD();
                // Variable para Permisos. Agregado por Luis Navarro
                $permisos = $this->gsatelite->get_permisos_opcion();

                $columns = array(
                    'tif_nombre',
                    'tif_abreviacion',
                    'tif_aplica_nrc',
                    'tif_tipo',
                    'tif_estado'
                );

                $fields = array(
                    'tif_nombre',
                    'tif_abreviacion',
                    'tif_tipo',
                    'tif_estado',
                    'tif_defecto',
                    'tif_edit_correlativo',
                    'tif_aplica_nrc',
                    'tif_aplica_venta',
                    'tif_aplica_anulacion',
                    'tif_usu_mod',
                    'tif_fecha_mod',
                    'tif_usu_crea',
                    'tif_fecha_crea',
                    'tif_codigo_hacienda',
                    'tif_aplica_nota_credito',
                    'tif_aplica_nota_debito',
                    'tif_aplica_aplica_auditoria'
                );

                $display_as = array(
                    'tif_nombre'        => 'Nombre',
                    'tif_abreviacion'   => 'Abreviación',
                    'tif_tipo'          => 'Tipo',
                    'tif_estado'        => 'Estado',
                    'tif_defecto'       => 'Factura por Defecto',
                    'tif_edit_correlativo' => 'Editar correlativos',
                    'tif_aplica_nrc'    => 'Aplica NRC',
                    'tif_aplica_venta' => 'Aplica Venta',
                    'tif_aplica_anulacion'    => 'Aplica Anular',
                    'tif_codigo_hacienda' => 'Código Hacienda',
                        'tif_aplica_nota_credito' => 'Aplica Nota Crédito',
                        'tif_aplica_nota_debito' => 'Aplica Nota Débito',
                        'tif_aplica_aplica_auditoria' => 'Aplica Auditoría'
                );

                $required = array(
                    'tif_nombre',
                    'tif_abreviacion',
                    'tif_tipo',
                    'tif_estado'
                );

                $crud->set_table('tif_tipo_factura')
                    ->set_subject('Tipo Factura')
                    ->columns($columns)
                    ->fields($fields)
                    ->display_as($display_as)
                    ->required_fields($required)
                    ->callback_add_field('tif_defecto', function () {
                        return '<input type="checkbox" id="chbdefecto" class="nostyle"><input type="hidden" id="field-tif_defecto" name="tif_defecto" value="0">';
                    })
                    ->callback_edit_field('tif_defecto', function ($value, $primary_key) {
                        $leer    = ($this->uri->rsegments[3] == 'read') ? 'iButton' : '';
                        $defecto = ($value) ? 'checked' : ''; // Verificar si esta activo
                        return '<input type="checkbox" id="chbdefecto" ' . $defecto . ' class="' . $leer . ' nostyle"><input type="hidden" id="field-tif_defecto" name="tif_defecto" value="' . $value . '">';
                    })

                    ->callback_add_field('tif_edit_correlativo', function () {
                        return '<input type="checkbox" id="chbedit" class="nostyle"><input type="hidden" id="field-tif_edit_correlativo" name="tif_edit_correlativo" value="0">';
                    })
                    ->callback_edit_field('tif_edit_correlativo', function ($value, $primary_key) {
                        $leer    = ($this->uri->rsegments[3] == 'read') ? 'iButton' : '';
                        $defecto = ($value) ? 'checked' : ''; // Verificar si esta activo
                        return '<input type="checkbox" id="chbedit" ' . $defecto . ' class="' . $leer . ' nostyle"><input type="hidden" id="field-tif_edit_correlativo" name="tif_edit_correlativo" value="' . $value . '">';
                    })
                    ->callback_add_field('tif_aplica_nrc', function () {
                        return '<input type="checkbox" id="chaplicanrc" class="nostyle"><input type="hidden" id="field-tif_aplica_nrc" name="tif_aplica_nrc" value="0">';
                    })                    
                    ->callback_edit_field('tif_aplica_nrc', function ($value, $primary_key) {
                        $leer    = ($this->uri->rsegments[3] == 'read') ? 'iButton' : '';
                        $defecto = ($value) ? 'checked' : ''; // Verificar si esta activo
                        return '<input type="checkbox" id="chaplicanrc" ' . $defecto . ' class="' . $leer . ' nostyle"><input type="hidden" id="field-tif_aplica_nrc" name="tif_aplica_nrc" value="' . $value . '">';
                    })

                    ->callback_add_field('tif_aplica_venta', function () {
                        return '<input type="checkbox" id="chaplicavent" class="nostyle"><input type="hidden" id="field-tif_aplica_venta" name="tif_aplica_venta" value="0">';
                    })                    
                    ->callback_edit_field('tif_aplica_venta', function ($value, $primary_key) {
                        $leer    = ($this->uri->rsegments[3] == 'read') ? 'iButton' : '';
                        $defecto = ($value) ? 'checked' : ''; // Verificar si esta activo
                        return '<input type="checkbox" id="chaplicavent" ' . $defecto . ' class="' . $leer . ' nostyle"><input type="hidden" id="field-tif_aplica_venta" name="tif_aplica_venta" value="' . $value . '">';
                    })

                    ->callback_add_field('tif_aplica_anulacion', function () {
                        return '<input type="checkbox" id="tif_anular" class="nostyle"><input type="hidden" id="tif_aplica_anulacion" name="tif_aplica_anulacion" value="0">';
                    })
                    ->callback_edit_field('tif_aplica_anulacion', function ($value, $primary_key) {
                        $leer    = ($this->uri->rsegments[3] == 'read') ? 'iButton' : '';
                        $defecto = ($value) ? 'checked' : ''; // Verificar si esta activo
                        return '<input type="checkbox" id="tif_anular" ' . $defecto . ' class="' . $leer . ' nostyle"><input type="hidden" id="tif_aplica_anulacion" name="tif_aplica_anulacion" value="' . $value . '">';
                    })
                    ->callback_add_field('tif_aplica_nota_credito', function () {
                        return '<input type="checkbox" id="chaplicanotacredito" class="nostyle"><input type="hidden" id="field-tif_aplica_nota_credito" name="tif_aplica_nota_credito" value="0">';
                    })
                    ->callback_edit_field('tif_aplica_nota_credito', function ($value, $primary_key) {
                        $leer    = ($this->uri->rsegments[3] == 'read') ? 'iButton' : '';
                        $defecto = ($value) ? 'checked' : ''; // Verificar si esta activo
                        return '<input type="checkbox" id="chaplicanotacredito" ' . $defecto . ' class="' . $leer . ' nostyle"><input type="hidden" id="field-tif_aplica_nota_credito" name="tif_aplica_nota_credito" value="' . $value . '">';
                    })
                    ->callback_add_field('tif_aplica_nota_debito', function () {
                        return '<input type="checkbox" id="chaplicanotd" class="nostyle"><input type="hidden" id="field-tif_aplica_nota_debito" name="tif_aplica_nota_debito" value="0">';
                    })
                    ->callback_edit_field('tif_aplica_nota_debito', function ($value, $primary_key) {
                        $leer    = ($this->uri->rsegments[3] == 'read') ? 'iButton' : '';
                        $defecto = ($value) ? 'checked' : ''; // Verificar si esta activo
                        return '<input type="checkbox" id="chaplicanotd" ' . $defecto . ' class="' . $leer . ' nostyle"><input type="hidden" id="field-tif_aplica_nota_debito" name="tif_aplica_nota_debito" value="' . $value . '">';
                    })
                    ->callback_add_field('tif_aplica_aplica_auditoria', function () {
                        return '<input type="checkbox" id="chaplicaaudi" class="nostyle"><input type="hidden" id="field-tif_aplica_aplica_auditoria" name="tif_aplica_aplica_auditoria" value="0">';
                    })
                    ->callback_edit_field('tif_aplica_aplica_auditoria', function ($value, $primary_key) {
                        $leer    = ($this->uri->rsegments[3] == 'read') ? 'iButton' : '';
                        $defecto = ($value) ? 'checked' : ''; // Verificar si esta activo
                        return '<input type="checkbox" id="chaplicaaudi" ' . $defecto . ' class="' . $leer . ' nostyle"><input type="hidden" id="field-tif_aplica_aplica_auditoria" name="tif_aplica_aplica_auditoria" value="' . $value . '">';
                    })
                    ->set_rules('tif_nombre', 'Nombre', 'trim|required|campo_unico[tif_tipo_factura.tif_nombre]')
                    ->field_type('tif_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('tif_usu_crea', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('tif_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                    ->field_type('tif_fecha_crea', 'hidden', date('Y-m-d H:i:s'))
                    ->field_type('tif_tipo', 'dropdown', array('1' => 'Factura', '2' => 'Ticket'))
                    ->unset_delete();
                $urlx = explode('/', uri_string());
                if (end($urlx) == 'add') {
                    $crud->field_type('tif_estado', 'hidden', 1);
                } else {
                    $crud->field_type('tif_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
                }
                // Validar Permisos. Agregado por Luis Navarro
                if (!$permisos['permite_agregar']) {
                    $crud->unset_add();
                }
                if (!$permisos['permite_editar']) {
                    $crud->unset_edit();
                }

                $data['titulo_personal'] = "Tipos de factura";

                $output = $crud->render();
                $this->_cargarvista($data, $output);
            } catch (Exception $e) {
                show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
            }
        }
    }

    /**
     * @author René Castaneda
     * @return Mantenimiento imp_impuesto
     */
    /*function impuestos() {
        satelite_validar();

        $crud = new grocery_CRUD();
        // Variable para Permisos. Agregado por Luis Navarro
        $permisos = $this->gsatelite->get_permisos_opcion();
        $crud->set_table('imp_impuesto')
                ->set_subject('Impuestos')
                ->columns('imp_nombre', 'imp_porcentaje', 'imp_estado')
                ->fields('imp_nombre', 'imp_porcentaje', 'imp_defecto', 'imp_estado', 'imp_usu_mod', 'imp_fecha_mod')
                ->display_as('imp_nombre', 'Nombre')
                ->display_as('imp_porcentaje', 'Porcentaje')
                ->display_as('imp_estado', 'Estado')
                ->display_as('imp_defecto', 'Aplicar por Defecto')
                ->required_fields('imp_nombre', 'imp_porcentaje', 'imp_estado', 'imp_defecto')
                ->set_rules('imp_nombre', 'Nombre', 'trim|required|campo_unico[imp_impuesto.imp_nombre]')
                ->set_rules('imp_porcentaje', 'Porcentaje', 'trim|required|is_numeric')
                ->field_type('imp_defecto', 'dropdown', array('1' => 'Sí', '0' => 'No'))
                ->field_type('imp_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('imp_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                ->unset_delete()
                ->unset_edit()
                ->unset_add()
        ;
        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('imp_estado', 'hidden', 1);
        } else {
            $crud->field_type('imp_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

        // validar permisos. Agregado por Luis Navarro
        if ($permisos['permite_editar']) {
            $crud->add_action('Editar', 'icon16 icomoon-icon-pencil-5', 'facturacion/entradas/editar_impuesto');
        }
        // Enviar permisos a la vista para validar. Agregado por Luis Navarro
        $data['permisos'] = $permisos;
        $data['titulo_personal'] = "Impuestos";

        $output = $crud->render();
        $this->_cargarvista($data, $output);
    }*/

    function gestion_impuestos()
    {
        satelite_validar();
        $this->load->library('../controllers/cotizaciones/mantenimientos');
        $this->mantenimientos->gestion_impuestos('facturacion/entradas');
    }


    function agregar_impuesto()
    {
        satelite_validar();
        $this->load->library('../controllers/cotizaciones/mantenimientos');
        $this->mantenimientos->agregar_impuesto('facturacion/entradas');
    }
    /*public function agregar_impuesto() {
        $data['cuentas'] = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_estado' => 1));
        $data['titulo_personal'] = "Gestión de impuestos";
        $this->_cargarvista($data);
    }*/
    function guardar_impuesto()
    {
        satelite_validar();
        $this->load->library('../controllers/cotizaciones/mantenimientos');
        $this->mantenimientos->guardar_impuesto('facturacion/entradas');
    }

    function editar_impuesto($id_impuesto, $ruta = null)
    {
        satelite_validar();
        $this->load->library('../controllers/cotizaciones/mantenimientos');
        $this->mantenimientos->editar_impuesto($id_impuesto, 'facturacion/entradas');
    }

    function actualizar_impuesto($id_impuesto)
    {
        satelite_validar();
        $this->load->library('../controllers/cotizaciones/mantenimientos');
        $this->mantenimientos->actualizar_impuesto($id_impuesto);
    }
    /*public function guardar_impuesto() {
        satelite_validar();


        if ($_POST) {
            // die(var_dump($_POST));

            $imp_array = array(
                'imp_nombre' => $this->input->post('nombre'),
                'imp_defecto' => $this->input->post('apli_defect'),
                'imp_porcentaje' => $this->input->post('porcentaje'),
                'imp_estado' => 1,
                'imp_usu_mod' => $this->tank_auth->get_user_id(),
                'imp_fecha_mod' => date('Y-m-d h:i:s'),
            );
            //$this->db->insert('cxj_correlativoxcaja', $uxc_array);
            $respuesta = $this->db->insert('imp_impuesto', $imp_array);
            $impu_id = $this->db->insert_id();
            $cnt = $this->input->post('cuen_cont_cli');
            foreach ($cnt as $id) {
                $info = array(
                    'cxe_id_cnt' => $id,
                    'cxe_id_imp' => $impu_id,
                    'cxe_tipo' => 2,
                    'cxe_estado' => 1,
                    'cxe_usu_crea' => $this->tank_auth->get_user_id(),
                    'cxe_fecha_crea' => date('Y-m-d H:i:s'),
                    'cxe_usu_mod' => $this->tank_auth->get_user_id(),
                    'cxe_fecha_mod' => date('Y-m-d H:i:s'),
                );
                $this->gsatelite->ingresar('cxe_cuentaximpuesto', $info);
            }

            $cnt = $this->input->post('cuen_cont_cli_2');
            foreach ($cnt as $id2) {
                $info = array(
                    'cxe_id_cnt' => $id2,
                    'cxe_id_imp' => $impu_id,
                    'cxe_tipo' => 1,
                    'cxe_estado' => 1,
                    'cxe_usu_crea' => $this->tank_auth->get_user_id(),
                    'cxe_fecha_crea' => date('Y-m-d H:i:s'),
                    'cxe_usu_mod' => $this->tank_auth->get_user_id(),
                    'cxe_fecha_mod' => date('Y-m-d H:i:s'),
                );
                $this->gsatelite->ingresar('cxe_cuentaximpuesto', $info);
            }

            $rediret = $this->input->post('redirect');
            if ($respuesta > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Procesado", 'texto_alerta' => "Registro(s) ingresado(s) con éxito");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "Ocurrió un error al ingresar la información");
            }

            $this->session->set_flashdata($alerta);

            $dir = $this->input->post('direccion');
            if ($dir == 1) {
                redirect('facturacion/entradas/agregar_impuesto');
            } else if ($dir == 2) {
                redirect('facturacion/entradas/impuestos');
            }
        }
    }*/

    /*public function editar_impuesto($id_imp) {
        satelite_validar();
        //die(var_dump($_POST));
        if ($_POST) {

        } else {
            $data['id_impuesto'] = $id_imp;
            $data['impuestos'] = $this->gsatelite->get_tabla('imp_impuesto', array('imp_id' => $id_imp, 'imp_estado' => 1));
            $data['cuentas'] = $this->gsatelite->get_tabla('cxe_cuentaximpuesto', array('cxe_id_imp' => $id_imp, 'cxe_estado' => 1, 'cxe_tipo' => 2));
            $data['cuentas2'] = $this->gsatelite->get_tabla('cxe_cuentaximpuesto', array('cxe_id_imp' => $id_imp, 'cxe_estado' => 1, 'cxe_tipo' => 1));
            $data['cnt_cont'] = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_estado' => 1));
            $data['titulo_personal'] = "Gestión de impuestos";
            $this->_cargarvista($data, null);
        }
    }*/

    /*public function actualizar_impuesto() {
        $id_imp = $this->input->post('id_impuestos');
        $imp_array = array(
            'imp_nombre' => $this->input->post('nombre'),
            'imp_defecto' => $this->input->post('apli_defect'),
            'imp_porcentaje' => $this->input->post('porcentaje'),
            'imp_estado' => $this->input->post('estado'),
            'imp_usu_mod' => $this->tank_auth->get_user_id(),
            'imp_fecha_mod' => date('Y-m-d h:i:s'),
        );
        //$this->db->insert('cxj_correlativoxcaja', $uxc_array);
        $contrato_id = $this->gsatelite->actualizar_array('imp_impuesto', $imp_array, array('imp_id' => $id_imp));
        $this->gsatelite->borrado_general('cxe_cuentaximpuesto', array('cxe_id_imp' => $id_imp, 'cxe_tipo' => 2));
        $cnt = $this->input->post('cuen_cont_cli');
        foreach ($cnt as $id) {
            $info = array(
                'cxe_id_cnt' => $id,
                'cxe_id_imp' => $id_imp,
                'cxe_tipo' => 2,
                'cxe_estado' => 1,
                'cxe_usu_crea' => $this->tank_auth->get_user_id(),
                'cxe_fecha_crea' => date('Y-m-d H:i:s'),
                'cxe_usu_mod' => $this->tank_auth->get_user_id(),
                'cxe_fecha_mod' => date('Y-m-d H:i:s'),
            );
            $this->gsatelite->ingresar('cxe_cuentaximpuesto', $info);
        }

        $this->gsatelite->borrado_general('cxe_cuentaximpuesto', array('cxe_id_imp' => $id_imp, 'cxe_tipo' => 1));
        $cnt = $this->input->post('cuen_cont_cli_2');
        foreach ($cnt as $id2) {
            $info2 = array(
                'cxe_id_cnt' => $id2,
                'cxe_id_imp' => $id_imp,
                'cxe_tipo' => 1,
                'cxe_estado' => 1,
                'cxe_usu_crea' => $this->tank_auth->get_user_id(),
                'cxe_fecha_crea' => date('Y-m-d H:i:s'),
                'cxe_usu_mod' => $this->tank_auth->get_user_id(),
                'cxe_fecha_mod' => date('Y-m-d H:i:s'),
            );
            $this->gsatelite->ingresar('cxe_cuentaximpuesto', $info2);
        }

        $dir = $this->input->post('direccion');
        if ($dir == 1) {
            redirect('facturacion/entradas/editar_impuesto/' . $id_imp);
        } else if ($dir == 2) {
            redirect('facturacion/entradas/impuestos');
        }
    }*/

    function series(){
        satelite_validar();

        $display_as = array(
            'sef_nombre'            => 'Nombre',
            'sef_abrev'             => 'Abreviación  ',
            'sef_fecha_resolucion'  => 'Fecha de Resolución',
            'sef_estado'            => 'Estado',
            'sef_id_tif'            => 'Tipo de factura',
            'sef_resolucion'        => 'No de Resolución '
        );

        $columns = array(
            'sef_nombre',
            'sef_abrev',
            'sef_resolucion',
            'sef_fecha_resolucion',
            'sef_estado'
        );

        $fields = array(
            'sef_resolucion',
            'sef_id_tif',
            'sef_nombre',
            'sef_abrev',
            'sef_fecha_resolucion',
            'sef_estado',
            'sef_usu_crea',
            'sef_fecha_crea',
            'sef_usu_mod',
            'sef_fecha_mod'
        );

        $required = array(
            'sef_id_tif',
            'sef_nombre',
            'sef_abrev',
            'sef_resolucion',
            'sef_estado'
        );

        $crud = new grocery_CRUD();
        // Variable para Permisos. Agregado por Luis Navarro
        $permisos = $this->gsatelite->get_permisos_opcion();
        $crud->set_table('sef_serie_factura');
        $crud->set_subject('Series');
        $crud->columns($columns);
        $crud->fields($fields);
        $crud->display_as($display_as);
        $crud->required_fields($required);
        $crud->set_relation('sef_id_tif', 'tif_tipo_factura', 'tif_nombre');
        $crud->set_rules('sef_nombre', 'Nombre', 'trim|required|campo_unico[sef_serie_factura.sef_nombre]');
        $crud->set_rules('sef_abrev', 'Abreviación', 'trim|required|campo_unico[sef_serie_factura.sef_nombre]');
        $crud->set_rules('sef_resolucion', 'No de Resolución', 'trim|required');
        $crud->add_action('Gestionar', '', 'facturacion/entradas/correlativos', 'icomoon-icon-cog-2  tbutton');
        $crud->field_type('sef_usu_crea', 'hidden', $this->tank_auth->get_user_id());
        $crud->field_type('sef_fecha_crea', 'hidden', date('Y-m-d H:i:s'));
        $crud->field_type('sef_usu_mod', 'hidden', $this->tank_auth->get_user_id());
        $crud->field_type('sef_fecha_mod', 'hidden', date('Y-m-d H:i:s'));
        $crud->unset_delete();
        $crud->set_rules('sef_id_tif', 'Tipo de factura', 'trim|required|callback_series_facturadas');
        $crud->callback_column('sef_fecha_resolucion', function ($value, $row) {
            return formatear_fecha('d-m-Y', $value);
        });
        $crud->callback_before_insert(function ($post_array) {
            $resolucion = $post_array['sef_resolucion'];
            $nombre     = $post_array['sef_nombre'];

            $this->db->limit(1);
            $repetido   = $this->gsatelite->get_campo("sef_serie_factura", "sef_resolucion", array("sef_resolucion" => $resolucion, "sef_nombre" => $nombre));

            if ($resolucion == $repetido) {
                return FALSE;
            } else {
                return TRUE;
            }
        });

        $crud->callback_before_update(function ($post_array, $primary_key) {
            $resolucion = $post_array['sef_resolucion'];
            $nombre     = $post_array['sef_nombre'];
            $id         = $primary_key;

            $this->db->limit(1);
            $repetido   = $this->gsatelite->get_campo("sef_serie_factura", "sef_resolucion", array("sef_resolucion" => $resolucion, "sef_nombre" => $nombre, "sef_id !=" => $primary_key));

            if ($resolucion == $repetido) {
                return FALSE;
            } else {
                return TRUE;
            }
        });

        $urlx = explode('/', uri_string());
        if (end($urlx) == 'add') {
            $crud->field_type('sef_estado', 'hidden', 1);
        } else {
            $crud->field_type('sef_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }
        // Validar Permisos. Agregado por Luis Navarro
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }
        if (!$permisos['permite_editar']) {
            $crud->unset_edit();
        }
        if (!$permisos['permite_ver']) {
            $crud->unset_read();
        }
        $data['titulo_personal'] = "Series";
        $serie = (is_numeric(end($urlx))) ? end($urlx) : 0;

                             $this->db->join("cof_correlativo_factura", " cof_id = fac_id_cof");
        $verificar_factura = $this->gsatelite->count("fac_factura", array("cof_id_sef" => $serie));
        $data['verificar_factura']  = $verificar_factura;
        $data['serie']              = $serie;
        $output = $crud->render();
        $this->_cargarvista($data, $output);
    }

    function cargar_correlativo()
    {
        $id_serie = $this->input->post("serie_id");
        $correlativo = $this->gsatelite->get_dropdown('cof_correlativo_factura', '{cof_inicio} - {cof_fin}', '', array('cof_estado' => '1', 'cof_id_sef' => $id_serie), null, '', 'cof_id', true);
        $datos["series"] = str_replace('<option value="0">Seleccione</option>', '', $correlativo);
        echo $datos['series'];
    }

    function correlativos($id){
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data['title'] = "Rango";
            $data['titulo_personal'] = "Correlativos";
            $data['correlativo_tabla'] = $this->gsatelite->get_tabla('cof_correlativo_factura', array('cof_id_sef' => $id, 'cof_estado' => 1));
            $tif = $this->gsatelite->get_campo('sef_serie_factura', 'sef_id_tif', array('sef_id' => $id));
            $corr = $this->facturacion_model->verificar_correlativo($tif);
            $tipo_facturacion = $this->gsatelite->get_parametro_emp('SYS_TIPO_DE_FACTURACION', 2);
            $data['tipo_facturacion'] = $tipo_facturacion;
            if ($_POST) {
                if ($_POST['boton'] == 'ingreso') {
                    $info_tabla = array(
                        'cof_id_sef' => $id,
                        'cof_inicio' => (int) $_POST['inicioCorrelativo'],
                        'cof_fin' => (trim($_POST['finCorrelativo']) != "") ? (int) $_POST['finCorrelativo'] : -1,
                        'cof_estado' => 1,
                        'cof_usu_mod' => $this->tank_auth->get_user_id(),
                        'cof_fecha_mod' => date('Y-m-d H:i:s'),
                        'cof_usu_crea' => $this->tank_auth->get_user_id(),
                        'cof_fecha_crea' => date('Y-m-d H:i:s'),
                        'cof_masivo' => ($this->input->post('cof_masivo')) ? 1 : 0,
                        'cof_actual' => 0
                    );
                    $rango = array();
                    $aplica = true;
                    foreach ($data['correlativo_tabla'] as $key => $value) {
                        $rango[] = ($value['cof_inicio'] . ' ' . $value['cof_fin']);
                    }
                    if ($tipo_facturacion != 1) {
                        foreach ($rango as $key => $value) {
                            $valores = explode(' ', $value);
                            $inicio = $valores[0];
                            $fin = $valores[1];

                            if ($_POST['inicioCorrelativo'] >= $inicio && $_POST['inicioCorrelativo'] <= $fin) {
                                $aplica = false;
                                break;
                            } else
                            if ($_POST['inicioCorrelativo'] < $inicio && $_POST['finCorrelativo'] >= $inicio) {
                                $aplica = false;
                                break;
                            } else if ($_POST['inicioCorrelativo'] >= $_POST['finCorrelativo']) {
                                $aplica = false;
                                break;
                            }
                        }
                    } else {
                        if (count($data['correlativo_tabla']) > 0) {
                            $aplica = false;
                        }
                    }

                    if ($aplica) {
                        if ($this->input->post('cof_masivo')) {
                            $masivo = 1;
                        } else {
                            $masivo = 0;
                        } //Verifica si se seleccionó para facturación masiva

                        if ($masivo == 1 && count($corr) <= 0) {
                            $registro = $this->gsatelite->ingresar('cof_correlativo_factura', $info_tabla);
                        } else if ($masivo == 0 && count($corr) >= 0) {
                            $registro = $this->gsatelite->ingresar('cof_correlativo_factura', $info_tabla);
                        } else {
                            $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro no ingresado", 'texto_alerta' => "Ya existe un correlativo asignado a la facturación masiva");
                            $this->session->set_flashdata($alerta);
                            redirect('facturacion/entradas/correlativos/' . $id);
                        }

                        if ($registro > 0) {
                            $alerta = array('registro' => $registro, 'tipo_alerta' => 'success', 'titulo_alerta' => "Registro ingresado", 'texto_alerta' => "El registro se ha ingresado correctamente");
                        } else {
                            $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro no ingresado", 'texto_alerta' => "El registro no se pudo ingresar, verifique la información ingresada");
                        }
                        $this->session->set_flashdata($alerta);
                        redirect('facturacion/entradas/correlativos/' . $id);
                    } else {
                        //var_dump("DENEGADO"); die();
                        $texto = ($tipo_facturacion != 1)?"El registro no se pudo ingresar verifique la información ingresada ":"Solo un correlativo para facturación electrónica";
                        $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro no ingresado", 'texto_alerta' => $texto);
                        $this->session->set_flashdata($alerta);
                        redirect('facturacion/entradas/correlativos/' . $id);
                    }
                }
            }
            $this->_cargarvista($data);
        }
    }

    public function eliminar($id_sef, $id_cof, $inicio, $fin)
    {
        /* Obtener primero todos los correlativos utilizados en facturas para esa serie */
        $en_uso = $this->gsatelite->get_registro('cof_correlativo_factura', array('cof_id' => $id_cof, 'cof_estado' => 1));
        $borrar = true;

        // if(count($en_uso)>1){
        //     foreach ($en_uso as $key => $value) {
        //       if($value->cof_inicio >= $inicio && $value->cof_fin<=$fin){
        //         $alerta=array('tipo_alerta'=> 'error','titulo_alerta'=>"Registro no ingresado",'texto_alerta'=>"El registro está en uso");
        //         $borrar = false;
        //         break;
        //       }
        // }
        // } else
        //Preguntar si el registro ya ha sido utilizado en otras tablas.
        $pregunta_caja = $this->gsatelite->get_tabla('cxj_correlativoxcaja', array('cxj_id_cof' => $id_cof));
        $pregunta_factura = $this->gsatelite->get_tabla('fac_factura', array('fac_id_cof' => $id_cof));

        if (count($en_uso) == 1 or (count($pregunta_caja) > 0 or count($pregunta_factura) > 0)) {
            if ($en_uso->cof_actual > 0 or (count($pregunta_caja) > 0 or count($pregunta_factura) > 0)) {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro no Eliminado", 'texto_alerta' => "El registro está en uso");
                $borrar = false;
            }
        }

        //var_dump($borrar); die();
        if ($borrar) {
            $registro = $this->gsatelite->borrado_general('cof_correlativo_factura', array('cof_id' => $id_cof));
            if ($registro > 0) {
                $alerta = array('registro' => $registro, 'tipo_alerta' => 'success', 'titulo_alerta' => "Registro eliminado", 'texto_alerta' => "El registro se ha eliminado correctamente");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro no ingresado", 'texto_alerta' => "El registro no se pudo ingresar verifique la informacion ingresada");
            }
        }

        $this->session->set_flashdata($alerta);
        redirect('facturacion/entradas/correlativos/' . $id_sef);
    }

    function categorias()
    {
        satelite_validar();
        $modulo = 3;
        $this->load->library('../controllers/inventario/mantenimiento');
        $this->mantenimiento->tipo_articulo('facturacion/entradas');
    }

    public function agregar_pro_articulo()
    {
        $this->load->library('../controllers/inventario/mantenimiento');
        $html = $this->mantenimiento->agregar_pro_articulo('facturacion/entradas/agregar_pro_articulo', 'facturacion/entradas/categorias');
        $data['html'] = $html;
        $this->_cargarvista($data);

        // $data['padre'] = $this->gsatelite->get_tabla('tia_tipo_articulo', array('tia_estado' => 1));
        // $data['cuen_con'] = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_estado' => 1));
        // $data['caract'] = $this->gsatelite->get_tabla('car_caracteristica', array('car_estado' => 1));
        // $data['cuentas'] = $this->gsatelite->get_tabla('cco_cuenta_contable');
        // $data['titulo_personal'] = "Gestión de categoría";
        // $this->_cargarvista($data);
    }

    public function guardar_pro_articulo()
    {
        satelite_validar();


        if ($_POST) {
            // die(var_dump($_POST));
            $padre = $this->input->post('padre');
            if ($padre > 0) {
                $padre = $this->input->post('padre');
            } else {
                $padre = null;
            }
            $art_array = array(
                'tia_nombre' => $this->input->post('categoria'),
                'tia_id_cco' => ($this->input->post('cuenta') > 0) ? $this->input->post('cuenta') : null,
                'tia_estado' => 1,
                'tia_padre' => $padre,
                'tia_codigo' => $this->input->post('codigo'),
            );
            //$this->db->insert('cxj_correlativoxcaja', $uxc_array);
            $respuesta = $this->db->insert('tia_tipo_articulo', $art_array);
            $art_id = $this->db->insert_id();

            $cnt1 = $this->input->post('cuen_cont_cli');
            if (!empty($cnt1)) {
                foreach ($cnt1 as $id1) {
                    $info1 = array(
                        'cxa_id_tia' => $art_id,
                        'cxa_id_cnt' => $id1,
                        'cxa_tipo' => 1,
                        'cxa_estado' => 1,
                        'cxa_usu_crea' => $this->tank_auth->get_user_id(),
                        'cxa_fecha_crea' => date('Y-m-d H:i:s'),
                        'cxa_usu_mod' => $this->tank_auth->get_user_id(),
                        'cxa_fecha_mod' => date('Y-m-d H:i:s'),
                    );
                    $this->gsatelite->ingresar('cxa_cuentaxtipo_articulo', $info1);
                }
            }

            $cnt2 = $this->input->post('cuen_cont_cli_2');
            foreach ($cnt2 as $id2) {
                $info2 = array(
                    'cxa_id_tia' => $art_id,
                    'cxa_id_cnt' => $id2,
                    'cxa_tipo' => 2,
                    'cxa_estado' => 1,
                    'cxa_usu_crea' => $this->tank_auth->get_user_id(),
                    'cxa_fecha_crea' => date('Y-m-d H:i:s'),
                    'cxa_usu_mod' => $this->tank_auth->get_user_id(),
                    'cxa_fecha_mod' => date('Y-m-d H:i:s'),
                );
                $this->gsatelite->ingresar('cxa_cuentaxtipo_articulo', $info2);
            }

            $cnt3 = $this->input->post('cuen_cont_cli_3');
            foreach ($cnt3 as $id3) {
                $info3 = array(
                    'cxa_id_tia' => $art_id,
                    'cxa_id_cnt' => $id3,
                    'cxa_tipo' => 3,
                    'cxa_estado' => 1,
                    'cxa_usu_crea' => $this->tank_auth->get_user_id(),
                    'cxa_fecha_crea' => date('Y-m-d H:i:s'),
                    'cxa_usu_mod' => $this->tank_auth->get_user_id(),
                    'cxa_fecha_mod' => date('Y-m-d H:i:s'),
                );
                $this->gsatelite->ingresar('cxa_cuentaxtipo_articulo', $info3);
            }

            $cnt4 = $this->input->post('cuen_cont_cli_4');
            foreach ($cnt4 as $id4) {
                $info4 = array(
                    'cxa_id_tia' => $art_id,
                    'cxa_id_cnt' => $id4,
                    'cxa_tipo' => 4,
                    'cxa_estado' => 1,
                    'cxa_usu_crea' => $this->tank_auth->get_user_id(),
                    'cxa_fecha_crea' => date('Y-m-d H:i:s'),
                    'cxa_usu_mod' => $this->tank_auth->get_user_id(),
                    'cxa_fecha_mod' => date('Y-m-d H:i:s'),
                );
                $this->gsatelite->ingresar('cxa_cuentaxtipo_articulo', $info4);
            }


            $car = $this->input->post('caracteristicas');
            foreach ($car as $id_car) {
                $info_car = array(
                    'cxr_id_car' => $id_car,
                    'cxr_id_tia' => $art_id,
                    'cxr_estado' => 1,
                    'cxr_usu_mod' => $this->tank_auth->get_user_id(),
                    'cxr_fecha_mod' => date('Y-m-d H:i:s'),
                );
                $this->gsatelite->ingresar('cxr_caractxtipo_articulo', $info_car);
            }

            $rediret = $this->input->post('redirect');
            if ($respuesta > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Procesado", 'texto_alerta' => "Registro(s) ingresado(s) con éxito");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "Ocurrió un error al ingresar la información");
            }

            $this->session->set_flashdata($alerta);

            $dir = $this->input->post('direccion');
            if ($dir == 1) {
                redirect('facturacion/entradas/agregar_pro_articulo');
            } else if ($dir == 2) {
                redirect('facturacion/entradas/categorias');
            }
        }
    }

    public function validar_codigo()
    {
        $codigo = $this->input->post('codigo');
        $code = $this->input->post('code');
        $codigos = $this->gsatelite->get_tabla('tia_tipo_articulo');
        $resp = 0;
        if ($codigo == $code) {
            echo json_encode(array('resp' => $resp));
            die();
        }
        $codigo1 = strtolower($codigo);
        foreach ($codigos as $cod) {
            $codigo_base = strtolower($cod['tia_codigo']);
            if ($codigo_base == $codigo1) {
                $resp = 1;
                echo json_encode(array('resp' => $resp));
                die();
            }
        }
        echo json_encode(array('resp' => $resp));
    }

    public function editar_pro_articulo($id_tia)
    {
        satelite_validar();
        $this->load->library('../controllers/inventario/mantenimiento');
        $html = $this->mantenimiento->editar_pro_articulo($id_tia, 'facturacion/entradas/editar_pro_articulo', 'facturacion/entradas/categorias');
        $data['html'] = $html;
        $this->_cargarvista($data);
        // satelite_validar();
        // //
        // if ($_POST) {
        //     //die(var_dump($_POST));
        //     $art_id = $this->input->post('id_arti');
        //     $art_array = array(
        //         'tia_nombre' => $this->input->post('categoria'),
        //         'tia_id_cco' => ($this->input->post('cuenta') > 0) ? $this->input->post('cuenta') : null,
        //         'tia_estado' => ($this->input->post('estado') > 0) ? 1 : 0,
        //         'tia_padre' => ($this->input->post('padre') > 0) ? $this->input->post('padre') : null,
        //         'tia_codigo' => $this->input->post('codigo'),
        //     );
        //     //$this->db->insert('cxj_correlativoxcaja', $uxc_array);
        //     $respuesta = $this->gsatelite->actualizar_array('tia_tipo_articulo', $art_array, array('tia_id' => $art_id));

        //     $this->gsatelite->borrado_general('cxa_cuentaxtipo_articulo', array('cxa_id_tia' => $art_id, 'cxa_tipo' => 1));
        //     $cnt1 = $this->input->post('cuen_cont_cli');
        //     if (!empty($cnt1)) {
        //         foreach ($cnt1 as $id1) {
        //             $info1 = array(
        //                 'cxa_id_tia' => $art_id,
        //                 'cxa_id_cnt' => $id1,
        //                 'cxa_tipo' => 1,
        //                 'cxa_estado' => 1,
        //                 'cxa_usu_crea' => $this->tank_auth->get_user_id(),
        //                 'cxa_fecha_crea' => date('Y-m-d H:i:s'),
        //                 'cxa_usu_mod' => $this->tank_auth->get_user_id(),
        //                 'cxa_fecha_mod' => date('Y-m-d H:i:s'),
        //             );
        //             $this->gsatelite->ingresar('cxa_cuentaxtipo_articulo', $info1);
        //         }
        //     }


        //     $this->gsatelite->borrado_general('cxa_cuentaxtipo_articulo', array('cxa_id_tia' => $art_id, 'cxa_tipo' => 2));
        //     $cnt2 = $this->input->post('cuen_cont_cli_2');
        //     foreach ($cnt2 as $id2) {
        //         $info2 = array(
        //             'cxa_id_tia' => $art_id,
        //             'cxa_id_cnt' => $id2,
        //             'cxa_tipo' => 2,
        //             'cxa_estado' => 1,
        //             'cxa_usu_crea' => $this->tank_auth->get_user_id(),
        //             'cxa_fecha_crea' => date('Y-m-d H:i:s'),
        //             'cxa_usu_mod' => $this->tank_auth->get_user_id(),
        //             'cxa_fecha_mod' => date('Y-m-d H:i:s'),
        //         );
        //         $this->gsatelite->ingresar('cxa_cuentaxtipo_articulo', $info2);
        //     }

        //     $this->gsatelite->borrado_general('cxa_cuentaxtipo_articulo', array('cxa_id_tia' => $art_id, 'cxa_tipo' => 3));
        //     $cnt3 = $this->input->post('cuen_cont_cli_3');
        //     foreach ($cnt3 as $id3) {
        //         $info3 = array(
        //             'cxa_id_tia' => $art_id,
        //             'cxa_id_cnt' => $id3,
        //             'cxa_tipo' => 3,
        //             'cxa_estado' => 1,
        //             'cxa_usu_crea' => $this->tank_auth->get_user_id(),
        //             'cxa_fecha_crea' => date('Y-m-d H:i:s'),
        //             'cxa_usu_mod' => $this->tank_auth->get_user_id(),
        //             'cxa_fecha_mod' => date('Y-m-d H:i:s'),
        //         );
        //         $this->gsatelite->ingresar('cxa_cuentaxtipo_articulo', $info3);
        //     }

        //     $this->gsatelite->borrado_general('cxa_cuentaxtipo_articulo', array('cxa_id_tia' => $art_id, 'cxa_tipo' => 4));
        //     $cnt4 = $this->input->post('cuen_cont_cli_4');
        //     foreach ($cnt4 as $id4) {
        //         $info4 = array(
        //             'cxa_id_tia' => $art_id,
        //             'cxa_id_cnt' => $id4,
        //             'cxa_tipo' => 4,
        //             'cxa_estado' => 1,
        //             'cxa_usu_crea' => $this->tank_auth->get_user_id(),
        //             'cxa_fecha_crea' => date('Y-m-d H:i:s'),
        //             'cxa_usu_mod' => $this->tank_auth->get_user_id(),
        //             'cxa_fecha_mod' => date('Y-m-d H:i:s'),
        //         );
        //         $this->gsatelite->ingresar('cxa_cuentaxtipo_articulo', $info4);
        //     }

        //     $this->db->query("DELETE FROM cxo_caracxarticuloxcotizacion WHERE cxo_id_cxr IN (SELECT cxr_id FROM cxr_caractxtipo_articulo WHERE cxr_id_tia=$art_id)");
        //     $this->db->query("DELETE FROM cxu_caracxarticulo WHERE cxu_id_cxr IN (SELECT cxr_id FROM cxr_caractxtipo_articulo WHERE cxr_id_tia=$art_id)");
        //     $this->gsatelite->borrado_general('cxr_caractxtipo_articulo', array('cxr_id_tia' => $art_id));
        //     $car = $this->input->post('caracteristicas');
        //     foreach ($car as $id_car) {
        //         $info_car = array(
        //             'cxr_id_car' => $id_car,
        //             'cxr_id_tia' => $this->input->post('id_arti'),
        //             'cxr_estado' => 1,
        //             'cxr_usu_mod' => $this->tank_auth->get_user_id(),
        //             'cxr_fecha_mod' => date('Y-m-d H:i:s'),
        //         );
        //         $this->gsatelite->ingresar('cxr_caractxtipo_articulo', $info_car);
        //     }

        //     $rediret = $this->input->post('redirect');
        //     if ($respuesta > 0) {
        //         $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Procesado", 'texto_alerta' => "Registro(s) editado(s) con éxito");
        //     } else {
        //         $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "Ocurrió un error al editar la información");
        //     }

        //     $this->session->set_flashdata($alerta);

        //     $dir = $this->input->post('direccion');
        //     if ($dir == 1) {
        //         redirect('facturacion/entradas/editar_pro_articulo/' . $art_id);
        //     } else if ($dir == 2) {
        //         redirect('facturacion/entradas/categorias');
        //     }
        // } else {
        //     $data['id_art'] = $id_art;
        //     $data['articulo'] = $this->gsatelite->get_tabla('tia_tipo_articulo', array('tia_id' => $id_art));
        //     $data['padre'] = $this->gsatelite->get_tabla('tia_tipo_articulo', array('tia_estado' => 1));
        //     $data['cco_cuentas'] = $this->gsatelite->get_tabla('cco_cuenta_contable');
        //     $data['caracteristicas'] = $this->gsatelite->get_tabla('car_caracteristica', array('car_estado' => 1));
        //     $data['car_x_art'] = $this->gsatelite->get_tabla('cxr_caractxtipo_articulo', array('cxr_id_tia' => $id_art, 'cxr_estado' => 1));

        //     $data['cuentas'] = $this->gsatelite->get_tabla('cxa_cuentaxtipo_articulo', array('cxa_id_tia' => $id_art, 'cxa_tipo' => 1));
        //     $data['cuentas2'] = $this->gsatelite->get_tabla('cxa_cuentaxtipo_articulo', array('cxa_id_tia' => $id_art, 'cxa_tipo' => 2));
        //     $data['cuentas3'] = $this->gsatelite->get_tabla('cxa_cuentaxtipo_articulo', array('cxa_id_tia' => $id_art, 'cxa_tipo' => 3));
        //     $data['cuentas4'] = $this->gsatelite->get_tabla('cxa_cuentaxtipo_articulo', array('cxa_id_tia' => $id_art, 'cxa_tipo' => 4));

        //     $data['cnt_cont'] = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_estado' => 1));
        //     $data['titulo_personal'] = "Gestión de categoría";
        //     $this->_cargarvista($data, null);
        // }
    }

    function articulo()
    {
        satelite_validar();

        $this->load->library('../controllers/inventario/mantenimiento');
        $this->mantenimiento->articulo('Catálogo de producto', 'facturacion', null, 'facturacion/entradas');
    }

    function agregar_articulo()
    {
        satelite_validar();
        $this->load->library('../controllers/inventario/mantenimiento');
        $info = $this->mantenimiento->agregar_articulo(7, true, 'facturacion/entradas');
        //$data['html'] = $this->load->view('inventario/mantenimiento/agregar_articulo', $info, true);
        //$this->_cargarvista(null, $data);
    }

    function guardar_articulo()
    {
        satelite_validar();
        $this->load->library('../controllers/inventario/mantenimiento');
        $this->mantenimiento->guardar_articulo('facturacion/entradas');
    }

    function editar_articulo($id_art)
    {
        satelite_validar();
        $this->load->library('../controllers/inventario/mantenimiento');
        $info = $this->mantenimiento->editar_articulo($id_art, 7, 'facturacion/entradas');
        //$data['html'] = $this->load->view('inventario/mantenimiento/editar_articulo', $info, true);

        //$this->_cargarvista(null, $data);
    }



    function precios_articulo($id_art){
        satelite_validar();
        $this->gsatelite->verificar_registro_real('art_articulo', $id_art);
        $id_art = $this->uri->segment(4);
        $crud = new grocery_CRUD();
        // Filtro
        $where = null;
        $data['id_articulo'] = ($id_art > 0) ? $id_art : 0;
        // Verificar si vienen datos por POST
        if ($this->input->post()) {
            $tipo = $this->input->post('slcTipo');
            if ($tipo > 0) {
                $where['tlp_id'] = $tipo;
            }
        }
        // Verificar si se ha definido
        if (isset($where)) {
            $crud->where($where);
        }

        $add_fields = array(
            'lip_id_art',
            'lip_id_tlp',
            'lip_desde',
            'lip_hasta',
            'lip_descuento_min',
            'lip_descuento_max',
            'lip_precio',
            'lip_id_mep',
            'lip_ultimo_prec_compra',
            'lip_variacion_utilidad',
            'lip_estado',
            'lip_usu_creacion',
            'lip_fecha_creacion',
            'lip_usu_modificacion',
            'lip_fecha_modificacion'
        );

        $edit_fields = array(
            'lip_id_art',
            'lip_id_tlp',
            'lip_desde',
            'lip_hasta',
            'lip_descuento_min',
            'lip_descuento_max',
            'lip_precio',
            'lip_id_mep',
            'lip_ultimo_prec_compra',
            'lip_variacion_utilidad',
            'lip_estado',
            'lip_usu_modificacion',
            'lip_fecha_modificacion'
        );

        $colum_fields =  array(
            'lip_id_tlp',
            'lip_desde',
            'lip_hasta',
            'lip_id_mep',
            'lip_descuento_min',
            'lip_descuento_max',
            'lip_precio',
            'lip_estado'
        );

        $required = array(
            'lip_id_tlp',
            'lip_id_art',
            'lip_desde',
            'lip_hasta',
            'lip_precio',
            'lip_estado',
            'lip_id_mep',
            'lip_descuento_min',
            'lip_descuento_max'
        );

        $display_as = array(
            'lip_desde'         => 'Cantidad Desde',
            'lip_hasta'         => 'Cantidad Hasta',
            'lip_descuento_min' => 'Porcentaje Minimo',
            'lip_descuento_max' => 'Porcentaje Maximo',
            'lip_precio'        => 'Precio',
            'lip_ultimo_prec_compra' => 'Precio última compra',
            'lip_variacion_utilidad' => '% Variación utilidad',
            'lip_estado'        => 'Estado',
            'lip_id_mep'        => 'Unidad medida',
            'lip_id_tlp'        => 'Tipo de lista'
        );

        $crud->set_table('lip_listado_precio')
            ->set_subject('Precio Producto')
            ->where('lip_id_art', $id_art)
            ->columns($colum_fields)
            ->add_fields($add_fields)
            ->edit_fields($edit_fields)
            ->display_as($display_as)
            ->set_relation('lip_id_tlp', 'tlp_tipo_lista_precio', '{tlp_nombre}', array('tlp_estado' => 1))
            ->required_fields($required)
            ->set_rules('lip_desde', 'Cantidad Desde', 'trim|is_numeric|required|callback_validacion_rango|callback_validar_cant_desde_hasta_lista')
            ->set_rules('lip_hasta', 'Cantidad Hasta', 'trim|required|is_numeric')
            ->set_rules('lip_venta_minima', 'Minimo de Venta', 'trim|is_numeric')
            ->set_rules('lip_descuento_min', 'Porcentaje Minimo', 'trim|required|is_numeric')
            ->set_rules('lip_descuento_max', 'Porcentaje Maximo', 'trim|required|is_numeric')
            ->set_rules('lip_precio', 'Precio', 'trim|required|is_numeric')
            ->field_type('lip_id_art', 'hidden', $id_art)
            ->field_type('lip_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
            ->field_type('lip_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
            // ->unset_delete()
        ;
        $crud->callback_edit_field('lip_id_mep', array($this, 'edit_lip_id_mep_for_article'));
        $crud->callback_add_field('lip_id_mep', array($this, 'edit_lip_id_mep_for_article'));

        //$crud->set_relation('lip_id_mep', 'mep_medida_producto', '{mep_codigo} - {mep_nombre}', array('mep_estado' => '1'));
        $urlx = explode('/', uri_string());
        if (end($urlx) == 'add') {
            $crud->set_relation('lip_id_mep', 'mep_medida_producto', '{mep_nombre}', array('mep_estado' => '1'));
            $crud->field_type('lip_estado', 'hidden', 1);
            $crud->field_type('lip_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('lip_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
        } else {  // Editar
            $crud->set_relation('lip_id_mep', 'mep_medida_producto', '{mep_nombre}', array('mep_estado' => '1'));
            $crud->field_type('lip_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }
        $name_articulo = $this->gsatelite->get_tabla('art_articulo', array('art_id' => $id_art));

        $data['titulo_personal'] = "Listado de Precios";
        $data['registro_art'] = $this->gsatelite->get_registro('art_articulo', 'art_id', $id_art);

        // Enviar url
        $data['url'] = $urlx;
        // Datos para filtro de tipo de lista
        $tipo_lista = $this->gsatelite->get_dropdown('tlp_tipo_lista_precio', '{tlp_nombre}', '', array('tlp_estado' => '1'), null, '', 'tlp_id', true);
        $data["tipo_lista"] = str_replace('<option value="0">Seleccione</option>', '', $tipo_lista);

        $output = $crud->render();
        $this->_cargarvista($data, $output);
    }

    function validar_cant_desde_hasta_lista()
    {
        $this->load->library('form_validation');
        $id_articulo = $this->uri->segment(4);
        $id = $this->uri->segment(6) != "" ? $this->uri->segment(6) : 0;
        $c_desde = $this->input->post('lip_desde');
        $c_hasta = $this->input->post('lip_hasta');
        $id_tlp = ($this->input->post('lip_id_tlp') > 0) ? $this->input->post('lip_id_tlp') : 0;
        $id_mep = $this->input->post('lip_id_mep');

        $valido = true;
        $where =
            "lip_id != " . $id . "
         AND lip_id_mep = " . $id_mep . "
         AND lip_id_art = " . $id_articulo . "
         AND lip_id_tlp = " . $id_tlp . "
         AND (
            (
                " . $c_desde . " BETWEEN lip_desde AND lip_hasta
            )
            OR (
                " . $c_hasta . " BETWEEN lip_desde AND lip_hasta
            )
        )
        ";
        // $where= "lip_id_art = $id_articulo AND lip_id_tlp = $id_tlp
        // AND ((". str_replace('0','',$c_desde) ." BETWEEN lip_desde AND lip_hasta)
        // OR (". str_replace('0','',$c_hasta) ." BETWEEN lip_desde AND lip_hasta))";
        /*
        SELECT * FROM lip_listado_precio
        WHERE lip_id <> 153 AND lip_id_art = 836 AND lip_id_tlp = 5
        AND (
            ( 1 BETWEEN lip_desde AND lip_hasta)
            OR ( 11 BETWEEN lip_desde AND lip_hasta)
        );
        */

        $query = $this->facturacion_model->comprobar_cantidad_desde_hasta_por_lista($where);

        if (count($query) == 0) {
            return true;
        } else {
            $this->form_validation->set_message('validar_cant_desde_hasta_lista', 'La cantidad desde y hasta ya estan registradas en este tipo de lista.');
            return false;
        }
    }

    public function get_meps_prod(){
        $id_art = $this->input->post('id_articulo');
        $id_tlp = $this->input->post('id_tipo_lis');
        $ya_exist = $this->gsatelite->get_tabla('lip_listado_precio', array('lip_id_art' => $id_art, 'lip_id_tlp' => $id_tlp));
        $select = '<option></option>';
        if (!(count($ya_exist) > 0)) {
            $cva_ids = $this->gsatelite->get_tabla('cva_conversion_articulo', array('cva_id_art' => $id_art, 'cva_estado' => 1));
            foreach ($cva_ids as $key => $value) {
                $select .= $this->gsatelite->get_dropdown('mep_medida_producto', '{mep_nombre}', '', array('mep_estado' => 1, 'mep_id' => (int)$value["cva_id_mep"]), null, '', 'mep_id', true);
            }
        }
        $select = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
        echo json_encode(array('cuantas' => count($ya_exist), 'lista' => $select));
    }

    function edit_lip_id_mep_for_article($value, $primary_key)
    {
        $id_art = $this->uri->segment(4);

        $ids = $this->gsatelite->get_tabla('cva_conversion_articulo', array('cva_id_art' => $id_art, 'cva_estado' => 1));
        $array_days = array();
        $um_ligada_articulo = '';
        for ($i = 0; $i < count($ids); $i++) {
            array_push($array_days, $ids[$i]["cva_id_mep"]);
            $um_ligada_articulo .= $this->gsatelite->get_dropdown('mep_medida_producto', '{mep_nombre}', '', array('mep_estado' => '1', 'mep_id' => (int) $ids[$i]["cva_id_mep"]), null, '', 'mep_id', true);
            $um_ligada_articulo = str_replace('<option value="0">Seleccione</option>', '', $um_ligada_articulo);
        }

        $js = '<script>$(\'select[name="lip_id_mep"] option[value="' . $value . '"]\').attr("selected", "selected");</script>';
        return '<select id="field-lip_id_mep" name="lip_id_mep" class="nostyle chosen-select" data-placeholder=" Unidad" style="width: 100%; display: none;">'
            . $um_ligada_articulo .
            '</select>' . $js;
        //'+30 <input type="text" maxlength="50" value="'.$value.'" name="phone" style="width:462px">';
    }

    function mantenimiento_caja(){
        satelite_validar();
        $columns = array(
            'caj_nombre',
            'caj_estimado_facturacion',
            'caj_estado'
        );
        $display_as = array(
            'caj_nombre' => 'Nombre',
            'caj_estimado_facturacion' => 'Meta mensual',
            'caj_estado' => 'Estado'
        );
        $required = array(
            'caj_nombre',
            'caj_estado'
        );
        $add_columns = array(
            'caj_nombre',
            'caj_estimado_facturacion',
            'caj_estado',
            'caj_fecha_crea',
            'caj_usu_crea',
            'caj_fecha_mod',
            'caj_usu_mod'
        );
        $edit_columns = array(
            'caj_nombre',
            'caj_estimado_facturacion',
            'caj_estado',
            'caj_fecha_mod',
            'caj_usu_mod'
        );
        $crud = new grocery_CRUD();
        // Variable para permisos. Agregado por Luis Navarro
        $permisos = $this->gsatelite->get_permisos_opcion();
        $crud->set_table('caj_caja')
            ->set_subject('Cajas')
            ->columns($columns)
            ->add_fields($add_columns)
            ->edit_fields($edit_columns)
            // ->fields('caj_nombre', 'caj_estimado_facturacion','caj_estado', 'caj_usu_mod', 'caj_fecha_mod', 'caj_fecha_crea', 'caj_usu_crea')
            ->display_as($display_as)
            ->required_fields($required)
            ->set_rules('caj_nombre', 'Nombre', 'trim|required|campo_unico[caj_caja.caj_nombre]')
            ->set_rules('caj_estimado_facturacion', 'Meta mensual', 'trim|is_numeric')
            //personal/catalogos/ing_des_pla','ui-icon-plus tbutton')
            // ->field_type('imp_defecto','dropdown',array('1' => 'Sí', '0' => 'No'))
            ->field_type('caj_usu_mod', 'hidden', $this->tank_auth->get_user_id())
            ->field_type('caj_usu_crea', 'hidden', $this->tank_auth->get_user_id())
            ->field_type('caj_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
            ->field_type('caj_fecha_crea', 'hidden', date('Y-m-d H:i:s'))
            ->unset_delete();
        $crud->unset_edit();
        $tipo_facturacion = $this->gsatelite->get_parametro_emp('SYS_TIPO_DE_FACTURACION', 2);
        if ($tipo_facturacion != 1) {
            $crud->add_action('Asignar correlativo', '', 'facturacion/entradas/asignacion_correlativo', 'icomoon-icon-file');
        }
        $urlx = explode('/', uri_string());
        if (end($urlx) == 'add') {
            $crud->field_type('caj_estado', 'hidden', 1);
        } else {
            $crud->field_type('caj_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }
        // Validar Permisos. Agregado por Luis Navarro
        if ($permisos['permite_editar']) {
            $crud->add_action('Ver', 'icon16 minia-icon-search', 'facturacion/entradas/ver_caja');
        }

        if ($permisos['permite_editar']) {
            $crud->add_action('Editar', 'icon16 icomoon-icon-pencil-5', 'facturacion/entradas/editar_caja');
        }

        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }

        $data['titulo_personal'] = "Cajas";
        $output = $crud->render();
        $this->_cargarvista($data, $output);
    }

    function asignacion_correlativo($id){
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            //  $datosCliente = $this->cotModel->correlativo_caja();
            $data['id'] = $id;
            $data['registros'] = $this->facturacion_model->correlativo_caja($id);
            $data['titulo_personal'] = "Asignación correlativo";
            $data['tipo_facturacion'] = $this->gsatelite->get_parametro_emp('SYS_TIPO_DE_FACTURACION', 2);
            // var_dump($this->db->last_query());die();
            //$data['html']=$this->load->view('facturacion/entradas/asignacion_correlativo', $data , true);
            $this->_cargarvista(null, $data);
        }
    }

    public function agregar_correlativo($id) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            //  $datosCliente = $this->cotModel->correlativo_caja();
            $data['user'] = $this->tank_auth->get_user_id();
            $data['id'] = $id;
            $data['registros'] = $this->facturacion_model->obtener_series($id);
            $data['correlativo_tabla'] = $this->gsatelite->get_tabla('cof_correlativo_factura', array('cof_id_sef' => $id, 'cof_estado' => 1));
            $data['tipo_facturacion'] = $this->gsatelite->get_parametro_emp('SYS_TIPO_DE_FACTURACION', 2);
            $data['titulo_personal'] = "Asignacion correlativo";
            //$data['html']=$this->load->view('facturacion/entradas/asignacion_correlativo', $data , true);
            $this->_cargarvista($data);
        }
    }

    public function validar_cajaxusuario($id)
    {

        $caja = $this->input->post('caja');
        $serie = $this->input->post('serie');
        $user = $this->tank_auth->get_user_id();
        $cxj = $this->facturacion_model->validar_uxc();
        $uxc = $this->gsatelite->get_tabla('uxc_usuarioxcaja');
        foreach ($cxj as $cxc) {
            if ($serie == $cxc['cof_id'] && $caja == $cxc['cxj_id_caj']) {
                echo json_encode(array('resp' => 1));
                die();
            }
        }
        foreach ($uxc as $uxxc) {
            if ($user == $uxxc['uxc_id_usu'] && $caja == $uxxc['uxc_id_caj']) {
                echo json_encode(array('resp' => 2));
                die();
            }
        }
        $this->_cargarvista($data);
    }

    public function validar_serie() {
        $inicio = $this->input->post('inicio'); // Inicio de Corr General
        $fin    = $this->input->post('fin');    // Fin de Corr General
        $serie  = $this->input->post('serie');
        $caja   = $this->input->post('caja');
        $cxj_id = $this->input->post('cxj');

        // Obtener todo los correlativo
                    $this->db->order_by('cxj_id', 'DESC');
        $cxj_todo = $this->gsatelite->get_tabla('cxj_correlativoxcaja', array('cxj_id_cof' => $serie)); //print_r($cxj_todo);die();

        if ($cxj_id > 0) {
            $serie_cxj = $this->gsatelite->get_tabla('cxj_correlativoxcaja', array('cxj_id_cof' => $serie, 'cxj_estado' => 1, 'cxj_id_caj' => $caja, 'cxj_id <> ' => $cxj_id));
        } else {
            $serie_cxj = $this->gsatelite->get_tabla('cxj_correlativoxcaja', array('cxj_id_cof' => $serie, 'cxj_estado' => 1, 'cxj_id_caj' => $caja));
        }

        if (count($cxj_todo) > 0) {
            // Recorrer las facturas
            // Consulta para obtener las facturas creadas por ese rango
            $numeros        = $this->facturacion_model->get_numeros_facturas(array('fac_numero >=' => $cxj_todo[0]['cxj_inicio'], 'fac_numero <=' => $cxj_todo[0]['cxj_fin'], 'fac_id_cof' => $cxj_todo[0]['cxj_id_cof'])); //print_r($numeros);die();

            // Procesar para obtener el ultimo indice
            $numero     = (int) ($cxj_todo[0]['cxj_inicio']);
            $cxj_inicio = (int) ($cxj_todo[0]['cxj_inicio']);
            $cxj_fin    = (int) ($cxj_todo[0]['cxj_fin']);
            if (count($numeros) > 0) {
                $numero = 0;
                $numero_factura = array();

                foreach ($numeros as $key) {
                    $numero_factura[] = $key['fac_numero'];
                }

                /* for ($x = $cxj_inicio; $x <= $cxj_fin; $x++) {
                    if (!in_array($x, $numero_factura)) {
                        $numero = $x;
                        break;
                    }
                } */
            }
        }

        $tipos_series   = $this->facturacion_model->validar_correlativos_cajas_($caja);
        $tipo_serie     = $this->facturacion_model->validar_tipo_serie_($serie);
        $resp1 = 0;
        $resp2 = 0;

        // Ya existe correlativos asignados a esta caja
        if (!empty($serie_cxj)) {
            $resp1 = 1;
            echo json_encode(array('resp1' => $resp1));
            die();
        } else {
            // echo json_encode(array('resp1'=>$resp1));
        }

        // Si ya se registro un tipo de factura
        foreach ($tipos_series as $tips) {
            if ($tipo_serie[0]['tif_id'] == $tips['tif_id']) {

                if ($numero != 0) {
                    $resp2 = 1;
                    echo json_encode(array('resp2' => $resp2));
                    die();
                }
                // Si se acabaron los correlativos
                if (isset($numero) && $numero == 0) {
                    $resp2 = 2;
                    echo json_encode(array('resp2' => $resp2, 'tipo_factura' => $tips['tif_nombre']));
                    die();
                }
            }
        }

        $correlativo = $this->gsatelite->get_dropdown('cxj_correlativoxcaja', '{cxj_inicio} - {cxj_fin}', '', array('cxj_id_cof' => $serie), null, '', 'cxj_id', true);
        echo json_encode(array('corre_usa' => $correlativo));
    }

    public function validar_correlativo(){
        $desde = $this->input->post('desde');
        $hasta = $this->input->post('hasta');
        $caja = $this->input->post('caja');
        $serie = $this->input->post('serie');
        $inicio = $this->input->post('inicio');
        $fin = $this->input->post('fin');

        $tipo_facturacion = $this->gsatelite->get_parametro_emp('SYS_TIPO_DE_FACTURACION', 2);

        $rangos = $this->gsatelite->get_tabla('cxj_correlativoxcaja', array('cxj_id_cof' => $serie));

        foreach ($rangos as $ran) {
            if ($desde > $ran['cxj_inicio'] && $hasta < $ran['cxj_fin']) { //Rango intermedio
                echo json_encode(array('resp' => 1));
                die();
            } elseif ($desde < $ran['cxj_inicio'] && $hasta > $ran['cxj_inicio']) { //Rango menor que inicio y menor que fin
                echo json_encode(array('resp' => 1));
                die();
            } elseif ($desde < $ran['cxj_fin'] && $hasta > $ran['cxj_fin']) { //Rango menor que fin y mayor a fin
                echo json_encode(array('resp' => 1));
                die();
            } elseif ($desde < $ran['cxj_inicio'] && $hasta > $ran['cxj_fin']) { //Rango dejando adentro cualquier serie
                echo json_encode(array('resp' => 1));
                die();
            } elseif ($desde > $hasta) {
                echo json_encode(array('resp' => 1));
                die();
            }
        }

        $rangos2 = $this->gsatelite->get_tabla('cof_correlativo_factura', array('cof_id' => $serie, 'cof_estado' => 1));    
        foreach ($rangos2 as $ran2) {
            if ($desde >= $ran2['cof_inicio'] && $hasta != "" && $hasta <= $ran2['cof_fin']) {
                echo json_encode(array('resp' => 0));
                die();
            } elseif ($desde <= $ran2['cof_inicio'] && $hasta != "" && $hasta >= $ran2['cof_inicio']) {
                echo json_encode(array('resp' => 1));
                die();
            } elseif ($desde <= $ran2['cof_fin']  && $hasta != "" && $hasta >= $ran2['cof_fin']) {
                echo json_encode(array('resp' => 1));
                die();
            } elseif ($desde <= $ran2['cof_inicio'] && $hasta != "" && $hasta >= $ran2['cof_fin']) {
                echo json_encode(array('resp' => 1));
                die();
            } elseif ($desde >= $ran2['cof_fin'] && $hasta != "" && $hasta >= $ran2['cof_fin']) {
                echo json_encode(array('resp' => 1));
                die();
            } elseif ($hasta != "" && $desde >= $hasta) {
                echo json_encode(array('resp' => 1));
                die();
            } elseif (trim($hasta) == "" && $tipo_facturacion == 1) {
               echo json_encode(array('resp' => 0));
               die();
            }
        }
    }

    public function guardar_correlativo($id = null){
        $id = $this->input->post('caja');
        $tipo_facturacion = $this->gsatelite->get_parametro_emp('SYS_TIPO_DE_FACTURACION', 2);
        $lim_hasta = ($tipo_facturacion != 1 || $this->input->post('hasta') > 0) ? $this->input->post('hasta') : -1;
        $nuevo = array(
            'cxj_id_caj' => $this->input->post('caja'),
            'cxj_id_cof' => $this->input->post('serie'),
            'cxj_inicio' => $this->input->post('desde'),
            'cxj_fin' => $lim_hasta,
            'cxj_fecha' => date('Y-m-d h:i:s'),
            'cxj_estado' => 1,
            'cxj_usu_mod' => $this->tank_auth->get_user_id(),
            'cxj_fecha_mod' => date('Y-m-d h:i:s'),
            'cxj_fecha_crea' => date('Y-m-d h:i:s'),
            'cxj_usu_crea' => $this->tank_auth->get_user_id()
        );

        $this->db->insert('cxj_correlativoxcaja', $nuevo);
        $rediret = $this->input->post('redirect');
        if ($rediret == 1) {
            $this->gsatelite->show_dialog("Se procesó correctamente", "facturacion/entradas/agregar_correlativo/$id", 'success', 'Atención');
        } else {
            $this->gsatelite->show_dialog("Se procesó correctamente", "facturacion/entradas/asignacion_correlativo/$id", 'success', 'Atención');
        }
    }

    public function eliminar_correlativo($id_caj, $id_cxj, $id_cof, $id_tif, $inicio, $fin)
    {
        $tipo = (trim($this->input->post('tipo')) != "") ? $this->input->post('tipo') : null;

        if ($tipo != null) {
            $id_cof = $this->input->post('correlativo');
            $id_tif = $this->input->post('tipo_factura');
            $inicio = $this->input->post('inicio');
            $fin = $this->input->post('fin');
        }

        $numeros = $this->facturacion_model->get_numeros_facturas(array('fac_numero >=' => $inicio, 'fac_numero <=' => $fin, 'fac_id_cof' => $id_cof, 'fac_id_tif' => $id_tif));
        $borrar = true;

        if (count($numeros) > 0) {
            $borrar = false;
        }

        if ($tipo != null) {
            echo json_encode(array('borrar' => $borrar));
        } else {
            if ($borrar) {
                $registro = $this->gsatelite->borrado_general('cxj_correlativoxcaja', array('cxj_id' => $id_cxj));
                $alerta = array('registro' => $registro, 'tipo_alerta' => 'success', 'titulo_alerta' => "Registro eliminado", 'texto_alerta' => "El registro se ha eliminado correctamente");
            }
            $this->session->set_flashdata($alerta);
            redirect('facturacion/entradas/asignacion_correlativo/' . $id_caj);
        }
    }

    public function editar_correlativo($id)
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            //  $datosCliente = $this->cotModel->correlativo_caja();
            $data['id2'] = $this->input->post('caja');
            $data['series'] = $this->facturacion_model->obtener_series();
            // print_r( $this->facturacion_model->obtener_series2($id2));
            // die();
            $data['id_correlativo'] = $id;
            $data['cxj_info'] = $this->gsatelite->get_tabla('cxj_correlativoxcaja', array('cxj_id' => $id));
            $data['registros'] = $this->facturacion_model->correlativos_caja($id);
            $data['correlativo_tabla'] = $this->gsatelite->get_tabla('cxj_correlativoxcaja', array('cxj_id' => $id, 'cxj_estado' => 1));
            $c = $data['registros'][0];
            $hay = $this->facturacion_model->get_numeros_facturas2(array('fac_numero >='=>$c['cxj_inicio'],'fac_numero <='=>$c['cxj_fin'],'fac_id_cof'=>$c['cof_id'],'fac_id_tif'=>$c['sef_id_tif']));
            $data['fac_disp'] = $c['cxj_fin'] - (count($hay) + $c['cxj_inicio'] - 1);
            // $data['correlativo_tabla'] = $this->gsatelite->get_tabla('cof_correlativo_factura', array('cof_id_sef' => $id, 'cof_estado' => 1));
            $data['titulo_personal'] = "Editar correlativo";
            //$data['html']=$this->load->view('facturacion/entradas/asignacion_correlativo', $data , true);
            $this->_cargarvista($data);
        }
    }

    public function guardar_correlativo_edit($id)
    {
        $caja = $this->input->post('cxj_id_caj');
        $cerrar_caja = $this->input->post('closeser');
        $nuevo_estado = ($this->input->post('slcestado') != "") ? trim($this->input->post('slcestado'), "'") : 1;
        $editado = array(
            'cxj_id_caj' => $caja,
            'cxj_id_cof' => $this->input->post('serie'),
            'cxj_inicio' => $this->input->post('desde'),
            'cxj_fin' => $this->input->post('hasta'),
            'cxj_fecha' => $this->input->post('cxj_fecha'),
            'cxj_estado' => ($cerrar_caja == 3) ? 0 : $nuevo_estado,
            'cxj_usu_mod' => $this->tank_auth->get_user_id(),
            'cxj_fecha_mod' => date('Y-m-d h:i:s'),
            // 'cxj_fecha_crea' => date('Y-m-d h:i:s'),
            // 'cxj_usu_crea' => $this->tank_auth->get_user_id()
        );

        //  $this->db->insert('cxj_correlativoxcaja', $nuevo);
        $this->gsatelite->actualizar_array('cxj_correlativoxcaja', $editado, array('cxj_id' => $id));
        $rediret = $this->input->post('redirect');
        if ($rediret == 1 && $cerrar_caja != 3) {
            redirect('facturacion/entradas/editar_correlativo/' . $id);
        } else {
            redirect('facturacion/entradas/asignacion_correlativo/' . $caja);
        }
    }

    /* Mantenimiento de tabla CFC del modulo CRM */
    function clasificacion_clientes() {
        satelite_validar();
        $this->load->library('../controllers/cotizaciones/mantenimientos');
        $this->mantenimientos->clasificacion_cliente();
    }


    function tipos_pago($ruta = null)
    {
        satelite_validar();
        $ruta = (trim($ruta) != '') ? $ruta : 'facturacion/entradas';
        $crud = new grocery_CRUD();
        // Variable para Permisos. Agregado por Luis Navarro
        $permisos = $this->gsatelite->get_permisos_opcion();
        $crud->set_table('tpg_tipo_pago')
            ->set_subject('Tipo de pago')
            ->columns('tpg_nombre', 'tpg_estado')
            ->display_as('tpg_nombre', 'Nombre')
            ->display_as('tpg_estado', 'Estado')
            ->required_fields('tpg_nombre', 'tpg_estado')
            ->set_rules('tpg_nombre', 'Nombre', 'trim|required|campo_unico[tpg_tipo_pago.tpg_nombre]')
            ->field_type('tpg_usu_mod', 'hidden', $this->tank_auth->get_user_id())
            ->field_type('tpg_usu_crea', 'hidden', $this->tank_auth->get_user_id())
            ->field_type('tpg_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
            ->field_type('tpg_fecha_crea', 'hidden', date('Y-m-d H:i:s'))
            ->unset_delete()->unset_edit();
        $crud->add_fields('tpg_nombre', 'tpg_estado', 'tpg_usu_crea', 'tpg_fecha_crea', 'tpg_usu_mod', 'tpg_fecha_mod');
        $crud->edit_fields('tpg_nombre', 'tpg_estado', 'tpg_usu_mod', 'tpg_fecha_mod');

        // Validar Permisos. Agregado por Luis Navarro
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }
        if ($permisos['permite_editar']) {
            $crud->add_action('Editar', '', "$ruta/editar_tipo_pago", ' icomoon-icon-pencil-5');
        }

        $urlx = explode('/', uri_string());
        if (end($urlx) == 'add') {
            $crud->field_type('tpg_estado', 'hidden', 1)
                //->field_type('tpg_fecha_crea', 'hidden', date('Y-m-d H:i:s'))
                //->field_type('tpg_usu_crea', 'hidden', $this->tank_auth->get_user_id())
            ;
        } else {
            //$crud->fields('tpg_nombre','tpg_estado','tpg_usu_mod','tpg_fecha_mod');
            $crud->field_type('tpg_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

        $data['titulo_personal'] = "Tipos de Pago";

        $output = $crud->render();

        //$this->_cargarvista($data, $output);
        $data['ruta'] = $ruta;
        cargarvista($data, $output, 'facturacion/entradas/tipos_pago');
    }

    public function agregar_tipo_pago($ruta = null) {
        satelite_validar();
        $output = (isset($output)) ? $output : null;
        $ruta   = (trim($ruta) != '') ? $ruta : 'facturacion/entradas';

        if ($this->input->post()) {
            if (trim($this->input->post('nombre')) == '') {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "El nombre es obligatorio");
                $this->session->set_flashdata($alerta);
                redirect($ruta . '/agregar_tipo_pago');
            }
            if (count($this->gsatelite->get_tabla('tpg_tipo_pago', array('tpg_nombre' => trim($this->input->post('nombre'))))) > 0) {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "El tipo de pago ya existe");
                $this->session->set_flashdata($alerta);
                redirect($ruta . '/agregar_tipo_pago');
            }
            $insert_array = array(
                'tpg_nombre'    => $this->input->post('nombre'),
                'tpg_defecto'   => $this->input->post('pago_defecto'),
                'tpg_aplica_credito' => $this->input->post('aplica_contado'),
                'tpg_estado'    => 1,
                'tpg_usu_mod'   => $this->tank_auth->get_user_id(),
                'tpg_fecha_mod' => date('Y-m-d h:i:s'),
                'tpg_usu_crea'  => $this->tank_auth->get_user_id(),
                'tpg_fecha_crea' => date('Y-m-d h:i:s'),
            );
            $id_tipo = $this->gsatelite->ingresar('tpg_tipo_pago', $insert_array);
            // Se comento, ya que se quito la ficha de finanzas
            // $cuentas = $this->input->post('cuentas');
            // foreach ($cuentas as $id) {
            //     if ($id > 0) {
            //         $info = array(
            //             'cxg_id_cnt'    => $id,
            //             'cxg_id_tpg'    => $id_tipo,
            //             'cxg_estado'    => 1,
            //             'cxg_usu_crea'  => $this->tank_auth->get_user_id(),
            //             'cxg_fecha_crea'=> date('Y-m-d H:i:s'),
            //             'cxg_usu_mod'   => $this->tank_auth->get_user_id(),
            //             'cxg_fecha_mod' => date('Y-m-d H:i:s'),
            //         );
            //         $this->gsatelite->ingresar('cxg_cuentaxtipo_pago', $info);
            //     }
            // }
            $rediret = $this->input->post('redirect');
            if ($id_tipo > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Procesado", 'texto_alerta' => "Registro ingresado con éxito");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "Ocurrió un error al ingresar la información");
            }
            $this->session->set_flashdata($alerta);
            $dir = $this->input->post('direccion');
            if ($dir == 1) {
                redirect($ruta . '/agregar_tipo_pago');
            } else if ($dir == 2) {
                redirect($ruta . '/tipos_pago');
            }
        }

        $data['titulo_personal'] = "Agregar Tipo Pago";
        $data['ruta'] = $ruta;
        cargarvista($data, $output, 'facturacion/entradas/agregar_tipo_pago');
    }

    public function editar_tipo_pago($id_tipo_pago = null, $ruta = null){
        satelite_validar();
        if (!is_numeric($id_tipo_pago)) {
            rediret('');
        }
        $output = (isset($output)) ? $output : null;
        $ruta = (trim($ruta) != '') ? $ruta : 'facturacion/entradas';
        if ($this->input->post()) {
            if (trim($this->input->post('nombre')) == '') {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "El nombre es obligatorio");
                $this->session->set_flashdata($alerta);
                redirect($ruta . "/editar_tipo_pago/$id_tipo_pago");
            }
            $id_tipo_pago = $this->input->post('id_tipo_pago');
            if (count($this->gsatelite->get_tabla('tpg_tipo_pago', array('tpg_nombre' => trim($this->input->post('nombre')), 'tpg_id !=' => $id_tipo_pago))) > 0) {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "El tipo de pago ya existe");
                $this->session->set_flashdata($alerta);
                redirect($ruta . "/editar_tipo_pago/$id_tipo_pago");
            }
            $update_array = array(
                'tpg_nombre'    => $this->input->post('nombre'),
                'tpg_estado'    => $this->input->post('estado'),
                'tpg_defecto'   => $this->input->post('pago_defecto'),
                'tpg_aplica_credito' => $this->input->post('aplica_contado'),
                'tpg_usu_mod'   => $this->tank_auth->get_user_id(),
                'tpg_fecha_mod' => date('Y-m-d h:i:s'),
            );
            $exito   = $this->gsatelite->actualizar_array('tpg_tipo_pago', $update_array, array('tpg_id' => $id_tipo_pago));
            // Se comento este codigo, ya que se quito la ficha de finanzas
            // $cuentas = $this->input->post('cuentas');
            // $cuentas_actuales = $this->gsatelite->get_tabla('cxg_cuentaxtipo_pago', array('cxg_id_tpg' => $id_tipo_pago));
            // $cnt_actuales     = array();
            // foreach ($cuentas_actuales as $fila) {
            //     $cnt_actuales[] = $fila['cxg_id_cnt'];
            // }
            // $existen = array();
            // foreach ($cuentas as $id) {
            //     if ($id > 0) {
            //         if (in_array($id, $cnt_actuales)) {
            //             $existen[] = $id;
            //             $info      = array(
            //                 'cxg_id_cnt'    => $id,
            //                 'cxg_id_tpg'    => $id_tipo_pago,
            //                 'cxg_estado'    => 1,
            //                 'cxg_usu_mod'   => $this->tank_auth->get_user_id(),
            //                 'cxg_fecha_mod' => date('Y-m-d H:i:s'),
            //             );
            //             $this->gsatelite->actualizar_array('cxg_cuentaxtipo_pago', $info, array('cxg_id_cnt' => $id, 'cxg_id_tpg' => $id_tipo_pago));
            //         } else {
            //             $info = array(
            //                 'cxg_id_cnt'    => $id,
            //                 'cxg_id_tpg'    => $id_tipo_pago,
            //                 'cxg_estado'    => 1,
            //                 'cxg_usu_crea'  => $this->tank_auth->get_user_id(),
            //                 'cxg_fecha_crea'=> date('Y-m-d H:i:s'),
            //                 'cxg_usu_mod'   => $this->tank_auth->get_user_id(),
            //                 'cxg_fecha_mod' => date('Y-m-d H:i:s'),
            //             );
            //             $this->gsatelite->ingresar('cxg_cuentaxtipo_pago', $info);
            //         }
            //     }
            // }
            // foreach ($cnt_actuales as $idcnt) {
            //     if (!in_array($idcnt, $existen)) {
            //         $info = array(
            //             'cxg_id_cnt'    => $idcnt,
            //             'cxg_id_tpg'    => $id_tipo_pago,
            //             'cxg_estado'    => 0,
            //             'cxg_usu_mod'   => $this->tank_auth->get_user_id(),
            //             'cxg_fecha_mod' => date('Y-m-d H:i:s'),
            //         );
            //         $this->gsatelite->actualizar_array('cxg_cuentaxtipo_pago', $info, array('cxg_id_cnt' => $idcnt, 'cxg_id_tpg' => $id_tipo_pago));
            //     }
            // }
            $rediret = $this->input->post('redirect');
            if ($exito > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Procesado", 'texto_alerta' => "Registro actualizado con éxito");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "Ocurrió un error al actualizar la información");
            }
            $this->session->set_flashdata($alerta);
            $dir = $this->input->post('direccion');
            if ($dir == 1) {
                redirect($ruta . "/editar_tipo_pago/$id_tipo_pago");
            } else if ($dir == 2) {
                redirect($ruta . '/tipos_pago');
            }
        }

        $data['id_tipo']       = $id_tipo_pago;
        $data['registro']      = $this->gsatelite->get_tabla('tpg_tipo_pago', array('tpg_id' => $id_tipo_pago));
        $data['pago_defecto']  = (isset($data['registro'][0]['tpg_defecto']) && $data['registro'][0]['tpg_defecto'] > 0) ? 'checked' : '';
        $data['aplica_contado']  = (isset($data['registro'][0]['tpg_aplica_credito']) && $data['registro'][0]['tpg_aplica_credito'] > 0) ? 'checked' : '';
        /************************************* Se quito la ficha de finanzas ***************************************/
        // $this->db->join('cnt_cuenta_contable', 'cnt_id=cxg_id_cnt');
        // $data['cuentasxtipo'] = $this->gsatelite->get_tabla('cxg_cuentaxtipo_pago', array('cxg_id_tpg' => $id_tipo_pago, 'cxg_estado' => 1));
        // $this->db->join('cnt_cuenta_contable', "cnt_id=cxg_id_cnt and cxg_id_tpg=$id_tipo_pago and cxg_estado=1", 'right');
        // $this->db->where('cxg_id', null);
        // $data['cuentas'] = $this->gsatelite->get_tabla('cxg_cuentaxtipo_pago', array('cnt_estado' => 1));
        /***********************************************************************************************************/
        $data['titulo_personal'] = "Editar Tipo Pago";
        $data['ruta'] = $ruta;
        cargarvista($data, $output, 'facturacion/entradas/editar_tipo_pago');
    }

    public function actualizar_tipo_pago()
    {
        $id_imp = $this->input->post('id_impuestos');
        $imp_array = array(
            'imp_nombre' => $this->input->post('nombre'),
            'imp_defecto' => $this->input->post('apli_defect'),
            'imp_porcentaje' => $this->input->post('porcentaje'),
            'imp_estado' => $this->input->post('estado'),
            'imp_usu_mod' => $this->tank_auth->get_user_id(),
            'imp_fecha_mod' => date('Y-m-d h:i:s'),
        );
        //$this->db->insert('cxj_correlativoxcaja', $uxc_array);
        $contrato_id = $this->gsatelite->actualizar_array('imp_impuesto', $imp_array, array('imp_id' => $id_imp));
        $this->gsatelite->borrado_general('cxe_cuentaximpuesto', array('cxe_id_imp' => $id_imp, 'cxe_tipo' => 2));
        $cnt = $this->input->post('cuen_cont_cli');
        foreach ($cnt as $id) {
            $info = array(
                'cxe_id_cnt' => $id,
                'cxe_id_imp' => $id_imp,
                'cxe_tipo' => 2,
                'cxe_estado' => 1,
                'cxe_usu_crea' => $this->tank_auth->get_user_id(),
                'cxe_fecha_crea' => date('Y-m-d H:i:s'),
                'cxe_usu_mod' => $this->tank_auth->get_user_id(),
                'cxe_fecha_mod' => date('Y-m-d H:i:s'),
            );
            $this->gsatelite->ingresar('cxe_cuentaximpuesto', $info);
        }

        $this->gsatelite->borrado_general('cxe_cuentaximpuesto', array('cxe_id_imp' => $id_imp, 'cxe_tipo' => 1));
        $cnt = $this->input->post('cuen_cont_cli_2');
        foreach ($cnt as $id2) {
            $info2 = array(
                'cxe_id_cnt' => $id2,
                'cxe_id_imp' => $id_imp,
                'cxe_tipo' => 1,
                'cxe_estado' => 1,
                'cxe_usu_crea' => $this->tank_auth->get_user_id(),
                'cxe_fecha_crea' => date('Y-m-d H:i:s'),
                'cxe_usu_mod' => $this->tank_auth->get_user_id(),
                'cxe_fecha_mod' => date('Y-m-d H:i:s'),
            );
            $this->gsatelite->ingresar('cxe_cuentaximpuesto', $info2);
        }

        $dir = $this->input->post('direccion');
        if ($dir == 1) {
            redirect('facturacion/entradas/editar_impuesto/' . $id_imp);
        } else if ($dir == 2) {
            redirect('facturacion/entradas/impuestos');
        }
    }

    /*
     * @author: Mario Marquez
     * @method: Mantenimiento de Medios de Contacto
     * @origin: Cotizaciones
     */

    public function medio_contacto()
    {
        satelite_validar();

        $this->load->library('../controllers/cotizaciones/mantenimientos');
        $this->mantenimientos->medio_contacto();
    }

    /**
     * @author René Castaneda
     * @since 2017-09-07
     * @return Mantenimiento tabla tipo_cliente
     */
    public function tipo_cliente()
    {
        satelite_validar();
        $this->load->library('../controllers/cotizaciones/mantenimientos');
        $url_vista = 'cotizaciones/mantenimientos/tipo_cliente';
        $this->mantenimientos->tipo_cliente($url_vista);
        die('éxito');
    }


    /**
     * @author René Castaneda
     * @since 2017-09-07
     * @return Mantenimiento tabla tipo_documento
     */
    public function tipo_documento()
    {
        satelite_validar();
        $this->load->library('../controllers/expediente_personal/catalogos');
        $url_vista = 'expediente_personal/catalogos/tipo_documento';
        $this->catalogos->tipo_documento($url_vista);
        die('éxito');
    }

    /**
     * @author Habby Lovo
     * @since 2017-10-02
     * @return Mantenimiento tabla tipo_venta
     */
    public function tipo_venta()
    {
        satelite_validar();
        $this->load->library('../controllers/modulo_compras/catalogos');
        $permisos = $this->gsatelite->get_permisos_opcion('facturacion/entradas/tipo_venta');
        $this->catalogos->tipo_venta('Catálogo de Tipo de venta', $permisos, 'facturacion');
    }

    //Bodega preferencial
    function bodega_preferencial($consulta = null)
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $permisos = $this->gsatelite->get_permisos_opcion();
            if ($consulta == 1) {
                //$this->gsatelite->borrado_general('cxe_cuentaximpuesto', array('cxe_id_imp' => $id_imp, 'cxe_tipo' => 1));
                $usu_id = $this->input->post('usuario');
                $uxb_id = $this->input->post('bodega_pref');
                $detalle_uxb = array(
                    'uxb_defecto' => 0
                );
                $this->gsatelite->actualizar_array("uxb_usuarioxbodega", $detalle_uxb, array("uxb_id_usu" => $usu_id));

                $detalle_uxb2 = array(
                    'uxb_defecto' => 1,
                    'uxb_usu_mod' => $this->tank_auth->get_user_id(),
                    'uxb_fecha_mod' => date('Y-m-d H:i:s'),
                );
                $this->gsatelite->actualizar_array("uxb_usuarioxbodega", $detalle_uxb2, array("uxb_id" => $uxb_id));

                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Procesado", 'texto_alerta' => "Registro actualizado con éxito");
                $this->session->set_flashdata($alerta);

                redirect('facturacion/entradas/bodega_preferencial');
            } else {
                $rol_cajero = $this->gsatelite->get_parametro('SYS_ID_ROL_CAJA');
                $crud =  new grocery_CRUD();
                $crud->set_subject('Bodega preferencial')->set_table('emp_empleado');
                $crud->set_relation('emp_id_usu', 'uxr_usuarioxrol', 'uxr_id_usu');
                $crud->columns('suc_nombre', 'Cajero', 'bodega');
                $crud->display_as('suc_nombre', 'Sucursal')
                    ->display_as('bodega', 'Bodega preferencial');
                $crud->callback_column('suc_nombre', function ($value, $row) {
                    $sucursal = $this->gsatelite->get_campo('suc_sucursal', 'suc_nombre', array('suc_id' => $row->emp_id_suc));
                    return $sucursal;
                });
                $crud->callback_column('Cajero', function ($value, $row) {
                    return $row->emp_nombre . ' ' . $row->emp_apellido;
                });
                $crud->callback_column('bodega', function ($value, $row) {
                    $this->db->join('uxb_usuarioxbodega', 'uxb_id_bod = bod_id', 'left');
                    $bodega_defecto = $this->gsatelite->get_campo('bod_bodega', 'bod_nombre', array('uxb_id_usu' => $row->emp_id_usu, 'uxb_defecto' => 1));
                    $regresar = (trim($bodega_defecto) != '') ? $bodega_defecto : '';
                    return $regresar;
                });
                $crud->where("emp_id_usu in (SELECT uxr_id_usu from uxr_usuarioxrol where uxr_id_rol = " . $rol_cajero . ")");

                $crud->unset_read();
                $crud->unset_edit();
                $crud->unset_delete();
                $crud->unset_add();
                $crud->unset_print();
                $crud->unset_export();

                //$crud->add_action('Bodega pref.', '', '/facturacion/entradas/bodega_cliente','icomoon-icon-search-3 fancybox_modal');
                $crud->add_action('Bodega pref.', '', '', 'icomoon-icon-search-3 bodega_pref', function ($key, $row) {
                    return $row->emp_id_usu;
                });

                $output = $crud->render();
                $data['titulo_personal'] = "Bodega preferencial";
                $this->_cargarvista($data, $output);
            }
        }
    }

    function bodega_cliente()
    {
        $usu_id = $this->input->post('usuario');

        $bodegas_reg = $this->facturacion_model->bodegas_cliente(array('uxb_id_usu' => $usu_id));
        $regresar = '';
        if (count($bodegas_reg) > 0) {
            foreach ($bodegas_reg as $key) {
                $selected = '';
                if ($key['uxb_defecto'] == 1) {
                    $selected = 'checked';
                }
                $regresar .= '<tr>';
                $regresar .= '<td>' . $key['suc_nombre'] . '</td>';
                $regresar .= '<td>' . $key['bod_nombre'] . '</td>';
                $regresar .= '<td><input type="radio" value="' . $key['uxb_id'] . '" name="bodega_pref" ' . $selected . '></td>';
            }
        } else {
            $regresar .= '<tr>';
            $regresar .= '<td colspan="3" style="text-align: center;">No se encontraron registros</td>';
        }

        //print_r($bodegas_reg);
        echo json_encode(array('resultado' => $regresar));
    }

    function series_facturadas()
    {
        //verificar si hay un factura creadas
        $result = false;
        $urlx = explode('/', uri_string());
        $primary_key = (is_numeric(end($urlx))) ? end($urlx) : 0;

        $sef_id_tif_old = $this->gsatelite->get_campo("sef_serie_factura", "sef_id_tif", array("sef_id" => $primary_key));

        $sef_id_tif_new = $this->input->post('sef_id_tif');

        $sef_id_tif_old = ($sef_id_tif_old != null) ? $sef_id_tif_old : $sef_id_tif_new;

        if ($sef_id_tif_new != $sef_id_tif_old) {
            $this->db->join("cof_correlativo_factura", " cof_id = fac_id_cof");
            $verificar_factura = $this->gsatelite->count("fac_factura", array("cof_id_sef" => $primary_key));
            if ($verificar_factura > 0) {
                $this->form_validation->set_message('series_facturadas', "No se puede cambiar el tipo de factura porque ya se crearon facturas.");
                $result = false;
            } else {
                $result = true;
            }
        } else {
            $result = true;
        }
        return $result;
    }

    function validar_correlativo_cajaxfactura(){
        // print_r($_POST);die();
        // Datos obtenidos por POST
        $inicio = $this->input->post('inicio'); // Inicio de Corr
        $fin  = $this->input->post('fin'); // Fin de Corr
        $correlativo_id = $this->input->post('serie');
        $caja = $this->input->post('caja');

        // Obtener los datos del correlativo
        $cof = $this->gsatelite->get_tabla('cof_correlativo_factura', array('cof_id' => $correlativo_id, 'cof_estado' => 1)); //print_r($cof);die();
        // Obtener la serie de las facturas, Nombre de la serie de Factura
        $sef = $this->gsatelite->get_tabla('sef_serie_factura', array('sef_id' => $cof[0]['cof_id_sef'], 'sef_estado' => 1)); //print_r($sef);die();
        // Obtener el tipo de Factura
        $tipo_factura_id = $sef[0]['sef_id_tif'];
        // Obtener el correlativo asignado a la caja, si existe
               $this->db->order_by('cxj_id', 'DESC');
        $cxj = $this->gsatelite->get_tabla('cxj_correlativoxcaja', array('cxj_id_cof' => $correlativo_id, 'cxj_id_caj' => $caja)); //Verifica si existe caja con correlativo asignada que sea mayor
        // Consulta para obtener las facturas creadas por ese rango
        $where = array('fac_numero >=' => $inicio, 'fac_id_cof' => $correlativo_id, 'fac_id_tif' => $tipo_factura_id);
        if ($fin > 0) {
            $where['fac_numero <='] = $fin;
        }
        $numeros = $this->facturacion_model->get_numeros_facturas($where);
        // Valores a enviar
        $permitidoI = 0;
        $permitidoF = 0;
        $numero = null;

        // Verificar si ya no hay correlativos en una caja
        if (count($cxj) > 0) {
            // Procesar para obtener el ultimo indice
            $numero     = (int) ($cxj[0]['cxj_inicio']);
            $cxj_inicio = (int) ($cxj[0]['cxj_inicio']);
            $cxj_fin    = (int) ($cxj[0]['cxj_fin']);
            if (count($numeros) > 0) {
                $numero = 0;
                $numero_factura = array();
                foreach ($numeros as $key) {
                    $numero_factura[] = $key['fac_numero'];
                }
                /*for ($x = $cxj_inicio; $x <= $cxj_fin; $x++) {
                    if (!in_array($x, $numero_factura)) {
                        $numero = $x;
                        break;
                    }
                } */
                $cantidad = count($numeros) - $fin;
                $permitidoI = $numeros[0]['fac_numero'];
            }
        }

        // Decision: Si != 0, obtener el ultimo indice permitido sino esta agotado
        echo json_encode(array('resultado' => $numero, 'inicio' => $permitidoI, 'fin' => $fin));
    }

    /**
     * @author Luis Navarro
     * @since 2018-02-28
     * @return Verificar si el flag de tipo de factura esta o no activado
     */
    function verificar_flag_defecto_factura()
    {
        satelite_validar(true);

        if ($this->input->post()) {
            $flag       = $this->input->post("flag");
            $consulta   = $this->gsatelite->get_tabla('tif_tipo_factura', array('tif_defecto' => 1, 'tif_estado' => 1));

            if (count($consulta) > 0) {
                $defecto = 1;
            } else {
                $defecto = 0;
            }

            echo json_encode(array('cant_defecto' => count($consulta), 'es_defecto' => $defecto));
        }
    }

    /**
     * @author Luis Navarro
     * @since 2018-02-28
     * @return Verificar si el flag de tipo de pago esta o no activo
     */
    function verificar_flag_defecto_pago()
    {
        satelite_validar(true);

        if ($this->input->post()) {
            $flag       = $this->input->post("flag");
            $consulta   = $this->gsatelite->get_tabla('tpg_tipo_pago', array('tpg_defecto' => 1, 'tpg_estado' => 1));

            if (count($consulta) > 0) {
                $defecto = 1;
            } else {
                $defecto = 0;
            }

            echo json_encode(array('cant_defecto' => count($consulta), 'es_defecto' => $defecto));
        }
    }

    /**
     * @author Luis Navarro
     * @since  2018-03-01
     * @return Verificar si el flag de forma de pago esta o no activo
     */
    function verificar_flag_defecto_forma_pago()
    {
        satelite_validar(true);

        if ($this->input->post()) {
            $flag       = $this->input->post("flag");
            $consulta   = $this->gsatelite->get_tabla('frp_forma_pago', array('frp_defecto' => 1, 'frp_estado' => 1));

            if (count($consulta) > 0) {
                $defecto = 1;
            } else {
                $defecto = 0;
            }

            echo json_encode(array('cant_defecto' => count($consulta), 'es_defecto' => $defecto));
        }
    }

    /**
     * @author Luis Navarro
     * @since  2018-03-01
     * @return Mantenimiento de Forma de Pago (tabla frp_forma_pago)
     */
    function forma_pago()
    {
        satelite_validar();
        $crud     = new grocery_CRUD();
        $accion   = $crud->getState(); //obtener la acción que esta ejecutando grocery crud
        $permisos = $this->gsatelite->get_permisos_opcion();
        $crud->set_table('frp_forma_pago');
        $crud->set_subject('Formas de Pagos');

        $columns = array(
            'frp_nombre',
            'frp_descripcion',
            'frp_estado'
        );

        $display_as = array(
            'frp_nombre'      => 'Nombre',
            'frp_descripcion' => 'Descripción',
            'frp_defecto'     => 'Pago por Defecto',
            'frp_estado'      => 'Estado'
        );

        $required = array(
            'frp_nombre',
            'frp_estado'
        );

        $add_columns = array(
            'frp_nombre',
            'frp_descripcion',
            'frp_defecto',
            'frp_estado',
            'frp_usu_creacion',
            'frp_fecha_creacion',
            'frp_usu_modificacion',
            'frp_fecha_modificacion'
        );

        $edit_columns = array(
            'frp_nombre',
            'frp_descripcion',
            'frp_defecto',
            'frp_estado',
            'frp_usu_modificacion',
            'frp_fecha_modificacion'
        );

        $crud->columns($columns);
        $crud->display_as($display_as);
        $crud->required_fields($required);
        $crud->add_fields($add_columns);
        $crud->edit_fields($edit_columns);
        $crud->callback_add_field('frp_defecto', function () {
            return '<input type="checkbox" id="chbdefecto" class="nostyle"><input type="hidden" id="field-frp_defecto" name="frp_defecto" value="0">';
        });
        $crud->callback_edit_field('frp_defecto', function ($value, $primary_key) {
            $leer    = ($this->uri->rsegments[3] == 'read') ? 'iButton' : '';
            $defecto = ($value) ? 'checked' : ''; // Verificar si esta activo
            return '<input type="checkbox" id="chbdefecto" ' . $defecto . ' class="' . $leer . ' nostyle"><input type="hidden" id="field-frp_defecto" name="frp_defecto" value="' . $value . '">';
        });
        $crud->field_type('frp_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
        $crud->field_type('frp_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
        $crud->field_type('frp_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
        $crud->field_type('frp_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
        $crud->set_rules('frp_nombre', 'Nombre', 'campo_unico[frp_forma_pago.frp_nombre]|required');
        $crud->unset_export();
        $crud->unset_print();
        $crud->unset_read();

        if ($accion == 'add') {
            $crud->field_type('frp_estado', 'hidden', 1);
        } else {
            $crud->field_type('frp_estado', 'dropdown', array(1 => 'Activo', 0 => 'Inactivo'));
        }

        // Validaciones
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }
        if (!$permisos['permite_editar']) {
            $crud->unset_edit();
        }
        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }

        $output = $crud->render();

        $data['titulo_personal'] = "Formas de Pagos";
        cargarvista($data, $output);
    } //Fin mantenimiento Formas de Pagos

    /**
     * @author Habby Lovo
     * @since  2018-03-26
     * @return Mantenimiento de formas de envio (tabla frv_forma_envio)
     */
    function forma_envio()
    {
        satelite_validar();
        $crud     = new grocery_CRUD();
        $accion   = $crud->getState(); //obtener la acción que esta ejecutando grocery crud
        $permisos = $this->gsatelite->get_permisos_opcion();
        $crud->set_table('frv_forma_envio');
        $crud->set_subject('Formas de envio');


        $columns = array(
            'frv_nombre',
            'frv_descripcion',
            'frv_estado'
        );

        $display_as = array(
            'frv_nombre'      => 'Nombre',
            'frv_descripcion' => 'Descripción',
            'frv_estado'      => 'Estado'
        );

        $required = array(
            'frv_nombre',
            'frv_estado'
        );

        $add_columns = array(
            'frv_nombre',
            'frv_descripcion',
            'frv_estado',
            'frv_usu_creacion',
            'frv_fecha_creacion',
            'frv_usu_modificacion',
            'frv_fecha_modificacion'
        );

        $edit_columns = array(
            'frv_nombre',
            'frv_descripcion',
            'frv_estado',
            'frv_usu_modificacion',
            'frv_fecha_modificacion'
        );

        $crud->columns($columns);
        $crud->display_as($display_as);
        $crud->required_fields($required);
        $crud->add_fields($add_columns);
        $crud->edit_fields($edit_columns);
        $crud->field_type('frv_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
        $crud->field_type('frv_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
        $crud->field_type('frv_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
        $crud->field_type('frv_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
        $crud->set_rules('frv_nombre', 'Nombre', 'campo_unico[frv_forma_envio.frv_nombre]|required');
        $crud->unset_export();
        $crud->unset_print();
        $crud->unset_read();

        if ($accion == 'add') {
            $crud->field_type('frv_estado', 'hidden', 1);
        } else {
            $crud->field_type('frv_estado', 'dropdown', array(1 => 'Activo', 0 => 'Inactivo'));
        }

        // Validaciones
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }
        if (!$permisos['permite_editar']) {
            $crud->unset_edit();
        }
        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }

        $output = $crud->render();

        $data['titulo_personal'] = "Forma de envio";
        cargarvista($data, $output);
    } //Fin mantenimiento Formas de Pagos

    /**
     * @author Habby Lovo
     * @since 2018-03-26
     * @return mantenimiento compartido de registro academico
     */
    public function tipo_transporte()
    {
        satelite_validar();
        $this->load->library('../controllers/registro_academico/mantenimientos');
        $this->mantenimientos->tipo_transporte('facturacion/entradas');
    }

    /**
     * Descripción:
     * Función para dar mantenimiento a las formulas por producto (tabla: foa_formula_articulo)
     * Funcionalidad Compartida del Módulo de Inventario - Tipo de Referencia
     * @author Edith Herrera - Grupo Satélite
     * @since  2018-05-15
     * @param  Ninguno
     * @return Mantenimiento de formulas
     */
    public function formulas_producto($art_id)
    {
        satelite_validar();
        $this->load->library('../controllers/inventario/mantenimiento');
        $this->mantenimiento->formulas_producto($art_id, 'facturacion/entradas');
    }

    /**
     * Descripción:
     * Función para agregar formula al producto (tabla: foa_formula_articulo)
     * @author Edith Herrera - Grupo Satélite
     * @since  2018-05-15
     * @param  Ninguno
     * @return Obtener la vista para agregar formula
     */
    public function agregar_formula($art_id)
    {
        satelite_validar();
        $this->load->library('../controllers/inventario/mantenimiento');
        $this->mantenimiento->agregar_formula($art_id, 'facturacion/entradas', 'formulas_producto');
    }

    /**
     * Descripción:
     * Función para editar formula al producto (tabla: foa_formula_articulo)
     * @author Edith Herrera - Grupo Satélite
     * @since  2018-05-15
     * @param  Ninguno
     * @return Obtener la vista para editar formula
     */
    public function editar_formula($foa_id = null, $ver = null)
    {
        satelite_validar();
        $this->load->library('../controllers/inventario/mantenimiento');
        $this->mantenimiento->editar_formula($foa_id, $ver, 'facturacion/entradas', 'formulas_producto');
    }


    /**
     * Descripción:
     * Función para obtener el valor de la ultima entrada a los inventarios de un producto determinado
     * @author René Castaneda - Grupo Satélite
     * @since  2018-06-14
     * @param  Ninguno
     * @return Obtener la vista para editar formula
     */
    public function get_valor_ultima_entrada(){
        $precio_lista = $this->input->post('precio_lista');
        $id_articulo = $this->input->post('id_articulo');
        $unidad_medida = $this->input->post('unidad_medida');
        $where_cva['cva_id_art'] = $id_articulo;
        if ($unidad_medida == 0 && isset($_POST['id_cva']) && $_POST['id_cva'] > 0) {
            $where_cva['cva_id'] = $this->input->post('id_cva');
        } else {
            $where_cva['cva_id_mep'] = $unidad_medida;
        }
        $q2 = $this->gsatelite->get_tabla("cva_conversion_articulo", $where_cva);
        $unidad_medida = ($unidad_medida > 0) ? $unidad_medida : $q2[0]['cva_id_mep'];
        $where['sar_id_art'] = $id_articulo;
        $where['dxd_id_art'] = $id_articulo;
        $where['cva_id_mep'] = $unidad_medida;
        //query unidad de medida factor
        $datos = $this->facturacion_model->get_valor_ultima_entrada($where);
        $factor_conversion = ($q2[0]['cva_conversion'] > 0) ? $q2[0]['cva_conversion'] : 1;
        $valor_ultima_compra = (isset($datos['dxd_precio_unitario'])) ? ($datos['dxd_precio_unitario']/*$factor_conversion*/) : 0;
        $respuesta['ultima_compra'] = $valor_ultima_compra;
        $respuesta['utilidad'] = (isset($datos['sar_precio'])) ? round((($precio_lista - $valor_ultima_compra) * 100) / $valor_ultima_compra, 2) : 0;
        die(json_encode($respuesta));
    }

    /**
     * Descripción:
     * Función para dar mantenimiento de Tipo lista  (tabla: tlp_tipo_lista_precio)
     * Funcionalidad Compartida del Modulo de Inventario - tipo_lista
     * @author Luis Navarro - Grupo Satélite
     * @since 2018-06-23
     * @return Mantenimiento de Tipo lista de precio
     */
    public function tipo_lista(){
        satelite_validar();
        $this->load->library('../controllers/inventario/mantenimiento');
        $this->mantenimiento->tipo_lista(array('facturacion/entradas/tipo_lista'));
    }

    public function verificar_resolucion()
    {
        $resolucion = $this->input->post('resolucion');
        $nombre     = $this->input->post('nombre');
        $codigo     = $this->input->post('codigo');

        $where['sef_resolucion']    = trim($resolucion);
        $where['sef_nombre']        = trim($nombre);
        $where['sef_id !=']         = $codigo;

        $this->db->limit(1);
        $repetido   = $this->gsatelite->get_campo("sef_serie_factura", "sef_resolucion", $where);
        $repetido   = ($repetido != NULL) ? $repetido : "";

        if (trim($resolucion) == trim($repetido)) {
            echo 0;
            die();
        } else {
            echo 1;
            die();
        }
    }

    /**
     * Descripción:
     * Función para dar mantenimiento a Area de Factura (tabla: arf_area_factura)
     * @author Rafael A. Cuchilla - Grupo satélite
     * @since  2018-07-05
     * @param  Ninguno
     * @return Mantenimiento de Area de factura
     */
    public function areas_facturacion()
    {
        satelite_validar();

        try {
            $permisos = $this->gsatelite->get_permisos_opcion();
            $crud = new grocery_CRUD();


            $columnas = array(
                'arf_codigo',
                'arf_nombre',
                'arf_estado'
            );

            $required = array(
                'arf_codigo',
                'arf_nombre',
                'arf_estado'
            );

            $alias = array(
                'arf_codigo' => 'Código',
                'arf_nombre' => 'Nombre',
                'arf_estado' => 'Estado',
                'arf_defecto' => 'Defecto'
            );

            $columnas_insert = array(
                'arf_codigo',
                'arf_nombre',
                'arf_defecto',
                'arf_estado',
                'arf_usu_creacion',
                'arf_fecha_creacion',
                'arf_usu_modificacion',
                'arf_fecha_modificacion'
            );

            $columnas_update = array(
                'arf_codigo',
                'arf_nombre',
                'arf_estado',
                'arf_defecto',
                'arf_usu_modificacion',
                'arf_fecha_modificacion'
            );

            $crud->set_table('arf_area_factura')
                ->set_subject('Área de Facturación')
                ->columns($columnas)
                ->display_as($alias)
                ->add_fields($columnas_insert)
                ->edit_fields($columnas_update)
                ->required_fields($required)
                ->callback_add_field('arf_defecto', function ($value, $noc) {
                    return '<input type="checkbox" id="chbdefecto" class="nostyle"><input type="hidden" id="field-arf_defecto" name="arf_defecto" value="0">';
                })
                ->callback_edit_field('arf_defecto', function ($value, $primary_key) {
                    $leer    = ($this->uri->rsegments[3] == 'read') ? 'iButton' : '';
                    $defecto = ($value) ? 'checked' : ''; // Verificar si esta activo
                    return '<input type="checkbox" id="chbdefecto" ' . $defecto . ' class="' . $leer . ' nostyle"><input type="hidden" id="field-arf_defecto" name="arf_defecto" value="' . $value . '">';
                })
                ->callback_column('arf_defecto', function ($value, $row) {
                    $defecto = ($value == 1) ? 'SI' : '';
                    return $defecto;
                })
                ->set_rules('arf_codigo', 'Código', 'trim|required|campo_unico[arf_area_factura.arf_codigo]')
                ->set_rules('arf_nombre', 'Nombre', 'trim|required|campo_unico[arf_area_factura.arf_nombre]')
                ->field_type('arf_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('arf_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
                ->field_type('arf_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
                ->field_type('arf_usu_creacion', 'hidden', $this->tank_auth->get_user_id());

            $urlx = explode('/', uri_string());
            if (end($urlx) == 'add') {
                $crud->field_type('arf_estado', 'hidden', 1);
            } else {
                $crud->field_type('arf_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if (!$permisos['permite_ver']) {
                $crud->unset_read();
            } else {
                $data_url = $this->masterpage->getUsuario();
                $url_read = $data_url['modulo'] . '/' . $data_url['control'] . '/' . $data_url['funcion'];
                $crud->add_action('Ver', 'minia-icon-search', $url_read . "/read");
            }

            $output = $crud->render();
            $data['titulo_personal'] = "Áreas de Facturación";

            cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    function verificar_flag_defecto_arf()
    {
        satelite_validar(true);
        if ($this->input->post()) {
            $id = $this->input->post("id");
            $defecto = $this->gsatelite->get_tabla('arf_area_factura', array('arf_defecto' => 1, 'arf_estado' => 1));
            if ($id == $defecto[0]['arf_id']) {
                $defecto = 0;
            } else {
                $consulta = $this->gsatelite->get_tabla('arf_area_factura', array('arf_defecto' => 1, 'arf_estado' => 1, 'arf_id <>' => $id));
                if (count($consulta) > 0) {
                    $defecto = 1;
                } else {
                    $defecto = 0;
                }
            }
            echo json_encode(array('cant_defecto' => count($consulta), 'es_defecto' => $defecto));
        }
    }

    function get_valor_conversion($id_unidad = null, $id_articulo = null){
        if ($_POST) {
            $id_unidad = $this->input->post('id_unidad');
            $id_articulo = $this->input->post('id_articulo');
            $data = $this->gsatelite->get_tabla('cva_conversion_articulo', array('cva_id_mep' => $id_unidad, 'cva_id_art' => $id_articulo));
            echo json_encode($data);
        }
    }

    public function agregar_caja(){
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion('facturacion/entradas/mantenimiento_caja');
        if ($this->input->post()) {
            // var_dump($_POST);die();
            $nombre       = (trim($this->input->post('caja_nombre')) != "") ? $this->input->post('caja_nombre') : null;
            $meta_mensual = (trim($this->input->post('caja_meta_mensual')) != "") ? $this->input->post('caja_meta_mensual') : null;
            $maq_registra = (trim($this->input->post('num_registradora')) != "") ? $this->input->post('num_registradora') : null;
            $mailcaja = (trim($this->input->post('correo_caja')) != "") ? trim($this->input->post('correo_caja')) : null;
            $sucursalCaja = ($this->input->post('slcSucursal') > 0) ? $this->input->post('slcSucursal') : null;
            $slcCentroDefecto = ($this->input->post('slcCentroDefecto') > 0) ? $this->input->post('slcCentroDefecto') : null;

            $array_caja = array(
                'caj_nombre'                => $nombre,
                'caj_estimado_facturacion'  => $meta_mensual,
                'caj_id_cec_defecto'  => $slcCentroDefecto,
                'caj_id_suc' => $sucursalCaja,
                'caj_correo_electronico' => $mailcaja,
                'caj_numero_registradora' => $maq_registra,
                'caj_estado'        => 1,
                'caj_usu_mod'       => $this->tank_auth->get_user_id(),
                'caj_fecha_mod'     => date('Y-m-d H:i:s'),
                'caj_usu_crea'      => $this->tank_auth->get_user_id(),
                'caj_fecha_crea'    => date('Y-m-d H:i:s')
            );
            $caja_id = $this->gsatelite->ingresar('caj_caja', $array_caja);

            // Datos de las metas
            $metas_mes      = (is_array($this->input->post("metas_mes")) && count($this->input->post("metas_mes")) > 0) ? $this->input->post("metas_mes") : array();
            $metas_fecha_   = (is_array($this->input->post("metas_fecha_")) && count($this->input->post("metas_fecha_")) > 0) ? $this->input->post("metas_fecha_") : array();
            $metas_venta    = (is_array($this->input->post("metas_venta")) && count($this->input->post("metas_venta")) > 0) ? $this->input->post("metas_venta") : array();

            //Se Agregara los datos de las metas
            for ($x = 0; $x < count($metas_mes); $x++) {
                if (trim($metas_mes[$x]) != "") {

                    $guardar_metas = array(
                        'mtc_id_caj'            => $caja_id,
                        'mtc_periodo'           => formatear_fecha('Y-m-d', $metas_fecha_[$x]),
                        'mtc_meta_venta'        => floatval($metas_venta[$x]),
                        'mtc_estado'            => 1,
                        'mtc_usu_creacion'      => $this->tank_auth->get_user_id(),
                        'mtc_fecha_creacion'    => date('Y-m-d H:i:s'),
                        'mtc_usu_modificacion'  => $this->tank_auth->get_user_id(),
                        'mtc_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->ingresar('mtc_meta_caja', $guardar_metas);
                }
            }

            // Mostrar alerta
            if ($caja_id > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Mantenimiento de Caja", 'texto_alerta' => "El registro se guardó correctamente.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Mantenimiento de Caja", 'texto_alerta' => "El registro no se guardó.");
            }

            $this->session->set_flashdata($alerta);
            $redireccion = $this->input->post("redireccion");

            if ($redireccion == 1) {
                redirect('facturacion/entradas/agregar_caja');
            } else if ($redireccion == 2) {
                redirect('facturacion/entradas/mantenimiento_caja');
            }
            die();
        } else {
            $data['slcSuc'] = $this->gsatelite->get_dropdown('suc_sucursal','{suc_nombre}','',array('suc_id_emr'=>$this->tank_auth->get_empresa_id()),null, '','suc_id',true);
            $data['slcCentroDefecto'] = $this->gsatelite->get_dropdown('cec_centro_costo', '{cec_nombre}', '', array('cec_estado' => '1'), null, '', 'cec_id', true);
            $data['titulo_personal'] = 'Agregar Caja';
            $this->_cargarvista($data);
        }
    }

    public function editar_caja($id = null){
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion('facturacion/entradas/mantenimiento_caja');

        if ($this->input->post()) {
            // print_r($_POST);die();
            $nombre       = (trim($this->input->post('caja_nombre')) != "") ? $this->input->post('caja_nombre') : null;
            $meta_mensual = (trim($this->input->post('caja_meta_mensual')) != "") ? $this->input->post('caja_meta_mensual') : null;
            $estado       = (trim($this->input->post('estado')) != "") ? $this->input->post('estado') : 0;
            $maq_registra = (trim($this->input->post('num_registradora')) != "") ? $this->input->post('num_registradora') : null;
            $slcCentroDefecto = ($this->input->post('slcCentroDefecto') > 0) ? $this->input->post('slcCentroDefecto') : null;
            $mailcaja = (trim($this->input->post('correo_caja')) != "") ? trim($this->input->post('correo_caja')) : null;
            $sucursalCaja = ($this->input->post('slcSucursal') > 0) ? $this->input->post('slcSucursal') : null;

            $array_caja = array(
                'caj_nombre' => $nombre,
                'caj_id_suc' => $sucursalCaja,
                'caj_correo_electronico' => $mailcaja,
                'caj_estimado_facturacion'  => $meta_mensual,
                'caj_id_cec_defecto'  => $slcCentroDefecto,
                'caj_numero_registradora' => $maq_registra,
                'caj_estado'        => $estado,
                'caj_usu_mod'       => $this->tank_auth->get_user_id(),
                'caj_fecha_mod'     => date('Y-m-d H:i:s')
            );
            $caja_id = $this->gsatelite->actualizar_array('caj_caja', $array_caja, array('caj_id' => $id));

            // Datos de las metas
            $metas_mes      = (is_array($this->input->post("metas_mes")) && count($this->input->post("metas_mes")) > 0) ? $this->input->post("metas_mes") : array();
            $metas_fecha_   = (is_array($this->input->post("metas_fecha_")) && count($this->input->post("metas_fecha_")) > 0) ? $this->input->post("metas_fecha_") : array();
            $metas_venta    = (is_array($this->input->post("metas_venta")) && count($this->input->post("metas_venta")) > 0) ? $this->input->post("metas_venta") : array();

            //Se Agregara los datos de las metas
            $this->gsatelite->borrado_general('mtc_meta_caja', array('mtc_id_caj' => $id));
            for ($x = 0; $x < count($metas_mes); $x++) {
                if (trim($metas_mes[$x]) != "") {

                    $guardar_metas = array(
                        'mtc_id_caj'            => $id,
                        'mtc_periodo'           => formatear_fecha('Y-m-d', $metas_fecha_[$x]),
                        'mtc_meta_venta'        => floatval($metas_venta[$x]),
                        'mtc_estado'            => 1,
                        'mtc_usu_creacion'      => $this->tank_auth->get_user_id(),
                        'mtc_fecha_creacion'    => date('Y-m-d H:i:s'),
                        'mtc_usu_modificacion'  => $this->tank_auth->get_user_id(),
                        'mtc_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->ingresar('mtc_meta_caja', $guardar_metas);
                }
            }

            // Mostrar alerta
            if ($caja_id > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Ingreso de contrato", 'texto_alerta' => "El registro se guardó correctamente.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Ingreso de contrato", 'texto_alerta' => "El registro no se guardó.");
            }

            $this->session->set_flashdata($alerta);
            $redireccion = $this->input->post("redireccion");

            if ($redireccion == 1) {
                redirect('facturacion/entradas/editar_caja/' . $id);
            } else if ($redireccion == 2) {
                redirect('facturacion/entradas/mantenimiento_caja');
            }
            die();
        } else {
            $data['id']        = $id;
            $data['caja']      = $this->gsatelite->get_tabla('caj_caja', array('caj_id' => $id));
            $data['caja_meta'] = $this->gsatelite->get_tabla('mtc_meta_caja', array('mtc_id_caj' => $id));
            $data['slcCentroDefecto'] = $this->gsatelite->get_dropdown('cec_centro_costo', '{cec_nombre}', '', array('cec_estado' => '1'), $data['caja'][0]['caj_id_cec_defecto'], '', 'cec_id', true);
            $data['slcSuc'] = $this->gsatelite->get_dropdown('suc_sucursal','{suc_nombre}','',array('suc_id_emr'=>$this->tank_auth->get_empresa_id()),$data['caja'][0]['caj_id_suc'], '','suc_id',true);
            $data['titulo_personal'] = 'Editar Caja';
            $this->_cargarvista($data);
        }
    }

    public function ver_caja($id = null)
    {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion('facturacion/entradas/mantenimiento_caja');

        if (is_numeric($id) && $id > 0) {
            $data['id']        = $id;
            $data['ver']       = 1;
            $data['caja']      = $this->gsatelite->get_tabla('caj_caja', array('caj_id' => $id));
            $data['caja_meta'] = $this->gsatelite->get_tabla('mtc_meta_caja', array('mtc_id_caj' => $id));
            $data['titulo_personal'] = 'Ver Caja';
            cargarvista($data, 0, 'facturacion/entradas/editar_caja');
        } else {
            $this->gsatelite->show_dialog("Error en la caja seleccionada", '', 'error', 'Error');
        }
    }

    public function validar_correlativos_usado()
    {
        $desde = $this->input->post('desde');
        $hasta = $this->input->post('hasta');
        $caja = $this->input->post('caja');
        $serie = $this->input->post('serie');
        $correlativo = $this->input->post('correlativo');

        $caja_actual = $this->gsatelite->get_tabla('cxj_correlativoxcaja', array('cxj_id' => $correlativo));

        $this->db->order_by('fac_numero', 'desc');
        $numeros = $this->facturacion_model->get_numeros_facturas(array('fac_numero >=' => $caja_actual[0]['cxj_inicio'], 'fac_numero <=' => $caja_actual[0]['cxj_fin'], 'fac_id_cof' => $caja_actual[0]['cxj_id_cof']));
        // print_r($numeros);die();
        $numero_valido = 0;
        $caso = 0;
        if (($desde <= $numeros[0]['fac_numero'])) {
            if ($desde == $caja_actual[0]['cxj_inicio']) {
                $numero_valido = 0;
            } else {
                $numero_valido = 1;
                $caso = 1;
            }
        }

        if ($numeros[0]['fac_numero'] >= $hasta) {
            $numero_valido = 1;
            $caso = 2;
        }

        $numero_rango = $hasta - ($desde - 1);
        $numero_facturas = count($numeros);

        if ($numero_rango == $numero_facturas) {
            if (!($numeros[0]['fac_numero'] == $hasta)) {
                $numero_valido = 1;
                $caso = 3;
            } else {
                $numero_valido = 3;
            }
        }

        $rangos = $this->gsatelite->get_tabla('cxj_correlativoxcaja', array('cxj_id_cof' => $serie));

        foreach ($rangos as $ran) {
            if ($ran['cxj_id'] != $correlativo) {
                if ($desde > $ran['cxj_inicio'] && $hasta < $ran['cxj_fin']) { //Rango intermedio
                    echo json_encode(array('resp' => 1, 'numero_valido' => $numero_valido));
                    die();
                } elseif ($desde < $ran['cxj_inicio'] && $hasta > $ran['cxj_inicio']) { //Rango menor que inicio y menor que fin
                    echo json_encode(array('resp' => 1, 'numero_valido' => $numero_valido));
                    die();
                } elseif ($desde < $ran['cxj_fin'] && $hasta > $ran['cxj_fin']) { //Rango menor que fin y mayor a fin
                    echo json_encode(array('resp' => 1, 'numero_valido' => $numero_valido));
                    die();
                } elseif ($desde < $ran['cxj_inicio'] && $hasta > $ran['cxj_fin']) { //Rango dejando adentro cualquier serie
                    echo json_encode(array('resp' => 1, 'numero_valido' => $numero_valido));
                    die();
                } elseif ($desde > $hasta) {
                    echo json_encode(array('resp' => 1, 'numero_valido' => $numero_valido));
                    die();
                }
            }
        }

        $rangos2 = $this->gsatelite->get_tabla('cof_correlativo_factura', array('cof_id' => $serie, 'cof_estado' => 1));
        foreach ($rangos2 as $ran2) {
            if ($desde >= $ran2['cof_inicio'] && $hasta <= $ran2['cof_fin']) {
                echo json_encode(array('resp' => 0, 'numero_valido' => $numero_valido, 'caso' => $caso));
                die();
            } elseif ($desde <= $ran2['cof_inicio'] && $hasta >= $ran2['cof_inicio']) {
                echo json_encode(array('resp' => 1, 'numero_valido' => $numero_valido));
                die();
            } elseif ($desde <= $ran2['cof_fin'] && $hasta >= $ran2['cof_fin']) {
                echo json_encode(array('resp' => 1, 'numero_valido' => $numero_valido));
                die();
            } elseif ($desde <= $ran2['cof_inicio'] && $hasta >= $ran2['cof_fin']) {
                echo json_encode(array('resp' => 1, 'numero_valido' => $numero_valido));
                die();
            } elseif ($desde >= $ran2['cof_fin'] && $hasta >= $ran2['cof_fin']) {
                echo json_encode(array('resp' => 1, 'numero_valido' => $numero_valido));
                die();
            } elseif ($desde >= $hasta) {
                echo json_encode(array('resp' => 1, 'numero_valido' => $numero_valido));
                die();
            }
        }
    }

    /**
     *@author: Francisco Orozco
     *Fecha: 11/10/2018
     *Descripción: Mantenimiento de gestion_rifas.
     */
    public function gestion_rifas()
    {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();

        $crud = new grocery_CRUD;
        $alias = array(
            'crf_fecha_inicio'  => 'Fecha inicio',
            'crf_fecha_fin'     => 'Fecha fin',
            'crf_monto_inicio'  => 'Monto',
            'crf_estado'        => 'Estado',
            'crf_observacion'   => 'Observación'
        );

        $colums = array(
            'crf_fecha_inicio',
            'crf_fecha_fin',
            'crf_monto_inicio',
            'crf_observacion',
            'Sucursal',
            'crf_estado',
        );

        $edit = array(
            'crf_fecha_inicio',
            'crf_monto_inicio',
            'crf_observacion',
            'crf_fecha_fin',
            'crf_estado',
            'Sucursal',
            'crf_usu_modificacion',
            'crf_fecha_modificacion'
        );

        $add = array(
            'crf_fecha_inicio',
            'crf_monto_inicio',
            'crf_observacion',
            'crf_fecha_fin',
            'crf_estado',
            'Sucursal',
            'crf_usu_modificacion',
            'crf_fecha_modificacion',
            'crf_usu_creacion',
            'crf_fecha_creacion',
            'crf_id_usu'
        );

        $required = array(
            'crf_fecha_inicio',
            'crf_fecha_fin',
            'crf_monto_inicio',
            'crf_estado',
            'crf_usu_modificacion',
            'crf_fecha_modificacion'
        );

        $auditoria_array['rxs_estado']              = 1;
        $auditoria_array['rxs_usu_creacion']        = $this->tank_auth->get_user_id();
        $auditoria_array['rxs_usu_modificacion']    = $this->tank_auth->get_user_id();
        $auditoria_array['rxs_fecha_creacion']      = date('Y-m-d H:i:s');
        $auditoria_array['rxs_fecha_modificacion']  = date('Y-m-d H:i:s');

        $crud->set_table('crf_configuracion_rifa')
            ->set_subject('Tacos de Rifas')
            ->display_as($alias)
            ->columns($colums)
            ->add_fields($add)
            ->edit_fields($edit)
            ->required_fields($required)
            ->field_type('crf_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
            ->field_type('crf_fecha_modificacion', 'hidden', date('Y-m-d h:i:s'))
            ->set_relation_n_n('Sucursal', 'rxs_rifaxsucursal', 'suc_sucursal', 'rxs_id_crf', 'rxs_id_suc', 'suc_nombre', null, array(), $auditoria_array);
        $urlx = explode('/', uri_string());
        if (end($urlx) == 'add') {
            $crud->field_type('crf_estado', 'hidden', 1)
                ->field_type('crf_id_usu', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('crf_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('crf_fecha_creacion', 'hidden', date('Y-m-d h:i:s'));
        } else {
            $crud->field_type('crf_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

        $crud->callback_column('crf_fecha_inicio', function ($value, $row) {
            return formatear_fecha('d-m-Y', $value);
        });

        $crud->callback_column('crf_fecha_fin', function ($value, $row) {
            return formatear_fecha('d-m-Y', $value);
        });

        // Validaciones
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }
        if (!$permisos['permite_editar']) {
            $crud->unset_edit();
        }
        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }
        if ($permisos['permite_ver']) {
            $crud->add_action('Ver', 'minia-icon-search', 'facturacion/entradas/gestion_rifas/read');
        }

        $output = $crud->render();
        $data['titulo_personal'] = "Gestión de tacos de rifas";
        $this->_cargarvista($data, $output);
    }

    /**
     *@author: Luis Navarro
     *Fecha: 2018/11/07
     *Descripción: Verificar si la lista de precios esta asociado a factura o cotizacion
     */
    public function verificar_precio_lista_asociado(){
        if ($this->input->post()) {
            $lista_precio = $this->input->post("lista_precio");
            $retornar = 0;
            $cantidad_lip_def = $this->gsatelite->get_tabla("def_detalle_fact", array("def_id_lip" => $lista_precio));
            $cantidad_lip_cot = $this->gsatelite->get_tabla("axc_articuloxcotizacion", array("axc_id_lip" => $lista_precio));
            if (count($cantidad_lip_def) > 0 || count($cantidad_lip_cot)  > 0) {
                $retornar = 1;
            }
            echo json_encode(array("lista_precio_asociado" => $retornar));
            die();
        }
    }

    function _cargarvista($data = 0, $crud = 0)
    {
        $this->load->view('vacia', $crud);
        if ($data != 0)
            $data = array_merge($data, $this->masterpage->getUsuario());
        else
            $data = $this->masterpage->getUsuario();
        $vista = $data['modulo'] . '/' . $data['control'] . '/' . $data['funcion'];
        $this->masterpage->setMasterPage('masterpage_default');
        $this->masterpage->addContentPage($vista, 'content', $data);
        $this->masterpage->show();
    }

    /**
     *@author: Raul Escalante
     *Fecha: 2019/07/22
     *Descripción: Verificar si el usuario tiene permiso para agregar un nuevo cliente
     */
    public function get_permisos_cli()
    {
        satelite_validar();
        $permisos        = $this->gsatelite->get_permisos_opcion("facturacion/entradas/clientes");
        $permite_agregar = (int) $permisos['permite_agregar'];
        echo json_encode(array('permiso' => $permite_agregar));
    }

    /**
     * @author René Castaneda - Grupo Satélite
     * @since 2019-08-26
     * @return Gestión de archivos.
     * Descripción:
     * Función para hacer una jerarquia de archivos
     */
    public function gestion_archivos_cierre()
    {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion('gestion_archivos_cierre');
        $data['titulo_personal'] = "Gestión de Archivos";
        cargarvista($data);
    }

    /**
     * @author René Castaneda - Grupo Satélite
     * @since 2019-08-26
     * @return Gestión de archivos.
     * Descripción:
     * Función para navegar entre archivos
     */
    public function navegador_archivos()
    {
        satelite_validar();
        $data['titulo_personal'] = "Navegador Archivos";
        $this->gsatelite->cargar_vista_masterpage('facturacion/entradas/navegador_archivos', $data);
        //cargarvista($data);
    }

    /**
     * Descripción:
     * Función para dar mantenimiento a las promociones (tabla: pmp_promocion_producto)
     * @author Herberth Lucho - Grupo satélite
     * @since  2019-08-23
     * @param  Ninguno
     * @return Mantenimiento de promociones
     */
    public function promociones()
    {
        satelite_validar();

        try {
            $permisos = $this->gsatelite->get_permisos_opcion();
            $crud = new grocery_CRUD();

            $columnas = array(
                'pmp_codigo',
                'pmp_fecha_inicio',
                'pmp_fecha_fin',
                'pmp_nombre',
                'pmp_precio',
                'Categorias',
                'pmp_estado'
            );

            $alias = array(
                'pmp_codigo' => 'Código',
                'pmp_fecha_inicio' => 'Fecha inicio',
                'pmp_fecha_fin' => 'Fecha fin',
                'pmp_nombre' => 'Nombre',
                'pmp_precio' => 'Precio',
                'pmp_estado' => 'Estado'
            );

            $crud->set_table('pmp_promocion_producto')
                ->set_subject('Promociones')
                ->columns($columnas)
                ->display_as($alias)
                ->set_relation_n_n('Categorias', 'pmt_promocion_tipo_articulo', 'tia_tipo_articulo', 'pmt_id_pmp', 'pmt_id_tia', 'tia_nombre')
                ->field_type('pmp_fecha_inicio', 'date', date('d-m-Y'))
                ->field_type('pmp_fecha_fin', 'date', date('d-m-Y'))
                ->field_type('arf_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('arf_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
                ->field_type('arf_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
                ->field_type('arf_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('pmp_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'))
                ->add_action('Editar', '', "facturacion/entradas/editar_promociones", 'icomoon-icon-pencil-5')
                ->add_action('Eliminar', 'icon16 icomoon-icon-remove', 'facturacion/entradas/eliminar_promociones', 'eliminar_promocion')
                ->unset_add()
                ->unset_edit()
                ->unset_read()
                ->unset_delete();

            $urlx = explode('/', uri_string());
            if (end($urlx) == 'add') {
                $crud->field_type('arf_estado', 'hidden', 1);
            } else {
                $crud->field_type('arf_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            // Validaciones
            /*if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if (!$permisos['permite_ver']) {
                $crud->unset_read();
            } else {
                $data_url = $this->masterpage->getUsuario();
                $url_read = $data_url['modulo'] . '/' . $data_url['control'] . '/' . $data_url['funcion'];
                $crud->add_action('Ver', 'minia-icon-search', $url_read."/read");
            }*/

            $output = $crud->render();
            $data['titulo_personal'] = "Áreas de Facturación";

            cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    function ingresar_promociones()
    {
        satelite_validar();
        //$permisos = $this->gsatelite->get_permisos_opcion('facturacion/entradas/mantenimiento_caja');        

        if ($this->input->post()) {
            $codigo = (trim($this->input->post('codigo')) != "") ? $this->input->post('codigo') : null;
            $fecha_inicio = $this->input->post('fecha_inicio');
            $fecha_fin = $this->input->post('fecha_fin');
            $pmp_nombre = ($this->input->post('nombre') != "") ? $this->input->post('nombre') : null;
            $pmp_descripcion = ($this->input->post('descripcion') != "") ? $this->input->post('descripcion') : null;
            $pmp_porcentaje = ($this->input->post('porcentaje') > 0) ? $this->input->post('porcentaje') : null;
            $pmp_precio = ($this->input->post('precio') > 0) ? $this->input->post('precio') : null;
            $pmp_cantidad_desde = ($this->input->post('cantidad_desde') > 0) ? $this->input->post('cantidad_desde') : null;
            $pmp_cantidad_hasta = ($this->input->post('cantidad_hasta') > 0) ? $this->input->post('cantidad_hasta') : null;

            $categorias     = ($this->input->post('slc_categorias') != "") ? $this->input->post('slc_categorias') : null;
            $unidad_medida  = ($this->input->post('slc_unidad_medida') != "") ? $this->input->post('slc_unidad_medida') : null;
            $productos      = ($this->input->post('slc_productos') != "") ? $this->input->post('slc_productos') : null;            
            $columnas_insert = array(
                'pmp_codigo'            => $codigo,
                'pmp_id_mep'            => $unidad_medida,
                'pmp_fecha_inicio'      => formatear_fecha('Y-m-d', $fecha_inicio),
                'pmp_fecha_fin'         => formatear_fecha('Y-m-d', $fecha_fin),
                'pmp_nombre'            => $pmp_nombre,
                'pmp_descripcion'       => $pmp_descripcion,
                'pmp_cantidad_desde'    => $pmp_cantidad_desde,
                'pmp_cantidad_hasta'    => $pmp_cantidad_hasta,
                'pmp_precio'            => $pmp_precio,
                'pmp_estado'            => 1,
                'pmp_porcentaje'        => $pmp_porcentaje,
                'pmp_usu_creacion'      => $this->tank_auth->get_user_id(),
                'pmp_fecha_creacion'    => date('Y-m-d H:i:s'),
                'pmp_usu_modificacion'  => $this->tank_auth->get_user_id(),
                'pmp_fecha_modificacion'=> date('Y-m-d H:i:s')
            );          

            $promocion_id = $this->gsatelite->ingresar('pmp_promocion_producto', $columnas_insert);
            foreach ($productos as $producto) {
                $columnas_insert_pma = array(
                    'pma_id_pmp'            => $promocion_id,
                    'pma_id_art'            => $producto,
                    'pma_estado'            => 1,
                    'pma_usu_creacion'      => $this->tank_auth->get_user_id(),
                    'pma_fecha_creacion'    => date('Y-m-d H:i:s'),
                    'pma_usu_modificacion'  => $this->tank_auth->get_user_id(),
                    'pma_fecha_modificacion'=> date('Y-m-d H:i:s')
                );

                $this->gsatelite->ingresar('pma_promocion_articulo', $columnas_insert_pma);
            }

            foreach ($categorias as $categoria) {
                $columnas_insert_pmt = array(
                    'pmt_id_pmp'            => $promocion_id,
                    'pmt_id_tia'            => $categoria,
                    'pmt_estado'            => 1,
                    'pmt_usu_creacion'      => $this->tank_auth->get_user_id(),
                    'pmt_fecha_creacion'    => date('Y-m-d H:i:s'),
                    'pmt_usu_modificacion'  => $this->tank_auth->get_user_id(),
                    'pmt_fecha_modificacion'=> date('Y-m-d H:i:s')
                );

                $this->gsatelite->ingresar('pmt_promocion_tipo_articulo', $columnas_insert_pmt);
            }

            // Mostrar alerta
            if ($promocion_id > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro de promocion", 'texto_alerta' => "El registro se guardó correctamente.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro de promocion", 'texto_alerta' => "El registro no se guardó.");
            }

            $this->session->set_flashdata($alerta);
            $redireccion = $this->input->post("btnCrear");

            if ($redireccion == 1) {
                redirect('facturacion/entradas/ingresar_promociones');
            } else if ($redireccion == 2) {
                redirect('facturacion/entradas/promociones');
            }
            die();
        } else {
            $data['categorias']     = $this->facturacion_model->get_categorias();
            $data['unidad_medida']  = $this->facturacion_model->get_unidad_medida();
            $codigo                 = ($this->gsatelite->get_max("pmp_promocion_producto", "pmp_id")) + 1;
            $data['codigo']         = str_pad($codigo, 5, "0", STR_PAD_LEFT);
            $data['titulo_personal'] = 'Agregar Promoción';
            $this->_cargarvista($data);
        }
    }

    /**
     * @Descripcion
     * metodo para mostrar productos por unidad de medida con ajax
     * 
     * @author Herberth Lucho
     * @since archivo disponible desde 2019-08-30
     * @param integer el Id de la unidad de medida
     * @return los productos segun las categorias seleccionadas y agrupadas por unidad de medida
     * 
     **/
    public function get_productos_promociones()
    {
        $where['cva_id_mep']= $this->input->post('unidad_medida');
        $categorias         = $this->input->post('categorias'); 
    
        $where_in['tia_id'] = implode(",", $categorias);           
        $result             = $this->facturacion_model->get_productos_promociones($where,$where_in);        
        echo json_encode($result);
    }

    public function editar_promociones($promocion_id)
    {
        satelite_validar();
       
        //print_r(number_format($data_promociones[0]['pmp_cantidad_desde'], 0));die();
        if ($this->input->post()) {
            $codigo = (trim($this->input->post('codigo')) != "") ? $this->input->post('codigo') : null;
            $fecha_inicio = $this->input->post('fecha_inicio');
            $fecha_fin = $this->input->post('fecha_fin');
            $pmp_nombre = ($this->input->post('nombre') != "") ? $this->input->post('nombre') : null;
            $pmp_descripcion = ($this->input->post('descripcion') != "") ? $this->input->post('descripcion') : null;
            $pmp_porcentaje = ($this->input->post('porcentaje') != "") ? $this->input->post('porcentaje') : null;
            $pmp_precio = ($this->input->post('precio') > 0) ? $this->input->post('precio') : null;
            $pmp_cantidad_desde = ($this->input->post('cantidad_desde') > 0) ? $this->input->post('cantidad_desde') : null;
            $pmp_cantidad_hasta = ($this->input->post('cantidad_hasta') > 0) ? $this->input->post('cantidad_hasta') : null;

            $categorias = ($this->input->post('slc_categorias') != "") ? $this->input->post('slc_categorias') : null;
            $unidad_medida = ($this->input->post('slc_unidad_medida') != "") ? $this->input->post('slc_unidad_medida') : null;
            $productos = ($this->input->post('slc_productos') != "") ? $this->input->post('slc_productos') : null;

            $columnas_insert = array(
                'pmp_codigo' => $codigo,
                'pmp_id_mep' => $unidad_medida,
                'pmp_fecha_inicio' => formatear_fecha('Y-m-d', $fecha_inicio),
                'pmp_fecha_fin' => formatear_fecha('Y-m-d', $fecha_fin),
                'pmp_nombre' => $pmp_nombre,
                'pmp_descripcion' => $pmp_descripcion,
                'pmp_cantidad_desde' => $pmp_cantidad_desde,
                'pmp_cantidad_hasta' => $pmp_cantidad_hasta,
                'pmp_precio' => $pmp_precio,
                'pmp_estado' => 1,
                'pmp_porcentaje' => $pmp_porcentaje,
                'pmp_usu_creacion' => $this->tank_auth->get_user_id(),
                'pmp_fecha_creacion' => date('Y-m-d H:i:s'),
                'pmp_usu_modificacion' => $this->tank_auth->get_user_id(),
                'pmp_fecha_modificacion' => date('Y-m-d H:i:s')
            );

            $resultado = $this->gsatelite->actualizar_array('pmp_promocion_producto', $columnas_insert, array('pmp_id' => $promocion_id));
            $this->gsatelite->borrado_general('pma_promocion_articulo', array('pma_id_pmp' => $promocion_id));
            foreach ($productos as $value) {
                $columnas_insert_pma = array(
                    'pma_id_pmp' => $promocion_id,
                    'pma_id_art' => $value,
                    'pma_estado' => 1,
                    'pma_usu_creacion' => $this->tank_auth->get_user_id(),
                    'pma_fecha_creacion' => date('Y-m-d H:i:s'),
                    'pma_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'pma_fecha_modificacion' => date('Y-m-d H:i:s')
                );

                $this->gsatelite->ingresar('pma_promocion_articulo', $columnas_insert_pma);
            }

            $this->gsatelite->borrado_general('pmt_promocion_tipo_articulo', array('pmt_id_pmp' => $promocion_id));
            foreach ($categorias as $value) {
                $columnas_insert_pmt = array(
                    'pmt_id_pmp' => $promocion_id,
                    'pmt_id_tia' => $value,
                    'pmt_estado' => 1,
                    'pmt_usu_creacion' => $this->tank_auth->get_user_id(),
                    'pmt_fecha_creacion' => date('Y-m-d H:i:s'),
                    'pmt_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'pmt_fecha_modificacion' => date('Y-m-d H:i:s')
                );

                $this->gsatelite->ingresar('pmt_promocion_tipo_articulo', $columnas_insert_pmt);
            }

            // Mostrar alerta
            if ($resultado > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro de promocion", 'texto_alerta' => "El registro se guardó correctamente.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro de promocion", 'texto_alerta' => "El registro no se guardó.");
            }

            $this->session->set_flashdata($alerta);
            $redireccion = $this->input->post("btnCrear");

            if ($redireccion == 1) {
                redirect('facturacion/entradas/editar_promociones/' . $promocion_id);
            } else if ($redireccion == 2) {
                redirect('facturacion/entradas/promociones');
            }
            die();
        } else {
            $data['unidad_medida']  = $this->facturacion_model->get_unidad_medida();
            //$permisos = $this->gsatelite->get_permisos_opcion('facturacion/entradas/mantenimiento_caja');
            $decimales              = $this->gsatelite->get_parametro('NUMERO_DECIMALES', 2);    
            $data_promociones       = $this->gsatelite->get_tabla('pmp_promocion_producto', array('pmp_estado' => 1, 'pmp_id' => $promocion_id));
            $data['categorias']     = $this->facturacion_model->get_categorias();
            $data['id_promocion']   = $data_promociones[0]['pmp_id'];
            $data['codigo']         = $data_promociones[0]['pmp_codigo'];
            $data['fechainicio']    = $data_promociones[0]['pmp_fecha_inicio'];
            $data['fechafin']       = $data_promociones[0]['pmp_fecha_fin'];
            $data['fechafin']       = $data_promociones[0]['pmp_fecha_fin'];
            $data['nombre']         = $data_promociones[0]['pmp_nombre'];
            $data['porcentaje_pro'] = number_format($data_promociones[0]['pmp_porcentaje'], $decimales,'.','');
            $data['descripcion_pro']= $data_promociones[0]['pmp_descripcion'];
            $data['desde']          = number_format($data_promociones[0]['pmp_cantidad_desde'], $decimales,'.','');
            $data['hasta']          = number_format($data_promociones[0]['pmp_cantidad_hasta'], $decimales,'.','');
            $data['precio']         = number_format($data_promociones[0]['pmp_precio'], $decimales,'.','');
            $data['estado']         = $data_promociones[0]['pmp_estado'];
            $data['medida']         = $data_promociones[0]['pmp_id_mep'];            
    
            $categorias = $this->facturacion_model->get_categorias();
            $data_categorias = $this->facturacion_model->get_categoria_promocion(array('pmt_id_pmp' => $promocion_id));
            $prod_categorias = array();
            foreach ($data_categorias as $data_categoria => $value) {
                $prod_categorias[$value['tia_id']] = $value['tia_id'];
            }
    
            $data['prod_categorias'] = $prod_categorias;
            $data['categorias'] = $categorias;
    
            $articulos = $this->facturacion_model->get_articulos_promos();
            $data_productos = $this->facturacion_model->get_productos_promociones_categoria_unidadmedida(array('pmp_id' => $promocion_id));
            $products = array();
            foreach ($data_productos as $data_producto => $value) {
                $products[$value['art_id']] = $value['art_id'];
            }
    
            $data['productos']      = $articulos;
            $data['products']       = $products;
            $data['decimales']      = $decimales; 
            $data['titulo_personal']= 'Editar Promoción';
            cargarvista($data, 0, 'facturacion/entradas/editar_promociones');
        }
    }

    /**
     * @author Herberth Lucho
     * @since  2019-09-04
     * @param  id_promocion
     * @return Mensaje de confirmacion si es posible eliminar la promocion o se rechaza al estar en algun proceso ya relacionado
     */
    public function  eliminar_promociones()
    {
        satelite_validar();
        $id  =  $this->input->post('promocion_id');

        $movimientos = $this->db->query('CALL eliminar_promocion(?)', array($id))->result_array();
        clean_mysqli_connection($this->db->conn_id);
        if ($movimientos[0]['Code'] == 1451) {
            echo json_encode(array('respuesta' => 0));
            die();
        } else {
            echo json_encode(array('respuesta' => 1));
        }
    }
}

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */
