<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Correlativo extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();
		//$this->load->model('utm_model');
	  //$this->load->model('consultas');
		//$this->load->model('gsatelite');
		$this->load->library('grocery_CRUD');
		$this->load->library('Procesos');
   $this->load->model('consultas');
   $this->load->model('personal_model');
   $this->load->library('tank_auth');
		//$this->driver =  $this->planilla_model;
 }
 public function index()
 {
  if (!$this->tank_auth->is_logged_in())
  {
    redirect('/auth/login/');
  } else
  {
    $this->_cargarvista();
  }
}


function parentesco()
{
   if (!$this->tank_auth->is_logged_in()) {
    redirect('/auth/login/');
  } else { 
    $crud =  new grocery_CRUD();
    $crud->set_subject('Parentescos')->set_table('pat_parentesco');
    $crud->columns('pat_nombre', 'pat_estado');
    $crud->display_as('pat_nombre', 'Nombre')
    ->display_as('pat_estado', 'Estado');
    $crud->fields('pat_nombre', 'pat_estado','pat_usu_mod','pat_fecha_mod');
    $crud->required_fields('pat_nombre','pat_estado');
    $crud->field_type('pat_fecha_mod','hidden',date('Y-m-d H:i:s'));
    $crud->field_type('pat_usu_mod','hidden',$this->tank_auth->get_user_id());
    $crud->field_type('pat_estado','dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
    $crud->set_rules('pat_nombre','Nombre','trim|required|campo_unico[pat_parentesco.pat_nombre]');
    $output = $crud->render();
    $data['titulo_personal']="Parentescos";
    $this->_cargarvista($data, $output);
  }
}

function tipo_carga_archivo()
{
   if (!$this->tank_auth->is_logged_in()) {
    redirect('/auth/login/');
  } else { 
    $crud =  new grocery_CRUD();
    $crud->set_subject('Archivo de configuración')->set_table('tac_tipo_carga');
    $crud->columns('tac_nombre','tac_estado');
    $crud->display_as('tac_nombre', 'Nombre');
    $crud->display_as('tac_estado', 'Estado');
    $crud->fields('tac_nombre','tac_estado','tac_fecha_mod','tac_usu_mod');
    $crud->required_fields('tac_nombre','tac_estado');
    $crud->field_type('tac_fecha_mod','hidden',date('Y-m-d H:i:s'));
    $crud->field_type('tac_usu_mod','hidden',$this->tank_auth->get_user_id());
    $crud->field_type('tac_estado','dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
    $crud->set_rules('tac_nombre','Nombre','trim|required|campo_unico[tac_tipo_carga.tac_nombre]');
    $output = $crud->render();
    $data['titulo_personal']="Archivo de configuración";
    $this->_cargarvista($data, $output);
  }
}

function profesion()
  {
    if (!$this->tank_auth->is_logged_in()) {
      redirect('/auth/login/');
    } else {
      $crud = new grocery_CRUD();
      $crud->set_subject('Profesión');
      $crud->set_table('pro_profesion');
      $crud->display_as('pro_nombre','Nombre')
         ->display_as('pro_estado','Estado')
         ->add_fields('pro_nombre','pro_estado', 'pro_usu_mod', 'pro_fecha_mod')
         ->edit_fields('pro_nombre','pro_estado', 'pro_usu_mod', 'pro_fecha_mod')
         ->columns('pro_nombre','pro_estado')
         ->required_fields('pro_nombre','pro_estado')
         ->set_rules('pro_nombre','Nombre','campo_unico[pro_profesion.pro_nombre]|required')
         ->field_type('pro_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                 ->field_type('pro_usu_mod', 'hidden', $this->tank_auth->get_user_id());

        if(end(explode('/',uri_string()))=='add') {
                $crud->field_type('pro_estado','hidden',1);
                }
                else {
                $crud->field_type('pro_estado','dropdown', array('1' => 'Activado', '0' => 'Desactivado'));
                }
      $output=$crud->render();
      $data['titulo_personal']="Profesiones";
      $this->_cargarvista($data,$output);

    }
  }

function area_empresa()
{
  if (!$this->tank_auth->is_logged_in()) {
    redirect('/auth/login/');
  } else { 
    $crud =  new grocery_CRUD();
    $crud->set_subject('Área')->set_table('are_area');
    $crud->columns('are_nombre');
    $crud->display_as('are_nombre', 'Nombre');
    $crud->fields('are_nombre');
    $crud->required_fields('are_nombre');
    $crud->set_rules('are_nombre','Nombre','trim|required|campo_unico[are_area.are_nombre]');
    $output = $crud->render();
    $data['titulo_personal']="Áreas";
    $this->_cargarvista($data, $output);
  }
}

function tipo_documento()
  {
    if (!$this->tank_auth->is_logged_in()) {
      redirect('/auth/login/');
    } else {
      $crud = new grocery_CRUD();
      $crud->set_subject('Tipo documento');
      $crud->set_table('tde_tipo_documento');
      $crud->display_as('tde_nombre','Nombre')
         ->display_as('tde_estado','Estado')
         ->fields('tde_nombre','tde_estado','tde_usu_mod','tde_fecha_mod')
         ->columns('tde_nombre','tde_estado')
         ->required_fields('tde_nombre','tde_estado')
         ->set_rules('tde_nombre','Nombre','campo_unico[tde_tipo_documento.tde_nombre]|required')
         ->field_type('tde_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                 ->field_type('tde_usu_mod', 'hidden', $this->tank_auth->get_user_id());
                 if(end(explode('/',uri_string()))== 'add'){
                  $crud->field_type('tde_estado','hidden',1);
                 }else{
                  $crud->field_type('tde_estado','dropdown',array('1'=>'Activado', '0'=>'Desactivado'));
                 }
      $output=$crud->render();
      $data['titulo_personal']="Tipos de documentos";
      $this->_cargarvista($data,$output);

    }
  }


function puesto()
{
  if (!$this->tank_auth->is_logged_in()) {
    redirect('/auth/login/');
  } else {      
    $crud =  new grocery_CRUD();
    $crud->set_subject('Puesto')->set_table('pto_puesto');
    $crud->columns('pto_nombre', 'pto_estado');
    $crud->display_as('pto_nombre', 'Nombre')
    ->display_as('pto_estado', 'Estado')
    ->display_as('pto_id_tpt', 'Tipo de puesto');
    $crud->fields('pto_nombre','pto_id_tpt', 'pto_estado');
    $crud->required_fields('pto_nombre','pto_estado');
    $crud->field_type('pto_estado','dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
    $crud->set_rules('pto_nombre','Nombre','trim|required|campo_unico[pto_puesto.pto_nombre]');
    $crud->set_relation('pto_id_tpt','tpt_tipo_puesto','tpt_nombre');
    $output = $crud->render();
    $this->_cargarvista(null, $output);
  }
}
function sucursal()
{
  if (!$this->tank_auth->is_logged_in()) {
    redirect('/auth/login/');
  } else {      
    $crud =  new grocery_CRUD();
    $crud->set_subject('Sucursal')->set_table('suc_sucursal');
    $crud->columns('suc_codigo', 'suc_nombre', 'suc_id_mun');
    $crud->display_as('suc_codigo', 'Código')
    ->display_as('suc_nombre', 'Nombre')
    ->display_as('suc_id_mun', 'Municipio')
    ->display_as('suc_direccion', 'Dirección');
    $crud->fields('suc_codigo','suc_nombre', 'suc_id_mun','suc_usu_mod','suc_fecha_mod','suc_direccion');
    $crud->required_fields('suc_nombre','suc_codigo');
    $crud->set_relation('suc_id_mun','mun_municipio','mun_nombre',array('mun_id_dep' => 9));
    $crud->set_rules('suc_nombre','Nombre','trim|required|campo_unico[suc_sucursal.suc_nombre]');
    $crud->set_rules('suc_codigo','Código','trim|required|campo_unico[suc_sucursal.suc_codigo]');
    $crud->field_type('suc_usu_mod','hidden',$this->tank_auth->get_user_id());
    $crud->field_type('suc_fecha_mod','hidden',date('Y-m-d'));
    $output = $crud->render();
    $this->_cargarvista(null, $output);
  }
}
function tipos_descuento()
{
  if (!$this->tank_auth->is_logged_in()) {
    redirect('/auth/login/');
  }

  $campos = array(
    'tdc_nombre'    => 'Nombre'
    , 'tdc_cuota'     => 'Cuota'
    , 'tdc_id'     => 'ID'
    , 'tdc_porcentaje' => 'Porcentaje'
    , 'tdc_porcentaje_patronal' => 'Aporte Patronal'
    , 'tdc_desde'     => 'Desde'
    , 'tdc_hasta'     => 'Hasta'
    , 'tdc_minimo'    => 'Mínimo'
    , 'tdc_maximo'    => 'Máximo'
    , 'tdc_agrupador' => 'Agrupador'
    //, 'tdc_tipo'      => 'Tipo'
    );

  $columns=array(
    'tdc_id',
    'tdc_nombre',
    'tdc_hasta', 'tdc_agrupador');
  $required_fields=array(
    'tdc_nombre',
    //'tdc_tipo',
    //'tdc_agrupador'
    );

  $crud = new grocery_CRUD();
  $crud->set_table('tdc_tipo_descuento')
  ->set_subject('Descuento')
  ->columns($columns)
  ->fields('tdc_nombre', 'tdc_cuota', 'tdc_porcentaje', 'tdc_desde', 'tdc_hasta', 'tdc_minimo', 'tdc_maximo', 'tdc_agrupador')
  ->required_fields($required_fields)
  ->display_as($campos)
  ->set_rules('tdc_nombre','Nombre','trim|required|campo_unico[tdc_tipo_descuento.tdc_nombre]')
  //->field_type('tdc_tipo', 'dropdown', array(1=>'Monto Definido', 2=> 'Porcentaje', 3=> 'Minimo y Maximo', 4=> 'Renta (min_max+porcentaje)'))
  ->unset_export()
  ->unset_print();
  $crud->set_relation('tdc_agrupador', 'tag_tipo_agrupador', '{tag_nombre}');
  $data['titulo_personal']="TIPO DE DESCUENTO";

  $this->_cargarvista($data, $crud->render());
}
function tipos_ingreso()
{
  if (!$this->tank_auth->is_logged_in()) {
    redirect('/auth/login/');
  }

  $campos = array(
    'tig_id'    => 'ID',
    'tig_codigo'    => 'Código',
    'tig_nombre'    => 'Nombre',
    'tig_cuenta_contable' => 'Cuenta Contable',
    'tig_estado'    => 'Estado',
    'tig_descripcion' => 'Descripción',
    'tig_gravado'=>'Gravado'
    );

  $add_columns=array(
    'tig_codigo',
    'tig_nombre',
    'tig_estado',
    'tig_descripcion',
    'tig_gravado');

  $required_fields=array(
    'tig_codigo',
    'tig_nombre',
    'tig_estado',
    'tig_gravado');


  $crud = new grocery_CRUD();
  $crud->set_table('tig_tipo_ingreso')
  ->set_subject('Ingreso')
  ->columns('tig_id','tig_nombre', 'tig_estado')
  ->display_as($campos)
  ->add_fields($add_columns)
  ->edit_fields($add_columns)
  ->required_fields($required_fields)
  //->field_type( 'tig_estado' , 'dropdown', array(0=>'Inactivo', 1=> 'Activo'))
  ->field_type( 'tig_gravado' , 'dropdown', array(0=>'No aplica', 1=> 'Aplica'))
  ->set_rules('tig_nombre','Nombre','trim|required|campo_unico[tig_tipo_ingreso.tig_nombre]')
  ->set_rules('tig_codigo','Código','trim|required|campo_unico[tig_tipo_ingreso.tig_codigo]');
   if(end(explode('/',uri_string()))=='add') {
  $crud->field_type('tig_estado','hidden',1);
  }
  else {
  $crud->field_type('tig_estado','dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
  } 
  $data['titulo_personal']="TIPO DE INGRESO";
  $this->_cargarvista($data, $crud->render());
}



function afp()
{
  if (!$this->tank_auth->is_logged_in()) {
    redirect('/auth/login/');
  } else {      
    $crud =  new grocery_CRUD();
    $crud->set_subject('AFP')->set_table('afp_afp');
    $crud->columns('afp_nombre', 'afp_porcentaje', 'afp_activo');
    $crud->display_as('afp_nombre', 'Nombre')
    ->display_as('afp_porcentaje', 'Porcentaje descuento')
    ->display_as('afp_activo', 'Activo')
    ->display_as('afp_porcentaje_patrono', 'Porcentaje patrono')
    ->display_as('afp_maximo', 'Máximo');
    $crud->fields('afp_nombre','afp_porcentaje', 'afp_porcentaje_patrono','afp_maximo','afp_activo');
    $crud->required_fields('afp_nombre','afp_porcentaje_patrono', 'afp_porcentaje','afp_activo', 'afp_maximo');
    //$crud->field_type( 'afp_activo' , 'true_false');             
    $crud->unset_delete();
    $crud->set_rules('afp_nombre','Nombre','trim|required|campo_unico[afp_afp.afp_nombre]');
     if(end(explode('/',uri_string()))=='add') {
    $crud->field_type('afp_activo','hidden',1);
    }
    else {
    $crud->field_type('afp_activo','dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
    } 
    $output = $crud->render();
    $this->_cargarvista(null, $output);
  }
}
function isr(){
  if (!$this->tank_auth->is_logged_in()) {
    redirect('/auth/login/');
  } else {

    $crud = new grocery_CRUD;
    $crud =  new grocery_CRUD();
    $crud->set_subject('ISR')->set_table('isr_isr');
    $crud->columns('isr_desc', 'isr_desde','isr_hasta', 'isr_porcentaje','isr_exceso','isr_cuota','isr_id_tis');
    $crud->display_as('isr_id_tis','Tipo tabla');
    $crud->display_as('isr_desc','ISR');
    $crud->display_as('isr_desde','Desde');
    $crud->display_as('isr_hasta','Hasta');
    $crud->display_as('isr_porcentaje','Porcentaje');
    $crud->display_as('isr_exceso','Exceso');
    $crud->display_as('isr_cuota','Cuota');
    $crud->required_fields('isr_desc', 'isr_desde','isr_hasta', 'isr_porcentaje','isr_exceso','isr_cuota'); 
    $crud->fields('isr_id_tis', 'isr_desc', 'isr_desde','isr_hasta', 'isr_porcentaje','isr_exceso','isr_cuota');
    $crud->order_by('isr_id_tis');
    $crud->unset_delete();
    $crud->unset_export();
    $crud->unset_print();


    if(($cub_id = $this->input->get('cub_id')) > 0){
      $crud->where(array('isr_id_tis' => $cub_id));


    }

    $crud->set_primary_key('isr_id','isr_isr')
    ->set_relation('isr_id_tis','tis_tipo_isr','cuenta');
    $crud->set_relation('isr_id_tis','tis_tipo_isr','tis_desc');

    $output = $crud->render();
    $cuentas[0] = 'Seleccione';
    foreach($this->db->get('tis_tipo_isr')->result() as $row){
      $cuentas[$row->tis_id] = $row->tis_desc;
    }

    $data = array (
      'cuentas' => $cuentas
      );


    $this->_cargarvista($data, $output);
  }
}
function tipo_isr(){
  if (!$this->tank_auth->is_logged_in()) {
    redirect('/auth/login/');
  } else {

    $crud = new grocery_CRUD;
    $crud =  new grocery_CRUD();
    $crud->set_subject('tipo ISR')->set_table('tis_tipo_isr');
    $crud->columns('tis_desc', 'tis_vigente');
    $crud->display_as('tis_desc', 'Tipo de ISR');
    $crud->display_as('tis_vigente', 'Estado');
    $crud->fields('tis_desc', 'tis_vigente');
    $crud->required_fields('tis_desc', 'tis_vigente');
    $crud->unset_delete();
    $crud->unset_export();
    $crud->unset_print();
    $output = $crud->render();
    $data="";
    $this->_cargarvista($data, $output);
  }
}
function mostrar_correlativo($id)
{
  if (!$this->tank_auth->is_logged_in())
  {
    redirect('/auth/login/');
  } else
  {
    $data['titulo_personal']="Ingresos y descuentos de planilla";
    $data['tpl']=$this->personal_model->get_tabla('tpl_tipo_planilla',array('tpl_id'=>$id));            
    $data['desxpla']=$this->personal_model->get_ing_des('dtp_descuentoxtipo_planilla',array('dtp_id_tpl'=>$id),1);
    $data['descuentos']=$this->personal_model->get_det_ing_des('tdc_tipo_descuento',$data['desxpla'],'dtp_id_tdc','tdc_id','tdc_agrupador');
    $data['ingxpla']=$this->personal_model->get_ing_des('itp_ingresoxtipo_planilla',array('itp_id_tpl'=>$id),2);
   //echo $this->db->last_query(); die();
    $data['ingresos']=$this->personal_model->get_det_ing_des('tig_tipo_ingreso',$data['ingxpla'],'itp_id_tig','tig_id',null);
    if($_POST)
      {  /*print_r($_POST);
        exit(); */
        if($_POST['boton']=='ingreso')
        {
          $ingreso=array(
            'itp_id_tpl'=>(int)$id,
            'itp_id_tig'=>(int)$_POST['ingreso']
            );
          $registro=$this->personal_model->add_regitro('itp_ingresoxtipo_planilla',$ingreso);
          if($registro>0)
            $alerta=array('registro'=>$registro,'tipo_alerta'=> 'success','titulo_alerta'=>"Registro ingresado",'texto_alerta'=>"El registro se ha ingresado correctamente");                
          else
            $alerta=array('tipo_alerta'=> 'error','titulo_alerta'=>"Registro no ingresado",'texto_alerta'=>"El registro no se pudo ingresar verifique la informacion ingresada");
          $this->session->set_flashdata($alerta);       
          redirect('personal/catalogos/ing_des_pla/'.$id);   
        }
        if($_POST['boton']=='descuento')
        {
          $descuento=array(
            'dtp_id_tpl'=>(int)$id,
            'dtp_id_tdc'=>(int)$_POST['descuento']
            );
          $registro=$this->personal_model->add_regitro('dtp_descuentoxtipo_planilla',$descuento);
          if($registro>0)
            $alerta=array('registro'=>$registro,'tipo_alerta'=> 'success','titulo_alerta'=>"Registro ingresado",'texto_alerta'=>"El registro se ha ingresado correctamente");                
          else
            $alerta=array('tipo_alerta'=> 'error','titulo_alerta'=>"Registro no ingresado",'texto_alerta'=>"El registro no se pudo ingresar verifique la informacion ingresada");
          $this->session->set_flashdata($alerta);       
          redirect('personal/catalogos/ing_des_pla/'.$id);
        }
      }
      $this->_cargarvista($data);
    }
  }

  public function eliminar($tipo,$id_tipo,$planilla){

    if($tipo=="ing"){
      $this->db->where('itp_id',$id_tipo)
      ->where('itp_id_tpl',$planilla)
      ->delete('itp_ingresoxtipo_planilla');
      $alerta=array('registro'=>$registro,'tipo_alerta'=> 'success','titulo_alerta'=>"Registro eliminado",'texto_alerta'=>"El registro se ha eliminado correctamente");
      redirect('personal/catalogos/ing_des_pla/'.$planilla);
    }else if($tipo=="des"){
      $this->db->where('dtp_id',$id_tipo)
      ->where('dtp_id_tpl',$planilla)
      ->delete('dtp_descuentoxtipo_planilla');
      $alerta=array('registro'=>$registro,'tipo_alerta'=> 'success','titulo_alerta'=>"Registro eliminado",'texto_alerta'=>"El registro se ha eliminado correctamente");
      redirect('personal/catalogos/ing_des_pla/'.$planilla);
    }else if($tipo=="isr"){
      $this->db->where('txt_id',$id_tipo)
      ->where('txt_id_tpl',$planilla)
      ->delete('txt_tipo_planillaxtipo_isr');
      $alerta=array('registro'=>$registro,'tipo_alerta'=> 'success','titulo_alerta'=>"Registro eliminado",'texto_alerta'=>"El registro se ha eliminado correctamente");
      redirect('personal/catalogos/pla_isr/'.$planilla);
    }
  }

  function pla_isr($id)
  {
    if (!$this->tank_auth->is_logged_in())
    {
      redirect('/auth/login/');
    } else
    {
      $data['titulo_personal']="Planilla por ISR";
      $data['tpl']=$this->personal_model->get_tabla('tpl_tipo_planilla',array('tpl_id'=>$id));            
      $data['isrxpla']=$this->personal_model->get_ing_des('txt_tipo_planillaxtipo_isr',array('txt_id_tpl'=>$id),3);
      $data['isr']=$this->personal_model->get_det_ing_des('tis_tipo_isr',$data['isrxpla'],'txt_id_tis','tis_id');

      if($_POST)
      {
        $ingreso=array(
          'txt_id_tpl'=>(int)$id,
          'txt_id_tis'=>(int)$_POST['isr']
          );
        $registro=$this->personal_model->add_regitro('txt_tipo_planillaxtipo_isr',$ingreso);
        if($registro>0)
          $alerta=array('registro'=>$registro,'tipo_alerta'=> 'success','titulo_alerta'=>"Registro ingresado",'texto_alerta'=>"El registro se ha ingresado correctamente");                
        else
          $alerta=array('tipo_alerta'=> 'error','titulo_alerta'=>"Registro no ingresado",'texto_alerta'=>"El registro no se pudo ingresar verifique la informacion ingresada");
        $this->session->set_flashdata($alerta);       
        redirect('personal/catalogos/pla_isr/'.$id);   
      }
      $this->_cargarvista($data);
    }
  }

  /**
   * @author Boris Estrada
   */
  function agrupadores(){
    $crud = new grocery_CRUD();
    $crud->set_table('tag_tipo_agrupador')
    ->set_subject('Agrupadores')
    ->columns('tag_nombre','tag_tipo', 'tag_estado', 'ingresos', 'descuentos')
    ->fields('tag_nombre','tag_tipo', 'tag_estado', 'ingresos', 'descuentos')
    ->set_rules('tag_nombre','Nombre','trim|required|campo_unico[tag_tipo_agrupador.tag_nombre]')
    ->display_as('tag_estado','Estado')
    ->display_as('tag_tipo','Tipo')->field_type('tag_tipo', 'dropdown', array('C'=>'C', 'R'=>'R'))    /*Falta definir la C y la R*/
    ->display_as('tag_nombre','Nombre')
    ->display_as('tag_descripcion','Descripción')
    ->required_fields('tag_nombre','tag_tipo', 'tag_estado');

    $ingresos = $this->consultas->ingresos();
    $descuentos = $this->consultas->descuentos();
    $crud->set_relation_n_n('ingresos', 'deg_detalle_agrupador', 'tig_tipo_ingreso', 
      'deg_id_tag' ,'deg_id_tig','tig_nombre', null, "tig_id in ($ingresos)");
    $crud->set_relation_n_n('descuentos', 'deg_detalle_agrupador', 'tdc_tipo_descuento', 
      'deg_id_tag' ,'deg_id_tdc','tdc_nombre', null, "tdc_id in ($descuentos)");
    $crud->callback_after_insert(function($post_array,$primary_key){
      $this->personal_model->agrupadores(array('deg_id_tag'=>$primary_key),$primary_key,$post_array);
      return TRUE; 
    });
    $crud->callback_after_update(function($post_array,$primary_key){
      //print_r($post_array); die();
      $this->personal_model->agrupadores(array('deg_id_tag'=>$primary_key),$primary_key,$post_array);
      return TRUE; 
    });
    $crud->unset_delete();
     if(end(explode('/',uri_string()))=='add') {
    $crud->field_type('tag_estado','hidden',1);
    }
    else {
    $crud->field_type('tag_estado','dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
    } 
    $this->_cargarvista(null, $crud->render());
  }

  function _cargarvista($data=0,$crud=0)
  {	
    $this->load->view('vacia',$crud);	
    if($data!=0)
     $data=array_merge($data,$this->masterpage->getUsuario());
   else
     $data=$this->masterpage->getUsuario();
   $vista=$data['modulo'].'/'.$data['control'].'/'.$data['funcion'];
   $this->masterpage->setMasterPage('masterpage_default');
   $this->masterpage->addContentPage($vista, 'content',$data);
   $this->masterpage->show();
 }
}