<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Consultas extends CI_Controller
{
	function __construct()
	{
		parent::__construct();
		$this->load->library('grocery_CRUD');
        $this->load->model('facturacion_model');
		$this->load->library('form_validation');
		      	
	}

	function index()
	{
		if (!$this->tank_auth->is_logged_in()) {
			redirect('/auth/login/');
		} else {			
			$this->_cargarvista();
		}
	}

	/**
	 * Consultas:general_de_cotizaciones
	 * @author René Castaneda
	 * @return Generación de un reporte general de cotizaciones 
	 */
    function facturas($export = 0) {
    	if (!$this->tank_auth->is_logged_in()) {
			redirect('/auth/login/');
		} else {			
        redirect('facturacion/reportes/facturas_reporte');
        $consulta_factura = $this->facturacion_model->get_facturas();
        // $data["facturas"] = $consulta_factura;
         $clientes = $this->gsatelite->get_dropdown('cli_cliente', '{cli_nombre} {cli_apellido}','', array('cli_estado' => '1'), null, '', 'cli_id', true);
         $data["clientes"] = str_replace('<option value="0">Seleccione</option>', '',$clientes);
         $vendedores = $this->gsatelite->get_dropdown('ven_vendedor', '{ven_codigo} {ven_nombre} {ven_apellidos}','', array('ven_estado' => '1'), null, '', 'ven_id', true);
         $data["vendedores"] = str_replace('<option value="0">Seleccione</option>', '',$vendedores);
         $data["titulo_personal"] = "Facturas procesadas";
         $this->_cargarvista($data,null);
       	     }
    }

    public function export_fact_consulta(){
        satelite_validar();
        $tipo = $_POST['btnxprt'];
        $tipo_rep = ($tipo > 1) ? 'pdf' : (($tipo > 0) ? 'exc' : null);
        $this->facturas_consulta($tipo_rep, $_POST['hdn_filtro'], $_POST['hdn_valor'], $_POST['hdn_caja']);
    }

    function facturas_consulta($flag = null, $fltr = null, $vlr = null, $caj = null) { // Se movió a facturación/reportes
        $filtro = ($fltr != null) ? $fltr : $this->input->post('filtro');
        $valor  = ($vlr != null) ? $vlr : $this->input->post('valor');
        $caja   = ($caj != null) ? $caj : $this->input->post('caja');
        $user   = null;      
        if($filtro == 'fac_fecha_fact'){
            $f      = explode('#',$valor);
            $where  = array('date_format(fac_fecha_fact,"%Y-%m-%d") >='=>date('Y-m-d', strtotime($f[0])), 'date_format(fac_fecha_fact,"%Y-%m-%d") <='=>date('Y-m-d', strtotime($f[1])));
        } elseif ($filtro == 'fac_fecha_cont') {
            $f      = explode('#',$valor);
            $where  = array("DATE(fac_fecha_cont) >= " => formatear_fecha('Y-m-d', $f[0]), "DATE(fac_fecha_cont) <= " => formatear_fecha('Y-m-d', $f[1]));
        } else{
            $where  = array("$filtro"=>$valor); // Se quitó el estado ,"fac_estado <> "=>0 para mostrar todas las facturas
        }
        if($caja>0){
            $user = $this->tank_auth->get_user_id();
            $reg_usu = $this->gsatelite->get_tabla('uxc_usuarioxcaja', array('uxc_id_usu'=>$user));
            $uxc_in = array_column($reg_usu, 'uxc_id');
        }     
        if(isset($uxc_in) && count($uxc_in) > 0 && $caja > 0){
            $this->db->where_in('fac_id_uxc', $uxc_in);
        }else if(isset($uxc_in) && count($uxc_in)<=0 && $caja>0){
            $this->db->where('fac_id_uxc', 0);
        }

                            $this->db->join('def_detalle_fact', 'def_id_fac = fac_id', 'INNER');
                            $this->db->group_by('fac_id');
        $consulta_factura = $this->facturacion_model->get_facturas($where);
        $tipo_rep = ($flag != null) ? $flag : "";
        $data["tipo_rep"] = $tipo_rep;
        $data["facturas"] = $consulta_factura;
        $html = $this->load->view('facturacion/consultas/facturas_consulta',$data,true);
        if ($flag != null) {
            if ($tipo_rep != 'exc') {
                $this->load->library('pdf');
                $header = $this->load->view('reporte/header', array('titulo'=>'Facturas'), true);
                $GLOBALS['nombre_reporte']  = 'reporte_facturas' . date('dmY');
                $reporte = $header . $html;
                $this->pdf->makePdf($reporte, 'L', 'reporte_facturas', 'Letter');
            } else {
                echo $html;
            }
        } else {
            echo json_encode(array('resultado'=>$html,'filas'=>count($consulta_factura)));
        }
    }

	function anular_factura()
  {		
    $data["id_fac"] = $this->input->post('factura'); 
    $data['no_anular'] = $this->input->post('sinAnular');
		$data["detalle"] = $this->facturacion_model->get_detalle_factura($data['id_fac']);		    
    $data['factura'] = $this->facturacion_model->get_facturas(array('fac_id'=>$data['id_fac']));		
    $data['factura_info'] = $this->facturacion_model->get_factura_info($data['id_fac']);    
    $vista = $this->load->view("facturacion/consultas/facturas_anuladas",$data,true);
    ob_end_clean();
    echo json_encode(array('resultado'=>$vista));
	}

	function aplica_anulacion($id){ //se movio a facturacion/reportes
		$fecha = date('Y-m-d');
		$motivo = $this->input->post("justificar_anulacion");
		$num_fac = $this->gsatelite->get_tabla('fac_factura', array('fac_id' => $id));
    $num_fac = (count($num_fac) > 0) ? $num_fac[0]['fac_numero'] : '';
    // Verificar si NO hubo descarga
		$factura = $this->gsatelite->get_registro('mxf_movimientoxfact',array('mxf_id_fac'=>$id, 'mxf_estado'=>1));
		

    if(count($factura)>0){

			//$proceso = $this->gsatelite->get_campo('tip_tipo_proceso','tip_id',array('tip_entrada_fac'=>1)); // Proceso que se le pondra
      $proceso = $this->gsatelite->get_campo('tip_tipo_proceso','tip_id_tip_entrada',array('tip_facturacion'=>1,'tip_estado'=>1));
			
      $bodega =  $this->gsatelite->get_campo('moi_movimiento_inv','moi_id_bod', array('moi_id'=>$factura->mxf_id_moi));
			$producto_fila = $this->gsatelite->get_registro('dee_detalle_mov', array('dee_id_moi'=>$factura->mxf_id_moi));
			$array = json_decode(json_encode($producto_fila), true);
			$producto = array();
			$cantidad = array();
			$datos = array();
			
			if(count($producto_fila)==1){
				$producto[] = $array['dee_id_art'];
				$cantidad[] = $array['dee_cantidad'];
			} else {
			foreach ($array as $key => $value) {
				$producto[] = $value['dee_id_art'];
				$cantidad[] = $value['dee_cantidad'];
			 }
			}
			$datos[] = $producto;
			$datos[] = $cantidad;
			$datos[] = $bodega;
			$datos[] = $id;

			$this->ingresar_productos_movimiento(true, $datos, $proceso, $motivo, $id);
		} else 
		{
      /* ======================================================================================================
                                Inicio Partida contable para la anulacion de factura
      =========================================================================================================*/
            $generar_partida = $this->gsatelite->get_parametro('SYS_GENERAR_PARTIDA_FACTURACION');
            if($generar_partida > 0){
                $where['fac_id'] = $id;                            
                $info['num_fac'] = $num_fac;
                $res_debe = $this->generar_partida_anular_factura_afecta_noafecta_inv_debe($where,$info);                
                $this->generar_partida_anular_factura_afecta_noafecta_inv_haber($where, $res_debe['id_pct'], $res_debe['total_debe']);

                //Actualizar el id de la partida contable en la factura, Actualizar la forma de generacion de la partida
                //1= generada a detalle (uno a uno), 2 = Generada en consolidado (partida muchas facturas), null = aun no creada partida
                $this->gsatelite->actualizar_array('fac_factura',array('fac_id_pct_anulacion' => $res_debe['id_pct']),array('fac_id' => $id));                                
            } 
                    
      /* ======================================================================================================
                          Fin Partida contable para la anulacion de factura
      =========================================================================================================*/
			$this->facturacion_model->anular_factura($id, $fecha, $motivo);  // No hubo descarga	
		}

		$alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Actualización de estado",'texto_alerta'=>"Se modificó el estado de la factura exitosamente");
                      
          $this->session->set_flashdata($alerta);
        redirect('facturacion/consultas/facturas');
	}


	  function llamar_datos_row($tabla,$where,$order){
    $query=$this->facturacion_model->cargar_todo($tabla,$where,$order);
    return $query;
  }

  
	public function ingresar_productos_movimiento($ajuste=null,$ingreso=null,$proc_entrada=null,$descript_ajuste=null, $factura=null)
  {
  	 //var_dump($ingreso); die();	
      $flag=0; //Bandera de error
      $parametro=$_POST['parametro'];
      //variables de control (para guardar el id_del detalle y vincularlo con el correlativo indicado en el caso que aplique serie)
      $arregloIDtrProductos = $this->input->post('ids_filaP'); //este arreglo solo llevará los ids de los tr de todos los productos
      $arregloIDtrProductosSeries = $this->input->post('ids_filaS'); //este arreglo solo llevará los ids de los tr que aplicarón serie


      if($ajuste==null){
        $entrada = $_POST['tipo_transaccion'];
        $usuario = $this->tank_auth->get_user_id();
        $bodega=   $_POST['bodega'];
        $proveedor=   $_POST['proveedor'];
        $fecha = date('Y-m-d h:i:s');
        $documento = $_POST['documento'];

        
        $descripcion=   $_POST['descripcion_requisicion'];

        //$caducidad = $_POST['caducidad'];
        $productos = $_POST['productos'];
        $cantidades= $_POST['cantidad'];
        $retaceo=$_POST['retaceo'];
        if($_POST['retaceo'] == ''){
        $precios= $_POST['precios'];
      }else{
         $precios= $_POST['precios1'];

      }

        $p1=$_POST['p1'];
        $u1=$_POST['u1'];
        $p2=$_POST['p2'];
        $u2=$_POST['u2'];
        $p3=$_POST['p3'];
        $u3=$_POST['u3'];
        $p4=$_POST['p4'];
        $u4=$_POST['u4'];
        $p5=$_POST['p5'];
        $u5=$_POST['u5'];
        $n1=$_POST['nombre_precio1'];
        $n2=$_POST['nombre_precio2'];
        $n3=$_POST['nombre_precio3'];
        $n4=$_POST['nombre_precio4'];
        $n5=$_POST['nombre_precio5'];
        $caja = $_POST['caja'];
        $furgon = $_POST['furgon'];
        $cantxcaja=$_POST['cantxcaja'];
        

      }else{
        
        $entrada=$proc_entrada;

        $usuario = $this->tank_auth->get_user_id();

        $bodega = $ingreso[2];

        $fecha = date("Y-m-d H:i:s");
        $documento = '';
        $descripcion= $descript_ajuste;

        //$productos1 = $ingreso[0];      
        
        $productos = $ingreso[0];
        $cantidades= $ingreso[1];

        $precios=array();

        foreach ($productos as $key => $id_prod) {//Conociendo los precios de cada producto

        //$id_prod=$this->db->select('art_id')->where('art_codigo',$id_prod)->get('art_articulo')->result_array();
        
          $saldos=$this->llamar_datos_row("sar_saldo_articulo",array('sar_id_art'=>$productos[$key],'sar_id_bod'=>$bodega/*,'sar_cant_actual !='=>'0'*/),'sar_id ASC');
          
          if(count($saldos)>0){
            $precios= array_merge($precios,array($saldos[0]['sar_precio']));
          }else{
            $flag=1;
          }
       }
        /*$productos=array();
        foreach ($productos1 as $key => $id) {
          $id_producto=$this->db->select('art_id')->where('art_codigo',$id)->get('art_articulo')->result_array();
          array_push($productos,$id_producto[0]['art_id']);
        }*/
      }


      if($flag==0){
       //en este punto se realizara la insercion del movimiento
      ( $proveedor == 0 ) ? $proveedor=NULL : $proveedor;
      if(!empty($retaceo)){
      $ingresar_movimiento = array(
        'moi_retaceo'     =>$retaceo,
        'moi_id_bod'      =>$bodega,
        'moi_id_tip'      =>$entrada->tip_id_tip_entrada,
        'moi_documento'   =>$documento,
        'moi_fecha_mov'   =>$fecha,
        'moi_usr_mod'     =>$usuario,
        'moi_fecha_mod'   =>date('Y-m-d H:i:s'),
        'moi_descripcion' =>$descripcion,
        'moi_id_prv'      =>$proveedor
        );
    }
    else {
      $ingresar_movimiento = array(
        'moi_id_bod'      =>$bodega,
        'moi_id_tip'      =>$entrada->tip_id_tip_entrada,
        'moi_documento'   =>$documento,
        'moi_fecha_mov'   =>$fecha,
        'moi_usr_mod'     =>$this->tank_auth->get_user_id(),
        'moi_fecha_mod'   =>date('Y-m-d H:i:s'),
        'moi_descripcion' =>$descripcion,
        'moi_id_prv'      =>$proveedor
        );
    }

      $id_movimiento = $this->gsatelite->ingresar('moi_movimiento_inv',$ingresar_movimiento);
        
      $ingresar_movxfactura = array(
      	'mxf_id_fac'	=> $ingreso[3],
      	'mxf_id_moi'	=> $id_movimiento,
      	'mxf_tipo'		=> 2,
      	'mxf_estado'	=> 1,
      	'mxf_usu_mod'	=> $this->tank_auth->get_user_id(),
      	'mxf_fecha_mod' => date('Y-m-d H:i:s')
      	);

      $registrar = $this->gsatelite->ingresar('mxf_movimientoxfact',$ingresar_movxfactura);
      // Modificar campos de Factura para la anulacion

      $this->facturacion_model->anular_factura($ingreso[3], $fecha, $descript_ajuste);

      //este bucle repetitivo nos servira para guardar todos los productos anexados a la compra
      $IDsMovimientos = array(); //este arreglo guardará todos los ids que se inserten
      foreach($productos as $key => $id_prod){
        $id_cant = $cantidades[$key];
        $id_precio = $precios[$key];
        $id_cantxcaja = $cantxcaja[$key];

        if(isset($caducidad)){
        $id_caducidad = date('Y-m-d',strtotime($caducidad[$key])); // date('Y-m-d h:i:s', strtotime($_POST['caducidad']));
      }
      if(isset($caja)){
        $id_caja = $caja[$key];
      }

      if(isset($furgon)){
        $id_furgon = $furgon[$key];
      }

      if(isset($p1)){
        $id_precio_venta1=$p1[$key];
      }
      if(isset($u1)){
        $id_unidad_medida1=$u1[$key];
      }

      if(isset($p2)){
        $id_precio_venta2=$p2[$key];
      }

      if(isset($u2)){
        $id_unidad_medida2=$u2[$key];
      }

      if(isset($p3)){
        $id_precio_venta3=$p3[$key];
      }
      if(isset($u3)){
        $id_unidad_medida3=$u3[$key];
      }
      if(isset($p4)){
        $id_precio_venta4=$p4[$key];
      }
      if(isset($u4)){
        $id_unidad_medida4=$u4[$key];
      }
      if(isset($p5)){
        $id_precio_venta5=$p5[$key];
      }
      if(isset($u5)){
        $id_unidad_medida5=$u5[$key];
      }
      if(isset($n1)){
        $id_nombre_precio1=$n1[$key];
      }
      if(isset($n2)){
        $id_nombre_precio2=$n2[$key];
      }
      if(isset($n3)){
        $id_nombre_precio3=$n3[$key];
      }
      if(isset($n4)){
        $id_nombre_precio4=$n4[$key];
      }
      if(isset($n5)){
        $id_nombre_precio5=$n5[$key];
      }
        
        // Esta parte no cuenta aca.
   /*     
      if($this->gsatelite->get_parametro('INV_COSTO_PROMEDIO') == 0){
        $ingresar_saldo = array(  
          'sar_id_art'       =>$id_prod,
          'sar_id_bod'       =>$bodega,
          'sar_cant_actual'  =>$id_cant,
          'sar_precio'       =>$id_precio
        );

        $id_saldo = $this->gsatelite->ingresar('sar_saldo_articulo',$ingresar_saldo);
      }
      else
      { */

        $saldo_actual=$this->db->select()
                               ->from('sar_saldo_articulo')
                               ->where('sar_id_art',$id_prod)
                               ->where('sar_id_bod',$bodega)
                               ->get()->result_array();                	
                               
        if(empty($saldo_actual))
        {
          $precio_actual=0;
          $sar_cant_actual=0;
        }
        else{
          $sar_cant_actual=$saldo_actual[0]['sar_cant_actual'];
          $precio_actual=($saldo_actual[0]['sar_cant_actual'])*($saldo_actual[0]['sar_precio']);
        }
        
        $precio_entrada=$id_cant*$id_precio;
        $cantidad_existencia=$sar_cant_actual+($id_cant);
        $suma_precios=$precio_actual+$precio_entrada;
        $nuevo_precio=$suma_precios/$cantidad_existencia;

        $ingresar_saldo = array(  
          'sar_id_art'       =>$id_prod,
          'sar_id_bod'       =>$bodega,
          'sar_cant_actual'  =>$cantidad_existencia,
          'sar_precio'       =>$nuevo_precio,
          'sar_fecha_caducidad'=>null,
          'sar_usu_mod'       =>$this->tank_auth->get_user_id(),
          'sar_fecha_mod'     =>date('Y-m-d H:i:s')
        );
        if(empty($saldo_actual)){
          $id_saldo = $this->gsatelite->ingresar('sar_saldo_articulo',$ingresar_saldo);
           
        }
        else{
          $id_saldo1=$this->db->where('sar_id',$saldo_actual[0]['sar_id'])->update('sar_saldo_articulo',$ingresar_saldo);
          $id_saldo=$saldo_actual[0]['sar_id'];
         
        }
        
    //  }
    
      if($ajuste==null && $parametro !=0){
        $ingresar_ixc = array(
          'ixc_cantidad_caja'   =>$id_cantxcaja,
          'ixc_contenedor'      => $id_furgon,
          'ixc_caja'            => $id_caja,
          'ixc_cantidad_actual' => $id_cant);
       $id_ixc = $this->gsatelite->ingresar('ixc_ingresoxcontenedor',$ingresar_ixc);
        }


        $ingresar_detalle = array(
          'dee_id_ixc'      =>$id_ixc,  
          'dee_id_moi'      =>$id_movimiento,
          'dee_id_art'      =>$id_prod,
          'dee_id_sar'      =>$id_saldo,
          'dee_cantidad'    =>$id_cant,
          'dee_precio'      =>$id_precio,
          'dee_usr_mod'     =>$usuario,
          'dee_fecha_mod'   =>date('Y-m-d h:i:s')
         );
        
        $id_detalle = $this->gsatelite->ingresar('dee_detalle_mov',$ingresar_detalle);
        $id_filaUnico = $arregloIDtrProductos[$key].'S'; //variable de control (indice del arreglo-que concuerdará con el id del tr de las series. y poder llevar el id del detalle correctamente)
        $IDsMovimientos["$id_filaUnico"] = $id_detalle;

        if(!empty($id_precio_venta1) && !empty($id_unidad_medida1) && !empty($id_nombre_precio1)){

        $ingresar_precios1 = array('pdv_id_sar' => $id_saldo,
          'pdv_precio' => $id_precio_venta1,
          'pdv_id_mep'   => $id_unidad_medida1,
          'pdv_nombre' => $id_nombre_precio1);
         $id_detalle = $this->gsatelite->ingresar('pdv_precio_venta',$ingresar_precios1);
       }
        if(!empty($id_precio_venta2) && !empty($id_unidad_medida2) && !empty($id_nombre_precio2)){
         $ingresar_precios2 = array('pdv_id_sar' => $id_saldo,
          'pdv_precio' => $id_precio_venta2,
          'pdv_id_mep'   => $id_unidad_medida2,
          'pdv_nombre' => $id_nombre_precio2);
         $id_detalle = $this->gsatelite->ingresar('pdv_precio_venta',$ingresar_precios2);
       }
        if(!empty($id_precio_venta3) && !empty($id_unidad_medida3) && !empty($id_nombre_precio3)){
         $ingresar_precios3 = array('pdv_id_sar' => $id_saldo,
          'pdv_precio' => $id_precio_venta3,
          'pdv_id_mep'   => $id_unidad_medida3,
          'pdv_nombre' => $id_nombre_precio3);
         $id_detalle = $this->gsatelite->ingresar('pdv_precio_venta',$ingresar_precios3);
       }
        if(!empty($id_precio_venta4) && !empty($id_unidad_medida4) && !empty($id_nombre_precio4)){
         $ingresar_precios4 = array('pdv_id_sar' => $id_saldo,
          'pdv_precio' => $id_precio_venta4,
          'pdv_id_mep'   => $id_unidad_medida4,
          'pdv_nombre' => $id_nombre_precio4);
         $id_detalle = $this->gsatelite->ingresar('pdv_precio_venta',$ingresar_precios4);
       }
        if(!empty($id_precio_venta5) && !empty($id_unidad_medida5) && !empty($id_nombre_precio5)){
         $ingresar_precios5 = array('pdv_id_sar' => $id_saldo,
          'pdv_precio' => $id_precio_venta5,
          'pdv_id_mep'   => $id_unidad_medida5,
          'pdv_nombre' => $id_nombre_precio5);
         $id_detalle = $this->gsatelite->ingresar('pdv_precio_venta',$ingresar_precios5);
       }



       }//end foreach
     }

     //REALIZAR EL INSERT DE LAS SERIES EN LOS PRODUCTOS A CUALES SE LES HA APLICADO.
      $arregloIDtrProductosSeries = $this->input->post('ids_filaS'); //este arreglo solo llevará los ids de los tr que aplicarón serie
      $idsDetalles = $IDsMovimientos;
      
      $ids_productos=$this->input->post('producto_serie');
      $nom_series=$this->input->post('nombre_serie');
      $ini_correlativo=$this->input->post('iniC_serie');
      $fin_correlativo=$this->input->post('finC_serie');
      if(count($ids_productos)>0){
        for ($i=0; $i < count($ids_productos) ; $i++) { 
          if($ids_productos[$i]>0) { //condicionar que sea un id valido.
            //preguntar por el id del detalle correcto
          $id_filaUnicoS = $arregloIDtrProductosSeries[$i];
          $idMovimientoSerie = $idsDetalles[$id_filaUnicoS]; //hacer referencia al key correcto.
          $insert_serie = array(
             'ser_id_art'   =>$ids_productos[$i]
            ,'ser_nombre'   =>trim($nom_series[$i])
            ,'ser_estado'   =>1
            ,'ser_fecha_mod'=>date('Y-m-d H:i:s')
            ,'ser_usu_mod'  =>$this->tank_auth->get_user_id()
            );
          $id_serie = $this->gsatelite->ingresar('ser_serie',$insert_serie); //insertar la serie

          $insert_correlativo = array(
            'cor_id_ser'   =>$id_serie
           ,'cor_tipo'     =>1
           ,'cor_inicio'   =>$ini_correlativo[$i]
           ,'cor_fin'      =>$fin_correlativo[$i]
           ,'cor_estado'   =>1
           ,'cor_id_dee'   =>$idMovimientoSerie
           ,'cor_usu_mod'  =>$this->tank_auth->get_user_id()
           ,'cor_fecha_mod'=> date('Y-m-d H:i:s')
            );

          $id_correlativo = $this->gsatelite->ingresar('cor_correlativo',$insert_correlativo); //insertar del correlativo
          }

        }
      }
     //FIN DEL SCRIPT QUE INSERTA LAS SERIES Y CORRELATIVOS
      if($ajuste==null){
           $alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Entrada de artículos",'texto_alerta'=>"El registro se guardó correctamente");
                      
          $this->session->set_flashdata($alerta);
        redirect('/inventario/gestion_productos/entrada_productos');
      }else{
      		$alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Anulación de factura",'texto_alerta'=>"Anulación de factura exitosamente");
                      
          $this->session->set_flashdata($alerta);
        redirect('facturacion/consultas/facturas');
        /*print_r($flag);
        exit();*/
        //return $flag;
      }
     //}
  }

  /**
  * @author ELman Ortiz
  * @fecha: 23/03/2018
  * @descripcion: Genera la partida contable automatica cuando se crea una factura independientemente si el producto tiene
  * @la configuracion de afecta o no inventario
  * @param integer fac_id, string num_fac
  * @return array {pct_id, total debe}
  */
  function generar_partida_anular_factura_afecta_noafecta_inv_debe($where, $info){
      $total_debe = 0.0000;
      //Tipo de cuenta por defecto
      $idtipo_cnt = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS',null,null,array('INGRESO'));
      $where['idtipo_cnt'] = $idtipo_cnt;//Se agrega el id del tipo cuenta que deben ser las cuentas para los productos
      $cnt_prods = $this->facturacion_model->get_cnt_x_prod_x_fac_anular($where);
      
      //Obtener los productos
      foreach ($cnt_prods as $key => $cnt_prod) {
          $total_debe = $total_debe + $cnt_prod['subtotal_prod'];            
      }
      //Obtener los impuestos
      $cnt_imps = $this->facturacion_model->get_cnt_x_impu_x_fac_anular($where);
      
      foreach ($cnt_imps as $key => $cnt_imp) {
          $total_debe = $total_debe + $cnt_imp['subtotximpcuenta'];
      }
      //Obtener las retenciones
      /*$cnt_rets = $this->compras_model->get_cnt_x_ret_x_docproveedor($where);
      foreach ($cnt_rets as $key => $cnt_ret) {
          $total_debe = $total_debe + $cnt_ret['subtotxretcuenta'];
      }*/       
      
      //Correlativo de la partida contable
      $correlativo_partida = $this->gsatelite->get_max('pct_partida_contable', 'pct_correlativo')+1;
      //Determinar el origen de la partida si es Documento Proveedor - Sin afectar inventario 
      $origen = $this->gsatelite->get_tabla('orp_origen_partida', array('orp_id' => 2));
      $orp_partida =(count($origen)>0)? $origen[0]['orp_id']:null;
      //Cuenta por defecto
      $id_tipo_partida = $this->gsatelite->get_parametro('SYS_TIPO_CUENTA_DEFECTO');
      //Tipo de partida
      $tipo_partida = $this->gsatelite->get_parametro('SYS_TIPO_PARTIDAS', null, false, array('EGRESOS'));
      $consultar = $this->gsatelite->get_tabla('tpd_tipo_partida',array('tpd_id'=>$tipo_partida));
      if (count($consultar)>0) {
          $id_tipo_partida = $tipo_partida;
      }

      //Concepto anulacion de factura
      $pct_concepto = $this->gsatelite->get_tabla('ccp_concepto_partida', array('ccp_id' => 3));
      if(count($pct_concepto) > 0){
        $pct_concepto = $pct_concepto[0]['ccp_descripcion_concepto'];
      }else{
        $pct_concepto = 'Concepto no definido';
      }

      $array_partida = array(
          'pct_id_tpd' => $id_tipo_partida,
          //'pct_id_prc' => $this->input->post('id_prc'),
          'pct_id_orp' => $orp_partida,//YA
          'pct_concepto' => $pct_concepto . $info['num_fac'],//YA
          'pct_total' => number_format($total_debe, 4, '.', ''),//YA
          'pct_fecha' => date('Y-m-d H:i:s'), //YA
          'pct_correlativo' => $correlativo_partida,//YA                
          //'pct_codigo' => $codigo,
          //'pct_modulo' => $modulo,
          'pct_estado' => 1,
          'pct_fecha_crea' => date('Y-m-d H:i:s'),
          'pct_fecha_mod' => date('Y-m-d H:i:s'),
          'pct_usu_crea' => $this->tank_auth->get_user_id(),
          'pct_usu_mod' => $this->tank_auth->get_user_id()
      );

      $id_pct = $this->gsatelite->ingresar('pct_partida_contable', $array_partida);
      
      //Ingresar los detalles de la partida para los productos
      foreach ($cnt_prods as $j => $deta) {
          $dpc_id_cnt = ($deta['cnt_id'] > 0) ? $deta['cnt_id'] : $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO');
          $array_detalle = array(
              'dpc_id_cnt' => $dpc_id_cnt,//YA
              'dpc_id_pct' => $id_pct,//YA
              'dpc_concepto' => 'Venta de producto',//YA
              'dpc_debe' => $deta['subtotal_prod'],//debe
              'dpc_haber' => 0.00,
              'dpc_estado' => 1,
              'dpc_fecha_crea' => date('Y-m-d H:i:s'),
              'dpc_fecha_mod' => date('Y-m-d H:i:s'),
              'dpc_usu_crea' => $this->tank_auth->get_user_id(),
              'dpc_usu_mod' => $this->tank_auth->get_user_id()
          );                

          $detalle = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle);                
      }

      //Ingresar los detalles de la partida para los impuesto
      foreach ($cnt_imps as $j => $deta) {
          $dpc_id_cnt = ($deta['cxe_id_cnt'] > 0) ? $deta['cxe_id_cnt'] : $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO');
          $array_detalle = array(
              'dpc_id_cnt' => $dpc_id_cnt,//YA
              'dpc_id_pct' => $id_pct,//YA
              'dpc_concepto' => 'Impuestos por venta',
              'dpc_debe' => $deta['subtotximpcuenta'],//debe 
              'dpc_haber' => 0.00,
              'dpc_estado' => 1,
              'dpc_fecha_crea' => date('Y-m-d H:i:s'),
              'dpc_fecha_mod' => date('Y-m-d H:i:s'),
              'dpc_usu_crea' => $this->tank_auth->get_user_id(),
              'dpc_usu_mod' => $this->tank_auth->get_user_id()
          );                

          $detalle = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle);                
      }        

      return array('id_pct' => $id_pct, 'total_debe' => $total_debe);
  }

  /**
   *@return Elman Ortiz
   *@fecha 23/03/2018
   *@descripcion: Haber para factura al ser anulada
   */
  function generar_partida_anular_factura_afecta_noafecta_inv_haber($where, $id_pct, $monto_haber){        
      $id_cuenta = $this->gsatelite->get_parametro('SYS_CUENTA_DEFECTO');        
      $id_cnt = $this->facturacion_model->get_cuenta_contable_tipopago_anular_factura($where);        
      if(count($id_cnt) > 0){
          if($id_cnt[0]['cnt_id'] > 0){
              $id_cuenta = $id_cnt[0]['cnt_id'];    
          }            
      }

      $array_detalle = array(
          'dpc_id_cnt' => $id_cuenta,//YA
          'dpc_id_pct' => $id_pct,//Ya
          'dpc_concepto' => 'Entrada a caja',
          'dpc_debe' => 0.00,//debe
          'dpc_haber' => $monto_haber,
          'dpc_estado' => 1,
          'dpc_fecha_crea' => date('Y-m-d H:i:s'),
          'dpc_fecha_mod' => date('Y-m-d H:i:s'),
          'dpc_usu_crea' => $this->tank_auth->get_user_id(),
          'dpc_usu_mod' => $this->tank_auth->get_user_id()
      );
      $detalle = $this->gsatelite->ingresar('dpc_detalle_partida', $array_detalle);         
  }//Fin haber partida contable cuando NO afecta inventario por medio de documento por proveedor

	function _cargarvista($data=0,$crud=0)
	{	
		$this->load->view('vacia',$crud);	
		if($data!=0)
			$data=array_merge($data,$this->masterpage->getUsuario());
		else
			$data=$this->masterpage->getUsuario();		
		$vista=$data['modulo'].'/'.$data['control'].'/'.$data['funcion'];
		$this->masterpage->setMasterPage('masterpage_default');
		$this->masterpage->addContentPage($vista, 'content',$data);
		$this->masterpage->show();
	}
}

