<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Reportes extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();
		$this->load->library('grocery_CRUD');
		$this->load->library('Procesos');
		$this->load->model('planilla_model');
		$this->load->model('personal_model');
		$this->load->model('expediente_personal_model');
		$this->load->library('tank_auth');
        $this->load->library('pdf');
        $this->load->library('EnLetras');
        
		$this->driver =  $this->planilla_model;
	}

	public function constancias()
	{
		if (!$this->tank_auth->is_logged_in()) {
			redirect('/auth/login/');
		} else {
			$isss=$this->gsatelite->get_parametro('DESCUENTO_ISS');
			$renta=$this->gsatelite->get_parametro('DESCUENTO_ISR');
			$id_afp=$this->gsatelite->get_parametro('DESCUENTO_AFP');
			$descuentos = implode(',',array($isss,$renta,$id_afp)); 
			$where = 'tdc_id NOT IN ('.$descuentos.')';
			$option = $this->gsatelite->get_dropdown('tdc_tipo_descuento', 'tdc_nombre', 'descuentos', $where, null, null, 'tdc_id', true);
			$data['titulo_personal'] = "Constancias";
			$data['tipo_des'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $option);
			$data['constancia_formato'] = $this->gsatelite->get_parametro('SYS_FORMATO_CONSTANCIA');
			$this->_cargarvista($data);
		}
	}

	public function fecha_vencimiento() {
		if (!$this->tank_auth->is_logged_in()) {
			redirect('/auth/login/');
		} else {
			$data['documentos'] = $this->gsatelite->get_tabla('tde_tipo_documento');
			$data['titulo_personal'] = "Fecha de vencimiento en documentos";
			$this->_cargarvista($data);

		}
	}

	public function obtener_documentos() {
		$desde = $this->input->post('desde');
		$hasta = $this->input->post('hasta');
		$documento = $this->input->post('documento');
		$where = array(
			"DATE_FORMAT(dce_fecha_vence, '%Y-%m-%d') >= " => formatear_fecha('Y-m-d', $desde),
			"DATE_FORMAT(dce_fecha_vence, '%Y-%m-%d') <= " => formatear_fecha('Y-m-d', $hasta)
		);
		if($documento != 0){
			$where['dce_id_tde'] = $documento;
		}
		$get_fechas = $this->expediente_personal_model->fecha_vencimiento_nuevo($where);
		// var_dump($this->db->last_query());die();
		$data['documento']  = $documento;
		$data['get_fechas'] = $get_fechas;
		$data['desde'] = $desde;
		$data['hasta'] = $hasta;
		$arreglo['html'] = $this->load->view('expediente_personal/reportes/consulta_documentos_empleado', $data, true);
		echo json_encode($arreglo);
	}

	public function imprimir_fecha_vencimiento() {
		$desde = $this->input->post('fecha_desde');
		$hasta = $this->input->post('fecha_hasta');
		$documento = $this->input->post('tipo_documento');
		$tipo = $this->input->post('tipo');
		$cadena = "";
		$colspan = 3;
		$doct_titulo = '';
		$where = array(
			"DATE_FORMAT(dce_fecha_vence, '%Y-%m-%d') >= " => formatear_fecha('Y-m-d', $desde),
			"DATE_FORMAT(dce_fecha_vence, '%Y-%m-%d') <= " => formatear_fecha('Y-m-d', $hasta)
		);
		if($documento != 0){
			$where['dce_id_tde'] = $documento;
			$reg_doc = $this->gsatelite->get_registro('tde_tipo_documento', 'tde_id', $documento);
			$doct_titulo = "Tipo: " . $reg_doc->tde_nombre;
			$cadena = "<table border = '1'><tr><th>Valor</th><th>Empleada/o</th><th>Fecha de vencimiento</th></tr>";
		} else{
			$colspan = 4;
			$cadena = "<table border = '1'><tr><th>Tipo documento</th><th>Valor</th><th>Empleada/o</th><th>Fecha de vencimiento</th></tr>";
		}
		$get_fechas = $this->expediente_personal_model->fecha_vencimiento_nuevo($where);		
		$fecha_actual = strtotime(date("Y-m-d",time()));
		foreach ($get_fechas as $k) {
			$fecha_vencimiento = strtotime($k['dce_fecha_vence']);
			if($fecha_actual > $fecha_vencimiento){
				$color = 'style= "background-color: #fc8c8c"';
			} else{
				$color = '';
			}
			$cadena.="<tr $color>";
			if($documento == 0){
				$cadena .= '<td>'.$k['tde_nombre'].'</td>';
			}
			$cadena .= '<td>' . $k['dce_valor'] . '</td>';
			$cadena .= '<td>' . $k['emp_nombre'] . ' ' . $k['emp_apellido'] . '</td>';
			$cadena .= '<td>' . formatear_fecha('d-m-Y', $k['dce_fecha_vence']) . '</td></tr>';
		}
		$cadena .= "</table>";
		if ($tipo == 'excel') {
			header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
			header("Content-Disposition: attachment;filename=documento_fecha_vencimiento_".date('d-m-Y_His').".xls"); 
			header("Pragma: no-cache");
			header("Expires: 0");
			echo '<meta charset="utf-8" />';
			echo "<table border='0'>
			<tr><th colspan='".$colspan."' align='center' >".mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'),'UTF-8')."</th></tr>";
			echo "<tr><th colspan='".$colspan."' align='center' >Documentos con fecha de vencimiento</th></tr>";
			echo ($doct_titulo != '')? "<tr><th colspan='".$colspan."' align='center' > $doct_titulo </th></tr>":'';
			echo "</table>";
			echo $cadena; 
			die();
		}
		$doct_titulo = ($doct_titulo != '') ? '<br />' . $doct_titulo : '';
		$html = $this->load->view('reporte/header', array('titulo' => 'fecha de vencimiento de documentos' . $doct_titulo), true);
		$html .= $cadena;
		$this->pdf->makePDF($html,'P','Fecha Vencimiento');
		// $reporte=$this->pdf->reportePDF2($html, 1, null, 'I');
	}

	public function reporte_planilla()
	{
		$data['titulo_personal'] = "Impresión de boletas y planillas";
		$data['tipo_planilla'] = $this->planilla_model->get_tipo_contrato();
		$this->_cargarvista($data);
	}

	/**
	 * @author Boris Estrada
	 */
	function reporte_cumpleanios(){

						 $this->db->join('mxr_empresaxarea', 'mxr_id_are = are_id');
						 $this->db->where('mxr_id_emr', $this->tank_auth->get_empresa_id());
		$data['areas'] = $this->gsatelite->get_tabla('are_area', array('are_estado' => 1));
		$data['slcSucursal'] = $this->gsatelite->get_dropdown('suc_sucursal', '{suc_codigo} - {suc_nombre}', 'slcSucursal', array('suc_id_emr' => $this->tank_auth->get_empresa_id()), null, '', '', true);
		$data['titulo_personal'] ="Reporte cumpleañeros";
		$data['empresa'] = $this->tank_auth->get_empresa_id();
		$this->_cargarvista($data);
	}

	/**
	 * @author Boris Estrada
	 */
	function obtener_cupleaneros(){
		$desde=$this->input->post('desde');
		$hasta=$this->input->post('hasta');
		$area=$this->input->post('area');
		$slcSucursal = $this->input->post('slcSucursal');
		$slcEmpresa = $this->input->post('slcEmpresa');
		$data['empleados']=$this->expediente_personal_model->cumpleaneros($desde, $hasta, (($area==0)? null: $area), $slcSucursal, $slcEmpresa);
		//die($this->db->last_query());
		$data['desde'] = $desde;
		$data['hasta'] = $hasta;
		$data['area'] = $area;
		$data['slcSucursal'] = $slcSucursal;
		$data['slcEmpresa'] = $slcEmpresa;
		$respuesta=array(
			'html'=>$this->load->view('expediente_personal/reportes/listado_cumpleaneros', $data, true),
			'respuesta'=>(count($data['empleados'])>0)? 1: 0
			);
		echo json_encode($respuesta);
	}

	/**
	 * @author Boris Estrada
	 */
	function imprimir_reporte_cumpleanios(){
		$desde=$this->input->post('desde');
		$hasta=$this->input->post('hasta');
		$area=$this->input->post('area');
		$tipo=$this->input->post('tipo');
		$slcSucursal = $this->input->post('slcSucursal');
		$slcEmpresa = $this->input->post('slcEmpresa');

		$desde=formatear_fecha('Y-m-d', $desde);
		$hasta=formatear_fecha('Y-m-d', $hasta);
		$data['empleados']=$this->expediente_personal_model->cumpleaneros($desde, $hasta, (($area==0)? null: $area), $slcSucursal, $slcEmpresa);
		if($tipo=='pdf'){
			$html=$this->load->view('reporte/header', array('titulo' => 'Cumpleañeros'), true);
			$html.=$this->load->view('expediente_personal/reportes/listado_cumpleaneros_pdf', $data, true);
			$reporte=$this->pdf->reportePDF2($html, 1, null, 'I');
		}
		if($tipo=='excel'){
			$this->load->view('expediente_personal/reportes/listado_cumpleaneros_excel', $data);
		}		

	}

	public function get_empleado($activos = NULL){
		$suc_id = $this->input->post('suc_id');
		$area = $this->input->post('area');
		if ($activos) {
			$this->db->where('emp_estado', 1);
		}
		if($suc_id > 0){
			$empleados = $this->db->select()->from('emp_empleado')->where('emp_id_suc', $suc_id)->get()->result_array();
		}else if($area > 0){
			$empleados = $this->db->select()->from('emp_empleado')->where('emp_id_are', $area)->get()->result_array();
		}
		$cadena="<option value=''></option>";
		if(count($empleados)>0){
			foreach ($empleados as $key => $value) {
				$cadena.="<option value='".$value['emp_id']."'>".$value['emp_codigo']." ".$value['emp_nombre']." ".$value['emp_apellido']."</option>";
			}
		}
		$arreglo=array('lista'=>$cadena);
		echo json_encode($arreglo);
	}

	public function imprimir_constancia()
	{	
		$empleado=$_POST['empleado'];
		$tipo=$_POST['constancia'];
		$codigo_ingreso01=$this->planilla_model->codigo_ingreso01($empleado);
		$codigo_ingreso11=$this->planilla_model->codigo_ingreso11($empleado);
		$cons_trabajo=$this->db->select()
		->from('emp_empleado')
		->where('emp_id',$empleado)
		->join('plz_plaza','plz_id = emp_id_plz', 'left')
		->join('pto_puesto','pto_id = plz_id_pto', 'left')
		->get()->result_array();
		$ultimo_sueldo=$this->planilla_model->ultimo_sueldo($empleado);
		$desc_ley=$this->planilla_model->descuentos_ley($empleado);
		$documentos = $this->planilla_model->documentos_emp($empleado);
		

		$data=array('cons_trabajo' => $cons_trabajo,
					'ultimo_sueldo'=> $ultimo_sueldo,
					'descuentos'=> $desc_ley,
					'tipo_cons' => $tipo,
					'documentos' => $documentos,					
					'codigo01' => $codigo_ingreso01,
					'codigo11' => $codigo_ingreso11
					);
		//die(print_r($data));
		// var_dump($data);die();
        
		$html = $this->load->view('personal/reportes/plantillas_constancias', $data, true);
		$reporte=$this->pdf->reportePDF2($html);

	}

	function plantillas_constancias()
	{
		$this->_cargarvista();
	}

	/**
	 * Consultas:consulta de registros
	 * @author René Castaneda
     */
	function reporte_empleado() {
		if (!$this->tank_auth->is_logged_in()) {
			redirect('/auth/login/');
		} else {
			if($_POST) {
				// var_dump($_POST); die();
				$tipo=$this->input->post('tipo_accion');
				$filtro=$this->input->post('filtro_hidden');
				$valor_filtro=$this->input->post('filtro_valor_hidden');
				$valor_filtro2=$this->input->post('filtro_valor_hidden2');
				$filtro_sucursal=$this->input->post('filtro_sucursal_hidden');
				$colum_report=$this->input->post('colums');
				$columnas=array();
				for ($i=0; $i < count($colum_report) ; $i++) { 	$columnas[]=$colum_report[$i];	}
				//Filtro sucursal
					$filtros_extras['filtro_sucursal'] = ($filtro_sucursal) ? $filtro_sucursal: '';
				$nombre_sucursal = 'Todas';
				if($filtro_sucursal > 0){
					$nombre_sucursal = $this->gsatelite->get_campo('suc_sucursal','suc_nombre', array('suc_id' => $filtro_sucursal));
				}
				$data['nombre_sucursal'] = $nombre_sucursal;
				if($tipo=='pdf'){
					//imprimir pdf
					$formato = (count($columnas)>10)? 'Legal':'Letter';
					$data['filtro']=$filtro;
					$data["consulta"] = $this->filtro_reporte_empleado($filtro,$valor_filtro,false,true, $valor_filtro2, $filtros_extras);
					$data["columnas_reporte"] = $columnas;
					$data["columnas"] = $colum_report;
					$html=$this->load->view('reporte/header', array('titulo' => 'Empleadas/os'), true);
					$html.=$this->load->view('expediente_personal/reportes/reporte_empleado_pdf',$data,true);
					$this->pdf->setPrintFooter(true);
					$this->pdf->makePDF($html,'L','reporte_empleado',$formato);
				}
				if($tipo=='excel'){
					//exportar excel
					$data['filtro']=$filtro;
					$data["columnas_reporte"] = $columnas;
					$cantidad=count($columnas);
					$data['html']=$this->load->view('reporte/header', array('titulo' => 'Empleadas/os','columnas'=>$cantidad), true);
					$data["consulta"] = $this->filtro_reporte_empleado($filtro,$valor_filtro,false,true, $valor_filtro2, $filtros_extras);
					$data["columnas"] = $colum_report;
					$this->load->view('expediente_personal/reportes/reporte_empleado_excel',$data);
				}
			} else { 
				$select = $this->gsatelite->get_dropdown('suc_sucursal', '{suc_nombre}','', array('suc_id_emr'=>$this->tank_auth->get_empresa_id()), null, '', 'suc_id', true);
				$data["select_emp_id_suc"] = str_replace('<option value="0">Seleccione</option>', '',$select);

				$this->db->join('mxr_empresaxarea', 'mxr_id_are = are_id');
				$this->db->where('mxr_id_emr', $this->tank_auth->get_empresa_id());
				$select = $this->gsatelite->get_dropdown('are_area', '{are_nombre}','', null,null, '', 'are_id', true);
	 			//echo $this->db->last_query(); die();
				$data["select_emp_id_are"] = str_replace('<option value="0">Seleccione</option>', '',$select);

				$this->db->join('mxp_empresaxpuesto', 'mxp_id_pto = pto_id');
				$this->db->where('mxp_id_emr', $this->tank_auth->get_empresa_id());
				$select = $this->gsatelite->get_dropdown('pto_puesto', '{pto_nombre}','', array('pto_estado'=>1), null, '', 'pto_id', true);
				$data["select_emp_id_pto"] = str_replace('<option value="0">Seleccione</option>', '',$select);
				$select = $this->gsatelite->get_dropdown('gen_genero', '{gen_nombre}','', null, null, '', 'gen_id', true);
				$data["select_emp_id_gen"] = str_replace('<option value="0">Seleccione</option>', '',$select);

				$select = $this->gsatelite->get_dropdown('tpl_tipo_planilla', '{tpl_nombre}','',  array('tpl_id_emr'=>$this->tank_auth->get_empresa_id()), null, '', 'tpl_id', true);
				$data["select_tpl_id"] = str_replace('<option value="0">Seleccione</option>', '',$select);

				$select = $this->gsatelite->get_dropdown('tic_tipo_contrato', '{tic_nombre}','', array('tic_estado'=>1), null, '', 'tic_id', true);
				$data["select_tic_id"] = str_replace('<option value="0">Seleccione</option>', '',$select);

				$select = $this->gsatelite->get_dropdown('tpl_tipo_planilla', '{tpl_nombre}','',  array('tpl_id_emr'=>$this->tank_auth->get_empresa_id()), null, '', 'tpl_id', true);

				$preguntar_plaza = $this->expediente_personal_model->plazas_agrupadas();
				$opciones_plaza="";
				foreach ($preguntar_plaza as $plz) {
					$opciones_plaza .='<option value="'.$plz['ids'].'" >'.$plz['plz_nombre'].'</option>';
				}
				$data["select_emp_plaza"] = $opciones_plaza;
				$data["select_emp_id_emr"] = $this->gsatelite->get_dropdown_empresa();

				$data["titulo_personal"] = "Reporte de empleados";
				$this->_cargarvista($data,null);
			}
		}
	}

	/* René Castaneda*/
	function filtro_reporte_empleado($filtro=null,$valor=null,$retorna_html=false,$retornarconsulta=false, $valor2=null, $filtros_extras=null) {
		$idsuc = $this->input->post('sucursal');
		$vista="filtro_reporte_empleado";
		$noes_reporte= $this->input->post('noesreporte'); //ajax archivo busqueda_empleado.js (no utilizado (pero funcional) en el sistema)
		$ids_parentesco_hijo = (trim($this->gsatelite->get_parametro('SYS_PARENTESCO_HIJO')) != "" )? trim($this->gsatelite->get_parametro('SYS_PARENTESCO_HIJO')):"0";
		if($noes_reporte==1){ 
			$vista="filtro_consulta_empleado"; 
			$this->db->where('emp_empleado.emp_estado',1); 
			$this->db->where('emp_empleado.emp_id_emr',$this->tank_auth->get_empresa_id()); 
			$this->db->where('tpl_tipo_planilla.tpl_id',$this->input->post('id_tipo_planilla'));
		}
		if($filtro==null and $valor==null) { 
			$filtro= $this->input->post('filtro');
			$valor= $this->input->post('valor');
			$valor2= $this->input->post('valor2');
		}
		//die(print_r($filtro.'/'.$valor));
		$where=null;
		if($filtro=='emp_fecha_contrato'){
			$f=explode('#',$valor);
			$where=array('date_format('.$filtro.',"%Y-%m-%d") >='=>date('Y-m-d', strtotime($f[0])), 'date_format('.$filtro.',"%Y-%m-%d") <='=>date('Y-m-d', strtotime($f[1])));
		} elseif ($filtro == 'emp_fecha_mod') {
			$f=explode('#',$valor);
			$where = array('date_format('.$filtro.',"%Y-%m-%d") >= ' => formatear_fecha('Y-m-d', $f[0]), 'date_format('.$filtro.',"%Y-%m-%d") <= ' => formatear_fecha('Y-m-d', $f[1]));
		} elseif($filtro=='emp_nombre' or $filtro=='emp_apellido'){
			$this->db->like("$filtro",trim($valor)); 
		} elseif($filtro=='emp_plaza'){
			$ids_plazas= explode(',', $valor);
			$this->db->where_in('emp_id_plz',$ids_plazas);
		} elseif ($filtro=='cxp_correo') {
			$this->db->like("$filtro",trim($valor)); 
		} elseif($filtro=='todos_empleados'){
			// ningun valor de filtro 
		}elseif ($filtro=='tic_id') {
			$this->db->where('tic_id', $valor);
		}elseif($filtro=='emp_fecha_nac' && $valor!='' && $valor2!=''){
			$actual=date('Y');
			$anio1=$actual-$valor;
			$anio2=$actual-$valor2;
			$where=array('date_format('.$filtro.',"%Y") >='=>$anio2, 'date_format('.$filtro.',"%Y") <='=>$anio1);
		}elseif ($filtro=='emp_id_gen' && $valor=='todos') {
			// Sin condicional
		} else {
			$where=array("$filtro"=>trim($valor));
		}
		if ($idsuc > 0) {
			$where['emp_id_suc'] = $idsuc;
		}
		if($filtros_extras['filtro_sucursal'] != ''){
			$where['emp_id_suc'] = $filtros_extras['filtro_sucursal'];
		}	
		$consulta= $this->planilla_model->get_empleados_reporte($where, $ids_parentesco_hijo);
		//echo $this->db->last_query(); die();
		$data['filtro']=$filtro;
		$data["consulta"] = $consulta;
		$html=$this->load->view("expediente_personal/reportes/$vista",$data,true); 
		if ($retorna_html) {  return $html; }
		elseif ($retornarconsulta) { return $consulta;   }
		else {  echo json_encode(array('resultado'=>$html)); }
	}

 	/* RENE CASTANEDA */
		/**
	 * Descripción:
	 * se modifico la impresion de los datos y los recolecte segun como son solicitados por el usuario
	 * @author      Marlon Olmedo
	 * @version     23-05-2019
	**/
	function reporte_documentos($id_emp=0,$tde_id=0,$retorna_html=0,$tipo=2, $salida='I') {
		satelite_validar();
		ini_set( 'memory_limit', '4048M' );        
		ini_set('max_execution_time', '9999');          
		ini_set( 'max_input_vars', '15000' );
		if($id_emp!=0 and $tde_id!=0) {
  			//si idempleado y id_tipo_documento existen, entonces
  			/*$this->gsatelite->verificar_registro_real('emp_empleado',$id_emp);*/
  			$data['documentos'] = $this->planilla_model->documentos_emp($id_emp,$tde_id);
  			/*$data['empleado'] = $this->gsatelite->get_registro('emp_empleado','emp_id',$id_emp);*/
  			$html  = $this->load->view('reporte/header', array('titulo' => 'Reporte Documentos Empleada/o','solotitulo'=>true), true);
  			$html .= $this->load->view('expediente_personal/reportes/documentos_empleado', $data, true);
  		} elseif ($id_emp!=0) {
    		//si solo empleado existe
  			/*$this->gsatelite->verificar_registro_real('emp_empleado',$id_emp);*/
  			$data['documentos'] = $this->planilla_model->documentos_emp($id_emp,'');
  			/*$data['empleado'] = $this->gsatelite->get_registro('emp_empleado','emp_id',$id_emp);*/
  			$html  = $this->load->view('reporte/header', array('titulo' => 'Reporte Documentos Empleada/o','solotitulo'=>true), true);
  			$html .= $this->load->view('expediente_personal/reportes/documentos_empleado', $data, true);
  		} elseif ($tde_id!=0) {
    		//si solo id_tipo_documento existe
  			/*$consulta_empleados = $this->gsatelite->get_tabla('emp_empleado',array('emp_estado'=>1, 'emp_id_emr'=>$this->tank_auth->get_empresa_id()));*/
  			/*foreach ($consulta_empleados as $fila) {*/
  			$data['documentos'] = $this->planilla_model->documentos_emp('',$tde_id);
  			/*$data['empleado'] = $this->gsatelite->get_registro('emp_empleado','emp_id',$fila['emp_id']);*/
  			$html  = $this->load->view('reporte/header', array('titulo' => 'Reporte Documentos Empleada/o','solotitulo'=>true), true);
  			$html .= $this->load->view('expediente_personal/reportes/documentos_empleado', $data, true);
  			/*$html .= '&nbsp;<br />';*/
  			/*}*/
  		} elseif($id_emp==0 and $tde_id==0) {
    		//si ninguno de los 2 existe
  			/*$consulta_empleados = $this->gsatelite->get_tabla('emp_empleado',array('emp_estado'=>1, 'emp_id_emr'=>$this->tank_auth->get_empresa_id()));*/
  			/*foreach ($consulta_empleados as $fila) {*/
  			$data['documentos'] = $this->planilla_model->documentos_emp('','');
  			/*$data['empleado'] = $this->gsatelite->get_registro('emp_empleado','emp_id',$fila['emp_id']);*/
  			$html  = $this->load->view('reporte/header', array('titulo' => 'Reporte Documentos Empleada/o','solotitulo'=>true), true);
  			$html .= $this->load->view('expediente_personal/reportes/documentos_empleado', $data, true);
  			/*$html .= '&nbsp;<br />';*/
  			/*}*/
  		}

  		if($retorna_html) {
  			$html_header = $this->load->view('reporte/header', array('titulo' => 'Reporte Documentos Empleada/o','solotitulo'=>true), true);
  			return str_replace($html_header,'',$html);
  		} else {
  			if($tipo==2) { 
  				$reporte=$this->pdf->makePDF($html,'P','','Letter',$salida);
  			} else {
  				header("Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
  				header("Content-Disposition: attachment;filename=Reporte_documentos.xls"); 
  				header("Pragma: no-cache");
  				header("Expires: 0");
  				$html_header = $this->load->view('reporte/header', array('titulo' => 'Reporte Documentos Empleada/o','solotitulo'=>true), true);
  				echo str_replace($html_header,'',$html);
  			}
  		}
  	}

 function generar_contrato_empleado($id_empleado=null) {
 	satelite_validar();
 	$this->load->library('EnLetras');  	
 	$id_emp = $this->input->post('empleado');
 	$id_suc = $this->input->post('sucursal');
 	$slcArea = $this->input->post('slcArea');
 	$id_frm = $this->input->post('frm_contrato');
  	//print_r($_POST); die();
 	$id_empleado = ($id_empleado)?$id_empleado:$id_emp;
	//UBICACION DE LA EMPRESA
 	$info_emp = $this->tank_auth->get_all_empresa();
    $data['municipio'] = $this->gsatelite->get_registro('mun_municipio', 'mun_id', $info_emp->emr_id_mun);
  	if ($id_empleado > 0) {
  		$where = array('emp_id'=>$id_empleado);
  		$this->gsatelite->verificar_registro_real('emp_empleado',$id_empleado);
  	}
  	elseif ($slcArea > 0 ) {
  		$where = array('emp_id_are'=>$slcArea);
  	}

  	if ($id_suc > 0 ) {
  		$where['emp_id_suc'] = $id_suc;
  	}
  	//representante legal de la empresa
  	$id_repre = $this->gsatelite->get_parametro_emp('ID_REPRESENTANTE_LEGAL');
  	$dui_id = $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_DUI');
  	$nit_id = $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_NIT');
  	$data['nombre_empresa'] = $this->gsatelite->get_parametro_emp('SYS_EMPRESA');
  	$data['isss_empresa'] = $this->gsatelite->get_parametro_emp('SYS_ISSS_PATRONAL');
  	$data['nit_empresa'] = $this->gsatelite->get_parametro_emp('SYS_NIT'); 
  	$data['dui_representante'] = $this->gsatelite->get_tabla('dce_documento_emp', array('dce_id_emp' => $id_repre, 'dce_id_tde' => $dui_id));
  	$data['nit_representante'] = $this->gsatelite->get_tabla('dce_documento_emp', array('dce_id_emp' => $id_repre, 'dce_id_tde' => $nit_id));
  	$consulta_r = $this->planilla_model->get_empleados_reporte(array('emp_id'=>$id_repre));
  	$data['datos_r']= $consulta_r[0];
  	$data['siglas'] = strtolower(trim($this->gsatelite->get_parametro('SYS_SIGLAS')));
  	$consulta = $this->planilla_model->get_empleados_reporte($where);
  	$n_registros = count($consulta);
  	$id_frm = ($id_frm > 1 ) ? $id_frm : '';
  	$todo_html = "";
  	$i=0;
  	foreach ($consulta as $fila_emp) {
  		$i++;
  			   				 $this->db->join('fun_funcion', 'fxl_id_fun=fun_id');
  		$data['funciones'] = $this->gsatelite->get_tabla('fxl_funcionxplaza', array('fxl_id_plz'=>$fila_emp['plz_id']));
  		$data['datos']= $fila_emp;
	  	$data['dui_empleado'] = $this->gsatelite->get_tabla('dce_documento_emp', array('dce_id_emp' => $fila_emp['emp_id'], 'dce_id_tde' => $dui_id));
	  	$data['nit_empleado'] = $this->gsatelite->get_tabla('dce_documento_emp', array('dce_id_emp' => $fila_emp['emp_id'], 'dce_id_tde' => $nit_id));
	  	$data['familiares'] = $this->planilla_model->familiares_empleado($fila_emp['emp_id']);
	  	$data['mun_suc'] = $this->gsatelite->get_campo('mun_municipio','mun_nombre',array('mun_id' => $fila_emp['suc_id_mun']));
	  	// traemos los horarios por turnos
		  $data['horariosxturnos'] = $this->planilla_model->get_horariosxturnos(array('plz_id' =>$fila_emp['plz_id'],'dxt_estado' => 1));
		  $data['horariosxturnos_group'] = $this->planilla_model->get_horariosxturnos_group(array('plz_id' =>$fila_emp['plz_id'],'dxt_estado' => 1));

		  $where_t["ddi_id_emp"] = $fila_emp['emp_id'];
		  $where_t["pla_estado"] = 3;
		  $fecha_plan = $this->planilla_model->get_fecha_detallepla($where_t);
		  $tag_id = $this->gsatelite->get_parametro('SYS_ID_AGRUPADOR_CONTRATO'); 
		  //print_r($fecha_plan);die();
		  $tig_table = $this->gsatelite->get_tabla('deg_detalle_agrupador', array('deg_id_tag'=>$tag_id));
		  $tig_table = array_column($tig_table,"deg_id_tig");
		  $tig_explode = implode(",",$tig_table); // cantidad para el where
		//print_r(array_column($tig_table,"deg_id_tig"));die();
		if (isset($fecha_plan[0]["fecha_fin"])) {
			$fecha_inicio = formatear_fecha("Y-m",$fecha_plan[0]["fecha_fin"])."-01";
			$fecha_fin = formatear_fecha("Y-m-t",$fecha_plan[0]["fecha_fin"]);
		} else {
			$fecha_inicio = date("Y-m")."-01";
			$fecha_fin = date("Y-m-t");
		}
		  $fecha_plan = (isset($fecha_plan[0]["fecha_fin"]))? $fecha_plan[0]["fecha_fin"] : date("Y-m-d");
		  $where_u["pla_fecha_inicio BETWEEN '$fecha_inicio' and '$fecha_fin'"] = NULL;

		  if ($tig_explode != null) {
			$where_u["ddi_id_tig in ($tig_explode)"] = NULL;
		  }

		  $fecha_plan = $this->planilla_model->get_sallario_detallepla($where_u,$fila_emp['emp_id']);
		  //print_r($this->db->last_query());die();

		  $salario_proyecto = array_column($fecha_plan,"ddi_valor");
		  $data["salario"] = array_sum($salario_proyecto);
			// print_r($data);die();
		  //Generar el reporte
		  if ($id_frm == 14) {
			$font_family = 'Tahoma';
			$margen = 'margin-left: 0.21cm;';
		  }else{
			$font_family = 'Arial';
			$margen = '';
		  }
	  	$todo_html .= $this->load->view('expediente_personal/reportes/generar_contrato_empleado'.$id_frm, $data, TRUE);
	  	// print_r($todo_html);die();
		$todo_html .= ($i!=$n_registros)? '<br style="page-break-after: always;" />':'';
  	}
  	// echo $todo_html;
  	// die();
  	//////////////////////// PASA IGUAL QUE LAS FORMATOS DE LAS COTIZACIONES  //////////////////////  COMO VINCULAR LAS QUE YA ESTAN CON EL MANTENIMIENTO  ////////////////////////
  	// SE AGREGARA LINK D ACCESO A FORMATO REQUERDO DE WORDY NOSOTROS IR A LEERLO Y HACER REPLACE, DEJAR UNO POR DEFECTO Y LAS PALABRAS CLAVES SE COLOCARAN EN UN JSON QUE NO SE PUEDA CAMBIAR POR EL CLIWNTE
  	///////////////////////////////////NO ENTIENDO  LA 144  /////////////  SI SOY SUP SEGUI VIENDO  TODO PERO CON USUARIO ADMIN  ///////////////////////
  	header('Content-type: application/vnd.ms-word');
  	header('Content-Disposition: attachment;Filename=contrato_empleado.doc');
  	header("Pragma: no-cache");
  	header("Expires: 0");
  	echo '<html>';
  	echo '<meta http-equiv=\'Content-Type\' content=\'text/html; charset=Windows-1252\'>';
  	echo '<body style="font-family:'.$font_family.';'.$margen.'" >';
  	echo '<meta charset="utf-8" />';
	echo '<style type="text/css"> .inicio_contrato {  font-weight: bold;  }  .parrafo {    text-align: justify;  }</style>';
  	echo $todo_html;
  	echo '</body></html>';

  
  }


function documentos_empleados() {
	satelite_validar();
	$data["titulo_personal"] = "Reportes documentos empleados";
	$data["tipo"] = $this->gsatelite->get_dropdown('tde_tipo_documento', '{tde_nombre}','', '', null, '', 'tde_id', true);
 	$this->_cargarvista($data,null);
}


	public function documentos_externos($frmId = null, $empId = null ){
		satelite_validar();
		if ($empId || $_POST) {
			$id_emp = ($empId) ? $empId : $this->input->post('slc_empleado');
			$id_frm = ($frmId) ? $frmId : $this->input->post('tipo_documento');

			$slcArea = $this->input->post('slcArea');
			$aucens = ($this->input->post('ausencias') > 0) ? $this->input->post('ausencias') : null;
			$id_part = ($this->input->post('parentesco') > 0) ? $this->input->post('parentesco') : null;
			$fech_murt = ($this->input->post('fecha_muerte') != "") ? formatear_fecha('Y-m-d', $this->input->post('fecha_muerte')) : null;
			$fech_volv = ($this->input->post('fecha_regresa') != "") ? formatear_fecha('Y-m-d', $this->input->post('fecha_regresa')) : null;
			$fech_resoluc = ($this->input->post('fecha_resol') != "") ? formatear_fecha('Y-m-d', $this->input->post('fecha_resol')) : null;
			$num_resol = $this->input->post('resolucion');
			$info_emr = $this->gsatelite->get_registro('emr_empresa', array('emr_id' => $this->tank_auth->get_empresa_id()));
			$data['municipio'] = $this->gsatelite->get_registro('mun_municipio', 'mun_id', $info_emr->emr_id_mun);
			if ($id_emp > 0) {
				$where = array('emp_id'=>$id_emp);
				$this->gsatelite->verificar_registro_real('emp_empleado',$id_emp);
			} elseif ($slcArea > 0 ) {
				$where = array('emp_id_are'=>$slcArea);
			}
			$dui_id = $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_DUI');
			$nit_id = $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_NIT');
			$id_repre = $this->gsatelite->get_parametro_emp('ID_REPRESENTANTE_LEGAL');
			$data['nombre_empresa'] = $this->gsatelite->get_parametro_emp('SYS_EMPRESA');
			$data['isss_empresa'] = $this->gsatelite->get_parametro_emp('SYS_ISSS_PATRONAL');
			$data['nit_empresa'] = $this->gsatelite->get_parametro_emp('SYS_NIT'); 
			$data['dui_representante'] = $this->gsatelite->get_tabla('dce_documento_emp', array('dce_id_emp' => $id_repre, 'dce_id_tde' => $dui_id));
			$data['nit_representante'] = $this->gsatelite->get_tabla('dce_documento_emp', array('dce_id_emp' => $id_repre, 'dce_id_tde' => $nit_id));
			$consulta_r = $this->planilla_model->get_empleados_reporte(array('emp_id'=>$id_repre));
			$data['datos_r']= $consulta_r[0];
			$consulta = $this->planilla_model->get_empleados_reporte($where);
			$n_registros = count($consulta);
			$id_frm = ($id_frm > 1 ) ? $id_frm : '';
			$todo_html = "";
			$i=0;
			foreach ($consulta as $fila_emp) {
				$i++;
									 $this->db->join('fun_funcion', 'fxl_id_fun=fun_id');
				$data['funciones'] = $this->gsatelite->get_tabla('fxl_funcionxplaza', array('fxl_id_plz'=>$fila_emp['plz_id']));
				$data['datos']= $fila_emp;
				$data['dui_empleado'] = $this->gsatelite->get_tabla('dce_documento_emp', array('dce_id_emp' => $fila_emp['emp_id'], 'dce_id_tde' => $dui_id));
				$data['nit_empleado'] = $this->gsatelite->get_tabla('dce_documento_emp', array('dce_id_emp' => $fila_emp['emp_id'], 'dce_id_tde' => $nit_id));
				$data['familiares'] = $this->planilla_model->familiares_empleado($fila_emp['emp_id'], $id_part);
				$data['mun_suc'] = $this->gsatelite->get_campo('mun_municipio','mun_nombre',array('mun_id' => $fila_emp['suc_id_mun']));
				$data['horariosxturnos'] = $this->planilla_model->get_horariosxturnos(array('plz_id' =>$fila_emp['plz_id'],'dxt_estado' => 1));
				$data['horariosxturnos_group'] = $this->planilla_model->get_horariosxturnos_group(array('plz_id' =>$fila_emp['plz_id'],'dxt_estado' => 1));
				$where_t["ddi_id_emp"] = $fila_emp['emp_id'];
				$where_t["pla_estado"] = 3;
				$fecha_plan = $this->planilla_model->get_fecha_detallepla($where_t);
				$tag_id = $this->gsatelite->get_parametro('SYS_ID_AGRUPADOR_CONTRATO'); 
				$tig_table = $this->gsatelite->get_tabla('deg_detalle_agrupador', array('deg_id_tag'=>$tag_id));
				$tig_table = array_column($tig_table,"deg_id_tig");
				$tig_explode = implode(",",$tig_table);
				if (isset($fecha_plan[0]["fecha_fin"])) {
					$fecha_inicio = formatear_fecha("Y-m",$fecha_plan[0]["fecha_fin"])."-01";
					$fecha_fin = formatear_fecha("Y-m-t",$fecha_plan[0]["fecha_fin"]);
				} else {
					$fecha_inicio = date("Y-m")."-01";
					$fecha_fin = date("Y-m-t");
				}
				$fecha_plan = (isset($fecha_plan[0]["fecha_fin"]))? $fecha_plan[0]["fecha_fin"] : date("Y-m-d");
				$where_u["pla_fecha_inicio BETWEEN '$fecha_inicio' and '$fecha_fin'"] = NULL;
				if ($tig_explode != null) {
					$where_u["ddi_id_tig in ($tig_explode)"] = NULL;
				}
				$fecha_plan = $this->planilla_model->get_sallario_detallepla($where_u,$fila_emp['emp_id']);
				$salario_proyecto = array_column($fecha_plan,"ddi_valor");
				$data["salario"] = array_sum($salario_proyecto);
				$data["aucensia"] = $aucens;
				$data["regresar"] = $fech_volv;
				$data["num_resol"] = $num_resol;
				$data["fallecido"] = $fech_murt;
				$data["resolucion"] = $fech_resoluc;
				$todo_html .= $this->load->view('expediente_personal/reportes/generar_contrato_empleado'.$id_frm, $data, TRUE);
				$todo_html .= ($i!=$n_registros)? '<br style="page-break-after: always;" />':'';
			}
			$this->pdf->setPrintFooter(false);
			$this->pdf->makePDF($todo_html);
		} else {
			$data['titulo_personal'] = "Documentos";
			$data['formato_reporte'] = $this->gsatelite->get_parametro('SYS_FORMAT_REPORT_CONTRATO');
			$empleados = $this->gsatelite->get_tabla('emp_empleado', array('emp_estado' => 1));
			$slc_emp = '<option value=""></option>';
			foreach ($empleados as $k => $e) {
				$state = ($e['emp_estado'] > 0) ? '' : ' (INACTIVO)';
				$slc_emp .= '<option value="'.$e['emp_id'].'">'.$e['emp_codigo'].' - '.$e['emp_nombre'].' '.$e['emp_apellido'].$state.'</option>';
			}
			$data['slc_empleados'] = $slc_emp;
								 $this->db->join('mxr_empresaxarea', 'mxr_id_are = are_id');
								 $this->db->where('mxr_id_emr', $this->tank_auth->get_empresa_id());
			$data['slc_areas'] = $this->gsatelite->get_dropdown('are_area', '{are_nombre}','', array('are_estado'=>1), null, '', 'are_id', true);
			$data['parentescos'] = $this->gsatelite->get_dropdown('pat_parentesco', '{pat_nombre}','', array('pat_estado'=>1), null, '', 'pat_id', true);
			$this->_cargarvista($data);
		}
	}

		/**
	 * Descripción:
	 * se modifico que validara si existen los datos para mostrar dependiendo lo que el cliente seleccione
	 * @author      Marlon Olmedo
	 * @version     23-05-2019
	**/
function get_detalle_documentos() {
	$id = $this->input->post('id');
	$idemp = $this->input->post('idemp');
	if ($id > 0 and $idemp > 0) {
		echo $this->reporte_documentos($id,$idemp,1);
	} elseif ($idemp > 0) {
		echo $this->reporte_documentos('',$idemp,1);
	} elseif ($id>0) {
		echo $this->reporte_documentos($id,'',1);
	} elseif ($id==0 and $idemp==0) {
		echo $this->reporte_documentos('','',1);
	}
}

function get_funciones()
{
	$puesto = $this->input->post('puesto');
	//print_r($puesto);
	$funciones = $this->gsatelite->get_tabla('pto_puesto', array('pto_id' => $puesto));
	//print_r($funciones);
	$si = $funciones[0]['pto_funcion'];
	$html = '';
	$div = '';
	if ($si !='') {
		$respuesta = 1;
		
	}else{
		$respuesta = 0;
		$funcion = '';
	}
	$funcion = '<br><br><label  class="form-label span3" id="funcion_puesto" style="color:#0C0C0C">Funciones: </label>';
	
	$div .='<div id="label_1"> ';
	$div .='</div>';

	$div2 .='<div id="label_2"> ';
	$div2 .='</div>';
	
	$html .='<br><textarea rows="4" cols="200" style="width:100%; height:8%;" disabled>'.$funciones[0]['pto_funcion'].'</textarea>';
	$html2 .='<br><textarea rows="4" cols="200" style="width:100%; height:8%;" disabled>No se han asignado funciones a este puesto.</textarea>';
	echo json_encode(array('label'=>$html, 'resp'=>$respuesta, 'div' => $div, 'div2' => $div2 , 'sin_resp'=>$html2, 'funcion'=>$funcion));

}

function contratos() {
  	satelite_validar();
  	$data['titulo_personal']="Contratos";
  	//busca parametro para determinar el formato de contrato que puede imprimir
  	$data['formato_reporte'] = $this->gsatelite->get_parametro('SYS_FORMAT_REPORT_CONTRATO');
  	$data['empresa'] = $this->gsatelite->get_parametro('SYS_EMPRESA');
	$this->_cargarvista($data);
}

  /**
 * Descripción:
 * Función para reporte de Datos Academicos de Empleados
 * @author Luis Navarro - Grupo Satélite
 * @since 2017-12-16
 * @param $flag = valor que identifica si es reporte o impresion de html
 * @return Obtener Reporte de Empleados 
 */
  function datos_academicos($flag=NULL) {
    satelite_validar();
    if ($this->input->post()) {

        /*
         * Si es consulta ajax se toman los nombres del Jquery
         * De lo contrario, se toman los filtros de impresión
         */

        if ($flag) {
            $area = $this->input->post('area');
            $profesion = $this->input->post('profesion');
        } else {
            $area = $this->input->post('filtro_area');
            $profesion = $this->input->post('filtro_profesion');
        }

        $tipo_reporte = $this->input->post('tipo_reporte');

        $where = array();

        if ($area != '') {
            $where['emp_id_are'] = $area;
        }
        if ($profesion != ''){
            $where['emp_id_pro'] = $profesion;
        }

        $where['emp_estado'] = 1;

        $consulta = $this->expediente_personal_model->get_empleados_area_profesion($where);

        $filename = 'rpt_reporte_academicos' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
        $data['filename'] = $filename;
        $data['tipo_reporte'] = $tipo_reporte;
        $data['empleados'] = $consulta;

        $detalle = $this->load->view('expediente_personal/reportes/detalle_datos_academicos', $data, true);
        
        if ($flag) {
            echo json_encode($detalle);
            die();

        } else {
            if ($tipo_reporte == 'pdf') {

                $data['titulo'] = 'Datos academicos';
                $html = $this->load->view('reporte/header', $data, true);
                $GLOBALS['nombre_reporte'] = 'reporte_datos_academicos' . date('dmY');
                $html .= $this->load->view('expediente_personal/reportes/reporte_datos_academicos', $data, true);

                // echo $reporte;
                $this->pdf->makePdf($html, 'L', 'reporte_datos_academicos', 'Letter');
            } elseif ($tipo_reporte == 'excel') {

                $filename = 'rpt_reporte_datos_academicos_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
                $data['titulo'] = 'Reporte de datos academicos';
                $data['area'] = $this->gsatelite->get_tabla('are_area', array('are_id'=>$area));
                $data['profesion'] = $this->gsatelite->get_tabla('pro_profesion', array('pro_id'=>$profesion));
                $data['excel'] = 1;
                $data['filename'] = $filename;

                $html = $this->load->view('expediente_personal/reportes/reporte_datos_academicos', $data, true);

                echo $html;
            }
        }

    } else {
    					$this->db->join('nia_nivel_area', 'are_id_nia = nia_id', 'left');
    					$this->db->join('mxr_empresaxarea', 'mxr_id_are = are_id');
    					$this->db->where('mxr_id_emr',$this->tank_auth->get_empresa_id());
        $data['areas'] = $this->gsatelite->get_tabla('are_area',array('are_estado' => 1));
        $profesiones = $this->gsatelite->get_dropdown('pro_profesion', '{pro_nombre}', '', array('pro_estado' => 1), null, '', 'pro_id', true);
        $data["profesiones"] = str_replace('<option value="0">Seleccione</option>', '', $profesiones);
        $data['titulo_personal']="Reporte de profesión empleado";
        $this->_cargarvista($data);

    }
  }

  /**
 * Descripción:
 * Función para reporte de Empleados por Estado
 * @author Luis Navarro - Grupo Satélite
 * @since 2017-12-18
 * @param $flag = valor que identifica si es reporte o impresion de html
 * @return Obtener Reporte de Empleados por Estado
 */
  function empleados_estado($flag=NULL) {
    satelite_validar();
    if ($this->input->post()) {
    	if ($flag) {
            $estado = $this->input->post('estado');
            $contrato = $this->input->post('contrato');
        } else {
            $estado = $this->input->post('filtro_estado');
            $contrato = $this->input->post('filtro_contrato');
        }
        $tipo_reporte = $this->input->post('tipo_reporte');
        $where = array();
        if ($estado != '') {
            $where['emp_estado'] = $estado;
        }
        if ($contrato != ''){
            $where['emp_id_tic'] = $contrato;
        }
        $consulta = $this->expediente_personal_model->get_empleados_area_profesion($where);
        $filename = 'rpt_empleados_estado' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
        $data['filename'] = $filename;
        $data['tipo_reporte'] = $tipo_reporte;
        $data['empleados'] = $consulta;
        $detalle = $this->load->view('expediente_personal/reportes/detalle_empleados_estado', $data, true);
        if ($flag) {
            echo json_encode($detalle);
            die();
        } else {
            if ($tipo_reporte == 'pdf') {
            	$data['titulo'] = 'Empleadas/os Por Estado';
                $html = $this->load->view('reporte/header', $data, true);
                $GLOBALS['nombre_reporte'] = 'reporte_empleados_estado' . date('dmY');
                $html .= $this->load->view('expediente_personal/reportes/reporte_empleados_estado', $data, true);
                $this->pdf->makePdf($html, 'L', 'reporte_empleados_estado', 'Letter');
            } elseif ($tipo_reporte == 'excel') {
            	$filename = 'rpt_reporte_empleados_estado_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
                $data['titulo'] = 'Empleadas/os por Estado';

                //Datos enviados por POST
                $data['estado'] = $estado;
                $data['contrato'] = $contrato;
                $data['tipo_contratos'] = $this->gsatelite->get_tabla('tic_tipo_contrato', array('tic_estado'=>1));
                $data['excel'] = 1;
                $data['filename'] = $filename;
                $html = $this->load->view('expediente_personal/reportes/reporte_empleados_estado', $data, true);
                echo $html;
            }
        }


    } else {
        $tipos_contratos = $this->gsatelite->get_dropdown('tic_tipo_contrato', '{tic_nombre}', '', array('tic_estado' => 1), null, '', 'tic_id', true);
        $data['tipos_contratos'] = 	str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $tipos_contratos);
        $data['titulo_personal'] = "Reporte de Empleadas/os por Estado";
        $this->_cargarvista($data);
    }
  }


	function ingreso_personal(){
		satelite_validar();
        			 	 $this->db->join('nia_nivel_area', 'are_id_nia = nia_id', 'left');            
        			 	 $this->db->join('mxr_empresaxarea', 'mxr_id_are = are_id');
        			 	 $this->db->where('mxr_id_emr',$this->tank_auth->get_empresa_id());
		$data['areas'] = $this->gsatelite->get_tabla('are_area', array('are_estado' => 1));
		$data['slcEmpresa'] = $this->gsatelite->get_dropdown_empresa();
		$data['titulo_personal']    = "Reporte de ingreso de personal";
		$this->_cargarvista($data);
	}

	public function reporte_ingreso_personal($flag = null){
        satelite_validar();
        if ($_POST){
            $post_array = $this->input->post();
            /*
             * Si es consulta ajax se toman los nombres del Jquery
             * De lo contrario, se toman los filtros de impresión
             */

            if ($flag) {
                $area           = ($post_array['area'] != '') ? $post_array['area'] : null;
				$nombre_area    = ($post_array['nombre_area'] != '') ? $post_array['nombre_area'] : "todos";
				$fecha_ini = ($post_array['fecha_ini'] != '') ? date('Y-m-d', strtotime($post_array['fecha_ini'])) : null;
                $fecha_fin = ($post_array['fecha_fin'] != '') ? date('Y-m-d', strtotime($post_array['fecha_fin'])) : null;
            } else {
                $area = ($post_array['filtro_area'] != '') ? $post_array['filtro_area'] : null;
				$nombre_area    = ($post_array['filtro_area_nombre'] != '') ? $post_array['filtro_area_nombre'] : "todos";
				$fecha_ini = ($post_array['filtro_inicio'] != '') ? date('Y-m-d', strtotime($post_array['filtro_inicio'])) : null;
                $fecha_fin = ($post_array['filtro_fin'] != '') ? date('Y-m-d', strtotime($post_array['filtro_fin'])) : null;
            }

            //Tipo de Reportes si sera Excel o Pdf
            $tipo_reporte = $this->input->post('tipo_reporte');

            $where = null;

            if ($area !=  '') {
                $where['emp_id_are'] = $area;
			}
			
			if ($fecha_ini != '' && $fecha_fin != '') {
                $where['emp_fecha_contrato >='] = $fecha_ini;
                $where['emp_fecha_contrato <='] = $fecha_fin;
                $data['fecha_inicio'] = $fecha_ini;
                $data['fecha_fin'] = $fecha_fin;
            }

            $where['emp_estado'] = 1;
            $where['emp_id_emr'] = $this->input->post('slcEmpresa');

            $reporte = $this->expediente_personal_model->get_empleados_area_profesion($where);
		
            $filename = 'rpt_reporte_ingreso_personal' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename'] = $filename;
            $data['reporte'] = $reporte;
            $data['tipo_reporte'] = $tipo_reporte;
            $data['area_nombre']  = $nombre_area;
			$html = $this->load->view('expediente_personal/reportes/reporte_ingreso_personal', $data, true);

            if ($flag) {
                $dato["html"] = $html;
                $total =0;
                foreach ($reporte as $row) {
                    $total = $total + $row['emp_salario'];;
                }

                $dato["foot"] = "<th colspan='11' style='text-align: left;'> Total</th>
                                <th colspan='1' style='text-align: left;'>$". number_format($total, $this->gsatelite->get_parametro('NUMERO_DECIMALES'), '.', ',')."</th>";
				echo json_encode($dato);
				die();
            } else {
                if ($tipo_reporte == 'pdf') {

                    $data['titulo'] = 'ingreso de personal';

                    $header = $this->load->view('reporte/header', $data, true);

                    $GLOBALS['nombre_reporte'] = 'reporte_ingreso_personal' . date('dmY');

                    $reporte = $header . $html;

                    //echo $reporte;
                    $this->pdf->makePdf($reporte, 'L', 'reporte_ingreso_personal', 'Legal');
                } elseif ($tipo_reporte == 'excel') {

                    $filename = 'rpt_reporte_ingreso_personal_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

                    $data['titulo'] = 'ingreso personal';

                    $data['filename'] = $filename;

                    echo $html;
                }
            }
            
        } else{
            redirect('/expediente_personal/reportes/ingreso_personal');
		}
	}

    /**
     * Descripción:
     * Función para reporte de Contrataciones por Fuente de Reclutamiento
     * @author Luis Navarro - Grupo Satélite
     * @since 2017-12-18
     * @param $flag = valor que identifica si es reporte o impresion de html
     * @return Obtener Reporte de Fuente de Reclutamiento
     */
    public function fuente_reclutamiento($flag=NULL) {
        satelite_validar();
        if($this->input->post()) {            
            if ($flag) {
                $area = $this->input->post('area');
                $fuente = $this->input->post('fuente');
            } else {
                $area = $this->input->post('filtro_area');
                $fuente = $this->input->post('filtro_fuente');
            }
            $tipo_reporte = $this->input->post('tipo_reporte');
            $where = array('emp_estado' => 1);
            if ($area != '') {
                $where['emp_id_are'] = $area;
            }
            if ($fuente != ''){
                $where['emp_id_fnr'] = $fuente;
            }
            $consulta = $this->expediente_personal_model->get_listado_empleados($where);            
            $filename = 'rpt_fuente_reclutameinto' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename'] = $filename;
            $data['tipo_reporte'] = $tipo_reporte;
            $data['empleados'] = $consulta;
            $detalle = $this->load->view('expediente_personal/reportes/reporte_fuente_reclutamiento', $data, true);            
            if ($flag) {
                echo json_encode($detalle);
                die();
            } else {
                if ($tipo_reporte == 'pdf') {
                    $data['titulo'] = 'Contrataciones por Fuente de Reclutamiento';
                    $data['pdf'] = 1;                    
                    $header = $this->load->view('reporte/header', $data, true);
                    $GLOBALS['nombre_reporte'] = 'reporte_fuente_reclutamiento' . date('dmY');
                    $html = $this->load->view('expediente_personal/reportes/reporte_fuente_reclutamiento', $data, true);
                    $reporte = $header.$html;
                    // echo $reporte;
                    $this->pdf->makePdf($reporte, 'L', 'reporte_fuente_reclutamiento', 'Legal');
                } elseif ($tipo_reporte == 'excel') {
                    $filename = 'rpt_reporte_fuente_reclutamiento_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
                    $data['titulo'] = 'Fuente de Reclutamiento';
                    $data['excel'] = 1;
                    $data['filename'] = $filename;
                    $html = $this->load->view('expediente_personal/reportes/reporte_fuente_reclutamiento', $data, true);
                    echo $html;
                }
            }
        } else {
        			 $this->db->join('mxr_empresaxarea', 'mxr_id_are = are_id');
        			 $this->db->where('mxr_id_emr',$this->tank_auth->get_empresa_id());
            $areas = $this->gsatelite->get_dropdown('are_area', '{are_nombre}', '', array('are_estado' => 1), null, '', 'are_id', true);
            $data['areas'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $areas);

            $reclutamiento = $this->gsatelite->get_dropdown('fnr_fuente_reclutamiento', '{fnr_nombre}', '', array('fnr_estado' => 1), null, '', 'fnr_id', true);
            $data['reclutamiento'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $reclutamiento);
            $data['titulo_personal']="Reporte de Contrataciones por Fuente de Reclutamiento";
            $this->_cargarvista($data);
        }
	}

    /**
     * Descripción:
     * Función para reporte de Personal por Edad
     * @author Luis Navarro - Grupo Satélite
     * @since 2017-12-19
     * @param $flag = valor que identifica si es reporte o impresion de html
     * @return Obtener Reporte de personal por edad
     */
    public function personal_por_edad($flag=NULL) {
        satelite_validar();
        if($this->input->post()) {            
            if ($flag) {
                $area = $this->input->post('area');
                $edadDesde = $this->input->post('edadDesde');
                $edadHasta = $this->input->post('edadHasta');
            } else {
                $area = $this->input->post('filtro_area');
                $edadDesde = $this->input->post('filtro_edadDesde');
                $edadHasta = $this->input->post('filtro_edadHasta');
            }
            $tipo_reporte = $this->input->post('tipo_reporte');
            $where = array('emp_estado' => 1);
            if ($area != '') {
                $where['emp_id_are'] = $area;
            }
            if ($edadDesde != ''){
            	$where['TIMESTAMPDIFF(YEAR, emp_fecha_nac, CURDATE()) >= '] = $edadDesde;
            }
            if ($edadHasta != '') {
            	$where['TIMESTAMPDIFF(YEAR, emp_fecha_nac, CURDATE()) <= '] = $edadHasta;
            }
            $consulta = $this->expediente_personal_model->get_listado_empleados($where);
            $filename = 'rpt_personal_edad' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename'] = $filename;
            $data['tipo_reporte'] = $tipo_reporte;
            $data['empleados'] = $consulta;
            $detalle = $this->load->view('expediente_personal/reportes/reporte_personal_edad', $data, true);            
            if ($flag) {
                echo json_encode($detalle);
                die();
            } else {
                if ($tipo_reporte == 'pdf') {
                    $data['titulo'] = 'Personal por Edad';
                    $data['pdf'] = 1;                    
                    $data['are'] = $this->gsatelite->get_tabla('are_area', array('are_estado'=>1, 'are_id'=>$area));
                    $data['area'] = $area;
                    $data['edadDesde'] = $edadDesde;
                    $data['edadHasta'] = $edadHasta;
                    $header = $this->load->view('reporte/header', $data, true);
                    $GLOBALS['nombre_reporte'] = 'reporte_personal_edad' . date('dmY');
                    $html = $this->load->view('expediente_personal/reportes/reporte_personal_edad', $data, true);
                    $reporte = $header.$html;
                    $this->pdf->makePdf($reporte, 'L', 'reporte_personal_edad', 'Letter');
                } elseif ($tipo_reporte == 'excel') {
                    $filename = 'rpt_reporte_personal_edad_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
                    $data['titulo'] = 'Personal por Edad';
                    $data['are'] = $this->gsatelite->get_tabla('are_area', array('are_estado'=>1, 'are_id'=>$area));
                    $data['area'] = $area;
                    $data['edadDesde'] = $edadDesde;
                    $data['edadHasta'] = $edadHasta;
                    $data['excel'] = 1;
                    $data['filename'] = $filename;
                    $html = $this->load->view('expediente_personal/reportes/reporte_personal_edad', $data, true);
                    echo $html;
                }
            }
        } else {
        			 $this->db->join('mxr_empresaxarea', 'mxr_id_are = are_id');
        			 $this->db->where('mxr_id_emr',$this->tank_auth->get_empresa_id());
            $areas = $this->gsatelite->get_dropdown('are_area', '{are_nombre}', '', array('are_estado' => 1), null, '', 'are_id', true);
            $data['areas'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $areas);

            $data['titulo_personal']="Reporte de Personal por Edad";
            $this->_cargarvista($data);
        }
	}
	

	function personal_puesto(){
		satelite_validar();
						 $this->db->join('nia_nivel_area', 'are_id_nia = nia_id', 'left');
						 $this->db->join('mxr_empresaxarea', 'mxr_id_are = are_id');
						 $this->db->where('mxr_id_emr',$this->tank_auth->get_empresa_id());
		$data['areas'] = $this->gsatelite->get_tabla('are_area',array('are_estado' => 1));
		$data['slcEmpresa'] = $this->tank_auth->get_empresa_id();//$this->gsatelite->get_dropdown_empresa();

						   $this->db->join('mxp_empresaxpuesto', 'mxp_id_pto = pto_id');
						   $this->db->where('mxp_id_emr',$this->tank_auth->get_empresa_id());
		$data['puestos'] = $this->gsatelite->get_tabla('pto_puesto', array('pto_estado' => 1) );
		$data['titulo_personal'] = "Reporte de personal por puesto";
		$this->_cargarvista($data);
	}

	public function reporte_personal_puesto($flag = null){
        satelite_validar();
        if ($_POST){
            $post_array = $this->input->post();
            //print_r($post_array); die();
            /*
             * Si es consulta ajax se toman los nombres del Jquery
             * De lo contrario, se toman los filtros de impresión
            */
            if ($flag) {
				$area           = ($post_array['area'] != '') ? $post_array['area'] : null;
                $nombre_area    = ($post_array['nombre_area'] != '') ? $post_array['nombre_area'] : "todos";                
                $puesto         = ($post_array['puesto'] != '') ? $post_array['puesto'] : null;
				$nombre_puesto	= ($post_array['nombre_puesto'] != '') ? $post_array['nombre_puesto'] : "todos";
            } else {
                $area = ($post_array['filtro_area'] != '') ? $post_array['filtro_area'] : null;
                $nombre_area    = ($post_array['filtro_area_nombre'] != '') ? $post_array['filtro_area_nombre'] : "todos";                
                $puesto         = ($post_array['filtro_puesto'] != '') ? $post_array['filtro_puesto'] : null;
				$nombre_puesto	= ($post_array['filtro_puesto_nombre'] != '') ? $post_array['filtro_puesto_nombre'] : "todos";
            }
            //Tipo de Reportes si sera Excel o Pdf
            $tipo_reporte = $this->input->post('tipo_reporte');
            $where = null;
            if ($area != null) {
                $where['emp_id_are']    = $area;
			}            
            if ($puesto != null) {
                $where['pto_id']        = $puesto;
			}			 
            $where['emp_id_emr']  =  $post_array['slcEmpresa'];
			$reporte = $this->expediente_personal_model->get_empleados_area_profesion($where);
			$filename = 'rpt_reporte_personal_puesto' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
			$data['area_nombre']    = $nombre_area;
			$data['puesto_nombre']  = $nombre_puesto;
            $data['filename'] 		= $filename;
            $data['reporte'] 		= $reporte;
            $data['tipo_reporte'] 	= $tipo_reporte;           
			$html = $this->load->view('expediente_personal/reportes/reporte_personal_puesto', $data, true);		
            if ($flag) {
                $dato["html"] = $html;
				echo json_encode($dato);
				die();
            } else {
                if ($tipo_reporte == 'pdf') {
                    $data['titulo'] = 'Personal por Puesto';
                    $header = $this->load->view('reporte/header', $data, true);
                    $GLOBALS['nombre_reporte'] = 'reporte_personal_puesto' . date('dmY');
                    $reporte = $header . $html;
                    $this->pdf->makePdf($reporte, 'L', 'reporte_personal_puesto', 'Letter');
                } elseif ($tipo_reporte == 'excel') {
                    $filename = 'rpt_personal_puesto_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
                    $data['titulo'] = 'personal puesto';
                    $data['filename'] = $filename;
                    echo $html;
                }
            }
            
        } else{
            redirect('expediente_personal/reportes/personal_puesto');
		}
	}


	function empleado_area(){
		satelite_validar();
								   $this->db->join('nia_nivel_area', 'are_id_nia = nia_id', 'left');
								   $this->db->join('mxr_empresaxarea', 'mxr_id_are = are_id');
								   $this->db->where('mxr_id_emr',$this->tank_auth->get_empresa_id());
		$data['areas'] 			 = $this->gsatelite->get_tabla('are_area',array('are_estado' => 1));
		$data['tipo_contrato'] 	 = $this->gsatelite->get_tabla('tic_tipo_contrato', array('tic_estado' => 1) );
		$data['titulo_personal'] = "Reporte de empleado por área";
		$this->_cargarvista($data);
	}

	public function reporte_empleado_area($flag = null){
        satelite_validar();
        if ($_POST){
            $post_array = $this->input->post();
            /*
             * Si es consulta ajax se toman los nombres del Jquery
             * De lo contrario, se toman los filtros de impresión
            */
            if ($flag) {
				$area           = ($post_array['area'] != '') ? $post_array['area'] : null;
                $nombre_area    = ($post_array['nombre_area'] != '') ? $post_array['nombre_area'] : "todos";
                
                $puesto         = ($post_array['puesto'] != '') ? $post_array['puesto'] : null;
				$nombre_puesto	= ($post_array['nombre_puesto'] != '') ? $post_array['nombre_puesto'] : "todos";
            } else {
                $area = ($post_array['filtro_area'] != '') ? $post_array['filtro_area'] : null;
                $nombre_area    = ($post_array['filtro_area_nombre'] != '') ? $post_array['filtro_area_nombre'] : "todos";
                
                $puesto         = ($post_array['filtro_puesto'] != '') ? $post_array['filtro_puesto'] : null;
				$nombre_puesto	= ($post_array['filtro_puesto_nombre'] != '') ? $post_array['filtro_puesto_nombre'] : "todos";
            }
		
            //Tipo de Reportes si sera Excel o Pdf
            $tipo_reporte = $this->input->post('tipo_reporte');

            $where = null;

            if ($area != null) {
                $where['emp_id_are']    = $area;
			}
            
            if ($puesto != null) {
                $where['tic_id']        = $puesto;
			}

			$where['emp_estado']		= 1;

			$reporte = $this->expediente_personal_model->get_empleados_area_profesion($where);
		
			$filename = 'rpt_reporte_empleado_area' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
			$data['area_nombre']    = $nombre_area;
			$data['puesto_nombre']  = $nombre_puesto;
            $data['filename'] 		= $filename;
            $data['reporte'] 		= $reporte;
            $data['tipo_reporte'] 	= $tipo_reporte;
           
			$html = $this->load->view('expediente_personal/reportes/reporte_empleado_area', $data, true);
		
            if ($flag) {
                $dato["html"] = $html;
				echo json_encode($dato);
				die();
            } else {
                if ($tipo_reporte == 'pdf') {

                    $data['titulo'] = 'empleado ';

                    $header = $this->load->view('reporte/header', $data, true);

                    $GLOBALS['nombre_reporte'] = 'reporte_empleado_area' . date('dmY');

                    $reporte = $header . $html;

                    $this->pdf->makePdf($reporte, 'L', 'reporte_empleado_area', 'Letter');
                } elseif ($tipo_reporte == 'excel') {

                    $filename = 'rpt_empleado_area_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

                    $data['titulo'] = 'empleado área';

                    $data['filename'] = $filename;

                    echo $html;
                }
            }
            
        } else{
            redirect('expediente_personal/reportes/empleado_area');
		}
	}

    /**
     * Descripción:
     * Función para reporte de Personal por Tipo de Experiencia
     * @author Luis Navarro - Grupo Satélite
     * @since 2017-12-19
     * @param $flag = valor que identifica si es reporte o impresion de html
     * @return Obtener Reporte de personal por Tipo de experiencia
     */
    public function tipo_experiencia($flag=NULL) {
    	satelite_validar();
    	if($this->input->post()) {
    		if ($flag) {
    			$area = $this->input->post('area');
    			$tipo_experiencia = $this->input->post('tipoExperiencia');
    			$empleado = $this->input->post('empleado');     			
    		} else {
    			$area = $this->input->post('filtro_area');
    			$tipo_experiencia = $this->input->post('filtro_tipoExperiencia');
    			$empleado = $this->input->post('empleado');
    		}
    		$tipo_reporte = $this->input->post('tipo_reporte');
    		$where = array('emp_estado' => 1);
    		if ($area != '') {
    			$where['emp_id_are'] = $area;
    		}
    		if ($tipo_experiencia != ''){
    			$where['tie_id'] = $tipo_experiencia;
    		}
    		if ($empleado != ''){
    			$where['emp_id'] = $empleado;
    		}            
    		$consulta = $this->expediente_personal_model->get_tipo_experiencia_emp($where, 'emp_id');
    		// var_dump($this->db->last_query());die();
            $filename = 'reporte_tipo_experiencia' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename'] = $filename;
            $data['tipo_reporte'] = $tipo_reporte;
            $data['empleados'] = $consulta;
            $detalle = $this->load->view('expediente_personal/reportes/reporte_tipo_experiencia', $data, true);
            if ($flag) {
                echo json_encode($detalle);
                die();
            } else {
                if ($tipo_reporte == 'pdf') {
                    $data['titulo'] = 'Personal por tipo de experiencia';
                    $data['pdf'] = 1;
                    $data['are'] = $this->gsatelite->get_tabla('are_area', array('are_estado'=>1, 'are_id'=>$area));
                    $data['area'] = $area;
                    $data['tipo_experiencia'] = $tipo_experiencia;
                    $data['experiencia'] = $this->gsatelite->get_tabla('tie_tipo_educacion', array('tie_estado'=>1));
                    $header = $this->load->view('reporte/header', $data, true);
                    $GLOBALS['nombre_reporte'] = 'reporte_tipo_experiencia' . date('dmY');
                    $html = $this->load->view('expediente_personal/reportes/reporte_tipo_experiencia', $data, true);
                    $reporte = $header.$html;
                    $this->pdf->makePdf($reporte, 'L', 'reporte_tipo_experiencia', 'Letter');
                } elseif ($tipo_reporte == 'excel') {
                    $filename = 'rpt_reporte_tipo_experiencia_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
                    $data['titulo'] = 'Personal por tipo de experiencia';
                    $data['are'] = $this->gsatelite->get_tabla('are_area', array('are_estado'=>1, 'are_id'=>$area));
                    $data['area'] = $area;
                    $data['tipo_experiencia'] = $tipo_experiencia;
                    $data['experiencia'] = $this->gsatelite->get_tabla('tie_tipo_educacion', array('tie_estado'=>1));
                    $data['excel'] = 1;
                    $data['filename'] = $filename;
                    $html = $this->load->view('expediente_personal/reportes/reporte_tipo_experiencia', $data, true);
                    echo $html;
                }
            }
        } else {
        			 		 $this->db->join('mxr_empresaxarea', 'mxr_id_are = are_id');
        			 		 $this->db->where('mxr_id_emr',$this->tank_auth->get_empresa_id());
        			 		 $this->db->join('nia_nivel_area', 'are_id_nia = nia_id', 'left');
            $data['areas'] = $this->gsatelite->get_tabla('are_area', array('are_estado' => 1));
            $tipo_experiencia = $this->gsatelite->get_dropdown('tie_tipo_educacion', '{tie_nombre}', '', array('tie_estado' => 1), null, '', 'tie_id', true);
            $empleados = $this->gsatelite->get_dropdown('emp_empleado', '{emp_codigo} - {emp_nombre} {emp_apellido}', '', array('emp_estado' => 1), null, '', 'emp_id', true);
            $data['empleados'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $empleados);
            $data['tipo_experiencia'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $tipo_experiencia);
            $data['titulo_personal'] = "Reporte de personal por tipo de experiencia";
            $this->_cargarvista($data);
        }
	}
	
	function tipo_salario(){
		satelite_validar();
        						   $this->db->join('nia_nivel_area', 'are_id_nia = nia_id', 'left');
								   $this->db->join('mxr_empresaxarea', 'mxr_id_are = are_id');
								   $this->db->where('mxr_id_emr',$this->tank_auth->get_empresa_id());
		$data['areas'] 			 = $this->gsatelite->get_tabla('are_area',array('are_estado' => 1));
		$data['tipo_salario'] 	 = $this->gsatelite->get_tabla('tps_tipo_salario',array('tps_estado' => 1));
		$data['titulo_personal'] = "Reporte de personal por tipo de salario";
		$this->_cargarvista($data);
	}

	public function reporte_tipo_salario($flag = null){
        satelite_validar();
        if ($_POST){
            $post_array = $this->input->post();
            /*
             * Si es consulta ajax se toman los nombres del Jquery
             * De lo contrario, se toman los filtros de impresión
            */
            if ($flag) {
				$area           = ($post_array['area'] != '') ? $post_array['area'] : null;
                $nombre_area    = ($post_array['nombre_area'] != '') ? $post_array['nombre_area'] : "todos";
                
                $puesto         = ($post_array['puesto'] != '') ? $post_array['puesto'] : null;
				$nombre_puesto	= ($post_array['nombre_puesto'] != '') ? $post_array['nombre_puesto'] : "todos";
            } else {
                $area = ($post_array['filtro_area'] != '') ? $post_array['filtro_area'] : null;
                $nombre_area    = ($post_array['filtro_area_nombre'] != '') ? $post_array['filtro_area_nombre'] : "todos";
                
                $puesto         = ($post_array['filtro_puesto'] != '') ? $post_array['filtro_puesto'] : null;
				$nombre_puesto	= ($post_array['filtro_puesto_nombre'] != '') ? $post_array['filtro_puesto_nombre'] : "todos";
            }
		
            //Tipo de Reportes si sera Excel o Pdf
            $tipo_reporte = $this->input->post('tipo_reporte');

            $where = null;

            if ($area != null) {
                $where['emp_id_are']    = $area;
			}
            
            if ($puesto != null) {
                $where['tps_id']        = $puesto;
			}

			$where['emp_estado']		= 1;

			$reporte = $this->expediente_personal_model->get_listado_empleados($where);
		
			$filename = 'rpt_reporte_tipo_salario' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
			$data['area_nombre']    = $nombre_area;
			$data['puesto_nombre']  = $nombre_puesto;
            $data['filename'] 		= $filename;
            $data['reporte'] 		= $reporte;
            $data['tipo_reporte'] 	= $tipo_reporte;
           
			$html = $this->load->view('expediente_personal/reportes/reporte_tipo_salario', $data, true);
		
            if ($flag) {
                $dato["html"] = $html;
				echo json_encode($dato);
				die();
            } else {
                if ($tipo_reporte == 'pdf') {

                    $data['titulo'] = 'tipo de salario ';

                    $header = $this->load->view('reporte/header', $data, true);

                    $GLOBALS['nombre_reporte'] = 'reporte_tipo_salario' . date('dmY');

                    $reporte = $header . $html;

                    $this->pdf->makePdf($reporte, 'L', 'reporte_tipo_salario', 'Letter');
                } elseif ($tipo_reporte == 'excel') {

                    $filename = 'rpt_tipo_salario_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

                    $data['titulo'] = 'tipo de salario';

                    $data['filename'] = $filename;

                    echo $html;
                }
            }
            
        } else{
            redirect('expediente_personal/reportes/tipo_salario');
		}
	}

    /**
     * Descripción:
     * Función para reporte de Familiares de Personal
     * @author Luis Navarro - Grupo Satélite
     * @since 2017-12-20
     * @param $flag = valor que identifica si es reporte o impresion de html
     * @return Obtener Reporte de Familiares por Personal
     */
    function familiares_personal($flag = null) {
        satelite_validar();
        if($this->input->post()) {
            if ($flag) {
                $area = $this->input->post('area');
                $parentesco = $this->input->post('parentesco');
                $empleado = $this->input->post('empleado');
            } else {
                $area = $this->input->post('filtro_area');
                $parentesco = $this->input->post('filtro_parentesco');
                $empleado = $this->input->post('filtro_empleado');
            }
            $tipo_reporte = $this->input->post('tipo_reporte');
            $where = array('emp_estado' => 1, 'fam_estado' => 1);
            if ($area != '') {
                $where["emp_id_are IN($area)"] = null;
            }
            if ($parentesco != ''){
                $where["pat_id IN ($parentesco)"] = null;
            }            
            if ($empleado != ''){
                $where["emp_id IN ($empleado)"] = null;
            }            
            $consulta = $this->expediente_personal_model->get_tipo_experiencia_emp($where, 'emp_id, fam_id');
            $filename = 'reporte_familiares_personal' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename'] = $filename;
            $data['tipo_reporte'] = $tipo_reporte;
            $data['empleados'] = $consulta;
            $data['pat'] = $this->gsatelite->get_tabla('pat_parentesco', array('pat_estado'=>1));
            $detalle = $this->load->view('expediente_personal/reportes/reporte_familiares_personal', $data, true);            
            if ($flag) {
                echo json_encode(array('detalle' => $detalle, 'filas' => count($consulta)));
                die();
            } else {
                if ($tipo_reporte == 'pdf') {
                    $data['titulo'] = 'Familiares por Personal';
                    $header = $this->load->view('reporte/header', $data, true);
                    $GLOBALS['nombre_reporte'] = 'reporte_familiares_personal' . date('dmY');
                    $reporte = $header . $detalle;
                    $this->pdf->makePdf($reporte, 'L', 'reporte_familiares_personal', 'Letter');
                } elseif ($tipo_reporte == 'excel') {
                	echo $detalle; 
                }
            }
        } else {
        			 		 $this->db->join('mxr_empresaxarea', 'mxr_id_are = are_id');
    				 		 $this->db->join('nia_nivel_area', 'are_id_nia = nia_id', 'left');
        			 		 $this->db->where('mxr_id_emr',$this->tank_auth->get_empresa_id());
            $data['areas'] = $this->gsatelite->get_tabla('are_area', array('are_estado' => 1));
            $parentesco = $this->gsatelite->get_dropdown('pat_parentesco', '{pat_nombre}', '', array('pat_estado' => 1), null, '', 'pat_id', true);
            $data['parentesco'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $parentesco);
            $empleados = $this->gsatelite->get_dropdown('emp_empleado', '{emp_codigo} - {emp_nombre} {emp_apellido}', '', array('emp_estado' => 1), null, '', 'emp_id', true);
            $data['empleados'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $empleados);
            $data['titulo_personal'] = "Reporte de Familiares por Personal";
            $this->_cargarvista($data);
        }
    }

	function ingreso_bajas(){
		satelite_validar();
		$data['slcEmpresa'] = $this->tank_auth->get_empresa_id();
		$data['titulo_personal'] = "Reporte de ingresos y bajas de personal";
		$this->_cargarvista($data);
	}


	public function reporte_ingreso_bajas($flag = null){
        satelite_validar();
        if ($_POST){
            $post_array = $this->input->post();
            /* Si es consulta ajax se toman los nombres del Jquery, De lo contrario, se toman los filtros de impresión */
            if ($flag) {
				$tipo           = ($post_array['tipo'] != '') ? $post_array['tipo'] : null;
				$nombre_tipo   	= ($post_array['nombre_tipo'] != '') ? $post_array['nombre_tipo'] : "todos";
				
				$fecha_ini 		= ($post_array['fecha_ini'] != '') ? date('Y-m-d', strtotime($post_array['fecha_ini'])) : null;
                $fecha_fin 		= ($post_array['fecha_fin'] != '') ? date('Y-m-d', strtotime($post_array['fecha_fin'])) : null;
            } else {
                $tipo 			= ($post_array['filtro_tipo'] != '') ? $post_array['filtro_tipo'] : null;
				$nombre_tipo    = ($post_array['filtro_tipo_nombre'] != '') ? $post_array['filtro_tipo_nombre'] : "todos";

				$fecha_ini 		= ($post_array['filtro_inicio'] != '') ? date('Y-m-d', strtotime($post_array['filtro_inicio'])) : null;
                $fecha_fin 		= ($post_array['filtro_fin'] != '') ? date('Y-m-d', strtotime($post_array['filtro_fin'])) : null;
            }		
            //Tipo de Reportes si sera Excel o Pdf
            $tipo_reporte = $this->input->post('tipo_reporte');
            $where = array('emp_id_emr' => $this->input->post('slcEmpresa'));
            if ($tipo != null) {
            	$where['emp_estado']    = $tipo;
            }
            if ($tipo == 1){
				$where['DATE(emp_fecha_contrato) >=']	= $fecha_ini;
				$where['DATE(emp_fecha_contrato) <=']	= $fecha_fin;
				$reporte = $this->expediente_personal_model->get_listado_empleados($where);
			} else {
				$where['DATE(rte_fecha_retiro) >=']	= $fecha_ini;
				$where['DATE(rte_fecha_retiro) <='] = $fecha_fin;
				$reporte = $this->expediente_personal_model->get_retiro_empleados($where);
			}
			$filename = 'rpt_reporte_ingreso_bajas' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
			$data['fecha_inicio'] 	= $fecha_ini;
			$data['fecha_fin'] 		= $fecha_fin;
			$data['tipo_nombre']    = $nombre_tipo;
			$data['tipo_filtro']	= $tipo;
            $data['filename'] 		= $filename;
            $data['reporte'] 		= $reporte;
            $data['tipo_reporte'] 	= ($tipo_reporte)?$tipo_reporte:"";
			$html = $this->load->view('expediente_personal/reportes/reporte_ingreso_bajas', $data, true);
            if ($flag) {
                $dato["html"] = $html;
				echo json_encode($dato);
				die();
            } else {
                if ($tipo_reporte == 'pdf') {
                	$data['titulo'] = 'ingreso y bajas de personal ';
                    $header = $this->load->view('reporte/header', $data, true);
                    $GLOBALS['nombre_reporte'] = 'reporte_ingreso_bajas' . date('dmY');
                    $reporte = $header . $html;
                    $this->pdf->makePdf($reporte, 'L', 'reporte_ingreso_bajas', 'Letter');
                } elseif ($tipo_reporte == 'excel') {
                    $filename = 'rpt_ingreso_bajas_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
                    $data['titulo'] = 'ingreso y bajas de personal';
                    $data['filename'] = $filename;
                    echo $html;
                }
            }            
        } else{
            redirect('expediente_personal/reportes/ingreso_bajas');
		}
	}

	/**
     * Descripción:
     * Función para reporte de Empleado por tipo de construccion de vivienda
     * @author Elman Ortiz - Grupo Satélite
     * @since 2017-12-21
     * @param $flag = valor que identifica si es reporte o impresion de html
     * @return Obtener Retorna html o reporte
     */
	function reporte_empleado_tipo_vivienda($flag = null){				
        satelite_validar();
        if ($_POST){
        	$post_array = $this->input->post();
            if ($flag) {
				$tipoconstruccion = ($post_array['tipoconstruccion'] != '') ? $post_array['tipoconstruccion'] : null;
                $departamento     = ($post_array['departamento'] != '') ? $post_array['departamento'] : null;                
                $municipio        = ($post_array['municipio'] != '') ? $post_array['municipio'] : null;				
            } else {
				$tipoconstruccion = ($post_array['htipocontruccion'] != '') ? $post_array['htipocontruccion'] : null;
                $departamento     = ($post_array['hdepartamento'] != '') ? $post_array['hdepartamento'] : null;                
                $municipio        = ($post_array['hmunicipio'] != '') ? $post_array['hmunicipio'] : null;
                $data['tipoconstrucciontext'] = ($post_array['htipocontrucciontext'] != '') ? '<b>Tipo vivienda: </b>' . $post_array['htipocontrucciontext'] : '<b>Tipo vivienda: </b>' .'Todos';
                $data['departamentotext']     = ($post_array['hdepartamentotext'] != '') ? '<b>Departamento: </b>' . $post_array['hdepartamentotext'] : '<b>Departamento: </b>' . 'Todos';
                $data['municipiotext'] 		  = ($post_array['hmunicipiotext'] != '') ? '<b>Municipio: </b>' . $post_array['hmunicipiotext'] : '<b>Municipio: </b>' . 'Todos';                
            }
            //Tipo de Reportes si sera Excel o Pdf
            $tipo_reporte = $this->input->post('tipo_reporte');
            $where = null;
            if ($tipoconstruccion != null) {
                $where['emp_id_tcv'] = $tipoconstruccion;
			}
            if ($departamento != null) {
                $where['mun_id_dep'] = $departamento;
			}
			if ($municipio != null) {
                $where['emp_id_mun'] = $municipio;
			}
			$where['emp_estado'] = 1;
			$reporte = $this->expediente_personal_model->get_empleados_tipo_construccion($where);
			$filename = 'reporte_empleado_tipo_vivienda' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename'] 			   = $filename;
            $data['reporte'] 			   = $reporte;
            $data['tipo_reporte'] 		   = $tipo_reporte;
            $html = $this->load->view('expediente_personal/reportes/filtrar_cliente_tipo_construccion_vivienda', $data, true);
            if ($flag) {
            	echo $html;
				die();
            } else {
                if ($tipo_reporte == 'pdf') {

                    $data['titulo'] = 'empleado por tipo de vivienda';
                    $header = $this->load->view('reporte/header', $data, true);
                    $GLOBALS['nombre_reporte'] = 'reporte_empleado_tipo_vivienda_' . date('dmY');
                    $reporte = $header . $html;
                    $this->pdf->makePdf($reporte, 'L', 'reporte_empleado_tipo_vivienda', 'Letter');
                } elseif ($tipo_reporte == 'excel') {
                	$filename = 'rpt_empleado_tipo_vivienda_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
                	$data['titulo'] = 'empleado por tipo de vivienda';
                	$data['filename'] = $filename;
                	echo $html;
                }
            }
        } else {
        	$select = $this->gsatelite->get_dropdown('tcv_tipo_construccion_vivienda', '{tcv_nombre}', '', array('tcv_estado' => 1), null, '', 'tcv_id', true);
			$data["slcTipoConstruccion"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);        	
        	$select = $this->gsatelite->get_dropdown('dep_departamento', '{dep_nombre}', '', array('dep_estado' => 1), null, '', 'dep_id', true);
        	$data["slcDepartamento"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
        	$data['titulo_personal'] = "Empleadas/os por tipo de vivienda";
        	$this->_cargarvista($data);
		}
	}	

    /**
     * Descripción:
     * Función para reporte de Personal por Zona de Residencia
     * @author Luis Navarro - Grupo Satélite
     * @since 2017-12-21
     * @param $flag = valor que identifica si es reporte o impresion de html
     * @return Obtener Reporte
     */
    public function zona_residencia($flag = null) {
        satelite_validar();
        if($this->input->post()) {
            if ($flag) {
                $departamento = $this->input->post('departamento');
                $municipio = $this->input->post('municipio');                
            } else {
                $departamento = $this->input->post('filtro_departamento');
                $municipio = $this->input->post('filtro_municipio');                
            }
            $tipo_reporte = $this->input->post('tipo_reporte');
            $where = array();
            if ($departamento != '') {
                $where['dep_id'] = $departamento;
            }
            if ($municipio != ''){
                $where['emp_id_mun'] = $municipio;
            }            
            $where['emp_estado'] = 1;
            $where['emp_id_emr'] = $this->tank_auth->get_empresa_id();
            $consulta = $this->expediente_personal_model->get_emp_zona_residencia($where);
            $filename = 'reporte_zona_residencia' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename'] = $filename;
            $data['tipo_reporte'] = $tipo_reporte;
            $data['empleados'] = $consulta;
            $data['departamento'] = $departamento;
            $data['dep'] = $this->gsatelite->get_tabla('dep_departamento', array('dep_estado'=>1));
            $data['municipio'] = $municipio;
            $data['mun'] = $this->gsatelite->get_tabla('mun_municipio', array('mun_estado'=>1));

            $detalle = $this->load->view('expediente_personal/reportes/reporte_zona_residencia', $data, true);
            
            if ($flag) {
                echo json_encode($detalle);
                die();
            } else {
                if ($tipo_reporte == 'pdf') {
                    $data['titulo'] = 'Zona de Residencia';
                    $data['pdf'] = 1;
                    $header = $this->load->view('reporte/header', $data, true);
                    $GLOBALS['nombre_reporte'] = 'reporte_zona_residencia' . date('dmY');
                    $html = $this->load->view('expediente_personal/reportes/reporte_zona_residencia', $data, true);
                    $reporte = $header.$html;
                    $this->pdf->makePdf($reporte, 'L', 'reporte_zona_residencia', 'Letter');
                } elseif ($tipo_reporte == 'excel') {
                    $filename = 'rpt_reporte_zona_residencia_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
                    $data['titulo'] = 'Zona de Residencia';
                    $data['excel'] = 1;
                    $data['filename'] = $filename;
                    $html = $this->load->view('expediente_personal/reportes/reporte_zona_residencia', $data, true);
                    echo $html;
                }
            }
        } else {
        	$departamentos = $this->gsatelite->get_dropdown('dep_departamento', '{dep_nombre}', '', array('dep_estado' => 1), null, '', 'dep_id', true);
        	$data['departamentos'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $departamentos);
            $data['titulo_personal'] = "Reporte de Personal por Zona de Residencia";
            $this->_cargarvista($data);
        }
    }

    /**
     * Descripción:
     * Función para obtener los municipios por departamento (tabla mun_municipio)
     * @author Luis Navarro - Grupo Satélite
     * @since 2017-12-21
     * @param Ninguno
     * @return Obtener los municipios
     */
    public function ajax_municipio() {
    	if($this->input->post()) {
    		$departamento = $this->input->post('departamento');
        	$where = array(
        		'mun_estado' => 1, 
        		'dep_id' => $departamento
        	);
            	   $this->db->join('dep_departamento', 'mun_id_dep=dep_id');
            $mun = $this->gsatelite->get_dropdown('mun_municipio', '{mun_nombre}', '', $where, null, '', 'mun_id', true);
            $municipios = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $mun);
            echo json_encode(array("municipios" => $municipios, "exito" => 1));
        }
    }    

    /**
     * Descripción:
     * Función para reporte de Empleados por Tipo de Contrato
     * @author Luis Navarro - Grupo Satélite
     * @since 2017-12-21
     * @param $flag = valor que identifica si es reporte o impresion de html
     * @return Obtener Reporte
     */
    public function tipo_contrato($flag=NULL) {
    	satelite_validar();
    	if($this->input->post()) {
    		$where_empleado = null;
    		$tipo_contrato = ($this->input->post('filtro_tipo_contrato') > 0) ? $this->input->post('filtro_tipo_contrato') : null;
    		$fechaDesde = ($this->input->post('filtro_inicio') != "") ? formatear_fecha('Y-m-d', $this->input->post('filtro_inicio')) : null;
    		$fechaHasta = ($this->input->post('filtro_fin') != "") ?  formatear_fecha('Y-m-d', $this->input->post('filtro_fin')) : null;
            $slcEstado = (is_numeric($this->input->post('filtro_estado'))) ? $this->input->post('filtro_estado') : null;
            $tipo_reporte = $this->input->post('tipo_reporte');
            // Condiciones 
            if ($slcEstado){
                $where_empleado['emp_estado'] = ($slcEstado - 1);
            }
            if ($fechaDesde) {
            	$where_empleado['emp_fecha_contrato >= '] = $fechaDesde;
            }
            if ($fechaHasta) {
            	$where_empleado['emp_fecha_contrato <= '] = $fechaHasta;
            }
            if ($tipo_contrato){
                $where_empleado['emp_id_tic'] = $tipo_contrato;
            }
            $data['registros_empleado']   = $this->expediente_personal_model->get_empleado_tipo_contrato($where_empleado, 'emp_id');

            $filename = 'reporte_tipo_contrato' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename'] = $filename;
            $data['tipo_reporte'] = $tipo_reporte;
        
            $data['fechaDesde'] = $fechaDesde;
            $data['fechaHasta'] = $fechaHasta;
            $data['tipo_contrato'] = $tipo_contrato;
            $data['contratos'] = $this->gsatelite->get_tabla('tic_tipo_contrato', array('tic_id'=>$tipo_contrato));
            
            $detalle = $this->load->view('expediente_personal/reportes/reporte_tipo_contrato', $data, true);
            
            if ($flag) {
                echo json_encode(array('tabla' => $detalle, 'filas' => count($data['registros_empleado'])));
                die();

            } else {
                if ($tipo_reporte == 'pdf') {

                    $data['titulo'] = 'Empleadas/os por Tipo de Contrato';
                    $data['pdf'] = 1;

                    $header = $this->load->view('reporte/header', $data, true);
                    $GLOBALS['nombre_reporte'] = 'reporte_tipo_contrato' . date('dmY');
                    $html = $this->load->view('expediente_personal/reportes/reporte_tipo_contrato', $data, true);
                    $reporte = $header.$html;

                    // echo $reporte;
                    $this->pdf->makePdf($reporte, 'L', 'reporte_tipo_contrato', 'Legal');
                } elseif ($tipo_reporte == 'excel') {

                    $filename = 'rpt_reporte_tipo_contrato_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
                    $data['titulo'] = 'Empleadas/os por Tipo de Contrato';

                    $data['excel'] = 1;
                    $data['filename'] = $filename;
                    $html = $this->load->view('expediente_personal/reportes/reporte_tipo_contrato', $data, true);
                    echo $html;
                }
            }

        } else {
            $tipo_contrato = $this->gsatelite->get_dropdown('tic_tipo_contrato', '{tic_nombre}', '', array('tic_estado' => 1), null, '', 'tic_id', true);
            $data['tipo_contrato'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $tipo_contrato);
            // $data['slcEmpresa'] = $this->gsatelite->get_dropdown_empresa();
            $data['titulo_personal'] = "Empleadas/os por Tipo de Contrato";
            $this->_cargarvista($data);
        }
    }

    /**
     * Descripción:
     * Función para reporte de Promociones Niveles
     * @author Elman Ortiz - Grupo Satélite
     * @since 2017-12-21
     * @param $flag = valor que identifica si es reporte o impresion de html
     * @return Obtener Retorna html o reporte
     */
	function reporte_promociones_niveles($flag = null){				
        satelite_validar();
        if ($_POST){
            $post_array = $this->input->post();
            /* Si es consulta ajax se toman los nombres del Jquery, De lo contrario, se toman los filtros de impresión */
            if ($flag) {				
                $fecha_ini     	= ($post_array['fecha_ini'] != '') ? $post_array['fecha_ini'] : null;                
                $fecha_fin     	= ($post_array['fecha_fin'] != '') ? $post_array['fecha_fin'] : null;                
                $tipo_promocion = ($post_array['filtro_tipo_promocion'] != '') ? $post_array['filtro_tipo_promocion'] : null;
                $plaza 			= ($post_array['plaza'] != '') ? $post_array['plaza'] : null;				
            } else {
				$fecha_ini     	= ($post_array['filtro_inicio'] != '') ? $post_array['filtro_inicio'] : null;                
                $fecha_fin     	= ($post_array['filtro_fin'] != '') ? $post_array['filtro_fin'] : null;                
                $tipo_promocion = ($post_array['filtro_tipo_promocion'] != '') ? $post_array['filtro_tipo_promocion'] : null;
                $plaza 			= ($post_array['filtro_area'] != '') ? $post_array['filtro_area'] : null;
                $data['tipo_promociontext'] = ($post_array['filtro_tipo_promocion_nombre'] != '') ? '<b>Tipo promoción: </b>' . $post_array['filtro_tipo_promocion_nombre'] : '<b>Tipo promoción: </b>' .'Todos';
                $data['plazatext']     = ($post_array['filtro_area_nombre'] != '') ? '<b>Área: </b>' . $post_array['filtro_area_nombre'] : '<b>Área: </b>' . 'Todos';
                $data['fecha_initext'] = ($post_array['filtro_inicio'] != '') ? '<b>Desde: </b>' . $post_array['filtro_inicio'] : '<b>Desde: </b>' . 'Todos';
                $data['fecha_fintext'] = ($post_array['filtro_fin'] != '') ? '<b>Hasta: </b>' . $post_array['filtro_fin'] : '<b>Hasta: </b>' . 'Todos';
            }
            //Tipo de Reportes si sera Excel o Pdf
            $tipo_reporte = $this->input->post('tipo_reporte');
            $where = array('emp_estado' => 1);
            if ($fecha_ini != null) {
            	$where['DATE(pps_fecha_efectiva) >= '] = formatear_fecha('Y-m-d', $fecha_ini);                
			}            
            if ($fecha_fin != null) {
                $where['DATE(pps_fecha_efectiva) <= '] = formatear_fecha('Y-m-d', $fecha_fin);                
			}
			if ($tipo_promocion != null) {
                $where['pps_tipo']        = $tipo_promocion;
			}
			if ($plaza != null) {
                $where['are_id']        = $plaza;
			}

			$reporte = $this->expediente_personal_model->reporte_promociones_niveles($where);
			$filename = 'rpt_reporte_promociones_niveles' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);			
            $data['filename'] 			   = $filename;
            $data['reporte'] 			   = $reporte;
            $data['tipo_reporte'] 		   = $tipo_reporte;
			$html = $this->load->view('expediente_personal/reportes/filtrar_promociones_niveles', $data, true);			
            if ($flag) {                
				echo $html;
				die();
            } else {
                if ($tipo_reporte == 'pdf') {
                    $data['titulo'] = 'traslados, promociones y niveles';
                    $header = $this->load->view('reporte/header', $data, true);
                    $GLOBALS['nombre_reporte'] = 'reporte_promociones_niveles' . date('dmY');
                    $reporte = $header . $html;
                    $this->pdf->makePdf($reporte, 'L', 'reporte_promociones_niveles', 'Letter');
                } elseif ($tipo_reporte == 'excel') {
                    $filename = 'rpt_promociones_niveles' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
                    $data['filename'] = $filename;
                    echo $html;
                }
            }
            
        } else{
							  $this->db->join('mxr_empresaxarea', 'mxr_id_are = are_id');
							  $this->db->where('mxr_id_emr',$this->tank_auth->get_empresa_id());
			$data['areas'] = $this->gsatelite->get_tabla('are_area',array('are_estado' => 1, 'are_padre' => null, 'are_id_emr'=>$this->tank_auth->get_empresa_id()));
			$data['titulo_personal']    = "Reporte de traslados, promociones y niveles";
			$this->_cargarvista($data);
		}
	}

	function _cargarvista($data=0,$crud=0){	
		$this->load->view('vacia',$crud);	
		if($data!=0)
			$data=array_merge($data,$this->masterpage->getUsuario());
		else
			$data=$this->masterpage->getUsuario();
		$vista=$data['modulo'].'/'.$data['control'].'/'.$data['funcion'];
		$this->masterpage->setMasterPage('masterpage_default');
		$this->masterpage->addContentPage($vista, 'content',$data);
		$this->masterpage->show();
	}	

	/**
	* @author René Castaneda
	* @since 2018-04-10
	* @return filtrar las sucursales dependiendo la empresa
	 */
	public function filtrar_sucursales_option()
	{
	    $where['suc_id_emr'] = ($this->input->post('slcEmpresa') > 0 )? $this->input->post('slcEmpresa'): $this->tank_auth->get_empresa_id();
	    
	    if ($this->input->post('slcEmpresa') == -1)    	$where = null;
	    
        $data['options'] = $this->gsatelite->get_dropdown('suc_sucursal', '{suc_nombre}','', $where, null, '', 'suc_id', true);
	    $data['options'] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $data['options']);
	    die(json_encode($data));
	}	

	/**
	* @author René Castaneda
	* @since 2018-04-10
	* @return filtrar las areas dependiendo la empresa
	 */
	public function filtrar_areas_option()
	{
	    $id_empresa = ($this->input->post('slcEmpresa') > 0 )? $this->input->post('slcEmpresa'): $this->tank_auth->get_empresa_id();
	    $where["are_id IN (SELECT mxr_id_are FROM mxr_empresaxarea WHERE mxr_id_emr = $id_empresa )"] = null;

	    if ($this->input->post('slcEmpresa') == -1)    	$where = null;
	    
        $data['options'] = $this->gsatelite->get_dropdown('are_area', '{are_nombre}','', $where, null, '', 'are_id', true);
	    $data['options'] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $data['options']);
	    die(json_encode($data));
	}	

		/**
		* @author René Castaneda
		* @since 2018-04-10
		* @return filtrar las puestos dependiendo la empresa
		 */
		public function filtrar_puesto_option()
		{
		    $id_empresa = ($this->input->post('slcEmpresa') > 0 )? $this->input->post('slcEmpresa'): $this->tank_auth->get_empresa_id();
		    $where["pto_id IN (SELECT mxp_id_pto FROM mxp_empresaxpuesto WHERE mxp_id_emr = $id_empresa )"] = null;

		    if ($this->input->post('slcEmpresa') == -1)    	$where = null;
		    
	        $data['options'] = $this->gsatelite->get_dropdown('pto_puesto', '{pto_nombre}','', $where, null, '', 'pto_id', true);
		    $data['options'] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $data['options']);
		    die(json_encode($data));
        }
        
        
        /**
     * Descripción:
     * Reporte de Beneficios por puesto
     * @author Rafael A. Cuchilla - Grupo Satélite
     * @since 2018-07-06
     * @param Ninguno
     */
    public function beneficios_puesto() {
        satelite_validar();
        $select_beneficio = $this->gsatelite->get_dropdown('bfp_beneficio_puesto', '{bfp_nombre}', '', array('bfp_estado' => 1), null, '', 'bfp_id', true);
        $data["beneficio"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select_beneficio);
        $data["empleado"] = $this->gsatelite->get_tabla('emp_empleado',array('emp_estado' => 1));
        $data['titulo_personal'] = "Reporte de Beneficios por Puesto";
        $this->_cargarvista($data); 
    }    

    public function imprimir_beneficios_puesto($flag = null){
        if($flag == 1) {
            $tipo = $this->input->post("tipo");
            $empleado   = $this->input->post("empleado");
            $beneficio   = $this->input->post("beneficio");
        } else {
            $tipo = $this->input->post("tipo");
            $empleado    = $this->input->post("filtro_empleado");
            $beneficio    = $this->input->post("filtro_beneficio");
        }
        $where = array('emp_estado' => 1, 'plz_estado' => 1, 'bfp_estado' => 1);
        $where['emr_id'] = $this->tank_auth->get_empresa_id();
        if($empleado > 0) {
            $where['emp_id'] = $empleado;
        }
        if($beneficio != "") {
            $where["bfp_id IN($beneficio)"] = null;
        }
        $data['beneficios'] = $this->expediente_personal_model->get_beneficios_puesto($where);
        $data['tipo'] = $tipo;
        if($flag==1) {
        	$html = $this->load->view('expediente_personal/reportes/beneficios_print', $data, true);
            echo json_encode(array('html'=>$html, 'filas'=>count($data['beneficios'])));
        } else {
            if($tipo==1){ // para formato en PDF
                $html = $this->load->view('reporte/header', array('titulo' => 'Beneficios por puesto'), true);
                $html .= $this->load->view('expediente_personal/reportes/beneficios_print', $data,true);
                // $this->pdf->reportePDF2($html);
                $this->pdf->makePDF($html,'L','Beneficios');
            }else if($tipo == 2){ // Para formato en Excel
                 //Nombre del archivo 
                $filename = 'rpt_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);
                $data['table_header'] = "Reporte de Beneficios por puesto";
                $data['filename']=$filename;
                $this->load->view('expediente_personal/reportes/beneficios_print_excel', $data);
            }
        } 
    }


    /**
	 * reportes.php
	 * Descripción:
	 * Funcion que recibe el id de un empleado y el tipo de reporte a generar para mostrar los datos academicos
	 * @author      Israel Alfaro  -  Grupo Satelite
	 * @version     2018-08-07
	 * @since       Archivo disponible desde 2018-08-03
	 **/
    public function reporte_datos_academicos_empleado() {
		if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
        	if ($_POST) {
        		$id_empleado = $this->input->post("select_id");
        		$tipo_reporte = $this->input->post("tipo_reporte");
        		//obtener el nombre completo del empleado
        		$nombre_empleado = $this->gsatelite->get_tabla('emp_empleado', array('emp_id' => $id_empleado));
        		$nombre_empleado = $nombre_empleado[0]["emp_nombre"] . " " .$nombre_empleado[0]["emp_apellido"];

        		//$data =$this->gsatelite->get_tabla('dac_dato_academico', array('dac_id_emp' => $id_empleado));
        		$data =$this->gsatelite->get_tabla('dac_dato_academico', array('dac_id_emp' => $id_empleado));
	        	//obtener el tipo educacion del empleado
	        	$label_tipo_educacion = $this->gsatelite->get_tabla('tie_tipo_educacion', array('tie_id' => $data[0]['dac_id_tie']));
	        	$label_tipo_educacion = $label_tipo_educacion[0]['tie_nombre'] != "" ? $label_tipo_educacion[0]['tie_nombre'] : "-";      		
	        	//obtener la profesion del empleado
	        	$label_profesion = $this->gsatelite->get_tabla('pro_profesion', array('pro_id' => $data[0]['dac_id_pro']));
	        	$label_profesion = $label_profesion[0]['pro_nombre'] != "" ? $label_profesion[0]['pro_nombre'] : "-";
	        	//obtener intitucion academica del empleado
	        	$label_institucion = $this->gsatelite->get_tabla('ina_institucion_academica', array('ina_id' => $data[0]['dac_id_ina']));
	        	$label_institucion = $label_institucion[0]['ina_nombre'] != "" ? $label_institucion[0]['ina_nombre'] : "-";
	        	//obtener estado del empleado
	        	$label_estado = $this->gsatelite->get_tabla('ese_estado_estudio', array('ese_id' => $data[0]['dac_id_ese']));
	        	$label_estado = $label_estado[0]['ese_nombre'] != "" ? $label_estado[0]['ese_nombre'] : "-";
	        	//obtener anos cursados del empleado
	        	$label_anios_cursados = $data[0]['dac_anios_cursado'] != "" ? $data[0]['dac_anios_cursado'] : "-";
	        	//obtener fecha finalizacion del empleado
	        	$label_fecha_fina = $data[0]['dac_fecha_finalizacion'];
	        	//Para obtener la fecha y no fecha-hora
	        	$label_fecha_fina = $data[0]['dac_fecha_finalizacion'][0] != "" ? explode(" ", $data[0]['dac_fecha_finalizacion'])[0] : "-";
	        	//obtener las observaciones del empleado
	        	$observacion = $this->gsatelite->get_tabla('dac_dato_academico', array('dac_id_emp' => $id_empleado));
	        	$label_observacion = $observacion[0]['dac_observacion'] != "" ? $observacion[0]['dac_observacion'] : "-";
	        	//Obtener el pais del empleado
	        	$label_pais = $this->gsatelite->get_tabla('pai_pais', array('pai_id' => $data[0]['dac_id_pai']));
	        	$label_pais = $label_pais[0]['pai_nombre'] != "" ? $label_pais[0]['pai_nombre'] : "-";
	        	//onbtener la experiencia del empleado
	        	$label_experiencia = $this->gsatelite->get_tabla('exl_experiencia_laboral', array('exl_id' => $data[0]['dac_id_exl']));
	        	$label_experiencia = $label_experiencia[0]['exl_nombre'] != "" ? $label_experiencia[0]['exl_nombre'] : '-';
				$data_to_view = array(
					'tipo_educacion' => $label_tipo_educacion,
					'profesion' => $label_profesion,
					'institucion' => $label_institucion,
					'estado' => $label_estado,
					'anios_cursados' => $label_anios_cursados,
					'fechal_final' => $label_fecha_fina,
					'observacion' => $label_observacion,
					'pais' => $label_pais,
					'experiencia' => $label_experiencia 
				);
				if ($tipo_reporte =='pdf'){
					$data['tr'] =  "si";
					$data['titulo'] = 'Reporte datos academicos por empleado';
					$formato = 'Legal';
					$data['data_tabla'] = $data_to_view;
					$html=$this->load->view('reporte/header', array('titulo' => 'Datos academicos de '.$nombre_empleado), true);
					$html.=$this->load->view('expediente_personal/reportes/detalle_academicos_empleado',$data,true);
					$this->pdf->setPrintFooter(true);
					$this->pdf->makePDF($html,'L','datos academicos',$formato);
				}  
				if($tipo_reporte == "excel") {
					$data['tr'] =  "si";
					$data['filtro']= 'Letter';
			     	$data["data_tabla"] = $data_to_view;
			     	$cantidad=count($data_to_view);
			     	$data['excel'] = true;
			     	$html=$this->load->view('reporte/header_excel', array('titulo' => 'Datos academicos de '.$nombre_empleado), true);
			     	$data['html'] = $html;
			     	$this->load->view('expediente_personal/reportes/detalle_academicos_empleado',$data);
				}
        	}
        }
	}

	/**
	 * reportes.php
	 * Descripción:
	 * Funcion donde se carga la vista de los datos academicos y tambien donde se manda la data a detalle_datos_academicos
	 * @author      Israel Alfaro  -  Grupo Satelite
	 * @version     2018-08-03
	 * @since       Archivo disponible desde 2018-08-03
	 **/
	public function datos_academicos_empleado() {
		if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
        	if($_POST) {
        		$id_empleado = $this->input->post("id");
        		$tipo_reporte = $this->input->post("tipo_reporte");
	        	//Consulta que cargara todos los datos
	        	
	        	//$data =$this->gsatelite->get_tabla('dac_dato_academico', array('dac_id_emp' => $id_empleado));
        		$data =$this->gsatelite->get_tabla('dac_dato_academico', array('dac_id_emp' => $id_empleado));
	        	//obtener el tipo educacion del empleado
	        	$label_tipo_educacion = $this->gsatelite->get_tabla('tie_tipo_educacion', array('tie_id' => $data[0]['dac_id_tie']));
	        	$label_tipo_educacion = $label_tipo_educacion[0]['tie_nombre'] != "" ? $label_tipo_educacion[0]['tie_nombre'] : "-";      		
	        	//obtener la profesion del empleado
	        	$label_profesion = $this->gsatelite->get_tabla('pro_profesion', array('pro_id' => $data[0]['dac_id_pro']));
	        	$label_profesion = $label_profesion[0]['pro_nombre'] != "" ? $label_profesion[0]['pro_nombre'] : "-";
	        	//obtener intitucion academica del empleado
	        	$label_institucion = $this->gsatelite->get_tabla('ina_institucion_academica', array('ina_id' => $data[0]['dac_id_ina']));
	        	$label_institucion = $label_institucion[0]['ina_nombre'] != "" ? $label_institucion[0]['ina_nombre'] : "-";
	        	//obtener estado del empleado
	        	$label_estado = $this->gsatelite->get_tabla('ese_estado_estudio', array('ese_id' => $data[0]['dac_id_ese']));
	        	$label_estado = $label_estado[0]['ese_nombre'] != "" ? $label_estado[0]['ese_nombre'] : "-";
	        	//obtener anos cursados del empleado
	        	$label_anios_cursados = $data[0]['dac_anios_cursado'] != "" ? $data[0]['dac_anios_cursado'] : "-";
	        	//obtener fecha finalizacion del empleado
	        	$label_fecha_fina = $data[0]['dac_fecha_finalizacion'];
	        	//Para obtener la fecha y no fecha-hora
	        	$label_fecha_fina = $data[0]['dac_fecha_finalizacion'][0] != "" ? explode(" ", $data[0]['dac_fecha_finalizacion'])[0] : "-";
	        	//obtener las observaciones del empleado
	        	$observacion = $this->gsatelite->get_tabla('dac_dato_academico', array('dac_id_emp' => $id_empleado));
	        	$label_observacion = $observacion[0]['dac_observacion'] != "" ? $observacion[0]['dac_observacion'] : "-";
	        	//Obtener el pais del empleado
	        	$label_pais = $this->gsatelite->get_tabla('pai_pais', array('pai_id' => $data[0]['dac_id_pai']));
	        	$label_pais = $label_pais[0]['pai_nombre'] != "" ? $label_pais[0]['pai_nombre'] : "-";
	        	//onbtener la experiencia del empleado
	        	$label_experiencia = $this->gsatelite->get_tabla('exl_experiencia_laboral', array('exl_id' => $data[0]['dac_id_exl']));
	        	$label_experiencia = $label_experiencia[0]['exl_nombre'] != "" ? $label_experiencia[0]['exl_nombre'] : '-';
				$data_to_view = array(
					'tipo_educacion' => $label_tipo_educacion,
					'profesion' => $label_profesion,
					'institucion' => $label_institucion,
					'estado' => $label_estado,
					'anios_cursados' => $label_anios_cursados,
					'fechal_final' => $label_fecha_fina,
					'observacion' => $label_observacion,
					'pais' => $label_pais,
					'experiencia' => $label_experiencia 
				);
				$data['titulo']             = 'Reporte de estado de cuenta corriente cliente';
				$data['data_tabla'] = [$data_to_view];
				$html = $this->load->view('expediente_personal/reportes/detalle_academicos_empleado', $data, true);
				$data['html'] = $html;
		        echo json_encode($data);
        	} else {
        		$data['titulo_personal']="Datos academicos de empleado";
				$data['titulo_div'] = "Datos academicos por empleados";
				$this->_cargarvista($data);
        	}
        }
	}
	/**
	 * Descripción:
	 * Reporte para imprimir finiquito de empleados, aplica solo para empleados activos
	 * @author      Manuel Anzora  -  Grupo Satelite
	 * @version     2018-12-17
	 **/
	public function reporte_finiquito_empleado(){
		satelite_validar();
		$data['sucursales'] = $this->gsatelite->get_dropdown('suc_sucursal', '{suc_codigo} - {suc_nombre}','', null, null, '', 'suc_id', true);
		$data['titulo_personal'] = "Finiquito de empleado";
		$this->_cargarvista($data); 
	}

	public function generar_finiquito_all(){
		$html = "";
        if($_POST){
        	// var_dump($_POST);die();
        	$empresa = strtolower(trim($this->gsatelite->get_parametro('SYS_SIGLAS')));
        	$sucursal = $this->input->post('sucursal');
        	$empleado = $this->input->post('empleado');
            $data=[];
            if($empleado != '' && $empresa != 'fya'){
            	//CUANDO SELECCIONA UN EMPLEADO UTILIZA MEDOTO DESARROLLADO EN EXPEDIENTE DE PERSONAL
            	$this->load->library('../controllers/expediente_personal/empleado');
        		$this->empleado->finiquito_empleado($empleado);	
        	}else{
        		$where = array();
            	//CUANDO SE DEBE IMPRIMIR EN MASA EL FINIQUITO
        		$estado = $this->input->post('slc_estado');
        		$data['siglas'] = $empresa;
        		if (is_numeric($estado)) {
            		$where['emp_estado'] = $estado;
            	}
            	if (is_numeric($sucursal)) {
            		$where['emp_id_suc'] = $sucursal;
            	}
            	if ($empresa == 'fya' && $empleado != '') {
            		$where['emp_id'] = $empleado;
            	}
            	$group = 'emp_id';
            	//datos de todos los empleados de la sucursal
            	$empleados = $this->expediente_personal_model->get_empleado_activo($where, $group);
            	//informacion del representante legal
            	$representante = $this->gsatelite->get_parametro_emp('ID_REPRESENTANTE_LEGAL');
	            $band = 0;
	            if($representante!=''){
	                $condition = ['emp_id'=>$representante];
	                $data_rep = $this->expediente_personal_model->get_empleado_retirado($condition,null);
	            }else{
	                $band=1;
	            }
	            $repre_legal=[];
	            foreach ($data_rep as $value) {
	                $repre_legal=[
	                    'nombre'=>$value['fullname'],
	                    'direccion'=>$value['emp_direccion']
	                ];
	            }
	            $data['representante_legal']=$repre_legal;
	            $notario['nombre'] = $this->gsatelite->get_parametro_emp('SYS_NOMBRE_NOTARIO');
	            $notario['domicilio'] = $this->gsatelite->get_parametro_emp('SYS_DOMICILIO_NOTARIO');
	            $info=[];
	            $year = $this->enletras->num2letras(date('Y'));
	            $dia = $this->enletras->num2letras(date('j'));
	            $hora = $this->enletras->num2letras(date('H'));
	            $minutos = $this->enletras->num2letras(date('i',strtotime(date('H:i:s'))));
	            //UBICACION DE LA EMPRESA
	            // $info_emp = $this->tank_auth->get_all_empresa();
	            $empresa = $this->gsatelite->get_registro('emr_empresa', array('emr_id' => $this->tank_auth->get_empresa_id()));
	            $data['municipio'] = $this->gsatelite->get_registro('mun_municipio', 'mun_id', $empresa->emr_id_mun);
	            $data['pais'] = $this->gsatelite->get_registro('pai_pais', 'pai_id', $empresa->emr_id_pai);
				$empleado_data = array();
	            foreach ($empleados as $value) {
	            	$age = '';
	            	$f_nac = $value['emp_fecha_nac'];
	            	if ($f_nac != '') {
	            		$fec_n = explode('-', $f_nac);
	            		$anio = date('Y');
	            		$mes = date('m');
	            		$day = date('d');
	            		if ($fec_n[1] == $mes && $fec_n[2] > $day) {
	            			$anio = $anio - 1;
	            		}
	            		if ($fec_n[1] > $mes) {
	            			$anio = $anio - 1;
	            		}
	            		$age = $anio - $fec_n[0];
	            	}
	            	$edad = ($age != '') ? $this->enletras->num2letras($age) : '';
	            	$info=[
	            		'empleado'     => $value['fullname'],
	            		'edad'         => $edad,
	            		'profesion'    => $value['pro_nombre'],
	            		'puesto'       => $value['pto_nombre'],
	            		'contratacion' => formatear_fecha('d-n-Y', $value['emp_fecha_contrato']),
	            		'direccion'    => $value['emp_direccion'],
	            		'documento'    => $value['dce_valor'],
	            		'pais'         => $value['pai_nombre'],
	            		'departamento' => $value['dep_nombre'],
	            		'municipio'    => $value['mun_nombre']
	            	];
	            	array_push($empleado_data, $info);
	            }

	            $data['empleados'] = $empleado_data;
	            $data['notario'] = $notario;
	            $data['year'] = strtolower($year);
	            $data['dia'] = strtolower($dia);
	            $data['hora'] = strtolower($hora);
	            $data['minutos'] = strtolower($minutos);
	            $html .= $this->load->view('expediente_personal/reportes/finiquito_empleado_masa', $data, true);
	            header('Content-type: application/vnd.ms-word');
		        header('Content-Disposition: attachment;Filename=finiquito_empleado.doc');
		        header("Pragma: no-cache");
		        header("Expires: 0");
		        echo '<html>';
		        echo '<meta http-equiv=\'Content-Type\' content=\'text/html; charset=Windows-1252\'>';
		        echo '<body style="font-family:Arial;" >';
		        echo '<meta charset="utf-8" />';
		        echo '<style type="text/css"> .inicio_contrato {  font-weight: bold;  }  .parrafo {    text-align: justify;  }</style>';
		        echo $html;
		        echo '</body></html>';
            }
            
        }
	}
	/**
	 * Descripción:
	 * Obtiene empleados mediante la data recibida, el metodo se utiliza en select ajax.
	 * @author      Manuel Anzora  -  Grupo Satelite
	 * @version     2018-12-17
	 **/
	public function get_empleado_active(){
		$like = $this->input->post('empleado');
		$sucursal = $this->input->post('sucursal');
		$estados = $this->input->post('estados');
		$where = null;
		if (is_numeric($sucursal)) {
			$where['emp_id_suc'] = $sucursal;
		}
		if (is_numeric($estados)) {
			$where['emp_estado'] = $estados;
		}
		$datos = $this->expediente_personal_model->get_empleado_like($where, $like);
		echo json_encode($datos);
	}

	/**
	 * Descripción:
	 * Reporte de Genero por Area, retorna vista con los controles para el filtrado
	 * @author      Nelson Soriano
	 * @version     14-05-2019
	**/

	public function reporte_genero(){
		satelite_validar();
		$data['areas']           = str_replace('<option value="0">Seleccione</option>', '',$this->gsatelite->get_dropdown('are_area','are_nombre','',array('are_estado' =>1),null,null,'are_id',true));
		$data['permisos'] 		 = $this->gsatelite->get_permisos_opcion();
		$data['genero']          = $this->gsatelite->get_tabla('gen_genero',array('gen_estado' => 1));
		$data['titulo_personal'] = "Reporte de Género por área";
		$this->_cargarvista($data);
	}

	public function generar_reporte_genero($es_reporte = null){
		satelite_validar();
		$area  = $this->input->post('area');
		$detalles = $keys = $where = array();
		$filtro_titulo = '';
		if ($area !== '') {
			$where['emp_id_are'] = $area;
			$filtro_titulo = '<p>Área: '.$this->gsatelite->get_campo('are_area','are_nombre',array('are_id' => $area)).'</p>';
		}
		$informacion = $this->expediente_personal_model->detalles_reporte_genero($where,array('gen_id','are_id'));
		foreach ($informacion as $key => $value) {
			if (array_key_exists($value['are_id'], $detalles)) {
				if (!(array_key_exists($value['gen_id'], $detalles[$value['are_id']]['valor']))) {
					$detalles[$value['are_id']]['valor'][$value['gen_id']]['llave'] = $value['llave'];
					$detalles[$value['are_id']]['valor'][$value['gen_id']]['ctdad'] = $value['total'];
				}				
			} else {
				$detalles[$value['are_id']]['valor'][$value['gen_id']]['llave'] = $value['llave'];
				$detalles[$value['are_id']]['valor'][$value['gen_id']]['ctdad'] = $value['total'];
				$detalles[$value['are_id']]['area'] = $value['area'];
			}
			if (!(array_key_exists($value['gen_id'], $keys))) {
				$keys[$value['gen_id']] = $value['nombre'];
			}			
		}
		$data['llaves_key'] = $keys;
		$data['detalles'] = $detalles;
		$html  = $this->load->view('expediente_personal/reportes/generar_reporte_genero', $data, true);
		$tipo  = $this->input->post('tipo_reporte');
		if ($es_reporte  == 1) {
			switch ($tipo) {
				// Tipo reporte 1:excel 2:pdf
				case 'excel':
					header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
	                header("Content-Disposition: attachment;filename=Generos por Area".date('d-m-Y_His').".xls");
	                header("Pragma: no-cache");
	                header("Expires: 0");
	                echo '<meta charset="utf-8" />';
	                echo "<table border='0'>
	                  <tr><th colspan='6' align='center' >".mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'),'UTF-8')."</th></tr>
	                  <tr><th colspan='6' align='center' >Generos por Area</th></tr>
	                  <tr><th colspan='6' align='center' >".$filtro_titulo. "</th></tr>
	                  </table>";
	                echo $html; die();
				break;
				
				case 'pdf':
					$html_header=$this->load->view('reporte/header', array('titulo' => "Reporte Géneros por Área <br /> $filtro_titulo", 'solotitulo'=> true), true);
	                $html = str_replace('border="1" style="margin-left: 4px; width: 99%; font-size:12px;"','border="0.5" style="width: 100%; font-size:9px;"',$html);
	                $this->pdf->makePDF($html_header.str_replace('font-size: 14px;','font-size: 10px;',$html),'P');
				break;
			}
		}
		echo $html;
	}

	/**
	* @author Herberth Lucho
	* @since  10-09-2019
	* @return Genera vista html para procesar reporte
	*/
	public function detalle_contratacion(){
		satelite_validar();
		$data['persmisos'] = $this->gsatelite->get_permisos_opcion();
		$data['titulo_personal'] = "Reporte detalle de contratación";
		$empleado = $this->gsatelite->get_dropdown('emp_empleado', '{emp_codigo} - {emp_nombre} {emp_apellido}', '', array('emp_estado' => 1), null, '', 'emp_id', true);
		$data['empleado'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $empleado);
		cargarvista($data);
	}
	
	/**
      * @author Herberth Lucho
      * @since  10-09-2019
      * @return Genera pdf o excel del reporte
      * @param  fecha de inicio, fecha fin, empleado
      */
	 public function get_valor_filtro($tabla,$where,$campo,$personeria = null,$extra){
	 	$valor = $this->gsatelite->get_tabla($tabla,$where);
	 	if ($personeria != null) {
	 		if ($valor[$personeria] == 2) {
	 			return $valor[0][$campo].' '.$valor[0][$extra];
	 		}else{
	 			return $valor[0][$campo];
	 		}
	 	}
	 	return $valor[0][$campo];
    }

	/**
      * @author Raul E.
      * @since  jun-2021
      * @return Genera word con constancia personalizada
      */
    public function constancia_personalizada() {
    	satelite_validar();
    	if ($_POST) {
    		$empleado = $this->input->post('empleado');
    		$tipo_constancia =  $this->input->post('constancia');
    		$dirigido_para = $this->input->post('persona_dirigido');
    		$anio_rentas =  ($this->input->post('year') != "") ? $this->input->post('year') : null;
    		$data['constancia'] = $this->datos_imprimir_constancia($empleado, null, $anio_rentas);
    		$data['tabla'] = $this->expediente_personal_model->get_datos_tipo_constancia($tipo_constancia);
    		$data['dirigido_a'] = $dirigido_para;
    		$this->load->view('expediente_personal/reportes/cuerpo_constancia_personalizada', $data, false);
    	} else {
    		$slct_emp = $slct_year = "";
    		$empleados = $this->gsatelite->get_tabla('emp_empleado');
    		$year_hasta = date('Y');
    		$year_desde = ($year_hasta - 6);
    		for ($i = $year_hasta; $i >  $year_desde; $i--) {
    			$slct_year .= '<option value="' . $i . '">' . $i . '</option>';
    		}
    		foreach ($empleados as $k => $val) {
    			$slct_emp .= '<option value="' . $val['emp_id'] . '" data-estado="' . $val['emp_estado'] . '">' . $val['emp_codigo'];
    			$slct_emp .= ($val['emp_codigo'] != "") ? " - " : "";
    			$slct_emp .= $val['emp_nombre'] . " " . $val['emp_apellido'];
    			$slct_emp .= ($val['emp_estado'] > 0) ? "" : " (Empleada/o Inactivo)";
    			$slct_emp .= '</option>';
    		}
    					$this->db->where('txr_id_emr', $this->tank_auth->get_empresa_id());
                        $this->db->join('txr_tipo_constanciaxempresa', 'txr_id_tpo = tpo_id');
            $tipo_con = $this->gsatelite->get_dropdown('tpo_tipo_constancia','tpo_nombre','', array('tpo_estado' => 1, 'txr_estado' => 1), null, '', 'tpo_id', true);
            $data['anios'] = $slct_year;
            $data['empleados'] = $slct_emp;
            $data['constancias'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $tipo_con);
            $data['titulo_personal'] = "Constancias Personalizadas";
            cargarvista($data);
        }
    }

	/**
      * @author Raul E.
      * @since  jun-2021
      * @return Copia de la funcion de imprimir constancia pero retornando datos
      */
    public function datos_imprimir_constancia($empleado_id, $tipo_pla = null, $tipo_sal = null, $year = null, $lugar_presenta = null, $tipo_descuento = null){
    	satelite_validar();
    	$this->load->library('EnLetras');
		$empleado = $empleado_id;
		$tipo_planilla = ($tipo_pla) ? $tipo_pla : 0;
		$anio = ($year) ? $year : date('Y');
		$lugar = ($lugar_presenta) ? $lugar_presenta : null; //Lugar donde se presenta ("... y para ser presentada en: ")
		$tipo_desc = ($tipo_descuento) ? $tipo_descuento : null;
		$tipo_salario = ($tipo_sal) ? $tipo_sal : 1;
		$fecha = date('Y-m-d');
		
		
		$codigo_ingreso01 = $this->planilla_model->codigo_ingreso01($empleado,$tipo_planilla);   
		$codigo_ingreso11 = $this->planilla_model->codigo_ingreso11($empleado,$tipo_planilla);
		$tipo_dui = $this->gsatelite->get_parametro('ID_TIPO_DOCUMENTO_DUI');
		$rep_legal = $this->gsatelite->get_parametro('ID_REPRESENTANTE_LEGAL');
		$cons_trabajo = $this->db->select("*, if(gen_nombre LIKE 'femenino', pro_prefijo_f, pro_prefijo_m) as titulo, 
							(SELECT mun_nombre FROM mun_municipio JOIN suc_sucursal ON suc_id_mun = mun_id JOIN emp_empleado ON suc_id = emp_id_suc WHERE emp_id = $rep_legal) AS mun_rh", FALSE )
							->from('emp_empleado')
							->where('emp_id',$empleado)
							->join('suc_sucursal', 'suc_id=emp_id_suc', 'left')
							->join('gen_genero', 'emp_id_gen=gen_id', 'left')
							->join('pro_profesion', 'pro_id=emp_id_pro', 'left')
							->join('mun_municipio', 'suc_id_mun=mun_id', 'left')
							->join('dep_departamento', 'mun_id_dep=dep_id', 'left')
							->join("dce_documento_emp", "dce_id_emp = emp_id AND dce_id_tde = $tipo_dui", "left")
							->join('plz_plaza','plz_id = emp_id_plz','left')
							->join('pto_puesto','pto_id = plz_id_pto','left')
							->join('afp_afp','afp_id=emp_id_afp','left')
							->get()->result_array();
		$ultimo_sueldo = $this->planilla_model->ultimo_sueldo($empleado, 1,$tipo_planilla);
		$ingresos = $this->planilla_model->get_ingresosxplanilla($empleado,$tipo_planilla);
		$sueldo_base=0;
		$sueldo_promedio=0;
		$actual_com = 0;
		$parametro_calculo_vacacion_meses = $this->gsatelite->get_parametro('NUM_PLANILLAS_CALCULO_VACACION');
		$par_com = $this->gsatelite->get_parametro('INGRESO_COMISIONES');
		//Promedio total
		$promedio = $this->planilla_model->get_promedio_ingreso_empleado($empleado,$parametro_calculo_vacacion_meses,1, $tipo_planilla);
		$sueldo_promedio = $promedio[0];
		$num_planilla = $promedio[1];
		//Promedio sin comisiones (EMI)
		$comision = ($par_com>0) ? $par_com : null;
		$prom_scom = $this->planilla_model->get_promedio_ingreso_empleado($empleado,$parametro_calculo_vacacion_meses,1, $tipo_planilla, $comision, $solo_com=false);
		$promedio_sin_com = $prom_scom[0];
		//Promedio de comisiones (EMI)
		$prom_com = $this->planilla_model->get_promedio_ingreso_empleado($empleado,$parametro_calculo_vacacion_meses,1, $tipo_planilla, $comision, $num_planilla);
		$promedio_com = $prom_com[0];
		$sueldo_base = $this->gsatelite->get_campo('emp_empleado', 'emp_salario', array('emp_id'=>$empleado));

						  $this->db->join('pla_planilla','pla_id = ddi_id_pla');
						  $this->db->limit(1);
						  $this->db->order_by('pla_fecha_fin','DESC');
		$ultimo_reg_pla = $this->gsatelite->get_tabla('ddi_detalle_ingreso', array('ddi_id_emp' => $empleado,'pla_estado'=>3));
		$fecha_mes_anio = ($ultimo_reg_pla)? formatear_fecha('Ym',$ultimo_reg_pla[0]['pla_fecha_inicio']):date('Ym');
		$comisiones_act = $this->planilla_model->get_ultimo_ingreso(array('ddi_id_tig'=>$par_com, 'DATE_FORMAT(pla_fecha_inicio, "%Y%m") ='=>$fecha_mes_anio, 'ddi_id_emp'=>$empleado));
		if(count($comisiones_act) > 0){
			$actual_com = $comisiones_act->mensual;
		}
		if ($tipo_salario == 3) {
			$desc_ley=$this->planilla_model->descuentos_ley_vivo($empleado,$sueldo_promedio,$tipo_planilla);
		} elseif ($tipo_salario == 1) {
			$desc_ley=$this->planilla_model->descuentos_ley_promediado($empleado,null,$tipo_planilla);
		} else { 
			$desc_ley=$this->planilla_model->descuentos_ley($empleado,null,$tipo_planilla);
		}
		//print_r($desc_ley);die();
		$documentos = $this->planilla_model->documentos_emp($empleado);
		$nup = $this->planilla_model->info_completa_empleado($empleado)[0]['emp_afp'];
		$id_planilla = $this->db->select('pla_id as planilla')
					 ->from('pla_planilla');
					 if ($tipo_planilla > 0 ) {
					     $this->db->where('pla_id_tpl', $tipo_planilla);
					 }
					 $this->db->where('pla_fecha_inicio <=',$fecha)
					 ->where('pla_fecha_fin >=',$fecha)
					 ->limit(1)
					 ->order_by('pla_fecha_fin', 'DESC')
					 ->get()->row();
		$pla_id=$id_planilla->planilla;
		/****************** DESCUENTOS PARA CONSTANCIA ANUAL ***********************/
		$renta10_des=0;
		$renta_des=0;
		$banco_des=0;
		$descuento_anual=$this->planilla_model->get_descuentos_anual($empleado,$tipo_planilla,$anio);
		$isss=$this->gsatelite->get_parametro('DESCUENTO_ISS');
		$renta=$this->gsatelite->get_parametro('DESCUENTO_ISR');
		$id_afp=$this->gsatelite->get_parametro('DESCUENTO_AFP');
		$renta10=$this->gsatelite->get_parametro('DESCUENTO_ISR10');
		$renta10=$this->gsatelite->get_parametro('DESCUENTO_ISR10');
		$otros_internos=$this->gsatelite->get_parametro('ID_DESCUENTO_INTERNO_RENTA');
		$otros_desc=explode(',', $otros_internos);
		foreach ($descuento_anual as $ds => $dss) {
			if($isss == $dss['tdc_id']){ 
				$isss_des = $dss['ddd_valor']; 
				$afecto_isss=$dss['afecto']; 
			} else if ($renta==$dss['tdc_id']){ 
				$renta_des = $dss['ddd_valor']; 
				$afecto_renta=$dss['afecto']; 
			} else if ($id_afp==$dss['tdc_id']){ 
				$afp_des=$dss['ddd_valor']; 
				$afecto_afp=$dss['afecto']; 
			} else if ($renta10 == $dss['tdc_id']){ 
				$renta10_des = $dss['ddd_valor']; 
				$afecto_renta10=$dss['afecto']; 
			} else if (in_array($dss['tdc_id'],$tipo_desc)){ 
				$otrosdescv[]=$dss['ddd_valor']; 
				$otrosdesca[]=$dss['afecto']; 
				$otrosdescn[]=$dss['tdc_nombre']; 
			} else if(in_array($dss['tdc_id'], $otros_desc)){ 
				$otros_dss=$dss['ddd_valor']; 
			}				
		}
		$porcen_renta=$this->gsatelite->get_campo('tdc_tipo_descuento', 'tdc_porcentaje', array('tdc_id'=>$renta10));
		/****************** INGRESOS PARA CONSTANCIA ANUAL ***********************/
		$ingreso_anual=$this->planilla_model->get_ingresos_anual($empleado,$tipo_planilla,$anio);			
		$vacacion=$this->gsatelite->get_parametro('ID_TIG_VACACION');
		$prima_vacacion=$this->gsatelite->get_parametro('ID_INGRESO_PRIMA_VACACION');
		$horas_extra= $this->gsatelite->get_parametro('ID_INGRESO_HORAS_EXTRAS'); //Parametro para horas extras 
		$hrs_extra=explode(',', $horas_extra);
		$salario_ing=$this->gsatelite->get_parametro('INGRESO_SALARIO');
		$bonificacion=$this->gsatelite->get_parametro('INGRESO_BONIFICACIONES');
		$aguinaldo=$this->gsatelite->get_parametro('ID_TIPO_INGRESO_AGUINALDO');
		$comision=$this->gsatelite->get_parametro('INGRESO_COMISIONES');
		$indemnizacion=$this->gsatelite->get_parametro('ID_TIPO_INGRESO_INDEMNIZACION');
		$aguinaldo_no_grav=0;
		$salario_otros=0;			
		foreach ($ingreso_anual as $in => $inn) {
			if($vacacion==$inn['tig_id']){ 
				$vacacion_inn=$inn['valor']; 
			} else if ($prima_vacacion==$inn['tig_id']){ 
				$prima_inn=$inn['valor']; 
			} else if(in_array($inn['tig_id'], $hrs_extra)){ 
				$extra_inn=$inn['valor']; 
			} else if($bonificacion==$inn['tig_id']){ 
				$bonif_inn=$inn['valor']; 
			} else if($aguinaldo==$inn['tig_id']){ 
				$aguinaldo_inn=$inn['valor']; 
			} else if($comision==$inn['tig_id']){ 
				$comision_inn=$inn['valor']; 
			} else if($indemnizacion==$inn['tig_id']){ 
				$indemnizacion_inn=$inn['valor']; 
			} else if($salario_ing==$inn['tig_id']){ 
				$solo_salario+=$inn['valor']; 
			} else { 
				$otros+=$inn['ddi_valor'];
			}
		}
		$salario_otros=$solo_salario+$otros; // salario y otros ingresos (plailla de renta original)
		$subtotal_gravadas=$vacacion_inn+$bonif_inn+$aguinaldo_inn+$comision_inn+$salario_otros+$prima_inn;
		$total_gravadas=$subtotal_gravadas-($afp_des+$isss_des);
		$total_no_grav=$aguinaldo_no_grav+$indemnizacion_inn;
		$empleado = $cons_trabajo[0]['emp_id'];
				   $this->db->limit(1);
				   $this->db->order_by('pps_id', 'DESC');
				   $this->db->join('plz_plaza', 'pps_id_plz = plz_id');
		$pps_reg = $this->gsatelite->get_tabla('pps_promocion_plaza_salarioxemp', array('pps_id_emp'=>$empleado));
		$plaza_pps = (count($pps_reg)>0)? $pps_reg[0]['plz_nombre']: '';
		$data = array(
			'cons_trabajo'  => $cons_trabajo,
			'ultimo_sueldo' => $ultimo_sueldo,
			'sueldo_base'	=> $sueldo_base,
			'descuentos'	=> $desc_ley,
			'tipo_cons' 	=> $tipo,
			'documentos'	=> $documentos,					
			'nup'			=> $nup,					
			'codigo01' 		=> $codigo_ingreso01,
			'dirigidoa' 	=> $dirigido,
			'codigo11' 		=> $codigo_ingreso11,
			'fechas' 		=> $fechas,
			'sueldoProm'	=> $sueldo_promedio, // Promedio de sueldo total (6 meses según parámetro) 
			'anio'			=> $anio,
			'vacacion_inn'	=> $vacacion_inn,
			'bonif_inn'		=> $bonif_inn,
			'aguinaldo_inn' => $aguinaldo_inn,
			'comision_inn'  => $comision_inn,
			'salario_otros' => $salario_otros, // Consolidado de salario y otros ingresos de hace 6 meses
			'subtotal_grav' => $subtotal_gravadas,
			'afp'			=> $afp_des,
			'total_gravadas'=> $total_gravadas,
			'indemnizacion' => $indemnizacion_inn,
			'isss_des'		=> $isss_des,
			'renta'			=> $renta_des,
			'renta10'		=> $renta10_des,
			'porcen_renta'  => $porcen_renta,
			'aguinaldo_no'  => $aguinaldo_no_grav,
			'total_no_grav' => $total_no_grav,
			'banco' 		=> $banco_des,
			'num_planilla'	=> $num_planilla,
			'lugar'			=> $lugar,		  // Lugar en el que se presentará la constancia de sueldo (TROQUELES)
			'prima_vacacion'=>$prima_inn, 	 // Prima de vacación - 30% (ESPUMAR)
			'extra_inn'		=>$extra_inn,	 // Ingresos de horas extra diurnas y nocturnas (ESPUMAR)
			'salario_inn' 	=>$solo_salario, // Solo salario para constancia anual (ESPUMAR)
			'otros_inn'		=>$otros, 		 // Otros ingresos anuales (ESPUMAR)
			'afecto_isss'   =>$afecto_isss,
			'afecto_afp'    =>$afecto_afp,		//-- INGRESO AFECTO POR CADA DESCUENTO.
			'afecto_renta10'=>$afecto_renta10,	
			'afecto_renta'  =>$afecto_renta,	
			'otros_dss'		=>$otros_dss, 	// descuentos internos para renta anual (ESPUMAR)
			'det_ingresos'	=>$ingresos,
			'promedio_com' =>$promedio_com, // Promedio únicamente de comisiones (EMI)
			'promedio_sin_com'=>$promedio_sin_com, // Promedio sin comisiones (EMI)
			'actual_com' => $actual_com,
			'otrosdescuentosv' => $otrosdescv,
			'otrosdescuentosn' => $otrosdescn,
			'plaza_pps' => $plaza_pps
		);

		$data['tipo_salario'] = $tipo_salario;
		$emr = $this->tank_auth->get_empresa_id();
		$correo = $this->db->select('emr_correo')->from('emr_empresa')->where('emr_id',$emr)->get()->row();		
		$data['correo'] = $correo->emr_correo;		
		
		$tipo_enc = $this->gsatelite->get_parametro('SYS_ENCABEZADO_CONSTANCIAS');
		if($tipo_enc==1){
			$data['header'] = $this->load->view('reporte/header_cons', array('titulo'=>"prueba1"), true);
			$data['pie_pag'] = 1; 
		}else{
			$data['header'] = $this->load->view('reporte/header_detalle_cons', array('titulo'=>"prueba2"), true);
			$data['pie_pag'] = 0; // Si el encabezado tiene detalle no se coloca pie de página
		}
		$suc =  $cons_trabajo[0]['emp_id_suc'];
		$sucursal_nombre  = $this->gsatelite->get_tabla('suc_sucursal',array('suc_id' => $suc));
		$data['sucursal_x'] = $sucursal_nombre[0]['suc_nombre'];
		return $data;
	}

    public function reporte_detalle_contratacion($es_reporte = null){
    	satelite_validar();
    	ini_set('memory_limit', '2048M');
    	ini_set('max_execution_time', '9999');
        $empleado = $this->input->post('empleado');
        $fechai = $this->input->post('fechai');
		$fechaf = $this->input->post('fechaf');
		$estado = (is_numeric($this->input->post('estado'))) ? $this->input->post('estado') : null;
		$filtros_titulo = '<br>';
		if ($fechai != '' && $fechaf != '') {
			$filtros_titulo.= '<br>Del: '.date_format(date_create($fechai),'d-m-Y'); 
			$filtros_titulo.= ' Al: '.date_format(date_create($fechaf),'d-m-Y').'<br>'; 
		}
		$where = null;
		if ($estado) {
			$where['emp_estado'] = ($estado - 1); 
		}
        if($empleado != '') {
        	$where['emp_id'] = $empleado; 
        	$data_emp = $this->gsatelite->get_registro('emp_empleado',array('emp_id' => $empleado));
        	$filtros_titulo.='Empleada/o: ' . $data_emp->emp_nombre . ' ' . $data_emp->emp_apellido;
        }
        if ($fechai != '') {
        	$where['DATE(emp_fecha_contrato) >= '] = formatear_fecha('Y-m-d', $fechai);
        }
        if ($fechaf != '') {
        	$where['DATE(emp_fecha_contrato) <= '] = formatear_fecha('Y-m-d', $fechaf);
        }        
        $consulta = $this->expediente_personal_model->get_reporte_detalle_contratacion($where);
        $data['info'] = $consulta;
        $tipo_reporte = $this->input->post('tipo_reporte');
        $data['reporte'] = $tipo_reporte;
        $html = $this->load->view('expediente_personal/reportes/reporte_detalle_contratacion.php', $data,true);
        if ($es_reporte != null) {
        	switch ($tipo_reporte) {
        		case 'pdf':
        			$header = $this->load->view('reporte/header', array('titulo' => 'Reporte detalle de contratación'.'<div style="font-weight:nornal;font-size:14px;text-align:left" id="x2">'.$filtros_titulo.'</div>','tipo_fuente' => 'pdfahelvetica'), true);
        			$htmlx   = $header.$html;
        			$this->pdf->makePDF($htmlx,'L');
                   	break;               
               case 'excel':
                    $data_header = array(
                        'titulo'       => 'Reporte detalle de contratación '.$filtros_titulo,
                        "solotitulo"   =>1,
                        "columnas"     => 6,
                        "tipo_fuente"  => 'arial'
                         );
                    $filename = 'rpt_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);
                    $heaader  = $this->load->view('reporte/header', $data_header, true);
                    $data['table_header'] = "Reporte detalle de contratación ";
                    $data['activos']=$activos;
                    $data['filename']=$filename;                    
                    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                    header("Content-Disposition: attachment;filename=reporte_detalle_contratacion".date('d-m-Y_His').".xls"); 
                    header("Pragma: no-cache");
                    header("Expires: 0");
                    echo '<meta charset="utf-8" />';
                    echo $heaader.$html;die();
                   	break;
           	}
        }
        echo json_encode(array('html' => $html));
    }

    public function get_empleado_area(){
    	$filtro = array();
        $where['emp_estado'] = 1;
    	$select = '<option value=""></option>';
        $emp_id_are = $this->input->post('area');
        $emps_slctd = $this->input->post('slct');
        $actuales = (trim($emps_slctd) != "") ?  explode(',', $emps_slctd) : array();
        $where["emp_id_are IN ($emp_id_are)"] = NULL;
    	$empleado = $this->expediente_personal_model->get_empleados_area_profesion($where);
    	if (count($empleado) > 0) {
    		foreach ($empleado as $key => $value) {
    			if (in_array($value['emp_id'], $actuales)) {
    				$selected = 'selected';
    				$filtro[] = $value['emp_id'];
    			} else {
    				$selected = '';
    			}
    			$select .= '<option ' . $selected . ' value="' . $value['emp_id'] . '">' . $value['emp_codigo'] . ' - ' . $value['emp_nombre'] . ' ' . $value['emp_apellido'] .  '</option>';
    		}
    	}
    	$filtrado = (count($filtro) > 0) ? implode(',', $filtro) : "";
    	echo json_encode(array('select' => $select, 'filtro' => $filtrado));
    }

	public function reporte_enfermedades_personal() {
		satelite_validar();
		if($_POST){
			$post_array = $this->input->post();
			$enfermedad 	= ($post_array['enfermedad'] != '' )? $post_array['enfermedad'] : null;
			$area 			= ($post_array['area'] != '') ? $post_array['area'] : null;
			$departamento 	= ($post_array['departamento'] != '') ? $post_array['departamento'] : null;
			$municipio 		= ($post_array['municipio'] != '') ? $post_array['municipio'] : null;
    		$where = array();
    		if (isset($enfermedad)) {
    			$where['enf_id'] = $enfermedad;
    		}
    		if (isset($area)) {
				$where['are_id'] = $area;
    		}
    		if (isset($municipio)) {
    			$where['mun_id'] = $municipio;
    		}
    		if (isset($departamento)) {
    			$where['mun_id_dep'] = $departamento;
    		}
    		$data['estadisticas_enfermedades'] = $this->expediente_personal_model->get_rpt_enfermedades_personal_estadistico($where);
    		$tipo_reporte               = $post_array['tipo_reporte'];
    		$data["tipo_reporte"]       = $tipo_reporte;
    		$html = $this->load->view('expediente_personal/reportes/consultar_reporte_enfermedades_personal', $data, true);
    		
    		echo json_encode(array('html' => $html));
    		
		} else {
			$enfermedades = $this->gsatelite->get_dropdown('enf_enfermedad', '{enf_nombre}', '', array('enf_estado'=>1), null, '', 'enf_id', true);
			$data['enfermedades'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $enfermedades);

			$departamentos = $this->gsatelite->get_dropdown('dep_departamento', '{dep_nombre}', '', array('dep_estado' => 1), null, '', 'dep_id', true);
			$data['departamentos'] = str_replace('<option value="0">Seleccione</option>', '', $departamentos);

			$data['titulo_personal'] = "Reporte de enfermedades por personal";
			cargarvista($data);
		}
	}

	function imprimir_reporte_enfermedades_personal(){
		satelite_validar();
		$post_array 	= $this->input->post();

		$enfermedad 	= ($post_array['slcEnfermedad'] != '' )? $post_array['slcEnfermedad'] : null;
    	$area 		= ($post_array['slcArea'] != '') ? $post_array['slcArea'] : null;
    	$departamento 		= ($post_array['slcDepartamento'] != '') ? $post_array['slcDepartamento'] : null;
    	$municipio 			= ($post_array['slcMunicipio'] != '') ? $post_array['slcMunicipio'] : null;
    	$tipo_reporte 	= $post_array['tipo_reporte'];
    	$where = array();
    	if (isset($enfermedad)) {
    		$where['enf_id'] = $enfermedad;
    	}
    	if (isset($area)) {
    		$where['emp_id_are'] = $area;
    	}
    	if (isset($departamento)) {
    		$where['mun_id_dep'] = $departamento;
    	}
    	if (isset($municipio)) {
    		$where['mun_id'] = $municipio;
    	}
    	$data['estadisticas_enfermedades'] = $this->expediente_personal_model->get_rpt_enfermedades_personal_estadistico($where);

    	$filename                   = 'reporte_enfermedadesxpersonal_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
    	$data['tipo_reporte'] 		= $tipo_reporte;
    	$data['filename']           = $filename;
    	
    	if($tipo_reporte == 'excel'){
    		$this->load->view('expediente_personal/reportes/consultar_reporte_enfermedades_personal', $data);
    	} else{
			$data['titulo']		= 'Estadístico de Enfermedades';
    		$header = $this->load->view('reporte/header', $data, true);
			$html = $this->load->view('expediente_personal/reportes/consultar_reporte_enfermedades_personal', $data, true);
    		$reporte = $header . $html;
    		$GLOBALS['nombre_reporte']  = $filename;
    		$this->pdf->makePdf($reporte, 'P', 'Reporte_enfermedadesxpersonal_', 'Letter');
    	}
    }

	public function reporte_profesiones_num_licencia() {
		satelite_validar();
		if($_POST){			
			$post_array = $this->input->post();
			$fecha_inicio = ($post_array['fecha_inicio'] != '' )? $post_array['fecha_inicio'] : null;
			$fecha_fin 	= ($post_array['fecha_fin'] != '') ? $post_array['fecha_fin'] : null;
			$profesion 	= ($post_array['profesion'] != '') ? $post_array['profesion'] : null;
			$fecha_inicio = formatear_fecha('Y-m-d', $fecha_inicio);
			$fecha_fin = formatear_fecha('Y-m-d', $fecha_fin);
    		$where = array('emp_licencia_profesional IS NOT NULL'=> NULL, 'emp_estado'=>1);
    		if ($fecha_inicio != "") {
    			$where['DATE(emp_fecha_contrato) >= '] = $fecha_inicio;
    		}
    		if ($fecha_fin != "") {
    			$where['DATE(emp_fecha_contrato) <= '] = $fecha_fin;
    		}
    		if (isset($profesion)) {
    			$where['pro_id'] = $profesion;
    		}
    		$data['profesiones_num_licencia'] = $this->expediente_personal_model->get_rpt_profesiones_num_licencia($where);
    		$tipo_reporte               = $post_array['tipo_reporte'];
    		$data["tipo_reporte"]       = $tipo_reporte;
    		$html = $this->load->view('expediente_personal/reportes/consultar_reporte_profesiones_num_licencia', $data, true);
    		
    		echo json_encode(array('html' => $html));
    	
		} else {
			$data['titulo_personal'] = "Reporte de profesiones por numero de licencia";
			cargarvista($data);
		}
	}

	function imprimir_reporte_profesiones_num_licencia(){
		satelite_validar();
		$post_array 	= $this->input->post();
		$fecha_inicio 	= ($post_array['txtFechaIni'] != '' )? $post_array['txtFechaIni'] : null;
    	$fecha_fin 		= ($post_array['txtFechaFin'] != '') ? $post_array['txtFechaFin'] : null;
    	$profesion 		= ($post_array['slcProfesion'] != '') ? $post_array['slcProfesion'] : null;
    	$tipo_reporte 	= $post_array['tipo_reporte'];
		
    	$fecha_inicio 	= formatear_fecha('Y-m-d', $fecha_inicio);
    	$fecha_fin  	= formatear_fecha('Y-m-d', $fecha_fin);
    	$where = array('emp_licencia_profesional IS NOT NULL'=>NULL, 'emp_estado'=>1);
    	if ($fecha_inicio != "") {
    		$where['DATE(emp_fecha_contrato) >= '] = $fecha_inicio;
		}
    	if ($fecha_fin != "") {
			$where['DATE(emp_fecha_contrato) <= '] = $fecha_fin;
    	}
    	if (isset($profesion)) {
			$where['pro_id'] = $profesion;
    	}

    	$data['profesiones_num_licencia'] = $this->expediente_personal_model->get_rpt_profesiones_num_licencia($where);
    	$filename                   = 'reporte_profesionesxnum_licencia_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
    	$periodo = ($fecha_inicio != "") ? "Desde: " . formatear_fecha('d-m-Y', $fecha_inicio) :"";
    	$periodo .= ($fecha_fin != "") ? " Hasta: " . formatear_fecha('d-m-Y', $fecha_fin) :"";
    	$data['periodo'] = $periodo;
    	$data['tipo_reporte'] 		= $tipo_reporte;
    	$data['filename']           = $filename;
    	// var_dump($data);die();
    	if($tipo_reporte == 'excel'){
    		$this->load->view('expediente_personal/reportes/consultar_reporte_profesiones_num_licencia', $data);
    	} else{
			$data['titulo']		= 'Números de Licencias Profesionales';
    		$data['subtitulo'] 	= $periodo;
    		$header = $this->load->view('reporte/header', $data, true);
			$html = $this->load->view('expediente_personal/reportes/consultar_reporte_profesiones_num_licencia', $data, true);
    		$reporte = $header . $html;
    		$GLOBALS['nombre_reporte']  = $filename;
    		$this->pdf->makePdf($reporte, 'P', 'Reporte_profesionesxnum_licencia_', 'Letter');
    	}
    }

	public function consultar_profesion () { 

		satelite_validar(true);
        $profesion = ($this->input->post('profesion') != '') ? $this->input->post('profesion') : null;
        $where  = null;
        $like   = null;             
        if ($profesion != '') {
            $like['pro_nombre'] = $profesion;
        }
        $where['pro_estado'] = 1;
        $arreglo = array();
        $profesiones = $this->expediente_personal_model->get_profesiones_like($where, $like);

        if (count($profesiones) > 0 ) {
            foreach ($profesiones as $key => $value) {
                $arreglo[$key]['profesion'] = $value['pro_id'];
                $arreglo[$key]['nombre_profesion'] = $value['pro_nombre'];
            }
        }
        echo json_encode($arreglo);
	}

	public function consultar_area () { 

		satelite_validar(true);
        $area = ($this->input->post('area') != '') ? $this->input->post('area') : null;
        $where  = null;
        $like   = null;             
        if ($area != '') {
            $like['are_nombre'] = $area;
        }
        $where['are_estado'] = 1;
        $arreglo = array();
        $areas = $this->expediente_personal_model->get_areas_like($where, $like);

        if (count($areas) > 0 ) {
            foreach ($areas as $key => $value) {
                $arreglo[$key]['area'] = $value['are_id'];
                $arreglo[$key]['nombre_area'] = $value['are_nombre'];
            }
        }
        echo json_encode($arreglo);
	}

	public function reporte_detallado_enfermedades_personal() {
		satelite_validar();
		if($_POST){			
			$post_array = $this->input->post();			
			$area 		= ($post_array['area'] != '') ? $post_array['area'] : null;
			$profesion 	= ($post_array['profesion'] != '') ? $post_array['profesion'] : null;
			$departamento 	= ($post_array['departamento'] != '') ? $post_array['departamento'] : null;
			$municipio 		= ($post_array['municipio'] != '') ? $post_array['municipio'] : null;
			$enfermedad 	= ($post_array['enfermedad'] != '' )? $post_array['enfermedad'] : null;
			$where = array('emp_estado' => 1, 'enf_estado' => 1);
			if (isset($area)) {
				$where['are_id'] = $area;
			}
			if (isset($profesion)) {
				$where['pro_id'] = $profesion;
			}
			if (isset($departamento)) {
				$where['mun_id_dep'] = $departamento;
			}
			if (isset($municipio)) {
				$where['mun_id'] = $municipio;
			}
			if (isset($enfermedad)) {
				$where['enf_id'] = $enfermedad;
			}
			$data['enfermedades_personal'] = $this->expediente_personal_model->get_enfermedades_empleados($where);
			$tipo_reporte               = $post_array['tipo_reporte'];
			$data["tipo_reporte"]       = $tipo_reporte;
			$html = $this->load->view('expediente_personal/reportes/consultar_reporte_detallado_enfermedades_personal', $data, true);    		
			echo json_encode(array('html' => $html));
		} else {
			$enfermedades = $this->gsatelite->get_dropdown('enf_enfermedad', '{enf_nombre}', '', array('enf_estado'=>1), null, '', 'enf_id', true);
			$data['enfermedades'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $enfermedades);
			$departamentos = $this->gsatelite->get_dropdown('dep_departamento', '{dep_nombre}', '', array('dep_estado' => 1), null, '', 'dep_id', true);
			$data['departamentos'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $departamentos);
			$data['titulo_personal'] = "Detalle de Enfermedades";
			cargarvista($data);
		}
	}

	function imprimir_reporte_detallado_enfermedades_personal(){
		satelite_validar();
		$post_array 	= $this->input->post();		
		$area 		= ($post_array['slcArea'] != '') ? $post_array['slcArea'] : null;
		$profesion 	= ($post_array['slcProfesion'] != '') ? $post_array['slcProfesion'] : null;
		$departamento 		= ($post_array['slcDepartamento'] != '') ? $post_array['slcDepartamento'] : null;
		$municipio 			= ($post_array['slcMunicipio'] != '') ? $post_array['slcMunicipio'] : null;
		$enfermedad 	= ($post_array['slcEnfermedad'] != '' )? $post_array['slcEnfermedad'] : null;
		$tipo_reporte 	= $post_array['tipo_reporte'];

    	$where = array('emp_estado' => 1);
			
		if (isset($area)) {
			$where['are_id'] = $area;
		}
		if (isset($profesion)) {
    		$where['pro_id'] = $profesion;
		}
		if (isset($departamento)) {
			$where['mun_id_dep'] = $departamento;
		}
		if (isset($municipio)) {
			$where['mun_id'] = $municipio;
		}
		if (isset($enfermedad)) {
			$where['enf_id'] = $enfermedad;
		}

    	$data['enfermedades_personal'] = $this->expediente_personal_model->get_enfermedades_empleados($where);
    	$filename                   = 'reporte_detallado_enfermedadesxpersonal_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
    	
    	$data['periodo'] = null;
    	$data['tipo_reporte'] 		= $tipo_reporte;
    	$data['filename']           = $filename;

    	if($tipo_reporte == 'excel'){
    		$this->load->view('expediente_personal/reportes/consultar_reporte_detallado_enfermedades_personal', $data);
    	} else{
			$data['titulo']		= 'Enfermedades por Personal';
    		$data['subtitulo'] 	= $periodo;
    		$header = $this->load->view('reporte/header', $data, true);
			$html = $this->load->view('expediente_personal/reportes/consultar_reporte_detallado_enfermedades_personal', $data, true);
    		$reporte = $header . $html;
    		$GLOBALS['nombre_reporte']  = $filename;
    		$this->pdf->makePdf($reporte, 'P', 'Reporte_detallado_enfermedadesxpersonal_', 'Letter');
    	}
    }

	public function reporte_detallado_medicamentos_personal () {
		satelite_validar();
		if($_POST){
			
			$post_array = $this->input->post();

			$area 		= ($post_array['area'] != '') ? $post_array['area'] : null;
			$profesion 	= ($post_array['profesion'] != '') ? $post_array['profesion'] : null;
			$departamento 		= ($post_array['departamento'] != '') ? $post_array['departamento'] : null;
			$municipio 			= ($post_array['municipio'] != '') ? $post_array['municipio'] : null;

    		$where = array('emp_estado'=>1);
    		
			if (isset($area)) {
				$where['are_id'] = $area;
			}
			if (isset($profesion)) {
				$where['pro_id'] = $profesion;
			}
			if (isset($departamento)) {
				$where['mun_id_dep'] = $departamento;
			}
			if (isset($municipio)) {
				$where['mun_id'] = $municipio;
			}

    		$data['medicamentos_personal'] = $this->expediente_personal_model->get_medicamentos_empleados($where);
    		$tipo_reporte               = $post_array['tipo_reporte'];
    		$data["tipo_reporte"]       = $tipo_reporte;
    		$html = $this->load->view('expediente_personal/reportes/consultar_reporte_detallado_medicamentos_personal', $data, true);
    		
    		echo json_encode(array('html' => $html));
    	
		} else {

			$enfermedades = $this->gsatelite->get_dropdown('enf_enfermedad', '{enf_nombre}', '', array(), null, '', 'enf_id', true);
            $data['enfermedades'] = str_replace('<option value="0">Seleccione</option>', '', $enfermedades);

			$departamentos = $this->gsatelite->get_dropdown('dep_departamento', '{dep_nombre}', '', array('dep_estado' => 1), null, '', 'dep_id', true);
			$data['departamentos'] = str_replace('<option value="0">Seleccione</option>', '', $departamentos);

			$data['titulo_personal'] = "Reporte detallado de medicamentos por personal";
			cargarvista($data);
		}
	}

	function imprimir_reporte_detallado_medicamentos_personal(){
		satelite_validar();
		$post_array 	= $this->input->post();
		
		$area 		= ($post_array['slcArea'] != '') ? $post_array['slcArea'] : null;
		$profesion 	= ($post_array['slcProfesion'] != '') ? $post_array['slcProfesion'] : null;
		$departamento 		= ($post_array['slcDepartamento'] != '') ? $post_array['slcDepartamento'] : null;
		$municipio 			= ($post_array['slcMunicipio'] != '') ? $post_array['slcMunicipio'] : null;
    	$tipo_reporte 	= $post_array['tipo_reporte'];
		
    	$where = array('emp_estado'=>1);
    	
		if (isset($area)) {
			$where['are_id'] = $area;
		}
		if (isset($profesion)) {
			$where['pro_id'] = $profesion;
		}
		if (isset($departamento)) {
			$where['mun_id_dep'] = $departamento;
		}
		if (isset($municipio)) {
			$where['mun_id'] = $municipio;
		}

    	$data['medicamentos_personal'] = $this->expediente_personal_model->get_medicamentos_empleados($where);
    	$filename                   = 'reporte_detallado_medicamentosxpersonal_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
    	
    	$data['periodo'] = null;
    	$data['tipo_reporte'] 		= $tipo_reporte;
    	$data['filename']           = $filename;
    	if($tipo_reporte == 'excel'){
    		$this->load->view('expediente_personal/reportes/consultar_reporte_detallado_medicamentos_personal', $data);
    	} else{
			$data['titulo']		= 'Medicamentos por Personal';
    		$data['subtitulo'] 	= $periodo;
    		$header = $this->load->view('reporte/header', $data, true);
			$html = $this->load->view('expediente_personal/reportes/consultar_reporte_detallado_medicamentos_personal', $data, true);
    		$reporte = $header . $html;
    		$GLOBALS['nombre_reporte']  = $filename;
    		$this->pdf->makePdf($reporte, 'P', 'Reporte_detallado_medicamentosxpersonal_', 'Letter');
    	}
    }

	function get_empleados_like() {
        satelite_validar(true);
        $empleado = ($this->input->post('empleado') != '') ? $this->input->post('empleado') : null;
        $where  = null;
        $like   = null;             
        if ($empleado != '') {
            $like['emp_nombre'] = $empleado;
            $like['emp_apellido'] = $empleado;
            $like['emp_codigo'] = $empleado;
        }
        $where['emp_estado'] = 1;
        $arreglo = array();
        $empleados = $this->expediente_personal_model->get_empleados_like($where, $like);

        if (count($empleados) > 0 ) {
            foreach ($empleados as $key => $value) {
                $arreglo[$key]['id'] = $value['emp_id'];
                $arreglo[$key]['nombre'] = $value['emp_codigo'].' - '.$value['emp_nombre'].' '.$value['emp_apellido'];
            }
        }
        echo json_encode($arreglo);
    }

	function reporte_capacitaciones() {

		satelite_validar();
		if($_POST){

			$post_array = $this->input->post();
			$fecha_inicio 			= ($post_array['fecha_inicio'] != '' )? $post_array['fecha_inicio'] : null;
			$fecha_fin 				= ($post_array['fecha_fin'] != '') ? $post_array['fecha_fin'] : null;
			$unidad_organizativa 	= ($post_array['unidad_organizativa'] != '') ? $post_array['unidad_organizativa'] : null;
			$empleado 				= ($post_array['empleado'] != '') ? $post_array['empleado'] : null;
			$fecha_inicio = formatear_fecha('Y-m-d', $fecha_inicio);
			$fecha_fin = formatear_fecha('Y-m-d', $fecha_fin);
    		$where = array('cpe_estado =' => 1);
    		if ($fecha_inicio != "") {
    			$where['DATE(cpe_fecha_inicio) >= '] = $fecha_inicio;
    		}
    		if ($fecha_fin != "") {
    			$where['DATE(cpe_fecha_fin) <= '] = $fecha_fin;
    		}
    		if ($unidad_organizativa) {
    			$where['emp_id_are'] = $unidad_organizativa;
    		}
    		if ($empleado) {
    			$where['cpe_id_emp'] = $empleado;
    		}

    		$data['capacitaciones_grid'] = $this->expediente_personal_model->get_capacitaciones($where);
    		$tipo_reporte               = $post_array['tipo_reporte'];
    		$data["tipo_reporte"]       = $tipo_reporte;
    		$html = $this->load->view('expediente_personal/reportes/consultar_reporte_capacitaciones', $data, true);

			if ($tipo_reporte == '') {
				echo json_encode(array('html' => $html));
			}
		} else {

			$data['titulo_personal'] = "Reporte de capacitaciones recibidas";
			
			cargarvista($data);
		}	           
	}

	function imprimir_reporte_capacitaciones(){
		satelite_validar();
		$post_array 	= $this->input->post();
		$fecha_inicio 			= ($post_array['txtFechaIni'] != '' )? $post_array['txtFechaIni'] : null;
		$fecha_fin 				= ($post_array['txtFechaFin'] != '') ? $post_array['txtFechaFin'] : null;
		$unidad_organizativa 	= ($post_array['slcUnidadOrganizativa'] != '') ? $post_array['slcUnidadOrganizativa'] : null;
		$empleado 				= ($post_array['slcEmpleado'] != '') ? $post_array['slcEmpleado'] : null;
    	$tipo_reporte 	= $post_array['tipo_reporte'];
    	$fecha_inicio 	= formatear_fecha('Y-m-d', $fecha_inicio);
    	$fecha_fin  	= formatear_fecha('Y-m-d', $fecha_fin);
    	$where = array('cpe_estado =' => 1);
    	if ($fecha_inicio != "") {
    		$where['DATE(cpe_fecha_inicio) >= '] = $fecha_inicio;
		}
    	if ($fecha_fin != "") {
    		$where['DATE(cpe_fecha_fin) <= '] = $fecha_fin;
		}
    	if ($unidad_organizativa) {
			$where['emp_id_are'] = $unidad_organizativa;
		}
    	if ($empleado) {
    		$where['cpe_id_emp'] = $empleado;
		}
		$data['capacitaciones_grid'] = $this->expediente_personal_model->get_capacitaciones($where);
    	$filename                   = 'reporte_capacitaciones_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
    	$periodo = ($fecha_inicio != "") ? "Desde: " . formatear_fecha('d-m-Y', $fecha_inicio) :"";
    	$periodo .= ($fecha_fin != "") ? " Hasta: " . formatear_fecha('d-m-Y', $fecha_fin) :"";
    	$data['periodo'] = $periodo;
    	$data['tipo_reporte'] 		= $tipo_reporte;
    	$data['filename']           = $filename;

    	if($tipo_reporte == 'excel'){
    		$this->load->view('expediente_personal/reportes/consultar_reporte_capacitaciones', $data);
    	} else{
			$data['titulo']		= 'capacitaciones recibidas';
    		$data['subtitulo'] 	= $periodo;
    		$header = $this->load->view('reporte/header', $data, true);
			$html = $this->load->view('expediente_personal/reportes/consultar_reporte_capacitaciones', $data, true);
    		$reporte = $header . $html;
    		$GLOBALS['nombre_reporte']  = $filename;
    		$this->pdf->makePdf($reporte, 'L', 'Reporte_capacitaciones_', 'Letter');
    	}
    }

	function reporte_actualizacion_perfil() {

		satelite_validar();
		if($_POST){

			$post_array = $this->input->post();
			$fecha_inicio 			= ($post_array['fecha_inicio'] != '' )? $post_array['fecha_inicio'] : null;
			$fecha_fin 				= ($post_array['fecha_fin'] != '') ? $post_array['fecha_fin'] : null;
			$unidad_organizativa 	= ($post_array['unidad_organizativa'] != '') ? $post_array['unidad_organizativa'] : null;
			$fecha_inicio = formatear_fecha('Y-m-d', $fecha_inicio);
			$fecha_fin = formatear_fecha('Y-m-d', $fecha_fin);
    		$where = array('emp_empleado.emp_estado =' => 1);
    		if ($fecha_inicio != "") {
    			$where['DATE(emp_empleado.emp_fecha_mod) >= '] = $fecha_inicio;
    		}
    		if ($fecha_fin != "") {
    			$where['DATE(emp_empleado.emp_fecha_mod) <= '] = $fecha_fin;
    		}
    		if ($unidad_organizativa) {
    			$where['emp_empleado.emp_id_are'] = $unidad_organizativa;
    		}

    		$data['actualizaciones'] = $this->expediente_personal_model->get_listado_empleados($where);
    		$tipo_reporte               = $post_array['tipo_reporte'];
    		$data["tipo_reporte"]       = $tipo_reporte;
    		$html = $this->load->view('expediente_personal/reportes/consultar_reporte_actualizacion_perfil', $data, true);

			if ($tipo_reporte == '') {
				echo json_encode(array('html' => $html));
			}
		} else {

			$data['titulo_personal'] = "Reporte de actualizaciones de perfil";
			
			cargarvista($data);
		}	           
	}

	function imprimir_reporte_actualizacion_perfil(){
		satelite_validar();
		$post_array 	= $this->input->post();
		$fecha_inicio 			= ($post_array['txtFechaIni'] != '' )? $post_array['txtFechaIni'] : null;
		$fecha_fin 				= ($post_array['txtFechaFin'] != '') ? $post_array['txtFechaFin'] : null;
		$unidad_organizativa 	= ($post_array['slcUnidadOrganizativa'] != '') ? $post_array['slcUnidadOrganizativa'] : null;

		$tipo_reporte 	= $post_array['tipo_reporte'];
    	$fecha_inicio 	= formatear_fecha('Y-m-d', $fecha_inicio);
    	$fecha_fin  	= formatear_fecha('Y-m-d', $fecha_fin);
    	$where = array('emp_empleado.emp_estado =' => 1);
    	if ($fecha_inicio != "") {
    		$where['DATE(emp_empleado.emp_fecha_mod) >= '] = $fecha_inicio;
		}
    	if ($fecha_fin != "") {
    		$where['DATE(emp_empleado.emp_fecha_mod) <= '] = $fecha_fin;
		}
    	if ($unidad_organizativa) {
			$where['emp_empleado.emp_id_are'] = $unidad_organizativa;
		}
		$data['actualizaciones'] = $this->expediente_personal_model->get_listado_empleados($where);
    	$filename                   = 'reporte_actualizaciones_perfil_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
    	$periodo = ($fecha_inicio != "") ? "Desde: " . formatear_fecha('d-m-Y', $fecha_inicio) :"";
    	$periodo .= ($fecha_fin != "") ? " Hasta: " . formatear_fecha('d-m-Y', $fecha_fin) :"";
    	$data['periodo'] = $periodo;
    	$data['tipo_reporte'] 		= $tipo_reporte;
    	$data['filename']           = $filename;

    	if($tipo_reporte == 'excel'){
    		$this->load->view('expediente_personal/reportes/consultar_reporte_actualizacion_perfil', $data);
    	} else{
			$data['titulo']		= 'actualizaciones de perfil';
    		$data['subtitulo'] 	= $periodo;
    		$header = $this->load->view('reporte/header', $data, true);
			$html = $this->load->view('expediente_personal/reportes/consultar_reporte_actualizacion_perfil', $data, true);
    		$reporte = $header . $html;
    		$GLOBALS['nombre_reporte']  = $filename;
    		$this->pdf->makePdf($reporte, 'L', 'Reporte_actualizaciones_perfil_', 'Letter');
    	}
    }


	function reporte_ficha_empleados_masivo() {
		satelite_validar();
		if($_POST){
			$post_array = $this->input->post();
			$filtro_busqueda		= ($post_array['filtro_busqueda'] != '') ? $post_array['filtro_busqueda'] : null;
			$area					= ($post_array['area'] != '') ? $post_array['area'] : null;
			$tipo_contrato			= ($post_array['tipo_contrato'] != '') ? $post_array['tipo_contrato'] : null;
			$profesion				= ($post_array['profesion'] != '') ? $post_array['profesion'] : null;
			$fecha_inicio 			= ($post_array['fecha_inicio'] != '' )? $post_array['fecha_inicio'] : null;
			$fecha_fin 				= ($post_array['fecha_fin'] != '') ? $post_array['fecha_fin'] : null;
			$fecha_inicio = formatear_fecha('Y-m-d', $fecha_inicio);
			$fecha_fin = formatear_fecha('Y-m-d', $fecha_fin);
    		$where = array();
			if (isset($filtro_busqueda)) {
				if ($filtro_busqueda == 1) { //area
					if (isset($area)) {
						$where['emp_empleado.emp_id_are'] = $area;
					}
				} else if ($filtro_busqueda == 2) { //tipo contrato
					if (isset($tipo_contrato)) {
						$where['emp_empleado.emp_id_tic'] = $tipo_contrato;
					}
				} else if ($filtro_busqueda == 3) { //ultima actualizacion
					if ($fecha_inicio != "") {
						$where['DATE(emp_empleado.emp_fecha_mod) >= '] = $fecha_inicio;
					}
					if ($fecha_fin != "") {
						$where['DATE(emp_empleado.emp_fecha_mod) <= '] = $fecha_fin;
					}
				} else if ($filtro_busqueda == 4) { //profesion
					if (isset($profesion)) {
						$where['emp_empleado.emp_id_pro'] = $profesion;
					}
				} else { //fecha contrato
					if ($fecha_inicio != "") {
						$where['DATE(emp_empleado.emp_fecha_contrato) >= '] = $fecha_inicio;
					}
					if ($fecha_fin != "") {
						$where['DATE(emp_empleado.emp_fecha_contrato) <= '] = $fecha_fin;
					}
				}
			}
    		$data['actualizaciones'] = $this->expediente_personal_model->get_listado_empleados($where);
    		$tipo_reporte               = $post_array['tipo_reporte'];
    		$data["tipo_reporte"]       = $tipo_reporte;
    		$html = $this->load->view('expediente_personal/reportes/consultar_reporte_ficha_empleados_masivo', $data, true);
			if ($tipo_reporte == '') {
				echo json_encode(array('html' => $html));
			}
		} else {
			$select = $this->gsatelite->get_dropdown('tic_tipo_contrato', '{tic_nombre}', '', array('tic_estado' => 1), null, '', 'tic_id', true);
        	$data["tipo_contrato"] = str_replace('<option value="0">Seleccione</option>', '', $select);
			$data['titulo_personal'] = "Impresión masiva de ficha de empleados";
			cargarvista($data);
		}	           
	}

	function imprimir_reporte_ficha_empleados_masivo(){
		satelite_validar();
		$post_array = $this->input->post();
		$ids_seleccionados = ($post_array['ids'] != '') ? explode(',', $post_array['ids']) : null;
		$filename = 'reporte_ficha_empleados_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
    	// $header = $this->load->view('reporte/header', array('titulo' => 'Ficha de empleado'), true);
		$reporte = "";//$header;
		$total_fichas = count($ids_seleccionados);
		foreach ($ids_seleccionados as $k => $value) {
			$data['empleado'] = $this->planilla_model->info_completa_empleado($value);
            $data['documentos'] = $this->planilla_model->documentos_emp($value, '');
            $data['familiares'] = $this->planilla_model->familiares_empleado($value);
            $data['more_info'] = $this->planilla_model->get_empleados_reporte(array('emp_id' => $value));
            $data['foto'] = $this->personal_model->foto_empleado($value);
            $data['informacion'] = $this->personal_model->editar_empleado($value);
            $getDatosempleado = $data['informacion'];
            //------------------------------------------- 	ALERGIAS 	----------------------------------------------------------------
            $alergico = $this->gsatelite->get_tabla('cae_componente_alergico_empleado', array('cae_estado' => 1, 'cae_id_emp' => $value));
            $alerg_select = $this->gsatelite->get_tabla('coa_componente_alergico', array('coa_estado' => 1));
            $ids_alergias = array();
            $array_alergias = array();
            foreach ($alergico as $key) {
            	$ids_alergias[] = $key["cae_id_coa"];
            }
            foreach ($alerg_select as $key) {
            	if (in_array($key['coa_id'], $ids_alergias)) {
            		$array_alergias[] = $key['coa_nombre'];
            	}
            }
            $label_alergias = implode(", ", $array_alergias);
            $data['alergico'] = $label_alergias;
            $data['tipo_sangre'] = $this->gsatelite->get_tabla('tsr_tipo_sangre', array('tsr_estado' => 1, 'tsr_id' => $getDatosempleado[0]['emp_id_tsr']));
            //------------------------------------------- 	DISCAPACIDAD 	--------------------------------------------------------------
            $discapacidad = $getDatosempleado[0]['emp_discapacidad'] == 0 ? "No" : "Si";
            if ($discapacidad == "Si") {
            	$tipo_discapacidad = $this->gsatelite->get_tabla('tds_tipo_discapacidad', array('tds_estado' => 1, 'tds_id' => $getDatosempleado[0]['emp_id_tds']));
            	$discapacidad = $tipo_discapacidad[0]['tds_nombre'];
            }
            $data['discapacidad'] = $discapacidad;
            //----------------------------------------------- 	ENFERMEDADES 	------------------------------------------------------------
            $enfermedad = $this->gsatelite->get_tabla('exe_enfermedadxempleado', array('exe_estado' => 1, 'exe_id_emp' => $value));
            $enf_select = $this->gsatelite->get_tabla('enf_enfermedad', array('enf_estado' => 1));
            $id_enfermedades = array();
            $enfe = array();
            foreach ($enfermedad as $key) {
            	$id_enfermedades[] = $key['exe_id_enf'];
            }
            foreach ($enf_select as $key) {
            	if (in_array($key['enf_id'], $id_enfermedades)) {
            		$enfe[] = $key['enf_nombre'];
            	}
            }
            //el array devuelto en el foreahc anterios devolveras todos los name d elas enfermedades y convertimos en 1 string para mostrar
            $labels_enfermedades = implode(", ", $enfe);
            $data['enfermedades'] = $labels_enfermedades;
            $data['contactar_a'] = $getDatosempleado[0]['emp_contacto_emergencia'];
            $data['direccion'] = $getDatosempleado[0]['emp_direccion_emergencia'];
            $data['telefono'] = $getDatosempleado[0]['emp_telefono_emergencia'];
            $parentesco = $this->gsatelite->get_tabla('pat_parentesco', array('pat_id' => $getDatosempleado[0]['emp_id_pat_contacto']));
            $data['parentesco'] = count($parentesco) > 0 ? $parentesco[0]['pat_nombre']: '';
            //------------------------------------------------- 	DATOS ACADEMICOS 	-----------------------------------------------------
            $datos_academicos = $this->gsatelite->get_tabla('dac_dato_academico', array('dac_estado' => 1, 'dac_id_emp' => $value));
            //Arrays donde se agregara toda la data segun el empleado actual
            $tipo_educacion = array();
            $profesion = array();
            $institucion = array();
            $estado = array();
            $anios = array();
            $fecha_finaliza = array();
            $observaciones_aca = array();
            $pais = array();
            $experiencia_pro = array();
            foreach ($datos_academicos as $key) {
            	$label_tipo_educacion = $this->gsatelite->get_tabla('tie_tipo_educacion', array('tie_id' => $key['dac_id_tie'], 'tie_estado' => 1));
            	$tipo_educacion[] = $label_tipo_educacion[0]['tie_nombre'];
            	$label_profesion = $this->gsatelite->get_tabla('pro_profesion', array('pro_id' => $key['dac_id_pro'], 'pro_estado' => 1));
            	$profesion[] = count($label_profesion) > 0 ? $label_profesion[0]['pro_nombre']: '';
            	$label_institucion = $this->gsatelite->get_tabla('ina_institucion_academica', array('ina_id' => $key['dac_id_ina'], 'ina_estado' => 1));
            	$institucion[] = count($label_institucion) > 0 ? $label_institucion[0]['ina_nombre']: '';
            	$label_estado = $this->gsatelite->get_tabla('ese_estado_estudio', array('ese_id' => $key['dac_id_ese'], 'ese_estado' => 1));
            	$estado[] = count($label_estado) > 0 ? $label_estado[0]['ese_nombre']: '';
            	$anios[] = $key['dac_anios_cursado'];
            	$fecha_finaliza[] = $key['dac_fecha_finalizacion'];
            	$observaciones_aca[] = $key['dac_observacion'];
            	$label_pais = $this->gsatelite->get_tabla('pai_pais', array('pai_id' => $key['dac_id_pai'], 'pai_estado' => 1));
            	$pais[] = count($label_pais) > 0 ? $label_pais[0]['pai_nombre']: '';
            	$label_experiencia = $this->gsatelite->get_tabla('exl_experiencia_laboral', array('exl_id' => $key['dac_id_exl'], 'exl_estado' => 1));
            	$experiencia_pro[] = count($label_experiencia) > 0 ? $label_experiencia[0]['exl_nombre']: '';
            }
            $data['tipo_edu'] = $tipo_educacion;
            $data['profe'] = $profesion;
            $data['insti'] = $institucion;
            $data['esta'] = $estado;
            $data['anios'] = $anios;
            $data['fech_da'] = $fecha_finaliza;
            $data['obser_da'] = $observaciones_aca;
            $data['pais'] = $pais;
            $data['expe'] = $experiencia_pro; 
            $data['datos_academicos'] = $datos_academicos;
            //----------------------------------------- 	PROGRAMAS Y EQUIPOS 	-----------------------------------------------------------
            $tipo_programas = array();
            $nivel_pq = array();
            $programas = $this->gsatelite->get_tabla('pxe_programaxempleado', array('pxe_estado' => 1, 'pxe_id_emp' => $value));
            foreach ($programas as $key) {
            	$label_tipo_pro = $this->gsatelite->get_tabla('peq_programa_equipo', array('peq_estado' => 1, 'peq_id' => $key['pxe_id_peq']));
            	$tipo_programas[] = $label_tipo_pro[0]['peq_nombre'];
            	$label_nivel = $this->gsatelite->get_tabla('nie_nivel_experiencia', array('nie_estado' => 1, 'nie_id' => $key['pxe_id_nie']));
            	$nivel_pq[] = $label_nivel[0]['nie_nombre']; 
            }
            $data['tipo_pq'] = $tipo_programas;
            $data['nivel_pq'] = $nivel_pq;
            $data['programas_equi'] = $programas;
            //-------------------------------------------- 	CERTIFICACIONES 	-----------------------------------------------------------------
            $tipo_programas_cer = array();
            $certificacion = array();
            $impartido_por = array();
            $modalidad = array();
            $puntaje = array();
            $fecha_certi = array();
            $certificaciones = $this->gsatelite->get_tabla('cep_certificacion_programa', array('cep_estado' => 1, 'cep_id_emp' => $value));
            foreach ($certificaciones as $key) {
            	$label_tipo_pro = $this->gsatelite->get_tabla('peq_programa_equipo', array('peq_estado' => 1, 'peq_id' => $key['cep_id_peq']));
            	$tipo_programas_cer[] = $label_tipo_pro[0]['peq_nombre'];
            	$label_certificacion = $this->gsatelite->get_tabla('cer_certificacion', array('cer_estado' => 1, 'cer_id' => $key['cep_id_cer']));
            	$certificacion[] = $label_certificacion[0]['cer_nombre'];
            	$label_impar_por = $this->gsatelite->get_tabla('icp_institucion_capacitacion', array('icp_estado' => 1, 'icp_id' => $key['cep_id_icp']));
            	$impartido_por[] = $label_impar_por[0]['icp_nombre'];
            	$label_modalidad = $this->gsatelite->get_tabla('mde_modalidad_estudio', array('mde_estado' => 1, 'mde_id' => $key['cep_id_mde']));
            	$modalidad[] = $label_modalidad[0]['mde_nombre'];
            	$puntaje[] = $key['cep_puntaje'];
            	$fecha_certi[] = $key['cep_fecha_certificacion'];
            }
            $data['tipo_cer'] = $tipo_programas_cer;
            $data['certi'] = $certificacion;
            $data['impart'] = $impartido_por;
            $data['modali'] = $modalidad;
            $data['puntaje'] = $puntaje;
            $data['fech_cert'] = $fecha_certi;
            $data['certificaciones'] = $certificaciones;
            //--------------------------------------------- 	REF LABORALES 	-------------------------------------------------------------------
            $empresa = array();
            $direccion_ref = array();
            $telefono_ref = array();
            $puesto = array();
            $nombrE_ref = array();
            $jefe_ref = array();
            $salario_ref = array();
            $motivo_retiro = array();
            $desde_ref = array();
            $hasta_ref = array();
            $referencia_ref = array();
            $referencias = $this->gsatelite->get_tabla('rfl_referencia_laboral', array('rfl_estado' => 1, 'rfl_id_emp' => $value));
            $data['referencias'] = $referencias;
            //----------------------------------------------- 	IDIOMAS 	---------------------------------------------------------------------------
            $idioma = array();
            $nivel =  array();
            $leer = array();
            $escribir = array();
            $hablar = array();
            $traductor = array();
            $idiomas = $this->gsatelite->get_tabla('iem_idioma_empleado', array('iem_estado' => 1, 'iem_id_emp' => $value));
            foreach ($idiomas as $key) {
            	$label_idioma = $this->gsatelite->get_tabla('idm_idioma', array('idm_estado' => 1, 'idm_id' => $key['iem_id_idm']));
            	$idioma[] = $label_idioma[0]['idm_nombre'];
            	$label_nivel_i = $this->gsatelite->get_tabla('nii_nivel_idioma', array('nii_estado' => 1, 'nii_id' => $key['iem_id_nii']));
            	$nivel[] = $label_nivel_i[0]['nii_nombre'];
            	$leer[] = $key['iem_leer'] == 1 ? "SI": "NO";
            	$escribir[] = $key['iem_escribir'] == 1 ? "SI": "NO";
            	$hablar[] = $key['iem_hablar'] == 1 ? "SI": "NO";
            	$traductor[] = $key['iem_traductor'] == 1 ? "SI": "NO";
            }
            $data['idioma'] = $idioma;
            $data['nivel'] = $nivel;
            $data['leer'] = $leer;
            $data['escribir'] = $escribir;
            $data['hablar'] = $hablar;
            $data['traductor'] = $traductor;
            $data['idiomas'] = $idiomas;
            //----------------------------------------------- 	CERTIFICACIONES INGLES 	--------------------------------------------------------------------
            $c_idiomas = $this->gsatelite->get_tabla('cri_certificacion_idioma', array('cri_estado' => 1, 'cri_id_emp' => $value));
            $c_idioma = array();
            $certi_c = array();
            $puntaje_c = array();
            $fecha_cer = array();
            foreach ($c_idiomas as $key) {
            	$label_cidioma = $this->gsatelite->get_tabla('idm_idioma', array('idm_estado' => 1, 'idm_id' => $key['cri_id_idm']));
            	$c_idioma[] = $label_cidioma[0]['idm_nombre'];
            	$label_ccerti = $this->gsatelite->get_tabla('cer_certificacion', array('cer_estado' => 1, 'cer_id' => $key['cri_id_cer']));
            	$certi_c[] = $label_ccerti[0]['cer_nombre'];
            	$puntaje_c[] = $key['cri_puntaje'];
            	$fecha_cer[] = $key['cri_fecha_certificacion'];
            }
            $data['c_idioma'] = $c_idioma;
            $data['certi_c'] = $certi_c;
            $data['puntaje_c'] = $puntaje_c;
            $data['fecha_c'] = $fecha_cer;
            $data['c_idiomas'] = $c_idiomas;
            //---------------------------------------------- 	REFS PERSONALES 	-------------------------------------------------------------------------
            $ref_personal = $this->gsatelite->get_tabla('rfp_referencia_personal', array('rfp_estado' => 1, 'rfp_id_emp' => $value));
            $ref_tipo = array();
            $ref_nombre = array();
            $ref_lugar = array();
            $ref_ocupacion = array();
            $ref_telefono = array();
            $ref_referencia = array();
            foreach ($ref_personal as $key) {
            	$label_ref_tipo = $this->gsatelite->get_tabla('trr_tipo_referencia', array('trr_estado' => 1, 'trr_id' => $key['rfp_id_trr']));
            	$ref_tipo[] = $label_ref_tipo[0]['trr_nombre'];
            	$ref_nombre[] = $key['rfp_nombre'];
            	$ref_lugar[] = $key['rfp_lugar_trabajo'];
            	$ref_ocupacion[] = $key['rfp_ocupacion'];
            	$ref_telefono[] = $key['rfp_telefono'];
            	$ref_referencia[] = $key['rfp_descripcion_referencia'];
            }
            $data['ref_tipo'] = $ref_tipo;
            $data['ref_nombre'] = $ref_nombre;
            $data['ref_lugar'] = $ref_lugar;
            $data['ref_ocupacion'] = $ref_ocupacion;
            $data['ref_telefono'] = $ref_telefono;
            $data['ref_referencia'] = $ref_referencia;
            $data['ref_personal'] =  $ref_personal;
            //---------------------------------------------- 	DATOS VIVIENDA 	--------------------------------------------------------------------------------
            $zona = $this->gsatelite->get_tabla('zon_zona', array('zon_id' => $getDatosempleado[0]['emp_id_zon']));
            $data['zona_residencia'] = count($zona) > 0 ? $zona[0]['zon_nombre']: '';
            $nameTipoCasa = $this->gsatelite->get_tabla('tiv_tipo_vivienda', array('tiv_id' => $getDatosempleado[0]['emp_id_tiv']));
            $data['tipo_casa'] = count($nameTipoCasa) > 0 ? $nameTipoCasa[0]['tiv_nombre']: '';
            $nameConstruccion = $this->gsatelite->get_tabla('tcv_tipo_construccion_vivienda', array('tcv_id' => $getDatosempleado[0]['emp_id_tcv']));
            $data['tipo_construccion'] = count($nameConstruccion) > 0 ? $nameConstruccion[0]['tcv_nombre']: '';
            $sre = $this->gsatelite->get_tabla('sre_servicio_empleado', array('sre_estado' => 1, 'sre_id_emp' => $value));
            $servicios = array();
            foreach ($sre as $key) {
            	$label_serv = $this->gsatelite->get_tabla('srb_servicio_basico', array('srb_estado' => 1, 'srb_id' => $key['sre_id_srb']));
            	$servicios[] = $label_serv[0]['srb_nombre'];
            }
            $data['servicios'] = implode(', ', $servicios);
            //---------------------------------------------- 	HABILIDADES EMPLEADO 	-----------------------------------------------------------------------
            $habilidades_emp = $this->gsatelite->get_tabla('hxm_habilidadxempleado', array('hxm_id_emp' => $value));
            $habilidad = array();
            $nivel_hab = array();
            foreach ($habilidades_emp as $key) {
            	$label_hab = $this->gsatelite->get_tabla('hab_habilidad', array('hab_estado' => 1, 'hab_id' => $key['hxm_id_hab']));
            	$habilidad[] = $label_hab[0]['hab_nombre'];
            	$label_nivelhab = $this->gsatelite->get_tabla('nih_nivel_habilidad', array('nih_estado' => 1, 'nih_id' => $key['hxm_id_nih']));
            	$nivel_hab[] = $label_nivelhab[0]['nih_nombre'];
            }
            $data['habilidad'] = $habilidad;
            $data['nivel_hab'] = $nivel_hab;
            $data['habilidad_emp'] = $habilidades_emp;
            //----------------------------------------------- 	AGRUPACIONES EMPLEADO 	--------------------------------------------------------------------------
            $agrupaciones_emp = $this->gsatelite->get_tabla('age_agrupacion_empleado', array('age_estado' => 1, 'age_id_emp' => $value));
            $data['agrupaciones'] = $agrupaciones_emp;
            //--------------------------------------------- 	INSUMOS EMPLEADO 	------------------------------------------------------------------------------
            $insumos = $this->gsatelite->get_tabla('ixe_insumoxempleado', array('ixe_id_emp' => $value));
            $tipo_ins = array();
            $insumo = array();
            $cantidad_ins = array();
            $costo = array();
            $fecha_ins = array();
            foreach ($insumos as $key) {
            	$id_inm = $this->gsatelite->get_tabla('inm_insumo', array('inm_estado' => 1, 'inm_id' => $key['ixe_id_inm']));
            	$label_tipoins = $this->gsatelite->get_tabla('tim_tipo_insumo', array('tim_estado' => 1, 'tim_id' => $id_inm[0]['inm_id_tim']));
            	$tipo_ins[] = $label_tipoins[0]['tim_nombre'];
            	$label_insumo = $this->gsatelite->get_tabla('inm_insumo', array('inm_estado' => 1, 'inm_id' => $key['ixe_id_inm']));
            	$insumo[] = $id_inm[0]['inm_nombre'];
            	$cantidad_ins[] = explode(".", $key['ixe_cantidad'])[0];
            	$costo[] = $key['ixe_costo'];
            	$fecha_ins[] = explode(" ", $key['ixe_fecha_entrega'])[0];
            }
            $data['tipo_insumo'] = $tipo_ins;
            $data['insumo'] = $insumo;
            $data['cantidad_insumo'] = $cantidad_ins;
            $data['costo_insumo'] = $costo;
            $data['fecha_insumo'] = $fecha_ins;
            $data['insumos'] = $insumos;
            //---------------------------------------------- 	CAPACITACIONES 	-----------------------------------------------------------------------------------
            $capacitaciones = $this->gsatelite->get_tabla('cpe_capacitacion_empleado', array('cpe_id_emp' => $value));
            $nombre_cp = array();
            $institucion_cp = array();
            $fecha_inicio_cp = array();
            $fecha_fin_cp = array();
            $horas_cp = array();
            $costo_emp_cp = array();
            $costo_ins_cp = array();
            $costo_pro_cp = array();
            $estado_cp = array();
            foreach ($capacitaciones as $key) {
            	$nombre_cp[] = $key['cpe_nombre'];
            	$label_nombre = $this->gsatelite->get_tabla('icp_institucion_capacitacion', array('icp_id' => $key['cpe_id_icp']));
            	$institucion_cp[] = count($label_nombre) > 0 ? $label_nombre[0]['icp_nombre']: '';
            	$fecha_inicio_cp[] = explode(" ", $key['cpe_fecha_inicio'])[0];
            	$fecha_fin_cp[] = explode(" ", $key['cpe_fecha_fin'])[0];
            	$horas_cp[] = $key['cpe_duracion'];
            	$costo_emp_cp[] = $key['cpe_costo_empresa'];
            	$costo_ins_cp[] = $key['cpe_costo_insaforp'];
            	$costo_pro_cp[] = $key['cpe_costo_proveedor'];
            	$label_estado = $this->gsatelite->get_tabla('ese_estado_estudio', array('ese_id' => $key['cpe_id_ese']));
            	$estado_cp[] = count($label_estado) > 0 ? $label_estado[0]['ese_nombre']: '';
            }
            $data['nombre_cp'] = $nombre_cp;
            $data['institucion_cp'] = $institucion_cp;
            $data['fecha_inicio_cp'] = $fecha_inicio_cp;
            $data['fecha_fin_cp'] = $fecha_fin_cp;
            $data['horas_cp'] = $horas_cp;
            $data['costo_emp_cp'] = $costo_emp_cp;
            $data['costo_ins_cp'] = $costo_ins_cp;
            $data['costo_pro_cp'] = $costo_pro_cp;
            $data['estado_cp'] = $estado_cp;
            $data['capacitaciones'] = $capacitaciones;
            //---------------------------------------------- TERMINA CAPACITACIONES -------------------------------------------------------
            $anexos = $this->gsatelite->get_tabla('axe_anexoxempleado', array('axe_id_emp' => $value));
            $list_anx = array();
            $i = 0;
            foreach ($anexos as $key) {
            	$data_anx = $this->gsatelite->get_tabla('anx_anexo', array('anx_id' => $key['axe_id_anx']));
            	$data_url = explode('.', $data_anx[0]['anx_url']);
            	$type = strtolower(trim(end($data_url)));
            	$list_anx[$i]['name'] = $data_anx[0]['anx_nombre'];
            	$list_anx[$i]['link'] = $data_anx[0]['anx_url'];
            	$list_anx[$i]['type'] = $type;
            	$list_anx[$i]['face'] = $data_anx[0]['anx_imagen'];
            	$list_anx[$i]['icon'] = "media/imagenes/sistema/" . $type . ".png";                  
            	$i++;
            }
            $data['lista_anexos'] = $list_anx;
            //////////////////////////////////////////////// ENTREVISTA ////////////////////////////////////////////////////////////////////////
            								  $this->db->join('tnv_tipo_entrevista', 'enm_id_tnv = tnv_id',"left");
            $data["entrevista_solicitante"] = $this->gsatelite->get_tabla('enm_entrevista_empleado', array('enm_id_emp'=>$value));
            //////////////////////////////////////////////// PRUEBAS //////////////////////////////////////////////////////////////////////////
            							  $this->db->join('tib_tipo_prueba', 'pbe_id_tib = tib_id',"left");
            $data["prueba_solicitante"] = $this->gsatelite->get_tabla('pbe_prueba_empleado', array('pbe_id_emp'=>$value));
            $reporte .= trim($this->load->view('expediente_personal/empleado/ficha_empleado', $data, true));
            if ((intval($k) + 1) < $total_fichas){
            	$reporte .= '<div style="page-break-after: always"></div>';
            }
        }
        if (version_compare(PHP_VERSION, '6.0.0', '>=')) {
        	$GLOBALS['nombre_reporte'] = $filename;
        	$html = '<html><head><link rel="stylesheet" type="text/css" href="'.base_url('stylesheets\print.css').'" /></head><body>' . $reporte . '</body></html>';
        	$this->pdf->makePdf($html, 'P', $filename, 'Letter');
        	// $this->pdf->reporteNombrePDF($reporte, explode(' ', trim($getDatosempleado[0]['emp_nombre']))[0].$getDatosempleado[0]['emp_codigo'], 'I', 1);
		} else {
			$this->pdf->reporteNombrePDF($reporte, $filename, 'I', 1);
		}
    }


}
?>