<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Empleado extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('personal_model');
        $this->load->model('gsatelite');
        $this->load->library('grocery_CRUD');
        $this->load->model('planilla_model');
        $this->load->model('consultas');
        $this->load->model('proceso_model');
        $this->load->model('expediente_personal_model');
        $this->load->model('registro_academico_model');
        $this->load->library('pdf');

        $this->load->library('tank_auth');
        $this->load->library('EnLetras');
        $this->driver = $this->planilla_model;
    }

    public function ficha_empleado($id_emp) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data['empleado'] = $this->planilla_model->info_completa_empleado($id_emp);
            //print_r($data['empleado']);die();
            $data['documentos'] = $this->planilla_model->documentos_emp($id_emp, '');
            $data['familiares'] = $this->planilla_model->familiares_empleado($id_emp);
            $data['more_info'] = $this->planilla_model->get_empleados_reporte(array('emp_id' => $id_emp));
            $data['foto'] = $this->personal_model->foto_empleado($id_emp);
            //*******************************************************************************************************************
            $data['informacion'] = $this->personal_model->editar_empleado($id_emp);
            $getDatosempleado = $data['informacion'];
            //--------------------------------------------------------------------------------------------------------------------------------
            //                                                      ALERGIAS
            //---------------------------------------------------------------------------------------------------------------------------------
            $alergico = $this->gsatelite->get_tabla('cae_componente_alergico_empleado', array('cae_estado' => 1, 'cae_id_emp' => $id_emp));
            $alerg_select = $this->gsatelite->get_tabla('coa_componente_alergico', array('coa_estado' => 1));
            $ids_alergias = array();
            $array_alergias = array();
            foreach ($alergico as $key) {
                $ids_alergias[] = $key["cae_id_coa"];
            }
            foreach ($alerg_select as $key) {
                if (in_array($key['coa_id'], $ids_alergias)) {
                    $array_alergias[] = $key['coa_nombre'];
                }
            }
            $label_alergias = implode(", ", $array_alergias);
            $data['alergico'] = $label_alergias;
            //----------------------------------------------- TERMINA ALERGIAS ----------------------------------------------------------------
            $data['tipo_sangre'] = $this->gsatelite->get_tabla('tsr_tipo_sangre', array('tsr_estado' => 1, 'tsr_id' => $getDatosempleado[0]['emp_id_tsr']));
            //--------------------------------------------------------------------------------------------------------------------------------
            //                                                      DISCAPACIDAD
            //---------------------------------------------------------------------------------------------------------------------------------
            $discapacidad = $getDatosempleado[0]['emp_discapacidad'] == 0 ? "No" : "Si";
            if ($discapacidad == "Si") {
                $tipo_discapacidad = $this->gsatelite->get_tabla('tds_tipo_discapacidad', array('tds_estado' => 1, 'tds_id' => $getDatosempleado[0]['emp_id_tds']));
                $discapacidad = $tipo_discapacidad[0]['tds_nombre'];
            }
            $data['discapacidad'] = $discapacidad;
            //--------------------------------------------------------------------------------------------------------------------------------
            //                                                       ENFERMEDADES
            //---------------------------------------------------------------------------------------------------------------------------------
            $enfermedad = $this->gsatelite->get_tabla('exe_enfermedadxempleado', array('exe_estado' => 1, 'exe_id_emp' => $id_emp));
            $enf_select = $this->gsatelite->get_tabla('enf_enfermedad', array('enf_estado' => 1));
            $id_enfermedades = array();
            $enfe = array();
            foreach ($enfermedad as $key) {
                $id_enfermedades[] = $key['exe_id_enf'];
            }
            foreach ($enf_select as $key) {
                if (in_array($key['enf_id'], $id_enfermedades)) {
                    $enfe[] = $key['enf_nombre'];
                }
            }
            //el array devuelto en el foreahc anterios devolveras todos los name d elas enfermedades y convertimos en 1 string para mostrar
            $labels_enfermedades = implode(", ", $enfe);
            $data['enfermedades'] = $labels_enfermedades;
            //---------------------------------------------- TERMINA ENFERMEDADES ---------------------------------------------------------------
            $data['contactar_a'] = $getDatosempleado[0]['emp_contacto_emergencia'];
            $data['direccion'] = $getDatosempleado[0]['emp_direccion_emergencia'];
            $data['telefono'] = $getDatosempleado[0]['emp_telefono_emergencia'];
            $parentesco = $this->gsatelite->get_tabla('pat_parentesco', array('pat_id' => $getDatosempleado[0]['emp_id_pat_contacto']));

            $data['parentesco'] = count($parentesco) > 0 ? $parentesco[0]['pat_nombre']: '';
            //--------------------------------------------------------------------------------------------------------------------------------
            //                                                      DATOS ACADEMICOS
            //---------------------------------------------------------------------------------------------------------------------------------
            $datos_academicos = $this->gsatelite->get_tabla('dac_dato_academico', array('dac_estado' => 1, 'dac_id_emp' => $id_emp));
            //Arrays donde se agregara toda la data segun el empleado actual
            $tipo_educacion = array();
            $profesion = array();
            $institucion = array();
            $estado = array();
            $anios = array();
            $fecha_finaliza = array();
            $observaciones_aca = array();
            $pais = array();
            $experiencia_pro = array();
            foreach ($datos_academicos as $key) {
                $label_tipo_educacion = $this->gsatelite->get_tabla('tie_tipo_educacion', array('tie_id' => $key['dac_id_tie'], 'tie_estado' => 1));
                $tipo_educacion[] = $label_tipo_educacion[0]['tie_nombre'];
                $label_profesion = $this->gsatelite->get_tabla('pro_profesion', array('pro_id' => $key['dac_id_pro'], 'pro_estado' => 1));
                $profesion[] = count($label_profesion) > 0 ? $label_profesion[0]['pro_nombre']: '';
                $label_institucion = $this->gsatelite->get_tabla('ina_institucion_academica', array('ina_id' => $key['dac_id_ina'], 'ina_estado' => 1));
                $institucion[] = count($label_institucion) > 0 ? $label_institucion[0]['ina_nombre']: '';
                $label_estado = $this->gsatelite->get_tabla('ese_estado_estudio', array('ese_id' => $key['dac_id_ese'], 'ese_estado' => 1));
                $estado[] = count($label_estado) > 0 ? $label_estado[0]['ese_nombre']: '';
                $anios[] = $key['dac_anios_cursado'];
                $fecha_finaliza[] = $key['dac_fecha_finalizacion'];
                $observaciones_aca[] = $key['dac_observacion'];
                $label_pais = $this->gsatelite->get_tabla('pai_pais', array('pai_id' => $key['dac_id_pai'], 'pai_estado' => 1));
                $pais[] = count($label_pais) > 0 ? $label_pais[0]['pai_nombre']: '';
                $label_experiencia = $this->gsatelite->get_tabla('exl_experiencia_laboral', array('exl_id' => $key['dac_id_exl'], 'exl_estado' => 1));
                $experiencia_pro[] = count($label_experiencia) > 0 ? $label_experiencia[0]['exl_nombre']: '';
            }
            $data['tipo_edu'] = $tipo_educacion;
            $data['profe'] = $profesion;
            $data['insti'] = $institucion;
            $data['esta'] = $estado;
            $data['anios'] = $anios;
            $data['fech_da'] = $fecha_finaliza;
            $data['obser_da'] = $observaciones_aca;
            $data['pais'] = $pais;
            $data['expe'] = $experiencia_pro; 
            $data['datos_academicos'] = $datos_academicos;
            //---------------------------------------------------------------------------------------------------------------------------------
            //                                          PROGRAMAS Y EQUIPOS
            //---------------------------------------------------------------------------------------------------------------------------------
            $tipo_programas = array();
            $nivel_pq = array();
            $programas = $this->gsatelite->get_tabla('pxe_programaxempleado', array('pxe_estado' => 1, 'pxe_id_emp' => $id_emp));
            foreach ($programas as $key) {
                $label_tipo_pro = $this->gsatelite->get_tabla('peq_programa_equipo', array('peq_estado' => 1, 'peq_id' => $key['pxe_id_peq']));
                $tipo_programas[] = $label_tipo_pro[0]['peq_nombre'];
                $label_nivel = $this->gsatelite->get_tabla('nie_nivel_experiencia', array('nie_estado' => 1, 'nie_id' => $key['pxe_id_nie']));
                $nivel_pq[] = $label_nivel[0]['nie_nombre']; 
            }
            $data['tipo_pq'] = $tipo_programas;
            $data['nivel_pq'] = $nivel_pq;
            $data['programas_equi'] = $programas;
            //---------------------------------------------------------------------------------------------------------------------------------
            //                                                  CERTIFICACIONES
            //---------------------------------------------------------------------------------------------------------------------------------
            $tipo_programas_cer = array();
            $certificacion = array();
            $impartido_por = array();
            $modalidad = array();
            $puntaje = array();
            $fecha_certi = array();
            $certificaciones = $this->gsatelite->get_tabla('cep_certificacion_programa', array('cep_estado' => 1, 'cep_id_emp' => $id_emp));
            foreach ($certificaciones as $key) {
                $label_tipo_pro = $this->gsatelite->get_tabla('peq_programa_equipo', array('peq_estado' => 1, 'peq_id' => $key['cep_id_peq']));
                $tipo_programas_cer[] = $label_tipo_pro[0]['peq_nombre'];
                $label_certificacion = $this->gsatelite->get_tabla('cer_certificacion', array('cer_estado' => 1, 'cer_id' => $key['cep_id_cer']));
                $certificacion[] = $label_certificacion[0]['cer_nombre'];
                $label_impar_por = $this->gsatelite->get_tabla('icp_institucion_capacitacion', array('icp_estado' => 1, 'icp_id' => $key['cep_id_icp']));
                $impartido_por[] = $label_impar_por[0]['icp_nombre'];
                $label_modalidad = $this->gsatelite->get_tabla('mde_modalidad_estudio', array('mde_estado' => 1, 'mde_id' => $key['cep_id_mde']));
                $modalidad[] = $label_modalidad[0]['mde_nombre'];
                $puntaje[] = $key['cep_puntaje'];
                $fecha_certi[] = $key['cep_fecha_certificacion'];
            }
            $data['tipo_cer'] = $tipo_programas_cer;
            $data['certi'] = $certificacion;
            $data['impart'] = $impartido_por;
            $data['modali'] = $modalidad;
            $data['puntaje'] = $puntaje;
            $data['fech_cert'] = $fecha_certi;
            $data['certificaciones'] = $certificaciones;
            //---------------------------------------------------------------------------------------------------------------------------------
            //                                                  REF LABORALES
            //---------------------------------------------------------------------------------------------------------------------------------
            $empresa = array();
            $direccion_ref = array();
            $telefono_ref = array();
            $puesto = array();
            $nombrE_ref = array();
            $jefe_ref = array();
            $salario_ref = array();
            $motivo_retiro = array();
            $desde_ref = array();
            $hasta_ref = array();
            $referencia_ref = array();
            $referencias = $this->gsatelite->get_tabla('rfl_referencia_laboral', array('rfl_estado' => 1, 'rfl_id_emp' => $id_emp));
            $data['referencias'] = $referencias;
            //---------------------------------------------------------------------------------------------------------------------------------
            //                                                      IDIOMAS
            //---------------------------------------------------------------------------------------------------------------------------------
            $idioma = array();
            $nivel =  array();
            $leer = array();
            $escribir = array();
            $hablar = array();
            $traductor = array();
            $idiomas = $this->gsatelite->get_tabla('iem_idioma_empleado', array('iem_estado' => 1, 'iem_id_emp' => $id_emp));
            foreach ($idiomas as $key) {
                $label_idioma = $this->gsatelite->get_tabla('idm_idioma', array('idm_estado' => 1, 'idm_id' => $key['iem_id_idm']));
                $idioma[] = $label_idioma[0]['idm_nombre'];
                $label_nivel_i = $this->gsatelite->get_tabla('nii_nivel_idioma', array('nii_estado' => 1, 'nii_id' => $key['iem_id_nii']));
                $nivel[] = $label_nivel_i[0]['nii_nombre'];
                $leer[] = $key['iem_leer'] == 1 ? "SI": "NO";
                $escribir[] = $key['iem_escribir'] == 1 ? "SI": "NO";
                $hablar[] = $key['iem_hablar'] == 1 ? "SI": "NO";
                $traductor[] = $key['iem_traductor'] == 1 ? "SI": "NO";
            }
            $data['idioma'] = $idioma;
            $data['nivel'] = $nivel;
            $data['leer'] = $leer;
            $data['escribir'] = $escribir;
            $data['hablar'] = $hablar;
            $data['traductor'] = $traductor;
            $data['idiomas'] = $idiomas;
            //---------------------------------------------------------------------------------------------------------------------------------
            //                                                      CERTIFICACIONES INGLES
            //---------------------------------------------------------------------------------------------------------------------------------
            $c_idiomas = $this->gsatelite->get_tabla('cri_certificacion_idioma', array('cri_estado' => 1, 'cri_id_emp' => $id_emp));
            $c_idioma = array();
            $certi_c = array();
            $puntaje_c = array();
            $fecha_cer = array();
            foreach ($c_idiomas as $key) {
                $label_cidioma = $this->gsatelite->get_tabla('idm_idioma', array('idm_estado' => 1, 'idm_id' => $key['cri_id_idm']));
                $c_idioma[] = $label_cidioma[0]['idm_nombre'];
                $label_ccerti = $this->gsatelite->get_tabla('cer_certificacion', array('cer_estado' => 1, 'cer_id' => $key['cri_id_cer']));
                $certi_c[] = $label_ccerti[0]['cer_nombre'];
                $puntaje_c[] = $key['cri_puntaje'];
                $fecha_cer[] = $key['cri_fecha_certificacion'];
            }
            $data['c_idioma'] = $c_idioma;
            $data['certi_c'] = $certi_c;
            $data['puntaje_c'] = $puntaje_c;
            $data['fecha_c'] = $fecha_cer;
            $data['c_idiomas'] = $c_idiomas;
            //---------------------------------------------------------------------------------------------------------------------------------
            //                                                      REFS PERSONALES
            //---------------------------------------------------------------------------------------------------------------------------------
            $ref_personal = $this->gsatelite->get_tabla('rfp_referencia_personal', array('rfp_estado' => 1, 'rfp_id_emp' => $id_emp));
            $ref_tipo = array();
            $ref_nombre = array();
            $ref_lugar = array();
            $ref_ocupacion = array();
            $ref_telefono = array();
            $ref_referencia = array();
            foreach ($ref_personal as $key) {
                $label_ref_tipo = $this->gsatelite->get_tabla('trr_tipo_referencia', array('trr_estado' => 1, 'trr_id' => $key['rfp_id_trr']));
                $ref_tipo[] = $label_ref_tipo[0]['trr_nombre'];
                $ref_nombre[] = $key['rfp_nombre'];
                $ref_lugar[] = $key['rfp_lugar_trabajo'];
                $ref_ocupacion[] = $key['rfp_ocupacion'];
                $ref_telefono[] = $key['rfp_telefono'];
                $ref_referencia[] = $key['rfp_descripcion_referencia'];
            }
            $data['ref_tipo'] = $ref_tipo;
            $data['ref_nombre'] = $ref_nombre;
            $data['ref_lugar'] = $ref_lugar;
            $data['ref_ocupacion'] = $ref_ocupacion;
            $data['ref_telefono'] = $ref_telefono;
            $data['ref_referencia'] = $ref_referencia;
            $data['ref_personal'] =  $ref_personal;
            //---------------------------------------------------------------------------------------------------------------------------------
            //                                                      DATOS VIVIENDA
            //---------------------------------------------------------------------------------------------------------------------------------
            $zona = $this->gsatelite->get_tabla('zon_zona', array('zon_id' => $getDatosempleado[0]['emp_id_zon']));
            $data['zona_residencia'] = count($zona) > 0 ? $zona[0]['zon_nombre']: '';
            $nameTipoCasa = $this->gsatelite->get_tabla('tiv_tipo_vivienda', array('tiv_id' => $getDatosempleado[0]['emp_id_tiv']));
            $data['tipo_casa'] = count($nameTipoCasa) > 0 ? $nameTipoCasa[0]['tiv_nombre']: '';
            $nameConstruccion = $this->gsatelite->get_tabla('tcv_tipo_construccion_vivienda', array('tcv_id' => $getDatosempleado[0]['emp_id_tcv']));
            $data['tipo_construccion'] = count($nameConstruccion) > 0 ? $nameConstruccion[0]['tcv_nombre']: '';
            $sre = $this->gsatelite->get_tabla('sre_servicio_empleado', array('sre_estado' => 1, 'sre_id_emp' => $id_emp));
            $servicios = array();
            foreach ($sre as $key) {
                $label_serv = $this->gsatelite->get_tabla('srb_servicio_basico', array('srb_estado' => 1, 'srb_id' => $key['sre_id_srb']));
                $servicios[] = $label_serv[0]['srb_nombre'];
            }
            $data['servicios'] = implode(', ', $servicios);
            //---------------------------------------------------------------------------------------------------------------------------------
            //                                                   HABILIDADES EMPLEADO
            //---------------------------------------------------------------------------------------------------------------------------------
            $habilidades_emp = $this->gsatelite->get_tabla('hxm_habilidadxempleado', array('hxm_id_emp' => $id_emp));
            $habilidad = array();
            $nivel_hab = array();
            foreach ($habilidades_emp as $key) {
                $label_hab = $this->gsatelite->get_tabla('hab_habilidad', array('hab_estado' => 1, 'hab_id' => $key['hxm_id_hab']));
                $habilidad[] = $label_hab[0]['hab_nombre'];

                $label_nivelhab = $this->gsatelite->get_tabla('nih_nivel_habilidad', array('nih_estado' => 1, 'nih_id' => $key['hxm_id_nih']));
                $nivel_hab[] = $label_nivelhab[0]['nih_nombre'];
            }
            $data['habilidad'] = $habilidad;
            $data['nivel_hab'] = $nivel_hab;
            $data['habilidad_emp'] = $habilidades_emp;
            //---------------------------------------------------------------------------------------------------------------------------------
            //                                                   AGRUPACIONES EMPLEADO
            //---------------------------------------------------------------------------------------------------------------------------------
            $agrupaciones_emp = $this->gsatelite->get_tabla('age_agrupacion_empleado', array('age_estado' => 1, 'age_id_emp' => $id_emp));
            $data['agrupaciones'] = $agrupaciones_emp;
            //---------------------------------------------------------------------------------------------------------------------------------
            //                                                   INSUMOS EMPLEADO
            //---------------------------------------------------------------------------------------------------------------------------------
            $insumos = $this->gsatelite->get_tabla('ixe_insumoxempleado', array('ixe_id_emp' => $id_emp));
            $tipo_ins = array();
            $insumo = array();
            $cantidad_ins = array();
            $costo = array();
            $fecha_ins = array();
            foreach ($insumos as $key) {
                $id_inm = $this->gsatelite->get_tabla('inm_insumo', array('inm_estado' => 1, 'inm_id' => $key['ixe_id_inm']));
                $label_tipoins = $this->gsatelite->get_tabla('tim_tipo_insumo', array('tim_estado' => 1, 'tim_id' => $id_inm[0]['inm_id_tim']));
                $tipo_ins[] = $label_tipoins[0]['tim_nombre'];
                $label_insumo = $this->gsatelite->get_tabla('inm_insumo', array('inm_estado' => 1, 'inm_id' => $key['ixe_id_inm']));
                $insumo[] = $id_inm[0]['inm_nombre'];
                $cantidad_ins[] = explode(".", $key['ixe_cantidad'])[0];
                $costo[] = $key['ixe_costo'];
                $fecha_ins[] = explode(" ", $key['ixe_fecha_entrega'])[0];
            }
            $data['tipo_insumo'] = $tipo_ins;
            $data['insumo'] = $insumo;
            $data['cantidad_insumo'] = $cantidad_ins;
            $data['costo_insumo'] = $costo;
            $data['fecha_insumo'] = $fecha_ins;
            $data['insumos'] = $insumos;
            //-----------------------------------------------------------------------------------------------------------------------------
            //                                                   CAPACITACIONES
            //-----------------------------------------------------------------------------------------------------------------------------
            $capacitaciones = $this->gsatelite->get_tabla('cpe_capacitacion_empleado', array('cpe_id_emp' => $id_emp));
            $nombre_cp = array();
            $institucion_cp = array();
            $fecha_inicio_cp = array();
            $fecha_fin_cp = array();
            $horas_cp = array();
            $costo_emp_cp = array();
            $costo_ins_cp = array();
            $costo_pro_cp = array();
            $estado_cp = array();
            foreach ($capacitaciones as $key) {
                $nombre_cp[] = $key['cpe_nombre'];
                $label_nombre = $this->gsatelite->get_tabla('icp_institucion_capacitacion', array('icp_id' => $key['cpe_id_icp']));
                $institucion_cp[] = count($label_nombre) > 0 ? $label_nombre[0]['icp_nombre']: '';
                $fecha_inicio_cp[] = explode(" ", $key['cpe_fecha_inicio'])[0];
                $fecha_fin_cp[] = explode(" ", $key['cpe_fecha_fin'])[0];
                $horas_cp[] = $key['cpe_duracion'];
                $costo_emp_cp[] = $key['cpe_costo_empresa'];
                $costo_ins_cp[] = $key['cpe_costo_insaforp'];
                $costo_pro_cp[] = $key['cpe_costo_proveedor'];
                $label_estado = $this->gsatelite->get_tabla('ese_estado_estudio', array('ese_id' => $key['cpe_id_ese']));
                $estado_cp[] = count($label_estado) > 0 ? $label_estado[0]['ese_nombre']: '';
            }
            $data['nombre_cp'] = $nombre_cp;
            $data['institucion_cp'] = $institucion_cp;
            $data['fecha_inicio_cp'] = $fecha_inicio_cp;
            $data['fecha_fin_cp'] = $fecha_fin_cp;
            $data['horas_cp'] = $horas_cp;
            $data['costo_emp_cp'] = $costo_emp_cp;
            $data['costo_ins_cp'] = $costo_ins_cp;
            $data['costo_pro_cp'] = $costo_pro_cp;
            $data['estado_cp'] = $estado_cp;
            $data['capacitaciones'] = $capacitaciones;
            //---------------------------------------------- TERMINA CAPACITACIONES -------------------------------------------------------
            $anexos = $this->gsatelite->get_tabla('axe_anexoxempleado', array('axe_id_emp' => $id_emp));
            $list_anx = array();
            $i = 0;
            foreach ($anexos as $key) {
                $data_anx = $this->gsatelite->get_tabla('anx_anexo', array('anx_id' => $key['axe_id_anx']));
                $data_url = explode('.', $data_anx[0]['anx_url']);
                $type = strtolower(trim(end($data_url)));
                $list_anx[$i]['name'] = $data_anx[0]['anx_nombre'];
                $list_anx[$i]['link'] = $data_anx[0]['anx_url'];
                $list_anx[$i]['type'] = $type;
                $list_anx[$i]['face'] = $data_anx[0]['anx_imagen'];
                $list_anx[$i]['icon'] = "media/imagenes/sistema/" . $type . ".png";                  
                $i++;
            }
            //$data['anexos'] = $anexos;
            $data['lista_anexos'] = $list_anx;

            //////////////////////////////////////////////// ENTREVISTA ////////////////////////////////////////////////////////////////////////
            $this->db->join('tnv_tipo_entrevista', 'enm_id_tnv = tnv_id',"left");
            $data["entrevista_solicitante"] = $this->gsatelite->get_tabla('enm_entrevista_empleado', array('enm_id_emp'=>$id_emp));

            //////////////////////////////////////////////// PRUEBAS //////////////////////////////////////////////////////////////////////////
            $this->db->join('tib_tipo_prueba', 'pbe_id_tib = tib_id',"left");
            $data["prueba_solicitante"] = $this->gsatelite->get_tabla('pbe_prueba_empleado', array('pbe_id_emp'=>$id_emp));

            //*****************************************************************
            $header = $this->load->view('reporte/header', array('titulo' => 'Ficha de empleado'), true);
            $html = $this->load->view('expediente_personal/empleado/ficha_empleado', $data, true);
            $reporte =  $header . $html;
            if (version_compare(PHP_VERSION, '6.0.0', '>=')) {
                $filename = explode(' ',trim($getDatosempleado[0]['emp_nombre']))[0].$getDatosempleado[0]['emp_codigo'];
                $GLOBALS['nombre_reporte'] = $filename;
                $html = '<html><head><style>' . $stylesheet . '</style></head><body>' . $reporte . '</body></html>';
                $this->pdf->makePdf($html, 'P', $filename, 'Letter');
            } else {
                $this->pdf->reporteNombrePDF($reporte, explode(' ', trim($getDatosempleado[0]['emp_nombre']))[0].$getDatosempleado[0]['emp_codigo'], 'I', 1);            
            }
        }
    }

    public function deshabilitar_empleado() {
        //redireccionar la funcionalidad compartidad
        redirect('expediente_personal/empleado/retiro_personal'); //add by René Castaneda (21-12-2017)
    }

    public function index_agregar_empleado($act_r = false, $lugar = 0) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $where['emp_estado'] = (isset($_POST['slcEstado']) && $_POST['slcEstado'] == 0) ? 0 : 1;
            $data['estado_emp'] = $where['emp_estado'];
            $data["act_r"] = $act_r;
            //print_r($this->input->post()); die();
            if  ($act_r) {
                $emp_id = $this->gsatelite->get_campo('users', 'usu_id_emp', array('id'=>$this->tank_auth->get_user_id()));
                $select = $this->gsatelite->get_dropdown('emp_empleado', '{emp_nombre}  {emp_apellido}', '', array('emp_estado' => 1), $emp_id, '', 'emp_id', true);
                $data["slc_empleado"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
                $where["emp_id"] = $emp_id;
                $data["lugar"] = $lugar;
            }
            //Added by René Castaneda 05-03-2018
            //actualizar al id de empresa según la sessión del usuario (dado que es un cambio nuevo)
            $this->gsatelite->actualizar_empresa_id('emp_empleado');
            $data['total_empleados'] = $this->personal_model->listado_empleados($where);
            $titulo['titulo_personal'] = "Gestión de personal";
            //$this->_cargarvista($titulo, $data);
            cargarvista($titulo, $data, 'expediente_personal/empleado/index_agregar_empleado');
        }
    }

    public function exportar_empleados($tipo = 0, $estado = 1){
        $data['tipo'] = $tipo;
                                   $this->db->order_by('emp_codigo');
        $data['total_empleados'] = $this->personal_model->listado_empleados(array('emp_estado' => $estado));
        $html = $this->load->view('expediente_personal/empleado/detalle_empleados', $data, true);
        if ($tipo > 0) {
            $header = $this->load->view('reporte/header', array('titulo' => 'empleados'), true);
            $GLOBALS['nombre_reporte'] = 'empleados_' . date('dmY');
            $reporte = $header . $html;
            $this->pdf->SetTitle('listado_empleados');
            $this->pdf->makePdf($reporte, 'P', 'listado_empleados', 'Letter');
        } else {
            echo $html;
        }
        
    }

    function gestion_seguro($id_emp = null, $dtc = null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $this->gsatelite->verificar_registro_real('emp_empleado', $id_emp);
            $registro_emp = $this->gsatelite->get_registro('emp_empleado', 'emp_id', $id_emp);
            $IDS = $this->expediente_personal_model->porcentajes_seguro_empleado($id_emp);
            $data["opciones_seguro"] = $this->select_tipo_seguro($id_emp);
            $data["nombre_empleado"] = $registro_emp->emp_nombre . " " . $registro_emp->emp_apellido;
            $crud = new grocery_CRUD();
            $crud->set_subject('Porcentaje Seguro')->set_table('prs_porcentaje_seguro');
            $crud->set_relation('prs_id_fam', 'fam_familiar', '{fam_nombre} {fam_apellido}', array('fam_dependiente' => 1, 'fam_id_emp' => $id_emp));
            $crud->set_relation('prs_id_sxe', 'sxe_seguroxempleado', '{sxe_id}', array('sxe_id_emp' => $id_emp));
            $crud->where("prs_id in ( {$IDS} )");
            $crud->columns('prs_id_fam', 'prs_id_sxe_column', 'prs_porcentaje', 'prs_estado');
            $crud->callback_column('prs_id_sxe_column', function($value, $row) {
                $registro_sxe = $this->gsatelite->get_registro('sxe_seguroxempleado', 'sxe_id', $row->prs_id_sxe);
                $registro_seg = $this->gsatelite->get_registro('seg_seguro', 'seg_id', $registro_sxe->sxe_id_seg);
                return $registro_seg->seg_nombre;
            });
            $crud->display_as('prs_id_fam', 'Familiar');
            $crud->display_as('prs_id_sxe', 'Tipo Seguro');
            $crud->display_as('prs_id_sxe_column', 'Tipo Seguro');
            $crud->display_as('prs_estado', 'Estado');
            $crud->display_as('prs_porcentaje', 'Porcentaje');
            $crud->display_as('prs_observaciones', 'Observación');
            $crud->fields('prs_id_fam', 'prs_id_sxe', 'prs_porcentaje', 'prs_observaciones', 'prs_estado', 'prs_fecha_mod', 'prs_usu_mod');
            $crud->required_fields('prs_id_fam', 'prs_id_sxe', 'prs_porcentaje', 'prs_estado');
            $crud->field_type('prs_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            $crud->field_type('prs_fecha_mod', 'hidden', date("Y-m-d H:i:s"));
            $crud->field_type('prs_usu_mod', 'hidden', $this->tank_auth->get_user_id());
            $crud->set_rules('prs_porcentaje', 'Porcentaje', 'trim|required|is_numeric');
            $crud->set_rules('prs_id_sxe', 'Tipo Seguro', 'trim|required|callback_validar_seguro');

            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('prs_estado', 'hidden', 1);
            } else {  // Editar
                $crud->field_type('prs_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            $crud->callback_before_insert(array($this, 'validar_ponderaciones'));
            $crud->callback_before_update(array($this, 'validar_ponderaciones'));
            //$crud->set_rules('seg_nombre','Nombre','trim|required|campo_unico[seg_seguro.seg_nombre]');

            $crud->set_lang_string('update_error', 'Los porcentajes deben sumar el 100%');
            $crud->set_lang_string('insert_error', 'Los porcentajes deben sumar el 100%');


            $output = $crud->render();
            $data['dct'] = $dct;
            $data['titulo_personal'] = "Porcentaje Seguro";
            $this->_cargarvista($data, $output);
        }
    }

    /* @author: René Castaneda */

    function select_tipo_seguro($id_emp = 0) {

        $this->db->order_by('sxe_id');
        $this->db->join('seg_seguro', 'seg_id=sxe_id_seg');
        $consul = $this->gsatelite->get_tabla('sxe_seguroxempleado', array('sxe_id_emp' => $id_emp));
        $html_select = '<option value=""></option>';
        foreach ($consul as $fila) {
            $html_select .= '<option value="' . $fila['sxe_id'] . '">' . $fila['seg_nombre'] . '</option>';
        }
        return ($html_select != "") ? $html_select : '';
    }

    public function ingresos_descuentos() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data['total_empleados'] = $this->personal_model->listado_empleados();
            $titulo['titulo_personal'] = "Ingresos y descuentos empleado";
            $this->_cargarvista($titulo, $data);
        }
    }

    public function guardar_gral($parametros, $carpeta = null) {
        //print_r($parametros);
        //exit();
        $datos = @explode($parametros);
        $carpeta = $parametros;

        $image = $this->upload_gral($carpeta);

        //echo base_url().'/public/temp/'.$image['upload_data']['raw_name'].$image['upload_data']['file_ext'];
        echo $image['upload_data']['raw_name'] . $image['upload_data']['file_ext'];
        //echo $image['upload_data']['client_name'];
    }

    function upload_gral($carpeta) {

        $ruta = FCPATH . "public/temp/" . $carpeta;
        if (!file_exists($ruta)) {
            mkdir($ruta, 0777);
        }

        $obj = &get_instance();
        $config['upload_path'] = $ruta;
        $config['allowed_types'] = 'pdf|jpg|png|jpeg|doc|xls|docx|xlsx';
        $obj->load->library('upload', $config);
        if (!$obj->upload->do_upload()) {
            $error = array('error' => $obj->upload->display_errors());
            return true;
        } else {
            $data = array('upload_data' => $obj->upload->data());
            return $data;
        }
        print_r($data);
    }

    function eliminar_imagen_gral($carpeta = "") {

        $url = $this->input->post("url");
        echo $url;
        $carp = ($carpeta != "") ? $carpeta : "documentos";

        unlink("./public/temp/$carp/" . $url);
    }

    public function eliminar_empleado($emp_id) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $registro = $this->gsatelite->get_registro('emp_empleado', 'emp_id', $emp_id);
            $array = array('emp_estado' => 0, 'emp_id_plz' => null);
            $this->db->where('emp_id', $emp_id)
                    ->update('emp_empleado', $array);


            $dct = $this->input->get('dct');
            if ($dct == 1) {

                $array = array('dct_estado' => 0);
                $this->db->where('dct_id_emp', $emp_id)
                        ->update('dct_docente', $array);

                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Docente desactivado", 'texto_alerta' => "La operación a sido realizada con exito");
                $this->session->set_flashdata($alerta);
                redirect('registro_academico/procesos/index_agregar_docente');
            } else {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Empleada/o desactivado", 'texto_alerta' => "La operación a sido realizada con exito");
                $this->session->set_flashdata($alerta);
                redirect('expediente_personal/empleado/index_agregar_empleado');
            }
        }
    }

    public function eliminar_empleado_2($emp_id) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $registro = $this->gsatelite->get_registro('emp_empleado', 'emp_id', $emp_id);
            $array = array('emp_estado' => 0, 'emp_id_plz' => null);
            $this->db->where('emp_id', $emp_id)
                    ->update('emp_empleado', $array);



            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Empleada/o desactivado", 'texto_alerta' => "La operación a sido realizada con exito");
            $this->session->set_flashdata($alerta);
            redirect('expediente_personal/empleado/deshabilitar_empleado');
        }
    }

    public function reactivar_empleado($emp_id) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $array = array('emp_estado' => 1);
            $this->db->where('emp_id', $emp_id)
                    ->update('emp_empleado', $array);


            $dct = $this->input->get('dct');
            if ($dct == 1) {
                $array = array('dct_estado' => 1);
                $this->db->where('dct_id_emp', $emp_id)
                        ->update('dct_docente', $array);

                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Docente reactivado", 'texto_alerta' => "La operación a sido realizada con exito<br />Actualizar al empleado y asignarle una plaza / cargo funcional");
                $this->session->set_flashdata($alerta);
                redirect('registro_academico/procesos/index_agregar_docente');
            } else {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Empleada/o reactivado", 'texto_alerta' => "La operación a sido realizada con exito<br />Actualizar al empleado y asignarle una plaza / cargo funcional");
                $this->session->set_flashdata($alerta);
                redirect('expediente_personal/empleado/index_agregar_empleado');
            }
        }
    }

    public function reactivar_empleado_2($emp_id) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $array = array('emp_estado' => 1);
            $this->db->where('emp_id', $emp_id)
                    ->update('emp_empleado', $array);

            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Empleada/o reactivado", 'texto_alerta' => "La operación a sido realizada con exito<br />Actualizar al empleado y asignarle una plaza / cargo funcional");
            $this->session->set_flashdata($alerta);
            redirect('expediente_personal/empleado/deshabilitar_empleado');
        }
    }

    function editar_ingreso($ingreso_id) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data['tipo_ingreso'] = $this->personal_model->tipo_ingreso();
            $data['ingreso'] = $this->planilla_model->editar_ingreso_info($ingreso_id);
            $titulo['titulo_personal'] = "Ingresos";
            $this->_cargarvista($titulo, $data);
        }
    }

    function ingreso_editar() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $ingreso = $this->input->post('inn_id');
            $resultado = $this->planilla_model->editar_ingreso($ingreso);
            if ($resultado === TRUE) {

                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Actualización Completada", 'texto_alerta' => "La actualización de los datos a sido exitosa");
                $this->session->set_flashdata($alerta);
                redirect('expediente_personal/empleado/index_agregar_empleado');
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "No se pudo actualizar el registro", 'texto_alerta' => "Corrobore los datos y vuelva a intentar");

                $this->session->set_flashdata($alerta);
                redirect('expediente_personal/empleado/editar_ingreso/' . $descuento);
            }
        }
    }

    function editar_descuento($descuento_id) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data['tipo_descuento'] = $this->personal_model->tipo_descuento();
            /* print_r($this->db->last_query());
              exit(); */
            $data['informacion'] = $this->planilla_model->editar_descuento_info($descuento_id);
            $titulo['titulo_personal'] = "Edición de descuento";

            $this->_cargarvista($titulo, $data);
        }
    }

    function descuento_editar($descuento) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $descuento = $this->input->post('dss_id');
            $resultado = $this->planilla_model->editar_descuento($descuento);

            if ($resultado === TRUE) {

                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Actualización Completada", 'texto_alerta' => "La actualización de los datos a sido exitosa");
                $this->session->set_flashdata($alerta);
                redirect('expediente_personal/empleado/index_agregar_empleado');
            } else {
                $alerta = array('tipo_alerta' => 'notice', 'titulo_alerta' => "No se pudo actualizar el registro", 'texto_alerta' => "Corrobore los datos y vuelva a intentar");

                $this->session->set_flashdata($alerta);
                redirect('expediente_personal/empleado/editar_descuento/' . $descuento);
            }
        }
    }

    function agregar_empleado() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {            
            $data['genero'] = $this->personal_model->get_genero();
            $data['nacionalidad'] = $this->personal_model->get_nacionalidad();
            $data['estado_civil'] = $this->personal_model->get_estado_civil();
            $data['profesion'] = $this->personal_model->get_profesion();
            $data['tipo_telefono'] = $this->personal_model->get_tipotelefono();
            $data['afp'] = $this->personal_model->get_afp();
            $data['doc_documentos'] = $this->personal_model->get_documentos();
            $tipos_doc = $this->expediente_personal_model->get_dropdown('tde_tipo_documento', '{tde_nombre}', '', array('tde_estado' => 1), null, '', 'tde_id', true);
            $data['options_tipo_documento'] = str_replace('<option value="0">Seleccione</option>', '', $tipos_doc);

            $arreglo_ids = $this->expediente_personal_model->get_permitidos_plaza();
            $this->db->where_not_in('plz_id', $arreglo_ids);
            $where_plaza = array('plz_estado' => '1');

            $this->db->join('mxr_empresaxarea', 'mxr_id_are = plz_id_are');
            $this->db->where('mxr_id_emr', $this->tank_auth->get_empresa_id()); //Added by René Castaneda 02-03-2018  
            $data['plaza'] = $this->gsatelite->get_tabla('plz_plaza', $where_plaza);
            $data['departamento'] = $this->personal_model->get_departamento();
            $data['sucursal'] = $this->personal_model->get_sucursal();
            $data['tipo_contrato'] = $this->personal_model->get_tipo_contrato();
            $data['parentescos'] = $this->personal_model->get_parentesco();

            $dct = $this->input->get('dct');
            if ($dct == 1) {
                $data['dct'] = $dct;
                $titulo['titulo_personal'] = "Nuevo Docente";
            } else {
                $titulo['titulo_personal'] = "Nuevo empleado";
            }

            $select = $this->expediente_personal_model->get_dropdown('idm_idioma', '{idm_nombre}', '', array('idm_estado' => 1), null, '', 'idm_id', true);
            $data["idm_idioma"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            $select = $this->expediente_personal_model->get_dropdown('nii_nivel_idioma', '{nii_nombre}', '', array('nii_estado' => 1), null, '', 'nii_id', true);
            $data["nivel_idioma"] = str_replace('<option value="0">Seleccione</option>', '', $select);

            $select = "";
            $datos = $this->gsatelite->get_tabla('cer_certificacion', array('cer_estado' => 1, 'cer_tipo' => 1));
            foreach ($datos as $key) {
                $select .= '<option value = "' . $key['cer_id'] . '">' . $key['cer_nombre'] . '</option>';
            }
            $data["cert_idioma_d"] = str_replace('<option value="0">Seleccione</option>', '', $select);

            $data["alergico"] = $this->gsatelite->get_tabla('coa_componente_alergico', array('coa_estado' => 1));
            $data["enfermedad"] = $this->gsatelite->get_tabla('enf_enfermedad', array('enf_estado' => 1));

            //programas
            $select = $this->expediente_personal_model->get_dropdown('nie_nivel_experiencia', '{nie_nombre}', '', array('nie_estado' => 1), null, '', 'nie_id', true);
            $data["nivel_programa_select"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            $select = $this->expediente_personal_model->get_dropdown('peq_programa_equipo', '{peq_nombre}', '', array('peq_estado' => 1), null, '', 'peq_id', true);
            $data["tipo_programa_select"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            $select = "";
            $datos = $this->gsatelite->get_tabla('cer_certificacion', array('cer_estado' => 1, 'cer_tipo' => 2));
            foreach ($datos as $key) {
                $select .= '<option value = "' . $key['cer_id'] . '">' . $key['cer_nombre'] . '</option>';
            }
            $data["cert_programa_select"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            $select = $this->expediente_personal_model->get_dropdown('icp_institucion_capacitacion', '{icp_nombre}', '', array('icp_estado' => 1), null, '', 'icp_id', true);
            $data["institucion_select"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            $select = $this->expediente_personal_model->get_dropdown('mde_modalidad_estudio', '{mde_nombre}', '', array('mde_estado' => 1), null, '', 'mde_id', true);
            $data["modalidad_select"] = str_replace('<option value="0">Seleccione</option>', '', $select);

            //RefPersonales
            $select = $this->expediente_personal_model->get_dropdown('trr_tipo_referencia', '{trr_nombre}', '', array('trr_estado' => 1), null, '', 'trr_id', true);
            $data["tipo_referencia"] = str_replace('<option value="0">Seleccione</option>', '', $select);

            //DatAcademicos
            $select = $this->expediente_personal_model->get_dropdown('tie_tipo_educacion', '{tie_nombre}', '', array('tie_estado' => 1), null, '', 'tie_id', true);
            $data["tipo_educacion"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            $select = $this->expediente_personal_model->get_dropdown('pro_profesion', '{pro_nombre}', '', array('pro_estado' => 1), null, '', 'pro_id', true);
            $data["pro_profesion"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            $select = $this->expediente_personal_model->get_dropdown('ina_institucion_academica', '{ina_nombre}', '', array('ina_estado' => 1), null, '', 'ina_id', true);
            $data["institucion_academica"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            $select = $this->expediente_personal_model->get_dropdown('ese_estado_estudio', '{ese_nombre}', '', array('ese_estado' => 1), null, '', 'ese_id', true);
            $data["estado_estudio"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            $select2 = $this->expediente_personal_model->get_dropdown('pai_pais', '{pai_nombre}', '', array('pai_estado' => 1), null, '', 'pai_id', true);
            $data["pai_pais"] = str_replace('<option value="0">Seleccione</option>', '', $select2);
            $select = $this->expediente_personal_model->get_dropdown('exl_experiencia_laboral', '{exl_nombre}', '', array('exl_estado' => 1), null, '', 'exl_id', true);
            $data["experiencia_laboral"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            $select = $this->gsatelite->get_dropdown('hab_habilidad', '{hab_nombre}', '', array('hab_estado' => 1), null, '', 'hab_id', true);
            $data["habilidad"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            $select = $this->gsatelite->get_dropdown('nih_nivel_habilidad', '{nih_nombre}', '', array('nih_estado' => 1), null, '', 'nih_id', true);
            $data["nivel_habilidad"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            $select = $this->gsatelite->get_dropdown('zon_zona', '{zon_nombre}', '', array('zon_estado' => 1), null, '', 'zon_id', true);
            $data["slcZona"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            $select = $this->gsatelite->get_dropdown('tiv_tipo_vivienda', '{tiv_nombre}', '', array('tiv_estado' => 1), null, '', 'tiv_id', true);
            $data["slcTipoCasa"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            $select = $this->gsatelite->get_dropdown('srb_servicio_basico', '{srb_nombre}', '', array('srb_estado' => 1), null, '', 'srb_id', true);
            $data["slcServiciosBasicos"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            $select = $this->gsatelite->get_dropdown('tcv_tipo_construccion_vivienda', '{tcv_nombre}', '', array('tcv_estado' => 1), null, '', 'tcv_id', true);
            $data["slcTipoConstruccion"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            $select = $this->gsatelite->get_dropdown('gen_genero', '{gen_nombre}', '', array('gen_estado' => 1), null, '', 'gen_id', true);
            $data["genero"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            $select = $this->gsatelite->get_dropdown('dep_departamento', '{dep_nombre}', '', array('dep_estado' => 1), null, '', 'dep_id', true);
            $data["slcDepartamento"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            $select = $this->gsatelite->get_dropdown('pai_pais', '{pai_nacionalidad}', '', array('pai_estado' => 1), null, '', 'pai_id', true);
            $data["slcNacionalidad"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            $select = $this->gsatelite->get_dropdown('mun_municipio', '{mun_nombre}', '', array('mun_estado' => 1, 'mun_id_dep' => 0), null, '', 'mun_id', true);
            $data["slcMunicipio"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            $select = $this->gsatelite->get_dropdown('tps_tipo_salario', '{tps_nombre}', '', array('tps_estado' => 1), null, '', 'tps_id', true);
            $data["slcTipoSalario"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            $select = $this->gsatelite->get_dropdown('cta_categoria_aguinaldo', '{cta_nombre}', '', array('cta_estado' => 1), null, '', 'cta_id', true);
            $data["slcCatAguinaldo"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            $select = $this->gsatelite->get_dropdown('fnr_fuente_reclutamiento', '{fnr_nombre}', '', array('fnr_estado' => 1), null, '', 'fnr_id', true);
            $data["slcFuenteReclutamiento"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);            
            $select = $this->gsatelite->get_dropdown('tpc_tipo_cuenta', '{tpc_nombre}', '', array('tpc_estado' => 1), null, '', 'tpc_id', true);
            $data["slcTipoCuenta"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);

            //Tab insumos
            $select = $this->gsatelite->get_dropdown('tim_tipo_insumo', '{tim_nombre}', '', array('tim_estado' => 1), null, '', 'tim_id', true);
            $data["slcTipoInsumo"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);

            //Tab capacitaciones
            $select = $this->gsatelite->get_dropdown('icp_institucion_capacitacion', '{icp_nombre}', '', array('icp_estado' => 1), null, '', 'icp_id', true);
            $data["slcInstitucionCapacitacion"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            $select = $this->gsatelite->get_dropdown('ese_estado_estudio', '{ese_nombre}', '', array('ese_estado' => 1), null, '', 'ese_id', true);
            $data["slcEstadoEstudio"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);

            //Documentos                                    
            $select = $this->gsatelite->get_dropdown('mun_municipio', '{mun_nombre}', '', array('mun_estado' => 1), null, '', 'mun_id', true);
            $data["slcMunicipioExp"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            
            // Tipo entrevista
            $select = $this->gsatelite->get_dropdown('tnv_tipo_entrevista', '{tnv_nombre}', '', array('tnv_estado' => 1), null, '', 'tnv_id', true);
            $data["slc_entrevista"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);

            // Tipo prueba
                $select = $this->gsatelite->get_dropdown('tib_tipo_prueba', '{tib_nombre}', '', array('tib_estado' => 1), null, '', 'tib_id', true);
                $data["slc_pruebas"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            
                //////////////// CODIGO DEL EMPLEADO //////////////////////////////////////
            // $last=$this->consultas->get_max_codigo('emp_empleado','emp_codigo');

            $longitu = $this->gsatelite->get_parametro_emp('SYS_CODIGO_NUEVO_EMPLEADO', null, null, array('LONGITUD MINIMA'));
            if ( $longitu != 0 ){
                $prefijo = $this->gsatelite->get_parametro_emp('SYS_CODIGO_NUEVO_EMPLEADO', null, null, array('PREFIJO CODIGO'));
                $longitu = $this->gsatelite->get_parametro_emp('SYS_CODIGO_NUEVO_EMPLEADO', null, null, array('LONGITUD MINIMA'));
                $last = $this->consultas->get_max_codigo('emp_empleado','emp_id');
                $code = $last->codigo;
                $cod = (float)$code + 1;
                $codigo = $prefijo . str_pad($cod, $longitu, '0', STR_PAD_LEFT);
                $data['codigo'] = $codigo;
                // var_dump($codigo);
                // die();
            } else {
                $last=$this->consultas->get_max_codigo('emp_empleado','emp_codigo');
                $code=$last->codigo;
                $cod= (float)$code+1;
                $codigo = str_pad($cod, 4, '0', STR_PAD_LEFT);
                $data['codigo'] = $codigo;
            }


            //////////////// N° DE EXPEDIENTE  //////////////////////////////////////
            $last_e=$this->consultas->get_max_codigo('emp_empleado','emp_expediente');
            $exped=$last_e->codigo;
            $exp= (float)$exped+1;
            $empediente = str_pad($exp, 4, '0', STR_PAD_LEFT);
            $data['expediente'] = $empediente;

            $this->_cargarvista($titulo, $data);
        }
    }

    public function editar_empleado($emp_id, $tipo, $ver_detalle = null,$precarga = null,$viene_concurso = null, $act_r = false,$wcome = 0) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');   
        } else {
            $data["act_r"] = $act_r;
            $data["wcome"] = $wcome;
            $ver_detalle = ((int) $ver_detalle === 0)?$ver_detalle = null:$ver_detalle;
            $registro = $this->gsatelite->get_registro('emp_empleado', 'emp_id', $emp_id);
            /*************Determinar la cantidad de promociones nivelaciones **********************/
            $num_promos = count($this->gsatelite->get_tabla('pps_promocion_plaza_salarioxemp', array('pps_id_emp' => $emp_id)));            
            $data['num_promos'] = $num_promos;
            //$data['genero'] = $this->personal_model->get_genero();
            //$data['nacionalidad'] = $this->personal_model->get_nacionalidad();
            $data['estado_civil'] = $this->personal_model->get_estado_civil();
            $data['profesion'] = $this->personal_model->get_profesion();
            $data['tipo_telefono'] = $this->personal_model->get_tipotelefono();
            $data['afp'] = $this->personal_model->get_afp();
            $data['doc_documentos'] = $this->personal_model->get_documentos();
            $data['parentescos_cat'] = $this->personal_model->get_parentesco();
            $data['precarga'] = $precarga;
            //$data['puesto']=$this->personal_model->get_puesto();
            $arreglo_ids = $this->expediente_personal_model->get_permitidos_plaza($registro->emp_id_plz);
            $this->db->where_not_in('plz_id', $arreglo_ids);
            if ($registro->emp_id_are != "") {
                /* Se comenta por los casos de data anterior que no coinciden el area con la plaza*/
                // $this->db->where('plz_id_are',$registro->emp_id_are);
            }            
            $this->db->join('mxr_empresaxarea', 'mxr_id_are = plz_id_are');
            $this->db->where('mxr_id_emr', $this->tank_auth->get_empresa_id()); //Added by René Castaneda             
            //Si el insert viene de un concurso
            // $plaza_con = $this->gsatelite->get_campo('cnp_concurso_plaza','cnp_id_plz',array('cnp_id' => $viene_concurso));
            //$are_con   = $this->gsatelite->get_campo('cnp_concurso_plaza','cnp_id_are',array('cnp_id' => $viene_concurso));
            $data['plaza'] = $this->gsatelite->get_tabla('plz_plaza', array('plz_estado' => 1));
            $data['departamento'] = $this->personal_model->get_departamento();
            $data['sucursal'] = $this->personal_model->get_sucursal();
            $data['tipo_contrato'] = $this->personal_model->get_tipo_contrato();
            $data['informacion'] = $informacion = $this->personal_model->editar_empleado($emp_id);
            $data['telefonos'] = $this->personal_model->editar_tel_empleado($emp_id);
            //oculta el thead de la tabla, en el caso de que no hayan datos
            $tel_sty = 'style="display:none;"';
            if (!(empty($data['telefonos']))) {
                $tel_sty = '';
            }
            $data['tel_sty'] = $tel_sty;
            $data['alergico'] = $this->gsatelite->get_tabla('cae_componente_alergico_empleado', array('cae_estado' => 1, 'cae_id_emp' => $emp_id));
            $data['enfermedad'] = $this->gsatelite->get_tabla('exe_enfermedadxempleado', array('exe_estado' => 1, 'exe_id_emp' => $emp_id));
            $data['medicamentos'] = $this->gsatelite->get_tabla('mxe_medicamento_x_empleado', array('mxe_estado' => 1, 'mxe_id_emp' => $emp_id));
            $data['enf_select'] = $this->gsatelite->get_tabla('enf_enfermedad', array('enf_estado' => 1));
            $data['alerg_select'] = $this->gsatelite->get_tabla('coa_componente_alergico', array('coa_estado' => 1));
            $data['parentescos_enf'] = $this->gsatelite->get_tabla('pat_parentesco');
            $data['documentos'] = $this->personal_model->editar_doc_empleado($emp_id);
            $data['parentescos'] = $this->personal_model->editar_fam_empleado($emp_id);
            //oculta el thead de la tabla, en el caso de que no hayan datos
            $paren_sty = "display:none;";
            if (!(empty($data['parentescos']))) {
                $paren_sty = "";
            }
            $data['paren_sty'] = $paren_sty;
            //programas y equipo
            $select = $this->expediente_personal_model->get_dropdown('nie_nivel_experiencia', '{nie_nombre}', '', array('nie_estado' => 1), null, '', 'nie_id', true);
            $data["nivel_programa_select"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            $select = $this->expediente_personal_model->get_dropdown('peq_programa_equipo', '{peq_nombre}', '', array('peq_estado' => 1), null, '', 'peq_id', true);
            $data["tipo_programa_select"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            $select = "";
            $datos = $this->gsatelite->get_tabla('cer_certificacion', array('cer_estado' => 1, 'cer_tipo' => 2));
            foreach ($datos as $key) {
                $select .= '<option value = "' . $key['cer_id'] . '">' . $key['cer_nombre'] . '</option>';
            }
            $data["cert_programa_select"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            $select = $this->expediente_personal_model->get_dropdown('icp_institucion_capacitacion', '{icp_nombre}', '', array('icp_estado' => 1), null, '', 'icp_id', true);
            $data["institucion_select"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            $select = $this->expediente_personal_model->get_dropdown('mde_modalidad_estudio', '{mde_nombre}', '', array('mde_estado' => 1), null, '', 'mde_id', true);
            $data["modalidad_select"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            $data['nivel_programa_select2'] = $this->gsatelite->get_tabla('nie_nivel_experiencia', array('nie_estado' => 1,));
            $data['tipo_programa_select2'] = $this->gsatelite->get_tabla('peq_programa_equipo', array('peq_estado' => 1));
            $data['cert_programa_select2'] = $this->gsatelite->get_tabla('cer_certificacion', array('cer_estado' => 1, 'cer_tipo' => 2));
            $data['institucion_programa_select2'] = $this->gsatelite->get_tabla('icp_institucion_capacitacion', array('icp_estado' => 1));
            $data['modalidad_programa_select2'] = $this->gsatelite->get_tabla('mde_modalidad_estudio', array('mde_estado' => 1));
            $data['programa'] = $this->gsatelite->get_tabla('pxe_programaxempleado', array('pxe_estado' => 1, 'pxe_id_emp' => $emp_id));
            $data['programa_certificacion'] = $this->gsatelite->get_tabla('cep_certificacion_programa', array('cep_estado' => 1, 'cep_id_emp' => $emp_id));
            $program_sty = "display:none;";
            if (!(empty($data['tipo_programa_select2']))) {
                $program_sty = "";
            }
            $data['program_sty'] = $program_sty;
            $program_cert_sty = "display:none;";
            if (!(empty($data['programa_certificacion']))) {
                $program_cert_sty = "";
            }
            $data['program_cert_sty'] = $program_cert_sty;
            $data['anexos'] = $this->personal_model->anexo_empleado($emp_id);
            $data['foto'] = $this->personal_model->foto_empleado($emp_id);
            $data['tipo'] = $tipo;
            /* ============================================================================================
              =					DATOS DE LOS IDIOMAS
              ==============================================================================================             */
            //controles para los select
            $select = $this->expediente_personal_model->get_dropdown('idm_idioma', '{idm_nombre}', '', null, null, '', 'idm_id', true);
            $data["idm_idioma"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            $select = $this->expediente_personal_model->get_dropdown('nii_nivel_idioma', '{nii_nombre}', '', null, null, '', 'nii_id', true);
            $data["nivel_idioma"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            $select = "";
            $datos = $this->gsatelite->get_tabla('cer_certificacion', array('cer_estado' => 1, 'cer_tipo' => 1));
            foreach ($datos as $key) {
                $select .= '<option value = "' . $key['cer_id'] . '">' . $key['cer_nombre'] . '</option>';
            }
            $data["cert_idioma_d"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            //fin de controles
            //tablas para mostrar los idiomas y certificacion del empleado
            $data['idiomas'] = $this->gsatelite->get_tabla('iem_idioma_empleado', array('iem_estado' => 1, 'iem_id_emp' => $emp_id));
            $data['certificado'] = $this->gsatelite->get_tabla('cri_certificacion_idioma', array('cri_estado' => 1, 'cri_id_emp' => $emp_id));
            //idiomas
            $data['select_idiomas'] = $this->gsatelite->get_tabla('idm_idioma', array('idm_estado' => 1));
            $data['select_nivel'] = $this->gsatelite->get_tabla('nii_nivel_idioma', array('nii_estado' => 1));
            //certificado
            $data['select_certificacion'] = $this->gsatelite->get_tabla('cer_certificacion', array('cer_estado' => 1, 'cer_tipo' => 1));
            //oculta el thead de la tabla, en el caso de que no hayan datos
            $idi_sty = 'style = "display:none"';
            $cer_sty = 'style = "display:none"';
            if (!(empty($data['idiomas']))) {
                $idi_sty = '';
            }
            if (!(empty($data['certificado']))) {
                $cer_sty = '';
            }
            $data['tabla_idm'] = $idi_sty;
            $data['tabla_cer'] = $cer_sty;
            /* ============================================================================================
              =					DATOS DE LAS REFERENCIAS PERSONALES
              ============================================================================================             */
            //controles para los select
            $select = $this->expediente_personal_model->get_dropdown('trr_tipo_referencia', '{trr_nombre}', '', array('trr_estado' => 1), null, '', 'trr_id', true);
            $data["tipo_referencia"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            //tabla relacionada con el empleado
            $data["referencia_personal"] = $this->gsatelite->get_tabla('rfp_referencia_personal', array('rfp_estado' => 1, 'rfp_id_emp' => $emp_id));
            //tablas para mostrar los idiomas y certificacion del empleado
            $data['tipo_referencia_select'] = $this->gsatelite->get_tabla('trr_tipo_referencia', array('trr_estado' => 1));
            //oculta el thead de la tabla, en el caso de que no hayan datos
            $refpersonal_sty = 'style = "display:none"';
            if (!(empty($data['referencia_personal']))) {
                $refpersonal_sty = '';
            }
            $data['refpersonal_sty'] = $refpersonal_sty;
            /* ============================================================================================
              =					DATOS DE LAS REFERENCIAS PERSONALES
              =============================================================================================             */
            //tabla relacionada con el empleado
            $data["referencia_laboral"] = $this->gsatelite->get_tabla('rfl_referencia_laboral', array('rfl_estado' => 1, 'rfl_id_emp' => $emp_id));
            //oculta el thead de la tabla, en el caso de que no hayan datos
            $reflaboral_sty = 'display:none;';
            if (!(empty($data['referencia_laboral']))) {
                $reflaboral_sty = '';
            }
            $data['reflaboral_sty'] = $reflaboral_sty;            
            /* ============================================================================================
              =                 INSUMOS EMPLEADO
              ==============================================================================================
             */                    
            $data["insumos_grid"] = $this->expediente_personal_model->get_insumos(array('ixe_estado' => 1,'ixe_id_emp' => $emp_id));            
            /* ============================================================================================
              =                 INSUMOS EMPLEADO
              ==============================================================================================
             */                    
            $data["capacitaciones_grid"] = $this->expediente_personal_model->get_capacitaciones(array('cpe_estado' => 1,'cpe_id_emp' => $emp_id));            
            /* ============================================================================================
              =						DATOS ACADEMICOS
              ==============================================================================================
             */
            //tabla relacionada con el empleado
            $data["datos_academicos"] = $this->gsatelite->get_tabla('dac_dato_academico', array('dac_estado' => 1, 'dac_id_emp' => $emp_id));
            //oculta el thead de la tabla, en el caso de que no hayan datos
            $datacademic_sty = 'style = "display:none"';
            if (!(empty($data['datos_academicos']))) {
                $datacademic_sty = '';
            }
            $data['datacademic_sty'] = $datacademic_sty;
            $select = $this->expediente_personal_model->get_dropdown('tie_tipo_educacion', '{tie_nombre}', '', array('tie_estado' => 1), null, '', 'tie_id', true);
            $data["tipo_educacion"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            $select = $this->expediente_personal_model->get_dropdown('pro_profesion', '{pro_nombre}', '', array('pro_estado' => 1), null, '', 'pro_id', true);
            $data["pro_profesion"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            $select = $this->expediente_personal_model->get_dropdown('ina_institucion_academica', '{ina_nombre}', '', array('ina_estado' => 1), null, '', 'ina_id', true);
            $data["institucion_academica"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            $select = $this->expediente_personal_model->get_dropdown('ese_estado_estudio', '{ese_nombre}', '', array('ese_estado' => 1), null, '', 'ese_id', true);
            $data["estado_estudio"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            $select2 = $this->expediente_personal_model->get_dropdown('pai_pais', '{pai_nombre}', '', array('pai_estado' => 1), null, '', 'pai_id', true);
            $data["pai_pais"] = str_replace('<option value="0">Seleccione</option>', '', $select2);
            $select = $this->expediente_personal_model->get_dropdown('exl_experiencia_laboral', '{exl_nombre}', '', array('exl_estado' => 1), null, '', 'exl_id', true);
            $data["experiencia_laboral"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            $data["sel_tipo_educacion"] = $this->expediente_personal_model->get_select('tie_tipo_educacion', array('tie_nombre', 'asc'), array('tie_estado' => 1));
            $data["sel_pro_profesion"] = $this->expediente_personal_model->get_select('pro_profesion', array('pro_nombre', 'asc'), array('pro_estado' => 1));
            $data["sel_institucion_academica"] = $this->expediente_personal_model->get_select('ina_institucion_academica', array('ina_nombre', 'asc'), array('ina_estado' => 1));
            $data["sel_estado_estudio"] = $this->expediente_personal_model->get_select('ese_estado_estudio', array('ese_nombre', 'asc'), array('ese_estado' => 1));
            $data["sel_pai_pais"] = $this->expediente_personal_model->get_select('pai_pais', array('pai_nombre', 'asc'), array('pai_estado' => 1));
            $data["sel_experiencia_laboral"] = $this->expediente_personal_model->get_select('exl_experiencia_laboral', array('exl_nombre', 'asc'), array('exl_estado' => 1));
            $select = $this->gsatelite->get_dropdown('hab_habilidad', '{hab_nombre}', '', array('hab_estado' => 1), null, '', 'hab_id', true);
            $data["habilidad"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            $select = $this->gsatelite->get_dropdown('nih_nivel_habilidad', '{nih_nombre}', '', array('nih_estado' => 1), null, '', 'nih_id', true);
            $data["nivel_habilidad"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            $data['habilidades_emple'] = $this->expediente_personal_model->get_habilidades_emp(array('hxm_id_emp'=>$emp_id));
            $data['agrupaciones_emple'] = $this->gsatelite->get_tabla('age_agrupacion_empleado',array('age_id_emp'=>$emp_id));
            $select = $this->gsatelite->get_dropdown('zon_zona', '{zon_nombre}', '', array('zon_estado' => 1), $registro->emp_id_zon, '', 'zon_id', true);
            $data["slcZona"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            $select = $this->gsatelite->get_dropdown('tiv_tipo_vivienda', '{tiv_nombre}', '', array('tiv_estado' => 1), $registro->emp_id_tiv, '', 'tiv_id', true);
            $data["slcTipoCasa"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            $select = $this->gsatelite->get_dropdown('tcv_tipo_construccion_vivienda', '{tcv_nombre}', '', array('tcv_estado' => 1), $registro->emp_id_tcv, '', 'tcv_id', true);
            $data["slcTipoConstruccion"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            $servicicios_emp  = array();
            $reg_srv = $this->gsatelite->get_tabla('sre_servicio_empleado',array('sre_id_emp'=>$emp_id));
            foreach ($reg_srv as $rs) {
                $servicicios_emp[]=$rs['sre_id_srb'];
            }
            $select = $this->gsatelite->get_dropdown('srb_servicio_basico', '{srb_nombre}', '', array('srb_estado' => 1), $servicicios_emp, '', 'srb_id', true);
            $data["slcServiciosBasicos"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            $reg_municipio = $this->gsatelite->get_tabla('mun_municipio',array('mun_id'=>$registro->emp_id_mun));
            $id_departamento =  ($reg_municipio)? $reg_municipio[0]['mun_id_dep']:null;
            $id_municipio =  ($reg_municipio)? $reg_municipio[0]['mun_id']:null;
            $select = $this->gsatelite->get_dropdown('dep_departamento', '{dep_nombre}', '', array('dep_estado' => 1), $id_departamento, '', 'dep_id', true);
            $data["slcDepartamento"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            $select = $this->gsatelite->get_dropdown('pai_pais', '{pai_nacionalidad}', '', array('pai_estado' => 1), $registro->emp_id_pai, '', 'pai_id', true);
            $data["slcNacionalidad"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            $select = $this->gsatelite->get_dropdown('mun_municipio', '{mun_nombre}', '', array('mun_estado' => 1, 'mun_id_dep' => $id_departamento), $id_municipio, '', 'mun_id', true);
            $data["slcMunicipio"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            $select = $this->gsatelite->get_dropdown('tps_tipo_salario', '{tps_nombre}', '', array('tps_estado' => 1), $registro->emp_id_tps, '', 'tps_id', true);
            $data["slcTipoSalario"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            $select = $this->gsatelite->get_dropdown('cta_categoria_aguinaldo', '{cta_nombre}', '', array('cta_estado' => 1), $registro->emp_id_cta, '', 'cta_id', true);
            $data["slcCatAguinaldo"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            $select = $this->gsatelite->get_dropdown('fnr_fuente_reclutamiento', '{fnr_nombre}', '', array('fnr_estado' => 1), $registro->emp_id_fnr, '', 'fnr_id', true);
            $data["slcFuenteReclutamiento"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            $select = $this->gsatelite->get_dropdown('tpc_tipo_cuenta', '{tpc_nombre}', '', array('tpc_estado' => 1), $registro->emp_id_tpc, '', 'tpc_id', true);
            $data["slcTipoCuenta"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            $select = $this->gsatelite->get_dropdown('gen_genero', '{gen_nombre}', '', array('gen_estado' => 1), $registro->emp_id_gen, '', 'gen_id', true);
            $data["genero"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);

            //Tab insumos
            $select = $this->gsatelite->get_dropdown('tim_tipo_insumo', '{tim_nombre}', '', array('tim_estado' => 1), null, '', 'tim_id', true);
            $data["slcTipoInsumo"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);

            //Tab capacitaciones            
            $select = $this->gsatelite->get_dropdown('icp_institucion_capacitacion', '{icp_nombre}', '', array('icp_estado' => 1), null, '', 'icp_id', true);
            $data["slcInstitucionCapacitacion"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);

            $select = $this->gsatelite->get_dropdown('ese_estado_estudio', '{ese_nombre}', '', array('ese_estado' => 1), null, '', 'ese_id', true);
            $data["slcEstadoEstudio"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            $data['ver_detalle']  = ($ver_detalle == null || $ver_detalle == 0) ? null : $ver_detalle;

            // Tipo entrevista
            $select = $this->gsatelite->get_dropdown('tnv_tipo_entrevista', '{tnv_nombre}', '', array('tnv_estado' => 1), null, '', 'tnv_id', true);
            $data["slc_entrevista"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);

            // Tipo prueba
            $select = $this->gsatelite->get_dropdown('tib_tipo_prueba', '{tib_nombre}', '', array('tib_estado' => 1), null, '', 'tib_id', true);
            $data["slc_pruebas"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);

            //////////////////////////////////////////////// ENTREVISTA ////////////////////////////////////////////////////////////////////////
            $this->db->join('tnv_tipo_entrevista', 'enm_id_tnv = tnv_id',"left");
            $data["entrevista_solicitante"] = $this->gsatelite->get_tabla('enm_entrevista_empleado', array('enm_id_emp'=>$emp_id));
            
            ////////////////////////////////////////////// PRUEBAS /////////////////////////////////////////////////////////////////////
            $this->db->join('tib_tipo_prueba', 'pbe_id_tib = tib_id',"left");
            $data["prueba_solicitante"] = $this->gsatelite->get_tabla('pbe_prueba_empleado', array('pbe_id_emp'=>$emp_id));

            if($informacion[0]['emp_codigo']!=''){
                $data['codigo'] = $informacion[0]['emp_codigo'];
            }else{
                $longitu = $this->gsatelite->get_parametro_emp('SYS_CODIGO_NUEVO_EMPLEADO', null, null, array('LONGITUD MINIMA'));
                if ( $longitu != 0 ){
                    $prefijo = $this->gsatelite->get_parametro_emp('SYS_CODIGO_NUEVO_EMPLEADO', null, null, array('PREFIJO CODIGO'));
                    $longitu = $this->gsatelite->get_parametro_emp('SYS_CODIGO_NUEVO_EMPLEADO', null, null, array('LONGITUD MINIMA'));
                    $last = $this->consultas->get_max_codigo('emp_empleado','emp_id');
                    $code = $last->codigo;
                    $cod = (float)$code + 1;
                    $codigo = $prefijo . str_pad($cod, $longitu, '0', STR_PAD_LEFT);
                    $data['codigo'] = $codigo;
                    // var_dump($codigo);
                    // die();
                } else {
                    $last=$this->consultas->get_max_codigo('emp_empleado','emp_codigo');
                    $code=$last->codigo;
                    $cod= (float)$code+1;
                    $codigo = str_pad($cod, 4, '0', STR_PAD_LEFT);
                    $data['codigo'] = $codigo;
                }
            }
            $dct = $this->input->get('dct');
            if ($dct == 1) {
                $data['dct'] = $dct;
                $titulo['titulo_personal'] = "Editar Docente";
            } else {
                $titulo['titulo_personal'] = "Editar Empleada/o";
            }
            // $titulo['titulo_personal'] = "Gestión de empleados";
            $prox_vac = null;
            if ($informacion[0]['emp_fecha_ult_vacacion']!='') {//Fecha insertada menos 365 dias como ultima Vacacion
                $antigua = formatear_fecha('Y-m-d', $informacion[0]['emp_fecha_ult_vacacion']);
                $antigua = strtotime($antigua);
                $actual = strtotime('+365 day', $antigua);
                $prox_vac =  date('Y-m-d', $antigua);// $actual);//SAT_7003 se respetara fecha ingresada
            }
            $data['prox_vac'] = $prox_vac;
            if ($ver_detalle == 1) {
                $titulo['titulo_personal'] = "Ver Datos de Empleada/o";
                cargarvista($titulo, $data, 'expediente_personal/empleado/ver_empleado');
            } else {
                cargarvista($titulo, $data, 'expediente_personal/empleado/editar_empleado');
            }            
        }
    }

    function nuevo_empleado() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            // var_dump($_POST);die();
            $cod_post = trim($this->input->post('codigo_emp'));
            $reg_cod = $this->gsatelite->get_registro('emp_empleado', array('emp_codigo'=>$cod_post));
            if(count($reg_cod)>0){
                $longitu = $this->gsatelite->get_parametro_emp('SYS_CODIGO_NUEVO_EMPLEADO', null, null, array('LONGITUD MINIMA'));
                if ( $longitu != 0 ){
                    $prefijo = $this->gsatelite->get_parametro_emp('SYS_CODIGO_NUEVO_EMPLEADO', null, null, array('PREFIJO CODIGO'));
                    $longitu = $this->gsatelite->get_parametro_emp('SYS_CODIGO_NUEVO_EMPLEADO', null, null, array('LONGITUD MINIMA'));
                    $last = $this->consultas->get_max_codigo('emp_empleado','emp_id');
                    $code = $last->codigo;
                    $cod = (float)$code + 1;
                    $codigo = $prefijo . str_pad($cod, $longitu, '0', STR_PAD_LEFT);
                    $data['codigo'] = $codigo;
                    // var_dump($codigo);
                    // die();
                } else {
                    $last=$this->consultas->get_max_codigo('emp_empleado','emp_codigo');
                    $code=$last->codigo;
                    $cod= (float)$code+1;
                    $codigo = str_pad($cod, 4, '0', STR_PAD_LEFT);
                    $data['codigo'] = $codigo;
                }
            }else{
                $codigo = $cod_post;
            }
            if ($this->input->post("fecha_prox_vac")!='') {//Fecha insertada menos 365 dias como ultima Vacacion
                $actual   =  strtotime($this->input->post("fecha_prox_vac"));
                $anterior =  strtotime('-365 day', $actual);
                $fecha_anterior =  date('d-m-Y', $actual);// $anterior); //SAT_7003 se respetara fecha ingresada
            }            
            $nuevo = array(
                'emp_id_suc'    => ($this->input->post('sucursal') > 0) ? $this->input->post('sucursal') : null,
                'emp_id_plz'    => ($this->input->post('puesto') > 0) ? $this->input->post('puesto') : null,
                'emp_id_afp'    => ($this->input->post('afp') > 0 ) ? $this->input->post('afp') : null,
                'emp_id_emr'    => $this->tank_auth->get_empresa_id(), //id de empresa added by René Castaneda
                'emp_nombre'    => $this->input->post('nombres'),
                'emp_apellido'  => $this->input->post('apellidos'),
                'emp_estado'    => 1,
                'emp_direccion' => $this->input->post('direccion'),
                'emp_id_are'    => ($this->input->post('departamento') > 0) ? $this->input->post('departamento') : null,
                'emp_lugar_nac' => $this->input->post('lugar_nacimiento'),
                //'emp_id_pai'  => ($this->input->post('nacionalidad') != "") ? $this->input->post('nacionalidad') : null,
                'emp_fecha_nac' => formatear_fecha('Y-m-d', $this->input->post('fecha_nacimiento')),
                'emp_id_gen'    => ($this->input->post('genero') != "") ? $this->input->post('genero') : null,
                'emp_id_cnt'    => ($this->input->post('slcCuentaCont') > 0) ? $this->input->post('slcCuentaCont') : null,
                'emp_id_pro'    => ($this->input->post('profesion') != "") ? $this->input->post('profesion') : null,
                'emp_id_esc'    => ($this->input->post('estado_civil') != "") ? $this->input->post('estado_civil') : null,
                'emp_fecha_contrato' => formatear_fecha('Y-m-d', $this->input->post('fecha_contratacion')),
                'emp_fecha_retiro'  => null, //$this->input->post(''),
                'emp_salario'       => ($this->input->post('salario') != "") ? $this->input->post('salario') : 0,
                'emp_salario_hora'  => ($this->input->post('salario_hora') != "") ? $this->input->post('salario_hora') : null,
                'emp_salario_hora_nocturna' => ($this->input->post('salario_hora_noc') != "") ? $this->input->post('salario_hora_noc') : null,//Horas extras fijas
                'emp_metodo_pago'   => ($this->input->post('forma_pago_salario') > 0) ? $this->input->post('forma_pago_salario') : 0,
                'emp_usu_mod'       => $this->tank_auth->get_user_id(),
                'emp_fecha_mod'     => date('Y-m-d H:i:s'),
                'emp_usu_crea'      => $this->tank_auth->get_user_id(),
                'emp_fecha_crea'    => date('Y-m-d H:i:s'),
                'emp_codigo'        => $codigo,
                'emp_afp'           => $this->input->post('num_afp'),
                'emp_seguro'        => $this->input->post('num_seg'),
                'emp_id_ban'        => ($this->input->post('banco') != "") ? $this->input->post('banco') : null,
                'emp_numero_cuenta' => $this->input->post('cuenta_banco'),
                'emp_observacion_contrato' => trim($this->input->post('observacion_contratacion')),
                'emp_id_tic'        => ($this->input->post('tipo_contrato_empleado') != "") ? $this->input->post('tipo_contrato_empleado') : null,
                //'emp_color_icono' => strtoupper($this->input->post('color_emp')),
                'emp_id_pat_contacto' => ($this->input->post("contact_parentesco") != "") ? $this->input->post("contact_parentesco") : null, //id_parentesco
                'emp_estatura'      => ($this->input->post("enf_estatura") != "") ? $this->input->post("enf_estatura") : null,
                'emp_peso'          => ($this->input->post("enf_peso") != "") ? $this->input->post("enf_peso") : null,
                'emp_licencia_profesional' => trim($this->input->post("licencia_prof")),
                'emp_id_tsr'        => ($this->input->post("slcTipoSangre") > 0)? $this->input->post("slcTipoSangre"):null,
                'emp_discapacidad'  => $this->input->post("enf_discapacidad"),
                'emp_id_tds'        => ($this->input->post("enf_discapacidad") == 1 && $this->input->post("slcTipoDiscapacidad") > 0 )? $this->input->post("slcTipoDiscapacidad"):null,
                'emp_observacion_clinica' => $this->input->post("enf_observacion"),
                'emp_contacto_emergencia' => $this->input->post("contact_a"),
                'emp_direccion_emergencia' => $this->input->post("contact_direccion"),
                'emp_telefono_emergencia' => $this->input->post("contact_telefono"),
                'emp_id_zon'        => ($this->input->post("slcZona") > 0)? $this->input->post("slcZona"):null,
                'emp_id_tiv'        => ($this->input->post("slcTipoCasa") > 0)? $this->input->post("slcTipoCasa"):null,
                'emp_id_tcv'        => ($this->input->post("slcTipoConstruccion") > 0)? $this->input->post("slcTipoConstruccion"):null,
                'emp_expediente'    => (trim($this->input->post("expediente_emp")) !='')? trim($this->input->post("expediente_emp")):null,
                'emp_id_mun'        => ($this->input->post("slcMunicipio") > 0)? $this->input->post("slcMunicipio"):null,
                'emp_id_pai'        => ($this->input->post("slcNacionalidad") > 0)? $this->input->post("slcNacionalidad"):null,
                'emp_es_reingreso'  => ($this->input->post("ckcReingreso") > 0)? 1:0,
                'emp_es_jubilado'   => ($this->input->post("ckcJubilado") > 0)? 1:0,
                'emp_fecha_jubilado' => ($this->input->post("txtFechaJubilacion") !='' )? formatear_fecha('Y-m-d', $this->input->post('txtFechaJubilacion')):null,
                'emp_id_tps' => ($this->input->post("slcTipoSalario") > 0)? $this->input->post("slcTipoSalario"):null,
                'emp_id_cta' => ($this->input->post("slcCatAguinaldo") > 0)? $this->input->post("slcCatAguinaldo"):null,
                'emp_id_fnr' => ($this->input->post("slcFuenteReclutamiento") > 0)? $this->input->post("slcFuenteReclutamiento"):null,
                'emp_realizo_poligrafo' => ($this->input->post("ckcRealizaPoligrafo") > 0)? 1:0,
                'emp_codigo_referencia' => (trim($this->input->post("codigo_referencia")) !='')? trim($this->input->post("codigo_referencia")):null,
                'emp_id_tpc'        => ($this->input->post("slcTipoCuenta") > 0)? $this->input->post("slcTipoCuenta"):null,
                'emp_aplica_afp'    => ($this->input->post("ckcAplicaAfp") > 0)? 1:0,
                'emp_aplica_renta'  => ($this->input->post("ckcAplicaRenta") > 0)? 1:0,
                'emp_tipo_isr_aplica' => ($this->input->post("forma_renta") > 0)? 1:0,
                'emp_aplica_isss'   => ($this->input->post("ckcAplicaIsss") > 0)? 1:0,
                'emp_disponibilidad_viajar' => ($this->input->post("disponible_viajar") > 0) ? 1 : 0,
                'emp_fecha_ult_liquidacion' => ($this->input->post("fecha_ult_liquidacion") !='' )? formatear_fecha('Y-m-d', $this->input->post('fecha_ult_liquidacion')):null,
                'emp_fecha_fin_contrato' => ($this->input->post("fecha_fin_contrato") !='' )? formatear_fecha('Y-m-d', $this->input->post('fecha_fin_contrato')):null,
                'emp_fecha_antiguedad' => ($this->input->post("fecha_antiguedad") !='' )? formatear_fecha('Y-m-d', $this->input->post('fecha_antiguedad')):null,
                'emp_fecha_ult_aguinaldo'=> ($this->input->post("fecha_ult_aguinaldo") !='' )? formatear_fecha('Y-m-d', $this->input->post('fecha_ult_aguinaldo')):null,
                'emp_fecha_ult_vacacion'=> ($this->input->post("fecha_prox_vac") !='' )? formatear_fecha('Y-m-d', $fecha_anterior):null,
                'emp_fecha_poligrafo' => ($this->input->post("txtFecha_poligrafo") !='' )? formatear_fecha('Y-m-d', $this->input->post('txtFecha_poligrafo')):null,
                'emp_fecha_prox_poligrafo' => ($this->input->post("txtFecha_prox_poligrafo") !='' )? formatear_fecha('Y-m-d', $this->input->post('txtFecha_prox_poligrafo')):null,
                'emp_doc_bancario' => ($this->input->post("slcDocBac") != '') ? $this->input->post('slcDocBac') : null,
                'emp_id_sin' => ($this->input->post("slcSindicato") != '') ? $this->input->post("slcSindicato") : null,
                'emp_acumula_permisos' => ($this->input->post("acumula_dias_permisos") != '') ? $this->input->post("acumula_dias_permisos") : null
            );
            $this->db->insert('emp_empleado', $nuevo);
            $emp_id = $this->db->insert_id();

            /************Ingresar en la tabla promocion_plaza_salarioxemp*********************/
            if($this->input->post('puesto') > 0){
                $newarea = $this->gsatelite->get_campo('plz_plaza', 'plz_id_are', array('plz_id' => $this->input->post('puesto')));
                $this->db->insert('pps_promocion_plaza_salarioxemp', array('pps_id_plz' => $this->input->post('puesto'),
                            'pps_id_emp' => $emp_id,
                            'pps_id_are' => ($newarea > 0) ? $newarea : null,
                            'pps_id_emr' => $this->tank_auth->get_empresa_id(),
                            'pps_tipo' => 0,
                            'pps_salario' => ($this->input->post('salario') != "") ? $this->input->post('salario') : 0,
                            'pps_fecha_efectiva' => formatear_fecha('Y-m-d', $this->input->post('fecha_contratacion')),
                            'pps_fecha_desde' => formatear_fecha('Y-m-d', $this->input->post('fecha_contratacion')),                        
                            'pps_fecha_hasta' => null,                        
                            'pps_estado' => 1,
                            'pps_usu_creacion' => $this->tank_auth->get_user_id(),
                            'pps_fecha_creacion' => date('Y-m-d H:i:s'),
                            'pps_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'pps_fecha_modificacion' => date('Y-m-d H:i:s')
                        ));
            }
            /*****************************************************/
            $tseg = $this->input->post('tipo_seguro');
            for ($i = 0; $i < count($tseg); $i++) {
                if ($tseg[$i] != null) {
                    $this->db->insert('sxe_seguroxempleado', array('sxe_id_seg' => $tseg[$i],
                        'sxe_id_emp' => $emp_id,
                        'sxe_estado' => 1,
                        'sxe_usu_mod' => $this->tank_auth->get_user_id(),
                        'sxe_fecha_mod' => date('Y-m-d H:i:s')
                    ));
                }
            }
            $tpl = $this->input->post('tipo_contrato');
            if (is_array($tpl) && count($tpl) > 0 ) {
                for ($i = 0; $i < count($tpl); $i++) {
                    if ($tpl[$i] != null && $tpl[$i] > 0 ) {
                        $this->db->insert('txe_tipo_planillaxempleado', array('txe_id_tpl' => $tpl[$i], 'txe_id_emp' => $emp_id));
                    }
                }
            }
            $correos = $this->input->post('correo_empleado');
            $tipo_correo_empleado =  $this->input->post('tipo_correo_empleado');
            for ($i = 0; $i < count($correos); $i++) {
                if ($correos[$i] != null and trim($correos[$i]) != '') {
                    $this->db->insert('cxp_correoxempleado', array('cxp_id_emp' => $emp_id,
                        'cxp_correo' => $correos[$i],
                        'cxp_tipo_correo_empleado' => $tipo_correo_empleado[$i],
                        'cxp_estado' => 1,
                        'cxp_usu_mod' => $this->tank_auth->get_user_id(),
                        'cxp_fecha_mod' => date('Y-m-d H:i:s')
                    ));
                }
            }
            /* =================================================================================================================
              =									TELEFONOS
              ===================================================================================================================
             */
            $array = $this->input->post('numeros_telefons');
            $array_tit = $this->input->post('tipos_telefons');

            for ($x = 0; $x < count($array); $x++) {
                if ($array[$x] != "" && trim($array_tit[$x]) != "") {
                    $this->db->insert('tel_telefono', array(
                        'tel_numero' => $array[$x],
                        'tel_id_tit' => $array_tit[$x],
                        'tel_estado' => 1,
                        'tel_usu_crea' => $this->tank_auth->get_user_id(),
                        'tel_usu_mod' => $this->tank_auth->get_user_id(),
                        'tel_fecha_crea' => date('Y-m-d H:i:s'),
                        'tel_fecha_mod' => date('Y-m-d H:i:s')
                    ));
                    $tel_id = $this->db->insert_id();
                    $this->db->insert('txm_telefonoxempleado', array(
                        'txm_id_tel' => $tel_id,
                        'txm_id_emp' => $emp_id
                    ));
                }
            }

            /* ==================================================================================
              =						ENFERMEDADES
              ====================================================================================
             */
            $enf_alergia = $this->input->post("enf_alergia"); //id_cos_componente
            $enf_tipo = $this->input->post("enf_tipo"); //id_enf_enfermedad
            $med_perm = $this->input->post("perm_drugs"); //lista de medicinas
            foreach ($enf_tipo as $key) {
                if (trim($key) != "") {
                    $this->db->insert('exe_enfermedadxempleado', array(
                        'exe_id_enf' => $key,
                        'exe_id_emp' => $emp_id,
                        'exe_estado' => 1,
                        'exe_fecha_creacion' => date('Y-m-d H:i:s'),
                        'exe_usu_creacion' => $this->tank_auth->get_user_id(),
                        'exe_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'exe_fecha_modificacion' => date('Y-m-d H:i:s')
                    ));
                }
            }
            foreach ($enf_alergia as $key) {
                if (trim($key) != "") {
                    $this->db->insert('cae_componente_alergico_empleado', array(
                        'cae_id_coa' => $key,
                        'cae_id_emp' => $emp_id,
                        'cae_estado' => 1,
                        'cae_fecha_creacion' => date('Y-m-d H:i:s'),
                        'cae_usu_creacion' => $this->tank_auth->get_user_id(),
                        'cae_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'cae_fecha_modificacion' => date('Y-m-d H:i:s')
                    ));
                }
            }
            foreach ($med_perm as $val) {
                if (trim($val) != "") {
                    $this->db->insert('mxe_medicamento_x_empleado', array(
                        'mxe_id_emp' => $emp_id,
                        'mxe_nombre_medicamento' => trim($val),
                        'mxe_estado' => 1,
                        'mxe_usu_crea' => $this->tank_auth->get_user_id(),
                        'mxe_fecha_crea' => date('Y-m-d H:i:s'),
                        'mxe_usu_modifica' => $this->tank_auth->get_user_id(),
                        'mxe_fecha_modifica' => date('Y-m-d H:i:s')
                    ));
                }
            }

            $array2 = $this->input->post('numero_documento');
            //$ver2= array_pop($array2);
            $array2_1 = $this->input->post('documento');
            //$ver2_1 = array_pop($array2_1);
            $array_vence_doc = $this->input->post('vence_documento');
            $array_titulo_anexo = $this->input->post('titulo_anexo_doc');
            $array_nombre_anex = $this->input->post('nombre_anexo_doc');
            $carpeta = $this->input->post("nombre_anexo_carpeta");
            // $carpeta = 'archivos';
            // var_dump($carpeta);die();

            $array_fexp_doc = $this->input->post('fecha_exp_doc');
            /* $array_lugarexp_doc = $this->input->post('lugar_
              $titulo_a = trim($array_titulo_anexo[$i]);
              $url_anexo="";exp_doc'); */
            $array_lugarexp_doc = $this->input->post('lugar_exp_doc');
            $array_munexp_doc = $this->input->post('mun_exp');
            $array_nombre_segun_doc = $this->input->post('nombre_segun_doc');
            $array_observacion_doc = $this->input->post('observacion_doc');
            $i = 0;
            foreach ($array2 as $key => $value2) {

                $f_vence = (trim($array_vence_doc[$i]) != "" and $array_vence_doc[$i] != null ) ? date('Y-m-d', strtotime(trim($array_vence_doc[$i]))) : null;
                $f_exp = (trim($array_fexp_doc[$i]) != "" and $array_fexp_doc[$i] != null ) ? date('Y-m-d', strtotime(trim($array_fexp_doc[$i]))) : null;
                //Se obtiene el titulo del anexo
                $titulo_a = trim($array_titulo_anexo[$i]);
                // Se agrego para la duplicidad de un empleado inactivo (solo copiara la ruta, no duplicara archivo)
                $array_nombre_anexo = $array_nombre_anex[$i];
                if (empty($titulo_a)) {
                    $url_anexo = "";
                } else {
                    $url_anexo = $array_nombre_anexo;
                }
                

                if ($titulo_a != "" && $url_anexo == "") {
                    $tUnico = time();
                    $extencion = end(explode(".", $array_nombre_anexo[$i]));
                    //$url_anexo= "uploads/anexos_empleados/".trim($array_titulo_anexo[$i]).".".trim($extencion);
                    $url_anexo = clean_string(trim($array_titulo_anexo[$i])) . $tUnico . "." . trim($extencion); //se modifico de esta manera porque se uso grocery para su edicion.
                    
                    $this->datos_anexo_documento(trim($array_nombre_anexo[$i]), $carpeta, $titulo_a, $url_anexo); //funcion para guardar el anexo
                }
                // var_dump($url_anexo);die();

                $this->db->insert('dce_documento_emp', array(
                    'dce_id_tde' => $array2_1[$i],
                    'dce_id_emp' => $emp_id,
                    'dce_valor' => $value2,
                    'dce_fecha_registro' => date('Y-m-d'),
                    'dce_fecha_vence' => $f_vence,
                    'dce_fecha_expedicion' => $f_exp,
                    'dce_lugar_expedicion' => trim($array_lugarexp_doc[$i]),
                    'dce_id_mun' => (trim($array_munexp_doc[$i]) != '')?trim($array_munexp_doc[$i]):NULL,
                    'dce_nombre_segun_doc' => trim($array_nombre_segun_doc[$i]),
                    'dce_observacion' => trim($array_observacion_doc[$i]),
                    'dce_nombre_anexo' => $titulo_a,
                    'dce_url' => $url_anexo,
                    'dce_estado' => 1,
                    'dce_usu_creacion' => $this->tank_auth->get_user_id(),
                    'dce_fecha_creacion' => date('Y-m-d H:i:s'),
                    'dce_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'dce_fecha_modificacion' => date('Y-m-d H:i:s')
                ));
                //	$dce_id= $this->db->insert_id();
                //	$this->db->where('dce_id',$dce_id);
                //	$this->db->update('dce_documento_emp',array('dce_id_tde' => $array2_1[$i]));
                $i++;
            }

            /* =================================================================================================================
              =									PROGRAMA Y EQUIPOS
              ===================================================================================================================
             */

            $array6 = $this->input->post('tipo_program');
            $array6_1 = $this->input->post('nivel_program');

            $i = 0;
            foreach ($array6 as $key => $value4) {
                if (trim($value4) != "" && trim($array6_1[$i]) != "")
                    $this->db->insert('pxe_programaxempleado', array(
                        'pxe_id_peq' => $value4,
                        'pxe_id_emp' => $emp_id,
                        'pxe_id_nie' => $array6_1[$i],
                        'pxe_estado' => 1,
                        'pxe_fecha_creacion' => date('Y-m-d H:i:s'),
                        'pxe_usu_creacion' => $this->tank_auth->get_user_id(),
                        'pxe_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'pxe_fecha_modificacion' => date('Y-m-d H:i:s')
                    ));
                $i++;
            }

            $array7 = $this->input->post('program_cer');
            $array7_1 = $this->input->post('tipo_program_cer');
            $array7_2 = $this->input->post('program_puntaje_cert');
            $array7_3 = $this->input->post('program_fecha_cert');
            $array7_4 = $this->input->post('program_institucion_cert');
            $array7_5 = $this->input->post('program_modalidad_cert');
            // var_dump((trim($array7_2[$i]) != "") ? $array7_2[$i] : null);
            // var_dump((trim($array7_5[$i]) != "") ? $array7_5[$i] : null);
            // var_dump((trim($array7_4[$i]) != "") ? $array7_4[$i] : null);
            // var_dump((trim($array7_3[$i]) != "") ? date('Y-m-d', strtotime($array7_3[$i])) : null);
            
            
            // die();
            $i = 0;
            foreach ($array7 as $key => $value5) {
                if (trim($value5) != "" && trim($array7_1[$i]) != "") {
                    $this->db->insert('cep_certificacion_programa', array(
                        'cep_id_emp' => $emp_id,
                        'cep_id_cer' => $array7_1[$i],
                        'cep_id_peq' => $value5,
                        'cep_puntaje' => (trim($array7_2[$i]) != "") ? $array7_2[$i] : null,
                        'cep_id_mde'  => (trim($array7_5[$i]) != "") ? $array7_5[$i] : null,
                        'cep_id_icp'  => (trim($array7_4[$i]) != "") ? $array7_4[$i] : null,
                        'cep_fecha_certificacion' => (trim($array7_3[$i]) != "") ? date('Y-m-d', strtotime($array7_3[$i])) : null,
                        'cep_estado' => 1,
                        'cep_usu_creacion' => $this->tank_auth->get_user_id(),
                        'cep_fecha_creacion' => date('Y-m-d H:i:s'),
                        'cep_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'cep_fecha_modificacion' => date('Y-m-d H:i:s')
                    ));
                    // var_dump($this->db->last_query());die();
                }
                $i++;
            }


            /* =================================================================================================================
              =									DATOS FAMILIARES
              ===================================================================================================================
             */
            $array3 = $this->input->post('nombres_familiares');
            $array3_1 = $this->input->post('apellidos_familiares');
            $array3_2 = $this->input->post('parentesco_familiares');
            $array3_3 = $this->input->post('telefono_familiares');
            $array3_4 = $this->input->post('fechas_familiares');
            $array3_5 = $this->input->post('dependencia_familiares');
            $array3_6 = $this->input->post('institucion_familiares');
            $array3_7 = $this->input->post('id_empleado_familiares');
            $array3_8 = $this->input->post('reside_con_empleado_familiares');
            $array3_9 = $this->input->post('beneficiario_familiares');
            $array3_10 = $this->input->post('beneficia_porcentaje_familiares');
            $i = 0;
            foreach ($array3 as $key => $value3) {
                /*print_r($array3_3);die();*/
                if (trim($value3) != "" && trim($array3_1[$i]) != "" && trim($array3_2[$i]) != "" && trim($array3_5[$i]) != "") 
                {
                    $query = array(
                        'fam_nombre' => $value3,
                        'fam_apellido' => $array3_1[$i],
                        'fam_fecha_nacimiento' => (trim($array3_4[$i]) != "") ? date('Y-m-d', strtotime($array3_4[$i])) : null,
                        'fam_dependiente' => $array3_5[$i],
                        'fam_empresa' => (is_numeric($array3_6[$i]))? $array3_6[$i]:null, //si familia en institucion
                        'fam_estado' => 1,
                        'fam_id_pat' => $array3_2[$i],
                        'fam_id_emp' => $emp_id,
                        'fam_id_emp_familiar' => ($array3_7[$i]) ? $array3_7[$i] : null,
                        'fam_reside_empleado' => ($array3_8[$i] !='')?$array3_8[$i]:null,
                        'fam_beneficiario' =>  ($array3_9[$i] >0)?$array3_9[$i]:0,
                        'fam_porcentaje_beneficio' =>  ($array3_10[$i] != '')?$array3_10[$i]:NULL,
                        'fam_telefono' => $array3_3[$i],
                        'fam_usu_crea' => $this->tank_auth->get_user_id(),
                        'fam_fecha_crea' => date('Y-m-d H:i:s'),
                        'fam_usu_mod' => $this->tank_auth->get_user_id(),
                        'fam_fecha_mod' => date('Y-m-d H:i:s'));
                    $result = $this->db->insert('fam_familiar',$query);
                    /*print_r($result);die();*/
                }
                $i++;
            }

            /* =================================================================================================================
              =									DATOS DE IDIOMAS
              ===================================================================================================================
             */
            $array4 = $this->input->post('idioma');
            $array4_1 = $this->input->post('nivel');
            $array4_2 = $this->input->post('leer');
            $array4_3 = $this->input->post('escribir');
            $array4_4 = $this->input->post('hablar');
            $array4_5 = $this->input->post('traductor');
            for ($x = 0; $x < count($array4); $x++) {
                if ($array4[$x] != "" && $array4_1[$x] != "") {
                    $this->db->insert('iem_idioma_empleado', array(
                        'iem_id_nii' => $array4_1[$x],
                        'iem_id_idm' => $array4[$x],
                        'iem_id_emp' => $emp_id,
                        'iem_leer' => ($array4_2[$x] != "") ? $array4_2[$x] : 0,
                        'iem_escribir' => ($array4_3[$x] != "") ? $array4_3[$x] : 0,
                        'iem_hablar' => ($array4_4[$x] != "") ? $array4_4[$x] : 0,
                        'iem_traductor' => ($array4_5[$x] != "") ? $array4_5[$x] : 0,
                        'iem_estado' => 1,
                        'iem_usu_creacion' => $this->tank_auth->get_user_id(),
                        'iem_fecha_creacion' => date('Y-m-d H:i:s'),
                        'iem_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'iem_fecha_modificacion' => date('Y-m-d H:i:s')));
                }
            }

            /* =================================================================================================================
              =									CERTIFICADOS DE IDIOMAS
              ===================================================================================================================
             */
            $array5 = $this->input->post('idioma_cert');
            $array5_1 = $this->input->post('tipo_cert');
            $array5_2 = $this->input->post('puntaje_cert');
            $array5_3 = $this->input->post('fecha_cert');
            for ($x = 0; $x < count($array5); $x++) {
                if ($array5[$x] != "" && $array5_1[$x] != "" && $array5_2[$x] != "" && $array5_3[$x] != "") {
                    $this->db->insert('cri_certificacion_idioma', array(
                        'cri_id_emp' => $emp_id,
                        'cri_id_cer' => $array5_1[$x],
                        'cri_id_idm' => $array5[$x],
                        'cri_puntaje' => $array5_2[$x],
                        'cri_fecha_certificacion' => (trim($array5_3[$x]) != "") ? date('Y-m-d', strtotime($array5_3[$x])) : null,
                        'cri_estado' => 1,
                        'cri_usu_creacion' => $this->tank_auth->get_user_id(),
                        'cri_fecha_creacion' => date('Y-m-d H:i:s'),
                        'cri_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'cri_fecha_modificacion' => date('Y-m-d H:i:s')));
                }
            }

            /* =================================================================================================================
              =									REFERENCIAS PERSONALES
              ===================================================================================================================
             */
            $array8 = $this->input->post('tipo_refpersonal');
            $array8_1 = $this->input->post('nombre_refpersonal');
            $array8_2 = $this->input->post('ltrabajo_refpersonal');
            $array8_3 = $this->input->post('ocupacion_refpersonal');
            $array8_4 = $this->input->post('telefono_refpersonal');
            $array8_5 = $this->input->post('referencia_refpersonal');

            for ($x = 0; $x < count($array8); $x++) {
                if ($array8[$x] != "" && $array8_1[$x] != "" && $array8_2[$x] != "" && $array8_4[$x] != "") {
                    $this->db->insert('rfp_referencia_personal', array(
                        'rfp_id_trr' => $array8[$x],
                        'rfp_id_emp' => $emp_id,
                        'rfp_nombre' => $array8_1[$x],
                        'rfp_lugar_trabajo' => $array8_2[$x],
                        'rfp_ocupacion' => (trim($array8_3[$x]) != "") ? $array8_3[$x] : null,
                        'rfp_telefono' => $array8_4[$x],
                        'rfp_descripcion_referencia' => (trim($array8_5[$x]) != '')? $array8_5[$x]:null,
                        'rfp_estado' => 1,
                        'rfp_fecha_creacion' => date('Y-m-d H:i:s'),
                        'rfp_usu_creacion' => $this->tank_auth->get_user_id(),
                        'rfp_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'rfp_fecha_modificacion' => date('Y-m-d H:i:s')
                    ));
                }
            }

            /* =================================================================================================================
              =									REFERENCIAS LABORALES
              ===================================================================================================================
             */
            $array9 = $this->input->post('lugar_tra_reflab');
            $array9_1 = $this->input->post('direccion_reflab');
            $array9_2 = $this->input->post('telefono_reflab');
            $array9_3 = $this->input->post('puesto_reflab');
            $array9_4 = $this->input->post('jefe_inmediato_reflab');
            $array9_5 = $this->input->post('salario_deven_reflab');
            $array9_6 = $this->input->post('mot_retiro_reflab');

            $array9_7 = $this->input->post('nombre_referencia_reflab');
            $array9_8 = $this->input->post('desde_reflab');
            $array9_9 = $this->input->post('hasta_reflab');
            $array9_10 = $this->input->post('referencia_reflab');

            for ($x = 0; $x < count($array9); $x++) {
                if ($array9[$x] != "" && $array9_1[$x] != "" && $array9_3[$x] != "") {
                    $this->db->insert('rfl_referencia_laboral', array(
                        'rfl_id_emp' => $emp_id,
                        'rfl_lugar_trabajo' => $array9[$x],
                        'rfl_direccion' => $array9_1[$x],
                        'rfl_telefono' => $array9_2[$x],
                        'rfl_puesto' => $array9_3[$x],
                        'rfl_jefe' => $array9_4[$x],
                        'rfl_salario_devengado' => ($array9_5[$x] != '')?$array9_5[$x]:NULL,
                        'rfl_motivo_retiro' => $array9_6[$x],
                        'rfl_nombre_ref' => $array9_7[$x],
                        'rfl_fecha_desde' => (trim($array9_8[$x]) != '')? formatear_fecha('Y-m-d',$array9_8[$x]):null,
                        'rfl_fecha_hasta' => (trim($array9_9[$x]) != '')? formatear_fecha('Y-m-d',$array9_9[$x]):null,
                        'rfl_referencia' => $array9_10[$x],
                        'rfl_estado' => 1,
                        'rfl_fecha_creacion' => date('Y-m-d H:i:s'),
                        'rfl_usu_creacion' => $this->tank_auth->get_user_id(),
                        'rfl_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'rfl_fecha_modificacion' => date('Y-m-d H:i:s')
                    ));
                }
            }


            /* =================================================================================================================
              =									DATOS ACADEMICOS
              ===================================================================================================================
             */
            $array10 = $this->input->post('tipo_datacademicos');
            $array10_1 = $this->input->post('profesion_datacademicos');
            $array10_2 = $this->input->post('institucion_datacademicos');
            $array10_3 = $this->input->post('estestudio_datacademicos');
            $array10_4 = $this->input->post('pais_datacademicos');
            $array10_5 = $this->input->post('explaboral_datacademicos');
            $array10_6 = $this->input->post('fecha_datacademicos');
            $array10_7 = $this->input->post('observacion_datacademicos');

            $array10_8 = $this->input->post('anios_cursado_estudio_datacademicos');

            foreach ($array10 as $key => $value) {
                if ($array10[$key] > 0/*  && $array10_3[$key] != "" && $array10_4[$key] != "" && $array10_5[$key]*/) {
                    $this->db->insert('dac_dato_academico', array(
                        'dac_id_pai' => ($array10_4[$key] > 0)? $array10_4[$key]:null,
                        'dac_id_tie' => $array10[$key],
                        'dac_id_pro' => ($array10_1[$key] > 0)? $array10_1[$key]:null,
                        'dac_id_ese' => ($array10_3[$key] > 0)? $array10_3[$key]:null,
                        'dac_id_emp' => $emp_id,
                        'dac_id_exl' => ($array10_5[$key]  > 0) ? $array10_5[$key] : null,
                        'dac_id_ina' => ($array10_2[$key]) ? $array10_2[$key] : null,
                        'dac_fecha_finalizacion' => (trim($array10_6[$key]) != "") ? formatear_fecha('Y-m-d', $array10_6[$key]) : null,
                        'dac_observacion' => $array10_7[$key],
                        'dac_anios_cursado' => ($array10_8[$key] > 0)? $array10_8[$key]:null,
                        'dac_estado' => 1,
                        'dac_fecha_creacion' => date('Y-m-d H:i:s'),
                        'dac_usu_creacion' => $this->tank_auth->get_user_id(),
                        'dac_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'dac_fecha_modificacion' => date('Y-m-d H:i:s')
                    ));
                }
            }



            /* =================================================================================================================
              =                              INICIO GUARDADO DE HABILIDADES EMPLEADO
              ===================================================================================================================
             */
            $hablidad_empleado = $this->input->post('hablidad_empleado');
            $nivel_hablidad_empleado = $this->input->post('nivel_hablidad_empleado');

            for ($hab_emp=0; $hab_emp < count($hablidad_empleado) ; $hab_emp++) { 
                if ($hablidad_empleado[$hab_emp] > 0) {
                   $array_insert_reg = array(
                    'hxm_id_hab' => $hablidad_empleado[$hab_emp],
                    'hxm_id_emp' => $emp_id,
                    'hxm_id_nih' => ($nivel_hablidad_empleado[$hab_emp] > 0)? $nivel_hablidad_empleado[$hab_emp]:null,
                    'hxm_estado' => 1,
                    'hxm_usu_creacion' => $this->tank_auth->get_user_id(),
                    'hxm_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'hxm_fecha_creacion' => date('Y-m-d H:i:s'),
                    'hxm_fecha_modificacion' => date('Y-m-d H:i:s')
                   );

                   $id_hxm = $this->gsatelite->ingresar('hxm_habilidadxempleado', $array_insert_reg);
                }
            }

            /* =================================================================================================================
              =                              FIN GUARDADO DE HABILIDADES EMPLEADO
              ===================================================================================================================
             */

            /* =================================================================================================================
            =                              INICIO GUARDADO DE AGRUPACIONES EMPLEADO
            ===================================================================================================================
            */
              $agrupacion_emp = $this->input->post('agrupacion_emp');
              $anio_afiliacion = $this->input->post('anio_afiliacion');
              $estado_afiliacion = $this->input->post('estado_afiliacion');

              for ($agru_emp=0; $agru_emp < count($agrupacion_emp) ; $agru_emp++) { 
                  if (trim($agrupacion_emp[$agru_emp]) != '') {
                     $array_insert_reg = array(
                      'age_nombre' => $agrupacion_emp[$agru_emp],
                      'age_anio_afiliacion' => ($anio_afiliacion[$agru_emp] >0)? $anio_afiliacion[$agru_emp]:null,
                      'age_estado_agrupacion' => ($estado_afiliacion[$agru_emp] >0)? 1:0,
                      'age_id_emp' => $emp_id,
                      'age_estado' => 1,
                      'age_usu_creacion' => $this->tank_auth->get_user_id(),
                      'age_usu_modificacion' => $this->tank_auth->get_user_id(),
                      'age_fecha_creacion' => date('Y-m-d H:i:s'),
                      'age_fecha_modificacion' => date('Y-m-d H:i:s')
                     );

                     $id_age = $this->gsatelite->ingresar('age_agrupacion_empleado', $array_insert_reg);
                  }
              }

            /* =================================================================================================================
            =                              FIN GUARDADO DE AGRUPACIONES EMPLEADO
            ===================================================================================================================
            */

            /* =================================================================================================================
            =                              INICIO GUARDADO DE SERVICION BASICOS EMPLEADO
            ===================================================================================================================
            */

                $slcServiciosBasicos = $this->input->post('slcServiciosBasicos');
                for ($sbi = 0; $sbi < count($slcServiciosBasicos); $sbi++) {
                    if ($slcServiciosBasicos[$sbi] > 0 ) {
                        $array_insert_reg = array(
                         'sre_id_srb' => $slcServiciosBasicos[$sbi],
                         'sre_id_emp' => $emp_id,
                         'sre_estado' => 1,
                         'sre_usu_creacion' => $this->tank_auth->get_user_id(),
                         'sre_usu_modificacion' => $this->tank_auth->get_user_id(),
                         'sre_fecha_creacion' => date('Y-m-d H:i:s'),
                         'sre_fecha_modificacion' => date('Y-m-d H:i:s')
                        );

                        $id_sre = $this->gsatelite->ingresar('sre_servicio_empleado', $array_insert_reg);
                    }
                }

             /* =================================================================================================================
             =                              FIN GUARDADO DE SERVICION BASICOS EMPLEADO
             ===================================================================================================================
            */

            /* =================================================================================================================
            =                              INICIO INSUMO EMPLEADO
            ===================================================================================================================
            */
                $tipo_insumo_array = $this->input->post('tipo_insumo_array');
                $insumo_array = $this->input->post('insumo_array');
                $cantidad_insumo_array = $this->input->post('cantidad_insumo_array');
                $costo_insumo_array = $this->input->post('costo_insumo_array');
                $fecha_insumo_array = $this->input->post('fecha_insumo_array');

                foreach ($insumo_array as $key => $insumo) {
                    $array_ixe_insumoxempleado = array(                        
                        'ixe_id_inm' => $insumo_array[$key],
                        'ixe_id_emp' => $emp_id,
                        'ixe_cantidad' => $cantidad_insumo_array[$key],
                        'ixe_costo' => $costo_insumo_array[$key],
                        'ixe_fecha_entrega' => formatear_fecha('Y-m-d',$fecha_insumo_array[$key]),
                        'ixe_estado' => 1,
                        'ixe_usu_creacion' => $this->tank_auth->get_user_id(),
                        'ixe_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'ixe_fecha_creacion' => date('Y-m-d H:i:s'),
                        'ixe_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $id_ixe = $this->gsatelite->ingresar('ixe_insumoxempleado', $array_ixe_insumoxempleado);                    
                }                
            /* =================================================================================================================
             =                              FIN INSUMO EMPLEADO
             ===================================================================================================================
            */

              /* =================================================================================================================
              =                              INICIO CAPACITACIONES EMPLEADO
              ===================================================================================================================
             */
                  $nombre_capa_array = $this->input->post('nombre_capa_array');
                  $institucion_capa_array = $this->input->post('institucion_capa_array');
                  $fecha_inicio_capa_array = $this->input->post('fecha_inicio_capa_array');
                  $fecha_fin_capa_array = $this->input->post('fecha_fin_capa_array');
                  $hora_duracion_capa_array = $this->input->post('hora_duracion_capa_array');
                  $costo_capa_array = $this->input->post('costo_capa_array');
                  $costo_cubierto_insa_array = $this->input->post('costo_cubierto_insa_array');
                  $costo_cubierto_prov_array = $this->input->post('costo_cubierto_prov_array');
                  $estado_capa_array = $this->input->post('estado_capa_array');

                  foreach ($nombre_capa_array as $key => $nomcap) {
                      $array_cpe_capacitacion_empleado = array(                                                  
                          'cpe_id_emp' => $emp_id,
                          'cpe_id_ese' => is_numeric($estado_capa_array[$key])? $estado_capa_array[$key]:null,
                          'cpe_id_icp' => is_numeric($institucion_capa_array[$key])? $institucion_capa_array[$key]:null,
                          'cpe_nombre' => $nomcap,
                          'cpe_duracion' => ($hora_duracion_capa_array[$key] != "") ? $hora_duracion_capa_array[$key] : 0,
                          'cpe_costo_empresa' => ($costo_capa_array[$key] != "") ? $costo_capa_array[$key] : 0,
                          'cpe_costo_insaforp' => ($costo_cubierto_insa_array[$key] != "") ? $costo_cubierto_insa_array[$key] : 0,
                          'cpe_costo_proveedor' => ($costo_cubierto_prov_array[$key] != "") ? $costo_cubierto_prov_array[$key] : 0,
                          'cpe_fecha_inicio' => formatear_fecha('Y-m-d',$fecha_inicio_capa_array[$key]),
                          'cpe_fecha_fin' => formatear_fecha('Y-m-d',$fecha_fin_capa_array[$key]),                          
                          'cpe_estado' => 1,
                          'cpe_usu_creacion' => $this->tank_auth->get_user_id(),
                          'cpe_usu_modificacion' => $this->tank_auth->get_user_id(),
                          'cpe_fecha_creacion' => date('Y-m-d H:i:s'),
                          'cpe_fecha_modificacion' => date('Y-m-d H:i:s')
                      );
                      $id_ixe = $this->gsatelite->ingresar('cpe_capacitacion_empleado', $array_cpe_capacitacion_empleado);                    
                  }                
                /* =================================================================================================================
                =                              FIN CAPACITACIONES EMPLEADO
                ===================================================================================================================
                */

              //entrevista

                  $enm_id = $this->input->post('enm_id');
                  $tipo_entrevista = $this->input->post('tipo_entrevista');
                  $fecha_entrevista = $this->input->post('fecha_gen');
                  $lugar_entrevista = $this->input->post('lugar_ent');
                  $ponderacion_entrevista = $this->input->post('ponde_ent');
                  $descripcion_entrevista = $this->input->post('descr_ent');
                  $nombre_realizo = $this->input->post('nom_entre');

                  foreach ($enm_id as $key => $value) {
                      $array_entrevista = array(                                                  
                          'enm_id_tnv' => $tipo_entrevista[$key],
                          'enm_id_emp' => $emp_id,
                          'enm_fecha' => formatear_fecha("Y-m-d",$fecha_entrevista[$key]),
                          'enm_persona_realiza' => $nombre_realizo[$key],
                          'enm_lugar' => $lugar_entrevista[$key],
                          'enm_ponderacion' => $ponderacion_entrevista[$key],
                          'enm_descripcion' => $descripcion_entrevista[$key],                      
                          'enm_estado' => 1,
                          'enm_usu_creacion' => $this->tank_auth->get_user_id(),
                          'enm_usu_modificacion' => $this->tank_auth->get_user_id(),
                          'enm_fecha_creacion' => date('Y-m-d H:i:s'),
                          'enm_fecha_modificacion' => date('Y-m-d H:i:s')
                      );
                      $id_enm = $this->gsatelite->ingresar('enm_entrevista_empleado', $array_entrevista);                    
                  }

                  //PRUEBASSSSSS

                  $pbe_id = $this->input->post('pbe_id');
                  $tipo_prueba = $this->input->post('tipo_prueba');
                  $nombre_realizo_prueba = $this->input->post('nom_prueba');
                  $fecha_prueba = $this->input->post('fecha_prueba');
                  $lugar_prueba = $this->input->post('lugar_prueba');
                  $nota_prueba = $this->input->post('nota_prueba');
                  $descripcion_prueba = $this->input->post('descr_prueba');

                  foreach ($pbe_id as $key => $value) {
                      $array_prueba = array(                                                  
                          'pbe_id_tib' => $tipo_prueba[$key],
                          'pbe_id_emp' => $emp_id,
                          'pbe_fecha' => formatear_fecha("Y-m-d",$fecha_prueba[$key]),
                          'pbe_persona_califica' => $nombre_realizo_prueba[$key],
                          'pbe_lugar' => $lugar_prueba[$key],
                          'pbe_resultado' => $nota_prueba[$key],
                          'pbe_descripcion' => $descripcion_prueba[$key],                      
                          'pbe_estado' => 1,
                          'pbe_usu_creacion' => $this->tank_auth->get_user_id(),
                          'pbe_usu_modificacion' => $this->tank_auth->get_user_id(),
                          'pbe_fecha_creacion' => date('Y-m-d H:i:s'),
                          'pbe_fecha_modificacion' => date('Y-m-d H:i:s')
                      );
                      $id_pbe = $this->gsatelite->ingresar('pbe_prueba_empleado', $array_prueba);                    
                  }


            /* =================================================================================================================
              =									ANEXOS
              ===================================================================================================================
             */
            $rutas = $this->input->post("ruta");
            $carpeta = $this->input->post("nombreCarpeta");
            $duplicado = $this->input->post("duplicado");
            if (count($rutas) > 0) {
                $carpeta = $carpeta;
                $duplicado = $duplicado;
                for ($i = 0; $i < count($rutas); $i++) {
                    if ($rutas[$i] != "") {
                        $img = $rutas[$i];
                        $titulo = $this->input->post("titulo_doc" . ($i));
                        $this->datos_imagen_gral($img, $emp_id, $carpeta, $titulo, 0, null, $duplicado);
                    }
                }
            }

            $foto = $this->input->post('foto_empleado');
            $titulo = $this->input->post('titulo_foto_empleado');
            //guardar la foto del empleado
            if ($this->input->post('foto_empleado') != "" && $this->input->post('titulo_foto_empleado') != "") {
                $titulo = $this->input->post('titulo_foto_empleado');
                $img = $this->input->post('foto_empleado');
                $this->datos_imagen_gral($img, $emp_id, $carpeta, $titulo, 1, 1, $duplicado); //es de tipo foto
            }

            $dct = $this->input->post('dct');
            if ($dct == 1) {
                $docente_array = array(
                    'dct_id_emp' => $emp_id,
                    'dct_estado' => 1,
                    'dct_usu_crea' => $this->tank_auth->get_user_id(),
                    'dct_fecha_crea' => date('Y-m-d H:i:s'),
                    'dct_usu_mod' => $this->tank_auth->get_user_id(),
                    'dct_fecha_mod' => date('Y-m-d H:i:s')
                );

                $id = $this->gsatelite->ingresar('dct_docente', $docente_array);
                if ($id > 0) {
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro de Docente", 'texto_alerta' => "El registro se guardó correctamente");

                    $this->session->set_flashdata($alerta);
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "Hubo un problema al ingresar el registro");
                    $this->session->set_flashdata($alerta);
                }
                redirect('registro_academico/procesos/index_agregar_docente');
            } else {

                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro de personal", 'texto_alerta' => "El registro se guardó correctamente");
                $this->session->set_flashdata($alerta);
                // Redireccion
                $redireccion = $this->input->post('redireccion');
                if ($redireccion == 1) {
                    redirect('expediente_personal/empleado/agregar_empleado');
                } else {
                    redirect('expediente_personal/empleado/index_agregar_empleado?resultado=1');
                }
                
            }
        }
    }

    public function datos_imagen_gral($img, $id_emp, $carpeta, $titulo_doc, $tipo = 0, $foto_empleado = null, $duplicado = 0) {
        $extencion = end(explode(".", $img));
        // var_dump($carpeta);die();
        $datos_1 = $this->session->keep_flashdata('datos_1');
        $nombre = trim($img);
        $ruta = "public/temp/" . $carpeta . "/" . $nombre;
        /* if($extencion=='jpg' || $extencion=='jepg' || $extencion=='png'){
          $tipo=1;
          }
          else{$tipo=0;} */
        $destino = "uploads/anexos_empleados/" . $titulo_doc . time() . "." . trim($extencion) . "";
        $dir = $this->gsatelite->get_campo('anx_anexo', 'anx_url', array('anx_url' => $destino, 'anx_estado' => 1));
        
        if ($duplicado == 0){
            $destino = $destino;
        } else {
            // var_dump($titulo_doc);die();
            $destino = "uploads/anexos_empleados/" . $nombre . "";
        }
        //die(print_r(count($dir)));
        if (count($dir) <= 0) {
            $array_anex = array(
                'anx_url' => $destino,
                'anx_nombre' => $titulo_doc,
                'anx_estado' => 1,
                'anx_usu_crea' => $this->tank_auth->get_user_id(),
                'anx_usu_mod' => $this->tank_auth->get_user_id(),
                'anx_fecha_crea' => date('Y-m-d H:i:s'),
                'anx_fecha_mod' => date('Y-m-d H:i:s'),
                'anx_imagen' => $tipo
            );

            $this->db->insert("anx_anexo", $array_anex);
            $id_anexo = $this->db->insert_id();
            $array_anex_doc = array(
                'axe_id_emp' => $id_emp,
                'axe_id_anx' => $id_anexo,
                'axe_estado' => 1,
                'axe_usu_mod' => $this->tank_auth->get_user_id(),
                'axe_fecha_mod' => date('Y-m-d H:i:s')
            );
            $this->db->insert("axe_anexoxempleado", $array_anex_doc);
            $carpeta_destino = "uploads/anexos_empleados/" . $titulo_doc . time() . "." . trim($extencion) . "";
            copy($ruta, $carpeta_destino);
            unlink($ruta);
            if ($foto_empleado) {
                $this->gsatelite->actualizar_array('emp_empleado', array('emp_url_foto' => $destino), array('emp_id' => $id_emp));
            }
        }
    }

    public function datos_anexo_documento($img, $carpeta, $titulo_doc, $url_anexo_base='') {
        // var_dump($img);die();
        $extencion = end(explode(".", $img));
        $nombre = trim($img);
        $ruta = "public/temp/" . $carpeta . "/" . $nombre;
        if (trim($url_anexo_base) != '') {
            $carpeta_destino = "uploads/anexos_empleados/" . $url_anexo_base;
        } else {
            $carpeta_destino = "uploads/anexos_empleados/" . $titulo_doc . time() . "." . trim($extencion) . "";
        }
        copy($ruta, $carpeta_destino);
        unlink($ruta);
    }

    function validar_codigo() {

        $codigo = $this->input->post('codigo');
        $id = $this->input->post('id');

        if (isset($id)) {
            $validar_codigo = $this->db->select('emp_codigo,emp_id')
                            ->from('emp_empleado')
                            ->where('emp_id <>', $id)
                            ->where('emp_codigo', $codigo)
                            ->where('emp_id_emr', $this->tank_auth->get_empresa_id())
                            ->get()->result_array();
            if (count($validar_codigo) > 0) {
                if ($validar_codigo[0]['emp_id'] == $id) {
                    $id = $validar_codigo[0]['emp_id'];
                }
            } else {
                $id = 0;
            }
        } else {
            $validar_codigo = $this->db->select('emp_codigo,emp_id')
                            ->from('emp_empleado')
                            ->where('emp_codigo', $codigo)
                            ->get()->result_array();
            if (count($validar_codigo) > 0) {
                $id = $validar_codigo[0]['emp_id'];
            } else {
                $id = 0;
            }
        }

        $data = array(
            'id' => $id,
            'response' => true);
        echo json_encode($data);
    }

    function descuentos_empleado() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $titulo['titulo_personal'] = "Editar descuento";
            $data['tipo_descuento'] = $this->personal_model->tipo_descuento();
            $this->_cargarvista($titulo, $data);
        }
    }

    function eliminar_ingreso($id_inn) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $emp = $this->db->select('inn_id_emp')->from('inn_ingreso')->where('inn_id', $id_inn)->get()->result_array();
            //PREGUNTAR SI NO POSEE UN DETALLE DE HORAS EXTRAS EN LAS TABLA hxe_hora_extraxempleado
            $registro = $this->gsatelite->get_registro('inn_ingreso', 'inn_id', $id_inn);
            if ($registro->inn_id_hxe != "" and $registro->inn_id_hxe != null) {
                $this->gsatelite->borrado_general('hxe_hora_extraxempleado', array('hxe_id' => $registro->inn_id_hxe));
            }
            //PREGUNTAR SI NO POSEE UN DETALLE DE VACACIONES EN LAS TABLA gva_goce_vacacion
            if ($registro->inn_id_gva != "" and $registro->inn_id_gva != null) {
                $this->gsatelite->actualizar_array('gva_goce_vacacion', array('gva_estado' => '0'), array('gva_id' => $registro->inn_id_gva));
            }

            $this->db->where('inn_id', $id_inn)
                    ->delete('inn_ingreso');
            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "El registro a sido eliminado", 'texto_alerta' => "El ingreso para el empleado a sido eliminado");
            $this->session->set_flashdata($alerta);
            redirect('expediente_personal/empleado/ingreso_descuento_empleado/' . $emp[0]['inn_id_emp']);
        }
    }

    function eliminar_descuento($id_dss) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $emp = $this->db->select('dss_id_emp')->from('dss_descuento')->where('dss_id', $id_dss)->get()->result_array();

            //PREGUNTAR SI NO POSEE UN DETALLE DE VACACIONES EN LAS TABLA gva_goce_vacacion
            $registro = $this->gsatelite->get_registro('dss_descuento', 'dss_id', $id_dss);
            if ($registro->dss_id_gva != "" and $registro->dss_id_gva != null) {
                $this->gsatelite->actualizar_array('gva_goce_vacacion', array('gva_estado' => '0'), array('gva_id' => $registro->dss_id_gva));
            }

            //PREGUNTAR SI NO POSEE UN DETALLE DE HORAS EXTRAS EN LAS TABLA hxe_hora_extraxempleado
            if ($registro->dss_id_hxe != "" and $registro->dss_id_hxe != null) {
                $this->gsatelite->borrado_general('hxe_hora_extraxempleado', array('hxe_id' => $registro->dss_id_hxe));
            }

            $this->db->where('dss_id', $id_dss)
                    ->delete('dss_descuento');
            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "El registro a sido eliminado", 'texto_alerta' => "El descuento para el empleado a sido eliminado");
            $this->session->set_flashdata($alerta);
            redirect('expediente_personal/empleado/ingreso_descuento_empleado/' . $emp[0]['dss_id_emp']);
        }
    }

    function ingreso_descuento_empleado($id, $inc = null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data['info'] = $this->personal_model->info_empleado($id);
            $data['ver_ingresos'] = $this->personal_model->ingresos_empleado($id);
            $data['ver_descuentos'] = $this->personal_model->descuentos_empleado($id);
            $data['tipo_ingreso'] = $this->personal_model->tipo_ingreso();
            $titulo['titulo_personal'] = "Ingresos y descuentos";
            $data['tipo_descuento'] = $this->personal_model->tipo_descuento();
            $data['incapacidad'] = $inc;
            $ids_tpl = array(0);
            $pregunta = $this->gsatelite->get_tabla('txe_tipo_planillaxempleado', array('txe_id_emp' => $id));
            foreach ($pregunta as $fila) {
                $ids_tpl[] = $fila['txe_id_tpl'];
            }
            $this->db->where_in('tpl_id', $ids_tpl);
            $select = $this->gsatelite->get_dropdown('tpl_tipo_planilla', '{tpl_nombre}', '', null, null, '', 'tpl_id', true);
            $data["select_tpl_id"] = str_replace('<option value="0">Seleccione</option>', '', $select);

            $this->_cargarvista($titulo, $data);
        }
    }

    function nuevo_descuento() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $fecha1 = formatear_fecha('Y-m-d', $this->input->post('fecha_desde_des'));
            $emp = $this->input->post('emp_id');
            $descuento = array(
                'dss_id_emp' => $this->input->post('emp_id'),
                'dss_id_tpl' => $this->input->post('tipo_planilla_des'),
                'dss_id_tdc' => $this->input->post('tipo_descuento'),
                'dss_referencia' => $this->input->post('referencia_des'),
                'dss_motivo' => $this->input->post('con_descuento'),
                'dss_observacion' => $this->input->post('observaciones_des'),
                'dss_permanente' => ($this->input->post('permanente_des') == 1) ? 1 : 0,
                'dss_valor' => $this->input->post('monto_descontar'),
                'dss_fecha' => date('Y-m-d H:i:s'),
                'dss_fecha_desde' => $fecha1,
                'dss_cuota' => $this->input->post('cuotas_des'),
                'dss_cuota_pagada' => 0,
                'dss_estado' => $this->input->post('estado_des'),
                'dss_fecha_mod' => date("Y-m-d H:i:s"),
                'dss_usu_mod' => $this->tank_auth->get_user_id()
            );
            $this->db->insert('dss_descuento', $descuento);
            $dss_id = $this->db->insert_id();
            if (!empty($dss_id)) {

                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Inserción de descuento completo", 'texto_alerta' => "Puede ver el descuento en la pestaña de ver descuentos");
                $this->session->set_flashdata($alerta);
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "No se ingreso el descuento", 'texto_alerta' => "Verifique la informacion a ingresar");
                $this->session->set_flashdata($alerta);
            }
            redirect('expediente_personal/empleado/ingreso_descuento_empleado/' . $emp);
        }
    }

    function nuevo_ingreso() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {

            $fecha1 = str_replace('/', '-', $this->input->post('fecha_desde_in'));
            $fecha1 = date("Y-m-d", strtotime($fecha1));
            $emp = $this->input->post('emp_id');

            $ingreso = array(
                'inn_id_emp' => $this->input->post('emp_id'),
                'inn_id_tpl' => $this->input->post('tipo_planilla_in'),
                'inn_id_tig' => $this->input->post('tipo_ingreso'),
                'inn_motivo' => $this->input->post('con_ingreso'),
                'inn_observacion' => $this->input->post('observaciones_in'),
                'inn_permanente' => ($this->input->post('permanente_in') == 1) ? 1 : 0,
                'inn_valor' => $this->input->post('monto_aumentar'),
                'inn_fecha_desde' => $fecha1,
                'inn_cuota' => $this->input->post('cuotas_in'),
                'inn_cuota_pagada' => 0,
                'inn_estado' => $this->input->post('estado_in'),
                'inn_fecha_mod' => date("Y-m-d H:i:s"),
                'inn_usu_mod' => $this->tank_auth->get_user_id()
            );

            $this->db->insert('inn_ingreso', $ingreso);
            $inn_id = $this->db->insert_id();
            if (!empty($inn_id)) {

                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Inserción de ingreso completo", 'texto_alerta' => "Puede ver el ingreso en la pestaña de ver ingresos");
                $this->session->set_flashdata($alerta);
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "No se ingreso el descuento", 'texto_alerta' => "Verifique la informacion a ingresar");
                $this->session->set_flashdata($alerta);
            }
            redirect('expediente_personal/empleado/ingreso_descuento_empleado/' . $emp);
        }
    }


    function empleado_editar() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else { 
            // var_dump($_POST);die();
            $emp_id = $this->input->post('id');
            $cod_post = trim($this->input->post('codigo_emp'));
            $reg_cod = $this->gsatelite->get_registro('emp_empleado', array('emp_codigo'=>$cod_post, 'emp_id <>'=>$emp_id));
            if(count($reg_cod)>0){
                $longitu = $this->gsatelite->get_parametro_emp('SYS_CODIGO_NUEVO_EMPLEADO', null, null, array('LONGITUD MINIMA'));
                if ($longitu != 0 ){
                    $prefijo = $this->gsatelite->get_parametro_emp('SYS_CODIGO_NUEVO_EMPLEADO', null, null, array('PREFIJO CODIGO'));
                    $longitu = $this->gsatelite->get_parametro_emp('SYS_CODIGO_NUEVO_EMPLEADO', null, null, array('LONGITUD MINIMA'));
                    $last = $this->consultas->get_max_codigo('emp_empleado','emp_id');
                    $code = $last->codigo;
                    $cod = (float)$code + 1;
                    $codigo = $prefijo . str_pad($cod, $longitu, '0', STR_PAD_LEFT);
                    $data['codigo'] = $codigo;
                    // var_dump($codigo);
                    // die();
                } else {
                    $last=$this->consultas->get_max_codigo('emp_empleado','emp_codigo');
                    $code=$last->codigo;
                    $cod= (float)$code+1;
                    $codigo = str_pad($cod, 4, '0', STR_PAD_LEFT);
                    $data['codigo'] = $codigo;
                }
            }else{
                $codigo = $cod_post;
            }
            if ($this->input->post("fecha_prox_vac")!='') {//Fecha insertada menos 365 dias
                $actual   =  strtotime($this->input->post("fecha_prox_vac"));
                $anterior =  strtotime('-365 day', $actual);
                $fecha_anterior =  date('d-m-Y', $actual);//SAT_7003 se respetara fecha ingresada
            }

            $editar = array(
                'emp_id_suc' => ($this->input->post('sucursal') > 0) ? $this->input->post('sucursal') : null,
                'emp_id_plz' => ($this->input->post('puesto') > 0) ? $this->input->post('puesto') : null,
                'emp_id_afp' => ($this->input->post('afp') > 0) ? $this->input->post('afp') : null,
                'emp_id_are' => ($this->input->post('departamento') > 0) ? $this->input->post('departamento') : null,
                'emp_nombre' => $this->input->post('nombres'),
                'emp_apellido' => $this->input->post('apellidos'),
                //'emp_estado' => 1, //$this->input->post('estado'),//siempre en uno porque la acción de desactivar es independiente no en el editar
                'emp_direccion' => $this->input->post('direccion'),
                'emp_lugar_nac' => $this->input->post('lugar_nacimiento'),
               // 'emp_id_pai' => ($this->input->post('slcNacionalidad') > 0) ? $this->input->post('slcNacionalidad') : null,
                'emp_fecha_nac' => formatear_fecha('Y-m-d', $this->input->post('fecha_nacimiento')),
                'emp_id_gen' => ($this->input->post('genero') != "") ? $this->input->post('genero') : null,
                'emp_id_cnt' => ($this->input->post('slcCuentaCont') > 0) ? $this->input->post('slcCuentaCont') : null,
                'emp_id_pro' => ($this->input->post('profesion') != "") ? $this->input->post('profesion') : null,
                'emp_id_esc' => ($this->input->post('estado_civil') != "") ? $this->input->post('estado_civil') : null,
                'emp_fecha_contrato' => formatear_fecha('Y-m-d', $this->input->post('fecha_contratacion')),
                'emp_salario' => ($this->input->post('salario') != "") ? $this->input->post('salario') : 0,
                'emp_salario_hora' => ($this->input->post('salario_hora') != "") ? $this->input->post('salario_hora') : null,
                'emp_salario_hora_nocturna' => ($this->input->post('salario_hora_noc') != "") ? $this->input->post('salario_hora_noc') : null,
                'emp_usu_mod' => $this->tank_auth->get_user_id(),
                'emp_fecha_mod' => date('Y-m-d H:i:s'),
                'emp_codigo' => $codigo,
                'emp_afp' => $this->input->post('num_afp'),
                'emp_fecha_retiro' => (trim($this->input->post('fecha_retiro')) != "") ? formatear_fecha('Y-m-d', $this->input->post('fecha_retiro')) : null,
                'emp_seguro' => $this->input->post('num_seg'),
                'emp_id_ban' => ($this->input->post('banco') != "") ? $this->input->post('banco') : null,
                'emp_numero_cuenta' => $this->input->post('cuenta_banco'),
                'emp_observacion_contrato' => trim($this->input->post('observacion_contratacion')),
                'emp_id_tic' => ($this->input->post('tipo_contrato_empleado') != "") ? $this->input->post('tipo_contrato_empleado') : null,
                'emp_metodo_pago' => ($this->input->post('forma_pago_salario') != "") ? $this->input->post('forma_pago_salario') : null,
                'emp_licencia_profesional' => trim($this->input->post("licencia_prof")),
                'emp_id_pat_contacto' => ($this->input->post("contact_parentesco") != "") ? $this->input->post("contact_parentesco") : null, //id_parentesco
                'emp_estatura' => ($this->input->post("enf_estatura") != "") ? $this->input->post("enf_estatura") : null,
                'emp_peso' => ($this->input->post("enf_peso") != "") ? $this->input->post("enf_peso") : null,
                'emp_id_tsr' => ($this->input->post("slcTipoSangre") > 0)? $this->input->post("slcTipoSangre"):null,
                'emp_discapacidad' => $this->input->post("enf_discapacidad"),
                'emp_disponibilidad_viajar' => ($this->input->post("disponible_viajar") > 0) ? 1 : 0,
                'emp_id_tds' => ($this->input->post("enf_discapacidad") == 1 && $this->input->post("slcTipoDiscapacidad") > 0 )? $this->input->post("slcTipoDiscapacidad"):null,
                'emp_observacion_clinica' => $this->input->post("enf_observacion"),
                'emp_contacto_emergencia' => $this->input->post("contact_a"),
                'emp_direccion_emergencia' => $this->input->post("contact_direccion"),
                'emp_telefono_emergencia' => $this->input->post("contact_telefono"),
                'emp_id_zon' => ($this->input->post("slcZona") > 0)? $this->input->post("slcZona"):null,
                'emp_id_tiv' => ($this->input->post("slcTipoCasa") > 0)? $this->input->post("slcTipoCasa"):null,
                'emp_id_tcv' => ($this->input->post("slcTipoConstruccion") > 0)? $this->input->post("slcTipoConstruccion"):null,
                'emp_expediente' => (trim($this->input->post("expediente_emp")) !='')? trim($this->input->post("expediente_emp")):null,
                'emp_id_mun' => ($this->input->post("slcMunicipio") > 0)? $this->input->post("slcMunicipio"):null,
                'emp_id_pai' => ($this->input->post("slcNacionalidad") > 0)? $this->input->post("slcNacionalidad"):null,
                'emp_es_reingreso' => ($this->input->post("ckcReingreso") > 0)? 1:0,
                'emp_es_jubilado' => ($this->input->post("ckcJubilado") > 0)? 1:0,
                'emp_fecha_jubilado' => ($this->input->post("txtFechaJubilacion") !='' )? formatear_fecha('Y-m-d', $this->input->post('txtFechaJubilacion')):null,
                'emp_id_tps' => ($this->input->post("slcTipoSalario") > 0)? $this->input->post("slcTipoSalario"):null,
                'emp_id_cta' => ($this->input->post("slcCatAguinaldo") > 0)? $this->input->post("slcCatAguinaldo"):null,
                'emp_id_fnr' => ($this->input->post("slcFuenteReclutamiento") > 0)? $this->input->post("slcFuenteReclutamiento"):null,
                'emp_realizo_poligrafo' => ($this->input->post("ckcRealizaPoligrafo") > 0)? 1:0,
                'emp_codigo_referencia' => (trim($this->input->post("codigo_referencia")) !='')? trim($this->input->post("codigo_referencia")):null,
                'emp_id_tpc' => ($this->input->post("slcTipoCuenta") > 0)? $this->input->post("slcTipoCuenta"):null,
                'emp_aplica_afp' => ($this->input->post("ckcAplicaAfp") > 0)? 1:0,
                'emp_aplica_isss' => ($this->input->post("ckcAplicaIsss") > 0)? 1:0,
                'emp_aplica_renta' => ($this->input->post("ckcAplicaRenta") > 0)? 1:0,
                'emp_tipo_isr_aplica' => ($this->input->post("forma_renta") > 0)? 1:0,
                'emp_fecha_ult_liquidacion' => ($this->input->post("fecha_ult_liquidacion") !='' )? formatear_fecha('Y-m-d', $this->input->post('fecha_ult_liquidacion')):null,
                'emp_fecha_fin_contrato' => ($this->input->post("fecha_fin_contrato") !='' )? formatear_fecha('Y-m-d', $this->input->post('fecha_fin_contrato')):null,
                'emp_fecha_antiguedad' => ($this->input->post("fecha_antiguedad") !='' )? formatear_fecha('Y-m-d', $this->input->post('fecha_antiguedad')):null,
                'emp_fecha_ult_aguinaldo' => ($this->input->post("fecha_ult_aguinaldo") !='' )? formatear_fecha('Y-m-d', $this->input->post('fecha_ult_aguinaldo')):null,
                'emp_fecha_ult_vacacion'=> ($this->input->post("fecha_prox_vac") !='' )? formatear_fecha('Y-m-d', $fecha_anterior):null,
                'emp_fecha_poligrafo' => ($this->input->post("txtFecha_poligrafo") !='' )? formatear_fecha('Y-m-d', $this->input->post('txtFecha_poligrafo')):null,
                'emp_fecha_prox_poligrafo' => ($this->input->post("txtFecha_prox_poligrafo") !='' )? formatear_fecha('Y-m-d', $this->input->post('txtFecha_prox_poligrafo')):null,
                'emp_doc_bancario' => ($this->input->post("slcDocBac") != '') ? $this->input->post('slcDocBac') : null,
                'emp_id_sin' => ($this->input->post("slcSindicato") != '') ? $this->input->post("slcSindicato") : null,
                'emp_acumula_permisos' => ($this->input->post("acumula_dias_permisos") != '') ? $this->input->post("acumula_dias_permisos") : null
            );
            $this->db->where('emp_id', $emp_id)->update('emp_empleado', $editar);

            /************Ingresar en la tabla promocion_plaza_salarioxemp*********************/
            //Esta edicion solo esta permitida si el empleado solo posee un registro en pps_promocion_plaza_salarioxemp por tal motivo al editar solo se usa
            //el id del empleado para actualizar el registro en dicha tabla, si tienen mas de 2 registros ya no podra actualizarse desde aca
            $num_promos = count($this->gsatelite->get_tabla('pps_promocion_plaza_salarioxemp', array('pps_id_emp' => $emp_id)));
            if($num_promos <= 1 ){
                if($this->input->post('puesto') > 0){
                    $newarea = $this->gsatelite->get_campo('plz_plaza', 'plz_id_are', array('plz_id' => $this->input->post('puesto')));
                    $this->gsatelite->actualizar_array('pps_promocion_plaza_salarioxemp', array('pps_id_plz' => $this->input->post('puesto'),
                        'pps_id_emp' => $emp_id,
                        'pps_id_are' => ($newarea > 0) ? $newarea : null,
                        'pps_tipo' => 0,
                        'pps_salario' => ($this->input->post('salario') != "") ? $this->input->post('salario') : 0,
                        'pps_fecha_efectiva' => formatear_fecha('Y-m-d', $this->input->post('fecha_contratacion')),
                        'pps_fecha_desde' => formatear_fecha('Y-m-d', $this->input->post('fecha_contratacion')),                        
                        'pps_fecha_hasta' => null,                        
                        'pps_estado' => 1,
                        'pps_usu_creacion' => $this->tank_auth->get_user_id(),
                        'pps_fecha_creacion' => date('Y-m-d H:i:s'),
                        'pps_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'pps_fecha_modificacion' => date('Y-m-d H:i:s')
                    ), array('pps_id_emp' => $emp_id));
                }
            } elseif ($num_promos == 0) { //si no existe insertarlo.
                $newarea = $this->gsatelite->get_campo('plz_plaza', 'plz_id_are', array('plz_id' => $this->input->post('puesto')));
                $this->db->insert('pps_promocion_plaza_salarioxemp', array('pps_id_plz' => $this->input->post('puesto'),
                            'pps_id_emp' => $emp_id,
                            'pps_id_are' => ($newarea > 0) ? $newarea : null,
                            'pps_id_emr' => $this->tank_auth->get_empresa_id(),
                            'pps_tipo' => 0,
                            'pps_salario' => ($this->input->post('salario') != "") ? $this->input->post('salario') : 0,
                            'pps_fecha_efectiva' => formatear_fecha('Y-m-d', $this->input->post('fecha_contratacion')),
                            'pps_fecha_desde' => formatear_fecha('Y-m-d', $this->input->post('fecha_contratacion')),                        
                            'pps_fecha_hasta' => null,                        
                            'pps_estado' => 1,
                            'pps_usu_creacion' => $this->tank_auth->get_user_id(),
                            'pps_fecha_creacion' => date('Y-m-d H:i:s'),
                            'pps_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'pps_fecha_modificacion' => date('Y-m-d H:i:s')
                        ));
            }
            /*****************************************************/

            $this->db->where('txe_id_emp', $emp_id)
                    ->delete('txe_tipo_planillaxempleado');

            $tpl = $this->input->post('tipo_contrato');
            for ($i = 0; $i < count($tpl); $i++) {
                if ($tpl[$i] != null) {
                    $this->db->insert('txe_tipo_planillaxempleado', array('txe_id_tpl' => $tpl[$i], 'txe_id_emp' => $emp_id));
                }
            }
            //ACTUALIZAR LOS TIPOS DE SEGURO DEL EMPLEADO
            //preguntar por los existentes
            $consul = $this->gsatelite->get_tabla('sxe_seguroxempleado', array('sxe_id_emp' => $emp_id));
            $seleccionados_activos = array();
            foreach ($consul as $f) {
                $seleccionados_activos[] = $f['sxe_id_seg'];
            }

            $tseg = $this->input->post('tipo_seguro');
            for ($i = 0; $i < count($tseg); $i++) {
                if ($tseg[$i] > 0) {
                    if (!in_array($tseg[$i], $seleccionados_activos)) { //preguntar si se ha elegido uno nuevo
                        $this->db->insert('sxe_seguroxempleado', array('sxe_id_seg' => $tseg[$i],
                            'sxe_id_emp' => $emp_id,
                            'sxe_estado' => 1,
                            'sxe_usu_mod' => $this->tank_auth->get_user_id(),
                            'sxe_fecha_mod' => date('Y-m-d H:i:s')
                        ));
                    } else {// si existe unicamente actualizar los campos de auditoria
                        $cadena = array(
                            'sxe_estado' => 1,
                            'sxe_usu_mod' => $this->tank_auth->get_user_id(),
                            'sxe_fecha_mod' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->actualizar_array('sxe_seguroxempleado', $cadena, array('sxe_id_seg' => $tseg[$i], 'sxe_id_emp' => $emp_id));
                    }
                }
            }

            //AHORA RECORRER LOS EXISTENTES Y PREGUNTAR CUAL NO SE HA ELEGIDO
            for ($i = 0; $i < count($seleccionados_activos); $i++) {
                if (!in_array($seleccionados_activos[$i], $tseg)) {
                    $cadena = array(
                        'sxe_estado' => 0
                        , 'sxe_usu_mod' => $this->tank_auth->get_user_id()
                        , 'sxe_fecha_mod' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->actualizar_array('sxe_seguroxempleado', $cadena, array('sxe_id_seg' => $seleccionados_activos[$i], 'sxe_id_emp' => $emp_id));
                }
            }
            /////FIN ACTUALIZACIÓN DE TIPOS DE SEGURO
            ///INICIO ACTUALIZACION DE LOS CORREOS DEL EMPLEADO
            $this->db->where('cxp_id_emp', $emp_id)
                    ->delete('cxp_correoxempleado');

            $correos = $this->input->post('correo_empleado');
            $tipo_correo_empleado =  $this->input->post('tipo_correo_empleado');
            for ($i = 0; $i < count($correos); $i++) {
                if ($correos[$i] != null and trim($correos[$i]) != '') {
                    $this->db->insert('cxp_correoxempleado', array('cxp_id_emp' => $emp_id,
                        'cxp_correo' => $correos[$i],
                        'cxp_tipo_correo_empleado' => $tipo_correo_empleado[$i],
                        'cxp_estado' => 1,
                        'cxp_usu_mod' => $this->tank_auth->get_user_id(),
                        'cxp_fecha_mod' => date('Y-m-d H:i:s')
                    ));
                }
            }

            //FIN DE LA ACTUALIZACION DE LOS CORREOS DEL EMPLEADO
            ////////Inicio de modificacion de telefonos
            //obtenemos los ids de la relacion del empleado con los telefonos
            $telefonos_empleado = $this->personal_model->get_id_telefono($emp_id);
            $telefonos_seleccionados_ids = array();
            //guardamos los id de los telefonos que el usuario tiene actualmente
            foreach ($telefonos_empleado as $tel_emp) {
                $telefonos_seleccionados_ids[] = $tel_emp['tel_id'];
            }

            //toma de datos del formulario
            $array_ids_telefono = $this->input->post('ids_telefono_empleado');
            $array = $this->input->post('numeros_telefons'); //numeros de telefonos
            $array_tit = $this->input->post('tipos_telefons');

            //verificamos si en el array de los telefonos del usuario coinciden con los del formulario
            for ($x = 0; $x < count($array); $x++) {
                if (trim($array[$x]) != "" && trim($array_tit[$x]) != "") {
                    //si no existe el id en el array se inserta
                    if (!in_array($array_ids_telefono[$x], $telefonos_seleccionados_ids)) {
                        $this->db->insert('tel_telefono', array(
                            'tel_numero' => $array[$x],
                            'tel_id_tit' => $array_tit[$x],
                            'tel_estado' => 1,
                            'tel_usu_crea' => $this->tank_auth->get_user_id(),
                            'tel_usu_mod' => $this->tank_auth->get_user_id(),
                            'tel_fecha_crea' => date('Y-m-d H:i:s'),
                            'tel_fecha_mod' => date('Y-m-d H:i:s')
                        ));
                        $tel_id = $this->db->insert_id();
                        $this->db->insert('txm_telefonoxempleado', array(
                            'txm_id_tel' => $tel_id,
                            'txm_id_emp' => $emp_id
                        ));
                    } else {
                        $cadena_tel = array(
                            'tel_numero' => $array[$x],
                            'tel_id_tit' => $array_tit[$x],
                            'tel_estado' => 1,
                            'tel_usu_mod' => $this->tank_auth->get_user_id(),
                            'tel_fecha_mod' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->actualizar_array('tel_telefono', $cadena_tel, array('tel_id' => $array_ids_telefono[$x]));
                    }
                }
            }
            //Si el id se a eliminado del formulario entonces el estado pasa a 0
            for ($z = 0; $z < count($telefonos_seleccionados_ids); $z++) {
                if (!in_array($telefonos_seleccionados_ids[$z], $array_ids_telefono)) {
                    $cadena = array(
                        'tel_estado' => 0,
                        'tel_usu_mod' => $this->tank_auth->get_user_id(),
                        'tel_fecha_mod' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->actualizar_array('tel_telefono', $cadena, array('tel_id' => $telefonos_seleccionados_ids[$z]));
                }
            }
            /* ====================================================================================================================
              =								ACTUALIZAR ENFERMEDAD
              ======================================================================================================================
             */
            $enfermedad = $this->gsatelite->get_tabla('exe_enfermedadxempleado', array('exe_estado' => 1, 'exe_id_emp' => $emp_id));
            $exe_enf_ids = array();
            $enf_ids = array();
            foreach ($enfermedad as $key) {
                $exe_enf_ids[] = $key["exe_id"];
                $enf_ids[] = $key["exe_id_enf"];
            }
            $exe_id_enf = $this->input->post("exe_id_enf");
            $enf_tipo = $this->input->post("enf_tipo"); //id_enf_enfermedad

            $exe_id = 0;
            foreach ($enf_tipo as $key) {
                if (trim($key) != "") {
                    if (!in_array($key, $enf_ids)) {
                        $this->db->insert('exe_enfermedadxempleado', array(
                            'exe_id_enf' => $key,
                            'exe_id_emp' => $emp_id,
                            'exe_estado' => 1,
                            'exe_fecha_creacion' => date('Y-m-d H:i:s'),
                            'exe_usu_creacion' => $this->tank_auth->get_user_id(),
                            'exe_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'exe_fecha_modificacion' => date('Y-m-d H:i:s')
                        ));
                    } else {
                        $cadena_enf = array(
                            'exe_estado' => 1,
                            'exe_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'exe_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->actualizar_array('exe_enfermedadxempleado', $cadena_enf, array('exe_id' => $exe_enf_ids[$exe_id]));
                    }
                }
                $exe_id ++;
            }

            for ($enf_del = 0; $enf_del < count($enf_ids); $enf_del++) {
                if (!in_array($enf_ids[$enf_del], $enf_tipo)) {
                    $cadena = array(
                        'exe_estado' => 0,
                        'exe_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'exe_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->actualizar_array('exe_enfermedadxempleado', $cadena, array('exe_id' => $exe_enf_ids[$enf_del]));
                }
            }


            $alergico = $this->gsatelite->get_tabla('cae_componente_alergico_empleado', array('cae_estado' => 1, 'cae_id_emp' => $emp_id));

            $cae_aler_ids = array(); //Se almacenan los ids de la relacion de la alergia con el empleado
            $aler_ids = array(); //Se almacenan los ids de la relacion de la alergia con el empleado
            foreach ($alergico as $key) {
                $cae_aler_ids[] = $key["cae_id"];
                $aler_ids[] = $key["cae_id_coa"];
            }
            $cae_id_enf = $this->input->post("cae_id_enf");
            $enf_alergia = $this->input->post("enf_alergia"); //id_cos_componente

            $cae_id = 0;
            foreach ($enf_alergia as $key) {
                if (trim($key) != "") {
                    if (!in_array($key, $aler_ids)) {
                        $this->db->insert('cae_componente_alergico_empleado', array(
                            'cae_id_coa' => $key,
                            'cae_id_emp' => $emp_id,
                            'cae_estado' => 1,
                            'cae_fecha_creacion' => date('Y-m-d H:i:s'),
                            'cae_usu_creacion' => $this->tank_auth->get_user_id(),
                            'cae_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'cae_fecha_modificacion' => date('Y-m-d H:i:s')
                        ));
                    } else {
                        $cadena_aler = array(
                            'cae_estado' => 1,
                            'cae_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'cae_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->actualizar_array('cae_componente_alergico_empleado', $cadena_aler, array('cae_id' => $cae_id_enf[$cae_id]));
                    }
                }
                $cae_id++;
            }

            for ($aler_del = 0; $aler_del < count($aler_ids); $aler_del++) {
                if (!in_array($aler_ids[$aler_del], $enf_alergia)) {
                    $cadena = array(
                        'cae_estado' => 0,
                        'cae_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'cae_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->actualizar_array('cae_componente_alergico_empleado', $cadena, array('cae_id' => $cae_aler_ids[$aler_del]));
                }
            }

            // TEMPORALMENTE SE BORRARAN Y SE INGRESARAN DE NUEVO PUES SOLO SIRVE PARA REPORTERIA
            $this->db->where('mxe_id_emp', $emp_id)->delete('mxe_medicamento_x_empleado');
            $med_perm = $this->input->post("perm_drugs"); //lista de medicinas
            foreach ($med_perm as $val) {
                if (trim($val) != "") {
                    $this->db->insert('mxe_medicamento_x_empleado', array(
                        'mxe_id_emp' => $emp_id,
                        'mxe_nombre_medicamento' => trim($val),
                        'mxe_estado' => 1,
                        'mxe_usu_crea' => $this->tank_auth->get_user_id(),
                        'mxe_fecha_crea' => date('Y-m-d H:i:s'),
                        'mxe_usu_modifica' => $this->tank_auth->get_user_id(),
                        'mxe_fecha_modifica' => date('Y-m-d H:i:s')
                    ));
                }
            }

            /* =====================================================================================================================
              =									EDITAR DATOS FAMILIARES
              =======================================================================================================================
             */

            /*
              $this->db->where('fam_id_emp',$emp_id)
              ->delete('fam_familiar');
             */

            /* Verificar los familiares que tiene ese empleado */
            $consul = $this->gsatelite->get_tabla('fam_familiar', array('fam_id_emp' => $emp_id, 'fam_estado' => 1));
            $seleccionados_activos = array();
            foreach ($consul as $f) {
                $seleccionados_activos[] = $f['fam_id'];
            }
            
            /* Se obtiene los datos ha capturar de los familiares de empleado */
            $array3 = $this->input->post('nombres_familiares');
            $array3_1 = $this->input->post('apellidos_familiares');
            $array3_2 = $this->input->post('parentesco_familiares');
            $array3_3 = $this->input->post('telefono_familiares');
            $array3_4 = $this->input->post('fechas_familiares');
            $array3_5 = $this->input->post('dependencia_familiares');
            $array3_6 = $this->input->post('institucion_familiares');
            $array3_7 = $this->input->post('id_empleado_familiares');
            $array3_82 = $this->input->post('reside_con_empleado_familiares');
            $array3_8 = $this->input->post('familiar_ids');
            $array3_9 = $this->input->post('beneficiario_familiares');
            $array3_10 = $this->input->post('beneficia_porcentaje_familiares');
            $i = 0;
            foreach ($array3 as $key => $value3) {
                if (trim($value3) != "" && trim($array3_1[$i]) != "" && trim($array3_2[$i]) != "" && trim($array3_5[$i]) != "") {
                    if (in_array($array3_8[$i], $seleccionados_activos)) {
                            $cadena = array(
                            'fam_nombre' => $value3,
                            'fam_apellido' => $array3_1[$i],
                            'fam_fecha_nacimiento' => (trim($array3_4[$i]) != "")? date('Y-m-d', strtotime($array3_4[$i])) : null,
                            'fam_dependiente' => (is_numeric($array3_5[$i]))? $array3_5[$i]:null,
                            'fam_empresa' => (is_numeric($array3_6[$i]))? $array3_6[$i]:null,
                            'fam_estado' => 1,
                            'fam_id_pat' => $array3_2[$i],
                            'fam_telefono' => $array3_3[$i],
                            'fam_beneficiario' =>  (is_numeric($array3_9[$i]))?  $array3_9[$i]:null,
                            'fam_porcentaje_beneficio' =>  (is_numeric($array3_10[$i]))? $array3_10[$i]:null,
                            'fam_reside_empleado' => ($array3_82[$i] > 0) ? $array3_82[$i] :0,
                            'fam_usu_mod' => $this->tank_auth->get_user_id(),
                            'fam_fecha_mod' => date('Y-m-d H:i:s')
                        );
                            /*print_r($cadena);die();*/
                        $this->gsatelite->actualizar_array('fam_familiar', $cadena, array('fam_id' => $array3_8[$i], 'fam_id_emp' => $emp_id));
                    } else {
                        $cadena2 = array(
                            'fam_nombre' => $value3,
                            'fam_apellido' => $array3_1[$i],
                            'fam_fecha_nacimiento' => (trim($array3_4[$i]) != "") ? date('Y-m-d', strtotime($array3_4[$i])) : null,
                            'fam_dependiente' => (is_numeric($array3_5[$i]))? $array3_5[$i]:null, 
                            'fam_empresa' => (is_numeric($array3_6[$i]))? $array3_6[$i]:null, 
                            'fam_estado' => 1,
                            'fam_id_pat' => $array3_2[$i],
                            'fam_id_emp' => $emp_id,
                            'fam_id_emp_familiar' => ($array3_7[$i]) ? $array3_7[$i] : null,
                            'fam_reside_empleado' => ($array3_82[$i] > 0) ? $array3_82[$i] :0,
                            'fam_beneficiario' =>  (is_numeric($array3_9[$i]))? $array3_9[$i]:null, 
                            'fam_porcentaje_beneficio' =>  (is_numeric($array3_10[$i]))? $array3_10[$i]:null, 
                            'fam_telefono' => $array3_3[$i],
                            'fam_usu_crea' => $this->tank_auth->get_user_id(),
                            'fam_fecha_crea' => date('Y-m-d H:i:s'),
                            'fam_usu_mod' => $this->tank_auth->get_user_id(),
                            'fam_fecha_mod' => date('Y-m-d H:i:s'));
                        $fam_id = $this->db->insert('fam_familiar',$cadena2);
                        /*print_r($fam_id);die();*/
                    }
                } 
                $i++;
            }

            for ($j = 0; $j < count($seleccionados_activos); $j++) {
                if (!in_array($seleccionados_activos[$j], $array3_8)) {
                    $cadena = array(
                        'fam_estado' => 0,
                        'fam_usu_mod' => $this->tank_auth->get_user_id(),
                        'fam_fecha_mod' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->actualizar_array('fam_familiar', $cadena, array('fam_id' => $seleccionados_activos[$j], 'fam_id_emp' => $emp_id));
                }
            }

            /* ===============================================================================================================================
              =											ACTUALIZACION DE IDIOMAS
              =================================================================================================================================
             */

            $consul_idioma_emp = $this->gsatelite->get_tabla('iem_idioma_empleado', array('iem_id_emp' => $emp_id, 'iem_estado' => 1));
            //se guardan los ids de los familiares existentes
            $ids_idioma_emp = array();
            foreach ($consul_idioma_emp as $key) {
                $ids_idioma_emp[] = $key['iem_id'];
            }

            //Guarda los datos de los idiomas
            $array4 = $this->input->post('idioma');
            $array4_1 = $this->input->post('nivel');
            $array4_2 = $this->input->post('leer');
            $array4_3 = $this->input->post('escribir');
            $array4_4 = $this->input->post('hablar');
            $array4_5 = $this->input->post('traductor');
            $array4_6 = $this->input->post('id_iem_idioma');

            for ($i_d = 0; $i_d < count($array4); $i_d++) {
                if ($array4[$i_d] != "" && $array4_1[$i_d] != "") {
                    if (!in_array($array4_6[$i_d], $ids_idioma_emp)) {
                        $this->db->insert('iem_idioma_empleado', array(
                            'iem_id_nii' => $array4_1[$i_d],
                            'iem_id_idm' => $array4[$i_d],
                            'iem_id_emp' => $emp_id,
                            'iem_leer' => ($array4_2[$i_d] != "") ? $array4_2[$i_d] : 0,
                            'iem_escribir' => ($array4_3[$i_d] != "") ? $array4_3[$i_d] : 0,
                            'iem_hablar' => ($array4_4[$i_d] != "") ? $array4_4[$i_d] : 0,
                            'iem_traductor' => ($array4_5[$i_d] != "") ? $array4_5[$i_d] : 0,
                            'iem_estado' => 1,
                            'iem_usu_creacion' => $this->tank_auth->get_user_id(),
                            'iem_fecha_creacion' => date('Y-m-d H:i:s'),
                            'iem_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'iem_fecha_modificacion' => date('Y-m-d H:i:s'))
                        );
                    } else {
                        $cadena = array(
                            'iem_id_nii' => $array4_1[$i_d],
                            'iem_id_idm' => $array4[$i_d],
                            'iem_leer' => $array4_2[$i_d],
                            'iem_escribir' => $array4_3[$i_d],
                            'iem_hablar' => $array4_4[$i_d],
                            'iem_traductor' => $array4_5[$i_d],
                            'iem_estado' => 1,
                            'iem_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'iem_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->actualizar_array('iem_idioma_empleado', $cadena, array('iem_id' => $array4_6[$i_d], 'iem_id_emp' => $emp_id));
                    }
                }
            }

            for ($i_dd = 0; $i_dd < count($ids_idioma_emp); $i_dd++) {
                if (!in_array($ids_idioma_emp[$i_dd], $array4_6)) {
                    $cadena = array(
                        'iem_estado' => 0,
                        'iem_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'iem_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->actualizar_array('iem_idioma_empleado', $cadena, array('iem_id' => $ids_idioma_emp[$i_dd], 'iem_id_emp' => $emp_id));
                }
            }


            /* ===============================================================================================================================
              =											ACTUALIZACION DE CERTIFICADOS DE IDIOMA
              =================================================================================================================================
             */

            $consul_cer_idioma_emp = $this->gsatelite->get_tabla('cri_certificacion_idioma', array('cri_id_emp' => $emp_id, 'cri_estado' => 1));
            $ids_cer_idioma_emp = array();
            foreach ($consul_cer_idioma_emp as $key) {
                $ids_cer_idioma_emp[] = $key['cri_id'];
            }

            $array5 = $this->input->post('idioma_cert');
            $array5_1 = $this->input->post('tipo_cert');
            $array5_2 = $this->input->post('puntaje_cert');
            $array5_3 = $this->input->post('fecha_cert');
            $array5_4 = $this->input->post('id_cri_idioma');

            for ($c_d = 0; $c_d < count($array5); $c_d++) {
                if ($array5[$c_d] != "" && $array5_1[$c_d] != "" && $array5_2[$c_d] != "" && $array5_3[$c_d] != "") {
                    if (!in_array($array5_4[$c_d], $ids_cer_idioma_emp)) {
                        $this->db->insert('cri_certificacion_idioma', array(
                            'cri_id_emp' => $emp_id,
                            'cri_id_cer' => $array5_1[$c_d],
                            'cri_id_idm' => $array5[$c_d],
                            'cri_puntaje' => $array5_2[$c_d],
                            'cri_fecha_certificacion' => (trim($array5_3[$c_d]) != "") ? date('Y-m-d', strtotime($array5_3[$c_d])) : null,
                            'cri_estado' => 1,
                            'cri_usu_creacion' => $this->tank_auth->get_user_id(),
                            'cri_fecha_creacion' => date('Y-m-d H:i:s'),
                            'cri_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'cri_fecha_modificacion' => date('Y-m-d H:i:s')
                        ));
                    } else {
                        $cadena = array(
                            'cri_id_cer' => $array5_1[$c_d],
                            'cri_id_idm' => $array5[$c_d],
                            'cri_puntaje' => $array5_2[$c_d],
                            'cri_fecha_certificacion' => (trim($array5_3[$c_d]) != "") ? date('Y-m-d', strtotime($array5_3[$c_d])) : null,
                            'cri_estado' => 1,
                            'cri_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'cri_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->actualizar_array('cri_certificacion_idioma', $cadena, array('cri_id' => $array5_4[$c_d], 'cri_id_emp' => $emp_id));
                    }
                }
            }

            for ($c_dd = 0; $c_dd < count($ids_cer_idioma_emp); $c_dd++) {
                if (!in_array($ids_cer_idioma_emp[$c_dd], $array5_4)) {
                    $cadena = array(
                        'cri_estado' => 0,
                        'cri_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'cri_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->actualizar_array('cri_certificacion_idioma', $cadena, array('cri_id' => $ids_cer_idioma_emp[$c_dd], 'cri_id_emp' => $emp_id));
                }
            }

            /* ===============================================================================================================================
              =											ACTUALIZACION DE PROGRAMAS
              =================================================================================================================================
             */

            $consul_programa_emp = $this->gsatelite->get_tabla('pxe_programaxempleado', array('pxe_id_emp' => $emp_id, 'pxe_estado' => 1));
            //se guardan los ids de los familiares existentes
            $ids_programa_emp = array();
            foreach ($consul_programa_emp as $key) {
                $ids_programa_emp[] = $key['pxe_id'];
            }

            //Guarda los datos de los idiomas
            $array4 = $this->input->post('tipo_program');
            $array4_1 = $this->input->post('nivel_program');

            $array4_2 = $this->input->post('id_pxe_program');

            for ($i_p = 0; $i_p < count($array4); $i_p++) {
                if ($array4[$i_p] != "" && $array4_1[$i_p] != "") {
                    if (!in_array($array4_2[$i_p], $ids_programa_emp)) {
                        $this->db->insert('pxe_programaxempleado', array(
                            'pxe_id_peq' => $array4[$i_p],
                            'pxe_id_emp' => $emp_id,
                            'pxe_id_nie' => $array4_1[$i_p],
                            'pxe_estado' => 1,
                            'pxe_fecha_creacion' => date('Y-m-d H:i:s'),
                            'pxe_usu_creacion' => $this->tank_auth->get_user_id(),
                            'pxe_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'pxe_fecha_modificacion' => date('Y-m-d H:i:s')
                        ));
                    } else {
                        $cadena = array(
                            'pxe_id_peq' => $array4[$i_p],
                            'pxe_id_nie' => $array4_1[$i_p],
                            'pxe_estado' => 1,
                            'pxe_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'pxe_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->actualizar_array('pxe_programaxempleado', $cadena, array('pxe_id' => $array4_2[$i_d], 'pxe_id_emp' => $emp_id));
                    }
                }
            }

            for ($i_pp = 0; $i_pp < count($ids_programa_emp); $i_pp++) {
                if (!in_array($ids_programa_emp[$i_pp], $array4_2)) {
                    $cadena = array(
                        'pxe_estado' => 0,
                        'pxe_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'pxe_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->actualizar_array('pxe_programaxempleado', $cadena, array('pxe_id' => $ids_programa_emp[$i_pp], 'pxe_id_emp' => $emp_id));
                }
            }


            /* ===============================================================================================================================
              =											ACTUALIZACION DE CERTIFICADOS DE PROGRAMAS
              =================================================================================================================================
             */

            $consul_cer_program_cep = $this->gsatelite->get_tabla('cep_certificacion_programa', array('cep_id_emp' => $emp_id, 'cep_estado' => 1));
            $ids_cer_program_cep = array();
            foreach ($consul_cer_program_cep as $key) {
                $ids_cer_program_cep[] = $key['cep_id'];
            }

            $array5 = $this->input->post('program_cer');
            $array5_1 = $this->input->post('tipo_program_cer');
            $array5_2 = $this->input->post('program_puntaje_cert');
            $array5_3 = $this->input->post('program_fecha_cert');
            $array5_4 = $this->input->post('program_institucion_cert');
            $array5_5 = $this->input->post('program_modalidad_cert');


            $array5_6 = $this->input->post('id_cep_program_cer');

            for ($c_p = 0; $c_p < count($array5); $c_p++) {
                if ($array5[$c_p] != "" && $array5_1[$c_p] != "") {
                    if (!in_array($array5_6[$c_p], $ids_cer_program_cep)) {
                        $this->db->insert('cep_certificacion_programa', array(
                            'cep_id_emp' => $emp_id,
                            'cep_id_cer' => $array5_1[$c_p],
                            'cep_id_peq' => $array5[$c_p],
                            'cep_puntaje' => (trim($array5_2[$c_p]) != "") ? $array5_2[$c_p] : null,
                            'cep_id_mde'  => (trim($array5_5[$c_p]) != "") ? $array5_5[$c_p] : null,
                            'cep_id_icp'  => (trim($array5_4[$c_p]) != "") ? $array5_4[$c_p] : null,
                            'cep_fecha_certificacion' => (trim($array5_3[$c_p]) != "") ? date('Y-m-d', strtotime($array5_3[$c_p])) : null,
                            'cep_estado' => 1,
                            'cep_usu_creacion' => $this->tank_auth->get_user_id(),
                            'cep_fecha_creacion' => date('Y-m-d H:i:s'),
                            'cep_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'cep_fecha_modificacion' => date('Y-m-d H:i:s')
                        ));
                    } else {
                        $cadena = array(
                            'cep_id_cer' => $array5_1[$c_p],
                            'cep_id_peq' => $array5[$c_p],
                            'cep_puntaje' => $array5_2[$c_p],
                            'cep_id_mde'  => $array5_5[$c_p],
                            'cep_id_icp'  => $array5_4[$c_p],
                            'cep_fecha_certificacion' => (trim($array5_3[$c_p]) != "") ? date('Y-m-d', strtotime($array5_3[$c_p])) : null,
                            'cep_estado' => 1,
                            'cep_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'cep_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->actualizar_array('cep_certificacion_programa', $cadena, array('cep_id' => $array5_4[$c_p], 'cep_id_emp' => $emp_id));
                    }
                }
            }

            for ($c_pp = 0; $c_pp < count($ids_cer_program_cep); $c_pp++) {
                if (!in_array($ids_cer_program_cep[$c_pp], $array5_6)) {
                    $cadena = array(
                        'cep_estado' => 0,
                        'cep_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'cep_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->actualizar_array('cep_certificacion_programa', $cadena, array('cep_id' => $ids_cer_program_cep[$c_pp], 'cep_id_emp' => $emp_id));
                }
            }

            /* =================================================================================================================
              =									REFERENCIAS PERSONALES
              ===================================================================================================================
             */
            $array8 = $this->input->post('tipo_refpersonal');
            $array8_1 = $this->input->post('nombre_refpersonal');
            $array8_2 = $this->input->post('ltrabajo_refpersonal');
            $array8_3 = $this->input->post('ocupacion_refpersonal');
            $array8_4 = $this->input->post('telefono_refpersonal');
            $array8_refDescipcion = $this->input->post('referencia_refpersonal');

            $consul_refpersonal = $this->gsatelite->get_tabla('rfp_referencia_personal', array('rfp_estado' => 1, 'rfp_id_emp' => $emp_id));
            $ids_refpersonal = array();
            foreach ($consul_refpersonal as $key) {
                $ids_refpersonal[] = $key['rfp_id'];
            }

            $array8_5 = $this->input->post('id_refpersonal');

            for ($rf = 0; $rf < count($array8); $rf++) {
                if ($array8[$rf] != "" && $array8_1[$rf] != "" && $array8_2[$rf] != "" && $array8_4[$rf] != "") {
                    if (!in_array($array8_5[$rf], $ids_refpersonal)) {
                        $this->db->insert('rfp_referencia_personal', array(
                            'rfp_id_trr' => $array8[$rf],
                            'rfp_id_emp' => $emp_id,
                            'rfp_nombre' => $array8_1[$rf],
                            'rfp_lugar_trabajo' => $array8_2[$rf],
                            'rfp_ocupacion' => (trim($array8_3[$rf]) != "") ? $array8_3[$rf] : null,
                            'rfp_telefono' => $array8_4[$rf],
                            'rfp_descripcion_referencia' => (trim($array8_refDescipcion[$rf]) != '')? $array8_refDescipcion[$rf]:null,
                            'rfp_estado' => 1,
                            'rfp_fecha_creacion' => date('Y-m-d H:i:s'),
                            'rfp_usu_creacion' => $this->tank_auth->get_user_id(),
                            'rfp_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'rfp_fecha_modificacion' => date('Y-m-d H:i:s')
                        ));
                    } else {
                        $cadena = array(
                            'rfp_id_trr' => $array8[$rf],
                            'rfp_nombre' => $array8_1[$rf],
                            'rfp_lugar_trabajo' => $array8_2[$rf],
                            'rfp_ocupacion' => (trim($array8_3[$rf]) != "") ? $array8_3[$rf] : null,
                            'rfp_telefono' => $array8_4[$rf],
                            'rfp_descripcion_referencia' => (trim($array8_refDescipcion[$rf]) != '')? $array8_refDescipcion[$rf]:null,
                            'rfp_estado' => 1,
                            'rfp_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'rfp_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->actualizar_array('rfp_referencia_personal', $cadena, array('rfp_id' => $array8_5[$rf], 'rfp_id_emp' => $emp_id));
                    }
                }
            }

            for ($rff = 0; $rff < count($ids_refpersonal); $rff++) {
                if (!in_array($ids_refpersonal[$rff], $array8_5)) {
                    $cadena = array(
                        'rfp_estado' => 0,
                        'rfp_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'rfp_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->actualizar_array('rfp_referencia_personal', $cadena, array('rfp_id' => $ids_refpersonal[$rff], 'rfp_id_emp' => $emp_id));
                }
            }

            /* =================================================================================================================
              =									REFERENCIAS PERSONALES
              ===================================================================================================================
             */
            $array9 = $this->input->post('lugar_tra_reflab');
            $array9_1 = $this->input->post('direccion_reflab');
            $array9_2 = $this->input->post('telefono_reflab');
            $array9_3 = $this->input->post('puesto_reflab');
            $array9_4 = $this->input->post('jefe_inmediato_reflab');
            $array9_5 = $this->input->post('salario_deven_reflab');
            $array9_6 = $this->input->post('mot_retiro_reflab');


            $array9_8 = $this->input->post('nombre_referencia_reflab');
            $array9_9 = $this->input->post('desde_reflab');
            $array9_10 = $this->input->post('hasta_reflab');
            $array9_11 = $this->input->post('referencia_reflab');

            $consul_reflaboral = $this->gsatelite->get_tabla('rfl_referencia_laboral', array('rfl_estado' => 1, 'rfl_id_emp' => $emp_id));
            $ids_reflaboral = array();
            foreach ($consul_reflaboral as $key) {
                $ids_reflaboral[] = $key['rfl_id'];
            }

            $array9_7 = $this->input->post('id_reflaboral');

            for ($rl = 0; $rl < count($array9); $rl++) {
                if ($array9[$rl] != "" && $array9_1[$rl] != "" && $array9_3[$rl] != "") {
                    if (!in_array($array9_7[$rl], $ids_reflaboral)) {
                        $this->db->insert('rfl_referencia_laboral', array(
                            'rfl_id_emp' => $emp_id,
                            'rfl_lugar_trabajo' => $array9[$rl],
                            'rfl_direccion' => $array9_1[$rl],
                            'rfl_telefono' => $array9_2[$rl],
                            'rfl_puesto' => $array9_3[$rl],
                            'rfl_jefe' => $array9_4[$rl],
                            'rfl_salario_devengado' => ($array9_5[$rl] >0)? $array9_5[$rl]:null,
                            'rfl_motivo_retiro' => $array9_6[$rl],
                            'rfl_nombre_ref' => $array9_8[$rl],
                            'rfl_fecha_desde' => (trim($array9_9[$rl]) != '')? formatear_fecha('Y-m-d',$array9_9[$rl]):null,
                            'rfl_fecha_hasta' => (trim($array9_10[$rl]) != '')? formatear_fecha('Y-m-d',$array9_10[$rl]):null,
                            'rfl_referencia' => $array9_11[$rl],
                            'rfl_estado' => 1,
                            'rfl_fecha_creacion' => date('Y-m-d H:i:s'),
                            'rfl_usu_creacion' => $this->tank_auth->get_user_id(),
                            'rfl_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'rfl_fecha_modificacion' => date('Y-m-d H:i:s')
                        ));
                    } else {
                        $cadena = array(
                            'rfl_lugar_trabajo' => $array9[$rl],
                            'rfl_direccion' => $array9_1[$rl],
                            'rfl_telefono' => $array9_2[$rl],
                            'rfl_puesto' => $array9_3[$rl],
                            'rfl_jefe' => $array9_4[$rl],
                            'rfl_salario_devengado' => ($array9_5[$rl] >0)? $array9_5[$rl]:null,
                            'rfl_motivo_retiro' => $array9_6[$rl],
                            'rfl_estado' => 1,
                            'rfl_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'rfl_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->actualizar_array('rfl_referencia_laboral', $cadena, array('rfl_id' => $array9_7[$rl], 'rfl_id_emp' => $emp_id));
                    }
                }
            }

            for ($rll = 0; $rll < count($ids_reflaboral); $rll++) {
                if (!in_array($ids_reflaboral[$rll], $array9_7)) {
                    $cadena = array(
                        'rfl_estado' => 0,
                        'rfl_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'rfl_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->actualizar_array('rfl_referencia_laboral', $cadena, array('rfl_id' => $ids_reflaboral[$rll], 'rfl_id_emp' => $emp_id));
                }
            }

            /* =================================================================================================================
              =									DATOS ACADEMICOS
              ===================================================================================================================
             */
            $array10 = $this->input->post('tipo_datacademicos');
            $array10_1 = $this->input->post('profesion_datacademicos');
            $array10_2 = $this->input->post('institucion_datacademicos');
            $array10_3 = $this->input->post('estestudio_datacademicos');
            $array10_4 = $this->input->post('pais_datacademicos');
            $array10_5 = $this->input->post('explaboral_datacademicos');
            $array10_6 = $this->input->post('fecha_datacademicos');
            $array10_7 = $this->input->post('observacion_datacademicos');

            $array10_9 = $this->input->post('anios_cursado_estudio_datacademicos');


            $consul_dacacademic = $this->gsatelite->get_tabla('dac_dato_academico', array('dac_estado' => 1, 'dac_id_emp' => $emp_id));
            $ids_dacacademic = array();
            foreach ($consul_dacacademic as $key) {
                $ids_dacacademic[] = $key['dac_id'];
            }

            $array10_8 = $this->input->post('id_datacademic');

            for ($dta = 0; $dta < count($array10); $dta++) {
                if ($array10[$dta] > 0/* && $array10_3[$dta] != "" && $array10_4[$dta] != "" && $array10_5[$dta] */) {
                    if (!in_array($array10_8[$dta], $ids_dacacademic)) {
                        $this->db->insert('dac_dato_academico', array(
                            'dac_id_pai' => ($array10_4[$dta] > 0)? $array10_4[$dta]:null,
                            'dac_id_tie' => $array10[$dta],
                            'dac_id_pro' => ($array10_1[$dta] > 0)? $array10_1[$dta] : null,
                            'dac_id_ese' => ($array10_3[$dta] > 0)? $array10_3[$dta]:null,
                            'dac_id_emp' => $emp_id,
                            'dac_id_exl' => ($array10_5[$dta] > 0 ) ? $array10_5[$dta] : null,
                            'dac_id_ina' => ($array10_2[$dta] > 0 ) ? $array10_2[$dta] : null,
                            'dac_fecha_finalizacion' => date('Y-m-d', strtotime($array10_6[$dta])),
                            'dac_anios_cursado' => ($array10_9[$dta] > 0 ) ? $array10_9[$dta] : null,
                            'dac_observacion' => $array10_7[$dta],
                            'dac_estado' => 1,
                            'dac_fecha_creacion' => date('Y-m-d H:i:s'),
                            'dac_usu_creacion' => $this->tank_auth->get_user_id(),
                            'dac_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'dac_fecha_modificacion' => date('Y-m-d H:i:s')
                        ));
                    } else {
                        $cadena = array(
                            'dac_id_pai' => ($array10_4[$dta] > 0 )? $array10_4[$dta]:null,
                            'dac_id_tie' => $array10[$dta],
                            'dac_id_pro' => ($array10_1[$dta] != '') ? $array10_1[$dta] : null,
                            'dac_id_ese' => ($array10_3[$dta] > 0)? $array10_3[$dta]:null,
                            'dac_id_exl' => ($array10_5[$dta] != '') ? $array10_5[$dta] : null,
                            'dac_id_ina' => ($array10_2[$dta] != '') ? $array10_2[$dta] : null,
                            'dac_fecha_finalizacion' => (trim($array10_6[$dta]) != "") ? date('Y-m-d', strtotime($array10_6[$dta])) : null,
                            'dac_anios_cursado' => ($array10_9[$dta] > 0 ) ? $array10_9[$dta] : null,
                            'dac_observacion' => $array10_7[$dta],
                            'dac_estado' => 1,
                            'dac_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'dac_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->actualizar_array('dac_dato_academico', $cadena, array('dac_id' => $array10_8[$dta], 'dac_id_emp' => $emp_id));
                    }
                }
            }

            for ($dtaa = 0; $dtaa < count($ids_dacacademic); $dtaa++) {
                if (!in_array($ids_dacacademic[$dtaa], $array10_8)) {
                    $cadena = array(
                        'dac_estado' => 0,
                        'dac_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'dac_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->actualizar_array('dac_dato_academico', $cadena, array('dac_id' => $ids_dacacademic[$dtaa], 'dac_id_emp' => $emp_id));
                }
            }



            /* =================================================================================================================
              =                              INICIO GUARDADO DE HABILIDADES EMPLEADO
              ===================================================================================================================
             */

            $this->gsatelite->borrado_general('hxm_habilidadxempleado',array('hxm_id_emp'=>$emp_id));
            $hablidad_empleado = $this->input->post('hablidad_empleado');
            $nivel_hablidad_empleado = $this->input->post('nivel_hablidad_empleado');
            for ($hab_emp=0; $hab_emp < count($hablidad_empleado) ; $hab_emp++) { 
                if ($hablidad_empleado[$hab_emp] > 0) {
                   $array_insert_reg = array(
                    'hxm_id_hab' => $hablidad_empleado[$hab_emp],
                    'hxm_id_emp' => $emp_id,
                    'hxm_id_nih' => ($nivel_hablidad_empleado[$hab_emp] > 0)? $nivel_hablidad_empleado[$hab_emp]:null,
                    'hxm_estado' => 1,
                    'hxm_usu_creacion' => $this->tank_auth->get_user_id(),
                    'hxm_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'hxm_fecha_creacion' => date('Y-m-d H:i:s'),
                    'hxm_fecha_modificacion' => date('Y-m-d H:i:s')
                   );

                   $id_hxm = $this->gsatelite->ingresar('hxm_habilidadxempleado', $array_insert_reg);
                }
            }

            /* =================================================================================================================
              =                              FIN GUARDADO DE HABILIDADES EMPLEADO
              ===================================================================================================================
             */
              
              /* =================================================================================================================
              =                              INICIO EDITAR INSUMOS
              ===================================================================================================================
             */
              //Contacto
              $new = $this->input->post('txtTablaNew');
              $tipo_insumo_array = $this->input->post('tipo_insumo_array');
              $insumo_array = $this->input->post('insumo_array');
              $cantidad_insumo_array = $this->input->post('cantidad_insumo_array');
              $costo_insumo_array = $this->input->post('costo_insumo_array');
              $fecha_insumo_array = $this->input->post('fecha_insumo_array');            
              
              //obtener los detalles antiguos
              $insumos_antiguos = $this->gsatelite->get_tabla('ixe_insumoxempleado', array('ixe_id_emp' => $emp_id));
              
              //eliminacion de insumos que no existen 
              foreach ($insumos_antiguos as $insu) {
                  if (!in_array($insu['ixe_id'], $new)) {
                      $this->gsatelite->actualizar_array('ixe_insumoxempleado', array('ixe_estado' => 0),array('ixe_id' => $insu['ixe_id']));
                  }
              }

              foreach ($insumo_array as $key => $id_insu) {
                  if(trim($id_insu)){
                      if ( $new[$key] == "" ) {
                          $array_ixe_insumoxempleado = array(                        
                              'ixe_id_inm' => $insumo_array[$key],
                              'ixe_id_emp' => $emp_id,
                              'ixe_cantidad' => $cantidad_insumo_array[$key],
                              'ixe_costo' => $costo_insumo_array[$key],
                              'ixe_fecha_entrega' => formatear_fecha('Y-m-d',$fecha_insumo_array[$key]),
                              'ixe_estado' => 1,
                              'ixe_usu_creacion' => $this->tank_auth->get_user_id(),
                              'ixe_usu_modificacion' => $this->tank_auth->get_user_id(),
                              'ixe_fecha_creacion' => date('Y-m-d H:i:s'),
                              'ixe_fecha_modificacion' => date('Y-m-d H:i:s')
                          );
                          $this->gsatelite->ingresar('ixe_insumoxempleado', $array_ixe_insumoxempleado);
                      } else {
                          $array_ixe_insumoxempleado = array(                        
                              'ixe_id_inm' => $insumo_array[$key],
                              'ixe_id_emp' => $emp_id,
                              'ixe_cantidad' => $cantidad_insumo_array[$key],
                              'ixe_costo' => $costo_insumo_array[$key],
                              'ixe_fecha_entrega' => formatear_fecha('Y-m-d',$fecha_insumo_array[$key]),
                              'ixe_estado' => 1,
                              //'ixe_usu_creacion' => $this->tank_auth->get_user_id(),
                              //'ixe_usu_modificacion' => $this->tank_auth->get_user_id(),
                              'ixe_fecha_creacion' => date('Y-m-d H:i:s'),
                              'ixe_fecha_modificacion' => date('Y-m-d H:i:s')
                          );    
                          $this->gsatelite->actualizar_array('ixe_insumoxempleado', $array_ixe_insumoxempleado,array('ixe_id' => $new[$key]));
                      }                    
                  }
              }            
              /* =================================================================================================================
              =                              FIN EDITAR INSUMOS
              ===================================================================================================================
              */
                
                 /* =================================================================================================================
                 =                              INICIO EDITAR CAPACITACIONES
                 ===================================================================================================================
                */
                 //Contacto
                 $new = $this->input->post('txtTablaNewCapa');
                 $nombre_capa_array = $this->input->post('nombre_capa_array');
                 $institucion_capa_array = $this->input->post('institucion_capa_array');
                 $fecha_inicio_capa_array = $this->input->post('fecha_inicio_capa_array');                 
                 $fecha_fin_capa_array = $this->input->post('fecha_fin_capa_array');
                 $hora_duracion_capa_array = $this->input->post('hora_duracion_capa_array');
                 $costo_capa_array = $this->input->post('costo_capa_array');   
                 $costo_cubierto_insa_array = $this->input->post('costo_cubierto_insa_array');
                 $costo_cubierto_prov_array = $this->input->post('costo_cubierto_prov_array');            
                 $estado_capa_array = $this->input->post('estado_capa_array');            
                 
                 //obtener los detalles antiguos
                 $capacitaciones_antiguos = $this->gsatelite->get_tabla('cpe_capacitacion_empleado', array('cpe_id_emp' => $emp_id));
                 
                 //eliminacion de insumos que no existen 
                 foreach ($capacitaciones_antiguos as $capa) {
                     if (!in_array($capa['cpe_id'], $new)) {
                         $this->gsatelite->actualizar_array('cpe_capacitacion_empleado', array('cpe_estado' => 0),array('cpe_id' => $capa['cpe_id']));
                     }
                 }

                 foreach ($nombre_capa_array as $key => $nomca) {
                     if(trim($nomca)){
                         if ( $new[$key] == "" ) {
                             $array_cpe_capacitacion_empleado = array(                                                         
                                 'cpe_id_emp' => $emp_id,
                                 'cpe_id_ese' => is_numeric($estado_capa_array[$key])? $estado_capa_array[$key]:null,
                                 'cpe_id_icp' => is_numeric($institucion_capa_array[$key])? $institucion_capa_array[$key]:null,
                                 'cpe_nombre' => $nomca,
                                 'cpe_duracion' => ($hora_duracion_capa_array[$key] != "") ? $hora_duracion_capa_array[$key] : 0,
                                 'cpe_costo_empresa' => ($costo_capa_array[$key] != "") ? $costo_capa_array[$key] : 0,
                                 'cpe_costo_insaforp' => ($costo_cubierto_insa_array[$key] != "") ? $costo_cubierto_insa_array[$key] : 0,
                                 'cpe_costo_proveedor' => ($costo_cubierto_prov_array[$key] != "") ? $costo_cubierto_prov_array[$key] : 0,
                                 'cpe_fecha_inicio' => formatear_fecha('Y-m-d', $fecha_inicio_capa_array[$key]),
                                 'cpe_fecha_fin' => formatear_fecha('Y-m-d', $fecha_fin_capa_array[$key]),                                 
                                 'cpe_estado' => 1,
                                 'cpe_usu_creacion' => $this->tank_auth->get_user_id(),
                                 'cpe_usu_modificacion' => $this->tank_auth->get_user_id(),
                                 'cpe_fecha_creacion' => date('Y-m-d H:i:s'),
                                 'cpe_fecha_modificacion' => date('Y-m-d H:i:s')
                             );
                             $this->gsatelite->ingresar('cpe_capacitacion_empleado', $array_cpe_capacitacion_empleado);
                         } else {
                             $array_cpe_capacitacion_empleado = array(                                                         
                                 'cpe_id_emp' => $emp_id,
                                 'cpe_id_ese' => is_numeric($estado_capa_array[$key])? $estado_capa_array[$key]:null,
                                 'cpe_id_icp' => is_numeric($institucion_capa_array[$key])? $institucion_capa_array[$key]:null,
                                 'cpe_nombre' => $nomca,
                                 'cpe_duracion' => ($hora_duracion_capa_array[$key] != "") ? $hora_duracion_capa_array[$key] : 0,
                                 'cpe_costo_empresa' => ($costo_capa_array[$key] != "") ? $costo_capa_array[$key] : 0,
                                 'cpe_costo_insaforp' => ($costo_cubierto_insa_array[$key] != "") ? $costo_cubierto_insa_array[$key] : 0,
                                 'cpe_costo_proveedor' => ($costo_cubierto_prov_array[$key] != "") ? $costo_cubierto_prov_array[$key] : 0,
                                 'cpe_fecha_inicio' => formatear_fecha('Y-m-d', $fecha_inicio_capa_array[$key]),
                                 'cpe_fecha_fin' => formatear_fecha('Y-m-d', $fecha_fin_capa_array[$key]),                                 
                                 'cpe_estado' => 1,
                                 //'cpe_usu_creacion' => $this->tank_auth->get_user_id(),
                                 'cpe_usu_modificacion' => $this->tank_auth->get_user_id(),
                                 //'cpe_fecha_creacion' => date('Y-m-d H:i:s'),
                                 'cpe_fecha_modificacion' => date('Y-m-d H:i:s')
                             );    
                             $this->gsatelite->actualizar_array('cpe_capacitacion_empleado', $array_cpe_capacitacion_empleado, array('cpe_id' => $new[$key]));
                         }                    
                     }
                 }            
                 /* =================================================================================================================
                 =                              FIN EDITAR CAPACITACIONES
                 ===================================================================================================================
                 */                            


              /* =================================================================================================================
                =                              INICIO GUARDADO DE AGRUPACIONES EMPLEADO
                ===================================================================================================================
               */
            $this->gsatelite->borrado_general('age_agrupacion_empleado',array('age_id_emp'=>$emp_id));
              $agrupacion_emp = $this->input->post('agrupacion_emp');
              $anio_afiliacion = $this->input->post('anio_afiliacion');
              $estado_afiliacion = $this->input->post('estado_afiliacion');

              for ($agru_emp=0; $agru_emp < count($agrupacion_emp) ; $agru_emp++) { 
                  if (trim($agrupacion_emp[$agru_emp]) != '') {
                     $array_insert_reg = array(
                      'age_nombre' => $agrupacion_emp[$agru_emp],
                      'age_anio_afiliacion' => ($anio_afiliacion[$agru_emp] >0)? $anio_afiliacion[$agru_emp]:null,
                      'age_estado_agrupacion' => ($estado_afiliacion[$agru_emp] >0)? 1:0,
                      'age_id_emp' => $emp_id,
                      'age_estado' => 1,
                      'age_usu_creacion' => $this->tank_auth->get_user_id(),
                      'age_usu_modificacion' => $this->tank_auth->get_user_id(),
                      'age_fecha_creacion' => date('Y-m-d H:i:s'),
                      'age_fecha_modificacion' => date('Y-m-d H:i:s')
                     );

                     $id_age = $this->gsatelite->ingresar('age_agrupacion_empleado', $array_insert_reg);
                  }
              }

              /* =================================================================================================================
                =                              FIN GUARDADO DE AGRUPACIONES EMPLEADO
                ===================================================================================================================
               */

             /* =================================================================================================================
             =                              INICIO GUARDADO DE SERVICION BASICOS EMPLEADO
             ===================================================================================================================
            */
                $this->gsatelite->borrado_general('sre_servicio_empleado',array('sre_id_emp'=>$emp_id));
                 $slcServiciosBasicos = $this->input->post('slcServiciosBasicos');
                 for ($sbi = 0; $sbi < count($slcServiciosBasicos); $sbi++) {
                     if ($slcServiciosBasicos[$sbi] > 0 ) {
                         $array_insert_reg = array(
                          'sre_id_srb' => $slcServiciosBasicos[$sbi],
                          'sre_id_emp' => $emp_id,
                          'sre_estado' => 1,
                          'sre_usu_creacion' => $this->tank_auth->get_user_id(),
                          'sre_usu_modificacion' => $this->tank_auth->get_user_id(),
                          'sre_fecha_creacion' => date('Y-m-d H:i:s'),
                          'sre_fecha_modificacion' => date('Y-m-d H:i:s')
                         );

                         $id_sre = $this->gsatelite->ingresar('sre_servicio_empleado', $array_insert_reg);
                     }
                 }

              /* =================================================================================================================
              =                              FIN GUARDADO DE SERVICION BASICOS EMPLEADO
              ===================================================================================================================
             */
            //entrevista
                 $this->gsatelite->borrado_general('enm_entrevista_empleado',array('enm_id_emp'=>$emp_id));
                  $enm_id = $this->input->post('enm_id');
                  $tipo_entrevista = $this->input->post('tipo_entrevista');
                  $fecha_entrevista = $this->input->post('fecha_gen');
                  $lugar_entrevista = $this->input->post('lugar_ent');
                  $ponderacion_entrevista = $this->input->post('ponde_ent');
                  $descripcion_entrevista = $this->input->post('descr_ent');
                  $nombre_realizo = $this->input->post('nom_entre');

                  foreach ($enm_id as $key => $value) {
                      $array_entrevista = array(                                                  
                          'enm_id_tnv' => $tipo_entrevista[$key],
                          'enm_id_emp' => $emp_id,
                          'enm_fecha' => formatear_fecha("Y-m-d",$fecha_entrevista[$key]),
                          'enm_persona_realiza' => $nombre_realizo[$key],
                          'enm_lugar' => $lugar_entrevista[$key],
                          'enm_ponderacion' => $ponderacion_entrevista[$key],
                          'enm_descripcion' => $descripcion_entrevista[$key],                      
                          'enm_estado' => 1,
                          'enm_usu_creacion' => $this->tank_auth->get_user_id(),
                          'enm_usu_modificacion' => $this->tank_auth->get_user_id(),
                          'enm_fecha_creacion' => date('Y-m-d H:i:s'),
                          'enm_fecha_modificacion' => date('Y-m-d H:i:s')
                      );
                      $id_enm = $this->gsatelite->ingresar('enm_entrevista_empleado', $array_entrevista);                    
                  }

                  //PRUEBASSSSSS
                  $this->gsatelite->borrado_general('pbe_prueba_empleado',array('pbe_id_emp'=>$emp_id));
                  $pbe_id = $this->input->post('pbe_id');
                  $tipo_prueba = $this->input->post('tipo_prueba');
                  $nombre_realizo_prueba = $this->input->post('nom_prueba');
                  $fecha_prueba = $this->input->post('fecha_prueba');
                  $lugar_prueba = $this->input->post('lugar_prueba');
                  $nota_prueba = $this->input->post('nota_prueba');
                  $descripcion_prueba = $this->input->post('descr_prueba');

                  foreach ($pbe_id as $key => $value) {
                      $array_prueba = array(                                                  
                          'pbe_id_tib' => $tipo_prueba[$key],
                          'pbe_id_emp' => $emp_id,
                          'pbe_fecha' => formatear_fecha("Y-m-d",$fecha_prueba[$key]),
                          'pbe_persona_califica' => $nombre_realizo_prueba[$key],
                          'pbe_lugar' => $lugar_prueba[$key],
                          'pbe_resultado' => $nota_prueba[$key],
                          'pbe_descripcion' => $descripcion_prueba[$key],                      
                          'pbe_estado' => 1,
                          'pbe_usu_creacion' => $this->tank_auth->get_user_id(),
                          'pbe_usu_modificacion' => $this->tank_auth->get_user_id(),
                          'pbe_fecha_creacion' => date('Y-m-d H:i:s'),
                          'pbe_fecha_modificacion' => date('Y-m-d H:i:s')
                      );
                      $id_pbe = $this->gsatelite->ingresar('pbe_prueba_empleado', $array_prueba);                    
                  }


            /* ===============================================================================================================================
              =											ACTUALIZACION
              =================================================================================================================================
             */

            $rutas = $this->input->post("ruta");
            $carpeta = $this->input->post("nombreCarpeta");

            if (count($rutas) > 0) {
                $carpeta = $carpeta;
                for ($i = 0; $i < count($rutas); $i++) {
                    if ($rutas[$i] != "") {
                        $img = $rutas[$i];
                        $titulo = $this->input->post("titulo_doc" . $i);
                        $this->datos_imagen_gral($img, $emp_id, $carpeta, $titulo);
                    }
                }
            }

            $id_foto = $this->input->post('id_foto');
            $foto_editar = $this->input->post('edit_foto');

            if (trim($foto_editar) != "") {
                $img = $foto_editar;
                $titulo = $this->input->post("titulo_edit");
                $eliminar = $this->input->post('foto_eliminar');
                if (!empty($eliminar)) {
                    $this->datos_reemplazar_imagen($img, $id_foto, $carpeta, $titulo, $eliminar, $emp_id);
                } else {
                    $this->datos_imagen_gral($foto_editar, $emp_id, $carpeta, $titulo, 1, 1);
                }
            }



            $dct = $this->input->post('dct');
            if ($dct == 1) {
                $docente_array = array(
                    'dct_estado' => $this->input->post('estado'),
                    'dct_usu_mod' => $this->tank_auth->get_user_id(),
                    'dct_fecha_mod' => date('Y-m-d H:i:s')
                );

                $id = $this->gsatelite->actualizar_array('dct_docente', $docente_array, array('dct_id_emp' => $emp_id));

                if ($id > 0) {
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "El registro fue actualizado correctamente", 'texto_alerta' => "Actualización de datos del docente completo");

                    $this->session->set_flashdata($alerta);
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "Hubo un problema al ingresar el registro");

                    $this->session->set_flashdata($alerta);
                }

                redirect('registro_academico/procesos/index_agregar_docente');
            } else {

                $redireccion = $this->input->post('redireccion');
                $redireccion = $this->input->post('redireccion');
                $id          = $this->input->post('id');
                $tipo        = $this->input->post('txttipo');
                $alerta      = array('tipo_alerta' => 'success', 'titulo_alerta' => "El registro fue actualizado correctamente", 'texto_alerta' => "Actualización de datos del empleado completo");

                $this->session->set_flashdata($alerta);
                
                if ($redireccion == 1) {
                    $redirect = ($this->input->post('txtredirect'))? "actualizar_ficha/$id" : "editar_empleado/$id/$tipo";
                    if($this->input->post('txtadnb') == 2){
                        redirect("auto_gestion/acciones/$redirect");
                    }
                    redirect("expediente_personal/empleado/$redirect");
                } else {
                    $redirect = ($this->input->post('txtredirect'))? "ultima_actualizacion" : "index_agregar_empleado";
                    if($this->input->post('txtadnb') == 2){
                        redirect("auto_gestion/acciones/$redirect?resultado=1");
                    }
                    redirect("expediente_personal/empleado/$redirect?resultado=1");
                }
            }
        }
    }

    function datos_reemplazar_imagen($img, $id_foto, $carpeta, $titulo, $eliminar, $emp_id) {
        unlink($eliminar);
        $extencion = end(explode(".", $img));
        $datos_1 = $this->session->keep_flashdata('datos_1');
        $nombre = trim($img);
        $ruta = "public/temp/" . $carpeta . "/" . $nombre;
        $destino = "uploads/anexos_empleados/" . $titulo . "." . trim($extencion) . "";
        $array = array('anx_nombre' => $titulo,
            'anx_url' => $destino,
            'anx_usu_mod' => $this->tank_auth->get_user_id(),
            'anx_fecha_mod' => date('Y-m-d H:i:s'));
        $this->db->where('anx_id', $id_foto)
                ->update('anx_anexo', $array);
        $carpeta_destino = "uploads/anexos_empleados/" . $titulo . "." . trim($extencion) . "";
        $nuevo_valor = (end(explode('/', $titulo)) == "userempty_png") ? null : $destino;
        copy($ruta, $carpeta_destino);
        unlink($ruta);
        $this->gsatelite->actualizar_array('emp_empleado', array('emp_url_foto' => $nuevo_valor), array('emp_id' => $emp_id));
    }

    public function check_documento($tipo = 1) {
        if ($tipo == 1) {
            if ($this->input->post('doc') != null and $this->input->post('doc') != "") {
                $result = $this->gsatelite->get_tabla('dce_documento_emp', array('dce_valor' => $this->input->post('doc')
                    , 'dce_id_tde' => $this->input->post('Tdoc')));

                if (count($result) > 0) {
                    print json_encode(
                                    array('exists' => true)
                    );
                } else {
                    print json_encode(
                                    array('exists' => false)
                    );
                }
            }
        } elseif ($tipo == 2) {
            if ($this->input->post('cod') != null and $this->input->post('cod') != "") {
                $result = $this->gsatelite->get_tabla('emp_empleado', array('emp_codigo' => $this->input->post('cod')));

                if (count($result) > 0) {
                    print json_encode(
                                    array('exists' => true)
                    );
                } else {
                    print json_encode(
                                    array('exists' => false)
                    );
                }
            }
        }
    }

    /**
     * @author René Castaneda
     * @return Mantenimiento documentos por empleado
     */
    function documentos_empleado_crud($id_empleado = null, $ver_detalle = null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            try {
                $crud = new grocery_CRUD();
                $this->load->config('grocery_crud');
                $this->config->set_item('grocery_crud_file_upload_allow_file_types', 'pdf|jpeg|jpg|png');
                $crud->set_table('dce_documento_emp')
                        ->set_subject('Documento')
                        ->where('dce_documento_emp.dce_id_emp', $id_empleado)
                        ->columns('dce_id_tde', 'dce_valor', 'dce_fecha_vence', 'dce_fecha_expedicion', 'dce_lugar_expedicion', 'dce_url','dce_nombre_segun_doc','dce_id_mun')
                        ->set_relation('dce_id_tde', 'tde_tipo_documento', 'tde_nombre', array('tde_estado' => 1))
                        ->set_relation('dce_id_mun','mun_municipio','mun_nombre', array('mun_estado' => 1))
                        ->add_fields('dce_id_tde', 'dce_id_emp', 'dce_valor', 'dce_fecha_vence', 'dce_fecha_expedicion', 'dce_lugar_expedicion', 'dce_fecha_registro', 'dce_url', 'dce_nombre_anexo','dce_nombre_segun_doc','dce_observacion','dce_usu_modificacion', 'dce_fecha_modificacion', 'dce_usu_creacion', 'dce_fecha_creacion','dce_id_mun')
                        ->edit_fields('dce_id_tde', 'dce_id_emp', 'dce_valor', 'dce_fecha_vence', 'dce_fecha_expedicion', 'dce_lugar_expedicion', 'dce_url', 'dce_nombre_anexo','dce_nombre_segun_doc','dce_observacion', 'dce_usu_modificacion', 'dce_fecha_modificacion', 'dce_id_mun')
                        ->display_as('dce_id_tde', 'Documento')
                        ->display_as('dce_valor', 'Número de Documento')
                        ->display_as('dce_fecha_vence', 'Vence')
                        ->display_as('dce_fecha_expedicion', 'Fecha<br/>Expedición')
                        ->display_as('dce_lugar_expedicion', 'Lugar<br/>Expedición')
                        ->display_as('dce_id_mun', 'Municipio<br/>Expedición')
                        ->display_as('dce_url', 'Anexo')
                        ->display_as('dce_nombre_anexo', 'Titulo<br/>Anexo')
                        ->display_as('dce_nombre_segun_doc', 'Nombre<br/>según Doc')
                        ->display_as('dce_observacion', 'Observaciones')
                        ->required_fields('dce_id_tde', 'dce_valor')
                       // ->set_rules('dce_valor', 'Valor', 'trim|required|campo_unico[dce_documento_emp.dce_valor]')
                        ->set_rules('dce_id_tde', 'Documento', "trim|required|campo_unico2[dce_documento_emp.dce_id_tde.dce_id_emp.$id_empleado]")
                        ->field_type('dce_id_emp', 'hidden', $id_empleado)
                        ->field_type('dce_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                        ->field_type('dce_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
                        ->field_type('dce_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                        ->field_type('dce_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
                        ->field_type('dce_fecha_registro', 'hidden', date('Y-m-d'))
                        ->field_type('dce_estado', 'hidden', 1)                        
                        ->set_field_upload('dce_url', 'uploads/anexos_empleados')
                        ->callback_add_field('dce_fecha_vence', function () {
                            return '<input id="field-dce_fecha_vence" name="dce_fecha_vence" type="text" value="" maxlength="10" class="datePicker" placeholder="dd-mm-yyyy">';
                        })
                        ->callback_edit_field('dce_fecha_vence', function ($value, $row) {
                            $fecha = implode('-', array_reverse(explode('-', $value)));
                            return '<input type="text" value="'.$fecha.'" id="field-dce_fecha_vence" class="datePicker" name="dce_fecha_vence" placeholder="dd-mm-yyyy">';
                        })
                        ->callback_add_field('dce_fecha_expedicion', function () {
                            return '<input id="field-dce_fecha_expedicion" name="dce_fecha_expedicion" type="text" value="" maxlength="10" class="datePicker" placeholder="dd-mm-yyyy">';
                        })
                        ->callback_edit_field('dce_fecha_expedicion', function ($value, $row) {
                            $fecha = implode('-', array_reverse(explode('-', $value)));
                            return '<input type="text" value="'.$fecha.'" id="field-dce_fecha_expedicion" class="datePicker" name="dce_fecha_expedicion" placeholder="dd-mm-yyyy">';
                        })
                        ->callback_before_insert(function($post_array) {
                            if ($post_array['dce_fecha_vence'] != "") {
                                $post_array['dce_fecha_vence'] = implode('-', array_reverse(explode('-', $post_array['dce_fecha_vence'])));
                            }
                            if ($post_array['dce_fecha_expedicion'] != "") {
                                $post_array['dce_fecha_expedicion'] = implode('-', array_reverse(explode('-', $post_array['dce_fecha_expedicion'])));
                            }
                            return $post_array;
                        })
                        ->callback_before_update(function($post_array, $primary_key) {
                            if ($post_array['dce_fecha_vence'] != "") {
                                $post_array['dce_fecha_vence'] = implode('-', array_reverse(explode('-', $post_array['dce_fecha_vence'])));
                            }
                            if ($post_array['dce_fecha_expedicion'] != "") {
                                $post_array['dce_fecha_expedicion'] = implode('-', array_reverse(explode('-', $post_array['dce_fecha_expedicion'])));
                            }
                            return $post_array;
                        })
                        ->callback_column('dce_fecha_vence', function($value, $row) {
                            if ($value != "") {
                                return implode('-', array_reverse(explode('-', $value)));
                            } else {
                                return '';
                            }
                        })
                        ->callback_column('dce_fecha_expedicion', function($value, $row) {
                            if ($value != "") {
                                return implode('-', array_reverse(explode('-', $value)));
                            } else {
                                return '';
                            }
                        })
                        // ->set_upload_file_types('jpg','jpeg','png','pdf') //pdf|jpg|png|jpeg'
                        //->unset_delete()
                        ->unset_print()
                        ->unset_export()
                ;
                if ($ver_detalle != null and is_numeric($ver_detalle)) {
                    $crud->unset_edit();
                    $crud->unset_delete();
                    $crud->unset_add();
                }
                
                $crud->add_action('Ver', 'minia-icon-search', "expediente_personal/empleado/documentos_empleado_crud/$id_empleado/read");
                // $data['array_documento'] = $this->gsatelite->get_tabla("tde_tipo_documento");
                $data['id_empleado'] = $id_empleado;
                $output = $crud->render();
                $output = array_merge($data, (array) $output);
                $this->gsatelite->cargar_vista_masterpage('expediente_personal/empleado/documentos_empleado_crud', $output);
            } catch (Exception $e) {
                show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
            }
        }
    }

    function documentos_solicitante_crud($id_empleado = null, $ver_detalle = null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            try {

                $crud = new grocery_CRUD();
                $this->load->config('grocery_crud');
                $this->config->set_item('grocery_crud_file_upload_allow_file_types', 'pdf|jpeg|jpg|png');

                $crud->set_table('dcs_documento_solicitante')
                        ->set_subject('Documentos')
                        ->where('dcs_documento_solicitante.dcs_id_sle', $id_empleado)
                        ->columns('dcs_id_tde', 'dcs_valor', 'dcs_fecha_vence', 'dcs_fecha_expedicion', 'dcs_lugar_expedicion', 'dcs_url','dcs_nombre_segun_doc','dcs_id_mun')
                        ->set_relation('dcs_id_tde', 'tde_tipo_documento', 'tde_nombre', array('tde_estado' => 1))
                        ->set_relation('dcs_id_mun','mun_municipio','mun_nombre')
                        ->add_fields('dcs_id_tde', 'dcs_id_sle', 'dcs_valor', 'dcs_fecha_vence', 'dcs_fecha_expedicion', 'dcs_lugar_expedicion', 'dcs_fecha_registro', 'dcs_url', 'dcs_nombre_anexo','dcs_nombre_segun_doc','dcs_observacion','dcs_usu_modificacion', 'dcs_fecha_modificacion', 'dcs_usu_creacion', 'dcs_fecha_creacion','dcs_id_mun','dcs_estado')
                        ->edit_fields('dcs_id_tde', 'dcs_id_emp', 'dcs_valor', 'dcs_fecha_vence', 'dcs_fecha_expedicion', 'dcs_lugar_expedicion', 'dcs_url', 'dcs_nombre_anexo','dcs_nombre_segun_doc','dcs_observacion', 'dcs_usu_modificacion', 'dcs_fecha_modificacion', 'dcs_id_mun','dcs_estado')
                        ->display_as('dcs_id_tde', 'Documento')
                        ->display_as('dcs_valor', 'Valor')
                        ->display_as('dcs_fecha_vence', 'Vence')
                        ->display_as('dcs_fecha_expedicion', 'Fecha<br/>Expedición')
                        ->display_as('dcs_lugar_expedicion', 'Lugar<br/>Expedición')
                        ->display_as('dcs_id_mun', 'Municipio<br/>Expedición')
                        ->display_as('dcs_url', 'Anexo')
                        ->display_as('dcs_nombre_anexo', 'Titulo<br/>Anexo')
                        ->display_as('dcs_nombre_segun_doc', 'Nombre<br/>según Doc')
                        ->display_as('dcs_observacion', 'Observaciones')
                        ->required_fields('dcs_id_tde', 'dcs_valor')
                       // ->set_rules('dce_valor', 'Valor', 'trim|required|campo_unico[dce_documento_emp.dce_valor]')
                        ->set_rules('dcs_id_tde', 'Documento', "trim|required|campo_unico2[dcs_documento_solicitante.dcs_id_tde.dcs_id_sle.$id_empleado]")
                        ->field_type('dcs_id_sle', 'hidden', $id_empleado)
                        ->field_type('dcs_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                        ->field_type('dcs_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
                        ->field_type('dcs_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                        ->field_type('dcs_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
                        ->field_type('dcs_fecha_registro', 'hidden', date('Y-m-d'))
                        ->field_type('dcs_estado', 'hidden', 1)                        
                        ->set_field_upload('dcs_url', 'uploads/anexos_empleados')
                        ->callback_before_insert(function($post_array, $primary_key) {
                            if ($post_array['dcs_fecha_vence'] != "") {
                                $post_array['dcs_fecha_vence'] = implode('-', array_reverse(explode('-', $post_array['dce_fecha_vence'])));
                            }
                            if ($post_array['dcs_fecha_expedicion'] != "") {
                                $post_array['dcs_fecha_expedicion'] = implode('-', array_reverse(explode('-', $post_array['dce_fecha_expedicion'])));
                            }
                            return $post_array;
                        })
                        ->callback_before_update(function($post_array, $primary_key) {
                            if ($post_array['dcs_fecha_vence'] != "") {
                                $post_array['dcs_fecha_vence'] = implode('-', array_reverse(explode('-', $post_array['dce_fecha_vence'])));
                            }
                            if ($post_array['dcs_fecha_expedicion'] != "") {
                                $post_array['dcs_fecha_expedicion'] = implode('-', array_reverse(explode('-', $post_array['dce_fecha_expedicion'])));
                            }
                            return $post_array;
                        })
                        ->callback_column('dcs_fecha_vence', function($value, $row) {
                            if ($value != "") {
                                return implode('-', array_reverse(explode('-', $value)));
                            } else {
                                return '';
                            }
                        })
                        ->callback_column('dcs_fecha_expedicion', function($value, $row) {
                            if ($value != "") {
                                return implode('-', array_reverse(explode('-', $value)));
                            } else {
                                return '';
                            }
                        })
                        // ->set_upload_file_types('jpg','jpeg','png','pdf') //pdf|jpg|png|jpeg'
                        //->unset_delete()
                        ->unset_print()
                        ->unset_export()
                ;
                if ($ver_detalle != null && is_numeric($ver_detalle)) {
                    $crud->unset_edit();
                    $crud->unset_delete();
                    $crud->unset_add();
                }
                $crud->add_action('Ver', 'minia-icon-search', "expediente_personal/empleado/documentos_solicitante_crud/$id_empleado/read");
                $data['array_documento'] = $this->gsatelite->get_tabla("tde_tipo_documento");
                $data['id_empleado'] = $id_empleado;
                $output = $crud->render();
                $output = array_merge($data, (array) $output);

                $this->gsatelite->cargar_vista_masterpage('expediente_personal/empleado/documentos_solicitante_crud', $output);
            } catch (Exception $e) {
                show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
            }
        }
    }


    /*
     * *AUTOR: Christian Menendez
     * *DESCRIPCION: registra los docentes
     */

    public function agregar_docente() {
        $this->_cargarvista();
    }

    public function eliminar_anexemp($anexo = null, $emp = null) {
        if ($_POST) {
            $anexo = $this->input->post('anexo');
            $emp = $this->input->post('emp');
        }
        if ($anexo != null && $emp != null) {
            $axe = $this->gsatelite->borrado_general('axe_anexoxempleado', array('axe_id_emp' => $emp, 'axe_id_anx' => $anexo));

            $where_anx = array('anx_id' => $anexo);
            $url = $this->gsatelite->get_campo('anx_anexo', 'anx_url', $where_anx);
            $result = $this->gsatelite->borrado_general('anx_anexo', $where_anx);
            if (unlink($url)) {
                echo $result;
            }
        }
    }

    function validar_ponderaciones($post_array) {

        // $ponderacion = $this->input->post('prs_porcentaje_seguro');
        $ponderacion = $post_array['prs_porcentaje'];
        $sxe = $post_array['prs_id_sxe'];

        $seg = $this->gsatelite->get_campo('sxe_seguroxempleado', 'sxe_id_seg', array('sxe_id' => $sxe));
        $emp = $this->gsatelite->get_campo('sxe_seguroxempleado', 'sxe_id_emp', array('sxe_id' => $sxe));

        //die(print_r($post_array).print_r($ponderacion.'/'.$seg.'/'.$emp.'/'));
        if (!is_numeric(end(explode('/', uri_string())))) {



            $where = array('sxe_id_seg' => $seg, 'sxe_id_emp' => $emp);
            $this->db->where($where);
            $this->db->join('sxe_seguroxempleado', 'sxe_id=prs_id_sxe');
            $suma_pod = $this->gsatelite->get_suma('prs_porcentaje_seguro', 'prs_porcentaje');
        } else {
            $id = end(explode('/', uri_string()));
            $where = array('sxe_id_seg' => $seg, 'sxe_id_emp' => $emp, 'prs_id <>' => $id);
            $this->db->where($where);
            $this->db->join('sxe_seguroxempleado', 'sxe_id=prs_id_sxe');
            $suma_pod = $this->gsatelite->get_suma('prs_porcentaje_seguro', 'prs_porcentaje');

            // $suma_pod = $this->gsatelite->get_suma('prs_porcentaje_seguro','prs_porcentaje','prs_id <>'.$id);   
        }

        $suma_pod += $ponderacion;


        if (floatval($suma_pod) > 100) {
            return false;
        } else {

            return true;
        }
    }

    function validar_seguro($post_array) {
        $fam = $this->input->post('prs_id_fam');
        $sxe = $this->input->post('prs_id_sxe');

        if (!is_numeric(end(explode('/', uri_string())))) {
            $familiar = $this->gsatelite->get_tabla('prs_porcentaje_seguro', array('prs_id_sxe' => $sxe, 'prs_id_fam' => $fam));
        } else {
            $id = end(explode('/', uri_string()));
            $familiar = $this->gsatelite->get_tabla('prs_porcentaje_seguro', array('prs_id_sxe' => $sxe, 'prs_id_fam' => $fam, 'prs_id <>' => $id));
        }

        if (count($familiar) > 0) {
            $this->form_validation->set_message('validar_seguro', 'El Tipo Seguro ya esta asignado a este familiar');
            return false;
        }
    }

    function validar_fecha($fecha) {
        $dia = Date("d");
        $mes = Date("m");
        $anio = Date("Y");

        $dia1 = Date('d', strtotime($fecha));
        $mes1 = Date('m', strtotime($fecha));
        $anio1 = Date('Y', strtotime($fecha));
        $regresar = false;


        if (!($anio1 > $anio)) {
            if ($anio1 == $anio) {
                if (!($mes1 > $mes)) {
                    if ($mes1 == $mes) {
                        if ($dia1 > $dia) {
                            if ($dia1 == $dia) {
                                $regresar = true;
                            }
                        } else {
                            $regresar = true;
                        }
                    } else {
                        $regresar = true;
                    }
                }
            } else {
                $regresar = true;
            }
        }
        return $regresar;
    }

    function get_plazasxdepto($emp = null) {
        satelite_validar();
        $depto = $this->input->post('depto');
        if ($emp) {
            $actual = $this->gsatelite->get_campo('emp_empleado', 'emp_id_plz', array('emp_id' => $emp));
            $arreglo_ids = $this->expediente_personal_model->get_permitidos_plaza($actual);
            $excluir = implode(',', $arreglo_ids);
        } else {
            $emp_plz = $this->gsatelite->get_tabla('emp_empleado', array('emp_estado' => 1, 'emp_id_plz IS NOT NULL' => NULL));
            $excluir = (count($emp_plz) > 0) ? implode(',', array_unique(array_column($emp_plz, 'emp_id_plz'))) : 0;
        }
        $where = array("plz_estado" => 1, "plz_id NOT IN ($excluir)" => null);
        if($depto > 0){
            $where['plz_id_are'] = $depto;
            $plazas = $this->gsatelite->get_dropdown('plz_plaza', '{plz_nombre}', '', $where, null, null, 'plz_id', true);
        }else{
            $plazas = $this->gsatelite->get_dropdown('plz_plaza', '{plz_nombre}', '', $where, null, null, 'plz_id', true);
        }
        $plazas_area = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $plazas);        
        echo $plazas_area;
    }

    public function get_deptoxplaza(){
        $actual = $this->gsatelite->get_campo('plz_plaza', 'plz_id_are', array('plz_id' => $this->input->post('plaza')));
        $actual = ($actual != "") ? $actual : null;
                $this->db->join('mxr_empresaxarea', 'mxr_id_are = are_id');
        $area = $this->gsatelite->get_dropdown('are_area', '{are_nombre}', '', array('mxr_id_emr' => $this->tank_auth->get_empresa_id()), $actual, null, 'are_id', true);
        echo str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $area);
    }

    public function info_salario(){
        $texto = $prom = "";
                $this->db->join('pto_puesto', 'pto_id = plz_id_pto');
                $this->db->join('cts_categoria_salarial', 'cts_id = pto_id_cts');
        $info = $this->gsatelite->get_tabla('plz_plaza', array('plz_id' => $this->input->post('plaza')));
        if (count($info) > 0) {
            $smb = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', '');
            if (is_numeric($info[0]['cts_salario_minimo'])) {
                $texto .= "Categoría Salarial, Mínimo: " . $smb . number_format($info[0]['cts_salario_minimo'],2);
            }
            if (is_numeric($info[0]['cts_salario_maximo'])) {
                if ($texto != "") {
                    $texto .= " | ";
                    $texto .= "Máximo: " . $smb . number_format($info[0]['cts_salario_maximo'],2);
                } else {
                    $texto .= "Categoría Salarial,Máximo: " . $smb . number_format($info[0]['cts_salario_maximo'],2);
                }
            }
            if (is_numeric($info[0]['cts_salario_medio'])) {
                $prom = number_format($info[0]['cts_salario_medio'],2);
            }
        }
        echo json_encode(array('texto' => $texto, 'promedio' => $prom));
    }

    /**
    * @author René Castaneda
    * @since 2017-12-09
    * @return filtrar los municipios dependiendo del departamento
     */
    public function filtrar_municipio_option()
    {
        $where['mun_id_dep'] = $this->input->post('slcDepartamento');
        $dropdown = $this->gsatelite->get_dropdown('mun_municipio', '{mun_nombre}','', $where, null, '', 'mun_id', true);
        $data['options'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $dropdown);
        die(json_encode($data));
    }

    function filtrar_insumoxtipo() {
        satelite_validar();

        $tip_insu = $this->input->post('tip_insu');

        $insumos = $this->gsatelite->get_dropdown('inm_insumo', '{inm_nombre}', '', array('inm_estado' => 1, 'inm_id_tim' => $tip_insu), null, null, 'inm_id', true);
        $slcinsumos = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $insumos);

        echo $slcinsumos;
    }

    public function get_empleadoxcodigo()
    {   
        $codigo_emp = $this->input->post('codigo_emp');
        $emp_id = $this->input->post('emp_id');
        $where = [];
        $where['emp_id != '] = $emp_id;        
        $where["(emp_codigo LIKE '%". $codigo_emp."%' OR emp_nombre LIKE '%". $codigo_emp."%' OR emp_nombre LIKE '%". $codigo_emp."%')"] = null;
                
        $empleado = $this->expediente_personal_model->get_empleadoxcodigo($codigo_emp, $where);        
        echo json_encode($empleado);
    }

    public function get_empleadoxid()
    {
        $emp_id = $this->input->post('emp_id');
        $empleado = $this->expediente_personal_model->get_empleadoxid(array('emp_id' => $emp_id));
        echo json_encode($empleado);
    }

    /**
    * @author René Castaneda
    * @since 2017-12-19
    * @return Historial del empleado
     */
    public function historial_empleado($id_empleado = 0 )
    {
        satelite_validar();
        $this->gsatelite->verificar_registro_real('emp_empleado', $id_empleado);
        $data['titulo_personal'] = "Historial Empleada/o";
        $registro_empleado = $this->gsatelite->get_tabla('emp_empleado', array('emp_id'=>$id_empleado));
        $data['registro_empleado'] = $registro_empleado[0];
        $data['plazas_salario_emp'] = $this->expediente_personal_model->get_plaza_salario_emp(array('pps_id_emp'=>$id_empleado));
        cargarvista($data);
    }

    /**
    * @author René Castaneda
    * @since 2017-12-19
    * @return vista para la Carga masiva de insumos a empleados
     */
    public function carga_masiva_insumo()
    {
        satelite_validar();
        if($_FILES){
            ini_set( 'memory_limit', '2048M' );
            ini_set('max_execution_time', '9999');  
            
            $file = fopen($_FILES['csv_insumos']['tmp_name'], "r");
            $cabezera = fgetcsv($file);
            $cabezera_array = explode(';', $cabezera[0]);
            if(count($cabezera_array) == 5){
                $insumos_array = array();

                while (! feof($file)){
                    $registro = fgetcsv($file);
                    $datos_reg = explode(';', $registro[0]);
                    if (count($datos_reg) == 5 ) {
                        //validar que es un registro valido
                        $valido = 1;
                        $reg_insumo = $this->expediente_personal_model->get_insumo(array('inm_id'=>$datos_reg[0]));
                        $reg_emp = $this->gsatelite->get_tabla('emp_empleado',array('emp_codigo'=>trim($datos_reg[1]), 'emp_id_emr' => $this->tank_auth->get_empresa_id()));
                        if ( count($reg_insumo) <= 0 or count($reg_emp)  <= 0 ) {
                           $valido = 0;
                        }
                        $array_datos['id_insumo'] = $datos_reg[0]; 
                        $array_datos['codigo_emp'] = $datos_reg[1]; 
                        $array_datos['cantidad'] = $datos_reg[2]; 
                        $array_datos['costo_unitario'] = $datos_reg[3];
                        $array_datos['fecha_entrega'] = formatear_fecha('Y-m-d',$datos_reg[4]);
                        $array_datos['fecha_entregaf'] = formatear_fecha('d-m-Y',$datos_reg[4]);

                        $array_datos['id_empleado'] = ($reg_emp)? $reg_emp[0]['emp_id']:0;
                        $array_datos['nombre_insumo'] = ($reg_insumo)? $reg_insumo[0]['inm_nombre']:'no encontrado';
                        $array_datos['tipo_insumo'] = ($reg_insumo)? $reg_insumo[0]['tim_nombre']:'no encontrado';
                        $array_datos['codigo_empleado'] = ($reg_emp)? $reg_emp[0]['emp_codigo']:'no encontrado';
                        $array_datos['nombre_empleado'] = ($reg_emp)? $reg_emp[0]['emp_nombre'].' '.$reg_emp[0]['emp_apellido']:'no encontrado';
                        
                        $array_datos['valido'] = $valido; 
                        $insumos_array[] = $array_datos;
                    }
                }
                //print_r($insumos_array); die();
                $data['insumos_array'] = $insumos_array;

                
                
                $excel_data = '<br/><center><h4>(<em>'. $_FILES["csv_insumos"]["name"] .'</em>)</h4></center><br/>';
                $excel_data .='<div class="span6" style="margin-left:2%"><div style="width:15px;height:15px;background:rgb(242, 161, 161);"></div><div style="width:100%; margin:-3% 0 1% 6%"><h5>Los registros marcados en rojo son inválidos y no seran procesados.</h5></div></div><br/><br>
                               </div>';
                $excel_data.= $this->load->view('expediente_personal/empleado/tabla_csv_insumos',$data,true);
            }
            else{
                $excel_data .='<br/><center><h4>(<em>'. $_FILES["csv_insumos"]["name"] .'</em>)</h4></center><br/><center><h3>';
                $excel_data .='La hoja actual no cumple con el formato de columnas</h3><br/>';
                $excel_data .='<h4>Favor revisar documento csv y cantidad de columnas</h4></center><br/>';
            }

            fclose($file);

            $tabla_html = $excel_data;

            echo json_encode(array('drop'=>$tabla_html));
        } else {    
        $data['titulo_personal'] = "Carga masiva de insumos";
        cargarvista($data);
        }
    }

    /**
    * @author René Castaneda
    * @since 2017-12-19
    * @return procesamiento de datos de carga masiva de insumos
     */
    public function procesar_carga_insumos()
    {
        if ($this->input->post()) {
            //print_r($_POST); die();
            $datos_insumo = $this->input->post('datos_insumo');
            $n = count($datos_insumo);

            $auditoria = array(
                'ixe_estado' => 1,
                'ixe_usu_creacion' => $this->tank_auth->get_user_id(),
                'ixe_fecha_creacion' => date('Y-m-d H:i:s'),
                'ixe_usu_modificacion' => $this->tank_auth->get_user_id(),
                'ixe_fecha_modificacion' => date('Y-m-d H:i:s')
            );
            $exito = 0;
            for ($i=0; $i < $n ; $i++) { 
                $datos_array = (trim($datos_insumo[$i]) != '')? ((array) json_decode($datos_insumo[$i])):null;
                if (is_array($datos_array)) {
                    $array_insert =     array_merge($datos_array, $auditoria);
                    $id = $this->gsatelite->ingresar('ixe_insumoxempleado',$array_insert);
                    $exito++;
                }
            }

            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Carga masiva insumo", 'texto_alerta' => "La operación a sido realizada con éxito ($exito registros procesados)");
            $this->session->set_flashdata($alerta);
            redirect('expediente_personal/empleado/carga_masiva_insumo');


        } else {
            redirect('expediente_personal/empleado/carga_masiva_insumo');
        }
    }


    /**
     * @author René Castaneda
     * @since 2017-12-21
     * @return Proceso de retirar a un empleado
     * @description se cargará una funcionalidad centralizada en: acciones_personal/principal (funcion: retiro_personal )
      */
     public function retiro_personal() {
         if (!$this->tank_auth->is_logged_in()) {
             redirect('/auth/login/');
         } else {
             satelite_validar();
             $this->load->library('../controllers/acciones_personal/principal');
             $this->principal->retiro_personal('expediente_personal/empleado');
         }
     }

    public function notificacion_destitucion($emp_id, $rte_id) {
        $this->load->library('pdf');

		$data = [];

        $data['emp_id'] = $emp_id;
		$html_header = ''; 
		$html = $this->load->view('acciones_personal/principal/notificacion_destitucion', $data, true);
	  	
        $this->pdf->makePDF($html_header.$html, 'P');
    }


     /**
      * @author René Castaneda
      * @since 2017-12-21
      * @return Proceso de agregar retiro
      * @description se cargará una funcionalidad centralizada en: acciones_personal/principal (funcion: agregar_retiro )
       */
      public function agregar_retiro() {
          if (!$this->tank_auth->is_logged_in()) {
              redirect('/auth/login/');
          } else {
              satelite_validar();
              $this->load->library('../controllers/acciones_personal/principal');
              $this->principal->agregar_retiro('expediente_personal/empleado');
          }
      }

      /**
       * @author René Castaneda
       * @since 2017-12-21
       * @return Proceso de guardar retiro
       * @description se cargará una funcionalidad centralizada en: acciones_personal/principal (funcion: guardar_retiro )
        */
       public function guardar_retiro() {
           if (!$this->tank_auth->is_logged_in()) {
               redirect('/auth/login/');
           } else {
               satelite_validar();
               $this->load->library('../controllers/acciones_personal/principal');
               $this->principal->guardar_retiro('expediente_personal/empleado');
           }
       }

   /**
    * @author René Castaneda
    * @since 2017-12-21
    * @return Proceso de editar retiro
    * @description se cargará una funcionalidad centralizada en: acciones_personal/principal (funcion: editar_retiro_personal )
     */
    public function editar_retiro_personal($id_rte=0) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            satelite_validar();
            $this->load->library('../controllers/acciones_personal/principal');
            $this->principal->editar_retiro_personal($id_rte, 'expediente_personal/empleado');
        }
    }


    /**
     * @author René Castaneda
     * @since 2017-12-21
     * @return Proceso de guardar- la actualización de retiro
     * @description se cargará una funcionalidad centralizada en: acciones_personal/principal (funcion: actualizar_retiro )
      */
     public function actualizar_retiro() {
         if (!$this->tank_auth->is_logged_in()) {
             redirect('/auth/login/');
         } else {
             satelite_validar();
             $this->load->library('../controllers/acciones_personal/principal');
             $this->principal->actualizar_retiro('expediente_personal/empleado');
         }
     }


     /**
      * @author René Castaneda
      * @since 2017-12-21
      * @return Proceso de inactivar retiro
      * @description se cargará una funcionalidad centralizada en: acciones_personal/principal (funcion: inactivar_retiro )
       */
      public function inactivar_retiro($retiro_id=0) {
          if (!$this->tank_auth->is_logged_in()) {
              redirect('/auth/login/');
          } else {
              satelite_validar();
              $this->load->library('../controllers/acciones_personal/principal');
              $this->principal->inactivar_retiro($retiro_id, 'expediente_personal/empleado');
          }
      }

    /**
     * @author René Castaneda
     * @since 2017-12-21
     * @return Proceso de autorizar retiro
     * @description se cargará una funcionalidad centralizada en: acciones_personal/principal (funcion: autorizar_retiro )
      */
     public function autorizar_retiro($empleado_id=0, $retiro_id=0) {
         if (!$this->tank_auth->is_logged_in()) {
             redirect('/auth/login/');
         } else {
             satelite_validar();
             $this->load->library('../controllers/acciones_personal/principal');
             $this->principal->autorizar_retiro($empleado_id, $retiro_id, 'expediente_personal/empleado');
         }
     }


     /**
     * @author René Castaneda
     * @since 2018-04-17
     * @return filtrar y retirar empleados
      */
    public function retiro_masivo_empleados() {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();
        if ($this->input->post()) {
            // var_dump($_POST); die();
            $slcCategoriaRetiro = $this->input->post('slcCategoriaRetiro');
            $txtMotivoGeneral = $this->input->post('txtMotivoGeneral');
            $chkEmpleado = $this->input->post('chkEmpleado');
            $fecha_retiro = (trim($this->input->post('fecha_retiro')) != "") ? formatear_fecha('Y-m-d', $this->input->post('fecha_retiro')) : date("Y-m-d");
            $fecha_retiro .= ' ' . date('H:i:s');
            $n = count($chkEmpleado);
            $k=0;
            for ($i=0; $i < $n; $i++) {
                if ($chkEmpleado[$i] > 0 && $slcCategoriaRetiro > 0) {
                    $emp = $this->gsatelite->get_tabla('emp_empleado', array('emp_id'=> $chkEmpleado[$i]));
                    $empleado = $emp[0];
                    //motivo especifico
                    $txtMotivoespecifico = $this->input->post('txtMotivo_' . $chkEmpleado[$i]);
                    //realizar el insert de retiro. (marcado de autorizado)
                    $retiro = array(
                        'rte_id_ctr' => $slcCategoriaRetiro,
                        'rte_id_emr' =>$empleado['emp_id_emr'],
                        'rte_id_emp' => $chkEmpleado[$i],
                        'rte_fecha_retiro' => $fecha_retiro,
                        'rte_motivo_retiro' => (trim($txtMotivoespecifico)!="")?trim($txtMotivoespecifico):((trim($txtMotivoGeneral)!="")?trim($txtMotivoGeneral):" Retiro masivo de empleados."),
                        'rte_observacion' => $txtMotivoGeneral,
                        'rte_autorizar_ret' => 1, //marcar autorizado el retiro.
                        'rte_estado' => 1,
                        'rte_desactivar_plaza' => 0,
                        'rte_recontratable' => 0,
                        'rte_usu_mod' => $this->tank_auth->get_user_id(),
                        'rte_fecha_mod' => date('Y-m-d H:i:s'),
                        'rte_usu_creacion' => $this->tank_auth->get_user_id(),
                        'rte_fecha_creacion' => date('Y-m-d H:i:s')
                    );
                    $ingreso_retiro = $this->gsatelite->ingresar('rte_retiro_empleado', $retiro);
                    //crear bitacora de promoción empleado
                                      $this->db->order_by('pps_id','DESC');
                    $promo_anterior = $this->gsatelite->get_tabla('pps_promocion_plaza_salarioxemp', array('pps_id_emp' => $empleado['emp_id']));

                    if(count($promo_anterior) <= 0){
                        //si no existe crearlo automaticamente
                        $newarea = $this->gsatelite->get_campo('plz_plaza', 'plz_id_are', array('plz_id' => $empleado['emp_id_plz']));
                        $promo_nivel = array(
                            'pps_id_plz' => $empleado['emp_id_plz'],
                            'pps_id_emp' => $empleado['emp_id'],
                            'pps_id_emr' => $empleado['emp_id_emr'],
                            'pps_id_are' => ($newarea > 0) ? $newarea : null,
                            'pps_tipo' => 1,
                            'pps_salario' => $empleado['emp_salario'],
                            'pps_fecha_efectiva' => formatear_fecha('Y-m-d',  $empleado['emp_fecha_contrato']),
                            'pps_fecha_desde' => formatear_fecha('Y-m-d', $empleado['emp_fecha_contrato']),
                            'pps_fecha_hasta' => $fecha_retiro, //fecha actual de retiro
                            'pps_estado' => 0,
                            'pps_usu_creacion' => $this->tank_auth->get_user_id(),
                            'pps_fecha_creacion' => date('Y-m-d H:i:s'),
                            'pps_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'pps_fecha_modificacion' => date('Y-m-d H:i:s')            
                        );    
                        $id_pps_anterior = $this->gsatelite->ingresar('pps_promocion_plaza_salarioxemp', $promo_nivel);
                    }
                    
                    //realizar update a empleado  a inactivo y quitar la plaza asociada.

                    $this->gsatelite->actualizar_array('emp_empleado', array('emp_fecha_retiro'=>$fecha_retiro, 'emp_estado'=>0, 'emp_id_plz'=>null), array('emp_id'=>$empleado['emp_id']));

                    $k++;
                 }
             }
             $this->gsatelite->show_dialog("Proceso realizado con éxito <br /> <b> $k  empleados dados de bajas </b>", "expediente_personal/empleado/retiro_masivo_empleados");
         }// end if post exist

         $data['permisos']=$permisos;

                        $this->db->join('mxr_empresaxarea', 'mxr_id_are = are_id');
                        $this->db->where('mxr_id_emr',$this->tank_auth->get_empresa_id());
         $data['slcArea'] = $this->gsatelite->get_dropdown('are_area', '{are_nombre}', 'slcArea', array('are_estado' => 1), null, '', '', true);

         $data['slcSucursal'] = $this->gsatelite->get_dropdown('suc_sucursal', '{suc_codigo} - {suc_nombre}', 'slcSucursal', array('suc_id_emr' => $this->tank_auth->get_empresa_id()), null, '', '', true);
         $data['slcEmpresa'] = $this->gsatelite->get_dropdown_empresa();

         $data['titulo_personal'] = "Retiro masivo de empleados.";
         cargarvista($data);
     }


     /**
     * @author René Castaneda
     * @since 2018-04-17
     * @return filtrar ine,pleado
      */

    public function filtrar_retiro_masivo_empleados($es_reporte = 0) {
        satelite_validar();
        $registros = array();
        $permisos = $this->gsatelite->get_permisos_opcion('retiro_masivo_empleados');
        $data['permisos']=$permisos;
        $slcEmpresa =  $this->input->post('slcEmpresa');
        $slcArea = $this->input->post('slcArea');
        $slcSucursal = $this->input->post('slcSucursal');
        $where['emp_estado'] = '1';
        $where["emp_id_plz IS NOT NULL"] = NULL; //que posea una plaza
        if ($this->input->post()) {
            if ($slcEmpresa > 0) {
                $where['emp_id_emr'] = $slcEmpresa;
            }
            if ($slcArea > 0) {
                $where['emp_id_are'] = $slcArea;
            }
            if ($slcSucursal > 0) {
                $where['emp_id_suc'] = $slcSucursal;
            }
        }
        $registros=$this->planilla_model->get_empleados_reporte($where);
        $data['es_reporte']=$es_reporte;
        $data['slcEmpresa'] = $this->input->post('slcEmpresa');
        $data['slcArea'] = $this->input->post('slcArea');
        $data['slcSucursal'] = $this->input->post('slcSucursal');
        $data['registros'] = $registros;
        $data['slcCategoriaRetiro'] = $this->gsatelite->get_dropdown('ctr_categoria_retiro', '{ctr_nombre}', '', array('ctr_estado' => 1), null, '', '', true);
        $html = $this->load->view('expediente_personal/empleado/filtrar_retiro_masivo_empleados', $data, true);       
        echo json_encode(array('html'=>$html));
    }



    /**
     * @author René Castaneda 
     * @since 2018-05-16
     * @return filtrar y trasladar empleados
      */
    public function traslado_masivo_empleados(){
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();
        if ($this->input->post()) {
            //print_r($_POST); die();
            $slcCategoriaRetiro =  $this->input->post('slcCategoriaRetiro');
            $slcEmpresaTraslado =  $this->input->post('slcEmpresaTraslado');
            $slcSucursalTraslado =  $this->input->post('slcSucursalTraslado');
            $fecha_contratacion =  $this->input->post('txtFechaContrato');
            $txtMotivoGeneral = $this->input->post('txtMotivoGeneral');
            $chkEmpleado = $this->input->post('chkEmpleado');
            $fecha_retiro = date("Y-m-d H:i:s");
            $n = count($chkEmpleado);
            $k=0;
             for ($i=0; $i < $n; $i++) { 
                 
                 if ($chkEmpleado[$i] > 0 && $slcCategoriaRetiro > 0) {
                    $empleado = $this->gsatelite->get_tabla('emp_empleado', array('emp_id'=> $chkEmpleado[$i]));
                    $empleado = $empleado[0];

                    //motivo especifico
                    $txtMotivoespecifico = $this->input->post('txtMotivo_'+$chkEmpleado[$i]);

                    //realizar el insert de retiro. (marcado de autorizado)
                    $retiro = array(
                        'rte_id_ctr' => $slcCategoriaRetiro,
                        'rte_id_emr' =>$empleado['emp_id_emr'],
                        'rte_id_emp' => $chkEmpleado[$i],
                        'rte_fecha_retiro' => $fecha_retiro,
                        'rte_motivo_retiro' => (trim($txtMotivoespecifico) != "")? trim($txtMotivoespecifico):((trim($txtMotivoGeneral)!= "")? trim($txtMotivoGeneral):" Retiro masivo de empleados."),
                        'rte_observacion' => $txtMotivoGeneral,
                        'rte_autorizar_ret' => 1, //marcar autorizado el retiro.
                        'rte_estado' => 1,
                        'rte_usu_mod' => $this->tank_auth->get_user_id(),
                        'rte_fecha_mod' => date('Y-m-d H:i:s'),
                        'rte_usu_creacion' => $this->tank_auth->get_user_id(),
                        'rte_fecha_creacion' => date('Y-m-d H:i:s')
                    );
                    $ingreso_retiro = $this->gsatelite->ingresar('rte_retiro_empleado', $retiro);

                    

                    //crear bitacora de promoción empleado
                    $this->db->order_by('pps_id','DESC');
                    $promo_anterior = $this->gsatelite->get_tabla('pps_promocion_plaza_salarioxemp', array('pps_id_emp' => $empleado['emp_id']));

                    if(count($promo_anterior) <= 0){
                        //si no existe crearlo automaticamente
                        $promo_nivel = array(
                            'pps_id_plz' => $empleado['emp_id_plz'],
                            'pps_id_emp' => $empleado['emp_id'],
                            'pps_id_emr' => $empleado['emp_id_emr'],
                            'pps_tipo' => 1,
                            'pps_salario' => $empleado['emp_salario'],
                            'pps_fecha_efectiva' => formatear_fecha('Y-m-d',  $empleado['emp_fecha_contrato']),
                            'pps_fecha_desde' => formatear_fecha('Y-m-d', $empleado['emp_fecha_contrato']),
                            'pps_fecha_hasta' => $fecha_retiro, //fecha actual de retiro
                            'pps_estado' => 0,
                            'pps_usu_creacion' => $this->tank_auth->get_user_id(),
                            'pps_fecha_creacion' => date('Y-m-d H:i:s'),
                            'pps_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'pps_fecha_modificacion' => date('Y-m-d H:i:s')            
                        );    

                        $id_pps_anterior = $this->gsatelite->ingresar('pps_promocion_plaza_salarioxemp', $promo_nivel);

                    }
                    
                    $this->duplicar_empleado_traslado($chkEmpleado[$i], $slcEmpresaTraslado, $slcSucursalTraslado, $fecha_contratacion, $slcCategoriaRetiro);

                    //realizar update a empleado  a inactivo y quitar la plaza asociada.
                    $this->gsatelite->actualizar_array('emp_empleado', array('emp_fecha_retiro'=>$fecha_retiro, 'emp_estado'=>0, 'emp_id_plz'=>null), array('emp_id'=>$empleado['emp_id']));

                    $k++;
                 }
             }
             $this->gsatelite->show_dialog("Proceso realizado con éxito <br /> <b> $k  empleados dados de bajas y traladados a una nueva empresa</b>", "expediente_personal/empleado/traslado_masivo_empleados");
         }// end if post exist

         $data['permisos']=$permisos;

                        $this->db->join('mxr_empresaxarea', 'mxr_id_are = are_id');
                        $this->db->where('mxr_id_emr',$this->tank_auth->get_empresa_id());
         $data['slcArea'] = $this->gsatelite->get_dropdown('are_area', '{are_nombre}', 'slcArea', array('are_estado' => 1), null, '', '', true);

         $data['slcSucursal'] = $this->gsatelite->get_dropdown('suc_sucursal', '{suc_codigo} - {suc_nombre}', 'slcSucursal', array('suc_id_emr' => $this->tank_auth->get_empresa_id()), null, '', '', true);
         $data['slcEmpresa'] = $this->gsatelite->get_dropdown_empresa();

         $data['titulo_personal'] = "Traslado masivo de empleados.";
         cargarvista($data);
     }


    /**
     * @author René Castaneda
     * @since 2018-05-16
     * @return filtrar ine,pleado
      */

    public function filtrar_traslado_masivo_empleados($es_reporte = 0){   
        satelite_validar();
        $registros = array();
        $permisos = $this->gsatelite->get_permisos_opcion('retiro_masivo_empleados');
        $data['permisos']=$permisos;

        $slcEmpresa =  $this->input->post('slcEmpresa');
        $slcArea = $this->input->post('slcArea');
        $slcSucursal = $this->input->post('slcSucursal');
        $where['emp_estado'] = '1';
        $where["emp_id_plz IS NOT NULL"] = NULL; //que posea una plaza
        if ($this->input->post()) {                        
            if ($slcEmpresa > 0) {
                $where['emp_id_emr'] = $slcEmpresa;
            }
            if ($slcArea > 0) {
                $where['emp_id_are'] = $slcArea;
            }
            if ($slcSucursal > 0) {
                $where['emp_id_suc'] = $slcSucursal;
            }
        }
        $registros=$this->planilla_model->get_empleados_reporte($where);
        //echo $this->db->last_query(); die();
        $data['es_reporte'] = $es_reporte;
        $data['slcEmpresa'] = $this->input->post('slcEmpresa');
        $data['slcArea'] = $this->input->post('slcArea');
        $data['slcSucursal'] = $this->input->post('slcSucursal');
        $data['registros'] = $registros;
        // if ($slcEmpresa > 0) {
            // $this->db->where('emr_id !=', $slcEmpresa);
        // }
        $suc = ($slcSucursal > 0) ? $slcSucursal : $this->tank_auth->get_sucursal_id();
        $data["slcEmpresaTraslado"] = $this->gsatelite->get_dropdown_empresa();
        $data['slcCategoriaRetiro'] = $this->gsatelite->get_dropdown('ctr_categoria_retiro', '{ctr_nombre}', '', array('ctr_estado' => 1), null, '', '', true);
        $data['slcSucursalTraslado'] = $this->gsatelite->get_dropdown('suc_sucursal', '{suc_nombre}', '', array('suc_id !=' => $suc), null, '', '', true);
        $html = $this->load->view('expediente_personal/empleado/filtrar_traslado_masivo_empleados', $data, true);       
        echo json_encode(array('html'=>$html));
    }

     /**
     * @author René Castaneda
     * @since 2018-05-18
     * @return duplicar el registro del empleado
      */

    public function duplicar_empleado_traslado($id_emp = 0, $id_emr = 0, $id_suc = null, $fContratacion = null, $id_ingreso_retiro=null){
        if ($id_emp > 0 && $id_emr > 0) {
            $fecha_actual = date('Y-m-d H:i:s');
            $id_usuario = $this->tank_auth->get_user_id();
            $reg_emp = $this->gsatelite->get_tabla('emp_empleado',array('emp_id'=>$id_emp));
            if ( count($reg_emp) > 0 ) {
                //insert de emp_empleado
                $reg_emp = $reg_emp[0];
                $area = null;
                $plaza = null;
                //esta vinculada el area con la empresa?
                $permiteArea = $this->gsatelite->get_tabla('mxr_empresaxarea', array('mxr_id_are'=>$reg_emp['emp_id_are'], 'mxr_id_emr'=>$id_emr));
                if (count($permiteArea) > 0) {
                    $area = $reg_emp['emp_id_are'];
                    $plaza = $reg_emp['emp_id_plz'];
                }
                $fContratacion = formatear_fecha("Y-m-d", $fContratacion);
                $nuevo_empleado = array(
                    'emp_id_suc' => ($id_suc>0)? $id_suc:null,
                    'emp_id_are' => ($area > 0)? $area:null,
                    'emp_id_plz' => ($plaza > 0)? $plaza:null,
                    'emp_id_emr' => $id_emr,
                    'emp_id_afp' => $reg_emp['emp_id_afp'],
                    'emp_id_gen' => $reg_emp['emp_id_gen'],
                    'emp_id_cnt' => $reg_emp['emp_id_cnt'],
                    'emp_id_pro' => $reg_emp['emp_id_pro'],
                    'emp_id_esc' => $reg_emp['emp_id_esc'],
                    'emp_id_ban' => $reg_emp['emp_id_ban'],
                    'emp_id_tic' => $reg_emp['emp_id_tic'],
                    'emp_id_pat_contacto' => $reg_emp['emp_id_pat_contacto'],
                    'emp_id_tsr' => $reg_emp['emp_id_tsr'],
                    'emp_id_tds' => $reg_emp['emp_id_tds'],
                    'emp_id_zon' => $reg_emp['emp_id_zon'],
                    'emp_id_tiv' => $reg_emp['emp_id_tiv'],
                    'emp_id_tcv' => $reg_emp['emp_id_tcv'],
                    'emp_id_mun' => $reg_emp['emp_id_mun'],
                    'emp_id_pai' => $reg_emp['emp_id_pai'],
                    'emp_id_tps' => $reg_emp['emp_id_tps'],
                    'emp_id_cta' => $reg_emp['emp_id_cta'],
                    'emp_id_fnr' => $reg_emp['emp_id_fnr'],
                    'emp_id_tpc' => $reg_emp['emp_id_tpc'],
                    'emp_codigo' => $reg_emp['emp_codigo'],
                    'emp_nombre' => $reg_emp['emp_nombre'],
                    'emp_apellido' => $reg_emp['emp_apellido'],
                    'emp_direccion' => $reg_emp['emp_direccion'],
                    'emp_lugar_nac' => $reg_emp['emp_lugar_nac'],
                    'emp_fecha_nac' => $reg_emp['emp_fecha_nac'],
                    'emp_fecha_contrato' => $fContratacion,
                    'emp_salario' =>$reg_emp['emp_salario'],
                    'emp_salario_hora' => $reg_emp['emp_salario_hora'],
                    'emp_salario_hora_nocturna' => $reg_emp['emp_salario_hora_nocturna'],
                    'emp_afp' => $reg_emp['emp_afp'],
                    'emp_seguro' => $reg_emp['emp_seguro'],
                    'emp_numero_cuenta' => $reg_emp['emp_numero_cuenta'],
                    'emp_observacion_contrato' => "Traslado masivo",
                    'emp_estatura' => $reg_emp['emp_estatura'],
                    'emp_peso' => $reg_emp['emp_peso'],
                    'emp_discapacidad' => $reg_emp['emp_discapacidad'],
                    'emp_observacion_clinica' => $reg_emp['emp_observacion_clinica'],
                    'emp_contacto_emergencia' => $reg_emp['emp_contacto_emergencia'],
                    'emp_direccion_emergencia' => $reg_emp['emp_direccion_emergencia'],
                    'emp_telefono_emergencia' => $reg_emp['emp_telefono_emergencia'],
                    'emp_expediente' => $reg_emp['emp_expediente'],
                    'emp_es_reingreso' => $reg_emp['emp_es_reingreso'],
                    'emp_es_jubilado' => $reg_emp['emp_es_jubilado'],
                    'emp_fecha_jubilado' => $reg_emp['emp_fecha_jubilado'],
                    'emp_realizo_poligrafo' => $reg_emp['emp_realizo_poligrafo'],
                    'emp_codigo_referencia' => $reg_emp['emp_codigo_referencia'],
                    'emp_aplica_afp' => $reg_emp['emp_aplica_afp'],
                    'emp_aplica_isss' => $reg_emp['emp_aplica_isss'],
                    'emp_fecha_ult_liquidacion' => $reg_emp['emp_fecha_ult_liquidacion'],
                    'emp_fecha_fin_contrato' => $reg_emp['emp_fecha_fin_contrato'],
                    'emp_fecha_antiguedad' => $reg_emp['emp_fecha_antiguedad'],
                    'emp_id_origen_traslado' => $reg_emp['emp_id'],
                    'emp_estado' => 1,
                    'emp_usu_mod' => $id_usuario,
                    'emp_fecha_mod' => $fecha_actual,
                    'emp_usu_crea' => $id_usuario,
                    'emp_fecha_crea' => $fecha_actual
                );
                $id_nuevo_emp = $this->gsatelite->ingresar('emp_empleado', $nuevo_empleado);
                //actualizar el empleado anterior
                $array_update_ant = array(
                    'emp_id_emr_tralado' => $id_emr,
                    'emp_fecha_traslado' => $fecha_actual,
                    'emp_usu_mod' => $id_usuario,
                    'emp_fecha_mod' => $fecha_actual                      
                );
                $this->gsatelite->actualizar_array('emp_empleado', $array_update_ant, array('emp_id'=>$reg_emp['emp_id']));
                //fin de insert emp_empleado
                if ($plaza > 0) {
                    //preguntar por el ultimo registro activo.
                    $query_bitacora = $this->gsatelite->get_tabla('pps_promocion_plaza_salarioxemp',array('pps_id_emp' => $reg_emp['emp_id'], 'pps_estado' => 1));
                    if ($query_bitacora) {
                        $this->gsatelite->actualizar_array('pps_promocion_plaza_salarioxemp', array('pps_fecha_hasta' => $fContratacion, 'pps_estado' => 0), array('pps_id_emp' => $reg_emp['emp_id'], 'pps_estado' => 1));
                    }
                    $newarea = $this->gsatelite->get_campo('plz_plaza', 'plz_id_are', array('plz_id' => $this->input->post('puesto')));
                    $array_asenso = array(
                        'pps_id_plz' => $this->input->post('puesto'),
                        'pps_id_emp' => $id_nuevo_emp,
                        'pps_id_are' => ($newarea > 0) ? $newarea : null,
                        'pps_id_emr' => $id_emr,
                        'pps_tipo' => 0,
                        'pps_salario' => $reg_emp['emp_salario'],
                        'pps_fecha_efectiva' => $fContratacion,
                        'pps_fecha_desde' => $fContratacion,                        
                        'pps_fecha_hasta' => null,                        
                        'pps_estado' => 1,
                        'pps_usu_creacion' => $id_usuario,
                        'pps_fecha_creacion' => $fecha_actual,
                        'pps_usu_modificacion' => $id_usuario,
                        'pps_fecha_modificacion' => $fecha_actual
                    );
                    $id_asenso = $this->gsatelite->ingresar('pps_promocion_plaza_salarioxemp', $array_asenso);
                }
                $tablas_duplicar = array(
                    'sxe_seguroxempleado',
                    'cxp_correoxempleado',
                    'exe_enfermedadxempleado',
                    'cae_componente_alergico_empleado',
                    'dce_documento_emp',
                    'pxe_programaxempleado',
                    'cep_certificacion_programa',
                    'fam_familiar',
                    'iem_idioma_empleado',
                    'cri_certificacion_idioma',
                    'rfp_referencia_personal',
                    'rfl_referencia_laboral',
                    'dac_dato_academico',
                    'hxm_habilidadxempleado',
                    'age_agrupacion_empleado',
                    'sre_servicio_empleado',
                    'ixe_insumoxempleado',
                    'cpe_capacitacion_empleado',
                    'axe_anexoxempleado'
                );
                $this->expediente_personal_model->duplicar_info_emp($tablas_duplicar,$reg_emp['emp_id'],$id_nuevo_emp);
            }
        }   
    }


        /**
         * Descripción:
         * Función para obtener los empleados en la pantalla de promociones y nivelaciones
         * @author Edith Herrera - Grupo Satélite
         * @since  2018-07-12
         * @param  id del empleado al agregar promociones 
         * @return listado de empleados y promociones.
         ***************************************************************************************/

        function promocion_nivelacion() {
            satelite_validar();

            $this->load->library('../controllers/acciones_personal/principal');
            $this->principal->promocion_nivelacion();
        }

        function promocion_nivelacion_empleado($id_emp) {
            satelite_validar();

            $this->load->library('../controllers/acciones_personal/principal');
            $this->principal->promocion_nivelacion_empleado($id_emp);
        }

        function promocion_nivelacion_exportar() {
            satelite_validar();  
            if ($_POST) {
                $id_emp   = $this->input->post('id_empleado');
                $reporte   = $this->input->post('tipo_reporte');
                $data['proniv_empleados'] = $this->expediente_personal_model->reporte_promociones_niveles(array('pps_id_emp' => $id_emp));
                $row_emp = $this->gsatelite->get_tabla('emp_empleado', array('emp_id' => $id_emp));

                $data['reporte'] = $reporte;
                $data['id_empleado'] = $row_emp[0]['emp_id'];        
                $data['nom_ape_emp'] = $row_emp[0]['emp_nombre'] .' '. $row_emp[0]['emp_apellido'];        
                $data['titulo_personal'] = "Promociones de puestos/salarios";
                $data['filename'] = 'promocion_nivelacion_empleado_' . $row_emp[0]['emp_nombre'] .' '. $row_emp[0]['emp_apellido'] . '_' . date('dmY') . substr(uniqid(md5(rand()), true), 0, 5);
                $data['id_emp'] = $id_emp;
                $html = $this->load->view('acciones_personal/principal/tabla_pdf_promocion_nivelacion_empleado', $data, true);
                
                if ($reporte == 'pdf') {
                    ini_set('memory_limit', '512M' );
					ini_set('max_execution_time', '9999');
					$header = $this->load->view('reporte/header',  array('titulo' => 'Promociones de Puestos/Salarios ', 'subtitulo' => 'Empleada/o - ' . $row_emp[0]['emp_nombre'] .' '. $row_emp[0]['emp_apellido']), true);
					$documento = $header . $html;
                    // var_dump($documento);die();
					$this->pdf->makePdf($documento);
				} else {
					echo $html;
				}
                // var_dump($data);die();
            }
        }

        function nueva_promocion_nivelacion($id_emp) {
            satelite_validar();           
            $this->load->library('../controllers/acciones_personal/principal');
            $this->principal->nueva_promocion_nivelacion($id_emp);
        }

        function editar_promocion_nivelacion($id_emp, $id_pps) {
            satelite_validar();           
           
            $this->load->library('../controllers/acciones_personal/principal');
            $this->principal->editar_promocion_nivelacion($id_emp, $id_pps);
        }
    /****************************************************************************************/

    /**
     * Descripción:
     * Función verificar las dependencias de una plaza
     * @author Luis Navarro - Grupo Satélite
     * @since  2018-07-17
     * @param  id del empleado
     * @return retorna un valor booleano.
     **/
    public function verificar_dependencias_plaza() {
        satelite_validar();
        if ($this->input->post()) {
            $empleado = $this->input->post('empleado');
            $es_padre = 0;
            $info_empleado = $this->personal_model->listado_empleados(array('emp_id' => $empleado));

            // consulta para verificar si es padre
            $plaza_padre = $this->gsatelite->get_tabla('plz_plaza', array('plz_id_padre' => ($info_empleado[0]['plz_id'] != null)?$info_empleado[0]['plz_id']:0));

            if (count($plaza_padre) > 0) {
                $es_padre = 1;
            }

            echo json_encode(array( 'es_padre' => $es_padre ));
            die();
        }
    }

    function _cargarvista($data = 0, $crud = 0) {
        $this->load->view('vacia', $crud);
        if ($data != 0)
            $data = array_merge($data, $this->masterpage->getUsuario());
        else
            $data = $this->masterpage->getUsuario();
        $vista = $data['modulo'] . '/' . $data['control'] . '/' . $data['funcion'];
        $this->masterpage->setMasterPage('masterpage_default');
        $this->masterpage->addContentPage($vista, 'content', $data);
        $this->masterpage->show();
    }


    function gestion_tipo_pla($id_emp = null, $dtc = null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $this->gsatelite->verificar_registro_real('emp_empleado', $id_emp);

            $registro_emp = $this->gsatelite->get_registro('emp_empleado', 'emp_id', $id_emp);

            $data["opciones_seguro"] = $this->select_tipo_seguro($id_emp);
            $data["nombre_empleado"] = $registro_emp->emp_nombre . " " . $registro_emp->emp_apellido;

            $add_fields = array(
                'txe_id_emp',
                'txe_id_tpl', 
                'txe_id_cnt', 
                'txe_estado', 
                'txe_usu_creacion', 
                'txe_fecha_creacion',
                'txe_usu_modificacion', 
                'txe_fecha_modificacion'
            );

            $edit_fields = array(
                'txe_id_emp',
                'txe_id_tpl', 
                'txe_id_cnt', 
                'txe_estado', 
                'txe_usu_creacion', 
                'txe_fecha_creacion',
                'txe_usu_modificacion', 
                'txe_fecha_modificacion'
            );



            $crud = new grocery_CRUD();
            $crud->set_subject('Tipos de Planilla')->set_table('txe_tipo_planillaxempleado');
            $crud->set_relation('txe_id_tpl', 'tpl_tipo_planilla', '{tpl_nombre}', array('tpl_estado' => 1));
            $crud->set_relation('txe_id_cnt', 'cnt_cuenta_contable', '{cnt_cuenta} {cnt_nombre}', array('cnt_estado' => 1));
            $crud->where("txe_id_emp in ( {$id_emp} )");
            $crud->columns('txe_id_tpl', 'txe_id_cnt','txe_estado');
            // $crud->callback_column('prs_id_sxe_column', function($value, $row) {
            //     $registro_sxe = $this->gsatelite->get_registro('sxe_seguroxempleado', 'sxe_id', $row->prs_id_sxe);
            //     $registro_seg = $this->gsatelite->get_registro('seg_seguro', 'seg_id', $registro_sxe->sxe_id_seg);
            //     return $registro_seg->seg_nombre;
            // });
            $crud->display_as('txe_id_tpl', 'Tipo de Planilla');
            $crud->display_as('txe_id_cnt', 'Cuenta Contable');
            $crud->display_as('txe_estado', 'Estado');
            $crud->add_fields($add_fields);
            $crud->edit_fields($edit_fields);
            $crud->required_fields('txe_id_tpl', 'txe_estado');
            $crud->field_type('txe_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            $crud->field_type('txe_id_emp', 'hidden', $id_emp);
            $crud->field_type('txe_fecha_modificacion', 'hidden', date("Y-m-d H:i:s"));
            $crud->field_type('txe_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('txe_fecha_creacion', 'hidden', date("Y-m-d H:i:s"));
            $crud->field_type('txe_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->set_rules('txe_id_tpl', 'Tipo de Planilla', 'required|callback_valid_tipos_insert');
            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('txe_estado', 'hidden', 1)
                ->field_type('txe_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('txe_fecha_creacion', 'hidden', date('Y-m-d h:i:s'));
            } else {  // Editar
                $crud->field_type('txe_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

           // $crud->callback_before_insert(array($this, 'validar_ponderaciones'));
           // $crud->callback_before_update(array($this, 'validar_ponderaciones'));
            //$crud->set_rules('seg_nombre','Nombre','trim|required|campo_unico[seg_seguro.seg_nombre]');

           // $crud->set_lang_string('update_error', 'Los porcentajes deben sumar el 100%');
            //$crud->set_lang_string('insert_error', 'Los porcentajes deben sumar el 100%');
            //$crud->callback_before_insert(array($this, 'valid_tipos_insert'));
            $output = $crud->render();
            $data['dct'] = $dct;
            $data['titulo_personal'] = "Tipos de Planilla";
            $this->_cargarvista($data, $output);
        }
    }

    public function valid_tipos_insert(){
        $post_array = $this->input->post();
        $tipo      = $post_array['txe_id_tpl'];
        $emp       = $post_array['txe_id_emp'];
        $registros = $this->gsatelite->get_tabla('txe_tipo_planillaxempleado',array('txe_id_tpl' => $tipo,'txe_id_emp'=> $emp));
        if (count($registros)> 0) {
            $this->form_validation->set_message('valid_tipos_insert','Tipo de planilla ya fue agregado');
            return false;
        }else{
            return true;
        }

    }
    /**
     * Descripción:
     * Función verificar las dependencias de una plaza
     * @author Manuel Anzora - Grupo Satélite
     * @since  2018-12-07
     * @param  $emp: id del empleado
     * @return Finiquito de empleado retirado, despedido en doc word
     **/
    public function finiquito_empleado($emp_id=null, $id=null){
        $html = "";
        if($emp_id != null){
            $where = ['emp_id'=>$emp_id];
            $group = 'emp_id';
            $data=[];
            $data_emp = $this->expediente_personal_model->get_empleado_retirado($where,$group);
            $representante = $this->gsatelite->get_parametro_emp('ID_REPRESENTANTE_LEGAL');
            $band=0;
            if($representante!=''){
                $condition = ['emp_id'=>$representante];
                $data_rep = $this->expediente_personal_model->get_empleado_retirado($condition,null);
            }else{
                $band=1;
            }
            $repre_legal=[];
            foreach ($data_rep as $value) {
                $repre_legal=[
                    'nombre'=>$value['fullname'],
                    'direccion'=>$value['emp_direccion']
                ];
            }
            // $data['representante_legal']=$repre_legal;
            $data['representante_legal'] = $this->gsatelite->get_parametro_emp('TES_NOMBRE_TESORERO');
            $notario['nombre'] = $this->gsatelite->get_campo('prm_parametro_empresa', 'prm_valor', array('prm_codigo'=>'SYS_NOMBRE_NOTARIO', 'prm_id_emr'=>$this->tank_auth->get_empresa_id()));
            $notario['domicilio'] = $this->gsatelite->get_campo('prm_parametro_empresa', 'prm_valor', array('prm_codigo'=>'SYS_DOMICILIO_NOTARIO', 'prm_id_emr'=>$this->tank_auth->get_empresa_id()));
            $info=[];
            $year = $this->enletras->num2letras(date('Y'));
            $dia = $this->enletras->num2letras(date('j'));
            $hora = $this->enletras->num2letras(date('H'));
            $minutos = $this->enletras->num2letras(date('i',strtotime(date('H:i:s'))));
            //UBICACION DE LA EMPRESA
            // $info_emp = $this->tank_auth->get_all_empresa();
            $empresa = $this->gsatelite->get_registro('emr_empresa', array('emr_id' => $this->tank_auth->get_empresa_id()));
            $municipio = json_decode(json_encode($this->gsatelite->get_registro('mun_municipio', 'mun_id', $empresa->emr_id_mun)), true);
            $data['municipio'] = $municipio;
            $data['pais'] = $this->gsatelite->get_registro('pai_pais', 'pai_id', $empresa->emr_id_pai);
            // $data['dep_empre'] = $this->gsatelite->get_campo('dep_departamento','dep_nombre',array('dep_id' => $municipio["mun_id_dep"]));
            foreach ($data_emp as $value) {
                $age = '';
                $f_nac = $value['emp_fecha_nac'];
                if ($f_nac != '') {
                    $fec_n = explode('-', $f_nac);
                    $anio = date('Y');
                    $mes = date('m');
                    $day = date('d');
                    if ($fec_n[1] == $mes && $fec_n[2] > $day) {
                        $anio = $anio - 1;
                    }
                    if ($fec_n[1] > $mes) {
                        $anio = $anio - 1;
                    }
                    $age = $anio - $fec_n[0];
                }
                $edad = ($age != '') ? $this->enletras->num2letras($age) : '';
                if ($value['plz_nombre'] != "") {
                    $puesto = $value['plz_nombre'];
                } elseif ($value['pto_nombre'] != "") {
                    $puesto = $value['pto_nombre'];
                }else{
                    $puesto = '---';
                }
                $info=[
                    'empleado'     => $value['fullname'],
                    'edad'         => $edad,
                    'profesion'    => $value['pro_nombre'],
                    'puesto'       => $puesto,
                    'contratacion' => formatear_fecha('d-n-Y', $value['emp_fecha_contrato']),
                    'direccion'    => $value['emp_direccion'],
                    'documento'    => $value['dce_valor'],
                    'pais'         => $value['pai_nombre'],
                    'departamento' => $value['dep_nombre'],
                    'municipio'    => $value['mun_nombre']
                ];
            }
            $data['empleado'] = $info;
            $data['notario'] = $notario;
            $data['year'] = strtolower($year);
            $data['dia'] = strtolower($dia);
            $data['hora'] = strtolower($hora);
            $data['minutos'] = strtolower($minutos);
            // $html .= $this->load->view('expediente_personal/empleado/finiquito_empleado', $data, true);
            $sig_emp = strtolower(trim($this->gsatelite->get_parametro('SYS_SIGLAS')));
            if ($sig_emp != 'fya') {
                $html .= $this->load->view('expediente_personal/empleado/finiquito_empleado', $data, true);     
            } else {
                $empleado_data = array($info);
                $data['municipio'] = $this->gsatelite->get_registro('mun_municipio', 'mun_id', $empresa->emr_id_mun);
                $data['empleados'] = $empleado_data;
                $data['siglas'] = $sig_emp;
                $html .= $this->load->view('expediente_personal/reportes/finiquito_empleado_masa', $data, true);
            }
        }   
        $nombre_archivo = (trim($info['empleado']) != '')? clean_string(trim($info['empleado'])):'finiquito_empleado';
        header('Content-type: application/vnd.ms-word');
        header("Content-Disposition: attachment;Filename=Finiquito ".$nombre_archivo.".doc");
        header("Pragma: no-cache");
        header("Expires: 0");
        echo '<html>';
        echo '<meta http-equiv=\'Content-Type\' content=\'text/html; charset=Windows-1252\'>';
        echo '<body style="font-family:Arial;" >';
        echo '<meta charset="utf-8" />';
        echo '<style type="text/css"> .inicio_contrato {  font-weight: bold;  }  .parrafo {    text-align: justify;  }</style>';
        echo $html;
        echo '</body></html>'; 
    }
    /**
     * Descripción:
     * Función para duplicar la ficha del empleado
     * @author Nelson Soriano
     * @since  23-05-2019
     * @param  id del empleado
     * @return Confirmcion de l transaccion
     **/

    public function duplicar_ficha($emp_id = null){
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $registro = $this->gsatelite->get_registro('emp_empleado', 'emp_id', $emp_id);
            /*********************************************************************************/
            // CODIGO EMPLEADO
            if($informacion[0]['emp_codigo']!=''){
                $data['codigo'] = $informacion[0]['emp_codigo'];
            }else{
                $longitu = $this->gsatelite->get_parametro_emp('SYS_CODIGO_NUEVO_EMPLEADO', null, null, array('LONGITUD MINIMA'));
                if ($longitu != 0 ){
                    $prefijo = $this->gsatelite->get_parametro_emp('SYS_CODIGO_NUEVO_EMPLEADO', null, null, array('PREFIJO CODIGO'));
                    $longitu = $this->gsatelite->get_parametro_emp('SYS_CODIGO_NUEVO_EMPLEADO', null, null, array('LONGITUD MINIMA'));
                    $last = $this->consultas->get_max_codigo('emp_empleado','emp_id');
                    $code = $last->codigo;
                    $cod = (float)$code + 1;
                    $codigo = $prefijo . str_pad($cod, $longitu, '0', STR_PAD_LEFT);
                    $data['codigo'] = $codigo;
                    // var_dump($codigo);
                    // die();
                } else {
                    $last=$this->consultas->get_max_codigo('emp_empleado','emp_codigo');
                    $code=$last->codigo;
                    $cod= (float)$code+1;
                    $codigo = str_pad($cod, 4, '0', STR_PAD_LEFT);
                    $data['codigo'] = $codigo;
                }
            }
            $informacion['emp_codigo_new'] = $codigo;
            // var_dump($informacion);die();
            /*************Determinar la cantidad de promociones nivelaciones **********************/
            $num_promos = count($this->gsatelite->get_tabla('pps_promocion_plaza_salarioxemp', array('pps_id_emp' => $emp_id)));            
            $data['num_promos'] = $num_promos;
            //die(print_r($registro,true));
            //$data['genero'] = $this->personal_model->get_genero();
            //$data['nacionalidad'] = $this->personal_model->get_nacionalidad();
            $data['estado_civil'] = $this->personal_model->get_estado_civil();
            $data['profesion'] = $this->personal_model->get_profesion();
            $data['tipo_telefono'] = $this->personal_model->get_tipotelefono();
            $data['afp'] = $this->personal_model->get_afp();
            $data['doc_documentos'] = $this->personal_model->get_documentos();
            $data['parentescos_cat'] = $this->personal_model->get_parentesco();
            //$data['puesto']=$this->personal_model->get_puesto();

            $arreglo_ids = $this->expediente_personal_model->get_permitidos_plaza($registro->emp_id_plz);
            $this->db->where_not_in('plz_id', $arreglo_ids);
            $this->db->where('plz_id_are',$registro->emp_id_are);
            $this->db->join('mxr_empresaxarea', 'mxr_id_are = plz_id_are');
            $this->db->where('mxr_id_emr', $this->tank_auth->get_empresa_id()); //Added by René Castaneda 
            $data['plaza'] = $this->gsatelite->get_tabla('plz_plaza', array('plz_estado' => 1));
            $data['departamento'] = $this->personal_model->get_departamento();
            $data['sucursal'] = $this->personal_model->get_sucursal();
            $data['tipo_contrato'] = $this->personal_model->get_tipo_contrato();
            $data['informacion'] = $informacion = $this->personal_model->editar_empleado($emp_id);

            $data['telefonos'] = $this->personal_model->editar_tel_empleado($emp_id);
            //oculta el thead de la tabla, en el caso de que no hayan datos
            $tel_sty = 'style="display:none;"';
            if (!(empty($data['telefonos']))) {
                $tel_sty = '';
            }
            $data['tel_sty'] = $tel_sty;

            $data['alergico'] = $this->gsatelite->get_tabla('cae_componente_alergico_empleado', array('cae_estado' => 1, 'cae_id_emp' => $emp_id));
            $data['enfermedad'] = $this->gsatelite->get_tabla('exe_enfermedadxempleado', array('exe_estado' => 1, 'exe_id_emp' => $emp_id));
            $data['enf_select'] = $this->gsatelite->get_tabla('enf_enfermedad', array('enf_estado' => 1));
            $data['alerg_select'] = $this->gsatelite->get_tabla('coa_componente_alergico', array('coa_estado' => 1));
            $data['parentescos_enf'] = $this->gsatelite->get_tabla('pat_parentesco');

            $data['documentos'] = $this->personal_model->editar_doc_empleado($emp_id);
            $data['parentescos'] = $this->personal_model->editar_fam_empleado($emp_id);
            //oculta el thead de la tabla, en el caso de que no hayan datos
            $paren_sty = "display:none;";
            if (!(empty($data['parentescos']))) {
                $paren_sty = "";
            }
            $data['paren_sty'] = $paren_sty;

            //programas y equipo
            $select = $this->expediente_personal_model->get_dropdown('nie_nivel_experiencia', '{nie_nombre}', '', array('nie_estado' => 1), null, '', 'nie_id', true);
            $data["nivel_programa_select"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            $select = $this->expediente_personal_model->get_dropdown('peq_programa_equipo', '{peq_nombre}', '', array('peq_estado' => 1), null, '', 'peq_id', true);
            $data["tipo_programa_select"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            $select = "";

            $datos = $this->gsatelite->get_tabla('cer_certificacion', array('cer_estado' => 1, 'cer_tipo' => 2));
            foreach ($datos as $key) {
                $select .= '<option value = "' . $key['cer_id'] . '">' . $key['cer_nombre'] . '</option>';
            }
            $data["cert_programa_select"] = str_replace('<option value="0">Seleccione</option>', '', $select);

            $select = $this->expediente_personal_model->get_dropdown('icp_institucion_capacitacion', '{icp_nombre}', '', array('icp_estado' => 1), null, '', 'icp_id', true);
            $data["institucion_select"] = str_replace('<option value="0">Seleccione</option>', '', $select);

            $select = $this->expediente_personal_model->get_dropdown('mde_modalidad_estudio', '{mde_nombre}', '', array('mde_estado' => 1), null, '', 'mde_id', true);
            $data["modalidad_select"] = str_replace('<option value="0">Seleccione</option>', '', $select);


            $data['nivel_programa_select2'] = $this->gsatelite->get_tabla('nie_nivel_experiencia', array('nie_estado' => 1,));
            $data['tipo_programa_select2'] = $this->gsatelite->get_tabla('peq_programa_equipo', array('peq_estado' => 1));
            $data['cert_programa_select2'] = $this->gsatelite->get_tabla('cer_certificacion', array('cer_estado' => 1, 'cer_tipo' => 2));

            $data['institucion_programa_select2'] = $this->gsatelite->get_tabla('icp_institucion_capacitacion', array('icp_estado' => 1));
            $data['modalidad_programa_select2'] = $this->gsatelite->get_tabla('mde_modalidad_estudio', array('mde_estado' => 1));

            $data['programa'] = $this->gsatelite->get_tabla('pxe_programaxempleado', array('pxe_estado' => 1, 'pxe_id_emp' => $emp_id));
            $data['programa_certificacion'] = $this->gsatelite->get_tabla('cep_certificacion_programa', array('cep_estado' => 1, 'cep_id_emp' => $emp_id));

            $program_sty = "display:none;";
            if (!(empty($data['tipo_programa_select2']))) {
                $program_sty = "";
            }
            $data['program_sty'] = $program_sty;

            $program_cert_sty = "display:none;";
            if (!(empty($data['programa_certificacion']))) {
                $program_cert_sty = "";
            }
            $data['program_cert_sty'] = $program_cert_sty;

            /* print_r($this->db->last_query());
              exit();die(); */
            $data['anexos'] = $this->personal_model->anexo_empleado($emp_id);
            $data['foto'] = $this->personal_model->foto_empleado($emp_id);
            $data['tipo'] = $tipo;

            /* ============================================================================================
              =                 DATOS DE LOS IDIOMAS
              ==============================================================================================
             */
            //controles para los select
            $select = $this->expediente_personal_model->get_dropdown('idm_idioma', '{idm_nombre}', '', null, null, '', 'idm_id', true);
            $data["idm_idioma"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            $select = $this->expediente_personal_model->get_dropdown('nii_nivel_idioma', '{nii_nombre}', '', null, null, '', 'nii_id', true);
            $data["nivel_idioma"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            $select = "";
            $datos = $this->gsatelite->get_tabla('cer_certificacion', array('cer_estado' => 1, 'cer_tipo' => 1));
            foreach ($datos as $key) {
                $select .= '<option value = "' . $key['cer_id'] . '">' . $key['cer_nombre'] . '</option>';
            }
            $data["cert_idioma_d"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            //fin de controles
            //tablas para mostrar los idiomas y certificacion del empleado
            $data['idiomas'] = $this->gsatelite->get_tabla('iem_idioma_empleado', array('iem_estado' => 1, 'iem_id_emp' => $emp_id));
            $data['certificado'] = $this->gsatelite->get_tabla('cri_certificacion_idioma', array('cri_estado' => 1, 'cri_id_emp' => $emp_id));
            //idiomas
            $data['select_idiomas'] = $this->gsatelite->get_tabla('idm_idioma', array('idm_estado' => 1));
            $data['select_nivel'] = $this->gsatelite->get_tabla('nii_nivel_idioma', array('nii_estado' => 1));
            //certificado
            $data['select_certificacion'] = $this->gsatelite->get_tabla('cer_certificacion', array('cer_estado' => 1, 'cer_tipo' => 1));

            //oculta el thead de la tabla, en el caso de que no hayan datos
            $idi_sty = 'style = "display:none"';
            $cer_sty = 'style = "display:none"';
            if (!(empty($data['idiomas']))) {
                $idi_sty = '';
            }
            if (!(empty($data['certificado']))) {
                $cer_sty = '';
            }
            $data['tabla_idm'] = $idi_sty;
            $data['tabla_cer'] = $cer_sty;

            /* ============================================================================================
              =                 DATOS DE LAS REFERENCIAS PERSONALES
              ==============================================================================================
             */
            //controles para los select
            $select = $this->expediente_personal_model->get_dropdown('trr_tipo_referencia', '{trr_nombre}', '', array('trr_estado' => 1), null, '', 'trr_id', true);
            $data["tipo_referencia"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            //tabla relacionada con el empleado
            $data["referencia_personal"] = $this->gsatelite->get_tabla('rfp_referencia_personal', array('rfp_estado' => 1, 'rfp_id_emp' => $emp_id));
            //tablas para mostrar los idiomas y certificacion del empleado
            $data['tipo_referencia_select'] = $this->gsatelite->get_tabla('trr_tipo_referencia', array('trr_estado' => 1));
            //oculta el thead de la tabla, en el caso de que no hayan datos
            $refpersonal_sty = 'style = "display:none"';
            if (!(empty($data['referencia_personal']))) {
                $refpersonal_sty = '';
            }
            $data['refpersonal_sty'] = $refpersonal_sty;

            /* ============================================================================================
              =                 DATOS DE LAS REFERENCIAS PERSONALES
              ==============================================================================================
             */
            //tabla relacionada con el empleado
            $data["referencia_laboral"] = $this->gsatelite->get_tabla('rfl_referencia_laboral', array('rfl_estado' => 1, 'rfl_id_emp' => $emp_id));
            //oculta el thead de la tabla, en el caso de que no hayan datos
            $reflaboral_sty = 'display:none;';
            if (!(empty($data['referencia_laboral']))) {
                $reflaboral_sty = '';
            }
            $data['reflaboral_sty'] = $reflaboral_sty;
            
            /* ============================================================================================
              =                 INSUMOS EMPLEADO
              ==============================================================================================
             */                    
            $data["insumos_grid"] = $this->expediente_personal_model->get_insumos(array('ixe_estado' => 1,'ixe_id_emp' => $emp_id));                                                
            
            /* ============================================================================================
              =                 INSUMOS EMPLEADO
              ==============================================================================================
             */                    
            $data["capacitaciones_grid"] = $this->expediente_personal_model->get_capacitaciones(array('cpe_estado' => 1,'cpe_id_emp' => $emp_id));            
            /* ============================================================================================
              =                     DATOS ACADEMICOS
              ==============================================================================================
             */
            //tabla relacionada con el empleado
            $data["datos_academicos"] = $this->gsatelite->get_tabla('dac_dato_academico', array('dac_estado' => 1, 'dac_id_emp' => $emp_id));
            //oculta el thead de la tabla, en el caso de que no hayan datos
            $datacademic_sty = 'style = "display:none"';
            if (!(empty($data['datos_academicos']))) {
                $datacademic_sty = '';
            }
            $data['datacademic_sty'] = $datacademic_sty;

            $select = $this->expediente_personal_model->get_dropdown('tie_tipo_educacion', '{tie_nombre}', '', array('tie_estado' => 1), null, '', 'tie_id', true);
            $data["tipo_educacion"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            $select = $this->expediente_personal_model->get_dropdown('pro_profesion', '{pro_nombre}', '', array('pro_estado' => 1), null, '', 'pro_id', true);
            $data["pro_profesion"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            $select = $this->expediente_personal_model->get_dropdown('ina_institucion_academica', '{ina_nombre}', '', array('ina_estado' => 1), null, '', 'ina_id', true);
            $data["institucion_academica"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            $select = $this->expediente_personal_model->get_dropdown('ese_estado_estudio', '{ese_nombre}', '', array('ese_estado' => 1), null, '', 'ese_id', true);
            $data["estado_estudio"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            $select2 = $this->expediente_personal_model->get_dropdown('pai_pais', '{pai_nombre}', '', array('pai_estado' => 1), null, '', 'pai_id', true);
            $data["pai_pais"] = str_replace('<option value="0">Seleccione</option>', '', $select2);
            $select = $this->expediente_personal_model->get_dropdown('exl_experiencia_laboral', '{exl_nombre}', '', array('exl_estado' => 1), null, '', 'exl_id', true);
            $data["experiencia_laboral"] = str_replace('<option value="0">Seleccione</option>', '', $select);

            $data["sel_tipo_educacion"] = $this->expediente_personal_model->get_select('tie_tipo_educacion', array('tie_nombre', 'asc'), array('tie_estado' => 1));
            $data["sel_pro_profesion"] = $this->expediente_personal_model->get_select('pro_profesion', array('pro_nombre', 'asc'), array('pro_estado' => 1));
            $data["sel_institucion_academica"] = $this->expediente_personal_model->get_select('ina_institucion_academica', array('ina_nombre', 'asc'), array('ina_estado' => 1));
            $data["sel_estado_estudio"] = $this->expediente_personal_model->get_select('ese_estado_estudio', array('ese_nombre', 'asc'), array('ese_estado' => 1));
            $data["sel_pai_pais"] = $this->expediente_personal_model->get_select('pai_pais', array('pai_nombre', 'asc'), array('pai_estado' => 1));
            $data["sel_experiencia_laboral"] = $this->expediente_personal_model->get_select('exl_experiencia_laboral', array('exl_nombre', 'asc'), array('exl_estado' => 1));

            $select = $this->gsatelite->get_dropdown('hab_habilidad', '{hab_nombre}', '', array('hab_estado' => 1), null, '', 'hab_id', true);
            $data["habilidad"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);

            $select = $this->gsatelite->get_dropdown('nih_nivel_habilidad', '{nih_nombre}', '', array('nih_estado' => 1), null, '', 'nih_id', true);
            $data["nivel_habilidad"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);

            $data['habilidades_emple'] = $this->expediente_personal_model->get_habilidades_emp(array('hxm_id_emp'=>$emp_id));
            $data['agrupaciones_emple'] = $this->gsatelite->get_tabla('age_agrupacion_empleado',array('age_id_emp'=>$emp_id));

            $select = $this->gsatelite->get_dropdown('zon_zona', '{zon_nombre}', '', array('zon_estado' => 1), $registro->emp_id_zon, '', 'zon_id', true);
            $data["slcZona"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            $select = $this->gsatelite->get_dropdown('tiv_tipo_vivienda', '{tiv_nombre}', '', array('tiv_estado' => 1), $registro->emp_id_tiv, '', 'tiv_id', true);
            $data["slcTipoCasa"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            $select = $this->gsatelite->get_dropdown('tcv_tipo_construccion_vivienda', '{tcv_nombre}', '', array('tcv_estado' => 1), $registro->emp_id_tcv, '', 'tcv_id', true);
            $data["slcTipoConstruccion"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            
            $servicicios_emp  = array();
            $reg_srv = $this->gsatelite->get_tabla('sre_servicio_empleado',array('sre_id_emp'=>$emp_id));
            foreach ($reg_srv as $rs) {
                $servicicios_emp[]=$rs['sre_id_srb'];
            }
            $select = $this->gsatelite->get_dropdown('srb_servicio_basico', '{srb_nombre}', '', array('srb_estado' => 1), $servicicios_emp, '', 'srb_id', true);
            $data["slcServiciosBasicos"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);

            $reg_municipio = $this->gsatelite->get_tabla('mun_municipio',array('mun_id'=>$registro->emp_id_mun));
            $id_departamento =  ($reg_municipio)? $reg_municipio[0]['mun_id_dep']:null;
            $id_municipio =  ($reg_municipio)? $reg_municipio[0]['mun_id']:null;
            $select = $this->gsatelite->get_dropdown('dep_departamento', '{dep_nombre}', '', array('dep_estado' => 1), $id_departamento, '', 'dep_id', true);
            $data["slcDepartamento"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            $select = $this->gsatelite->get_dropdown('pai_pais', '{pai_nacionalidad}', '', array('pai_estado' => 1), $registro->emp_id_pai, '', 'pai_id', true);
            $data["slcNacionalidad"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            $select = $this->gsatelite->get_dropdown('mun_municipio', '{mun_nombre}', '', array('mun_estado' => 1, 'mun_id_dep' => $id_departamento), $id_municipio, '', 'mun_id', true);
            $data["slcMunicipio"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);

            $select = $this->gsatelite->get_dropdown('tps_tipo_salario', '{tps_nombre}', '', array('tps_estado' => 1), $registro->emp_id_tps, '', 'tps_id', true);
            $data["slcTipoSalario"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            $select = $this->gsatelite->get_dropdown('cta_categoria_aguinaldo', '{cta_nombre}', '', array('cta_estado' => 1), $registro->emp_id_cta, '', 'cta_id', true);
            $data["slcCatAguinaldo"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            $select = $this->gsatelite->get_dropdown('fnr_fuente_reclutamiento', '{fnr_nombre}', '', array('fnr_estado' => 1), $registro->emp_id_fnr, '', 'fnr_id', true);
            $data["slcFuenteReclutamiento"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            $select = $this->gsatelite->get_dropdown('tpc_tipo_cuenta', '{tpc_nombre}', '', array('tpc_estado' => 1), $registro->emp_id_tpc, '', 'tpc_id', true);
            $data["slcTipoCuenta"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);

            $select = $this->gsatelite->get_dropdown('gen_genero', '{gen_nombre}', '', array('gen_estado' => 1), $registro->emp_id_gen, '', 'gen_id', true);
            $data["genero"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);

            //Tab insumos
            $select = $this->gsatelite->get_dropdown('tim_tipo_insumo', '{tim_nombre}', '', array('tim_estado' => 1), null, '', 'tim_id', true);
            $data["slcTipoInsumo"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);

            //Tab capacitaciones            
            $select = $this->gsatelite->get_dropdown('icp_institucion_capacitacion', '{icp_nombre}', '', array('icp_estado' => 1), null, '', 'icp_id', true);
            $data["slcInstitucionCapacitacion"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);

            $select = $this->gsatelite->get_dropdown('ese_estado_estudio', '{ese_nombre}', '', array('ese_estado' => 1), null, '', 'ese_id', true);
            $data["slcEstadoEstudio"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            
            // Tipo entrevista
            $select = $this->gsatelite->get_dropdown('tnv_tipo_entrevista', '{tnv_nombre}', '', array('tnv_estado' => 1), null, '', 'tnv_id', true);
            $data["slc_entrevista"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);

            // Tipo prueba
            $select = $this->gsatelite->get_dropdown('tib_tipo_prueba', '{tib_nombre}', '', array('tib_estado' => 1), null, '', 'tib_id', true);
            $data["slc_pruebas"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);

            //////////////////////////////////////////////// ENTREVISTA ////////////////////////////////////////////////////////////////////////
            $this->db->join('tnv_tipo_entrevista', 'enm_id_tnv = tnv_id',"left");
            $data["entrevista_solicitante"] = $this->gsatelite->get_tabla('enm_entrevista_empleado', array('enm_id_emp'=>$emp_id));
            
            ////////////////////////////////////////////// PRUEBAS /////////////////////////////////////////////////////////////////////
            $this->db->join('tib_tipo_prueba', 'pbe_id_tib = tib_id',"left");
            $data["prueba_solicitante"] = $this->gsatelite->get_tabla('pbe_prueba_empleado', array('pbe_id_emp'=>$emp_id));



            $dct = $this->input->get('dct');
            if ($dct == 1) {
                $data['dct'] = $dct;
                $titulo['titulo_personal'] = "Duplicar Docente";
            } else {
                $titulo['titulo_personal'] = "Duplicar Empleada/o";
            }
            // $titulo['titulo_personal'] = "Gestión de empleados";

            if ($informacion[0]['emp_fecha_ult_vacacion']!='') {//Fecha insertada menos 365 dias como ultima Vacacion
                $antigua = formatear_fecha('Y-m-d', $informacion[0]['emp_fecha_ult_vacacion']);
                $antigua = strtotime($antigua);
                $actual = strtotime('+365 day', $antigua);
                // $prox_vac =  date('Y-m-d', $actual);//SAT_7003 Se respetara la fecha actual
                $prox_vac =  date('d-m-Y', $antigua);
            }
            $data['prox_vac'] = $prox_vac;
            $this->_cargarvista($titulo, $data);
        }
       
    }

    /**
     * @author Marlon Olmedo
     * @since 2020-05-18
     * @return Proceso de edicion de un empleado
     * @description se carga la vista para la edicion de un empleado en grid
      */
    public function ultima_actualizacion() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $this->index_agregar_empleado(true,1);
        }
    }

    /**
     * @author Marlon Olmedo
     * @since 2020-05-18
     * @return Proceso de edicion de un empleado
     * @description se carga la vista para la edicion de un empleado en grid (se almacena)
      */
    public function actualizar_ficha($emp_id) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $this->editar_empleado($emp_id, 1, null,null,null,true,1);
        }
    }

}

?>