<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Catalogos extends CI_Controller {

    public function __construct() {
        parent::__construct();
        //$this->load->model('utm_model');
        //$this->load->model('consultas');
        //$this->load->model('gsatelite');
        $this->load->library('grocery_CRUD');
        // $this->load->library('Procesos');
        $this->load->model('consultas');
        $this->load->model('personal_model');
        $this->load->model('inventario_model');
        $this->load->library('tank_auth');
        //$this->driver =  $this->planilla_model;
    }

    public function index() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $this->_cargarvista();
        }
    }

    function gestion_bancos() {
        satelite_validar();

        try {
            $permisos = $this->gsatelite->get_permisos_opcion('expediente_personal/catalogos/gestion_bancos');
            $crud = new grocery_CRUD;
            $crud->set_table('ban_banco');
            $crud->set_subject('Banco');
            $crud->display_as('ban_nombre', 'Nombre');
            $crud->display_as('ban_estado', 'Estado');
            $crud->display_as('ban_prefijo', 'Prefijo de chequera');
            $crud->display_as('ban_sufijo', 'Sufijo de chequera');
            $crud->columns('ban_nombre', 'ban_estado');
            $crud->required_fields('ban_nombre', 'ban_estado');
            $crud->fields('ban_nombre', 'ban_estado', 'ban_usu_mod', 'ban_fecha_mod');
            $crud->set_rules('ban_nombre', 'Nombre', 'trim|required|campo_unico[ban_banco.ban_nombre]');
            $crud->field_type('ban_fecha_mod', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('ban_usu_mod', 'hidden', $this->tank_auth->get_user_id());
            //$crud->unset_delete();
            $crud->set_language('spanish');
            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('ban_estado', 'hidden', 1);
            } else {
                $crud->field_type('ban_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            if(!$permisos["permite_editar"]){
                $crud->unset_edit();
            }
            if(!$permisos["permite_eliminar"]){
                $crud->unset_delete();
            }
            if(!$permisos["permite_agregar"]){
                $crud->unset_add();
            }
            if($permisos["permite_ver"]){
                $crud->add_action('&nbsp;&nbsp;Ver', '', 'expediente_personal/catalogos/gestion_bancos/read','icomoon-icon-search-3');
            }
            $output = $crud->render();
            $data['titulo_personal'] = "Gestión Bancos";
            $this->_cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    function cuenta_contable() {
        satelite_validar();
        $campos = array(
            'cnt_cuenta' => 'Cuenta',
            'cnt_nombre' => 'Nombre',
            'cnt_id_cnt_padre' => 'Dependencia',
            'cnt_id_nic' => 'Nivel',
            'cnt_estado' => 'Estado',
            'cnt_aumenta' => 'D/H'
        );
        $crud = new grocery_CRUD();
        $permisos = $this->gsatelite->get_permisos_opcion();
        $dep = 0;
        if ($_POST) {
            $nombre = $this->input->post('nombre');
            $nivel = $this->input->post('nivel');
            $dep = $this->input->post('dependencia');
            if ($nombre != '') {
                $crud->where("cnt_nombre like '" . $nombre . "%'");
            }
            if ($nivel != '') {
                $crud->where("cnt_id_nic", $nivel);
            }
            if ($dep > 0) {
                $crud->where("cnt_id_cnt_padre", $dep);
            }
            $data['nivel'] = $nivel;
            $data['nombre'] = $nombre;
        }
        $crud->set_table('cnt_cuenta_contable')
                ->set_subject('')
                ->columns('cnt_cuenta', 'cnt_nombre', 'cnt_id_cnt_padre', 'cnt_id_nic', 'cnt_estado', 'cnt_aumenta')
                ->display_as($campos)
                ->set_relation('cnt_id_nic', 'nic_nivel_cuenta', '{nic_numero}')
                ->unset_export()
                ->unset_print()
                ->callback_column('cnt_id_cnt_padre', array($this, '_callback_dependencia'))
        ;
        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('cnt_estado', 'hidden', 1);
        } else {
            $crud->field_type('cnt_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }
        if ($dep > 0) {
            $data['dependencia'] = $this->gsatelite->get_dropdown('cnt_cuenta_contable', '{cnt_id} - {cnt_nombre}', '', array('cnt_estado' => 1), $dep, null, null, true);
        } else {
            $data['dependencia'] = $this->gsatelite->get_dropdown('cnt_cuenta_contable', '{cnt_id} - {cnt_nombre}', '', array('cnt_estado' => 1), null, null, null, true);
        }
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }
        if (!$permisos['permite_editar']) {
            $crud->unset_edit();
        }
        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }
        $data['titulo_personal'] = "Cuentas contables";
        $this->_cargarvista($data, $crud->render());
    }

    function parentesco() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $permisos = $this->gsatelite->get_permisos_opcion();

            $crud = new grocery_CRUD();
            $crud->set_subject('Parentescos')->set_table('pat_parentesco');
            $crud->columns('pat_nombre', 'pat_estado');
            $crud->display_as('pat_nombre', 'Nombre')
                    ->display_as('pat_estado', 'Estado');
            $crud->fields('pat_nombre', 'pat_estado', 'pat_usu_mod', 'pat_fecha_mod');
            $crud->required_fields('pat_nombre', 'pat_estado');
            $crud->field_type('pat_fecha_mod', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('pat_usu_mod', 'hidden', $this->tank_auth->get_user_id());
            $crud->set_rules('pat_nombre', 'Nombre', 'trim|required|campo_unico[pat_parentesco.pat_nombre]');
            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('pat_estado', 'hidden', 1);
            } else {
                $crud->field_type('pat_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }
            if(!$permisos["permite_editar"]){
                $crud->unset_edit();
            }
            if(!$permisos["permite_eliminar"]){
                $crud->unset_delete();
            }
            if(!$permisos["permite_agregar"]){
                $crud->unset_add();
            }
            if(!$permisos["permite_ver"]){
                $crud->unset_read();
            }else{
                $data_url = $this->masterpage->getUsuario();
                $url_read = $data_url['modulo'] . '/' . $data_url['control'] . '/' . $data_url['funcion'];
                $crud->add_action('Ver', 'minia-icon-search', $url_read."/read");
            }
            $output = $crud->render();
            $data['titulo_personal'] = "Parentescos";
            $this->_cargarvista($data, $output, 'expediente_personal/catalogos/parentesco');
        }
    }

    /*
    *   Funcionalidad Compartida con el Modulo de Seleccion de Personal
    */
    function profesion($ruta_vista = null) {
        satelite_validar();

        //$ruta_vista es una array en la posición uno viene la ruta de los permisos a obtener en la dos viene la vista a cargar.
        //cuando viene la petición de otro modulo.
        $ruta_permisos = (is_array($ruta_vista)) ? $ruta_vista[0] : 'expediente_personal/catalogos/profesion'; 
        $arreglo_url = explode('/', $ruta_permisos);
        $data['modulo_url'] = $arreglo_url[0] . '/' . $arreglo_url[1]; //cuando viene la petición de otro modulo.
        $ruta_vista = (is_array($ruta_vista)) ? $ruta_vista[1] : null;

        try {
            $permisos = $this->gsatelite->get_permisos_opcion();
            $crud = new grocery_CRUD();
            $crud->set_subject('Profesión');
            $crud->set_table('pro_profesion');

            $columns = array(
                'pro_nombre', 
                'pro_estado'
            );

            $display_as = array(
                'pro_nombre'    => 'Nombre',
                'pro_estado'    => 'Estado'
            );

            $fields = array(
                'pro_nombre', 
                'pro_estado', 
                'pro_usu_mod', 
                'pro_fecha_mod', 
                'pro_usu_crea', 
                'pro_fecha_crea'
            );

            $required = array(
                'pro_nombre', 
                'pro_estado'
            );

            $crud->columns($columns);
            $crud->display_as($display_as);
            $crud->fields($fields);
            $crud->required_fields($required);
            $crud->set_rules('pro_nombre', 'Nombre', 'trim|required|campo_unico[pro_profesion.pro_nombre]');
            $crud->field_type('pro_fecha_mod', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('pro_usu_mod', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('pro_fecha_crea', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('pro_usu_crea', 'hidden', $this->tank_auth->get_user_id());

            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('pro_estado', 'hidden', 1);
            } else {
                $crud->field_type('pro_estado', 'dropdown', array('1' => 'Activado', '0' => 'Desactivado'));
            }

            if(!$permisos["permite_editar"]){
                $crud->unset_edit();
            }
            if(!$permisos["permite_eliminar"]){
                $crud->unset_delete();
            }
            if(!$permisos["permite_agregar"]){
                $crud->unset_add();
            }
            if(!$permisos["permite_ver"]){
                $crud->unset_read();
            }

            $output = $crud->render();
            $data['titulo_personal'] = "Profesiones";
            $ruta_vista = (trim($ruta_vista) != '')? $ruta_vista:'expediente_personal/catalogos/profesion';
            cargarvista($data, $output, $ruta_vista);

        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
        
    }

    /**
     * Descripción:
     * Funcionalidad compartida de Estructura Organizativa>index(área)
     * @author Luis Navarro - Grupo Satélite
     * @since 2017-12-21
     * @param ninguno
     */
    function area_empresa($per_inv=null) {
        satelite_validar();
        $this->load->library('../controllers/estructura_organizativa/procesos');
        $this->procesos->index('expediente_personal/catalogos');
    }

    /*
    * Funcionalidad Compartida con el Modulo de Seleccion de Personal
    * Funcionalidad Compartida con el Modulo de compras
    */
    function tipo_documento($url_vista='') {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {

            $permisos = $this->gsatelite->get_permisos_opcion();
            $crud = new grocery_CRUD();
            $crud->set_subject('Tipo de documento');
            $crud->set_table('tde_tipo_documento');

            $columns = array(
                'tde_nombre', 
                'tde_mascara', 
                'tde_codigo_hacienda', 
                'tde_estado'
            );

            $display_as = array(
                'tde_nombre'    => 'Nombre',
                'tde_mascara'   => 'Máscara',
                'tde_codigo_hacienda'   => 'Código',
                'tde_estado'    => 'Estado'
            );

            $fields = array(
                'tde_nombre', 
                'tde_mascara', 
                'tde_codigo_hacienda', 
                'tde_estado', 
                'tde_usu_mod', 
                'tde_fecha_mod'
            );

            $required = array(
                'tde_nombre', 
                'tde_estado'
            );

            $crud->columns($columns);
            $crud->display_as($display_as);
            $crud->fields($fields);
            $crud->required_fields($required);
            $crud->set_rules('tde_nombre', 'Nombre', 'trim|required|campo_unico[tde_tipo_documento.tde_nombre]');
            $crud->field_type('tde_fecha_mod', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('tde_usu_mod', 'hidden', $this->tank_auth->get_user_id());
            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('tde_estado', 'hidden', 1);
            } else {
                $crud->field_type('tde_estado', 'dropdown', array('1' => 'Activado', '0' => 'Desactivado'));
            }

            if(!$permisos["permite_editar"]){
                $crud->unset_edit();
            }
            if(!$permisos["permite_eliminar"]){
                $crud->unset_delete();
            }
            if(!$permisos["permite_agregar"]){
                $crud->unset_add();
            }
            if($permisos["permite_ver"]){
                $data_url = $this->masterpage->getUsuario();
                $url_read = $data_url['modulo'] . '/' . $data_url['control'] . '/' . $data_url['funcion'];
                $crud->add_action('Ver', 'minia-icon-search', $url_read."/read");
            }
            
            $output    = $crud->render();
            $data['titulo_personal'] = "Tipos de documentos";
            cargarvista($data, $output, 'expediente_personal/catalogos/tipo_documento');
        }
    }

    /**
     * Descripción:
     * Mantenimieto de centros de costo - Funcionalidad compartida de Estructura organizativa
     * @author Raul E
     * @since  feb/2021
     */
    function centro_costos() {
        satelite_validar();
        $this->load->library('../controllers/estructura_organizativa/mantenimientos');
        $this->mantenimientos->centro_costos('expediente_personal/catalogos', 'centros_costo');
    }

    function clasificacion_cuentas() {
        satelite_validar();
        try {
            $permisos = $this->gsatelite->get_permisos_opcion();
            $url_actual = uri_string();
            $data['mandar_alerta'] = (substr_count($url_actual, 'success') > 0) ? true : false;
            $crud = new grocery_CRUD();
            $crud->unset_export();
            $crud->unset_print();
            $columns = array(
                'cft_nombre',
                'cft_descripcion',
                'cft_abreviacion',                
                'cft_estado'                
            );
            $display_as = array(
                'cft_nombre'    => 'Nombre',
                'cft_descripcion'  => 'Descripción',
                'cft_abreviacion'  => 'Abreviación',
                'cft_estado'    => 'Estado'
            );
            $add = array(
                'cft_nombre',
                'cft_descripcion',
                'cft_abreviacion',
                'cft_estado',
                'cft_fecha_creacion',
                'cft_usu_creacion',
                'cft_fecha_modificacion',
                'cft_usu_modificacion'               
            );
            $edit = array(
                'cft_nombre',
                'cft_descripcion',
                'cft_abreviacion',
                'cft_estado',
                'cft_fecha_modificacion',
                'cft_usu_modificacion'
            );
            $required = array(
                'cft_nombre',
                'cft_abreviacion',
                'cft_estado',
                'cft_fecha_modificacion',
                'cft_usu_modificacion'
            );            
            $crud->set_table('cft_clasificacion_cuenta_contable')
                ->set_subject('Clasificación cuenta contable')
                ->columns($columns)
                ->display_as($display_as)
                ->add_fields($add)
                ->edit_fields($edit)
                ->required_fields($required)
                ->field_type('cft_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
                ->field_type('cft_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())                
            ;
            $crud->set_rules('cft_nombre', 'Nombre', 'trim|required|campo_unico[cft_clasificacion_cuenta_contable.cft_nombre]');
            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('cft_estado', 'hidden', 1)
                    ->field_type('cft_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('cft_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
            } else {
                $crud->field_type('cft_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }
            if (!$permisos['permite_agregar']) {
              $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if ($permisos['permite_ver']) {
               $crud->add_action('Ver', 'icomoon-icon-search-3', 'modulo_contabilidad/catalogos/clasificacion_cuenta/read');
            }
            $output = $crud->render();
            $data['titulo_personal'] = "Clasificación cuentas";
            $this->_cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    function tipo_seguro() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $permisos = $this->gsatelite->get_permisos_opcion('expediente_personal/catalogos/tipo_seguro');
    
            $crud = new grocery_CRUD();
            $crud->set_subject('Tipo de seguro')->set_table('seg_seguro');
            $crud->columns('seg_nombre', 'seg_descripcion', 'seg_estado');
            $crud->display_as('seg_nombre', 'Nombre');
            $crud->display_as('seg_descripcion', 'Descripción');
            $crud->display_as('seg_estado', 'Estado');
            $crud->fields('seg_nombre', 'seg_descripcion', 'seg_estado', 'seg_fecha_mod', 'seg_usu_mod');
            $crud->required_fields('seg_nombre', 'seg_estado');
            $crud->field_type('seg_fecha_mod', 'hidden', date("Y-m-d H:i:s"));
            $crud->field_type('seg_usu_mod', 'hidden', $this->tank_auth->get_user_id());
            $crud->set_rules('seg_nombre', 'Nombre', 'trim|required|campo_unico[seg_seguro.seg_nombre]');
            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('seg_estado', 'hidden', 1);
            } else {
                $crud->field_type('seg_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            if(!$permisos["permite_editar"]){
                $crud->unset_edit();
            }
            if(!$permisos["permite_eliminar"]){
                $crud->unset_delete();
            }
            if(!$permisos["permite_agregar"]){
                $crud->unset_add();
            }
            if($permisos["permite_ver"]){
                $crud->add_action('&nbsp;&nbsp;Ver', '', 'expediente_personal/catalogos/tipo_seguro/read','icomoon-icon-search-3');
            }

            $output = $crud->render();
            $data['titulo_personal'] = "Tipos de seguro";
            $this->_cargarvista($data, $output);
        }
    }

    function tipo_contrato($ruta_vista = null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {

            //$ruta_vista es una array en la posición uno viene la ruta de los permisos a obtener en la dos viene la vista a cargar.
            //cuando viene la petición de otro modulo.
            $ruta_permisos = (is_array($ruta_vista)) ? $ruta_vista[0] : 'expediente_personal/catalogos/tipo_contrato'; 
            $arreglo_url = explode('/', $ruta_permisos);
            $data['modulo_url'] = $arreglo_url[0] . '/' . $arreglo_url[1]; //cuando viene la petición de otro modulo.
            $ruta_vista = (is_array($ruta_vista)) ? $ruta_vista[1] : null;

            $columns = array(
                'tic_nombre', 
                'tic_descripcion', 
                'tic_estado'
            );

            $display_as =array(
                'tic_nombre'        => 'Nombre',
                'tic_descripcion'   => 'Descripción',
                'tic_dias_vacacion' => 'Días Vacación',
                'tic_estado'        => 'Estado'
            );

            $fields = array(
                'tic_nombre', 
                'tic_descripcion', 
                'tic_estado', 
                'tic_dias_vacacion', 
                'tic_fecha_mod', 
                'tic_usu_mod'
            );

            $required = array(
                'tic_nombre', 
                'tic_estado'
            );

            $permisos = $this->gsatelite->get_permisos_opcion();
            $crud = new grocery_CRUD();
            $crud->set_subject('Tipo de contrato');
            $crud->set_table('tic_tipo_contrato');
            $crud->columns($columns);
            $crud->display_as($display_as);
            $crud->fields($fields);
            $crud->required_fields($required);
            $crud->field_type('tic_fecha_mod', 'hidden', date("Y-m-d H:i:s"));
            $crud->field_type('tic_usu_mod', 'hidden', $this->tank_auth->get_user_id());
            $crud->set_rules('tic_nombre', 'Nombre', 'trim|required|campo_unico[tic_tipo_contrato.tic_nombre]');

            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('tic_estado', 'hidden', 1);
            } else {
                $crud->field_type('tic_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            if(!$permisos["permite_editar"]){
                $crud->unset_edit();
            }
            if(!$permisos["permite_eliminar"]){
                $crud->unset_delete();
            }
            if(!$permisos["permite_agregar"]){
                $crud->unset_add();
            }
            if (!$permisos['permite_ver']) {
                $crud->unset_read();
            } else {
                $data_url = $this->masterpage->getUsuario();
                $url_read = $data_url['modulo'] . '/' . $data_url['control'] . '/' . $data_url['funcion'];
                $crud->add_action('Ver', 'minia-icon-search', $url_read."/read");
            }

            $output = $crud->render();
            $data['titulo_personal'] = "Tipos de contrato";
            $ruta_vista = (trim($ruta_vista) != '')? $ruta_vista:'expediente_personal/catalogos/tipo_contrato';
            cargarvista($data, $output, $ruta_vista);
        }
    }

    /**
     * @author René Castaneda
     * @since 16-02-2018
     * @return Mantenimiento plz_plaza
     */
    //==== INICIO COMPARTIR FUNCIONALIDAD DE MANTENIMIENTO DE PLAZA - ESTRUCTURA ORGANIZATIVA
    public function plazas()
    {
        satelite_validar();
        $this->load->library('../controllers/estructura_organizativa/procesos');
        $this->procesos->plazas();
    }

    public function agregar_plaza()
    {
        satelite_validar();
        $this->load->library('../controllers/estructura_organizativa/procesos');
        $this->procesos->agregar_plaza();
    }

    public function editar_plaza($plz_id, $ver = null, $modulo = null, $ruta = null)
    {
        satelite_validar();
        $this->load->library('../controllers/estructura_organizativa/procesos');
        $this->procesos->editar_plaza($plz_id, $ver, $modulo, $ruta);
    }

    //==== FIN COMPARTIR FUNCIONALIDAD DE MANTENIMIENTO DE PLAZA - ESTRUCTURA ORGANIZATIVA

    /**
     * @author René Castaneda
     * @return Mantenimiento plz_plaza
     */
    function plazasBK($otro_mod = null, $per_inv=null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            try {

                $idno = 0;
                $arreglo = explode('/', uri_string());
                if (is_numeric(end($arreglo))) {
                    $idno = end($arreglo);
                }

                if(count($per_inv)>0){
                    $permisos=$per_inv;
                }else{
                    $permisos = $this->gsatelite->get_permisos_opcion('expediente_personal/catalogos/plazas');
                }

                $crud = new grocery_CRUD();
                $crud->set_table('plz_plaza')
                        ->set_subject('Plaza / Cargo Funcional')
                        ->columns('plz_nombre', 'plz_id_padre', 'plz_id_pto', 'plz_salario_base', 'plz_id_are', 'plz_estado')
                        ->set_relation('plz_id_cec', 'cec_centro_costo', '{cec_nombre}', array('cec_estado' => 1))
                        ->set_relation('plz_id_are', 'are_area', 'are_nombre', array('are_estado' => 1))
                        ->set_relation('plz_id_padre', 'plz_plaza', 'plz_nombre', array('plz_estado' => 1, 'plz_id !=' => $idno))
                        ->set_relation('plz_id_pto', 'pto_puesto', 'pto_nombre', array('pto_estado' => 1))
                        ->display_as('plz_nombre', 'Nombre')
                        ->display_as('plz_estado', 'Estado')
                        ->display_as('plz_id_deh', 'Horario')
                        ->display_as('plz_id_pto', 'Puesto')
                        ->display_as('plz_id_are', 'Área')
                        ->display_as('plz_id_cec', 'Centro Costos')
                        ->display_as('plz_id_padre', 'Padre')
                        ->display_as('plz_salario_base', 'Salario Base')
                        ->fields('plz_nombre', 'plz_id_padre', 'plz_id_pto', 'plz_id_are', 'plz_salario_base', 'plz_id_cec', 'plz_id_deh', 'plz_estado', 'plz_usu_modificacion', 'plz_fecha_modificacion', 'plz_usu_creacion', 'plz_fecha_creacion')
                        ->required_fields('plz_nombre', 'plz_id_are', 'plz_salario_base', 'plz_estado', 'plz_usu_modificacion', 'plz_fecha_modificacion')
                        ->set_rules('plz_nombre', 'Nombre', 'trim|required')
                        ->field_type('plz_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                        ->field_type('plz_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
                        ->field_type('plz_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                        ->field_type('plz_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
                        ->unset_delete()
                ;

                $crud->set_relation('plz_id_deh','deh_detalle_horario','{deh_hora_entrada} - {deh_hora_salida}');
                
                if ($otro_mod != null) {
                    $crud->add_action('Duplicar Registro', '', 'sistema/catalogo/duplicar_plaza', 'duplicar_plaza icomoon-icon-copy-2');
                    $data['otro_mod'] = $otro_mod;
                } else {
                    $crud->add_action('Duplicar Registro', '', 'estructura_organizativa/procesos/duplicar_plaza', 'duplicar_plaza icomoon-icon-copy-2');
                }

                if (end(explode('/', uri_string())) == 'add') {
                    $crud->field_type('plz_estado', 'hidden', 1);
                    
                } else {
                    $crud->field_type('plz_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
                }
                  // Validaciones
                if (!$permisos['permite_agregar']) {
                    $crud->unset_add();
                }

                if (!$permisos['permite_editar']) {
                    $crud->unset_edit();
                }

                if (!$permisos['permite_eliminar']) {
                    $crud->unset_delete();
                }

                if ($permisos['permite_ver']) {
                    if(count($per_inv)>0){
                        $crud->add_action('Ver', 'minia-icon-search', 'inventario/mantenimiento/plazas/read');
                    }else{
                        $crud->add_action('Ver', 'minia-icon-search', 'expediente_personal/catalogos/plazas/read');

                    }
                }

                $data['titulo_personal'] = "Plazas / Cargos funcionales";

                $output = $crud->render();
                $this->_cargarvista($data, $output);
            } catch (Exception $e) {
                show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
            }
        }
    }

    /**
     * @author René Castaneda
     * @return Mantenimiento axp_anexoxpuesto
     */
    function puesto() {
        satelite_validar();
        $this->load->library('../controllers/estructura_organizativa/procesos');
        $this->procesos->puestos('expediente_personal/catalogos');
    }

    /**
     * Descripción:
     * Función para agregar puesto (tabla pto_puesto)
     * @author Luis Navarro - Grupo Satélite
     * @since 2017-12-20
     * @param Ninguno
     * @return Obtener la vista para agregar un puesto
     */
    function agregar_puesto() {
        satelite_validar();
        $this->load->library('../controllers/estructura_organizativa/procesos');
        $this->procesos->agregar_puesto('expediente_personal/catalogos', 'puesto');    
    }

    /**
     * Descripción:
     * Función para editar el puesto (tabla pto_puesto)
     * @author Luis Navarro - Grupo Satélite
     * @since 2017-12-20
     * @param Ninguno
     * @return Obtener la vista para editar puesto
     */
    function editar_puesto($pto_id = null) {
        satelite_validar();
        $this->load->library('../controllers/estructura_organizativa/procesos');
        $this->procesos->editar_puesto($pto_id, 'expediente_personal/catalogos', 'puesto');
    }

    /**
     * Descripción:
     * Función para obtener la vista de ver el registro de puesto
     * @author Luis Navarro - Grupo Satélite
     * @since 2017-12-20
     * @param $pto_id = ID del puesto que se desea ver
     * @return Obtener Vista de puesto
     */
    function ver_puesto($pto_id = null) {
        satelite_validar();
        $this->load->library('../controllers/estructura_organizativa/procesos');
        $this->procesos->ver_puesto($pto_id, 'expediente_personal/catalogos', 'puesto');
    }

    /**
     * Descripción:
     * Función para eliminar un puesto (tabla pto_puesto)
     * @author Luis Navarro - Grupo Satélite
     * @since 2017-12-20
     * @param $pto_id = ID del puesto
     * @return Eliminar un registro de puesto
     */
    function eliminar_puesto($pto_id = null) {
        satelite_validar();
        $this->load->library('../controllers/estructura_organizativa/procesos');
        $this->procesos->eliminar_puesto($pto_id, 'expediente_personal/catalogos', 'puesto');
    }

    /**
     * @author René Castaneda
     * @return Mantenimiento axp_anexoxpuesto
     */
    function anexos_puesto($id_puesto = null) {
        satelite_validar();
        $this->gsatelite->verificar_registro_real('pto_puesto', $id_puesto);
        $crud = new grocery_CRUD();
        $this->load->config('grocery_crud');
        $this->config->set_item('grocery_crud_file_upload_allow_file_types', 'pdf|jpeg|jpg|png|doc|xls|ppt');

        $crud->set_table('axp_anexoxpuesto')
                ->set_subject('Anexo Puesto')
                ->where('axp_anexoxpuesto.axp_id_pto', $id_puesto)
                ->columns('axp_id_pto', 'axp_nombre', 'axp_url', 'axp_estado')
                ->set_relation('axp_id_pto', 'pto_puesto', 'pto_nombre')
                ->fields('axp_id_pto', 'axp_nombre', 'axp_url', 'axp_estado', 'axp_usu_mod', 'axp_fecha_mod')
                ->display_as('axp_id_pto', 'Puesto')
                ->display_as('axp_nombre', 'Nombre')
                ->display_as('axp_url', 'Anexo')
                ->display_as('axp_estado', 'Estado')
                ->required_fields('axp_id_pto', 'axp_nombre', 'axp_url', 'axp_estado')
                ->set_rules('axp_nombre', 'Nombre', 'trim|required|campo_unico[axp_anexoxpuesto.axp_nombre]')
                ->field_type('axp_id_pto', 'hidden', $id_puesto)
                ->field_type('axp_estado', 'dropdown', array('1' => 'Activado', '0' => 'Desactivado'))
                ->field_type('axp_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('axp_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                ->set_field_upload('axp_url', 'uploads/anexos_puesto')
                ->unset_print()
                ->unset_delete()
                ->unset_export()
        ;

        $data['titulo_personal'] = "ANEXOS PUESTO";
        $output = $crud->render();
        $this->_cargarvista($data, $output);
    }

    function sucursal() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $permisos = $this->gsatelite->get_permisos_opcion();
            $id_empresa = $this->tank_auth->get_empresa_id();

            $display_as = array(
                'suc_codigo' => 'Código',
                'suc_nombre' => 'Nombre',
                'suc_id_mun' => 'Municipio',
                'suc_direccion' => 'Dirección'
            );

            $required_fields = array(
                'suc_nombre', 
                //'suc_codigo'
            );

            $fields = array(
                'suc_codigo', 
                'suc_nombre', 
                'suc_id_mun', 
                'suc_id_emr', 
                'suc_usu_mod', 
                'suc_fecha_mod', 
                'suc_direccion'
            );

            $columns = array(
                'suc_codigo', 
                'suc_nombre', 
                'suc_id_mun'
            );

            $crud = new grocery_CRUD();
            
            $estado_crud = $crud->getState();

            $crud->set_subject('Sucursal/Plantel')
                 ->set_table('suc_sucursal')
                 ->columns($columns)
                 ->display_as($display_as)
                 ->fields($fields)
                 ->required_fields($required_fields)
            ;
            
            $crud->set_relation('suc_id_mun', 'mun_municipio', 'mun_nombre', null);
            $crud->set_rules('suc_nombre', 'Nombre', "trim|required|campo_unico2[suc_sucursal.suc_nombre.suc_id_emr.$id_empresa]");
            $crud->set_rules('suc_codigo', 'Código', "trim|campo_unico2[suc_sucursal.suc_codigo.suc_id_emr.$id_empresa]");
            $crud->field_type('suc_id_emr', 'hidden', $this->tank_auth->get_empresa_id());
            $crud->field_type('suc_usu_mod', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('suc_fecha_mod', 'hidden', date('Y-m-d'));

            if(!$permisos["permite_editar"]){
                $crud->unset_edit();
            }
            if(!$permisos["permite_eliminar"]){
                $crud->unset_delete();
            }
            if(!$permisos["permite_agregar"]){
                $crud->unset_add();
            }
            if(!$permisos["permite_ver"]){
                $crud->unset_read();
            }


            $data['estado_crud'] = $estado_crud;
            $data['codigo_sugerido'] = '';
            if($estado_crud == 'add')
            {
                $codigo_sugerido = $this->get_codigo_sucursal();

                $data['codigo_sugerido'] = $codigo_sugerido;
            }

            //print_r($data); die();
            //Added by René Castaneda 05-03-2018
            //actualizar al id de empresa según la sessión del usuario (dado que es un cambio nuevo)
            $this->gsatelite->actualizar_empresa_id('suc_sucursal');
            //condicionar empresa segun sessión del usuario
            $crud->where('suc_id_emr', $this->tank_auth->get_empresa_id());

            $output = $crud->render();
            $data['titulo_personal'] = "Sucursal/Plantel";
            $this->_cargarvista($data, $output);
        }
    }

    function tipos_descuento() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        }

        $campos = array(
            'tdc_nombre' => 'Nombre'
            , 'tdc_cuota' => 'Cuota'
            , 'tdc_porcentaje' => 'Porcentaje'
            , 'tdc_porcentaje_patronal' => 'Aporte Patronal'
            , 'tdc_desde' => 'Desde'
            , 'tdc_hasta' => 'Hasta'
            , 'tdc_minimo' => 'Mínimo'
            , 'tdc_maximo' => 'Máximo'
            , 'tdc_agrupador' => 'Agrupador'
                //, 'tdc_tipo'      => 'Tipo'
        );

        $columns = array(
            'tdc_nombre',
            'tdc_hasta', 'tdc_agrupador');
        $required_fields = array(
            'tdc_nombre',
            //'tdc_tipo',
            'tdc_agrupador');

        $crud = new grocery_CRUD();
        $crud->set_table('tdc_tipo_descuento')
                ->set_subject('Descuento')
                ->columns($columns)
                ->fields('tdc_nombre', 'tdc_cuota', 'tdc_porcentaje', 'tdc_desde', 'tdc_hasta', 'tdc_minimo', 'tdc_maximo', 'tdc_agrupador')
                ->required_fields($required_fields)
                ->display_as($campos)
                ->set_rules('tdc_nombre', 'Nombre', 'trim|required|campo_unico[tdc_tipo_descuento.tdc_nombre]')
                //->field_type('tdc_tipo', 'dropdown', array(1=>'Monto Definido', 2=> 'Porcentaje', 3=> 'Minimo y Maximo', 4=> 'Renta (min_max+porcentaje)'))
                ->unset_export()
                ->unset_print();
        $crud->set_relation('tdc_agrupador', 'tag_tipo_agrupador', '{tag_nombre}');
        $data['titulo_personal'] = "TIPO DE DESCUENTO";

        $this->_cargarvista($data, $crud->render());
    }

    function tipos_ingreso() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        }

        $campos = array(
            'tig_codigo' => 'Código',
            'tig_nombre' => 'Nombre',
            'tig_cuenta_contable' => 'Cuenta Contable',
            'tig_estado' => 'Estado',
            'tig_descripcion' => 'Descripción',
            'tig_gravado' => 'Gravado'
        );

        $add_columns = array(
            'tig_codigo',
            'tig_nombre',
            'tig_estado',
            'tig_descripcion',
            'tig_gravado'
        );

        $required_fields = array(
            'tig_codigo',
            'tig_nombre',
            'tig_estado',
            'tig_gravado');

        $crud = new grocery_CRUD();
        $crud->set_table('tig_tipo_ingreso')
                ->set_subject('Ingreso')
                ->columns('tig_nombre', 'tig_estado')
                ->display_as($campos)
                ->add_fields($add_columns)
                ->edit_fields($add_columns)
                ->required_fields($required_fields)
                ->field_type('tig_estado', 'dropdown', array(0 => 'Inactivo', 1 => 'Activo'))
                ->field_type('tig_gravado', 'dropdown', array(0 => 'No aplica', 1 => 'Aplica'))
                ->set_rules('tig_nombre', 'Nombre', 'trim|required|campo_unico[tig_tipo_ingreso.tig_nombre]')
                ->set_rules('tig_codigo', 'Código', 'trim|required|campo_unico[tig_tipo_ingreso.tig_codigo]');
        $data['titulo_personal'] = "Tipo de ingreso";
        $this->_cargarvista($data, $crud->render());
    }

    function afp() {
        //El mantenimiento existe tambien en /personal/catalogos/afp
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $permisos = $this->gsatelite->get_permisos_opcion('expediente_personal/catalogos/afp');
            $ctas_padres = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_estado' => 1, 'cnt_id_cnt_padre IS NOT NULL' => NULL));
            $padres = (count($ctas_padres) > 0) ? implode(',', array_unique(array_column($ctas_padres, 'cnt_id_cnt_padre'))) : 0;
            $crud = new grocery_CRUD();
            $crud->set_subject('AFP')->set_table('afp_afp');
            $crud->columns('afp_nombre', 'afp_porcentaje', 'afp_porcentaje_patrono', 'afp_activo');
            $crud->set_relation('afp_id_cnt', 'cnt_cuenta_contable', '{cnt_cuenta} - {cnt_nombre}', array('cnt_estado'=>1));
            $crud->set_relation('afp_id_cnt_patrono', 'cnt_cuenta_contable', '{cnt_cuenta} - {cnt_nombre}', array("cnt_estado" => 1, "cnt_id NOT IN ( $padres )" => null));
            $crud->display_as('afp_nombre', 'Nombre')
                    ->display_as('afp_porcentaje', 'Porcentaje descuento empleado')
                    ->display_as('afp_activo', 'Activo')
                    ->display_as('afp_id_cnt', 'Cuenta contable aporte empleado')
                    ->display_as('afp_porcentaje_patrono', 'Porcentaje descuento patrono')
                    ->display_as('afp_maximo', 'Techo salarial')
                    ->display_as('afp_id_cnt_patrono', 'Cuenta contable aporte patronal');
            $crud->fields('afp_nombre','afp_porcentaje', 'afp_porcentaje_patrono','afp_maximo','afp_id_cnt','afp_id_cnt_patrono','afp_activo');
            $crud->required_fields('afp_nombre','afp_porcentaje_patrono', 'afp_porcentaje','afp_activo', 'afp_maximo');
            $crud->set_rules('afp_nombre','Nombre','trim|required|campo_unico[afp_afp.afp_nombre]');
            $crud->unset_edit();
            $crud->unset_delete();
            if(end(explode('/',uri_string()))=='add') {
                $crud->field_type('afp_activo','hidden',1);
            }else {
                $crud->field_type('afp_activo','dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }
            if($permisos["permite_editar"]){
                $crud->add_action('&nbsp;&nbsp;Editar', '', 'expediente_personal/catalogos/editar_afp','icomoon-icon-pencil-5');  
            }
            if($permisos["permite_eliminar"]){
                $crud->add_action('&nbsp;&nbsp;Inactivar', '', 'expediente_personal/catalogos/eliminar_afp','icomoon-icon-remove');
            }
            if(!$permisos["permite_agregar"]){
                $crud->unset_add();
            }
            if($permisos["permite_ver"]){
                // $crud->add_action('&nbsp;&nbsp;Ver', '', 'expediente_personal/catalogos/afp/read','icomoon-icon-search-3');
            }
            $output = $crud->render();
            $this->_cargarvista(null, $output);
        }
    }

    public function agregar_afp(){
        satelite_validar();
        if ( $this->input->post() ) {
            $afp_nombre             = ($this->input->post('txt_nombre_afp') != '')? $this->input->post('txt_nombre_afp') : ""; 
            $afp_maximo             = ($this->input->post('txt_salario') != '')? $this->input->post('txt_salario') : 0;
            $afp_porcentaje         = ($this->input->post('txt_porcentaje_empleado') != '')? $this->input->post('txt_porcentaje_empleado') : 0;
            $afp_porcentaje_patrono = ($this->input->post('txt_porcentaje_patrono') != '')? $this->input->post('txt_porcentaje_patrono') : 0;
            $codigo_del_usuario     = ($this->input->post('afp_internal_code') != '')? $this->input->post('afp_internal_code') : null;
            $afp_afp = array (
                "afp_codigo_interno"    => $codigo_del_usuario,
                "afp_nombre"            => $afp_nombre, 
                "afp_porcentaje"        => $afp_porcentaje,
                "afp_porcentaje_patrono"=> $afp_porcentaje_patrono,
                "afp_maximo"            => $afp_maximo,
                "afp_activo"            => 1
            );      
            $id_afp = $this->gsatelite->ingresar('afp_afp', $afp_afp );
            $centro_costo            = ($this->input->post('dtll_centro_costo') != '')? $this->input->post('dtll_centro_costo') : null;
            $tipo_cuenta             = ($this->input->post('dtll_tipo_cuenta') != '')? $this->input->post('dtll_tipo_cuenta') : null;
            $cuentas                 = ($this->input->post('dtll_cuenta') != '')? $this->input->post('dtll_cuenta') : null;
            $dff_detalle_finanza_afp = [];
            foreach ($cuentas as $key => $cuenta) {
                $dff_detalle_finanza_afp[] = array(
                    "dff_id_afp"            => $id_afp,
                    "dff_id_cnt"            => $cuenta,
                    "dff_id_tcn"            => $tipo_cuenta[$key],
                    "dff_id_cec"            => $centro_costo[$key],
                    "dff_estado"            => 1,
                    "dff_usu_creacion"      => $this->tank_auth->get_user_id(),
                    "dff_fecha_creacion"    => date('Y-m-d h:i:s'),
                    "dff_usu_modificacion"  => $this->tank_auth->get_user_id(),
                    "dff_fecha_modificacion"=> date('Y-m-d h:i:s'),
                );
            }
            if ( count($dff_detalle_finanza_afp) >0 ) {
                $this->gsatelite->ingresar('dff_detalle_finanza_afp', $dff_detalle_finanza_afp, true);
            }
            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro de AFP", 'texto_alerta' => "El registro se ingreso correctamente.");
            $this->session->set_flashdata($alerta);
            $redireccion = ($this->input->post('crear') != '')? $this->input->post('crear') : 1;
            if ($redireccion == 1) {
                redirect('expediente_personal/catalogos/agregar_afp');
            } else {
                redirect('expediente_personal/catalogos/afp');
            }
        } else{
            //Centro de costos
            $centro_costo         = $this->gsatelite->get_dropdown('cec_centro_costo', '{cec_nombre}', '', array('cec_estado' => 1), null, '', 'cec_id', true);
            $data["centro_costo"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $centro_costo);
            //tipo de cuenta
            $tipo_cuenta         = $this->gsatelite->get_dropdown('tcn_tipo_cuenta', '{tcn_nombre}', '', array('tcn_estado' => 1), null, '', 'tcn_id', true);
            $data["tipo_cuenta"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $tipo_cuenta);      
            //cuenta contable
            $ctas_padres = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_estado' => 1, 'cnt_id_cnt_padre IS NOT NULL' => NULL));
            $padres = (count($ctas_padres) > 0) ? implode(',', array_unique(array_column($ctas_padres, 'cnt_id_cnt_padre'))) : 0;
            $cuenta = $this->gsatelite->get_dropdown('cnt_cuenta_contable', '{cnt_cuenta} - {cnt_nombre}', '', array("cnt_estado" => 1, "cnt_id NOT IN ($padres)" => null), null, '', 'cnt_id', true);
            $data["cuentas"]  = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $cuenta);
            $data['titulo_personal'] = "Agregar AFP";
            $data['decimales']       = $this->gsatelite->get_parametro('NUMERO_DECIMALES', 2);
            $this->_cargarvista($data);
        }
    }

    public function editar_afp($afp = null){ 
        satelite_validar();
        if ($this->input->post()) {
            $afp_nombre             = ($this->input->post('txt_nombre_afp') != '')? $this->input->post('txt_nombre_afp') : ""; 
            $afp_maximo             = ($this->input->post('txt_salario') != '')? $this->input->post('txt_salario') : 0;
            $afp_porcentaje         = ($this->input->post('txt_porcentaje_empleado') != '')? $this->input->post('txt_porcentaje_empleado') : 0;
            $afp_porcentaje_patrono = ($this->input->post('txt_porcentaje_patrono') != '')? $this->input->post('txt_porcentaje_patrono') : 0;
            $afp_activo             = ($this->input->post('slc_estado') != '')? $this->input->post('slc_estado') : 0;
            $codigo_del_usuario     = ($this->input->post('afp_internal_code') != '')? $this->input->post('afp_internal_code') : null;
            $afp                    = ($this->input->post('txt_afp') != '')? $this->input->post('txt_afp') : 0;
            $afp_afp = array (
                "afp_codigo_interno"    => $codigo_del_usuario,
                "afp_nombre"            => $afp_nombre, 
                "afp_porcentaje"        => $afp_porcentaje,
                "afp_porcentaje_patrono"=> $afp_porcentaje_patrono,
                "afp_maximo"            => $afp_maximo,
                "afp_activo"            => $afp_activo
            );      
            $this->gsatelite->actualizar_array('afp_afp', $afp_afp, array('afp_id' => $afp) );
            $centro_costo            = ($this->input->post('dtll_centro_costo') != '')? $this->input->post('dtll_centro_costo') : null;
            $tipo_cuenta             = ($this->input->post('dtll_tipo_cuenta') != '')? $this->input->post('dtll_tipo_cuenta') : null;
            $cuentas                 = ($this->input->post('dtll_cuenta') != '')? $this->input->post('dtll_cuenta') : null;
            $old_detalle             = ($this->input->post('dtll_old') != '')? $this->input->post('dtll_old') : null;
            $dff_detalle_finanza_afp = [];
            $dff_detalle_finanza_old= $this->gsatelite->get_tabla("dff_detalle_finanza_afp",array("dff_id_afp"=>$afp));
            foreach ($dff_detalle_finanza_old as $data) {
                if (!in_array($data['dff_id'], $old_detalle)) {
                    $this->gsatelite->borrado_general('dff_detalle_finanza_afp', array('dff_id' => $data['dff_id']));
                }
            }
            foreach ($cuentas as $key => $cuenta) {
                if ($old_detalle[$key] == "") {
                    $dff_detalle_finanza_afp[] = array(
                        "dff_id_afp"            => $afp,
                        "dff_id_cnt"            => $cuenta,
                        "dff_id_tcn"            => $tipo_cuenta[$key],
                        "dff_id_cec"            => $centro_costo[$key],
                        "dff_estado"            => 1,
                        "dff_usu_creacion"      => $this->tank_auth->get_user_id(),
                        "dff_fecha_creacion"    => date('Y-m-d h:i:s'),
                        "dff_usu_modificacion"  => $this->tank_auth->get_user_id(),
                        "dff_fecha_modificacion"=> date('Y-m-d h:i:s'),
                    );
                } else {
                    $dff_detalle_finanza_afp_update = array(
                        "dff_id_cnt"            => $cuenta,
                        "dff_id_tcn"            => $tipo_cuenta[$key],
                        "dff_id_cec"            => $centro_costo[$key],
                        "dff_estado"            => 1,
                        "dff_usu_modificacion"  => $this->tank_auth->get_user_id(),
                        "dff_fecha_modificacion"=> date('Y-m-d h:i:s'),
                    );
                    $this->gsatelite->actualizar_array('dff_detalle_finanza_afp', $dff_detalle_finanza_afp_update, array('dff_id' => $old_detalle[$key]) );
                }
            }
            if ( count($dff_detalle_finanza_afp) >0 ) {
                $this->gsatelite->ingresar('dff_detalle_finanza_afp', $dff_detalle_finanza_afp, true);
            }
            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro de AFP", 'texto_alerta' => "El registro se ingreso correctamente.");
            $this->session->set_flashdata($alerta);
            $redireccion = ($this->input->post('crear') != '')? $this->input->post('crear') : 1;
            if ($redireccion == 1) {
                redirect('expediente_personal/catalogos/editar_afp/'.$afp);
            } else {
                redirect('expediente_personal/catalogos/afp');
            }
        } else {
            $centro_costo         = $this->gsatelite->get_dropdown('cec_centro_costo', '{cec_nombre}', '', array('cec_estado' => 1), null, '', 'cec_id', true);
            $data["centro_costo"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $centro_costo);
            $tipo_cuenta          = $this->gsatelite->get_dropdown('tcn_tipo_cuenta', '{tcn_nombre}', '', array('tcn_estado' => 1), null, '', 'tcn_id', true);
            $data["tipo_cuenta"]  = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $tipo_cuenta);   
            $ctas_padres = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_estado' => 1, 'cnt_id_cnt_padre IS NOT NULL' => NULL));
            $padres = (count($ctas_padres) > 0) ? implode(',', array_unique(array_column($ctas_padres, 'cnt_id_cnt_padre'))) : 0;
            $cuenta = $this->gsatelite->get_dropdown('cnt_cuenta_contable', '{cnt_cuenta} - {cnt_nombre}', '', array("cnt_estado" => 1, "cnt_id NOT IN ($padres)" => null), null, '', 'cnt_id', true);
            $data["cuentas"]  = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $cuenta);
            $data["afp"]             = $this->personal_model->get_detalles_afp(array("afp_id" => $afp),null);
            $data['titulo_personal'] = "Editar AFP";
            $data['decimales']       = $this->gsatelite->get_parametro('NUMERO_DECIMALES', 2);
            $this->_cargarvista($data);
        }
    }

    public function eliminar_afp($afp = null){ 
        satelite_validar();
        $this->gsatelite->actualizar_array('afp_afp', array('afp_activo'=>0), array('afp_id'=>$afp) );   
        redirect('expediente_personal/catalogos/afp');
        die();
    }

    function isr() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {

            $crud = new grocery_CRUD;
            $crud = new grocery_CRUD();
            $crud->set_subject('ISR')->set_table('isr_isr');
            $crud->columns('isr_desc', 'isr_desde', 'isr_hasta', 'isr_porcentaje', 'isr_exceso', 'isr_cuota');
            $crud->display_as('isr_desc', 'ISR');
            $crud->display_as('isr_desde', 'Desde');
            $crud->display_as('isr_hasta', 'Hasta');
            $crud->display_as('isr_porcentaje', 'Porcentaje');
            $crud->display_as('isr_exceso', 'Exceso');
            $crud->display_as('isr_cuota', 'Cuota');
            $crud->required_fields('isr_desc', 'isr_desde', 'isr_hasta', 'isr_porcentaje', 'isr_exceso', 'isr_cuota');
            $crud->fields('isr_id_tis', 'isr_desc', 'isr_desde', 'isr_hasta', 'isr_porcentaje', 'isr_exceso', 'isr_cuota');
            $crud->order_by('isr_id_tis');
            $crud->unset_delete();
            $crud->unset_export();
            $crud->unset_print();


            if (($cub_id = $this->input->get('cub_id')) > 0) {
                $crud->where(array('isr_id_tis' => $cub_id));
            }

            $crud->set_primary_key('isr_id', 'isr_isr')
                    ->set_relation('isr_id_tis', 'tis_tipo_isr', 'cuenta');
            $crud->set_relation('isr_id_tis', 'tis_tipo_isr', 'tis_desc');

            $output = $crud->render();
            $cuentas[0] = 'Seleccione';
            foreach ($this->db->get('tis_tipo_isr')->result() as $row) {
                $cuentas[$row->tis_id] = $row->tis_desc;
            }

            $data = array(
                'cuentas' => $cuentas
            );


            $this->_cargarvista($data, $output);
        }
    }

    function tipo_isr() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {

            $crud = new grocery_CRUD;
            $crud = new grocery_CRUD();
            $crud->set_subject('tipo ISR')->set_table('tis_tipo_isr');
            $crud->columns('tis_desc', 'tis_vigente');
            $crud->display_as('tis_desc', 'Tipo de ISR');
            $crud->display_as('tis_vigente', 'Estado');
            $crud->fields('tis_desc', 'tis_vigente');
            $crud->required_fields('tis_desc', 'tis_vigente');
            $crud->unset_delete();
            $crud->unset_export();
            $crud->unset_print();
            $output = $crud->render();
            $data = "";
            $this->_cargarvista($data, $output);
        }
    }

    function ing_des_pla($id) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data['titulo_personal'] = "Ingresos y descuentos de planilla";
            $data['tpl'] = $this->personal_model->get_tabla('tpl_tipo_planilla', array('tpl_id' => $id));
            $data['desxpla'] = $this->personal_model->get_ing_des('dtp_descuentoxtipo_planilla', array('dtp_id_tpl' => $id), 1);
            $data['descuentos'] = $this->personal_model->get_det_ing_des('tdc_tipo_descuento', $data['desxpla'], 'dtp_id_tdc', 'tdc_id', 'tdc_agrupador');
            $data['ingxpla'] = $this->personal_model->get_ing_des('itp_ingresoxtipo_planilla', array('itp_id_tpl' => $id), 2);
            $data['ingresos'] = $this->personal_model->get_det_ing_des('tig_tipo_ingreso', $data['ingxpla'], 'itp_id_tig', 'tig_id', null);
            if ($_POST) { /* print_r($_POST);
              exit(); */
                if ($_POST['boton'] == 'ingreso') {
                    $ingreso = array(
                        'itp_id_tpl' => (int) $id,
                        'itp_id_tig' => (int) $_POST['ingreso']
                    );
                    $registro = $this->personal_model->add_regitro('itp_ingresoxtipo_planilla', $ingreso);
                    if ($registro > 0)
                        $alerta = array('registro' => $registro, 'tipo_alerta' => 'success', 'titulo_alerta' => "Registro ingresado", 'texto_alerta' => "El registro se ha ingresado correctamente");
                    else
                        $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro no ingresado", 'texto_alerta' => "El registro no se pudo ingresar verifique la informacion ingresada");
                    $this->session->set_flashdata($alerta);
                    redirect('personal/catalogos/ing_des_pla/' . $id);
                }
                if ($_POST['boton'] == 'descuento') {
                    $descuento = array(
                        'dtp_id_tpl' => (int) $id,
                        'dtp_id_tdc' => (int) $_POST['descuento']
                    );
                    $registro = $this->personal_model->add_regitro('dtp_descuentoxtipo_planilla', $descuento);
                    if ($registro > 0)
                        $alerta = array('registro' => $registro, 'tipo_alerta' => 'success', 'titulo_alerta' => "Registro ingresado", 'texto_alerta' => "El registro se ha ingresado correctamente");
                    else
                        $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro no ingresado", 'texto_alerta' => "El registro no se pudo ingresar verifique la informacion ingresada");
                    $this->session->set_flashdata($alerta);
                    redirect('personal/catalogos/ing_des_pla/' . $id);
                }
            }
            $this->_cargarvista($data);
        }
    }

    public function eliminar($tipo, $id_tipo, $planilla) {

        if ($tipo == "ing") {
            $this->db->where('itp_id', $id_tipo)
                    ->where('itp_id_tpl', $planilla)
                    ->delete('itp_ingresoxtipo_planilla');
            $alerta = array('registro' => $registro, 'tipo_alerta' => 'success', 'titulo_alerta' => "Registro eliminado", 'texto_alerta' => "El registro se ha eliminado correctamente");
            redirect('expediente_personal/catalogos/ing_des_pla/' . $planilla);
        } else if ($tipo == "des") {
            $this->db->where('dtp_id', $id_tipo)
                    ->where('dtp_id_tpl', $planilla)
                    ->delete('dtp_descuentoxtipo_planilla');
            $alerta = array('registro' => $registro, 'tipo_alerta' => 'success', 'titulo_alerta' => "Registro eliminado", 'texto_alerta' => "El registro se ha eliminado correctamente");
            redirect('expediente_personal/catalogos/ing_des_pla/' . $planilla);
        } else if ($tipo == "isr") {
            $this->db->where('txt_id', $id_tipo)
                    ->where('txt_id_tpl', $planilla)
                    ->delete('txt_tipo_planillaxtipo_isr');
            $alerta = array('registro' => $registro, 'tipo_alerta' => 'success', 'titulo_alerta' => "Registro eliminado", 'texto_alerta' => "El registro se ha eliminado correctamente");
            redirect('expediente_personal/catalogos/pla_isr/' . $planilla);
        }
    }

    function tipo_planilla() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $emr_id = $this->tank_auth->get_empresa_id();
            $this->gsatelite->actualizar_empresa_id('tpl_tipo_planilla');
            $crud = new grocery_CRUD();
            
            $crud->set_subject('Tipos de planilla')->set_table('tpl_tipo_planilla');
            $crud->columns('tpl_nombre', 'tpl_prefijo', 'tpl_desc', 'tpl_cantidad', 'tpl_frecuencia');
            $crud->display_as('tpl_nombre', 'Nombre')
                    ->display_as('tpl_prefijo', 'Prefijo')
                    ->display_as('tpl_desc', 'Descripción')
                    ->display_as('tpl_cantidad', 'Cantidad')
                    ->display_as('tpl_tipo_liquidacion', 'Planilla de Liquidación')
                    ->display_as('tpl_frecuencia', 'Frecuencia');
            $crud->add_fields('tpl_nombre', 'tpl_prefijo', 'tpl_desc', 'tpl_cantidad', 'tpl_frecuencia', 'tpl_id_emr', 'tpl_usu_creacion', 'tpl_fecha_creacion', 'tpl_tipo_liquidacion');
            $crud->edit_fields('tpl_nombre', 'tpl_prefijo', 'tpl_desc', 'tpl_cantidad', 'tpl_frecuencia', 'tpl_usu_modificacion', 'tpl_fecha_modificacion', 'tpl_tipo_liquidacion');
            $crud->required_fields('tpl_nombre', 'tpl_prefijo', 'tpl_cantidad', 'tpl_frecuencia');
            $crud->field_type('tpl_id_emr', 'hidden', $emr_id)
                    ->field_type('tpl_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('tpl_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
                    ->field_type('tpl_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('tpl_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->set_rules('tpl_nombre', 'Nombre', 'trim|required|campo_unico2[tpl_tipo_planilla.tpl_nombre.tpl_id_emr.' . $emr_id . ']')
                    ->set_rules('tpl_prefijo', 'Prefijo', 'trim|required|campo_unico2[tpl_tipo_planilla.tpl_prefijo.tpl_id_emr.' . $emr_id . ']')
                    ->where('tpl_id_emr', $emr_id);
            $crud->add_action('Gestionar', '', 'expediente_personal/catalogos/ing_des_pla', 'icomoon-icon-cogs', null, "", array('tpl_tipo_liquidacion' => 0));
            $crud->add_action('ISR', '', 'expediente_personal/catalogos/pla_isr', 'brocco-icon-list', null, "", array('tpl_tipo_liquidacion' => 0));

            $crud->callback_add_field('tpl_tipo_liquidacion', function() {
                return '<input type="checkbox" id="chk_liquidar" class="nostyle"><input type="hidden" id="field-tpl_tipo_liquidacion" name="tpl_tipo_liquidacion" value="0">';
            });
            $crud->callback_edit_field('tpl_tipo_liquidacion', function($value, $primary_key) {
                $ver = ($this->uri->rsegments[3] == 'read') ? 'readonly ' : ''; 
                $dft = ($value) ? 'checked' : ''; 
                return '<input type="checkbox" id="chk_liquidar" '.$dft.' class="nostyle" '.$ver.'><input type="hidden" id="field-tpl_tipo_liquidacion" name="tpl_tipo_liquidacion" value="'.$value.'">';
            });
            $crud->callback_after_insert(function($post_array, $primary_key){
                if ($post_array['tpl_tipo_liquidacion'] > 0) {
                    $CI = & get_instance();
                    $CI->gsatelite->actualizar_array('tpl_tipo_planilla', array('tpl_tipo_liquidacion' => 0), array('tpl_id != ' => $primary_key));
                    $valor_act = json_decode($CI->gsatelite->get_parametro('SYS_CONFIGURACION_LIQUIDACION', null, null, true), true);
                    $valor_act['ID_TIPO_PLANILLA_LIQ'] = strval($primary_key);
                    $nu_val = json_encode($valor_act);
                    $CI->gsatelite->actualizar('par_parametro', array("par_valor" => $nu_val), 'par_codigo', 'SYS_CONFIGURACION_LIQUIDACION');
                }
                return $post_array;
            });
            $crud->callback_after_update(function($post_array, $primary_key){
                if ($post_array['tpl_tipo_liquidacion'] > 0) {
                    $CI = & get_instance();
                    $CI->gsatelite->actualizar_array('tpl_tipo_planilla', array('tpl_tipo_liquidacion' => 0), array('tpl_id != ' => $primary_key));
                    $valor_act = json_decode($CI->gsatelite->get_parametro('SYS_CONFIGURACION_LIQUIDACION', null, null, true), true);
                    $valor_act['ID_TIPO_PLANILLA_LIQ'] = strval($primary_key);
                    $nu_val = json_encode($valor_act);
                    $CI->gsatelite->actualizar('par_parametro', array("par_valor" => $nu_val), 'par_codigo', 'SYS_CONFIGURACION_LIQUIDACION');
                                $this->db->join('pis_periodo_isr', 'pis_id_txt = txt_id');
                    $have_isr = $CI->gsatelite->get_tabla('txt_tipo_planillaxtipo_isr',array('txt_id_tpl' => $primary_key));
                    if (count($have_isr) > 0) {
                        $CI->gsatelite->borrado_general('pis_periodo_isr', array('pis_id_txt' => $have_isr[0]['txt_id']));
                        $CI->gsatelite->borrado_general('txt_tipo_planillaxtipo_isr', array('txt_id_tpl' => $primary_key));
                    }
                    $CI->gsatelite->borrado_general('itp_ingresoxtipo_planilla', array('itp_id_tpl' => $primary_key));
                    $CI->gsatelite->borrado_general('dtp_descuentoxtipo_planilla', array('dtp_id_tpl' => $primary_key));
                }
                return $post_array;
            });
            
            $output = $crud->render();
            $data['titulo_personal'] = "TIPO DE PLANILLA";
            $this->_cargarvista($data, $output);
        }
    }

    function pla_isr($id) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data['titulo_personal'] = "Planilla por ISR";
            $data['tpl'] = $this->personal_model->get_tabla('tpl_tipo_planilla', array('tpl_id' => $id));
            $data['isrxpla'] = $this->personal_model->get_ing_des('txt_tipo_planillaxtipo_isr', array('txt_id_tpl' => $id), 3);
            $data['isr'] = $this->personal_model->get_det_ing_des('tis_tipo_isr', $data['isrxpla'], 'txt_id_tis', 'tis_id');

            if ($_POST) {
                $ingreso = array(
                    'txt_id_tpl' => (int) $id,
                    'txt_id_tis' => (int) $_POST['isr']
                );
                $registro = $this->personal_model->add_regitro('txt_tipo_planillaxtipo_isr', $ingreso);
                if ($registro > 0)
                    $alerta = array('registro' => $registro, 'tipo_alerta' => 'success', 'titulo_alerta' => "Registro ingresado", 'texto_alerta' => "El registro se ha ingresado correctamente");
                else
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro no ingresado", 'texto_alerta' => "El registro no se pudo ingresar verifique la informacion ingresada");
                $this->session->set_flashdata($alerta);
                redirect('personal/catalogos/pla_isr/' . $id);
            }
            $this->_cargarvista($data);
        }
    }

    /**
     * @author Boris Estrada
     */
    function agrupadores() {
        $crud = new grocery_CRUD();
        $crud->set_table('tag_tipo_agrupador')
                ->set_subject('Agrupadores')
                ->columns('tag_nombre', 'tag_tipo', 'tag_estado', 'ingresos', 'descuentos')
                ->fields('tag_nombre', 'tag_tipo', 'tag_estado', 'ingresos', 'descuentos')
                ->set_rules('tag_nombre', 'Nombre', 'trim|required|campo_unico[tag_tipo_agrupador.tag_nombre]')
                ->display_as('tag_estado', 'Estado')->field_type('tag_estado', 'dropdown', array('0' => 'Inactivo', '1' => 'Activo'))
                ->display_as('tag_tipo', 'Tipo')->field_type('tag_tipo', 'dropdown', array('C' => 'C', 'R' => 'R'))
                ->display_as('tag_nombre', 'Nombre')
                ->display_as('tag_descripcion', 'Descripción')
                ->required_fields('tag_nombre', 'tag_tipo', 'tag_estado')
        ;
        $ingresos = $this->consultas->ingresos();
        $descuentos = $this->consultas->descuentos();
        $crud->set_relation_n_n('ingresos', 'deg_detalle_agrupador', 'tig_tipo_ingreso', 'deg_id_tag', 'deg_id_tig', 'tig_nombre', null, "tig_id in ($ingresos)");
        $crud->set_relation_n_n('descuentos', 'deg_detalle_agrupador', 'tdc_tipo_descuento', 'deg_id_tag', 'deg_id_tdc', 'tdc_nombre', null, "tdc_id in ($descuentos)");
        $crud->callback_after_insert(function($post_array, $primary_key) {
            $this->personal_model->agrupadores(array('deg_id_tag' => $primary_key));
            return TRUE;
        });
        $crud->callback_after_update(function($post_array, $primary_key) {
            $this->personal_model->agrupadores(array('deg_id_tag' => $primary_key));
            return TRUE;
        });
        $crud->unset_delete();
        $this->_cargarvista(null, $crud->render());
    }

    /**
     * @author Mario Marquez
     * Funcionalidad Compartida con el Modulo de Seleccion de Personal
     */
    public function paises() {
        satelite_validar();

        //$ruta_vista es una array en la posición uno viene la ruta de los permisos a obtener en la dos viene la vista a cargar.
        //cuando viene la petición de otro modulo.
        $ruta_permisos = (is_array($ruta_vista)) ? $ruta_vista[0] : 'expediente_personal/catalogos/paises'; 
        $arreglo_url = explode('/', $ruta_permisos);
        $data['modulo_url'] = $arreglo_url[0] . '/' . $arreglo_url[1]; //cuando viene la petición de otro modulo.
        $ruta_vista = (is_array($ruta_vista)) ? $ruta_vista[1] : null;

        try {
            $permisos = $this->gsatelite->get_permisos_opcion();
            $crud = new grocery_CRUD();
            $crud->unset_export();
            $crud->unset_print();
            $crud->set_table('pai_pais');
            $crud->set_subject('Nacionalidades');

            $columnas = array(
                'pai_nombre',
                'pai_nacionalidad',
                'pai_estado'
            );

            $display_as = array(
                'pai_nombre'        => 'Nombre',
                'pai_nacionalidad'  => 'Nacionalidad',
                'pai_estado'        => 'Estado',
                'pai_usu_cre'       => 'Usuario Creacion',
                'pai_usu_mod'       => 'Usuario Modificacion',
                'pai_fecha_crea'    => 'Fecha Creacion',
                'pai_fecha_mod'     => 'Fecha Modificacion'
            );

            $required = array(
                'pai_nombre', 
                'pai_estado'
            );

            $crud->columns($columnas);
            $crud->required_fields($required);
            $crud->display_as($display_as);
            $crud->field_type('pai_usu_crea', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('pai_fecha_crea', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('pai_usu_mod', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('pai_fecha_mod', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('pai_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            $crud->set_rules('pai_nombre', 'Nombre', 'campo_unico[pai_pais.pai_nombre]|required');

            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('pai_estado', 'hidden', 1);
            } else {
                $crud->field_type('pai_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            if(!$permisos["permite_editar"]){
                $crud->unset_edit();
            }
            if(!$permisos["permite_eliminar"]){
                $crud->unset_delete();
            }
            if(!$permisos["permite_agregar"]){
                $crud->unset_add();
            }
            if(!$permisos["permite_ver"]){
                $crud->unset_read();
            }

            $output = $crud->render();
            $data['titulo_personal'] = "Catálogo de Nacionalidades";
            $ruta_vista = (trim($ruta_vista) != '')? $ruta_vista:'expediente_personal/catalogos/paises';
            cargarvista($data, $output, $ruta_vista);

        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    function certificacion($ruta_vista = null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {

            //$ruta_vista es una array en la posición uno viene la ruta de los permisos a obtener en la dos viene la vista a cargar.
            $ruta_permisos = (is_array($ruta_vista)) ? $ruta_vista[0] : 'expediente_personal/catalogos/certificacion'; //cuando viene la petición de otro modulo.
            $arreglo_url = explode('/', $ruta_permisos);
            $data['modulo_url'] = $arreglo_url[0] . '/' . $arreglo_url[1]; //cuando viene la petición de otro modulo.
            $ruta_vista = (is_array($ruta_vista)) ? $ruta_vista[1] : null;

            $columns = array(
                'cer_nombre', 
                'cer_descripcion', 
                'cer_tipo', 
                'cer_estado'
            );

            $display_as = array(
                'cer_nombre'        => 'Nombre',
                'cer_descripcion'   => 'Descripción',
                'cer_tipo'          => 'Tipo',
                'cer_estado'        => 'Estado'
            );

            $fields = array(
                'cer_nombre', 
                'cer_descripcion', 
                'cer_tipo', 
                'cer_estado', 
                'cer_fecha_creacion', 
                'cer_usu_creacion', 
                'cer_usu_modificacion', 
                'cer_fecha_modificacion'
            );

            $required = array(
                'cer_nombre', 
                'cer_tipo', 
                'cer_estado'
            );

            $permisos = $this->gsatelite->get_permisos_opcion();
            $crud = new grocery_CRUD();
            $crud->set_subject('Certificación');
            $crud->set_table('cer_certificacion');
            $crud->columns($columns);
            $crud->display_as($display_as);
            $crud->fields($fields);
            $crud->required_fields($required);
            $crud->set_rules('cer_nombre', 'Nombre', 'trim|required|campo_unico[cer_certificacion.cer_nombre]');
            $crud->set_rules('cer_tipo', 'Tipo', 'trim|required');
            $crud->set_rules('cer_estado', 'Estado', 'trim|required');
            $crud->field_type('cer_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('cer_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('cer_fecha_creacion', 'hidden', date('Y-m-d'));
            $crud->field_type('cer_fecha_modificacion', 'hidden', date('Y-m-d'));
            $crud->field_type('cer_tipo', 'dropdown', array('1' => 'Idiomas', '2' => 'Programas o Equipos'));

            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('cer_estado', 'hidden', 1);
            } else {
                $crud->field_type('cer_estado', 'dropdown', array('1' => 'Activado', '0' => 'Desactivado'));
            }
            if (!$permisos["permite_editar"]) {
                $crud->unset_edit();
            }
            if (!$permisos["permite_eliminar"]) {
                $crud->unset_delete();
            }
            if (!$permisos["permite_agregar"]) {
                $crud->unset_add();
            }
            if (!$permisos["permite_ver"]) {
                $crud->unset_read();
            } else {
                $data_url = $this->masterpage->getUsuario();
                $url_read = $data_url['modulo'] . '/' . $data_url['control'] . '/' . $data_url['funcion'];
                $crud->add_action('Ver', 'minia-icon-search', $url_read."/read");
                // $crud->add_action('&nbsp;&nbsp;Ver', '', 'expediente_personal/catalogos/certificacion/read', 'icomoon-icon-search-3');
            }
            $output = $crud->render();
            $data['titulo_personal'] = "Certificaciones";
            $ruta_vista = (trim($ruta_vista) != '')? $ruta_vista:'expediente_personal/catalogos/certificacion';
            cargarvista($data, $output, $ruta_vista);
        }
    }

    function enfermedades() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $permisos = $this->gsatelite->get_permisos_opcion();
            $crud = new grocery_CRUD();
            $crud->set_subject('Enfermedad')->set_table('enf_enfermedad');
            $crud->columns('enf_nombre', 'enf_descripcion', 'enf_estado');
            $crud->display_as('enf_nombre', 'Nombre')
                    ->display_as('enf_descripcion', 'Descripción')
                    ->display_as('enf_estado', 'Estado');
            $crud->add_fields('enf_nombre', 'enf_descripcion', 'enf_estado', 'enf_fecha_creacion', 'enf_usu_creacion', 'enf_usu_modificacion', 'enf_fecha_modificacion');
            $crud->edit_fields('enf_nombre', 'enf_descripcion', 'enf_estado', 'enf_usu_modificacion', 'enf_fecha_modificacion');
            $crud->required_fields('enf_nombre', 'enf_estado');
            //$crud->set_relation('suc_id_mun','mun_municipio','mun_nombre',null);
            $crud->set_rules('enf_nombre', 'Nombre', 'trim|required|campo_unico[enf_enfermedad.enf_nombre]');
            $crud->set_rules('enf_estado', 'Tipo', 'trim|required');
            $crud->field_type('enf_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('enf_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('enf_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('enf_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('enf_estado', 'hidden', 1);
            } else {
                $crud->field_type('enf_estado', 'dropdown', array('1' => 'Activado', '0' => 'Desactivado'));
            }
            if (!$permisos["permite_editar"]) {
                $crud->unset_edit();
            }
            if (!$permisos["permite_eliminar"]) {
                $crud->unset_delete();
            }
            if (!$permisos["permite_agregar"]) {
                $crud->unset_add();
            }
            if (!$permisos["permite_ver"]) {
                /*$crud->add_action('&nbsp;&nbsp;Ver', '', 'expediente_personal/catalogos/enfermedades/read', 'icomoon-icon-search-3');*/
                $crud->unset_read();
            }
            $output = $crud->render();
            $data['titulo_personal'] = "Enfermedades";
            //$this->_cargarvista($data, $output);
            cargarvista($data,$output,'expediente_personal/catalogos/enfermedades');
        }
    }

    public function alergia() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {

            // Arreglos con los campos 
            $columns = array(
                'coa_nombre', 
                'coa_descripcion', 
                'coa_estado'
            );

            $display_as = array(
                'coa_nombre'        => 'Nombre',
                'coa_descripcion'   => 'Descripción',
                'coa_estado'        => 'Estado'
            );

            $add_fields = array(
                'coa_nombre', 
                'coa_descripcion', 
                'coa_estado', 
                'coa_fecha_creacion', 
                'coa_usu_creacion', 
                'coa_usu_modificacion', 
                'coa_fecha_modificacion'
            );

            $edit_fields = array(
                'coa_nombre', 
                'coa_descripcion', 
                'coa_estado', 
                'coa_usu_modificacion', 
                'coa_fecha_modificacion'
            );

            $required = array(
                'coa_nombre', 
                'coa_estado'
            );

            $permisos = $this->gsatelite->get_permisos_opcion();
            $crud = new grocery_CRUD();
            $crud->set_subject('Alergia');
            $crud->set_table('coa_componente_alergico');
            $crud->columns($columns);
            $crud->display_as($display_as);
            $crud->add_fields($add_fields);
            $crud->edit_fields($edit_fields);
            $crud->required_fields($required);
            //$crud->set_relation('suc_id_mun','mun_municipio','mun_nombre',null);
            $crud->set_rules('coa_nombre', 'Nombre', 'trim|required|campo_unico[coa_componente_alergico.coa_nombre]');
            $crud->set_rules('coa_estado', 'Tipo', 'trim|required');
            $crud->field_type('coa_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('coa_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('coa_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('coa_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
            $urlx = explode('/', uri_string());
            if (end($urlx) == 'add') {
                $crud->field_type('coa_estado', 'hidden', 1);
            } else {
                $crud->field_type('coa_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }
            if (!$permisos["permite_editar"]) {
                $crud->unset_edit();
            }
            if (!$permisos["permite_eliminar"]) {
                $crud->unset_delete();
            }
            if (!$permisos["permite_agregar"]) {
                $crud->unset_add();
            }
            if($permisos["permite_ver"]){
                $data_url = $this->masterpage->getUsuario();
                $url_read = $data_url['modulo'] . '/' . $data_url['control'] . '/' . $data_url['funcion'];
                $crud->add_action('Ver', 'minia-icon-search', $url_read."/read");
            }
            $output = $crud->render();
            $data['titulo_personal'] = "Alergias";
            cargarvista($data, $output, 'expediente_personal/catalogos/alergia');
        }
    }

    /*
    *   Funcionalidad Compartida con el modulo de Seleccion de Personal
    */
    function programa_y_equipo($ruta_vista = null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {

            //$ruta_vista es una array en la posición uno viene la ruta de los permisos a obtener en la dos viene la vista a cargar.
            //cuando viene la petición de otro modulo.
            $ruta_permisos = (is_array($ruta_vista)) ? $ruta_vista[0] : 'expediente_personal/catalogos/programa_y_equipo'; 

            $arreglo_url    = explode('/', $ruta_permisos);
            $modulo_url     = $arreglo_url[0] . '/' . $arreglo_url[1]; //cuando viene la petición de otro modulo.
            $data['modulo_url'] = $modulo_url;
            $ruta_vista     = (is_array($ruta_vista)) ? $ruta_vista[1] : null;

            $columns = array(
                'peq_nombre', 
                'peq_descripcion', 
                'peq_estado'
            );

            $display_as = array(
                'peq_nombre'        => 'Nombre',
                'peq_descripcion'   => 'Descripción',
                'peq_estado'        => 'Estado'
            );

            $add_fields = array(
                'peq_nombre', 
                'peq_descripcion', 
                'peq_estado', 
                'peq_fecha_creacion', 
                'peq_usu_creacion', 
                'peq_usu_modificacion', 
                'peq_fecha_modificacion'
            );

            $edit_fields = array(
                'peq_nombre', 
                'peq_descripcion', 
                'peq_estado', 
                'peq_usu_modificacion', 
                'peq_fecha_modificacion'
            );

            $required = array(
                'peq_nombre', 
                'peq_estado'
            );

            $permisos = $this->gsatelite->get_permisos_opcion();
            $crud = new grocery_CRUD();
            $crud->set_subject('Programa y equipo');
            $crud->set_table('peq_programa_equipo');
            $crud->columns($columns);
            $crud->display_as($display_as);
            $crud->add_fields($add_fields);
            $crud->edit_fields($edit_fields);
            $crud->required_fields($required);
            $crud->set_rules('peq_nombre', 'Nombre', 'trim|required|campo_unico[peq_programa_equipo.peq_nombre]');
            $crud->set_rules('peq_estado', 'Tipo', 'trim|required');
            $crud->field_type('peq_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('peq_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('peq_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('peq_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));

            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('peq_estado', 'hidden', 1);
            } else {
                $crud->field_type('peq_estado', 'dropdown', array('1' => 'Activado', '0' => 'Desactivado'));
            }
            if (!$permisos["permite_editar"]) {
                $crud->unset_edit();
            }
            if (!$permisos["permite_eliminar"]) {
                $crud->unset_delete();
            }
            if (!$permisos["permite_agregar"]) {
                $crud->unset_add();
            }
            if (!$permisos["permite_ver"]) {
                $crud->unset_read();
            } else {
                $data_url = $this->masterpage->getUsuario();
                $url_read = $data_url['modulo'] . '/' . $data_url['control'] . '/' . $data_url['funcion'];
                $crud->add_action('Ver', 'minia-icon-search', $url_read."/read");
            }
            $output = $crud->render();
            $data['titulo_personal'] = "Programas y equipos";
            $ruta_vista = (trim($ruta_vista) != '')? $ruta_vista:'expediente_personal/catalogos/programa_y_equipo';
            cargarvista($data, $output, $ruta_vista);
        }
    }

    /*
    *   Funcionalidad Compartida con el Modulo de Seleccion de Personal
    */
    function tipo_referencia($ruta_vista = null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {

            //$ruta_vista es una array en la posición uno viene la ruta de los permisos a obtener en la dos viene la vista a cargar.
            $ruta_permisos = (is_array($ruta_vista)) ? $ruta_vista[0] : 'expediente_personal/catalogos/tipo_referencia'; //cuando viene la petición de otro modulo.

            $arreglo_url    = explode('/', $ruta_permisos);
            $modulo_url     = $arreglo_url[0] . '/' . $arreglo_url[1]; //cuando viene la petición de otro modulo.
            $data['modulo_url'] = $modulo_url;
            $ruta_vista     = (is_array($ruta_vista)) ? $ruta_vista[1] : null;

            try {
                $permisos   = $this->gsatelite->get_permisos_opcion();
                $crud       = new grocery_CRUD();
                $crud->set_subject('Tipo de referencia');
                $crud->set_table('trr_tipo_referencia');

                $columns = array(
                    'trr_nombre', 
                    'trr_descripcion', 
                    'trr_estado'
                );

                $display_as = array(
                    'trr_nombre'      => 'Nombre',
                    'trr_descripcion' => 'Descripción',
                    'trr_estado'      => 'Estado'
                );

                $add_fields = array(
                    'trr_nombre', 
                    'trr_descripcion', 
                    'trr_estado', 
                    'trr_fecha_creacion', 
                    'trr_usu_creacion', 
                    'trr_usu_modificacion', 
                    'trr_fecha_modificacion'
                );

                $edit_fields = array(
                    'trr_nombre', 
                    'trr_descripcion', 
                    'trr_estado', 
                    'trr_usu_modificacion', 
                    'trr_fecha_modificacion'
                );

                $required = array(
                    'trr_nombre', 
                    'trr_estado'
                );

                $crud->columns($columns);
                $crud->display_as($display_as);
                $crud->add_fields($add_fields);
                $crud->edit_fields($edit_fields);
                $crud->required_fields($required);
                $crud->set_rules('trr_nombre', 'Nombre', 'trim|required|campo_unico[trr_tipo_referencia.trr_nombre]');
                $crud->set_rules('trr_estado', 'Tipo', 'trim|required');
                $crud->field_type('trr_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
                $crud->field_type('trr_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
                $crud->field_type('trr_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
                $crud->field_type('trr_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));

                if (end(explode('/', uri_string())) == 'add') {
                    $crud->field_type('trr_estado', 'hidden', 1);
                } else {
                    $crud->field_type('trr_estado', 'dropdown', array('1' => 'Activado', '0' => 'Desactivado'));
                }
                if (!$permisos["permite_editar"]) {
                    $crud->unset_edit();
                }
                if (!$permisos["permite_eliminar"]) {
                    $crud->unset_delete();
                }
                if (!$permisos["permite_agregar"]) {
                    $crud->unset_add();
                }
                if (!$permisos["permite_ver"]) {
                    $crud->unset_read();
                }

                $output = $crud->render();
                $data['titulo_personal'] = "Tipo de referencias";
                $ruta_vista = (trim($ruta_vista) != '')? $ruta_vista:'expediente_personal/catalogos/tipo_referencia';
                cargarvista($data, $output, $ruta_vista);
            } catch (Exception $e) {
                show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
            }

        }
    }

    function institucion($ruta_vista = null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {

            //$ruta_vista es una array en la posición uno viene la ruta de los permisos a obtener en la dos viene la vista a cargar.
            //cuando viene la petición de otro modulo.
            $ruta_permisos = (is_array($ruta_vista)) ? $ruta_vista[0] : 'expediente_personal/catalogos/institucion'; 

            $arreglo_url    = explode('/', $ruta_permisos);
            $modulo_url     = $arreglo_url[0] . '/' . $arreglo_url[1]; //cuando viene la petición de otro modulo.
            $data['modulo_url'] = $modulo_url;
            $ruta_vista     = (is_array($ruta_vista)) ? $ruta_vista[1] : null;

            $columns = array(
                'ina_id',
                'ina_nombre', 
                'ina_descripcion', 
                'ina_estado'
            );

            $display_as = array(
                'ina_id' => 'ID',
                'ina_nombre'      => 'Nombre',
                'ina_descripcion' => 'Descripción',
                'ina_estado'      => 'Estado'
            );

            $add_fields = array(
                'ina_nombre', 
                'ina_descripcion', 
                'ina_estado', 
                'ina_fecha_creacion', 
                'ina_usu_creacion', 
                'ina_usu_modificacion', 
                'ina_fecha_modificacion'
            );

            $edit_fields = array(
                'ina_nombre', 
                'ina_descripcion', 
                'ina_estado', 
                'ina_usu_modificacion', 
                'ina_fecha_modificacion'
            );

            $required = array(
                'ina_nombre', 
                'ina_estado'
            );

            try {
                $permisos = $this->gsatelite->get_permisos_opcion();
                $crud = new grocery_CRUD();
                $crud->set_subject('Institución');
                $crud->set_table('ina_institucion_academica');
                $crud->columns($columns);
                $crud->display_as($display_as);
                $crud->add_fields($add_fields);
                $crud->edit_fields($edit_fields);
                $crud->required_fields($required);
                $crud->set_rules('ina_nombre', 'Nombre', 'trim|required|campo_unico[ina_institucion_academica.ina_nombre]');
                $crud->set_rules('ina_estado', 'Tipo', 'trim|required');
                $crud->field_type('ina_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
                $crud->field_type('ina_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
                $crud->field_type('ina_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
                $crud->field_type('ina_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));

                if (end(explode('/', uri_string())) == 'add') {
                    $crud->field_type('ina_estado', 'hidden', 1);
                } else {
                    $crud->field_type('ina_estado', 'dropdown', array('1' => 'Activado', '0' => 'Desactivado'));
                }
                if (!$permisos["permite_editar"]) {
                    $crud->unset_edit();
                }
                if (!$permisos["permite_eliminar"]) {
                    $crud->unset_delete();
                }
                if (!$permisos["permite_agregar"]) {
                    $crud->unset_add();
                }
                if (!$permisos["permite_ver"]) {
                    $crud->unset_read();
                }
                $output = $crud->render();
                $data['titulo_personal'] = "Instituciones";
                $ruta_vista = (trim($ruta_vista) != '')? $ruta_vista:'expediente_personal/catalogos/institucion';
                cargarvista($data, $output, $ruta_vista);
            } catch (Exception $e) {
                show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
            }
        }
    }

    function experiencia_laboral($ruta_vista = null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {

            //$ruta_vista es una array en la posición uno viene la ruta de los permisos a obtener en la dos viene la vista a cargar.
            //cuando viene la petición de otro modulo.
            $ruta_permisos = (is_array($ruta_vista)) ? $ruta_vista[0] : 'expediente_personal/catalogos/experiencia_laboral'; 

            $arreglo_url    = explode('/', $ruta_permisos);
            $modulo_url     = $arreglo_url[0] . '/' . $arreglo_url[1]; //cuando viene la petición de otro modulo.
            $data['modulo_url'] = $modulo_url;
            $ruta_vista     = (is_array($ruta_vista)) ? $ruta_vista[1] : null;

            $columns = array(
                'exl_nombre', 
                'exl_descripcion', 
                'exl_estado'
            );

            $display_as = array(
                'exl_nombre'        => 'Nombre',
                'exl_descripcion'   => 'Descripción',
                'exl_estado'        => 'Estado'
            );

            $add_fields = array(
                'exl_nombre', 
                'exl_descripcion', 
                'exl_estado', 
                'exl_fecha_creacion', 
                'exl_usu_creacion', 
                'exl_usu_modificacion', 
                'exl_fecha_modificacion'
            );
            $edit_fields = array(
                'exl_nombre', 
                'exl_descripcion', 
                'exl_estado', 
                'exl_usu_modificacion', 
                'exl_fecha_modificacion'
            );

            $required = array(
                'exl_nombre', 
                'exl_estado'
            );
             
            try {
                $permisos = $this->gsatelite->get_permisos_opcion();
                $crud = new grocery_CRUD();
                $crud->set_subject('Experiencia Profesional');
                $crud->set_table('exl_experiencia_laboral');
                $crud->columns($columns);
                $crud->display_as($display_as);
                $crud->add_fields($add_fields);
                $crud->edit_fields($edit_fields);
                $crud->required_fields($required);
                $crud->set_rules('exl_nombre', 'Nombre', 'trim|required|campo_unico[exl_experiencia_laboral.exl_nombre]');
                $crud->set_rules('exl_estado', 'Tipo', 'trim|required');
                $crud->field_type('exl_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
                $crud->field_type('exl_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
                $crud->field_type('exl_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
                $crud->field_type('exl_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));

                if (end(explode('/', uri_string())) == 'add') {
                    $crud->field_type('exl_estado', 'hidden', 1);
                } else {
                    $crud->field_type('exl_estado', 'dropdown', array('1' => 'Activado', '0' => 'Desactivado'));
                }
                if (!$permisos["permite_editar"]) {
                    $crud->unset_edit();
                }
                if (!$permisos["permite_eliminar"]) {
                    $crud->unset_delete();
                }
                if (!$permisos["permite_agregar"]) {
                    $crud->unset_add();
                }
                if (!$permisos["permite_ver"]) {
                    $crud->unset_read();
                }
                $output = $crud->render();
                $data['titulo_personal'] = "Experiencias Profesionales";
                $ruta_vista = (trim($ruta_vista) != '')? $ruta_vista:'expediente_personal/catalogos/experiencia_laboral';
                cargarvista($data, $output, $ruta_vista);
            } catch (Exception $e) {
                show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
            }
        }
    }    
    
    /*
    * Funcionalidad Compartida Con el Modulo de Seleccion de Personal
    */
    public function generos($ruta_vista = null) {
        satelite_validar();

        //$ruta_vista es una array en la posición uno viene la ruta de los permisos a obtener en la dos viene la vista a cargar.
        //cuando viene la petición de otro modulo.
        $ruta_permisos = (is_array($ruta_vista)) ? $ruta_vista[0] : 'expediente_personal/catalogos/generos'; 
        $arreglo_url = explode('/', $ruta_permisos);
        $data['modulo_url'] = $arreglo_url[0] . '/' . $arreglo_url[1]; //cuando viene la petición de otro modulo.
        $ruta_vista = (is_array($ruta_vista)) ? $ruta_vista[1] : null;

        try {
            $permisos = $this->gsatelite->get_permisos_opcion();
            $crud = new grocery_CRUD();
            $crud->unset_export();
            $crud->unset_print();
            $crud->set_table('gen_genero');
            $crud->set_subject('Género');

            $columnas = array(
                'gen_nombre',
                'gen_estado'
            );

            $add_fields = array(
                'gen_nombre',
                'gen_estado',
                'gen_usu_creacion',
                'gen_usu_modificacion',
                'gen_fecha_creacion',
                'gen_fecha_modificacion'
            );

            $edit_fields = array(
                'gen_nombre',
                'gen_estado',
                'gen_usu_modificacion',
                'gen_fecha_modificacion'
            );

            $required_fields = array(
                'gen_nombre',
                'gen_estado',
                'gen_usu_creacion',
                'gen_usu_modificacion',
                'gen_fecha_creacion',
                'gen_fecha_modificacion'
            );

            $display_as = array(
                'gen_nombre' => 'Nombre',
                'gen_estado' => 'Estado'
            );

            $crud->required_fields($required_fields);
            $crud->columns($columnas);
            $crud->add_fields($add_fields);
            $crud->edit_fields($edit_fields);
            $crud->display_as($display_as);
            $crud->field_type('gen_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('gen_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));

            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('gen_estado', 'hidden', 1);
                $crud->field_type('gen_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
                $crud->field_type('gen_fecha_creacion', 'hidden', date('Y-m-d h:i:s'));
            } else {
                $crud->field_type('gen_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if (!$permisos['permite_ver']) {
                $crud->unset_read();
            }

            $output = $crud->render();
            $data['titulo_personal'] = "Catálogo de Género";
            $ruta_vista = (trim($ruta_vista) != '')? $ruta_vista:'expediente_personal/catalogos/generos';
            cargarvista($data, $output, $ruta_vista);

        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    /*
    * Funcionalidad Compartida con el modulo de Seleccion de Personal
    */
    public function estado_civil($ruta_vista = null) {
        satelite_validar();

        //$ruta_vista es una array en la posición uno viene la ruta de los permisos a obtener en la dos viene la vista a cargar.
        //cuando viene la petición de otro modulo.
        $ruta_permisos = (is_array($ruta_vista)) ? $ruta_vista[0] : 'expediente_personal/catalogos/estado_civil'; 
        $arreglo_url = explode('/', $ruta_permisos);
        $data['modulo_url'] = $arreglo_url[0] . '/' . $arreglo_url[1]; //cuando viene la petición de otro modulo.
        $ruta_vista = (is_array($ruta_vista)) ? $ruta_vista[1] : null;

        try {
            $permisos = $this->gsatelite->get_permisos_opcion();
            $crud = new grocery_CRUD();
            $crud->unset_export();
            $crud->unset_print();
            $crud->set_table('esc_estado_civil');
            $crud->set_subject('Estado civil');

            $columnas = array(
                'esc_nombre',
                'esc_estado'
            );

            $add_fields = array(
                'esc_nombre',
                'esc_estado',
                'esc_usu_creacion',
                'esc_fecha_creacion',
                'esc_usu_modificacion',
                'esc_fecha_modificacion'
            );

            $edit_fields = array(
                'esc_nombre',
                'esc_estado',
                'esc_usu_modificacion',
                'esc_fecha_modificacion'
            );

            $required_fields = array(
                'esc_nombre',
                'esc_estado',
                'esc_usu_creacion',
                'esc_fecha_creacion',
                'esc_usu_modificacion',
                'esc_fecha_modificacion'
            );

            $display_as = array(
                'esc_nombre' => 'Nombre',
                'esc_estado' => 'Estado'
            );

            $crud->required_fields($required_fields);
            $crud->columns($columnas);
            $crud->add_fields($add_fields);
            $crud->edit_fields($edit_fields);
            $crud->display_as($display_as);
            $crud->field_type('esc_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('esc_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));

            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('esc_estado', 'hidden', 1);
                $crud->field_type('esc_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
                $crud->field_type('esc_fecha_creacion', 'hidden', date('Y-m-d h:i:s'));
            } else {
                $crud->field_type('esc_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if (!$permisos['permite_ver']) {
                $crud->unset_read();
            }

            $output = $crud->render();
            $data['titulo_personal'] = "Catálogo de Estado Civil";
            $ruta_vista = (trim($ruta_vista) != '')? $ruta_vista:'expediente_personal/catalogos/estado_civil';
            cargarvista($data, $output, $ruta_vista);

        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    /*
    * Funcionalidad Compartida con el modulo de Seleccion de Personal
    */
    function nivel_programa_equipo($ruta_vista = null){
        if(!$this->tank_auth->is_logged_in()){
            redirect('/auth/login/');
        } else {

            //$ruta_vista es una array en la posición uno viene la ruta de los permisos a obtener en la dos viene la vista a cargar.
            //cuando viene la petición de otro modulo.
            $ruta_permisos = (is_array($ruta_vista)) ? $ruta_vista[0] : 'expediente_personal/catalogos/nivel_programa_equipo'; 
            $arreglo_url = explode('/', $ruta_permisos);
            $data['modulo_url'] = $arreglo_url[0] . '/' . $arreglo_url[1]; //cuando viene la petición de otro modulo.
            $ruta_vista = (is_array($ruta_vista)) ? $ruta_vista[1] : null;

            $columns = array(
                'nie_nombre', 
                'nie_estado'
            );

            $display_as = array(
                'nie_nombre'    => 'Nombre',
                'nie_estado'    => 'Estado'
            );

            $add_fields = array(
                'nie_nombre',
                'nie_estado',
                'nie_usu_modificacion',
                'nie_fecha_modificacion',
                'nie_usu_creacion',
                'nie_fecha_creacion'
            );

            $edit_fields = array(
                'nie_nombre',
                'nie_estado',
                'nie_usu_modificacion',
                'nie_fecha_modificacion'
            );

            $required = array(
                'nie_nombre',
                'nie_estado'
            );

            $permisos = $this->gsatelite->get_permisos_opcion();
            $crud =  new grocery_CRUD();
            $crud->set_subject('Nivel de programa y equipo');
            $crud->set_table('nie_nivel_experiencia');
            $crud->columns($columns);
            $crud->display_as($display_as);
            $crud->add_fields($add_fields);
            $crud->edit_fields($edit_fields);
            $crud->required_fields($required);
            $crud->set_rules('nie_nombre','nombre','trim|required|campo_unico[nie_nivel_experiencia.nie_nombre]');
            $crud->set_rules('nie_estado','estado','trim|required');
            $crud->field_type('nie_usu_creacion','hidden',$this->tank_auth->get_user_id());
            $crud->field_type('nie_usu_modificacion','hidden',$this->tank_auth->get_user_id());
            $crud->field_type('nie_fecha_creacion','hidden',date('Y-m-d H:i:s'));
            $crud->field_type('nie_fecha_modificacion','hidden',date('Y-m-d H:i:s'));

            if(end(explode('/',uri_string()))=='add') {
                $crud->field_type('nie_estado','hidden',1);
            }else {
                $crud->field_type('nie_estado','dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            if(!$permisos["permite_editar"]){
                $crud->unset_edit();
            }
            if(!$permisos["permite_eliminar"]){
                $crud->unset_delete();
            }
            if(!$permisos["permite_agregar"]){
                $crud->unset_add();
            }
            if(!$permisos["permite_ver"]){
                $crud->unset_read();
            } else {
                $data_url = $this->masterpage->getUsuario();
                $url_read = $data_url['modulo'] . '/' . $data_url['control'] . '/' . $data_url['funcion'];
                $crud->add_action('Ver', 'minia-icon-search', $url_read."/read");
            }

            $output = $crud->render();
            $data['titulo_personal']="Niveles de programas y equipos";
            $ruta_vista = (trim($ruta_vista) != '')? $ruta_vista:'expediente_personal/catalogos/nivel_programa_equipo';
            cargarvista($data, $output, $ruta_vista);
        }
    }

    /*
    * Funcionalidad Compartida con el modulo de Seleccion de Personal
    */
    function tipo_telefono($ruta_vista = null){
        if(!$this->tank_auth->is_logged_in()){
            redirect('/auth/login/');
        } else {

            //$ruta_vista es una array en la posición uno viene la ruta de los permisos a obtener en la dos viene la vista a cargar.
            //cuando viene la petición de otro modulo.
            $ruta_permisos = (is_array($ruta_vista)) ? $ruta_vista[0] : 'expediente_personal/catalogos/tipo_telefono'; 
            $arreglo_url = explode('/', $ruta_permisos);
            $data['modulo_url'] = $arreglo_url[0] . '/' . $arreglo_url[1]; //cuando viene la petición de otro modulo.
            $ruta_vista = (is_array($ruta_vista)) ? $ruta_vista[1] : null;

            $columns = array(
                'tit_nombre', 
                'tit_estado'
            );

            $display_as = array(
                'tit_nombre'    => 'Nombre',
                'tit_privacidad' => 'Visibilidad',
                'tit_estado'    => 'Estado'
            );

            $add_fields = array(
                'tit_nombre',
                'tit_privacidad',
                'tit_estado',
                'tit_usu_mod',
                'tit_fecha_mod',
                'tit_usu_crea',
                'tit_fecha_crea'
            );

            $edit_fields = array(
                'tit_nombre',
                'tit_privacidad',
                'tit_estado',
                'tit_usu_mod',
                'tit_fecha_mod'
            );

            $required = array(
                'tit_nombre',
                'tit_estado'
            );

            $permisos = $this->gsatelite->get_permisos_opcion();
            $crud =  new grocery_CRUD();
            $crud->set_subject('Tipo de telefono');
            $crud->set_table('tit_tipo_telefono');
            $crud->columns($columns);
            $crud->display_as($display_as);
            $crud->add_fields($add_fields);
            $crud->edit_fields($edit_fields);
            $crud->required_fields($required);
            $crud->set_rules('tit_nombre','nombre','trim|required|campo_unico[tit_tipo_telefono.tit_nombre]');
            $crud->set_rules('tit_estado','estado','trim|required');
            $crud->field_type('tit_usu_crea','hidden',$this->tank_auth->get_user_id());
            $crud->field_type('tit_usu_mod','hidden',$this->tank_auth->get_user_id());
            $crud->field_type('tit_fecha_crea','hidden',date('Y-m-d H:i:s'));
            $crud->field_type('tit_fecha_mod','hidden',date('Y-m-d H:i:s'));
            $crud->field_type('','dropdown', array('1' => 'Público', '0' => 'Privado'));
            $crud->callback_add_field('tit_privacidad',function(){
                return '<input type="checkbox" id="tit_privacidad" class="nostyle"><input type="hidden" id="field-tit_privacidad" name="tit_privacidad" value="0">';
            });
            $crud->callback_edit_field('tit_privacidad', function($value, $primary_key) {
                $defecto = ($value) ? 'checked' : '';
                return '<input type="checkbox" id="tit_privacidad" class="nostyle" '.$defecto.'><input type="hidden" id="field-tit_privacidad" name="tit_privacidad" value="'.$value.'">';            
            });

            $uri_segments = explode('/',uri_string());
            if(end($uri_segments)=='add') {
                $crud->field_type('tit_estado','hidden',1);
            }else {
                $crud->field_type('tit_estado','dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }
            
            if(!$permisos["permite_editar"]){
                $crud->unset_edit();
            }
            if(!$permisos["permite_eliminar"]){
                $crud->unset_delete();
            }
            if(!$permisos["permite_agregar"]){
                $crud->unset_add();
            }
            if(!$permisos["permite_ver"]){
                $crud->unset_read();
            } else {
                $data_url = $this->masterpage->getUsuario();
                $url_read = $data_url['modulo'] . '/' . $data_url['control'] . '/' . $data_url['funcion'];
                $crud->add_action('Ver', 'minia-icon-search', $url_read."/read");
            }

            $output = $crud->render();
            $data['titulo_personal']="Tipos de telefonos";
            $ruta_vista = (trim($ruta_vista) != '')? $ruta_vista:'expediente_personal/catalogos/tipo_telefono';
            cargarvista($data, $output, $ruta_vista);
        }
    }

    function tipo_educacion(){
        if(!$this->tank_auth->is_logged_in()){
            redirect('/auth/login/');
        } else {
            //$permisos = $this->gsatelite->get_permisos_opcion('expediente_personal/catalogos/tipo_educacion');
            $this->load->library('../controllers/registro_academico/mantenimientos');
            $this->mantenimientos->tipo_educacion();
        }        
    }

    /**
     * Descripción:
     * Función para dar mantenimiento a zonas de residencia (tabla: zon_zona)
     * @author René Castaneda - Grupo Satélite
     * @since 2017-11-22
     * @param ninguno
     * @return Mantenimiento de zonas de residencia
     */

    function zona_residencia() {
        satelite_validar();
        $crud = new grocery_CRUD();
        $accion = $crud->getState(); //obtener la acción que esta ejecutando grocery crud
        $permisos = $this->gsatelite->get_permisos_opcion();
        $crud->set_table('zon_zona');
        $crud->set_subject('Zona - Residencia');


        $columns = array(
            'zon_nombre',
            'zon_descripcion',
            'zon_estado'
        );

        $display_as = array(
            'zon_nombre' => 'Nombre',
            'zon_descripcion' => 'Descripción',
            'zon_estado' => 'Estado'
        );

        $required = array(
            'zon_nombre',
            'zon_estado'
        );

        $add_columns = array(
            'zon_nombre',
            'zon_descripcion',
            'zon_estado',
            'zon_fecha_creacion',
            'zon_usu_creacion',
            'zon_fecha_modificacion',
            'zon_usu_modificacion'
        );

        $edit_columns = array(
            'zon_nombre',
            'zon_descripcion',
            'zon_estado',
            'zon_fecha_modificacion',
            'zon_usu_modificacion'
        );

        $crud->columns($columns);
        $crud->display_as($display_as);
        $crud->required_fields($required);
        $crud->add_fields($add_columns);
        $crud->edit_fields($edit_columns);
        $crud->field_type('zon_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
        $crud->field_type('zon_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
        $crud->field_type('zon_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
        $crud->field_type('zon_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
        $crud->set_rules('zon_nombre','Nombre','campo_unico[zon_zona.zon_nombre]|required');
        $crud->unset_export();
        $crud->unset_print();
        
        if ($accion == 'add') {
            $crud->field_type('zon_estado', 'hidden', 1);
        } else {
            $crud->field_type('zon_estado', 'dropdown', array(1 => 'Activo', 0 => 'Inactivo'));
        }

        // Validaciones
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }
        if (!$permisos['permite_editar']) {
            $crud->unset_edit();
        }
        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }
        if ($permisos['permite_ver']) {
            $crud->add_action('Ver', 'minia-icon-search', 'expediente_personal/catalogos/zona_residencia/read');
        }

        $output = $crud->render();

        $data['titulo_personal'] = "Zonas de Residencia";
        cargarvista($data, $output);
    } //Fin mantenimiento Zonas residencia


    /**
     * Descripción:
     * Función para dar mantenimiento a tipos de vivienda (tabla: tiv_tipo_vivienda)
     * @author René Castaneda - Grupo Satélite
     * @since 2017-11-22
     * @param ninguno
     * @return Mantenimiento de tipos de vivienda
     */

    function tipo_vivienda() {
        satelite_validar();
        $crud = new grocery_CRUD();
        $accion = $crud->getState(); //obtener la acción que esta ejecutando grocery crud
        $permisos = $this->gsatelite->get_permisos_opcion();
        $crud->set_table('tiv_tipo_vivienda');
        $crud->set_subject('Tipo Vivienda');


        $columns = array(
            'tiv_nombre',
            'tiv_descripcion',
            'tiv_estado'
        );

        $display_as = array(
            'tiv_nombre' => 'Nombre',
            'tiv_descripcion' => 'Descripción',
            'tiv_estado' => 'Estado'
        );

        $required = array(
            'tiv_nombre',
            'tiv_estado'
        );

        $add_columns = array(
            'tiv_nombre',
            'tiv_descripcion',
            'tiv_estado',
            'tiv_fecha_creacion',
            'tiv_usu_creacion',
            'tiv_fecha_modificacion',
            'tiv_usu_modificacion'
        );

        $edit_columns = array(
            'tiv_nombre',
            'tiv_descripcion',
            'tiv_estado',
            'tiv_fecha_modificacion',
            'tiv_usu_modificacion'
        );

        $crud->columns($columns);
        $crud->display_as($display_as);
        $crud->required_fields($required);
        $crud->add_fields($add_columns);
        $crud->edit_fields($edit_columns);
        $crud->field_type('tiv_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
        $crud->field_type('tiv_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
        $crud->field_type('tiv_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
        $crud->field_type('tiv_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
        $crud->set_rules('tiv_nombre','Nombre','campo_unico[tiv_tipo_vivienda.tiv_nombre]|required');
        $crud->unset_export();
        $crud->unset_print();
        
        if ($accion == 'add') {
            $crud->field_type('tiv_estado', 'hidden', 1);
        } else {
            $crud->field_type('tiv_estado', 'dropdown', array(1 => 'Activo', 0 => 'Inactivo'));
        }

        // Validaciones
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }
        if (!$permisos['permite_editar']) {
            $crud->unset_edit();
        }
        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }
        if ($permisos['permite_ver']) {
            $crud->add_action('Ver', 'minia-icon-search', 'expediente_personal/catalogos/tipo_vivienda/read');
        }

        $output = $crud->render();

        $data['titulo_personal'] = "Tipos de Vivienda";
        cargarvista($data, $output);
    } //Fin mantenimiento tipos de vivienda


    /**
     * Descripción:
     * Función para dar mantenimiento a tipos de construccion vivienda (tabla: tcv_tipo_construccion_vivienda)
     * @author René Castaneda - Grupo Satélite
     * @since 2017-11-22
     * @param ninguno
     * @return Mantenimiento de tipos de construccion vivienda
     */

    function tipo_construccion_vivienda() {
        satelite_validar();
        $crud = new grocery_CRUD();
        $accion = $crud->getState(); //obtener la acción que esta ejecutando grocery crud
        $permisos = $this->gsatelite->get_permisos_opcion();
        $crud->set_table('tcv_tipo_construccion_vivienda');
        $crud->set_subject('Construcción Vivienda');


        $columns = array(
            'tcv_nombre',
            'tcv_descripcion',
            'tcv_estado'
        );

        $display_as = array(
            'tcv_nombre' => 'Nombre',
            'tcv_descripcion' => 'Descripción',
            'tcv_estado' => 'Estado'
        );

        $required = array(
            'tcv_nombre',
            'tcv_estado'
        );

        $add_columns = array(
            'tcv_nombre',
            'tcv_descripcion',
            'tcv_estado',
            'tcv_fecha_creacion',
            'tcv_usu_creacion',
            'tcv_fecha_modificacion',
            'tcv_usu_modificacion'
        );

        $edit_columns = array(
            'tcv_nombre',
            'tcv_descripcion',
            'tcv_estado',
            'tcv_fecha_modificacion',
            'tcv_usu_modificacion'
        );

        $crud->columns($columns);
        $crud->display_as($display_as);
        $crud->required_fields($required);
        $crud->add_fields($add_columns);
        $crud->edit_fields($edit_columns);
        $crud->field_type('tcv_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
        $crud->field_type('tcv_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
        $crud->field_type('tcv_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
        $crud->field_type('tcv_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
        $crud->set_rules('tcv_nombre','Nombre','campo_unico[tcv_tipo_construccion_vivienda.tcv_nombre]|required');
        $crud->unset_export();
        $crud->unset_print();
        
        if ($accion == 'add') {
            $crud->field_type('tcv_estado', 'hidden', 1);
        } else {
            $crud->field_type('tcv_estado', 'dropdown', array(1 => 'Activo', 0 => 'Inactivo'));
        }

        // Validaciones
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }
        if (!$permisos['permite_editar']) {
            $crud->unset_edit();
        }
        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }
        if ($permisos['permite_ver']) {
            $crud->add_action('Ver', 'minia-icon-search', 'expediente_personal/catalogos/tipo_construccion_vivienda/read');
        }

        $output = $crud->render();

        $data['titulo_personal'] = "Tipos de Construcción - Vivienda";
        cargarvista($data, $output);
    } //Fin mantenimiento tipos de construción vivienda


    /**
     * Descripción:
     * Función para dar mantenimiento a tipos de sangre (tabla: tsr_tipo_sangre)
     * @author René Castaneda - Grupo Satélite
     * @since 2017-11-22
     * @param ninguno
     * @return Mantenimiento de tipos de sangre
     */
    public function tipo_sangre() {
        satelite_validar();
        $crud = new grocery_CRUD();
        $accion = $crud->getState(); //obtener la acción que esta ejecutando grocery crud
        $permisos = $this->gsatelite->get_permisos_opcion();
        $crud->set_table('tsr_tipo_sangre');
        $crud->set_subject('Tipo Sangre');


        $columns = array(
            'tsr_nombre',
            'tsr_descripcion',
            'tsr_estado'
        );

        $display_as = array(
            'tsr_nombre' => 'Nombre',
            'tsr_descripcion' => 'Descripción',
            'tsr_estado' => 'Estado'
        );

        $required = array(
            'tsr_nombre',
            'tsr_estado'
        );

        $add_columns = array(
            'tsr_nombre',
            'tsr_descripcion',
            'tsr_estado',
            'tsr_fecha_creacion',
            'tsr_usu_creacion',
            'tsr_fecha_modificacion',
            'tsr_usu_modificacion'
        );

        $edit_columns = array(
            'tsr_nombre',
            'tsr_descripcion',
            'tsr_estado',
            'tsr_fecha_modificacion',
            'tsr_usu_modificacion'
        );

        $crud->columns($columns);
        $crud->display_as($display_as);
        $crud->required_fields($required);
        $crud->add_fields($add_columns);
        $crud->edit_fields($edit_columns);
        $crud->field_type('tsr_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
        $crud->field_type('tsr_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
        $crud->field_type('tsr_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
        $crud->field_type('tsr_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
        $crud->set_rules('tsr_nombre','Nombre','campo_unico[tsr_tipo_sangre.tsr_nombre]|required');
        $crud->unset_export();
        $crud->unset_print();
        
        if ($accion == 'add') {
            $crud->field_type('tsr_estado', 'hidden', 1);
        } else {
            $crud->field_type('tsr_estado', 'dropdown', array(1 => 'Activo', 0 => 'Inactivo'));
        }

        // Validaciones
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }
        if (!$permisos['permite_editar']) {
            $crud->unset_edit();
        }
        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }
        if($permisos["permite_ver"]){
            $data_url = $this->masterpage->getUsuario();
            $url_read = $data_url['modulo'] . '/' . $data_url['control'] . '/' . $data_url['funcion'];
            $crud->add_action('Ver', 'minia-icon-search', $url_read."/read");
        }

        $output = $crud->render();
        $data['titulo_personal'] = "Tipos de Sangre";
        cargarvista($data, $output, 'expediente_personal/catalogos/tipo_sangre');
    } //Fin mantenimiento tipos de sangre



    /**
     * Descripción:
     * Función para dar mantenimiento a tipos de Incapacidad (tabla: tds_tipo_discapacidad)
     * @author René Castaneda - Grupo Satélite
     * @since 2017-11-22
     * @param ninguno
     * @return Mantenimiento de tipos de Incapacidad
     */
    public function tipo_discapacidad() {
        satelite_validar();
        $crud = new grocery_CRUD();
        $accion = $crud->getState(); //obtener la acción que esta ejecutando grocery crud
        $permisos = $this->gsatelite->get_permisos_opcion();
        $crud->set_table('tds_tipo_discapacidad');
        $crud->set_subject('Tipo Discapacidad');


        $columns = array(
            'tds_nombre',
            'tds_descripcion',
            'tds_estado'
        );

        $display_as = array(
            'tds_nombre' => 'Nombre',
            'tds_descripcion' => 'Descripción',
            'tds_estado' => 'Estado'
        );

        $required = array(
            'tds_nombre',
            'tds_estado'
        );

        $add_columns = array(
            'tds_nombre',
            'tds_descripcion',
            'tds_estado',
            'tds_fecha_creacion',
            'tds_usu_creacion',
            'tds_fecha_modificacion',
            'tds_usu_modificacion'
        );

        $edit_columns = array(
            'tds_nombre',
            'tds_descripcion',
            'tds_estado',
            'tds_fecha_modificacion',
            'tds_usu_modificacion'
        );

        $crud->columns($columns);
        $crud->display_as($display_as);
        $crud->required_fields($required);
        $crud->add_fields($add_columns);
        $crud->edit_fields($edit_columns);
        $crud->field_type('tds_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
        $crud->field_type('tds_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
        $crud->field_type('tds_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
        $crud->field_type('tds_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
        $crud->set_rules('tds_nombre','Nombre','campo_unico[tds_tipo_discapacidad.tds_nombre]|required');
        $crud->unset_export();
        $crud->unset_print();
        
        if ($accion == 'add') {
            $crud->field_type('tds_estado', 'hidden', 1);
        } else {
            $crud->field_type('tds_estado', 'dropdown', array(1 => 'Activo', 0 => 'Inactivo'));
        }

        // Validaciones
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }
        if (!$permisos['permite_editar']) {
            $crud->unset_edit();
        }
        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }
        if($permisos["permite_ver"]){
            $data_url = $this->masterpage->getUsuario();
            $url_read = $data_url['modulo'] . '/' . $data_url['control'] . '/' . $data_url['funcion'];
            $crud->add_action('Ver', 'minia-icon-search', $url_read."/read");
        }

        $output = $crud->render();

        $data['titulo_personal'] = "Tipos de Discapacidad";
        cargarvista($data, $output, 'expediente_personal/catalogos/tipo_discapacidad');
    } //Fin mantenimiento tipos de discapacidad

    /**
     * Descripción:
     * Función para dar mantenimiento a Servicios Básicos (tabla: srb_servicio_basico)
     * @author René Castaneda - Grupo Satélite
     * @since 2017-11-22
     * @param ninguno
     * @return Mantenimiento de servicios basicos
     */

    function servicio_basico() {
        satelite_validar();
        $crud = new grocery_CRUD();
        $accion = $crud->getState(); //obtener la acción que esta ejecutando grocery crud
        $permisos = $this->gsatelite->get_permisos_opcion();
        $crud->set_table('srb_servicio_basico');
        $crud->set_subject('Servicio Basico');


        $columns = array(
            'srb_nombre',
            'srb_descripcion',
            'srb_estado'
        );

        $display_as = array(
            'srb_nombre' => 'Nombre',
            'srb_descripcion' => 'Descripción',
            'srb_estado' => 'Estado'
        );

        $required = array(
            'srb_nombre',
            'srb_estado'
        );

        $add_columns = array(
            'srb_nombre',
            'srb_descripcion',
            'srb_estado',
            'srb_fecha_creacion',
            'srb_usu_creacion',
            'srb_fecha_modificacion',
            'srb_usu_modificacion'
        );

        $edit_columns = array(
            'srb_nombre',
            'srb_descripcion',
            'srb_estado',
            'srb_fecha_modificacion',
            'srb_usu_modificacion'
        );

        $crud->columns($columns);
        $crud->display_as($display_as);
        $crud->required_fields($required);
        $crud->add_fields($add_columns);
        $crud->edit_fields($edit_columns);
        $crud->field_type('srb_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
        $crud->field_type('srb_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
        $crud->field_type('srb_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
        $crud->field_type('srb_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
        $crud->set_rules('srb_nombre','Nombre','campo_unico[srb_servicio_basico.srb_nombre]|required');
        $crud->unset_export();
        $crud->unset_print();
        
        if ($accion == 'add') {
            $crud->field_type('srb_estado', 'hidden', 1);
        } else {
            $crud->field_type('srb_estado', 'dropdown', array(1 => 'Activo', 0 => 'Inactivo'));
        }

        // Validaciones
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }
        if (!$permisos['permite_editar']) {
            $crud->unset_edit();
        }
        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }
        if ($permisos['permite_ver']) {
            $crud->add_action('Ver', 'minia-icon-search', 'expediente_personal/catalogos/servicio_basico/read');
        }

        $output = $crud->render();

        $data['titulo_personal'] = "Servicio Básico";
        cargarvista($data, $output);
    } //Fin mantenimiento a Servicios Básicos
    

    /**
     * Descripción:
     * Función para dar mantenimiento a Nivles de habilidad (tabla: nih_nivel_habilidad)
     * @author René Castaneda - Grupo Satélite
     * @since 2017-12-07
     * @param ninguno
     * @return Mantenimiento de Niveles de habilidad
     */

    function nivel_habilidad() {
        satelite_validar();
        $crud = new grocery_CRUD();
        $accion = $crud->getState(); //obtener la acción que esta ejecutando grocery crud
        $permisos = $this->gsatelite->get_permisos_opcion();
        $crud->set_table('nih_nivel_habilidad');
        $crud->set_subject('Nivel Habilidad');


        $columns = array(
            'nih_nombre',
            'nih_estado'
        );

        $display_as = array(
            'nih_nombre' => 'Nombre',
            'nih_estado' => 'Estado'
        );

        $required = array(
            'nih_nombre',
            'nih_estado'
        );

        $add_columns = array(
            'nih_nombre',
            'nih_estado',
            'nih_fecha_creacion',
            'nih_usu_creacion',
            'nih_fecha_modificacion',
            'nih_usu_modificacion'
        );

        $edit_columns = array(
            'nih_nombre',
            'nih_estado',
            'nih_fecha_modificacion',
            'nih_usu_modificacion'
        );

        $crud->columns($columns);
        $crud->display_as($display_as);
        $crud->required_fields($required);
        $crud->add_fields($add_columns);
        $crud->edit_fields($edit_columns);
        $crud->field_type('nih_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
        $crud->field_type('nih_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
        $crud->field_type('nih_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
        $crud->field_type('nih_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
        $crud->set_rules('nih_nombre','Nombre','campo_unico[nih_nivel_habilidad.nih_nombre]|required');
        $crud->unset_export();
        $crud->unset_print();
        
        if ($accion == 'add') {
            $crud->field_type('nih_estado', 'hidden', 1);
        } else {
            $crud->field_type('nih_estado', 'dropdown', array(1 => 'Activo', 0 => 'Inactivo'));
        }

        // Validaciones
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }
        if (!$permisos['permite_editar']) {
            $crud->unset_edit();
        }
        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }
        if ($permisos['permite_ver']) {
            $crud->add_action('Ver', 'minia-icon-search', 'expediente_personal/catalogos/nivel_habilidad/read');
        }

        $output = $crud->render();

        $data['titulo_personal'] = "Niveles Habilidad";
        cargarvista($data, $output);
    } //Fin mantenimiento a niveles de habilidad



    /**
     * Descripción:
     * Función para dar mantenimiento a habilidad (compartiendo el catalogo con registro academico)
     * @author René Castaneda - Grupo Satélite
     * @since 2017-12-07
     * @param ninguno
     * @return Mantenimiento de habilidad
     */

    function habilidad(){
        if(!$this->tank_auth->is_logged_in()){
            redirect('/auth/login/');
        } else {
            $this->load->library('../controllers/registro_academico/mantenimientos');
            $vistas = array('registro_academico/mantenimientos/habilidades','expediente_personal/catalogos/habilidad');
            $this->mantenimientos->habilidades($vistas);
        }        
    }



    /**
     * Descripción:
     * Función para dar mantenimiento a tipos de habilidad (compartiendo el catalogo con registro academico)
     * @author René Castaneda - Grupo Satélite
     * @since 2017-12-07
     * @param ninguno
     * @return Mantenimiento de tipo de  habilidad
     */

    function tipo_habilidad(){
        if(!$this->tank_auth->is_logged_in()){
            redirect('/auth/login/');
        } else {
            $this->load->library('../controllers/registro_academico/mantenimientos');
            $vistas = array('registro_academico/mantenimientos/tipo_habilidades','expediente_personal/catalogos/tipo_habilidad');
            $this->mantenimientos->tipo_habilidades($vistas);
        }        
    }



    /**
     * Descripción:
     * Función para dar mantenimiento a tipo de salario (tabla: tps_tipo_salario)
     * @author René Castaneda - Grupo Satélite
     * @since 2017-12-12
     * @param $ruta_vista = Parametro para la ruta de la vista a mostrar
     * @return Mantenimiento de tipo de salario
     */

    function tipo_salario($ruta_vista = null) {
        satelite_validar();

        //$ruta_vista es una array en la posición uno viene la ruta de los permisos a obtener en la dos viene la vista a cargar.
        $ruta_permisos = (is_array($ruta_vista)) ? $ruta_vista[0] : 'expediente_personal/catalogos/tipo_salario'; //cuando viene la petición de otro modulo.
        $arreglo_url = explode('/', $ruta_permisos);
        $data['modulo_url'] = $arreglo_url[0] . '/' . $arreglo_url[1]; //cuando viene la petición de otro modulo.
        $ruta_vista = (is_array($ruta_vista)) ? $ruta_vista[1] : null;

        $crud = new grocery_CRUD();
        $accion = $crud->getState(); //obtener la acción que esta ejecutando grocery crud
        $permisos = $this->gsatelite->get_permisos_opcion();
        $crud->set_table('tps_tipo_salario');
        $crud->set_subject('Tipo Salario');


        $columns = array(
            'tps_nombre',
            'tps_descripcion',
            'tps_estado'
        );

        $display_as = array(
            'tps_nombre' => 'Nombre',
            'tps_descripcion' => 'Descripción',
            'tps_estado' => 'Estado'
        );

        $required = array(
            'tps_nombre',
            'tps_estado'
        );

        $add_columns = array(
            'tps_nombre',
            'tps_descripcion',
            'tps_estado',
            'tps_fecha_creacion',
            'tps_usu_creacion',
            'tps_fecha_modificacion',
            'tps_usu_modificacion'
        );

        $edit_columns = array(
            'tps_nombre',
            'tps_descripcion',
            'tps_estado',
            'tps_fecha_modificacion',
            'tps_usu_modificacion'
        );

        $crud->columns($columns);
        $crud->display_as($display_as);
        $crud->required_fields($required);
        $crud->add_fields($add_columns);
        $crud->edit_fields($edit_columns);
        $crud->field_type('tps_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
        $crud->field_type('tps_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
        $crud->field_type('tps_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
        $crud->field_type('tps_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
        $crud->set_rules('tps_nombre','Nombre','campo_unico[tps_tipo_salario.tps_nombre]|required');
        $crud->unset_export();
        $crud->unset_print();
        
        if ($accion == 'add') {
            $crud->field_type('tps_estado', 'hidden', 1);
        } else {
            $crud->field_type('tps_estado', 'dropdown', array(1 => 'Activo', 0 => 'Inactivo'));
        }

        // Validaciones
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }
        if (!$permisos['permite_editar']) {
            $crud->unset_edit();
        }
        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }
        if (!$permisos['permite_ver']) {
            $crud->unset_read();
        } else {
            $data_url = $this->masterpage->getUsuario();
            $url_read = $data_url['modulo'] . '/' . $data_url['control'] . '/' . $data_url['funcion'];
            $crud->add_action('Ver', 'minia-icon-search', $url_read."/read");
        }

        $output = $crud->render();

        $data['titulo_personal'] = "Tipo de Salario";
        $ruta_vista = (trim($ruta_vista) != '')? $ruta_vista:'expediente_personal/catalogos/tipo_salario';
        cargarvista($data, $output, $ruta_vista);
    } //Fin mantenimiento tipos de salario



    /**
     * Descripción:
     * Función para dar mantenimiento a categoria aguinaldo (tabla: cta_categoria_aguinaldo)
     * @author René Castaneda - Grupo Satélite
     * @since 2017-12-12
     * @param ninguno
     * @return Mantenimiento de  categoria aguinaldo
     */

    function categoria_aguinaldo() {
        satelite_validar();
        $crud = new grocery_CRUD();
        $accion = $crud->getState(); //obtener la acción que esta ejecutando grocery crud
        $permisos = $this->gsatelite->get_permisos_opcion();
        $crud->set_table('cta_categoria_aguinaldo');
        $crud->set_subject('Categoria Aguinaldo');


        $columns = array(
            'cta_nombre',
            'cta_descripcion',
            'cta_estado'
        );

        $display_as = array(
            'cta_nombre' => 'Nombre',
            'cta_descripcion' => 'Descripción',
            'cta_estado' => 'Estado'
        );

        $required = array(
            'cta_nombre',
            'cta_estado'
        );

        $add_columns = array(
            'cta_nombre',
            'cta_descripcion',
            'cta_estado',
            'cta_fecha_creacion',
            'cta_usu_creacion',
            'cta_fecha_modificacion',
            'cta_usu_modificacion'
        );

        $edit_columns = array(
            'cta_nombre',
            'cta_descripcion',
            'cta_estado',
            'cta_fecha_modificacion',
            'cta_usu_modificacion'
        );

        $crud->columns($columns);
        $crud->display_as($display_as);
        $crud->required_fields($required);
        $crud->add_fields($add_columns);
        $crud->edit_fields($edit_columns);
        $crud->field_type('cta_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
        $crud->field_type('cta_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
        $crud->field_type('cta_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
        $crud->field_type('cta_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
        $crud->set_rules('cta_nombre','Nombre','campo_unico[cta_categoria_aguinaldo.cta_nombre]|required');
        $crud->unset_export();
        $crud->unset_print();
        
        if ($accion == 'add') {
            $crud->field_type('cta_estado', 'hidden', 1);
        } else {
            $crud->field_type('cta_estado', 'dropdown', array(1 => 'Activo', 0 => 'Inactivo'));
        }

        // Validaciones
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }
        if (!$permisos['permite_editar']) {
            $crud->unset_edit();
        }
        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }
        if ($permisos['permite_ver']) {
            $crud->add_action('Ver', 'minia-icon-search', 'expediente_personal/catalogos/categoria_aguinaldo/read');
        }

        $output = $crud->render();

        $data['titulo_personal'] = "Categoria Aguinaldo";
        cargarvista($data, $output);
    } //Fin mantenimiento categoria aguinaldo


    /**
     * Descripción:
     * Función para dar mantenimiento a fuente de reclutamiento (tabla: fnr_fuente_reclutamiento)
     * @author René Castaneda - Grupo Satélite
     * @since 2017-12-12
     * @param ninguno
     * @return Mantenimiento de  fuente de reclutamiento
     */

    function fuente_reclutamiento() {
        satelite_validar();
        $crud = new grocery_CRUD();
        $accion = $crud->getState(); //obtener la acción que esta ejecutando grocery crud
        $permisos = $this->gsatelite->get_permisos_opcion();
        $crud->set_table('fnr_fuente_reclutamiento');
        $crud->set_subject('Fuente reclutamiento');


        $columns = array(
            'fnr_nombre',
            'fnr_descripcion',
            'fnr_estado'
        );

        $display_as = array(
            'fnr_nombre' => 'Nombre',
            'fnr_descripcion' => 'Descripción',
            'fnr_estado' => 'Estado'
        );

        $required = array(
            'fnr_nombre',
            'fnr_estado'
        );

        $add_columns = array(
            'fnr_nombre',
            'fnr_descripcion',
            'fnr_estado',
            'fnr_fecha_creacion',
            'fnr_usu_creacion',
            'fnr_fecha_modificacion',
            'fnr_usu_modificacion'
        );

        $edit_columns = array(
            'fnr_nombre',
            'fnr_descripcion',
            'fnr_estado',
            'fnr_fecha_modificacion',
            'fnr_usu_modificacion'
        );

        $crud->columns($columns);
        $crud->display_as($display_as);
        $crud->required_fields($required);
        $crud->add_fields($add_columns);
        $crud->edit_fields($edit_columns);
        $crud->field_type('fnr_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
        $crud->field_type('fnr_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
        $crud->field_type('fnr_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
        $crud->field_type('fnr_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
        $crud->set_rules('fnr_nombre','Nombre','campo_unico[fnr_fuente_reclutamiento.fnr_nombre]|required');
        $crud->unset_export();
        $crud->unset_print();
        
        if ($accion == 'add') {
            $crud->field_type('fnr_estado', 'hidden', 1);
        } else {
            $crud->field_type('fnr_estado', 'dropdown', array(1 => 'Activo', 0 => 'Inactivo'));
        }

        // Validaciones
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }
        if (!$permisos['permite_editar']) {
            $crud->unset_edit();
        }
        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }
        if (!$permisos['permite_ver']) {
            $crud->unset_read();
        }

        $output = $crud->render();

        $data['titulo_personal'] = "Fuente de reclutamiento";
        cargarvista($data, $output);
    } //Fin mantenimiento fuente de reclutamiento

    /*
    *   Funcionalidad Compartida con el modulo de Seleccion de Personal
    */
    public function modalidad($ruta_vista = null) {
        satelite_validar();
        try {
            //$ruta_vista es una array en la posición uno viene la ruta de los permisos a obtener en la dos viene la vista a cargar.
            //cuando viene la petición de otro modulo.
            $ruta_permisos = (is_array($ruta_vista)) ? $ruta_vista[0] : 'expediente_personal/catalogos/modalidad'; 

            $arreglo_url    = explode('/', $ruta_permisos);
            $modulo_url     = $arreglo_url[0] . '/' . $arreglo_url[1]; //cuando viene la petición de otro modulo.
            $data['modulo_url'] = $modulo_url;
            $ruta_vista     = (is_array($ruta_vista)) ? $ruta_vista[1] : null;

            $permisos = $this->gsatelite->get_permisos_opcion();
            $crud = new grocery_CRUD();
            $crud->unset_export();
            $crud->unset_print();
            $crud->set_table('mde_modalidad_estudio');
            $crud->set_subject('Modalidades');

            $columnas = array(
                'mde_nombre',
                'mde_estado'
            );

            $add_fields = array(
                'mde_nombre',
                'mde_descripcion',
                'mde_estado',
                'mde_usu_creacion',
                'mde_usu_modificacion',
                'mde_fecha_creacion',
                'mde_fecha_modificacion'
            );

            $edit_fields = array(
                'mde_nombre',
                'mde_descripcion',
                'mde_estado',
                'mde_usu_modificacion',
                'mde_fecha_modificacion'
            );

            $required_fields = array(
                'mde_nombre',
                'mde_estado',
                'mde_usu_creacion',
                'mde_usu_modificacion',
                'mde_fecha_creacion',
                'mde_fecha_modificacion'
            );

            $display_as = array(
                'mde_nombre'        => 'Nombre',
                'mde_descripcion'   => 'Descripción',
                'mde_estado'        => 'Estado'
            );

            $crud->required_fields($required_fields);
            $crud->columns($columnas);
            $crud->add_fields($add_fields);
            $crud->edit_fields($edit_fields);
            $crud->display_as($display_as);
            $crud->field_type('mde_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('mde_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->set_rules('mde_nombre', 'Nombre', 'campo_unico[mde_modalidad_estudio.mde_nombre]|required');

            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('mde_estado', 'hidden', 1)
                        ->field_type('mde_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                        ->field_type('mde_fecha_creacion', 'hidden', date('Y-m-d h:i:s'));
            } else {
                $crud->field_type('mde_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if (!$permisos['permite_ver']) {
                $crud->unset_read();
            } else {
                $data_url = $this->masterpage->getUsuario();
                $url_read = $data_url['modulo'] . '/' . $data_url['control'] . '/' . $data_url['funcion'];
                $crud->add_action('Ver', 'minia-icon-search', $url_read."/read");
            }

            $output = $crud->render();
            $data['titulo_personal'] = "Catálogo de modalidades";
            $ruta_vista = (trim($ruta_vista) != '')? $ruta_vista:'expediente_personal/catalogos/modalidad';
            cargarvista($data, $output, $ruta_vista);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    public function instituciones($ruta_vista = null) {
        satelite_validar();
        try {

            //$ruta_vista es una array en la posición uno viene la ruta de los permisos a obtener en la dos viene la vista a cargar.
            //cuando viene la petición de otro modulo.
            $ruta_permisos = (is_array($ruta_vista)) ? $ruta_vista[0] : 'expediente_personal/catalogos/instituciones'; 
            $arreglo_url    = explode('/', $ruta_permisos);
            $modulo_url     = $arreglo_url[0] . '/' . $arreglo_url[1]; //cuando viene la petición de otro modulo.
            $data['modulo_url'] = $modulo_url;
            $ruta_vista     = (is_array($ruta_vista)) ? $ruta_vista[1] : null;

            $permisos = $this->gsatelite->get_permisos_opcion();
            $crud = new grocery_CRUD();
            $crud->unset_export();
            $crud->unset_print();
            $crud->set_table('icp_institucion_capacitacion');
            $crud->set_subject('Instituciones');

            $columnas = array(
                'icp_nombre',
                'icp_estado'
            );

            $add_fields = array(
                'icp_nombre',
                'icp_descripcion',
                'icp_estado',
                'icp_usu_creacion',
                'icp_usu_modificacion',
                'icp_fecha_creacion',
                'icp_fecha_modificacion'
            );

            $edit_fields = array(
                'icp_nombre',
                'icp_descripcion',
                'icp_estado',
                'icp_usu_modificacion',
                'icp_fecha_modificacion'
            );

            $required_fields = array(
                'icp_nombre',
                'icp_estado',
                'icp_usu_creacion',
                'icp_usu_modificacion',
                'icp_fecha_creacion',
                'icp_fecha_modificacion'
            );

            $display_as = array(
                'icp_nombre'        => 'Nombre',
                'icp_descripcion'   => 'Descripción',
                'icp_estado'        => 'Estado'
            );

            $crud->required_fields($required_fields);
            $crud->columns($columnas);
            $crud->add_fields($add_fields);
            $crud->edit_fields($edit_fields);
            $crud->display_as($display_as);
            $crud->field_type('icp_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('icp_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->set_rules('icp_nombre', 'Nombre', 'campo_unico[icp_institucion_capacitacion.icp_nombre]|required');

            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('icp_estado', 'hidden', 1)
                        ->field_type('icp_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                        ->field_type('icp_fecha_creacion', 'hidden', date('Y-m-d h:i:s'));
            } else {
                $crud->field_type('icp_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if (!$permisos['permite_ver']) {
                $crud->unset_read();
            } else {
                $data_url = $this->masterpage->getUsuario();
                $url_read = $data_url['modulo'] . '/' . $data_url['control'] . '/' . $data_url['funcion'];
                $crud->add_action('Ver', 'minia-icon-search', $url_read."/read");
            }

            $output = $crud->render();
            $data['titulo_personal'] = "Catálogo de instituciones Cap.";
            $ruta_vista = (trim($ruta_vista) != '')? $ruta_vista:'expediente_personal/catalogos/instituciones';
            cargarvista($data, $output, $ruta_vista);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }


    /**
     * Descripción:
     * Función para dar mantenimiento a tipos de cuenta (compartiendo el catalogo con modulo de banco)
     * @author René Castaneda - Grupo Satélite
     * @since 2017-12-07
     * @param ninguno
     * @return Mantenimiento de tipo cuenta
     */

    function tipo_cuenta(){
        if(!$this->tank_auth->is_logged_in()){
            redirect('/auth/login/');
        } else {
            $this->load->library('../controllers/utm/bancos');
            $this->bancos->gestion_cuenta();



        }        
    }
    
    /**
     * Descripción:
     * Función para dar mantenimiento a tipos de insumo
     * @author Elman Ortiz - Grupo Satélite
     * @since 2017-12-13
     * @param ninguno
     * @return Mantenimiento de tipo insumo
     */
    public function tipo_insumo() {
        satelite_validar();
        try {
            $permisos = $this->gsatelite->get_permisos_opcion();
            $crud = new grocery_CRUD();
            $crud->unset_export();
            $crud->unset_print();
            $crud->set_table('tim_tipo_insumo');
            $crud->set_subject('Tipo de insumo');

            $columnas = array(
                'tim_nombre',
                'tim_descripcion',
                'tim_estado'
            );

            $add_fields = array(
                'tim_nombre',
                'tim_descripcion',
                'tim_usu_creacion',
                'tim_fecha_creacion',
                'tim_usu_modificacion',
                'tim_fecha_modificacion',
                'tim_estado'                    
            );

            $edit_fields = array(
                'tim_nombre',
                'tim_descripcion',
                'tim_usu_modificacion',
                'tim_fecha_modificacion',
                'tim_estado'                    
            );

            $required_fields = array(
                'tim_nombre',
                'tim_estado',
                'tim_usu_crea',
                'tim_usu_mod',
                'tim_fecha_crea',
                'tim_fecha_mod'
            );

            $display_as = array(
                'tim_nombre' => 'Nombre',
                'tim_descripcion' => 'Descripción',
                'tim_estado' => 'Estado'
            );

            $crud->required_fields($required_fields);
            $crud->columns($columnas);
            $crud->add_fields($add_fields);
            $crud->edit_fields($edit_fields);
            $crud->display_as($display_as);
            $crud->field_type('tim_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('tim_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->set_rules('tim_nombre', 'Nombre', 'campo_unico[tim_tipo_insumo.tim_nombre]|required');

            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('tim_estado', 'hidden', 1)
                        ->field_type('tim_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                        ->field_type('tim_fecha_creacion', 'hidden', date('Y-m-d h:i:s'));
            } else {
                $crud->field_type('tim_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if (!$permisos['permite_ver']) {
                $crud->unset_read();
            }            

            $output = $crud->render();
            $data['titulo_personal'] = "Catálogo de tipo de insumo";
            $this->_cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }    
    
    /**
     * Descripción:
     * Función para dar mantenimiento a insumo
     * @author Elman Ortiz - Grupo Satélite
     * @since 2017-12-13
     * @param ninguno
     * @return Mantenimiento de insumo
     */
    public function insumo() {
        satelite_validar();
        try {
            $permisos = $this->gsatelite->get_permisos_opcion();
            $crud = new grocery_CRUD();
            $crud->unset_export();
            $crud->unset_print();
            $crud->set_table('inm_insumo');
            $crud->set_subject('Insumo');

            $columnas = array(
                'inm_id',
                'inm_nombre',
                'inm_descripcion',
                'inm_id_tim',
                'inm_estado'
            );

            $add_fields = array(
                'inm_nombre',
                'inm_descripcion',
                'inm_id_tim',
                'inm_usu_creacion',
                'inm_fecha_creacion',
                'inm_usu_modificacion',
                'inm_fecha_modificacion',
                'inm_estado'                    
            );

            $edit_fields = array(
                'inm_nombre',
                'inm_descripcion',
                'inm_id_tim',
                'inm_usu_modificacion',
                'inm_fecha_modificacion',
                'inm_estado'                    
            );

            $required_fields = array(
                'inm_nombre',
                'inm_id_tim',
                'inm_estado',
                'inm_usu_crea',
                'inm_usu_mod',
                'inm_fecha_crea',
                'inm_fecha_mod'
            );

            $display_as = array(
                'inm_id' => 'ID',
                'inm_nombre' => 'Nombre',
                'inm_descripcion' => 'Descripción',
                'inm_id_tim' => 'Tipo de insumo',
                'inm_estado' => 'Estado'
            );

            $crud->required_fields($required_fields);
            $crud->columns($columnas);
            $crud->add_fields($add_fields);
            $crud->edit_fields($edit_fields);
            $crud->display_as($display_as);
            $crud->field_type('inm_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('inm_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->set_rules('inm_nombre', 'Nombre', 'campo_unico[inm_insumo.inm_nombre]|required');

            $crud->set_relation('inm_id_tim', 'tim_tipo_insumo', 'tim_nombre');
            
            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('inm_estado', 'hidden', 1)
                        ->field_type('inm_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                        ->field_type('inm_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
            } else {
                $crud->field_type('inm_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if (!$permisos['permite_ver']) {
                $crud->add_read();
            }

            $output = $crud->render();
            $data['titulo_personal'] = "Catálogo de insumo";
            $this->_cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    /**
     * Descripción:
     * Función para dar mantenimiento a estados de estudio
     * @author Elman Ortiz - Grupo Satélite
     * @since 2017-12-14
     * @param ninguno
     * @return Mantenimiento de estado de estudio
     */
    public function estado_estudio() {
        satelite_validar();
        try {
            $permisos = $this->gsatelite->get_permisos_opcion();
            $crud = new grocery_CRUD();
            $crud->unset_export();
            $crud->unset_print();
            $crud->set_table('ese_estado_estudio');
            $crud->set_subject('Estados de estudio');

            $columnas = array(
                'ese_nombre',
                'ese_descripcion',
                'ese_estado'
            );

            $add_fields = array(
                'ese_nombre',
                'ese_descripcion',
                'ese_estado',
                'ese_usu_creacion',
                'ese_usu_modificacion',
                'ese_fecha_creacion',
                'ese_fecha_modificacion'                    
            );

            $edit_fields = array(
                'ese_nombre',
                'ese_descripcion',
                'ese_estado',
                'ese_usu_modificacion',
                'ese_fecha_modificacion'                    
            );

            $required_fields = array(
                'ese_nombre',
                'ese_estado',
                'ese_usu_creacion',
                'ese_usu_modificacion',
                'ese_fecha_creacion',
                'ese_fecha_modificacion'
            );

            $display_as = array(
                'ese_nombre' => 'Nombre',
                'ese_descripcion' => 'Descripción',
                'ese_estado' => 'Estado'
            );

            $crud->required_fields($required_fields);
            $crud->columns($columnas);
            $crud->add_fields($add_fields);
            $crud->edit_fields($edit_fields);
            $crud->display_as($display_as);
            $crud->field_type('ese_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('ese_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('ese_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('ese_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->set_rules('ese_nombre', 'Nombre', 'campo_unico[ese_estado_estudio.ese_nombre]|required');

            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('ese_estado', 'hidden', 1);
            } else {
                $crud->field_type('ese_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if (!$permisos['permite_ver']) {
                $crud->unset_read();
            }else{
                $data_url = $this->masterpage->getUsuario();
                $url_read = $data_url['modulo'] . '/' . $data_url['control'] . '/' . $data_url['funcion'];
                $crud->add_action('Ver', 'minia-icon-search', $url_read."/read");
            }            

            $output = $crud->render();
            $data['titulo_personal'] = "Catálogo estados de estudio";
            $this->_cargarvista($data, $output, 'expediente_personal/catalogos/estado_estudio');
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }  

    /**
     * @author René Castaneda
     * @since 2017-12-21
     * @return catalogo de categoria de retiro
     * @description se cargará una funcionalidad centralizada en: acciones_personal/mantenimientos (funcion: categoria_retiro )
      */
     public function categoria_retiro() {
         if (!$this->tank_auth->is_logged_in()) {
             redirect('/auth/login/');
         } else {
             satelite_validar();
             $this->load->library('../controllers/acciones_personal/mantenimientos');
             $this->mantenimientos->categoria_retiro('expediente_personal/catalogos');
         }
     }

     /**
      * @author René Castaneda
      * @since 2018-01-23
      * @return Generar codigo automatico para la sucursal
       */

     public function get_codigo_sucursal($es_ajax = false)
     {
         $codigo_sugerido_suc = '';

             $codigo_sugerido = ($this->gsatelite->get_max('suc_sucursal', 'suc_id') + 1); //validar que el sugerido no exista
             $existe = true;
             while ($existe) {
                 $pregunta = $this->gsatelite->get_tabla('suc_sucursal',array('suc_codigo'=>$codigo_sugerido));
                 if (count($pregunta) <= 0) {
                     $existe = false;
                 } else {
                     $codigo_sugerido++;
                 }
             }

        $codigo_sugerido_suc = $codigo_sugerido;

        if ($es_ajax) {
            die( json_encode(array('codigo'=>$codigo_sugerido_suc)));
        }

        return $codigo_sugerido_suc;


     }

     /**
      * @author René Castaneda
      * @since 2018-01-31
      * @return Mantenimiento catalogos paises
       */
     public function pais()
     {
        satelite_validar();
        $this->load->library('../controllers/sistema/catalogo');
        $this->catalogo->pais();
     }

     /**
      * @author René Castaneda
      * @since 2018-01-31
      * @return Mantenimiento catalogos departamento
       */
     public function departamentos()
     {
        satelite_validar();
        $this->load->library('../controllers/sistema/catalogo');
        $this->catalogo->departamentos();
     }

     /**
     * @author Edith Herrera
     * @since  2018-03-09
     * @return Mantenimiento nivel de idioma 
     */
    //==== Mantenimiento nivel de idioma - registro academico
    public function nivel_idioma()
    {
        satelite_validar();
        $this->load->library('../controllers/registro_academico/mantenimientos');
        $this->mantenimientos->nivel_idioma();
    }

    /**
     * Descripción:
     * Función para dar mantenimiento de Idioma  (tabla: idm_idioma)
     * Funcionalidad Compartida del Modulo de Registro Academico - idiomas
     * @author René Castaneda - Grupo Satélite
     * @since 2018-05-25
     * @param ninguno
     * @return Mantenimiento de Idiomas
     */
    public function idiomas() {
        satelite_validar();
        $this->load->library('../controllers/registro_academico/mantenimientos');
        $this->mantenimientos->idiomas();
    }

    /**
     * Descripción:
     * Función para dar mantenimiento a Beneficios por puesto (tabla:bfp_beneficio_puesto )
     * @author Rafael A. Cuchilla - Grupo satélite
     * @since  2018-07-09
     * @param  Ninguno
     * @return Mantenimiento de Beneficios por puesto
     */
    public function ubicacion_plaza() {
        satelite_validar();

        try {
            $permisos = $this->gsatelite->get_permisos_opcion();
            $crud = new grocery_CRUD();


            $columnas = array(
                'ubp_nombre',
                'ubp_estado'
            );

            $required = array(
                'ubp_nombre',
                'ubp_estado'
            );

            $alias = array(
                'ubp_nombre' => 'Nombre',
                'ubp_estado' => 'Estado'
            );

            $columnas_insert = array(
                'ubp_nombre',
                'ubp_estado',
                'ubp_usu_creacion',
                'ubp_fecha_creacion',
                'ubp_usu_modificacion',
                'ubp_fecha_modificacion'
            );

            $columnas_update = array(
                'ubp_nombre',
                'ubp_estado',
                'ubp_usu_modificacion',
                'ubp_fecha_modificacion'
            );

            $crud->set_table('ubp_ubicacion_plaza')
                    ->set_subject('Ubicacion Plaza / Cargo Funcional')
                    ->columns($columnas)
                    ->display_as($alias)
                    ->add_fields($columnas_insert)
                    ->edit_fields($columnas_update)
                    ->required_fields($required)
                    ->set_rules('ubp_nombre', 'Nombre', 'trim|required|campo_unico[ubp_ubicacion_plaza.ubp_nombre]')
                    ->field_type('ubp_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('ubp_fecha_modificacion', 'hidden', date('Y-m-d h:i:s'))
                    ->field_type('ubp_fecha_creacion', 'hidden', date('Y-m-d h:i:s'))
                    ->field_type('ubp_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
            ;

            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('ubp_estado', 'hidden', 1);
            } else {
                $crud->field_type('ubp_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if (!$permisos['permite_ver']) {
                $crud->unset_read();
            } else {
                $data_url = $this->masterpage->getUsuario();
                $url_read = $data_url['modulo'] . '/' . $data_url['control'] . '/' . $data_url['funcion'];
                $crud->add_action('Ver', 'minia-icon-search', $url_read."/read");
            }

            $output = $crud->render();
            $data['titulo_personal'] = "Ubicacion Plaza / Cargo Funcional";
           
            cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    function _cargarvista($data = 0, $crud = 0, $ruta_vista='') {
        $this->load->view('vacia', $crud);
        if ($data != 0)
            $data = array_merge($data, $this->masterpage->getUsuario());
        else
            $data = $this->masterpage->getUsuario();
        $vista = (trim($ruta_vista) != '' and substr_count(trim($ruta_vista),'/') > 1 )? trim($ruta_vista):$data['modulo'] . '/' . $data['control'] . '/' . $data['funcion'];
        $this->masterpage->setMasterPage('masterpage_default');
        $this->masterpage->addContentPage($vista, 'content', $data);
        $this->masterpage->show();
    }

    /**
     * Descripción:
     * Función para dar mantenimiento al cuerpo de constancias
     * @author Raul E - Grupo Satélite
     * @since Abr-2021
     */
    public function cuerpo_constancia(){
        satelite_validar();
        if ($_POST) {
            $tipos = $this->input->post("tipo_cons");
                    $this->db->join('tpo_tipo_constancia', 'tpo_id = fre_id_tpo');
            $dato = $this->gsatelite->get_tabla('fre_formato_constancia_empleado', array('tpo_id' => $tipos));
            if (count($dato) > 0) {
                $error = 0;
                $valor = $dato[0]['fre_configuraciones_formato'];
            } else {
                $error = 1;
                $valor = "";
            }
            echo json_encode(array('error' => $error, 'valor' => $valor));
            die();
        } else {
                        $this->db->where('txr_id_emr', $this->tank_auth->get_empresa_id());
                        $this->db->join('txr_tipo_constanciaxempresa', 'txr_id_tpo = tpo_id');
            $tipo_con = $this->gsatelite->get_dropdown('tpo_tipo_constancia','tpo_nombre','', array('tpo_estado' => 1, 'txr_estado' => 1), null, '', 'tpo_id', true);
            $data['constancias'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $tipo_con);
            $data['titulo_personal'] = "Texto Constancias Personalizadas";
            $this->_cargarvista($data);
        }        
    }

    public function editar_constancia($tipo_constancia){
        satelite_validar();
        if ($_POST) {
            $id_cons = $this->input->post("id_cons");
            $tip_con = $this->input->post("tipo_cons");
            $texto = $this->input->post("text_cons");
            $actualiza = array(
                'fre_configuraciones_formato' => $texto,
                'fre_usu_modificacion' => $this->tank_auth->get_user_id(),
                'fre_fecha_modificacion' => date('Y-m-d h:i:s')
            );
            $exito = $this->gsatelite->actualizar_array('fre_formato_constancia_empleado', $actualiza, array('fre_id' => $id_cons));
            echo $exito;
            die();
        } else {
            $data['url_base'] = base_url();
            $data['tabla'] = $this->personal_model->get_datos_tipo_constancia($tipo_constancia);
            $this->load->view('expediente_personal/catalogos/editar_cuerpo_constancia', $data, FALSE);
        }
    }


    /**
     * Descripción:
     * Función para dar mantenimiento a Tipo de entrevista (tabla: tnv_tipo_entrevista)
     * @author Marlon Olmedo - Grupo Satélite
     * @since 05-06-2020
     * @param null
     * @return Mantenimiento de Tipo de entrevista
     */
    public function tipo_entrevista() {
        satelite_validar();
        $this->load->library('../controllers/modulo_seleccion_personal/slp_mantenimientos');
        $this->slp_mantenimientos->tipo_entrevista();
    }


    /**
     * Descripción:
     * Función para dar mantenimiento a Tipo de pruebas (tabla: tib_tipo_prueba)
     * @author Marlon Olmedo - Grupo Satélite
     * @since 05-06-2020
     * @param null
     * @return Mantenimiento de Tipo de pruebas
     */
    public function tipo_prueba() {
        satelite_validar();
        $this->load->library('../controllers/modulo_seleccion_personal/slp_mantenimientos');
        $this->slp_mantenimientos->tipo_prueba();
    }

    public function sindicatos() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {

            $siglas = $this->gsatelite->get_parametro('SYS_SIGLAS');

            $crud = new grocery_CRUD();

            $column = array(
                'sin_codigo',
                'sin_nombre', 
                'sin_descripcion',
                'sin_estado'
            );

            $display_as = array(
                'sin_codigo'=>'Código',
                'sin_nombre' => 'Nombre',
                'sin_descripcion' => 'Descripcion',
                'sin_estado' => 'Estado'
            );

            $add_columns = array( 
                'sin_codigo',
                'sin_descripcion',
                'sin_nombre',
                'sin_estado', 
                'sin_usu_creacion', 
                'sin_fecha_creacion', 
                'sin_usu_modificacion', 
                'sin_fecha_modificacion'
            );

            $edit_columns = array( 
                'sin_codigo',
                'sin_nombre', 
                'sin_descripcion',
                'sin_usu_modificacion', 
                'sin_fecha_modificacion',
                'sin_estado'
            );

            $crud->set_table('sin_sindicato');
            $crud->set_subject('Sindicatos');
            $crud->columns($column);
            $crud->display_as($display_as);
            $crud->required_fields('sin_nombre', 'sin_estado');
            $crud->field_type('sin_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('sin_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('sin_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->set_rules('sin_codigo', 'Código', 'trim|required|campo_unico[sin_sindicato.sin_codigo]');
            $crud->set_rules('sin_nombre', 'Nombre', 'trim|required|campo_unico[sin_sindicato.sin_nombre]');
            $crud->unset_delete();
            $crud->field_type('sin_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('sin_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('sin_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('sin_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->add_fields($add_columns);
            $crud->edit_fields($edit_columns);

            // AGREGAR EL CÓDIGO SEGÚN CORRELATIVO.
            $crud->callback_add_field('sin_codigo', function () {
                $tabla='sin_sindicato';
                $campo='sin_codigo';
                $last=$this->consultas->get_max_codigo($tabla, $campo);
                $code=$last->codigo;
                $cod= (int)$code+1;
                $codigo = str_pad($cod, 6, '0', STR_PAD_LEFT);
                return '<input id="field-sin_codigo" name="sin_codigo" type="text" maxlength="99" value="'.$codigo.'" >';
            });


            $crud->callback_edit_field('sin_codigo', function ($value, $primary_key) {
                if($value==''){
                    $tabla='sin_sindicato';
                    $campo='sin_codigo';
                    $last=$this->consultas->get_max_codigo($tabla, $campo);

                    $code=$last->codigo;
                    $cod= (int)$code+1;
                    $codigo = str_pad($cod, 6, '0', STR_PAD_LEFT);
                    return '<input id="field-sin_codigo" name="sin_codigo" type="text" maxlength="99" value="'.$codigo.'" >';
                }else{
                    return '<input id="field-sin_codigo" name="sin_codigo" type="text" maxlength="99" value="'.$value.'" >';
                }
            });

            $state = $crud->getState();
            if($state== 'success'){
                $crud->callback_field('sin_codigo', function ($value, $primary_key) {
                    if($value==''){
                        $tabla='sin_sindicato';
                        $campo='sin_codigo';
                        $last=$this->consultas->get_max_codigo($tabla,$campo);

                        $code=$last->codigo;
                        $cod= (int)$code+1;
                        $codigo = str_pad($cod, 6, '0', STR_PAD_LEFT);
                        return '<input id="field-sin_codigo" name="sin_codigo" type="text" readonly maxlength="99" value="'.$codigo.'" >';
                    }else{
                        return '<input id="field-sin_codigo" name="sin_codigo" type="text" readonly maxlength="99" value="'.$value.'" >';
                    }
                });
            }

            $urlx= explode('/', uri_string());
            if (end($urlx) == 'add') {
                $crud->field_type('sin_estado', 'hidden', 1);
            } else {  // Editar
                $crud->field_type('sin_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            $data['titulo_personal'] = "Sindicatos";

            $output = $crud->render();
            $this->_cargarvista($data, $output);
        }
    }
 
}
