<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Procesos extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->library('grocery_CRUD');
        $this->load->library('tank_auth');
        $this->load->model('gsatelite');
        $this->load->model('planilla_model');
        $this->load->model('personal_model');
        $this->load->model('accion_personal_model');
        $this->load->model('estructura_organizativa_model');
    }

    /**
     * @author René Castaneda / Luis Navarro (proceso de compartir funcionalidad 26-12-2017)
     * @return Mantenimiento are_area
     * Descricion: funcionalidad compartida en: expediente_personal/catalogos (funcion: area_empresa )
     */
    public function index($ruta = null) {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();

        $id_usuario = $this->tank_auth->get_user_id();
        $id_empresa = $this->tank_auth->get_empresa_id();
        $ruta = (trim($ruta) != '') ? $ruta : 'estructura_organizativa/procesos';
        $nivel = $this->db->select("IFNULL(MAX(are_area.are_nivel),1) AS ultimo_nivel", false)->from("are_area")->get()->row_array();
        $es_alcaldia = (substr_count(mb_strtolower($this->gsatelite->get_parametro_emp('SYS_EMPRESA'),'UTF-8'),'municipal') > 0) ? 1 : 0;
        $idno = 0;
        $nN = $nivel['ultimo_nivel']; //ultimo nivel
        $arreglo = explode('/', uri_string());
        if (is_numeric(end($arreglo))) {
            $idno = end($arreglo);
            $pregunta = $this->gsatelite->get_tabla('are_area', array('are_id' => $idno));
            $nN = $pregunta[0]['are_nivel'];
            if (!$nN) {
                $nN = 1;
            }
        }
        $crud = new grocery_CRUD();
        $url_actual = uri_string();
        $data['aplica_filtro'] = false; //EL CAMPO ESTA EN DESUSO EN EL CRUD
        $data['mandar_alerta'] = false;
        $nivel_seleccionado = null;
        if (substr_count($url_actual, 'add') > 0 || substr_count($url_actual, 'edit') > 0 || substr_count($url_actual, 'read') > 0 ) {
           $data['aplica_filtro'] = false;
        }
        if (substr_count($url_actual, 'success') > 0) {
           $data['mandar_alerta'] = true;
        }
        if ($this->input->post()) {
            if ( $this->input->post('slcNivel') > 0 ) {
                $nivel_seleccionado = $this->input->post('slcNivel');
                $crud->where(array('are_area.are_id_nia'=>$this->input->post('slcNivel')));
            }
        } else {
            $crud->where(array('are_area.are_estado >= '=> 0));
        }
        if ($es_alcaldia > 0) {
            $add = array(
                'are_nombre',
                'are_nivel',
                'are_padre',
                'are_descripcion',
                'are_prefijo',
                'are_referencia',
                'are_es_staff',
                'are_orden',
                'are_id_cec',
                'are_estado',
                'are_usu_modificacion',
                'are_fecha_modificacion',
                'are_usu_creacion',
                'are_fecha_creacion',
                'are_id_emr'
            );
            $edit = array(
                'are_nombre',
                'are_nivel',
                'are_padre',
                'are_descripcion',
                'are_prefijo',
                'are_referencia',
                'are_es_staff',
                'are_orden',
                'are_id_cec',
                'are_estado',
                'are_usu_modificacion',
                'are_fecha_modificacion'
            );
        } 
        else {
            
            $add = array(
                'are_nombre',
                'are_nivel',
                'are_padre',
                'are_descripcion',
                'are_prefijo',
                'are_referencia',
                'are_es_staff',
                'are_orden',
                'are_id_suc',
                'are_estado',
                'are_usu_modificacion',
                'are_fecha_modificacion',
                'are_usu_creacion',
                'are_fecha_creacion',
                'are_id_emr'
            );
            $edit = array(
                'are_nombre',
                'are_nivel',
                'are_padre',
                'are_descripcion',
                'are_prefijo',
                'are_referencia',
                'are_es_staff',
                'are_orden',
                'are_id_suc',
                'are_estado',
                'are_usu_modificacion',
                'are_fecha_modificacion'
            );
        }
        $display_as = array(
            'are_nombre' => 'Nombre',
            'are_estado' => 'Estado',
            'are_padre' => 'Dependencia',
            'are_descripcion' => 'Descripción',
            'are_prefijo' => 'Prefijo',
            'are_referencia' => 'Referencia',
            'are_id' => 'Código',
            'are_id_suc' => 'Sucursal',
            'are_orden' => 'Orden Organigrama',
            'are_es_staff' => 'Es Staff',
        );
        if ($es_alcaldia > 0) {
            $display_as['are_id_cec'] = 'Línea';
        }
        if (substr_count($url_actual, 'print') > 0 || substr_count($url_actual, 'export') > 0) {
            $columns = array(
                'are_id',
                'are_prefijo', 
                'are_nombre', 
                'are_padre', 
                'are_id_suc',
                'are_estado'
            );
        } else {
            if ($es_alcaldia > 0) {
                $columns = array(
                    'are_nivel',
                    'are_id',
                    'are_nombre', 
                    'are_padre', 
                    'are_id_cec',
                    'are_estado'
                );
            } else {
                $columns = array(
                    'are_nivel',
                    'are_id',
                    'are_prefijo', 
                    'are_nombre', 
                    'are_padre', 
                    'are_estado',
                    'are_id_suc',
                    'are_orden'
                );
            }
        }
        $crud->set_table('are_area')
                ->set_subject('área')
                ->columns($columns)
        ;
        if (in_array('edit', $arreglo)) {
            $crud->set_relation('are_padre', 'are_area', '{are_nombre} - (Nivel {are_nivel})', array('are_estado' => 1, 'are_nivel <' => $nN, 'are_id !=' => $idno,"are_id IN (SELECT mxr_id_are FROM mxr_empresaxarea WHERE mxr_id_emr = $id_empresa) "=> null), 'are_nivel');
        } else if (in_array('add', $arreglo)){
            $crud->set_relation('are_padre', 'are_area', '{are_nombre} - (Nivel {are_nivel})', array('are_estado' => 1, 'are_nivel <=' => $nN, 'are_id !=' => $idno,"are_id IN (SELECT mxr_id_are FROM mxr_empresaxarea WHERE mxr_id_emr = $id_empresa) "=> null), 'are_nivel')
                ->field_type('are_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('are_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
        }else {
             $crud->set_relation('are_padre', 'are_area', '{are_nombre}', array('are_estado' => 1, 'are_nivel <=' => $nN, 'are_id !=' => $idno));
        }
        $crud->set_relation('are_id_suc','suc_sucursal','{suc_codigo} - {suc_nombre}');
        $auditoria_empresa = array(
            'mxr_estado' => 1,
            'mxr_usu_creacion' => $this->tank_auth->get_user_id(),
            'mxr_usu_modificacion' => $this->tank_auth->get_user_id(),
            'mxr_fecha_modificacion' => date('Y-m-d H:i:s'),
            'mxr_fecha_creacion' => date('Y-m-d H:i:s')
        );

        $crud->display_as($display_as)
                ->add_fields($add)
                ->edit_fields($edit)
                ->required_fields('are_nombre', 'are_nivel', 'are_es_staff', 'are_estado', 'are_usu_modificacion', 'are_fecha_modificacion')//,'are_id_nia','empresas'
                ->field_type('are_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('are_id_emr', 'hidden', $this->tank_auth->get_empresa_id())
                ->field_type('are_nivel', 'hidden')
                ->field_type('are_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
                ->field_type('are_es_staff', 'dropdown', array('1' => 'Sí', '0' => 'No'))
                ->callback_edit_field('are_padre', function($value, $primary_key){
                    $idno = 0;
                    $nivel = $this->db->select("IFNULL(MAX(are_area.are_nivel),1) AS ultimo_nivel", false)->from("are_area")->get()->row_array();
                    $nN = $nivel['ultimo_nivel']; //ultimo nivel
                    $arreglo = explode('/', uri_string());
                    if (is_numeric(end($arreglo))) {
                        $idno = end($arreglo);
                        //, 'are_area.are_id_emr'=> $this->tank_auth->get_empresa_id()
                        $pregunta = $this->gsatelite->get_tabla('are_area', array('are_id' => $idno));
                        $nN = $pregunta[0]['are_nivel'];
                        if (!$nN) {
                            $nN = 1;
                        }
                    }                    
                    $padre = $this->gsatelite->get_campo('are_area', 'are_padre', array('are_id'=>$primary_key));
                    // $get_hijos=$this->gsatelite->get_tabla('are_area', array('are_padre'=>$primary_key));
                    if($padre != null && $padre > 0){//si posee padre se muestran niveles menores o igual
                        //, 'are_area.are_id_emr'=> $this->tank_auth->get_empresa_id()
                        $this->db->join('mxr_empresaxarea', 'mxr_id_are = are_id');
                        $datosArea = $this->gsatelite->get_tabla('are_area', array('are_estado'=> 1, 'are_nivel <='=> $nN, 'are_id !='=> $idno, 'mxr_id_emr' => $this->tank_auth->get_empresa_id()));
                    }else{
                        $sons = $this->get_niveles_hijos($idno);
                        $lvls = (trim($sons) != "") ? trim($sons,',') : 0;
                        $this->db->join('mxr_empresaxarea', 'mxr_id_are = are_id');
                        $datosArea = $this->gsatelite->get_tabla("are_area", array("are_estado"=>1,"are_id !="=>$idno,"are_id NOT IN ($lvls)"=>null,"mxr_id_emr"=>$this->tank_auth->get_empresa_id()));
                    }
                    $select_areas = '<select id="field-are_padre" class="nostyle chosen-select" style="width: 100%;" data-placeholder=" Dependencia" size="8" name="are_padre"><option value="" selected></option>';                     
                    foreach ($datosArea as $fila) {
                        if($padre==$fila['are_id']) {   
                            $select_areas .= '<option value="' . $fila['are_id'] . '" selected >' . $fila['are_nombre'].'</option>'; 
                        } else {  
                            $select_areas .= '<option value="' . $fila['are_id'] . '">' . $fila['are_nombre'] .  '</option>'; 
                        }                        
                    }
                    $select_areas .= '</select>';                    
                    return $select_areas;
                })
                ->callback_before_delete(array($this,'delete_mxr'));
                // ->set_relation_n_n('empresas', 'mxr_empresaxarea', 'emr_empresa', 'mxr_id_are', 'mxr_id_emr', 'emr_nombre', null, array('emr_estado' => 1, "emr_id in ( SELECT uxe_id_emr FROM uxe_usuarioxempresa WHERE uxe_id_usu = $id_usuario)" => null),$auditoria_empresa)
        ;
        if ($es_alcaldia > 0) {
            $crud->set_relation('are_id_cec', 'cec_centro_costo', '{cec_codigo} {cec_nombre}', array('cec_estado' => 1), 'cec_codigo');
        } 
        $crud->callback_after_update(function($post_array, $primary_key) {
            //actualizamos nivel de los hijos
            $niveles = $this->get_niveles_hijos($primary_key);
            $array_niveles = (trim($niveles) != "") ? explode(',', trim($niveles,',')) : array();
            if (count($array_niveles) > 0) {
                foreach ($array_niveles as $key => $value) {
                    $padre = $this->gsatelite->get_campo('are_area', 'are_padre', array('are_id' => $value));
                    $nivel = $this->gsatelite->get_campo('are_area', 'are_nivel', array('are_id' => $padre));
                    $this->gsatelite->actualizar('are_area', array('are_nivel' => ($nivel+1)), 'are_id', $value);
                }
            }
        });
        if (in_array('estructura_organizativa', $arreglo) && in_array('procesos', $arreglo)) {
            $crud->add_action('Organigrama', '', 'estructura_organizativa/consultas/ver_organigrama', 'icomoon-icon-tree-view ver_en_modal')
            ->add_action('Org. Área-Plazas', '', 'estructura_organizativa/consultas/ver_organigrama_area_plaza', 'icomoon-icon-tree-view ver_en_modal', function($primary_key, $row){
                return base_url('estructura_organizativa/consultas/ver_organigrama/'.$primary_key.'/no/1');
            });
        }
        $urlx = explode('/', uri_string());
        if (end($urlx) == 'add') {
            $crud->field_type('are_estado', 'hidden', 1);
        } else {
            $crud->field_type('are_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }
        if(!$permisos["permite_editar"]){
            $crud->unset_edit();
        }
        if(!$permisos["permite_eliminar"]){
            $crud->unset_delete();
        }
        if(!$permisos["permite_agregar"]){
            $crud->unset_add();
        }
        if(!$permisos["permite_ver"]){
            $crud->unset_read();
        } 
        $data['slcNivel'] =  $this->gsatelite->get_dropdown('nia_nivel_area', '{nia_nombre}','', array('nia_estado' => 1 ), $nivel_seleccionado, '', 'nia_id', true);
        $data['titulo_personal'] = "Áreas";
        //Added by René Castaneda 01-03-2018
        //actualizar al id de empresa según la sessión del usuario (dado que es un cambio nuevo)
        $this->gsatelite->actualizar_empresa_id('are_area');
        //condicionar empresa segun sessión del usuario
        $crud->where("are_area.are_id IN (SELECT mxr_id_are FROM mxr_empresaxarea WHERE mxr_id_emr = $id_empresa)", null);
        if (substr_count($url_actual, 'print') > 0 || substr_count($url_actual, 'export') > 0) {
            $this->db->order_by("are_nivel ASC");
        }
        $output = $crud->render();
        // $this->_cargarvista($data, $output);
        cargarvista($data, $output, 'estructura_organizativa/procesos/index');
    }

    public function get_niveles_hijos($id_padre=null){
        $cadena_ids = "";
        $q = $this->gsatelite->get_tabla('are_area', array('are_estado' => 1, 'are_id_emr' => $this->tank_auth->get_empresa_id(), 'are_padre' => $id_padre));
        if ($q){
            foreach ($q as $fila) {
                $cadena_ids .= $fila['are_id'] . ',';
                $cadena_ids .= $this->get_niveles_hijos($fila['are_id']);
            }
        }
        return $cadena_ids;
    }

    public function delete_mxr($primary_key) {
        $this->db->where('mxr_id_are', $primary_key);
        $this->db->delete('mxr_empresaxarea');
        return true;
    }

    function verificar_nivel() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $id = $this->input->post('id');
            if ($id > 0) {
                $pregunta = $this->gsatelite->get_tabla('are_area', array('are_id' => $id));
                //nivel hijo
                $nivel = $pregunta[0]['are_nivel'] + 1;
                echo json_encode(array('nivel' => $nivel));
            }
        }
    }

    /**
     * @author René Castaneda
     * @return Mantenimiento plz_plaza
     * descripción: Esta función se encuentra compartida en expediente personal e inventario
     */
    function plazas() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            try {
                $permisos = $this->gsatelite->get_permisos_opcion();
                $ruta_modulo = $permisos['modulo'].'/'.$permisos['control'];
                $idno = 0;
                $estado = "";
                $arreglo = explode('/', uri_string());
                if (is_numeric(end($arreglo))) {
                    $idno = end($arreglo);
                }
                $columns = array(
                    'plz_id',
                    'plz_nombre',
                    'plz_id_padre',
                    // 'plz_id_pto',
                    'empleado',
                    'plz_id_are',
                    'plz_estado'
                );
                $display_as = array(
                    'plz_id' => 'Código',
                    'plz_nombre' => 'Nombre',
                    'plz_estado' => 'Estado',
                    'plz_horario' => 'Horario',
                    // 'plz_id_pto' => 'Puesto',
                    'plz_id_are' => 'Área',
                    'plz_id_cec' => 'Centro Costos',
                    'plz_id_padre' => 'Dependencia',
                    'empleado' => 'Empleado Asignado',
                );
                $url_actual = uri_string();
                $data['aplica_filtro'] = true;
                if (substr_count($url_actual, 'add') > 0 || substr_count($url_actual, 'edit') > 0 || substr_count($url_actual, 'read') > 0 ) {
                   $data['aplica_filtro'] = false;
                }
                // Condicion
                $where = null;
                $crud = new grocery_CRUD();
                $area_seleccionada = null;
                if ($this->input->post()) {
                    $state = $this->input->post('hdn_chk_estado');
                    $estado = $state;
                    if ( $this->input->post('slcArea') > 0 ) {
                        $area_seleccionada = $this->input->post('slcArea');
                        $crud->where(array('plz_plaza.plz_id_are' => $this->input->post('slcArea'), 'plz_plaza.plz_estado' => $state));
                    } else {
                        $crud->where(array('plz_plaza.plz_estado' => $state));
                    }
                } else {
                    $crud->where(array('plz_plaza.plz_estado' => 1));
                }
                $crud->set_table('plz_plaza')
                        ->set_subject('Plazas / Cargos funcionales')
                        ->columns($columns)
                        ->set_relation('plz_id_cec', 'cec_centro_costo', '{cec_nombre}', array('cec_estado' => 1))
                        ->set_relation('plz_id_are', 'are_area', 'are_nombre', array('are_estado' => 1))
                        ->set_relation('plz_id_padre', 'plz_plaza', 'plz_nombre', array('plz_estado' => 1, 'plz_id !=' => $idno))
                        ->set_relation('plz_id_pto', 'pto_puesto', 'pto_nombre', array('pto_estado' => 1))
                        ->display_as($display_as)
                        ->fields('plz_nombre', 'plz_id_padre', 'plz_id_pto', 'plz_id_are', 'plz_salario_base', 'plz_id_cec', 'plz_horario', 'plz_estado', 'plz_usu_mod', 'plz_fecha_mod')
                        ->required_fields('plz_nombre', 'plz_id_are',  'plz_estado', 'plz_usu_mod', 'plz_fecha_mod')
                        ->set_rules('plz_nombre', 'Nombre', 'trim|required')
                        ->field_type('plz_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                        ->field_type('plz_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                ;
                $crud->callback_column('empleado', function ($value, $row) {
                    $CI = &get_instance();
                    if ($row->plz_estado > 0) {
                        $emps = $CI->gsatelite->get_tabla('emp_empleado', array('emp_id_plz' => $row->plz_id, 'emp_estado' => 1));
                        $nombre_empleado = (count($emps) == 1) ? $emps[0]['emp_nombre'] .' ' . $emps[0]['emp_apellido'] : "";
                        return $nombre_empleado;
                    } else {
                        return "";
                    }
                });

                $crud->add_action('Duplicar Registro', '', 'estructura_organizativa/procesos/duplicar_plaza', 'duplicar_plaza icomoon-icon-copy-2');
                //$crud->unset_delete();

                $urlx = explode('/', uri_string());
                if (end($urlx) == 'add') {
                    $crud->field_type('plz_estado', 'hidden', 1);
                } else {
                    $crud->field_type('plz_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
                }
                $data['titulo_personal'] = "Plazas / Cargos funcionales";
                $crud->callback_add_field('plz_horario', function () {
                    return '<textarea maxlength="200" value="" name="plz_horario"></textarea>';
                });
                $crud->unset_add();
                $crud->unset_edit();
                $crud->unset_read();
                // $crud->unset_delete()->unset_export()->unset_print();

                // Validaciones
                if ($permisos['permite_editar']) {
                    $crud->add_action('Editar', 'icon16 icomoon-icon-pencil-5', "$ruta_modulo/editar_plaza");
                }

                if (!$permisos['permite_eliminar']) {
                    $crud->unset_delete();
                }

                if ($permisos['permite_ver']) {
                    $crud->add_action('Ver', 'minia-icon-search', "$ruta_modulo/editar_plaza/1");
                }
                $id_empresa = $this->tank_auth->get_empresa_id();
                
                if ($permisos['modulo']=='estructura_organizativa') {
                    $crud->add_action('Organigrama Plazas', '', 'estructura_organizativa/consultas/ver_organigrama_plaza', 'icomoon-icon-tree-view ver_en_modal', null, "", "[plz_dibujar_organigrama]==1");
                    $crud->add_action('Org. Plaza-Empleada/o', '', 'estructura_organizativa/consultas/ver_organigrama_plaza_opc2', 'icomoon-icon-tree-view ver_en_modal', null, "", "[plz_dibujar_organigrama]==1");
                    $crud->add_action('Anexos', '', 'estructura_organizativa/procesos/anexos_plaza', 'icomoon-icon-stack');
                }

                $data['slcArea'] =  $this->gsatelite->get_dropdown('are_area', '{are_nombre}','', array('are_estado' => 1 ,"are_id IN (SELECT mxr_id_are FROM mxr_empresaxarea WHERE mxr_id_emr = $id_empresa)"=> null), $area_seleccionada, '', 'are_id', true);
                $data['permisos'] = $permisos;
                $data['estado'] = $estado;
                //Added by René Castaneda 01-03-2018
                //actualizar al id de empresa según la sessión del usuario (dado que es un cambio nuevo)
                //$this->gsatelite->actualizar_empresa_id('plz_plaza');
                //condicionar empresa segun sessión del usuario                
                $crud->where("plz_plaza.plz_id_are IN (SELECT mxr_id_are FROM mxr_empresaxarea WHERE mxr_id_emr = $id_empresa) ",null);
                $output = $crud->render();
                //$this->_cargarvista($data, $output);
                 cargarvista($data, $output, 'estructura_organizativa/procesos/plazas');
            } catch (Exception $e) {
                show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
            }
        }
    }

    /**
     * @author René Castaneda
     * @return Mantenimiento axp_anexoxplaza
     */
    function anexos_plaza($id = null) {
        satelite_validar();
        $this->gsatelite->verificar_registro_real('plz_plaza', $id);
        $crud = new grocery_CRUD();
        $this->load->config('grocery_crud');
        $this->config->set_item('grocery_crud_file_upload_allow_file_types', 'pdf|jpeg|jpg|png|doc|xls|ppt|docx|xlsx|pptx');

        $crud->set_table('axp_anexoxplaza')
                ->set_subject('Anexo Plaza / Cargo Funcional')
                ->where('axp_anexoxplaza.axp_id_plz', $id)
                ->columns('axp_id_plz', 'axp_nombre', 'axp_url', 'axp_estado')
                ->set_relation('axp_id_plz', 'plz_plaza', 'plz_nombre')
                ->edit_fields('axp_id_plz', 'axp_nombre', 'axp_url', 'axp_estado', 'axp_usu_creacion', 'axp_fecha_creacion', 'axp_usu_modificacion', 'axp_fecha_modificacion')
                ->edit_fields('axp_id_plz', 'axp_nombre', 'axp_url', 'axp_estado', 'axp_usu_modificacion', 'axp_fecha_modificacion')
                ->display_as('axp_id_plz', 'Plaza / Cargo Funcional')
                ->display_as('axp_nombre', 'Nombre')
                ->display_as('axp_url', 'Anexo')
                ->display_as('axp_estado', 'Estado')
                ->required_fields('axp_id_plz', 'axp_nombre', 'axp_url', 'axp_estado')
                ->set_rules('axp_nombre', 'Nombre', 'trim|required|campo_unico[axp_anexoxplaza.axp_nombre]')
                ->field_type('axp_id_plz', 'hidden', $id)
                ->field_type('axp_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('axp_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
                ->set_field_upload('axp_url', 'uploads/anx_plazas')
                ->unset_print()
                //->unset_delete()
                ->unset_export()
        ;
        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('axp_estado', 'hidden', 1);
            $crud->field_type('axp_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('axp_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
        } else {
            $crud->field_type('axp_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }
        $data['titulo_personal'] = "ANEXOS PLAZA / CARGO FUNCIONAL";
        $output = $crud->render();
        $this->_cargarvista($data, $output);
    }

    function _cargarvista($data = 0, $crud = 0) {
        $this->load->view('vacia', $crud);
        if ($data != 0)
            $data = array_merge($data, $this->masterpage->getUsuario());
        else
            $data = $this->masterpage->getUsuario();
        $vista = $data['modulo'] . '/' . $data['control'] . '/' . $data['funcion'];
        $this->masterpage->setMasterPage('masterpage_default');
        $this->masterpage->addContentPage($vista, 'content', $data);
        $this->masterpage->show();
    }

    public function registro_accionistas() {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();
        $crud = new grocery_CRUD;
        $alias = array(
            'acn_nombre'              => 'Accionista',
            'acn_porcentaje'          => 'Porcentaje de participación',
            'acn_estado'              => 'Estado',
            'acn_cantidad_acciones'   => 'Cantidad acciones',
            'acn_valor_contable'      => 'Valor contable',
            'acn_valor_nominal'       => 'Valor nominal',
            'acn_documento_dui'       => 'DUI',
            'acn_documento_nit'       => 'NIT'
        );

        $colums = array(
            'acn_nombre',
            'acn_porcentaje',
            'acn_cantidad_acciones',
            'acn_valor_contable',
            'acn_valor_nominal',
            'acn_documento_dui',
            'acn_documento_nit',
            'acn_estado'
        );

        $add = array(
            'acn_nombre',
            'acn_porcentaje',
            'acn_estado',
            'acn_id_emr',
            'acn_usu_creacion',
            'acn_fecha_creacion',
            'acn_usu_modificacion',
            'acn_fecha_modificacion',
            'acn_cantidad_acciones',
            'acn_valor_contable',
            'acn_valor_nominal',
            'acn_documento_dui',
            'acn_documento_nit'
        );
        $requeridos = array(
            'acn_nombre',
            'acn_porcentaje',
            'acn_estado'
        );
        $edit = array(
            'acn_nombre',
            'acn_porcentaje',
            'acn_estado',
            'acn_usu_modificacion',
            'acn_fecha_modificacion',
            'acn_cantidad_acciones',
            'acn_valor_contable',
            'acn_valor_nominal',
            'acn_documento_dui',
            'acn_documento_nit'
        );

        $crud->set_table('acn_accionista')
                ->set_subject('Accionistas')
                ->display_as($alias)
                ->columns($colums)
                ->add_fields($add)
                ->edit_fields($edit)
                ->required_fields($requeridos)
                ->field_type('acn_id_emr', 'hidden', $this->tank_auth->get_empresa_id())
                ->field_type('acn_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('acn_fecha_modificacion', 'hidden', date('Y-m-d h:i:s'))
                ->unset_print()
                ->unset_export()
        ;
        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('acn_estado', 'hidden', 1)
                    ->field_type('acn_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('acn_fecha_creacion', 'hidden', date('Y-m-d h:i:s'));
        } else {
            $crud->field_type('acn_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

        // $crud->callback_edit_field('acn_porcentaje', function ($value, $primary_key) {
        //     return '<input id="field-acn_porcentaje" name="acn_porcentaje" type="text" class="span12 soloDecimales text" value="'.$value.'" maxlength="19,2" extras="." autocomplete="off"><input type="hidden" id="actual" value="' . $value . '">';
        // });
        $crud->unset_edit();

        // Validaciones
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }

        if ($permisos['permite_editar']) {
            $crud->add_action('&nbsp;&nbsp;Editar', '', 'estructura_organizativa/procesos/editar_registro_accionistas', 'icon16 icomoon-icon-pencil-5');
        }

        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }

        if (!$permisos['permite_ver']) {
             $crud->unset_read();
        }

        //Added by René Castaneda 02-03-2018
        //actualizar al id de empresa según la sessión del usuario (dado que es un cambio nuevo)
        $this->gsatelite->actualizar_empresa_id('acn_accionista');
        //condicionar empresa segun sessión del usuario
        $crud->where('acn_id_emr', $this->tank_auth->get_empresa_id());

        $output = $crud->render();
        $data['titulo_personal'] = 'Registro de accionista';
        $this->_cargarvista($data, $output);
    }

    /**
     * @author Raul E
     * @return Mantenimiento Clon de registro de accionistas para clientes que no poseen accionistas sino junta directiva, por ejemplo UTE
     */
    public function registro_miembro_jd() {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();
        $crud = new grocery_CRUD;
        $alias = array(
            'mij_nombre'         => 'Miembro',
            'mij_estado'         => 'Estado',
            'mij_id_itt'         => 'Institución',
            'mij_periodo_inicio' => 'Período Desde',
            'mij_periodo_fin'    => 'Período Hasta'
        );
        $colums = array(
            'mij_nombre',
            'mij_id_itt',
            'mij_periodo_inicio',
            'mij_periodo_fin',
            'mij_estado'
        );
        $requeridos = array(
            'mij_nombre',
            'mij_estado'
        );
        $add = array(
            'mij_nombre',
            'mij_estado',
            'mij_id_emr',
            'mij_usu_creacion',
            'mij_fecha_creacion',
            'mij_usu_modificacion',
            'mij_fecha_modificacion',
            'mij_documento_dui',
            'mij_documento_nit'
        );        
        $edit = array(
            'mij_nombre',
            'mij_estado',
            'mij_usu_modificacion',
            'mij_fecha_modificacion',
            'mij_documento_dui',
            'mij_documento_nit'
        );
        $crud->set_table('mij_miembro_junta')
                ->set_subject('Miembros de CCSJ')
                ->display_as($alias)
                ->columns($colums)
                ->add_fields($add)
                ->edit_fields($edit)
                ->required_fields($requeridos)
                ->set_relation('mij_id_itt', 'itt_institucion', 'itt_nombre')
                ->field_type('mij_id_emr', 'hidden', $this->tank_auth->get_empresa_id())
                ->field_type('mij_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('mij_fecha_modificacion', 'hidden', date('Y-m-d h:i:s'))
                ->unset_print()
                ->unset_export()
        ;
        $crud->callback_column('mij_periodo_inicio', array($this, '_format_date'));
        $crud->callback_column('mij_periodo_fin', array($this, '_format_date'));
        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('mij_estado', 'hidden', 1)
                    ->field_type('mij_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('mij_fecha_creacion', 'hidden', date('Y-m-d h:i:s'));
        } else {
            $crud->field_type('mij_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }
        $crud->unset_edit();

        // Validaciones
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }

        if ($permisos['permite_editar']) {
            $crud->add_action('&nbsp;&nbsp;Editar', '', 'estructura_organizativa/procesos/editar_registro_miembros', 'icon16 icomoon-icon-pencil-5');
        }

        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }

        if (!$permisos['permite_ver']) {
             $crud->unset_read();
        }
        //actualizar al id de empresa según la sessión del usuario
        $this->gsatelite->actualizar_empresa_id('mij_miembro_junta');
        //condicionar empresa segun sessión del usuario
        $crud->where('mij_id_emr', $this->tank_auth->get_empresa_id());
        $output = $crud->render();
        $data['titulo_personal'] = 'Miembros de Junta Directiva';
        $data['url_grid'] = base_url('estructura_organizativa/procesos/registro_miembro_jd');
        $this->_cargarvista($data, $output);
    }

     function _format_date($valor) {
        $date = new DateTime($valor);
        return $date->format('d/m/Y');
    }

    /**
     * @internal Si el modulo es null esta siendo llamado por modulo propietario
     * @internal La ruta_modulo indica el modulo y controlador ejemplo modulo_ejemplo/ejemplo
     * descripción: Esta función se encuentra compartida en expediente personal e inventario
     */
    public function agregar_plaza($modulo = null, $ruta_modulo = null) {
        satelite_validar();
        if ($_POST) {
            $post_array = $_POST; 
            if(!$ruta_modulo){
                $ruta_modulo = $this->input->post('url');
            }else{
                $ruta_modulo = 'estructura_organizativa/procesos';
            }

            $txtNombre = $post_array['txtNombre'];
            $slcArea = ($post_array['slcArea'] != '') ? $post_array['slcArea'] : null;
            //$slcCentroCosto = ($post_array['slcCentroCosto'] != '') ? $post_array['slcCentroCosto'] : null;
            $slcDependencia = ($post_array['slcDependencia'] != '') ? $post_array['slcDependencia'] : null;

            $slcGenero = ($post_array['slcGenero'] != '') ? $post_array['slcGenero'] : null;
            $slcPuesto = ($post_array['slcPuesto'] != '') ? $post_array['slcPuesto'] : null;
            $slcNivelEduc = ($post_array['slcNivelEduc'] != '') ? $post_array['slcNivelEduc'] : null;
            $slcGradoAca = ($post_array['slcGradoAca'] != '') ? $post_array['slcGradoAca'] : null;
            $slcEdadMinima = ($post_array['slcEdadMinima'] != '') ? $post_array['slcEdadMinima'] : null;
            $slcEdadMaxima = ($post_array['slcEdadMaxima'] != '') ? $post_array['slcEdadMaxima'] : null;
            $txtAlcances = ($post_array['txtAlcances'] != '') ? $post_array['txtAlcances'] : null;
            $txtCompetencias = ($post_array['txtCompetencias'] != '') ? $post_array['txtCompetencias'] : null;
            $txtPlan = ($post_array['txtPlan'] != '') ? $post_array['txtPlan'] : null;
            $slcHorario = ($post_array['slcHorario'] != '') ? $post_array['slcHorario'] : null;
            $txtSalario = ($post_array['txtSalario'] != '') ? $post_array['txtSalario'] : null;
            $txtBonos = ($post_array['txtBonos'] != '') ? $post_array['txtBonos'] : null;
            $hdnPagoHorasExt = ($post_array['hdnPagoHorasExt'] != '') ? $post_array['hdnPagoHorasExt'] : null;
            $txtMejoraDesc = ($post_array['txtMejoraDesc'] != '') ? $post_array['txtMejoraDesc'] : null;
            $staff = ($post_array['chkStaff'] != '') ? 1 : null;
            $ubicacion = ($post_array['slcUbiPlaza'] > 0) ? $post_array['slcUbiPlaza'] : null;

            $organigrama = ( $post_array['slcOrganigrama'] != "" ) ? $post_array['slcOrganigrama'] : null;
            $inputUbicacion = ( $post_array['txtUbicacion'] != "" ) ? $post_array['txtUbicacion'] : null;

            $num_autoriza = ($post_array['txt_num_autoriza_prep'] != '') ? $post_array['txt_num_autoriza_prep'] : null;
            $num_resoluci = ($post_array['txt_num_resoluc_prep'] != '') ? $post_array['txt_num_resoluc_prep'] : null;
            $unidad_presp = ($post_array['slc_unid_presup'] > 0) ? $post_array['slc_unid_presup'] : null;
            $linea_trabaj = ($post_array['slc_linea_trabajo'] > 0) ? $post_array['slc_linea_trabajo'] : null;
            $pttda_presup = ($post_array['slc_ptda_presup'] > 0) ? $post_array['slc_ptda_presup'] : null;
            $sub_ptda_pre = ($post_array['slc_subptda_pre'] > 0) ? $post_array['slc_subptda_pre'] : null;
            $cifrado_prep = ($post_array['slc_cifrado_pre'] > 0) ? $post_array['slc_cifrado_pre'] : null;
            $formas_pagos = ($post_array['slc_forma_pagos'] != "") ? intval($post_array['slc_forma_pagos']) : null;


            $plaza_array = array(
                'plz_nombre' => $txtNombre,
                'plz_id_pto' => $slcPuesto,
                'plz_id_are' => $slcArea,
                // 'plz_id_org' => $organigrama,
                'plz_ubicacion_especifica' => $inputUbicacion,
                //'plz_id_cec' => $slcCentroCosto,
                'plz_id_padre' => $slcDependencia,
                'plz_edad_maxima' => $slcEdadMaxima,
                'plz_edad_minima' => $slcEdadMinima,
                'plz_id_tie' => $slcNivelEduc,
                //'plz_id_gen' => $slcGenero,
                //'plz_id_pro' => $slcGradoAca,
                'plz_id_tur' => $slcHorario,
                'plz_id_unp' => $unidad_presp,
                'plz_id_lnt' => $linea_trabaj,
                'plz_id_ppl' => $pttda_presup,
                'plz_id_spp' => $sub_ptda_pre,
                'plz_id_cip' => $cifrado_prep,
                'plz_forma_pagos' => $formas_pagos,
                'plz_numero_autorizacion' => $num_autoriza,
                'plz_numero_resolucion' => $num_resoluci,
                'plz_bono' => $txtBonos,
                'plz_pago_hora_extra' => $hdnPagoHorasExt,
                'plz_descripcion_mejora' => $txtMejoraDesc,
                'plz_salario_base' => $txtSalario,
                'plz_alcance_decision' => $txtAlcances,
                'plz_competencia_basica' => $txtCompetencias,
                'plz_plan_carrera' => $txtPlan,
                'plz_id_emr' => $this->tank_auth->get_empresa_id(),
                'plz_es_staff'=>$staff,
                'plz_dibujar_organigrama'=>($post_array['chkDibujar'] != '') ? 1 : null,
                'plz_id_ubp'=>$ubicacion,
                'plz_estado' => 1,
                'plz_usu_creacion' => $this->tank_auth->get_user_id(),
                'plz_fecha_creacion' => date('Y-m-d H:i:s'),
                'plz_usu_modificacion' => $this->tank_auth->get_user_id(),
                'plz_fecha_modificacion' => date('Y-m-d H:i:s')
            );

            //Se ingresa la plaza
            $plz_id = $this->gsatelite->ingresar('plz_plaza', $plaza_array);

            //Si la plaza se ingreso correctamente se procesan los demas registros
            if ($plz_id > 0) {

                //Se procesan los generos
                if (count($slcGenero) > 0) {
                    for ($i = 0; $i < count($slcGenero); $i++) {
                        $generos_array = array(
                            'gxp_id_gen' => $slcGenero[$i],
                            'gxp_id_plz' => $plz_id,
                            'gxp_estado' => 1,
                            'gxp_usu_creacion' => $this->tank_auth->get_user_id(),
                            'gxp_fecha_creacion' => date('Y-m-d H:i:s'),
                            'gxp_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'gxp_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('gxp_generoxplaza', $generos_array);
                    }
                }

                //Se procesan los grados academicos.
                if (count($slcGradoAca) > 0) {
                    for ($i = 0; $i < count($slcGradoAca); $i++) {
                        $grados_array = array(
                            'prp_id_pro' => $slcGradoAca[$i],
                            'prp_id_plz' => $plz_id,
                            'prp_estado' => 1,
                            'prp_usu_creacion' => $this->tank_auth->get_user_id(),
                            'prp_fecha_creacion' => date('Y-m-d H:i:s'),
                            'prp_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'prp_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('prp_profesion_plaza', $grados_array);
                    }
                }

                //Se procesan las funciones
                $slcFunciones = ($post_array['slcFunciones'] != '') ? $post_array['slcFunciones'] : null;

                if (count($slcFunciones) > 0) {
                    for ($i = 0; $i < count($slcFunciones); $i++) {
                        $funciones_array = array(
                            'fxl_id_fun' => $slcFunciones[$i],
                            'fxl_id_plz' => $plz_id,
                            'fxl_estado' => 1,
                            'fxl_usu_creacion' => $this->tank_auth->get_user_id(),
                            'fxl_fecha_creacion' => date('Y-m-d H:i:s'),
                            'fxl_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'fxl_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('fxl_funcionxplaza', $funciones_array);
                    }
                }

                //Se procesan las competencias por plaza
                $competencias = ($post_array['competencias'] != '') ? $post_array['competencias'] : null;
                $clasificaciones = ($post_array['clasificaciones'] != '') ? $post_array['clasificaciones'] : null;

                if (count($competencias) > 0) {
                    for ($i = 0; $i < count($competencias); $i++) {
                        $competencias_array = array(
                            'cpz_id_com' => $competencias[$i],
                            'cpz_id_cls' => $clasificaciones[$i],
                            'cpz_id_plz' => $plz_id,
                            'cpz_estado' => 1,
                            'cpz_usu_creacion' => $this->tank_auth->get_user_id(),
                            'cpz_fecha_creacion' => date('Y-m-d H:i:s'),
                            'cpz_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'cpz_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('cpz_competencia_plaza', $competencias_array);
                    }
                }

                //Se procesan los logros por plaza
                $areasResultado = ($post_array['areasResultado'] != '') ? $post_array['areasResultado'] : null;
                $areasResponsable = ($post_array['areasResponsable'] != '') ? $post_array['areasResponsable'] : null;
                $tiempoPorc = ($post_array['tiempoPorc'] != '') ? $post_array['tiempoPorc'] : null;
                if (count($areasResultado) > 0) {
                    for ($i = 0; $i < count($areasResultado); $i++) {
                        $logros_array = array(
                            'arp_id_are' => $areasResponsable[$i],
                            'arp_id_acl' => $areasResultado[$i],
                            'arp_id_pot' => $tiempoPorc[$i],
                            'arp_id_plz' => $plz_id,
                            'arp_estado' => 1,
                            'arp_usu_creacion' => $this->tank_auth->get_user_id(),
                            'arp_fecha_creacion' => date('Y-m-d H:i:s'),
                            'arp_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'arp_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('arp_area_resultadoxplaza', $logros_array);
                    }
                }

                //Se procesan los ambientes de trabajo
                $slcAmbientesTrab = ($post_array['slcAmbientesTrab'] != '') ? $post_array['slcAmbientesTrab'] : null;
                if (count($slcAmbientesTrab) > 0) {
                    for ($i = 0; $i < count($slcAmbientesTrab); $i++) {
                        $espacios_array = array(
                            'exp_id_ept' => $slcAmbientesTrab[$i],
                            'exp_id_plz' => $plz_id,
                            'exp_estado' => 1,
                            'exp_usu_creacion' => $this->tank_auth->get_user_id(),
                            'exp_fecha_creacion' => date('Y-m-d H:i:s'),
                            'exp_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'exp_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('exp_espacioxplaza', $espacios_array);
                    }
                }

                //Se procesan las herramientas de trabajo
                $slcHerramientasTrab = ($post_array['slcHerramientasTrab'] != '') ? $post_array['slcHerramientasTrab'] : null;
                if (count($slcHerramientasTrab) > 0) {
                    for ($i = 0; $i < count($slcHerramientasTrab); $i++) {
                        $herramientas_array = array(
                            'hxp_id_hrt' => $slcHerramientasTrab[$i],
                            'hxp_id_plz' => $plz_id,
                            'hxp_estado' => 1,
                            'hxp_usu_creacion' => $this->tank_auth->get_user_id(),
                            'hxp_fecha_creacion' => date('Y-m-d H:i:s'),
                            'hxp_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'hxp_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('hxp_herramientaxplaza', $herramientas_array);
                    }
                }

                //Se procesan los riesgos por plaza
                $tipos_riesgo = ($post_array['tipos_riesgo'] != '') ? $post_array['tipos_riesgo'] : null;
                $niveles_riesgo = ($post_array['niveles_riesgo'] != '') ? $post_array['niveles_riesgo'] : null;
                if (count($tipos_riesgo) > 0) {
                    for ($i = 0; $i < count($tipos_riesgo); $i++) {
                        $riesgos_array = array(
                            'rxl_id_tri' => $tipos_riesgo[$i],
                            'rxl_id_nir' => $niveles_riesgo[$i],
                            'rxl_id_plz' => $plz_id,
                            'rxl_estado' => 1,
                            'rxl_usu_creacion' => $this->tank_auth->get_user_id(),
                            'rxl_fecha_creacion' => date('Y-m-d H:i:s'),
                            'rxl_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'rxl_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('rxl_riesgoxplaza', $riesgos_array);
                    }
                }

                //Se procesan las prestaciones
                $slcPrestaciones = ($post_array['slcPrestaciones'] != '') ? $post_array['slcPrestaciones'] : null;
                if (count($slcPrestaciones) > 0) {
                    for ($i = 0; $i < count($slcPrestaciones); $i++) {
                        $prestaciones_array = array(
                            'pxz_id_prt' => $slcPrestaciones[$i],
                            'pxz_id_plz' => $plz_id,
                            'pxz_estado' => 1,
                            'pxz_usu_creacion' => $this->tank_auth->get_user_id(),
                            'pxz_fecha_creacion' => date('Y-m-d H:i:s'),
                            'pxz_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'pxz_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('pxz_prestacionxplaza', $prestaciones_array);
                    }
                }


                //Se agregan detalles de centro de costos
                $dcl_id_cec     = ($post_array['txt_centro_costo_finanza'] != '') ? $post_array['txt_centro_costo_finanza'] : null;
                $dcl_pocentaje  = ($post_array['txt_porcentaje_finanza'] != '') ? $post_array['txt_porcentaje_finanza'] : null;


                if (count($dcl_id_cec) > 0) {
                    foreach ( $dcl_id_cec as $key => $centro ){
                        $dcl_detalle_centro_costoxplaza = array(
                            'dcl_id_cec'            => $dcl_id_cec[$key],
                            'dcl_id_plz'            => $plz_id,
                            'dcl_porcentaje'        => $dcl_pocentaje[$key],
                            'dcl_estado'            => 1,
                            'dcl_usu_creacion'      => $this->tank_auth->get_user_id(),
                            'dcl_fecha_creacion'    => date('Y-m-d H:i:s'),
                            'dcl_usu_modificacion'  => $this->tank_auth->get_user_id(),
                            'dcl_fecha_modificacion'=> date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('dcl_detalle_centro_costoxplaza', $dcl_detalle_centro_costoxplaza);
                    }
                }

                //Se procesan los anexos
                $tituloAnexo = ($post_array['hdnPagoHorasExt'] != '') ? $post_array['titulo_doc'] : null;
                $nombreAnexo = ($post_array['hdnPagoHorasExt'] != '') ? $post_array['ruta'] : null;

                //Anexos
                if (count($nombreAnexo) > 0) {
                    for ($i = 0; $i < count($nombreAnexo); $i++) {

                        $extension = end(explode('.', $nombreAnexo[$i]));
                        $carpeta_temporal_anx = $ruta = "public/temp/anx_temporales/" . trim($nombreAnexo[$i]);

                        $nombreArchivo = trim($tituloAnexo[$i]) . "." . trim($extension);

                        $carpeta_destino_anx = "uploads/anx_plazas/" . $nombreArchivo;

                        $documentos_array = array(
                            'axp_id_plz' => $plz_id,
                            'axp_url' => $nombreArchivo,
                            'axp_nombre' => $tituloAnexo[$i],
                            'axp_estado' => 1,
                            'axp_usu_creacion' => $this->tank_auth->get_user_id(),
                            'axp_fecha_creacion' => date('Y-m-d H:i:s'),
                            'axp_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'axp_fecha_modificacion' => date('Y-m-d H:i:s'),
                        );

                        $nxp_id = $this->gsatelite->ingresar('axp_anexoxplaza', $documentos_array);

                        if ($nxp_id > 0) {
                            copy($carpeta_temporal_anx, $carpeta_destino_anx);
                            unlink($carpeta_temporal_anx);
                        }
                    }
                }

                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Plaza / Cargo Funcional", 'texto_alerta' => "Registro procesado correctamente.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "Hubó un problema al realizar la operación");
            }

            $tipo_btn = $post_array['btnGuardar'];

            $this->session->set_flashdata($alerta);
           
            if ($tipo_btn == 1) {
                redirect($ruta_modulo.'/agregar_plaza/');
            } else {
                redirect($ruta_modulo.'/plazas');
            }
        }

        $id_empresa = $this->tank_auth->get_empresa_id();

                         $this->db->join('mxr_empresaxarea', 'mxr_id_are = are_id');
                         $this->db->where('mxr_id_emr',$this->tank_auth->get_empresa_id());
                         $this->db->join('nia_nivel_area', 'are_id_nia = nia_id', 'left');
        $data['areas'] = $this->gsatelite->get_tabla('are_area', array('are_estado' => 1));
        // $data['areas'] = $this->gsatelite->get_dropdown('are_area', 'are_nombre', 'areas', array('are_estado' => 1, "are_id IN (SELECT mxr_id_are FROM mxr_empresaxarea WHERE mxr_id_emr = $id_empresa)"=> null), null, null, null, true);        
        // $data['areas_nivel'] = $this->estructura_organizativa_model->get_select_areas_niveles();

        $data['centros_costo'] = $this->gsatelite->get_dropdown('cec_centro_costo', 'cec_nombre', 'centros', array('cec_estado' => 1, 'cec_id_emr'=> $this->tank_auth->get_empresa_id()), null, null, null, true);
        $data['areaDepedencia'] = $this->gsatelite->get_dropdown('are_area', 'are_nombre', 'areas', array('are_estado' => 1, "are_id IN (SELECT mxr_id_are FROM mxr_empresaxarea WHERE mxr_id_emr = $id_empresa)"=> null), null, null, null, true);
        $data['funciones'] = $this->gsatelite->get_dropdown('fun_funcion', 'fun_nombre', 'Funciones', array('fun_estado' => 1), null, null, null, true);
        $data['generos'] = $this->gsatelite->get_dropdown('gen_genero', 'gen_nombre', 'Generos', null, null, null, null, true);
        $data['puestos'] = $this->gsatelite->get_dropdown('pto_puesto', 'pto_nombre', 'Puestos', array('pto_estado' => 1, "pto_id IN (SELECT mxp_id_pto FROM mxp_empresaxpuesto WHERE mxp_id_emr = $id_empresa)"=>null), null, null, null, true);
        $data['nivel_educativo'] = $this->gsatelite->get_dropdown('tie_tipo_educacion', 'tie_nombre', 'NivelesE', array('tie_estado' => 1), null, null, null, true);
        $data['grado_academico'] = $this->gsatelite->get_dropdown('pro_profesion', 'pro_nombre', 'GradoAca', array('pro_estado' => 1), null, null, null, true);
        $data['area_clave'] = $this->gsatelite->get_dropdown('acl_area_clave_resultado', 'acl_nombre', 'AreaClave', array('acl_estado' => 1), null, null, null, true);
        $data['porcentaje_tiempo'] = $this->gsatelite->get_dropdown('pot_porcentaje_tiempo', 'pot_porcentaje', 'Porcentaje', array('pot_estado' => 1), null, null, null, true);
        $data['competencias'] = $this->gsatelite->get_dropdown('com_competencia', 'com_nombre', 'Competencias', array('com_estado' => 1), null, null, null, true);
        $data['clasificaciones'] = $this->gsatelite->get_dropdown('cls_clasificacion', 'cls_nombre', 'Clasificaciones', array('cls_estado' => 1), null, null, null, true);
        $data['espacio_trabajo'] = $this->gsatelite->get_dropdown('ept_espacio_trabajo', 'ept_nombre', 'Espacios', array('ept_estado' => 1), null, null, null, true);
        $data['herramientas'] = $this->gsatelite->get_dropdown('hrt_herramienta_trabajo', 'hrt_nombre', 'Herramientas', array('hrt_estado' => 1), null, null, null, true);
        $data['tipo_riesgo'] = $this->gsatelite->get_dropdown('tri_tipo_riesgo', 'tri_nombre', 'TipoRiesgos', array('tri_estado' => 1), null, null, null, true);
        $data['nivel_riesgo'] = $this->gsatelite->get_dropdown('nir_nivel_riesgo', 'nir_nombre', 'NivelRiesgos', array('nir_estado' => 1), null, null, null, true);
        $data['horarios'] = $this->gsatelite->get_tabla('tur_turno', array('tur_estado' => 1));
        $data['prestaciones'] = $this->gsatelite->get_dropdown('prt_prestacion', 'prt_nombre', 'Prestaciones', array('prt_estado' => 1), null, null, null, true);
        $data['ubiplaza'] = $this->gsatelite->get_dropdown('ubp_ubicacion_plaza', 'ubp_nombre', 'Ubicaciones', array('ubp_estado' => 1), null, null, null, true);
        $data['organigrama'] = $this->gsatelite->get_dropdown('org_organigrama', 'org_nombre', 'Organigramas', array('org_estado' => 1), null, null, null, true);

        $data['unid_presup'] = $this->gsatelite->get_dropdown('unp_unidad_presupuestaria', 'unp_nombre', '', array('unp_estado' => 1), null, null, 'unp_id', true);
        $data['linea_trabj'] = $this->gsatelite->get_dropdown('lnt_linea_trabajo', 'lnt_nombre', '', array('lnt_estado' => 1), null, null, 'lnt_id', true);
        $data['partida_plz'] = $this->gsatelite->get_dropdown('ppl_partida_plaza', 'ppl_nombre', '', array('ppl_estado' => 1), null, null, 'ppl_id', true);
        $data['sub_ptda_pl'] = $this->gsatelite->get_dropdown('spp_subpartida_plaza', 'spp_nombre', '', array('spp_estado' => 1), null, null, 'spp_id', true);
        $data['cifr_presup'] = $this->gsatelite->get_dropdown('cip_cifrado_presupuestario', 'cip_nombre', '', array('cip_estado' => 1), null, null, 'cip_id', true);
        
                  $this->db->join('emp_empleado', 'emp_id_plz = plz_id', 'left');   
        $plazas = $this->gsatelite->get_dropdown('plz_plaza', "[concat_ws(' ', plz_nombre,'-',emp_nombre, emp_apellido)]", 'Plaza / Cargo Funcional', array('plz_estado' => 1, "plz_id_are IN (SELECT mxr_id_are FROM mxr_empresaxarea WHERE mxr_id_emr = $id_empresa)" => null), null, null, null, true);
        $plazas = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $plazas);
      
        $data['plazas'] = $plazas;
        //El parametro contiene (separado por /) la edad minima y maxima de una plaza
        $edades = $this->gsatelite->get_parametro('SYS_EDADES_PLAZAS');

        $edades_array = explode('/', $edades);

        $data['edad_minima'] = $edades_array[0];
        $data['edad_maxima'] = $edades_array[1];

        $data['titulo_personal'] = "Nueva Plaza / Cargo Funcional";
        
        //OBTENER RUTA
        $obtener_ruta = $this->gsatelite->get_valores_url();

        $data['url'] = $obtener_ruta['modulo'].'/'.$obtener_ruta['control'];
        if($modulo){ return $data; }
        
        cargarvista($data, null, 'estructura_organizativa/procesos/agregar_plaza');
   
    }

    //* descripción: Esta función se encuentra compartida en expediente personal e inventario
    public function editar_plaza($plz_id, $ver = null, $modulo = null, $ruta = null) {        
        satelite_validar();
        $id_empresa = $this->tank_auth->get_empresa_id();
        if ($_POST) {
            
            $ruta = $this->input->post('url');

            $post_array = $_POST;

            $txtNombre = $post_array['txtNombre'];
            $slcArea = ($post_array['slcArea'] != '') ? $post_array['slcArea'] : null;
            $slcCentroCosto = (isset($post_array['slcCentroCosto']) && $post_array['slcCentroCosto'] != '') ? $post_array['slcCentroCosto'] : null;
            $slcDependencia = ($post_array['slcDependencia'] != '') ? $post_array['slcDependencia'] : null;

            $slcGenero = (isset($post_array['slcGenero']) && $post_array['slcGenero'] != '') ? $post_array['slcGenero'] : null;
            $slcPuesto = ($post_array['slcPuesto'] != '') ? $post_array['slcPuesto'] : null;
            $slcNivelEduc = ($post_array['slcNivelEduc'] != '') ? $post_array['slcNivelEduc'] : null;
            $slcGradoAca = (isset($post_array['slcGradoAca']) && $post_array['slcGradoAca'] != '') ? $post_array['slcGradoAca'] : null;
            $slcEdadMinima = ($post_array['slcEdadMinima'] != '') ? $post_array['slcEdadMinima'] : null;
            $slcEdadMaxima = ($post_array['slcEdadMaxima'] != '') ? $post_array['slcEdadMaxima'] : null;
            $txtAlcances = ($post_array['txtAlcances'] != '') ? $post_array['txtAlcances'] : null;
            $txtCompetencias = ($post_array['txtCompetencias'] != '') ? $post_array['txtCompetencias'] : null;
            $txtPlan = ($post_array['txtPlan'] != '') ? $post_array['txtPlan'] : null;
            //$slcestado = ($post_array['slcestado'] != '') ? $post_array['slcestado'] : null;
            if($post_array['slcestado'] != ''){
                $slcestado = ($post_array['slcestado'] == '2') ? 0 : 1;
            } else{
                $slcestado = null;
            }

            $slcHorario = ($post_array['slcHorario'] != '') ? $post_array['slcHorario'] : null;
            $txtSalario = ($post_array['txtSalario'] != '') ? $post_array['txtSalario'] : null;
            $txtBonos = ($post_array['txtBonos'] != '') ? $post_array['txtBonos'] : null;
            $hdnPagoHorasExt = ($post_array['hdnPagoHorasExt'] != '') ? $post_array['hdnPagoHorasExt'] : null;
            $txtMejoraDesc = ($post_array['txtMejoraDesc'] != '') ? $post_array['txtMejoraDesc'] : null;
            $staff = ($post_array['chkStaff'] != '') ? 1 : null;
            $ubica = ($post_array['slcUbiPlaza'] > 0) ? $post_array['slcUbiPlaza'] : null;

            $organigrama = ( $post_array['slcOrganigrama'] != "" ) ? $post_array['slcOrganigrama'] : null;
            $inputUbicacion = ( $post_array['txtUbicacion'] != "" ) ? $post_array['txtUbicacion'] : null;

            $num_autoriza = ($post_array['txt_num_autoriza_prep'] != '') ? $post_array['txt_num_autoriza_prep'] : null;
            $num_resoluci = ($post_array['txt_num_resoluc_prep'] != '') ? $post_array['txt_num_resoluc_prep'] : null;
            $unidad_presp = ($post_array['slc_unid_presup'] > 0) ? $post_array['slc_unid_presup'] : null;
            $linea_trabaj = ($post_array['slc_linea_trabajo'] > 0) ? $post_array['slc_linea_trabajo'] : null;
            $pttda_presup = ($post_array['slc_ptda_presup'] > 0) ? $post_array['slc_ptda_presup'] : null;
            $sub_ptda_pre = ($post_array['slc_subptda_pre'] > 0) ? $post_array['slc_subptda_pre'] : null;
            $cifrado_prep = ($post_array['slc_cifrado_pre'] > 0) ? $post_array['slc_cifrado_pre'] : null;
            $formas_pagos = ($post_array['slc_forma_pagos'] != "") ? intval($post_array['slc_forma_pagos']) : null;

            $plaza_array = array(
                'plz_nombre' => $txtNombre,
                'plz_id_pto' => $slcPuesto,
                'plz_id_are' => $slcArea,
                'plz_id_cec' => $slcCentroCosto,
                'plz_id_padre' => $slcDependencia,
                'plz_edad_maxima' => $slcEdadMaxima,
                'plz_edad_minima' => $slcEdadMinima,
                'plz_id_tie' => $slcNivelEduc,

                // 'plz_id_org' => $organigrama,
                'plz_ubicacion_especifica' => $inputUbicacion,
                //'plz_id_gen' => $slcGenero,
                //'plz_id_pro' => $slcGradoAca,
                'plz_es_staff'=>$staff,
                'plz_dibujar_organigrama'=>($post_array['chkDibujar'] != '') ? 1 : null,
                'plz_id_tur' => $slcHorario,
                'plz_id_unp' => $unidad_presp,
                'plz_id_lnt' => $linea_trabaj,
                'plz_id_ppl' => $pttda_presup,
                'plz_id_spp' => $sub_ptda_pre,
                'plz_id_cip' => $cifrado_prep,
                'plz_forma_pagos' => $formas_pagos,
                'plz_numero_autorizacion' => $num_autoriza,
                'plz_numero_resolucion' => $num_resoluci,
                'plz_bono' => $txtBonos,
                'plz_pago_hora_extra' => $hdnPagoHorasExt,
                'plz_descripcion_mejora' => $txtMejoraDesc,
                'plz_salario_base' => $txtSalario,
                'plz_alcance_decision' => $txtAlcances,
                'plz_competencia_basica' => $txtCompetencias,
                'plz_plan_carrera' => $txtPlan,
                'plz_id_ubp'=>$ubica,
                'plz_estado' => $slcestado,
                'plz_usu_modificacion' => $this->tank_auth->get_user_id(),
                'plz_fecha_modificacion' => date('Y-m-d H:i:s')
            );

            //Se ingresa la plaza
            $resultado = $this->gsatelite->actualizar_array('plz_plaza', $plaza_array, array('plz_id' => $plz_id));

            //Si la plaza se ingreso correctamente se procesan los demas registros
            if ($resultado > 0) {

                //Se procesan los generos
                //Se eliminan los generos ya ingresados. para procesarlas nuevamente
                $this->gsatelite->borrado_general('gxp_generoxplaza', array('gxp_id_plz' => $plz_id));
                if (count($slcGenero) > 0) {
                    for ($i = 0; $i < count($slcGenero); $i++) {
                        $generos_array = array(
                            'gxp_id_gen' => $slcGenero[$i],
                            'gxp_id_plz' => $plz_id,
                            'gxp_estado' => 1,
                            'gxp_usu_creacion' => $this->tank_auth->get_user_id(),
                            'gxp_fecha_creacion' => date('Y-m-d H:i:s'),
                            'gxp_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'gxp_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('gxp_generoxplaza', $generos_array);
                    }
                }


                //Se procesan los generos
                //Se eliminan los generos ya ingresados. para procesarlas nuevamente
                $this->gsatelite->borrado_general('prp_profesion_plaza', array('prp_id_plz' => $plz_id));
                if (count($slcGradoAca) > 0) {
                    for ($i = 0; $i < count($slcGradoAca); $i++) {
                        $grados_array = array(
                            'prp_id_pro' => $slcGradoAca[$i],
                            'prp_id_plz' => $plz_id,
                            'prp_estado' => 1,
                            'prp_usu_creacion' => $this->tank_auth->get_user_id(),
                            'prp_fecha_creacion' => date('Y-m-d H:i:s'),
                            'prp_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'prp_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('prp_profesion_plaza', $grados_array);
                    }
                }


                //Se procesan las funciones
                //Se eliminan las funciones ya ingresadas. para procesarlas nuevamente
                $this->gsatelite->borrado_general('fxl_funcionxplaza', array('fxl_id_plz' => $plz_id));

                $slcFunciones = ($post_array['slcFunciones'] != '') ? $post_array['slcFunciones'] : null;

                if (count($slcFunciones) > 0) {
                    for ($i = 0; $i < count($slcFunciones); $i++) {
                        $funciones_array = array(
                            'fxl_id_fun' => $slcFunciones[$i],
                            'fxl_id_plz' => $plz_id,
                            'fxl_estado' => 1,
                            'fxl_usu_creacion' => $this->tank_auth->get_user_id(),
                            'fxl_fecha_creacion' => date('Y-m-d H:i:s'),
                            'fxl_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'fxl_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('fxl_funcionxplaza', $funciones_array);
                    }
                }

                //Se verifican las Competencias eliminadas de la pantalla contra las registradas
                $competenciasPlaza = $post_array['competenciasPlaza'];
                $competencias_plaza = $this->estructura_organizativa_model->get_competencias_plaza(array('cpz_id_plz' => $plz_id));
                $cpzIds = (count($competenciasPlaza) > 0) ? $competenciasPlaza : array();

                foreach ($competencias_plaza as $cpz) {
                    if (!in_array($cpz['cpz_id'], $cpzIds)) {
                        //Se eliminan las competencias, que no se encuentren
                        $this->gsatelite->borrado_general('cpz_competencia_plaza', array('cpz_id' => $cpz['cpz_id']));
                    }
                }

                //Se procesan las competencias por plaza
                $competencias = ($post_array['competencias'] != '') ? $post_array['competencias'] : null;
                $clasificaciones = ($post_array['clasificaciones'] != '') ? $post_array['clasificaciones'] : null;

                if (count($competencias) > 0) {
                    for ($i = 0; $i < count($competencias); $i++) {
                        $competencias_array = array(
                            'cpz_id_com' => $competencias[$i],
                            'cpz_id_cls' => $clasificaciones[$i],
                            'cpz_id_plz' => $plz_id,
                            'cpz_estado' => 1,
                            'cpz_usu_creacion' => $this->tank_auth->get_user_id(),
                            'cpz_fecha_creacion' => date('Y-m-d H:i:s'),
                            'cpz_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'cpz_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('cpz_competencia_plaza', $competencias_array);
                    }
                }


                //Se verifican los Logros eliminadas de la pantalla contra las registradas
                $logrosPlaza = $post_array['logrosPlaza'];
                $logros_plaza = $this->estructura_organizativa_model->get_logros_plaza(array('arp_id_plz' => $plz_id));
                $arpIds = (count($logrosPlaza) > 0) ? $logrosPlaza : array();

                foreach ($logros_plaza as $arp) {
                    if (!in_array($arp['arp_id'], $arpIds)) {
                        //Se eliminan los logros, que no se encuentren
                        $this->gsatelite->borrado_general('arp_area_resultadoxplaza', array('arp_id' => $arp['arp_id']));
                    }
                }

                //Se procesan los logros por plaza
                $areasResultado = ($post_array['areasResultado'] != '') ? $post_array['areasResultado'] : null;
                $areasResponsable = ($post_array['areasResponsable'] != '') ? $post_array['areasResponsable'] : null;
                $tiempoPorc = ($post_array['tiempoPorc'] != '') ? $post_array['tiempoPorc'] : null;
                if (count($areasResultado) > 0) {
                    for ($i = 0; $i < count($areasResultado); $i++) {
                        $logros_array = array(
                            'arp_id_are' => $areasResponsable[$i],
                            'arp_id_acl' => $areasResultado[$i],
                            'arp_id_pot' => $tiempoPorc[$i],
                            'arp_id_plz' => $plz_id,
                            'arp_estado' => 1,
                            'arp_usu_creacion' => $this->tank_auth->get_user_id(),
                            'arp_fecha_creacion' => date('Y-m-d H:i:s'),
                            'arp_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'arp_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('arp_area_resultadoxplaza', $logros_array);
                    }
                }

                //Se eliminan los espacios ya ingresados. para procesarlas nuevamente
                $this->gsatelite->borrado_general('exp_espacioxplaza', array('exp_id_plz' => $plz_id));
                //Se procesan los ambientes de trabajo
                $slcAmbientesTrab = ($post_array['slcAmbientesTrab'] != '') ? $post_array['slcAmbientesTrab'] : null;
                if (count($slcAmbientesTrab) > 0) {
                    for ($i = 0; $i < count($slcAmbientesTrab); $i++) {
                        $espacios_array = array(
                            'exp_id_ept' => $slcAmbientesTrab[$i],
                            'exp_id_plz' => $plz_id,
                            'exp_estado' => 1,
                            'exp_usu_creacion' => $this->tank_auth->get_user_id(),
                            'exp_fecha_creacion' => date('Y-m-d H:i:s'),
                            'exp_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'exp_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('exp_espacioxplaza', $espacios_array);
                    }
                }

                //Se eliminan las herramientas ya ingresadas. para procesarlas nuevamente
                $this->gsatelite->borrado_general('hxp_herramientaxplaza', array('hxp_id_plz' => $plz_id));
                //Se procesan las herramientas de trabajo
                $slcHerramientasTrab = ($post_array['slcHerramientasTrab'] != '') ? $post_array['slcHerramientasTrab'] : null;
                if (count($slcHerramientasTrab) > 0) {
                    for ($i = 0; $i < count($slcHerramientasTrab); $i++) {
                        $herramientas_array = array(
                            'hxp_id_hrt' => $slcHerramientasTrab[$i],
                            'hxp_id_plz' => $plz_id,
                            'hxp_estado' => 1,
                            'hxp_usu_creacion' => $this->tank_auth->get_user_id(),
                            'hxp_fecha_creacion' => date('Y-m-d H:i:s'),
                            'hxp_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'hxp_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('hxp_herramientaxplaza', $herramientas_array);
                    }
                }

                //Se verifican los Riesgos eliminados de la pantalla contra las registradas
                $riesgosPlaza = $post_array['riesgosPlaza'];
                $riesgos_plaza = $this->estructura_organizativa_model->get_riesgos_plaza(array('rxl_id_plz' => $plz_id));
                $rxlIds = (count($riesgosPlaza) > 0) ? $riesgosPlaza : array();

                foreach ($riesgos_plaza as $rxl) {
                    if (!in_array($rxl['rxl_id'], $rxlIds)) {
                        //Se eliminan los riesgos, que no se encuentren
                        $this->gsatelite->borrado_general('rxl_id_plz', array('rxl_id' => $rxl['rxl_id']));
                    }
                }

                //Se procesan los riesgos por plaza
                $tipos_riesgo = ($post_array['tipos_riesgo'] != '') ? $post_array['tipos_riesgo'] : null;
                $niveles_riesgo = ($post_array['niveles_riesgo'] != '') ? $post_array['niveles_riesgo'] : null;
                if (count($tipos_riesgo) > 0) {
                    for ($i = 0; $i < count($tipos_riesgo); $i++) {
                        $riesgos_array = array(
                            'rxl_id_tri' => $tipos_riesgo[$i],
                            'rxl_id_nir' => $niveles_riesgo[$i],
                            'rxl_id_plz' => $plz_id,
                            'rxl_estado' => 1,
                            'rxl_usu_creacion' => $this->tank_auth->get_user_id(),
                            'rxl_fecha_creacion' => date('Y-m-d H:i:s'),
                            'rxl_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'rxl_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('rxl_riesgoxplaza', $riesgos_array);
                    }
                }

                //Se procesan las prestaciones
                $slcPrestaciones = ($post_array['slcPrestaciones'] != '') ? $post_array['slcPrestaciones'] : null;
                if (count($slcPrestaciones) > 0) {
                    for ($i = 0; $i < count($slcPrestaciones); $i++) {
                        $prestaciones_array = array(
                            'pxz_id_prt' => $slcPrestaciones[$i],
                            'pxz_id_plz' => $plz_id,
                            'pxz_estado' => 1,
                            'pxz_usu_creacion' => $this->tank_auth->get_user_id(),
                            'pxz_fecha_creacion' => date('Y-m-d H:i:s'),
                            'pxz_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'pxz_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('pxz_prestacionxplaza', $prestaciones_array);
                    }
                }

                //Se agregan detalles de centro de costos
                $dcl_id_cec     = ($post_array['txt_centro_costo_finanza'] != '') ? $post_array['txt_centro_costo_finanza'] : null;
                $dcl_pocentaje  = ($post_array['txt_porcentaje_finanza'] != '') ? $post_array['txt_porcentaje_finanza'] : null;
                $detales_nuevos = ($post_array['txt_centro_costo_new'] != '') ? $post_array['txt_centro_costo_new'] : null;

                //obtener los detalles antiguos
                $detalles_centros = $this->gsatelite->get_tabla('dcl_detalle_centro_costoxplaza', array('dcl_id_plz' => $plz_id));
                //eliminacion de detalles que no existen 
                if (count($detalles_centros) > 0) {
                    $this->gsatelite->borrado_general('dcl_detalle_centro_costoxplaza', array('dcl_id_plz' => $plz_id));
                }

                if (count($dcl_id_cec) > 0) {
                    foreach ($dcl_id_cec as $key => $centro ){
                        $dcl_detalle_centro_costoxplaza = array(
                            'dcl_id_cec'            => $dcl_id_cec[$key],
                            'dcl_id_plz'            => $plz_id,
                            'dcl_porcentaje'        => $dcl_pocentaje[$key],
                            'dcl_estado'            => 1,
                            'dcl_usu_creacion'      => $this->tank_auth->get_user_id(),
                            'dcl_fecha_creacion'    => date('Y-m-d H:i:s'),
                            'dcl_usu_modificacion'  => $this->tank_auth->get_user_id(),
                            'dcl_fecha_modificacion'=> date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('dcl_detalle_centro_costoxplaza', $dcl_detalle_centro_costoxplaza);
                    }
                }

                //Se verifican los Anexos eliminados de la pantalla contra las registradas
                $AnexoPlz = $post_array['AnexoPlz'];
                $anexos_plaza = $this->gsatelite->get_tabla('axp_anexoxplaza', array('axp_id_plz' => $plz_id));
                $axpIds = (count($AnexoPlz) > 0) ? $AnexoPlz : array();
                foreach ($anexos_plaza as $axp) {
                    if (!in_array($axp['axp_id'], $axpIds)) {
                        //Se eliminan los anexos, que no se encuentren
                        $this->gsatelite->borrado_general('axp_anexoxplaza', array('axp_id' => $axp['axp_id']));

                        unlink($axp['axp_url']);
                    }
                }

                //Se procesan los anexos
                $tituloAnexo = ($post_array['titulo_doc'] != '') ? $post_array['titulo_doc'] : null;
                $nombreAnexo = ($post_array['ruta'] != '') ? $post_array['ruta'] : null;

                //Anexos
                if (count($nombreAnexo) > 0) {
                    for ($i = 0; $i < count($nombreAnexo); $i++) {

                        $extension = end(explode('.', $nombreAnexo[$i]));
                        $carpeta_temporal_anx = $ruta = "public/temp/anx_temporales/" . trim($nombreAnexo[$i]);

                        $nombreArchivo = trim($tituloAnexo[$i]) . "." . strtolower(trim($extension));

                        $carpeta_destino_anx = "uploads/anx_plazas/" . $nombreArchivo;

                        $documentos_array = array(
                            'axp_id_plz' => $plz_id,
                            'axp_url' => $nombreArchivo,
                            'axp_nombre' => $tituloAnexo[$i],
                            'axp_estado' => 1,
                            'axp_usu_creacion' => $this->tank_auth->get_user_id(),
                            'axp_fecha_creacion' => date('Y-m-d H:i:s'),
                            'axp_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'axp_fecha_modificacion' => date('Y-m-d H:i:s'),
                        );

                        $nxp_id = $this->gsatelite->ingresar('axp_anexoxplaza', $documentos_array);

                        if ($nxp_id > 0) {
                            copy($carpeta_temporal_anx, $carpeta_destino_anx);
                            unlink($carpeta_temporal_anx);
                        }
                    }
                }

                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Plaza / Cargo Funcional", 'texto_alerta' => "Registro procesado correctamente.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "Hubó un problema al realizar la operación");
            }

            $tipo_btn = $post_array['btnGuardar'];

            $this->session->set_flashdata($alerta);            
            if ($tipo_btn == 1) {
                redirect($ruta.'/editar_plaza/' . $plz_id);
            } else {
                redirect($ruta.'/plazas');
            }
        }

        if ($ver != null) {
            $plz_id = $ver;
            $ver = 1;
        }

        $id_empresa = $this->tank_auth->get_empresa_id();
        //Se obtiene la información de la plaza
        $plaza_data = $this->gsatelite->get_tabla('plz_plaza', array('plz_id' => $plz_id));
        //Se obtienen los generos por plaza
        $generos_plaza = $this->gsatelite->get_tabla('gxp_generoxplaza', array('gxp_id_plz' => $plz_id));
        $gxpIds = (count($generos_plaza) > 0) ? array_column($generos_plaza, 'gxp_id_gen') : null;

        //Se obtienen los grados academicos por plaza
        $profesion_plaza = $this->gsatelite->get_tabla('prp_profesion_plaza', array('prp_id_plz' => $plz_id));
        $prpIds = (count($profesion_plaza) > 0) ? array_column($profesion_plaza, 'prp_id_pro') : null;

        //Se obtienen las funciones por plaza
        $funciones_plaza = $this->gsatelite->get_tabla('fxl_funcionxplaza', array('fxl_id_plz' => $plz_id));
        $fxlIds = (count($funciones_plaza) > 0) ? array_column($funciones_plaza, 'fxl_id_fun') : null;

        //Se obtienen los espacios por plaza
        $espacios_plaza = $this->gsatelite->get_tabla('exp_espacioxplaza', array('exp_id_plz' => $plz_id));
        $expIds = (count($espacios_plaza) > 0) ? array_column($espacios_plaza, 'exp_id_ept') : null;

        //Se obtienen las herramientas por plaza
        $herramientas_plaza = $this->gsatelite->get_tabla('hxp_herramientaxplaza', array('hxp_id_plz' => $plz_id));
        $hxpIds = (count($herramientas_plaza) > 0) ? array_column($herramientas_plaza, 'hxp_id_hrt') : null;

        //Se obtienen las prestaciones por plaza
        $prestaciones_plaza = $this->gsatelite->get_tabla('pxz_prestacionxplaza', array('pxz_id_plz' => $plz_id));
        $pxzIds = (count($prestaciones_plaza) > 0) ? array_column($prestaciones_plaza, 'pxz_id_prt') : null;

                         $this->db->join('mxr_empresaxarea', 'mxr_id_are = are_id');
                         $this->db->where('mxr_id_emr',$this->tank_auth->get_empresa_id());
                         $this->db->join('nia_nivel_area', 'are_id_nia = nia_id', 'left');
        $data['areas'] = $this->gsatelite->get_tabla('are_area', array('are_estado' => 1));
        // $data['areas'] = $this->gsatelite->get_dropdown('are_area', 'are_nombre', 'areas', array('are_estado' => 1, "are_id IN (SELECT mxr_id_are FROM mxr_empresaxarea WHERE mxr_id_emr = $id_empresa)"=> null),$plaza_data[0]['plz_id_are'], null, null, true);
        // $data['areas_nivel'] = $this->estructura_organizativa_model->get_select_areas_niveles($plaza_data[0]['plz_id_are']);

        $data['centros_costo'] = $this->gsatelite->get_dropdown('cec_centro_costo', 'cec_nombre', 'centros', array('cec_estado' => 1, 'cec_id_emr'=> $this->tank_auth->get_empresa_id()), $plaza_data[0]['plz_id_cec'], null, null, true);

        $plz_dependencia = null;
        if ($plaza_data[0]['plz_id_padre']>0) {
            $plaza_data_padre = $this->gsatelite->get_tabla('plz_plaza', array('plz_id' => $plaza_data[0]['plz_id_padre']));

                      $this->db->join('emp_empleado', 'emp_id_plz = plz_id','left');
            $plazas = $this->gsatelite->get_dropdown('plz_plaza', "[concat_ws(' ', plz_nombre,'-',emp_nombre, emp_apellido)]", 'Plaza / Cargo Funcional', array('plz_estado' => 1, "plz_id_are IN (SELECT mxr_id_are FROM mxr_empresaxarea WHERE mxr_id_emr = $id_empresa)"=> null, 'plz_id_are'=>$plaza_data_padre[0]['plz_id_are']), $plaza_data[0]['plz_id_padre'], null, null, true);
            $plazas = str_replace('<option value="0">Seleccione</option>', '', $plazas);
            $data['plazas'] = str_replace('<option value="0">Sin Registros</option>', '', $plazas);
            $plz_dependencia = ($plaza_data_padre[0]["plz_id_are"]>0)?$plaza_data_padre[0]["plz_id_are"]:null;
        }


                  $this->db->join('emp_empleado', 'emp_id_plz = plz_id','left');
        $plazas = $this->gsatelite->get_dropdown('plz_plaza', "[concat_ws(' ', plz_nombre,'-',emp_nombre, emp_apellido)]", 'Plaza / Cargo Funcional', array('plz_estado' => 1, "plz_id_are IN (SELECT mxr_id_are FROM mxr_empresaxarea WHERE mxr_id_emr = $id_empresa)"=> null), $plaza_data[0]['plz_id_padre'], null, null, true);
        $plazas = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $plazas);
        $data['plazas'] = str_replace('<option value="0">Sin Registros</option>', '', $plazas);


        $data['areaDepedencia'] = $this->gsatelite->get_dropdown('are_area', 'are_nombre', 'areas', array('are_estado' => 1, "are_id IN (SELECT mxr_id_are FROM mxr_empresaxarea WHERE mxr_id_emr = $id_empresa)"=> null), $plz_dependencia, null, null, true);

        $data['funciones'] = $this->gsatelite->get_dropdown('fun_funcion', 'fun_nombre', 'Funciones', array('fun_estado' => 1), $fxlIds, null, null, true);
        $data['generos'] = $this->gsatelite->get_dropdown('gen_genero', 'gen_nombre', 'Generos', null, $gxpIds, null, null, true);
        $data['puestos'] = $this->gsatelite->get_dropdown('pto_puesto', 'pto_nombre', 'Puestos', array('pto_estado' => 1, "pto_id IN (SELECT mxp_id_pto FROM mxp_empresaxpuesto WHERE mxp_id_emr = $id_empresa)"=>null), $plaza_data[0]['plz_id_pto'], null, null, true);
        $data['nivel_educativo'] = $this->gsatelite->get_dropdown('tie_tipo_educacion', 'tie_nombre', 'NivelesE', array('tie_estado' => 1), $plaza_data[0]['plz_id_tie'], null, null, true);
        $data['grado_academico'] = $this->gsatelite->get_dropdown('pro_profesion', 'pro_nombre', 'GradoAca', array('pro_estado' => 1), $prpIds, null, null, true);
        $data['area_clave'] = $this->gsatelite->get_dropdown('acl_area_clave_resultado', 'acl_nombre', 'AreaClave', array('acl_estado' => 1), null, null, null, true);
        $data['areas_responsables'] = $this->gsatelite->get_dropdown('are_area', 'are_nombre', 'areas', array('are_estado' => 1, "are_id IN (SELECT mxr_id_are FROM mxr_empresaxarea WHERE mxr_id_emr = $id_empresa)"=>null), null, null, null, true);
        $data['porcentaje_tiempo'] = $this->gsatelite->get_dropdown('pot_porcentaje_tiempo', 'pot_porcentaje', 'Porcentaje', array('pot_estado' => 1), null, null, null, true);
        $data['competencias'] = $this->gsatelite->get_dropdown('com_competencia', 'com_nombre', 'Competencias', array('com_estado' => 1), null, null, null, true);
        $data['clasificaciones'] = $this->gsatelite->get_dropdown('cls_clasificacion', 'cls_nombre', 'Clasificaciones', array('cls_estado' => 1), null, null, null, true);
        $data['espacio_trabajo'] = $this->gsatelite->get_dropdown('ept_espacio_trabajo', 'ept_nombre', 'Espacios', array('ept_estado' => 1), $expIds, null, null, true);
        $data['herramientas'] = $this->gsatelite->get_dropdown('hrt_herramienta_trabajo', 'hrt_nombre', 'Herramientas', array('hrt_estado' => 1), $hxpIds, null, null, true);
        $data['tipo_riesgo'] = $this->gsatelite->get_dropdown('tri_tipo_riesgo', 'tri_nombre', 'TipoRiesgos', array('tri_estado' => 1), null, null, null, true);
        $data['nivel_riesgo'] = $this->gsatelite->get_dropdown('nir_nivel_riesgo', 'nir_nombre', 'NivelRiesgos', array('nir_estado' => 1), null, null, null, true);
        $data['horarios'] = $this->gsatelite->get_tabla('tur_turno', array('tur_estado' => 1));
        $data['prestaciones'] = $this->gsatelite->get_dropdown('prt_prestacion', 'prt_nombre', 'Prestaciones', array('prt_estado' => 1), $pxzIds, null, null, true);
        $data['ubiplaza'] = $this->gsatelite->get_dropdown('ubp_ubicacion_plaza', 'ubp_nombre', 'Ubicaciones', array('ubp_estado' => 1), $plaza_data[0]['plz_id_ubp'], null, null, true);
        $data['organigrama'] = $this->gsatelite->get_dropdown('org_organigrama', 'org_nombre', 'Organigramas', array('org_estado' => 1), $plaza_data[0]['plz_id_org'], null, null, true);

        $data['unid_presup'] = $this->gsatelite->get_dropdown('unp_unidad_presupuestaria', 'unp_nombre', '', array('unp_estado' => 1), $plaza_data[0]['plz_id_unp'], null, 'unp_id', true);
        $data['linea_trabj'] = $this->gsatelite->get_dropdown('lnt_linea_trabajo', 'lnt_nombre', '', array('lnt_estado' => 1), $plaza_data[0]['plz_id_lnt'], null, 'lnt_id', true);
        $data['partida_plz'] = $this->gsatelite->get_dropdown('ppl_partida_plaza', 'ppl_nombre', '', array('ppl_estado' => 1), $plaza_data[0]['plz_id_ppl'], null, 'ppl_id', true);
        $data['sub_ptda_pl'] = $this->gsatelite->get_dropdown('spp_subpartida_plaza', 'spp_nombre', '', array('spp_estado' => 1), $plaza_data[0]['plz_id_spp'], null, 'spp_id', true);
        $data['cifr_presup'] = $this->gsatelite->get_dropdown('cip_cifrado_presupuestario', 'cip_nombre', '', array('cip_estado' => 1), $plaza_data[0]['plz_id_cip'], null, 'cip_id', true);
        //El parametro contiene (separado por "/") la edad minima y maxima de una plaza
        $edades = $this->gsatelite->get_parametro('SYS_EDADES_PLAZAS');

        $edades_array = explode('/', $edades);

        $data['edad_minima'] = $edades_array[0];
        $data['edad_maxima'] = $edades_array[1];
        $data['plaza'] = $plaza_data[0];

        $data['competencias_plaza'] = $this->estructura_organizativa_model->get_competencias_plaza(array('cpz_id_plz' => $plz_id));
        $data['logros_plaza'] = $this->estructura_organizativa_model->get_logros_plaza(array('arp_id_plz' => $plz_id));
        $data['riesgos_plaza'] = $this->estructura_organizativa_model->get_riesgos_plaza(array('rxl_id_plz' => $plz_id));
        $data['anexos_plaza'] = $this->gsatelite->get_tabla('axp_anexoxplaza', array('axp_id_plz' => $plz_id));     
        
        $this->db->join('cec_centro_costo','cec_id = dcl_id_cec');
        $data['detalles_centros'] = $this->gsatelite->get_tabla('dcl_detalle_centro_costoxplaza',array('dcl_id_plz' => $plz_id, 'cec_id_emr'=> $this->tank_auth->get_empresa_id()));
      
        if ($ver != null) {
            $data['titulo_personal'] = "Ver Plaza / Cargo Funcional";
        } else {
            $data['titulo_personal'] = "Editar Plaza / Cargo Funcional";
        }
        $data['ver'] = $ver;

        //OBTENER RUTA
        $obtener_ruta = $this->gsatelite->get_valores_url();

        $data['url'] = $obtener_ruta['modulo'].'/'.$obtener_ruta['control'];

        if($modulo){ return $data; }

        cargarvista($data, null, 'estructura_organizativa/procesos/editar_plaza');
        
        //$this->_cargarvista($data);
    }

    function duplicar_plaza($id_plaza = null, $num_plazas = null) {
        satelite_validar();
        $plz_id = 0;
        $cantidad = 0;
        $ajax = false;

        $plz_id = $id_plaza;
        $cantidad = $num_plazas;

        if ($_POST) {
            $ajax = true;
            $plz_id = $this->input->post('id_plaza');
            $cantidad = $this->input->post('cantidad');
        }
        //var_dump($cantidad);die();
        $this->gsatelite->verificar_registro_real('plz_plaza', $plz_id);
        $plaza = $this->gsatelite->get_tabla('plz_plaza', array('plz_id' => $plz_id));
        $plaza = $plaza[0];
        
        //Se obtienen los generos por plaza
        $generos_plaza = $this->gsatelite->get_tabla('gxp_generoxplaza', array('gxp_id_plz' => $plz_id));

        //Se obtienen los grados academicos por plaza
        $profesion_plaza = $this->gsatelite->get_tabla('prp_profesion_plaza', array('prp_id_plz' => $plz_id));
        
        $funciones_plaza = $this->gsatelite->get_tabla('fxl_funcionxplaza', array('fxl_id_plz' => $plz_id));
        $espacios_plaza = $this->gsatelite->get_tabla('exp_espacioxplaza', array('exp_id_plz' => $plz_id));
        $herramientas_plaza = $this->gsatelite->get_tabla('hxp_herramientaxplaza', array('hxp_id_plz' => $plz_id));
        $prestaciones_plaza = $this->gsatelite->get_tabla('pxz_prestacionxplaza', array('pxz_id_plz' => $plz_id));

        $competencias_plaza = $this->estructura_organizativa_model->get_competencias_plaza(array('cpz_id_plz' => $plz_id));
        $logros_plaza = $this->estructura_organizativa_model->get_logros_plaza(array('arp_id_plz' => $plz_id));
        $riesgos_plaza = $this->estructura_organizativa_model->get_riesgos_plaza(array('rxl_id_plz' => $plz_id));
        $detalles_centros = $this->gsatelite->get_tabla('dcl_detalle_centro_costoxplaza', array('dcl_id_plz' => $plz_id));
        $anexos_plaza = $this->gsatelite->get_tabla('axp_anexoxplaza', array('axp_id_plz' => $plz_id));

        $exito = 0;
        for ($j = 0; $j < $cantidad; $j++) {
            $plaza_array = array(
                'plz_nombre' => $plaza['plz_nombre'],
                'plz_id_pto' => $plaza['plz_id_pto'],
                'plz_id_are' => $plaza['plz_id_are'],
                'plz_id_cec' => $plaza['plz_id_cec'],
                'plz_id_padre' => $plaza['plz_id_padre'],
                'plz_edad_maxima' => $plaza['plz_edad_maxima'],
                'plz_edad_minima' => $plaza['plz_edad_minima'],
                'plz_id_org' => $plaza['plz_id_org'],
                'plz_ubicacion_especifica' => $plaza['plz_ubicacion_especifica'],
                'plz_id_tie' => $plaza['plz_id_tie'],
                //'plz_id_gen' => $plaza['plz_id_gen'],
                //'plz_id_pro' => $plaza['plz_id_pro'],
                'plz_id_deh' => $plaza['plz_id_deh'],
                'plz_bono' => $plaza['plz_bono'],
                'plz_pago_hora_extra' => $plaza['plz_pago_hora_extra'],
                'plz_descripcion_mejora' => $plaza['plz_descripcion_mejora'],
                'plz_salario_base' => $plaza['plz_salario_base'],
                //'plz_horario' => $plaza['plz_horario'],
                'plz_alcance_decision' => $plaza['plz_alcance_decision'],
                'plz_competencia_basica' => $plaza['plz_competencia_basica'],
                'plz_plan_carrera' => $plaza['plz_plan_carrera'],
                'plz_estado' => 1,
                'plz_id_emr' => $this->tank_auth->get_empresa_id(),
                'plz_usu_creacion' => $this->tank_auth->get_user_id(),
                'plz_fecha_creacion' => date('Y-m-d H:i:s'),
                'plz_usu_modificacion' => $this->tank_auth->get_user_id(),
                'plz_fecha_modificacion' => date('Y-m-d H:i:s')
            );

            //Se ingresa la plaza
            $plz_nueva = $this->gsatelite->ingresar('plz_plaza', $plaza_array);
            if ($plz_nueva > 0) {
                
                //Se procesan los generos
                if (count($generos_plaza) > 0) {
                    for ($i = 0; $i < count($generos_plaza); $i++) {
                        $generos_array = array(
                            'gxp_id_gen' => $generos_plaza[$i]['gxp_id_gen'],
                            'gxp_id_plz' => $plz_nueva,
                            'gxp_estado' => 1,
                            'gxp_usu_creacion' => $this->tank_auth->get_user_id(),
                            'gxp_fecha_creacion' => date('Y-m-d H:i:s'),
                            'gxp_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'gxp_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('gxp_generoxplaza', $generos_array);
                    }
                }

                //Se procesan los grados academicos.
                if (count($profesion_plaza) > 0) {
                    for ($i = 0; $i < count($profesion_plaza); $i++) {
                        $grados_array = array(
                            'prp_id_pro' => $profesion_plaza[$i]['prp_id_pro'],
                            'prp_id_plz' => $plz_nueva,
                            'prp_estado' => 1,
                            'prp_usu_creacion' => $this->tank_auth->get_user_id(),
                            'prp_fecha_creacion' => date('Y-m-d H:i:s'),
                            'prp_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'prp_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('prp_profesion_plaza', $grados_array);
                    }
                }

                //Se procesan las funciones
                if (count($funciones_plaza) > 0) {
                    for ($i = 0; $i < count($funciones_plaza); $i++) {
                        $funciones_array = array(
                            'fxl_id_fun' => $funciones_plaza[$i]['fxl_id_fun'],
                            'fxl_id_plz' => $plz_nueva,
                            'fxl_estado' => 1,
                            'fxl_usu_creacion' => $this->tank_auth->get_user_id(),
                            'fxl_fecha_creacion' => date('Y-m-d H:i:s'),
                            'fxl_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'fxl_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('fxl_funcionxplaza', $funciones_array);
                    }
                }

                //Se procesan las competencias
                if (count($competencias_plaza) > 0) {
                    for ($i = 0; $i < count($competencias_plaza); $i++) {
                        $competencias_array = array(
                            'cpz_id_com' => $competencias_plaza[$i]['cpz_id_com'],
                            'cpz_id_cls' => $competencias_plaza[$i]['cpz_id_cls'],
                            'cpz_id_plz' => $plz_nueva,
                            'cpz_estado' => 1,
                            'cpz_usu_creacion' => $this->tank_auth->get_user_id(),
                            'cpz_fecha_creacion' => date('Y-m-d H:i:s'),
                            'cpz_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'cpz_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('cpz_competencia_plaza', $competencias_array);
                    }
                }

                //se procesan los logros
                if (count($logros_plaza) > 0) {
                    for ($i = 0; $i < count($logros_plaza); $i++) {
                        $logros_array = array(
                            'arp_id_are' => $logros_plaza[$i]['arp_id_are'],
                            'arp_id_acl' => $logros_plaza[$i]['arp_id_acl'],
                            'arp_id_pot' => $logros_plaza[$i]['arp_id_pot'],
                            'arp_id_plz' => $plz_nueva,
                            'arp_estado' => 1,
                            'arp_usu_creacion' => $this->tank_auth->get_user_id(),
                            'arp_fecha_creacion' => date('Y-m-d H:i:s'),
                            'arp_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'arp_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('arp_area_resultadoxplaza', $logros_array);
                    }
                }

                //Se procesan los espacios
                if (count($espacios_plaza) > 0) {
                    for ($i = 0; $i < count($espacios_plaza); $i++) {
                        $espacios_array = array(
                            'exp_id_ept' => $espacios_plaza[$i]['exp_id_ept'],
                            'exp_id_plz' => $plz_nueva,
                            'exp_estado' => 1,
                            'exp_usu_creacion' => $this->tank_auth->get_user_id(),
                            'exp_fecha_creacion' => date('Y-m-d H:i:s'),
                            'exp_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'exp_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('exp_espacioxplaza', $espacios_array);
                    }
                }

                //Se procesan las herramientas
                if (count($herramientas_plaza) > 0) {
                    for ($i = 0; $i < count($herramientas_plaza); $i++) {
                        $herramientas_array = array(
                            'hxp_id_hrt' => $herramientas_plaza[$i]['hxp_id_hrt'],
                            'hxp_id_plz' => $plz_nueva,
                            'hxp_estado' => 1,
                            'hxp_usu_creacion' => $this->tank_auth->get_user_id(),
                            'hxp_fecha_creacion' => date('Y-m-d H:i:s'),
                            'hxp_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'hxp_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('hxp_herramientaxplaza', $herramientas_array);
                    }
                }

                //Se procesan los riesgos de la plaza
                if (count($riesgos_plaza) > 0) {
                    for ($i = 0; $i < count($riesgos_plaza); $i++) {
                        $riesgos_array = array(
                            'rxl_id_tri' => $riesgos_plaza[$i]['rxl_id_tri'],
                            'rxl_id_nir' => $riesgos_plaza[$i]['rxl_id_nir'],
                            'rxl_id_plz' => $plz_nueva,
                            'rxl_estado' => 1,
                            'rxl_usu_creacion' => $this->tank_auth->get_user_id(),
                            'rxl_fecha_creacion' => date('Y-m-d H:i:s'),
                            'rxl_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'rxl_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('rxl_riesgoxplaza', $riesgos_array);
                    }
                }

                //Se procesan las prestaciones
                if (count($prestaciones_plaza) > 0) {
                    for ($i = 0; $i < count($prestaciones_plaza); $i++) {
                        $prestaciones_array = array(
                            'pxz_id_prt' => $prestaciones_plaza[$i]['pxz_id_prt'],
                            'pxz_id_plz' => $plz_nueva,
                            'pxz_estado' => 1,
                            'pxz_usu_creacion' => $this->tank_auth->get_user_id(),
                            'pxz_fecha_creacion' => date('Y-m-d H:i:s'),
                            'pxz_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'pxz_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('pxz_prestacionxplaza', $prestaciones_array);
                    }
                }

                if (count($anexos_plaza) > 0) {
                    for ($i = 0; $i < count($anexos_plaza); $i++) {
                        $nombreAnexo = end(explode('/', $anexos_plaza[$i]['axp_url']));
                        $tituloAnexo = explode('.', $nombreAnexo);

                        $extension = end(explode('.', $nombreAnexo));
                        $carpeta_temporal_anx = $ruta = "uploads/anx_plazas/" . trim($nombreAnexo);

                        $nombreArchivo = trim($tituloAnexo[0]) . $plz_nueva . "." . trim($extension);

                        $carpeta_destino_anx = "uploads/anx_plazas/" . $nombreArchivo;

                        $documentos_array = array(
                            'axp_id_plz' => $plz_nueva,
                            'axp_url' => $carpeta_destino_anx,
                            'axp_nombre' => $anexos_plaza[$i]['axp_nombre'],
                            'axp_estado' => 1,
                            'axp_usu_creacion' => $this->tank_auth->get_user_id(),
                            'axp_fecha_creacion' => date('Y-m-d H:i:s'),
                            'axp_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'axp_fecha_modificacion' => date('Y-m-d H:i:s'),
                        );

                        $nxp_id = $this->gsatelite->ingresar('axp_anexoxplaza', $documentos_array);

                        if ($nxp_id > 0) {
                            copy($carpeta_temporal_anx, $carpeta_destino_anx);
                        }
                    }
                }

                //Se procesan Centro de Costos
                
                if (count($detalles_centros) > 0) {
                    for ($i = 0; $i < count($detalles_centros); $i++) {
                            $dcl_detalle_centro_costoxplaza = array(
                            'dcl_id_cec'            => $detalles_centros[$i]['dcl_id_cec'],
                            'dcl_id_plz'            => $plz_nueva,
                            'dcl_porcentaje'        => $detalles_centros[$i]['dcl_porcentaje'],
                            'dcl_estado'            => 1,
                            'dcl_usu_creacion'      => $this->tank_auth->get_user_id(),
                            'dcl_fecha_creacion'    => date('Y-m-d H:i:s'),
                            'dcl_usu_modificacion'  => $this->tank_auth->get_user_id(),
                            'dcl_fecha_modificacion'=> date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('dcl_detalle_centro_costoxplaza', $dcl_detalle_centro_costoxplaza);
                    }
                }

                $exito++;
            }
        }
        if ($exito > 0) {
            $alerta = array(
                'tipo_alerta' => 'success'
                , 'titulo_alerta' => 'Éxito'
                , 'texto_alerta' => "<b>$exito</b> Nueva(s) plaza(s) / cargo(s) funcional(es) duplicada(s) con éxito."
            );
            $this->session->set_flashdata($alerta);
        }
        if ($ajax) {
            echo json_encode(array('exito' => $exito));
            die();
        } else {

            if ($plz_nueva > 0) {
                $this->gsatelite->show_dialog('Nueva plaza / cargo funcional ingresada con éxito.', 'estructura_organizativa/procesos/plazas');
            } else {
                $this->gsatelite->show_dialog('Error en duplicar plaza / cargo funcional', 'estructura_organizativa/procesos/plazas', 'error');
            }
        }
    }


    /**
     * @author René Castaneda / Luis Navarro (proceso de compartir funcionalidad 20-12-2017)
     * @return Mantenimiento pto_puesto
     * Descripcion: Funcion padre, comparitda con el modulo Inventario/Mantenimiento ( funcion: puesto)
     * Funcionalidad Padre, compartida con el modulo expediente_personal/Mantenimiento (funcion: puesto)
     * Funcionalidad Padre, compartida con el modulo estructura_organizativa/consultas (funcion: descriptor_puesto)
     */
    function puestos($ruta=null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            try {
                $ruta = (trim($ruta) != '')? $ruta : 'estructura_organizativa/procesos';
                $es_reporte = ($ruta == 'estructura_organizativa/consultas')? true:false;
                $permisos = $this->gsatelite->get_permisos_opcion();

                $id_usuario = $this->tank_auth->get_user_id();
                $id_empresa = $this->tank_auth->get_empresa_id();

                $url_actual = uri_string();
                $tipo_seleccionado = null;
                $data['aplica_filtro'] = true;
                if (substr_count($url_actual, 'add') > 0 || substr_count($url_actual, 'edit') > 0 || substr_count($url_actual, 'read') > 0 ) {
                   $data['aplica_filtro'] = false;
                }


                $columns = array(
                    'pto_id',
                    'pto_nombre',
                    'pto_id_tpt',
                    'pto_estado'
                );

                $display_as = array(
                    'pto_id' => 'Código',
                    'pto_nombre' => 'Nombre',
                    'empresas' => 'Empresa',
                    'pto_id_tpt' => 'Tipo puesto',
                    'pto_estado' => 'Estado',
                    'pto_funcion' => 'Responsabilidades'
                );

                $auditoria_empresa = array(
                           'mxp_estado' => 1,
                           'mxp_usu_creacion' => $this->tank_auth->get_user_id(),
                           'mxp_usu_modificacion' => $this->tank_auth->get_user_id(),
                           'mxp_fecha_modificacion' => date('Y-m-d H:i:s'),
                           'mxp_fecha_creacion' => date('Y-m-d H:i:s')
                       );


                $crud = new grocery_CRUD();
                $crud->unset_add();
                $crud->unset_edit();

                if ($this->input->post()) {
                        if ( $this->input->post('slcTipoPuesto') > 0 ) {
                            $tipo_seleccionado = $this->input->post('slcTipoPuesto');
                            $crud->where(array('pto_id_tpt'=>$tipo_seleccionado));
                           // $this->session->set_flashdata('export',$tipo_seleccionado);
                        }
                } else {
                    $state = $crud->getState();
                    /*if($state == 'print' or $state == 'export'){
                        $export = ( $this->session->flashdata('export') )?$this->session->flashdata('export'):0;
                        $crud->where(array('pto_id_tpt'=> $export ));
                        $this->session->set_flashdata('export',$export);
                    }else{*/
                        $crud->where(array('pto_id'=>0));   
                    //}
                }

                $crud->set_table('pto_puesto')
                        ->set_subject('puesto')
                        ->columns($columns)
                        ->set_relation('pto_id_tpt', 'tpt_tipo_puesto', 'tpt_nombre')
                        ->fields('pto_nombre', 'empresas', 'pto_funcion', 'pto_estado', 'pto_usu_mod', 'pto_fecha_mod')
                        ->display_as($display_as)
                        ->required_fields('pto_nombre','empresas', 'pto_estado', 'pto_usu_mod', 'pto_fecha_mod')
                       // ->set_rules('pto_nombre', 'Nombre', 'trim|required|campo_unico[pto_puesto.pto_nombre]')
                        ->set_relation_n_n('empresas', 'mxp_empresaxpuesto', 'emr_empresa', 'mxp_id_pto', 'mxp_id_emr', 'emr_nombre', null, array('emr_estado' => 1, "emr_id in ( SELECT uxe_id_emr FROM uxe_usuarioxempresa WHERE uxe_id_usu = $id_usuario)" => null),$auditoria_empresa)
                        ->field_type('pto_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                        ->field_type('pto_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                        // ->add_action('Anexos', '', 'expediente_personal/catalogos/anexos_puesto', 'icomoon-icon-stack')
                        ->unset_delete()
                       // ->unset_read()->unset_export()->unset_print()
                ;
                $urlx = explode('/', uri_string());
                if (end($urlx) == 'add') {
                    $crud->field_type('pto_estado', 'hidden', 1);
                } else {
                    $crud->field_type('pto_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
                }

                 // Validaciones
                if ($permisos['permite_agregar'] && !$es_reporte) {
                    $data['agregar'] = true;
                }

                if ($permisos['permite_editar'] && !$es_reporte) {
                    $crud->add_action('Editar', 'icomoon-icon-pencil-5', "$ruta/editar_puesto");
                }

                if ($permisos['permite_ver'] && !$es_reporte) {
                    $crud->add_action('Ver', 'icomoon-icon-search-5', "$ruta/ver_puesto");

                }

                if ($permisos['permite_eliminar'] && !$es_reporte) {
                    $crud->add_action('Eliminar', '  iconic-icon-denied', "$ruta/eliminar_puesto",'eliminar_puesto');
                }

                if ($es_reporte) {
                  //  $crud->unset_print()->unset_export();
                }

                $crud->add_action(' Imprimir', '', "estructura_organizativa/consultas/reporte_descriptor_puesto",'icomoon-icon-printer',null,'target="_blank"');

                $data['slcTipoPuesto'] =  $this->gsatelite->get_dropdown('tpt_tipo_puesto', '{tpt_nombre}','', array('tpt_estado' => 1 ), $tipo_seleccionado, '', 'tpt_id', true);

                $data['ruta'] = $ruta;
                $data['titulo_personal'] = (!$es_reporte)? "Puesto / Cargo en Estructura":"Reporte Descriptor de puesto";
                $crud->callback_add_field('pto_funcion', function () {
                    return '<textarea maxlength="300" value="" name="pto_funcion"></textarea>';
                });

            
                //Added by René Castaneda 08-03-2018
                //actualizar al id de empresa según la sessión del usuario (dado que es un cambio nuevo)
                $this->gsatelite->actualizar_empresa_id('pto_puesto');
                //condicionar empresa segun sessión del usuario
                $crud->where("pto_id IN (SELECT mxp_id_pto FROM mxp_empresaxpuesto WHERE mxp_id_emr = $id_empresa)", null);

                $output = $crud->render();
                // $this->_cargarvista($data, $output);

                cargarvista($data, $output, 'estructura_organizativa/procesos/puestos');
            } catch (Exception $e) {
                show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
            }
        }
    }


    /**
     * @author René Castaneda
     * @return Mantenimiento axp_anexoxpuesto
     */
    function anexos_puesto($id_puesto = null) {
        satelite_validar();
        $this->gsatelite->verificar_registro_real('pto_puesto', $id_puesto);
        $crud = new grocery_CRUD();
        $this->load->config('grocery_crud');
        $this->config->set_item('grocery_crud_file_upload_allow_file_types', 'pdf|jpeg|jpg|png|doc|xls|ppt');

        $crud->set_table('axp_anexoxpuesto')
                ->set_subject('Anexo Puesto')
                ->where('axp_anexoxpuesto.axp_id_pto', $id_puesto)
                ->columns('axp_id_pto', 'axp_nombre', 'axp_url', 'axp_estado')
                ->set_relation('axp_id_pto', 'pto_puesto', 'pto_nombre')
                ->fields('axp_id_pto', 'axp_nombre', 'axp_url', 'axp_estado', 'axp_usu_mod', 'axp_fecha_mod')
                ->display_as('axp_id_pto', 'Puesto')
                ->display_as('axp_nombre', 'Nombre')
                ->display_as('axp_url', 'Anexo')
                ->display_as('axp_estado', 'Estado')
                ->required_fields('axp_id_pto', 'axp_nombre', 'axp_url', 'axp_estado')
                ->set_rules('axp_nombre', 'Nombre', 'trim|required|campo_unico[axp_anexoxpuesto.axp_nombre]')
                ->field_type('axp_id_pto', 'hidden', $id_puesto)
                ->field_type('axp_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'))
                ->field_type('axp_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('axp_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                ->set_field_upload('axp_url', 'uploads/anexos_puesto')
                ->unset_print()
                ->unset_delete()
                ->unset_export()
        ;

        $data['titulo_personal'] = "ANEXOS PUESTO";
        $output = $crud->render();
        $this->_cargarvista($data, $output);
    }

    public function verificar_plaza(){
        satelite_validar();
        $plz_id = $this->input->post('plaza');
                   $this->db->join('emp_empleado', 'emp_id_plz = plz_id','left');
        $emp_reg = $this->gsatelite->get_tabla('plz_plaza', array('plz_id' => $plz_id));
        $estado = (count($emp_reg[0]['emp_id_plz']) > 0) ? true : false;
        $nombre_empleado = '';
        if($estado){
            $nombre_empleado = $emp_reg[0]['emp_nombre'].' '.$emp_reg[0]['emp_apellido'];
        }
        
        echo json_encode(array('empleado'=>$estado, 'nombre_empleado'=>$nombre_empleado));
    }

    /*
    * Descripcion: Funcion padre, comparitda con el modulo Inventario/Mantenimiento, funcion agregar_puesto
    * Funcionalidad Padre, compartida con el modulo expediente_personal/Mantenimiento, funcion agregar_puesto
    */
    public function agregar_puesto($ruta=null, $flag=null){
        satelite_validar();
        // ruta para pantalla compartida y flag para redireccion. Agregado por Luis Navarro
        $ruta = (trim($ruta) != '')? $ruta : 'estructura_organizativa/procesos';
        $flag = (trim($flag) != '')? $flag : 'puestos';
        $data['ruta'] = $ruta; 
        $data['flag'] = $flag;
        if ($_POST){
            $post_array = $_POST;
            $pto_puesto = array(
                'pto_id_tpt'                => ($post_array['slc_tipo_puesto'] != '') ? $post_array['slc_tipo_puesto'] : null,
                'pto_id_cts'                => ($post_array['slc_categoria_salarial'] != '') ? $post_array['slc_categoria_salarial'] : null,
                'pto_nombre'                => ($post_array['txt_nombre_puesto'] != '') ? $post_array['txt_nombre_puesto'] : null,
                'pto_funcion'               => ($post_array['txt_principales_responsabilidades'] != '') ? $post_array['txt_principales_responsabilidades'] : null,      
                'pto_objetivo'              => ($post_array['txt_objetivo'] != '') ? $post_array['txt_objetivo'] : null,
                'pto_cargo_persona'         => ($post_array['ckcPersonalCargo'])? 1 : 0,
                'pto_salario_promediado'    => ($post_array['ckcSalarioProm'])? 1 : 0,
                'pto_puntaje'               => ($post_array['txt_puntaje_puesto'] != '') ? $post_array['txt_puntaje_puesto'] : null,
                'pto_formacion_academica'   => ($post_array['txt_formacion_academica'] != '') ? $post_array['txt_formacion_academica'] : null,
                'pto_habilidad_especial'    => ($post_array['txt_habilidades_especiales'] != '') ? $post_array['txt_habilidades_especiales'] : null,
                'pto_conocimiento_tecnico'  => ($post_array['txt_conocimientos_tecnicos'] != '') ? $post_array['txt_conocimientos_tecnicos'] : null,
                'pto_otra_competencia'      => ($post_array['txt_otras_competencias'] != '') ? $post_array['txt_otras_competencias'] : null,
                'pto_actividad_diaria'      => ($post_array['txt_actividades_diarias'] != '') ? $post_array['txt_actividades_diarias'] : null,
                'pto_actividad_semanal'     => ($post_array['txt_actividades_semanales'] != '') ? $post_array['txt_actividades_semanales'] : null,
                'pto_actividad_quincenal'   => ($post_array['txt_actividades_quincenales'] != '') ? $post_array['txt_actividades_quincenales'] : null,
                'pto_actividad_mensual'     => ($post_array['txt_actividades_mensuales'] != '') ? $post_array['txt_actividades_mensuales'] : null,
                'pto_uniforme'              => ($post_array['txt_uniforme_puesto'] != '') ? $post_array['txt_uniforme_puesto'] : null,
                'pto_otros_datos'           => ($post_array['txt_otra_informacion'] != '') ? $post_array['txt_otra_informacion'] : null,
                'pto_entregable'            => ($post_array['txt_entregables_puesto'] != '') ? $post_array['txt_entregables_puesto'] : null,
                'pto_estado'                => 1,
                'pto_usu_creacion'          => $this->tank_auth->get_user_id(),
                'pto_fecha_creacion'        => date('Y-m-d h:i:s'),
                'pto_usu_modificacion'      => $this->tank_auth->get_user_id(),
                'pto_fecha_modificacion'    => date('Y-m-d h:i:s')
            );
            $pto_id = $this->gsatelite->ingresar('pto_puesto',$pto_puesto);

            ////// BENEFICIOS POR PUESTO
            if (isset($post_array['slc_beneficios_puesto']) and count($post_array['slc_beneficios_puesto']) > 0) {
                $bens = $post_array['slc_beneficios_puesto'];
                for ($k=0; $k < count($bens) ; $k++) { 
                    if ($bens[$k] > 0) {
                        $datos_emp = array(
                            'bxp_id_pto'                => $pto_id,
                            'bxp_id_bfp'                => $bens[$k],
                            'bxp_estado'                => 1,
                            'bxp_usu_creacion'          => $this->tank_auth->get_user_id(),
                            'bxp_fecha_creacion'        => date('Y-m-d H:i:s'),
                            'bxp_usu_modificacion'      => $this->tank_auth->get_user_id(),
                            'bxp_fecha_modificacion'    => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('bxp_beneficioxpuesto', $datos_emp);
                    }
                }               
            }

            ///////////////////////////////////
            ///EMPRESAS POR PUESTO
            // if (isset($post_array['slcEmpresa']) and count($post_array['slcEmpresa']) > 0) {
            //     $emps = $post_array['slcEmpresa'];
            //     for ($k=0; $k < count($emps) ; $k++) { 
            //         if ($emps[$k] > 0) {
                        $datos_emp = array(
                            'mxp_id_pto'                => $pto_id,
                            'mxp_id_emr'                => $this->tank_auth->get_empresa_id(),//$emps[$k],
                            'mxp_estado'                => 1,
                            'mxp_usu_creacion'          => $this->tank_auth->get_user_id(),
                            'mxp_fecha_creacion'        => date('Y-m-d H:i:s'),
                            'mxp_usu_modificacion'      => $this->tank_auth->get_user_id(),
                            'mxp_fecha_modificacion'    => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('mxp_empresaxpuesto', $datos_emp);
            //         }
            //     }               
            // }
            //////////////////////////////

            if (isset($post_array['titulo_doc'])) {
                for ($i = 0; $i < count($post_array['titulo_doc']); $i++) {

                    $carpeta_temporal_anx = "public/temp/anexos_puesto/" . trim($post_array['ruta'][$i]);
                    $carpeta_destino_anx = "uploads/anexos_puesto/" . trim($post_array['ruta'][$i]);

                    $datos_anexo = array(
                        'axp_id_pto'    => $pto_id,
                        'axp_nombre'    => $post_array['titulo_doc'][$i],
                        'axp_url'       => $carpeta_destino_anx,
                        'axp_estado'    => 1,
                        'axp_usu_mod'   => $this->tank_auth->get_user_id(),
                        'axp_fecha_mod' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->ingresar('axp_anexoxpuesto', $datos_anexo);

                    copy($carpeta_temporal_anx, $carpeta_destino_anx);
                    unlink($carpeta_temporal_anx);
                }
            }

            $alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Puestos de trabajo",'texto_alerta'=>"Registro procesados correctamente");
            $this->session->set_flashdata($alerta);

            if ( $post_array['txt_guardar'] == 0 ) {
                redirect("$ruta/agregar_puesto");
            } else {
                redirect("$ruta/$flag");
            }

        } else {
            // $id_usuario = $this->tank_auth->get_user_id();
            $data['tipo_puesto']        =  $this->gsatelite->get_tabla('tpt_tipo_puesto', array('tpt_estado' => 1) );
            $data['categoria_salarial'] =  $this->gsatelite->get_tabla('cts_categoria_salarial', array('cts_estado' => 1) );
            // $select_emp = $this->gsatelite->get_dropdown('emr_empresa', '{emr_nombre}', '', array('emr_estado' => 1,"emr_id in ( SELECT uxe_id_emr FROM uxe_usuarioxempresa WHERE uxe_id_usu = $id_usuario)"=>null), null, '', 'emr_id', true);
            // $data["empresas"] = str_replace('<option value="0">Seleccione</option>', '', $select_emp);
            $data['beneficio_puesto'] =  $this->gsatelite->get_tabla('bfp_beneficio_puesto', array('bfp_estado' => 1) );
            $data['titulo_personal']    = "Agregar Puesto / Cargo en Estructura";
            $data['simb_moneda'] = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ''); 
            cargarvista($data, null, 'estructura_organizativa/procesos/agregar_puesto');
        }
    }

    /*
    * Descripcion: Funcion padre, comparitda con el modulo sistema/catalogo, funcion editar_puesto
    * Funcionalidad Padre, compartida con el modulo expediente_personal/catalogos, funcion editar_puesto
    */
    public function editar_puesto($pto_id = null, $ruta = null, $flag = null){
        satelite_validar();
        // ruta para pantalla compartida y flag para redireccion. Agregado por Luis Navarro
        $ruta = (trim($ruta) != '')? $ruta : 'estructura_organizativa/procesos';
        $flag = (trim($flag) != '')? $flag : 'puestos';
        $data['ruta'] = $ruta;
        $data['flag'] = $flag;
        if ($_POST){
            $post_array = $_POST;
            $pto_id = ($post_array['txt_puesto'] != '') ? $post_array['txt_puesto'] : null;
            $pto_puesto = array(
                'pto_id_tpt'                => ($post_array['slc_tipo_puesto'] != '') ? $post_array['slc_tipo_puesto'] : null,
                'pto_id_cts'                => ($post_array['slc_categoria_salarial'] != '') ? $post_array['slc_categoria_salarial'] : null,
                'pto_nombre'                => ($post_array['txt_nombre_puesto'] != '') ? $post_array['txt_nombre_puesto'] : null,
                'pto_funcion'               => ($post_array['txt_principales_responsabilidades'] != '') ? $post_array['txt_principales_responsabilidades'] : null,      
                'pto_objetivo'              => ($post_array['txt_objetivo'] != '') ? $post_array['txt_objetivo'] : null,
                'pto_cargo_persona'         => (isset($post_array['ckcPersonalCargo'])) ? 1 : 0,
                'pto_salario_promediado'    => ($post_array['ckcSalarioProm'])? 1 : 0,
                'pto_puntaje'               => ($post_array['txt_puntaje_puesto'] != '') ? $post_array['txt_puntaje_puesto'] : null,
                'pto_formacion_academica'   => ($post_array['txt_formacion_academica'] != '') ? $post_array['txt_formacion_academica'] : null,
                'pto_habilidad_especial'    => ($post_array['txt_habilidades_especiales'] != '') ? $post_array['txt_habilidades_especiales'] : null,
                'pto_conocimiento_tecnico'  => ($post_array['txt_conocimientos_tecnicos'] != '') ? $post_array['txt_conocimientos_tecnicos'] : null,
                'pto_otra_competencia'      => ($post_array['txt_otras_competencias'] != '') ? $post_array['txt_otras_competencias'] : null,
                'pto_actividad_diaria'      => ($post_array['txt_actividades_diarias'] != '') ? $post_array['txt_actividades_diarias'] : null,
                'pto_actividad_semanal'     => ($post_array['txt_actividades_semanales'] != '') ? $post_array['txt_actividades_semanales'] : null,
                'pto_actividad_quincenal'   => ($post_array['txt_actividades_quincenales'] != '') ? $post_array['txt_actividades_quincenales'] : null,
                'pto_actividad_mensual'     => ($post_array['txt_actividades_mensuales'] != '') ? $post_array['txt_actividades_mensuales'] : null,
                'pto_uniforme'              => ($post_array['txt_uniforme_puesto'] != '') ? $post_array['txt_uniforme_puesto'] : null,
                'pto_otros_datos'           => ($post_array['txt_otra_informacion'] != '') ? $post_array['txt_otra_informacion'] : null,
                'pto_entregable'            => ($post_array['txt_entregables_puesto'] != '') ? $post_array['txt_entregables_puesto'] : null,
                'pto_estado'                => ($post_array['slc_estado'] != '') ? $post_array['slc_estado'] : null,
                'pto_usu_modificacion'      => $this->tank_auth->get_user_id(),
                'pto_fecha_modificacion'    => date('Y-m-d h:i:s')
            );
            $this->gsatelite->actualizar_array('pto_puesto',$pto_puesto, array('pto_id' => $pto_id) );


            //obtener todos los anexos originales
            $anexos_originales = $this->gsatelite->get_tabla('axp_anexoxpuesto', array('axp_id_pto' => $pto_id) );
            
            $documentos = (isset($post_array['anexos_puesto']) ) ? $post_array['anexos_puesto'] : "";
            //recorrer  para verrificar si viene un faltante, si no esta...es porque se elimino en la vista.
            for ($i = 0; $i < count($anexos_originales); $i++) {
                if (!in_array($anexos_originales[$i]['axp_id'], $documentos)) {
                    $carpeta_destino = $anexos_originales[$i]['axp_url'];
                    unlink($carpeta_destino);
                    $this->gsatelite->borrado_general('axp_anexoxpuesto', array('axp_id' => $anexos_originales[$i]['axp_id']) );
                }
            }

            ///BENEFICIOS POR PUESTO
            $this->gsatelite->borrado_general('bxp_beneficioxpuesto',array('bxp_id_pto' => $pto_id));
            if (isset($post_array['slc_beneficios_puesto']) and count($post_array['slc_beneficios_puesto']) > 0) {
                $bens = $post_array['slc_beneficios_puesto'];
                for ($k=0; $k < count($bens) ; $k++) { 
                    if ($bens[$k] > 0) {
                        $datos_emp = array(
                            'bxp_id_pto'                => $pto_id,
                            'bxp_id_bfp'                => $bens[$k],
                            'bxp_estado'                => 1,
                            'bxp_usu_creacion'          => $this->tank_auth->get_user_id(),
                            'bxp_fecha_creacion'        => date('Y-m-d H:i:s'),
                            'bxp_usu_modificacion'      => $this->tank_auth->get_user_id(),
                            'bxp_fecha_modificacion'    => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('bxp_beneficioxpuesto', $datos_emp);
                    }
                }          
             }
             //////////////////////////////



            ///EMPRESAS POR PUESTO
            $this->gsatelite->borrado_general('mxp_empresaxpuesto',array('mxp_id_pto' => $pto_id));
            /*
            if (isset($post_array['slcEmpresa']) and count($post_array['slcEmpresa']) > 0) {
                $emps = $post_array['slcEmpresa'];
                for ($k=0; $k < count($emps) ; $k++) { 
                    if ($emps[$k] > 0) {
                        */
                        $datos_emp = array(
                            'mxp_id_pto'                => $pto_id,
                            'mxp_id_emr'                => $this->tank_auth->get_empresa_id(),
                            'mxp_estado'                => 1,
                            'mxp_usu_creacion'          => $this->tank_auth->get_user_id(),
                            'mxp_fecha_creacion'        => date('Y-m-d H:i:s'),
                            'mxp_usu_modificacion'      => $this->tank_auth->get_user_id(),
                            'mxp_fecha_modificacion'    => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('mxp_empresaxpuesto', $datos_emp);
                        /*
                    }
                }               
            }
            */
            //////////////////////////////


            //insertar nuevos
            if (isset($post_array['titulo_doc'])) {
                for ($i = 0; $i < count($post_array['titulo_doc']); $i++) {

                    $carpeta_temporal_anx = "public/temp/anexos_puesto/" . trim($post_array['ruta'][$i]);
                    $carpeta_destino_anx = "uploads/anexos_puesto/" . trim($post_array['ruta'][$i]);

                    $datos_anexo = array(
                        'axp_id_pto'    => $pto_id,
                        'axp_nombre'    => $post_array['titulo_doc'][$i],
                        'axp_url'       => $carpeta_destino_anx,
                        'axp_estado'    => 1,
                        'axp_usu_mod'   => $this->tank_auth->get_user_id(),
                        'axp_fecha_mod' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->ingresar('axp_anexoxpuesto', $datos_anexo);

                    copy($carpeta_temporal_anx, $carpeta_destino_anx);
                    unlink($carpeta_temporal_anx);
                }
            }

            $alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Puestos de trabajo",'texto_alerta'=>"Registro procesados correctamente");
            $this->session->set_flashdata($alerta);

            if ( $post_array['txt_guardar'] == 0 ) {
                redirect("$ruta/editar_puesto/".$pto_id);
            } else {
                redirect("$ruta/$flag");
            }
        
        } else {
            $data['puesto'] = $this->gsatelite->get_tabla('pto_puesto',array('pto_id' => $pto_id));
            $data['anexos'] = $this->gsatelite->get_tabla('axp_anexoxpuesto',array('axp_id_pto' => $pto_id));
            $tpt            = $data['puesto'][0]['pto_id_tpt'];
            if ($tpt != '') {
                $id = $this->gsatelite->get_campo('tpt_tipo_puesto','tpt_aplica_detalle',array('tpt_id' => $tpt));
                $data['ver'] = ($id == 1) ? $id : null;
            }else{
                $data['ver'] = null;
            }

            $data['tipo_puesto']        = $this->gsatelite->get_tabla('tpt_tipo_puesto', array('tpt_estado' => 1) );
            $data['categoria_salarial'] = $this->gsatelite->get_tabla('cts_categoria_salarial', array('cts_estado' => 1) );

            $reg_emppuesto = $this->gsatelite->get_tabla('mxp_empresaxpuesto',array('mxp_id_pto'=>$pto_id));
            $array_emp = ($reg_emppuesto)? array_column($reg_emppuesto, 'mxp_id_emr'): array();
            
            // $id_usuario = $this->tank_auth->get_user_id();
            // $select_emp = $this->gsatelite->get_dropdown('emr_empresa', '{emr_nombre}', '', array('emr_estado' => 1,"emr_id in ( SELECT uxe_id_emr FROM uxe_usuarioxempresa WHERE uxe_id_usu = $id_usuario)"=>null), $array_emp, '', 'emr_id', true);
            // $data["empresas"] = str_replace('<option value="0">Seleccione</option>', '', $select_emp);
           
            $reg_bxp = $this->gsatelite->get_tabla('bxp_beneficioxpuesto',array('bxp_id_pto'=>$pto_id));
            $array_benf = ($reg_bxp)? array_column($reg_bxp, 'bxp_id_bfp'): array();
            $select_benf = $this->gsatelite->get_dropdown('bfp_beneficio_puesto', '{bfp_nombre}', '', array('bfp_estado' => 1), $array_benf, '', 'bfp_id', true);
            $data['simb_moneda'] = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ''); 
            $data["beneficiosxpuesto"] = str_replace('<option value="0">Seleccione</option>', '', $select_benf);
            $data['titulo_personal']    = "Editar Puesto / Cargo en Estructura";
            cargarvista($data, null, 'estructura_organizativa/procesos/editar_puesto');
        }
    }

    /*
    * Descripcion: Funcion padre, comparitda con el modulo Inventario/mantenimiento, funcion ver_puesto
    * Funcionalidad Padre, compartida con el modulo expediente_personal/mantenimiento, funcion ver_puesto
    */
    public function ver_puesto($pto_id = null, $ruta = null, $flag = null){
        satelite_validar();
        $ruta = (trim($ruta) != '')? $ruta : 'estructura_organizativa/procesos';
        $flag = (trim($flag) != '')? $flag : 'puestos';
        $data['ruta'] = $ruta;
        $data['flag'] = $flag;

        $data['puesto']             = $this->gsatelite->get_tabla('pto_puesto',array('pto_id' => $pto_id));
        $data['anexos']              = $this->gsatelite->get_tabla('axp_anexoxpuesto',array('axp_id_pto' => $pto_id));
        $data['tipo_puesto']        = $this->gsatelite->get_tabla('tpt_tipo_puesto', array('tpt_estado' => 1) );
        $data['categoria_salarial'] = $this->gsatelite->get_tabla('cts_categoria_salarial', array('cts_estado' => 1) );

        $reg_emppuesto = $this->gsatelite->get_tabla('mxp_empresaxpuesto',array('mxp_id_pto'=>$pto_id));
        $array_emp = ($reg_emppuesto)? array_column($reg_emppuesto, 'mxp_id_emr'): array();
        
        $id_usuario = $this->tank_auth->get_user_id();
        $select_emp = $this->gsatelite->get_dropdown('emr_empresa', '{emr_nombre}', '', array('emr_estado' => 1,"emr_id in ( SELECT uxe_id_emr FROM uxe_usuarioxempresa WHERE uxe_id_usu = $id_usuario)"=>null), $array_emp, '', 'emr_id', true);
        $data["empresas"] = str_replace('<option value="0">Seleccione</option>', '', $select_emp);

        $reg_bxp = $this->gsatelite->get_tabla('bxp_beneficioxpuesto',array('bxp_id_pto'=>$pto_id));
        $array_benf = ($reg_bxp)? array_column($reg_bxp, 'bxp_id_bfp'): array();
        $select_benf = $this->gsatelite->get_dropdown('bfp_beneficio_puesto', '{bfp_nombre}', '', array('bfp_estado' => 1), $array_benf, '', 'bfp_id', true);

        $data["beneficiosxpuesto"] = str_replace('<option value="0">Seleccione</option>', '', $select_benf);

        $data['titulo_personal']    = "Ver Puesto / Cargo en Estructura";
        // $this->_cargarvista($data);
        cargarvista($data, null, 'estructura_organizativa/procesos/ver_puesto');

    }

    /*
    * Descripcion: Funcion padre, comparitda con el modulo Inventario/mantenimiento, funcion eliminar_puesto
    * Funcionalidad Padre, compartida con el modulo expediente_personal/mantenimiento, funcion eliminar_puesto
    */
    public function eliminar_puesto($pto_id = null, $ruta = null, $flag = null){
        satelite_validar();
        $ruta = (trim($ruta) != '')? $ruta : 'estructura_organizativa/procesos';
        $flag = (trim($flag) != '')? $flag : 'puestos';
        
        // revisar si hay plazas, evaluaciones o un concurso de plaza autorizado para ese puesto
        $plaza = $this->gsatelite->get_tabla('plz_plaza',array('plz_id_pto' => $pto_id));
        $concursos = $this->gsatelite->get_tabla('cnp_concurso_plaza',array('cnp_id_pto' => $pto_id, 'cnp_estado > ' => 1));
        $evaluaciones = $this->gsatelite->get_tabla('ext_evaluacionxpuesto',array('ext_id_pto' => $pto_id, 'ext_estado' => 1));

        if (count($plaza) > 0) {
            $alerta=array('tipo_alerta'=> 'info','titulo_alerta'=>"Puestos de trabajo",'texto_alerta'=>"No puedo eliminarse debido a que una o más plazas / cargos funcionales poseen este puesto.");
        } elseif (count($concursos) > 0) {
            $alerta=array('tipo_alerta'=> 'info','titulo_alerta'=>"Puestos de trabajo",'texto_alerta'=>"No puedo eliminarse debido a uno o más concursos de plaza / cargo funcional para este puesto.");
        } elseif (count($evaluaciones) > 0) {
            $alerta=array('tipo_alerta'=> 'info','titulo_alerta'=>"Puestos de trabajo",'texto_alerta'=>"No puedo eliminarse debido a una o más evaluaciones de desempeño para este puesto.");
        } else {
            $this->gsatelite->actualizar_array('acn_accionista', array('acn_id_pto' => null), array('acn_id_pto' => $pto_id));
            $this->gsatelite->actualizar_array('mij_miembro_junta', array('mij_id_pto' => null), array('mij_id_pto' => $pto_id));
            //borrar anexos
            $anexos_originales = $this->gsatelite->get_tabla('axp_anexoxpuesto', array('axp_id_pto' => $pto_id) );
            foreach ($anexos_originales as $anexo) {
                $carpeta_destino = $anexo['axp_url'];
                unlink($carpeta_destino);
            }
            $this->gsatelite->borrado_general('axp_anexoxpuesto',array('axp_id_pto' => $pto_id));
            $this->gsatelite->borrado_general('bxp_beneficioxpuesto',array('bxp_id_pto' => $pto_id));
            $this->gsatelite->borrado_general('mxp_empresaxpuesto',array('mxp_id_pto' => $pto_id));
            $this->gsatelite->borrado_general('pto_puesto',array('pto_id' => $pto_id));

            $alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Puestos de trabajo",'texto_alerta'=>"Registro eliminado correctamente");
        }
        $this->session->set_flashdata($alerta);
        redirect("$ruta/$flag");
    }

    public function ajax_prefiltro_dependencia() {
        satelite_validar(true);
        if($this->input->post()) {
            $area = $this->input->post('areaDependencia');
            $id_empresa = $this->tank_auth->get_empresa_id();

                      $this->db->join('emp_empleado', 'emp_id_plz = plz_id', 'left');   
            $plazas = $this->gsatelite->get_dropdown('plz_plaza', "[concat_ws(' ', plz_nombre,'-',emp_nombre, emp_apellido)]", 'Plaza / Cargo Funcional', array('plz_estado' => 1, "plz_id_are IN (SELECT mxr_id_are FROM mxr_empresaxarea WHERE mxr_id_emr = $id_empresa)" => null, 'plz_id_are'=>$area), null, null, null, true);
            $plazas = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $plazas);
            echo json_encode($plazas);
            die();
        }
    }

    public function cargar_area_nivel()
    {
        $id_empresa = $this->tank_auth->get_empresa_id();
        $id_area = ($this->input->post('id_area')>0)? $this->input->post('id_area'):0;
        $id_nivel_siguiente = ($this->input->post('id_nivel_siguiente')>0)? $this->input->post('id_nivel_siguiente'):0;

        $opciones = $this->gsatelite->get_dropdown('are_area', 'are_nombre', 'areas', array('are_estado' => 1,'are_padre'=>$id_area, 'are_id_nia' =>$id_nivel_siguiente, "are_id IN (SELECT mxr_id_are FROM mxr_empresaxarea WHERE mxr_id_emr = $id_empresa)"=> null), null, null, null, true);
        $datos_nivel['opciones'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $opciones);
        die(json_encode($datos_nivel));
    }

    function get_porcentaje_disponible(){
        $tipo_vista = $this->input->post('vista');
        $id_empresa = $this->tank_auth->get_empresa_id();
        $porc_total = $this->gsatelite->get_suma('acn_accionista','acn_porcentaje',array('acn_id_emr' => $id_empresa, 'acn_estado' => 1));
        $accionista = $this->gsatelite->count('acn_accionista', array('acn_id_emr' => $id_empresa, 'acn_estado' => 1));
        $proporcion = ($tipo_vista == 2) ? $accionista : ($accionista + 1);
        $disponible = round((100 - $porc_total),2);
        echo json_encode(array('total' => $porc_total, 'proporcion'=>$proporcion, 'disponible'=> $disponible));
    }

    /*
        * Descripción: Guardar registro de accionistas
        * @author Marlon Olmedo. - Grupo Satélite
        * @since  2020-May
    */
    public function guardar_registro_accionistas() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($_POST) {
                $nombre_titular = $this->input->post('txttitular'); //acn_nombre
                $por_parti = $this->input->post('acn_porcentaje'); //acn_porcentaje
                $canti_acci = $this->input->post('acn_cantidad_acciones'); //acn_cantidad_acciones
                $val_contable = $this->input->post('acn_valor_contable'); //acn_valor_contable
                $val_nominal = $this->input->post('acn_valor_nominal'); //acn_valor_nominal
                $titular = $this->input->post('slctitular'); //acn_id_pto
                $institucion = $this->input->post('slcintitucion'); //acn_id_itt
                $dui = $this->input->post('txtdui'); //acn_documento_dui
                $direccion = $this->input->post('txtdireccion'); //acn_direccion_contacto
                $nit = $this->input->post('txtnit'); //acn_documento_nit
                $correo = $this->input->post('txtcorreo'); //acn_correo_contacto
                $tel_titular = $this->input->post('txttelefono'); //acn_telefono_contacto
                $per_desde = $this->input->post('txtperiodoD'); //acn_periodo_inicio
                $per_hasta = $this->input->post('txtperiodoH'); //acn_periodo_fin
                $estado = $this->input->post('txtestado'); //acn_estado
                $boton = $this->input->post('btnGuardar');
                //print_r($this->input->post('txtasistente'));die();
                $data = array(
                    "acn_id_emr" => $this->tank_auth->get_empresa_id(), //acn_id_emr
                    // "acn_id_itt" => $institucion,
                    "acn_id_pto" => $titular,
                    "acn_nombre" => $nombre_titular,
                    "acn_porcentaje" => (is_numeric($por_parti)) ? $por_parti : 0,
                    "acn_cantidad_acciones" => (is_numeric($canti_acci)) ? $canti_acci : 0,
                    "acn_valor_contable" => (is_numeric($val_contable)) ? $val_contable : 0,
                    "acn_valor_nominal" => (is_numeric($val_nominal)) ? $val_nominal : 0,
                    "acn_documento_dui" => $dui,
                    "acn_documento_nit" => $nit,
                    "acn_direccion_contacto" => $direccion,
                    "acn_correo_contacto" => $correo,
                    "acn_telefono_contacto" => $tel_titular,
                    "acn_periodo_inicio" => formatear_fecha("Y-m-d H:i:s", $per_desde),
                    "acn_periodo_fin" => formatear_fecha("Y-m-d H:i:s", $per_hasta),
                    "acn_estado" => $estado,
                    "acn_usu_creacion" => $this->tank_auth->get_user_id(),
                    "acn_fecha_creacion" => date('Y-m-d H:i:s'),
                    "acn_usu_modificacion" => $this->tank_auth->get_user_id(),
                    "acn_fecha_modificacion" => date('Y-m-d H:i:s')
                );
                $acn_id = $this->gsatelite->ingresar('acn_accionista', $data);

                $asa_id = $this->input->post('asa_id');
                $nombre_asistente = $this->input->post('txtasistente');
                $tel_asistente = $this->input->post('txttelefonoA');
                
                if (!empty($asa_id)) {
                    foreach ($asa_id as $key => $value) {
                        $asa_data = array(
                            "asa_id_acn" => $acn_id,
                            "asa_nombre" => $nombre_asistente[$key],
                            "asa_telefono" => $tel_asistente[$key],
                            "asa_estado" => 1,
                            "asa_usu_creacion" => $this->tank_auth->get_user_id(),
                            "asa_fecha_creacion" => date('Y-m-d H:i:s'),
                            "asa_usu_modificacion" => $this->tank_auth->get_user_id(),
                            "asa_fecha_modificacion" => date('Y-m-d H:i:s')
                        );

                        $asa_id = $this->gsatelite->ingresar('asa_asistente_accionista', $asa_data);
                    }
                }

                if ($acn_id > 0) {
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro de accionista", 'texto_alerta' => "El registro se guardó correctamente");
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro de accionista", 'texto_alerta' => "El registro NO se guardó correctamente");
                }

                $this->session->set_flashdata($alerta);

                if ($boton == 1) {
                    redirect('estructura_organizativa/procesos/guardar_registro_accionistas');
                } else {
                    redirect('estructura_organizativa/procesos/registro_accionistas');
                }
            }
            $cargo = $this->gsatelite->get_dropdown('pto_puesto', '{pto_nombre}', '', array('pto_estado' => 1), null, '', 'pto_id', true);
            $data['cargo'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $cargo);
            $institucion = $this->gsatelite->get_dropdown('itt_institucion', '{itt_nombre}', '', array('itt_estado' => 1), null, '', 'itt_id', true);
            $data['institucion'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $institucion);
            $data["titulo_personal"]    = "Registro de accionistas";
            $this->_cargarvista($data);
        }
    }

    /*
        * Descripción: Copia de "Guardar registro de accionistas" para empresas sin accionistas por ejemplo UTE
        * @author Raul E. - Grupo Satélite
        * @since  2021/Ene
    */
    public function guardar_registro_miembros() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($_POST) {
                $nombre_titular = $this->input->post('txttitular'); 
                $titular = $this->input->post('slctitular');
                $dui = $this->input->post('txtdui');
                $direccion = $this->input->post('txtdireccion');
                $nit = $this->input->post('txtnit');
                $correo = $this->input->post('txtcorreo');
                $tel_titular = $this->input->post('txttelefono');
                $per_desde = $this->input->post('txtperiodoD');
                $per_hasta = $this->input->post('txtperiodoH');
                $estado = $this->input->post('txtestado');
                $insttn = ($this->input->post('txt_institut') != "") ? $this->input->post('txt_institut') : null;
                $boton = $this->input->post('btnGuardar');
                $data = array(
                    "mij_id_emr" => $this->tank_auth->get_empresa_id(),
                    "mij_id_pto" => $titular,
                    "mij_id_itt" => $insttn,
                    "mij_nombre" => $nombre_titular,                    
                    "mij_documento_dui" => $dui,
                    "mij_documento_nit" => $nit,
                    "mij_direccion_contacto" => $direccion,
                    "mij_correo_contacto" => $correo,
                    "mij_telefono_contacto" => $tel_titular,
                    "mij_periodo_inicio" => formatear_fecha("Y-m-d H:i:s", $per_desde),
                    "mij_periodo_fin" => formatear_fecha("Y-m-d H:i:s", $per_hasta),
                    "mij_estado" => ($estado != "") ? $estado : 1,
                    "mij_usu_creacion" => $this->tank_auth->get_user_id(),
                    "mij_fecha_creacion" => date('Y-m-d H:i:s'),
                    "mij_usu_modificacion" => $this->tank_auth->get_user_id(),
                    "mij_fecha_modificacion" => date('Y-m-d H:i:s')
                );
                $acn_id = $this->gsatelite->ingresar('mij_miembro_junta', $data);
                $asa_id = $this->input->post('asa_id');
                $nombre_asistente = $this->input->post('txtasistente');
                $tel_asistente = $this->input->post('txttelefonoA');                
                if (!empty($asa_id)) {
                    foreach ($asa_id as $key => $value) {
                        $asa_data = array(
                            "asm_id_mij" => $acn_id,
                            "asm_nombre" => $nombre_asistente[$key],
                            "asm_telefono_contacto" => $tel_asistente[$key],
                            "asm_estado" => 1,
                            "asm_usu_creacion" => $this->tank_auth->get_user_id(),
                            "asm_fecha_creacion" => date('Y-m-d H:i:s'),
                            "asm_usu_modificacion" => $this->tank_auth->get_user_id(),
                            "asm_fecha_modificacion" => date('Y-m-d H:i:s')
                        );
                        $asa_id = $this->gsatelite->ingresar('asm_asistente_miembro', $asa_data);
                    }
                }
                if ($acn_id > 0) {
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Miembro de Junta Directiva", 'texto_alerta' => "El registro se guardó correctamente");
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Miembro de Junta Directiva", 'texto_alerta' => "El registro NO se guardó correctamente");
                }
                $this->session->set_flashdata($alerta);
                if ($boton == 1) {
                    redirect('estructura_organizativa/procesos/guardar_registro_miembros');
                } else {
                    redirect('estructura_organizativa/procesos/registro_miembro_jd');
                }
            }
            $cargo = $this->gsatelite->get_dropdown('pto_puesto', '{pto_nombre}', '', array('pto_estado' => 1), null, '', 'pto_id', true);
            $instt = $this->gsatelite->get_dropdown('itt_institucion', '{itt_nombre}', '', array('itt_estado' => 1), $data["accionista"]["mij_id_itt"], '', 'itt_id', true);
            $data['cargo'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $cargo);
            $data['instt'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $instt);
            $data["titulo_personal"]    = "Miembros de CCSJ";
            $data["url_grid"] = base_url('estructura_organizativa/procesos/registro_miembro_jd');
            //SE ENVIA EL $data["url_grid"] PARA MANTENER EL TITULO DE LA OPCION PADRE QUE SE COLOCARA EN UN SPAN CON LA CLASE "title_heading" SINO SE COLOCA EL titulo_personal
            $this->_cargarvista($data);
        }
    }

    /*
        * Descripción: Editar registro de accionistas
        * @author Marlon Olmedo. - Grupo Satélite
        * @since  2020-May
    */
    public function editar_registro_accionistas($acn_id) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($_POST) {
               $nombre_titular = $this->input->post('txttitular'); //acn_nombre
                $por_parti = $this->input->post('acn_porcentaje'); //acn_porcentaje
                $canti_acci = $this->input->post('acn_cantidad_acciones'); //acn_cantidad_acciones
                $val_contable = $this->input->post('acn_valor_contable'); //acn_valor_contable
                $val_nominal = $this->input->post('acn_valor_nominal'); //acn_valor_nominal
                $titular = $this->input->post('slctitular'); //acn_id_pto
                $institucion = $this->input->post('slcintitucion'); //acn_id_itt
                $dui = $this->input->post('txtdui'); //acn_documento_dui
                $direccion = $this->input->post('txtdireccion'); //acn_direccion_contacto
                $nit = $this->input->post('txtnit'); //acn_documento_nit
                $correo = $this->input->post('txtcorreo'); //acn_correo_contacto
                $tel_titular = $this->input->post('txttelefono'); //acn_telefono_contacto
                $per_desde = $this->input->post('txtperiodoD'); //acn_periodo_inicio
                $per_hasta = $this->input->post('txtperiodoH'); //acn_periodo_fin
                $estado = $this->input->post('txtestado'); //acn_estado
                $boton = $this->input->post('btnGuardar');
                //print_r($this->input->post('txtasistente'));die();
                $data = array(
                    // "acn_id_itt" => $institucion,
                    "acn_id_pto" => $titular,
                    "acn_nombre" => $nombre_titular,
                    "acn_porcentaje" => (is_numeric($por_parti)) ? $por_parti : 0,
                    "acn_cantidad_acciones" => (is_numeric($canti_acci)) ? $canti_acci : 0,
                    "acn_valor_contable" => (is_numeric($val_contable)) ? $val_contable : 0,
                    "acn_valor_nominal" => (is_numeric($val_nominal)) ? $val_nominal : 0,
                    "acn_documento_dui" => $dui,
                    "acn_documento_nit" => $nit,
                    "acn_direccion_contacto" => $direccion,
                    "acn_correo_contacto" => $correo,
                    "acn_telefono_contacto" => $tel_titular,
                    "acn_periodo_inicio" => formatear_fecha("Y-m-d H:i:s", $per_desde),
                    "acn_periodo_fin" => formatear_fecha("Y-m-d H:i:s", $per_hasta),
                    "acn_estado" => $estado,
                    "acn_usu_creacion" => $this->tank_auth->get_user_id(),
                    "acn_fecha_creacion" => date('Y-m-d H:i:s'),
                    "acn_usu_modificacion" => $this->tank_auth->get_user_id(),
                    "acn_fecha_modificacion" => date('Y-m-d H:i:s')
                );
                
                $acn_id_ = $this->gsatelite->actualizar_array('acn_accionista',$data, array('acn_id' => $acn_id) );
                

                $this->gsatelite->borrado_general('asa_asistente_accionista', array('asa_id_acn' => $acn_id) );
                $asa_id = $this->input->post('asa_id');
                $nombre_asistente = $this->input->post('txtasistente');
                $tel_asistente = $this->input->post('txttelefonoA');
                if (!empty($asa_id)) {
                    foreach ($asa_id as $key => $value) {
                        $asa_data = array(
                            "asa_id_acn" => $acn_id,
                            "asa_nombre" => $nombre_asistente[$key],
                            "asa_telefono" => $tel_asistente[$key],
                            "asa_estado" => 1,
                            "asa_usu_creacion" => $this->tank_auth->get_user_id(),
                            "asa_fecha_creacion" => date('Y-m-d H:i:s'),
                            "asa_usu_modificacion" => $this->tank_auth->get_user_id(),
                            "asa_fecha_modificacion" => date('Y-m-d H:i:s')
                        );

                        $asa_id = $this->gsatelite->ingresar('asa_asistente_accionista', $asa_data);
                    }
                }

                if ($acn_id_ > 0) {
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro de accionista", 'texto_alerta' => "El registro se actualizo correctamente");
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro de accionista", 'texto_alerta' => "El registro NO se actualizo correctamente");
                }

                $this->session->set_flashdata($alerta);

                if ($boton == 1) {
                    redirect('estructura_organizativa/procesos/editar_registro_accionistas/'.$acn_id);
                } else {
                    redirect('estructura_organizativa/procesos/registro_accionistas');
                }
            }
            $accionista = $this->gsatelite->get_tabla('acn_accionista', array('acn_id' => $acn_id));
            $data["accionista"] = $accionista[0];
            $cargo = $this->gsatelite->get_dropdown('pto_puesto', '{pto_nombre}', '', array('pto_estado' => 1), $data["accionista"]["acn_id_pto"], '', 'pto_id', true);
            $data['cargo'] = str_replace('<option value="0">Seleccione</option>', '', $cargo);
            $institucion = $this->gsatelite->get_dropdown('itt_institucion', '{itt_nombre}', '', array('itt_estado' => 1), $data["accionista"]["acn_id_itt"], '', 'itt_id', true);
            $data['institucion'] = str_replace('<option value="0">Seleccione</option>', '', $institucion);
            $data["asistente"] = $this->gsatelite->get_tabla('asa_asistente_accionista', array('asa_id_acn' => $acn_id));
            $data["titulo_personal"]    = "Registro de accionistas";
            $this->_cargarvista($data);
        }
    }

    /*
        * Descripción: Copia de "Editar registro de accionistas" para empresas sin accionistas por ejemplo UTE
        * @author Raul E. - Grupo Satélite
        * @since  2021/Ene
    */
    public function editar_registro_miembros($acn_id) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($_POST) {
                // var_dump($_POST);die();
                $nombre_titular = $this->input->post('txttitular'); 
                $titular = $this->input->post('slctitular');
                $dui = $this->input->post('txtdui');
                $direccion = $this->input->post('txtdireccion');
                $nit = $this->input->post('txtnit');
                $correo = $this->input->post('txtcorreo');
                $tel_titular = $this->input->post('txttelefono');
                $per_desde = $this->input->post('txtperiodoD');
                $per_hasta = $this->input->post('txtperiodoH');
                $estado = $this->input->post('txtestado');
                $insttn = ($this->input->post('txt_institut') != "") ? $this->input->post('txt_institut') : null;
                $boton = $this->input->post('btnGuardar');
                $data = array(
                    "mij_id_pto" => $titular,
                    "mij_id_itt" => $insttn,
                    "mij_nombre" => $nombre_titular,
                    "mij_documento_dui" => $dui,
                    "mij_documento_nit" => $nit,
                    "mij_direccion_contacto" => $direccion,
                    "mij_correo_contacto" => $correo,
                    "mij_telefono_contacto" => $tel_titular,
                    "mij_periodo_inicio" => formatear_fecha("Y-m-d H:i:s", $per_desde),
                    "mij_periodo_fin" => formatear_fecha("Y-m-d H:i:s", $per_hasta),
                    "mij_estado" => ($estado != "") ? $estado : 1,
                    "mij_usu_creacion" => $this->tank_auth->get_user_id(),
                    "mij_fecha_creacion" => date('Y-m-d H:i:s'),
                    "mij_usu_modificacion" => $this->tank_auth->get_user_id(),
                    "mij_fecha_modificacion" => date('Y-m-d H:i:s')
                );                
                $acn_id_ = $this->gsatelite->actualizar_array('mij_miembro_junta',$data, array('mij_id' => $acn_id) );
                $this->gsatelite->borrado_general('asm_asistente_miembro', array('asm_id_mij' => $acn_id) );
                $asa_id = $this->input->post('asa_id');
                $nombre_asistente = $this->input->post('txtasistente');
                $tel_asistente = $this->input->post('txttelefonoA');
                if (!empty($asa_id)) {
                    foreach ($asa_id as $key => $value) {
                        $asa_data = array(
                            "asm_id_mij" => $acn_id,
                            "asm_nombre" => $nombre_asistente[$key],
                            "asm_telefono_contacto" => $tel_asistente[$key],
                            "asm_estado" => 1,
                            "asm_usu_creacion" => $this->tank_auth->get_user_id(),
                            "asm_fecha_creacion" => date('Y-m-d H:i:s'),
                            "asm_usu_modificacion" => $this->tank_auth->get_user_id(),
                            "asm_fecha_modificacion" => date('Y-m-d H:i:s')
                        );
                        $asa_id = $this->gsatelite->ingresar('asm_asistente_miembro', $asa_data);
                    }
                }
                if ($acn_id_ > 0) {
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Miembro de Junta Directiva", 'texto_alerta' => "El registro se actualizo correctamente");
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Miembro de Junta Directiva", 'texto_alerta' => "El registro NO se actualizo correctamente");
                }
                $this->session->set_flashdata($alerta);
                if ($boton == 1) {
                    redirect('estructura_organizativa/procesos/editar_registro_miembros/'.$acn_id);
                } else {
                    redirect('estructura_organizativa/procesos/registro_miembro_jd');
                }
            }
            $accionista = $this->gsatelite->get_tabla('mij_miembro_junta', array('mij_id' => $acn_id));
            $data["accionista"] = $accionista[0];
            $cargo = $this->gsatelite->get_dropdown('pto_puesto', '{pto_nombre}', '', array('pto_estado' => 1), $data["accionista"]["mij_id_pto"], '', 'pto_id', true);
            $instt = $this->gsatelite->get_dropdown('itt_institucion', '{itt_nombre}', '', array('itt_estado' => 1), $data["accionista"]["mij_id_itt"], '', 'itt_id', true);
            $data['cargo'] = str_replace('<option value="0">Seleccione</option>', '', $cargo);
            $data['instt'] = str_replace('<option value="0">Seleccione</option>', '', $instt);
            $data["asistente"] = $this->gsatelite->get_tabla('asm_asistente_miembro', array('asm_id_mij' => $acn_id));
            $data["titulo_personal"]    = "Miembros de CCSJ";
            //PARA MANTENER EL TITULO DE LA OPCION PADRE
            $data["url_grid"] = base_url('estructura_organizativa/procesos/registro_miembro_jd');
            $this->_cargarvista($data);
        }
    }

    public function get_areas_ajax(){
        if($this->input->post()){
            // var_dump($_POST);die();
            $post_array = $this->input->post();
            $area_nombre = ($post_array['area'] != '') ? $post_array['area'] : null;
            $where["are_estado"] = 1;
            if ($area_nombre) {
                $where["are_nombre RLIKE '$area_nombre'"] = null;
            }
            $listado_areas = $this->estructura_organizativa_model->get_area_are($where);
            // print_r($this->db->last_query());die();
            echo json_encode($listado_areas);
        }
    }

}
?>