<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Mantenimientos extends CI_Controller {

    function __construct() {
        parent::__construct();
        $this->load->library('grocery_CRUD');
        $this->load->model('gsatelite');
    }

    function index() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $this->_cargarvista();
        }
    }

    function organigrama() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            try {
                $id_usuario = $this->tank_auth->get_user_id();

                $crud = new grocery_CRUD();
                $crud->set_table("org_organigrama");
                $crud->set_subject('Organigrama');
                $crud->columns("org_nombre", "org_estado");

                $crud->fields("org_nombre", "org_estado", "org_usu_creacion", "org_fecha_creacion", "org_usu_modificacion", "org_fecha_modificacion");

                $crud->field_type('org_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));

                $crud->display_as("org_nombre", "Nombre");
                $crud->display_as("org_estado", "Estado");
                $crud->required_fields("org_nombre", "org_estado");
                if (end(explode('/', uri_string())) == 'add') {
                    $crud->field_type('org_usu_creacion', 'hidden', $id_usuario);
                    $crud->field_type('org_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
                    $crud->field_type('org_usu_modificacion', 'hidden', $id_usuario);
                    $crud->field_type('org_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
                } else {
                    $crud->field_type('org_usu_creacion', 'hidden');
                    $crud->field_type('org_fecha_creacion', 'hidden');
                    $crud->field_type('org_usu_modificacion', 'hidden', $id_usuario);
                    $crud->field_type('org_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
                }
                $crud->set_rules('org_nombre', 'Nombre','trim|required|campo_unico[org_organigrama.org_nombre]');
                $output = $crud->render();
                cargarvista($data, $output, 'estructura_organizativa/mantenimientos/organigrama');
            } catch (Exception $e) {
                show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
            }
            
        }
    }

    /**
     * @author René Castaneda
     * @return Mantenimiento ubi_ubicacion
     */
    function ubicacion() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            try {
                $permisos = $this->gsatelite->get_permisos_opcion('estructura_organizativa/mantenimientos/ubicacion');
                $crud = new grocery_CRUD();
                $crud->set_table('ubi_ubicacion')
                ->set_subject('ubicación')
                ->columns('ubi_nombre', 'ubi_estado')
                ->fields('ubi_nombre', 'ubi_estado', 'ubi_usu_mod', 'ubi_fecha_mod')
                ->display_as('ubi_nombre', 'Nombre')
                ->display_as('ubi_estado', 'Estado')
                ->required_fields('ubi_nombre', 'ubi_estado')
                ->set_rules('ubi_nombre', 'Nombre', 'trim|required|campo_unico[ubi_ubicacion.ubi_nombre]')
                ->field_type('ubi_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('ubi_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                ;
                if (end(explode('/', uri_string())) == 'add') {
                    $crud->field_type('ubi_estado', 'hidden', 1);
                } else {
                    $crud->field_type('ubi_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
                }

                // Validaciones
                if (!$permisos['permite_agregar']) {
                    $crud->unset_add();
                }

                if (!$permisos['permite_editar']) {
                    $crud->unset_edit();
                }

                if (!$permisos['permite_eliminar']) {
                    $crud->unset_delete();
                }

                if ($permisos['permite_ver']) {
                    $crud->add_action('Ver', 'minia-icon-search', 'estructura_organizativa/mantenimientos/ubicacion/read');
                }
                $data['titulo_personal'] = "Ubicaciones";

                $output = $crud->render();
                $this->_cargarvista($data, $output);
            } catch (Exception $e) {
                show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
            }
        }
    }

    /**
     * @author René Castaneda / Luis Navarro (proceso de compartir funcionalidad 23-12-2017)
     * @return Mantenimiento cec_centro_costo
     * @description funcionalidad compartida en: inventario/mantenimiento (funcion: centros_costo )
     */
    function centro_costos($ruta=NULL, $url=NULL) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            try {
                $ruta = (trim($ruta) != '')? $ruta : 'estructura_organizativa/mantenimientos';
                $url  = (trim($url) != '')?  $url  : 'centro_costos';

                $url_array = explode('/', uri_string());//Added by Raul Escalante 18-08-2019
                $no_incluir = (is_numeric(end($url_array)) and end($url_array) > 0 ) ? end($url_array) : 0;

                $id_empresa = $this->tank_auth->get_empresa_id();
                $permisos = $this->gsatelite->get_permisos_opcion();

                $columns = array(
                    'cec_id',
                    'cec_codigo',
                    'cec_nombre', 
                    'cec_observacion',
                    'cec_defecto',
                    'cec_estado'
                );

                $display_as = array(
                    'cec_id' => 'ID',
                    'cec_codigo'      => 'Código',
                    'cec_nombre'      => 'Nombre',
                    'cec_observacion' => 'Observación',
                    'cec_cuenta_contable' => 'Cuenta Contable',
                    'cec_estado'      => 'Estado',
                    'cec_id_padre'    => 'Nivel Superior',
                    'cec_defecto'     => 'Defecto'
                );

                $required = array(
                    'cec_codigo', 
                    'cec_nombre', 
                    'cec_estado'
                );

                $fields = array(
                    'cec_id_padre',
                    'cec_codigo',
                    'cec_nombre', 
                    'cec_observacion',
                    'cec_defecto', 
                    'cec_estado', 
                    'cec_usu_mod', 
                    'cec_fecha_mod'
                );

                $crud = new grocery_CRUD();
                $crud->set_table('cec_centro_costo')
                ->set_subject('Centro de costo')
                ->columns($columns)
                ->fields($fields)
                ->display_as($display_as)
                ->required_fields($required)
                ->callback_add_field('cec_defecto', function() {
                    return '<input type="checkbox" id="chbdefecto" class="nostyle"><input type="hidden" id="field-cec_defecto" name="cec_defecto" value="0">';
                })
                ->callback_edit_field('cec_defecto', function($value, $primary_key) {
                    $leer    = ($this->uri->rsegments[3] == 'read')?'iButton':'';
                            $defecto = ($value)?'checked':''; // Verificar si esta activo
                            return '<input type="checkbox" id="chbdefecto" '.$defecto.' class="'.$leer.' nostyle"><input type="hidden" id="field-cec_defecto" name="cec_defecto" value="'.$value.'">';
                        })
                ->callback_column('cec_defecto', function($value, $row) {
                    $defecto = ($value == 1)?'SI':'';
                    return $defecto;
                })
                ->callback_before_insert(function($post_array){
                    $CI = & get_instance();
                    $CI->gsatelite->actualizar_array('cec_centro_costo', array('cec_defecto'=>0), array());
                    return $post_array;
                })
                ->callback_before_update(function($post_array){
                    $CI = & get_instance();
                    $CI->gsatelite->actualizar_array('cec_centro_costo', array('cec_defecto'=>0), array());
                    return $post_array;
                })
                ->set_rules('cec_nombre', 'Nombre', "trim|required|campo_unico2[cec_centro_costo.cec_nombre.cec_id_emr.$id_empresa]")
                ->set_rules('cec_codigo', 'Código', "trim|required|campo_unico2[cec_centro_costo.cec_codigo.cec_id_emr.$id_empresa]")
                ->field_type('cec_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('cec_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                ;
                //Added by Raul Escalante 18-08-2019
                $crud->set_relation('cec_id_padre', 'cec_centro_costo', '{cec_nombre}', array('cec_id !=' => $no_incluir));
                $urlx = explode('/', uri_string());
                if (end($urlx) == 'add') {
                    $crud->field_type('cec_estado', 'hidden', 1);
                } else {
                    $crud->field_type('cec_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
                }

                $crud->field_type('cec_id_emr', 'hidden', $id_empresa);

                 // Validaciones
                if (!$permisos['permite_agregar']) {
                    $crud->unset_add();
                }

                if (!$permisos['permite_editar']) {
                    $crud->unset_edit();
                }

                if (!$permisos['permite_eliminar']) {
                    $crud->unset_delete();
                }

                if (!$permisos['permite_ver']) {
                    $crud->unset_read();
                    //$crud->add_action('Ver', 'minia-icon-search', "$ruta/$url/read");
                }

                $data['titulo_personal'] = "Centro de costos";
                $crud->where('cec_centro_costo.cec_id_emr', $this->tank_auth->get_empresa_id()); //Added by René Castaneda 05-03-2018

                //Added by René Castaneda 08-03-2018
                //actualizar al id de empresa según la sessión del usuario (dado que es un cambio nuevo)
                $this->gsatelite->actualizar_empresa_id('cec_centro_costo');
                
                $output = $crud->render();
                // $this->_cargarvista($data, $output);
                cargarvista($data, $output, 'estructura_organizativa/mantenimientos/centro_costos');
            } catch (Exception $e) {
                show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
            }
        }
    }

    /**
     * @author René Castaneda
     * @return Mantenimiento pto_puesto
     */
    function puestos() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            try {

                $crud = new grocery_CRUD();
                $crud->set_table('pto_puesto')
                ->set_subject('puesto')
                ->columns('pto_nombre', 'pto_funcion', 'pto_estado')
                ->fields('pto_nombre', 'pto_funcion', 'pto_estado', 'pto_usu_mod', 'pto_fecha_mod')
                ->display_as('pto_nombre', 'Nombre')
                ->display_as('pto_estado', 'Estado')
                ->display_as('pto_funcion', 'Funciones')
                ->required_fields('pto_nombre', 'pto_estado', 'pto_usu_mod', 'pto_fecha_mod')
                ->set_rules('pto_nombre', 'Nombre', 'trim|required|campo_unico[pto_puesto.pto_nombre]')
                ->field_type('pto_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('pto_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                ->add_action('Anexos', '', 'estructura_organizativa/mantenimientos/anexos_puesto', 'icomoon-icon-stack')
                ->unset_delete()
                ;
                if (end(explode('/', uri_string())) == 'add') {
                    $crud->field_type('pto_estado', 'hidden', 1);
                } else {
                    $crud->field_type('pto_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
                }
                $data['titulo_personal'] = "Puestos";
                $crud->callback_add_field('pto_funcion', function () {
                    return '<textarea maxlength="300" value="" name="pto_funcion"></textarea>';
                });
                $output = $crud->render();
                $this->_cargarvista($data, $output);
            } catch (Exception $e) {
                show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
            }
        }
    }

    /**
     * @author René Castaneda
     * @return Mantenimiento axp_anexoxpuesto
     */
    function anexos_puesto($id_puesto = null) {
        satelite_validar();
        $this->gsatelite->verificar_registro_real('pto_puesto', $id_puesto);
        $crud = new grocery_CRUD();
        $this->load->config('grocery_crud');
        $this->config->set_item('grocery_crud_file_upload_allow_file_types', 'pdf|jpeg|jpg|png|doc|xls|ppt');

        $crud->set_table('axp_anexoxpuesto')
        ->set_subject('Anexo Puesto')
        ->where('axp_anexoxpuesto.axp_id_pto', $id_puesto)
        ->columns('axp_id_pto', 'axp_nombre', 'axp_url', 'axp_estado')
        ->set_relation('axp_id_pto', 'pto_puesto', 'pto_nombre')
        ->fields('axp_id_pto', 'axp_nombre', 'axp_url', 'axp_estado', 'axp_usu_mod', 'axp_fecha_mod')
        ->display_as('axp_id_pto', 'Puesto')
        ->display_as('axp_nombre', 'Nombre')
        ->display_as('axp_url', 'Anexo')
        ->display_as('axp_estado', 'Estado')
        ->required_fields('axp_id_pto', 'axp_nombre', 'axp_url', 'axp_estado')
        ->set_rules('axp_nombre', 'Nombre', 'trim|required|campo_unico[axp_anexoxpuesto.axp_nombre]')
        ->field_type('axp_id_pto', 'hidden', $id_puesto)
        ->field_type('axp_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'))
        ->field_type('axp_usu_mod', 'hidden', $this->tank_auth->get_user_id())
        ->field_type('axp_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
        ->set_field_upload('axp_url', 'uploads/anexos_puesto')
        ->unset_print()
        ->unset_delete()
        ->unset_export()
        ;

        $data['titulo_personal'] = "ANEXOS PUESTO";
        $output = $crud->render();
        $this->_cargarvista($data, $output);
    }

    /**
     * @author René Castaneda
     * @return Mantenimiento prv_periodo_vacacion
     */
    function periodos_vacacion() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            try {

                $crud = new grocery_CRUD();
                $crud->set_table('prv_periodo_vacacion')
                ->set_subject('Periodos Vacación')
                ->columns('prv_nombre', 'prv_desde', 'prv_hasta', 'prv_estado')
                ->fields('prv_nombre', 'prv_desde', 'prv_hasta', 'prv_estado', 'prv_usu_mod', 'prv_fecha_mod')
                ->display_as('prv_nombre', 'Nombre')
                ->display_as('prv_desde', 'Desde')
                ->display_as('prv_hasta', 'Hasta')
                ->display_as('prv_estado', 'Estado')
                ->required_fields('prv_nombre', 'prv_desde', 'prv_hasta', 'prv_estado')
                ->set_rules('prv_nombre', 'Nombre', 'trim|required|campo_unico[prv_periodo_vacacion.prv_nombre]')
                ->set_rules('prv_desde', 'Desde', 'trim|callback_validacion_fechas|required')
                ->field_type('prv_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'))
                ->field_type('prv_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('prv_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                ->unset_delete()
                ;
                $data['titulo_personal'] = "PERIODOS DE VACACIÓN";

                $output = $crud->render();
                $this->_cargarvista($data, $output);
            } catch (Exception $e) {
                show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
            }
        }
    }

    public function validacion_fechas($data) {
//   die(print_r($_POST));
        if ($data != '') {
            $validado1 = false; //variable que cambiará de valor cuando no se cumpla una condición de validación
            $validado2 = false; //variable que cambiará de valor cuando no se cumpla la segunda condición de validación

            $f1 = $this->input->post('prv_desde');
            $f2 = $this->input->post('prv_hasta');
            $n_dias = $this->gsatelite->get_intervalo_dias($f1, $f2);
            if ($n_dias > 0) {
                $validado1 = true;
            } //primera condición
            else {
                $this->form_validation->set_message('validacion_fechas', 'Fecha desde debe ser menor a fecha hasta');
                return false;
            }

            //PREGUNTAR SI EXISTEN REGISTROS DE FECHA DESDE MAYOR A LA INGRESADA. (PARA EVITAR REGISTRO CRUZADOS) 
            $url_array = explode('/', uri_string()); //en el caso de edit
            $no_incluir = (is_numeric(end($url_array)) and end($url_array) > 0 ) ? end($url_array) : 0;
            $pregunta = $this->gsatelite->get_tabla('prv_periodo_vacacion', array('prv_id !=' => $no_incluir, 'prv_hasta >=' => date('Y-m-d', strtotime($f1))));
            if (count($pregunta) > 0) {
                $this->form_validation->set_message('validacion_fechas', 'Ya existen otros periodos que contienen la fecha desde');
                return false;
            } else {
                $validado2 = true;
            }

            return ($validado1 and $validado2) ? true : false;
        } else {
            return true;
        }
    }

    function _cargarvista($data = 0, $crud = 0) {


        $this->load->view('vacia', $crud);
        if ($data != 0)
            $data = array_merge($data, $this->masterpage->getUsuario());
        else
            $data = $this->masterpage->getUsuario();
        $vista = $data['modulo'] . '/' . $data['control'] . '/' . $data['funcion'];        
        $this->masterpage->setMasterPage('masterpage_default');
        $this->masterpage->addContentPage($vista, 'content', $data);
        $this->masterpage->show();
    }

    public function espacios_trabajo() {
        satelite_validar();

        $permisos = $this->gsatelite->get_permisos_opcion('estructura_organizativa/mantenimientos/espacios_trabajo');

        $crud = new grocery_CRUD;

        $alias = array(
            'ept_nombre' => 'Nombre',
            'ept_estado' => 'Estado'
        );

        $colums = array(
            'ept_nombre',
            'ept_estado'
        );

        $add = array(
            'ept_nombre',
            'ept_estado',
            'ept_usu_creacion',
            'ept_fecha_creacion',
            'ept_usu_modificacion',
            'ept_fecha_modificacion'
        );

        $edit = array(
            'ept_nombre',
            'ept_estado',
            'ept_usu_modificacion',
            'ept_fecha_modificacion'
        );

        $crud->set_table('ept_espacio_trabajo')
        ->set_subject('Espacios de trabajo')
        ->display_as($alias)
        ->columns($colums)
        ->add_fields($add)
        ->edit_fields($edit)
        ->required_fields($add)
        ->field_type('ept_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
        ->field_type('ept_fecha_modificacion', 'hidden', date('Y-m-d h:i:s'))
        ->unset_print()
        ->unset_export()
        ;
        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('ept_estado', 'hidden', 1)
            ->field_type('ept_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
            ->field_type('ept_fecha_creacion', 'hidden', date('Y-m-d h:i:s'));
        } else {
            $crud->field_type('ept_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

        // Validaciones
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }

        if (!$permisos['permite_editar']) {
            $crud->unset_edit();
        }
        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }
        if ($permisos['permite_ver']) {
            $crud->add_action('Ver', 'minia-icon-search', 'estructura_organizativa/mantenimientos/espacios_trabajo/read');
        }

        $output = $crud->render();
        $data['titulo_personal'] = 'Espacios de trabajo';
        $this->_cargarvista($data, $output);
    }

    public function herramientas_trabajo() {
        satelite_validar();

        $permisos = $this->gsatelite->get_permisos_opcion('estructura_organizativa/mantenimientos/herramientas_trabajo');

        $crud = new grocery_CRUD;

        $alias = array(
            'hrt_nombre' => 'Nombre',
            'hrt_estado' => 'Estado'
        );

        $colums = array(
            'hrt_nombre',
            'hrt_estado'
        );

        $add = array(
            'hrt_nombre',
            'hrt_estado',
            'hrt_usu_creacion',
            'hrt_fecha_creacion',
            'hrt_usu_modificacion',
            'hrt_fecha_modificacion'
        );

        $edit = array(
            'hrt_nombre',
            'hrt_estado',
            'hrt_usu_modificacion',
            'hrt_fecha_modificacion'
        );

        $crud->set_table('hrt_herramienta_trabajo')
        ->set_subject('herramientas de trabajo')
        ->display_as($alias)
        ->columns($colums)
        ->add_fields($add)
        ->edit_fields($edit)
        ->required_fields($add)
        ->field_type('hrt_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
        ->field_type('hrt_fecha_modificacion', 'hidden', date('Y-m-d h:i:s'))
        ->unset_print()
        ->unset_export()
        ;
        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('hrt_estado', 'hidden', 1)
            ->field_type('hrt_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
            ->field_type('hrt_fecha_creacion', 'hidden', date('Y-m-d h:i:s'));
        } else {
            $crud->field_type('hrt_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

        // Validaciones
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }

        if (!$permisos['permite_editar']) {
            $crud->unset_edit();
        }

        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }

        if ($permisos['permite_ver']) {
            $crud->add_action('Ver', 'minia-icon-search', 'estructura_organizativa/mantenimientos/herramientas_trabajo/read');
        }

        $output = $crud->render();
        $data['titulo_personal'] = 'Herramientas de trabajo';
        $this->_cargarvista($data, $output);
    }

    public function nivel_riesgo() {
        satelite_validar();

        $permisos = $this->gsatelite->get_permisos_opcion('estructura_organizativa/mantenimientos/nivel_riesgo');

        $crud = new grocery_CRUD;

        $alias = array(
            'nir_nombre' => 'Nombre',
            'nir_estado' => 'Estado'
        );

        $colums = array(
            'nir_nombre',
            'nir_estado'
        );

        $add = array(
            'nir_nombre',
            'nir_estado',
            'nir_usu_creacion',
            'nir_fecha_creacion',
            'nir_usu_modificacion',
            'nir_fecha_modificacion'
        );

        $edit = array(
            'nir_nombre',
            'nir_estado',
            'nir_usu_modificacion',
            'nir_fecha_modificacion'
        );

        $crud->set_table('nir_nivel_riesgo')
        ->set_subject('Nivel de Riesgo')
        ->display_as($alias)
        ->columns($colums)
        ->add_fields($add)
        ->edit_fields($edit)
        ->required_fields($add)
        ->field_type('nir_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
        ->field_type('nir_fecha_modificacion', 'hidden', date('Y-m-d h:i:s'))
        ->set_rules('nir_nombre', 'Nombre', 'trim|required|campo_unico[nir_nivel_riesgo.nir_nombre]')
        ->unset_print()
        ->unset_export()
        ;
        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('nir_estado', 'hidden', 1)
            ->field_type('nir_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
            ->field_type('nir_fecha_creacion', 'hidden', date('Y-m-d h:i:s'));
        } else {
            $crud->field_type('nir_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

        // Validaciones
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }

        if (!$permisos['permite_editar']) {
            $crud->unset_edit();
        }

        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }

        if ($permisos['permite_ver']) {
            $crud->add_action('Ver', 'minia-icon-search', 'estructura_organizativa/mantenimientos/nivel_riesgo/read');
        }

        $output = $crud->render();
        $data['titulo_personal'] = 'Niveles de riesgo';
        $this->_cargarvista($data, $output);
    }

    public function porcentaje_tiempo() {

        satelite_validar();

        $permisos = $this->gsatelite->get_permisos_opcion('estructura_organizativa/mantenimientos/porcentaje_tiempo');

        $crud = new grocery_CRUD;

        $alias = array(
            'pot_porcentaje' => 'Porcentaje de tiempo',
            'pot_estado' => 'Estado'
        );

        $colums = array(
            'pot_porcentaje',
            'pot_estado'
        );

        $add = array(
            'pot_porcentaje',
            'pot_estado',
            'pot_usu_creacion',
            'pot_fecha_creacion',
            'pot_usu_modificacion',
            'pot_fecha_modificacion'
        );

        $edit = array(
            'pot_porcentaje',
            'pot_estado',
            'pot_usu_modificacion',
            'pot_fecha_modificacion'
        );

        $crud->set_table('pot_porcentaje_tiempo')
        ->set_subject('Porcentaje de tiempo')
        ->display_as($alias)
        ->columns($colums)
        ->add_fields($add)
        ->edit_fields($edit)
        ->required_fields($add)
        ->field_type('pot_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
        ->field_type('pot_fecha_modificacion', 'hidden', date('Y-m-d h:i:s'))
        ->unset_print()
        ->unset_export()
        ;
        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('pot_estado', 'hidden', 1)
            ->field_type('pot_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
            ->field_type('pot_fecha_creacion', 'hidden', date('Y-m-d h:i:s'));
        } else {
            $crud->field_type('pot_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

        // Validaciones
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }

        if (!$permisos['permite_editar']) {
            $crud->unset_edit();
        }

        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }

        if ($permisos['permite_ver']) {
            $crud->add_action('Ver', 'minia-icon-search', 'estructura_organizativa/mantenimientos/porcentaje_tiempo/read');
        }

        $output = $crud->render();
        $data['titulo_personal'] = 'Porcentaje de tiempo';
        $this->_cargarvista($data, $output);
    }

    public function areas_claves_resultado() {

        satelite_validar();

        $permisos = $this->gsatelite->get_permisos_opcion('estructura_organizativa/mantenimientos/areas_claves_resultado');

        $crud = new grocery_CRUD;

        $alias = array(
            'acl_nombre' => 'Nombre',
            'acl_estado' => 'Estado'
        );

        $colums = array(
            'acl_nombre',
            'acl_estado'
        );

        $add = array(
            'acl_nombre',
            'acl_estado',
            'acl_usu_creacion',
            'acl_fecha_creacion',
            'acl_usu_modificacion',
            'acl_fecha_modificacion'
        );

        $edit = array(
            'acl_nombre',
            'acl_estado',
            'acl_usu_modificacion',
            'acl_fecha_modificacion'
        );

        $crud->set_table('acl_area_clave_resultado')
        ->set_subject('Área clave de resultado')
        ->display_as($alias)
        ->columns($colums)
        ->add_fields($add)
        ->edit_fields($edit)
        ->required_fields($add)
        ->field_type('acl_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
        ->field_type('acl_fecha_modificacion', 'hidden', date('Y-m-d h:i:s'))
        ->unset_print()
        ->unset_export()
        ;
        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('acl_estado', 'hidden', 1)
            ->field_type('acl_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
            ->field_type('acl_fecha_creacion', 'hidden', date('Y-m-d h:i:s'));
        } else {
            $crud->field_type('acl_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

        // Validaciones
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }

        if (!$permisos['permite_editar']) {
            $crud->unset_edit();
        }

        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }

        if ($permisos['permite_ver']) {
            $crud->add_action('Ver', 'minia-icon-search', 'estructura_organizativa/mantenimientos/areas_claves_resultado/read');
        }

        $output = $crud->render();
        $data['titulo_personal'] = 'Áreas Claves de resultado';
        $this->_cargarvista($data, $output);
    }

    public function competencias() {

        satelite_validar();

        $permisos = $this->gsatelite->get_permisos_opcion('estructura_organizativa/mantenimientos/competencias');

        $crud = new grocery_CRUD;

        $alias = array(
            'com_nombre' => 'Nombre',
            'com_estado' => 'Estado'
        );

        $colums = array(
            'com_nombre',
            'com_estado'
        );

        $add = array(
            'com_nombre',
            'com_estado',
            'com_usu_creacion',
            'com_fecha_creacion',
            'com_usu_modificacion',
            'com_fecha_modificacion'
        );

        $edit = array(
            'com_nombre',
            'com_estado',
            'com_usu_modificacion',
            'com_fecha_modificacion'
        );

        $crud->set_table('com_competencia')
        ->set_subject('Competencia')
        ->display_as($alias)
        ->columns($colums)
        ->add_fields($add)
        ->edit_fields($edit)
        ->required_fields($add)
        ->field_type('com_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
        ->field_type('com_fecha_modificacion', 'hidden', date('Y-m-d h:i:s'))
        ->unset_print()
        ->unset_export()
        ;
        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('com_estado', 'hidden', 1)
            ->field_type('com_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
            ->field_type('com_fecha_creacion', 'hidden', date('Y-m-d h:i:s'));
        } else {
            $crud->field_type('com_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

        // Validaciones
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }

        if (!$permisos['permite_editar']) {
            $crud->unset_edit();
        }

        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }

        if ($permisos['permite_ver']) {
            $crud->add_action('Ver', 'minia-icon-search', 'estructura_organizativa/mantenimientos/competencias/read');
        }

        $output = $crud->render();
        $data['titulo_personal'] = 'Competencias';
        $this->_cargarvista($data, $output);
    }

    public function clasificaciones() {

        satelite_validar();

        $permisos = $this->gsatelite->get_permisos_opcion('estructura_organizativa/mantenimientos/clasificaciones');

        $crud = new grocery_CRUD;

        $alias = array(
            'cls_nombre' => 'Porcentaje',
            'cls_estado' => 'Estado'
        );

        $colums = array(
            'cls_nombre',
            'cls_estado'
        );

        $add = array(
            'cls_nombre',
            'cls_estado',
            'cls_usu_creacion',
            'cls_fecha_creacion',
            'cls_usu_modificacion',
            'cls_fecha_modificacion'
        );

        $edit = array(
            'cls_nombre',
            'cls_estado',
            'cls_usu_modificacion',
            'cls_fecha_modificacion'
        );

        $crud->set_table('cls_clasificacion')
        ->set_subject('Clasificación')
        ->display_as($alias)
        ->columns($colums)
        ->add_fields($add)
        ->edit_fields($edit)
        ->required_fields($add)
        ->field_type('cls_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
        ->field_type('cls_fecha_modificacion', 'hidden', date('Y-m-d h:i:s'))
        ->unset_print()
        ->unset_export()
        ;
        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('cls_estado', 'hidden', 1)
            ->field_type('cls_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
            ->field_type('cls_fecha_creacion', 'hidden', date('Y-m-d h:i:s'));
        } else {
            $crud->field_type('cls_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

        // Validaciones
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }

        if (!$permisos['permite_editar']) {
            $crud->unset_edit();
        }

        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }

        if ($permisos['permite_ver']) {
            $crud->add_action('Ver', 'minia-icon-search', 'estructura_organizativa/mantenimientos/clasificaciones/read');
        }

        $output = $crud->render();
        $data['titulo_personal'] = 'Clasificaciones';
        $this->_cargarvista($data, $output);
    }
    
    public function funciones() {
        satelite_validar();

        $permisos = $this->gsatelite->get_permisos_opcion('estructura_organizativa/mantenimientos/funciones');

        $crud = new grocery_CRUD;

        $alias = array(
            'fun_nombre' => 'Nombre',
            'fun_estado' => 'Estado'
        );

        $colums = array(
            'fun_nombre',
            'fun_estado'
        );

        $add = array(
            'fun_nombre',
            'fun_estado',
            'fun_usu_creacion',
            'fun_fecha_creacion',
            'fun_usu_modificacion',
            'fun_fecha_modificacion'
        );

        $edit = array(
            'fun_nombre',
            'fun_estado',
            'fun_usu_modificacion',
            'fun_fecha_modificacion'
        );

        $crud->set_table('fun_funcion')
        ->set_subject('Funciones')
        ->display_as($alias)
        ->columns($colums)
        ->add_fields($add)
        ->edit_fields($edit)
        ->required_fields($add)
        ->field_type('fun_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
        ->field_type('fun_fecha_modificacion', 'hidden', date('Y-m-d h:i:s'))
        ->set_rules('fun_nombre', 'Nombre', 'trim|required|campo_unico[fun_funcion.fun_nombre]')
        ->unset_print()
        ->unset_export()
        ;

        $crud->change_field_type('fun_nombre', 'text'); // Se cambio el tipo de campo a text area

        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('fun_estado', 'hidden', 1)
            ->field_type('fun_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
            ->field_type('fun_fecha_creacion', 'hidden', date('Y-m-d h:i:s'));
        } else {
            $crud->field_type('fun_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

        // Validaciones
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }

        if (!$permisos['permite_editar']) {
            $crud->unset_edit();
        }

        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }

        if ($permisos['permite_ver']) {
            $crud->add_action('Ver', 'minia-icon-search', 'estructura_organizativa/mantenimientos/funciones/read');
        }

        $output = $crud->render();
        $data['titulo_personal'] = 'Funciones plaza / cargo funcional';
        $this->_cargarvista($data, $output);
    }
    
    public function tipo_riesgo() {
        satelite_validar();

        $permisos = $this->gsatelite->get_permisos_opcion('estructura_organizativa/mantenimientos/tipo_riesgo');

        $crud = new grocery_CRUD;

        $alias = array(
            'tri_nombre' => 'Nombre',
            'tri_estado' => 'Estado'
        );

        $colums = array(
            'tri_nombre',
            'tri_estado'
        );

        $add = array(
            'tri_nombre',
            'tri_estado',
            'tri_usu_creacion',
            'tri_fecha_creacion',
            'tri_usu_modificacion',
            'tri_fecha_modificacion'
        );

        $edit = array(
            'tri_nombre',
            'tri_estado',
            'tri_usu_modificacion',
            'tri_fecha_modificacion'
        );

        $crud->set_table('tri_tipo_riesgo')
        ->set_subject('Tipo de riesgo')
        ->display_as($alias)
        ->columns($colums)
        ->add_fields($add)
        ->edit_fields($edit)
        ->required_fields($add)
        ->field_type('tri_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
        ->field_type('tri_fecha_modificacion', 'hidden', date('Y-m-d h:i:s'))
        ->set_rules('tri_nombre', 'Nombre', 'trim|required|campo_unico[tri_tipo_riesgo.tri_nombre]')
        ->unset_print()
        ->unset_export()
        ;
        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('tri_estado', 'hidden', 1)
            ->field_type('tri_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
            ->field_type('tri_fecha_creacion', 'hidden', date('Y-m-d h:i:s'));
        } else {
            $crud->field_type('tri_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

        // Validaciones
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }

        if (!$permisos['permite_editar']) {
            $crud->unset_edit();
        }

        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }

        if ($permisos['permite_ver']) {
            $crud->add_action('Ver', 'minia-icon-search', 'estructura_organizativa/mantenimientos/tipo_riesgo/read');
        }

        $output = $crud->render();
        $data['titulo_personal'] = 'Tipos de riesgo';
        $this->_cargarvista($data, $output);
    }
    
    public function prestaciones() {
        satelite_validar();

        $permisos = $this->gsatelite->get_permisos_opcion('estructura_organizativa/mantenimientos/prestaciones');

        $crud = new grocery_CRUD;

        $alias = array(
            'prt_nombre' => 'Nombre',
            'prt_estado' => 'Estado'
        );

        $colums = array(
            'prt_nombre',
            'prt_estado'
        );

        $add = array(
            'prt_nombre',
            'prt_estado',
            'prt_usu_creacion',
            'prt_fecha_creacion',
            'prt_usu_modificacion',
            'prt_fecha_modificacion'
        );

        $edit = array(
            'prt_nombre',
            'prt_estado',
            'prt_usu_modificacion',
            'prt_fecha_modificacion'
        );

        $crud->set_table('prt_prestacion')
        ->set_subject('Prestación')
        ->display_as($alias)
        ->columns($colums)
        ->add_fields($add)
        ->edit_fields($edit)
        ->required_fields($add)
        ->field_type('prt_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
        ->field_type('prt_fecha_modificacion', 'hidden', date('Y-m-d h:i:s'))
        ->set_rules('prt_nombre', 'Nombre', 'trim|required|campo_unico[prt_prestacion.prt_nombre]')
        ->unset_print()
        ->unset_export()
        ;
        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('prt_estado', 'hidden', 1)
            ->field_type('prt_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
            ->field_type('prt_fecha_creacion', 'hidden', date('Y-m-d h:i:s'));
        } else {
            $crud->field_type('prt_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

        // Validaciones
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }

        if (!$permisos['permite_editar']) {
            $crud->unset_edit();
        }

        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }

        if ($permisos['permite_ver']) {
            $crud->add_action('Ver', 'minia-icon-search', 'estructura_organizativa/mantenimientos/prestaciones/read');
        }

        $output = $crud->render();
        $data['titulo_personal'] = 'Prestaciones';
        $this->_cargarvista($data, $output);
    }

    /**
     * @author Elman Ortiz
     * @return Mantenimiento tipo de prefesiones
     * @internal Esta funcion tambien esta en controllers/expediente_personal/catalogos
     */
    public function profesiones() {        
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $permisos = $this->gsatelite->get_permisos_opcion('estructura_organizativa/mantenimientos/profesiones');
            $crud = new grocery_CRUD();
            $crud->set_subject('Profesión')->set_table('pro_profesion');
            $crud->columns('pro_nombre', 'pro_estado');
            $crud->display_as('pro_nombre', 'Nombre');
            $crud->display_as('pro_estado', 'Estado');
            $crud->fields('pro_nombre', 'pro_estado', 'pro_usu_mod', 'pro_fecha_mod', 'pro_usu_crea', 'pro_fecha_crea');
            $crud->required_fields('pro_nombre', 'pro_estado');
            $crud->set_rules('pro_nombre', 'Nombre', 'trim|required|campo_unico[pro_profesion.pro_nombre]');
            $crud->field_type('pro_fecha_mod', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('pro_usu_mod', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('pro_fecha_crea', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('pro_usu_crea', 'hidden', $this->tank_auth->get_user_id());

            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('pro_estado', 'hidden', 1);
            } else {
                $crud->field_type('pro_estado', 'dropdown', array('1' => 'Activado', '0' => 'Desactivado'));
            }

            if(!$permisos["permite_editar"]){
                $crud->unset_edit();
            }
            if(!$permisos["permite_eliminar"]){
                $crud->unset_delete();
            }
            if(!$permisos["permite_agregar"]){
                $crud->unset_add();
            }            
            if($permisos["permite_ver"]){
                $crud->add_action('&nbsp;&nbsp;Ver', '', 'estructura_organizativa/mantenimientos/profesiones/read','icomoon-icon-search-3');
            }

            $output = $crud->render();            
            $data['titulo_personal'] = "Profesiones";                        
            $this->_cargarvista($data, $output);            
        }
    }//fin funcion prefesiones

    public function genero() {
        satelite_validar();
        try {
            $permisos = $this->gsatelite->get_permisos_opcion('estructura_organizativa/mantenimientos/genero');
            $crud = new grocery_CRUD();
            $crud->unset_export();
            $crud->unset_print();
            $crud->set_table('gen_genero');
            $crud->set_subject('Género');

            $columnas = array(
                'gen_nombre',
                'gen_estado'
            );

            $add_fields = array(
                'gen_nombre',
                'gen_estado',
                'gen_usu_creacion',
                'gen_usu_modificacion',
                'gen_fecha_creacion',
                'gen_fecha_modificacion'
            );

            $edit_fields = array(
                'gen_nombre',
                'gen_estado',
                'gen_usu_modificacion',
                'gen_fecha_modificacion'
            );

            $required_fields = array(
                'gen_nombre',
                'gen_estado',
                'gen_usu_creacion',
                'gen_usu_modificacion',
                'gen_fecha_creacion',
                'gen_fecha_modificacion'
            );

            $display_as = array(
                'gen_nombre' => 'Nombre',
                'gen_estado' => 'Estado'
            );

            $crud->required_fields($required_fields);
            $crud->columns($columnas);
            $crud->add_fields($add_fields);
            $crud->edit_fields($edit_fields);
            $crud->display_as($display_as);
            $crud->field_type('gen_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('gen_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));

            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('gen_estado', 'hidden', 1)
                ->field_type('gen_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('gen_fecha_creacion', 'hidden', date('Y-m-d h:i:s'));
            } else {
                $crud->field_type('gen_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if ($permisos['permite_ver']) {
                $crud->add_action('Ver', 'minia-icon-search', 'estructura_organizativa/mantenimientos/genero/read');
            }

            $output = $crud->render();
            $data['titulo_personal'] = "Catálogo de Género";
            $this->_cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    /**
     * @author Elman Ortiz
     * @return Mantenimiento tipo de educacion
     * @internal esta funcion tambien esta en controllers/registro_academico/mantenimientos
     */
    public function tipo_educacion($value = null) {
        satelite_validar();
        try {
            $crud = new grocery_CRUD();

            if($value != null){
                $permisos = $value;
            } else{
                $permisos = $this->gsatelite->get_permisos_opcion('estructura_organizativa/mantenimientos/tipo_educacion');
            }

            $columnas = array(
                'tie_nombre',
                'tie_estado'
            );

            $required = array(
                'tie_nombre',
                'tie_estado'
            );

            $alias = array(
                'tie_nombre' => 'Nombre',
                'tie_estado' => 'Estado'
            );

            $columnas_insert = array(
                'tie_nombre',
                'tie_estado',
                'tie_usu_crea',
                'tie_fecha_crea',
                'tie_usu_mod',
                'tie_fecha_mod'
            );

            $columnas_update = array(
                'tie_nombre',
                'tie_estado',
                'tie_usu_crea',
                'tie_fecha_crea',
                'tie_usu_mod',
                'tie_fecha_mod'
            );

            $crud->set_table('tie_tipo_educacion')
            ->set_subject('Nivel educativo')
            ->columns($columnas)
            ->display_as($alias)
            ->add_fields($columnas_insert)
            ->edit_fields($columnas_update)
            ->required_fields($required)
            ->set_rules('tie_nombre', 'Nombre', 'trim|required|campo_unico[tie_tipo_educacion.tie_nombre]')
            ->field_type('tie_usu_mod', 'hidden', $this->tank_auth->get_user_id())
            ->field_type('tie_fecha_mod', 'hidden', date('Y-m-d h:i:s'))
            ->field_type('tie_fecha_crea', 'hidden', date('Y-m-d h:i:s'))
            ->field_type('tie_usu_crea', 'hidden', $this->tank_auth->get_user_id())
            ;

            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('tie_estado', 'hidden', 1);
            } else {
                $crud->field_type('tie_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            //permisos
            if(!$permisos["permite_editar"]){
                $crud->unset_edit();
            }
            if(!$permisos["permite_eliminar"]){
                $crud->unset_delete();
            }
            if(!$permisos["permite_agregar"]){
                $crud->unset_add();
            }
            if($permisos["permite_ver"]){
                $crud->add_action('&nbsp;&nbsp;Ver', '', 'estructura_organizativa/mantenimientos/tipo_educacion/read','icomoon-icon-search-3');
            }

            $output = $crud->render();

            $data['titulo_personal'] = "Nivel educativo";

            $this->_cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    /**
     * @author Elman Ortiz
     * @return Mantenimiento detalle de horario
     * @internal Esta funcion tambien esta en controllers/marcacion/mantenimientos
     */
    public function detalle_horario() 
    {        
     if (!$this->tank_auth->is_logged_in()) {
         redirect('/auth/login/');
     } else {
         try
         {    
            $permisos = $this->gsatelite->get_permisos_opcion('estructura_organizativa/mantenimientos/detalle_horario');
                   //$dias_semana=array('Lunes'=>'Lunes','Martes'=>'Martes','Miércoles'=>'Miércoles','Jueves'=>'Jueves','Viernes'=>'Viernes','Sábado'=>'Sábado','Domingo'=>'Domingo');
            $crud = new grocery_CRUD();
            $crud->set_table('deh_detalle_horario')
            ->set_subject('Detalle de horarios')
            ->columns('deh_hora_entrada', 'deh_hora_salida', 'deh_estado')
            ->fields('deh_hora_entrada', 'deh_hora_salida', 'deh_estado','deh_usu_mod','deh_fecha_mod')
            ->display_as('deh_hora_entrada', 'Hora entrada')
            ->display_as('deh_hora_salida', 'Hora salida')
            ->display_as('deh_estado', 'Estado')
            ->required_fields('deh_hora_entrada', 'deh_hora_salida', 'deh_estado','deh_usu_mod','deh_fecha_mod');
                   if($this->gsatelite->get_parametro('SYS_IDENTIFICADOR_EMPRESA')!=2) { //en caso de que sea emi omitir la validacion por los turnos que traspasan dos dias
                   //    $crud->set_rules('deh_hora_entrada','Hora entrada','trim|callback_validacion_tiempo|required');
                   }     
                   $crud->field_type('deh_estado','dropdown',array('1' => 'Activado', '0' => 'Desactivado'))
                   ->field_type('deh_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                   ->field_type('deh_fecha_mod', 'hidden', date('Y-m-d H:i:s'))                        
                   ;
                   if(end(explode('/',uri_string()))=='add') {
                    $crud->field_type('deh_estado','hidden',1);
                }
                else {
                    $crud->field_type('deh_estado','dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
                }

                     // Validaciones                    
                if (!$permisos['permite_agregar']) {
                    $crud->unset_add();
                }

                if (!$permisos['permite_editar']) {
                    $crud->unset_edit();
                }

                if (!$permisos['permite_eliminar']) {
                    $crud->unset_delete();
                }

                if (!$permisos['permite_ver']) {
                    $crud->unset_read();
                }

                $data['titulo_personal'] = "Detalle de horarios";

                $output = $crud->render();
                $this->_cargarvista($data,$output);
            }
            catch(Exception $e)
            {
             show_error($e->getMessage().' --- '.$e->getTraceAsString());
         }

     }
       }//Fin detalle horario


    public function budget_unit() {
        satelite_validar();
        try {
            $permisos = $this->gsatelite->get_permisos_opcion();
            $urlx = explode('/', uri_string());
            $crud = new grocery_CRUD();
            $columnas = array(
                'unp_nombre',
                'unp_estado'
            );
            $required = array(
                'unp_nombre',
                'unp_estado'
            );
            $alias = array(
                'unp_codigo' => 'Código',
                'unp_nombre' => 'Nombre',
                'unp_estado' => 'Estado'
            );
            $columnas_insert = array(
                'unp_codigo',
                'unp_nombre',
                'unp_estado',
                'unp_usu_creacion',
                'unp_usu_modifiacion',
                'unp_fecha_creacion',
                'unp_fecha_modificacion'
            );
            $columnas_update = array(
                'unp_codigo',
                'unp_nombre',
                'unp_estado',
                'unp_usu_modifiacion',
                'unp_fecha_modificacion'
            );
            $crud->set_table('unp_unidad_presupuestaria')
                ->set_subject('')
                ->columns($columnas)
                ->display_as($alias)
                ->add_fields($columnas_insert)
                ->edit_fields($columnas_update)
                ->required_fields($required)
                ->set_rules('unp_nombre', 'Nombre', 'trim|required|campo_unico[unp_unidad_presupuestaria.unp_nombre]')
                ->field_type('unp_usu_modifiacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('unp_fecha_modificacion', 'hidden', date('Y-m-d h:i:s'))
            ;

            if (end($urlx) == 'add') {
                $crud->field_type('unp_estado', 'hidden', 1)
                    ->field_type('unp_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('unp_fecha_creacion', 'hidden', date('Y-m-d h:i:s'))
                ;
            } else {
                $crud->field_type('unp_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if (!$permisos['permite_ver']) {
                $crud->unset_read();
            }
            $output = $crud->render();
            $data['titulo_personal'] = "Unidad Presupuestaria";
            $this->_cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    public function work_line() {
        satelite_validar();
        try {
            $permisos = $this->gsatelite->get_permisos_opcion();
            $urlx = explode('/', uri_string());
            $crud = new grocery_CRUD();
            $columnas = array(
                'lnt_nombre',
                'lnt_estado'
            );
            $required = array(
                'lnt_nombre',
                'lnt_estado'
            );
            $alias = array(
                'lnt_codigo' => 'Código',
                'lnt_nombre' => 'Nombre',
                'lnt_estado' => 'Estado'
            );
            $columnas_insert = array(
                'lnt_codigo',
                'lnt_nombre',
                'lnt_estado',
                'lnt_usu_creacion',
                'lnt_usu_modifiacion',
                'lnt_fecha_creacion',
                'lnt_fecha_modificacion'
            );
            $columnas_update = array(
                'lnt_codigo',
                'lnt_nombre',
                'lnt_estado',
                'lnt_usu_modifiacion',
                'lnt_fecha_modificacion'
            );
            $crud->set_table('lnt_linea_trabajo')
                ->set_subject('')
                ->columns($columnas)
                ->display_as($alias)
                ->add_fields($columnas_insert)
                ->edit_fields($columnas_update)
                ->required_fields($required)
                ->set_rules('lnt_nombre', 'Nombre', 'trim|required|campo_unico[lnt_linea_trabajo.lnt_nombre]')
                ->field_type('lnt_usu_modifiacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('lnt_fecha_modificacion', 'hidden', date('Y-m-d h:i:s'))
            ;

            if (end($urlx) == 'add') {
                $crud->field_type('lnt_estado', 'hidden', 1)
                    ->field_type('lnt_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('lnt_fecha_creacion', 'hidden', date('Y-m-d h:i:s'))
                ;
            } else {
                $crud->field_type('lnt_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if (!$permisos['permite_ver']) {
                $crud->unset_read();
            }
            $output = $crud->render();
            $data['titulo_personal'] = "Línea de Trabajo";
            $this->_cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }
    
    public function budget_ptda() {
        satelite_validar();
        try {
            $permisos = $this->gsatelite->get_permisos_opcion();
            $urlx = explode('/', uri_string());
            $crud = new grocery_CRUD();
            $columnas = array(
                'ppl_nombre',
                'ppl_estado'
            );
            $required = array(
                'ppl_nombre',
                'ppl_estado'
            );
            $alias = array(
                'ppl_codigo' => 'Código',
                'ppl_nombre' => 'Nombre',
                'ppl_estado' => 'Estado'
            );
            $columnas_insert = array(
                'ppl_codigo',
                'ppl_nombre',
                'ppl_estado',
                'ppl_usu_creacion',
                'ppl_usu_modifiacion',
                'ppl_fecha_creacion',
                'ppl_fecha_modificacion'
            );
            $columnas_update = array(
                'ppl_codigo',
                'ppl_nombre',
                'ppl_estado',
                'ppl_usu_modifiacion',
                'ppl_fecha_modificacion'
            );
            $crud->set_table('ppl_partida_plaza')
                ->set_subject('')
                ->columns($columnas)
                ->display_as($alias)
                ->add_fields($columnas_insert)
                ->edit_fields($columnas_update)
                ->required_fields($required)
                ->set_rules('ppl_nombre', 'Nombre', 'trim|required|campo_unico[ppl_partida_plaza.ppl_nombre]')
                ->field_type('ppl_usu_modifiacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('ppl_fecha_modificacion', 'hidden', date('Y-m-d h:i:s'))
            ;

            if (end($urlx) == 'add') {
                $crud->field_type('ppl_estado', 'hidden', 1)
                    ->field_type('ppl_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('ppl_fecha_creacion', 'hidden', date('Y-m-d h:i:s'))
                ;
            } else {
                $crud->field_type('ppl_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if (!$permisos['permite_ver']) {
                $crud->unset_read();
            }
            $output = $crud->render();
            $data['titulo_personal'] = "Partida Presupuestaria";
            $this->_cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    public function budget_subptda() {
        satelite_validar();
        try {
            $permisos = $this->gsatelite->get_permisos_opcion();
            $urlx = explode('/', uri_string());
            $crud = new grocery_CRUD();
            $columnas = array(
                'spp_nombre',
                'spp_estado'
            );
            $required = array(
                'spp_nombre',
                'spp_estado'
            );
            $alias = array(
                'spp_codigo' => 'Código',
                'spp_nombre' => 'Nombre',
                'spp_estado' => 'Estado'
            );
            $columnas_insert = array(
                'spp_codigo',
                'spp_nombre',
                'spp_estado',
                'spp_usu_creacion',
                'spp_usu_modifiacion',
                'spp_fecha_creacion',
                'spp_fecha_modificacion'
            );
            $columnas_update = array(
                'spp_codigo',
                'spp_nombre',
                'spp_estado',
                'spp_usu_modifiacion',
                'spp_fecha_modificacion'
            );
            $crud->set_table('spp_subpartida_plaza')
                ->set_subject('')
                ->columns($columnas)
                ->display_as($alias)
                ->add_fields($columnas_insert)
                ->edit_fields($columnas_update)
                ->required_fields($required)
                ->set_rules('spp_nombre', 'Nombre', 'trim|required|campo_unico[spp_subpartida_plaza.spp_nombre]')
                ->field_type('spp_usu_modifiacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('spp_fecha_modificacion', 'hidden', date('Y-m-d h:i:s'))
            ;

            if (end($urlx) == 'add') {
                $crud->field_type('spp_estado', 'hidden', 1)
                    ->field_type('spp_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('spp_fecha_creacion', 'hidden', date('Y-m-d h:i:s'))
                ;
            } else {
                $crud->field_type('spp_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if (!$permisos['permite_ver']) {
                $crud->unset_read();
            }
            $output = $crud->render();
            $data['titulo_personal'] = "Sub Partida Presupuestaria";
            $this->_cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    public function budget_encrypt() {
        satelite_validar();
        try {
            $permisos = $this->gsatelite->get_permisos_opcion();
            $urlx = explode('/', uri_string());
            $crud = new grocery_CRUD();
            $columnas = array(
                'cip_nombre',
                'cip_estado'
            );
            $required = array(
                'cip_nombre',
                'cip_estado'
            );
            $alias = array(
                'cip_codigo' => 'Código',
                'cip_nombre' => 'Nombre',
                'cip_estado' => 'Estado'
            );
            $columnas_insert = array(
                'cip_codigo',
                'cip_nombre',
                'cip_estado',
                'cip_usu_creacion',
                'cip_usu_modifiacion',
                'cip_fecha_creacion',
                'cip_fecha_modificacion'
            );
            $columnas_update = array(
                'cip_codigo',
                'cip_nombre',
                'cip_estado',
                'cip_usu_modifiacion',
                'cip_fecha_modificacion'
            );
            $crud->set_table('cip_cifrado_presupuestario')
                ->set_subject('')
                ->columns($columnas)
                ->display_as($alias)
                ->add_fields($columnas_insert)
                ->edit_fields($columnas_update)
                ->required_fields($required)
                ->set_rules('cip_nombre', 'Nombre', 'trim|required|campo_unico[cip_cifrado_presupuestario.cip_nombre]')
                ->field_type('cip_usu_modifiacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('cip_fecha_modificacion', 'hidden', date('Y-m-d h:i:s'))
            ;

            if (end($urlx) == 'add') {
                $crud->field_type('cip_estado', 'hidden', 1)
                    ->field_type('cip_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('cip_fecha_creacion', 'hidden', date('Y-m-d h:i:s'))
                ;
            } else {
                $crud->field_type('cip_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if (!$permisos['permite_ver']) {
                $crud->unset_read();
            }
            $output = $crud->render();
            $data['titulo_personal'] = "Cifrado Presupuestal";
            $this->_cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }


    /**
     * @author Francisco Orozco
     * @return mantenimiento de niveles de areas
     */
    function niveles_areas() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            try {
                $permisos = $this->gsatelite->get_permisos_opcion();
                $crud = new grocery_CRUD();

                $add = array(
                    'nia_nombre',
                    'nia_estado',
                    'nia_usu_modificacion',
                    'nia_fecha_modificacion',
                    'nia_usu_creacion',
                    'nia_fecha_creacion'
                );

                $edit = array(
                    'nia_nombre',
                  //  'nia_valor',
                    'nia_estado',
                    'nia_usu_modificacion',
                    'nia_fecha_modificacion'
                );

                $crud->set_table('nia_nivel_area')
                ->set_subject('Niveles del área')
                ->columns('nia_nombre', 'nia_estado')
                ->display_as('nia_nombre', 'Nombre')
                ->display_as('nia_estado', 'Estado')
                ->add_fields($add)
                ->edit_fields($edit)
                ->required_fields($edit)
                ->field_type('nia_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('nia_fecha_modificacion', 'hidden',  date('Y-m-d H:i:s')) 
                ;

                $crud->set_rules('nia_nombre', 'Nombre', 'trim|required|campo_unico[nia_nivel_area.nia_nombre]');


                if (end(explode('/', uri_string())) == 'add') {
                    $crud->field_type('nia_estado', 'hidden', 1)
                    ->field_type('nia_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('nia_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
                } else {
                    $crud->field_type('nia_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
                }

                // Validaciones
                if (!$permisos['permite_agregar']) {
                    $crud->unset_add();
                }

                if (!$permisos['permite_editar']) {
                    $crud->unset_edit();
                }

                if (!$permisos['permite_eliminar']) {
                    $crud->unset_delete();
                }

                if ($permisos['permite_ver']) {
                    $crud->add_action('Ver', 'minia-icon-search', 'estructura_organizativa/mantenimientos/niveles_areas/read');
                }
                $data['titulo_personal'] = "Niveles del área";

                $output = $crud->render();
                $this->_cargarvista($data, $output);
            } catch (Exception $e) {
                show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
            }
        }
    }

    /**
     * @author Francisco Orozco
     * @return mantenimiento de categorias salariales
     */
    function categorias_salariales() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            try {
                $permisos = $this->gsatelite->get_permisos_opcion();
                $urlx = explode('/', uri_string());
                $crud = new grocery_CRUD();
                $add = array(
                    'cts_nombre',
                    'cts_nivel',
                    'cts_salario_minimo',
                    'cts_salario_maximo',
                    'cts_salario_medio',
                    'cts_estado',
                    'cts_usu_modificacion',
                    'cts_fecha_modificacion',
                    'cts_usu_creacion',
                    'cts_fecha_creacion'
                );
                $edit = array(
                    'cts_nombre',
                    'cts_nivel',
                    'cts_salario_minimo',
                    'cts_salario_maximo',
                    'cts_salario_medio',
                    'cts_estado',
                    'cts_usu_modificacion',
                    'cts_fecha_modificacion'
                );
                $column = array(
                    'cts_nombre',
                    'cts_nivel',
                    'cts_salario_minimo',
                    'cts_salario_maximo',
                    'cts_salario_medio',
                    'cts_estado'
                );
                $display = array(
                    'cts_nombre'        => 'Clasificación',
                    'cts_nivel'         => 'Nivel',
                    'cts_salario_minimo'=> 'Salario mínimo',
                    'cts_salario_maximo'=> 'Salario Máximo',
                    'cts_salario_medio' => 'Salario medio',
                    'cts_estado'        => 'Estado'
                );
                $crud->set_table('cts_categoria_salarial')
                ->set_subject('Categoría salarial')
                ->columns($column)
                ->add_fields($add)
                ->edit_fields($edit)
                ->required_fields($edit)
                ->display_as($display)
                ->field_type('cts_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('cts_fecha_modificacion', 'hidden',  date('Y-m-d H:i:s')) 
                ;
                $crud->set_rules('cts_nombre', 'Clasificación', 'trim|required|campo_unico[cts_categoria_salarial.cts_nombre]');

                if (end($urlx) == 'add') {
                    $crud->field_type('cts_estado', 'hidden', 1)
                    ->field_type('cts_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('cts_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
                } else {
                    $crud->field_type('cts_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
                }

                // Validaciones
                if (!$permisos['permite_agregar']) {
                    $crud->unset_add();
                }

                if (!$permisos['permite_editar']) {
                    $crud->unset_edit();
                }

                if (!$permisos['permite_eliminar']) {
                    $crud->unset_delete();
                }

                if ($permisos['permite_ver']) {
                    $crud->add_action('Ver', 'minia-icon-search', 'estructura_organizativa/mantenimientos/categorias_salariales/read');
                }
                $data['titulo_personal'] = "Categoría salarial";

                $output = $crud->render();
                $this->_cargarvista($data, $output);
            } catch (Exception $e) {
                show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
            }
        }
    }

    /**
     * @author René Castaneda
     * @return mantenimiento de tipo de puesto
     */
    function tipo_puesto() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            try {
                $permisos = $this->gsatelite->get_permisos_opcion();
                $crud = new grocery_CRUD();

                $add = array(
                    'tpt_nombre',
                    'tpt_estado',
                    'tpt_usu_modificacion',
                    'tpt_fecha_modificacion',
                    'tpt_usu_creacion',
                    'tpt_fecha_creacion',
                    'tpt_aplica_detalle'
                );

                $edit = array(
                    'tpt_nombre',
                    'tpt_estado',
                    'tpt_usu_modificacion',
                    'tpt_fecha_modificacion',
                    'tpt_aplica_detalle'
                );

                $req = array(
                    'tpt_nombre',
                    'tpt_estado',
                    'tpt_usu_modificacion',
                    'tpt_fecha_modificacion'
                );

                $column = array(
                    'tpt_nombre',
                    'tpt_estado'
                );

                $display = array(
                    'tpt_nombre'=> 'Nombre',
                    'tpt_estado'=> 'Estado',
                    'tpt_aplica_detalle' => 'Aplica detalle'
                );

                $crud->set_table('tpt_tipo_puesto')
                ->set_subject('Tipo puesto')
                ->columns($column)
                ->add_fields($add)
                ->edit_fields($edit)
                ->required_fields($req)
                ->display_as($display)
                ->field_type('tpt_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('tpt_fecha_modificacion', 'hidden',  date('Y-m-d H:i:s')) 
                ->callback_add_field('tpt_aplica_detalle',function(){
                    return '<input type="checkbox" id="tpt_aplica_detalle" class="nostyle"> <input type="hidden" id="field-tpt_aplica_detalle" name="tpt_aplica_detalle" value="0" >';
                })
                ->callback_edit_field('tpt_aplica_detalle', function($value, $primary_key) use ($id) {
                    $id      = $primary_key;
                    $leer    = ($this->uri->rsegments[3] == 'read')?'iButton':'';
                            $defecto = ($value)?'checked':''; // Verificar si esta activo
                            return '<input type="checkbox" id="tpt_aplica_detalle" '.$defecto.' class="'.$leer.' nostyle">
                            <input type="hidden" id="field-tpt_aplica_detalle" name="tpt_aplica_detalle" value="'.$value.'">';
                        })
                ;

                $crud->set_rules('tpt_nombre', 'Nombre', 'trim|required|campo_unico[tpt_tipo_puesto.tpt_nombre]');


                if (end(explode('/', uri_string())) == 'add') {
                    $crud->field_type('tpt_estado', 'hidden', 1)
                    ->field_type('tpt_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('tpt_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
                } else {
                    $crud->field_type('tpt_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
                }

                // Validaciones
                if (!$permisos['permite_agregar']) {
                    $crud->unset_add();
                }

                if (!$permisos['permite_editar']) {
                    $crud->unset_edit();
                }

                if (!$permisos['permite_eliminar']) {
                    $crud->unset_delete();
                }

                if (!$permisos['permite_ver']) {
                    $crud->unset_add();
                }
                $data['titulo_personal'] = "Tipo puesto";

                $output = $crud->render();
                $this->_cargarvista($data, $output);
            } catch (Exception $e) {
                show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
            }
        }
    }

    /**
     * @author Luis Navarro
     * @return Verificar flag por defecto de Centro de Costos (tabla cec_centro_costo)
     */
    function verificar_flag_defecto_cec() {
        satelite_validar(true);

        if($this->input->post()) {
            $flag       = $this->input->post("flag");          // Flag
            $empresa    = $this->tank_auth->get_empresa_id();  // Empresa que se ha seleccionado cuando se ha logueado

            if ($empresa>0) {
                $this->db->where("(cec_id_emr=$empresa OR cec_id_emr IS NULL)");
            } else {
                $this->db->where('ISNULL(cec_id_emr)');
            }

            $consulta   = $this->gsatelite->get_tabla('cec_centro_costo', array('cec_defecto'=>1, 'cec_estado'=>1));
            
            if (count($consulta)>0) {
                $defecto = 1;
            } else {
                $defecto = 0;
            }

            echo json_encode(array('cant_defecto'=>count($consulta), 'es_defecto'=>$defecto));
        }
    }

     /**
     * Descripción:
     * Función para dar mantenimiento a Beneficios por puesto (tabla:bfp_beneficio_puesto )
     * @author Rafael A. Cuchilla - Grupo satélite
     * @since  2018-07-05
     * @param  Ninguno
     * @return Mantenimiento de Beneficios por puesto
     */
     public function beneficios_puesto() {
        satelite_validar();

        try {
            $permisos = $this->gsatelite->get_permisos_opcion();
            $crud = new grocery_CRUD();


            $columnas = array(
                'bfp_nombre',
                'bfp_descripcion',
                'bfp_estado'
            );

            $required = array(
                'bfp_nombre',
                'bfp_estado'
            );

            $alias = array(
                'bfp_nombre' => 'Nombre',
                'bfp_descripcion' => 'Descripción',
                'bfp_estado' => 'Estado'
            );

            $columnas_insert = array(
                'bfp_nombre',
                'bfp_descripcion',
                'bfp_estado',
                'bfp_usu_creacion',
                'bfp_fecha_creacion',
                'bfp_usu_modificacion',
                'bfp_fecha_modificacion'
            );

            $columnas_update = array(
                'bfp_nombre',
                'bfp_descripcion',
                'bfp_estado',
                'bfp_usu_modificacion',
                'bfp_fecha_modificacion'
            );

            $crud->set_table('bfp_beneficio_puesto')
            ->set_subject('Beneficio')
            ->columns($columnas)
            ->display_as($alias)
            ->add_fields($columnas_insert)
            ->edit_fields($columnas_update)
            ->required_fields($required)
            ->set_rules('bfp_nombre', 'Nombre', 'trim|required|campo_unico[bfp_beneficio_puesto.bfp_nombre]')
            ->field_type('bfp_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
            ->field_type('bfp_fecha_modificacion', 'hidden', date('Y-m-d h:i:s'))
            ->field_type('bfp_fecha_creacion', 'hidden', date('Y-m-d h:i:s'))
            ->field_type('bfp_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
            ;

            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('bfp_estado', 'hidden', 1);
            } else {
                $crud->field_type('bfp_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if (!$permisos['permite_ver']) {
                $crud->unset_read();
            } else {
                $data_url = $this->masterpage->getUsuario();
                $url_read = $data_url['modulo'] . '/' . $data_url['control'] . '/' . $data_url['funcion'];
                $crud->add_action('Ver', 'minia-icon-search', $url_read."/read");
            }

            $output = $crud->render();
            $data['titulo_personal'] = "Beneficios Puestos";

            $this->_cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    /**
     * Descripción:
     * Función para dar mantenimiento a Instituciones (tabla:bfp_beneficio_puesto )
     * @author Marlon Olmedo - Grupo satélite
     * @since  2020-05-14
     * @param  Ninguno
     * @return Mantenimiento a Instituciones
     */
    public function institucion() {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();
        $crud = new grocery_CRUD;

        $alias = array(
            'itt_nombre'              => 'Nombre Institucion',
            'itt_telefono'            => 'Telefono',
            'itt_direccion'           => 'Direccion',
            'itt_estado'              => 'estado'
        );

        $colums = array(
            'itt_nombre',
            'itt_telefono',
            'itt_direccion',
            'itt_estado'
        );

        $add = array(
            'itt_nombre',
            'itt_telefono',
            'itt_direccion',
            'itt_estado',
            'itt_usu_creacion',
            'itt_fecha_creacion',
            'itt_usu_modificacion',
            'itt_fecha_modificacion'
        );
        $requeridos = array(
            'itt_nombre'
        );
        $edit = array(
            'itt_nombre',
            'itt_telefono',
            'itt_direccion',
            'itt_estado',
            'itt_usu_creacion',
            'itt_fecha_creacion',
            'itt_usu_modificacion',
            'itt_fecha_modificacion'
        );

        $crud->set_table('itt_institucion')
        ->set_subject('Institucion')
        ->display_as($alias)
        ->columns($colums)
        ->add_fields($add)
        ->edit_fields($edit)
        ->required_fields($requeridos)
        ->field_type('itt_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
        ->field_type('itt_fecha_modificacion', 'hidden', date('Y-m-d h:i:s'))
        ->unset_print()
        ->unset_export()
        ;
        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('itt_estado', 'hidden', 1)
            ->field_type('itt_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
            ->field_type('itt_fecha_creacion', 'hidden', date('Y-m-d h:i:s'));
        } else {
            $crud->field_type('itt_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }
        

        // Validaciones
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }

        if (!$permisos['permite_editar']) {
            $crud->unset_edit();
        }

        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }

        if (!$permisos['permite_ver']) {
           $crud->unset_read();
       }

       $output = $crud->render();
       $data['titulo_personal'] = 'Institucion';
       $this->_cargarvista($data, $output);
   }

    /**
     * Descripción:
     * Función para dar mantenimiento a empresa (tabla: emr_empresa)
     * Funcionalidad Compartida del Modulo de seguridad - catalogo
     * @author Marlon Olmedo - Grupo Satélite
     * @since 2020-05-15
     * @param ninguno
     * @return Mantenimiento de empresa
     */
    public function empresa() {
        satelite_validar();
        $this->load->library('../controllers/sistema/catalogo');
        $this->catalogo->empresa();
    }

    public function turnos(){
        satelite_validar();
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            try {
                $permisos = $this->gsatelite->get_permisos_opcion();
                $crud = new grocery_CRUD();
                $crud->set_table('tur_turno')
                        ->set_subject('turno')
                        ->columns('tur_nombre', 'tur_descripcion', 'tur_descuento_automatico', 'tur_estado')
                        ->fields('tur_nombre', 'tur_descripcion', 'tur_descuento_automatico', 'tur_estado', 'tur_usu_mod', 'tur_fecha_mod')
                        ->display_as('tur_nombre', 'Nombre')
                        ->display_as('tur_descripcion', 'Descripción')
                        ->display_as('tur_estado', 'Estado')
                        ->display_as('tur_descuento_automatico', 'Des. Automático')
                        ->required_fields('tur_nombre', 'tur_descuento_automatico', 'tur_estado', 'tur_usu_mod', 'tur_fecha_mod')
                        ->set_rules('tur_nombre', 'Nombre', 'trim|required|campo_unico[tur_turno.tur_nombre]')
                        ->field_type('tur_descuento_automatico', 'dropdown', array('1' => 'Sí', '0' => 'No'))
                        ->field_type('tur_estado', 'dropdown', array('1' => 'Activado', '0' => 'Desactivado'))
                        ->field_type('tur_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                        ->field_type('tur_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                        ->unset_delete()
                        ->unset_export()
                        ->unset_print()
                        ->unset_edit()
                        ->unset_read()
                ;
                if (!$permisos['permite_agregar']) {
                    $crud->unset_add();
                }
                if ($permisos['permite_editar']) {
                    $crud->add_action('Editar', '', 'estructura_organizativa/mantenimientos/editar_turno', 'icomoon-icon-pencil-5');
                    $crud->add_action('Configuraciones', '', '', 'entypo-icon-settings', function($primary_key, $row) {
                        $pre1 = $this->gsatelite->get_tabla('cot_configuracion_turno', array('cot_id_tur' => $primary_key));
                        $pre2 = $this->gsatelite->get_tabla('cat_configuracion_accion_turno', array('cat_id_tur' => $primary_key));
                        $pre3 = $this->gsatelite->get_tabla('che_configuracion_hora_extra', array('che_id_tur' => $primary_key));
                        if (count($pre1) == 0 and count($pre2) == 0 and count($pre3) == 0) {
                            return base_url() . 'estructura_organizativa/mantenimientos/configuracion_turno_add/' . $primary_key;
                        } else {
                            return base_url() . 'estructura_organizativa/mantenimientos/configuracion_turno_edit/' . $primary_key;
                        }
                    });
                }
                $data['titulo_personal'] = "Gestión de turnos";
                $output = $crud->render();
                $this->_cargarvista($data, $output);
            } catch (Exception $e) {
                show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
            }
        }
    }

    public function add_turno(){
        satelite_validar();
        if ($_POST) {
            // die(var_dump($_POST));
            $insert_turno = array(
                'tur_nombre' => $this->input->post('nombre_turno'),
                'tur_descuento_automatico' => $this->input->post('desc_auto'),
                'tur_descripcion' => $this->input->post('descripcion_turno'),
                'tur_estado' => $this->input->post('estado_turno'),
                'tur_usu_mod' => $this->tank_auth->get_user_id(),
                'tur_fecha_mod' => date("Y-m-d H:i:s")
            );
            $id_turno = $this->gsatelite->ingresar('tur_turno', $insert_turno);
            $detalles = $this->input->post('detalle_h');
            $dia = $this->input->post('detalle_h_dia');
            for ($i = 0; $i < count($detalles); $i++) {
                if ($detalles[$i] > 0 and $dia[$i] > 0) {
                    $insert_detalle = array(
                        'dxt_id_tur' => $id_turno,
                        'dxt_id_deh' => $detalles[$i],
                        'dxt_id_dia' => $dia[$i],
                        'dxt_estado' => 1,
                        'dxt_usu_mod' => $this->tank_auth->get_user_id(),
                        'dxt_fecha_mod' => date("Y-m-d H:i:s")
                    );
                    $this->gsatelite->ingresar('dxt_detallexturno', $insert_detalle);
                }
            }
            if ($this->input->post('boton') > 1) {
                $this->gsatelite->show_dialog('Turno ingresado con éxito', 'estructura_organizativa/mantenimientos/turnos', 'success');
            } else {
                $this->gsatelite->show_dialog('Turno ingresado con éxito', 'estructura_organizativa/mantenimientos/add_turno', 'success');
            }
            die();
        } else {
            $datos['titulo_personal'] = "Gestión de turnos";
            $this->_cargarvista($datos, null);
        }
    }

    public function editar_turno($id = null) {
        satelite_validar();
        $this->gsatelite->verificar_registro_real('tur_turno', $id);
        if ($_POST) {
            // var_dump($_POST);die();
            $id = $this->input->post('id_turno');
            $update_turno = array(
                'tur_nombre' => $this->input->post('nombre_turno'),
                'tur_descuento_automatico' => $this->input->post('desc_auto'),
                'tur_descripcion' => $this->input->post('descripcion_turno'),
                'tur_estado' => $this->input->post('estado_turno'),
                'tur_usu_mod' => $this->tank_auth->get_user_id(),
                'tur_fecha_mod' => date("Y-m-d H:i:s")
            );
            $this->gsatelite->actualizar_array('tur_turno', $update_turno, array('tur_id' => $id));            
            $consul = $this->gsatelite->get_tabla('dxt_detallexturno', array('dxt_id_tur' => $id));
            $seleccionados_activos = array();
            $seleccionados_deh = array();
            $seleccionados_dia = array();
            foreach ($consul as $f) {
                $seleccionados_activos[] = $f['dxt_id_deh'] . $f['dxt_id_dia'];
                $seleccionados_deh[] = $f['dxt_id_deh'];
                $seleccionados_dia[] = $f['dxt_id_dia'];
            }
            $array_datos = $this->input->post('detalle_h');
            $array_datos_dia = $this->input->post('detalle_h_dia');
            $array_concatenado = array();
            for ($i = 0; $i < count($array_datos); $i++) {
                if ($array_datos[$i] > 0 and $array_datos_dia[$i] > 0) {
                    $array_concatenado[] = $array_datos[$i] . $array_datos_dia[$i];
                    if (!in_array($array_datos[$i] . $array_datos_dia[$i], $seleccionados_activos)) {
                        $insert_detalle = array(
                            'dxt_id_tur' => $id,
                            'dxt_id_deh' => $array_datos[$i],
                            'dxt_id_dia' => $array_datos_dia[$i],
                            'dxt_estado' => 1,
                            'dxt_usu_mod' => $this->tank_auth->get_user_id(),
                            'dxt_fecha_mod' => date("Y-m-d H:i:s")
                        );
                        $this->gsatelite->ingresar('dxt_detallexturno', $insert_detalle);
                    } else {
                        $cadena = array(
                            'dxt_estado' => 1,
                            'dxt_usu_mod' => $this->tank_auth->get_user_id(),
                            'dxt_fecha_mod' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->actualizar_array('dxt_detallexturno', $cadena, array('dxt_id_deh' => $array_datos[$i], 'dxt_id_dia' => $array_datos_dia[$i], 'dxt_id_tur' => $id));
                    }
                }
            }
            for ($i = 0; $i < count($seleccionados_activos); $i++) {
                if (!in_array($seleccionados_activos[$i], $array_concatenado)) {
                    $cadena = array(
                        'dxt_estado' => 0,
                        'dxt_usu_mod' => $this->tank_auth->get_user_id(),
                        'dxt_fecha_mod' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->actualizar_array('dxt_detallexturno', $cadena, array('dxt_id_deh' => $seleccionados_deh[$i], 'dxt_id_dia' => $seleccionados_dia[$i], 'dxt_id_tur' => $id));
                }
            }
            $this->gsatelite->show_dialog('Turno actualizado con éxito', 'estructura_organizativa/mantenimientos/turnos', 'success');
        } else {
            $datos['titulo_personal'] = "GESTIÓN DE TURNOS";
            $consulta = $this->gsatelite->get_tabla('tur_turno', array('tur_id' => $id));
            $datos['informacion'] = $consulta[0];
            $this->_cargarvista($datos, null);
        }
    }

    public function configuracion_turno_add($id_turno = null) {
        satelite_validar();
        $this->gsatelite->verificar_registro_real('tur_turno', $id_turno);
        if ($_POST) {
            // die(var_dump($_POST));
            $id_turno = $this->input->post('id_turno');
            if ($this->input->post('aplica_entrada_tarde') == 1 && $this->input->post('minutos_tarde_ent') != "") {
                $array_insert = array(
                    'cot_id_tur' => $id_turno,
                    'cot_tipo' => 1,
                    'cot_minutos' => $this->input->post('minutos_tarde_ent'),
                    'cot_id_fre' => null,
                    'cot_estado' => 1,
                    'cot_usu_mod' => $this->tank_auth->get_user_id(),
                    'cot_fecha_mod' => date("Y-m-d H:i:s")
                );
                $id_insert_entrada = $this->gsatelite->ingresar('cot_configuracion_turno', $array_insert);
            }
            if ($this->input->post('aplica_salida_temprano') == 1 && $this->input->post('minutos_temp_sal') != "") {
                $array_insert = array(
                    'cot_id_tur' => $id_turno,
                    'cot_tipo' => 2,
                    'cot_minutos' => $this->input->post('minutos_temp_sal'),
                    'cot_id_fre' => null,
                    'cot_estado' => 1,
                    'cot_usu_mod' => $this->tank_auth->get_user_id(),
                    'cot_fecha_mod' => date("Y-m-d H:i:s")
                );
                $id_insert_entrada = $this->gsatelite->ingresar('cot_configuracion_turno', $array_insert);
            }
            if ($this->input->post('aplica_si_no_marca_ent') == 1 && $this->input->post('minutos_sino_ent') > 0 && $this->input->post('tipo_retraso_sino_ent') > 0) {
                $array_insert = array(
                    'cat_id_tur' => $id_turno,
                    'cat_tipo' => 1,
                    'cat_minutos' => $this->input->post('minutos_sino_ent'),
                    'cat_id_thf' => $this->input->post('tipo_retraso_sino_ent'),
                    'cat_estado' => 1,
                    'cat_usu_mod' => $this->tank_auth->get_user_id(),
                    'cat_fecha_mod' => date("Y-m-d H:i:s")
                );
                $id_insert_entrada = $this->gsatelite->ingresar('cat_configuracion_accion_turno', $array_insert);
            }
            if ($this->input->post('aplica_si_no_marca_sal') == 1 && $this->input->post('minutos_sino_sal') > 0 && $this->input->post('tipo_retraso_sino_sal') > 0) {
                $array_insert = array(
                    'cat_id_tur' => $id_turno,
                    'cat_tipo' => 2,
                    'cat_minutos' => $this->input->post('minutos_sino_sal'),
                    'cat_id_thf' => $this->input->post('tipo_retraso_sino_sal'),
                    'cat_estado' => 1,
                    'cat_usu_mod' => $this->tank_auth->get_user_id(),
                    'cat_fecha_mod' => date("Y-m-d H:i:s")
                );
                $id_insert_entrada = $this->gsatelite->ingresar('cat_configuracion_accion_turno', $array_insert);
            }
            //DETALLES DE RANGO DE HORAS EXTRAS
            $detalle_min_desde = $this->input->post('detalle_hora_desde');
            $detalle_min_hasta = $this->input->post('detalle_hora_hasta');
            $detalle_frecuencia = $this->input->post('detalle_fre');
            $detalle_hr_extra = $this->input->post('detalle_hora_extra');
            for ($i = 0; $i < count($detalle_min_desde); $i++) {
                if ($detalle_min_desde[$i] != "" and $detalle_hr_extra[$i] > 0) {
                    $insert_detalle = array(
                        'che_id_tur' => $id_turno
                        , 'che_minutos_desde' => $detalle_min_desde[$i]
                        , 'che_minutos_hasta' => $detalle_min_hasta[$i]
                        , 'che_factor_hora' => $detalle_hr_extra[$i]
                        , 'che_id_the' => $detalle_frecuencia[$i]
                        , 'che_estado' => 1
                        , 'che_usu_mod' => $this->tank_auth->get_user_id()
                        , 'che_fecha_mod' => date("Y-m-d H:i:s")
                    );
                    $this->gsatelite->ingresar('che_configuracion_hora_extra', $insert_detalle);
                }
            }
            $this->gsatelite->show_dialog('Configuración ingresada con éxito', 'estructura_organizativa/mantenimientos/turnos', 'success');
        } else {
            $datos['id_turno'] = $id_turno;
            $reg_turno = $this->gsatelite->get_tabla('tur_turno', array('tur_id' => $id_turno));
            $datos['reg_turno'] = $reg_turno[0];
            $time = $this->gsatelite->get_dropdown('thf_tipo_hora_faltante', '{thf_nombre} ({thf_factor})','', array('thf_estado'=>1), null, '', 'thf_id', true);
            $frec = $this->gsatelite->get_dropdown('the_tipo_hora_extra', '{the_nombre}','', array('the_estado' => 1), null, '', 'the_id', true);
            $datos['tiempo_faltante'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $time);
            $datos['frecuencias'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $frec);
            $datos['titulo_personal'] = "CONFIGURACIONES";
            $this->_cargarvista($datos, null);
        }
    }

    public function configuracion_turno_edit($id_turno = null) {
        satelite_validar();
        $this->gsatelite->verificar_registro_real('tur_turno', $id_turno);
        if ($_POST) {
            // die(var_dump($_POST));
            $id_turno = $this->input->post('id_turno');
            $tiene_entrada_tarde = count($this->gsatelite->get_tabla('cot_configuracion_turno', array('cot_id_tur' => $id_turno, 'cot_tipo' => 1)));
            $tiene_salida_temp = count($this->gsatelite->get_tabla('cot_configuracion_turno', array('cot_id_tur' => $id_turno, 'cot_tipo' => 2)));
            $tiene_sino_entrada = count($this->gsatelite->get_tabla('cat_configuracion_accion_turno', array('cat_id_tur' => $id_turno, 'cat_tipo' => 1)));
            $tiene_sino_salida = count($this->gsatelite->get_tabla('cat_configuracion_accion_turno', array('cat_id_tur' => $id_turno, 'cat_tipo' => 2)));
            if ($this->input->post('aplica_entrada_tarde') == 1 && $this->input->post('minutos_tarde_ent') != "") {
                $array_insert = array(
                    'cot_id_tur' => $id_turno,
                    'cot_tipo' => 1,
                    'cot_minutos' => $this->input->post('minutos_tarde_ent'),
                    'cot_id_fre' => null,
                    'cot_estado' => 1,
                    'cot_usu_mod' => $this->tank_auth->get_user_id(),
                    'cot_fecha_mod' => date("Y-m-d H:i:s")
                );
                if ($tiene_entrada_tarde > 0) {
                    $this->gsatelite->actualizar_array('cot_configuracion_turno', $array_insert, array('cot_id_tur' => $id_turno, 'cot_tipo' => 1));
                } else {
                    $id_insert_entrada = $this->gsatelite->ingresar('cot_configuracion_turno', $array_insert);
                }
            } else {
                if ($this->input->post('hidden_aplica_entrada_tarde') < 1) {
                    $array_insert = array(
                        'cot_estado' => 0,
                        'cot_usu_mod' => $this->tank_auth->get_user_id(),
                        'cot_fecha_mod' => date("Y-m-d H:i:s")
                    );
                    $this->gsatelite->actualizar_array('cot_configuracion_turno', $array_insert, array('cot_id_tur' => $id_turno, 'cot_tipo' => 1));
                }
            }
            if ($this->input->post('aplica_salida_temprano') == 1 && $this->input->post('minutos_temp_sal') != "") {
                $array_insert = array(
                    'cot_id_tur' => $id_turno,
                    'cot_tipo' => 2,
                    'cot_minutos' => $this->input->post('minutos_temp_sal'),
                    'cot_id_fre' => null,
                    'cot_estado' => 1,
                    'cot_usu_mod' => $this->tank_auth->get_user_id(),
                    'cot_fecha_mod' => date("Y-m-d H:i:s")
                );
                if ($tiene_salida_temp > 0) {
                    $this->gsatelite->actualizar_array('cot_configuracion_turno', $array_insert, array('cot_id_tur' => $id_turno, 'cot_tipo' => 2));
                } else {
                    $id_insert_salida = $this->gsatelite->ingresar('cot_configuracion_turno', $array_insert);
                }
            } else {
                if ($this->input->post('hidden_aplica_salida_temprano') < 1) {
                    $array_insert = array(
                        'cot_estado' => 0,
                        'cot_usu_mod' => $this->tank_auth->get_user_id(),
                        'cot_fecha_mod' => date("Y-m-d H:i:s")
                    );
                    $this->gsatelite->actualizar_array('cot_configuracion_turno', $array_insert, array('cot_id_tur' => $id_turno, 'cot_tipo' => 2));
                }
            }
            if ($this->input->post('aplica_si_no_marca_ent') == 1 && $this->input->post('minutos_sino_ent') > 0 && $this->input->post('tipo_retraso_sino_ent') > 0) {
                $array_insert = array(
                    'cat_id_tur' => $id_turno,
                    'cat_tipo' => 1,
                    'cat_minutos' => $this->input->post('minutos_sino_ent'),
                    'cat_id_thf' => $this->input->post('tipo_retraso_sino_ent'),
                    'cat_estado' => 1,
                    'cat_usu_mod' => $this->tank_auth->get_user_id(),
                    'cat_fecha_mod' => date("Y-m-d H:i:s")
                );
                if ($tiene_sino_entrada > 0) {
                    $this->gsatelite->actualizar_array('cat_configuracion_accion_turno', $array_insert, array('cat_id_tur' => $id_turno, 'cat_tipo' => 1));
                } else {
                    $id_insert = $this->gsatelite->ingresar('cat_configuracion_accion_turno', $array_insert);
                }
            } else {
                if ($this->input->post('hidden_aplica_si_no_marca_ent') < 1) {
                    $array_insert = array(
                        'cat_estado' => 0,
                        'cat_usu_mod' => $this->tank_auth->get_user_id(),
                        'cat_fecha_mod' => date("Y-m-d H:i:s")
                    );
                    $this->gsatelite->actualizar_array('cat_configuracion_accion_turno', $array_insert, array('cat_id_tur' => $id_turno, 'cat_tipo' => 1));
                }
            }
            if ($this->input->post('aplica_si_no_marca_sal') == 1 && $this->input->post('minutos_sino_sal') > 0 && $this->input->post('tipo_retraso_sino_sal') > 0) {
                $array_insert = array(
                    'cat_id_tur' => $id_turno,
                    'cat_tipo' => 2,
                    'cat_minutos' => $this->input->post('minutos_sino_sal'),
                    'cat_id_thf' => $this->input->post('tipo_retraso_sino_sal'),
                    'cat_estado' => 1,
                    'cat_usu_mod' => $this->tank_auth->get_user_id(),
                    'cat_fecha_mod' => date("Y-m-d H:i:s")
                );
                if ($tiene_sino_salida > 0) {
                    $this->gsatelite->actualizar_array('cat_configuracion_accion_turno', $array_insert, array('cat_id_tur' => $id_turno, 'cat_tipo' => 2));
                } else {
                    $id_insert = $this->gsatelite->ingresar('cat_configuracion_accion_turno', $array_insert);
                }
            } else {
                if ($this->input->post('hidden_aplica_si_no_marca_sal') < 1) {
                    $array_insert = array(
                        'cat_estado' => 0,
                        'cat_usu_mod' => $this->tank_auth->get_user_id(),
                        'cat_fecha_mod' => date("Y-m-d H:i:s")
                    );
                    $this->gsatelite->actualizar_array('cat_configuracion_accion_turno', $array_insert, array('cat_id_tur' => $id_turno, 'cat_tipo' => 2));
                }
            }
            $detalle_min_desde = $this->input->post('detalle_hora_desde');
            $detalle_min_hasta = $this->input->post('detalle_hora_hasta');
            $detalle_frecuencia = $this->input->post('detalle_fre');
            $detalle_hr_extra = $this->input->post('detalle_hora_extra');
            $this->gsatelite->borrado_general('che_configuracion_hora_extra', array('che_id_tur' => $id_turno));
            for ($i = 0; $i < count($detalle_min_desde); $i++) {
                if ($detalle_min_desde[$i] != "" && $detalle_hr_extra[$i] > 0) {
                    $insert_detalle = array(
                        'che_id_tur' => $id_turno,
                        'che_minutos_desde' => $detalle_min_desde[$i],
                        'che_minutos_hasta' => $detalle_min_hasta[$i],
                        'che_factor_hora' => $detalle_hr_extra[$i],
                        'che_id_the' => $detalle_frecuencia[$i],
                        'che_estado' => 1,
                        'che_usu_mod' => $this->tank_auth->get_user_id(),
                        'che_fecha_mod' => date("Y-m-d H:i:s")
                    );
                    $this->gsatelite->ingresar('che_configuracion_hora_extra', $insert_detalle);
                }
            }
            $this->gsatelite->show_dialog('Configuración actualizada con éxito', 'estructura_organizativa/mantenimientos/turnos', 'success');
        } else {
            $datos['id_turno'] = $id_turno;
            $reg_turno = $this->gsatelite->get_tabla('tur_turno', array('tur_id' => $id_turno));
            $datos['reg_turno'] = $reg_turno[0];
            $datos['configuracion_entrada'] = $this->gsatelite->get_tabla('cot_configuracion_turno', array('cot_id_tur' => $id_turno, 'cot_tipo' => 1, 'cot_estado' => 1));
            $datos['configuracion_salida'] = $this->gsatelite->get_tabla('cot_configuracion_turno', array('cot_id_tur' => $id_turno, 'cot_tipo' => 2, 'cot_estado' => 1));
            $datos['configuracion_accion_entrada'] = $this->gsatelite->get_tabla('cat_configuracion_accion_turno', array('cat_id_tur' => $id_turno, 'cat_tipo' => 1, 'cat_estado' => 1));
            $datos['configuracion_accion_salida'] = $this->gsatelite->get_tabla('cat_configuracion_accion_turno', array('cat_id_tur' => $id_turno, 'cat_tipo' => 2, 'cat_estado' => 1));
                                                 $this->db->join('the_tipo_hora_extra', 'che_id_the = the_id', 'left');
            $datos['configuracion_hora_extra'] = $this->gsatelite->get_tabla('che_configuracion_hora_extra', array('che_id_tur' => $id_turno, 'che_estado' => 1));
            $frec = $this->gsatelite->get_dropdown('the_tipo_hora_extra', '{the_nombre}','', array('the_estado' => 1), null, '', 'the_id', true);
            $datos['frecuencias'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $frec);
            $datos['titulo_personal'] = "CONFIGURACIONES";
            $this->_cargarvista($datos, null);
        }
    }

    /**
    * @author Raul E
    * @since 2021/ene
    * @param ninguno
    * @return Mantenimiento de giro comercial
    */
    public function giro_comerciales() {
        satelite_validar();
        $this->load->library('../controllers/modulo_compras/catalogos');
        $this->catalogos->giro_comercial('estructura_organizativa\mantenimientos');
    }

}

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */