<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Consultas extends CI_Controller
{

    function __construct()
    {
        parent::__construct();
        $this->load->library('grocery_CRUD');
        $this->load->model('estructura_organizativa_model');
        $this->load->library('form_validation');
        $this->load->model('gsatelite');
        $this->load->library('pdf');
    }

    function index()
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $this->_cargarvista();
        }
    }

    /**
     * @author René Castaneda
     */
    function consulta_organigrama()
    {
        satelite_validar();
        $tipo_estructura = "";
        if ($_POST) {
            $post_array = $this->input->post();
            $tipo_estructura = ($post_array['filtro_area'] != '') ? $post_array['filtro_area'] : $this->gsatelite->get_max("nia_nivel_area", "nia_id", array("nia_estado" => 1));
        } else {
            $tipo_estructura = $this->gsatelite->get_max("nia_nivel_area", "nia_id", array("nia_estado" => 1));
        }
        $data["tipo_estructura"]    = $tipo_estructura;
        $data['areas']              = $this->gsatelite->get_tabla('nia_nivel_area', array('nia_estado' => 1));
        $data["titulo_personal"]    = "Consulta de organigrama por áreas";
        $this->_cargarvista($data, null);
    }

    /**
     * @author René Castaneda
     */
    function ver_organigrama($area_especifica = null, $print = null, $plazas = 0)
    {
        satelite_validar();
        $data["titulo_personal"] = "ORGANIGRAMA ÁREAS";
        $data["imprimir"] = $print;
        if ($area_especifica != null and $area_especifica != 0) {
            $data["id_area_espeficica"] = $area_especifica;
            $data['registro_area'] = $this->gsatelite->get_registro('are_area', 'are_id', $area_especifica);
        } else {
            $data["datos_padres"] = $this->estructura_organizativa_model->get_solo_padres();

            $this->db->join('mxr_empresaxarea', 'mxr_id_are = are_id');
            $this->db->where('mxr_id_emr', $this->tank_auth->get_empresa_id()); //Added by René Castaneda 02-03-2018       
            $nivel = $this->db->select("IFNULL(MAX(are_area.are_nivel),1) AS ultimo_nivel", false)->from("are_area")->get()->row_array();
            $data["n_niveles"] = $nivel['ultimo_nivel'];
        }

        //Parametro para mostrar el detalle de plazas y empleado por area
        $data['plazas'] = $plazas;
        $this->load->view('estructura_organizativa/consultas/ver_organigrama_json', $data, FALSE);
    }

    /**
     * @author René Castaneda
     * para visualizar diagrama area-plaza completo (mezclado)
     */
    function consulta_organigrama2()
    {
        satelite_validar();
        $tipo_estructura = "";
        if ($_POST) {
            $post_array = $this->input->post();
            $tipo_estructura = ($post_array['filtro_area'] != '') ? $post_array['filtro_area'] : "";
        }
        $data["tipo_estructura"]    = $tipo_estructura;
        $data['areas']              = $this->gsatelite->get_tabla('nia_nivel_area', array('nia_estado' => 1));
        //$data["titulo_personal"]    = "CONSULTA ORGANIGRAMA ÁREAS - PLAZA";
        $data["titulo_personal"]    = "Organigrama General";
        $this->_cargarvista($data, null);
    }

    /**
     * @author René Castaneda
     * para visualizar diagrama area-plaza completo (mezclado)
     */
    function ver_organigrama2($area_especifica = null, $print = null)
    {
        satelite_validar();
        $id_empresa = $this->tank_auth->get_empresa_id();
        $data["titulo_personal"] = "ORGANIGRAMA ÁREAS - PLAZA / CARGO FUNCIONAL";
        $data["imprimir"] = $print;
        $datos_padres = $this->estructura_organizativa_model->get_solo_padres();
        $area_especifica = (count($datos_padres) > 0) ? $datos_padres[0]['are_id'] : $area_especifica;
        if ($area_especifica != null and $area_especifica > 0) {
            $data["id_area_espeficica"] = $area_especifica;
            $data['registro_area'] = $this->gsatelite->get_registro('are_area', 'are_id', $area_especifica);
        } else {
            $data["datos_padres"] = $datos_padres;


            $this->db->join('mxr_empresaxarea', 'mxr_id_are = are_id');
            $this->db->where('mxr_id_emr', $this->tank_auth->get_empresa_id());
            $nivel = $this->db->select("IFNULL(MAX(are_area.are_nivel),1) AS ultimo_nivel", false)->from("are_area")->get()->row_array();
            $data["n_niveles"] = $nivel['ultimo_nivel'];
        }
        //print_r($data["datos_padres"]); die();
        //print_r($this->db->last_query());die();
        $this->load->view('estructura_organizativa/consultas/ver_organigrama2', $data, FALSE);
    }

    /**
     * @author René Castaneda
     * @param int tipo_vista (1= empleado sin staff mostrando a los empleados, 0 = plaza (normal con staff))
     */
    function consulta_organigrama_plaza($tipo_vista = 0)
    {
        satelite_validar();
        $tipo_estructura = "";
        if ($_POST) {
            $post_array = $this->input->post();
            $tipo_estructura = ($post_array['filtro_area'] != '') ? $post_array['filtro_area'] : ""; //filtro area era el tipo de puesto pero se cambio por area en 1-sep-20
        }


        $data["tipo_estructura"]    = $tipo_estructura;
        $data["tipo_vista"]         = $tipo_vista;
        $data['areas']              = $this->gsatelite->get_tabla('nia_nivel_area', array('nia_estado' => 1));
        // $data['tipos']              = $this->gsatelite->get_tabla('tpt_tipo_puesto',array('tpt_estado' => 1));////////Se cambio por area en 1-sep-20////////
        $data["titulo_personal"]    = ($tipo_vista > 0) ? "Consulta de Organigrama por Plazas/Cargos funcionales-Empleado" : "Consulta de Organigrama por Plazas / Cargos funcionales";
        //$this->load->view('estructura_organizativa/consultas/consulta_organigrama_plaza', $data, FALSE);
        cargarvista($data, null, 'estructura_organizativa/consultas/consulta_organigrama_plaza');
    }

    function get_max_plaza_con_empleados($plz_ids)
    {
        $contador = 0;
        foreach ($plz_ids as $id) {
            $query = $this->db->select('COUNT(plz_id) AS total, group_concat(DISTINCT plz_id) AS ids_plazas')
                ->from('plz_plaza')
                ->join('pto_puesto', 'pto_id = plz_id_pto', 'left')
                ->join('mxr_empresaxarea', 'mxr_id_are = plz_id_are')
                ->where('plz_estado', 1)
                ->where('mxr_id_emr', $this->tank_auth->get_empresa_id())
                ->where('plz_id_padre', $id['plz_id'])
                ->where('plz_dibujar_organigrama', 1)
                ->group_by('plz_nombre')
                ->order_by('plz_id', 'asc')
                ->having('total >', 1)
                ->get()->result_array();


            if (isset($query[0]['ids_plazas']) == NULL) {
                $get_cantidad_emp = $this->db->select("count('emp_id') as n")->from('emp_empleado')->where('emp_id_plz', $id['plz_id'])->where('emp_estado', 1)->get()->result_array();
            } else {
                $idplz = (trim($query[0]['ids_plazas']) != null) ? $query[0]['ids_plazas'] : '0';
                $get_cantidad_emp = $this->db->select("count('emp_id') as n")->from('emp_empleado')->where(array('emp_estado' => 1, "emp_id_plz in (" . $idplz . ")" => null))->get()->result_array();
            }

            $contador = ((int) $get_cantidad_emp[0]['n'] > $contador) ?  (int) $get_cantidad_emp[0]['n'] : (int) $contador;
        }
        return $contador;
    }

    /**
     * @author René Castaneda
     */
    function ver_organigrama_plaza($id_especifico = null, $print = null, $tipo_vista = 0)
    {
        satelite_validar();
        $data["titulo_personal"] = "ORGANIGRAMA PLAZAS / CARGOS FUNCIONALES";
        $data["imprimir"] = $print;
        if ($id_especifico != null and $id_especifico > 0) {
            $data["id_plaza_espeficica"] = $id_especifico;
            $data['registro_plaza'] = $this->gsatelite->get_registro('plz_plaza', 'plz_id', $id_especifico);
            // $data['titulo']         = $data['registro_plaza']->plz_nombre;
        } else {
            $data["datos_padres"] = $this->estructura_organizativa_model->get_solo_padres_plaza_modificado();
        }
        $plz_ids = $this->db->select('plz_id')->from('plz_plaza')->where('plz_estado', 1)->get()->result_array();
        $data['max_empleado_en_plaza'] = (int)$this->get_max_plaza_con_empleados($plz_ids);

        //print_r($data["datos_padres"]); die();
        //$this->load->view('estructura_organizativa/consultas/ver_organigrama_plaza', $data, FALSE);
        $data['tipo_vista'] = $tipo_vista;
        /*if($tipo_vista == 1)
            $this->load->view('estructura_organizativa/consultas/ver_organigrama_plaza', $data, FALSE);
       else
        $this->load->view('estructura_organizativa/consultas/ver_organigrama_plaza_json', $data, FALSE);*/
        $this->load->view('estructura_organizativa/consultas/ver_organigrama_plaza_json', $data, FALSE);
    }
    /**
     * @author René Castaneda
     * @since 25-07-2018
     * @return Generación de organigrama con los empleados
     */
    public function ver_organigrama_plaza_opc2($id_especifico = null)
    {
        $this->ver_organigrama_plaza($id_especifico, $print = null, 1);
    }

    /**
     * @author René Castaneda
     */
    function ver_organigrama_area_plaza($area_especifica = null, $print = null)
    {
        satelite_validar();
        $data["titulo_personal"] = "Organigráma de áreas y plazas / cargos funcionales";
        $data["imprimir"] = $print;
        if ($area_especifica != null and $area_especifica != 0) {
            $data["id_area_espeficica"] = $area_especifica;
            $data['registro_area'] = $this->gsatelite->get_registro('are_area', 'are_id', $area_especifica);
            $data["datos_plaza"] = $this->gsatelite->get_tabla('plz_plaza', array('plz_id_are' => $area_especifica, "plz_id_padre IS NULL" => NULL));
        } else {
            redirect('');
        }
        $this->load->view('estructura_organizativa/consultas/ver_organigrama_area_plaza', $data, FALSE);
    }

    /**
     * @author René Castaneda
     */
    function consulta_accionistas()
    {
        satelite_validar();
        if ($_POST) {
            $tipo = $this->input->post('tipo_reporte');

            $data['accionistas'] = $this->gsatelite->get_tabla('acn_accionista', array('acn_id_emr' => $this->tank_auth->get_empresa_id()));

            if ($tipo != '') {
                if ($tipo == 'pdf') {
                    $data['titulo'] = 'Accionistas';

                    $html = $this->load->view('reporte/header', $data, true);
                    $html .= $this->load->view('estructura_organizativa/consultas/consulta_accionistas_export', $data, true);

                    $GLOBALS['nombre_reporte'] = 'accionistas' . date('dmY');

                    $this->pdf->makePdf($html, 'L', 'Accionistas', 'Letter');
                } else if ($tipo == 'excel') {

                    $filename = 'rpt_accionistas_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

                    $data['titulo'] = 'Reporte de Accionistas';
                    $data['filename'] = $filename;
                    $data['excel'] = 1;
                    $html = $this->load->view('estructura_organizativa/consultas/consulta_accionistas_export', $data, true);

                    echo $html;
                    die();
                }
            }
        }
        $data["titulo_personal"] = "Consulta de accionistas";
        $data['accionistas'] = $this->gsatelite->get_tabla('acn_accionista', array('acn_id_emr' => $this->tank_auth->get_empresa_id()));
        $this->_cargarvista($data, null);
    }

    /**
     * @author Raul E
     */
    public function consulta_miembros_jd($flag = null)
    {
        satelite_validar();
        if ($_POST) {
            $estados = $this->input->post('filtro_estado');
            $reporte = $this->input->post('reporte');
            if ($estados != "") {
                $where['mij_estado']  = $estados;
            }
            $where['mij_id_emr'] = $this->tank_auth->get_empresa_id();
            $data['reporte'] = $reporte;
            $data['filename'] = 'miembros_ccsj' . date('dmY');
            $this->db->join('pto_puesto', 'pto_id = mij_id_pto', 'left');
            $this->db->join('itt_institucion', 'itt_id = mij_id_itt', 'left');
            $data['accionistas'] = $this->gsatelite->get_tabla('mij_miembro_junta', $where);
            $html = $this->load->view('estructura_organizativa/consultas/detalle_consulta_miembros', $data, true);
            if ($flag) {
                echo $html;
            } else {
                if ($reporte == 'excel') {
                    echo $html;
                } else {
                    $data['titulo'] = 'Miembros de Junta Directiva';
                    $repor = $this->load->view('reporte/header', $data, true);
                    $repor .= $html;
                    $GLOBALS['nombre_reporte'] = 'miembros_ccsj' . date('dmY');
                    $this->pdf->makePdf($repor, 'L', 'Accionistas', 'Letter');
                }
            }
        } else {
            $data["titulo_personal"] = "Consulta de Miembros Junta Directiva";
            $this->_cargarvista($data, null);
        }
    }

    function consulta_completo()
    {
        satelite_validar();
        $data["titulo_personal"] = "CONSULTA ORGANIGRAMA ÁREAS - PLAZA / CARGO FUNCIONAL";
        $this->_cargarvista($data, null);
    }

    function ver_organigrama_completo($area_especifica = null, $print = null)
    {
        satelite_validar();
        $data["titulo_personal"] = "ORGANIGRAMA ÁREAS - PLAZA / CARGO FUNCIONAL";
        $data["imprimir"] = $print;
        if ($area_especifica != null and $area_especifica != 0) {
            $data["id_area_espeficica"] = $area_especifica;
            $data['registro_area'] = $this->gsatelite->get_registro('are_area', 'are_id', $area_especifica);
        } else {
            $data["datos_padres"] = $this->estructura_organizativa_model->get_solo_padres();
            $nivel = $this->db->select("IFNULL(MAX(are_area.are_nivel),1) AS ultimo_nivel", false)->from("are_area")->get()->row_array();
            $data["n_niveles"] = $nivel['ultimo_nivel'];
        }
        $this->load->view('estructura_organizativa/consultas/ver_organigrama_completo', $data, FALSE);
    }

    function personal_area()
    {
        satelite_validar();
        $this->db->join('mxr_empresaxarea', 'mxr_id_are = are_id');
        $this->db->join('nia_nivel_area', 'are_id_nia = nia_id', 'left');
        $this->db->where('mxr_id_emr', $this->tank_auth->get_empresa_id());
        $data['areas']              = $this->gsatelite->get_tabla('are_area', array('are_estado' => 1));
        $data['titulo_personal']    = "Reporte personal por área";
        $this->_cargarvista($data);
    }

    public function reporte_personal_area($flag = null)
    {
        satelite_validar();
        if ($_POST) {
            $post_array = $this->input->post();
            /*
             * Si es consulta ajax se toman los nombres del Jquery
             * De lo contrario, se toman los filtros de impresión
             */

            if ($flag) {
                $area           = ($post_array['area'] != '') ? $post_array['area'] : null;
                $nombre_area    = ($post_array['nombre_area'] != '') ? $post_array['nombre_area'] : "todos";
            } else {
                $area = ($post_array['filtro_area'] != '') ? $post_array['filtro_area'] : null;
                $nombre_area    = ($post_array['filtro_area_nombre'] != '') ? $post_array['filtro_area_nombre'] : "todos";
            }

            //Tipo de Reportes si sera Excel o Pdf
            $tipo_reporte = $this->input->post('tipo_reporte');

            $where = null;

            if ($area != null) {
                $where['emp_id_are'] = $area;
            }

            $where['emp_estado'] = 1;

            $reporte = $this->estructura_organizativa_model->get_empleado($where);


            $filename = 'rpt_reporte_personal_area' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename'] = $filename;
            $data['reporte'] = $reporte;
            $data['tipo_reporte'] = $tipo_reporte;
            $data['area_nombre']  = $nombre_area;
            $html = $this->load->view('estructura_organizativa/consultas/reporte_personal_area', $data, true);

            if ($flag) {
                $dato["html"] = $html;
                $total = 0;
                foreach ($reporte as $row) {
                    $total = $total + $row['emp_salario'];;
                }

                $dato["foot"] = "<th colspan='5' style='text-align: right;'> Total</th>
                                <th style='text-align: right;'>$" . number_format($total, 2) . "</th>
                                <th colspan='2'></th>";
                echo json_encode($dato);
            } else {
                if ($tipo_reporte == 'pdf') {

                    $data['titulo'] = 'personal por área';

                    $header = $this->load->view('reporte/header', $data, true);

                    $GLOBALS['nombre_reporte'] = 'reporte_personal_area' . date('dmY');

                    $reporte = $header . $html;

                    //echo $reporte;
                    $this->pdf->makePdf($reporte, 'L', 'reporte_personal_area', 'Letter');
                } elseif ($tipo_reporte == 'excel') {

                    $filename = 'rpt_reporte_personal_area_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

                    $data['titulo'] = 'personal por área';

                    $data['filename'] = $filename;

                    echo $html;
                }
            }
        } else {
            redirect('/estructura_organizativa/consultas/personal_area');
        }
    }

    function categoria_salarial()
    {
        satelite_validar();

        $this->db->join('nia_nivel_area', 'are_id_nia = nia_id', 'left');
        $data['areas']              = $this->gsatelite->get_tabla('are_area', array('are_estado' => 1, "are_id IN (SELECT mxr_id_are FROM mxr_empresaxarea WHERE mxr_id_emr = " . $this->tank_auth->get_empresa_id() . ")" => null));
        $data['categoria_salarial'] = $this->gsatelite->get_tabla('cts_categoria_salarial', array('cts_estado' => 1));
        $data['titulo_personal']    = "Reporte Categoría salarial";
        $this->_cargarvista($data);
    }

    public function reporte_categoria_salarial($flag = null)
    {
        satelite_validar();
        if ($_POST) {
            $post_array = $this->input->post();
            /*
             * Si es consulta ajax se toman los nombres del Jquery
             * De lo contrario, se toman los filtros de impresión
            */

            if ($flag) {
                $area           = ($post_array['area'] != '') ? $post_array['area'] : null;
                $nombre_area    = ($post_array['nombre_area'] != '') ? $post_array['nombre_area'] : "Todos";

                $nivel           = ($post_array['nivel'] != '') ? $post_array['nivel'] : null;
                $nombre_nivel    = ($post_array['nombre_nivel'] != '') ? $post_array['nombre_nivel'] : "Todos";
            } else {
                $area = ($post_array['filtro_area'] != '') ? $post_array['filtro_area'] : null;
                $nombre_area    = ($post_array['filtro_area_nombre'] != '') ? $post_array['filtro_area_nombre'] : "Todos";

                $nivel           = ($post_array['filtro_nivel'] != '') ? $post_array['filtro_nivel'] : null;
                $nombre_nivel    = ($post_array['filtro_nivel_nombre'] != '') ? $post_array['filtro_nivel_nombre'] : "Todos";
            }

            //Tipo de Reportes si sera Excel o Pdf
            $tipo_reporte = $this->input->post('tipo_reporte');

            $where = null;

            if ($area != null) {
                $where['emp_id_are']    = $area;
            }

            if ($nivel != null) {
                $where['cts_id']        = $nivel;
            }

            $reporte = $this->estructura_organizativa_model->get_empleado($where);

            $filename = 'rpt_reporte_categoria_salarial' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['area_nombre']    = $nombre_area;
            $data['nivel_nombre']   = $nombre_nivel;

            $data['filename'] = $filename;
            $data['reporte'] = $reporte;
            $data['tipo_reporte'] = $tipo_reporte;

            $html = $this->load->view('estructura_organizativa/consultas/reporte_categoria_salarial', $data, true);

            if ($flag) {
                $dato["html"] = $html;
                echo json_encode($dato);
                die();
            } else {
                if ($tipo_reporte == 'pdf') {

                    $data['titulo'] = 'categoría salarial';

                    $header = $this->load->view('reporte/header', $data, true);

                    $GLOBALS['nombre_reporte'] = 'reporte_categoria_salarial' . date('dmY');

                    $reporte = $header . $html;

                    //echo $reporte;
                    $this->pdf->makePdf($reporte, 'L', 'reporte_categoria_salarial', 'Letter');
                } elseif ($tipo_reporte == 'excel') {

                    $filename = 'rpt_categoria_salarial_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

                    $data['titulo'] = 'categoría salarial';

                    $data['filename'] = $filename;

                    echo $html;
                }
            }
        } else {
            redirect('estructura_organizativa/consultas/categoria_salarial');
        }
    }

    public function get_areas()
    {
        satelite_validar();
        if ($_POST) {
            $codigo_area   = $this->input->post('area');
            $areas = $this->gsatelite->get_tabla('are_area', array('are_estado' => 1, 'are_padre' => $codigo_area));
            if (count($areas) > 0) {
                $areas_string = "<option value=''></option>";
                foreach ($areas as $area) {
                    $areas_string = $areas_string . "<option value='" . $area['are_id'] . "'>" . $area['are_nombre'] . "</option>";
                }
                $result['areas']    = $areas_string;
                $result['hijos']    = 1;
            } else {
                $result['hijos'] = 0;
            }
            echo json_encode($result);
        }
    }

    /**
     * @author Francisco Orozco
     */
    function ver_organigrama_nivel_area($area_especifica = null, $print = null)
    {
        satelite_validar();
        $data["titulo_personal"]    = "ORGANIGRAMA ÁREAS";
        $data["imprimir"]           = $print;
        if ($area_especifica != null and $area_especifica != 0) {
            $data['titulo_filtro']  = $this->gsatelite->get_campo("nia_nivel_area", "nia_nombre", array('nia_id' => $area_especifica));
            $where["are_id_nia"]    = $area_especifica;
            $data["datos_padres"]   = $this->estructura_organizativa_model->get_solo_padres($where);
            $nivel                  = $this->db->select("IFNULL(MAX(are_area.are_nivel),1) AS ultimo_nivel", false)->from("are_area")->get()->row_array();
            $data["n_niveles"]      = $nivel['ultimo_nivel'];
        } else {
            $data["datos_padres"] = $this->estructura_organizativa_model->get_solo_padres();
            $nivel = $this->db->select("IFNULL(MAX(are_area.are_nivel),1) AS ultimo_nivel", false)->from("are_area")->get()->row_array();
            $data["n_niveles"] = $nivel['ultimo_nivel'];
        }

        $this->load->view('estructura_organizativa/consultas/ver_organigrama', $data, FALSE);
    }

    /**
     * @author Francisco Orozco
     */
    function filtro_organigrama_area($nivel_area = null, $print = null)
    {
        satelite_validar();
        $data["titulo_personal"] = "ORGANIGRAMA ÁREAS";
        $data["imprimir"] = $print;
        $data['titulo_filtro']  = $this->gsatelite->get_campo("nia_nivel_area", "nia_nombre", array('nia_id' => $nivel_area));
        $where['are_id_nia'] = $nivel_area;
        $data['nia_id_filtro'] = $nivel_area;

        $this->db->order_by('nia_id', 'ASC');
        $this->db->limit(1);
        $query_padre = $this->gsatelite->get_tabla('nia_nivel_area', array('nia_id <=' => $nivel_area));

        $where['are_id_nia'] = $query_padre[0]['nia_id'];
        $data["datos_padres"] = $this->estructura_organizativa_model->get_solo_padres($where);
        // echo $this->db->last_query(); die();
        $this->db->join('mxr_empresaxarea', 'mxr_id_are = are_id');
        $this->db->where('mxr_id_emr', $this->tank_auth->get_empresa_id()); //Added by René Castaneda 02-03-2018  
        $nivel = $this->db->select("IFNULL(MAX(are_area.are_nivel),1) AS ultimo_nivel", false)->from("are_area")->get()->row_array();
        $data["n_niveles"] = $nivel['ultimo_nivel'];

        // $plz_ids = $this->db->select('plz_id')->from('plz_plaza')->where('plz_estado', 1)->get()->result_array();
        // $data['max_empleado_en_plaza'] = (int)$this->get_max_area_con_empleados($plz_ids);

        $this->load->view('estructura_organizativa/consultas/ver_organigrama_json', $data, FALSE);
    }

    /**
     *@author: Francisco Orozco
     *fecha: 2018-01-30
     *Descripción:obtener las plazas filtradas por tipo de puesto
     *@author: Raul E
     *fecha: 2020-09-01
     *Descripción: se modifica pues ya no se filtra por tipo de puesto sino por area
     */
    function filtro_organigrama_plaza($tipo_puesto = null, $print = null, $tipo_vista = 0)
    {

        satelite_validar();
        $data["titulo_personal"]    = "ORGANIGRAMA PLAZAS / CARGOS FUNCIONALES";
        $data["imprimir"]           = $print;
        $where["plz_id_padre"]  = null;
        if ($tipo_puesto != null) {
            // $where["pto_id IN (SELECT pto_id FROM pto_puesto WHERE pto_id_tpt <= ".$tipo_puesto.")"] = null;
            $where["plz_id IN (SELECT plz_id FROM plz_plaza JOIN are_area ON plz_id_are = are_id WHERE are_id_nia <= " . $tipo_puesto . ")"] = null;
        }
        $id_empresa = $this->tank_auth->get_empresa_id();
        $data["datos_padres"]       = $this->estructura_organizativa_model->get_solo_padres_plaza_modificado($where);
        $data['titulo_filtro']      = $this->gsatelite->get_campo("nia_nivel_area", "nia_nombre", array('nia_id' => $tipo_puesto));
        $data["aplicar_where_in"]   = $tipo_puesto;
        $data['tipo_vista'] = $tipo_vista;


        $this->load->view('estructura_organizativa/consultas/ver_organigrama_plaza_json', $data, FALSE);
        /*if ($tipo_vista==1) {
            $this->load->view('estructura_organizativa/consultas/ver_organigrama_plaza', $data, FALSE);
        } else {
            $this->load->view('estructura_organizativa/consultas/ver_organigrama_plaza_json', $data, FALSE);
        }*/
    }

    /**
     * @author René Castaneda
     * @since 2018-01-02
     * @return / Description: Generar grid para reporte de descriptor de puesto
     */
    public function descriptor_puestos()
    {
        satelite_validar();
        $this->load->library('../controllers/estructura_organizativa/procesos');
        $this->procesos->puestos('estructura_organizativa/consultas');
    }

    /**
     * @author René Castaneda
     * @since 2018-01-02
     * @return / Description: Generar  pdf de reporteria para descriptor de puesto.
     */
    public function reporte_descriptor_puesto($id_puesto = 0)
    {
        satelite_validar();
        $data['registro'] = $this->estructura_organizativa_model->informacion_puesto(array('pto_id' => $id_puesto));
        $html = $this->load->view('estructura_organizativa/consultas/reporte_descriptor_puesto', $data, true);

        $this->load->library('pdf');
        $html_header = $this->load->view('reporte/header', array('titulo' => "Descriptor de Puesto / Cargo en Estructura", 'solotitulo' => true), true);
        $html = str_replace('', '', $html);
        $this->pdf->makePDF($html_header . $html);
        die();
    }

    //PRUEBA DE PLUGIN PARA ORGANIGRAMA 2
    /**
     * @author René Castaneda
     */
    function consulta_organigrama_new()
    {
        satelite_validar();
        $tipo_estructura = "";
        if ($_POST) {
            $post_array = $this->input->post();
            $tipo_estructura = ($post_array['filtro_area'] != '') ? $post_array['filtro_area'] : $this->gsatelite->get_max("nia_nivel_area", "nia_id", array("nia_estado" => 1));
        } else {
            $tipo_estructura = $this->gsatelite->get_max("nia_nivel_area", "nia_id", array("nia_estado" => 1));
        }
        $data["tipo_estructura"]    = $tipo_estructura;
        $data['areas']              = $this->gsatelite->get_tabla('nia_nivel_area', array('nia_estado' => 1));
        $data["titulo_personal"]    = "Consulta de organigrama por áreas";
        $this->_cargarvista($data, null);
    }

    /**
     * @author Francisco Orozco
     */
    function filtro_organigrama_area_new($nivel_area = null, $print = null)
    {
        satelite_validar();
        $data["titulo_personal"] = "ORGANIGRAMA ÁREAS";
        $data["imprimir"] = $print;
        $data['titulo_filtro']  = $this->gsatelite->get_campo("nia_nivel_area", "nia_nombre", array('nia_id' => $nivel_area));
        $where['are_id_nia'] = $nivel_area;
        $data['nia_id_filtro'] = $nivel_area;

        $this->db->order_by('nia_id', 'ASC');
        $this->db->limit(1);
        $query_padre = $this->gsatelite->get_tabla('nia_nivel_area', array('nia_id <=' => $nivel_area));

        $where['are_id_nia'] = $query_padre[0]['nia_id'];
        $data["datos_padres"] = $this->estructura_organizativa_model->get_solo_padres($where);
        // echo $this->db->last_query(); die();
        $this->db->join('mxr_empresaxarea', 'mxr_id_are = are_id');
        $this->db->where('mxr_id_emr', $this->tank_auth->get_empresa_id()); //Added by René Castaneda 02-03-2018  
        $nivel = $this->db->select("IFNULL(MAX(are_area.are_nivel),1) AS ultimo_nivel", false)->from("are_area")->get()->row_array();
        $data["n_niveles"] = $nivel['ultimo_nivel'];

        $this->load->view('estructura_organizativa/consultas/ver_organigrama_new', $data, FALSE);
    }

    /**
     * @author René Castaneda
     */
    function ver_organigrama_new($area_especifica = null, $print = null)
    {
        satelite_validar();
        $data["titulo_personal"] = "ORGANIGRAMA ÁREAS";
        $data["imprimir"] = $print;
        if ($area_especifica != null and $area_especifica != 0) {
            $data["id_area_espeficica"] = $area_especifica;
            $data['registro_area'] = $this->gsatelite->get_registro('are_area', 'are_id', $area_especifica);
        } else {
            $data["datos_padres"] = $this->estructura_organizativa_model->get_solo_padres();

            $this->db->join('mxr_empresaxarea', 'mxr_id_are = are_id');
            $this->db->where('mxr_id_emr', $this->tank_auth->get_empresa_id()); //Added by René Castaneda 02-03-2018       
            $nivel = $this->db->select("IFNULL(MAX(are_area.are_nivel),1) AS ultimo_nivel", false)->from("are_area")->get()->row_array();
            $data["n_niveles"] = $nivel['ultimo_nivel'];
        }
        $this->load->view('estructura_organizativa/consultas/ver_organigrama', $data, FALSE);
    }


    //PRUEBA DE PLUGIN PARA ORGANIGRAMA 3
    /**
     * @author René Castaneda
     */
    function consulta_organigrama_new2()
    {
        satelite_validar();
        $tipo_estructura = "";
        if ($_POST) {
            $post_array = $this->input->post();
            $tipo_estructura = ($post_array['filtro_area'] != '') ? $post_array['filtro_area'] : $this->gsatelite->get_max("nia_nivel_area", "nia_id", array("nia_estado" => 1));
        } else {
            $tipo_estructura = $this->gsatelite->get_max("nia_nivel_area", "nia_id", array("nia_estado" => 1));
        }
        $data["tipo_estructura"]    = $tipo_estructura;
        $data['areas']              = $this->gsatelite->get_tabla('nia_nivel_area', array('nia_estado' => 1));
        $data["titulo_personal"]    = "Consulta de organigrama por áreas";
        $this->_cargarvista($data, null);
    }

    /**
     * @author Francisco Orozco
     */
    function filtro_organigrama_area_new2($nivel_area = null, $print = null)
    {
        satelite_validar();
        $data["titulo_personal"] = "ORGANIGRAMA ÁREAS";
        $data["imprimir"] = $print;
        $data['titulo_filtro']  = $this->gsatelite->get_campo("nia_nivel_area", "nia_nombre", array('nia_id' => $nivel_area));
        $where['are_id_nia'] = $nivel_area;
        $data['nia_id_filtro'] = $nivel_area;

        $this->db->order_by('nia_id', 'ASC');
        $this->db->limit(1);
        $query_padre = $this->gsatelite->get_tabla('nia_nivel_area', array('nia_id <=' => $nivel_area));

        $where['are_id_nia'] = $query_padre[0]['nia_id'];
        $data["datos_padres"] = $this->estructura_organizativa_model->get_solo_padres($where);
        // echo $this->db->last_query(); die();
        $this->db->join('mxr_empresaxarea', 'mxr_id_are = are_id');
        $this->db->where('mxr_id_emr', $this->tank_auth->get_empresa_id()); //Added by René Castaneda 02-03-2018  
        $nivel = $this->db->select("IFNULL(MAX(are_area.are_nivel),1) AS ultimo_nivel", false)->from("are_area")->get()->row_array();
        $data["n_niveles"] = $nivel['ultimo_nivel'];

        $this->load->view('estructura_organizativa/consultas/ver_organigrama_new2', $data, FALSE);
    }

    /**
     * @author René Castaneda
     */
    function ver_organigrama_new2($area_especifica = null, $print = null)
    {
        satelite_validar();
        $data["titulo_personal"] = "ORGANIGRAMA ÁREAS";
        $data["imprimir"] = $print;
        if ($area_especifica != null and $area_especifica != 0) {
            $data["id_area_espeficica"] = $area_especifica;
            $data['registro_area'] = $this->gsatelite->get_registro('are_area', 'are_id', $area_especifica);
        } else {
            $data["datos_padres"] = $this->estructura_organizativa_model->get_solo_padres();

            $this->db->join('mxr_empresaxarea', 'mxr_id_are = are_id');
            $this->db->where('mxr_id_emr', $this->tank_auth->get_empresa_id()); //Added by René Castaneda 02-03-2018       
            $nivel = $this->db->select("IFNULL(MAX(are_area.are_nivel),1) AS ultimo_nivel", false)->from("are_area")->get()->row_array();
            $data["n_niveles"] = $nivel['ultimo_nivel'];
        }
        $this->load->view('estructura_organizativa/consultas/ver_organigrama', $data, FALSE);
    }


    /**
     * @author René Castaneda
     * para visualizar diagrama area-plaza completo (mezclado)
     */
    function filtro_ver_organigrama2($nivel_area = null, $print = null)
    {
        satelite_validar();
        $id_empresa = $this->tank_auth->get_empresa_id();
        $data["titulo_personal"] = "ORGANIGRAMA ÁREAS - PLAZA / CARGO FUNCIONAL";
        $data["imprimir"] = $print;
        $data["nivel_area"] = $nivel_area;
        $where = null;
        if ($nivel_area > 0) {
            $where['are_id_nia <='] = $nivel_area;
        }
        $data["datos_padres"] = $this->estructura_organizativa_model->get_solo_padres($where);
        //print_r($this->db->last_query());die();
        $this->load->view('estructura_organizativa/consultas/ver_organigrama2', $data, FALSE);
    }

    public function consulta_organigrama_plaza_empleado()
    {
        satelite_validar();
        $this->consulta_organigrama_plaza(1);
    }

    function _cargarvista($data = 0, $crud = 0)
    {
        $this->load->view('vacia', $crud);
        if ($data != 0)
            $data = array_merge($data, $this->masterpage->getUsuario());
        else
            $data = $this->masterpage->getUsuario();
        $vista = $data['modulo'] . '/' . $data['control'] . '/' . $data['funcion'];
        $this->masterpage->setMasterPage('masterpage_default');
        $this->masterpage->addContentPage($vista, 'content', $data);
        $this->masterpage->show();
    }
}
