<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Reportes extends CI_Controller {

    function __construct() {
        parent::__construct();
        $this->load->library('grocery_CRUD');
        $this->load->model('encuesta_model');
        $this->load->library('pdf');
        satelite_validar();
    }

    function index() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $this->_cargarvista();
        }
    }

    /**
     * @author Rene Castaneda
     */
    public function consulta_pregunta() {

        $data['titulo_personal'] = "Respuestas por Pregunta";
        $permisos = $this->gsatelite->get_permisos_opcion('consulta_pregunta');
        $data['sucursal'] = $this->gsatelite->get_dropdown('suc_sucursal', '{suc_nombre}', '', array('suc_estado' => '1'), null, '', 'suc_id', true);
        $data['permisos'] = $permisos;
        cargarvista($data);
    }

    /**
     * @author Rene Castaneda
     */
    public function filtrar_encuesta_sucursal() {

        $id = $this->input->post('id_sucursal');
        $encuesta = $this->encuesta_model->get_encuestasxsucursal(array('suc_id' => $id));
        $select = '<option value=""></option>';
        foreach ($encuesta as $fila) {
            $select .= '<option value="' . $fila['enc_id'] . '">' . $fila['enc_nombre'] . '</option>' . "\n";
        }
        die(json_encode(array('html_option' => $select)));
    }

    /**
     * @author Rene Castaneda
     */
    public function filtrar_respuesta_encuesta() {

        $id = $this->input->post('id_encuesta');
        $respuestas = $this->encuesta_model->get_respuestaxpregunta_cerrada('*, opr_nombre respuesta', 'opr_nombre', array('pre_id_enc' => $id), 'opr_nombre');
        $select = '<option value=""></option>';
        foreach ($respuestas as $fila) {
            $select .= '<option value="' . $fila['opr_id'] . '">' . $fila['respuesta'] . '</option>' . "\n";
        }
        die(json_encode(array('html_option' => $select)));
    }

    /**
     * @author Rene Castaneda
     */
    public function filtrar_consulta_pregunta($es_reporte = 0) {
        $registros = array();
        $permisos = $this->gsatelite->get_permisos_opcion('consulta_pregunta');
        $data['permisos'] = $permisos;
        $txtFecha_desde = $this->input->post('txtFecha_desde');
        $txtFecha_hasta = $this->input->post('txtFecha_hasta');
        $slcAgencia = $this->input->post('slcAgencia');
        $slcEncuesta = $this->input->post('slcEncuesta');
        //$slcRespuesta = $this->input->post('slcRespuesta');

        if ($txtFecha_desde != '' and $txtFecha_hasta != '' and $slcAgencia > 0 and $slcEncuesta > 0) {
            $where['date_format(ecl_fecha,"%Y-%m-%d") >='] = date('Y-m-d', strtotime($txtFecha_desde));
            $where['date_format(ecl_fecha,"%Y-%m-%d") <='] = date('Y-m-d', strtotime($txtFecha_hasta));
            $where['exs_id_suc'] = $slcAgencia;
            $where['pre_id_enc'] = $slcEncuesta;

            // if ($slcRespuesta > 0) {
            //     $reg_respuesta = $this->gsatelite->get_registro('opr_opcion_respuesta', 'opr_id', $slcRespuesta);
            //     $where['opr_nombre'] = $reg_respuesta->opr_nombre;
            // }
            $registros = $this->encuesta_model->get_preguntasxall($where);
            //print_r($this->db->last_query()); die();

            if (isset($where['opr_nombre'])) {
                unset($where['opr_nombre']);
            } //omitir la condicional de la respuesta
            $numero_encuesta = $this->encuesta_model->respuesta_preguntas('COUNT(DISTINCT ecl_id) n_encuestas', 'ecl_fecha', $where, 'exs_id');
        }
        $data['registros'] = $registros;
        $data['cantidad_encuestas'] = ($numero_encuesta) ? " ( Se encontraron " . $numero_encuesta[0]['n_encuestas'] . " Encuestas)" : '';
        $data['es_reporte'] = $es_reporte;

        $data['txtFecha_desde'] = $this->input->post('txtFecha_desde');
        $data['txtFecha_hasta'] = $this->input->post('txtFecha_hasta');
        $data['slcAgencia'] = $this->input->post('slcAgencia');
        $data['slcEncuesta'] = $this->input->post('slcEncuesta');
        //$data['slcRespuesta'] = $this->input->post('slcRespuesta');
        $data['periodo'] = date('d-m-Y', strtotime($txtFecha_desde)) . ' / ' . date('d-m-Y', strtotime($txtFecha_desde));
        //print_r($data); die();
        $html = $this->load->view('encuesta/reportes/filtrar_consulta_pregunta', $data, true);
        if ($es_reporte == 1) {
            //echo $html; die();
            $reg_encuesta = $this->gsatelite->get_registro('enc_encuesta', 'enc_id', $this->input->post('slcEncuesta'));
            $filtro_titulo = $txtFecha_desde . " / " . $txtFecha_hasta . " <br />" . $reg_encuesta->enc_nombre . " / " . $data['cantidad_encuestas'];
            $reg_sucursal = $this->gsatelite->get_registro('suc_sucursal', 'suc_id', $this->input->post('slcAgencia'));
            $data['nombre_sucursal'] = ($this->input->post('slcAgencia') > 0) ? $reg_sucursal->suc_nombre : "Todas";
            if ($this->input->post()) {
               
                $nombre_fichero = "consulta_preguntas_" . date('d-m-Y_His') . "_.csv";
                $fp = fopen("uploads/encuesta_temp/csv_enviados/$nombre_fichero", 'w');
                $i = 0;
                foreach ($registros as $campos) {
                    unset($campos['pre_id']);
                    unset($campos['iconos']);

                    $campos = array_map('utf8_decode', $campos);
                    //print_r($campos); die();
                    $i++;
                    if ($i == 1) {
                        $titulos = array('#', 'PREGUNTA', 'RESPUESTA', 'CANTIDAD RESPUESTA');
                        fputcsv($fp, array_merge($titulos));
                    }
                    fputcsv($fp, array_merge(array($i), $campos));
                }
                fclose($fp);
                if ($this->input->post('tipo_accion') == 1) {
                    //redirect("uploads/portal_inventario_temp/csv_enviados/$nombre_fichero");
                    if (file_exists("uploads/portal_inventario_temp/csv_enviados/$nombre_fichero")) {
                        unlink("uploads/portal_inventario_temp/csv_enviados/$nombre_fichero");
                    }
                    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                    header("Content-Disposition: attachment;filename=consulta_preguntas_" . date('d-m-Y_His') . ".xls");
                    header("Pragma: no-cache");
                    header("Expires: 0");
                    echo '<meta charset="utf-8" />';
                    echo "<table border='1'>
                      <tr><th colspan='4' align='center' >" . mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8') . "</th></tr>
                      <tr><th colspan='4' align='center' >Reporte de Respuesta Encuestas</th></tr>
                      <tr><th colspan='4' align='center' >" . $data['nombre_sucursal'] . " - " . $filtro_titulo . "</th></tr>
                      </table>";
                    echo $html;
                    die();
                } else {
                    //enviar por correo.
                    $asunto = "REPORTE DE PREGUNTA - ENCUESTA";
                    $mensaje = $this->load->view('encuesta/reportes/mensaje_correo', $data, true);
                    $correo_destino = explode(',', $this->gsatelite->get_parametro('SYS_CORREO_RECIBE_REPORTE_ENCUESTA'));

                    $this->db->join('emp_empleado', 'emp_id=usu_id_emp');
                    $registro_usuario = $this->gsatelite->get_registro('usu_usuario', 'usu_id', $this->tank_auth->get_user_id());
                    $correo_envia = $registro_usuario->usu_email;
                    $usuario_envia = $registro_usuario->emp_nombre . ' ' . $registro_usuario->emp_apellido;

                    $exito = $this->gsatelite->envio_correo($correo_envia, 'Portal Encuesta - ' . $usuario_envia, $correo_destino, $asunto, $mensaje, $correo_envia,null);
                    if ($exito > 0) {
                        $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Correo enviado", 'texto_alerta' => "Correo enviado con éxito");
                    } else {
                        $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error de envio ", 'texto_alerta' => "Correo no puedo ser enviado");
                    }
                    $this->session->set_flashdata($alerta);
                }
                if (file_exists("uploads/encuesta_temp/csv_enviados/$nombre_fichero")) {
                    unlink("uploads/encuesta_temp/csv_enviados/$nombre_fichero");
                }

                redirect('encuesta/reportes/consulta_pregunta');
            }
            redirect('encuesta/reportes/consulta_pregunta');
        } else {
            die(json_encode(array('html' => $html)));
        }
    }

    public function respuesta_encuesta($id_encuesta_cliente = 0, $reporte = 0) {
        $registros = $this->encuesta_model->respuesta_encuesta(array('ecl_id' => $id_encuesta_cliente));
      
        if (count($registros) <= 0) {
            die("<h4>NO SE ENCONTRARON REGISTROS</h4>");
        }
        //print_r($registros); die();
        $data['registros'] = $registros;
        $data['es_reporte'] = $reporte;
        if ($reporte) {
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header("Content-Disposition: attachment;filename=encuesta_cliente_" . date('d-m-Y_His') . ".xls");
            header("Pragma: no-cache");
            header("Expires: 0");
            echo '<meta charset="utf-8" />';
            echo "<table border='1'>
             <tr><th colspan='4' align='center' >" . mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8') . "</th></tr>
             </table>";
            echo $this->load->view('encuesta/reportes/respuesta_encuesta', $data, true);
            die();
        } else {
            $this->gsatelite->cargar_vista_masterpage('encuesta/reportes/respuesta_encuesta', $data);
        }
        //$this->load->view('encuesta/reportes/respuesta_encuesta', $data);
    }

    /**
     * @author Rene Castaneda
     */
    public function consulta_encuesta_sucursal() {
        $data['titulo_personal'] = "Consultar encuesta por grupo";
        $permisos = $this->gsatelite->get_permisos_opcion('consulta_encuesta_sucursal');
        $data['sucursal'] = $this->gsatelite->get_dropdown('suc_sucursal', '{suc_nombre}', '', array('suc_estado' => '1'), null, '', 'suc_id', true);
        $data['permisos'] = $permisos;
        cargarvista($data);
    }

    /**
     * @author Rene Castaneda
     */
    public function filtrar_consulta_encuesta_sucursal($es_reporte = 0) {
        $registros = array();
        $permisos = $this->gsatelite->get_permisos_opcion('consulta_encuesta_sucursal');
        $data['permisos'] = $permisos;
        $txtFecha_desde = $this->input->post('txtFecha_desde');
        $txtFecha_hasta = $this->input->post('txtFecha_hasta');
        $slcAgencia = $this->input->post('slcAgencia');

        $where='';
        //print_r($_POST); die();
        if ($txtFecha_desde != '' and $txtFecha_hasta != '') {
            //$this->db->where_in('suc_id', $slcAgencia);
            //$sucursales = $this->gsatelite->get_tabla("suc_sucursal"/* ,"exs_id_suc in (" .implode(',',$slcAgencia).")" */);
            //$arreglo_sucursales = array();
            /*foreach ($sucursales as $fila) {
                $arreglo_sucursales[] = $fila['suc_nombre'];
            }

            $agencias = implode(', ', $arreglo_sucursales);
            $data['agencias'] = $agencias;*/

            /*       $where['date_format(ecl_fecha,"%Y-%m-%d") >=']=date('Y-m-d',strtotime($txtFecha_desde));
              $where['date_format(ecl_fecha,"%Y-%m-%d") <=']=date('Y-m-d',strtotime($txtFecha_hasta));
              $where['exs_id_suc in']="(".implode(',',$slcAgencia).")";
             */
            $where .= 'date_format(ecl_fecha,"%Y-%m-%d") >="' . date('Y-m-d', strtotime($txtFecha_desde)) . '" AND ' . 'date_format(ecl_fecha,"%Y-%m-%d") <="' . date('Y-m-d', strtotime($txtFecha_hasta)).'"';

            //$registros=$this->encuesta_model->encuesta_cliente("ecl_id,CONCAT_WS(' ',cli_nombre, cli_apellido) cliente, cli_correo, cli_telefono, ecl_fecha",'ecl_fecha',$where,'ecl_id');
            //$numero_encuesta=$this->encuesta_model->respuesta_preguntas('COUNT(DISTINCT ecl_id) n_encuestas','ecl_fecha',$where,'exs_id');
            //print_r($this->db->last_query()); die();
        }

        
        if($this->input->post('slcAgencia')!='null'){
            $this->db->where_in('suc_id', $slcAgencia);
            $sucursales = $this->gsatelite->get_tabla("suc_sucursal"/* ,"exs_id_suc in (" .implode(',',$slcAgencia).")" */);
            $arreglo_sucursales = array();
            foreach ($sucursales as $fila) {
                $arreglo_sucursales[] = $fila['suc_nombre'];
            }

            $agencias = implode(', ', $arreglo_sucursales);
            $data['agencias'] = $agencias;
            $where .= 'AND exs_id_suc in (' . implode(',', $slcAgencia) . ")";
        }

       
        $registros = $this->encuesta_model->respuesta_preguntas('suc_nombre, COUNT(DISTINCT ecl_id) n_encuestas', 'ecl_fecha', $where, 'exs_id_suc');

    
        $data['registros'] = $registros;
        $data['cantidad_registros'] = ($registros) ? " ( Se encontraron " . count($registros) . " Grupos )" : '';
        $data['es_reporte'] = $es_reporte;

        $data['txtFecha_desde'] = $this->input->post('txtFecha_desde');
        $data['txtFecha_hasta'] = $this->input->post('txtFecha_hasta');
        $data['slcAgencia'] = $this->input->post('slcAgencia');
        $data['periodo'] = date('d-m-Y', strtotime($txtFecha_desde)) . ' / ' . date('d-m-Y', strtotime($txtFecha_desde));

        $html = $this->load->view('encuesta/reportes/filtrar_consulta_encuesta_sucursal', $data, true);
        if ($es_reporte == 1) {
            //echo $html; die();
            $filtro_titulo = $txtFecha_desde . " / " . $txtFecha_hasta . " <br />" . $data['cantidad_registros'];

            if ($this->input->post()) {
                $nombre_fichero = "consulta_encuesta_agencia_" . date('d-m-Y_His') . "_.csv";
                $fp = fopen("uploads/encuesta_temp/csv_enviados/$nombre_fichero", 'w');
                $i = 0;
                foreach ($registros as $campos) {

                    $campos = array_map('utf8_decode', $campos);
                    //print_r($campos); die();
                    $i++;
                    if ($i == 1) {
                        $titulos = array('#', 'AGENCIA', utf8_decode('NÚMERO ENCUESTAS'));
                        fputcsv($fp, array_merge($titulos));
                    }
                    fputcsv($fp, array_merge(array($i), $campos));
                }
                fclose($fp);
                if ($this->input->post('tipo_accion') == 1) {
                    //redirect("uploads/portal_inventario_temp/csv_enviados/$nombre_fichero");
                    if (file_exists("uploads/portal_inventario_temp/csv_enviados/$nombre_fichero")) {
                        unlink("uploads/portal_inventario_temp/csv_enviados/$nombre_fichero");
                    }
                    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                    header("Content-Disposition: attachment;filename=consulta_encuesta_agencia_" . date('d-m-Y_His') . ".xls");
                    header("Pragma: no-cache");
                    header("Expires: 0");
                    echo '<meta charset="utf-8" />';
                    echo "<table border='1'>
                     <tr><th colspan='3' align='center' >" . mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8') . "</th></tr>
                     <tr><th colspan='3' align='center' >Reporte de Encuestas - Agencia</th></tr>
                     <tr><th colspan='3' align='center' >" . $agencias . "</th></tr>
                     <tr><th colspan='3' align='center' >" . $filtro_titulo . "</th></tr>
                     </table>";
                    echo $html;
                    die();
                } else {
                    //enviar por correo.
                    $asunto = "REPORTE DE ENCUESTA - AGENCIA";
                    $mensaje = $this->load->view('encuesta/reportes/mensaje_correo_encuesta_sucursal', $data, true);
                    $correo_destino = explode(',', $this->gsatelite->get_parametro('SYS_CORREO_RECIBE_REPORTE_ENCUESTA'));

                    $this->db->join('emp_empleado', 'emp_id=usu_id_emp');
                    $registro_usuario = $this->gsatelite->get_registro('usu_usuario', 'usu_id', $this->tank_auth->get_user_id());
                    $correo_envia = $registro_usuario->usu_email;
                    $usuario_envia = $registro_usuario->emp_nombre . ' ' . $registro_usuario->emp_apellido;

                    $exito = $this->gsatelite->envio_correo($correo_envia, 'Portal Encuesta - ' . $usuario_envia, $correo_destino, $asunto, $mensaje, $correo_envia, FCPATH . "uploads/encuesta_temp/csv_enviados/$nombre_fichero");
                    if ($exito > 0) {
                        $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Correo enviado", 'texto_alerta' => "Correo enviado con éxito");
                    } else {
                        $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error de envio ", 'texto_alerta' => "Correo no puedo ser enviado");
                    }
                    $this->session->set_flashdata($alerta);
                }
                if (file_exists("uploads/encuesta_temp/csv_enviados/$nombre_fichero")) {
                    unlink("uploads/encuesta_temp/csv_enviados/$nombre_fichero");
                }

                redirect('encuesta/reportes/consulta_encuesta_cliente');
            }
            redirect('encuesta/reportes/consulta_encuesta_cliente');
        } else {
            die(json_encode(array('html' => $html)));
        }
    }

    /**
     * @author Rene Castaneda
     */
    public function consulta_respuesta_sucursal() {
        $data['titulo_personal'] = "Consultar Respuesta por grupo";
        $permisos = $this->gsatelite->get_permisos_opcion('consulta_respuesta_sucursal');
        $data['sucursal'] = $this->gsatelite->get_dropdown('suc_sucursal', '{suc_nombre}', '', array('suc_estado' => '1'), null, '', 'suc_id', true);
        $data['preguntas'] = $this->encuesta_model->select_preguntas(array('pre_estado' => 1));
        //print_r($data['respuesta']); die();
        $data['permisos'] = $permisos;
        cargarvista($data);
    }

    /**
     * @author Rene Castaneda
     */
    public function filtrar_consulta_respuesta_sucursal($es_reporte = 0) {
        $registros = array();
        $permisos = $this->gsatelite->get_permisos_opcion('consulta_respuesta_sucursal');
        $data['permisos'] = $permisos;
        $txtFecha_desde = $this->input->post('txtFecha_desde');
        $txtFecha_hasta = $this->input->post('txtFecha_hasta');
        $slcAgencia = $this->input->post('slcAgencia');
        $slcPregunta = $this->input->post('slcPregunta');

        //print_r($_POST); die();
        if ($txtFecha_desde != '' and $txtFecha_hasta != '' and count($slcAgencia) > 0) {
            $this->db->where_in('suc_id', $slcAgencia);
            $sucursales = $this->gsatelite->get_tabla("suc_sucursal"/* ,"exs_id_suc in (" .implode(',',$slcAgencia).")" */);
            $arreglo_sucursales = array();
            foreach ($sucursales as $fila) {
                $arreglo_sucursales[] = $fila['suc_nombre'];
            }

            $agencias = implode(', ', $arreglo_sucursales);
            $data['agencias'] = $agencias;

            $where['date_format(ecl_fecha,"%Y-%m-%d") >='] = date('Y-m-d', strtotime($txtFecha_desde));
            $where['date_format(ecl_fecha,"%Y-%m-%d") <='] = date('Y-m-d', strtotime($txtFecha_hasta));

            if ($slcPregunta > 0) {
                $reg_respuesta = $this->gsatelite->get_registro('pre_pregunta', 'pre_id', $slcPregunta);
                $where['pre_nombre'] = $reg_respuesta->pre_nombre;
            }
            $registros = $this->encuesta_model->preguntas_contestadas(' pre_id, suc_nombre,pre_nombre, COUNT(pre_id) n_preguntas,  GROUP_CONCAT(DISTINCT enc_nombre ) encuesta', 'ecl_fecha', $where, 'exs_id_suc,pre_nombre', array('exs_id_suc' => $slcAgencia));
           /* echo '$registros<pre>';
            print_r($registros);
            echo '</pre>';*/
            if (isset($where['pre_nombre'])) {
                unset($where['pre_nombre']);
            } //omitir la condicional de la respuesta
            $numero_encuesta = $this->encuesta_model->preguntas_contestadas('COUNT(DISTINCT ecl_id) n_encuestas', 'ecl_fecha', $where, null, array('exs_id_suc' => $slcAgencia));
            
           
            //print_r($this->db->last_query()); die();
        }
        $data['registros'] = $registros;
        $data['cantidad_registros'] = ($registros) ? " ( Se encontraron " . $numero_encuesta[0]['n_encuestas'] . " Encuestas )" : '';
        $data['es_reporte'] = $es_reporte;

        $data['txtFecha_desde'] = $this->input->post('txtFecha_desde');
        $data['txtFecha_hasta'] = $this->input->post('txtFecha_hasta');
        $data['slcAgencia'] = $this->input->post('slcAgencia');
        $data['slcRespuesta'] = $this->input->post('slcRespuesta');
        $data['periodo'] = date('d-m-Y', strtotime($txtFecha_desde)) . ' / ' . date('d-m-Y', strtotime($txtFecha_desde));

        $html = $this->load->view('encuesta/reportes/filtrar_consulta_respuesta_sucursal', $data, true);
        if ($es_reporte == 1) {
            //echo $html; die();
            $filtro_titulo = $txtFecha_desde . " / " . $txtFecha_hasta . " <br />" . $data['cantidad_registros'];

            if ($this->input->post()) {
                $nombre_fichero = "consulta_respuesta_agencia_" . date('d-m-Y_His') . "_.csv";
                $fp = fopen("uploads/encuesta_temp/csv_enviados/$nombre_fichero", 'w');
                $i = 0;
                foreach ($registros as $campos) {
                    unset($campos['iconos']);
                    unset($campos['encuesta']);
                    $campos = array_map('utf8_decode', $campos);
                    //print_r($campos); die();
                    $i++;
                    if ($i == 1) {
                        $titulos = array('#', 'AGENCIA', 'RESPUESTA', 'CANTIDAD RESPUESTA');
                        fputcsv($fp, array_merge($titulos));
                    }
                    fputcsv($fp, array_merge(array($i), $campos));
                }
                fclose($fp);
                if ($this->input->post('tipo_accion') == 1) {
                    //redirect("uploads/portal_inventario_temp/csv_enviados/$nombre_fichero");
                    if (file_exists("uploads/portal_inventario_temp/csv_enviados/$nombre_fichero")) {
                        unlink("uploads/portal_inventario_temp/csv_enviados/$nombre_fichero");
                    }
                    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                    header("Content-Disposition: attachment;filename=consulta_respuesta_agencia_" . date('d-m-Y_His') . ".xls");
                    header("Pragma: no-cache");
                    header("Expires: 0");
                    echo '<meta charset="utf-8" />';
                    echo "<table border='1'>
                      <tr><th colspan='4' align='center' >" . mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8') . "</th></tr>
                      <tr><th colspan='4' align='center' >Reporte de Respuesta - Agencia</th></tr>
                      <tr><th colspan='4' align='center' >" . $agencias . "</th></tr>
                      <tr><th colspan='4' align='center' >" . $filtro_titulo . "</th></tr>
                      </table>";
                    echo $html;
                    die();
                } else {
                    //enviar por correo.
                    $asunto = "REPORTE DE RESPUESTA - AGENCIA";
                    $mensaje = $this->load->view('encuesta/reportes/mensaje_correo_respuesta_sucursal', $data, true);
                    $correo_destino = explode(',', $this->gsatelite->get_parametro('SYS_CORREO_RECIBE_REPORTE_ENCUESTA'));

                    $this->db->join('emp_empleado', 'emp_id=usu_id_emp');
                    $registro_usuario = $this->gsatelite->get_registro('usu_usuario', 'usu_id', $this->tank_auth->get_user_id());
                    $correo_envia = $registro_usuario->usu_email;
                    $usuario_envia = $registro_usuario->emp_nombre . ' ' . $registro_usuario->emp_apellido;

                    $exito = $this->gsatelite->envio_correo($correo_envia, 'Portal Encuesta - ' . $usuario_envia, $correo_destino, $asunto, $mensaje, $correo_envia, FCPATH . "uploads/encuesta_temp/csv_enviados/$nombre_fichero");
                    if ($exito > 0) {
                        $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Correo enviado", 'texto_alerta' => "Correo enviado con éxito");
                    } else {
                        $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error de envio ", 'texto_alerta' => "Correo no puedo ser enviado");
                    }
                    $this->session->set_flashdata($alerta);
                }
                if (file_exists("uploads/encuesta_temp/csv_enviados/$nombre_fichero")) {
                    unlink("uploads/encuesta_temp/csv_enviados/$nombre_fichero");
                }

                redirect('encuesta/reportes/consulta_respuesta_sucursal');
            }
            redirect('encuesta/reportes/consulta_respuesta_sucursal');
        } else {
            die(json_encode(array('html' => $html)));
        }
    }

    /*
     * @author Mario Marquez
     */

    function consulta_respuesta_encuesta() {//consulta_respuesta_encuesta
        $data['titulo_personal'] = "Consultar Respuestas Encuesta";
        $permisos = $this->gsatelite->get_permisos_opcion('consulta_respuesta_encuesta');//consulta_respuesta_encuesta
        $data['sucursal'] = $this->gsatelite->get_dropdown('suc_sucursal', '{suc_nombre}', '', array('suc_estado' => '1'), null, '', 'suc_id', true);
        $data['permisos'] = $permisos;
        cargarvista($data);
    }

    /**
     * @author Rene Castaneda
     */
    public function filtrar_respuesta_cliente($es_reporte = 0) {
        $registros = array();
        //var_dump($_POST);die();
        $permisos = $this->gsatelite->get_permisos_opcion('consulta_respuesta_cliente');
        $data['permisos'] = $permisos;
        $txtFecha_desde = $this->input->post('txtFecha_desde');
        $txtFecha_hasta = $this->input->post('txtFecha_hasta');
        $slcAgencia = $this->input->post('slcAgencia');
        $slcEncuesta = $this->input->post('slcEncuesta');

        if ($txtFecha_desde != '' and $txtFecha_hasta != '' and $slcAgencia > 0 and $slcEncuesta > 0) {
            $where['date_format(ecl_fecha,"%Y-%m-%d") >='] = date('Y-m-d', strtotime($txtFecha_desde));
            $where['date_format(ecl_fecha,"%Y-%m-%d") <='] = date('Y-m-d', strtotime($txtFecha_hasta));
            $where['exs_id_suc'] = $slcAgencia;
            $where['exs_id_enc'] = $slcEncuesta;
            $registros = $this->encuesta_model->encuesta_cliente("ecl_id,cli_id,CONCAT_WS(' ',cli_nombre, cli_apellido) cliente, cli_correo, cli_telefono, ecl_fecha", 'ecl_fecha', $where, 'ecl_id');
           
            //$numero_encuesta=$this->encuesta_model->respuesta_preguntas('COUNT(DISTINCT ecl_id) n_encuestas','ecl_fecha',$where,'exs_id');
            //print_r($this->db->last_query()); die();
        }

        $reg_encuesta = $this->gsatelite->get_registro('enc_encuesta', 'enc_id', $this->input->post('slcEncuesta'));
        $reg_sucursal = $this->gsatelite->get_registro('suc_sucursal', 'suc_id', $this->input->post('slcAgencia'));
        $data['registros'] = $registros;
        $data['cantidad_registros'] = ($registros) ? " ( Se encontraron " . count($registros) . " Encuestas)" : '';
        $data['es_reporte'] = $es_reporte;
        //var_dump($registros);die();
        $data['txtFecha_desde'] = $this->input->post('txtFecha_desde');
        $data['txtFecha_hasta'] = $this->input->post('txtFecha_hasta');
        $data['slcAgencia'] = $this->input->post('slcAgencia');
        $data['slcEncuesta'] = $this->input->post('slcEncuesta');
        $data['periodo'] = date('d-m-Y', strtotime($txtFecha_desde)) . ' / ' . date('d-m-Y', strtotime($txtFecha_desde));
        $data['reg_encuesta'] = $reg_encuesta;
        $data['reg_sucursal'] = $reg_sucursal;

       /* echo '<pre>';
        print_r($data);
        echo '</pre>';*/

        $html = $this->load->view('encuesta/reportes/filtrar_respuesta_cliente', $data, true);
        if ($es_reporte == 1) {
            //echo $html; die();
            $filtro_titulo = $txtFecha_desde . " / " . $txtFecha_hasta . " <br />" . $reg_encuesta->enc_nombre . " / " . $data['cantidad_registros'];

            $data['nombre_sucursal'] = ($this->input->post('slcAgencia') > 0) ? $reg_sucursal->suc_nombre : "Todas";

            if ($this->input->post()) {
                $nombre_fichero = "consulta_respuesta_cliente_" . date('d-m-Y_His') . "_.csv";
                $fp = fopen("uploads/encuesta_temp/csv_enviados/$nombre_fichero", 'w');
                $i = 0;
                foreach ($registros as $campos) {
                    $ecl_id = $campos['ecl_id'];
                    unset($campos['ecl_id']);
                    $campos['ecl_fecha'] = date('d-m-Y H:i:s', strtotime($campos['ecl_fecha'])); //formatear la fecha.

                    $campos = array_map('utf8_decode', $campos);
                    //print_r($campos); die();
                    $i++;
                    if ($i == 1) {
                        $titulos = array('CLIENTE:', $campos['cliente'], '', '');
                        fputcsv($fp, array_merge($titulos));
                    }
                    //fputcsv($fp, array_merge(array($i), $campos));
                    $respuestas = $this->encuesta_model->respuesta_encuesta(array('ecl_id' => $ecl_id));
                    $titulos = array('#', 'TIPO', 'PREGUNTA', 'RESPUESTA');
                    fputcsv($fp, array_merge($titulos));
                    if (count($respuestas) > 0) {
                        $j = 0;
                        foreach ($respuestas as $resp) {
                            $j++;
                            $array_respuestas = array(
                                'Num' => $j,
                                'tipo' => ($resp['pre_tipo'] == 1) ? "Abierta" : "Cerrada",
                                'pregunta' => utf8_decode($resp['pre_nombre']),
                                'respuesta' => ($resp['pre_tipo'] == 1) ? utf8_decode($resp['rec_respuesta']) : ($resp['opr_nombre'])
                            );

                            fputcsv($fp, $array_respuestas);
                        }
                    }
                }
                fclose($fp);
                if ($this->input->post('tipo_accion') == 1) {
                    //redirect("uploads/portal_inventario_temp/csv_enviados/$nombre_fichero");
                    if (file_exists("uploads/portal_inventario_temp/csv_enviados/$nombre_fichero")) {
                        unlink("uploads/portal_inventario_temp/csv_enviados/$nombre_fichero");
                    }
                    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                    header("Content-Disposition: attachment;filename=consulta_encuesta_cliente_" . date('d-m-Y_His') . ".xls");
                    header("Pragma: no-cache");
                    header("Expires: 0");
                    echo '<meta charset="utf-8" />';
                    echo "<table border='1'>
                      <tr><th colspan='4' align='center' >" . mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8') . "</th></tr>
                      <tr><th colspan='4' align='center' >Reporte de Respuestas - Cliente</th></tr>
                      <tr><th colspan='4' align='center' >" . $data['nombre_sucursal'] . " - " . $filtro_titulo . "</th></tr>
                      </table>";
                    echo $html;
                    die();
                } else {
                    //enviar por correo.
                    $asunto = "REPORTE DE RESPUESTA - CLIENTE";
                    $mensaje = $this->load->view('encuesta/reportes/mensaje_correo_respuesta_cliente', $data, true);
                    $correo_destino = explode(',', $this->gsatelite->get_parametro('SYS_CORREO_RECIBE_REPORTE_ENCUESTA'));

                    $this->db->join('emp_empleado', 'emp_id=usu_id_emp');
                    $registro_usuario = $this->gsatelite->get_registro('usu_usuario', 'usu_id', $this->tank_auth->get_user_id());
                    $correo_envia = $registro_usuario->usu_email;
                    $usuario_envia = $registro_usuario->emp_nombre . ' ' . $registro_usuario->emp_apellido;
                    $exito = $this->gsatelite->envio_correo($correo_envia, 'Portal Encuesta - ' . $usuario_envia, $correo_destino, $asunto, $mensaje, $correo_envia, FCPATH . "uploads/encuesta_temp/csv_enviados/$nombre_fichero");
                    if ($exito > 0) {
                        $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Correo enviado", 'texto_alerta' => "Correo enviado con éxito");
                    } else {
                        $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error de envio ", 'texto_alerta' => "Correo no puedo ser enviado");
                    }
                    $this->session->set_flashdata($alerta);
                }
                if (file_exists("uploads/encuesta_temp/csv_enviados/$nombre_fichero")) {
                    unlink("uploads/encuesta_temp/csv_enviados/$nombre_fichero");
                }

                redirect('encuesta/reportes/consulta_respuesta_cliente');
            }
            redirect('encuesta/reportes/consulta_respuesta_cliente');
        } else {
            die(json_encode(array('html' => $html)));
        }
    }


     /**
     * @author Manuel Hernandez
     */
    public function filtrar_respuestaEncuesta($es_reporte = 0) {
        $maxColum=0;
        $registros = array();
        //var_dump($_POST);die();
        $permisos = $this->gsatelite->get_permisos_opcion('consulta_respuesta_encuesta');
        $data['permisos'] = $permisos;
        $txtFecha_desde = $this->input->post('txtFecha_desde');
        $txtFecha_hasta = $this->input->post('txtFecha_hasta');
        $slcAgencia = $this->input->post('slcAgencia');
        $slcEncuesta = $this->input->post('slcEncuesta');
        if ($txtFecha_desde != '' and $txtFecha_hasta != '' and $slcAgencia > 0 and $slcEncuesta > 0) {
            $where['date_format(ecl_fecha,"%Y-%m-%d") >='] = date('Y-m-d', strtotime($txtFecha_desde));
            $where['date_format(ecl_fecha,"%Y-%m-%d") <='] = date('Y-m-d', strtotime($txtFecha_hasta));
            $where['exs_id_suc'] = $slcAgencia;
            $where['exs_id_enc'] = $slcEncuesta;
            //Anteriormente se llamaba registros
            $encuestas = $this->encuesta_model->encuesta_cliente("ecl_id,cli_id,CONCAT_WS(' ',cli_nombre, cli_apellido) cliente, cli_correo, cli_telefono, ecl_fecha", 'ecl_fecha', $where, 'ecl_id');
        }

        $reg_encuesta = $this->gsatelite->get_registro('enc_encuesta', 'enc_id', $this->input->post('slcEncuesta'));
        $reg_sucursal = $this->gsatelite->get_registro('suc_sucursal', 'suc_id', $this->input->post('slcAgencia'));
        $data['registros'] = $encuestas;
        $data['cantidad_registros'] = ($encuestas) ? " ( Se encontraron " . count($encuestas) . " Encuestas)" : '';
        $data['es_reporte'] = $es_reporte;
        //var_dump($registros);die();
        $data['txtFecha_desde'] = $this->input->post('txtFecha_desde');
        $data['txtFecha_hasta'] = $this->input->post('txtFecha_hasta');
        $data['slcAgencia'] = $this->input->post('slcAgencia');
        $data['slcEncuesta'] = $this->input->post('slcEncuesta');
        $data['periodo'] = date('d-m-Y', strtotime($txtFecha_desde)) . ' / ' . date('d-m-Y', strtotime($txtFecha_desde));
        $data['reg_encuesta'] = $reg_encuesta;
        $data['reg_sucursal'] = $reg_sucursal;
        $ecl_id= $data['slcEncuesta'];
        /* 888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888 */
        if($ecl_id!=null){
            //Obteniendo las preguntas de la encuesta
            $where = array('pre_id_enc' => $slcEncuesta);
            $this->db->order_by('pre_orden ASC');
            $preguntas = $this->gsatelite->get_tabla('pre_pregunta', $where);
            //print_r($preguntas);die();
            //  $data['preguntas']=$preguntas;            

            //Obteniendo el nombre de la encuesta
            $where = array('enc_id' => $slcEncuesta);
            $encuesta = $this->gsatelite->get_tabla('enc_encuesta', $where);
            $nombreEncuesta=$encuesta[0]['enc_nombre'];

            $idEncuesta=$ecl_id;
            $data['idEncuesta']=$ecl_id;

            $detallePreguntas=Array();    

            //recorro el array de las preguntas para armar un nuevo array con todas las preguntas, respuestas y configuracionesF.
            foreach($preguntas as $row){
                $aux=Array();
                if($row['pre_tipo']==1 || ($row['pre_tipo']>3 && $row['pre_tipo']<9 )){ 
                    //Preguntas de texto
                    $aux=array(
                        'pre_id'=> $row['pre_id'],
                        'nombre'=> $row['pre_nombre'],
                        'descripcion'=> $row['pre_descripcion'],
                        'tipo' => $row['pre_tipo'],
                        // 'respuestas_cliente'=>null
                    );
                }elseif($row['pre_tipo']==2 || $row['pre_tipo']==3){ 
                    //Seleccion multiple o lista desplegable
                    $aux=array(
                        'pre_id'=> $row['pre_id'],
                        'nombre'=> $row['pre_nombre'],
                        'descripcion'=> $row['pre_descripcion'],
                        'tipo' => $row['pre_tipo'],
                        'respuesta'=>[],
                        // 'respuestas_cliente'=>[]
                    );                    
                    // Consulto las respuestas de estas preguntas
                    $where = array('opr_id_pre' => $row['pre_id']);
                    $respuestas = $this->gsatelite->get_tabla('opr_opcion_respuesta', $where);                   

                    //Recorremos vector de respuestas
                    foreach($respuestas as $row1){
                        $aux1=null;
                        $aux1['opr_id']=$row1['opr_id'];
                        $aux1['opr_nombre']=$row1['opr_nombre'];
                        $aux1['opr_aplica_especifique']=$row1['opr_aplica_especifique'];
                        array_push($aux['respuesta'],$aux1 );
                    }

                }elseif($row['pre_tipo']==10){
                    $aux=array(
                        'pre_id'=> $row['pre_id'],
                        'nombre'=> $row['pre_nombre'],
                        'descripcion'=> $row['pre_descripcion'],
                        'tipo' => $row['pre_tipo'],
                        'respuesta'=>[],
                        //  'respuestas_cliente'=>[],
                    );
                    $respuestas=$this->encuesta_model->opcion_respuesta(array('opr_id_pre' => $row['pre_id']));

                    //Recorremos vector de respuestas
                    foreach($respuestas as $row1){
                        $aux1=null;
                        $aux1['opr_id']=$row1['opr_id'];
                        $aux1['opr_id_ico']=$row1['opr_id_ico'];
                        $aux1['opr_notificacion_correo']=$row1['opr_notificacion_correo'];
                        $aux1['opr_nombre']=$row1['opr_nombre'];
                        $aux1['ico_nombre']=$row1['ico_nombre'];
                        $aux1['ico_url']=$row1['ico_url'];
                        array_push($aux['respuesta'],$aux1);
                    }

                }elseif($row['pre_tipo']==9 || $row['pre_tipo']==16){
                    $aux=array(
                       'pre_id'=> $row['pre_id'],
                       'nombre'=> $row['pre_nombre'],
                       'descripcion'=> $row['pre_descripcion'],
                       'tipo' => $row['pre_tipo'],
                       'respuesta'=>[],
                        //  'respuestas_cliente'=>[],
                   );

                    // Consulto las respuestas de estas preguntas
                    $where = array('opr_id_pre' => $row['pre_id']);
                    $respuestas = $this->gsatelite->get_tabla('opr_opcion_respuesta', $where);

                    //Recorremos vector de respuestas
                    foreach($respuestas as $row1){
                        $aux1=null;
                        $aux1['opr_id']=$row1['opr_id'];
                        $aux1['opr_id_pre']=$row1['opr_id_pre'];
                        $aux1['opr_nombre']=$row1['opr_nombre'];
                        $aux1['opr_aplica_especifique']=$row1['opr_aplica_especifique'];
                        $aux1['opr_tipo_campo_dinamico']=$row1['opr_tipo_campo_dinamico'];
                        $aux1['configuraciones']=[];

                        if($row1['opr_tipo_campo_dinamico']==2 || $row1['opr_tipo_campo_dinamico']==3){
                            $where = array('otd_id_opr' => $row1['opr_id']);
                            $configuraciones = $this->gsatelite->get_tabla('otd_opcion_tabla_dinamica', $where);

                            //Recorremos las configuraciones
                            foreach($configuraciones as $row2){
                                $aux2=null;
                                $aux2['otd_id']=$row2['otd_id'];
                                $aux2['otd_nombre']=$row2['otd_nombre'];
                                $aux2['otd_aplica_especifique']=$row2['otd_aplica_especifique'];
                                array_push($aux1['configuraciones'],$aux2);
                            }
                        }
                        array_push($aux['respuesta'],$aux1 );
                    }
                } elseif ($row['pre_tipo']==14 || $row['pre_tipo']==11 || $row['pre_tipo']==12 || $row['pre_tipo']==15) {
                    $aux=array(
                        'pre_id'=> $row['pre_id'],
                        'nombre'=> $row['pre_nombre'],
                        'descripcion'=> $row['pre_descripcion'],
                        'tipo' => $row['pre_tipo'],
                        // 'respuestas_cliente'=>null
                    );
                }

                array_push($detallePreguntas,$aux);
                //Fin de foreach 
            } 
            
            //Ahora recorremos el array detalle preguntas para introducir las respuestas de la bd
            $cont=0;
            $respuestasEncuesta=array();
            foreach($encuestas as $fila){
                $respuestasPregunta=array();
                foreach($detallePreguntas as $row){
                    $reg=array();
                    if($row['tipo']==1 || ($row['tipo']>=4 && $row['tipo']<=8)){ 
                        //tipo Texto, otras
                        $respuesta= $this->gsatelite->get_tabla('rec_respuesta_encuesta', array('rec_id_ecl' => $fila['ecl_id'], 'rec_id_pre'=>$row['pre_id']));
                        if(!empty($respuesta)){
                            //$detallePreguntas[$cont]['respuestas_cliente']=$respuesta[0]['rec_respuesta'] ;
                            $reg['tipo']=$row['tipo'];
                            $reg['tipo_nombre']=$this->tipoPregunta($row['tipo']);
                            $reg['pregunta']=$row['nombre'];
                            $reg['descripcion']=$row['descripcion'];
                            if($row['tipo']==4){
                                $reg['respuestas']=($respuesta[0]['rec_respuesta']==0)?'Falso':'Verdadero';
                            }else{
                                $reg['respuestas']=$respuesta[0]['rec_respuesta'];
                            }
                            array_push($respuestasPregunta,$reg);  
                        }     
                    }elseif($row['tipo']==2 || $row['tipo']==3){ 
                        //Lista de seleccion y seleccion multiple
                        $respuesta=$this->encuesta_model->respuesta_desplegable_multiple($fila['ecl_id'],$row['pre_id'] );
                        $i=0;
                        $aux2=array();
                        foreach($respuesta as $item){
                            $respItems=array();
                            if($row['tipo']==2)
                                $id=array_search($item['rec_id_opr'], array_column($row['respuesta'], 'opr_id'));
                            else    
                                $id=array_search($item['oxp_id_opr'], array_column($row['respuesta'], 'opr_id'));

                            $respItems['oxp_id_opr']=$item['oxp_id_opr'];
                            $respItems['respuesta']=$row['respuesta'][$id]['opr_nombre'];
                            $respItems['respuesta'].=(!empty($item['oxp_valor_referencia']))?' (<i>'.$item['oxp_valor_referencia'].'</i>)':'';

                            array_push($aux2,$respItems);
                        }
                        if(!empty($respuesta)){
                            // $detallePreguntas[$cont]['respuestas_cliente']=$respuesta;
                            $reg['tipo']=$row['tipo'];
                            $reg['tipo_nombre']=$this->tipoPregunta($row['tipo']);
                            $reg['pregunta']=$row['nombre'];
                            $reg['descripcion']=$row['descripcion']; 
                            $reg['respuestas']=$aux2;
                            array_push($respuestasPregunta,$reg);
                        }
                    }elseif($row['tipo']==9 || $row['tipo']==16){
                        //Tabla dinamica
                        $itemrespuesta= array();
                        foreach($row['respuesta'] as $items){
                            $itemrespuesta[]=$items['opr_nombre'];
                        }

                        $arrayRespuestas=[];
                        foreach($row['respuesta'] as $items){
                            $arrayRespuestas[]=$items['opr_id'];
                        }
                        $respuesta= $this->gsatelite->get_tabla('rec_respuesta_encuesta', array('rec_id_ecl' => $fila['ecl_id'], 'rec_id_pre'=>$row['pre_id']));
                        $numRespuestas=count($row['respuesta']);
                        //$numRespuestas=count($respuesta);
                        $contItems=0;
                        $aux=[];
                        $configuraciones=[];
                        $respuestaItems=array();
                        //print_r($respuesta);die();
                        // $respItems=array();
                        foreach($respuesta as $row1){
                            $aux=[];
                            //Buscamos el tipo de pregunta de la respuesta 
                            $numPregunta=0;                
                            foreach($row['respuesta'] as $row2){
                                if($row1['rec_id_opr']==$row2['opr_id']){
                                    $tipo=$row2['opr_tipo_campo_dinamico'];
                                } 
                                $numPregunta++;
                            }

                            /* ################################################################################################ */
                            if($tipo==1|| $tipo>3 && $tipo<=8){
                                $aux['tipo']=$tipo;
                                $aux['tipo_nombre']=$this->tipoPregunta($tipo);
                                $aux['rec_respuesta']=$row1['rec_respuesta'];
                                $aux['respuestas']=$aux['rec_respuesta'];
                                array_push($configuraciones,$aux);

                            }elseif($tipo==2){

                                //Consultamos si la opcion elegida tiene valor de especifique.
                                $especifique= $this->gsatelite->get_tabla('oxp_opcion_respuestaxpregunta', array('oxp_id_rec' => $row1['rec_id']));

                                $aux['tipo']=$tipo;
                                $aux['respuestas']=$especifique[0]['oxp_id_opr'];
                                $id=array_search($row1['rec_id_opr'], array_column($row['respuesta'], 'opr_id'));
                                $conf=array_search($aux['respuestas'], array_column($row['respuesta'][$id]['configuraciones'], 'otd_id'));

                                if($especifique[0]['oxp_valor_referencia']!=null)
                                    $aux['especifique']=$especifique[0]['oxp_valor_referencia'];

                                $aux['respuestas']=$row['respuesta'][$id]['configuraciones'][$conf]['otd_nombre'];
                                $aux['respuestas'].=(!empty($aux['especifique']))?'(<i>'.$aux['especifique'].'</i>)':'';

                                array_push($configuraciones,$aux);
                            }elseif($tipo==3){
                                $especifique= $this->gsatelite->get_tabla('oxp_opcion_respuestaxpregunta', array('oxp_id_rec' => $row1['rec_id']));  

                                $aux['tipo']=$tipo;
                                $aux['respuestas']=[];

                                $id=array_search($row1['rec_id_opr'], array_column($row['respuesta'], 'opr_id'));

                                foreach($especifique as $row3){
                                    $aux3=[];
                                    $aux3['oxp_id_opr']=$row3['oxp_id_opr'];
                                    $aux3['oxp_id_otd']=$row3['oxp_id_otd'];
                                    $aux3['oxp_valor_referencia']=$row3['oxp_valor_referencia'];
                                    $conf=array_search($row3['oxp_id_otd'], array_column($row['respuesta'][$id]['configuraciones'], 'otd_id'));

                                    $aux3['respuesta']=$row['respuesta'][$id]['configuraciones'][$conf]['otd_nombre'];
                                    $aux3['respuesta'].=(!empty($row3['oxp_valor_referencia']))?' (<i>'.$row3['oxp_valor_referencia'].'</i>)':'';
                                    array_push($aux['respuestas'], $aux3);
                                }
                                array_push($configuraciones,$aux);
                            }
                            /* ################################################################################################ */
                            // if ($contItems == 1) {
                                //print_r(count($respuesta));die();
                                //print_r($numRespuestas);die();
                            // }
                            
                            if($contItems<$numRespuestas-1){
                                $contItems++;
                            }else{
                                array_push($respuestaItems,$configuraciones);
                                $configuraciones=[];
                                $contItems=0;
                            }

                        }
                        if(count($respuesta) < (count($row['respuesta']) -1) ){
                            array_push($respuestaItems,$configuraciones);
                        }
                        //print_r($respuesta);die();
                        //print_r($respuestaItems);die();
                        if(!empty($respuestaItems)){
                            $reg['tipo']=$row['tipo'];
                            $reg['tipo_nombre']=$this->tipoPregunta($row['tipo']);
                            $reg['pregunta']=$row['nombre'];
                            $reg['descripcion']=$row['descripcion']; 
                            $reg['configuraciones']=$itemrespuesta;
                            if(count($reg['configuraciones'])>$maxColum)
                                $maxColum=count($reg['configuraciones']);
                            $reg['respuestas']=$respuestaItems;
                            //print_r("entra aqui");die();
                            array_push($respuestasPregunta,$reg);
                        }
                        //print_r($respuestasPregunta);die();
                    }elseif($row['tipo']==10){ 
                        //Lista de iconos
                        $respuesta= $this->gsatelite->get_tabla('rec_respuesta_encuesta', array('rec_id_ecl' => $fila['ecl_id'], 'rec_id_pre'=>$row['pre_id']));

                        if(!empty($respuesta)){
                            // $detallePreguntas[$cont]['respuestas_cliente']=$respuesta[0]['rec_id_opr'] ; 
                            $reg['tipo']=$row['tipo'];
                            $reg['tipo_nombre']=$this->tipoPregunta($row['tipo']);
                            $reg['pregunta']=$row['nombre'];
                            $reg['descripcion']=$row['descripcion'];
                            $reg['respuesta']=$respuesta[0]['rec_id_opr'];
                            $conf=array_search($respuesta[0]['rec_id_opr'], array_column($row['respuesta'], 'opr_id'));
                            $reg['opr_nombre']=$row['respuesta'][$conf]['opr_nombre'];
                            $reg['ico_url']=$row['respuesta'][$conf]['ico_url'];
                            array_push($respuestasPregunta,$reg);  
                        }
                    } elseif ($row['tipo']==14) {
                        $respuesta= $this->gsatelite->get_tabla('rec_respuesta_encuesta', array('rec_id_ecl' => $fila['ecl_id'], 'rec_id_pre'=>$row['pre_id']));

                        if(!empty($respuesta)){
                            $reg['tipo']=$row['tipo'];
                            $reg['tipo_nombre']=$this->tipoPregunta($row['tipo']);
                            $reg['pregunta']=$row['nombre'];
                            $reg['descripcion']=$row['descripcion'];
                            $reg['respuestas']=$respuesta[0]['rec_respuesta'];
                            array_push($respuestasPregunta,$reg); 
                        }
                    } elseif ($row['tipo']==11 || $row['tipo']==12 || $row['tipo']==15) {
                        $this->db->join("anr_anexo_respuesta","anr_id_rec = rec_id","left");
                        $respuesta= $this->gsatelite->get_tabla('rec_respuesta_encuesta', array('rec_id_ecl' => $fila['ecl_id'], 'rec_id_pre'=>$row['pre_id']));

                        if(!empty($respuesta)){
                            $reg['tipo']=$row['tipo'];
                            $reg['tipo_nombre']=$this->tipoPregunta($row['tipo']);
                            $reg['pregunta']=$row['nombre'];
                            $reg['descripcion']=$row['descripcion'];
                            $ruta = ($row['tipo']==15)? base_url($respuesta[0]['rec_respuesta']) : base_url($respuesta[0]['anr_ruta_archivo']."/".$respuesta[0]["anr_nombre_archivo"]) ;
                            $nombre_direccion = ($row['tipo']==15)? 'Dibujo' : $respuesta[0]["anr_nombre_archivo"];
                            //$clase = ($row['tipo']==11)? 'preg_tipo_11' : 'preg_tipo_12';
                            $clase = "preg_tipo_12y11";
                            $reg['respuestas']='<a target="_blank" class="'.$clase.'" href="' . $ruta . '">'. $nombre_direccion .'</a>';
                            array_push($respuestasPregunta,$reg); 
                        }
                    } 
                    $cont++;
                //fin de  foreach($detallePreguntas as $row)            
                } 

                if(!empty($respuestasPregunta))
                    array_push($respuestasEncuesta,$respuestasPregunta);
            } //Fin foreach encuestas

            $data['preguntas'] = $detallePreguntas;
            $data['respuestas']=$respuestasEncuesta;
            $data['maxColum']=$maxColum;            

            $html = $this->load->view('encuesta/reportes/filtrar_respuestaCliente', $data, true);
            if ($es_reporte == 1) {
                //echo $html; die();
                $filtro_titulo = $txtFecha_desde . " / " . $txtFecha_hasta . " <br />" . $reg_encuesta->enc_nombre . " / " . $data['cantidad_registros'];
                $data['nombre_sucursal'] = ($this->input->post('slcAgencia') > 0) ? $reg_sucursal->suc_nombre : "Todas";

                if ($this->input->post()) {
                    $nombre_fichero = "consulta_respuesta_cliente_" . date('d-m-Y_His') . "_.csv";
                    $fp = fopen("uploads/encuesta_temp/csv_enviados/$nombre_fichero", 'w');
                    $i = 0;
                    foreach ($registros as $campos) {
                        $ecl_id = $campos['ecl_id'];
                        unset($campos['ecl_id']);
                        $campos['ecl_fecha'] = date('d-m-Y H:i:s', strtotime($campos['ecl_fecha'])); 
                        //formatear la fecha.

                        $campos = array_map('utf8_decode', $campos);
                        //print_r($campos); die();
                        $i++;
                        if ($i == 1) {
                            $titulos = array('CLIENTE:', $campos['cliente'], '', '');
                            fputcsv($fp, array_merge($titulos));
                        }
                        //fputcsv($fp, array_merge(array($i), $campos));
                        $respuestas = $this->encuesta_model->respuesta_encuesta(array('ecl_id' => $ecl_id));
                        $titulos = array('#', 'TIPO', 'PREGUNTA', 'RESPUESTA');
                        fputcsv($fp, array_merge($titulos));
                        if (count($respuestas) > 0) {
                            $j = 0;
                            foreach ($respuestas as $resp) {
                                $j++;
                                $array_respuestas = array(
                                    'Num' => $j,
                                    'tipo' => ($resp['pre_tipo'] == 1) ? "Abierta" : "Cerrada",
                                    'pregunta' => utf8_decode($resp['pre_nombre']),
                                    'respuesta' => ($resp['pre_tipo'] == 1) ? utf8_decode($resp['rec_respuesta']) : ($resp['opr_nombre'])
                                );

                                fputcsv($fp, $array_respuestas);
                            }
                        }
                    }
                    fclose($fp);
                    if ($this->input->post('tipo_accion') == 1) {
                        //redirect("uploads/portal_inventario_temp/csv_enviados/$nombre_fichero");
                        if (file_exists("uploads/portal_inventario_temp/csv_enviados/$nombre_fichero")) {
                            unlink("uploads/portal_inventario_temp/csv_enviados/$nombre_fichero");
                        }
                        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                        header("Content-Disposition: attachment;filename=consulta_encuesta_cliente_" . date('d-m-Y_His') . ".xls");
                        header("Pragma: no-cache");
                        header("Expires: 0");
                        echo '<meta charset="utf-8" />';
                        echo "<table border='1'>
                        <tr><th colspan='4' align='center' >" . mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8') . "</th></tr>
                        <tr><th colspan='4' align='center' >Reporte de Respuestas - Encuesta</th></tr>
                        <tr><th colspan='4' align='center' >" . $data['nombre_sucursal'] . " - " . $filtro_titulo . "</th></tr>
                        </table>";
                        echo $html;
                        die();
                    } else {
                        //enviar por correo.
                        $asunto = "REPORTE DE RESPUESTA - ENCUESTA";
                        $mensaje = $this->load->view('encuesta/reportes/mensaje_correo_respuesta_cliente', $data, true);
                        $correo_destino = explode(',', $this->gsatelite->get_parametro('SYS_CORREO_RECIBE_REPORTE_ENCUESTA'));

                        $this->db->join('emp_empleado', 'emp_id=usu_id_emp');
                        $registro_usuario = $this->gsatelite->get_registro('usu_usuario', 'usu_id', $this->tank_auth->get_user_id());
                        $correo_envia = $registro_usuario->usu_email;
                        $usuario_envia = $registro_usuario->emp_nombre . ' ' . $registro_usuario->emp_apellido;
                        $exito = $this->gsatelite->envio_correo($correo_envia, 'Portal Encuesta - ' . $usuario_envia, $correo_destino, $asunto, $mensaje, $correo_envia, FCPATH . "uploads/encuesta_temp/csv_enviados/$nombre_fichero");
                        if ($exito > 0) {
                            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Correo enviado", 'texto_alerta' => "Correo enviado con éxito");
                        } else {
                            $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error de envio ", 'texto_alerta' => "Correo no puedo ser enviado");
                        }
                        $this->session->set_flashdata($alerta);
                    }
                    if (file_exists("uploads/encuesta_temp/csv_enviados/$nombre_fichero")) {
                        unlink("uploads/encuesta_temp/csv_enviados/$nombre_fichero");
                    }
                    redirect('encuesta/reportes/consulta_respuesta_encuesta');
                }
                redirect('encuesta/reportes/consulta_respuesta_encuesta');
            } else {
                die(json_encode(array('html' => $html)));
            }
        // fin de enc_id==null 
        } 
        /* 888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888 */
    }


public function tipoPregunta($tipo=0){
    switch($tipo) {
        case '1':
            $tipo_pregunta_texto = "Texto";
            break;
        case '2':
            $tipo_pregunta_texto = "Lista Desplegable";
            break;
        case '3':
            $tipo_pregunta_texto = "Selección Múltiple";
            break;
        case '4':
            $tipo_pregunta_texto = "Falso/Verdadero";
          break;
        case '5':
            $tipo_pregunta_texto = "Númerico Entero";
          break;
        case '6':
            $tipo_pregunta_texto = "Número Decimal";
            break;
        case '7':
            $tipo_pregunta_texto = "Fecha";
            break;
        case '8':
            $tipo_pregunta_texto = "Hora";
            break;
        case '9':
            $tipo_pregunta_texto = "Tabla Dinámica";
            break;
        case '10':
            $tipo_pregunta_texto = "Íconos";
            break;
        case '11':
            $tipo_pregunta_texto = "Imagen";
            break;
        case '12':
            $tipo_pregunta_texto = "Archivo";
            break;
        case '14':
            $tipo_pregunta_texto = "Georeferencia";
            break;
        case '15':
            $tipo_pregunta_texto = "Dibujo";
            break;
        case '16':
            $tipo_pregunta_texto = "Tabla Dinámica Indexada";
            break;
        default:
            $tipo_pregunta_texto='';
        break;
      }

      return $tipo_pregunta_texto;
}



     /*
     * @author Manuel Hernández
     */

    function consulta_respuesta_graficos() {
        $data['titulo_personal'] = "Consultar Respuestas - Gráficos";
        $permisos = $this->gsatelite->get_permisos_opcion();
        $data['sucursal'] = $this->gsatelite->get_dropdown('suc_sucursal', '{suc_nombre}', '', array('suc_estado' => '1'), null, '', 'suc_id', true);
        $data['permisos'] = $permisos;
        cargarvista($data);
    }


    /*
    * @author Manuel Hernandez
    */

    public function filtrar_consulta_respuesta_graficos($es_reporte=0){
        $maxColum=0;
        $registros = array();
        //var_dump($_POST);die();
        $permisos = $this->gsatelite->get_permisos_opcion('consulta_respuesta_graficos');
        $data['permisos'] = $permisos;
        $txtFecha_desde = $this->input->post('txtFecha_desde');
        $txtFecha_hasta = $this->input->post('txtFecha_hasta');
        $slcAgencia = $this->input->post('slcAgencia');
        $slcEncuesta = $this->input->post('slcEncuesta');

        if ($txtFecha_desde != '' and $txtFecha_hasta != '' and $slcAgencia > 0 and $slcEncuesta > 0) {
            $where['date_format(ecl_fecha,"%Y-%m-%d") >='] = date('Y-m-d', strtotime($txtFecha_desde));
            $where['date_format(ecl_fecha,"%Y-%m-%d") <='] = date('Y-m-d', strtotime($txtFecha_hasta));
            $where['exs_id_suc'] = $slcAgencia;
            $where['exs_id_enc'] = $slcEncuesta;
            //Anteriormente se llamaba registros
            $encuestas = $this->encuesta_model->encuesta_cliente("ecl_id,cli_id,CONCAT_WS(' ',cli_nombre, cli_apellido) cliente, cli_correo, cli_telefono, ecl_fecha", 'ecl_fecha', $where, 'ecl_id');
        }

        $reg_encuesta = $this->gsatelite->get_registro('enc_encuesta', 'enc_id', $this->input->post('slcEncuesta'));
        $reg_sucursal = $this->gsatelite->get_registro('suc_sucursal', 'suc_id', $this->input->post('slcAgencia'));
        $data['registros'] = $encuestas;
        $data['cantidad_registros'] = ($encuestas) ? " ( Se encontraron " . count($encuestas) . " Encuestas)" : '';
        $data['es_reporte'] = $es_reporte;
        //var_dump($registros);die();
        $data['txtFecha_desde'] = $this->input->post('txtFecha_desde');
        $data['txtFecha_hasta'] = $this->input->post('txtFecha_hasta');
        $data['slcAgencia'] = $this->input->post('slcAgencia');
        $data['slcEncuesta'] = $this->input->post('slcEncuesta');
        $data['periodo'] = date('d-m-Y', strtotime($txtFecha_desde)) . ' / ' . date('d-m-Y', strtotime($txtFecha_desde));
        $data['reg_encuesta'] = $reg_encuesta;
        $data['reg_sucursal'] = $reg_sucursal;

        $ecl_id= $data['slcEncuesta'];

    /* 888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888 */
    if($ecl_id!=null){

    //Obteniendo las preguntas de la encuesta
    $where = array('pre_id_enc' => $slcEncuesta);
    $this->db->order_by('pre_orden ASC');
    $preguntas = $this->gsatelite->get_tabla('pre_pregunta', $where);
    
     //Obteniendo el nombre de la encuesta
     $where = array('enc_id' => $slcEncuesta);
     $encuesta = $this->gsatelite->get_tabla('enc_encuesta', $where);
     $nombreEncuesta=$encuesta[0]['enc_nombre'];

    $idEncuesta=$ecl_id;
    $data['idEncuesta']=$ecl_id;

    $detallePreguntas=Array();

    
    //recorro el array de las preguntas para armar un nuevo array con todas las preguntas, respuestas y configuracionesF.
    foreach($preguntas as $row){
         $aux=Array();
         if($row['pre_tipo']==1 || ($row['pre_tipo']>4 && $row['pre_tipo']<9 )){ //Preguntas de texto
             $aux=array(
                 'pre_id'=> $row['pre_id'],
                 'nombre'=> $row['pre_nombre'],
                 'descripcion'=> $row['pre_descripcion'],
                 'tipo' => $row['pre_tipo'],
                 'respuesta'=>[]
                // 'respuestas_cliente'=>null
             );
         }elseif($row['pre_tipo']==2 || $row['pre_tipo']==3){ //Seleccion multiple o lista desplegable
                 $aux=array(
                     'pre_id'=> $row['pre_id'],
                     'nombre'=> $row['pre_nombre'],
                     'descripcion'=> $row['pre_descripcion'],
                     'tipo' => $row['pre_tipo'],
                     'respuesta'=>[],
                    // 'respuestas_cliente'=>[]
                 );
             
                 // Consulto las respuestas de estas preguntas
                 $where = array('opr_id_pre' => $row['pre_id']);
                 $respuestas = $this->gsatelite->get_tabla('opr_opcion_respuesta', $where);
             
                 
                 //Recorremos vector de respuestas
                 foreach($respuestas as $row1){
                     $aux1=null;
                         $aux1['opr_id']=$row1['opr_id'];
                         $aux1['opr_nombre']=$row1['opr_nombre'];
                         $aux1['opr_aplica_especifique']=$row1['opr_aplica_especifique'];
                         $aux1['n_respuestas']=0;
                         array_push($aux['respuesta'],$aux1 );
                 }
             
                 

         }elseif($row['pre_tipo']==4){
            $aux=array(
                'pre_id'=> $row['pre_id'],
                'nombre'=> $row['pre_nombre'],
                'descripcion'=> $row['pre_descripcion'],
                'tipo' => $row['pre_tipo'],
                'respuesta'=>array(array('respuesta'=>'Falso','n_respuestas'=>0),array('respuesta'=>'Verdadero','n_respuestas'=>0))
               // 'respuestas_cliente'=>null
            );

         }elseif($row['pre_tipo']==10){
             $aux=array(
                 'pre_id'=> $row['pre_id'],
                 'nombre'=> $row['pre_nombre'],
                 'descripcion'=> $row['pre_descripcion'],
                 'tipo' => $row['pre_tipo'],
                 'respuesta'=>[],
               //  'respuestas_cliente'=>[],
             );
             $respuestas=$this->encuesta_model->opcion_respuesta(array('opr_id_pre' => $row['pre_id']));
             
             //Recorremos vector de respuestas
             foreach($respuestas as $row1){
                 $aux1=null;
                     $aux1['opr_id']=$row1['opr_id'];
                     $aux1['opr_id_ico']=$row1['opr_id_ico'];
                     $aux1['opr_notificacion_correo']=$row1['opr_notificacion_correo'];
                     $aux1['opr_nombre']=$row1['opr_nombre'];
                     $aux1['ico_nombre']=$row1['ico_nombre'];
                     $aux1['ico_url']=$row1['ico_url'];
                     $aux1['n_respuestas']=0;
                     array_push($aux['respuesta'],$aux1);
             }
             
         }elseif($row['pre_tipo']==9){
             $aux=array(
                 'pre_id'=> $row['pre_id'],
                 'nombre'=> $row['pre_nombre'],
                 'descripcion'=> $row['pre_descripcion'],
                 'tipo' => $row['pre_tipo'],
                 'respuesta'=>[]
             );
         
             // Consulto las respuestas de estas preguntas
             $where = array('opr_id_pre' => $row['pre_id']);
             $respuestas = $this->gsatelite->get_tabla('opr_opcion_respuesta', $where);
                                     
             //Recorremos vector de respuestas
             foreach($respuestas as $row1){
                 $aux1=null;
                 $aux1['opr_id']=$row1['opr_id'];
                 $aux1['opr_id_pre']=$row1['opr_id_pre'];
                 $aux1['opr_nombre']=$row1['opr_nombre'];
                 $aux1['opr_aplica_especifique']=$row1['opr_aplica_especifique'];
                 $aux1['opr_tipo_campo_dinamico']=$row1['opr_tipo_campo_dinamico'];
                 $aux1['configuraciones']=[];
                 if($row1['opr_tipo_campo_dinamico']==1 || $row1['opr_tipo_campo_dinamico']>4 && $row1['opr_tipo_campo_dinamico']<9 ){
                    $aux1['respuestas']=[];
                 }elseif($row1['opr_tipo_campo_dinamico']==4){
                    $aux1['respuestas']=array(array('respuesta'=>'Falso','n_respuestas'=>0),array('respuesta'=>'Verdadero','n_respuestas'=>0));
                 }

                 if($row1['opr_tipo_campo_dinamico']==2 || $row1['opr_tipo_campo_dinamico']==3){
                     $where = array('otd_id_opr' => $row1['opr_id']);
                     $configuraciones = $this->gsatelite->get_tabla('otd_opcion_tabla_dinamica', $where);
                     
                     //Recorremos las configuraciones

                     foreach($configuraciones as $row2){
                         $aux2=null;
                         $aux2['otd_id']=$row2['otd_id'];
                         $aux2['otd_nombre']=$row2['otd_nombre'];
                         $aux2['otd_aplica_especifique']=$row2['otd_aplica_especifique'];
                         $aux2['n_respuestas']=0;
                         array_push($aux1['configuraciones'],$aux2);
                     }
                 }
                 array_push($aux['respuesta'],$aux1 );
             }
         } 

        
         

         array_push($detallePreguntas,$aux);

    } //Fin de foreach 



    //Ahora recorremos el array detalle preguntas para introducir las respuestas de la bd
    $cont=0;
    $respuestasEncuesta=array();
    foreach($encuestas as $fila){
        $respuestasPregunta=array();
        foreach($detallePreguntas as $row){
            $reg=array();
            if($row['tipo']==1 || ($row['tipo']>=4 && $row['tipo']<=8)){ //tipo Texto, otras
                $respuesta= $this->gsatelite->get_tabla('rec_respuesta_encuesta', array('rec_id_ecl' => $fila['ecl_id'], 'rec_id_pre'=>$row['pre_id']));
                if(!empty($respuesta)){
                    //$detallePreguntas[$cont]['respuestas_cliente']=$respuesta[0]['rec_respuesta'] ;
                    $reg['pre_id']=$row['pre_id'];
                    $reg['tipo']=$row['tipo'];
                    $reg['tipo_nombre']=$this->tipoPregunta($row['tipo']);
                    $reg['pregunta']=$row['nombre'];
                    $reg['descripcion']=$row['descripcion'];
                    if($row['tipo']==4){
                        $reg['respuestas']=($respuesta[0]['rec_respuesta']==0)?'Falso':'Verdadero';
                    }else{
                        $reg['respuestas']=$respuesta[0]['rec_respuesta'];
                    }
                   
                    array_push($respuestasPregunta,$reg);  
                }     
            }elseif($row['tipo']==2 || $row['tipo']==3){ //Lista de seleccion y seleccion multiple
                $respuesta=$this->encuesta_model->respuesta_desplegable_multiple($fila['ecl_id'],$row['pre_id'] );
                $i=0;
                $aux2=array();
                foreach($respuesta as $item){
                    $respItems=array();
                    if($row['tipo']==2)
                        $id=array_search($item['rec_id_opr'], array_column($row['respuesta'], 'opr_id'));
                    else    
                        $id=array_search($item['oxp_id_opr'], array_column($row['respuesta'], 'opr_id'));
                        $respItems['rec_id_opr']=$item['rec_id_opr'];
                        $respItems['oxp_id_opr']=$item['oxp_id_opr'];
                        $respItems['respuesta']=$row['respuesta'][$id]['opr_nombre'];
                        $respItems['respuesta'].=(!empty($item['oxp_valor_referencia']))?' (<i>'.$item['oxp_valor_referencia'].'</i>)':'';
                    
                    array_push($aux2,$respItems);
                }
                if(!empty($respuesta)){
                   // $detallePreguntas[$cont]['respuestas_cliente']=$respuesta;
                   $reg['pre_id']=$row['pre_id'];
                   $reg['tipo']=$row['tipo'];
                   $reg['tipo_nombre']=$this->tipoPregunta($row['tipo']);
                   $reg['pregunta']=$row['nombre'];
                   $reg['descripcion']=$row['descripcion']; 
                   $reg['respuestas']=$aux2;
                   array_push($respuestasPregunta,$reg);
                }
            }elseif($row['tipo']==9){//Tabla dinamica
                $itemrespuesta= array();

                foreach($row['respuesta'] as $items){
                    $itemrespuesta[]=$items['opr_nombre'];
                }

                $arrayRespuestas=[];
                foreach($row['respuesta'] as $items){
                    $arrayRespuestas[]=$items['opr_id'];
                }

                $respuesta= $this->gsatelite->get_tabla('rec_respuesta_encuesta', array('rec_id_ecl' => $fila['ecl_id'], 'rec_id_pre'=>$row['pre_id']));
                $numRespuestas=count($row['respuesta']);
                $contItems=0;
                $aux=[];
                $configuraciones=[];
                $respuestaItems=array();
                
               // $respItems=array();
                foreach($respuesta as $row1){
                    $aux=[];
                    //Buscamos el tipo de pregunta de la respuesta 
                    $numPregunta=0;
                
                    foreach($row['respuesta'] as $row2){
                        if($row1['rec_id_opr']==$row2['opr_id']){
                            $tipo=$row2['opr_tipo_campo_dinamico'];
                        } 
                    $numPregunta++;
                    }

                    /* ################################################################################################ */
                        if($tipo==1|| $tipo>3 && $tipo<=8){
                            $aux['tipo']=$tipo;
                            $aux['tipo_nombre']=$this->tipoPregunta($tipo);
                            $aux['rec_respuesta']=$row1['rec_respuesta'];
                            $aux['respuestas']=$aux['rec_respuesta'];
                            array_push($configuraciones,$aux);

                        }elseif($tipo==2){

                            //Consultamos si la opcion elegida tiene valor de especifique.
                            $especifique= $this->gsatelite->get_tabla('oxp_opcion_respuestaxpregunta', array('oxp_id_rec' => $row1['rec_id']));
                            
                            $aux['tipo']=$tipo;
                            $aux['oxp_id_opr']=$especifique[0]['oxp_id_opr'];
                            $aux['respuestas']=$especifique[0]['oxp_id_opr'];
                            $id=array_search($row1['rec_id_opr'], array_column($row['respuesta'], 'opr_id'));
                            $conf=array_search($aux['respuestas'], array_column($row['respuesta'][$id]['configuraciones'], 'otd_id'));

                            if($especifique[0]['oxp_valor_referencia']!=null)
                                $aux['especifique']=$especifique[0]['oxp_valor_referencia'];

                            $aux['respuestas']=$row['respuesta'][$id]['configuraciones'][$conf]['otd_nombre'];
                            $aux['respuestas'].=(!empty($aux['especifique']))?'(<i>'.$aux['especifique'].'</i>)':'';

                            array_push($configuraciones,$aux);
                        }elseif($tipo==3){
                            
                            $especifique= $this->gsatelite->get_tabla('oxp_opcion_respuestaxpregunta', array('oxp_id_rec' => $row1['rec_id'])); 
                            $aux['tipo']=$tipo;
                            $aux['respuestas']=[];
                            $id=array_search($row1['rec_id_opr'], array_column($row['respuesta'], 'opr_id'));
                            
                            foreach($especifique as $row3){
                                $aux3=[];
                                $aux3['oxp_id_opr']=$row3['oxp_id_opr'];
                                $aux3['oxp_id_otd']=$row3['oxp_id_otd'];
                                $aux3['oxp_valor_referencia']=$row3['oxp_valor_referencia'];

                               /* echo 'row3<pre>';
                            print_r($row3);
                            echo '</pre>'; 

                            echo '<pre>';
                            print_r($row['respuesta'][$id]['configuraciones']);
                            echo '</pre>'; */


                                $conf=array_search($row3['oxp_id_otd'], array_column($row['respuesta'][$id]['configuraciones'], 'otd_id'));
                                $aux3['respuesta']=$row['respuesta'][$id]['configuraciones'][$conf]['otd_nombre'];
                                $aux3['respuesta'].=(!empty($row3['oxp_valor_referencia']))?' (<i>'.$row3['oxp_valor_referencia'].'</i>)':'';
                                array_push($aux['respuestas'], $aux3);
                            }
                            array_push($configuraciones,$aux);
                        }
                    /* ################################################################################################ */

                    if($contItems<$numRespuestas-1){
                        $contItems++;
                    }else{
                        array_push($respuestaItems,$configuraciones);
                        $configuraciones=[];
                        $contItems=0;
                    }
 
                }

                if(!empty($respuestaItems)){
                    $reg['pre_id']=$row['pre_id'];
                    $reg['tipo']=$row['tipo'];
                    $reg['tipo_nombre']=$this->tipoPregunta($row['tipo']);
                    $reg['pregunta']=$row['nombre'];
                    $reg['descripcion']=$row['descripcion']; 
                    $reg['configuraciones']=$itemrespuesta;
                    if(count($reg['configuraciones'])>$maxColum)
                        $maxColum=count($reg['configuraciones']);
                    $reg['respuestas']=$respuestaItems;
                    array_push($respuestasPregunta,$reg);
                }
            }elseif($row['tipo']==10){ //Lista de iconos
                $respuesta= $this->gsatelite->get_tabla('rec_respuesta_encuesta', array('rec_id_ecl' => $fila['ecl_id'], 'rec_id_pre'=>$row['pre_id']));
                
                if(!empty($respuesta)){
                   // $detallePreguntas[$cont]['respuestas_cliente']=$respuesta[0]['rec_id_opr'] ; 


                   $reg['pre_id']=$row['pre_id']; 
                   $reg['tipo']=$row['tipo'];
                    $reg['tipo_nombre']=$this->tipoPregunta($row['tipo']);
                    $reg['pregunta']=$row['nombre'];
                    $reg['descripcion']=$row['descripcion'];
                    $reg['respuesta']=$respuesta[0]['rec_id_opr'];
                    $conf=array_search($respuesta[0]['rec_id_opr'], array_column($row['respuesta'], 'opr_id'));
                    $reg['opr_nombre']=$row['respuesta'][$conf]['opr_nombre'];
                    $reg['ico_url']=$row['respuesta'][$conf]['ico_url'];
                    array_push($respuestasPregunta,$reg);  
                }
            }
            $cont++;
            
        } //fin de  foreach($detallePreguntas as $row)

      
        if(!empty($respuestasPregunta))
            array_push($respuestasEncuesta,$respuestasPregunta);
    } //Fin foreach encuestas

   /* echo '$respuestasEncuesta<pre>';
    print_r($respuestasEncuesta);
    echo '</pre>'; */

   /* echo '$detallePreguntas<pre>';
    print_r($detallePreguntas);
    echo '</pre>'; */

    $graficar=array();
    //recorremos el vector de preguntas 
    $i=0;
    foreach($detallePreguntas as $row){
        $aux=[];

        $idPregunta=$row['pre_id'];
        $aux['pre_id']=$idPregunta;
        $aux['respuestas']=array();
       /* echo '$respuestasEncuesta<pre>';
                            print_r($respuestasEncuesta);
                            echo '</pre>';*/

        foreach($respuestasEncuesta as $enc){
            $resp=null;
            foreach($enc as $row2){
                if($idPregunta==$row2['pre_id']){
                    if($row2['tipo']==1 || $row2['tipo']>4 && $row2['tipo']<9){
                        $resp=$row2['respuestas'];
                        if($resp!=null){
                            $detallePreguntas[$i]['respuesta'][]=$resp;
                         }
                    }elseif($row2['tipo']==2 ){
                        foreach($row2['respuestas'] as $item){
                            $id=array_search($item['rec_id_opr'], array_column($detallePreguntas[$i]['respuesta'], 'opr_id'));
                            if($id>=0){
                                $detallePreguntas[$i]['respuesta'][$id]['n_respuestas']+=1; 
                            }
                        }  
                    }elseif($row2['tipo']==3){
                        foreach($row2['respuestas'] as $item){
                            $id=array_search($item['oxp_id_opr'], array_column($detallePreguntas[$i]['respuesta'], 'opr_id'));
                            if($id>=0){
                                $detallePreguntas[$i]['respuesta'][$id]['n_respuestas']+=1; 
                            }
                        } 
                    }elseif($row2['tipo']==4){
                       if($row2['respuestas']=='Falso'){
                        $detallePreguntas[$i]['respuesta'][0]['n_respuestas']+=1;  
                       }elseif($row2['respuestas']=='Verdadero'){
                        $detallePreguntas[$i]['respuesta'][1]['n_respuestas']+=1;  
                       }
            
                    }elseif($row2['tipo']==9){
                        foreach($row2['respuestas'] as $respEnc){
                            foreach($respEnc as $item){
                                if($item['tipo']==1 || $item['tipo']>4 && $item['tipo']<9){
                                    $id=array_search($item['tipo'], array_column($detallePreguntas[$i]['respuesta'], 'opr_tipo_campo_dinamico'));
                                    if($id>=0){
                                    $detallePreguntas[$i]['respuesta'][$id]['respuestas'][]=$item['rec_respuesta'];
                                    }
                                }elseif($item['tipo']==2){
                                    $id=array_search($item['tipo'], array_column($detallePreguntas[$i]['respuesta'], 'opr_tipo_campo_dinamico'));
                                    if($id>0){

                                        
                                        $idc=array_search($item['oxp_id_opr'], array_column($detallePreguntas[$i]['respuesta'][$id]['configuraciones'], 'otd_id'));
                                        if($idc>=0){
                                            $detallePreguntas[$i]['respuesta'][$id]['configuraciones'][$idc]['n_respuestas']+=1;
                                        }
                                    }
                                }elseif($item['tipo']==3){
                                    $id=array_search($item['tipo'], array_column($detallePreguntas[$i]['respuesta'], 'opr_tipo_campo_dinamico'));

                                    if($id>=0){
                                        foreach($item['respuestas'] as $x){
                                            $j=array_search($x['oxp_id_opr'], array_column($detallePreguntas[$i]['respuesta'], 'opr_id'));
                                            $k=array_search($x['oxp_id_otd'], array_column($detallePreguntas[$i]['respuesta'][$j]['configuraciones'], 'otd_id'));

                                            if($k>=0){
                                                $detallePreguntas[$i]['respuesta'][$j]['configuraciones'][$k]['n_respuestas']+=1;
                                            }
                                        }

                                           
                                    }   
                                }elseif($item['tipo']==4){
                                    $id=array_search($item['tipo'], array_column($detallePreguntas[$i]['respuesta'], 'opr_tipo_campo_dinamico'));
                                    if($id>=0){
                                       if($item['respuestas']==0){
                                        $detallePreguntas[$i]['respuesta'][$id]['respuestas'][0]['n_respuestas']+=1;
                                       }elseif($item['respuestas']==1){
                                        $detallePreguntas[$i]['respuesta'][$id]['respuestas'][1]['n_respuestas']+=1;
                                       }

                                    }
                                    
                                }
                            }
                        }

                    }elseif($row2['tipo']==10){
                        $id=array_search($row2['respuesta'], array_column($detallePreguntas[$i]['respuesta'], 'opr_id'));
                        if($id>=0){
                            $detallePreguntas[$i]['respuesta'][$id]['n_respuestas']+=1; 
                            
                        } 
                    }
                }
            }  
        } // fin de $respuestasEncuesta as $enc
        $i++;

    } //fin de $preguntas as $row

   /* echo '$detallePreguntas<pre>';
        print_r($detallePreguntas);
        echo '</pre>'; */

    $i=0;
    foreach($detallePreguntas as $row){
        if($row['tipo']==1 || $row['tipo']>4 && $row['tipo']<9){
            $aux=$row['respuesta'];
            $detallePreguntas[$i]['respuesta']=$this->contarValoresArray($aux);
        }elseif($row['tipo']==9){
            $y=0;
            foreach($row['respuesta'] as $conf){
                if($conf['opr_tipo_campo_dinamico']==1 || $conf['opr_tipo_campo_dinamico']>4 && $conf['opr_tipo_campo_dinamico']<9){
                    if(!empty($detallePreguntas[$i]['respuesta'][$y]['respuestas'])){
                        $detallePreguntas[$i]['respuesta'][$y]['respuestas']=$this->contarValoresArray($detallePreguntas[$i]['respuesta'][$y]['respuestas']);  
                    }
                }
                $y++;
            }    
        }
        $i++;
    }

   /* echo '$detallePreguntas<pre>';
        print_r($detallePreguntas);
        echo '</pre>';  */


    $data['preguntas'] = $detallePreguntas;
    $data['respuestas']=$respuestasEncuesta;
    $data['maxColum']=$maxColum;
   
    
    $html = $this->load->view('encuesta/reportes/filtrar_consulta_respuesta_graficos', $data, true);

  /* echo '$detallePreguntas<pre>';
        print_r($html);
        echo '</pre>'; */
    die(json_encode(array('html' => $html)));

    }
       

    } //Fin de filtrar_consulta_respuesta_graficos



    private function contarValoresArray($array)
    {
       /* echo '$array<pre>';
        print_r($array);
        echo '</pre>';*/
        
        $contar=array();
     
        foreach($array as $value)
        {
            if(isset($contar[$value]))
            {
                // si ya existe, le añadimos uno
                $contar[$value]+=1;
            }else{
                // si no existe lo añadimos al array
                $contar[$value]=1;
            }
        }
        return $contar;
    }

    public function exportar_entrevistas(){
        satelite_validar();

        $data['url_reporte'] = $this->gsatelite->get_parametro('SYS_URL_APP_SSRS');
        $data['titulo_personal'] = "Exportar Resultados";
        cargarvista($data);
    }

     /**
     * @author Manuel Hernandez
     */
    public function consulta_dashboard() {
        $data['titulo_personal'] = "Consultar Dashboard";
        $permisos = $this->gsatelite->get_permisos_opcion('consulta_dashboard');
       // $data['nivel'] = $this->gsatelite->get_dropdown('cla_clasificacion_encuesta', '{cla_nombre}', '', array('cla_estado' => '1'), null, '', 'cla_id', true);
        //$this->db->last_query("niv_nivel", " = niv_");
        $registros=$this->encuesta_model->consultar_nivel_dashboard(array('niv_orden'=>1));
        //print_r($registros);die();
        $data['nivel']=$registros;
       // $data['sucursal'] = $this->gsatelite->get_dropdown('suc_sucursal', '{suc_nombre}', '', array('suc_estado' => '1'), null, '', 'suc_id', true);
       // $data['preguntas'] = $this->encuesta_model->select_preguntas(array('pre_estado' => 1));
        //print_r($data); die();
        $data['permisos'] = $permisos;

        cargarvista($data);
    }

    /**
     * @author Manuel hernandez
     */
    public function filtrar_consulta_dashboard($es_reporte = 0) {
        $registros = array();
        $permisos = $this->gsatelite->get_permisos_opcion('consulta_dashboard');
        $data['permisos'] = $permisos;
       // $txtFecha_desde = $this->input->post('txtFecha_desde');
        //$txtFecha_hasta = $this->input->post('txtFecha_hasta');
        $slcNivel = $this->input->post('slc_nivel');
        //traigo Todos los indicadores
        $indicadores = $this->gsatelite->get_tabla("cla_clasificacion_encuesta",array("cla_id_niv = 
(SELECT
	niv_id 
FROM
	niv_nivel_clasificacion 
WHERE
    ( SELECT MAX( t2.niv_orden ) FROM niv_nivel_clasificacion t2 ) = niv_orden)" => null));
    //recorro el select para eliminar el ultimo * que encuentre
    foreach ($slcNivel as $key => $value) {
        if ($value == "*") {
            unset($slcNivel[$key]);
        }
    }
    $datos_verdaderos = [];
    $mapeo = null;
    $identificadores = null;
    //Marlon Olmedo - Grupo satelite 12/01/2021
    //recorro TODOS los indicadores para mapearlos en un array UwU
    foreach ($indicadores as $key => $value) {
        $padre = $value["cla_id_padre"]; //tomo el id padre del indicador
        $i = 0;
        $registros= $this->encuesta_model->consultar_dashboard($value["cla_id"]); //se hace la contabilizacion de las encuestas
        //print_r($this->db->last_query());die();
        //ordenamos los datos necesarios a imprimir
        $mapeo[$key]["cla_tipo"] = $value["cla_tipo"];
        $mapeo[$key]["cla_nota_minima"] = $value["cla_nota_minima"];
        $mapeo[$key]["cla_meta"] = $value["cla_meta"];
        $mapeo[$key]["encuestas"] = $registros[0]["encuestas"];
        $mapeo[$key]["per_nombre"] = $registros[0]["per_nombre"];
        $mapeo[$key]["cla_unidad_medida"] = $value["cla_unidad_medida"];
        $mapeo[$key]["clasificacion"][$value["cla_id"]] = $value["cla_nombre"];
        //empezamos un array para poder buscar dentro del arbol las clasificaciones seleccionadas
        $identificadores = array($value["cla_id"]);
        //ponemos un loop que seguira hasta encontrar el padre de todos, osease el id padre sea null
        while ($padre != null) {
            $papa = $this->gsatelite->get_tabla("cla_clasificacion_encuesta",array("cla_id" => $padre));
            $mapeo[$key]["clasificacion"][$papa[0]["cla_id"]] = $papa[0]["cla_nombre"];
            //almacenamos el nombre del padre y en un array vamos guardando los ids de las clasificaciones de cada recorrido
            array_push($identificadores,$papa[0]["cla_id"]);
            $padre = $papa[0]["cla_id_padre"];
            $i++;
        }
        //giramos el arbol para que esten en orden de padre a hijo
        $mapeo[$key]["clasificacion"] = array_reverse($mapeo[$key]["clasificacion"]);
        //buscamos en el array de las clasificaciones, el penultimo dato del array de clasificaciones filtradas,
        //para asi tomar todos los hijos del array padre y los almacenamos en un nuevo array
        if (in_array(end($slcNivel), $identificadores)) {
            $datos_verdaderos[$key] = array_merge(array_reverse($mapeo[$key]),$datos_verdaderos);
        }
    }
    //en caso que el filtro se hayan seleccionado todos los padres osease "*", guardara el mapeo en la variable definitiva
    if (empty($datos_verdaderos)) {
        $datos_verdaderos = $mapeo;
    }

    // print_r($datos_verdaderos);
    // die();    
        // if ($slcNivel != null ) {
        //     $registros=$this->encuesta_model->consultar_dashboard($slcNivel);
        // }

        $data['registros'] = $datos_verdaderos;
        $data['cantidad_registros'] = ($registros) ? " ( Se encontraron " .(count($registros) - 1) . " Resultados )" : '';
        $data['es_reporte'] = $es_reporte;
        

       /* $data['txtFecha_desde'] = $this->input->post('txtFecha_desde');
        $data['txtFecha_hasta'] = $this->input->post('txtFecha_hasta');*/
        $data['slcNivel'] = $this->input->post('slcNivel');

        $where = array('niv_estado' => 1);
        $this->db->order_by('niv_orden', 'ASC');
        $data['niveles']= $this->gsatelite->get_tabla("niv_nivel_clasificacion",$where);
        //print_r("aqui");die();
        $html = $this->load->view('encuesta/reportes/filtrar_consulta_dashboard', $data, true);
        if ($es_reporte == 1) {
            //echo $html; die();
            $filtro_titulo = $txtFecha_desde . " / " . $txtFecha_hasta . " <br />" . $data['cantidad_registros'];

            if ($this->input->post()) {
                $nombre_fichero = "consulta_dashboard_" . date('d-m-Y_His') . "_.csv";
                $fp = fopen("uploads/encuesta_temp/csv_enviados/$nombre_fichero", 'w');
                $i = 0;
                foreach ($registros as $campos) {
                    unset($campos['iconos']);
                    unset($campos['encuesta']);
                    $campos = array_map('utf8_decode', $campos);
                    //print_r($campos); die();
                    $i++;
                    if ($i == 1) {
                        $titulos = array('#', 'AGENCIA', 'RESPUESTA', 'CANTIDAD RESPUESTA');
                        fputcsv($fp, array_merge($titulos));
                    }
                    fputcsv($fp, array_merge(array($i), $campos));
                }
                fclose($fp);
                if ($this->input->post('tipo_accion') == 1) {
                    //redirect("uploads/portal_inventario_temp/csv_enviados/$nombre_fichero");
                    if (file_exists("uploads/portal_inventario_temp/csv_enviados/$nombre_fichero")) {
                        unlink("uploads/portal_inventario_temp/csv_enviados/$nombre_fichero");
                    }
                    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                    header("Content-Disposition: attachment;filename=consulta_respuesta_agencia_" . date('d-m-Y_His') . ".xls");
                    header("Pragma: no-cache");
                    header("Expires: 0");
                    echo '<meta charset="utf-8" />';
                    echo "<table border='1'>
                      <tr><th colspan='4' align='center' >" . mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8') . "</th></tr>
                      <tr><th colspan='4' align='center' >Reporte de Respuesta - Agencia</th></tr>
                      <tr><th colspan='4' align='center' >" . $agencias . "</th></tr>
                      <tr><th colspan='4' align='center' >" . $filtro_titulo . "</th></tr>
                      </table>";
                    echo $html;
                    die();
                } else {
                    //enviar por correo.
                    $asunto = "REPORTE DE DASHBOARD - AGENCIA";
                    $mensaje = $this->load->view('encuesta/reportes/mensaje_correo_respuesta_sucursal', $data, true);
                    $correo_destino = explode(',', $this->gsatelite->get_parametro('SYS_CORREO_RECIBE_REPORTE_ENCUESTA'));

                    $this->db->join('emp_empleado', 'emp_id=usu_id_emp');
                    $registro_usuario = $this->gsatelite->get_registro('usu_usuario', 'usu_id', $this->tank_auth->get_user_id());
                    $correo_envia = $registro_usuario->usu_email;
                    $usuario_envia = $registro_usuario->emp_nombre . ' ' . $registro_usuario->emp_apellido;

                    $exito = $this->gsatelite->envio_correo($correo_envia, 'Portal Encuesta - ' . $usuario_envia, $correo_destino, $asunto, $mensaje, $correo_envia, FCPATH . "uploads/encuesta_temp/csv_enviados/$nombre_fichero");
                    if ($exito > 0) {
                        $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Correo enviado", 'texto_alerta' => "Correo enviado con éxito");
                    } else {
                        $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error de envio ", 'texto_alerta' => "Correo no puedo ser enviado");
                    }
                    $this->session->set_flashdata($alerta);
                }
                if (file_exists("uploads/encuesta_temp/csv_enviados/$nombre_fichero")) {
                    unlink("uploads/encuesta_temp/csv_enviados/$nombre_fichero");
                }

                redirect('encuesta/reportes/consulta_respuesta_sucursal');
            }
            redirect('encuesta/reportes/consulta_respuesta_sucursal');
        } else {
            die(json_encode(array('html' => $html)));
        }
    }

    /**
    * @author René Castaneda - Grupo Satelite
    * @since 22-12-2020
    * @return html view - Descargar información horizontal
    */
    function descarga_informacion() {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();
        $data['sucursal'] = $this->gsatelite->get_dropdown('suc_sucursal', '{suc_nombre}', '', array('suc_estado' => '1'), null, '', 'suc_id', true);
        $data['permisos'] = $permisos;
        $data['titulo_personal'] = "Descargar información de encuesta";
        cargarvista($data);
    }

    /**
    * @author René Castaneda - Grupo Satelite
    * @since 22-12-2020
    * @return html view - query
    */
    public function filtrar_descarga_informacion($es_reporte = 0) {
        //satelite_validar();
       // $permisos = $this->gsatelite->get_permisos_opcion('encuesta/procesos/descarga_informacion');
      //  $data['permisos'] = $permisos;
        $txtFecha_desde = $this->input->post('txtFecha_desde');
        $txtFecha_hasta = $this->input->post('txtFecha_hasta');
        $slcAgencia = $this->input->post('slcAgencia');
        $slcEncuesta = $this->input->post('slcEncuesta');
        $filas_dinamica  = 0;//imprimir o no imprmir filas independientes de preguntas dinamicas e indexadas
        $data['filas_dinamica'] = $filas_dinamica;
        $data['group_by_dinamic'] = ($filas_dinamica)? 'rec_id':'rec_id_ecl, rec_id_pre, opr_id';
        $data['es_reporte'] = $es_reporte;
        $html_reporte= (isset($_POST['html_reporte']) && $_POST['html_reporte'] !='')? $_POST['html_reporte']:'';
        $where = array();
        if ($txtFecha_desde != '') {
            $where['DATE(ecl_fecha) >='] = date('Y-m-d', strtotime($txtFecha_desde));
        }
        if ($txtFecha_hasta != '') {
            $where['DATE(ecl_fecha) <='] = date('Y-m-d', strtotime($txtFecha_hasta));
        }
        if ($slcAgencia > 0) {
            $where['exs_id_suc'] = $slcAgencia;
        }
        if ($slcEncuesta > 0) {
            $where['exs_id_enc'] = $slcEncuesta;
        }
        
        if($html_reporte !='') {
            $html = $html_reporte;
        } else {
        $preguntas = $this->encuesta_model->get_preguntas_enc(array('pre_id_enc'=>$slcEncuesta)); //para listar las preguntas de la encuesta
        $get_info1 = $this->encuesta_model->get_informacion_numero_encuesta($where); //recorrer los N encuestas
        $get_info2 = $this->encuesta_model->get_informacion_encuesta($where); //para recorresr las N respuestas a las preguntas
        $data['preguntas'] = $preguntas;
        $data['info_encuesta'] = $get_info1;
        $data['info_encuesta2'] = $get_info2;
        $data['txtFecha_desde'] = $this->input->post('txtFecha_desde');
        $data['txtFecha_hasta'] = $this->input->post('txtFecha_hasta');
        $data['slcAgencia'] = $this->input->post('slcAgencia');
        $data['slcEncuesta'] = $this->input->post('slcEncuesta');
        $html = $this->load->view('encuesta/reportes/filtrar_descarga_informacion', $data, true);
        }

        if ($es_reporte == 1) {
            if ($this->input->post()) {
                if ($this->input->post('tipo_accion') == 1) {
                    if (ob_get_contents()) ob_end_clean();
                    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                    header("Content-Disposition: attachment;filename=datos_encuesta_" . date('d-m-Y_His') . ".xls");
                    header("Pragma: no-cache");
                    header("Expires: 0");
                    echo '<meta charset="utf-8" />';
                    echo $html;
                    die();
                } 
                redirect('encuesta/reportes/descarga_informacion');
            }
            redirect('encuesta/reportes/descarga_informacion');
        } else {
            die(json_encode(array('html' => $html)));
        }
    }

     /**
     * @author Manuel Hernandez
     */
    public function tabla_rastreo_indicadores() {
        $data['titulo_personal'] = "Consultar Tabla de Rastreo";
        $permisos = $this->gsatelite->get_permisos_opcion('tabla_rastreo_indicadores');
        $registros=$this->encuesta_model->consultar_nivel_dashboard(array('niv_orden'=>1));
        $data['nivel']=$registros;
        $data['permisos'] = $permisos;

        cargarvista($data);
    }

    /**
     * @author Manuel hernandez
     */
    public function filtrar_tabla_rastreo_indicadores($es_reporte = 0) {
        $registros = array();
        $permisos = $this->gsatelite->get_permisos_opcion('tabla_rastreo_indicadores');
        $data['permisos'] = $permisos;
        $txtFecha_desde = $this->input->post('txtFecha_desde');
        $txtFecha_hasta = $this->input->post('txtFecha_hasta');
        $slcNivel = $this->input->post('slc_nivel');
        //print_r($_POST);die();
        //$slcPregunta = $this->input->post('slcPregunta');

        if($txtFecha_desde!='' && $txtFecha_hasta!='' && $slcNivel != null ){
            $meses = ["Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre"];
            $where['date_format(T5.ecl_fecha,"%Y-%m-%d") >='] = date('Y-m-d', strtotime($txtFecha_desde));
            $where['date_format(T5.ecl_fecha,"%Y-%m-%d") <='] = date('Y-m-d', strtotime($txtFecha_hasta));

            $begin = new DateTime($txtFecha_desde);
            $end = new DateTime($txtFecha_hasta);
            //$end = $end->modify( '+1 month' );
            $interval = DateInterval::createFromDateString('1 month');

            $period = new DatePeriod($begin, $interval, $end);
            $periodos=[];

            foreach($period as $dt) {
                array_push($periodos,array('periodo'=>$dt->format( "m-Y" ), 'periodo_nombre'=>$meses[$dt->format("m")-1].'-'.$dt->format("Y")));
            }

            $this->db->join("per_periodo","per_id = cla_id_per","left");
            $indicadores = $this->gsatelite->get_tabla("cla_clasificacion_encuesta",
                            array("cla_id_niv = 
                                    (SELECT
                                        niv_id 
                                    FROM
                                        niv_nivel_clasificacion 
                                    WHERE
                                        ( SELECT MAX( t2.niv_orden ) FROM niv_nivel_clasificacion t2 ) = niv_orden)" => null));
            //recorro el select para eliminar el ultimo * que encuentre
            foreach ($slcNivel as $key => $value) {
                if ($value == "*") {
                    unset($slcNivel[$key]);
                }
            }
            $datos_verdaderos = [];
            $mapeo = null;
            $identificadores = null;
            //Marlon Olmedo - Grupo satelite 12/01/2021
            //recorro TODOS los indicadores para mapearlos en un array UwU
            foreach ($indicadores as $key => $value) {
                $padre = $value["cla_id_padre"]; //tomo el id padre del indicador
                
                $registros2= $this->encuesta_model->consultar_tabla_rastreo($value["cla_id"],$value["cla_tipo"],$value["cla_nota_minima"],$where); //se hace la contabilizacion de las encuestas
                //ordenamos los datos necesarios a imprimir
                $mapeo[$key]["cla_tipo"] = $value["cla_tipo"];
                $mapeo[$key]["cla_nota_minima"] = $value["cla_nota_minima"];
                $mapeo[$key]["cla_meta"] = $value["cla_meta"];
                $mapeo[$key]["cla_meta_mensual"] = $value["cla_meta_mensual"];
                $mapeo[$key]["cla_tipo_datpo"] = $value["cla_tipo_datpo"];
                $mapeo[$key]["encuestas_clas"] = $registros2;
                $mapeo[$key]["per_nombre"] = $value["per_nombre"];
                $mapeo[$key]["cla_unidad_medida"] = $value["cla_unidad_medida"];
                $mapeo[$key]["clasificacion"][$value["cla_id"]] = $value["cla_nombre"];
                //empezamos un array para poder buscar dentro del arbol las clasificaciones seleccionadas
                $identificadores = array($value["cla_id"]);
                //ponemos un loop que seguira hasta encontrar el padre de todos, osease el id padre sea null
                while ($padre != null) {
                    $papa = $this->gsatelite->get_tabla("cla_clasificacion_encuesta",array("cla_id" => $padre));
                    $mapeo[$key]["clasificacion"][$papa[0]["cla_id"]] = $papa[0]["cla_nombre"];
                    //almacenamos el nombre del padre y en un array vamos guardando los ids de las clasificaciones de cada recorrido
                    array_push($identificadores,$papa[0]["cla_id"]);
                    $padre = $papa[0]["cla_id_padre"];
                }
                //giramos el arbol para que esten en orden de padre a hijo
                $mapeo[$key]["clasificacion"] = array_reverse($mapeo[$key]["clasificacion"]);
                //buscamos en el array de las clasificaciones, el penultimo dato del array de clasificaciones filtradas,
                //para asi tomar todos los hijos del array padre y los almacenamos en un nuevo array
                if (in_array(end($slcNivel), $identificadores)) {
                    $datos_verdaderos[$key] = array_merge(array_reverse($mapeo[$key]),$datos_verdaderos);
                }
            }
            //en caso que el filtro se hayan seleccionado todos los padres osease "*", guardara el mapeo en la variable definitiva
            if (empty($datos_verdaderos)) {
                $datos_verdaderos = $mapeo;
            }

            //$registros=$this->encuesta_model->consultar_tabla_rastreo($slcNivel,$where);
            $registros= $datos_verdaderos;
            // print_r($registros);
            // die();
            // if(count($registros['detalle'])>0){ //COlocamos el mes en letras
            //     $i=0;
            //     foreach($registros['detalle'] as $row){
            //         $registros['detalle'][$i]['periodo_letra']=$meses[$registros['detalle'][$i]['mes']-1];
            //         $i++;
            //     }
            // }
        }

        $where = array('niv_estado' => 1);
        $this->db->order_by('niv_orden', 'ASC');
        $data['niveles']= $this->gsatelite->get_tabla("niv_nivel_clasificacion",$where);

        $data['registros'] = $registros;
        //$data['detalle'] = $registros['detalle'];
        $data['cantidad_registros'] = ($registros['registros']) ? " ( Se encontraron " .count($registros['registros'])/5 . " Resultados )" : '';
        $data['es_reporte'] = $es_reporte;

        $data['txtFecha_desde'] = $this->input->post('txtFecha_desde');
        $data['txtFecha_hasta'] = $this->input->post('txtFecha_hasta');
        $data['slcNivel'] = $this->input->post('slcNivel');
        $data['periodos']=$periodos;


       /* echo "REGISTROS<pre>";
        print_r($data['registros']);
        echo "</pre>";

        echo "PERIODOS<pre>";
        print_r($periodos);
        echo "</pre>";

        echo "DETALLE<pre>";
        print_r($data['detalle']);
        echo "</pre>"; */
        
       
        //$data['slcRespuesta'] = $this->input->post('slcRespuesta');
       // $data['periodo'] = date('d-m-Y', strtotime($txtFecha_desde)) . ' / ' . date('d-m-Y', strtotime($txtFecha_desde));

        $html = $this->load->view('encuesta/reportes/filtrar_consulta_tabla_rastreo', $data, true);
        if ($es_reporte == 1) {
            //echo $html; die();
            $filtro_titulo = $txtFecha_desde . " / " . $txtFecha_hasta . " <br />" . $data['cantidad_registros'];

            if ($this->input->post()) {
                $nombre_fichero = "consulta_dashboard_" . date('d-m-Y_His') . "_.csv";
                $fp = fopen("uploads/encuesta_temp/csv_enviados/$nombre_fichero", 'w');
                $i = 0;
                foreach ($registros as $campos) {
                    unset($campos['iconos']);
                    unset($campos['encuesta']);
                    $campos = array_map('utf8_decode', $campos);
                    //print_r($campos); die();
                    $i++;
                    if ($i == 1) {
                        $titulos = array('#', 'AGENCIA', 'RESPUESTA', 'CANTIDAD RESPUESTA');
                        fputcsv($fp, array_merge($titulos));
                    }
                    fputcsv($fp, array_merge(array($i), $campos));
                }
                fclose($fp);
                if ($this->input->post('tipo_accion') == 1) {
                    //redirect("uploads/portal_inventario_temp/csv_enviados/$nombre_fichero");
                    if (file_exists("uploads/portal_inventario_temp/csv_enviados/$nombre_fichero")) {
                        unlink("uploads/portal_inventario_temp/csv_enviados/$nombre_fichero");
                    }
                    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                    header("Content-Disposition: attachment;filename=consulta_respuesta_agencia_" . date('d-m-Y_His') . ".xls");
                    header("Pragma: no-cache");
                    header("Expires: 0");
                    echo '<meta charset="utf-8" />';
                    echo "<table border='1'>
                      <tr><th colspan='4' align='center' >" . mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8') . "</th></tr>
                      <tr><th colspan='4' align='center' >Reporte de Tabla Rastreo de Indicadores</th></tr>
                      <tr><th colspan='4' align='center' >" . $agencias . "</th></tr>
                      <tr><th colspan='4' align='center' >" . $filtro_titulo . "</th></tr>
                      </table>";
                    echo $html;
                    die();
                } else {
                    //enviar por correo.
                    $asunto = "REPORTE DE DASHBOARD - AGENCIA";
                    $mensaje = $this->load->view('encuesta/reportes/mensaje_correo_respuesta_sucursal', $data, true);
                    $correo_destino = explode(',', $this->gsatelite->get_parametro('SYS_CORREO_RECIBE_REPORTE_ENCUESTA'));

                    $this->db->join('emp_empleado', 'emp_id=usu_id_emp');
                    $registro_usuario = $this->gsatelite->get_registro('usu_usuario', 'usu_id', $this->tank_auth->get_user_id());
                    $correo_envia = $registro_usuario->usu_email;
                    $usuario_envia = $registro_usuario->emp_nombre . ' ' . $registro_usuario->emp_apellido;

                    $exito = $this->gsatelite->envio_correo($correo_envia, 'Portal Encuesta - ' . $usuario_envia, $correo_destino, $asunto, $mensaje, $correo_envia, FCPATH . "uploads/encuesta_temp/csv_enviados/$nombre_fichero");
                    if ($exito > 0) {
                        $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Correo enviado", 'texto_alerta' => "Correo enviado con éxito");
                    } else {
                        $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error de envio ", 'texto_alerta' => "Correo no puedo ser enviado");
                    }
                    $this->session->set_flashdata($alerta);
                }
                if (file_exists("uploads/encuesta_temp/csv_enviados/$nombre_fichero")) {
                    unlink("uploads/encuesta_temp/csv_enviados/$nombre_fichero");
                }

                redirect('encuesta/reportes/consulta_respuesta_sucursal');
            }
            redirect('encuesta/reportes/consulta_respuesta_sucursal');
        } else {
            die(json_encode(array('html' => $html)));
        }
    }

    /**
     * @author Marlon Olmedo
     */
    public function get_clasificacion_hijo() {

        $id_padre = $this->input->post('id_padre');
        
        $this->db->join("niv_nivel_clasificacion","cla_id_niv = niv_id","left");
        $clasificacion = $this->gsatelite->get_tabla('cla_clasificacion_encuesta',array('cla_id_padre'=>$id_padre));
        //print_r($this->db->last_query());die();
        echo json_encode($clasificacion);
    }

}

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */