<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Procesos extends CI_Controller
{

    function __construct()
    {
        parent::__construct();
        $this->load->library('grocery_CRUD');
        $this->load->model('gsatelite');
        $this->load->model('encuesta_model');
        $this->load->helper(array('download'));
        $this->load->model('desarrollo_model');
    }

    public function index()
    {
        if (!$this->tank_auth->is_logged_in()) {

            redirect('/auth/login/');
        } else {
            cargarvista();
        }
    }

    /**
     * @return Mantenimiento de Encuestas
     * @author Rene Castaneda
     */
    public function gestion_encuesta($id_usuario=0)
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            try {
                $permisos = $this->gsatelite->get_permisos_opcion();
                $this->session->set_userdata('url_return', base_url($_SERVER['REDIRECT_QUERY_STRING']));
                $crud = new grocery_CRUD();
                if ($id_usuario > 0) {
                    $crud->where('enc_usu_creacion',$id_usuario);
                }

                $auditoria_claxencu = array(
                    'cxe_estado' => 1,
                    'cxe_usu_creacion' => $this->tank_auth->get_user_id(),
                    'cxe_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'cxe_fecha_creacion' => date('Y-m-d H:i:s'),
                    'cxe_fecha_modificacion' => date('Y-m-d H:i:s'));

                $crud->set_table('enc_encuesta')
                ->set_subject('')
                ->columns('enc_nombre', 'enc_tipo', 'enc_observacion','clasificacion', 'enc_estado')
                ->add_fields('enc_nombre','clasificacion', 'enc_observacion', 'enc_estado', 'enc_tipo','enc_calificacion_maxima','enc_tipo_presentacion',  'enc_usu_creacion', 'enc_usu_modificacion', 'enc_fecha_creacion', 'enc_fecha_modificacion',"enc_indicaciones")
                ->edit_fields('enc_nombre','clasificacion', 'enc_observacion', 'enc_estado', 'enc_tipo','enc_calificacion_maxima','enc_tipo_presentacion', 'enc_usu_modificacion', 'enc_fecha_modificacion',"enc_indicaciones")
                ->display_as('enc_nombre', 'Nombre')
                ->display_as('enc_estado', 'Estado')
                ->display_as('enc_tipo', 'Tipo')
                ->display_as('enc_calificacion_maxima', 'Calificación Máxima')
                ->display_as('enc_observacion', 'Observación')
                ->display_as('clasificacion', 'Clasificación')
                ->display_as('enc_indicaciones', 'Indicaciones')
                ->display_as('enc_tipo_presentacion', 'Tipo de presentación')
                ->callback_field('clasificacion', array($this, '_callback_clasificaciones'))
                ->set_relation_n_n('clasificacion', 'cxe_clasificacionxencuesta', 'cla_clasificacion_encuesta','cxe_id_enc' ,'cxe_id_cla','cla_nombre',null,null,$auditoria_claxencu)
                    //->set_relation('enc_id_cla', 'cla_clasificacion_encuesta ', '{cla_nombre}', array('cla_estado' => 1))
                ->required_fields('enc_nombre', 'enc_estado','enc_calificacion_maxima')
                ->set_rules('enc_nombre', 'Nombre', 'trim|required|campo_unico[enc_encuesta.enc_nombre]')
                ->callback_field('enc_indicaciones', function($value, $row) {
                    return '<textarea id="field-enc_indicaciones" name="enc_indicaciones" class="" style="width:100%" maxlength="1000" rows="4">'.$value.'</textarea>';
                })
                ->field_type('enc_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('enc_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('enc_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
                ->field_type('enc_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
                ->field_type('enc_tipo', 'dropdown', array('1' => 'Evaluada', '0' => 'No Evaluada'))
                ->field_type('enc_tipo_presentacion', 'dropdown', array('0' => 'Normal', '1' => 'Pregunta por Pantalla', '2' => 'Pregunta por tabulación'))
                ;

                
                
                

                //comentada dado que por el momento no se estan utilizando los archivos json (en su inicio iba alimentar una app)

                // $crud->callback_after_update(function ($row, $key) {
                //     $this->generar_json_usuario(true); /* generar archivo json */
                // });
                // $crud->callback_after_insert(function ($row, $key) {
                //     $this->generar_json_usuario(true); /* generar archivo json */
                // });
                //insercion de categoria por defecto
                $crud->callback_after_insert(function ($post_array,$primary_key) {
                    
                    $insert_array = array(
                        'cap_id_enc' => $primary_key
                        , 'cap_nombre' => "Datos Generales"
                        , 'cap_estado' => 1
                        , 'cap_usu_creacion' => $this->tank_auth->get_user_id()
                        , 'cap_fecha_creacion' => date('Y-m-d H:i:s')
                        , 'cap_usu_modificacion' => $this->tank_auth->get_user_id()
                        , 'cap_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    
                    $this->gsatelite->ingresar('cap_categoria_pregunta', $insert_array);
                });

                $crud->callback_before_insert(function ($post_array) {
                    if ($post_array['enc_tipo'] == 1 && $post_array['enc_calificacion_maxima'] <= 0 ) {
                        return false;
                    } else {
                        return $post_array;
                    }
                });
                $crud->callback_before_update(function ($post_array, $key) {
                    if ($post_array['enc_tipo'] == 1 && $post_array['enc_calificacion_maxima'] <= 0 ) {
                        return false;
                    } else {
                        return $post_array;
                    }
                });
                $crud->set_lang_string('update_error', 'Debe ingresar una Calificación mayor a cero');
                $crud->set_lang_string('insert_error', 'Debe ingresar una Calificación mayor a cero');


                $uri_segments = explode('/', uri_string());
                if (end($uri_segments) == 'add') {
                    $crud->field_type('enc_estado', 'hidden', 1);
                } else {
                    $crud->field_type('enc_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
                }

                $data['titulo_personal'] = ($id_usuario > 0)? "Mis Encuestas - ".$this->tank_auth->get_username():"Gestión Encuesta";
                $crud->unset_print()->unset_export();
                $crud->add_action('Preguntas', '', 'encuesta/procesos/preguntas', 'minia-icon-list-4');
                $crud->add_action('Encuesta-Grupo', '', 'encuesta/procesos/encuesta_agencia', 'icomoon-icon-list-view');
                $crud->add_action('Categoría-Encuesta', '', 'encuesta/catalogos/categoria_pregunta', 'minia-icon-list-2');
                $crud->add_action('Exclusión-Categoría', '', 'encuesta/procesos/exclusion_categoria', 'minia-icon-list-2');
                // Validaciones
                if (!$permisos['permite_agregar']) {
                    $crud->unset_add();
                }
                if (!$permisos['permite_editar']) {
                    $crud->unset_edit();
                }
                if (!$permisos['permite_eliminar']) {
                    $crud->unset_delete();
                }
                $crud->add_action(' Duplicar', '', 'encuesta/procesos/duplicar_encuesta', 'icomoon-icon-stack ver_detalle');
                if ($permisos['permite_ver']) {
                    $crud->add_action('Ver', 'minia-icon-search', "encuesta/procesos/".(($id_usuario > 0)? "gestion_encuesta_me":"gestion_encuesta")."/read");
                }
                
                $output = $crud->render();
                cargarvista($data, $output,'encuesta/procesos/gestion_encuesta');
            } catch (Exception $e) {
                show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
            }
        }
    }

// End function gestion_encuesta



    function _callback_clasificaciones($value = '', $primary_key = null) {
    //print_r($value);die();
        $urlSegment = (explode("/", uri_string()));
        $sxc_id = null;
    /*
     * Se obtiene el id del Servicio por cliente.
     */
  /*  if (end(explode('/', uri_string())) == 'add') {
        $sxc_id = $urlSegment[count($urlSegment) - 2];
        
    } else {
        $sxc_id = $urlSegment[count($urlSegment) - 3];
    }

    echo "<pre>";
    print_r($sxc_id);
    echo "</pre>";
    

    $src_id = $this->gsatelite->get_campo('niv_nivel_clasificacion', 'sxc_id_art', array('sxc_id' => $sxc_id));
    $opciones = '<select id="field-pxl_id_pln" name="pxl_id_pln" class="nostyle chosen-select" data-placeholder=" Plan/Promoción" style="width: 100%; display: none;">';
    $opciones .= '<option></option>';
    $planes = $this->gsatelite->get_tabla('pln_plan_promocion', array('pln_estado' => 1, 'pln_id_art' => $src_id));*/


    $opciones = '<select id="field-clasificacion" name="clasificacion[]" multiple="multiple" size="8" class="nostyle chosen-multiple-select" data-placeholder=" Seleccione" style="width: 100%; display: none;">';
    $opciones .= '<option></option>';

    $validacion = array(
        'cla_clasificacion_encuesta.cla_estado' => 1,
        't2.cla_id' => null
    );

    $this->db->join('niv_nivel_clasificacion','cla_clasificacion_encuesta.cla_id_niv = niv_nivel_clasificacion.niv_id');
    $this->db->join('cla_clasificacion_encuesta t2','t2.cla_id_padre = cla_clasificacion_encuesta.cla_id','left');
    $this->db->select("cla_clasificacion_encuesta.*,niv_nivel_clasificacion.*");
    $clasificaciones = $this->gsatelite->get_tabla('cla_clasificacion_encuesta',$validacion);
        //print_r($this->db->last_query());die();
    if (count($clasificaciones) > 0) {
        foreach ($clasificaciones as $cla) {
            $selected = (isset($value[$cla['cla_id']])) ? "selected=selected" : "";
            $nombre_cla = $cla['cla_nombre'].' ('.$cla['niv_nombre'].')';
            $opciones .= '<option ' . $selected . ' value="' . $cla['cla_id'] . '">' . $nombre_cla . '</option>';
        }
    }

    $opciones .= "</select>";

    return $opciones;
}


    /**
     * @return Mantenimiento de Encuestas por Sucursal
     * @author Rene Castaneda
     */
    public function encuesta_agencia($id_encuesta)
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            try {
                if (!is_numeric($id_encuesta)) {
                    redirect('');
                }

                if ($this->input->post()) {
                    if ($this->input->post('encuesta_id') > 0 and $this->input->post('sucursal') > 0) {
                        $id_encuesta = $this->input->post('encuesta_id');
                        $insert_array = array(
                            'exs_id_enc' => $this->input->post('encuesta_id')
                            , 'exs_id_suc' => $this->input->post('sucursal')
                            , 'exs_estado' => 1
                            , 'exs_usu_creacion' => $this->tank_auth->get_user_id()
                            , 'exs_fecha_creacion' => date('Y-m-d H:i:s')
                            , 'exs_usu_modificacion' => $this->tank_auth->get_user_id()
                            , 'exs_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $exito = $this->gsatelite->ingresar('exs_encuestaxsucursal', $insert_array);
                        if ($exito > 0) {
                            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro Ingresado", 'texto_alerta' => "Registro ingresado correctamente");
                        } else {
                            $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error en ingresar", 'texto_alerta' => "No se pudo agregar el registro");
                        }
                        $this->session->set_flashdata($alerta);
                        $this->generar_json_encuesta_sucursal();  /* generar archivo json */
                        redirect("encuesta/procesos/encuesta_agencia/$id_encuesta");
                    }
                }

                $permisos = $this->gsatelite->get_permisos_opcion('gestion_encuesta');
                $data['registro'] = $this->gsatelite->get_tabla('enc_encuesta', array('enc_id' => $id_encuesta));
                $crud = new grocery_CRUD();
                $crud->set_table('exs_encuestaxsucursal')
                ->set_subject('Encuesta - Grupo')
                ->where('exs_id_enc', $id_encuesta)
                ->columns('exs_id_suc', 'exs_estado')
                ->add_fields('exs_id_enc', 'exs_id_suc', 'exs_estado', 'exs_usu_creacion', 'exs_usu_modificacion', 'exs_fecha_creacion', 'exs_fecha_modificacion')
                ->edit_fields('exs_id_enc', 'exs_id_suc', 'exs_estado', 'exs_usu_modificacion', 'exs_fecha_modificacion')
                ->display_as('exs_id_enc', 'Encuesta')
                ->display_as('exs_id_suc', 'Grupo')
                ->display_as('exs_estado', 'Estado')
                ->required_fields('exs_nombre', 'exs_estado')
                // ->set_relation('exs_id_suc', 'suc_sucursal', '{suc_nombre}', array('suc_estado' => 1))
                ->set_relation('exs_id_suc', 'suc_sucursal', '{suc_nombre}')
                ->set_relation('exs_id_enc', 'enc_encuesta', '{enc_nombre}')
                ->set_rules('exs_id_suc', 'Agencia', 'trim|required|campo_unico[exs_encuestaxsucursal.exs_id_suc]')
                ->field_type('exs_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('exs_id_enc', 'hidden', $id_encuesta)
                ->field_type('exs_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('exs_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
                ->field_type('exs_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
                $crud->callback_after_update(function ($row, $key) {
                    $this->generar_json_encuesta_sucursal(true); /* generar archivo json */
                });
                $crud->callback_after_insert(function ($row, $key) {
                    $this->generar_json_encuesta_sucursal(true); /* generar archivo json */
                });
                $data['estado_accion'] = $crud->getState();
                if ($data['estado_accion'] == 'add') {
                    $crud->field_type('exs_estado', 'hidden', 1);
                } else {
                    $crud->field_type('exs_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
                }

                $data['titulo_personal'] = "Permisos Encuesta";
                $crud->unset_print()->unset_export()->unset_add();
                $data['permite_agregar'] = $permisos['permite_agregar'];

                $data['select_agencia'] = $this->encuesta_model->select_agencia($id_encuesta);
                // Validaciones
                if (!$permisos['permite_agregar']) {
                    $crud->unset_add();
                }
                if (!$permisos['permite_editar']) {
                    $crud->unset_edit();
                }
                if (!$permisos['permite_eliminar']) {
                    $crud->unset_delete();
                }
                if ($permisos['permite_ver']) {
                    $crud->add_action('Ver', 'minia-icon-search', "encuesta/procesos/encuesta_agencia/$id_encuesta/read");
                }
                // $crud->add_action('Generar Link', '', "encuesta/procesos/link_encuesta_agencia", 'icomoon-icon-anchor ver_en_modal_link');
                $crud->add_action('Generar Link', '', "encuesta/procesos/link_encuestaAgencia", 'icomoon-icon-anchor ver_en_modal_link');

                //print_r($data); die();
                $output = $crud->render();
                cargarvista($data, $output);
            } catch (Exception $e) {
                show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
            }
        }
    }

// End function encuesta_agencia

    /**
     * @return Mantenimiento de Encuestas por Sucursal
     * @author Rene Castaneda
     */
    public function preguntas($id_encuesta)
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            try {
                if (!is_numeric($id_encuesta)) {
                    redirect('');
                }
                $this->generar_json_encuesta($id_encuesta);
                $permisos = $this->gsatelite->get_permisos_opcion('gestion_encuesta');
                $data['registro'] = $this->gsatelite->get_tabla('enc_encuesta', array('enc_id' => $id_encuesta));
                $crud = new grocery_CRUD();
                $crud->set_table('pre_pregunta')
                ->set_subject('Pregunta')
                ->where('pre_id_enc', $id_encuesta)
                ->columns('pre_orden', 'pre_id_cap', 'pre_nombre', 'pre_tipo')
                ->display_as('pre_orden', 'Orden')
                ->display_as('pre_id_cap', 'Categoría')
                ->display_as('pre_nombre', 'Nombre')
                ->display_as('pre_tipo', 'Tipo')
                ->display_as('pre_estado', 'Estado')
                ->required_fields('pre_nombre', 'pre_estado')
                ->set_relation('pre_id_cap', 'cap_categoria_pregunta', '{cap_nombre}');
                $crud->callback_column('pre_nombre', function ($value, $row) {
                    return $value;
                });
                $crud->callback_column('pre_tipo', function ($value, $row) {
                    // Se agrego los diferentes tipos de preguntas para ser mostradas   Manuel Hernandez 17/03/2020
                    switch ($value) {
                        case '1':
                        $tipo = 'Abierta';
                        break;
                        case '2':
                        $tipo = '<a class="ver_en_modal_ajax2"  target="_blank" href="' . base_url('encuesta/procesos/ver_detalle_pregunta/' . $row->pre_id) . '">Lista Desplegable</a>';
                        break;
                        case '3':
                        $tipo = '<a class="ver_en_modal_ajax2"  target="_blank" href="' . base_url('encuesta/procesos/ver_detalle_pregunta/' . $row->pre_id) . '">Selección Múltiple</a>';
                        break;
                        case '4':
                        $tipo = 'Falso/Verdadero';
                        break;
                        case '5':
                        $tipo = 'Númerico Entero';
                        break;
                        case '6':
                        $tipo = 'Número Decimal';
                        break;
                        case '7':
                        $tipo = 'Fecha';
                        break;
                        case '8':
                        $tipo = 'Hora';
                        break;
                        case '9':
                        $tipo = '<a class="ver_en_modal_ajax2"  target="_blank" href="' . base_url('encuesta/procesos/ver_detalle_pregunta/' . $row->pre_id) . '"><i title="Editar contenido" class="icomoon icon-pencil"></i>  Tabla Dinámica </a>';
                        break;
                        case '10':
                        $tipo = '<a class="ver_en_modal_ajax2"  target="_blank" href="' . base_url('encuesta/procesos/ver_detalle_pregunta/' . $row->pre_id) . '">Lista de iconos</a>';
                        break;
                        case '11':
                        $tipo = 'Imagen';
                        break;
                        case '12':
                        $tipo = 'Archivo';
                        break;
                        case '13':
                        $tipo = 'Video o audio';
                        break;
                        case '14':
                        $tipo = 'Georeferencia';
                        break;
                        case '15':
                        $tipo = 'Dibujo';
                        break;
                        case '16':
                        $tipo = 'Tabla Dinámica Indexable';
                        break;
                        default:
                        $tipo = "";
                        break;
                    }

                    return $tipo;
                });
                //$crud->field_type('pre_tipo', 'dropdown', array('1' => 'Abierta', '2' => 'Cerrada'));


                $data['titulo_personal'] = "Preguntas Encuesta";
                $crud->unset_print()->unset_export()->unset_edit();
                $crud->add_action('Duplicar', '', 'encuesta/procesos/duplicacion_pregunta', 'icomoon-icon-stack ver_detalle_nuevo');
                // Validaciones
                if (!$permisos['permite_agregar']) {
                    $crud->unset_add();
                }
                if ($permisos['permite_editar']) {
                    $crud->add_action('Editar', '', 'encuesta/procesos/editar_pregunta', 'icomoon-icon-pencil-5');
                }
                if ($permisos['permite_eliminar']) {
                    $crud->unset_delete();
                }
                if ($permisos['permite_ver']) {
                    $crud->add_action('Ver', 'minia-icon-search', 'encuesta/procesos/lectura_pregunta');
                }
                if ($permisos['permite_eliminar']) {
                    $crud->add_action('Eliminar', '', 'encuesta/procesos/eliminar_pregunta', 'icon16 icomoon-icon-remove');
                }

                $output = $crud->render();
                cargarvista($data, $output);
            } catch (Exception $e) {
                show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
            }
        }
    }

// End function encuesta_agencia

    public function agregar_pregunta($id_encuesta)
    {
        satelite_validar();
        // depurar($this->input->post());
        if ($this->input->post()) {
            $respuesta_predefinida = '';
            if($this->input->post('respuesta_predefinida_text') != ""){
                $respuesta_predefinida = $this->input->post('respuesta_predefinida_text');
            }else if($this->input->post('respuesta_predefinida_boolean') != ""){
                $respuesta_predefinida = $this->input->post('respuesta_predefinida_boolean');
            }else if($this->input->post('respuesta_predefinida_compuesta') != ""){
                $respuesta_predefinida = $this->input->post('respuesta_predefinida_compuesta');

            }
            //var_dump($_POST); die();
            $id_encuesta = $this->input->post('id_encuesta');
            $nombre = $this->input->post('nombre');
            $categoria = $this->input->post('categoria');
            $tipo_pregunta = $this->input->post('tipo_pregunta');
            $orden = $this->input->post('orden');
            $observacion = $this->input->post('observacion');
            $descripcion = $this->input->post('descripcion');
            $estado = $this->input->post('estado');
            $tipo_accion = $this->input->post('tipo_accion');
            $txtCalMaxPregunta = $this->input->post('txtCalMaxPregunta');
            $chkObligatoria = $this->input->post('chkObligatoria');



            $id_pregunta = 0;

            if ($id_encuesta > 0 && trim($nombre) != '' && $categoria > 0 && $orden > 0 && $tipo_pregunta > 0) {
                $array_insert = array(
                  'pre_id_cap' => $categoria
                  , 'pre_id_enc' => $id_encuesta
                  , 'pre_nombre' => trim($nombre)
                  , 'pre_tipo' => $tipo_pregunta
                  , 'pre_orden' => $orden
                  , 'pre_observacion' => (trim($observacion) != '') ? trim($observacion) : null
                  , 'pre_descripcion' => (trim($descripcion) != '') ? trim($descripcion) : null
                  , 'pre_requerida' => ($chkObligatoria && $chkObligatoria == 1)? 1 : null
                  , 'pre_estado' => $estado
                  , 'pre_usu_creacion' => $this->tank_auth->get_user_id()
                  , 'pre_fecha_creacion' => date('Y-m-d H:i:s')
                  , 'pre_usu_modificacion' => $this->tank_auth->get_user_id()
                  , 'pre_fecha_modificacion' => date('Y-m-d H:i:s')
                  , 'pre_respuesta_sugerida' => $respuesta_predefinida
              );
                if ($txtCalMaxPregunta > 0 ) {
                    $array_insert['pre_calificacion_maxima'] = $txtCalMaxPregunta;
                }

                if ($tipo_pregunta == 10) {
                    $opciones = $this->input->post('detalle_res');
                    $icono = $this->input->post('icono_res');
                    $aplica_notificar = $this->input->post('aplica_correo');
                    if (count($opciones) > 1) { //si es de tipo cerrada debe tener un minimo de 2 opciones de respuesta
                        $id_pregunta = $this->gsatelite->ingresar('pre_pregunta', $array_insert);
                        for ($i = 0; $i < count($opciones); $i++) {
                            if (trim($opciones[$i]) != '') {
                                $insert_opc = array(
                                    'opr_id_pre' => $id_pregunta
                                    , 'opr_id_ico' => ($icono[$i] > 0) ? $icono[$i] : null
                                    , 'opr_nombre' => trim($opciones[$i])
                                    , 'opr_notificacion_correo' => ($aplica_notificar[$i] > 0) ? 1 : 0
                                    , 'opr_estado' => 1
                                    , 'opr_usu_creacion' => $this->tank_auth->get_user_id()
                                    , 'opr_fecha_creacion' => date('Y-m-d H:i:s')
                                    , 'opr_usu_modificacion' => $this->tank_auth->get_user_id()
                                    , 'opr_fecha_modificacion' => date('Y-m-d H:i:s')
                                );
                                $id_detalle = $this->gsatelite->ingresar('opr_opcion_respuesta', $insert_opc);
                            }
                        }
                    }
                } elseif ($tipo_pregunta == 2 || $tipo_pregunta == 3) { // Para seleccion multiple y listas desplegables
                    $opciones = $this->input->post('detalle_res_lista');
                    $aplica_especificar = $this->input->post('aplica_especificar');
                    $finalizar_encuesta = $this->input->post('finalizar_encuesta');
                    $salto_pregunta = $this->input->post('salto_pregunta');
                    $txtPuntuacionRes = ($this->input->post('txtPuntuacionRes'))? $this->input->post('txtPuntuacionRes'):array();
                    $imagen_respuesta = $this->input->post('imagen_respuesta');

                    if (count($opciones) >= 1) { //Debe tener al menos 2 opciones registradas.
                        //Almacenamos el registro en bd para obtener el id.
                        $id_pregunta = $this->gsatelite->ingresar('pre_pregunta', $array_insert);
                        for ($i = 0; $i < count($opciones); $i++) {
                            if (trim($opciones[$i]) != '') {
                                $insert_opc = array(
                                    'opr_id_pre' => $id_pregunta,
                                    'opr_nombre' => trim($opciones[$i]),
                                    'opr_notificacion_correo' => 0,
                                    'opr_aplica_especifique' => ($aplica_especificar[$i] > 0) ? 1 : 0,
                                    'opr_finalizar_encuesta' => ($finalizar_encuesta[$i] > 0) ? 1 : 0,
                                    'opr_id_pre_salto' => ($salto_pregunta[$i] > 0) ? $salto_pregunta[$i] : null,
                                    'opr_estado' => 1,
                                    'opr_usu_creacion' => $this->tank_auth->get_user_id(),
                                    'opr_fecha_creacion' => date('Y-m-d H:i:s'),
                                    'opr_usu_modificacion' => $this->tank_auth->get_user_id(),
                                    'opr_fecha_modificacion' => date('Y-m-d H:i:s')
                                );
                                if (isset($txtPuntuacionRes[$i]) && is_numeric($txtPuntuacionRes[$i])) {
                                    $insert_opc['opr_puntuacion'] = $txtPuntuacionRes[$i];
                                }

                                if (isset($imagen_respuesta[$i]) && trim($imagen_respuesta[$i]) !='') { 
                                    $extension_file = end(explode('.', $imagen_respuesta[$i]));
                                    $nombre_file = str_replace('.'.$extension_file , '', end(explode('/', $imagen_respuesta[$i])));
                                    $new_nombre_file = $nombre_file.'_'.time().'.'.$extension_file; //asignamos un nombre unico al archivo
                                    copy($imagen_respuesta[$i], ("uploads/anx_opcion_respuesta/".$new_nombre_file)); //copiamos en la carpeta oficial
                                    unlink($imagen_respuesta[$i]); //eliminamos el temporal
                                    $insert_opc['opr_url'] = $new_nombre_file ;
                                }

                                
                                //Almacenamos el registro en la bd.
                                $id_detalle = $this->gsatelite->ingresar('opr_opcion_respuesta', $insert_opc);
                            }
                        }
                    }
                } elseif ($tipo_pregunta == 9) {

                    $opciones = $this->input->post('detalle_res_dinamica');
                    $es_obligatoria_dinamica = $this->input->post('es_obligatoria_dinamica');
                    $tipo_pregunta_dinamica = $this->input->post('tipo_pregunta_dinamica');
                    $respuestas_dinamicas = json_decode($this->input->post('respuestas_configuracion_dinamicas')[0]);

                    /*   echo '$respuestas_dinamicas<pre>';
                       print_r( $respuestas_dinamicas);
                       echo '</pre>';
                       echo '$opciones<pre>';
                       print_r( $opciones);
                       echo '</pre>'; */


                       if (count($opciones) > 0) {
                        //ALmacenamos el registro en la bd.
                        $id_pregunta = $this->gsatelite->ingresar('pre_pregunta', $array_insert);
                        for ($i = 0; $i < count($opciones); $i++) {
                            if (trim($opciones[$i]) != '') {
                                $insert_opc = array(
                                    'opr_id_pre' => $id_pregunta,
                                    'opr_nombre' => trim($opciones[$i]),
                                    'opr_notificacion_correo' => 0,
                                    'opr_tipo_campo_dinamico' => $tipo_pregunta_dinamica[$i],
                                    'opr_requerido' => ($es_obligatoria_dinamica[$i] == 1)? 1:0,
                                    'opr_estado' => 1,
                                    'opr_usu_creacion' => $this->tank_auth->get_user_id(),
                                    'opr_fecha_creacion' => date('Y-m-d H:i:s'),
                                    'opr_usu_modificacion' => $this->tank_auth->get_user_id(),
                                    'opr_fecha_modificacion' => date('Y-m-d H:i:s')
                                );

                                /*   echo '$insert_opc<pre>';
                                   print_r( $insert_opc);
                                   echo '</pre>'; */

                                //Almacenamos el registro en la bd.
                                   $id_detalle = $this->gsatelite->ingresar('opr_opcion_respuesta', $insert_opc);

                                //verificamos si tipo de pregunta dinamica  es tipo 2 o 3
                                   if ($tipo_pregunta_dinamica[$i] == 2 || $tipo_pregunta_dinamica[$i] == 3) {

                                    //Recorremos el vector de array donde estan las respuestas para seleccion multiple y listas desplegables
                                    foreach ($respuestas_dinamicas as $row) {
                                        if ($row->pregunta == $opciones[$i]) {
                                            //Insertamos el registro en la bd
                                            $insert_otd = array(
                                                'otd_id_opr' => $id_detalle,
                                                'otd_nombre' => trim($row->valor),
                                                'otd_aplica_especifique' => $row->especificar,
                                                'otd_estado' => 1,
                                                'otd_usu_creacion' => $this->tank_auth->get_user_id(),
                                                'otd_fecha_creacion' => date('Y-m-d H:i:s'),
                                                'otd_usu_modificacion' => $this->tank_auth->get_user_id(),
                                                'otd_fecha_modificacion' => date('Y-m-d H:i:s')
                                            );

                                            /*  echo '$insert_otd<pre>';
                                              print_r( $insert_otd);
                                              echo '</pre>';*/

                                            //Insertamos registro en la bd
                                              $id_detalle_otd = $this->gsatelite->ingresar('otd_opcion_tabla_dinamica', $insert_otd);

                                            /*   echo '$id_detalle_otd<pre>';
                                               print_r( $id_detalle_otd);
                                               echo '</pre>';*/
                                           }
                                       }
                                   }
                               }
                           }
                       }
                   } elseif ($tipo_pregunta == 16) {

                    $id_pregunta = $this->gsatelite->ingresar('pre_pregunta', $array_insert);

                    $valores = $this->input->post('valor_indexado');
                    $tipos_repuestas = $this->input->post('tipo_indexado');
                    $inicia_desplegado = $this->input->post('inicia_desplegado');
                    $respuestas_dinamicas = json_decode($this->input->post('respuestas_configuracion_dinamicas')[0],true);

                    foreach ($valores as $key => $value) {
                        $insert_opc = array(
                            'opr_id_pre' => $id_pregunta,
                            'opr_nombre' => trim($value),
                            'opr_notificacion_correo' => 0,
                            'opr_tipo_campo_dinamico' => $tipos_repuestas[$key],
                            'opr_opcion_seleccionada ' => $inicia_desplegado[$key],
                            'opr_estado' => 1,
                            'opr_usu_creacion' => $this->tank_auth->get_user_id(),
                            'opr_fecha_creacion' => date('Y-m-d H:i:s'),
                            'opr_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'opr_fecha_modificacion' => date('Y-m-d H:i:s')
                        );

                        $id_detalle = $this->gsatelite->ingresar('opr_opcion_respuesta', $insert_opc);

                        if ($tipos_repuestas[$key] == 2 || $tipos_repuestas[$key] == 3) {

                            foreach ($respuestas_dinamicas as $key3 => $row) {
                                if ($row["pregunta"] == $value) {
                                    //Insertamos el registro en la bd
                                    $insert_otd = array(
                                        'otd_id_opr' => $id_detalle,
                                        'otd_nombre' => trim($row["valor"]),
                                        'otd_aplica_especifique' => $row["especificar"],
                                        'otd_estado' => 1,
                                        'otd_usu_creacion' => $this->tank_auth->get_user_id(),
                                        'otd_fecha_creacion' => date('Y-m-d H:i:s'),
                                        'otd_usu_modificacion' => $this->tank_auth->get_user_id(),
                                        'otd_fecha_modificacion' => date('Y-m-d H:i:s')
                                    );

                                    //Insertamos registro en la bd
                                    $id_detalle_otd = $this->gsatelite->ingresar('otd_opcion_tabla_dinamica', $insert_otd);

                                }
                            }
                        }

                    }


                } else {
                    $id_pregunta = $this->gsatelite->ingresar('pre_pregunta', $array_insert);
                }

                if ($id_pregunta > 0) {
                    $ruta_anexos = $this->input->post('txtRutaArchivo'); //ruta del archivo
                    if (!empty($ruta_anexos)) {
                        for ($i = 0; $i < count($ruta_anexos); $i++) {
                            $ruta_anexos = $this->input->post('txtArchivo'); //anc_nombre
                            $nombre_extesion = explode('.', $ruta_anexos[$i]);
                            $extension = end($nombre_extesion);
                            // $carpeta_temporal_anx = $ruta = "uploads/temp/anx_temporales/" . trim($ruta_anexos[$i]);
                            $carpeta_temporal_anx = $ruta = "public/temp/anx_temporales/" . trim($ruta_anexos[$i]);
                            $carpeta_destino_anx = "uploads/anx_preguntas/" . trim($ruta_anexos[$i]);

                            $documentos_array = array(
                                'anp_id_pre' => $id_pregunta,
                                'anp_nombre' => $ruta_anexos[$i],
                                'anp_ruta' => $carpeta_destino_anx,
                                'anp_estado' => 1,
                                'anp_usu_creacion' => $this->tank_auth->get_user_id(),
                                'anp_fecha_creacion' => date('Y-m-d H:i:s'),
                                'anp_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'anp_fecha_modificacion' => date('Y-m-d H:i:s')
                            );

                            $anc_id = $this->gsatelite->ingresar('anp_anexo_pregunta', $documentos_array);

                            if ($anc_id > 0) {
                                copy($carpeta_temporal_anx, $carpeta_destino_anx);
                                unlink($carpeta_temporal_anx);
                            }
                        }
                    }
                }
            }
            //Porque esto esta comentado?
            //$this->generar_json_encuesta($id_encuesta);
            if ($id_pregunta > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro Agregado", 'texto_alerta' => "Registro agregado correctamente");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error al Guardar", 'texto_alerta' => "No se pudo guardar el registro, favor verificar e intentar nuevamente");
            }
            $this->session->set_flashdata($alerta);
            if ($tipo_accion == 1) {
                redirect('encuesta/procesos/preguntas/' . $id_encuesta);
            } else {
                redirect("encuesta/procesos/agregar_pregunta/$id_encuesta");
            }
        }

        $registro = $this->gsatelite->get_tabla('enc_encuesta', array('enc_id' => $id_encuesta));
        $data['titulo_personal'] = "Agregar Pregunta";
        $data['registro'] = $registro;
        $this->db->order_by('pre_orden ASC');
        $preguntas = $this->gsatelite->get_tabla('pre_pregunta', array('pre_id_enc' => $id_encuesta));
        $data['preguntas'] = $preguntas;
        $data['categoria'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $this->gsatelite->get_dropdown('cap_categoria_pregunta', '{cap_nombre}', '', array('cap_estado' => '1',"((cap_id_enc=$id_encuesta))"=>NULL), null, '', 'cap_id', true));
        $data['icono'] = $this->gsatelite->get_tabla('ico_icono', array('ico_estado' => 1));
        //Obteniendo el vlaor maximo de pregunta
        $actual = $this->encuesta_model->numero_pregunta(array('pre_id_enc' => $id_encuesta));
        if($actual!=null){
            $siguiente=$actual[0]['pre_orden']+1;
        }else{
            $siguiente=1;
        }
        $data['num_pregunta']=$siguiente;
        $data['resta_configurar'] = ($preguntas)? ($registro[0]['enc_calificacion_maxima'] - array_sum(array_column($preguntas, 'pre_calificacion_maxima'))):round($registro[0]['enc_calificacion_maxima'],2);
        if ($registro[0]['enc_tipo'] == 1 && $data['resta_configurar'] <=0) {
            $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Calificación máxima completada", 'texto_alerta' => "No se pueden agregar más preguntas porque ya se completo el 100% de la ponderación");
            $this->session->set_flashdata($alerta);
            redirect('encuesta/procesos/preguntas/' . $id_encuesta);
        }

        cargarvista($data);
    }


    /**
     * @return Agregar preguntas a Listas dinamicas
     * @author Manuel Hernandez
     */
    public function configurar_pregunta()
    {


        $data['pregunta'] = $this->uri->segment(4);
        $data['tipo_pregunta'] = $this->uri->segment(5);

        //Mostramos la vista para listas desplegables y seleccion multiple
        $this->load->view('encuesta/procesos/configurar_pregunta', $data);


    }

    /* Edita los 10 tipos de preguntas
    * @ Update by   Manuel Hernandez
    * @Fecha    25/03/2020
    */

    public function editar_pregunta($id_pregunta, $esver=0)
    {
        satelite_validar();
        if ($id_pregunta <= 0 or !is_numeric($id_pregunta)) {
            redirect('');
        }
        $data['esver'] = $esver;
        $registro_pregunta = $this->gsatelite->get_tabla('pre_pregunta', array('pre_id' => $id_pregunta));
        $id_encuesta = $registro_pregunta[0]['pre_id_enc'];
        $existe_respuesta = $this->gsatelite->get_tabla('rec_respuesta_encuesta', array('rec_id_pre' => $id_pregunta));

        /*if (count($existe_respuesta) > 0) {
            $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "La pregunta no puede ser editada porque ya se encuentra procesada con respuestas");
            $this->session->set_flashdata($alerta);
            redirect('encuesta/procesos/preguntas/' . $id_encuesta);
        }*/

        if ($this->input->post()) {
            $respuesta_predefinida = '';

            if($this->input->post('respuesta_predefinida_text') != ""){
                $respuesta_predefinida = $this->input->post('respuesta_predefinida_text');
            }else if($this->input->post('respuesta_predefinida_boolean') != ""){
                $respuesta_predefinida = $this->input->post('respuesta_predefinida_boolean');
            }else if($this->input->post('respuesta_predefinida_compuesta') != ""){
                $respuesta_predefinida = $this->input->post('respuesta_predefinida_compuesta');

            }
            $id_encuesta = $this->input->post('id_encuesta');
            $nombre = $this->input->post('nombre');
            $categoria = $this->input->post('categoria');
            $tipo_pregunta = $this->input->post('tipo_pregunta');
            $orden = $this->input->post('orden');
            $observacion = $this->input->post('observacion');
            $estado = $this->input->post('estado');
            $tipo_accion = $this->input->post('tipo_accion');
            $txtCalMaxPregunta = $this->input->post('txtCalMaxPregunta');
            $chkObligatoria = $this->input->post('chkObligatoria');
            $descripcion = $this->input->post('descripcion');


            $id_pregunta = $this->input->post('id_pregunta');

            if ($id_encuesta > 0 && trim($nombre) != '' && $categoria > 0 && $orden > 0 && $tipo_pregunta > 0) {
                $array_update = array(
                  'pre_id_cap' => $categoria
                  , 'pre_id_enc' => $id_encuesta
                  , 'pre_nombre' => trim($nombre)
                  , 'pre_tipo' => $tipo_pregunta
                  , 'pre_orden' => $orden
                  , 'pre_descripcion' => $descripcion
                  , 'pre_respuesta_sugerida' => $respuesta_predefinida
                  , 'pre_observacion' => (trim($observacion) != '') ? trim($observacion) : null
                  , 'pre_requerida' => ($chkObligatoria && $chkObligatoria == 1)? 1 : null
                  , 'pre_estado' => $estado
                  , 'pre_usu_modificacion' => $this->tank_auth->get_user_id()
                  , 'pre_fecha_modificacion' => date('Y-m-d H:i:s')
              );
                if ($txtCalMaxPregunta > 0 ) {
                    $array_update['pre_calificacion_maxima'] = $txtCalMaxPregunta;
                }
                if ($tipo_pregunta == 10) {
                    $id_existen = $this->input->post('detalle_res_id');  // id en base de datos de la respuesta
                    $opciones = $this->input->post('detalle_res');    //respuesta existentes en la tabla
                    $icono = $this->input->post('icono_res'); // posicion donde se encuentra el icono
                    $aplica_notificar = $this->input->post('aplica_correo'); //Notificar correo

                    if (count($opciones) > 1) { //si es de tipo cerrada debe tener un minimo de 2 opciones de respuesta

                        //Actualizamos los parametros de la pregunta principal.
                        $this->gsatelite->actualizar_array('pre_pregunta', $array_update, array('pre_id' => $id_pregunta));
                        $editados = array();
                        for ($i = 0; $i < count($opciones); $i++) {
                            if (trim($opciones[$i]) != '') {
                                //Si el id existe entonces modifica el registro
                                if ($id_existen[$i] > 0) {
                                    $editados[] = $id_existen[$i];    //Se van registrando los id de los registros que estan almacenados en la bd
                                    $update_opc = array(
                                      'opr_id_pre' => $id_pregunta
                                      , 'opr_id_ico' => ($icono[$i] > 0) ? $icono[$i] : null
                                      , 'opr_notificacion_correo' => ($aplica_notificar[$i] > 0) ? 1 : 0
                                      , 'opr_nombre' => trim($opciones[$i])
                                      , 'opr_estado' => 1
                                      , 'opr_usu_modificacion' => $this->tank_auth->get_user_id()
                                      , 'opr_fecha_modificacion' => date('Y-m-d H:i:s')
                                  );
                                    $id_detalle = $this->gsatelite->actualizar_array('opr_opcion_respuesta', $update_opc, array('opr_id' => $id_existen[$i]));
                                } else {      // Lo inserta porque se asume es un nuevo registro
                                    $insert_opc = array(
                                      'opr_id_pre' => $id_pregunta
                                      , 'opr_id_ico' => ($icono[$i] > 0) ? $icono[$i] : null
                                      , 'opr_notificacion_correo' => ($aplica_notificar[$i] > 0) ? 1 : 0
                                      , 'opr_nombre' => trim($opciones[$i])
                                      , 'opr_estado' => 1
                                      , 'opr_usu_creacion' => $this->tank_auth->get_user_id()
                                      , 'opr_fecha_creacion' => date('Y-m-d H:i:s')
                                      , 'opr_usu_modificacion' => $this->tank_auth->get_user_id()
                                      , 'opr_fecha_modificacion' => date('Y-m-d H:i:s')
                                  );
                                    $id_detalle = $this->gsatelite->ingresar('opr_opcion_respuesta', $insert_opc);
                                }
                            }
                        }

                        //Obtenemos los id de los registros que fueron cargados inicialmente.
                        $id_actuales = explode(',', $this->input->post('id_opc_array'));
                        for ($k = 0; $k < count($id_actuales); $k++) {
                            if (!in_array($id_actuales[$k], $editados)) { //eliminar los que ya no  venga en el post
                                $this->gsatelite->borrado_general('opr_opcion_respuesta', array('opr_id' => $id_actuales[$k]));
                            }
                        }
                    }
                } elseif ($tipo_pregunta == 2 || $tipo_pregunta == 3) {
                    $id_existen = $this->input->post('detalle_res_lista_id');  // id en base de datos de la respuesta
                    $opciones = $this->input->post('detalle_res_lista');    //respuesta existentes en la tabla
                    $aplica_especificar = $this->input->post('aplica_especificar'); // posicion donde se encuentra el ICONO
                    $finalizar_encuesta = $this->input->post('finalizar_encuesta');//Flag de finalizar encuesta
                    $salto_pregunta = $this->input->post('salto_pregunta');//Flag de saltar a pregunta
                    $txtPuntuacionRes = ($this->input->post('txtPuntuacionRes'))? $this->input->post('txtPuntuacionRes'):array();//Puntuaciones
                    $imagen_respuesta = $this->input->post('imagen_respuesta');//imagenes

                    if (count($opciones) > 1) { //si es de tipo cerrada debe tener un minimo de 2 opciones de respuesta

                        //Actualizamos los parametros de la pregunta principal.
                        $this->gsatelite->actualizar_array('pre_pregunta', $array_update, array('pre_id' => $id_pregunta));
                        $editados = array();
                        for ($i = 0; $i < count($opciones); $i++) {
                            if (trim($opciones[$i]) != '') {
                                //Si el id existe entonces modifica el registro
                                if ($id_existen[$i] > 0) {
                                    $editados[] = $id_existen[$i];    //Se van registrando los id de los registros que estan almacenados en la bd
                                    $update_opc = array(
                                      'opr_id_pre' => $id_pregunta
                                      , 'opr_aplica_especifique' => ($aplica_especificar[$i] > 0) ? 1 : 0
                                      , 'opr_finalizar_encuesta' => ($finalizar_encuesta[$i] > 0) ? 1 : 0
                                      , 'opr_notificacion_correo' => ($aplica_notificar[$i] > 0) ? 1 : 0
                                      , 'opr_id_pre_salto' => ($salto_pregunta[$i] > 0) ? $salto_pregunta[$i] : null
                                      , 'opr_nombre' => trim($opciones[$i])
                                      , 'opr_estado' => 1
                                      , 'opr_usu_modificacion' => $this->tank_auth->get_user_id()
                                      , 'opr_fecha_modificacion' => date('Y-m-d H:i:s')
                                  );
                                    if (isset($txtPuntuacionRes[$i]) && is_numeric($txtPuntuacionRes[$i])) {
                                        $update_opc['opr_puntuacion'] = $txtPuntuacionRes[$i];
                                    }


                                    $id_detalle = $this->gsatelite->actualizar_array('opr_opcion_respuesta', $update_opc, array('opr_id' => $id_existen[$i]));
                                } else {      // Lo inserta porque se asume es un nuevo registro
                                    $insert_opc = array(
                                      'opr_id_pre' => $id_pregunta
                                      , 'opr_aplica_especifique' => ($aplica_especificar[$i] > 0) ? 1 : 0
                                      , 'opr_finalizar_encuesta' => ($finalizar_encuesta[$i] > 0) ? 1 : 0
                                      , 'opr_id_pre_salto' => ($salto_pregunta[$i] > 0) ? $salto_pregunta[$i] : null
                                      , 'opr_notificacion_correo' => 0
                                      , 'opr_nombre' => trim($opciones[$i])
                                      , 'opr_estado' => 1
                                      , 'opr_usu_creacion' => $this->tank_auth->get_user_id()
                                      , 'opr_fecha_creacion' => date('Y-m-d H:i:s')
                                      , 'opr_usu_modificacion' => $this->tank_auth->get_user_id()
                                      , 'opr_fecha_modificacion' => date('Y-m-d H:i:s')
                                  );
                                    if (isset($txtPuntuacionRes[$i]) && is_numeric($txtPuntuacionRes[$i])) {
                                        $insert_opc['opr_puntuacion'] = $txtPuntuacionRes[$i];
                                    }
                                    
                                    if (isset($imagen_respuesta[$i]) && trim($imagen_respuesta[$i]) !='') { 
                                        $extension_file = end(explode('.', $imagen_respuesta[$i]));
                                        $nombre_file = str_replace('.'.$extension_file , '', end(explode('/', $imagen_respuesta[$i])));
                                        $new_nombre_file = $nombre_file.'_'.time().'.'.$extension_file; //asignamos un nombre unico al archivo
                                        copy($imagen_respuesta[$i], ("uploads/anx_opcion_respuesta/".$new_nombre_file)); //copiamos en la carpeta oficial
                                        unlink($imagen_respuesta[$i]); //eliminamos el temporal
                                        $insert_opc['opr_url'] = $new_nombre_file ;
                                    }

                                    $id_detalle = $this->gsatelite->ingresar('opr_opcion_respuesta', $insert_opc);
                                }
                            }
                        }

                        //Obtenemos los id de los registros que fueron cargados inicialmente.
                        $id_actuales = explode(',', $this->input->post('id_opc_array_listas'));

                        for ($k = 0; $k < count($id_actuales); $k++) {
                            if (!in_array($id_actuales[$k], $editados)) { //eliminar los que ya no  venga en el post
                                $this->gsatelite->borrado_general('opr_opcion_respuesta', array('opr_id' => $id_actuales[$k]));
                            }
                        }
                    }
                    //fin de  $tipo_pregunta == 2 || $tipo_pregunta == 3
                } elseif ($tipo_pregunta == 9 || $tipo_pregunta == 16) {
                    $id_existen = $this->input->post('detalle_res_dinamica_id');  // id en base de datos de la respuesta
                    $opciones = $this->input->post('detalle_res_dinamica');    //respuesta existentes en la tabla
                    $tipo_pregunta_dinamica = $this->input->post('tipo_pregunta_dinamica'); // El tipo de pregunta dinamica
                    $inicia_desplegado = $this->input->post('inicia_desplegado'); 
                    $respuestas_dinamicas = json_decode($this->input->post('respuestas_configuracion_dinamicas')[0]);
                    $es_obligatoria_dinamica = $this->input->post('es_obligatoria_dinamica');

                    if (count($opciones) > 1) { //si es de tipo cerrada debe tener un minimo de 2 opciones de respuesta

                        //Actualizamos los parametros de la pregunta principal.
                        $this->gsatelite->actualizar_array('pre_pregunta', $array_update, array('pre_id' => $id_pregunta));
                        $editados = array();
                        for ($i = 0; $i < count($opciones); $i++) {
                            if (trim($opciones[$i]) != '') {
                                //Si el id existe entonces modifica el registro
                                if ($id_existen[$i] > 0) {
                                    $editados[] = $id_existen[$i];    //Se van registrando los id de los registros que estan almacenados en la bd
                                    $update_opc = array(
                                      'opr_id_pre' => $id_pregunta
                                      , 'opr_tipo_campo_dinamico' => $tipo_pregunta_dinamica[$i]
                                      , 'opr_nombre' => trim($opciones[$i])
                                      , 'opr_opcion_seleccionada' => $inicia_desplegado[$i]
                                      , 'opr_requerido' => ($es_obligatoria_dinamica[$i] == 1)? 1:0
                                      , 'opr_estado' => 1
                                      , 'opr_usu_modificacion' => $this->tank_auth->get_user_id()
                                      , 'opr_fecha_modificacion' => date('Y-m-d H:i:s')
                                      , 'opr_notificacion_correo' => ($aplica_notificar[$i] > 0) ? 1 : 0
                                  );
                                    $id_detalle = $this->gsatelite->actualizar_array('opr_opcion_respuesta', $update_opc, array('opr_id' => $id_existen[$i]));

                                    //Verificamos las respuestas que se configuraron siempre y cuando sea de tipo 2 o 3
                                    if ($tipo_pregunta_dinamica[$i] == 2 || $tipo_pregunta_dinamica[$i] == 3) {

                                        foreach ($respuestas_dinamicas as $row) {
                                            if (strcmp($row->pregunta, trim($opciones[$i])) === 0 && !isset($row->otd_id_opr)) {
                                                //Ingresamos el registro en la tabla otd_opcion_tabla_dinamica.
                                                $insert_otd = array(
                                                    'otd_id_opr' => $id_existen[$i],
                                                    'otd_nombre' => trim($row->valor),
                                                    'otd_aplica_especifique' => $row->especificar,
                                                    'otd_estado' => 1,
                                                    'otd_usu_creacion' => $this->tank_auth->get_user_id(),
                                                    'otd_fecha_creacion' => date('Y-m-d H:i:s'),
                                                    'otd_usu_modificacion' => $this->tank_auth->get_user_id(),
                                                    'otd_fecha_modificacion' => date('Y-m-d H:i:s')
                                                );

                                                //Insertamos registro en la bd
                                                $id_detalle_otd = $this->gsatelite->ingresar('otd_opcion_tabla_dinamica', $insert_otd);
                                            }
                                        }
                                    }

                                } else {      // Lo inserta porque se asume es un nuevo registro
                                    $insert_opc = array(
                                       'opr_id_pre' => $id_pregunta
                                       , 'opr_tipo_campo_dinamico' => $tipo_pregunta_dinamica[$i]
                                       , 'opr_nombre' => trim($opciones[$i])
                                       , 'opr_requerido' => ($es_obligatoria_dinamica[$i] == 1)? 1:0
                                       , 'opr_opcion_seleccionada' => $inicia_desplegado[$i]
                                       , 'opr_estado' => 1
                                       , 'opr_usu_creacion' => $this->tank_auth->get_user_id()
                                       , 'opr_fecha_creacion' => date('Y-m-d H:i:s')
                                       , 'opr_usu_modificacion' => $this->tank_auth->get_user_id()
                                       , 'opr_fecha_modificacion' => date('Y-m-d H:i:s')
                                       , 'opr_notificacion_correo' => ($aplica_notificar[$i] > 0) ? 1 : 0
                                   );
                                    $id_detalle = $this->gsatelite->ingresar('opr_opcion_respuesta', $insert_opc);

                                    //Verificamos las respuestas que se configuraron siempre y cuando sea de tipo 2 o 3
                                    if ($tipo_pregunta_dinamica[$i] == 2 || $tipo_pregunta_dinamica[$i] == 3) {

                                        foreach ($respuestas_dinamicas as $row) {
                                            if (strcmp($row->pregunta, trim($opciones[$i])) === 0 && !isset($row->otd_id_opr)) {
                                                //Ingresamos el registro en la tabla otd_opcion_tabla_dinamica.
                                                $insert_otd = array(
                                                    'otd_id_opr' => $id_detalle,
                                                    'otd_nombre' => trim($row->valor),
                                                    'otd_aplica_especifique' => $row->especificar,
                                                    'otd_estado' => 1,
                                                    'otd_usu_creacion' => $this->tank_auth->get_user_id(),
                                                    'otd_fecha_creacion' => date('Y-m-d H:i:s'),
                                                    'otd_usu_modificacion' => $this->tank_auth->get_user_id(),
                                                    'otd_fecha_modificacion' => date('Y-m-d H:i:s')
                                                );

                                                //Insertamos registro en la bd
                                                $id_detalle_otd = $this->gsatelite->ingresar('otd_opcion_tabla_dinamica', $insert_otd);
                                            }
                                        }
                                    }
                                }
                            }
                        }

                        //Obtenemos los id de los registros que fueron cargados inicialmente.
                        $id_actuales = explode(',', $this->input->post('id_opc_array_dinamico'));
                        /*  echo 'id_actuales<pre>';
                          print_r($id_actuales);
                          echo '</pre>'; */

                          for ($k = 0; $k < count($id_actuales); $k++) {
                            if (!in_array($id_actuales[$k], $editados)) { //eliminar los que ya no  venga en el post
                                //Verificamos que el tipo de respuesta de  id_actuales[$k] != 2 o 3
                                $tipo = $this->encuesta_model->consultar_tipo_campo_dinamico(array('opr_id' => $id_actuales[$k]))[0]['opr_tipo_campo_dinamico'];
                                if ($tipo == 2 || $tipo == 3) {
                                    //Es necesario eliminar los registros de la tabla otd_opcion_tabla_dinamica
                                    $this->gsatelite->borrado_general('otd_opcion_tabla_dinamica', array('otd_id_opr' => $id_actuales[$k]));
                                    //realizamos la eliminacion del registro de la tabla opr_opcion_respuesta
                                    $this->gsatelite->borrado_general('opr_opcion_respuesta', array('opr_id' => $id_actuales[$k]));
                                } else {
                                    $this->gsatelite->borrado_general('opr_opcion_respuesta', array('opr_id' => $id_actuales[$k]));
                                }
                            }
                        }

                        //tambien debemos borrar las respuestas de configuraciones que fueron eliminadas

                        $editados = array();
                        foreach ($respuestas_dinamicas as $fila) {
                            $editados[] = $fila->id_pregunta;
                        }

                        $id_actuales = explode(',', $this->input->post('id_opc_array_configuraciones'));

                        for ($k = 0; $k < count($id_actuales); $k++) {
                            if (!in_array($id_actuales[$k], $editados)) { //eliminar los que ya no  venga en el post
                                $this->gsatelite->borrado_general('otd_opcion_tabla_dinamica', array('otd_id' => $id_actuales[$k]));
                            }
                        }
                    }
                    
                } else { //Fin de $tipo_pregunta==9
                    $this->gsatelite->actualizar_array('pre_pregunta', $array_update, array('pre_id' => $id_pregunta));
                }

                if ($id_pregunta > 0) {
                    $anc_id = ($this->input->post('txtanexo_id') != '') ? $this->input->post('txtanexo_id') : array(); //id
                    $ruta_anexos = $this->input->post('txtRutaArchivo'); //ruta del archivo

                    $anexo = $this->gsatelite->get_tabla("anp_anexo_pregunta", array("anp_id_pre" => $id_pregunta));
                    $anexos_id = array_column($anexo, 'anp_id');

                    foreach ($anexo as $key => $value) { //validamos que no se haya eliminado algun anexo
                        if (!in_array($value['anp_id'], $anc_id)) {
                            $this->gsatelite->borrado_general('anp_anexo_pregunta', array('anp_id' => $value['anp_id']));
                            unlink($value['anp_ruta']);
                        }
                    }

                    if (!empty($ruta_anexos)) {
                        foreach ($anc_id as $key => $value) {
                            if (!in_array($anc_id[$key], $anexos_id)) {
                                $ruta_anexos = $this->input->post('txtArchivo'); //anc_nombre
                                $nombre_extesion = explode('.', $ruta_anexos[$key]);
                                $extension = end($nombre_extesion);
                                $carpeta_temporal_anx = $ruta = "public/temp/anx_temporales/" . trim($ruta_anexos[$key]);
                                //$nombreArchivo = trim($titulo_anexo[$i]) . "." . trim($extension);
                                $carpeta_destino_anx = "uploads/anx_preguntas/" . trim($ruta_anexos[$key]);

                                $documentos_array = array(
                                    'anp_id_pre' => $id_pregunta,
                                    'anp_nombre' => $ruta_anexos[$key],
                                    'anp_ruta' => $carpeta_destino_anx,
                                    'anp_estado' => 1,
                                    'anp_usu_creacion' => $this->tank_auth->get_user_id(),
                                    'anp_fecha_creacion' => date('Y-m-d H:i:s'),
                                    'anp_usu_modificacion' => $this->tank_auth->get_user_id(),
                                    'anp_fecha_modificacion' => date('Y-m-d H:i:s')
                                );

                                $anc_id = $this->gsatelite->ingresar('anp_anexo_pregunta', $documentos_array);

                                if ($anc_id > 0) {
                                    copy($carpeta_temporal_anx, $carpeta_destino_anx);
                                    unlink($carpeta_temporal_anx);
                                }
                            }
                        }

                    }
                }
            }
            $this->generar_json_encuesta($id_encuesta);
            if ($id_pregunta > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro Actualizado", 'texto_alerta' => "Registro actualizado correctamente");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error al Actualizar", 'texto_alerta' => "No se pudo actualizar el registro, favor verificar e intentar nuevamente");
            }


            $this->session->set_flashdata($alerta);
            if ($tipo_accion == 1) {
                redirect('encuesta/procesos/preguntas/' . $id_encuesta);
            } else {
                redirect("encuesta/procesos/editar_pregunta/$id_pregunta");
            }
        }

        $registro_encuesta = $this->gsatelite->get_tabla('enc_encuesta', array('enc_id' => $id_encuesta));
        $data['titulo_personal'] = ($esver)? "Ver Pregunta":"Editar Pregunta";
        $data['registro_encuesta'] = $registro_encuesta[0];
        $data['registro_pregunta'] = $registro_pregunta[0];
        $data['categoria'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $this->gsatelite->get_dropdown('cap_categoria_pregunta', '{cap_nombre}', '', array('cap_estado' => '1',"(cap_id_enc = $id_encuesta)" => NULL), $registro_pregunta[0]['pre_id_cap'], '', 'cap_id', true));
        $data['icono'] = $this->gsatelite->get_tabla('ico_icono', array('ico_estado' => 1));
        $data['opciones_respuesta'] = array();
        $data['requerido'] = '';
        $this->db->order_by('pre_orden ASC');
        $preguntas = $this->gsatelite->get_tabla('pre_pregunta', array('pre_id !=' => $id_pregunta, 'pre_id_enc' => $registro_pregunta[0]['pre_id_enc']));
        $data['preguntas'] = $preguntas;
        $resta_configurar = ($preguntas)? ($registro_encuesta[0]['enc_calificacion_maxima'] - array_sum(array_column($preguntas, 'pre_calificacion_maxima'))):round($registro_encuesta[0]['enc_calificacion_maxima'],2);
        $data['resta_configurar'] = $resta_configurar;
        $data['anexo'] = $this->gsatelite->get_tabla('anp_anexo_pregunta', array('anp_id_pre' => $id_pregunta));

        if ($registro_pregunta[0]['pre_tipo'] == 10 || $registro_pregunta[0]['pre_tipo'] == 2 || $registro_pregunta[0]['pre_tipo'] == 3 || $registro_pregunta[0]['pre_tipo'] == 9 || $registro_pregunta[0]['pre_tipo'] == 16) {
            $opciones_respuesta = $this->encuesta_model->opcion_respuesta(array('opr_id_pre' => $registro_pregunta[0]['pre_id'], 'opr_estado' => 1));

            if ($registro_pregunta[0]['pre_tipo'] == 9 || $registro_pregunta[0]['pre_tipo'] == 16) {
                $respuestaConfiguraciones = $this->encuesta_model->respuesta_configuraciones(array('opr_id_pre' => $registro_pregunta[0]['pre_id'], 'opr_estado' => 1));
                $data['respuestaConfiguraciones'] = $respuestaConfiguraciones;

                for ($i = 0; $i < count($opciones_respuesta); $i++) {
                    $tipo_pregunta_texto = '';
                    switch ($opciones_respuesta[$i]['opr_tipo_campo_dinamico']) {
                        case '1':
                        $tipo_pregunta_texto = "Texto";
                        break;
                        case '2':
                        $tipo_pregunta_texto = "Lista Desplegable";
                        break;
                        case '3':
                        $tipo_pregunta_texto = "Selección Múltiple";
                        break;
                        case '4':
                        $tipo_pregunta_texto = "Falso/Verdadero";
                        break;
                        case '5':
                        $tipo_pregunta_texto = "Númerico Entero";
                        break;
                        case '6':
                        $tipo_pregunta_texto = "Número Decimal";
                        break;
                        case '7':
                        $tipo_pregunta_texto = "Fecha";
                        break;
                        case '8':
                        $tipo_pregunta_texto = "Hora";
                        break;
                        default:
                        $tipo_pregunta_texto = 'hola';
                        break;
                    }

                    $opciones_respuesta[$i]['opr_tipo_texto'] = $tipo_pregunta_texto;
                }

            }

            $data['opciones_respuesta'] = $opciones_respuesta;

            //print_r($data['opciones_respuesta']);die();

            if ($registro_pregunta[0]['pre_tipo'] != 2 && $registro_pregunta[0]['pre_tipo'] != 3) {
                $data['disabled'] = 'disabled="disabled"';
            }
        }
        // depurar($data);
        cargarvista($data,null,'encuesta/procesos/editar_pregunta');
    }


    public function eliminar_pregunta($id_pregunta = 0)
    {

        $error = 0;
        $tipo = 0;
        //esta validación esta perfect.
        if ($id_pregunta <= 0 or !is_numeric($id_pregunta)) {
            $tipo = 1;
        }

        $pre_array = array(
            ''
        );

        $registro_pregunta = $this->gsatelite->get_tabla('pre_pregunta', array('pre_id' => $id_pregunta));

        //del registro de la pregunta podes obtener la encuesta.
        $existe_respuesta = $this->gsatelite->get_tabla('rec_respuesta_encuesta', array('rec_id_pre' => $id_pregunta));

        if (count($existe_respuesta) > 0) {
            $tipo = 2;
        } else {
            //Preguntas de una sola respuesta.
            if ($registro_pregunta[0]['pre_tipo'] == 1 || ($registro_pregunta[0]['pre_tipo'] > 3 && $registro_pregunta[0]['pre_tipo'] < 9)) {
                $this->gsatelite->borrado_general('pre_pregunta', array('pre_id' => $registro_pregunta[0]['pre_id']));
                $tipo = 3;
            } elseif ($registro_pregunta[0]['pre_tipo'] == 2 || ($registro_pregunta[0]['pre_tipo'] == 3) || ($registro_pregunta[0]['pre_tipo'] == 10)) {
                //Seleccion multilple, lista desplegable y lista de iconos
                $this->gsatelite->borrado_general('opr_opcion_respuesta', array('opr_id_pre' => $registro_pregunta[0]['pre_id']));
                $this->gsatelite->borrado_general('anp_anexo_pregunta', array('anp_id_pre' => $registro_pregunta[0]['pre_id']));
                $this->gsatelite->borrado_general('pre_pregunta', array('pre_id' => $registro_pregunta[0]['pre_id']));
                $tipo = 3;
            } elseif ($registro_pregunta[0]['pre_tipo'] == 9 || $registro_pregunta[0]['pre_tipo'] == 16) {
                //consultamos los registros de las respuestas
                $respuestas = $this->gsatelite->get_tabla('opr_opcion_respuesta', array('opr_id_pre' => $id_pregunta));
                //recorremso el array y vamos buscando si los id de estas respuestas se encuentran en la tabla
                // odt_opcion_tabla_dinamica. De encontrarlo eliminar los registros
                foreach ($respuestas as $row) {
                    //Borramos los elementos que se encuentran en la tabla odt_opcion_tabla_dinamica
                    $this->gsatelite->borrado_general('otd_opcion_tabla_dinamica', array('otd_id_opr' => $row['opr_id']));
                }

                //Eliminamos los registros que se encuentran en la tabla
                $this->gsatelite->borrado_general('opr_opcion_respuesta', array('opr_id_pre' => $id_pregunta));
                $this->gsatelite->borrado_general('anp_anexo_pregunta', array('anp_id_pre' => $registro_pregunta[0]['pre_id']));
                $this->gsatelite->borrado_general('pre_pregunta', array('pre_id' => $id_pregunta));
                $tipo = 3;
            }
            elseif(in_array($registro_pregunta[0]['pre_tipo'], array(13, 14, 15))) {
                $this->gsatelite->borrado_general('anp_anexo_pregunta', array('anp_id_pre' => $registro_pregunta[0]['pre_id']));
                $this->gsatelite->borrado_general('pre_pregunta', array('pre_id' => $registro_pregunta[0]['pre_id']));
                $tipo = 3;
            }
        }

        if ($tipo == 1) {
            $this->gsatelite->show_dialog("Error, favor intentar de nuevo", "encuesta/index", 'error');
        } elseif ($tipo == 2) {
            $this->gsatelite->show_dialog("Otros registros dependen de este,<br />&nbsp;Por lo tanto no puede ser eliminado.", "encuesta/procesos/preguntas/" . $registro_pregunta[0]['pre_id_enc'], 'error');
        } elseif ($tipo == 3) {
            $this->gsatelite->show_dialog("Registro eliminado éxitosamente.", "encuesta/procesos/preguntas/" . $registro_pregunta[0]['pre_id_enc']);
        }
    }


    public function lectura_pregunta($id_pregunta)
    {

        if ($id_pregunta <= 0 or !is_numeric($id_pregunta)) {
            redirect('');
        }
        $this->editar_pregunta($id_pregunta,1);
        die();
        $registro_pregunta = $this->gsatelite->get_tabla('pre_pregunta', array('pre_id' => $id_pregunta));
        $id_encuesta = $registro_pregunta[0]['pre_id_enc'];
        $existe_respuesta = $this->gsatelite->get_tabla('rec_respuesta_encuesta', array('rec_id_pre' => $id_pregunta));

        $registro_encuesta = $this->gsatelite->get_tabla('enc_encuesta', array('enc_id' => $id_encuesta));
        $data['titulo_personal'] = "Editar Pregunta";
        $data['registro_encuesta'] = $registro_encuesta[0];
        $data['registro_pregunta'] = $registro_pregunta[0];
        $data['categoria'] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $this->gsatelite->get_dropdown('cap_categoria_pregunta', '{cap_nombre}', '', array('cap_estado' => '1'), $registro_pregunta[0]['pre_id_cap'], '', 'cap_id', true));
        $data['icono'] = $this->gsatelite->get_tabla('ico_icono', array('ico_estado' => 1));
        $data['opciones_respuesta'] = array();
        $data['requerido'] = '';
        if ($registro_pregunta[0]['pre_tipo'] == 10 || $registro_pregunta[0]['pre_tipo'] == 2 || $registro_pregunta[0]['pre_tipo'] == 3 || $registro_pregunta[0]['pre_tipo'] == 9 || $registro_pregunta[0]['pre_tipo'] == 16) {
            $opciones_respuesta = $this->encuesta_model->opcion_respuesta(array('opr_id_pre' => $registro_pregunta[0]['pre_id'], 'opr_estado' => 1));
            /*  echo '$opciones_respuesta<pre>';
  print_r($opciones_respuesta);
  echo '</pre>';*/
  if ($registro_pregunta[0]['pre_tipo'] == 9 || $registro_pregunta[0]['pre_tipo'] == 16) {
    $respuestaConfiguraciones = $this->encuesta_model->respuesta_configuraciones(array('opr_id_pre' => $registro_pregunta[0]['pre_id'], 'opr_estado' => 1));
                /*     echo '$respuestaConfiguraciones<pre>';
     print_r($respuestaConfiguraciones);
     echo '</pre>';*/
     $data['respuestaConfiguraciones'] = $respuestaConfiguraciones;

     for ($i = 0; $i < count($opciones_respuesta); $i++) {
        $tipo_pregunta_texto = '';
        switch ($opciones_respuesta[$i]['opr_tipo_campo_dinamico']) {
            case '1':
            $tipo_pregunta_texto = "Texto";
            break;
            case '2':
            $tipo_pregunta_texto = "Lista Desplegable";
            break;
            case '3':
            $tipo_pregunta_texto = "Selección Múltiple";
            break;
            case '4':
            $tipo_pregunta_texto = "Falso/Verdadero";
            break;
            case '5':
            $tipo_pregunta_texto = "Númerico Entero";
            break;
            case '6':
            $tipo_pregunta_texto = "Número Decimal";
            break;
            case '7':
            $tipo_pregunta_texto = "Fecha";
            break;
            case '8':
            $tipo_pregunta_texto = "Hora";
            break;
            default:
            $tipo_pregunta_texto = 'hola';
            break;
        }

        $opciones_respuesta[$i]['opr_tipo_texto'] = $tipo_pregunta_texto;
    }

}

$data['opciones_respuesta'] = $opciones_respuesta;
$data['disabled'] = 'disabled="disabled"';
}
cargarvista($data);
}


public function lectura_preguntaff($id_pregunta)
{
    if ($id_pregunta <= 0 or !is_numeric($id_pregunta)) {
        redirect('');
    }

    $registro_pregunta = $this->gsatelite->get_tabla('pre_pregunta', array('pre_id' => $id_pregunta));
    $id_encuesta = $registro_pregunta[0]['pre_id_enc'];

    $existe_respuesta = $this->gsatelite->get_tabla('rec_respuesta_encuesta', array('rec_id_pre' => $id_pregunta));


    $registro_encuesta = $this->gsatelite->get_tabla('enc_encuesta', array('enc_id' => $id_encuesta));
    $data['titulo_personal'] = "Editar Pregunta";
    $data['registro_encuesta'] = $registro_encuesta[0];
    $data['registro_pregunta'] = $registro_pregunta[0];
    $data['categoria'] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $this->gsatelite->get_dropdown('cap_categoria_pregunta', '{cap_nombre}', '', array('cap_estado' => '1'), $registro_pregunta[0]['pre_id_cap'], '', 'cap_id', true));
    $data['icono'] = $this->gsatelite->get_tabla('ico_icono', array('ico_estado' => 1));
    $data['opciones_respuesta'] = array();
    if ($registro_pregunta[0]['pre_tipo'] == 2) {
        $data['opciones_respuesta'] = $this->encuesta_model->opcion_respuesta(array('opr_id_pre' => $registro_pregunta[0]['pre_id'], 'opr_estado' => 1));
    }
    cargarvista($data);
}

public function validar_orden()
{
    $existe = 0;
    if ($this->input->post('id_enc') > 0 and $this->input->post('orden') > 0) {
        $where = array('pre_id_enc' => $this->input->post('id_enc'), 'pre_orden' => $this->input->post('orden'), 'pre_id !=' => $this->input->post('id_pregunta'));
        $query = $this->gsatelite->get_tabla('pre_pregunta', $where);
        if (count($query) > 0) {
            $existe = 1;
        }
    }

    die(json_encode(array('existe' => $existe)));
}

public function validar_pregunta()
{
    $existe = 0;
    if ($this->input->post('id_enc') > 0 and trim($this->input->post('pregunta')) != '') {
        $where = array('pre_id_enc' => $this->input->post('id_enc'), 'pre_nombre' => $this->input->post('pregunta'), 'pre_id !=' => $this->input->post('id_pregunta'));
        $query = $this->gsatelite->get_tabla('pre_pregunta', $where);
        if (count($query) > 0) {
            $existe = 1;
        }
    }

    die(json_encode(array('existe' => $existe)));
}

public function ver_detalle_pregunta($id_pregunta)
{
    $registro_pregunta = $this->gsatelite->get_tabla('pre_pregunta', array('pre_id' => $id_pregunta));
    $data['registro_pregunta'] = $registro_pregunta[0];
        /*  echo '$registro_pregunta<pre>';
          print_r($registro_pregunta);
          echo '</pre>'; */

          if ($registro_pregunta[0]['pre_tipo'] == 10 || $registro_pregunta[0]['pre_tipo'] == 2 || $registro_pregunta[0]['pre_tipo'] == 3) {
            $data['opciones_respuesta'] = $this->encuesta_model->opcion_respuesta(array('opr_id_pre' => $registro_pregunta[0]['pre_id'], 'opr_estado' => 1));
        } elseif ($registro_pregunta[0]['pre_tipo'] == 9) {
            $registros = $this->encuesta_model->opcion_respuesta(array('opr_id_pre' => $registro_pregunta[0]['pre_id'], 'opr_estado' => 1));

            $data['opciones_respuesta'] = $registros;

            /*  echo '$registros<pre>';
              print_r( $registros);
              echo '</pre>'; */

              $respuestaConfiguraciones = $this->encuesta_model->respuesta_configuraciones(array('opr_id_pre' => $registro_pregunta[0]['pre_id'], 'opr_estado' => 1));
              $data['respuestaConfiguraciones'] = $respuestaConfiguraciones;

            /* echo '$respuestaConfiguraciones<pre>';
             print_r( $respuestaConfiguraciones);
             echo '</pre>'; */

            //recorremos array para verificar si existen respuestas.

         }

        /* echo '<pre>';
 print_r($data);
 echo '</pre>'; */

 $this->load->view('encuesta/procesos/ver_detalle_pregunta', $data);
}

public function generar_json_encuesta_sucursal($retorna = false)
{
    satelite_validar();
    $datos = $this->encuesta_model->json_encuesta_sucursal();
    $json = array();
    foreach ($datos as $fila) {
        $fila['encuestas'] = $this->encuesta_model->encuestas_json(explode(',', $fila['id_encuestas']));
        $json[] = $fila;
    }
    $json_string = json_encode($json, JSON_UNESCAPED_UNICODE);
    $file = 'uploads/app_json/sucursal_encuesta.json';
        //print_r($json_string); die();
    file_put_contents($file, $json_string);
    if ($retorna) {
        return true;
    }
        //header("Location: ".base_url()."uploads/app_json/usuarios.json");
}

public function generar_json_encuesta($id_encuesta, $retorna = false)
{
    satelite_validar();


        //print_r(json_decode($todo)); die(" :/");
    $preguntas = $this->encuesta_model->get_preguntas(array("pre_id_enc" => $id_encuesta, "pre_estado" => 1));
    $cadena_json = '{
        pages: [';
        $i = 0;
        foreach ($preguntas as $fila) {
            $i++;
            $cadena_json .= '{
             name: "page' . $i . '",
             questions: [
             {';
            if ($fila["pre_tipo"] == 2) { //pregunta cerrada
                $opciones_respuesta = $this->encuesta_model->opcion_respuesta(array("opr_id_pre" => $fila["pre_id"], "opr_estado" => 1));
                $cadena_json .= 'type: "radiogroup",
                name: "PRE_' . $fila['pre_id'] . '",
                title: "' . $fila['pre_nombre'] . '",
                choices: [';
                $k = 0;
                foreach ($opciones_respuesta as $res) {
                    $k++;
                    $ruta_icono = ($res['opr_id_ico'] > 0) ? base_url('uploads/encuesta/iconos/' . $res['ico_url']) : base_url('uploads/encuesta/iconos/sin_icono.png');
                    $nombre_icono = ($res['opr_id_ico'] > 0) ? $res['ico_url'] : 'sin_icono.png';

                    $cadena_json .= '{
                     value: "' . $res['opr_id'] . '",
                     text: "' . $res['opr_nombre'] . '",
                     image_url: "' . $ruta_icono . '",
                     image_nombre: "' . $nombre_icono . '"';
                    $cadena_json .= (count($opciones_respuesta) == $k) ? '}' : '},'; //si es el final omitir la coma (,)
                }

                $cadena_json .= ']';
            } else {
                $cadena_json .= 'type: "comment",
                name: "PRE_' . $fila['pre_id'] . '",
                title: "' . $fila['pre_nombre'] . '"';
            }
            $cadena_json .= (count($preguntas) == $i) ? '} ] } ' : '} ] },'; //si es el final omitir la coma (,)
        }

        $datos_cliente = ',
        {
           name: "page' . ($i + 1) . '",
           questions: [
           {
             type: "multipletext",
             name: "datos_cliente",
             title: "Datos del Cliente",
             items: [
             {
               name: "nombre",
               title: "Nombre"
               },
               {
                   name: "apellido",
                   title: "Apellido"
                   },
                   {
                       name: "email",
                       title: "Correo"
                       },
                       {
                           name: "telefono",
                           title: "Teléfono"
                       }
                       ]
                   }
                   ]
               }';


               $cadena_json .= $datos_cliente . ' ]
           }';
        //$json_string = json_encode($json, JSON_UNESCAPED_UNICODE); 
           $file = "uploads/encuesta/app_json/preguntas_encuesta_" . $id_encuesta . ".json";
        //print_r($json_string); die();
           file_put_contents($file, $cadena_json);
           if ($retorna) {
            return true;
        }
        //header("Location: ".base_url()."uploads/app_json/usuarios.json");
    }

    public function generar_json_usuario($retorna = false)
    {
        satelite_validar();
        $datos = $this->encuesta_model->json_usuarios();
        $json = array();
        foreach ($datos as $fila) {
            $fila['sucursales'] = $this->encuesta_model->sucursales_json(explode(',', $fila['id_sucursales'])); //$sucursales;
            $json[] = $fila;
        }
        $json_string = json_encode($json, JSON_UNESCAPED_UNICODE);
        $file = 'uploads/encuesta/app_json/usuarios.json';
        //print_r($json_string); die();
        file_put_contents($file, $json_string);
        if ($retorna) {
            return true;
        }
        //header("Location: ".base_url()."uploads/app_json/usuarios.json");
    }

    /**
     * @return Listado de Sucursales por Usuario
     * @author Mario Marquez
     */
    public function gestion_sucursales()
    {
        satelite_validar();

        $usuario_id = $this->tank_auth->get_user_id();

        $where = array('usc_id_usu' => $usuario_id);

        $data['sucursales'] = $this->encuesta_model->get_sucursalesxusuario($where);
        $data['titulo_personal'] = "Responder Encuesta";

        //die(var_dump($data['sucursales']));
        cargarvista($data);
        //$this->gsatelite->cargar_vista_masterpage('encuesta/procesos/gestion_sucursales', $data);
    }

    public function gestion_encuestas_sucursal($suc_id)
    {
        satelite_validar();

        if ($suc_id != null) {


            $where = array('suc_id' => $suc_id, 'exs_estado' => 1, 'enc_estado' => 1);

            $data['encuestas'] = $this->encuesta_model->get_encuestasxsucursal($where);
            $data['suc_id'] = $suc_id;
            $data['titulo_personal'] = "Gestión Encuesta Grupos";

            cargarvista($data);
            // $this->gsatelite->cargar_vista_masterpage('encuesta/procesos/gestion_encuestas_sucursal', $data);
        } else {
            redirect('encuesta/procesos/gestion_sucursales');
        }
    }

    public function iniciar_encuesta($enc_id = 0, $suc_id = 0)
    {   
        $datos_link = array();
        if ($enc_id == 0) {

            $validar = $this->ejecutarLinkEncuesta(true);
            $validar_estado = $validar["estado_link"];

            if ($validar_estado == 1) //link legible
            {
                $datos_link = $validar;

                $enc_id = $validar["registro"]["enc_id"];
            } else {
                $this->ejecutarLinkEncuesta();
            }
        } else {
            if (!$_POST) {
                satelite_validar();
            }
        }
        if ($enc_id != null) {

            if ($_POST) {
                // die(var_dump($_POST));
                //Se obtienen los datos del post
                $post_array = $this->input->post();
                $id_usuario = ($post_array['txtIdUsario'] > 0) ? $post_array['txtIdUsario'] : $this->tank_auth->get_user_id();

                $txtNombre = $post_array['txtNombre'];
                $txtApellido = $post_array['txtApellido'];
                $txtCorreo = ($post_array['txtCorreo'] != '') ? $post_array['txtCorreo'] : null;
                $txtTelefono = ($post_array['txtTelefono'] != '') ? $post_array['txtTelefono'] : null;
                $preguntasIds = $post_array['pregunta'];
                $preguntasTipo = $post_array['tipo_preg'];
                $respuestasArray = $post_array['respuesta'];
                //Obteniendo el id de exs_encuestaxsucursal
                $where = array('exs_id_enc' => $enc_id, 'exs_id_suc' => $suc_id);
                $query = $this->gsatelite->get_tabla('exs_encuestaxsucursal', $where);
                $exs_id = $query[0]['exs_id'];

                $cliente_id = 1; //id de cliente por defecto;
                if (trim($txtNombre) != "" && trim($txtApellido) != "") {
                    //Se verifica si el cliente existe
                    $cliente_existente = $this->gsatelite->get_tabla('cli_cliente', array('cli_nombre' => $txtNombre, 'cli_apellido' => $txtApellido, 'cli_correo' => $txtCorreo));
                    $cliente_id = 0;
                    //var_dump($cliente_existente);die();
                    //Si el cliente no existe se ingresa
                    if (count($cliente_existente) == 0) {
                        $cliente_array = array(
                            'cli_nombre' => $txtNombre,
                            'cli_apellido' => $txtApellido,
                            'cli_correo' => $txtCorreo,
                            'cli_telefono' => $txtTelefono,
                            'cli_estado' => 1,
                            'cli_usu_creacion' => $id_usuario,
                            'cli_fecha_creacion' => date('Y-m-d H:i:s'),
                            'cli_usu_modificacion' => $id_usuario,
                            'cli_fecha_modificacion' => date('Y-m-d H:i:s')
                        );

                        $cliente_id = $this->gsatelite->ingresar('cli_cliente', $cliente_array);
                    } else {
                        $cliente_id = $cliente_existente[0]['cli_id'];
                    }
                }


                //Se ingresa la encuesta por cliente
                if ($cliente_id > 0) {

                    $defecto = $this->gsatelite->get_tabla('uxs_usuarioxsucursal', array('uxs_id_exs_defecto >' => 0, 'uxs_id_usu' => $id_usuario));

                    $ecl_array = array(
                        'ecl_id_cli' => $cliente_id,
                        'ecl_id_exs' => $exs_id, //$post_array['txtIdUxs'] > 0) ? $post_array['txtIdUxs'] : $defecto[0]['uxs_id_exs_defecto'],
                        'ecl_fecha' => date('Y-m-d H:i:s'),
                        'ecl_estado' => 1,
                        'ecl_usu_creacion' => $id_usuario,
                        'ecl_fecha_creacion' => date('Y-m-d H:i:s'),
                        'ecl_usu_modificacion' => $id_usuario,
                        'ecl_fecha_modificacion' => date('Y-m-d H:i:s')
                    );

                    if (isset($post_array["txtIdLke"]) && $post_array["txtIdLke"] > 0) {
                        $ecl_array["ecl_id_lke"] = $post_array["txtIdLke"];
                    }

                    $ecl_id = $this->gsatelite->ingresar('ecl_encuesta_cliente', $ecl_array);
                    //Se ingresa las respuestas por pregunta
                    if ($ecl_id > 0) {

                        for ($i = 0; $i < count($preguntasIds); $i++) {

                            $respuestas_array = array(
                                'rec_id_ecl' => $ecl_id,
                                'rec_id_pre' => $preguntasIds[$i],
                                'rec_id_opr' => NULL,
                                'rec_respuesta' => NULL,
                                'rec_fecha_registro' => date('Y-m-d H:i:s'),
                                'rec_estado' => 1,
                                'rec_usu_creacion' => $id_usuario,
                                'rec_fecha_creacion' => date('Y-m-d H:i:s'),
                                'rec_usu_modificacion' => $id_usuario,
                                'rec_fecha_modificacion' => date('Y-m-d H:i:s')
                            );

                            //Se procesan las preguntas cerradas
                            if ($preguntasTipo[$i] == 2) {
                                $respuestas_array['rec_id_opr'] = $respuestasArray[$i];
                            } else {
                                $respuestas_array['rec_respuesta'] = $respuestasArray[$i];
                            }
                            $this->gsatelite->ingresar('rec_respuesta_encuesta', $respuestas_array);
                        }
                    }
                }

                if (isset($post_array["txtKey"])) {

                    $datos_key = $this->ejecutarLinkEncuesta(true, $post_array["txtKey"]);
                    $redireccion = (trim($datos_key["registro"]["lke_link_redireccion"]) != '') ? trim($datos_key["registro"]["lke_link_redireccion"]) : base_url($datos_key["registro"]["lke_url_link"]);
                    if ($datos_key["registro"]["lke_ejecucion_unica"] == 1) //sessión unica
                    {
                        $this->session->set_userdata('encuesta_finalizada', $post_array["txtKey"]);
                    }
                    $data = $datos_key;
                    $data['sucursal'] = $suc_id;
                    $data['redireccion'] = $redireccion;
                    $this->gsatelite->cargar_vista_masterpage("encuesta/procesos/ejecutarLinkEncuesta_finalizada", $data);


                } else {

                    $data['logo'] = $this->gsatelite->get_parametro('SYS_LOGOTIPO');
                    $data['encuesta'] = $enc_id;
                    $data['sucursal'] = $suc_id;
                    $this->gsatelite->cargar_vista_masterpage('encuesta/procesos/vista_encuesta_completada', $data);
                }
                //die();
            } else {

                //  echo "iniciando encuesta"; //Aqui inicia la encuesta
                $where = array('pre_id_enc' => $enc_id);


                // $data['encuestas'] = $this->gsatelite->get_tabla('enc_encuesta', $where);
                $this->db->order_by('pre_orden ASC');
                $data['preguntas'] = $this->gsatelite->get_tabla('pre_pregunta', $where);


                //Realizamos la consulta y traigo todos los registros de las preguntas, tanto respuestas, opciones y configuraciones si existieran.
                // $data['preguntas']= $this->encuesta->registroPreguntas($enc_id);


                $data['encuesta'] = $enc_id;
                $data['sucursal'] = $suc_id;
                $data['datos_link'] = $datos_link;
                $data['logo'] = $this->gsatelite->get_parametro('SYS_LOGOTIPO');
                $this->gsatelite->cargar_vista_masterpage('encuesta/procesos/iniciar_encuesta', $data);
            }
        } else {
            redirect('encuesta/procesos/gestion_sucursales');
        }
    }


    /**
     * @return Muestra la vista responsive con los diferentes tipos de preguntas agregadas
     * @author Manuel Hernandez
     */
    public function iniciarEncuesta($enc_id = 0, $suc_id = 0, $idTicket = null)
    {
        //Se verifica el tipo de presentacion de encuesta
        if($enc_id > 0){
            $encuesta = $this->gsatelite->get_tabla('enc_encuesta', array('enc_id' => $enc_id))[0];
            $data['encuesta_data'] = $encuesta;
            if($encuesta['enc_tipo_presentacion'] == 1){
                redirect('encuesta/procesos/iniciar_encuesta/'.$enc_id.'/'.$suc_id);
                die();
            }else if($encuesta['enc_tipo_presentacion'] == 2){
                redirect('encuesta/procesos/iniciarEncuestaTabs/'.$enc_id.'/'.$suc_id);
                die();
            }
        }

        $data['idTicket'] = $idTicket;
        if ($idTicket) {
            $ticket = $this->gsatelite->get_tabla('tkh_ticket_helpdesk', ['tkh_estado' => 1, 'tkh_id' => $idTicket]);

            if ($ticket[0]['tkh_id_ecl']){
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "La encuesta ya ha sido realizada.");
                $this->session->set_flashdata($alerta);
                redirect('desarrollo/procesos/ticket');
            }
            
            // if ($ticket[0]['tkh_usu_creacion'] != $this->tank_auth->get_user_id()) {
            //     $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "Verificar encuestas pendientes.");
            //     $this->session->set_flashdata($alerta);
            //     redirect('desarrollo/procesos/ticket');
            // }

        }

        // la variable $nameWordOffline se recibia como 3 parametro. se cambio por el id de ticket
     //    if ($nameWorkOffline != '') { 
     //     $this->generarFileOffline(2);
     // }
     $data['aplicaOffline'] = 0;
        if ($enc_id > 0 && $suc_id > 0) { //permitir offline caché
            $data['aplicaOffline'] = 1;
            $data['enc_id_Offline'] = $enc_id;
            $data['suc_id_Offline'] = $suc_id;
            $this->generarFileOffline();
        }

        $datos_link = array();
        if ($enc_id == 0) {

            $validar = $this->ejecutarLinkEncuesta(true);
            $validar_estado = $validar["estado_link"];


            if ($validar_estado == 1) //link legible
            {
                $datos_link = $validar;
                $enc_id = $validar["registro"]["enc_id"];
                $suc_id = $validar["registro"]["suc_id"];
            } else {
                $this->ejecutar_LinkEncuesta();
            }
        } else {
            if (!$_POST) {
                satelite_validar();
            }
        }

        
        if ($enc_id != null && $suc_id != null) {
            
            //Obteniendo el nombre de la encuesta
            $where = array('enc_id' => $enc_id, 'enc_estado' => 1);
            $encuesta = $this->gsatelite->get_tabla('enc_encuesta', $where);
            $nombreEncuesta = $encuesta[0]['enc_nombre'];
            $indicaciones = $encuesta[0]['enc_indicaciones'];


            //Obteniendo el id de exs_encuestaxsucursal
            $where = array('exs_id_enc' => $enc_id, 'exs_id_suc' => $suc_id);
            $query = $this->gsatelite->get_tabla('exs_encuestaxsucursal', $where);
            $data['idSucursal'] = $query[0]['exs_id'];

            //Aqui inicia la encuesta
            $where = array('pre_id_enc' => $enc_id, 'pre_estado' => 1);
            //  $where = array('pre_id_enc' => $enc_id, 'pre_tipo =' => 9);
            $this->db->order_by('pre_orden ASC');
            $this->db->join('cap_categoria_pregunta', 'cap_id=pre_id_cap');
            $preguntas = $this->gsatelite->get_tabla('pre_pregunta', $where);
            $idCliente = $this->gsatelite->get_parametro('SYS_ID_CLIENTE_ANONIMO');

            if (!(empty($preguntas) || empty($idCliente))) {
                
                $detallePreguntas = array();

                //recorro el array de las preguntas para armar un nuevo array con todas las preguntas, respuestas y configuracionesF.
                foreach ($preguntas as $row) {

                    $aux = array();
                    if ($row['pre_tipo'] == 1 || ($row['pre_tipo'] > 3 && $row['pre_tipo'] < 9) ) { //Preguntas de texto
                        $aux = array(
                            'pre_id' => $row['pre_id'],
                            'nombre' => $row['pre_nombre'],
                            'tipo' => $row['pre_tipo'],
                            'requerida' => $row['pre_requerida'],
                            'required' => ($row['pre_requerida'])? 'required':'',
                            'orden' => $row['pre_orden'],
                            'descripcion' => $row['pre_descripcion'],
                            'predefinida' => $row['pre_respuesta_sugerida']
                        );
                    } elseif ($row['pre_tipo'] == 2 || $row['pre_tipo'] == 3) { //Seleccion multiple o lista desplegable
                        $aux = array(
                            'pre_id' => $row['pre_id'],
                            'nombre' => $row['pre_nombre'],
                            'tipo' => $row['pre_tipo'],
                            'orden' => $row['pre_orden'],
                            'requerida' => $row['pre_requerida'],
                            'required' => ($row['pre_requerida'])? 'required':'',
                            'descripcion' => $row['pre_descripcion'],
                            'predefinida' => $row['pre_respuesta_sugerida'],


                            'respuesta' => []
                        );

                        // Consulto las respuestas de estas preguntas
                        $where = array('opr_id_pre' => $row['pre_id'], 'opr_estado' => 1);
                        $this->db->join('pre_pregunta', 'pre_id = opr_id_pre_salto', 'left');
                        $respuestas = $this->gsatelite->get_tabla('opr_opcion_respuesta', $where);


                        //Recorremos vector de respuestas
                        foreach ($respuestas as $row1) {
                            $aux1 = null;
                            $aux1['opr_id'] = $row1['opr_id'];
                            $aux1['opr_nombre'] = $row1['opr_nombre'];
                            $aux1['opr_url'] = (trim($row1['opr_url']) != '' && file_exists('uploads/anx_opcion_respuesta/'.$row1['opr_url']))? base_url('uploads/anx_opcion_respuesta/'.$row1['opr_url']):'';
                            $aux1['opr_url_check'] = ($aux1['opr_url'] != '')? 1:0;
                            $aux1['opr_aplica_especifique'] = $row1['opr_aplica_especifique'];
                            $aux1['opr_finalizar_encuesta'] = $row1['opr_finalizar_encuesta'];
                            $aux1['opr_id_pre_salto'] = ($row1['opr_id_pre_salto'] != null) ? $row1['opr_id_pre_salto'] : 0;
                            $aux1['opr_orden_salto'] = ($row1['opr_id_pre_salto'] != null) ? $row1['pre_orden'] : 0;
                            array_push($aux['respuesta'], $aux1);
                        }


                    } elseif ($row['pre_tipo'] == 10) {
                        $aux = array(
                            'pre_id' => $row['pre_id'],
                            'nombre' => $row['pre_nombre'],
                            'tipo' => $row['pre_tipo'],
                            'orden' => $row['pre_orden'],
                            'requerida' => $row['pre_requerida'],
                            'required' => ($row['pre_requerida'])? 'required':'',
                            'descripcion' => $row['pre_descripcion'],
                            'predefinida' => $row['pre_respuesta_sugerida'],


                            'respuesta' => []
                        );
                        $respuestas = $this->encuesta_model->opcion_respuesta(array('opr_id_pre' => $row['pre_id']));

                        //Recorremos vector de respuestas
                        foreach ($respuestas as $row1) {
                            $aux1 = null;
                            $aux1['opr_id'] = $row1['opr_id'];
                            $aux1['opr_id_ico'] = $row1['opr_id_ico'];
                            $aux1['opr_notificacion_correo'] = $row1['opr_notificacion_correo'];
                            $aux1['opr_nombre'] = $row1['opr_nombre'];
                            $aux1['ico_nombre'] = $row1['ico_nombre'];
                            $aux1['ico_url'] = $row1['ico_url'];
                            array_push($aux['respuesta'], $aux1);
                        }

                    } elseif ($row['pre_tipo'] == 9) {
                        $aux = array(
                            'pre_id' => $row['pre_id'],
                            'nombre' => $row['pre_nombre'],
                            'tipo' => $row['pre_tipo'],
                            'orden' => $row['pre_orden'],
                            'requerida' => $row['pre_requerida'],
                            'required' => ($row['pre_requerida'])? 'required':'',
                            'descripcion' => $row['pre_descripcion'],
                            'predefinida' => $row['pre_respuesta_sugerida'],


                            'respuesta' => []
                        );

                        // Consulto las respuestas de estas preguntas
                        $where = array('opr_id_pre' => $row['pre_id'], 'opr_estado' => 1);
                        $respuestas = $this->gsatelite->get_tabla('opr_opcion_respuesta', $where);

                        //Recorremos vector de respuestas
                        foreach ($respuestas as $row1) {
                            $aux1 = null;
                            $aux1['opr_id'] = $row1['opr_id'];
                            $aux1['opr_id_pre'] = $row1['opr_id_pre'];
                            $aux1['opr_nombre'] = $row1['opr_nombre'];
                            $aux1['opr_requerido'] = ($row1['opr_requerido'] == 1)? 1:0;
                            $aux1['opr_requerido_label'] = ($row1['opr_requerido'] == 1)? '<b class="asterisRequeridoDinamic"> *</b>':'';
                            $aux1['opr_requerido_class'] = ($row1['opr_requerido'] == 1)? 'requerido_dinamic':'';
                            $aux1['opr_aplica_especifique'] = $row1['opr_aplica_especifique'];
                            $aux1['opr_finalizar_encuesta'] = $row1['opr_finalizar_encuesta'];
                            $aux1['opr_tipo_campo_dinamico'] = $row1['opr_tipo_campo_dinamico'];
                            $aux1['opr_opcion_seleccionada'] = $row1['opr_opcion_seleccionada'];
                            $aux1['configuraciones'] = [];

                            if ($row1['opr_tipo_campo_dinamico'] == 2 || $row1['opr_tipo_campo_dinamico'] == 3) {
                                $where = array('otd_id_opr' => $row1['opr_id']);
                                $configuraciones = $this->gsatelite->get_tabla('otd_opcion_tabla_dinamica', $where);

                                //Recorremos las configuraciones

                                foreach ($configuraciones as $row2) {
                                    $aux2 = null;
                                    $aux2['otd_id'] = $row2['otd_id'];
                                    $aux2['otd_nombre'] = $row2['otd_nombre'];
                                    $aux2['otd_aplica_especifique'] = $row2['otd_aplica_especifique'];
                                    array_push($aux1['configuraciones'], $aux2);
                                }
                            }
                            array_push($aux['respuesta'], $aux1);
                        }
                    }elseif ($row['pre_tipo'] == 11 || $row['pre_tipo'] == 12) { //Pregunta archivo e imagen
                        $aux = array(
                            'pre_id' => $row['pre_id'],
                            'nombre' => $row['pre_nombre'],
                            'tipo' => $row['pre_tipo'],
                            'orden' => $row['pre_orden'],
                            'requerida' => $row['pre_requerida'],
                            'required' => ($row['pre_requerida'])? 'required':'',
                            'descripcion' => $row['pre_descripcion'],
                            'predefinida' => $row['pre_respuesta_sugerida'],


                        );
                    }elseif ($row['pre_tipo'] == 14) { //Pregunta tipo mapa
                        $aux = array(
                            'pre_id' => $row['pre_id'],
                            'nombre' => $row['pre_nombre'],
                            'tipo' => $row['pre_tipo'],
                            'orden' => $row['pre_orden'],
                            'requerida' => $row['pre_requerida'],
                            'required' => ($row['pre_requerida'])? 'required':'',
                            'descripcion' => $row['pre_descripcion'],
                            'predefinida' => $row['pre_respuesta_sugerida'],


                            'latitud'=>null,
                            'longitud'=>null
                        );
                    }
                    if ($row['pre_tipo'] == 15) { //Preguntas de tipo Dibujo
                        $aux = array(
                            'pre_id' => $row['pre_id'],
                            'nombre' => $row['pre_nombre'],
                            'tipo' => $row['pre_tipo'],
                            'orden' => $row['pre_orden'],
                            'requerida' => $row['pre_requerida'],
                            'required' => ($row['pre_requerida'])? 'required':'',
                            'descripcion' => $row['pre_descripcion'],
                            'predefinida' => $row['pre_respuesta_sugerida'],


                        );
                    }
                    if($row['pre_tipo'] == 16){
                        $aux = array(
                            'pre_id' => $row['pre_id'],
                            'nombre' => $row['pre_nombre'],
                            'tipo' => $row['pre_tipo'],
                            'orden' => $row['pre_orden'],
                            'requerida' => $row['pre_requerida'],
                            'required' => ($row['pre_requerida'])? 'required':'',
                            'descripcion' => $row['pre_descripcion'],
                            'predefinida' => $row['pre_respuesta_sugerida'],


                            'respuesta' => []
                        );

                        // Consulto las respuestas de estas preguntas
                        $where = array('opr_id_pre' => $row['pre_id'], 'opr_estado' => 1);
                        $this->db->order_by("opr_opcion_seleccionada","DESC");
                        $respuestas = $this->gsatelite->get_tabla('opr_opcion_respuesta', $where);

                        //Recorremos vector de respuestas
                        foreach ($respuestas as $row1) {
                            $aux1 = null;
                            $aux1['opr_id'] = $row1['opr_id'];
                            $aux1['opr_id_pre'] = $row1['opr_id_pre'];
                            $aux1['opr_nombre'] = $row1['opr_nombre'];
                            $aux1['opr_requerido'] = ($row1['opr_requerido'] == 1)? 1:0;
                            $aux1['opr_requerido_label'] = ($row1['opr_requerido'] == 1)? '<b class="asterisRequeridoDinamic"> *</b>':'';
                            $aux1['opr_requerido_class'] = ($row1['opr_requerido'] == 1)? 'requerido_dinamic_index':'';
                            $aux1['opr_aplica_especifique'] = $row1['opr_aplica_especifique'];
                            $aux1['opr_finalizar_encuesta'] = $row1['opr_finalizar_encuesta'];
                            $aux1['opr_tipo_campo_dinamico'] = $row1['opr_tipo_campo_dinamico'];
                            $aux1['opr_opcion_seleccionada'] = $row1['opr_opcion_seleccionada'];
                            $aux1['configuraciones'] = [];

                            if ($row1['opr_tipo_campo_dinamico'] == 2 || $row1['opr_tipo_campo_dinamico'] == 3) {
                                $where = array('otd_id_opr' => $row1['opr_id']);
                                $configuraciones = $this->gsatelite->get_tabla('otd_opcion_tabla_dinamica', $where);

                                //Recorremos las configuraciones

                                foreach ($configuraciones as $row2) {
                                    $aux2 = null;
                                    $aux2['otd_id'] = $row2['otd_id'];
                                    $aux2['otd_nombre'] = $row2['otd_nombre'];
                                    $aux2['otd_aplica_especifique'] = $row2['otd_aplica_especifique'];
                                    array_push($aux1['configuraciones'], $aux2);
                                }
                            }
                            array_push($aux['respuesta'], $aux1);
                        }
                    }

                    //Se incluyen los anexos de la pregunta
                    $anexos_encuesta = $this->gsatelite->get_tabla('anp_anexo_pregunta', array('anp_id_pre' => $row['pre_id']));
                    $aux['anexos'] = $anexos_encuesta;
                    
                    $this->db->select("GROUP_CONCAT(DISTINCT exc_id_cap ) excluir_cat, GROUP_CONCAT(DISTINCT CONCAT(exc_id_cap,'#',dex_id_opr)) condiciones",false);
                    $this->db->group_by("dex_id_pre");
                    $this->db->join('exc_exclusion_categoria','exc_id=dex_id_exc');
                    $conf_exclusion = $this->gsatelite->get_tabla('dex_detalle_exclusion', array('dex_id_pre'=>$row['pre_id']));

                    $aux['exclusion'] = (count($conf_exclusion) > 0)? 1:0;
                    $aux['conf_exclusion'] = (count($conf_exclusion) > 0)? $conf_exclusion[0]:0;
                    $aux['categoria'] = $row['pre_id_cap']; //categoria a la que pertenece la pregunta
                    $aux['cap_nombre'] = $row['cap_nombre']; //categoria a la que pertenece la pregunta

                    array_push($detallePreguntas, $aux);

                } //Fin de foreach
                $exclusion_categoria_enc = $this->gsatelite->get_tabla('exc_exclusion_categoria', array('exc_id_enc'=>$enc_id,'exc_estado'=>1));
                $json_array = array();
                if (isset($exclusion_categoria_enc) && count($exclusion_categoria_enc) > 0) {
                    foreach ($exclusion_categoria_enc as $exc_ ) {
                        $config_ = $this->gsatelite->get_tabla('dex_detalle_exclusion', array('dex_id_exc'=>$exc_['exc_id'],'dex_estado'=>1));
                        if (count($config_) > 0) {
                            $respuestas_esperadas = array();
                            foreach ($config_ as $res) {
                                $respuestas_esperadas['pregunta'][] = $res['dex_id_pre'];
                                $respuestas_esperadas['respuesta'][] = $res['dex_id_opr'];
                            }
                            $json_array['categoria_exc'][] = $exc_['exc_id_cap'];
                            $json_array['categoria_resp'][] = $respuestas_esperadas;
                        }
                    }
                }
                //print_r($detallePreguntas); die();
                $data['exclusion_categoria_enc'] = $json_array;
                $data['exclusion_categoria_enc_json'] = json_encode($json_array);
                $data['preguntas'] = $detallePreguntas;
                $data['suc_id'] = $suc_id;
                $data['encuesta'] = $enc_id;
                $data['datos_link'] = $datos_link;
                $data['logo'] = $this->gsatelite->get_parametro('SYS_LOGOTIPO');
                $data['nombreEncuesta'] = $nombreEncuesta;
                $data["indicaciones"] = $indicaciones;
                $this->load->view('encuesta/procesos/iniciarEncuesta', $data);
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "Favor verificar la configuración, la acción no puede ser completada.");
                $this->session->set_flashdata($alerta);
                redirect('encuesta/procesos/gestion_sucursales');
            }

        } else {
            redirect('encuesta/procesos/gestion_sucursales');
        }
    }



    public function iniciarEncuestaTabs($enc_id = 0, $suc_id = 0, $nameWorkOffline="")
    {
        if($enc_id > 0){
            $encuesta = $this->gsatelite->get_tabla('enc_encuesta', array('enc_id' => $enc_id))[0];
            $data['encuesta_data'] = $encuesta;
        }

        $categorias = array();
        $categorias_id = array();
        $categorias_flag = '';
        $j = 0;
        if ($nameWorkOffline != '') {
         $this->generarFileOffline(2);
     }
     $data['aplicaOffline'] = 0;
        if ($enc_id > 0 && $suc_id > 0) { //permitir offline caché
            $data['aplicaOffline'] = 1;
            $data['enc_id_Offline'] = $enc_id;
            $data['suc_id_Offline'] = $suc_id;
            $this->generarFileOffline();
        }

        $datos_link = array();
        if ($enc_id == 0) {

            $validar = $this->ejecutarLinkEncuesta(true);
            $validar_estado = $validar["estado_link"];


            if ($validar_estado == 1) //link legible
            {
                $datos_link = $validar;
                $enc_id = $validar["registro"]["enc_id"];
                $suc_id = $validar["registro"]["suc_id"];
            } else {
                $this->ejecutar_LinkEncuesta();
            }
        } else {
            if (!$_POST) {
                satelite_validar();
            }
        }

        
        if ($enc_id != null && $suc_id != null) {
            
            //Obteniendo el nombre de la encuesta
            $where = array('enc_id' => $enc_id, 'enc_estado' => 1);
            $encuesta = $this->gsatelite->get_tabla('enc_encuesta', $where);
            $nombreEncuesta = $encuesta[0]['enc_nombre'];
            $indicaciones = $encuesta[0]['enc_indicaciones'];


            //Obteniendo el id de exs_encuestaxsucursal
            $where = array('exs_id_enc' => $enc_id, 'exs_id_suc' => $suc_id);
            $query = $this->gsatelite->get_tabla('exs_encuestaxsucursal', $where);
            $data['idSucursal'] = $query[0]['exs_id'];

            //Aqui inicia la encuesta
            $where = array('pre_id_enc' => $enc_id, 'pre_estado' => 1);
            //  $where = array('pre_id_enc' => $enc_id, 'pre_tipo =' => 9);
            $this->db->order_by('pre_orden ASC');
            $this->db->join('cap_categoria_pregunta', 'cap_id=pre_id_cap');
            $preguntas = $this->gsatelite->get_tabla('pre_pregunta', $where);
            $idCliente = $this->gsatelite->get_parametro('SYS_ID_CLIENTE_ANONIMO');

            if (!(empty($preguntas) || empty($idCliente))) {
                
                $detallePreguntas = array();

                //recorro el array de las preguntas para armar un nuevo array con todas las preguntas, respuestas y configuracionesF.
                foreach ($preguntas as $row) {

                    $aux = array();
                    if ($row['pre_tipo'] == 1 || ($row['pre_tipo'] > 3 && $row['pre_tipo'] < 9) ) { //Preguntas de texto
                        $aux = array(
                            'pre_id' => $row['pre_id'],
                            'nombre' => $row['pre_nombre'],
                            'tipo' => $row['pre_tipo'],
                            'requerida' => $row['pre_requerida'],
                            'required' => ($row['pre_requerida'])? 'required':'',
                            'orden' => $row['pre_orden'],
                            'descripcion' => $row['pre_descripcion'],
                            'predefinida' => $row['pre_respuesta_sugerida']
                        );
                    } elseif ($row['pre_tipo'] == 2 || $row['pre_tipo'] == 3) { //Seleccion multiple o lista desplegable
                        $aux = array(
                            'pre_id' => $row['pre_id'],
                            'nombre' => $row['pre_nombre'],
                            'tipo' => $row['pre_tipo'],
                            'orden' => $row['pre_orden'],
                            'requerida' => $row['pre_requerida'],
                            'required' => ($row['pre_requerida'])? 'required':'',
                            'descripcion' => $row['pre_descripcion'],
                            'predefinida' => $row['pre_respuesta_sugerida'],


                            'respuesta' => []
                        );

                        // Consulto las respuestas de estas preguntas
                        $where = array('opr_id_pre' => $row['pre_id'], 'opr_estado' => 1);
                        $this->db->join('pre_pregunta', 'pre_id = opr_id_pre_salto', 'left');
                        $respuestas = $this->gsatelite->get_tabla('opr_opcion_respuesta', $where);


                        //Recorremos vector de respuestas
                        foreach ($respuestas as $row1) {
                            $aux1 = null;
                            $aux1['opr_id'] = $row1['opr_id'];
                            $aux1['opr_nombre'] = $row1['opr_nombre'];
                            $aux1['opr_url'] = (trim($row1['opr_url']) != '' && file_exists('uploads/anx_opcion_respuesta/'.$row1['opr_url']))? base_url('uploads/anx_opcion_respuesta/'.$row1['opr_url']):'';
                            $aux1['opr_url_check'] = ($aux1['opr_url'] != '')? 1:0;
                            $aux1['opr_aplica_especifique'] = $row1['opr_aplica_especifique'];
                            $aux1['opr_finalizar_encuesta'] = $row1['opr_finalizar_encuesta'];
                            $aux1['opr_id_pre_salto'] = ($row1['opr_id_pre_salto'] != null) ? $row1['opr_id_pre_salto'] : 0;
                            $aux1['opr_orden_salto'] = ($row1['opr_id_pre_salto'] != null) ? $row1['pre_orden'] : 0;
                            array_push($aux['respuesta'], $aux1);
                        }


                    } elseif ($row['pre_tipo'] == 10) {
                        $aux = array(
                            'pre_id' => $row['pre_id'],
                            'nombre' => $row['pre_nombre'],
                            'tipo' => $row['pre_tipo'],
                            'orden' => $row['pre_orden'],
                            'requerida' => $row['pre_requerida'],
                            'required' => ($row['pre_requerida'])? 'required':'',
                            'descripcion' => $row['pre_descripcion'],
                            'predefinida' => $row['pre_respuesta_sugerida'],


                            'respuesta' => []
                        );
                        $respuestas = $this->encuesta_model->opcion_respuesta(array('opr_id_pre' => $row['pre_id']));

                        //Recorremos vector de respuestas
                        foreach ($respuestas as $row1) {
                            $aux1 = null;
                            $aux1['opr_id'] = $row1['opr_id'];
                            $aux1['opr_id_ico'] = $row1['opr_id_ico'];
                            $aux1['opr_notificacion_correo'] = $row1['opr_notificacion_correo'];
                            $aux1['opr_nombre'] = $row1['opr_nombre'];
                            $aux1['ico_nombre'] = $row1['ico_nombre'];
                            $aux1['ico_url'] = $row1['ico_url'];
                            array_push($aux['respuesta'], $aux1);
                        }

                    } elseif ($row['pre_tipo'] == 9) {
                        $aux = array(
                            'pre_id' => $row['pre_id'],
                            'nombre' => $row['pre_nombre'],
                            'tipo' => $row['pre_tipo'],
                            'orden' => $row['pre_orden'],
                            'requerida' => $row['pre_requerida'],
                            'required' => ($row['pre_requerida'])? 'required':'',
                            'descripcion' => $row['pre_descripcion'],
                            'predefinida' => $row['pre_respuesta_sugerida'],


                            'respuesta' => []
                        );

                        // Consulto las respuestas de estas preguntas
                        $where = array('opr_id_pre' => $row['pre_id'], 'opr_estado' => 1);
                        $respuestas = $this->gsatelite->get_tabla('opr_opcion_respuesta', $where);

                        //Recorremos vector de respuestas
                        foreach ($respuestas as $row1) {
                            $aux1 = null;
                            $aux1['opr_id'] = $row1['opr_id'];
                            $aux1['opr_id_pre'] = $row1['opr_id_pre'];
                            $aux1['opr_nombre'] = $row1['opr_nombre'];
                            $aux1['opr_requerido'] = ($row1['opr_requerido'] == 1)? 1:0;
                            $aux1['opr_requerido_label'] = ($row1['opr_requerido'] == 1)? '<b class="asterisRequeridoDinamic"> *</b>':'';
                            $aux1['opr_requerido_class'] = ($row1['opr_requerido'] == 1)? 'requerido_dinamic':'';
                            $aux1['opr_aplica_especifique'] = $row1['opr_aplica_especifique'];
                            $aux1['opr_finalizar_encuesta'] = $row1['opr_finalizar_encuesta'];
                            $aux1['opr_tipo_campo_dinamico'] = $row1['opr_tipo_campo_dinamico'];
                            $aux1['opr_opcion_seleccionada'] = $row1['opr_opcion_seleccionada'];
                            $aux1['configuraciones'] = [];

                            if ($row1['opr_tipo_campo_dinamico'] == 2 || $row1['opr_tipo_campo_dinamico'] == 3) {
                                $where = array('otd_id_opr' => $row1['opr_id']);
                                $configuraciones = $this->gsatelite->get_tabla('otd_opcion_tabla_dinamica', $where);

                                //Recorremos las configuraciones

                                foreach ($configuraciones as $row2) {
                                    $aux2 = null;
                                    $aux2['otd_id'] = $row2['otd_id'];
                                    $aux2['otd_nombre'] = $row2['otd_nombre'];
                                    $aux2['otd_aplica_especifique'] = $row2['otd_aplica_especifique'];
                                    array_push($aux1['configuraciones'], $aux2);
                                }
                            }
                            array_push($aux['respuesta'], $aux1);
                        }
                    }elseif ($row['pre_tipo'] == 11 || $row['pre_tipo'] == 12) { //Pregunta archivo e imagen
                        $aux = array(
                            'pre_id' => $row['pre_id'],
                            'nombre' => $row['pre_nombre'],
                            'tipo' => $row['pre_tipo'],
                            'orden' => $row['pre_orden'],
                            'requerida' => $row['pre_requerida'],
                            'required' => ($row['pre_requerida'])? 'required':'',
                            'descripcion' => $row['pre_descripcion'],
                            'predefinida' => $row['pre_respuesta_sugerida'],


                        );
                    }elseif ($row['pre_tipo'] == 14) { //Pregunta tipo mapa
                        $aux = array(
                            'pre_id' => $row['pre_id'],
                            'nombre' => $row['pre_nombre'],
                            'tipo' => $row['pre_tipo'],
                            'orden' => $row['pre_orden'],
                            'requerida' => $row['pre_requerida'],
                            'required' => ($row['pre_requerida'])? 'required':'',
                            'descripcion' => $row['pre_descripcion'],
                            'predefinida' => $row['pre_respuesta_sugerida'],


                            'latitud'=>null,
                            'longitud'=>null
                        );
                    }
                    if ($row['pre_tipo'] == 15) { //Preguntas de tipo Dibujo
                        $aux = array(
                            'pre_id' => $row['pre_id'],
                            'nombre' => $row['pre_nombre'],
                            'tipo' => $row['pre_tipo'],
                            'orden' => $row['pre_orden'],
                            'requerida' => $row['pre_requerida'],
                            'required' => ($row['pre_requerida'])? 'required':'',
                            'descripcion' => $row['pre_descripcion'],
                            'predefinida' => $row['pre_respuesta_sugerida'],


                        );
                    }
                    if($row['pre_tipo'] == 16){
                        $aux = array(
                            'pre_id' => $row['pre_id'],
                            'nombre' => $row['pre_nombre'],
                            'tipo' => $row['pre_tipo'],
                            'orden' => $row['pre_orden'],
                            'requerida' => $row['pre_requerida'],
                            'required' => ($row['pre_requerida'])? 'required':'',
                            'descripcion' => $row['pre_descripcion'],
                            'predefinida' => $row['pre_respuesta_sugerida'],


                            'respuesta' => []
                        );

                        // Consulto las respuestas de estas preguntas
                        $where = array('opr_id_pre' => $row['pre_id'], 'opr_estado' => 1);
                        $this->db->order_by("opr_opcion_seleccionada","DESC");
                        $respuestas = $this->gsatelite->get_tabla('opr_opcion_respuesta', $where);

                        //Recorremos vector de respuestas
                        foreach ($respuestas as $row1) {
                            $aux1 = null;
                            $aux1['opr_id'] = $row1['opr_id'];
                            $aux1['opr_id_pre'] = $row1['opr_id_pre'];
                            $aux1['opr_nombre'] = $row1['opr_nombre'];
                            $aux1['opr_requerido'] = ($row1['opr_requerido'] == 1)? 1:0;
                            $aux1['opr_requerido_label'] = ($row1['opr_requerido'] == 1)? '<b class="asterisRequeridoDinamic"> *</b>':'';
                            $aux1['opr_requerido_class'] = ($row1['opr_requerido'] == 1)? 'requerido_dinamic_index':'';
                            $aux1['opr_aplica_especifique'] = $row1['opr_aplica_especifique'];
                            $aux1['opr_finalizar_encuesta'] = $row1['opr_finalizar_encuesta'];
                            $aux1['opr_tipo_campo_dinamico'] = $row1['opr_tipo_campo_dinamico'];
                            $aux1['opr_opcion_seleccionada'] = $row1['opr_opcion_seleccionada'];
                            $aux1['configuraciones'] = [];

                            if ($row1['opr_tipo_campo_dinamico'] == 2 || $row1['opr_tipo_campo_dinamico'] == 3) {
                                $where = array('otd_id_opr' => $row1['opr_id']);
                                $configuraciones = $this->gsatelite->get_tabla('otd_opcion_tabla_dinamica', $where);

                                //Recorremos las configuraciones

                                foreach ($configuraciones as $row2) {
                                    $aux2 = null;
                                    $aux2['otd_id'] = $row2['otd_id'];
                                    $aux2['otd_nombre'] = $row2['otd_nombre'];
                                    $aux2['otd_aplica_especifique'] = $row2['otd_aplica_especifique'];
                                    array_push($aux1['configuraciones'], $aux2);
                                }
                            }
                            array_push($aux['respuesta'], $aux1);
                        }
                    }

                    //Se incluyen los anexos de la pregunta
                    $anexos_encuesta = $this->gsatelite->get_tabla('anp_anexo_pregunta', array('anp_id_pre' => $row['pre_id']));
                    $aux['anexos'] = $anexos_encuesta;
                    
                    $this->db->select("GROUP_CONCAT(DISTINCT exc_id_cap ) excluir_cat, GROUP_CONCAT(DISTINCT CONCAT(exc_id_cap,'#',dex_id_opr)) condiciones",false);
                    $this->db->group_by("dex_id_pre");
                    $this->db->join('exc_exclusion_categoria','exc_id=dex_id_exc');
                    $conf_exclusion = $this->gsatelite->get_tabla('dex_detalle_exclusion', array('dex_id_pre'=>$row['pre_id']));

                    $aux['exclusion'] = (count($conf_exclusion) > 0)? 1:0;
                    $aux['conf_exclusion'] = (count($conf_exclusion) > 0)? $conf_exclusion[0]:0;
                    $aux['categoria'] = $row['pre_id_cap']; //categoria a la que pertenece la pregunta
                    $aux['cap_nombre'] = $row['cap_nombre']; //categoria a la que pertenece la pregunta
                    if($categorias_flag != $row['cap_nombre']){
                        $j++;
                        $categorias_id[] = $row['pre_id_cap'].'_'.$j;
                        $categorias[] = $row['cap_nombre'];
                        $categorias_flag = $row['cap_nombre'];
                    }
                    array_push($detallePreguntas, $aux);

                } //Fin de foreach
                $exclusion_categoria_enc = $this->gsatelite->get_tabla('exc_exclusion_categoria', array('exc_id_enc'=>$enc_id,'exc_estado'=>1));
                $json_array = array();
                if (isset($exclusion_categoria_enc) && count($exclusion_categoria_enc) > 0) {
                    foreach ($exclusion_categoria_enc as $exc_ ) {
                        $config_ = $this->gsatelite->get_tabla('dex_detalle_exclusion', array('dex_id_exc'=>$exc_['exc_id'],'dex_estado'=>1));
                        if (count($config_) > 0) {
                            $respuestas_esperadas = array();
                            foreach ($config_ as $res) {
                                $respuestas_esperadas['pregunta'][] = $res['dex_id_pre'];
                                $respuestas_esperadas['respuesta'][] = $res['dex_id_opr'];
                            }
                            $json_array['categoria_exc'][] = $exc_['exc_id_cap'];
                            $json_array['categoria_resp'][] = $respuestas_esperadas;
                        }
                    }
                }
                //print_r($detallePreguntas); die();
                $data['exclusion_categoria_enc'] = $json_array;
                $data['exclusion_categoria_enc_json'] = json_encode($json_array);
                $data['preguntas'] = $detallePreguntas;
                $data['suc_id'] = $suc_id;
                $data['encuesta'] = $enc_id;
                $data['datos_link'] = $datos_link;
                $data['logo'] = $this->gsatelite->get_parametro('SYS_LOGOTIPO');
                $data['nombreEncuesta'] = $nombreEncuesta;
                $data["indicaciones"] = $indicaciones;
                $data['categorias_id'] = $categorias_id;
                $data['categorias'] = $categorias;
                $this->load->view('encuesta/procesos/iniciarEncuestaTabs', $data);
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "Favor verificar la configuración, la acción no puede ser completada.");
                $this->session->set_flashdata($alerta);
                redirect('encuesta/procesos/gestion_sucursales');
            }

        } else {
            redirect('encuesta/procesos/gestion_sucursales');
        }
    }


    /**
     * @return Guarda las respuestas de una encuesta.
     * @author Manuel Hernandez
     */
    public function guardarEncuesta($enc_id = 0, $esOffline=0)
    {
        $valor = $this->input->post();
        if ($_POST) {
            // depurar($this->input->post());
            $post_array = $this->input->post();
               $id_usuario = isset($post_array['txtIdUsario']) ? $post_array['txtIdUsario'] : $this->tank_auth->get_user_id();
               $usuarioAux = null;

               if (isset($post_array['txtIdUsario'])) {
                $id_usuario = $post_array['txtIdUsario'];
                $cliente_id = $this->gsatelite->get_parametro('SYS_ID_CLIENTE_ANONIMO');
            } elseif ($this->tank_auth->get_user_id()) {
                $id_usuario = $this->gsatelite->get_parametro('SYS_ID_CLIENTE_ANONIMO');
                $usuarioAux = $this->tank_auth->get_user_id();
            } else {
                $id_usuario = $this->gsatelite->get_parametro('SYS_ID_CLIENTE_ANONIMO');
            }
            //$id_usuario = ($post_array['txtIdUsario']>0)? $post_array['txtIdUsario']:$this->gsatelite->get_parametro('SYS_ID_CLIENTE_ANONIMO');


            $cliente_id = 1; //Valor por defecto
            /*   if($post_array['txtIdUsario']){
                   $txtNombre = $post_array['txtNombre'];
                   $txtApellido = $post_array['txtApellido'];
                   $txtCorreo = ($post_array['txtCorreo'] != '') ? $post_array['txtCorreo'] : null;
                   $txtTelefono = ($post_array['txtTelefono'] != '') ? $post_array['txtTelefono'] : null;
                   $preguntasIds = $post_array['pregunta'];
                   $preguntasTipo = $post_array['tipo_preg'];
                   $respuestasArray = $post_array['respuesta'];
               }else{ */
            //Obtenemos datos del registro del cliente
                // $cliente_existente = $this->gsatelite->get_tabla('cli_cliente', array('cli_id' => $id_usuario));

            //$cliente_id = $cliente_existente[0]['cli_id'];
                // $txtNombre = $cliente_existente[0]['cli_nombre'];
                // $txtApellido = $cliente_existente[0]['cli_apellido'];
                // $txtCorreo = ($cliente_existente[0]['cli_correo'] != '') ? $cliente_existente[0]['cli_correo'] : null;
                // $txtTelefono = ($cliente_existente[0]['cli_telefono'] != '') ? $cliente_existente[0]['cli_telefono'] : null;
                $preguntasIds = $post_array['pregunta'];
                $preguntasTipo = $post_array['tipo_preg'];
            //   }

                if ($usuarioAux != null) {
                    $id_usuario = $usuarioAux;
                }


                // if (trim($txtNombre) != "" && trim($txtApellido) != "") {
                // //Se verifica si el cliente existe
                //     $cliente_existente = $this->gsatelite->get_tabla('cli_cliente', array('cli_nombre' => $txtNombre, 'cli_apellido' => $txtApellido, 'cli_correo' => $txtCorreo));
                // //$cliente_id = 0;
                // //var_dump($cliente_existente);die();
                // //Si el cliente no existe se ingresa
                //     if (count($cliente_existente) == 0) {
                //         $cliente_array = array(
                //             'cli_nombre' => $txtNombre,
                //             'cli_apellido' => $txtApellido,
                //             'cli_correo' => $txtCorreo,
                //             'cli_telefono' => $txtTelefono,
                //             'cli_estado' => 1,
                //             'cli_usu_creacion' => $id_usuario,
                //             'cli_fecha_creacion' => date('Y-m-d H:i:s'),
                //             'cli_usu_modificacion' => $id_usuario,
                //             'cli_fecha_modificacion' => date('Y-m-d H:i:s')
                //         );

                //         $cliente_id = $this->gsatelite->ingresar('cli_cliente', $cliente_array);
                //     } else {
                //         $cliente_id = $cliente_existente[0]['cli_id'];
                //     }
                // }
            //print_r(trim($txtNombre));die();
            //Se ingresa la encuesta por cliente
                if ($cliente_id > 0) {
                //print_r("entra a la validacion");die();
                    // $defecto = $this->gsatelite->get_tabla('uxs_usuarioxsucursal', array('uxs_id_exs_defecto >' => 0, 'uxs_id_usu' => $id_usuario));

                    $ecl_array = array(
                        // 'ecl_id_cli' => $cliente_id,
                        'ecl_id_exs' => $this->input->post('idSucursal'),
                        'ecl_id_usu' => $id_usuario,
                        'ecl_fecha' => date('Y-m-d H:i:s'),
                        'ecl_estado' => 1,
                        'ecl_usu_creacion' => $id_usuario,
                        'ecl_fecha_creacion' => date('Y-m-d H:i:s'),
                        'ecl_usu_modificacion' => $id_usuario,
                        'ecl_fecha_modificacion' => date('Y-m-d H:i:s')
                    );

                    if (isset($post_array["txtIdLke"]) && $post_array["txtIdLke"] > 0) {
                        $ecl_array["ecl_id_lke"] = $post_array["txtIdLke"];
                    }


                    $ecl_id = $this->gsatelite->ingresar('ecl_encuesta_cliente', $ecl_array);
                    $ruta_archivos = "uploads/encuesta/archivos/" . $ecl_id;

                //Se ingresa las respuestas por pregunta
                    if ($ecl_id > 0) {

                    //recorro el vector de numero de preguntas
                        for ($i = 0; $i < count($preguntasIds); $i++) {

                        //Depende el tipo de respuesta se configuran los vectores.
                            if ($preguntasTipo[$i] == 1 || ($preguntasTipo[$i] > 3 && $preguntasTipo[$i] < 9)) {
                            //Verificamos que la respuesta no tenga un valor null, de lo contrario no se almacenará
                                if (isset($post_array['pregunta_' . $preguntasIds[$i]]) && $post_array['pregunta_' . $preguntasIds[$i]] != '') {
                                    $respuestas_array = array(
                                        'rec_id_ecl' => $ecl_id,
                                        'rec_id_pre' => $preguntasIds[$i],
                                        'rec_id_opr' => NULL,
                                        'rec_respuesta' => $post_array['pregunta_' . $preguntasIds[$i]],
                                        'rec_fecha_registro' => date('Y-m-d H:i:s'),
                                        'rec_estado' => 1,
                                        'rec_usu_creacion' => $id_usuario,
                                        'rec_fecha_creacion' => date('Y-m-d H:i:s'),
                                        'rec_usu_modificacion' => $id_usuario,
                                        'rec_fecha_modificacion' => date('Y-m-d H:i:s')
                                    );

                                    $this->gsatelite->ingresar('rec_respuesta_encuesta', $respuestas_array);
                                }
                            }
                            elseif ($preguntasTipo[$i] == 2) {
                                if (isset($post_array['pregunta_' . $preguntasIds[$i]]) && $post_array['pregunta_' . $preguntasIds[$i]] != '') {
                                    $respuestas_array = array(
                                        'rec_id_ecl' => $ecl_id,
                                        'rec_id_pre' => $preguntasIds[$i],
                                        'rec_id_opr' => $post_array['pregunta_' . $preguntasIds[$i]],
                                        'rec_respuesta' => NULL,
                                        'rec_fecha_registro' => date('Y-m-d H:i:s'),
                                        'rec_estado' => 1,
                                        'rec_usu_creacion' => $id_usuario,
                                        'rec_fecha_creacion' => date('Y-m-d H:i:s'),
                                        'rec_usu_modificacion' => $id_usuario,
                                        'rec_fecha_modificacion' => date('Y-m-d H:i:s')
                                    );

                                    $idRespuestaEncuesta = $this->gsatelite->ingresar('rec_respuesta_encuesta', $respuestas_array);

                                    $especifique = $this->input->post('E' . $post_array['pregunta_' . $preguntasIds[$i]]);

                                    if ($especifique != null) {

                                        $opcion_array = array(
                                        'oxp_id_rec' => $idRespuestaEncuesta,                    //id de la encuesta almacenada
                                        'oxp_id_opr' => $post_array['pregunta_' . $preguntasIds[$i]],          //respuestas de la entrevista
                                        'oxp_valor_referencia' => $especifique,             // Habilitado para opcion
                                        'oxp_estado' => 1,
                                        'oxp_usu_creacion' => $id_usuario,
                                        'oxp_fecha_creacion' => date('Y-m-d H:i:s'),
                                        'oxp_usu_modificacion' => $id_usuario,
                                        'oxp_fecha_modificacion' => date('Y-m-d H:i:s')
                                    );

                                        $this->gsatelite->ingresar('oxp_opcion_respuestaxpregunta', $opcion_array);
                                    }
                                }

                            }
                            elseif ($preguntasTipo[$i] == 3) {

                                if (isset($post_array['pregunta_' . $preguntasIds[$i]]) && $post_array['pregunta_' . $preguntasIds[$i]] != '') {

                                    $respuestas_array = array(
                                        'rec_id_ecl' => $ecl_id,
                                        'rec_id_pre' => $preguntasIds[$i],
                                        'rec_id_opr' => NULL,
                                        'rec_respuesta' => NULL,
                                        'rec_fecha_registro' => date('Y-m-d H:i:s'),
                                        'rec_estado' => 1,
                                        'rec_usu_creacion' => $id_usuario,
                                        'rec_fecha_creacion' => date('Y-m-d H:i:s'),
                                        'rec_usu_modificacion' => $id_usuario,
                                        'rec_fecha_modificacion' => date('Y-m-d H:i:s')
                                    );

                                    $idRespuestaEncuesta = $this->gsatelite->ingresar('rec_respuesta_encuesta', $respuestas_array);

                                    $registros = $post_array['pregunta_' . $preguntasIds[$i]];

                                    for ($k = 0; $k < count($registros); $k++) {


                                        $opcion_array = array(
                                        'oxp_id_rec' => $idRespuestaEncuesta,                    //id de la encuesta almacenada
                                        'oxp_id_opr' => $registros[$k],          //respuestas de la entrevista
                                        'oxp_valor_referencia' => ($this->input->post('EC' . $registros[$k]) != null) ? $this->input->post('EC' . $registros[$k]) : NULL,             // Habilitado para opcion
                                        'oxp_estado' => 1,
                                        'oxp_usu_creacion' => $id_usuario,
                                        'oxp_fecha_creacion' => date('Y-m-d H:i:s'),
                                        'oxp_usu_modificacion' => $id_usuario,
                                        'oxp_fecha_modificacion' => date('Y-m-d H:i:s')
                                    );

                                        $this->gsatelite->ingresar('oxp_opcion_respuestaxpregunta', $opcion_array);


                                    }

                                }

                            }
                        elseif ($preguntasTipo[$i] == 9) { //Pregunta dinamica
                            if (isset($post_array['pregunta_' . $preguntasIds[$i]]) && $post_array['pregunta_' . $preguntasIds[$i]] != '') {

                                $registros = $post_array['pregunta_' . $preguntasIds[$i]];
                                $especifique_array = $this->input->post('especificarPregunta_' . $preguntasIds[$i]);

                                $registroEspecifique = array();
                                foreach ($especifique_array as $fila) {
                                    $registroEspecifique = json_decode($fila);
                                }

                                $contE = 0;
                                foreach ($registros as $row) {

                                    $especifiqueActual = json_decode($especifique_array[$contE]);

                                    //Convertimos el array de json a array php
                                    $aux = json_decode($row);
                                    //Aux contiene las respuestas de tabla dinamica recorremos las diferentes respuestas
                                    foreach ($aux as $conf) {

                                        if ($conf->tipo == 1 || ($conf->tipo > 3 && $conf->tipo <= 8)) {
                                            $respuestas_array = array(
                                                'rec_id_ecl' => $ecl_id,
                                                'rec_id_pre' => $conf->idPregunta,
                                                'rec_id_opr' => $conf->idRespuesta,
                                                'rec_respuesta' => $conf->valor,
                                                'rec_fecha_registro' => date('Y-m-d H:i:s'),
                                                'rec_estado' => 1,
                                                'rec_usu_creacion' => $id_usuario,
                                                'rec_fecha_creacion' => date('Y-m-d H:i:s'),
                                                'rec_usu_modificacion' => $id_usuario,
                                                'rec_fecha_modificacion' => date('Y-m-d H:i:s')
                                            );

                                            $idRespuestaEncuesta = $this->gsatelite->ingresar('rec_respuesta_encuesta', $respuestas_array);

                                        }
                                        elseif ($conf->tipo == 2) {

                                            $respuestas_array = array(
                                                'rec_id_ecl' => $ecl_id,
                                                'rec_id_pre' => $conf->idPregunta,
                                                'rec_id_opr' => $conf->idRespuesta,
                                                'rec_respuesta' => '',
                                                'rec_fecha_registro' => date('Y-m-d H:i:s'),
                                                'rec_estado' => 1,
                                                'rec_usu_creacion' => $id_usuario,
                                                'rec_fecha_creacion' => date('Y-m-d H:i:s'),
                                                'rec_usu_modificacion' => $id_usuario,
                                                'rec_fecha_modificacion' => date('Y-m-d H:i:s')
                                            );

                                            $idRespuestaEncuesta = $this->gsatelite->ingresar('rec_respuesta_encuesta', $respuestas_array);

                                            //Recorremos el vector en busca de elementos que coinciden
                                            $txtEspecificacion = NULL;
                                            foreach ($especifiqueActual as $itemEsp) {
                                                if ($itemEsp->idConfiguracion == $conf->valor) {
                                                    $txtEspecificacion = $itemEsp->especifique;
                                                }
                                            }

                                            //Almacenamos el respuesta en la tabla de opciones x preguntas
                                            $opcion_array = array(
                                                'oxp_id_rec' => $idRespuestaEncuesta,                    //id de la encuesta almacenada
                                                // 'oxp_id_opr' => $conf->valor,          //respuestas de la entrevista
                                                'oxp_id_opr' => $conf->idRespuesta,          //respuestas de la entrevista
                                                'oxp_id_otd' => ($conf->valor >0)? $conf->valor:null,
                                                'oxp_valor_referencia' => $txtEspecificacion,             // Habilitado para opcion
                                                'oxp_estado' => 1,
                                                'oxp_usu_creacion' => $id_usuario,
                                                'oxp_fecha_creacion' => date('Y-m-d H:i:s'),
                                                'oxp_usu_modificacion' => $id_usuario,
                                                'oxp_fecha_modificacion' => date('Y-m-d H:i:s')
                                            );

                                            $this->gsatelite->ingresar('oxp_opcion_respuestaxpregunta', $opcion_array);

                                        } elseif ($conf->tipo == 3) {

                                            /*  echo 'conf<pre>';
                                              print_r( $conf);
                                              echo '</pre>';*/

                                              $respuestas_array = array(
                                                'rec_id_ecl' => $ecl_id,
                                                'rec_id_pre' => $conf->idPregunta,
                                                'rec_id_opr' => $conf->idRespuesta,
                                                'rec_respuesta' => null,
                                                'rec_fecha_registro' => date('Y-m-d H:i:s'),
                                                'rec_estado' => 1,
                                                'rec_usu_creacion' => $id_usuario,
                                                'rec_fecha_creacion' => date('Y-m-d H:i:s'),
                                                'rec_usu_modificacion' => $id_usuario,
                                                'rec_fecha_modificacion' => date('Y-m-d H:i:s')
                                            );

                                            /*  echo 'respuesta_array<pre>';
                                              print_r( $respuestas_array);
                                              echo '</pre>';*/

                                              $idRespuestaEncuesta = $this->gsatelite->ingresar('rec_respuesta_encuesta', $respuestas_array);

                                              $resp = explode(',', $conf->valor);

                                            /* echo 'resp<pre>';
                                             print_r( count($resp));
                                             echo '</pre>';*/

                                            //Recorremos el array resp para ir almacenando los registros en la bd.
                                             for ($k = 0; $k < count($resp); $k++) {
                                                //Buscamos el idrespuesta en array registroEspecifique
                                                //Recorremos el vector en busca de elementos que coinciden
                                                $txtEspecificacion = NULL;
                                                foreach ($especifiqueActual as $itemEsp) {
                                                    if ($itemEsp->idConfiguracion == $resp[$k]) {
                                                        $txtEspecificacion = $itemEsp->especifique;
                                                    }
                                                }
                                                $opcion_array = array(
                                                    'oxp_id_rec' => $idRespuestaEncuesta,     //id de la encuesta almacenada
                                                    'oxp_id_opr' => $conf->idRespuesta,          //respuestas de la entrevista
                                                    'oxp_id_otd' => $resp[$k],
                                                    'oxp_valor_referencia' => $txtEspecificacion,             // Habilitado para opcion
                                                    'oxp_estado' => 1,
                                                    'oxp_usu_creacion' => $id_usuario,
                                                    'oxp_fecha_creacion' => date('Y-m-d H:i:s'),
                                                    'oxp_usu_modificacion' => $id_usuario,
                                                    'oxp_fecha_modificacion' => date('Y-m-d H:i:s')
                                                );

                                                $this->gsatelite->ingresar('oxp_opcion_respuestaxpregunta', $opcion_array);

                                            }

                                        }

                                    } //Fin de aux = conf
                                    $contE++;
                                } //Fin foreach
                                //  die();

                            }

                        }
                        elseif ($preguntasTipo[$i] == 10) {
                            if (isset($post_array['pregunta_' . $preguntasIds[$i]]) && $post_array['pregunta_' . $preguntasIds[$i]] != '') {
                                $respuestas_array = array(
                                    'rec_id_ecl' => $ecl_id,
                                    'rec_id_pre' => $preguntasIds[$i],
                                    'rec_id_opr' => trim($post_array['pregunta_' . $preguntasIds[$i]]),
                                    'rec_respuesta' => NULL,
                                    'rec_fecha_registro' => date('Y-m-d H:i:s'),
                                    'rec_estado' => 1,
                                    'rec_usu_creacion' => $id_usuario,
                                    'rec_fecha_creacion' => date('Y-m-d H:i:s'),
                                    'rec_usu_modificacion' => $id_usuario,
                                    'rec_fecha_modificacion' => date('Y-m-d H:i:s')
                                );

                                $this->gsatelite->ingresar('rec_respuesta_encuesta', $respuestas_array);
                            }
                        }
                        elseif ($preguntasTipo[$i] == 11 || $preguntasTipo[$i] == 12) {
                           
                            if (isset($_FILES['pregunta_' . $preguntasIds[$i]]['name']) && $_FILES['pregunta_' . $preguntasIds[$i]]['name'] != '') {
                              
                                $config['upload_path']   = 'uploads/encuesta/archivos/'.$ecl_id;
                                //Si la carpeta no existe la creamos
                                if (!file_exists($config['upload_path'])) {
                                    mkdir(FCPATH . $config['upload_path'], 0777);
                                }

                                $config['allowed_types'] = "gif|jpg|jpeg|png|doc|docx|xls|xlsx|mp3|mp4|rar|pdf|ppt|pptx|tar|zip|txt|PNG";
                                $config['max_size'] = "204800";
                                $config['remove_spaces'] = true;
                                if (!is_dir($config['upload_path'])) {
                                    die("El directorio de carga no existe");
                                }
                                $this->load->library('upload', $config);
                                if (!$this->upload->do_upload('pregunta_' . $preguntasIds[$i])) {
                                    $errors = array('error' => $this->upload->display_errors());
                                    die(json_encode($errors));
                                } else {
                                    $info=$this->upload->data();

                                    /*Almacenamos el registro en la base de datos*/
                                    $respuestas_array = array(
                                        'rec_id_ecl' => $ecl_id,
                                        'rec_id_pre' => $preguntasIds[$i],
                                        'rec_id_opr' => NULL,
                                        'rec_respuesta' => $post_array['pregunta_' . $preguntasIds[$i]],
                                        'rec_fecha_registro' => date('Y-m-d H:i:s'),
                                        'rec_estado' => 1,
                                        'rec_usu_creacion' => $id_usuario,
                                        'rec_fecha_creacion' => date('Y-m-d H:i:s'),
                                        'rec_usu_modificacion' => $id_usuario,
                                        'rec_fecha_modificacion' => date('Y-m-d H:i:s')
                                    );
                                    
                                    //$this->gsatelite->ingresar('rec_respuesta_encuesta', $respuestas_array);

                                    $idRespuestaEncuesta = $this->gsatelite->ingresar('rec_respuesta_encuesta', $respuestas_array);

                                    $anexo_array = array(
                                        'anr_id_rec' => $idRespuestaEncuesta,                    //id de la encuesta almacenada
                                        'anr_nombre_archivo' => $info['file_name'],          //respuestas de la entrevista
                                        'anr_ruta_archivo' => $config['upload_path'],             // Habilitado para opcion
                                        'anr_estado' => 1,
                                        'anr_usu_creacion' => $id_usuario,
                                        'anr_fecha_creacion' => date('Y-m-d H:i:s'),
                                        'anr_usu_modificacion' => $id_usuario,
                                        'anr_fecha_modificacion' => date('Y-m-d H:i:s')
                                    );

                                    $idRespuestaEncuesta = $this->gsatelite->ingresar('anr_anexo_respuesta', $anexo_array);
                                    
                                    
                                  //die(json_encode($this->upload->data()));
                                  //  return ['upload_data' => $this->upload->data()];
                                }
                            } else if (isset($_POST['FILE_pregunta_' . $preguntasIds[$i]]) && trim($_POST['FILE_pregunta_' . $preguntasIds[$i]]) !='' && trim($_POST['FILE_pregunta_' . $preguntasIds[$i]]) !='null') {
                                //guardar el string 64 encode.
                                $cod_64 = trim($_POST['FILE_pregunta_' . $preguntasIds[$i]]);
                                $extension_f = trim($_POST['FILE_type_pregunta_' . $preguntasIds[$i]]);
                                $config['upload_path']   = 'uploads/encuesta/archivos/'.$ecl_id;
                                //Si la carpeta no existe la creamos
                                if (!file_exists($config['upload_path'])) {
                                    mkdir(FCPATH . $config['upload_path'], 0777);
                                }

                                //$extension = explode('/', mime_content_type($cod_64))[1];
                                $data_64 = str_replace('[removed]', '', $cod_64);
                                $nombre_arch = 'adjunto_' . $preguntasIds[$i].".".$extension_f;
                                $url_arch = $ruta_archivos."/".$nombre_arch;

                                //Se verifica si no existe la carpeta de archivos para esta entrevista, se crea
                                if (!file_exists($ruta_archivos)) {
                                    mkdir(FCPATH . $ruta_archivos, 0777);
                                }

                                //Se crea el archivo de imagen para escribir el base64
                                $fp = fopen(FCPATH . $url_arch, "w+");

                                //Se escribe la data de la imagen en base64
                                fwrite($fp, base64_decode($data_64));

                                //Se cierra el archivo de imagen
                                fclose($fp);

                                if ($cod_64 != '') {
                                    /*Almacenamos el registro en la base de datos*/
                                    $respuestas_array = array(
                                        'rec_id_ecl' => $ecl_id,
                                        'rec_id_pre' => $preguntasIds[$i],
                                        'rec_id_opr' => NULL,
                                        'rec_respuesta' => $post_array['pregunta_' . $preguntasIds[$i]],
                                        'rec_fecha_registro' => date('Y-m-d H:i:s'),
                                        'rec_estado' => 1,
                                        'rec_usu_creacion' => $id_usuario,
                                        'rec_fecha_creacion' => date('Y-m-d H:i:s'),
                                        'rec_usu_modificacion' => $id_usuario,
                                        'rec_fecha_modificacion' => date('Y-m-d H:i:s')
                                    );
                                    
                                    //$this->gsatelite->ingresar('rec_respuesta_encuesta', $respuestas_array);

                                    $idRespuestaEncuesta = $this->gsatelite->ingresar('rec_respuesta_encuesta', $respuestas_array);

                                    $anexo_array = array(
                                        'anr_id_rec' => $idRespuestaEncuesta,                    //id de la encuesta almacenada
                                        'anr_nombre_archivo' => $nombre_arch,          //respuestas de la entrevista
                                        'anr_ruta_archivo' => $config['upload_path'],             // Habilitado para opcion
                                        'anr_estado' => 1,
                                        'anr_usu_creacion' => $id_usuario,
                                        'anr_fecha_creacion' => date('Y-m-d H:i:s'),
                                        'anr_usu_modificacion' => $id_usuario,
                                        'anr_fecha_modificacion' => date('Y-m-d H:i:s')
                                    );

                                    $idRespuestaEncuesta = $this->gsatelite->ingresar('anr_anexo_respuesta', $anexo_array);
                                }

                            }
                        }
                        elseif($preguntasTipo[$i] == 14){
                            if (isset($post_array['pregunta_' . $preguntasIds[$i]]) && $post_array['pregunta_' . $preguntasIds[$i]] != '') {
                             $coordenada=$post_array['pregunta_' . $preguntasIds[$i]];
                             $geolocalizacion=null;
                             if($coordenada[0]!=null && $coordenada[1]!=null){
                              $geolocalizacion=implode(",", $coordenada);
                              
                              $respuestas_array = array(
                                'rec_id_ecl' => $ecl_id,
                                'rec_id_pre' => $preguntasIds[$i],
                                'rec_id_opr' => NULL,
                                'rec_respuesta' => $geolocalizacion,
                                'rec_fecha_registro' => date('Y-m-d H:i:s'),
                                'rec_estado' => 1,
                                'rec_usu_creacion' => $id_usuario,
                                'rec_fecha_creacion' => date('Y-m-d H:i:s'),
                                'rec_usu_modificacion' => $id_usuario,
                                'rec_fecha_modificacion' => date('Y-m-d H:i:s')
                            );

                              $this->gsatelite->ingresar('rec_respuesta_encuesta', $respuestas_array);
                          }
                      }
                  }
                        elseif($preguntasTipo[$i] == 15){ // Pregunta del Tipo Dibujo
                            if (isset($post_array['pregunta_' . $preguntasIds[$i]]) && $post_array['pregunta_' . $preguntasIds[$i]] != '') {
                                $data_imagen_64 = str_replace('[removed]', '', $post_array['pregunta_' . $preguntasIds[$i]]);
                                $nombre_imagen = 'pregunta_' . $preguntasIds[$i].".png";
                                $url_imagen = $ruta_archivos."/".$nombre_imagen;

                                if ($data_imagen_64 != null) {
                                    var_dump(FCPATH . $ruta_archivos);
                                    //Se verifica si no existe la carpeta de archivos para esta entrevista, se crea
                                    if (!file_exists($ruta_archivos)) {
                                        mkdir(FCPATH . $ruta_archivos, 0777);
                                    }

                                    //Se crea el archivo de imagen para escribir el base64
                                    $fp = fopen(FCPATH . $url_imagen, "w+");

                                    //Se escribe la data de la imagen en base64
                                    fwrite($fp, base64_decode($data_imagen_64));

                                    //Se cierra el archivo de imagen
                                    fclose($fp);
                                }

                                $respuestas_array = array(
                                    'rec_id_ecl' => $ecl_id,
                                    'rec_id_pre' => $preguntasIds[$i],
                                    'rec_id_opr' => NULL,
                                    'rec_respuesta' => $url_imagen,
                                    'rec_fecha_registro' => date('Y-m-d H:i:s'),
                                    'rec_estado' => 1,
                                    'rec_usu_creacion' => $id_usuario,
                                    'rec_fecha_creacion' => date('Y-m-d H:i:s'),
                                    'rec_usu_modificacion' => $id_usuario,
                                    'rec_fecha_modificacion' => date('Y-m-d H:i:s')
                                );

                                $this->gsatelite->ingresar('rec_respuesta_encuesta', $respuestas_array);
                            }
                        }
                        elseif($preguntasTipo[$i] == 16) { //Pregunta Tabla Indexada
                            //Se verifica que hayan filas de la tabla indexada
                            if(isset($post_array['pregunta_fila_'.$preguntasIds[$i]])){
                                $filas = $post_array['pregunta_fila_'.$preguntasIds[$i]];
                                $opr_pregunta = $this->gsatelite->get_tabla('opr_opcion_respuesta', array('opr_id_pre'=>$preguntasIds[$i]));
                                // depurar($opr_pregunta);
                                // for($k = 0; $k < count($filas); $k++){
                                //     foreach()
                                // }

                                            // depurar($post_array);
                                for($j = 0; $j < count($filas); $j++){
                                    foreach($opr_pregunta as $opr){
                                            // depurar_json($opr['opr_id']);
                                        if ($opr['opr_tipo_campo_dinamico'] == 1 || ($opr['opr_tipo_campo_dinamico'] > 3 && $opr['opr_tipo_campo_dinamico'] <= 8)) {
                                            if($opr['opr_tipo_campo_dinamico'] == 4){
                                                $respuesta = $post_array['respuesta_'.$opr['opr_id'].'_'.($j+1)];
                                                // depurar($respuesta);
                                            }else{
                                                $respuesta = $post_array['respuesta_'.$opr['opr_id']][$j];
                                            }

                                            $respuestas_array = array(
                                                'rec_id_ecl' => $ecl_id,
                                                'rec_id_pre' => $preguntasIds[$i],
                                                'rec_id_opr' => $opr['opr_id'],
                                                'rec_num_fila' => $filas[$j],
                                                'rec_respuesta' => $respuesta,
                                                'rec_fecha_registro' => date('Y-m-d H:i:s'),
                                                'rec_estado' => 1,
                                                'rec_usu_creacion' => $id_usuario,
                                                'rec_fecha_creacion' => date('Y-m-d H:i:s'),
                                                'rec_usu_modificacion' => $id_usuario,
                                                'rec_fecha_modificacion' => date('Y-m-d H:i:s')
                                            );
                                            // depurar($respuestas_array);
                                            $idRespuestaEncuesta = $this->gsatelite->ingresar('rec_respuesta_encuesta', $respuestas_array);
                                        }
                                        elseif ($opr['opr_tipo_campo_dinamico'] == 2) {

                                            $respuestas_array = array(
                                                'rec_id_ecl' => $ecl_id,
                                                'rec_id_pre' => $preguntasIds[$i],
                                                'rec_id_opr' => $opr['opr_id'],
                                                'rec_num_fila' => $filas[$j],
                                                'rec_respuesta' => '',
                                                'rec_fecha_registro' => date('Y-m-d H:i:s'),
                                                'rec_estado' => 1,
                                                'rec_usu_creacion' => $id_usuario,
                                                'rec_fecha_creacion' => date('Y-m-d H:i:s'),
                                                'rec_usu_modificacion' => $id_usuario,
                                                'rec_fecha_modificacion' => date('Y-m-d H:i:s')
                                            );

                                            $idRespuestaEncuesta = $this->gsatelite->ingresar('rec_respuesta_encuesta', $respuestas_array);



                                            //Almacenamos el respuesta en la tabla de opciones x preguntas
                                            $opcion_array = array(
                                                'oxp_id_rec' => $idRespuestaEncuesta,                    //id de la encuesta almacenada
                                                'oxp_id_opr' => $opr['opr_id'], //respuestas de la entrevista
                                                'oxp_id_otd' => ($post_array['respuesta_'.$opr['opr_id']][$j]>0)? $post_array['respuesta_'.$opr['opr_id']][$j]:null,
                                                'oxp_valor_referencia' => "", // Habilitado para opcion
                                                'oxp_estado' => 1,
                                                'oxp_usu_creacion' => $id_usuario,
                                                'oxp_fecha_creacion' => date('Y-m-d H:i:s'),
                                                'oxp_usu_modificacion' => $id_usuario,
                                                'oxp_fecha_modificacion' => date('Y-m-d H:i:s')
                                            );

                                            $this->gsatelite->ingresar('oxp_opcion_respuestaxpregunta', $opcion_array);
                                        }
                                    }
                                }
                            }
                        }
                    } //fin del foreach de todas las preguntas

                    //al final actualizar la nota de la encuesta.
                    $this->encuesta_model->update_nota_encuesta($ecl_id);
                }
            }


            // Procesar ticket con encuesta
            if ($post_array['idTicket'] != 0) {
                $actualizarTicket = [
                    'tkh_id_ecl' => $ecl_id,
                    'tkh_usu_modificacion' => $id_usuario,
                    'tkh_fecha_modificacion' => date('Y-m-d H:i:s')
                ];
                $updateTkh = $this->gsatelite->actualizar_array('tkh_ticket_helpdesk', $actualizarTicket, ['tkh_id' => $post_array['idTicket']]);

                // Consulta estado que finaliza el ticket
                // Finalizar ticket
                $estadoFinaliza = $this->gsatelite->get_tabla('esk_estado_ticket', ['esk_finalizacion' => 1]);
                if (!empty($estadoFinaliza)) {
                    $seguimiento_inactivar_array = array(
                        'sgk_estado' => 0,
                        'sgk_fecha_modificacion' => date('Y-m-d H:i:s'),
                        'sgk_usu_modificacion' => $this->tank_auth->get_user_id(),
                    );

                    $this->gsatelite->actualizar_array('sgk_seguimiento_ticket', $seguimiento_inactivar_array,array('sgk_id_tkh' => $post_array['idTicket']));

                    $seguimiento_tkh_array = array(
                        'sgk_id_tkh' => $post_array['idTicket'],
                        'sgk_id_esk' => $estadoFinaliza[0]['esk_id'],
                        'sgk_fecha' => date('Y-m-d H:i:s'),
                        'sgk_estado' => 1,
                        'sgk_usu_creacion' => $this->tank_auth->get_user_id(),
                        'sgk_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'sgk_fecha_creacion' => date('Y-m-d H:i:s'),
                        'sgk_fecha_modificacion' => date('Y-m-d H:i:s'),
                    );

                    $id_seg_tkh = $this->gsatelite->ingresar('sgk_seguimiento_ticket', $seguimiento_tkh_array);
                    $this->desarrollo_model->actualizar_etapa_ticket($id_seg_tkh);


                    // Consultar incidencia para actualizar estado
                    // Consultar estado relacionado con el fin de la incidencia / ticket
                    $incidencia = $this->gsatelite->get_tabla('inc_incidencia', ['inc_id_tkh' => $post_array['idTicket']]);
                    $idEstadoIncidencia = $this->gsatelite->get_tabla('etr_etapa_entregable', ['etr_id_esk' => $estadoFinaliza[0]['esk_id']]);

                    if (count($incidencia) > 0  && count($idEstadoIncidencia) > 0) {
                        $seguimiento_array = array(
                            'sgi_id_inc' => $incidencia[0]['inc_id'],
                            'sgi_id_etr' => $idEstadoIncidencia[0]['etr_id'],
                            'sgi_fecha' => date('Y-m-d H:i:s'),
                            'sgi_estado' => 1,
                            'sgi_usu_creacion' => $this->tank_auth->get_user_id(),
                            'sgi_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'sgi_fecha_creacion' => date('Y-m-d H:i:s'),
                            'sgi_fecha_modificacion' => date('Y-m-d H:i:s'),
                        );

                        $idSeguimientoInc = $this->gsatelite->ingresar('sgi_seguimiento_inc', $seguimiento_array);
                        $this->desarrollo_model->actualizar_etapa_inc($idSeguimientoInc);
                    }
                }

                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Encuesta", 'texto_alerta' => "Encuesta realizada con exito");
                $this->session->set_flashdata($alerta);

                
            }


            //print_r("finalizo UwU");die();
            $redireccion = 0;
            if (isset($post_array["txtKey"])) {
                $datos_key = $this->ejecutarLinkEncuesta(true, $post_array["txtKey"]);
                $redireccion = (trim($datos_key["registro"]["lke_link_redireccion"]) != '') ? trim($datos_key["registro"]["lke_link_redireccion"]) : base_url($datos_key["registro"]["lke_url_link"]);
                
                if (parse_url($redireccion, PHP_URL_SCHEME) == null) {
                    $redireccion = "http://".$redireccion."/";
                }

                if ($datos_key["registro"]["lke_ejecucion_unica"] == 1) //sessión unica
                {
                    $this->session->set_userdata('encuesta_finalizada', $post_array["txtKey"]);
                }
                $data = $datos_key;
                $data['redireccion'] = $redireccion;
                //print_r($redireccion);die();
                $this->session->set_flashdata('data', $data);
                $redireccion = 1;
                //redirect('/encuesta/procesos/encuestaFinalizada');
                //die();
                // $this->load->view('encuesta/procesos/ejecutar_LinkEncuesta_finalizada',$data);
                // $this->gsatelite->cargar_vista_masterpage("encuesta/procesos/ejecutarLinkEncuesta_finalizada",$data);
            }
            ob_end_clean();
            echo json_encode(array('error' => 0, 'redireccion' => $redireccion));
        }
    } //Fin de funcion guardarEncuesta


    public function preferencia($id_usuario)
    {
        $this->db->join("suc_sucursal", 'suc_id=uxs_id_suc');
        $this->db->order_by('uxs_id_exs_defecto', 'ASC');
        $sucursales = $this->gsatelite->get_tabla('uxs_usuarioxsucursal', array('uxs_id_usu' => $id_usuario));
        $data['registro_sucursal'] = $sucursales;
        $data['usuario'] = $this->gsatelite->get_tabla('usu_usuario', array('usu_id' => $id_usuario));
        $this->load->view('encuesta/procesos/ver_detalle_preferencia', $data);
    }

    public function actualizar_preferencia_encuesta($id_usuario)
    {
        $usu = $this->tank_auth->get_user_id();
        $exito = 0;
        if ($this->input->post()) {
            $id_encuesta_defecto = $this->input->post('encuesta_sucursal');
            $id_usuario_sucursal = $this->input->post('usuxsucursal');
            $id_usuario_general = $this->input->post('usuario_general');
            $update = array('uxs_id_exs_defecto' => null, 'uxs_usu_modificacion' => $id_usuario, 'uxs_fecha_modificacion' => date("Y-m-d H:i:s"));
            $where = array("uxs_id_usu" => $id_usuario_general);
            $this->gsatelite->actualizar_array('uxs_usuarioxsucursal', $update, $where);

            $update = array('uxs_id_exs_defecto' => $id_encuesta_defecto, 'uxs_usu_modificacion' => $id_usuario, 'uxs_fecha_modificacion' => date("Y-m-d H:i:s"));
            $where = array("uxs_id" => $id_usuario_sucursal);
            $this->gsatelite->actualizar_array('uxs_usuarioxsucursal', $update, $where);
            $exito = 1;
        }

        die(json_encode(array("exito" => $exito)));
    }

    public function link_encuesta_agenciaBK($id_encuesta_sucursal = '0')
    {
        satelite_validar();
        //$data["id_exs"] = $id_encuesta_sucursal;
        //$this->load->view('encuesta/procesos/link_encuesta_agencia', $data);
        //$this->gsatelite->cargar_vista_masterpage("encuesta/procesos/link_encuesta_agencia",$data);
    }

    /**
     * @return Mantenimiento de Links Encuestas por Sucursal
     * @author Rene Castaneda
     */
    public function link_encuesta_agencia($id_encuesta_sucursal = 0)
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            try {
                if (!is_numeric($id_encuesta_sucursal)) {
                    redirect('');
                }
                $this->db->join('enc_encuesta', 'enc_id=exs_id_enc');
                $this->db->join('suc_sucursal', 'suc_id=exs_id_suc');
                $data['registro'] = $this->gsatelite->get_tabla('exs_encuestaxsucursal', array('exs_id' => $id_encuesta_sucursal));
                $crud = new grocery_CRUD();
                $crud->set_table('lke_link_encuesta')
                ->set_subject('Link')
                ->where('lke_id_exs', $id_encuesta_sucursal)
                ->columns('lke_id_usu', 'lke_url_link', 'lke_fecha_inicio', 'lke_fecha_fin', 'lke_mensaje', 'lke_estado')
                ->display_as('lke_url_link', 'Link')
                ->display_as('lke_id_usu', 'Usuario Genera')
                ->display_as('lke_mensaje', 'Msj Inicio')
                ->display_as('lke_mensaje_fin', 'Msj Fin')
                ->display_as('lke_fecha_inicio', 'Inicio vigencia')
                ->display_as('lke_fecha_fin', 'Fin vigencia')
                ->display_as('lke_ejecucion_unica', 'Ejecución Unica')
                ->display_as('lke_link_redireccion', 'Redirección')
                ->display_as('lke_estado', 'Estado')
                ->add_fields('lke_id_usu',
                    'lke_id_exs',
                    'lke_url_link',
                    'lke_mensaje',
                    'lke_mensaje_fin',
                    'lke_fecha_inicio',
                    'lke_fecha_fin',
                    'lke_ejecucion_unica',
                    'lke_link_redireccion',
                    'lke_estado',
                    'lke_usu_creacion',
                    'lke_usu_modificacion',
                    'lke_fecha_creacion',
                    'lke_fecha_modificacion')
                ->edit_fields('lke_id_exs',
                    'lke_url_link',
                    'lke_mensaje',
                    'lke_mensaje_fin',
                    'lke_fecha_inicio',
                    'lke_fecha_fin',
                    'lke_ejecucion_unica',
                    'lke_link_redireccion',
                    'lke_estado',
                    'lke_usu_modificacion',
                    'lke_fecha_modificacion')
                ->required_fields('lke_fecha_inicio', 'lke_fecha_fin', 'lke_ejecucion_unica', 'lke_estado')
                ->field_type('lke_id_exs', 'hidden', $id_encuesta_sucursal)
                ->field_type('lke_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('lke_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('lke_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
                ->field_type('lke_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
                ->field_type('lke_url_link', 'hidden', '');
                if ($crud->getState() == "add" || $crud->getState() == "edit") {
                    $crud->field_type('lke_id_usu', 'hidden', $this->tank_auth->get_user_id());
                } else {
                    $crud->set_relation('lke_id_usu', 'usu_usuario', '{usu_nombre_usuario}');
                }
                $crud->callback_column('lke_mensaje', function ($value, $row) {
                    return $value;
                });
                $crud->callback_column('lke_fecha_inicio', function ($value, $row) {
                    return ($value) ? formatear_fecha("d-m-Y", $value) : '';
                });
                $crud->callback_column('lke_fecha_fin', function ($value, $row) {
                    return ($value) ? formatear_fecha("d-m-Y", $value) : '';
                });
                $crud->callback_column('lke_url_link', function ($value, $row) {
                    return '<a  target="_blank" class="tip" title="copiar: click derecho copiar dirección" href="' . base_url($value) . '">Link Encuesta</a>';
                });

                $uri_segments = explode('/', uri_string());
                if (end($uri_segments) == 'add') {
                    $crud->field_type('lke_estado', 'hidden', 1);
                } else {
                    $crud->field_type('lke_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
                }
                $crud->field_type('lke_ejecucion_unica', 'dropdown', array('1' => 'Sí', '0' => 'No'));
                $crud->callback_after_insert(function ($post, $primary_key) {
                    $unico = time() . "lk:(" . $primary_key;
                    $link = 'encuesta/procesos/ejecutarLinkEncuesta/?key=' . base64_encode($unico);
                    $this->gsatelite->actualizar_array("lke_link_encuesta", array('lke_url_link' => $link), array('lke_id' => $primary_key));
                    return true;
                });

                $data['titulo_personal'] = "Link Encuesta";
                $crud->unset_print()->unset_export()->unset_delete();
                // Validaciones
                $crud->add_action('Ver', 'minia-icon-search', "encuesta/procesos/lectura_pregunta/$id_encuesta_sucursal/read");

                $output = $crud->render();
                $this->gsatelite->cargar_vista_masterpage("encuesta/procesos/link_encuesta_agencia", $data, $output);
                //cargarvista($data, $output);
            } catch (Exception $e) {
                show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
            }
        }
    }

    /**
     * @return Enlace de respuesa
     * @author Rene Castaneda
     */
    public function ejecutarLinkEncuesta($validar = false, $key = "")
    {
        $ejecucion_unica = trim($this->session->userdata('encuesta_finalizada'));
        $data["key"] = "";
        $data["ejecucion_unica"] = 0;
        $data["estado_link"] = "3"; //link vacio, no existente
        $keyEncuesta = (trim($this->input->get("key")) != '') ? trim($this->input->get("key")) : $key;
        if (trim($keyEncuesta) != '') {
            $data["key"] = $keyEncuesta;
            $data["ejecucion_unica"] = ($ejecucion_unica == $data["key"]) ? 1 : 0;
            $data["sesion_web"] = $keyEncuesta . "__" . date("dmY_H_i_s");
            $datos = base64_decode($keyEncuesta);
            $datos_array = explode("lk:(", $datos);
            if (isset($datos_array[1]) && is_numeric($datos_array[1])) {
                $q = $this->gsatelite->get_tabla("lke_link_encuesta", array('lke_id' => $datos_array[1]));
                if ($q) {
                    if ($q[0]['lke_estado']) {
                        $fecha_actual = date("Ymd");
                        $fecha_inicio = formatear_fecha("Ymd", $q[0]['lke_fecha_inicio']);
                        $fecha_fin = formatear_fecha("Ymd", $q[0]['lke_fecha_fin']);
                        if ($fecha_actual >= $fecha_inicio && $fecha_actual <= $fecha_fin) {
                            $this->db->join("exs_encuestaxsucursal", "exs_id=lke_id_exs");
                            $this->db->join("enc_encuesta", "enc_id=exs_id_enc");
                            $this->db->join("suc_sucursal", "suc_id=exs_id_suc");
                            $qDatos = $this->gsatelite->get_tabla("lke_link_encuesta", array('lke_id' => $datos_array[1]));
                            $data["registro"] = $qDatos[0];
                            $data["estado_link"] = ($data["ejecucion_unica"] == 1) ? "7" : "1"; //valido, vigente
                        } else {
                            $data["estado_link"] = "6"; //Link vencido (fuera de tiempo)
                        }

                    } else {
                        $data["estado_link"] = "5"; //Registro Inactivo
                    }
                } else {
                    $data["estado_link"] = "4"; //Registro no existe, elminado
                }
            } else {
                $data["estado_link"] = "2"; //truncado, inconsistente
            }
        } else {
            $data["estado_link"] = "3"; //link vacio, no existente
        }

        if ($validar) {
            return $data;
        } else {
            //print_r($data); die();
            $this->gsatelite->cargar_vista_masterpage("encuesta/procesos/ejecutarLinkEncuesta", $data);
        }
    }


    /**
     * @author Manuel Hernandez
     */
    public function consultar_encuesta() {
        $data['titulo_personal'] = "Consultar Encuesta Contestadas";
        $permisos = $this->gsatelite->get_permisos_opcion('consultar_encuesta');
        //$data['sucursal'] = $this->gsatelite->get_dropdown('suc_sucursal', '{suc_nombre}', '', array('suc_estado' => '1'), null, '', 'suc_id', true);
        $data['permisos'] = $permisos;
        /* $data['sucursal']= $this->gsatelite->get_tabla('suc_sucursal');
        $data['sucursal'] = $this->encuesta_model->select_consultar_encuestas(array('usu_id'=>$this->tank_auth->get_user_id())); 
        */
        $param = explode(',', $this->gsatelite->get_parametro('SYS_ID_ROL_ADMINISTRADOR'));
        $rol = $this->gsatelite->get_tabla('uxr_usuarioxrol', array('uxr_id_usu' => $this->tank_auth->get_user_id()));
        $busqueda = array_search($rol[0]['uxr_id_rol'], $param, false);
        if (!is_bool($busqueda)) {
            $data['sucursal'] = $this->gsatelite->get_tabla('suc_sucursal');
        } else {
            // $where = array('uxs_id_usu' => $this->tank_auth->get_user_id());
            $where = array('usc_id_usu' => $this->tank_auth->get_user_id());

            $data['sucursal'] = $this->encuesta_model->get_sucursalesxusuario($where);
        }
        cargarvista($data);
    }

    /**
     * @author Raul E
     */
    public function exportar_encuesta() {
        $data['titulo_personal'] = "Exportar Encuesta Contestada";
        $permisos = $this->gsatelite->get_permisos_opcion('exportar_encuesta');
        $data['permisos'] = $permisos;
        $param = explode(',', $this->gsatelite->get_parametro('SYS_ID_ROL_ADMINISTRADOR'));
        $rol = $this->gsatelite->get_tabla('uxr_usuarioxrol', array('uxr_id_usu' => $this->tank_auth->get_user_id()));
        $busqueda = array_search($rol[0]['uxr_id_rol'], $param, false);
        if (!is_bool($busqueda)) {
            $data['sucursal'] = $this->gsatelite->get_tabla('suc_sucursal');
        } else {
            $where = array('usc_id_usu' => $this->tank_auth->get_user_id());
            $data['sucursal'] = $this->encuesta_model->get_sucursalesxusuario($where);
        }
        cargarvista($data);
    }

    /**
     * @author Manuel Hernandez
     */
    public function filtrar_consultar_encuesta($es_reporte = 0)
    {
        $txtFecha_desde = $this->input->post('txtFecha_desde');
        $txtFecha_hasta = $this->input->post('txtFecha_hasta');
        $slcAgencia = $this->input->post('slcAgencia');
        $slcEncuesta = $this->input->post('slcEncuesta');
        $where_in = null;

        if ($txtFecha_desde != '' and $txtFecha_hasta != '') {
            $where['date_format(ecl_fecha,"%Y-%m-%d") >='] = date('Y-m-d', strtotime($txtFecha_desde));
            $where['date_format(ecl_fecha,"%Y-%m-%d") <='] = date('Y-m-d', strtotime($txtFecha_hasta));
        }

        if ($slcAgencia == null) {
            $param = explode(',', $this->gsatelite->get_parametro('SYS_ID_ROL_ADMINISTRADOR'));

            $rol = $this->gsatelite->get_tabla('uxr_usuarioxrol', array('uxr_id_usu' => $this->tank_auth->get_user_id()));
            $busqueda = array_search($rol[0]['uxr_id_rol'], $param, false);

            if (!is_bool($busqueda)) {
                $data['sucursal'] = $this->gsatelite->get_tabla('suc_sucursal');
                //$data['sucursal'] = $this->encuesta_model->get_sucursalesxusuario();
            } else {
                $where1 = array('usc_id_usu' => $this->tank_auth->get_user_id());
                $data['sucursal'] = $this->encuesta_model->get_sucursalesxusuario($where1, '*');
                $where_in = $data['sucursal'][0]['id_agencias'];
                $where['ecl_id_usu'] = $this->tank_auth->get_user_id();
            }
        } else {
            $param = explode(',', $this->gsatelite->get_parametro('SYS_ID_ROL_ADMINISTRADOR'));
            $rol = $this->gsatelite->get_tabla('uxr_usuarioxrol', array('uxr_id_usu' => $this->tank_auth->get_user_id()));
            $busqueda = array_search($rol[0]['uxr_id_rol'], $param, false);
            if (!is_bool($busqueda)) {
                $where['exs_id_suc'] = $slcAgencia;
            } else {
                $where['exs_id_suc'] = $slcAgencia;
                $where['ecl_id_usu'] = $this->tank_auth->get_user_id();
            }


        }

        if ($this->input->post('slcEncuesta')) {
            $where['exs_id_enc'] = $slcEncuesta;
        }

        $registros = $this->encuesta_model->consultar_encuesta("ecl_id, ecl_fecha, username as usuario, enc_nombre, enc_tipo, enc_calificacion_maxima, IF(enc_tipo = 1, 
            IFNULL(ecl_nota_encuesta, 
            (SELECT SUM((IFNULL(pre_calificacion_maxima,0) * (IFNULL(opr_puntuacion,0)/100))) FROM opr_opcion_respuesta 
            JOIN pre_pregunta ON pre_id = opr_id_pre
            JOIN rec_respuesta_encuesta ON rec_id_opr = opr_id
            WHERE rec_id_ecl = ecl_id
        )),0) calificacion",
        'ecl_fecha', $where, 'ecl_id', $where_in);
        //print_r($this->db->last_query());die();
        $data['registros'] = $registros;
        $data['cantidad_registros'] = ($registros) ? " ( Se encontraron " . count($registros) . " Encuestas)" : '';
        $data['es_reporte'] = $es_reporte;

        $data['txtFecha_desde'] = $this->input->post('txtFecha_desde');
        $data['txtFecha_hasta'] = $this->input->post('txtFecha_hasta');
        $data['slcAgencia'] = $this->input->post('slcAgencia');
        $data['slcEncuesta'] = $this->input->post('slcEncuesta');
        $data['periodo'] = date('d-m-Y', strtotime($txtFecha_desde)) . ' / ' . date('d-m-Y', strtotime($txtFecha_desde));

        $html = $this->load->view('encuesta/procesos/filtrar_consultar_encuesta', $data, true);

        if ($es_reporte == 1) {
            //echo $html; die();
            $reg_encuesta = $this->gsatelite->get_registro('enc_encuesta', 'enc_id', $this->input->post('slcEncuesta'));
            $filtro_titulo = $txtFecha_desde . " / " . $txtFecha_hasta . " <br /> / " . $data['cantidad_registros'];
            $reg_sucursal = $this->gsatelite->get_registro('suc_sucursal', 'suc_id', $this->input->post('slcAgencia'));
            $data['nombre_sucursal'] = ($this->input->post('slcAgencia') > 0) ? $reg_sucursal->suc_nombre : "Todas";
            $data['reg_encuesta'] = $reg_encuesta;
            if ($this->input->post()) {
                $nombre_fichero = "consulta_encuesta_contestada_" . date('d-m-Y_His') . "_.csv";
                $fp = fopen("uploads/encuesta_temp/csv_enviados/$nombre_fichero", 'w');
                $i = 0;
                foreach ($registros as $campos) {
                    unset($campos['ecl_id']);
                    $campos['ecl_fecha'] = date('d-m-Y H:i:s', strtotime($campos['ecl_fecha'])); //formatear la fecha.

                    $campos = array_map('utf8_decode', $campos);
                    //print_r($campos); die();
                    $i++;
                    if ($i == 1) {
                        $titulos = array('#', 'USUARIO', 'ENCUESTA', 'FECHA/HORA');
                        fputcsv($fp, array_merge($titulos));
                    }
                    fputcsv($fp, array_merge(array($i), $campos));
                }
                fclose($fp);
                if ($this->input->post('tipo_accion') == 1) {
                    //redirect("uploads/portal_inventario_temp/csv_enviados/$nombre_fichero");
                    if (file_exists("uploads/portal_inventario_temp/csv_enviados/$nombre_fichero")) {
                        unlink("uploads/portal_inventario_temp/csv_enviados/$nombre_fichero");
                    }
                    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                    header("Content-Disposition: attachment;filename=consulta_encuesta_cliente_" . date('d-m-Y_His') . ".xls");
                    header("Pragma: no-cache");
                    header("Expires: 0");
                    echo '<meta charset="utf-8" />';
                    echo "<table border='1'>
                    <tr><th colspan='5' align='center' >" . mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8') . "</th></tr>
                    <tr><th colspan='5' align='center' >Reporte de Encuestas Contestadas - Agencia</th></tr>
                    <tr><th colspan='5' align='center' >" . $data['nombre_sucursal'] . " - " . $filtro_titulo . "</th></tr>
                    </table>";
                    echo $html;
                    die();
                }
                if (file_exists("uploads/encuesta_temp/csv_enviados/$nombre_fichero")) {
                    unlink("uploads/encuesta_temp/csv_enviados/$nombre_fichero");
                }

                redirect('encuesta/reportes/consulta_encuesta_cliente');
            }
            redirect('encuesta/reportes/consulta_encuesta_cliente');
        } else {
            die(json_encode(array('html' => $html)));
        }

    }

    /**
     * @author Manuel Hernández
     */
    public function respuesta_encuesta($ecl_id = 0)
    {
        if ($ecl_id != null) {

            //Obteniendo el id de la encuesta
            $where['ecl_id'] = $ecl_id;
            $idEncuesta = $this->encuesta_model->consultar_encuesta("exs_id_enc", '', $where, '');

            //Obteniendo las preguntas de la encuesta
            $where = array('pre_id_enc' => $idEncuesta[0]['exs_id_enc']);
            $this->db->order_by('pre_orden ASC');
            $preguntas = $this->gsatelite->get_tabla('pre_pregunta', $where);
            $data['preguntas'] = $preguntas;

            //Obteniendo el nombre de la encuesta
            $where = array('enc_id' => $idEncuesta[0]['exs_id_enc']);
            $encuesta = $this->gsatelite->get_tabla('enc_encuesta', $where);
            $nombreEncuesta = $encuesta[0]['enc_nombre'];

            $idEncuesta = $ecl_id;
            $data['idEncuesta'] = $ecl_id;


            $detallePreguntas = array();
            //Array de Tipos de pregunta con respuesta unica Ej. Texto, Numero, Dibujo, Etc.
            $lista_respuesta_unica = array(1, 4,5,6,7,8, 11, 12, 14,15);

            //recorro el array de las preguntas para armar un nuevo array con todas las preguntas, respuestas y configuracionesF.
            foreach ($preguntas as $row) {
                $aux = array();
                //if ($row['pre_tipo'] == 1 || ($row['pre_tipo'] > 3 && $row['pre_tipo'] < 9) || ($row['pre_tipo'] >= 11 && $row['pre_tipo'] <= 12 || $row['pre_tipo'] == 14)  ) { //Preguntas de texto
                if(in_array($row['pre_tipo'], $lista_respuesta_unica)){
                    $aux = array(
                        'pre_id' => $row['pre_id'],
                        'nombre' => $row['pre_nombre'],
                        'tipo' => $row['pre_tipo'],
                        'requerida' => $row['pre_requerida'],
                        'required' => ($row['pre_requerida'])? 'required':'',
                        'respuestas_cliente' => null
                    );
                } elseif ($row['pre_tipo'] == 2 || $row['pre_tipo'] == 3) { //Seleccion multiple o lista desplegable
                    $aux = array(
                        'pre_id' => $row['pre_id'],
                        'nombre' => $row['pre_nombre'],
                        'tipo' => $row['pre_tipo'],
                        'requerida' => $row['pre_requerida'],
                        'required' => ($row['pre_requerida'])? 'required':'',
                        'respuesta' => [],
                        'respuestas_cliente' => [],
                        'pre_calificacion_maxima' => $row['pre_calificacion_maxima']
                    );

                    // Consulto las respuestas de estas preguntas
                    $where = array('opr_id_pre' => $row['pre_id']);
                    $respuestas = $this->gsatelite->get_tabla('opr_opcion_respuesta', $where);


                    //Recorremos vector de respuestas
                    foreach ($respuestas as $row1) {
                        $aux1 = null;
                        $aux1['opr_id'] = $row1['opr_id'];
                        $aux1['opr_nombre'] = $row1['opr_nombre'];
                        $aux1['opr_url'] = (trim($row1['opr_url']) != '' && file_exists('uploads/anx_opcion_respuesta/'.$row1['opr_url']))? base_url('uploads/anx_opcion_respuesta/'.$row1['opr_url']):'';
                        $aux1['opr_url_check'] = ($aux1['opr_url'] != '')? 1:0;
                        $aux1['opr_aplica_especifique'] = $row1['opr_aplica_especifique'];
                        $aux1['opr_puntuacion'] = $row1['opr_puntuacion'];
                        $aux1['opr_finalizar_encuesta'] = $row1['opr_finalizar_encuesta'];
                        $aux1['opr_id_pre_salto'] = ($row1['opr_id_pre_salto'] != null) ? $row1['opr_id_pre_salto'] : 0;
                        $aux1['opr_orden_salto'] = ($row1['opr_id_pre_salto'] != null) ? $row1['pre_orden'] : 0;
                        array_push($aux['respuesta'], $aux1);
                    }


                } elseif ($row['pre_tipo'] == 10) {
                    $aux = array(
                        'pre_id' => $row['pre_id'],
                        'nombre' => $row['pre_nombre'],
                        'tipo' => $row['pre_tipo'],
                        'requerida' => $row['pre_requerida'],
                        'required' => ($row['pre_requerida'])? 'required':'',
                        'respuesta' => [],
                        'respuestas_cliente' => [],
                    );
                    $respuestas = $this->encuesta_model->opcion_respuesta(array('opr_id_pre' => $row['pre_id']));

                    //Recorremos vector de respuestas
                    foreach ($respuestas as $row1) {
                        $aux1 = null;
                        $aux1['opr_id'] = $row1['opr_id'];
                        $aux1['opr_id_ico'] = $row1['opr_id_ico'];
                        $aux1['opr_notificacion_correo'] = $row1['opr_notificacion_correo'];
                        $aux1['opr_nombre'] = $row1['opr_nombre'];
                        $aux1['ico_nombre'] = $row1['ico_nombre'];
                        $aux1['ico_url'] = $row1['ico_url'];
                        array_push($aux['respuesta'], $aux1);
                    }

                }
                elseif ($row['pre_tipo'] == 9) {
                    $aux = array(
                        'pre_id' => $row['pre_id'],
                        'nombre' => $row['pre_nombre'],
                        'tipo' => $row['pre_tipo'],
                        'requerida' => $row['pre_requerida'],
                        'required' => ($row['pre_requerida'])? 'required':'',
                        'respuesta' => [],
                        'respuestas_cliente' => [],
                    );

                    // Consulto las respuestas de estas preguntas
                    $where = array('opr_id_pre' => $row['pre_id']);
                    $respuestas = $this->gsatelite->get_tabla('opr_opcion_respuesta', $where);

                    //Recorremos vector de respuestas
                    foreach ($respuestas as $row1) {
                        $aux1 = null;
                        $aux1['opr_id'] = $row1['opr_id'];
                        $aux1['opr_id_pre'] = $row1['opr_id_pre'];
                        $aux1['opr_nombre'] = $row1['opr_nombre'];
                        $aux1['opr_aplica_especifique'] = $row1['opr_aplica_especifique'];
                        $aux1['opr_tipo_campo_dinamico'] = $row1['opr_tipo_campo_dinamico'];
                        $aux1['configuraciones'] = [];

                        if ($row1['opr_tipo_campo_dinamico'] == 2 || $row1['opr_tipo_campo_dinamico'] == 3) {
                            $where = array('otd_id_opr' => $row1['opr_id']);
                            $configuraciones = $this->gsatelite->get_tabla('otd_opcion_tabla_dinamica', $where);

                            //Recorremos las configuraciones

                            foreach ($configuraciones as $row2) {
                                $aux2 = null;
                                $aux2['otd_id'] = $row2['otd_id'];
                                $aux2['otd_nombre'] = $row2['otd_nombre'];
                                $aux2['otd_aplica_especifique'] = $row2['otd_aplica_especifique'];
                                array_push($aux1['configuraciones'], $aux2);
                            }
                        }
                        array_push($aux['respuesta'], $aux1);
                    }

                }
                if($row['pre_tipo'] == 16){
                    $aux = array(
                        'pre_id' => $row['pre_id'],
                        'nombre' => $row['pre_nombre'],
                        'tipo' => $row['pre_tipo'],
                        'orden' => $row['pre_orden'],
                        'requerida' => $row['pre_requerida'],
                        'required' => ($row['pre_requerida'])? 'required':'',
                        'respuestas_cliente' => [],
                        'respuesta' => []
                    );

                    // Consulto las respuestas de estas preguntas
                    $where = array('opr_id_pre' => $row['pre_id'], 'opr_estado' => 1);
                    $respuestas = $this->gsatelite->get_tabla('opr_opcion_respuesta', $where);

                    //Recorremos vector de respuestas
                    foreach ($respuestas as $row1) {
                        $aux1 = null;
                        $aux1['opr_id'] = $row1['opr_id'];
                        $aux1['opr_id_pre'] = $row1['opr_id_pre'];
                        $aux1['opr_nombre'] = $row1['opr_nombre'];
                        $aux1['opr_aplica_especifique'] = $row1['opr_aplica_especifique'];
                        $aux1['opr_finalizar_encuesta'] = $row1['opr_finalizar_encuesta'];
                        $aux1['opr_tipo_campo_dinamico'] = $row1['opr_tipo_campo_dinamico'];
                        $aux1['opr_opcion_seleccionada'] = $row1['opr_opcion_seleccionada'];
                        $aux1['configuraciones'] = [];

                        if ($row1['opr_tipo_campo_dinamico'] == 2 || $row1['opr_tipo_campo_dinamico'] == 3) {
                            $where = array('otd_id_opr' => $row1['opr_id']);
                            $configuraciones = $this->gsatelite->get_tabla('otd_opcion_tabla_dinamica', $where);

                            //Recorremos las configuraciones

                            foreach ($configuraciones as $row2) {
                                $aux2 = null;
                                $aux2['otd_id'] = $row2['otd_id'];
                                $aux2['otd_nombre'] = $row2['otd_nombre'];
                                $aux2['otd_aplica_especifique'] = $row2['otd_aplica_especifique'];
                                array_push($aux1['configuraciones'], $aux2);
                            }
                        }
                        array_push($aux['respuesta'], $aux1);
                    }
                }
                //Se incluyen los anexos de la pregunta
                $anexos_encuesta = $this->gsatelite->get_tabla('anp_anexo_pregunta', array('anp_id_pre' => $row['pre_id']));
                $aux['anexos'] = $anexos_encuesta;

                array_push($detallePreguntas, $aux);

            } //Fin de foreach


          /*  foreach($detallePreguntas as $row){
                $array_tipo=[];
                        foreach($row['respuesta'] as $items){
                            array_push($array_tipo,$items['opr_tipo_campo_dinamico']);
                        }

                        $array_respuestas_dinamica['pregunta'][]=$row['pre_id'];
                        //$array_respuestas_dinamica['respuestas'][]=$arrayRespuestas;
                        $array_respuestas_dinamica['tipo'][]=$array_tipo;

                        
                    }*/


            //Ahora recorremos el array detalle preguntas para introducir las respuestas de la bd
                    $cont = 0;
                    $array_respuestas_dinamica=[];
                    foreach ($detallePreguntas as $row) {


                if ($row['tipo'] == 1 || ($row['tipo'] >= 4 && $row['tipo'] <= 8) ) { //tipo Texto, otras
                    $respuesta = $this->gsatelite->get_tabla('rec_respuesta_encuesta', array('rec_id_ecl' => $idEncuesta, 'rec_id_pre' => $row['pre_id']));
                    if (!empty($respuesta))
                        $detallePreguntas[$cont]['respuestas_cliente'] = $respuesta[0]['rec_respuesta'];
                } elseif ($row['tipo'] == 2 || $row['tipo'] == 3) { //Lista de seleccion y seleccion multiple
                    $respuesta = $this->encuesta_model->respuesta_desplegable_multiple($idEncuesta, $row['pre_id']);
                    if (!empty($respuesta))
                        $detallePreguntas[$cont]['respuestas_cliente'] = $respuesta;
                }
                elseif ($row['tipo'] == 9) {//Tabla dinamica
                    $arrayRespuestas = [];

                    
                    foreach ($row['respuesta'] as $items) {                        
                        $arrayRespuestas[] = $items['opr_id'];
                    }

                    if(count($respuestas)>0){

                        $array_respuestas_dinamica['respuestas'][]=$arrayRespuestas;

                        $array_tipo=[];
                        foreach($row['respuesta'] as $items){
                            array_push($array_tipo,$items['opr_tipo_campo_dinamico']);
                        }

                        $array_respuestas_dinamica['pregunta'][]=$row['pre_id'];
                        
                        $array_respuestas_dinamica['tipo'][]=$array_tipo;   
                    }

                    //$respuesta = $this->gsatelite->get_tabla('rec_respuesta_encuesta', array('rec_id_ecl' => $idEncuesta, 'rec_id_pre' => $row['pre_id']));
                    $this->db->order_by('rec_id','asc');
                    $this->db->join('rec_respuesta_encuesta','rec_id_opr = opr_id AND rec_id_ecl = '.$idEncuesta, 'inner');
                    $respuesta = $this->gsatelite->get_tabla('opr_opcion_respuesta', array( 'opr_id_pre' => $row['pre_id']));
                    $numRespuestas = count($row['respuesta']);
                    $contItems = 0;
                    $aux = [];
                    $configuraciones = [];
                    //Se verifica existan respuestas
                    $count_rec_id = array_filter($respuesta, function($value){
                        return ($value['rec_id'] != null);
                    });

                    if(count($count_rec_id) > 0) {
                        $fila=end($array_respuestas_dinamica['pregunta']);
                        
                        $reg = array_filter($respuesta, function($value) use ($fila) { 
                            return ($value['opr_id_pre'] == $fila);
                        });

                        $key_respuesta=end($array_respuestas_dinamica['respuestas']);
                        $tipo_respuesta=end($array_respuestas_dinamica['tipo']);

                        $band=0;
                        $cont_reg=0;

                        $valor_array=[];
                        while($band==0){
                            $aux=[];
                            $configuraciones=[];

                            for($i=0;$i<count($key_respuesta);$i++){
                                $tipo=$tipo_respuesta[$i];
                                
                                if($key_respuesta[$i] == $reg[$cont_reg]['opr_id']){
                                    /*ÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑ*/
                                    if ($tipo == 1 || $tipo > 3 && $tipo <= 8) {
                                        $aux['tipo'] = $tipo;
                                        $aux['rec_respuesta'] = $reg[$cont_reg]['rec_respuesta'];
                                        array_push($configuraciones, $aux);
                                        
                                    } elseif ($tipo == 2) {
                                            //Consultamos si la opcion elegida tiene valor de especifique.
                                        $especifique = $this->gsatelite->get_tabla('oxp_opcion_respuestaxpregunta', array('oxp_id_rec' => $reg[$cont_reg]['rec_id']));
                                        $aux['tipo'] = $tipo;
                                        $aux['rec_respuesta'] = $especifique[0]['oxp_id_opr'];
                                        $aux['oxp_id_otd'] = $especifique[0]['oxp_id_otd'];
                                        if ($especifique[0]['oxp_valor_referencia'] != null)
                                            $aux['especifique'] = $especifique[0]['oxp_valor_referencia'];
                                        array_push($configuraciones, $aux);
                                    } elseif ($tipo == 3) {
                                        $especifique = $this->gsatelite->get_tabla('oxp_opcion_respuestaxpregunta', array('oxp_id_rec' => $reg[$cont_reg]['rec_id']));
                                        $aux['tipo'] = $tipo;
                                        $aux['rec_respuesta'] = [];
                                        foreach ($especifique as $row3) {
                                            $aux3 = [];
                                            $aux3['oxp_id_opr'] = $row3['oxp_id_opr'];
                                            $aux3['oxp_id_otd'] = $row3['oxp_id_otd'];
                                            $aux3['oxp_valor_referencia'] = $row3['oxp_valor_referencia'];
                                            array_push($aux['rec_respuesta'], $aux3);
                                        }
                                        array_push($configuraciones, $aux);
                                    }

                                    /*ÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑÑ*/
                                    $cont_reg++;
                                    $aux=[];
                                }else{
                                    $aux=[];
                                    $aux['tipo'] = $tipo;
                                    $aux['rec_respuesta'] = null;
                                    array_push($configuraciones, $aux);
                                }
                            }

                            array_push($detallePreguntas[$cont]['respuestas_cliente'], $configuraciones);
                            $configuraciones = [];

                                if($cont_reg==count($reg)){ //Todos los elementos de reg fueron tomados en cuenta.
                                    $band=1;
                                }
                            }
                        }
                    }
                elseif ($row['tipo'] == 10) { //Lista de iconos

                    $respuesta = $this->gsatelite->get_tabla('rec_respuesta_encuesta', array('rec_id_ecl' => $idEncuesta, 'rec_id_pre' => $row['pre_id']));
                    if (!empty($respuesta))
                        $detallePreguntas[$cont]['respuestas_cliente'] = $respuesta[0]['rec_respuesta'];

                }
                elseif ($row['tipo'] == 11 || $row['tipo'] == 12) { //Lista de iconos
                    $respuesta = $this->gsatelite->get_tabla('rec_respuesta_encuesta', array('rec_id_ecl' => $idEncuesta, 'rec_id_pre' => $row['pre_id']));
                    if (!empty($respuesta))
                        $anexo = $this->gsatelite->get_tabla('anr_anexo_respuesta', array('anr_id_rec' => $respuesta[0]['rec_id']));
                    if(!empty($anexo)){
                        $detallePreguntas[$cont]['respuestas_cliente'] =$anexo[0]['anr_ruta_archivo'].'/'.$anexo[0]['anr_nombre_archivo'];
                    }
                    

                }
                elseif($row['tipo'] == 14){
                    $respuesta = $this->gsatelite->get_tabla('rec_respuesta_encuesta', array('rec_id_ecl' => $idEncuesta, 'rec_id_pre' => $row['pre_id']));

                    if (!empty($respuesta))
                        $detallePreguntas[$cont]['respuestas_cliente'] = $respuesta[0]['rec_respuesta'];
                }

                elseif($row['tipo'] == 15){
                    $respuesta = $this->gsatelite->get_tabla('rec_respuesta_encuesta', array('rec_id_ecl' => $idEncuesta, 'rec_id_pre' => $row['pre_id']));

                    if (!empty($respuesta))
                        $detallePreguntas[$cont]['respuestas_cliente'] = $respuesta[0]['rec_respuesta'];
                }
                elseif ($row['tipo'] == 16) {//Tabla dinamica
                    $arrayRespuestas = [];
                    foreach ($row['respuesta'] as $items) {
                        $arrayRespuestas[] = $items['opr_id'];
                    }

                    //$respuesta = $this->gsatelite->get_tabla('rec_respuesta_encuesta', array('rec_id_ecl' => $idEncuesta, 'rec_id_pre' => $row['pre_id']));
                    $this->db->order_by('rec_num_fila ASC');
                    $this->db->join('rec_respuesta_encuesta','rec_id_opr = opr_id AND rec_id_ecl = '.$idEncuesta, 'left');
                    $respuesta = $this->gsatelite->get_tabla('opr_opcion_respuesta', array( 'opr_id_pre' => $row['pre_id']));
                    $numRespuestas = count($row['respuesta']);
                    $contItems = 0;
                    $aux = [];
                    $configuraciones = [];
                    //Se verifica existan respuestas
                    $count_rec_id = array_filter($respuesta, function($value){
                        return ($value['rec_id'] != null);
                    });

                    if(count($count_rec_id) > 0) {
                        foreach ($respuesta as $row1) {
                            $aux = [];
                            //Buscamos el tipo de pregunta de la respuesta
                            $numPregunta = 0;

                            foreach ($row['respuesta'] as $row2) {
                                if ($row1['rec_id_opr'] == $row2['opr_id']) {
                                    $tipo = $row2['opr_tipo_campo_dinamico'];
                                    break;
                                }
                                $numPregunta++;
                            }

                            /* ################################################################################################ */
                            if ($tipo == 1 || $tipo > 3 && $tipo <= 8) {
                                $aux['tipo'] = $tipo;
                                $aux['rec_respuesta'] = $row1['rec_respuesta'];
                                $aux['rec_id_opr'] = $row1['rec_id_opr'];
                                $aux['rec_num_fila'] = $row1['rec_num_fila'];
                                array_push($configuraciones, $aux);

                            } elseif ($tipo == 2) {
                                //Consultamos si la opcion elegida tiene valor de especifique.
                                $especifique = $this->gsatelite->get_tabla('oxp_opcion_respuestaxpregunta', array('oxp_id_rec' => $row1['rec_id']));
                                $aux['tipo'] = $tipo;
                                $aux['rec_respuesta'] = $especifique[0]['oxp_id_opr'];
                                $aux['rec_num_fila'] = $row1['rec_num_fila'];
                                $aux['rec_id_opr'] = $row1['rec_id_opr'];
                                $aux['oxp_id_otd'] = $especifique[0]['oxp_id_otd'];
                                if ($especifique[0]['oxp_valor_referencia'] != null)
                                    $aux['especifique'] = $especifique[0]['oxp_valor_referencia'];
                                array_push($configuraciones, $aux);
                            } elseif ($tipo == 3) {
                                $especifique = $this->gsatelite->get_tabla('oxp_opcion_respuestaxpregunta', array('oxp_id_rec' => $row1['rec_id']));
                                $aux['tipo'] = $tipo;
                                $aux['rec_respuesta'] = [];
                                $aux['rec_num_fila'] = $row1['rec_num_fila'];
                                $aux['rec_id_opr'] = $row1['rec_id_opr'];
                                foreach ($especifique as $row3) {
                                    $aux3 = [];
                                    $aux3['oxp_id_opr'] = $row3['oxp_id_opr'];
                                    $aux3['oxp_id_otd'] = $row3['oxp_id_otd'];
                                    $aux3['oxp_valor_referencia'] = $row3['oxp_valor_referencia'];
                                    array_push($aux['rec_respuesta'], $aux3);
                                }
                                array_push($configuraciones, $aux);
                            }

                            /* ################################################################################################ */

                            if ($contItems < $numRespuestas - 1) {
                                $contItems++;
                            } else {
                                array_push($detallePreguntas[$cont]['respuestas_cliente'], $configuraciones);
                                $configuraciones = [];
                                $contItems = 0;
                            }
                        }
                    }
                    //$respuesta=$this->encuesta_model->respuesta_dinamicas($idEncuesta,$row['pre_id'] );
                }
                $cont++;
            } //fin de  foreach($detallePreguntas as $row)

            $data['preguntas'] = $detallePreguntas;
            $data['encuesta'] = null;
            $data['idSucursal'] = null;
            $data['logo'] = $this->gsatelite->get_parametro('SYS_LOGOTIPO');
            $data['nombreEncuesta'] = $nombreEncuesta;
            ($data);
            $this->load->view('encuesta/procesos/respuesta_encuesta', $data);
        } else {

        }
    }


    /**
     * @return Mantenimiento de Links Encuestas por Sucursal
     * @update Manuel Hernandez
     * @author Rene Castaneda
     */
    public function link_encuestaAgencia($id_encuesta_sucursal = 0)
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            try {
                if (!is_numeric($id_encuesta_sucursal)) {
                    redirect('');
                }
                $this->db->join('enc_encuesta', 'enc_id=exs_id_enc');
                $this->db->join('suc_sucursal', 'suc_id=exs_id_suc');
                $data['registro'] = $this->gsatelite->get_tabla('exs_encuestaxsucursal', array('exs_id' => $id_encuesta_sucursal));
                $crud = new grocery_CRUD();
                $crud->set_table('lke_link_encuesta')
                ->set_subject('Link')
                ->where('lke_id_exs', $id_encuesta_sucursal)
                ->columns('lke_id_usu', 'lke_url_link', 'lke_fecha_inicio', 'lke_fecha_fin', 'lke_mensaje', 'lke_estado')
                ->display_as('lke_url_link', 'Link')
                ->display_as('lke_id_usu', 'Usuario Genera')
                ->display_as('lke_mensaje', 'Msj Inicio')
                ->display_as('lke_mensaje_fin', 'Msj Fin')
                ->display_as('lke_fecha_inicio', 'Inicio vigencia')
                ->display_as('lke_fecha_fin', 'Fin vigencia')
                ->display_as('lke_ejecucion_unica', 'Ejecución Unica')
                ->display_as('lke_link_redireccion', 'Redirección')
                ->display_as('lke_estado', 'Estado')
                ->add_fields('lke_id_usu',
                    'lke_id_exs',
                    'lke_url_link',
                    'lke_mensaje',
                    'lke_mensaje_fin',
                    'lke_fecha_inicio',
                    'lke_fecha_fin',
                    'lke_ejecucion_unica',
                    'lke_link_redireccion',
                    'lke_estado',
                    'lke_usu_creacion',
                    'lke_usu_modificacion',
                    'lke_fecha_creacion',
                    'lke_fecha_modificacion')
                ->edit_fields('lke_id_exs',
                    'lke_url_link',
                    'lke_mensaje',
                    'lke_mensaje_fin',
                    'lke_fecha_inicio',
                    'lke_fecha_fin',
                    'lke_ejecucion_unica',
                    'lke_link_redireccion',
                    'lke_estado',
                    'lke_usu_modificacion',
                    'lke_fecha_modificacion')
                ->required_fields('lke_fecha_inicio', 'lke_fecha_fin', 'lke_ejecucion_unica', 'lke_estado')
                ->field_type('lke_id_exs', 'hidden', $id_encuesta_sucursal)
                ->field_type('lke_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('lke_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('lke_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
                ->field_type('lke_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
                ->field_type('lke_url_link', 'hidden', '');
                if ($crud->getState() == "add" || $crud->getState() == "edit") {
                    $crud->field_type('lke_id_usu', 'hidden', $this->tank_auth->get_user_id());
                } else {
                    $crud->set_relation('lke_id_usu', 'users', '{username}');
                }
                $crud->add_action('Generar codigo QR', '', '', 'icomoon-icon-stack qr_generacion');
                
                $crud->callback_column('lke_mensaje', function ($value, $row) {
                    return $value;
                });
                $crud->callback_column('lke_fecha_inicio', function ($value, $row) {
                    return ($value) ? formatear_fecha("d-m-Y", $value) : '';
                });
                $crud->callback_column('lke_fecha_fin', function ($value, $row) {
                    return ($value) ? formatear_fecha("d-m-Y", $value) : '';
                });
                $crud->callback_column('lke_url_link', function ($value, $row) {
                    return '<a  target="_blank" class="tip" title="copiar: click derecho copiar dirección" href="' . base_url($value) . '">Link Encuesta</a>';
                });

                $uri_segments = explode('/', uri_string());
                if (end($uri_segments) == 'add') {
                    $crud->field_type('lke_estado', 'hidden', 1);
                } else {
                    $crud->field_type('lke_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
                }
                $crud->field_type('lke_ejecucion_unica', 'dropdown', array('1' => 'Sí', '0' => 'No'));
                $crud->callback_after_insert(function ($post, $primary_key) {
                    $unico = time() . "lk:(" . $primary_key;
                    $link = 'encuesta/procesos/ejecutar_LinkEncuesta/?key=' . base64_encode($unico);
                    $this->gsatelite->actualizar_array("lke_link_encuesta", array('lke_url_link' => $link), array('lke_id' => $primary_key));
                    return true;
                });

                $data['titulo_personal'] = "Link Encuesta";
                $crud->unset_print()->unset_export()->unset_delete();
                // Validaciones
                $crud->add_action('Ver', 'minia-icon-search', "encuesta/procesos/lectura_pregunta/$id_encuesta_sucursal/read");

                $output = $crud->render();
                $this->gsatelite->cargar_vista_masterpage("encuesta/procesos/link_encuesta_agencia", $data, $output);
                //cargarvista($data, $output);
            } catch (Exception $e) {
                show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
            }
        }
    }


    /**
     * @return Enlace para contestar encuestas por link
     * @author Manuel Hernandez
     */
    public function ejecutar_LinkEncuesta($validar = false, $key = "")
    {

        $ejecucion_unica = trim($this->session->userdata('encuesta_finalizada'));
        $data["key"] = "";
        $data["ejecucion_unica"] = 0;
        $data["estado_link"] = "3"; //link vacio, no existente
        $keyEncuesta = (trim($this->input->get("key")) != '') ? trim($this->input->get("key")) : $key;
        /* echo '$data<pre>';
         print_r($data);
         echo '</pre>'; */

         if (trim($keyEncuesta) != '') {
            $data["key"] = $keyEncuesta;
            $data["ejecucion_unica"] = ($ejecucion_unica == $data["key"]) ? 1 : 0;
            $data["sesion_web"] = $keyEncuesta . "__" . date("dmY_H_i_s");
            $datos = base64_decode($keyEncuesta);
            $datos_array = explode("lk:(", $datos);

            if (isset($datos_array[1]) && is_numeric($datos_array[1])) {
                $q = $this->gsatelite->get_tabla("lke_link_encuesta", array('lke_id' => $datos_array[1]));
                if ($q) {
                    if ($q[0]['lke_estado']) {
                        $fecha_actual = date("Ymd");
                        $fecha_inicio = formatear_fecha("Ymd", $q[0]['lke_fecha_inicio']);
                        $fecha_fin = formatear_fecha("Ymd", $q[0]['lke_fecha_fin']);
                        if ($fecha_actual >= $fecha_inicio && $fecha_actual <= $fecha_fin) {
                            $this->db->join("exs_encuestaxsucursal", "exs_id=lke_id_exs");
                            $this->db->join("enc_encuesta", "enc_id=exs_id_enc");
                            $this->db->join("suc_sucursal", "suc_id=exs_id_suc");
                            $qDatos = $this->gsatelite->get_tabla("lke_link_encuesta", array('lke_id' => $datos_array[1]));
                            $data["registro"] = $qDatos[0];
                            $data["estado_link"] = ($data["ejecucion_unica"] == 1) ? "7" : "1"; //valido, vigente
                        } else {
                            $data["estado_link"] = "6"; //Link vencido (fuera de tiempo)
                        }

                    } else {
                        $data["estado_link"] = "5"; //Registro Inactivo
                    }
                } else {
                    $data["estado_link"] = "4"; //Registro no existe, elminado
                }
            } else {
                $data["estado_link"] = "2"; //truncado, inconsistente
            }
        } else {
            $data["estado_link"] = "3"; //link vacio, no existente
        }

        if ($validar) {
            return $data;
        } else {
            //print_r($data); die();
            $this->load->view('encuesta/procesos/ejecutar_LinkEncuesta', $data);
            //$this->gsatelite->cargar_vista_masterpage("encuesta/procesos/ejecutar_LinkEncuesta",$data);
        }
    }

    /**
     * @author Manuel Hernández
     */
    public function encuestaFinalizada()
    {
        $data = $this->session->flashdata('data');
        //print_r($data);die();
        $this->load->view('encuesta/procesos/ejecutar_LinkEncuesta_finalizada', $data);
    }


    /**
     * @author Manuel Hernández
     */
    public function modificarConfiguracion()
    {
        $id = $this->input->post('id');
        $valorActual = $this->input->post('valorActual');
        $nuevoValor = $this->input->post('nuevoValor');
        $tipo = $this->input->post('tipo');

        $existe = 0;

        //realizamos los cambios
        if ($tipo == 1) {
            //Cambio en la tabla
            $update_opc = array(
                'opr_nombre' => trim($nuevoValor),
                'opr_usu_modificacion' => $this->tank_auth->get_user_id(),
                'opr_fecha_modificacion' => date('Y-m-d H:i:s')
            );
            $existe = $this->gsatelite->actualizar_array('opr_opcion_respuesta', $update_opc, array('opr_id' => $id));
        } elseif ($tipo == 2) {
            $update_opc = array(
                'otd_nombre' => trim($nuevoValor),
                'otd_usu_modificacion' => $this->tank_auth->get_user_id(),
                'otd_fecha_modificacion' => date('Y-m-d H:i:s')
            );
            $existe = $this->gsatelite->actualizar_array('otd_opcion_tabla_dinamica', $update_opc, array('otd_id' => $id));
        }


        die(json_encode(array('existe' => $existe)));
    }


    /**
     * @author Rene Castaneda
     */
    public function filtrar_encuesta_sucursal()
    {

        $id = $this->input->post('id_sucursal');
        $encuesta = $this->encuesta_model->get_encuestasxsucursal(array('suc_id' => $id));
        $select = '<option value=""></option>';
        foreach ($encuesta as $fila) {
            $select .= '<option value="' . $fila['enc_id'] . '">' . $fila['enc_nombre'] . '</option>' . "\n";
        }
        die(json_encode(array('html_option' => $select)));
    }

    public function exportar_datos($encuesta = 0, $spss = 0, $reprocesar = 0, $excel = 0) {
        ini_set('max_execution_time', '9999999999');
        ini_set('memory_limit ', '2048M');
        if ($encuesta != 0) {
            $where['enc_id'] = $encuesta;
        }
        $fecha_inicio = '';
        $fecha_fin= '';
        if($this->input->post()){
            
            $post_array = $this->input->post();
            if ($post_array['slcEncuesta'] != '') {
                $where['enc_id'] = $post_array['slcEncuesta'];
            }
            $fecha_inicio = formatear_fecha('Y-m-d',$post_array['txtFecha_desde']);
            $fecha_fin = formatear_fecha('Y-m-d',$post_array['txtFecha_hasta']);
            $where['DATE(ecl_fecha) >= '] = $fecha_inicio;
            $where['DATE(ecl_fecha) <= '] = $fecha_fin;
        }
        if ($spss == 0) {
            $data['encuestas'] = $this->encuesta_model->get_exportar_datos($where);
        } else {
            $group_by = "enc_id, pre_id";
            $order_by = "enc_id, pre_orden ASC";
            $data['encuesta_header'] = $this->encuesta_model->get_exportar_datos_spss($where, $group_by, $order_by);
        }
        //print_r($this->db->last_query());die();
        $data['encuesta'] = $encuesta;
        $data['opr_data'] = $this->gsatelite->get_tabla('opr_opcion_respuesta');

        $this->db->order_by('otd_id ASC');
        $data['otd_data'] = $this->gsatelite->get_tabla('otd_opcion_tabla_dinamica');

        $data['excel'] = $excel;
        $data['fecha_inicio'] = $fecha_inicio;
        $data['fecha_fin'] = $fecha_fin;
        $data['reprocesar'] = $reprocesar;
        $html = "";
        //echo count($data['encuestas']);die();
        if ($spss == 0) {
            $data['oxp_data'] = $this->gsatelite->get_tabla('oxp_opcion_respuestaxpregunta');
            $data['rec_data'] = $this->gsatelite->get_tabla('rec_respuesta_encuesta');
            $html = $this->load->view('encuesta/procesos/exportar_datos', $data, true);
        } else if($spss == 2) {
        $data['oxp_data'] = $this->encuesta_model->get_respuestas_multiples(array('enc_id' => $encuesta/*,'ecl_id IN(1,3, 2624)' => null*/), 'oxp_id', 'ecl_id ASC');

    $data['rec_data'] = $this->encuesta_model->get_respuestas_estaticas(array('enc_id' => $encuesta/*,'ecl_id IN(1,3, 2624)' => null*/), 'rec_id', 'ecl_id ASC');

$data['entrevistas'] = $this->encuesta_model->get_exportar_datos_spss(array('enc_id' => $encuesta/*,'ecl_id IN(1,3, 2624)' => null*/), 'ecl_id', 'ecl_id ASC');
$html = $this->load->view('encuesta/procesos/exportar_datos_p40', $data, true);
} else {
    $data['oxp_data'] = $this->gsatelite->get_tabla('oxp_opcion_respuestaxpregunta');
    $data['rec_data'] = $this->gsatelite->get_tabla('rec_respuesta_encuesta');
    $html = $this->procesar_datos_spss($data);
            //$html = $this->load->view('encuesta/procesos/exportar_datos_spss', $data, true);
}
if ($excel > 0) {
    echo $html;
} else {
    echo json_encode(array('html' => $html));
}        
}

public function procesar_datos_spss($data)
{
        //Se procesan todas las preguntas convirtiendolas en registros dependiendo del tipo de pregunta y las opciones de especifique
    $preguntas_array = array();
    $respuestas_array = array();
    $list_tipo_simple = array(1, 4, 5, 6, 7, 8);
       /* $this->gsatelite->borrado_general('exp_preguntas', array('pre_id_enc' => $data['encuesta']));

        foreach ($data['encuesta_header'] as $pre) {
            $pre_id = $pre['pre_id'];
            $pregunta = array(
                'pre_id_enc' => $pre['enc_id'],
                'pre_codigo' => '',
                'pre_nombre' => '',
                'pre_orden' => 0,
                'pre_tipo' => 0
            );

            //Dependiendo del tipo de pregunta se construiran las preguntas a insertar
            if (in_array($pre['pre_tipo'], $list_tipo_simple)) {
                $pregunta['pre_nombre'] = $pre['pre_nombre'];
                $pregunta['pre_codigo'] = 'pre_id_' . $pre['pre_id'];
                $pregunta['pre_orden'] = $pre['pre_orden'];
                $pregunta['pre_tipo'] = $pre['pre_tipo'];

                $preguntas_array[] = $pregunta;
            }

            if ($pre['pre_tipo'] == 2) {
                $pregunta['pre_nombre'] = $pre['pre_nombre'];
                $pregunta['pre_codigo'] = 'pre_id_' . $pre['pre_id'];
                $pregunta['pre_orden'] = $pre['pre_orden'];
                $pregunta['pre_tipo'] = $pre['pre_tipo'];

                $preguntas_array[] = $pregunta;

                $opciones_especifique = array_filter($data['opr_data'], function ($value) use ($pre_id) {
                    return ($value['opr_id_pre'] == $pre_id && $value['opr_aplica_especifique'] == 1);
                });

                //Si hay un especifique se agrega un otros
                if (count($opciones_especifique) > 0) {
                    $nombre_pre = "P" . $pre['pre_orden'] . '_Otro';
                    $pregunta['pre_nombre'] = $nombre_pre;
                    $pregunta['pre_codigo'] = 'pre_id_' . $pre['pre_id'] . '_otro';
                    $pregunta['pre_orden'] = $pre['pre_orden'];
                    $pregunta['pre_tipo'] = 11;

                    $preguntas_array[] = $pregunta;
                }
            }

            if ($pre['pre_tipo'] == 3) {
                //Se filtran las opciones que tengan especifique y las que no.
                $opciones_sin_especifique = array_filter($data['opr_data'], function ($value) use ($pre_id) {
                    return ($value['opr_id_pre'] == $pre_id && $value['opr_aplica_especifique'] == 0);
                });

                if (count($opciones_sin_especifique) > 0) {
                    $i = 1;
                    foreach ($opciones_sin_especifique as $opr) {
                        $nombre_pre = ($i == 1) ? "P" . $pre['pre_orden'].'.'.$opr['opr_nombre'] : "P" . $pre['pre_orden'] . '.' . $i.'.'.$opr['opr_nombre'];
                        $pregunta['pre_nombre'] = $nombre_pre;
                        $pregunta['pre_codigo'] = 'pre_id_' . $pre['pre_id'] . '_' . $opr['opr_id'];
                        $pregunta['pre_orden'] = $pre['pre_orden'];
                        $pregunta['pre_tipo'] = 3;

                        $preguntas_array[] = $pregunta;
                        $i++;
                    }
                }

                $opciones_especifique = array_filter($data['opr_data'], function ($value) use ($pre_id) {
                    return ($value['opr_id_pre'] == $pre_id && $value['opr_aplica_especifique'] == 1);
                });

                if (count($opciones_especifique) > 0) {
                    $i = 1;
                    foreach ($opciones_especifique as $opr) {
                        $nombre_pre = ($i == 1) ? "P" . $pre['pre_orden'].'.'.$opr['opr_nombre'] . '_Otro' : "P" . $pre['pre_orden'] . '.' . $i.'.'.$opr['opr_nombre'] . '_Otro';
                        $pregunta['pre_nombre'] = $nombre_pre;
                        $pregunta['pre_codigo'] = 'pre_id_' . $pre['pre_id'] . '_' . $opr['opr_id'];
                        $pregunta['pre_orden'] = $pre['pre_orden'];
                        $pregunta['pre_tipo'] = 3;

                        $preguntas_array[] = $pregunta;
                        $i++;
                    }
                }
            }

            if ($pre['pre_tipo'] == 9) {
                //Se filtran las opciones de la pregunta
                $opciones = array_filter($data['opr_data'], function ($value) use ($pre_id) {
                    return ($value['opr_id_pre'] == $pre_id);
                });

                if (count($opciones) > 0) {
                    $i = 1;
                    foreach ($opciones as $opr) {
                        $nombre_pre = "P" . $pre['pre_orden'] . '.' . $i . '_' . $opr['opr_nombre'];
                        $pregunta['pre_nombre'] = $nombre_pre;
                        $pregunta['pre_codigo'] = 'pre_id_' . $pre['pre_id'] . '_' . $opr['opr_id'];
                        $pregunta['pre_orden'] = $pre['pre_orden'];
                        $pregunta['pre_tipo'] = 9;

                        $preguntas_array[] = $pregunta;
                        $i++;
                    }
                }
            }
        }

        $this->gsatelite->ingresar('exp_preguntas', $preguntas_array, true);*/
        
        //var_dump($preguntas_array);

        //Se obtienen las preguntas normalizadas
        $exp_preguntas = $this->gsatelite->get_tabla('exp_preguntas', array('pre_id_enc' => $data['encuesta']));
        $entrevistas = $this->encuesta_model->get_exportar_datos_spss(array('enc_id' => $data['encuesta'],'ecl_id IN(1, 2624)' => null,"pre_id"=>63), 'ecl_id', 'ecl_id ASC');
        //Se recorren las preguntas nuevamente para ir ingresando las respuestas por pregunta
        //Si se quiere ordenar por encuesta usar el ecl_id, y rec_id. Para ordenarlas
        //Se recorren las entrevistas
        foreach ($entrevistas as $ecl) {
            $this->gsatelite->borrado_general('exp_respuestas', array('rec_id_ecl' => $ecl['ecl_id']));
            //Temporalmente por una sola encuesta la 34
            foreach ($data['encuesta_header'] as $pre) {
                $pre_id = $pre['pre_id'];
                $ecl_id = $ecl['ecl_id'];

                $filtro_resp = array('pre_id' => $pre_id, 'ecl_id' => $ecl_id);

                $respuesta = array(
                    'rec_id_ecl' => $ecl['ecl_id'],
                    'rec_id_pre' => '',
                    'rec_respuesta' => ''
                );

                //Dependiendo del tipo de pregunta se buscaran las respuestas a insertar
                if (in_array($pre['pre_tipo'], $list_tipo_simple)) {
                    //Se saca el id nuevo de la pregunta
                    $pre_id_exp = array_filter($exp_preguntas, function ($value) use ($filtro_resp) {
                        return ($value['pre_codigo'] == "pre_id_" . $filtro_resp['pre_id']);
                    });

                    $pre_id_exp = (count($pre_id_exp) > 0) ? array_pop(array_reverse($pre_id_exp)) : null;

                    //Si la pregunta no existe no se procesa
                    if ($pre_id_exp != null) {
                        $respuesta['rec_id_pre'] = $pre_id_exp['pre_id'];

                        $respuestas = array_filter($data['rec_data'], function ($value) use ($filtro_resp) {
                            return ($value['rec_id_pre'] == $filtro_resp['pre_id'] && $value['rec_id_ecl'] == $filtro_resp['ecl_id']);
                        });

                        //Si la pregunta no fue respondida se ingresa una respuesta vacia.
                        if (count($respuestas) > 0) {
                            foreach ($respuestas as $rec) {
                                $respuesta['rec_respuesta'] = $rec['rec_respuesta'];
                                $respuestas_array[] = $respuesta;
                            }
                        } else {
                            $respuesta['rec_respuesta'] = '';
                            $respuestas_array[] = $respuesta;
                        }
                    }
                }

                if ($pre['pre_tipo'] == 2) {
                    $opciones = array_filter($data['opr_data'], function ($value) use ($pre_id) {
                        return ($value['opr_id_pre'] == $pre_id);
                    });

                    //Se saca el id nuevo de la pregunta
                    $pre_id_exp = array_filter($exp_preguntas, function ($value) use ($filtro_resp) {
                        return ($value['pre_codigo'] == "pre_id_" . $filtro_resp['pre_id']);
                    });

                    //Se saca el id nuevo de la pregunta
                    $pre_id_otro_exp = array_filter($exp_preguntas, function ($value) use ($filtro_resp) {
                        return ($value['pre_codigo'] == "pre_id_" . $filtro_resp['pre_id'] . '_otro');
                    });

                    $pre_id_exp = (count($pre_id_exp) > 0) ? array_pop(array_reverse($pre_id_exp)) : null;
                    $pre_id_otro_exp = (count($pre_id_otro_exp) > 0) ? array_pop(array_reverse($pre_id_otro_exp)) : null;

                    if ($pre_id_exp != null) {

                        if (count($opciones) > 0) {
                            $resp = 0;
                            foreach ($opciones as $opr) {
                                $respuesta['rec_id_pre'] = $pre_id_exp['pre_id'];
                                $filtro_resp = array('pre_id' => $pre['pre_id'], 'ecl_id' => $ecl['ecl_id'], 'opr_id' => $opr['opr_id']);

                                $respuesta_pregunta = array_filter($data['rec_data'], function ($value) use ($filtro_resp) {
                                    return ($value['rec_id_ecl'] == $filtro_resp['ecl_id']
                                        && $value['rec_id_pre'] == $filtro_resp['pre_id']
                                        && $value['rec_id_opr'] == $filtro_resp['opr_id']);
                                });

                                //Si hay respuestas se busca el valor
                                if (count($respuesta_pregunta) > 0) {
                                    foreach ($respuesta_pregunta as $rec) {

                                        $respuesta['rec_respuesta'] = $opr['opr_nombre'];
                                        $respuestas_array[] = $respuesta;

                                        //Si aplica a otros se agrega la respuesta de otros siempre y cuando no este vacia
                                        if ($opr['opr_aplica_especifique'] == 1 && $pre_id_otro_exp != null) {
                                            //Se verifica que no se haya agregado ya el especifique de esta pregunta

                                            $respuesta_especifique = array_filter($respuestas_array, function ($value) use ($pre_id_otro_exp) {
                                                return ($value['rec_id_pre'] == $pre_id_otro_exp['pre_id']);
                                            });

                                            if (count($respuesta_especifique) == 0) {
                                                $respuesta['rec_id_pre'] = $pre_id_otro_exp['pre_id'];

                                                $filtro_espc = array('rec_id' => $rec['rec_id'], 'opr_id' => $opr['opr_id']);
                                                $especifique_res = array_filter($data['oxp_data'], function ($value) use ($filtro_espc) {
                                                    return ($value['oxp_id_opr'] == $filtro_espc['opr_id'] && $value['oxp_id_rec'] == $filtro_espc['rec_id']);
                                                });

                                                $especifique_res = (count($especifique_res) > 0) ? array_pop(array_reverse($especifique_res)) : null;
                                                if ($especifique_res != null) {
                                                    $respuesta['rec_respuesta'] = ($especifique_res != null) ? $especifique_res['oxp_valor_referencia'] : '';
                                                    $respuestas_array[] = $respuesta;
                                                }
                                            }
                                        }
                                    }
                                    $resp++;
                                }

                                //Si el especifique aplica pero no hay respuestas se ingresa uno vacio
                                if (count($respuesta_pregunta) == 0 && $opr['opr_aplica_especifique'] == 1 && $pre_id_otro_exp != null) {
                                    //Se verifica que no se haya agregado ya el especifique de esta pregunta

                                    $respuesta_especifique = array_filter($respuestas_array, function ($value) use ($pre_id_otro_exp) {
                                        return ($value['rec_id_pre'] == $pre_id_otro_exp['pre_id']);
                                    });

                                    if (count($respuesta_especifique) == 0) {
                                        $respuesta['rec_id_pre'] = $pre_id_otro_exp['pre_id'];
                                        $respuesta['rec_respuesta'] = '';
                                        $respuestas_array[] = $respuesta;
                                    }
                                }
                            }

                            //Si no hay respuestas se ingresa uno vacio a la pregunta normal y al otros
                            if ($resp == 0) {
                                $respuesta['rec_respuesta'] = '';
                                $respuestas_array[] = $respuesta;
                            }
                        }
                    }
                }

                if ($pre['pre_tipo'] == 3) {
                    //Se filtran las opciones de la pregunta
                    $opciones = array_filter($data['opr_data'], function ($value) use ($pre_id) {
                        return ($value['opr_id_pre'] == $pre_id);
                    });

                    if (count($opciones) > 0) {
                        //Se recorren las opciones para buscar cada una de las preguntas correspondientes
                        foreach ($opciones as $opr) {
                            $filtro_pre_exp = array('pre_id' => $pre['pre_id'], 'opr_id' => $opr['opr_id']);
                            //Se saca el id nuevo de la pregunta
                            $pre_id_exp = array_filter($exp_preguntas, function ($value) use ($filtro_pre_exp) {
                                return ($value['pre_codigo'] == "pre_id_" . $filtro_pre_exp['pre_id'] . '_' . $filtro_pre_exp['opr_id']);
                            });

                            $pre_id_exp = (count($pre_id_exp) > 0) ? array_pop(array_reverse($pre_id_exp)) : null;
                            //Se validara si existe una pregunta asociada a la opcion de respuesta
                            if ($pre_id_exp != null) {
                                $respuesta['rec_id_pre'] = $pre_id_exp['pre_id'];

                                //Se filtran las respuestas asociadas a la opcion
                                $filtro_resp = array('pre_id' => $pre['pre_id'], 'ecl_id' => $ecl['ecl_id'], 'opr_id' => $opr['opr_id']);

                                $respuesta_pregunta = array_filter($data['rec_data'], function ($value) use ($filtro_resp) {
                                    return ($value['rec_id_ecl'] == $filtro_resp['ecl_id']
                                        && $value['rec_id_pre'] == $filtro_resp['pre_id']);
                                });


                                //Se buscan las respuestas asociadas a la opcion de respuesta, y los detalles agregados
                                if (count($respuesta_pregunta) > 0) {
                                    foreach ($respuesta_pregunta as $rec) {
                                        $filtro_espc = array('rec_id' => $rec['rec_id'], 'opr_id' => $opr['opr_id']);
                                        $especifique_res = array_filter($data['oxp_data'], function ($value) use ($filtro_espc) {
                                            return ($value['oxp_id_opr'] == $filtro_espc['opr_id'] && $value['oxp_id_rec'] == $filtro_espc['rec_id']);
                                        });

                                        if (count($especifique_res)) {
                                            foreach ($especifique_res as $oxp) {
                                                $respuesta['rec_respuesta'] = ($oxp['oxp_valor_referencia'] != null) ? $oxp['oxp_valor_referencia'] : 'Si';
                                                $respuestas_array[] = $respuesta;
                                            }
                                        } else {
                                            $respuesta['rec_respuesta'] = ($opr['opr_aplica_especifique'] == 1) ? "" : "";
                                            $respuestas_array[] = $respuesta;
                                        }
                                    }
                                } else {
                                    $respuesta['rec_respuesta'] = "";
                                    $respuestas_array[] = $respuesta;
                                }
                            }
                        }
                    }
                }

                if ($pre['pre_tipo'] == 9) {
                    //Se filtran las opciones de la pregunta
                    $opciones = array_filter($data['opr_data'], function ($value) use ($pre_id) {
                        return ($value['opr_id_pre'] == $pre_id);
                    });

                    if (count($opciones) > 0) {
                        //Se recorren las opciones para buscar cada una de las preguntas correspondientes
                        foreach ($opciones as $opr) {
                            $filtro_opr = array('pre_id' => $pre_id, 'opr_id' => $opr['opr_id'], 'ecl_id' => $ecl_id);

                            //Se saca el id nuevo de la pregunta
                            $pre_id_exp = array_filter($exp_preguntas, function ($value) use ($filtro_opr) {
                                return ($value['pre_codigo'] == "pre_id_" . $filtro_opr['pre_id'] . '_' . $filtro_opr['opr_id']);
                            });

                            $pre_id_exp = (count($pre_id_exp) > 0) ? array_pop(array_reverse($pre_id_exp)) : null;
                            //Si la pregunta no existe no se procesa
                            if ($pre_id_exp != null) {
                                $respuesta['rec_id_pre'] = $pre_id_exp['pre_id'];

                                $respuestas = array_filter($data['rec_data'], function ($value) use ($filtro_opr) {
                                    return (
                                        $value['rec_id_pre'] == $filtro_opr['pre_id']
                                        && $value['rec_id_ecl'] == $filtro_opr['ecl_id']
                                        && $value['rec_id_opr'] == $filtro_opr['opr_id']
                                    );
                                });

                                //Si la pregunta no fue respondida se ingresa una respuesta vacia.
                                if (count($respuestas) > 0) {
                                    foreach ($respuestas as $rec) {

                                        //Dependiendo del tipo de pregunta se buscaran las respuestas a insertar
                                        if (in_array($opr['opr_tipo_campo_dinamico'], $list_tipo_simple)) {
                                            $respuesta['rec_respuesta'] = $rec['rec_respuesta'];
                                            $respuestas_array[] = $respuesta;
                                        }

                                        if ($opr['opr_tipo_campo_dinamico'] == 2 || $opr['opr_tipo_campo_dinamico'] == 3) {

                                            $filtro_espc = array('rec_id' => $rec['rec_id'], 'opr_id' => $opr['opr_id']);
                                            $especifique_res = array_filter($data['oxp_data'], function ($value) use ($filtro_espc) {
                                                return ($value['oxp_id_opr'] == $filtro_espc['opr_id'] && $value['oxp_id_rec'] == $filtro_espc['rec_id']);
                                            });

                                            if (count($especifique_res) > 0) {
                                                foreach ($especifique_res as $oxp) {
                                                    //Se busca la opcion asociada de la OTD
                                                    $filtro_otd = array('otd_id' => $oxp['oxp_id_otd'], 'opr_id' => $opr['opr_id']);
                                                    $otd = array_filter($data['otd_data'], function ($value) use ($filtro_otd) {
                                                        return ($value['otd_id'] == $filtro_otd['otd_id'] && $value['otd_id_opr'] == $filtro_otd['opr_id']);
                                                    });

                                                    $otd = (count($otd) > 0) ? array_pop(array_reverse($otd)) : null;

                                                    $respuesta['rec_respuesta'] = ($otd != null) ? $otd['otd_nombre'] : '';;
                                                    $respuestas_array[] = $respuesta;
                                                }
                                            } else {
                                                $respuesta['rec_respuesta'] = '';
                                                $respuestas_array[] = $respuesta;
                                            }
                                        }
                                    }
                                } else {
                                    $respuesta['rec_respuesta'] = '';
                                    $respuestas_array[] = $respuesta;
                                }
                            }
                        }
                    }
                }
            }
        }
        //var_dump($respuestas_array);
        if (count($respuestas_array) > 0) {
            $this->gsatelite->ingresar('exp_respuestas', $respuestas_array, true);
        } else {
            var_dump($respuestas_array);
        }


        return count($preguntas_array);
    }

    public function cargar_imagen($destino=null){

        header('Content-Type: application/json'); // set json response headers
        $outData = $this->upload_image(); // a function to upload the bootstrap-fileinput files
        echo "outdata<pre>";
        print_r($outData);
        echo "</pre>";

        echo json_encode($outData); // return json data
        exit(); // terminate
    }

    public function upload_image(){

        echo "<pre>";
        print_r($_FILES);
        echo "</pre>";

        $preview = $config = $errors = [];
    $input = 'pregunta_118'; // the input name for the fileinput plugin
    if (empty($_FILES[$input])) {
        echo "entro<pre>";
        print_r('hh');
        echo "</pre>";
        return [];
        
    $total = count($_FILES[$input]['name']); // multiple files
    echo "total<pre>";
    print_r($total);
    echo "</pre>";

    $path = '/uploads/'; // your upload path
    for ($i = 0; $i < $total; $i++) {
        $tmpFilePath = $_FILES[$input]['tmp_name'][$i]; // the temp file path
        $fileName = $_FILES[$input]['name'][$i]; // the file name
        $fileSize = $_FILES[$input]['size'][$i]; // the file size

        echo "<pre>";
        print_r($tmpFilePath);
        echo "</pre>";
        die();

        
        //Make sure we have a file path
        if ($tmpFilePath != ""){
            //Setup our new file path
            $newFilePath = $path . $fileName;
            $newFileUrl = base_url().'uploads/temp/' . $fileName;
            
            //Upload the file into the new path
            if(move_uploaded_file($tmpFilePath, $newFilePath)) {
                $fileId = $fileName . $i; // some unique key to identify the file
                $preview[] = $newFileUrl;
                $config[] = [
                    'key' => $fileId,
                    'caption' => $fileName,
                    'size' => $fileSize,
                    'downloadUrl' => $newFileUrl, // the url to download the file
                    'url' => base_url().'encuesta/procesos/eliminar_imagen', // server api to delete the file based on key
                ];
            } else {
                $errors[] = $fileName;
            }
        } else {
            $errors[] = $fileName;
        }
    }
    $out = ['initialPreview' => $preview, 'initialPreviewConfig' => $config, 'initialPreviewAsData' => true];
    echo $out;
    if (!empty($errors)) {
        $img = count($errors) === 1 ? 'file "' . $errors[0]  . '" ' : 'files: "' . implode('", "', $errors) . '" ';
        $out['error'] = 'Oh snap! We could not upload the ' . $img . 'now. Please try again later.';
    }
    return $out;
}
}
    //las ultimos 2 parametros llevaran valor cuando se trate de ver encuesta ya contestada.
public function testmap($id_latitud="", $id_longitud="",$val_latitud="", $val_longitud=""){
 $data['id_longitud'] = $id_longitud;
 $data['id_latitud'] = $id_latitud;
 $data['val_latitud'] = $val_latitud; 
 $data['val_longitud'] = $val_longitud;

 if(($val_latitud == null || $val_latitud == '') && ($val_longitud == null || $val_longitud == '')){
    $this->load->view('encuesta/procesos/testmap',$data);
}else{
    $this->load->view('encuesta/procesos/testmap_view',$data);
}
}

public function pregunta_dibujo($pre_id="", $pre_tipo){
    $data['pre_id'] = $pre_id;
    $data['pre_tipo'] = $pre_tipo;
    if($pre_id){
        $this->load->view('encuesta/procesos/view_dibujo',$data);
    }
}

    /**
     * @author Mario Marquez
     * @return Gestion de Comentarios por incidencia
     */
    function anexos_pregunta($pre_id = 0)
    {
        satelite_validar();

        $crud = new grocery_crud();

        $columns = array(
            'anp_ruta',
        );

        $display_as = array(
            'anp_ruta' => 'Adjunto',
        );

        $required = array(
            'anp_ruta',
        );

        $crud->set_table('anp_anexo_pregunta')
        ->set_subject('Anexos Pregunta')
        ->columns($columns)
        ->display_as($display_as)
        ->required_fields($required)
        ->set_rules('anp_ruta', 'Adjunto', 'required|trim')
        ->set_rules('anp_estado', 'Estado', 'required')
        ->set_field_upload('anp_ruta', 'uploads/anx_preguntas')
        ->field_type('anp_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
        ->field_type('anp_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
        ->field_type('anp_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
        ->field_type('anp_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
        ->field_type('anp_estado', 'hidden', date('Y-m-d H:i:s'))
        ->field_type('anp_id_pre', 'hidden', $pre_id)
        ->unset_export()
        ->unset_print();

        if ($pre_id != 0) {
            $crud->where('anp_id_pre', $pre_id);
        }

        //$crud->add_action('&nbsp;Editar', '', 'desarrollo/procesos/editar_comentario/' . $inc_id, 'icon16 icomoon-icon-pencil-5', '');
        $output = $crud->render();

        $data['titulo_personal'] = 'Adjuntos Pregunta';

        $data['pre_id'] = $pre_id;

        cargarvista($data, $output);

    }

    /**
    * @return Mantenimiento de Encuestas
    * @author Rene Castaneda
    * @since 17-12-2020
    */
    public function gestion_encuesta_me()
    { 
        satelite_validar();
        $this->gestion_encuesta($this->tank_auth->get_user_id());
    }

    /**
    * @return accion para la duplicacion de encuesta
    * @author Marlon Olmedo - Grupo Satelite
    * @since 19-12-2020
    */
    public function duplicar_encuesta($id_encuesta = null)
    {
        satelite_validar();
        if($this->input->post()){
            $id_encuesta = $this->input->post("id_encuesta");
            $nombre_new_encuesta = $this->input->post("nombre");

            $new_encuesta_grupo_id = null;
            $new_link = null;
            $new_categoria_encuesta = null;
            
            //primero duplica la encuesta --
            //luego las preguntas --
            //luego las opciones respuesta de la tabla dinamica --
            //luego las opcion tabla de la tabla dinamica --
            //luego encuestas por sucursal
            //luego el link de la encuestas y por ultimo categoria de pregunta
            //datos categoria encuesta

            //traigo informacion de encuesta
            $encuesta_duplicar = $this->gsatelite->get_tabla("enc_encuesta", array("enc_id" => $id_encuesta));

            unset($encuesta_duplicar[0]["enc_id"]);
            $encuesta_duplicar[0]["enc_nombre"] = $nombre_new_encuesta;
            $encuesta_duplicar[0]["enc_usu_creacion"] = $this->tank_auth->get_user_id();
            $encuesta_duplicar[0]["enc_fecha_creacion"] = date('Y-m-d H:i:s');
            $encuesta_duplicar[0]["enc_usu_modificacion"] = $this->tank_auth->get_user_id();
            $encuesta_duplicar[0]["enc_fecha_modificacion"] = date('Y-m-d H:i:s');

            $nuevo_id_encuesta = $this->gsatelite->ingresar('enc_encuesta', $encuesta_duplicar[0]);
            //$nuevo_id_encuesta = 1;
            //$repuesta = $this->duplicacion_pregunta_bk(null,29,32);
            $repuesta = $this->duplicacion_pregunta_bk(null,$id_encuesta,$nuevo_id_encuesta);
            //print_r($repuesta);die();

            $encuesta_grupo = $this->gsatelite->get_tabla("exs_encuestaxsucursal", array("exs_id_enc" => $id_encuesta));
            if(!empty($encuesta_grupo)){
                foreach ($encuesta_grupo as $key4 => $value4) {
                    $encuesta_grupo_id_old = $value4["exs_id"];

                    unset($value4["exs_id"]);
                    $value4["exs_id_enc"] = $nuevo_id_encuesta;
                    $value4["exs_usu_creacion"] = $this->tank_auth->get_user_id();
                    $value4["exs_fecha_creacion"] = date('Y-m-d H:i:s');
                    $value4["exs_usu_modificacion"] = $this->tank_auth->get_user_id();
                    $value4["exs_fecha_modificacion"] = date('Y-m-d H:i:s');

                    $new_encuesta_grupo_id[$key4] = $this->gsatelite->ingresar('exs_encuestaxsucursal', $value4);

                    $get_link = $this->gsatelite->get_tabla("lke_link_encuesta", array("lke_id_exs" => $encuesta_grupo_id_old));

                    foreach ($get_link as $key5 => $value5) {
                        unset($value5["lke_id"]);
                        $value5["lke_id_exs"] = $new_encuesta_grupo_id[$key4];
                        $value5["lke_usu_creacion"] = $this->tank_auth->get_user_id();
                        $value5["lke_fecha_creacion"] = date('Y-m-d H:i:s');
                        $value5["lke_usu_modificacion"] = $this->tank_auth->get_user_id();
                        $value5["lke_fecha_modificacion"] = date('Y-m-d H:i:s');

                        $new_link[$key5] = $this->gsatelite->ingresar('lke_link_encuesta', $value5);
                    }
                    } //fin link encuestas
                }
                
                $get_categoria_encuesta = $this->gsatelite->get_tabla("cap_categoria_pregunta", array("cap_id_enc" => $id_encuesta));
                if (!empty($get_categoria_encuesta)) {
                    foreach ($get_categoria_encuesta as $key6 => $value6) {
                        unset($value6["cap_id"]);
                        $value6["cap_id_enc"] = $nuevo_id_encuesta;
                        $value6["cap_usu_creacion"] = $this->tank_auth->get_user_id();
                        $value6["cap_fecha_creacion"] = date('Y-m-d H:i:s');
                        $value6["cap_usu_modificacion"] = $this->tank_auth->get_user_id();
                        $value6["cap_fecha_modificacion"] = date('Y-m-d H:i:s');

                        $new_categoria_encuesta[$key5] = $this->gsatelite->ingresar('cap_categoria_pregunta', $value6);
                }//fin categoria foreach
            }

            $array_info = array(
                'id_encuesta' => $nuevo_id_encuesta,
                'id_preguntas' => $repuesta["id_pregunta"],
                'id_opc_resp' => $repuesta["id_opc_resp"],
                'id_opc_dinamicas' => $repuesta["id_opc_dinamicas"],
                'id_encuesta_grupo' => $new_encuesta_grupo_id,
                'id_links' => $new_link,
                'id_cat_encuesta' => $new_categoria_encuesta
            );

            echo json_encode($array_info);
            die();

        }
        $data["id_encuesta"] = $id_encuesta;
        
        //cargarvista($data);
        $this->gsatelite->cargar_vista_masterpage('encuesta/procesos/duplicar_encuesta',$data, null);
    }

    /**
    * @return accion duplicadora de preguntas
    * @author Marlon Olmedo - Grupo Satelite
    * @since 19-12-2020
    */
    public function duplicacion_pregunta_bk($datos = null, $id_encuesta_old = null,$id_encuesta_new,$is_pregunta_old = null)
    { 
        satelite_validar();
        //si encuesta old viene vacio, es duplicacion de pregunta, si viene con datop es duplicacion de encuesta
        if($id_encuesta_old != null){
            $preguntas = $this->gsatelite->get_tabla("pre_pregunta", array("pre_id_enc" => $id_encuesta_old));
            $ult_orden = null;
        } else {
            $preguntas = $this->gsatelite->get_tabla("pre_pregunta", array("pre_id" => $is_pregunta_old));
            //la ultima pregunta del segun orden y tomamos su numero
            $this->db->order_by("pre_orden desc");
            $ult_orden = $this->gsatelite->get_tabla("pre_pregunta", array("pre_id_enc" => $id_encuesta_new))[0]["pre_orden"];
        }
        //print_r($this->db->last_query());die();
        
        if (!empty($preguntas)) {
            foreach ($preguntas as $key1 => $value1) {
                $pregunta_id_old = $value1["pre_id"];
                //print_r($value1);
                //print_r("<br><br>");
                unset($value1["pre_id"]);

                $value1["pre_id_enc"] = $id_encuesta_new;
                $value1["pre_nombre"] = ($datos != null)? $datos["nombre"] : $value1["pre_nombre"];
                $value1["pre_orden"] = ($ult_orden != null)?  $ult_orden + 1 : $value1["pre_orden"];
                $value1["pre_usu_creacion"] = $this->tank_auth->get_user_id();
                $value1["pre_fecha_creacion"] = date('Y-m-d H:i:s');
                $value1["pre_usu_modificacion"] = $this->tank_auth->get_user_id();
                $value1["pre_fecha_modificacion"] = date('Y-m-d H:i:s');

                //print_r($value1);die();
                $new_preguntas[$key1] = $this->gsatelite->ingresar('pre_pregunta', $value1);

                $opciones_res_tab_d = $this->gsatelite->get_tabla("opr_opcion_respuesta", array("opr_id_pre" => $pregunta_id_old));
                if (!empty($opciones_res_tab_d)) {
                    foreach ($opciones_res_tab_d as $key2 => $value2) {
                        $resp_tab_old = $value2["opr_id"];

                        unset($value2["opr_id"]);
                        $value2["opr_id_pre"] = $new_preguntas[$key1];
                        $value2["opr_usu_creacion"] = $this->tank_auth->get_user_id();
                        $value2["opr_fecha_creacion"] = date('Y-m-d H:i:s');
                        $value2["opr_usu_modificacion"] = $this->tank_auth->get_user_id();
                        $value2["opr_fecha_modificacion"] = date('Y-m-d H:i:s');

                        $new_resp_tab_d[$key2] = $this->gsatelite->ingresar('opr_opcion_respuesta', $value2);

                        if ($value2["opr_tipo_campo_dinamico"] == 2 || $value2["opr_tipo_campo_dinamico"] == 3) {
                            $datos_tab_dinamica = $this->gsatelite->get_tabla("otd_opcion_tabla_dinamica", array("otd_id_opr" => $resp_tab_old));
                            if (!empty($datos_tab_dinamica)) {
                                foreach ($datos_tab_dinamica as $key3 => $value3) {
                                    $opc_tab_di_old = $value3["otd_id"];

                                    unset($value3["otd_id"]);
                                    $value3["otd_id_opr"] = $new_resp_tab_d[$key2];
                                    $value3["otd_usu_creacion"] = $this->tank_auth->get_user_id();
                                    $value3["otd_fecha_creacion"] = date('Y-m-d H:i:s');
                                    $value3["otd_usu_modificacion"] = $this->tank_auth->get_user_id();
                                    $value3["otd_fecha_modificacion"] = date('Y-m-d H:i:s');

                                    $new_opc_tab_dinamica[$key3] = $this->gsatelite->ingresar('otd_opcion_tabla_dinamica', $value3);
                                } //fin opciones dinamicas
                            }
                        }

                    } //fin repuestas dinamicas
                }

            } //fin de las preguntas

            $info = array(
                'id_pregunta' => $new_preguntas,
                'id_opc_resp' => $new_resp_tab_d,
                'id_opc_dinamicas' => $new_opc_tab_dinamica
            );
            
            return $info;
        } else {
            $info = array(
                'id_pregunta' => null,
                'id_opc_resp' => null,
                'id_opc_dinamicas' => null
            );

            return $info;
        }
    }

    /**
    * @return vista para duplicacion de pregunta
    * @author Marlon Olmedo - Grupo Satelite
    * @since 19-12-2020
    */
    public function duplicacion_pregunta($id_pregunta = null,$id_encuesta = null)
    { 
        satelite_validar();
        if ($this->input->post()) {
            $id_pregunta = $this->input->post("id_pregunta");
            $nombre_pregunta = $this->input->post("nombre");
            $id_encuesta = $this->input->post("id_encuesta");

            $repuesta = $this->duplicacion_pregunta_bk(array('nombre' => $nombre_pregunta),null,$id_encuesta,$id_pregunta);

            echo json_encode($repuesta);
            die();
        }
        $data["id_pregunta"] = $id_pregunta;
        $data["id_encuesta"] = $id_encuesta;
        
        //cargarvista($data);
        $this->gsatelite->cargar_vista_masterpage('encuesta/procesos/duplicacion_pregunta',$data, null);
    }

    /**
    * @author René Castaneda - Grupo Satelite
    * @since 21-12-2020
    * @return array json
    */
    public function cargar_img_respuesta()
    {   
        $respuesta['exito'] = 0;
        if (!isset($_FILES['img_respuesta'])) {
            $respuesta['msj'] = 'Seleccione una imagen';
            die(json_encode($respuesta));
        }
        $config['upload_path']   = 'uploads/temp/anx_temporales';
        $config['allowed_types'] = "gif|jpg|jpeg|png|PNG";
        $config['max_size'] = "204800";
        $config['remove_spaces'] = true;
        $config['_file_name_override'] = 'imagen_respuesta_'.date("YmdHis");
        if (!is_dir($config['upload_path'])) {
            $respuesta['msj'] = 'El directorio de carga no existe';
            die(json_encode($respuesta));
        }
        $this->load->library('upload', $config);

        if (!$this->upload->do_upload('img_respuesta')) {
            $respuesta['msj'] = $this->upload->display_errors();
            die(json_encode($respuesta));
        } else { 
            $info=$this->upload->data();
            $respuesta['nombre_archivo'] = $info['file_name'];
            $respuesta['carpeta_archivo'] = $config['upload_path'];
            $respuesta['ruta_archivo_full'] = base_url($config['upload_path'].'/'.$info['file_name']);
            $respuesta['ruta_archivo_relative'] = $config['upload_path'].'/'.$info['file_name'];
            $respuesta['exito'] = 1;
            die(json_encode($respuesta));
        }
    }

    /**
    * @author René Castaneda - Grupo Satelite
    * @since 21-12-2020
    * @return array json
    */
    public function delete_img_respuesta($ruta_imagen='',$return=null)
    {
        $respuesta['exito'] = 0;
        $ruta_imagen = (trim($this->input->post('ruta_imagen_res')) !='')? $this->input->post('ruta_imagen_res'):$ruta_imagen;
        if ($ruta_imagen != '' &&  file_exists($ruta_imagen)) {
            unlink($ruta_imagen);
            $respuesta['exito'] = 1;
        }
        if ($return) {
         return $respuesta;
     }
     die(json_encode($respuesta));
 }

    /**
    * @author René Castaneda - Grupo Satelite
    * @since 21-12-2020
    * @return array json
    */
    public function validar_clasificacion($ruta_imagen='',$return=null)
    {
        $respuesta['exito'] = 0;
        if ($this->input->post('clasificacion') > 0) {
            $q = $this->gsatelite->get_tabla('cla_clasificacion_encuesta', array('cla_id_padre'=>$this->input->post('clasificacion')));
            $respuesta['exito'] = (count($q) > 0)? 0:1;
        }
        die(json_encode($respuesta));
    }

    /**
    * @author René Castaneda - Grupo Satelite
    * @since 03-01-2021
    * @return array json
    */
    public function test_offline($idEncuesta = 0)
    {
     $respuesta['exito'] = 0;
     $id_encuesta = ($idEncuesta > 0)? $idEncuesta:$this->input->post('idEncuesta');
     if ($id_encuesta > 0) {
      $q = $this->gsatelite->get_tabla('enc_encuesta',array('enc_id'=>$id_encuesta));
      $respuesta['exito'] = ($q)? 1:0;
  }
       ob_end_clean();//limpiar la cabecera (por alguna razón se imprime algo antes del die)
       header('Content-Type: application/json; charset=utf-8');
       die(json_encode($respuesta));
   }

    /**
    * @author René Castaneda - Grupo Satelite
    * @since 22-12-2020
    * @return html view - Descargar información horizontal
    */
    function descarga_informacion() {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();
        $data['sucursal'] = $this->gsatelite->get_dropdown('suc_sucursal', '{suc_nombre}', '', null, null, '', 'suc_id', true);
        $data['permisos'] = $permisos;
        $data['titulo_personal'] = "Descargar información de encuesta";
        cargarvista($data);
    }


        /**
         * @return Mantenimiento de Exclusión de categoria Encuestas
         * @author Rene Castaneda
         */
        public function exclusion_categoria($id_encuesta=0)
        {
            satelite_validar();
            $reg = $this->gsatelite->get_tabla("enc_encuesta", array("enc_id"=>$id_encuesta));
            if(!$reg)
                $this->gsatelite->show_dialog("Petición incorrecta", "encuesta/", 'error');

            $permisos = $this->gsatelite->get_permisos_opcion('gestion_encuesta');
            $crud = new grocery_CRUD();

            $crud->set_table('exc_exclusion_categoria')
            ->set_subject('Exclusión')
            ->columns('exc_id_enc', 'exc_id_cap', 'exc_observacion', 'exc_estado')
            ->add_fields('exc_id_enc', 'exc_id_cap', 'exc_observacion', 'exc_estado', 'exc_usu_creacion', 'exc_usu_modificacion', 'exc_fecha_creacion', 'exc_fecha_modificacion')
            ->edit_fields('exc_id_enc', 'exc_id_cap', 'exc_observacion', 'exc_estado', 'exc_usu_modificacion', 'exc_fecha_modificacion')
            ->display_as('exc_id_enc', 'Encuesta')
            ->display_as('exc_id_cap', 'Categoría excluir')
            ->display_as('exc_observacion', 'Observación')
            ->display_as('exc_estado', 'Estado')
            ->where('exc_id_enc',$id_encuesta)
            ->set_relation('exc_id_enc', 'enc_encuesta ', '{enc_nombre}', array('enc_estado' => 1))
            ->set_relation('exc_id_cap', 'cap_categoria_pregunta ', '{cap_nombre}', array('cap_estado' => 1))
            ->required_fields('exc_id_enc', 'exc_id_cap', 'exc_estado')
            ->set_rules('exc_id_cap', 'Categoria', 'trim|required|campo_unico2[exc_exclusion_categoria.exc_id_cap.exc_id_enc.$id_encuesta]')
            ->field_type('exc_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
            ->field_type('exc_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
            ->field_type('exc_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
            ->field_type('exc_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
            ;

            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('exc_estado', 'hidden', 1);
            } else {
                $crud->field_type('exc_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            $data['titulo_personal'] = "Exclusión Categoría Encuesta";
            $data['reg'] = $reg[0];
                // Validaciones
            $crud->unset_edit();
            $crud->unset_delete();
                //if (!$permisos['permite_agregar']) {
                //    $crud->unset_add();
                //}
                if ($permisos['permite_editar']) { //edición pendiente
                  //  $crud->add_action('Editar', '', 'encuesta/procesos/editar_exclusion_categoria_pregunta', 'icomoon-icon-pencil-5');
                }
                //if ($permisos['permite_eliminar']) {
                $crud->add_action('Eliminar', '', 'encuesta/procesos/eliminar_exclusion_categoria_pregunta', 'icon16 icomoon-icon-remove eliminarRegistro');
                //}
                
                $output = $crud->render();
                cargarvista($data, $output,'encuesta/procesos/exclusion_categoria');
            }

    // End function exclusion_categoria


    /**
    * @author René Castaneda - Grupo Satelite
    * @since 09-01-2021
    * @return view
    */
    public function exclusion_categoria_pregunta($id_encuesta=0)
    {
        satelite_validar();
        $registro_encuesta = $this->gsatelite->get_tabla('enc_encuesta',array('enc_id'=>$id_encuesta));
        if ($_POST) {
            $categoria = $this->input->post('categoria');
            $id_encuesta = $this->input->post('id_encuesta');
            $observacion = $this->input->post('observacion');
            $tipo_accion = $this->input->post('tipo_accion');
            
            $array_insert = array(
              'exc_id_cap' => $categoria
              , 'exc_id_enc' => $id_encuesta
              , 'exc_observacion' => (trim($observacion) != '') ? trim($observacion) : null
              , 'exc_estado' => 1
              , 'exc_usu_creacion' => $this->tank_auth->get_user_id()
              , 'exc_fecha_creacion' => date('Y-m-d H:i:s')
              , 'exc_usu_modificacion' => $this->tank_auth->get_user_id()
              , 'exc_fecha_modificacion' => date('Y-m-d H:i:s')
          );
            $pregunta = $this->input->post('detalle_pre');
            $opcion = $this->input->post('detalle_res');
            if (count($pregunta) > 0) { 
                $id_exclusion= $this->gsatelite->ingresar('exc_exclusion_categoria', $array_insert);
                for ($i = 0; $i < count($pregunta); $i++) {
                    if ($pregunta[$i] > 0 ) {
                        $insert_opc = array(
                            'dex_id_exc' => $id_exclusion
                            , 'dex_id_pre' => $pregunta[$i]
                            , 'dex_id_opr' => ($opcion[$i] > 0)? $opcion[$i]:null
                            , 'dex_estado' => 1
                            , 'dex_usu_creacion' => $this->tank_auth->get_user_id()
                            , 'dex_fecha_creacion' => date('Y-m-d H:i:s')
                            , 'dex_usu_modificacion' => $this->tank_auth->get_user_id()
                            , 'dex_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $id_detalle = $this->gsatelite->ingresar('dex_detalle_exclusion', $insert_opc);
                    }
                }
            }

            if (isset($id_exclusion) && $id_exclusion > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro Agregado", 'texto_alerta' => "Registro agregado correctamente");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error al Guardar", 'texto_alerta' => "No se pudo guardar el registro, favor verificar e intentar nuevamente");
            }
            $this->session->set_flashdata($alerta);
            if ($tipo_accion == 1) {
                redirect('encuesta/procesos/exclusion_categoria/' . $id_encuesta);
            } else {
                redirect("encuesta/procesos/exclusion_categoria_pregunta/$id_encuesta");
            }

        }
        $this->db->order_by('pre_orden ASC');
        $preguntas = $this->gsatelite->get_tabla('pre_pregunta', array('pre_id_enc' => $id_encuesta));
        if (!$preguntas) {
            $this->gsatelite->show_dialog("Encuesta sin preguntas", "encuesta/procesos/gestion_encuesta/", 'error');
        }      
        $this->db->join('pre_pregunta','pre_id_cap=cap_id'); 
        $this->db->group_by('cap_id');
        $this->db->where("cap_id NOT IN (SELECT exc_id_cap FROM exc_exclusion_categoria WHERE exc_id_enc=$id_encuesta)",null, false);
        $cat = $this->gsatelite->get_dropdown('cap_categoria_pregunta', '{cap_nombre}', '', array("pre_id_enc"=>$id_encuesta), null, '', 'cap_id', true);
        $data['categoria'] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $cat);
        $data['preguntas'] = $preguntas;
        $data['registro'] = $registro_encuesta[0];
        $data['titulo_personal'] = 'Configurar exclusión preguntas';
        cargarvista($data);
    }


    /**
    * @author René Castaneda - Grupo Satelite
    * @since 09-01-2021
    * @return view
    */
    public function editar_exclusion_categoria_pregunta($exc_id=0)
    {
        satelite_validar();
        $reg = $this->gsatelite->get_tabla("exc_exclusion_categoria", array("exc_id"=>$exc_id));
        if(!$reg)
            $this->gsatelite->show_dialog("Petición incorrecta", "encuesta/", 'error');

        $registro_encuesta = $this->gsatelite->get_tabla('enc_encuesta',array('enc_id'=>$reg[0]['exc_id_enc']));
        $id_encuesta = $reg[0]['exc_id_enc'];
        if ($_POST) {
            $categoria = $this->input->post('categoria');
            $id_encuesta = $this->input->post('id_encuesta');
            $exc_id = $this->input->post('exc_id');
            $observacion = $this->input->post('observacion');
            $tipo_accion = $this->input->post('tipo_accion');
            $estado = $this->input->post('estado');
            
            $array_update = array(
              'exc_id_cap' => $categoria
              , 'exc_observacion' => (trim($observacion) != '') ? trim($observacion) : null
              , 'exc_estado' => $estado
              , 'exc_usu_modificacion' => $this->tank_auth->get_user_id()
              , 'exc_fecha_modificacion' => date('Y-m-d H:i:s')
          );
            $pregunta = $this->input->post('detalle_pre');
            $opcion = $this->input->post('detalle_res');
            if (count($pregunta) > 0) { 
                $this->gsatelite->actualizar_array('exc_exclusion_categoria', $array_update,array('exc_id'=>$exc_id));
                $this->gsatelite->borrado_general('dex_detalle_exclusion',array('dex_id_exc'=>$exc_id));
                for ($i = 0; $i < count($pregunta); $i++) {
                    if ($pregunta[$i] > 0 ) {
                        $insert_opc = array(
                            'dex_id_exc' => $exc_id
                            , 'dex_id_pre' => $pregunta[$i]
                            , 'dex_id_opr' => ($opcion[$i] > 0)? $opcion[$i]:null
                            , 'dex_estado' => 1
                            , 'dex_usu_creacion' => $this->tank_auth->get_user_id()
                            , 'dex_fecha_creacion' => date('Y-m-d H:i:s')
                            , 'dex_usu_modificacion' => $this->tank_auth->get_user_id()
                            , 'dex_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $id_detalle = $this->gsatelite->ingresar('dex_detalle_exclusion', $insert_opc);
                    }
                }
            }

            if (isset($exc_id) && $exc_id > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro actualizado", 'texto_alerta' => "Registro actualizado correctamente");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error al actualizar", 'texto_alerta' => "No se pudo actualizar el registro, favor verificar e intentar nuevamente");
            }
            $this->session->set_flashdata($alerta);
            if ($tipo_accion == 1) {
                redirect('encuesta/procesos/exclusion_categoria/' . $id_encuesta);
            } else {
                redirect("encuesta/procesos/editar_exclusion_categoria_pregunta/$exc_id");
            }

        }
        $this->db->order_by('pre_orden ASC');
        $preguntas = $this->gsatelite->get_tabla('pre_pregunta', array('pre_id_enc' => $id_encuesta));
        if (!$preguntas) {
            $this->gsatelite->show_dialog("Encuesta sin preguntas", "encuesta/procesos/gestion_encuesta/", 'error');
        }      
        $this->db->join('pre_pregunta','pre_id_cap=cap_id'); 
        $this->db->group_by('cap_id');
        $cat = $this->gsatelite->get_dropdown('cap_categoria_pregunta', '{cap_nombre}', '', array("pre_id_enc"=>$id_encuesta), $reg[0]['exc_id_cap'], '', 'cap_id', true);

        $this->db->join('pre_pregunta','pre_id=dex_id_pre');
        $this->db->join('opr_opcion_respuesta','opr_id=dex_id_opr', 'left');
        $detalles = $this->gsatelite->get_tabla("dex_detalle_exclusion", array('dex_id_exc'=>$exc_id));

        $data['categoria'] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $cat);
        $data['preguntas'] = $preguntas;
        $data['registro'] = $registro_encuesta[0];
        $data['detalle'] = $detalles;
        $data['titulo_personal'] = 'Editar - Configurar exclusión preguntas';
        cargarvista($data);
    }


    /**
    * @author René Castaneda - Grupo Satelite
    * @since 09-01-2021
    * @return view
    */
    public function eliminar_exclusion_categoria_pregunta($exc_id=0)
    {
        satelite_validar();
        $reg = $this->gsatelite->get_tabla("exc_exclusion_categoria", array("exc_id"=>$exc_id));
        if(!$reg)
            $this->gsatelite->show_dialog("Petición incorrecta", "encuesta/", 'error');

        $this->gsatelite->borrado_general('dex_detalle_exclusion',array('dex_id_exc'=>$exc_id));
        $this->gsatelite->borrado_general('exc_exclusion_categoria',array('exc_id'=>$exc_id));
        $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro Eliminado", 'texto_alerta' => "Registro eliminado correctamente");
        $this->session->set_flashdata($alerta);
        redirect('encuesta/procesos/exclusion_categoria/' . $reg[0]['exc_id_enc']);
    }

    public function preguntas_categoria_enc()
    {
        $respuesta['exito'] = 0;
        $cat = $this->input->post('categoria');
        $id_enc = $this->input->post('id_enc');
        if ($cat > 0  && $id_enc > 0) {
            $respuesta['exito'] = 1;
            $option_pre = $this->gsatelite->get_dropdown('pre_pregunta', '{pre_nombre}', '', array('pre_id_cap !=' => $cat,'pre_tipo'=>2,"pre_id_enc"=>$id_enc), null, '', 'pre_id', true);
            $respuesta['html_option'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $option_pre);
        }
        die(json_encode($respuesta));
    }

    public function respuesta_pregunta_enc()
    {
        $respuesta['exito'] = 0;
        $pre = $this->input->post('id_pre');
        if ($pre > 0) {
            $respuesta['exito'] = 1;
                          $this->db->where('IFNULL(opr_finalizar_encuesta,0)',0); //omitir las respuestas que finalizan la encuesta.
                          $option_res = $this->gsatelite->get_dropdown('opr_opcion_respuesta', '{opr_nombre}', '', array('opr_id_pre' => $pre), null, '', 'opr_id', true);
                          $respuesta['html_option'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $option_res);
                      }
                      die(json_encode($respuesta));
                  }
    /**
     * @return Mantenimiento de Encuestas
     * @since 05/04/2021
     * @author Rene Castaneda
     * @return file .js
     */
    public function generarFileOffline($tipoAction=1)
    {
        if ($tipoAction == 2) {
            $template = file_get_contents('scripts/plantilla_encuesta/offline/offlineWorker.js');
            //include('scripts/plantilla_encuesta/offline/offlineWorker.js');
            if (ob_get_contents()) ob_end_clean();
            header('Content-Type: application/javascript');
            echo $template;
            die();
        }
       // $baseUrlJs =  base_url(); 
        $baseUrlJs =  str_replace('index.php', '', $_SERVER['PHP_SELF']); 
        $urlEncuesta =  uri_string().'/'; 
        $logoImg = $this->gsatelite->get_parametro('SYS_LOGOTIPO');
        $template = file_get_contents('scripts/plantilla_encuesta/offline/offlineWorker_template.js');
        $new = str_replace(array('{baseUrlJs}','{urlEncuesta}','{logoImg}'), array($baseUrlJs,$urlEncuesta,$logoImg), $template);
        $file = "scripts/plantilla_encuesta/offline/offlineWorker.js";
        if (file_exists($file)) {
            unlink($file);
        }
        file_put_contents($file, $new);
    }

    public function guardar_gral($parametros, $carpeta = null, $mimes = null) {
        $carpeta = $parametros;
        //var_dump($mimes);
        if ($mimes != null) {
            $mimes = str_replace('-', '|', $mimes);
            $image = $this->upload_gral($carpeta, $mimes);
        } else {
            $image = $this->upload_gral($carpeta);
        }
        //$this->session->keep_flashdata('datos_1');
        //echo $image['upload_data']['raw_name'] . $image['upload_data']['file_ext'];
        // echo $image['upload_data']['file_name'];
        echo json_encode($image['upload_data']);

    }

    function upload_gral($carpeta, $mimes = null) {
        $ruta = FCPATH . "public/temp/" . $carpeta;
        if (!file_exists($ruta)) {
            mkdir($ruta, 0777);
        }

        $obj = &get_instance();
        $config['upload_path'] = $ruta;
        if ($mimes != null) {
            $config['allowed_types'] = $mimes;
        } else {
            $config['allowed_types'] = 'pdf|jpg|png|jpeg|doc|xls|docx|xlsx|zip|rar|txt';
        }

        $obj->load->library('upload', $config);
        if (!$obj->upload->do_upload()) {
            $error = array('error' => $obj->upload->display_errors());
            return true;
        } else {
            $data = array('upload_data' => $obj->upload->data());
            return $data;
        }
        print_r($data);
    }    

}

/* End of file procesos.php */
/* Location: ./application/controllers/portal_inventario/procesos.php */