<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Catalogos extends CI_Controller {

    function __construct() {
        parent::__construct();
        $this->load->library('grocery_CRUD');
        $this->load->model('gsatelite');
        $this->load->model('encuesta_model');
        satelite_validar();
    }

    public function index() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $this->_cargarvista();
        }
    }


    /**
     * @author Rene Castaneda
     * @return Mantenimiento de Categoria preguntas
     */
    public function categoria_pregunta($id_enc=0) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            try {
                $permisos= $this->gsatelite->get_permisos_opcion('categoria_pregunta');
                
                $crud = new grocery_CRUD();
                $crud->set_table('cap_categoria_pregunta')
                        ->set_subject('')
                        ->columns('cap_nombre','cap_id_enc' ,'cap_estado')
                        ->add_fields('cap_nombre', 'cap_estado', 'cap_usu_creacion', 'cap_usu_modificacion', 'cap_fecha_creacion', 'cap_fecha_modificacion',"cap_id_enc")
                        ->edit_fields('cap_nombre', 'cap_estado', 'cap_usu_modificacion', 'cap_fecha_modificacion',"cap_id_enc")
                        ->set_relation('cap_id_enc', 'enc_encuesta', '{enc_nombre}', array('enc_estado' => 1))
                        ->display_as('cap_nombre', 'Nombre')
                        ->display_as('cap_id_enc', 'Encuesta')
                        ->display_as('cap_estado', 'Estado')
                        ->required_fields('cap_nombre', 'cap_estado')
                        //->set_rules('cap_id_enc', 'Encuesta', 'trim|required')
                        ->field_type('cap_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                        ->field_type('cap_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                        ->field_type('cap_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
                        ->field_type('cap_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
                ;

                $data['titulo_personal'] = "Categoría Pregunta";
                if($id_enc > 0){
                    //print_r($id_enc);die();
                    $crud->where ( 'cap_id_enc' , $id_enc ) ;
                    $crud->set_relation('cap_id_enc', 'enc_encuesta', '{enc_nombre}', array('enc_estado' => 1,'enc_id'=>$id_enc));
                    $crud->set_rules('cap_nombre', 'Nombre', 'trim|required|campo_unico2[cap_categoria_pregunta.cap_nombre.cap_id_enc]');
                    $crud->field_type('cap_id_enc', 'hidden', $id_enc);
                    $query= $this->gsatelite->get_tabla('enc_encuesta', array('enc_id' => $id_enc));
                    $data['titulo_personal'].=' -> Encuesta: '.$query[0]['enc_nombre'];
                } else {
                    $crud->set_rules('cap_nombre', 'Nombre', 'trim|required|campo_unico[cap_categoria_pregunta.cap_nombre]');
                    //$crud->field_type('cap_id_enc', 'hidden', null);
                    $crud->set_relation('cap_id_enc', 'enc_encuesta', '{enc_nombre}', array('enc_estado' => 1));
                }

                if (end(explode('/', uri_string())) == 'add') {
                    $crud->field_type('cap_estado', 'hidden', 1);
                } else {
                    $crud->field_type('cap_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
                }

               
                //$crud->unset_print()->unset_export();
                // Validaciones
                if(!$permisos['permite_agregar']) { $crud->unset_add();} 
                if(!$permisos['permite_editar']) { $crud->unset_edit();}
                if(!$permisos['permite_eliminar']) { $crud->unset_delete();} 
                if($permisos['permite_ver']) {
                  $crud->add_action('Ver','minia-icon-search','encuesta/catalogos/categoria_pregunta/read');
                 }     

                $output = $crud->render();
                cargarvista($data, $output);
            } catch (Exception $e) {
                show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
            }
        }
    } // End function categoria_pregunta


    /**
     * @author Rene Castaneda
     * @return Mantenimiento de Iconos
     */
    public function iconos() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            try {
                $permisos= $this->gsatelite->get_permisos_opcion('iconos');
                
                $crud = new grocery_CRUD();
                $this->load->config('grocery_crud');
                $this->config->set_item('grocery_crud_file_upload_allow_file_types','jpeg|jpg|png');
                $crud->set_table('ico_icono')
                        ->set_subject('')
                        ->columns('ico_nombre', 'ico_url', 'ico_estado')
                        ->add_fields('ico_nombre', 'ico_url', 'ico_estado', 'ico_usu_creacion', 'ico_usu_modificacion', 'ico_fecha_creacion', 'ico_fecha_modificacion')
                        ->edit_fields('ico_nombre', 'ico_url', 'ico_estado', 'ico_usu_modificacion', 'ico_fecha_modificacion')
                        ->display_as('ico_nombre', 'Nombre')
                        ->display_as('ico_estado', 'Estado')
                        ->display_as('ico_url', 'Icono')
                        ->required_fields('ico_nombre', 'ico_url', 'ico_estado')
                        ->set_rules('ico_nombre', 'Nombre', 'trim|required|campo_unico[ico_icono.ico_nombre]')
                        ->field_type('ico_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                        ->field_type('ico_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                        ->field_type('ico_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
                        ->field_type('ico_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
                        ->set_field_upload('ico_url','uploads/encuesta/iconos')
                ;
                if (end(explode('/', uri_string())) == 'add') {
                    $crud->field_type('ico_estado', 'hidden', 1);
                } else {
                    $crud->field_type('ico_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
                }

                $data['titulo_personal'] = "Iconos";
                $data['url_grid'] = base_url('encuesta/catalogos/iconos');
                //$crud->unset_print()->unset_export();
                // Validaciones
                if(!$permisos['permite_agregar']) { $crud->unset_add();} 
                if(!$permisos['permite_editar']) { $crud->unset_edit();}
                if(!$permisos['permite_eliminar']) { $crud->unset_delete();} 
                if($permisos['permite_ver']) {
                  $crud->add_action('Ver','minia-icon-search','encuesta/catalogos/iconos/read');
                 }     

                $output = $crud->render();
                cargarvista($data, $output);
            } catch (Exception $e) {
                show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
            }
        }
    } // End function iconos

    /**
     * @author Rene Castaneda
     * @since  22-12-2020
     * @return Mantenimiento de Clasificación encuesta
     */
    public function clasificacion_encuesta($flag=null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            try {
                $slcNivel = $this->input->post('slcNivel');
                $slcDependencia = $this->input->post('slcDependencia');
                $IdDependencias = "";
                $slcDependencia = ($slcDependencia != '*') ? $slcDependencia : null;
                $slcNivel = ($slcNivel != '*') ? $slcNivel : null;
                if($slcDependencia != null || $slcDependencia !=''){
                    $IdDependencias .= $slcDependencia.',';
                }
                $IdDependencias .= $this->gsatelite->get_ids_cuentas_hijas($slcDependencia);
                $permisos= $this->gsatelite->get_permisos_opcion();
                $where_relation['cla_estado'] = 1;
                if (end(explode('/', uri_string())) > 0 && substr_count(uri_string(), 'edit') > 0) {
                     $id_edit =  end(explode('/', uri_string()));
                     $where_relation['cla_id !='] = $id_edit;
                 } 
                $array_padres = $this->get_dependencias($where_relation);
                $IdDependencias= rtrim($IdDependencias, ",");
                $crud = new grocery_CRUD();
                $crud->set_table('cla_clasificacion_encuesta')
                        ->set_subject('')
                        ->columns('cla_nombre','cla_id_padre','cla_id_niv' ,'cla_estado')
                        ->add_fields('cla_nombre','cla_id_padre','cla_tipo','cla_nota_minima','cla_meta','cla_meta_mensual','cla_unidad_medida','cla_id_niv','cla_id_per','cla_id_tpd', 'cla_estado', 'cla_usu_creacion', 'cla_usu_modificacion', 'cla_fecha_creacion', 'cla_fecha_modificacion')
                        ->edit_fields('cla_nombre','cla_id_padre','cla_tipo','cla_nota_minima','cla_meta','cla_meta_mensual','cla_unidad_medida','cla_id_niv', 'cla_id_per','cla_id_tpd', 'cla_estado', 'cla_usu_modificacion', 'cla_fecha_modificacion')
                        ->field_type('cla_id_padre', 'dropdown', $array_padres)
                        ->set_relation('cla_id_per', 'per_periodo', '{per_nombre}', array())
                        ->set_relation('cla_id_niv', 'niv_nivel_clasificacion', '{niv_orden} - {niv_nombre}', array('niv_estado'=>1))

                        ->set_relation('cla_id_tpd', 'tpd_tipo_dato', '{tpd_nombre}', array())
                        ->display_as('cla_nombre', 'Nombre')
                        ->display_as('cla_id_padre', 'Dependencia')
                        ->display_as('cla_tipo', 'Tipo')
                        ->display_as('cla_id_niv', 'Nivel')
                        ->display_as('cla_nota_minima', 'Nota minima')
                        ->display_as('cla_meta', 'Meta Final')
                        ->display_as('cla_meta_mensual', 'Meta Mensual')
                        ->display_as('cla_unidad_medida', 'Unidad medida')
                        ->display_as('cla_estado', 'Estado')
                        ->display_as('cla_id_per', 'Período')
                        ->display_as('cla_id_tpd', 'Tipo dato')
                        ->required_fields('cla_nombre','cla_id_niv', 'cla_estado')
                        ->field_type('cla_tipo', 'dropdown', array('1' => 'Conteo', '2' => 'Condicional'))
                        //->field_type('cla_tipo_datpo', 'dropdown', array('1' => 'Porcentaje', '2' => 'Numero Absoluto'))
                        ->set_rules('cla_nombre', 'Nombre', 'trim|required|campo_unico[cla_clasificacion_encuesta.cla_nombre]')
                        //->set_rules('cla_tipo_datpo', 'Nombre', 'trim','numeric')
                        ->field_type('cla_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                        ->field_type('cla_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                        ->field_type('cla_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
                        ->field_type('cla_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
                        ->unset_edit()
                        //->unset_delete()
                ;

                $crud->callback_column('cla_nombre', function ($value, $row) {
                    if (!empty($value)) {
                        return $value;
                    } else {
                        // Make sure that you return white space or else the cell may break on print layout
                        return '&nbsp;';
                    }
                });
                $crud->order_by('cla_id', 'ASC');

                if(count($array_padres)==0){
                    $crud->field_type('cla_id_padre','hidden',null);
                }


                if($slcNivel!=null ||  $slcNivel != ""){
                    $crud->where(array('cla_id_niv ='. $slcNivel.'' => null));
                }

                if($IdDependencias!=null){
                    $crud->where('cla_id IN( '.$IdDependencias.')');
                }
                $data['titulo_personal'] = "Marco Lógico";
                $data['band']=1;

                $data['slcNivel']=str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $this->gsatelite->get_dropdown('niv_nivel_clasificacion', '{niv_orden} - {niv_nombre}', '', array('niv_estado' => '1'), null, '', 'niv_id', true));

                $data['slcDependencia']=str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $this->gsatelite->get_dropdown('cla_clasificacion_encuesta', '{cla_id} - {cla_nombre}', '', array('cla_estado' => '1', 'cla_id_padre' => null), null, '', 'cla_id', true));

                if (end(explode('/', uri_string())) == 'add') {
                    $crud->field_type('cla_estado', 'hidden', 1);
                    $data['band']=0;
                } else {
                    $crud->field_type('cla_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
                    
                }    
                
                if(substr_count(uri_string(), 'edit') > 0){
                    $data['band']=0;
                }

                // Validaciones
                if(!$permisos['permite_agregar']) { $crud->unset_add();} 
                if($permisos['permite_editar']) { 
                    //$crud->unset_edit();
                    $crud->add_action('Editar','icomoon-icon-pencil-5','encuesta/catalogos/editar_clasificacion_encuesta');
                }
                if(!$permisos['permite_eliminar']) { 
                    $crud->unset_delete();
                    //$crud->add_action('Eliminar','icomoon-icon-remove','encuesta/catalogos/editar_clasificacion_encuesta');
                } 
                if($permisos['permite_ver']) {
                  $crud->add_action('Ver','minia-icon-search','encuesta/catalogos/ver_clasificacion_encuesta');
                 } 
                 $output = $crud->render(); 
                /*#######################################################################################################*/
                if ($flag == null) {
                    cargarvista($data, $output);
                } else {
                    ?>
                        <script>
                        $('[data-toggle="tooltip"]').tooltip({
                            container : 'body'
                        });
                        </script>
                    <?php
                    print($output->output);
                }
                /*#######################################################################################################*/

                
                //cargarvista($data, $output);
            } catch (Exception $e) {
                show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
            }
        }
    } // End function clasificacion_encuesta

    /**
     * @author Marlon Olmedo
     * @since  20-01-2021
     * @return Guardar la clasificacion de la incuesta
     */
    public function guardar_clasificacion_encuesta() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($_POST) {
                //print_r($_POST);die();
                $cla_id_padre = $this->input->post('cla_id_padre');
                $cla_nivel = $this->input->post('cla_id_niv');
                $tipo_dato = $this->input->post('cla_id_tpd');
                $cla_nombre = $this->input->post('cla_nombre');
                $cla_nombre = preg_replace("/['\"]+/", '', $cla_nombre);
                $cla_meta = $this->input->post('cla_meta');
                $unidad_medida = $this->input->post('cla_unidad_medida');
                $tipo = $this->input->post('cla_tipo');
                $nota_minima = $this->input->post('cla_nota_minima');
                $periodo = $this->input->post('cla_id_per');
                $meta_mesual = $this->input->post('cla_meta_mensual');
                $pregunta_condicion = $this->input->post('ppc_id');
                $encuestas = $this->input->post('encuesta_id');
                $pregunta = $this->input->post('pregunta_id');
                $respuesta = $this->input->post('respuesta_id');
                $tipo_accion = $this->input->post('guardar');
                //print_r($_POST);die();
                $array_insert = array(
                  'cla_id_padre' => ($cla_id_padre == '')? null : $cla_id_padre
                , 'cla_id_niv' => ($cla_nivel == '')? null : $cla_nivel
                , 'cla_id_tpd' => ($tipo_dato == '')? null : $tipo_dato
                , 'cla_nombre' => $cla_nombre
                , 'cla_meta' => ($cla_meta == '')? 0 : $cla_meta
                , 'cla_unidad_medida' => ($unidad_medida == '')? null : $unidad_medida
                , 'cla_estado' => 1
                , 'cla_usu_creacion' => $this->tank_auth->get_user_id()
                , 'cla_fecha_creacion' => date('Y-m-d H:i:s')
                , 'cla_usu_modificacion' => $this->tank_auth->get_user_id()
                , 'cla_fecha_modificacion' => date('Y-m-d H:i:s')
                , 'cla_tipo' => ($tipo == '')? null: $tipo 
                , 'cla_nota_minima' => ($nota_minima == '')? 0 : $nota_minima
                , 'cla_id_per' => ($periodo == null)? null : $periodo
                , 'cla_meta_mensual' => ($meta_mesual == '')? 0 : $meta_mesual
                );

                $clasificacion_id = $this->gsatelite->ingresar('cla_clasificacion_encuesta', $array_insert);

                foreach ($pregunta_condicion as $key => $value) {
                    $array_ppc_insert = array(
                        'pcc_id_cla' =>  $clasificacion_id
                        , 'pcc_id_opr' => $respuesta[$key]
                        , 'pcc_estado' => 1
                        , 'pcc_usu_creacion' => $this->tank_auth->get_user_id()
                        , 'pcc_fecha_creacion' => date('Y-m-d H:i:s')
                        , 'pcc_usu_modificacion' => $this->tank_auth->get_user_id()
                        , 'pcc_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $condiciones[$key] = $this->gsatelite->ingresar('pcc_pregunta_condicion_clasificacion', $array_ppc_insert);
                }

                if ($clasificacion_id > 0) {
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro Agregado", 'texto_alerta' => "Registro agregado correctamente");
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error al Guardar", 'texto_alerta' => "No se pudo guardar el registro, favor verificar e intentar nuevamente");
                }

                $this->session->set_flashdata($alerta);

                if ($tipo_accion == 1) {
                    redirect('encuesta/catalogos/guardar_clasificacion_encuesta');
                } else {
                    redirect("encuesta/catalogos/clasificacion_encuesta");
                }

            }
        }
        $data["nivel"] = $this->gsatelite->get_dropdown('niv_nivel_clasificacion', '{niv_orden} - {niv_nombre}', '', array('niv_estado' => '1'), null, '', 'niv_id', true);
        $data["dependecia"] = $this->get_dependencias(["cla_estado" => 1]);
        $data["periodo"] = $this->gsatelite->get_dropdown('per_periodo', '{per_nombre}', '', array('per_estado' => '1'), null, '', 'per_id', true);
        $data["tipo_dato"] = $this->gsatelite->get_dropdown('tpd_tipo_dato', '{tpd_nombre}', '', array('tpd_estado' => '1'), null, '', 'tpd_id', true);
        $data["encuestas"] = $this->gsatelite->get_dropdown('enc_encuesta', '{enc_nombre}', '', array('enc_estado' => '1'), null, '', 'enc_id', true);
        $data['url_grid'] = base_url('encuesta/catalogos/clasificacion_encuesta');
        $data['titulo_personal'] = "Clasificación encuesta";
        cargarvista($data);
    } // End function guardar clasificacion encuesta

     /**
     * @author Marlon Olmedo
     * @since  20-01-2021
     * @return Guardar la clasificacion de la incuesta
     */
    public function editar_clasificacion_encuesta($id_encuesta,$es_ver = 0) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($_POST) {
                // depurar($this->input->post());
                //print_r($_POST);die();
                $tipo_accion = 0;
                $cla_id_padre = $this->input->post('cla_id_padre');
                $cla_nivel = $this->input->post('cla_id_niv');
                $tipo_dato = $this->input->post('cla_id_tpd');
                $cla_nombre = $this->input->post('cla_nombre');
                $cla_meta = $this->input->post('cla_meta');
                $unidad_medida = $this->input->post('cla_unidad_medida');
                $tipo = $this->input->post('cla_tipo');
                $nota_minima = $this->input->post('cla_nota_minima');
                $periodo = $this->input->post('cla_id_per');
                $meta_mesual = $this->input->post('cla_meta_mensual');
                $pregunta_condicion = $this->input->post('ppc_id');
                $encuestas = $this->input->post('encuesta_id');
                $pregunta = $this->input->post('pregunta_id');
                $respuesta = $this->input->post('respuesta_id');
                $tipo_accion = $this->input->post('tipo_accion');

                $estado = $this->input->post('cla_estado');

                $array_insert = array(
                  'cla_id_padre' => ($cla_id_padre == '')? null : $cla_id_padre
                , 'cla_id_niv' => ($cla_nivel == '')? null : $cla_nivel 
                , 'cla_id_tpd' => ($tipo_dato == '')? null : $tipo_dato
                , 'cla_nombre' => $cla_nombre
                , 'cla_meta' => ($cla_meta == '')? 0 : $cla_meta 
                , 'cla_unidad_medida' => ($unidad_medida == '')? null : $unidad_medida
                , 'cla_estado' => $estado
                , 'cla_usu_creacion' => $this->tank_auth->get_user_id()
                , 'cla_fecha_creacion' => date('Y-m-d H:i:s')
                , 'cla_usu_modificacion' => $this->tank_auth->get_user_id()
                , 'cla_fecha_modificacion' => date('Y-m-d H:i:s')
                , 'cla_tipo' => ($tipo == '')? null : $tipo
                , 'cla_nota_minima' => ($nota_minima == '')? 0 : $nota_minima
                , 'cla_id_per' => ($periodo == '')? null : $periodo
                , 'cla_meta_mensual' => ($meta_mesual == '')? 0 : $meta_mesual
                );

                $clasificacion_id = $this->gsatelite->actualizar_array('cla_clasificacion_encuesta', $array_insert, array('cla_id' => $id_encuesta));

                $condiciones_db = $this->gsatelite->get_tabla('pcc_pregunta_condicion_clasificacion',array("pcc_id_cla" => $id_encuesta));
                foreach ($condiciones_db as $key2 => $value2) {
                    if (!in_array($value2["pcc_id"],$pregunta_condicion)) {
                        $this->gsatelite->borrado_general('pcc_pregunta_condicion_clasificacion', array('pcc_id' => $value2["pcc_id"]));
                    }
                }
                foreach ($pregunta_condicion as $key => $value) {
                    if ($value == 0) {
                        $array_ppc_insert = array(
                            'pcc_id_cla' =>  $id_encuesta
                            , 'pcc_id_opr' => $respuesta[$key]
                            , 'pcc_estado' => 1
                            , 'pcc_usu_creacion' => $this->tank_auth->get_user_id()
                            , 'pcc_fecha_creacion' => date('Y-m-d H:i:s')
                            , 'pcc_usu_modificacion' => $this->tank_auth->get_user_id()
                            , 'pcc_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $condiciones[$key] = $this->gsatelite->ingresar('pcc_pregunta_condicion_clasificacion', $array_ppc_insert);
                    } 
                }

                if ($clasificacion_id > 0) {
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro Actualiazado", 'texto_alerta' => "Registro actualizado correctamente");
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error al Actualizar", 'texto_alerta' => "No se pudo actualizar el registro, favor verificar e intentar nuevamente");
                }

                $this->session->set_flashdata($alerta);

                if ($tipo_accion == 1) {
                    redirect('encuesta/catalogos/editar_clasificacion_encuesta/'.$id_encuesta);
                } else if($tipo_accion == 0) {
                    redirect("encuesta/catalogos/clasificacion_encuesta");
                }

            }
        }
        $encuestas = $this->gsatelite->get_tabla('cxe_clasificacionxencuesta', array('cxe_id_cla' => $id_encuesta));
        $encuestas = implode(",",array_column($encuestas,"cxe_id_enc"));
        $data["clasificacion"] = $this->gsatelite->get_tabla('cla_clasificacion_encuesta', array('cla_id' => $id_encuesta));
        $data["condicion_pregunta"] = $this->encuesta_model->get_categoriaxpregunta(array("pcc_id_cla" => $id_encuesta));
        $data["nivel"] = $this->gsatelite->get_dropdown('niv_nivel_clasificacion', '{niv_orden} - {niv_nombre}', '', array('niv_estado' => '1'), $data["clasificacion"][0]["cla_id_niv"], '', 'niv_id', true);
        $data["dependecia"] = $this->get_dependencias(["cla_estado" => 1]);
        $data["periodo"] = $this->gsatelite->get_dropdown('per_periodo', '{per_nombre}', '', array('per_estado' => '1'), $data["clasificacion"][0]["cla_id_per"], '', 'per_id', true);
        $data["tipo_dato"] = $this->gsatelite->get_dropdown('tpd_tipo_dato', '{tpd_nombre}', '', array('tpd_estado' => '1'), $data["clasificacion"][0]["cla_id_tpd"], '', 'tpd_id', true);
        if ($encuestas != null) {
            $where_enc["enc_id IN($encuestas)"] = null;
        }
        $where_enc["enc_estado"] = 1;
        $data["encuestas"] = $this->gsatelite->get_dropdown('enc_encuesta', '{enc_nombre}', '', $where_enc, null, '', 'enc_id', true);
        $data["es_ver"] = $es_ver;
        //print_r($data["dependecia"]);die();
        $data['titulo_personal'] = "Clasificación encuesta";
        $data['url_grid'] = base_url('encuesta/catalogos/clasificacion_encuesta');
        cargarvista($data,null,'encuesta/catalogos/editar_clasificacion_encuesta');
    } // End function guardar clasificacion encuesta

    /**
     * @author Marlon Olmedo
     * @since  20-01-2021
     * @return ver la clasificacion de la incuesta
     */
    public function ver_clasificacion_encuesta($id_encuesta) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $this->editar_clasificacion_encuesta($id_encuesta,1);
        }
    } // End function ver clasificacion encuesta

    /**
     * @author Rene Castaneda
     * @since  27-12-2020
     * @return Mantenimiento de NIvel Clasificación
     */
    public function nivel() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            try {
                $permisos= $this->gsatelite->get_permisos_opcion();
                
                $crud = new grocery_CRUD();
                $crud->set_table('niv_nivel_clasificacion')
                        ->set_subject('')
                        ->columns('niv_nombre','niv_orden','niv_estado')
                        ->add_fields('niv_nombre','niv_orden','niv_estado', 'niv_usu_creacion', 'niv_usu_modificacion', 'niv_fecha_creacion', 'niv_fecha_modificacion')
                        ->edit_fields('niv_nombre','niv_orden','niv_estado', 'niv_usu_modificacion', 'niv_fecha_modificacion')
                        ->display_as('niv_nombre', 'Nombre')
                        ->display_as('niv_estado', 'Estado')
                        ->display_as('niv_orden', 'Orden')
                        ->required_fields('niv_nombre', 'niv_estado')
                        ->set_rules('niv_nombre', 'Nombre', 'trim|required|campo_unico[niv_nivel_clasificacion.niv_nombre]')
                        ->set_rules('niv_orden', 'Orden', 'trim|required|campo_unico[niv_nivel_clasificacion.niv_orden]')
                       // ->field_type('niv_orden', 'hidden', 0)
                        ->field_type('niv_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                        ->field_type('niv_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                        ->field_type('niv_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
                        ->field_type('niv_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
                ;

                $data['titulo_personal'] = "Nivel de Marco Lógico";

                if (end(explode('/', uri_string())) == 'add') {
                    $crud->field_type('niv_estado', 'hidden', 1);
                } else {
                    $crud->field_type('niv_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
                }             

                // Validaciones
                if(!$permisos['permite_agregar']) { $crud->unset_add();} 
                if(!$permisos['permite_editar']) { $crud->unset_edit();}
                if(!$permisos['permite_eliminar']) { $crud->unset_delete();} 
                if($permisos['permite_ver']) {
                  $crud->add_action('Ver','minia-icon-search','encuesta/catalogos/nivel/read');
                 }     

                $output = $crud->render();
                cargarvista($data, $output);
            } catch (Exception $e) {
                show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
            }
        }
    } // End function niv_nivel_clasificacion

    public function validar_nivel()
    {
        $respuesta['id_nivel'] = 0;
        if ($this->input->post('clasificacion') > 0 ) {
            $id_padre = $this->input->post('clasificacion');
            $this->db->join('niv_nivel_clasificacion','niv_id=cla_id_niv');
            $reg_ = $this->gsatelite->get_tabla('cla_clasificacion_encuesta',array('cla_id'=>$id_padre));
            if ($reg_) {
                $orden_new = $reg_[0]['niv_orden'] + 1;
                $reg_nivel = $this->gsatelite->get_tabla('niv_nivel_clasificacion',array('niv_orden'=>$orden_new));
                $respuesta['id_nivel'] = ($reg_nivel)? $reg_nivel[0]['niv_id']:$reg_[0]['niv_id'];
            }
        }
        die(json_encode($respuesta));
    }

    public function validar_nombrenivel()
    {
        $respuesta['participacion'] = 0;
        $nombre = $this->input->post('nombre');
        $nivel = $this->input->post('cla_id_niv');

        $query= $this->gsatelite->get_tabla('cla_clasificacion_encuesta', array('cla_nombre' => $nombre, 'cla_id_niv' => $nivel));
        //print_r( $nombre.' '.$nivel); die();
        if ( $query != null ) {
            $respuesta['participacion'] = "Si";
        }else{
            $respuesta['participacion'] = "No";
        }
        die(json_encode($respuesta));
    }

    public function get_dependencias($where=null)
    {          

        $array_return = array();
            //consultar los padres
                $this->db->join('niv_nivel_clasificacion','niv_id=cla_id_niv');
                $this->db->order_by('cla_id_padre,niv_orden','ASC'); 
                $this->db->where("cla_id_padre IS NULL",null,false);
       $query = $this->gsatelite->get_tabla('cla_clasificacion_encuesta',$where);
       $nivel_ = 1;
       foreach ($query as $fila) {
           $orden = array();
           if ($fila['niv_orden'] > 0) {
               for ($i=1; $i <= $fila['niv_orden']; $i++) { 
                   $orden[] = $i;
               }
           } 
           $orden_label = (count($orden) > 0)? implode('.', $orden):'1';
           //$array_return['cla_'.$fila['cla_id']] = $orden_label.' - '.$fila['cla_nombre'];
           $array_return['cla_'.$fila['cla_id']] = $fila['cla_nombre'];
           $rama = $this->getArbol($fila['cla_id']);
           $array_return = array_merge($array_return, $rama);
       }

    if (count($array_return)>0) {
        $new_array = array();
        foreach ($array_return as $key => $value) {
            $new_array[str_replace('cla_','', $key)] = $value;
        }
        $array_return = $new_array;
    }
    return $array_return;
    }

    public function getArbol($id_padre = 0)
    {
        $array_return = array();
               $this->db->join('niv_nivel_clasificacion','niv_id=cla_id_niv');
               $this->db->order_by('niv_orden','ASC');
               $this->db->where("cla_estado",1);
        $reg = $this->gsatelite->get_tabla('cla_clasificacion_encuesta',array('cla_id_padre'=>$id_padre));

        foreach ($reg as $f) {
            $orden = array();
            if ($f['niv_orden'] > 0) {
                for ($i=1; $i <= $f['niv_orden']; $i++) { 
                    $orden[] = $i;
                }
            } 
            $orden_label = (count($orden) > 0)? implode('.', $orden):'1';
            //$array_return['cla_'.$f['cla_id']] = $orden_label.' - '.$f['cla_nombre'];
            $array_return['cla_'.$f['cla_id']] = $f['cla_nombre'];
            $rama = $this->getArbol($f['cla_id']);
            $array_return = array_merge($array_return, $rama);
        }
        return $array_return;
    }


    /**
     * @author Manuel Hernández
     * @return Mantenimiento de Periodos
     */
    public function periodos() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            try {
                $permisos= $this->gsatelite->get_permisos_opcion('periodos');
                
                $crud = new grocery_CRUD();
                $crud->set_table('per_periodo')
                        ->set_subject('')
                        ->columns('per_nombre')
                        ->add_fields('per_nombre', 'per_usu_creacion', 'per_usu_modificacion', 'per_fecha_creacion', 'per_fecha_modificacion', 'per_estado')
                        ->edit_fields('per_nombre', 'per_usu_modificacion', 'per_fecha_modificacion','per_estado')
                        ->display_as('per_nombre', 'Nombre')
                        ->display_as('per_estado', 'Estado')
                        ->required_fields('per_nombre')
                        ->set_rules('per_nombre', 'Nombre', 'trim|required|campo_unico[per_periodo.per_nombre]')
                        ->field_type('per_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                        ->field_type('per_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                        ->field_type('per_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
                        ->field_type('per_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
                ;

                $data['titulo_personal'] = "Períodos";
               
                if (end(explode('/', uri_string())) == 'add') {
                    $crud->field_type('per_estado', 'hidden', 1);
                } else {
                    $crud->field_type('per_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo')); 
                }

               
                //$crud->unset_print()->unset_export();
                // Validaciones
                if(!$permisos['permite_agregar']) { $crud->unset_add();} 
                if(!$permisos['permite_editar']) { $crud->unset_edit();}
                if(!$permisos['permite_eliminar']) { $crud->unset_delete();} 
                if($permisos['permite_ver']) {
                  $crud->add_action('Ver','minia-icon-search','encuesta/catalogos/periodos/read');
                 }     

                $output = $crud->render();
                cargarvista($data, $output);
            } catch (Exception $e) {
                show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
            }
        }
    } // End function categoria_pregunta

    /**
     * @author Marlon Olmedo
     * @since  14-01-2021
     * @return Mantenimiento de tipo dato
     */
    public function tipo_datos() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            try {
                $permisos= $this->gsatelite->get_permisos_opcion();
                
                $crud = new grocery_CRUD();
                $crud->set_table('tpd_tipo_dato')
                        ->set_subject('')
                        ->columns('tpd_nombre','tpd_descripcion','tpd_estado')
                        ->add_fields('tpd_nombre','tpd_descripcion','tpd_estado', 'tpd_usu_creacion', 'tpd_fecha_creacion', 'tpd_usu_modificacion', 'tpd_fecha_modificacion')
                        ->edit_fields('tpd_nombre','tpd_descripcion','tpd_estado', 'tpd_usu_modificacion', 'tpd_fecha_modificacion')
                        ->display_as('tpd_nombre', 'Nombre')
                        ->display_as('tpd_estado', 'Estado')
                        ->display_as('tpd_descripcion', 'Descripción')
                        ->required_fields('tpd_nombre', 'tpd_estado')
                        ->set_rules('tpd_nombre', 'Nombre', 'trim|required|campo_unico[niv_nivel_clasificacion.niv_nombre]')
                       // ->field_type('niv_orden', 'hidden', 0)
                        ->field_type('tpd_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                        ->field_type('tpd_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                        ->field_type('tpd_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
                        ->field_type('tpd_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
                ;

                $data['titulo_personal'] = "Tipo de datos";

                if (end(explode('/', uri_string())) == 'add') {
                    $crud->field_type('tpd_estado', 'hidden', 1);
                } else {
                    $crud->field_type('tpd_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
                }             

                // Validaciones
                if(!$permisos['permite_agregar']) { $crud->unset_add();} 
                if(!$permisos['permite_editar']) { $crud->unset_edit();}
                if(!$permisos['permite_eliminar']) { $crud->unset_delete();} 
                if($permisos['permite_ver']) {
                  $crud->add_action('Ver','minia-icon-search','encuesta/catalogos/tipo_datos/read');
                 }     

                $output = $crud->render();
                cargarvista($data, $output);
            } catch (Exception $e) {
                show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
            }
        }
    } // End function niv_nivel_clasificacion

    /**
     * @author Marlon Olmedo
     * @since  20-01-2021
     * @return traer las preguntas dependientes de la encuesta
     */
    public function get_preguntasxenc() {
        $encuesta_id = $this->input->post('encuesta_id');
        $preguntas = $this->gsatelite->get_dropdown('pre_pregunta', '{pre_nombre}', '', array('pre_estado' => '1','pre_id_enc' => $encuesta_id), null, '', 'pre_id', true);

        echo json_encode([ "options" => str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $preguntas)]);
    } // End function get_preguntasxenc

    /**
     * @author Marlon Olmedo
     * @since  20-01-2021
     * @return traer las respuestas dependientes de la pregunta
     */
    public function get_respuestasxpre() {
        $pregunta_id = $this->input->post('pregunta_id');
        $respuestas = $this->gsatelite->get_dropdown('opr_opcion_respuesta', '{opr_nombre}', '', array('opr_estado' => '1','opr_id_pre' => $pregunta_id), null, '', 'opr_id', true);

        echo json_encode([ "options" => str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $respuestas)]);
    } // End function get_preguntasxenc


}

/* End of file catalogos.php */
/* Location: ./application/controllers/encuesta/catalogos.php */