<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Salidas extends CI_Controller{
	function __construct(){
		parent::__construct();
		$this->load->library('grocery_CRUD');
		$this->load->model('gsatelite');
		$this->load->model('desarrollo_model');
        $this->load->library('pdf');
        $this->load->library('excel/excel_reader.php');
	}

	function index(){
		if (!$this->tank_auth->is_logged_in()) {
			redirect('/auth/login/');
		} else {			
			$data['titulo_personal']='Desarrollo SAT';
            $this->_cargarvista(null,$data);
        }
	}

    /**
    * @author Christian Menendez
    * @return 
    */
    function asignacion_consultor(){
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
                        $this->db->join('emp_empleado', 'usu_id_emp = emp_id', 'left');
            $usuarios = $this->gsatelite->get_dropdown('users', '[IF(emp_id_usu != "", CONCAT_WS(" ", emp_nombre, emp_apellido), username)]', '', array('activated' => 1), null, null, 'id', true);
            $etapas = $this->gsatelite->get_dropdown('etr_etapa_entregable', 'etr_nombre', '', array('etr_estado' => 1), null, null, 'etr_id', true);
            $data["usuarios"] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $usuarios);
            $data["etapas"] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $etapas);;
        	$data["titulo_personal"] ="Reporte de Asignaciones por consultor";
        	$this->_cargarvista($data);            
        }
    }

    public function mostrar_sprint($value=''){
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            // var_dump($_POST);die();
            $consultor = $this->input->post("slc_consultor");
            $proyecto = $this->input->post("slc_proyecto");
            $sprint = $this->input->post("slc_sprint");
            $etapa = $this->input->post("slc_etapa");
            $espm = $this->input->post("es_suprv");
            if ($proyecto > 0) {
                $where["inc_id_pry"] = $proyecto;
            }
            if ($sprint > 0) {
                $where["inc_id_enr"] = $sprint;
            }
            if ($etapa && is_array($etapa)) {
                $etapas = implode(",", $etapa);
                $where["inc_id_etr IN ($etapas)"] = NULL;
            }
            if ($consultor > 0) {
                if ($espm > 0) {
                    $where["(inc_id_usr_asignado = $consultor OR inc_id_usr_asignado IN (SELECT DISTINCT uxp_id_usu FROM uxp_usuarioxproyecto JOIN pry_proyecto ON pry_id = uxp_id_pry WHERE pry_id_usu_pm = $consultor))"] = NULL;
                } else {
                    $where["inc_id_usr_asignado"] = $consultor;
                }                
            }
            $cadena_sprint = "";
            $sprint_extraidos = $this->desarrollo_model->get_data_reportes($where);
            $total_horas = 0;
            if (!empty($sprint_extraidos)) {
                foreach ($sprint_extraidos as $key => $f) {
                    $total_horas += $f['inc_estimacion'];
                    $cadena_sprint.='<tr><td>'.$f['pry_nombre'].'</td>';
                    $cadena_sprint.='<td>'.$f['enr_codigo'].'</td>';
                    $cadena_sprint.='<td><span style="display:none;">'.formatear_fecha("Ymd",$f['enr_fecha_inicio']).'</span>'.formatear_fecha("d-m-Y",$f['enr_fecha_inicio']).'</td>';
                    $cadena_sprint.='<td><span style="display:none;">'.formatear_fecha("Ymd",$f['enr_fecha_fin']).'</span>'.formatear_fecha("d-m-Y",$f['enr_fecha_fin']).'</td>';
                    $cadena_sprint.='<td>'.$f['username'].'</td>';
                    $cadena_sprint.='<td>'.$f['inc_codigo'].'</td>';
                    $cadena_sprint.='<td>'.$f['inc_nombre'].'</td>';
                    $cadena_sprint.='<td>'.$f['inc_importancia'].'</td>';
                    $cadena_sprint.='<td>'.$f['inc_estimacion'].'</td>';
                    $cadena_sprint.='<td>'.$f['etrnombre'].'</td>';
                    $cadena_sprint.='<td><span style="display:none;">'.formatear_fecha("Ymd",$f['sgi_fecha']).'</span>'.formatear_fecha("d-m-Y",$f['sgi_fecha']).'</td>';
                    $cadena_sprint.='<td><span style="display:none;">'.formatear_fecha("Ymd",$f['fecha_actual']).'</span>'.formatear_fecha("d-m-Y",$f['fecha_actual']).'</td>';
                    $cadena_sprint.='<td>'.$f['diferencia'].'</td></tr>';
                }
            }
            echo json_encode(array('cadena_sprint' => $cadena_sprint, 'horas' => $total_horas));
        }
    }


    public function reporte_asignaciones_consultor(){
        satelite_validar();
        // var_dump($_POST);die();
        $consultor = $this->input->post("slc_consultor");
        $proyecto = $this->input->post("slc_proyecto");
        $sprint = $this->input->post("slc_sprint");
        $etapa = $this->input->post("slc_etapa");
        $espm = $this->input->post("es_suprv");
        if ($proyecto > 0) {
            $where["inc_id_pry"] = $proyecto;
        }
        if ($sprint > 0) {
            $where["inc_id_enr"] = $sprint;
        }
        if ($etapa != '') {
            $where["inc_id_etr IN ($etapa)"] = NULL;
        }
        if ($consultor > 0) {
            if ($espm > 0) {
                $where["(inc_id_usr_asignado = $consultor OR inc_id_usr_asignado IN (SELECT DISTINCT uxp_id_usu FROM uxp_usuarioxproyecto JOIN pry_proyecto ON pry_id = uxp_id_pry WHERE pry_id_usu_pm = $consultor))"] = NULL;
            } else {
                $where["inc_id_usr_asignado"] = $consultor;
            }
        }
        $sprint_extraidos = $this->desarrollo_model->get_data_reportes($where);
        $cadena = $cadena_cabecera = "";
        $rows = "REPORTES DE ASIGNACIONES POR CONSULTOR";
        $cadena_cabecera.='<th style="text-align:center; font-weight:bold; border: 1px solid black">Proyecto</th>';    
        $cadena_cabecera.='<th style="text-align:center; font-weight:bold; border: 1px solid black">Sprint</th> ' ;
        $cadena_cabecera.='<th style="text-align:center; font-weight:bold; border: 1px solid black">Fecha Inicio Sprint</th>'; 
        $cadena_cabecera.='<th style="text-align:center; font-weight:bold; border: 1px solid black">Fecha Fin</th> ' ;
        $cadena_cabecera.='<th style="text-align:center; font-weight:bold; border: 1px solid black">Consultor</th>';   
        $cadena_cabecera.='<th style="text-align:center; font-weight:bold; border: 1px solid black">Incidencia</th>' ; 
        $cadena_cabecera.='<th style="text-align:center; font-weight:bold; border: 1px solid black">Nombre</th>'  ;
        $cadena_cabecera.='<th style="text-align:center; font-weight:bold; border: 1px solid black">Importancia</th>'  ;
        $cadena_cabecera.='<th style="text-align:center; font-weight:bold; border: 1px solid black">Estimaci&oacute;n</th> ';
        $cadena_cabecera.='<th style="text-align:center; font-weight:bold; border: 1px solid black">Etapa Actual</th> ' ;  
        $cadena_cabecera.='<th style="text-align:center; font-weight:bold; border: 1px solid black" >Fecha etapa</th>';
        $cadena_cabecera.='<th style="text-align:center; font-weight:bold; border: 1px solid black">Fecha Actual</th>' ;  
        $cadena_cabecera.='<th style="text-align:center; font-weight:bold; border: 1px solid black"> Diferencia</th>';
        foreach ($sprint_extraidos as $key => $sld) {
            $cadena.='<tr><td style="border: 1px solid black;">'.$sld['pry_nombre'].'</td>';
            $cadena.='<td style="border: 1px solid black;">'.$sld['enr_codigo'].'</td>';
            $cadena.='<td style="border: 1px solid black;">'.formatear_fecha("d-m-Y", $sld['enr_fecha_inicio']).'</td>';
            $cadena.='<td style="border: 1px solid black;">'.formatear_fecha("d-m-Y", $sld['enr_fecha_fin']).'</td>';
            $cadena.='<td style="border: 1px solid black;">'.$sld['username'].'</td>';
            $cadena.='<td style="border: 1px solid black;">'.$sld['inc_codigo'].'</td>';
            $cadena.='<td style="border: 1px solid black;">'.$sld['inc_nombre'].'</td>';
            $cadena.='<td style="border: 1px solid black;">'.$sld['inc_importancia'].'</td>';
            $cadena.='<td style="border: 1px solid black;">'.$sld['inc_estimacion'].'</td>';
            $cadena.='<td style="border: 1px solid black;">'.$sld['etrnombre'].'</td>';
            $cadena.='<td style="border: 1px solid black;">'.formatear_fecha("d-m-Y", $sld['sgi_fecha']).'</td>';
            $cadena.='<td style="border: 1px solid black;">'.formatear_fecha("d-m-Y", $sld['fecha_actual']).'</td>';
            $cadena.='<td style="border: 1px solid black;">'.$sld['diferencia'].'</td></tr>';
        }
        $filename = 'rpt_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);
        $data['table_titulo'] = $rows;
        $data['table_header'] = $cadena_cabecera;
        $data['table_tbody'] = $cadena;
        $data['filename'] = $filename;
        /**$this->load->library('excelphp');
        $this->excelphp->crear_excel('Velocidad Equipo',$data);*/
        $this->load->view('desarrollo/salidas/reporte_asignaciones_consultor.php', $data);   
    }
    //========================================//
    //           FIN  REPORTE # 1            //
    //======================================//


    //========================================//
    //                REPORTE # 3         //
    //======================================//   
     /**
    * @author Christian Menendez
    * @return 
    */
     function generales_sprint(){
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {                
            $sprint = $this->gsatelite->get_tabla('enr_entregable');
            $proyecto = $this->gsatelite->get_tabla('pry_proyecto');
            //$etapas = $this->gsatelite->get_tabla('etr_etapa_entregable');
            $data["sprint"] = $sprint;
            $data["proyecto"] = $proyecto;
            // $data["etapas"] = $etapas;
            $data["titulo_personal"] ="Generales Sprint";
            $this->_cargarvista($data);           
        }
    }

    public function mostrar_sprint_generales(){
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {                
            $proyecto= ($this->input->post("consultor") != '')? $this->input->post("consultor") : NULL;//proyecto
            $Sprint= ($this->input->post("sprint") != '')? $this->input->post("sprint") : NULL;//sprint 

            if ($proyecto != NULL) {
                $where["pry_id"] = $proyecto;
            }
            if ($Sprint != NULL) {
                $where["enr_id"] = $Sprint;
            }

            $proyectos_extraidos = $this->desarrollo_model->get_data_generales_sprint($where);
            //print_r($proyectos_extraidos);die();
            if (!empty($proyectos_extraidos)) {
                $cadena_sprint="";
                
                foreach ($proyectos_extraidos as $key => $sld) {
                    $cadena_sprint.="<tr><td>".$sld['enr_codigo']."</td>";
                    $cadena_sprint.="<td><span style='display:none;'>".formatear_fecha("Ymd",$sld['enr_fecha_inicio'])."</span>".formatear_fecha("d-m-Y",$sld['enr_fecha_inicio'])."</td>";
                    $cadena_sprint.="<td><span style='display:none;'>".formatear_fecha("Ymd",$sld['enr_fecha_fin'])."</span>".formatear_fecha("d-m-Y",$sld['enr_fecha_fin'])."</td>";
                    $cadena_sprint.="<td>".$sld['enr_num_hora_efectiva']."</td>";
                    $cadena_sprint.="<td>".$sld['enr_consultor']."</td>";
                    $cadena_sprint.="<td>".$sld['multiplicacion']."</td>"; 
                    $cadena_sprint.="<td>".$sld['estima_ingr']."</td>";
                    $cadena_sprint.="<td>".$sld['estima_efectiva']."</td>";
                    $cadena_sprint.="<td>".number_format(($sld['multiplicacion'] / $sld['estima_efectiva']),2)."</td>";  
                    $cadena_sprint.="<td>".number_format(($sld['multiplicacion'] / $sld['estima_ingr']),2)."</td></tr>";   
                }
                echo json_encode(array('cadena_sprint' => $cadena_sprint));
            } else {
                echo json_encode(array('cadena_sprint' => "No existen Registros" ));
            }                   
        }
    }

    public function reporte_generales_sprint(){
            satelite_validar();

            $proyecto= ($this->input->post("consultor") != '')? $this->input->post("consultor") : NULL;//proyecto
            $Sprint= ($this->input->post("sprint") != '')? $this->input->post("sprint") : NULL;//sprint 

            if ($proyecto != NULL) {
                $where["pry_id"] = $proyecto;
            }
            if ($Sprint != NULL) {
                $where["enr_id"] = $Sprint;
            }
            

           $proyectos_extraidos = $this->desarrollo_model->get_data_generales_sprint($where);

            $cadena="";
            $cadena_cabecera="";

           $rows="REPORTES GENERALES SPRINT";

           $cadena_cabecera.='<th style="text-align:center; font-weight:bold; border: 1px solid black;" reporte_generales_sprint>Sprint</th> ' ;
           $cadena_cabecera.='<th style="text-align:center; font-weight:bold; border: 1px solid black;"
                reporte_generales_sprint>Fecha Inicio</th>'; 
           $cadena_cabecera.='<th style="text-align:center; font-weight:bold; border: 1px solid black;"
                    reporte_generales_sprint>Fecha Fin</th> ' ;
            
            $cadena_cabecera.='<th style="text-align:center; font-weight:bold; border: 1px solid black;"
          reporte_generales_sprint>Horas planificadas</th> ';
            $cadena_cabecera.='<th style="text-align:center; font-weight:bold; border: 1px solid black;"
          reporte_generales_sprint>Consultores</th> ';

           $cadena_cabecera.='<th style="text-align:center; font-weight:bold; border: 1px solid black;"
          reporte_generales_sprint>Total horas disponibles</th> ';
           $cadena_cabecera.='<th style="text-align:center; font-weight:bold; border: 1px solid black;"
          reporte_generales_sprint>Total Estimacion ingresada</th> ';;  
          $cadena_cabecera.='<th style="text-align:center; font-weight:bold; border: 1px solid black;" reporte_generales_sprint>Total Estimacion efectiva</th> ' ;
          $cadena_cabecera.='<th style="text-align:center; font-weight:bold; border: 1px solid black;" reporte_generales_sprint>Cumplimiento planificado</th> ' ;
          $cadena_cabecera.='<th style="text-align:center; font-weight:bold; border: 1px solid black;" reporte_generales_sprint>Cumplimiento asignado</th> ' ;
          
            //$cadena.='<th> Diferencia</th>';
         

          //die(print_r($proyectos_extraidos, true));
          foreach ($proyectos_extraidos as $key => $sld) {

                $cadena.= '<tr>';
                $cadena.='<td style="border: 1px solid black;">'.$sld['enr_codigo'].'</td>';
                $cadena.='<td style="border: 1px solid black;">'.formatear_fecha("d-m-Y",$sld['enr_fecha_inicio']).'</td>';
                $cadena.='<td style="border: 1px solid black;">'.formatear_fecha("d-m-Y",$sld['enr_fecha_fin']).'</td>';
                $cadena.='<td style="border: 1px solid black;">'.$sld['enr_num_hora_efectiva'].'</td>';
                $cadena.='<td style="border: 1px solid black;">'.$sld['enr_consultor'].'</td>';
                $cadena.='<td style="border: 1px solid black;">'.$sld['multiplicacion'].'</td>';
                $cadena.='<td style="border: 1px solid black;">'.$sld['estima_ingr'].'</td>';
                $cadena.='<td style="border: 1px solid black;">'.$sld['estima_efectiva'].'</td>';
                $cadena.='<td style="border: 1px solid black;" class="text">'.number_format(($sld['multiplicacion'] / $sld['estima_efectiva']),2).'</td>';
                $cadena.='<td style="border: 1px solid black;" class="text">'.number_format(($sld['multiplicacion'] / $sld['estima_ingr']),2).'</td>';
                $cadena.= '</tr>';
                //$cadena_sprint.="<td>".$sld['fecha_actual']."</td>";
                //$cadena_sprint.="<td>".$sld['diferencia']."</td></tr>";
                
            }


            $filename = 'rpt_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);

             $data['table_titulo']     = $rows;
            $data['table_header']      = $cadena_cabecera;
            $data['table_tbody']      = $cadena;
            $data['filename']         = $filename;
             $this->load->view('desarrollo/salidas/reporte_asignaciones_velocidad.php', $data); 
                             
    } 
    //========================================//
    //           FIN  REPORTE # 3            //
    //======================================//


    //================ REPORTE #4 ==================//   
    /**
    * @author Christian Menendez
    * @return 
    */
    function reporte_etapas(){
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $sprint = $this->gsatelite->get_tabla('enr_entregable');
            $proyecto = $this->gsatelite->get_tabla('pry_proyecto');
                        $this->db->join('emp_empleado','usu_id_emp = emp_id','left');
            $usuarios = $this->gsatelite->get_dropdown('users', '[IF(emp_id_usu != "",CONCAT_WS(" ", emp_nombre, emp_apellido),username)]', '', array('activated' => 1), null, null, 'id', true);
            $cliente = $this->gsatelite->get_dropdown('cli_cliente','[IF(cli_personeria=1,CONCAT_WS(" ",cli_nombre,cli_apellido),cli_apellido)]','',array('cli_estado' => 1),null,null,'cli_id',true);
            //$etapas = $this->gsatelite->get_tabla('etr_etapa_entregable');
            $data["usuarios"] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $usuarios);
            $data["cliente"] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $cliente);
            $data["sprint"] = $sprint;
            $data["proyecto"] = $proyecto;
            // $data["etapas"] = $etapas;
            $data["titulo_personal"] ="Etapas";
            $this->_cargarvista($data);            
        }
    }

    public function mostrar_etapas(){
        if (!$this->tank_auth->is_logged_in()) {
                redirect('/auth/login/');
            } else {
                $proyecto = ($this->input->post("slc_proyecto") != '')? $this->input->post("slc_proyecto") : null;
                $sprint = ($this->input->post("slc_sprint") != '')? $this->input->post("slc_sprint") : null;
                $consultor = ($this->input->post("slc_consultor") != '')? $this->input->post("slc_consultor") : null;
                $cliente = ($this->input->post("slc_cliente") != '')? $this->input->post("slc_cliente") : null;
                if ($proyecto != null){
                    $where["inc_id_pry"] = $proyecto;
                }
                if ($sprint != null){
                    $where["inc_id_enr"] = $sprint;
                }
                if ($consultor != null){
                    $where["inc_id_usr_asignado"] = $consultor;
                }
                if ($cliente != null){
                    $where["(SELECT GROUP_CONCAT(inl_id_cli) FROM inl_incidencia_cliente WHERE inc_id = inl_id_inc AND inl_id_cli = $cliente) >= 1"] = NULL;
                } 
                //por hacer           
                $proyectos_extraidos = $this->desarrollo_model->get_data_etapas($where);
                $cantidad_total = array_sum(array_column($proyectos_extraidos,"cantidad"));

                if (!empty($proyectos_extraidos)) {

                    $cadena_sprint="";

                foreach ($proyectos_extraidos as $key => $sld) {

                    $procentaje = (($sld['cantidad'] * 100) / $cantidad_total);

                    $cadena_sprint.="<tr><td>".$sld['etr_nombre']."</td>";
                    $cadena_sprint.="<td>".number_format($sld['cantidad'])."</td>";
                    $cadena_sprint.="<td>%".number_format($procentaje,2)."</td></tr>";//finalizadas

                  }

                    echo json_encode(array('cadena_sprint' => $cadena_sprint));

                } else {
                    echo json_encode(array('cadena_sprint' => "" ));
                }


            }
        }

    public function reporte_asignaciones_mostrar_etapas(){
                satelite_validar();
                $proyecto = ($this->input->post("slc_proyecto") != '')? $this->input->post("slc_proyecto") : null;
                $sprint = ($this->input->post("slc_sprint") != '')? $this->input->post("slc_sprint") : null;
                $consultor = ($this->input->post("slc_consultor") != '')? $this->input->post("slc_consultor") : null;
                $cliente = ($this->input->post("slc_cliente") != '')? $this->input->post("slc_cliente") : null;

                if ($proyecto != null){
                    $where["inc_id_pry"] = $proyecto;
                }
                if ($sprint != null){
                    $where["inc_id_enr"] = $sprint;
                }
                if ($consultor != null){
                    $where["inc_id_usr_asignado"] = $consultor;
                }
                if ($cliente != null){
                    $where["(SELECT GROUP_CONCAT(inl_id_cli) FROM inl_incidencia_cliente WHERE inc_id = inl_id_inc AND inl_id_cli = $cliente) >= 1"] = NULL;
                }
         
                $proyectos_extraidos = $this->desarrollo_model->get_data_etapas($where);
                $cantidad_total = array_sum(array_column($proyectos_extraidos,"cantidad"));
            $cadena="";
            $cadena_cabecera="";
            $rows="REPORTES ETAPAS";

       
            $cadena_cabecera.='<th style="text-align:center; font-weight:bold; border: 1px solid black;" >Etapas</th> ' ;
            $cadena_cabecera.='<th style="text-align:center; font-weight:bold;   border: 1px solid black; " >Horas</th>'; 
            $cadena_cabecera.='<th style="text-align:center; font-weight:bold;  border: 1px solid black; " >Porcentaje</th> ' ;
      


                 foreach ($proyectos_extraidos as $key => $sld) {

                    $procentaje = (($sld['cantidad'] * 100) / $cantidad_total);

                $cadena.='<tr><td style="border: 1px solid black" >'.$sld['etr_nombre'].'</td>';

                $cadena.='<td style="border: 1px solid black" >'.number_format($sld['cantidad']).'</td>';

                $cadena.='<td style="border: 1px solid black" >'.number_format($procentaje,2)."</td></tr>";//finalizadas

                }
              

          
           $filename = 'rpt_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);

             $data['table_titulo']     = $rows;
            $data['table_header']      = $cadena_cabecera;
            $data['table_tbody']      = $cadena;
            $data['filename']         = $filename;
        $this->load->view('desarrollo/salidas/reporte_asignaciones_velocidad.php', $data); 
                   
                    //$this->load->view('inventario/reportes/reporte_departamento.php', $data);

                 //$this->pdf->reportePDF('inventario/reportes/reporte_existencia_pdf.php', $data);
                // $this->load->view('registro_academico/consultas/consultar_notas_modulos');
       

    } 
    //========================================//
    //           FIN  REPORTE # 4            //
    //======================================//



    /**
     * Descripción:
     * Función para generar reprote de planes de trabajo
     * @author René Castaneda - Grupo Satélite
     * @since 2017-10-24
     * @param ninguno
     * @return Vista para generación de reporte
     */

    public function plan_trabajo(){   
        satelite_validar();
        $select_pry = '<option value=""></option>';
        $permisos               = $this->gsatelite->get_permisos_opcion();
        $data['permisos']       = $permisos;
        // $data['slcProyecto']    =  $this->gsatelite->get_dropdown('pry_proyecto', '{pry_inicial} - {pry_nombre}','', array('pry_estado' => '1'), null, '', 'pry_id', true);
        $proyectos = $this->desarrollo_model->get_proyectos(array('uxp_id_usu' => $this->tank_auth->get_user_id(),'pry_estado' => 1));
        foreach ($proyectos as $key => $value) {
            $select_pry .= '<option value="'.$value['pry_id'].'">'.$value['pry_inicial'].' - '.$value['pry_nombre'].'</option>';
        }
        $data['slcProyecto'] = $select_pry;
        $data['slcSprint']      =  str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $this->gsatelite->get_dropdown('enr_entregable', '{enr_codigo} - {enr_nombre}','', array('enr_id' => 0), null, '', 'enr_id', true));
        $data['slcConsultor']   =  $this->gsatelite->get_dropdown('users', '{username}','', array('activated > ' => '0'), null, '', 'id', true);
        $data['clientes'] = $this->desarrollo_model->get_select_cliente_incidencia();
        $data['titulo_personal']= "Backlog de requerimientos";
        cargarvista($data);
    }

    /**
    * @author René Castaneda
    * @since 2017-10-24
    * @param int $es_reporte (1=si es reporte, 0 = no es reporte)
    * @return filtrar las incidencias para los planes de trabajo.
    */ 

    public function filtrar_plan_trabajo($es_reporte=0){   
        satelite_validar();
        $registros          = array();
        $slcProyecto        = ($es_reporte)? ((trim($this->input->post('slcProyecto')) !='' ) ? explode(',',$this->input->post('slcProyecto')) : array()) : $this->input->post('slcProyecto');
        $slcEstadoSprint    = ($this->input->post('slcEstadoSprint') != "") ? $this->input->post('slcEstadoSprint') : NULL;
        $slcSprint          = ($es_reporte)? ( (trim($this->input->post('slcSprint')) !='' )? explode(',',$this->input->post('slcSprint')):array()):$this->input->post('slcSprint');
        $slcConsultor       = ($es_reporte)? ( (trim($this->input->post('slcConsultor')) !='' )? explode(',',$this->input->post('slcConsultor')):array()):$this->input->post('slcConsultor');
        $slcCliente         = ($this->input->post('slcCliente') != "")? $this->input->post('slcCliente') : NULL ;

        $where = NULL;

        if ( $slcCliente != NULL ){
            $where["inc_id in ( select inl_id_inc from inl_incidencia_cliente where inl_id_cli = $slcCliente)"]= -1;
        }

        if ($this->input->post()) {                        
            if ($slcProyecto > 0 or (is_array($slcProyecto) and count($slcProyecto) > 0)) { //valor simple o arreglo de valores
                $where['pry_id'] = $slcProyecto;
            }
            if ($slcSprint > 0 or (is_array($slcSprint) and count($slcSprint) > 0)) { //valor simple o arreglo de valores
                $where['enr_id'] = $slcSprint;
            }
            if ($slcConsultor > 0 or (is_array($slcConsultor) and count($slcConsultor) > 0)) { //valor simple o arreglo de valores
                $where['inc_id_usr_asignado'] = $slcConsultor;
            }
            if ($slcEstadoSprint > 0) {
                $where['enr_activo'] = 1;
            }
        }
        $where['inc_estado !='] = 0;
        $registros = $this->desarrollo_model->get_plan_trabajo($where);

        $data['es_reporte']         = $es_reporte;
        $data['slcProyecto']        = (is_array($this->input->post('slcProyecto')))? implode(',', $this->input->post('slcProyecto')):'';
        $data['slcEstadoSprint']    = $this->input->post('slcEstadoSprint');
        $data['slcSprint']          = (is_array($this->input->post('slcSprint')))? implode(',', $this->input->post('slcSprint')):'';
        $data['slcConsultor']       = (is_array($this->input->post('slcConsultor')))? implode(',', $this->input->post('slcConsultor')):'';
        $data['slcCliente']         = ($this->input->post('slcCliente') != "")? $this->input->post('slcCliente') : "";

        $data['registros'] = $registros;

        $tipo_accion = $this->input->post('tipo_accion');
        if ($tipo_accion) { /* Excel */  $data['excel']=1; }

        $html = $this->load->view('desarrollo/salidas/filtrar_plan_trabajo', $data, true);

        $filtro_titulo = "";
        if ($es_reporte) {
        if ($tipo_accion) { //excel
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header("Content-Disposition: attachment;filename=backlog_requerimientos_".date('d-m-Y_His').".xls"); 
            header("Pragma: no-cache");
            header("Expires: 0");
            echo '<meta charset="utf-8" />';
            echo "<table border='0'>
            <tr><th colspan='17' align='center' >".mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'),'UTF-8')."</th></tr>
            <tr><th colspan='17' align='center' >Backlog de requerimientos</th></tr>
            <tr><th colspan='17' align='center' >".$filtro_titulo. "</th></tr>
            </table>";
            echo $html; die();
        } else { //pdf
            ini_set( 'memory_limit', '2048M' );
            ini_set('max_execution_time', '9999');

            $this->load->library('pdf');
            $html_header=$this->load->view('reporte/header', array('titulo' => "Backlog de requerimientos<br /> $filtro_titulo", 'solotitulo'=> true), true);
            $html = str_replace('border="1" style="margin-left: 4px; width: 99%; font-size:12px;"','border="0.5" style="width: 100%; font-size:9px;"',$html);
            
            $this->pdf->makePDF($html_header.$html,'lanscape', 'backlog_requerimientos','A2');
            die();
        }
    }
    echo json_encode(array('html'=>$html));

}

/**
* @author René Castaneda
* @since 2017-11-12
* @return filtrar los sprint proyecto
 */
public function filtrar_sprint_option(){
    $slcEstadoSprint = $this->input->post('slcEstadoSprint');
    $where['enr_activo'] = ($slcEstadoSprint)? 1:0;
    if($this->input->post('slcProyecto') and count($this->input->post('slcProyecto')) > 0 )
    {
                           $this->db->where_in('enr_id_pry',$this->input->post('slcProyecto'));
        $data['options'] = $this->gsatelite->get_dropdown('enr_entregable', '{enr_codigo} - {enr_nombre}','', $where, null, '', 'enr_id', true);
    } 
    else
    {                       
        $data['options'] = $this->gsatelite->get_dropdown('enr_entregable', '{enr_codigo} - {enr_nombre}','', $where, null, '', 'enr_id', true);
    }
    $data['options'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $data['options']);
    die(json_encode($data));
}


    public function cumplimiento_consultor(){
        satelite_validar();
        $data['proyectos']          = $this->gsatelite->get_tabla('pry_proyecto',array('pry_estado' => 1) );
        //sprint
        $data['entregables']        = $this->gsatelite->get_tabla('enr_entregable',array('enr_estado' => 1) );
        //etapas
        $data['etapas']             = $this->gsatelite->get_tabla('etr_etapa_entregable',array('etr_estado' => 1) );
        
        $data['slcConsultors'] = $this->desarrollo_model->get_consultores_completo(array("activated" => 1)); 
        $data['titulo_personal']    = "Reporte de cumplimiento por consultor";
        $this->_cargarvista($data);
    }

    public function reporte_cumplimiento_consultor($flag = null){
        satelite_validar();
        if ($_POST){
            $post_array = $this->input->post();
            /*
             * Si es consulta ajax se toman los nombres del Jquery
             * De lo contrario, se toman los filtros de impresión
            */
           
            if ($flag) {
                $proyecto           = ($post_array['slc_proyecto'] != '') ? $post_array['slc_proyecto'] : NULL;
             
                $nombre_proyecto    = ($post_array['slc_proyecto_nombre'] != '') ? $post_array['slc_proyecto_nombre'] : "Todos";
               
                $sprint             = ($post_array['slc_sprint'] != 'null') ? $post_array['slc_sprint'] : NULL;
                $nombre_sprint      = ($post_array['slc_sprint_nombre'] != '') ? $post_array['slc_sprint_nombre'] : "Todos";
                
                $consultor          = ($post_array['slc_consultor'] != '') ? $post_array['slc_consultor'] : null;
                $nombre_consultor   = ($post_array['slc_consultor_nombre'] != '') ? $post_array['slc_consultor_nombre'] : "Todos";
                
                $etapa              = ($post_array['slc_estapa'] != 'null') ? $post_array['slc_estapa'] : null;
                $nombre_etapa       = ($post_array['slc_estapa_nombre'] != '') ? $post_array['slc_estapa_nombre'] : "Todos";
               
                $fecha_ini_1        = ($post_array['fecha_ini_1'] != '') ? date('Y-m-d', strtotime($post_array['fecha_ini_1'])) : null;
                $fecha_ini_2        = ($post_array['fecha_ini_2'] != '') ? date('Y-m-d', strtotime($post_array['fecha_ini_2'])) : null;

                $sprint_array ="";
                if ($sprint != null){
                    foreach ( $sprint as $value){
                        $sprint_array = $sprint_array.$value.",";
                    }
                    $sprint_array = substr($sprint_array, 0, -1);
                    // $sprint_where = $where_sprint;
                }
                $sprint = $sprint_array;

                $where_etapas ="";
                if ($etapa != null){
                    foreach ( $etapa as $value){
                        $where_etapas = $where_etapas.$value.",";
                    }
                    $where_etapas = substr($where_etapas, 0, -1);
                    $etapa = $where_etapas;
                }

            } else {
                $proyecto           = ($post_array['filtro_proyecto'] != '') ? $post_array['filtro_proyecto'] : null;
                $nombre_proyecto    = ($post_array['filtro_proyecto_nombre'] != '') ? $post_array['filtro_proyecto_nombre'] : "Todos";

                $sprint             = ($post_array['filtro_sprint'] != '') ? $post_array['filtro_sprint'] : null;
                $nombre_sprint      = ($post_array['filtro_sprint_nombre'] != '') ? $post_array['filtro_sprint_nombre'] : "Todos";

                $consultor          = ($post_array['filtro_consultor'] != '') ? $post_array['filtro_consultor'] : null;
                $nombre_consultor   = ($post_array['filtro_consultor_nombre'] != '') ? $post_array['filtro_consultor_nombre'] : "Todos";

                $etapa              = ($post_array['filtro_etapa'] != '') ? $post_array['filtro_etapa'] : null;
                $nombre_etapa       = ($post_array['filtro_etapa_nombre'] != '') ? $post_array['filtro_etapa_nombre'] : "Todos";

                $fecha_ini_1          = ($post_array['filtro_inicio_1'] != '') ? date('Y-m-d', strtotime($post_array['filtro_inicio_1'])) : null;
                $fecha_ini_2          = ($post_array['filtro_inicio_2'] != '') ? date('Y-m-d', strtotime($post_array['filtro_inicio_2'])) : null;
            }

            //Tipo de Reportes si sera Excel o Pdf
            $tipo_reporte   = $this->input->post('tipo_reporte');


            $where_etapas   = "";
            $where_sprint   = "";
            $where_proyecto = "";
            $where_fecha    = "";
            $where_consultor= "";
            $having_etapas  = "";

            if ($proyecto != null) {
                $where_proyecto     = $proyecto;
			      }
            
            if ($sprint != NULL) {
                $where_sprint = " AND enr_id IN (".$sprint.") ";
            }

            if ($fecha_ini_1 != null && $fecha_ini_2 != null) {
                $where_fecha = " AND enr_fecha_inicio BETWEEN '".$fecha_ini_1."' AND '".$fecha_ini_2."' ";   
            }

            if ($consultor != null) {
                $where_consultor = " AND inc_id_usr_asignado = '".$consultor."' ";   
            }

            if ($etapa != null) {
                $where_etapas   = " AND sgi_id_etr IN (".$etapa.") ";
                $having_etapas  = "HAVING ID_ETAPA IN (".$etapa.") ";
            }
           
            $reporte = $this->desarrollo_model->get_cumplimiento_consultor($where_proyecto, $where_sprint, $where_fecha, $where_consultor, $where_etapas,$having_etapas);
            //print_r($this->db->last_query());

            $filename = 'rpt_cumplimiento_consultor' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            
            $data['nombre_proyecto']    = $nombre_proyecto;
            $data['nombre_sprint']      = $nombre_sprint;
            $data['nombre_consultor']   = $nombre_consultor;
            $data['nombre_etapa']       = $nombre_etapa;
            $data['fecha_ini_1']          = $fecha_ini_1;
            $data['fecha_ini_2']          = $fecha_ini_2;
            
            $data['filename'] 		= $filename;
            $data['reporte'] 		= $reporte;
            $data['tipo_reporte'] 	= $tipo_reporte;
           
			$html = $this->load->view('desarrollo/salidas/reporte_cumplimiento_consultor', $data, true);
		
            if ($flag) {
                $dato["html"] = $html;
				echo json_encode($dato);
				die();
            } else {
                if ($tipo_reporte == 'pdf') {

                    $data['titulo'] = 'cumplimiento por consultor';

                    $header = $this->load->view('reporte/header', $data, true);

                    $GLOBALS['nombre_reporte'] = 'reporte_cumplimiento_consultor' . date('dmY');

                    $reporte = $header . $html;

                    $this->pdf->makePdf($reporte, 'L', 'reporte_cumplimiento_consultor', 'Letter');
                } elseif ($tipo_reporte == 'excel') {

                    $filename = 'rpt_cumplimiento_consultor_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

                    $data['titulo'] = 'cumplimiento por consultor';

                    $data['filename'] = $filename;

                    echo $html;
                }
            }
            
        } else{
            redirect('desarrollo/salidas/cumplimiento_consultor');
		}
	}

    function get_sprint(){
        if ($_POST){
            $proyecto   = $this->input->post('proyecto');
            $result     = $this->gsatelite->get_dropdown('enr_entregable', '{enr_codigo} - {enr_nombre}','', array("enr_id_pry" => $proyecto), null, '', 'enr_id', true);
            $result     = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $result);
            echo $result;
            die();
        } else {
            redirect('desarrollo/salidas/cumplimiento_consultor');
        }
    }

    function get_consultor(){
        if ($_POST){
            $proyecto   = $this->input->post('proyecto');
            $where = array();
            if(trim($proyecto) != ''){
              $where = array("uxp_id_pry" => $proyecto, "emp_estado" => 1);
            } else{
              $where = array("emp_estado" => 1);
            }

            $this->db->join("uxp_usuarioxproyecto","uxp_id_usu = emp_id_usu");
            $result     = $this->gsatelite->get_dropdown('emp_empleado', '{emp_nombre} {emp_apellido}','', $where, null, '', 'emp_id_usu', true);
            $result     = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $result);
            echo $result;
            die();
        } else {
            redirect('desarrollo/salidas/cumplimiento_consultor');
        }
    }

    public function incidencias_cliente(){
        satelite_validar();
                            $this->db->group_by("cli_id");
                            // $this->db->join("inc_incidencia","inc_id_cli = cli_id");
                            $this->db->join("inl_incidencia_cliente","inl_id_cli = cli_id");
        $data["clientes"] = $this->gsatelite->get_tabla('cli_cliente',array('cli_estado' => 1));
        
        //etapas
        $data['etapas'] = $this->gsatelite->get_tabla('etr_etapa_entregable',array('etr_estado' => 1) );
        $data['titulo_personal']    = "Reporte de estado de incidencias por cliente";
        $this->_cargarvista($data);
    }

    public function reporte_incidencias_cliente($flag = null){
        satelite_validar();
        if ($_POST){
            $post_array = $this->input->post();                      
            /*
             * Si es consulta ajax se toman los nombres del Jquery
             * De lo contrario, se toman los filtros de impresión
            */
            if ($flag) {
                $cliente            = ($post_array['slc_cliente'] != '') ? $post_array['slc_cliente'] : null;
                $nombre_cliente     = ($post_array['slc_cliente_nombre'] != '') ? $post_array['slc_cliente_nombre'] : "Todos";               
                $sprint             = ($post_array['slc_sprint'] != 'null') ? $post_array['slc_sprint'] : NULL;
                $nombre_sprint      = ($post_array['slc_sprint_nombre'] != '') ? $post_array['slc_sprint_nombre'] : "Todos";                
                $etapa              = ($post_array['slc_estapa'] != 'null') ? $post_array['slc_estapa'] : null;
                $nombre_etapa       = ($post_array['slc_estapa_nombre'] != '') ? $post_array['slc_estapa_nombre'] : "Todos";               
                //$estado             = ($post_array['estado'] != '') ? $post_array['estado'] : 1;
                $fecha_ini_1        = ($post_array['fecha_ini_1'] != '') ? date('Y-m-d', strtotime($post_array['fecha_ini_1'])) : null;
                $fecha_ini_2        = ($post_array['fecha_ini_2'] != '') ? date('Y-m-d', strtotime($post_array['fecha_ini_2'])) : null;
                $where_sprint ="";
                if ($sprint != null){
                    foreach ( $sprint as $value){
                        $where_sprint = $where_sprint.$value.",";
                    }
                    $where_sprint = substr($where_sprint, 0, -1);
                    $sprint = $where_sprint;
                }
                $where_etapas="";
                if ($etapa != null){
                    foreach ( $etapa as $value){
                        $where_etapas = $where_etapas.$value.",";
                    }
                    $where_etapas = substr($where_etapas, 0, -1);
                    $etapa = $where_etapas;
                }
            } else {
                $cliente            = ($post_array['filtro_cliente'] != '') ? $post_array['filtro_cliente'] : null;
                $nombre_cliente     = ($post_array['filtro_cliente_nombre'] != '') ? $post_array['filtro_cliente_nombre'] : "Todos";
                $sprint             = ($post_array['filtro_sprint'] != '') ? $post_array['filtro_sprint'] : null;
                $nombre_sprint      = ($post_array['filtro_sprint_nombre'] != '') ? $post_array['filtro_sprint_nombre'] : "Todos";
                $etapa              = ($post_array['filtro_etapa'] != '') ? $post_array['filtro_etapa'] : null;
                $nombre_etapa       = ($post_array['filtro_etapa_nombre'] != '') ? $post_array['filtro_etapa_nombre'] : "Todos";
                $fecha_ini_1          = ($post_array['filtro_inicio_1'] != '') ? date('Y-m-d', strtotime($post_array['filtro_inicio_1'])) : null;
                $fecha_ini_2          = ($post_array['filtro_inicio_2'] != '') ? date('Y-m-d', strtotime($post_array['filtro_inicio_2'])) : null;
                //$estado             = ($post_array['filtro_estado'] != '') ? $post_array['filtro_estado'] : 1;
            }		
            //Tipo de Reportes si sera Excel o Pdf
            $tipo_reporte   = $this->input->post('tipo_reporte');
            $where_etapas   = "";
            $where_sprint   = "";
            $where_cliente = "";
            $where_consultor= "";
            $having_etapas  = "";
            if ($fecha_ini_1 != null && $fecha_ini_2 != null) {
                $where_fecha = " AND enr_fecha_inicio BETWEEN '".$fecha_ini_1."' AND '".$fecha_ini_2."' ";   
            }
            if ($cliente != null) {
                $where_cliente   = " AND cli_id = ".$cliente;
            }            
            if ($sprint != NULL) {
                $where_sprint = " AND enr_id IN (".$sprint.") ";
            }
            if ($etapa != null) {
                $where_etapas = " AND sgi_id_etr IN (".$etapa.") ";
                $having_etapas  = "HAVING ID_ETAPA IN (".$etapa.") ";
            }
            $reporte = $this->desarrollo_model->get_incidencias_cliente($where_cliente, $where_sprint, $where_etapas, 1, $having_etapas,$where_fecha);
            //print_r($this->db->last_query());die();    
            $filename = 'rpt_incidencias_cliente' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);            
            $data['nombre_cliente'] = $nombre_cliente;
            $data['nombre_sprint']  = $nombre_sprint;
            $data['nombre_etapa']   = $nombre_etapa;
            $data['estado']         = $estado;            
            $data['filename'] 		= $filename;
            $data['reporte'] 		= $reporte;
            $data['tipo_reporte'] 	= $tipo_reporte;           
            $html = $this->load->view('desarrollo/salidas/reporte_incidencias_cliente', $data, true);		
            if ($flag) {
                $dato["html"] = $html;
                echo json_encode($dato);
                die();
            } else {
                if ($tipo_reporte == 'pdf') {
                    $data['titulo'] = 'de estado de incidencias por cliente';
                    $header = $this->load->view('reporte/header', $data, true);
                    $GLOBALS['nombre_reporte'] = 'reporte_incidencias_cliente' . date('dmY');
                    $reporte = $header . $html;
                    $this->pdf->makePdf($reporte, 'L', 'reporte_incidencias_cliente', 'Letter');
                } elseif ($tipo_reporte == 'excel') {
                    $filename = 'rpt_incidencias_cliente_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
                    $data['titulo'] = 'de estado de incidencias por cliente';
                    $data['filename'] = $filename;
                    echo $html;
                }
            }
            
        } else{
            redirect('desarrollo/salidas/incidencias_cliente');
		}
	}

    function get_sprintxcliente(){
        if ($_POST){
            $cliente    = $this->input->post('cliente');
            $estado     = ($this->input->post('estado')) ? $this->input->post('estado') : 1;
                      $this->db->join("pry_proyecto","pry_id = enr_id_pry");
                      $this->db->join("inc_incidencia","inc_id_pry = pry_id");
                      $this->db->join("inl_incidencia_cliente","inl_id_inc = inc_id");
            $result = $this->gsatelite->get_dropdown('enr_entregable','{enr_codigo} - {enr_nombre}','', array("inl_id_cli" => $cliente, "enr_estado" => $estado), null, '', 'enr_id', true);
            $result     = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $result);
            echo $result;
            die();
        } else {
            redirect('desarrollo/salidas/incidencias_cliente');
        }
    }

    function _cargarvista($data=0,$crud=0){	
        $this->load->view('vacia',$crud);	
        if($data!=0)
            $data=array_merge($data,$this->masterpage->getUsuario());
        else
            $data=$this->masterpage->getUsuario();
        $vista=$data['modulo'].'/'.$data['control'].'/'.$data['funcion'];
        $this->masterpage->setMasterPage('masterpage_default');
        $this->masterpage->addContentPage($vista, 'content',$data);
        $this->masterpage->show();
    }


    // public function cumplimiento_cliente($flag = null){
    //     satelite_validar();
    //     if ($_POST){
    //         $tipo_reporte = '';
    //         $post_array = $this->input->post();
    //         if ($flag) {
    //             $proyecto = ($post_array['proyecto'] != '') ? $post_array['proyecto'] : NULL;
    //             $cliente = ($post_array['cliente'] != '') ? $post_array['cliente'] : null;
    //             $sprint = ($post_array['sprints'] != '') ? $post_array['sprints'] : NULL;
    //         } else {
    //             $proyecto = ($post_array['h_proyecto'] != '') ? $post_array['h_proyecto'] : NULL;
    //             $cliente = ($post_array['h_cliente'] != '') ? $post_array['h_cliente'] : NULL;
    //             $sprint = ($post_array['h_sprint'] != '') ? $post_array['h_sprint'] : NULL;
    //             $tipo_reporte = $post_array['tipo_reporte'];
    //         }
    //         $where = NULL;
    //         $where_in = NULL;
    //         if ($proyecto != NULL) {
    //             $where['inc_id_pry'] = $proyecto;
    //         }
    //         if ($cliente != NULL) {
    //             $where['inl_id_cli'] = $cliente;
    //         }
    //         if ($sprint != NULL) {
    //             $where_in = $sprint;
    //         }
    //         $datos = $this->desarrollo_model->get_cantidad_incidencias_cliente($where, $where_in);
    //         $filename = 'rpt_cumplimiento_cliente' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
    //         $data['datos']  = $datos;
    //         $data['tipo_reporte'] = $tipo_reporte;
    //         $data['filename'] = $filename;
    //         $data['etapas'] = $this->gsatelite->get_tabla('etr_etapa_entregable', array('etr_estado' => 1));
    //         $dato_html = $this->load->view('desarrollo/salidas/filtrar_cumplimiento_cliente', $data, true);

    //         if ($flag) {
    //             echo $dato_html;
    //             die();
    //         } else {
    //             if ($tipo_reporte == 'pdf') {
    //                 $data['titulo'] = 'Cumplimiento por Cliente';
    //                 $header = $this->load->view('reporte/header', $data, true);
    //                 $GLOBALS['nombre_reporte'] = 'reporte_cumplimiento_cliente_' . date('dmY');
    //                 $reporte = $header . $dato_html;
    //                 $this->pdf->makePdf($reporte, 'P', 'reporte_cumplimiento_cliente', 'Letter');
    //             } elseif ($tipo_reporte == 'excel') {
    //                 echo $dato_html;
    //             }
    //         }
    //     } else {        
    //         $proyectos = $this->gsatelite->get_dropdown('pry_proyecto', '{pry_inicial} - {pry_nombre}','', array('pry_estado' => 1), null, '', '', true);        
    //         $clientes  = $this->desarrollo_model->get_select_cliente_incidencia();
    //         $data['proyectos'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $proyectos);        
    //         $data['clientes'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $clientes);
    //         $data['titulo_personal']    = "Reporte de cumplimiento por cliente";
    //         $this->_cargarvista($data);
    //     }
    // }

    /**
   * @author Marlon Olmedo
   * @return retorna los option de proyectos segun su usuario
   */
    public function get_proyectoxusu(){
        satelite_validar();
        $usu_id = $this->input->post("slc_consultor");
        $where_pry = array("pry_estado" => 1, "(uxp_id_usu = $usu_id OR pry_id_usu_pm = $usu_id)" => null);

                    $this->db->join('uxp_usuarioxproyecto', 'pry_id = uxp_id_pry');
        $all_prys = $this->gsatelite->get_dropdown('pry_proyecto', '{pry_inicial} - {pry_nombre}', '', $where_pry, null, null, 'pry_id', true);
        $proyectos = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $all_prys);

        $espm = $this->gsatelite->count('pry_proyecto', array('pry_id_usu_pm' => $usu_id));

        //SE COMENTA PUES EL SPRINT / ENTREGABLE, DEPENDERA DEL PROYECTO
        // $where_ = implode(",",array_column($all_prys,"pry_id"));
        // if ($where_ != '') {
        //     $where_sprint = array('enr_activo' => 1,"enr_id_pry IN ($where_)" => NULL);
        // } else {
        //     $where_sprint = array('enr_activo' => 1);
        // }
        // $sprint = $this->gsatelite->get_dropdown('enr_entregable', '{enr_codigo}','', $where_sprint, null, null, 'enr_id', true);
        $sprint_ = '';//str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $sprint);

        echo json_encode(array("options" => $proyectos, "essprv" => $espm, "options_spr" => $sprint_));
        die();
    }

    /**
   * @author Marlon Olmedo
   * @return retorna los option de los sprint segun el proyecto seleccionado
   */
    public function get_sprintxpry(){
        satelite_validar();
        $pry_id = $this->input->post("slc_proyecto");
        $openrs = $this->gsatelite->get_dropdown('enr_entregable', '{enr_codigo}','', array('enr_activo' => 1, "enr_id_pry" => $pry_id), null, null, 'enr_id', true);
        $sprint = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $openrs);
        echo json_encode(array("options" => $sprint));
        die();
    }

    public function estadisticas_ticket() {
        satelite_validar();
        $fecha_inicio_sgk = date('Y-m-01');
        $fecha_fin_sgk = date('Y-m-t');
        $data['estado_ticket'] = $this->desarrollo_model->reporte_estado_ticket(null, $fecha_inicio_sgk, $fecha_fin_sgk);

        $fecha_inicio_cmp = date('Y-m-01');
        $fecha_fin_cmp = date('Y-m-t');
        $data['componente'] = $this->desarrollo_model->reporte_componente_ticket(null, $fecha_inicio_cmp, $fecha_fin_cmp);

        $fecha_inicio_tpp = date('Y-m-01');
        $fecha_fin_tpp = date('Y-m-t');
        $data['tipo_prioridad'] = $this->desarrollo_model->reporte_tipo_prioridad(null, $fecha_inicio_tpp, $fecha_fin_tpp);

        $data['titulo_personal'] = "Reporte de Estadisticas de Tickets";
        $this->_cargarvista($data);
    }

    public function reporte_estadisticas_estado_ticket() {
        satelite_validar();
        $post_array = $this->input->post(); 
        $fecha_inicio = ($post_array['fecha_inicio'] != '') ? date('Y-m-d', strtotime($post_array['fecha_inicio'])) : '';
        $fecha_fin = ($post_array['fecha_fin'] != '') ? date('Y-m-d', strtotime($post_array['fecha_fin'])) : '';

        $estado_ticket = $this->desarrollo_model->reporte_estado_ticket(null, $fecha_inicio, $fecha_fin);

        echo json_encode(array("resultado" => $estado_ticket));
        die();

    }

    public function reporte_estadisticas_componente() {
        satelite_validar();
        $post_array = $this->input->post(); 
        $fecha_inicio = ($post_array['fecha_inicio'] != '') ? date('Y-m-d', strtotime($post_array['fecha_inicio'])) : '';
        $fecha_fin = ($post_array['fecha_fin'] != '') ? date('Y-m-d', strtotime($post_array['fecha_fin'])) : '';

        $componente = $this->desarrollo_model->reporte_componente_ticket(null, $fecha_inicio, $fecha_fin);

        echo json_encode(array("resultado" => $componente));
        die();

    }

    public function reporte_estadisticas_tipo_prioridad() {
        satelite_validar();
        $post_array = $this->input->post(); 
        $fecha_inicio = ($post_array['fecha_inicio'] != '') ? date('Y-m-d', strtotime($post_array['fecha_inicio'])) : '';
        $fecha_fin = ($post_array['fecha_fin'] != '') ? date('Y-m-d', strtotime($post_array['fecha_fin'])) : '';

        $tipo_prioridad = $this->desarrollo_model->reporte_tipo_prioridad(null, $fecha_inicio, $fecha_fin);

        echo json_encode(array("resultado" => $tipo_prioridad));
        die();

    }    

    
}
/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */
