<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Procesos extends CI_Controller
{
    function __construct()
    {
        parent::__construct();
        $this->load->library('grocery_CRUD');
        $this->load->model('gsatelite');
        $this->load->model('desarrollo_model');
    }

    function index()
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data['titulo_personal'] = 'Desarrollo SAT';
            $this->_cargarvista(null, $data);
        }
    }

    function proyectos()
    {
        $crud = new grocery_crud();

        $columns = array(
            'pry_nombre',
            'pry_descripcion',
            'pry_icono',
            'pry_estado'
        );

        $display_as = array(
            'pry_nombre' => 'Nombre',
            'pry_descripcion' => 'Descripción',
            'pry_icono' => 'Icono',
            'pry_estado' => 'Estado'
        );

        $required = array(
            'pry_nombre',
            'pry_estado',
        );

        $crud->set_table('pry_proyecto')
            ->set_subject('Proyecto')
            ->columns($columns)
            ->display_as($display_as);
        $crud->add_action('&nbsp;Editar', '', 'desarrollo/procesos/editar_proyecto', 'icomoon-icon-pencil-5');
        $crud->add_action('&nbsp;Componentes', '', 'desarrollo/procesos/componentes', 'icomoon-icon-list-view');
        $crud->add_action('&nbsp;Incidencias', '', 'desarrollo/procesos/incidencias', ' icomoon-icon-book');
        $crud->add_action('&nbsp;Pizarra', '', 'desarrollo/procesos/pizarra', ' icomoon-icon-map-2');

        //$crud->set_field_upload('pry_icono', $this);
        $crud->callback_column('pry_icono', function ($value, $row) {
            $img = '<a href="' . base_url($value) . '" class="image-thumbnail">';
            $img .= '<img src="' . base_url($value) . '" height="50px" style="width: 125px; height: 100px;"></a>';
            return ($value != '') ? $img : '';
        });

        $crud->unset_edit()
            ->unset_export()
            ->unset_print();

        $agregar = end(explode('/', uri_string()));

        if ($agregar == 'add') {
            $crud->field_type('pry_estado', 'hidden', 1);
        } else {
            $crud->field_type('pry_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

        $output = $crud->render();
        $data['titulo_personal'] = 'Proyectos';
        $this->_cargarvista($data, $output);
    }

    /**
     * @author: Mario Marquez
     */
    function componentes($pry_id = 0)
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {


            $crud = new grocery_crud();

            $columns = array(
                'cmp_nombre',
                'cmp_id_pry',
                'cmp_icono',
                'cmp_estado',
            );

            $display_as = array(
                'cmp_nombre' => 'Nombre',
                'cmp_icono' => 'Icono',
                'cmp_id_pry' => 'Proyecto',
                'cmp_estado' => 'Estado',
            );

            $required = array(
                'cmp_nombre',
                'cmp_id_pry',
                'cmp_estado',
            );

            $crud->set_table('cmp_componente')
                ->set_subject('Componentes')
                ->set_relation('cmp_id_pry', 'pry_proyecto', '{pry_nombre}', array('pry_estado' => 1))
                ->columns($columns)
                ->display_as($display_as)
                ->field_type('cmp_estado', 'dropdown', array(1 => 'Activo', 0 => 'Inactivo'))
                ->set_field_upload('cmp_icono', 'uploads/anx_componentes')

                //->callback_column('cmp_icono',array($this,'callback_anexo_componente'))
            ;

            if ($pry_id != 0) {
                $crud->where('cmp_id_pry', $pry_id);
            } else {
                $crud->where("cmp_id_pry in (select uxp_id_pry from uxp_usuarioxproyecto where uxp_id_usu=" . $this->tank_auth->get_user_id() . ")");
            }


            $crud->unset_add()
                ->unset_edit()
                //->unset_edit()
            ;

            if ($pry_id != 0) {
                $crud->add_action('&nbsp;Editar', '', 'desarrollo/procesos/editar_componente/' . $pry_id, 'icon16 icomoon-icon-pencil-5', '');
            } else {
                $crud->add_action('&nbsp;Editar', '', 'desarrollo/procesos/editar_componente/0', 'icon16 icomoon-icon-pencil-5', '');
            }

            $output = $crud->render();

            //$data['proyectos'] = $this->gsatelite->get_dropdown('pry_proyecto','{pry_nombre}','proyectos',array('pry_estado'=>1),$pry_id,'','',true);

            $data['proyectos'] = $this->desarrollo_model->get_proyectos(array('uxp_id_usu' => $this->tank_auth->get_user_id(), 'pry_estado' => 1));

            $data['titulo_personal'] = 'Componentes';

            $data['pry_id'] = $pry_id;

            $this->_cargarvista($data, $output);
        }
    }

    function agregar_componente($pry_id = 0)
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {

            if ($_POST) {
                //die(var_dump($_POST));
                $tipo_btn = $this->input->post('tipo_btn');
                $anexo = ($this->input->post('foto_icono') != '') ? $this->input->post('foto_icono') : null;

                $componente_array = array(
                    'cmp_id_pry' => $this->input->post('proyecto'),
                    'cmp_nombre' => $this->input->post('nombre'),
                    'cmp_icono' => $anexo,
                    'cmp_estado' => 1,
                    'cmp_usu_creacion' => $this->tank_auth->get_user_id(),
                    'cmp_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'cmp_fecha_creacion' => date('Y-m-d'),
                    'cmp_fecha_modificacion' => date('Y-m-d'),
                );

                $id = $this->gsatelite->ingresar('cmp_componente', $componente_array);

                if ($id > 0) {

                    if ($anexo != null) {
                        $ruta = 'public/temp/anx_componentes';
                        $destino = 'uploads/anx_componentes';

                        $this->mover_img_gral($ruta, $destino, $anexo);
                    }

                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Compomente ingresado", 'texto_alerta' => "La operación a sido realizada con exito");
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "La operación no pudo completarse");
                }
                $this->session->set_flashdata($alerta);

                if ($tipo_btn == 1) {
                    redirect('desarrollo/procesos/agregar_componente/' . $pry_id);
                } else {
                    redirect('desarrollo/procesos/componentes/' . $pry_id);
                }
            }

            $data['pry_id'] = $pry_id;
            $data['titulo_personal'] = 'Componentes';
            $data['proyectos'] = $this->desarrollo_model->get_proyectos(array('uxp_id_usu' => $this->tank_auth->get_user_id(), 'pry_estado' => 1));

            $this->_cargarvista($data);
        }
    }

    function editar_componente($pry_id = 0, $cmp_id = null)
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {

            if ($_POST) {
                //die(var_dump($_POST));
                $tipo_btn = $this->input->post('tipo_btn');
                $anexo = ($this->input->post('foto_icono') != '') ? $this->input->post('foto_icono') : null;

                $componente_array = array(
                    'cmp_id_pry' => $this->input->post('proyecto'),
                    'cmp_nombre' => $this->input->post('nombre'),
                    'cmp_icono' => $anexo,
                    'cmp_estado' => $this->input->post('estado'),
                    'cmp_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'cmp_fecha_modificacion' => date('Y-m-d H:i:s'),
                );

                $where = array('cmp_id' => $cmp_id);

                $id = $this->gsatelite->actualizar_array('cmp_componente', $componente_array, $where);

                if ($id > 0) {

                    if ($anexo != null) {
                        $ruta = 'public/temp/anx_componentes';
                        $destino = 'uploads/anx_componentes';

                        $this->mover_img_gral($ruta, $destino, $anexo);
                    }

                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Compomente ingresado", 'texto_alerta' => "La operación a sido realizada con exito");
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "La operación no pudo completarse");
                }
                $this->session->set_flashdata($alerta);

                if ($tipo_btn == 1) {
                    redirect('desarrollo/procesos/agregar_componente/' . $pry_id);
                } else {
                    redirect('desarrollo/procesos/componentes/' . $pry_id);
                }
            }

            $data['pry_id'] = $pry_id;

            $componente = $this->gsatelite->get_tabla('cmp_componente', array('cmp_id' => $cmp_id));
            //var_dump($componente);
            $data['componente'] = $componente;
            $data['titulo_personal'] = 'Componentes';
            $data['proyectos'] = $this->desarrollo_model->get_proyectos(array('uxp_id_usu' => $this->tank_auth->get_user_id(), 'pry_estado' => 1));

            $this->_cargarvista($data);
        }
    }

    function incidencias($pry_id = 0, $enr_id = 0)
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $permisos = $this->gsatelite->get_permisos_opcion();
            $data['permisos'] = $permisos;
            $crud   = new grocery_crud();
            $pry_id = null;
            $sprint = null;
            $estado = null;
            $etapa = null;
            $where_filtro = "inc_id in (0)";
            if ($_POST) {
                $inc_id         = 0;
                $pry_id         = $this->input->post("proyecto");
                $sprint         = ($this->input->post("sprint") != "") ? $this->input->post("sprint") : NULL;
                $etapa          = ($this->input->post("slc_etapa") != "") ? $this->input->post("slc_etapa") : NULL;
                $estado          = ($this->input->post("slc_estado") != "") ? $this->input->post("slc_estado") : NULL;
                $responsable    = ($this->input->post("slc_responsable") != "") ? $this->input->post("slc_responsable") : NULL;
                $cliente        = ($this->input->post("slc_cliente") != "") ? $this->input->post("slc_cliente") : NULL;
                $where_filtro = "inc_id IN 
                        (SELECT ID_INC FROM ( 
                            SELECT SUB.inc_id AS ID_INC, 
                            (SELECT sgi_id_etr FROM  sgi_seguimiento_inc 
                            WHERE sgi_id_inc=SUB.inc_id ORDER BY 
                             sgi_fecha DESC LIMIT 1)  AS ID_ETAPA  
                             from inc_incidencia SUB
                             left join inl_incidencia_cliente on inl_id_inc = inc_id
                             WHERE

                         ";

                $where["pry_id"] =  $pry_id;
                $aplica_and = false;

                if ($pry_id > 0) {
                    $where_filtro .= " SUB.inc_id_pry = $pry_id";
                    $aplica_and = true;
                }

                if ($sprint > 0) {
                    $where_filtro .= (($aplica_and) ? " AND " : "") . " SUB.inc_id_enr = $sprint";
                    $aplica_and = true;
                } elseif (trim($sprint) != '' and $sprint == 0) {
                    $where_filtro .= (($aplica_and) ? " AND " : "") . " SUB.inc_id_enr IS NULL";
                    $aplica_and = true;
                }

                if ($responsable > 0) {
                    $where_filtro .= (($aplica_and) ? " AND " : "") . " SUB.inc_id_usr_asignado = $responsable ";
                }

                if ($cliente > 0) {
                    $where_filtro .= (($aplica_and) ? " AND " : "") . " inl_id_cli = $cliente ";
                }

                if ($estado != '' && $estado > -1) {
                    $where_filtro .= (($aplica_and) ? " AND " : "") . " SUB.inc_estado = $estado ";
                }

                // print_r($estado));exit();die();
                $where_filtro .= " GROUP BY SUB.inc_id";

                if ($etapa  > 0) {
                    $where_filtro .= " HAVING ID_ETAPA = $etapa ";
                    $where["etr_id"] =  $etapa;
                }

                $where_filtro .= ") q )";
                /*
                $inc_id_array   = $this->desarrollo_model->get_incidencias($where);
                if ( count($inc_id_array) >0 ){
                    foreach ( $inc_id_array as $incidencia ) {
                        $inc_id =  $inc_id.$incidencia['inc_id']. ',';
                    }
                    $inc_id = substr($inc_id, 0, -1);
                }
                */
            }

            //print_r($where_filtro); die();
            $crud->where($where_filtro);

            $columns = array(
                'inc_codigo',
                'inc_nombre',
                'inc_id_cmp',
                'inc_id_usr_asignado',
                'inc_id_enr',
                'inc_estado',
                'Etapa'
            );

            $display_as = array(
                'inc_codigo' => 'Código',
                'inc_nombre' => 'Nombre',
                'inc_id_cmp' => 'Componente',
                'inc_id_usr_asignado' => 'Responsable',
                'inc_id_enr' => 'Sprint',
                'inc_estado' => 'Estado',
                'Etapa' => 'Etapa',
            );

            $required = array(
                'inc_codigo',
                'inc_nombre',
                'inc_id_cmp',
                'inc_id_usr_asignado',
            );

            $crud->set_table('inc_incidencia')
                ->set_subject('Incidencias')
                ->set_relation('inc_id_pry', 'pry_proyecto', '{pry_nombre}')
                ->set_relation('inc_id_tii', 'tii_tipo_incidencia', '{tii_nombre}')
                ->set_relation('inc_id_cmp', 'cmp_componente', '{cmp_nombre}')
                ->set_relation('inc_id_enr', 'enr_entregable', '{enr_codigo}', array('enr_estado >=' => 0))
                ->callback_column('Etapa', function ($value, $row) {
                    $this->db->limit(1);
                    $this->db->order_by('sgi_id', 'desc');
                    $this->db->join('etr_etapa_entregable', 'etr_id = sgi_id_etr');
                    $str = $this->gsatelite->get_tabla('sgi_seguimiento_inc', array('sgi_id_inc' => $row->inc_id));
                    return ($str) ? $str[0]['etr_nombre'] : '';
                })
                ->columns($columns)
                ->display_as($display_as)
                ->unset_jquery()
                ->unset_jquery_ui()
                ->callback_column('inc_id_usr_asignado', array($this, '_callback_responsable_incidencia'))
                ->field_type('inc_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'))
            ;


            $crud->unset_add()->unset_edit();
            $crud->unset_export()->unset_print();
            $crud->unset_read();

            if ($pry_id != 0) {
                if ($permisos['permite_editar']) {
                    $crud->add_action('&nbsp;Editar', '', 'desarrollo/procesos/editar_incidencia/' . $pry_id, 'icon16 icomoon-icon-pencil-5', '');
                }
                $crud->add_action('&nbsp;Asignar Sprint', '', 'desarrollo/procesos/asignar_sprint/' . $pry_id, 'btniframe icomoon-icon-checkmark-3', '');
                if ($permisos['permite_ver']) {
                    $crud->add_action('&nbsp;Detalle', '', 'desarrollo/procesos/vista_detalle_incidencia/' . $pry_id, 'icomoon-icon-search-3', '');
                }
                $crud->add_action('&nbsp;Cancelar incidencia', '', 'desarrollo/procesos/cancelar_inc/' . $pry_id, 'icomoon-icon-cancel cancela_inc', '', '', array('inc_estado' => 'Activo'));
                if ($permisos['permite_agregar']) {
                    $crud->add_action('&nbsp;Duplicar', '', 'desarrollo/procesos/duplicar_incidencia/' . $pry_id, 'icomoon-icon-copy-2', '');
                }
            } else {
                if ($permisos['permite_editar']) {
                    $crud->add_action('&nbsp;Editar', '', 'desarrollo/procesos/editar_incidencia/0', 'icon16 icomoon-icon-pencil-5', '');
                }
                $crud->add_action('&nbsp;Asignar Sprint', '', '', 'iframe icomoon-icon-checkmark-3', array($this, 'callback_asignar_sprint'));
                if ($permisos['permite_ver']) {
                    $crud->add_action('&nbsp;Detalle', '', 'desarrollo/procesos/vista_detalle_incidencia', 'icomoon-icon-search-3', '');
                }
                $crud->add_action('&nbsp;Cancelar incidencia', '', 'desarrollo/procesos/cancelar_inc/0', 'icomoon-icon-cancel cancela_inc', '', '', array('inc_estado' => 'Activo'));
            }

            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }

            $crud->add_action('&nbsp;Comentarios', '', 'desarrollo/procesos/comentarios_incidencia', 'icomoon-icon-comments-3', '');
            $output = $crud->render();

            $data['proyectos']          = $this->desarrollo_model->get_proyectos(array('uxp_id_usu' => $this->tank_auth->get_user_id(), 'pry_estado' => 1));
            //echo $this->db->last_query(); die();
            // $data['etapas']             = $this->gsatelite->get_tabla("etr_etapa_entregable",array("etr_estado" => 1));

            $data['etapas'] = $this->gsatelite->get_dropdown('etr_etapa_entregable', "etr_nombre", '', array('etr_estado' => '1'), $etapa, '', 'etr_id', true);
            $data['sprint'] = $this->gsatelite->get_dropdown('enr_entregable', "enr_codigo", '', array('enr_estado' => '1', 'enr_id_pry' => $pry_id), $sprint, '', 'enr_id', true);
            $data['clientes'] = $this->gsatelite->get_dropdown('cli_cliente', "[IF(cli_personeria=1,CONCAT_WS(' ', cli_codigo, cli_nombre, cli_apellido),CONCAT_WS(' ', cli_codigo, cli_apellido))]", '', array('cli_estado' => '1'), $cliente, '', 'cli_id', true);

            $data['slc_responsable'] = $this->get_responsable_proyecto($pry_id, $responsable, true);
            $data['titulo_personal']    = 'Incidencias';

            $data['pry_id']             = $pry_id;

            $data['estado']             = $estado;

            $enr_id                     = ($sprint != NULL) ? $sprint : 0;
            $data['enr_id']             = $sprint;

            $this->_cargarvista($data, $output);
        }
    }

    /**
     * @author: Christian Menendeez
     */
    function vista_detalle_incidencia($pry_id = 0, $inc_id = null, $enr_id = null)
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {

            $data['inc_id'] = $inc_id;
            $data['cmi_id'] = $cmi_id;

            $comentario = $this->gsatelite->get_tabla('cmi_comentario_inc', array('cmi_id_inc' => $inc_id));

            $data['comentarios'] = $comentario;

            //die(print_r($comentario,true));

            $data['pry_id'] = $pry_id;

            $data['proyectos'] = $this->gsatelite->get_tabla('pry_proyecto', array('pry_estado' => 1));

            //$data['componentes'] = $this->gsatelite->get_tabla('cmp_componente',array('cmp_estado'=>1));

            $data['responsables'] = $this->desarrollo_model->get_usuarios_completos(array('activated' => 1, /* 'emp_estado'=>1 */));

            //$data['sprints'] = $this->gsatelite->get_tabla('enr_entregable',array('enr_estado'=>1));

            // $data['clientes'] = $this->gsatelite->get_tabla('cli_cliente', array('cli_estado' => 1));


            $incidencia_cliente = $this->gsatelite->get_tabla('inl_incidencia_cliente', array('inl_id_inc' => $inc_id));
            $inl_cli = null;
            foreach ($incidencia_cliente as $fila_reg) {
                $inl_cli[] = $fila_reg['inl_id_cli'];
            }

            $data['clientes'] = $this->gsatelite->get_dropdown('cli_cliente', "[IF(cli_personeria=1,CONCAT_WS(' ', cli_codigo, cli_nombre, cli_apellido),CONCAT_WS(' ', cli_codigo, cli_apellido))]", '', array('cli_estado' => '1'), $inl_cli, '', 'cli_id', true);

            $data['tipos'] = $this->gsatelite->get_tabla('tii_tipo_incidencia', array('tii_estado' => 1));

            $data['etapas'] = $this->gsatelite->get_tabla('etr_etapa_entregable', array('etr_estado' => 1));

            $data['incidencia'] = $this->gsatelite->get_tabla('inc_incidencia', array('inc_id' => $inc_id));

            $data['anexos'] = $this->desarrollo_model->get_anexos($inc_id);

            if ($enr_id != null) {
                $data['pizarra'] = true;
                $data['enr_id'] = $enr_id;
                //die(var_dump($data['anexos']));
            }

            $userid = $this->tank_auth->get_user_id();
            $data['informador'] = $this->desarrollo_model->get_usuarios_completos(array('id' => $data['incidencia'][0]['inc_id_usr_informante']));
            $data['titulo_personal'] = 'Detalle de Incidencias';
            $this->_cargarvista($data);
        }
    }

    /**
     * @Modify: Nelson Soriano
     * @since: 23-04-2019
     * @description: Se agrego grid para Pruebas sugeridas 
     */
    function agregar_incidencia($pry_id = 0, $tkh_id = 0)
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {

            if ($_POST) {
                // die(var_dump($_POST));
                $tipo_btn = $this->input->post('tipo_btn');
                $iniciales = $this->input->post('inicial');
                $correlativo = $this->db->select_max('inc_correlativo')->where('inc_id_pry', $this->input->post('proyecto'))->get('inc_incidencia')->result_array();
                $num = ((int) $correlativo[0]['inc_correlativo']) + 1;
                $codigo = $iniciales . '_' . $num;
                $incidencia_array = array(
                    'inc_id_pry' => $this->input->post('proyecto'),
                    'inc_id_tii' => $this->input->post('tipo'),
                    'inc_id_cmp' => $this->input->post('componente'),
                    'inc_id_usr_informante' => $this->input->post('informador'),
                    'inc_id_usr_asignado' => $this->input->post('slc_responsable'),
                    'inc_id_enr' => ($this->input->post('sprint') != '' && $this->input->post('sprint') > 0) ? $this->input->post('sprint') : null,
                    //'inc_id_cli' => ($this->input->post('cliente') != '') ? $this->input->post('cliente') : null,
                    'inc_codigo' => $codigo,
                    'inc_nombre' => $this->input->post('nombre'),
                    'inc_descripcion' => $this->input->post('descripcion'),
                    'inc_importancia' => $this->input->post('importancia'),
                    'inc_estimacion' => $this->input->post('estimacion'),
                    'inc_fecha_ingreso' => date('Y-m-d H:i:s'),
                    'inc_fecha_asignacion' => date('Y-m-d H:i:s'),
                    'inc_pruebas_sugerida' => ($this->input->post('pruebas') != '') ? $this->input->post('pruebas') : null,
                    'inc_url' => ($this->input->post('url') != '') ? $this->input->post('url') : '',
                    'inc_fecha_entrega' => ($this->input->post('f_entrega') != '') ? date('Y-m-d', strtotime($this->input->post('f_entrega'))) : null,
                    'inc_pantalla' => null,
                    'inc_estado' => 1,
                    'inc_usu_creacion' => $this->tank_auth->get_user_id(),
                    'inc_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'inc_fecha_creacion' => date('Y-m-d H:i:s'),
                    'inc_fecha_modificacion' => date('Y-m-d H:i:s'),
                    'inc_correlativo' => $num,
                    'inc_fuente' => trim($this->input->post('fuente')),
                    'inc_id_tkh' => ($tkh_id > 0 ) ? $tkh_id : null,
                );
                $id = $this->gsatelite->ingresar('inc_incidencia', $incidencia_array);
                // Recorremos la grid con las pruebas sugeridas
                if ((is_array($_POST['pantalla'])) && (count($_POST['pantalla']) > 0)) {
                    $n_elements  = count($_POST['pantalla']);
                    for ($i = 0; $i < $n_elements; $i++) {
                        $pantalla  = $_POST['pantalla'][$i];
                        $flujo     = $_POST['flujo'][$i];
                        $resultado = $_POST['resultado'][$i];
                        $obtenido  = $_POST['obtenido'][$i];
                        $estadop   = ($_POST['estadop'][$i] != '') ? $_POST['estadop'][$i] : null;
                        $array_pruebas = array(
                            'pbg_id_inc'             => $id,
                            'pbg_id_esb'             => $estadop,
                            'pbg_pantalla'           => $pantalla,
                            'pbg_flujo'              => $flujo,
                            'pbg_resultado_esperado' => $resultado,
                            'pbg_resultado_obtenido' => $obtenido,
                            'pbg_estado'             => 1,
                            'pbg_usu_creacion'       => $this->tank_auth->get_user_id(),
                            'pbg_usu_modificacion'   => $this->tank_auth->get_user_id(),
                            'pbg_fecha_creacion'     => date('Y-m-d H:i:s'),
                            'pbg_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('pbg_prueba_sugerida', $array_pruebas);
                    }
                }
                if ($id > 0) {
                    $inc_clientes =  $this->input->post('cliente');
                    $array_insert = array();
                    for ($i = 0; $i < count($inc_clientes); $i++) {
                        if ($inc_clientes[$i] > 0) {
                            $array_insert[] = array(
                                'inl_id_cli' => $inc_clientes[$i],
                                'inl_id_inc' => $id,
                                'inl_estado' => 1,
                                'inl_usu_creacion' => $this->tank_auth->get_user_id(),
                                'inl_fecha_creacion' => date('Y-m-d H:i:s'),
                                'inl_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'inl_fecha_modificacion' => date('Y-m-d H:i:s')
                            );
                        }
                    }
                    if (count($array_insert) > 0) {
                        $id_inl = $this->gsatelite->ingresar('inl_incidencia_cliente', $array_insert, true); //insert batch
                    }
                }
                $etapa = $this->db->select()->from('etr_etapa_entregable')->order_by('etr_orden', 'ASC')->limit(1)->get()->result_array();
                $seguimiento_array = array(
                    'sgi_id_inc' => $id,
                    'sgi_id_etr' => $etapa[0]['etr_id'],
                    'sgi_fecha' => date('Y-m-d H:i:s'),
                    'sgi_estado' => 1,
                    'sgi_usu_creacion' => $this->tank_auth->get_user_id(),
                    'sgi_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'sgi_fecha_creacion' => date('Y-m-d H:i:s'),
                    'sgi_fecha_modificacion' => date('Y-m-d H:i:s'),
                );
                $id_seg = $this->gsatelite->ingresar('sgi_seguimiento_inc', $seguimiento_array);
                $this->desarrollo_model->actualizar_etapa_inc($id_seg);

                //Se actualiza el estado del ticket segun la etapa
                if($etapa[0]['etr_id_esk'] != null && $tkh_id > 0){
                    $seguimiento_inactivar_array = array(
                        'sgk_estado' => 0,
                        'sgk_fecha_modificacion' => date('Y-m-d H:i:s'),
                        'sgk_usu_modificacion' => $this->tank_auth->get_user_id(),
                    );

                    $this->gsatelite->actualizar_array('sgk_seguimiento_ticket', $seguimiento_inactivar_array,array('sgk_id_tkh' => $tkh_id));

                    $seguimiento_tkh_array = array(
                        'sgk_id_tkh' => $tkh_id,
                        'sgk_id_esk' => $etapa[0]['etr_id_esk'],
                        'sgk_fecha' => date('Y-m-d H:i:s'),
                        'sgk_estado' => 1,
                        'sgk_usu_creacion' => $this->tank_auth->get_user_id(),
                        'sgk_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'sgk_fecha_creacion' => date('Y-m-d H:i:s'),
                        'sgk_fecha_modificacion' => date('Y-m-d H:i:s'),
                    );

                    $id_seg_tkh = $this->gsatelite->ingresar('sgk_seguimiento_ticket', $seguimiento_tkh_array);
                    //Actualizamos el Ticket
                    $ticket_array = array(
                        'tkh_id_usr_asignado' => $this->input->post('slc_responsable'),
                        'tkh_id_esk' => $etapa[0]['etr_id_esk'],
                        'tkh_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'tkh_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->actualizar_array('tkh_ticket_helpdesk', $ticket_array, array('tkh_id'=>$tkh_id));
                }                
                // Guardar los Anexos
                $rutas = $this->input->post("ruta");
                $carpeta = $this->input->post("nombreCarpeta");
                $desc = $this->input->post("descripcion");
                if (count($rutas) > 0) {
                    $carpeta = $carpeta;
                    for ($i = 0; $i < count($rutas); $i++) {
                        if ($rutas[$i] != "") {
                            $img = $rutas[$i];
                            $titulo = $this->input->post("titulo_doc" . $i);
                            //die(print_r($img.'/'.$carpeta.'/'.$titulo.'/'.$id.'/'.$desc));
                            $this->datos_imagen_gral($img, $carpeta, $titulo, $id, $desc);
                        }
                    }
                } // End guardar anexos
                if ($id > 0) {
                    $codigo_incidencia = $this->gsatelite->get_campo("inc_incidencia", "inc_codigo", array("inc_id" => $id));
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Incidencia " . $codigo_incidencia . " creada", 'texto_alerta' => "La operación a sido realizada con exito");

                    /*
                    // PENDIENTE DE REVISION Y PRUEBAS
                    //PRUEBA DE CORREOS CON MAILTRAP RONALD
                    // $servidor = 'sandbox.smtp.mailtrap.io';
                    // $cuenta = '40ed329869dd66';
                    // $clave = '7bf689e5c29816';
                    // $puerto = 2525;
                    // $tls = 0;
                    //Enviar correo con la incidencia
                    $datos_empleado = $this->db->from('users')->join('emp_empleado', 'emp_id_usu = id', 'left')->where('id', $this->input->post('slc_responsable'))->get()->result()[0];

                    //Si el usuario tiene correo registrado ejecutamos la funcionalidad
                    if ($datos_empleado->email != null) {
                        $usuario_que_envia = $this->db->from('users')->join('emp_empleado', 'emp_id_usu = id', 'left')->where('id', $this->tank_auth->get_user_id())->get()->result()[0];
                        $datos_incidencia = $this->db->from('inc_incidencia')->join('pry_proyecto', 'pry_id = inc_id_pry')->where(array('inc_id' => $id))->get()->result()[0];
                        //Nombre usuario que envia 
                        if (!is_null($usuario_que_envia->emp_nombre)) {
                            $nombre_usuario_envia = $usuario_que_envia->emp_nombre . ' ' . $usuario_que_envia->emp_apellido;
                        } else {
                            $nombre_usuario_envia = $usuario_que_envia->username;
                        }
                        //Nombre del empleado
                        if (!is_null($datos_empleado->emp_nombre)) {
                            $nombre_empleado = $datos_empleado->emp_nombre . ' ' . $datos_empleado->emp_apellido;
                        } else {
                            $nombre_empleado = $datos_empleado->username;
                        }
                        $encabezado = "$nombre_empleado tiene la incidencia $datos_incidencia->inc_codigo asignada";
                        $mensaje    = "Código de la incidencia: $datos_incidencia->inc_codigo <br>
                                    Proyecto: $datos_incidencia->pry_nombre <br>
                                    Nombre de la incidencia: $datos_incidencia->inc_nombre <br> 
                                    Descripción: $datos_incidencia->inc_descripcion";
                        $estado     = $this->gsatelite->envio_correo($nombre_usuario_envia, $usuario_que_envia->email, $datos_empleado->email, $encabezado, $mensaje);
                        // var_dump($estado);die();
                        if ($estado == 1) {
                            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Incidencia " . $codigo_incidencia . " creada", 'texto_alerta' => "La operación a sido realizada con exito, se le ha notificado al usuario mediante correo electronico");
                        } else {
                            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Incidencia " . $codigo_incidencia . " creada", 'texto_alerta' => "La operación a sido realizada con exito, no se ha podido notificado al usuario mediante correo electronico");
                        }
                    }
                    */
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "La operación no pudo completarse");
                }
                $this->session->set_flashdata($alerta);

                if($tkh_id > 0){
                    redirect('desarrollo/inicio/tareas_pendientes');
                }                

                if ($tipo_btn == 1) {
                    redirect('desarrollo/procesos/agregar_incidencia/' . $pry_id);
                } else {
                    redirect('desarrollo/procesos/incidencias/' . $pry_id);
                }
            }


            //$proyect = $this->desarrollo_model->get_entregables($pry_id);
            //$data['sprint_standar'] = $proyect;
            $data['pry_id'] = $pry_id;

            $data['proyectos'] = $this->desarrollo_model->get_proyectos(array('uxp_id_usu' => $this->tank_auth->get_user_id(), 'pry_estado' => 1));

            //$data['componentes'] = $this->gsatelite->get_tabla('cmp_componente',array('cmp_estado'=>1));
            //$data['responsables'] = $this->gsatelite->get_tabla('users',array('activated'=>1));
            $data['responsables'] = $this->desarrollo_model->get_usuarios_completos(array('activated' => 1/* ,'emp_estado'=>1 */));
            //die(print_r($data['responsables'],true));
            //$data['usuarios'] = $this->desarrollo_model->get_usuarios_completos(array('activated'=>1));

            $userid = $this->tank_auth->get_user_id();
            $data['informador'] = $this->desarrollo_model->get_usuarios_completos(array('id' => $userid));
            //var_dump($data['informador']);
            //$data['sprints'] = $this->gsatelite->get_tabla('enr_entregable',array('enr_estado'=>1));

            //$data['clientes'] = $this->gsatelite->get_tabla('cli_cliente', array('cli_estado' => 1));
            $data['clientes'] = $this->gsatelite->get_dropdown('cli_cliente', "[IF(cli_personeria=1,CONCAT_WS(' ', cli_codigo, cli_nombre, cli_apellido),CONCAT_WS(' ', cli_codigo, IF(TRIM(cli_apellido)='', cli_nombre, cli_apellido )))]", '', array('cli_estado' => '1'), null, '', 'cli_id', true);

            $data['tipos'] = $this->gsatelite->get_tabla('tii_tipo_incidencia', array('tii_estado' => 1));

            $data['etapas'] = $this->gsatelite->get_tabla('etr_etapa_entregable', array('etr_estado' => 1));
            $data['titulo_personal'] = 'Incidencias';
            $id = $this->gsatelite->get_campo('esb_estado_prueba', "esb_id", array('esb_defecto' => 1));
            $data['estados_prueba'] = $this->gsatelite->get_dropdown('esb_estado_prueba', "esb_nombre", '', array('esb_estado' => '1'), $id, '', 'esb_id', true);

            $urlReturn = "desarrollo/procesos/incidencias/{$pry_id}";
            $data['tkh_id'] = $tkh_id;
            if($tkh_id > 0){
                $data['ticket'] = ($tkh_id > 0) ? $this->gsatelite->get_tabla('tkh_ticket_helpdesk', array('tkh_id'=> $tkh_id))[0] : null;

                //Obtener usuario ticket informante
                                                    $this->db->join('emp_empleado', 'emp_id_usu = id', 'left');
                $tkh_id_usr_informante = $this->gsatelite->get_registro('users', ['id' => $data['ticket']['tkh_id_usr_informante']]);
                $data['ticket_usuario_informante'] = ($tkh_id_usr_informante->emp_id != null) ? $tkh_id_usr_informante->emp_nombre . ' ' . $tkh_id_usr_informante->emp_apellido : $tkh_id_usr_informante->username;

                $data['cliente_defecto'] = $this->gsatelite->get_parametro('SYS_CLIENTE_DEFECTO');   
                $componentes = $this->gsatelite->get_tabla('cmp_componente',array('cmp_estado'=>1,'cmp_id_pry'=>$data['ticket']['tkh_id_pry']));
                $data['componentes'] = $componentes;
                $data['componente_padre'] = $this->gsatelite->get_registro('cmp_componente', array('cmp_id' => $data['ticket']['tkh_id_cmp']));
                $data['tipo_prioridad'] = $this->gsatelite->get_registro('tpp_tipo_prioridad', array('tpp_id' => $data['ticket']['tkh_id_tpp']));

                                                $this->db->join('pry_proyecto', 'pry_id = cft_id_pry');
                $data['configuracion_ticket'] = $this->gsatelite->get_registro('cft_configuracion_ticket', array('cft_id_pry' => $pry_id));
                $data['agentes'] = $this->get_dropdown_usuarios_agentes($data['configuracion_ticket']->cft_id_pry, null, true);

                $data['sprints'] = $this->gsatelite->get_tabla('enr_entregable', array('enr_id_pry' => $data['ticket']['tkh_id_pry'], 'enr_estado' => 1, 'enr_fecha_fin is null' => null));
                $data['sprint_defecto'] = $this->gsatelite->get_registro('enr_entregable', array('enr_id' => $data['configuracion_ticket']->cft_id_enr));   
                $data['estimacion'] = $this->horasADecimal($data['componente_padre']->cmp_tiempo_ejecucion);  
                $urlReturn = "desarrollo/inicio/tareas_pendientes";
            }

            $data['urlReturn'] = $urlReturn;
            $this->_cargarvista($data);
        }
    }

    function editar_incidencia($pry_id = 0, $inc_id = null)
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($_POST) {
                // die(var_dump($_POST));
                $tipo_btn = $this->input->post('tipo_btn');
                $iniciales = $this->input->post('inicial');
                $correlativo = $this->input->post('correlativo');
                $codigo = $iniciales . '_' . $correlativo;
                $incidencia_array = array(
                    'inc_id_pry' => $this->input->post('proyecto'),
                    'inc_id_tii' => $this->input->post('tipo'),
                    'inc_id_cmp' => $this->input->post('componente'),
                    'inc_id_usr_informante' => $this->input->post('informador'),
                    'inc_id_usr_asignado' => $this->input->post('slc_responsable'),
                    'inc_id_enr' => ($this->input->post('sprint') != '' && $this->input->post('sprint') > 0) ? $this->input->post('sprint') : null,
                    //'inc_id_cli' => ($this->input->post('cliente') != '') ? $this->input->post('cliente') : null,
                    'inc_codigo' => $codigo,
                    'inc_nombre' => $this->input->post('nombre'),
                    'inc_descripcion' => $this->input->post('descripcion'),
                    'inc_importancia' => $this->input->post('importancia'),
                    'inc_estimacion' => $this->input->post('estimacion'),
                    //'inc_fecha_ingreso' => date('Y-m-d'),
                    //'inc_fecha_asignacion' => date('Y-m-d'),
                    'inc_pruebas_sugerida' => ($this->input->post('pruebas') != '') ? $this->input->post('pruebas') : null,
                    'inc_url' => ($this->input->post('url') != '') ? $this->input->post('url') : '',
                    'inc_pantalla' => (trim($this->input->post('pantalla')) != '') ? $this->input->post('pantalla') : null,
                    'inc_fecha_entrega' => ($this->input->post('f_entrega') != '') ? date('Y-m-d', strtotime($this->input->post('f_entrega'))) : null,
                    'inc_estado' => 1,
                    //'inc_usu_creacion' => $this->tank_auth->get_user_id(),
                    'inc_usu_modificacion' => $this->tank_auth->get_user_id(),
                    //'inc_fecha_creacion'=> date('Y-m-d'),
                    'inc_fecha_modificacion' => date('Y-m-d H:i:s'),
                    'inc_fuente' => trim($this->input->post('fuente'))
                );
                $where = array('inc_id' => $inc_id);
                $id = $this->gsatelite->actualizar_array('inc_incidencia', $incidencia_array, $where);
                // Recorremos la grid con las pruebas sugeridas
                $this->gsatelite->borrado_general('pbg_prueba_sugerida', array('pbg_id_inc' => $inc_id));
                if ((is_array($_POST['pantalla'])) && (count($_POST['pantalla']) > 0)) {
                    $n_elements  = count($_POST['pantalla']);
                    for ($i = 0; $i < $n_elements; $i++) {
                        $pantalla  = $_POST['pantalla'][$i];
                        $flujo     = $_POST['flujo'][$i];
                        $resultado = $_POST['resultado'][$i];
                        $obtenido  = $_POST['obtenido'][$i];
                        $estadop   = ($_POST['estadop'][$i] != '') ? $_POST['estadop'][$i] : null;
                        $array_pruebas = array(
                            'pbg_id_inc'             => $inc_id,
                            'pbg_id_esb'             => $estadop,
                            'pbg_pantalla'           => $pantalla,
                            'pbg_flujo'              => $flujo,
                            'pbg_resultado_esperado' => $resultado,
                            'pbg_resultado_obtenido' => $obtenido,
                            'pbg_estado'             => 1,
                            'pbg_usu_creacion'       => $this->tank_auth->get_user_id(),
                            'pbg_usu_modificacion'   => $this->tank_auth->get_user_id(),
                            'pbg_fecha_creacion'     => date('Y-m-d H:i:s'),
                            'pbg_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('pbg_prueba_sugerida', $array_pruebas);
                    }
                }
                if ($inc_id > 0) {
                    $this->gsatelite->borrado_general('inl_incidencia_cliente', array('inl_id_inc' => $inc_id));
                    $inc_clientes =  $this->input->post('cliente');
                    $array_insert = array();
                    for ($i = 0; $i < count($inc_clientes); $i++) {
                        if ($inc_clientes[$i] > 0) {
                            $array_insert[] = array(
                                'inl_id_cli' => $inc_clientes[$i], 
                                'inl_id_inc' => $inc_id, 
                                'inl_estado' => 1, 
                                'inl_usu_creacion' => $this->tank_auth->get_user_id(), 
                                'inl_fecha_creacion' => date('Y-m-d H:i:s'), 
                                'inl_usu_modificacion' => $this->tank_auth->get_user_id(), 
                                'inl_fecha_modificacion' => date('Y-m-d H:i:s')
                            );
                        }
                    }
                    if (count($array_insert) > 0) {
                        $id_inl = $this->gsatelite->ingresar('inl_incidencia_cliente', $array_insert, true); //insert batch
                    }
                }
                // Guardar los Anexos
                $rutas = $this->input->post("ruta");
                $carpeta = $this->input->post("nombreCarpeta");
                $desc = $this->input->post("descripcion");
                if (count($rutas) > 0) {
                    $carpeta = $carpeta;
                    for ($i = 0; $i < count($rutas); $i++) {
                        if ($rutas[$i] != "") {
                            $img = $rutas[$i];
                            $titulo = $this->input->post("titulo_doc" . $i);
                            //die(print_r($img.'*'.$carpeta.'*'.$titulo.'*'.$inc_id.'*'.$desc));
                            $this->datos_imagen_gral($img, $carpeta, $titulo, $inc_id, $desc);
                        }
                    }
                } // End guardar anexos
                if ($id > 0) {
                    $codigo_incidencia = $this->gsatelite->get_campo("inc_incidencia", "inc_codigo", array("inc_id" => $id));

                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Incidencia " . $codigo_incidencia . " creada", 'texto_alerta' => "La operación a sido realizada con exito");

                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Incidencia " . $codigo_incidencia . "  actualizada", 'texto_alerta' => "La operación a sido realizada con exito");
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "La operación no pudo completarse");
                }
                $this->session->set_flashdata($alerta);
                if ($tipo_btn == 1) {
                    redirect('desarrollo/procesos/editar_incidencia/' . $pry_id . '/' . $inc_id);
                } else {
                    redirect('desarrollo/procesos/incidencias/' . $pry_id);
                }
            }



            $data['pry_id'] = $pry_id;
            $data['inc_id'] = $inc_id;
            $id = $this->gsatelite->get_campo('esb_estado_prueba', "esb_id", array('esb_defecto' => 1));
            $data['estados_prueba'] = $this->gsatelite->get_dropdown('esb_estado_prueba', "esb_nombre", '', array('esb_estado' => '1'), $id, '', 'esb_id', true);
            $data['incidencia'] = $this->gsatelite->get_tabla('inc_incidencia', array('inc_id' => $inc_id));
            $pruebas            = $this->desarrollo_model->get_pruebas_sugeridas(array('pbg_estado' => 1, 'pbg_id_inc' => $inc_id));
            $estadosx           = array();
            foreach ($pruebas as $key => $valor) {
                $select     = $this->gsatelite->get_dropdown('esb_estado_prueba', "esb_nombre", '', array('esb_estado' => '1'), $valor['esb_id'], '', 'esb_id', true);
                $select_limp = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $select);
                $estadosx[] = array('data' => $valor, "selector" => $select_limp);
            }
            $data['infox']  =  $estadosx;
            $data['proyectos']  = $this->desarrollo_model->get_proyectos(array('uxp_id_usu' => $this->tank_auth->get_user_id(), 'pry_estado' => 1));

            //$data['componentes'] = $this->gsatelite->get_tabla('cmp_componente',array('cmp_estado'=>1));


            //$data['responsables'] = $this->desarrollo_model->get_usuarios_completos(array('activated' => 1, /* 'emp_estado'=>1 */));

            $data['slc_responsable'] = $this->get_responsable_proyecto($data['incidencia'][0]['inc_id_pry'], $data['incidencia'][0]['inc_id_usr_asignado'], true);

            //$data['sprints'] = $this->gsatelite->get_tabla('enr_entregable',array('enr_estado'=>1));
            $incidencia_cliente = $this->gsatelite->get_tabla('inl_incidencia_cliente', array('inl_id_inc' => $inc_id));
            $inl_cli = null;
            foreach ($incidencia_cliente as $fila_reg) {
                $inl_cli[] = $fila_reg['inl_id_cli'];
            }

            $data['clientes'] = $this->gsatelite->get_dropdown('cli_cliente', "[IF(cli_personeria=1,CONCAT_WS(' ', cli_codigo, cli_nombre, cli_apellido),CONCAT_WS(' ', cli_codigo, cli_apellido))]", '', array('cli_estado' => '1'), $inl_cli, '', 'cli_id', true);
            //$data['clientes'] = $this->gsatelite->get_tabla('cli_cliente', array('cli_estado' => 1));

            $data['tipos'] = $this->gsatelite->get_tabla('tii_tipo_incidencia', array('tii_estado' => 1));

            $data['etapas'] = $this->gsatelite->get_tabla('etr_etapa_entregable', array('etr_estado' => 1));

            $data['anexos'] = $this->desarrollo_model->get_anexos($inc_id);


            $userid = $this->tank_auth->get_user_id();
            $data['informador'] = $this->desarrollo_model->get_usuarios_completos(array('id' => $data['incidencia'][0]['inc_id_usr_informante']));
            $data['titulo_personal'] = 'Incidencias';
            $this->_cargarvista($data);
        }
    }

    function obtener_componentes($proyecto = null, $select = null, $json = null)
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {

            if ($_POST) {
                $proyecto = $this->input->post('proyecto');
                $select = $this->input->post('select');
                $json = $this->input->post('json');
                $padres = $this->input->post('padres') ?? 0;
            }

            if ($select == 1) {
                $componentes = $this->gsatelite->get_dropdown('cmp_componente', '{cmp_nombre}', 'componentes', array('cmp_estado' => 1, 'cmp_id_pry' => $proyecto), null, '', '', true);
                echo $componentes;
            } else if ($json == 1) {
                $componentes = $this->gsatelite->get_tabla('cmp_componente', array('cmp_estado' => 1, 'cmp_id_pry' => $proyecto));

                echo json_encode($componentes);
            } else if ($select == 2) {

                if ($padres == 1) {
                    $componentes = $this->gsatelite->get_tabla('cmp_componente', array('cmp_estado' => 1, 'cmp_id_pry' => $proyecto, 'cmp_es_padre' => 1));
                } else {
                $componentes = $this->gsatelite->get_tabla('cmp_componente', array('cmp_estado' => 1, 'cmp_id_pry' => $proyecto));
                }
                $options = '<option value="0">Seleccione</option>';
                foreach ($componentes as $com) {
                    if ($com['cmp_icono'] != null) {
                        $options .= '<option id="cmp_' . $com['cmp_id'] . '" value="' . $com['cmp_id'] . '" data-img="' . base_url() . 'uploads/anx_componentes/' . $com['cmp_icono'] . '">' . $com['cmp_nombre'] . '</option>';
                    } else {
                        $options .= '<option id="cmp_' . $com['cmp_id'] . '" value="' . $com['cmp_id'] . '" data-img="">' . $com['cmp_nombre'] . '</option>';
                    }
                }
                echo $options;
            } else {
                $componentes = $this->gsatelite->get_tabla('cmp_componente', array('cmp_estado' => 1, 'cmp_id_pry' => $proyecto));

                return $componentes;
            }
        }
    }

    function obtener_sprints($proyecto = null, $select = null, $json = null)
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($_POST) {
                $proyecto = $this->input->post('proyecto');
                $select = $this->input->post('select');
                $json = $this->input->post('json');
            }
            if ($select == 1) {
                $sprints = $this->gsatelite->get_dropdown('enr_entregable', '{enr_codigo}', 'sprints', array('enr_estado' => 1, 'enr_id_pry' => $proyecto, 'enr_fecha_fin is null' => null), null, '', 'enr_id', true);
                $sprints = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $sprints);
                echo $sprints;
            } else if ($json == 1) {
                $sprints = $this->gsatelite->get_tabla('enr_entregable', array('enr_estado' => 1, 'enr_id_pry' => $proyecto));
                echo json_encode($sprints);
            } else {
                $sprints = $this->gsatelite->get_tabla('enr_entregable', array('enr_estado' => 1, 'enr_id_pry' => $proyecto));
                return $sprints;
            }
        }
    }

    function validar_componente()
    {
        $proyecto = $this->input->post('proyecto');
        $nombre = $this->input->post('nombre');
        $id = $this->input->post('id');

        if ($id == '') {
            $componentes = $this->gsatelite->count('cmp_componente', array('cmp_nombre' => $nombre, 'cmp_id_pry' => $proyecto));
        } else {
            $where = array('cmp_id_pry =' => $proyecto, 'cmp_nombre =' => $nombre, 'cmp_id !=' => $id);
            //$where = 'cmp_id_pry='.$proyecto.' AND cmp_nombre="'.$nombre.'" AND cmp_id <> '.$id.' ';
            $componentes = $this->gsatelite->count('cmp_componente', $where);
        }

        echo $componentes;
    }

    public function guardar_gral($parametros, $carpeta = null, $mimes = null)
    {
        $datos = @explode($parametros);
        $carpeta = $parametros;
        //var_dump($mimes);
        if ($mimes != null) {
            $mimes = str_replace('-', '|', $mimes);
            $image = $this->upload_gral($carpeta, $mimes);
        } else {
            $image = $this->upload_gral($carpeta);
        }
        //$this->session->keep_flashdata('datos_1');
        //echo $image['upload_data']['raw_name'] . $image['upload_data']['file_ext'];
        echo $image['upload_data']['file_name'];
    }

    function upload_gral($carpeta, $mimes = null)
    {
        $ruta = FCPATH . "public/temp/" . $carpeta;
        if (!file_exists($ruta)) {
            mkdir($ruta, 0777);
        }

        $obj = &get_instance();
        $config['upload_path'] = $ruta;
        if ($mimes != null) {
            $config['allowed_types'] = $mimes;
        } else {
            $config['allowed_types'] = 'pdf|jpg|png|jpeg|doc|xls|docx|xlsx|zip|rar|txt|webm';
        }

        $obj->load->library('upload', $config);
        if (!$obj->upload->do_upload()) {
            $error = array('error' => $obj->upload->display_errors());
            return true;
        } else {
            $data = array('upload_data' => $obj->upload->data());
            return $data;
        }
        print_r($data);
    }

    function mover_img_gral($ruta, $destino, $archivo)
    {
        if (is_dir($ruta)) {
            if (copy($ruta . '/' . $archivo, $destino . '/' . $archivo)) {
                return unlink($ruta . '/' . $archivo);
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    function eliminar_imagen_gral($carpeta = "", $ruta = null)
    {

        $url = $this->input->post("url");
        echo $url;
        $carp = ($carpeta != "") ? $carpeta : "documentos";
        if ($ruta != null) {
            unlink("$ruta/$carp/" . $url);
        } else {
            unlink("./public/temp/$carp/" . $url);
        }
    }

    function callback_anexo_componente($value, $row)
    {
        return "<a class='verAnexo' href='" . base_url() . "uploads/anx_componentes/" . $row->cmp_icono . "'>$value</a>";
    }

    function agregar_proyecto()
    {
        satelite_validar();
        if ($_POST) {
            //die(var_dump($_POST));

            $foto = $this->input->post('ruta_foto');
            $carpeta = $this->input->post('nombreCarpeta');
            $parts = explode('.', $foto);
            $nombre_anexo = $parts[0];
            $usuarios = $this->input->post('usuarios');

            if ($foto != '') {
                $icono = "uploads/iconos_proyecto/" . $foto . "";
            } else {
                $icono = "";
            }

            $proyecto = array(
                'pry_nombre' => $this->input->post('nombre'),
                'pry_descripcion' => $this->input->post('descripcion'),
                'pry_inicial' => $this->input->post('iniciales'),
                'pry_id_usu_pm' => ($this->input->post('project_manager') > 0) ? $this->input->post('project_manager') : null,
                'pry_icono' => $icono,
                'pry_estado' => 1,
                'pry_usu_creacion' => $this->tank_auth->get_user_id(),
                'pry_usu_modificacion' => $this->tank_auth->get_user_id(),
                'pry_fecha_creacion' => date('Y-m-d H:i:s'),
                'pry_fecha_modificacion' => date('Y-m-d H:i:s')
            );
            //die(print_r($proyecto));
            $this->datos_anexo_proyecto(trim($foto), $carpeta, $nombre_anexo);
            $pry_id = $this->gsatelite->ingresar('pry_proyecto', $proyecto);

            if ($pry_id != 0) {
                //Se ingresan los usuarios por proyecto.
                //Se verifica que se selecciono al menos un usuario

                if (count($usuarios) > 0 && $usuarios != '') {
                    for ($i = 0; $i < count($usuarios); $i++) {
                        $uxp_array = array(
                            'uxp_id_pry' => $pry_id,
                            'uxp_id_usu' => $usuarios[$i],
                            'uxp_estado' => 1,
                            'uxp_usu_creacion' => $this->tank_auth->get_user_id(),
                            'uxp_fecha_creacion' => date('Y-m-d H:i:s'),
                            'uxp_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'uxp_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('uxp_usuarioxproyecto', $uxp_array);
                    }
                }

                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Ingreso de proyectos", 'texto_alerta' => "Ingreso efectuado correctamente");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Ingreso de proyectos", 'texto_alerta' => "Ingreso no efectuado, favor verificar información");
            }

            $this->session->set_flashdata($alerta);
            $redir = $this->input->post("boton");
            if ($redir == 1) {
                redirect('desarrollo/procesos/agregar_proyecto');
            } else {
                redirect('desarrollo/procesos/proyectos');
            }
        } else {
            $data['usuarios'] = $this->desarrollo_model->get_usuarios_completos(array('activated' => 1/* ,'emp_estado'=>1 */));
            $data['titulo_personal'] = 'Proyectos';
            $this->_cargarvista($data);
        }
    }

    public function datos_anexo_proyecto($img, $carpeta, $nombre_anexo)
    {
        $extencion = end(explode(".", $img));
        $nombre = trim($img);
        $ruta = "public/temp/" . $carpeta . "/" . $nombre;
        $carpeta_destino = "uploads/iconos_proyecto/" . $nombre_anexo . "." . trim($extencion) . "";
        copy($ruta, $carpeta_destino);
        unlink($ruta);
    }

    function editar_proyecto($id_pry = null)
    {
        satelite_validar();
        if ($_POST) {
            $foto = $this->input->post('ruta_foto');
            $carpeta = $this->input->post('nombreCarpeta');
            $parts = explode('.', $foto);
            $nombre_anexo = $parts[0];
            $usuarios = $this->input->post('usuarios');
            if ($foto != '') {
                $icono = "uploads/iconos_proyecto/" . $foto . "";
            } else {
                $icono = "";
            }

            $est = $this->input->post('estado');
            if ($est == 2) {
                $estado = 0;
            } else {
                $estado = 1;
            }
            $id_pry = $this->input->post('proyecto');
            $proyecto_edit = array(
                'pry_nombre' => $this->input->post('nombre'),
                'pry_descripcion' => $this->input->post('descripcion'),
                'pry_inicial' => $this->input->post('iniciales'),
                'pry_id_usu_pm' => ($this->input->post('project_manager') > 0) ? $this->input->post('project_manager') : null,
                'pry_icono' => $icono,
                'pry_estado' => $estado,
                'pry_usu_modificacion' => $this->tank_auth->get_user_id(),
                'pry_fecha_modificacion' => date('Y-m-d H:i:s')
            );
            //die(print_r($proyecto_edit));
            $this->datos_anexo_proyecto(trim($foto), $carpeta, $nombre_anexo);
            $registro = $this->gsatelite->actualizar_array('pry_proyecto', $proyecto_edit, array('pry_id' => $id_pry));

            if ($registro != 0) {
                //Se ingresan los usuarios por proyecto.
                //Se eliminan los usuarios ya asociados al proyecto
                $this->gsatelite->borrado_general('uxp_usuarioxproyecto', array('uxp_id_pry' => $id_pry));

                //Se verifica que se selecciono al menos un usuario
                if (count($usuarios) > 0 && $usuarios != '') {
                    for ($i = 0; $i < count($usuarios); $i++) {
                        $uxp_array = array(
                            'uxp_id_pry' => $id_pry,
                            'uxp_id_usu' => $usuarios[$i],
                            'uxp_estado' => 1,
                            'uxp_usu_creacion' => $this->tank_auth->get_user_id(),
                            'uxp_fecha_creacion' => date('Y-m-d H:i:s'),
                            'uxp_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'uxp_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('uxp_usuarioxproyecto', $uxp_array);
                    }
                }

                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Ingreso de proyectos", 'texto_alerta' => "Ingreso efectuado correctamente");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Ingreso de proyectos", 'texto_alerta' => "Ingreso no efectuado, favor verificar información");
            }

            $this->session->set_flashdata($alerta);
            $redir = $this->input->post("boton");
            if ($redir == 1) {
                redirect('desarrollo/procesos/editar_proyecto/' . $id_pry);
            } else {
                redirect('desarrollo/procesos/proyectos');
            }
        } else {
            $data['info'] = $this->gsatelite->get_tabla('pry_proyecto', array('pry_id' => $id_pry));
            $data['usuarios'] = $this->desarrollo_model->get_usuarios_completos(array('activated' => 1/* ,'emp_estado'=>1 */));
            $uxp_listado = $this->gsatelite->get_tabla('uxp_usuarioxproyecto', array('uxp_id_pry' => $id_pry));

            $data['uxp_listado'] = array_column($uxp_listado, 'uxp_id_usu');
            //die(print_r($data['info']));
            $data['titulo_personal'] = 'Proyectos';
            $this->_cargarvista($data);
        }
    }

    function _callback_responsable_incidencia($value, $row)
    {
        $resp = $this->desarrollo_model->get_usuarios_completos(array('id' => $row->inc_id_usr_asignado));
        $nombre = ($resp[0]['emp_nombre'] != "" && $resp[0]['emp_apellido'] != "") ? $resp[0]['emp_nombre'] . ' ' . $resp[0]['emp_apellido'] : $resp[0]['username'];
        return $nombre;
    }

    /**
     * @author Christian  
     * @return Ingreso de  Entregables
     */
    function entregables()
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($_POST) {
                $pry_id = $this->input->post('proyecto');
                $opt = 1;
            } else {
                $pry_id = 0;
                $opt = 0;
            }
            $crud = new grocery_crud();

            $columns = array(
                'enr_id_pry',
                'enr_nombre',
                'enr_codigo',
                'enr_fecha_inicio',
                'enr_fecha_fin',
                'enr_activo',
                'enr_estado'
            );

            $display_as = array(
                'enr_id_pry' => 'Proyecto',
                'enr_nombre' => 'Nombre',
                'enr_codigo' => 'Código',
                'enr_fecha_inicio' => 'Fecha&nbsp;Inicio',
                'enr_fecha_fin' => '&nbsp;&nbsp;Fecha&nbsp;fin&nbsp;&nbsp;',
                'enr_activo' => 'Activo',
                'enr_estado' => 'Estado'
            );

            $crud->set_table('enr_entregable')
                ->set_subject('Entregables')
                ->columns($columns)
                ->set_relation('enr_id_pry', 'pry_proyecto', '{pry_nombre}')
                ->display_as($display_as)
                ->field_type('enr_fecha_inicio', 'date')
                ->field_type('enr_fecha_fin', 'date')
                ->field_type('enr_activo', 'dropdown', array('1' => 'X', '0' => ''))
                ->field_type('enr_estado', 'dropdown', array(1 => 'Activo', 0 => 'Inactivo'))
                //->unset_delete()
            ;
                /* ->set_field_upload('cmp_icono','uploads/anx_componentes') */

                //->callback_column('cmp_icono',array($this,'callback_anexo_componente'))
            ;
            $crud->add_action('&nbsp;Iniciar Sprint', '', 'desarrollo/procesos/iniciar_sprint', 'icon16 icomoon-icon-play iniciar_sprint_modal', null, '', array('enr_fecha_inicio' => null));
            $crud->add_action('&nbsp;Finalizar Sprint', '', 'desarrollo/procesos/finalizar_sprint', 'icon16 icomoon-icon-cancel iniciar_sprint_modal', null, '', "[enr_fecha_inicio]!=null AND [enr_fecha_fin]==null");
            $crud->add_action('&nbsp;Incidencias', '', 'desarrollo/procesos/incidencias', ' icomoon-icon-book inc');

            if ($pry_id != 0) {
                $crud->where('enr_id_pry', $pry_id);
            } else {
                $crud->where("enr_id_pry in (select uxp_id_pry from uxp_usuarioxproyecto where uxp_id_usu=" . $this->tank_auth->get_user_id() . ")");
            }

            $crud->callback_column('enr_fecha_inicio', function ($value, $row) {
                return ($value) ? formatear_fecha('d-m-Y', $value) : '';
            });
            $crud->callback_column('enr_fecha_fin', function ($value, $row) {
                return ($value) ? formatear_fecha('d-m-Y', $value) : '';
            });


            $crud->unset_add()->unset_edit();

            if ($pry_id != 0) {
                $crud->add_action('&nbsp;Editar', '', 'desarrollo/procesos/editar_entregable/' . $pry_id, 'icon16 icomoon-icon-pencil-5', '');
            } else {
                $crud->add_action('&nbsp;Editar', '', 'desarrollo/procesos/editar_entregable/0', 'icon16 icomoon-icon-pencil-5', '');
            }

            $output = $crud->render();

            $data['proyectos'] = $this->gsatelite->get_dropdown('pry_proyecto', '{pry_nombre}', 'proyectos', array('pry_estado' => 1), $pry_id, '', '', true);

            $data['proyectos'] = $this->desarrollo_model->get_proyectos(array('uxp_id_usu' => $this->tank_auth->get_user_id(), 'pry_estado' => 1));

            //die(print_r($data['proyectos'],true));

            $data['titulo_personal'] = 'Entregables';

            $data['pry_id'] = $pry_id;
            $data['opt'] = $opt;

            $this->_cargarvista($data, $output);
        }
    }

    /**
     * @author Christian  
     * @return agregar de  Entregables
     */
    function agregar_entregables($pry_id = 0)
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($_POST) {
                //die(print_r($_POST));
                $tipo_btn = $this->input->post('tipo_btn');
                $proyecto = $this->input->post('proyecto');
                $estado_activo = $this->input->post('activo');
                $enr_consultor = $this->input->post('cantidad_equipo');
                $ultimo = $this->desarrollo_model->correlativo($proyecto);

                foreach ($ultimo as $key => $value) {

                    $correlativo_val = $value['ultimo'] + 1;
                    //die(print_r($correlativo_val,true));
                }
                $correlativo_val = ($correlativo_val < 100) ? str_pad((int)($correlativo_val), 3, "0", STR_PAD_LEFT) : (int)($correlativo_val);
                //$cod_inicial=$this->desarrollo_model->codigo($proyecto);
                $cod_inicial = $this->gsatelite->get_tabla('pry_proyecto', array('pry_id' => $proyecto));

                foreach ($cod_inicial as $key => $value) {
                    $generacion_cod = "SP_" . $value['pry_inicial'] . "_" . $correlativo_val;
                    //die(print_r($generacion_cod,true));
                }

                $entregable_array = array(
                    'enr_id_pry' => $proyecto,
                    'enr_nombre' => $this->input->post('nombre'),
                    'enr_codigo' => $generacion_cod,
                    'enr_fecha_inicio' => null,
                    'enr_fecha_fin' => null,
                    'enr_consultor' => $enr_consultor,
                    'enr_activo' => (!empty($estado_activo)) ? $estado_activo : 0,
                    'enr_correlativo' => $correlativo_val,
                    'enr_num_hora_efectiva' => ($this->input->post('horas_efectivas') > 0) ? $this->input->post('horas_efectivas') : null,
                    'enr_num_dia_programa' => ($this->input->post('dias_programa') > 0) ? $this->input->post('dias_programa') : null,
                    'enr_observacion' => (trim($this->input->post('observaciones')) != '') ? $this->input->post('observaciones') : null,
                    'enr_estado' => 1,
                    'enr_usu_creacion' => $this->tank_auth->get_user_id(),
                    'enr_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'enr_fecha_creacion' => date('Y-m-d H:i:s'),
                    'enr_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                //die(print_r($entregable_array,true));
                $id = $this->gsatelite->ingresar('enr_entregable', $entregable_array);

                if ($id > 0) {

                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Compomente ingresado", 'texto_alerta' => "La operación a sido realizada con exito");
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "La operación no pudo completarse");
                }
                $this->session->set_flashdata($alerta);

                if ($tipo_btn == 1) {
                    redirect('desarrollo/procesos/agregar_entregables/' . $pry_id);
                } else {
                    redirect('desarrollo/procesos/entregables/' . $pry_id);
                }
            }

            $data['pry_id'] = $pry_id;
            $data['titulo_personal'] = 'Agrear Entregables';
            $data['proyectos'] = $this->desarrollo_model->get_proyectos(array('uxp_id_usu' => $this->tank_auth->get_user_id(), 'pry_estado' => 1));

            $this->_cargarvista($data);
        }
    }

    /**
     * @author Christian  
     * @return editar de  Entregables
     */
    function editar_entregable($pry_id = 0, $enr_id = null)
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {

            $entregable = $this->gsatelite->get_tabla('enr_entregable', array('enr_id' => $enr_id));

            if ($_POST) {
                //die(var_dump($_POST));
                $tipo_btn = $this->input->post('tipo_btn');

                $proyecto = $this->input->post('proyecto');
                $estado_activo = $this->input->post('activo');
                $estado_auditoria = $this->input->post('estado');
                $enr_consultor = $this->input->post('cantidad_equipo');

                $ultimo = $this->desarrollo_model->correlativo($proyecto);

                foreach ($ultimo as $key => $value) {

                    $correlativo_val = $value['ultimo'] + 1;
                    //die(print_r($correlativo_val,true));
                }



                //$cod_inicial=$this->desarrollo_model->codigo($proyecto);
                $cod_inicial = $this->gsatelite->get_tabla('pry_proyecto', array('pry_id' => $proyecto));

                foreach ($cod_inicial as $key => $value) {
                    $generacion_cod = "SP_" . $value['pry_inicial'] . "_" . $correlativo_val;

                    //die(print_r($generacion_cod,true));
                }



                $entregable_array = array(
                    'enr_id_pry' => $proyecto,
                    'enr_nombre' => $this->input->post('nombre'),
                    'enr_consultor' => $enr_consultor,
                    'enr_activo' => (!empty($estado_activo)) ? $estado_activo : 0,
                    'enr_num_hora_efectiva' => ($this->input->post('horas_efectivas') > 0) ? $this->input->post('horas_efectivas') : null,
                    'enr_num_dia_programa' => ($this->input->post('dias_programa') > 0) ? $this->input->post('dias_programa') : null,
                    'enr_observacion' => (trim($this->input->post('observaciones')) != '') ? $this->input->post('observaciones') : null,
                    'enr_estado' => (!empty($estado_auditoria)) ? $estado_auditoria : 0,
                    'enr_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'enr_fecha_modificacion' => date('Y-m-d H:i:s')
                );

                //die(print_r($entregable_array,true));

                $where = array('enr_id' => $enr_id);

                $id = $this->gsatelite->actualizar_array('enr_entregable', $entregable_array, $where);

                if ($id > 0) {

                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Compomente ingresado", 'texto_alerta' => "La operación a sido realizada con exito");
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "La operación no pudo completarse");
                }
                $this->session->set_flashdata($alerta);

                if ($tipo_btn == 1) {
                    redirect('desarrollo/procesos/editar_entregable/' . $pry_id . '/' . $enr_id);
                } else {
                    redirect('desarrollo/procesos/entregables/' . $pry_id);
                }
            }

            $data['pry_id'] = $pry_id;


            //die(print_r($entregable,true));
            $data['entregable'] = $entregable;
            $data['titulo_personal'] = 'Editar Entregables';
            $data['proyectos'] = $this->desarrollo_model->get_proyectos(array('uxp_id_usu' => $this->tank_auth->get_user_id(), 'pry_estado' => 1));

            $this->_cargarvista($data);
        }
    }

    /**
     * @author Mario Marquez  
     * @return Asignar sprint
     */
    function asignar_sprint($pry_id = 0, $inc_id = null)
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($_POST) {
                //die(var_dump($_POST));
                $proyecto_id = $this->input->post('id_pry');
                $incidencia_id = $this->input->post('id_inc');

                $incidencia_array = array(
                    'inc_id_enr' => $this->input->post('sprint'),
                );

                $where = array('inc_id' => $incidencia_id);
                $id = $this->gsatelite->actualizar_array('inc_incidencia', $incidencia_array, $where);

                $data['close'] = $id;
            }
            if ($pry_id == 0) {

                $where = array('enr_estado' => 1);

                $data['sprints'] = $this->gsatelite->get_tabla('enr_entregable', $where);
            } else {
                $where = array('enr_estado' => 1, 'enr_id_pry' => $pry_id);

                //$data['sprints'] = $this->gsatelite->get_tabla('enr_entregable',$where);
                $data['sprints'] = $this->desarrollo_model->get_asig_incidencias($where/* array('inc_id'=>$inc_id) */);
            }

            $data['inc_id'] = $inc_id;
            $data['pry_id'] = $pry_id;

            //die(print_r($data['proyct_sprint']));
            $data['incidencia'] = $this->gsatelite->get_tabla('inc_incidencia', array('inc_id' => $inc_id));
            $this->gsatelite->cargar_vista_masterpage('desarrollo/procesos/asignar_sprint', $data);
            //$this->load->view('desarrollo/procesos/asignar_sprint',$data);
        }
    }

    /**
     * @author Edith Herrera
     */
    function validar_nombre_proyecto($id = null)
    {
        $proyecto = $this->input->post('nombre');
        if ($proyecto != '') {

            $edit = $id;
            $existe = $this->gsatelite->get_campo('pry_proyecto', 'pry_id', array('pry_nombre' => $proyecto));

            if ($existe > 0 && $existe != $edit) {
                echo json_encode(array('respuesta' => 1)); // Existe
            } else {
                echo json_encode(array('respuesta' => 2)); // No existe
            }
        }
    }

    /**
     * @author Mario Marquez  
     * @return Pizarra de incidencias
     */
    function pizarra($pry_id = 0, $enr_id = null)
    {
        satelite_validar();
        $where = array('etr_estado' => 1);
        $group_by = array('etr_orden');
        $order_by = 'etr_orden ASC';
        $etapas = $this->desarrollo_model->get_etapas_entregables($where, $order_by, $group_by);
        $data['html_incidencias'] = "";
        $data['etapas'] = $etapas;
        if ($enr_id != null) {
            $data['proyecto'] = $this->gsatelite->get_tabla('pry_proyecto', array('pry_id' => $pry_id));

            $data['sprints'] = $this->desarrollo_model->get_entregables_por_usuario(array('enr_estado' => 1, 'enr_activo' => 1, 'uxp_id_usu' => $this->tank_auth->get_user_id()));

            $sprints_id = array_column($data['sprints'], 'enr_id');
            //var_dump($sprints_id);die();
            if (!in_array($enr_id, $sprints_id)) {
                redirect('/inicio/index');
            }

            $where = array('inc.inc_id_enr' => $enr_id, 'inc_estado' => 1);
            //$order_by = 'inc.inc_id ASC';
            $order_by = 'inc.inc_importancia DESC';
            $incidencias = $this->desarrollo_model->get_data_incidencias($where, $order_by);

            $data['incidencias'] = $incidencias;

            $data['titulo_formulario'] = 'Proyecto - ' . $data['proyecto'][0]['pry_nombre'];

            $where = array('inc_id_enr' => $enr_id);
            $data['seguimiento'] = $this->desarrollo_model->get_data_seguimiento($where);
            $data['html_incidencias'] = $this->load->view('desarrollo/procesos/consultar_pizarra', $data, true);
        }
        $data['sprints'] = $this->desarrollo_model->get_entregables_por_usuario(array('enr_estado' => 1, 'enr_activo' => 1, 'uxp_id_usu' => $this->tank_auth->get_user_id()));
        $data['pry_id'] = $pry_id;

        $data['spr_id'] = $enr_id;

        $data['titulo_personal'] = 'Pizarra';

        if ($pry_id != null) {
            $this->db->join('inc_incidencia', 'id = inc_id_usr_asignado OR id = inc_id_usr_informante', 'inner');
            $this->db->where('inc_id_enr', $enr_id);
            $this->db->order_by('emp_nombre', 'ASC');
            $this->db->group_by('id');
        }
        $data['empleados'] = $this->desarrollo_model->get_usuarios_completos(array('activated' => 1));

        if ($pry_id != null) {
            $this->db->join('inl_incidencia_cliente', 'inl_id_cli = cli_id', 'inner');
            $this->db->join('inc_incidencia', 'inc_id = inl_id_inc', 'inner');
            $this->db->where('inc_id_enr', $enr_id);
            $this->db->order_by('cli_nombre', 'ASC');
            $this->db->group_by('cli_id');
        }
        $data['clientes'] = $this->gsatelite->get_tabla('cli_cliente', array('cli_estado' => 1));
        //print_r($this->db->last_query()); die();

        if ($pry_id != null) {
            $this->db->join('inc_incidencia', 'inc_id_cmp = cmp_id');
            $this->db->where('inc_id_enr', $enr_id);
            $this->db->order_by('cmp_nombre', 'ASC');
            $this->db->group_by('cmp_id');
        }
        $data['componentes'] = $this->gsatelite->get_tabla('cmp_componente', array('cmp_estado' => 1));

        $this->_cargarvista($data);
    }

    function pizarra2($pry_id = 0, $enr_id = null)
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($enr_id != null) {

                $where = array('etr_estado' => 1);
                $group_by = array('etr_orden');
                $order_by = 'etr_orden ASC';
                $etapas = $this->desarrollo_model->get_etapas_entregables($where, $order_by, $group_by);

                //var_dump($etapas);

                $data['etapas'] = $etapas;

                $data['proyecto'] = $this->gsatelite->get_tabla('pry_proyecto', array('pry_id' => $pry_id));

                $data['sprints'] = $this->desarrollo_model->get_entregables_por_usuario(array('enr_estado' => 1, 'enr_activo' => 1, 'uxp_id_usu' => $this->tank_auth->get_user_id()));

                $sprints_id = array_column($data['sprints'], 'enr_id');
                //var_dump($sprints_id);die();
                if (!in_array($enr_id, $sprints_id)) {
                    redirect('/inicio/index');
                }


                $where = array('inc.inc_id_enr' => $enr_id, 'inc_estado' => 1);
                $order_by = 'inc.inc_id ASC';
                $incidencias = $this->desarrollo_model->get_data_incidencias($where, $order_by);
                //die(var_dump($incidencias));

                $data['incidencias'] = $incidencias;

                $data['titulo_personal'] = 'Pizarra';

                $data['titulo_formulario'] = 'Proyecto - ' . $data['proyecto'][0]['pry_nombre'];

                $where = array('inc_id_enr' => $enr_id);
                $data['seguimiento'] = $this->desarrollo_model->get_data_seguimiento($where);

                $data['pry_id'] = $pry_id;
                $data['html_incidencias'] = $this->load->view('desarrollo/procesos/consultar_pizarra', $data, true);
                $data['spr_id'] = $enr_id;
                $data['empleados'] = $this->desarrollo_model->get_usuarios_completos(array('activated' => 1));
                $data['clientes'] = $this->gsatelite->get_tabla('cli_cliente', array('cli_estado' => 1));

                $this->_cargarvista($data);
            } else {
                $where = array('etr_estado' => 1);
                $group_by = array('etr_orden');
                $order_by = 'etr_orden ASC';
                $etapas = $this->desarrollo_model->get_etapas_entregables($where, $order_by, $group_by);
                //die(var_dump($etapas));
                $data['etapas'] = $etapas;


                $data['sprints'] = $this->desarrollo_model->get_entregables_por_usuario(array('enr_estado' => 1, 'enr_activo' => 1, 'uxp_id_usu' => $this->tank_auth->get_user_id()));
                // die(var_dump($data['sprints']));
                $data['titulo_personal'] = 'Pizarra';
                if ($pry_id != 0) {
                    $data['primer_sprint'] = $this->gsatelite->get_tabla('enr_entregable', array('enr_id_pry' => $pry_id));
                    //var_dump($data['primer_sprint']);
                    $where = array('inc.inc_id_enr' => $data['primer_sprint'][0]['enr_id']);
                    $order_by = 'inc.inc_importancia DESC';
                    $incidencias = $this->desarrollo_model->get_data_incidencias($where, $order_by);
                    $data['incidencias'] = $incidencias;
                }

                $data['pry_id'] = $pry_id;

                $data['spr_id'] = $enr_id;
                $data['empleados'] = $this->desarrollo_model->get_usuarios_completos(array('activated' => 1));
                $data['clientes'] = $this->gsatelite->get_tabla('cli_cliente', array('cli_estado' => 1));
                $this->_cargarvista($data);
            }
        }
    }

    /**
     * @author Christian  
     * @return Iniciar sprint
     */
    function iniciar_sprint($entregable_id = 0)
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {

            if ($_POST) {
                //$data['closeFancy'] = 1;
                $entregable_id = $this->input->post('enr_id');
                $this->session->unset_userdata();
                $fecha = $this->input->post('fecha_desde');
                $fecha_actual = date('d-m-Y');
                //die(print_r($fecha));
                $where = array('enr_id' => $entregable_id);

                $entregable_array = array(
                    'enr_fecha_inicio' => date("Y-m-d H:i:s", strtotime($fecha)),
                    'enr_activo' => 1,
                    'enr_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'enr_fecha_modificacion' => date('Y-m-d H:i:s')
                );

                $consult_existencia = $this->gsatelite->get_campo('enr_entregable', 'enr_fecha_inicio', $where);
                $estado = $this->gsatelite->get_campo('enr_entregable', 'enr_estado', $where);
                //die(print_r($consult_existencia,true));

                if (!empty($consult_existencia)) {

                    $data['close'] = 1;
                    $data['type'] = 3;
                    //die(print_r($data['close']));
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "Sprint ya a sido iniciado anteriormente");

                    //$this->session->set_flashdata($alerta);
                } else if ($estado == 0) {

                    $data['close'] = 1;
                    $data['type'] = 2;
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "Sprint inactivo");
                } else {

                    $id = $this->gsatelite->actualizar_array('enr_entregable', $entregable_array, $where);

                    if ($id > 0) {

                        $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Sprint Iniciado", 'texto_alerta' => "El Sprint a sido iniciado con éxito");
                        $data['type'] = 1;
                        $data['close'] = 2;

                        //die(print_r($data['close'] ));	
                    } else {
                        $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "Sprint no pudo iniciarse");
                    }
                }

                echo json_encode($data);
                //die(var_dump($alerta));
                //$this->session->set_flashdata($alerta);
                //redirect ('desarrollo/procesos/iniciar_sprint/'.$pry_id);
                die();
            }

            $data['entregable_id'] = $entregable_id;

            $data['titulo_personal'] = 'Iniciar Sprint';
            //$data['proyectos'] = $this->gsatelite->get_tabla('pry_proyecto',array('pry_estado'=>1));

            $this->gsatelite->cargar_vista_masterpage('desarrollo/procesos/iniciar_sprint', $data);
            //$this->_cargarvista($data);	
        }
    }

    /**
     * @author Christian  
     * @return Finalizar sprint
     */
    function finalizar_sprint($entregable_id = 0)
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($_POST) {
                $entregable_id = $this->input->post('enr_id');
                $fecha = $this->input->post('fecha_fin');
                $fecha_actual = date('d-m-Y');
                $where = array('enr_id' => $entregable_id);
                $entregable_array = array(
                    'enr_fecha_fin' => date("Y-m-d", strtotime($fecha)),
                    'enr_activo' => 0,
                    'enr_estado' => 0,
                    'enr_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'enr_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                $consult_existencia = $this->gsatelite->get_campo('enr_entregable', 'enr_fecha_fin', $where);
                $consult_existencia_f1 = $this->gsatelite->get_campo('enr_entregable', 'enr_fecha_inicio', $where);
                $estado = $this->gsatelite->get_campo('enr_entregable', 'enr_estado', $where);
                //die(print_r($consult_existencia,true));
                if (!empty($consult_existencia)) {
                    $data['close'] = 1;
                    $data['type'] = 3;
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "Sprint ya a sido finalizado anteriormente");
                } else if ($estado == 0) {
                    $data['close'] = 1;
                    $data['type'] = 2;
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "Sprint inactivo");
                } else {
                    if (!empty($consult_existencia_f1)) {
                        $id = $this->gsatelite->actualizar_array('enr_entregable', $entregable_array, $where);
                        if ($id > 0) {
                            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Sprint Finalizado", 'texto_alerta' => "La Asignación Fue Finalizada con éxito");
                            $data['type'] = 1;
                            $data['close'] = 2;
                        } else {
                            $data['type'] = 4;
                            $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "El Sprint no pudo finalizarse");
                        }
                    } else {
                        $data['type'] = 5;
                        $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "Debe iniciar Sprint para finalizarlo");
                    }
                }
                echo json_encode($data);
                die();
            }

            $data['entregable_id'] = $entregable_id;
            $data['titulo_personal'] = 'Finalizar Sprint';
            //$data['proyectos'] = $this->gsatelite->get_tabla('pry_proyecto',array('pry_estado'=>1));

            $this->gsatelite->cargar_vista_masterpage('desarrollo/procesos/finalizar_sprint', $data);
            //$this->_cargarvista($data);	
        }
    }

    /**
     * @author Mario Marquez
     * @return Registro del movimiento de incidencias
     */
    function registrar_seguimiento($inc_id = null, $etr_id = null)
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($_POST) {
                $inc_id = $this->input->post('incidencia');
                $etr_id = $this->input->post('etapa');
            }

            // verificar si la incidencia posee ticket en estado finalizado
                        $this->db->join('tkh_ticket_helpdesk', 'tkh_id = inc_id_tkh');
                        $this->db->join('esk_estado_ticket', 'tkh_id_esk = esk_id');
            $incidencia = $this->gsatelite->get_tabla('inc_incidencia', ['inc_id' => $inc_id]);
            if (count($incidencia) > 0 && $incidencia[0]['esk_finalizacion']) {
                ob_end_clean();//limpiar la cabecera (por alguna razón se imprime algo antes del die)
                echo json_encode(['error' => 1, 'message' => 'Ticket cerrado, no es posible cambiar su etapa']);
                die();
            }            

            $seguimiento_array = array(
                'sgi_id_inc' => $inc_id,
                'sgi_id_etr' => $etr_id,
                'sgi_fecha' => date('Y-m-d H:i:s'),
                'sgi_estado' => 1,
                'sgi_usu_creacion' => $this->tank_auth->get_user_id(),
                'sgi_usu_modificacion' => $this->tank_auth->get_user_id(),
                'sgi_fecha_creacion' => date('Y-m-d H:i:s'),
                'sgi_fecha_modificacion' => date('Y-m-d H:i:s'),
            );

            $id = $this->gsatelite->ingresar('sgi_seguimiento_inc', $seguimiento_array);
            $this->desarrollo_model->actualizar_etapa_inc($id);


            //Se busca la etapa y la incidencia
            $etapa = $this->gsatelite->get_tabla('etr_etapa_entregable', array('etr_id' => $etr_id));
            $incidencia = $this->gsatelite->get_tabla('inc_incidencia', array('inc_id' => $inc_id));

            //Se actualiza el estado del ticket segun la etapa
            if($etapa[0]['etr_id_esk'] != null && $incidencia[0]['inc_id_tkh'] !=null){
                $tkh_id = $incidencia[0]['inc_id_tkh'];
                $seguimiento_inactivar_array = array(
                    'sgk_estado' => 0,
                    'sgk_fecha_modificacion' => date('Y-m-d H:i:s'),
                    'sgk_usu_modificacion' => $this->tank_auth->get_user_id(),
                );

                $this->gsatelite->actualizar_array('sgk_seguimiento_ticket', $seguimiento_inactivar_array,array('sgk_id_tkh' => $tkh_id));

                $seguimiento_tkh_array = array(
                    'sgk_id_tkh' => $tkh_id,
                    'sgk_id_esk' => $etapa[0]['etr_id_esk'],
                    'sgk_fecha' => date('Y-m-d H:i:s'),
                    'sgk_estado' => 1,
                    'sgk_usu_creacion' => $this->tank_auth->get_user_id(),
                    'sgk_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'sgk_fecha_creacion' => date('Y-m-d H:i:s'),
                    'sgk_fecha_modificacion' => date('Y-m-d H:i:s'),
                );

                $id_seg_tkh = $this->gsatelite->ingresar('sgk_seguimiento_ticket', $seguimiento_tkh_array);
                $this->desarrollo_model->actualizar_etapa_ticket($id_seg_tkh);

                // Enviar correo de encuesta
                $estadoTicket = $this->gsatelite->get_tabla('esk_estado_ticket', ['esk_id' => $etapa[0]['etr_id_esk']]);
                if ($estadoTicket[0]['esk_encuesta'] == 1) {
                    // $this->enviarCorreoEncuestaTicket($tkh_id);
                }
            }            

            if ($_POST) {
                echo $id;
            } else {
                echo $id;
            }
        }
    }

    function detalle_incidencia($inc_id = null)
    {
        satelite_validar();
        if ($_POST) {
            $inc_id = $this->input->post('incidencia');
        }

        $where = array('inc.inc_id' => $inc_id);
        //$order_by = 'inc.inc_id ASC';
        $incidencia = $this->desarrollo_model->get_data_incidencias($where);

        $data['comentarios'] = $this->desarrollo_model->get_comentarios(array('cmi_id_inc' => $inc_id), 'cmi_id DESC');
        $data['anexos'] = $this->desarrollo_model->get_anexos($inc_id);
        //die(var_dump($data['anexos']));
        $data['incidencia'] = $incidencia;
        // $data['pruebas']    = $this->desarrollo_model->get_pruebas_sugeridas(array('pbg_estado' =>1, 'pbg_id_inc' => $inc_id));
        $pruebas            = $this->desarrollo_model->get_pruebas_sugeridas(array('pbg_estado' => 1, 'pbg_id_inc' => $inc_id));
        $estadosx           = array();
        foreach ($pruebas as $key => $valor) {
            $select     = $this->gsatelite->get_dropdown('esb_estado_prueba', "esb_nombre", '', array('esb_estado' => '1'), $valor['esb_id'], '', 'esb_id', true);
            $select_limp = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $select);
            $estadosx[] = array('data' => $valor, "selector" => $select_limp);
        }
        $select = $this->gsatelite->get_dropdown('esb_estado_prueba', "esb_nombre", '', array('esb_estado' => '1'), null, '', 'esb_id', true);
        $data['estados_prueba'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $select);


        $data['infox']  =  $estadosx;
        $data['id_incidencia']  =  $inc_id;

        $html = $this->load->view('desarrollo/procesos/detalle_incidencia', $data, true);

        //print_r($html);
        echo $html;
    }

    function consultar_pizarra($pry_id = 0, $enr_id = null)
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {

            if ($_POST) {
                $post_array = $this->input->post();

                $pry_id = $post_array['proyecto'];
                $enr_id = $post_array['sprint'];
            }

            $where = array('etr_estado' => 1);
            $group_by = array('etr_orden');
            $order_by = 'etr_orden ASC';
            $etapas = $this->desarrollo_model->get_etapas_entregables($where, $order_by, $group_by);

            //var_dump($etapas);

            $data['etapas'] = $etapas;

            $data['proyecto'] = $this->gsatelite->get_tabla('pry_proyecto', array('pry_id' => $pry_id));

            $data['sprints'] = $this->gsatelite->get_tabla('enr_entregable', array('enr_estado' => 1, 'enr_id_pry' => $pry_id, 'enr_activo' => 1));

            $where = array('inc.inc_id_enr' => $enr_id);
            //$order_by = 'inc.inc_id ASC';
            $order_by = 'inc.inc_importancia DESC';
            $incidencias = $this->desarrollo_model->get_data_incidencias($where, $order_by);
            //die(var_dump($incidencias));

            $data['incidencias'] = $incidencias;

            $data['titulo_personal'] = 'Pizarra';

            $data['titulo_formulario'] = 'Proyecto - ' . $data['proyecto'][0]['pry_nombre'];

            $data['pry_id'] = $pry_id;

            $data['spr_id'] = $enr_id;

            $this->load->view('desarrollo/procesos/consultar_pizarra', $data);

            //echo $html;
        }
    }

    function callback_asignar_sprint($primary_key, $row)
    {
        return base_url() . 'desarrollo/procesos/asignar_sprint/' . $row->inc_id_pry . '/' . $row->inc_id;
    }

    /**
     * @author Mario Marquez
     * @return Gestion de Comentarios por incidencia
     */
    function comentarios_incidencia($inc_id = 0)
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {

            $crud = new grocery_crud();

            $columns = array(
                'cmi_comentario',
                'cmi_url',
            );

            $display_as = array(
                'cmi_comentario' => 'Nombre',
                'cmi_url' => 'Adjuntos',
            );

            $required = array(
                'cmi_comentario',
                'cmi_estado',
            );

            $crud->set_table('cmi_comentario_inc')
                //->set_relation('cmi_id_inc','inc_incidencia','{inc_nombre}')
                ->set_subject('Comentarios')
                ->columns($columns)
                ->display_as($display_as)
                ->required_fields($required)
                ->set_rules('cmi_comentario', 'Comentario', 'required|trim')
                ->set_rules('cmi_estado', 'Estado', 'required')
                ->set_field_upload('cmi_url', 'uploads/anx_comentarios')
                ->field_type('cmi_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'))
                ->field_type('cmi_id_inc', 'hidden', $inc_id)
                ->unset_add()
                ->unset_edit()
                ->unset_export()
                ->unset_print();

            if ($inc_id != 0) {
                $crud->where('cmi_id_inc', $inc_id);
            }

            $crud->add_action('&nbsp;Editar', '', 'desarrollo/procesos/editar_comentario/' . $inc_id, 'icon16 icomoon-icon-pencil-5', '');

            $output = $crud->render();

            $data['titulo_personal'] = 'Comentarios';

            $data['inc_id'] = $inc_id;

            $this->_cargarvista($data, $output);
        }
    }

    function agregar_comentario($inc_id = 0)
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            //$data['inc_id_i']=$inc_id;
            if ($_POST) {
                //die(var_dump($_POST));

                $tipo_btn = $this->input->post('tipo_btn');
                $anexo = ($this->input->post('foto_icono') != '') ? $this->input->post('foto_icono') : null;
                $iframe = $this->input->post('iframe');

                $comentario_array = array(
                    'cmi_id_inc' => $this->input->post('incidencia'),
                    'cmi_comentario' => $this->input->post('comentario'),
                    'cmi_url' => ($anexo != '') ? $anexo : null,
                    'cmi_estado' => 1,
                    'cmi_usu_creacion' => $this->tank_auth->get_user_id(),
                    'cmi_usu_mod' => $this->tank_auth->get_user_id(),
                    'cmi_fecha_creacion' => date('Y-m-d H:i:s'),
                    'cmi_fecha_mod' => date('Y-m-d H:i:s'),
                );

                $id = $this->gsatelite->ingresar('cmi_comentario_inc', $comentario_array);

                if ($iframe == 1) {
                    echo 1;
                    //echo $id;
                    die();
                } else {
                    if ($id > 0) {

                        $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Comentario Agregado", 'texto_alerta' => "Comentario agregado correctamente");
                    } else {
                        $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "El comentario no pudo agregarse");
                    }

                    $this->session->set_flashdata($alerta);

                    if ($tipo_btn == 1) {
                        redirect('desarrollo/procesos/agregar_comentario/' . $inc_id);
                    } else {
                        redirect('desarrollo/procesos/comentarios_incidencia/' . $inc_id);
                    }
                }
            }

            $data['titulo_personal'] = 'Comentarios';

            $data['inc_id'] = $inc_id;

            if ($this->input->get('iframe') != '') {
                $data['iframe'] = 1;
                $this->gsatelite->cargar_vista_masterpage('desarrollo/procesos/agregar_comentario', $data);
            } else {
                $this->_cargarvista($data);
            }
        }
    }

    function editar_comentario($inc_id = 0, $cmi_id = null)
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($_POST) {
                //die(var_dump($_POST));

                $tipo_btn = $this->input->post('tipo_btn');
                $anexo = ($this->input->post('foto_icono') != '') ? $this->input->post('foto_icono') : null;
                $iframe = $this->input->post('iframe');

                $comentario_array = array(
                    'cmi_id_inc' => $this->input->post('incidencia'),
                    'cmi_comentario' => $this->input->post('comentario'),
                    'cmi_url' => $anexo,
                    'cmi_estado' => 1,
                    //'cmi_usu_creacion' => $this->tank_auth->get_user_id(),
                    'cmi_usu_mod' => $this->tank_auth->get_user_id(),
                    //'cmi_fecha_creacion'=> date('Y-m-d H:i:s'),
                    'cmi_fecha_mod' => date('Y-m-d H:i:s'),
                );

                $where = array('cmi_id' => $cmi_id);
                $id = $this->gsatelite->actualizar_array('cmi_comentario_inc', $comentario_array, $where);
                //$id = $this->gsatelite->ingresar('cmi_comentario_inc',$componente_array);

                if ($iframe == 1) {
                    echo $id;
                    die();
                } else {
                    if ($id > 0) {

                        $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Comentario Agregado", 'texto_alerta' => "Comentario agregado correctamente");
                    } else {
                        $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "El comentario no pudo agregarse");
                    }

                    $this->session->set_flashdata($alerta);

                    if ($tipo_btn == 1) {
                        redirect('desarrollo/procesos/editar_comentario/' . $inc_id . '/' . $cmi_id);
                    } else {
                        redirect('desarrollo/procesos/comentarios_incidencia/' . $inc_id);
                    }
                }
            }

            $data['titulo_personal'] = 'Comentarios';

            $data['inc_id'] = $inc_id;
            $data['cmi_id'] = $cmi_id;

            $comentario = $this->gsatelite->get_tabla('cmi_comentario_inc', array('cmi_id' => $cmi_id));

            $data['comentario'] = $comentario;

            if ($this->input->get('iframe') != '') {
                $data['iframe'] = 1;
                $this->gsatelite->cargar_vista_masterpage('desarrollo/procesos/agregar_comentario', $data);
            } else {
                $this->_cargarvista($data, $output);
            }
        }
    }

    function agregar_adjunto_inc($inc_id = 0)
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            //$data['inc_id_i']=$inc_id;
            if ($_POST) {
                //die(var_dump($_POST));

                $tipo_btn = $this->input->post('tipo_btn');
                $anexo = ($this->input->post('foto_icono') != '') ? $this->input->post('foto_icono') : null;
                $iframe = $this->input->post('iframe');

                $comentario_array = array(
                    'cmi_id_inc' => $this->input->post('incidencia'),
                    'cmi_comentario' => $this->input->post('comentario'),
                    'cmi_url' => ($anexo != '') ? $anexo : null,
                    'cmi_estado' => 1,
                    'cmi_usu_creacion' => $this->tank_auth->get_user_id(),
                    'cmi_usu_mod' => $this->tank_auth->get_user_id(),
                    'cmi_fecha_creacion' => date('Y-m-d H:i:s'),
                    'cmi_fecha_mod' => date('Y-m-d H:i:s'),
                );

                $id = $this->gsatelite->ingresar('cmi_comentario_inc', $comentario_array);

                if ($iframe == 1) {
                    echo 1;
                    //echo $id;
                    die();
                } else {
                    if ($id > 0) {

                        $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Comentario Agregado", 'texto_alerta' => "Comentario agregado correctamente");
                    } else {
                        $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "El comentario no pudo agregarse");
                    }

                    $this->session->set_flashdata($alerta);

                    if ($tipo_btn == 1) {
                        redirect('desarrollo/procesos/agregar_comentario/' . $inc_id);
                    } else {
                        redirect('desarrollo/procesos/comentarios_incidencia/' . $inc_id);
                    }
                }
            }

            $data['titulo_personal'] = 'Comentarios';

            $data['inc_id'] = $inc_id;

            if ($this->input->get('iframe') != '') {
                $data['iframe'] = 1;
                $this->gsatelite->cargar_vista_masterpage('desarrollo/procesos/agregar_comentario', $data);
            } else {
                $this->_cargarvista($data, $output);
            }
        }
    }

    /*
     * Mario Marquez
     */
    private function generarCodigo($longitud)
    {
        $key = '';
        $pattern = '1234567890abcdefghijklmnopqrstuvwxyz';
        $max = strlen($pattern) - 1;

        for ($i = 0; $i < $longitud; $i++)
            $key .= $pattern{mt_rand(0, $max)};

        return $key;
    }

    public function guardar_generic($carpeta = null, $mimes = null)
    {
        if ($mimes != null) {
            $mimes = str_replace('-', '|', $mimes);
            $image = $this->upload_generic($carpeta, $mimes);
        } else {
            $image = $this->upload_generic($carpeta);
        }
        //echo $image['upload_data']['raw_name'] . $image['upload_data']['file_ext'];
        echo $image['upload_data']['file_name'];
    }

    public function row_inc()
    {
        $inc_id = $this->input->post('inc_id');
        $registro = $this->gsatelite->get_tabla('inc_incidencia', array('inc_id' => $inc_id));
        echo json_encode(array('code' => $registro[0]['inc_codigo']));
    }

    function upload_generic($carpeta, $mimes = null)
    {

        $ruta = FCPATH . "uploads/" . $carpeta;
        if (!file_exists($ruta)) {
            mkdir($ruta, 0777);
        }

        $obj = &get_instance();
        $config['upload_path'] = $ruta;

        $alt = $this->generarCodigo(6);

        $config['file_name'] = $alt . '-' . $_FILES['userfile']['name'];

        if ($mimes != null) {
            $config['allowed_types'] = $mimes;
        } else {
            $config['allowed_types'] = 'pdf|jpg|png|jpeg|doc|xls|docx|xlsx|zip|rar|txt';
        }

        $obj->load->library('upload', $config);
        if (!$obj->upload->do_upload()) {
            $error = array('error' => $obj->upload->display_errors());
            return true;
        } else {
            $data = array('upload_data' => $obj->upload->data());
            return $data;
        }
        print_r($data);
    }

    /*
     * Edith Herrera
     */

    public function datos_imagen_gral($img, $carpeta, $titulo_doc, $id, $desc)
    {

        $extencion = end(explode(".", $img));
        $unico = time();
        $nombre = trim($img);
        $ruta = "public/temp/" . $carpeta . "/" . $nombre;

        // $ruta= "public/temp/".$carpeta."/".$img; // Ruta de la imagen temporal

        $carpeta_destino = "uploads/anx_pizarra/" . $unico . '_' . $titulo_doc . "." . trim($extencion) . "";

        //die(print_r($ruta.'**'.$carpeta_destino));
        $dir = $this->gsatelite->get_campo('axi_anexoxincidencia', 'axi_url', array('axi_url' => $carpeta_destino, 'axi_estado' => 1));
        //die(print_r(count($dir)));
        if (count($dir) <= 0) {
            $array_anex = array(
                'axi_id_inc' => $id,
                'axi_nombre' => $titulo_doc,
                'axi_url' => $carpeta_destino,
                'axi_estado' => 1,
                'axi_fecha_mod' => date('Y-m-d H:i:s'),
                'axi_fecha_creacion' => date('Y-m-d H:i:s'),
                'axi_usu_mod' => $this->tank_auth->get_user_id(),
                'axi_usu_creacion' => $this->tank_auth->get_user_id()
            );

            $this->db->insert("axi_anexoxincidencia", $array_anex);


            //$carpeta_destino= "uploads/anexos_detalle_ticket/".$titulo_doc.".".trim($extencion)."";

            if (!copy($ruta, $carpeta_destino)) {
                //die(print_r("No se copio el archivo")); 
            }
            unlink($ruta);
        }
    }

    function cancelar_inc($proyecto = null, $incidencia = null)
    {
        satelite_validar();
        $motivo = $this->input->post('motivo');
        if ($incidencia > 0) {
            $cancelar_inc = array(
                'inc_usu_inactiva' => $this->tank_auth->get_user_id(),
                'inc_fecha_inactiva' => date('Y-m-d H:i:s'),
                'inc_comentario_inactiva' => trim($motivo),
                'inc_estado' => 0,
                'inc_fecha_modificacion' => date('Y-m-d H:i:s'),
                'inc_usu_modificacion' => $this->tank_auth->get_user_id()
            );
            $estado = $this->gsatelite->actualizar_array('inc_incidencia', $cancelar_inc, array('inc_id' => $incidencia));
        }
        if ($estado > 0) {
            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Cancelar incidencia", 'texto_alerta' => "La incidencia se canceló correctamente");
        }
        $this->session->set_flashdata($alerta);
        if ($proyecto > 0) {
            redirect('desarrollo/procesos/incidencias/' . $proyecto);
        } else {
            redirect('desarrollo/procesos/incidencias');
        }
    }

    public function eliminar_anexinc($anexo = null, $inc = null)
    {
        if ($_POST) {
            $anexo = $this->input->post('anexo');
            $inc = $this->input->post('inc');
        }

        if ($anexo != null && $inc != null) {
            $where_anx = array('axi_id' => $anexo);

            $url = $this->gsatelite->get_campo('axi_anexoxincidencia', 'axi_url', $where_anx);

            $result = $this->gsatelite->borrado_general('axi_anexoxincidencia', $where_anx);

            if (unlink($url)) {
                echo $result;
            }
        }
    }

    public function eliminar_anex_ticket($anexo = null, $tkh = null)
    {
        if ($_POST) {
            $anexo = $this->input->post('anexo');
            $tkh = $this->input->post('tkh');
        }
        if ($anexo != null && $tkh != null) {
            $where_anx = array('axh_id' => $anexo, 'axh_id_tkh' => $tkh);

            $url = $this->gsatelite->get_campo('axh_anexo_ticket_heldesk', 'axh_url', $where_anx);

            $result = $this->gsatelite->borrado_general('axh_anexo_ticket_heldesk', $where_anx);

            if (unlink($url)) {
                echo $result;
            }
        }
    }    

    function trasladar_incidencia($pry_id = 0, $enr_id = 0)
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($_POST) {
                die(var_dump($_POST));

                $iframe = $this->input->post('iframe');

                if ($iframe == 1) {
                    echo 1;
                    //echo $id;
                    die();
                } else {
                    if ($id > 0) {

                        $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Comentario Agregado", 'texto_alerta' => "Comentario agregado correctamente");
                    } else {
                        $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "El comentario no pudo agregarse");
                    }

                    $this->session->set_flashdata($alerta);

                    redirect('desarrollo/procesos/trasladar_incidencia/' . $pry_id . '/' . $enr_id);
                }
            }

            $data['titulo_personal'] = 'Traslado de incidencias';

            $data['pry_id'] = $pry_id;
            $data['enr_id'] = $enr_id;

            $data['proyectos'] = $this->gsatelite->get_tabla('pry_proyecto', array('pry_estado' => 1));

            $where = null;
            if ($pry_id) {
                $where['inc_id_pry'] = $pry_id;
            }
            if ($enr_id) {
                $where['inc_id_enr'] = $enr_id;
            }

            $data['incidencias'] = $this->desarrollo_model->get_listado_incidencias($where);

            if ($this->input->get('iframe') != '') {
                $data['iframe'] = 1;
                $this->gsatelite->cargar_vista_masterpage('desarrollo/procesos/trasladar_incidencia', $data);
            } else {
                $this->_cargarvista($data, $output);
            }
        }
    }

    function _cargarvista($data = 0, $crud = 0)
    {
        $this->load->view('vacia', $crud);
        if ($data != 0)
            $data = array_merge($data, $this->masterpage->getUsuario());
        else
            $data = $this->masterpage->getUsuario();
        $vista = $data['modulo'] . '/' . $data['control'] . '/' . $data['funcion'];
        $this->masterpage->setMasterPage('masterpage_default');
        $this->masterpage->addContentPage($vista, 'content', $data);
        $this->masterpage->show();
    }


    /**
     * Descripción:
     * Función para verificar si el usuario es admin
     * @author René Castaneda - Grupo Satélite
     * @since 2017-11-13
     * @param ninguno
     * @return true or false
     */
    public function comprobar_usuario($id_usu = 0)
    {
        $roles = $this->desarrollo_model->get_roles_usuario($id_usu);
        $exito = 0;
        $ROL_ADMIN_SCRUM = (trim($this->gsatelite->get_parametro('SYS_ROL_SCRUM_MEETING')) != '') ? explode(',', $this->gsatelite->get_parametro('SYS_ROL_SCRUM_MEETING')) : array(0);
        for ($i = 0; $i < count($roles); $i++) {
            if (in_array($roles[$i], $ROL_ADMIN_SCRUM)) {
                return 1; //si encuentra retornar exito
            }
        }
        return $exito;
    }


    /**
     * Descripción:
     * Función para ingresar la reunion diaria de scrum
     * @author René Castaneda - Grupo Satélite
     * @since 2017-11-13
     * @param ninguno
     * @return Vista de consulta
     */
    public function daily_meeting()
    {
        //echo md5(rand().microtime()); die();
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();
        $usuario = "";
        $usuario_admin = $this->comprobar_usuario();
        //echo $usuario_admin; die();
        if (!$usuario_admin) {
            $usuario = "- " . $this->tank_auth->get_username();
        }
        $data['usuario_admin'] = $usuario_admin;
        $where_select = ($usuario_admin == 0) ? array('id' => $this->tank_auth->get_user_id(), 'activated' => '1') : array('activated' => '1');
        $selected = null;// (!$usuario_admin) ? $this->tank_auth->get_user_id() : null; no precargr nadie
        $data['permisos'] = $permisos;
        $data['slcConsultor'] = $this->gsatelite->get_dropdown('users', '{username}', '', $where_select, $selected, '', 'id', true);
        $data['titulo_personal'] = "Daily Meeting $usuario";
        cargarvista($data);
    }



    /**
     * @author René Castaneda
     * @since 2017-11-13
     * @param int $es_reporte (1=si es reporte, 0 = no es reporte)
     * @return filtrar las reuniones de scrum
     */
    public function filtrar_daily_meeting($es_reporte = 0)
    {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion('daily_meeting');
        $data['permisos'] = $permisos;
        $registros = array();
        $where_query = null;
        $usuario_admin = $this->comprobar_usuario();
        $data['usuario_admin'] = $usuario_admin;
        $slcConsultor =  ($es_reporte) ? ((trim($this->input->post('slcConsultor')) != '') ? explode(',', $this->input->post('slcConsultor')) : array()) : $this->input->post('slcConsultor');
        $txtFecha_desde = $this->input->post('txtFecha_desde');
        $txtFecha_hasta = $this->input->post('txtFecha_hasta');
        if ($this->input->post()) {
            if (($slcConsultor > 0 or (is_array($slcConsultor) and count($slcConsultor) > 0)) and $usuario_admin) { //valor simple o arreglo de valores
                $where_query['scr_id_usu_consultor'] = $slcConsultor;
            } else {
                if (!$usuario_admin) {
                    // $where_query['scr_id_usu_consultor'] = $this->tank_auth->get_user_id();
                }
            }
            if (trim($txtFecha_desde) != '') { //valor simple o arreglo de valores
                $where_query['DATE_FORMAT(scr_fecha,"%Y-%m-%d") >='] = formatear_fecha("Y-m-d", $txtFecha_desde);
            }
            if (trim($txtFecha_hasta) != '') { //valor simple o arreglo de valores
                $where_query['DATE_FORMAT(scr_fecha,"%Y-%m-%d") <='] =  formatear_fecha("Y-m-d", $txtFecha_hasta);
            }
        }
        // print_r($_POST); die();
        $registros = $this->desarrollo_model->get_reunion_scrum($where_query);
        // print_r($this->db->last_query()); die(); 
        $data['es_reporte'] = $es_reporte;
        $data['slcConsultor'] =  (is_array($this->input->post('slcConsultor'))) ? implode(',', $this->input->post('slcConsultor')) : '';
        $data['txtFecha_desde'] =  $this->input->post('txtFecha_desde');
        $data['txtFecha_hasta'] =  $this->input->post('txtFecha_hasta');

        $data['registros'] = $registros;
        $html = $this->load->view('desarrollo/procesos/filtrar_daily_meeting', $data, true);

        $filtro_titulo = "";
        if ($es_reporte) {
            $tipo_accion = $this->input->post('tipo_accion');
            $filtro_titulo .= ($txtFecha_desde != '') ? " Desde: " . $txtFecha_desde : "";
            $filtro_titulo .= ($txtFecha_hasta != '') ? " Hasta: " . $txtFecha_hasta : "";

            if ($tipo_accion) { //excel
                header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                header("Content-Disposition: attachment;filename=daily_meeting_" . date('d-m-Y_His') . ".xls");
                header("Pragma: no-cache");
                header("Expires: 0");
                echo '<meta charset="utf-8" />';
                echo "<table border='0'>
                      <tr><th colspan='9' align='center' >" . mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8') . "</th></tr>
                      <tr><th colspan='9' align='center' >Reporte Daily Meeting</th></tr>
                      <tr><th colspan='9' align='center' >" . $filtro_titulo . "</th></tr>
                      </table>";
                echo $html;
                die();
            } else { //pdf
                ini_set('memory_limit', '2048M');
                ini_set('max_execution_time', '9999');
                $this->load->library('pdf');
                $html_header = $this->load->view('reporte/header', array('titulo' => "Reporte Daily Meeting<br /> $filtro_titulo", 'solotitulo' => true), true);
                $html = str_replace('border="1" style="margin-left: 4px; width: 99%; font-size:12px;"', 'border="0.5" style="width: 100%; font-size:9px;"', $html);
                // echo $html_header.$html; die();
                $this->pdf->makePDF($html_header . $html, 'L', 'plan_trabajo', 'legal');
                die();
            }
        }
        echo json_encode(array('html' => trim($html)));
    }

    /**
     * @author René Castaneda
     * @since 2017-11-12
     * @return filtrar los sprint proyecto
     */
    public function filtrar_sprint_option()
    {
        satelite_validar(true);
        $slcEstadoSprint = $this->input->post('slcEstadoSprint');
        $where['enr_activo'] = ($slcEstadoSprint) ? 1 : 0;
        if ($this->input->post('slcProyecto') and count($this->input->post('slcProyecto')) > 0) {
            $this->db->where_in('enr_id_pry', $this->input->post('slcProyecto'));
            $data['options'] = $this->gsatelite->get_dropdown('enr_entregable', '{enr_codigo} - {enr_nombre}', '', $where, null, '', 'enr_id', true);
        } else {
            $data['options'] = $this->gsatelite->get_dropdown('enr_entregable', '{enr_codigo} - {enr_nombre}', '', $where, null, '', 'enr_id', true);
        }
        $data['options'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '<option value=""></option>', $data['options']);
        die(json_encode($data));
    }


    /**
     * @author René Castaneda
     * @since 2017-11-13
     * @return/descripction agregar resunion scrum
     */
    public function agregar_daily_meeting()
    {
        satelite_validar();
        $data["titulo_personal"] = "Daily Meeting";
        $usuario_admin = $this->comprobar_usuario();
        if ($this->input->post()) {
            // var_dump($_POST);die();
            $id_scrum = 0;
            $tipo_accion = $this->input->post('tipo_accion');
            $id_consultor = (!$usuario_admin) ? $this->tank_auth->get_user_id() : $this->input->post('slcConsultor');
            $fecha_scrum = (!$usuario_admin) ? date("Y-m-d H:i:s") : formatear_fecha('Y-m-d', $this->input->post('txtFecha'));
            $array_insert = array(
                'scr_id_usu_consultor' => $id_consultor,
                'scr_fecha' => $fecha_scrum,
                'scr_asignacion' => $this->input->post('txtAsignacion'),
                'scr_descripcion' => $this->input->post('txtRealizado'),
                'scr_problema' => $this->input->post('txtProblema'),
                'scr_siguiente_scrum' =>  $this->input->post('txtContinuar'),
                'scr_estado' => 1,
                'scr_usu_creacion' => $this->tank_auth->get_user_id(),
                'scr_fecha_creacion' => date('Y-m-d H:i:s'),
                'scr_usu_modificacion' => $this->tank_auth->get_user_id(),
                'scr_fecha_modificacion' => date('Y-m-d H:i:s')
            );
            //verificar si ya existe el registro scrum
            $pregunta = $this->gsatelite->get_tabla('scr_scrum', array('scr_id_usu_consultor' => $id_consultor, 'DATE(scr_fecha)' => formatear_fecha('Y-m-d', $fecha_scrum)));
            //solo es un scrum al dia.
            if (count($pregunta) > 0) {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error al Insertar", 'texto_alerta' => "Ya existe un registro guardado para este día.");
                $this->session->set_flashdata($alerta);
                redirect('desarrollo/procesos/daily_meeting');
            }
            $id_scrum = $this->gsatelite->ingresar('scr_scrum', $array_insert);
            if ($id_scrum > 0) {
                $avance_inc =  $this->input->post('detalle_inc');
                $avance_por =  $this->input->post('detalle_avance');
                $faltan_por =  $this->input->post('estima_falta');
                for ($i = 0; $i < count($avance_inc); $i++) {
                    if ($avance_inc[$i] > 0) {
                        $porcentaje = ($avance_por > 0) ? $avance_por[$i] : null;
                        $faltante = ($faltan_por[$i] > 0) ? $faltan_por[$i] : null;
                        $array_insert = array(
                            'ixs_id_scr' => $id_scrum,
                            'ixs_id_inc' => $avance_inc[$i],
                            'ixs_porcentaje_avance' => $porcentaje,
                            'ixs_estimacion_faltante' => $faltante,
                            'ixs_estado' => 1,
                            'ixs_usu_creacion' => $this->tank_auth->get_user_id(),
                            'ixs_fecha_creacion' => date('Y-m-d H:i:s'),
                            'ixs_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'ixs_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $id_de = $this->gsatelite->ingresar('ixs_incidencia_scrum', $array_insert);
                    }
                }
            }
            if ($id_scrum > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro Insertado", 'texto_alerta' => "Registro insertado correctamente");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error al Insertar", 'texto_alerta' => "No se pudo insertar el registro, favor verificar e intentar nuevamente");
            }
            $this->session->set_flashdata($alerta);
            if ($tipo_accion == 1) {
                redirect('desarrollo/procesos/daily_meeting');
            } else {
                redirect('desarrollo/procesos/agregar_daily_meeting');
            }
        }
        $data['usuario_admin'] = $usuario_admin;
        $where_select = ($usuario_admin == 0) ? array('id' => $this->tank_auth->get_user_id(), 'activated' => '1') : array('activated' => '1', 'emp_estado' => '1');
        $selected = ($usuario_admin) ? null : $this->tank_auth->get_user_id();
        $this->db->join('emp_empleado', 'usu_id_emp = emp_id', 'left');
        $data['slcConsultor'] = $this->gsatelite->get_dropdown('users', '{username}', '', $where_select, $selected, '', 'id', true);
        $data['horas_minimo'] = $this->gsatelite->get_parametro('SYS_HORAS_EFECTIVAS_MINIMAS', 8);
        cargarvista($data);
    }

    /**
     * @author René Castaneda
     * @since 2017-11-13
     * @return/descripction editar resunion escrum
     */
    public function editar_daily_meeting($id_scrum_edit = 0)
    {
        satelite_validar();
        $data["titulo_personal"] = "Daily Meeting";
        $usuario_admin = $this->comprobar_usuario();
        if (!$usuario_admin) {
            $registro = $this->gsatelite->get_tabla('scr_scrum', array('scr_id' => $id_scrum_edit, 'scr_id_usu_consultor' => $this->tank_auth->get_user_id(), 'date(scr_fecha)' => date('Y-m-d')));
            if (count($registro) <= 0) {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "Sin permisos de edición");
                $this->session->set_flashdata($alerta);
                redirect('desarrollo/procesos/daily_meeting');
            }
        } else {
            $registro = $this->gsatelite->get_tabla('scr_scrum', array('scr_id' => $id_scrum_edit));
            if (count($registro) <= 0) {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "Registro inconsistente");
                $this->session->set_flashdata($alerta);
                redirect('desarrollo/procesos/daily_meeting');
            }
        }
        $data['registro_scrum'] = $registro[0];
        if ($this->input->post()) {
            // var_dump($_POST);die();
            $id_scrum = 0;
            $tipo_accion = $this->input->post('tipo_accion');
            $array_update = array(
                'scr_id_usu_consultor' => (!$usuario_admin) ? $this->tank_auth->get_user_id() : $this->input->post('slcConsultor'),
                'scr_asignacion' => $this->input->post('txtAsignacion'),
                'scr_descripcion' => $this->input->post('txtRealizado'),
                'scr_problema' => $this->input->post('txtProblema'),
                'scr_siguiente_scrum' =>  $this->input->post('txtContinuar'),
                'scr_estado' => 1,
                'scr_usu_modificacion' => $this->tank_auth->get_user_id(),
                'scr_fecha_modificacion' => date('Y-m-d H:i:s')
            );
            if ($usuario_admin) {
                $array_update['scr_fecha'] = formatear_fecha('Y-m-d', $this->input->post('txtFecha'));
            }
            $exito = $this->gsatelite->actualizar_array('scr_scrum', $array_update, array('scr_id' => $id_scrum_edit));
            $id_scrum = $id_scrum_edit;
            if ($id_scrum > 0) {
                $this->gsatelite->borrado_general('ixs_incidencia_scrum', array('ixs_id_scr' => $id_scrum));
                $avance_inc =  $this->input->post('detalle_inc');
                $avance_por =  $this->input->post('detalle_avance');
                $faltan_por =  $this->input->post('estima_falta');
                for ($i = 0; $i < count($avance_inc); $i++) {
                    if ($avance_inc[$i] > 0) {
                        $porcentaje = ($avance_por > 0) ? $avance_por[$i] : null;
                        $faltante = ($faltan_por[$i] > 0) ? $faltan_por[$i] : null;
                        $array_insert = array(
                            'ixs_id_scr' => $id_scrum,
                            'ixs_id_inc' => $avance_inc[$i],
                            'ixs_porcentaje_avance' => $porcentaje,
                            'ixs_estimacion_faltante' => $faltante,
                            'ixs_estado' => 1,
                            'ixs_usu_creacion' => $this->tank_auth->get_user_id(),
                            'ixs_fecha_creacion' => date('Y-m-d H:i:s'),
                            'ixs_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'ixs_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $id_de = $this->gsatelite->ingresar('ixs_incidencia_scrum', $array_insert);
                    }
                }
            }
            if ($id_scrum > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro Actualizado", 'texto_alerta' => "Registro Actualizado correctamente");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error al Actualizar", 'texto_alerta' => "No se pudo Actualizar el registro, favor verificar e intentar nuevamente");
            }
            $this->session->set_flashdata($alerta);
            if ($tipo_accion == 1) {
                redirect('desarrollo/procesos/daily_meeting');
            } else {
                redirect('desarrollo/procesos/editar_daily_meeting/' . $id_scrum);
            }
        }

        $data['usuario_admin'] = $usuario_admin;
        $where_select = ($usuario_admin == 0) ? array('id' => $this->tank_auth->get_user_id(), 'activated' => '1') : array('activated' => '1');
        $selected = ($usuario_admin) ? $data['registro_scrum']['scr_id_usu_consultor'] : $this->tank_auth->get_user_id();
        $data['slcConsultor'] = $this->gsatelite->get_dropdown('users', '{username}', '', $where_select, $selected, '', 'id', true);
        $data['avance_incidencia'] =  $this->desarrollo_model->get_avance_incidencia(array('ixs_id_scr' => $id_scrum_edit));
        $data['horas_minimo'] = $this->gsatelite->get_parametro('SYS_HORAS_EFECTIVAS_MINIMAS', 8);
        $data['titulo_form'] = "Editar";
        cargarvista($data);
    }

    /**
     * @author René Castaneda
     * @since 2017-11-13
     * @return/descripction ver resunion escrum
     */
    public function ver_daily_meeting($id_scrum_edit = 0)
    {
        satelite_validar();
        $data["titulo_personal"] = "Daily Meeting";
        $usuario_admin = $this->comprobar_usuario();
        $registro = $this->gsatelite->get_tabla('scr_scrum', array('scr_id' => $id_scrum_edit));
        if (count($registro) <= 0) {
            $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "Registro inconsistente");
            $this->session->set_flashdata($alerta);
            redirect('desarrollo/procesos/daily_meeting');
        }
        $data['registro_scrum'] = $registro[0];
        $data['usuario_admin'] = $usuario_admin;
        $where_select = ($usuario_admin == 0) ? array('id' => $this->tank_auth->get_user_id(), 'activated' => '1') : array('activated' => '1');
        $selected = ($usuario_admin) ? $data['registro_scrum']['scr_id_usu_consultor'] : $this->tank_auth->get_user_id();
        $data['slcConsultor'] = $this->gsatelite->get_dropdown('users', '{username}', '', $where_select, $selected, '', 'id', true);
        $data['avance_incidencia'] =  $this->desarrollo_model->get_avance_incidencia(array('ixs_id_scr' => $id_scrum_edit));
        $data['titulo_form'] = "Ver";
        $data['es_ver'] = 1;
        cargarvista($data, null, 'desarrollo/procesos/editar_daily_meeting');
    }


    /**
     * @author René Castaneda
     * @since 2017-11-17
     * @return aliminar registro scrum
     */
    public function eliminar_daily_meeting($id_scrum = 0)
    {
        $usuario_admin = $this->comprobar_usuario();
        $registro = $this->gsatelite->get_tabla('scr_scrum', array('scr_id' => $id_scrum));
        if ($usuario_admin or (date('Y-m-d') == formatear_fecha('Y-m-d', $registro[0]['scr_fecha']))) {
            $this->gsatelite->borrado_general('ixs_incidencia_scrum', array('ixs_id_scr' => $id_scrum));
            $this->gsatelite->borrado_general('scr_scrum', array('scr_id' => $id_scrum));
            $this->gsatelite->show_dialog('Registro eliminado con éxito ', 'desarrollo/procesos/daily_meeting', 'success');
        }
    }

    /**
     * @author René Castaneda
     * @since 2017-11-17
     * @return filtrar incidencia de consultor
     */
    public function filtrar_incidencia_consultor()
    {
        $where['inc_estado'] = 1;
        $where['inc_id_usr_asignado'] = ($this->input->post('slcConsultor') > 0) ? $this->input->post('slcConsultor') : 0;
        $this->db->having("avance < 100");
        $data['options'] = $this->desarrollo_model->get_option_incidencias($where);
        die(json_encode($data));
    }


    /**
     * @since 2023-04-12
     * @return filtrar los sprint activos para todos los proyectos
     */
    public function filtrar_sprint_cerrar()
    {
        $data['filas'] = $this->desarrollo_model->get_ultimos_sprints_activos();
        $tabla = $this->load->view('desarrollo/procesos/detalle_cerrar_sprints', $data, true);
        die(json_encode(array('tabla' => $tabla)));
    }

    /**
     * @author René Castaneda
     * @since 2017-12-26
     * @return filtrar y mover incidencias de un sprint a otro
     */
    public function mover_incidencias_sprint()
    {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();
        if ($this->input->post()) {
            $slcEntregableMover = $this->input->post('slcEntregableMover');
            $incidencias_mover = $this->input->post('incidencias_mover');
            $n = count($incidencias_mover);
            $k = 0;
            for ($i = 0; $i < $n; $i++) {
                $datos_inc = explode('#', $incidencias_mover[$i]);
                $id_inc = $datos_inc[0];
                $estimacion_cero = ($datos_inc[1] > 0) ? true : false; //preguntar si la incidencia ira con estimación cero
                $update_inc = null;
                if ($id_inc > 0 && $slcEntregableMover > 0) {
                    $update_inc['inc_id_enr'] = $slcEntregableMover;
                    $update_inc['inc_usu_modificacion'] = $this->tank_auth->get_user_id();
                    $update_inc['inc_fecha_modificacion'] = date('Y-m-d H:i:s');
                    if ($estimacion_cero) { // consultar si aplica estimación cero.
                        //$update_inc['inc_estimacion'] = 0;
                    }
                    $this->gsatelite->actualizar_array('inc_incidencia', $update_inc, array('inc_id' => $id_inc));
                    $k++;
                }
            }
            $this->gsatelite->show_dialog("Proceso realizado con éxito <br /> <b> $k  incidencias procesadas </b>", "desarrollo/procesos/mover_incidencias_sprint");
        }
        $data['permisos'] = $permisos;
        $data['slcProyecto'] = $this->desarrollo_model->get_proyectos(array('uxp_id_usu' => $this->tank_auth->get_user_id(), 'pry_estado' => 1), true);

        $data['slcConsultors'] = $this->desarrollo_model->get_consultores(array("emp_estado" => 1));

        $data['slcEntregable'] = $this->gsatelite->get_dropdown('enr_entregable', '{enr_codigo} - {enr_nombre}', '', array('enr_id' => '0'), null, '', 'enr_id', true);

        $data['slcEtapa'] = $this->gsatelite->get_dropdown('etr_etapa_entregable', '{etr_nombre}', '', array('etr_estado' => '1'), null, '', 'etr_id', true);
        $data['titulo_personal'] = "Mover incidencias sprint";
        cargarvista($data);
    }


    /**
     * @author René Castaneda
     * @since 2017-12-27
     * @return filtrar incidencias de sprint
     */

    public function filtrar_mover_incidencias_sprint($es_reporte = 0)
    {
        satelite_validar();
        $registros = array();
        $permisos = $this->gsatelite->get_permisos_opcion('mover_incidencias_sprint');
        $data['permisos'] = $permisos;
        $slcProyecto =  $this->input->post('slcProyecto');
        $slcEntregable = $this->input->post('slcEntregable');
        $slcEtapa = $this->input->post('slcEtapa');
        $slcConsultor = $this->input->post('slcConsultor');
        $where['inc_estado'] = '1';
        $where_having = null;
        if ($this->input->post()) {
            if ($slcProyecto > 0) {
                $where['inc_id_pry'] = $slcProyecto;
            }
            if ($slcEntregable > 0) {
                $where['inc_id_enr'] = $slcEntregable;
            }
            if ($slcConsultor > 0) {
                $where['id'] = $slcConsultor;
            }
            if ((is_array($slcEtapa) && count($slcEtapa) > 0) or (substr_count($slcEtapa, ',') > 0 && trim($slcEtapa) != '') && trim($slcEtapa) != 'null') {
                $slcEtapa = (is_array($slcEtapa)) ? implode(',', $slcEtapa) : $slcEtapa;
                $where_having["id_etapa_actual in ($slcEtapa)"] = null;
            }
        }
        $registros = $this->desarrollo_model->get_incidencias_mover($where, $where_having);
        $data['es_reporte'] = $es_reporte;
        $data['slcProyecto'] = $this->input->post('slcProyecto');
        $data['slcEntregable'] = $this->input->post('slcEntregable');
        $data['slcEtapa'] = $slcEtapa; //$this->input->post('slcEtapa');
        $data['slcEntregableMover'] = $this->filtrar_entregable_option($this->input->post('slcEntregable'), true);
        $data['registros'] = $registros;
        $html = $this->load->view('desarrollo/procesos/filtrar_mover_incidencias_sprint', $data, true);

        if ($es_reporte) {
            $tipo_accion = $this->input->post('tipo_accion');
            $filtro_titulo = '';
            if ($tipo_accion) { //excel
                header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                header("Content-Disposition: attachment;filename=incidencias_" . date('d-m-Y_His') . ".xls");
                header("Pragma: no-cache");
                header("Expires: 0");
                echo '<meta charset="utf-8" />';
                echo "<table border='0'>
                  <tr><th colspan='8' align='center' >" . mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8') . "</th></tr>
                  <tr><th colspan='8' align='center' >Reporte Incidencias</th></tr>
                  <tr><th colspan='8' align='center' >" . $filtro_titulo . "</th></tr>
                  </table>";
                echo $html;
                die();
            } else { //pdf
                ini_set('memory_limit', '2048M');
                ini_set('max_execution_time', '9999');

                $this->load->library('pdf');
                $html_header = $this->load->view('reporte/header', array('titulo' => "Reporte Incidencias<br /> $filtro_titulo", 'solotitulo' => true), true);
                $html = str_replace('border="1" style="margin-left: 4px; width: 99%; font-size:12px;"', 'border="0.5" style="width: 100%; font-size:9px;"', $html);
                $this->pdf->makePDF($html_header . $html, 'lanscape', 'total_activo', 'Legal');
                die();
            }
        }
        echo json_encode(array('html' => $html));
    }

    /**
     * @author René Castaneda
     * @since 2017-12-27
     * @return filtrar los entregables dependiendo el proyecto
     */
    public function filtrar_entregable_option($id_entregable = 0, $return_html = false)
    {
        $where['enr_id_pry'] = $this->input->post('slcProyecto');
        $where['enr_estado'] = 1;
        $where['enr_activo'] = 1;
        $where['enr_id !='] = $id_entregable;
        $where['enr_fecha_fin'] = null;
        if ($where['enr_id_pry'] > 0) {
            $data['options'] = $this->gsatelite->get_dropdown('enr_entregable', '{enr_codigo} - {enr_nombre}', '', $where, null, '', 'enr_id', true);
        } else {
            $data['options'] = $this->gsatelite->get_dropdown('enr_entregable', '{enr_codigo} - {enr_nombre}', '', array('enr_id' => '0'), null, '', 'enr_id', true);
        }
        $data['options'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '<option value=""></option>', $data['options']);
        if ($return_html) {
            return $data['options'];
        }
        die(json_encode($data));
    }

    /**
     * @author Francisco Orozco
     * @since 2018-01-25
     * @return filtrar los responsables por proyeco
     */
    public function get_responsable_proyecto($proyecto = 0, $selected = null, $aplica_return = false)
    {
        $proyecto = ($this->input->post('proyecto')) ? $this->input->post('proyecto') : $proyecto;

        $this->db->join("uxp_usuarioxproyecto", "uxp_id_usu = id");
        $this->db->join("emp_empleado", "usu_id_emp = emp_id", "left");
        //$proyecto = $this->gsatelite->get_tabla("emp_empleado",array("uxp_estado" => 1, "uxp_id_pry" => $proyecto));
        $proyecto = $this->gsatelite->get_tabla("users", array("uxp_estado" => 1, "uxp_id_pry" => $proyecto, 'activated' => 1));
        $result = '<option value=""></option>';

        if (count($proyecto) > 0) {
            foreach ($proyecto as $pro) {
                //$result = $result.'<option value="'.$pro["emp_id_usu"].'" '.(($pro["emp_id_usu"]==$selected)? 'selected':'').' >'.$pro["emp_nombre"].' '.$pro["emp_apellido"].'</option>';
                $nombre_persona = ($pro["emp_id"] != null) ? $pro["emp_nombre"] . ' ' . $pro["emp_apellido"] : $pro["username"];
                $result = $result . '<option value="' . $pro["id"] . '" ' . (($pro["id"] == $selected) ? 'selected' : '') . ' >' . $nombre_persona . '</option>';
            }
        }
        if ($aplica_return) {
            return $result;
        }
        echo $result;
    }

    /**
     * @author Rafael A. Cuchilla
     * @since 2018-07-04
     * @return filtrar los clientes por proyecto
     */
    public function get_cliente_proyecto($proyecto = 0, $selected = null, $aplica_return = false)
    {
        $proyecto = ($this->input->post('proyecto')) ? $this->input->post('proyecto') : $proyecto;
        $where = array("cli_estado" => 1, "pry_id" => $proyecto);
        $cliente = $this->desarrollo_model->get_clientes_proyecto($where);
        //print_r($this->db->last_query()); die();
        $result = '<option value=""></option>';

        if (count($cliente) > 0) {
            foreach ($cliente as $cli) {
                if ($cli["cli_personeria"] == 1) {
                    $result = $result . '<option value="' . $cli["cli_id"] . '" ' . (($cli["cli_id"] == $selected) ? 'selected' : '') . ' >' . $cli["cli_codigo"] . ' ' . $cli["cli_nombre"] . ' ' . $cli["cli_apellido"] . '</option>';
                } else {
                    $result = $result . '<option value="' . $cli["cli_id"] . '" ' . (($cli["cli_id"] == $selected) ? 'selected' : '') . ' >' . $cli["cli_codigo"] . ' ' . $cli["cli_apellido"] . '</option>';
                }
            }
        }
        if ($aplica_return) {
            return $result;
        }
        echo $result;
    }

    public function guardar_prueba_scrum()
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($_POST) {
                // print_r('expression');
                // die(print_r($_POST));
                $inc_id = $_POST['prueba_id'];

                // Recorremos la grid con las pruebas sugeridas
                $this->gsatelite->borrado_general('pbg_prueba_sugerida', array('pbg_id_inc' => $inc_id));
                $id_exitos = 0;
                if ((is_array($_POST['pantalla'])) && (count($_POST['pantalla']) > 0)) {
                    $n_elements  = count($_POST['pantalla']);
                    for ($i = 0; $i < $n_elements; $i++) {
                        $pantalla  = $_POST['pantalla'][$i];
                        $flujo     = $_POST['flujo'][$i];
                        $resultado = $_POST['resultado'][$i];
                        $obtenido  = $_POST['obtenido'][$i];
                        $estadop   = ($_POST['estadop'][$i] != '') ? $_POST['estadop'][$i] : null;
                        $array_pruebas = array(
                            'pbg_id_inc'             => $inc_id,
                            'pbg_id_esb'             => $estadop,
                            'pbg_pantalla'           => $pantalla,
                            'pbg_flujo'              => $flujo,
                            'pbg_resultado_esperado' => $resultado,
                            'pbg_resultado_obtenido' => $obtenido,
                            'pbg_estado'             => 1,
                            'pbg_usu_creacion'       => $this->tank_auth->get_user_id(),
                            'pbg_usu_modificacion'   => $this->tank_auth->get_user_id(),
                            'pbg_fecha_creacion'     => date('Y-m-d H:i:s'),
                            'pbg_fecha_modificacion' => date('Y-m-d H:i:s')
                        );

                        $id_exitos = $this->gsatelite->ingresar('pbg_prueba_sugerida', $array_pruebas);
                    } //fin for
                } //fin if
                echo $id_exitos;
            } //fin if post
        }
    }

    public function duplicar_incidencia($pry_id = 0, $inc_id = null)
    {
        satelite_validar();
        if ($_POST) {
            $post_array = $this->input->post();
            $tipo_btn = $post_array['tipo_btn'];
            $iniciales = $post_array['inicial'];
            $correlativo = $this->db->select_max('inc_correlativo')->where('inc_id_pry', $post_array['proyecto'])->get('inc_incidencia')->result_array();
            $num = ((int) $correlativo[0]['inc_correlativo']) + 1;
            $codigo = $iniciales . '_' . $num;
            $incidencia_array = array(
                'inc_id_pry' => $post_array['proyecto'],
                'inc_id_tii' => $post_array['tipo'],
                'inc_id_cmp' => $post_array['componente'],
                'inc_id_usr_informante' => $post_array['informador'],
                'inc_id_usr_asignado' => $post_array['slc_responsable'],
                'inc_id_enr' => ($post_array['sprint'] != "") ? $post_array['sprint'] : null,
                'inc_codigo' => $codigo,
                'inc_nombre' => $post_array['nombre'],
                'inc_descripcion' => trim($post_array['descripcion']),
                'inc_importancia' => $post_array['importancia'],
                'inc_estimacion' => $post_array['estimacion'],
                'inc_fecha_ingreso' => date('Y-m-d H:i:s'),
                'inc_fecha_asignacion' => date('Y-m-d H:i:s'),
                'inc_url' => ($post_array['url'] != "") ? $post_array['url'] : "",
                'inc_fecha_entrega' => ($post_array['f_entrega'] != "") ? formatear_fecha('Y-m-d', $post_array['f_entrega']) : null,
                'inc_estado' => 1,
                'inc_usu_creacion' => $this->tank_auth->get_user_id(),
                'inc_usu_modificacion' => $this->tank_auth->get_user_id(),
                'inc_fecha_creacion' => date('Y-m-d H:i:s'),
                'inc_fecha_modificacion' => date('Y-m-d H:i:s'),
                'inc_correlativo' => $num,
                'inc_fuente' => trim($post_array['fuente'])
            );
            $id = $this->gsatelite->ingresar('inc_incidencia', $incidencia_array);
            if (is_array($post_array['pantalla']) && count($post_array['pantalla']) > 0) {
                $n_elements  = count($post_array['pantalla']);
                for ($i = 0; $i < $n_elements; $i++) {
                    $array_pruebas = array(
                        'pbg_id_inc' => $id,
                        'pbg_id_esb' => ($post_array['estadop'][$i] != "") ? $post_array['estadop'][$i] : null,
                        'pbg_pantalla' => $post_array['pantalla'][$i],
                        'pbg_flujo' => $post_array['flujo'][$i],
                        'pbg_resultado_esperado' => $post_array['resultado'][$i],
                        'pbg_resultado_obtenido' => $post_array['obtenido'][$i],
                        'pbg_estado' => 1,
                        'pbg_usu_creacion' => $this->tank_auth->get_user_id(),
                        'pbg_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'pbg_fecha_creacion' => date('Y-m-d H:i:s'),
                        'pbg_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->ingresar('pbg_prueba_sugerida', $array_pruebas);
                }
            }
            if ($id > 0) {
                $array_insert = array();
                $inc_clientes =  $post_array['cliente'];
                $n_clientes = count($inc_clientes);
                for ($i = 0; $i < $n_clientes; $i++) {
                    if ($inc_clientes[$i] > 0) {
                        $array_insert[] = array(
                            'inl_id_cli' => $inc_clientes[$i],
                            'inl_id_inc' => $id,
                            'inl_estado' => 1,
                            'inl_usu_creacion' => $this->tank_auth->get_user_id(),
                            'inl_fecha_creacion' => date('Y-m-d H:i:s'),
                            'inl_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'inl_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                    }
                }
                if (count($array_insert) > 0) {
                    $id_inl = $this->gsatelite->ingresar('inl_incidencia_cliente', $array_insert, true); //insert batch
                }
            }
            $etapa = $this->db->select()->from('etr_etapa_entregable')->order_by('etr_orden', 'ASC')->limit(1)->get()->result_array();
            $seguimiento_array = array(
                'sgi_id_inc' => $id,
                'sgi_id_etr' => $etapa[0]['etr_id'],
                'sgi_fecha' => date('Y-m-d H:i:s'),
                'sgi_estado' => 1,
                'sgi_usu_creacion' => $this->tank_auth->get_user_id(),
                'sgi_usu_modificacion' => $this->tank_auth->get_user_id(),
                'sgi_fecha_creacion' => date('Y-m-d H:i:s'),
                'sgi_fecha_modificacion' => date('Y-m-d H:i:s'),
            );
            $id_seg = $this->gsatelite->ingresar('sgi_seguimiento_inc', $seguimiento_array);
            $this->desarrollo_model->actualizar_etapa_inc($id_seg);
            // Guardar los Anexos
            $rutas = $post_array["ruta"];
            $carpeta = $post_array["nombreCarpeta"];
            $desc = $post_array["descripcion"];
            if (count($rutas) > 0) {
                $carpeta = $carpeta;
                for ($i = 0; $i < count($rutas); $i++) {
                    if ($rutas[$i] != "") {
                        $img = $rutas[$i];
                        $titulo = $post_array["titulo_doc" . $i];
                        $this->datos_imagen_gral($img, $carpeta, $titulo, $id, $desc);
                    }
                }
            }
            if ($id > 0) {
                $codigo_incidencia = $this->gsatelite->get_campo("inc_incidencia", "inc_codigo", array("inc_id" => $id));
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Incidencia " . $codigo_incidencia . " creada", 'texto_alerta' => "La operación a sido realizada con exito");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "La operación no pudo completarse");
            }
            $this->session->set_flashdata($alerta);
            if ($tipo_btn == 1) {
                redirect('desarrollo/procesos/agregar_incidencia/' . $pry_id);
            } else {
                redirect('desarrollo/procesos/incidencias');
            }
        } else {
            $inl_cli = null;
            $estadosx = array();
            $userid = $this->tank_auth->get_user_id();
            $id = $this->gsatelite->get_campo('esb_estado_prueba', "esb_id", array('esb_defecto' => 1));
            $estados_prueba = $this->gsatelite->get_dropdown('esb_estado_prueba', "esb_nombre", '', array('esb_estado' => 1), $id, '', 'esb_id', true);
            $incidencia_cliente = $this->gsatelite->get_tabla('inl_incidencia_cliente', array('inl_id_inc' => $inc_id));
            $pruebas = $this->desarrollo_model->get_pruebas_sugeridas(array('pbg_estado' => 1, 'pbg_id_inc' => $inc_id));
            foreach ($incidencia_cliente as $fila_reg) {
                $inl_cli[] = $fila_reg['inl_id_cli'];
            }
            $clientes = $this->gsatelite->get_dropdown('cli_cliente', "[IF(cli_personeria=1,CONCAT_WS(' ',cli_codigo,cli_nombre,cli_apellido),CONCAT_WS(' ',cli_codigo,cli_apellido))]", '', array('cli_estado' => '1'), $inl_cli, '', 'cli_id', true);
            foreach ($pruebas as $key => $valor) {
                $select = $this->gsatelite->get_dropdown('esb_estado_prueba', "esb_nombre", '', array('esb_estado' => 1), $valor['esb_id'], '', 'esb_id', true);
                $select_limp = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $select);
                $estadosx[] = array('data' => $valor, "selector" => $select_limp);
            }
            $data['pry_id'] = $pry_id;
            $data['informador'] = $this->desarrollo_model->get_usuarios_completos(array('id' => $userid));
            $data['estados_prueba'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $estados_prueba);
            $data['proyectos'] = $this->desarrollo_model->get_proyectos(array('uxp_id_usu' => $this->tank_auth->get_user_id(), 'pry_estado' => 1));
            $data['tipos'] = $this->gsatelite->get_tabla('tii_tipo_incidencia', array('tii_estado' => 1));
            $data['etapas'] = $this->gsatelite->get_tabla('etr_etapa_entregable', array('etr_estado' => 1));
            $data['clientes'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $clientes);
            $data['anexos'] = $this->desarrollo_model->get_anexos($inc_id);
            $data['incidencia'] = $this->gsatelite->get_tabla('inc_incidencia', array('inc_id' => $inc_id));
            $data['slc_responsable'] = $this->get_responsable_proyecto($data['incidencia'][0]['inc_id_pry'], $data['incidencia'][0]['inc_id_usr_asignado'], true);
            $data['infox']  =  $estadosx;
            $data['titulo_personal'] = 'Duplicar Incidencias';
            $this->_cargarvista($data);
        }
    }


    /**
     * @since 2023-04-11
     * @return Cierra los sprints de cada proyecto y abre uno nuevo, de manera masiva
     */
    public function sprints_masivos()
    {
        satelite_validar();
        if ($_POST) {
            // var_dump($_POST);die();
            $fecha_cierre_actual = $this->input->post('fecha_cierre_antiguo');
            $fecha_abrir_nuevo = $this->input->post('fecha_inicia_nuevo');
            $proyectos = $this->input->post('id_pry');
            $procesar = $this->input->post('procesar');
            if (count($proyectos) > 0) {
                $s = 0;
                // CERRAR EL ANTIGUO Y CREAR EL NUEVO
                foreach ($proyectos as $k => $pry) {
                    $sprint = $this->desarrollo_model->get_ultimos_sprints_activos(array('pry_id' => $pry));
                    $sprint_array = array(
                        'enr_fecha_fin' => formatear_fecha("Y-m-d", $fecha_cierre_actual),
                        'enr_activo' => 0,
                        'enr_estado' => 0,
                        'enr_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'enr_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $id = $this->gsatelite->actualizar_array('enr_entregable', $sprint_array, array('enr_id' => $sprint[0]['id_cierra_sprint']));
                    $ultimo = $this->desarrollo_model->correlativo($pry);
                    $correlativo_val = ($ultimo[0]['ultimo'] < 99) ? str_pad((int)(($ultimo[0]['ultimo'] + 1)), 3, "0", STR_PAD_LEFT) : (int)(($ultimo[0]['ultimo'] + 1));
                    $generacion_cod = "SP_" . $sprint[0]['pry_inicial'] . "_" . $correlativo_val;
                    $nuevo_sprint_array = array(
                        'enr_id_pry' => $pry,
                        'enr_nombre' => $generacion_cod,
                        'enr_codigo' => $generacion_cod,
                        'enr_fecha_inicio' => formatear_fecha("Y-m-d", $fecha_abrir_nuevo),
                        'enr_fecha_fin' => null,
                        'enr_activo' => 1,
                        'enr_correlativo' => intval($correlativo_val),
                        'enr_observacion' => "Generado de forma masiva",
                        'enr_estado' => 1,
                        'enr_usu_creacion' => $this->tank_auth->get_user_id(),
                        'enr_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'enr_fecha_creacion' => date('Y-m-d H:i:s'),
                        'enr_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $new_sprint = $this->gsatelite->ingresar('enr_entregable', $nuevo_sprint_array);
                    if ($new_sprint > 0) {
                        $etapa_mover = $this->gsatelite->get_tabla('etr_etapa_entregable', array('etr_estado' => 1, 'etr_finalizacion <>' => 1));
                        $whereinc = array('inc_estado' => 1, 'inc_id_pry' => $pry, 'inc_id_enr' => $sprint[0]['id_cierra_sprint']);
                        $etapas = (count($etapa_mover) > 0) ? implode(',', array_column($etapa_mover, 'etr_id')) : 0;
                        $havinginc = array("id_etapa_actual IN ($etapas)" => null);
                        $incidencias = $this->desarrollo_model->get_incidencias_mover($whereinc, $havinginc);
                        foreach ($incidencias as $key => $inc) {
                            $actualiza_inc = array(
                                'inc_id_enr' => $new_sprint,
                                'inc_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'inc_fecha_modificacion' => date('Y-m-d H:i:s')
                            );
                            $this->gsatelite->actualizar_array('inc_incidencia', $actualiza_inc, array('inc_id' => $inc['inc_id']));
                        }
                        $s++;
                    }
                }
                $this->gsatelite->show_dialog("Proceso realizado con éxito<br/>$s Sprints procesados", "desarrollo/procesos/entregables");
            } else {
                $this->gsatelite->show_dialog("Ocurrió un error en el proceso<br/>Verifique e inténtelo de nuevo", "desarrollo/procesos/sprints_masivos", "error");
            }
        } else {
            $data['permisos'] = $this->gsatelite->get_permisos_opcion();
            $data['titulo_personal'] = "Cierre masivo sprint";
            cargarvista($data);
        }
    }

    public function get_empleados_area($areaId = null, $return = false, $valorDefecto = null)
    {
        $area = ($areaId!=null) ? $areaId: $this->input->post('area');
        if ($area != '') {
            $empleados = $this->desarrollo_model->get_usuarios_completos(array('emp_id_are' => $area, 'emp_estado' => 1));
            $html = '';
            foreach ($empleados as $emp) {
                $selected = ($valorDefecto == $emp['id']) ? "selected=selected" : "";
                $html .= '<option ' . $selected . ' value="' . $emp['id'] . '">' . $emp['emp_nombre'] . ' ' . $emp['emp_apellido'] . '</option>';
            }

            if (!$return) {
                echo json_encode(array('html' => $html));
            } else {
                return $html;
            }
        }
    }

    function configuracion_ticket()
    {
        $crud = new grocery_crud();

        $columns = array(
            'cft_nombre',
            'cft_inicial',
            'cft_estado'
        );

        $display_as = array(
            'cft_nombre' => 'Nombre',
            'cft_inicial' => 'Prefijo',
            'cft_icono' => 'Icono',
            'cft_estado' => 'Estado'
        );

        $required = array(
            'cft_nombre',
            'cft_estado',
        );

        $crud->set_table('cft_configuracion_ticket')
            ->set_subject('Config. Ticket')
            ->columns($columns)
            ->display_as($display_as);
        $crud->add_action('Editar', '', 'desarrollo/procesos/editar_configuracion_ticket', 'icon16 icomoon-icon-pencil-5');
        // $crud->add_action('Tickets', '', 'desarrollo/procesos/tickets', 'mdi mdi-book-account-outline');

        //$crud->set_field_upload('pry_icono', $this);
        $crud->callback_column('cft_icono', function ($value, $row) {
            $img = '<a href="' . base_url($value) . '" class="image-thumbnail">';
            $img .= '<img src="' . base_url($value) . '" height="50px" style="width: 125px; height: 100px;"></a>';
            return ($value != '') ? $img : '';
        });

        $crud->unset_edit()
            ->unset_add()
            ->unset_export()
            ->unset_print();

        $url_array = explode('/', uri_string());
        $agregar = end($url_array);

        if ($agregar == 'add') {
            $crud->field_type('cft_estado', 'hidden', 1);
        } else {
            $crud->field_type('cft_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

        $output = $crud->render();
        $data['titulo_personal'] = 'Config. Tickets';
        $this->_cargarvista($data, $output);
    }

    function agregar_configuracion_ticket()
    {
        satelite_validar();
        if ($_POST) {
            //die(var_dump($_POST));
            $usuarios = $this->input->post('slcUsuario');
            $agentes = $this->input->post('slcAgente');
            $responsables = $this->input->post('slcResponsables');

            $proyecto = array(
                'cft_nombre' => $this->input->post('nombre'),
                'cft_descripcion' => $this->input->post('descripcion'),
                'cft_inicial' => $this->input->post('iniciales'),
                'cft_id_usu' => ($this->input->post('slcAgenteEncargado') > 0) ? $this->input->post('slcAgenteEncargado') : null,
                'cft_id_pry' => ($this->input->post('slcProyectoPadre') > 0) ? $this->input->post('slcProyectoPadre') : null,
                'cft_id_tii' => ($this->input->post('slcTipoIncidencia') > 0) ? $this->input->post('slcTipoIncidencia'): null,
                'cft_id_enr' => ($this->input->post('slcSprint') > 0) ? $this->input->post('slcSprint'): null,
                'cft_color_etiqueta' => ($this->input->post('txtColor')) ? $this->input->post('txtColor') : null,
                'cft_estado' => 1,
                'cft_usu_creacion' => $this->tank_auth->get_user_id(),
                'cft_usu_modificacion' => $this->tank_auth->get_user_id(),
                'cft_fecha_creacion' => date('Y-m-d H:i:s'),
                'cft_fecha_modificacion' => date('Y-m-d H:i:s')
            );

            $cft_id = $this->gsatelite->ingresar('cft_configuracion_ticket', $proyecto);

            if ($cft_id != 0) {
                //Se ingresan los usuarios por proyecto.
                //Se verifica que se selecciono al menos un usuario
                if (count($usuarios) > 0 && $usuarios != '') {
                    for ($i = 0; $i < count($usuarios); $i++) {
                        $uxp_array = array(
                            'uxo_id_cft' => $cft_id,
                            'uxo_id_usu' => $usuarios[$i],
                            'uxo_estado' => 1,
                            'uxo_usu_creacion' => $this->tank_auth->get_user_id(),
                            'uxo_fecha_creacion' => date('Y-m-d H:i:s'),
                            'uxo_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'uxo_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('uxo_usuarioxconfiguracion', $uxp_array);
                    }
                }

                $this->gsatelite->borrado_general('uxp_usuarioxproyecto', array('uxp_id_pry' => $this->input->post('slcProyectoPadre')));

                //Se ingresan los agentes por proyecto.
                //Se verifica que se selecciono al menos un agente
                if (count($agentes) > 0 && $agentes != '') {
                    for ($i = 0; $i < count($agentes); $i++) {

                        $uxp_array = array(
                            'uxp_id_pry' => $this->input->post('slcProyectoPadre'),
                            'uxp_id_usu' => $agentes[$i],
                            'uxp_estado' => 1,
                            'uxp_usu_creacion' => $this->tank_auth->get_user_id(),
                            'uxp_fecha_creacion' => date('Y-m-d H:i:s'),
                            'uxp_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'uxp_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('uxp_usuarioxproyecto', $uxp_array);
                    }
                }

                //Se ingresan los responsables por proyecto.
                //Se verifica que se selecciono al menos un responsable
                if (count($responsables) > 0 && $responsables != '') {
                    for ($i = 0; $i < count($responsables); $i++) {
                        $ret_array = array(
                            'ret_id_cft' => $cft_id,
                            'ret_id_usu' => $responsables[$i],
                            'ret_estado' => 1,
                            'ret_usu_creacion' => $this->tank_auth->get_user_id(),
                            'ret_fecha_creacion' => date('Y-m-d H:i:s'),
                            'ret_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'ret_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('ret_responsable_confg_ticket_helpdesk', $ret_array);
                    }
                }                                

                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Ingreso de configuracion Ticket", 'texto_alerta' => "Ingreso efectuado correctamente");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Ingreso de configuracion Ticket", 'texto_alerta' => "Ingreso no efectuado, favor verificar información");
            }

            $this->session->set_flashdata($alerta);
            $redir = $this->input->post("boton");
            if ($redir == 1) {
                redirect('desarrollo/procesos/agregar_configuracion_ticket');
            } else {
                redirect('desarrollo/procesos/configuracion_ticket');
            }
        } else {
            $data['usuarios'] = $this->desarrollo_model->get_usuarios_empleados(array('activated' => 1 ));
            $data['encargados'] = $this->desarrollo_model->get_usuarios_completos(array('activated' => 1 ,'emp_estado'=>1));
            $data['areas'] = $this->gsatelite->get_tabla('are_area',array('are_estado' => 1));
            $data['proyectos'] = $this->gsatelite->get_tabla('pry_proyecto',array('pry_estado' => 1));
            $data['tipos_incidencias'] = $this->gsatelite->get_tabla('tii_tipo_incidencia', array('tii_estado' => 1));
            $data['sprints'] = $this->gsatelite->get_tabla('enr_entregable', array('enr_estado' => 1, 'enr_fecha_fin is null' => null));
            $data['titulo_personal'] = 'Agregar Configuración Ticket';
            $this->_cargarvista($data);
        }
    }

    function editar_configuracion_ticket($id_pry = null)
    {
        satelite_validar();
        if ($_POST) {
            //var_dump($_POST);die();

            $usuarios = $this->input->post('slcUsuario');
            $agentes = $this->input->post('slcAgente');
            $responsables = $this->input->post('slcResponsables');            
            $est = $this->input->post('estado');
            if ($est == 2) {
                $estado = 0;
            } else {
                $estado = 1;
            }
            $id_pry = $this->input->post('proyecto');
            $proyecto_edit = array(
                'cft_nombre' => $this->input->post('nombre'),
                'cft_descripcion' => $this->input->post('descripcion'),
                'cft_inicial' => $this->input->post('iniciales'),
                'cft_color_etiqueta' => ($this->input->post('txtColor')) ? $this->input->post('txtColor') : null,
                'cft_id_pry' => ($this->input->post('slcProyectoPadre') > 0) ? $this->input->post('slcProyectoPadre') : null,
                'cft_id_usu' => ($this->input->post('slcAgenteEncargado') > 0) ? $this->input->post('slcAgenteEncargado') : null,
                'cft_id_tii' => ($this->input->post('slcTipoIncidencia') > 0) ? $this->input->post('slcTipoIncidencia'): null,
                'cft_id_enr' => ($this->input->post('slcSprint') > 0) ? $this->input->post('slcSprint'): null,
                'cft_estado' => $estado,
                'cft_usu_modificacion' => $this->tank_auth->get_user_id(),
                'cft_fecha_modificacion' => date('Y-m-d H:i:s')
            );

            $registro = $this->gsatelite->actualizar_array('cft_configuracion_ticket', $proyecto_edit, array('cft_id' => $id_pry));

            if ($registro != 0) {
                //Se ingresan los usuarios por proyecto.
                //Se eliminan los usuarios ya asociados al proyecto
                $this->gsatelite->borrado_general('uxo_usuarioxconfiguracion', array('uxo_id_cft' => $id_pry));

                //Se verifica que se selecciono al menos un usuario
                if (count($usuarios) > 0 && $usuarios != '') {
                    for ($i = 0; $i < count($usuarios); $i++) {
                        $uxp_array = array(
                            'uxo_id_cft' => $id_pry,
                            'uxo_id_usu' => $usuarios[$i],
                            'uxo_estado' => 1,
                            'uxo_usu_creacion' => $this->tank_auth->get_user_id(),
                            'uxo_fecha_creacion' => date('Y-m-d H:i:s'),
                            'uxo_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'uxo_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('uxo_usuarioxconfiguracion', $uxp_array);
                    }
                }

                //Se ingresan los agentes por proyecto.
                //Se eliminan los agentes ya asociados al proyecto
                $this->gsatelite->borrado_general('uxp_usuarioxproyecto', array('uxp_id_pry' => $this->input->post('slcProyectoPadre')));

                //Se ingresan los agentes por proyecto.
                //Se verifica que se selecciono al menos un agente
                if (count($agentes) > 0 && $agentes != '') {
                    for ($i = 0; $i < count($agentes); $i++) {
                        $uxp_array = array(
                            'uxp_id_pry' => $this->input->post('slcProyectoPadre'),
                            'uxp_id_usu' => $agentes[$i],
                            'uxp_estado' => 1,
                            'uxp_usu_creacion' => $this->tank_auth->get_user_id(),
                            'uxp_fecha_creacion' => date('Y-m-d H:i:s'),
                            'uxp_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'uxp_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('uxp_usuarioxproyecto', $uxp_array);
                    }
                }

                //Se ingresan los responsables por proyecto.
                //Se eliminan los responsables ya asociados al proyecto
                $this->gsatelite->borrado_general('ret_responsable_confg_ticket_helpdesk', array('ret_id_cft' => $id_pry));

                //Se verifica que se selecciono al menos un responsable
                if (count($responsables) > 0 && $responsables != '') {
                    for ($i = 0; $i < count($responsables); $i++) {
                        $ret_array = array(
                            'ret_id_cft' => $id_pry,
                            'ret_id_usu' => $responsables[$i],
                            'ret_estado' => 1,
                            'ret_usu_creacion' => $this->tank_auth->get_user_id(),
                            'ret_fecha_creacion' => date('Y-m-d H:i:s'),
                            'ret_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'ret_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('ret_responsable_confg_ticket_helpdesk', $ret_array);
                    }
                }                 

                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Actualización de configuracion Ticket", 'texto_alerta' => "Ingreso efectuado correctamente");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Actualización de configuracion Ticket", 'texto_alerta' => "Ingreso no efectuado, favor verificar información");
            }

            $this->session->set_flashdata($alerta);
            $redir = $this->input->post("boton");
            if ($redir == 1) {
                redirect('desarrollo/procesos/editar_configuracion_ticket/' . $id_pry);
            } else {
                redirect('desarrollo/procesos/configuracion_ticket');
            }
        } else {
            $data['info'] = $this->gsatelite->get_tabla('cft_configuracion_ticket', array('cft_id' => $id_pry));
            
            $data['encargados'] = $this->desarrollo_model->get_usuarios_completos(array('activated' => 1));

                $this->db->join('users', 'id = uxp_id_usu');
                $this->db->join('emp_empleado', 'emp_id = usu_id_emp', 'left');
                $this->db->join('are_area', 'emp_id_are = are_id', 'left');
                $this->db->join('plz_plaza', 'emp_id_plz = plz_id', 'left');
                $this->db->join('suc_sucursal', 'emp_id_suc = suc_id', 'left');                
            $data['uxp_listado'] = $this->gsatelite->get_tabla('uxp_usuarioxproyecto', array('uxp_id_pry' => $data['info'][0]['cft_id_pry']));

            $data['usuarios'] = $this->desarrollo_model->get_usuarios_empleados(array('activated' => 1));
            $data['uxo_listado'] = $this->desarrollo_model->get_usuarios_configuracion(array('uxo_id_cft' => $id_pry));
            $data['ret_listado'] = $this->desarrollo_model->get_responsables_configuracion(array('ret_id_cft' => $id_pry));            

            if($data['info'][0]['cft_id_usu']!=null){
                $data['area_selected'] = $this->desarrollo_model->get_usuarios_completos(array('id' => $data['info'][0]['cft_id_usu']));
                $data['empleado_pm'] = $this->get_empleados_area($data['area_selected'][0]['emp_id_are'],true,$data['info'][0]['cft_id_usu'] );
            }

            $data['areas'] = $this->gsatelite->get_tabla('are_area',array('are_estado' => 1));
            $data['proyectos'] = $this->gsatelite->get_tabla('pry_proyecto',array('pry_estado' => 1));
            $data['tipos_incidencias'] = $this->gsatelite->get_tabla('tii_tipo_incidencia', array('tii_estado' => 1));
            $data['sprints'] = $this->gsatelite->get_tabla('enr_entregable', array('enr_estado' => 1, 'enr_id_pry' => $data['info'][0]['cft_id_pry'], 'enr_fecha_fin is null' => null));
            $data['titulo_personal'] = 'Editar Configuración Ticket';
            $this->_cargarvista($data);
        }
    }

    function ticket($pry_id = 0, $enr_id = 0)
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $this->session->set_userdata('url_return', base_url($_SERVER['REDIRECT_QUERY_STRING']));

            $estadosTicket = $this->gsatelite->get_tabla('esk_estado_ticket as estados_ticket', ['estados_ticket.esk_estado' => 1]);
            $estadosTicketEncuesta = array_values(array_filter($estadosTicket, function($estado){
                return $estado['esk_encuesta'] == 1;
            }));

            $estadosTicketFinalizacion = array_values(array_filter($estadosTicket, function($estado){
                return $estado['esk_finalizacion'] == 1;
            }));

            $flagEncuesta = (count($estadosTicketEncuesta) > 0) ? 1 : 0;

            $validarAccionEncuesta = "[tkh_id_usr_informante] == {$this->tank_auth->get_user_id()} and [tkh_id_usr_asignado] != null and [tkh_id_ecl] == null and [1] = {$flagEncuesta}";
            if (count($estadosTicketEncuesta) > 0) {
                $validarAccionEncuesta .=" and [tkh_id_esk] == {$estadosTicketEncuesta[0]['esk_id']}";
                // $etr_etapa_entregable = $this->gsatelite->get_tabla('etr_etapa_entregable', ['etr_id_esk' => $estadosTicketEncuesta[0]['esk_id']]);
            }

            $validarAccionCancelarEditar = "[tkh_id_usr_informante] == {$this->tank_auth->get_user_id()} and [tkh_id_usr_asignado] == null";

            if (count($estadosTicketFinalizacion) > 0) {
                $validarAccionCancelarEditar .=" and [tkh_id_esk] != {$estadosTicketFinalizacion[0]['esk_id']}";
            }

            $permisos = $this->gsatelite->get_permisos_opcion();
            $data['permisos'] = $permisos;
            $data['btnAgregar'] = 1;
            $crud   = new grocery_crud();
            $pry_id = null;
            $sprint = null;
            $estado = null;
            $etapa = null;
            $responsable = null;

                $this->db->join('emp_empleado', 'emp_id = usu_id_emp');
            $usuario = $this->gsatelite->get_tabla('users', ['id' => $this->tank_auth->get_user_id()]);
            $usuario = $usuario[0];

            if ($usuario['emp_id_are'] != null) {
                $this->db->join('users', 'users.id = tkh_id_usr_informante');
                $this->db->join('emp_empleado', 'emp_empleado.emp_id = users.usu_id_emp');
                $this->db->join('are_area', 'are_area.are_id = emp_empleado.emp_id_are');
                $this->db->where('are_id', $usuario['emp_id_are']);
            } else {
                $this->db->where('tkh_id_usr_informante', $this->tank_auth->get_user_id());
            }

            $where_filtro = "tkh_estado = 1"; //$this->tank_auth->get_user_id();
            if ($_POST) {
                $inc_id         = 0;
                $pry_id         = $this->input->post("proyecto");
                $sprint         = ($this->input->post("sprint") != "") ? $this->input->post("sprint") : NULL;
                $etapa          = ($this->input->post("slc_etapa") != "") ? $this->input->post("slc_etapa") : NULL;
                $estado          = ($this->input->post("slc_estado") != "") ? $this->input->post("slc_estado") : NULL;
                $responsable    = ($this->input->post("slc_responsable") != "") ? $this->input->post("slc_responsable") : NULL;
                $where_filtro = "tkh_id IN 
                        (SELECT ID_INC FROM ( 
                            SELECT SUB.tkh_id AS ID_INC
                             from tkh_ticket_helpdesk SUB
                             WHERE
                         ";

                $where["pry_id"] =  $pry_id;
                $aplica_and = false;

                if ($pry_id > 0) {
                    $where_filtro .= " SUB.tkh_id_pry = $pry_id";
                    $aplica_and = true;
                }

                if ($responsable > 0) {
                    $where_filtro .= (($aplica_and) ? " AND " : "") . " SUB.tkh_id_usr_asignado = $responsable ";
                }

                if ($estado != '' && $estado > -1) {
                    $where_filtro .= (($aplica_and) ? " AND " : "") . " SUB.tkh_estado = $estado ";
                }

                if ($etapa > 0) {
                    $ids_consulta = "";
                    foreach ($etapa as $key) {
                        $ids_consulta .= $key.",";
                    }

                    $ids_consulta = substr($ids_consulta , 0, -1);

                    $where_filtro .= (($aplica_and) ? " AND " : "") . " SUB.tkh_id_esk in($ids_consulta) ";
                }

                $where_filtro .= " GROUP BY SUB.tkh_id";

                $where_filtro .= ") q )";
                /*
                $inc_id_array   = $this->desarrollo_model->get_incidencias($where);
                if ( count($inc_id_array) >0 ){
                    foreach ( $inc_id_array as $incidencia ) {
                        $inc_id =  $inc_id.$incidencia['inc_id']. ',';
                    }
                    $inc_id = substr($inc_id, 0, -1);
                }
                */
            }

            // print_r($where_filtro); die();
            $crud->where($where_filtro);

            $columns = array(
                'tkh_codigo',
                'tkh_asunto',
                'tkh_id_cmp',
                'tkh_id_usr_asignado',
                // 'tkh_estado',
                'tkh_id_esk'
            );

            $display_as = array(
                'tkh_codigo' => 'Código',
                'tkh_asunto' => 'Asunto',
                'tkh_id_cmp' => 'Componente',
                'tkh_id_usr_asignado' => 'Responsable',
                // 'tkh_estado' => 'Estado',
                'tkh_id_esk' => 'Estado',
            );

            $required = array(
                'tkh_codigo',
                'tkh_nombre',
                'tkh_id_cmp',
                'tkh_id_usr_asignado',
            );

            $crud->set_table('tkh_ticket_helpdesk')
                ->set_subject('Tickets')
                ->set_relation('tkh_id_pry', 'pry_proyecto', '{pry_nombre}')
                ->set_relation('tkh_id_tii', 'tii_tipo_incidencia', '{tii_nombre}')
                ->set_relation('tkh_id_cmp', 'cmp_componente', '{cmp_nombre}')
                ->set_relation('tkh_id_esk', 'esk_estado_ticket', '{esk_nombre}')
                ->columns($columns)
                ->display_as($display_as)
                ->unset_jquery()
                ->unset_jquery_ui()
                ->callback_column('tkh_id_usr_asignado', array($this, '_callback_responsable_ticket_v2'))
                // ->field_type('tkh_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'))
            ;


            $crud->unset_add()->unset_edit();
            // $crud->unset_export()->unset_print();
            $crud->unset_read();
            $crud->unset_delete();

            $crud->add_action('Encuesta', '', 'desarrollo/procesos/encuesta_satisfaccion', 'icomoon-icon-bookmark', '', '', $validarAccionEncuesta);
            if ($pry_id != 0) {
                if ($permisos['permite_editar']) {
                    $crud->add_action('Editar', '', 'desarrollo/procesos/editar_ticket/' . $pry_id, 'icon16 icomoon-icon-pencil-5', '', '', $validarAccionCancelarEditar);
                    $crud->add_action('Comentarios', '', 'desarrollo/procesos/comentarios_ticket', 'icomoon-icon-comments', '', '', array('tkh_id_usr_informante' => $this->tank_auth->get_user_id()));                    
                }
                if ($permisos['permite_ver']) {
                    //$crud->add_action('&nbsp;Detalle', '', 'desarrollo/procesos/vista_detalle_ticket/' . $pry_id, 'icomoon-icon-search-3', '');
                }
                //$crud->add_action('&nbsp;Cancelar incidencia', '', 'desarrollo/procesos/cancelar_ticket/' . $pry_id, 'icomoon-icon-cancel cancela_inc', '', '', array('inc_estado' => 'Activo'));
            } else {
                if ($permisos['permite_editar']) {
                    $crud->add_action('Editar', '', 'desarrollo/procesos/editar_ticket/0', 'icon16 icomoon-icon-pencil-5', '', '', $validarAccionCancelarEditar);
                    $crud->add_action('Comentarios', '', 'desarrollo/procesos/comentarios_ticket', 'icomoon-icon-comments', '', '', array('tkh_id_usr_informante' => $this->tank_auth->get_user_id()));
                }
                if ($permisos['permite_ver']) {
                    //$crud->add_action('&nbsp;Detalle', '', 'desarrollo/procesos/vista_detalle_ticket', 'icomoon-icon-search-3', '');
                }
                //$crud->add_action('&nbsp;Cancelar incidencia', '', 'desarrollo/procesos/cancelar_ticket/0', 'icomoon-icon-cancel cancela_inc', '', '', array('inc_estado' => 'Activo'));
            }

            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            } else {
                $crud->add_action('Cancelar', '', 'desarrollo/procesos/cancelar_ticket', 'icomoon-icon-cancel cancelar_ticket', '', '', $validarAccionCancelarEditar);
            }

            //$crud->add_action('&nbsp;Comentarios', '', 'desarrollo/procesos/comentarios_ticket', 'icomoon-icon-comments-3', '');
            $output = $crud->render();

                $this->db->join('cft_configuracion_ticket', 'cft_id_pry = pry_id');
                $this->db->join('uxo_usuarioxconfiguracion', 'uxo_id_cft = cft_id');
                $this->db->group_by('pry_id');
            $data['proyectos'] = $this->gsatelite->get_tabla('pry_proyecto', array('uxo_id_usu' => $this->tank_auth->get_user_id(), 'pry_estado' => 1));            

            $data['etapas'] = $this->gsatelite->get_dropdown('esk_estado_ticket', "esk_nombre", '', array('esk_estado' => '1'), $etapa, '', 'esk_id', true);

            $data['slc_responsable'] = $this->get_responsable_proyecto($pry_id, $responsable, true);

            $data['titulo_personal']    = 'Tickets';

            $data['pry_id']             = $pry_id;

            $data['estado']             = $estado;

            $enr_id                     = ($sprint != NULL) ? $sprint : 0;
            $data['enr_id']             = $sprint;

            $this->_cargarvista($data, $output);
        }
    }

    function _callback_responsable_ticket($value, $row)
    {
        $resp = $this->desarrollo_model->get_usuarios_completos(array('id' => $row->tkh_id_usr_asignado));
        $nombre = (count($resp) > 0) ? ($resp[0]['emp_nombre']!='') ? $resp[0]['emp_nombre'] . ' ' . $resp[0]['emp_apellido'] : $resp[0]['username'] : '';
        return $nombre;
    }


    function _callback_responsable_ticket_v2($value, $row)
    {
        $resp = $this->desarrollo_model->get_usuarios_completos_v2(array('inc_id_tkh' => $row->tkh_id));
        $nombre = (count($resp) > 0) ? ($resp[0]['emp_nombre']!='') ? $resp[0]['emp_nombre'] . ' ' . $resp[0]['emp_apellido'] : $resp[0]['username'] : '';
        return $nombre;
    }

    function agregar_ticket($pry_id = 0)
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($_POST) {
                //die(var_dump($_POST));
                
                $tipo_btn = $this->input->post('tipo_btn');
                $iniciales = $this->input->post('inicial');
                $correlativo = $this->db->select_max('tkh_correlativo')->where('tkh_id_pry', $this->input->post('proyecto'))->get('tkh_ticket_helpdesk')->result_array();
                $num = ((int)$correlativo[0]['tkh_correlativo']) + 1;
                $codigo = $iniciales . '_' . $num;
                $incidencia_array = array(
                    'tkh_id_pry' => $this->input->post('proyecto'),
                    'tkh_id_tii' => $this->input->post('tipo'),
                    'tkh_id_tpp' => $this->input->post('prioridad'),
                    'tkh_id_cmp' => $this->input->post('componente'),
                    'tkh_id_usr_informante' => $this->input->post('informador'),
                    'tkh_codigo' => $codigo,
                    'tkh_asunto' => $this->input->post('nombre'),
                    'tkh_descripcion' => $this->input->post('descripcion'),
                    'tkh_fecha_ingreso' => date('Y-m-d H:i:s'),
                    'tkh_estado' => 1,
                    'tkh_usu_creacion' => $this->tank_auth->get_user_id(),
                    'tkh_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'tkh_fecha_creacion' => date('Y-m-d H:i:s'),
                    'tkh_fecha_modificacion' => date('Y-m-d H:i:s'),
                    'tkh_correlativo' => $num,
                );
                $id = $this->gsatelite->ingresar('tkh_ticket_helpdesk', $incidencia_array);

                $etapa = $this->db->select()->from('esk_estado_ticket')->order_by('esk_orden', 'ASC')->limit(1)->get()->result_array();
                $seguimiento_array = array(
                    'sgk_id_tkh' => $id,
                    'sgk_id_esk' => $etapa[0]['esk_id'],
                    'sgk_fecha' => date('Y-m-d H:i:s'),
                    'sgk_estado' => 1,
                    'sgk_usu_creacion' => $this->tank_auth->get_user_id(),
                    'sgk_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'sgk_fecha_creacion' => date('Y-m-d H:i:s'),
                    'sgk_fecha_modificacion' => date('Y-m-d H:i:s'),
                );

                $id_seg = $this->gsatelite->ingresar('sgk_seguimiento_ticket', $seguimiento_array);
                $this->desarrollo_model->actualizar_etapa_ticket($id_seg);

                // Guardar los Anexos
                $rutas = ($this->input->post("ruta")) ? $this->input->post("ruta"): array();
                $carpeta = $this->input->post("nombreCarpeta");
                $desc = $this->input->post("descripcion");
                if (count($rutas) > 0) {
                    $carpeta = $carpeta;
                    for ($i = 0; $i < count($rutas); $i++) {
                        if ($rutas[$i] != "") {
                            $img = $rutas[$i];
                            $titulo = $this->input->post("titulo_doc" . $i);
                            $this->datos_imagen_ticket($img, $carpeta, $titulo, $id, $desc);
                        }
                    }
                } // End guardar anexos
                if ($id > 0) {
                    $codigo_ticket = $this->gsatelite->get_campo("tkh_ticket_helpdesk", "tkh_codigo", array("tkh_id" => $id));
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Ticket " . $codigo_ticket . " creada", 'texto_alerta' => "La operación a sido realizada con exito");
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "La operación no pudo completarse");
                }
                $this->session->set_flashdata($alerta);

                if ($tipo_btn == 1) {
                    redirect('desarrollo/procesos/agregar_ticket');
                } else {
                    redirect('desarrollo/procesos/ticket/'.$pry_id);
                }
            }

            $data['pry_id'] = $pry_id;

            //$data['proyectos'] = $this->desarrollo_model->get_proyectos(array('uxp_id_usu' => $this->tank_auth->get_user_id(), 'pry_estado' => 1));
            
                $this->db->join('cft_configuracion_ticket', 'cft_id_pry = pry_id');
                $this->db->join('uxo_usuarioxconfiguracion', 'uxo_id_cft = cft_id');
                $this->db->group_by('pry_id');
            $data['proyectos'] = $this->gsatelite->get_tabla('pry_proyecto', array('uxo_id_usu' => $this->tank_auth->get_user_id(), 'pry_estado' => 1));

            $userid = $this->tank_auth->get_user_id();
            $data['informador'] = $this->desarrollo_model->get_usuarios_completos(array('id' => $userid));

            $data['tipos'] = $this->gsatelite->get_tabla('tii_tipo_incidencia', array('tii_estado' => 1));
            $data['prioridad'] = $this->gsatelite->get_tabla('tpp_tipo_prioridad', array('tpp_estado' => 1));

            $data['titulo_personal'] = 'Agregar Ticket';
            $this->_cargarvista($data);
        }
    }

    public function datos_imagen_ticket($img, $carpeta, $titulo_doc, $id, $desc)
    {
        $extencion = end(explode(".", $img));
        $unico = time();
        $nombre = trim($img);
        $ruta = "public/temp/" . $carpeta . "/" . $nombre;

        $carpeta_destino = "uploads/anx_ticket_helpdesk/" . $unico . '_' . $titulo_doc . "." . trim($extencion) . "";

        $dir = $this->gsatelite->get_campo('axh_anexo_ticket_heldesk', 'axh_url', array('axh_url' => $carpeta_destino, 'axh_estado' => 1));
        //die(print_r(count($dir)));
        if (count($dir) <= 0) {
            $array_anex = array(
                'axh_id_tkh' => $id,
                'axh_nombre' => $titulo_doc,
                'axh_url' => $carpeta_destino,
                'axh_estado' => 1,
                'axh_fecha_modificacion' => date('Y-m-d H:i:s'),
                'axh_fecha_creacion' => date('Y-m-d H:i:s'),
                'axh_usu_modificacion' => $this->tank_auth->get_user_id(),
                'axh_usu_creacion' => $this->tank_auth->get_user_id()
            );

            $this->db->insert("axh_anexo_ticket_heldesk", $array_anex);

            if (!copy($ruta, $carpeta_destino)) {
                //die(print_r("No se copio el archivo"));
            }
            unlink($ruta);
        }
    }

    // se accede desde ticket y gestion ticket
    function editar_ticket($pry_id = 0, $inc_id = null, $ver = 0)
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($_POST) {
                //die(var_dump($_POST));
                $tipo_btn = $this->input->post('tipo_btn');
                $iniciales = $this->input->post('inicial');
                $correlativo = $this->input->post('correlativo');
                $codigo = $iniciales . '_' . $correlativo;
                $incidencia_array = array(
                    'tkh_id_pry' => $this->input->post('proyecto'),
                    'tkh_id_tii' => $this->input->post('tipo'),
                    'tkh_id_tpp' => $this->input->post('prioridad'),
                    'tkh_id_cmp' => $this->input->post('componente'),
                    'tkh_id_usr_informante' => $this->input->post('informador'),
                    'tkh_codigo' => $codigo,
                    'tkh_asunto' => $this->input->post('nombre'),
                    'tkh_descripcion' => $this->input->post('descripcion'),
                    'tkh_estado' => 1,
                    'tkh_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'tkh_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                $where = array('tkh_id' => $inc_id);
                $id = $this->gsatelite->actualizar_array('tkh_ticket_helpdesk', $incidencia_array, $where);

                // Guardar los Anexos
                $rutas = $this->input->post("ruta");
                $carpeta = $this->input->post("nombreCarpeta");
                $desc = $this->input->post("descripcion");
                if (count($rutas) > 0) {
                    $carpeta = $carpeta;
                    for ($i = 0; $i < count($rutas); $i++) {
                        if ($rutas[$i] != "") {
                            $img = $rutas[$i];
                            $titulo = $this->input->post("titulo_doc" . $i);
                            //die(print_r($img.'*'.$carpeta.'*'.$titulo.'*'.$inc_id.'*'.$desc));
                            $this->datos_imagen_ticket($img, $carpeta, $titulo, $inc_id, $desc);
                        }
                    }
                } // End guardar anexos
                if ($id > 0) {
                    $codigo_incidencia = $this->gsatelite->get_campo("tkh_ticket_helpdesk", "tkh_codigo", array("tkh_id" => $id));

                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Ticket " . $codigo_incidencia . " creada", 'texto_alerta' => "La operación a sido realizada con exito");

                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Ticket " . $codigo_incidencia . "  actualizada", 'texto_alerta' => "La operación a sido realizada con exito");
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "La operación no pudo completarse");
                }
                $this->session->set_flashdata($alerta);
                if ($tipo_btn == 1) {
                    redirect('desarrollo/procesos/editar_ticket/' . $pry_id . '/' . $inc_id);
                } else {
                    redirect('desarrollo/procesos/ticket/' . $pry_id);
                }
            }
            $data['pry_id'] = $pry_id;
            $data['inc_id'] = $inc_id;
            $data['ver'] = (int)$ver;
            
            $data['ticket'] = $this->gsatelite->get_tabla('tkh_ticket_helpdesk', array('tkh_id' => $inc_id));
            $data['proyectos'] = $this->gsatelite->get_tabla('pry_proyecto');

            $data['tipos'] = $this->gsatelite->get_tabla('tii_tipo_incidencia', array('tii_estado' => 1));
            $data['prioridad'] = $this->gsatelite->get_tabla('tpp_tipo_prioridad', array('tpp_estado' => 1));

            $data['anexos'] = $this->desarrollo_model->get_anexos_ticket($inc_id);
            $userid = $this->tank_auth->get_user_id();
            $data['informador'] = $this->desarrollo_model->get_usuarios_completos(array('id' => $data['ticket'][0]['tkh_id_usr_informante']));
            $data['titulo_personal'] = 'Editar Ticket';


            $referers = array('tareas_pendientes');
            $cumple_http_referer = false;
            
            foreach ($referers as $referer) {
                if (substr_count($_SERVER['HTTP_REFERER'], $referer)) {
                    $cumple_http_referer = true;
                    break;
                }
            }

            $iframe = $this->input->get('iframe');

            if ($cumple_http_referer || $iframe == 1) {

                $data['iframe'] = true;

                $this->gsatelite->cargar_vista_masterpage('desarrollo/procesos/editar_ticket', $data);
            } else {
                $this->_cargarvista($data);
            }
            
        }
    }


    public function send_mail_test_funcional() {
        // Carga la biblioteca de PHPMailer
        $this->load->library('phpmailer_lib');
        $mail = $this->phpmailer_lib->load();

        try {
            // Configuración del servidor SMTP
            $mail->isSMTP();
            $mail->Host = 'mail.gruposatelite.net';
            $mail->SMTPAuth = true;
            $mail->Username = 'facturacion.sat@gruposatelite.net';
            $mail->Password = 'Nuevo1010$';
            $mail->SMTPSecure = 'tls'; // o `ssl` según tu configuración
            $mail->Port = 587; // o 465 para `ssl`

            // Destinatario
            $mail->setFrom('facturacion.sat@gruposatelite.net', 'Tu Nombre');
            $mail->addAddress('jose.rodriguez@gruposatelite.net');

            // Contenido del correo
            $mail->isHTML(true);
            $mail->Subject = 'Asunto del Correo';
            $mail->Body    = 'Contenido del correo en <b>HTML</b>';

            // Enviar correo
            $mail->send();
            echo 'Correo enviado con éxito';
        } catch (Exception $e) {
            echo "Error al enviar el correo: {$mail->ErrorInfo}";
        }
    }



    public function enviarCorreoEncuestaTicket($idTicket) {
        $data = $this->generarInfoEncuesta($idTicket);
        if (!empty($data) && $data['emailUsuario']) {
            $html = $this->load->view('desarrollo/procesos/enviar_correo_encuesta_ticket', $data, true);
            $enviarCorreo = $this->gsatelite->envio_correo("notificaciones@gruposatelite.net", "Sistema HelpDesk", $data['emailUsuario'], "Encuesta satisfacción", $html, null, null, true);
        }
    }

    private function horasADecimal($hora) {

    // Validar formato con expresiones regulares: HH:MM:SS
        if (!preg_match('/^\d{1,2}:\d{1,2}:\d{1,2}$/', $hora)) {
            return '0.00';
        }

        $partes = explode(':', $hora);

        if (count($partes) !== 3) {
            return '0.00';
        }

        list($horas, $minutos, $segundos) = $partes;

    // Validar que todos sean numéricos
        if (!is_numeric($horas) || !is_numeric($minutos) || !is_numeric($segundos)) {
            return '0.00';
        }

        $horas = (int)$horas;
        $minutos = (int)$minutos;
        $segundos = (int)$segundos;

        $minutosDecimal = $minutos / 60;
        $segundosDecimal = $segundos / 3600;

        $totalDecimal = $horas + $minutosDecimal + $segundosDecimal;

        return number_format(round($totalDecimal, 2), 2, '.', '');
    }

    private function decimalAHoras($decimal) {

        $horas = floor($decimal);

        $minutosDecimales = ($decimal - $horas) * 60;
        $minutos = floor($minutosDecimales);

        $segundos = round(($minutosDecimales - $minutos) * 60);

        return sprintf('%02d:%02d:%02d', $horas, $minutos, $segundos);
    }

    private function generarInfoEncuesta($idTicket) {
                $this->db->join('inc_incidencia', 'inc_id_tkh = tkh_id');
                $this->db->join('tii_tipo_incidencia', 'inc_id_tii = tii_id');
        $ticket = $this->gsatelite->get_tabla('tkh_ticket_helpdesk', ['tkh_id' => $idTicket]);
        $infoEncuesta = [];

        if (count($ticket) > 0) {
            // consulta sucursal usuario creacion ticket
            $this->db->join('suc_sucursal', 'suc_id = usc_id_suc');
            $this->db->join('users', 'id = usc_id_usu');
            $sucursalesUsuario = $this->gsatelite->get_tabla('usc_usuario_sucursal', ['usc_id_usu' => $ticket[0]['tkh_usu_creacion']]); 
            if (count($sucursalesUsuario) > 0 && $ticket[0]['tii_id_enc']) {
                $sucursal = $sucursalesUsuario[0]['suc_id'];
                $idEncuesta = $ticket[0]['tii_id_enc'];
                $encuesta = $this->gsatelite->get_tabla('enc_encuesta', ['enc_id' => $idEncuesta]);
                $linkEncuesta = "encuesta/procesos/iniciarEncuesta/{$idEncuesta}/{$sucursal}/{$idTicket}";
                $infoEncuesta = [
                    'encuesta' => $encuesta[0],
                    'ticket' => $ticket[0],
                    'linkEncuesta' => $linkEncuesta,
                    'emailUsuario' => $sucursalesUsuario[0]['email'],
                ];
            }         
        }
        return $infoEncuesta;
    }   

    public function encuesta_satisfaccion($idTicket) {
        $data = $this->generarInfoEncuesta($idTicket);
        if (empty($data)) {
            $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Encuesta", 'texto_alerta' => "Encuesta no disponible");
            $this->session->set_flashdata($alerta);
            redirect('desarrollo/procesos/ticket');            
        } else {
            redirect($data['linkEncuesta']);            
        }
        die();
    }

    public function comentarios_ticket($tkh_id, $modal = 0, $tareas_pendientes = 0)
    {
        satelite_validar();
        if ($tkh_id == null)
            redirect('/');
        else {
            if ($this->input->post()) {
                $post = $this->input->post();
                //var_dump($post);die();

                $comentario_array = array(
                    'cmk_id_tkh' => $tkh_id,
                    'cmk_id_usu' => $this->tank_auth->get_user_id(),
                    'cmk_comentario' => $post['txtEditorComentario'],
                    'cmk_estado' => 1,
                    'cmk_usu_creacion' => $this->tank_auth->get_user_id(),
                    'cmk_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'cmk_fecha_creacion' => date('Y-m-d H:i:s'),
                    'cmk_fecha_modificacion' => date('Y-m-d H:i:s'),
                );

                $cmk_id = $this->gsatelite->ingresar('cmk_comentario_ticket', $comentario_array);

                if ($cmk_id > 0) {
                    $ticket_data['ticket'] = $this->desarrollo_model->get_tickets(array('tkh_id' => $tkh_id));
                    //Email Asignado
                    $userAsignado = $this->gsatelite->get_tabla('users', array('id' => $ticket_data['ticket'][0]['tkh_id_usr_asignado']));
                    $ticket_data['email'] = ($this->tank_auth->get_user_id() == $ticket_data['ticket'][0]['tkh_id_usr_informante']) ? $ticket_data['ticket'][0]['email'] : $userAsignado[0]['email'];

                    // $this->enviarCorreoComentario($tkh_id, $ticket_data);
                    $codigo_ticket = $this->gsatelite->get_campo("tkh_ticket_helpdesk", "tkh_codigo", array("tkh_id" => $id));
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Comentario - Ticket " . $codigo_ticket, 'texto_alerta' => "La operación a sido realizada con exito");
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "La operación no pudo completarse");
                }
                $this->session->set_flashdata($alerta);
                redirect('desarrollo/procesos/comentarios_ticket/' . $tkh_id.'/'.$modal.'/'.$tareas_pendientes);
            }

            $data['ticket'] = $this->desarrollo_model->get_tickets(array('tkh_id' => $tkh_id));
            $data['comentarios'] = $this->desarrollo_model->get_comentarios_ticket(array('cmk_id_tkh' => $tkh_id), 'cmk_fecha_creacion ASC');
            $data['tareas_pendientes'] = $tareas_pendientes;
            $data['titulo_personal'] = "Comentarios";
            $data['modal'] = $modal;
            if ($modal == 1)
                cargarvista_modal(null, $data);
            else
                cargarvista(null, $data);
        }
    }
    public function enviarCorreoComentario($ticket_id, $ticket_data = null) {
        $ticket_data['ticket'] = ($ticket_data !=null) ? $ticket_data : $this->desarrollo_model->get_tickets(array('tkh_id' => $ticket_id));
        $data['ticket'] = $ticket_data['ticket'][0];
        if (!empty($ticket_data)) {
            $data['emailUsuario'] = $ticket_data['email'];
            $html = $this->load->view('desarrollo/procesos/enviar_correo_comentario', $data, true);
            $enviarCorreo = $this->gsatelite->envio_correo("notificaciones@gruposatelite.net", "Sistema HelpDesk", $data['emailUsuario'], "Encuesta satisfacción", $html, null, null, true);
        }
    }

    public function cancelar_ticket() {
        $tkh_id = $this->input->post('tkh_id');
        $comentario = $this->input->post('comentario');
        $estadoTicketFinalizado = $this->gsatelite->get_tabla('esk_estado_ticket', ['esk_estado' => 1, 'esk_finalizacion' => 1]);

        $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Ticket", 'texto_alerta' => "La operación no pudo completarse");      

        $comentario_array = array(
            'cmk_id_tkh' => $tkh_id,
            'cmk_id_usu' => $this->tank_auth->get_user_id(),
            'cmk_comentario' => trim($comentario),
            'cmk_estado' => 1,
            'cmk_usu_creacion' => $this->tank_auth->get_user_id(),
            'cmk_usu_modificacion' => $this->tank_auth->get_user_id(),
            'cmk_fecha_creacion' => date('Y-m-d H:i:s'),
            'cmk_fecha_modificacion' => date('Y-m-d H:i:s'),
        );

        $cmk_id = $this->gsatelite->ingresar('cmk_comentario_ticket', $comentario_array);
        if (count($estadoTicketFinalizado) > 0 && $cmk_id > 0) {
            $seguimiento_inactivar_array = array(
                'sgk_estado' => 0,
                'sgk_fecha_modificacion' => date('Y-m-d H:i:s'),
                'sgk_usu_modificacion' => $this->tank_auth->get_user_id(),
            );
            $this->gsatelite->actualizar_array('sgk_seguimiento_ticket', $seguimiento_inactivar_array, array('sgk_id_tkh' => $tkh_id));

            $seguimiento_array = array(
                'sgk_id_tkh' => $tkh_id,
                'sgk_id_esk' => $estadoTicketFinalizado[0]['esk_id'],
                'sgk_fecha' => date('Y-m-d H:i:s'),
                'sgk_estado' => 1,
                'sgk_usu_creacion' => $this->tank_auth->get_user_id(),
                'sgk_usu_modificacion' => $this->tank_auth->get_user_id(),
                'sgk_fecha_creacion' => date('Y-m-d H:i:s'),
                'sgk_fecha_modificacion' => date('Y-m-d H:i:s'),
            );

            $id_seg = $this->gsatelite->ingresar('sgk_seguimiento_ticket', $seguimiento_array);
            $this->desarrollo_model->actualizar_etapa_ticket($id_seg);

            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Ticket", 'texto_alerta' => "La operación se ha realizado con éxito");
        }

        $this->session->set_flashdata($alerta);
        die();
    }

    function gestion_ticket()
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {

            $this->session->set_userdata('url_return', base_url($_SERVER['REDIRECT_QUERY_STRING']));

            $estadosTicket = $this->gsatelite->get_tabla('esk_estado_ticket as estados_ticket', ['estados_ticket.esk_estado' => 1]);

            $estadosTicketFinalizacion = array_values(array_filter($estadosTicket, function($estado){
                return $estado['esk_finalizacion'] == 1;
            }));

            $validarAccionCancelarEditar = "[tkh_id_usr_asignado] == null";

            if (count($estadosTicketFinalizacion) > 0) {
                $validarAccionCancelarEditar .=" and [tkh_id_esk] != {$estadosTicketFinalizacion[0]['esk_id']}";
            }

            $permisos = $this->gsatelite->get_permisos_opcion();
            $data['permisos'] = $permisos;
            $data['btnAgregar'] = 0;
            $crud   = new grocery_crud();
            $pry_id = null;
            $sprint = null;
            $estado = null;
            $etapa = null;
            $responsable = null;

            $where_filtro = "tkh_estado = 1"; //$this->tank_auth->get_user_id();
            if ($_POST) {
                $inc_id         = 0;
                $pry_id         = $this->input->post("proyecto");
                $sprint         = ($this->input->post("sprint") != "") ? $this->input->post("sprint") : NULL;
                $etapa          = ($this->input->post("slc_etapa") != "") ? $this->input->post("slc_etapa") : NULL;
                $estado          = ($this->input->post("slc_estado") != "") ? $this->input->post("slc_estado") : NULL;
                $responsable    = ($this->input->post("slc_responsable") != "") ? $this->input->post("slc_responsable") : NULL;
                $where_filtro = "tkh_id IN 
                        (SELECT ID_INC FROM ( 
                            SELECT SUB.tkh_id AS ID_INC
                             from tkh_ticket_helpdesk SUB
                             WHERE
                         ";

                $where["pry_id"] =  $pry_id;
                $aplica_and = false;

                if ($pry_id > 0) {
                    $where_filtro .= " SUB.tkh_id_pry = $pry_id";
                    $aplica_and = true;
                }

                if ($responsable > 0) {
                    $where_filtro .= (($aplica_and) ? " AND " : "") . " SUB.tkh_id_usr_asignado = $responsable ";
                }

                if ($estado != '' && $estado > -1) {
                    $where_filtro .= (($aplica_and) ? " AND " : "") . " SUB.tkh_estado = $estado ";
                }

                if ($etapa > 0) {
                    $ids_consulta = "";
                    foreach ($etapa as $key) {
                        $ids_consulta .= $key.",";
                    }

                    $ids_consulta = substr($ids_consulta , 0, -1);

                    $where_filtro .= (($aplica_and) ? " AND " : "") . " SUB.tkh_id_esk in($ids_consulta) ";
                }

                $where_filtro .= " GROUP BY SUB.tkh_id";

                $where_filtro .= ") q )";
            }

            $crud->where($where_filtro);

            $columns = array(
                'tkh_codigo',
                'tkh_asunto',
                'tkh_id_cmp',
                'tkh_id_usr_asignado',
                'tkh_id_esk'
            );

            $display_as = array(
                'tkh_codigo' => 'Código',
                'tkh_asunto' => 'Asunto',
                'tkh_id_cmp' => 'Componente',
                'tkh_id_usr_asignado' => 'Responsable',
                'tkh_id_esk' => 'Estado',
            );

            $required = array(
                'tkh_codigo',
                'tkh_nombre',
                'tkh_id_cmp',
                'tkh_id_usr_asignado',
            );

            $crud->set_table('tkh_ticket_helpdesk')
                ->set_subject('Tickets')
                ->set_relation('tkh_id_pry', 'pry_proyecto', '{pry_nombre}')
                ->set_relation('tkh_id_tii', 'tii_tipo_incidencia', '{tii_nombre}')
                ->set_relation('tkh_id_cmp', 'cmp_componente', '{cmp_nombre}')
                ->set_relation('tkh_id_esk', 'esk_estado_ticket', '{esk_nombre}')
                ->columns($columns)
                ->display_as($display_as)
                ->unset_jquery()
                ->unset_jquery_ui()
                ->callback_column('tkh_id_usr_asignado', array($this, '_callback_responsable_ticket_v2'))
            ;

            $crud->unset_add()->unset_edit();
            $crud->unset_read();
            $crud->unset_delete();

            if ($pry_id != 0) {
                if ($permisos['permite_editar']) {
                    $crud->add_action('Editar', '', 'desarrollo/procesos/editar_ticket/' . $pry_id, 'icon16 icomoon-icon-pencil-5', '', '', $validarAccionCancelarEditar);
                    $crud->add_action('Comentarios', '', 'desarrollo/procesos/comentarios_ticket', 'icomoon-icon-comments', '', '', '');                    
                }
                if ($permisos['permite_ver']) {
                    $crud->add_action('Detalle', '', '', 'icon16 minia-icon-search', function($primary_key, $row) use ($pry_id){
                        return $this->_callback_ver_ticket($primary_key, $row, $pry_id);
                    });
                }
            } else {
                if ($permisos['permite_editar']) {
                    $crud->add_action('Editar', '', 'desarrollo/procesos/editar_ticket/0', 'icon16 icomoon-icon-pencil-5', '', '', $validarAccionCancelarEditar);
                    $crud->add_action('Comentarios', '', 'desarrollo/procesos/comentarios_ticket', 'icomoon-icon-comments', '', '', '');
                }
                if ($permisos['permite_ver']) {
                    $crud->add_action('Detalle', '', '', 'icon16 minia-icon-search', array($this, '_callback_ver_ticket'), '', '');
                }
            }

            $output = $crud->render();

            $data['proyectos'] = $this->gsatelite->get_tabla('pry_proyecto', array('pry_estado' => 1));

            $data['etapas'] = $this->gsatelite->get_dropdown('esk_estado_ticket', "esk_nombre", '', array('esk_estado' => '1'), $etapa, '', 'esk_id', true);

            $data['slc_responsable'] = $this->get_responsable_proyecto($pry_id, $responsable, true);

            $data['titulo_personal']    = 'Tickets';

            $data['pry_id']             = $pry_id;

            $data['estado']             = $estado;

            $enr_id                     = ($sprint != NULL) ? $sprint : 0;
            $data['enr_id']             = $sprint;

            cargarvista($data, $output, 'desarrollo/procesos/ticket');
            // $this->_cargarvista($data, $output);
        }

    }    

    public function _callback_ver_ticket($primary_key , $row, $proyecto = 0)
    {
        return site_url("desarrollo/procesos/editar_ticket/{$proyecto}/{$primary_key}/1");
    } 

    // Obtener usuarios agentes y sprint de proyectos
    public function get_tabla_usuarios_agentes($pry = 0) {

        $proyecto = ($this->input->post('pry') > 0) ? $this->input->post('pry'): $pry;

            $this->db->join("uxp_usuarioxproyecto", "uxp_id_usu = id");
            $this->db->join("emp_empleado", "usu_id_emp = emp_id", "left");
            $this->db->join('are_area', 'emp_id_are = are_id', 'left');
            $this->db->join('plz_plaza', 'emp_id_plz = plz_id', 'left');
            $this->db->join('suc_sucursal', 'emp_id_suc = suc_id', 'left');
        $usuarios = $this->gsatelite->get_tabla("users", array("uxp_estado" => 1, "uxp_id_pry" => $proyecto, 'activated' => 1));
    
        $result = array();
    
        if (count($usuarios) > 0) {
            foreach ($usuarios as $usu) {
                $nombre_persona = ($usu["emp_id"] != null) ? $usu["emp_nombre"] . ' ' . $usu["emp_apellido"] : $usu["username"];
                $result[] = array(
                    'id' => $usu["id"],
                    'nombre' => $nombre_persona,
                    'cargo' => ($usu['plz_nombre'] != null) ? $usu['plz_nombre']: '',
                    'correo' => ($usu['emp_email'] != null) ? $usu['emp_email']: ''
                );
            }
        }

        $sprints = $this->getSprintxProyecto($proyecto);
        
        $data = [
            'result' => $result,
            'sprints' => $sprints,
        ];
    
        echo json_encode($data);
    }

    private function getSprintxProyecto($pry_id){
        $sprints = $this->gsatelite->get_dropdown('enr_entregable', '{enr_codigo}','',array('enr_estado' => 1, 'enr_id_pry' => $pry_id, 'enr_fecha_fin is null' => null), null, '', 'enr_id', true);
        $select = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $sprints);        
        return $select;
    } 

    function obtener_tipo_prioridad($proyecto = null, $select = null, $json = null)
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {

            if ($_POST) {
                $proyecto = $this->input->post('proyecto');
                $select = $this->input->post('select');
                $json = $this->input->post('json');
            }

            if ($select == 2) {
                    $this->db->join('tii_tipo_incidencia', 'tii_id = cft_id_tii');
                $cft_tipo_prioridad = $this->gsatelite->get_tabla('cft_configuracion_ticket', array('cft_id_pry' => $proyecto));
                $options = '<option value="0">Seleccione</option>';

                if(count($cft_tipo_prioridad) > 0) {
                    foreach ($cft_tipo_prioridad as $cft_tpp) {
                    
                        $options .= '<option value="' . $cft_tpp['tii_id'] . '" selected>' . $cft_tpp['tii_nombre'] . '</option>';
                        
                    }
                }
                echo $options;
            } 
        }
    }

    public function guardar_gral_ticket($parametros, $carpeta = null, $mimes = null)
    {
        $datos = @explode($parametros);
        $carpeta = $parametros;
        //var_dump($mimes);
        if ($mimes != null) {
            $mimes = str_replace('-', '|', $mimes);
            $image = $this->upload_gral($carpeta, $mimes);
        } else {
            $image = $this->upload_gral($carpeta);
        }
        //$this->session->keep_flashdata('datos_1');
        //echo $image['upload_data']['raw_name'] . $image['upload_data']['file_ext'];
        echo json_encode($image['upload_data']);
    } 

    public function get_dropdown_usuarios_agentes($pry = 0, $selected = null, $aplica_return = false)
    {
            $this->db->join("uxp_usuarioxproyecto", "uxp_id_usu = id");
            $this->db->join("emp_empleado", "usu_id_emp = emp_id", "left");
            $this->db->join('are_area', 'emp_id_are = are_id', 'left');
            $this->db->join('plz_plaza', 'emp_id_plz = plz_id', 'left');
            $this->db->join('suc_sucursal', 'emp_id_suc = suc_id', 'left');
        $usuarios = $this->gsatelite->get_tabla("users", array("uxp_estado" => 1, "uxp_id_pry" => $pry, 'activated' => 1));
        $result = '<option value=""></option>';

        if (count($usuarios) > 0) {
            foreach ($usuarios as $usu) {
                $nombre_persona = ($usu["emp_id"] != null) ? $usu["emp_nombre"] . ' ' . $usu["emp_apellido"] : $usu["username"];
                $result = $result . '<option value="' . $usu["id"] . '" data-cargo="' . $usu['plz_nombre'] . '" data-correo="' . $usu['emp_email'] . '" ' . (($usu["id"] == $selected) ? 'selected' : '') . ' >' . $nombre_persona . '</option>';
            }
        }
        if ($aplica_return) {
            return $result;
        }
        echo $result;
    }

    public function obtener_componentes_hijo(){
        $id_componente_padre = $this->input->post('componente_padre');
        $componentes = $this->gsatelite->get_tabla('cmp_componente', array('cmp_estado' => 1, 'cmp_id_padre' => $id_componente_padre));
        $options = '<option value="0">Seleccione</option>';
        foreach ($componentes as $com) {
            if ($com['cmp_icono'] != null) {
                $options .= '<option data-prioridad="'.$com['cmp_id_tpp'].'" id="cmp_' . $com['cmp_id'] . '" value="' . $com['cmp_id'] . '" data-img="' . base_url() . 'uploads/anx_componentes/' . $com['cmp_icono'] . '">' . $com['cmp_nombre'] . '</option>';
            } else {
                $options .= '<option data-prioridad="'.$com['cmp_id_tpp'].'" id="cmp_' . $com['cmp_id'] . '" value="' . $com['cmp_id'] . '" data-img="">' . $com['cmp_nombre'] . '</option>';
}
        }
        echo $options;        
    }      

}

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */