<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Mantenimiento extends CI_Controller
{
    function __construct()
    {
        parent::__construct();
        $this->load->library('grocery_CRUD');
        $this->load->model('desarrollo_model');
    }

    function index()
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {            
            $data['titulo_personal']='Desarrollo SAT';
            $this->_cargarvista(null,$data);
        }
    }
     /**
   * @author Christian  
   * @return Mantenimiento de tipos de incidencias
   */
 function tipos_incidencias() 
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            try
            {
                $crud = new grocery_CRUD();
                $crud->set_table('tii_tipo_incidencia')
                     ->set_subject('Tipos de incidencias')
                     ->columns('tii_nombre','tii_icono','tii_estado')
                     ->fields('tii_nombre','tii_estado','tii_usu_creacion','tii_usu_modificacion','tii_fecha_creacion','tii_fecha_modificacion','tii_longitud_descripcion','tii_requiere_prueba','tii_requiere_anexo','tii_icono', 'tii_enviar_encuesta', 'tii_id_enc')
                     ->display_as('tii_nombre', 'Nombre')
                     ->display_as('tii_icono', 'Icono')
                     ->display_as('tii_estado', 'Estado')
                     ->display_as('tii_longitud_descripcion', 'Caracteres')
                     ->display_as('tii_requiere_prueba', 'Hacer Pruebas')
                     ->display_as('tii_requiere_anexo', 'Pedir Anexos')
                     ->display_as('tii_enviar_encuesta', 'Enviar encuesta de satisfacción')
                     ->display_as('tii_id_enc', 'Formulario relacionado')                     
                     ->callback_field('tii_requiere_prueba', function($value, $primary_key) {
                            $value = ($value != '') ? $value : 1;
                            $def = ($value > 0) ? 'checked' : '';
                            return '<input type="checkbox" id="chk_pruebas" ' . $def . ' class="nostyle"><input type="hidden" id="field-tii_requiere_prueba" name="tii_requiere_prueba" value="'.$value.'">';
                        })
                     ->callback_field('tii_requiere_anexo', function($value, $primary_key) {
                            $value = ($value != '') ? $value : 1;
                            $def = ($value > 0) ? 'checked' : '';
                            return '<input type="checkbox" id="chk_anexos" ' . $def . ' class="nostyle"><input type="hidden" id="field-tii_requiere_anexo" name="tii_requiere_anexo" value="'.$value.'">';
                        })
                     ->callback_field('tii_enviar_encuesta', function($value, $primary_key) {
                            $value = ($value != '') ? $value : 1;
                            $def = ($value > 0) ? 'checked' : '';
                            return '<input type="checkbox" id="chk_encuesta" ' . $def . ' class="nostyle"><input type="hidden" id="field-tii_enviar_encuesta" name="tii_enviar_encuesta" value="'.$value.'">';
                        })                     
                     ->required_fields('tii_nombre','tii_estado')
                     ->set_rules('tii_id_enc', 'Encuesta', 'callback_validate_encuesta')                     
                     ->set_rules('tii_nombre','Nombre','trim|required|campo_unico[tii_tipo_incidencia.tii_nombre]')
                     ->field_type('tii_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                     ->field_type('tii_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))

                     ->field_type('tii_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                     ->field_type('tii_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
                     
                     ->set_field_upload('tii_icono','uploads/iconos_incidencias')
                     ->set_relation('tii_id_enc', 'enc_encuesta', '{enc_nombre}', array('enc_estado' => 1));

                     ;
                      $crud->callback_before_upload(array($this,'formato_img_callback_before_upload'));

                      if(end(explode('/',uri_string()))=='add') {
                     $crud->field_type('tii_estado','hidden',1);
                     }
                     else {
                     $crud->field_type('tii_estado','dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
                     }                     
                     $data['titulo_personal'] = "Tipos de Incidencias";

                $output = $crud->render();
                $this->_cargarvista($data,$output);
            }
            catch(Exception $e)
            {
                show_error($e->getMessage().' --- '.$e->getTraceAsString());
            }
            
        }
    }

    public function validate_encuesta($value) {
        $tii_enviar_encuesta = $this->input->post('tii_enviar_encuesta');
        if ($tii_enviar_encuesta == 1 && empty($value)) {
            $this->form_validation->set_message('validate_encuesta', '"Formulario relacionado" obligatorio cuando "Enviar encuesta de satisfacción" es habilitado.');
            return false;
        }
        return true;
    }    



    function formato_img_callback_before_upload($files_to_upload,$field_info)
{
    /**
   * @author Christian  
   * @return Mantenimiento Etapas Entregables
   */
 //Examples of what the $files_to_upload and $field_info will be:    
    foreach($files_to_upload as $value) {
        $ext = pathinfo($value['name'], PATHINFO_EXTENSION);
    }

    $allowed_formats = array("jpg","gif","pdf","png","ico");
    if(in_array($ext,$allowed_formats))
    {
        return true;
    }
    else
    {
        return 'El formato de archivo es incorrecto';    
    }

         
}

     /**
   * @author Christian  
   * @return Mantenimiento Etapas Entregables
   */
    function etapas_entregables() 
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            try
            {
                
                $crud = new grocery_CRUD();

                $crud->set_table('etr_etapa_entregable')
                     ->set_subject('Etapa Entregable')
                     ->columns('etr_nombre','etr_orden', 'etr_icono', 'etr_finalizacion')
                     ->fields('etr_nombre','etr_orden','etr_icono','etr_estado','etr_usu_creacion','etr_usu_modificacion','etr_fecha_creacion','etr_fecha_modificacion','etr_finalizacion')
                     ->display_as('etr_nombre', 'Nombre')
                     ->display_as('etr_icono', 'Icono')
                     ->display_as('etr_estado', 'Estado')
                     ->display_as('etr_finalizacion', 'Finalizado')
                     ->display_as('etr_orden', 'Orden')
                     ->display_as('etr_id_esk', 'Estado Ticket')
                     //->display_as('etr_descripcion', 'Descripcion')
                     //->display_as('etr_encuesta', 'Encuesta')
                     //->display_as('etr_pausa', 'Pausada')

                     ->required_fields('etr_nombre','etr_estado','etr_orden')

                     ->set_rules('etr_nombre','Nombre','trim|required|campo_unico[etr_etapa_entregable.etr_nombre]')
                     ->set_rules('etr_orden','Orden','trim|required|is_numeric|campo_unico[etr_etapa_entregable.etr_orden]')
                     ->set_field_upload('etr_icono','uploads/etapas_entregables')
                     //->field_type('etr_encuesta','dropdown', array('1' => 'Si', '0' => 'No'))
                     //->field_type('etr_pausa','dropdown', array('1' => 'Si', '0' => 'No'))
                     ->add_fields('etr_nombre', 'etr_id_esk','etr_estado', 'etr_usu_creacion','etr_usu_modificacion','etr_fecha_creacion','etr_fecha_modificacion',  'etr_orden', 'etr_finalizacion', 'etr_icono' )
                     ->edit_fields('etr_nombre', 'etr_id_esk', 'etr_usu_creacion','etr_usu_modificacion','etr_fecha_creacion','etr_fecha_modificacion', 'etr_orden', 'etr_estado', 'etr_finalizacion', 'etr_icono')
                     ->set_relation('etr_id_esk', 'esk_estado_ticket', 'esk_nombre',array('esk_estado'=>1))

                     ->field_type('etr_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                     ->field_type('etr_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))

                     ->field_type('etr_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                     ->field_type('etr_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
              
                    ;
                    $crud->callback_before_upload(array($this,'formato_img_callback_before_upload'));
                   
                    //AGREGAR UN INPUT TYPE="CHECKBOX EDITAR Y AGREGAR"    
                    $crud->callback_insert(array($this,'ingresar_check_callback'));

                    //ACTUALIZAR
                    $crud->callback_update(array($this,'actualizar_check_callback'));
                    $crud->callback_edit_field('etr_finalizacion',array($this,'mostrar_check_edit_callback'));
                    $crud->callback_add_field('etr_finalizacion',array($this,'mostrar_check_edit_callback'));

                    $url_explode = explode('/', uri_string());

                    if(end($url_explode) == 'add') {
                        $crud->field_type('etr_estado','hidden',1);
                    }
                    else {
                        $crud->field_type('etr_estado','dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
                        $crud->field_type('etr_finalizacion','dropdown', array('1' => 'Si', '0' => 'No'));
                    }                     
                    $data['titulo_personal'] = "Estado Ticket";

                $output = $crud->render();
                $this->_cargarvista($data,$output);
            }
            catch(Exception $e)
            {
                show_error($e->getMessage().' --- '.$e->getTraceAsString());
            }
            
        }
    }

 /**
   * @author Christian  
   * @return Mantenimiento Etapas Entregables
   */
    /*=======================================*/
    //   inicio callback de etapas_entregables
    /*=======================================*/
       function ingresar_check_callback($post_array) {
         
          $post_array['etr_finalizacion'] = ($post_array['etr_finalizacion']==1)?$post_array['etr_finalizacion']:0;
            unset($post_array['etr_finalizacion2']);
          return $this->db->insert('etr_etapa_entregable',$post_array);
        }        
         

   
        //FUNCION DE CHECKBOX AGREGADO A ETAPAS ENTREGABLES
        function actualizar_check_callback($post_array, $primary_key) {
            
             //die(print_r($post_array,true));
          
         
        if($post_array['etr_finalizacion']==1)
        {
            $post_array['etr_finalizacion'] = 1;

            unset($post_array['etr_finalizacion2']);
        }
        elseif ($post_array['etr_finalizacion2']==0) {

             $post_array['etr_finalizacion'] = 0;
              unset($post_array['etr_finalizacion2']);

        }else
        {
            unset($post_array['etr_finalizacion']);

        }
     
      return $this->db->update('etr_etapa_entregable',$post_array,array('etr_id' => $primary_key));
        }



        function mostrar_check_edit_callback($value, $primary_key) {
           // return '<input type="checkbox"  value="1" name="etr_finalizacion" > <input type="hidden" value="0" name="etr_finalizacion2" >';
         if ($value == 0) {
              return '<input type="checkbox" value="1" name="etr_finalizacion" > <input type="hidden" value="0" name="etr_finalizacion2" >';

            }else{ return '<input type="checkbox" value="1" name="etr_finalizacion" checked><input type="hidden" value="0" name="etr_finalizacion2" >';}

        }
     /*=======================================*/
    //   fin callback de etapas_entregables
    /*=======================================*/  
    


    /**
    * @author René Castaneda
    * @since 2017-08-21
    * @return Gestión de reunión diaria de scrum
     */
    function scrum() 
    {
    	if (!$this->tank_auth->is_logged_in()) {
    		redirect('/auth/login/');
    	} else {
    		try
    		{
    			$permisos = $this->gsatelite->get_permisos_opcion();
    			$usuario_admin = (in_array($this->tank_auth->get_user_id(),array(1)))? 1:0;
    			$data['usuario_admin'] = $usuario_admin;
    			$where_datos = null;
    			$usuario_ = "";
    			if ($this->input->post()) {
    				$this->session->set_userdata('scrum_usuario',$this->input->post('usuario'));
    				$this->session->set_userdata('scrum_fecha_ini',$this->input->post('fecha_inicio'));
    				$this->session->set_userdata('scrum_fecha_fin',$this->input->post('fecha_fin'));		
    			}
    			if ($usuario_admin == 0) {
    				$fecha = date_create(date('Y-m-d'));
    				date_add($fecha, date_interval_create_from_date_string('-30 day'));
    				$fecha_inicio = date_format($fecha, 'Y-m-d');

    				$where_datos['scr_id_usu_consultor'] = $this->tank_auth->get_user_id();
    				$where_datos['DATE_FORMAT(scr_fecha,"%Y-%m-%d") >='] = $fecha_inicio;
    				$where_datos['DATE_FORMAT(scr_fecha,"%Y-%m-%d") <='] = date('t-m-Y');
    				$usuario_ = " - ".$this->tank_auth->get_username();
    			} 

    			if ($this->session->userdata('scrum_usuario') > 0 ) {
    				$where_datos['scr_id_usu_consultor'] = $this->session->userdata('scrum_usuario');
    			}

    			if ($this->session->userdata('scrum_fecha_ini') != '' ) {
    				$where_datos['DATE_FORMAT(scr_fecha,"%Y-%m-%d") >='] = formatear_fecha('Y-m-d',$this->session->userdata('scrum_fecha_ini'));
    			}
    			if ($this->session->userdata('scrum_fecha_fin') != '' ) {
    				$where_datos['DATE_FORMAT(scr_fecha,"%Y-%m-%d") <='] = formatear_fecha('Y-m-d',$this->session->userdata('scrum_fecha_fin'));
    			}
    			$where_select = ($usuario_admin == 0)? array('id' => $this->tank_auth->get_user_id(),'activated' => '1'):array('activated' => '1');
    			$data['usuarios'] = $this->gsatelite->get_dropdown('users', '{username}','', $where_select, $this->session->userdata('scrum_usuario'), '', 'id', true);

    			$crud = new grocery_CRUD();
    			$crud->set_table('scr_scrum')
    			->set_subject("Scrum$usuario_")
    			->columns('scr_id_usu_consultor','scr_fecha','scr_asignacion','scr_descripcion','scr_problema','scr_siguiente_scrum','rol','scr_avance_plan')
    			->display_as('scr_id_usu_consultor', 'Responsable')
    			->display_as('scr_fecha', 'Fecha')
    			->display_as('scr_asignacion', 'Asignación')
    			->display_as('scr_descripcion', '¿Qué has hecho para alcanzar la meta del sprint (ayer)?')
    			->display_as('scr_problema', '¿Has tenido algún Problema para alcanzar la meta del sprint?')
    			->display_as('rol', 'Incidencias Trabajadas')
    			->display_as('scr_siguiente_scrum', '¿En que continuarias trabajando para alcanzar la meta del sprint (hoy)?')
    			->display_as('scr_avance_plan', '% Avance Plan');
    			if ($usuario_admin == 0 ) {
    				$crud->field_type('scr_id_usu_consultor', 'hidden', $this->tank_auth->get_user_id());
    			}

    			$crud->required_fields('scr_id_usu_consultor','scr_fecha','scr_descripcion','scr_asignacion')                        
    			->field_type('scr_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
    			->field_type('scr_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
    			->field_type('scr_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
    			->field_type('scr_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
    			->unset_edit_fields('scr_id_usu_consultor','scr_usu_creacion','scr_fecha_creacion','scr_fecha')
    			;
    			$crud->set_relation_n_n('rol', 'ixs_incidencia_scrum', 'inc_incidencia', 'ixs_id_scr', 'ixs_id_inc', 'inc_codigo', null, array('inc_estado' => 1,'inc_id_usr_asignado' => $this->tank_auth->get_user_id(),'YEAR(inc_fecha_modificacion)' => date('Y')));
    			$crud->field_type('scr_estado','hidden',1);
    			if ( $usuario_admin == 0 ) {
    				$crud->unset_delete()
    					->unset_export()
    					->unset_print()
		    			->field_type('scr_fecha', 'hidden', date('Y-m-d H:i:s'))
                        ->callback_before_insert(function($post_array, $primary_key) {
                            $post_array['scr_fecha'] = date('Y-m-d H:i:s'); //reasignar la fecha actual
                            return $post_array;
                        })
    			;  
    			}
    			if ($where_datos) {
    				$crud->where($where_datos);
    			} else {
                    $crud->where('scr_id',0);
                }              

    			$existe = $this->gsatelite->get_tabla('scr_scrum',array('scr_id_usu_consultor'=>$this->tank_auth->get_user_id(),'DATE_FORMAT(scr_fecha,"%Y-%m-%d")'=>date('Y-m-d'))); 
    			if (count($existe)>0 and  $usuario_admin == 0 ) {
    				$crud->unset_add()
    					 ->set_relation('scr_id_usu_consultor', 'users', 'username')
    					 ;

    			} elseif (count($existe)>0 and  $usuario_admin == 1 and substr_count(uri_string(), 'add') > 0 ) {
    				$crud->set_relation('scr_id_usu_consultor', 'users', 'username',array('id !='=>$this->tank_auth->get_user_id()))
    					 ;
    			} else {
    				$crud->set_relation('scr_id_usu_consultor', 'users', 'username');
    			}

    			if ((substr_count(uri_string(), 'edit') > 0 || substr_count(uri_string(), 'read') > 0 ) and  $usuario_admin == 0 ) {
    				$id = end(explode('/', uri_string()));
                    if (substr_count(uri_string(), 'edit') > 0) {
                    $existe = $this->gsatelite->get_tabla('scr_scrum',array('scr_id_usu_consultor'=>$this->tank_auth->get_user_id(),'DATE_FORMAT(scr_fecha,"%Y-%m-%d")'=>date('Y-m-d'),'scr_id'=>$id)); 
                    } else { //read
                        $existe = $this->gsatelite->get_tabla('scr_scrum',array('scr_id_usu_consultor'=>$this->tank_auth->get_user_id(),'scr_id'=>$id)); 
                    }
    				if (count($existe) <=0 ) {
    					$this->gsatelite->show_dialog('','desarrollo/mantenimiento/scrum', 'error', 'Acceso denegado - Registro no Editable');
    				} 
    			}

    			$crud->callback_column('scr_fecha', function($value,$row) {
    				return formatear_fecha('d-m-Y H:i:s', $value);
    			});

                $crud->order_by('scr_fecha');

    			$data['titulo_personal'] = "Scrum - Seguimiento plan de trabajo (Sprint)";
    			$data['fecha_actual'] = date('d-m-Y');

    			// Validaciones
    			if (!$permisos['permite_agregar']) {
    			    $crud->unset_add();
    			}
    			if (!$permisos['permite_editar']) {
    			    $crud->unset_edit();
    			}
    			if (!$permisos['permite_eliminar']) {
    			    $crud->unset_delete();
    			}
    			if ($permisos['permite_ver']) {
    			    $crud->add_action('Ver', 'minia-icon-search', 'desarrollo/mantenimiento/scrum/read');
    			}

    			$output = $crud->render();
    			$this->_cargarvista($data,$output);
    		}
    		catch(Exception $e)
    		{
    			show_error($e->getMessage().' --- '.$e->getTraceAsString());
    		}

    	}
    }



    function _cargarvista($data=0,$crud=0)
    {   
        $this->load->view('vacia',$crud);   
        if($data!=0)
            $data=array_merge($data,$this->masterpage->getUsuario());
        else
            $data=$this->masterpage->getUsuario();
        $vista=$data['modulo'].'/'.$data['control'].'/'.$data['funcion'];
        $this->masterpage->setMasterPage('masterpage_default');
        $this->masterpage->addContentPage($vista, 'content',$data);
        $this->masterpage->show();
    }


    /**
    * @author: Nelson Soriano
    * @since:  24-04-2019
    * @return  Mantenimiento de estados de pruebas sugeridas
    */

    public function estados_pruebas(){
        satelite_validar();

        $permisos = $this->gsatelite->get_permisos_opcion();
        $crud = new grocery_CRUD();

        $alias = array(
            'esb_nombre'  => 'Nombre estado.',
            'esb_estado'  => 'Estado', 
            'esb_defecto' => 'Defecto'          
        );

        $add   = array(
            'esb_nombre',
            'esb_defecto',
            'esb_estado',
            'esb_usu_creacion',
            'esb_usu_modificacion',
            'esb_fecha_creacion',
            'esb_fecha_modificacion'
        );

        $edit  = array(
            'esb_nombre',
            'esb_defecto',
            'esb_estado',
            'esb_usu_modificacion',
            'esb_fecha_modificacion'
        );

        $columns = array(
            'esb_nombre',
            'esb_estado',
            'esb_defecto'
        );

        $required = array('esb_nombre');

        $crud->set_table('esb_estado_prueba')
             ->set_subject('')
             ->add_fields($add)
             ->edit_fields($edit)
             ->columns($columns)
             ->display_as($alias)
             ->required_fields($required)
             ->field_type('esb_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
             ->field_type('esb_usu_modificacion','hidden',$this->tank_auth->get_user_id())
             ->field_type('esb_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
             ->field_type('esb_fecha_modificacion','hidden',date('Y-m-d H-i-s'))
             ->callback_column('cfc_defecto', function($value, $row) {
                if ($value == 1) {
                    return 'Si';
                }
             })
             ->callback_add_field('esb_defecto', function() {
                    return '<input type="checkbox" id="chbdefecto" class="nostyle"><input type="hidden" id="field-esb_defecto" name="esb_defecto" value="0">';
             })
             ->callback_edit_field('esb_defecto', function($value, $primary_key) {
                $id      = $primary_key;
                $leer    = ($this->uri->rsegments[3] == 'read')?'iButton':'';
                $defecto = ($value)?'checked':''; // Verificar si esta activo
                return '<input type="checkbox" id="chbdefecto" '.$defecto.' class="'.$leer.' nostyle"><input type="hidden" id="field-esb_defecto" name="esb_defecto" value="'.$value.'">';
             })
        ;

        $crud->callback_column('esb_defecto', function($value,$row) {
            if ($value == 1) {
                return "Defecto";
            }else{ return '';}
        });

        if (end(explode('/',uri_string())) == 'add' ) {
            $crud->field_type('esb_estado','hidden',1);
        }else{
            $crud->field_type('esb_estado','dropdown',array('1' => 'Activo','0' => 'Inactivo'));
        }

        if(!$permisos['permite_agregar']){
            $crud->unset_add();
        }

        if(!$permisos['permite_editar']){
            $crud->unset_edit();
        }

        if(!$permisos['permite_eliminar']){
            $crud->unset_delete();
        }
         $data['reg_id']          = (is_numeric(end(explode('/', uri_string()))))?end(explode('/', uri_string())):0;

        $crud->callback_after_insert(array($this, 'actualizar_defecto'));
        $crud->callback_after_update(array($this, 'actualizar_defecto'));
        $output = $crud->render();
        $data['titulo_personal'] = 'Estados de pruebas';
        $this->_cargarvista($data, $output,'desarrollo/mantenimiento/estados_pruebas');

    }

   public  function actualizar_defecto($post_array,$primary_key)
    { 
        if ($post_array['esb_defecto']  == 1) {
           $this->gsatelite->actualizar_array('esb_estado_prueba',array('esb_defecto' => 0),array('esb_estado' => 1,'esb_id <>' => $primary_key));
        }
     
        return true;
    }

   public function aplica_actualizar_defecto(){
    $flag =  $this->input->post('flag');
    if ($flag !== '') {
        $total = $this->gsatelite->get_tabla('esb_estado_prueba', array('esb_estado' => 1,'esb_defecto' => 1));
        if (count($total) > 0) {
            echo json_encode(array('es_defecto' => 1));
        }
    }
}

    public function tipo_prioridad() {

        satelite_validar();
        try {
            $permisos = $this->gsatelite->get_permisos_opcion();
            $add_columns = array(
                'tpp_nombre',
                'tpp_atencion',
                'tpp_color',
                'tpp_nivel',
                'tpp_tiempo_tolerancia',
                'tpp_icono',
                'tpp_estado',
                'tpp_usu_creacion',
                'tpp_fecha_creacion',
                'tpp_usu_modificacion',
                'tpp_fecha_modificacion'
            );
            $edit_columns = array(
                'tpp_nombre',
                'tpp_atencion',
                'tpp_color',
                'tpp_estado',
                'tpp_nivel',
                'tpp_tiempo_tolerancia',
                'tpp_icono',
                'tpp_usu_modificacion',
                'tpp_fecha_modificacion'
            );
            $required_fields = array(
                'tpp_nombre',
                'tpp_atencion',
                'tpp_nivel',
                'tpp_color',
                'tpp_tiempo_tolerancia',
                'tpp_estado'
            );
            $alias = array(
                'tpp_nombre' => 'Nombre',
                'tpp_atencion' => 'Importancia',
                'tpp_nivel' => 'Nivel',
                'tpp_estado' => 'Estado',
                'tpp_color' => 'Color',
                'tpp_icono' => 'Icono',
                'tpp_tiempo_tolerancia' => 'Tiempo de Tolerancia'
            );
            $columns = array(
                'tpp_nombre',
                'tpp_nivel',
                'tpp_estado',
                'tpp_atencion',
                'tpp_color',
                'tpp_icono',
                'tpp_tiempo_tolerancia'
            );
            $crud = new grocery_CRUD();
            $crud->set_table('tpp_tipo_prioridad');
            $crud->set_subject('Tipo de Prioridad');
            $crud->display_as($alias);
            $crud->columns($columns);
            $crud->add_fields($add_columns);
            $crud->edit_fields($edit_columns);
            $crud->required_fields($required_fields);
            $crud->callback_field('tpp_color', function ($value = '', $primary_key = null) {
                $ver = '<table width="10%"><tr><td style="height: 30px; border: solid black 1px; background-color:'.$value.'">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td></tr></table>';
                return '<div class="span10" style="display: flex">
                <input type="text" id="field-tpp_color" name="tpp_color" style="width:35% !important;display: inline-block;" readonly value="' . $value . '">
                <div id="colorSelector" style="margin-left:7px;"><div style="background-color:' . $value . '"></div></div>
                <div id="read_color" style="margin-left:7px; display: none;">' . $ver . '</div></div>';
            });
            $crud->set_field_upload('tpp_icono', 'uploads/iconos_tipo_prioridad');
            $crud->field_type('tpp_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('tpp_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->set_rules('tpp_nombre', 'Nombre', 'trim|required|campo_unico[tpp_tipo_prioridad.tpp_nombre]');
            $crud->set_rules('tpp_nivel','Nivel','trim|required|is_numeric|campo_unico[tpp_tipo_prioridad.tpp_nivel]');


            $url_explode = explode('/', uri_string());
            if (end($url_explode) == 'add') {
                $crud->field_type('tpp_estado', 'hidden', 1);
                $crud->field_type('tpp_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
                $crud->field_type('tpp_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
            } else {
                $crud->field_type('tpp_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if (!$permisos['permite_ver']) {
                $crud->unset_read();
                $crud->unset_print();
                $crud->unset_export();
            }
            $output = $crud->render();
            $data['titulo_personal'] = 'Tipo de prioridad';
            $this->_cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }
    
    public function estado_ticket() {
        satelite_validar();
        try {
            $permisos = $this->gsatelite->get_permisos_opcion();
            $add_columns = array(
                'esk_nombre',
                'esk_descripcion',
                'esk_encuesta',
                'esk_icono',
                'esk_orden',
                'esk_finalizacion',
                'esk_pausa',
                'esk_estado',
                'esk_usu_creacion',
                'esk_fecha_creacion',
                'esk_usu_modificacion',
                'esk_fecha_modificacion'
            );
            $edit_columns = array(
                'esk_nombre',
                'esk_descripcion',
                'esk_encuesta',
                'esk_icono',
                'esk_orden',
                'esk_finalizacion',
                'esk_pausa',
                'esk_estado',
                'esk_usu_modificacion',
                'esk_fecha_modificacion'
            );
            $required_fields = array(
                'esk_nombre',
                'esk_estado',
                'esk_orden'
            );
            $alias = array(
                'esk_nombre' => 'Nombre',
                'esk_estado' => 'Estado',
                'esk_descripcion' => 'Descripción',
                'esk_encuesta' => 'Encuesta',
                'esk_icono' => 'Icono',
                'esk_orden' => 'Orden',
                'esk_finalizacion' => 'Finalizado',
                'esk_pausa' => 'Pausada',
            );
            $columns = array(
                'esk_nombre',
                'esk_orden',
                // 'esk_descripcion',
                'esk_icono',
                'esk_finalizacion',
                'esk_encuesta',
                'esk_pausa'
            );
            $crud = new grocery_CRUD();
            $crud->set_table('esk_estado_ticket');
            $crud->set_subject('Estado de Ticket');
            $crud->display_as($alias);
            $crud->columns($columns);
            $crud->add_fields($add_columns);
            $crud->edit_fields($edit_columns);
            $crud->required_fields($required_fields);
            $crud->set_rules('esk_orden','Orden','trim|required|is_numeric|campo_unico[esk_estado_ticket.esk_orden]');
            $crud->set_field_upload('esk_icono','uploads/iconos_estado_ticket');
            $crud->field_type('esk_finalizacion','dropdown', array('1' => 'Si', '0' => 'No'));
            $crud->field_type('esk_encuesta','dropdown', array('1' => 'Si', '0' => 'No'));
            $crud->field_type('esk_pausa','dropdown', array('1' => 'Si', '0' => 'No'));
            $crud->field_type('esk_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('esk_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->set_rules('esk_nombre', 'Nombre', 'trim|required|campo_unico[esk_estado_ticket.esk_nombre]');
            
            $url_explode = explode('/', uri_string());
            if (end($url_explode) == 'add') {
                $crud->field_type('esk_estado', 'hidden', 1);
                $crud->field_type('esk_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
                $crud->field_type('esk_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
            } else {
                $crud->field_type('esk_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if (!$permisos['permite_ver']) {
                $crud->unset_read();
                $crud->unset_print();
                $crud->unset_export();
            }
            $output = $crud->render();
            $data['titulo_personal'] = 'Estado de Ticket';
            $this->_cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    public function componentes_tickets() {
        satelite_validar();
        try {
            $permisos = $this->gsatelite->get_permisos_opcion();
            $add_columns = array(
                'cmp_nombre',
                'cmp_id_pry',
                'cmp_tiempo_ejecucion',
                'cmp_id_tpp',
                'cmp_id_padre',
                'cmp_tiempo_tolerancia',
                'cmp_estado',
                'cmp_usu_creacion',
                'cmp_fecha_creacion',
                'cmp_usu_modificacion',
                'cmp_fecha_modificacion',
                'cmp_es_padre'
            );
            $edit_columns = array(
                'cmp_nombre',
                'cmp_id_pry',
                'cmp_tiempo_ejecucion',
                'cmp_estado',
                'cmp_id_tpp',
                'cmp_id_padre',
                'cmp_tiempo_tolerancia',
                'cmp_usu_modificacion',
                'cmp_fecha_modificacion',
                'cmp_es_padre'
            );
            $required_fields = array(
                'cmp_id_pry',
                'cmp_nombre',
                'cmp_tiempo_ejecucion',
                'cmp_tiempo_tolerancia',
                'cmp_id_tpp',
                'cmp_estado'
            );
            $alias = array(
                'cmp_id_pry' => 'Proyecto',
                'cmp_id_padre' => 'Componente Padre',
                'cmp_nombre' => 'Nombre',
                'cmp_tiempo_ejecucion' => 'Ejecucion',
                'cmp_tiempo_tolerancia' => 'Tolerancia',
                'cmp_id_tpp' => 'Prioridad por defecto',
                'cmp_estado' => 'Estado',
                'cmp_es_padre' => 'Es padre'
            );
            $columns = array(
                'cmp_id_pry',
                'cmp_id_padre',
                'cmp_nombre',
                'cmp_tiempo_ejecucion',
                'cmp_tiempo_tolerancia',
                'cmp_id_tpp',
                'cmp_es_padre'
            );
            $crud = new grocery_CRUD();
            $crud->set_table('cmp_componente');
            $crud->set_subject('Componente de Tickets');
            $crud->display_as($alias);
            $crud->columns($columns);
            $crud->add_fields($add_columns);
            $crud->edit_fields($edit_columns);
            $crud->required_fields($required_fields);
            $crud->set_relation('cmp_id_pry', 'pry_proyecto', 'pry_nombre', array('pry_estado' => '1'));
            $crud->set_relation('cmp_id_tpp', 'tpp_tipo_prioridad', 'tpp_nombre', array('tpp_estado' => '1'));
            $crud->set_relation('cmp_id_padre', 'cmp_componente', 'cmp_nombre', array('cmp_estado' => '1', 'cmp_es_padre' => '1'));
            $crud->field_type('cmp_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('cmp_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->set_rules('cmp_nombre', 'Nombre', 'trim|required|campo_unico[cmp_componente.cmp_nombre]');
            $crud->field_type('cmp_es_padre', 'dropdown', array('1' => 'Si', '0' => 'No'));
            
            $url_explode = explode('/', uri_string());
            if (end($url_explode) == 'add') {
                $crud->field_type('cmp_estado', 'hidden', 1);
                $crud->field_type('cmp_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
                $crud->field_type('cmp_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
            } else {
                $crud->field_type('cmp_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if (!$permisos['permite_ver']) {
                $crud->unset_read();
                $crud->unset_print();
                $crud->unset_export();
            }
            $output = $crud->render();
            $data['titulo_personal'] = 'Componentes de Tickets';
            $this->_cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }    
  
}

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */