<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Inicio extends CI_Controller {
    
    function __construct() {
        parent::__construct();
        $this->load->model('desarrollo_model');
        $this->load->model('inventario_model');
        $this->load->model('gsatelite');
        $this->load->library('grocery_CRUD');
        $this->load->library('excel/excel_reader.php');
    }

    function _cargarvista($data = 0, $crud = 0){
        $this->load->view('vacia', $crud);
        if ($data != 0)
            $data = array_merge($data, $this->masterpage->getUsuario());
        else
            $data = $this->masterpage->getUsuario();
        $vista = $data['modulo'] . '/' . $data['control'] . '/' . $data['funcion'];
        $this->masterpage->setMasterPage('masterpage_default');
        $this->masterpage->addContentPage($vista, 'content', $data);
        $this->masterpage->show();
    }
    
    function index() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $this->_cargarvista();
        }
    }

    // Tareas pendientes
    function tareas_pendientes(){
        satelite_validar();
        if ($_POST) {
                
                $post_array = $this->input->post();

                $proyectos = $post_array['proyecto'];
                $estado = $post_array['estado'];
                $fecha_inicio = $post_array['fecha_ini'];
                $fecha_fin = $post_array['fecha_fin'];

                $where = null;
                
                if ($proyectos != '') {
                    $where['pry_id'] = $proyectos;
                } 
                if ($estado != '') {
                    $where['esk_id'] = $estado;
                }
                if ($fecha_inicio != '') {
                    $where['DATE(tkh_fecha_ingreso) >='] = date('Y-m-d', strtotime($fecha_inicio));
                }
                if ($fecha_fin != '') {
                    $where['DATE(tkh_fecha_ingreso) <='] = date('Y-m-d', strtotime($fecha_fin));
                }

                $where["(cft_id_usu = {$this->tank_auth->get_user_id()} OR ret_id_usu = {$this->tank_auth->get_user_id()})"] = NULL;
                
                $tareas_pendientes = $this->desarrollo_model->get_tickets($where);

                $data['tareas_pendientes'] = $tareas_pendientes;

                $html = $this->load->view('desarrollo/inicio/consultar_tareas_pendientes', $data, true);

                echo $html;
                die();
            
        } else{

                $this->db->join('cft_configuracion_ticket', 'cft_id_pry = pry_id');
                $this->db->join('ret_responsable_confg_ticket_helpdesk', "ret_id_cft = cft_id", 'left');                
                $this->db->group_by('pry_id');
            $select = $this->gsatelite->get_dropdown('pry_proyecto', '{pry_nombre}', '', array("(cft_id_usu = {$this->tank_auth->get_user_id()} OR ret_id_usu = {$this->tank_auth->get_user_id()})" => NULL, 'pry_estado' => 1), null, '', 'pry_id', true);
            $data["proyectos"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $select);

            $select = $this->gsatelite->get_dropdown('esk_estado_ticket', '{esk_nombre}', '', array('esk_estado' => 1), null, '', 'esk_id', true);
            $data["estados"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $select);

            $data['titulo_personal'] = "Tareas pendientes";
            $this->_cargarvista($data);
        }
    }

}