<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Consultas extends CI_Controller {

    function __construct() {
        parent::__construct();
        $this->load->library('grocery_CRUD');
        $this->load->model('gsatelite');
        $this->load->model('desarrollo_model');
    }

    function consultar_pizarra($pry_id = 0, $enr_id = null) {
            satelite_validar();
            if ($_POST) {
                $post_array = $this->input->post();

                $pry_id = $post_array['proyecto'];
                $enr_id = $post_array['sprint'];
                $filtros = (isset($post_array['filtros'])) ? $post_array['filtros'] : "";
            }

            //var_dump($post_array);die();

            $where = array('etr_estado' => 1);
            $group_by = array('etr_orden');
            $order_by = 'etr_orden ASC';
            $etapas = $this->desarrollo_model->get_etapas_entregables($where, $order_by, $group_by);

            //var_dump($etapas);

            $data['etapas'] = $etapas;

            $data['proyecto'] = $this->gsatelite->get_tabla('pry_proyecto', array('pry_id' => $pry_id));

            $data['sprints'] = $this->gsatelite->get_tabla('enr_entregable', array('enr_estado' => 1, 'enr_id_pry' => $pry_id, 'enr_activo' => 1));

            $where_inc = array('inc.inc_id_enr' => $enr_id, 'inc.inc_estado' => 1);

            /*
             * Se agregan los filtros seleccionados
             */
            $where_cliente = '';
            if ($filtros != '') {
                $arrayFiltros = array(
                    '1' => "inc.inc_id_usr_asignado",
                    '2' => "inc.inc_id_usr_informante",
                    '3' => "inc.inc_fecha_creacion",
                    '4' => "inc.inc_fecha_entrega",
                    '5' => "cliente",
                    '6' => "inc.inc_id_cmp",
                );

                $splitFiltro = explode("#", $filtros);
                //Si se encuentra una "/" se trata de fechas
                if (!strpos($filtros, "/")) {
                    if ($splitFiltro[0] != 5 ) { //omitir el de cliente
                        $where_inc[$arrayFiltros[$splitFiltro[0]]] = $splitFiltro[1];
                    } else {
                        $where_cliente = " inc.inc_id in ( select inl_id_inc from inl_incidencia_cliente where inl_id_cli = $splitFiltro[1] )";
                    }
                } else {
                    $splitFechas = explode("/", $splitFiltro[1]);

                    $fecha_inicio = date('Y-m-d', strtotime($splitFechas[0]));
                    $fecha_fin = date('Y-m-d', strtotime($splitFechas[1]));

                    $where_inc['date(' . $arrayFiltros[$splitFiltro[0]] . ') >='] = $fecha_inicio;
                    $where_inc['date(' . $arrayFiltros[$splitFiltro[0]] . ') <='] = $fecha_fin;
                }
            }

            //var_dump($where_inc);
            //die();

            //$order_by = 'inc.inc_id ASC';
            $order_by = 'inc.inc_importancia DESC';
            $incidencias = $this->desarrollo_model->get_data_incidencias($where_inc, $order_by, null, $where_cliente);
            //die(var_dump($incidencias));

            $data['incidencias'] = $incidencias;

            $data['titulo_personal'] = 'Pizarra';

            $data['titulo_formulario'] = 'Proyecto - ' . $data['proyecto'][0]['pry_nombre'];

            $data['pry_id'] = $pry_id;

            $data['spr_id'] = $enr_id;

            $this->load->view('desarrollo/procesos/consultar_pizarra', $data);

            //echo $html;
        
    }

    function consultar_seguimiento($pry_id = 0, $enr_id = null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {

            if ($_POST) {
                $pry_id = $this->input->post('proyecto');
                $enr_id = $this->input->post('sprint');
            }

            $where = array('inc_id_enr' => $enr_id);
            $seguimiento = $this->desarrollo_model->get_data_seguimiento($where);

            echo count($seguimiento);
        }
    }

    function _cargarvista($data = 0, $crud = 0) {
        $this->load->view('vacia', $crud);
        if ($data != 0)
            $data = array_merge($data, $this->masterpage->getUsuario());
        else
            $data = $this->masterpage->getUsuario();
        $vista = $data['modulo'] . '/' . $data['control'] . '/' . $data['funcion'];
        $this->masterpage->setMasterPage('masterpage_default');
        $this->masterpage->addContentPage($vista, 'content', $data);
        $this->masterpage->show();
    }

}

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */
