<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Mantenimientos extends CI_Controller
{

    function __construct()
    {
        parent::__construct();

        $this->load->library('grocery_CRUD');
        $this->load->model('proceso_model');
        $this->load->model('inventario_model');
        $this->load->model('cotizaciones_model');
        $this->load->model('contabilidad_model');
        $this->load->model('gsatelite');
        $this->load->model('inventario_model');
        $this->load->model('personal_model');
        $this->load->model('expediente_personal_model');
        $this->load->model('proyecto_model');
    }

    function index()
    {
        // $this->load->view('cotizaciones/mantenimientos/vendedores',$data);
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $this->_cargarvista();
        }
    }

    function marcas()
    {
        satelite_validar();
        $this->load->library('../controllers/inventario/mantenimiento');
        $this->mantenimiento->marca_producto('inventario');
    }

    public function tipo_cliente($url_vista = '')
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {

            $permisos = $this->gsatelite->get_permisos_opcion();
            $crud = new grocery_CRUD();
            $crud->set_table('tpc_tipo_cliente');
            //$crud->set_subject('Tipos de cliente');
            $crud->set_subject('');
            $crud->fields('tpc_nombre', 'tpc_descripcion', 'tpc_estado', 'tpc_usu_mod', 'tpc_fecha_mod', 'tpc_usu_crea', 'tpc_fecha_crea');
            $crud->required_fields('tpc_nombre', 'tpc_estado');
            $crud->columns('tpc_nombre', 'tpc_descripcion', 'tpc_estado');
            $crud->display_as('tpc_nombre', 'Nombre');
            $crud->display_as('tpc_descripcion', 'Descripción');
            $crud->display_as('tpc_estado', 'Estado');
            $crud->field_type('tpc_usu_mod', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('tpc_fecha_mod', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('tpc_usu_crea', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('tpc_fecha_crea', 'hidden', date('Y-m-d H:i:s'));
            $crud->set_rules('tpc_nombre', 'Nombre', 'trim|required|campo_unico[tpc_tipo_cliente.tpc_nombre]');

            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('tpc_estado', 'hidden', 1);
            } else {  // Editar
                $crud->field_type('tpc_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            // Validar Permisos. Agregado por Luis Navarro
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if ($permisos['permite_ver']) {
                $data_url = $this->masterpage->getUsuario();
                $url_read = $data_url['modulo'] . '/' . $data_url['control'] . '/' . $data_url['funcion'];
                $crud->add_action('Ver', 'minia-icon-search', $url_read . "/read");
            }

            $output = $crud->render();
            $data['titulo_personal'] = "Tipos de clientes";
            $this->_cargarvista($data, $output, $url_vista);
        }
    }

    /**
     * Descripcion:
     * Funcion encargada de el mantenimeinto de tipos de preguntas
     * @author Nelson David Soriano
     * @since  30-11-2018
     **/

    public function tipos_preguntas()
    {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();
        $crud   = new grocery_CRUD();

        $alias  = array(
            'tpe_nombre'            => 'Nombre del tipo',
            'tpe_configuracion'     => 'Configuracion',
            'tpe_fecha_creacion'    => 'Fecha creacion',
            'tpe_estado'            => 'Estado'
        );

        $columns = array(
            'tpe_nombre',
            'tpe_estado'
        );

        $edit = array(
            'tpe_nombre',
            'tpe_estado',
            'tpe_configuracion',
            'tpe_fecha_modificacion',
            'tpe_usu_modificacion'
        );

        $add = array(
            'tpe_nombre',
            'tpe_estado',
            'tpe_configuracion',
            'tpe_usu_creacion',
            'tpe_fecha_creacion',
            'tpe_fecha_modificacion',
            'tpe_usu_modificacion'
        );

        $required = array(
            'tpe_nombre',
            'tpe_estado',
            'tpe_fecha_creacion',
            'tpe_fecha_modificacion',
            'tpe_usu_creacion',
            'tpe_usu_modificacion'
        );

        $crud->set_table('tpe_tipo_pregunta')
            //->set_subject('Tipo de Pregunta')
            ->set_subject('')
            ->columns($columns)
            ->add_fields($add)
            ->edit_fields($edit)
            ->display_as($alias)
            ->required_fields($required)
            ->field_type('tpe_fecha_modificacion', 'hidden', date('Y-m-d h:i:s'))
            ->field_type('tpe_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
            ->field_type('tpe_fecha_creacion', 'hidden', date('Y-m-d h:i:s'))
            ->field_type('tpe_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
            ->unset_delete();

        if (end(explode('/', uri_string())) ==  'add') {
            $crud->field_type('tpe_estado', 'hidden', 1);
        } else {
            $crud->field_type('tpe_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }
        $crud->callback_column('tpe_fecha_creacion', function ($value, $row) {
            return formatear_fecha('d-m-Y', $value);
        });

        if (!$permisos['permite_editar']) {
            $crud->unset_edit();
        }

        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }

        $output = $crud->render();
        $data['titulo_personal'] = 'Tipos de preguntas';
        $this->_cargarvista($data, $output, 'cotizaciones/mantenimientos/tipos_preguntas');
    }
    function gestion_condicion()
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            // Variable para permisos. Agregado por Luis Navarro
            $permisos = $this->gsatelite->get_permisos_opcion();
            $crud = new grocery_CRUD();
            $crud->set_table('cod_condicion')
                //->set_subject('Condición')
                ->set_subject('')
                ->columns('cod_nombre', 'cod_descripcion', 'cod_estado')
                ->display_as('cod_nombre', 'Nombre')
                ->display_as('cod_descripcion', 'Descripción')
                ->display_as('cod_estado', 'Estado')
                ->required_fields('cod_nombre', 'cod_estado')
                ->set_rules('cod_nombre', 'Nombre', 'trim|required|campo_unico[cod_condicion.cod_nombre]')
                ->field_type('cod_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('cod_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                ->field_type('cod_usu_crea', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('cod_fecha_crea', 'hidden', date('Y-m-d H:i:s'))
            ;

            $crud->add_fields('cod_nombre', 'cod_descripcion', 'cod_usu_crea', 'cod_usu_mod', 'cod_fecha_crea', 'cod_fecha_mod', 'cod_estado');
            $crud->edit_fields('cod_nombre', 'cod_descripcion', 'cod_usu_mod', 'cod_fecha_mod', 'cod_estado');

            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('cod_estado', 'hidden', 1);
            } else {  // Editar
                $crud->field_type('cod_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            // Administrar Permisos. Agregado por Luis Navarro
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if ($permisos['permite_ver']) {
                $data_url = $this->masterpage->getUsuario();
                $url_read = $data_url['modulo'] . '/' . $data_url['control'] . '/' . $data_url['funcion'];
                $crud->add_action('Ver', 'minia-icon-search', $url_read . "/read");
            }

            $data['titulo_personal'] = "Condiciones";

            $output = $crud->render();
            $this->_cargarvista($data, $output);
        }
    }

    /**
     * ====================
     * @Autor: CHRISTIAN
     * ===================
     * */
    function vendedores($modulo = NULL)
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {

            $crud = new grocery_CRUD();
            $permisos = $this->gsatelite->get_permisos_opcion();
            $crud->set_table('ven_vendedor')
                //->set_subject('Vendedor')
                ->set_subject('')
                ->columns('ven_id', 'ven_codigo', 'ven_nombre', 'ven_apellidos', 'ven_estado')
                ->display_as('ven_id', 'ID')
                ->display_as('ven_nombre', 'Nombre')
                ->display_as('ven_apellidos', 'Apellido')
                ->display_as('ven_estado', 'Estado')
                ->unset_delete()
                ->unset_edit()
                ->unset_add()
            ;
            // Validar permisos para editar. Agregado por Luis Navarro
            if ($permisos['permite_editar']) {
                if ($modulo == 'facturacion') {
                    $crud->add_action('Editar', '', 'facturacion/entradas/editar_vendedores', 'icomoon-icon-pencil-5');
                } else {
                    $crud->add_action('Editar', '', 'cotizaciones/mantenimientos/editar_vendedores', 'icomoon-icon-pencil-5');
                }
            }

            //->add_action('Contactos', '','cotizaciones/mantenimientos/contactos/','icomoon-icon-user')


            /*
              ->field_type('cod_usu_mod', 'hidden', $this->tank_auth->get_user_id())
              ->field_type('cod_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
              ->field_type('cod_usu_crea','hidden', $this->tank_auth->get_user_id())
              ->field_type('cod_fecha_crea','hidden', date('Y-m-d H:i:s'))
              ; */
            /*
              $crud->add_fields('cod_nombre','cod_descripcion','cod_usu_crea','cod_usu_mod','cod_fecha_crea','cod_fecha_mod','cod_estado');
              $crud->edit_fields('cod_nombre','cod_descripcion','cod_usu_mod','cod_fecha_mod','cod_estado');
             */
            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('ven_estado', 'hidden', 1);
            } else {  // Editar
                $crud->field_type('ven_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }
            // Administrar Permisos. Agregado por Luis Navarro
            $data['permisos'] = $permisos;
            $data['titulo_personal'] = "Vendedores";


            $output = $crud->render();
            $this->_cargarvista($data, $output);
        }
    }

    /**
     * ====================
     * @Autor: CHRISTIAN
     * ===================
     * */
    public function extraerUsuarios($value = '')
    {
        $id_usuario = $this->input->post('idp');
        // vAlidar si es un Vendedor
        $vendedor = $this->gsatelite->get_tabla('ven_vendedor', array('ven_id_usu' => $id_usuario));
        if (count($vendedor) > 0) {
            $vendedor = "<input type='hidden' id='error_usuario_validacion' name='error_usuario_validacion' value=1>";
        } else {
            $vendedor = "<input type='hidden' id='error_usuario_validacion' name='error_usuario_validacion' value=0>";
        }
        // Obtener los datos del empleado
        //$empleados = $this->gsatelite->get_tabla('emp_empleado', array('emp_id_usu' => $id_usuario));
        $registro_usu = $this->gsatelite->get_registro('users', array('id' => $id_usuario));
        $empleados = $this->gsatelite->get_tabla('emp_empleado', array('emp_id' => $registro_usu->usu_id_emp));

        if (!empty($empleados)) {
            //$cadena="";
            $cod_empleado = "";
            $nombre_empleado = "";
            $apellido_empleado = "";
            $email_empleado = "";
            foreach ($empleados as $key => $value) {
                $this->db->limit(1);
                $this->db->order_by('cxp_id', 'ASC');
                $email = $this->gsatelite->get_registro('cxp_correoxempleado', array('cxp_id_emp' => $empleados[0]['emp_id']));

                //die(print_r($email));
                $cod_empleado .= "<input type='text' id='codigo_vendedor' name='codigo_vendedor' value='" . $value['emp_codigo'] . "' >
                    <input type='hidden' id='hdn_codigo_vendedor' name='hdn_codigo_vendedor' value='" . $value['emp_codigo'] . "' >";
                $nombre_empleado .= "<input type='text' id='nombre' name='nombre' value='" . $value['emp_nombre'] . "' disabled='true'>
                    <input type='hidden' id='nombre' name='nombre' value='" . $value['emp_nombre'] . "' >";
                $apellido_empleado .= "<input type='text' id='apellido' name='apellido' value='" . $value['emp_apellido'] . "' disabled='true'>
                     <input type='hidden' id='apellido' name='apellido' value='" . $value['emp_apellido'] . "' >";
                $disabled = (empty($email)) ? '>' : '><input type="hidden" id="hdn_email" name="hdn_email" value="' . $email->cxp_correo . '" >';
                $email_empleado .= "<input type='email' id='email' name='email' value='" . $email->cxp_correo . "' " . $disabled;
                //<input type="text" class="fecha" id="e-mail" name="e-mail" value="">
            }
            //die(print_r($cod_empleado,TRUE));
            echo json_encode(array('codigo' => $cod_empleado, 'vendedor' => $vendedor, 'nombre' => $nombre_empleado, 'apellido' => $apellido_empleado, 'email' => $email_empleado,));
        } else {
            echo json_encode(array('codigo' => "<input type='text' id='codigo_vendedor' name='codigo_vendedor' value='No existe codigo ' disabled='true' >", 'nombre' => "<input type='text' id='nombre' name='nombre' value='No existe nombre' disabled='true'>", 'apellido' => "<input type='text' id='apellido' name='apellido' value='No existe apellido' disabled='true'>", 'email' => "<input type='text' id='email' name='email' value='No existe email ' disabled='true'>"));
        }
    }

    function ingresar_vendedores($modulo = NULL, $ruta_vista = null)
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $ruta_vista  = (substr_count($ruta_vista, '/') > 1) ? $ruta_vista : 'cotizaciones/mantenimientos/ingresar_vendedores';
            $arreglo_url = explode('/', $ruta_vista);
            $modulo_url  = $arreglo_url[0] . '/' . $arreglo_url[1];
            $data['modulo_url'] = $modulo_url;

            $this->db->join("emp_empleado", "emp_id_usu = id");
            $data['usuarios_act'] = $this->gsatelite->get_tabla('users');
            $data['supervisores'] = $this->gsatelite->get_dropdown('sup_supervisor', '{sup_nombre} {sup_apellido}', '', array('sup_estado' => 1), null, '', 'sup_id', true);
            if ($_POST) {
                // var_dump($_POST);die();
                // Validaciones
                $usuario  = (is_numeric($this->input->post('usuario')) && intval($this->input->post('usuario')) > 0) ? $this->input->post('usuario') : null;
                $codigo_vendedor = (trim($this->input->post('codigo_vendedor')) != "") ? $this->input->post('codigo_vendedor') : null;
                $nombre   = (trim($this->input->post('nombre')) != "") ? $this->input->post('nombre') : null;
                $apellido = (trim($this->input->post('apellido')) != "") ? $this->input->post('apellido') : null;
                $email    = (trim($this->input->post('email')) != "") ? $this->input->post('email') : null;
                $telefono = (trim($this->input->post('telefono')) != "") ? $this->input->post('telefono') : null;

                $array_vendendor = array(
                    'ven_id_usu'        => $usuario,
                    'ven_codigo'        => $codigo_vendedor,
                    'ven_nombre'        => $nombre,
                    'ven_apellidos'     => $apellido,
                    'ven_meta_cotizado' => NULL,
                    'ven_meta_ventas'   => NULL,
                    'ven_numero_visitas' => NULL,
                    'ven_telefono'      => $telefono,
                    'ven_email'         => $email,
                    'ven_estado'        => 1,
                    'ven_usu_mod'       => $this->tank_auth->get_user_id(),
                    'ven_fecha_mod'     => date('Y-m-d H:i:s'),
                );
                // var_dump($array_vendendor);die();
                $contrato_id = $this->gsatelite->ingresar('ven_vendedor', $array_vendendor);
                $supervisor = $this->input->post('supervisor');

                //for de ingreso de supervisores
                foreach ($supervisor as $key => $value) {
                    $ingresarSup[] = array('vxs_id_sup' => $supervisor[$key], 'vxs_id_ven' => $contrato_id);
                    $this->gsatelite->ingresar('vxs_vendedorxsupervisor', $ingresarSup[$key]);
                }

                // Datos de las metas
                $metas_mes      = (is_array($this->input->post("metas_mes")) && count($this->input->post("metas_mes")) > 0) ? $this->input->post("metas_mes") : array();
                $metas_fecha_   = (is_array($this->input->post("metas_fecha_")) && count($this->input->post("metas_fecha_")) > 0) ? $this->input->post("metas_fecha_") : array();
                $metas_venta    = (is_array($this->input->post("metas_venta")) && count($this->input->post("metas_venta")) > 0) ? $this->input->post("metas_venta") : array();
                $metas_cot      = (is_array($this->input->post("metas_cot")) && count($this->input->post("metas_cot")) > 0) ? $this->input->post("metas_cot") : array();
                $visita_cliente = (is_array($this->input->post("visita_cliente")) && count($this->input->post("visita_cliente")) > 0) ? $this->input->post("visita_cliente") : array();

                //Se Agregara los datos de las metas
                for ($x = 0; $x < count($metas_mes); $x++) {
                    if (trim($metas_mes[$x]) != "") {
                        $guardar_metas = array(
                            'mtv_id_ven'            => $contrato_id,
                            'mtv_periodo'           => formatear_fecha('Y-m-d', $metas_fecha_[$x]),
                            'mtv_visita_cliente'    => intval($visita_cliente[$x]),
                            'mtv_meta_venta'        => floatval($metas_venta[$x]),
                            'mtv_meta_cotizacion'   => floatval($metas_cot[$x]),
                            'mtv_estado'            => 1,
                            'mtv_usu_creacion'      => $this->tank_auth->get_user_id(),
                            'mtv_fecha_creacion'    => date('Y-m-d H:i:s'),
                            'mtv_usu_modificacion'  => $this->tank_auth->get_user_id(),
                            'mtv_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('mtv_meta_vendedor', $guardar_metas);
                    }
                }

                // Mostrar alerta
                if ($contrato_id > 0) {
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Ingreso de contrato", 'texto_alerta' => "El registro se guardó correctamente.");
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Ingreso de contrato", 'texto_alerta' => "El registro no se guardó.");
                }

                $this->session->set_flashdata($alerta);
                $redireccion = $this->input->post("redireccion");
                $modulo_url_redir = $this->input->post("modulo");
                if ($redireccion == 1) {
                    redirect($modulo_url_redir . '/ingresar_vendedores');
                } else if ($redireccion == 2) {
                    redirect($modulo_url_redir . '/vendedores');
                }
                die();
            } else {
                $data['titulo_personal'] = "Agregar vendedor";
                cargarvista($data, 0, 'cotizaciones/mantenimientos/ingresar_vendedores');
            }
        }
    }

    /*
      public function validar_vendedor($str)
      {

      $id=  end(explode("/",uri_string()));
      if(is_numeric($id) )
      {
      $username_old = $this->db->where("ven_id",$id)->get('ven_vendedor')->row()->mep_nombre;
      $num_row = $this->db->where('ven_codigo',$str)->where('ven_id !=',$id)->get('ven_vendedor')->num_rows();
      if ($num_row >= 1)
      {
      $this->form_validation->set_message('validar_vendedor', 'El código del vendedor ya existe');
      return false;
      }
      else
      {
      return TRUE;
      }
      }
      else{
      $num_row = $this->db->where('ven_codigo',$str)->get('ven_vendedor')->num_rows();
      if ($num_row >= 1)
      {
      $this->form_validation->set_message('validar_vendedor', 'El código del vendedor ya existe');
      return FALSE;
      }
      else
      {
      return TRUE;
      }
      }
      } */

    /**
     * ====================
     * @Autor: CHRISTIAN
     * ===================
     * */
    function editar_vendedores($id_vendedor, $ruta_vista = NULL)
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $ruta_vista  = (substr_count($ruta_vista, '/') > 1) ? $ruta_vista : 'cotizaciones/mantenimientos/editar_vendedores';
            $arreglo_url = explode('/', $ruta_vista);
            $modulo_url  = $arreglo_url[0] . '/' . $arreglo_url[1];
            $data['modulo_url'] = $modulo_url;
            if ($_POST) {
                //print_r($_POST);die();
                $id_vendedor = $this->input->post('id_vendedor');

                $meta_venta = $this->input->post('meta_mensual_ventas');
                if ($meta_venta != '') {
                    $meta_venta = $this->input->post('meta_mensual_ventas');
                } else {
                    $meta_venta = NULL;
                }

                // Validaciones
                $usuario    = ($this->input->post('usuario') != '') ? $this->input->post('usuario') : null;
                $codigo_vendedor = (trim($this->input->post('codigo_vendedor')) != "") ? $this->input->post('codigo_vendedor') : null;
                $nombre     = (trim($this->input->post('nombre')) != "") ? $this->input->post('nombre') : null;
                $apellido   = (trim($this->input->post('apellido')) != "") ? $this->input->post('apellido') : null;
                $email      = (trim($this->input->post('email')) != "") ? $this->input->post('email') : null;
                $telefono   = (trim($this->input->post('telefono')) != "") ? $this->input->post('telefono') : null;
                $estado     = (trim($this->input->post('estado')) != "") ? $this->input->post('estado') : 0;

                $array_vendendor = array(
                    'ven_id_usu'    => $usuario,
                    'ven_codigo'    => $codigo_vendedor,
                    'ven_nombre'    => $nombre,
                    'ven_apellidos' => $apellido,
                    'ven_meta_cotizado' => null,
                    'ven_meta_ventas'   => null,
                    'ven_numero_visitas' => NULL,
                    'ven_telefono'  => $telefono,
                    'ven_email'     => $email,
                    'ven_estado'    => $estado,
                    'ven_usu_mod'   => $this->tank_auth->get_user_id(),
                    'ven_fecha_mod' => date('Y-m-d H:i:s'),
                );

                $contrato_id = $this->gsatelite->actualizar_array('ven_vendedor', $array_vendendor, array('ven_id' => $id_vendedor));

                //borrar supervisores actuales
                $this->gsatelite->borrado_general('mtv_meta_vendedor', array('mtv_id_ven' => $id_vendedor));
                // Datos de las metas del vendedor
                $metas_mes      = (is_array($this->input->post("metas_mes")) && count($this->input->post("metas_mes")) > 0) ? $this->input->post("metas_mes") : array();
                $metas_fecha_   = (is_array($this->input->post("metas_fecha_")) && count($this->input->post("metas_fecha_")) > 0) ? $this->input->post("metas_fecha_") : array();
                $metas_venta    = (is_array($this->input->post("metas_venta")) && count($this->input->post("metas_venta")) > 0) ? $this->input->post("metas_venta") : array();
                $metas_cot      = (is_array($this->input->post("metas_cot")) && count($this->input->post("metas_cot")) > 0) ? $this->input->post("metas_cot") : array();
                $visita_cliente = (is_array($this->input->post("visita_cliente")) && count($this->input->post("visita_cliente")) > 0) ? $this->input->post("visita_cliente") : array();

                //Se Agregara los datos de las metas
                for ($x = 0; $x < count($metas_mes); $x++) {
                    if (trim($metas_mes[$x]) != "") {

                        $guardar_metas = array(
                            'mtv_id_ven'            => $id_vendedor,
                            'mtv_periodo'           => formatear_fecha('Y-m-d', $metas_fecha_[$x]),
                            'mtv_visita_cliente'    => intval($visita_cliente[$x]),
                            'mtv_meta_venta'        => floatval($metas_venta[$x]),
                            'mtv_meta_cotizacion'   => floatval($metas_cot[$x]),
                            'mtv_estado'            => 1,
                            'mtv_usu_creacion'      => $this->tank_auth->get_user_id(),
                            'mtv_fecha_creacion'    => date('Y-m-d H:i:s'),
                            'mtv_usu_modificacion'  => $this->tank_auth->get_user_id(),
                            'mtv_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('mtv_meta_vendedor', $guardar_metas);
                    }
                }

                //borrar supervisores actuales
                $this->gsatelite->borrado_general('vxs_vendedorxsupervisor', array('vxs_id_ven' => $id_vendedor));
                //capturar nuevos supervisores
                $supervisor = $this->input->post('supervisor');
                //for de ingreso de supervisores
                foreach ($supervisor as $key => $value) {

                    $ingresarSup[] = array('vxs_id_sup' => $supervisor[$key], 'vxs_id_ven' => $id_vendedor);
                    $respuesta = $this->gsatelite->ingresar('vxs_vendedorxsupervisor', $ingresarSup[$key]);
                }

                // Alcamenado de las Obligaciones
                // Mostrar alerta
                if ($contrato_id > 0) {
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Ingreso de Vendedor", 'texto_alerta' => "El registro se actualizó correctamente.");
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Ingreso de Vendedor", 'texto_alerta' => "El registro no se actualizó.");
                }

                $this->session->set_flashdata($alerta);
                $modulo = $this->input->post('modulo');
                $redireccion = $this->input->post("redireccion");
                if ($redireccion == 1) {
                    redirect($modulo . '/editar_vendedores/' . $id_vendedor);
                } else if ($redireccion == 2) {
                    redirect($modulo . '/vendedores');
                }
                die();
            } else {
                // mostrar  informacion
                $data['id_vendedor'] = $id_vendedor;
                // Datos del Vendedor
                $data['vendedor'] = $this->cotizaciones_model->get_vendedorxempleado(array('ven_id' => $id_vendedor));
                // print_r($data['vendedor']);die();
                $this->db->join("emp_empleado", "usu_id_emp = emp_id");
                $select = $this->gsatelite->get_dropdown('users', '{emp_nombre} {emp_apellido}', '', array(), $data['vendedor'][0]['id'], '', 'id', true);
                $data['usuario'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $select);

                // Obtener todas las metas del vendedor
                $data['metas'] = $this->gsatelite->get_tabla('mtv_meta_vendedor', array('mtv_id_ven' => $id_vendedor));
                //preguntar supervisores
                $supxvendedor = $this->gsatelite->get_tabla('vxs_vendedorxsupervisor', array('vxs_id_ven' => $id_vendedor));
                //mostrar arreglo de supervisores
                $supervSelec = array();
                foreach ($supxvendedor as $key => $value) {
                    $supervSelec[] = $value['vxs_id_sup'];
                }
                $data['supervisores'] = $this->gsatelite->get_dropdown('sup_supervisor', '{sup_nombre} {sup_apellido}', '', array('sup_estado' => 1), $supervSelec, '', 'sup_id', true);
                $data['titulo_personal'] = "Editar vendedor";
                cargarvista($data, 0, 'cotizaciones/mantenimientos/editar_vendedores');
            }
        }
    }

    function contactos_iframe($id_cliente, $flag_mod = 1)
    {
        //satelite_validar();
        if (!isset($id_cliente))
            $id_cliente = 0;

        $crud = new grocery_CRUD();

        $this->load->config('grocery_crud');
        $permisos = $this->gsatelite->get_permisos_opcion('cotizaciones/mantenimientos/clientes');
        //Columnas a mostrar en READ
        $columns = array(
            'con_nombre',
            'con_apellidos',
            'con_cargo',
            'con_telefono',
            'con_email'
        );

        //Alias para las columnas
        $alias = array(
            'con_nombre' => 'Nombre',
            'con_apellidos' => 'Apellidos',
            'con_email' => 'E-mail',
            'con_cargo' => 'Cargo',
            'con_telefono' => 'Teléfono'
        );

        //Columnas a mostrar en ADD
        $add_columns = array(
            'con_id_cli',
            'con_nombre',
            'con_apellidos',
            'con_cargo',
            'con_telefono',
            'con_email',
            'con_estado',
            'con_fecha_mod',
            'con_usu_mod'
        );

        //Columnas a mostrar en EDIT
        $edit_columns = $add_columns;

        $required_fields = array('con_nombre', 'con_apellidos', 'con_cargo', 'con_estado');

        $crud->set_table('con_contacto')
            //->set_subject('Contacto')
            ->set_subject('')
            ->where('con_estado <>', -1)
            ->where('con_id_cli', $id_cliente)
            //->unset_delete()
            ->columns($columns)
            ->display_as($alias)
            ->add_fields($add_columns)
            ->edit_fields($edit_columns)
            ->required_fields($required_fields)
            //->field_type('con_estado','dropdown',array('1' => 'Activado', '0' => 'Desactivado'))
            ->field_type('con_id_cli', 'hidden', $id_cliente)
            ->field_type('con_estado', 'hidden', 1)
            ->field_type('con_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
            ->field_type('con_usu_mod', 'hidden', $this->tank_auth->get_user_id())
            ///->set_rules('con_telefono', 'con_telefono', 'callback_validar_telefono')
            //->set_rules('con_email', 'Email', 'valid_email|callback_validar_telefono')
            ->unset_export()
            ->unset_print()
            //->callback_after_insert(array($this, 'validar_email_telefono'))
        ;

        $datos = $this->gsatelite->get_tabla("con_contacto", array("con_id_cli" => $id_cliente, "con_estado" => 1));
        $contador = 0;
        foreach ($datos as $key => $value) {
            $contador++;
        }

        $data['n_val'] = $contador;
        $output = $crud->render();
        $data['esmodal'] = ($flag_mod == null || $flag_mod == 1) ? true : false;
        $data['noreturn'] = 1;
        $output = array_merge($data, (array) $output);
        //$this->_cargarvista(null,$output);
        $this->gsatelite->cargar_vista_masterpage('cotizaciones/mantenimientos/contactos', $output);
    }

    function validar_telefono($value, $row)
    {
        /* $telefono = $this->input->post('con_telefono');
          $telefono = $row->con_telefono;
          $email = $this->input->post('con_email');
          $email = $row->con_email; */
        $this->form_validation->set_message('validar_telefono', 'El campo Telefono o Email es obligatorio');
        /* if($telefono != "" && $email != ""){
          return TRUE;
          } else {
          $this->form_validation->set_message('validar_email_telefono','El campo Telefono o Email es obligatorio');
          return FALSE;
          } */
        return FALSE;
    }

    /**
     * ====================
     * @Autor: CHRISTIAN
     * ===================
     * */
    // public function ingresarEdicionVendedores() {
    //     if (!$this->tank_auth->is_logged_in()) {
    //         redirect('/auth/login/');
    //     } else {
    //         if ($_POST) {
    //             //die(print_r($_POST));
    //             $id_vendedor = $this->input->post('id_vendedor');

    //             $meta_venta = $this->input->post('meta_mensual_ventas');
    //             if ($meta_venta != '') {
    //                 $meta_venta = $this->input->post('meta_mensual_ventas');
    //             } else {
    //                 $meta_venta = NULL;
    //             }
    //             //die(print_r($meta_venta));
    //             $array_vendendor = array(
    //                 'ven_id_usu' => $this->input->post('usuario'),
    //                 'ven_codigo' => $this->input->post('codigo_vendedor'),
    //                 'ven_nombre' => $this->input->post('nombre'),
    //                 'ven_apellidos' => $this->input->post('apellido'),
    //                 'ven_meta_cotizado' => (!empty($_POST['meta_mensual_cotizaciones']) ) ? $_POST['meta_mensual_cotizaciones'] : null,
    //                 'ven_meta_ventas' => (!empty($_POST['meta_mensual_ventas']) ) ? $_POST['meta_mensual_ventas'] : null,
    //                 'ven_numero_visitas' => (!empty($_POST['visitas_clientes'])) ? $_POST['visitas_clientes'] : NULL,
    //                 'ven_telefono' => $this->input->post('telefono'),
    //                 'ven_email' => $this->input->post('email'),
    //                 'ven_estado' => (!empty($_POST['estado'])) ? 1 : $_POST['estado'],
    //                 'ven_usu_mod' => $this->tank_auth->get_user_id(),
    //                 'ven_fecha_mod' => date('Y-m-d H:i:s'),
    //             );

    //             //die(print_r($array_vendendor,true));

    //             $contrato_id = $this->gsatelite->actualizar_array('ven_vendedor', $array_vendendor, array('ven_id' => $id_vendedor));

    //             //borrar supervisores actuales
    //             $this->gsatelite->borrado_general('vxs_vendedorxsupervisor', array('vxs_id_ven' => $id_vendedor));

    //             //capturar nuevos supervisores
    //             $supervisor = $this->input->post('supervisor');

    //             //for de ingreso de supervisores
    //             foreach ($supervisor as $key => $value) {

    //                 $ingresarSup[] = array('vxs_id_sup' => $supervisor[$key], 'vxs_id_ven' => $id_vendedor);

    //                 $respuesta = $this->gsatelite->ingresar('vxs_vendedorxsupervisor', $ingresarSup[$key]);
    //             }

    //             // Alcamenado de las Obligaciones
    //             // Mostrar alerta
    //             if ($contrato_id > 0) {
    //                 $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Ingreso de contrato", 'texto_alerta' => "El registro se guardó correctamente.");
    //             } else {
    //                 $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Ingreso de contrato", 'texto_alerta' => "El registro no se guardó.");
    //             }

    //             $this->session->set_flashdata($alerta);
    //             if ($_POST['facturacion'])
    //                 $this->gsatelite->show_dialog('El registro se editó correctamente', "facturacion/entradas/vendedores");
    //             redirect('/cotizaciones/mantenimientos/vendedores');
    //         } else {
    //             //$data['departamentos'] = $this->gsatelite->get_dropdown('dep_departamento', '{dep_nombre}','', array('dep_estado' => '1'), null, '', 'dep_id', true);
    //             //$data['proveedores'] = $this->gsatelite->get_dropdown('prv_proveedor', '{prv_nombre} {prv_apellido}','', array('prv_estado' => '1'), null, '', 'prv_id', true);

    //             $data['titulo_personal'] = "Editar vendedor";
    //             $this->_cargarvista($data);
    //         }
    //     }
    // }

    //funcion para cambiar el estado cuando se elimina un registro cambia estadao a -1
    public function estado($id = '')
    {

        $tabl = $this->input->get();
        if ($tabl != NULL) {
            //print_r(" sshahjsa,shakas") ; die();

            $tabl = $this->input->get();
            $tr = implode($tabl);
            $tc = explode('?', $tr);
            $tab = $tc[0];
            $url = $tc[1];


            //print_r($id);

            $url2 = explode('/', $url);

            $uri = $url2[0];
            //print_r($uri); die();


            $id = end(explode("/", $_SERVER['REQUEST_URI']));
            $this->proceso_model->set_estado($id, $tab);
        }

        if ($id != null) {

            if ($id == ini) {
                //Obtiendo el parametro de edicion de la URL

                $campana_id = end(explode("/", $_SERVER['REQUEST_URI']));
                //$this->proceso_model->set_estado($id, $tab);
                //print_r($campana_id);  die();

                redirect('cotizaciones/mantenimientos/estado/' . $campana_id);
            } else {

                //print_r($tabl);   die();
                //print_r($campana_id); die();

                redirect('cotizaciones/mantenimientos/' . $uri . '/' . $campana_id);
            }
        } else {
            redirect('cotizaciones/mantenimientos/' . $uri . '/' . $campana_id);
        }
    }

    function contactos($id_cliente) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            try {
                if (!isset($id_cliente))
                    $id_cliente = 0;
                $crud = new grocery_CRUD();
                $permisos = $this->gsatelite->get_permisos_opcion('cotizaciones/mantenimientos/clientes');
                //Columnas a mostrar en READ
                $columns = array(
                    'con_nombre',
                    'con_apellidos',
                    'con_cargo',
                    'con_telefono',
                    'con_email',
                    'con_estado',
                );

                //Alias para las columnas
                $alias = array(
                    'con_nombre' => 'Nombre',
                    'con_apellidos' => 'Apellidos',
                    'con_email' => 'E-mail',
                    'con_estado' => 'Estado',
                    'con_id_tit' => 'Tipo Teléfono',
                    'con_cargo' => 'Cargo',
                    'con_telefono' => 'Teléfono',
                    'con_titulo_profesion' => 'Titulo o Profesión'
                );


                //Columnas a mostrar en ADD
                $add_columns = array(
                    'con_id_cli',
                    'con_titulo_profesion',
                    'con_nombre',
                    'con_apellidos',
                    'con_cargo',
                    'con_telefono',
                    'con_id_tit',
                    'con_email',
                    'con_estado',
                    'con_fecha_mod',
                    'con_usu_mod',
                );

                //Columnas a mostrar en EDIT
                $edit_columns = $add_columns;

                $required_fields = array(
                    'con_nombre',
                    'con_estado',
                );

                $crud->set_table('con_contacto')
                    //->set_subject('Contacto')
                    ->set_subject('')
                    ->where('con_estado <>', -1)
                    ->where('con_id_cli', $id_cliente)
                    ->unset_delete()
                    ->columns($columns)
                    ->display_as($alias)
                    ->add_fields($add_columns)
                    ->edit_fields($edit_columns)
                    ->set_rules('con_email', 'Email', 'valid_email')
                    ->required_fields($required_fields)

                    ->set_relation('con_id_tit', 'tit_tipo_telefono', 'tit_nombre', array('tit_estado' => 1))
                    //->add_action('Borrar', '', 'cotizaciones/mantenimientos/estado/ini?t=con_contacto?contactos',' icomoon-icon-remove')
                    ->field_type('con_id_cli', 'hidden', $id_cliente)
                    ->field_type('con_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                    ->field_type('con_usu_mod', 'hidden', $this->tank_auth->get_user_id());
                if (end(explode('/', uri_string())) == 'add') {
                    $crud->field_type('con_estado', 'hidden', 1);
                } else {
                    $crud->field_type('con_estado', 'dropdown', array('1' => 'Activado', '0' => 'Desactivado'));
                }
                $datos = $this->gsatelite->get_tabla("con_contacto", array("con_id_cli" => $id_cliente, "con_estado" => 1));
                $contador = 0;
                foreach ($datos as $key => $value) {
                    $contador++;
                }
                $data['n_val'] = $contador;
                $data['datos_cliente'] = $this->gsatelite->get_registro('cli_cliente', 'cli_id', $id_cliente);
                $output = $crud->render();
                $data['titulo_personal'] = "Contactos"; # Antonio
                $data['esmodal'] = 0;
                $this->_cargarvista($data, $output);
            } catch (Exception $e) {
                show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
            }
        }
    }

    /**
     * @author Melbin Cruz
     * @return Mantenimiento documentos por cliente
     */
    function documentos_cliente_crud($id_cliente = null)
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            try {
                $crud = new grocery_CRUD();
                $this->load->config('grocery_crud');
                $this->config->set_item('grocery_crud_file_upload_allow_file_types', 'pdf|jpeg|jpg|png');

                $crud->set_table('dcc_documento_cliente')
                    //->set_subject('Documento')
                    ->set_subject('')
                    ->where('dcc_id_cli', $id_cliente)
                    ->columns('dcc_id_tde', 'dcc_valor', 'dcc_fecha_vence', 'dcc_fecha_expedicion', 'dcc_lugar_expedicion', 'dcc_url')
                    ->set_relation('dcc_id_tde', 'tde_tipo_documento', 'tde_nombre', array('tde_estado' => 1))
                    ->add_fields('dcc_id_tde', 'dcc_id_cli', 'dcc_estado', 'dcc_valor', 'dcc_fecha_vence', 'dcc_fecha_expedicion', 'dcc_lugar_expedicion', 'dcc_url', 'dcc_nombre_anexo', 'dcc_usu_mod', 'dcc_fecha_mod', 'dcc_usu_crea', 'dcc_fecha_crea')
                    ->edit_fields('dcc_id_tde', 'dcc_id_cli', 'dcc_valor', 'dcc_fecha_vence', 'dcc_fecha_expedicion', 'dcc_lugar_expedicion', 'dcc_url', 'dcc_nombre_anexo', 'dcc_usu_mod', 'dcc_fecha_mod', 'dcc_usu_crea', 'dcc_fecha_crea')
                    ->display_as('dcc_id_tde', 'Documento')
                    ->display_as('dcc_valor', 'Valor')
                    ->display_as('dcc_fecha_vence', 'Vence')
                    ->display_as('dcc_fecha_expedicion', 'Fecha Expedición')
                    ->display_as('dcc_lugar_expedicion', 'Lugar Expedición')
                    ->display_as('dcc_url', 'Anexo')
                    ->display_as('dcc_nombre_anexo', 'Titulo Anexo')
                    ->required_fields('dcc_valor', 'dcc_id_tde')
                    ->set_rules('dcc_valor', 'Valor', 'trim|required|campo_unico[dcc_documento_cliente.dcc_valor]')
                    ->set_rules('dcc_id_tde', 'Documento', "trim|required|campo_unico2[dcc_documento_cliente.dcc_id_tde.dcc_id_cli.$id_cliente]")
                    // ->set_rules('dcc_id_tde', 'Documento', 'required|callback_validar_tipo')
                    ->field_type('dcc_id_cli', 'hidden', $id_cliente)
                    ->field_type('dcc_estado', 'hidden', 1)
                    ->field_type('dcc_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('dcc_usu_crea', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('dcc_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                    ->field_type('dcc_fecha_crea', 'hidden', date('Y-m-d H:i:s'))
                    ->set_field_upload('dcc_url', 'uploads/anexos_cliente')
                    ->callback_before_insert(function ($post_array, $primary_key) {
                        if ($post_array['dcc_fecha_vence'] != "") {
                            //$fecha = strstr($post_array['dcc_fecha_vence'], ' ', true);

                            $post_array['dcc_fecha_vence'] = implode('-', array_reverse(explode('-', $post_array['dcc_fecha_vence'])));
                        }
                        if ($post_array['dcc_fecha_expedicion'] != "") {
                            //$fecha_exp = strstr($post_array['dcc_fecha_expedicion'], ' ', true);
                            $post_array['dcc_fecha_expedicion'] = implode('-', array_reverse(explode('-', $post_array['dcc_fecha_expedicion'])));
                        }
                        return $post_array;
                    })
                    ->callback_before_update(function ($post_array, $primary_key) {
                        if ($post_array['dcc_fecha_vence'] != "") {
                            //$fecha = strstr($post_array['dcc_fecha_vence'], ' ', true);
                            $post_array['dcc_fecha_vence'] = implode('-', array_reverse(explode('-', $post_array['dcc_fecha_vence'])));
                        }
                        if ($post_array['dcc_fecha_expedicion'] != "") {
                            //$fecha_exp = strstr($post_array['dcc_fecha_expedicion'], ' ', true);
                            $post_array['dcc_fecha_expedicion'] = implode('-', array_reverse(explode('-', $post_array['dcc_fecha_expedicion'])));
                        }
                        return $post_array;
                    })
                    ->callback_column('dcc_fecha_vence', function ($value, $row) {
                        if ($value != "") {
                            $valor = strstr($value, ' ', true);
                            return implode('-', array_reverse(explode('-', $valor)));
                        } else {
                            return '';
                        }
                    })
                    ->callback_column('dcc_fecha_expedicion', function ($value, $row) {
                        if ($value != "") {
                            $valor = strstr($value, ' ', true);
                            return implode('-', array_reverse(explode('-', $valor)));
                        } else {
                            return '';
                        }
                    })
                    ->unset_print()
                    ->unset_export()
                ;
                //$crud->set_rules('dcc_id_tde', 'Documento', 'required|callback_validar_tipo');
                $datos = $this->gsatelite->get_tabla("dcc_documento_cliente", array("dcc_id_cli" => $id_cliente, "dcc_estado" => 1));
                $contador = 0;
                foreach ($datos as $key => $value) {
                    $contador++;
                }

                $data['n_val'] = $contador;

                //$crud->callback_before_insert(array($this, 'formatear_fechas'));
                $data['array_documento'] = $this->gsatelite->get_tabla("tde_tipo_documento");
                $data['id_cliente'] = $id_cliente;
                $output = $crud->render();
                $data['esmodal'] = true;
                $output = array_merge($data, (array) $output);
                $this->gsatelite->cargar_vista_masterpage('cotizaciones/mantenimientos/documentos_cliente', $output);
            } catch (Exception $e) {
                show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
            }
        }
    }

    public function validar_tipo($valor)
    {
        $post_array = $this->input->post();
        $tipo = $this->input->post('dcc_id_tde');
        $cliente = $this->input->post('dcc_id_cli');
        $this->form_validation->set_message('validar_tipo_documento', 'El %s seleccionado ya existe');
        return false;


        if (!is_numeric(end(explode('/', uri_string())))) {
            $where = array('dcc_id_tde' => $tipo, 'dcc_id_cli' => $cliente);
            $count = $this->gsatelite->count('dcc_documento_cliente', $where);
        } else {
            $id = end(explode('/', uri_string()));
            $where = 'dcc_id_tde  = "' . $tipo . '" AND dcc_id_cli = ' . $cliente . " AND dcc_id <> " . $id;
            $count = $this->gsatelite->count('dcc_documento_cliente', $where);
        }
        //print_r($this->db->last_query());
        //var_dump($count);
        //die();

        if ($count > 0) {
            $this->form_validation->set_message('validar_tipo_documento', 'El %s seleccionado ya existe');
            return false;
        } else {
            return true;
        }
    }

    function formatear_fechas($post_array)
    {

        if ($post_array['dcc_fecha_vence'] != "") {
            $post_array['dcc_fecha_vence'] = implode('-', array_reverse(explode('-', $post_array['dcc_fecha_vence'])));
        }
        if ($post_array['dcc_fecha_expedicion'] != "") {
            $post_array['dcc_fecha_expedicion'] = implode('-', array_reverse(explode('-', $post_array['dcc_fecha_expedicion'])));
        }
        return $post_array;
    }

    // Melbin Cruz
    function referencias_cliente_crud($id_cliente = null)
    {

        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            try {

                $crud = new grocery_CRUD();
                $this->load->config('grocery_crud');

                $crud->set_table('rfc_referencia_cliente')
                    //->set_subject('Referencias')
                    ->set_subject('')
                    ->where('rfc_referencia_cliente.rfc_id_cli', $id_cliente)
                    ->columns('rfc_nombre', 'rfc_tel_fijo', 'rfc_tel_movil', 'rfc_tipo', 'rfc_estado')
                    //->set_relation('rfc_tipo', 'tit_tipo_telefono', 'tit_nombre', array('tit_id >'=>0))
                    ->add_fields('rfc_id_cli', 'rfc_nombre', 'rfc_tel_fijo', 'rfc_tel_movil', 'rfc_tipo', 'rfc_estado', 'rfc_usu_mod', 'rfc_fecha_mod', 'rfc_usu_crea', 'rfc_fecha_crea')
                    ->edit_fields('rfc_id_cli', 'rfc_nombre', 'rfc_tel_fijo', 'rfc_tel_movil', 'rfc_tipo', 'rfc_estado', 'rfc_usu_mod', 'rfc_fecha_mod')
                    ->display_as('rfc_nombre', 'Nombre')
                    ->display_as('rfc_tel_fijo', 'Fijo')
                    ->display_as('rfc_tel_movil', 'Móvil')
                    ->display_as('rfc_tipo', 'Tipo')
                    ->display_as('rfc_estado', 'Estado')
                    ->required_fields('rfc_nombre', 'rfc_tipo', 'rfc_estado')
                    ->set_rules('rfc_tel_fijo', 'Fijo', "trim|campo_unico2[rfc_referencia_cliente.rfc_tel_fijo.rfc_id_cli.$id_cliente]")
                    ->set_rules('rfc_tel_movil', 'Móvil', "trim|campo_unico2[rfc_referencia_cliente.rfc_tel_movil.rfc_id_cli.$id_cliente]")
                    ->field_type('rfc_tipo', 'dropdown', array('1' => 'Personal', '2' => 'Laboral'))
                    ->field_type('rfc_estado', 'dropdown', array('1' => 'Activado', '0' => 'Desactivado'))
                    ->field_type('rfc_id_cli', 'hidden', $id_cliente)
                    ->field_type('rfc_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('rfc_usu_crea', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('rfc_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                    ->field_type('rfc_fecha_crea', 'hidden', date('Y-m-d H:i:s'))
                    ->unset_print()
                    ->unset_export()
                ;
                /* $existe=$this->cotizaciones_model->existeRegistroEtapa('vxs_vendedorxsupervisor','vxs_id_ven',$post_array['vxs_id_ven'],'vxs_id_sup',$post_array['vxs_id_sup'],0,0);
                  if ($existe > 0){ return FALSE;  }
                  else { return TRUE; }
                  }) */

                //$data['array_documento'] = $this->gsatelite->get_tabla("tde_tipo_documento");
                $datos = $this->gsatelite->get_tabla("rfc_referencia_cliente", array("rfc_id_cli" => $id_cliente, "rfc_estado" => 1));
                $contador = 0;
                foreach ($datos as $key => $value) {
                    $contador++;
                }
                $data['id_cliente'] = $id_cliente;
                $output = $crud->render();
                $data['esmodal'] = true;
                $data['n_val'] = $contador;
                $output = array_merge($data, (array) $output);
                $this->gsatelite->cargar_vista_masterpage('cotizaciones/mantenimientos/referencias_cliente_crud', $output);
                //return false;
            } catch (Exception $e) {
                show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
            }
        }
    }

    function medio_contacto()
    {
        satelite_validar();
        // Variable para permisos. Agregado por Luis Navarro
        $permisos = $this->gsatelite->get_permisos_opcion();
        $crud = new grocery_CRUD;
        $alias = array(
            'tmc_id' => 'ID',
            'tmc_nombre' => 'Nombre',
            'tmc_estado' => 'Estado'
        );
        $colums = array(
            'tmc_id',
            'tmc_nombre',
            'tmc_estado'
        );
        $edit = array(
            'tmc_nombre',
            'tmc_estado',
            'tmc_usu_modificacion',
            'tmc_fecha_modificacion'
        );
        $add = array(
            'tmc_nombre',
            'tmc_estado',
            'tmc_usu_creacion',
            'tmc_fecha_creacion',
            'tmc_usu_modificacion',
            'tmc_fecha_modificacion'
        );

        $crud->set_table('tmc_tipo_medio')
            ->set_subject('')
            ->display_as($alias)
            ->columns($colums)
            ->add_fields($add)
            ->edit_fields($edit)
            ->required_fields($add)
            ->field_type('tmc_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
            ->field_type('tmc_fecha_modificacion', 'hidden', date('Y-m-d h:i:s'))
            ->set_rules('tmc_nombre', 'Nombre', 'trim|required|campo_unico[tmc_tipo_medio.tmc_nombre]');
        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('tmc_estado', 'hidden', 1)
                ->field_type('tmc_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('tmc_fecha_creacion', 'hidden', date('Y-m-d h:i:s'));
        } else {
            $crud->field_type('tmc_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

        // Validar Permisos. Agregado por Luis Navarro
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }

        if (!$permisos['permite_editar']) {
            $crud->unset_edit();
        }

        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }


        $output = $crud->render();
        $data['titulo_personal'] = "Medio de contacto";
        $this->_cargarvista($data, $output);
    }

    function clientes($modal = 'no', $otro_modulo = null)
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            try {
                $permisos = $this->gsatelite->get_permisos_opcion();
                $datos = array();
                //preguntar si el usuario es supervisor o vendedor
                $condicion1 = array('sup_id_usu' => $this->tank_auth->get_user_id(), 'sup_estado' => 1);
                $esSup = $this->cotizaciones_model->Existe_Registro("sup_supervisor", $condicion1);
                $condicion2 = array('ven_id_usu' => $this->tank_auth->get_user_id(), 'ven_estado' => 1);
                $esVen = $this->cotizaciones_model->Existe_Registro("ven_vendedor", $condicion2);
                $urlx = explode('/', uri_string());
                $cli_id = end($urlx);
                if ($cli_id > 0) {
                    $datosCliente = $this->cotizaciones_model->get_registro('cli_cliente', 'cli_id', $cli_id);
                    $id_vendedor = $datosCliente->cli_id_ven;
                } else {
                    $id_vendedor = "0";
                }
                $crud = new grocery_CRUD();
                //Columnas a mostrar en READ
                $columns = array(
                    'cli_codigo',
                    'cli_nombre',
                    'cli_apellido',
                    'cli_direccion',
                    'Documento',
                    'Teléfono',
                    'Contacto',
                    'cli_email',
                    'cli_estado'
                );

                //Alias para las columnas
                $alias = array(
                    'cli_codigo' => 'Código',
                    'cli_nombre' => 'Razón comercial',
                    'cli_apellido' => 'Razón social',
                    'cli_email' => 'E-mail',
                    'cli_estado' => 'Estado',
                    'cli_personeria' => 'Personería',
                    'cli_observacion' => 'Observación',
                    'cli_sitio_web' => 'Sitio Web',
                    'cli_id_sec' => 'Sector',
                    'cli_id_cac' => 'Cartera',
                    'cli_id_ven' => 'Vendedor',
                    'cli_id_tmc' => 'Medio de contacto',
                    'cli_id_tpc' => 'Tipo de cliente',
                    'cli_direccion' => 'Direccion'
                );

                //Columnas a mostrar en ADD
                $add_columns = array(
                    'cli_personeria',
                    'cli_nombre',
                    'cli_apellido',
                    // 'cli_razon_comercial',
                    'cli_email',
                    'cli_observacion',
                    'cli_id_sec',
                    'cli_id_cac',
                    'cli_id_ven',
                    'cli_sitio_web',
                    'cli_id_tmc',
                    'cli_estado',
                    'cli_fecha_mod',
                    'cli_usu_mod',
                    'cli_id_tpc'
                );

                $required_fields = array(
                    'cli_apellido',
                    'cli_id_ven',
                    'cli_estado',
                    'cli_id_sec',
                    'cli_id_cac',
                    'cli_id_tmc',
                    'cli_personeria'
                );

                //Columnas a mostrar en EDIT
                $edit_columns = $add_columns;
                $crud->set_table('cli_cliente')
                    ->set_subject('')
                    ->where('cli_estado <>', -1)
                    ->unset_delete()
                    ->columns($columns)
                    ->display_as($alias)
                    ->edit_fields($edit_columns)
                    ->set_relation('cli_id_sec', 'sec_sector_cliente', 'sec_nombre')
                    ->set_relation('cli_id_tpc', 'tpc_tipo_cliente', 'tpc_nombre')
                    ->set_relation('cli_id_cac', 'cac_cartera_cliente', 'cac_nombre')
                    ->set_relation('cli_id_tmc', 'tmc_tipo_medio', 'tmc_nombre', array('tmc_estado' => 1))
                    //->unset_add()
                    ->field_type('cli_personeria', 'dropdown', array('1' => 'Natural', '2' => 'Jurídica'))
                    ->field_type('cli_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'))
                    ->set_rules('cli_email', 'Email', 'valid_email')
                    ->set_rules('cli_nombre', 'Nombre o Razón social', 'required')

                    /* ->set_rules('cli_id_ven','Vendedor','required')
                          ->set_rules('cli_estado','Estado','required')
                          ->set_rules('cli_id_sec','Sector','required')
                          ->set_rules('cli_id_cac','Cartera Cliente','required') */
                    ->required_fields($required_fields);

                $crud->callback_column('Documento', function ($value, $row) {
                    $cliente = $row->cli_id;
                    $getPersoneria = $this->gsatelite->get_tabla('cli_cliente', array('cli_id' => $cliente));
                    $getPersoneria = $getPersoneria[0]['cli_personeria'];
                    //QUEDO OBSOLETO ESTE PARAMETRO, porque si retorna un valor(revisar la BDD) deberia filtrar por el mismo, pero si se desea filtrar
                    //segun el tipo de personeria juridica se podria filtrar aunque si igual viene ese parametro no mostrara nada, asi que por eso.
                    //$tipo_documento =$this->gsatelite->get_parametro('SYS_TIPO_DOC');
                    $documento = $this->gsatelite->get_tabla('dcc_documento_cliente', array('dcc_id_cli' => $cliente, 'dcc_estado' => 1));
                    return (isset($documento[0]['dcc_valor'])) ? $documento[0]['dcc_valor'] : null;
                    // Codigo del funiconamiento anterior #27-08-18
                    //  $cliente = $row->cli_id;
                    //  $tipo_doc = $this->gsatelite->get_parametro('SYS_TIPO_DOC');
                    //  if ($tipo_doc == 0) {
                    //      $this->db->limit(1);
                    //      $doc = $this->gsatelite->get_tabla('dcc_documento_cliente', array('dcc_id_cli' => $cliente));
                    //  } else {
                    //      $doc = $this->gsatelite->get_tabla('dcc_documento_cliente', array('dcc_id_cli' => $cliente, 'dcc_id_tde' => $tipo_doc));
                    //  }
                    //  return (isset($doc[0]['dcc_valor'])) ? $doc[0]['dcc_valor'] : null;
                });

                $crud->callback_column('Contacto', function ($value, $row) {
                    $cliente = $row->cli_id;
                    $conta = $this->gsatelite->get_tabla('con_contacto', array('con_id_cli' => $cliente, 'con_estado' => 1));
                    if (count($conta) > 0) {
                        return $conta[0]['con_nombre'] . ' ' . $conta[0]['con_apellidos'];
                    } else {
                        return false;
                    }
                });


                $crud->callback_column('Teléfono', function ($value, $row) {
                    $cliente = $row->cli_id;
                    //txc_telefonoxcliente
                    $telefonos = $this->gsatelite->get_tabla('txc_telefonoxcliente', array('txc_id_cli' => $cliente));
                    //$telefonos=$this->cotizaciones_model->get_telxcliente($cliente);
                    if (count($telefonos) > 0) {
                        return $telefonos[0]['txc_numero'];
                    } else {
                        return null;
                    }
                });
                // ->add_action('Ver Cotizaciones', '', 'cotizaciones/cotizaciones/cotizacion_cliente','icomoon-icon-file')
                if ($otro_modulo == 'tarificador') {
                    //$crud->add_action('Contactos', base_url() . 'media/images/glyphicons-halflings.png', base_url() . 'cotizaciones/mantenimientos/contactos/','icomoon-icon-user');
                    if ($permisos['permite_editar']) {
                        $crud->add_action('Editar', '', 'tarificador/procesos/editar_cliente', 'icomoon-icon-pencil-5');
                    }
                    $crud->add_action('Productos por cliente', '', 'tarificador/procesos/producto_cliente', 'minia-icon-mobile');
                } elseif ($otro_modulo == 'cuentasxcobrar') {
                    //$crud->add_action('Contactos', base_url() . 'media/images/glyphicons-halflings.png', base_url() . 'cotizaciones/mantenimientos/contactos/','icomoon-icon-user');
                    if ($permisos['permite_editar']) {
                        $crud->add_action('Editar', '', 'tarificador/procesos/editar_cliente', 'icomoon-icon-pencil-5');
                    }
                    $crud->add_action('Productos por cliente', '', 'tarificador/procesos/producto_cliente', 'minia-icon-mobile');
                } elseif ($otro_modulo == 'facturacion') {
                    if ($permisos['permite_editar']) {
                        $crud->add_action('Editar', '', 'facturacion/entradas/editar_cliente', 'icomoon-icon-pencil-5');
                    }
                } elseif ($otro_modulo == 'produccion') {
                    $crud->add_action('Editar', '', 'proyectos/mantenimientos/editar_cliente', 'icomoon-icon-pencil-5');
                } elseif ($otro_modulo == 'modulo_cuentas_cobrar') {
                    if ($permisos['permite_agregar']) {
                        $data['agregar'] = true;
                    }
                    if ($permisos['permite_editar']) {
                        $crud->add_action('Editar', 'icomoon-icon-pencil-5', 'modulo_cuentas_cobrar/mantenimiento/editar_cliente');
                    }
                    //$crud->add_action('Servicio', ' icomoon-icon-cog-2', 'modulo_contratos/catalogos/servicioxcliente');
                } elseif ($otro_modulo == 'modulo_contratos') {
                    if ($permisos['permite_agregar']) {
                        $data['agregar'] = true;
                    }
                    if ($permisos['permite_editar']) {
                        $crud->add_action('Editar', 'icomoon-icon-pencil-5', 'modulo_contratos/catalogos/editar_cliente');
                    }
                    //$crud->add_action('Servicio', ' icomoon-icon-cog-2', 'modulo_contratos/catalogos/servicioxcliente');
                } elseif ($modal == 'no') {
                    $crud->add_action('Contactos', base_url() . 'media/images/glyphicons-halflings.png', base_url() . 'cotizaciones/mantenimientos/contactos/', 'icomoon-icon-user');
                    if ($permisos['permite_editar']) {
                        $crud->add_action('Editar', '', 'cotizaciones/mantenimientos/editar_cliente', 'icomoon-icon-pencil-5');
                    }
                    $crud->add_action('Proyectos', '', 'cotizaciones/mantenimientos/proyectos', ' icomoon-icon-notebook');
                    $crud->add_action('Sucursales', '', 'cotizaciones/mantenimientos/sucursales_cliente', ' icomoon-icon-office');
                    if ($permisos['permite_eliminar']) {
                        $crud->add_action('Eliminar', '', 'cotizaciones/mantenimientos/eliminar_clientex', 'iicon16 icomoon-icon-remove eliminar_clientex');
                    }
                } elseif ($modal == 'si') {
                    if ($permisos['permite_editar']) {
                        $crud->add_action('Editar', '', '', 'icomoon-icon-pencil-5', function ($primary_key, $row) {
                            return site_url('cotizaciones/mantenimientos/editar_cliente') . "/$primary_key/1";
                        });
                    }
                }
                //->add_action('Borrar', '', 'cotizaciones/mantenimientos/estado/ini?t=cli_cliente?clientes',' icomoon-icon-remove')
                $crud->field_type('cli_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                    ->field_type('cli_usu_mod', 'hidden', $this->tank_auth->get_user_id());

                $crud->callback_column('cliente', function ($value, $row) {
                    $str = $row->cli_nombre;
                    return $str;
                });

                $crud->callback_column('cli_razon_comercial', function ($value, $row) {
                    if ($row->cli_apellido != '') {
                        $str = $row->cli_apellido;
                    } else {
                        $str = $row->cli_razon_comercial;
                    }
                    return $str;
                });
                if ($esSup > 0) { //es supervisor
                    $queryIdVen = $this->cotizaciones_model->get_idsVendedoresxSupervisor($this->tank_auth->get_user_id());
                    if ($id_vendedor != 0) {
                        if (!in_array($id_vendedor, (explode(',', $queryIdVen)))) {
                            $queryIdVen = "0";
                        }
                    }

                    $crud->set_relation('cli_id_ven', 'ven_vendedor', '{ven_nombre} {ven_apellidos}', "ven_id in ( {$queryIdVen} )");
                } else if ($esVen > 0) { //es vendedor
                    $usu_id = $this->gsatelite->get_campo('ven_vendedor', 'ven_id_usu', array('ven_id' => $id_vendedor));
                    if ($id_vendedor != 0) {
                        if ($usu_id == $this->tank_auth->get_user_id()) {
                            $crud->set_relation('cli_id_ven', 'ven_vendedor', '{ven_nombre} {ven_apellidos}', array('ven_estado' => 1, 'ven_id_usu' => $this->tank_auth->get_user_id()));
                        } else {
                            $crud->set_relation('cli_id_ven', 'ven_vendedor', '{ven_nombre} {ven_apellidos}', array('ven_estado' => 1, 'ven_id_usu' => 0));
                        }
                    } else {
                        $crud->set_relation('cli_id_ven', 'ven_vendedor', '{ven_nombre} {ven_apellidos}', array('ven_estado' => 1, 'ven_id_usu' => $this->tank_auth->get_user_id()));
                    }
                } else {
                    $crud->set_relation('cli_id_ven', 'ven_vendedor', '{ven_nombre} {ven_apellidos}', array('ven_estado' => 1, 'ven_id_usu' => 0));
                }

                //se agrego where en la consulta  (Francisco Orozco 2017-01-13)
                $cli_id = 0;
                if ($_POST) {
                    $cliente_filtro    = $this->input->post('txt_cliente');
                    $segmento  = $this->input->post('slcSegmentos');
                    $documento_filtro  = $this->input->post('txt_documento');
                    $vendedor_filtro = $this->input->post('slcVendedor');
                    $clasific_filtro = $this->input->post('slcClasific');
                    $zona_filtro = $this->input->post('slcZona');
                    $departamento = $this->input->post('slc_dep');
                    $municipio = $this->input->post('slc_muni');
                    $where = $like = $like2 = null;

                    if ($cliente_filtro != "") {
                        $where['cli_id'] = $cliente_filtro;
                    }
                    if ($vendedor_filtro != "") {
                        $where['cli_id_ven'] = $vendedor_filtro;
                    }
                    if ($segmento != "") {
                        $where['cli_id_cac'] = $segmento;
                    }
                    if ($zona_filtro != "") {
                        $where['cli_id_zog'] = $zona_filtro;
                    }
                    if ($clasific_filtro != "") {
                        $where['cli_id_cfc'] = $clasific_filtro;
                    }
                    if ($cliente_filtro != "") {
                        $like = $cliente_filtro;
                    }
                    if ($documento_filtro != "") {
                        $like2['dcc_valor'] = $documento_filtro;
                    }
                    if ($departamento != '' && $municipio == '') {
                        $where["cli_id_mun IN (SELECT mun_id FROM mun_municipio WHERE mun_id_dep = $departamento)"] = NULL;
                    }
                    if ($municipio != "") {
                        $where['cli_id_mun'] = $municipio;
                    }
                    $clientes_array = $this->cotizaciones_model->get_clientes_like($where, null, $like2);

                    if (count($clientes_array) > 0) {
                        $cli_id = implode(',', array_unique(array_column($clientes_array, 'cli_id')));
                    }
                    if ($cli_id == "") {
                        $cli_id = 0;
                    }
                    $data_filtro['clientes'] = $this->clientes_x_segmento($segmento, true);
                    //$data_filtro['cliente_filtro']    = $cliente_filtro;
                    $data_filtro['documento_filtro']  = $documento_filtro;
                } else {
                    $data_filtro['cliente_filtro']    = "";
                    $data_filtro['documento_filtro']  = "";
                }
                // var_dump($cli_id);die();
                $crud->where('cli_id IN (' . $cli_id . ')');

                // Validaciones
                if (!$permisos['permite_agregar']) {
                    $crud->unset_add();
                }
                if (!$permisos['permite_eliminar']) {
                    $crud->unset_delete();
                }
                $data_filtro['servicios'] = $this->gsatelite->get_tabla('art_articulo', array('art_estado' => 1, 'art_tipo' => 1));

                if ($_POST) {
                    //Sector seleccionado
                    $select = $this->gsatelite->get_dropdown('cac_cartera_cliente', '{cac_nombre}', '', array('cac_estado' => 1), $segmento, '', 'cac_id', true);
                    $data_filtro["segmentos"] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $select);
                    //Cliente seleccionado                    
                    $cliente_selected = array(); // $this->gsatelite->get_tabla('cli_cliente',array('cli_estado' => 1));
                    $data_filtro['cliente_slctd'] = $this->gsatelite->get_tabla('cli_cliente', array('cli_estado' => 1, 'cli_id' => $cliente_filtro));
                    $client = '';
                    foreach ($cliente_selected as $cli) {
                        $seleccionado = ($cli['cli_id'] ==  $cliente_filtro) ? "selected" : "";
                        //$seleccionado = '';

                        if ($cli['cli_codigo'] != '') {
                            $codigo = trim($cli['cli_codigo']) . ' - ';
                        } else {
                            $codigo = '';
                        }
                        $nombre_cliente = ($cli['cli_personeria'] == 1) ? $codigo . $cli['cli_nombre'] . ' ' . $cli['cli_apellido'] : $codigo . $cli['cli_apellido'];
                        $client .= '<option value="' . $cli['cli_id'] . '" ' . $seleccionado . '>' . $nombre_cliente . '</option>';
                    }
                    $data_filtro['clientes'] = $client;
                    //vendedores
                    $select_v = $this->gsatelite->get_dropdown('ven_vendedor', '{ven_codigo} - {ven_nombre} {ven_apellidos}', '', array('ven_estado' => 1), $vendedor_filtro, '', 'ven_id', true);
                    $data_filtro["vendedores"] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $select_v);
                    //clasificaciones
                    $select_c = $this->gsatelite->get_dropdown('cfc_clasificacion_cliente', 'cfc_nombre', '', array('cfc_estado' => 1), $clasific_filtro, '', 'cfc_id', true);
                    $data_filtro["clasificaciones"] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $select_c);
                    //zonas
                    $select_z = $this->gsatelite->get_dropdown('zog_zona_geografica', 'zog_nombre', '', array('zog_estado' => 1), $zona_filtro, '', 'zog_id', true);
                    $data_filtro["zonas"] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $select_z);
                    //dep y mun

                    $select_d = $this->gsatelite->get_dropdown('dep_departamento', 'dep_nombre', '', array('dep_estado' => 1), $departamento, '', 'dep_id', true);
                    $data_filtro["departamento"] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $select_d);
                    $dpto = ($departamento != "") ? $departamento : 0;
                    $select_m = $this->gsatelite->get_dropdown('mun_municipio', 'mun_nombre', '', array('mun_estado' => 1, 'mun_id_dep' => $dpto), $municipio, '', 'mun_id', true);
                    $data_filtro["municipios"] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $select_m);
                    // var_dump($select_v);die();
                } else {
                    //clientes
                    $clientes = array(); // $this->gsatelite->get_tabla('cli_cliente', array('cli_estado' => 1));
                    $client = '';
                    foreach ($clientes as $cli) {
                        if ($cli['cli_codigo'] != '') {
                            $codigo = trim($cli['cli_codigo']) . ' - ';
                        } else {
                            $codigo = '';
                        }
                        $nombre_cliente = ($cli['cli_personeria'] == 1) ? $codigo . $cli['cli_nombre'] . ' ' . $cli['cli_apellido'] : $codigo . $cli['cli_apellido'];
                        $client .= '<option value="' . $cli['cli_id'] . '">' . $nombre_cliente . '</option>';
                    }
                    $data_filtro['clientes'] = $client;
                    //"segmento"
                    $select = $this->gsatelite->get_dropdown('cac_cartera_cliente', '{cac_nombre}', '', array('cac_estado' => 1), null, '', 'cac_id', true);
                    $data_filtro["segmentos"] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $select);
                    //vendedores
                    $select_v = $this->gsatelite->get_dropdown('ven_vendedor', '{ven_codigo} - {ven_nombre} {ven_apellidos}', '', array('ven_estado' => 1), null, '', 'ven_id', true);
                    $data_filtro["vendedores"] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $select_v);
                    //clasificaciones
                    $select_c = $this->gsatelite->get_dropdown('cfc_clasificacion_cliente', 'cfc_nombre', '', array('cfc_estado' => 1), null, '', 'cfc_id', true);
                    $data_filtro["clasificaciones"] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $select_c);
                    //zonas
                    $select_z = $this->gsatelite->get_dropdown('zog_zona_geografica', 'zog_nombre', '', array('zog_estado' => 1), null, '', 'zog_id', true);
                    $data_filtro["zonas"] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $select_z);
                    //dep y mun
                    $select_d = $this->gsatelite->get_dropdown('dep_departamento', 'dep_nombre', '', array('dep_estado' => 1), null, '', 'dep_id', true);
                    $data_filtro["departamento"] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $select_d);
                    $data_filtro["municipios"] = "";
                }
                $data_filtro["new_filtros"] = true;
                $datos['html_filtro_clientes'] = $this->load->view('cotizaciones/mantenimientos/filtro_clientes', $data_filtro, true);

                //$crud->set_relation('cli_id_ven','ven_vendedor','{ven_nombre} {ven_apellidos}', array('ven_estado'=>1));
                //echo $this->db->last_query(); die();
                //$data['titulo_personal'] = "Actividad Comercial"; # Antonio
                if ($modal == 'si') {
                    //     $crud->unset_columns('cli_observacion','cli_email','cli_sitio_web');
                    $crud->unset_print();
                    $crud->unset_edit();
                    $crud->unset_export();
                    $output = $crud->render();
                    $datos['esmodal'] = "/1";
                    $this->gsatelite->cargar_vista_masterpage('cotizaciones/mantenimientos/clientes', $datos, $output);
                    //    $this->load->view('cotizaciones/cotizaciones/nuevo_cliente',$output);
                } else {
                    $datos['esmodal'] = '';
                    $datos['titulo_personal'] = "Clientes";
                    $crud->unset_edit();
                    $output = $crud->render();
                    $this->_cargarvista($datos, $output);
                }
            } catch (Exception $e) {
                show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
            }
        }
    }

    function supervisores($modulo = NULL)
    {

        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {

            try {

                $query = $this->proceso_model->getusername();

                $sup_id = end(explode('/', uri_string()));
                if ($sup_id > 0) {
                    $usu_id = $this->gsatelite->get_campo('sup_supervisor', 'sup_id_usu', array('sup_id' => $sup_id));
                    if ($usu_id > 0) {
                        if ($query != "") {
                            $query .= ",{$usu_id}";
                        } else {
                            $query .= "{$usu_id}";
                        }
                    }
                }

                /*
                  @autor: Rene Castaneda
                  fecha: 17/05/2014
                  descripcion: Se incluyó una restriccion para que solamente aparescan los usuarios que no han sido asignados como
                  supervisor o como vendedor
                 */
                if (strlen($query) > 0) {
                    $query = $query;
                } else {
                    $query = "0";
                }
                $crud = new grocery_CRUD();
                $permisos = $this->gsatelite->get_permisos_opcion();
                //Columnas a mostrar en READ
                $columns = array(
                    'sup_nombre',
                    'sup_apellido',
                    'sup_email',
                    'sup_estado',
                );

                //Alias para las columnas
                $alias = array(
                    'sup_nombre' => 'Nombre',
                    'sup_apellido' => 'Apellidos',
                    'sup_email' => 'E-mail',
                    'sup_estado' => 'Estado',
                    'sup_id_usu' => 'Usuario',
                    'sup_codigo' => 'Código',
                    'sup_telefono' => 'Teléfono',
                    'sup_extension' => 'Extensión'
                );


                //Columnas a mostrar en ADD
                $add_columns = array(
                    'sup_id_usu',
                    'sup_nombre',
                    'sup_apellido',
                    'sup_email',
                    'sup_codigo',
                    'sup_estado',
                    'sup_fecha_mod',
                    'sup_usu_mod', 'vendedores',
                    'sup_telefono',
                    'sup_extension'
                );

                //Columnas a mostrar en EDIT
                $edit_columns = $add_columns;

                $required_fields = array(
                    'sup_nombre',
                    'sup_apellido',
                    'sup_estado',
                    'sup_email',
                    /* 'vendedores', */
                    'sup_codigo'
                );

                $crud->set_table('sup_supervisor')
                    //->set_subject('Supervisores')
                    ->set_subject('')
                    ->where('sup_estado <>', -1)
                    ->unset_delete()
                    ->columns($columns)
                    ->display_as($alias)
                    ->add_fields($add_columns)
                    ->edit_fields($edit_columns)
                    ->required_fields($required_fields)
                    ->set_relation('sup_id_usu', 'users', 'username', "id in ( {$query} )")
                    ->set_rules('sup_email', 'Email', 'valid_email')
                    /* ->set_rules('sup_nombre','Nombre','required')
                          ->set_rules('sup_apellido','Apellidos','required')
                          ->set_rules('sup_estado','Estado','required')
                          ->set_rules('sup_email','E-mail','required') */
                    ->set_rules('sup_codigo', 'Código', 'callback_validar_supervisor|required');

                if (end(explode('/', uri_string())) == 'add') {
                    $crud->field_type('sup_estado', 'hidden', 1);
                } else {
                    $crud->field_type('sup_estado', 'dropdown', array('1' => 'Activado', '0' => 'Desactivado'));
                }
                //->add_action('Borrar', '', 'cotizaciones/mantenimientos/estado/ini?t=sup_supervisor?supervisores',' icomoon-icon-remove')
                $crud->field_type('sup_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                    ->field_type('sup_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                    /**
                     *
                     *
                     * @autor Rene Castaneda
                     * @since 17/05/2014
                     *
                     * @return Mantenimiento de Tipo se seguimiento. (CRUD)
                     * Unicamente se agrego un add_action para el mantenimiento de vendedoresxsupervisor
                     * y un set_ralation_n_n
                     */
                    ->set_relation_n_n('vendedores', 'vxs_vendedorxsupervisor', 'ven_vendedor', 'vxs_id_sup', 'vxs_id_ven', '{ven_nombre} {ven_apellidos}', NULL, array('ven_estado' => 1))
                    ->unset_delete()
                    ->unset_edit()
                    ->unset_add();

                // Validar permisos. Agregado por Luis Navarro
                if ($permisos['permite_editar']) {
                    if ($modulo == 'facturacion') {
                        $crud->add_action('Editar', '', 'facturacion/entradas/editar_supervisores', 'icomoon-icon-pencil-5');
                        //  $crud->add_action('Vendedores', '', 'facturacion/entradas/vendedor_supervisor','icomoon-icon-stack');
                    } else {
                        $crud->add_action('Editar', '', 'cotizaciones/mantenimientos/editar_supervisores', 'icomoon-icon-pencil-5');
                    }
                }
                if ($modulo != 'facturacion') {
                    $crud->add_action('Vendedores', '', 'cotizaciones/mantenimientos/vendedor_supervisor', 'icomoon-icon-stack');
                }
                // Variable que envia un arreglo con los permisos. Agregado por Luis Navarro.
                $data['permisos'] = $permisos;
                $output = $crud->render();

                $data['titulo_personal'] = "Supervisores";
                $this->_cargarvista($data, $output);
            } catch (Exception $e) {
                show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
            }
        }
    }

    /**
     * ====================
     * @Autor: CHRISTIAN
     * ===================
     * */
    public function extraerSupervisores($value = '')
    {

        $id_usuario = $this->input->post('idp');
        //die(print_r($id_usuario,TRUE));

        $registro_usu = $this->gsatelite->get_registro('users', array('id' => $id_usuario));
        $empleados = $this->gsatelite->get_tabla('emp_empleado', array('emp_id' => $registro_usu->usu_id_emp));
        //die(print_r($empleados,TRUE));




        if (!empty($empleados) and $id_usuario > 0) {
            //$cadena="";
            $cod_empleado = "";
            $nombre_empleado = "";
            $apellido_empleado = "";
            $email_empleado = "";

            foreach ($empleados as $key => $value) {
                // $cadena.="<option value='".$value['emp_id']."'>".$value['emp_nombre']."</option>";
                //$cadena.="<label id='nombre_label' class='form-label span3'>".$value['emp_id'].":<span class='required' style='color:red' >&nbsp;*</span>";
                $cod_empleado .= "<input type='text' id='codigo_supervisor' name='codigo_supervisor' value='" . $value['emp_codigo'] . "' disabled='true'>";
                $cod_empleado .= "<input type='hidden' id='codigo_supervisor' name='codigo_supervisor' value='" . $value['emp_codigo'] . "'>";

                $nombre_empleado .= "<input type='text' id='nombre' name='nombre' value='" . $value['emp_nombre'] . "' disabled='true'>";
                $nombre_empleado .= "<input type='hidden' id='nombre' name='nombre' value='" . $value['emp_nombre'] . "' >";
                $apellido_empleado .= "<input type='text' id='apellido' name='apellido' value='" . $value['emp_apellido'] . "' disabled='true'>";
                $apellido_empleado .= "<input type='hidden' id='apellido' name='apellido' value='" . $value['emp_apellido'] . "' >";
                //$email_empleado .= "<input hidden='text' id='email' name='email' value='" . $value['emp_email'] . "' >";
                $email_empleado .= "<input type='email' id='email' name='email' value='" . $value['emp_email'] . "' >";

                //<input type="text" class="fecha" id="e-mail" name="e-mail" value="">
            }

            echo json_encode(array('codigo' => $cod_empleado, 'nombre' => $nombre_empleado, 'apellido' => $apellido_empleado, 'email' => $email_empleado,));
        } else {


            echo json_encode(array('codigo' => "<input type='text' id='codigo_supervisor' name='codigo_supervisor' value='No existe codigo ' disabled='true' >", 'nombre' => "<input type='text' id='nombre' name='nombre' value='No existe nombre' disabled='true'>", 'apellido' => "<input type='text' id='apellido' name='apellido' value='No existe apellido' disabled='true'>", 'email' => "<input type='text' id='email' name='email' value='No existe email ' disabled='true'>"));
        }
    }

    /**
     * ====================
     * @Autor: CHRISTIAN
     * ===================
     * */
    public function validar_supervisor()
    {


        $id_usuario = $this->input->post('idp');
        //die(print_r($id_usuario,TRUE));

        $empleados = $this->gsatelite->get_tabla('sup_supervisor', array('sup_id_usu' => $id_usuario));
        // die(print_r($empleados,TRUE));




        if (!empty($empleados)) {


            echo json_encode(array('codigo' => "<input type='hidden' id='error_usuario' name='error_usuario' value=1>"));
        } else {


            echo json_encode(array('codigo' => "<input type='hidden' id='error_usuario' name='error_usuario' value=0>"));
        }
    }

    function ingresar_supervisores($modulo = NULL)
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            //satelite_validar();
            $this->db->join("emp_empleado", "emp_id_usu=id");
            $data['usuarios_act'] = $this->gsatelite->get_tabla('users');

            $data['supervisores'] = $this->gsatelite->get_dropdown('ven_vendedor', '{ven_codigo} - {ven_nombre} {ven_apellidos}', '', array('ven_estado' => 1), null, '', 'ven_id', true);

            //die(print_r( $data['supervisores'],true));
            //die(print_r($_POST,true));

            if ($_POST) {

                $array_supervisor = array(
                    'sup_id_usu' => $this->input->post('usuario'),
                    'sup_codigo' => $this->input->post('codigo_supervisor'),
                    'sup_nombre' => $this->input->post('nombre'),
                    'sup_apellido' => $this->input->post('apellido'),
                    'sup_extension' => ($this->input->post('extension') > 0) ? intval($this->input->post('extension')) : null,
                    'sup_telefono' => $this->input->post('telefono'),
                    'sup_email' => $this->input->post('email'),
                    'sup_estado' => 1,
                    'sup_usu_mod' => $this->tank_auth->get_user_id(),
                    'sup_fecha_mod' => date('Y-m-d H:i:s'),
                );

                $contrato_id = $this->gsatelite->ingresar('sup_supervisor', $array_supervisor);

                //die(print_r($array_supervisor,true));
                $supervisor = $this->input->post('vendedor');

                //for de ingreso de supervisores
                foreach ($supervisor as $key => $value) {

                    $ingresarSup[] = array('vxs_id_sup' => $contrato_id, 'vxs_id_ven' => $supervisor[$key]);
                    $this->gsatelite->ingresar('vxs_vendedorxsupervisor', $ingresarSup[$key]);
                }

                //die(print_r($ingresarSup[2] ,true));
                //
                // Alcamenado de las Obligaciones
                // Mostrar alerta
                if ($contrato_id > 0) {
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Ingreso de contrato", 'texto_alerta' => "El registro se guardó correctamente.");
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Ingreso de contrato", 'texto_alerta' => "El registro no se guardó.");
                }

                $this->session->set_flashdata($alerta);
                if ($_POST['facturacion'])
                    $this->gsatelite->show_dialog('Supervisor ingresado con éxito!', "facturacion/entradas/supervisores");
                redirect('/cotizaciones/mantenimientos/supervisores');
            } else {
                //$data['departamentos'] = $this->gsatelite->get_dropdown('dep_departamento', '{dep_nombre}','', array('dep_estado' => '1'), null, '', 'dep_id', true);
                //$data['proveedores'] = $this->gsatelite->get_dropdown('prv_proveedor', '{prv_nombre} {prv_apellido}','', array('prv_estado' => '1'), null, '', 'prv_id', true);

                $data['titulo_personal'] = "Agregar supervisor";
                if ($modulo)
                    return $data;
                $this->_cargarvista($data);
            }
        }
    }

    /**
     * ====================
     * @Autor: CHRISTIAN
     * ===================
     * */
    function editar_supervisores($id_supervisor, $modulo = NULL)
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {

            //satelite_validar();
            // mostrar  informacion
            $data['id_supervisor'] = $id_supervisor;


            $supervisor = $this->gsatelite->get_tabla('sup_supervisor', array('sup_id' => $id_supervisor));
            $user = $this->gsatelite->get_campo('sup_supervisor', 'sup_id_usu', array('sup_id' => $id_supervisor));
            $supervisor_emp = $this->gsatelite->get_tabla('emp_empleado', array('emp_id_usu' => $user));


            foreach ($supervisor as $key => $value) {
                $id_usuario_vendedor = $value['sup_id_usu'];
                $data['usuarios_act_editar'] = $this->gsatelite->get_tabla('users', array('id' => $id_usuario_vendedor));
            }

            $data['vendedor'] = $supervisor;
            $data['supervisor_emp'] = $supervisor_emp;

            //die(print_r($supervisor,true));
            //preguntar supervisores

            $supxvendedor = $this->gsatelite->get_tabla('vxs_vendedorxsupervisor', array('vxs_id_sup' => $id_supervisor));

            //mostrar arreglo de supervisores

            $supervSelec = array();

            foreach ($supxvendedor as $key => $value) {

                $supervSelec[] = $value['vxs_id_ven'];
            }

            $data['supervisores'] = $this->gsatelite->get_dropdown('ven_vendedor', '{ven_codigo} - {ven_nombre} {ven_apellidos}', '', array('ven_estado' => 1), $supervSelec, '', 'ven_id', true);


            $data['titulo_personal'] = "Editar Supervisor";

            if ($modulo)
                return $data;
            $this->_cargarvista($data);
        }
    }

    /**
     * ====================
     * @autor: CHRISTIAN
     * ===================
     * */
    public function ingresarEdicionSupervisores()
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {



            if ($_POST) {

                //die(print_r($_POST,true));

                $id_vendedor = $this->input->post('id_supervisor');

                //die(print_r($id_vendedor,true));


                $array_supervisor = array(
                    'sup_id_usu' => $this->input->post('usuario'),
                    'sup_codigo' => $this->input->post('codigo_supervisor'),
                    'sup_nombre' => $this->input->post('nombre'),
                    'sup_apellido' => $this->input->post('apellido'),
                    'sup_extension' => ($this->input->post('extension') > 0) ? intval($this->input->post('extension')) : null,
                    'sup_telefono' => $this->input->post('telefono'),
                    'sup_email' => $this->input->post('email'),
                    'sup_estado' => (!empty($_POST['estado'])) ? 1 : $_POST['estado'],
                    'sup_usu_mod' => $this->tank_auth->get_user_id(),
                    'sup_fecha_mod' => date('Y-m-d H:i:s'),
                );

                //die(print_r($array_supervisor,true));

                $contrato_id = $this->gsatelite->actualizar_array('sup_supervisor', $array_supervisor, array('sup_id' => $id_vendedor));



                //borrar supervisores actuales

                $this->gsatelite->borrado_general('vxs_vendedorxsupervisor', array('vxs_id_sup' => $id_vendedor));

                //capturar nuevos supervisores
                $supervisor = $this->input->post('vendedor');


                //for de ingreso de supervisores
                foreach ($supervisor as $key => $value) {


                    $ingresarSup[] = array('vxs_id_sup' => $id_vendedor, 'vxs_id_ven' => $supervisor[$key]);

                    $respuesta = $this->gsatelite->ingresar('vxs_vendedorxsupervisor', $ingresarSup[$key]);
                }




                // Alcamenado de las Obligaciones
                // Mostrar alerta
                if ($contrato_id > 0) {
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Ingreso de contrato", 'texto_alerta' => "El registro se guardó correctamente.");
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Ingreso de contrato", 'texto_alerta' => "El registro no se guardó.");
                }

                $this->session->set_flashdata($alerta);
                if ($_POST['facturacion'])
                    $this->gsatelite->show_dialog('El registro se editó correctamente', "facturacion/entradas/supervisores");
                redirect('/cotizaciones/mantenimientos/supervisores');
            } else {
                //$data['departamentos'] = $this->gsatelite->get_dropdown('dep_departamento', '{dep_nombre}','', array('dep_estado' => '1'), null, '', 'dep_id', true);
                //$data['proveedores'] = $this->gsatelite->get_dropdown('prv_proveedor', '{prv_nombre} {prv_apellido}','', array('prv_estado' => '1'), null, '', 'prv_id', true);

                $data['titulo_personal'] = "Editar vendedor";
                $this->_cargarvista($data);
            }
        }
    }

    function sector_cliente()
    {

        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {

            try {

                $crud = new grocery_CRUD();
                // Variable Para permisos. Agregado por Luis Navarro
                $permisos = $this->gsatelite->get_permisos_opcion();
                //Columnas a mostrar en READ
                $columns = array(
                    'sec_nombre',
                    'sec_estado',
                );

                //Alias para las columnas
                $alias = array(
                    'sec_nombre' => 'Nombre',
                    'sec_estado' => 'Estado',
                );


                //Columnas a mostrar en ADD
                $add_columns = array(
                    'sec_nombre',
                    'sec_estado',
                    'sec_fecha_mod',
                    'sec_usu_mod',
                );

                //Columnas a mostrar en EDIT
                $edit_columns = $add_columns;

                $crud->set_table('sec_sector_cliente')
                    //->set_subject('Sector de cliente')
                    ->set_subject('')
                    ->where('sec_estado <>', -1)
                    ->unset_delete()
                    ->columns($columns)
                    ->display_as($alias)
                    ->add_fields($add_columns)
                    ->edit_fields($edit_columns)
                    ->required_fields($add_columns)
                    ->field_type('sec_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                    ->set_rules('sec_nombre', 'Nombre', 'callback_validar_sector|required')
                    ->field_type('sec_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                    ->set_rules('sec_nombre', 'Nombre', 'trim|required|campo_unico[sec_sector_cliente.sec_nombre]');;

                if (end(explode('/', uri_string())) == 'add') {
                    $crud->field_type('sec_estado', 'hidden', 1);
                } else {
                    $crud->field_type('sec_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
                }

                // Permsisos para Administrar CRUD. Agregado por Luis Navarro
                if (!$permisos['permite_agregar']) {
                    $crud->unset_add();
                }
                if (!$permisos['permite_editar']) {
                    $crud->unset_edit();
                }
                if (!$permisos['permite_eliminar']) {
                    $crud->unset_delete();
                }

                $output = $crud->render();

                $data['titulo_personal'] = "Sector de cliente";
                $this->_cargarvista($data, $output);
            } catch (Exception $e) {
                show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
            }
        }
    }

    public function validar_sector($str)
    {
        $id = end(explode("/", uri_string()));
        if (is_numeric($id)) {
            $username_old = $this->db->where("sec_id", $id)->get('sec_sector_cliente')->row()->mep_nombre;
            $num_row = $this->db->where('sec_nombre', $str)->where('sec_id !=', $id)->get('sec_sector_cliente')->num_rows();
            if ($num_row >= 1) {
                $this->form_validation->set_message('validar_sector', 'El nombre del sector ya existe');
                return FALSE;
            } else {
                return TRUE;
            }
        } else {
            $num_row = $this->db->where('sec_nombre', $str)->get('sec_sector_cliente')->num_rows();
            if ($num_row >= 1) {
                $this->form_validation->set_message('validar_sector', 'El nombre del sector ya existe');
                return FALSE;
            } else {
                return TRUE;
            }
        }
    }

    function segmento_cliente()
    {

        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {

            try {

                $crud = new grocery_CRUD();
                // Variable para Permisos. Agregado por Luis Navarro
                $permisos = $this->gsatelite->get_permisos_opcion();
                //Columnas a mostrar en READ
                $columns = array(
                    'cac_nombre',
                    'cac_comision',
                    'cac_estado',
                );

                //Alias para las columnas
                $alias = array(
                    'cac_nombre' => 'Nombre',
                    'cac_estado' => 'Estado',
                    'cac_comision' => 'Comisión %',
                );


                //Columnas a mostrar en ADD
                $add_columns = array(
                    'cac_nombre',
                    'cac_estado',
                    'cac_comision',
                    'cac_fecha_mod',
                    'cac_usu_mod',
                );

                //Columnas a mostrar en EDIT
                $edit_columns = $add_columns;

                $crud->set_table('cac_cartera_cliente')
                    //->set_subject('Segmento de cliente')
                    ->set_subject('')
                    ->where('cac_estado <>', -1)
                    ->unset_delete()
                    ->columns($columns)
                    ->display_as($alias)
                    ->add_fields($add_columns)
                    ->edit_fields($edit_columns)
                    /* ->set_rules('cac_nombre','Nombre','required')
                          ->set_rules('cac_estado','Estado','required') */
                    ->required_fields('cac_nombre', 'cac_estado', 'cac_fecha_mod', 'cac_usu_mod')
                    //->add_action('Borrar', '', 'cotizaciones/mantenimientos/estado/ini?t=cac_cartera_cliente?cartera_cliente',' icomoon-icon-remove')
                    ->field_type('cac_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                    ->set_rules('cac_nombre', 'Nombre', 'callback_validar_segmento|required|campo_unico[cac_cartera_cliente.cac_nombre]')
                    ->set_rules('cac_comision', 'Comisión', 'is_numeric')
                    ->field_type('cac_usu_mod', 'hidden', $this->tank_auth->get_user_id());

                if (end(explode('/', uri_string())) == 'add') {
                    $crud->field_type('cac_estado', 'hidden', 1);
                } else {
                    $crud->field_type('cac_estado', 'dropdown', array('1' => 'Activado', '0' => 'Desactivado'));
                }

                // Permisos Para Administrar CRUD. Agregado por Luis Navarro
                if (!$permisos['permite_agregar']) {
                    $crud->unset_add();
                }
                if (!$permisos['permite_editar']) {
                    $crud->unset_edit();
                }
                if (!$permisos['permite_eliminar']) {
                    $crud->unset_delete();
                }

                $crud->set_lang_string('update_error', 'El nombre del segmento ya existe');
                $crud->set_lang_string('insert_error', 'El nombre del segmento ya existe');
                //->set_rules('ACT_NOMBRE','Nombre','required|is_unique[ACT_ACTIVIDAD_COMERCIAL.ACT_NOMBRE]')
                // ->set_relation('ACT_ESTADO','TES_TIPO_ESTADO','TES_NOMBRE');

                $output = $crud->render();

                $data['titulo_personal'] = " Segmento de cliente";
                $this->_cargarvista($data, $output);
            } catch (Exception $e) {
                show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
            }
        }
    }

    public function validar_segmento($str)
    {
        $id = end(explode("/", uri_string()));
        if (is_numeric($id)) {
            $username_old = $this->db->where("cac_id", $id)->get('cac_cartera_cliente')->row()->mep_nombre;
            $num_row = $this->db->where('cac_nombre', $str)->where('cac_id !=', $id)->get('cac_cartera_cliente')->num_rows();
            if ($num_row >= 1) {
                $this->form_validation->set_message('validar_segmento', 'El nombre del segmento ya existe');
                return FALSE;
            } else {
                return TRUE;
            }
        } else {
            $num_row = $this->db->where('cac_nombre', $str)->get('cac_cartera_cliente')->num_rows();
            if ($num_row >= 1) {
                $this->form_validation->set_message('validar_segmento', 'El nombre del segmento ya existe');
                return FALSE;
            } else {
                return TRUE;
            }
        }
    }

    public function validar_productos($str)
    {
        $id = end(explode("/", uri_string()));
        if (is_numeric($id)) {
            $username_old = $this->db->where("pro_id", $id)->get('pro_producto')->row()->mep_nombre;
            $num_row = $this->db->where('pro_nombre', $str)->where('pro_id !=', $id)->get('pro_producto')->num_rows();
            if ($num_row >= 1) {
                $this->form_validation->set_message('validar_productos', 'El nombre del producto ya existe');
                return FALSE;
            } else {
                return TRUE;
            }
        } else {
            $num_row = $this->db->where('pro_nombre', $str)->get('pro_producto')->num_rows();
            if ($num_row >= 1) {
                $this->form_validation->set_message('validar_productos', 'El nombre del producto ya existe');
                return FALSE;
            } else {
                return TRUE;
            }
        }
    }

    function tipos_anexo()
    {

        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {

            try {

                $crud = new grocery_CRUD();
                $permisos = $this->gsatelite->get_permisos_opcion();
                //Columnas a mostrar en READ
                $columns = array(
                    'tia_nombre',
                    'tia_estado',
                );

                //Alias para las columnas
                $alias = array(
                    'tia_nombre' => 'Nombre',
                    'tia_estado' => 'Estado',
                );


                //Columnas a mostrar en ADD
                $add_columns = array(
                    'tia_nombre',
                    'tia_estado',
                    'tia_fecha_mod',
                    'tia_usu_mod',
                );

                //Columnas a mostrar en EDIT
                $edit_columns = $add_columns;

                $crud->set_table('tia_tipo_anexo')
                    //->set_subject('Tipos de anexo')
                    ->set_subject('')
                    ->where('tia_estado <>', -1)
                    ->unset_delete()
                    ->columns($columns)
                    ->display_as($alias)
                    ->add_fields($add_columns)
                    ->edit_fields($edit_columns)
                    ->required_fields($add_columns)
                    ->set_rules('tia_nombre', 'Nombre', 'trim|required|campo_unico[tia_tipo_anexo.tia_nombre]')
                    ->set_rules('tia_estado', 'Estado', 'required')
                    //->add_action('Borrar', '', 'cotizaciones/mantenimientos/estado/ini?t=tia_tipo_anexo?tipos_anexo',' icomoon-icon-remove')
                    ->field_type('tia_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                    ->field_type('tia_usu_mod', 'hidden', $this->tank_auth->get_user_id());
                //->set_rules('ACT_NOMBRE','Nombre','required|is_unique[ACT_ACTIVIDAD_COMERCIAL.ACT_NOMBRE]')
                // ->set_relation('ACT_ESTADO','TES_TIPO_ESTADO','TES_NOMBRE');
                if (end(explode('/', uri_string())) == 'add') {
                    $crud->field_type('tia_estado', 'hidden', 1);
                } else {
                    $crud->field_type('tia_estado', 'dropdown', array('1' => 'Activado', '0' => 'Desactivado'));
                }
                // Administrar Permisos de CRUD. Agregado por Luis Navarro
                if (!$permisos['permite_agregar']) {
                    $crud->unset_add();
                }
                if (!$permisos['permite_editar']) {
                    $crud->unset_edit();
                }
                if (!$permisos['permite_eliminar']) {
                    $crud->unset_delete();
                }
                $output = $crud->render();

                $data['titulo_personal'] = "Tipos de anexo";
                $this->_cargarvista($data, $output);
            } catch (Exception $e) {
                show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
            }
        }
    }

    function tipos_comision()
    {

        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {

            try {

                $crud = new grocery_CRUD();
                $permisos = $this->gsatelite->get_permisos_opcion();
                //Columnas a mostrar en READ
                $columns = array(
                    'tic_nombre',
                    'tic_estado',
                    'tic_tasa',
                );

                //Alias para las columnas
                $alias = array(
                    'tic_nombre' => 'Nombre',
                    'tic_estado' => 'Estado',
                    'tic_tasa' => 'Tasa',
                );


                //Columnas a mostrar en ADD
                $add_columns = array(
                    'tic_nombre',
                    'tic_tasa',
                    'tic_estado',
                    'tic_fecha_mod',
                    'tic_usu_mod',
                );

                //Columnas a mostrar en EDIT
                $edit_columns = $add_columns;

                $crud->set_table('tic_tipo_comision')
                    //->set_subject('Tipos de comisión')
                    ->set_subject('')
                    ->where('tic_estado <>', -1)
                    ->unset_delete()
                    ->columns($columns)
                    ->display_as($alias)
                    ->add_fields($add_columns)
                    ->edit_fields($edit_columns)
                    ->set_rules('tic_nombre', 'Nombre', 'callback_validar_comision|required')
                    /* ->set_rules('tic_estado','Estado','required')
                          ->set_rules('tic_tasa','Tasa','required') */
                    ->required_fields($add_columns)
                    //->add_action('Borrar', '', 'cotizaciones/mantenimientos/estado/ini?t=tic_tipo_comision?tipos_comision',' icomoon-icon-remove')
                    ->field_type('tic_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                    ->field_type('tic_usu_mod', 'hidden', $this->tank_auth->get_user_id());
                //->set_rules('ACT_NOMBRE','Nombre','required|is_unique[ACT_ACTIVIDAD_COMERCIAL.ACT_NOMBRE]')
                // ->set_relation('ACT_ESTADO','TES_TIPO_ESTADO','TES_NOMBRE');
                if (end(explode('/', uri_string())) == 'add') {
                    $crud->field_type('tic_estado', 'hidden', 1);
                } else {
                    $crud->field_type('tic_estado', 'dropdown', array('1' => 'Activado', '0' => 'Desactivado'));
                }
                // Administrar Permisos CRUD. Agregado por Luis Navarro
                if (!$permisos['permite_agregar']) {
                    $crud->unset_add();
                }
                if (!$permisos['permite_editar']) {
                    $crud->unset_edit();
                }
                if (!$permisos['permite_eliminar']) {
                    $crud->unset_delete();
                }

                $output = $crud->render();

                $data['titulo_personal'] = "Tipos de comisión";
                $this->_cargarvista($data, $output);
            } catch (Exception $e) {
                show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
            }
        }
    }

    public function validar_comision($str)
    {
        $id = end(explode("/", uri_string()));
        if (is_numeric($id)) {
            $username_old = $this->db->where("tic_id", $id)->get('tic_tipo_comision')->row()->mep_nombre;
            $num_row = $this->db->where('tic_nombre', $str)->where('tic_id !=', $id)->get('tic_tipo_comision')->num_rows();
            if ($num_row >= 1) {
                $this->form_validation->set_message('validar_comision', 'El nombre de la comisión producto ya existe');
                return FALSE;
            } else {
                return TRUE;
            }
        } else {
            $num_row = $this->db->where('tic_nombre', $str)->get('tic_tipo_comision')->num_rows();
            if ($num_row >= 1) {
                $this->form_validation->set_message('validar_comision', 'El nombre de la comisión ya existe');
                return FALSE;
            } else {
                return TRUE;
            }
        }
    }

    function etapas()
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            try {
                $crud = new grocery_CRUD();
                // Variable para permisos. Agregado por Luis Navarro
                $permisos = $this->gsatelite->get_permisos_opcion();
                //Columnas a mostrar en READ
                $columns = array(
                    'etc_nombre',
                    'etc_descripcion',
                    'etc_estado',
                    'etc_defecto'
                );

                //Alias para las columnas
                $alias = array(
                    'etc_nombre' => 'Nombre',
                    'etc_descripcion' => 'Descripción',
                    'etc_estado' => 'Estado',
                    'etc_defecto' => 'Defecto'
                );


                //Columnas a mostrar en ADD
                $add_columns = array(
                    'etc_nombre',
                    'etc_descripcion',
                    'etc_defecto',
                    'etc_estado',
                    'etc_usu_creacion',
                    'etc_fecha_creacion',
                    'etc_usu_modificacion',
                    'etc_fecha_modificacion',
                );

                //Columnas a mostrar en ADD
                $required_columns = array(
                    'etc_nombre',
                    'etc_estado',
                    'etc_usu_creacion',
                    'etc_fecha_creacion',
                    'etc_usu_modificacion',
                    'etc_fecha_modificacion',
                );

                //Columnas a mostrar en ADD
                $edit_columns = array(
                    'etc_nombre',
                    'etc_descripcion',
                    'etc_defecto',
                    'etc_estado',
                    'etc_usu_modificacion',
                    'etc_fecha_modificacion',
                );

                $crud->set_table('etc_etapa_cotizacion')
                    //->set_subject('Etapas')
                    ->set_subject('')
                    ->unset_delete()
                    ->columns($columns)
                    ->display_as($alias)
                    ->add_fields($add_columns)
                    ->edit_fields($edit_columns)
                    ->required_fields($required_columns)
                    ->set_rules('etc_nombre', 'Nombre', 'required|campo_unico[etc_etapa_cotizacion.etc_nombre]')
                    ->field_type('etc_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
                    ->field_type('etc_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                    ->callback_add_field('etc_defecto', function() {
                            return '<input type="checkbox" id="chbdefecto" class="nostyle"><input type="hidden" id="field-etc_defecto" name="etc_defecto" value="0">';
                    })
                    ->callback_edit_field('etc_defecto', function($value, $primary_key) {
                        $id      = $primary_key;
                        $leer    = ($this->uri->rsegments[3] == 'read')?'iButton':'';
                        $defecto = ($value)?'checked':''; // Verificar si esta activo
                        return '<input type="checkbox" id="chbdefecto" '.$defecto.' class="'.$leer.' nostyle"><input type="hidden" id="field-etc_defecto" name="etc_defecto" value="'.$value.'">';
                    })
                    ->callback_column('etc_defecto', function($value, $row) {
                        if ($value == 1) {
                            return 'Si';
                        }
                    });
                //->set_rules('ACT_NOMBRE','Nombre','required|is_unique[ACT_ACTIVIDAD_COMERCIAL.ACT_NOMBRE]')
                // ->set_relation('ACT_ESTADO','TES_TIPO_ESTADO','TES_NOMBRE');
                if (end(explode('/', uri_string())) == 'add') {
                    $crud->field_type('etc_estado', 'hidden', 1)
                        ->field_type('etc_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
                        ->field_type('etc_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
                } else {
                    $crud->field_type('etc_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
                }
                // Administrar Permisos CRUD. Agregado por Luis Navarro
                if (!$permisos['permite_agregar']) {
                    $crud->unset_add();
                }
                if (!$permisos['permite_editar']) {
                    $crud->unset_edit();
                }
                if (!$permisos['permite_eliminar']) {
                    $crud->unset_delete();
                }

                    $crud->callback_after_insert(array($this, 'actualizar_defecto_etc'));
                    $crud->callback_after_update(array($this, 'actualizar_defecto_etc'));
                $output = $crud->render();

                $data['titulo_personal'] = "Etapas Cotización";
                $this->_cargarvista($data, $output);
            } catch (Exception $e) {
                show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
            }
        }
    }

    public  function actualizar_defecto_etc($post_array, $primary_key)
    { 
        if ($post_array['etc_defecto']  == 1) {
           //etc_estado => 1
           $this->gsatelite->actualizar_array('etc_etapa_cotizacion',array('etc_defecto' => 0),array('etc_id <>' => $primary_key));
        }
     
        return true;
    }

    public function aplica_actualizar_defecto_etc(){
        $flag =  $this->input->post('flag');
        if ($flag !== '') {
            $total = $this->gsatelite->get_tabla('etc_etapa_cotizacion', array('etc_estado' => 1,'etc_defecto' => 1));
            if (count($total) > 0) {
                echo json_encode(array('es_defecto' => 1));
            }
        }
    }

    public function validar_etapa($str)
    {
        $id = end(explode("/", uri_string()));
        if (is_numeric($id)) {
            $username_old = $this->db->where("etp_id", $id)->get('etp_etapa')->row()->mep_nombre;
            $num_row = $this->db->where('etp_nombre', $str)->where('etp_id !=', $id)->get('etp_etapa')->num_rows();
            if ($num_row >= 1) {
                $this->form_validation->set_message('validar_etapa', 'El nombre de la etapa ya existe');
                return FALSE;
            } else {
                return TRUE;
            }
        } else {
            $num_row = $this->db->where('etp_nombre', $str)->get('etp_etapa')->num_rows();
            if ($num_row >= 1) {
                $this->form_validation->set_message('validar_etapa', 'El nombre de la etapa ya existe');
                return FALSE;
            } else {
                return TRUE;
            }
        }
    }

    function estados_cotizacion()
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            try {
                $crud = new grocery_CRUD();
                // Variable para permisos. Agregado por Luis Navarro
                $permisos = $this->gsatelite->get_permisos_opcion();
                //Columnas a mostrar en READ
                $columns = array(
                    'est_nombre',
                    'est_cerrada',
                    'est_estado',
                    'est_seguimiento',
                );
                //Alias para las columnas
                $alias = array(
                    'est_nombre' => 'Nombre',
                    'est_estado' => 'Estado',
                    'est_cerrada' => 'Cerrada',
                    'est_vigente' => 'Vigente',
                    'est_ganada' => 'Ganada',
                    'est_perdida' => 'Perdida',
                    'est_seguimiento' => 'Brindar Seguimiento',
                    'est_color_indicador' => 'Color Indicador'
                );

                //Columnas a mostrar en ADD
                $add_columns = array(
                    'est_nombre',
                    'est_estado',
                    'est_cerrada',
                    'est_seguimiento',
                    'est_color_indicador',
                    'est_vigente',
                    'est_ganada',
                    'est_perdida',
                    'est_fecha_mod',
                    'est_usu_mod',
                );

                $required_fields = array(
                    'est_nombre',
                    'est_estado',
                    'est_cerrada',
                    'est_seguimiento'
                );

                //Columnas a mostrar en EDIT
                $edit_columns = $add_columns;

                $crud->set_table('est_estado_cotizacion')
                    ->set_subject('')
                    ->columns($columns)
                    ->display_as($alias)
                    ->add_fields($add_columns)
                    ->edit_fields($edit_columns)
                    ->required_fields($required_fields)
                    ->set_rules('est_nombre', 'Nombre', 'trim|required|campo_unico[est_estado_cotizacion.est_nombre]')
                    /* ->set_rules('est_estado','Estado','required')
                          ->set_rules('est_cerrada','Cerrada','required')
                          ->set_rules('est_seguimiento','Dar seguimiento','required') */
                    //->field_type('est_estado','dropdown',array('1' => 'Perdida', '2' => 'Ganada', '3' => 'Corto Plazo'))
                    ->field_type('est_cerrada', 'dropdown', array('1' => 'Si', '0' => 'No'))
                    ->field_type('est_seguimiento', 'dropdown', array('1' => 'Sí', '0' => 'No'))
                    ->field_type('est_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                    ->field_type('est_usu_mod', 'hidden', $this->tank_auth->get_user_id());
                $crud->callback_add_field('est_vigente', function () {
                    return '<input type="radio" name="estado" id="chb_vigente" class="nostyle"><input type="hidden" id="field-est_vigente" name="est_vigente" value="0">';
                });
                $crud->callback_add_field('est_ganada', function () {
                    return '<input type="radio" name="estado" id="chb_ganada" class="nostyle"><input type="hidden" id="field-est_ganada" name="est_ganada" value="0">';
                });
                $crud->callback_add_field('est_perdida', function () {
                    return '<input type="radio" name="estado" id="chb_perdida" class="nostyle"><input type="hidden" id="field-est_perdida" name="est_perdida" value="0">';
                });
                $crud->callback_edit_field('est_vigente', function ($value, $primary_key) {
                    $chkd = ($value == 1) ? 'checked' : '';
                    $val = (is_numeric($value)) ? $value : 0;
                    return '<input type="radio" name="estado" id="chb_vigente" class="nostyle" ' . $chkd . '><input type="hidden" id="field-est_vigente" name="est_vigente" value="' . $val . '">';
                });
                $crud->callback_edit_field('est_ganada', function ($value, $primary_key) {
                    $chkd = ($value == 1) ? 'checked' : '';
                    $val = (is_numeric($value)) ? $value : 0;
                    return '<input type="radio" name="estado" id="chb_ganada" class="nostyle" ' . $chkd . '><input type="hidden" id="field-est_ganada" name="est_ganada" value="' . $val . '">';
                });
                $crud->callback_edit_field('est_perdida', function ($value, $primary_key) {
                    $chkd = ($value == 1) ? 'checked' : '';
                    $val = (is_numeric($value)) ? $value : 0;
                    return '<input type="radio" name="estado" id="chb_perdida" class="nostyle" ' . $chkd . '><input type="hidden" id="field-est_perdida" name="est_perdida" value="' . $val . '">';
                });
                //POR EL MOMENTO SOLO SE DEJARA UN ESTADO COMO GANADA Y SE CAMBIAN LAS OTRAS A CERO
                $crud->callback_after_insert(function ($post_array, $primary_key) {
                    if ($post_array['est_ganada'] > 0) {
                        $CI = &get_instance();
                        $CI->gsatelite->actualizar_array('est_estado_cotizacion', array('est_ganada' => 0), array('est_id != ' => $primary_key));
                    }
                    return $post_array;
                });
                $crud->callback_after_update(function ($post_array, $primary_key) {
                    if ($post_array['est_ganada'] > 0) {
                        $CI = &get_instance();
                        $CI->gsatelite->actualizar_array('est_estado_cotizacion', array('est_ganada' => 0), array('est_id != ' => $primary_key));
                    }
                    return $post_array;
                });
                $crud->callback_field('est_color_indicador', array($this, 'field_callback_1'));
                if (end(explode('/', uri_string())) == 'add') {
                    $crud->field_type('est_estado', 'hidden', 1);
                } else {
                    $crud->field_type('est_estado', 'dropdown', array('1' => 'Activado', '0' => 'Desactivado'));
                }
                // Administrar Permisos CRUD. Agregado por Luis Navarro
                if (!$permisos['permite_agregar']) {
                    $crud->unset_add();
                }
                if (!$permisos['permite_editar']) {
                    $crud->unset_edit();
                }
                if (!$permisos['permite_eliminar']) {
                    $crud->unset_delete();
                }

                $output = $crud->render();

                $data['titulo_personal'] = 'Estados de cotización';
                $this->_cargarvista($data, $output);
            } catch (Exception $e) {
                show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
            }
        }
    }

    function field_callback_1($value = '', $primary_key = null)
    {
        $ver = '<table width="10%"><tr><td style="height: 30px; border: solid black 1px; background-color:' . $value . '">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td></tr></table>';
        return '<div class="span10" style="display: flex">
            <input type="text" id="field-est_color_indicador" name="est_color_indicador" style="width:35% !important;display: inline-block;" value="' . $value . '">
            <div id="colorSelector" style="margin-left:7px;"><div style="background-color:' . $value . '"></div></div>
            <div id="read_color" style="margin-left:7px; display: none;">' . $ver . '</div>
            </div>';
    }

    /**
     *
     *
     * @autor Rene Castaneda
     * @since 17/05/2014
     *
     * @return Mantenimiento de Tipo se seguimiento. (CRUD)
     */
    function tipo_seguimiento()
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            try {

                $crud = new grocery_CRUD();
                $permisos = $this->gsatelite->get_permisos_opcion();
                $crud->set_table('tsg_tipo_seguimiento')
                    //->set_subject('Tipo de seguimiento')
                    ->set_subject('')
                    ->columns('tsg_nombre', 'tsg_estado')
                    ->fields('tsg_nombre', 'tsg_estado')
                    ->display_as('tsg_nombre', 'Nombre')
                    ->display_as('tsg_estado', 'Estado')
                    ->required_fields('tsg_nombre', 'tsg_estado')
                    ->set_rules('tsg_nombre', 'Nombre', 'campo_unico[tsg_tipo_seguimiento.tsg_nombre]|required')
                    ->unset_delete();
                if (end(explode('/', uri_string())) == 'add') {
                    $crud->field_type('tsg_estado', 'hidden', 1);
                } else {
                    $crud->field_type('tsg_estado', 'dropdown', array('1' => 'Activado', '0' => 'Desactivado'));
                }

                $datos["titulo_personal"] = "Tipos de seguimiento";
                // Administrar Permisos CRUD. Agregado por Luis Navarro
                if (!$permisos['permite_agregar']) {
                    $crud->unset_add();
                }
                if (!$permisos['permite_editar']) {
                    $crud->unset_edit();
                }
                if (!$permisos['permite_eliminar']) {
                    $crud->unset_delete();
                }
                $output = $crud->render();
                $this->_cargarvista($datos, $output);
            } catch (Exception $e) {
                show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
            }
        }
    }

    public function validar_tipo_seguimiento($str)
    {
        $id = end(explode("/", uri_string()));
        if (is_numeric($id)) {
            $username_old = $this->db->where("tsg_id", $id)->get('tsg_tipo_seguimiento')->row()->mep_nombre;
            $num_row = $this->db->where('tsg_nombre', $str)->where('tsg_id !=', $id)->get('tsg_tipo_seguimiento')->num_rows();
            if ($num_row >= 1) {
                $this->form_validation->set_message('validar_tipo_seguimiento', 'El nombre del seguimiento ya existe');
                return FALSE;
            } else {
                return TRUE;
            }
        } else {
            $num_row = $this->db->where('tsg_nombre', $str)->get('tsg_tipo_seguimiento')->num_rows();
            if ($num_row >= 1) {
                $this->form_validation->set_message('validar_tipo_seguimiento', 'El nombre del seguimiento ya existe');
                return FALSE;
            } else {
                return TRUE;
            }
        }
    }

    /**
     *
     *
     * @autor Rene Castaneda
     * @since 17/05/2014
     *
     * @return Mantenimiento de vendedorxsupervisor. (CRUD)
     */
    function vendedor_supervisor($id_supervisor)
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            try {

                $crud = new grocery_CRUD();

                $crud->set_table('vxs_vendedorxsupervisor')
                    //->set_subject('Vendedor - Supervisor')
                    ->set_subject('')
                    ->where('vxs_id_sup', $id_supervisor)
                    ->columns('vxs_id_ven')
                    ->fields('vxs_id_sup', 'vxs_id_ven')
                    ->display_as('vxs_id_ven', 'Nombre Vendedor')
                    // ->display_as('tsg_estado', 'Estado')
                    ->required_fields('vxs_id_ven')
                    ->set_relation('vxs_id_ven', 'ven_vendedor', '{ven_nombre} {ven_apellidos}', array('ven_estado' => 1))
                    ->field_type('vxs_id_sup', 'hidden', $id_supervisor)
                    // ->field_type('tsg_estado','dropdown',array('1' => 'Activado', '0' => 'Desactivado'))
                    ->callback_before_insert(function ($post_array) {
                        //VALIDAR QUE NO REGISTRE UN VENDEDOR YA REGISTRADO
                        $existe = $this->cotizaciones_model->existeRegistroEtapa('vxs_vendedorxsupervisor', 'vxs_id_ven', $post_array['vxs_id_ven'], 'vxs_id_sup', $post_array['vxs_id_sup'], 0, 0);
                        if ($existe > 0) {
                            return FALSE;
                        } else {
                            return TRUE;
                        }
                    })
                    ->callback_before_update(function ($post_array, $primary_key) {
                        //VALIDAR QUE NO REGISTRE UN VENDEDOR YA REGISTRADO
                        $filaVenSup = $this->cotizaciones_model->get_registro('vxs_vendedorxsupervisor', 'vxs_id', $primary_key);
                        $idVenactual = $filaVenSup->vxs_id_ven;

                        $existe = $this->cotizaciones_model->existeRegistroEtapa('vxs_vendedorxsupervisor', 'vxs_id_ven', $post_array['vxs_id_ven'], 'vxs_id_sup', $post_array['vxs_id_sup'], 1, $idVenactual);
                        if ($existe > 0) {
                            return FALSE;
                        } else {
                            return TRUE;
                        }
                    })
                    ->set_lang_string('update_error', 'Error!\nFavor Verificar lo Siguiente:\n\n*El Vendedor elegido ya fue registrado anteriormente.')
                    ->set_lang_string('insert_error', 'Error!\nFavor Verificar lo Siguiente:\n\n*El Vendedor elegido ya fue registrado anteriormente.')
                    ->unset_delete();
                $datos["datos_supervisor"] = $this->cotizaciones_model->get_registro('sup_supervisor', 'sup_id', $id_supervisor); //obtener registro
                $datos["titulo_personal"] = "Vendedores por Supervisor";

                $output = $crud->render();
                $this->_cargarvista($datos, $output);
            } catch (Exception $e) {
                show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
            }
        }
    }

    function nuevo_cliente($esmodal = null, $id_tabla = null, $otro_modulo = null, $base_datos = null)
    {
        satelite_validar();
        // Preguntar si el usuario es supervisor o vendedor
        $condicion1 = array('sup_id_usu' => $this->tank_auth->get_user_id(), 'sup_estado' => 1);
        $esSup = $this->cotizaciones_model->Existe_Registro("sup_supervisor", $condicion1);
        $condicion2 = array('ven_id_usu' => $this->tank_auth->get_user_id(), 'ven_estado' => 1);
        $esVen = $this->cotizaciones_model->Existe_Registro("ven_vendedor", $condicion2);
        //$datos['doc_documentos'] = $this->gsatelite->get_tabla('tde_tipo_documento');
        $datos['doc_documentos'] = $this->personal_model->get_documentos();
        $tipos_doc = $this->expediente_personal_model->get_dropdown('tde_tipo_documento', '{tde_nombre}', '', array('tde_estado' => 1), null, '', 'tde_id', true);
        $datos['options_tipo_documento'] = str_replace('<option value="0">Seleccione</option>', '', $tipos_doc);
        // Obtener las Condiciones
        // $condiciones = $this->gsatelite->get_dropdown('tpg_tipo_pago', '{tpg_nombre}','', array('tpg_estado' => '1'), null, '', 'tpg_id', true);
        // $datos["condicion_tabla"] = str_replace('<option value=""></option>', '',$condiciones);

        $datos['tipo_telefono'] = $this->gsatelite->get_tabla('tit_tipo_telefono', array('tit_id >' => 0));

        //Tipo de lista de precio
        $datos['tipo_lista_precio'] = $this->gsatelite->get_tabla('tlp_tipo_lista_precio', array('tlp_estado' => 1));

        $datos['departamentos'] = $this->gsatelite->get_tabla('dep_departamento', array('dep_estado' => 1));
        $datos['giros'] = $this->gsatelite->get_tabla('gir_giro', array('gir_estado' => 1));
        $datos['clasificaciones'] = $this->gsatelite->get_tabla('cfc_clasificacion_cliente', array('cfc_estado' => 1));
        //Centro de costos
        $datos["centro_costo"] = $this->gsatelite->get_dropdown('cec_centro_costo', '{cec_nombre}', '', array('cec_estado' => 1), null, '', 'cec_id', true);
        $datos["bancos"] = $this->gsatelite->get_dropdown('ban_banco', '{ban_nombre}', '', array('ban_estado' => 1), null, '', 'ban_id', true);
        //tipo de cuenta
        $datos["tipo_cuenta"] = $this->gsatelite->get_dropdown('tcn_tipo_cuenta', '{tcn_nombre}', '', array('tcn_estado' => 1), null, '', 'tcn_id', true);
        //cuenta contable
        $datos["cuen_con"] = $this->gsatelite->get_dropdown('cnt_cuenta_contable', '{cnt_nombre}', '', array('cnt_estado' => 1), null, '', 'cnt_id', true);
        //zona geografias
        $datos["zonas"]     = $this->gsatelite->get_tabla("zog_zona_geografica", array("zog_estado" => 1));
        //telefonos
        $datos['tipo_telefonos'] = $this->gsatelite->get_tabla('tit_tipo_telefono', array('tit_estado' => 1));
        $datos["tipos_tel"] = $this->gsatelite->get_dropdown('tit_tipo_telefono', '{tit_nombre}', '', array('tit_estado' => 1), null, '', '', true);
        if ($esSup > 0) { //es supervisor
            $queryIdVen = $this->cotizaciones_model->get_idsVendedoresxSupervisor($this->tank_auth->get_user_id());
            $datos['ids_ven'] = $queryIdVen;
            $datos['ven_selec'] = null;
        }
        if ($esVen > 0) { //es vendedor
            $ven_id = $this->gsatelite->get_campo('ven_vendedor', 'ven_id', array('ven_id_usu' => $this->tank_auth->get_user_id()));
            $datos['ids_ven'] = $ven_id;
            $datos['ven_selec'] = $ven_id;
        } else {
            $datos['ids_ven'] = 0;
            $datos['ven_selec'] = null;
        }
        $datos['base_datos'] = null;
        if ($this->input->get('bd') != '') {
            $drn_id = $this->input->get('bd');
            $base_datos = $this->cotizaciones_model->get_base_datos(array('drn_id' => $drn_id));
            if ($base_datos[0]['drn_id_cli'] != null) {
                redirect('cotizaciones/mantenimientos/editar_cliente/' . $base_datos[0]['drn_id_cli']);
            } else {
                $datos_nuevo_cliente = $this->cotizaciones_model->get_datos_llamada_sac($drn_id);
                //print_r($this->db->last_query());die();
                $datos['new_cliente'] = $datos_nuevo_cliente[0];
            }
            //print_r($datos['new_cliente']);die();   
            $datos['base_datos'] = $base_datos[0];
        }
        if ($esmodal) {
            $datos['esmodal'] = 1;
            if (isset($id_tabla)) {
                $datos['llamada_info'] = $this->gsatelite->get_registro('tbl_tabla_llamadas', array('tbl_id' => $id_tabla));
                $datos['medios'] = $this->gsatelite->get_tabla('txt_tabla_llamadaxtipo_medio', array('txt_id_tbl' => $id_tabla));
                $datos['giro'] = $this->gsatelite->get_tabla('gir_giro', array('gir_estado' => 1));
            }
            $this->gsatelite->cargar_vista_masterpage('cotizaciones/mantenimientos/nuevo_cliente', $datos);
        } else {
            $datos['titulo_personal'] = "Nuevo Cliente";
            if ($otro_modulo)
                return $datos;
            $this->_cargarvista($datos);
        }
    }

    function guardar_cliente(){
        if ($_POST) {
            $esmodal = $this->input->post('es_agregar_modal'); // Este me sirve para diferenciar de donde vengo.
            $modal = $this->input->post('modal'); // Este me sirve para diferenciar de donde vengo.
            $id_tabla = $this->input->post('id_tabla');  // Actualizar tbl_tabla_llamadas
            $person = $this->input->post('personeria');
            $idstlp = $this->input->post('slc_tipo_lista_precio');
            //validacion de los dias plazo
            $tipo_vencimiento   = $this->input->post('slc_tipo_vencimiento');
            $tipo_vencimiento   = ($tipo_vencimiento == "") ? null : $tipo_vencimiento;
            $dias_plazo         = null;
            if ($tipo_vencimiento  == 1) {
                $txt_dias_plazo =  $this->input->post('txt_dias_plazo');
                $dias_plazo = ($txt_dias_plazo != "" and is_numeric($txt_dias_plazo)) ? $txt_dias_plazo : null;
            } else if ($tipo_vencimiento  == 2) {
                $slc_dia_especifico =  $this->input->post('slc_dia_especifico');
                $dias_plazo = ($slc_dia_especifico != "" and is_numeric($slc_dia_especifico)) ? $slc_dia_especifico : null;
            } else {
                $tipo_vencimiento = null;
            }
            //fin validacion dias plazo
            $detalle = array(
                'cli_codigo' => (trim($this->input->post('codigo_cli')) != "") ? trim($this->input->post('codigo_cli')) : "", 
                'cli_id_sec' => ($this->input->post('sector') != "" && $this->input->post('sector') > 0) ? $this->input->post('sector') : null, 
                'cli_id_cac' => ($this->input->post('cartera') != "" && $this->input->post('cartera') > 0) ? $this->input->post('cartera') : null, 
                'cli_id_ven' => ($this->input->post('vendedor') != "") ? $this->input->post('vendedor') : null, 
                'cli_apellido' => trim($this->input->post('apellidos')), 
                'cli_nombre' => trim($this->input->post('nombres')), 
                'cli_nombre_comercio' => trim($this->input->post('nom_comercial')), 
                'cli_personeria' => $this->input->post('personeria'), 
                'cli_id_pro' => ($_POST['ocupacion']) ? $this->input->post('ocupacion') : null, 
                'cli_lugar_trabajo' => ($_POST['lugar_trabajo']) ? $_POST['lugar_trabajo'] : null, 
                'cli_cargo' => ($_POST['cargo']) ? $_POST['cargo'] : null, 
                'cli_persona_aut' => $_POST['persona_autorizada'], 
                'cli_observacion' => $this->input->post('observ'), 
                'cli_id_rtc' => ($this->input->post('ruta_cliente') != "") ? $this->input->post('ruta_cliente') : null, 
                'cli_es_gran_contribuyente' => $this->input->post('hdngranCont'), 
                'cli_id_mun' => (!empty($_POST['municipio'])) ? $_POST['municipio'] : NULL, 
                'cli_id_dis' => ($_POST['distrito'] > 0) ? $_POST['distrito'] : NULL,                
                'cli_id_tif' => ($_POST['comprobante']) ? $_POST['comprobante'] : null, 
                'cli_factura_elect' => (isset($_POST['factura_electronica'])) ? 1 : null, 
                'cli_id_pai' => ($_POST['nacionalidad']) ? $_POST['nacionalidad'] : null, 
                'cli_id_tpg' => ($_POST['condicion'] != '') ? $_POST['condicion'] : null, 
                'cli_id_frp' => ($_POST['slc_forma_pago'] != '') ? $_POST['slc_forma_pago'] : null, 
                'cli_estado' => 1, 
                'cli_sitio_web' => $this->input->post('sitio_web'), 
                'cli_email' => $this->input->post('correo'), 
                'cli_usu_mod' => $this->tank_auth->get_user_id(), 
                'cli_fecha_mod' => date('Y-m-d H:i:s'), 
                'cli_fecha_crea' => date('Y-m-d H:i:s'), 
                'cli_usu_crea' => $this->tank_auth->get_user_id(), 
                'cli_direccion' => $this->input->post('direccion_cli'), 
                'cli_id_tpc' => ($this->input->post('tip_cliente') != "") ? $this->input->post('tip_cliente') : null, 
                'cli_id_gir' => ($this->input->post('giro') != "") ? $this->input->post('giro') : null, 
                'cli_representante' => ($_POST['representante']) ? $_POST['representante'] : null, 
                'cli_registro' => ($_POST['registro']) ? $_POST['registro'] : null, 
                'cli_fotografia' => ($this->input->post('foto_empleado') != "") ? "uploads/anexos_cliente/" . $this->input->post('foto_empleado') : null, 
                'cli_fecha_nacimiento' => ($_POST['txt_fecha_nacimiento'] != "") ? formatear_fecha('Y-m-d', $_POST['txt_fecha_nacimiento']) : null, 
                'cli_fecha_registro' => ($_POST['txt_fecha_registro'] != "") ? formatear_fecha('Y-m-d', $_POST['txt_fecha_registro']) : null, 
                'cli_id_cfc' => ($_POST['slc_clasificacion'] != "") ? $_POST['slc_clasificacion'] : null, 
                'cli_dias_plazo'          => $dias_plazo, 
                'cli_monto_credito'       => ($_POST['txt_monto_credito'] != "") ? $_POST['txt_monto_credito'] : null, 
                'cli_nombre_factura'      => ($_POST['txt_nombre_factura'] != "") ? $_POST['txt_nombre_factura'] : null, 
                'cli_descuento_sugerido'  => ($_POST['txt_descuento_sugerido'] != "") ? $_POST['txt_descuento_sugerido'] : 0, 
                'cli_id_zog'              => ($_POST['slc_zona_geografica'] != "") ? $_POST['slc_zona_geografica'] : null, 
                'cli_tipo_fac_vence'      => $tipo_vencimiento, 
                'cli_id_ban'            => ($_POST['slc_banco_paga'] != "") ? $_POST['slc_banco_paga'] : null, 
                'cli_encargado_pago'      => ($_POST['txt_encargado_pago'] != "") ? $_POST['txt_encargado_pago'] : null, 
                'cli_comentario_finanzas' => ($_POST['txt_comentario_adicional'] != "") ? $_POST['txt_comentario_adicional'] : null, 
                'cli_suspender_facturacion' => $_POST['hdn_suspende_fact']
            );
            $id_cliente = $this->gsatelite->ingresar('cli_cliente', $detalle);
            //Insertar el tipo precio cliente
            foreach ($idstlp as $key => $idtlp) {
                $tipo_precio_cliente_array = array(
                    'tpn_id_cli' => $id_cliente,
                    'tpn_id_tlp' => $idtlp,
                    'tpn_estado' => 1,
                    'tpn_usu_creacion' => $this->tank_auth->get_user_id(),
                    'tpn_fecha_creacion' => date('Y-m-d H:i:s'),
                    'tpn_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'tpn_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                $this->gsatelite->ingresar('tpn_tipo_precio_cliente', $tipo_precio_cliente_array);
            }
            // Guardar los numeros de telefono
            $telefonos = $this->input->post('medios_contacto');
            $telefonos_valor = $this->input->post('medio');
            for ($i = 0; $i < count($telefonos); $i++) {
                if ($telefonos[$i] != '' && $telefonos_valor[$i] != '') {
                    if ($telefonos[$i] > 0 && $telefonos_valor[$i] > 0) {
                        $cadena = array(
                            'txc_id_cli' => $id_cliente,
                            'txc_id_tit' => $telefonos[$i],
                            'txc_numero' => $telefonos_valor[$i],
                            'txc_estado' => 1,
                            'txc_usu_mod' => $this->tank_auth->get_user_id(),
                            'txc_fecha_mod' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('txc_telefonoxcliente', $cadena);
                    }
                }
            }
            $medio_contacto = $this->input->post('medio_contacto');
            //$condicion = $this->input->post('condiciones');
            for ($i = 0; $i < count($medio_contacto); $i++) {
                if ($medio_contacto[$i] > 0) {
                    $this->gsatelite->ingresar('cxm_clientexmediocontacto', array('cxm_id_cli' => $id_cliente, 'cxm_id_tmc' => $medio_contacto[$i]));
                }
            }
            // for($i=0; $i< count($condicion); $i++) {
            //    if($condicion[$i]>0){
            //       $cond_detalle = array(
            //         'cxl_id_cli' => $id_cliente,
            //         'cxl_id_cod' => $condicion[$i],
            //         'cxl_estado' => 1,
            //         'cxl_usu_mod' => $this->tank_auth->get_user_id(),
            //         'cxl_fecha_mod' => date('Y-m-d H:i:s')
            //       );
            //       $this->gsatelite->ingresar('cxl_condicionxcliente', $cond_detalle);
            //    }
            // }
            $uno = 1;
            if (isset($id_tabla) && isset($esmodal)) {
                $personeria = $this->cotizaciones_model->actualizarCampo('tbl_tabla_llamadas', 'tbl_id', $id_tabla, 'tbl_nuevo', $uno);
                $registro = $this->cotizaciones_model->actualizarCampo('tbl_tabla_llamadas', 'tbl_id', $id_tabla, 'tbl_id_cli', $id_cliente);
            }
            //ingresar los impuestos que seran aplicados al cliente de forma automatica
            // Estara siendo manejado al momento de crear una nueva cotizacion.
            $imp_clientes = $this->input->post('impuestos_cliente');
            for ($j = 0; $j < count($imp_clientes); $j++) {
                if ($imp_clientes[$j] > 0) {
                    $arreglo_imp = array(
                        'ixc_id_cli'            => $id_cliente,
                        'ixc_id_imp'            => $imp_clientes[$j],
                        'ixc_aplica'            => 1,
                        'ixc_estado'            => 1,
                        'ixc_usu_creacion'      => $this->tank_auth->get_user_id(),
                        'ixc_fecha_creacion'    => date('Y-m-d H:i:s'),
                        'ixc_usu_modificacion'  => $this->tank_auth->get_user_id(),
                        'ixc_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->ingresar('ixc_impuestoxcliente', $arreglo_imp);
                }
            }
            //se ingresaran los impuestos que no aplicara al cliente.
            $imp_clientes_no = $this->input->post('no_impuestos_cliente');
            foreach ($imp_clientes_no as $imp_cliente_no) {
                $arreglo_imp_no = array(
                    'ixc_id_cli'            => $id_cliente,
                    'ixc_id_imp'            => $imp_cliente_no,
                    'ixc_aplica'            => 0,
                    'ixc_estado'            => 1,
                    'ixc_usu_creacion'      => $this->tank_auth->get_user_id(),
                    'ixc_fecha_creacion'    => date('Y-m-d H:i:s'),
                    'ixc_usu_modificacion'  => $this->tank_auth->get_user_id(),
                    'ixc_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                $this->gsatelite->ingresar('ixc_impuestoxcliente', $arreglo_imp_no);
            }
            //se ingresaran los retenciones del cliente.
            $retenciones_cliente = $this->input->post('retenciones_cliente');
            foreach ($retenciones_cliente as $retencion_cliente) {
                $arreglo_cli_ret = array(
                    'rxc_id_cli'            => $id_cliente,
                    'rxc_id_ret'            => $retencion_cliente,
                    'rxc_estado'            => 1,
                    'rxc_usu_creacion'      => $this->tank_auth->get_user_id(),
                    'rxc_fecha_creacion'    => date('Y-m-d H:i:s'),
                    'rxc_usu_modificacion'   => $this->tank_auth->get_user_id(),
                    'rxc_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                $this->gsatelite->ingresar('rxc_retencionxcliente', $arreglo_cli_ret);
            }
            //ingresar a los contactos
            $contacto_nom = $this->input->post('contacto_nombre');
            $contacto_ape = $this->input->post('contacto_apellido');
            $contacto_cargo = $this->input->post('contacto_cargo');
            $tiposTelefono = $this->input->post('tiposTelefono');
            $contacto_tel = $this->input->post('contacto_telefono');
            $contacto_email = $this->input->post('contacto_email');
            for ($k = 0; $k < count($contacto_nom); $k++) {
                if (trim($contacto_nom[$k]) != "") {
                    $detalle_con = array(
                        'con_id_cli' => $id_cliente,
                        'con_id_tit' => (trim($tiposTelefono[$k]) > 0) ? trim($tiposTelefono[$k]) : NULL,
                        'con_nombre' => trim($contacto_nom[$k]),
                        'con_apellidos' => trim($contacto_ape[$k]),
                        'con_cargo' => trim($contacto_cargo[$k]),
                        'con_telefono' => trim($contacto_tel[$k]),
                        'con_email' => trim($contacto_email[$k]),
                        'con_estado' => 1,
                        'con_usu_mod' => $this->tank_auth->get_user_id(),
                        'con_fecha_mod' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->ingresar('con_contacto', $detalle_con);
                }
            } // End ingreso de contactos
            // Ingresar Referencias
            $referencia_nombre = $this->input->post('referencia_nombre');
            $referencia_fijo = $this->input->post('referencia_fijo');
            $referencia_movil = $this->input->post('referencia_movil');
            $referencia_tipo = $this->input->post('referencia_tipo');
            for ($k = 0; $k < count($referencia_nombre); $k++) {
                if (trim($referencia_nombre[$k]) != "") {

                    $detalle_ref = array(
                        'rfc_id_cli' => $id_cliente, 
                        'rfc_nombre' => trim($referencia_nombre[$k]), 
                        'rfc_tel_fijo' => trim($referencia_fijo[$k]), 
                        'rfc_tel_movil' => trim($referencia_movil[$k]), 
                        'rfc_tipo' => trim($referencia_tipo[$k]), 
                        'rfc_estado' => 1, 
                        'rfc_usu_mod' => $this->tank_auth->get_user_id(), 
                        'rfc_usu_crea' => $this->tank_auth->get_user_id(), 
                        'rfc_fecha_mod' => date('Y-m-d H:i:s'), 
                        'rfc_fecha_crea' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->ingresar('rfc_referencia_cliente', $detalle_ref);
                }
            } // End ingreso de contactos
            // Agregar documentos del Cliente
            $numeros_array = $this->input->post('numero_documento');
            $documentos_array = $this->input->post('documento');
            $vence_documento_array = $this->input->post('vence_documento');
            $fecha_exp_doc_array = $this->input->post('fecha_exp_doc');
            $array_titulo_anexo = $this->input->post('titulo_anexo_doc');
            $array_nombre_anexo = $this->input->post('nombre_anexo_doc');
            $array_lugarexp_doc = $this->input->post('lugar_exp_doc');
            $carpeta = $this->input->post("nombre_anexo_carpeta");

            foreach ($numeros_array as $key => $value) {
                $titulo_a = trim($array_titulo_anexo[$key]);
                $url_anexo = "";
                if ($titulo_a != "") {
                    $extencion = end(explode(".", $array_nombre_anexo[$key]));
                    $url_anexo = trim($array_titulo_anexo[$key]) . "." . trim($extencion); //se modifico de esta manera porque se uso grocery para su edicion.
                    $this->mover_img_gral('public/temp/archivos/', 'uploads/anexos_cliente', $array_nombre_anexo[$key]);
                }
                $cadena = array(
                    'dcc_id_tde' => $documentos_array[$key],
                    'dcc_id_cli' => $id_cliente,
                    'dcc_valor' => $value,
                    'dcc_fecha_vence' => formatear_fecha('Y-m-d', $vence_documento_array[$key]),
                    'dcc_fecha_expedicion' => formatear_fecha('Y-m-d', $fecha_exp_doc_array[$key]),
                    'dcc_nombre_anexo' => $titulo_a,
                    'dcc_url' => $url_anexo,
                    'dcc_lugar_expedicion' => $array_lugarexp_doc[$key],
                    'dcc_estado' => 1,
                    'dcc_usu_mod' => $this->tank_auth->get_user_id(),
                    'dcc_fecha_mod' => date('Y-m-d H:i:s'),
                    'dcc_usu_crea' => $this->tank_auth->get_user_id(),
                    'dcc_fecha_crea' => date('Y-m-d H:i:s')
                );
                $this->gsatelite->ingresar('dcc_documento_cliente', $cadena);
            }
            //Cuentas Contables
            $centrosCosto   = $this->input->post('centrosCosto');
            $cuentaContable = $this->input->post('cuentaContable');
            $tipoCuentas    = $this->input->post('tipoCuentas');
            $tipo_pago      = $this->input->post('tipo_pago');
            //Cuentas Contables
            if (count($centrosCosto) > 0 && $centrosCosto != '') {
                for ($i = 0; $i < count($centrosCosto); $i++) {
                    $cuentas_array = array(
                        'cxn_id_cli'    => $id_cliente,
                        'cxn_id_cnt'    => $cuentaContable[$i],
                        'cxn_id_tcn'    => $tipoCuentas[$i],
                        'cxn_id_cec'    => $centrosCosto[$i],
                        'cxn_id_tpg'    => $tipo_pago[$i],
                        'cxn_estado'    => 1,
                        'cxn_usu_crea'  => $this->tank_auth->get_user_id(),
                        'cxn_fecha_crea' => date('Y-m-d H:i:s'),
                        'cxn_usu_mod'   => $this->tank_auth->get_user_id(),
                        'cxn_fecha_mod' => date('Y-m-d H:i:s'),
                    );
                    $this->gsatelite->ingresar('cxn_cuentaxcliente', $cuentas_array);
                }
            }
            // Agregar los Anexos por cliente
            $rutas = $this->input->post("ruta");
            $carpeta = $this->input->post("nombreCarpeta");
            if (count($rutas) > 0) {
                $carpeta = $carpeta;
                for ($i = 0; $i < count($rutas); $i++) {
                    if ($rutas[$i] != "") {
                        $img = $rutas[$i];
                        $titulo = $this->input->post("titulo_doc" . $i);
                        $this->datos_imagen_gral($img, $id_cliente, $carpeta, $titulo);
                    }
                }
            }
            //agregar imagen del clientes
            if ($this->input->post('foto_empleado') != "" and $this->input->post('titulo_foto_empleado') != "") { //guardar la foto del eclienteleado
                $titulo = $this->input->post('titulo_foto_empleado');
                $img = $this->input->post('foto_empleado');
                $this->datos_imagen_gral2($img, $id_emp, 'uploads/anexos_cliente/fotos/', $titulo, 1); //es de tipo foto
            }
            //Si viene desde una base de datos se asocia el id del cliente.
            if ($_POST['hdnBaseDatos'] != '') {
                $base_array = array(
                    'drn_id_cli' => $id_cliente,
                    'drn_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'drn_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                $this->gsatelite->actualizar_array('drn_directorio_contacto', $base_array, array('drn_id' => $_POST['hdnBaseDatos']));
                //buscar si habia seguimientos y trasladarlos a la SEC
                $seguimientos = $this->cotizaciones_model->get_seguimientos_base_datos(array('cli_id' => $id_cliente));
                if (count($seguimientos) > 0) {
                    foreach ($seguimientos as $k => $v) {
                        $old_seg = array(
                            'sec_id_tsg' => $v['sgd_id_tsg'],
                            'sec_id_con' => $v['contacto'],
                            'sec_fecha' => $v['sgd_fecha'],
                            'sec_fecha_proximo' => $v['sgd_fecha_proximo'],
                            'sec_comentario' => $v['sgd_comentario'],
                            'sec_lugar' => $v['sgd_lugar'],
                            'sec_invitados' => $v['sgd_invitados'],
                            'sec_estado' => $v['sgd_estado'],
                            'sec_usu_crea' => $v['sgd_usu_creacion'],
                            'sec_fecha_crea' => $v['sgd_fecha_creacion'],
                            'sec_usu_mod' => $this->tank_auth->get_user_id(),
                            'sec_fecha_mod' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('sec_seguimiento_cliente', $old_seg);
                    }
                }
            }
            $tipo_boton = $this->input->post('btnCrear');
            $this->session->set_userdata('id_cliente_llamada', $id_cliente);
            //Se redirecciona en base al boton
            if ($tipo_boton == 1) {
                // Verificar si viene del modal de CRM
                if ($modal === '1') {
                    //$modulo = (int)$mod;
                    $alerta['registroProcesado'] = 1;
                    $alerta['direccion'] = 2;
                    $this->session->set_flashdata($alerta);
                    redirect('cotizaciones/mantenimientos/nuevo_cliente');
                    die();
                }
                if ($_POST['modulo_contratos']) {
                    $this->gsatelite->show_dialog('Cliente ingresado con éxito!', "modulo_contratos/catalogos/nuevo_cliente");
                }
                if ($_POST['facturacion']) {
                    //Si llega desde el modal de facturacion
                    if ($modal === '2') {
                        $this->gsatelite->show_dialog('Cliente ingresado con éxito!', "facturacion/entradas/nuevo_cliente/$modal");
                        // redirect('facturacion/entradas/nuevo_cliente');
                    } else {
                        $this->gsatelite->show_dialog('Cliente ingresado con éxito!', "facturacion/entradas/nuevo_cliente");
                    }
                }
                if ($_POST['cuentasxcobrar']) {
                    $this->gsatelite->show_dialog('Cliente ingresado con éxito!', "modulo_cuentas_cobrar/mantenimiento/nuevo_cliente");
                }
                $this->gsatelite->show_dialog('Cliente ingresado con éxito!', "cotizaciones/mantenimientos/nuevo_cliente$esmodal");
            } else {
                if ($_POST['modulo_contratos']) {
                    $this->gsatelite->show_dialog('Cliente ingresado con éxito!', "modulo_contratos/catalogos/clientes");
                }
                if ($_POST['facturacion']) {
                    $this->gsatelite->show_dialog('Cliente ingresado con éxito!', "facturacion/entradas/clientes");
                }
                if ($_POST['cuentasxcobrar']) {
                    $this->gsatelite->show_dialog('Cliente ingresado con éxito!', "modulo_cuentas_cobrar/mantenimiento/clientes");
                }
                if ($_POST['hdnBaseDatos'] != '') {
                    $this->gsatelite->show_dialog('Cliente ingresado con éxito!', "cotizaciones/cotizaciones/base_datos");
                }
                $this->gsatelite->show_dialog('Cliente ingresado con éxito!', "cotizaciones/mantenimientos/clientes$esmodal");
            }
        }
    }

    function gestion_impuestos($ruta = null)
    {
        satelite_validar();
        $ruta = (trim($ruta) != '') ? $ruta : 'cotizaciones/mantenimientos';
        $crud = new grocery_CRUD();
        // Variable para Permisos. Agreado por Luis Navarro
        $permisos = $this->gsatelite->get_permisos_opcion();
        $crud->set_table('imp_impuesto')
            ->set_subject('')
            ->columns('imp_nombre', 'imp_porcentaje', 'imp_valor', 'imp_estado')
            ->fields('imp_nombre', 'imp_porcentaje', 'imp_valor', 'imp_defecto', 'imp_estado', 'imp_usu_mod', 'imp_fecha_mod')
            ->display_as('imp_nombre', 'Nombre')
            ->display_as('imp_porcentaje', 'Porcentaje')
            ->display_as('imp_valor', 'Valor')
            ->display_as('imp_estado', 'Estado')
            ->display_as('imp_defecto', 'Aplicar por Defecto')
            ->required_fields('imp_nombre', 'imp_porcentaje', 'imp_valor', 'imp_estado', 'imp_defecto')
            ->set_rules('imp_nombre', 'Nombre', 'trim|required|campo_unico[imp_impuesto.imp_nombre]')
            ->set_rules('imp_porcentaje', 'Porcentaje', 'trim|required|is_numeric')
            ->field_type('imp_defecto', 'dropdown', array('1' => 'Sí', '0' => 'No'))
            ->field_type('imp_usu_mod', 'hidden', $this->tank_auth->get_user_id())
            ->field_type('imp_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
            ->unset_delete()
            ->unset_edit()
            ->unset_add();
        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('imp_estado', 'hidden', 1);
        } else {
            $crud->field_type('imp_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }
        // Validar Permisos. Agregado por Luis Navarro
        if ($permisos['permite_editar']) {
            $crud->add_action('Editar', 'icon16 icomoon-icon-pencil-5', $ruta . '/editar_impuesto');
        }
        // Se envia los permisos a la vista. Agregado por Luis Navarro
        $data['permisos'] = $permisos;
        $data['titulo_personal'] = "Impuestos";
        $data['ruta'] = $ruta;
        $output = $crud->render();
        cargarvista($data, $output, 'cotizaciones/mantenimientos/gestion_impuestos');
        //$this->_cargarvista($data, $output);
    }

    function editar_cliente($id_cliente = null, $esmodal = null, $otro_modulo = null, $traspaso = null){
        satelite_validar();
        // si el proceso viene de control sac[traspaso de cliente] mandamos variables[id del tbl flag] en la data para posteriormente hacer la asociacion 
        if (($traspaso != '') && ($id_cliente != '')) {
            $datos['es_traspaso']  = true;
            $id_tbl                = $traspaso;
            $datos['id_tbl']       = $id_tbl;
            $datos['cliente_id']   = $id_cliente;
        }
        $this->gsatelite->verificar_registro_real('cli_cliente', $id_cliente);

                            $this->db->join('mun_municipio', 'mun_id = cli_id_mun', 'left');
                            $this->db->join('dis_distrito', 'dis_id = cli_id_dis', 'left');
        $registro_cliente = $this->gsatelite->get_tabla('cli_cliente', array('cli_id' => $id_cliente));
        $id_vendedor = $registro_cliente[0]['cli_id_ven'];
        $datos['reg_cliente'] = $registro_cliente[0];
        //Mientras no esta el campo en la base solo se mostrara todos los bancos
        $datos["bancos"] = $this->gsatelite->get_dropdown('ban_banco', '{ban_nombre}', '', array('ban_estado' => 1), null, '', 'ban_id', true);
        //Contacto
        $datos['contactos'] = $this->gsatelite->get_tabla('con_contacto', array('con_id_cli' => $id_cliente, 'con_estado' => 1));
        //lista tipos
        //Referencias
        $datos['referencias'] = $this->gsatelite->get_tabla('rfc_referencia_cliente', array('rfc_id_cli' => $id_cliente, 'rfc_estado' => 1));
        //var_dump($datos['reg_cliente']); die();
        $datos['id_cliente'] = $id_cliente;
        $ven_seleccionado = null;
        $datos['anexos'] = $this->cotizaciones_model->anexo_cliente($id_cliente);
        //  Traerse los telefonos por cliente
        $datos['tel_cliente'] = $this->db->join('tit_tipo_telefono', 'tit_id=txc_id_tit')
            ->where('txc_id_cli', $id_cliente)
            ->get('txc_telefonoxcliente')->result_array();
        $datos['telefonos'] = $this->gsatelite->get_tabla('tit_tipo_telefono', array('tit_id >' => 0));

        $con_cliente = $this->gsatelite->get_tabla('cxl_condicionxcliente', array('cxl_id_cli' => $id_cliente, 'cxl_estado' => 1));
        $condicion_array = array();
        foreach ($con_cliente as $key => $value) {
            $condicion_array[] = $value['cxl_id_cod'];
        }
        $condiciones = $this->gsatelite->get_dropdown('tpg_tipo_pago', '{tpg_nombre}', '', array('tpg_estado' => '1'), $condicion_array, '', 'tpg_id', true);
        $datos["condicion_tabla"] = str_replace('<option value=""></option>', '', $condiciones);

        //preguntar si el usuario es supervisor o vendedor
        $condicion1 = array('sup_id_usu' => $this->tank_auth->get_user_id(), 'sup_estado' => 1);
        $esSup = $this->cotizaciones_model->Existe_Registro("sup_supervisor", $condicion1);
        $condicion2 = array('ven_id_usu' => $this->tank_auth->get_user_id(), 'ven_estado' => 1);
        $esVen = $this->cotizaciones_model->Existe_Registro("ven_vendedor", $condicion2);
        if ($esSup > 0) { //es supervisor
            $queryIdVen = $this->cotizaciones_model->get_idsVendedoresxSupervisor($this->tank_auth->get_user_id());
            $hay_coma = strpos($queryIdVen, ',');
            if (!$hay_coma === false) {
                if (!in_array($id_vendedor, (explode(',', $queryIdVen)))) {
                    $queryIdVen = "0";
                } else {
                    $ven_seleccionado = $id_vendedor;
                }
            } else {
                if ($id_vendedor != $queryIdVen) {
                    $queryIdVen = "0";
                } else {
                    $ven_seleccionado = $id_vendedor;
                }
            }

            $datos['ids_ven'] = $queryIdVen;
            $datos['ven_selec'] = $ven_seleccionado;
        } else if ($esVen > 0) { //es vendedor
            $ven_id = $this->gsatelite->get_campo('ven_vendedor', 'ven_id', array('ven_id_usu' => $this->tank_auth->get_user_id()));
            $ven_seleccionado = $ven_id;
            if ($id_vendedor != $ven_id) {
                $ven_id = "0";
                $ven_seleccionado = null;
                //$ven_id = $id_vendedor;
                //$ven_seleccionado = $id_vendedor;
            }
            $datos['ids_ven'] = $ven_id;
            $datos['ven_selec'] = $ven_seleccionado;
        } else {
            $datos['ids_ven'] = 0;
            $datos['ven_selec'] = null;
        }
        $datos['cuentas_clien'] = $this->gsatelite->get_tabla('cxn_cuentaxcliente', array('cxn_id_cli' => $id_cliente, 'cxn_estado' => 1));
        $datos['cuenta_conta'] = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_estado' => 1));
        $datos['titulo_personal'] = "Editar Cliente";
        $datos['esmodal'] = $esmodal;

        //Obtener los documentos para el select tipo de documento
        $datos['doc_documentos'] = $this->personal_model->get_documentos();
        $tipos_doc = $this->expediente_personal_model->get_dropdown('tde_tipo_documento', '{tde_nombre}', '', array('tde_estado' => 1), null, '', 'tde_id', true);
        $datos['options_tipo_documento'] = str_replace('<option value="0">Seleccione</option>', '', $tipos_doc);
        //Obtener documentos guardados
        $this->db->join('dcc_documento_cliente', 'tde_id = dcc_id_tde');
        $datos['documentosxcliente'] = $this->gsatelite->get_tabla('tde_tipo_documento', array('dcc_id_cli' => $id_cliente, 'dcc_estado' => 1));

        //Centro de costos
        $datos["centro_costo"] = $this->gsatelite->get_dropdown('cec_centro_costo', '{cec_nombre}', '', array('cec_estado' => 1), null, '', 'cec_id', true);
        //tipo de cuenta
        $datos["tipo_cuenta"] = $this->gsatelite->get_dropdown('tcn_tipo_cuenta', '{tcn_nombre}', '', array('tcn_estado' => 1), null, '', 'tcn_id', true);
        //cuenta contable
        $datos["cuen_con"] = $this->gsatelite->get_dropdown('cnt_cuenta_contable', '{cnt_nombre}', '', array('cnt_estado' => 1), null, '', 'cnt_id', true);

        $datos['cuentas_contables'] = $this->cotizaciones_model->get_cuentas_cliente(array('cxn_id_cli' => $id_cliente));

        //zona geografias
        $datos["zonas"]     = $this->gsatelite->get_tabla("zog_zona_geografica", array("zog_estado" => 1));

        //Tipo lista precio
        $idstpn = [];
        $id_para_opt = [];
        $this->db->join('cli_cliente', 'cli_id = tpn_id_cli');
        $idtpn_res = $this->gsatelite->get_tabla('tpn_tipo_precio_cliente', array('tpn_id_cli' => $id_cliente));
        //print_r($idtpn_res); die();
        $idtlp = (count($idtpn_res) > 0) ? $idtpn_res[0]['tpn_id_tlp'] : 0;
        foreach ($idtpn_res as $key => $idtpn_re) {
            array_push($idstpn, $idtpn_re['tpn_id']);
            array_push($id_para_opt, $idtpn_re['tpn_id_tlp']);
        }
        //$idtpn = (count($idtpn_res) > 0) ? $idtpn_res[0]['tpn_id'] : 0;
        $datos['idtlp'] = $idtlp;
        $datos['idstpn'] = $idstpn;
        $datos['id_para_opt'] = $id_para_opt;
        //cargar tipos de telefonos
        $etiquetas  = $this->gsatelite->get_tabla('con_contacto', array('con_id_cli' => $id_cliente));
        //$idsEtiquetas  = array_column($etiquetas, 'con_id_tit');
        $select = array();
        foreach ($etiquetas as $cont) {
            $select_temp  = $this->gsatelite->get_dropdown('tit_tipo_telefono', 'tit_nombre', 'etiquetas', array('tit_estado' => 1), $cont['con_id_tit'], null, null, true);
            $select[$cont['con_id']] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Regristros</option>'), '', $select_temp);
        }
        $datos['etiquetasX'] = $select;
        $select_temp  = $this->gsatelite->get_dropdown('tit_tipo_telefono', 'tit_nombre', 'etiquetas', array('tit_estado' => 1), null, null, null, true);
        $datos['etiquetasX2']  = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Regristros</option>'), '', $select_temp);
        $datos["fotos"] = $this->gsatelite->get_tabla('cli_cliente', array('cli_id' => $id_cliente));
        $datos['departamentos'] = $this->gsatelite->get_tabla('dep_departamento', array('dep_estado' => 1));
        if ($esmodal) {
            $this->gsatelite->cargar_vista_masterpage('cotizaciones/mantenimientos/editar_cliente', $datos);
        } else {
            if ($otro_modulo)
                return $datos;
            $this->_cargarvista($datos);
        }
    }

    function guardar_edit_cliente()
    {
        if ($_POST) {
            // var_dump($_POST);die();
            //===========================================================================================//
            //si viene la variable de traspaso de cliente se procede a realizar la asociacion
            //+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
            $id_cliente = $this->input->post('id_cliente');
            $id_tbl_assoc  = ($this->input->post('tbl_id') != '') ? $this->input->post('tbl_id') : null;
            if ($id_tbl_assoc) {
                $this->gsatelite->actualizar_array('tbl_tabla_llamadas', array('tbl_id_cli' => $id_cliente), array('tbl_id' => $id_tbl_assoc));
            }
            $esmodal = $this->input->post('es_edicion_modal');
            $foto_anterior = (file_exists($_POST['id_foto']) && $_POST['imagen_defecto'] == 0) ? $_POST['id_foto'] : null;

            //validacion de los dias plazo
            $tipo_vencimiento   = $this->input->post('slc_tipo_vencimiento');
            $tipo_vencimiento   = ($tipo_vencimiento == "") ? null : $tipo_vencimiento;
            $dias_plazo         = null;

            if ($tipo_vencimiento  == 1) {
                $txt_dias_plazo =  $this->input->post('txt_dias_plazo');
                $dias_plazo = ($txt_dias_plazo != "" and is_numeric($txt_dias_plazo)) ? $txt_dias_plazo : null;
            } else if ($tipo_vencimiento  == 2) {
                $slc_dia_especifico =  $this->input->post('slc_dia_especifico');
                $dias_plazo = ($slc_dia_especifico != "" and is_numeric($slc_dia_especifico)) ? $slc_dia_especifico : null;
            } else {
                $tipo_vencimiento = null;
            }

            $detalle = array(
                'cli_codigo' => (trim($this->input->post('codigo_cli')) != "") ? trim($this->input->post('codigo_cli')) : "",
                'cli_id_sec' => ($this->input->post('sector') != "") ? $this->input->post('sector') : null,
                'cli_id_cac' => ($this->input->post('cartera') != "") ? $this->input->post('cartera') : null,
                'cli_id_ven' => ($this->input->post('vendedor') != "") ? $this->input->post('vendedor') : null,
                'cli_apellido' => trim($this->input->post('apellidos')),
                'cli_nombre' => trim($this->input->post('nombres')),
                'cli_nombre_comercio' => ($this->input->post('nom_comercial')),
                'cli_personeria' => $this->input->post('personeria'),
                'cli_id_pro' => ($_POST['ocupacion']) ? $this->input->post('ocupacion') : null,
                'cli_lugar_trabajo' => ($_POST['lugar_trabajo']) ? $_POST['lugar_trabajo'] : null,
                'cli_cargo' => ($_POST['cargo']) ? $_POST['cargo'] : null,
                'cli_persona_aut' => $_POST['persona_autorizada'],
                'cli_observacion' => $this->input->post('observ'),
                'cli_id_rtc' => ($this->input->post('ruta_cliente') != "") ? $this->input->post('ruta_cliente') : null,
                'cli_id_mun' => (!empty($_POST['municipio'])) ? $_POST['municipio'] : null,
                'cli_id_dis' => ($_POST['distrito'] > 0) ? $_POST['distrito'] : NULL,                
                'cli_id_tif' => ($_POST['comprobante']) ? $_POST['comprobante'] : null,
                'cli_factura_elect' => (isset($_POST['factura_electronica'])) ? 1 : null,
                'cli_id_pai' => ($_POST['nacionalidad']) ? $_POST['nacionalidad'] : null,
                'cli_id_tpg' => ($_POST['condicion'] != '') ? $_POST['condicion'] : null,
                'cli_id_frp' => ($_POST['slc_forma_pago'] != '') ? $_POST['slc_forma_pago'] : null,
                'cli_sitio_web' => $this->input->post('sitio_web'),
                'cli_es_gran_contribuyente' => $this->input->post('hdngranCont'),
                'cli_email' => $this->input->post('correo'),
                'cli_usu_mod' => $this->tank_auth->get_user_id(),
                'cli_fecha_mod' => date('Y-m-d H:i:s'),
                'cli_direccion' => $this->input->post('direccion_cli'),
                'cli_id_tpc' => ($this->input->post('tip_cliente') != "") ? $this->input->post('tip_cliente') : null,
                'cli_id_gir' => ($this->input->post('giro') != "") ? $this->input->post('giro') : null,
                'cli_representante' => ($_POST['representante']) ? $_POST['representante'] : null,
                'cli_registro' => ($_POST['registro']) ? $_POST['registro'] : null,
                'cli_fotografia' => ($this->input->post('foto_empleado') != "") ? "uploads/anexos_cliente/" . $this->input->post('foto_empleado') : $foto_anterior,
                'cli_fecha_nacimiento' => ($_POST['txt_fecha_nacimiento'] != "") ? formatear_fecha('Y-m-d', $_POST['txt_fecha_nacimiento']) : null,
                'cli_fecha_registro' => ($_POST['txt_fecha_registro'] != "") ? $_POST['txt_fecha_registro'] : null,
                'cli_id_cfc' => ($_POST['slc_clasificacion'] != "") ? $_POST['slc_clasificacion'] : null,
                'cli_dias_plazo'          => $dias_plazo,
                'cli_monto_credito'       => ($_POST['txt_monto_credito'] != "") ? $_POST['txt_monto_credito'] : null,
                'cli_nombre_factura'      => ($_POST['txt_nombre_factura'] != "") ? $_POST['txt_nombre_factura'] : null,
                'cli_descuento_sugerido'  => ($_POST['txt_descuento_sugerido'] != "") ? $_POST['txt_descuento_sugerido'] : 0,
                'cli_estado'              => ($_POST['slc_estado'] != "") ? $_POST['slc_estado'] : 0,
                'cli_id_zog'              => ($_POST['slc_zona_geografica'] != "") ? $_POST['slc_zona_geografica'] : null,
                'cli_tipo_fac_vence'      => $tipo_vencimiento,
                'cli_id_ban'            => ($_POST['slc_banco_paga'] != "") ? $_POST['slc_banco_paga'] : null,
                'cli_encargado_pago'      => ($_POST['txt_encargado_pago'] != "") ? $_POST['txt_encargado_pago'] : null,
                'cli_comentario_finanzas' => ($_POST['txt_comentario_adicional'] != "") ? $_POST['txt_comentario_adicional'] : null,
                'cli_suspender_facturacion' => $_POST['hdn_suspende_fact']
            ); //var_dump($detalle);die();
            $this->gsatelite->actualizar_array('cli_cliente', $detalle, array('cli_id' => $id_cliente));

            //Actualizar Tipo lista precio
            //$idtpn_array = explode(',', $this->input->post('idtpn'));
            $idtlp_array = $this->input->post('slc_tipo_lista_precio');

            $this->gsatelite->borrado_general('tpn_tipo_precio_cliente', array('tpn_id_cli' => $id_cliente));
            foreach ($idtlp_array as $key => $idtlp_elem) {
                $tpn_array = array(
                    'tpn_id_cli' => $id_cliente,
                    'tpn_id_tlp' => $idtlp_elem,
                    'tpn_estado' => 1,
                    'tpn_usu_creacion' => $this->tank_auth->get_user_id(),
                    'tpn_fecha_creacion' => date('Y-m-d H:i:s'),
                    'tpn_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'tpn_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                $this->gsatelite->ingresar('tpn_tipo_precio_cliente', $tpn_array);
            }

            // Guardar los numeros de telefono
            $telefonos = $this->input->post('medios_contacto');
            $telefonos_valor = $this->input->post('medio');
            $telefonos_valor = ($_POST['medio'] != "") ? $_POST['medio'] : null;
            // die(print_r($telefonos_valor));
            $this->gsatelite->borrado_general('txc_telefonoxcliente', array('txc_id_cli' => $id_cliente));
            for ($i = 0; $i < count($telefonos); $i++) {
                if ($telefonos[$i] > 0) {
                    $cadena = array(
                        'txc_id_cli' => $id_cliente,
                        'txc_id_tit' => $telefonos[$i],
                        'txc_numero' => $telefonos_valor[$i],
                        'txc_estado' => 1,
                        'txc_usu_mod' => $this->tank_auth->get_user_id(),
                        'txc_fecha_mod' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->ingresar('txc_telefonoxcliente', $cadena);
                }
            }

            $this->gsatelite->borrado_general('ixc_impuestoxcliente', array('ixc_id_cli' => $id_cliente));
            $imp_clientes = $this->input->post('impuestos_cliente');
            for ($j = 0; $j < count($imp_clientes); $j++) {
                if ($imp_clientes[$j] > 0) {
                    $arreglo_imp = array(
                        'ixc_id_cli' => $id_cliente,
                        'ixc_id_imp' => $imp_clientes[$j],
                        'ixc_aplica'            => 1,
                        'ixc_estado'            => 1,
                        'ixc_usu_creacion'      => $this->tank_auth->get_user_id(),
                        'ixc_fecha_creacion'    => date('Y-m-d H:i:s'),
                        'ixc_usu_modificacion'  => $this->tank_auth->get_user_id(),
                        'ixc_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->ingresar('ixc_impuestoxcliente', $arreglo_imp);
                }
            }

            //se ingresaran los impuestos que no aplicara al cliente.
            $imp_clientes_no = $this->input->post('no_impuestos_cliente');
            foreach ($imp_clientes_no as $imp_cliente_no) {
                $arreglo_imp_no = array(
                    'ixc_id_cli'            => $id_cliente,
                    'ixc_id_imp'            => $imp_cliente_no,
                    'ixc_aplica'            => 0,
                    'ixc_estado'            => 1,
                    'ixc_usu_creacion'      => $this->tank_auth->get_user_id(),
                    'ixc_fecha_creacion'    => date('Y-m-d H:i:s'),
                    'ixc_usu_modificacion'  => $this->tank_auth->get_user_id(),
                    'ixc_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                $this->gsatelite->ingresar('ixc_impuestoxcliente', $arreglo_imp_no);
            }

            //se ingresaran los retenciones del cliente.
            $this->gsatelite->borrado_general('rxc_retencionxcliente', array('rxc_id_cli' => $id_cliente));
            $retenciones_cliente = $this->input->post('retenciones_cliente');
            foreach ($retenciones_cliente as $retencion_cliente) {
                $arreglo_cli_ret = array(
                    'rxc_id_cli'            => $id_cliente,
                    'rxc_id_ret'            => $retencion_cliente,
                    'rxc_estado'            => 1,
                    'rxc_usu_creacion'      => $this->tank_auth->get_user_id(),
                    'rxc_fecha_creacion'    => date('Y-m-d H:i:s'),
                    'rxc_usu_modificacion'   => $this->tank_auth->get_user_id(),
                    'rxc_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                $this->gsatelite->ingresar('rxc_retencionxcliente', $arreglo_cli_ret);
            }


            //Cuentas Contables
            $detalleCuentas = $this->input->post('hdnCuentaProv');
            $centrosCosto = $this->input->post('centrosCosto');
            $cuentaContable = $this->input->post('cuentaContable');
            $tipoCuentas = $this->input->post('tipoCuentas');
            $tipo_pago      = $this->input->post('tipo_pago');
            $formas_de_pago = $this->input->post('forma_pago_cxn');

            //Se obtienen las Cuentas guardadas, si existen se verifica si se eliminara
            $dataCuentas = $this->gsatelite->get_tabla('cxn_cuentaxcliente', array('cxn_id_cli' => $id_cliente));
            if (!is_array($detalleCuentas)) {
                $detalleCuentas = array();
            }
            foreach ($dataCuentas as $data) {
                if (!in_array($data['cxn_id'], $detalleCuentas)) {
                    $this->gsatelite->borrado_general('cxn_cuentaxcliente', array('cxn_id' => $data['cxn_id']));
                }
            }
            //Cuentas Contables
            if (count($centrosCosto) > 0 && $centrosCosto != '') {
                for ($i = 0; $i < count($centrosCosto); $i++) {
                    $cuentas_array = array(
                        'cxn_id_cli'    => $id_cliente,
                        'cxn_id_cnt'    => $cuentaContable[$i],
                        'cxn_id_tcn'    => $tipoCuentas[$i],
                        'cxn_id_cec'    => $centrosCosto[$i],
                        'cxn_id_tpg'    => $tipo_pago[$i],
                        'cxn_id_frp'    => $formas_de_pago[$i],
                        'cxn_estado'    => 1,
                        'cxn_usu_crea'  => $this->tank_auth->get_user_id(),
                        'cxn_fecha_crea' => date('Y-m-d H:i:s'),
                        'cxn_usu_mod'   => $this->tank_auth->get_user_id(),
                        'cxn_fecha_mod' => date('Y-m-d H:i:s'),
                    );
                    $this->gsatelite->ingresar('cxn_cuentaxcliente', $cuentas_array);
                }
            }

            // Agregar los Anexos por cliente
            $rutas = $this->input->post("ruta");
            $carpeta = $this->input->post("nombreCarpeta");

            if (count($rutas) > 0) {
                $carpeta = $carpeta;
                for ($i = 0; $i < count($rutas); $i++) {
                    if ($rutas[$i] != "") {
                        $img = $rutas[$i];
                        $titulo = $this->input->post("titulo_doc" . $i);
                        $this->datos_imagen_gral($img, $id_cliente, $carpeta, $titulo);
                    }
                }
            }

            $this->gsatelite->borrado_general('cxm_clientexmediocontacto', array('cxm_id_cli' => $id_cliente));
            $medio_contacto = $this->input->post('medio_contacto');
            for ($i = 0; $i < count($medio_contacto); $i++) {
                if ($medio_contacto[$i] > 0) {
                    $this->gsatelite->ingresar('cxm_clientexmediocontacto', array('cxm_id_cli' => $id_cliente, 'cxm_id_tmc' => $medio_contacto[$i]));
                }
            }

            /***********************Inicio ficha contacto************************/
            //Contacto
            $new = $this->input->post('txtTablaNew');
            $contacto_nombre = $this->input->post('contacto_nombre');
            $contacto_apellido = $this->input->post('contacto_apellido');
            $contacto_cargo = $this->input->post('contacto_cargo');
            $contacto_telefono = $this->input->post('contacto_telefono');
            $contacto_email = $this->input->post('contacto_email');
            $tipo_telefono  = $this->input->post('tip_telefono');

            //obtener los detalles antiguos
            $contactos_antiguos = $this->gsatelite->get_tabla('con_contacto', array('con_id_cli' => $id_cliente));

            //eliminacion de detalles que no existen
            foreach ($contactos_antiguos as $con) {
                if (!in_array($con['con_id'], $new)) {
                    $this->gsatelite->actualizar_array('con_contacto', array('con_estado' => 0), array('con_id' => $con['con_id']));
                }
            }
            foreach ($contacto_nombre as $key => $value) {
                if (trim($value)) {
                    if ($new[$key] == "") {
                        $array_con = array(
                            'con_id_cli'        => $id_cliente,
                            'con_id_tit'     => ($tipo_telefono[$key] > 0) ? $tipo_telefono[$key] : null,
                            'con_nombre'        => ($value != '') ? $value : null,
                            'con_apellidos'     => ($contacto_apellido[$key] != '') ? $contacto_apellido[$key] : "",
                            'con_cargo'         => ($contacto_cargo[$key] != '') ? $contacto_cargo[$key] : null,
                            'con_telefono'      => ($contacto_telefono[$key] != '') ? $contacto_telefono[$key] : null,
                            'con_email'         => ($contacto_email[$key] != '') ? $contacto_email[$key] : null,
                            'con_estado'        => 1,
                            'con_usu_mod'       => $this->tank_auth->get_user_id(),
                            'con_fecha_mod'     => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('con_contacto', $array_con);
                    } else {
                        $array_con = array(
                            'con_id_cli'        => $id_cliente,
                            'con_id_tit'        => ($tipo_telefono[$key] > 0) ? $tipo_telefono[$key] : null,
                            'con_nombre'        => ($value != '') ? $value : null,
                            'con_apellidos'     => ($contacto_apellido[$key] != '') ? $contacto_apellido[$key] : "",
                            'con_cargo'         => ($contacto_cargo[$key] != '') ? $contacto_cargo[$key] : null,
                            'con_telefono'      => ($contacto_telefono[$key] != '') ? $contacto_telefono[$key] : null,
                            'con_email'         => ($contacto_email[$key] != '') ? $contacto_email[$key] : null,
                            'con_estado'        => 1,
                            'con_usu_mod'       => $this->tank_auth->get_user_id(),
                            'con_fecha_mod'     => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->actualizar_array('con_contacto', $array_con, array('con_id' => $new[$key]));
                    }
                }
            }
            /**********************Fin ficha contacto************************/

            /***********************Inicio ficha documento************************/
            //Contacto
            $new = $this->input->post('txtTablaNewDoc');
            $documento = $this->input->post('documento');
            $numero_documento = $this->input->post('numero_documento');
            $vence_documento = $this->input->post('vence_documento');
            $fecha_exp_doc = $this->input->post('fecha_exp_doc');
            $lugar_exp_doc = $this->input->post('lugar_exp_doc');
            $nombre_anexo_doc = $this->input->post('nombre_anexo_doc');
            $titulo_anexo_doc = $this->input->post('titulo_anexo_doc');


            //obtener los documentos antiguos
            $documentos_antiguos = $this->gsatelite->get_tabla('dcc_documento_cliente', array('dcc_id_cli' => $id_cliente, 'dcc_estado' => 1));
            //eliminacion de detalles que no existen

            //print_r($new);

            foreach ($documentos_antiguos as $doc) {
                if (!in_array($doc['dcc_id'], $new)) {
                    $this->gsatelite->actualizar_array('dcc_documento_cliente', array('dcc_estado' => 0), array('dcc_id' => $doc['dcc_id']));
                    $this->eliminar_imagen_gral2($doc['dcc_url']);
                } //else{
                // $this->eliminar_imagen_gral2($doc['dcc_url']);
                //}
            }

            foreach ($documento as $key => $value) {
                if (trim($value)) {
                    if ($new[$key] == "") {
                        $array_doc = array(
                            'dcc_id_tde'            => $documento[$key],
                            'dcc_id_cli'            => $id_cliente,
                            'dcc_valor'             => ($numero_documento[$key] != '') ? $numero_documento[$key] : null,
                            'dcc_fecha_vence'       => ($vence_documento[$key] != '') ? formatear_fecha('Y-m-d', $vence_documento[$key]) : null,
                            'dcc_nombre_anexo'      => ($titulo_anexo_doc[$key] != '') ? $titulo_anexo_doc[$key] : null,
                            'dcc_url'               => ($nombre_anexo_doc[$key] != '') ? $nombre_anexo_doc[$key] : null,
                            'dcc_fecha_expedicion'  => ($fecha_exp_doc[$key] != '') ? formatear_fecha('Y-m-d', $fecha_exp_doc[$key]) : null,
                            'dcc_lugar_expedicion'  => ($lugar_exp_doc[$key] != '') ? $lugar_exp_doc[$key] : null,
                            'dcc_estado'            => 1,
                            'dcc_usu_crea'          => $this->tank_auth->get_user_id(),
                            'dcc_fecha_crea'        => date('Y-m-d H:i:s'),
                            'dcc_usu_mod'           => $this->tank_auth->get_user_id(),
                            'dcc_fecha_mod'         => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('dcc_documento_cliente', $array_doc);
                    } else {
                        $array_doc = array(
                            'dcc_id_tde'            => $documento[$key],
                            'dcc_id_cli'            => $id_cliente,
                            'dcc_valor'             => ($numero_documento[$key] != '') ? $numero_documento[$key] : null,
                            'dcc_fecha_vence'       => ($vence_documento[$key] != '') ? formatear_fecha('Y-m-d', $vence_documento[$key]) : null,
                            'dcc_nombre_anexo'      => ($titulo_anexo_doc[$key] != '') ? $titulo_anexo_doc[$key] : null,
                            'dcc_url'               => ($nombre_anexo_doc[$key] != '') ? $nombre_anexo_doc[$key] : null,
                            'dcc_fecha_expedicion'  => ($fecha_exp_doc[$key] != '') ? formatear_fecha('Y-m-d', $fecha_exp_doc[$key]) : null,
                            'dcc_lugar_expedicion'  => ($lugar_exp_doc[$key] != '') ? $lugar_exp_doc[$key] : null,
                            'dcc_estado'            => 1,
                            //'con_usu_ingreso'   => $this->tank_auth->get_user_id(),
                            //'con_fecha_ingreso' => date('Y-m-d H:i:s'),
                            'dcc_usu_mod'           => $this->tank_auth->get_user_id(),
                            'dcc_fecha_mod'         => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->actualizar_array('dcc_documento_cliente', $array_doc, array('dcc_id' => $new[$key]));
                    }
                    $this->mover_img_gral('public/temp/archivos/', 'uploads/anexos_cliente', $nombre_anexo_doc[$key]);
                }
            }

            //$this->inicio->mover_img_gral( 'public/temp/archivos/', 'uploads/anexos_cliente/', ( $titulo_anexo_doc[$key] != '') ? $titulo_anexo_doc[$key] : null,);
            /**********************Fin ficha contacto************************/

            /**********************Inicio ficha referencia************************/
            //Referencia
            $new = $this->input->post('txtTablaNewRef');
            $referencia_nombre = $this->input->post('referencia_nombre_edit');
            $referencia_fijo = $this->input->post('referencia_fijo_edit');
            $referencia_movil = $this->input->post('referencia_movil_edit');
            $referencia_tipo = $this->input->post('referencia_tipo_edit');


            //obtener los detalles antiguos
            $referencias_antiguas = $this->gsatelite->get_tabla('rfc_referencia_cliente', array('rfc_id_cli' => $id_cliente));

            //eliminacion de detalles que no existen
            foreach ($referencias_antiguas as $ref) {
                if (!in_array($ref['rfc_id'], $new)) {
                    $this->gsatelite->actualizar_array('rfc_referencia_cliente', array('rfc_estado' => 0), array('rfc_id' => $ref['rfc_id']));
                }
            }

            foreach ($referencia_nombre as $key => $value) {
                if (trim($value)) {
                    if ($new[$key] == "") {
                        $array_ref = array(
                            'rfc_id_cli'        => $id_cliente,
                            'rfc_nombre'        => ($value != '') ? $value : null,
                            'rfc_tel_fijo'      => ($referencia_fijo[$key] != '') ? $referencia_fijo[$key] : null,
                            'rfc_tel_movil'     => ($referencia_movil[$key] != '') ? $referencia_movil[$key] : null,
                            'rfc_tipo'          => ($referencia_tipo[$key] != '') ? $referencia_tipo[$key] : null,
                            'rfc_estado'        => 1,
                            'rfc_usu_crea'   => $this->tank_auth->get_user_id(),
                            'rfc_fecha_crea' => date('Y-m-d H:i:s'),
                            'rfc_usu_mod'       => $this->tank_auth->get_user_id(),
                            'rfc_fecha_mod'     => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('rfc_referencia_cliente', $array_ref);
                    } else {
                        $array_ref = array(
                            'rfc_id_cli'     => $id_cliente,
                            'rfc_nombre'     => ($value != '') ? $value : null,
                            'rfc_tel_fijo'   => ($referencia_fijo[$key] != '') ? $referencia_fijo[$key] : null,
                            'rfc_tel_movil'  => ($referencia_movil[$key] != '') ? $referencia_movil[$key] : null,
                            'rfc_tipo'       => ($referencia_tipo[$key] != '') ? $referencia_tipo[$key] : null,
                            'rfc_estado'     => 1,
                            'rfc_usu_mod'    => $this->tank_auth->get_user_id(),
                            'rfc_fecha_mod'  => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->actualizar_array('rfc_referencia_cliente', $array_ref, array('rfc_id' => $new[$key]));
                    }
                }
            }


            if ($this->input->post('foto_empleado') != "" and $this->input->post('titulo_foto_empleado') != "") { //guardar la foto del eclienteleado
                $titulo = $this->input->post('titulo_foto_empleado');
                $img = $this->input->post('foto_empleado');
                $this->datos_imagen_gral2($img, $id_emp, 'uploads/anexos_cliente/fotos/', $titulo, 1); //es de tipo foto
            }

            /**********************Fin ficha contacto************************/

            $tipo_boton = $this->input->post('btnCrear');
            //Se redirecciona en base al boton
            if ($tipo_boton == 1) {
                if ($_POST['facturacion']) {
                    $this->gsatelite->show_dialog('Cliente actualizado con éxito!', "facturacion/entradas/editar_cliente/" . $id_cliente);
                }
                if ($_POST['modulo_contratos']) {
                    $this->gsatelite->show_dialog('Cliente actualizado con éxito!', "modulo_contratos/catalogos/editar_cliente/" . $id_cliente);
                }
                if ($_POST['cuentasxcobrar']) {
                    $this->gsatelite->show_dialog('Cliente actualizado con éxito!', "modulo_cuentas_cobrar/mantenimiento/editar_cliente/" . $id_cliente);
                }
                $this->gsatelite->show_dialog('Cliente actualizado con éxito!', "cotizaciones/mantenimientos/editar_cliente/" . $id_cliente);
            } else {
                if ($_POST['modulo_contratos']) {
                    $this->gsatelite->show_dialog('Cliente actualizado con éxito!', "modulo_contratos/catalogos/clientes");
                }
                if ($_POST['facturacion']) {
                    $this->gsatelite->show_dialog('Cliente actualizado con éxito!', "facturacion/entradas/clientes");
                }
                if ($_POST['cuentasxcobrar']) {
                    $this->gsatelite->show_dialog('Cliente actualizado con éxito!', "modulo_cuentas_cobrar/mantenimiento/clientes");
                }
                $this->gsatelite->show_dialog('Cliente actualizado con éxito!', "cotizaciones/mantenimientos/clientes$esmodal");
            }
        }
    }

    function articulo()
    {
        satelite_validar();

        $this->load->library('../controllers/inventario/mantenimiento');
        $permisos = $this->gsatelite->get_permisos_opcion('cotizaciones/mantenimientos/articulo');
        $this->mantenimiento->articulo('Catálogo de productos', 'cotizaciones', $permisos, "cotizaciones/mantenimientos");
    }

    function agregar_articulo()
    {
        satelite_validar();
        $this->load->library('../controllers/inventario/mantenimiento');
        $this->mantenimiento->agregar_articulo('3', true, 'cotizaciones/mantenimientos');

        /*
        satelite_validar();
        $this->load->library('../controllers/inventario/mantenimiento');
        $info = $this->mantenimiento->agregar_articulo(null, true, 'cotizaciones/mantenimientos');
        $data['html'] = $this->load->view('inventario/mantenimiento/agregar_articulo', $info, true);
        $this->_cargarvista(null, $data);*/
    }

    function duplicar_articulo($id_art)
    {
        satelite_validar();
        $this->load->library('../controllers/inventario/mantenimiento');
        $permisos = $this->gsatelite->get_permisos_opcion('cotizaciones/mantenimientos/articulo');
        $this->mantenimiento->duplicar_articulo($id_art, "cotizaciones/mantenimientos");
    }

    function guardar_articulo()
    {
        satelite_validar();
        $this->load->library('../controllers/inventario/mantenimiento');
        $this->mantenimiento->guardar_articulo('cotizaciones/mantenimientos');
    }


    function editar_articulo($id_art)
    {
        satelite_validar();
        $this->load->library('../controllers/inventario/mantenimiento');
        $this->mantenimiento->editar_articulo($id_art, 7, 'cotizaciones/mantenimientos');
        /*
        satelite_validar();
        $this->load->library('../controllers/inventario/mantenimiento');
        $info = $this->mantenimiento->editar_articulo($id_art, '7', 'cotizaciones/mantenimientos');
        $data['html'] = $this->load->view('inventario/mantenimiento/editar_articulo', $info, true);

        $this->_cargarvista(null, $data);*/
    }

    function precios_articulo($id_art)
    {

        satelite_validar();
        $this->gsatelite->verificar_registro_real('art_articulo', $id_art);
        $id_art = $this->uri->segment(4);

        $crud = new grocery_CRUD();

        // Filtro
        $where = null;

        $data['id_articulo'] = ($id_art > 0) ? $id_art : 0;
        // Verificar si vienen datos por POST
        if ($this->input->post()) {
            $tipo = $this->input->post('slcTipo');
            if ($tipo > 0) {
                $where['tlp_id'] = $tipo;
            }
        } // else {
        //     $where['tlp_id'] = null;
        // }
        // Verificar si se ha definido
        if (isset($where)) {
            $crud->where($where);
        }

        $add_fields = array(
            'lip_id_art',
            'lip_id_tlp',
            'lip_desde',
            'lip_hasta',
            'lip_descuento_min',
            'lip_descuento_max',
            'lip_precio',
            'lip_id_mep',
            'lip_ultimo_prec_compra',
            'lip_variacion_utilidad',
            'lip_estado',
            'lip_usu_creacion',
            'lip_fecha_creacion',
            'lip_usu_modificacion',
            'lip_fecha_modificacion'
        );

        $edit_fields = array(
            'lip_id_art',
            'lip_id_tlp',
            'lip_desde',
            'lip_hasta',
            'lip_descuento_min',
            'lip_descuento_max',
            'lip_precio',
            'lip_id_mep',
            'lip_ultimo_prec_compra',
            'lip_variacion_utilidad',
            'lip_estado',
            'lip_usu_modificacion',
            'lip_fecha_modificacion'
        );

        $colum_fields = array(
            'lip_desde',
            'lip_hasta',
            'lip_precio',
            'lip_descuento_min',
            'lip_descuento_max',
            'lip_id_tlp',
            'lip_estado'
        );

        $required = array(
            'lip_id_tlp',
            'lip_id_art',
            'lip_desde',
            'lip_hasta',
            'lip_precio',
            'lip_estado',
            'lip_id_mep',
            'lip_descuento_min',
            'lip_descuento_max'
        );

        $display_as = array(
            'lip_desde'         => 'Cantidad Desde',
            'lip_hasta'         => 'Cantidad Hasta',
            'lip_descuento_min' => 'Porcentaje Minimo',
            'lip_descuento_max' => 'Porcentaje Maximo',
            'lip_precio'        => 'Precio',
            'lip_ultimo_prec_compra' => 'Precio última compra',
            'lip_variacion_utilidad' => '% Variación utilidad',
            'lip_estado'        => 'Estado',
            'lip_id_mep'        => 'Unidad',
            'lip_id_tlp'        => 'Tipo lista'
        );

        $crud->set_table('lip_listado_precio')
            //->set_subject('Precio Producto')
            ->set_subject('')
            ->where('lip_id_art', $id_art)
            ->columns($colum_fields)
            ->add_fields($add_fields)
            ->edit_fields($edit_fields)
            ->display_as($display_as)
            ->set_relation('lip_id_tlp', 'tlp_tipo_lista_precio', '{tlp_nombre}', array('tlp_estado' => 1))
            ->required_fields($required)
            ->set_rules('lip_desde', 'Cantidad Desde', 'trim|is_numeric|required|callback_validacion_rango|callback_validar_cant_desde_hasta_lista')
            ->set_rules('lip_hasta', 'Cantidad Hasta', 'trim|required|is_numeric')
            ->set_rules('lip_descuento_min', 'Porcentaje Minimo', 'trim|required|is_numeric')
            ->set_rules('lip_descuento_max', 'Porcentaje Maximo', 'trim|required|is_numeric')
            ->set_rules('lip_precio', 'Precio', 'trim|required|is_numeric')
            ->field_type('lip_id_art', 'hidden', $id_art)
            ->field_type('lip_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
            ->field_type('lip_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
            ->unset_delete();
        $crud->callback_edit_field('lip_id_mep', array($this, 'edit_lip_id_mep_for_article'));
        $crud->callback_add_field('lip_id_mep', array($this, 'edit_lip_id_mep_for_article'));
        //$crud->set_relation('lip_id_mep', 'mep_medida_producto', '{mep_codigo} - {mep_nombre}', array('mep_estado' => '1'));
        if (end(explode('/', uri_string())) == 'add') {
            //
            $crud->field_type('lip_estado', 'hidden', 1);
            $crud->field_type('lip_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('lip_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
        } else {  // Editar
            $ids = $this->gsatelite->get_tabla('cva_conversion_articulo', array('cva_id_art' => $id_art));
            $array_days = array();
            $um_ligada_articulo = '';
            for ($i = 0; $i < count($ids); $i++) {
                array_push($array_days, $ids[$i]["cva_id_mep"]);
                $um_ligada_articulo .= $this->gsatelite->get_dropdown('mep_medida_producto', '{mep_nombre}', '', array('mep_estado' => '1', 'mep_id' => (int)$ids[$i]["cva_id_mep"]), null, '', 'mep_id', true);
                $um_ligada_articulo = str_replace('<option value="0">Seleccione</option>', '', $um_ligada_articulo);
            }
            //echo json_encode($um_ligada_articulo);
            //$crud->set_rules('lip_desde', 'Cantidad Desde', 'trim|is_numeric|required|validar_cant_desde_hasta_lista');
            $crud->set_relation('lip_id_mep', 'mep_medida_producto', '{mep_codigo} - {mep_nombre}', array('mep_estado' => '1'));
            $crud->field_type('lip_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }
        $name_articulo = $this->gsatelite->get_tabla('art_articulo', array('art_id' => $id_art));

        $data['titulo_personal'] = "Listado de Precios - " . $name_articulo[0]['art_nombre'];
        $data['registro_art'] = $this->gsatelite->get_registro('art_articulo', 'art_id', $id_art);

        // Enviar url
        $data['url'] = explode('/', uri_string());
        // Datos para filtro de tipo de lista
        $tipo_lista = $this->gsatelite->get_dropdown('tlp_tipo_lista_precio', '{tlp_nombre}', '', array('tlp_estado' => '1'), null, '', 'tlp_id', true);
        $data["tipo_lista"] = str_replace('<option value="0">Seleccione</option>', '', $tipo_lista);

        $output = $crud->render();
        $this->_cargarvista($data, $output);
        /*
        ------------------------
        satelite_validar();
        $this->gsatelite->verificar_registro_real('art_articulo', $id_art);
        // $crud = new grocery_CRUD();
        $crud = new grocery_CRUD();

        $add_fields = array(
            'lip_id_art',
            'lip_id_tlp',
            'lip_desde',
            'lip_hasta',
            'lip_precio',
            'lip_id_mep',
            'lip_estado',
            'lip_usu_creacion',
            'lip_fecha_creacion',
            'lip_usu_modificacion',
            'lip_fecha_modificacion'
        );

        $edit_fields = array(
            'lip_id_art',
            'lip_id_tlp',
            'lip_desde',
            'lip_hasta',
            'lip_precio',
            'lip_id_mep',
            'lip_estado',
            'lip_usu_modificacion',
            'lip_fecha_modificacion'
        );

        $crud->set_table('lip_listado_precio')
                ->set_subject('Precio Producto')
                ->where('lip_id_art', $id_art)
                ->columns('lip_desde', 'lip_hasta', 'lip_precio', 'lip_estado')
                ->add_fields($add_fields)
                ->edit_fields($edit_fields)
                ->display_as('lip_desde', 'Cantidad Desde')
                ->display_as('lip_hasta', 'Cantidad Hasta')
                ->display_as('lip_precio', 'Precio')
                ->display_as('lip_estado', 'Estado')
                ->display_as('lip_id_mep', 'Unidad')
                ->display_as('lip_id_tlp', 'Tipo lista')
                ->set_relation('lip_id_tlp', 'tlp_tipo_lista_precio', '{tlp_nombre}', array('tlp_estado' => 1))
                ->required_fields('lip_id_tlp','lip_id_art', 'lip_desde', 'lip_hasta', 'lip_precio', 'lip_estado', 'lip_id_mep')
                ->set_rules('lip_desde', 'Cantidad Desde', 'trim|is_numeric|required|callback_validacion_rango')
                ->set_rules('lip_hasta', 'Cantidad Hasta', 'trim|required|is_numeric')
                ->set_rules('lip_precio', 'Precio', 'trim|required|is_numeric')
                ->field_type('lip_id_art', 'hidden', $id_art)
                ->field_type('lip_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('lip_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
                ->unset_delete()
        ;
        $crud->set_relation('lip_id_mep', 'mep_medida_producto', 'mep_nombre', array('mep_estado' => '1'));
        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('lip_estado', 'hidden', 1);
            $crud->field_type('lip_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('lip_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
        } else {  // Editar
            $crud->field_type('lip_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }
        $data['titulo_personal'] = "Listado de Precios";
        $data['registro_art'] = $this->gsatelite->get_registro('art_articulo', 'art_id', $id_art);

        $output = $crud->render();
        $this->_cargarvista($data, $output);*/
    }

    function edit_lip_id_mep_for_article($value, $primary_key)
    {
        $id_art = $this->uri->segment(4);

        $ids = $this->gsatelite->get_tabla('cva_conversion_articulo', array('cva_id_art' => $id_art));
        $array_days = array();
        $um_ligada_articulo = '';
        for ($i = 0; $i < count($ids); $i++) {
            array_push($array_days, $ids[$i]["cva_id_mep"]);
            $um_ligada_articulo .= $this->gsatelite->get_dropdown('mep_medida_producto', '{mep_nombre}', '', array('mep_estado' => '1', 'mep_id' => (int)$ids[$i]["cva_id_mep"]), null, '', 'mep_id', true);
            $um_ligada_articulo = str_replace('<option value="0">Seleccione</option>', '', $um_ligada_articulo);
        }
        return '<select id="field-lip_id_mep" name="lip_id_mep" class="nostyle chosen-select" data-placeholder=" Unidad" style="width: 100%; display: none;">'
            . $um_ligada_articulo .
            '</select>';
        //'+30 <input type="text" maxlength="50" value="'.$value.'" name="phone" style="width:462px">';
    }

    public function articuaaasaslo()
    { //Necesita que le metan la foto
        satelite_validar();
        $titulo = "Catálogo de artículos";
        $this->load->library('../controllers/inventario/mantenimiento');
        $this->mantenimiento->articulo($titulo);
        //             try{
        //           $crud =  new grocery_CRUD();
        //                 //Columnas a mostrar en READ
        //           $columns = array(
        //             'art_codigo',
        //             'art_nombre',
        //             'art_id_tia',
        //             'caract'
        //             );
        //                 //Alias para las columnas
        //           $alias = array(
        //             'art_codigo' => 'Código',
        //             'art_nombre' => 'Nombre Artículo',
        //             'art_id_mep' => 'Medida',
        //             'art_minimo' => 'Mínimo',
        //             'art_maximo' => 'Máximo',
        //             'art_id_tia' => 'Padre',
        //             'art_foto'   => 'Foto de artículo',
        //             'art_estado' => 'Estado',
        //             'caract' => 'Características',
        //             'art_aplica_serie' => 'Aplica Serie',
        //             'art_codigo_proveedor'=>'Código fabrica',
        //             'propositos'=>'Tipo artículo'
        //             );
        //                 //Columnas a mostrar en ADD
        //           $add_columns = array(
        //             'art_id_tia',
        //             'art_nombre',
        //             'art_id_mep',
        //             'art_codigo',
        //             'art_codigo_proveedor',
        //             'art_minimo',
        //             'art_maximo',
        //             'art_foto',
        //             'propositos',
        //             'art_aplica_serie' ,
        //             'art_estado',
        //             'art_usu_mod',
        //             'art_fecha_mod',
        //             'art_fecha'
        //             );
        //                  //Columnas a mostrar en EDIT
        //           $edit_columns = array(
        //             'art_id_tia',
        //             'art_nombre',
        //             'art_id_mep',
        //             'art_codigo',
        //             'art_codigo_proveedor',
        //             'art_minimo',
        //             'art_maximo',
        //             'art_foto',
        //             'propositos',
        //             'art_aplica_serie' ,
        //             'art_estado',
        //             'art_usu_mod',
        //             'art_fecha_mod'
        //             );
        //           $req_columns = array(
        //             'art_id_tia',
        //             'art_nombre',
        //             'art_id_mep',
        //             'propositos',
        //             'art_aplica_serie',
        //             'art_estado'
        //             );
        //           $query_padres="SELECT DISTINCT tia_padre FROM tia_tipo_articulo";
        //           $padres=$this->db->query($query_padres)->result_array();
        //           $cadena_in="";
        //           foreach ($padres as $key => $value) {
        //             if($value['tia_padre'] != ""){
        //               $cadena_in.=$value['tia_padre'].",";
        //             }
        //           }
        //           $cadena_final=substr($cadena_in,0,-1);
        //           if($cadena_final == '')
        //           {
        //             $cadena_final=0;
        //           }
        //           $query_no_tienen_hijos="SELECT tia_id FROM tia_tipo_articulo WHERE tia_id NOT IN (".$cadena_final.")";
        //           $no_tienen_hijos=$this->db->query($query_no_tienen_hijos)->result_array();
        //           $cadena_in2="";
        //           foreach ($no_tienen_hijos as $key2 => $value2) {
        //             if($value2['tia_id'] != ""){
        //               $cadena_in2.=$value2['tia_id'].",";
        //             }
        //           }
        //           /*print_r($this->db->last_query());
        //           exit();*/
        //           $cadena_final2=substr($cadena_in2,0,-1);
        //           if($cadena_final2 == '')
        //           {
        //             $cadena_final2=0;
        //           }
        //           $crud->set_table('art_articulo')
        //           ->set_subject('Artículos')
        //           ->columns($columns)
        //           ->display_as($alias)
        //           ->add_fields($add_columns)
        //           ->edit_fields($edit_columns)
        //           ->required_fields($req_columns)
        //           ->set_field_upload('art_foto','assets/uploads/images')
        //           ->set_rules('art_nombre','Nombre','required')
        //           ->set_rules('art_id_tia','Categoría','required')
        //           ->set_rules('art_id_mep','Medida','required')
        //           ->set_relation('art_id_mep', 'mep_medida_producto', 'mep_nombre')
        //           ->set_relation('art_id_tia','tia_tipo_articulo','tia_nombre',"tia_id IN({$cadena_final2})")
        //           ->field_type('art_estado','dropdown',array('1'=>'Activo','0'=>'Inactivo'))
        //           ->field_type('art_aplica_serie','dropdown',array('1'=>'Sí','0'=>'No'))
        //           //->field_type('art_tipo_articulo','dropdown',array('1'=>'Para Venta','2'=>'Para Materia Prima','3'=>'Para Consumo'))
        //           ->set_relation_n_n('propositos','axp_articuloxproposito','pra_proposito_articulo','axp_id_art','axp_id_pra','pra_nombre')
        //           ->field_type('art_usu_mod','hidden',$this->tank_auth->get_user_id())
        //                     //->set_rules('art_nombre','Nombre','callback_username_check_insert4')
        //           ->field_type('art_fecha_mod','hidden',date('Y-m-d h:i:s'))
        //           ->add_action('Editar','icon16 icomoon-icon-pencil-5 ','inventario/mantenimiento/editar_articulo/3','blank')
        //           //->add_action('Caracteristicas','icon16 icomoon-icon-list-view','cotizaciones/mantenimiento/caracteristicasxarticulo','car_pro')
        //           ->field_type('art_fecha','hidden',date('Y-m-d h:i:s'))
        //           ->unset_edit()
        //         //  ->unset_add() este link sera modificado con js para que redireccione a la pantalla de agregar producto de inventario
        //           ->unset_delete()
        //           ;
        //           $crud->callback_column('caract',function($value,$row){
        //             if($row->art_id_tia){
        //               $where=array('cxr_id_tia'=>$row->art_id_tia,'cxr_estado'=>1);
        //                       $CI =& get_instance();
        //                       $consul = $CI->cotizaciones_model->get_carateristicas_matenimiento_articulo($where);
        // /*                      $CI->db->select('')
        //                       ->from('cxr_caractxtipo_articulo')
        //                       ->join('car_caracteristica','car_id=cxr_id_car')
        //                       ->where('car_modulo', 3)->where($where);//modulo tres es de cotizacion
        //                       $consulta=$CI->db->get();
        //                       $datos=$consulta->result_array();
        //                       $consul = $datos;
        // */
        //               $seleccionados =array();
        //               foreach ($consul as $f) {  $seleccionados[] = $f['car_nombre'];  }
        //               return implode(',', $seleccionados);
        //             } else { return ''; }
        //             });
        //           $output = $crud->render();
        //           $data['titulo_personal'] ="Gestión de Artículos";
        //           $this->_cargarvista($data,$output);
        //         }
        //         catch(Exception $e){
        //           show_error($e->getMessage().' --- '.$e->getTraceAsString());
        //         }
    }

    /**
     * Actualizado por: Edith Herrera
     * @date 18/01/2016
     * @description : Se creó una instancia al controlador de inventario para acceder a este catálogo
     * y así evitar duplicación de catálogos en los módulos.
     * @modify by: Mario Marquez
     * @description : Se agrego el parametro para hacer la ruta de la accion de ver
     * @since: 22/07/2917
     */
    public function caracteristicas()
    {
        satelite_validar();
        try {
            $permisos = $this->gsatelite->get_permisos_opcion();
            $url_array = explode('/', uri_string());
            $crud = $this->new_crud();

            //Columnas a mostrar en READ
            $columns = array(
                // 'car_codigo',
                'car_nombre',
                'car_descripcion'
            );

            //Alias para las columnas
            $alias = array(
                //  'car_codigo' => 'Código',
                'car_nombre' => 'Nombre',
                'car_descripcion' => 'Descripción',
                'car_estado' => 'Estado'
            );

            //Columnas a mostrar en ADD
            $add_columns = array(
                // 'car_codigo',
                'car_nombre',
                'car_descripcion',
                'car_estado',
                'car_usu_mod',
                'car_fecha_mod',
                'car_usu_crea',
                'car_fecha_crea'
            );


            $req_columns = array(
                'car_nombre',
                'car_estado'
            );

            $crud->set_table('car_caracteristica')->set_subject('')->columns($columns)->display_as($alias)->add_fields($add_columns)->required_fields($req_columns)->field_type('car_usu_mod', 'hidden', $this->tank_auth->get_user_id())->field_type('car_fecha_mod', 'hidden', date('Y-m-d H:i:s'))->field_type('car_usu_crea', 'hidden', $this->tank_auth->get_user_id())->field_type('car_fecha_crea', 'hidden', date('Y-m-d H:i:s'))->set_rules('car_nombre', 'Nombre de la característica', 'trim|required|callback_caracteristica_nombre_unico');
            if (end($url_array) == 'add') {
                $crud->field_type('car_estado', 'hidden', 1);
            } else {
                $crud->field_type('car_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            $crud->callback_add_field('car_codigo', function () {
                $tabla = 'car_caracteristica';
                $campo = 'car_codigo';
                $last = $this->inventario_model->get_max_codigo($tabla, $campo);

                $code = $last->codigo;
                $cod = (int) $code + 1;
                $codigo = str_pad($cod, 3, '0', STR_PAD_LEFT);

                return '<input id="field-car_codigo" name="car_codigo" type="text" maxlength="99" value="' . $codigo . '" >';
            });

            $crud->callback_edit_field('car_codigo', function ($value, $primary_key) {
                if ($value == '') {
                    $tabla = 'car_caracteristica';
                    $campo = 'car_codigo';
                    $last = $this->inventario_model->get_max_codigo($tabla, $campo);

                    $code = $last->codigo;
                    $cod = (int) $code + 1;
                    $codigo = str_pad($cod, 3, '0', STR_PAD_LEFT);
                    return '<input id="field-car_codigo" name="car_codigo" type="text" maxlength="99" value="' . $codigo . '" >';
                } else {
                    return '<input id="field-car_codigo" name="car_codigo" type="text" maxlength="99" value="' . $value . '" >';
                }
            });

            $crud->edit_fields($add_columns);

            // Validaciones
            $crud->unset_add();
            $data['agregar'] = true;
            if (!$permisos['permite_agregar']) {
                $data['agregar'] = false;
            }

            $crud->unset_edit();
            if ($permisos['permite_editar']) {
                //$crud->unset_edit();
                $crud->add_action('Editar', 'minia-icon-pencil', base_url() . 'cotizaciones/mantenimientos/caracteristicas_editar/');
            }

            $crud->unset_delete();
            if ($permisos['permite_eliminar']) {
                //$crud->unset_delete();
                $crud->add_action('Eliminar', 'icon16 icomoon-icon-remove', base_url() . 'cotizaciones/mantenimientos/caracteristicas_eliminar/');
            }

            if ($permisos['permite_ver']) {
                $crud->add_action('Ver', 'minia-icon-search', base_url() . 'cotizaciones/mantenimientos/caracteristicas_ver/');
            }

            $output = $crud->render();
            $data['titulo_personal'] = "Catálogo de características";

            $this->_cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    function get_caracteristicas_tia()
    {
        $id_pro = $this->input->post('id_pro');
        $reg = $this->gsatelite->get_tabla('art_articulo', array('art_id' => $id_pro));
        $reg = $reg[0];
        $data['id_tia'] = $reg['art_id_tia'];
        $data['articulo'] = $id_pro;
        $data['registro_padre'] = $this->gsatelite->get_registro('tia_tipo_articulo', 'tia_id', $reg['art_id_tia']);
        $html = $this->load->view('cotizaciones/mantenimientos/modal_edit_caracteristicas', $data, true);
        echo json_encode(array('html_form' => $html));
    }

    function editar_caracteris()
    {
        // die(print_r($_POST));
        $caract = $this->input->post('caracteris');
        $id_tia = $this->input->post('id_tia');
        //$articulo = $this->input->post('articulo');
        //ACTUALIZAR LAS CARACTERISTICAS DEL TIPO DE PRODUCTO
        //preguntar por los existentes
        $this->db->join('car_caracteristica', 'car_id=cxr_id_car');
        //$this->db->where('car_modulo',3);//modulo tres es de cotizacion
        $consul = $this->gsatelite->get_tabla('cxr_caractxtipo_articulo', array('cxr_id_tia' => $id_tia));
        //die(print_r($this->db->last_query());
        $seleccionados_activos = array();
        foreach ($consul as $f) {
            $seleccionados_activos[] = $f['cxr_id_car'];
        }


        for ($i = 0; $i < count($caract); $i++) {
            if ($caract[$i] > 0) {
                if (!in_array($caract[$i], $seleccionados_activos)) { //preguntar si se ha elegido uno nuevo
                    $this->db->insert('cxr_caractxtipo_articulo', array('cxr_id_car' => $caract[$i],
                        'cxr_id_tia' => $id_tia,
                        'cxr_estado' => 1,
                        'cxr_usu_mod' => $this->tank_auth->get_user_id(),
                        'cxr_fecha_mod' => date('Y-m-d H:i:s')
                    ));
                } else { // si existe unicamente actualizar los campos de auditoria
                    $cadena = array( 'cxr_estado' => 1, 'cxr_usu_mod' => $this->tank_auth->get_user_id(), 'cxr_fecha_mod' => date('Y-m-d H:i:s') );
                    $this->gsatelite->actualizar_array('cxr_caractxtipo_articulo', $cadena, array('cxr_id_car' => $caract[$i], 'cxr_id_tia' => $id_tia));
                }
            }
        }

        //AHORA RECORRER LOS EXISTENTES Y PREGUNTAR CUAL NO SE HA ELEGIDO

        for ($i = 0; $i < count($seleccionados_activos); $i++) {
            if (!in_array($seleccionados_activos[$i], $caract)) {
                $cadena = array( 'cxr_estado' => 0, 'cxr_usu_mod' => $this->tank_auth->get_user_id(), 'cxr_fecha_mod' => date('Y-m-d H:i:s') );
                $this->gsatelite->actualizar_array('cxr_caractxtipo_articulo', $cadena, array('cxr_id_car' => $seleccionados_activos[$i], 'cxr_id_tia' => $id_tia));
            }
        }
        /////////////////FIN ACTUALIZACIÓN DE CARACTERISTICAS


        echo json_encode(array('exito' => 1));
    }
    /**
     * @author Habby Lovo
     * @since  13/11/2017 - modificado
     * @return Mantenimiento tabla mob_mano_obra
     * Módulos padre: Sistema.
     */
    public function mano_obra()
    {
        satelite_validar();
        $this->load->library('../controllers/sistema/mantenimientos_compartidos');
        $permisos = $this->gsatelite->get_permisos_opcion('cotizaciones/mantenimientos/mano_obra');
        $this->mantenimientos_compartidos->mano_obra("cotizaciones", $permisos);
    }

    public function verificar_codigo_mob()
    {
        $codigo = $this->input->post('codigo');
        $existe = $this->db->where('mob_codigo', $codigo)->get('mob_mano_obra')->result_array();
        $arreglo = array('drop' => count($existe));
        //$arreglo=array('drop'=>0); //quitar la validación para ylufa
        echo json_encode($arreglo);
    }

    function giro_comercial()
    {
        satelite_validar();
        $crud = new grocery_CRUD;
        // Variable para Permisos. Agregado por Luis Navarro
        $permisos = $this->gsatelite->get_permisos_opcion();
        $alias = array(
            'gir_nombre' => 'Nombre',
            'gir_codigo' => 'Codigo Giro',
            'gir_estado' => 'Estado'
        );

        $colums = array(
            'gir_nombre',
            'gir_codigo',
            'gir_estado'
        );
        $edit = array(
            'gir_nombre',
            'gir_codigo',
            'gir_estado',
            'gir_usu_mod',
            'gir_fecha_mod'
        );
        $add = array(
            'gir_nombre',
            'gir_codigo',
            'gir_estado',
            'gir_usu_mod',
            'gir_fecha_mod'
        );

        $crud->set_table('gir_giro')
            //->set_subject('Giro comercial')
            ->set_subject('')
            ->display_as($alias)
            ->columns($colums)
            ->add_fields($add)
            ->edit_fields($edit)
            ->required_fields($add)
            ->field_type('gir_usu_mod', 'hidden', $this->tank_auth->get_user_id())
            ->field_type('gir_fecha_mod', 'hidden', date('Y-m-d h:i:s'))
            ->set_rules('gir_nombre', 'Nombre', 'trim|required|campo_unico[gir_giro.gir_nombre]')
            ->set_rules('gir_codigo', 'Codigo Giro', 'trim|required|campo_unico[gir_giro.gir_codigo]')
            ->unset_delete();
        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('gir_estado', 'hidden', 1);
        } else {
            $crud->field_type('gir_estado', 'dropdown', array('1' => 'Activado', '0' => 'Desactivado'));
        }
        // Administrar Permisos CRUD. Agregado por Luis Navarro
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }
        if (!$permisos['permite_editar']) {
            $crud->unset_edit();
        }
        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }
        $output = $crud->render();
        $data['titulo_personal'] = "Giro comercial";
        $this->_cargarvista($data, $output);
    }

    function motivo_perdida(){
        satelite_validar();
        try {
            $permisos = $this->gsatelite->get_permisos_opcion();
            $colums = array('mop_nombre','mop_descripcion','mop_estado');
            $edit = array('mop_nombre','mop_descripcion','mop_estado','mop_usu_modificacion','mop_fecha_modificacion');
            $add = array('mop_nombre','mop_descripcion','mop_estado','mop_usu_creacion','mop_fecha_creacion','mop_usu_modificacion','mop_fecha_modificacion');
            $alias = array(
                'mop_nombre' => 'Nombre',
                'mop_descripcion' => 'Descripción',
                'mop_estado' => 'Estado'
            );
            $crud = new grocery_CRUD;
            $urlx = explode('/', uri_string());
            $crud->set_table('mop_motivo_perdida')
                ->columns($colums)
                ->add_fields($add)
                ->edit_fields($edit)
                ->display_as($alias)
                ->set_rules('mop_nombre', 'Nombre', 'trim|required|campo_unico[mop_motivo_perdida.mop_nombre]')
                ->field_type('mop_fecha_modificacion', 'hidden', date('Y-m-d h:i:s'))
                ->field_type('mop_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
            ;
            if (end($urlx) == 'add') {
                $crud->field_type('mop_estado', 'hidden', 1)
                    ->field_type('mop_fecha_creacion', 'hidden', date('Y-m-d h:i:s'))
                    ->field_type('mop_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                ;
            } else {
                $crud->field_type('mop_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if (!$permisos['permite_ver']) {
                $crud->unset_read();
            }
            $output = $crud->render();
            $data['titulo_personal'] = "Motivo Perdida";
            $this->_cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    public function verificar_codigo_esm()
    {
        $codigo = $this->input->post('codigo');
        $existe = $this->db->where('esm_codigo', $codigo)->get('esm_estimacion')->result_array();
        $arreglo = array('drop' => count($existe));
        //$arreglo=array('drop'=>0); //quitar la validación para ylufa
        echo json_encode($arreglo);
    }

    /**
     * @Author: Edith Herrera
     * @date 18/01/2016
     * @description : Se creó una instancia al controlador de inventario para acceder a este catálogo
     *                y así evitar duplicación de catálogos en los módulos.
     */
    public function categorias()
    {
        satelite_validar();
        $modulo = 2;
        $this->load->library('../controllers/inventario/mantenimiento');
        $this->mantenimiento->tipo_articulo('cotizaciones/mantenimientos');
    }

    public function columna_padres($value, $row)
    {
        $valores = $this->inventario_model->categorias_hijas_padres($row->tia_id);
        return $valores[0]['departamento'];
    }

    /*function tipo_pago() {
        satelite_validar();
        $crud = new grocery_CRUD;
        $permisos = $this->gsatelite->get_permisos_opcion();
        $alias = array(
            'tpg_nombre' => 'Nombre',
            'tpg_estado' => 'Estado');

        $colums = array(
            'tpg_nombre',
            'tpg_estado');
        $edit = array(
            'tpg_nombre',
            'tpg_estado',
            'tpg_usu_mod',
            'tpg_fecha_mod',
            'tpg_usu_crea',
            'tpg_fecha_crea'
        );
        $add = array(
            'tpg_nombre',
            'tpg_estado',
            'tpg_usu_mod',
            'tpg_fecha_mod',
            'tpg_usu_crea',
            'tpg_fecha_crea'
        );
        $crud->where('tpg_estado >=', 0);
        $crud->set_table('tpg_tipo_pago')
                ->set_subject('Tipo de pago')
                ->display_as($alias)
                ->columns($colums)
                ->add_fields($add)
                ->edit_fields($edit)
                ->required_fields($add)
                ->field_type('tpg_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('tpg_fecha_mod', 'hidden', date('Y-m-d h:i:s'))
                ->field_type('tpg_usu_crea', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('tpg_fecha_crea', 'hidden', date('Y-m-d h:i:s'))
                ->set_rules('tpg_nombre', 'Nombre', 'trim|required|campo_unico[tpg_tipo_pago.tpg_nombre]')
        ;
        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('tpg_estado', 'hidden', 1);
        } else {
            $crud->field_type('tpg_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }
        // Administrar Permisos CRUD. Agregado de Luis Navarro
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }
        if (!$permisos['permite_editar']) {
            $crud->unset_edit();
        }
        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }
        $output = $crud->render();
        $data['titulo_personal'] = "Tipo de pago";
        $this->_cargarvista($data, $output);
    }*/

    //Este método tambien se encuentra en el cátalogo del módulo de contratos en el método tipo_servicio (Francisco Orozco 12/05/2017)
    public function tipo_servicio()
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $crud = new grocery_CRUD();
            $crud->set_table('tps_tipo_servicio');
            $crud->set_subject('Tipo de servicio');
            $crud->unset_export()->unset_print();
            $crud->required_fields('tps_nombre', 'tps_estado');
            $crud->columns('tps_nombre', 'tps_estado');
            $crud->display_as('tps_nombre', 'Nombre');
            $crud->display_as('tps_estado', 'Estado');
            $crud->field_type('tps_usu_mod', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('tps_fecha_mod', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('tps_usu_crea', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('tps_fecha_crea', 'hidden', date('Y-m-d H:i:s'));
            $crud->set_rules('tps_nombre', 'Nombre', 'trim|required|campo_unico[tps_tipo_servicio.tps_nombre]');

            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('tps_estado', 'hidden', 1);
            } else {  // Editar
                $crud->field_type('tps_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            $output = $crud->render();
            $data['titulo_personal'] = "Tipo de servicio";
            $this->_cargarvista($data, $output);
        }
    }

    //Este método tambien se encuentra en el cátalogo del módulo de contratos en el método servicios (Francisco Orozco 12/05/2017)
    public function catalogo_servicios($tarificador = null)
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $crud = new grocery_CRUD();
            $crud->set_table('src_servicio');
            $crud->set_subject('Servicio');
            $crud->unset_export()->unset_print();

            $crud->set_relation('src_id_tps', 'tps_tipo_servicio', '{tps_nombre}', array('tps_estado' => 1));
            $crud->required_fields('src_nombre', 'src_estado');
            $crud->columns('src_nombre', 'src_descripcion', 'src_id_tps', 'src_estado');
            $crud->display_as('src_nombre', 'Nombre');
            $crud->display_as('src_codigo', 'Código');
            $crud->display_as('src_descripcion', 'Descripción');
            $crud->display_as('src_estado', 'Estado');
            $crud->display_as('src_id_tps', 'Tipo de servicio');
            $crud->display_as('src_foto', 'Foto');
            $crud->field_type('src_usu_mod', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('src_fecha_mod', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('src_usu_crea', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('src_fecha_crea', 'hidden', date('Y-m-d H:i:s'));
            $crud->set_rules('src_nombre', 'Nombre', 'trim|required|campo_unico[src_servicio.src_nombre]');

            $crud->add_fields('src_nombre', 'src_codigo', 'src_id_tps', 'src_descripcion', 'src_estado', 'src_foto', 'src_usu_mod', 'src_fecha_mod', 'src_usu_crea', 'src_fecha_crea');
            $crud->edit_fields('src_nombre', 'src_codigo', 'src_id_tps', 'src_descripcion', 'src_estado', 'src_foto', 'src_usu_mod', 'src_fecha_mod');
            $crud->set_field_upload('src_foto', 'uploads/anx_servicios');

            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('src_estado', 'hidden', 1);
            } else {  // Editar
                $crud->field_type('src_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }
            $dir = explode('/', uri_string());
            if ($dir[0] == 'tarificador') {
                $crud->add_action('Planes', 'icon16 icon16 icomoon-icon-calendar-2', 'tarificador/procesos/planes', '');
            }

            $output = $crud->render();
            $data['titulo_personal'] = "Servicios";
            $this->_cargarvista($data, $output);
        }
    }

    function eliminar_registro_json()
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($_POST) {

                $tabla = $this->input->post('tabla');

                $tabla = $this->encode->decode_cpass($tabla);

                $id = $this->input->post('id');

                $primary_principal = $this->db->primary($tabla);

                $condicion = array($primary_principal => $id);

                $result = $this->gsatelite->borrado_general($tabla, $condicion);

                if ($result > 0) {

                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro eliminado", 'texto_alerta' => "Proceso realizado correctamente");

                    $this->session->set_flashdata($alerta);
                }
                echo $result;
            }
        }
    }

    /**
     * @author: Mario Marquez
     * @param: file = string;
     * @param: carpeta = string;
     * @param: tabla_principal = string;
     * @param: array_principal = array;
     * @param: tabla_dependiente = string;
     * @param: campo_fk = string;
     * @param: array_dependiente = array;
     */
    public function datos_adjuntos_generic($file, $carpeta, $tabla_principal = null, $array_principal = null, $tabla_dependiente = null, $campo_fk = null, $array_dependiente = null)
    {

        $ruta = "public/temp/" . $carpeta . "/" . $file;

        $carpeta_destino = "uploads/" . $carpeta . "/" . $file;

        if ($tabla_principal != null && $array_principal != null) {

            $id_principal = $this->gsatelite->ingresar($tabla_principal, $array_principal);
        } else {

            $array_anex = array(
                'anx_url' => $carpeta_destino,
                'anx_estado' => 1,
                'anx_fecha_modificacion' => date('Y-m-d H:i:s'),
                'anx_fecha_creacion' => date('Y-m-d H:i:s'),
                'anx_usu_modificacion' => $this->tank_auth->get_user_id(),
                'anx_usu_creacion' => $this->tank_auth->get_user_id()
            );

            $id_principal = $this->gsatelite->ingresar('anx_anexo', $array_anex);
        }

        if ($tabla_dependiente != null) {

            $array_dependiente[$campo_fk] = $id_principal;

            $id_dependiente = $this->db->insert($tabla_dependiente, $array_dependiente);
        }

        if ($id_principal > 0) {
            if (!copy($ruta, $carpeta_destino)) {
                return false;
                die(print_r("No se copio el archivo"));
            }

            unlink($ruta);
            return true;
        }
    }

    /**
     * @author: Mario Marquez
     * @param: longitud = int;
     */
    private function generarCodigo($longitud = 6)
    {

        $key = '';

        //$caracteres = '1234567890ABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $caracteres = '1234567890ABCDE';

        $max = strlen($caracteres) - 1;

        for ($i = 0; $i < $longitud; $i++)
            $key .= $caracteres[mt_rand(0, $max)];

        return $key;
    }

    /**
     * @author: Mario Marquez
     * @param: carpeta = string;
     * @param: mimes = string, mimes types separados por coma;
     */
    public function guardar_generic($carpeta = null, $mimes = null)
    {
        if ($mimes != null) {
            $mimes = str_replace('-', '|', $mimes);
            $image = $this->upload_generic($carpeta, $mimes);
        } else {
            $image = $this->upload_generic($carpeta);
        }

        //die(var_dump($image));
        if (isset($image['upload_data']['file_name'])) {
            echo $image['upload_data']['file_name'];
        } else {
            echo '';
        }
    }

    /**
     * @author: Mario Marquez
     * @param: carpeta = string;
     * @param: mimes = string;
     */
    function upload_generic($carpeta, $mimes = null)
    {

        $ruta = FCPATH . "public/temp/" . $carpeta;
        if (!file_exists($ruta)) {
            mkdir($ruta, 0777);
        }

        $obj = &get_instance();
        $config['upload_path'] = $ruta;

        $alt = $this->generarCodigo();
        //$_FILES['userfile']['name'] = str_replace(array('(',')'), '_', $_FILES['userfile']['name']);

        $_FILES['userfile']['name'] = preg_replace("/[^a-zA-Z0-9.-_]/", "", $_FILES['userfile']['name']);
        //var_dump($_FILES);

        $config['file_name'] = $alt . '_' . $_FILES['userfile']['name'];
        //$config['max_filename'] = 0;

        if ($mimes != null) {
            $config['allowed_types'] = $mimes;
        } else {
            $config['allowed_types'] = 'pdf|jpg|png|jpeg|doc|xls|docx|xlsx';
        }

        $obj->load->library('upload', $config);
        if (!$obj->upload->do_upload()) {
            $error = array('error' => $obj->upload->display_errors());
            return $error;
        } else {

            $data = array('upload_data' => $obj->upload->data());
            return $data;
        }
    }

    /* ---------------------
      anexo de documentos
      -------------------- */

    public function datos_anexo_documento($img, $carpeta, $titulo_doc)
    {
        $extencion = end(explode(".", $img));
        $nombre = trim($img);
        $ruta = "public/temp/" . $carpeta . "/" . $nombre;
        $carpeta_destino = "uploads/anexos_cliente/" . $titulo_doc . "." . trim($extencion) . "";
        copy($ruta, $carpeta_destino);
        unlink($ruta);
    }

    public function guardar_gral($parametros, $carpeta = null)
    {
        $datos = @explode($parametros);
        $carpeta = $parametros;

        $image = $this->upload_gral($carpeta);
        echo $image['upload_data']['raw_name'] . $image['upload_data']['file_ext'];
    }

    function upload_gral($carpeta)
    {

        if ($carpeta == "assets") {
            $ruta = FCPATH . "assets/uploads/images";
        } else {
            $ruta = FCPATH . "public/temp/" . $carpeta;
        }

        if (!file_exists($ruta)) {
            mkdir($ruta, 0777);
        }
        $obj = &get_instance();
        $config['upload_path'] = $ruta;
        $config['allowed_types'] = 'pdf|jpg|png|jpeg|doc|xls|docx|xlsx';
        $obj->load->library('upload', $config);
        if (!$obj->upload->do_upload()) {
            $error = array('error' => $obj->upload->display_errors());
            return true;
        } else {
            $data = array('upload_data' => $obj->upload->data());
            return $data;
        }
        print_r($data);
    }

    function eliminar_imagen_gral($carpeta = "")
    {

        $url = $this->input->post("url");
        echo $url;
        $carp = ($carpeta != "") ? $carpeta : "documentos";

        unlink("./public/temp/$carp/" . $url);
    }

    public function datos_imagen_gral($img, $id_cliente, $carpeta, $titulo_doc, $tipo = 0)
    {
        $extencion = end(explode(".", $img));
        $datos_1 = $this->session->keep_flashdata('datos_1');
        $nombre = trim($img);
        $ruta = "public/temp/" . $carpeta . "/" . $nombre;
        /* if($extencion=='jpg' || $extencion=='jepg' || $extencion=='png'){
          $tipo=1;
          }
          else{$tipo=0;} */

        $destino = "uploads/anexos_cliente/" . $titulo_doc . "." . trim($extencion) . "";
        $dir = $this->gsatelite->get_campo('anx_anexo', 'anx_url', array('anx_url' => $destino, 'anx_estado' => 1));
        // Si ya existe, no se ingresa.

        if (count($dir) <= 0) {
            $array_anex = array(
                'anx_url' => $destino,
                'anx_nombre' => $titulo_doc,
                'anx_estado' => 1,
                'anx_usu_crea' => $this->tank_auth->get_user_id(),
                'anx_usu_mod' => $this->tank_auth->get_user_id(),
                'anx_fecha_crea' => date('Y-m-d H:i:s'),
                'anx_fecha_mod' => date('Y-m-d H:i:s'),
                'anx_imagen' => $tipo
            );

            $this->db->insert("anx_anexo", $array_anex);
            $id_anexo = $this->db->insert_id();

            $array_anex_doc = array(
                'axn_id_anx' => $id_anexo,
                'axn_id_cli' => $id_cliente,
                'axn_estado' => 1,
                'axn_usu_mod' => $this->tank_auth->get_user_id(),
                'axn_fecha_mod' => date('Y-m-d H:i:s'),
                'axn_usu_crea' => $this->tank_auth->get_user_id(),
                'axn_fecha_crea' => date('Y-m-d H:i:s')
            );
            $this->db->insert("axn_anexoxcliente", $array_anex_doc);
            $carpeta_destino = "uploads/anexos_cliente/" . $titulo_doc . "." . trim($extencion) . "";

            copy($ruta, $carpeta_destino);
            unlink($ruta);
        }
    }

    public function datos_imagen_gral2($img, $id_cliente, $carpeta, $titulo_doc, $tipo = 0)
    {
        $extencion = end(explode(".", $img));
        $datos_1 = $this->session->keep_flashdata('datos_1');
        $nombre = trim($img);

        $ruta = "public/temp/archivos/" . $nombre;

        $destino = "uploads/anexos_cliente/" . $nombre;

        $carpeta_destino = "uploads/anexos_cliente/" . $nombre;
        copy($ruta, $carpeta_destino);
        unlink($ruta);
    }
    // funcion para agregar anexos al proyecto del cliente
    public function datos_imagen_gral3($img, $proyecto, $carpeta, $titulo_doc, $tipo = 0)
    {
        $extencion = end(explode(".", $img));
        $datos_1 = $this->session->keep_flashdata('datos_1');
        $nombre = trim($img);
        $ruta = "public/temp/" . $carpeta . "/" . $nombre;
        $destino = "uploads/anexos_proyectos_cliente/" . $titulo_doc . "." . trim($extencion) . "";
        $dir = $this->gsatelite->get_campo('apl_anexo_proyecto_cliente', 'apl_url', array('apl_url' => $destino, 'apl_estado' => 1));
        // Si ya existe, no se ingresa.

        if (count($dir) <= 0) {
            $array_anex = array(
                'apl_id_pcl' => $proyecto,
                'apl_url'    => $destino,
                'apl_nombre' => $nombre,
                'apl_estado' => 1,
                'apl_usu_creacion'       => $this->tank_auth->get_user_id(),
                'apl_fecha_creacion'     => date('Y-m-d H:i:s'),
                'apl_usu_modificacion'   => $this->tank_auth->get_user_id(),
                'apl_fecha_modificacion' => date('Y-m-d H:i:s')
            );

            $this->db->insert("apl_anexo_proyecto_cliente", $array_anex);
            $id_anexo = $this->db->insert_id();
            $carpeta_destino = "uploads/anexos_proyectos_cliente/" . $titulo_doc . "." . trim($extencion) . "";

            copy($ruta, $carpeta_destino);
            unlink($ruta);
        }
    }

    /**
     * ====================
     * CALLBACKS
     * ===================
     * */

    /**
     * ====================
     * @Autor: Mario Marquez
     * ===================
     * */
    function caracteristica_nombre_unico()
    {
        $nom_carac = trim($this->input->post('car_nombre'));
        $mod_carac = $this->input->post('car_modulo');

        if (end(explode('/', uri_string())) == 'add') {
            $where = array('car_caracteristica.car_nombre' => $nom_carac, 'car_caracteristica.car_modulo' => $mod_carac);
            $query = $this->db->select('car_caracteristica.car_id')
                ->from('car_caracteristica');
            $this->db->where($where);
        } else {
            $id_carac = end(explode('/', uri_string()));
            $where = array('car_caracteristica.car_nombre' => $nom_carac, 'car_caracteristica.car_modulo' => $mod_carac);
            $query = $this->db->select('car_caracteristica.car_id')
                ->from('car_caracteristica');
            $this->db->where($where);
            $this->db->where_not_in('car_caracteristica.car_id', $id_carac);
        }
        $result = $query->get()->result();
        if (count($result) > 0) {
            $this->form_validation->set_message('caracteristica_nombre_unico', 'El campo Nombre debe ser único.');
            return false;
        } else {
            return true;
        }
    }

    public function agregar_impuesto($ruta = null)
    {
        satelite_validar();
        $ruta = (trim($ruta) != '') ? $ruta : 'cotizaciones/mantenimientos';
        //Centro de costos
        $centro_costo = $this->gsatelite->get_dropdown('cec_centro_costo', '{cec_nombre}', '', array('cec_estado' => 1), null, '', 'cec_id', true);
        $data["centro_costo"] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '<option value=""></option>', $centro_costo);
        //tipo de cuenta
        $tipo_cuenta = $this->gsatelite->get_dropdown('tcn_tipo_cuenta', '{tcn_nombre}', '', array('tcn_estado' => 1), null, '', 'tcn_id', true);
        $data["tipo_cuenta"] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '<option value=""></option>', $tipo_cuenta);
        //tipo de factura
        $tipo_factura = $this->gsatelite->get_dropdown('tif_tipo_factura', '{tif_nombre}', '', array('tif_estado' => 1), null, '', 'tif_id', true);
        $data["tipo_factura"] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '<option value=""></option>', $tipo_factura);
        //cuenta contable
        $ctas_padres = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_estado' => 1, 'cnt_id_cnt_padre IS NOT NULL' => NULL));
        $padres = (count($ctas_padres) > 0) ? implode(',', array_unique(array_column($ctas_padres, 'cnt_id_cnt_padre'))) : 0;
        $cuenta = $this->gsatelite->get_dropdown('cnt_cuenta_contable', '{cnt_cuenta} - {cnt_nombre}', '', array("cnt_estado" => 1, "cnt_id NOT IN ( $padres )" => NULL), null, '', 'cnt_id', true);
        $data["cuen_con"] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '<option value=""></option>', $cuenta);
        $data['titulo_personal'] = "Gestión de impuestos";
        $data['ruta'] = $ruta;
        cargarvista($data, null, 'cotizaciones/mantenimientos/agregar_impuesto');
    }

    public function guardar_impuesto($ruta = null)
    {
        satelite_validar();
        $ruta = (trim($ruta) != '') ? $ruta : 'cotizaciones/mantenimientos';

        if ($_POST) {

            $imp_array = array(
                'imp_nombre' => $this->input->post('nombre'),
                'imp_defecto' => $this->input->post('apli_defect'),
                'imp_porcentaje' => $this->input->post('porcentaje'),
                'imp_valor' => $this->input->post('valor'),
                'imp_estado' => 1,
                'imp_usu_mod' => $this->tank_auth->get_user_id(),
                'imp_fecha_mod' => date('Y-m-d h:i:s'),
            );
            $respuesta      = $this->gsatelite->ingresar('imp_impuesto', $imp_array);
            $centro_costo   = $this->input->post('centrosCosto');
            $cuenta_cnt     = $this->input->post('cuentaContable');
            $tipo_cnt       = $this->input->post('tipoCuentas');
            $tipoFactura    = $this->input->post('tipoFactura');
            foreach ($cuenta_cnt as $key => $cnt) {
                $info = array(
                    'cxe_id_cnt' => $cnt,
                    'cxe_id_imp' => $respuesta,
                    'cxe_id_tcn' => $tipo_cnt[$key],
                    'cxe_id_cec' => ($centro_costo[$key] > 0) ? $centro_costo[$key] : null,
                    'cxe_id_tif' => ($tipoFactura[$key] > 0) ? $tipoFactura[$key] : null,
                    'cxe_tipo'  => null,
                    'cxe_estado' => 1,
                    'cxe_usu_crea' => $this->tank_auth->get_user_id(),
                    'cxe_fecha_crea' => date('Y-m-d H:i:s'),
                    'cxe_usu_mod' => $this->tank_auth->get_user_id(),
                    'cxe_fecha_mod' => date('Y-m-d H:i:s')
                );
                $this->gsatelite->ingresar('cxe_cuentaximpuesto', $info);
            }

            $rediret = $this->input->post('redirect');
            if ($respuesta > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Procesado", 'texto_alerta' => "Registro(s) ingresado(s) con éxito");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "Ocurrió un error al ingresar la información");
            }

            $this->session->set_flashdata($alerta);

            $dir = $this->input->post('direccion');
            if ($dir == 1) {
                redirect($ruta . '/agregar_impuesto');
            } else if ($dir == 2) {
                redirect($ruta . '/gestion_impuestos');
            }
        }
    }

    public function editar_impuesto($id_imp, $ruta = null)
    {
        satelite_validar();
        $ruta = (trim($ruta) != '') ? $ruta : 'cotizaciones/mantenimientos';
        if ($_POST) {
        } else {
            $data['id_impuesto'] = $id_imp;
            $data['impuestos'] = $this->gsatelite->get_tabla('imp_impuesto', array('imp_id' => $id_imp));
            $data['cuentas'] = $this->cotizaciones_model->get_cuentas_impuesto(array('imp_id' => $id_imp, 'cxe_estado' => 1));
            //Centro de costos
            $centro_costo = $this->gsatelite->get_dropdown('cec_centro_costo', '{cec_nombre}', '', array('cec_estado' => 1), null, '', 'cec_id', true);
            $data["centro_costo"] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '<option value=""></option>', $centro_costo);
            //tipo de cuenta
            $tipo_cuenta = $this->gsatelite->get_dropdown('tcn_tipo_cuenta', '{tcn_nombre}', '', array('tcn_estado' => 1), null, '', 'tcn_id', true);
            $data["tipo_cuenta"] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '<option value=""></option>', $tipo_cuenta);
            //tipo de factura
            $tipo_factura = $this->gsatelite->get_dropdown('tif_tipo_factura', '{tif_nombre}', '', array('tif_estado' => 1), null, '', 'tif_id', true);
            $data["tipo_factura"] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '<option value=""></option>', $tipo_factura);
            //cuenta contable
            $ctas_padres = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_estado' => 1, 'cnt_id_cnt_padre IS NOT NULL' => NULL));
            $padres = (count($ctas_padres) > 0) ? implode(',', array_unique(array_column($ctas_padres, 'cnt_id_cnt_padre'))) : 0;
            $cuenta = $this->gsatelite->get_dropdown('cnt_cuenta_contable', '{cnt_cuenta} - {cnt_nombre}', '', array("cnt_estado" => 1, "cnt_id NOT IN ( $padres )" => NULL), null, '', 'cnt_id', true);
            $data["cuen_con"] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '<option value=""></option>', $cuenta);
            $data['cnt_cont'] = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_estado' => 1));
            $data['titulo_personal'] = "Gestión de impuestos";
            $data['ruta'] = $ruta;
            cargarvista($data, null, 'cotizaciones/mantenimientos/editar_impuesto');
        }
    }

    public function actualizar_impuesto()
    {
        $ruta_array = $this->gsatelite->get_valores_url();
        $ruta = $ruta_array['modulo'] . '/' . $ruta_array['control'];

        $id_imp = $this->input->post('id_impuestos');
        $imp_array = array(
            'imp_nombre' => $this->input->post('nombre'),
            'imp_defecto' => $this->input->post('apli_defect'),
            'imp_porcentaje' => $this->input->post('porcentaje'),
            'imp_valor' => $this->input->post('valor'),
            'imp_estado' => $this->input->post('estado'),
            'imp_usu_mod' => $this->tank_auth->get_user_id(),
            'imp_fecha_mod' => date('Y-m-d h:i:s'),
        );
        $contrato_id = $this->gsatelite->actualizar_array('imp_impuesto', $imp_array, array('imp_id' => $id_imp));

        $this->gsatelite->borrado_general('cxe_cuentaximpuesto', array('cxe_id_imp' => $id_imp));

        $centro_costo   = $this->input->post('centrosCosto');
        $cuenta_cnt     = $this->input->post('cuentaContable');
        $tipo_cnt       = $this->input->post('tipoCuentas');
        $tipoFactura    = $this->input->post('tipoFactura');
        foreach ($cuenta_cnt as $key => $cnt) {
            $info = array(
                'cxe_id_cnt' => $cnt,
                'cxe_id_imp' => $id_imp,
                'cxe_id_tcn' => $tipo_cnt[$key],
                'cxe_id_cec' => ($centro_costo[$key] > 0) ? $centro_costo[$key] : null,
                'cxe_id_tif' => ($tipoFactura[$key] > 0) ? $tipoFactura[$key] : null,
                'cxe_tipo' => null,
                'cxe_estado' => 1,
                'cxe_usu_crea' => $this->tank_auth->get_user_id(),
                'cxe_fecha_crea' => date('Y-m-d H:i:s'),
                'cxe_usu_mod' => $this->tank_auth->get_user_id(),
                'cxe_fecha_mod' => date('Y-m-d H:i:s')
            );
            $this->gsatelite->ingresar('cxe_cuentaximpuesto', $info);
        }


        $dir = $this->input->post('direccion');
        if ($dir == 1) {
            redirect($ruta . '/editar_impuesto/' . $id_imp);
        } else if ($dir == 2) {
            redirect($ruta . '/gestion_impuestos');
        }
    }

    function tipo_factura()
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            try {

                $crud = new grocery_CRUD();
                $permisos = $this->gsatelite->get_permisos_opcion();
                $crud->set_table('tif_tipo_factura')
                    //->set_subject('Tipos Factura')
                    ->set_subject('')
                    ->columns('tif_nombre', 'tif_abreviacion', 'tif_estado')
                    ->fields('tif_nombre', 'tif_abreviacion', 'tif_estado', 'tif_usu_mod', 'tif_fecha_mod', 'tif_usu_crea', 'tif_fecha_crea')
                    ->display_as('tif_nombre', 'Nombre')
                    ->display_as('tif_abreviacion', 'Abreviación')
                    ->display_as('tif_estado', 'Estado')
                    ->required_fields('tif_nombre', 'tif_abreviacion', 'tif_estado')
                    ->set_rules('tif_nombre', 'Nombre', 'trim|required|campo_unico[tif_tipo_factura.tif_nombre]')
                    ->field_type('tif_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('tif_usu_crea', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('tif_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                    ->field_type('tif_fecha_crea', 'hidden', date('Y-m-d H:i:s'))
                    ->unset_delete();
                if (end(explode('/', uri_string())) == 'add') {
                    $crud->field_type('tif_estado', 'hidden', 1);
                } else {
                    $crud->field_type('tif_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
                }
                // Validar Permisos. Agregado por Luis Navarro
                if (!$permisos['permite_agregar']) {
                    $crud->unset_add();
                }
                if (!$permisos['permite_editar']) {
                    $crud->unset_edit();
                }
                if (!$permisos['permite_eliminar']) {
                    $crud->unset_delete();
                }
                $data['titulo_personal'] = "Tipos de factura";

                $output = $crud->render();
                $this->_cargarvista($data, $output);
            } catch (Exception $e) {
                show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
            }
        }
    }

    function tipo_cuenta()
    {
        satelite_validar();

        $campos = array(
            'tcn_nombre' => 'Nombre',
            'tcn_abreviacion' => 'Abreviación',
            'tcn_descripcion' => 'Descripción',
            'tcn_estado' => 'Estado'
        );

        $add_fields = array(
            'tcn_nombre',
            'tcn_abreviacion',
            'tcn_descripcion',
            'tcn_estado',
            'tcn_fecha_crea',
            'tcn_fecha_mod',
            'tcn_usu_crea',
            'tcn_usu_mod'
        );

        $edit_fields = array(
            'tcn_nombre',
            'tcn_abreviacion',
            'tcn_descripcion',
            'tcn_estado',
            'tcn_fecha_mod',
            'tcn_usu_mod'
        );

        $required_fields = array(
            'tcn_nombre',
            'tcn_abreviacion',
            'tcn_estado',
        );


        $crud = new grocery_CRUD();
        // Variable para Permisos. Agregado por Luis Navarro
        $permisos = $this->gsatelite->get_permisos_opcion();
        $crud->set_table('tcn_tipo_cuenta')
            //->set_subject('Tipo de cuenta')
            ->set_subject('')
            ->columns('tcn_nombre', 'tcn_abreviacion', 'tcn_estado')
            ->display_as($campos)
            ->add_fields($add_fields)
            ->edit_fields($edit_fields)
            ->required_fields($required_fields)
            ->set_rules('tcn_nombre', 'Nombre', 'trim|required|campo_unico[tcn_tipo_cuenta.tcn_nombre]')
            ->field_type('tcn_usu_mod', 'hidden', $this->tank_auth->get_user_id())
            ->field_type('tcn_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
            ->field_type('tcn_usu_crea', 'hidden', $this->tank_auth->get_user_id())
            ->field_type('tcn_fecha_crea', 'hidden', date('Y-m-d H:i:s'));
        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('tcn_estado', 'hidden', 1);
        } else {
            $crud->field_type('tcn_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }
        // Validar Permisos. Agregado por Luis Navarro
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }
        if (!$permisos['permite_editar']) {
            $crud->unset_edit();
        }
        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }
        $data['titulo_personal'] = "Tipos de cuentas";
        $output = $crud->render();
        $this->_cargarvista($data, $output);
    }

    function nivel_cuenta()
    {
        satelite_validar();

        $campos = array(
            'nic_nombre' => 'Nombre',
            'nic_numero' => 'Nivel',
            'nic_descripcion' => 'Descripción',
            'nic_estado' => 'Estado'
        );

        $add_fields = array(
            'nic_nombre',
            'nic_numero',
            'nic_descripcion',
            'nic_estado',
            'nic_fecha_crea',
            'nic_fecha_mod',
            'nic_usu_crea',
            'nic_usu_mod'
        );
        $edit_fields = array(
            'nic_nombre',
            'nic_numero',
            'nic_descripcion',
            'nic_estado',
            'nic_fecha_mod',
            'nic_usu_mod'
        );

        $required_fields = array(
            'nic_nombre',
            'nic_numero',
            'nic_estado',
        );


        $crud = new grocery_CRUD();
        // Variable para Permisos. Agregado por Luis Navarro
        $permisos = $this->gsatelite->get_permisos_opcion();
        $crud->set_table('nic_nivel_cuenta')
            ->set_subject('')
            ->columns('nic_nombre', 'nic_numero', 'nic_estado')
            ->display_as($campos)
            ->add_fields($add_fields)
            ->edit_fields($edit_fields)
            ->required_fields($required_fields)
            ->set_rules('nic_nombre', 'Nombre', 'trim|required|campo_unico[nic_nivel_cuenta.nic_nombre]')
            ->field_type('nic_usu_mod', 'hidden', $this->tank_auth->get_user_id())
            ->field_type('nic_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
            ->field_type('nic_usu_crea', 'hidden', $this->tank_auth->get_user_id())
            ->field_type('nic_fecha_crea', 'hidden', date('Y-m-d H:i:s'));
        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('nic_estado', 'hidden', 1);
        } else {
            $crud->field_type('nic_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }
        // Validar Permisos. Agregado por Luis Navarro
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }
        if (!$permisos['permite_editar']) {
            $crud->unset_edit();
        }
        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }
        $data['titulo_personal'] = "Niveles de cuentas";
        $this->_cargarvista($data, $crud->render());
    }

    function cuenta_contable()
    {
        satelite_validar();

        $campos = array(
            'cnt_cuenta' => 'Cuenta',
            'cnt_nombre' => 'Nombre',
            'cnt_id_cnt_padre' => 'Dependencia',
            'cnt_id_nic' => 'Nivel',
            'cnt_estado' => 'Estado',
            'cnt_aumenta' => 'D/H'
        );
        $crud = new grocery_CRUD();
        $permisos = $this->gsatelite->get_permisos_opcion();
        $dep = 0;
        if ($_POST) {

            $nombre = $this->input->post('nombre');
            $nivel = $this->input->post('nivel');
            $dep = $this->input->post('dependencia');

            if ($nombre != '') {
                $crud->where("cnt_nombre like '" . $nombre . "%'");
            }
            if ($nivel != '') {
                $crud->where("cnt_id_nic", $nivel);
            }
            if ($dep > 0) {
                $crud->where("cnt_id_cnt_padre", $dep);
            }
            $data['nivel'] = $nivel;
            $data['nombre'] = $nombre;
        }
        $crud->set_table('cnt_cuenta_contable')
            //->set_subject('Cuenta contable')
            ->set_subject('')
            ->columns('cnt_cuenta', 'cnt_nombre', 'cnt_id_cnt_padre', 'cnt_id_nic', 'cnt_estado', 'cnt_aumenta')
            ->display_as($campos)
            ->set_relation('cnt_id_nic', 'nic_nivel_cuenta', '{nic_numero}')
            ->unset_edit()
            ->callback_column('cnt_id_cnt_padre', array($this, '_callback_dependencia'));

        if (end(explode('/', uri_string())) == 'add') {

            $crud->field_type('cnt_estado', 'hidden', 1);
        } else {
            $crud->field_type('cnt_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }


        if ($dep > 0) {
            $data['dependencia'] = $this->gsatelite->get_dropdown('cnt_cuenta_contable', '{cnt_id} - {cnt_nombre}', '', array('cnt_estado' => 1), $dep, null, null, true);
        } else {
            $data['dependencia'] = $this->gsatelite->get_dropdown('cnt_cuenta_contable', '{cnt_id} - {cnt_nombre}', '', array('cnt_estado' => 1), null, null, null, true);
        }
        // Validar Permisos. Agregado por Luis Navarro
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }
        if ($permisos['permite_editar']) {
            $crud->add_action('Editar', '', 'cotizaciones/mantenimientos/editar_cuenta', 'icomoon-icon-pencil-5');
        }
        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }

        $data['titulo_personal'] = "Cuentas contables";
        $this->_cargarvista($data, $crud->render());
    }

    function agregar_cuenta()
    {
        satelite_validar();
        if ($_POST) {
            $array_cuenta = array(
                'cnt_id_tcn' => $this->input->post('tipo_cuenta'),
                'cnt_id_cnt_padre' => ($this->input->post('dependencia')) ? $this->input->post('dependencia') : null,
                'cnt_id_nic' => ($this->input->post('nivel')) ? $this->input->post('nivel') : null,
                'cnt_cuenta' => $this->input->post('cuenta'),
                'cnt_nombre' => $this->input->post('nombre'),
                'cnt_descripcion' => ($this->input->post('descripcion')) ? trim($this->input->post('descripcion')) : null,
                'cnt_estado' => 1,
                'cnt_aumenta' => $this->input->post('d_h'),
                'cnt_fecha_crea' => date('Y-m-d H:i:s'),
                'cnt_fecha_mod' => date('Y-m-d H:i:s'),
                'cnt_usu_crea' => $this->tank_auth->get_user_id(),
                'cnt_usu_mod' => $this->tank_auth->get_user_id()
            );
            $agregar = $this->gsatelite->ingresar('cnt_cuenta_contable', $array_cuenta);

            if ($agregar > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro Ingresado", 'texto_alerta' => "El registro se ha ingresado correctamente.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Fallo de ingreso", 'texto_alerta' => "El registro no pudo ser ingresado, verifique la información a ingresar.");
            }

            $this->session->set_flashdata($alerta);

            $volver = $this->input->post('volver');
            if ($volver == 1) {
                redirect('cotizaciones/mantenimientos/cuenta_contable');
            } else {
                redirect('cotizaciones/mantenimientos/agregar_cuenta');
            }
        } else {
            $data['tipo_cuenta'] = $this->gsatelite->get_dropdown('tcn_tipo_cuenta', '{tcn_nombre}', '', array('tcn_estado' => 1), null, null, null, true);
            $data['dependencia'] = $this->gsatelite->get_dropdown('cnt_cuenta_contable', '{cnt_id} - {cnt_nombre}', '', array('cnt_estado' => 1), null, null, null, true);
            $data['nivel'] = $this->gsatelite->get_dropdown('nic_nivel_cuenta', '{nic_numero}', '', array('nic_estado' => 1), null, null, null, true);
        }

        $data['titulo_personal'] = "Agregar cuenta contable ";
        $this->_cargarvista($data);
    }

    function editar_cuenta($cuenta)
    {
        satelite_validar();
        if ($_POST) {
            //var_dump($_POST);die();
            $id_cuenta = $this->input->post('id_cuenta');
            $array_cuenta = array(
                'cnt_id_tcn' => $this->input->post('tipo_cuenta'),
                'cnt_id_cnt_padre' => ($this->input->post('dependencia')) ? $this->input->post('dependencia') : null,
                'cnt_id_nic' => ($this->input->post('nivel')) ? $this->input->post('nivel') : null,
                'cnt_cuenta' => $this->input->post('cuenta'),
                'cnt_nombre' => $this->input->post('nombre'),
                'cnt_descripcion' => ($this->input->post('descripcion')) ? trim($this->input->post('descripcion')) : null,
                'cnt_estado' => $this->input->post('estado'),
                'cnt_aumenta' => $this->input->post('d_h'),
                'cnt_fecha_mod' => date('Y-m-d H:i:s'),
                'cnt_usu_mod' => $this->tank_auth->get_user_id()
            );

            $editar = $this->gsatelite->actualizar_array('cnt_cuenta_contable', $array_cuenta, array('cnt_id' => $id_cuenta));

            if ($editar > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro actualizado", 'texto_alerta' => "El registro se ha actualizado correctamente.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro no actualizado", 'texto_alerta' => "El registro no pudo ser actualizado, verifique la información a actualizar.");
            }
            $this->session->set_flashdata($alerta);

            $volver = $this->input->post('volver');
            if ($volver == 1) {
                redirect('cotizaciones/mantenimientos/cuenta_contable');
            } else {
                redirect('cotizaciones/mantenimientos/editar_cuenta/' . $id_cuenta);
            }
        } else {
            $data['id_cuenta'] = $cuenta;
            $info = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_id' => $cuenta));
            $data['info'] = $info[0];
            $data['tipo_cuenta'] = $this->gsatelite->get_dropdown('tcn_tipo_cuenta', '{tcn_nombre}', '', array('tcn_estado' => 1), $info[0]['cnt_id_tcn'], null, null, true);
            $data['dependencia'] = $this->gsatelite->get_dropdown('cnt_cuenta_contable', '{cnt_id} - {cnt_nombre}', '', array('cnt_estado' => 1), $info['cnt_id_cnt_padre'], null, null, true);
            $data['nivel'] = $this->gsatelite->get_dropdown('nic_nivel_cuenta', ' {nic_numero}', '', array('nic_estado' => 1), $info['cnt_id_nic'], null, null, true);
        }

        $data['titulo_personal'] = "Editar cuenta contable ";
        $this->_cargarvista($data);
    }

    function _callback_dependencia($value, $row)
    {

        $cuenta = $this->gsatelite->get_campo('cnt_cuenta_contable', 'cnt_cuenta', array('cnt_id' => $value));

        return $cuenta;
    }

    public function agregar_pro_articulo()
    {
        satelite_validar();
        $this->load->library('../controllers/inventario/mantenimiento');
        $html = $this->mantenimiento->agregar_pro_articulo('cotizaciones/mantenimientos/agregar_pro_articulo', 'cotizaciones/mantenimientos/categorias');
        $data['html'] = $html;
        $this->_cargarvista($data);
    }

    public function validar_codigo()
    {
        $codigo = $this->input->post('codigo');
        $code = $this->input->post('code');
        $codigos = $this->gsatelite->get_tabla('tia_tipo_articulo');
        $resp = 0;
        if ($codigo == $code) {
            echo json_encode(array('resp' => $resp));
            die();
        }
        $codigo1 = strtolower($codigo);
        foreach ($codigos as $cod) {
            $codigo_base = strtolower($cod['tia_codigo']);
            if ($codigo_base == $codigo1) {
                $resp = 1;
                echo json_encode(array('resp' => $resp));
                die();
            }
        }
        echo json_encode(array('resp' => $resp));
    }

    public function editar_pro_articulo($id_tia)
    {
        satelite_validar();
        $this->load->library('../controllers/inventario/mantenimiento');
        $html = $this->mantenimiento->editar_pro_articulo($id_tia, 'cotizaciones/mantenimientos/editar_pro_articulo', 'cotizaciones/mantenimientos/categorias');
        $data['html'] = $html;
        $this->_cargarvista($data);
    }

    function validar_numero_cuenta($cuenta = null, $id_cuenta = null)
    {
        satelite_validar(true);
        if ($_POST['num_cuenta'] != '') {
            $cuenta = $this->input->post('num_cuenta');
            $id_cuenta = ($this->input->post('cuenta') != '') ? $this->input->post('cuenta') : null;
        }

        if ($id_cuenta != null) {
            $where = 'cnt_cuenta = ' . $cuenta . ' AND cnt_id <> ' . $id_cuenta;
        } else {
            $where = array('cnt_cuenta' => $cuenta);
        }

        $count = $this->gsatelite->count('cnt_cuenta_contable', $where);

        if ($count > 0) {
            $existe = 1;
        } else {
            $existe = 0;
        }

        echo json_encode(array('existe' => $existe));
    }

    public function get_municipio()
    {
        $mun_id_dep = $this->input->post('departamento');
        $select = $this->gsatelite->get_dropdown('mun_municipio', '{mun_nombre}', '', array('mun_id_dep' => $mun_id_dep, "mun_estado" => 1), null, '', 'mun_id', true);
        echo json_encode($select);
    }

    public function get_distritro_mun() {
        $mun_dt = $this->input->post('municipio');
        $select = $this->gsatelite->get_dropdown('dis_distrito', '{dis_nombre}', '', array('dis_id_mun' => $mun_dt, "dis_estado" => 1), null, '', 'dis_id', true);
        $dropdown = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $select);
        echo json_encode($dropdown);
    }

    public function get_ciudad()
    {
        $ciu_id_mun = $this->input->post('municipio');
        $select = $this->gsatelite->get_dropdown('ciu_ciudad', '{ciu_nombre}', '', array('ciu_id_mun' => $ciu_id_mun), null, '', 'ciu_id', true);
        echo json_encode($select);
    }

    function sucursales_cliente($cli_id = null)
    {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion('cotizaciones/mantenimientos/clientes');
        $crud = new grocery_CRUD();
        //Columnas a mostrar en READ
        $columns = array(
            'scl_codigo',
            'scl_nombre',
            'scl_direccion',
            'scl_estado'
        );

        //Alias para las columnas
        $alias = array(
            'scl_codigo' => 'Código',
            'scl_nombre' => 'Nombre',
            'scl_direccion' => 'Dirección',
            'scl_estado' => 'Estado'
        );

        $edit = array(
            'scl_codigo',
            'scl_nombre',
            'scl_direccion',
            'scl_estado',
            'scl_id_cli',
            'scl_usu_modificacion',
            'scl_fecha_modificacion'
        );
        $add = array(
            'scl_codigo',
            'scl_nombre',
            'scl_direccion',
            'scl_id_cli',
            'scl_estado',
            'scl_usu_creacion',
            'scl_fecha_creacion',
            'scl_fecha_modificacion',
            'scl_usu_modificacion'
        );

        $required = array(
            'scl_codigo',
            'scl_nombre',
            'scl_estado',
            'scl_usu_creacion',
            'scl_fecha_creacion',
            'scl_fecha_modificacion',
            'scl_usu_modificacion'
        );

        $crud->set_table('scl_sucursal_cliente')
            ->set_subject('Sucursales por cliente')
            ->where('scl_id_cli', $cli_id)
            ->add_fields($add)
            ->edit_fields($edit)
            ->columns($columns)
            ->required_fields($required)
            ->display_as($alias)
            ->unset_export()
            ->unset_print()
            ->field_type('scl_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
            ->field_type('scl_id_cli', 'hidden', $cli_id)
            ->field_type('scl_fecha_modificacion', 'hidden', date('Y-m-d h:i:s'))
            //->callback_before_update(array($this,'verify_update'))
            //->set_rules('scl_codigo', 'Código', 'required|campo_unico[scl_sucursal_cliente.scl_codigo]')
            // ->set_rules('scl_codigo', 'Código', 'required|callback_validar_sucursalesxcliente')
            //->callback_before_update(array($this,'encrypt_password_callback'))
        ;

        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('scl_estado', 'hidden', 1)
                ->field_type('scl_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('scl_fecha_creacion', 'hidden', date('Y-m-d h:i:s'));
        } else {
            $crud->field_type('scl_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }

        if (!$permisos['permite_editar']) {
            $crud->unset_edit();
        }

        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }

        $data['cliente'] = $this->gsatelite->get_tabla('cli_cliente', array('cli_id' => $cli_id));

        $data['titulo_personal'] = "Sucursales por cliente";

        $output = $crud->render();
        $this->_cargarvista($data, $output);
    }

    function validar_sucursalesxcliente()
    {
        $s_codigo = $this->input->post('scl_codigo');
        $s_cli =    $this->input->post('scl_id_cli');
        $error = false;
        if (end(explode('/', uri_string())) == 'add') {
            return true;
        } else {
            $id = end(explode('/', uri_string())) != "" ? end(explode('/', uri_string())) : 0;
            if ($id != 0) {
                $da = $this->gsatelite->get_tabla('scl_sucursal_cliente', array('scl_id' => $id));
                $this->db->select()->from('scl_sucursal_cliente')->where('scl_id_cli', $s_cli)->where('scl_codigo <>', $da[0]['scl_codigo']);
                $data = $this->db->get()->result_array();
                foreach ($data as $key) {
                    if ($s_codigo == $key['scl_codigo']) {
                        $error = true;
                    }
                }
            } else {
                $data = $this->gsatelite->get_tabla('scl_sucursal_cliente', array('scl_id_cli' => $s_cli));
                foreach ($data as $key) {
                    if ($s_codigo == $key['scl_codigo']) {
                        $error = true;
                    }
                }
            }
        }

        if ($error == true) {
            $this->form_validation->set_message('validar_sucursalesxcliente', 'El campo Código debe ser único.');
            return false;
        } else {
            return true;
        }
    }

    function clasificacion_cliente()
    {
        satelite_validar();

        // Variable para permisos. Agregado por Luis Navarro
        $permisos = $this->gsatelite->get_permisos_opcion();
        $id       = 0;

        $crud = new grocery_CRUD();
        //Columnas a mostrar en READ
        $columns = array(
            'cfc_nombre',
            'cfc_prefijo',
            'cfc_defecto',
            'cfc_estado'
        );

        //Alias para las columnas
        $alias = array(
            'cfc_nombre' => 'Nombre',
            'cfc_prefijo' => 'Prefijo',
            'cfc_defecto' => 'Defecto',
            'cfc_estado' => 'Estado'
        );

        $edit = array(
            'cfc_nombre',
            'cfc_prefijo',
            'cfc_estado',
            'cfc_defecto',
            'cfc_usu_modificacion',
            'cfc_fecha_modificacion'
        );

        $add = array(
            'cfc_nombre',
            'cfc_prefijo',
            'cfc_estado',
            'cfc_defecto',
            'cfc_usu_creacion',
            'cfc_fecha_creacion',
            'cfc_fecha_modificacion',
            'cfc_usu_modificacion'
        );

        $required = array(
            'cfc_nombre',
            'cfc_estado',
            'cfc_usu_creacion',
            'cfc_fecha_creacion',
            'cfc_fecha_modificacion',
            'cfc_usu_modificacion'
        );

        $crud->set_table('cfc_clasificacion_cliente')
            //->set_subject('Clasificación por cliente')
            ->set_subject('')
            ->add_fields($add)
            ->edit_fields($edit)
            ->columns($columns)
            ->required_fields($required)
            ->display_as($alias)
            ->unset_export()
            ->unset_print()
            ->field_type('cfc_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
            ->field_type('cfc_fecha_modificacion', 'hidden', date('Y-m-d h:i:s'))
            ->set_rules('cfc_nombre', 'Nombre', 'required|campo_unico[cfc_clasificacion_cliente.cfc_nombre]')
            ->callback_column('cfc_defecto', function ($value, $row) {
                if ($value == 1) {
                    return 'Si';
                }
            })
            ->callback_add_field('cfc_defecto', function () {
                return '<input type="checkbox" id="chbdefecto" class="nostyle"><input type="hidden" id="field-cfc_defecto" name="cfc_defecto" value="0">';
            })
            ->callback_edit_field('cfc_defecto', function ($value, $primary_key) use ($id) {
                $id      = $primary_key;
                $leer    = ($this->uri->rsegments[3] == 'read') ? 'iButton' : '';
                $defecto = ($value) ? 'checked' : ''; // Verificar si esta activo
                return '<input type="checkbox" id="chbdefecto" ' . $defecto . ' class="' . $leer . ' nostyle"><input type="hidden" id="field-cfc_defecto" name="cfc_defecto" value="' . $value . '">';
            });

        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('cfc_estado', 'hidden', 1)
                ->field_type('cfc_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('cfc_fecha_creacion', 'hidden', date('Y-m-d h:i:s'));
        } else {
            $crud->field_type('cfc_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }
        // Validar permisos. Agregado por Luis Navarro
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }

        if (!$permisos['permite_editar']) {
            $crud->unset_edit();
        }

        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }

        if (!$permisos['permite_ver']) {
            $crud->unset_read();
            // $crud->add_action('Ver', 'minia-icon-search', 'cotizaciones/mantenimientos/clasificacion_cliente/read');
        }

        $data['titulo_personal'] = "Clasificación";
        $data['reg_id']          = (is_numeric(end(explode('/', uri_string())))) ? end(explode('/', uri_string())) : 0;
        $output = $crud->render();
        //$this->_cargarvista($data, $output);
        cargarvista($data, $output, 'cotizaciones/mantenimientos/clasificacion_cliente');
    }

    function departamentos()
    {
        satelite_validar();
        $this->load->library('../controllers/sistema/catalogo');
        $this->catalogo->departamentos(array('transporte/cruds/departamento', 'sistema/catalogo/departamentos'));
        die('éxito');
    }

    function origen_base_datos()
    {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();

        $crud = new grocery_CRUD();
        //Columnas a mostrar en READ
        $columns = array(
            'ogc_nombre',
            'ogc_estado'
        );

        //Alias para las columnas
        $alias = array(
            'ogc_nombre' => 'Nombre',
            'ogc_estado' => 'Estado'
        );

        $edit = array(
            'ogc_nombre',
            'ogc_estado',
            'ogc_usu_modificacion',
            'ogc_fecha_modificacion'
        );
        $add = array(
            'ogc_nombre',
            'ogc_estado',
            'ogc_usu_creacion',
            'ogc_fecha_creacion',
            'ogc_fecha_modificacion',
            'ogc_usu_modificacion'
        );

        $required = array(
            'ogc_nombre',
            'ogc_estado',
            'ogc_usu_creacion',
            'ogc_fecha_creacion',
            'ogc_fecha_modificacion',
            'ogc_usu_modificacion'
        );

        $crud->set_table('ogc_origen_contacto')
            //->set_subject('Origen de base de datos')
            ->set_subject('')
            ->add_fields($add)
            ->edit_fields($edit)
            ->columns($columns)
            ->required_fields($required)
            ->display_as($alias)
            ->unset_export()
            ->unset_print()
            ->field_type('ogc_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
            ->field_type('ogc_fecha_modificacion', 'hidden', date('Y-m-d h:i:s'))
            ->set_rules('ogc_nombre', 'Nombre', 'required|campo_unico[ogc_origen_contacto.ogc_nombre]');

        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('ogc_estado', 'hidden', 1)
                ->field_type('ogc_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('ogc_fecha_creacion', 'hidden', date('Y-m-d h:i:s'));
        } else {
            $crud->field_type('ogc_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }

        if (!$permisos['permite_editar']) {
            $crud->unset_edit();
        }

        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }

        if ($permisos['permite_ver']) {
            $crud->add_action('Ver', 'minia-icon-search', uri_string() . '/read');
        }

        $data['titulo_personal'] = "Origen base de datos";

        $output = $crud->render();
        $this->_cargarvista($data, $output);
    }

    function etiquetas()
    {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();

        $crud = new grocery_CRUD();
        //Columnas a mostrar en READ
        $columns = array(
            'etq_nombre',
            'etq_estado'
        );

        //Alias para las columnas
        $alias = array(
            'etq_nombre' => 'Nombre',
            'etq_estado' => 'Estado'
        );

        $edit = array(
            'etq_nombre',
            'etq_estado',
            'etq_usu_modificacion',
            'etq_fecha_modificacion'
        );
        $add = array(
            'etq_nombre',
            'etq_estado',
            'etq_usu_creacion',
            'etq_fecha_creacion',
            'etq_fecha_modificacion',
            'etq_usu_modificacion'
        );

        $required = array(
            'etq_nombre',
            'etq_estado',
            'etq_usu_creacion',
            'etq_fecha_creacion',
            'etq_fecha_modificacion',
            'etq_usu_modificacion'
        );

        $crud->set_table('etq_etiqueta')
            //->set_subject('Etiquetas')
            ->set_subject('')
            ->add_fields($add)
            ->edit_fields($edit)
            ->columns($columns)
            ->required_fields($required)
            ->display_as($alias)
            ->unset_export()
            ->unset_print()
            ->field_type('etq_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
            ->field_type('etq_fecha_modificacion', 'hidden', date('Y-m-d h:i:s'))
            ->set_rules('etq_nombre', 'Nombre', 'required|campo_unico[etq_etiqueta.etq_nombre]');

        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('etq_estado', 'hidden', 1)
                ->field_type('etq_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('etq_fecha_creacion', 'hidden', date('Y-m-d h:i:s'));
        } else {
            $crud->field_type('etq_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }

        if (!$permisos['permite_editar']) {
            $crud->unset_edit();
        }

        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }

        if ($permisos['permite_ver']) {
            $crud->add_action('Ver', 'minia-icon-search', uri_string() . '/read');
        }

        $data['titulo_personal'] = "Etiquetas";

        $output = $crud->render();
        $this->_cargarvista($data, $output);
    }


    /**
     * @author Elman Ortiz
     * @date 15/08/2017
     */
    function caracteristicas_agregar()
    {
        satelite_validar();
        if ($this->input->post('tipoboton') == 'cancel') {
            redirect('cotizaciones/mantenimientos/caracteristicas');
        }

        if ($this->input->post()) { //Para guardar las caracteristicas
            //Crear arreglo caracteristicas
            $caracteristica_array = array(
                'car_codigo' => ($this->input->post('car_codigo')) ? $this->input->post('car_codigo') : null,
                'car_nombre' => $this->input->post('inpNombre'),
                'car_descripcion' => $this->input->post('inpDescripcion'),
                'car_tipo' => $this->input->post('slcTipo'),
                'car_estado' => 1,
                'car_usu_crea' => $this->tank_auth->get_user_id(),
                'car_fecha_crea' => date('Y-m-d H:i:s'),
                'car_usu_mod' => $this->tank_auth->get_user_id(),
                'car_fecha_mod' => date('Y-m-d H:i:s')
            );

            $car_id = $this->gsatelite->ingresar('car_caracteristica', $caracteristica_array);
            $valor  = $this->input->post('valores');
            $precio = $this->input->post('preciosCa');
            $lista  = array_combine($valor, $precio);
            if ($lista) {
                //$elem = " ";
                foreach ($lista as $key => $value) {
                    //vrl_valores_lista
                    $valores_lista_array = array(
                        'vrl_id_car' => $car_id,
                        'vrl_valor' => $key,
                        'vrl_precio_valor' => ($value != '') ? $value : null,
                        'vrl_estado' => 1,
                        'vrl_usu_creacion' => $this->tank_auth->get_user_id(),
                        'vrl_fecha_creacion' => date('Y-m-d H:i:s'),
                        'vrl_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'vrl_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $result = $this->gsatelite->ingresar('vrl_valores_lista', $valores_lista_array);
                }
            }/*else{
                //vrl_valores_lista
                $valores_lista_array = array(
                    'vrl_id_car' => $car_id,
                    'vrl_valor' => ($this->input->post('inpValorUnico')) ? $this->input->post('inpValorUnico') : null,
                    'vrl_estado' => 1,
                    'vrl_usu_creacion' => $this->tank_auth->get_user_id(),
                    'vrl_fecha_creacion' => date('Y-m-d H:i:s'),
                    'vrl_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'vrl_fecha_modificacion' => date('Y-m-d H:i:s')
                );
            }*/

            if ($car_id > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Agregar caracteristica", 'texto_alerta' => "El registro se guardó correctamente.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Agregar caracteristica", 'texto_alerta' => "Ocurrio un problema al crear el registro.");
            }
            $this->session->set_flashdata($alerta);

            if ($this->input->post('tipoboton') == 'save') {
                redirect('cotizaciones/mantenimientos/caracteristicas_agregar/');
            } else {
                redirect('cotizaciones/mantenimientos/caracteristicas/');
            }
        } else { //Mostrar vista para caracteristicas
            $last = $this->inventario_model->get_max_codigo('car_caracteristica', 'car_codigo');
            $code = $last->codigo;
            $cod = (int) $code + 1;
            $codigo = str_pad($cod, 3, '0', STR_PAD_LEFT);

            $data['titulo_personal'] = "Catálogo de características";
            $data['codigo'] = $codigo;
            $this->_cargarvista($data);
        }
    }

    /**
     * @author Elman Ortiz
     * @date 15/08/2017
     */
    function caracteristicas_ver($car_id)
    {
        satelite_validar();
        $carac = $this->inventario_model->get_caracteristicas($car_id);
        $data['caracteristica'] = $carac;
        $data['titulo_personal'] = "Ver características";
        $this->_cargarvista($data);
    }

    /**
     * @author Elman Ortiz
     * @date 17/08/2017
     */
    function caracteristicas_eliminar($car_id)
    {
        $tbl_vrl = $this->gsatelite->get_tabla('vrl_valores_lista', array('vrl_id_car' => $car_id));
        $result1 = $this->gsatelite->borrado_general('vrl_valores_lista', array('vrl_id_car' => $car_id));
        $result2 = $this->inventario_model->delete_caracteristica(array('car_id' => $car_id));
        if ($result2 < 1 && count($tbl_vrl) > 0) { //No se pudo borrar y reversion de los datos eliminados
            $vrl_array = array(
                'vrl_id_car' => $tbl_vrl[0]['vrl_id_car'],
                'vrl_valor' => $tbl_vrl[0]['vrl_valor'],
                'vrl_estado' => $tbl_vrl[0]['vrl_estado'],
                'vrl_usu_modificacion' => $tbl_vrl[0]['vrl_usu_modificacion'],
                'vrl_fecha_modificacion' => $tbl_vrl[0]['vrl_fecha_modificacion'],
                'vrl_usu_creacion' => $tbl_vrl[0]['vrl_usu_creacion'],
                'vrl_fecha_creacion' => $tbl_vrl[0]['vrl_fecha_creacion']
            );
            $registro = $this->gsatelite->ingresar('vrl_valores_lista', $vrl_array);
            $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "IF111111111 Eliminar caracteristica", 'texto_alerta' => " IF22222 No se puede eliminar porque esta asignado.");
        } else {
            if ($result2 == 0) {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Eliminar caracteristica", 'texto_alerta' => "No se puede eliminar porque esta asignado.");
            } else {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Eliminar caracteristica", 'texto_alerta' => "El registro se elimino correctamente.");
            }
        }
        $this->session->set_flashdata($alerta);
        redirect('cotizaciones/mantenimientos/caracteristicas');
    }

    public function new_crud()
    {
        $db_driver = $this->db->platform();
        $model_name = 'grocery_crud_model_' . $db_driver;
        $model_alias = 'm' . substr(md5(rand()), 0, rand(4, 15));

        unset($this->{$model_name});
        $this->load->library('grocery_CRUD');
        $crud = new Grocery_CRUD();
        if (file_exists(APPPATH . '/models/' . $model_name . '.php')) {
            $this->load->model('grocery_crud_generic_model');
            $this->load->model($model_name, $model_alias);
            $crud->basic_model = $this->{$model_alias};
        }
        return $crud;
    }

    public function get_suma_horas_mob_gif()
    {
        $horas_mob = $horas_gif = 0;
        if ($_POST) {
            $art_id = $this->input->post('art');
            $cva_id = $this->input->post('cva');
            $mob_id = $this->input->post('mob');
            $gif_id = $this->input->post('gif');
            if ($mob_id > 0) {
                $suma = $this->gsatelite->get_suma('eta_etapa_articulo', 'eta_duracion_mod', array('eta_id_cva' => $cva_id, 'eta_id_art' => $art_id, 'eta_estado' => 1));
                if ($suma > 0) {
                    $horas_mob = $suma;
                }
            }
            if ($gif_id > 0) {
                $suma = $this->gsatelite->get_suma('eta_etapa_articulo', 'eta_duracion', array('eta_id_cva' => $cva_id, 'eta_id_art' => $art_id, 'eta_estado' => 1));
                if ($suma > 0) {
                    $horas_gif = $suma;
                }
            }
        }
        $arreglo = array('ctdad_mob' => $horas_mob, 'ctdad_gif' => $horas_gif);
        echo json_encode($arreglo);
    }


    /*
     * Edith Herrera
     * Acción de presupuesto para el producto
     *
    */
    function presupuesto($art_id = null)
    {
        satelite_validar();
        $this->gsatelite->verificar_registro_real('art_articulo', $art_id);
        $articulo = $this->gsatelite->get_tabla('art_articulo', array('art_id' => $art_id));
        $data['art_id'] = $art_id;
        $data['articulo'] = $articulo[0];
        $data['recetas'] = $this->gsatelite->get_tabla('rea_receta_articulo', array('rea_id_art' => $art_id));
        $data['recetas_activas'] = $this->gsatelite->get_tabla('rea_receta_articulo', array('rea_id_art' => $art_id, 'rea_estado' => 1));
        $data['titulo_personal'] = "Costeo Producto";
        cargarvista($data);
    }

    public function presupuesto_producto($art_id = null, $rea_id = 0)
    {
        satelite_validar();
        $max_cod_rea_art = $this->gsatelite->get_max('rea_receta_articulo', 'rea_correlativo', array('rea_id_art' => $art_id));
        if ($_POST) {
            // var_dump($_POST);die();
            $post_array = $this->input->post();
            $cantidadBase = ($post_array['cantidad_producir'] != "") ? floatval($post_array['cantidad_producir']) : 1;
            $codigo_receta = $post_array['codigo_receta'];
            $nombre_receta = $post_array['nombre_receta'];
            $art_id = $post_array['art_id'];
            $rea_id = $post_array['rea_id'];
            $hdnDetalleMateria = $post_array['hdnDetalleMateria'];
            $etapas = $post_array['hdnEtapas'];
            $materiaPrima = $post_array['materiaPrima'];
            $conversionesMateria = $post_array['conversionesMateria'];
            $proveedoresMateria = $post_array['proveedoresMateria'];
            $precioUnitarioFijo = $post_array['pre_fijo_uni'];
            $tipo_precio = $post_array['tipo_precio'];
            $cantidadesMateria = $post_array['cantidadesMateria'];
            $chkEstMateria = $post_array['chkEstMateria'];
            $hdnDetalleMob = $post_array['hdnDetalleMob'];
            $manoObra = $post_array['manoObra'];
            $responsanblesMob = $post_array['responsanblesMob'];
            $cantidadesMob = $post_array['cantidadesMob'];
            $chkestmob = $post_array['chkEstMob'];
            $hdnDetalleGst = $post_array['hdnDetalleGst'];
            $estimacionesGasto = $post_array['estimacionesGasto'];
            $cantidadesGasto = $post_array['cantidadesGasto'];
            $preciosGasto = $post_array['preciosGasto'];
            $receta_defecto = $post_array['receta_defecto'];
            /////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            $hdnDetalleMateria = $post_array['hdnDetalleMateria'];
            $preciosMateria = $post_array['preciosMateria'];
            $preciosMob = $post_array['preciosMob'];
            //////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            $receta = array(
                'rea_id_art' => $art_id,
                'rea_codigo' => $codigo_receta,
                'rea_nombre' => $nombre_receta,
                'rea_cantidad_producir' => $cantidadBase,
                'rea_defecto' => $receta_defecto,
                'rea_estado' => 1,
                'rea_usu_modificacion' => $this->tank_auth->get_user_id(),
                'rea_fecha_modificacion' => date('Y-m-d H:i:s')
            );
            if ($rea_id > 0) {
                $id_rea = $rea_id;
                $this->gsatelite->actualizar_array('rea_receta_articulo', $receta, array('rea_id' => $rea_id));
            } else {
                $receta['rea_fecha'] = date('Y-m-d H:i:s');
                $receta['rea_correlativo'] = intval($max_cod_rea_art) + 1;
                $receta['rea_usu_creacion'] = $this->tank_auth->get_user_id();
                $receta['rea_fecha_creacion'] = date('Y-m-d H:i:s');
                $id_rea = $this->gsatelite->ingresar('rea_receta_articulo', $receta);
            }
            if ($receta_defecto > 0) {
                $this->gsatelite->actualizar_array('rea_receta_articulo', array('rea_defecto' => 0), array('rea_id_art' => $art_id, 'rea_id <> ' => $id_rea));
            }
            $resultado = 0;
            /**************** MATERIA PRIMA ****************/
            $idsMateria = array();
            if (count($hdnDetalleMateria) > 0) {
                for ($i = 0; $i < count($hdnDetalleMateria); $i++) {
                    if ($hdnDetalleMateria[$i] > 0) {
                        $idsMateria[] = $hdnDetalleMateria[$i];
                    }
                }
            }
            //Se eliminan los detalles que no se procesaron.
            $dataMateria = $this->gsatelite->get_tabla('mpa_materia_prima_articulo', array('mpa_id_art' => $art_id, 'mpa_id_rea' => $id_rea));
            if (count($dataMateria) > 0) {
                foreach ($dataMateria as $row) {
                    if (!in_array($row['mpa_id'], $idsMateria)) {
                        $this->gsatelite->borrado_general('mpa_materia_prima_articulo', array('mpa_id' => $row['mpa_id']));
                    }
                }
            }
            if (count($hdnDetalleMateria) > 0) {
                for ($i = 0; $i < count($hdnDetalleMateria); $i++) {
                    $cantidadMateria = convertirFloat($cantidadesMateria[$i]);
                    $materia_array = array(
                        'mpa_id_art' => $art_id,
                        'mpa_id_rea' => $id_rea,
                        'mpa_id_art_materia' => $materiaPrima[$i],
                        'mpa_id_cva' => ($conversionesMateria[$i] != '') ? $conversionesMateria[$i] : null,
                        'mpa_id_prv' => ($proveedoresMateria[$i] != '') ? $proveedoresMateria[$i] : null,
                        'mpa_id_etp' => ($etapas[$i] != '') ? $etapas[$i] : null,
                        'mpa_cantidad' => ($cantidadMateria / $cantidadBase),
                        'mpa_cantidad_base' => $cantidadBase,
                        'mpa_tipo_precio' => $tipo_precio[$i],
                        'mpa_estimacion_porcentaje' => $chkEstMateria[$i],
                        'mpa_estado' => 1,
                        'mpa_usu_creacion' => $this->tank_auth->get_user_id(),
                        'mpa_fecha_creacion' => date('Y-m-d H:i:s'),
                        'mpa_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'mpa_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    if ($tipo_precio[$i] == 4 && $precioUnitarioFijo[$i] > 0) {
                        $materia_array['mpa_precio'] = ($precioUnitarioFijo[$i] / $cantidadBase);
                    }
                    if ($hdnDetalleMateria[$i] > 0) {
                        unset($materia_array['mpa_id_art']);
                        unset($materia_array['mpa_usu_creacion']);
                        unset($materia_array['mpa_fecha_creacion']);
                        $resultado += $this->gsatelite->actualizar_array('mpa_materia_prima_articulo', $materia_array, array('mpa_id' => $hdnDetalleMateria[$i]));
                    } else {
                        $resultado += $this->gsatelite->ingresar('mpa_materia_prima_articulo', $materia_array);
                    }
                }
            }
            /**************** MANO DE OBRA ****************/
            $idsMob = array();
            if (count($hdnDetalleMob) > 0) {
                for ($i = 0; $i < count($hdnDetalleMob); $i++) {
                    if ($hdnDetalleMob[$i] > 0) {
                        $idsMob[] = $hdnDetalleMob[$i];
                    }
                }
            }
            //Se eliminan los detalles que no se procesaron.
            $dataMob = $this->gsatelite->get_tabla('moa_mano_obra_articulo', array('moa_id_art' => $art_id, 'moa_id_rea' => $id_rea));
            if (count($dataMob) > 0) {
                foreach ($dataMob as $row) {
                    if (!in_array($row['moa_id'], $idsMob)) {
                        $this->gsatelite->borrado_general('moa_mano_obra_articulo', array('moa_id' => $row['moa_id']));
                    }
                }
            }
            if (count($hdnDetalleMob) > 0) {
                for ($i = 0; $i < count($hdnDetalleMob); $i++) {
                    $cantidadMob = convertirFloat($cantidadesMob[$i]);
                    $mano_obra_array = array(
                        'moa_id_art' => $art_id,
                        'moa_id_rea' => $id_rea,
                        'moa_id_mob' => $manoObra[$i],
                        'moa_id_emp' => ($responsanblesMob[$i] != '') ? $responsanblesMob[$i] : null,
                        'moa_cantidad' => ($cantidadMob / $cantidadBase),
                        'moa_cantidad_base' => $cantidadBase,
                        'moa_estimacion_porcentaje' => $chkestmob[$i],
                        'moa_estado' => 1,
                        'moa_usu_creacion' => $this->tank_auth->get_user_id(),
                        'moa_fecha_creacion' => date('Y-m-d H:i:s'),
                        'moa_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'moa_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    if ($hdnDetalleMob[$i] > 0) {
                        unset($materia_array['moa_id_axo']);
                        unset($materia_array['moa_usu_creacion']);
                        unset($materia_array['moa_fecha_creacion']);
                        $resultado += $this->gsatelite->actualizar_array('moa_mano_obra_articulo', $mano_obra_array, array('moa_id' => $hdnDetalleMob[$i]));
                    } else {
                        $resultado += $this->gsatelite->ingresar('moa_mano_obra_articulo', $mano_obra_array);
                    }
                }
            }
            /**************** OTROS GASTOS ****************/
            $idsGastos = array();
            if (count($hdnDetalleGst) > 0) {
                for ($i = 0; $i < count($hdnDetalleGst); $i++) {
                    if ($hdnDetalleGst[$i] > 0) {
                        $idsGastos[] = $hdnDetalleGst[$i];
                    }
                }
            }
            //Se eliminan los detalles que no se procesaron.
            $dataGastos = $this->gsatelite->get_tabla('esr_estimacion_articulo', array('esr_id_art' => $art_id, 'esr_id_rea' => $id_rea));
            if (count($dataGastos) > 0) {
                foreach ($dataGastos as $row) {
                    if (!in_array($row['esr_id'], $idsGastos)) {
                        $this->gsatelite->borrado_general('esr_estimacion_articulo', array('esr_id' => $row['esr_id']));
                    }
                }
            }
            $tipo_gasto = $post_array['hdnTipoGastos'];
            if (count($hdnDetalleGst) > 0) {
                for ($i = 0; $i < count($hdnDetalleGst); $i++) {
                    $cantidadGasto = convertirFloat($cantidadesGasto[$i]);
                    $precioGasto = convertirFloat($preciosGasto[$i]);
                    $gastos_exr = array(
                        'esr_id_esm' => $estimacionesGasto[$i],
                        'esr_id_art' => $art_id,
                        'esr_id_rea' => $id_rea,
                        'esr_cantidad' => ($cantidadGasto / $cantidadBase),
                        'esr_tipo_costo' => $tipo_gasto[$i],
                        'esr_precio' => ($precioGasto / $cantidadBase),
                        'esr_cantidad_base' => $cantidadBase,
                        'esr_estado' => 1,
                        'esr_usu_creacion' => $this->tank_auth->get_user_id(),
                        'esr_fecha_creacion' => date('Y-m-d H:i:s'),
                        'esr_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'esr_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    if ($hdnDetalleGst[$i] > 0) {
                        unset($gastos_exr['esr_id_art']);
                        unset($gastos_exr['esr_usu_creacion']);
                        unset($gastos_exr['esr_fecha_creacion']);
                        $resultado += $this->gsatelite->actualizar_array('esr_estimacion_articulo', $gastos_exr, array('esr_id' => $hdnDetalleGst[$i]));
                    } else {
                        $resultado += $this->gsatelite->ingresar('esr_estimacion_articulo', $gastos_exr);
                    }
                }
            }
            if ($resultado > 0) {
                //Se actualizan los totales en el artículo.
                $txtTotalMateriaPrima = ($post_array['txtTotalMateria'] > 0) ? convertirFloat($post_array['txtTotalMateria']) : null;
                $txtTotalManoObra = ($post_array['txtTotalManoObra'] > 0) ? convertirFloat($post_array['txtTotalManoObra']) : null;
                $txtTotalGastos = ($post_array['txtTotalGastos'] > 0) ? convertirFloat($post_array['txtTotalGastos']) : null;
                $totalCosto = ($post_array['txtTotalCostos'] > 0) ? convertirFloat($post_array['txtTotalCostos']) : null;
                $txtObservacion = ($post_array['txtObservacion'] != '') ? $post_array['txtObservacion'] : null;
                $articulo_array = array( //ACTUALIZA EL ARTICULO CON LA ULTIMA RECETA
                    'art_total_materia_prima' => $txtTotalMateriaPrima,
                    'art_total_mano_obra' => $txtTotalManoObra,
                    'art_total_gastos' => $txtTotalGastos,
                    'art_total_presupuesto' => $totalCosto,
                    'art_observacion_presupuesto' => $txtObservacion,
                    'art_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'art_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                $this->gsatelite->actualizar_array('art_articulo', $articulo_array, array('art_id' => $art_id));
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Costeo", 'texto_alerta' => "Información procesada correctamente.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Costeo", 'texto_alerta' => "No se procesó ningun registro, favor verificar información.");
            }
            $this->session->set_flashdata($alerta);
            $tipoBtn = $post_array['btnCrear'];
            if ($tipoBtn > 1) {
                redirect('cotizaciones/mantenimientos/presupuesto/' . $art_id);
            } else {
                redirect("cotizaciones/mantenimientos/presupuesto_producto/" . $art_id . "/" . $id_rea);
            }
        } else {
            $articulo = $this->gsatelite->get_tabla('art_articulo', array('art_id' => $art_id));
            $data['receta'] = $this->gsatelite->get_tabla('rea_receta_articulo', array('rea_id_art' => $art_id, 'rea_id' => $rea_id));
            //Validar si tiene etapas
            $result_etapas = $this->proyecto_model->verificar_tiene_etapas(array('art_id' => $art_id));
            $decimales_json = $this->gsatelite->get_parametro('SYS_NUMERO_DECIMALES_PRODUCCION');
            $map = $this->gsatelite->get_dropdown('art_articulo', '{art_codigo} - {art_nombre}', '', array('art_materia_prima' => 1, 'art_estado' => 1), null, null, 'art_id', true);
            $prv = $this->gsatelite->get_dropdown('prv_proveedor', "[IF(prv_tipo_pers = 1, CONCAT(prv_codigo, ' - ', prv_nombre, ' ', prv_apellido), CONCAT(prv_codigo, ' - ', prv_apellido))]", '', array('prv_estado' => 1), null, null, 'prv_id', true);
            if ($decimales_json != "") {
                $decimales_array = json_decode($decimales_json, true);
                $data['decimales'] = ($decimales_array["presupuesto"] != NULL && $decimales_array["presupuesto"] != "") ? $decimales_array["presupuesto"] : 2;
            } else {
                $data['decimales'] = $this->gsatelite->get_parametro('NUMERO_DECIMALES', 2);
            }
            $this->db->join('cva_conversion_articulo', 'cva_id_mep = mep_id');
            $data['articulo_medida'] = $this->gsatelite->get_tabla('mep_medida_producto', array('mep_estado' => 1, 'cva_estado' => 1, 'cva_defecto' => 1, 'cva_id_art' => $art_id));
            $data['decimales_monetarios'] = $this->gsatelite->get_parametro('NUMERO_DECIMALES', 2);
            $data['emp_default'] = $this->gsatelite->get_dropdown('emp_empleado', '{emp_codigo} - {emp_nombre}' . ' ' . '{emp_apellido}', '', array('emp_estado' => 1), null, '', 'emp_id', true);
            $data['etapas'] = (count($result_etapas) > 0) ? $result_etapas : $this->gsatelite->get_tabla('etp_etapa', array('etp_estado' => 1));
            $data['art_id'] = $art_id;
            $data['rea_id'] = $rea_id;
            $data['articulo'] = $articulo[0];
            $data['cod_sug'] = generar_codigo_cor((intval($max_cod_rea_art) + 1), 3);
            $data['lista'] = $this->gsatelite->get_tabla('art_articulo');
            $data['obra'] = $this->gsatelite->get_tabla('mob_mano_obra', array('mob_estado' => 1));
            $data['resp'] = $this->gsatelite->get_tabla('emp_empleado');
            $data['est'] = $this->gsatelite->get_tabla('esm_estimacion');
            // Se carga el presupuesto agregado al producto, si existe.
            $data['materia_prima_prod'] = $this->cotizaciones_model->get_materia_prima_presupuesto(array('mpa_id_art' => $art_id, 'mpa_id_rea' => $rea_id));
            $data['mano_obra_prod'] = $this->cotizaciones_model->get_mano_obra_presupuesto(array('moa_id_art' => $art_id, 'moa_id_rea' => $rea_id));
            $data['gastos_indirectos'] = $this->cotizaciones_model->get_gastos_indirectos_presupuesto(array('esr_id_art' => $art_id, 'esr_id_rea' => $rea_id));
            $data['mano_obra'] = $this->gsatelite->get_tabla('mob_mano_obra', array('mob_estado' => 1));
            $data['estimaciones'] = $this->gsatelite->get_tabla('esm_estimacion', array('esm_estado' => 1));
            $data['proveedores'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '<option value=""></option>', $prv);
            $data['materia_prima'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '<option value=""></option>', $map);
        }
        $data['titulo_personal'] = "Costeo Producto";
        $this->_cargarvista($data);
    }

    public function active_inactivate_recipe($art_id, $rea_id, $estado)
    {
        $actualizar = array('rea_estado' => $estado, 'rea_usu_modificacion' => $this->tank_auth->get_user_id(), 'rea_fecha_modificacion' => date('Y-m-d H:i:s'));
        if ($estado > 0) {
            $actualizar['rea_fecha'] = date('Y-m-d H:i:s');
        }
        $exito = $this->gsatelite->actualizar_array('rea_receta_articulo', $actualizar, array('rea_id' => $rea_id, 'rea_id_art' => $art_id));
        if ($exito > 0) {
            $this->gsatelite->show_dialog("El Estado del Costeo se procesó correctamente.", "cotizaciones/mantenimientos/presupuesto/$art_id", "success", "Éxito");
        } else {
            $this->gsatelite->show_dialog("No se pudo procesar el Nuevo Estado",  "cotizaciones/mantenimientos/presupuesto/$art_id", "error", "Ocurrió un error");
        }
    }

    /**
     * @author Elman Ortiz
     * @date 22/08/2017
     */
    function caracteristicas_editar($car_id = null)
    {
        satelite_validar();
        if ($_POST) { //Guardar datos

            $car_id = $this->input->post('car_id');
            //Crear arreglo caracteristicas
            $caracteristica_array = array(
                'car_codigo' => ($this->input->post('car_codigo')) ? $this->input->post('car_codigo') : null,
                'car_nombre' => $this->input->post('inpNombre'),
                'car_descripcion' => $this->input->post('inpDescripcion'),
                'car_tipo' => $this->input->post('slcTipo'),
                'car_estado' => $this->input->post('slcEstado'),
                'car_usu_crea' => $this->tank_auth->get_user_id(),
                'car_fecha_crea' => date('Y-m-d H:i:s'),
                'car_usu_mod' => $this->tank_auth->get_user_id(),
                'car_fecha_mod' => date('Y-m-d H:i:s')
            );

            $this->gsatelite->actualizar_array('car_caracteristica', $caracteristica_array, array('car_id' => $car_id));
            $res = $this->gsatelite->borrado_general('vrl_valores_lista', array('vrl_id_car' => $car_id));
            $valor = $this->input->post('valores');
            $precio = $this->input->post('preciosCaUpdate');
            $lista = array_combine($valor, $precio);

            //print_r(count($lista)); die();
            if ($lista) {
                //$elem = " ";
                foreach ($lista as $key => $value) {
                    //vrl_valores_lista
                    $valores_lista_array = array(
                        'vrl_id_car' => $car_id,
                        'vrl_valor' => $key,
                        'vrl_precio_valor' => ($value != '') ? $value : null,
                        'vrl_estado' => 1,
                        'vrl_usu_creacion' => $this->tank_auth->get_user_id(),
                        'vrl_fecha_creacion' => date('Y-m-d H:i:s'),
                        'vrl_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'vrl_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $result = $this->gsatelite->ingresar('vrl_valores_lista', $valores_lista_array);
                }
            }

            if ($car_id > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Agregar caracteristica", 'texto_alerta' => "El registro se guardó correctamente.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Agregar caracteristica", 'texto_alerta' => "Ocurrio un problema al crear el registro.");
            }
            $this->session->set_flashdata($alerta);

            if ($this->input->post('tipoboton') == 'save') {
                redirect('cotizaciones/mantenimientos/caracteristicas_editar/' . $car_id);
            } else {
                redirect('cotizaciones/mantenimientos/caracteristicas/');
            }
        } else { //Cargar datos
            satelite_validar();
            $this->db->join('vrl_valores_lista', 'car_id =vrl_id_car', 'left');
            $carac = $this->gsatelite->get_tabla('car_caracteristica', array('car_id' => $car_id));
            $data['caracteristica'] = $carac;
            $data['car_id'] = $car_id;
            $data['car_codigo'] = $carac[0]['car_codigo'];
            $data['titulo_personal'] = "Editar características";
            $this->_cargarvista($data);
        }
    } //caracteristicas editar


    /**
     * @author René Castaneda
     * @since 2017-09-07
     * @return Mantenimiento tabla tipo_documento
     */
    public function tipo_documento()
    {
        satelite_validar();
        $this->load->library('../controllers/expediente_personal/catalogos');
        $url_vista = 'expediente_personal/catalogos/tipo_documento';
        $this->catalogos->tipo_documento($url_vista);
        die('éxito');
    }

    /**
     * @author Edith Herrera
     * @since  02/10/2017
     * @return Mantenimiento tabla mat_motivo_atencion
     */
    public function motivo_atencion($url_vista = '')
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            // Variable para permisos. Agregado por Luis Navarro
            $permisos = $this->gsatelite->get_permisos_opcion();
            $crud = new grocery_CRUD();
            $crud->set_table('mat_motivo_atencion');
            $crud->set_subject('');
            $crud->fields('mat_nombre', 'mat_descripcion', 'mat_estado', 'mat_usu_modificacion', 'mat_fecha_modificacion', 'mat_usu_creacion', 'mat_fecha_creacion');

            $crud->required_fields('mat_nombre', 'mat_estado');
            $crud->columns('mat_nombre', 'mat_descripcion', 'mat_estado');
            $crud->display_as('mat_nombre', 'Nombre');
            $crud->display_as('mat_descripcion', 'Descripción');
            $crud->display_as('mat_estado', 'Estado');
            $crud->field_type('mat_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('mat_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('mat_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('mat_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->set_rules('mat_nombre', 'Nombre', 'trim|required|campo_unico[mat_motivo_atencion.mat_nombre]');

            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('mat_estado', 'hidden', 1);
            } else {  // Editar
                $crud->field_type('mat_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            // Validar Permisos. Agregado por Luis Navarro
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if ($permisos['permite_ver']) {
                $data_url = $this->masterpage->getUsuario();
                $url_read = $data_url['modulo'] . '/' . $data_url['control'] . '/' . $data_url['funcion'];
                $crud->add_action('Ver', 'minia-icon-search', $url_read . "/read");
            }

            $output = $crud->render();
            $data['titulo_personal'] = "Motivos de llamada";
            $this->_cargarvista($data, $output, $url_vista);
        }
    }

    /**
     * @author Edith Herrera
     * @since  03/10/2017
     * @return Mantenimiento tabla esn_estado_atencion
     */
    public function estado_llamada($url_vista = '')
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $permisos = $this->gsatelite->get_permisos_opcion();
            $crud = new grocery_CRUD();
            $crud->set_table('esn_estado_atencion');
            //$crud->set_subject('Estado de llamada');
            $crud->set_subject('');
            $crud->fields('esn_nombre', 'esn_descripcion', 'esn_estado', 'esn_usu_modificacion', 'esn_fecha_modificacion', 'esn_usu_creacion', 'esn_fecha_creacion');
            $crud->required_fields('esn_nombre', 'esn_estado');
            $crud->columns('esn_nombre', 'esn_descripcion', 'esn_estado');
            $crud->display_as('esn_nombre', 'Nombre');
            $crud->display_as('esn_descripcion', 'Descripción');
            $crud->display_as('esn_estado', 'Estado');
            $crud->field_type('esn_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('esn_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('esn_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('esn_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->set_rules('esn_nombre', 'Nombre', 'trim|required|campo_unico[esn_estado_atencion.esn_nombre]');

            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('esn_estado', 'hidden', 1);
            } else {  // Editar
                $crud->field_type('esn_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            // Validaciones
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if ($permisos['permite_ver']) {
                $data_url = $this->masterpage->getUsuario();
                $url_read = $data_url['modulo'] . '/' . $data_url['control'] . '/' . $data_url['funcion'];
                $crud->add_action('Ver', 'minia-icon-search', $url_read . "/read");
            }

            $output = $crud->render();
            $data['titulo_personal'] = "Estados de llamada";
            $this->_cargarvista($data, $output, $url_vista);
        }
    }

    /**
     * @author Edith Herrera
     * @since  03/10/2017 - modificado
     * @return Mantenimiento tabla esn_estado_atencion
     * Módulos padre: Sistema.
     */
    function manto_estimacion()
    {
        $this->load->library('../controllers/sistema/mantenimientos_compartidos');
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion('cotizaciones/mantenimientos/manto_estimacion');
        $this->mantenimientos_compartidos->estimacion($permisos, 'cotizaciones');
    }

    public function detalle_calculo_estimacion($esm_id)
    {
        satelite_validar();
        $this->load->library('../controllers/sistema/mantenimientos_compartidos');
        $permisos = $this->gsatelite->get_permisos_opcion('cotizaciones/mantenimientos/manto_estimacion');
        $this->mantenimientos_compartidos->detalle_calculo_estimacion($esm_id);
    }

    /**
     * @author Francisco Orozco
     * @since  31/10/2017
     * @return Mantenimiento tabla epr_estado_proyecto
     */
    function estado_proyecto()
    {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion('cotizaciones/mantenimientos/estado_proyecto');

        $crud = new grocery_CRUD;
        $colums = array(
            'epr_nombre',
            'epr_cierre',
            'epr_estado'
        );

        $add = array(
            'epr_nombre',
            'epr_cierre',
            'epr_estado',
            'epr_usu_creacion',
            'epr_fecha_creacion',
            'epr_usu_modificacion',
            'epr_fecha_modificacion'
        );

        $edit = array(
            'epr_nombre',
            'epr_estado',
            'epr_cierre',
            'epr_usu_modificacion',
            'epr_fecha_modificacion'
        );

        $alias = array(
            'epr_nombre'    => 'Nombre',
            'epr_cierre'    => 'Última etapa',
            'epr_estado'    => 'Estado'
        );

        $crud->set_table('epr_estado_proyecto')
            //->set_subject('Estado del proyecto')
            ->set_subject('')
            ->display_as($alias)
            ->columns($colums)
            ->add_fields($add)
            ->edit_fields($edit)
            ->required_fields($add)
            ->field_type('epr_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
            ->field_type('epr_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));

        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('epr_estado', 'hidden', 1)
                ->field_type('epr_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('epr_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));

            //verificar si ya existe un dato con flag cierre 1.
            $cantidad_cierre = $this->gsatelite->count('epr_estado_proyecto', array('epr_cierre' => 1));
            if ($cantidad_cierre > 0) {
                $crud->field_type('epr_cierre', 'hidden', '0 ');
            } else {
                $crud->field_type('epr_cierre', 'dropdown', array('1' => 'Si', '0' => 'No'));
            }
        } else {
            $crud->field_type('epr_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));

            $url = explode('/', uri_string());
            if (in_array("edit", $url, TRUE)) {
                $epr_id = end(explode('/', uri_string()));

                if (is_numeric($epr_id)) {
                    //verificar si ya existe un dato con flag cierre 1.
                    $cantidad_cierre = $this->gsatelite->count('epr_estado_proyecto', array('epr_cierre' => 1, 'epr_id <>' => $epr_id));

                    if ($cantidad_cierre > 0) {
                        $crud->field_type('epr_cierre', 'hidden', '0 ');
                    } else {
                        $crud->field_type('epr_cierre', 'dropdown', array('1' => 'Si', '0' => 'No'));
                    }
                }
            } else {
                $crud->field_type('epr_cierre', 'dropdown', array('1' => 'Si', '0' => 'No'));
            }
        }

        // Validaciones
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }

        if (!$permisos['permite_editar']) {
            $crud->unset_edit();
        }

        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }

        if ($permisos['permite_ver']) {
            $crud->add_action('Ver', 'minia-icon-search', 'cotizaciones/mantenimientos/estado_proyecto/read');
        }

        $output = $crud->render();
        $data['titulo_personal'] = 'Estados del proyecto';
        $this->_cargarvista($data, $output);
    }

    /**
     * @author Francisco Orozco
     * @since  31/10/2017
     * @return Creacion de proyectos para el cliente, tabla pcl_proyecto_cliente.
     */
    function proyectos($cli_id = 0)
    {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion('cotizaciones/mantenimientos/clientes');
        $cli_cliente = $this->gsatelite->get_tabla('cli_cliente', array('cli_id' => $cli_id));

        if ($cli_cliente[0]['cli_personeria'] == 1) {
            $cliente = $cli_cliente[0]['cli_nombre'] . " " . $cli_cliente[0]['cli_apellido'];
        } else {
            $cliente = $cli_cliente[0]['cli_apellido'];
        }

        $arreglo    = explode('/', uri_string());
        $idno       = 0;
        if (is_numeric(end($arreglo))) {
            $idno = end($arreglo);
        }

        $crud = new grocery_CRUD;
        $colums = array(
            'pcl_codigo',
            'pcl_id_padre',
            'pcl_nombre',
            'pcl_id_scl',
            'pcl_id_epr'
        );

        $add = array(
            'pcl_id_padre',
            'pcl_id_cli',
            'pcl_nombre',
            'pcl_codigo',
            'pcl_descripcion',
            'pcl_id_scl',
            'pcl_id_epr',
            'pcl_estado',
            'pcl_usu_creacion',
            'pcl_fecha_creacion',
            'pcl_usu_modificacion',
            'pcl_fecha_modificacion'
        );

        $edit = array(
            'pcl_id_padre',
            'pcl_id_cli',
            'pcl_id_scl',
            'pcl_id_epr',
            'pcl_codigo',
            'pcl_nombre',
            'pcl_descripcion',
            'pcl_estado',
            'pcl_usu_modificacion',
            'pcl_fecha_modificacion'
        );

        $required = array(
            'pcl_id_cli',
            'pcl_nombre',
            'pcl_codigo',
            'pcl_descripcion',
            'pcl_id_epr',
            'pcl_estado',
            'pcl_usu_modificacion',
            'pcl_fecha_modificacion'
        );

        $alias = array(
            'pcl_id_padre'      => 'Nivel superior',
            'pcl_id_scl'        => 'Sucursal',
            'pcl_id_epr'        => 'Estado del proyecto',
            'pcl_codigo'        => 'Código',
            'pcl_nombre'        => 'Nombre',
            'pcl_descripcion'   => 'Descripción',
            'pcl_estado'        => 'Estado',
        );

        $crud->set_table('pcl_proyecto_cliente')
            ->set_subject('')
            //->set_subject('Proyecto del cliente')
            ->display_as($alias)
            ->columns($colums)
            ->add_fields($add)
            ->edit_fields($edit)
            ->required_fields($required)
            ->field_type('pcl_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
            ->field_type('pcl_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
            ->field_type('pcl_id_cli', 'hidden', $cli_id)
            ->set_relation('pcl_id_scl', 'scl_sucursal_cliente', 'scl_nombre', array('scl_estado' => 1, 'scl_id_cli' => $cli_id))
            ->set_rules('pcl_codigo', 'Código', "required|trim|campo_unico2[pcl_proyecto_cliente.pcl_codigo.pcl_id_cli.$cli_id]")
            ->where('pcl_proyecto_cliente.pcl_id_cli', $cli_id);

        $crud->set_relation('pcl_id_padre', 'pcl_proyecto_cliente', '{pcl_nombre}', array('pcl_id_cli' => $cli_id, 'pcl_estado' => 1, 'pcl_id !=' => $idno), 'pcl_nombre');

        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('pcl_estado', 'hidden', 1)
                ->field_type('pcl_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('pcl_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
        } else {
            $crud->field_type('pcl_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

        $ruta = explode('/', uri_string());

        if (in_array("read", $ruta)) {
            $crud->set_relation('pcl_id_epr', 'epr_estado_proyecto', 'epr_nombre', array('epr_estado' => 1));
        } else {
            $crud->set_relation('pcl_id_epr', 'epr_estado_proyecto', 'epr_nombre', array('epr_estado' => 1, 'epr_cierre <>' => 1));
        }
        // Validaciones
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }

        if (!$permisos['permite_editar']) {
            $crud->unset_edit();
        }

        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }

        if ($permisos['permite_ver']) {
            $crud->add_action('Ver', 'minia-icon-search', "cotizaciones/mantenimientos/proyectos/$cli_id/read", 'ver_proyectos');
        }

        $crud->add_action('Finalizar proyecto', 'brocco-icon-checkmark', 'cotizaciones/mantenimientos/proyectos', 'finalizar');

        $output = $crud->render();
        $data['titulo_personal'] = 'Proyectos del cliente ' . $cliente;
        $this->_cargarvista($data, $output);
    }

    /**
     * @author Francisco Orozco
     * @since  31/10/2017
     * @return verifica si algun estado de un proyecto de la tabla epr_estado_proyecto posee el flag de cierre.
     */
    function verificar_estado_finalizado()
    {
        satelite_validar();
        $result = $this->gsatelite->count("epr_estado_proyecto", array("epr_cierre" => 1));
        echo $result;
    }

    /**
     * @author Francisco Orozco
     * @since  31/10/2017
     * @return Finalizar un proyecto de un cliente.
     */
    function finalizar_proyecto()
    {
        $post_array             = $this->input->post();

        $pcl_descripcion_cierre = $post_array['txt_descripcion'];
        $pcl_id                 = $post_array['txt_proyecto'];
        $link                   = (isset($post_array['txt_ruta'])) ? $post_array['txt_ruta'] : "";
        $pcl_id_epr             = $this->gsatelite->get_campo('epr_estado_proyecto', 'epr_id', array("epr_cierre" => 1));

        $pcl_proyecto_cliente = array(
            'pcl_descripcion_cierre'    => $pcl_descripcion_cierre,
            'pcl_id_usu_cierre'         => $this->tank_auth->get_user_id(),
            'pcl_fecha_cierre'          => date('Y-m-d H:i:s'),
            'pcl_usu_modificacion'      => $this->tank_auth->get_user_id(),
            'pcl_fecha_modificacion'    => date('Y-m-d H:i:s'),
            'pcl_id_epr'                => $pcl_id_epr
        );

        $result = $this->gsatelite->actualizar_array('pcl_proyecto_cliente', $pcl_proyecto_cliente, array('pcl_id' => $pcl_id));

        if ($result > 0) {
            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Proyectos", 'texto_alerta' => "Los registros se ingresaron con éxito.");
        } else {
            $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Proyectos", 'texto_alerta' => "Ocurrió un error al guardar la información.");
        }

        $cliente = $this->gsatelite->get_campo('pcl_proyecto_cliente', 'pcl_id_cli', array("pcl_id" => $pcl_id));

        $this->session->set_flashdata($alerta);

        if ($link == "") {
            redirect('cotizaciones/mantenimientos/proyectos/' . $cliente);
        } else {
            redirect($link);
        }
    }

    /**
     * @author Francisco Orozco
     * @since  01/11/2017
     * @return Verifica si el proyecto si esta finalizado.
     */
    function verificar_proyecto_finalizado()
    {
        $post_array     = $this->input->post();
        $pcl_id         = $post_array['proyecto'];
        $this->db->join('epr_estado_proyecto', 'epr_id = pcl_id_epr');
        $proyecto       = $this->gsatelite->get_tabla("pcl_proyecto_cliente", array("pcl_id" => $pcl_id, "epr_cierre" => 1));

        if (count($proyecto) > 0) {
            $result = 1; //proyecto esta finalizado
        } else {
            $result = 0; //proyecto no esta finalizdo
        }
        echo $result;
    }

    /**
     * @author Francisco Orozco
     * @since  01/11/2017
     * @return obtener la descripcion de finalizacion de un proyecto
     */
    function obtener_descripcion()
    {
        satelite_validar();
        $post_array     = $this->input->post();
        $pcl_id         = $post_array['proyecto'];
        $result         = $this->gsatelite->get_campo("pcl_proyecto_cliente", 'pcl_descripcion_cierre', array("pcl_id" => $pcl_id));
        echo $result;
    }

    function mover_img_gral($ruta, $destino, $archivo)
    {
        if (is_dir($ruta)) {
            if (copy($ruta . '/' . $archivo, $destino . '/' . $archivo)) {
                return unlink($ruta . '/' . $archivo);
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    function eliminar_imagen_gral2($archivo = "")
    {
        unlink("./uploads/anexos_cliente/" . $archivo);
    }

    function eliminar_anexo_cliente(){
        if ($_POST) {
            $anxid = $this->input->post('anexo');
            $idaxn = $this->input->post('indice');
            if ($anxid > 0 && $idaxn > 0) {
                $url = $this->gsatelite->get_campo('anx_anexo', 'anx_url', array('anx_id' => $anxid));
                if (unlink($url)) {
                    $this->gsatelite->borrado_general('axn_anexoxcliente', array('axn_id' => $idaxn));
                    $result = $this->gsatelite->borrado_general('anx_anexo', array('anx_id' => $anxid));
                    echo $result;
                }
            }
        }
    }

    /**
     * @author Francisco Orozco
     * @since  02/01/2018
     * @return generar codigo sugerido para cliente.
     */
    function generar_codigo_cliente()
    {
        satelite_validar();
        if ($_POST) {
            $clasificacion_id   = $this->input->post("clasificacion");
            $clasificacion      = $this->gsatelite->get_campo("cfc_clasificacion_cliente", "cfc_prefijo", array("cfc_id" => $clasificacion_id));
            $cliente            = ($this->input->post("cliente") != null) ? $this->input->post("cliente") : 0;
            $cantidad           = $this->gsatelite->count("cli_cliente", array("cli_id_cfc" => $clasificacion_id));
            $result             = trim($clasificacion . str_pad($cantidad + 1, 4, "0", STR_PAD_LEFT));
            $i                  = 1;
            $clasificacion_old  = NULL;

            if ($cliente != 0) {
                $clasificacion_old = $this->gsatelite->get_tabla("cli_cliente", array("cli_id" => $cliente));
                if ($clasificacion_old[0]["cli_id_cfc"] != $clasificacion_id) {
                    while ($this->gsatelite->get_campo("cli_cliente", "cli_codigo", array("cli_codigo" => $result)) != NULL) {
                        $i++;
                        $result             = $clasificacion . str_pad($cantidad + $i, 4, "0", STR_PAD_LEFT);
                    }
                } else {
                    $clasificacion_old[0]["cli_codigo"];
                }
            } else {
                while ($this->gsatelite->get_campo("cli_cliente", "cli_codigo", array("cli_codigo" => $result)) != NULL) {
                    $i++;
                    $result             = $clasificacion . str_pad($cantidad + $i, 4, "0", STR_PAD_LEFT);
                }
            }
            echo $result;
        }
    }

    function tipos_pago()
    {
        satelite_validar();
        $this->load->library('../controllers/facturacion/entradas');
        $this->entradas->tipos_pago('cotizaciones/mantenimientos');
    }

    function agregar_tipo_pago()
    {
        satelite_validar();
        $this->load->library('../controllers/facturacion/entradas');
        $this->entradas->agregar_tipo_pago('cotizaciones/mantenimientos');
    }

    function editar_tipo_pago($id_tipo_pago, $ruta = null)
    {
        satelite_validar();
        $this->load->library('../controllers/facturacion/entradas');
        $this->entradas->editar_tipo_pago($id_tipo_pago, 'cotizaciones/mantenimientos');
    }

    public function tabla_llamadas_vendedor($id_ven = null)
    {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();

        //preguntar por el vendedor dependiendo el usuario
        $id_usuario = $this->tank_auth->get_user_id();
        $registro = $this->gsatelite->get_tabla('ven_vendedor', array('ven_id_usu' => $id_usuario));

        //validar que sea un registro unico y que no este vacio
        if ($registro > 0 and count($registro) == 1) {
            $id_vendedor = $registro[0]['ven_id'];
            $data['NombreVendedor'] = $registro[0]['ven_nombre'] . ' ' . $registro[0]['ven_apellidos'];
        } else {
            $this->gsatelite->show_dialog('El usuario no es un vendedor', 'cotizaciones/index', 'note');
        }

        $columns = array(
            'tbl_fecha',
            'tbl_cliente_nombre',
            'tbl_cliente_apellido',
            'tbl_id_ven',
            'tbl_recado'
        );

        $add_fields = array(
            'tbl_fecha',
            'tbl_cliente_nombre',
            'tbl_cliente_apellido',
            'tbl_telefono',
            'tbl_correo',
            'tbl_direccion',
            'tbl_id_sec',
            'tbl_id_ven',
            'tbl_contacto',
            'tbl_nuevo',
            'medios',
            'tbl_usu_recibe',
            'tbl_recado',
            'tbl_fecha_mod',
            'tbl_usu_mod',
            'tbl_fecha_crea',
            'tbl_usu_crea'
        );

        $edit_fields = array(
            'tbl_cliente_nombre',
            'tbl_cliente_apellido',
            'tbl_telefono',
            'tbl_correo',
            'tbl_direccion',
            'tbl_id_sec',
            'tbl_id_ven',
            'tbl_contacto',
            'tbl_nuevo',
            'medios',
            'tbl_usu_recibe',
            'tbl_recado',
            'tbl_fecha_mod',
            'tbl_usu_mod'
        );

        $display_as = array(
            'tbl_fecha'             => 'Fecha',
            'tbl_cliente_nombre'    => 'Nombre',
            'tbl_cliente_apellido'  => 'Apellido',
            'tbl_telefono'          => 'Teléfono',
            'tbl_correo'            => 'Correo',
            'tbl_direccion'         => 'Dirección',
            'tbl_id_sec'            => 'Sector Cliente',
            'tbl_id_ven'            => 'Vendedor Asignado',
            'tbl_contacto'          => 'Contacto',
            'tbl_nuevo'             => '¿Cliente nuevo?',
            'medios'                => 'Medio de contacto',
            'tbl_recado'            => 'Recado',
        );

        $required = array(
            'tbl_fecha',
            'tbl_cliente_nombre',
            'tbl_cliente_apellido',
            'tbl_contacto',
            'tbl_recado'
        );

        $crud = new grocery_CRUD();
        $crud->set_table('tbl_tabla_llamadas');
        $crud->set_subject('');
        $crud->where('tbl_id_ven', $id_vendedor);
        $crud->order_by('tbl_id', 'desc');
        $crud->add_fields($add_fields);
        $crud->edit_fields($edit_fields);
        $crud->columns($columns);
        $crud->display_as($display_as);
        $crud->required_fields($required);
        $crud->set_relation('tbl_id_sec', 'sec_sector_cliente', 'sec_nombre', array('sec_estado' => 1));
        $crud->set_relation('tbl_id_ven', 'ven_vendedor', '{ven_nombre} {ven_apellidos}', array('ven_estado' => 1));
        $crud->set_relation_n_n('medios', 'txt_tabla_llamadaxtipo_medio', 'tmc_tipo_medio', 'txt_id_tbl', 'txt_id_tmc', 'tmc_nombre', null, array('tmc_estado' => 1))
            ->field_type('tbl_usu_mod', 'hidden', $this->tank_auth->get_user_id())
            ->set_rules('tbl_correo', 'Correo', 'trim|valid_email')
            ->field_type('tbl_usu_recibe', 'hidden', $this->tank_auth->get_user_id())
            ->field_type('tbl_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
            ->field_type('tbl_fecha', 'hidden', date('Y-m-d H:i:s'))
            ->field_type('tbl_usu_crea', 'hidden', $this->tank_auth->get_user_id())
            ->field_type('tbl_id_ven', 'hidden', $id_vendedor)
            ->field_type('tbl_fecha_crea', 'hidden', date('Y-m-d H:i:s'))
            ->field_type('tbl_nuevo', 'dropdown', array('0' => 'No', '1' => 'Sí'))
            ->unset_delete(); // Se deshabilito la opcion de Eliminar

        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }

        if (!$permisos['permite_editar']) {
            $crud->unset_edit();
        }

        if (!$permisos['permite_ver']) {
            $crud->unset_read();
        }

        $output = $crud->render();
        $data['texto_boton'] = "Consultar Cliente";
        if (end(explode('/', uri_string())) == 'add') {
            $data['texto_boton'] = "Agregar Cliente";
        }
        $data['titulo_personal'] = "Tabla de llamadas";

        $this->_cargarvista($data, $output);
    }

    /**
     * @author Luis Navarro
     * @since  2018-06-23
     * @return Verificar si el flag de Clasificacion de cliente esta o no activo
     */
    public function verificar_flag_defecto_clc_clientes()
    {
        satelite_validar(true);

        if ($this->input->post()) {
            $flag       = $this->input->post("flag");
            $consulta   = $this->gsatelite->get_tabla('cfc_clasificacion_cliente', array('cfc_defecto' => 1, 'cfc_estado' => 1));

            if (count($consulta) > 0) {
                $defecto = 1;
            } else {
                $defecto = 0;
            }

            echo json_encode(array('id' => $consulta[0]['cfc_id'], 'cant_defecto' => count($consulta), 'es_defecto' => $defecto));
        }
    }

    /**
     * @author Luis Navarro
     * @since  2018-09-05
     * @return Verificar si existe el vendedor registado con ese usuario
     */
    public function validar_existe_vendedor()
    {
        satelite_validar(true);
        if ($this->input->post()) {
            $retornar       = array();
            $usuario        = (is_numeric($this->input->post("usuario")) && $this->input->post("usuario") > 0) ? $this->input->post("usuario") : 0;
            $existe_usuario = $this->gsatelite->get_tabla('ven_vendedor', array('ven_id_usu' => $usuario, 'ven_estado' => 1));
            if (count($existe_usuario) > 0) {
                $retornar['existe_usuario_ven'] = 1;
            } else {
                $retornar['existe_usuario_ven'] = 0;
            }
            echo json_encode($retornar);
            die();
        }
    }

    /**
     * @author Luis Navarro
     * @since  2018-09-06
     * @return Verificar si existe el codigo entre los clientes en las sucursales
     */
    public function validar_codigo_clientexsucursal()
    {
        satelite_validar(true);
        if ($this->input->post()) {
            $codigo   = (trim($this->input->post("codigo")) != "") ? $this->input->post("codigo") : '';
            $retornar = 0;
            $existe_codigo = $this->gsatelite->get_tabla('scl_sucursal_cliente', array('scl_codigo' => $codigo));
            if (count($existe_codigo) > 0) {
                $retornar = 1;
            }
            echo json_encode(array('existe_codigo' => $retornar));
            die();
        }
    }

    /**
     * @author Elman Ortiz
     * @since  2018-09-06
     * @return Clientes por segmento
     */
    public function clientes_x_segmento($idcac = null, $ajax = null)
    {
        if ($idcac == null) {
            $idcac = $this->input->post('idcac');
        }

        //clientes
        if ($idcac != '') {
            $clientes = $this->gsatelite->get_tabla('cli_cliente', array('cli_id_cac' => $idcac, 'cli_estado' => 1));
        } else {
            $clientes = $this->gsatelite->get_tabla('cli_cliente', array('cli_estado' => 1));
        }

        $client = '<option></option>';
        foreach ($clientes as $cli) {
            if ($cli['cli_codigo'] != '') {
                $codigo = trim($cli['cli_codigo']) . ' - ';
            } else {
                $codigo = '';
            }
            $nombre_cliente = ($cli['cli_personeria'] == 1) ? $codigo . $cli['cli_nombre'] . ' ' . $cli['cli_apellido'] : $codigo . $cli['cli_apellido'];
            $client .= '<option value="' . $cli['cli_id'] . '">' . $nombre_cliente . '</option>';
        }

        if ($ajax) {
            return $client;
        } else {
            echo $client;
        }
    }

    function _cargarvista($data = 0, $crud = 0, $ruta_vista = "")
    {
        $this->load->view('vacia', $crud);
        if ($data != 0)
            $data = array_merge($data, $this->masterpage->getUsuario());
        else
            $data = $this->masterpage->getUsuario();
        $vista = (trim($ruta_vista) != ''  and substr_count(trim($ruta_vista), '/') > 1) ? trim($ruta_vista) : $data['modulo'] . '/' . $data['control'] . '/' . $data['funcion'];
        $this->masterpage->setMasterPage('masterpage_default');
        $this->masterpage->addContentPage($vista, 'content', $data);
        $this->masterpage->show();
    }

    /**
     * @author Nelson David Soriano
     * @since  2019-03-26
     * @param  id_cliente
     * @return Mensaje de confirmacion si es posible eliminar el usuario o se rechaza al estar en algun proceso ya relacionado
     */

    public function  eliminar_clientex()
    {
        satelite_validar();
        $id  =  $this->input->post('id_clientex');

        $movimientos = $this->db->query('CALL eliminar_clientex(?)', array($id))->result_array();
        clean_mysqli_connection($this->db->conn_id);
        if ($movimientos[0]['Code'] == 1451) {
            echo json_encode(array('respuesta' => 0));
            die();
        } else {
            echo json_encode(array('respuesta' => 1));
        }
    }

    /**
     * @author Nelson Soriano
     * @since  27/03/2019
     * @return Creacion de Proyectos para el cliente
     * @description: Se reconstruyo la pantalla de proyectos para trabajar con anexos
     */

    public function agregar_proyectos($id_cliente = null, $ruta = "")
    {
        satelite_validar();
        if ($_POST) {
            $cliente      = ($this->input->post('id_cliente')) ? $this->input->post('id_cliente') : null;
            $nombre       = ($this->input->post('txtNombre')) ? $this->input->post('txtNombre') : null;
            $codigo       = ($this->input->post('txtCodigo')) ? $this->input->post('txtCodigo') : null;
            $superior     = ($this->input->post('slcNivelSuperior')) ? $this->input->post('slcNivelSuperior') : null;
            $sucursal     = ($this->input->post('slcSucursal')) ? $this->input->post('slcSucursal') : null;
            $estado       = ($this->input->post('slcEstadoProyecto')) ? $this->input->post('slcEstadoProyecto') : null;
            $descrip      = ($this->input->post('txtDescripcion')) ? $this->input->post('txtDescripcion') : null;
            $tipo_accion  = $this->input->post('btnCrear');
            $link         = ($this->input->post('txt_ruta')) ? $this->input->post('txt_ruta') : "";
            $centros      = ($this->input->post('slc_centros')) ? $this->input->post('slc_centros') : null;
            $duracion     = ($this->input->post('txt_duracion')) ? $this->input->post('txt_duracion') : null;
            $fecha_inicio = ($this->input->post('txt_fecha_inicio')) ? date('Y-m-d', strtotime($this->input->post('txt_fecha_inicio'))) : null;
            $moneda       = ($this->input->post('slc_moneda')) ? $this->input->post('slc_moneda') : null;
            $monto        = ($this->input->post('txt_monto_solicitado')) ? $this->input->post('txt_monto_solicitado') : null;

            $array_proyecto              = array(
                'pcl_id_cli'             => $cliente,
                'pcl_id_scl'             => $sucursal,
                'pcl_id_epr'             => $estado,
                'pcl_id_padre'           => $superior,
                'pcl_id_cec'             => $centros,
                'pcl_codigo'             => $codigo,
                'pcl_nombre'             => $nombre,
                'pcl_descripcion'        => $descrip,
                'pcl_duracion_meses'     => $duracion,
                'pcl_fecha_inicio'       => $fecha_inicio,
                'pcl_monto_solicitado'   => $monto,
                'pcl_id_mon'             => $moneda,
                'pcl_estado'             => 1,
                'pcl_usu_creacion'       => $this->tank_auth->get_user_id(),
                'pcl_fecha_creacion'     => date('Y-m-d H:i:s'),
                'pcl_usu_modificacion'   => $this->tank_auth->get_user_id(),
                'pcl_fecha_modificacion' => date('Y-m-d H:i:s')
            );

            $resultado = $this->gsatelite->ingresar('pcl_proyecto_cliente', $array_proyecto);
            if ($resultado > 0) {

                // Agregar los Anexos por cliente
                $rutas = $this->input->post("ruta");
                $carpeta = $this->input->post("nombreCarpeta");
                if (count($rutas) > 0) {
                    $carpeta = $carpeta;
                    for ($i = 0; $i < count($rutas); $i++) {
                        if ($rutas[$i] != "") {
                            $img = $rutas[$i];
                            $titulo = $this->input->post("titulo_doc" . $i);
                            $this->datos_imagen_gral3($img, $resultado, $carpeta, $titulo);
                        }
                    }
                }

                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Proyectos", 'texto_alerta' => "Los registros se ingresaron con éxito.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Proyectos", 'texto_alerta' => "Ocurrió un error al guardar la información.");
            }
            $this->session->set_flashdata($alerta);
            switch ($tipo_accion) {
                case 1:
                    if ($link == "") {
                        redirect('cotizaciones/mantenimientos/agregar_proyectos/' . $cliente);
                    } else {
                        $link = $link . "agregar_proyecto";
                        redirect($link);
                    }
                    break;

                case 2:
                    if ($link == "") {
                        redirect('cotizaciones/mantenimientos/proyectos/' . $cliente);
                    } else {
                        $link = $link . "proyectos";
                        redirect($link);
                    }
                    break;
            }
        }
        // Carga de los controles de la vista
        if ($id_cliente) {
            $data['titulo_personal']     = 'Agregar proyectos';
            $data['niveles_proyectos']   = $this->gsatelite->get_dropdown('pcl_proyecto_cliente', '{pcl_codigo} - {pcl_nombre}', '', array('pcl_estado' => 1, 'pcl_id_cli' => $id_cliente, 'pcl_id_padre' => null), null, null, 'pcl_id', true);
            $data['sucursales']          = $this->gsatelite->get_dropdown('scl_sucursal_cliente', '{scl_nombre}', '', array('scl_estado' => 1, 'scl_id_cli' => $id_cliente), null, '', 'scl_id', true);
            $data['etapas']              = $this->gsatelite->get_dropdown('epr_estado_proyecto', '{epr_nombre}', '', array('epr_estado' => 1), null, '', 'epr_id', true);
            $data['clientes']            = "";
            $data['centros']             = "";
            $data['id_cliente']          = $id_cliente;
            $data['ruta']                = "";
            cargarvista($data, 0, 'cotizaciones/mantenimientos/agregar_proyectos');
        } else {
            $data['titulo_personal']   = 'Agregar proyectos';
            $data['niveles_proyectos'] = $this->gsatelite->get_dropdown('pcl_proyecto_cliente', '{pcl_codigo} - {pcl_nombre}', '', array('pcl_estado' => 1, 'pcl_id_padre' => null), null, null, 'pcl_id', true);
            $data['sucursales']        = $this->gsatelite->get_dropdown('scl_sucursal_cliente', '{scl_nombre}', '', array('scl_estado' => 1), null, '', 'scl_id', true);
            $data['etapas']            = $this->gsatelite->get_dropdown('epr_estado_proyecto', '{epr_nombre}', '', array('epr_estado' => 1), null, '', 'epr_id', true);
            $data['clientes']          = $this->gsatelite->get_dropdown('cli_cliente', '{cli_nombre} {cli_apellido}', '', array('cli_estado' => 1), null, '', 'cli_id', true);
            $data['centros']           = $this->gsatelite->get_dropdown('cec_centro_costo', '{cec_nombre}', '', array('cec_estado' => 1), null, '', 'cec_id', true);
            $moneda                    = $this->gsatelite->get_dropdown('mon_moneda', '{mon_nombre}', '', array('mon_estado' => 1), null, '', 'mon_id', true);
            $data['monedas']           = str_replace('<option value="0">Seleccione</option>', '', $moneda);
            $data['id_cliente']        = "";
            $data['ruta']              = $ruta;
            cargarvista($data, 0, 'cotizaciones/mantenimientos/agregar_proyectos');
        }
    }


    /**
     * @author Nelson Soriano
     * @since  28/03/2019
     * @return Edicion de Proyectos para el cliente
     * @description: Se reconstruyo la pantalla de proyectos para trabajar con anexos
     */

    public function editar_proyecto($proyecto = null, $ruta = "")
    {
        satelite_validar();
        if ($_POST) {

            $cliente      = ($this->input->post('id_cliente')) ? $this->input->post('id_cliente') : null;
            $nombre       = ($this->input->post('txtNombre')) ? $this->input->post('txtNombre') : null;
            $codigo       = ($this->input->post('txtCodigo')) ? $this->input->post('txtCodigo') : null;
            $superior     = ($this->input->post('slcNivelSuperior')) ? $this->input->post('slcNivelSuperior') : null;
            $sucursal     = ($this->input->post('slcSucursal')) ? $this->input->post('slcSucursal') : null;
            $estado       = ($this->input->post('slcEstadoProyecto')) ? $this->input->post('slcEstadoProyecto') : null;
            $descrip      = ($this->input->post('txtDescripcion')) ? $this->input->post('txtDescripcion') : null;
            $tipo_accion  = $this->input->post('btnCrear');
            $proyecto_id  = $this->input->post('proyecto_id');
            $link         = ($this->input->post('txt_ruta')) ? $this->input->post('txt_ruta') : "";
            $centros      = ($this->input->post('slc_centros')) ? $this->input->post('slc_centros') : null;
            $duracion     = ($this->input->post('txt_duracion')) ? $this->input->post('txt_duracion') : null;
            $fecha_inicio = ($this->input->post('txt_fecha_inicio')) ? date('Y-m-d', strtotime($this->input->post('txt_fecha_inicio'))) : null;
            $moneda       = ($this->input->post('slc_moneda')) ? $this->input->post('slc_moneda') : null;
            $monto        = ($this->input->post('txt_monto_solicitado')) ? $this->input->post('txt_monto_solicitado') : null;

            $array_proyecto              = array(
                'pcl_id_scl'             => $sucursal,
                'pcl_id_epr'             => $estado,
                'pcl_id_padre'           => $superior,
                'pcl_id_cec'             => $centros,
                'pcl_codigo'             => $codigo,
                'pcl_nombre'             => $nombre,
                'pcl_descripcion'        => $descrip,
                'pcl_duracion_meses'     => $duracion,
                'pcl_fecha_inicio'       => $fecha_inicio,
                'pcl_monto_solicitado'   => $monto,
                'pcl_id_mon'             => $moneda,
                'pcl_usu_modificacion'   => $this->tank_auth->get_user_id(),
                'pcl_fecha_modificacion' => date('Y-m-d H:i:s')
            );
            $resultado = $this->gsatelite->actualizar_array('pcl_proyecto_cliente', $array_proyecto, array('pcl_id' => $proyecto_id));
            if ($resultado > 0) {
                $Anexo_proyecto  = $this->input->post('Anexo_proyecto');
                $dataAnexos = $this->gsatelite->get_tabla('apl_anexo_proyecto_cliente', array('apl_id_pcl' => $proyecto_id));
                if (!is_array($Anexo_proyecto)) {
                    $Anexo_proyecto = array();
                }
                foreach ($dataAnexos as $data) {
                    if (!in_array($data['apl_id'], $Anexo_proyecto)) {
                        $this->gsatelite->borrado_general('apl_anexo_proyecto_cliente', array('apl_id' => $data['apl_id']));
                        $ruta_nxp = $data['apl_url'];
                        unlink($ruta_nxp);
                    }
                }

                $rutas = $this->input->post("ruta");
                $carpeta = $this->input->post("nombreCarpeta");
                if (count($rutas) > 0) {
                    $carpeta = $carpeta;
                    for ($i = 0; $i < count($rutas); $i++) {
                        if ($rutas[$i] != "") {
                            $img = $rutas[$i];
                            $titulo = $this->input->post("titulo_doc" . $i);
                            $this->datos_imagen_gral3($img, $proyecto_id, $carpeta, $titulo);
                        }
                    }
                }

                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Proyectos", 'texto_alerta' => "Los registros se Actualizaron con éxito.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Proyectos", 'texto_alerta' => "Ocurrió un error al guardar la información.");
            }
            $this->session->set_flashdata($alerta);
            switch ($tipo_accion) {
                case 1:
                    if ($link == "") {
                        redirect('cotizaciones/mantenimientos/editar_proyecto/' . $proyecto_id);
                    } else {
                        $link = $link . "editar_proyecto/" . $proyecto_id;
                        redirect($link);
                    }
                    break;
                case 2:
                    if ($link == "") {
                        redirect('cotizaciones/mantenimientos/proyectos/' . $cliente);
                    } else {
                        $link = $link . "proyectos";
                        redirect($link);
                    }
                    break;
            }
        }
        if ($proyecto) {
            $data_proyecto           = $this->gsatelite->get_tabla('pcl_proyecto_cliente', array('pcl_estado' => 1, 'pcl_id' => $proyecto));
            $nivel                   = $data_proyecto[0]['pcl_id_padre'];
            $sucursal                = $data_proyecto[0]['pcl_id_scl'];
            $etapa                   = $data_proyecto[0]['pcl_id_epr'];
            $cliente                 = $data_proyecto[0]['pcl_id_cli'];
            $centro                  = $data_proyecto[0]['pcl_id_cec'];
            $data['anexos']          = $this->gsatelite->get_tabla('apl_anexo_proyecto_cliente', array('apl_id_pcl' => $proyecto));
            $data['id_cliente']      = $cliente;
            $data['nivel_sup']       = $this->gsatelite->get_dropdown('pcl_proyecto_cliente', '{pcl_codigo} - {pcl_nombre}', '', array('pcl_estado' => 1, 'pcl_id_cli' => $cliente), $nivel, null, 'pcl_id', true);
            $data['sucursales']      = $this->gsatelite->get_dropdown('scl_sucursal_cliente', '{scl_nombre}', '', array('scl_estado' => 1, 'scl_id_cli' => $cliente), $sucursal, '', 'scl_id', true);
            $data['etapa_pro']       = $this->gsatelite->get_dropdown('epr_estado_proyecto', '{epr_nombre}', '', array('epr_estado' => 1), $etapa, '', 'epr_id', true);
            $data['clientes']        = $this->gsatelite->get_dropdown('cli_cliente', '{cli_nombre} {cli_apellido}', '', array('cli_estado' => 1), $cliente, '', 'cli_id', true);
            $data['centros']         = $this->gsatelite->get_dropdown('cec_centro_costo', '{cec_nombre}', '', array('cec_estado' => 1), $centro, '', 'cec_id', true);
            $data['nombre']          = $data_proyecto[0]['pcl_nombre'];
            $data['codigo']          = $data_proyecto[0]['pcl_codigo'];
            $data['descripcion_pro'] = $data_proyecto[0]['pcl_descripcion'];

            $data['duracion']        = $data_proyecto[0]['pcl_duracion_meses'];
            $data['inicio']          = ($data_proyecto[0]['pcl_fecha_inicio']) ? date('Y-m-d', strtotime($data_proyecto[0]['pcl_fecha_inicio'])) : "";
            $data['monto']           = $data_proyecto[0]['pcl_monto_solicitado'];
            $pcl_id_mon              = $data_proyecto[0]['pcl_id_mon'];
            $moneda                  = $this->gsatelite->get_dropdown('mon_moneda', '{mon_nombre}', '', array('mon_estado' => 1), $pcl_id_mon, '', 'mon_id', true);
            $data['monedas']         = str_replace('<option value="0">Seleccione</option>', '', $moneda);

            $data['titulo_personal'] = 'Editar proyecto';
            $data['proyecto']        = $proyecto;
            $data['ruta']            = $ruta;
            cargarvista($data, 0, 'cotizaciones/mantenimientos/editar_proyectos');
        }
    }

    public function ver_proyectos($proyecto = null)
    {
        if ($proyecto) {
            $data_proyecto         = $this->gsatelite->get_tabla('pcl_proyecto_cliente', array('pcl_estado' => 1, 'pcl_id' => $proyecto));
            $nivel                 = $data_proyecto[0]['pcl_id_padre'];
            $sucursal              = $data_proyecto[0]['pcl_id_scl'];
            $etapa                 = $data_proyecto[0]['pcl_id_epr'];
            $cliente               = $data_proyecto[0]['pcl_id_cli'];
            $data['anexos']        = $this->gsatelite->get_tabla('apl_anexo_proyecto_cliente', array('apl_id_pcl' => $proyecto));
            $data['id_cliente']    = $cliente;
            $data['nivel_sup']     = $this->gsatelite->get_dropdown('pcl_proyecto_cliente', '{pcl_codigo} - {pcl_nombre}', '', array('pcl_estado' => 1, 'pcl_id_cli' => $cliente), $nivel, null, 'pcl_id', true);
            $data['sucursales']    = $this->gsatelite->get_dropdown('scl_sucursal_cliente', '{scl_nombre}', '', array('scl_estado' => 1, 'scl_id_cli' => $cliente), $sucursal, '', 'scl_id', true);
            $data['etapa_pro']     = $this->gsatelite->get_dropdown('epr_estado_proyecto', '{epr_nombre}', '', array('epr_estado' => 1), $etapa, '', 'epr_id', true);
            $data['nombre']        = $data_proyecto[0]['pcl_nombre'];
            $data['codigo']        = $data_proyecto[0]['pcl_codigo'];
            $data['descripcion_pro']    = $data_proyecto[0]['pcl_descripcion'];
            $data['titulo_personal']    = 'Ver proyecto';
            $data['proyecto']           = $proyecto;

            cargarvista($data, 0, 'cotizaciones/mantenimientos/ver_proyectos');
        }
    }

    /*******************************************************************/
    /**
     * @autor Elman Ortiz
     * @since 11/04/2019
     * @param Metodo para el mantenimiento de tipo_comision_recuperacion
     */
    function tipo_comision_recuperacion()
    {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();
        $crud = new grocery_CRUD;
        $alias = array(
            'crp_id_tic'        => 'Nombre',
            'crp_id_tia'        => 'Categoria',
            'crp_porcentaje'    => 'Porcentaje',
            'crp_valor'         => 'Valor',
            'crp_desde'         => 'Desde',
            'crp_hasta'         => 'Hasta',
            'crp_descripcion'   => 'Descripción',
            'crp_estado'        => 'Estado'
        );
        $colums = array(
            'crp_id_tic',
            'crp_id_tia',
            'crp_porcentaje',
            'crp_valor',
            'crp_desde',
            'crp_hasta',
            'crp_estado'
        );
        $edit = array(
            'crp_id_tic',
            'crp_id_tia',
            'crp_porcentaje',
            'crp_valor',
            'crp_desde',
            'crp_hasta',
            'crp_descripcion',
            'crp_estado',
            'crp_usu_modificacion',
            'crp_fecha_modificacion'
        );
        $add = array(
            'crp_id_tic',
            'crp_id_tia',
            'crp_porcentaje',
            'crp_valor',
            'crp_desde',
            'crp_hasta',
            'crp_descripcion',
            'crp_estado',
            'crp_usu_creacion',
            'crp_fecha_creacion',
            'crp_usu_modificacion',
            'crp_fecha_modificacion'
        );

        $required = array(
            'crp_id_tic',
            'crp_id_tia',
            'crp_estado',
            'crp_usu_creacion',
            'crp_fecha_creacion',
            'crp_usu_modificacion',
            'crp_fecha_modificacion'
        );

        $crud->set_table('crp_comision_recuperacion')
            ->set_subject('Comision recuperacion')
            ->display_as($alias)
            ->columns($colums)
            ->add_fields($add)
            ->edit_fields($edit)
            ->required_fields($required)
            ->field_type('crp_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
            ->field_type('crp_fecha_modificacion', 'hidden', date('Y-m-d h:i:s'))
            ->set_relation('crp_id_tic', 'tic_tipo_comision', '{tic_nombre} - ({tic_tasa})', array('tic_estado' => 1))
            ->set_relation('crp_id_tia', 'tia_tipo_articulo', '{tia_nombre}', array('tia_estado' => 1))
            ->set_rules('crp_id_tic', 'Tipo comision', 'trim|required')
            ->set_rules('crp_id_tia', 'Tipo articulo', 'trim|required')
            //->unset_delete()
        ;
        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('crp_estado', 'hidden', 1);
            $crud->field_type('crp_fecha_creacion', 'hidden', date('Y-m-d h:i:s'));
            $crud->field_type('crp_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
        } else {
            $crud->field_type('crp_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

        // Validaciones
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }
        if (!$permisos['permite_editar']) {
            $crud->unset_edit();
        }
        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }
        if (!$permisos['permite_ver']) {
            $crud->unset_read();
        }

        $output = $crud->render();
        $data['titulo_personal'] = "Tipo comisión por recuperación";
        cargarvista($data, $output);
    }

    /*******************************************************************/
    /**
     * @autor Elman Ortiz
     * @since 11/04/2019
     * @param Metodo para el mantenimiento de cvt_comision_venta
     */
    function tipo_comision_venta()
    {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();
        $crud = new grocery_CRUD;
        $alias = array(
            'cvt_id_tic'        => 'Nombre',
            'cvt_id_tia'        => 'Categoria',
            'cvt_porcentaje'    => 'Porcentaje',
            'cvt_valor'         => 'Valor',
            'cvt_desde'         => 'Desde',
            'cvt_hasta'         => 'Hasta',
            'cvt_descripcion'   => 'Descripción',
            'cvt_estado'        => 'Estado'
        );

        $colums = array(
            'cvt_id_tic',
            'cvt_id_tia',
            'cvt_porcentaje',
            'cvt_valor',
            'cvt_desde',
            'cvt_hasta',
            'cvt_estado'
        );
        $edit = array(
            'cvt_id_tic',
            'cvt_id_tia',
            'cvt_porcentaje',
            'cvt_valor',
            'cvt_desde',
            'cvt_hasta',
            'cvt_descripcion',
            'cvt_estado',
            'cvt_usu_modificacion',
            'cvt_fecha_modificacion'
        );

        $add = array(
            'cvt_id_tic',
            'cvt_id_tia',
            'cvt_porcentaje',
            'cvt_valor',
            'cvt_desde',
            'cvt_hasta',
            'cvt_descripcion',
            'cvt_usu_creacion',
            'cvt_fecha_creacion',
            'cvt_usu_modificacion',
            'cvt_fecha_modificacion',
            'cvt_estado'
        );

        $required = array(
            'cvt_id_tic',
            'cvt_id_tia',
            'cvt_estado',
            'cvt_usu_creacion',
            'cvt_fecha_creacion',
            'cvt_usu_modificacion',
            'cvt_fecha_modificacion'
        );

        $crud->set_table('cvt_comision_venta')
            ->set_subject('Comision venta')
            ->display_as($alias)
            ->columns($colums)
            ->add_fields($add)
            ->edit_fields($edit)
            ->required_fields($required)
            ->field_type('cvt_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
            ->field_type('cvt_fecha_modificacion', 'hidden', date('Y-m-d h:i:s'))
            ->set_relation('cvt_id_tic', 'tic_tipo_comision', '{tic_nombre} - {tic_tasa}%', array('tic_estado' => 1))
            ->set_relation('cvt_id_tia', 'tia_tipo_articulo', '{tia_nombre}', array('tia_estado' => 1))
            ->set_rules('cvt_id_tic', 'Tipo comision', 'trim|required')
            ->set_rules('cvt_id_tia', 'Tipo articulo', 'trim|required')
            //->unset_delete()
        ;
        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('cvt_estado', 'hidden', 1);
            $crud->field_type('cvt_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('cvt_fecha_creacion', 'hidden', date('Y-m-d h:i:s'));
        } else {
            $crud->field_type('cvt_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

        // Validaciones
        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }
        if (!$permisos['permite_editar']) {
            $crud->unset_edit();
        }
        if (!$permisos['permite_eliminar']) {
            $crud->unset_delete();
        }
        if (!$permisos['permite_ver']) {
            $crud->unset_read();
        }

        $output = $crud->render();
        $data['titulo_personal'] = "Tipo comisión por venta";
        cargarvista($data, $output);
    }

    public function consulta_x()
    {
        $documento = $this->input->post('documento');
        $tipodoc = ($this->input->post('tipo') > 0) ? $this->input->post('tipo') : null;
        if ($documento) {
            $where = array('dcc_valor' => $documento, 'dcc_estado' => 1);
            if ($tipodoc) {
                $where['dcc_id_tde'] = $tipodoc;
            }
            $row = $this->gsatelite->get_tabla('dcc_documento_cliente', $where);
            if (count($row) > 0) {
                echo  json_encode(array('existe' => 1)); die();
            } else {
                echo  json_encode(array('existe' => 2)); die();
            }
        }
    }

    public function detalle_calculo_mano_obra($mob_id)
    {
        satelite_validar();
        $this->load->library('../controllers/sistema/mantenimientos_compartidos');
        $permisos = $this->gsatelite->get_permisos_opcion('cotizaciones/mantenimientos/mano_obra');
        $this->mantenimientos_compartidos->detalle_calculo_mano_obra($mob_id);
    }
}

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */
