<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

/**
 * Cotizaciones
 *
 * @package Satelite Base
 * @author Rene Castaneda
 * @copyright 2014
 * @access public
 */
class Cotizaciones extends CI_Controller
{

    function __construct()
    {
        parent::__construct();
        $this->load->library('grocery_CRUD');
        $this->load->model('cotizaciones_model', 'cotModel');
        $this->load->model('desarrollo_model');
        $this->load->model('inventario_model');
        $this->load->library('form_validation');
        $this->load->model('facturacion_model');
        $this->load->model('proyecto_model');
        $this->load->library('EnLetras');
        // $this->load->library('Excelphp');
    }

    public function tabla_llamadas_backup()
    {
        $crud = new grocery_CRUD();

        $crud->set_table('tbl_tabla_llamadas');
        $crud->set_subject('Llamada');
        $column = array('tbl_fecha', 'tbl_id_cli', 'tbl_recado');
        $add_fields = array('tbl_fecha', 'tbl_id_cli', 'tbl_id_con', 'tbl_nuevo', 'medios', 'tbl_usu_recibe', 'tbl_recado', 'tbl_fecha_mod', 'tbl_usu_mod');
        $alias = array(
            'tbl_fecha' => 'Fecha',
            'tbl_id_cli' => 'Cliente',
            'tbl_id_con' => 'Contacto',
            'tbl_nuevo' => '¿Cliente nuevo?',
            'tbl_id_tmc' => 'Medio de contacto',
            'tbl_recado' => 'Recado',
        );
        $required = array('tbl_fecha', 'tbl_id_cli', 'tbl_id_con', 'tbl_recado');
        $crud->fields($add_fields);
        $crud->columns($column);
        $crud->display_as($alias);
        $crud->required_fields($required);
        $crud->set_relation_n_n('medios', 'txt_tabla_llamadaxtipo_medio', 'tmc_tipo_medio', 'txt_id_tbl', 'txt_id_tmc', 'tmc_nombre')
            ->set_relation('tbl_id_cli', 'cli_cliente', 'cli_nombre')
            ->set_relation('tbl_id_con', 'con_contacto', 'con_nombre')
            ->field_type('tbl_usu_mod', 'hidden', $this->tank_auth->get_user_id())
            ->field_type('tbl_usu_recibe', 'hidden', $this->tank_auth->get_user_id())
            ->field_type('tbl_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
            ->field_type('tbl_nuevo', 'dropdown', array('0' => 'No', '1' => 'Si'));
        $output = $crud->render();

        $data['titulo_personal'] = "Tabla de llamadas";

        $this->_cargarvista($data, $output);
    }

    public function tabla_llamadas_bkC()
    {

        $crud = new grocery_CRUD();

        $crud->set_table('tbl_tabla_llamadas');
        $crud->set_subject('Consulta');

        $column = array(
            'tbl_fecha',
            'tbl_id_mat',
            'tbl_id_cli',
            'tbl_id_ven',
            'tbl_recado'
        );

        $add_fields = array(
            'tbl_id_cli',
            'tbl_nuevo',
            'tbl_personeria',
            'tbl_cliente_nombre',
            'tbl_cliente_apellido',
            'tbl_fecha',
            'tbl_id_mat',
            'tbl_telefono',
            'tbl_correo',
            'tbl_direccion',
            'tbl_id_sec',
            'tbl_id_ven',
            'tbl_contacto',
            'medios',
            'tbl_usu_recibe',
            'tbl_recado',
            'tbl_fecha_mod',
            'tbl_usu_mod',
            'tbl_fecha_crea',
            'tbl_usu_crea'
        );

        $edit_fields = array(
            'tbl_id_cli',
            'tbl_nuevo',
            'tbl_personeria',
            'tbl_cliente_nombre',
            'tbl_cliente_apellido',
            'tbl_telefono',
            'tbl_correo',
            'tbl_direccion',
            'tbl_id_sec',
            'tbl_id_ven',
            'tbl_contacto',
            'medios',
            'tbl_usu_recibe',
            'tbl_recado',
            'tbl_fecha_mod',
            'tbl_usu_mod'
        );

        $alias = array(
            'tbl_id_cli' => 'Cliente',
            'tbl_nuevo' => '¿Cliente nuevo?',
            'tbl_cliente_nombre' => 'Cliente',
            'tbl_cliente_apellido' => 'Apellido',
            'tbl_fecha' => 'Fecha',
            'tbl_id_mat' => 'Motivo',
            'tbl_telefono' => 'Teléfono',
            'tbl_personeria' => 'Personería',
            'tbl_correo' => 'Correo',
            'tbl_direccion' => 'Dirección',
            'tbl_id_sec' => 'Sector Cliente',
            'tbl_id_ven' => 'Ejecutivo Asignado',
            'tbl_contacto' => 'Contacto',
            'medios' => 'Medio de contacto',
            'tbl_recado' => 'Mensaje',
        );

        $required = array(
            'tbl_nuevo',
            'tbl_cliente_nombre',
            'tbl_contacto',
            'tbl_recado'
        );
        //'tbl_cliente_apellido',
        //'tbl_fecha',
        //$this->session->keep_flashdata('id_registro');
        $crud->add_fields($add_fields);
        $crud->edit_fields($edit_fields);
        $crud->columns($column);
        $crud->order_by('tbl_fecha', 'desc');
        $crud->display_as($alias);
        $crud->required_fields($required);

        $crud->set_relation('tbl_id_sec', 'sec_sector_cliente', 'sec_nombre', array('sec_estado' => 1));
        $crud->set_relation('tbl_id_mat', 'mat_motivo_atencion', 'mat_nombre', array('mat_estado' => 1));
        $crud->set_relation('tbl_id_cli', 'cli_cliente', '{cli_nombre} {cli_apellido}', array('cli_estado' => 1));
        $crud->set_relation('tbl_id_ven', 'ven_vendedor', '{ven_nombre} {ven_apellidos}', array('ven_estado' => 1));
        $crud->set_relation_n_n('medios', 'txt_tabla_llamadaxtipo_medio', 'tmc_tipo_medio', 'txt_id_tbl', 'txt_id_tmc', 'tmc_nombre', NULL, array('tmc_estado' => 1))
            ->field_type('tbl_usu_mod', 'hidden', $this->tank_auth->get_user_id())
            ->set_rules('tbl_correo', 'Correo', 'trim|valid_email')
            ->field_type('tbl_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
            ->field_type('tbl_usu_recibe', 'hidden', $this->tank_auth->get_user_id())
            ->field_type('tbl_fecha', 'hidden', date('Y-m-d H:i:s'))
            ->field_type('tbl_usu_crea', 'hidden', $this->tank_auth->get_user_id())
            ->field_type('tbl_fecha_crea', 'hidden', date('Y-m-d H:i:s'))
            ->field_type('tbl_personeria', 'dropdown', array('1' => 'Natural', '2' => 'Jurídica'))
            ->field_type('tbl_nuevo', 'dropdown', array('1' => 'No', '2' => 'Sí'));
        $crud->order_by('tbl_fecha', 'desc');

        $crud->callback_after_insert(array($this, 'redirect_llamada'));

        $crud->callback_column('tbl_fecha', array($this, '_cambiar_formato'));
        //$crud->callback_column('tbl_fecha',array($this,'_date'));
        // Arreglar
        // $crud->set_lang_string('insert_success_message',
        //        '<script type="text/javascript">
        //        window.location = "'.site_url('cotizaciones/cotizaciones/tabla_llamadas/edit/'.$this->session->userdata('id_registro_llamada')).'";
        //        </script>');

        $crud->order_by('tbl_fecha', 'DESC');

        $crud->add_action('Ver', 'icon16 icomoon-icon-search-5', 'cotizaciones/cotizaciones/ver_control_sac', '');
        $crud->unset_edit();
        $crud->add_action('Editar', '', 'cotizaciones/cotizaciones/editar_control_sac', 'icomoon-icon-pencil-5');

        $output = $crud->render();

        $data['primary_key'] = '';
        $url = explode('/', uri_string());
        $data['texto_boton'] = "Consultar Cliente";
        $data['cliente'] = '';
        if (end($url) == 'add') {
            redirect('cotizaciones/cotizaciones/agregar_control_sac');
        } /* elseif (prev($url) == 'edit') {
          $data['primary_key'] = end($url);

          redirect('cotizaciones/cotizaciones/editar_control_sac/'.$data['primary_key']);

          //$data['personeria']= $this->gsatelite->get_campo('tbl_tabla_llamadas', 'tbl_personeria',array('tbl_id'=>$data['primary_key']));
          $data['cliente'] = $this->gsatelite->get_campo('tbl_tabla_llamadas', 'tbl_id_cli', array('tbl_id' => $data['primary_key']));
          if (!isset($data['cliente'])) {
          $data['texto_boton'] = "Agregar Cliente";
          }
          } */

        $data['titulo_personal'] = "Control de servicio al cliente";

        $this->_cargarvista($data, $output);
    }

    public function _cambiar_formato($value, $row)
    {
        $acceso_formateado = null;

        if (!is_null($value)) {
            $fecha = date('d-M-Y H:i:s', strtotime($value));
            return $fecha;
        }
    }

    function _date($value, $row)
    {
        return "<span style='visibility:hidden;display:none;'>" . date('Y-m-d H:i:s', strtotime($value)) . "</span>" . " " . date('d-m-Y H:i:s', strtotime($value));
    }

    function redirect_llamada($post_array, $primary_key)
    {
        $this->session->set_flashdata('id_registro_llamada', $primary_key);
    }

    function obtener_cliente()
    {
        satelite_validar();
        $id_cli = $this->input->post('cli_id');
        $reg_cliente = (array) $this->gsatelite->get_registro('cli_cliente', array('cli_id' => $id_cli));
        echo json_encode($reg_cliente);
    }

    public function obtener_contacto()
    {
        satelite_validar();
        $cod_cli = $this->input->post('cli_id');
        $contactos = $this->cotModel->contacto($cod_cli);

        $var = '';
        foreach ($contactos as $key) {
            if ($key['con_id'] != '') {
                $var .= "<option value='" . $key['con_nombre'] . "' >" . $key['con_nombre'] . " " . $key['con_apellidos'] . "</option>";
            }
        }
        $arreglo = array(
            "opc" => $var,
        );

        echo json_encode($arreglo);
    }

    public function verificar_id_cliente()
    {
        satelite_validar();
        $id_tbl = $this->input->post('tbl_id');
        $clienteId = $this->gsatelite->get_campo('tbl_tabla_llamadas', 'tbl_id_cli', array('tbl_id' => $id_tbl));
        echo $clienteId;
    }

    public function obtener_medio_contacto()
    {
        satelite_validar();
        $cliente = $this->input->post('cli_id');
        $medio_contact = $this->cotModel->medio_contacto(array('cxm_id_cli' => $cliente));
        $var = '';
        $no = array(0);
        foreach ($medio_contact as $key) {
            if ($key['tmc_id'] != '') {
                $no[] = $key['tmc_id'];
                $var .= "<option value='" . $key['tmc_id'] . "' selected >" . $key['tmc_nombre'] . "</option>";
            }
        }

        $noo = "tmc_id not in (" . implode(',', $no) . ")";
        $medio_contact = $this->cotModel->medio_contacto($noo);
        foreach ($medio_contact as $key) {
            if ($key['tmc_id'] != '') {
                $var .= "<option value='" . $key['tmc_id'] . "'>" . $key['tmc_nombre'] . "</option>";
            }
        }
        $arreglo = array(
            "drop" => $var,
        );
        echo json_encode($arreglo);
    }

    public function cargar_condiciones()
    {
        // Obtener las Condiciones para el Cliente
        $cliente = $this->input->post("id_cliente");
        $con_cliente = $this->gsatelite->get_tabla('cxl_condicionxcliente', array('cxl_id_cli' => $cliente, 'cxl_estado' => 1));
        $condiciones = $this->gsatelite->get_tabla('cod_condicion', array('cod_estado' => 1));

        $var = '';

        foreach ($con_cliente as $key => $value) {
            foreach ($condiciones as $key2 => $value2) {
                if ($value['cxl_id_cod'] == $value2['cod_id']) {
                    $var .= "<option value='" . $value2['cod_id'] . "' >" . $value2['cod_nombre'] . "</option>";
                }
            }
        }

        $arreglo = array(
            "drop" => $var,
        );

        echo json_encode($arreglo);
    }


    public function _callback_columns($value, $row)
    {
        $ndias_parametro = $this->gsatelite->get_parametro('SYS_COT_DIAS_SEGUIMIENTO');
        $getIdEst = $this->gsatelite->get_tabla('cot_cotizacion', array('cot_id' => $row->cot_id));
        $getColor = $this->gsatelite->get_tabla('est_estado_cotizacion', array('est_id' => $row->cot_id_est));
        $getColor = $getColor[0]['est_color_indicador'] != "" ? $getColor[0]['est_color_indicador'] : "";
        return $value;
    }

    /**
     * @author René Castaneda
     * @since 21/05/2014
     * @description : Es un crud que mostrará el listado de cotizaciones haciendo un filtro según sea el usuario (supervisor o vendedor), si es supervisor mostrará 
     * todas las cotizaciones de los vendedores asignados y usará ajax para cargar en forma asincronica el select cliente (dependiendo de el vendedor) y el multiselect 
     * contactos (dependiendo el cliente) si es vendedor unicamente mostrará las cotizaciones pertenecientes a el y usará ajax para cargar en forma asincronica el 
     * multiselect contactos (dependiendo de el cliente), se agrego una columna dias para mostrar cuantos dias han pasado después de la ultima fecha de contacto
     * @modify: Mario Marquez
     * @since: 12/06/2017
     * @modify: Raul Escalante
     * @since: 01/06/2019
     */
    function index($stado = null, $stateCot = null, $fecha_inicio = null, $fecha_fin = null, $vendedor = null, $cliente = null)
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($stado > 0) {
                $this->actualizar_cot_pendientes();
            }
            try {
                $autorizacion_estados_cot = (trim($this->gsatelite->get_parametro('SYS_AUTORIZA_ESTADO_COTIZACION_VENTA')) == 1) ? 1 : 0;
                $datos['autorizacion_estados_cot'] = $autorizacion_estados_cot;
                //VERIFICAR SI YA EXISTEN LOS NUEVOS CAMPOS, SINO SE SEGUIRAN USANDO LOS VALORES DEL PARAMETRO
                $hay_campo = $this->db->query("SHOW COLUMNS FROM est_estado_cotizacion WHERE Field = 'est_vigente'")->result_array();
                if (count($hay_campo) > 0) {
                    $vigente = $this->gsatelite->get_tabla('est_estado_cotizacion', array('est_estado' => 1, 'est_vigente' => 1));
                    $ganada  = $this->gsatelite->get_tabla('est_estado_cotizacion', array('est_estado' => 1, 'est_ganada' => 1));
                    $perdida = $this->gsatelite->get_tabla('est_estado_cotizacion', array('est_estado' => 1, 'est_perdida' => 1));
                    if (!(count($vigente) > 0 || count($ganada) > 0 || count($perdida) > 0)) {
                        $this->gsatelite->show_dialog('Verificar el mantenimiento de Estados de la Cotización', 'cotizaciones/index/index/1', 'error');
                    }
                    $estados_cot['VIGENTE'] = (count($vigente) > 0) ? implode(',', array_column($vigente, 'est_id')) : 0;
                    $estados_cot['GANADA'] = (count($ganada) > 0) ? implode(',', array_column($ganada, 'est_id')) : 0;
                    $estados_cot['PERDIDA'] = (count($perdida) > 0) ? implode(',', array_column($perdida, 'est_id')) : 0;
                } else {
                    $estados_cot =  trim($this->gsatelite->get_parametro('SYS_ESTADO_COTIZACION'));
                    $estados_cot = ($estados_cot != '' && is_object(json_decode($estados_cot))) ? (array) json_decode($estados_cot) : null;
                    if (!$estados_cot) {
                        $this->gsatelite->show_dialog('Verificar la configuración de estados de la cotización', 'cotizaciones/index/index/1', 'error');
                    }
                }
                $datos['estados_cot_auto'] = $estados_cot;
                // Arreglo para cotizaciones
                $display_as = array(
                    'facturado'         => 'Facturado',
                    'cot_codigo'        => 'Código',
                    'cot_id_cli'        => 'Cliente',
                    'cot_concepto'      => 'Concepto',
                    'cot_total'         => 'Total',
                    'cot_subtotal'      => 'V. Neto',
                    'fecha_presenta'    => 'Fecha de presentación ',
                    'dias'              => 'Días',
                    'cot_id_est'        => 'Estado Cotización',
                    'segui'             => 'Seguimiento',
                    'seguidays'         => 'Días último seguimiento'
                );
                $columns = array(
                    'facturado',
                    'cot_codigo',
                    'cot_id_cli',
                    'cot_concepto',
                    'cot_subtotal',
                    'cot_total',
                    'fecha_presenta',
                    'dias',
                    'cot_id_est',
                    'segui',
                    'seguidays'
                );
                //preguntar si es supervisor "o vendedor
                $condicion1 = array('sup_id_usu' => $this->tank_auth->get_user_id(), 'sup_estado' => 1);
                $esSup = $this->cotModel->Existe_Registro("sup_supervisor", $condicion1);
                $condicion2 = array('ven_id_usu' => $this->tank_auth->get_user_id(), 'ven_estado' => 1);
                $esVen = $this->cotModel->Existe_Registro("ven_vendedor", $condicion2);
                $crud = new grocery_CRUD();
                $crud->set_table('cot_cotizacion')
                    ->set_subject('')
                    ->columns($columns)
                    ->set_relation('cot_id_cli', 'cli_cliente', "[CASE WHEN cli_personeria = 1 THEN CONCAT_WS(' ', cli_codigo, '-', cli_nombre, cli_apellido) ELSE CONCAT_WS(' ', cli_codigo, '-', cli_apellido) END]", array('cli_estado' => 1))
                    ->set_relation('cot_id_est', 'est_estado_cotizacion', 'est_nombre', array('est_estado' => 1))
                    ->set_relation('cot_id_tic', 'tic_tipo_comision', '{tic_nombre} {tic_tasa} % ', array('tic_estado' => 1))
                    ->set_relation('cot_id_etp', 'etp_etapa', 'etp_nombre', array('etp_estado' => 1))
                    ->set_relation('cot_id_pcl', 'pcl_proyecto_cliente', 'pcl_codigo', array('pcl_estado' => 1))
                    ->set_relation_n_n('contactos', 'cxt_contactoxcotizacion', 'con_contacto', 'cxt_id_cot', 'cxt_id_con', '{con_nombre} {con_apellidos} - {con_cargo}', NULL, array('con_estado' => 1))
                    ->display_as($display_as)
                    ->add_action('Editar', '', 'cotizaciones/cotizaciones/editar_cotizacion', 'icomoon-icon-pencil-5 eliminar_accion_editar')
                    ->add_action('Duplicar', '', '', 'icomoon-icon-stack duplicar')
                    ->add_action('Seguimiento', '', 'cotizaciones/cotizaciones/seguimiento_cotizacion', 'icomoon-icon-stack')
                    ->add_action('Anexos', '', 'cotizaciones/cotizaciones/anexos_cotizacion', 'icomoon-icon-stack') //cotizaciones/cotizaciones/seguimiento_cotizacion
                    ->add_action('Imprimir', '', 'cotizaciones/cotizaciones/imprimir_cotizacion2', 'icomoon-icon-printer imprimir_cot')
                    ->add_action('Imprimir completa', '', 'cotizaciones/cotizaciones/imprimir_cotizacion_larga', 'icomoon-icon-printer imprimir_cot')

                    ->add_action('Envios parciales', '', 'cotizaciones/cotizaciones/envios_parciales', 'icomoon-icon-rating-3');

                // FILTROS
                $state = ($stado != null) ? $stado : null;
                $fecha_pasada = ($fecha_inicio != null) ? formatear_fecha("Y-m-d", $fecha_inicio) : null;
                $fecha_actual = ($fecha_fin != null) ? formatear_fecha("Y-m-d", $fecha_fin) : null;
                $slcVendedor = ($vendedor != null) ? $vendedor : null;
                $chkCot = ($stateCot != null) ? $stateCot : null;
                $slcCliente = ($cliente != null) ? $cliente : null;
                if ($this->input->post('estado') > 0) {
                    $state = $this->input->post('estado');
                }
                if ($this->input->post('txtFechaPasada') != "") {
                    $fecha_pasada = formatear_fecha('Y-m-d', $this->input->post('txtFechaPasada'));
                }
                if ($this->input->post('txtFechaActual') != "") {
                    $fecha_actual = formatear_fecha('Y-m-d', $this->input->post('txtFechaActual'));
                }
                if ($this->input->post('slcVendedor') != "") {
                    $slcVendedor = $this->input->post('slcVendedor');
                }
                if ($this->input->post('chkCot') != "") {
                    $chkCot = $this->input->post('chkCot');
                }
                if ($this->input->post('slcCliente') != "") {
                    $slcCliente = $this->input->post('slcCliente');
                }
                $fecha_pasada = ($fecha_pasada) ? $fecha_pasada : date("Y-m-01");
                $fecha_actual = ($fecha_actual) ? $fecha_actual : date("Y-m-t");
                $chkCot = ($chkCot != null) ? $chkCot : 1;

                $crud->where("DATE(cot_fecha_pres) >= '$fecha_pasada'");
                $crud->where("DATE(cot_fecha_pres) <= '$fecha_actual'");
                $crud->where('cot_estado', $chkCot);
                if ($state > 0) {
                    $crud->where('cot_id_est', $state);
                }
                if ($slcVendedor > 0) {
                    $crud->where('cot_id_ven', $slcVendedor);
                }
                if ($slcCliente > 0) {
                    $crud->where('cot_id_cli', $slcCliente);
                }
                $crud->callback_column('dias', function ($value, $row) {
                    $CI = &get_instance();
                    $total_cot = $row->cot_total;
                    $getEstado = $CI->gsatelite->get_tabla('est_estado_cotizacion', array('est_id' => $row->cot_id_est));
                    $getColor = $getEstado[0]['est_color_indicador'] != "" ? $getEstado[0]['est_color_indicador'] : "";
                    //preguntar por el estado de la cotizacion y saber si se le debe dar o no seguimiento
                    $seguir = $getEstado[0]['est_seguimiento'];
                    $perdida = $CI->gsatelite->get_campo('per_perdido', 'per_id_cot', array('per_id_cot' => $row->cot_id));
                    $esta_coti = " id_estado_cot='$row->cot_id_est' ";
                    $estado_actual = $row->cot_id_est;
                    if (count($this->db->query("SHOW COLUMNS FROM est_estado_cotizacion WHERE Field = 'est_ganada'")->result_array()) > 0) {
                        $ganada = $this->gsatelite->get_tabla('est_estado_cotizacion', array('est_estado' => 1, 'est_ganada' => 1));
                        $ganada_est = (count($ganada) > 0) ? $ganada[0]['est_id'] : 0;
                    } else {
                        $ganada_est = $this->gsatelite->get_parametro('SYS_ESTADO_COTIZACION', null, null, array('GANADA'));
                        $ganada_est = ($ganada_est > 0) ? $ganada_est : 0;
                    }
                    if ($seguir > 0) {
                        $date1 = date('Y-m-d H:i:s');
                        $date2 = formatear_fecha('Y-m-d H:i:s', $row->cot_fecha_pres); //ultima fecha de contacto /*Se cambia por fecha de presentacion 6/7/20 SAT_6214*/
                        $fecha_1 = new DateTime($date1);
                        $fecha_2 = new DateTime($date2);
                        $diferencia = date_diff($fecha_1, $fecha_2);
                        $ndias = $diferencia->days;
                        if ($ndias < 1) {
                            return "<span style=\"display:none;\">00000</span><label est_ganadax='" . $ganada_est . "' est_actual='" . $estado_actual . "' total_cot='" . $total_cot . "' class='color_tr' $esta_coti color_estado='" . $getColor . "' >0</label>";
                        } else {
                            if ($perdida > 0) {
                                return '<span style="display:none;">' . str_pad($value, 5, 0, STR_PAD_LEFT) . "</span><label est_ganadax='" . $ganada_est . "' est_actual='" . $estado_actual . "' total_cot='" . $total_cot . "' class='color_tr' $esta_coti  color_estado='" . $getColor . "'>$value</label>";
                            } else {
                                return '<span style="display:none;">' . str_pad($ndias, 5, 0, STR_PAD_LEFT) . "</span><label est_ganadax='" . $ganada_est . "' est_actual='" . $estado_actual . "' total_cot='" . $total_cot . "' class='color_tr' $esta_coti  color_estado='" . $getColor . "'>$ndias</label>";
                            }
                        }
                    } else {
                        //si el estado en que se encuentra no es de seguimiento retornar cero
                        return "<span style=\"display:none;\">00000</span><label est_ganadax='" . $ganada_est . "' est_actual='" . $estado_actual . "' total_cot='" . $total_cot . "' class='color_tr' $esta_coti color_estado='" . $getColor . "'>0</label>";
                    }
                });
                $crud->callback_column('seguidays', function ($value, $row) {
                    $CI = &get_instance();
                    $seguir = $CI->gsatelite->get_campo('est_estado_cotizacion', 'est_seguimiento', array('est_id' => $row->cot_id_est));
                    $param_dias_seguim = $CI->gsatelite->get_parametro('SYS_COT_DIAS_SEGUIMIENTO', 30);
                    if ($seguir > 0) {
                                       $CI->db->order_by('seg_fecha DESC');
                        $seguimiento = $CI->gsatelite->get_tabla('seg_seguimiento', array('seg_id_cot' => $row->cot_id));
                        $ganada = $CI->gsatelite->get_campo('cog_cotiz_ganada', 'cog_id', array('cog_id_cot' => $row->cot_id));
                        $date1 = date('Y-m-d H:i:s');
                        if (count($seguimiento) > 0) {
                            $date2 = formatear_fecha('Y-m-d H:i:s', $seguimiento[0]['seg_fecha']);
                            $fecha_1 = new DateTime($date1);
                            $fecha_2 = new DateTime($date2);
                            $diferencia = date_diff($fecha_1, $fecha_2);
                            $sdias = $diferencia->days;
                            return '<span style="display:none;">' . str_pad($sdias, 5, 0, STR_PAD_LEFT) . '</span><span class="ult_seg_days" dultseg="' . $sdias . '" es_ganada="' . $ganada . '">' . $sdias . '</span>';
                        } else {
                            $date2 = formatear_fecha('Y-m-d H:i:s', $row->cot_fecha_pres);
                            $fecha_1 = new DateTime($date1);
                            $fecha_2 = new DateTime($date2);
                            $diferencia = date_diff($fecha_1, $fecha_2);
                            $ndias = $diferencia->days;
                            return '<span style="display:none;">' . str_pad($ndias, 5, 0, STR_PAD_LEFT) . '</span><span class="sin_seg_days" diasprs="' . $ndias . '" es_ganada="' . $ganada . '">' . $ndias . '</span>';
                        }
                    } else {
                        return '<span>No Aplica</span>';
                    }
                });
                $crud->callback_column('facturado', function ($value, $row) {
                    $CI = &get_instance();
                    $query = $this->db->query("SELECT IF(COUNT(fac_id_cot) >= 1,'Si','Pendiente') AS facturado FROM fac_factura WHERE fac_id_cot = " . $row->cot_id . "");
                    $value = $query->result_array();
                    return $value[0]['facturado'];
                });
                $crud->callback_column('fecha_presenta', function ($value, $row) {
                    $presento = $row->cot_fecha_pres;
                    return '<span style="display:none;">' . formatear_fecha('Ymd', $presento) . '</span><span>' . formatear_fecha('d-m-Y', $presento) . '</span>';
                });
                $crud->callback_column('cot_concepto', function ($value, $row) {
                    return "<span>$value</span>";
                });
                $crud->callback_column('cot_total', function ($value, $row) {
                    $smb = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', '$');
                    return $smb . number_format($value, 2);
                });
                $crud->callback_column('cot_subtotal', function ($value, $row) {
                    $smb = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', '$');
                    return $smb . number_format($value, 2);
                });
                $crud->callback_column('segui', function ($value, $row) {
                    $CI = &get_instance();
                    $id = $row->cot_id;
                    $CI->db->order_by('seg_id DESC');
                    $seguimientos = $CI->gsatelite->get_tabla('seg_seguimiento', array('seg_id_cot' => $id));
                    $comentario = (count($seguimientos) > 0) ? $seguimientos[0]['seg_comentario'] : "";
                    return '<input type="hidden" class="id_cotx" id="seg_cotid" name="seg_cotid[]" value="' . $row->cot_id . '"> <span>' . $comentario . '</span>';
                });
                $est_won = ($estados_cot['GANADA']) ? explode(",", $estados_cot['GANADA']) : array(0);
                $est_lost = ($estados_cot['PERDIDA']) ? explode(",", $estados_cot['PERDIDA']) : array(0);
                $no_mostrar = "[cot_estado] != 0 AND [cot_id_est] != " . $est_won[0] . " AND [cot_id_est] != " . $est_lost[0];
                $filtro_ganada = "[cot_id_est] != " . $est_won[0];
                $filtro_perdida = "[cot_id_est] != " . $est_lost[0];
                $crud->unset_edit();
                $crud->unset_delete();
                $crud->add_action('Costeo Cotización', '', 'cotizaciones/cotizaciones/presupuesto_cotizacion', 'icomoon-icon-stack');
                $crud->add_action('Ver', '', 'cotizaciones/cotizaciones/ver_cotizacion', 'minia-icon-search', null, null);
                $crud->add_action('Entregables', '', 'cotizaciones/cotizaciones/entregables_cot', ' brocco-icon-calendar', null, null);
                $crud->add_action('Formas de Pago', '', 'cotizaciones/cotizaciones/forma_pago_cot', 'icomoon-icon-coins', null, null);
                $crud->add_action('Anular', '', 'cotizaciones/cotizaciones/anular_cotizacion', 'minia-icon-trashcan inactivacion', null, null, $no_mostrar);

                //preguntar si es usuario supervisor o vendedor  y hacer los respectivos filtros
                $user = $this->tank_auth->get_user_id();
                $user_admin = $this->db->select('id')->from('users')->where('username like', '%admin%')->get()->row_array();
                $admin = $user_admin['id'];
                if ($esSup > 0 && $user != $admin) {
                    //EL USUARIO ES UN SUPERVISOR.
                    $filaSup = $this->cotModel->get_registro("sup_supervisor", "sup_id_usu", $this->tank_auth->get_user_id());
                    $datos['nombreSupervisor'] = $filaSup->sup_nombre . " " . $filaSup->sup_apellido;
                    $queryIdVen = $this->cotModel->get_idsVendedoresxSupervisor($this->tank_auth->get_user_id());
                    $queryIdCot = $this->cotModel->get_idsCotizacionesxSupervisor($this->tank_auth->get_user_id());
                    $dosroles = $this->gsatelite->get_tabla('ven_vendedor', array('ven_estado' => 1, 'ven_id_usu' => $this->tank_auth->get_user_id()));

                    if (count($dosroles) > 0) {
                        $arrayidsven = explode(',', $queryIdVen);
                        array_push($arrayidsven, $dosroles[0]['ven_id']);
                        $queryIdVen =  implode(',', array_unique($arrayidsven));
                    }
                    $this->db->join('cot_cotizacion', 'cot_id_ven = ven_id');
                    $mis_cots = $this->gsatelite->get_tabla('ven_vendedor', array('ven_estado' => 1, 'ven_id_usu' => $this->tank_auth->get_user_id()));
                    if (count($mis_cots) > 0) {
                        $cots_mias = implode(',', array_column($mis_cots, 'cot_id'));
                        $queryIdCot .= ',' . $cots_mias;
                    }
                    // var_dump($this->db->last_query());die();
                    /*$parametro = $this->gsatelite->get_parametro('SYS_AUTORIZA_ESTADO_COTIZACION_VENTA');*/
                    $crud->set_relation('cot_id_ven', 'ven_vendedor', '{ven_nombre} {ven_apellidos}', "ven_id in ( {$queryIdVen} )")->where("cot_id in ( {$queryIdCot} )");
                    if ($autorizacion_estados_cot > 0) {
                        $crud->add_action('Autorizar Cot.', '', 'cotizaciones/cotizaciones/autorizar_cotizacion', 'icomoon-icon-stack', null, null, array('cot_autorizada' => 0));
                        // $crud->add_action('Ganada', '', 'cotizaciones/cotizaciones/establecer_cotizacion_ganada', 'icomoon-icon-stack eliminar_accion_ganada', array($this, 'add_url_action_ganada'), null, $ganada);
                        $crud->add_action('Ganada', '', 'cotizaciones/cotizaciones/establecer_cotizacion_ganada', 'icomoon-icon-stack eliminar_accion_ganada', array($this, 'add_url_action_ganada'), null);
                        // $crud->add_action('Perdida', '', 'cotizaciones/cotizaciones/establecer_cotizacion_perdida', 'icomoon-icon-stack eliminar_accion_perdida', array($this, 'add_url_action_perdida'), null, $perdida);
                        $crud->add_action('Perdida', '', 'cotizaciones/cotizaciones/establecer_cotizacion_perdida', 'icomoon-icon-stack eliminar_accion_perdida', array($this, 'add_url_action_perdida'), null);
                    } else {
                        // $crud->add_action('Ganada', '', 'cotizaciones/cotizaciones/establecer_cotizacion_ganada', 'icomoon-icon-stack eliminar_accion_ganada', array($this, 'add_url_action_ganada'), null, $ganada2);
                        $crud->add_action('Ganada', '', 'cotizaciones/cotizaciones/establecer_cotizacion_ganada', 'icomoon-icon-stack eliminar_accion_ganada', array($this, 'add_url_action_ganada'), null);
                        // $crud->add_action('Perdida', '', 'cotizaciones/cotizaciones/establecer_cotizacion_perdida', 'icomoon-icon-stack eliminar_accion_perdida', array($this, 'add_url_action_perdida'), null, $perdida2);
                        $crud->add_action('Perdida', '', 'cotizaciones/cotizaciones/establecer_cotizacion_perdida', 'icomoon-icon-stack eliminar_accion_perdida', array($this, 'add_url_action_perdida'), null);
                    }
                    $crud->add_action('Reenviar Correo', '', 'cotizaciones/cotizaciones/reenvia_correo_cotizacion', 'icomoon-icon-mail-3 envia_correo');
                } else if ($esVen > 0 && $user != $admin) {
                    //EL USUARIO ES UN VENDEDOR
                    $perdida = "[cot_autorizada] == 1 AND [cot_id_est] == " . $estados_cot['VIGENTE']; //Si es vendedor, solo muestra opcion en las vigentes & autorizadas
                    //Preguntar los datos del vendedor
                    $filaVen = $this->cotModel->get_registro("ven_vendedor", "ven_id_usu", $this->tank_auth->get_user_id());
                    $id_Ven = $filaVen->ven_id;
                    $nombreVendedor = $filaVen->ven_nombre . " " . $filaVen->ven_apellidos;
                    $queryIdCot = $this->cotModel->get_idsCotizacionesxVendedor($this->tank_auth->get_user_id());
                    $crud->where("cot_id IN ({$queryIdCot})")->set_relation('cot_id_ven', 'ven_vendedor', '{ven_nombre} {ven_apellidos}', array('ven_estado' => 1, 'ven_id_usu' => $this->tank_auth->get_user_id()));
                    $datos["NombreVendedor"] = $nombreVendedor;
                    // $crud->add_action('Ganada', '', 'cotizaciones/cotizaciones/establecer_cotizacion_ganada', 'icomoon-icon-stack eliminar_accion_ganada', array($this, 'add_url_action_ganada'), null, $ganada);
                    $crud->add_action('Ganada', '', 'cotizaciones/cotizaciones/establecer_cotizacion_ganada', 'icomoon-icon-stack eliminar_accion_ganada', array($this, 'add_url_action_ganada'), null);
                    // $crud->add_action('Perdida', '', 'cotizaciones/cotizaciones/establecer_cotizacion_perdida', 'icomoon-icon-stack eliminar_accion_perdida', array($this, 'add_url_action_perdida'), null, $perdida);
                    $crud->add_action('Perdida', '', 'cotizaciones/cotizaciones/establecer_cotizacion_perdida', 'icomoon-icon-stack eliminar_accion_perdida', array($this, 'add_url_action_perdida'), null);
                    $crud->add_action('Enviar Cot. Correo', '', 'cotizaciones/cotizaciones/reenvia_correo_cotizacion', 'icomoon-icon-mail-3 envia_correo');
                } else if ($user == $admin) {
                    //EL USUARIO ES ADMINISTRADOR
                    if ($esSup > 0) {
                        $filaSup = $this->cotModel->get_registro("sup_supervisor", "sup_id_usu", $this->tank_auth->get_user_id());
                        $datos['nombreSupervisor'] = $filaSup->sup_nombre . " " . $filaSup->sup_apellido . " (ADMIN)";
                    } else if ($esVen > 0) {
                        $filaVen = $this->cotModel->get_registro("ven_vendedor", "ven_id_usu", $this->tank_auth->get_user_id());
                        $id_Ven = $filaVen->ven_id;
                        $nombreVendedor = $filaVen->ven_nombre . " " . $filaVen->ven_apellidos . " (ADMIN)";
                        $datos["NombreVendedor"] = $nombreVendedor;
                    }
                    $queryIdVen = null;
                    $crud->set_relation('cot_id_ven', 'ven_vendedor', '{ven_nombre} {ven_apellidos}', "ven_id in ( {$queryIdVen} )");
                    if ($autorizacion_estados_cot > 0) {
                        $crud->add_action('Autorizar Cot.', '', 'cotizaciones/cotizaciones/autorizar_cotizacion', 'icomoon-icon-stack', null, null, array('cot_autorizada' => 0));
                        // $crud->add_action('Ganada', '', 'cotizaciones/cotizaciones/establecer_cotizacion_ganada', 'icomoon-icon-stack eliminar_accion_ganada', array($this, 'add_url_action_ganada'), null, $ganada);//array('cot_autorizada' => 1, 'cot_id_est !=' => "Ganada")
                        $crud->add_action('Ganada', '', 'cotizaciones/cotizaciones/establecer_cotizacion_ganada', 'icomoon-icon-stack eliminar_accion_ganada', array($this, 'add_url_action_ganada'), null); //array('cot_autorizada' => 1, 'cot_id_est !=' => "Ganada")
                        // $crud->add_action('Perdida', '', 'cotizaciones/cotizaciones/establecer_cotizacion_perdida', 'icomoon-icon-stack eliminar_accion_perdida', array($this, 'add_url_action_perdida'), null, $perdida);
                        $crud->add_action('Perdida', '', 'cotizaciones/cotizaciones/establecer_cotizacion_perdida', 'icomoon-icon-stack eliminar_accion_perdida', array($this, 'add_url_action_perdida'), null);
                    } else {
                        // $crud->add_action('Ganada', '', 'cotizaciones/cotizaciones/establecer_cotizacion_ganada', 'icomoon-icon-stack eliminar_accion_ganada', array($this, 'add_url_action_ganada'), null, $ganada2);
                        $crud->add_action('Ganada', '', 'cotizaciones/cotizaciones/establecer_cotizacion_ganada', 'icomoon-icon-stack eliminar_accion_ganada', array($this, 'add_url_action_ganada'), null);
                        // $crud->add_action('Perdida', '', 'cotizaciones/cotizaciones/establecer_cotizacion_perdida', 'icomoon-icon-stack eliminar_accion_perdida', array($this, 'add_url_action_perdida'), null, $perdida2);
                        $crud->add_action('Perdida', '', 'cotizaciones/cotizaciones/establecer_cotizacion_perdida', 'icomoon-icon-stack eliminar_accion_perdida', array($this, 'add_url_action_perdida'), null);
                    }
                    $crud->add_action('Enviar Cot. Correo', '', 'cotizaciones/cotizaciones/reenvia_correo_cotizacion', 'icomoon-icon-mail-3 envia_correo');
                    //actionhere
                } else {
                    $queryIdCot = "0";
                    $crud->set_relation('cot_id_ven', 'ven_vendedor', '{ven_nombre} {ven_apellidos}', array('ven_estado' => 1, 'ven_id_usu' => $this->tank_auth->get_user_id()));
                    $crud->where("cot_id in ( {$queryIdCot} )");
                    $crud->unset_add();
                    $crud->unset_edit();
                }
                // Ordernar por fecha de presentacion
                $crud->order_by('cot_fecha_pres', 'DESC');
                $output = $crud->render();
                $datos["est_id"] = ($state > 0) ? $state : null;

                $datos["titulo_personal"] = "Cotizaciones";
                $datos["ndias_parametro"] = $this->gsatelite->get_parametro('SYS_COT_DIAS_SEGUIMIENTO');
                //Validacion si existe el parametro SYS_COT_DIAS_SEGUIMIENTO
                if ($datos["ndias_parametro"] == "" || $datos["ndias_parametro"] == null) {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Requisición", 'texto_alerta' => "Parametro requerido.");
                    $this->session->set_flashdata($alerta);
                    redirect('/cotizaciones/index');
                }
                $datos["fecha_actual"] = date("Y-m-d H:i:s");
                // Cargar Vendedores o vendedor y definir variable de esVendedor
                $where = array('vxs_id_sup' => $filaSup->sup_id);
                $vendedores = '';
                $verificar_ven = 0;
                if ($esSup > 0 /*&& $user != $admin*/) {
                    $verificar_ven = 0;
                    $this->db->join('ven_vendedor', 'ven_id = vxs_id_ven', 'inner');
                    $vendedores = $this->gsatelite->get_tabla('vxs_vendedorxsupervisor', $where);
                } else if ($esVen > 0) {
                    $verificar_ven = 1;
                    $vendedores = $this->gsatelite->get_tabla('ven_vendedor', array('ven_id_usu' => $this->tank_auth->get_user_id(), 'ven_estado' => 1));
                }
                // Recorrer para los vendedores \\
                $html = '';
                $selected = ($verificar_ven > 0) ? 'selected' : '';
                foreach ($vendedores as $key => $valor) {
                    $html .= '<option value="' . $valor['ven_id'] . '" ' . $selected . '>' . $valor['ven_codigo'] . ' - ' . $valor['ven_nombre'] . ' ' . $valor['ven_apellidos'] . '</option>';
                }
                $datos['vendedores']   = str_replace(array('<option value=""></option>', '<option value="0">Sin Registros</option>'), '', $html);
                // Obtener mes de las ultimas cotizacones
                $fecha_actual = ($this->input->post()) ? $fecha_actual : date("Y-m-t");
                $fecha_pasada = ($this->input->post()) ? $fecha_pasada : date("Y-m-01");
                $datos['fecha_actual'] = $fecha_actual;
                $datos['fecha_pasada'] = $fecha_pasada;
                $datos['est_cot_chk']  = $chkCot;
                $this->_cargarvista($datos, $output);
            } catch (Exception $e) {
                show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
            }
        }
    }

    public function ver_cotizacion($id_cot, $ver_cot = null)
    {
        $ver = 0;
        if ($ver_cot == null) {
            $ver = 1;
        } else {
            $ver = 2;
        }
        $this->editar_cotizacion($id_cot, $ver);
    }

    public function agregar_cotizacion()
    {
        if ($this->input->post()) {
            $post_array = $this->input->post();
            $tipo_btn   = $post_array['btnCrear'];
            $slcVendedor    = ($post_array['slcVendedor'] > 0) ? $post_array['slcVendedor'] : null;
            $slcCliente     = ($post_array['slcCliente'] > 0) ? $post_array['slcCliente'] : null;
            $slcSucursal    = ($post_array['slcSucursal'] != '') ? $post_array['slcSucursal'] : null;
            $slcTipoPago    = ($post_array['slcTipoPago'] > 0) ? $post_array['slcTipoPago'] : null;
            $slc_form_pay   = ($post_array['slc_forma_pago'] > 0) ? $post_array['slc_forma_pago'] : null;
            $txtDirigido    = $post_array['txtDirigido'];
            $txtFechaPresentacion = ($post_array['txtFechaPresentacion'] != '') ? date('Y-m-d', strtotime($post_array['txtFechaPresentacion'])) : null;
            $txtValidez     = ($post_array['txtValidez'] != '') ? $post_array['txtValidez'] : null;
            $slcContactos   = ($post_array['slcContactos'] != '') ? $post_array['slcContactos'] : null;
            $txtFechaVigencia = ($post_array['txtFechaVigencia'] != '') ? date('Y-m-d', strtotime($post_array['txtFechaVigencia'])) : null;
            $txtConcepto    = ($post_array['txtConcepto'] != '') ? $post_array['txtConcepto'] : null;
            $slcEtapa       = ($post_array['slcEtapa'] != '') ? $post_array['slcEtapa'] : null;
            $slcProyecto    = ($post_array['slcProyecto'] != '') ? $post_array['slcProyecto'] : null;
            $txtProbabilidad    = ($post_array['txtProbabilidad'] != '') ? $post_array['txtProbabilidad'] : null;
            $slc_condicion_pay  = ($post_array['slc_condicion_pay'] > 0) ? $post_array['slc_condicion_pay'] : null;
            $txtFechaCierre     = ($post_array['txtFechaCierre'] != '') ? date('Y-m-d', strtotime($post_array['txtFechaCierre'])) : null;
            $slcEstadoCotizacion = ($post_array['slcEstadoCotizacion'] != '') ? $post_array['slcEstadoCotizacion'] : null;
            $txtLugarEntrega    = ($post_array['txtLugarEntrega'] != '') ? $post_array['txtLugarEntrega'] : null;
            $txtComentario      = ($post_array['txtComentario'] != '') ? $post_array['txtComentario'] : null;
            $txtFechaEntrega    = ($post_array['txtFechaEntrega'] != '') ? date('Y-m-d', strtotime($post_array['txtFechaEntrega'])) : null;
            $txtHoraInicio  = ($post_array['txtHoraInicio'] != '') ? date('Y-m-d H:i:s', strtotime($post_array['txtHoraInicio'])) : null;
            $txtHoraFin     = ($post_array['txtHoraFin'] != '') ? date('Y-m-d H:i:s', strtotime($post_array['txtHoraFin'])) : null;
            $hdnEnviarEmail = $post_array['hdnEnviarEmail'];
            $slcProduccion  = ($post_array['slcProduccion'] == 2) ? 0 : 1;
            $txtCondiciones = ($post_array['txtCondiciones'] != '') ? $post_array['txtCondiciones'] : null;
            $txtDescuentoUnico = ($post_array['txtDescuentoUnico'] != '') ? $post_array['txtDescuentoUnico'] : null;
            $slcArea = ($post_array['slcArea'] != '') ? $post_array['slcArea'] : null;
            $hdnAplicaTransporte = $post_array['hdnAplicaTransporte'];
            $tipo_comision = ($post_array['slcTipoComis'] > 0) ? $post_array['slcTipoComis'] : null;
            $tipo_OfertaValida = $post_array['hdnkOfertaValida'];
            $tipo_fechaEntrega = $post_array['hdnFechaEntrega'];
            $txt_valid_ofert_person = $post_array['validez_oferta_txt'];
            $txt_fecha_entrega_person = $post_array['fechs_entrega_txt'];

            //$txtSumaGeneral = ($post_array['txtSumaGeneral'] != '') ? $post_array['txtSumaGeneral'] : null;
            $txtDescuentoGeneral = ($post_array['txtDescuentoGeneral'] != '') ? $post_array['txtDescuentoGeneral'] : null;
            $txtSubtotalGeneral = ($post_array['txtSubtotalGeneral'] != '') ? $post_array['txtSubtotalGeneral'] : null;
            $txtImpuestosGeneral = ($post_array['txtImpuestosGeneral'] != '') ? $post_array['txtImpuestosGeneral'] : null;
            $txtTotalGeneral = ($post_array['txtTotalGeneral'] != '') ? $post_array['txtTotalGeneral'] : null;
            //$autorizacion_estados_cot = (trim($this->gsatelite->get_parametro('SYS_AUTORIZA_ESTADO_COTIZACION_VENTA')) == 1)? 0 : 1;
            $codigo = ($post_array['txtCodigo'] != '') ? $post_array['txtCodigo'] : null;
            //VERIFICAR QUE NO SE REPITA EL CORRELATIVO CUANDO HAY VARIOS USUARIOS INGRESANDO AL MISMO TIEMPO
            $ultimo = ($this->gsatelite->count('cot_cotizacion') + 1);
            $this_code = explode('-', $codigo);
            if (intval($this_code[1]) < $ultimo) {
                if ($ultimo < 10) {
                    $this_code[1] = "000" . $ultimo;
                } else if ($ultimo < 100) {
                    $this_code[1] = "00" . $ultimo;
                } else if ($ultimo < 1000) {
                    $this_code[1] = "0" . $ultimo;
                } else {
                    $this_code[1] = $ultimo;
                }
                $codigo = implode('-', $this_code);
            }
            //Array costo de venta de producto por detalle
            $axc_costo_venta_por_producto = ($this->input->post('costo_venta_por_producto') != '') ? $this->input->post('costo_venta_por_producto') : null;
            //Anexos
            $TitulosAnexo = $post_array['titulo_doc'];
            $NombreAnexo = $post_array['ruta'];

            $cotizacion_array = array(
                'cot_id_cli' => $slcCliente,
                'cot_id_ven' => $slcVendedor,
                'cot_id_est' => $slcEstadoCotizacion,
                'cot_id_etc' => $slcEtapa,
                'cot_id_pcl' => $slcProyecto,
                'cot_id_frp' => $slc_form_pay,
                'cot_id_cod' => $slc_condicion_pay,
                'cot_id_scl' => $slcSucursal,
                'cot_id_arf' => $slcArea,
                'cot_id_tpg' => $slcTipoPago,
                'cot_id_tic' => $tipo_comision,
                'cot_codigo' => $codigo,
                'cot_fecha' => date('Y-m-d H:i:s'),
                'cot_fecha_pres' => $txtFechaPresentacion,
                'cot_concepto' => $txtConcepto,
                'cot_ult_fecha_cont' => date('Y-m-d H:i:s'),
                'cot_condicion' => $txtCondiciones,
                'cot_dirigido' => $txtDirigido,
                'cot_lugar_entrega' => $txtLugarEntrega,
                'cot_fecha_entrega' => $txtFechaEntrega,
                'cot_fecha_entrega_texto' => ($tipo_fechaEntrega > 0 && trim($txt_fecha_entrega_person) != "") ? trim($txt_fecha_entrega_person) : null,
                'cot_hora_inicio_entrega' => $txtHoraInicio,
                'cot_hora_fin_entrega' => $txtHoraFin,
                'cot_validez_oferta' => $txtValidez,
                'cot_validez_texto' => ($tipo_OfertaValida > 0 && trim($txt_valid_ofert_person) != "") ? trim($txt_valid_ofert_person) : null,
                'cot_fecha_vigencia' => $txtFechaVigencia,
                'cot_probabilidad_cierre' => $txtProbabilidad,
                'cot_fecha_cierre' => $txtFechaCierre,
                'cot_plan_accion' => (trim($this->input->post('txtPlanAccion')) != '') ? trim($this->input->post('txtPlanAccion')) : null,
                'cot_comentario' => $txtComentario,
                'cot_enviar_email' => $hdnEnviarEmail,
                'cot_aplica_transporte' => $hdnAplicaTransporte,
                'cot_produccion' => $slcProduccion,
                'cot_autorizada' => (trim($this->gsatelite->get_parametro('SYS_AUTORIZA_ESTADO_COTIZACION_VENTA')) == 1) ? 0 : 1,
                'cot_descuento_porcentaje' => convertirFloat($txtDescuentoUnico),
                'cot_subtotal' => convertirFloat($txtSubtotalGeneral),
                'cot_descuento' => convertirFloat($txtDescuentoGeneral),
                'cot_impuesto' => convertirFloat($txtImpuestosGeneral),
                'cot_total' => convertirFloat($txtTotalGeneral),
                'cot_estado' => 1,
                'cot_usu_creacion' => $this->tank_auth->get_user_id(),
                'cot_fecha_creacion' => date('Y-m-d H:i:s'),
                'cot_usu_modificacion' => $this->tank_auth->get_user_id(),
                'cot_fecha_modificacion' => date('Y-m-d H:i:s'),
            );

            $cot_id = $this->gsatelite->ingresar('cot_cotizacion', $cotizacion_array);
            if ($cot_id > 0) {
                //Se procesan los contactos agregados
                if (count($slcContactos) > 0) {
                    for ($i = 0; $i < count($slcContactos); $i++) {
                        if ($slcContactos[$i] > 0) {
                            $contactos_array = array(
                                'cxt_id_cot' => $cot_id,
                                'cxt_id_con' => $slcContactos[$i],
                                'cxt_estado' => 1,
                                'cxt_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'cxt_fecha_modificacion' => date('Y-m-d H:i:s'),
                                'cxt_usu_creacion' => $this->tank_auth->get_user_id(),
                                'cxt_fecha_creacion' => date('Y-m-d H:i:s')
                            );
                            $this->gsatelite->ingresar('cxt_contactoxcotizacion', $contactos_array);
                        }
                    }
                }

                $row        = $post_array['row'];
                $productos  = $post_array['productos'];
                $descripciones  = $post_array['descripciones'];
                $conversiones   = $post_array['conversiones'];
                $cantidades     = $post_array['cantidades'];
                $precios        = $post_array['precios'];
                $impuestos      = $post_array['impuestos'];
                $impuestosProducto  = $post_array['impuestosProducto'];
                $descuentos     = $post_array['descuentos'];
                $subtotalesProducto = $post_array['subtotalesProducto'];
                $totalesProducto    = $post_array['totalesProducto'];
                $personalizado      = $post_array['txtprodper'];
                // Se agrego la lista de precio y precio sugerido
                $lista_precio    = $post_array['lista_precio'];
                $precio_sugerido = $post_array['precio_sugerido'];
                if (count($productos) > 0) {
                    //Se ingresan los detalles de la cotizacion
                    $tipo = $this->input->post('tipo_caracteristica');
                    for ($i = 0; $i < count($productos); $i++) {
                        $cantidad_detalle   = convertirFloat($cantidades[$i]);
                        $precio_detalle     = convertirFloat($precios[$i]);
                        $impuestos_detalle  = convertirFloat($impuestosProducto[$i]);
                        $descuentos_detalle = ($descuentos[$i] != '') ? convertirFloat($descuentos[$i]) : 0;
                        $subtotal_detalle   = convertirFloat($subtotalesProducto[$i]);
                        $total_detalle  = convertirFloat($totalesProducto[$i]);
                        $prodper        = $personalizado[$i];

                        $detalle_array = array(
                            'axc_id_cot' => $cot_id,
                            'axc_id_art' => $productos[$i],
                            'axc_id_cva' => ($conversiones[$i] != '') ? $conversiones[$i] : null,
                            'axc_id_lip' => (trim($lista_precio[$i]) != "") ? $lista_precio[$i] : null, //(bitacora/historial)
                            'axc_precio_sugerido_lista' => (trim($precio_sugerido[$i]) != "") ? convertirFloat($precio_sugerido[$i]) : null,
                            'axc_descripcion'   => $descripciones[$i],
                            'axc_cantidad'      => $cantidad_detalle,
                            'axc_precio'        => $precio_detalle,
                            'axc_impuesto'      => $impuestos_detalle,
                            'axc_descuento'     => $descuentos_detalle,
                            'axc_subtotal'      => $subtotal_detalle,
                            'axc_total'         => $total_detalle,
                            'axc_personalizado' => $prodper,
                            'axc_cantidad_facturada' => 0.00,
                            'axc_cantidad_pendiente' => $cantidad_detalle,
                            'axc_precio_inventario'  => $axc_costo_venta_por_producto[$i],
                            'axc_estado'             => 1,
                            'axc_usu_creacion'       => $this->tank_auth->get_user_id(),
                            'axc_fecha_creacion'     => date('Y-m-d H:i:s'),
                            'axc_usu_modificacion'   => $this->tank_auth->get_user_id(),
                            'axc_fecha_modificacion' => date('Y-m-d H:i:s')
                        );

                        $axc_id = $this->gsatelite->ingresar('axc_articuloxcotizacion', $detalle_array);

                        if ($axc_id > 0) {
                            //Se valida existan impuestos
                            if (count($impuestos) > 0) {
                                //Se crea el array de los impuestos
                                $impuestos_array = explode(',', $impuestos[$i]);

                                if (count($impuestos_array) > 0) {
                                    //Se recore el array para la insercion de impuestos
                                    for ($j = 0; $j < count($impuestos_array); $j++) {

                                        if ($impuestos_array[$j] != '') {

                                            $porcentaje_impuesto = $this->gsatelite->get_campo('imp_impuesto', 'imp_porcentaje', array('imp_id' => $impuestos_array[$j]));
                                            $monto_porcenjate = ($porcentaje_impuesto / 100) * ($precio_detalle * $cantidad_detalle);
                                            $ixt_array = array(
                                                'ixt_id_imp' => $impuestos_array[$j],
                                                'ixt_id_axc' => $axc_id,
                                                'ixt_monto' => $monto_porcenjate,
                                                'ixt_estado' => 1,
                                                'ixt_usu_modificacion' => $this->tank_auth->get_user_id(),
                                                'ixt_fecha_modificacion' => date('Y-m-d H:i:s'),
                                                'ixt_usu_creacion' => $this->tank_auth->get_user_id(),
                                                'ixt_fecha_creacion' => date('Y-m-d H:i:s')
                                            );

                                            $this->gsatelite->ingresar('ixt_impuestoxcotizacion', $ixt_array);
                                        }
                                    }
                                }
                            }

                            //Se procesan los detalles del prorrateo
                            if (count($post_array['centroCostos_' . $productos[$i] . '_' . $row[$i]]) > 0) {
                                $centros_costo = $post_array['centroCostos_' . $productos[$i] . '_' . $row[$i]];
                                $porcentajes = $post_array['porcentajesCec_' . $productos[$i] . '_' . $row[$i]];
                                $totales = $post_array['totalCec_' . $productos[$i] . '_' . $row[$i]];

                                for ($j = 0; $j < count($post_array['centroCostos_' . $productos[$i] . '_' . $row[$i]]); $j++) {
                                    if ($centros_costo[$j] != '') {
                                        $detalle_pro_array = array(
                                            'pxt_id_dpr' => $centros_costo[$j],
                                            'pxt_id_axc' => $axc_id,
                                            'pxt_porcentaje' => $porcentajes[$j],
                                            'pxt_total' => $totales[$j],
                                            'pxt_estado' => 1,
                                            'pxt_usu_creacion' => $this->tank_auth->get_user_id(),
                                            'pxt_fecha_creacion' => date('Y-m-d H:i:s'),
                                            'pxt_usu_modificacion' => $this->tank_auth->get_user_id(),
                                            'pxt_fecha_modificacion' => date('Y-m-d H:i:s')
                                        );
                                        $this->gsatelite->ingresar('pxt_prorrateoxarticulo_cotizacion', $detalle_pro_array);
                                    }
                                }
                            }

                            // Retenciones
                            $index = 'montosIndividuales' . ($i + 1);
                            $retenciones = json_decode($post_array[$index][0], true);
                            $decimales   = ($this->gsatelite->get_parametro('NUMERO_DECIMALES') != '') ? $this->gsatelite->get_parametro('NUMERO_DECIMALES') : 2;

                            if (is_array($retenciones) && count($retenciones) > 0) {
                                for ($j = 0; $j < count($retenciones); $j++) {
                                    //print_r($retenciones[$j]['']);die();
                                    $arreglo = array(
                                        'rxz_id_axc'             => $axc_id,
                                        'rxz_id_ret'             => $retenciones[$j]['id'],
                                        'rxz_monto'              => $retenciones[$j]['valor'],
                                        'rxz_estado'             => 1,
                                        'rxz_usu_creacion'       => $this->tank_auth->get_user_id(),
                                        'rxz_fecha_creacion'     => date('Y-m-d H:i:s'),
                                        'rxz_usu_modificacion'   => $this->tank_auth->get_user_id(),
                                        'rxz_fecha_modificacion' => date('Y-m-d H:i:s')
                                    );

                                    $this->gsatelite->ingresar('rxz_retencionxcotizacion', $arreglo);
                                }
                            }



                            $caracteristicas_id = $this->input->post('caracteristica_' . $productos[$i] . '_' . $row[$i]); //array
                            //solo se usara la formula cuando el producto contenga alguna formula existente asociada a el
                            $formula = null;
                            $formula_id = null;

                            if ($tipo[$i] == 2) {
                                // la formula se obtiene con el codigo del producto, el input tiene la siguiente forma nombre_cada_+idproducto
                                $formula = (trim($this->input->post('resultado_formula_input' . $productos[$i] . '_' . $row[$i])) != "") ? $this->input->post('resultado_formula_input' . $productos[$i] . '_' . $row[$i]) : null;
                                $formula_id = (trim($this->input->post('resultado_formula_select' . $productos[$i] . '_' . $row[$i])) != "") ? $this->input->post('resultado_formula_select' . $productos[$i] . '_' . $row[$i]) : null;
                            }

                            if ($formula_id != null) {
                                $actualizar_axc = array('axc_id_foa' => $formula_id, 'axc_valor_formula' => $formula);
                                $this->gsatelite->actualizar_array('axc_articuloxcotizacion', $actualizar_axc, array('axc_id' => $axc_id));
                            }

                            for ($y = 0; $y < count($caracteristicas_id); $y++) {
                                if ($tipo[$i] == 0) {
                                    //cuanto el tipo es = a 0 significa que el producto no tiene caracteristicas
                                } else if ($tipo[$i] == 1) {
                                    // Toma el valor de la caja cuando no se a aplicado ninguna formula, para evitar que se aplique la formula y cambie los valores de las cajas
                                    // $caracteristicas_precio_valor = $this->input->post('preciosValores_'.$productos[$i].'_'.$caracteristicas_id[$y].'_'.$row[$i]); 
                                    $caracteristicas_id_valor = $this->input->post('valorcaja_' . $productos[$i] . '_' . $caracteristicas_id[$y] . '_' . $row[$i]); //array
                                    // La descripcion es el nombre de car_caracteristicas
                                    $caracteristicas_id_descripcion = $this->input->post('descripcion_' . $productos[$i] . '_' . $caracteristicas_id[$y] . '_' . $row[$i]); //array
                                } else if ($tipo[$i] == 2) {
                                    // Toma los valores de las cajas escondidas despues de aplicar la formula se almacenan en estas
                                    // Si no se a seleccionado ninguna formula, entonces el valor de las cajas que se toma seria las visibles
                                    if ($formula != "") {
                                        $caracteristicas_id_valor = $this->input->post('valor_' . $productos[$i] . '_' . $caracteristicas_id[$y] . '_' . $row[$i]); //array
                                    } else {
                                        $caracteristicas_id_valor = $this->input->post('valorcaja_' . $productos[$i] . '_' . $caracteristicas_id[$y] . '_' . $row[$i]); //array
                                    }
                                    // La descripcion es el nombre de car_caracteristicas
                                    $caracteristicas_id_descripcion = $this->input->post('descripcion_' . $productos[$i] . '_' . $caracteristicas_id[$y] . '_' . $row[$i]); //array
                                }
                                if ($tipo[$i] != 0) {
                                    if (trim($caracteristicas_id_valor) != "") {
                                        $caracteristicas_precio_valor = $this->input->post('preciosValores_' . $productos[$i] . '_' . $caracteristicas_id[$y] . '_' . $row[$i]);
                                        //se guardara en la tabla cxd_caracteristicaxdetalle_factura
                                        $caracteristicas_factura = array(
                                            'cxo_id_axc' => $axc_id,
                                            'cxo_id_cxu' => (trim($caracteristicas_id[$y]) != "") ? $caracteristicas_id[$y] : null,
                                            'cxo_valor' => (trim($caracteristicas_id_valor) != "") ? $caracteristicas_id_valor : null,
                                            // 'cxd_descripcion' => (trim($caracteristicas_id_descripcion) != "") ? $caracteristicas_id_descripcion : null,
                                            'cxo_estado' => 1,
                                            'cxo_usu_creacion' => $this->tank_auth->get_user_id(),
                                            'cxo_fecha_creacion' => date('Y-m-d H:i:s'),
                                            'cxo_usu_modificacion' => $this->tank_auth->get_user_id(),
                                            'cxo_fecha_modificacion' => date('Y-m-d H:i:s'),
                                            'cxo_precio_valor' => (trim($caracteristicas_precio_valor) != "") ? $caracteristicas_precio_valor : null

                                        );

                                        $this->gsatelite->ingresar('cxo_caracxarticuloxcotizacion', $caracteristicas_factura);
                                    }
                                }
                            } // fin de recorrido de las caracteristica
                        }
                        /* ===============================================================================================
                                    COMPONENTES
                        ================================================================================================*/
                        $identificador = '_' . $productos[$i] . '_' . $row[$i];

                        /* para descargar de bodega             type array*/
                        $descargar_componente = $this->input->post('producto_descargar_componente' . $identificador);
                        $tipo_componente = $this->input->post('producto_tipo_componente' . $identificador);
                        $bodega_componente = $this->input->post('bodega_componente_id' . $identificador); // no es arreglo

                        /* detalle para guardar                 type array*/
                        $producto_componente = ($this->input->post('producto_componente' . $identificador) != '') ? $this->input->post('producto_componente' . $identificador) : '';
                        $medida_componente = $this->input->post('medida_componente' . $identificador);
                        $cantidad_componente = $this->input->post('cantidad_conv_componente' . $identificador);

                        $precio_componente = $this->input->post('precio_componente' . $identificador);
                        $subtotal_componente = $this->input->post('subtotal_componente' . $identificador);
                        $descripcion_componente = $this->input->post('descripcion_componente' . $identificador);

                        $alternar_componente = $this->input->post('alternar_componente' . $identificador);
                        $mostrar_descripcion_componete = $this->input->post('showdesc_componente' . $identificador);

                        $fecha_creacion = date('Y-m-d H:i:s');
                        $componente_sav = array();
                        if ($producto_componente != '') {
                            foreach ($producto_componente as $id_comp => $comp) {
                                $componente_sav[] = array(
                                    'cdc_id_axc' => $axc_id,
                                    'cdc_id_cva' => $medida_componente[$id_comp],
                                    'cdc_descripcion' => $descripcion_componente[$id_comp],
                                    'cdc_cantidad' => $cantidad_componente[$id_comp],
                                    'cdc_precio' => $precio_componente[$id_comp],
                                    'cdc_subtotal' => $subtotal_componente[$id_comp],
                                    'cdc_total' => $subtotal_componente[$id_comp],
                                    'cdc_altera_precio' => $alternar_componente[$id_comp],
                                    'cdc_muestra_descripcion' => $mostrar_descripcion_componete[$id_comp],
                                    'cdc_estado' => 1,
                                    'cdc_usu_creacion' => $this->tank_auth->get_user_id(),
                                    'cdc_fecha_creacion' =>  $fecha_creacion,
                                    'cdc_usu_modificacion' => $this->tank_auth->get_user_id(),
                                    'cdc_fecha_modificacion' =>  $fecha_creacion
                                );
                            }
                            $this->gsatelite->ingresar('cdc_componente_detalle_cotizacion', $componente_sav, true);
                        }
                        //////////////////////////////////////////////////
                    }
                }

                if ($axc_id > 0) {
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Cotización", 'texto_alerta' => "El registro se guardó correctamente. Cotización N. " . $codigo);
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Cotización", 'texto_alerta' => "Ocurrio un problema al crear el registro.");
                }

                //Anexos
                if (count($NombreAnexo) > 0) {
                    for ($i = 0; $i < count($NombreAnexo); $i++) {
                        $extension = end(explode('.', $NombreAnexo[$i]));
                        $carpeta_temporal_anx = $ruta = "public/temp/anx_temporales/" . trim($NombreAnexo[$i]);

                        $nombreArchivo = trim($TitulosAnexo[$i]) . "." . trim($extension);

                        $carpeta_destino_anx = "uploads/anx_cotizacion/" . $nombreArchivo;

                        $anexos_array = array(
                            'axz_id_cot' => $cot_id,
                            'axz_url' => $carpeta_destino_anx,
                            'axz_nombre' => $nombreArchivo,
                            'axz_estado' => 1,
                            'axz_usu_creacion' => $this->tank_auth->get_user_id(),
                            'axz_fecha_creacion' => date('Y-m-d H:i:s'),
                            'axz_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'axz_fecha_modificacion' => date('Y-m-d H:i:s')
                        );

                        $axz_id = $this->gsatelite->ingresar('axz_anexoxcotizacion', $anexos_array);

                        if ($axz_id > 0) {
                            copy($carpeta_temporal_anx, $carpeta_destino_anx);
                            unlink($carpeta_temporal_anx);
                        }
                    }
                }
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Cotización", 'texto_alerta' => "Ocurrio un problema al crear el registro.");
            }

            $this->session->set_flashdata($alerta);
            if ($tipo_btn == 1) {
                redirect('cotizaciones/cotizaciones/agregar_cotizacion/');
            } else {
                redirect('cotizaciones/cotizaciones/index/');
            }
        }
        //Filtra las bodegas por usuario
        $bodxus = $this->inventario_model->get_bodegas_usuario();
        $bodegas = implode(', ', array_column($bodxus, 'bod_id'));
        $data['bodegas'] = $bodegas;

        //parametro para saber si se permite agregar mas de un producto
        $permite_mas_productos = $this->gsatelite->get_parametro('SYS_PERMITE_DUPLICAR_PRODUCTO');
        $data['permite_mas_productos'] = (trim($permite_mas_productos) != '') ? $permite_mas_productos : 0;

        //preguntar si es supervisor o vendedor
        $condicion1 = array('sup_id_usu' => $this->tank_auth->get_user_id(), 'sup_estado' => 1);
        $esSup = $this->cotModel->Existe_Registro("sup_supervisor", $condicion1);
        $condicion2 = array('ven_id_usu' => $this->tank_auth->get_user_id(), 'ven_estado' => 1);
        $esVen = $this->cotModel->Existe_Registro("ven_vendedor", $condicion2);
        /*****************Verificar si es vendedor para select***********************************/
        if ($esVen > 0) {
            $vende = $this->gsatelite->get_tabla('ven_vendedor', array('ven_id_usu' => $this->tank_auth->get_user_id(), 'ven_estado' => 1));
            //$data['esvendedor'] = TRUE;
            $select_default = $vende[0]['ven_id'];
        } else {
            //$select_default = (count($data['ven_permitidos']) == 1) ? $data['ven_permitidos'][0] : null;
            $select_default = '';
        }
        /***************Fin verificar si es vendedor************************************/
        //print_r($ven); die();
        if ($esSup > 0) {
            $queryIdVen = $this->cotModel->get_idsVendedoresxSupervisor($this->tank_auth->get_user_id());
            $data['ven_permitidos'] = ($queryIdVen == 0) ? array(0) : explode(',', $queryIdVen);
            //$data['clientes'] = '';
        } elseif ($esVen > 0) {
            $filaVen = $this->cotModel->get_registro("ven_vendedor", "ven_id_usu", $this->tank_auth->get_user_id());
            $data['ven_permitidos'] = array($filaVen->ven_id);
            // $data['clientes'] = $this->gsatelite->get_dropdown('cli_cliente', '{cli_nombre} {cli_apellido}','', array('cli_estado' => 1,'cli_id_ven' => $filaVen->ven_id), null, '', 'cli_id', true);
        } else {
            $this->gsatelite->show_dialog('Favor verificar que tu usuario este asociado a un vendedor o supervisor', 'cotizaciones/cotizaciones/index', 'note');
        }
        $permite_editar_precio = (trim($this->gsatelite->get_parametro('SYS_EDITA_PRECIO_LISTA')) != '') ? $this->gsatelite->get_parametro('SYS_EDITA_PRECIO_LISTA') : 0;
        $data['permite_editar_precio'] = $permite_editar_precio;
        //$select_default = (count($data['ven_permitidos']) == 1) ? $data['ven_permitidos'][0] : null;
        $this->db->where_in('ven_id', $data['ven_permitidos']);
        $this->db->join('users', 'id = ven_id_usu', 'inner');
        $this->db->join('emp_empleado', 'emp_id = usu_id_emp', 'left');
        $data['vendedores'] = $this->gsatelite->get_dropdown('ven_vendedor', "{emp_codigo} - {ven_nombre} {ven_apellidos}", '', array('ven_estado' => 1), $select_default, '', 'ven_id', true);
        $data['vendedores'] = str_replace('<option value="0">Seleccione</option>', '', $data['vendedores']);

        $tipos_pago = $this->gsatelite->get_tabla("tpg_tipo_pago", array("tpg_estado" => 1));
        $option_tpg = '<option value=""></option>';
        foreach ($tipos_pago as $k2) {
            $option_tpg .= '<option value="' . $k2['tpg_id'] . '" data-aplcred="' . intval($k2['tpg_aplica_credito']) . '" >' . $k2['tpg_nombre'] . '</option>';
        }
        $data['tipo_pago'] = $option_tpg;

        $formas_pago = $this->gsatelite->get_dropdown('frp_forma_pago', '{frp_nombre}', '', array('frp_estado' => 1), null, null, 'frp_id', true);
        $data['forma_pago'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $formas_pago);
        $condicion_pago = $this->gsatelite->get_dropdown('cod_condicion', '{cod_nombre}', '', array('cod_estado' => 1), null, null, 'cod_id', true);
        $data['condicionesPago'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $condicion_pago);


        $etapa_defecto = $this->cotModel->get_registro("etc_etapa_cotizacion", "etc_defecto", 1);
        $etapa_defecto_id = is_object($etapa_defecto) && isset($etapa_defecto) ? $etapa_defecto->etc_id: null;

        $data['etapa'] = $this->gsatelite->get_dropdown('etc_etapa_cotizacion', 'etc_nombre', '', array('etc_estado' => 1), $etapa_defecto_id, '', 'etc_id', true);

        //VERIFICAR SI YA EXISTEN LOS NUEVOS CAMPOS, SINO SE SEGUIRAN USANDO LOS VALORES DEL PARAMETRO
        $hay_ganada = $this->db->query("SHOW COLUMNS FROM est_estado_cotizacion WHERE Field = 'est_ganada'")->result_array();
        $hay_perdida = $this->db->query("SHOW COLUMNS FROM est_estado_cotizacion WHERE Field = 'est_perdida'")->result_array();
        if (count($hay_ganada) > 0 || count($hay_perdida) > 0) {
            $ganadas = array_column($this->gsatelite->get_tabla('est_estado_cotizacion', array('est_estado' => 1, 'est_ganada' => 1)), 'est_id');
            $perdidas = array_column($this->gsatelite->get_tabla('est_estado_cotizacion', array('est_estado' => 1, 'est_perdida' => 1)), 'est_id');
            $id_ganada = (count($ganadas) > 0) ? implode(',', $ganadas) : 0;
            $id_perdida = (count($perdidas) > 0) ? implode(',', $perdidas) : 0;
        } else {
            $estados_cot =  trim($this->gsatelite->get_parametro('SYS_ESTADO_COTIZACION'));
            $estados_cot = ($estados_cot != '' && is_object(json_decode($estados_cot))) ? (array) json_decode($estados_cot) : null;
            $id_ganada = (trim($estados_cot['GANADA']) > 0) ? $estados_cot['GANADA'] : 0;
            $id_perdida = (trim($estados_cot['PERDIDA']) > 0) ? $estados_cot['PERDIDA'] : 0;
        }

        $where_estado['est_estado'] = 1;
        $where_estado["est_id NOT IN($id_ganada, $id_perdida)"] = null;
        $data['estados'] = $this->gsatelite->get_dropdown('est_estado_cotizacion', 'est_nombre', '', $where_estado, 1, '', 'est_id', true);
        $data['areas'] = $this->gsatelite->get_dropdown('arf_area_factura', 'arf_nombre', '', array('arf_estado' => 1), null, '', 'arf_id', true);
        //Cargar parametro SYS_PRODUCCION_S_N_COT
        $data['SYS_PRODUCCION_S_N_COT'] = $this->gsatelite->get_parametro('SYS_PRODUCCION_S_N_COT');
        $correlativo = $this->gsatelite->get_tabla('cot_cotizacion');
        $codigo = count($correlativo) + 1;
        //-----------------------------------------------------------------------------------------------------
        $labelMes = "";
        $correlativoNew = "-";
        $mes = date("m");
        $anio = date("Y");
        if ($codigo < 10) {
            $correlativoNew = "-000" . $codigo;
        } else if ($codigo < 100) {
            $correlativoNew = "-00" . $codigo;
        } else if ($codigo < 1000) {
            $correlativoNew = "-0" . $codigo;
        } else {
            $correlativoNew = "-" . $codigo;
        }

        if ($mes == "01") {
            $labelMes = "ENERO";
        } else if ($mes == "02") {
            $labelMes = "FEBRERO";
        } else if ($mes == "03") {
            $labelMes = "MARZO";
        } else if ($mes == "04") {
            $labelMes = "ABRIL";
        } else if ($mes == "05") {
            $labelMes = "MAYO";
        } else if ($mes == "06") {
            $labelMes = "JUNIO";
        } else if ($mes == "07") {
            $labelMes = "JULIO";
        } else if ($mes == "08") {
            $labelMes = "AGOSTO";
        } else if ($mes == "09") {
            $labelMes = "SEPTIEMBRE";
        } else if ($mes == "10") {
            $labelMes = "OCTUBRE";
        } else if ($mes == "11") {
            $labelMes = "NOVIEMBRE";
        } else if ($mes == "12") {
            $labelMes = "DICIEMBRE";
        }

        $correlativoNew = substr($labelMes, 0, 3) . $anio . $correlativoNew;
        $codigo = $correlativoNew;
        //---------------------------------------------------------------------------------------------------------------------
        $data['correlativo'] = $codigo;
        $data['prorrateos'] = $this->gsatelite->get_dropdown('ptg_prorrateo_gasto', '{ptg_nombre}', 'prorrateos', array('ptg_estado' => 1), null, null, null, true);
        $data['comisiones'] = $this->gsatelite->get_dropdown('tic_tipo_comision', '{tic_nombre} ({tic_tasa})', '', array('tic_estado' => 1), null, null, null, true);
        $decimales  = $this->gsatelite->get_tabla("par_parametro", array('par_codigo' => 'NUMERO_DECIMALES'));
        $data["cantidad_decimales"] = ($decimales[0]["par_valor"] != "") ? $decimales[0]["par_valor"] : $decimales[0]["par_default"];
        // Configuracion parametrizada para mostrar elementos en la vista
        $data["show_option"] = $this->gsatelite->get_parametro('SYS_ELEMENTOS_MOSTRAR_COT', '1,1');
        // Parametro para obtener los dias de validez de la cotizacion 
        $dias_validos = $this->gsatelite->get_parametro('SYS_DIAS_VALIDEZ_COTIZACION');
        $data["dias_validos"] = ($dias_validos > 0) ? $dias_validos : '';
        $tpg_contado = $this->gsatelite->get_parametro('SYS_CONFIGURACION_CORTE_CAJA', null, null, array('CONTADO'));
        $data["tpg_contado"] = ($tpg_contado) ? $tpg_contado : 0;
        $data["descarga_inv"] = $this->gsatelite->get_parametro('SYS_DESCARGA_INV');
        $data["titulo_personal"] = "Agregar cotización";
        $this->_cargarvista($data);
    }

    public function editar_cotizacion($cot_id = null, $ver = 0)
    {
        satelite_validar();
        if ($this->input->post()) {
            $post_array = $this->input->post();
            // var_dump($post_array);die();
            $tipo_btn = $post_array['btnCrear'];
            $slcVendedor = ($post_array['slcVendedor'] > 0) ? $post_array['slcVendedor'] : null;
            $slcCliente = ($post_array['slcCliente'] > 0) ? $post_array['slcCliente'] : null;
            $slcSucursal = ($post_array['slcSucursal'] > 0) ? $post_array['slcSucursal'] : null;
            $slcTipoPago = ($post_array['slcTipoPago'] > 0) ? $post_array['slcTipoPago'] : null;
            $slcProyecto = ($post_array['slcProyecto'] != '') ? $post_array['slcProyecto'] : null;
            $slc_form_pay   = ($post_array['slc_forma_pago'] > 0) ? $post_array['slc_forma_pago'] : null;
            $txtDirigido = $post_array['txtDirigido'];
            $txtFechaPresentacion = ($post_array['txtFechaPresentacion'] != '') ? date('Y-m-d', strtotime($post_array['txtFechaPresentacion'])) : null;
            $txtValidez = ($post_array['txtValidez'] != '') ? $post_array['txtValidez'] : null;
            $slcContactos = ($post_array['slcContactos'] != '') ? $post_array['slcContactos'] : null;
            $txtFechaVigencia = ($post_array['txtFechaVigencia'] != '') ? date('Y-m-d', strtotime($post_array['txtFechaVigencia'])) : null;
            $txtConcepto = ($post_array['txtConcepto'] != '') ? $post_array['txtConcepto'] : null;
            $slcEtapa = ($post_array['slcEtapa'] != '') ? $post_array['slcEtapa'] : null;
            $txtProbabilidad = ($post_array['txtProbabilidad'] != '') ? $post_array['txtProbabilidad'] : null;
            $txtFechaCierre = ($post_array['txtFechaCierre'] != '') ? date('Y-m-d', strtotime($post_array['txtFechaCierre'])) : null;
            $slcEstadoCotizacion = ($post_array['slcEstadoCotizacion'] != '') ? $post_array['slcEstadoCotizacion'] : null;
            $txtLugarEntrega = ($post_array['txtLugarEntrega'] != '') ? $post_array['txtLugarEntrega'] : null;
            $txtComentario = ($post_array['txtComentario'] != '') ? $post_array['txtComentario'] : null;
            $txtFechaEntrega = ($post_array['txtFechaEntrega'] != '') ? date('Y-m-d', strtotime($post_array['txtFechaEntrega'])) : null;
            $txtHoraInicio = ($post_array['txtHoraInicio'] != '') ? date('Y-m-d H:i:s', strtotime($post_array['txtHoraInicio'])) : null;
            $txtHoraFin = ($post_array['txtHoraFin'] != '') ? date('Y-m-d H:i:s', strtotime($post_array['txtHoraFin'])) : null;
            $hdnEnviarEmail = $post_array['hdnEnviarEmail'];
            $hdnAplicaTransporte = $post_array['hdnAplicaTransporte'];
            $slcProduccion = ($post_array['slcProduccion'] == 2) ? 0 : 1;
            $txtCondiciones = ($post_array['txtCondiciones'] != '') ? $post_array['txtCondiciones'] : null;
            $txtDescuentoUnico = ($post_array['txtDescuentoUnico'] != '') ? $post_array['txtDescuentoUnico'] : null;
            $slcArea = ($post_array['slcArea'] != '') ? $post_array['slcArea'] : null;
            //$txtSumaGeneral = ($post_array['txtSumaGeneral'] != '') ? $post_array['txtSumaGeneral'] : null;
            $txtDescuentoGeneral = ($post_array['txtDescuentoGeneral'] != '') ? convertirFloat($post_array['txtDescuentoGeneral']) : null;
            $txtSubtotalGeneral = ($post_array['txtSubtotalGeneral'] != '') ? convertirFloat($post_array['txtSubtotalGeneral']) : null;
            $txtImpuestosGeneral = ($post_array['txtImpuestosGeneral'] != '') ? convertirFloat($post_array['txtImpuestosGeneral']) : null;
            $txtTotalGeneral = ($post_array['txtTotalGeneral'] != '') ? convertirFloat($post_array['txtTotalGeneral']) : null;
            $tipo_comision = ($post_array['slcTipoComis'] > 0) ? $post_array['slcTipoComis'] : null;
            $EstadoCot = ($post_array['slc_estado'] == 2) ? 0 : 1;
            $slc_condicion_pay  = ($post_array['slc_condicion_pay'] > 0) ? $post_array['slc_condicion_pay'] : null;
            $tipo_OfertaValida = $post_array['hdnkOfertaValida'];
            $tipo_fechaEntrega = $post_array['hdnFechaEntrega'];
            $txt_valid_ofert_person = $post_array['validez_oferta_txt'];
            $txt_fecha_entrega_person = $post_array['fechs_entrega_txt'];
            //Anexos
            $NombreAnexo = $post_array['ruta'];
            $TitulosAnexo = $post_array['titulo_doc'];
            $AnexoCot = $post_array['AnexoCot'];

            $cotizacion_array = array(
                'cot_id_cli' => $slcCliente,
                'cot_id_ven' => $slcVendedor,
                'cot_id_est' => $slcEstadoCotizacion,
                'cot_id_frp' => $slc_form_pay,
                'cot_id_etc' => $slcEtapa,
                'cot_id_arf' => $slcArea,
                'cot_id_scl' => $slcSucursal,
                'cot_id_tpg' => $slcTipoPago,
                'cot_id_pcl' => $slcProyecto,
                'cot_id_tic' => $tipo_comision,
                'cot_id_cod' => $slc_condicion_pay,
                'cot_fecha' => date('Y-m-d H:i:s'),
                'cot_fecha_pres' => $txtFechaPresentacion,
                'cot_concepto' => $txtConcepto,
                'cot_ult_fecha_cont' => date('Y-m-d H:i:s'),
                'cot_condicion' => $txtCondiciones,
                'cot_dirigido' => $txtDirigido,
                'cot_lugar_entrega' => $txtLugarEntrega,
                'cot_fecha_entrega' => $txtFechaEntrega,
                'cot_fecha_entrega_texto' => ($tipo_fechaEntrega > 0 && trim($txt_fecha_entrega_person) != "") ? trim($txt_fecha_entrega_person) : null,
                'cot_hora_inicio_entrega' => $txtHoraInicio,
                'cot_hora_fin_entrega' => $txtHoraFin,
                'cot_validez_oferta' => $txtValidez,
                'cot_validez_texto' => ($tipo_OfertaValida > 0 && trim($txt_valid_ofert_person) != "") ? trim($txt_valid_ofert_person) : null,
                'cot_fecha_vigencia' => $txtFechaVigencia,
                'cot_probabilidad_cierre' => $txtProbabilidad,
                'cot_fecha_cierre' => $txtFechaCierre,
                'cot_plan_accion' => (trim($this->input->post('txtPlanAccion')) != '') ? trim($this->input->post('txtPlanAccion')) : null,
                'cot_comentario' => $txtComentario,
                'cot_enviar_email' => $hdnEnviarEmail,
                'cot_aplica_transporte' => $hdnAplicaTransporte,
                'cot_produccion' => $slcProduccion,
                'cot_descuento_porcentaje' => convertirFloat($txtDescuentoUnico),
                'cot_subtotal' => convertirFloat($txtSubtotalGeneral),
                'cot_descuento' => convertirFloat($txtDescuentoGeneral),
                'cot_impuesto' => convertirFloat($txtImpuestosGeneral),
                'cot_total' => convertirFloat($txtTotalGeneral),
                'cot_estado' => $EstadoCot,
                'cot_usu_modificacion' => $this->tank_auth->get_user_id(),
                'cot_fecha_modificacion' => date('Y-m-d H:i:s'),
            );
            $resultado = $this->gsatelite->actualizar_array('cot_cotizacion', $cotizacion_array, array('cot_id' => $cot_id));

            if ($resultado > 0) {
                //Se procesan los contactos agregados
                //Se eliminan los contactos ya ingresados
                $this->gsatelite->borrado_general('cxt_contactoxcotizacion', array('cxt_id_cot' => $cot_id));
                if (count($slcContactos) > 0) {
                    for ($i = 0; $i < count($slcContactos); $i++) {
                        if ($slcContactos[$i] > 0) {
                            $contactos_array = array(
                                'cxt_id_cot' => $cot_id,
                                'cxt_id_con' => $slcContactos[$i],
                                'cxt_estado' => 1,
                                'cxt_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'cxt_fecha_modificacion' => date('Y-m-d H:i:s'),
                                'cxt_usu_creacion' => $this->tank_auth->get_user_id(),
                                'cxt_fecha_creacion' => date('Y-m-d H:i:s')
                            );
                            $this->gsatelite->ingresar('cxt_contactoxcotizacion', $contactos_array);
                        }
                    }
                }
                $row = $post_array['row'];
                $hdnDetalle = $post_array['hdnDetalle'];
                $productos = $post_array['productos'];
                $descripciones = $post_array['descripciones'];
                $conversiones = $post_array['conversiones'];
                $cantidades = $post_array['cantidades'];
                $precios = $post_array['precios'];
                $impuestos = $post_array['impuestos'];
                $impuestosProducto = $post_array['impuestosProducto'];
                $descuentos = $post_array['descuentos'];
                $subtotalesProducto = $post_array['subtotalesProducto'];
                $totalesProducto = $post_array['totalesProducto'];
                $prodper = $post_array['txtprodper'];
                $productosIds = null;

                if (count($hdnDetalle) > 0) {
                    for ($i = 0; $i < count($hdnDetalle); $i++) {
                        if ($hdnDetalle[$i] != '0') {
                            $productosIds[] = $hdnDetalle[$i];
                        }
                    }
                }

                //Se eliminan los registros necesarios.
                //Se verifica si se eliminaron productos.
                $dataDetalle = $this->cotModel->get_detalle_cotizacion(array('axc_id_cot' => $cot_id));
                if (!is_array($productosIds)) {
                    $productosIds = array();
                }
                foreach ($dataDetalle as $data) {
                    if (!in_array($data['axc_id'], $productosIds)) {
                        //Se eliminan los impuestos del detalle
                        $this->gsatelite->borrado_general('ixt_impuestoxcotizacion', array('ixt_id_axc' => $data['axc_id']));
                        //Se eliminan las caracteristicas del detalle
                        $this->gsatelite->borrado_general('cxo_caracxarticuloxcotizacion', array('cxo_id_axc' => $data['axc_id']));
                        //Se eliminan los prorrateos del detalle
                        $this->gsatelite->borrado_general('pxt_prorrateoxarticulo_cotizacion', array('pxt_id_axc' => $data['axc_id']));
                        //Se eliminan los componentes de la cotizacion
                        $this->gsatelite->borrado_general('cdc_componente_detalle_cotizacion', array('cdc_id_axc' => $data['axc_id']));
                        //Se elimina el detalle
                        $this->gsatelite->borrado_general('axc_articuloxcotizacion', array('axc_id' => $data['axc_id']));
                    }
                }

                if (count($productos) > 0) {
                    //Se ingresan los detalles de la cotizacion
                    $tipo = $this->input->post('tipo_caracteristica');

                    // Se agrego la lista de precio y precio sugerido
                    $lista_precio    = $post_array['lista_precio'];
                    $precio_sugerido = $post_array['precio_sugerido'];
                    for ($i = 0; $i < count($productos); $i++) {

                        $cantidad_detalle = convertirFloat($cantidades[$i]);
                        $precio_detalle = convertirFloat($precios[$i]);
                        $impuestos_detalle = convertirFloat($impuestosProducto[$i]);
                        $descuentos_detalle = ($descuentos[$i] != '') ? convertirFloat($descuentos[$i]) : 0;
                        $subtotal_detalle = convertirFloat($subtotalesProducto[$i]);
                        $total_detalle = convertirFloat($totalesProducto[$i]);

                        $detalle_array = array(
                            'axc_id_cot' => $cot_id,
                            'axc_id_art' => $productos[$i],
                            'axc_id_cva' => ($conversiones[$i] != '') ? $conversiones[$i] : null,
                            'axc_id_lip' => (trim($lista_precio[$i]) != "") ? $lista_precio[$i] : null, //(bitacora/historial)
                            'axc_precio_sugerido_lista' => (trim($precio_sugerido[$i]) != "") ? convertirFloat($precio_sugerido[$i]) : null,
                            'axc_descripcion' => $descripciones[$i],
                            'axc_cantidad' => $cantidad_detalle,
                            'axc_precio' => $precio_detalle,
                            'axc_impuesto' => $impuestos_detalle,
                            'axc_descuento' => $descuentos_detalle,
                            'axc_subtotal' => $subtotal_detalle,
                            'axc_total' => $total_detalle,
                            'axc_personalizado' => $prodper[$i],
                            'axc_estado' => 1,
                            'axc_usu_creacion' => $this->tank_auth->get_user_id(),
                            'axc_fecha_creacion' => date('Y-m-d H:i:s'),
                            'axc_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'axc_fecha_modificacion' => date('Y-m-d H:i:s')
                        );

                        //si ya existe el detalle se actualiza
                        if ($hdnDetalle[$i] != '0') {
                            $axc_id = $hdnDetalle[$i];
                            unset($detalle_array['axc_id_cot']);
                            unset($detalle_array['axc_id_art']);
                            unset($detalle_array['axc_id_cva']);
                            unset($detalle_array['axc_usu_creacion']);
                            unset($detalle_array['axc_fecha_creacion']);

                            $this->gsatelite->actualizar_array('axc_articuloxcotizacion', $detalle_array, array('axc_id' => $axc_id));
                        } else {
                            $axc_id = $this->gsatelite->ingresar('axc_articuloxcotizacion', $detalle_array);
                        }

                        if ($axc_id > 0) {
                            //Se eliminan los ya ingresados
                            $this->gsatelite->borrado_general('ixt_impuestoxcotizacion', array('ixt_id_axc' => $axc_id));
                            //Se valida existan impuestos
                            if (count($impuestos) > 0) {
                                //Se crea el array de los impuestos
                                $impuestos_array = explode(',', $impuestos[$i]);

                                if (count($impuestos_array) > 0) {
                                    //Se recore el array para la insercion de impuestos
                                    for ($j = 0; $j < count($impuestos_array); $j++) {

                                        if ($impuestos_array[$j] != '') {

                                            $porcentaje_impuesto = $this->gsatelite->get_campo('imp_impuesto', 'imp_porcentaje', array('imp_id' => $impuestos_array[$j]));
                                            $monto_porcenjate = ($porcentaje_impuesto / 100) * ($precio_detalle * $cantidad_detalle);
                                            $ixt_array = array(
                                                'ixt_id_imp' => $impuestos_array[$j],
                                                'ixt_id_axc' => $axc_id,
                                                'ixt_monto' => $monto_porcenjate,
                                                'ixt_estado' => 1,
                                                'ixt_usu_modificacion' => $this->tank_auth->get_user_id(),
                                                'ixt_fecha_modificacion' => date('Y-m-d H:i:s'),
                                                'ixt_usu_creacion' => $this->tank_auth->get_user_id(),
                                                'ixt_fecha_creacion' => date('Y-m-d H:i:s')
                                            );

                                            $this->gsatelite->ingresar('ixt_impuestoxcotizacion', $ixt_array);
                                        }
                                    }
                                }
                            }

                            //Se procesan los detalles del prorrateo
                            if (count($post_array['centroCostos_' . $productos[$i] . '_' . $row[$i]]) > 0) {
                                $centros_costo = $post_array['centroCostos_' . $productos[$i] . '_' . $row[$i]];
                                $porcentajes = $post_array['porcentajesCec_' . $productos[$i] . '_' . $row[$i]];
                                $totales = $post_array['totalCec_' . $productos[$i] . '_' . $row[$i]];

                                for ($j = 0; $j < count($post_array['centroCostos_' . $productos[$i] . '_' . $row[$i]]); $j++) {
                                    if ($centros_costo[$j] != '') {
                                        $detalle_pro_array = array(
                                            'pxt_id_dpr' => $centros_costo[$j],
                                            'pxt_id_axc' => $axc_id,
                                            'pxt_porcentaje' => $porcentajes[$j],
                                            'pxt_total' => $totales[$j],
                                            'pxt_estado' => 1,
                                            'pxt_usu_creacion' => $this->tank_auth->get_user_id(),
                                            'pxt_fecha_creacion' => date('Y-m-d H:i:s'),
                                            'pxt_usu_modificacion' => $this->tank_auth->get_user_id(),
                                            'pxt_fecha_modificacion' => date('Y-m-d H:i:s')
                                        );
                                        $this->gsatelite->ingresar('pxt_prorrateoxarticulo_cotizacion', $detalle_pro_array);
                                    }
                                }
                            }

                            /* ==========================================================================================
                                        CARACTERISTICAS
                            ============================================================================================*/


                            //Se elimina los detalles y se ingresan de nuevo
                            $this->gsatelite->borrado_general('cxo_caracxarticuloxcotizacion', array('cxo_id_axc' => $axc_id));

                            $caracteristicas_id = $this->input->post('caracteristica_' . $productos[$i] . '_' . $row[$i]); //array
                            //solo se usara la formula cuando el producto contenga alguna formula existente asociada a el
                            $formula = null;
                            $formula_id = null;

                            if ($tipo[$i] == 2) {
                                // la formula se obtiene con el codigo del producto, el input tiene la siguiente forma nombre_cada_+idproducto
                                $formula = (trim($this->input->post('resultado_formula_input' . $productos[$i] . '_' . $row[$i])) != "") ? $this->input->post('resultado_formula_input' . $productos[$i] . '_' . $row[$i]) : null;
                                $formula_id = (trim($this->input->post('resultado_formula_select' . $productos[$i] . '_' . $row[$i])) != "") ? $this->input->post('resultado_formula_select' . $productos[$i] . '_' . $row[$i]) : null;
                            }

                            if ($formula_id != null) {
                                $actualizar_axc = array('axc_id_foa' => $formula_id, 'axc_valor_formula' => $formula);
                                $this->gsatelite->actualizar_array('axc_articuloxcotizacion', $actualizar_axc, array('axc_id' => $axc_id));
                            }

                            for ($y = 0; $y < count($caracteristicas_id); $y++) {
                                //cuanto el tipo es = a 0 significa que el producto no tiene caracteristicas
                                $caracteristicas_precio_valor = $this->input->post('preciosValores_' . $productos[$i] . '_' . $caracteristicas_id[$y] . '_' . $row[$i]);

                                if ($tipo[$i] == 0) {
                                } else if ($tipo[$i] == 1) {

                                    // Toma el valor de la caja cuando no se a aplicado ninguna formula, para evitar que se aplique la formula y cambie los valores de las cajas
                                    $caracteristicas_id_valor = $this->input->post('valorcaja_' . $productos[$i] . '_' . $caracteristicas_id[$y] . '_' . $row[$i]); //array

                                    // La descripcion es el nombre de car_caracteristicas
                                    $caracteristicas_id_descripcion = $this->input->post('descripcion_' . $productos[$i] . '_' . $caracteristicas_id[$y] . '_' . $row[$i]); //array

                                    $caracteristicas_precio_valor = $this->input->post('preciosValores_' . $productos[$i] . '_' . $caracteristicas_id[$y] . '_' . $row[$i]);
                                } else if ($tipo[$i] == 2) {

                                    // Toma los valores de las cajas escondidas despues de aplicar la formula se almacenan en estas
                                    // Si no se a seleccionado ninguna formula, entonces el valor de las cajas que se toma seria las visibles
                                    if ($formula != "") {

                                        $caracteristicas_id_valor = $this->input->post('valor_' . $productos[$i] . '_' . $caracteristicas_id[$y] . '_' . $row[$i]); //array

                                        $caracteristicas_precio_valor = $this->input->post('preciosValores_' . $productos[$i] . '_' . $caracteristicas_id[$y] . '_' . $row[$i]);
                                    } else {

                                        $caracteristicas_id_valor = $this->input->post('valorcaja_' . $productos[$i] . '_' . $caracteristicas_id[$y] . '_' . $row[$i]); //array

                                        $caracteristicas_precio_valor = $this->input->post('preciosValores_' . $productos[$i] . '_' . $caracteristicas_id[$y] . '_' . $row[$i]);
                                    }
                                    // La descripcion es el nombre de car_caracteristicas
                                    $caracteristicas_id_descripcion = $this->input->post('descripcion_' . $productos[$i] . '_' . $caracteristicas_id[$y] . '_' . $row[$i]); //array
                                }
                                if ($tipo[$i] != 0) {
                                    if (is_array($caracteristicas_precio_valor)) {
                                        $caracteristicas_precio_valor = $caracteristicas_precio_valor[$y];
                                    }
                                    if (trim($caracteristicas_id_valor) != "") {

                                        //se guardara en la tabla cxd_caracteristicaxdetalle_factura
                                        $caracteristicas_factura = array(
                                            'cxo_id_axc' => $axc_id,
                                            'cxo_id_cxu' => (trim($caracteristicas_id[$y]) != "") ? $caracteristicas_id[$y] : null,
                                            'cxo_valor' => (trim($caracteristicas_id_valor) != "") ? $caracteristicas_id_valor : null,
                                            // 'cxd_descripcion' => (trim($caracteristicas_id_descripcion) != "") ? $caracteristicas_id_descripcion : null,
                                            'cxo_estado' => 1,
                                            'cxo_usu_creacion' => $this->tank_auth->get_user_id(),
                                            'cxo_fecha_creacion' => date('Y-m-d H:i:s'),
                                            'cxo_usu_modificacion' => $this->tank_auth->get_user_id(),
                                            'cxo_fecha_modificacion' => date('Y-m-d H:i:s'),
                                            'cxo_precio_valor'       => ($caracteristicas_precio_valor != "") ? $caracteristicas_precio_valor : null
                                        );

                                        $this->gsatelite->ingresar('cxo_caracxarticuloxcotizacion', $caracteristicas_factura);
                                    }
                                }
                            } // fin de recorrido de las caracteristica
                            //Se procesan los detalles de las caracteristicas
                            // if (count($post_array['caracteristicas_' . $productos[$i] . '_' . $row[$i]]) > 0) {
                            //     $caracteristicas = $post_array['caracteristicas_' . $productos[$i] . '_' . $row[$i]];
                            //     $valores = $post_array['valoresCarac_' . $productos[$i] . '_' . $row[$i]];

                            //     for ($j = 0; $j < count($post_array['caracteristicas_' . $productos[$i] . '_' . $row[$i]]); $j++) {
                            //         if ($caracteristicas[$j] != '') {
                            //             $detalle_carac_array = array(
                            //                 'cxo_id_cxu' => $caracteristicas[$j],
                            //                 'cxo_id_axc' => $axc_id,
                            //                 'cxo_valor' => $valores[$j],
                            //                 'cxo_estado' => 1,
                            //                 'cxo_usu_creacion' => $this->tank_auth->get_user_id(),
                            //                 'cxo_fecha_creacion' => date('Y-m-d H:i:s'),
                            //                 'cxo_usu_modificacion' => $this->tank_auth->get_user_id(),
                            //                 'cxo_fecha_modificacion' => date('Y-m-d H:i:s')
                            //             );
                            //             $this->gsatelite->ingresar('cxo_caracxarticuloxcotizacion', $detalle_carac_array);
                            //         }
                            //     }
                            // }
                        }
                        /* ===================================================================================================
                                    COMPONENTES
                    ====================================================================================================*/
                        $identificador = '_' . $productos[$i] . '_' . $row[$i];

                        /* para descargar de bodega             type array*/
                        $tipo_estado = $this->input->post('tipo_estado' . $identificador);
                        $descargar_componente = $this->input->post('producto_descargar_componente' . $identificador);
                        $tipo_componente = $this->input->post('producto_tipo_componente' . $identificador);
                        $bodega_componente = $this->input->post('bodega_componente_id' . $identificador); // no es arreglo

                        /* detalle para guardar                 type array*/
                        $producto_componente = ($this->input->post('producto_componente' . $identificador) != '') ? $this->input->post('producto_componente' . $identificador) : '';
                        $medida_componente = $this->input->post('medida_componente' . $identificador);
                        $cantidad_componente = $this->input->post('cantidad_conv_componente' . $identificador);

                        $precio_componente = $this->input->post('precio_componente' . $identificador);
                        $subtotal_componente = $this->input->post('subtotal_componente' . $identificador);
                        $descripcion_componente = $this->input->post('descripcion_componente' . $identificador);

                        $alternar_componente = $this->input->post('alternar_componente' . $identificador);
                        $mostrar_descripcion_componete = $this->input->post('showdesc_componente' . $identificador);

                        $componentes_reg = $this->gsatelite->get_tabla('cdc_componente_detalle_cotizacion', array('cdc_id_axc' => $axc_id));
                        $fecha_creacion = date('Y-m-d H:i:s');
                        //$componente_up = array();
                        if ($tipo_estado != '') {
                            foreach ($componentes_reg as $comp_reg) {
                                if (!in_array($comp_reg['cdc_id'], $tipo_estado)) {
                                    $this->gsatelite->borrado_general('cdc_componente_detalle_cotizacion', array('cdc_id' => $comp_reg['cdc_id']));
                                } else {
                                    $indice_comp = array_search($comp_reg['cdc_id'], $tipo_estado);
                                    $componente_up = array(
                                        'cdc_descripcion' => $descripcion_componente[$indice_comp],
                                        'cdc_cantidad' => $cantidad_componente[$indice_comp],
                                        'cdc_precio' => $precio_componente[$indice_comp],
                                        'cdc_subtotal' => $subtotal_componente[$indice_comp],
                                        'cdc_total' => $subtotal_componente[$indice_comp],
                                        'cdc_altera_precio' => $alternar_componente[$indice_comp],
                                        'cdc_muestra_descripcion' => $mostrar_descripcion_componete[$indice_comp],
                                        'cdc_estado' => 1,
                                        'cdc_usu_modificacion' => $this->tank_auth->get_user_id(),
                                        'cdc_fecha_modificacion' =>  $fecha_creacion
                                    );
                                    $this->gsatelite->actualizar_array('cdc_componente_detalle_cotizacion', $componente_up, array('cdc_id' => $comp_reg['cdc_id']));
                                }
                            }
                        } else {
                            $this->gsatelite->borrado_general('cdc_componente_detalle_cotizacion', array('cdc_id_axc' => $axc_id));
                        }


                        $fecha_creacion = date('Y-m-d H:i:s');
                        $componente_sav = array();
                        if ($producto_componente != '') {
                            foreach ($producto_componente as $id_comp => $comp) {
                                if ($tipo_estado[$id_comp] == 0) {
                                    $componente_sav[] = array(
                                        'cdc_id_axc' => $axc_id,
                                        'cdc_id_cva' => $medida_componente[$id_comp],
                                        'cdc_descripcion' => $descripcion_componente[$id_comp],
                                        'cdc_cantidad' => $cantidad_componente[$id_comp],
                                        'cdc_precio' => $precio_componente[$id_comp],
                                        'cdc_subtotal' => $subtotal_componente[$id_comp],
                                        'cdc_total' => $subtotal_componente[$id_comp],
                                        'cdc_altera_precio' => $alternar_componente[$id_comp],
                                        'cdc_muestra_descripcion' => $mostrar_descripcion_componete[$id_comp],
                                        'cdc_estado' => 1,
                                        'cdc_usu_creacion' => $this->tank_auth->get_user_id(),
                                        'cdc_fecha_creacion' =>  $fecha_creacion,
                                        'cdc_usu_modificacion' => $this->tank_auth->get_user_id(),
                                        'cdc_fecha_modificacion' =>  $fecha_creacion
                                    );
                                }
                            }
                            if (count($componente_sav) > 0) {
                                $this->gsatelite->ingresar('cdc_componente_detalle_cotizacion', $componente_sav, true);
                            }
                        }
                    }
                }

                if ($axc_id > 0) {
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Cotización", 'texto_alerta' => "El registro se guardó correctamente.");
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Cotización", 'texto_alerta' => "Ocurrio un problema al crear el registro.");
                }

                //Se obtienen los Anexos guardados, si existen se verifica si se actualizan o se eliminan
                $dataAnexos = $this->gsatelite->get_tabla('axz_anexoxcotizacion', array('axz_id_cot' => $cot_id));
                if (!is_array($AnexoCot)) {
                    $AnexoCot = array();
                }
                foreach ($dataAnexos as $data) {
                    if (!in_array($data['axz_id'], $AnexoCot)) {
                        $this->gsatelite->borrado_general('axz_anexoxcotizacion', array('axz_id' => $data['axz_id']));
                        $ruta_nxp = $data['axz_url'];
                        unlink($ruta_nxp);
                    }
                }

                //Anexos
                if (count($NombreAnexo) > 0) {
                    for ($i = 0; $i < count($NombreAnexo); $i++) {
                        $extension = end(explode('.', $NombreAnexo[$i]));
                        $carpeta_temporal_anx = $ruta = "public/temp/anx_temporales/" . trim($NombreAnexo[$i]);

                        $nombreArchivo = trim($TitulosAnexo[$i]) . "." . trim($extension);

                        $carpeta_destino_anx = "uploads/anx_cotizacion/" . $nombreArchivo;

                        $anexos_array = array(
                            'axz_id_cot' => $cot_id,
                            'axz_url' => $nombreArchivo,
                            'axz_nombre' => $nombreArchivo,
                            'axz_estado' => 1,
                            'axz_usu_creacion' => $this->tank_auth->get_user_id(),
                            'axz_fecha_creacion' => date('Y-m-d H:i:s'),
                            'axz_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'axz_fecha_modificacion' => date('Y-m-d H:i:s'),
                        );

                        $axz_id = $this->gsatelite->ingresar('axz_anexoxcotizacion', $anexos_array);

                        if ($axz_id > 0) {
                            copy($carpeta_temporal_anx, $carpeta_destino_anx);
                            unlink($carpeta_temporal_anx);
                        }
                    }
                }
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Cotización", 'texto_alerta' => "Ocurrio un problema al crear el registro.");
            }

            $this->session->set_flashdata($alerta);

            if ($tipo_btn == 1) {
                redirect('cotizaciones/cotizaciones/editar_cotizacion/' . $cot_id);
            } else {
                redirect('cotizaciones/cotizaciones/index/');
            }
        }

        //parametro para saber si se permite agregar mas de un producto
        $permite_mas_productos = $this->gsatelite->get_parametro('SYS_PERMITE_DUPLICAR_PRODUCTO');
        $data['permite_mas_productos'] = (trim($permite_mas_productos) != '') ? $permite_mas_productos : 0;
        $this->gsatelite->verificar_registro_real('cot_cotizacion', $cot_id);
        //preguntar ha sido declarada como ganada o perdida para ya no poder editarse (PENDIENTE)
        //preguntar si es supervisor o vendedor
        $condicion1 = array('sup_id_usu' => $this->tank_auth->get_user_id(), 'sup_estado' => 1);
        $esSup = $this->cotModel->Existe_Registro("sup_supervisor", $condicion1);
        $condicion2 = array('ven_id_usu' => $this->tank_auth->get_user_id(), 'ven_estado' => 1);
        $esVen = $this->cotModel->Existe_Registro("ven_vendedor", $condicion2);
        if ($esSup > 0) {
            $queryIdVen = $this->cotModel->get_idsVendedoresxSupervisor($this->tank_auth->get_user_id());
            $data['ven_permitidos'] = ($queryIdVen == 0) ? array(0) : explode(',', $queryIdVen);
            //$data['clientes'] = '';
        } elseif ($esVen > 0) {
            $filaVen = $this->cotModel->get_registro("ven_vendedor", "ven_id_usu", $this->tank_auth->get_user_id());
            $data['ven_permitidos'] = array($filaVen->ven_id);
            // $data['clientes'] = $this->gsatelite->get_dropdown('cli_cliente', '{cli_nombre} {cli_apellido}','', array('cli_estado' => 1,'cli_id_ven' => $filaVen->ven_id), null, '', 'cli_id', true);
        } else {
            $this->gsatelite->show_dialog('Favor verificar que tu usuario este asociado a un vendedor o supervisor', 'cotizaciones/cotizaciones/index', 'note');
        }

        // Obtener las Condiciones
        $cotizacion = $this->cotModel->get_cotizacion(array('cot_id' => $cot_id), 0);
        //VERIFICAR SI YA EXISTEN LOS NUEVOS CAMPOS, SINO SE SEGUIRAN USANDO LOS VALORES DEL PARAMETRO
        $hay_ganada = $this->db->query("SHOW COLUMNS FROM est_estado_cotizacion WHERE Field = 'est_ganada'")->result_array();
        $hay_perdida = $this->db->query("SHOW COLUMNS FROM est_estado_cotizacion WHERE Field = 'est_perdida'")->result_array();
        if (count($hay_ganada) > 0 || count($hay_perdida) > 0) {
            $ganadas = array_column($this->gsatelite->get_tabla('est_estado_cotizacion', array('est_estado' => 1, 'est_ganada' => 1)), 'est_id');
            $perdidas = array_column($this->gsatelite->get_tabla('est_estado_cotizacion', array('est_estado' => 1, 'est_perdida' => 1)), 'est_id');
            $id_ganada = (count($ganadas) > 0) ? implode(',', $ganadas) : 0;
            $id_perdida = (count($perdidas) > 0) ? implode(',', $perdidas) : 0;
            if ((in_array($cotizacion[0]['cot_id_est'], $ganadas) || in_array($cotizacion[0]['cot_id_est'], $perdidas)) && $ver == 0) {
                //SI VER = 0 ES 'EDIT' SINO ES 'READ'
                $this->gsatelite->show_dialog('Cotización como ganada o perdida, no procede edición.', 'cotizaciones/cotizaciones/index', 'info');
            }
        } else {
            $estados_cot =  trim($this->gsatelite->get_parametro('SYS_ESTADO_COTIZACION'));
            $estados_cot = ($estados_cot != '' && is_object(json_decode($estados_cot))) ? (array) json_decode($estados_cot) : null;
            $id_ganada = (trim($estados_cot['GANADA']) > 0) ? $estados_cot['GANADA'] : 0;
            $id_perdida = (trim($estados_cot['PERDIDA']) > 0) ? $estados_cot['PERDIDA'] : 0;
            if (($cotizacion[0]['cot_id_est'] == $id_ganada || $cotizacion[0]['cot_id_est'] == $id_perdida) && $ver == 0) {
                //SI VER = 0 ES 'EDIT' SINO ES 'READ'
                $this->gsatelite->show_dialog('Cotización como ganada o perdida, no procede edición.', 'cotizaciones/cotizaciones/index', 'info');
            }
        }
        //Consulta de artículos.
        $detalle_productos = $this->cotModel->get_detalle_cotizacion(array('axc_id_cot' => $cot_id));
        $data['detalle_productos'] = $detalle_productos;
        //die(print_r($detalle_productos));
        //Se obtienen los datos del clientes
        $contactos_cotizacion = $this->gsatelite->get_tabla('cxt_contactoxcotizacion', array('cxt_id_cot' => $cot_id));
        $idsContactos = array_column($contactos_cotizacion, 'cxt_id_con');
        $registrados = array(
            'sucursales' => array($cotizacion[0]['cot_id_scl']),
            'contactos' => $idsContactos
        );

        $permite_editar_precio = (trim($this->gsatelite->get_parametro('SYS_EDITA_PRECIO_LISTA')) != '') ? $this->gsatelite->get_parametro('SYS_EDITA_PRECIO_LISTA') : 0;
        $data['permite_editar_precio'] = $permite_editar_precio;
        $data['datos_cliente'] = $this->get_informacion_cliente($cotizacion[0]['cot_id_cli'], $registrados);
        $data['lista_de_cliente'] = $data['datos_cliente']['lista_client'];
        $data['cotizacion'] = $cotizacion[0];
        $select_default = $cotizacion[0]['cot_id_ven']; //(count($data['ven_permitidos']) == 1) ? $data['ven_permitidos'][0] : null;

        $this->db->where_in('ven_id', $data['ven_permitidos']);
        $this->db->join('users', 'id = ven_id_usu', 'inner');
        $this->db->join('emp_empleado', 'emp_id = usu_id_emp', 'left');
        $data['vendedores'] = $this->gsatelite->get_dropdown('ven_vendedor', "{ven_nombre} {ven_apellidos}", '', array('ven_estado' => 1), $select_default, '', 'ven_id', true);

        $tipos_pago = $this->gsatelite->get_tabla("tpg_tipo_pago", array("tpg_estado" => 1));
        $option_tpg = '<option value=""></option>';
        foreach ($tipos_pago as $k2) {
            $selected_ = ($k2['tpg_id'] == $cotizacion[0]['cot_id_tpg']) ? 'selected' : '';
            $option_tpg .= '<option value="' . $k2['tpg_id'] . '" data-aplcred="' . intval($k2['tpg_aplica_credito']) . '" ' . $selected_ .'  >' . $k2['tpg_nombre'] . '</option>';
        }
        $data['tipo_pago'] = $option_tpg;


        $etapa_defecto = $this->cotModel->get_registro("etc_etapa_cotizacion", "etc_defecto", 1);
        $etapa_defecto_id = is_object($etapa_defecto) && isset($etapa_defecto) ? $etapa_defecto->etc_id: null;

        $cot_id_etc = isset($cotizacion[0]['cot_id_etc']) ? $cotizacion[0]['cot_id_etc']: $etapa_defecto_id; 

        $data['etapa'] = $this->gsatelite->get_dropdown('etc_etapa_cotizacion', 'etc_nombre', '', array('etc_estado' => 1), $cot_id_etc, '', 'etc_id', true);
        $formas_pago = $this->gsatelite->get_dropdown('frp_forma_pago', '{frp_nombre}', '', array('frp_estado' => 1), $cotizacion[0]['cot_id_frp'], null, 'frp_id', true);
        $data['forma_pago'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $formas_pago);
        $condicion_pago = $this->gsatelite->get_dropdown('cod_condicion','{cod_nombre}','',array('cod_estado'=>1),$cotizacion[0]['cot_id_cod'],null,'cod_id',true);
        $data['condicionesPago'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $condicion_pago);
        $where_estado['est_estado'] = 1;
        $where_estado["est_id NOT IN($id_ganada, $id_perdida)"] = null;

        $data['estados'] = $this->gsatelite->get_dropdown('est_estado_cotizacion', 'est_nombre', '', $where_estado, $cotizacion[0]['cot_id_est'], '', 'est_id', true);
        $data['prorrateos'] = $this->gsatelite->get_dropdown('ptg_prorrateo_gasto', '{ptg_nombre}', 'prorrateos', array('ptg_estado' => 1), null, null, null, true);
        $data['areas'] = $this->gsatelite->get_dropdown('arf_area_factura', 'arf_nombre', '', array('arf_estado' => 1), $cotizacion[0]['cot_id_arf'], '', 'arf_id', true);
        $data['comisiones'] = $this->gsatelite->get_dropdown('tic_tipo_comision','{tic_nombre} ({tic_tasa})', '', array('tic_estado' => 1), $cotizacion[0]['cot_id_tic'], null, 'tic_id', true);

        //Se obtienen los proyectos
        $this->db->join('epr_estado_proyecto', 'epr_id = pcl_id_epr', 'inner');
        $proyectos = $this->gsatelite->get_tabla('pcl_proyecto_cliente', array('pcl_id_cli' => $cotizacion[0]['cot_id_cli'], 'pcl_estado' => 1, 'epr_cierre' => 0));
        $opciones = "<option></option>";
        if (count($proyectos) > 0) {
            foreach ($proyectos as $pcl) {
                $selected = '';
                if ($pcl['pcl_id'] == $cotizacion[0]['cot_id_pcl']) {
                    $selected = 'selected';
                }
                $nombre = $pcl['pcl_codigo'] . ' - ' . $pcl['pcl_nombre'];
                $opciones .= "<option value='" . $pcl['pcl_id'] . "' data-suc='" . $pcl['pcl_id_scl'] . "' $selected>" . $nombre . "</option>";
            }
        }
        $data['cot_estado'] =  $cotizacion[0]['cot_estado'];
        $data['proyecto'] = $opciones;
        $data['cantidad_decimales'] = $this->gsatelite->get_parametro('NUMERO_DECIMALES', 2);
        $data['ordenes_produccion'] = $this->gsatelite->count('ord_orden', array('ord_id_cot' => $cot_id));
        $data['anexos_doc'] = $this->gsatelite->get_tabla('axz_anexoxcotizacion', array('axz_id_cot' => $cot_id));

        $productos_cotizacion = $this->load->view('cotizaciones/cotizaciones/grid_cotizacion', $data, true);
        $data['productos_cotizacion'] = $productos_cotizacion;

        $productos_id = "";
        $cantidad_productos = "";
        $contador = 0;
        if (count($detalle_productos) > 0) {
            foreach ($detalle_productos as $key) {
                $id_art = $key['art_id'];
                $productos_id .= $id_art . ',';
                $cantidad_productos .= $contador . ',';
                $contador++;
            }
            $productos_id = substr($productos_id, 0, -1);
            $cantidad_productos = substr($cantidad_productos, 0, -1);
        }

        $data['productos_caracteristica'] = $productos_id;
        $data['cantidad_caracteristicas'] = $cantidad_productos;

        // Configuracion parametrizada para mostrar elementos en la vista
        $data["show_option"] = $this->gsatelite->get_parametro('SYS_ELEMENTOS_MOSTRAR_COT', '1,1');
        // Parametro para obtener los dias de validez de la cotizacion 
        $dias_validos = $this->gsatelite->get_parametro('SYS_DIAS_VALIDEZ_COTIZACION');
        $data["dias_validos"] = ($dias_validos > 0) ? $dias_validos : '';
        $data["ver"] = $ver;
        $tpg_contado = $this->gsatelite->get_parametro('SYS_CONFIGURACION_CORTE_CAJA', null, null, array('CONTADO'));
        $data["tpgXcliente"] = $data['datos_cliente']['tipo_pago'];
        $data["tpg_contado"] = ($tpg_contado) ? $tpg_contado : 0;
        $data["descarga_inv"] = $this->gsatelite->get_parametro('SYS_DESCARGA_INV');
        $data["titulo_personal"] = ($ver == 0) ? "Editar cotización" : "Ver cotización";

        if ($ver == 2) {
            $data['modal_cotizaciones'] = true;
            cargarvista_modal($data, null, "cotizaciones/cotizaciones/editar_cotizacion");
        } else {
            $data['modal_cotizaciones'] = false;
            $this->_cargarvista($data, null, "cotizaciones/cotizaciones/editar_cotizacion");
        }
    }

    public function anular_cotizacion($cotid = 0)
    {
        satelite_validar();
        // VALIDAR SI LA COTIZACION NO ES POR ORDEN DE PRODUCCION O FACTURA
        $ordprod = $this->gsatelite->get_tabla('ord_orden', array('ord_id_cot' => $cotid));
        $factura = $this->gsatelite->get_tabla('fac_factura', array('fac_id_cot' => $cotid));
        if (count($ordprod) > 0 || count($factura) > 0) {
            $this->gsatelite->show_dialog('No se procesará. Es referenciada por otro proceso.', 'cotizaciones/cotizaciones/index', 'error');
        } else {
            $this->gsatelite->actualizar_array('cot_cotizacion', array('cot_estado' => 0, 'cot_usu_modificacion' => $this->tank_auth->get_user_id(), 'cot_fecha_modificacion' => date('Y-m-d H:i:s')), array('cot_id' => $cotid));
            $this->gsatelite->show_dialog('Se procesó exitosamente.', 'cotizaciones/cotizaciones/index', 'success');
            /*$alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Cotización", 'texto_alerta' => "Ocurrio un problema al crear el registro.");
            }

            $this->session->set_flashdata($alerta);
            if ($tipo_btn == 1) {
                redirect('cotizaciones/cotizaciones/agregar_cotizacion/');
            } else {
                redirect('cotizaciones/cotizaciones/index/');*/
        }
    }

    public function get_nu_code_cot($fecha = null)
    {
        $fecha_pres = ($fecha) ? $fecha : $this->input->post('fecha_pres');
        $prefix = array('01' => 'ENE', '02' => 'FEB', '03' => 'MAR', '04' => 'ABR', '05' => 'MAY', '06' => 'JUN', '07' => 'JUL', '08' => 'AGO', '09' => 'SEP', '10' => 'OCT', '11' => 'NOV', '12' => 'DIC');
        $codigo =  ($this->gsatelite->count('cot_cotizacion') + 1);
        $mes = formatear_fecha("m", $fecha_pres);
        $anio = formatear_fecha("Y", $fecha_pres);
        $labelMes = $prefix[$mes];
        if ($codigo < 10) {
            $correlativoNew = "-000" . $codigo;
        } else if ($codigo < 100) {
            $correlativoNew = "-00" . $codigo;
        } else if ($codigo < 1000) {
            $correlativoNew = "-0" . $codigo;
        } else {
            $correlativoNew = "-" . $codigo;
        }
        $nu_codigo = $labelMes . $anio . $correlativoNew;
        echo $nu_codigo;
    }

    /**
     * @autor Habby Lovo
     * @since 31/01/2018
     *
     * @description : Nos obtiene la grid de componentes con los detalles.
     */
    public function obtener_componente_edit($producto, $correlativo, $axc_id, $cliente, $edit_cot = null)
    {
        $this->load->library('../controllers/facturacion/facturar');
        //$correlativo = ($this->input->post('correlativo') != '')?$this->input->post('correlativo'):null;
        //$producto = ($this->input->post('producto') != '')?$this->input->post('producto'):null;
        // lista de precio
        $id_tipl = 0;
        $data_grid['decimales'] = $this->gsatelite->get_parametro('NUMERO_DECIMALES', 2);
        $tipos_lista2 = $this->inventario_model->get_tipo_lista_precio(array('tpn_id_cli' => $cliente));
        $select_tipo_lista_cliente = "<option value=''></option>";
        foreach ($tipos_lista2 as $key => $value) {
            if ($key == 0) {
                $select_tipo_lista_cliente .= "<option data-tlp=" . $value["tlp_id"] . " value=" . $value["tlp_id"] . " selected>" . $value["tlp_nombre"] . "</option>";
                $id_tipl = $value["tlp_id"];
            } else {
                $select_tipo_lista_cliente .= "<option data-tlp=" . $value["tlp_id"] . " value=" . $value["tlp_id"] . ">" . $value["tlp_nombre"] . "</option>";
            }
        }
        //carga la grid de componentes
        $html = '';
        //if($correlativo != null && $correlativo >= 0){
        if ($correlativo > -1) {
            $data_grid['bodega_nombre'] = '';
            $data_grid['bodega_id'] = '';
            $data_grid['edit_cot'] = $edit_cot;

            $data_grid['ident'] = "_" . $producto . "_" . $correlativo;
            $data_grid['correlativo'] = $correlativo;
            $data_grid['producto'] = $producto;
            $data_grid['lista_id'] = $id_tipl;
            $data_grid['lista_cliente'] = $select_tipo_lista_cliente;
            $data_grid['productos'] = $this->gsatelite->get_tabla('art_articulo', array('art_componente' => 1, 'art_estado' => 1));
            $data_grid['componentes'] = $this->cotModel->get_componente_cotizacion(array('cdc_id_axc' => $axc_id));
            $html = $this->load->view('facturacion/facturar/grid_componentes', $data_grid, true);
        }

        echo $html;
    }

    function pipeline_ventas($state = null, $stateCot = null, $fecha_inicio = null, $fecha_fin = null, $vendedor = null, $cliente = null)
    {
        satelite_validar();
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        }

        // Handle pending quotations update if needed
        if ($state > 0) {
            $this->actualizar_cot_pendientes();
        }

        // Fetch quotation stages
        $where = array('etc_estado' => 1);
        $group_by = array('etc_id');
        $order_by = 'etc_id ASC';
        $data['etapas'] = $this->cotModel->get_etapas_cotizacion($where, $order_by, $group_by);

        // Fetch authorization settings and quotation states
        $autorizacion_estados_cot = (trim($this->gsatelite->get_parametro('SYS_AUTORIZA_ESTADO_COTIZACION_VENTA')) == 1) ? 1 : 0;
        $data['autorizacion_estados_cot'] = $autorizacion_estados_cot;

        $hay_campo = $this->db->query("SHOW COLUMNS FROM est_estado_cotizacion WHERE Field = 'est_vigente'")->result_array();
        if (count($hay_campo) > 0) {
            $vigente = $this->gsatelite->get_tabla('est_estado_cotizacion', array('est_estado' => 1, 'est_vigente' => 1));
            $ganada = $this->gsatelite->get_tabla('est_estado_cotizacion', array('est_estado' => 1, 'est_ganada' => 1));
            $perdida = $this->gsatelite->get_tabla('est_estado_cotizacion', array('est_estado' => 1, 'est_perdida' => 1));
            if (!(count($vigente) > 0 || count($ganada) > 0 || count($perdida) > 0)) {
                $this->gsatelite->show_dialog('Verificar el mantenimiento de Estados de la Cotización', 'cotizaciones/pipeline_ventas', 'error');
            }
            $estados_cot['VIGENTE'] = (count($vigente) > 0) ? implode(',', array_column($vigente, 'est_id')) : 0;
            $estados_cot['GANADA'] = (count($ganada) > 0) ? implode(',', array_column($ganada, 'est_id')) : 0;
            $estados_cot['PERDIDA'] = (count($perdida) > 0) ? implode(',', array_column($perdida, 'est_id')) : 0;
        } else {
            $estados_cot = trim($this->gsatelite->get_parametro('SYS_ESTADO_COTIZACION'));
            $estados_cot = ($estados_cot != '' && is_object(json_decode($estados_cot))) ? (array) json_decode($estados_cot) : null;
            if (!$estados_cot) {
                $this->gsatelite->show_dialog('Verificar la configuración de estados de la cotización', 'cotizaciones/pipeline_ventas', 'error');
            }
        }
        $data['estados_cot_auto'] = $estados_cot;

        // Handle filter defaults
        $fecha_pasada = ($fecha_inicio != null) ? formatear_fecha("Y-m-d", $fecha_inicio) : date("Y-m-01");
        $fecha_actual = ($fecha_fin != null) ? formatear_fecha("Y-m-d", $fecha_fin) : date("Y-m-t");
        $slcVendedor = ($vendedor != null) ? $vendedor : null;
        $chkCot = ($stateCot != null) ? $stateCot : 1;
        $slcCliente = ($cliente != null) ? $cliente : null;
        $data['est_id'] = ($state != null) ? $state : null;

        // Fetch vendedores for filter
        $user = $this->tank_auth->get_user_id();
        $user_admin = $this->db->select('id')->from('users')->where('username like', '%admin%')->get()->row_array();
        $admin = $user_admin['id'];
        $esSup = $this->cotModel->Existe_Registro("sup_supervisor", array('sup_id_usu' => $user, 'sup_estado' => 1));
        $esVen = $this->cotModel->Existe_Registro("ven_vendedor", array('ven_id_usu' => $user, 'ven_estado' => 1));

        $vendedores = '';
        $verificar_ven = 0;
        if ($esSup > 0) {
            $verificar_ven = 0;
            $filaSup = $this->cotModel->get_registro("sup_supervisor", "sup_id_usu", $user);
            $data['nombreSupervisor'] = $filaSup->sup_nombre . " " . $filaSup->sup_apellido;
            $this->db->join('ven_vendedor', 'ven_id = vxs_id_ven', 'inner');
            $vendedores = $this->gsatelite->get_tabla('vxs_vendedorxsupervisor', array('vxs_id_sup' => $filaSup->sup_id));
        } elseif ($esVen > 0) {
            $verificar_ven = 1;
            $filaVen = $this->cotModel->get_registro("ven_vendedor", "ven_id_usu", $user);
            $data["NombreVendedor"] = $filaVen->ven_nombre . " " . $filaVen->ven_apellidos;
            $vendedores = $this->gsatelite->get_tabla('ven_vendedor', array('ven_id_usu' => $user, 'ven_estado' => 1));
        }
        $html = '<option value=""></option>';
        $selected = ($verificar_ven > 0) ? 'selected' : '';
        foreach ($vendedores as $valor) {
            $html .= '<option value="' . $valor['ven_id'] . '" ' . ($slcVendedor == $valor['ven_id'] ? 'selected' : '') . '>' . $valor['ven_codigo'] . ' - ' . $valor['ven_nombre'] . ' ' . $valor['ven_apellidos'] . '</option>';
        }
        $data['vendedores'] = $html;

        
        /*$this->db->join('cot_cotizacion', 'cot_id_cli = cli_id', 'inner');
        $this->db->where('cot_estado', 1);
        $this->db->group_by('cli_id');
        $data['clientes'] = $this->gsatelite->get_tabla('cli_cliente', array('cli_estado' => 1));*/

        
        $data['estados'] = $this->gsatelite->get_tabla('est_estado_cotizacion', array('est_estado' => 1));

        
        $data['titulo_personal'] = 'Pipeline Ventas';
        $data['fecha_pasada'] = $fecha_pasada;
        $data['fecha_actual'] = $fecha_actual;
        $data['est_cot_chk'] = $chkCot;
        $data['slcVendedor'] = $slcVendedor;
        $data['slcCliente'] = $slcCliente;
        $data['ndias_parametro'] = $this->gsatelite->get_parametro('SYS_COT_DIAS_SEGUIMIENTO', 30);

        $this->_cargarvista($data);
    }

    function consultar_pipeline()
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        }

        $post_array = $this->input->post();
        $state = $post_array['estado'] ?? null;
        $estado_cotizacion = $post_array['estado_cotizacion'] ?? null;
        $fecha_pasada = $post_array['fecha_inicio'] ? formatear_fecha('Y-m-d', $post_array['fecha_inicio']) : date("Y-m-01");
        $fecha_actual = $post_array['fecha_fin'] ? formatear_fecha('Y-m-d', $post_array['fecha_fin']) : date("Y-m-t");
        $slcVendedor = $post_array['vendedor'] ?? null;
        $chkCot = $post_array['chkCot'] ?? 1;
        $slcCliente = $post_array['cliente'] ?? null;

        // Fetch quotation stages
        $where = array('etc_estado' => 1);
        $group_by = array('etc_id');
        $order_by = 'etc_id ASC';
        $data['etapas'] = $this->cotModel->get_etapas_cotizacion($where, $order_by, $group_by);


        // Apply role-based filters
        $user = $this->tank_auth->get_user_id();
        $user_admin = $this->db->select('id')->from('users')->where('username like', '%admin%')->get()->row_array();
        $admin = $user_admin['id'];
        $esSup = $this->cotModel->Existe_Registro("sup_supervisor", array('sup_id_usu' => $user, 'sup_estado' => 1));
        $esVen = $this->cotModel->Existe_Registro("ven_vendedor", array('ven_id_usu' => $user, 'ven_estado' => 1));

        $where["cot_id_etc IS NOT NULL"] = null;
        if ($esSup > 0 && $user != $admin) {
            $queryIdCot = $this->cotModel->get_idsCotizacionesxSupervisor($user);
            $mis_cots = $this->gsatelite->get_tabla('ven_vendedor', array('ven_estado' => 1, 'ven_id_usu' => $user));
            if (count($mis_cots) > 0) {
                $cots_mias = implode(',', array_column($mis_cots, 'cot_id'));
                $queryIdCot .= ',' . $cots_mias;
            }
            $where["cot_id IN"] = "($queryIdCot)";
        } elseif ($esVen > 0 && $user != $admin) {
            $queryIdCot = $this->cotModel->get_idsCotizacionesxVendedor($user);
            $where["cot_id IN"] = "($queryIdCot)";
        } elseif ($user != $admin) {
            $where["cot_id IN"] = "(0)";
        }

        
        $where = array('cot_estado' => $chkCot);
        if ($state > 0) {
            $where['cot_id_est'] = $state;
        }
        if ($slcVendedor > 0) {
            $where['cot_id_ven'] = $slcVendedor;
        }
        if ($slcCliente > 0) {
            $where['cot_id_cli'] = $slcCliente;
        }

        if ($estado_cotizacion) {
            if ($estado_cotizacion === 'ganada') {
                
                $where['cog_id_cot IS NOT NULL'] = null;
            } elseif ($estado_cotizacion === 'perdida') {
                
                $where['per_id_cot IS NOT NULL'] = null;
            }
        }
        $where["DATE(cot_fecha_pres) >="] = $fecha_pasada;
        $where["DATE(cot_fecha_pres) <="] = $fecha_actual;

        $order_by = 'cot_fecha_pres DESC';
        $group_by = 'cot_id';
        $data['cotizaciones'] = $this->cotModel->get_data_cotizaciones($where, $order_by, $group_by);

        if ($this->input->post('json')) {
            $cotizaciones = [];
            foreach ($data['cotizaciones'] as $cot) {
                $cotizaciones[] = [
                    'cot_id' => $cot['cot_id'],
                    'cot_codigo' => $cot['cot_codigo'],
                    'cot_concepto' => $cot['cot_concepto'],
                    'cot_total' => $cot['cot_total'],
                    'cot_id_est' => $cot['cot_id_est'],
                    'cot_id_etc' => $cot['cot_id_etc'],
                    'cot_fecha_pres' => DateTime::createFromFormat('Y-m-d H:i:s', $cot['cot_fecha_pres'])->format('d/m/Y H:i'),
                    'cli_nombre' => ($cot['cli_personeria'] == 1) ? $cot['cli_codigo'].'-'.$cot['nombre'].' '.$cot['cli_apellido'] : $cot['cli_codigo'].'-'.$cot['cli_apellido'],
                    'ven_nombre' => $cot['ven_nombre']." " .$cot['ven_apellidos'],
                    'foto_vendedor' => $cot['foto_vendedor'],
                    'existe_foto_vendedor' => ($cot['foto_vendedor'] != "" && file_exists($cot['foto_vendedor'])) ? 1: 0,
                    'emp_color_icono' => $cot['emp_color_icono'],
                    'flag_ganada' => ($cot['cog_id_cot'] !== null) ? 1 : 0,
                    'flag_perdida' => ($cot['per_id_cot'] !== null) ? 1 : 0
                ];
            }
            $response = [
                'etapas' => $data['etapas'],
                'cotizaciones' => $cotizaciones
            ];
            echo json_encode($response);
        } else {
            //$data['titulo_personal'] = 'Pipeline Ventas';
            //$this->load->view('cotizaciones/consultar_pipeline', $data);
        }
    }

    function verificar_opciones_cotizacion()
    {
        if (!$this->tank_auth->is_logged_in()) {
            echo json_encode(['success' => false, 'message' => 'Error al obtener informacion']);
            return;
        }

        $cot_id = $this->input->post('cot_id');
        if ($cot_id > 0) {
            $es_ganada = $this->db->select('COUNT(*) as count')
                            ->from('cog_cotiz_ganada')
                            ->where('cog_id_cot', $cot_id)
                            ->get()->row()->count > 0;
            $es_perdida = $this->db->select('COUNT(*) as count')
                            ->from('per_perdido')
                            ->where('per_id_cot', $cot_id)
                            ->get()->row()->count > 0;

            echo json_encode(['success' => true, 'es_ganada' => $es_ganada, 'es_perdida' => $es_perdida]);
        } else {
            echo json_encode(['success' => false, 'message' => 'Id de cotización invalido']);
        }

    }


    function registrar_seguimiento_cotizacion()
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        }

        $cot_id = $this->input->post('cotizacion');
        $etapa = $this->input->post('etapa');

        if ($cot_id > 0 && $etapa > 0) {
            $array_cot = array(
                'cot_id_etc' => $etapa,
                'cot_usu_modificacion' => $this->tank_auth->get_user_id(),
                'cot_fecha_modificacion' => date('Y-m-d H:i:s')
            );

            $consulta_cot = $this->gsatelite->actualizar_array("cot_cotizacion", $array_cot, array('cot_id' => $cot_id));
            echo json_encode(['success' => true]);
        } else {
            echo json_encode(['success' => false, 'message' => 'Invalid data']);
        }
    }

    function detalle_pipeline_ventas($cot_id = null)
    {
        satelite_validar();
        if ($_POST) {
            $cot_id = $this->input->post('cotizacion');
        }

        $where = array('cot_id' => $cot_id);
        $cotizacion = $this->cotModel->get_data_cotizaciones($where);

        $data['cotizacion'] = $cotizacion;
        
        $data['id_cotizacion']  =  $cot_id;

        $html = $this->load->view('cotizaciones/cotizaciones/detalle_pipeline_ventas', $data, true);

        
        echo $html;
    }

    /**
     * @autor René Castaneda
     * @since 21/05/2014
     *
     * @description : Es una función a la cual acceso desde la vista cotizaciones mediante ajax e imprimo
     * un select con los clientes según el vendedor seleccionado.
     */
    function select_clientes_ajax()
    {

        $id_vendedor = $this->input->post('id_vendedor');
        $Condiciones = array('cli_estado' => 1);
        $datosCliente = $this->cotModel->get_tabla2('cli_cliente', $Condiciones, 'cli_id', 'ASC');


        /* $script  = "<script>";
          $script .= "$(\"SELECT[id='field-cot_id_cli']\").select2();";
          $script .= "jQuery('#field-cot_id_cli').change(function(){ ";
          $script .= "var id_cli = this.value;
          if (this.value != \"\" ){
          realizaProcesoSelectContactos(id_cli);
          }" ;

          $script .= " } ) ;";
          $script .= "</script>"; */


        //$selectCli = '<select id="field-cot_id_cli" class="nostyle chosen-select" style="width: 100%;" data-placeholder="Select Cliente" name="cot_id_cli" ><option value=""></option>';
        $selectCli = "<option value=''></option>";
        foreach ($datosCliente->result() as $fila) {
            $selectCli .= '<option value="' . $fila->cli_id . '">' . $fila->cli_nombre . " " . $fila->cli_apellido . '</option>';
        }
        $arreglo = array('drop' => $selectCli);
        echo json_encode($arreglo);

        //$this->load->view("cotizaciones/cotizaciones/select_clientes",$datos);
    }

    /**
     * @autor René Castaneda
     * @since 21/05/2014
     *
     * @description : Es una función a la cual acceso desde la vista cotizaciones mediante ajax e imprimo
     * un multiselect con los contactos según el cliente seleccionado.
     */
    function multiselect_contactos_ajax()
    {
        $id_cliente = $this->input->post('id_cliente');
        $reg = $this->gsatelite->get_registro('cli_cliente', 'cli_id', $id_cliente);
        $personeria = ($reg->cli_personeria == 1) ? 'Natural' : 'Jurídica';
        $Condiciones = array('con_id_cli' => $id_cliente, 'con_estado' => 1);
        $datosContactos = $this->cotModel->get_tabla2('con_contacto', $Condiciones, 'con_id', 'ASC');

        /* $script  = "<script>";
          $script .= "$(\"SELECT[id='field-contactos']\").select2();";
          $script .= "</script>"; */


        //$selectCon = '<select id="field-contactos" class="chosen-multiple-select" style="width: 100%;" data-placeholder="Select Contactos de Cotización" size="8" multiple="multiple" name="contactos[]"><option value=""></option>';
        $selectCon = "<option value=''></option>";
        foreach ($datosContactos->result() as $fila) {
            $selectCon .= '<option value="' . $fila->con_id . '">' . $fila->con_nombre . " " . $fila->con_apellidos . " - " . $fila->con_cargo . '</option>';
        }

        $arreglo = array('drop' => $selectCon, 'personeria' => $personeria);
        echo json_encode($arreglo);
    }

    /**
     * @autor René Castaneda
     * @since 21/05/2014
     *
     * @description : MANTENIMIENTO DE LA TABLA cot_cotizacion filtrado por cliente
     * @description : Es un crud que mostrará el listado de cotizaciones segun el cliente haciendo un filtro según sea el usuario (supervisor o vendedor)
     * si es supervisor mostrará todas las cotizaciones de los vendedores asignados y
     * se agrego una columna dias para mostrar cuantos dias han pasado después de la ultima fecha de contacto
     */
    function cotizacion_cliente($id_cliente = 0)
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {

            try {

                //preguntar por el registro del cliente
                $filaCliente = $this->cotModel->get_registro('cli_cliente', 'cli_id', $id_cliente); //obtener registro de sector
                //preguntar si es supervisor o vendedor
                $condicion1 = array('sup_id_usu' => $this->tank_auth->get_user_id(), 'sup_estado' => 1);
                $esSup = $this->cotModel->Existe_Registro("sup_supervisor", $condicion1);
                $condicion2 = array('ven_id_usu' => $this->tank_auth->get_user_id(), 'ven_estado' => 1);
                $esVen = $this->cotModel->Existe_Registro("ven_vendedor", $condicion2);



                $query = $this->cotModel->get_idsContactosxCliente($id_cliente);
                ///SE AGREGÓ UNA COLUMNA LLAMADA DIAS PARA QUE MOSTRAR LA DIFERENCIA DE DIAS QUE EXISTE
                //ENTRE COT_FECHA_PRES COT_ULT_FECHA_CONT
                $crud = new grocery_CRUD();
                $crud->set_table('cot_cotizacion');
                $crud->set_subject('Cotizaciones');
                $crud->columns('cot_id', 'cot_id_cli', 'cot_id_pro', 'cot_concepto', 'dias', 'cot_id_est');
                $crud->where('cot_id_cli', $id_cliente);
                $crud->display_as('cot_id', 'C&oacute;digo');
                $crud->display_as('cot_id_cli', 'Cliente');
                $crud->display_as('cot_id_pro', 'Producto');
                $crud->display_as('cot_concepto', 'Descripción');
                $crud->display_as('dias', 'Dias');
                $crud->display_as('cot_id_est', '<span id=estCot >Estado Cotizaci&oacute;n</span>');
                $crud->display_as('cot_id_ven', 'Vendedor');
                $crud->display_as('cot_concepto', 'Concepto');
                $crud->display_as('cot_valor_cot_iva', 'Valor Cotizado IVA');
                $crud->display_as('cot_valor_cot_neto', 'Valor Cotizado Neto');
                $crud->display_as('cot_fecha_pres', 'Fecha Presentaci&oacute;n');
                $crud->display_as('cot_id_tic', '<span id=tipCom >Tipo Comisi&oacute;n</span>');
                $crud->display_as('cot_id_etp', '<span id=Etp >Etapa</span>');
                $crud->display_as('cot_url_internet', 'Direcci&oacute;n de Internet');
                $crud->display_as('cot_comentario', 'Comentarios');
                $crud->display_as('cot_concepto', 'Concepto');
                $crud->display_as('contactos', '<span id=contactosCot >Contactos de Cotización</span>');
                $crud->add_action('Seguimiento', '', 'cotizaciones/cotizaciones/seguimiento_cotizacion', 'icomoon-icon-stack');
                $crud->add_action('Anexos', '', 'cotizaciones/cotizaciones/anexos_cotizacion', 'icomoon-icon-stack');

                //->display_as('cot_estado', 'Estado')
                $crud->add_fields('cot_id_ven', 'cot_id_cli', 'cot_id_pro', 'cot_concepto', 'cot_valor_cot_iva', 'cot_valor_cot_neto', 'cot_fecha_pres', 'cot_id_tic', 'cot_id_est', 'cot_id_etp', 'cot_fecha', 'cot_url_internet', 'cot_ult_fecha_cont', 'cot_comentario', 'contactos', 'cot_usu_mod', 'cot_fecha_mod');
                $crud->edit_fields('cot_id_ven', 'cot_id_cli', 'cot_id_pro', 'cot_concepto', 'cot_valor_cot_iva', 'cot_valor_cot_neto', 'cot_fecha_pres', 'cot_id_tic', 'cot_id_est', 'cot_id_etp', 'cot_url_internet', 'cot_comentario', 'contactos', 'cot_usu_mod', 'cot_fecha_mod');
                $crud->required_fields('cot_id_cli', 'cot_id_ven', 'cot_id_pro', 'cot_concepto', 'cot_valor_cot_iva', 'cot_valor_cot_neto', 'cot_fecha_pres', 'cot_id_tic', 'cot_id_est', 'cot_id_etp', 'contactos', 'cot_usu_mod', 'cot_fecha_mod');
                $crud->set_relation('cot_id_cli', 'cli_cliente', 'cli_nombre', array('cli_estado' => 1));
                $crud->set_relation('cot_id_pro', 'pro_producto', 'pro_nombre', array('pro_estado' => 1));

                //preguntar si es usuario supervisor o vendedor y hacer los respectivos filtros

                if ($esSup > 0) {
                    //                   	$queryIdVen = $this->cotModel->get_idsVendedoresxSupervisor($this->tank_auth->get_user_id()) ;
                    $queryIdCot = $this->cotModel->get_idsCotizacionesxSupervisor($this->tank_auth->get_user_id());



                    //	$crud->set_relation('cot_id_ven','ven_vendedor','{ven_nombre} {ven_apellidos}', "ven_id in ( {$queryIdVen} )");
                    $crud->set_relation('cot_id_ven', 'ven_vendedor', '{ven_nombre} {ven_apellidos}', array('ven_id' => $filaCliente->cli_id_ven));
                    $crud->where("cot_id in ( {$queryIdCot} )");
                    $crud->add_action('Ganada-Perdida', '', 'cotizaciones/cotizaciones/cotizacion_ganada_perdida', 'icomoon-icon-stack');

                    $filaVen = $this->cotModel->get_registro("ven_vendedor", "ven_id", $filaCliente->cli_id_ven);
                    $id_Ven = $filaVen->ven_id;
                    $nombreVendedor = $filaVen->ven_nombre . " " . $filaVen->ven_apellidos;

                    $crud->field_type('cot_id_ven', 'hidden', $id_Ven);
                    $datos["NombreVendedor"] = $nombreVendedor;
                } else if ($esVen > 0) {
                    $queryIdCot = $this->cotModel->get_idsCotizacionesxVendedor($this->tank_auth->get_user_id());
                    $crud->where("cot_id in ( {$queryIdCot} )");
                    $crud->set_relation('cot_id_ven', 'ven_vendedor', '{ven_nombre} {ven_apellidos}', array('ven_id' => $filaCliente->cli_id_ven));
                    $filaVen = $this->cotModel->get_registro("ven_vendedor", "ven_id", $filaCliente->cli_id_ven);
                    $id_Ven = $filaVen->ven_id;
                    $nombreVendedor = $filaVen->ven_nombre . " " . $filaVen->ven_apellidos;

                    $crud->field_type('cot_id_ven', 'hidden', $id_Ven);
                    $datos["NombreVendedor"] = $nombreVendedor;

                    //$crud->add_action('Perdida', '', 'cotizaciones/cotizaciones/cotizacion_ganada_perdida','icomoon-icon-stack');
                    $crud->add_action('Ganada-Perdida', '', 'cotizaciones/cotizaciones/cotizacion_ganada_perdida', 'icomoon-icon-stack');
                } else {
                    $queryIdCot = "0";
                    $crud->set_relation('cot_id_ven', 'ven_vendedor', '{ven_nombre} {ven_apellidos}', array('ven_estado' => 1, 'ven_id_usu' => $this->tank_auth->get_user_id()));
                    $crud->where("cot_id in ( {$queryIdCot} )");
                    $crud->unset_add();
                }


                $crud->set_relation('cot_id_est', 'est_estado_cotizacion', 'est_nombre')
                    ->set_relation('cot_id_tic', 'tic_tipo_comision', 'tic_nombre', array('tic_estado' => 1))
                    ->set_relation('cot_id_etp', 'etp_etapa', 'etp_nombre', array('etp_estado' => 1))



                    //->field_type('cot_estado','dropdown',array('1' => 'Activado', '0' => 'Desactivado'))
                    ->field_type('cot_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('cot_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                    ->field_type('cot_ult_fecha_cont', 'hidden', date('Y-m-d H:i:s'))
                    ->field_type('cot_fecha', 'hidden', date('Y-m-d H:i:s'))
                    ->field_type('cot_fecha_pres', 'date', date('Y-m-d'))
                    ->field_type('cot_id_cli', 'hidden', $id_cliente)
                    ->field_type('cxt_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('cxt_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                    ->set_relation_n_n('contactos', 'cxt_contactoxcotizacion', 'con_contacto', 'cxt_id_cot', 'cxt_id_con', '{con_nombre} {con_apellidos} - {con_cargo}', NULL, "con_id in ( {$query} )")
                    ->callback_before_insert(function ($post_array, $primary_key) {
                        //VERIFICAR SI LA FECHA DE PRESENTACION NO SEA MAYOR A LA ACTUAL
                        $hoy = date('Y-m-d H:i:s');
                        $datetime1 = new DateTime($post_array['cot_fecha_pres']); //fecha de presentación
                        $datetime2 = new DateTime($hoy); //fecha actual

                        if ($datetime1 <= $datetime2) {
                            return TRUE;
                        } else {
                            return FALSE;
                        }
                    })
                    ->callback_before_update(function ($post_array, $primary_key) {

                        $esganada = $this->cotModel->Existe_Registro("cog_cotiz_ganada", array('cog_id_cot' => $primary_key));
                        $esperdida = $this->cotModel->Existe_Registro("per_perdido", array('per_id_cot' => $primary_key));

                        if ($esganada > 0) {
                            $esganada_perdida = 1;
                        } else if ($esperdida > 0) {
                            $esganada_perdida = 1;
                        } else {
                            $esganada_perdida = 0;
                        }


                        //VERIFICAR SI LA FECHA DE PRESENTACION NO SEA MAYOR A LA ACTUAL
                        $hoy = date('Y-m-d H:i:s');
                        $datetime1 = new DateTime($post_array['cot_fecha_pres']); //fecha de presentación
                        $datetime2 = new DateTime($hoy); //fecha actual


                        if ($datetime1 <= $datetime2 and $esganada_perdida == 0) {
                            return TRUE;
                        } else {
                            return FALSE;
                        }
                    })
                    ->callback_after_insert(function ($post_array, $primary_key) {

                        //DESPUES DE QUE SE HAYA REALIZADO LA INSERCCION DEL REGISTRO
                        //SE DEBERAN ACTUALIZAR LOS CAMPOS cxt_usu_mod y cxt_fecha_mod que estan vacios (NULL)
                        $datosAuditoria = array(
                            'cxt_usu_mod' => $this->tank_auth->get_user_id(),
                            'cxt_fecha_mod' => date('Y-m-d H:i:s')
                        );
                        $this->cotModel->update_registros('cxt_contactoxcotizacion', $datosAuditoria, 'cxt_id_cot', $primary_key);
                        return TRUE;
                    })
                    ->callback_after_update(function ($post_array, $primary_key) {

                        //DESPUES DE QUE SE HAYA REALIZADO LA ACTUALIZACION DEL REGISTRO
                        //SE DEBERAN ACTUALIZAR LOS CAMPOS cxt_usu_mod y cxt_fecha_mod que estan vacios (NULL)
                        $datosAuditoria = array(
                            'cxt_usu_mod' => $this->tank_auth->get_user_id(),
                            'cxt_fecha_mod' => date('Y-m-d H:i:s')
                        );
                        $this->cotModel->update_registros('cxt_contactoxcotizacion', $datosAuditoria, 'cxt_id_cot', $primary_key);
                        return TRUE;
                    })
                    ->set_lang_string('update_error', 'Error!\nFavor Verificar lo Siguiente:\n\n*La fecha de presentación no debe ser mayor a la fecha actual.\n*Si ya se declaro como cotización ganada o perdida ya no se puede editar. ')
                    ->set_lang_string('insert_error', 'Error!\nFavor Verificar lo Siguiente:\n\n*La fecha de presentación no debe ser mayor a la fecha actual.')
                    ->callback_column('dias', function ($value, $row) {
                        $getIdEst = $this->gsatelite->get_tabla('cot_cotizacion', array('cot_id' => $row->cot_id));
                        $getColor = $this->gsatelite->get_tabla('est_estado_cotizacion', array('est_id' => $row->cot_id_est));
                        $getColor = $getColor[0]['est_color_indicador'] != "" ? $getColor[0]['est_color_indicador'] : "";
                        //preguntar por el estado de la cotizacion y saber si se le debe dar o no seguimiento
                        $seguir = $this->gsatelite->get_campo('est_estado_cotizacion', 'est_seguimiento', array('est_id' => $row->cot_id_est));
                        if ($seguir > 0) {
                            $date1 = date('Y-m-d H:i:s');
                            $date2 = $row->cot_ult_fecha_cont; //ultima fecha de contacto

                            $dias = (strtotime($date1) - strtotime($date2)) / 86400;
                            $ndias = floor($dias);

                            if ($ndias < 1) {
                                return "0";
                            } else {
                                return $ndias;
                            }
                        } else { //si el estado en que se encuentra no es de seguimiento retornar cero
                            return "0";
                        }
                    })
                    ->unset_delete();

                $output = $crud->render();


                $datos['datos_cliente'] = $filaCliente;
                $datos["titulo_personal"] = "Cotizaciones - Cliente";
                $this->_cargarvista($datos, $output);
            } catch (Exception $e) {
                show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
            }
        }
    }

    /**
     * Cotizaciones::seguimiento_cotizacion()
     * @param integer $id_cotizacion
     * @return MANTENIMIENTO DE LA TABLA seg_seguimiento
     */
    function seguimiento_cotizacion($id_cotizacion = 0)
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            try {
                $estado_cotizacion = $this->cotModel->cotizacionGanadaPerdida($id_cotizacion);
                $filaCotizacion = $this->cotModel->get_registro('cot_cotizacion', 'cot_id', $id_cotizacion);
                $crud = new grocery_CRUD();
                $crud->set_table('seg_seguimiento');
                $crud->set_subject('Seguimiento de cotizaci&oacute;n');
                $crud->where('seg_id_cot', $id_cotizacion);
                $crud->columns(
                    'seg_id_tsg',
                    'seg_id_con',
                    'e_mail',
                    'telefono',
                    'seg_fecha',
                    'seg_comentario',
                    'seg_fecha_proximo'
                );
                $crud->add_fields(
                    'seg_id_cot',
                    'seg_id_con',
                    'seg_fecha',
                    'seg_comentario',
                    'seg_fecha_proximo',
                    'seg_id_tsg',
                    'seg_lugar',
                    'seg_invitados',
                    'seg_usu_mod',
                    'seg_fecha_mod',
                    'seg_fecha_crea',
                    'seg_usu_crea'
                );
                $crud->edit_fields(
                    'seg_id_cot',
                    'seg_id_con',
                    'seg_comentario',
                    'seg_fecha_proximo',
                    'seg_id_tsg',
                    'seg_usu_mod',
                    'seg_fecha_mod',
                    'seg_lugar',
                    'seg_invitados'
                );
                $crud->required_fields('seg_id_cot', 'seg_id_con', 'seg_id_tsg', 'seg_fecha', 'seg_comentario', 'seg_fecha_proximo', 'seg_usu_mod', 'seg_fecha_mod');
                $crud->display_as('seg_id_cot', 'Cotización');
                $crud->display_as('seg_id_con', 'Contacto');
                $crud->display_as('e_mail', 'E-mail Contacto');
                $crud->display_as('telefono', ' Teléfono Contacto');
                $crud->display_as('seg_fecha', 'Fecha Seguimiento');
                $crud->display_as('seg_comentario', 'Comentario');
                $crud->display_as('seg_fecha_proximo', 'Pr&oacute;ximo Seguimiento');
                $crud->display_as('seg_id_tsg', 'Tipo Seguimiento');
                $crud->display_as('seg_lugar', 'Lugar');
                $crud->display_as('seg_invitados', 'Asistentes de Seguimiento');
                $crud->set_relation('seg_id_cot', 'cot_cotizacion', 'cot_concepto');
                $crud->set_relation('seg_id_tsg', 'tsg_tipo_seguimiento', 'tsg_nombre', array('tsg_estado' => 1));
                $crud->set_relation('seg_id_con', 'con_contacto', '{con_titulo_profesion} {con_nombre} {con_apellidos} - {con_cargo}', array('con_estado' => 1, 'con_id_cli' => $filaCotizacion->cot_id_cli));
                $crud->field_type('seg_usu_mod', 'hidden', $this->tank_auth->get_user_id());
                $crud->field_type('seg_fecha_mod', 'hidden', date('Y-m-d H:i:s'));
                $crud->field_type('seg_fecha_crea', 'hidden', date('Y-m-d H:i:s'));
                $crud->field_type('seg_usu_crea', 'hidden', $this->tank_auth->get_user_id());
                $crud->field_type('seg_id_cot', 'hidden', $id_cotizacion);
                $crud->callback_column('telefono', function ($value, $row) {
                    $CI = &get_instance();
                    $telefono = $CI->gsatelite->get_campo('con_contacto', 'con_telefono', array('con_id' => $row->seg_id_con));
                    return '<label>' . $telefono . '</label>';
                })
                    ->callback_column('e_mail', function ($value, $row) {
                        $CI = &get_instance();
                        $e_mail = $CI->gsatelite->get_campo('con_contacto', 'con_email', array('con_id' => $row->seg_id_con));
                        return '<label>' . $e_mail . '</label>';
                    })
                    ->callback_column('seg_comentario', function ($value, $row) {
                        return '<span>' . $value . '</span>';
                    })
                    ->callback_column('seg_fecha', function ($value, $row) {
                        return '<span style="display: none;">' . formatear_fecha('Ymd', $row->seg_fecha) . '</span>' . formatear_fecha('d-m-Y', $row->seg_fecha);
                    })
                    ->callback_column('seg_fecha_proximo', function ($value, $row) {
                        return '<span style="display: none;">' . formatear_fecha('Ymd', $row->seg_fecha_proximo) . '</span>' . formatear_fecha('d-m-Y', $row->seg_fecha_proximo);
                    })
                    ->callback_add_field('seg_fecha', function () {
                        return '<input type="text" id="field-seg_fecha" readonly name="seg_fecha">';
                    })
                    ->callback_add_field('seg_fecha_proximo', function () {
                        return '<input type="text" id="field-seg_fecha_proximo" name="seg_fecha_proximo" autocomplete="off" class="datePicker">';
                    })
                    ->callback_edit_field('seg_fecha_proximo', function ($value, $row) {
                        return '<input type="text" id="field-seg_fecha_proximo" name="seg_fecha_proximo" value="' . formatear_fecha('d-m-Y', $value) . '" class="datePicker" autocomplete="off">';
                    })
                    ->callback_before_insert(function ($post_array) {
                        $datetime1 = date('Y-m-d');
                        $datetime2 = date('Y-m-d', strtotime($post_array['seg_fecha_proximo']));
                        $post_array['seg_fecha'] = formatear_fecha('Y-m-d', $post_array['seg_fecha']);
                        $post_array['seg_fecha_proximo'] = formatear_fecha('Y-m-d', $post_array['seg_fecha_proximo']);
                        if ($datetime1 <= $datetime2) {
                            return $post_array;
                        } else {
                            return FALSE;
                        }
                    })
                    ->callback_after_insert(function ($post_array, $primary_key) {
                        //REALIZAR LA ACTUALIZACIÓN PARA EL REGISTRO DE LA COTIZACION, ACTUALIZAR EL CAMPO cot_ult_fecha_cont
                        if ($this->cotModel->actualizarCampo('cot_cotizacion', 'cot_id', $post_array['seg_id_cot'], 'cot_ult_fecha_cont', $post_array['seg_fecha'])) {
                            return true;
                        } else {
                            return true;
                        }
                    })
                    ->callback_before_update(function ($post_array, $primary_key) {
                        $datetime1 = date('Y-m-d');
                        $datetime2 = date('Y-m-d', strtotime($post_array['seg_fecha_proximo']));
                        $post_array['seg_fecha_proximo'] = formatear_fecha('Y-m-d', $post_array['seg_fecha_proximo']);
                        // var_dump($post_array);die();
                        if ($datetime1 <= $datetime2) {
                            return $post_array;
                        } else {
                            return FALSE;
                        }
                    })
                    ->set_lang_string('update_error', 'La fecha del próximo seguimiento no puede ser menor a la actual')
                    ->set_lang_string('insert_error', 'La fecha del próximo seguimiento no puede ser menor a la actual')
                    ->unset_delete();
                ///$estado_cotizacion[0] == 1 ||  AHORA SOLO VA A AIMPEDIR LLENAR SEGUIMIENTO SI ES PERDIDA
                if ($estado_cotizacion[0] == 2) {
                    $crud->unset_add();
                    $crud->unset_edit();
                    $crud->unset_delete();
                }
                $datos['datos_cotizacion'] = $filaCotizacion;
                $datos['datos_cliente'] = $this->cotModel->get_registro('cli_cliente', 'cli_id', $filaCotizacion->cot_id_cli); //obtener registro
                $datos['titulo_personal'] = "Seguimiento  de Cotizaci&oacute;n";
                $output = $crud->render();
                $modal = $this->uri->segment(7);
                if ($modal == false) {
                    $this->_cargarvista($datos, $output);
                } else {
                    $datos['modal_cotizaciones'] = true;
                    cargarvista_modal($datos, $output);
                }
            } catch (Exception $e) {
                show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
            }
        }
    }

    /**
     * @autor Raul E.
     * @since feb/2021
     * @description: Agregar fechas aproximadas para las etapas o entregas de una cotizacion
     */
    public function entregables_cot($cot_id = 0)
    {
        satelite_validar();
        $registros = $this->gsatelite->get_tabla('ent_entregable_cotizacion', array('ent_estado' => 1, 'ent_id_cot' => $cot_id));
        if ($_POST) {
            $exitos = 0;
            $ids_entrega = $this->input->post('ids_ent');
            $entregables = $this->input->post('numero_entregable');
            $nom_entrega = $this->input->post('nombre_entregable');
            $descrip_ent = $this->input->post('descript_entregas');
            $dias_entreg = $this->input->post('dias_entregable');
            $fecha_entre = $this->input->post('fecha_entregable');
            $redireccion = $this->input->post('btnCrear');
            //Inactivar / eliminar los que no van
            $act_ids = array_column($registros, 'ent_id');
            foreach ($act_ids as $key => $val) {
                if (!(in_array($val, $ids_entrega))) {
                    $inactivar = array('ent_estado' => 0, 'ent_usu_modificacion' => $this->tank_auth->get_user_id(), 'ent_fecha_modificacion' => date('Y-m-d H:i:s'));
                    $id = $this->gsatelite->actualizar_array('ent_entregable_cotizacion', $inactivar, array('ent_id' => $val));
                }
            }
            if (count($ids_entrega) > 0) {
                foreach ($ids_entrega as $k => $value) {
                    $datos = array(
                        'ent_id_cot' => $cot_id,
                        'ent_numero_entregable' => $entregables[$k],
                        'ent_nombre' => $nom_entrega[$k],
                        'ent_dias_entregable' => $dias_entreg[$k],
                        'ent_fecha_aproximada' => formatear_fecha('Y-m-d', $fecha_entre[$k]),
                        'ent_descripcion' => ($descrip_ent[$k] != "") ? $descrip_ent[$k] : null,
                        'ent_estado' => 1,
                        'ent_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'ent_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    if ($value > 0) {
                        $exitos += $this->gsatelite->actualizar_array('ent_entregable_cotizacion', $datos, array('ent_id' => $value));
                    } else {
                        $datos['ent_usu_creacion'] = $this->tank_auth->get_user_id();
                        $datos['ent_fecha_creacion'] = date('Y-m-d H:i:s');
                        $exitos += $this->gsatelite->ingresar('ent_entregable_cotizacion', $datos);
                    }
                }
            }
            if ($exitos > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Entregables Cotización", 'texto_alerta' => "El registro se procesó correctamente.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Entregables Cotización", 'texto_alerta' => "Ocurrio un problema al procesar el registro.");
            }
            $this->session->set_flashdata($alerta);
            if ($redireccion > 1) {
                redirect('/cotizaciones/cotizaciones/index');
            } else {
                redirect('cotizaciones/cotizaciones/entregables_cot/' . $cot_id);
            }
        } else {
            $this->gsatelite->verificar_registro_real('cot_cotizacion', $cot_id);
            $cotizacion = $this->cotModel->get_cotizacion(array('cot_id' => $cot_id), 0);
            $datos['sugerido'] = (number_format($this->gsatelite->get_max('ent_entregable_cotizacion', 'ent_numero_entregable', array('ent_estado' => 1, 'ent_id_cot' => $cot_id))) + 1);
            $datos['registros'] = $registros;
            $datos['cotizacion'] = $cotizacion[0];
            $datos['titulo_personal'] = 'Entregables';
            $this->_cargarvista($datos, null);
        }
    }

    /**
     * @autor Raul E.
     * @since feb/2021
     * @description: Agregar los pagos y sus formas de pago seccionados para una cotizacion
     */
    public function forma_pago_cot($cot_id = 0)
    {
        satelite_validar();
        $registros = $this->cotModel->get_forma_pago_cot(array('fpc_id_cot' => $cot_id));
        if ($_POST) {
            $exitos = 0;
            $ids_pagos = $this->input->post('ids_pago');
            $num_pagos = $this->input->post('numero_pago');
            $nom_pagos = $this->input->post('nombre_pago');
            $porciento = $this->input->post('percnt_pago');
            $cant_pago = $this->input->post('monto_pago');
            $dias_pago = $this->input->post('dias_pago');
            $fech_pago = $this->input->post('fecha_pago');
            $ids_entrg = $this->input->post('ids_entr_pago');
            $redirects = $this->input->post('btnCrear');
            //Inactivar / eliminar los que no van
            $act_ids = array_column($registros, 'fpc_id');
            foreach ($act_ids as $key => $val) {
                if (!(in_array($val, $ids_pagos))) {
                    $inactivar = array('fpc_estado' => 0, 'fpc_usu_modificacion' => $this->tank_auth->get_user_id(), 'fpc_fecha_modificacion' => date('Y-m-d H:i:s'));
                    $id = $this->gsatelite->actualizar_array('fpc_forma_pago_cotizacion', $inactivar, array('fpc_id' => $val));
                }
            }
            if (count($ids_pagos) > 0) {
                foreach ($ids_pagos as $k => $value) {
                    $datos = array(
                        'fpc_id_cot' => $cot_id,
                        'fpc_numero_pago' => $num_pagos[$k],
                        'fpc_nombre' => $nom_pagos[$k],
                        'fpc_porcentaje' => $porciento[$k],
                        'fpc_monto_pago' => number_format($cant_pago[$k], 2, '.', ''),
                        'fpc_dias' => $dias_pago[$k],
                        'fpc_fecha_aproximada' => formatear_fecha('Y-m-d', $fech_pago[$k]),
                        'fpc_estado' => 1,
                        'fpc_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'fpc_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    if ($value > 0) {
                        $fpc_id = $value;
                        $exitos += $this->gsatelite->actualizar_array('fpc_forma_pago_cotizacion', $datos, array('fpc_id' => $value));
                    } else {
                        $datos['fpc_usu_creacion'] = $this->tank_auth->get_user_id();
                        $datos['fpc_fecha_creacion'] = date('Y-m-d H:i:s');
                        $fpc_id = $this->gsatelite->ingresar('fpc_forma_pago_cotizacion', $datos);
                        $exitos++;
                    }
                    if ($ids_entrg[$k] != "") {
                        $entregas = explode(',', $ids_entrg[$k]);
                        $this->gsatelite->borrado_general('fxe_forma_pagoxentregable_cotizacion', array('fxe_id_fpc' => $fpc_id));
                        foreach ($entregas as $key => $value) {
                            $detalles = array(
                                'fxe_id_fpc' => $fpc_id,
                                'fxe_id_ent' => $value,
                                'fxe_estado' => 1,
                                'fxe_usu_creacion' => $this->tank_auth->get_user_id(),
                                'fxe_fecha_creacion' => date('Y-m-d H:i:s'),
                                'fxe_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'fxe_fecha_modificacion' => date('Y-m-d H:i:s')
                            );
                            $fxo_id = $this->gsatelite->ingresar('fxe_forma_pagoxentregable_cotizacion', $detalles);
                        }
                    }
                }
            }
            if ($exitos > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Entregables Cotización", 'texto_alerta' => "El registro se procesó correctamente.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Entregables Cotización", 'texto_alerta' => "Ocurrio un problema al procesar el registro.");
            }
            $this->session->set_flashdata($alerta);
            if ($redirects > 1) {
                redirect('/cotizaciones/cotizaciones/index');
            } else {
                redirect('cotizaciones/cotizaciones/forma_pago_cot/' . $cot_id);
            }
        } else {
            $this->gsatelite->verificar_registro_real('cot_cotizacion', $cot_id);
            $cotizacion = $this->cotModel->get_cotizacion(array('cot_id' => $cot_id), 0);
            $data['entregas'] = $this->gsatelite->get_tabla('ent_entregable_cotizacion', array('ent_estado' => 1, 'ent_id_cot' => $cot_id));
            $data['sugerido'] = (number_format($this->gsatelite->get_max('fpc_forma_pago_cotizacion', 'fpc_numero_pago', array('fpc_estado' => 1, 'fpc_id_cot' => $cot_id))) + 1);
            $data['cotizacion'] = $cotizacion[0];
            $data['registros'] = $registros;
            $data['titulo_personal'] = 'Forma de Pago';
            $this->_cargarvista($data, null);
        }
    }

    /**
     * Cotizaciones::clientes()
     *
     * @return vista de la tabla clientes
     * (solo para redireccionar a diversas acciones como ver los contactos, dar seguimiento y ver cotizacioens)
     */
    function clientes($existe = 0, $idcliente = null, $modal_clie = null)
    {

        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {

            try {

                //preguntar si el usuario es supervisor o vendedor
                $condicion1 = array('sup_id_usu' => $this->tank_auth->get_user_id(), 'sup_estado' => 1);
                $esSup = $this->cotModel->Existe_Registro("sup_supervisor", $condicion1);
                $condicion2 = array('ven_id_usu' => $this->tank_auth->get_user_id(), 'ven_estado' => 1);
                $esVen = $this->cotModel->Existe_Registro("ven_vendedor", $condicion2);


                $cli_id = end(explode('/', uri_string()));
                if ($cli_id > 0) {
                    $datosCliente = $this->cotModel->get_registro('cli_cliente', 'cli_id', $cli_id);
                    $id_vendedor = $datosCliente->cli_id_ven;
                } else {
                    $id_vendedor = "0";
                }

                $crud = new grocery_CRUD();


                $state = $crud->getState();
                switch ($state) {
                    case 'print':
                        //Columnas a mostrar en READ
                        $columns = array(
                            'cli_codigo',
                            'cli_nombre', //razon comercial
                            'cli_apellido', //razon social
                            'contacto',
                            'telefono', //telefono del primer contacto
                            'email', //email del primer contacto
                            'cli_direccion',
                            'cli_estado'
                        );
                        break;
                    case 'export':
                        //Columnas a mostrar en READ
                        $columns = array(
                            'cli_codigo',
                            'cli_nombre', //razon comercial
                            'cli_apellido', //razon social
                            'contacto',
                            'telefono', //telefono del primer contacto
                            'email', //email del primer contacto
                            'cli_direccion',
                            'cli_estado'
                        );
                        break;
                    default:
                        //Columnas a mostrar en READ
                        $columns = array(
                            'cli_codigo',
                            'cli_nombre', //razon comercial
                            'cli_apellido', //razon social
                            'contacto',
                            'telefono', //telefono del primer contacto
                            'email', //email del primer contacto
                            'cli_direccion',
                            'cli_estado'
                        );
                        break;
                }

                //Alias para las columnas
                $alias = array(
                    'cli_nombre' => 'Razón comercial',
                    'cli_apellido' => 'Razón social',
                    'cli_email' => 'E-mail',
                    'cli_estado' => 'Estado',
                    // 'cli_razon_comercial' => 'Razón Comercial',
                    'cli_personeria' => 'Personeria',
                    'cli_observacion' => 'Observación',
                    'cli_sitio_web' => 'Sitio Web',
                    'cli_id_sec' => 'Sector',
                    'cli_id_cac' => 'Cartera',
                    'cli_id_ven' => 'Vendedor',
                    'cli_direccion' => 'Dirección',
                    'cli_codigo' => 'Código',
                    'cliente' => 'Cliente',
                    'con_contacto' => 'Contacto',
                    'con_telefono' => 'Telefono',
                    'email' => 'Correo'

                );



                //Columnas a mostrar en ADD
                $add_columns = array(
                    'cli_personeria',
                    'cli_nombre',
                    'cli_apellido',
                    //'cli_razon_comercial',
                    'cli_email',
                    'cli_observacion',
                    'cli_id_sec',
                    'cli_id_cac',
                    'cli_id_ven',
                    'cli_sitio_web',
                    'cli_estado',
                    'cli_fecha_mod',
                    'cli_usu_mod',
                    'cli_direccion',
                    'con_contacto',
                    'con_telefono',
                    'con_email'
                );


                //Columnas a mostrar en EDIT
                $edit_columns = $add_columns;

                $crud->set_table('cli_cliente')
                    //->set_subject('Listado de clientes')
                    ->set_subject('')
                    ->where('cli_estado <>', -1)
                    ->unset_delete()
                    ->columns($columns)
                    ->display_as($alias)
                    //->display_as('cli_apellido','Cliente')
                    ->add_fields($add_columns)
                    ->edit_fields($edit_columns)
                    ->set_relation('cli_id_sec', 'sec_sector_cliente', 'sec_nombre')
                    ->set_relation('cli_id_cac', 'cac_cartera_cliente', 'cac_nombre')
                    ->callback_column('contacto', array($this, '_callback_contacto'))
                    ->callback_column('telefono', array($this, '_callback_contacto_telefono'))
                    ->callback_column('email', array($this, '_callback_contacto_email'))
                    ->field_type('cli_personeria', 'dropdown', array('1' => 'Juridica', '0' => 'Natural'))
                    ->field_type('cli_estado', 'dropdown', array('1' => 'Activado', '0' => 'Desactivado'))
                    ->set_rules('cli_nombre', 'Nombre', 'required')
                    ->set_rules('cli_id_ven', 'Vendedor', 'required')
                    ->set_rules('cli_estado', 'Estado', 'required')
                    ->set_rules('cli_id_sec', 'Sector', 'required')
                    ->set_rules('cli_id_cac', 'Cartera Cliente', 'required')

                    //    ->add_action('Ver Cotizaciones', '', 'cotizaciones/cotizaciones/cotizacion_cliente','icomoon-icon-file')
                    ->add_action('Seguimiento Cliente', '', 'cotizaciones/cotizaciones/seguimiento_cliente', 'icomoon-icon-file')
                    ->add_action('Contactos', '', 'cotizaciones/mantenimientos/contactos/', 'icomoon-icon-user')
                    ->field_type('cli_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                    ->field_type('cli_usu_mod', 'hidden', $this->tank_auth->get_user_id());

                //$crud->unset_columns('cli_nombre', 'cli_apellido');
                // $crud->callback_column('cliente',function($value, $row){
                // 	$str = $row->cli_nombre.' '.$row->cli_apellido;
                //     return $str;
                // });

                if ($esSup > 0) { //es supervisor
                    $queryIdVen = $this->cotModel->get_idsVendedoresxSupervisor($this->tank_auth->get_user_id());
                    if ($id_vendedor != 0) {
                        if (!in_array($id_vendedor, (explode(',', $queryIdVen)))) {
                            $queryIdVen = "0";
                        }
                    }

                    $crud->set_relation('cli_id_ven', 'ven_vendedor', '{ven_nombre} {ven_apellidos}', "ven_id in ( {$queryIdVen} )");
                } else if ($esVen > 0) { //es vendedor
                    $usu_id = $this->gsatelite->get_campo('ven_vendedor', 'ven_id_usu', array('ven_id' => $id_vendedor));
                    if ($id_vendedor != 0) {
                        if ($usu_id == $this->tank_auth->get_user_id()) {
                            $crud->set_relation('cli_id_ven', 'ven_vendedor', '{ven_nombre} {ven_apellidos}', array('ven_estado' => 1, 'ven_id_usu' => $this->tank_auth->get_user_id()));
                        } else {
                            $crud->set_relation('cli_id_ven', 'ven_vendedor', '{ven_nombre} {ven_apellidos}', array('ven_estado' => 1, 'ven_id_usu' => 0));
                        }
                    } else {
                        $crud->set_relation('cli_id_ven', 'ven_vendedor', '{ven_nombre} {ven_apellidos}', array('ven_estado' => 1, 'ven_id_usu' => $this->tank_auth->get_user_id()));
                    }
                } else {
                    $crud->set_relation('cli_id_ven', 'ven_vendedor', '{ven_nombre} {ven_apellidos}', array('ven_estado' => 1, 'ven_id_usu' => 0));
                }
                $crud->unset_edit();
                $crud->unset_add();
                //$crud->unset_print();
                //$crud->unset_export();

                //se agrego where en la consulta
                if ($_POST) { //print_r($_POST); die();
                    //$cliente_filtro    = $this->input->post('txt_cliente');
                    //$documento_filtro  = $this->input->post('txt_documento');

                    $cliente_filtro    = $this->input->post('txt_cliente');
                    $segmento  = $this->input->post('slcSegmentos');
                    $documento_filtro  = $this->input->post('txt_documento');

                    $vendedor  = $this->input->post('slcVendedor');
                    $clasificacion  = $this->input->post('slcClasific');
                    $zona_geo  = $this->input->post('slcZona');

                    //print_r($_POST); die();
                    $where = null;
                    $like = null;
                    $like2 = null;

                    if ($cliente_filtro != "") {
                        //$like = $cliente_filtro;
                        $where['cli_id'] = $cliente_filtro;
                    }

                    if ($segmento != "") {
                        $where['cli_id_cac'] = $segmento;
                    }

                    if ($vendedor != '') {
                        $where['cli_id_ven'] = $vendedor;
                    }

                    if ($clasificacion != '') {
                        $where['cli_id_cfc'] = $clasificacion;
                    }

                    if ($zona_geo != '') {
                        $where['cli_id_zog'] = $zona_geo;
                    }

                    if ($documento_filtro != "") {
                        $like2['dcc_valor'] = $documento_filtro;
                    }

                    $clientes_array = $this->cotModel->get_clientes_like($where, null, $like2);
                    //$clientes_array = $this->cotModel->get_clientes_like($where,$like,$like2);

                    $cli_id = "";
                    if (count($clientes_array) > 0) {
                        foreach ($clientes_array as $cliente) {
                            $cli_id = $cli_id . $cliente['cli_id'] . ",";
                        }
                    }

                    if ($cli_id == "") {
                        $cli_id = 0;
                    } else {
                        $cli_id = substr($cli_id, 0, -1);
                    }
                    $crud->where('cli_id IN (' . $cli_id . ')');

                    $this->load->library('../controllers/cotizaciones/mantenimientos');
                    $data_filtro['clientes'] = $this->mantenimientos->clientes_x_segmento($segmento, true);
                    //$data_filtro['cliente_filtro']    = $cliente_filtro;
                    $data_filtro['documento_filtro']  = $documento_filtro;
                } else {
                    $crud->where('cli_id', 0);
                    $data_filtro['cliente_filtro']    = "";
                    $data_filtro['documento_filtro']  = "";
                }

                if ($_POST) {
                    //Sector seleccionado
                    $select = $this->gsatelite->get_dropdown('cac_cartera_cliente', '{cac_nombre}', '', array('cac_estado' => 1), $segmento, '', 'cac_id', true);
                    $data_filtro["segmentos"] = str_replace('<option value="0">Seleccione</option>', '', $select);
                    //print_r($select); die();
                    //Cliente seleccionado                    
                    $cliente_selected = $this->gsatelite->get_tabla('cli_cliente', array('cli_estado' => 1));

                    $client = '';
                    foreach ($cliente_selected as $cli) {
                        $seleccionado = ($cli['cli_id'] ==  $cliente_filtro) ? "selected" : "";
                        //$seleccionado = '';

                        if ($cli['cli_codigo'] != '') {
                            $codigo = trim($cli['cli_codigo']) . ' - ';
                        } else {
                            $codigo = '';
                        }
                        $nombre_cliente = ($cli['cli_personeria'] == 1) ? $codigo . $cli['cli_nombre'] . ' ' . $cli['cli_apellido'] : $codigo . $cli['cli_apellido'];
                        $client .= '<option value="' . $cli['cli_id'] . '" ' . $seleccionado . '>' . $nombre_cliente . '</option>';
                    }
                    $data_filtro['clientes'] = $client;
                    //$cliente_filtro
                } else {
                    //sectores
                    $select = $this->gsatelite->get_dropdown('cac_cartera_cliente', '{cac_nombre}', '', array('cac_estado' => 1), null, '', 'cac_id', true);
                    $data_filtro["segmentos"] = str_replace('<option value="0">Seleccione</option>', '', $select);

                    //clientes
                    $clientes = $this->gsatelite->get_tabla('cli_cliente', array('cli_estado' => 1));

                    $client = '';
                    foreach ($clientes as $cli) {

                        if ($cli['cli_codigo'] != '') {
                            $codigo = trim($cli['cli_codigo']) . ' - ';
                        } else {
                            $codigo = '';
                        }
                        $nombre_cliente = ($cli['cli_personeria'] == 1) ? $codigo . $cli['cli_nombre'] . ' ' . $cli['cli_apellido'] : $codigo . $cli['cli_apellido'];
                        $client .= '<option value="' . $cli['cli_id'] . '">' . $nombre_cliente . '</option>';
                    }
                    $data_filtro['clientes'] = $client;
                }

                $select = $this->gsatelite->get_dropdown('ven_vendedor', '{ven_codigo} - {ven_nombre}', '', array('ven_estado' => 1), null, '', 'ven_id', true);
                $data_filtro["vendedores"] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $select);

                $select = $this->gsatelite->get_dropdown('cfc_clasificacion_cliente', '{cfc_nombre}', '', array('cfc_estado' => 1), null, '', 'cfc_id', true);
                $data_filtro["clasificaciones"] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $select);

                $select = $this->gsatelite->get_dropdown('zog_zona_geografica', '{zog_nombre}', '', array('zog_estado' => 1), null, '', 'zog_id', true);
                $data_filtro["zonas"] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $select);

                $output = $crud->render();
                $data['html_filtro_clientes'] = $this->load->view('cotizaciones/mantenimientos/filtro_clientes', $data_filtro, true);
                $data['titulo_personal'] = "Administración de clientes";

                if ($existe != 0) {
                    $this->load->view('cotizaciones/cotizaciones/nuevo_cliente', $output);
                } else if ($modal_clie == 1) {
                    $this->load->view('cotizaciones/cotizaciones/nuevo_cliente', $output);
                } else {
                    $this->_cargarvista($data, $output);
                }
            } catch (Exception $e) {
                show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
            }
        }
    }

    /**
     * Cotizaciones::seguimiento_cliente()
     *
     * @param integer $id_cliente
     * @return MANTENIMIENTO DE LA TABLA sec_seguimiento_cliente
     */
    function seguimiento_cliente($id_cliente = 0)
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            try {
                $queryIdSec = $this->cotModel->get_idsSeguimientoxCliente($id_cliente);
                $crud = new grocery_CRUD();
                $crud->set_table('sec_seguimiento_cliente')
                    ->set_subject('Seguimiento - Cliente')
                    ->columns('sec_id_tsg', 'sec_id_con', 'sec_fecha', 'sec_comentario', 'sec_fecha_proximo')
                    ->where("sec_id in ( {$queryIdSec} )") //id de los seguimientos pertenecientes al cliente
                    ->add_fields(
                        'sec_id_con',
                        'sec_fecha',
                        'sec_comentario',
                        'sec_fecha_proximo',
                        'sec_id_tsg',
                        'sec_usu_mod',
                        'sec_fecha_mod',
                        'sec_lugar',
                        'sec_invitados',
                        'sec_estado',
                        'sec_usu_crea',
                        'sec_fecha_crea'
                    )
                    ->edit_fields(
                        'sec_id_con',
                        'sec_comentario',
                        'sec_fecha_proximo',
                        'sec_id_tsg',
                        'sec_usu_mod',
                        'sec_fecha_mod',
                        'sec_lugar',
                        'sec_invitados',
                        'sec_estado'
                    )
                    ->required_fields('sec_id_con', 'sec_id_tsg', 'sec_fecha', 'sec_comentario', 'sec_fecha_proximo', 'sec_usu_mod', 'sec_fecha_mod')
                    ->display_as('sec_id_con', 'Contacto')
                    ->display_as('sec_fecha', 'Fecha Seguimiento')
                    ->display_as('sec_comentario', 'Comentario')
                    ->display_as('sec_fecha_proximo', 'Próximo Seguimiento')
                    ->display_as('sec_id_tsg', 'Tipo Seguimiento')
                    ->display_as('sec_lugar', 'Lugar')
                    ->display_as('sec_invitados', 'Asistentes')
                    ->display_as('sec_estado', 'Estado')
                    ->set_relation('sec_id_tsg', 'tsg_tipo_seguimiento', 'tsg_nombre', array('tsg_estado' => 1))
                    ->set_relation('sec_id_con', 'con_contacto', '{con_titulo_profesion} {con_nombre} {con_apellidos} - {con_cargo}', array('con_estado' => 1, 'con_id_cli' => $id_cliente))
                    ->field_type('sec_usu_crea', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('sec_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('sec_fecha_crea', 'hidden', date('Y-m-d H:i:s'))
                    ->field_type('sec_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                    ->callback_column('sec_fecha', function($value, $row) {
                        return '<span style="display: none;">' . formatear_fecha('Ymd', $row->sec_fecha) . '</span>' . formatear_fecha('d-m-Y', $row->sec_fecha);
                    })
                    ->callback_column('sec_fecha_proximo', function($value, $row) {
                        return '<span style="display: none;">' . formatear_fecha('Ymd', $row->sec_fecha_proximo) . '</span>' . formatear_fecha('d-m-Y', $row->sec_fecha_proximo);
                    })
                    ->callback_add_field('sec_fecha', function () {
                        return '<input type="text" id="field-sec_fecha" readonly name="sec_fecha">';
                    })
                    ->callback_add_field('sec_fecha_proximo', function () {
                        return '<input type="text" id="field-sec_fecha_proximo" name="sec_fecha_proximo" autocomplete="off" class="datePicker">';
                    })
                    ->callback_edit_field('sec_fecha_proximo', function ($value, $row) {
                        return '<input type="text" id="field-sec_fecha_proximo" name="sec_fecha_proximo" value="' . formatear_fecha('d-m-Y', $value) . '" class="datePicker" autocomplete="off">';
                    })
                    ->callback_before_insert(function($post_array){
                        $datetime1 = date('Y-m-d');
                        $datetime2 = date('Y-m-d', strtotime($post_array['sec_fecha_proximo']));
                        $post_array['sec_fecha'] = formatear_fecha('Y-m-d', $post_array['sec_fecha']);
                        $post_array['sec_fecha_proximo'] = formatear_fecha('Y-m-d', $post_array['sec_fecha_proximo']);
                        if ($datetime1 <= $datetime2) {
                            return $post_array;
                        } else {
                            return FALSE;
                        }
                    })
                    ->callback_before_update(function ($post_array, $primary_key) {
                        $datetime1 = date('Y-m-d');
                        $datetime2 = date('Y-m-d', strtotime($post_array['sec_fecha_proximo']));
                        $post_array['sec_fecha_proximo'] = formatear_fecha('Y-m-d', $post_array['sec_fecha_proximo']);
                        if ($datetime1 <= $datetime2) {
                            return $post_array;
                        } else {
                            return FALSE;
                        }
                    })
                    ->set_lang_string('insert_error', 'La fecha del próximo seguimiento no puede ser menor a la actual')
                    ->set_lang_string('update_error', 'La fecha del próximo seguimiento no puede ser menor a la actual')
                    ->unset_delete();
                if (end(explode('/', uri_string())) == 'add') {
                    $crud->field_type('sec_estado', 'hidden', 1);
                } else {
                    $crud->field_type('sec_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
                }
                $datos['datos_cliente'] = $this->cotModel->get_registro('cli_cliente', 'cli_id', $id_cliente); //obtener registro
                $output = $crud->render();
                $datos['titulo_personal'] = "Seguimiento Cliente";
                $modal = $this->uri->segment(8);
                if ($modal == false) {
                    $this->_cargarvista($datos, $output);
                } else {
                    $datos['modal_cotizaciones'] = true;
                    cargarvista_modal($datos, $output);
                }
            } catch (Exception $e) {
                show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
            }
        }
    }

    function validar_fecha($str)
    {
        $hoy = date('Y-m-d H:i:s');
        $datetime1 = new DateTime($hoy); //fecha actual
        $datetime2 = new DateTime($str); //fecha del proximo seguimiento

        if ($datetime1 <= $datetime2) {
            return TRUE;
        } else {
            $this->form_validation->set_message('validar_fecha', 'La fecha del próximo seguimiento no puede ser menor a la actual');
            return FALSE;
        }
    }

    /**
     * Cotizaciones::anexos_cotizacion()
     *
     * @param integer $id_cotizacion
     * @return MATENIMIENTO DE LA TABLA axc_anexoxcotizacion
     */
    function contactos_cliente_modal($id_cliente)
    {

        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {

            try {

                if (!isset($id_cliente))
                    $id_cliente = 0;
                $crud = new grocery_CRUD();
                //Columnas a mostrar en READ
                $columns = array(
                    'con_nombre',
                    'con_apellidos',
                    'con_cargo',
                    'con_telefono',
                    'con_email',
                    'con_estado',
                );

                //Alias para las columnas
                $alias = array(
                    'con_nombre' => 'Nombre',
                    'con_apellidos' => 'Apellidos',
                    'con_email' => 'E-mail',
                    'con_estado' => 'Estado',
                    'con_cargo' => 'Cargo',
                    'con_telefono' => 'Telefono',
                );


                //Columnas a mostrar en ADD
                $add_columns = array(
                    'con_id_cli',
                    'con_nombre',
                    'con_apellidos',
                    'con_cargo',
                    'con_telefono',
                    'con_email',
                    'con_estado',
                    'con_fecha_mod',
                    'con_usu_mod',
                );

                //Columnas a mostrar en EDIT
                $edit_columns = $add_columns;


                $crud->set_table('con_contacto')
                    ->set_subject('Contacto')
                    ->where('con_estado <>', -1)
                    ->where('con_id_cli', $id_cliente)
                    ->unset_delete()
                    ->columns($columns)
                    ->display_as($alias)
                    ->add_fields($add_columns)
                    ->edit_fields($edit_columns)
                    ->set_rules('con_nombre', 'Nombre', 'required')
                    ->set_rules('con_apellidos', 'Apellidos', 'required')
                    ->set_rules('con_estado', 'Estado', 'required')
                    ->set_rules('con_email', 'E-mail', 'required')
                    ->set_rules('con_telefono', 'Telefono', 'required')
                    ->set_rules('con_cargo', 'Cargo', 'required')
                    ->field_type('con_id_cli', 'hidden', $id_cliente)
                    ->field_type('con_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                    ->field_type('con_usu_mod', 'hidden', $this->tank_auth->get_user_id());
                $ven_id = end(explode('/', uri_string()));

                if ($ven_id == 'add') {
                    $crud->field_type('con_estado', 'hidden', 1);
                } else {
                    $crud->field_type('con_estado', 'dropdown', array('1' => 'Activado', '0' => 'Desactivado'));
                }
                $crud->unset_delete();
                $crud->unset_print();
                $crud->unset_export();

                $output = $crud->render();

                //$data['titulo_personal'] = "Actividad Comercial"; # Antonio
                // $this->_cargarvista(null,$output);
                $this->load->view("cotizaciones/cotizaciones/contactos_cliente_modal", $output);
            } catch (Exception $e) {
                show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
            }
        }
    }

    /**
     * Cotizaciones::anexos_cotizacion()
     *
     * @param integer $id_cotizacion
     * @return MATENIMIENTO DE LA TABLA axc_anexoxcotizacion
     */
    function anexos_cotizacion($id_cotizacion = 0)
    {

        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            try {
                /* $IDS = $this->cotModel->get_idsAnexoxCotizaciones($id_cotizacion);
                  if (strlen($IDS) > 0) {
                  $IDS = $IDS;
                  } else {
                  $IDS = "0";
                  } */

                $anexos_cotizaciones = $this->gsatelite->get_tabla('axz_anexoxcotizacion', array('axz_id_cot' => $id_cotizacion));
                $detalles = array_column($anexos_cotizaciones, 'axz_id');
                $IDS = '0';
                if (count($detalles) > 0) {
                    $IDS = implode(',', $detalles);
                }

                // $IDcotizacion =  $id_cotizacion;
                if (isset($_SESSION["IDAnexoxCotizacion"])) {
                    unset($_SESSION["IDAnexoxCotizacion"]);
                }
                $_SESSION["IDAnexoxCotizacion"] = $id_cotizacion;


                $crud = new grocery_CRUD();
                $crud->set_table('axz_anexoxcotizacion')
                    ->set_subject('Anexo - Cotizaci&oacute;n')
                    ->columns('axz_nombre', 'axz_url', 'axz_estado')
                    ->where("axz_id in ( {$IDS} )")
                    ->add_fields('axz_nombre', 'axz_id_cot', 'axz_url', 'axz_estado', 'axz_usu_modificacion', 'axz_fecha_modificacion', 'axz_usu_creacion', 'axz_fecha_creacion')
                    ->edit_fields('axz_nombre', 'axz_url', 'axz_estado', 'axz_usu_modificacion', 'axz_fecha_modificacion')
                    ->required_fields('axz_estado', 'axz_nombre', 'axz_url')
                    ->display_as('axz_url', 'Anexo')
                    ->display_as('axz_estado', 'Estado Anexo')
                    ->display_as('axz_nombre', 'Nombre Anexo')
                    ->field_type('axz_id_cot', 'hidden', $id_cotizacion)
                    ->field_type('axz_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('axz_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
                    ->field_type('axz_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('axz_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
                    ->set_field_upload('axz_url', 'uploads/anx_cotizacion')
                    ->unset_delete();
                $agregar = end(explode('/', uri_string()));

                if ($agregar == 'add') {
                    $crud->field_type('axz_estado', 'hidden', 1);
                } else {
                    $crud->field_type('axz_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
                }

                $filaCotizacion = $this->cotModel->get_registro('cot_cotizacion', 'cot_id', $id_cotizacion); //obtener registro de sector
                $datos['datos_cotizacion'] = $filaCotizacion;
                $datos['datos_cliente'] = $this->cotModel->get_registro('cli_cliente', 'cli_id', $filaCotizacion->cot_id_cli); //obtener registro


                $output = $crud->render();
                $datos['titulo_personal'] = "Anexos por cotizaci&oacute;n";

                $this->_cargarvista($datos, $output);
            } catch (Exception $e) {
                show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
            }
        }
    }

    /**
     * Cotizaciones::cotizacion_ganada_perdida()
     *
     * @param mixed $id_cotizacion
     * @param string $correcto
     * @return MATENIMIENTO DE LAS TABLAS cog_cotiz_ganada y per_perdido
     */
    function cotizacion_ganada_perdida($id_cotizacion, $correcto = "")
    {

        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            try {
                //PREGUNTAR SI A ESA COTIZACION YA SE LE REGISTRO COMO GANADA O PERDIDA Y ASI SOLO MOSTRAR SUS DATOS
                //PARA LA ACTUALIZACION
                $WhereGanada = array('cog_id_cot' => $id_cotizacion);
                $WherePerdida = array('per_id_cot' => $id_cotizacion);

                $es_ganada = $this->cotModel->Existe_Registro("cog_cotiz_ganada", $WhereGanada);
                $es_perdida = $this->cotModel->Existe_Registro("per_perdido", $WherePerdida);

                if ($es_ganada == 1) {
                    $datos['estado_cotizacion'] = 1;
                    $datos['datos_ganada'] = $this->cotModel->get_tabla("cog_cotiz_ganada", "cog_id_cot", $id_cotizacion, "cog_id", "ASC");
                } else if ($es_perdida == 1) {
                    $datos['estado_cotizacion'] = 2;
                    $datos['datos_perdida'] = $this->cotModel->get_tabla("per_perdido", "per_id_cot", $id_cotizacion, "per_id", "ASC");
                } else {
                    $datos['estado_cotizacion'] = 3;
                }

                //die(print_r($datos['estado_cotizacion']));
                $filaCotizacion = $this->cotModel->get_registro('cot_cotizacion', 'cot_id', $id_cotizacion); //obtener registro

                $datos['datos_cotizacion'] = $filaCotizacion;
                //solo lectura del estado de la cotizacion en la vista del form cotizacion ganada-perdida (cuando haya sido registrada como perdida o ganada)
                $datos['Nombre_EstadoCotizacion'] = $this->gsatelite->get_campo('est_estado_cotizacion', 'est_nombre', array('est_id' => $filaCotizacion->cot_id_est));
                $datos['tabla_estado_cotizacion'] = $this->cotModel->get_tabla("est_estado_cotizacion", "est_estado", 1, "est_id", "ASC");
                $datos['datos_cliente'] = $this->cotModel->get_registro('cli_cliente', 'cli_id', $filaCotizacion->cot_id_cli); //obtener registro
                // $datos['todobien'] = $correcto;
                if ($correcto != "" and $correcto == "1") {
                    $datos['exito'] = "Operación realizada con Éxito :)";
                    $datos['clase'] = "ui-state-highlight";
                    $datos['icono'] = "ui-icon ui-icon-info";
                }
                if ($correcto != "" and $correcto == "2") {
                    $datos['exito'] = "Error en Realizar operación :( , Favor de intentar de nuevo";
                    $datos['clase'] = "ui-state-error";
                    $datos['icono'] = "ui-icon ui-icon-alert";
                }


                //preguntar si es vendedor
                $condicion1 = array('ven_id_usu' => $this->tank_auth->get_user_id(), 'ven_estado' => 1);
                $esVen = $this->cotModel->Existe_Registro("ven_vendedor", $condicion1);
                if ($esVen > 0) {
                    $datos["esVen"] = 1;
                    $datos['titulo_personal'] = "Establecer cotizaci&oacute;n perdida";
                } else {
                    $datos['titulo_personal'] = "Establecer cotizaci&oacute;n como ganada o perdida";
                }
                $this->_cargarvista($datos, null);
            } catch (Exception $e) {
                show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
            }
        }
    }

    /**
     * Cotizaciones::insert_update_cotizacion_ganada_perdida()
     *
     * @return void FUNCION PARA REALIZAR EL INSERT O ACTUALIZACION EN LA TABLA PER_PERDIDO O COG_COTIZ_GANADA
     */
    function insert_update_cotizacion_ganada_perdida()
    {

        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        }
        try {
            $bandera = $this->input->post('bandera');
            $id_cotizacion = $this->input->post('cotizacionID');
            $id_nuevo_EstadoCot = $this->input->post('actualizar_estado_cotizacion');

            if ($bandera == 1) { //ES INSERCCION
                $estado = $this->input->post('estado_cotizacion');
                if ($estado == 1) { //insert a la tabla cotizacion ganada
                    //APLICAR LA VALIDACION
                    $this->form_validation->set_rules('fecha_cierre', 'Fecha', 'trim|required|xss_clean');
                    $this->form_validation->set_rules('comision_real_p', 'Comision_P', 'trim|required|xss_clean');
                    $this->form_validation->set_rules('comision_real_d', 'Comision_D', 'trim|required|xss_clean');

                    if ($this->form_validation->run() == false) { //preguntar si cumple con las validaciones
                        $correcto = 2;
                    } else {
                        $this->cotModel->update_registros("cot_cotizacion", array('cot_id_est' => $id_nuevo_EstadoCot), "cot_id", $id_cotizacion);

                        $arregloDatos = array(
                            'cog_id_cot' => $id_cotizacion,
                            'cog_fecha_cierre' => trim($this->input->post('fecha_cierre')),
                            'cog_comision_real_p' => trim($this->input->post('comision_real_p')),
                            'cog_comision_real_d' => trim($this->input->post('comision_real_d')),
                            'cog_causa_estado' => trim($this->input->post('causa_gan')),
                            'cog_estado' => 1,
                            'cog_usu_crea' => $this->tank_auth->get_user_id(),
                            'cog_fecha_crea' => date('Y-m-d H:i:s'),
                            'cog_usu_mod' => $this->tank_auth->get_user_id(),
                            'cog_fecha_mod' => date('Y-m-d H:i:s')
                        );
                        if ($this->cotModel->insertar_registros("cog_cotiz_ganada", $arregloDatos)) {
                            $correcto = 1;
                        } else {
                            $correcto = 2;
                        }
                    }
                } else { //insert a la tabla cotizacion perdida
                    //APLICAR LA VALIDACION
                    $this->form_validation->set_rules('fecha_p', 'Fecha', 'trim|required|xss_clean');
                    $this->form_validation->set_rules('precio_p', 'Precio', 'trim|xss_clean');
                    $this->form_validation->set_rules('empresa', 'Empresa', 'trim|xss_clean');


                    if ($this->form_validation->run() == false) { //preguntar si cumple con las validaciones
                        $correcto = 2;
                    } else {
                        $this->cotModel->update_registros("cot_cotizacion", array('cot_id_est' => $id_nuevo_EstadoCot), "cot_id", $id_cotizacion);
                        //preguntar si el precio viene vacio
                        if (trim($this->input->post('precio_p')) != "") {
                            $arregloDatos = array(
                                'per_id_cot' => $id_cotizacion,
                                'per_precio' => trim($this->input->post('precio_p')),
                                'per_empresa' => trim($this->input->post('empresa')),
                                'per_fecha_perdido' => trim($this->input->post('fecha_p')),
                                'per_causa_estado' => trim($this->input->post('causa_per')),
                                'per_estado' => 1,
                                'per_usu_crea' => $this->tank_auth->get_user_id(),
                                'per_fecha_crea' => date('Y-m-d H:i:s'),
                                'per_usu_mod' => $this->tank_auth->get_user_id(),
                                'per_fecha_mod' => date('Y-m-d H:i:s')
                            );
                        } else {
                            $arregloDatos = array(
                                'per_id_cot' => $id_cotizacion,
                                'per_empresa' => trim($this->input->post('empresa')),
                                'per_fecha_perdido' => trim($this->input->post('fecha_p')),
                                'per_causa_estado' => trim($this->input->post('causa_per')),
                                'per_estado' => 1,
                                'per_usu_crea' => $this->tank_auth->get_user_id(),
                                'per_fecha_crea' => date('Y-m-d H:i:s'),
                                'per_usu_mod' => $this->tank_auth->get_user_id(),
                                'per_fecha_mod' => date('Y-m-d H:i:s')
                            );
                        }


                        if ($this->cotModel->insertar_registros("per_perdido", $arregloDatos)) {
                            $correcto = 1;
                        } else {
                            $correcto = 2;
                        }
                    }
                }
            } else { //ES ACTUALIZACION
                $bandera_estado = $this->input->post('bandera_estado');

                if ($bandera_estado == 1) { //update a la tabla cotigacion ganada
                    $id_ganada = $this->input->post('registro_id');


                    $this->form_validation->set_rules('dato1', 'Fecha', 'trim|required|xss_clean');
                    $this->form_validation->set_rules('dato2', 'Comision_P', 'trim|required|xss_clean');
                    $this->form_validation->set_rules('dato3', 'Comision_D', 'trim|required|xss_clean');


                    if ($this->form_validation->run() == false) { //preguntar si cumple con las validaciones
                        $correcto = 2;
                    } else {

                        $arregloDatos = array(
                            'cog_id_cot' => $id_cotizacion,
                            'cog_fecha_cierre' => trim($this->input->post('dato1')),
                            'cog_comision_real_p' => trim($this->input->post('dato2')),
                            'cog_comision_real_d' => trim($this->input->post('dato3')),
                            'cog_causa_estado' => '',
                            'cog_estado' => 1,
                            'cog_usu_mod' => $this->tank_auth->get_user_id(),
                            'cog_fecha_mod' => date('Y-m-d H:i:s')
                        );
                        if ($this->cotModel->update_registros("cog_cotiz_ganada", $arregloDatos, "cog_id", $id_ganada)) {
                            $correcto = 1;
                        } else {
                            $correcto = 2;
                        }
                    }
                } else { //update a la tabla cotigacion perdida
                    $id_perdida = $this->input->post('registro_id');


                    //$this->form_validation->set_message('required', 'El campo %s es requerido');
                    $this->form_validation->set_rules('dato1', 'Fecha', 'trim|required|xss_clean');
                    $this->form_validation->set_rules('dato2', 'Precio', 'trim|xss_clean');
                    $this->form_validation->set_rules('dato3', 'Empresa', 'trim|xss_clean');


                    if ($this->form_validation->run() == false) { //preguntar si cumple con las validaciones
                        $correcto = 2;
                    } else {
                        if (trim($this->input->post('dato2')) != "") {
                            $arregloDatos = array(
                                'per_id_cot' => $id_cotizacion,
                                'per_precio' => trim($this->input->post('dato2')),
                                'per_empresa' => trim($this->input->post('dato3')),
                                'per_fecha_perdido' => trim($this->input->post('dato1')),
                                'per_causa_estado' => trim($this->input->post('dato4')),
                                'per_estado' => 1,
                                'per_usu_mod' => $this->tank_auth->get_user_id(),
                                'per_fecha_mod' => date('Y-m-d H:i:s')
                            );
                        } else {
                            $arregloDatos = array(
                                'per_id_cot' => $id_cotizacion,
                                'per_precio' => NULL,
                                'per_empresa' => trim($this->input->post('dato3')),
                                'per_fecha_perdido' => trim($this->input->post('dato1')),
                                'per_causa_estado' => trim($this->input->post('dato4')),
                                'per_estado' => 1,
                                'per_usu_mod' => $this->tank_auth->get_user_id(),
                                'per_fecha_mod' => date('Y-m-d H:i:s')
                            );
                        }


                        if ($this->cotModel->update_registros("per_perdido", $arregloDatos, "per_id", $id_perdida))
                            $correcto = 1;
                        else
                            $correcto = 2;
                    }
                }
            }

            redirect("cotizaciones/cotizaciones/cotizacion_ganada_perdida/$id_cotizacion/$correcto", null);
        } catch (exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    function imprimir_cotizacion($id_cot = null, $retornar_html = false, $envio_correo = false)
    {
        satelite_validar();
        $this->gsatelite->verificar_registro_real('cot_cotizacion', $id_cot);
        $consulta = $this->cotModel->get_cotizacion(array('cot_id' => $id_cot));

        $con_cotizacion = $this->gsatelite->get_tabla('cxz_condicionxcotizacion', array('cxz_id_cot' => $id_cot, 'cxz_estado' => 1));
        $condiciones = $this->gsatelite->get_tabla('cod_condicion', array('cod_estado' => 1));

        $var = array();

        foreach ($con_cotizacion as $key => $value) {
            foreach ($condiciones as $key2 => $value2) {
                if ($value['cxz_id_cod'] == $value2['cod_id']) {
                    $var[] = $value2['cod_nombre'];
                }
            }
        }
        $decimales_par = $this->gsatelite->get_parametro('NUMERO_DECIMALES');
        $data['decimales'] = (trim($decimales_par) != '') ? $decimales_par : 2;

        //Se verifica si se detalla impuesto o no.
        //$data['opc_impuesto']=$opc_imp;
        $data['opc_impuesto'] = $this->gsatelite->get_campo('cot_cotizacion', 'cot_detalle_imp', array('cot_id' => $id_cot));

        $condicion_cadena = implode(", ", $var);
        $data['condicion_cadena'] = $condicion_cadena;
        // Trabajando
        $data["consulta"] = $consulta;
        $data["detalle_productos"] = $this->cotModel->get_detalle_productos(array('axc_id_cot' => $id_cot, 'axc_estado' => 1));

        $html_2 = '';
        if ($this->gsatelite->get_parametro('COT_APLICA_TITULO') == 1) {
            $html = $this->load->view('reporte/header', array('titulo' => "Cotización", 'apl_titulo' => ''), true);
            $data['header2'] = $html;
        } else {
            $html = $this->load->view('reporte/header', array('titulo' => "Cotización"), true);
            $data['header2'] = $html;
        }

        $data['esreporte'] = true;

        $html .= $this->load->view('cotizaciones/cotizaciones/imprimir_cotizacion', $data, true);
        if ($retornar_html) {
            return $html;
        } else {
            //echo $html; die();exit();
            //nombre del pdf
            $meses = array('', 'ene', 'feb', 'mar', 'abr', 'may', 'jun', 'jul', 'ago', 'sep', 'oct', 'nov', 'dic');
            $part1 = str_replace(' ', '_', trim($consulta[0]['cli_nombre']));
            $part2 = (trim($consulta[0]['cot_fecha_pres']) != "") ? $meses[intval(date('m', strtotime($consulta[0]['cot_fecha_pres'])))] : "";
            $part3 = (trim($consulta[0]['cot_fecha_pres']) != "") ? date('d', strtotime($consulta[0]['cot_fecha_pres'])) : "";
            $part4 = str_replace(' ', '_', substr(trim($consulta[0]['cot_concepto']), 0, 10));
            $part5 = trim($consulta[0]['cot_codigo']);
            $nombre_pdf = $part1 . '.' . $part2 . '.' . $part3 . '.' . $part4 . '.' . $part5;
            $this->load->library('Pdf'); //libreria pdf
            //$GLOBALS['pie_cotizacion'] = 1;
            if ($this->gsatelite->get_parametro('COT_APLICA_PIE_PAGINA') == 1) {
                $GLOBALS['es_cotizacion'] = 1;
                $this->pdf->setPrintFooter(true);
            } else {
                $this->pdf->setPrintFooter(true);
            }
            if ($envio_correo) {
                //$this->session->set_flashdata('nombre_pdf_cotizacion',$nombre_pdf);
                $this->session->set_userdata('nombre_pdf_cotizacion', $nombre_pdf . '.pdf');
                $this->pdf->makePDF_cotizacion($html, 'P', $nombre_pdf, 'Letter', 'F');
            } else {
                $this->pdf->makePDF_cotizacion($html, 'P', $nombre_pdf, 'Letter', 'I');
            }
        }
    }

    function imprimir_cotizacion_larga($id_cot = null){
        satelite_validar(true);
        $this->imprimir_cotizacion2($id_cot, false, false, true);
    }

    function imprimir_cotizacion2($id_cot = null, $retornar_html = false, $envio_correo = false, $cot_completa = false)
    {
        satelite_validar();
        $cot_completa = $cot_completa?"completa_":'';
        $this->gsatelite->verificar_registro_real('cot_cotizacion', $id_cot);
        $consulta = $this->cotModel->get_cotizacion(array('cot_id' => $id_cot));
        $con_cotizacion = $this->gsatelite->get_tabla('cxz_condicionxcotizacion', array('cxz_id_cot' => $id_cot, 'cxz_estado' => 1));
        $condiciones = $this->gsatelite->get_tabla('cod_condicion', array('cod_estado' => 1));

        $var = array();

        foreach ($con_cotizacion as $key => $value) {
            foreach ($condiciones as $key2 => $value2) {
                if ($value['cxz_id_cod'] == $value2['cod_id']) {
                    $var[] = $value2['cod_nombre'];
                }
            }
        }
        $decimales_par = $this->gsatelite->get_parametro('NUMERO_DECIMALES');
        $data['decimales'] = (trim($decimales_par) != '') ? $decimales_par : 2;

        //Se verifica si se detalla impuesto o no.
        //$data['opc_impuesto']=$opc_imp;
        $data['opc_impuesto'] = $this->gsatelite->get_campo('cot_cotizacion', 'cot_detalle_imp', array('cot_id' => $id_cot));

        $condicion_cadena = implode(", ", $var);
        $data['condicion_cadena'] = $condicion_cadena;
        $data['iva'] = $this->cotModel->impuesto_cot(array('cot_id' => $id_cot), 'IVA');
        $data["consulta"] = $consulta;
        $data["detalle_productos"] = $this->cotModel->get_detalle_productos(array('axc_id_cot' => $id_cot, 'axc_estado' => 1));
        $data['datos_emp'] = $this->gsatelite->get_tabla('emr_empresa', array('emr_id' => $this->tank_auth->get_empresa_id()));
        //se buscara el parametro para elegir el formato de cotizacion.
        $parametro = $this->gsatelite->get_parametro("SYS_FORMATO_IMPRESION_COTIZACION", 0);


        //$parametro = 2; //variable para testear.
        // si parametro es 0 : default.
        // si parametro es 1 : Maya.
        // si parametro es 2 : TROQUELES.
        // si parametro es 3 : intervision.
        // si parametro es 4 : caisa.
        // si parametro es 5 : espumar.
        // Si parametro es 6 : Arca.
        // Si parametro es 7 : Posada.
        // Si parametro es 10 : PREFASA.
        // Si parametro es 11 : INSTRUQUIMICA.
        if ($parametro != 0) {
            $html .= $this->load->view('cotizaciones/cotizaciones/'.$cot_completa.'cotizacion_personalizada' . $parametro, $data, true);
        } else {
            if ($this->gsatelite->get_parametro('COT_APLICA_TITULO') == 1) {
                $html = $this->load->view('reporte/header', array('titulo' => "Cotización", 'apl_titulo' => ''), true);
                $data['header2'] = $html;
            } else {
                $html = $this->load->view('reporte/header', array('titulo' => "Cotización"), true);
                $data['header2'] = $html;
            }
            $data['esreporte'] = true;
            $html .= $this->load->view('cotizaciones/cotizaciones/imprimir_cotizacion2', $data, true);
        }
        if ($retornar_html) {
            return $html;
        } else {
            //nombre del pdf
            $meses = array('', 'ene', 'feb', 'mar', 'abr', 'may', 'jun', 'jul', 'ago', 'sep', 'oct', 'nov', 'dic');
            $part1 = str_replace(' ', '_', $consulta[0]['cli_nombre']);
            $part2 = $meses[intval(date('m', strtotime($consulta[0]['cot_fecha_pres'])))];
            $part3 = date('d', strtotime($consulta[0]['cot_fecha_pres']));
            $part4 = str_replace(' ', '_', substr($consulta[0]['cot_concepto'], 0, 10));
            $part5 = $consulta[0]['cot_codigo'];
            $nombre_pdf = $part1 . '.' . $part2 . '.' . $part3 . '.' . $part4 . '.' . $part5;
            $this->load->library('Pdf'); //libreria pdf
            //$GLOBALS['pie_cotizacion'] = 1;
            $this->pdf->setPrintHeader(false);


            if ($this->gsatelite->get_parametro('COT_APLICA_PIE_PAGINA') == 1) {
                $GLOBALS['es_cotizacion'] = 10;
                $this->pdf->setPrintFooter(true);
            } else {
                $this->pdf->setPrintFooter(false);
            }
            if ($envio_correo) {

                $this->session->set_userdata('nombre_pdf_cotizacion', $nombre_pdf . '.pdf'); 

                if ($parametro == 11) {
                    $GLOBALS['es_cotizacion'] = 11;
                    $this->pdf->setPrintHeader(true);
                    $this->pdf->setPrintFooter(true);
                    $nombre_pdf = $part5 . '.' . $part4;
                    $this->pdf->makePDF_cotizacion($html, 'P', $nombre_pdf, 'Letter', 'F', 30);
                }else{
                    $this->pdf->makePDF_cotizacion($html, 'P', $nombre_pdf, 'Letter', 'F');
                }

                //$this->session->set_flashdata('nombre_pdf_cotizacion',$nombre_pdf);
                
                
            } else {

                if ($parametro == 11) {
                    $GLOBALS['es_cotizacion'] = 11;
                    $this->pdf->setPrintHeader(true);
                    $this->pdf->setPrintFooter(true);
                    $nombre_pdf = $part5 . '.' . $part4;
                    $this->pdf->makePDF_cotizacion($html, 'P', $nombre_pdf, 'Letter', 'I', 30);
                }else{
                    $this->pdf->makePDF_cotizacion($html, 'P', $nombre_pdf, 'Letter', 'I');
                }

                
            }
            unset($GLOBALS['es_cotizacion']);
        }
    }

    function obtener_tipo_persona()
    {
        $id = $this->input->post('id');
        $registro = $this->gsatelite->get_registro('cli_cliente', 'cli_id', $id);
        $tp = ($registro->cli_personeria == 1) ? 'Persona Jurídica' : 'Persona Natural';
        die(json_encode(array('tipo_per' => $tp)));
    }

    function get_caracteristicas_productos()
    {
        $fila_correlativo = $this->input->post('fila_corralativa');
        $id_producto = $this->input->post('id_product');
        $registro = $this->gsatelite->get_registro('art_articulo', 'art_id', $id_producto);
        $this->db->join('car_caracteristica', 'car_id=cxr_id_car');
        //$this->db->where('car_modulo',3); //el tres es del modulo cotizacion
        $data['consulta'] = $this->gsatelite->get_tabla('cxr_caractxtipo_articulo', array('cxr_id_tia' => $registro->art_id_tia, 'cxr_estado' => 1));

        $data['producto'] = $id_producto;
        $data['fila'] = $fila_correlativo;
        $html = $this->load->view('cotizaciones/cotizaciones/cotizaciones_form_caracteristicas', $data, true);
        //die($html);
        echo json_encode(array('formulario' => $html));
    }

    function get_precio_producto()
    {
        $cantidad = $this->input->post('cantidad');
        $id_producto = $this->input->post('id_product');
        $consulta = $this->gsatelite->get_tabla('lip_listado_precio', array('lip_id_art' => $id_producto));
        $precio = 0;
        foreach ($consulta as $f) {
            if ($cantidad >= $f['lip_desde'] and $cantidad <= $f['lip_hasta'] and $precio == 0) {
                $precio = $f['lip_precio'];
            }
        }
        echo json_encode(array('precio' => $precio));
    }

    function get_impuesto_cliente($cliente = null)
    {
        $id = ($cliente != null) ? $cliente : $this->input->post('id');
        $opciones = '';

        // Permite cargar solo los impuestos relacionados con el cliente.
        /* $this->db->join('imp_impuesto','imp_id=ixc_id_imp');
          $preguntar=  $this->gsatelite->get_tabla('ixc_impuestoxcliente',array('ixc_id_cli'=>$id));
         */
        $prueba = $this->cotModel->impuesto_cliente($id);

        $seleccionados = array();
        foreach ($prueba as $f) {
            $seleccionados[] = $f['ixc_id_cli'];
        }
        $sum = array_sum($seleccionados);

        foreach ($prueba as $f) {
            if ($sum > 0) {
                if ($f['ixc_id_cli'] > 0) {
                    $selected = 'selected';
                } else {
                    $selected = '';
                }
            }

            if ($sum <= 0) {
                if ($selected == '' && $f['imp_defecto'] == 1 && $f['ixc_id_cli'] == '') {
                    $defecto = 'selected';
                } else {
                    $defecto = '';
                }
            }

            if ($selected == '') {
                $result = $defecto;
            } else {
                $result = $selected;
            }

            $display = $f['imp_nombre'] . ' (' . $f['imp_porcentaje'] . ' % )';
            $opciones .= '<option value="' . $f['imp_id'] . '" id_imp="' . $f['ixc_id_imp'] . '" porcentaje="' . $f['imp_porcentaje'] . '" ' . $result . '  >' . $display . '</option>';
        }

        if ($cliente != null) {
            return $opciones;
        }
        echo json_encode(array('opc_imp' => $opciones));
    }

    //rené castaneda
    function enviar_cotizacion_correo($id = null)
    {
        if ($id != null) {

            //Preguntar por el vendedor
            $this->gsatelite->verificar_registro_real('cot_cotizacion', $id);
            $registro_cot = $this->gsatelite->get_registro('cot_cotizacion', 'cot_id', $id);
            $registro_ven = $this->gsatelite->get_registro('ven_vendedor', 'ven_id', $registro_cot->cot_id_ven);
            $registro_cli = $this->gsatelite->get_registro('cli_cliente', 'cli_id', $registro_cot->cot_id_cli);

            //preguntar por los contactos de la cotizacion.
            //y extraer los emails de los mismos.
            $this->db->join('con_contacto', 'con_id=cxt_id_con');
            $contactos_cotiz = $this->gsatelite->get_tabla('cxt_contactoxcotizacion', array('cxt_id_cot' => $id));
            $correos_involucrados = array(); //el array ya contiene un elemento (el correo del cliente)
            if ($registro_cli->cli_email != "") {
                $correos_involucrados[] = $registro_cli->cli_email;
            }
            foreach ($contactos_cotiz as $f) {
                if ($f['con_email'] != "") {
                    $correos_involucrados[] = $f['con_email'];
                }
            }

            if ($registro_ven->ven_email != "" and count($correos_involucrados) > 0) {
                //obtener el detalle de la cotización
                $corre_ven = $registro_ven->ven_email;
                $nombre_ven = $registro_ven->ven_nombre . ' ' . $registro_ven->ven_apellidos;
                $corre_cli = $registro_cli->cli_email;
                $asunto = "DETALLE COTIZACIÓN";
                $mensaje = $this->imprimir_cotizacion($id, true);

                $this->imprimir_cotizacion2($id, false, true);
                //$ruta_adjunto = base_url('amueblados_sa_de_cv.dic.29.esta_es_un.13'.'.pdf');
                //die($ruta_adjunto);
                $ruta_adjunto = "";
                if ($this->session->userdata('nombre_pdf_cotizacion') != "") {
                    $r_pdf = $this->session->userdata('nombre_pdf_cotizacion');
                    $this->session->unset_userdata('nombre_pdf_cotizacion');
                    $ruta_adjunto = FCPATH . $r_pdf;
                }
                //$ruta_adjunto= FCPATH.'amueblados_sa_de_cv.dic.29.esta_es_un.13'.'.pdf';
                //descomentar esta linea y comentar la de abajo (cuando ya este en produccion )

                $estado = $this->gsatelite->envio_correo($corre_ven, $nombre_ven, $correos_involucrados, $asunto, $mensaje, $corre_ven, $ruta_adjunto); //melbin.cruz40@gmail.com //sairamelara@hotmail.com


                //$estado =  $this->gsatelite->envio_correo('leovilla7777@gmail.com','Saira (Vendedora)','reymundo0792@hotmail.com',$asunto,$mensaje,null,$ruta_adjunto);
                if ($estado) {
                    if ($ruta_adjunto != "") {
                        unlink($ruta_adjunto);
                    }
                    return 1;
                }
            } else {
                return 0;
            }
        } else {
            return 0;
        }
    }

    //René Castaneda
    function reenvia_correo_cotizacion()
    {
        $id = $this->input->post('id');
        $exito = $this->enviar_cotizacion_correo($id);
        die(json_encode(array('exito' => $exito)));
    }

    // function gestion_listado_precios() {
    //     satelite_validar();
    //     $permisos = $this->gsatelite->get_permisos_opcion();
    //     $where_articulo =  array('art_estado' => 1, 'art_venta' => 1);
    //     $id_cat = null;
    //     if ($_POST) {
    //         $id_art = ($this->input->post('slcProducto') > 0) ? $this->input->post('slcProducto') : null;
    //         $id_cat = ($this->input->post('slcCategory') > 0) ? $this->input->post('slcCategory') : null;
    //         if ($id_art) {
    //             $where_articulo['art_id'] = $id_art;
    //             $data_articulo = $this->gsatelite->get_tabla('art_articulo', array('art_id' => $id_art));
    //             $data['art'] = $data_articulo[0];
    //         }            
    //         if ($id_cat) {
    //             $ids_categorias = array($id_cat);
    //             $tia_hijas = $this->gsatelite->get_tabla('tia_tipo_articulo',array('tia_padre' => $id_cat, 'tia_estado' => 1));
    //             if (count($tia_hijas) > 0) {
    //                 foreach ($tia_hijas as $k => $f) {
    //                     $ids_categorias[] = $f['tia_id'];
    //                     $tia_nietas = $this->gsatelite->get_tabla('tia_tipo_articulo',array('tia_padre' => $f['tia_id'], 'tia_estado' => 1));
    //                     if (count($tia_nietas) > 0) {
    //                         foreach ($tia_nietas as $k2 => $f2) {
    //                             $ids_categorias[] = $f2['tia_id'];
    //                         }
    //                     }
    //                 }
    //             }
    //             $ids_finales = implode(',', $ids_categorias);
    //             $where_articulo["art_id_tia IN ($ids_finales)"] = null;
    //         }
    //     }
    //              $this->db->group_by('tia_id');
    //              $this->db->join('art_articulo', 'art_id_tia = tia_id');
    //     $categ = $this->gsatelite->get_dropdown('tia_tipo_articulo', '{tia_codigo} - {tia_nombre}', '', array('art_estado' => 1, 'art_venta' => 1, 'tia_estado'=>1), $id_cat, null, null, true);
    //     $data['categorias'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $categ);
    //     $data['tabla_art'] = $this->gsatelite->get_tabla('art_articulo', $where_articulo);
    //     $data['titulo_personal'] = "Listado de Precios por Producto";
    //     cargarvista($data);
    // }
    public function gestion_listado_precios()
    {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion('cotizaciones/cotizaciones/gestion_listado_precios');
        $crud = new grocery_CRUD();
        $alias = array(
            'tlp_nombre' => 'Nombre',
            'tlp_descripcion' => 'Descripción',
            'tlp_estado' => 'Estado'
        );
        $colums = array(
            'tlp_nombre',
            'tlp_descripcion',
            'tlp_estado'
        );
        $crud->set_table('tlp_tipo_lista_precio')
            ->display_as($alias)
            ->columns($colums)
            ->unset_add()
            ->unset_delete()
            ->unset_read()
            ->unset_edit();
        $crud->field_type('tlp_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        if ($permisos['permite_agregar'] > 0) {
            $crud->add_action(' Artículos por lista', '', 'cotizaciones/cotizaciones/articulos_lista_precio', 'silk-icon-checklist');
        }
        $crud->add_action(' Exportar Lista', '', 'cotizaciones/cotizaciones/export_plantilla', 'silk-icon-download plantilla');
        $output = $crud->render();
        $data['permisos'] = $permisos;
        $data['titulo_personal'] = "Gestión de Precios por Lista";
        $this->_cargarvista($data, $output);
    } ////////////////////////////////////////

    public function articulos_lista_precio($tipo_lista)
    {
        satelite_validar();
        ini_set('memory_limit', '1024M');
        ini_set('max_execution_time', '9999');
        $id_cat = $id_mrp = null;
        $muestrabtn = 0;
        $permisos = $this->gsatelite->get_permisos_opcion('cotizaciones/cotizaciones/gestion_listado_precios');

                    $this->db->group_by('lip_id_art');
        $products = $this->gsatelite->get_tabla('lip_listado_precio', array('lip_estado' => 1, 'lip_id_tlp' => $tipo_lista));
        $art_x_lista = (count($products) > 0) ? array_column($products, 'lip_id_art') : array(0);
        $where_articulo =  array('art_estado' => 1, 'art_venta' => 1);
        if ($_POST) {
            $id_cat = ($this->input->post('slcCategory') > 0) ? $this->input->post('slcCategory') : null;
            $id_mrp = ($this->input->post('slcMarcaProd') > 0) ? $this->input->post('slcMarcaProd') : null;
            $muestrabtn = ($id_cat || $id_mrp) ? 1 : 0;
        }
        $this->db->where_in('art_id', $art_x_lista);
        $this->db->join('art_articulo', 'art_id_tia = tia_id');
        $catg = $this->gsatelite->get_dropdown('tia_tipo_articulo', '{tia_codigo} - {tia_nombre}', '', array('art_estado' => 1, 'art_venta' => 1, 'tia_estado' => 1), $id_cat, null, null, true);

        $this->db->where_in('art_id', $art_x_lista);
        $this->db->join('art_articulo', 'art_id_mrp = mrp_id');
        $mrps = $this->gsatelite->get_dropdown('mrp_marca_producto', '{mrp_codigo} - {mrp_nombre}', '', array('art_estado' => 1, 'art_venta' => 1, 'mrp_estado' => 1), $id_mrp, null, null, true);
        $data['categorias'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $catg);
        $data['marca_prod'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $mrps);
        if ($id_cat) {
            $where_articulo["art_id_tia"] = $id_cat;
        }
        if ($id_mrp) {
            $where_articulo["art_id_mrp"] = $id_mrp;
        }
                             $this->db->where_in('art_id', $art_x_lista);
        $data['tabla_art'] = $this->db->select("art_id, art_codigo, art_nombre")->from('art_articulo')->where($where_articulo)->get()->result_array();
        $data['mostrar_btn'] = $muestrabtn;
        $data['titulo_personal'] = "Artículos por Lista de Precio";
        $data['tipo_lista'] = $tipo_lista;
        cargarvista($data);
    } //////////////////////////////////////////

    // public function precios_articulo($id_art){
    //     satelite_validar();
    //     $this->gsatelite->verificar_registro_real('art_articulo', $id_art);
    //     $id_art = $this->uri->segment(4);
    //     $crud = new grocery_CRUD();
    //     $where = null;
    //     $data['id_articulo'] = ($id_art > 0) ? $id_art : 0;
    //     // Verificar si vienen datos por POST
    //     if ($this->input->post()) {
    //         $tipo = $this->input->post('slcTipo');
    //         if ($tipo > 0) {
    //             $where['tlp_id'] = $tipo;
    //         }
    //     }
    //     if (isset($where)) {
    //         $crud->where($where);
    //     }
    //     $add_fields = array(
    //         'lip_id_art',
    //         'lip_id_tlp',
    //         'lip_desde',
    //         'lip_hasta',
    //         'lip_descuento_min',
    //         'lip_descuento_max',
    //         'lip_precio',
    //         'lip_id_mep',
    //         'lip_ultimo_prec_compra',
    //         'lip_variacion_utilidad',
    //         'lip_venta_minima',
    //         'lip_estado',
    //         'lip_usu_creacion',
    //         'lip_fecha_creacion',
    //         'lip_usu_modificacion',
    //         'lip_fecha_modificacion'
    //     );
    //     $edit_fields = array(
    //         'lip_id_art',
    //         'lip_id_tlp',
    //         'lip_desde',
    //         'lip_hasta',
    //         'lip_descuento_min',
    //         'lip_descuento_max',
    //         'lip_precio',
    //         'lip_id_mep',
    //         'lip_ultimo_prec_compra',
    //         'lip_variacion_utilidad',
    //         'lip_venta_minima',
    //         'lip_estado',
    //         'lip_usu_modificacion',
    //         'lip_fecha_modificacion'
    //     );
    //     $colum_fields = array(
    //         'lip_desde',
    //         'lip_hasta',
    //         'lip_id_mep',
    //         'lip_precio',
    //         'lip_descuento_min',
    //         'lip_descuento_max',
    //         'lip_venta_minima',
    //         'lip_id_tlp',
    //         'lip_estado'
    //     );
    //     $required = array(
    //         'lip_id_tlp',
    //         'lip_id_art',
    //         'lip_desde',
    //         'lip_hasta',
    //         'lip_precio',
    //         'lip_estado',
    //         'lip_id_mep',
    //         'lip_descuento_min',
    //         'lip_descuento_max'
    //     );
    //     $display_as = array(
    //         'lip_desde'         => 'Cantidad Desde',
    //         'lip_hasta'         => 'Cantidad Hasta',
    //         'lip_descuento_min' => 'Porcentaje Minimo',
    //         'lip_descuento_max' => 'Porcentaje Maximo',
    //         'lip_precio'        => 'Precio',
    //         'lip_ultimo_prec_compra' => 'Precio última compra',
    //         'lip_variacion_utilidad' => '% Variación utilidad',
    //         'lip_estado'        => 'Estado',
    //         'lip_id_mep'        => 'Unidad',
    //         'lip_id_tlp'        => 'Tipo lista',
    //         'lip_venta_minima'  => 'Minimo de Venta'
    //     );
    //     $crud->set_table('lip_listado_precio')
    //         ->set_subject('Precio Producto')
    //         ->where('lip_id_art', $id_art)
    //         ->columns($colum_fields)
    //         ->add_fields($add_fields)
    //         ->edit_fields($edit_fields)
    //         ->display_as($display_as)
    //         ->set_relation('lip_id_tlp', 'tlp_tipo_lista_precio', '{tlp_nombre}', array('tlp_estado' => 1))
    //         ->required_fields($required)
    //         ->set_rules('lip_desde', 'Cantidad Desde', 'trim|is_numeric|required|callback_validacion_rango|callback_validar_cant_desde_hasta_lista')
    //         ->set_rules('lip_hasta', 'Cantidad Hasta', 'trim|required|is_numeric')
    //         ->set_rules('lip_venta_minima', 'Minimo de Venta', 'trim|is_numeric')
    //         ->set_rules('lip_descuento_min', 'Porcentaje Minimo', 'trim|required|is_numeric')
    //         ->set_rules('lip_descuento_max', 'Porcentaje Maximo', 'trim|required|is_numeric')
    //         ->set_rules('lip_precio', 'Precio', 'trim|required|is_numeric')
    //         ->field_type('lip_id_art', 'hidden', $id_art)
    //         ->field_type('lip_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
    //         ->field_type('lip_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
    //     ;
    //     $crud->callback_edit_field('lip_id_mep', array($this, 'edit_lip_id_mep_for_article'));
    //     $crud->callback_add_field('lip_id_mep', array($this, 'edit_lip_id_mep_for_article'));
    //     if (end(explode('/', uri_string())) == 'add') {
    //         $crud->set_relation('lip_id_mep', 'mep_medida_producto', '{mep_nombre}', array('mep_estado' => '1'));
    //         $crud->field_type('lip_estado', 'hidden', 1);
    //         $crud->field_type('lip_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
    //         $crud->field_type('lip_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
    //     } else {
    //         $crud->set_relation('lip_id_mep', 'mep_medida_producto', '{mep_nombre}', array('mep_estado' => '1'));
    //         $crud->field_type('lip_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
    //     }
    //     $name_articulo = $this->gsatelite->get_tabla('art_articulo', array('art_id' => $id_art));
    //     $data['titulo_personal'] = "Listado de Precios - " . $name_articulo[0]['art_nombre'];
    //     $data['registro_art'] = $this->gsatelite->get_registro('art_articulo', 'art_id', $id_art);
    //     // Enviar url
    //     $data['url'] = explode('/', uri_string());
    //     // Datos para filtro de tipo de lista
    //     $tipo_lista = $this->gsatelite->get_dropdown('tlp_tipo_lista_precio', '{tlp_nombre}', '', array('tlp_estado' => '1'), null, '', 'tlp_id', true);
    //     $data["tipo_lista"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $tipo_lista);
    //     $output = $crud->render();
    //     cargarvista($data, $output);
    // }
    public function precios_articulo($id_art, $id_tlp)
    {
        satelite_validar();
        $this->gsatelite->verificar_registro_real('art_articulo', $id_art);
        $this->producto = $this->gsatelite->get_tabla('art_articulo', array('art_id' => $id_art))[0];
        $crud = new grocery_CRUD();
        $add_fields = array(
            'lip_id_art',
            'lip_id_tlp',
            'lip_desde',
            'lip_hasta',
            'lip_descuento_min',
            'lip_descuento_max',
            'lip_precio',
            'lip_id_mep',
            'lip_id_cva',
            'lip_ultimo_prec_compra',
            'lip_variacion_utilidad',
            'lip_venta_minima',
            'lip_estado',
            'lip_usu_creacion',
            'lip_fecha_creacion',
            'lip_usu_modificacion',
            'lip_fecha_modificacion'
        );
        $edit_fields = array(
            'lip_id_art',
            'lip_id_tlp',
            'lip_desde',
            'lip_hasta',
            'lip_descuento_min',
            'lip_descuento_max',
            'lip_precio',
            'lip_id_mep',
            'lip_id_cva',
            'lip_ultimo_prec_compra',
            'lip_variacion_utilidad',
            'lip_venta_minima',
            'lip_estado',
            'lip_usu_modificacion',
            'lip_fecha_modificacion'
        );
        $colum_fields = array(
            'lip_desde',
            'lip_hasta',
            'lip_id_mep',
            'lip_precio',
            'lip_descuento_min',
            'lip_descuento_max',
            'lip_venta_minima',
            'lip_estado'
        );
        $required = array(
            'lip_id_tlp',
            'lip_id_art',
            'lip_desde',
            'lip_hasta',
            'lip_precio',
            'lip_estado',
            'lip_id_mep',
            'lip_descuento_min',
            'lip_descuento_max'
        );
        $display_as = array(
            'lip_desde'         => 'Cantidad Desde',
            'lip_hasta'         => 'Cantidad Hasta',
            'lip_descuento_min' => 'Porcentaje Mínimo',
            'lip_descuento_max' => 'Porcentaje Máximo',
            'lip_precio'        => 'Precio',
            'lip_ultimo_prec_compra' => 'Precio última compra',
            'lip_variacion_utilidad' => '% Variación utilidad',
            'lip_estado'        => 'Estado',
            'lip_id_mep'        => 'Unidad',
            'lip_venta_minima'  => 'Mínimo de Venta'
        );
        $crud->set_table('lip_listado_precio')
            ->set_subject('Precios por Producto')
            ->where('lip_id_art', $id_art)
            ->where('lip_id_tlp', $id_tlp)
            ->where('lip_estado >= ', 0)//LISTAS DE PRECIOS "ELIMINADAS" AL CARGAR EN EXCEL SE QUEDARAN CON ESTADO MENOS 1 SI TIENEN INTEGRIDAD RELACIONAL
            ->columns($colum_fields)
            ->add_fields($add_fields)
            ->edit_fields($edit_fields)
            ->display_as($display_as)
            ->required_fields($required)
            ->set_rules('lip_desde', 'Cantidad Desde', 'trim|is_numeric|required|callback_validacion_rango|callback_validar_cant_desde_hasta_lista')
            ->set_rules('lip_hasta', 'Cantidad Hasta', 'trim|required|is_numeric')
            ->set_rules('lip_venta_minima', 'Minimo de Venta', 'trim|is_numeric')
            ->set_rules('lip_descuento_min', 'Porcentaje Minimo', 'trim|required|is_numeric')
            ->set_rules('lip_descuento_max', 'Porcentaje Maximo', 'trim|required|is_numeric')
            ->set_rules('lip_precio', 'Precio', 'trim|required|is_numeric')
            ->field_type('lip_id_art', 'hidden', $id_art)
            ->field_type('lip_id_tlp', 'hidden', $id_tlp)
            ->field_type('lip_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
            ->field_type('lip_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
        $crud->field_type('lip_id_cva', 'hidden');
        $crud->callback_edit_field('lip_id_mep', array($this, 'edit_lip_id_mep_for_article'));
        $crud->callback_add_field('lip_id_mep', function(){
                       $this->db->join('cva_conversion_articulo', 'cva_id_mep = mep_id');
            $ums_art = $this->gsatelite->get_dropdown('mep_medida_producto','{mep_nombre}','',array('cva_id_art'=>$this->producto['art_id'],'cva_estado'=>1,'mep_estado'=>1),null,'','mep_id', true);
            $um_ligada_articulo = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $ums_art);
            $js = '<script type="text/javascript">$("#field-lip_id_mep").select2();</script>';
            return '<select id="field-lip_id_mep" name="lip_id_mep" class="nostyle chosen-select" data-placeholder="Unidad" style="width: 100%;">' . $um_ligada_articulo . '</select>' . $js;
        });
        $crud->callback_edit_field('lip_id_cva', function ($value, $primary_key) {
            return '<input id="field-lip_id_cva" type="hidden" name="lip_id_cva" value="'.$value.'">';
        });
        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('lip_estado', 'hidden', 1);
            $crud->field_type('lip_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->field_type('lip_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
        } else {
            $crud->set_relation('lip_id_mep', 'mep_medida_producto', '{mep_nombre}', array('mep_estado' => '1'));
            $crud->field_type('lip_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }
        $name_articulo = $this->gsatelite->get_tabla('art_articulo', array('art_id' => $id_art));
        $data['titulo_personal'] = "Listado de Precios - " . $name_articulo[0]['art_nombre'];
        $data['registro_art'] = $this->gsatelite->get_registro('art_articulo', 'art_id', $id_art);
        $data['tpl'] = $id_tlp;
        $data['url'] = explode('/', uri_string());
        $output = $crud->render();
        cargarvista($data, $output);
    } ///////////////////////////////////////////

    // function validar_cant_desde_hasta_lista(){
    //     $this->load->library('form_validation');
    //     $id_articulo = $this->uri->segment(4);
    //     $id = $this->uri->segment(6) != "" ? $this->uri->segment(6) : 0;
    //     $c_desde = $this->input->post('lip_desde');
    //     $c_hasta = $this->input->post('lip_hasta');
    //     $id_tlp = ($this->input->post('lip_id_tlp') > 0) ? $this->input->post('lip_id_tlp') : 0;
    //     $id_mep = $this->input->post('lip_id_mep');
    //     $valido = true;
    //     $where = "lip_id != " . $id . " AND lip_id_mep = " . $id_mep . " AND lip_id_art = " . $id_articulo . " AND lip_id_tlp = " . $id_tlp . " 
    //     AND ( ( " . $c_desde . " BETWEEN lip_desde AND lip_hasta ) OR ( " . $c_hasta . " BETWEEN lip_desde AND lip_hasta ) )";
    //     $query = $this->cotModel->comprobar_cantidad_desde_hasta_por_lista($where);
    //     if (count($query) == 0) {
    //         return true;
    //     } else {
    //         $this->form_validation->set_message('validar_cant_desde_hasta_lista', 'La cantidad desde y hasta ya estan registradas en este tipo de lista.');
    //         return false;
    //     }
    // }
    function validar_cant_desde_hasta_lista()
    {
        $this->load->library('form_validation');
        $id_articulo = $this->uri->segment(4);
        $id = $this->uri->segment(7) != "" ? $this->uri->segment(7) : 0;
        $c_desde = $this->input->post('lip_desde');
        $c_hasta = $this->input->post('lip_hasta');
        $id_tlp = ($this->input->post('lip_id_tlp') > 0) ? $this->input->post('lip_id_tlp') : 0;
        $id_mep = $this->input->post('lip_id_mep');
        $valido = true;
        $where = "lip_id != " . $id . " AND lip_id_mep = " . $id_mep . " AND lip_id_art = " . $id_articulo . " AND lip_id_tlp = " . $id_tlp . " 
        AND ( ( " . $c_desde . " BETWEEN lip_desde AND lip_hasta ) OR ( " . $c_hasta . " BETWEEN lip_desde AND lip_hasta ) )";
        $query = $this->facturacion_model->comprobar_cantidad_desde_hasta_por_lista($where);
        if (count($query) > 0) {
            $this->form_validation->set_message('validar_cant_desde_hasta_lista', 'La cantidad desde y hasta ya estan registradas en este tipo de lista.');
            return false;
        } else {
            return true;
        }
    } //////////////////////////////////////////

    // function edit_lip_id_mep_for_article($value, $primary_key){
    //     $id_art = $this->uri->segment(4);
    //     $ids = $this->gsatelite->get_tabla('cva_conversion_articulo', array('cva_id_art' => $id_art));
    //     $array_days = array();
    //     $um_ligada_articulo = '';
    //     for ($i = 0; $i < count($ids); $i++) {
    //         array_push($array_days, $ids[$i]["cva_id_mep"]);
    //         $um_ligada_articulo .= $this->gsatelite->get_dropdown('mep_medida_producto', '{mep_nombre}', '', array('mep_estado'=>1,'mep_id'=>(int) $ids[$i]["cva_id_mep"]), null, '', 'mep_id', true);
    //         $um_ligada_articulo = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $um_ligada_articulo);
    //     }
    //     $js = '<script>$(\'select[name="lip_id_mep"] option[value="' . $value . '"]\').attr("selected", "selected");</script>';
    //     return '<select id="field-lip_id_mep" name="lip_id_mep" class="nostyle chosen-select" data-placeholder=" Unidad" style="width: 100%; display: none;">'.$um_ligada_articulo.'</select>'.$js;
    // }
    function edit_lip_id_mep_for_article($value, $primary_key)
    {
        $id_art = $this->uri->segment(4);
        $ids = $this->gsatelite->get_tabla('cva_conversion_articulo', array('cva_id_art' => $id_art));
        $array_days = array();
        $um_ligada_articulo = '<option value=""></option>';
        for ($i = 0; $i < count($ids); $i++) {
            array_push($array_days, $ids[$i]["cva_id_mep"]);
            $ums_ligada_articulo = $this->gsatelite->get_dropdown('mep_medida_producto', '{mep_nombre}', '', array('mep_estado' => 1, 'mep_id' => (int) $ids[$i]["cva_id_mep"]), null, '', 'mep_id', true);
            $um_ligada_articulo .= str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $ums_ligada_articulo);
        }
        $js = ($value) ? '<script>$(\'select[name="lip_id_mep"] option[value="' . $value . '"]\').attr("selected", "selected");</script>' : '<script>$("#field-lip_id_mep").select2();</script>';
        return '<select id="field-lip_id_mep" name="lip_id_mep" class="nostyle chosen-select" data-placeholder=" Unidad" style="width: 100%; display: ;">' . $um_ligada_articulo . '</select>' . $js;
    } ///////////////////////////////////////////

    public function add_article_list($id_tlp)
    {
        satelite_validar();
        if ($_POST) {
            $insertar = array(
                'lip_id_art' => $_POST['slcProducto'],
                'lip_id_mep' => $_POST['slc_mep_art'],
                'lip_id_tlp' => $_POST['txt_tipo_lista'],
                'lip_desde' => $_POST['txt_desde_ctdad'],
                'lip_hasta' => $_POST['txt_hasta_ctdad'],
                'lip_precio' => $_POST['txt_precio'],
                'lip_ultimo_prec_compra' => ($_POST['prec_ultima_compra'] != "") ? $_POST['prec_ultima_compra'] : null,
                'lip_variacion_utilidad' => ($_POST['varia_utilidad'] != "") ? $_POST['varia_utilidad'] : null,
                'lip_descuento_min' => ($_POST['porc_min'] != "") ? $_POST['porc_min'] : null,
                'lip_descuento_max' => ($_POST['porc_max'] != "") ? $_POST['porc_max'] : null,
                'lip_venta_minima' => ($_POST['venta_min'] != "") ? $_POST['venta_min'] : null,
                'lip_estado' => 1,
                'lip_usu_creacion' => $this->tank_auth->get_user_id(),
                'lip_fecha_creacion' => date('Y-m-d H:i:s'),
                'lip_usu_modificacion' => $this->tank_auth->get_user_id(),
                'lip_fecha_modificacion' => date('Y-m-d H:i:s')
            );
            $id_lista = $this->gsatelite->ingresar('lip_listado_precio', $insertar);
            if ($id_lista > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Listado de Precios", 'texto_alerta' => "El registro se procesó correctamente.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Listado de Precios", 'texto_alerta' => "El registro no se procesó, revise la información.");
            }
            $this->session->set_flashdata($alerta);
            if ($_POST['btnCrear'] > 0) {
                redirect('cotizaciones/cotizaciones/articulos_lista_precio/' . $_POST['txt_tipo_lista']);
            } else {
                redirect('cotizaciones/cotizaciones/add_article_list/' . $_POST['txt_tipo_lista']);
            }
        } else {
            $data['tipo_lista'] = $id_tlp;
            $data['titulo_personal'] = "Agregar Artículo a Lista";
            cargarvista($data);
        }
    } ////////////////////////////////////////////////

    public function export_plantilla($id_tpl = 0, $id_cat = 0, $id_mrp = 0)
    {
        satelite_validar();
        $nombre_tpl = $this->gsatelite->get_campo('tlp_tipo_lista_precio', 'tlp_nombre', array('tlp_id' => $id_tpl));
        $filename = 'lista_precios_' . clean_string($nombre_tpl);
        $where = array('lip_id_tlp' => $id_tpl);
        if ($id_cat > 0) {
            $where['art_id_tia'] = $id_cat;
        }
        if ($id_mrp > 0) {
            $where['art_id_mrp'] = $id_mrp;
        }
        $data['productos'] = $this->facturacion_model->plantilla_exportar_lista_precio($where);
        $html = $this->load->view('facturacion/facturar/get_listado_precios', $data, true);
        $this->load->library('excelphp');
        $this->excelphp->crear_excel($filename, $html, 0);
    } ////////////////////////////////////////////////

    // public function gestion_listado_precios_excel(){
    //     satelite_validar();
    //     if ($_FILES) {
    //         $this->load->library('excel/excel_reader.php');
    //         $excel = new Excel_reader;
    //         $excel->read($_FILES["excel_precios"]["tmp_name"]);

    //         $nr_sheets = count($excel->sheets);       // gets the number of sheets
    //         //echo var_dump($excel->sheets[0]);die();
    //         $excel_data = '';
    //         $excel->sheets[0]['cells'] = array_values($excel->sheets[0]['cells']); //reordena el array que empieza con 1 a 0
    //         unset($excel->sheets[0]['cells'][0]); // elimina la posicion 0 del array

    //         // to store the the html tables with data of each sheet
    //         //  die(var_dump($excel->boundsheets[0]['name']));
    //         // traverses the number of sheets and sets html table with each sheet data in $excel_data
    //         for ($i = 0; $i < $nr_sheets; $i++) {
    //             if ($excel->sheets[$i]['numCols'] == 9 or $excel->sheets[$i]['numCols'] == 8) {
    //                 $re_h = '<center><table border="1" class="responsive table table-bordered contenedor" id="data_expand" name="data_expand">';     // starts html table
    //                 $re_h .= '<thead>';
    //                 $re_h .= '<tr>';
    //                 $re_h .= '<th colspan="1">';
    //                 $re_h .= 'Id Art';
    //                 $re_h .= '</th>';
    //                 $re_h .= '<th colspan="1">';
    //                 $re_h .= 'Código';
    //                 $re_h .= '</th>';
    //                 $re_h .= '<th colspan="1">';
    //                 $re_h .= 'Nombre';
    //                 $re_h .= '</th>';
    //                 $re_h .= '<th colspan="1">';
    //                 $re_h .= 'Desde';
    //                 $re_h .= '</th>';
    //                 $re_h .= '<th colspan="1">';
    //                 $re_h .= 'Hasta';
    //                 $re_h .= '</th>';
    //                 $re_h .= '<th colspan="1">';
    //                 $re_h .= 'Precio';
    //                 $re_h .= '</th>';
    //                 $re_h .= '<th colspan="1">';
    //                 $re_h .= 'Id unidad';
    //                 $re_h .= '</th>';
    //                 $re_h .= '<th colspan="1">';
    //                 $re_h .= 'id tipo lista precio';
    //                 $re_h .= '</th>';
    //                 $re_h .= '<th colspan="1">';
    //                 $re_h .= 'id conversion articulo';
    //                 $re_h .= '</th>';
    //                 $re_h .= '</tr>';
    //                 $re_h .= '</thead>';
    //                 $excel_data .= '<center><h4>(<em>' . $excel->boundsheets[$i]['name'] . '</em>)</h4></center>' . $re_h . $this->sheetData($excel->sheets[$i]) . '<br/>';

    //                  $categoria_seleccionada = $this->input->post('categoria_seleccionada');

    //                  $array = array_column($excel->sheets[$i]['cells'], 1);

    //                 foreach ($array as $key => $value) {
    //                 $impuesto_categoria = $this->cotModel->categoria_producto($categoria_seleccionada,$value);
    //                 if (!count($impuesto_categoria) > 0) 
    //                     $excel_data .= '<h4 style="color:red;">El producto con ID ['.$value.'] no tiene asignado la categoría anteriormente seleccionada</h4>';                    
    //                 }
    //                 //die();
    //             } else {
    //                 $excel_data .= '<center><h4>(<em>' . $excel->boundsheets[$i]['name'] . '</em>)</h4></center><br/><center><h4>';
    //                 $excel_data .= 'La hoja actual no cumple con el formato de columnas: <br /> "[ID_ART][CODIGO][PRODUCTO][DESDE][HASTA][PRECIO][ID_UNIDAD]"</h4><br/>';
    //                 $excel_data .= '<h4>Favor revisar documento de excel y cantidad de columnas</h4></center><br/>';
    //             }
    //         }
    //         $datos['tabla_html'] = $excel_data;
    //     }
    //     $no_tienen_hijos = $this->db->query("SELECT tia_id FROM tia_tipo_articulo WHERE tia_id NOT IN (SELECT DISTINCT tia_padre FROM tia_tipo_articulo WHERE tia_padre IS NOT NULL)")->result_array();
    //     $cadena_in = array();
    //     foreach ($no_tienen_hijos as $key2 => $value2) {
    //         $cadena_in[] = $value2['tia_id'];
    //     }
    //     $cadena_in = (count($cadena_in) <= 0) ? array(0) : $cadena_in;
    //     $this->db->where_in('tia_id', $cadena_in);
    //     $categorias = $this->gsatelite->get_dropdown('tia_tipo_articulo', '{tia_codigo} {tia_nombre}', '', array('tia_estado' => '1'), null, '', 'tia_id', true);
    //     $datos["categorias"] = str_replace('<option value="0">Seleccione</option>', '', $categorias);

    //     $datos['titulo_personal'] = 'Gestión de precios a productos';
    //     $this->_cargarvista($datos, null);
    // }
    public function gestion_listado_precios_excel()
    {
        satelite_validar();
        if ($_FILES) {
            $this->load->library('excel/excel_reader.php');
            // $this->load->library('../controllers/cotizaciones/cotizaciones'); 
            // $this->cotizaciones->gestion_listado_precios_excel();
            $excel = new Excel_reader;
            $excel->read($_FILES["excel_precios"]["tmp_name"]);
            $nr_sheets = count($excel->sheets); // gets the number of sheets
            $excel_data = '';
            $excel->sheets[0]['cells'] = array_values($excel->sheets[0]['cells']); //reordena el array que empieza con 1 a 0
            unset($excel->sheets[0]['cells'][0]); // elimina la posicion 0 del array
            // to store the the html tables with data of each sheet traverses the number of sheets and sets html table with each sheet data in $excel_data
            for ($i = 0; $i < $nr_sheets; $i++) {
                if ($excel->sheets[$i]['numCols'] == 10 || $excel->sheets[$i]['numCols'] == 11) {
                    $aplicaproceso = 1;
                    $re_h = '<center><table border="1" class="responsive table table-bordered contenedor" id="data_expand" name="data_expand">';     // starts html table
                    $re_h .= '<thead>';
                    $re_h .= '<tr>';
                    $re_h .= '<th>ID Tipo Lista Precio</th>';
                    $re_h .= '<th>Lista de Precios</th>';
                    $re_h .= '<th>ID Artículo</th>';
                    $re_h .= '<th>Código</th>';
                    $re_h .= '<th>Nombre</th>';
                    $re_h .= '<th>Desde</th>';
                    $re_h .= '<th>Hasta</th>';
                    $re_h .= '<th>ID Unidad</th>';
                    $re_h .= '<th>Unidad</th>';
                    $re_h .= '<th>Precio</th>';
                    $re_h .= '</tr>';
                    $re_h .= '</thead>';
                    $excel_data .= '<center><h4>(<em>' . $excel->boundsheets[$i]['name'] . '</em>)</h4></center>' . $re_h . $this->sheetData($excel->sheets[$i]) . '<br/>';
                    // $categoria_seleccionada = $this->input->post('categoria_seleccionada');
                    // $array = array_column($excel->sheets[$i]['cells'], 1);//array con los IDS DE LOS PRODUCTOS QUE LUEGO VERIFICABAN QUE FUERA DE LA CATEGORIA X
                    // foreach ($array as $key => $value) {
                    //     $impuesto_categoria = $this->cotModel->categoria_producto($categoria_seleccionada,$value);
                    //     if (!count($impuesto_categoria) > 0) 
                    //         $excel_data .= '<h4 style="color:red;">El producto con ID ['.$value.'] no tiene asignado la categoría anteriormente seleccionada</h4>';                    
                    // }
                } else {
                    $aplicaproceso = 0;
                    $excel_data .= '<center><h4>(<em>' . $excel->boundsheets[$i]['name'] . '</em>)</h4></center><br/><center><h4>';
                    $excel_data .= 'La hoja actual no cumple con el formato de columnas: <br /> ';
                    $excel_data .= '"[ID LISTA][NOMBRE LISTA][ID PRODUCTO][CODIGO][NOMBRE][DESDE][HASTA][ID UNIDAD][UNIDAD][PRECIO]"';
                    $excel_data .= '</h4><br/><h4>Favor revisar documento de excel y cantidad de columnas</h4></center><br/>';
                }
            }
            $datos['tabla_html'] = $excel_data;
            $datos['procede'] = $aplicaproceso;
        }
        $datos['titulo_personal'] = 'Importar Gestión de Precios';
        $this->_cargarvista($datos, null);
    } /////////////////////////////////////////////

    function get_listado_precios()
    {
        satelite_validar();
        $cate = $this->input->post('id_cat');
        $tipo = $this->input->post('tipo');
        if ($this->input->post('id_cat') != "" and $this->input->post('id_cat') > 0) {
            $where = array('art_id_tia' => $cate);
            $this->db->join('mep_medida_producto', 'lip_id_mep=mep_id');
            $this->db->join('art_articulo', 'art_id=lip_id_art');
            $this->db->join('tlp_tipo_lista_precio', 'tlp_id = lip_id_tlp');
            //$this->db->join('cva_conversion_articulo', 'cva_id = lip_id_cva', 'left');
            $this->db->join('cva_conversion_articulo', 'cva_id_art = art_id AND cva_defecto = 1', 'left');
            $data['consulta'] = $this->gsatelite->get_tabla('lip_listado_precio', $where);
            $data['registro_cat'] = $this->gsatelite->get_registro('tia_tipo_articulo', 'tia_id', $cate);
            $html = $this->load->view('cotizaciones/cotizaciones/get_listado_precios', $data, true);
        }

        if ($tipo == null or $tipo == "") {
            echo $html;
        } else if ($tipo == 2) {
            $this->load->library('pdf');
            $html_header = $this->load->view('reporte/header', array('titulo' => 'Listado de precios'), true);
            $reporte = $this->pdf->makePDF($html_header . $html, 'P');
        } else {

            $this->load->library('excelphp');
            $this->excelphp->crear_excel('lista_precios', $html, 1);

            /*
              header("Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
              header("Content-Disposition: attachment;filename=LISTADO_DE_PRECIOS.xls");
              header("Pragma: no-cache");
              header("Expires: 0");
              echo $html;
             */
        }
    } //////////////?????????????????????/////////////

    // function guardar_precios_excel($otro_modulo = null) {
    //     satelite_validar();
    //     if ($_POST) {
    //         //die(print_r($_POST));
    //         //obtener los datos
    //         $id_productos = $this->input->post('id_art');
    //         $desde = $this->input->post('desde');
    //         $hasta = $this->input->post('hasta');
    //         $precio = $this->input->post('precio');
    //         $id_unidad = $this->input->post('id_unidad');
    //         $id_tlp = $this->input->post('id_tlp');
    //         $id_cva = $this->input->post('id_cva');
    //         //id_de los productos
    //         $no_duplicados = array_unique($id_productos);
    //         //print_r($id_lista_precios);die();

    //         foreach ($id_productos as $key => $value) {
    //             //print_r($precio[$key]);die();
    //             //print_r($lip_id[0]['lip_id']);die();
    //             $existe_art_tlp = $this->cotModel->validacion_art_tipo_lista_precio($value,$id_tlp[$key]);
    //             if(count($existe_art_tlp) > 0){
    //                 //print_r($existe_art_tlp[0]['lip_id']);die();  
    //                 $array_art_tlp = array(
    //                     'lip_id_mep' => $id_unidad[$key]
    //                     , 'lip_id_tlp' => $id_tlp[$key]
    //                     , 'lip_id_cva' => ($id_cva[$key] != '')? $id_cva[$key] : null
    //                     , 'lip_desde' => $desde[$key]
    //                     , 'lip_hasta' => $hasta[$key]
    //                     , 'lip_precio' => $precio[$key]
    //                     , 'lip_usu_modificacion' => $this->tank_auth->get_user_id()
    //                     , 'lip_fecha_modificacion' => date('Y-m-d')
    //                 );

    //                  $where = array('lip_id' => $existe_art_tlp[0]['lip_id']);

    //                 $registro = $this->gsatelite->actualizar_array('lip_listado_precio', $array_art_tlp, $where);
    //                 if ($registro != 0)
    //                 $lip = 1;
    //                 }
    //                 else{
    //                #si no existe producto ni tipo precio en lip_listado_precio entonces creo nuevo registro 
    //                    //insertar los nuevos precios

    //                 $array_insert = array(
    //                     'lip_id_art' => $id_productos[$key]
    //                     , 'lip_id_mep' => $id_unidad[$key]
    //                     , 'lip_id_tlp' => $id_tlp[$key]
    //                     , 'lip_id_cva' => ($id_cva[$key] != '')? $id_cva[$key] : null
    //                     , 'lip_desde' => $desde[$key]
    //                     , 'lip_hasta' => $hasta[$key]
    //                     , 'lip_precio' => $precio[$key]
    //                     , 'lip_estado' => 1
    //                     , 'lip_usu_creacion' => $this->tank_auth->get_user_id()
    //                     , 'lip_fecha_creacion' => date('Y-m-d')
    //                     , 'lip_usu_modificacion' => $this->tank_auth->get_user_id()
    //                     , 'lip_fecha_modificacion' => date('Y-m-d')
    //                 );
    //                 //die(print_r($array_insert));
    //                 $lip = $this->gsatelite->ingresar('lip_listado_precio', $array_insert);

    //                 }

    //         }

    //         //alfinal redireccionar a la pagina de consulta
    //         if ($lip > 0) {
    //             if ($otro_modulo) {
    //                 $this->gsatelite->show_dialog('Nuevo listado de precios ingresado con éxito.', 'facturacion/facturar/gestion_listado_precios');
    //             } else {
    //                 $this->gsatelite->show_dialog('Nuevo listado de precios ingresado con éxito.', 'cotizaciones/cotizaciones/gestion_listado_precios');
    //             }
    //         }
    //     }
    // }
    function guardar_precios_excel($otro_modulo = null)
    {
        satelite_validar();
        if ($_POST) {
            $lip = 0;
            $id_tlp = $this->input->post('id_tlp');
            $id_art = $this->input->post('id_art');
            $cdesde = $this->input->post('desde');
            $chasta = $this->input->post('hasta');
            $id_mep = $this->input->post('id_unidad');
            $precio = $this->input->post('precio');
            foreach ($id_art as $key => $value) {
                $where = array('lip_id_art' => $value, 'lip_id_tlp' => $id_tlp[$key], 'lip_desde' => $cdesde[$key], 'lip_hasta' => $chasta[$key]);
                $existe_art_tlp = $this->facturacion_model->validacion_art_tipo_lista_precio($where);
                $cva = $this->gsatelite->get_campo('cva_conversion_articulo', 'cva_id', array('cva_estado' => 1, 'cva_id_art' => $value, 'cva_id_mep' => $id_mep[$key]));
                $cva_id = (is_object($cva) || is_null($cva)) ? null : $cva;
                if (count($existe_art_tlp) > 0) {
                    $array_art_tlp = array(
                        'lip_id_cva' => $cva_id,
                        'lip_id_mep' => $id_mep[$key],
                        'lip_id_tlp' => $id_tlp[$key],
                        'lip_desde' => $cdesde[$key],
                        'lip_hasta' => $chasta[$key],
                        'lip_precio' => $precio[$key],
                        'lip_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'lip_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $lip += $this->gsatelite->actualizar_array('lip_listado_precio', $array_art_tlp, array('lip_id' => $existe_art_tlp[0]['lip_id']));
                } else {
                    $array_insert = array(
                        'lip_id_cva' => $cva_id,
                        'lip_id_art' => $id_art[$key],
                        'lip_id_mep' => $id_mep[$key],
                        'lip_id_tlp' => $id_tlp[$key],
                        'lip_desde' => $cdesde[$key],
                        'lip_hasta' => $chasta[$key],
                        'lip_precio' => $precio[$key],
                        'lip_estado' => 1,
                        'lip_usu_creacion' => $this->tank_auth->get_user_id(),
                        'lip_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'lip_fecha_creacion' => date('Y-m-d H:i:s'),
                        'lip_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $lip += $this->gsatelite->ingresar('lip_listado_precio', $array_insert);
                }
            }
            if ($lip > 0) {
                if ($otro_modulo) {
                    $this->gsatelite->show_dialog('Archivo procesado con éxito.', 'facturacion/facturar/gestion_listado_precios');
                } else {
                    $this->gsatelite->show_dialog('Archivo procesado con éxito.', 'cotizaciones/cotizaciones/gestion_listado_precios');
                }
            } else {
                if ($otro_modulo) {
                    $this->gsatelite->show_dialog('Ocurrió un error y no se pudo procesar el archivo.', 'facturacion/facturar/gestion_listado_precios', 'error');
                } else {
                    $this->gsatelite->show_dialog('Ocurrió un error y no se pudo procesar el archivo.', 'cotizaciones/cotizaciones/gestion_listado_precios', 'error');
                }
            }
        }
    }

    // function sheetData($sheet) {
    //     $re = '<tbody id="contenedor">';

    //     $unpacker = $this->procesar_info($sheet);
    //     //die(print_r($unpacker));
    //     $x = 1;
    //     while ($x <= $sheet['numRows']) {
    //         $re .= "<tr>\n";
    //         $y = 1;
    //         while ($y <= $sheet['numCols']) {

    //             $cell = isset($sheet['cells'][$x][$y]) ? $sheet['cells'][$x][$y] : '';
    //             //$re .= "<td style='text-align: left;'>";
    //             if (trim($cell) != "") { //no procesar celdas vacias quitar condicional de ser necesario
    //                 //con jquery se eliminará la fila que no posea datos
    //                 $re .= ($unpacker[$y - 1][$x - 1] != "Registro no encontrado") ? "<td style='text-align: left;'>" : "<td class='eliminar_tr_padre' style='text-align: left;'>";
    //                 if ($unpacker[$y - 1][$x - 1] != "Registro no encontrado") {
    //                     if ($unpacker[$y - 1][$x - 1] != '') {
    //                         switch ($y) {
    //                             case 1:
    //                                 $re .= $unpacker[$y - 1][$x - 1] . " [" . $cell . "]" . "<input type='hidden' name='id_art[]' class='art' value='" . $cell . "'/></td>\n";
    //                                 break;

    //                             case 2:
    //                                 $re .= $unpacker[$y - 1][$x - 1] . "<input type='hidden' name='codigo_art[]' class='codigo_art' value='" . $cell . "'/></td>\n";
    //                                 break;

    //                             case 3:
    //                                 $re .= $unpacker[$y - 1][$x - 1] . "<input type='hidden' name='nombre_art[]' class='nombre_art' value='" . $cell . "'/></td>\n";
    //                                 break;

    //                             case 4:
    //                                 $re .= $unpacker[$y - 1][$x - 1] . "<input type='hidden' name='desde[]' class='desde' value='" . $cell . "'/></td>\n";
    //                                 break;

    //                             case 5:
    //                                 $re .= $unpacker[$y - 1][$x - 1] . "<input type='hidden' name='hasta[]' class='hasta' value='" . $cell . "'/></td>\n";
    //                                 break;

    //                             case 6:
    //                                 $re .= $unpacker[$y - 1][$x - 1] . "<input type='hidden' name='precio[]' class='precio' value='" . $cell . "'/></td>\n";
    //                                 break;

    //                             case 7:
    //                                 $re .= $unpacker[$y - 1][$x - 1] . "<input type='hidden' name='id_unidad[]' class='id_unidad' value='" . $cell . "'/></td>\n";
    //                                 break;
    //                             case 8: //id tlp
    //                                 $re .= $unpacker[$y - 1][$x - 1] . "<input type='hidden' name='id_tlp[]' class='id_tlp' value='" . $cell . "'/></td>\n";
    //                                 break;
    //                             case 9: //id cva
    //                                 $re .= $unpacker[$y - 1][$x - 1] . "<input type='hidden' name='id_cva[]' class='id_cva' value='" . $cell . "'/></td>\n";
    //                                 break;
    //                         }
    //                     } else {
    //                         $re .= "</td>\n";
    //                     }
    //                 } else {
    //                     if ($y == 2) {
    //                         $re .= "</td>\n";
    //                     } else {
    //                         $re .= $unpacker[$y - 1][$x - 1] . "</td>\n";
    //                     }
    //                 }
    //             } //fin de condición para que la celda no este vacia
    //             $y++;
    //         }

    //         $re .= "</tr>\n";
    //         $x++;
    //     }
    //     //
    //     //print_r($re .'</tbody></table></center>');exit();
    //     return $re . '</tbody></table></center>';     // ends and returns the html table
    // }
    function sheetData($sheet)
    {
        $re = '<tbody id="contenedor">';
        $unpacker = $this->procesar_info($sheet);
        $x = 1;
        while ($x <= $sheet['numRows']) { // <= 17
            $re .= "<tr>\n";
            $y = 1;
            while ($y <= $sheet['numCols']) { // <= 10
                $cell = isset($sheet['cells'][$x][$y]) ? $sheet['cells'][$x][$y] : '';
                //no procesar celdas vacias quitar condicional de ser necesario
                if (trim($cell) != "") {
                    //con jquery se eliminará la fila que no posea datos
                    $re .= ($unpacker[$y - 1][$x - 1] != "registro no encontrado") ? "<td style='text-align: left;'>" : "<td class='eliminar_tr_padre' style='text-align: left;'>";
                    if ($unpacker[$y - 1][$x - 1] != "registro no encontrado") {
                        if ($unpacker[$y - 1][$x - 1] != '') {
                            switch ($y) {
                                case 1:
                                    //ID TLP
                                    $re .= "ID [" . $unpacker[$y - 1][$x - 1] . "] <input type='hidden' name='id_tlp[]' class='id_tlp' value='" . $cell . "'/></td>\n";
                                    break;
                                case 2:
                                    //NAME TLP
                                    $re .= $unpacker[$y - 1][$x - 1] . "<input type='hidden' name='name_tlp[]' class='name_tlp' value='" . $cell . "'/></td>\n";
                                    break;
                                case 3:
                                    //ID ART
                                    $re .= "ID [" . $unpacker[$y - 1][$x - 1] . "] <input type='hidden' name='id_art[]' class='id_art' value='" . $cell . "'/></td>\n";
                                    break;
                                case 4:
                                    //CODE ART
                                    $re .= $unpacker[$y - 1][$x - 1] . "<input type='hidden' name='codigo_art[]' class='codigo_art' value='" . $cell . "'/></td>\n";
                                    break;
                                case 5:
                                    //NAME ART
                                    $re .= $unpacker[$y - 1][$x - 1] . "<input type='hidden' name='nombre_art[]' class='nombre_art' value='" . $cell . "'/></td>\n";
                                    break;
                                case 6:
                                    //DESDE
                                    $re .= $unpacker[$y - 1][$x - 1] . "<input type='hidden' name='desde[]' class='desde' value='" . $cell . "'/></td>\n";
                                    break;
                                case 7:
                                    //HASTA
                                    $re .= $unpacker[$y - 1][$x - 1] . "<input type='hidden' name='hasta[]' class='hasta' value='" . $cell . "'/></td>\n";
                                    break;
                                case 8:
                                    //ID MEP
                                    $re .= "ID [" . $unpacker[$y - 1][$x - 1] . "] <input type='hidden' name='id_unidad[]' class='id_unidad' value='" . $cell . "'/></td>\n";
                                    break;
                                case 9:
                                    //NAME MEP
                                    $re .= $unpacker[$y - 1][$x - 1] . "<input type='hidden' name='name_medida[]' class='name_medida' value='" . $cell . "'/></td>\n";
                                    break;
                                case 10:
                                    //PRECIO
                                    $re .= $unpacker[$y - 1][$x - 1] . "<input type='hidden' name='precio[]' class='precio' value='" . $cell . "'/></td>\n";
                                    break;
                            }
                        } else {
                            $re .= "</td>\n";
                        }
                    } else {
                        if ($y == 2) {
                            $re .= "</td>\n";
                        } else {
                            $re .= ucwords($unpacker[$y - 1][$x - 1]) . "</td>\n";
                        }
                    }
                } //fin de condición para que la celda no este vacia
                $y++;
            }
            $re .= "</tr>\n";
            $x++;
        }
        $re .= '</tbody></table></center>';
        return $re;
    } ///////////////////////////////////

    // function procesar_info($hoja) {
    //     $condiciones[0] = array(); //id art
    //     $condiciones[1] = array(); //codigo
    //     $condiciones[2] = array(); //nombre
    //     $condiciones[3] = array(); //desde
    //     $condiciones[4] = array(); //hasta
    //     $condiciones[5] = array(); //precio
    //     $condiciones[6] = array(); //id unidad
    //     $condiciones[7] = array(); //id tlp
    //     $condiciones[8] = array(); //id cva

    //     $x = 1;
    //     while ($x <= $hoja['numRows']) {
    //         $y = 1;
    //         while ($y <= $hoja['numCols']) {
    //             $cell = isset($hoja['cells'][$x][$y]) ? $hoja['cells'][$x][$y] : '';

    //             if (trim($cell) != "") { //no procesar celdas vacias quitar condicional de ser necesario
    //                 $condiciones[$y - 1] = array_merge($condiciones[$y - 1], array($cell));
    //             }

    //             $y++;
    //         }
    //         $x++;
    //     }

    //     foreach ($condiciones[0] as $key => $valor) {


    //         if ($condiciones[0][$key] != '') {
    //             //preguntar si el id pertenece a un producto valido
    //             $preguntar = $this->gsatelite->get_tabla('art_articulo', array('art_id' => $condiciones[0][$key]));
    //             if (isset($preguntar[0]['art_id'])) {
    //                 // $texto ='<input value="'.$condiciones[0][$key].'" name="id_producto[]" type="hidden" />';
    //                 // $texto =$preguntar[0]['art_nombre'];
    //                 $texto = 'ID';
    //                 $condiciones[0][$key] = $texto;
    //                 $condiciones[1][$key] = $condiciones[1][$key];
    //                 $condiciones[2][$key] = $condiciones[2][$key];
    //                 $condiciones[3][$key] = $condiciones[3][$key];
    //                 $condiciones[4][$key] = $condiciones[4][$key];
    //                 $condiciones[5][$key] = $condiciones[5][$key];
    //                 $condiciones[6][$key] = $condiciones[6][$key];
    //                 $condiciones[7][$key] = $condiciones[7][$key]; //id tlp
    //                 $condiciones[8][$key] = $condiciones[8][$key]; //id cva
    //             } else {
    //                 $texto = '<input value="no" name="id_producto[]" type="hidden" />';
    //                 $condiciones[0][$key] = "registro no encontrado";
    //                 $condiciones[1][$key] = "";
    //                 $condiciones[2][$key] = "";
    //                 $condiciones[3][$key] = "";
    //                 $condiciones[4][$key] = "";
    //                 $condiciones[5][$key] = "";
    //                 $condiciones[6][$key] = "";
    //                 $condiciones[7][$key] = ""; //id tlp
    //                 $condiciones[8][$key] = ""; //id cva
    //             }
    //         } else {
    //             $condiciones[0][$key] = "";
    //             $condiciones[1][$key] = "";
    //             $condiciones[2][$key] = "";
    //             $condiciones[3][$key] = "";
    //             $condiciones[4][$key] = "";
    //             $condiciones[5][$key] = "";
    //             $condiciones[6][$key] = "";
    //             $condiciones[7][$key] = ""; //id tlp
    //             $condiciones[8][$key] = ""; //id cva
    //         }
    //     }
    //     return $condiciones;
    // }
    function procesar_info($hoja)
    {
        $condiciones[0] = array(); //ID TLP
        $condiciones[1] = array(); //NAME TLP
        $condiciones[2] = array(); //ID ART
        $condiciones[3] = array(); //CODE ART
        $condiciones[4] = array(); //NAME ART
        $condiciones[5] = array(); //DESDE
        $condiciones[6] = array(); //HASTA
        $condiciones[7] = array(); //ID MEP
        $condiciones[8] = array(); //NAME MEP
        $condiciones[9] = array(); //PRECIO
        $x = 1;
        while ($x <= $hoja['numRows']) { //17
            $y = 1;
            while ($y <= $hoja['numCols']) { //10
                $cell = isset($hoja['cells'][$x][$y]) ? $hoja['cells'][$x][$y] : '';
                if (trim($cell) != "") { //no procesar celdas vacias quitar condicional de ser necesario
                    $condiciones[($y - 1)] = array_merge($condiciones[($y - 1)], array($cell));
                }
                $y++;
            }
            $x++;
        }
        foreach ($condiciones[0] as $key => $valor) {
            if ($condiciones[2][$key] != '') {
                //preguntar si el id pertenece a un producto valido
                $preguntar = $this->gsatelite->get_tabla('art_articulo', array('art_id' => $condiciones[2][$key]));
                if (!(isset($preguntar[0]['art_id']))) {
                    $condiciones[0][$key] = "registro no encontrado";
                    $condiciones[1][$key] = "";
                    $condiciones[2][$key] = "";
                    $condiciones[3][$key] = "";
                    $condiciones[4][$key] = "";
                    $condiciones[5][$key] = "";
                    $condiciones[6][$key] = "";
                    $condiciones[7][$key] = "";
                    $condiciones[8][$key] = "";
                    $condiciones[9][$key] = "";
                }
            } else {
                $condiciones[0][$key] = "";
                $condiciones[1][$key] = "";
                $condiciones[2][$key] = "";
                $condiciones[3][$key] = "";
                $condiciones[4][$key] = "";
                $condiciones[5][$key] = "";
                $condiciones[6][$key] = "";
                $condiciones[7][$key] = "";
                $condiciones[8][$key] = "";
                $condiciones[9][$key] = "";
            }
        }
        return $condiciones;
    } /////////////////////////////////////

    function get_img_producto()
    {
        $id = $this->input->post('id');
        $reg = $this->gsatelite->get_tabla('art_articulo', array('art_id' => $id));
        $reg = $reg[0];
        echo json_encode($reg);
    }

    function cargos_pendientes()
    {
        /*
          $num = 5;
          $location = 'tree';

          $format = 'There are %d monkeys in the %s';
          $mes=1;

          $mes = sprintf("%02d",$mes);
          echo $mes;
         */

        /* ini_set('memory_limit', '1024M');

          $saldos_pendientes =	$this->db->query("
          SELECT in2.TARJETA, in2.Ultimo_Pago,CURDATE() fecha_actual, in2.meses,
          in1.TASEO, in1.TALUMBRADO, in1.TPAVIMENTA, in1.TDESECHO
          FROM (
          SELECT
          inm02.TARJETA,
          inm02.FHASTA AS Ultimo_Pago,
          TIMESTAMPDIFF(MONTH, inm02.FHASTA, CURDATE()) +1 as Meses
          FROM
          inm02
          WHERE YEAR(inm02.FHASTA)<=2015
          HAVING meses>1
          ORDER BY inm02.FHASTA DESC
          -- LIMIT 100
          ) AS in2

          INNER JOIN inm01 AS in1
          ON in1.TARJETA = in2.TARJETA
          -- WHERE in2.TARJETA=00001 and  in2.meses=143
          GROUP BY in2.TARJETA DESC
          ORDER BY in2.TARJETA ASC
          -- LIMIT 10
          ;
          ")->result_array();
          $html='';
          $cont=0;
          $html.= "<table border='1' style='1'><tr><td>tarjeta_inm</td><td>nom_servicio</td><td>id_servicio</td><td>fecha_generacion</td><td>periodo</td><td>cargo_tarifa</td></tr>";
          foreach ($saldos_pendientes as $f) {
          // Cortar Fecha
          $fecha = explode('-', $f['Ultimo_Pago']);
          $anio = $fecha[0];
          $mes = $fecha[1] +1;

          for ($i=0; $i < $f['meses']; $i++) {
          if( $mes==13){
          $anio++;
          $mes=01;
          }
          if($anio==2015 && $mes==07){
          break;
          }

          $mes = sprintf("%02d",$mes);

          $html.= ($f['TALUMBRADO']!="" and $f['TALUMBRADO']>0 )? '<tr><td>'. $f['TARJETA'] .'</td>' . '<td>ALUMBRADO</td> <td> 1 </td> '. '<td>'. $anio .'-'. $mes .'-01' . '</td>' . '<td>'. $anio .''.$mes. '</td>' . '<td>' . $f['TALUMBRADO']. '</td></tr>':'';
          $html.= ($f['TASEO']!="" and $f['TASEO']>0 )? '<tr><td>'. $f['TARJETA'] .'</td>' . '<td>ASEO</td> <td> 2 </td> '. '<td>'. $anio .'-'. $mes .'-01' . '</td>' . '<td>'. $anio .''.$mes. '</td>' . '<td>' .$f['TASEO'] .'</td></tr>':'';
          $html.= ($f['TPAVIMENTA']!="" and $f['TPAVIMENTA']>0 )? '<tr><td>'. $f['TARJETA'] .'</td>' . '<td>PAVIMENTO</td> <td> 3 </td> '. '<td>'. $anio .'-'. $mes .'-01' . '</td>' . '<td>'. $anio .''.$mes. '</td>' . '<td>' . $f['TPAVIMENTA'] .'</td></tr>':'';
          $html.= ($f['TDESECHO']!="" and $f['TDESECHO']>0 )? '<tr><td>'. $f['TARJETA'] .'</td>' . '<td>DESECHO</td> <td> 4 </td> '. '<td>'. $anio .'-'. $mes .'-01' . '</td>' . '<td>'. $anio .''.$mes. '</td>' . '<td>' . $f['TDESECHO'] .'</td></tr>':'';

          $mes++;

          }
          }
          $html.='</table>';
          header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
          header("Content-Disposition: attachment;filename=cargos_inm.xls");
          header("Pragma: no-cache");
          header("Expires: 0");

          echo $html; */
    }

    /**
     * @autor:  Edith Herrera
     * Descripcion: tabla con el detalle de cotizacion.
     */
    function conf_detalle_cotizacion($id)
    {
        satelite_validar();
        $crud = new grocery_CRUD();
        $alias = array(
            'codigo' => 'Código',
            'imagen' => 'Imagen',
            'axc_descripcion' => 'Descripción',
            'axc_precio' => 'Precio',
            'axc_cantidad' => 'Cantidad',
            'axc_impuesto' => 'Impuesto',
            'axc_subtotal' => 'Subtotal'
        );
        $colums = array(
            'codigo',
            'imagen',
            'axc_id_art',
            'axc_descripcion',
            'axc_precio',
            'axc_cantidad',
            'axc_impuesto',
            'axc_subtotal'
        );
        $crud->set_table('axc_articuloxcotizacion')
            ->set_subject('Detalle cotizacion')
            ->display_as($alias)
            ->columns($colums)
            ->where('axc_id_cot', $id)
            ->unset_add()
            ->unset_delete()
            ->unset_edit()
            ->set_relation('axc_id_art', 'art_articulo', 'art_nombre')->display_as('axc_id_art', 'Nombre')
            ->callback_column('codigo', array($this, '_callback_codigo'))
            ->callback_column('imagen', array($this, '_callback_img'));

        $output = $crud->render();
        $data['titulo_personal'] = "Detalle de cotizacion";
        $this->_cargarvista($data, $output);
    }

    /**
     * @autor:  Edith Herrera
     * Descripcion: permite traer el codigo del articulo para la funcion conf_detalle_cotizacion
     */
    public function _callback_codigo($value, $cod)
    {
        $c = $this->cotModel->codigoarticulo($cod->axc_id);
        return $c['art_codigo'];
    }

    /**
     * @autor:  Edith Herrera
     * Descripcion: permite traer la imagen del articulo para la funcion conf_detalle_cotizacion
     */
    public function _callback_img($value, $img)
    {
        $m = $this->cotModel->imgarticulo($img->axc_id);
        return "<a href='" . site_url('assets/uploads/images/' . $m['art_foto']) . "' class='ver_en_modal_ajax_'><img src='" . site_url('assets/uploads/images/' . $m['art_foto']) . "' height='70px' width='70px'></a>";
    }

    /**
     * @autor:  Edith Herrera
     * Descripcion: pantalla de detalle de materiales.
     */
    public function detalle_material($cod_axc = null)
    {
        satelite_validar();
        $data['titulo_personal'] = "Detalle de Materiales";
        $data['articulo'] = $this->cotModel->listaarticulo($cod_axc);
        $data['lista'] = $this->gsatelite->get_tabla('art_articulo', array('art_estado' => 1, 'art_venta' => 0, 'art_inventario' => 1));
        $data['obra'] = $this->gsatelite->get_tabla('mob_mano_obra', array('mob_estado' => 1));
        $data['resp'] = $this->gsatelite->get_tabla('emp_empleado');
        $data['est'] = $this->gsatelite->get_tabla('esm_estimacion');
        $data['art'] = $this->gsatelite->get_campo('axc_articuloxcotizacion', 'axc_id_art', array('axc_id' => $cod_axc));
        // Extraccion de detalles existentes
        $this->db->join('art_articulo', 'art_id = axr_id_art_materia');
        $this->db->join('cva_conversion_articulo', 'cva_id = axr_id_cva');
        $this->db->join('mep_medida_producto', ' mep_id = cva_id_mep');
        $this->db->join('axc_articuloxcotizacion', 'axc_id=axr_id_axc');
        $data['axr'] = $this->gsatelite->get_tabla('axr_articulo_materiaxarticulo', array('axr_id_axc' => $cod_axc, 'axr_estado' => 1));
        $this->db->join('emp_empleado', 'emp_id=mxa_id_emp');
        $this->db->join('mob_mano_obra', 'mob_id=mxa_id_mob');

        $data['mxa'] = $this->gsatelite->get_tabla('mxa_mano_obraxarticulo', array('mxa_id_axc' => $cod_axc, 'mxa_estado' => 1));
        $this->db->join('esm_estimacion', 'esm_id=exa_id_esm');
        $data['esm'] = $this->gsatelite->get_tabla('exa_estimacionxarticulo', array('exa_id_axc' => $cod_axc, 'exa_estado' => 1));
        $data['acs'] = $this->gsatelite->get_tabla('acs_articulo_costo', array('acs_id_axc' => $cod_axc));
        $data['cod_axc'] = $cod_axc;
        $data['axc'] = $this->gsatelite->get_tabla('axc_articuloxcotizacion', array('axc_id' => $cod_axc));
        $this->_cargarvista($data);
    }

    /**
     * @autor:  Edith Herrera
     * Descripcion: consulta de datos segun la opcion seleccionada de Detalle Materiales.
     */
    public function datos_articulo()
    {
        satelite_validar();
        $this->db->join('cva_conversion_articulo', 'cva_id_art=art_id');
        $this->db->join('mep_medida_producto', 'mep_id=cva_id_mep');
        $data['prod'] = $this->gsatelite->get_tabla('art_articulo', array('art_id' => $this->input->post('art_id')));
        $data['desc'] = $this->gsatelite->get_tabla('axc_articuloxcotizacion', array('axc_id_art' => $this->input->post('art_id')));
        //$precio=$this->db->select_min('sar_id')->from('sar_saldo_articulo')->where('');
        // $this->db->join('moi_movimiento_inv','sar_id_bod=moi_id_bod');
        $data['pre'] = $this->gsatelite->get_tabla('sar_saldo_articulo', array('sar_id_art' => $this->input->post('art_id'), 'sar_cant_actual' => 0));

        // $data['prec']=$this->db->select('min(moi_fecha_mod) as fecha')
        // 				  ->from('sar_saldo_articulo')
        // 				  ->join('moi_movimiento_inv','sar_id_bod=moi_id_bod')
        // 				  ->where('sar_id_art',11)
        // 				  ->where('sar_cant_actual',0);

        $data['cod_obra'] = $this->gsatelite->get_tabla('mob_mano_obra', array('mob_id' => $this->input->post('mob_id')));
        $data['cod_esm'] = $this->gsatelite->get_tabla('esm_estimacion', array('esm_id' => $this->input->post('esm_id')));

        $data['art_id'] = $this->input->post('art_id');

        $art = $this->load->view("cotizaciones/cotizaciones/datos_articulo.php", $data, TRUE);
        $arreglo = array('dato' => $art);

        echo json_encode($arreglo);
    }

    /**
     * @autor:  Edith Herrera
     * Descripcion: Guardar datos de pantalla "detalle de materiales".
     * @modefy by: Mario Marquez
     * @since: 28/06/2017
     */
    function guardar_detalle_material()
    {
        satelite_validar();
        $codaxr = $this->input->post('axr_id');
        $estado = array(
            'axr_estado' => 0,
            'axr_usu_modificacion' => $this->tank_auth->get_user_id(),
            'axr_fecha_modificacion' => date('Y-m-d H:i:s')
        );
        $this->db->where('axr_id', $codaxr);
        $this->db->update('axr_articulo_materiaxarticulo', $estado);

        $codmxa = $this->input->post('mxa_id');
        $est = array(
            'mxa_estado' => 0,
            'mxa_usu_mod' => $this->tank_auth->get_user_id(),
            'mxa_fecha_mod' => date('Y-m-d H:i:s')
        );
        $this->db->where('mxa_id', $codmxa);
        $this->db->update('mxa_mano_obraxarticulo', $est);

        $codexa = $this->input->post('exa_id');
        $estd = array(
            'exa_estado' => 0,
            'exa_usu_mod' => $this->tank_auth->get_user_id(),
            'exa_fecha_mod' => date('Y-m-d H:i:s')
        );
        $this->db->where('exa_id', $codexa);
        $this->db->update('exa_estimacionxarticulo', $estd);

        $prim = $_POST['axc'];
        $cot = $_POST['cot'];
        if (isset($_POST['detalle_art'])) {

            $art = $_POST['detalle_art'];
            $cant = $_POST['detalle_c'];
            $pre = $_POST['detalle_i'];
            $uni = $_POST['detalle_u'];
            $iduni = $_POST['detalle_iu'];
            $obj = $_POST['detalle_ob'];

            $registro = 0;
            foreach ($art as $key => $value) {
                $array_axr = array(
                    'axr_id_axc' => $prim,
                    'axr_id_art_materia' => $value,
                    'axr_cantidad' => $cant[$key],
                    'axr_precio' => $pre[$key],
                    'axr_observacion' => $obj[$key],
                    'axr_estado' => 1,
                    'axr_usu_creacion' => $this->tank_auth->get_user_id(),
                    'axr_fecha_creacion' => date('Y-m-d H:i:s'),
                    'axr_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'axr_fecha_modificacion' => date('Y-m-d H:i:s'),
                    'axr_id_cva' => $iduni[$key]
                );
                $registro = $this->gsatelite->ingresar('axr_articulo_materiaxarticulo', $array_axr);
            }
        }

        if (isset($_POST['detalle_nomb'])) {
            $mob = $_POST['detalle_nomb'];
            $cant_obra = $_POST['detalle_c'];
            $pre_obra = $_POST['detalle_p'];
            $resp_obra = $_POST['detalle_r'];

            foreach ($mob as $dato => $val) {
                $array_mxa = array(
                    'mxa_id_axc' => $prim,
                    'mxa_id_mob' => $val,
                    'mxa_cantidad' => $cant_obra[$dato],
                    'mxa_precio' => $pre_obra[$dato],
                    'mxa_estado' => 1,
                    'mxa_usu_mod' => $this->tank_auth->get_user_id(),
                    'mxa_fecha_mod' => date('Y-m-d H:i:s'),
                    'mxa_id_emp' => $resp_obra[$dato]
                );
                $this->gsatelite->ingresar('mxa_mano_obraxarticulo', $array_mxa);
            }
        }

        if (isset($_POST['detalle_n'])) {
            $esm = $_POST['detalle_n'];
            $cant_esm = $_POST['detalle_cant'];
            $pre_esm = $_POST['detalle_pre'];
            $obj_esm = $_POST['detalle_o'];


            foreach ($esm as $est => $valor) {
                $array_exa = array(
                    'exa_id_esm' => $valor,
                    'exa_id_axc' => $prim,
                    'exa_cantidad' => $cant_esm[$est],
                    'exa_precio' => $pre_esm[$est],
                    'exa_observacion' => $obj_esm[$est],
                    'exa_estado' => 1,
                    'exa_usu_mod' => $this->tank_auth->get_user_id(),
                    'exa_fecha_mod' => date('Y-m-d H:i:s')
                );
                $this->gsatelite->ingresar('exa_estimacionxarticulo', $array_exa);
            }
        }

        $array_acs = array(
            'acs_id_axc' => $_POST['axc'],
            'acs_costo' => $_POST['cant_esm'],
            'acs_porcentaje_marg' => $_POST['porcentaje'],
            'acs_margen' => $_POST['margen'],
            'acs_precio' => $_POST['pre_esm'],
            'acs_observacion' => $_POST['obj'],
            'acs_estado' => 1,
            'acs_usu_mod' => $this->tank_auth->get_user_id(),
            'acs_fecha_mod' => date('Y-m-d H:i:s')
        );

        $idacs = $this->gsatelite->get_campo('acs_articulo_costo', 'acs_id_axc', array('acs_id_axc' => $prim));

        if (count($idacs) > 0) {
            $registro = $this->gsatelite->actualizar_array('acs_articulo_costo', $array_acs, array('acs_id_axc' => $prim));
        } else {
            $registro = $this->gsatelite->ingresar('acs_articulo_costo', $array_acs);
        }

        if ($registro != 0) {
            $costo = array('agregado' => $registro);
            $this->session->set_flashdata($costo);

            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Detalle de cotización", 'texto_alerta' => "Transacción efectuada correctamente");
        } else {
            $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Detalle de cotización", 'texto_alerta' => "Transacción no efectuada, favor verificar información");
        }

        $this->session->set_flashdata($alerta);
        redirect('cotizaciones/cotizaciones/editar_cotizacion/' . $cot);
    }

    function actualizar_detalle_material()
    {
        satelite_validar();
        //die(var_dump($_POST));
        if ($_POST) {
            $axr_id = $this->input->post('axr_id');
            $cantidad = $this->input->post('cantidad');
            $precio = $this->input->post('precio');

            $array_axr = array(
                'axr_cantidad' => $cantidad,
                'axr_precio' => $precio,
                'axr_usu_mod' => $this->tank_auth->get_user_id(),
                'axr_fecha_mod' => date('Y-m-d H:i:s'),
            );

            $where = array('axr_id' => $axr_id);

            $this->gsatelite->actualizar_array('axr_articulo_materiaxarticulo', $array_axr, $where);
        }
    }

    function actualizar_detalle_mano_obra()
    {
        satelite_validar();
        //die(var_dump($_POST));
        if ($_POST) {

            $mxa_id = $this->input->post('mxa_id');
            $cantidad = $this->input->post('cantidad');
            $precio = $this->input->post('precio');

            $array_mxa = array(
                'mxa_cantidad' => $cantidad,
                'mxa_precio' => $precio,
                'mxa_usu_mod' => $this->tank_auth->get_user_id(),
                'mxa_fecha_mod' => date('Y-m-d H:i:s'),
            );

            $where = array('mxa_id' => $mxa_id);

            $this->gsatelite->actualizar_array('mxa_mano_obraxarticulo', $array_mxa, $where);
        }
    }

    function actualizar_detalle_estimacion()
    {
        satelite_validar();
        //die(var_dump($_POST));
        if ($_POST) {

            $exa_id = $this->input->post('exa_id');
            $cantidad = $this->input->post('cantidad');
            $precio = $this->input->post('precio');

            $array_exa = array(
                'exa_cantidad' => $cantidad,
                'exa_precio' => $precio,
                'exa_usu_mod' => $this->tank_auth->get_user_id(),
                'exa_fecha_mod' => date('Y-m-d H:i:s'),
            );

            $where = array('exa_id' => $exa_id);

            $this->gsatelite->actualizar_array('exa_estimacionxarticulo', $array_exa, $where);
        }
    }

    /*
     * @author: Mario Marquez
     * tipo categoria: 1- Articulos, 2- Servicios, 3 - Activo Fijo
     * produccion: 1 = Se filtran las categorias que esten asociadas a productos de produccion
     * produccion: 0 = Se filtran normalmente las categorias
     */

    public function get_categorias_productos($tipo_categoria = null, $produccion = null)
    {

        $tipo = ($tipo_categoria != null) ? $tipo_categoria : $this->input->post('tipo');
        $aplicaProduccion = ($produccion != null) ? $tipo_categoria : $this->input->post('aplicaProduccion');

        $categorias = '<option value="0">Seleccione una opción</option>';
        $productos = '<option value="0">Seleccione una opción</option>';

        switch ($tipo) {
            case 1:

                $where = array('tia_padre' => null, 'tia_estado' => 1);

                if ($aplicaProduccion == 1) {
                    $this->db->join('art_articulo', 'art_id_tia = tia_id', 'inner');
                    $this->db->group_by('tia_id');
                    $where['art_produccion'] = 1;
                }

                $categorias_prod = $this->gsatelite->get_tabla('tia_tipo_articulo', $where);

                foreach ($categorias_prod as $key) {
                    $categorias .= "<option value='" . $key['tia_id'] . "'>" . $key['tia_nombre'] . "</option>";
                }

                break;
            case 2:

                $this->db->join('art_articulo', 'art_id_tia = tia_id');
                $this->db->group_by('tia_id');
                $categorias_prod = $this->gsatelite->get_tabla('tia_tipo_articulo', array('tia_padre' => null, 'art_tipo' => 1));

                foreach ($categorias_prod as $key) {
                    $categorias .= "<option value='" . $key['tia_id'] . "'>" . $key['tia_nombre'] . "</option>";
                }
                break;
        }

        $arreglo = array(
            "categoria" => $categorias,
            "producto" => $productos
        );

        echo json_encode($arreglo);
    }

    public function get_clientes($cli_busqueda = null)
    {
        $cliente = ($cli_busqueda != null) ? $cli_busqueda : $this->input->post('cliente');
        $resultado = null;
        if ($cliente != null) {
            $where = array(
                'cli_estado' => 1
            );
            $like = array("CONCAT_WS(' ', cli_codigo, cli_nombre, cli_apellido)" => $cliente);
            // $like = array("CONCAT(cli_codigo,' - ',cli_nombre, ' ', cli_apellido)" => $cliente);
            $resultado = $this->cotModel->get_clientes($where, $like);
        }
        if ($cli_busqueda != null) {
            return $resultado;
        }
        echo json_encode($resultado);
    }

    /*
     * @method: Obtiene detalles del cliente y los devuelve como opciones via ajax
     * el metodo normalmente, devuelve tambien el array de registros
     */
    public function get_informacion_cliente($cli_id = null, $registrados = null)
    {
        $cliente = ($cli_id != null) ? $cli_id : $this->input->post('cliente');
        $resultado = array();
        //Se obtienen las sucursales
        $sucursales = $this->gsatelite->get_tabla('scl_sucursal_cliente', array('scl_id_cli' => $cliente, 'scl_estado' => 1));
        $opciones = "<option></option>";
        if (count($sucursales) > 0) {
            foreach ($sucursales as $suc) {
                $selected = "";
                if ($registrados['sucursales'] != null) {
                    $selected = (in_array($suc['scl_id'], $registrados['sucursales'])) ? "selected=selected" : "";
                }

                $nombre = ($suc['scl_codigo'] != '') ? $suc['scl_codigo'] . ' - ' . $suc['scl_nombre'] : $suc['scl_nombre'];
                $opciones .= "<option " . $selected . " value='" . $suc['scl_id'] . "'>" . $nombre . "</option>";
            }
        }
        $resultado['sucursales'] = $opciones;
        //Se obtienen los impuestos
        $this->db->join('imp_impuesto', 'imp_id = ixc_id_imp', 'inner');
        $impuestos = $this->gsatelite->get_tabla('ixc_impuestoxcliente', array('ixc_id_cli' => $cliente));
        $opciones = "<option></option>";
        if (count($impuestos) > 0) {
            foreach ($impuestos as $imp) {
                $selected = "";
                $opciones .= "<option " . $selected . " data-porcentaje='" . $imp['imp_porcentaje'] . "' value='" . $imp['imp_id'] . "'>" . $imp['imp_nombre'] . "</option>";
            }
        }
        $resultado['impuestos'] = $opciones;
        //Se obtienen los contactos
        $contactos = $this->gsatelite->get_tabla('con_contacto', array('con_id_cli' => $cliente, 'con_estado' => 1));
        $opciones = "<option></option>";
        if (count($contactos) > 0) {
            foreach ($contactos as $con) {
                $selected = "";
                if (count($registrados['contactos']) > 0) {
                    $selected = (in_array($con['con_id'], $registrados['contactos'])) ? "selected=selected" : "";
                }
                $nombre = $con['con_nombre'] . ' ' . $con['con_apellidos'];
                $opciones .= "<option " . $selected . " value='" . $con['con_id'] . "'>" . $nombre . "</option>";
            }
        }
        $resultado['contactos'] = $opciones;
        //Se obtienen los proyectos
        $this->db->join('epr_estado_proyecto', 'epr_id = pcl_id_epr', 'inner');
        $proyectos = $this->gsatelite->get_tabla('pcl_proyecto_cliente', array('pcl_id_cli' => $cliente, 'pcl_estado' => 1, 'epr_cierre' => 0));
        $opciones = "<option></option>";
        if (count($proyectos) > 0) {
            foreach ($proyectos as $pcl) {
                $nombre = $pcl['pcl_codigo'] . ' - ' . $pcl['pcl_nombre'];
                $opciones .= "<option value='" . $pcl['pcl_id'] . "' data-suc='" . $pcl['pcl_id_scl'] . "'>" . $nombre . "</option>";
            }
        }
        $resultado['proyecto'] = $opciones;
        $id_tipl = 0;
        $tipos_lista2 = $this->inventario_model->get_tipo_lista_precio(array('tpn_id_cli' => $cliente));
        $select_tipo_lista_cliente = "<option value=''></option>";
        foreach ($tipos_lista2 as $key => $value) {
            if ($key == 0) {
                $select_tipo_lista_cliente .= "<option data-des_min=" . $value["lip_descuento_min"] . " data-des_max=" . $value["lip_descuento_max"] . " data-tlp=" . $value["tlp_id"] . " value=" . $value["tlp_id"] . " selected>" . $value["tlp_nombre"] . "</option>";
                $id_tipl = $value["tlp_id"];
            } else {
                $select_tipo_lista_cliente .= "<option data-des_min=" . $value["lip_descuento_min"] . " data-des_max=" . $value["lip_descuento_max"] . " data-tlp=" . $value["tlp_id"] . " value=" . $value["tlp_id"] . ">" . $value["tlp_nombre"] . "</option>";
            }
        }
        $resultado['lista_client'] = $select_tipo_lista_cliente;
        $tipo_pago = $this->gsatelite->get_campo("cli_cliente", "cli_id_tpg", array("cli_id" => $cliente));
        $resultado['tipo_pago'] = ($tipo_pago) ? $tipo_pago : "";
        /**********************************************/
        // Agregar vendedor por defecto para el cliente
        /**********************************************/
        $this->db->join('cli_cliente', 'cli_id_ven = ven_id');
        $vendedor_defecto = $this->gsatelite->get_tabla('ven_vendedor', array('cli_id' => $cliente));
        $html = '';
        if (count($vendedor_defecto) > 0) {
            $defecto = $vendedor_defecto[0]['cli_id_ven'];
            $vendedores = $this->cotModel->get_vendedorxempleado(array('ven_estado' => 1));
            foreach ($vendedores as $llave => $valor) {
                $selected = ($valor['ven_id'] === $defecto) ? 'selected' : '';
                $html .= '<option value="' . $valor['ven_id'] . '" ' . $selected . '>' . $valor['emp_codigo'] . ' - ' . $valor['ven_nombre'] . ' ' . $valor['ven_apellidos'] . '</option>';
            }

            $vendedor = $html;
        } else {
            $vendedor = 1;
        }
        /**********************************************/
        $resultado['vendedor'] = $vendedor;
        if ($cli_id != null) {
            $resultado['sucursales_array'] = $sucursales;
            $resultado['impuestos_array'] = $impuestos;
            $resultado['contactos_array'] = $contactos;
            return $resultado;
        }
        $forma_pago_cliente = $this->gsatelite->get_campo("cli_cliente", "cli_id_frp", array("cli_id" => $cliente));
        $forma_pago_defecto = $this->gsatelite->get_tabla("frp_forma_pago", array("frp_estado" => 1, 'frp_defecto' => 1));
        $frp_defecto = (count($forma_pago_defecto) > 0) ? $forma_pago_defecto[0]['frp_id'] : "";
        $resultado['forma_pago'] = ($forma_pago_cliente != "") ? $forma_pago_cliente : $frp_defecto;
        echo json_encode($resultado);
    }

    public function get_dependencias_categoria()
    {
        $padre = $this->input->post('padre');
        $servicio = $this->input->post('servicio');
        $aplicaProduccion = $this->input->post('aplicaProduccion');
        //$this->db->where('tia_padre', $padre);
        $hijos = $this->gsatelite->get_tabla('tia_tipo_articulo', array('tia_padre' => $padre, 'tia_estado' => 1));
        $cadena = "<option value='0' selected>Seleccione una opción</option>";
        $var = "<option value='0' selected>Seleccione una opción</option>";

        foreach ($hijos as $key => $value) {
            $cadena .= '<option value="' . $value['tia_id'] . '">' . $value['tia_nombre'] . '</option>';
        }

        $where_art = array('art_venta' => 1, 'art_estado' => 1);
        if ($aplicaProduccion == 1) {
            $where_art['art_produccion'] = 1;
        }
        $articulos = $this->cotModel->get_articulosxcategoria($padre, $servicio, $where_art);
        /*print_r($servicio);
        print_r($this->db->last_query());
        exit();die();*/
        //print_r($this->db->last_query());die();
        $etiqueta = 0;
        foreach ($articulos as $fila) {
            $var .= "<option data-codigo='" . $fila['art_codigo'] . "' data-nombre='" . $fila['art_nombre'] . "' "
                . "precio='" . $fila['sar_precio'] . "' value='" . $fila['art_id'] . "' id='opt_prod" . $etiqueta . "'>" . $fila['art_codigo'] . ' - ' . $fila['art_nombre'] . "</option>";
            $etiqueta++;
        }

        //Se obtienen los impuestos del tipo
        $this->db->join('imp_impuesto', 'imp_id = ixr_id_imp', 'inner');
        $impuestos_categoria = $this->gsatelite->get_tabla('ixr_impuestox_tipo_articulo', array('ixr_id_tia' => $padre));

        $impuestos = "";
        foreach ($impuestos_categoria as $key => $value) {
            $impuestos .= '<option data-id="' . $value['ixr_id'] . '" data-porcentaje="' . $value['imp_porcentaje'] . '" value="' . $value['imp_id'] . '">' . $value['imp_nombre'] . '</option>';
        }

        if (count($hijos) == 0) {
            $cadena = "";
        }
        if (count($articulos) == 0) {
            $var = "";
        }
        if (count($impuestos_categoria) == 0) {
            $impuestos = "";
        }

        $arreglo = array('drop' => $cadena, 'producto' => $var, 'padre' => $padre, 'impuestos' => $impuestos);
        echo json_encode($arreglo);
    }

    /*
     * $idProc: Id del producto a solicitar
     * @detalle: Se obtiene toda la informacion en general del producto (Inpuestos, Cuentas, Caracteristicas, Etc)
     */

    public function get_detalles_producto($idProc = null, $flag = false)
    {
        $totales = '';
        $etiqueta = 0;
        $number = 0;
        $defecto = 1;
        $producto = ($idProc > 0) ? $idProc : $this->input->post('producto');
        $cli_id = $this->input->post('cliente');
        //Existencias segun unidad por defecto
        $total = $this->cotModel->get_prod_bod_total($producto);
        if ($total) {
            $totales .= 'Existencias por ' . $total[0]['mep_nombre'] . ': ' . $total[0]['totales'];
            $number = $total[0]['totales'];
            $defecto = $total[0]['cva_conversion'];
        }

        //Se obtienen las medidas del producto
        $where = array('cva_id_art' => $producto, 'cva_estado' => 1);
        $conversiones = $this->inventario_model->get_conversiones_producto($where);
        $var = "<option></option>";
        foreach ($conversiones as $fila) {
            $selected = ($fila['cva_defecto'] == 1) ? "selected = selected" : "";
            $var .= "<option data-mep='" . $fila['cva_id_mep'] . "' data-conv='" . $fila['cva_conversion'] . "' " . $selected . " value='" . $fila['cva_id'] . "' id='opt_conv" . $etiqueta . "'>" . $fila['mep_nombre'] . "</option>";

            $etiqueta++;
        }



        //Se obtienen los impuestos del articulo
        $impuestos = "";
        $etiqueta = 0;
        $impuesto_array             = $this->gsatelite->get_tabla('imp_impuesto', array('imp_estado' => 1, 'IFNULL(imp_proceso_aplica,0) !=' => 2));
        $impuestos_clientes_array   = $this->gsatelite->get_tabla('ixc_impuestoxcliente', array('ixc_id_cli' => $cli_id));
        $this->db->join('tia_tipo_articulo', 'tia_id = ixr_id_tia');
        $this->db->join('art_articulo', 'art_id_tia = tia_id');
        $impuestos_tipo_articulo_array =  $this->gsatelite->get_tabla('ixr_impuestox_tipo_articulo', array('art_id' => $producto, 'ixr_estado' => 1));
        $id_impuestos = [];
        $imp_no_apply = [];
        foreach ($impuestos_clientes_array as $imp_cliente) {
            if ($imp_cliente['ixc_aplica'] > 0) {
                array_push($id_impuestos, $imp_cliente['ixc_id_imp']);
            }else{
                array_push($imp_no_apply, $imp_cliente['ixc_id_imp']);
            }
        }
        foreach ($impuestos_tipo_articulo_array as $imp_cliente) {
            if (!in_array($imp_cliente['ixr_id_imp'], $id_impuestos)) {
                array_push($id_impuestos, $imp_cliente['ixr_id_imp']);
            }
        }
        if (count($impuesto_array) > 0) {
            foreach ($impuesto_array as $key) {
                if (in_array($key['imp_id'], $id_impuestos)) {
                    $slt = (in_array($key['imp_id'], $imp_no_apply)) ? "" : "selected";
                    $impuestos .= "<option data-porcentaje='" . (((float)$key["imp_porcentaje"] != 0) ? $key["imp_porcentaje"] : $key["imp_valor"]) . "' value='" . $key["imp_id"] . "' " . $slt . " >" . $key["imp_nombre"] . "</option>";
                } else {
                    $impuestos .= "<option data-porcentaje='" . (((float)$key["imp_porcentaje"] != 0) ? $key["imp_porcentaje"] : $key["imp_valor"]) . "' value='" . $key["imp_id"] . "'>" . $key["imp_nombre"] . "</option>";
                }
                $etiqueta++;
            }
        }

        // Retenciones
        $retenciones_sys     = $this->gsatelite->get_tabla('ret_retencion', array('ret_estado' => 1));
        $retenciones_cliente = array_column($this->gsatelite->get_tabla('rxc_retencionxcliente', array('rxc_estado' => 1, 'rxc_id_cli' => $cli_id)), 'rxc_id_ret');
        $sys                 = array_column($retenciones_sys, 'ret_id');
        $options_ret         = '';
        // print_r($retenciones_cliente); die();
        foreach ($retenciones_sys as $key => $valor) {
            $selected = '';
            if ((isset($retenciones_cliente[$key])) && in_array($retenciones_cliente[$key], $sys)) {
                $selected = 'selected';
                $options_ret .= '<option value="' . $valor['ret_id'] . '" ' . $selected . ' data-valor="' . $valor['ret_valor'] . '" data-porcentaje="' . $valor['ret_porcentaje'] . '">' . $valor['ret_nombre'] . '</option> ';
            } else {
                $options_ret .= '<option value="' . $valor['ret_id'] . '"  data-valor="' . $valor['ret_valor'] . '"  data-porcentaje="' . $valor['ret_porcentaje'] . '">' . $valor['ret_nombre'] . '</option> ';
            }
        }

        //Muestra los tipos de lista asociados al cliente y al producto
        $id_tipl = 0;
        $tipos_lista = $this->inventario_model->get_tipo_lista_precio(array('lip_id_art' => $producto, 'tpn_id_cli' => $cli_id));
        $is_list_dfc = array_sum(array_column($tipos_lista, 'tlp_defecto'));
        $exist_dfcto = ($is_list_dfc > 0) ? true : false;
        //print_r($tipos_lista);
        $select_tipo_lista = "<option value=''></option>";
        foreach ($tipos_lista as $key => $value) {
            if ($exist_dfcto) {
                if ($value['tlp_defecto'] == 1) {
                    $select_tipo_lista .= "<option data-tlp=" . $value["tlp_id"] . " data-des_min=" . $value["lip_descuento_min"] . " data-des_max=" . $value["lip_descuento_max"] . " value=" . $value["tlp_id"] . " selected>" . $value["tlp_nombre"] . "</option>";
                    $id_tipl = $value["tlp_id"];
                } else {
                    $select_tipo_lista .= "<option data-tlp=" . $value["tlp_id"] . " data-des_min=" . $value["lip_descuento_min"] . " data-des_max=" . $value["lip_descuento_max"] . " value=" . $value["tlp_id"] . ">" . $value["tlp_nombre"] . "</option>";
                }
            } else {
                if ($key == 0) {
                    $select_tipo_lista .= "<option data-tlp=" . $value["tlp_id"] . " data-des_min=" . $value["lip_descuento_min"] . " data-des_max=" . $value["lip_descuento_max"] . " value=" . $value["tlp_id"] . " selected>" . $value["tlp_nombre"] . "</option>";
                    $id_tipl = $value["tlp_id"];
                } else {
                    $select_tipo_lista .= "<option data-tlp=" . $value["tlp_id"] . " data-des_min=" . $value["lip_descuento_min"] . " data-des_max=" . $value["lip_descuento_max"] . " value=" . $value["tlp_id"] . ">" . $value["tlp_nombre"] . "</option>";
                }
            }
        }

        //Listado de precios
        $precios = $this->gsatelite->get_tabla('lip_listado_precio', array('lip_id_art' => $producto, 'lip_estado' => 1));

        $opciones = "<option></option>";
        //$opciones_busqueda = "<option></option>";
        if (count($precios) > 0) {
            foreach ($precios as $lip) {
                $opciones .= "<option data-inicio='" . $lip['lip_desde'] . "' data-fin='" . $lip['lip_hasta'] . "' value='" . $lip['lip_id'] . "'>" . $lip['lip_precio'] . "</option>";
                //$opciones_busqueda .= "<option data-inicio='" . $lip['lip_desde'] . "' data-fin='" . $lip['lip_hasta'] . "' value='" . $lip['lip_id_mep'] . "'>" . $lip['lip_precio'] . "</option>";
            }
        }

        $precios2 = $this->gsatelite->get_tabla('lip_listado_precio', array('lip_id_art' => $producto, 'lip_estado' => 1, 'lip_id_tlp' => $id_tipl));
        $opciones_busqueda = "<option></option>";
        if (count($precios2) > 0) {
            foreach ($precios2 as $lip2) {
                $opciones_busqueda .= "<option data-id_lip='" . $lip2['lip_id'] . "' data-inicio='" . $lip2['lip_desde'] . "' data-fin='" . $lip2['lip_hasta'] . "' value='" . $lip2['lip_id_mep'] . "'>" . $lip2['lip_precio'] . "</option>";
            }
        }

        /****************************************************/
        /*$categoria = $this->input->post('categoria');
        $categoria_codigo = $this->gsatelite->get_tabla('tia_tipo_articulo', array('tia_estado' => 1, 'tia_id' => $categoria));
        $codigo_categoria = $categoria_codigo[0]['tia_codigo'];
        $caracteristicas = $this->inventario_model->get_caracteristica2($categoria);*/
        /****************************************************/

        $caracteristicas = $this->inventario_model->get_caracteristicas_producto(array('cxu_id_art' => $producto, 'cxu_estado' => 1));
        $opciones_carac = "<option></option>";
        if (count($caracteristicas) > 0) {
            foreach ($caracteristicas as $car) {
                $opciones_carac .= "<option  id='" . $car['car_tipo'] . "' data-valor='" . $car['cxu_valor'] . "' data-car='" . $car['car_id'] . "' data-cxr='" . $car['cxu_id_cxr'] . "' value='" . $car['cxu_id'] . "'>" . $car['car_nombre'] . "</option>";
            }
        }

        $producto = $this->gsatelite->get_tabla('art_articulo', array('art_id' => $producto));
        $nombre_foto = FCPATH . "assets/uploads/images/" . $producto[0]['art_foto'];
        $ruta = base_url() . "assets/uploads/images/" . $producto[0]['art_foto'];
        if (!file_exists($nombre_foto) || $producto[0]['art_foto'] == null) {
            $ruta = base_url() . "media/imagenes/sistema/noimagefound.jpg";
        }

        $detalle_prod = array(
            'codigo' => $producto[0]['art_codigo'],
            'nombre' => $producto[0]['art_nombre'],
            'descripcion' => $producto[0]['art_descripcion'],
            'foto' => ($producto[0]['art_foto'] != null) ? $producto[0]['art_foto'] : "",
            'ruta' => $ruta,
            'valor' => $valor,
            'activo_fijo' => $producto[0]['art_activo_fijo'],
            'compra_producto' => $producto[0]['art_compra'],
            'tipo_producto' => $producto[0]['art_tipo']
        );

        $arreglo = array(
            'caracteristicas' => $opciones_carac,
            'impuestos' => $impuestos,
            'medidas' => $var,
            'precios' => $opciones,
            'producto' => $detalle_prod,
            'rango_precios' => $opciones_busqueda,
            'select_tipo_lista' => $select_tipo_lista,
            'total' => $totales,
            'numero' => $number,
            'defecto' => $defecto,
            'retenciones' => $options_ret
        );

        if (!$flag) {
            echo json_encode($arreglo);
        } else {
            return $arreglo;
        }
    }

    function envios_parciales($cot_id = null)
    {
        satelite_validar();
        if ($cot_id == null) {
            redirect('inicio');
        }

        $crud = new grocery_CRUD();

        $columns = array(
            'enc_id_usu',
            'enc_fecha_envio',
            'total_enviados'
        );

        //Alias para las columnas
        $alias = array(
            'enc_id_usu' => 'Realizado por',
            'enc_fecha_envio' => 'Fecha de envío',
            'total_enviados' => 'Productos enviados',
        );

        $crud->set_table('enc_envio_cotizacion')
            ->set_subject('Envío Parcial')
            ->where('enc_id_cot', $cot_id)
            ->columns($columns)
            ->display_as($alias)
            ->unset_export()
            ->unset_print()
            ->unset_edit()
            ->unset_delete()
            ->unset_add()
            //->add_action('Ver', 'minia-icon-search', 'cotizaciones/cotizaciones/editar_envio_parcial/1')
            ->add_action('Imprimir', 'icomoon-icon-printer imprimir', 'cotizaciones/cotizaciones/imprimir_envio_parcial/' . $cot_id)
            ->callback_column('enc_id_usu', function ($value, $primary_key) {
                $user_id = $value;
                $informacion = $this->inventario_model->informacion_empleado($user_id);

                $nombre = "";
                if ($informacion[0]['emp_nombre'] != '') {
                    $nombre = $informacion[0]['emp_nombre'] . " " . $informacion[0]['emp_apellido'];
                }

                return $nombre;
            })
            ->callback_column('total_enviados', function ($value, $primary_key) {
                $total_enviados = $this->gsatelite->get_suma('den_detalle_envio', 'den_cantidad', array('den_id_enc' => $primary_key->enc_id));
                return $total_enviados;
            })

            ->callback_column('enc_fecha_envio', function ($value, $row) {
                if ($value != '') {
                    return date('d-m-Y', strtotime($value));
                } else {
                    return '';
                }
            });

        $this->db->join('enc_envio_cotizacion', 'enc_id = den_id_enc');
        $total_enviados = $this->gsatelite->get_suma('den_detalle_envio', 'den_cantidad', array('enc_id_cot' => $cot_id));
        //return $total_enviados;


        $total_productos = $this->gsatelite->get_suma('axc_articuloxcotizacion', 'axc_cantidad', array('axc_id_cot' => $cot_id));
        $cotizacion = $this->cotModel->get_cotizacion(array('cot_id' => $cot_id));
        $data['no_add'] = 0;
        if ($total_enviados == $cotizacion[0]['cot_total']) {
            $data['no_add'] = 1;
        }

        $output = $crud->render();

        $data['total_productos'] = $total_productos;
        $data['cotizacion'] = $cotizacion[0];
        $data['titulo_personal'] = "Envíos Parciales";
        $this->_cargarvista($data, $output);
    }

    function agregar_envio_parcial($cot_id = null)
    {
        satelite_validar();
        if ($cot_id == null) {
            redirect('inicio');
        }
        if ($this->input->post()) {
            $post_array = $this->input->post();

            $tipo_btn = $post_array['btnCrear'];
            $envio_array = array(
                'enc_id_usu' => $this->tank_auth->get_user_id(),
                'enc_id_cot' => $cot_id,
                'enc_fecha_envio' => date('Y-m-d H:i:s'),
                'enc_estado' => 1,
                'enc_usu_creacion' => $this->tank_auth->get_user_id(),
                'enc_fecha_creacion' => date('Y-m-d H:i:s'),
                'enc_usu_modificacion' => $this->tank_auth->get_user_id(),
                'enc_fecha_modificacion' => date('Y-m-d H:i:s')
            );

            $enc_id = $this->gsatelite->ingresar('enc_envio_cotizacion', $envio_array); //enc_envio_cotizacion
            if ($enc_id > 0) {

                $productos = $post_array['productos'];
                $fechasEnvio = $post_array['fechasEnvio'];
                $horaEnvio = $post_array['horasEnvio'];
                $sucursalProducto = $post_array['sucursalProducto'];
                $direccionSuc = $post_array['direccionSuc'];
                $cantidades = $post_array['cantidades'];
                $contactos = $post_array['contactos'];

                if (count($productos) > 0) {
                    for ($i = 0; $i < count($productos); $i++) {
                        $fechaConvert = new DateTime($fechasEnvio[$i]);
                        $hora_convert = new DateTime($horaEnvio[$i]);

                        $fecha_final = $fechaConvert->format('Y-m-d') . ' ' . $hora_convert->format('H:i:s');


                        $detalle_array = array(
                            'den_id_enc' => $enc_id,
                            'den_id_scl' => ($sucursalProducto[$i] != '') ? $sucursalProducto[$i] : NULL,
                            'den_id_con' => ($contactos[$i] != '') ? $contactos[$i] : NULL,
                            'den_id_axc' => $productos[$i],
                            'den_cantidad' => $cantidades[$i],
                            'den_fecha' => $fecha_final,
                            'den_direccion' => ($direccionSuc[$i] != '') ? $direccionSuc[$i] : null,
                            'den_estado' => 1,
                            'den_usu_creacion' => $this->tank_auth->get_user_id(),
                            'den_fecha_creacion' => date('Y-m-d H:i:s'),
                            'den_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'den_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $den_id = $this->gsatelite->ingresar('den_detalle_envio', $detalle_array);
                    }
                }
                if ($den_id > 0) {
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Envío Parcial", 'texto_alerta' => "El registro se guardó correctamente.");
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Envío Parcial", 'texto_alerta' => "Ocurrio un problema al crear el registro.");
                }
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Envío Parcial", 'texto_alerta' => "Ocurrio un problema al crear el registro.");
            }

            $this->session->set_flashdata($alerta);

            if ($tipo_btn == 1) {
                redirect('/cotizaciones/cotizaciones/agregar_envio_parcial/' . $cot_id);
            } else {
                redirect('cotizaciones/cotizaciones/envios_parciales/' . $cot_id);
            }
        }

        $cotizacion = $this->cotModel->get_cotizacion(array('cot_id' => $cot_id));
        $data['cotizacion'] = $cotizacion[0];

        $data['sucursales'] = $this->gsatelite->get_dropdown('scl_sucursal_cliente', 'scl_nombre', 'surcursales', array('scl_id_cli' => $cotizacion[0]['cot_id_cli']), null, null, null, true);
        $data['detalle_cotizacion'] = $this->cotModel->get_detalle_cotizacion(array('axc_id_cot' => $cot_id, 'axc_estado' => 1));

        $contactos = $this->gsatelite->get_dropdown('con_contacto', '{con_nombre} {con_apellidos}', 'contactos', array('con_id_cli' => $cotizacion[0]['cot_id_cli']), null, null, 'con_id', true);
        $data["contactos"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $contactos);

        $data['titulo_personal'] = "Agregar Envío Parcial";
        cargarvista($data);
    }

    public function get_detalle_prorrateo($ptg_id = null, $flag = null)
    {

        $idProrrateo = ($ptg_id != null) ? $ptg_id : $this->input->post('prorrateo');

        $dataProrrateo = array();

        $detalleProrrateo = $this->cotModel->get_detalleprorrateo(array('dpr_id_ptg' => $idProrrateo));
        //var_dump($detalleProrrateo);die();
        $opciones = "<option></option>";

        foreach ($detalleProrrateo as $row) {
            $opciones .= '<option data-porcentaje="' . $row['dpr_porcentaje'] . '" data-cuenta="' . $row['cec_cuenta_contable'] . '" value="' . $row['dpr_id'] . '">' . $row['cec_nombre'] . '</option>';
        }

        $dataProrrateo['opciones'] = $opciones;

        if ($flag) {
            return $flag;
        }

        echo json_encode($dataProrrateo);
    }

    /**
     * Cotizaciones::_cargarvista()
     *
     * @param integer $data
     * @param integer $crud
     * @return void
     */
    function _cargarvista($data = 0, $crud = 0, $ruta_vista = "")
    {
        $this->load->view('vacia', $crud);
        if ($data != 0)
            $data = array_merge($data, $this->masterpage->getUsuario());
        else
            $data = $this->masterpage->getUsuario();
        $vista = ($ruta_vista != '') ? $ruta_vista : ($data['modulo'] . '/' . $data['control'] . '/' . $data['funcion']);
        $this->masterpage->setMasterPage('masterpage_default');
        $this->masterpage->addContentPage($vista, 'content', $data);
        $this->masterpage->show();
    }

    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /**
     * Cotizaciones:establecer_cotizacion_ganada()
     *
     * @param mixed $id_cotizacion
     * @param string $correcto
     * @return MATENIMIENTO DE LAS TABLAS cog_cotiz_ganada
     * @modify by: Mario Marquez
     * @since: 10/08/2017
     */
    function establecer_cotizacion_ganada($id_cotizacion)
    {
        satelite_validar();
        $esPerdida = $this->cotModel->Existe_Registro("per_perdido", array('per_id_cot' => $id_cotizacion));
        $cotizacion = $this->cotModel->get_cotizacion(array('cot_id' => $id_cotizacion));
        $txtNumeroOrdCompra = $this->input->post('txtNOrdCompra');
        if ($esPerdida == 1) {
            $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Advertencia", 'texto_alerta' => "La cotización ya ha sido declarada como perdida");
            $this->session->set_flashdata($alerta);
            redirect("cotizaciones/cotizaciones/index");
        }
        //VERIFICAR SI YA EXISTEN LOS NUEVOS CAMPOS, SINO SE SEGUIRAN USANDO LOS VALORES DEL PARAMETRO
        $hay_campo = $this->db->query("SHOW COLUMNS FROM est_estado_cotizacion WHERE Field = 'est_ganada'")->result_array();
        if (count($hay_campo) > 0) {
            $ganada = $this->gsatelite->get_tabla('est_estado_cotizacion', array('est_estado' => 1, 'est_ganada' => 1));
            if (count($ganada) > 0) {
                $estado_cotizacion = $ganada[0]['est_id'];
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Advertencia", 'texto_alerta' => 'Verifique que exista un Estado "Ganada".');
                $this->session->set_flashdata($alerta);
                redirect("cotizaciones/cotizaciones/index");
            }
        } else {
            $estado_cotizacion = $this->gsatelite->get_parametro('SYS_ESTADO_COTIZACION', null, null, array('GANADA'));
        }
        if ($this->input->post()) {
            $post_array = $this->input->post();
            //die(var_dump($post_array));
            $det_cot_array = $this->gsatelite->get_tabla('axc_articuloxcotizacion', array('axc_id_cot' => $id_cotizacion));
            $id_tot_det_cot = array_column($det_cot_array, 'axc_id');
            $checkbox_det = $post_array['checkbox_det'];
            foreach ($id_tot_det_cot as $key => $det_id) {
                if (in_array($det_id, $checkbox_det)) {
                    $actualizar_detalle_cotizacion_array = array(
                        'axc_estado' => 1,
                        'axc_fecha_modificacion' => date('Y-m-d H:i:s'),
                        'axc_usu_modificacion' => $this->tank_auth->get_user_id()
                    );
                } else {
                    $actualizar_detalle_cotizacion_array = array(
                        'axc_estado' => 0,
                        'axc_fecha_modificacion' => date('Y-m-d H:i:s'),
                        'axc_usu_modificacion' => $this->tank_auth->get_user_id()
                    );
                }
                $deta_cot = $this->gsatelite->actualizar_array('axc_articuloxcotizacion', $actualizar_detalle_cotizacion_array, array('axc_id' => $det_id));
            }
            $ganada_array = array(
                'cog_id_cot' => $id_cotizacion,
                'cog_fecha_cierre' => formatear_fecha('Y-m-d', $post_array['txtFechaCierra']),
                'cog_causa_estado' => $post_array['txtObservacion'],
                'cog_numero_orden' => $txtNumeroOrdCompra,
                'cog_estado' => 1,
                'cog_usu_modificacion' => $this->tank_auth->get_user_id(),
                'cog_fecha_modificacion' => date('Y-m-d H:i:s'),
                'cog_usu_creacion' => $this->tank_auth->get_user_id(),
                'cog_fecha_creacion' => date('Y-m-d H:i:s')
            );
            $yaGanada = $this->cotModel->Existe_Registro("cog_cotiz_ganada", array('cog_id_cot' => $id_cotizacion));
            if ($post_array['hdnGanada'] == '' && $yaGanada == 0) {
                $cog_id = $this->gsatelite->ingresar('cog_cotiz_ganada', $ganada_array);
            } else {
                unset($ganada_array['cog_usu_creacion']);
                unset($ganada_array['cog_fecha_creacion']);
                $cog_id = $this->gsatelite->actualizar_array('cog_cotiz_ganada', $ganada_array, array('cog_id' => $post_array['hdnGanada']));
            }
            //die(var_dump($cog_id));
            if ($cog_id > 0) {
                $cotizacion_array = array(
                    'cot_fecha_cierre' => formatear_fecha('Y-m-d', $post_array['txtFechaCierra']),
                    'cot_id_est' => $estado_cotizacion,
                    'cot_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'cot_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                $this->gsatelite->actualizar_array('cot_cotizacion', $cotizacion_array, array('cot_id' => $id_cotizacion));
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Cotización #" . $cotizacion[0]['cot_codigo'], 'texto_alerta' => "Establecida como ganada.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Cotización #" . $cotizacion[0]['cot_codigo'], 'texto_alerta' => "Ocurrio un problema al crear el registro.");
            }
            /**Actualizar los estados de los detalles de la cotizacion ganada**/
            //Id de todas los ids de los detalles de la cotizacion
            /*$actualizar_detalle_cotizacion_array = array(
                'axc_id' => $,
                'axc_estado' => 0,
            );*/
            /**Fin actualizar los estados de los detalles de la cotizacion ganada**/
            $tipo_btn = $post_array['btnCrear'];
            $this->session->set_flashdata($alerta);
            if ($tipo_btn == 1) {
                redirect('cotizaciones/cotizaciones/establecer_cotizacion_ganada/' . $id_cotizacion);
            } else {
                redirect('cotizaciones/cotizaciones/index');
            }
        } //FIN DE if(post())
        $ganada = $this->gsatelite->get_tabla('cog_cotiz_ganada', array('cog_id_cot' => $id_cotizacion));
        $detalle_cotizacion = $this->cotModel->get_detalle_cotizacion(array('axc_id_cot' => $id_cotizacion));
        $detalle_activos    = $this->cotModel->get_detalle_cotizacion(array('axc_id_cot' => $id_cotizacion, 'axc_estado' => 1));
        $detalle_inactivos  = $this->cotModel->get_detalle_cotizacion(array('axc_id_cot' => $id_cotizacion, 'axc_estado' => 0));
        //print_r($detalle_inactivos); die();
        $data['cantidad_total_detalles'] = count($detalle_cotizacion);
        $data['cantidad_detalle_activos'] = count($detalle_activos);
        $data['cantidad_detalle_inactivos'] = count($detalle_inactivos);
        //print_r($detalle_cotizacion); die();
        $data['cotizacion'] = $cotizacion[0];
        $data['ganada'] = ($ganada[0] != null) ? $ganada[0] : null;
        $data['detalle_cotizacion'] = (count($detalle_cotizacion) > 0) ? $detalle_cotizacion : null;
        $data['titulo_personal'] = "Establecer cotizaci&oacute;n Ganada";
        cargarvista($data);
    }

    function establecer_cotizacion_ganada_2($id_cotizacion, $correcto = "")
    {


        $WhereEsPerdida = array('per_id_cot' => $id_cotizacion);
        $esPerdida = $this->cotModel->Existe_Registro("per_perdido", $WhereEsPerdida);

        if ($esPerdida == 1) {
            $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Advertencia", 'texto_alerta' => "La cotización ya ha sido declarada como perdida");

            $this->session->set_flashdata($alerta);
            redirect("cotizaciones/cotizaciones/index");
        }

        if (isset($correcto) && $correcto == "1") { //mostrar un mensaje al usuario
            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Éxito en la operación", 'texto_alerta' => "Operación realizada con Éxito");
            $this->session->set_flashdata($alerta);
            redirect("cotizaciones/cotizaciones/establecer_cotizacion_ganada/$id_cotizacion", null);
        }
        if (isset($correcto) and $correcto == "2") {
            $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error al actualizar", 'texto_alerta' => "Error en Realizar operación, Favor de intentar de nuevo");
            $this->session->set_flashdata($alerta);
            redirect("cotizaciones/cotizaciones/establecer_cotizacion_ganada/$id_cotizacion", null);
        }

        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            try {
                //PREGUNTAR SI A ESA COTIZACION YA SE LE REGISTRO COMO GANADA O PERDIDA Y ASI SOLO MOSTRAR SUS DATOS
                //PARA LA ACTUALIZACION
                $WhereGanada = array('cog_id_cot' => $id_cotizacion);
                $WherePerdida = array('per_id_cot' => $id_cotizacion);

                $es_ganada = $this->cotModel->Existe_Registro("cog_cotiz_ganada", $WhereGanada);
                $es_perdida = $this->cotModel->Existe_Registro("per_perdido", $WherePerdida);

                if ($es_ganada == 1) {
                    $datos['estado_cotizacion'] = 1;
                    $datos['datos_ganada'] = $this->cotModel->get_tabla("cog_cotiz_ganada", "cog_id_cot", $id_cotizacion, "cog_id", "ASC");
                } else if ($es_perdida == 1) {
                    $datos['estado_cotizacion'] = 2;
                    $datos['datos_perdida'] = $this->cotModel->get_tabla("per_perdido", "per_id_cot", $id_cotizacion, "per_id", "ASC");
                } else {
                    $datos['estado_cotizacion'] = 3;
                }

                //die(print_r($datos['estado_cotizacion']));
                $filaCotizacion = $this->cotModel->get_registro('cot_cotizacion', 'cot_id', $id_cotizacion); //obtener registro

                $datos['datos_cotizacion'] = $filaCotizacion;
                //solo lectura del estado de la cotizacion en la vista del form cotizacion ganada-perdida (cuando haya sido registrada como perdida o ganada)
                $datos['Nombre_EstadoCotizacion'] = $this->gsatelite->get_campo('est_estado_cotizacion', 'est_nombre', array('est_id' => $filaCotizacion->cot_id_est));
                $datos['tabla_estado_cotizacion'] = $this->cotModel->get_tabla("est_estado_cotizacion", "est_estado", 1, "est_id", "ASC");
                $datos['datos_cliente'] = $this->cotModel->get_registro('cli_cliente', 'cli_id', $filaCotizacion->cot_id_cli); //obtener registro
                // $datos['todobien'] = $correcto;
                if ($correcto != "" and $correcto == "1") {
                    $datos['exito'] = "Operación realizada con Éxito";
                    $datos['clase'] = "ui-state-highlight";
                    $datos['icono'] = "ui-icon ui-icon-info";
                }
                if ($correcto != "" and $correcto == "2") {
                    $datos['exito'] = "Error en Realizar operación, Favor de intentar de nuevo";
                    $datos['clase'] = "ui-state-error";
                    $datos['icono'] = "ui-icon ui-icon-alert";
                }


                //preguntar si es vendedor
                $condicion1 = array('ven_id_usu' => $this->tank_auth->get_user_id(), 'ven_estado' => 1);
                $esVen = $this->cotModel->Existe_Registro("ven_vendedor", $condicion1);
                if ($esVen > 0) {
                    $datos["esVen"] = 1;
                    $datos['titulo_personal'] = "Establecer cotizaci&oacute;n Ganada";
                } else {
                    $datos['titulo_personal'] = "Establecer cotizaci&oacute;n como ganada o perdida";
                }
                $this->_cargarvista($datos, null);
            } catch (Exception $e) {
                show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
            }
        }
    }

    /**
     * Cotizaciones:establecer_cotizacion_ganada()
     *
     * @param mixed $id_cotizacion
     * @param string $correcto
     * @return MATENIMIENTO DE LAS TABLAS cog_cotiz_ganada
     */
    function establecer_cotizacion_perdida($id_cotizacion, $change = NULL)
    {
        satelite_validar();
        $WhereEsPerdida = array('cog_id_cot' => $id_cotizacion);
        $esPerdida = $this->cotModel->Existe_Registro("cog_cotiz_ganada", $WhereEsPerdida);
        $cotizacion = $this->cotModel->get_cotizacion(array('cot_id' => $id_cotizacion));
        if ($change == NULL && $esPerdida == 1) {
            $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Advertencia", 'texto_alerta' => "La cotización ya ha sido declarada como ganada");
            $this->session->set_flashdata($alerta);
            redirect("cotizaciones/cotizaciones/index");
        }
        //VERIFICAR SI YA EXISTEN LOS NUEVOS CAMPOS, SINO SE SEGUIRAN USANDO LOS VALORES DEL PARAMETRO
        $hay_campo = $this->db->query("SHOW COLUMNS FROM est_estado_cotizacion WHERE Field = 'est_perdida'")->result_array();
        if (count($hay_campo) > 0) {
            $perdida = $this->gsatelite->get_tabla('est_estado_cotizacion', array('est_estado' => 1, 'est_perdida' => 1));
            if (count($perdida) > 0) {
                $estado_cotizacion = $perdida[0]['est_id'];
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Advertencia", 'texto_alerta' => 'Verifique que exista un Estado "Perdida".');
                $this->session->set_flashdata($alerta);
                redirect("cotizaciones/cotizaciones/index");
            }
        } else {
            $estado_cotizacion = $this->gsatelite->get_parametro('SYS_ESTADO_COTIZACION', null, null, array('PERDIDA'));
        }
        if ($this->input->post()) {
            $post_array = $this->input->post();
            if ($change != NULL && $esPerdida > 0) {
                $this->gsatelite->borrado_general('cog_cotiz_ganada', array('cog_id_cot' => $id_cotizacion));
            }
            $ganada_array = array(
                'per_id_cot' => $id_cotizacion,
                'per_id_mop' => ($post_array['slcMotivoPerdida'] > 0) ? $post_array['slcMotivoPerdida'] : null,
                'per_precio' => $post_array['txtPrecio'],
                'per_empresa' => $post_array['txtEmpresa'],
                'per_fecha_perdido' => formatear_fecha('Y-m-d', $post_array['txtFechaCierra']),
                'per_causa_estado' => $post_array['txtObservacion'],
                'per_estado' => 1,
                'per_usu_modificacion' => $this->tank_auth->get_user_id(),
                'per_fecha_modificacion' => date('Y-m-d H:i:s'),
                'per_usu_creacion' => $this->tank_auth->get_user_id(),
                'per_fecha_creacion' => date('Y-m-d H:i:s')
            );
            if ($post_array['hdnPerdida'] == '') {
                $cog_id = $this->gsatelite->ingresar('per_perdido', $ganada_array);
            } else {
                unset($ganada_array['per_usu_creacion']);
                unset($ganada_array['per_fecha_creacion']);
                $cog_id = $this->gsatelite->actualizar_array('per_perdido', $ganada_array, array('per_id' => $post_array['hdnPerdida']));
            }
            if ($cog_id > 0) {
                $cotizacion_array = array(
                    'cot_fecha_cierre' => formatear_fecha('Y-m-d', $post_array['txtFechaCierra']),
                    'cot_id_est' => $estado_cotizacion,
                    'cot_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'cot_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                $this->gsatelite->actualizar_array('cot_cotizacion', $cotizacion_array, array('cot_id' => $id_cotizacion));
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Cotización #" . $cotizacion[0]['cot_codigo'], 'texto_alerta' => "Establecida como perdida.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Cotización #" . $cotizacion[0]['cot_codigo'], 'texto_alerta' => "Ocurrio un problema al crear el registro.");
            }

            $tipo_btn = $post_array['btnCrear'];
            $this->session->set_flashdata($alerta);

            if ($tipo_btn == 1) {
                redirect('cotizaciones/cotizaciones/establecer_cotizacion_perdida/' . $id_cotizacion);
            } else {
                redirect('cotizaciones/cotizaciones/index');
            }
        }
        if ($change != NULL) {
            $data['cambio'] = 1;
        }
        
        $perdida = $this->gsatelite->get_tabla('per_perdido', array('per_id_cot' => $id_cotizacion));
        $slctd = ($perdida[0]['per_id_mop'] > 0) ? $perdida[0]['per_id_mop'] : null;
        $dropdown = $this->gsatelite->get_dropdown('mop_motivo_perdida', 'mop_nombre', '', array('mop_estado' => 1), $slctd, '', 'mop_id', true);
        $data['cotizacion'] = $cotizacion[0];
        $data['perdida'] = (isset($perdida[0]) && $perdida[0] != null) ? $perdida[0] : null;
        $data['motivo_perd'] =  str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $dropdown);
        $data['titulo_personal'] = "Establecer cotizaci&oacute;n Perdida";
        cargarvista($data);
    }

    function establecer_cotizacion_perdida_2($id_cotizacion, $correcto = "")
    {


        $WhereEsGanada = array('cog_id_cot' => $id_cotizacion);
        $esGanada = $this->cotModel->Existe_Registro("cog_cotiz_ganada", $WhereEsGanada);

        if ($esGanada == 1) {
            $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Advertencia", 'texto_alerta' => "La cotización ya ha sido declarada como ganada");

            $this->session->set_flashdata($alerta);
            redirect("cotizaciones/cotizaciones/index");
        }

        if (isset($correcto) && $correcto == "1") { //mostrar un mensaje al usuario
            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Éxito en la operación", 'texto_alerta' => "Operación realizada con Éxito");
            $this->session->set_flashdata($alerta);
            redirect("cotizaciones/cotizaciones/establecer_cotizacion_perdida/$id_cotizacion", null);
        }
        if (isset($correcto) and $correcto == "2") {
            $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error al actualizar", 'texto_alerta' => "Error en Realizar operación, Favor de intentar de nuevo");
            $this->session->set_flashdata($alerta);
            redirect("cotizaciones/cotizaciones/establecer_cotizacion_perdida/$id_cotizacion", null);
        }
        //var_dump($correcto); die();

        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            try {
                //PREGUNTAR SI A ESA COTIZACION YA SE LE REGISTRO COMO GANADA O PERDIDA Y ASI SOLO MOSTRAR SUS DATOS
                //PARA LA ACTUALIZACION
                $WhereGanada = array('cog_id_cot' => $id_cotizacion);
                $WherePerdida = array('per_id_cot' => $id_cotizacion);

                $es_ganada = $this->cotModel->Existe_Registro("cog_cotiz_ganada", $WhereGanada);
                $es_perdida = $this->cotModel->Existe_Registro("per_perdido", $WherePerdida);

                if ($es_ganada == 1) {
                    $datos['estado_cotizacion'] = 1;
                    $datos['datos_ganada'] = $this->cotModel->get_tabla("cog_cotiz_ganada", "cog_id_cot", $id_cotizacion, "cog_id", "ASC");
                } else if ($es_perdida == 1) {
                    $datos['estado_cotizacion'] = 2;
                    $datos['datos_perdida'] = $this->cotModel->get_tabla("per_perdido", "per_id_cot", $id_cotizacion, "per_id", "ASC");
                } else {
                    $datos['estado_cotizacion'] = 3;
                }

                //die(print_r($datos['estado_cotizacion']));
                $filaCotizacion = $this->cotModel->get_registro('cot_cotizacion', 'cot_id', $id_cotizacion); //obtener registro

                $datos['datos_cotizacion'] = $filaCotizacion;
                //solo lectura del estado de la cotizacion en la vista del form cotizacion ganada-perdida (cuando haya sido registrada como perdida o ganada)
                $datos['Nombre_EstadoCotizacion'] = $this->gsatelite->get_campo('est_estado_cotizacion', 'est_nombre', array('est_id' => $filaCotizacion->cot_id_est));
                $datos['tabla_estado_cotizacion'] = $this->cotModel->get_tabla("est_estado_cotizacion", "est_estado", 1, "est_id", "ASC");
                $datos['datos_cliente'] = $this->cotModel->get_registro('cli_cliente', 'cli_id', $filaCotizacion->cot_id_cli); //obtener registro
                // $datos['todobien'] = $correcto;
                if ($correcto != "" and $correcto == "1") {
                    $datos['exito'] = "Operación realizada con Éxito";
                    $datos['clase'] = "ui-state-highlight";
                    $datos['icono'] = "ui-icon ui-icon-info";
                }
                if ($correcto != "" and $correcto == "2") {
                    $datos['exito'] = "Error en Realizar operación, Favor de intentar de nuevo";
                    $datos['clase'] = "ui-state-error";
                    $datos['icono'] = "ui-icon ui-icon-alert";
                }


                //preguntar si es vendedor
                $condicion1 = array('ven_id_usu' => $this->tank_auth->get_user_id(), 'ven_estado' => 1);
                $esVen = $this->cotModel->Existe_Registro("ven_vendedor", $condicion1);
                if ($esVen > 0) {
                    $datos["esVen"] = 1;
                    $datos['titulo_personal'] = "Establecer cotizaci&oacute;n Perdida";
                } else {
                    $datos['titulo_personal'] = "Establecer cotizaci&oacute;n como ganada o perdida2";
                }
                $this->_cargarvista($datos, null);
            } catch (Exception $e) {
                show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
            }
        }
    }

    /**
     * Cotizaciones::insert_update_cotizacion_ganada()
     *
     * @return void FUNCION PARA REALIZAR EL INSERT O ACTUALIZACION EN LA COG_COTIZ_GANADA
     */
    function insert_update_cotizacion_ganada()
    {

        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        }
        try {
            //var_dump($_POST);die();

            $bandera = $this->input->post('bandera');
            $id_cotizacion = $this->input->post('cotizacionID');
            //$id_nuevo_EstadoCot = $this->input->post('actualizar_estado_cotizacion');
            $estado = $this->input->post('estado_cotizacion');
            $estado2 = $estado;
            if ($bandera == 1) { //ES INSERCCION
                if ($estado == 1) { //insert a la tabla cotizacion ganada
                    //APLICAR LA VALIDACION
                    $this->form_validation->set_rules('fecha_cierre', 'Fecha', 'trim|required|xss_clean');

                    if ($this->form_validation->run() == false) { //preguntar si cumple con las validaciones
                        $correcto = 2;
                    } else {
                        //$this->cotModel->update_registros("cot_cotizacion", array('cot_id_est' => $id_nuevo_EstadoCot), "cot_id", $id_cotizacion);

                        $arregloDatos = array(
                            'cog_id_cot' => $id_cotizacion,
                            'cog_fecha_cierre' => formatear_fecha('Y-m-d', $this->input->post('fecha_cierre')),
                            //'cog_comision_real_p' => trim($this->input->post('comision_real_p')),
                            //'cog_comision_real_d' => trim($this->input->post('comision_real_d')),
                            'cog_causa_estado' => $this->input->post('observacion_cot_ganada'),
                            'cog_estado' => 1,
                            'cog_usu_crea' => $this->tank_auth->get_user_id(),
                            'cog_fecha_crea' => date('Y-m-d H:i:s'),
                            'cog_usu_mod' => $this->tank_auth->get_user_id(),
                            'cog_fecha_mod' => date('Y-m-d H:i:s')
                        );

                        if ($this->cotModel->insertar_registros("cog_cotiz_ganada", $arregloDatos)) {
                            $correcto = 1;
                        } else {
                            $correcto = 2;
                        }
                    }
                } else { //insert a la tabla cotizacion perdida
                    //APLICAR LA VALIDACION
                    $this->form_validation->set_rules('fecha_p', 'Fecha', 'trim|required|xss_clean');
                    $this->form_validation->set_rules('precio_p', 'Precio', 'trim|xss_clean');
                    $this->form_validation->set_rules('empresa', 'Empresa', 'trim|xss_clean');


                    if ($this->form_validation->run() == false) { //preguntar si cumple con las validaciones
                        $correcto = 2;
                    } else {
                        //$this->cotModel->update_registros("cot_cotizacion", array('cot_id_est' => $id_nuevo_EstadoCot), "cot_id", $id_cotizacion);
                        //preguntar si el precio viene vacio
                        if (trim($this->input->post('precio_p')) != "") {
                            $arregloDatos = array(
                                'per_id_cot' => $id_cotizacion,
                                'per_precio' => trim($this->input->post('precio_p')),
                                'per_empresa' => trim($this->input->post('empresa')),
                                'per_fecha_perdido' => formatear_fecha('Y-m-d', $this->input->post('fecha_p')),
                                'per_causa_estado' => trim($this->input->post('observacion_cot_perdida')),
                                'per_estado' => 1,
                                'per_usu_crea' => $this->tank_auth->get_user_id(),
                                'per_fecha_crea' => date('Y-m-d H:i:s'),
                                'per_usu_mod' => $this->tank_auth->get_user_id(),
                                'per_fecha_mod' => date('Y-m-d H:i:s')
                            );
                        } else {
                            $arregloDatos = array(
                                'per_id_cot' => $id_cotizacion,
                                'per_empresa' => trim($this->input->post('empresa')),
                                'per_fecha_perdido' => formatear_fecha('Y-m-d', $this->input->post('fecha_p')),
                                'per_causa_estado' => trim($this->input->post('observacion_cot_perdida')),
                                'per_estado' => 1,
                                'per_usu_crea' => $this->tank_auth->get_user_id(),
                                'per_fecha_crea' => date('Y-m-d H:i:s'),
                                'per_usu_mod' => $this->tank_auth->get_user_id(),
                                'per_fecha_mod' => date('Y-m-d H:i:s')
                            );
                        }


                        if ($this->cotModel->insertar_registros("per_perdido", $arregloDatos)) {
                            $correcto = 1;
                        } else {
                            $correcto = 2;
                        }
                    }
                }
            } else { //ES ACTUALIZACION
                $bandera_estado = $this->input->post('bandera_estado');

                if ($bandera_estado == 1) { //update a la tabla cotigacion ganada
                    $id_ganada = $this->input->post('registro_id');

                    $this->form_validation->set_rules('dato1', 'Fecha', 'trim|required|xss_clean');

                    if ($this->form_validation->run() == false) { //preguntar si cumple con las validaciones
                        $correcto = 2;
                    } else {

                        $arregloDatos = array(
                            'cog_id_cot' => $id_cotizacion,
                            'cog_fecha_cierre' => formatear_fecha('Y-m-d', $this->input->post('dato1')),
                            //'cog_comision_real_p' => trim($this->input->post('dato2')),
                            //'cog_comision_real_d' => trim($this->input->post('dato3')),
                            'cog_causa_estado' => trim($this->input->post('dato4')),
                            'cog_estado' => 1,
                            'cog_usu_mod' => $this->tank_auth->get_user_id(),
                            'cog_fecha_mod' => date('Y-m-d H:i:s')
                        );
                        if ($this->cotModel->update_registros("cog_cotiz_ganada", $arregloDatos, "cog_id", $id_ganada)) {
                            $correcto = 1;
                        } else {
                            $correcto = 2;
                        }
                    }
                } else { //update a la tabla cotigacion perdida
                    $id_perdida = $this->input->post('registro_id');


                    //$this->form_validation->set_message('required', 'El campo %s es requerido');
                    $this->form_validation->set_rules('dato1', 'Fecha', 'trim|required|xss_clean');
                    $this->form_validation->set_rules('dato2', 'Precio', 'trim|xss_clean');
                    $this->form_validation->set_rules('dato3', 'Empresa', 'trim|xss_clean');


                    if ($this->form_validation->run() == false) { //preguntar si cumple con las validaciones
                        $correcto = 2;
                    } else {
                        if (trim($this->input->post('dato2')) != "") {
                            $arregloDatos = array(
                                'per_id_cot' => $id_cotizacion,
                                'per_precio' => trim($this->input->post('dato2')),
                                'per_empresa' => trim($this->input->post('dato3')),
                                'per_fecha_perdido' => formatear_fecha('Y-m-d', $this->input->post('dato1')),
                                'per_causa_estado' => trim($this->input->post('dato4')),
                                'per_estado' => 1,
                                'per_usu_mod' => $this->tank_auth->get_user_id(),
                                'per_fecha_mod' => date('Y-m-d H:i:s')
                            );
                        } else {
                            $arregloDatos = array(
                                'per_id_cot' => $id_cotizacion,
                                'per_precio' => NULL,
                                'per_empresa' => trim($this->input->post('dato3')),
                                'per_fecha_perdido' => formatear_fecha('Y-m-d', $this->input->post('dato1')),
                                'per_causa_estado' => trim($this->input->post('dato4')),
                                'per_estado' => 1,
                                'per_usu_mod' => $this->tank_auth->get_user_id(),
                                'per_fecha_mod' => date('Y-m-d H:i:s')
                            );
                        }


                        if ($this->cotModel->update_registros("per_perdido", $arregloDatos, "per_id", $id_perdida))
                            $correcto = 1;
                        else
                            $correcto = 2;
                    }
                }
            }
            //var_dump($estado); die();

            if ($estado == 1) {
                redirect("cotizaciones/cotizaciones/establecer_cotizacion_ganada/$id_cotizacion/$correcto", null);
            } else {
                redirect("cotizaciones/cotizaciones/establecer_cotizacion_perdida/$id_cotizacion/$correcto", null);
            }
        } catch (exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    function agregar_control_sac()
    {
        satelite_validar();
        if ($_POST) {
            $post_array         = $_POST;                   // Array POST
            $cliente_nuevo      = $post_array['cliente_n'];
            $idCliente          = $post_array['slcCliente'];
            $motivo             = $post_array['slcMotivo'];
            $categoria          = $post_array['slcCategoria'];
            $producto           = $post_array['slcProducto'];
            $personeria         = $post_array['slcPersoneria'];
            $nombre_cliente     = $post_array['txtNombre'];
            $apellido_cliente   = $post_array['txtApellido'];
            $telefono_cliente   = $post_array['contacto_telefono'];
            $telefono_celular   = $post_array['contacto_celular'];
            $correo_cliente     = $post_array['correo'];
            $direccion_cliente  = $post_array['txtDireccion'];
            $mensaje            = $post_array['txtMensaje'];
            $fecha_inicio_garantia = $post_array['txtFechaInicioGarantia'];
            $fecha_nacimiento   = $post_array['txtFechaNacimiento'];
            $genero_cliente     = $post_array['slcGenero'];
            $contacto_cliente   = $post_array['txtContacto'];
            $sector_cliente     = $post_array['slcSector'];
            $ejecutivo_asignado = $post_array['slcEjecutivo'];
            $medio_contacto     = $post_array['slcMedios'];
            $fecha_proximo_contacto = $post_array['txtFechaProximoContacto'];
            $estado             = $post_array['slcEstado'];
            $datosCliente       = $this->gsatelite->get_tabla('cli_cliente', array('cli_id' => $idCliente));

            $llamada_array = array(
                'tbl_id_sec'    => ($post_array['slcSector'] != '') ? $post_array['slcSector'] : null,
                'tbl_id_ven'    => ($post_array['slcEjecutivo'] != '') ? $post_array['slcEjecutivo'] : null,
                'tbl_id_cli'    => ($post_array['slcCliente'] != '') ? $post_array['slcCliente'] : null,
                'tbl_id_art'    =>  null,
                'tbl_id_gen'    => ($post_array['slcGenero'] != '') ? $post_array['slcGenero'] : null,
                'tbl_id_mat'    => ($post_array['slcMotivo'] != '') ? $post_array['slcMotivo'] : null,
                'tbl_id_esn'    => ($post_array['slcEstado'] != '') ? $post_array['slcEstado'] : null,
                'tbl_fecha'     => date('Y-m-d H:i:s'),
                'tbl_personeria'        => ($post_array['slcPersoneria'] != '') ? $post_array['slcPersoneria'] : null,
                'tbl_cliente_nombre'    => ($post_array['txtNombre'] != '' and trim($post_array['slcCliente']) == '') ? $post_array['txtNombre'] : null,
                'tbl_cliente_apellido'  => ($post_array['txtApellido'] != '' and trim($post_array['slcCliente']) == '') ? $post_array['txtApellido'] : null,
                'tbl_contacto'  => ($post_array['txtContacto'] != '') ? $post_array['txtContacto'] : null,
                'tbl_nuevo'     => (isset($_POST['cliente_n'])) ? 1 : null,
                'tbl_usu_recibe' => $this->tank_auth->get_user_id(),
                'tbl_recado'    => ($post_array['txtMensaje'] != '') ? $post_array['txtMensaje'] : null,
                'tbl_telefono'  => ($post_array['contacto_telefono'] != '') ? $post_array['contacto_telefono'] : null,
                'tbl_celular'   => ($post_array['contacto_celular'] != '') ? $post_array['contacto_celular'] : null,
                'tbl_correo'    => ($post_array['correo'] != '') ? $post_array['correo'] : null,
                'tbl_direccion' => ($post_array['txtDireccion'] != '') ? $post_array['txtDireccion'] : null,
                'tbl_fecha_inicio_garantia' => ($post_array['txtFechaInicioGarantia'] != '') ? formatear_fecha('Y-m-d H:i:s', $post_array['txtFechaInicioGarantia']) : null,
                'tbl_fecha_nacimiento'      => ($post_array['txtFechaNacimiento'] != '') ? formatear_fecha('Y-m-d H:i:s', $post_array['txtFechaNacimiento']) : null,
                'tbl_fecha_prox_contacto'   => ($post_array['txtFechaProximoContacto'] != '') ? formatear_fecha('Y-m-d H:i:s', $post_array['txtFechaProximoContacto']) : null,
                'tbl_estado'    => 1,
                'tbl_usu_crea'  => $this->tank_auth->get_user_id(),
                'tbl_fecha_crea' => date('Y-m-d H:i:s'),
                'tbl_fecha_mod' => date('Y-m-d H:i:s'),
                'tbl_usu_mod'   => $this->tank_auth->get_user_id(),
            );

            $insertar_llamada = $this->gsatelite->ingresar('tbl_tabla_llamadas', $llamada_array);

            if ($insertar_llamada) {
                if ((is_array($post_array['slcProducto'])) && (count($post_array['slcProducto']) > 0)) {
                    for ($i = 0; $i < count($post_array['slcProducto']); $i++) {
                        $array_productos         = array(
                            'rxt_id_tbl'             => $insertar_llamada,
                            'rxt_id_art'             => $post_array['slcProducto'][$i],
                            'rxt_estado'             => 1,
                            'rxt_usu_creacion'       => $this->tank_auth->get_user_id(),
                            'rxt_fecha_creacion'     => date('Y-m-d H:i:s'),
                            'rxt_usu_modificacion'   => $this->tank_auth->get_user_id(),
                            'rxt_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('rxt_articuloxtabla_llamada', $array_productos);
                    }
                }
            }

            if ($insertar_llamada > 0) {
                if (count($medio_contacto) > 0) {
                    for ($i = 0; $i < count($medio_contacto); $i++) {
                        $medio_contacto_array = array(
                            'txt_id_tbl' => $insertar_llamada,
                            'txt_id_tmc' => $medio_contacto[$i],
                        );

                        $this->gsatelite->ingresar('txt_tabla_llamadaxtipo_medio', $medio_contacto_array);
                    }
                }

                $id_llamada = $this->gsatelite->get_parametro('SYS_SEGUIMIENTO_LLAMADA');
                if ($id_llamada > 0) {
                    $reg = $this->gsatelite->get_tabla('tsg_tipo_seguimiento', array('tsg_id' => $id_llamada));
                    if (count($reg) > 0) {
                        $seguimiento = array(
                            'sel_id_tsg' => $id_llamada,
                            'sel_id_esn' => ($post_array['slcEstado'] != '') ? $post_array['slcEstado'] : null,
                            'sel_id_tbl' => $insertar_llamada,
                            'sel_id_ven' => ($post_array['slcEjecutivo'] != '') ? $post_array['slcEjecutivo'] : null,
                            'sel_fecha'  => date('Y-m-d H:i:s'),
                            'sel_fecha_proximo' => ($post_array['txtFechaProximoContacto'] != '') ? formatear_fecha('Y-m-d H:i:s', $post_array['txtFechaProximoContacto']) : null,
                            'sel_comentario' => ($post_array['txtMensaje'] != '') ? $post_array['txtMensaje'] : '',
                            'sel_notificado' => 0,
                            'sel_estado'     => 1,
                            'sel_usu_creacion'   => $this->tank_auth->get_user_id(),
                            'sel_fecha_creacion' => date('Y-m-d H:i:s'),
                            'sel_fecha_modificacion'  => date('Y-m-d H:i:s'),
                            'sel_usu_modificacion'    => $this->tank_auth->get_user_id()
                        );

                        $this->gsatelite->ingresar('sel_seguimiento_llamada', $seguimiento);
                    }
                }
                //if($id_llamada = )

                $alerta     = array('tipo_alerta' => 'success', 'titulo_alerta' => "Éxito en la operación", 'texto_alerta' => "Operación realizada con Éxito");

                $this->session->set_flashdata($alerta);

                if ($this->input->post('btnCrear') == 1) {
                    redirect('cotizaciones/cotizaciones/agregar_control_sac');
                } else {
                    redirect('cotizaciones/cotizaciones/tabla_llamadas');
                }
            } else {

                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "Hubó un problema al realizar la operación");

                if ($this->input->post('btnCrear') == 1) {
                    redirect('cotizaciones/cotizaciones/agregar_control_sac');
                } else {
                    redirect('cotizaciones/cotizaciones/tabla_llamadas');
                }

                $this->session->set_flashdata($alerta);
                redirect('cotizaciones/cotizaciones/tabla_llamadas');
            }
        } else {
            $data['clientes']   = $this->gsatelite->get_dropdown('cli_cliente', "[IF(cli_personeria=1,CONCAT_WS(' ', cli_codigo, cli_nombre, cli_apellido),CONCAT_WS(' ', cli_codigo, cli_apellido))]", '', array('cli_estado' => 1), null, null, null, true);
            $data['sector']     = $this->gsatelite->get_dropdown('sec_sector_cliente', '{sec_nombre}', '', array('sec_estado' => 1), null, null, null, true);
            $data['categoria']  = $this->gsatelite->get_dropdown('tia_tipo_articulo', '{tia_codigo} - {tia_nombre}', '', array('tia_estado' => 1), null, null, null, true);
            $data['vendedores'] = $this->gsatelite->get_dropdown('ven_vendedor', '{ven_nombre} {ven_apellidos}', '', array('ven_estado' => 1), null, null, null, true);
            $data['genero']     = $this->gsatelite->get_dropdown('gen_genero', '{gen_nombre}', '', array('gen_estado' => 1), null, null, null, true);
            $data['motivo_a']   = $this->gsatelite->get_dropdown('mat_motivo_atencion', '{mat_nombre}', '', array('mat_estado' => 1), null, null, null, true);
            $data['estado_a']   = $this->gsatelite->get_dropdown('esn_estado_atencion', '{esn_nombre}', '', array('esn_estado' => 1), null, null, null, true);
            $data['medios']     = $this->gsatelite->get_dropdown('tmc_tipo_medio', '{tmc_nombre}', '', array('tmc_estado' => 1), null, null, null, true);
            //$data['medios']  = $this->gsatelite->get_tabla('tmc_tipo_medio', array('tmc_estado'=>1));
            //print_r($data['medios']); die();
        }

        $data['titulo_personal'] = "Control de servicio al cliente";
        $this->_cargarvista($data);
    }

    // cierre function
    function editar_control_sac($tblsac_id, $solo_lectura = false)
    {
        satelite_validar();
        $data['solo_lectura'] = $solo_lectura;
        if ($_POST) {
            //ie(print_r($_POST));
            //echo $tblsac_id; die();       tblsac_id
            $post_array         = $_POST;
            $cliente_nuevo      = $post_array['cliente_n'];
            $idCliente          = $post_array['slcCliente'];
            $motivo             = $post_array['slcMotivo'];
            $categoria          = $post_array['slcCategoria'];
            $producto           = $post_array['slcProducto'];
            $personeria         = $post_array['slcPersoneria'];
            $nombre_cliente     = $post_array['txtNombre'];
            $apellido_cliente   = $post_array['txtApellido'];
            $telefono_cliente   = $post_array['contacto_telefono'];
            $telefono_celular   = $post_array['contacto_celular'];
            $correo_cliente     = $post_array['correo'];
            $direccion_cliente  = $post_array['txtDireccion'];
            $mensaje            = $post_array['txtMensaje'];
            $fecha_inicio_garantia = $post_array['txtFechaInicioGarantia'];
            $fecha_nacimiento   = $post_array['txtFechaNacimiento'];
            $genero_cliente     = $post_array['slcGenero'];
            $contacto_cliente   = $post_array['txtContacto'];
            $sector_cliente     = $post_array['slcSector'];
            $ejecutivo_asignado = $post_array['slcEjecutivo2'];
            $medio_contacto     = $post_array['slcMedios'];
            $fecha_proximo_contacto = $post_array['txtFechaProximoContacto'];
            $estado             = $post_array['slcEstado'];


            $datosCliente = $this->gsatelite->get_tabla('cli_cliente', array('cli_id' => $post_array['slcCliente']));

            $llamada_array = array(
                'tbl_id_sec'    => ($post_array['slcSector'] != '') ? $post_array['slcSector'] : null,
                'tbl_id_ven'    => ($post_array['slcEjecutivo2'] != '') ? $post_array['slcEjecutivo2'] : null,
                'tbl_id_cli'    => ($post_array['slcCliente'] != '') ? $post_array['slcCliente'] : null,
                'tbl_id_art'    =>  null,
                'tbl_id_gen'    => ($post_array['slcGenero'] != '') ? $post_array['slcGenero'] : null,
                'tbl_id_mat'    => ($post_array['slcMotivo'] != '') ? $post_array['slcMotivo'] : null,
                'tbl_id_esn'    => ($post_array['slcEstado'] != '') ? $post_array['slcEstado'] : null,
                'tbl_fecha'     => date('Y-m-d H:i:s'),
                'tbl_personeria' => ($post_array['slcPersoneria'] != '') ? $post_array['slcPersoneria'] : null,
                'tbl_cliente_nombre'    => ($post_array['txtNombre'] != '') ? $post_array['txtNombre'] : null, //se quito la validacion para slcclinte
                'tbl_cliente_apellido'  => ($post_array['txtApellido'] != '') ? $post_array['txtApellido'] : null,
                'tbl_contacto'          => ($post_array['txtContacto'] != '') ? $post_array['txtContacto'] : null,
                'tbl_nuevo'     => (isset($_POST['cliente_n'])) ? 1 : null,
                'tbl_usu_recibe' => $this->tank_auth->get_user_id(),
                'tbl_recado'    => ($post_array['txtMensaje'] != '') ? $post_array['txtMensaje'] : null,
                'tbl_telefono'  => ($post_array['contacto_telefono'] != '') ? $post_array['contacto_telefono'] : null,
                'tbl_celular'   => ($post_array['contacto_celular'] != '') ? $post_array['contacto_celular'] : null,
                'tbl_correo'    => ($post_array['correo'] != '') ? $post_array['correo'] : null,
                'tbl_direccion' => ($post_array['txtDireccion'] != '') ? $post_array['txtDireccion'] : null,
                'tbl_fecha_inicio_garantia' => ($post_array['txtFechaInicioGarantia'] != '') ? formatear_fecha('Y-m-d H:i:s', $post_array['txtFechaInicioGarantia']) : null,
                'tbl_fecha_nacimiento'      => ($post_array['txtFechaNacimiento'] != '') ? formatear_fecha('Y-m-d H:i:s', $post_array['txtFechaNacimiento']) : null,
                'tbl_fecha_prox_contacto'   => ($post_array['txtFechaProximoContacto'] != '') ? formatear_fecha('Y-m-d H:i:s', $post_array['txtFechaProximoContacto']) : null,
                'tbl_estado'    => 1,
                'tbl_fecha_mod' => date('Y-m-d H:i:s'),
                'tbl_usu_mod'   => $this->tank_auth->get_user_id(),
            );

            $registro = $this->gsatelite->actualizar_array('tbl_tabla_llamadas', $llamada_array, array('tbl_id' => $tblsac_id));

            if ($registro) {
                $this->gsatelite->borrado_general('rxt_articuloxtabla_llamada', array('rxt_id_tbl' => $tblsac_id));
                if ((is_array($post_array['slcProducto'])) && (count($post_array['slcProducto']) > 0)) {
                    for ($i = 0; $i < count($post_array['slcProducto']); $i++) {
                        $array_productos         = array(
                            'rxt_id_tbl'             => $tblsac_id,
                            'rxt_id_art'             => $post_array['slcProducto'][$i],
                            'rxt_estado'             => 1,
                            'rxt_usu_creacion'       => $this->tank_auth->get_user_id(),
                            'rxt_fecha_creacion'     => date('Y-m-d H:i:s'),
                            'rxt_usu_modificacion'   => $this->tank_auth->get_user_id(),
                            'rxt_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('rxt_articuloxtabla_llamada', $array_productos);
                    }
                }
            }

            if ($registro > 0) {
                //Se eliminan los medios ya existentes
                $this->gsatelite->borrado_general('txt_tabla_llamadaxtipo_medio', array('txt_id_tbl' => $tblsac_id));

                if (count($medio_contacto) > 0) {
                    for ($i = 0; $i < count($medio_contacto); $i++) {
                        $medio_contacto_array = array(
                            'txt_id_tbl' => $tblsac_id,
                            'txt_id_tmc' => $medio_contacto[$i],
                        );

                        $this->gsatelite->ingresar('txt_tabla_llamadaxtipo_medio', $medio_contacto_array);
                    }
                }

                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Éxito en la operación", 'texto_alerta' => "Operación realizada con Éxito");

                $this->session->set_flashdata($alerta);
                if ($this->input->post('btnCrear') == 1) {
                    redirect('cotizaciones/cotizaciones/editar_control_sac/' . $tblsac_id);
                } else {
                    redirect('cotizaciones/cotizaciones/tabla_llamadas');
                }
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "Hubó un problema al realizar la operación");

                $this->session->set_flashdata($alerta);
                if ($this->input->post('btnCrear') == 1) {
                    redirect('cotizaciones/cotizaciones/editar_control_sac/' . $tblsac_id);
                } else {
                    redirect('cotizaciones/cotizaciones/tabla_llamadas');
                }
            }
        } else {

            $data['tbl_id'] = $tblsac_id;
            $info = $this->gsatelite->get_tabla('tbl_tabla_llamadas', array('tbl_id' => $tblsac_id));
            $data['info'] = $info[0];
            $rxt = $this->gsatelite->get_tabla('rxt_articuloxtabla_llamada', array('rxt_id_tbl' => $tblsac_id));


            $medios_seleccionados = $this->gsatelite->get_tabla('txt_tabla_llamadaxtipo_medio', array('txt_id_tbl' => $tblsac_id));
            $seleccionados = array();
            foreach ($medios_seleccionados as $mseleccionados) {
                $seleccionados[] = $mseleccionados['txt_id_tmc'];
            }

            $items = (count($seleccionados) > 0) ? $seleccionados : null;

            if (count($rxt) > 0) {

                $info_categoria = $this->gsatelite->get_tabla('art_articulo', array('art_id' => $info[0]['tbl_id_art']));

                $data['categoria'] = $this->gsatelite->get_dropdown('tia_tipo_articulo', '{tia_nombre}', '', array('tia_estado' => 1), $info_categoria[0]['art_id_tia'], null, null, true);

                $ids = '(' . implode(',', array_column($rxt, 'rxt_id_art')) . ')';
                $data['articulo'] = $this->gsatelite->get_dropdown('art_articulo', '{art_nombre}', '', array('art_estado' => 1, 'art_id in ' . $ids . '' => null), array_column($rxt, 'rxt_id_art'), null, null, true);
            } else {

                $data['categoria'] = $this->gsatelite->get_dropdown('tia_tipo_articulo', '{tia_nombre}', '', array('tia_estado' => 1), null, null, null, true);
            }

            $data['clientes'] = $this->gsatelite->get_dropdown('cli_cliente', "[IF(cli_personeria=1,CONCAT_WS(' ', cli_codigo, cli_nombre, cli_apellido),CONCAT_WS(' ', cli_codigo, cli_apellido))]", '', array('cli_estado' => 1), $info[0]['tbl_id_cli'], null, null, true);
            $data['sector'] = $this->gsatelite->get_dropdown('sec_sector_cliente', '{sec_nombre}', '', array('sec_estado' => 1), $info[0]['tbl_id_sec'], null, null, true);
            $data['vendedores'] = $this->gsatelite->get_dropdown('ven_vendedor', '{ven_nombre} {ven_apellidos}', '', array('ven_estado' => 1), $info[0]['tbl_id_ven'], null, null, true);
            $data['genero'] = $this->gsatelite->get_dropdown('gen_genero', '{gen_nombre}', '', array('gen_estado' => 1), $info[0]['tbl_id_gen'], null, null, true);
            $data['motivo_a'] = $this->gsatelite->get_dropdown('mat_motivo_atencion', '{mat_nombre}', '', array('mat_estado' => 1), $info[0]['tbl_id_mat'], null, null, true);
            $data['estado_a'] = $this->gsatelite->get_dropdown('esn_estado_atencion', '{esn_nombre}', '', array('esn_estado' => 1), $info[0]['tbl_id_esn'], null, null, true);
            $data['medios'] = $this->gsatelite->get_dropdown('tmc_tipo_medio', '{tmc_nombre}', '', array('tmc_estado' => 1), $items, null, null, true);
            //print_r($info[0]); die();
            $data['contacto'] = $info[0]['tbl_contacto'];
            $data['tllClienteNombre'] = $info[0]['tbl_cliente_nombre'];
            $data['tllClienteApellido'] = $info[0]['tbl_cliente_apellido'];
            $data['tllFechaNacimiento'] = formatear_fecha('d-m-Y', $info[0]['tbl_fecha_nacimiento']);
            $data['tllFechaProxContacto'] = formatear_fecha('d-m-Y', $info[0]['tbl_fecha_prox_contacto']);
            $data['tllFechaIniGarantia'] = formatear_fecha('d-m-Y', $info[0]['tbl_fecha_inicio_garantia']);
            $data['tllTelefono'] = $info[0]['tbl_telefono'];
            $data['tllCelular'] = $info[0]['tbl_celular'];
            $data['tllCorreo'] = $info[0]['tbl_correo'];
            $data['tllDireccion'] = $info[0]['tbl_direccion'];
            $data['tllPersoneria'] = $info[0]['tbl_personeria'];
        }

        $data['titulo_personal'] = (($solo_lectura) ? "Ver " : "Editar ") . "Control de servicio al cliente";
        $this->_cargarvista($data, null, "cotizaciones/cotizaciones/editar_control_sac");
    }

    // cierre function editar_control_sac

    function ver_control_sac($tblsac_id)
    {
        satelite_validar();
        $this->editar_control_sac($tblsac_id, true);
    }

    /* Obtener los articulos por tipo_articulo */

    function get_art_x_tia()
    {

        $idTia = $this->input->post('filtro');
        $opciones = "<option></option>";

        $articulos = $this->gsatelite->get_tabla('art_articulo', array('art_id_tia' => $idTia, 'art_estado' => 1));

        foreach ($articulos as $row) {
            $opciones .= "<option value='" . $row['art_id'] . "'>" . $row['art_nombre'] . "</option>";
        }

        echo $opciones;
    }

    /**
     * @author Elman Ortiz
     * @fecha 27/02/2017
     * @descripcion agregar url personalizada para la opcion de editar
     */
    function add_url_action_editar($primary_key, $row)
    {
        $p1 = $this->gsatelite->get_tabla('cog_cotiz_ganada', array('cog_id_cot' => $row->cot_id));
        $p2 = $this->gsatelite->get_tabla('per_perdido', array('per_id_cot' => $row->cot_id));
        if (count($p1) > 0 or count($p2) > 0) {
            return base_url('quitar_accion_editar');
        } else {
            return base_url('cotizaciones/cotizaciones/editar_cotizacion/' . $row->cot_id);
        }
    }

    /**
     * @author Elman Ortiz
     * @fecha 28/02/2017
     * @descripcion agregar url personalizada para la opcion de ganada
     */
    function add_url_action_ganada($primary_key, $row)
    {
        $p2 = $this->gsatelite->get_tabla('per_perdido', array('per_id_cot' => $row->cot_id));
        if (count($p2) > 0) {
            return base_url('quitar_accion_ganada');
        } else {
            return base_url('cotizaciones/cotizaciones/establecer_cotizacion_ganada/' . $row->cot_id);
        }
    }

    /**
     * @author Elman Ortiz
     * @fecha 28/02/2017
     * @descripcion agregar url personalizada para la opcion de perdida
     */
    function add_url_action_perdida($primary_key, $row)
    {
        $p1 = $this->gsatelite->get_tabla('cog_cotiz_ganada', array('cog_id_cot' => $row->cot_id));
        if (count($p1) > 0) {
            return base_url('cotizaciones/cotizaciones/establecer_cotizacion_perdida/' . $row->cot_id . '/1');
        } else {
            return base_url('cotizaciones/cotizaciones/establecer_cotizacion_perdida/' . $row->cot_id);
        }
    }

    /**
     * @author Elman Ortiz
     * @fecha 27/02/2017
     * @descripcion agregar url personalizada para la opcion de seguimiento
     */
    function add_url_action_seguimiento($primary_key, $row)
    {
        $p1 = $this->gsatelite->get_tabla('cog_cotiz_ganada', array('cog_id_cot' => $row->cot_id));
        $p2 = $this->gsatelite->get_tabla('per_perdido', array('per_id_cot' => $row->cot_id));
        if (count($p1) > 0 or count($p2) > 0) {
            return base_url('quitar_accion_seguimiento');
        } else {
            return base_url('cotizaciones/cotizaciones/seguimiento_cotizacion/' . $row->cot_id);
        }
    }

    /**
     * @author René Castaneda
     * @since 2017-07-28
     * @return llamadas
     */
    public function tabla_llamadas()
    {
        $fecha = date_create(date('Y-m-d'));
        date_add($fecha, date_interval_create_from_date_string('-1 months'));
        $fecha_inicio = date_format($fecha, 'Y-m-01');
        //die();
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();
        $data['permisos'] = $permisos;
        $data['titulo_personal'] = "Control de servicio al cliente";
        $where['date_format(tbl_fecha,"%Y-%m-%d") >='] = $fecha_inicio;
        $where['date_format(tbl_fecha,"%Y-%m-%d") <='] = date('Y-m-t');
        $data['registros']  = $this->cotModel->get_tabla_llamadas($where);

        //print_r($this->db->last_query()); die();

        $data['vendedores'] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $this->gsatelite->get_dropdown('ven_vendedor', '{ven_nombre} {ven_apellidos}', '', array('ven_estado' => 1), null, null, null, true));
        $data['medios_contacto']  = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $this->gsatelite->get_dropdown('tmc_tipo_medio', '{tmc_nombre}', '', array('tmc_estado' => 1), null, null, null, true));
        $data['motivos']    = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $this->gsatelite->get_dropdown('mat_motivo_atencion', '{mat_nombre}', '', array('mat_estado' => 1), null, null, null, true));
        $data['clientes'] = $this->gsatelite->get_dropdown('cli_cliente', "[CASE WHEN cli_personeria = 1 THEN CONCAT_WS(' ',cli_codigo,' - ', cli_nombre, cli_apellido) ELSE  CONCAT_WS(' ',cli_codigo,' - ', cli_apellido) END]", 'clientes', array('cli_estado' => 0), null, null, null, true);

        $data['fecha_inicio'] = formatear_fecha('d-m-Y', $fecha_inicio);
        $data['fecha_fin']    = date('t-m-Y');
        //print_r($this->db->last_query()); die();
        cargarvista($data);
    }

    /**
     * @author René Castaneda
     * @since 2017-07-28
     * @return filtrar llamadas
     */
    public function filtrar_tabla_llamadas($es_reporte = 0)
    {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion('tabla_llamadas');
        $data['permisos'] = $permisos;
        if ($this->input->post()) {
            $fecha_inicio = formatear_fecha('Y-m-d', $this->input->post('txtFecha_desde'));
            $fecha_fin = formatear_fecha('Y-m-d', $this->input->post('txtFecha_hasta'));
            $where = array("DATE_FORMAT(tbl_fecha, '%Y-%m-%d') >=" => "$fecha_inicio", "DATE_FORMAT(tbl_fecha, '%Y-%m-%d') <=" => "$fecha_fin");

            if ($this->input->post('slcVendedor') > 0) {
                $where['tbl_id_ven'] = $this->input->post('slcVendedor');
            }

            if ($this->input->post('slcmotivo') > 0) {
                $where['tbl_id_mat'] = $this->input->post('slcmotivo');
            }

            if ($this->input->post('slcMedioContacto') > 0) {
                $where['txt_id_tmc'] = $this->input->post('slcMedioContacto');
            }
        }
        $data['registros'] = $this->cotModel->get_tabla_llamadas($where);
        //print_r($this->db->last_query()); die();
        $data['txtFecha_desde'] = $this->input->post('txtFecha_desde');
        $data['txtFecha_hasta'] = $this->input->post('txtFecha_hasta');
        $data['slcVendedor'] = $this->input->post('slcVendedor');
        $data['es_reporte'] = $es_reporte;
        $html = $this->load->view('cotizaciones/cotizaciones/filtrar_tabla_llamadas', $data, true);

        $filtro_titulo = "";
        if ($es_reporte) {
            $txtFecha_desde = formatear_fecha('d-m-Y', $this->input->post('txtFecha_desde'));
            $txtFecha_hasta = formatear_fecha('d-m-Y', $this->input->post('txtFecha_hasta'));
            $tipo_accion = $this->input->post('tipo_accion');
            $filtro_titulo .= ($txtFecha_desde != '') ? " Desde: " . $txtFecha_desde : "";
            $filtro_titulo .= ($txtFecha_hasta != '') ? " Hasta: " . $txtFecha_hasta : "";

            if ($tipo_accion) { //excel
                header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                header("Content-Disposition: attachment;filename=control_SAC_" . date('d-m-Y_His') . ".xls");
                header("Pragma: no-cache");
                header("Expires: 0");
                echo '<meta charset="utf-8" />';
                echo "<table border='0'>
                  <tr><th colspan='7' align='center' >" . mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8') . "</th></tr>
                  <tr><th colspan='7' align='center' >Reporte Control SAC</th></tr>
                  <tr><th colspan='7' align='center' >" . $filtro_titulo . "</th></tr>
                  </table>";
                echo $html;
                die();
            } else { //pdf
                ini_set('memory_limit', '2048M');
                ini_set('max_execution_time', '9999');

                $this->load->library('pdf');
                $html_header = $this->load->view('reporte/header', array('titulo' => "Reporte control SAC<br /> $filtro_titulo", 'solotitulo' => true), true);
                $html = str_replace(' border="1" class="responsive table table-bordered"', 'border="0.5" width="100%" style="width: 100%; font-size:9px;"', $html);
                // echo $html_header.$html; die();
                $this->pdf->makePDF($html_header . $html, 'lanscape', 'plan_trabajo', 'legal');
                die();
            }
        }


        echo json_encode(array('html' => $html));
    }

    /**
     * @author René Castaneda
     * @since  2017-07-31
     * @return datos del cliente
     */
    public function get_info_cliente()
    {
        $id_cliente = $this->input->post('id_cliente');

        /******************* DATOS DEL CLIENTE ******************************************/
        $query = $this->gsatelite->get_tabla('cli_cliente', array('cli_id' => $id_cliente));

        /******************* DROPDOWN MULTIPLE DE MEDIOS DE CONTACTO ******************************************/
        $consul = $this->gsatelite->get_tabla('cxm_clientexmediocontacto', array('cxm_id_cli' => $id_cliente));
        $seleccionados = array();
        foreach ($consul as $f) {
            $seleccionados[] = $f['cxm_id_tmc'];
        }
        $items = (count($seleccionados) > 0) ? $seleccionados : null;

        $select = $this->gsatelite->get_dropdown('tmc_tipo_medio', '{tmc_nombre}', '', array('tmc_estado' => 1), $items, '', 'tmc_id', true);
        $select = str_replace('<option value="0">Seleccione</option>', '', $select);
        $medios = str_replace('<option value="0">Sin Registros</option>', '<option value=""></option>', $select);

        /******************* TELÉFONOS DEL CLIENTE ******************************************/
        $par_tel = $this->gsatelite->get_parametro('SYS_TIPO_TELEFONO', 0);
        $tipos_array = json_decode($par_tel, true);

        $tit_oficina = $tipos_array['OFICINA'];
        $tel_oficina = $this->gsatelite->get_campo('txc_telefonoxcliente', 'txc_numero', array('txc_id_cli' => $id_cliente, 'txc_id_tit' => $tit_oficina));
        $tit_celular = $tipos_array['CELULAR'];
        $tel_celular = $this->gsatelite->get_campo('txc_telefonoxcliente', 'txc_numero', array('txc_id_cli' => $id_cliente, 'txc_id_tit' => $tit_celular));

        $contactos = $this->gsatelite->get_tabla('con_contacto', array('con_id_cli' => $id_cliente, 'con_estado' => 1));

        $datos_cli = array(
            'cli_nombre'   => $query[0]['cli_nombre'],
            'cli_apellido' => $query[0]['cli_apellido'],
            'cli_apellido' => $query[0]['cli_apellido'],
            'cli_email'    => $query[0]['cli_email'],
            'cli_direccion' => $query[0]['cli_direccion'],
            'vendedor_cli' => $query[0]['cli_id_ven'],
            'nombre_contacto' => $contactos[0]['con_nombre'],
            'medios'       => $medios,
            'tel_oficina'  => $tel_oficina,
            'tel_celular'  => $tel_celular,
            'cli_personeria' => $query[0]['cli_personeria']
        );

        die(json_encode($datos_cli));
    }

    public function eliminar_control_sac($id)
    {
        $update_array = array(
            'tbl_estado' => '0',
            'tbl_fecha_mod' => date('Y-m-d H:i:s'),
            'tbl_usu_mod' => $this->tank_auth->get_user_id()
        );
        $this->gsatelite->actualizar_array('tbl_tabla_llamadas', $update_array, array('tbl_id' => $id));
        $this->gsatelite->show_dialog('Registro Desactivado con éxito', 'cotizaciones/cotizaciones/tabla_llamadas', 'success');
    }

    /**
     * Descripcion:
     * Mantenimiento de encuestas y preguntas
     * @author Nelson David Soriano
     * @since  30-11-2018
     * 
     * 
     **/
    public function preguntas_encuestas()
    {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();
        $crud = new grocery_CRUD();

        $alias  = array(
            'ent_nombre'          => 'Nombre',
            'ent_observacion'     => 'Observacion',
            'ent_fecha_creacion'  => 'Fecha Creacion',
            'ent_estado'          => 'Estado'
        );

        $columns = array(
            'ent_nombre',
            'ent_observacion',
            'ent_estado'
        );

        $edit    = array(
            'ent_nombre',
            'ent_observacion',
            'ent_usu_modificacion',
            'ent_fecha_modificacion',
            'ent_estado'
        );

        $add     = array(
            'ent_nombre',
            'ent_observacion',
            'ent_estado',
            'ent_usu_creacion',
            'ent_fecha_creacion',
            'ent_usu_modificacion',
            'ent_fecha_modificacion'
        );

        $required  = array(
            'ent_nombre',
            'ent_estado',
            'ent_usu_modificacion',
            'ent_fecha_modificacion'
        );

        $crud->set_table('ent_encuesta')
            //->set_subject('Encuesta')
            ->set_subject('')
            ->columns($columns)
            ->add_fields($add)
            ->edit_fields($edit)
            ->display_as($alias)
            ->required_fields($required)
            ->field_type('ent_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
            ->field_type('ent_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
            ->field_type('ent_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
            ->field_type('ent_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
            ->unset_export()->unset_print()->unset_delete();

        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('ent_estado', 'hidden', 1);
        } else {
            $crud->field_type('ent_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

        $crud->callback_column('ent_fecha_creacion', function ($value, $row) {
            return formatear_fecha('d-m-Y', $value);
        });

        if (!$permisos['permite_agregar']) {
            $crud->unset_add();
        }

        if (!$permisos['permite_editar']) {
            $crud->unset_edit();
        }

        $crud->add_action('Preguntas', 'icomoon-icon-file', 'cotizaciones/cotizaciones/manto_encuestas');

        $output = $crud->render();
        $data['titulo_personal'] = 'Encuestas';
        $this->_cargarvista($data, $output, 'cotizaciones/cotizaciones/preguntas_encuestas');
    }

    /**
     * Descripcion:
     * Funcion que devuelve el mantenimiento de Encuestas/preguntas/tipos
     * @author Nelson David Soriasno
     * @since  10-11-2018
     *   
     **/
    public function manto_encuestas($id)
    {
        satelite_validar();
        $id = (int) $id;
        if ($id != '') {
            $permisos = $this->gsatelite->get_permisos_opcion('cotizaciones/cotizaciones/preguntas_encuestas');
            $crud     = new grocery_CRUD();

            $add = array(
                'pge_id_tpe',
                'pge_id_ent',
                'pge_nombre',
                'pge_descripcion',
                'pge_orden',
                'pge_estado',
                'pge_fecha_creacion',
                'pge_usu_creacion',
                'pge_usu_modificacion',
                'pge_fecha_modificacion'
            );

            $edit = array(
                'pge_id_tpe',
                'pge_nombre',
                'pge_descripcion',
                'pge_orden',
                'pge_estado',
                'pge_fecha_modificacion',
                'pge_usu_modificacion'
            );

            $columns = array(
                'pge_nombre',
                'pge_descripcion',
                'pge_orden',
                'pge_estado'
            );

            $alias = array(
                'pge_nombre'            => 'Nombre Pregunta',
                'pge_descripcion'       => 'Descripcion',
                'pge_orden'             => 'Orden',
                'pge_fecha_creacion'    => 'Fecha creacion',
                'pge_id_tpe'            => 'Tipo Pregunta',
                'pge_estado'            => 'Estado'
            );

            $required = array(
                'pge_nombre',
                'pge_id_tpe',
                'pge_id_ent',
                'pge_estado',
                'pge_usu_modificacion',
                'pge_usu_creacion',
                'pge_fecha_creacion',
                'pge_fecha_modificacion'
            );
            $crud->set_table('pge_pregunta_encuesta')
                ->set_subject('Preguntas')
                ->columns($columns)
                ->add_fields($add)
                ->edit_fields($edit)
                ->required_fields($required)
                ->display_as($alias)
                ->unset_delete()
                ->set_relation('pge_id_tpe', 'tpe_tipo_pregunta', 'tpe_nombre', array('tpe_estado' => 1))
                ->where('pge_id_ent', $id)
                ->field_type('pge_id_ent', 'hidden', $id)
                ->field_type('pge_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('pge_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                ->field_type('pge_fecha_creacion', 'hidden', date('Y-m-d h:i:s'))
                ->field_type('pge_fecha_modificacion', 'hidden', date('Y-m-d h:i:s'))
            ;

            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('pge_estado', 'hidden', 1);
            } else {
                $crud->field_type('pge_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }

            $crud->callback_column('pge_fecha_creacion', function ($value, $row) {
                return formatear_fecha('d-m-Y', $value);
            });
            $output = $crud->render();
            $name = $this->sistema->get_registro("ent_encuesta", array('ent_id' => (int) $id));
            $data['titulo_personal'] = 'Encuesta : ' . $name['ent_nombre'];
            $this->_cargarvista($data, $output, 'cotizaciones/cotizaciones/manto_encuestas');
        }
    }

    /**
     * descripcion:
     * Funcion para exportar a excel todos los registros que existentes en la tabla base de datos
     * @author  Nelson Soriano
     * @since   17-12-2018
     * @param   none
     * @return  archivo excel con la informacion de la tabla base de datos
     **/
    /*
   public function obtener_reporte_base_datos(){
        satelite_validar();
        $data['consulta'] = $this->cotModel->obtener_base_datos();
        $html = $this->load->view('cotizaciones/consultas/obtener_reporte_base_datos', $data, true);
        $titulo = '<p style="text-align:center;font-weight:bold">
        <br/>'.mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8').'<br>
        Reporte Base de datos.</p>';
        header("Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        header("Content-Disposition: attachment;filename=base_de_datos.xls");
        header("Pragma: no-cache");
        header("Expires: 0");
        echo $titulo;
        echo $html;
   }
  */
    function base_datos($consulta = null)
    {
        $data['permisos'] = $this->gsatelite->get_permisos_opcion();
        if ($consulta == 1) {
            if ($this->input->post()) {
                $post_array = $this->input->post();
                $personeria = ($post_array['personeria'] != '') ? $post_array['personeria'] : null;
                $actividad_economica = ($post_array['actividad'] != '') ? $post_array['actividad'] : null;
                $etiqueta = ($post_array['etiqueta'] != '') ? $post_array['etiqueta'] : null;
                $where = $where_in2 = null;
                //$where = array('drn_id_cli' => null);
                if ($personeria != null) {
                    $where['drn_personeria'] = $personeria;
                }
                if ($actividad_economica != null) {
                    $where['drn_id_cac'] = $actividad_economica;
                }
                if ($etiqueta != '') {
                    //$this->db->where_in('exc_id_etq',$etiqueta);
                    $where_in2 = $etiqueta;
                }
                $data['base_datos'] = $this->cotModel->get_base_datos($where, null, $where_in2);
                $html = $this->load->view('cotizaciones/cotizaciones/consultar_base_datos', $data, true);
                echo $html;
                die();
            }
        }
        if ($consulta == 'excel') {
            if ($this->input->post()) {
                $post_array = $this->input->post();
                $personeria = ($post_array['personeria'] != '') ? $post_array['personeria'] : null;
                $actividad_economica = ($post_array['actividad'] != '') ? $post_array['actividad'] : null;
                $etiqueta = ($post_array['etiqueta'] != '') ? $post_array['etiqueta'] : null;

                $where = array('drn_id_cli' => null);
                if ($personeria != null) {
                    $where['drn_personeria'] = $personeria;
                }
                if ($actividad_economica != null) {
                    $where['drn_id_cac'] = $actividad_economica;
                }

                if ($etiqueta != '') {
                    $this->db->where_in('exc_id_etq', $etiqueta);
                }

                $data['consulta'] = $this->cotModel->get_base_datos($where);
                $html  = $this->load->view('cotizaciones/consultas/obtener_reporte_base_datos', $data, true);
                $titulo = '<p style="text-align:center;font-weight:bold">
                <br/>' . mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8') . '<br>
                Reporte Base de datos.</p>';
                header("Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
                header("Content-Disposition: attachment;filename=base_de_datos.xls");
                header("Pragma: no-cache");
                header("Expires: 0");
                echo $titulo;
                echo $html;
                die();
            }
        }
        $data['actividades_eco'] = $this->gsatelite->get_dropdown('cac_cartera_cliente', 'cac_nombre', 'cartera', array('cac_estado' => 1), null, null, null, true);
        $data['etiquetas'] = $this->gsatelite->get_dropdown('etq_etiqueta', 'etq_nombre', 'etiquetas', array('etq_estado' => 1), null, null, 'etq_id', true);
        $data['clientes'] = $this->gsatelite->get_dropdown('cli_cliente', "[CASE WHEN cli_personeria = 1 THEN CONCAT_WS(' ',cli_codigo,' - ', cli_nombre, cli_apellido) ELSE  CONCAT_WS(' ',cli_codigo,' - ', cli_apellido) END]", 'clientes', '', null, null, null, true);
        $data['clientes'] = str_replace('<option value="0">Sin Registros</option>', '<option></option>', $data['clientes']);

        $data['titulo_personal'] = "Base de Datos de Contactos";
        cargarvista($data);
    }

    public function ver_base_datos($id_bd, $ver_bd = null)
    {
        $ver = 0;
        if ($ver_bd == null) {
            $ver = 1;
        } else {
            $ver = 2;
        }
        $this->editar_base_datos($id_bd, $ver);
    }

    function agregar_base_datos()
    {
        if ($this->input->post()) {
            $post_array = $this->input->post();
            $slcPersoneria = $post_array['slcPersoneria'];
            $slcSegmento = ($post_array['slcSegmento'] != '') ? $post_array['slcSegmento'] : null;
            $txtEmpresa = ($post_array['txtEmpresa'] != '') ? $post_array['txtEmpresa'] : null;
            $slcActividadEco = ($post_array['slcActividadEco'] != '') ? $post_array['slcActividadEco'] : null;
            $txtContacto = ($post_array['txtContacto'] != '') ? $post_array['txtContacto'] : null;
            $slcNacionalidad = ($post_array['slcNacionalidad'] != '') ? $post_array['slcNacionalidad'] : null;
            $slcDepartamento = ($post_array['slcDepartamento'] != '') ? $post_array['slcDepartamento'] : null;
            $slcMunicipio = ($post_array['slcMunicipio'] != '') ? $post_array['slcMunicipio'] : null;
            $txtEmail = ($post_array['txtEmail'] != '') ? $post_array['txtEmail'] : null;
            $slcZona = ($post_array['slcZona'] != '') ? $post_array['slcZona'] : null;
            $txtTelefono = ($post_array['txtTelefono'] != '') ? $post_array['txtTelefono'] : null;
            $txtCargo = ($post_array['txtCargo'] != '') ? $post_array['txtCargo'] : null;
            $txtSitioWeb = ($post_array['txtSitioWeb'] != '') ? $post_array['txtSitioWeb'] : null;
            $txtDireccion = ($post_array['txtDireccion'] != '') ? $post_array['txtDireccion'] : null;
            $slcEtiquetas = ($post_array['slcEtiquetas'] != '') ? $post_array['slcEtiquetas'] : null;
            //campo etiquetas medios
            $slcM = ($post_array['slcMedios'] != '') ? $post_array['slcMedios'] : null;

            $slcOrigen = ($post_array['slcOrigen'] != '') ? $post_array['slcOrigen'] : null;
            $txtObservaciones = ($post_array['txtObservaciones'] != '') ? $post_array['txtObservaciones'] : null;
            $tipo_btn = ($post_array['btnGuardar'] != '') ? $post_array['btnGuardar'] : null;

            $base_array = array(
                'drn_id_ogc' => $slcOrigen,
                'drn_id_zod' => $slcZona,
                'drn_id_mun' => $slcMunicipio,
                'drn_id_dep' => $slcDepartamento,
                'drn_id_pai' => $slcNacionalidad,
                'drn_id_sec' => $slcSegmento,
                'drn_id_cac' => $slcActividadEco,
                'drn_personeria' => $slcPersoneria,
                'drn_nombre' => $txtEmpresa,
                'drn_contacto' => $txtContacto,
                'drn_cargo' => $txtCargo,
                'drn_telefono' => $txtTelefono,
                'drn_email' => $txtEmail,
                'drn_sitio_web' => $txtSitioWeb,
                'drn_direccion' => $txtDireccion,
                'drn_observacion' => $txtObservaciones,
                'drn_estado' => 1,
                'drn_usu_creacion' => $this->tank_auth->get_user_id(),
                'drn_fecha_creacion' => date('Y-m-d H:i:s'),
                'drn_usu_modificacion' => $this->tank_auth->get_user_id(),
                'drn_fecha_modificacion' => date('Y-m-d H:i:s')
            );

            $drn_id = $this->gsatelite->ingresar('drn_directorio_contacto', $base_array);

            if ($drn_id > 0) {

                //Se ingresan las etiquetas
                if (count($slcEtiquetas) > 0) {

                    for ($i = 0; $i < count($slcEtiquetas); $i++) {
                        $etiqueta_array = array(
                            'exc_id_drn' => $drn_id,
                            'exc_id_etq' => $slcEtiquetas[$i],
                            'exc_estado' => 1,
                            'exc_usu_creacion' => $this->tank_auth->get_user_id(),
                            'exc_fecha_creacion' => date('Y-m-d H:i:s'),
                            'exc_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'exc_fecha_modificacion' => date('Y-m-d H:i:s')
                        );

                        $this->gsatelite->ingresar('exc_etiquetaxcontacto', $etiqueta_array);
                    }
                }

                // se ingresan las etiquetas de los tipos de medios

                if (count($slcM) > 0) {

                    for ($i = 0; $i < count($slcM); $i++) {
                        $etiqueta_array = array(
                            'txd_id_drn' => $drn_id,
                            'txd_id_tmc' => $slcM[$i],
                            'txd_estado' => 1,
                            'txd_usu_creacion' => $this->tank_auth->get_user_id(),
                            'txd_fecha_creacion' => date('Y-m-d H:i:s'),
                            'txd_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'txd_fecha_modificacion' => date('Y-m-d H:i:s')
                        );

                        $this->gsatelite->ingresar('txd_tipo_contactoxdirectorio_cont', $etiqueta_array);
                    }
                }

                if ($drn_id > 0) {
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Base de Datos", 'texto_alerta' => "El registro se guardó correctamente.");
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Base de Datos", 'texto_alerta' => "Ocurrio un problema al crear el registro.");
                }

                $this->session->set_flashdata($alerta);

                if ($tipo_btn == 1) {
                    redirect('cotizaciones/cotizaciones/agregar_base_datos');
                } else {
                    redirect('cotizaciones/cotizaciones/base_datos');
                }
            }
        }

        $data['titulo_personal'] = "Agregar Base de Datos";
        $data['origen'] = $this->gsatelite->get_dropdown('ogc_origen_contacto', 'ogc_nombre', 'origen', array('ogc_estado' => 1), null, null, null, true);
        $data['paises'] = $this->gsatelite->get_dropdown('pai_pais', 'pai_nombre', 'paises', array('pai_estado' => 1), null, null, null, true);
        $data['sector'] = $this->gsatelite->get_dropdown('sec_sector_cliente', 'sec_nombre', 'sectores', array('sec_estado' => 1), null, null, null, true);
        $data['cartera_cliente'] = $this->gsatelite->get_dropdown('cac_cartera_cliente', 'cac_nombre', 'cartera', array('cac_estado' => 1), null, null, null, true);
        $data['etiquetas'] = $this->gsatelite->get_dropdown('etq_etiqueta', 'etq_nombre', 'etiquetas', array('etq_estado' => 1), null, null, null, true);
        //consulta para generar los tipos de medios
        $data['medios'] = $this->gsatelite->get_dropdown('tmc_tipo_medio', 'tmc_nombre', 'etiquetasMedios', array('tmc_estado' => 1), null, null, null, true);

        cargarvista($data);
    }

    function editar_base_datos($drn_id, $ver_bd = null)
    {
        if ($this->input->post()) {
            $post_array = $this->input->post();
            //die(var_dump($post_array));

            $slcPersoneria = $post_array['slcPersoneria'];
            $slcSegmento = ($post_array['slcSegmento'] != '') ? $post_array['slcSegmento'] : null;
            $txtEmpresa = ($post_array['txtEmpresa'] != '') ? $post_array['txtEmpresa'] : null;
            $slcActividadEco = ($post_array['slcActividadEco'] != '') ? $post_array['slcActividadEco'] : null;
            $txtContacto = ($post_array['txtContacto'] != '') ? $post_array['txtContacto'] : null;
            $slcNacionalidad = ($post_array['slcNacionalidad'] != '') ? $post_array['slcNacionalidad'] : null;
            $slcDepartamento = ($post_array['slcDepartamento'] != '') ? $post_array['slcDepartamento'] : null;
            $slcMunicipio = ($post_array['slcMunicipio'] != '') ? $post_array['slcMunicipio'] : null;
            $txtEmail = ($post_array['txtEmail'] != '') ? $post_array['txtEmail'] : null;
            $slcZona = ($post_array['slcZona'] != '') ? $post_array['slcZona'] : null;
            $txtTelefono = ($post_array['txtTelefono'] != '') ? $post_array['txtTelefono'] : null;
            $txtCargo = ($post_array['txtCargo'] != '') ? $post_array['txtCargo'] : null;
            $txtSitioWeb = ($post_array['txtSitioWeb'] != '') ? $post_array['txtSitioWeb'] : null;
            $txtDireccion = ($post_array['txtDireccion'] != '') ? $post_array['txtDireccion'] : null;
            $slcEtiquetas = ($post_array['slcEtiquetas'] != '') ? $post_array['slcEtiquetas'] : null;
            //select con los medios para actualizar
            $slcEtiquetasU = ($post_array['slcMediosU'] != '') ? $post_array['slcMediosU'] : null;

            $slcOrigen = ($post_array['slcOrigen'] != '') ? $post_array['slcOrigen'] : null;
            $slcEstado = ($post_array['slcEstado'] != '') ? $post_array['slcEstado'] : null;
            $txtObservaciones = ($post_array['txtObservaciones'] != '') ? $post_array['txtObservaciones'] : null;
            $tipo_btn = ($post_array['btnGuardar'] != '') ? $post_array['btnGuardar'] : null;

            $base_array = array(
                'drn_id_ogc' => $slcOrigen,
                'drn_id_zod' => $slcZona,
                'drn_id_mun' => $slcMunicipio,
                'drn_id_dep' => $slcDepartamento,
                'drn_id_pai' => $slcNacionalidad,
                'drn_id_sec' => $slcSegmento,
                'drn_id_cac' => $slcActividadEco,
                'drn_personeria' => $slcPersoneria,
                'drn_nombre' => $txtEmpresa,
                'drn_contacto' => $txtContacto,
                'drn_cargo' => $txtCargo,
                'drn_telefono' => $txtTelefono,
                'drn_email' => $txtEmail,
                'drn_sitio_web' => $txtSitioWeb,
                'drn_direccion' => $txtDireccion,
                'drn_observacion' => $txtObservaciones,
                'drn_estado' => $slcEstado,
                'drn_usu_creacion' => $this->tank_auth->get_user_id(),
                'drn_fecha_creacion' => date('Y-m-d H:i:s'),
                'drn_usu_modificacion' => $this->tank_auth->get_user_id(),
                'drn_fecha_modificacion' => date('Y-m-d H:i:s')
            );

            $resultado = $this->gsatelite->actualizar_array('drn_directorio_contacto', $base_array, array('drn_id' => $drn_id));

            if ($resultado > 0) {


                $this->gsatelite->borrado_general('exc_etiquetaxcontacto', array('exc_id_drn' => $drn_id));

                $this->gsatelite->borrado_general('txd_tipo_contactoxdirectorio_cont', array('txd_id_drn' => $drn_id));

                //Se ingresan las etiquetas
                if (count($slcEtiquetas) > 0) {

                    for ($i = 0; $i < count($slcEtiquetas); $i++) {
                        $etiqueta_array = array(
                            'exc_id_drn' => $drn_id,
                            'exc_id_etq' => $slcEtiquetas[$i],
                            'exc_estado' => 1,
                            'exc_usu_creacion' => $this->tank_auth->get_user_id(),
                            'exc_fecha_creacion' => date('Y-m-d H:i:s'),
                            'exc_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'exc_fecha_modificacion' => date('Y-m-d H:i:s')
                        );

                        $this->gsatelite->ingresar('exc_etiquetaxcontacto', $etiqueta_array);
                    }
                }
                // etiquetas de medios

                if (count($slcEtiquetasU) > 0) {

                    for ($i = 0; $i < count($slcEtiquetasU); $i++) {
                        $etiqueta_array = array(
                            'txd_id_drn' => $drn_id,
                            'txd_id_tmc' => $slcEtiquetasU[$i],
                            'txd_estado' => 1,
                            'txd_usu_creacion' => $this->tank_auth->get_user_id(),
                            'txd_fecha_creacion' => date('Y-m-d H:i:s'),
                            'txd_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'txd_fecha_modificacion' => date('Y-m-d H:i:s')
                        );

                        $this->gsatelite->ingresar('txd_tipo_contactoxdirectorio_cont', $etiqueta_array);
                    }
                }


                if ($drn_id > 0) {
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Base de Datos", 'texto_alerta' => "El registro se guardó correctamente.");
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Base de Datos", 'texto_alerta' => "Ocurrio un problema al crear el registro.");
                }

                $this->session->set_flashdata($alerta);

                if ($tipo_btn == 1) {
                    redirect('cotizaciones/cotizaciones/editar_base_datos/' . $drn_id);
                } else {
                    redirect('cotizaciones/cotizaciones/base_datos');
                }
            }
        }

        $data['titulo_personal'] = "Editar Base de Datos";

        $base_datos = $this->cotModel->get_base_datos(array('drn_id' => $drn_id));
        //die(var_dump($base_datos));

        $etiquetas  = $this->gsatelite->get_tabla('exc_etiquetaxcontacto', array('exc_id_drn' => $drn_id));
        $etiquetas2 = $this->gsatelite->get_tabla('txd_tipo_contactoxdirectorio_cont', array('txd_id_drn' => $drn_id));

        $idsEtiquetas  = array_column($etiquetas, 'exc_id_etq');
        $idsEtiquetas2 = array_column($etiquetas2, 'txd_id_tmc');

        $data['origen'] = $this->gsatelite->get_dropdown('ogc_origen_contacto', 'ogc_nombre', 'origen', array('ogc_estado' => 1), $base_datos[0]['drn_id_ogc'], null, null, true);
        $data['paises'] = $this->gsatelite->get_dropdown('pai_pais', 'pai_nombre', 'paises', array('pai_estado' => 1), $base_datos[0]['drn_id_pai'], null, null, true);
        $data['sector'] = $this->gsatelite->get_dropdown('sec_sector_cliente', 'sec_nombre', 'sectores', array('sec_estado' => 1), $base_datos[0]['drn_id_sec'], null, null, true);
        $data['cartera_cliente'] = $this->gsatelite->get_dropdown('cac_cartera_cliente', 'cac_nombre', 'cartera', array('cac_estado' => 1), $base_datos[0]['drn_id_cac'], null, null, true);
        $data['etiquetas'] = $this->gsatelite->get_dropdown('etq_etiqueta', 'etq_nombre', 'etiquetas', array('etq_estado' => 1), $idsEtiquetas, null, null, true);
        // etiquetas de medios
        $data['mediosUpdate'] = $this->gsatelite->get_dropdown('tmc_tipo_medio', 'tmc_nombre', 'etiquetas', array('tmc_estado' => 1), $idsEtiquetas2, null, null, true);

        $data['departamentos'] = $this->gsatelite->get_dropdown('dep_departamento', 'dep_nombre', 'departamentos', array('dep_estado' => 1, 'dep_id_pai' => $base_datos[0]['drn_id_pai']), $base_datos[0]['drn_id_dep'], null, null, true);
        $data['municipios'] = $this->gsatelite->get_dropdown('mun_municipio', 'mun_nombre', 'municipio', array('mun_estado' => 1, 'mun_id_dep' => $base_datos[0]['drn_id_dep']), $base_datos[0]['drn_id_mun'], null, null, true);
        $data['zonas_depto'] = $this->gsatelite->get_dropdown('zod_zona_departamento', 'zod_nombre', 'zonas', array('zod_estado' => 1, 'zod_id_dep' => $base_datos[0]['drn_id_dep']), $base_datos[0]['drn_id_zod'], null, null, true);

        $data['base_datos'] = $base_datos[0];
        $data['ver'] = $ver_bd;

        if ($ver_bd == 2) {
            $data['modal_bd'] = true;
            cargarvista_modal($data, null, "cotizaciones/cotizaciones/editar_base_datos");
        } else {
            $data['modal_bd'] = false;
            cargarvista($data);
        }
    }

    public function eliminar_base_datos($drn_id)
    {

        $cliente = $this->gsatelite->get_campo('drn_directorio_contacto', 'drn_id_cli', array('drn_id' => $drn_id));
        if ($cliente == null) {
            $this->gsatelite->borrado_general('exc_etiquetaxcontacto', array('exc_id_drn' => $drn_id));
            $this->gsatelite->borrado_general('cnc_contactos_campania', array('cnc_id_drn' => $drn_id));
            $resultado = $this->gsatelite->borrado_general('drn_directorio_contacto', array('drn_id' => $drn_id));
        } else {
            $resultado = 0;
        }

        if ($resultado > 0) {
            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Base de Datos", 'texto_alerta' => "El registro se eliminó correctamente.");
        } else {
            $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Base de Datos", 'texto_alerta' => "El registro ya fue asociado a un cliente.");
        }

        $this->session->set_flashdata($alerta);

        redirect('cotizaciones/cotizaciones/base_datos');
    }

    public function get_departamentos_municipio()
    {
        if ($this->input->post()) {
            $post_array = $this->input->post();

            $pais = (isset($post_array['pais']) && $post_array['pais'] != '') ? $post_array['pais'] : null;
            $departamento = (isset($post_array['departamento']) && $post_array['departamento'] != '') ? $post_array['departamento'] : null;
            //Si la variable pais existe, se buscan los departamentos dependientes

            $depto_html = "";
            $mun_html = "";
            $zona_html = "";

            if ($pais != null) {
                $depto_html = $this->gsatelite->get_dropdown('dep_departamento', 'dep_nombre', 'departamentos', array('dep_estado' => 1, 'dep_id_pai' => $pais), null, null, null, true);
                $depto_html = str_replace('<option value="0">Seleccione</option>', '<option></option>', $depto_html);
                $depto_html = str_replace('<option value="0">Sin Registros</option>', '<option></option>', $depto_html);
            }

            if ($departamento != null) {
                $mun_html = $this->gsatelite->get_dropdown('mun_municipio', 'mun_nombre', 'municipios', array('mun_estado' => 1, 'mun_id_dep' => $departamento), null, null, null, true);
                $mun_html = str_replace('<option value="0">Seleccione</option>', '<option></option>', $mun_html);
                $mun_html = str_replace('<option value="0">Sin Registros</option>', '<option></option>', $mun_html);

                $zona_html = $this->gsatelite->get_dropdown('zod_zona_departamento', 'zod_nombre', 'zonas', array('zod_estado' => 1, 'zod_id_dep' => $departamento), null, null, null, true);
                $zona_html = str_replace('<option value="0">Seleccione</option>', '<option></option>', $zona_html);
                $zona_html = str_replace('<option value="0">Sin Registros</option>', '<option></option>', $zona_html);
            }

            $resultado = array(
                'departamentos' => $depto_html,
                'municipios' => $mun_html,
                'zonas' => $zona_html,
            );

            echo json_encode($resultado);
        }
    }

    /**
     * @author Edith Herrera
     * @since 18/08/2017
     * @return Detalle de productos asociados a la cotización.
     */
    function presupuesto_cotizacion($cot_id = null)
    {
        satelite_validar();
        if ($cot_id == null) {
            redirect('cotizaciones/cotizaciones/index');
        }
        $cotizacion = $this->gsatelite->get_tabla('cot_cotizacion', array('cot_id' => $cot_id));
        $data['cotizacion'] = $cotizacion[0];
        $detalle_cotizacion = $this->cotModel->get_detalle_cotizacion(array('axc_id_cot' => $cot_id, 'axc_estado' => 1));
        $data['detalle_cotizacion'] = $detalle_cotizacion;

        $data['titulo_personal'] = "Listado de Presupuestos";
        cargarvista($data);
    }

    /**
     * @author Edith Herrera
     * @since 18/08/2017
     * @return Detalle de productos asociados a la cotización.
     */
    function detalle_presupuesto($axc_id = NULL, $cot_id = null)
    {
        satelite_validar();
        if ($this->input->post()) {
            $post_array = $this->input->post();
            $axc_id              = $post_array['axc'];
            $id_cot              = $post_array['id_cot'];
            $hdnDetalleMateria   = $post_array['hdnDetalleMateria'];
            $materiaPrima        = $post_array['materiaPrima'];
            $conversionesMateria = $post_array['conversionesMateria'];
            $proveedoresMateria  = $post_array['proveedoresMateria'];
            $cantidadesMateria   = $post_array['cantidadesMateria'];
            $preciosMateria      = $post_array['preciosMateria'];
            $chkEstMateria       = $post_array['chkEstMateria'];
            $hdnDetalleMob       = $post_array['hdnDetalleMob'];
            $manoObra            = $post_array['manoObra'];
            $responsanblesMob    = $post_array['responsanblesMob'];
            $cantidadesMob       = $post_array['cantidadesMob'];
            $preciosMob          = $post_array['preciosMob'];
            $chkestmob           = $post_array['chkEstMob'];
            $hdnDetalleGst       = $post_array['hdnDetalleGst'];
            $estimacionesGasto   = $post_array['estimacionesGasto'];
            $cantidadesGasto     = $post_array['cantidadesGasto'];
            $preciosGasto        = $post_array['preciosGasto'];
            $subtotalesGasto     = $post_array['subtotalesGasto'];
            $cantidad_cotizada   = $post_array['txtCantidadProd'];
            //$ord_id = $this->gsatelite->get_campo('axo_articuloxorden', 'axo_id_ord', array('axo_id' => $axo_id));
            $resultado = 0;
            //Se procesan los detalles ingresados
            $porcentaje = $post_array['porcentaje'];
            // si hay margen se actualiza la cotizacion.
            if ($porcentaje > 0) {
                $new_precio_unitario     = $post_array['txt_precio_unitario'];
                $axc_articuloxcotizacion = $this->gsatelite->get_tabla('axc_articuloxcotizacion', array('axc_id' => $axc_id));
                $new_axc_subtotal        = $axc_articuloxcotizacion[0]['axc_cantidad'] * $new_precio_unitario;
                $new_axc_impuesto        = ($axc_articuloxcotizacion[0]['axc_impuesto'] / $axc_articuloxcotizacion[0]['axc_subtotal']) * $new_axc_subtotal;
                $new_axc_descuento       = ($axc_articuloxcotizacion[0]['axc_descuento'] / $axc_articuloxcotizacion[0]['axc_subtotal']) * $new_axc_subtotal;
                $axc_articuloxcotizacion_update = array(
                    'axc_precio'    => $new_precio_unitario,
                    'axc_subtotal'  => $new_axc_subtotal,
                    'axc_impuesto'  => $new_axc_impuesto,
                    'axc_descuento' => $new_axc_descuento,
                    'axc_usu_modificacion'      => $this->tank_auth->get_user_id(),
                    'axc_fecha_modificacion'    => date('Y-m-d H:i:s')
                );
                $this->gsatelite->actualizar_array('axc_articuloxcotizacion', $axc_articuloxcotizacion_update, array('axc_id' => $axc_id));
                $ixt_impuestoxcotizacion = $this->gsatelite->get_tabla('ixt_impuestoxcotizacion', array('ixt_id_axc' => $axc_id));
                if (count($ixt_impuestoxcotizacion > 0)) {
                    foreach ($ixt_impuestoxcotizacion as $impuesto) {
                        $new_monto = ($impuesto['ixt_monto'] / $axc_articuloxcotizacion[0]['axc_subtotal']) * $new_axc_subtotal;
                        $ixt_impuestoxcotizacion_update = array(
                            'ixt_monto'                 => $new_monto,
                            'ixt_usu_modificacion'      => $this->tank_auth->get_user_id(),
                            'ixt_fecha_modificacion'    => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->actualizar_array('ixt_impuestoxcotizacion', $ixt_impuestoxcotizacion_update, array('ixt_id_axc' => $axc_id, 'ixt_id' => $impuesto['ixt_id']));
                    }
                }
                $cot_cotizacion = $this->gsatelite->get_tabla('cot_cotizacion', array('cot_id' => $axc_articuloxcotizacion[0]['axc_id_cot']));
                $new_cotizacion_impuesto    = ($cot_cotizacion[0]['cot_impuesto'] - $axc_articuloxcotizacion[0]['axc_impuesto']) + $new_axc_impuesto;
                $new_cotizacion_descuento   = ($cot_cotizacion[0]['cot_descuento'] - $axc_articuloxcotizacion[0]['axc_descuento']) + $new_axc_descuento;
                $new_cotizacion_subtotal    = ($cot_cotizacion[0]['cot_subtotal'] - $axc_articuloxcotizacion[0]['axc_subtotal']) + $new_axc_subtotal;
                $new_cotizacion_total       = ($new_cotizacion_subtotal + $new_cotizacion_impuesto) - $new_cotizacion_descuento;
                $cot_cotizacion_update = array(
                    'cot_impuesto'              => $new_cotizacion_impuesto,
                    'cot_descuento'             => $new_cotizacion_descuento,
                    'cot_subtotal'              => $new_cotizacion_subtotal,
                    'cot_total'                 => $new_cotizacion_total,
                    'cot_usu_modificacion'      => $this->tank_auth->get_user_id(),
                    'cot_fecha_modificacion'    => date('Y-m-d H:i:s')
                );
                $this->gsatelite->actualizar_array('cot_cotizacion', $cot_cotizacion_update, array('cot_id' => $axc_articuloxcotizacion[0]['axc_id_cot']));
            }
            /**************** DETALLES DE MATERIA PRIMA *******************/
            $idsMateria = array();
            if (count($hdnDetalleMateria) > 0) {
                for ($i = 0; $i < count($hdnDetalleMateria); $i++) {
                    if ($hdnDetalleMateria[$i] > 0) {
                        $idsMateria[] = $hdnDetalleMateria[$i];
                    }
                }
            }
            //Se eliminan los detalles que no se procesaron.
            $dataMateria = $this->gsatelite->get_tabla('axr_articulo_materiaxarticulo', array('axr_id_axc' => $axc_id));
            if (count($dataMateria) > 0) {
                foreach ($dataMateria as $row) {
                    if (!in_array($row['axr_id'], $idsMateria)) {
                        $this->gsatelite->borrado_general('axr_articulo_materiaxarticulo', array('axr_id' => $row['axr_id']));
                    }
                }
            }
            if (count($hdnDetalleMateria) > 0) {
                for ($i = 0; $i < count($hdnDetalleMateria); $i++) {
                    $cantidadMateria = convertirFloat($cantidadesMateria[$i]);
                    $precioMateria = convertirFloat($preciosMateria[$i]);
                    $materia_array = array(
                        'axr_id_axc' => $axc_id,
                        'axr_id_cva' => ($conversionesMateria[$i] != '') ? $conversionesMateria[$i] : null,
                        'axr_id_prv' => ($proveedoresMateria[$i] != '') ? $proveedoresMateria[$i] : null,
                        'axr_id_art_materia' => $materiaPrima[$i],
                        'axr_cantidad' => $cantidadMateria,
                        'axr_precio' => $precioMateria,
                        'axr_estimacion_porcentaje' => ($chkEstMateria[$i] != '' && $chkEstMateria[$i] > 0) ? $chkEstMateria[$i] : 0,
                        'axr_observacion' => '',
                        'axr_estado' => 1,
                        'axr_usu_creacion' => $this->tank_auth->get_user_id(),
                        'axr_fecha_creacion' => date('Y-m-d H:i:s'),
                        'axr_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'axr_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    if ($hdnDetalleMateria[$i] > 0) {
                        unset($materia_array['axr_id_axc']);
                        unset($materia_array['axr_usu_creacion']);
                        unset($materia_array['axr_fecha_creacion']);
                        $resultado += $this->gsatelite->actualizar_array('axr_articulo_materiaxarticulo', $materia_array, array('axr_id' => $hdnDetalleMateria[$i]));
                    } else {
                        $resultado += $this->gsatelite->ingresar('axr_articulo_materiaxarticulo', $materia_array);
                    }
                }
            }
            /******************** DETALLES DE MANO DE OBRA *******************/
            $idsMob = array();
            if (count($hdnDetalleMob) > 0) {
                for ($i = 0; $i < count($hdnDetalleMob); $i++) {
                    if ($hdnDetalleMob[$i] > 0) {
                        $idsMob[] = $hdnDetalleMob[$i];
                    }
                }
            }
            //Se eliminan los detalles que no se procesaron.
            $dataMob = $this->gsatelite->get_tabla('mxa_mano_obraxarticulo', array('mxa_id_axc' => $axc_id));
            if (count($dataMob) > 0) {
                foreach ($dataMob as $row) {
                    if (!in_array($row['mxa_id'], $idsMob)) {
                        $this->gsatelite->borrado_general('mxa_mano_obraxarticulo', array('mxa_id' => $row['mxa_id']));
                    }
                }
            }
            if (count($hdnDetalleMob) > 0) {
                for ($i = 0; $i < count($hdnDetalleMob); $i++) {
                    $cantidadMob = convertirFloat($cantidadesMob[$i]);
                    $precioMob = convertirFloat($preciosMob[$i]);
                    $mano_obra_array = array(
                        'mxa_id_axc' => $axc_id,
                        'mxa_id_mob' => $manoObra[$i],
                        'mxa_cantidad' => $cantidadMob,
                        'mxa_precio' => $precioMob,
                        'mxa_estimacion_porcentaje' => ($chkestmob[$i] != '' && $chkestmob[$i] > 0) ? $chkestmob[$i] : 0,
                        'mxa_estado' => 1,
                        'mxa_usu_mod' => $this->tank_auth->get_user_id(),
                        'mxa_fecha_mod' => date('Y-m-d H:i:s'),
                        'mxa_id_emp' => ($responsanblesMob[$i] != '') ? $responsanblesMob[$i] : null
                    );
                    if ($hdnDetalleMob[$i] > 0) {
                        unset($materia_array['mxa_id_axc']);
                        unset($materia_array['mxa_usu_creacion']);
                        unset($materia_array['mxa_fecha_creacion']);
                        $resultado += $this->gsatelite->actualizar_array('mxa_mano_obraxarticulo', $mano_obra_array, array('mxa_id' => $hdnDetalleMob[$i]));
                    } else {
                        $resultado += $this->gsatelite->ingresar('mxa_mano_obraxarticulo', $mano_obra_array);
                    }
                }
            }
            /****************** GASTOS INDIRECTOS ***************************/
            if (count($hdnDetalleGst) > 0) {
                $idsGastos = array();
                for ($i = 0; $i < count($hdnDetalleGst); $i++) {
                    if ($hdnDetalleGst[$i] > 0) {
                        $idsGastos[] = $hdnDetalleGst[$i];
                    }
                }
            }
            //Se eliminan los detalles que no se procesaron.
            $dataGastos = $this->gsatelite->get_tabla('exa_estimacionxarticulo', array('exa_id_axc' => $axc_id));
            if (count($dataGastos) > 0) {
                foreach ($dataGastos as $row) {
                    if (!in_array($row['exa_id'], $idsGastos)) {
                        $this->gsatelite->borrado_general('exa_estimacionxarticulo', array('exa_id' => $row['exa_id']));
                    }
                }
            }
            if (count($hdnDetalleGst) > 0) {
                for ($i = 0; $i < count($hdnDetalleGst); $i++) {
                    $cantidadGasto = convertirFloat($cantidadesGasto[$i]);
                    $precioGasto = convertirFloat($preciosGasto[$i]);
                    $subTotGasto = convertirFloat($subtotalesGasto[$i]);
                    $gastos_exr = array(
                        'exa_id_esm' => $estimacionesGasto[$i],
                        'exa_id_axc' => $axc_id,
                        'exa_cantidad' => $cantidadGasto,
                        'exa_precio' => $precioGasto,
                        'exa_monto_calculo' => $subTotGasto,
                        'exa_estado' => 1,
                        //'exa_usu_creacion' => $this->tank_auth->get_user_id(),
                        //'exa_fecha_creacion' => date('Y-m-d H:i:s'),
                        'exa_usu_mod' => $this->tank_auth->get_user_id(),
                        'exa_fecha_mod' => date('Y-m-d H:i:s')
                    );
                    if ($hdnDetalleGst[$i] > 0) {
                        unset($gastos_exr['exa_id_axc']);
                        unset($gastos_exr['exa_usu_mod']);
                        unset($gastos_exr['exa_fecha_mod']);
                        $resultado += $this->gsatelite->actualizar_array('exa_estimacionxarticulo', $gastos_exr, array('exa_id' => $hdnDetalleGst[$i]));
                    } else {
                        $resultado += $this->gsatelite->ingresar('exa_estimacionxarticulo', $gastos_exr);
                    }
                }
            }
            if ($resultado > 0) {
                $costo       = $post_array['txtTotalCostos'];
                $margen      = $post_array['margen'];
                $total       = $post_array['pre_esm'];
                $observacion = $post_array['observacion'];
                $array_acs   = array(
                    'acs_id_axc' => $axc_id,
                    'acs_costo' => convertirFloat($costo),
                    'acs_porcentaje_marg' => $porcentaje,
                    'acs_margen' => convertirFloat($margen),
                    'acs_precio' => convertirFloat($total),
                    'acs_observacion' => $observacion,
                    'acs_estado' => 1,
                    'acs_usu_mod' => $this->tank_auth->get_user_id(),
                    'acs_fecha_mod' => date('Y-m-d H:i:s')
                );
                $idacs = $this->gsatelite->get_campo('acs_articulo_costo', 'acs_id_axc', array('acs_id_axc' => $axc_id));
                if ($idacs > 0) {
                    $this->gsatelite->actualizar_array('acs_articulo_costo', $array_acs, array('acs_id_axc' => $axc_id));
                } else {
                    $this->gsatelite->ingresar('acs_articulo_costo', $array_acs);
                }
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Presupuestos", 'texto_alerta' => "Información procesada correctamente.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Presupuestos", 'texto_alerta' => "No se proceso ningun registro, favor verificar información.");
            }
            $this->session->set_flashdata($alerta);
            $tipoBtn = $post_array['btnCrear'];
            if ($tipoBtn == 1) {
                redirect('cotizaciones/cotizaciones/detalle_presupuesto/' . $axc_id);
            } else {
                redirect('cotizaciones/cotizaciones/presupuesto_cotizacion/' . $id_cot);
            }
        }
        //satelite_validar();
        $articulo                   = $this->cotModel->listaarticulo($axc_id);
        $data['articulo']           = $articulo[0];
        $data['cot_id']             = $cot_id;
        $producto                   = $this->cotModel->get_detalle_cotizacion(array('axc_id' => $axc_id));
        $data['producto']           = $producto[0];
        $data['proveedores']        = $this->gsatelite->get_dropdown('prv_proveedor', "[CASE WHEN prv_tipo_pers = 1 THEN CONCAT(prv_nombre,' ',prv_apellido) ELSE prv_nombre End]", 'proveedores', array('prv_estado' => 1), null, null, null, true);
        $data['materia_prima']      = $this->gsatelite->get_dropdown('art_articulo', '{art_codigo} - {art_nombre}', 'materia_prima', array('art_materia_prima' => 1, 'art_estado' => 1), null, null, null, true);
        $data['mano_obra']          = $this->gsatelite->get_tabla('mob_mano_obra', array('mob_estado' => 1));
        $data['estimaciones']       = $this->gsatelite->get_tabla('esm_estimacion', array('esm_estado' => 1));
        //Se carga el presupuesto de la cotización en caso de que exista.
        $data['permite_actualizar'] = 1;
        $data['materia_prima_prod'] = $this->cotModel->get_materia_prima_presupuesto_cot(array('axr_id_axc' => $axc_id));
        $data['mano_obra_prod']     = $this->cotModel->get_mano_obra_presupuesto_cot(array('mxa_id_axc' => $axc_id));
        $data['gastos_indirectos']  = $this->cotModel->get_gastos_indirectos_presupuesto_cot(array('exa_id_axc' => $axc_id));
        //Se carga el presupuesto del producto en caso de que la cotización no posea uno.
        if (!(count($data['materia_prima_prod']) > 0) && !(count($data['mano_obra_prod']) > 0) && !(count($data['gastos_indirectos']) > 0)) {
            $data['permite_actualizar'] = 0;
            //se carga la receta por defecto
            $receta = $this->gsatelite->get_campo('rea_receta_articulo', 'rea_id', array('rea_estado' => 1, 'rea_defecto' => 1, 'rea_id_art' => $producto[0]['axc_id_art']));
            $data['materia_prima_prod'] = $this->proyecto_model->get_materia_prima_producto_segun_receta(array('mpa_id_art' => $producto[0]['axc_id_art'], 'mpa_id_rea' => $receta));
            $data['mano_obra_prod']     = $this->cotModel->get_mano_obra_presupuesto(array('moa_id_art' => $producto[0]['axc_id_art'], 'moa_id_rea' => $receta));
            $data['gastos_indirectos']  = $this->cotModel->get_gastos_indirectos_presupuesto(array('esr_id_art' => $producto[0]['axc_id_art'], 'esr_id_rea' => $receta));
        }
        $data['lista']           = $this->gsatelite->get_tabla('art_articulo');
        $data['obra']            = $this->gsatelite->get_tabla('mob_mano_obra', array('mob_estado' => 1));
        $data['resp']            = $this->gsatelite->get_tabla('emp_empleado');
        $data['est']             = $this->gsatelite->get_tabla('esm_estimacion');
        $data['acs']             = $this->gsatelite->get_tabla('acs_articulo_costo', array('acs_id_axc' => $axc_id));
        $data['id_cot']          = $this->gsatelite->get_campo('axc_articuloxcotizacion', 'axc_id_cot', array('axc_id' => $axc_id));
        $data['axc']             = $axc_id;
        $cotizacion              = $this->cotModel->get_cotizacion(array('cot_id' => $producto[0]['axc_id_cot']));
        $data['cotizacion']      = $cotizacion[0];
        $data['decimales']       = ($this->gsatelite->get_parametro('NUMERO_DECIMALES') != '') ? $this->gsatelite->get_parametro('NUMERO_DECIMALES') : 2;
        $data['decimalescantidad'] = json_decode($this->gsatelite->get_parametro('SYS_NUMERO_DECIMALES_PRODUCCION'), true);
        $data['emp_default']     = $this->gsatelite->get_dropdown('emp_empleado', '{emp_codigo} - {emp_nombre}' . ' ' . '{emp_apellido}', '', array('emp_estado' => 1), null, '', 'emp_id', true);
        $data['titulo_personal'] = "Costeo Cotización";
        $this->_cargarvista($data);
    }

    /**
     * @author Habby Lovo
     * @since  12/10/2017
     * @return Verifica si hay registros en los presupuestos del producto
     */
    function verificar_presupuesto()
    {
        $cot_id = $this->input->post('cotizacion');
        $respuesta = $this->cotModel->get_cotizacion(array('cot_id' => $cot_id));
        $select_default = $respuesta[0]['cot_id_ven']; //(count($data['ven_permitidos']) == 1) ? $data['ven_permitidos'][0] : null;
        $vendedor_reg =  $this->gsatelite->get_tabla('ven_vendedor', array('ven_estado' => 1, 'ven_id' => $select_default));
        $vendedor = $vendedor_reg[0]['ven_nombre'] . ' ' . $vendedor_reg[0]['ven_apellidos'];
        echo json_encode(array('producto' => $respuesta[0], 'vendedor' => $vendedor));
    }

    public function duplicar_cotizacion()
    {
        $correlativo = $this->gsatelite->get_tabla('cot_cotizacion');
        $codigo = count($correlativo) + 1;
        $labelMes = "";
        $correlativoNew = "-";
        $mes = date("m");
        $anio = date("Y");
        if ($codigo < 10) {
            $correlativoNew = "-000" . $codigo;
        } else if ($codigo < 100) {
            $correlativoNew = "-00" . $codigo;
        } else if ($codigo < 1000) {
            $correlativoNew = "-0" . $codigo;
        } else {
            $correlativoNew = "-" . $codigo;
        }
        if ($mes == "01") {
            $labelMes = "ENERO";
        } else if ($mes == "02") {
            $labelMes = "FEBRERO";
        } else if ($mes == "03") {
            $labelMes = "MARZO";
        } else if ($mes == "04") {
            $labelMes = "ABRIL";
        } else if ($mes == "05") {
            $labelMes = "MAYO";
        } else if ($mes == "06") {
            $labelMes = "JUNIO";
        } else if ($mes == "07") {
            $labelMes = "JULIO";
        } else if ($mes == "08") {
            $labelMes = "AGOSTO";
        } else if ($mes == "09") {
            $labelMes = "SEPTIEMBRE";
        } else if ($mes == "10") {
            $labelMes = "OCTUBRE";
        } else if ($mes == "11") {
            $labelMes = "NOVIEMBRE";
        } else if ($mes == "12") {
            $labelMes = "DICIEMBRE";
        }
        $correlativoNew = substr($labelMes, 0, 3) . $anio . $correlativoNew;
        $codigo = $correlativoNew;
        $cot_id = $this->input->post('cot_id');
        $checked = $this->input->post('checked');
        $cotizacion_reg = $this->gsatelite->get_tabla('cot_cotizacion', array('cot_id' => $cot_id));

        //VERIFICAR SI YA EXISTEN LOS NUEVOS CAMPOS, SINO SE SEGUIRAN USANDO LOS VALORES DEL PARAMETRO
        $hay_campo = $this->db->query("SHOW COLUMNS FROM est_estado_cotizacion WHERE Field = 'est_vigente'")->result_array();
        if (count($hay_campo) > 0) {
            $vigente = $this->gsatelite->get_tabla('est_estado_cotizacion', array('est_estado' => 1, 'est_vigente' => 1));
            if (count($vigente) > 0) {
                $estado_cotizacion = $vigente[0]['est_id'];
            } else {
                echo json_encode(array('estado' => false, 'cotizacion' => 0, 'error' => 'Verifique que exista un Estado "Vigente".'));
                die();
            }
        } else {
            $estado_cotizacion = $this->gsatelite->get_parametro('SYS_ESTADO_COTIZACION', null, null, array('VIGENTE'));
        }

        //Arreglo donde se guarda la cotizacion existente
        $cotizacion_array = array();
        $estado = false;
        if (count($cotizacion_reg) > 0) {
            foreach ($cotizacion_reg as $key) {
                $cotizacion_array = array(
                    'cot_id_cli' => $key['cot_id_cli'],
                    'cot_id_ven' => $key['cot_id_ven'],
                    'cot_id_est' => $estado_cotizacion,
                    'cot_id_etc' => $key['cot_id_etc'],
                    //'cot_id_etp' => $slcEtapa,
                    'cot_id_scl' => $key['cot_id_scl'],
                    'cot_id_are' => $key['cot_id_are'],
                    'cot_id_tpg' => $key['cot_id_tpg'],
                    'cot_codigo' => $codigo,
                    'cot_fecha' => date('Y-m-d H:i:s'),
                    'cot_fecha_pres' => date('Y-m-d H:i:s'),
                    'cot_concepto' => $key['cot_concepto'],
                    'cot_ult_fecha_cont' => date('Y-m-d H:i:s'),
                    'cot_condicion' => $key['cot_condicion'],
                    'cot_dirigido' => $key['cot_dirigido'],
                    'cot_lugar_entrega' => $key['cot_lugar_entrega'],
                    'cot_fecha_entrega' => $key['cot_fecha_entrega'],
                    'cot_hora_inicio_entrega' => $key['cot_hora_inicio_entrega'],
                    'cot_hora_fin_entrega' => $key['cot_hora_fin_entrega'],
                    'cot_validez_oferta' => null,
                    'cot_fecha_vigencia' => date('Y-m-d H:i:s'),
                    'cot_probabilidad_cierre' => $key['cot_probabilidad_cierre'],
                    'cot_fecha_cierre' => $key['cot_fecha_cierre'],
                    'cot_plan_accion' => $key['cot_plan_accion'],
                    'cot_comentario' => $key['cot_comentario'],
                    'cot_enviar_email' => 0,
                    'cot_produccion' => $key['cot_produccion'],
                    'cot_descuento_porcentaje' => $key['cot_descuento_porcentaje'],
                    'cot_subtotal' => $key['cot_subtotal'],
                    'cot_descuento' => $key['cot_descuento'],
                    'cot_impuesto' => $key['cot_impuesto'],
                    'cot_total' => $key['cot_total'],
                    'cot_estado' => 1,
                    'cot_usu_creacion' => $this->tank_auth->get_user_id(),
                    'cot_fecha_creacion' => date('Y-m-d H:i:s'),
                    'cot_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'cot_fecha_modificacion' => date('Y-m-d H:i:s')
                );
            }
            $cot_id_new = $this->gsatelite->ingresar('cot_cotizacion', $cotizacion_array);
            $estado = true;
        }

        if ($cot_id_new > 0) {
            $contactoxcotizacion_reg = $this->gsatelite->get_tabla('cxt_contactoxcotizacion', array('cxt_id_cot' => $cot_id));
            //arreglo donde se guarda la cotizacion existente
            $contactoxcotizacion_array = array();
            if (count($contactoxcotizacion_reg) > 0) {
                foreach ($contactoxcotizacion_reg as $key) {
                    $contactoxcotizacion_array[] = array(
                        'cxt_id_cot' => $cot_id_new,
                        'cxt_id_con' => $key['cxt_id_con'],
                        'cxt_estado' => 1,
                        'cxt_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'cxt_fecha_modificacion' => date('Y-m-d H:i:s'),
                        'cxt_usu_creacion' => $this->tank_auth->get_user_id(),
                        'cxt_fecha_creacion' => date('Y-m-d H:i:s')
                    );
                }
                $this->gsatelite->ingresar('cxt_contactoxcotizacion', $contactoxcotizacion_array, true);
                $estado = true;
            }

            $articuloxcotizacion_reg = $this->gsatelite->get_tabla('axc_articuloxcotizacion', array('axc_id_cot' => $cot_id));
            //arreglo donde se guarda la axc_articuloxcotizacion existente
            $articuloxcotizacion_array = array();
            if (count($articuloxcotizacion_reg) > 0) {
                foreach ($articuloxcotizacion_reg as $key) {
                    $id_apc = $key['axc_id'];
                    $articuloxcotizacion_array = array(
                        'axc_id_cot' => $cot_id_new,
                        'axc_id_art' => $key['axc_id_art'],
                        'axc_id_cva' => $key['axc_id_cva'],
                        'axc_descripcion' => $key['axc_descripcion'],
                        'axc_cantidad' => $key['axc_cantidad'],
                        'axc_precio' => $key['axc_precio'],
                        'axc_impuesto' => $key['axc_impuesto'],
                        'axc_descuento' => $key['axc_descuento'],
                        'axc_subtotal' => $key['axc_subtotal'],
                        'axc_total' => $key['axc_total'],
                        'axc_estado' => 1,
                        'axc_usu_creacion' => $this->tank_auth->get_user_id(),
                        'axc_fecha_creacion' => date('Y-m-d H:i:s'),
                        'axc_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'axc_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $axc_id = $this->gsatelite->ingresar('axc_articuloxcotizacion', $articuloxcotizacion_array);

                    if ($axc_id > 0) {
                        $axc_id_org = $key['axc_id'];

                        //Duplicar presupuesto
                        if ($checked == 1) {
                            $materia_prima_reg = $this->gsatelite->get_tabla('axr_articulo_materiaxarticulo', array('axr_id_axc' => $axc_id_org));
                            $mano_obra_articulo_reg = $this->gsatelite->get_tabla('mxa_mano_obraxarticulo', array('mxa_id_axc' => $axc_id_org));
                            $estimacion_articulo_reg = $this->gsatelite->get_tabla('exa_estimacionxarticulo', array('exa_id_axc' => $axc_id_org));
                            $costo_articulo_reg = $this->gsatelite->get_tabla('acs_articulo_costo', array('acs_id_axc' => $axc_id_org));

                            $materia_prima = array();
                            //$estado = false;
                            if (count($materia_prima_reg) > 0) {
                                foreach ($materia_prima_reg as $key) {
                                    $materia_prima[] = array(
                                        'axr_id_axc' => $axc_id,
                                        'axr_id_cva' => $key['axr_id_cva'],
                                        'axr_id_prv' => $key['axr_id_prv'],
                                        'axr_id_art_materia' => $key['axr_id_art_materia'],
                                        'axr_cantidad' => $key['axr_cantidad'],
                                        'axr_precio' => $key['axr_precio'],
                                        'axr_estimacion_porcentaje' => $key['axr_estimacion_porcentaje'],
                                        'axr_estado' => 1,
                                        'axr_usu_creacion' => $this->tank_auth->get_user_id(),
                                        'axr_fecha_creacion' => date('Y-m-d H:i:s'),
                                        'axr_usu_modificacion' => $this->tank_auth->get_user_id(),
                                        'axr_fecha_modificacion' => date('Y-m-d H:i:s')
                                    );
                                }
                                $this->gsatelite->ingresar('axr_articulo_materiaxarticulo', $materia_prima, true);
                                //$estado = true;
                            }

                            $mano_obra_articulo = array();
                            if (count($mano_obra_articulo_reg) > 0) {
                                foreach ($mano_obra_articulo_reg as $key) {
                                    $mano_obra_articulo[] = array(
                                        'mxa_id_axc' => $axc_id,
                                        'mxa_id_mob' => $key['mxa_id_mob'],
                                        'mxa_cantidad' => $key['mxa_cantidad'],
                                        'mxa_precio' => $key['mxa_precio'],
                                        'mxa_estimacion_porcentaje' => $key['mxa_estimacion_porcentaje'],
                                        'mxa_estado' => 1,
                                        'mxa_usu_mod' => $this->tank_auth->get_user_id(),
                                        'mxa_fecha_mod' => date('Y-m-d H:i:s'),
                                        'mxa_id_emp' => $key['mxa_id_emp']
                                    );
                                }
                                $this->gsatelite->ingresar('mxa_mano_obraxarticulo', $mano_obra_articulo, true);
                                //$estado = true;
                            }

                            $estimacion_articulo = array();
                            if (count($estimacion_articulo_reg) > 0) {
                                foreach ($estimacion_articulo_reg as $key) {
                                    $estimacion_articulo[] = array(
                                        'exa_id_esm' => $key['exa_id_esm'],
                                        'exa_id_axc' => $axc_id,
                                        'exa_cantidad' => $key['exa_cantidad'],
                                        'exa_precio' => $key['exa_precio'],
                                        'exa_monto_calculo' => $key['exa_monto_calculo'],
                                        'exa_estado' => 1,
                                        'exa_usu_mod' => $this->tank_auth->get_user_id(),
                                        'exa_fecha_mod' => date('Y-m-d H:i:s')
                                    );
                                }
                                $this->gsatelite->ingresar('exa_estimacionxarticulo', $estimacion_articulo, true);
                                //$estado = true;
                            }

                            $costo_articulo = array();
                            if (count($costo_articulo_reg) > 0) {
                                foreach ($costo_articulo_reg as $key) {
                                    $costo_articulo[] = array(
                                        'acs_id_axc' => $axc_id,
                                        'acs_costo' => $key['acs_costo'],
                                        'acs_porcentaje_marg' => $key['acs_porcentaje_marg'],
                                        'acs_margen' => $key['acs_margen'],
                                        'acs_precio' => $key['acs_precio'],
                                        'acs_observacion' => $key['acs_observacion'],
                                        'acs_estado' => 1,
                                        'acs_usu_mod' => $this->tank_auth->get_user_id(),
                                        'acs_fecha_mod' => date('Y-m-d H:i:s')
                                    );
                                }
                                $this->gsatelite->ingresar('acs_articulo_costo', $costo_articulo, true);
                                //$estado = true;
                            }
                        }

                        //impuestos
                        $impuestoxcotizacion_reg = $this->gsatelite->get_tabla('ixt_impuestoxcotizacion', array('ixt_id_axc' => $axc_id_org));
                        //arreglo donde se guarda la cotizacion existente
                        $impuestoxcotizacion_array = array();
                        if (count($impuestoxcotizacion_reg) > 0) {
                            foreach ($impuestoxcotizacion_reg as $key) {
                                $impuestoxcotizacion_array[] = array(
                                    'ixt_id_imp' => $key['ixt_id_imp'],
                                    'ixt_id_axc' => $axc_id,
                                    'ixt_monto' => $key['ixt_monto'],
                                    'ixt_estado' => 1,
                                    'ixt_usu_modificacion' => $this->tank_auth->get_user_id(),
                                    'ixt_fecha_modificacion' => date('Y-m-d H:i:s'),
                                    'ixt_usu_creacion' => $this->tank_auth->get_user_id(),
                                    'ixt_fecha_creacion' => date('Y-m-d H:i:s')
                                );
                            }
                            $this->gsatelite->ingresar('ixt_impuestoxcotizacion', $impuestoxcotizacion_array, true);
                        }

                        //prorrateo
                        /*$prorrateoxarticulo_cotizacion_reg = $this->gsatelite->get_tabla('pxt_prorrateoxarticulo_cotizacion',array('pxt_id_axc'=>$axc_id_org));
                        //arreglo donde se guarda la cotizacion existente
                        $prorrateoxarticulo_cotizacion_array = array();
                        if(count($prorrateoxarticulo_cotizacion_reg) > 0){
                            foreach ($prorrateoxarticulo_cotizacion_reg as $key) {
                                $prorrateoxarticulo_cotizacion_array[] = array(
                                    'pxt_id_dpr' => $key['pxt_id_dpr'],
                                    'pxt_id_axc' => $axc_id,
                                    'pxt_porcentaje' => $key['pxt_porcentaje'],
                                    'pxt_total' => $key['pxt_total'],
                                    'pxt_estado' => 1,
                                    'pxt_usu_creacion' => $this->tank_auth->get_user_id(),
                                    'pxt_fecha_creacion' => date('Y-m-d H:i:s'),
                                    'pxt_usu_modificacion' => $this->tank_auth->get_user_id(),
                                    'pxt_fecha_modificacion' => date('Y-m-d H:i:s')
                                );
                            }
                            $this->gsatelite->ingresar('pxt_prorrateoxarticulo_cotizacion', $prorrateoxarticulo_cotizacion_array, true);
                        }*/

                        //caracteristicas
                        $caracxarticuloxcotizacion_reg = $this->gsatelite->get_tabla('cxo_caracxarticuloxcotizacion', array('cxo_id_axc' => $axc_id_org));
                        //arreglo donde se guarda la cotizacion existente
                        $caracxarticuloxcotizacion_array = array();
                        if (count($caracxarticuloxcotizacion_reg) > 0) {
                            foreach ($caracxarticuloxcotizacion_reg as $key) {
                                $caracxarticuloxcotizacion_array[] = array(
                                    'cxo_id_cxu' => $key['cxo_id_cxu'],
                                    'cxo_id_axc' => $axc_id,
                                    'cxo_valor' => $key['cxo_valor'],
                                    'cxo_estado' => 1,
                                    'cxo_usu_creacion' => $this->tank_auth->get_user_id(),
                                    'cxo_fecha_creacion' => date('Y-m-d H:i:s'),
                                    'cxo_usu_modificacion' => $this->tank_auth->get_user_id(),
                                    'cxo_fecha_modificacion' => date('Y-m-d H:i:s')
                                );
                            }
                            $this->gsatelite->ingresar('cxo_caracxarticuloxcotizacion', $caracxarticuloxcotizacion_array, true);
                        }

                        $componentes = $this->gsatelite->get_tabla('cdc_componente_detalle_cotizacion', array('cdc_id_axc' => $id_apc));
                        if (count($componentes) > 0) {
                            foreach ($componentes as $key => $value) {
                                $comp_array = array(
                                    'cdc_id_axc' => $axc_id,
                                    'cdc_id_cva' => $value['cdc_id_cva'],
                                    'cdc_descripcion' => $value['cdc_descripcion'],
                                    'cdc_cantidad' => $value['cdc_cantidad'],
                                    'cdc_precio' => $value['cdc_precio'],
                                    'cdc_subtotal' => $value['cdc_subtotal'],
                                    'cdc_total' => $value['cdc_total'],
                                    'cdc_altera_precio' => $value['cdc_altera_precio'],
                                    'cdc_muestra_descripcion' => $value['cdc_muestra_descripcion'],
                                    'cdc_estado' => 1,
                                    'cdc_usu_creacion' =>  $this->tank_auth->get_user_id(),
                                    'cdc_usu_modificacion' => $this->tank_auth->get_user_id(),
                                    'cdc_fecha_modificacion' =>  date('Y-m-d H:i:s')
                                );
                                $this->gsatelite->ingresar('cdc_componente_detalle_cotizacion', $comp_array);
                            }
                        }
                    }
                }
            }
        }

        if ($estado) {
            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Cotización", 'texto_alerta' => "El registro se guardó correctamente. Cotización N. " . $codigo);
        } else {
            $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Cotización", 'texto_alerta' => "Ocurrio un problema al crear el registro.");
        }
        $this->session->set_flashdata($alerta);
        echo json_encode(array('estado' => $estado, 'cotizacion' => $cot_id_new, 'error' => ""));
        /*
        $producto_destino = $this->input->post('producto_des');
        $producto_origen = $this->input->post('producto_org');
        $url = $this->input->post('url');

        $materia_prima_reg = $this->gsatelite->get_tabla('mpa_materia_prima_articulo',array('mpa_id_art'=>$producto_origen));
        $estimacion_articulo_reg = $this->gsatelite->get_tabla('esr_estimacion_articulo',array('esr_id_art'=>$producto_origen));
        $mano_obra_articulo_reg = $this->gsatelite->get_tabla('moa_mano_obra_articulo',array('moa_id_art'=>$producto_origen));

        $materia_prima = array();

        $estado = false;
        if(count($materia_prima_reg) > 0){
            $this->gsatelite->ingresar('mpa_materia_prima_articulo', $materia_prima, true);
            $estado = true;
        }
        if(count($estimacion_articulo_reg) > 0){
            $this->gsatelite->ingresar('esr_estimacion_articulo', $estimacion_articulo, true);
            $estado = true;
        }
        if(count($mano_obra_articulo_reg) > 0){
            $this->gsatelite->ingresar('moa_mano_obra_articulo', $mano_obra_articulo, true);
            $estado = true;
        }*/
    }

    /**
     * @author Habby Lovo
     * @since 2018-02-21
     * @return
     */
    public function get_productos_like()
    {
        satelite_validar(true);
        $producto = ($this->input->post('producto') != '') ? $this->input->post('producto') : null;
        $servicio = ($this->input->post('servicio') != '') ? $this->input->post('servicio') : null;
        $aplicaProduccion = $this->input->post('aplicaProduccion');

        $where = null;
        $like = null;

        if ($producto != '') {
            if ($servicio == '2') {
                $where = array('art_venta' => 1, 'art_tipo' => 1, 'art_estado' => 1);
                $bodegas = null;
                if ($aplicaProduccion == 1) {
                    $where['art_produccion'] = 1;
                }
            } else {
                $where = array('art_venta' => 1, 'art_tipo >=' => 0, 'art_estado' => 1);
                $bodxus = $this->inventario_model->get_bodegas_usuario();
                $bodegas = array_column($bodxus, 'bod_id');
                if ($aplicaProduccion == 1) {
                    $where['art_produccion'] = 1;
                }
            }
            /*$like = "(art_nombre LIKE '%".$producto."%' 
                        OR art_codigo LIKE '%".$producto."%' 
                        OR art_sinonimo LIKE '%".$producto."%' 
                        OR cdp_codigo LIKE '%".$producto."%')";*/
            $like = $producto;
        }
        // $bodxus = $this->inventario_model->get_bodegas_usuario();        
        // $bodegas = array_column($bodxus, 'bod_id');
        $arreglo = array();
        $extra = '';
        $productos = $this->cotModel->get_productos_bodega_user($where, $like, $bodegas);
        //$productos = $this->cotModel->get_productos_likee($where, $like, $bodegas);
        if (count($productos) > 0) {
            foreach ($productos as $key => $value) {
                $cant = ($value['totales'] != NULL) ? $value['totales'] : '0';
                $arreglo[$key]['producto'] = $value['art_id'];
                $arreglo[$key]['codigo'] = $value['art_codigo'];

                $extra = ($value['cdp_codigo'] != '') ? $value['cdp_codigo'] : '';
                if ($value['art_sinonimo'] != '') {
                    $extra = ($extra != '') ? $extra . '/ ' . $value['art_sinonimo'] : $value['art_sinonimo'];
                }
                $extra = ($extra != '') ? ' (' . $extra . ')' : '';
                $extra .= ' (Existencia: ' . $cant . ')';

                $arreglo[$key]['prod_nombre'] = $value['art_nombre'] . $extra;
                $arreglo[$key]['tipo'] = $value['art_tipo'];
                /*  $arreglo[$key]['precio'] = $value['sar_precio'];
                $arreglo[$key]['tipo'] = $value['art_tipo'];*/
            }
        }
        echo json_encode($arreglo);
    }

    /**
     * @author Edith Herrera
     * @since 2018-03-12
     * @return
     **/
    function seguimiento_control_sac($id_tbl)
    {
        if ($id_tbl <= 0) {
            die('Error!');
        }
        $data['registro'] = $registro = $this->cotModel->getSeguimiento(array('tbl_id' => $id_tbl));

        $crud = new grocery_CRUD();
        $crud->set_table('sel_seguimiento_llamada')
            ->set_subject('Seguimiento')
            ->columns('sel_id_esn', 'sel_id_ven', 'sel_fecha', 'sel_fecha_proximo', 'sel_comentario')
            ->add_fields('sel_id_tbl', 'sel_id_esn',  'sel_id_ven', 'sel_fecha', 'sel_fecha_proximo', 'sel_comentario', 'sel_usu_creacion', 'sel_fecha_creacion', 'sel_usu_modificacion', 'sel_fecha_modificacion', 'sel_notificado', 'sel_estado')
            ->edit_fields('sel_id_tbl', 'sel_id_esn', 'sel_id_ven', 'sel_fecha', 'sel_fecha_proximo', 'sel_comentario', 'sel_usu_modificacion', 'sel_fecha_modificacion', 'sel_notificado')

            ->display_as('sel_id_esn', 'Estado de atención')
            ->display_as('sel_id_ven', 'Ejecutivo asignado')
            ->display_as('sel_fecha', 'Fecha')
            ->display_as('sel_fecha_proximo', 'Próximo seguimiento')
            ->display_as('sel_comentario', 'Comentario')
            ->where("sel_id_tbl", $id_tbl)
            ->required_fields('sel_fecha_proximo', 'sel_comentario', 'sel_estado')
            ->set_relation('sel_id_esn', 'esn_estado_atencion', 'esn_nombre')
            ->set_relation('sel_id_ven', 'ven_vendedor', '{ven_nombre} {ven_apellidos}')

            ->field_type('sel_id_tbl', 'hidden', $id_tbl)

            ->field_type('sel_notificado', 'hidden', 0)

            ->field_type('sel_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
            ->field_type('sel_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
            ->field_type('sel_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
            ->field_type('sel_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))

            ->callback_column('sel_fecha_proximo', array($this, '_formatoFecha'))
            ->callback_column('sel_fecha', array($this, '_formatoFecha'))

            ->callback_edit_field('sel_notificado', function ($value, $primary_key) {
                return '<input id="field-sel_notificado" type="hidden" name="sel_notificado" value="0">';
            });

        if (count($registro) && $registro->sel_fecha != '') {
            $crud->field_type('sel_fecha', 'hidden', formatear_fecha('Y-m-d H:i:s', $registro->sel_fecha));
        } else if (count($registro) && $registro->tbl_fecha != '') {
            $crud->field_type('sel_fecha', 'hidden', formatear_fecha('Y-m-d H:i:s', $registro->tbl_fecha));
        } else {
            $crud->field_type('sel_fecha', 'hidden', date('Y-m-d H:i:s'));
        }

        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('sel_estado', 'hidden', 1);
        } else {
            $crud->field_type('sel_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

        $data['titulo_personal'] = "Seguimiento";
        $crud->unset_delete()->unset_export()->unset_print();

        if ($this->input->post()) {
            $alerta['registroProcesado'] = 1;
            $this->session->set_flashdata($alerta);
        }

        $output = $crud->render();
        $this->gsatelite->cargar_vista_masterpage('cotizaciones/cotizaciones/seguimiento_control_sac', $data, $output);
    }

    function get_contactos_dropdown()
    {
        satelite_validar(true);

        $cliente = $this->input->post('cliente');
        $contactos = $this->gsatelite->get_dropdown('con_contacto', '{con_nombre} {con_apellidos}', '', array('con_estado' => 1, 'con_id_cli' => $cliente), null, '', 'con_id', true);
        $dp_contactos = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $contactos);

        echo json_encode($dp_contactos);
    }


    function _formatoFecha($value, $row){
        if ($value != '') {
            return '<span style="display:none;">'.formatear_fecha('YmdHis',$value).'</span>' .  date('d-m-Y', strtotime($value));
        } else {
            return '';
        }
    }

    /**
     * @author Edith Herrera - Grupo Satélite
     * @since  2018-08-23
     * @return Impresión de envío parcial
     */
    function imprimir_envio_parcial($id_cot, $id_envio = null)
    {
        satelite_validar();
        $this->gsatelite->verificar_registro_real('cot_cotizacion', $id_cot);
        $consulta = $this->cotModel->get_cotizacion(array('cot_id' => $id_cot));

        $decimales_par = $this->gsatelite->get_parametro('NUMERO_DECIMALES');

        $data["detalle"] = $this->cotModel->get_envío_cot(array('axc_id_cot' => $id_cot, 'enc_id' => $id_envio));
        //die(print_r($data["detalle"]));
        $data['esreporte'] = true;
        $html = $this->load->view('cotizaciones/cotizaciones/imprimir_envio_parcial', $data, true);

        $this->load->library('Pdf'); //libreria pdf
        if ($this->gsatelite->get_parametro('COT_APLICA_PIE_PAGINA') == 1) {
            $GLOBALS['es_cotizacion'] = 1;
            $this->pdf->setPrintFooter(false);
        } else {
            $this->pdf->setPrintFooter(false);
        }
        $this->pdf->makePDF_cotizacion($html, 'P', $nombre_pdf, 'Letter', 'I');
    }

    /**
     * @author Edith Herrera - Grupo Satélite
     * @since  2018-09-03
     * @return Se obtiene el dropdown de etiquetas
     */
    function get_etiquetas_base()
    {
        $base = $this->input->post('base');

        $etiquetas = $this->gsatelite->get_tabla('exc_etiquetaxcontacto', array('exc_id_drn' => $base));
        $selected = array_column($etiquetas, 'exc_id_etq');

        $select = $this->gsatelite->get_dropdown('etq_etiqueta', 'etq_nombre', 'etiquetas', array('etq_estado' => 1), $selected, null, 'etq_id', true);
        $etiquetas_sel = str_replace('<option value="0">Seleccione</option>', '', $select);
        $etiquetas_sel = str_replace('<option value="0">Sin Registros</option>', '<option value=""></option>', $etiquetas_sel);
        echo $etiquetas_sel;
    }

    /**
     * @author Edith Herrera - Grupo Satélite
     * @since  2018-09-03
     * @return Guardar etiquetas por base seleccionada
     */
    function guardar_etiquetas_base()
    {
        $base = $this->input->post('base');
        $etiqueta = $this->input->post('etiqueta');

        $exito = 0;

        if ($base > 0) {
            $this->gsatelite->borrado_general('exc_etiquetaxcontacto', array('exc_id_drn' => $base));
            //Se ingresan las etiquetas
            if (count($etiqueta) > 0) {
                for ($i = 0; $i < count($etiqueta); $i++) {
                    $etiqueta_array = array(
                        'exc_id_drn' => $base,
                        'exc_id_etq' => $etiqueta[$i],
                        'exc_estado' => 1,
                        'exc_usu_creacion' => $this->tank_auth->get_user_id(),
                        'exc_fecha_creacion' => date('Y-m-d H:i:s'),
                        'exc_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'exc_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->ingresar('exc_etiquetaxcontacto', $etiqueta_array);
                    $exito++;
                }
            }
        }

        echo $exito;
        die();
    }

    function get_sucursal_info()
    {
        $sucursal = $this->input->post('sucursal');

        $info = $this->gsatelite->get_registro('scl_sucursal_cliente', array('scl_id' => $sucursal));
        $direccion = $info->scl_direccion;
        echo json_encode($direccion);
    }

    /**
     * @author Luis Navarro - Grupo Satélite
     * @since  2018-09-10
     * @return Gestion de campañas
     */
    public function gestion_campanas()
    {
        satelite_validar();
        $permisos         = $this->gsatelite->get_permisos_opcion();
        $data['permisos'] = $permisos;
        if ($this->input->post()) {
            $campana = (is_numeric($this->input->post('campana'))) ? $this->input->post('campana') : '';
            $txtFechaIni = $this->input->post('txtFechaIni');
            $txtFechaFin = $this->input->post('txtFechaFin');

            $where = array();
            $html = '';

            if (trim($txtFechaIni) != "" && trim($txtFechaFin) != "") {
                $desde = formatear_fecha("Y-m-d", $txtFechaIni);
                $hasta = formatear_fecha("Y-m-d", $txtFechaFin);
                $where["DATE(cam_fecha_registro) BETWEEN '$desde' AND '$hasta'"] = null;
            }

            if ($campana != '') {
                $where['cam_id'] = $campana;
            }
            // print_r($where);die();
            $this->db->order_by('cam_id');
            $data['campanas'] = $this->gsatelite->get_tabla('cam_campania', $where);
            // print_r($this->db->last_query());die();
            $html = $this->load->view('cotizaciones/cotizaciones/detalle_campanas', $data, true);

            echo $html;
            die();
        } else {
            // Datos a mostrar
            // $html = $this->load->view('registro_academico/procesos/detalle_horarios_supervisor', $data, true);

            $data['titulo_personal'] = "Campaña";
            $this->_cargarvista($data);
        }
    }

    /**
     * @author Luis Navarro - Grupo Satélite
     * @since  2018-09-10
     * @return Pantalla de agregar campaña
     */
    public function agregar_campana()
    {
        satelite_validar();
        $permisos         = $this->gsatelite->get_permisos_opcion('cotizaciones/cotizaciones/gestion_campanas');
        $data['permisos'] = $permisos;
        if ($this->input->post()) {

            //print_r($_POST);die();
            // Declaracion de variables
            $campana_codigo = (trim($this->input->post('campana_codigo')) != "") ? $this->input->post('campana_codigo') : null;
            $campana_nombre = (trim($this->input->post('campana_nombre')) != "") ? $this->input->post('campana_nombre') : null;
            $campana_descripcion = (trim($this->input->post('campana_descripcion')) != "") ? $this->input->post('campana_descripcion') : null;
            $campana_fecha_inicio = (trim($this->input->post('campana_fecha_inicio')) != "") ? $this->input->post('campana_fecha_inicio') : null;
            $campana_fecha_fin   = (trim($this->input->post('campana_fecha_fin')) != "") ? $this->input->post('campana_fecha_fin') : null;
            $contacto_nombre_a   = (is_array($this->input->post('contacto_nombre_a'))) ? $this->input->post('contacto_nombre_a') : array(); // Array
            $contacto_type = (is_array($this->input->post('type'))) ? $this->input->post('type') : array(); // Array
            $nombreCarpeta       = (trim($this->input->post('nombreCarpeta')) != "") ? $this->input->post('nombreCarpeta') : null;
            $titulo_doc          = (trim($this->input->post('titulo_doc')) != "") ? $this->input->post('titulo_doc') : null;
            $ruta                = (trim($this->input->post('ruta')) != "") ? $this->input->post('ruta') : null;

            $destino = "uploads/" . $nombreCarpeta . "/" . $ruta;

            $campana_guardar = array(
                'cam_id_usu'             => $this->tank_auth->get_user_id(),
                'cam_fecha_registro'     => date('Y-m-d H:i:s'),
                'cam_codigo'             => $campana_codigo,
                'cam_nombre'             => $campana_nombre,
                'cam_fecha_desde'        => formatear_fecha('Y-m-d', $campana_fecha_inicio),
                'cam_fecha_hasta'        => formatear_fecha('Y-m-d', $campana_fecha_fin),
                'cam_contenido'          => $campana_descripcion,
                'cam_url'                => $destino,
                'cam_estado'             => 1,
                'cam_usu_creacion'       => $this->tank_auth->get_user_id(),
                'cam_fecha_creacion'     => date('Y-m-d H:i:s'),
                'cam_usu_modificacion'   => $this->tank_auth->get_user_id(),
                'cam_fecha_modificacion' => date('Y-m-d H:i:s')
            );
            $campana_id = $this->gsatelite->ingresar('cam_campania', $campana_guardar);

            /* ===========================================================================================================
                                ARRAY PARA GUARDAR LOS DATOS DE CONTACTOS
            =========================================================================================================== */
            //Se Agregara los datos a la tabla
            for ($x = 0; $x < count($contacto_nombre_a); $x++) {
                if ($contacto_nombre_a[$x] > 0) {
                    if ($contacto_type[$x] == 'Cliente') {
                        $guardar_contacto = array(
                            'cnc_id_cam'             => $campana_id,
                            'cnc_id_cli'             => ($contacto_nombre_a[$x] > 0) ? $contacto_nombre_a[$x] : null,
                            'cnc_id_drn'             => null,
                            'cnc_estado'             => 1,
                            'cnc_usu_creacion'       => $this->tank_auth->get_user_id(),
                            'cnc_fecha_creacion'     => date('Y-m-d H:i:s'),
                            'cnc_usu_modificacion'   => $this->tank_auth->get_user_id(),
                            'cnc_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                    } else {
                        $guardar_contacto = array(
                            'cnc_id_cam'             => $campana_id,
                            'cnc_id_drn'             => ($contacto_nombre_a[$x] > 0) ? $contacto_nombre_a[$x] : null,
                            'cnc_estado'             => 1,
                            'cnc_usu_creacion'       => $this->tank_auth->get_user_id(),
                            'cnc_fecha_creacion'     => date('Y-m-d H:i:s'),
                            'cnc_usu_modificacion'   => $this->tank_auth->get_user_id(),
                            'cnc_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                    }

                    $this->gsatelite->ingresar('cnc_contactos_campania', $guardar_contacto);
                }
            }


            /* ===========================================================================================================
                                        MENSAJE DE REALIZADO
            =========================================================================================================== */
            if ($campana_id > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro de Campaña", 'texto_alerta' => "El registro se guardó correctamente.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro de Campaña", 'texto_alerta' => "El registro no se guardó correctamente.");
            }
            /* ===========================================================================================================
                                        REDIRECCIONES
            =========================================================================================================== */
            $redireccion = $this->input->post('redireccion');
            $this->session->set_flashdata($alerta);

            if ($redireccion == 1) {
                redirect('cotizaciones/cotizaciones/agregar_campana');
            } else {
                redirect('cotizaciones/cotizaciones/gestion_campanas');
            }
            die();
        } else {
            // Datos a mostrar
            $selected = $this->gsatelite->get_dropdown('ogc_origen_contacto', 'ogc_nombre', 'origen', array('ogc_estado' => 1), null, null, null, true);
            $data['origen'] = str_replace('<option value="0">Seleccione</option>', '<option></option>', $selected);

            $selected = $this->gsatelite->get_dropdown('pai_pais', 'pai_nombre', 'paises', array('pai_estado' => 1), null, null, null, true);
            $data['paises'] = str_replace('<option value="0">Seleccione</option>', '<option></option>', $selected);

            $selected = $this->gsatelite->get_dropdown('sec_sector_cliente', 'sec_nombre', 'sector_cliente', array('sec_estado' => 1), null, null, null, true);
            $data['sector_cliente'] = str_replace('<option value="0">Seleccione</option>', '<option></option>', $selected);

            $selected = $this->gsatelite->get_dropdown('cac_cartera_cliente', 'cac_nombre', 'cartera', array('cac_estado' => 1), null, null, null, true);
            $data['sector'] = str_replace('<option value="0">Seleccione</option>', '<option></option>', $selected);

            $selected = $this->gsatelite->get_dropdown('cac_cartera_cliente', 'cac_nombre', 'cartera', array('cac_estado' => 1), null, null, null, true);
            $data['cartera_cliente'] = str_replace('<option value="0">Seleccione</option>', '<option></option>', $selected);

            $selected = $this->gsatelite->get_dropdown('etq_etiqueta', 'etq_nombre', 'etiquetas', array('etq_estado' => 1), null, null, null, true);
            $data['etiquetas'] = str_replace('<option value="0">Seleccione</option>', '<option></option>', $selected);

            $selected = $this->gsatelite->get_dropdown('cli_cliente', trim('{cli_nombre} {cli_apellido}'), 'clientes', array('cli_estado' => 1), null, null, null, true);
            $data['clientes'] = str_replace('<option value="0">Seleccione</option>', '<option></option>', $selected);

            $selected = $this->gsatelite->get_dropdown('tpc_tipo_cliente', 'tpc_nombre', 'tipo_clientes', array('tpc_estado' => 1), null, null, null, true);
            $data['tipo_clientes'] = str_replace('<option value="0">Seleccione</option>', '<option></option>', $selected);

            $selected = "<option value=''>Seleccione</option><option value='1'>Natural</option><option value='2'>Juridica</option>";
            $data['personeria'] = str_replace('<option value="0">Seleccione</option>', '<option></option>', $selected);

            /*  ************************** Codigo para mostrar en la campana ************************  */
            $abre_mes = array(1 => 'EN', 2 => 'FEBR', 3 => 'MZO', 4 => 'ABR', 5 => 'MY', 6 => 'JUN', 7 => 'JUL', 8 => 'AG', 9 => 'SEPT', 10 => 'OCT', 11 => 'NOV', 12 => 'DIC');
            $mes =  $abre_mes[intval(date('m'))];
            $correlativo = $this->gsatelite->count('cam_campania');
            $codigo = $mes . date('Y') . '-' . str_pad(($correlativo + 1), 3, "0", STR_PAD_LEFT);
            $data['codigo_automatico']  = $codigo;

            // $html = $this->load->view('registro_academico/procesos/detalle_horarios_supervisor', $data, true);
            $data['titulo_personal'] = "Agregar Campaña";
            $this->_cargarvista($data);
        }
    }

    /**
     * @author Luis Navarro - Grupo Satélite
     * @since  2018-09-10
     * @return Pantalla de editar campaña
     */
    public function editar_campana($id = null, $ver = null, $iframe = null)
    {
        if ($this->input->post()) {
            // print_r($_POST);die();
            $campana_codigo = (trim($this->input->post('campana_codigo')) != "") ? $this->input->post('campana_codigo') : null;
            $campana_nombre = (trim($this->input->post('campana_nombre')) != "") ? $this->input->post('campana_nombre') : null;
            $campana_descripcion = (trim($this->input->post('campana_descripcion')) != "") ? $this->input->post('campana_descripcion') : null;
            $campana_fecha_inicio = (trim($this->input->post('campana_fecha_inicio')) != "") ? $this->input->post('campana_fecha_inicio') : null;
            $campana_fecha_fin   = (trim($this->input->post('campana_fecha_fin')) != "") ? $this->input->post('campana_fecha_fin') : null;
            $contacto_nombre_a   = (is_array($this->input->post('contacto_nombre_a'))) ? $this->input->post('contacto_nombre_a') : array(); // Array
            $nombreCarpeta       = (trim($this->input->post('nombreCarpeta')) != "") ? $this->input->post('nombreCarpeta') : null;
            $titulo_doc          = (trim($this->input->post('titulo_doc')) != "") ? $this->input->post('titulo_doc') : null;
            $ruta                = (trim($this->input->post('ruta')) != "") ? $this->input->post('ruta') : null;
            $contacto_type = (is_array($this->input->post('type'))) ? $this->input->post('type') : array(); // Array
            $campana_estado      = (trim($this->input->post("campana_estado")) != "") ? $this->input->post("campana_estado") : 0;

            $destino = "uploads/" . $nombreCarpeta . "/" . $ruta;

            $campana_guardar = array(
                'cam_codigo'             => $campana_codigo,
                'cam_nombre'             => $campana_nombre,
                'cam_fecha_desde'        => formatear_fecha('Y-m-d', $campana_fecha_inicio),
                'cam_fecha_hasta'        => formatear_fecha('Y-m-d', $campana_fecha_fin),
                'cam_contenido'          => $campana_descripcion,
                'cam_url'                => $destino,
                'cam_estado'             => $campana_estado,
                'cam_usu_modificacion'   => $this->tank_auth->get_user_id(),
                'cam_fecha_modificacion' => date('Y-m-d H:i:s')
            );
            $campana_id = $this->gsatelite->actualizar_array('cam_campania', $campana_guardar, array('cam_id' => $id));

            /* ===========================================================================================================
                                ARRAY PARA GUARDAR LOS DATOS DE CONTACTOS
            =========================================================================================================== */
            //Se Agregara los datos a la tabla
            $this->gsatelite->borrado_general('cnc_contactos_campania', array('cnc_id_cam' => $id));
            for ($x = 0; $x < count($contacto_nombre_a); $x++) {
                if ($contacto_nombre_a[$x] > 0) {
                    if ($contacto_type[$x] == 'Cliente') {
                        $guardar_contacto = array(
                            'cnc_id_cam'             => $id,
                            'cnc_id_cli'             => ($contacto_nombre_a[$x] > 0) ? $contacto_nombre_a[$x] : null,
                            'cnc_id_drn'             => null,
                            'cnc_estado'             => 1,
                            'cnc_usu_creacion'       => $this->tank_auth->get_user_id(),
                            'cnc_fecha_creacion'     => date('Y-m-d H:i:s'),
                            'cnc_usu_modificacion'   => $this->tank_auth->get_user_id(),
                            'cnc_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                    } else {
                        $guardar_contacto = array(
                            'cnc_id_cam'             => $id,
                            'cnc_id_drn'             => ($contacto_nombre_a[$x] > 0) ? $contacto_nombre_a[$x] : null,
                            'cnc_estado'             => 1,
                            'cnc_usu_creacion'       => $this->tank_auth->get_user_id(),
                            'cnc_fecha_creacion'     => date('Y-m-d H:i:s'),
                            'cnc_usu_modificacion'   => $this->tank_auth->get_user_id(),
                            'cnc_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                    }
                    $this->gsatelite->ingresar('cnc_contactos_campania', $guardar_contacto);
                }
            }


            /* ===========================================================================================================
                                        MENSAJE DE REALIZADO
            =========================================================================================================== */
            if ($campana_id > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro de Campaña", 'texto_alerta' => "El registro se actualizó correctamente.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro de Campaña", 'texto_alerta' => "El registro no se actualizó correctamente.");
            }
            /* ===========================================================================================================
                                        REDIRECCIONES
            =========================================================================================================== */
            $redireccion = $this->input->post('redireccion');
            $this->session->set_flashdata($alerta);

            if ($redireccion == 1) {
                redirect('cotizaciones/cotizaciones/editar_campana/' . $id);
            } else {
                redirect('cotizaciones/cotizaciones/gestion_campanas');
            }
            die();
        } else {

            // Cargar datos para editar
            $data['id'] = $id;
            $data['campana'] = $this->gsatelite->get_tabla('cam_campania', array('cam_id' => $id));
            $data['det_campana'] = $this->cotModel->get_contactos_x_campana(array('cnc_id_cam' => $id));

            // Procesar el tipo de imagen 
            $nombre_archivo = explode("/", $data['campana'][0]['cam_url']);
            if (isset($nombre_archivo[2]) && $nombre_archivo[2] != "") {
                $extension_imagen = '';
                $ext_data         = explode(".", $nombre_archivo[2]);
                switch (strtolower(trim($ext_data[1]))) {
                    case 'docx':
                        $extension_imagen = 'docx';
                        break;
                    case 'doc':
                        $extension_imagen = 'doc';
                        break;
                    case 'pdf':
                        $extension_imagen = 'pdf';
                        break;
                    case 'xlsx':
                        $extension_imagen = 'xlsx';
                        break;
                    case 'xls':
                        $extension_imagen = 'xls';
                        break;
                    case 'txt':
                        $extension_imagen = 'txt';
                        break;
                    case 'rar':
                        $extension_imagen = 'rar';
                        break;
                    case 'png':
                        $extension_imagen = 'png';
                        break;
                    case 'jpg':
                        $extension_imagen = 'jpg';
                        break;
                    case 'jpeg':
                        $extension_imagen = 'jpeg';
                        break;
                    default:
                        $extension_imagen = 'txt';
                        break;
                }
                $data['extension_imagen'] = $extension_imagen;
            }

            // Datos a mostrar
            $selected = $this->gsatelite->get_dropdown('ogc_origen_contacto', 'ogc_nombre', 'origen', array('ogc_estado' => 1), null, null, null, true);
            $data['origen'] = str_replace('<option value="0">Seleccione</option>', '<option></option>', $selected);

            $selected = $this->gsatelite->get_dropdown('pai_pais', 'pai_nombre', 'paises', array('pai_estado' => 1), null, null, null, true);
            $data['paises'] = str_replace('<option value="0">Seleccione</option>', '<option></option>', $selected);

            $selected = $this->gsatelite->get_dropdown('cac_cartera_cliente', 'cac_nombre', 'cartera', array('cac_estado' => 1), null, null, null, true);
            $data['sector'] = str_replace('<option value="0">Seleccione</option>', '<option></option>', $selected);

            $selected = $this->gsatelite->get_dropdown('sec_sector_cliente', 'sec_nombre', 'sector_cliente', array('sec_estado' => 1), null, null, null, true);
            $data['sector_cliente'] = str_replace('<option value="0">Seleccione</option>', '<option></option>', $selected);

            $selected = $this->gsatelite->get_dropdown('cac_cartera_cliente', 'cac_nombre', 'cartera', array('cac_estado' => 1), null, null, null, true);
            $data['cartera_cliente'] = str_replace('<option value="0">Seleccione</option>', '<option></option>', $selected);

            $selected = $this->gsatelite->get_dropdown('etq_etiqueta', 'etq_nombre', 'etiquetas', array('etq_estado' => 1), null, null, null, true);
            $data['etiquetas'] = str_replace('<option value="0">Seleccione</option>', '<option></option>', $selected);

            $selected = $this->gsatelite->get_dropdown('cli_cliente', trim('{cli_nombre} {cli_apellido}'), 'clientes', array('cli_estado' => 1), null, null, null, true);
            $data['clientes'] = str_replace('<option value="0">Seleccione</option>', '<option></option>', $selected);

            $selected = $this->gsatelite->get_dropdown('tpc_tipo_cliente', 'tpc_nombre', 'tipo_clientes', array('tpc_estado' => 1), null, null, null, true);
            $data['tipo_clientes'] = str_replace('<option value="0">Seleccione</option>', '<option></option>', $selected);

            $selected = "<option value=''>Seleccione</option><option value='1'>Natural</option><option value='2'>Juridica</option>";
            $data['personeria'] = str_replace('<option value="0">Seleccione</option>', '<option></option>', $selected);

            /*  ************************** Codigo para mostrar en la campana ************************  */
            $abre_mes = array(1 => 'EN', 2 => 'FEBR', 3 => 'MZO', 4 => 'ABR', 5 => 'MY', 6 => 'JUN', 7 => 'JUL', 8 => 'AG', 9 => 'SEPT', 10 => 'OCT', 11 => 'NOV', 12 => 'DIC');
            $mes =  $abre_mes[intval(date('m'))];
            $correlativo = $this->gsatelite->count('cam_campania');
            $codigo = $mes . date('Y') . str_pad(($correlativo + 1), 3, "0", STR_PAD_LEFT);
            $data['codigo_automatico']  = $codigo;
            $tcm_medios = $this->cotModel->get_medio();

            $data_tcm_medio = [];
            foreach ($tcm_medios as $key) {
                $data_tcm_medio[$key['cli_id']] = $key['tmc_nombre'];
            }
            $data['tcm_medio_cli'] = $data_tcm_medio;

            // $html = $this->load->view('registro_academico/procesos/detalle_horarios_supervisor', $data, true);
            $data['titulo_personal'] = "Editar Campaña";
            if ($iframe == 1) {
                $this->gsatelite->cargar_vista_masterpage('cotizaciones/cotizaciones/editar_campana', $data);
            } else {
                $this->_cargarvista($data);
            }
        }
    }

    /**
     * @author Luis Navarro - Grupo Satélite
     * @since  2018-09-10
     * @return Anular una campana
     */
    public function anular_campana($id = null)
    {
        if ($id != null) {
            $id = $this->input->post('idcamp');
            $comentario = $this->input->post('motivo');
            $campana_actualizar = array(
                'cam_estado'             => 0,
                'cam_observacion_anulacion' => $comentario,
                'cam_id_usu_anula' => $this->tank_auth->get_user_id(),
                'cam_fecha_anulacion' => date('Y-m-d H:i:s'),
                'cam_usu_modificacion'   => $this->tank_auth->get_user_id(),
                'cam_fecha_modificacion' => date('Y-m-d H:i:s')
            );
            $campana_id = $this->gsatelite->actualizar_array('cam_campania', $campana_actualizar, array('cam_id' => $id));

            if ($campana_id > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro de Campaña", 'texto_alerta' => "El registro se Anuló correctamente.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro de Campaña", 'texto_alerta' => "El registro no se Anuló correctamente.");
            }
            $this->session->set_flashdata($alerta);
            redirect('cotizaciones/cotizaciones/gestion_campanas');
        } else {
            $this->gsatelite->show_dialog('No hay un identificador para anular Campaña', '', 'error', 'Anular Campaña');
        }
    }

    /**
     * @author Luis Navarro - Grupo Satélite
     * @since  2018-09-10
     * @return Consultar contactos para campaña
     */
    public function get_contactos_db()
    {
        satelite_validar();

        if ($this->input->post()) {
            // print_r($_POST);die();
            $segmento   = $this->input->post("segmento");
            //$origen     = $this->input->post("origen");            

            $ori        = ($this->input->post("origen") != 'null' && count($this->input->post("origen")) > 0) ? $this->input->post("origen") : array();

            $sector_cliente     = $this->input->post("sector_cliente");
            $eti        = ($this->input->post("etiquetas") != 'null' && count($this->input->post("etiquetas")) > 0) ? $this->input->post("etiquetas") : array();
            $etiquetas  = ($eti != null && count($eti) > 0) ? implode(",", $eti) : array();
            /*$cliente = $this->input->post("cliente");
            $personeria = $this->input->post("personeria");
            $tipo_cli = $this->input->post("tipo_cli");
           */

            //die(print_r($eti));
            //die();

            // $where = array('drn_id_cli' => null);
            $where = array();
            $where_in_ori = array();
            $where_in_eti = array();
            if (trim($segmento) != "") {
                $where['cac_id'] = $segmento;
            }
            if (count($ori) > 0) {
                //$where['ogc_id'] = $origen;
                $where_in_ori = $ori;
            }
            if (trim($sector_cliente) != "") {
                $where['sec_id'] = $sector_cliente;
            }
            if (count($eti) > 0) {
                $where_in_eti = $eti;
            }

            /*print_r($where);
            echo "<br>";
            print_r($where_in_ori);
            echo "<br>";
            print_r($where_in_eti);*/
            //print_r($where_in_ori); die();
            //die();

            //print_r($where_in_eti); die();
            /*if (trim($cliente) != "") {
                $where['cli_id'] = $cliente;
            }
            if (trim($tipo_cli) != "") {
                $where['cli_id_tpc'] = $tipo_cli;
            }
            if (trim($personeria) != "") {
                $where['cli_personeria'] = $personeria;
            }*/

            //parametros where, where_in(etiquetas), 1 = contactos
            $data['contactos'] = $this->cotModel->get_base_datos($where, $where_in_ori, $where_in_eti);
            //print_r($this->db->last_query()); die();

            $html = $this->load->view('cotizaciones/cotizaciones/consultar_contactos_db', $data, true);
            echo json_encode(array('html' => $html));
            die();
        }
    }
    public function get_clientes_db()
    {
        satelite_validar();

        if ($this->input->post()) {
            // print_r($_POST);die();
            $cliente = $this->input->post("cliente");
            $personeria = $this->input->post("personeria");
            //$tipo_cli = $this->input->post("tipo_cli");
            $ti_cli  = ($this->input->post("tipo_cli") != 'null' && count($this->input->post("tipo_cli")) > 0) ? $this->input->post("tipo_cli") : array(); //(count($this->input->post("tipo_cli")) > 0) ? $this->input->post("tipo_cli") : null;

            //$tipo_cli  = ($ti_cli != null && count($ti_cli)>0)?implode(",", $ti_cli):array();
            //print_r($tipo_cli); die();
            $sector = $this->input->post("sector"); //sector_cliente2
            $segmento = $this->input->post("segmento"); //campana_segmento2


            //die(print_r($ti_cli));

            // $where = array('drn_id_cli' => null);
            $where = array();
            $where_in = array();

            if (trim($cliente) != "") {
                $where['cli_id'] = $cliente;
            }
            if (count($ti_cli) > 0) {
                //$where['cli_id_tpc'] = $tipo_cli;
                $where_in = $ti_cli;
                //print_r($where_in); die();
            }

            if (trim($personeria) != "") {
                $where['cli_personeria'] = $personeria;
            }

            if (trim($sector) != "") {
                $where['cli_id_sec'] = $sector;
            }
            if (trim($segmento) != "") {
                $where['cli_id_cac'] = $segmento;
            }

            //parametros where, where_in(etiquetas), 2 = clientes
            $data['clientes'] = $this->cotModel->get_base_datos($where, $where_in, null, 1);
            //print_r($this->db->last_query()); die();

            $html = $this->load->view('cotizaciones/cotizaciones/consultar_contactos_db', $data, true);
            echo json_encode(array('html' => $html));
            die();
        }
    }
    /**
     * @author Luis Navarro - Grupo Satélite
     * @since  2018-09-10
     * @return Registrar anexo
     */
    public function registrar_anexo($parametros, $carpeta = null)
    {
        $datos = @explode($parametros);
        $carpeta = $parametros;
        $image = $this->subir_anexo($carpeta);
        echo $image['upload_data']['raw_name'] . $image['upload_data']['file_ext'];
    }

    /**
     * @author Luis Navarro - Grupo Satélite
     * @since  2018-09-10
     * @return Subir anexo al servidor
     */
    public function subir_anexo($carpeta)
    {
        // $carpeta = str_replace("-", "/", $carpeta);
        $ruta = FCPATH . "uploads/" . $carpeta;
        if (!file_exists($ruta)) {
            mkdir($ruta, 0777);
        }
        $obj = &get_instance();
        $config['upload_path'] = $ruta;
        $config['allowed_types'] = 'pdf|doc|docx|xls|xlsx|jpg|jpeg|png';
        $config['max_size'] = 4001;

        // $config['allowed_types'] = 'pdf|jpg|png|jpeg|doc|xls|docx|xlsx';
        $obj->load->library('upload', $config);
        if (!$obj->upload->do_upload()) {
            $error = array('error' => $obj->upload->display_errors());
            return true;
        } else {
            $data = array('upload_data' => $obj->upload->data());
            return $data;
        }
        print_r($data);
    }

    /**
     * @author Edith Herrera
     * @since 2018-03-12
     * @return
     **/
    function seguimiento_bd($id_drn, $cart_seg = null){
        if ($id_drn <= 0) {
            die('Error!');
        }
        $registro = $this->gsatelite->get_tabla('drn_directorio_contacto', array('drn_id' => $id_drn));
        $data['info'] = $info = $registro[0];
        // die(var_dump($info));
        $crud = new grocery_CRUD();
        $crud->set_table('sgd_seguimiento_directorio')
            ->set_subject('Seguimiento')
            ->columns('sgd_id_tsg', 'sgd_id_usu_seguimiento', 'sgd_fecha', 'sgd_fecha_proximo', 'sgd_comentario')
            ->add_fields(
                'sgd_id_tsg',
                'sgd_id_drn',
                'sgd_id_usu_seguimiento',
                'sgd_fecha',
                'sgd_fecha_proximo',
                'sgd_contacto',
                'sgd_comentario',
                'sgd_lugar',
                'sgd_invitados',
                'sgd_estado',
                'sgd_usu_creacion',
                'sgd_fecha_creacion',
                'sgd_usu_modificacion',
                'sgd_fecha_modificacion'
            )
            ->edit_fields(
                'sgd_id_tsg',
                'sgd_id_usu_seguimiento',
                'sgd_fecha_proximo',
                'sgd_contacto',
                'sgd_comentario',
                'sgd_lugar',
                'sgd_invitados',
                'sgd_estado',
                'sgd_usu_modificacion', 
                'sgd_fecha_modificacion'
            )
            ->display_as('sgd_id_tsg', 'Tipo Seguimiento')
            ->display_as('sgd_id_usu_seguimiento', 'Ejecutivo asignado')
            ->display_as('sgd_fecha', 'Fecha')
            ->display_as('sgd_contacto', 'Contacto')
            ->display_as('sgd_fecha_proximo', 'Próximo seguimiento')
            ->display_as('sgd_comentario', 'Comentario')
            ->display_as('sgd_lugar', 'Lugar')
            ->display_as('sgd_invitados', 'Asistentes')
            ->display_as('sgd_estado', 'Estado')
            ->where("sgd_id_drn", $id_drn)
            ->required_fields('sgd_fecha_proximo', 'sgd_comentario', 'sgd_estado', 'sgd_id_tsg', 'sgd_contacto')
            ->set_relation('sgd_id_tsg', 'tsg_tipo_seguimiento', 'tsg_nombre')
            ->set_relation('sgd_id_usu_seguimiento', 'users', '{username}')
            ->field_type('sgd_id_drn', 'hidden', $id_drn)
            ->field_type('sgd_fecha', 'hidden', date('Y-m-d H:i:s'))
            ->field_type('sgd_id_usu_seguimiento', 'hidden', $this->tank_auth->get_user_id())
            ->field_type('sgd_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
            ->field_type('sgd_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
            ->field_type('sgd_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
            ->field_type('sgd_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
            ->callback_column('sgd_fecha', function($value, $row) {
                return '<span style="display: none;">' . formatear_fecha('Ymd', $row->sgd_fecha) . '</span>' . formatear_fecha('d-m-Y', $row->sgd_fecha);
            })
            ->callback_column('sgd_fecha_proximo', function($value, $row) {
                return '<span style="display: none;">' . formatear_fecha('Ymd', $row->sgd_fecha_proximo) . '</span>' . formatear_fecha('d-m-Y', $row->sgd_fecha_proximo);
            })
            ->callback_add_field('sgd_fecha_proximo', function () {
                return '<input type="text" id="field-sgd_fecha_proximo" name="sgd_fecha_proximo" autocomplete="off" class="datePicker">';
            })
            ->callback_edit_field('sgd_fecha_proximo', function ($value, $row) {
                return '<input type="text" id="field-sgd_fecha_proximo" name="sgd_fecha_proximo" value="' . formatear_fecha('d-m-Y', $value) . '" class="datePicker" autocomplete="off">';
            })
            ->callback_before_insert(function($post_array){
                $datetime1 = date('Y-m-d');
                $datetime2 = date('Y-m-d', strtotime($post_array['sgd_fecha_proximo']));
                $post_array['sgd_fecha_proximo'] = formatear_fecha('Y-m-d', $post_array['sgd_fecha_proximo']);
                if ($datetime1 <= $datetime2) {
                    return $post_array;
                } else {
                    return FALSE;
                }
            })
            ->callback_before_update(function ($post_array, $primary_key) {
                $datetime1 = date('Y-m-d');
                $datetime2 = date('Y-m-d', strtotime($post_array['sgd_fecha_proximo']));
                $post_array['sgd_fecha_proximo'] = formatear_fecha('Y-m-d', $post_array['sgd_fecha_proximo']);
                if ($datetime1 <= $datetime2) {
                    return $post_array;
                } else {
                    return FALSE;
                }
            })
            ->set_lang_string('insert_error', 'La fecha del próximo seguimiento no puede ser menor a la actual')
            ->set_lang_string('update_error', 'La fecha del próximo seguimiento no puede ser menor a la actual')
        ;
        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('sgd_estado', 'hidden', 1);
        } else {
            $crud->field_type('sgd_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }
        $data['titulo_personal'] = "Seguimiento";
        if (true) {
            $data['modal_cotizaciones'] = false;
        } else {
            $data['modal_cotizaciones'] = true;
        }
        $crud->unset_delete()->unset_export()->unset_print();
        if ($data['modal_cotizaciones'] == true) {
            $crud->unset_add();
            $crud->unset_edit();
        }
        if ($this->input->post()) {
            $alerta['registroProcesado'] = 1;
            $this->session->set_flashdata($alerta);
        }
        $output = $crud->render();
        $this->gsatelite->cargar_vista_masterpage('cotizaciones/cotizaciones/seguimiento_bd', $data, $output);
    }

    public function contactos_masivo()
    {
        satelite_validar();
        if ($this->input->post()) {

            $origen = $this->input->post("slcOrigen");
            $segmento =  $this->input->post("slcSegmento");
            $segmento_cliente =  $this->input->post("segmento_cliente");
            $personeria = $this->input->post("slcPersoneria");
            $etiqueta = $this->input->post("slcEtiquetas");
            $target_dir = "public/temp/archivos/";
            $target_file = $target_dir . basename($_FILES["excelfile"]["name"]);
            move_uploaded_file($_FILES["excelfile"]["tmp_name"], $target_file);
            $cont = 0;

            $this->load->library('excelphp');
            // El archivo a cargar debe tener una extension de hoja de calculo para que no de error la
            // libreria.
            $objExcel = PHPExcel_IOFactory::load($target_file);

            // se obtienen el numero de columnas de la hoja de excel para comprobar si se esta utilizando el formato
            // adecuado
            $columna = $objExcel->getActiveSheet()->getHighestColumn();
            //print_r($columna);die();
            // exit($columna);
            // se evalua si la ultima columna de hoja de excel coincide con la del formato
            // de lo contrario se lanzara una alerta de formato incorrecto
            if ($columna == 'G' || $objExcel->getActiveSheet()->getCell('G1')->getValue() != '') {

                // Se inicializa el contador en el numero de fila donde comienzan los datos  que se quieren
                // extraer luego se utiliza la funcion getCell con la columna y fila de la celda
                for ($i = 2; $i > 1; $i++) {
                    $nombre =  $objExcel->getActiveSheet()->getCell('B' . $i)->getValue();
                    $contacto =  $objExcel->getActiveSheet()->getCell('C' . $i)->getValue();
                    $telefono =  $objExcel->getActiveSheet()->getCell('D' . $i)->getValue();
                    $cargo =  $objExcel->getActiveSheet()->getCell('E' . $i)->getValue();
                    $direccion =  $objExcel->getActiveSheet()->getCell('F' . $i)->getValue();
                    $email =  $objExcel->getActiveSheet()->getCell('G' . $i)->getValue();

                    // Condicion para salir del ciclo For cuando ya no se encuentren datos
                    // en el documento.
                    if ($nombre == "") {
                        break;
                    }
                    $base_array = array(
                        'drn_id_ogc' => $origen,
                        'drn_id_sec' => $segmento, //Le llaman asi al sector
                        'drn_id_cac' => $segmento_cliente, //Se le llama asi a la cartera
                        'drn_personeria' => $personeria,
                        'drn_nombre' => $nombre,
                        'drn_contacto' => $contacto,
                        'drn_cargo' => $cargo,
                        'drn_telefono' => $telefono,
                        'drn_email' => $email,
                        'drn_direccion' => $direccion,
                    );
                    $contactos[$i] = $base_array;
                    $cont++;
                }
            } else {
                unlink($target_file);
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Contactos Masivos", 'texto_alerta' => "El formato cargado es invalido");
                $this->session->set_flashdata($alerta);
                redirect('cotizaciones/cotizaciones/contactos_masivo');
            }
            unlink($target_file);
            $data['excel'] = $contactos;
            $data['personeria'] = $personeria;
            $data['origen'] = $this->gsatelite->get_dropdown('ogc_origen_contacto', 'ogc_nombre', 'origen', array('ogc_estado' => 1), $origen, null, null, true);
            $data['segmento_cliente'] = $this->gsatelite->get_dropdown('cac_cartera_cliente', 'cac_nombre', 'segmento_cliente', array('cac_estado' => 1), $segmento_cliente, null, null, true);
            $data['sector'] = $this->gsatelite->get_dropdown('sec_sector_cliente', 'sec_nombre', 'sectores', array('sec_estado' => 1), $segmento, null, null, true);
            $data['etiquetas'] = $this->gsatelite->get_dropdown('etq_etiqueta', 'etq_nombre', 'etiquetas', array('etq_estado' => 1), $etiqueta, null, null, true);
            //die('sadasdasd');
        } else {
            $selected = $this->gsatelite->get_dropdown('cac_cartera_cliente', 'cac_nombre', 'segmento_cliente', array('cac_estado' => 1), null, null, null, true);
            $data['segmento_cliente'] = str_replace('<option value="0">Seleccione</option>', '<option></option>', $selected);
            //die('asdasda');

            $data['origen'] = $this->gsatelite->get_dropdown('ogc_origen_contacto', 'ogc_nombre', 'origen', array('ogc_estado' => 1), null, null, null, true);
            $data['sector'] = $this->gsatelite->get_dropdown('sec_sector_cliente', 'sec_nombre', 'sectores', array('sec_estado' => 1), null, null, null, true);
            $data['etiquetas'] = $this->gsatelite->get_dropdown('etq_etiqueta', 'etq_nombre', 'etiquetas', array('etq_estado' => 1), null, null, null, true);
        }

        $data['titulo_personal'] = "Carga de Contactos Masiva";
        $this->_cargarvista($data);
    }

    public function guardar_contactos_masivo()
    {
        satelite_validar();
        //  var_dump($this->input->post());die();
        $origen = $this->input->post("origen");
        $sector =  $this->input->post("seg");
        $segmento_cliente =  $this->input->post("segmento_cliente_hidden");
        $personeria = $this->input->post("perso");
        $nombres =  $this->input->post("nombre");
        $contacto =  $this->input->post("contacto");
        $telefono =  $this->input->post("telefono");
        $cargo =  $this->input->post("cargo");
        $direccion =  $this->input->post("direccion");
        $email =  $this->input->post("email");
        $etq = $this->input->post("etiqueta");
        $etiqueta = explode(',', $etq);

        $i = 0;
        foreach ($nombres as $nombre) {
            $base_array = array(
                'drn_id_ogc' => $origen,
                'drn_id_sec' => $sector, //Este es el sector del cliente
                'drn_id_cac' => $segmento_cliente, //A la cartera de clientes se le llama segmento de cliente
                'drn_personeria' => $personeria,
                'drn_nombre' => $nombre,
                'drn_contacto' => $contacto[$i],
                'drn_cargo' => $cargo[$i],
                'drn_telefono' => $telefono[$i],
                'drn_email' => $email[$i],
                'drn_direccion' => $direccion[$i],
                'drn_estado' => 1,
                'drn_usu_creacion' => $this->tank_auth->get_user_id(),
                'drn_fecha_creacion' => date('Y-m-d H:i:s'),
                'drn_usu_modificacion' => $this->tank_auth->get_user_id(),
                'drn_fecha_modificacion' => date('Y-m-d H:i:s')
            );

            $drn_id = $this->gsatelite->ingresar('drn_directorio_contacto', $base_array);
            if (count($etiqueta) > 0) {

                for ($j = 0; $j < count($etiqueta); $j++) {
                    $etiqueta_array = array(
                        'exc_id_drn' => $drn_id,
                        'exc_id_etq' => $etiqueta[$j],
                        'exc_estado' => 1,
                        'exc_usu_creacion' => $this->tank_auth->get_user_id(),
                        'exc_fecha_creacion' => date('Y-m-d H:i:s'),
                        'exc_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'exc_fecha_modificacion' => date('Y-m-d H:i:s')
                    );

                    $this->gsatelite->ingresar('exc_etiquetaxcontacto', $etiqueta_array);
                }
            }
            $i++;
        }
        $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Contactos Masivos", 'texto_alerta' => "Se procesaron " . $i . " contactos correctamente.");
        $this->session->set_flashdata($alerta);
        redirect('cotizaciones/cotizaciones/contactos_masivo');
    }

    // funcion para actualizar campo de verificacion de cotizaciones pendientes
    //Rafael Cuchilla 01/10/2018
    public function actualizar_cot_pendientes()
    {
        $where['id'] = $this->tank_auth->get_user_id();
        $where["cot_fecha_revisado"] = date('Y-m-d');
        $ids_cot = $this->cotModel->id_cot_pendientes($where);

        if (count($ids_cot) > 0) {
            foreach ($ids_cot as $key) {
                $act_cot = array(
                    'cot_fecha_revisado'     => date('Y-m-d H:i:s'),
                    'cot_usu_modificacion'   => $this->tank_auth->get_user_id(),
                    'cot_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                $this->gsatelite->actualizar_array('cot_cotizacion', $act_cot, array('cot_id' => $key['cot_id']));
            }
        }
    }

    /**
     * @author Luis Navarro - Grupo Satélite
     * @since  2018-10-10
     * @return Aprobacion de campanias
     */
    public function aprobacion_campania()
    {
        satelite_validar();
        $permisos         = $this->gsatelite->get_permisos_opcion();
        $data['permisos'] = $permisos;
        if ($this->input->post()) {
            //print_r($_POST);die();
            // Declaracion de variables
            $where = array();
            $html = '';
            $estado_campana = (is_numeric($this->input->post('estado'))) ? $this->input->post('estado') : '';
            if (is_numeric($estado_campana)) {
                $where['cam_estado'] = $estado_campana;
            }
            $data['campanas'] = $this->gsatelite->get_tabla('cam_campania', $where);
            $html = $this->load->view('cotizaciones/cotizaciones/detalle_aprobacion_campania', $data, true);

            echo $html;
            die();
        } else {

            // $html = $this->load->view('registro_academico/procesos/detalle_horarios_supervisor', $data, true);
            $data['titulo_personal'] = "Autorización de Campaña";
            $this->_cargarvista($data);
        }
    }

    /**
     * @author Luis Navarro - Grupo Satélite
     * @since  2018-10-11
     * @return Aprobacion de campanias
     */
    public function estado_aprobacion_campania($id = null, $ver = null)
    {
        satelite_validar();
        if ($this->input->post()) {

            // print_r($_POST);die();
            // Declaracion de variables
            $observaciones = $this->input->post('campana_observacion');
            $estado        = $this->input->post('campana_estado');
            $id_registro   = ($id > 0) ? $id : die('No se ha seleccionado ningun id para procesar la aprobacion');
            if ($estado == 1) {
                $actualizar_cam = array(
                    'cam_id_usu_autoriza'       => $this->tank_auth->get_user_id(),
                    'cam_fecha_autorizacion'    => date('Y-m-d H:i:s'),
                    'cam_observacion_autorizacion' => $observaciones,
                    'cam_estado' => 2,
                    'cam_usu_modificacion'      => $this->tank_auth->get_user_id(),
                    'cam_fecha_modificacion'    => date('Y-m-d H:i:s')
                );
                $registro = $this->gsatelite->actualizar_array('cam_campania', $actualizar_cam, array('cam_id' => $id_registro));
            } else if ($estado == 0) {
                $actualizar_cam = array(
                    'cam_id_usu_anula'          => $this->tank_auth->get_user_id(),
                    'cam_fecha_anulacion'       => date('Y-m-d H:i:s'),
                    'cam_observacion_anulacion' => $observaciones,
                    'cam_estado'                => 0,
                    'cam_usu_modificacion'      => $this->tank_auth->get_user_id(),
                    'cam_fecha_modificacion'    => date('Y-m-d H:i:s')
                );
                $registro = $this->gsatelite->actualizar_array('cam_campania', $actualizar_cam, array('cam_id' => $id_registro));
            } else {
                die("No se ha seleccionado ningun estado para la campaña");
                redirect('');
            }
            $titulo = ($estado == 1) ? 'Aprobado' : 'Rechazado';
            // $this->session->set_flashdata($alerta);
            $this->session->set_flashdata('registro', $registro);
            $this->session->set_flashdata('titulo', $titulo);
            redirect('cotizaciones/cotizaciones/estado_aprobacion_campania');
        } else {
            // Cargar datos para editar
            $data['id'] = $id;
            $data['ver'] = ($ver > 0) ? 1 : 0;
            $data['autorizacion'] = ($ver == 2) ? 1 : 0;
            $data['campana'] = $this->gsatelite->get_tabla('cam_campania', array('cam_id' => $id));
            $data['det_campana'] = $this->cotModel->get_contactos_x_campana(array('cnc_id_cam' => $id));

            // Procesar el tipo de imagen 
            $nombre_archivo = explode("/", $data['campana'][0]['cam_url']);
            if (isset($nombre_archivo[2]) && $nombre_archivo[2] != "") {
                $extension_imagen = '';
                $es_imagen = 0;
                $es_pdf    = 0;
                $ext_data         = explode(".", $nombre_archivo[2]);
                switch (strtolower(trim($ext_data[1]))) {
                    case 'docx':
                        $extension_imagen = 'docx';
                        break;
                    case 'doc':
                        $extension_imagen = 'doc';
                        break;
                    case 'pdf':
                        $extension_imagen = 'pdf';
                        $es_pdf = 1;
                        break;
                    case 'xlsx':
                        $extension_imagen = 'xlsx';
                        break;
                    case 'xls':
                        $extension_imagen = 'xls';
                        break;
                    case 'txt':
                        $extension_imagen = 'txt';
                        break;
                    case 'rar':
                        $extension_imagen = 'rar';
                        break;
                    case 'png':
                        $extension_imagen = 'png';
                        $es_imagen = 1;
                        break;
                    case 'jpg':
                        $extension_imagen = 'jpg';
                        $es_imagen = 1;
                        break;
                    case 'jpeg':
                        $extension_imagen = 'jpeg';
                        $es_imagen = 1;
                        break;
                    default:
                        $extension_imagen = 'txt';
                        break;
                }
                $data['es_imagen'] = $es_imagen;
                $data['es_pdf']    = $es_pdf;
                $data['extension_imagen'] = $extension_imagen;
            }

            // Datos a mostrar
            $selected = $this->gsatelite->get_dropdown('ogc_origen_contacto', 'ogc_nombre', 'origen', array('ogc_estado' => 1), null, null, null, true);
            $data['origen'] = str_replace('<option value="0">Seleccione</option>', '<option></option>', $selected);

            $selected = $this->gsatelite->get_dropdown('pai_pais', 'pai_nombre', 'paises', array('pai_estado' => 1), null, null, null, true);
            $data['paises'] = str_replace('<option value="0">Seleccione</option>', '<option></option>', $selected);

            $selected = $this->gsatelite->get_dropdown('sec_sector_cliente', 'sec_nombre', 'sectores', array('sec_estado' => 1), null, null, null, true);
            $data['sector'] = str_replace('<option value="0">Seleccione</option>', '<option></option>', $selected);

            $selected = $this->gsatelite->get_dropdown('cac_cartera_cliente', 'cac_nombre', 'cartera', array('cac_estado' => 1), null, null, null, true);
            $data['cartera_cliente'] = str_replace('<option value="0">Seleccione</option>', '<option></option>', $selected);

            $selected = $this->gsatelite->get_dropdown('etq_etiqueta', 'etq_nombre', 'etiquetas', array('etq_estado' => 1), null, null, null, true);
            $data['etiquetas'] = str_replace('<option value="0">Seleccione</option>', '<option></option>', $selected);

            /*  ************************** Codigo para mostrar en la campana ************************  */
            $abre_mes = array(1 => 'EN', 2 => 'FEBR', 3 => 'MZO', 4 => 'ABR', 5 => 'MY', 6 => 'JUN', 7 => 'JUL', 8 => 'AG', 9 => 'SEPT', 10 => 'OCT', 11 => 'NOV', 12 => 'DIC');
            $mes =  $abre_mes[intval(date('m'))];
            $correlativo = $this->gsatelite->count('cam_campania');
            $codigo = $mes . date('Y') . str_pad(($correlativo + 1), 3, "0", STR_PAD_LEFT);
            $data['codigo_automatico']  = $codigo;
            // $html = $this->load->view('registro_academico/procesos/detalle_horarios_supervisor', $data, true);
            $data['titulo_personal'] = "Autorización de Campaña";
            $tcm_medios = $this->cotModel->get_medio();

            $data_tcm_medio = [];
            foreach ($tcm_medios as $key) {
                $data_tcm_medio[$key['cli_id']] = $key['tmc_nombre'];
            }

            $data['tcm_medio_cli'] = $data_tcm_medio;
            $this->gsatelite->cargar_vista_masterpage('cotizaciones/cotizaciones/estado_aprobacion_campania', $data);
        }
    }

    /**
     * @author Luis Navarro - Grupo Satélite
     * @since  2018-10-11
     * @return Enviar correo de la campania
     */
    public function enviar_correo_campania($id = null)
    {
        satelite_validar();
        $id = ($this->input->post('id') > 0) ? $this->input->post('id') : $id;
        if ($id != null) {
            // Obtener los datos de la campaña a enviar el correo a los contactos
            $campania  = $this->gsatelite->get_tabla('cam_campania', array('cam_id' => $id, 'cam_estado' => 2));
            $contactos = $this->cotModel->get_contactos_x_campana(array('cnc_id_cam' => $id), 'drn_id');
            $clientes_id = $contactos[0]['ids_cliente'];
            // Verificar si el estado de campania esta autorizado
            if (!count($campania) > 0) {
                echo json_encode(array('exito' => 0));
            }
            $data =  array();
            $clientes_email  = array();
            $contacto_email  = array();
            $data['campania'] = $campania;
            // Cargar vista con el mensaje  a enviar a los contactos
            $mensaje_html = $this->load->view('cotizaciones/cotizaciones/detalle_correo_campania', $data, true);
            // Obtener los correos de los prospectos
            $prospectos_email = array_filter(array_column($contactos, 'drn_email'));
            // Obtener los correos de los clientes
            $this->db->join('cnc_contactos_campania', 'cli_id = cnc_id_cli');
            $clientes = $this->gsatelite->get_tabla('cli_cliente', array('cnc_id_cam' => $id, 'cli_email !=' => ""));
            if (!empty($clientes)) {
                $clientes_email = array_filter(array_column($clientes, 'cli_email'));
            }
            // Obtener los correos de los contactos
            if ($clientes_id != '') {
                $contactos = $this->gsatelite->get_tabla('con_contacto', array('con_email !=' => "", 'con_id_cli in (' . $clientes_id . ')' => NULL));
                if (!empty($contactos)) {
                    $contacto_email = array_filter(array_column($contactos, 'con_email'));
                }
            }
            // Se unen todos los correos
            $contantos_array = array_merge($prospectos_email, $clientes_email, $contacto_email);
            if (!count($contantos_array) > 0) {
                echo json_encode(array('exito' => 2));
                die();
            }
            // Obtener los datos del Empleado
            $usuario  = $this->tank_auth->get_user_id();
            $this->db->join('emp_empleado', 'id = emp_id_usu');
            $empleado = $this->gsatelite->get_tabla('users', array('id' => $usuario));
            // Definicion de datos para el correo
            $nombre_envia   = $empleado[0]['emp_nombre'] . ' ' . $empleado[0]['emp_apellido'];
            $de             = $empleado[0]['email'];
            $asunto         = $campania[0]['cam_nombre'];
            $url_archivo    = (substr(FCPATH . $campania[0]['cam_url'], -1) != '/') ? FCPATH . $campania[0]['cam_url'] : null;
            // Enviar el correo a los contactos 
            $exito = $this->gsatelite->envio_correo($de, $nombre_envia, $de, $asunto, $mensaje_html, $contantos_array, $url_archivo, TRUE);
            // $exito = $this->gsatelite->envio_correo('rene.castaneda@gruposatelite.net', 'Rene', 'elman.ortiz@gruposatelite.net', 'test', $mensaje_html, null, null,0);
            if ($exito) {
                // echo 'Se ha enviado el correo';
                echo json_encode(array('exito' => 1));
            } else {
                // echo 'No se ha enviado el correo';
                echo json_encode(array('exito' => 0));
            }
        } else {
            die("No se ha seleccionado ninguna Campaña");
        }
    }

    public function get_permisos_padre_cliente()
    {
        satelite_validar(true);
        /*      Obtener permisos para agregar cliente        */
        /* ************************************************** */
        $permisos        = $this->gsatelite->get_permisos_opcion("cotizaciones/mantenimientos/clientes");
        $permite_agregar = (int)$permisos['permite_agregar'];
        /* ************************************************** */

        echo json_encode(array('permiso' => $permite_agregar));
    }

    public function _callback_contacto($value, $row)
    {
        $contacto         = $this->gsatelite->get_tabla('con_contacto', array('con_id_cli' => $row->cli_id));
        $contacto_nombre  = $contacto[0]['con_nombre'] . ' ' . $contacto[0]['con_apellidos'];
        return $contacto_nombre;
    }

    public function _callback_contacto_telefono($value, $row)
    {
        $contacto_telefono = array_shift(array_column($this->gsatelite->get_tabla('con_contacto', array('con_id_cli' => $row->cli_id)), 'con_telefono'));
        return $contacto_telefono;
    }

    public function _callback_contacto_email($value, $row)
    {
        $contacto_email = array_shift(array_column($this->gsatelite->get_tabla('con_contacto', array('con_id_cli' => $row->cli_id)), 'con_email'));
        return $contacto_email;
    }

    public function get_telefono_contacto()
    {
        $idcontacto = $this->input->post('idcontacto');

        $telefono = $this->gsatelite->get_campo('con_contacto', 'con_telefono', array('con_id' => $idcontacto));
        //echo 'hola'; die();
        //print_r($this->db->last_query()); die();
        echo $telefono;
        //return $telefono;
    }

    /**
     * @author Marlon Olmedo - Grupo Satélite
     * @since  2019-06-24
     * @return vista de autorizacion cotizaciones
     */
    public function autorizar_cotizacion($id_cot = null)
    {

        if ($_POST) {
            $post_array            = $this->input->post();
            $fecha_autorizacion    = ($post_array['fchautorizacion'] != '') ? date('Y-m-d', strtotime($post_array['fchautorizacion'])) : null;
            $observaciones         = ($post_array['txaobservacion'] != '') ? $post_array['txaobservacion'] : null;

            $array = array(
                'cot_autorizada' => 1,
                'cot_fecha_autoriza' => $fecha_autorizacion,
                'cot_observacion_autoriza' => $observaciones
            );

            $respuesta = $this->gsatelite->actualizar_array('cot_cotizacion', $array, array('cot_id' => $id_cot));

            if ($respuesta > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Admón Cotizaciones", 'texto_alerta' => "La cotizacion se a autorizado exitosamente.");
                $this->session->set_flashdata($alerta);
                redirect('cotizaciones/cotizaciones/index/');
            }
        }

        $cotizacion = $this->cotModel->get_cotizacion(array('cot_id' => $id_cot));
        foreach ($cotizacion as $key) {
            $data['cot_id']     = $key['cot_id'];
            $data['cot_codigo'] = $key['cot_codigo'];
            $data['cli_nombre'] = $key['cli_nombre'];
            $data['est_nombre'] = $key['est_nombre'];
            $data['id_cli']     = $key['cot_id_cli'];
            $data['id_ven']     = $key['cot_id_ven'];
        }
        $data['titulo_personal'] = 'Autorizar Cotizacion';

        $this->_cargarvista($data);
    }

    /**
     * @author Nelson Soriano
     * @since  2019-06-24
     * @return Correo de seguimiento
     */
    public function enviar_correos_segx()
    {
        $cots       = $this->gsatelite->get_tabla('cot_cotizacion', array('cot_estado' => 1));
        $cots       = array_column($cots, 'cot_id');
        foreach ($cots as $key => $val) {
            $cot_id = $val;
            $this->db->order_by('seg_id', 'DESC');
            $seguimientos  = $this->gsatelite->get_tabla('seg_seguimiento', array('seg_id_cot' => $cot_id));
            $info_cot      = $this->gsatelite->get_tabla('cot_cotizacion', array('cot_id' => $cot_id));
            if (count($seguimientos) > 0) {
                $ultimo = date_format(date_create($seguimientos[0]['seg_fecha_proximo']), 'Y-m-d');
                $ahora  = date('Y-m-d');
                $data['info_coti']     = $info_cot;
                $data['seguimientos']  = $seguimientos;
                $data['cliente']       = $this->gsatelite->get_tabla('cli_cliente', array('cli_id' =>  $data['info_coti'][0]['cot_id_cli']));
                if ($ultimo == $ahora) {
                    $vendedor   = $this->gsatelite->get_tabla('ven_vendedor', array('ven_id' => $info_cot[0]['cot_id_ven']));
                    $email      = $vendedor[0]['ven_email'];
                    $nombre_ven = $vendedor[0]['ven_nombre'] . ' ' . $vendedor[0]['ven_apellidos'];
                    $html  = $this->load->view('cotizaciones/cotizaciones/enviar_correos_segx', $data, true);

                    $ruta_adjunto = '';
                    $asunto       = 'Recordatorio Seguimiento Cotización';
                    $correos_involucrados = $email;
                    if ($email != '') {
                        $envio = $this->gsatelite->envio_correo($email, $nombre_ven, $correos_involucrados, $asunto, $html, $email, $ruta_adjunto);
                    }
                }
            }
        }
    }

    /**
     * @author Raul E
     * @since  SEP-2021
     * @return Gesion ordenes de venta de facturacion
     */
    public function ordenes_venta($fecha_inicio = null, $fecha_fin = null, $tipo = null)
    {
        satelite_validar();
        try {
            $txtcliente = $filEstado = "";
            $fecha_inicio = $fecha_fin = date('d-m-Y');
            $permisos = $this->gsatelite->get_permisos_opcion();
            // SI EL USUARIO NO TIENE EL ROL DE ADMINISTRADOR SOLO PUEDE VER LAS PROPIAS
            $roles_usuario = $this->facturacion_model->get_roles_usuario($this->tank_auth->get_user_id());
            $rol_admit = 0;
            foreach ($roles_usuario as $key => $value) {
                if ($value == 1) {
                    $rol_admit = 1;
                }
            }
            $columns = array(
                'orv_numero_orden',
                'orv_nombre_factura',
                'orv_fecha_orden',
                'orv_id_cli',
                'orv_total',
                'orv_estado'
            );
            $display_as = array(
                'orv_numero_orden'   => 'No. Orden',
                'orv_nombre_factura' => 'Nombre factura',
                'orv_fecha_orden'    => 'Fecha',
                'orv_id_cli'         => 'Cliente',
                'orv_total'          => 'Monto',
                'orv_estado'         => 'Estado'
            );
            if ($_POST) {
                $txtcliente = $this->input->post("txtcliente");
                $filEstado = $this->input->post('filEstado');
                $fecha_inicio = $this->input->post('txtFechaIni');
                $fecha_fin = $this->input->post('txtFechaFin');
            }
            $crud = new grocery_CRUD();
            $crud->set_subject('Orden de Venta');
            $crud->set_table('orv_orden_venta');
            $crud->columns($columns);
            $crud->display_as($display_as);
            $crud->field_type('orv_estado', 'dropdown', array('1' => 'Pendiente de facturar', '2' => 'Facturado',  '3' => 'Anulada'));
            $crud->callback_column('orv_id_cli', function ($value, $row) {
                $cliente_array = $this->gsatelite->get_tabla('cli_cliente', array('cli_id' => $row->orv_id_cli));
                $cliente = $cliente_array[0]["cli_codigo"] . " - ";
                $cliente .= ($cliente_array[0]["cli_personeria"] > 1) ? $cliente_array[0]["cli_apellido"] : $cliente_array[0]["cli_nombre"] . " " . $cliente_array[0]["cli_apellido"];
                return $cliente;
            });
            $crud->callback_column('orv_fecha_orden', function ($value, $row) {
                return formatear_fecha('d-m-Y', trim($row->orv_fecha_orden));
            });
            $crud->callback_column('orv_total', function ($value, $row) {
                return '$' . number_format($row->orv_total, 2);
            });
            if ($fecha_inicio != '' && $fecha_fin != '') {
                $crud->where('DATE(orv_fecha_orden) >= ', formatear_fecha('Y-m-d', $fecha_inicio));
                $crud->where('DATE(orv_fecha_orden) <= ', formatear_fecha('Y-m-d', $fecha_fin));
            }
            if ($filEstado != "") {
                $crud->where('orv_estado', $filEstado);
            }
            if ($txtcliente != "") {
                $crud->where('orv_id_cli', $txtcliente);
            }
            if ($rol_admit < 1) {
                $crud->where('orv_usu_creacion', $this->tank_auth->get_user_id());
            }
            $crud->unset_add();
            $crud->unset_edit();
            $crud->unset_delete();
            $crud->unset_read();
            $crud->unset_print();
            $crud->unset_export();
            if ($permisos["permite_editar"]) {
                $crud->add_action('&nbsp;Editar', '', 'cotizaciones/cotizaciones/editar_orden_venta', 'icomoon-icon-pencil-5 editar', null, '', array('orv_estado' => 'Pendiente de facturar'));
            }
            $crud->add_action('&nbsp;Imprimir', '', 'facturacion/facturar/imprimir_orden_venta', 'icomoon-icon-printer-2 imprimir', null, '');
            // $crud->add_action('&nbsp;Facturar', '', 'facturacion/facturar/crear_factura', 'icomoon-icon-copy-2 facturar', null,'' , array('orv_estado'=>'Pendiente de facturar'));
            // $crud->add_action('&nbsp;Nota envio', '', 'facturacion/facturar/imprimir_nota_envio', 'icomoon-icon-printer-2 imprimir nota_envio_x', null,'', array('orv_estado <>'=>'Anulada'));
            $output = $crud->render();
            $data['estado'] = $filEstado;
            $data['ffin'] = formatear_fecha('d-m-Y', $fecha_fin);
            $data['fini'] = formatear_fecha('d-m-Y', $fecha_inicio);
            $data['cliente'] = ($txtcliente != "") ? $this->gsatelite->get_registro('cli_cliente', array('cli_id' => $txtcliente)) : null;
            $data['permite_add'] = $permisos["permite_agregar"];
            $data['titulo_personal'] = "Orden de Venta";
            // var_dump($data);die();
            $this->_cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    public function agregar_orden_venta()
    {
        satelite_validar();
        $this->load->library('../controllers/facturacion/facturar');
        if ($_POST) {
            $dtg_Norden         = (trim($this->input->post('dtg_Norden')) != "") ? $this->input->post('dtg_Norden') : "";
            $dtg_cliente        = (trim($this->input->post('dtg_cliente')) != "") ? $this->input->post('dtg_cliente') : "";
            $dtg_nombre_factura = (trim($this->input->post('dtg_nombre_factura')) != "") ? $this->input->post('dtg_nombre_factura') : null;
            $dtf_area           = (trim($this->input->post('dtf_area')) != "") ? $this->input->post('dtf_area') : null;
            $personal           = $this->input->post('personal'); //NULL
            $dtg_vendedor       = (trim($this->input->post('dtf_vendedor')) != "") ? $this->input->post('dtf_vendedor') : null;
            $observaciones      = (trim($this->input->post('observaciones')) != "") ? $this->input->post('observaciones') : null;
            $suma_factura_total = (trim($this->input->post('suma_factura_total')) != "") ? $this->input->post('suma_factura_total') : 0;
            $descuentoT_factura_total  = (trim($this->input->post('descuentoT_factura_total')) != "") ? $this->input->post('descuentoT_factura_total') : 0;
            $subtotal_factura_total    = (trim($this->input->post('subtotal_factura_total')) != "") ? $this->input->post('subtotal_factura_total') : 0;
            $impuesto_factura_total    = (trim($this->input->post('impuesto_factura_total')) != "") ? $this->input->post('impuesto_factura_total') : 0;
            $retencion_factura_total   = (trim($this->input->post('retencion_factura_total')) != "") ? $this->input->post('retencion_factura_total') : 0;
            $total_factura_total       = (trim($this->input->post('total_factura_total')) != "") ? $this->input->post('total_factura_total') : 0;
            $total_factura_total_origi = (trim($this->input->post('total_factura_total_origi')) != "") ? $this->input->post('total_factura_total_origi') : 0;
            $orv_condicion_pago        = (trim($this->input->post('slc_cond_pago')) != "") ? $this->input->post('slc_cond_pago') : null;
            $orv_comentario            = (trim($this->input->post('txt_comentarios')) != "") ? $this->input->post('txt_comentarios') : null;
            $orv_aplica_picking        = $this->input->post('hdn_picking');
            $id_anticipo = 0;
            $saldo_restante = 0;
            $fin_anticipo = 0;
            $fin_anticipo_2 = 0;
            $monto_guardar = 0;
            $monto_actualizar = 0;
            $productos_id_moi = array();
            $produtos_cantidad_moi = array();
            $productos_medida_moi = array();
            $alerta = "";
            if ($dtg_Norden != "" && $dtg_cliente != "") {
                if ($total_factura_total < 0) {
                    $total_factura_total = 0;
                }
                $orden_n = intval($this->gsatelite->get_max('orv_orden_venta', 'orv_id')) + 1;
                $orden_array = array(
                    'orv_id_arf' => $dtf_area,
                    'orv_id_cli' => $dtg_cliente,
                    'orv_id_ven' => $dtg_vendedor,
                    'orv_numero_orden' => $orden_n,
                    'orv_fecha_orden' => date('Y-m-d H:i:s'),
                    'orv_nombre_factura' => $dtg_nombre_factura,
                    'orv_total_retencion' => $retencion_factura_total,
                    'orv_subtotal' => $subtotal_factura_total,
                    'orv_descuento' => $descuentoT_factura_total,
                    'orv_impuesto' => $impuesto_factura_total,
                    'orv_total' => convertirFloat($total_factura_total),
                    'orv_observacion' => $observaciones,
                    'orv_condicion_pago' => $orv_condicion_pago,
                    'orv_comentario' => $orv_comentario,
                    'orv_aplica_picking_list' => $orv_aplica_picking,
                    'orv_estado' => 1,
                    'orv_fecha_creacion' => date('Y-m-d H:i:s'),
                    'orv_usu_creacion' => $this->tank_auth->get_user_id(),
                    'orv_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'orv_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                $orv_id = $this->gsatelite->ingresar('orv_orden_venta', $orden_array);
                //Se guarda el personal de la factura
                for ($x = 0; $x < count($personal); $x++) {
                    if (trim($personal[$x]) != "") {
                        //tabla pxf_personalxfactura
                        $detalle_personal = array(
                            'pxo_id_orv' => $orv_id,
                            'pxo_id_emp' => $personal[$x],
                            'pxo_estado' => 1,
                            'pxo_usu_creacion' => $this->tank_auth->get_user_id(),
                            'pxo_fecha_creacion' => date('Y-m-d H:i:s'),
                            'pxo_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'pxo_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('pxo_personalxorden_venta', $detalle_personal);
                    }
                }
                //columna codigo
                $combo_agrupacion = $this->input->post('combo_agrupacion');
                $aplica_descarga = $this->input->post('aplica_descarga'); //array
                $fecha_garantia = $this->input->post('garantia_factura');
                $fecha_text_garantia = $this->input->post('txtgarantia_factura');
                $tip_producto = $this->input->post('tip_producto');
                $productos_factura = $this->input->post('producto_factura'); //array
                $correlativo = $this->input->post('producto_correlativo'); //array
                $medida_factura = $this->input->post('medida_factura'); //array
                $codigo_factura = $this->input->post('codigo_factura'); //array
                //columna descripcion
                $descripcion_factura = $this->input->post('descripcion_factura'); //array
                //columna cantidad
                $cantidad_factura = $this->input->post('cantidad_factura'); //array
                //columna precio
                $precio_factura = $this->input->post('precio_factura'); //array
                //impuesto
                $impuesto_factura = $this->input->post('impuesto_factura'); //array
                $impuesto_por_factura = $this->input->post('impuesto_por_factura'); //array
                $impuesto_array = $this->input->post('impuesto_array'); //array
                $impuesto_por_array = $this->input->post('impuesto_por_array'); //array
                //retencion
                $retencion_factura = $this->input->post('retencion_factura'); //array
                $retencion_por_factura = $this->input->post('retencion_por_factura'); //array
                $retencion_array = $this->input->post('retencion_array'); //array
                $retencion_por_array = $this->input->post('retencion_por_array'); //array
                //descuento
                $descuento_factura = $this->input->post('descuento_factura'); //array
                $descuento_por_factura = $this->input->post('descuento_por_factura'); //array
                //subtotal
                $subtotal_factura = $this->input->post('subtotal_factura'); //array
                //total
                $total_factura = $this->input->post('total_factura'); //array
                $tipo_venta = $this->input->post('tipo_venta'); //array
                $bodega_producto = $this->input->post('bodega_producto'); //array
                //Array costo de venta de producto por detalle
                $dov_costo_venta_por_producto = ($this->input->post('costo_venta_por_producto') != '') ? $this->input->post('costo_venta_por_producto') : null; //array
                //datos de caracteristica
                /*
                  Recorremos las caracteristicas de cada producto, usando su Id para identificar los input relacionados, con los input
                  se obtienen los ids de las caracteristicas asociadas con el producto y con esta obtenemos el valor de la caja usando
                  el id del producto con el id de la caracteristica para guardar la relacion
                */
                $id_tlp_array_post = $this->input->post('id_tipo_lista_precio');
                $precio_sugerido_array = $this->input->post('precio_sugerido_array');
                $tipo = $this->input->post('tipo_caracteristica');
                for ($x = 0; $x < count($productos_factura); $x++) {
                    if (trim($productos_factura[$x]) != "" && trim($cantidad_factura[$x]) != "" && trim($precio_factura[$x]) != "" && trim($descripcion_factura[$x]) != "") {
                        //es el id de la caracteristica que cuenta el producto
                        $idart = (trim($productos_factura[$x]) != "") ? $productos_factura[$x] : null;
                        $idlip_res = $this->inventario_model->get_tipo_lista_precio(array('lip_id_art' => $idart, 'tpn_id_cli' => $dtg_cliente, 'lip_id_tlp' => $id_tlp_array_post[$x]));
                        $idlip = (count($idlip_res) > 0) ? $idlip_res[0]['lip_id'] : null;
                        if ($aplica_descarga[$x] == 1 && $tip_producto[$x] == 0) {
                            if ($combo_agrupacion[$x] == 1) {
                                $combos_articulo_array = $this->input->post('combo_' . $productos_factura[$x] . '_' . $correlativo[$x]);
                                $cantidad_temp_combo = $this->input->post('combo_cantidad_' . $productos_factura[$x] . '_' . $correlativo[$x]);
                                $combos_cantidad_array = $cantidad_factura[$x] * $cantidad_temp_combo;
                                $combos_medida_array = $this->input->post('combo_medida_' . $productos_factura[$x] . '_' . $correlativo[$x]);
                                for ($k = 0; $k < count($combos_articulo_array); $k++) {
                                    $productos_id_moi[] = $combos_articulo_array[$k];
                                    $produtos_cantidad_moi[] = $combos_cantidad_array[$k];
                                    $productos_medida_moi[] = $combos_medida_array[$k];
                                }
                            } else {
                                $productos_id_moi[] = $productos_factura[$x];
                                $produtos_cantidad_moi[] = $cantidad_factura[$x];
                                $productos_medida_moi[] = $medida_factura[$x];
                            }
                        }
                        $fecha_def = null;
                        if (trim($fecha_text_garantia[$x]) != '') {
                            $fecha_def = formatear_fecha('Y-m-d', $fecha_garantia[$x]);
                        }
                        $detalle_factura = array(
                            'dov_id_orv' => $orv_id,
                            'dov_id_art' => (trim($productos_factura[$x]) != "") ? $productos_factura[$x] : null,
                            'dov_id_cva' => (trim($medida_factura[$x]) != "") ? $medida_factura[$x] : null,
                            'dov_id_lip' => $idlip,
                            'dov_id_tpv' => (trim($tipo_venta[$x]) != "") ? $tipo_venta[$x] : null,
                            'dov_id_bod' => (trim($bodega_producto[$x]) != "") ? $bodega_producto[$x] : null,
                            'dov_descripcion' => (trim($descripcion_factura[$x]) != "") ? $descripcion_factura[$x] : null,
                            'dov_cantidad' => (trim($cantidad_factura[$x]) != "") ? $cantidad_factura[$x] : null,
                            'dov_precio' => (trim($precio_factura[$x]) != "") ? $precio_factura[$x] : null,
                            'dov_precio_sugerido_lista' => trim($precio_sugerido_array[$x]) ? $precio_sugerido_array[$x] : null,
                            'dov_porcentaje_retencion' => (trim($retencion_por_factura[$x]) != "") ? $retencion_por_factura[$x] : null,
                            'dov_porcentaje_impuesto' => (trim($impuesto_por_factura[$x]) != "") ? $impuesto_por_factura[$x] : null,
                            'dov_porcentaje_descuento' => (trim($descuento_por_factura[$x]) != "") ? $descuento_por_factura[$x] : null,
                            'dov_retencion' => (trim($retencion_factura[$x]) != "") ? $retencion_factura[$x] : null,
                            'dov_descuento' => (trim($descuento_factura[$x]) != "") ? $descuento_factura[$x] : null,
                            'dov_impuesto' => (trim($impuesto_factura[$x]) != "") ? $impuesto_factura[$x] : null,
                            'dov_subtotal' => (trim($subtotal_factura[$x]) != "") ? $subtotal_factura[$x] : null,
                            'dov_combo' => (trim($combo_agrupacion[$x]) != "") ? $combo_agrupacion[$x] : null,
                            'dov_precio_inventario' => $dov_costo_venta_por_producto[$x],
                            'dov_estado' => 1,
                            'dov_usu_creacion' => $this->tank_auth->get_user_id(),
                            'dov_fecha_creacion' => date('Y-m-d H:i:s'),
                            'dov_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'dov_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $dov_id = $this->gsatelite->ingresar('dov_detalle_orden_venta', $detalle_factura);
                        //separamos el impuesto de cada producto total y porcentual para almacenarlo en la tabla para el detalle de cada impuesto
                        $impuesto_ids = explode(",", $impuesto_array[$x]);
                        $impuesto_por = explode(",", $impuesto_por_array[$x]);
                        for ($k = 0; $k < count($impuesto_ids); $k++) {
                            if ($impuesto_ids[$k] != 0) {
                                if (trim($impuesto_por[$k]) != "") {
                                    //hacemos el calculo de el monto aplicado para ese impuesto especifico
                                    $monto_temp = $subtotal_factura[$x] * ($impuesto_por[$k] / 100);
                                    //tabla ixf_impuestoxfactura
                                    $detalle_impuesto = array(
                                        'ixv_id_dov' => $dov_id,
                                        'ixv_id_imp' => (trim($impuesto_ids[$k]) != "") ? $impuesto_ids[$k] : null,
                                        'ixv_monto' => $monto_temp,
                                        'ixv_porcentaje' => $impuesto_por[$k],
                                        'ixv_estado' => 1,
                                        'ixv_usu_modificacion' => $this->tank_auth->get_user_id(),
                                        'ixv_fecha_modificacion' => date('Y-m-d H:i:s'),
                                        'ixv_fecha_creacion' => date('Y-m-d H:i:s'),
                                        'ixv_usu_creacion' => $this->tank_auth->get_user_id()
                                    );
                                    $this->gsatelite->ingresar('ixv_impuestoxorden_venta', $detalle_impuesto);
                                }
                            }
                        }
                        $retencion_ids = explode(",", $retencion_array[$x]);
                        $retencion_por = explode(",", $retencion_por_array[$x]);
                        for ($k = 0; $k < count($retencion_ids); $k++) {
                            if ($retencion_ids[$k] != 0) {
                                if (trim($retencion_por[$k]) != "") {
                                    $monto_temp = $subtotal_factura[$x] * ($retencion_por[$k] / 100);
                                    //tabla rxf_retencionxdetalle_factura
                                    $detalle_retencion = array(
                                        'rxv_id_dov' => $dov_id,
                                        'rxv_id_ret' => (trim($retencion_ids[$k]) != "") ? $retencion_ids[$k] : null,
                                        'rxv_monto' => $monto_temp,
                                        'rxv_porcentaje' => $retencion_por[$k],
                                        'rxv_estado' => 1,
                                        'rxv_usu_creacion' => $this->tank_auth->get_user_id(),
                                        'rxv_fecha_creacion' => date('Y-m-d H:i:s'),
                                        'rxv_usu_modificacion' => $this->tank_auth->get_user_id(),
                                        'rxv_fecha_modificacion' => date('Y-m-d H:i:s')
                                    );
                                    $this->gsatelite->ingresar('rxv_retencionxorden_venta', $detalle_retencion);
                                }
                            }
                        }
                        /* === COMPONENTES ======*/
                        $identificador = '_' . $productos_factura[$x] . '_' . $correlativo[$x];
                        /* para descargar de bodega             type array*/
                        /* detalle para guardar                 type array*/
                        $producto_componente = ($this->input->post('producto_componente' . $identificador) != '') ? $this->input->post('producto_componente' . $identificador) : '';
                        $medida_componente = $this->input->post('medida_componente' . $identificador);
                        $cantidad_componente = $this->input->post('cantidad_conv_componente' . $identificador);
                        $precio_componente = $this->input->post('precio_componente' . $identificador);
                        $subtotal_componente = $this->input->post('subtotal_componente' . $identificador);
                        $descripcion_componente = $this->input->post('descripcion_componente' . $identificador);
                        $alternar_componente = $this->input->post('alternar_componente' . $identificador);
                        $mostrar_descripcion_componete = $this->input->post('showdesc_componente' . $identificador);
                        $fecha_creacion = date('Y-m-d H:i:s');
                        $componente_sav = array();
                        if ($producto_componente != '') {
                            foreach ($producto_componente as $id_comp => $comp) {
                                $componente_sav[] = array(
                                    'cdv_id_dov' => $dov_id,
                                    'cdv_id_cva' => $medida_componente[$id_comp],
                                    'cdv_descripcion' => $descripcion_componente[$id_comp],
                                    'cdv_cantidad' => $cantidad_componente[$id_comp],
                                    'cdv_precio' => $precio_componente[$id_comp],
                                    'cdv_subtotal' => $subtotal_componente[$id_comp],
                                    'cdv_total' => $subtotal_componente[$id_comp],
                                    'cdv_altera_precio' => $alternar_componente[$id_comp],
                                    'cdv_muestra_descripcion' => $mostrar_descripcion_componete[$id_comp],
                                    'cdv_estado' => 1,
                                    'cdv_usu_creacion' => $this->tank_auth->get_user_id(),
                                    'cdv_fecha_creacion' =>  $fecha_creacion,
                                    'cdv_usu_modificacion' => $this->tank_auth->get_user_id(),
                                    'cdv_fecha_modificacion' =>  $fecha_creacion
                                );
                            }
                            $this->gsatelite->ingresar('cdv_componente_detallexorden_venta', $componente_sav, true);
                        }
                        /* ========= FIN COMPONENTES =================*/
                        /* ========= CENTRO COSTO  ===================*/
                        $centro_costo_costo = ($this->input->post('centro_costo_costo' . $identificador) != '') ? $this->input->post('centro_costo_costo' . $identificador) : '';
                        $tipo_cuenta_costo = $this->input->post('tipo_cuenta_costo' . $identificador);
                        $cuenta_contable_costo = $this->input->post('cuenta_contable_costo' . $identificador);
                        $porcentaje_costo = $this->input->post('porcentaje_costo' . $identificador);
                        $subtotal_costo = $this->input->post('subtotal_costo' . $identificador);
                        $pais_costo = $this->input->post('pais' . $identificador);
                        $costo_sav = array();
                        if ($centro_costo_costo != '') {
                            foreach ($centro_costo_costo as $id_cost => $costo) {
                                $costo_sav[] = array(
                                    'dcv_id_dov' => $dov_id,
                                    'dcv_id_cec' => $centro_costo_costo[$id_cost],
                                    'dcv_id_tcn' => $tipo_cuenta_costo[$id_cost],
                                    'dcv_id_cnt' => $cuenta_contable_costo[$id_cost],
                                    'dcv_id_pai' => ($pais_costo[$id_cost] != "") ? $pais_costo[$id_cost] : null,
                                    'dcv_porcentaje' => $porcentaje_costo[$id_cost],
                                    'dcv_monto' => $subtotal_costo[$id_cost],
                                    'dcv_estado' => 1,
                                    'dcv_usu_creacion' => $this->tank_auth->get_user_id(),
                                    'dcv_fecha_creacion' =>  $fecha_creacion,
                                    'dcv_usu_modificacion' => $this->tank_auth->get_user_id(),
                                    'dcv_fecha_modificacion' =>  $fecha_creacion
                                );
                            }
                            $this->gsatelite->ingresar('dcv_detalle_centrocostoxorden_venta', $costo_sav, true);
                        }
                    }
                }
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro de factura", 'texto_alerta' => "El registro se guardó correctamente.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro de factura", 'texto_alerta' => "El registro no se guardó, revise la información a ingresar.");
            }
            $redireccion = $this->input->post('redireccionar');
            $this->session->set_flashdata($alerta);
            if ($redireccion == 0) {
                redirect('cotizaciones/cotizaciones/agregar_orden_venta');
            } else if ($redireccion == 1) {
                redirect('cotizaciones/cotizaciones/ordenes_venta');
            } else {
                $this->session->set_flashdata('id_orden', $orv_id);
                redirect('cotizaciones/cotizaciones/agregar_orden_venta');
            }
        }
        $select = $select_bod = "";
        $tip_venta_reg = $this->gsatelite->get_tabla('tpv_tipo_venta', array('tpv_estado' => 1, 'tpv_aplica_venta' => 1));
        $bodegas_reg = $this->facturacion_model->bodegas_cliente(array('uxb_id_usu' => $this->tank_auth->get_user_id()));
        foreach ($tip_venta_reg as $key) {
            $select .= '<option value="' . $key['tpv_id'] . '" abrv="' . $key['tpv_abreviacion'] . '">' . $key['tpv_nombre'] . '-' . $key['tpv_abreviacion'] . '</option>';
        }
        foreach ($bodegas_reg as $key) {
            $selected = ($key['uxb_defecto'] == 1) ? 'selected' : '';
            $select_bod .= '<option value="' . $key['bod_id'] . '" ' . $selected . '>' . $key['bod_nombre'] . '</option>';
        }
        $tpg_contado = $this->gsatelite->get_parametro('SYS_CONFIGURACION_CORTE_CAJA', null, null, array('CONTADO'));
        $tpg_credito = $this->gsatelite->get_parametro('SYS_CONFIGURACION_CORTE_CAJA', null, null, array('CREDITO'));
        $data["tpg_contado"] = ($tpg_contado) ? $tpg_contado : 0;
        $data["tpg_credito"] = ($tpg_credito) ? $tpg_credito : 0;
        $data["descarga_inv"] = $this->gsatelite->get_parametro('SYS_DESCARGA_INV');
        $vendedor_reg = $this->facturacion_model->obtener_usuarios_rol(array('rol_id' => 5, 'id' => $this->tank_auth->get_user_id()));
        $arf_dfcto = $this->gsatelite->get_campo('arf_area_factura', 'arf_id', array('arf_defecto' => 1, 'arf_estado' => 1));
        $area_drop = $this->gsatelite->get_dropdown('arf_area_factura', '{arf_nombre}', '', array('arf_estado' => '1'), $arf_dfcto, '', 'arf_id', true);
        $empleados_select = $this->gsatelite->get_dropdown('emp_empleado', '{emp_codigo} - {emp_nombre} {emp_apellido}', '', array('emp_estado' => '1'), null, '', 'emp_id', true);
        $vendedores_select = $this->gsatelite->get_dropdown('ven_vendedor', '{ven_codigo} - {ven_nombre} {ven_apellidos}', '', array('ven_estado' => '1'), (count($vendedor_reg) > 0 ? $vendedor_reg[0]['ven_id'] : null), '', 'ven_id', true);
        $data['vendedor_reg'] = (count($vendedor_reg) > 0) ? 1 : 0;
        $data['vendedor_defecto']  = $vendedor_reg[0]['ven_id'];
        $data["titulo_personal"] = "Agregar Orden de Venta";
        $data["tipo_venta"] = $select;
        $data["numero_orden"] = intval($this->gsatelite->get_max('orv_orden_venta', 'orv_id')) + 1;
        $data["area"] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $area_drop);
        $data["cliente"] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $clientes);
        $data["empleados"] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $empleados_select);
        $data["vendedores"] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $vendedores_select);
        $cliente_defecto = $this->gsatelite->get_parametro('SYS_CLIENTE_DEFECTO');
        $data["cliente_defecto"] = ($cliente_defecto > 0) ? $cliente_defecto : '';
        $data["cliente_defecto_name"] = ($cliente_defecto > 0) ? $this->facturar->get_nombre_cliente($cliente_defecto) : '';
        $data['decimales'] = $this->gsatelite->get_parametro('NUMERO_DECIMALES', 2);
        $data["bodega_prefe"] = $select_bod;
        $data["activar_alerta_productox"] = $this->gsatelite->get_parametro('SYS_NOTIFICACION_EXISTENCIAX');
        $data['permite_mas_productos'] = $this->gsatelite->get_parametro('SYS_PERMITE_DUPLICAR_PRODUCTO', 0);
        $data["categorias"] = $this->facturar->obtener_categoriaxbodega2();
        $this->_cargarvista($data, null);
    }

    public function editar_orden_venta($id)
    {
        satelite_validar();
        $this->load->library('../controllers/facturacion/facturar');
        if ($_POST) {
            // var_dump($_POST);die();
            $dtg_Norden = (trim($this->input->post('dtg_Norden')) != "") ? $this->input->post('dtg_Norden') : null;
            $dtg_cliente = (trim($this->input->post('dtg_cliente')) != "") ? $this->input->post('dtg_cliente') : null;
            $dtg_nombre_factura = (trim($this->input->post('dtg_nombre_factura')) != "") ? $this->input->post('dtg_nombre_factura') : null;
            $dtf_area = (trim($this->input->post('dtf_area')) != "") ? $this->input->post('dtf_area') : null;
            $personal = $this->input->post('personal');
            $dtg_vendedor = (trim($this->input->post('dtf_vendedor')) != "") ? $this->input->post('dtf_vendedor') : null;
            $observaciones = (trim($this->input->post('observaciones')) != "") ? $this->input->post('observaciones') : null;
            $suma_factura_total = (trim($this->input->post('suma_factura_total')) != "") ? $this->input->post('suma_factura_total') : 0;
            $descuentoT_factura_total = (trim($this->input->post('descuentoT_factura_total')) != "") ? $this->input->post('descuentoT_factura_total') : 0;
            $subtotal_factura_total = (trim($this->input->post('subtotal_factura_total')) != "") ? $this->input->post('subtotal_factura_total') : 0;
            $impuesto_factura_total = (trim($this->input->post('impuesto_factura_total')) != "") ? $this->input->post('impuesto_factura_total') : 0;
            $retencion_factura_total = (trim($this->input->post('retencion_factura_total')) != "") ? $this->input->post('retencion_factura_total') : 0;
            $total_factura_total = (trim($this->input->post('total_factura_total')) != "") ? $this->input->post('total_factura_total') : 0;
            $total_factura_total_origi = (trim($this->input->post('total_factura_total_origi')) != "") ? $this->input->post('total_factura_total_origi') : 0;
            $orv_condicion_pago        = (trim($this->input->post('slc_cond_pago')) != "") ? $this->input->post('slc_cond_pago') : null;
            $orv_comentario            = (trim($this->input->post('txt_comentarios')) != "") ? $this->input->post('txt_comentarios') : null;
            $id_anticipo = 0;
            $saldo_restante = 0;
            $fin_anticipo = 0;
            $fin_anticipo_2 = 0;
            $monto_guardar = 0;
            $monto_actualizar = 0;
            $productos_id_moi = array();
            $produtos_cantidad_moi = array();
            $productos_medida_moi = array();
            $alerta = "";
            if ($dtg_Norden != "" && $dtg_cliente != "") {
                if ($total_factura_total < 0) {
                    $total_factura_total = 0;
                }
                $orden_array = array(
                    'orv_id_arf' => $dtf_area,
                    'orv_id_cli' => $dtg_cliente,
                    'orv_id_ven' => $dtg_vendedor,
                    'orv_nombre_factura' => $dtg_nombre_factura,
                    'orv_total_retencion' => $retencion_factura_total,
                    'orv_subtotal' => $subtotal_factura_total,
                    'orv_descuento' => $descuentoT_factura_total,
                    'orv_impuesto' => $impuesto_factura_total,
                    'orv_condicion_pago' => $orv_condicion_pago,
                    'orv_comentario' => $orv_comentario,
                    'orv_total' => convertirFloat($total_factura_total),
                    'orv_observacion' => $observaciones,
                    'orv_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'orv_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                $this->gsatelite->actualizar_array('orv_orden_venta', $orden_array, array('orv_id' => $id));
                //Se guarda el personal de la factura
                $this->gsatelite->borrado_general("pxo_personalxorden_venta", array('pxo_id_orv' => $id));
                for ($x = 0; $x < count($personal); $x++) {
                    if (trim($personal[$x]) != "") {
                        //tabla pxo_personalxorden_venta
                        $detalle_personal = array(
                            'pxo_id_orv' => $id,
                            'pxo_id_emp' => $personal[$x],
                            'pxo_estado' => 1,
                            'pxo_usu_creacion' => $this->tank_auth->get_user_id(),
                            'pxo_fecha_creacion' => date('Y-m-d H:i:s'),
                            'pxo_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'pxo_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('pxo_personalxorden_venta', $detalle_personal);
                    }
                }
                //columna codigo
                $dov_id_grid = $this->input->post('dov_id');
                $combo_agrupacion = $this->input->post('combo_agrupacion');
                $aplica_descarga = $this->input->post('aplica_descarga'); //array
                $fecha_garantia = $this->input->post('garantia_factura');
                $fecha_text_garantia = $this->input->post('txtgarantia_factura');
                $tip_producto = $this->input->post('tip_producto');
                $productos_factura = $this->input->post('producto_factura'); //array
                $correlativo = $this->input->post('producto_correlativo'); //array
                $medida_factura = $this->input->post('medida_factura'); //array
                $codigo_factura = $this->input->post('codigo_factura'); //array
                //columna descripcion
                $descripcion_factura = $this->input->post('descripcion_factura'); //array
                //columna cantidad
                $cantidad_factura = $this->input->post('cantidad_factura'); //array
                //columna precio
                $precio_factura = $this->input->post('precio_factura'); //array
                //impuesto
                $impuesto_factura = $this->input->post('impuesto_factura'); //array
                $impuesto_por_factura = $this->input->post('impuesto_por_factura'); //array
                $impuesto_array = $this->input->post('impuesto_array'); //array
                $impuesto_por_array = $this->input->post('impuesto_por_array'); //array
                //retencion
                $retencion_factura = $this->input->post('retencion_factura'); //array
                $retencion_por_factura = $this->input->post('retencion_por_factura'); //array
                $retencion_array = $this->input->post('retencion_array'); //array
                $retencion_por_array = $this->input->post('retencion_por_array'); //array
                //descuento
                $descuento_factura = $this->input->post('descuento_factura'); //array
                $descuento_por_factura = $this->input->post('descuento_por_factura'); //array
                //subtotal
                $subtotal_factura = $this->input->post('subtotal_factura'); //array
                //total
                $total_factura = $this->input->post('total_factura'); //array
                $tipo_venta = $this->input->post('tipo_venta'); //array
                //datos de caracteristica
                /*Recorremos las caracteristicas de cada producto, usando su Id para identificar los input relacionados, con los input
                  se obtienen los ids de las caracteristicas asociadas con el producto y con esta obtenemos el valor de la caja usando
                  el id del producto con el id de la caracteristica para guardar la relacion*/
                $id_tlp_array_post = $this->input->post('id_tipo_lista_precio');
                $precio_sugerido_array = $this->input->post('precio_sugerido_array');
                $dov_array = $this->gsatelite->get_tabla('dov_detalle_orden_venta', array('dov_id_orv' => $id));
                foreach ($dov_array as $key3) {
                    if (!in_array($key3['dov_id'], $dov_id_grid)) {
                        $this->gsatelite->borrado_general("ixv_impuestoxorden_venta", array('ixv_id_dov' => $key3['dov_id']));
                        $this->gsatelite->borrado_general("rxv_retencionxorden_venta", array('rxv_id_dov' => $key3['dov_id']));
                        $this->gsatelite->borrado_general('cdv_componente_detallexorden_venta', array('cdv_id_dov' => $key3['dov_id']));
                        $this->gsatelite->borrado_general('dcv_detalle_centrocostoxorden_venta', array('dcv_id_dov' => $key3['dov_id']));
                        $this->gsatelite->borrado_general("dov_detalle_orden_venta", array('dov_id' => $key3['dov_id']));
                    }
                }
                for ($x = 0; $x < count($productos_factura); $x++) {
                    if (trim($productos_factura[$x]) != "" && trim($cantidad_factura[$x]) != "" && trim($precio_factura[$x]) != "" && trim($descripcion_factura[$x]) != "") {
                        //es el id de la caracteristica que cuenta el producto
                        $idart = (trim($productos_factura[$x]) != "") ? $productos_factura[$x] : null;
                        $idlip_res = $this->inventario_model->get_tipo_lista_precio(array('lip_id_art' => $idart, 'tpn_id_cli' => $dtg_cliente, 'lip_id_tlp' => $id_tlp_array_post[$x]));
                        $idlip = (count($idlip_res) > 0) ? $idlip_res[0]['lip_id'] : null;
                        if (trim($dov_id_grid[$x]) != '') {
                            $detalle_factura = array(
                                'dov_id_orv' => $id,
                                'dov_id_cva' => (trim($medida_factura[$x]) != "") ? $medida_factura[$x] : null,
                                'dov_id_lip' => $idlip,
                                'dov_id_tpv' => (trim($tipo_venta[$x]) != "") ? $tipo_venta[$x] : null,
                                'dov_descripcion' => (trim($descripcion_factura[$x]) != "") ? $descripcion_factura[$x] : null,
                                'dov_cantidad' => (trim($cantidad_factura[$x]) != "") ? $cantidad_factura[$x] : null,
                                'dov_precio' => (trim($precio_factura[$x]) != "") ? $precio_factura[$x] : null,
                                'dov_precio_sugerido_lista' => trim($precio_sugerido_array[$x]) ? $precio_sugerido_array[$x] : null,
                                'dov_porcentaje_retencion' => (trim($retencion_por_factura[$x]) != "") ? $retencion_por_factura[$x] : null,
                                'dov_porcentaje_impuesto' => (trim($impuesto_por_factura[$x]) != "") ? $impuesto_por_factura[$x] : null,
                                'dov_porcentaje_descuento' => (trim($descuento_por_factura[$x]) != "") ? $descuento_por_factura[$x] : null,
                                'dov_retencion' => (trim($retencion_factura[$x]) != "") ? $retencion_factura[$x] : null,
                                'dov_descuento' => (trim($descuento_factura[$x]) != "") ? $descuento_factura[$x] : null,
                                'dov_impuesto' => (trim($impuesto_factura[$x]) != "") ? $impuesto_factura[$x] : null,
                                'dov_subtotal' => (trim($subtotal_factura[$x]) != "") ? $subtotal_factura[$x] : null,
                                'dov_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'dov_fecha_modificacion' => date('Y-m-d H:i:s')
                            );
                            $this->gsatelite->actualizar_array('dov_detalle_orden_venta', $detalle_factura, array('dov_id' => $dov_id_grid[$x]));
                            $dov_id = $dov_id_grid[$x];
                        } else {
                            $detalle_factura = array(
                                'dov_id_orv' => $id,
                                'dov_id_art' => (trim($productos_factura[$x]) != "") ? $productos_factura[$x] : null,
                                'dov_id_cva' => (trim($medida_factura[$x]) != "") ? $medida_factura[$x] : null,
                                'dov_id_lip' => $idlip,
                                'dov_id_tpv' => (trim($tipo_venta[$x]) != "") ? $tipo_venta[$x] : null,
                                'dov_descripcion' => (trim($descripcion_factura[$x]) != "") ? $descripcion_factura[$x] : null,
                                'dov_cantidad' => (trim($cantidad_factura[$x]) != "") ? $cantidad_factura[$x] : null,
                                'dov_precio' => (trim($precio_factura[$x]) != "") ? $precio_factura[$x] : null,
                                'dov_precio_sugerido_lista' => trim($precio_sugerido_array[$x]) ? $precio_sugerido_array[$x] : null,
                                'dov_porcentaje_retencion' => (trim($retencion_por_factura[$x]) != "") ? $retencion_por_factura[$x] : null,
                                'dov_porcentaje_impuesto' => (trim($impuesto_por_factura[$x]) != "") ? $impuesto_por_factura[$x] : null,
                                'dov_porcentaje_descuento' => (trim($descuento_por_factura[$x]) != "") ? $descuento_por_factura[$x] : null,
                                'dov_retencion' => (trim($retencion_factura[$x]) != "") ? $retencion_factura[$x] : null,
                                'dov_descuento' => (trim($descuento_factura[$x]) != "") ? $descuento_factura[$x] : null,
                                'dov_impuesto' => (trim($impuesto_factura[$x]) != "") ? $impuesto_factura[$x] : null,
                                'dov_subtotal' => (trim($subtotal_factura[$x]) != "") ? $subtotal_factura[$x] : null,
                                'dov_combo' => (trim($combo_agrupacion[$x]) != "") ? $combo_agrupacion[$x] : null,
                                'dov_estado' => 1,
                                'dov_usu_creacion' => $this->tank_auth->get_user_id(),
                                'dov_fecha_creacion' => date('Y-m-d H:i:s'),
                                'dov_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'dov_fecha_modificacion' => date('Y-m-d H:i:s')
                            );
                            $dov_id = $this->gsatelite->ingresar('dov_detalle_orden_venta', $detalle_factura);
                        }
                        //separamos el impuesto de cada producto total y porcentual para almacenarlo en la tabla para el detalle de cada impuesto
                        $impuesto_ids = explode(",", $impuesto_array[$x]);
                        $impuesto_por = explode(",", $impuesto_por_array[$x]);
                        $this->gsatelite->borrado_general("ixv_impuestoxorden_venta", array('ixv_id_dov' => $dov_id));
                        for ($k = 0; $k < count($impuesto_ids); $k++) {
                            if ($impuesto_ids[$k] != 0) {
                                if (trim($impuesto_por[$k]) != "") {
                                    //hacemos el calculo de el monto aplicado para ese impuesto especifico
                                    $monto_temp = $subtotal_factura[$x] * ($impuesto_por[$k] / 100);
                                    //tabla ixf_impuestoxfactura
                                    $detalle_impuesto = array(
                                        'ixv_id_dov' => $dov_id,
                                        'ixv_id_imp' => (trim($impuesto_ids[$k]) != "") ? $impuesto_ids[$k] : null,
                                        'ixv_monto' => $monto_temp,
                                        'ixv_porcentaje' => $impuesto_por[$k],
                                        'ixv_estado' => 1,
                                        'ixv_usu_modificacion' => $this->tank_auth->get_user_id(),
                                        'ixv_fecha_modificacion' => date('Y-m-d H:i:s'),
                                        'ixv_fecha_creacion' => date('Y-m-d H:i:s'),
                                        'ixv_usu_creacion' => $this->tank_auth->get_user_id()
                                    );
                                    $this->gsatelite->ingresar('ixv_impuestoxorden_venta', $detalle_impuesto);
                                }
                            }
                        }
                        $retencion_ids = explode(",", $retencion_array[$x]);
                        $retencion_por = explode(",", $retencion_por_array[$x]);
                        $this->gsatelite->borrado_general("rxv_retencionxorden_venta", array('rxv_id_dov' => $dov_id));
                        for ($k = 0; $k < count($retencion_ids); $k++) {
                            if ($retencion_ids[$k] != 0) {
                                if (trim($retencion_por[$k]) != "") {
                                    $monto_temp = $subtotal_factura[$x] * ($retencion_por[$k] / 100);
                                    //tabla rxf_retencionxdetalle_factura
                                    $detalle_retencion = array(
                                        'rxv_id_dov' => $dov_id,
                                        'rxv_id_ret' => (trim($retencion_ids[$k]) != "") ? $retencion_ids[$k] : null,
                                        'rxv_monto' => $monto_temp,
                                        'rxv_porcentaje' => $retencion_por[$k],
                                        'rxv_estado' => 1,
                                        'rxv_usu_creacion' => $this->tank_auth->get_user_id(),
                                        'rxv_fecha_creacion' => date('Y-m-d H:i:s'),
                                        'rxv_usu_modificacion' => $this->tank_auth->get_user_id(),
                                        'rxv_fecha_modificacion' => date('Y-m-d H:i:s')
                                    );
                                    $this->gsatelite->ingresar('rxv_retencionxorden_venta', $detalle_retencion);
                                }
                            }
                        }
                        /* ======== COMPONENTES ===============================================*/
                        $identificador = '_' . $productos_factura[$x] . '_' . $correlativo[$x];
                        /* para descargar de bodega             type array*/
                        $tipo_estado = $this->input->post('tipo_estado' . $identificador);
                        $descargar_componente = $this->input->post('producto_descargar_componente' . $identificador);
                        $tipo_componente = $this->input->post('producto_tipo_componente' . $identificador);
                        $bodega_componente = $this->input->post('bodega_componente_id' . $identificador); // no es arreglo
                        /* detalle para guardar                 type array*/
                        $producto_componente = ($this->input->post('producto_componente' . $identificador) != '') ? $this->input->post('producto_componente' . $identificador) : '';
                        $medida_componente = $this->input->post('medida_componente' . $identificador);
                        $cantidad_componente = $this->input->post('cantidad_conv_componente' . $identificador);
                        $precio_componente = $this->input->post('precio_componente' . $identificador);
                        $subtotal_componente = $this->input->post('subtotal_componente' . $identificador);
                        $descripcion_componente = $this->input->post('descripcion_componente' . $identificador);
                        $alternar_componente = $this->input->post('alternar_componente' . $identificador);
                        $mostrar_descripcion_componete = $this->input->post('showdesc_componente' . $identificador);
                        $componentes_reg = $this->gsatelite->get_tabla('cdv_componente_detallexorden_venta', array('cdv_id_dov' => $dov_id));
                        $fecha_creacion = date('Y-m-d H:i:s');
                        //$componente_up = array();
                        if ($tipo_estado != '') {
                            foreach ($componentes_reg as $comp_reg) {
                                if (!in_array($comp_reg['cdv_id'], $tipo_estado)) {
                                    $this->gsatelite->borrado_general('cdv_componente_detallexorden_venta', array('cdv_id' => $comp_reg['cdv_id']));
                                } else {
                                    $indice_comp = array_search($comp_reg['cdv_id'], $tipo_estado);
                                    $componente_up = array(
                                        'cdv_descripcion' => $descripcion_componente[$indice_comp],
                                        'cdv_cantidad' => $cantidad_componente[$indice_comp],
                                        'cdv_precio' => $precio_componente[$indice_comp],
                                        'cdv_subtotal' => $subtotal_componente[$indice_comp],
                                        'cdv_total' => $subtotal_componente[$indice_comp],
                                        'cdv_altera_precio' => $alternar_componente[$indice_comp],
                                        'cdv_muestra_descripcion' => $mostrar_descripcion_componete[$indice_comp],
                                        'cdv_estado' => 1,
                                        'cdv_usu_modificacion' => $this->tank_auth->get_user_id(),
                                        'cdv_fecha_modificacion' =>  $fecha_creacion
                                    );
                                    $this->gsatelite->actualizar_array('cdv_componente_detallexorden_venta', $componente_up, array('cdv_id' => $comp_reg['cdv_id']));
                                }
                            }
                        } else {
                            $this->gsatelite->borrado_general('cdv_componente_detallexorden_venta', array('cdv_id_dov' => $dov_id));
                        }
                        $fecha_creacion = date('Y-m-d H:i:s');
                        $componente_sav = array();
                        if ($producto_componente != '') {
                            foreach ($producto_componente as $id_comp => $comp) {
                                if ($tipo_estado[$id_comp] == 0) {
                                    $componente_sav[] = array(
                                        'cdv_id_dov' => $dov_id,
                                        'cdv_id_cva' => $medida_componente[$id_comp],
                                        'cdv_descripcion' => $descripcion_componente[$id_comp],
                                        'cdv_cantidad' => $cantidad_componente[$id_comp],
                                        'cdv_precio' => $precio_componente[$id_comp],
                                        'cdv_subtotal' => $subtotal_componente[$id_comp],
                                        'cdv_total' => $subtotal_componente[$id_comp],
                                        'cdv_altera_precio' => $alternar_componente[$id_comp],
                                        'cdv_muestra_descripcion' => $mostrar_descripcion_componete[$id_comp],
                                        'cdv_estado' => 1,
                                        'cdv_usu_creacion' => $this->tank_auth->get_user_id(),
                                        'cdv_fecha_creacion' =>  $fecha_creacion,
                                        'cdv_usu_modificacion' => $this->tank_auth->get_user_id(),
                                        'cdv_fecha_modificacion' =>  $fecha_creacion
                                    );
                                }
                            }
                            if (count($componente_sav) > 0) {
                                $this->gsatelite->ingresar('cdv_componente_detallexorden_venta', $componente_sav, true);
                            }
                        }
                        /* ========= FIN COMPONENTES =======================================*/
                        /* ========= CENTRO COSTO ===========================================*/
                        $this->gsatelite->borrado_general('dcv_detalle_centrocostoxorden_venta', array('dcv_id_dov' => $dov_id));
                        $centro_costo_costo = ($this->input->post('centro_costo_costo' . $identificador) != '') ? $this->input->post('centro_costo_costo' . $identificador) : '';
                        $tipo_cuenta_costo = $this->input->post('tipo_cuenta_costo' . $identificador);
                        $cuenta_contable_costo = $this->input->post('cuenta_contable_costo' . $identificador);
                        $porcentaje_costo = $this->input->post('porcentaje_costo' . $identificador);
                        $subtotal_costo = $this->input->post('subtotal_costo' . $identificador);
                        $pais_costo = $this->input->post('pais' . $identificador);
                        $costo_sav = array();
                        if ($centro_costo_costo != '') {
                            foreach ($centro_costo_costo as $id_cost => $costo) {
                                $costo_sav[] = array(
                                    'dcv_id_dov' => $dov_id,
                                    'dcv_id_cec' => $centro_costo_costo[$id_cost],
                                    'dcv_id_tcn' => $tipo_cuenta_costo[$id_cost],
                                    'dcv_id_cnt' => $cuenta_contable_costo[$id_cost],
                                    'dcv_id_pai' => ($pais_costo[$id_cost] != "") ? $pais_costo[$id_cost] : null,
                                    'dcv_porcentaje' => $porcentaje_costo[$id_cost],
                                    'dcv_monto' => $subtotal_costo[$id_cost],
                                    'dcv_estado' => 1,
                                    'dcv_usu_creacion' => $this->tank_auth->get_user_id(),
                                    'dcv_fecha_creacion' =>  $fecha_creacion,
                                    'dcv_usu_modificacion' => $this->tank_auth->get_user_id(),
                                    'dcv_fecha_modificacion' =>  $fecha_creacion
                                );
                            }
                            $this->gsatelite->ingresar('dcv_detalle_centrocostoxorden_venta', $costo_sav, true);
                        }
                    }
                }
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Registro de orden de venta", 'texto_alerta' => "El registro se guardó correctamente.");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registro de orden de venta", 'texto_alerta' => "El registro no se guardó, revise la información a ingresar.");
            }
            $redireccion = $this->input->post('redireccionar');
            $this->session->set_flashdata($alerta);
            //$this->session->set_flashdata('id_orden_venta', $orv_id);
            if ($redireccion == 0) {
                redirect('cotizaciones/cotizaciones/editar_orden_venta/' . $id);
            } else if ($redireccion == 1) {
                redirect('cotizaciones/cotizaciones/ordenes_venta');
            }
            exit();
            die();
        } else {
            $datos["titulo_personal"] = "Editar orden de venta";
            $orv_id = $id;
            $orden_venta_datos = $this->gsatelite->get_tabla('orv_orden_venta', array('orv_id' => $orv_id));
            /* =============    CARGA DE DATOS      ===========*/
            $datos['datos_orden'] = $orden_venta_datos[0];
            $datos['orv_id'] = $orv_id;
            $tipos_pago = $this->gsatelite->get_tabla("tpg_tipo_pago", array("tpg_estado" => 1));
            $option_tpg = '<option value=""></option>';
            foreach ($tipos_pago as $k2) {
                $selected_ = ($k2['tpg_id'] == $orden_venta_datos[0]['orv_condicion_pago']) ? 'selected' : '';
                $option_tpg .= '<option value="' . $k2['tpg_id'] . '" data-aplcred="' . intval($k2['tpg_aplica_credito']) . '" ' . $selected_ .'  >' . $k2['tpg_nombre'] . '</option>';
            }
            $datos['tipos_pago'] = $option_tpg;
            //  regresa datos de parametro
            $permite_mas_productos = $this->gsatelite->get_parametro('SYS_PERMITE_DUPLICAR_PRODUCTO');
            $datos['permite_mas_productos'] = (trim($permite_mas_productos) != '') ? $permite_mas_productos : 0;
            $datos["cliente"] = $orden_venta_datos[0]['orv_id_cli'];
            $datos["cliente_name"] = $this->facturar->get_nombre_cliente($orden_venta_datos[0]['orv_id_cli']);
            $arf_defecto = $this->gsatelite->get_campo('arf_area_factura', 'arf_id', array('arf_defecto' => 1, 'arf_estado' => 1));
            $area_drop = $this->gsatelite->get_dropdown('arf_area_factura', '{arf_nombre}', '', array('arf_estado' => '1'), $arf_defecto, '', 'arf_id', true);
            $datos["area"] = str_replace('<option value="0">Seleccione</option>', '', $area_drop);
            //por si esta el valor de la orden de venta, si no se carga el area por defecto
            $valor = $orden_venta_datos[0]['orv_id_arf'] != "" ? $orden_venta_datos[0]['orv_id_arf'] : $arf_defecto;
            $area_drop = $this->gsatelite->get_dropdown('arf_area_factura', '{arf_nombre}', '', array('arf_estado' => '1'),  $valor, '', 'arf_id', true);
            $datos["area"] = str_replace('<option value="0">Seleccione</option>', '', $area_drop);
            $personalxorden_array = $this->gsatelite->get_tabla('pxo_personalxorden_venta', array('pxo_id_orv' => $orv_id));
            //tabla de la relacion entre el empleado y la orden de venta
            $pxo_id_emp = array();
            foreach ($personalxorden_array as $key) {
                $pxo_id_emp[] = $key['pxo_id_emp'];
            }
            $empleados_drop = $this->gsatelite->get_dropdown('emp_empleado', '{emp_codigo} - {emp_nombre} {emp_apellido}', '', array('emp_estado' => '1'), $pxo_id_emp, '', 'emp_id', true);
            $datos["empleados"] = str_replace('<option value="0">Seleccione</option>', '', $empleados_drop);
            $vendedores_select = $this->gsatelite->get_dropdown('ven_vendedor', '{ven_codigo} - {ven_nombre} {ven_apellidos}', '', array('ven_estado' => 1), $orden_venta_datos[0]['orv_id_ven'], '', 'ven_id', true);
            $datos["vendedores"] = str_replace('<option value="0">Seleccione</option>', '', $vendedores_select);
            $datos["categorias"] = $this->facturar->obtener_categoriaxbodega2();
            $select = "";
            $tip_venta_reg = $this->gsatelite->get_tabla('tpv_tipo_venta', array('tpv_estado' => 1, 'tpv_aplica_venta' => 1));
            foreach ($tip_venta_reg as $key) {
                $select .= '<option value="' . $key['tpv_id'] . '" abrv="' . $key['tpv_abreviacion'] . '">' . $key['tpv_nombre'] . '-' . $key['tpv_abreviacion'] . '</option>';
            }
            $datos["tipo_venta"] = $select;
            $data_grid['detalle_orden'] = $this->facturacion_model->get_detalle_orden_venta(array('dov_id_orv' => $orv_id));
            $decimales = $this->gsatelite->get_parametro('NUMERO_DECIMALES');
            $data_grid['decimales'] = ($decimales != '') ? $decimales : 2;
            $datos['decimales'] = ($decimales != '') ? $decimales : 2;
            $data_grid['cliente'] = $orden_venta_datos[0]['orv_id_cli'];
            $datos["limite_credito"] = $this->gsatelite->get_campo('cli_cliente', 'cli_monto_credito', array('cli_id' => $orden_venta_datos[0]['orv_id_cli']));

            $datos["html"] = $this->load->view('facturacion/facturar/grid_orden_venta', $data_grid, true);
            $datos["cliente_defecto"] = $this->gsatelite->get_parametro('SYS_CLIENTE_DEFECTO');
            $tiene_lista = 0;
            foreach ($data_grid['detalle_orden'] as $key) {
                $id_tlp = $key['lip_id_tlp'];
                $tiene_lista += (trim($id_tlp) != '') ? 1 : 0;
            }
            $datos['tiene_lista'] = $tiene_lista;
            $user = $this->tank_auth->get_user_id();
            $bodegas_reg = $this->facturacion_model->bodegas_cliente(array('uxb_id_usu' => $user));
            $select = "";
            foreach ($bodegas_reg as $key) {
                $selected = ($key['uxb_defecto'] == 1) ? 'selected' : '';
                $select .= '<option value="' . $key['bod_id'] . '" ' . $selected . '>' . $key['bod_nombre'] . '</option>';
            }
            $datos["bodega_prefe"] = $select;
            $tpg_contado = $this->gsatelite->get_parametro('SYS_CONFIGURACION_CORTE_CAJA', null, null, array('CONTADO'));
            $tpg_credito = $this->gsatelite->get_parametro('SYS_CONFIGURACION_CORTE_CAJA', null, null, array('CREDITO'));
            $datos["datos_tpgcli"] = $this->facturacion_model->get_info_tpg_cli($orden_venta_datos[0]['orv_id_cli']);
            $datos["tpg_contado"] = ($tpg_contado) ? $tpg_contado : 0;
            $datos["tpg_credito"] = ($tpg_credito) ? $tpg_credito : 0;
            $datos["descarga_inv"] = $this->gsatelite->get_parametro('SYS_DESCARGA_INV');
            $this->_cargarvista($datos, null);
        }
    }


    public function see_all_contacts($cli_id)
    {
        $data['cli'] = $this->gsatelite->get_registro('cli_cliente', array('cli_id' => $cli_id));
        $data['contactos_cliente'] = $this->gsatelite->get_tabla('con_contacto', array('con_id_cli' => $cli_id));
        $this->gsatelite->cargar_vista_masterpage('cotizaciones/cotizaciones/contactos_cliente_cot', $data);
    }

    /**
     * @author Habby Lovo
     * @since 2018-02-23
     * @return
     */
    public function obtener_costos_edit($producto, $correlativo, $dov_id, $cliente, $tipo, $subtotal)
    {
        $this->load->library('../controllers/facturacion/facturar');
        $this->load->model('facturacion_model');
        $data_grid['decimales'] = $this->gsatelite->get_parametro('NUMERO_DECIMALES', 2);
        //carga la grid de componentes
        $html = '';
        //if($correlativo != null && $correlativo >= 0){
        if ($correlativo > -1) {
            $data_grid['ident'] = "_" . $producto . "_" . $correlativo;
            $data_grid['correlativo'] = $correlativo;
            $data_grid['producto'] = $producto;
            $data_grid['editar'] = 1;
            $data_grid['duplicar'] = 1;
            $data_grid['tipo'] = $tipo;

            $data_grid['subtotal'] = $subtotal;
            $data_grid['costo'] = null; // datos de costos

            $producto_det = $this->gsatelite->get_tabla('art_articulo', array('art_id' => $producto));
            $categoria = $producto_det[0]['art_id_tia'];

            $paiscli = $this->gsatelite->get_campo('cli_cliente', 'cli_id_pai', array('cli_id' => $cliente));
            $id_pais_defecto = $this->tank_auth->get_all_empresa();
            $id_pais_defecto = $id_pais_defecto->emr_id_pai;

            //Tipo de cuenta por defecto
            $tcn_id = $this->gsatelite->get_parametro('SYS_TIPO_CUENTAS', null, null, array('INGRESO'));
            $data_grid['costo_reg'] = $this->facturacion_model->get_centro_costo(array(
                'dta_id_tia' => $categoria,
                'tcn_id' => $tcn_id,
                'IFNULL(dta_id_pai, ' . $id_pais_defecto . ') = ' . (($paiscli != null) ? $paiscli : 0) => null
            ));
            if ($tipo == 2) {
                $data_grid['costo_grid'] = $this->facturacion_model->get_centro_costo_detalle_dov(array('dcv_id_dov' => $dov_id));
            } else {
                $data_grid['costo_grid'] = array();
            }
            $html = $this->load->view('facturacion/facturar/grid_centro_costo', $data_grid, true);
        }
        return array('html' => $html);
    }

    /**
     * @author René Castaneda
     * @return Cartelera de eventos
     * @since 11-07-2018
     */
    function cartelera_seguimiento()
    {
        $segumiento = $this->cotModel->get_seguimiento_cotizaciones();
        // <?php  echo base_url('cotizaciones/cotizaciones/seguimiento_bd/'.$bd['drn_id']);

        //se repasa la informacion para el ordenamiento de la informacion que se imprimira en el js, por la toma de desiciones
        foreach ($segumiento as $key => $value) {
            switch ($value['seguimiento']) {
                case 'CL':
                    $color  = '#E01010';
                    $url    = base_url("cotizaciones/cotizaciones/seguimiento_cliente/" . $value['id_cab'] . "/read/" . $value['id_mus_seg'] . "/1/2");
                    break;
                case 'CT':
                    $color = '#2358E3';
                    $url    = base_url("cotizaciones/cotizaciones/seguimiento_cotizacion/" . $value['id_cab'] . "/read/" . $value['id_mus_seg'] . "/1");
                    break;
                case 'BD1':
                    $color = '#206F0A';
                    $url    = base_url("cotizaciones/cotizaciones/seguimiento_bd/" . $value['id_cab'] . "/read/" . $value['id_mus_seg'] . "/1");
                    break;
                case 'BD2':
                    $color = '#001FFF';
                    $url    = base_url("cotizaciones/cotizaciones/seguimiento_bd/" . $value['id_cab'] . "/read/" . $value['id_mus_seg'] . "/1");
                    break;
            }
            $informacion[$key] = array(
                'title'         => $value['id_cab'],
                'description'   => mb_strtoupper(trim($value['nombre']), 'UTF-8'),
                'concepto'      => "<b>Concepto: </b>" . str_replace(array("\r\n", "\n", "\r"), " ", trim($value['concepto'])),
                'lugar'         => '<b>Lugar: </b>' . $value['lugar'],
                'start'         => formatear_fecha('Y-m-d', $value['fecha_proximo']),
                'end'           => formatear_fecha('Y-m-d', $value['fecha_proximo']),
                'color'         => $color,
                'allday'        => '0',
                'seguimiento'   => $value['id_mus_seg'],
                'url'           => $url,
                'estado'        => $value['estado']
            );
        }
        // var_dump($informacion);die();
        $data['informacion'] = $informacion;
        $data['titulo_personal'] = "Calendario de Seguimiento";
        cargarvista($data);
    }

    function datos_contacto()
    {
        $id = $this->input->post('contac');
        $datos_contc = $this->gsatelite->get_tabla('con_contacto', array('con_id' => $id));
        $datos_contc = $datos_contc[0];
        echo json_encode($datos_contc);
    }
}
