<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Consultas extends CI_Controller
{

    function __construct()
    {
        parent::__construct();
        $this->load->library('grocery_CRUD');
        $this->load->model('cotizaciones_model', 'cotModel');
        $this->load->library('form_validation');
        $this->load->library('pdf');
        $this->load->model('proyecto_model');
    }

    function index()
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $this->_cargarvista();
        }
    }



    /**
     * Consultas:general_de_cotizaciones
     * @author René Castaneda
     * @return Generación de un reporte general de cotizaciones
     * Modificada por Carlos Flores
     * Modificacion: Se modifico para obtener mas filtros como los clientes, los productos y los estados de las cotizaciones
     * */
    function general_de_cotizaciones($export = 0)
    {
        try {
            if (!$this->tank_auth->is_logged_in()) {
                redirect('/auth/login/');
            } else {

                $datos["datos_vendedores"] = $this->cotModel->get_tabla("ven_vendedor", "ven_estado", 1, "ven_id", "ASC");
                $datos["datos_clientes"] = $this->cotModel->get_tabla("cli_cliente", "", "", "cli_id", "ASC");
                $datos["datos_tia"] = $this->cotModel->get_tabla("tia_tipo_articulo", "tia_estado", 1, "tia_id", "ASC");
                $datos["datos_estado"] = $this->cotModel->get_tabla("est_estado_cotizacion", "", "", "est_id", "ASC");
                $datos["titulo_personal"] = "Reporte general de cotizaciones";

                $fecha1 = $this->input->post('fecha_pres_inicio'); //fecha_pres_inicio
                $fecha2 = $this->input->post('fecha_pres_fin'); //fecha_pres_fin
                $fecha3 = $this->input->post('fecha_cierre_inicio'); //fecha_cierre_inicio
                $fecha4 = $this->input->post('fecha_cierre_fin'); //fecha_cierre_fin

                $id_ven = $this->input->post('vendedores');
                $id_clie = $this->input->post('clientes');
                $id_tia = $this->input->post('categoria');
                $id_estado = $this->input->post('estado');


                // if ($fecha1 != "" || $fecha3 != "") { //comentado el 24/02/2023
                $datetime1 = new DateTime($fecha1); //fecha_pres_inicio
                $datetime2 = new DateTime($fecha2); //fecha_pres_fin
                $datetime3 = new DateTime($fecha3); //fecha_pres_inicio
                $datetime4 = new DateTime($fecha4); //fecha_pres_inicio
                //if ($datetime1 > $datetime2 || $datetime1 > $datetime3 || $datetime3 > $datetime4)    { $datos["error"] = 1; }

                $datos["fecha1"] = $fecha1;
                $datos["fecha2"] = $fecha2;
                $datos["fecha3"] = $fecha3;
                $datos["fecha4"] = $fecha4;
                //var_dump($datos["fecha1"]);die();
                $datos["id_vendedorpost"] = $id_ven;
                $datos["id_clientepost"] = $id_clie;
                $datos["id_tiapost"] = $id_tia;
                $datos["id_estadopost"] = $id_estado;
                //var_dump($_POST);die();
                $datos["datosCotizaciones"] = $this->cotModel->get_ReporteGeneralCotizaciones($fecha1, $fecha2, $fecha3, $fecha4, $id_ven, $id_clie, $id_tia, $id_estado);
                //print_r($this->db->last_query());die();
                // }

                if ($export == 0) { //si el post no viene del boton exportar que muestre la vista en la masterpage
                    $this->_cargarvista($datos, null);
                } else { //cargar la vista para el exports
                    $this->load->view("cotizaciones/consultas/general_de_cotizaciones_export", $datos);
                }
            }
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    /**
     * Consultas:resumen_ventas_vensupervisor
     * @author René Castaneda
     * @return Generación de un reporte resumido de las ventas efectuadas por los vendedores de dicho supervisor
     */
    function resumen_ventas_vensupervisor($export = 0)
    {
        try {
            if (!$this->tank_auth->is_logged_in()) {
                redirect('/auth/login/');
            } else {
                $datos['simbolo'] = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');

                //preguntar si es supervisor o vendedor
                $condicion1 = array('sup_id_usu' => $this->tank_auth->get_user_id(), 'sup_estado' => 1);
                $esSup = $this->cotModel->Existe_Registro("sup_supervisor", $condicion1);
                $condicion2 = array('ven_id_usu' => $this->tank_auth->get_user_id(), 'ven_estado' => 1);
                $esVen = $this->cotModel->Existe_Registro("ven_vendedor", $condicion2);
                if ($esSup == 1) {  //es supervisor 
                    $datos["tambien_vendedor"] = $this->cotModel->get_registro("ven_vendedor", "ven_id_usu", $this->tank_auth->get_user_id());
                    $datos["datos_vendedores"] = $this->cotModel->datosVendedoresxSupervisor($this->tank_auth->get_user_id());
                    $datos["titulo_personal"] = "Reporte de cumplimiento de metas";
                    $registro = $this->cotModel->get_registro("sup_supervisor", "sup_id_usu", $this->tank_auth->get_user_id());
                    $datos["nombre_super_ven"] = $registro->sup_nombre . " " . $registro->sup_apellido;
                    $fecha1 = $this->input->post('fecha_ini');
                    $fecha2 = $this->input->post('fecha_fin');
                    $vendedor = $this->input->post('vendedor');
                    if ($fecha1 != "") {
                        $datetime1 = new DateTime($fecha1); //fecha inicio
                        $datetime2 = new DateTime($fecha2); //fecha fin
                        if ($datetime1 > $datetime2) {
                            $datos["error"] = 1;
                        }
                        if ($vendedor != "") {
                            $id_ven = $vendedor;
                            $datos["datosVen"] = $this->cotModel->get_tabla3("ven_vendedor", null, "", "", "ven_id", $id_ven);
                            $datos["fecha1"] = $fecha1;
                            $datos["fecha2"] = $fecha2;
                            $datos["id_vendedorpost"] = $vendedor;
                        } else {
                            $datos["datosVen"] = $this->cotModel->datosVendedoresxSupervisor($this->tank_auth->get_user_id());
                            $datos["fecha1"] = $fecha1;
                            $datos["fecha2"] = $fecha2;
                            $datos["id_vendedorpost"] = $vendedor;
                        }
                    }
                    if ($export == 0) { //si el post no viene del boton exportar que muestre la vista en la masterpage
                        $this->_cargarvista($datos, null);
                    } else { //cargar la vista para el export
                        if ($this->input->post('vendedor') != "") {
                            $vendedor = explode(',', $this->input->post('vendedor'));
                            $id_ven = $vendedor;
                            $datos["datosVen"] = $this->cotModel->get_tabla3("ven_vendedor", null, "", "", "ven_id", $id_ven);
                        } else {
                            $datos["datosVen"] = $this->cotModel->datosVendedoresxSupervisor($this->tank_auth->get_user_id());
                            $datos["todosSeleccionados"] = "Todos";
                        }
                        $this->load->view("cotizaciones/consultas/resumen_ventas_vensupervisor_export", $datos);
                    }
                } elseif ($esVen == 1) {
                    $query = $this->db->select()->from('ven_vendedor')->where('ven_id_usu', $this->tank_auth->get_user_id())->get();
                    $datos["datos_vendedores"] = $query;
                    $datos["titulo_personal"] = "Reporte Resumen de ventas";
                    $registro = $this->cotModel->get_registro("ven_vendedor", "ven_id_usu", $this->tank_auth->get_user_id());
                    $datos["nombre_super_ven"] = $registro->ven_nombre . " " . $registro->ven_apellidos;
                    $fecha1 = $this->input->post('fecha_ini');
                    $fecha2 = $this->input->post('fecha_fin');
                    $vendedor = $this->input->post('vendedor');
                    if ($fecha1 != "") {
                        $datetime1 = new DateTime($fecha1); //fecha inicio
                        $datetime2 = new DateTime($fecha2); //fecha fin
                        if ($datetime1 > $datetime2) {
                            $datos["error"] = 1;
                        }
                        if ($vendedor != "") {
                            $id_ven = $vendedor;
                            $datos["datosVen"] = $this->cotModel->get_tabla3("ven_vendedor", null, "", "", "ven_id", $id_ven);
                            $datos["fecha1"] = $fecha1;
                            $datos["fecha2"] = $fecha2;
                            $datos["id_vendedorpost"] = $vendedor;
                        } else {
                            $datos["datosVen"] = $this->cotModel->datosVendedoresxSupervisor($this->tank_auth->get_user_id());
                            $datos["fecha1"] = $fecha1;
                            $datos["fecha2"] = $fecha2;
                            $datos["id_vendedorpost"] = $vendedor;
                        }
                    }
                    if ($export == 0) { //si el post no viene del boton exportar que muestre la vista en la masterpage
                        $this->_cargarvista($datos, null);
                    } else { //cargar la vista para el export
                        if ($this->input->post('vendedor') != "") {
                            $vendedor = explode(',', $this->input->post('vendedor'));
                            $id_ven = $vendedor;
                            $datos["datosVen"] = $this->cotModel->get_tabla3("ven_vendedor", null, "", "", "ven_id", $id_ven);
                        } else {
                            $datos["datosVen"] = $this->cotModel->datosVendedoresxSupervisor($this->tank_auth->get_user_id());
                        }
                        $this->load->view("cotizaciones/consultas/resumen_ventas_vensupervisor_export", $datos);
                    }
                } else {
                    $datos["accesoNo"] = "no";
                    $datos["titulo_personal"] = "Reporte Resumen de ventas";
                    $this->_cargarvista($datos, null);
                }
            }
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    /**
     * Consultas:resumen_ventas_vensupervisor
     * @author René Castaneda
     * @return Generación de un reporte resumido de las cotizaciones efectuadas por un vendedor
     */
    function resumen_cotizado_vensupervisor($export = 0)
    {
        try {
            if (!$this->tank_auth->is_logged_in()) {
                redirect('/auth/login/');
            } else {
                $datos['simbolo'] = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');

                //preguntar si es supervisor o vendedor
                $condicion1 = array('sup_id_usu' => $this->tank_auth->get_user_id(), 'sup_estado' => 1);
                $esSup = $this->cotModel->Existe_Registro("sup_supervisor", $condicion1);
                $condicion2 = array('ven_id_usu' => $this->tank_auth->get_user_id(), 'ven_estado' => 1);
                $esVen = $this->cotModel->Existe_Registro("ven_vendedor", $condicion2);
                if ($esSup == 1) {  //es supervisor
                    $datos["datos_vendedores"] = $this->cotModel->datosVendedoresxSupervisor($this->tank_auth->get_user_id());
                    $datos["titulo_personal"] = "Reporte Resumen de cotizaciones";
                    $registro = $this->cotModel->get_registro("sup_supervisor", "sup_id_usu", $this->tank_auth->get_user_id());
                    $datos["nombre_super_ven"] = $registro->sup_nombre . " " . $registro->sup_apellido;
                    $fecha1 = $this->input->post('fecha_ini');
                    $fecha2 = $this->input->post('fecha_fin');
                    if ($fecha1 != "") {
                        $datetime1 = new DateTime($fecha1); //fecha inicio
                        $datetime2 = new DateTime($fecha2); //fecha fin
                        if ($datetime1 > $datetime2) {
                            $datos["error"] = 1;
                        }
                        $vendedor = $this->input->post('vendedor');
                        if ($vendedor != "todos") {
                            $id_ven = $vendedor;
                            $datos["datosVen"] = $this->cotModel->get_tabla2("ven_vendedor", array('ven_id' => $id_ven));
                            $datos["fecha1"] = $fecha1;
                            $datos["fecha2"] = $fecha2;
                            $datos["id_vendedorpost"] = $vendedor;
                        } else {
                            $datos["datosVen"] = $this->cotModel->datosVendedoresxSupervisor($this->tank_auth->get_user_id());
                            $datos["fecha1"] = $fecha1;
                            $datos["fecha2"] = $fecha2;
                            $datos["id_vendedorpost"] = $vendedor;
                        }
                    }
                    if ($export == 0) { //si el post no viene del boton exportar que muestre la vista en la masterpage
                        $this->_cargarvista($datos, null);
                    } else { //cargar la vista para el export
                        $this->load->view("cotizaciones/consultas/resumen_cotizado_vensupervisor_export", $datos);
                    }
                } elseif ($esVen == 1) {
                    $query = $this->db->select()->from('ven_vendedor')->where('ven_id_usu', $this->tank_auth->get_user_id())->get();
                    $datos["datos_vendedores"] = $query;
                    $datos["titulo_personal"] = "Reporte Resumen de cotizaciones";
                    $registro = $this->cotModel->get_registro("ven_vendedor", "ven_id_usu", $this->tank_auth->get_user_id());
                    $datos["nombre_super_ven"] = $registro->ven_nombre . " " . $registro->ven_apellidos;
                    $fecha1 = $this->input->post('fecha_ini');
                    $fecha2 = $this->input->post('fecha_fin');
                    if ($fecha1 != "") {
                        $datetime1 = new DateTime($fecha1); //fecha inicio
                        $datetime2 = new DateTime($fecha2); //fecha fin
                        if ($datetime1 > $datetime2) {
                            $datos["error"] = 1;
                        }
                        $vendedor = $this->input->post('vendedor');
                        if ($vendedor != "todos") {
                            $id_ven = $vendedor;
                            $datos["datosVen"] = $this->cotModel->get_tabla2("ven_vendedor", array('ven_id' => $id_ven));
                            $datos["fecha1"] = $fecha1;
                            $datos["fecha2"] = $fecha2;
                            $datos["id_vendedorpost"] = $vendedor;
                        } else {
                            $datos["datosVen"] = $this->cotModel->datosVendedoresxSupervisor($this->tank_auth->get_user_id());
                            $datos["fecha1"] = $fecha1;
                            $datos["fecha2"] = $fecha2;
                            $datos["id_vendedorpost"] = $vendedor;
                        }
                    }

                    if ($export == 0) { //si el post no viene del boton exportar que muestre la vista en la masterpage
                        $this->_cargarvista($datos, null);
                    } else { //cargar la vista para el export
                        $this->load->view("cotizaciones/consultas/resumen_cotizado_vensupervisor_export", $datos);
                    }
                } else {
                    $datos["accesoNo"] = "no";
                    $datos["titulo_personal"] = "Reporte Resumen de cotizaciones";
                    $this->_cargarvista($datos, null);
                }
            }
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    // Rafael A. Cuchilla

    public function cotizacion_personalizada()
    {
        satelite_validar();
        $datos['titulo_personal'] = 'Reporte de Cotizacion Personalizada';
        $this->_cargarvista($datos, null);
    }

    // Rafael A. Cuchilla
    function get_reporte_cot_personalizada()
    {
        satelite_validar();
        $html_header = $this->load->view('reporte/header', array('titulo' => 'Cotizaciones Personalizadas'), true);

        $f1 = date('Y-m-d', strtotime($this->input->post('txtFecha_desde')));
        $f2 = date('Y-m-d', strtotime($this->input->post('txtFecha_hasta')));
        $tipo = $this->input->post('tipo');
        $data['tipo'] = $tipo;
        if ($this->input->post('txtFecha_desde') != "" and $this->input->post('txtFecha_hasta') != "") {
            $where = array(
                'DATE(cot_fecha) >=' => $f1, 'DATE(cot_fecha) <=' => $f2
            );
            $where['(axc_personalizado > 0 ) or (axc_personalizado <> null)'] = null;

            $data['consulta'] = $this->cotModel->get_cotizaciones_personalizadas($where);
            //die(print_r($this->db->last_query()));
            $html = $this->load->view('cotizaciones/consultas/grid_cot_personalizada', $data, true);
        }

        if ($tipo == null or $tipo == "") {
            echo $html;
        } else if ($tipo == 2) {
            $this->load->library('pdf');
            $reporte = $this->pdf->makePDF($html_header . $html, 'L');
        } else {
            header("Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            header("Content-Disposition: attachment;filename=Reporte_cotizaciones_personalizadas.xls");
            header("Pragma: no-cache");
            header("Expires: 0");
            echo $html;
        }
    }

    function reporte_tabla_llamadas()
    {
        satelite_validar();
        $datos['titulo_personal'] = 'Reporte tabla de llamadas';
        $datos['motivos']    = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $this->gsatelite->get_dropdown('mat_motivo_atencion', '{mat_nombre}', '', array('mat_estado' => 1), null, null, null, true));
        $this->_cargarvista($datos, null);
    }

    /* RENE CASTANEDA */

    function get_reporte_tabla_llamadas()
    {
        satelite_validar();
        $html_header = $this->load->view('reporte/header', array('titulo' => 'Llamadas'), true);

        $f1     = date('Y-m-d 00:00:00', strtotime($this->input->post('desde')));
        $f2     = date('Y-m-d 23:59:59', strtotime($this->input->post('hasta')));
        $motivo = $this->input->post("motivo");
        $tipo = $this->input->post('tipo');
        if ($this->input->post('desde') != "" and $this->input->post('hasta') != "") {
            $where = array(
                'tbl_fecha >=' => $f1, 'tbl_fecha <=' => $f2, 'tbl_id_mat =' => $motivo
            );

            $data['consulta'] = $this->cotModel->obtener_tabla_llamadas($where);
            $html = $this->load->view('cotizaciones/consultas/get_reporte_tabla_llamadas', $data, true);
        }

        $mo = $this->cotModel->get_nombre($motivo);

        if ($tipo == null or $tipo == "") {
            echo $html;
        } else if ($tipo == 2) {
            $this->load->library('pdf');
            $titulo = '<p> <br/>Motivo: ' . $mo[0]["mat_nombre"] . '<br/
            > Desde: ' . $this->input->post('desde') . '<br/> Hasta: ' . $this->input->post('hasta') . '</p>';

            $reporte = $this->pdf->makePDF($html_header . $titulo . $html, 'L');
        } else {
            $titulo = '<p style="text-align:center;font-weight:bold">
            <br/>' . mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8') . '<br>
            Reporte de Llamadas</p><p> <br/>Motivo: ' . $mo[0]["mat_nombre"] . '<br/> Desde: ' . $this->input->post('desde') . '<br/> Hasta: ' . $this->input->post('hasta') . '</p>';
            header("Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            header("Content-Disposition: attachment;filename=Reporte_de_llamadas.xls");
            header("Pragma: no-cache");
            header("Expires: 0");
            echo $titulo;
            echo $html;
        }
    }

    function reporte_productos_masvendidos()
    {
        satelite_validar();
        $datos['vendedores'] = $this->gsatelite->get_tabla('ven_vendedor', "ven_estado <> 0"); //Obtener los vendedores
        $categorias = $this->gsatelite->get_dropdown('tia_tipo_articulo', '{tia_codigo} - {tia_nombre}', '', array('tia_estado' => '1'), null, '', 'tia_id', true);
        $datos['categorias'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $categorias);
        $marcaprod = $this->gsatelite->get_dropdown('mrp_marca_producto', '{mrp_codigo} - {mrp_nombre}', '', array('mrp_estado' => '1'), null, '', 'mrp_id', true);
        $datos['drop_marcas'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $marcaprod);
        $datos['titulo_personal'] = 'Reporte productos más vendidos';
        $this->_cargarvista($datos, null);
    }

    function get_productos_masvendidos()
    {
        satelite_validar();
        $f1 = date('Y-m-d 00:00:00', strtotime($this->input->post('desde')));
        $f2 = date('Y-m-d 23:00:00', strtotime($this->input->post('hasta')));
        $limite = ($this->input->post('cantidad') != "") ? $this->input->post('cantidad') : "10";
        $categoria = ($this->input->post('categoria') != "") ? $this->input->post('categoria') : "";
        $vendedor = ($this->input->post('vendedor') != "") ? $this->input->post('vendedor') : "";
        $marcaprod = ($this->input->post('marca') > 0) ? $this->input->post('marca') : "";
        $tipo = $this->input->post('tipo');
        if ($this->input->post('desde') != "" and $this->input->post('hasta') != "") {
            $where = array(
                'cog_fecha_modificacion >=' => $f1,
                'cog_fecha_modificacion <=' => $f2
            );
            if ($vendedor != "") {
                $where['ven_id'] = $vendedor;
            }
            if ($marcaprod != "") {
                $where['mrp_id'] = $marcaprod;
            }
            if ($categoria != "") {
                $where['tia_id'] = $categoria;
            }
            $where['cot_estado'] = 1;
            $data['consulta'] = $this->cotModel->get_productos_mas_ven($where, $limite);
            $data['fecha1'] = date('d-m-Y', strtotime($this->input->post('desde')));
            $data['fecha2'] = date('d-m-Y', strtotime($this->input->post('hasta')));
            $data['np'] = $limite;
            $data['id_ven'] = $vendedor;
            $html = $this->load->view('cotizaciones/consultas/get_productos_masvendidos', $data, true);
        }

        if ($tipo == null or $tipo == "") {
            echo $html;
        } else if ($tipo == 2) {
            $this->load->library('pdf');
            $html_header = $this->load->view('reporte/header', array('titulo' => 'Productos más vendidos'), true);
            $reporte = $this->pdf->makePDF($html_header . $html, 'L');
        } else {
            header("Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            header("Content-Disposition: attachment;filename=Reporte_productos_mas_vendidos.xls");
            header("Pragma: no-cache");
            header("Expires: 0");
            echo $html;
        }
    }

    function ver_grafico_producto_vendidos($f1 = null, $f2 = null, $n = null, $id_ven = null, $catego = null)
    {
        $f1 = date('Y-m-d 00:00:00', strtotime($f1));
        $f2 = date('Y-m-d 23:00:00', strtotime($f2));
        $id_ven = ($id_ven) ? $id_ven : "";
        $catego = ($catego) ? $catego : "";
        $where = array(
            'cog_fecha_modificacion >=' => $f1, 'cog_fecha_modificacion <=' => $f2
        );
        if ($id_ven != "" && $id_ven > 0) {
            $where['ven_id'] = $id_ven;
        }
        if ($catego != "") {
            $where['tia_id'] = $catego;
        }
        $data = array();
        $textof1 = date('d-m-Y', strtotime($f1));
        $textof2 = date('d-m-Y', strtotime($f2));
        $n = ($n) ? $n : 10;
        $data['titulo_grafico'] = "Desde $textof1 Hasta $textof2 Los $n productos más vendidos";


        $data['consulta'] = $this->cotModel->get_productos_mas_ven($where, $n);
        $this->load->view('cotizaciones/consultas/grafico_productos_vendidos', $data, FALSE);
    }

    function reporte_detallecompra_cliente()
    {
        satelite_validar();
        $datos['titulo_personal'] = 'Reporte detalle de compras por cliente';
        $this->_cargarvista($datos, null);
    }

    function get_detallecompra_cliente()
    {
        satelite_validar();
        $f1 = date('Y-m-d 00:00:00', strtotime($this->input->post('desde')));
        $f2 = date('Y-m-d 23:00:00', strtotime($this->input->post('hasta')));
        $cliente = $this->input->post('cliente');
        $tipo = $this->input->post('tipo');
        $data['simbolo'] = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');

        if ($this->input->post('desde') != "" and $this->input->post('hasta') != "") {
            $where = array(
                'cog_fecha_modificacion >=' => $f1, 'cog_fecha_modificacion <=' => $f2, 'cot_id_cli =' => $cliente
            );
            $consulta = $this->cotModel->get_cotizaciones_ganada_cliente($where);
            //print_r($this->db->last_query());die();
            // $data['consulta'] = $this->cotModel->get_cotizaciones_ganada_cliente($where);
            $data['fecha1'] = date('d-m-Y', strtotime($this->input->post('desde')));
            $data['fecha2'] = date('d-m-Y', strtotime($this->input->post('hasta')));
            $data['registro_cliente'] = $this->gsatelite->get_registro('cli_cliente', 'cli_id', $cliente);

            $html_d = "";
            $i = 0;
            foreach ($consulta as $j) {
                $i++;
                $html_d .= $this->get_detelle_cotizacion($j['cot_id']);
                if ($i != count($consulta)) {
                    // $html_d .= '<br style="page-break-after: always;" />';
                }
            }
            $data['resultados'] = $html_d;
            $html = $this->load->view('cotizaciones/consultas/get_detallecompra_cliente', $data, true);
        }

        if ($tipo == null or $tipo == "") {
            echo $html;
        } else if ($tipo == 2) {
            $this->load->library('pdf');
            $html_header = $this->load->view('reporte/header', array('titulo' => 'Detalles de compra'), true);
            $reporte = $this->pdf->makePDF($html_header . $html, 'P');
        } else {
            header("Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            header("Content-Disposition: attachment;filename=Reporte_detalle_compra_cliente.xls");
            header("Pragma: no-cache");
            header("Expires: 0");
            echo $html;
        }
    }

    function get_detelle_cotizacion($id_cot = null)
    {
        satelite_validar();
        $data['simbolo'] = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');
        $this->gsatelite->verificar_registro_real('cot_cotizacion', $id_cot);
        $data["consulta"] = $this->cotModel->get_cotizacion(array('cot_id' => $id_cot));
        $data["detalle_productos"] = $this->cotModel->get_detalle_productos(array('axc_id_cot' => $id_cot));
        $data['esreporte'] = true;
        $html = $this->load->view('cotizaciones/consultas/get_detelle_cotizacion', $data, true);
        return $html;
    }

    function reporte_mejores_clientes()
    {
        satelite_validar();
        $datos['vendedores'] = $this->gsatelite->get_tabla('ven_vendedor', "ven_estado <> 0"); //Obtener los vendedores
        $datos['titulo_personal'] = 'Reporte de mejores clientes';
        $this->_cargarvista($datos, null);
    }

    function get_mejores_clientes()
    {
        satelite_validar();
        $data['simbolo'] = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');

        $f1 = date('Y-m-d 00:00:00', strtotime($this->input->post('desde')));
        $f2 = date('Y-m-d 23:59:59', strtotime($this->input->post('hasta')));
        $limite = ($this->input->post('cantidad') != "") ? $this->input->post('cantidad') : "10";
        $vendedor = ($this->input->post('vendedor') != "") ? $this->input->post('vendedor') : "";
        $tipo = $this->input->post('tipo');
        if ($this->input->post('desde') != "" and $this->input->post('hasta') != "") {
            $where = array(
                'cog_fecha_modificacion >=' => $f1,
                'cog_fecha_modificacion <=' => $f2
            );
            if ($vendedor != "") {
                $where['ven_id'] = $vendedor;
            }
            $data['tipo'] = $tipo;
            $data['consulta'] = $this->cotModel->get_mejores_clientes($where, $limite);
            //die($this->db->last_query());
            $data['fecha1'] = date('d-m-Y', strtotime($this->input->post('desde')));
            $data['fecha2'] = date('d-m-Y', strtotime($this->input->post('hasta')));
            $data['np'] = $limite;
            $data['f1_iframe'] = date('d-m-Y', strtotime($this->input->post('desde')));
            $data['f2_iframe'] = date('d-m-Y', strtotime($this->input->post('hasta')));
            $data['id_ven'] = $vendedor;
            $html = $this->load->view('cotizaciones/consultas/get_mejores_clientes', $data, true);
        }

        if ($tipo == null or $tipo == "") {
            echo $html;
        } else if ($tipo == 2) {
            $this->load->library('pdf');
            $html_header = $this->load->view('reporte/header', array('titulo' => 'Mejores Clientes'), true);
            $reporte = $this->pdf->makePDF($html_header . $html, 'P');
        } else {
            header("Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            header("Content-Disposition: attachment;filename=Reporte_mejores_clientes.xls");
            header("Pragma: no-cache");
            header("Expires: 0");
            echo $html;
        }
    }

    function ver_grafico_mejores_clientes($f1 = null, $f2 = null, $n = null, $id_ven = null)
    {
        $f1 = date('Y-m-d 00:00:00', strtotime($f1));
        $f2 = date('Y-m-d 23:00:00', strtotime($f2));
        $id_ven = ($id_ven) ? $id_ven : "";
        $where = array(
            'cog_fecha_modificacion >=' => $f1, 'cog_fecha_modificacion <=' => $f2
        );
        if ($id_ven != "") {
            $where['ven_id'] = $id_ven;
        }
        $data = array();
        $textof1 = date('d-m-Y', strtotime($f1));
        $textof2 = date('d-m-Y', strtotime($f2));
        $n = ($n) ? $n : 10;
        $data['titulo_grafico'] = "Desde $textof1 Hasta $textof2 Los $n mejores clientes";

        $data['consulta'] = $this->cotModel->get_mejores_clientes($where, $n);
        $this->load->view('cotizaciones/consultas/grafico_mejores_clientes', $data, FALSE);
    }

    /**
     * Consultas:consulta de registros
     * @author René Castaneda
     */
    function consulta_cotizaciones()
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($_POST) {

                $tipo = $this->input->post('tipo_accion');
                $filtro = $this->input->post('filtro_hidden');
                $valor_filtro = $this->input->post('filtro_valor_hidden');
                $valor_extras = $this->input->post('filtro_extra_hidden');

                if ($tipo == 'pdf') {
                    //imprimir pdf
                    $data["consulta"] = $this->filtro_reporte_cotizaciones($filtro, $valor_filtro, false, true, $valor_extras);
                    $html = $this->load->view('reporte/header', array('titulo' => 'Cotizaciones'), true);
                    $html .= $this->load->view('cotizaciones/consultas/reporte_cotizaciones_pdf', $data, true);
                    $this->load->library('pdf');
                    $this->pdf->setPrintFooter(true);
                    $this->pdf->makePDF($html, 'L', 'reporte_clientes', 'Letter');
                }

                if ($tipo == 'excel') {
                    //exportar excel
                    $data["consulta"] = $this->filtro_reporte_cotizaciones($filtro, $valor_filtro, false, true, $valor_extras);
                    $this->load->view('cotizaciones/consultas/reporte_cotizaciones_excel', $data);
                }
            } else {
                $select = $this->gsatelite->get_dropdown('ven_vendedor', '{ven_nombre} {ven_apellidos}', '', array('ven_estado' => 1), null, '', 'ven_id', true);
                $data["select_cot_id_ven"] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $select);
                $select = $this->gsatelite->get_dropdown('cli_cliente', '{cli_codigo} - {cli_nombre} {cli_apellido}', '', array('cli_estado' => 1), null, '', 'cli_id', true);
                $data["select_cot_id_cli"] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $select);

                $cadena_in = array();
                $sin_hijos = $this->db->query("SELECT tia_id FROM tia_tipo_articulo WHERE tia_id NOT IN (SELECT DISTINCT tia_padre FROM tia_tipo_articulo WHERE tia_padre IS NOT NULL)")->result_array();
                foreach ($sin_hijos as $key2 => $value2) {
                    $cadena_in[] = $value2['tia_id'];
                }
                $cadena_in = (count($cadena_in) <= 0) ? array(0) : $cadena_in;

                $this->db->where_in('tia_id', $cadena_in);
                $categorias = $this->gsatelite->get_dropdown('tia_tipo_articulo', '{tia_codigo} {tia_nombre}', '', array('tia_estado' => '1'), null, '', 'tia_id', true);
                $data["select_categorias"] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $categorias);

                $select = $this->gsatelite->get_dropdown('sec_sector_cliente', '{sec_nombre}', '', array('sec_estado' => 1), null, '', 'sec_id', true);
                $data["select_cli_id_sec"] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $select);

                $select = $this->gsatelite->get_dropdown('cac_cartera_cliente', '{cac_nombre}', '', array('cac_estado' => 1), null, '', 'cac_id', true);
                $data["select_cli_id_cac"] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $select);

                $select = $this->gsatelite->get_dropdown('cfc_clasificacion_cliente', '{cfc_nombre}', '', array('cfc_estado' => 1), null, '', 'cfc_id', true);
                $data["select_cli_id_cfc"] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $select);

                $data["titulo_personal"] = "Consulta de cotizaciones";
                $this->_cargarvista($data, null);
            }
        }
    }

    /* René Castaneda */
    function filtro_reporte_cotizaciones($filtro = null, $valor = null, $retorna_html = false, $retornarconsulta = false, $datas = null)
    {
        $data['simbolo'] = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');

        if ($filtro == null and $valor == null) {
            $filtro = $this->input->post('filtro');
            $valor = $this->input->post('valor');
            $datas = $this->input->post('extra');
        }
        $where = null;
        if ($filtro == 'cot_fecha_pres') {
            $f = explode('#', $valor);
            $where = array('date_format(' . $filtro . ',"%Y-%m-%d") >=' => date('Y-m-d', strtotime($f[0])), 'date_format(' . $filtro . ',"%Y-%m-%d") <=' => date('Y-m-d', strtotime($f[1])));
        } elseif ($filtro == 'todos_los_registros') {
            // ningun valor de filtro
        } elseif ($filtro == 'categorias') {
            //preguntar por las cotizaciones que poseen algun detalle del producto correspondiente a la categoria elegida
            $this->db->group_by('axc_id_cot');
            $this->db->join('art_articulo', 'art_id=axc_id_art');
            $query = $this->gsatelite->get_tabla('axc_articuloxcotizacion', array('art_id_tia' => $valor));
            //die($this->db->last_query());
            if (!empty($query)) {
                $ids_cot = array();
                foreach ($query as $k) {
                    $ids_cot[] = $k['axc_id_cot'];
                }
                //condicionar que solo muestre las cotizaciones que estan en el array (ELIMINAR LOS VALORES DUPLICADOS EN EL ARRAY)
                $this->db->where_in('cot_id', $ids_cot);
            } else {
                $this->db->where_in('cot_id', 'null');
            }
        } else {
            $where = array("$filtro" => trim($valor));
        }
        $fechas = explode("#", $datas);
        if (trim($fechas[0]) != "") {
            $where["DATE(cot_fecha_pres) >= "] = formatear_fecha('Y-m-d', $fechas[0]);
        }
        if (trim($fechas[1]) != "") {
            $where["DATE(cot_fecha_pres) <= "] = formatear_fecha('Y-m-d', $fechas[1]);
        }
        $consulta = $this->cotModel->get_cotizacion($where);
        $data["consulta"] = $consulta;
        $html = $this->load->view("cotizaciones/consultas/filtro_reporte_cotizaciones", $data, true);

        if ($retorna_html) {
            return $html;
        } elseif ($retornarconsulta) {
            return $consulta;
        } else {
            echo json_encode(array('resultado' => $html));
        }
    }

    /*
     *  La opcion de Llamadas a vendedor se cambio al controlador de Cotizaciones/Mantenimiento
     */
    // public function tabla_llamadas_vendedor($id_ven = null) {
    //     //preguntar por el vendedor dependiendo el usuario
    //     $id_usuario = $this->tank_auth->get_user_id();
    //     $registro = $this->gsatelite->get_tabla('ven_vendedor', array('ven_id_usu' => $id_usuario));

    //     //validar que sea un registro unico y que no este vacio
    //     if ($registro > 0 and count($registro) == 1) {
    //         $id_vendedor = $registro[0]['ven_id'];
    //         $data['NombreVendedor'] = $registro[0]['ven_nombre'] . ' ' . $registro[0]['ven_apellidos'];
    //     } else {
    //         $this->gsatelite->show_dialog('El usuario no es un vendedor', 'cotizaciones/index', 'note');
    //     }
    //     $crud = new grocery_CRUD();
    //     $crud->set_table('tbl_tabla_llamadas');
    //     $crud->set_subject('Llamada');
    //     $crud->where('tbl_id_ven', $id_vendedor);
    //     $crud->order_by('tbl_id', 'desc');
    //     $column = array('tbl_fecha', 'tbl_cliente_nombre', 'tbl_cliente_apellido', /* 'tbl_cliente', */ 'tbl_id_ven', 'tbl_recado');
    //     $add_fields = array('tbl_fecha', 'tbl_cliente_nombre', 'tbl_cliente_apellido', /* 'tbl_cliente', */ 'tbl_telefono', 'tbl_correo', 'tbl_direccion', 'tbl_id_sec', 'tbl_id_ven', 'tbl_contacto', 'tbl_nuevo', 'medios', 'tbl_usu_recibe', 'tbl_recado', 'tbl_fecha_mod', 'tbl_usu_mod', 'tbl_fecha_crea', 'tbl_usu_crea');
    //     $edit_fields = array(/* 'tbl_cliente', */'tbl_cliente_nombre', 'tbl_cliente_apellido', 'tbl_telefono', 'tbl_correo', 'tbl_direccion', 'tbl_id_sec', 'tbl_id_ven', 'tbl_contacto', 'tbl_nuevo', 'medios', 'tbl_usu_recibe', 'tbl_recado', 'tbl_fecha_mod', 'tbl_usu_mod');
    //     $alias = array(
    //         'tbl_fecha' => 'Fecha',
    //         'tbl_cliente_nombre' => 'Nombre',
    //         'tbl_cliente_apellido' => 'Apellido',
    //         //'tbl_cliente'=>'Cliente',
    //         'tbl_telefono' => 'Teléfono',
    //         'tbl_correo' => 'Correo',
    //         'tbl_direccion' => 'Dirección',
    //         'tbl_id_sec' => 'Sector Cliente',
    //         'tbl_id_ven' => 'Vendedor Asignado',
    //         'tbl_contacto' => 'Contacto',
    //         'tbl_nuevo' => '¿Cliente nuevo?',
    //         'medios' => 'Medio de contacto',
    //         'tbl_recado' => 'Recado',
    //     );
    //     $required = array('tbl_fecha', 'tbl_cliente_nombre', 'tbl_cliente_apellido', /* 'tbl_cliente', */ 'tbl_contacto', 'tbl_recado');
    //     $crud->add_fields($add_fields);
    //     $crud->edit_fields($edit_fields);
    //     $crud->columns($column);
    //     $crud->display_as($alias);
    //     $crud->required_fields($required);
    //     $crud->set_relation('tbl_id_sec', 'sec_sector_cliente', 'sec_nombre', array('sec_estado' => 1));
    //     $crud->set_relation('tbl_id_ven', 'ven_vendedor', '{ven_nombre} {ven_apellidos}', array('ven_estado' => 1));
    //     $crud->set_relation_n_n('medios', 'txt_tabla_llamadaxtipo_medio', 'tmc_tipo_medio', 'txt_id_tbl', 'txt_id_tmc', 'tmc_nombre')
    //     ->field_type('tbl_usu_mod', 'hidden', $this->tank_auth->get_user_id())
    //     ->set_rules('tbl_correo', 'Correo', 'trim|valid_email')
    //     ->field_type('tbl_usu_recibe', 'hidden', $this->tank_auth->get_user_id())
    //     ->field_type('tbl_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
    //     ->field_type('tbl_fecha', 'hidden', date('Y-m-d H:i:s'))
    //     ->field_type('tbl_usu_crea', 'hidden', $this->tank_auth->get_user_id())
    //     ->field_type('tbl_id_ven', 'hidden', $id_vendedor)
    //     ->field_type('tbl_fecha_crea', 'hidden', date('Y-m-d H:i:s'))
    //     ->field_type('tbl_nuevo', 'dropdown', array('0' => 'No', '1' => 'Sí'))
    //     ->unset_delete();
    //     $output = $crud->render();
    //     $data['texto_boton'] = "Consultar Cliente";
    //     if (end(explode('/', uri_string())) == 'add') {
    //         $data['texto_boton'] = "Agregar Cliente";
    //     }
    //     $data['titulo_personal'] = "Tabla de llamadas";

    //     $this->_cargarvista($data, $output);
    // }


    public function proyeccion_ventas()
    {
        satelite_validar();
        $data['permisos'] = $this->gsatelite->get_permisos_opcion();

        //preguntar si es supervisor o vendedor
        $condicion1 = array('sup_id_usu' => $this->tank_auth->get_user_id(), 'sup_estado' => 1);
        $esSup = $this->cotModel->Existe_Registro("sup_supervisor", $condicion1);
        $condicion2 = array('ven_id_usu' => $this->tank_auth->get_user_id(), 'ven_estado' => 1);
        $esVen = $this->cotModel->Existe_Registro("ven_vendedor", $condicion2);

        if ($esSup > 0) {
            $queryIdVen = $this->cotModel->get_idsVendedoresxSupervisor($this->tank_auth->get_user_id());
            $data['ven_permitidos'] = ($queryIdVen == 0) ? array(0) : explode(',', $queryIdVen);
            //$data['clientes'] = '';
        } elseif ($esVen > 0) {
            $filaVen = $this->cotModel->get_registro("ven_vendedor", "ven_id_usu", $this->tank_auth->get_user_id());
            $data['ven_permitidos'] = array($filaVen->ven_id);
            // $data['clientes'] = $this->gsatelite->get_dropdown('cli_cliente', '{cli_nombre} {cli_apellido}','', array('cli_estado' => 1,'cli_id_ven' => $filaVen->ven_id), null, '', 'cli_id', true);
        }

        $select_default = (count($data['ven_permitidos']) == 1) ? $data['ven_permitidos'][0] : null;
        $this->db->where_in('ven_id', $data['ven_permitidos']);
        $this->db->join('users', 'id = ven_id_usu', 'inner');
        $this->db->join('emp_empleado', 'emp_id = usu_id_emp', 'left');
        $data['vendedores'] = $this->gsatelite->get_dropdown('ven_vendedor', "{emp_codigo} - {ven_nombre} {ven_apellidos}", '', array('ven_estado' => 1), $select_default, '', 'ven_id', true);
        $data['titulo_personal'] = "Reporte de proyección de ventas";

        cargarvista($data);
    }

    /*
     * @author: Mario Marquez
     * Reporte de Proyección de ventas (Detalla el listado de Cotizaciones)
     * $flag 1 = Indica si el reporte es una consulta Ajax. Null = Impresión
     */

    function reporte_proyeccion_ventas($flag = null)
    {
        satelite_validar();
        if ($this->input->post()) {
            $post_array = $this->input->post();
            //die(var_dump($post_array));
            //Tipo de Reportes si sera Excel o Pdf
            $tipo_reporte = (isset($post_array['tipo_reporte']) && $post_array['tipo_reporte'] != '') ? $post_array['tipo_reporte'] : null;
            /*
             * Si es consulta ajax se toman los nombres del Jquery
             * De lo contrario, se toman los filtros de impresión
             */
            $orden = null;
            $productos = null;

            if ($flag != null) {
                $vendedores = ($post_array['vendedores'] != '') ? $post_array['vendedores'] : null;
                $fecha_ini = ($post_array['fecha_ini'] != '') ? formatear_fecha('Y-m-d', $post_array['fecha_ini']) : null;
                $fecha_fin = ($post_array['fecha_fin'] != '') ? formatear_fecha('Y-m-d', $post_array['fecha_fin']) : null;
            } else {
                $vendedores = ($post_array['filtro_vendedores'] != '') ? $post_array['filtro_vendedores'] : null;
                $fecha_ini = ($post_array['filtro_fecha_inicio'] != '') ? formatear_fecha('Y-m-d', $post_array['filtro_fecha_inicio']) : null;
                $fecha_fin = ($post_array['filtro_fecha_fin'] != '') ? formatear_fecha('Y-m-d', $post_array['filtro_fecha_fin']) : null;
            }

            /*
             * Se aplican los filtros
             */
            $where = null;
            $data['orden'] = null;
            $data['fecha_inicio'] = null;
            $data['fecha_fin'] = null;
            $data['cliente'] = null;
            $data['empleado'] = null;
            $idsVendedores = array();


            if ($vendedores != null) {
                $idsVendedores = explode(',', $vendedores);
            } else {
                $vendedores = $this->obtener_vendedores($this->tank_auth->get_user_id());

                $idsVendedores = array_column($vendedores, 'ven_id');
            }
            if ($fecha_ini != null && $fecha_fin != null) {
                $where['DATE(cot_fecha_cierre) >='] = $fecha_ini;
                $where['DATE(cot_fecha_cierre) <='] = $fecha_fin;
                $data['fecha_inicio'] = formatear_fecha('d-m-Y', $fecha_ini);
                $data['fecha_fin'] = formatear_fecha('d-m-Y', $fecha_fin);
            }


            $this->db->where_in('cot_id_ven', $idsVendedores);
            $data['reporte'] = $this->cotModel->report_proyeccion_ventas($where, 'cot_id ASC');
            //die(print_r($this->db->last_query()));
            $data['tipo_reporte'] = $tipo_reporte;

            $filename = 'rpt_proyeccion_ventas_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

            $data['filename'] = $filename;
            $html = $this->load->view('cotizaciones/consultas/reporte_proyeccion_ventas', $data, true);

            if ($flag) {
                echo $html;
            } else {
                if ($tipo_reporte == 'pdf') {
                    $this->load->library('pdf');

                    $data['titulo'] = 'Proyección de ventas';

                    $header = $this->load->view('reporte/header', $data, true);

                    $GLOBALS['nombre_reporte'] = 'Reporte_Proyeccion_Ventas_' . date('dmY');

                    $reporte = $header . $html;

                    //echo $reporte;die();
                    $this->pdf->SetMargins(10, 10, 10, 50);
                    $this->pdf->makePdf($reporte, 'L', 'Reporte_Proyeccion_Ventas', 'Letter');
                } elseif ($tipo_reporte == 'excel') {

                    $filename = 'rpt_pagos_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

                    $data['titulo'] = 'Proyección de ventas';

                    $data['filename'] = $filename;

                    echo $html;
                }
            }
        }
    }

    function obtener_vendedores($usuario)
    {

        $user_id = ($usuario != null) ? $usuario : $this->tank_auth->get_user_id();

        //preguntar si es supervisor o vendedor
        $condicion1 = array('sup_id_usu' => $user_id, 'sup_estado' => 1);
        $esSup = $this->cotModel->Existe_Registro("sup_supervisor", $condicion1);
        $condicion2 = array('ven_id_usu' => $user_id, 'ven_estado' => 1);
        $esVen = $this->cotModel->Existe_Registro("ven_vendedor", $condicion2);

        if ($esSup > 0) {
            $queryIdVen = $this->cotModel->get_idsVendedoresxSupervisor($user_id);
            $data['ven_permitidos'] = ($queryIdVen == 0) ? array(0) : explode(',', $queryIdVen);
            //$data['clientes'] = '';
        } elseif ($esVen > 0) {
            $filaVen = $this->cotModel->get_registro("ven_vendedor", "ven_id_usu", $user_id);
            $data['ven_permitidos'] = array($filaVen->ven_id);
            // $data['clientes'] = $this->gsatelite->get_dropdown('cli_cliente', '{cli_nombre} {cli_apellido}','', array('cli_estado' => 1,'cli_id_ven' => $filaVen->ven_id), null, '', 'cli_id', true);
        }

        $this->db->where_in('ven_id', $data['ven_permitidos']);
        $this->db->join('users', 'id = ven_id_usu', 'inner');
        $this->db->join('emp_empleado', 'emp_id = usu_id_emp', 'left');
        $vendedores = $this->gsatelite->get_tabla('ven_vendedor', array('ven_estado' => 1));

        return $vendedores;
    }

    /*
     * @author: Habby Lovo
     * Reporte para el listado de proyectos por cliente
     */

    function listado_proyectos($consulta = 0)
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data['permisos'] = $this->gsatelite->get_permisos_opcion('cotizaciones/consultas/listado_proyectos');
            if ($_POST) {
                if ($consulta > 0) {
                    $post_array = $_POST;

                    $cliente = $post_array['cliente'];
                    $proyecto = $post_array['proyecto'];
                    $estado = $post_array['estado'];

                    $data['cliente_id']  = $cliente;
                    $data['proyecto']  = $proyecto;
                    $data['estado']   = $estado;

                    $where = null;

                    if (trim($cliente) != "") {
                        $where['pcl_id_cli'] = $cliente;
                    }
                    if (trim($proyecto) != "") {
                        $where['pcl_id'] = $proyecto;
                    }
                    if (trim($estado) != "") {
                        $where['pcl_id_epr'] = $estado;
                    }

                    $proyectos = $this->cotModel->get_ReporteListadoProyecto($where);

                    $data['proyectos'] = $proyectos;
                    $data['tipo_reporte'] = 'grid';
                    $html = $this->load->view('cotizaciones/consultas/reporte_listado_proyectos', $data, true);
                    echo $html;
                    die();
                }
            } else {
                $cli = $this->gsatelite->get_tabla('cli_cliente', array('cli_estado' => 1));
                $est = $this->gsatelite->get_tabla('epr_estado_proyecto', array('epr_estado' => 1));
                $data['clientes'] = str_replace('<option value="0"></option>', '', $cli);
                $data['estados'] = str_replace('<option value="0"></option>', '', $est);
                $data['titulo_personal'] = "Listado de proyectos";
                $this->_cargarvista($data);
            }
        }
    }
    public function reporte_listado_proyectos()
    {
        $post_array = $_POST;

        $cliente = $post_array['rpt_cliente'];
        $proyecto = $post_array['rpt_proyecto'];
        $estado = $post_array['rpt_estado'];
        $tipo = $post_array['rpt_tipo'];


        $data['cliente_id']  = $cliente;
        $data['proyecto']  = $proyecto;
        $data['estado']   = $estado;

        $where = null;

        if (trim($cliente) != "") {
            $where['pcl_id_cli'] = $cliente;
        }
        if (trim($proyecto) != "") {
            $where['pcl_id'] = $proyecto;
        }
        if (trim($estado) != "") {
            $where['pcl_id_epr'] = $estado;
        }

        $proyectos = $this->cotModel->get_ReporteListadoProyecto($where);

        $data['proyectos'] = $proyectos;
        $data['tipo_reporte'] = $tipo;

        if ($tipo == 'excel') {
            $filename = 'rpt_listado_proyectos' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename'] = $filename;

            $this->load->view('cotizaciones/consultas/reporte_listado_proyectos', $data);
        } else {
            $this->load->library('pdf');
            $data['titulo'] = 'Listado de proyectos';
            $data['solotitulo'] = '1';

            $header = $this->load->view('reporte/header', $data, true);

            $html = $this->load->view('cotizaciones/consultas/reporte_listado_proyectos', $data, true);
            $GLOBALS['nombre_reporte'] = 'rpt_listado_proyectos' . date('dmY');

            $this->pdf->makePdf($header . $html, 'L', 'rpt_listado_proyectos', 'Letter');
        }
    }

    /*
     * @author: Habby Lovo
     * Reporte para cotizaciones por proyecto detallado
     */

    public function detallado_cotizaciones_proyecto($consulta = 0)
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data['permisos'] = $this->gsatelite->get_permisos_opcion('cotizaciones/consultas/detallado_cotizaciones_proyecto');
            $data['simbolo'] = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');
            if ($_POST) {
                if ($consulta > 0) {
                    $post_array = $_POST;

                    $fecha_ini = date('Y-m-d 00:00:00', strtotime($post_array['fecha_ini']));
                    $fecha_fin = date('Y-m-d 23:59:59', strtotime($post_array['fecha_fin']));
                    $cliente = $post_array['cliente'];
                    $proyecto = $post_array['proyecto'];
                    $cotizacion = $post_array['cotizacion'];
                    $estado = $post_array['estado'];

                    $data['fecha_ini'] = $fecha_ini;
                    $data['fecha_fin'] = $fecha_fin;
                    $data['cliente_id']  = $cliente;
                    $data['proyecto']  = $proyecto;
                    $data['cotizacion'] = $cotizacion;
                    $data['estado']   = $estado;

                    $where = null;

                    if ($fecha_ini != '' && $fecha_fin != '') {
                        $where = array('cot_fecha >=' => $fecha_ini, 'cot_fecha <=' => $fecha_fin);
                    }
                    if (trim($cliente) != "") {
                        $where['cot_id_cli'] = $cliente;
                    }
                    if (trim($proyecto) != "") {
                        $where['pcl_id'] = $proyecto;
                    }
                    if (trim($cotizacion != "")) {
                        $where['cot_id'] = $cotizacion;
                    }
                    if (trim($estado) != "") {
                        $where['pcl_id_epr'] = $estado;
                    }
                    $where['cot_estado'] = 1;
                    $proyectos = $this->cotModel->get_CotizacionProyectoDetallado($where);

                    $data['proyectos'] = $proyectos;
                    $data['tipo_reporte'] = 'grid';
                    $html = $this->load->view('cotizaciones/consultas/reporte_cotizaciones_proyecto_det', $data, true);
                    echo $html;
                    die();
                }
            } else {
                $cli = $this->gsatelite->get_tabla('cli_cliente', array('cli_estado' => 1));
                $data['clientes'] = str_replace('<option value="0"></option>', '', $cli);
                $data['titulo_personal'] = "Detallado de cotizaciones por proyecto";
                $this->_cargarvista($data);
            }
        }
    }

    public function reporte_cotizaciones_proyecto_det()
    {
        $post_array = $_POST;

        $fecha_ini = date('Y-m-d 00:00:00', strtotime($post_array['filtro_ini']));
        $fecha_fin = date('Y-m-d 23:59:59', strtotime($post_array['filtro_fin']));
        $cliente = $post_array['rpt_cliente'];
        $proyecto = $post_array['rpt_proyecto'];
        $cotizacion = $post_array['rpt_cotizacion'];
        $estado = $post_array['rpt_estado'];
        $tipo = $post_array['rpt_tipo'];

        $data['fecha_ini'] = $fecha_ini;
        $data['fecha_fin'] = $fecha_fin;
        $data['cliente_id']  = $cliente;
        $data['proyecto']  = $proyecto;
        $data['cotizacion'] = $cotizacion;
        $data['estado']   = $estado;
        $data['simbolo'] = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');

        $where = null;

        if ($fecha_ini != '' && $fecha_fin != '') {
            $where = array('cot_fecha >=' => $fecha_ini, 'cot_fecha <=' => $fecha_fin);
        }
        if (trim($cliente) != "") {
            $where['cot_id_cli'] = $cliente;
            $cliente_data = $this->gsatelite->get_tabla('cli_cliente', array('cli_id' => $cliente));
            $nombre_cliente = $cliente_data[0]['cli_codigo'] . ' ' . $cliente_data[0]['cli_nombre'] . ' ' . $cliente_data[0]['cli_apellido'];
            if ($cliente_data[0]['cli_personeria'] == 2) {
                $nombre_cliente = $cliente_data[0]['cli_codigo'] . ' - ' . $cliente_data[0]['cli_apellido'];
            }
            $data['cliente'] = $nombre_cliente;
        }
        if (trim($proyecto) != "") {
            $where['pcl_id'] = $proyecto;
            $proyecto_data = $this->gsatelite->get_tabla('pcl_proyecto_cliente', array('pcl_id' => $proyecto));
            $nombre_proyecto = $proyecto_data[0]['pcl_codigo'] . ' - ' . $proyecto_data[0]['pcl_nombre'];
            $data['pro'] = $nombre_proyecto;
        }
        if (trim($cotizacion != "")) {
            $where['cot_id'] = $cotizacion;
        }
        if (trim($estado) != "") {
            $where['pcl_id_epr'] = $estado;
        }

        $proyectos = $this->cotModel->get_CotizacionProyectoDetallado($where);

        $data['proyectos'] = $proyectos;
        $data['tipo_reporte'] = $tipo;

        if ($tipo == 'excel') {
            $filename = 'rpt_detallado_cotizacion_proyecto' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename'] = $filename;

            $this->load->view('cotizaciones/consultas/reporte_cotizaciones_proyecto_det', $data);
        } else {
            $this->load->library('pdf');
            $data['titulo'] = 'Detallado de cotizaciones por proyecto';
            $data['solotitulo'] = '1';

            $header = $this->load->view('reporte/header', $data, true);

            $html = $this->load->view('cotizaciones/consultas/reporte_cotizaciones_proyecto_det', $data, true);
            $GLOBALS['nombre_reporte'] = 'rpt_cosolidado_cotizacion_proyecto' . date('dmY');

            $this->pdf->makePdf($header . $html, 'L', 'rpt_cosolidado_cotizacion_proyecto', 'Letter');
        }
    }

    /*
     * @author: Habby Lovo
     * Reporte para cotizaciones por proyecto consolidado
     */

    public function consolidado_cotizaciones_proyecto($consulta = 0)
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data['permisos'] = $this->gsatelite->get_permisos_opcion('cotizaciones/consultas/consolidado_cotizaciones_proyecto');
            $data['simbolo'] = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');
            if ($_POST) {
                if ($consulta > 0) {
                    $post_array = $_POST;

                    $fecha_ini = date('Y-m-d 00:00:00', strtotime($post_array['fecha_ini']));
                    $fecha_fin = date('Y-m-d 23:59:59', strtotime($post_array['fecha_fin']));
                    $cliente = $post_array['cliente'];
                    $proyecto = $post_array['proyecto'];
                    $estado = $post_array['estado'];

                    $data['fecha_ini'] = $fecha_ini;
                    $data['fecha_fin'] = $fecha_fin;
                    $data['cliente_id']  = $cliente;
                    $data['proyecto']  = $proyecto;
                    $data['estado']   = $estado;


                    $where = null;

                    if ($fecha_ini != '' && $fecha_fin != '') {
                        $where = array('cot_fecha >=' => $fecha_ini, 'cot_fecha <=' => $fecha_fin);
                    }
                    if (trim($cliente) != "") {
                        $where['cot_id_cli'] = $cliente;
                    }
                    if (trim($proyecto) != "") {
                        $where['pcl_id'] = $proyecto;
                    }
                    if (trim($estado) != "") {
                        $where['pcl_id_epr'] = $estado;
                    }
                    $where['cot_estado'] = 1;
                    $proyectos = $this->cotModel->get_CotizacionProyectoConsolidado($where);

                    $data['proyectos'] = $proyectos;
                    $data['tipo_reporte'] = 'grid';

                    $html = $this->load->view('cotizaciones/consultas/reporte_cotizaciones_proyecto_cons', $data, true);
                    echo $html;
                    die();
                }
            } else {
                $cli = $this->gsatelite->get_tabla('cli_cliente', array('cli_estado' => 1));
                $data['clientes'] = str_replace('<option value="0"></option>', '', $cli);
                $data['titulo_personal'] = "Consolidado de cotizaciones por proyecto";
                $this->_cargarvista($data);
            }
        }
    }
    public function reporte_cotizaciones_proyecto_cons()
    {
        $post_array = $_POST;

        $fecha_ini = date('Y-m-d 00:00:00', strtotime($post_array['filtro_ini']));
        $fecha_fin = date('Y-m-d 23:59:59', strtotime($post_array['filtro_fin']));
        $cliente = $post_array['rpt_cliente'];
        $proyecto = $post_array['rpt_proyecto'];
        $estado = $post_array['rpt_estado'];
        $tipo = $post_array['rpt_tipo'];

        $data['fecha_ini'] = $fecha_ini;
        $data['fecha_fin'] = $fecha_fin;
        $data['cliente_id']  = $cliente;
        $data['proyecto']  = $proyecto;
        $data['estado']   = $estado;
        $data['simbolo'] = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');

        $where = null;

        if ($fecha_ini != '' && $fecha_fin != '') {
            $where = array('cot_fecha >=' => $fecha_ini, 'cot_fecha <=' => $fecha_fin);
        }
        if (trim($cliente) != "") {
            $where['cot_id_cli'] = $cliente;
        }
        if (trim($proyecto) != "") {
            $where['pcl_id'] = $proyecto;
        }
        if (trim($estado) != "") {
            $where['pcl_id_epr'] = $estado;
        }

        $proyectos = $this->cotModel->get_CotizacionProyectoConsolidado($where);

        $data['proyectos'] = $proyectos;
        $data['tipo_reporte'] = $tipo;

        if ($tipo == 'excel') {
            $filename = 'rpt_cosolidado_cotizacion_proyecto' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename'] = $filename;

            $this->load->view('cotizaciones/consultas/reporte_cotizaciones_proyecto_cons', $data);
        } else {
            $this->load->library('pdf');
            $data['titulo'] = 'Consolidado de cotizaciones por proyecto';
            $data['solotitulo'] = '1';

            $header = $this->load->view('reporte/header', $data, true);

            $html = $this->load->view('cotizaciones/consultas/reporte_cotizaciones_proyecto_cons', $data, true);
            $GLOBALS['nombre_reporte'] = 'rpt_cosolidado_cotizacion_proyecto' . date('dmY');

            $this->pdf->makePdf($header . $html, 'L', 'rpt_cosolidado_cotizacion_proyecto', 'Letter');
        }
    }

    public function get_proyectos()
    {
        $cli = $this->input->post('cliente');
        $select = '<option value=""></option>';
        $proyectos = $this->cotModel->get_FiltrosEstadoProyecto(array('cot_id_cli' => $cli));
        foreach ($proyectos as $key) {
            $select .= '<option value="' . $key["pcl_id"] . '">' . $key["pcl_codigo"] . ' - ' . $key["pcl_nombre"] . '</option>';
        }
        $opcion = '<option value=""></option>';
        $eta_pro = $this->cotModel->get_FiltrosEstadoProyecto(array('pcl_id_cli' => $cli));
        foreach ($eta_pro as $key) {
            $opcion .= '<option value="' . $key["epr_id"] . '">' . $key["epr_nombre"] . '</option>';
        }
        echo json_encode(array('proyectos' => $select, 'estado' => $opcion));
    }

    public function get_estado_cotizaciones_cliente()
    {
        $cli_id = $this->input->post('cli');
        $opcion = '<option value=""></option>';
        $eta_pro = $this->cotModel->get_FiltrosEstadoProyecto(array('cot_id_cli' => $cli_id));
        foreach ($eta_pro as $key) {
            $opcion .= '<option value="' . $key["epr_id"] . '">' . $key["epr_nombre"] . '</option>';
        }
        echo json_encode(array('resp' => $opcion));
    }

    public function get_estado_cotizaciones_proyecto()
    {
        $pro_id = $this->input->post('proyecto');
        $opcion = '';
        $eta_pro = $this->cotModel->get_FiltrosEstadoProyecto(array('pcl_id' => $pro_id));
        foreach ($eta_pro as $key) {
            $opcion .= '<option value="' . $key["epr_id"] . '">' . $key["epr_nombre"] . '</option>';
        }
        $opc = '<option value=""></option>';
        $cot = $this->cotModel->get_CotizacionProyectoConsolidado(array('cot_id_pcl' => $pro_id));
        foreach ($cot as $key) {
            $opc .= '<option value="' . $key["cot_id"] . '">' . $key["cot_codigo"] . '</option>';
        }
        echo json_encode(array('resp' => $opcion, 'cotizacion' => $opc));
    }

    public function get_proyectos_cliente()
    {
        $cli_id = $this->input->post('cliente');
        $select = '<option value=""></option>';
        $proyectos = $this->gsatelite->get_tabla('pcl_proyecto_cliente', array('pcl_id_cli' => $cli_id));
        foreach ($proyectos as $key) {
            $select .= '<option value="' . $key["pcl_id"] . '">' . $key["pcl_codigo"] . ' - ' . $key["pcl_nombre"] . '</option>';
        }
        echo json_encode(array('resp' => $select));
    }

    public function get_estado_proyecto_x_cliente()
    {
        $cli_id = $this->input->post('cli');
        $opcion = '<option value=""></option>';
        $eta_pro = $this->cotModel->get_estados_proyectos(array('pcl_id_cli' => $cli_id));
        foreach ($eta_pro as $key) {
            $opcion .= '<option value="' . $key["epr_id"] . '">' . $key["epr_nombre"] . '</option>';
        }
        echo json_encode(array('resp' => $opcion));
    }

    public function get_estado_proyecto()
    {
        $pro_id = $this->input->post('proyecto');
        $opciones = '';
        $eta_pro = $this->cotModel->get_estado_proyecto_cliente(array('pcl_id' => $pro_id));
        foreach ($eta_pro as $key) {
            $opciones .= '<option value="' . $key["epr_id"] . '">' . $key["epr_nombre"] . '</option>';
        }
        echo json_encode(array('resp' => $opciones));
    }

    // Rafael A. Cuchilla
    public function informe_presupuesto_cot($axc_id = NULL, $cot_id = null)
    {
        $data['articulo'] = $this->cotModel->listaarticulo($axc_id);
        $data['cot_id'] = $cot_id;
        $producto = $this->cotModel->get_detalle_cotizacion(array('axc_id' => $axc_id));
        $data['producto'] = $producto[0];
        //Se carga el presupuesto de la cotización en caso de que exista.
        $data['materia_prima_prod'] = $this->cotModel->get_materia_prima_presupuesto_cot(array('axr_id_axc' => $axc_id));
        $data['mano_obra_prod'] = $this->cotModel->get_mano_obra_presupuesto_cot(array('mxa_id_axc' => $axc_id));
        $data['gastos_indirectos'] = $this->cotModel->get_gastos_indirectos_presupuesto_cot(array('exa_id_axc' => $axc_id));
        //Se carga el presupuesto del producto en caso de que la cotización no posea uno.
        if (count($data['materia_prima_prod']) <= 0 && count($data['mano_obra_prod']) <= 0 && count($data['gastos_indirectos']) <= 0) {
            $receta = $this->gsatelite->get_campo('rea_receta_articulo', 'rea_id', array('rea_estado' => 1, 'rea_defecto' => 1, 'rea_id_art' => $producto[0]['axc_id_art']));
            $data['materia_prima_prod'] = $this->proyecto_model->get_materia_prima_producto_segun_receta(array('mpa_id_art' => $producto[0]['axc_id_art'], 'mpa_id_rea' => $receta));
            $data['mano_obra_prod'] = $this->cotModel->get_mano_obra_presupuesto(array('moa_id_art' => $producto[0]['axc_id_art'], 'moa_id_rea' => $receta));
            $data['gastos_indirectos'] = $this->cotModel->get_gastos_indirectos_presupuesto(array('esr_id_art' => $producto[0]['axc_id_art'], 'esr_id_rea' => $receta));
        }
        $cotizacion = $this->cotModel->get_cotizacion(array('cot_id' => $producto[0]['axc_id_cot']));
        $data['cotizacion'] = $cotizacion[0];
        $this->load->library('pdf');
        $data['titulo'] = 'Reporte de Materiales';
        $data['solotitulo'] = '1';
        $header = $this->load->view('reporte/header', $data, true);
        $html = $this->load->view('cotizaciones/consultas/informe_presupuesto_cot', $data, true);
        $GLOBALS['nombre_reporte'] = 'rpt_informe_presupuesto' . date('dmY');
        $this->pdf->makePdf($header . $html, 'L', 'rpt_informe_presupuesto', 'Letter');
    }

    /*
    *  Raul E. 
    */
    public function costeo_receta($flag = null)
    {
        satelite_validar();
        if ($_POST) {
            $art_id = $this->input->post('producto');
            $report = $this->input->post('tipo_reporte');
            $materia_prima = $this->proyecto_model->get_materia_prima_producto_segun_receta(array('mpa_id_art' => $art_id));
            $mano_obra_dir = $this->cotModel->get_mano_obra_presupuesto(array('moa_id_art' => $art_id));
            $gastos_indirc = $this->cotModel->get_gastos_indirectos_presupuesto(array('esr_id_art' => $art_id));
            if (!(count($materia_prima) > 0) && !(count($mano_obra_dir) > 0) && !(count($gastos_indirc) > 0)) {
                $data['vacio'] = 1;
                $filas = 0;
            } else {
                $data['vacio'] = 0;
                $data['mat_prima'] = $materia_prima;
                $data['mano_obra'] = $mano_obra_dir;
                $data['otros_gts'] = $gastos_indirc;
                $filas = count($materia_prima) + count($mano_obra_dir) + count($gastos_indirc);
            }
            $this->db->limit(1);
            $this->db->join('cva_conversion_articulo', 'cva_id_mep = mep_id');
            $data['cva_medida'] = $this->gsatelite->get_campo('mep_medida_producto', 'mep_nombre', array('cva_id_art' => $art_id, 'cva_defecto' => 1, 'cva_estado' => 1));
            $data['articulo'] = $this->gsatelite->get_tabla('art_articulo', array('art_id' => $art_id));
            $data['reporte'] = $report;
            $data['filename'] = 'Costeo_Producto';
            $data['decimal'] = $this->gsatelite->get_parametro('NUMERO_DECIMALES', 2);
            $html = $this->load->view('cotizaciones/consultas/informe_costeo_receta', $data, true);
            if ($flag) {
                $resultado = array('filas' => $html, 'cantidad' => $filas);
                echo json_encode($resultado);
                die();
            } else {
                if ($report == 'pdf') {
                    $data['titulo'] = 'Costeo de Producto';
                    $header = $this->load->view('reporte/header', $data, true);
                    $reporte = $header . $html;
                    $GLOBALS['nombre_reporte'] = 'rpt_costeo_producto' . date('dmY');
                    $this->pdf->makePdf($reporte, 'L', 'costeo_producto', 'Letter');
                } else {
                    echo $html;
                }
            }
        } else {
            $data['titulo_personal'] = "Costeo de Producto";
            $this->_cargarvista($data);
        }
    }

    // Rafael A. Cuchilla
    public function informe_ganancias_cot($axc_id = NULL, $cot_id = null)
    {
        $data['articulo'] = $this->cotModel->listaarticulo($axc_id);
        $data['cot_id']   = $cot_id;
        $producto         = $this->cotModel->get_detalle_cotizacion(array('axc_id' => $axc_id));
        $data['producto'] = $producto[0];
        //Se carga el presupuesto de la cotización en caso de que exista.
        $data['materia_prima_prod'] = $this->cotModel->get_materia_prima_presupuesto_cot(array('axr_id_axc' => $axc_id));
        $data['mano_obra_prod']     = $this->cotModel->get_mano_obra_presupuesto_cot(array('mxa_id_axc' => $axc_id));
        $data['gastos_indirectos']  = $this->cotModel->get_gastos_indirectos_presupuesto_cot(array('exa_id_axc' => $axc_id));
        $data['receta'] = 0;
        //Se carga el presupuesto del producto en caso de que la cotización no posea uno.
        if (count($data['materia_prima_prod']) <= 0 && count($data['mano_obra_prod']) <= 0 && count($data['gastos_indirectos']) <= 0) {
            $data['receta'] = 1;
            $receta = $this->gsatelite->get_campo('rea_receta_articulo', 'rea_id', array('rea_estado' => 1, 'rea_defecto' => 1, 'rea_id_art' => $producto[0]['axc_id_art']));
            $data['materia_prima_prod'] = $this->proyecto_model->get_materia_prima_producto_segun_receta(array('mpa_id_art' => $producto[0]['axc_id_art'], 'mpa_id_rea' => $receta));
            $data['mano_obra_prod'] = $this->cotModel->get_mano_obra_presupuesto(array('moa_id_art' => $producto[0]['axc_id_art'], 'moa_id_rea' => $receta));
            $data['gastos_indirectos'] = $this->cotModel->get_gastos_indirectos_presupuesto(array('esr_id_art' => $producto[0]['axc_id_art'], 'esr_id_rea' => $receta));
        }
        $cotizacion = $this->cotModel->get_cotizacion(array('cot_id' => $producto[0]['axc_id_cot']));
        $data['cotizacion'] = $cotizacion[0];
        $this->load->library('pdf');
        $data['titulo'] = 'Informe de Ganancias';
        $data['solotitulo'] = '1';
        $header = $this->load->view('reporte/header', $data, true);
        $html = $this->load->view('cotizaciones/consultas/informe_ganancias_cot', $data, true);
        $GLOBALS['nombre_reporte'] = 'rpt_informe_presupuesto' . date('dmY');

        $this->pdf->makePdf($header . $html, 'L', 'rpt_informe_presupuesto', 'Letter');
    }


    /**
     * Descripción:
     * Función para reporte de Seguimiento de cliente
     * @author Elman Ortiz - Grupo Satélite
     * @since 2019-02-20
     * @param $flag = valor que identifica si es reporte o impresion de html
     * @return Obtener Retorna html o reporte
     */
    function reporte_seguimiento_cotizaciones($flag = null)
    {
        satelite_validar();
        if ($_POST) {

            $post_array = $this->input->post();
            //print_r($post_array); die();
            /*
             * Si es consulta ajax se toman los nombres del Jquery
             * De lo contrario, se toman los filtros de impresión
            */
            if ($flag) {
                $fecha_inicio   = ($post_array['fecha_inicio'] != '') ? $post_array['fecha_inicio'] : null;
                $fecha_fin      = ($post_array['fecha_inicio'] != '') ? $post_array['fecha_fin'] : null;
                $cliente        = ($post_array['cliente'] != '') ? $post_array['cliente'] : null;
                $cotizacionpor  = ($post_array['seguimientopor'] != '') ? $post_array['seguimientopor'] : null;
            } else {
                $fecha_inicio   = ($post_array['htxtFechaIni'] != '') ? $post_array['htxtFechaIni'] : null;
                $fecha_fin      = ($post_array['htxtFechaFin'] != '') ? $post_array['htxtFechaFin'] : null;
                $cliente      = ($post_array['hslcCliente'] != '') ? $post_array['hslcCliente'] : null;
                $cotizacionpor  = ($post_array['hslcSeguimientoPor'] != '') ? $post_array['hslcSeguimientoPor'] : null;
                $data['hslcClientetext'] = ($post_array['hslcClientetext'] != '') ? '<b>Cliente: </b>' . $post_array['hslcClientetext'] : '<b>Cliente: </b>' . 'Todos';
                $data['hslcSeguimientoPortext']     = ($post_array['hslcSeguimientoPortext'] != '') ? '<b>Departamento: </b>' . $post_array['hslcSeguimientoPortext'] : '<b>Departamento: </b>' . 'Todos';
            }

            //Tipo de Reportes si sera Excel o Pdf
            $tipo_reporte = $this->input->post('tipo_reporte');

            $where = null;
            $where_in = null;


            if ($cliente != 'null') {
                $where_in        = $cliente;
            }
            //print_r($where_in); die();

            //$where['cot_estado']        = 1;

            switch ($cotizacionpor) {
                case 1: //Cotizacion
                    if ($fecha_inicio != null) {
                        $where['seg_fecha >=']    = formatear_fecha('Y-m-d 00:00:00', $fecha_inicio);
                    }

                    if ($fecha_fin != null) {
                        $where['seg_fecha <=']    = formatear_fecha('Y-m-d 23:59:59', $fecha_fin);
                    }
                    $reporte = $this->cotModel->get_seguimientos_cotizacion($where, $where_in);
                    break;
                case 2: //base de datos
                    if ($fecha_inicio != null) {
                        $where['sgd_fecha >=']    = formatear_fecha('Y-m-d 00:00:00', $fecha_inicio);
                    }
                    if ($fecha_fin != null) {
                        $where['sgd_fecha <=']    = formatear_fecha('Y-m-d 23:59:59', $fecha_fin);
                    }
                    $reporte = $this->cotModel->get_seguimientos_llamada($where, $where_in);
                    //print_r($this->db->last_query());die();
                    break;
                case 3: //Administracion cliente
                    if ($fecha_inicio != null) {
                        $where['sec_fecha >=']    = formatear_fecha('Y-m-d 00:00:00', $fecha_inicio);
                    }
                    if ($fecha_fin != null) {
                        $where['sec_fecha <=']    = formatear_fecha('Y-m-d 23:59:59', $fecha_fin);
                    }
                    $reporte = $this->cotModel->get_seguimientos_x_administracion_cliente($where, $where_in);
                    break;
                default:

                    if ($fecha_inicio != null) {
                        $where['seg_fecha >=']    = formatear_fecha('Y-m-d 00:00:00', $fecha_inicio);
                    }

                    if ($fecha_fin != null) {
                        $where['seg_fecha <=']    = formatear_fecha('Y-m-d 23:59:59', $fecha_fin);
                    }
                    $seg_cot = $this->cotModel->get_seguimientos_cotizacion($where, $where_in); //cotizacion

                    $where = '';

                    if ($fecha_inicio != null) {
                        $where['sgd_fecha >=']    = formatear_fecha('Y-m-d 00:00:00', $fecha_inicio);
                    }
                    if ($fecha_fin != null) {
                        $where['sgd_fecha <=']    = formatear_fecha('Y-m-d 23:59:59', $fecha_fin);
                    }
                    $seg_db = $this->cotModel->get_seguimientos_llamada($where, $where_in); //base de datos

                    $where = '';

                    if ($fecha_inicio != null) {
                        $where['sec_fecha >=']    = formatear_fecha('Y-m-d 00:00:00', $fecha_inicio);
                    }
                    if ($fecha_fin != null) {
                        $where['sec_fecha <=']    = formatear_fecha('Y-m-d 23:59:59', $fecha_fin);
                    }
                    $seg_admon_cli = $this->cotModel->get_seguimientos_x_administracion_cliente($where, $where_in); //administracion cliente

                    $reporte = array_merge($seg_cot, $seg_db, $seg_admon_cli);

                    break;
            }
            //print_r($this->db->last_query()); die();
            $filename = 'rpt_reporte_seguimiento_cliente' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename']              = $filename;
            $data['reporte']               = $reporte;
            $data['tipo_reporte']          = $tipo_reporte;

            $html = $this->load->view('cotizaciones/consultas/filtrar_reporte_seguimiento_cotizaciones', $data, true);

            if ($flag) {
                echo $html;
                die();
            } else {
                if ($tipo_reporte == 'pdf') {

                    $data['titulo'] = 'seguimiento de cliente';

                    $header = $this->load->view('reporte/header', $data, true);

                    $GLOBALS['nombre_reporte'] = 'reporte_seguimiento_cliente_' . date('dmY');

                    $reporte = $header . $html;

                    $this->pdf->makePdf($reporte, 'L', 'reporte_seguimiento_cliente', 'Letter');
                } elseif ($tipo_reporte == 'excel') {

                    $filename = 'rpt_seguimiento_cliente_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

                    $data['titulo'] = 'seguimiento de cliente';

                    $data['filename'] = $filename;

                    echo $html;
                }
            }
        } else {

            //Select cliente
            //$data["slcCliente"] =  $this->cotModel->get_cliente_con_seguimiento_x_cotizacion();
            //print_r($this->db->last_query()); die();
            $data['titulo_personal'] = "Seguimiento de cliente";
            $this->_cargarvista($data);
        }
    }

    function get_cliente_con_seguimiento()
    {
        $seguimientopor = $this->input->post('seguimientopor');
        switch ($seguimientopor) {
            case 2: //Llamada
                $resultado = $this->cotModel->get_cliente_con_seguimiento_x_llamada();
                break;
            case 3: //Administracion cliente
                $resultado = $this->cotModel->get_cliente_con_seguimiento_x_administracion_cliente();
                //print_r($this->db->last_query()); die();
                # code...
                break;
            default: //Cotizacion
                $resultado = $this->cotModel->get_cliente_con_seguimiento_x_cotizacion();
                break;
        }

        $html = '<option value=""></option>';
        foreach ($resultado as $key => $res) {
            $html .= '<option value="' . $res['cli_id'] . '">' . $res['cli_nombre'] . '</option>';
        }

        echo $html;
    }

    function _cargarvista($data = 0, $crud = 0)
    {
        $this->load->view('vacia', $crud);
        if ($data != 0)
            $data = array_merge($data, $this->masterpage->getUsuario());
        else
            $data = $this->masterpage->getUsuario();
        $vista = $data['modulo'] . '/' . $data['control'] . '/' . $data['funcion'];
        $this->masterpage->setMasterPage('masterpage_default');
        $this->masterpage->addContentPage($vista, 'content', $data);
        $this->masterpage->show();
    }

    /**
     * 
     * @author Nelson Soriano
     * @since  19-02-2019
     * @param  none
     * Descripcion: crea la vista con los filtros del reporte
     */

    public function reporte_presupuesto()
    {
        $data['permisos']        = $this->gsatelite->get_permisos_opcion();
        $data['categorias']      = $this->gsatelite->get_dropdown('tia_tipo_articulo', '{tia_codigo} - {tia_nombre}', 'categorias', array('tia_estado' => 1, 'tia_padre' => null), null, null, null, true);
        $data['titulo_personal'] = 'Presupuesto';
        $select = $this->gsatelite->get_dropdown('art_articulo', '{art_codigo} - {art_nombre}', '', array('art_estado' => 1), null, '', 'art_id', true);
        $data["articulo"] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $select);
        cargarvista($data);
    }

    /**
     * Consultas:Reporte de presupuesto
     * @author Nelson Soriano
     * @since  19-02-2019
     * @param  parametros de busqueda [fecha,producto,categoria]
     */
    public function mostrar_presupuesto($reporte = null)
    {
        satelite_validar();
        ini_set('memory_limit', '2048M');
        ini_set('max_execution_time', '9999');

        $inicio   = $this->input->post('txtFecha_desde');
        $fin      = $this->input->post('txtFecha_hasta');
        $prod     = $this->input->post('slcProducto');
        $tia      = $this->input->post('tia_cont');
        $tipo     = $this->input->post('tipo_accion');
        $cara     = $this->input->post('slcCaracteristicas');
        $where    = null;
        $prod     = ($prod == 'null') ? '' : $prod;
        $filtro_titulo = '';
        if ($prod != '') {
            $where['art_id']  = $prod;
            $data['producto'] = $prod;
            $producto_nombre  = $this->gsatelite->get_campo('art_articulo', 'art_nombre', array('art_id' => $prod));
            $filtro_titulo   .= 'Producto: ' . $producto_nombre . '<br>';
        }
        if ($tia != '') {
            $where['art_id_tia'] = $tia;
            $data['tia']         = $tia;
            $tia_nombre = $this->gsatelite->get_campo('tia_tipo_articulo', 'tia_nombre', array('tia_id' => $tia));
            $filtro_titulo .= 'Categoria: ' . $tia_nombre . '';
        }
        $data['es_reporte'] = $reporte;
        if ($tipo) {
            $data['es_reporte'] = '';
        }
        if ($cara) {
            if ((is_array($cara)) && (count($cara) > 0)) {
                $op = implode(',', $cara);
                $where2['cxu_id in (' . $op . ')'] = null;
            }
        }
        $data['info'] =  $this->cotModel->get_presupuestos($where);
        $datos = array();
        $materia = array();
        $mano_obra = array();
        foreach ($data['info'] as $key => $value) {
            $receta     = $this->gsatelite->get_campo('rea_receta_articulo', 'rea_id', array('rea_estado' => 1, 'rea_defecto' => 1, 'rea_id_art' => $value['art_id']));
            // $materia    = $this->cotModel->get_materia(array('mpa_estado'=>1,'mpa_id_art' => $value['art_id'], 'mpa_id_rea' => $receta));
            // $mano_obra  = $this->cotModel->get_mano_obra(array('moa_estado'=>1,'moa_id_art' => $value['art_id'], 'moa_id_rea' => $receta));
            // $est        = $this->cotModel->get_esr(array('esr_estado'=>1,'esr_id_art' => $value['art_id'], 'esr_id_rea' => $receta));
            $materia    = $this->proyecto_model->get_materia_prima_producto_segun_receta(array('mpa_id_art' => $value['art_id'], 'mpa_id_rea' => $receta));
            $mano_obra  = $this->proyecto_model->get_mano_obra_producto(array('moa_id_art' => $value['art_id'], 'moa_id_rea' => $receta));
            $est        = $this->proyecto_model->get_gastos_indirectos_producto(array('esr_id_art' => $value['art_id'], 'esr_id_rea' => $receta));
            $where2['art_id'] = $value['art_id'];
            $where2['cxu_estado'] = 1;
            $caracteristicas = $this->cotModel->get_caracteristicas2($where2);
            $datos[] = array(
                'articulo' => $value['art_nombre'],
                'codigo' => $value['art_codigo'],
                'materias' => $materia,
                'mano_obra' => $mano_obra,
                'estimaciones' => $est,
                'caracteristicas' => $caracteristicas,
                'coments' => $value['art_observacion_presupuesto']
            );
        }
        $data['datos'] = $datos;
        $data['simbolo'] = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');
        $html = $this->load->view('cotizaciones/consultas/mostrar_presupuesto', $data, true);
        if ($tipo) {
            switch ($tipo) {
                    //excel
                case 1:
                    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                    header("Content-Disposition: attachment;filename=presupuesto-" . date('d-m-Y_His') . ".xls");
                    header("Pragma: no-cache");
                    header("Expires: 0");
                    echo '<meta charset="utf-8" />';
                    echo "<table border='0'>
                <tr><th colspan='5' align='center' >" . mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8') . "</th></tr>
                <tr><th colspan='5' align='center' >Reporte de Presupuesto</th></tr>
                <tr><th colspan='5' align='center' >" . $filtro_titulo . "</th></tr>
                </table>";
                    echo $html;
                    die();
                    break;
                    //pdf
                case 2:
                    $this->load->library('pdf');
                    $html_header = $this->load->view('reporte/header', array('titulo' => "Reporte de Presupuesto <br /> $filtro_titulo", 'solotitulo' => true), true);
                    $html = str_replace('border="1" style="margin-left: 4px; width: 99%; font-size:12px;"', 'border="0.5" style="width: 100%; font-size:9px;"', $html);
                    $this->pdf->makePDF($html_header . str_replace('font-size: 14px;', 'font-size: 10px;', $html), 'L');
                    die();
                    break;
            }
        }
        echo json_encode(array('info' => $html));
    }

    public function get_productos()
    {
        $categoria = $this->input->post('id_tia');
        $where     = null;

        $where['art_id_tia'] = $categoria;
        $where['art_tipo']   = 0;

        $productos = $this->cotModel->productos_ajax($where);
        //print_r($this->db->last_query());die();
        $opc       = '<option></option>';
        foreach ($productos as $key => $prod) {
            $opc .= '<option value="' . $prod['art_id'] . '">' . $prod['art_codigo'] . ' - ' . $prod['art_nombre'] . ' </option>';
        }

        if (empty($productos)) {
            $select = $this->gsatelite->get_dropdown('art_articulo', '{art_codigo} - {art_nombre}', '', array('art_estado' => 1), null, '', 'art_id', true);
            $opc = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $select);
        }

        echo json_encode(array('option' => $opc));
        die();
    }

    public function get_caracteristicas_prod()
    {
        $producto = $this->input->post('id_prod');
        $where['art_id'] = $producto;
        $where['cxu_estado']   = 1;

        $caracteristicas = $this->cotModel->get_caracteristicas2($where);
        $opc       = '<option></option>';
        foreach ($caracteristicas as $key => $cara) {
            $opc .= '<option value="' . $cara['id'] . '">' . $cara['nombre'] . ' </option>';
        }
        echo json_encode(array('option' => $opc));
        die();
    }


    /**
     * 
     * @author Nelson Soriano
     * @since  19-07-2019
     * @param  none
     * Descripcion: crea la vista con los filtros del reporte de clientes
     */

    public function reporte_clientes()
    {
        satelite_validar();
        $data['permisos']              = $this->gsatelite->get_permisos_opcion();
        $data['titulo_personal']       = 'Reporte registro de clientes';
        $select = $this->gsatelite->get_dropdown('ven_vendedor', '{ven_codigo} - {ven_nombre} {ven_apellidos}', '', array('ven_estado' => 1), null, '', 'ven_id', true);
        $data["vendedor"] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $select);
        cargarvista($data);
    }


    /**
     * 
     * @author Nelson Soriano
     * @since  19-07-2019
     * @param  id_cliente
     * Descripcion: Imprime Ficha de clientes
     */

    public function imprime_cliente($id_cliente = null)
    {
        satelite_validar();
        if ($id_cliente !== null) {
            $data['info'] = $this->cotModel->get_clientes_info(array('cli_id' => $id_cliente));
            $d            = $this->cotModel->obtener_municipios(array('mun_id' => $data['info'][0]['cli_id_mun']), 'dep_nombre, mun_nombre');
            $data['depa'] = $d[0]['dep_nombre'];
            $data['mun']  = $d[0]['mun_nombre'];
            $suc          = $this->cotModel->get_sucursal_vendedor(array('emp_id_usu' => $data['info'][0]['ven_id_usu']), 'suc_nombre');
            $data['sucursal'] = $suc[0]['suc_nombre'];
            $html         = $this->load->view('cotizaciones/consultas/imprime_cliente', $data, true);
            $html_header  = $this->load->view('reporte/header', array('titulo' => 'Datos del cliente'), true);
            $this->load->library('pdf');
            $reporte = $this->pdf->makePDF($html_header . $html, 'L');
        }
    }

    /**
     * Consultas: lista precio por cliente
     * @return Generación de un reporte general de cotizaciones
     * */
    function lista_precio_clientes($flag = null)
    {
        satelite_validar();
        if ($_POST) {
            $reporte =  $this->input->post('reporte');
            $clientes =  $this->input->post('clientes');
            $where = array('cli_estado' => 1, 'tlp_estado' => 1);
            if (trim($clientes) != "") {
                $where["cli_id IN ($clientes)"] = null;
            }
            $listas = $this->cotModel->getListaPreciosCliente($where);
            $data['reporte'] = $reporte;
            $data['registros'] = $listas;
            $html = $this->load->view('cotizaciones/consultas/det_list_prec_cli', $data, true);
            if ($flag) {
                echo json_encode(array('tabla' => $html, 'registros' => count($listas)));
            } else {
                if ($reporte == 'pdf') {
                    ini_set('memory_limit', '1024M');
                    ini_set('max_execution_time', '9999');
                    $datos = $this->load->view('reporte/header', array('titulo' => 'Listas de precios por cliente'), true);
                    $datos .= $html;
                    $this->pdf->makePDF($datos, 'P');
                } else {
                    echo $html;
                }
            }
        } else {
            $data['titulo_personal'] = 'Listas de precios por cliente';
            $this->_cargarvista($data);
        }
    }

    /**
     * 
     * @author Nelson Soriano
     * @since  19-07-2019
     * @param  Fecha desde. hasta
     * Descripcion: Retorna Preview de los clientes y acciones
     */

    public function get_clientes($es_reporte = false)
    {
        satelite_validar(true);
        $desde    = $this->input->post('desde');
        $hasta    = $this->input->post('hasta');
        $where    = array();
        $t_repor  =  $this->input->post('tipo_reporte');
        $filtros  = '';
        $vendedor    = $this->input->post('vendedor');

        if (($desde != '') && ($hasta != '')) {
            $where['DATE_FORMAT(cli_fecha_registro,"%Y-%m-%d") >='] = date_format(date_create($desde), 'Y-m-d');
            $where['DATE_FORMAT(cli_fecha_registro,"%Y-%m-%d") <='] = date_format(date_create($hasta), 'Y-m-d');
            $filtros .= 'Desde: ' . $desde . '<br>';
            $filtros .= 'Hasta: ' . $hasta;
        }

        if ($vendedor != '') {
            $where["cli_id_ven"] = $vendedor;
        }

        $data['info'] = $this->cotModel->get_clientes_sector($where);
        //print_r($this->db->last_query());die();
        $html         = $this->load->view('cotizaciones/consultas/get_clientes', $data, true);

        if (is_numeric($t_repor)) {
            $html_header  = $this->load->view('reporte/header', array('titulo' => 'Clientes registrados'), true);
            switch ($t_repor) {
                case 1: // PDF
                    $this->load->library('pdf');
                    $reporte = $this->pdf->makePDF($html_header . $html, 'L');
                    break;
                case 2: // EXCEL
                    header("Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
                    header("Content-Disposition: attachment;filename=Reporte_clientes_registrados.xls");
                    header("Pragma: no-cache");
                    header("Expires: 0");
                    echo $html_header . $html;
                    break;
            }
        }

        echo $html;
        die();
    }

    /**
     * 
     * @author Marlon Olmedo
     * @since  07-07-2020
     * @param  none
     * Descripcion: 
     * crea las vistas de los clientes para la eleccion de las columnas que desee ver
     */

    public function reporte_clientes_deta()
    {
        satelite_validar();
        $this->gsatelite->get_permisos_opcion();
        if ($_POST) {
            //print_r($_POST);die();
            $tipo_filtro = $this->input->post('tipo_filtro');
            $cli_codigo = $this->input->post('cli_codigo');
            $cli_nombre = $this->input->post('cli_nombre');
            $fecha_ini = $this->input->post('fecha1');
            $fecha_fin = $this->input->post('fecha2');

            $tipo_reporte = $this->input->post('tipo_reporte');
            if ($tipo_filtro == "todos_clientes") {
                $where["cli_estado"] = 1;
            } else {
                if ($cli_codigo != '') {
                    $where["cli_codigo"] = $cli_codigo;
                }
                if ($cli_nombre != '') {
                    $where["CONCAT(cli_nombre,' ',cli_apellido) like '%$cli_nombre%'"] = NULL;
                }
                if ($fecha_ini != '' && $fecha_fin != '') {
                    $fecha_ini_ = formatear_fecha("Y-m-d", $fecha_ini);
                    $fecha_fin_ = formatear_fecha("Y-m-d", $fecha_fin);
                    $where["DATE(cli_fecha_registro) BETWEEN '$fecha_ini_' AND '$fecha_fin_'"] = NULL;
                }
            }
            $data["reporte"] = $tipo_reporte;
            $this->db->limit(100);
            $data['info'] = $this->cotModel->get_cliente($where);
            //print_r($this->db->last_query());die();
            $html = $this->load->view('cotizaciones/consultas/grid_reporte_clientes_deta', $data, true);
            $html_header  = $this->load->view('reporte/header', array('titulo' => 'Clientes registrados'), true);

            if ($tipo_reporte == 'pdf') {
                $this->load->library('pdf');
                $reporte = $this->pdf->makePDF($html_header . $html, 'L');
                die();
            } elseif ($tipo_reporte == 'excel') {
                header("Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
                header("Content-Disposition: attachment;filename=Reporte_clientes_registrados.xls");
                header("Pragma: no-cache");
                header("Expires: 0");
                echo $html_header . $html;
                die();
            }
            echo json_encode(array("html" => $html));
            die();
        }
        $data['titulo_personal']       = 'Reporte registro de clientes detallado';
        cargarvista($data);
    }

    public function rpt_listados_precio()
    {
        satelite_validar();
        if ($_POST) {
            $where = array();
            $tipo_reporte = ($this->input->post('tipo_reporte') != '') ? $this->input->post('tipo_reporte') : null;
            if ($tipo_reporte != null) {
                $cliente = $this->input->post('filtro_cliente');
                $categoria = ($this->input->post('filtro_categoria') != '') ? $this->input->post('filtro_categoria') : null;
                $producto = ($this->input->post('filtro_producto') != '') ? $this->input->post('filtro_producto') : null;
                $lista = ($this->input->post('filtro_lista') > 0) ? $this->input->post('filtro_lista') : null;
                if ($lista != "") {
                    $where['tlp_id IN (' . $lista . ')'] = null;
                }
            }
            if ($categoria > 0) {
                $where['tia_id'] = $categoria;
            }
            if ($producto > 0) {
                $where['art_id'] = $producto;
            }
            if ($cliente > 0) {
                $where["tlp_id IN (SELECT tpn_id_tlp FROM tpn_tipo_precio_cliente WHERE tpn_estado = 1 AND tpn_id_cli = $cliente)"] = null;
            }
            $this->load->model('facturacion_model');
            $data['registros'] = $this->facturacion_model->get_listado_precio($where);
            $data['decimales'] = $this->gsatelite->get_parametro('NUMERO_DECIMALES', 2);
            $data['header'] = $this->load->view('reporte/header',  array('titulo' => 'Lista de precios'), true);
            $data['tipo_reporte'] = $tipo_reporte;
            if ($tipo_reporte != '') {
                switch ($tipo_reporte) {
                    case 'pdf':
                        $data['titulo'] = 'Lista de precios';
                        $html = $this->load->view('facturacion/reportes/rpt_lista_precio_export', $data, true);
                        $head = '<!DOCTYPE html><html><head><title>Listas de precios</title></head><body><script type="text/javascript">';
                        $head .= 'document.title = "' . mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8') . ' - Reporte Listas de precios";';
                        $head .= 'window.print();</script>';
                        $footer = '</body></html>';
                        $reporte = $head . $html . $footer;
                        echo $reporte;
                        break;
                    case 'excel':
                        $filename = 'rpt_lista' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
                        $data['titulo'] = ' Reporte de lista de precios';
                        $data['filename'] = $filename;
                        $data['excel'] = 1;
                        $html = $this->load->view('facturacion/reportes/rpt_lista_precio_export', $data, true);
                        echo $html;
                        break;
                }
            }
            // LA GRID EN LA VISTA SE COMPARTE CON FACTURACION
            die();
        } else {
            $ls_precio = $this->gsatelite->get_dropdown('tlp_tipo_lista_precio', '{tlp_nombre}', '', null, null, '', 'tlp_id', true);
            $categorias = $this->gsatelite->get_dropdown('tia_tipo_articulo', '{tia_codigo} - {tia_nombre}', '', array('tia_estado' => 1), null, '', 'tia_id', true);
            $data['listas'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $ls_precio);
            $data['categorias'] = str_replace(array('<option value="0">Seleccione</option>', '<option value="0">Sin Registros</option>'), '', $categorias);
            $data["titulo_personal"] = "Lista de precio";
        }
        cargarvista($data);
    }

    /**
     * @since  2023-04-17
     * Descripcion: invoca el reporte de comisiones por recuperacion del modulo de CxC
     */
    public function cobranza_comision($flag = null)
    {
        satelite_validar();
        $this->load->library('../controllers/modulo_cuentas_cobrar/reportes');
        $this->reportes->cobranza_comision($flag);
    }
}
