<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class reportes extends CI_Controller {

    function __construct() {
        parent::__construct();
        $this->load->library('pdf');
        $this->load->library('grocery_CRUD');
        $this->load->model('gsatelite');
        $this->load->model('auto_gestion_model');
        $this->load->model('estructura_organizativa_model');
    }

    function index() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $this->_cargarvista();
        }
    }

    function _cargarvista($data = 0, $crud = 0) {
        $this->load->view('vacia', $crud);
        if ($data != 0) {
            $data = array_merge($data, $this->masterpage->getUsuario());
        } else {
            $data = $this->masterpage->getUsuario();
        }
        $vista = $data['modulo'] . '/' . $data['control'] . '/' . $data['funcion'];        
        $this->masterpage->setMasterPage('masterpage_default');
        $this->masterpage->addContentPage($vista, 'content', $data);
        $this->masterpage->show();
    }

    public function marcaciones($id=NULL) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if($_POST){
                die(var_dump($_POST));
            }
                       $this->db->join('emp_empleado', 'usu_id_emp = emp_id','left');
                       $this->db->join('plz_plaza', 'emp_id_plz = plz_id','left');
            $emp_plz = $this->gsatelite->get_tabla('users',array('id' => $this->tank_auth->get_user_id(), 'emp_id_plz IS NOT NULL' => null));
            $permisos = $this->gsatelite->get_permisos_opcion();
            if (count($emp_plz) > 0) {
                $plz_id = $emp_plz[0]["emp_id_plz"];
                $emp_id = $emp_plz[0]["emp_id"];
                $plz_hijo = $this->gsatelite->get_tabla('plz_plaza',array('plz_id_padre' => $plz_id,"plz_estado" => 1));
                $plz_hijos = implode(',', array_column($plz_hijo,"plz_id"));
                $subordinados = ($plz_hijos != "") ? $this->gsatelite->get_tabla('emp_empleado',array("emp_id_plz IN($plz_hijos)" => NULL, 'emp_estado' => 1)) : array();
                $empleados = (count($subordinados) > 0) ? array_column($subordinados,"emp_id") : array();
                $fusion = implode(',', array_values(array_merge($empleados, array($emp_id))));
                $where['emp_estado'] = 1;
                $where["emp_id IN($fusion)"] = NULL;
                $select = $this->gsatelite->get_dropdown('emp_empleado', '{emp_codigo} - {emp_nombre} {emp_apellido}', '', $where, $emp_id, '', 'emp_id', true);
            } else {
                $permisos['permite_ver'] = 0;
                $select = '';
                $fusion = 0;
            }        
            $data["empleado"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            $data['permisos'] = $permisos;
            $data['emp_list'] = $fusion;
            $data['titulo_personal'] = "Marcaciones";
            $this->_cargarvista($data, null);
        }
    }

    public function permisos_consumidos($flag = null) {
        satelite_validar();
                    $this->db->join('emp_empleado', 'usu_id_emp = emp_id','left');
        $emp_regs = $this->gsatelite->get_tabla('users',array('id' => $this->tank_auth->get_user_id()));
        $emp_id = (count($emp_regs) > 0) ? $emp_regs[0]['emp_id'] : 0;
        if ($emp_id <= 0) {
            $this->gsatelite->show_dialog('El usuario no es un empleado válido', 'auto_gestion/index', 'error');
        } else {
            if ($_POST) {
                $year = $_POST['year'];
                $tipo = $_POST['tipo_reporte'];
                $registros = $this->auto_gestion_model->get_consumo_permiso($emp_id, $year);
                $data['periodo'] = $year;
                $data['reporte'] = $tipo;
                $data['registros'] = $registros;
                $html = $this->load->view('auto_gestion/reportes/detalle_consumo_permisos', $data, true);
                if ($flag) {
                    echo json_encode(array('tabla' => $html, 'filas' => count($registros)));
                } else {
                    if ($tipo == 'excel') {
                        echo $html;
                    } else {
                        $reporte = $this->load->view('reporte/header', array('titulo' => 'Permisos Consumidos ' . $year), true);
                        $reporte .= $html;
                        $this->pdf->makePDF($reporte, 'P');
                    }
                }                
            } else {
                $permisos = $this->gsatelite->get_permisos_opcion();
                $years = "";
                $actual = date('Y');
                for ($i = 0; $i < 5; $i++) { 
                    $selected = ($i > 0) ? "" : "selected";
                    $years .= '<option value="'.($actual - $i).'" '.$selected.'>'.($actual - $i).'</option>';
                }
                $data['years'] = $years;
                $data['titulo_personal'] = "Permisos Consumidos";
                $this->_cargarvista($data, null);
            }
        }
    }

}
/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */