<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Acciones extends CI_Controller
{
    function __construct()
    {
        parent::__construct();
        $this->load->library('grocery_CRUD');
        $this->load->model('gsatelite');             
        $this->load->model('personal_model');   
        $this->load->model('planilla_model');
        $this->load->model('auto_gestion_model');
        $this->load->model('expediente_personal_model');
        $this->load->model('accion_personal_model');
        $this->load->model('evaluacion_desempeno_model');
        $this->load->model('registro_academico_model');
        $this->load->model('compras_model');
        $this->load->library('EnLetras');
    }

    function index()
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {            
            $this->_cargarvista();
        }
    }

    public function datos_empleado()
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
                    
            $id_user = $this->tank_auth->get_user_id();
            $id_emp = $this->gsatelite->get_campo('users', 'usu_id_emp', array('id'=>$id_user));
            $data['total_empleados'] = $this->personal_model->listado_empleados(array('emp_id'=>$id_emp));
            $data['anexos'] = $this->personal_model->anexo_empleado($id_emp);
            $titulo['titulo_personal'] = "Información general";
            $this->_cargarvista($titulo, $data);
        }
    }

    public function ficha_empleado($id_emp)
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data['empleado'] = $this->planilla_model->info_completa_empleado($id_emp);
            $data['documentos'] = $this->planilla_model->documentos_emp($id_emp, '');
            $data['familiares'] = $this->planilla_model->familiares_empleado($id_emp);
            $data['more_info'] = $this->planilla_model->get_empleados_reporte(array('emp_id'=>$id_emp));
            $data['foto'] = $this->personal_model->foto_empleado($id_emp);
            $html  = $this->load->view('reporte/header', array('titulo' => 'Ficha de empleado'), true);
            $html .= $this->load->view('expediente_personal/empleado/ficha_empleado', $data, true);
            $this->load->library('pdf');
            $this->pdf->makePdf($html, 'P', $filename, 'Letter');
            // $reporte=$this->pdf->reportePDF2($html);

        }
    }

    public function reporte_planilla(){
        satelite_validar();
        $id_user= $this->tank_auth->get_user_id();
        $id_emp = $this->gsatelite->get_campo('users', 'usu_id_emp', array('id'=>$id_user));
        $data['tipo_planilla'] = $this->auto_gestion_model->get_tipo_contrato(array('txe_id_emp'=>$id_emp));
        $data['titulo_personal'] = "Impresión de boletas y planillas";
        $this->_cargarvista($data);
    }

        function obtener_periodo_planilla($tipo_estado=0)
    {
        if (!$this->tank_auth->is_logged_in()) {
      redirect('/auth/login/');
    } else {
        $option      = "";
        $var         = '<option value=0 selected >Seleccione una opción</option>';
        $t_planilla  = $this->input->post('t_planilla');
        $tipo= $this->input->post('tipo');
        if($tipo_estado) {
        $periodos  = $this->planilla_model->obtener_periodo_planilla2($t_planilla,$tipo);
        }
        else {
        $periodos  = $this->planilla_model->obtener_periodo_planilla($t_planilla,$tipo);
        }

        foreach ($periodos as $key) 
        {
            switch ($key['pla_estado']) {
                case '1':
                    $estado="Creada";
                    break;
                case '2':
                    $estado="Generada";
                    break;
                case '3':
                    $estado="Autorizada";
                    break;
                
                default:
                    # code...
                    break;
            }
            $var .="<option value='".$key['pla_id']."'>".$key['pla_fecha_inicio']."  --  ".$key['pla_fecha_fin']." ".$estado."</option>";
        }

        $arreglo = array( 
            "drop"=>$var,
            );

        echo json_encode($arreglo);
    }
}

    function generar_boletas($pla_id=null){
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $id_user= $this->tank_auth->get_user_id();
            $id_emp = $this->gsatelite->get_campo('users', 'usu_id_emp', array('id'=>$id_user));
            $pla_id= $this->input->post('planilla');
            $datos = $this->planilla_model->generar_boletas($pla_id, $id_emp);
            $empresa = strtolower(trim($this->gsatelite->get_parametro('SYS_SIGLAS', '')));
            $this->load->library('pdf');
            $pdf = $this->pdf;
            $total_empleados = count($datos);
            $header_html = $this->load->view('reporte/header_boleta_pago', array('solotitulo' => true, 'titulo' => ' BOLETA PAGO ', 'empresa' => $empresa, 'doble' => 0), true);
            if(count($datos) > 0){
                $k=0;
                $html2="";
                $p=0;
                $existe_fri = $this->gsatelite->get_tabla('fri_formato_impresion', array('fri_estado' => 1, 'fri_activo' => 1, 'fri_tipo_formato' => 5));
                $parm_ant = $this->gsatelite->get_parametro('ID_TIPO_DESCUENTO_ANTICIPO');
                foreach($datos as $row){
                    $p++;
                    $row['doble'] = 0;
                    $row['correlativo'] = $p;
                    $row['empresa'] = $empresa;
                    $row['cabezera'] = $header_html;
                    $row['total_empleado'] = $total_empleados;
                    $row['permite_saltos'] = ($k == 0 or (($p == $total_empleados and ($total_empleados % 2) != 0))) ? false : true;
                    $row['tipo_ant'] = $parm_ant;
                    if (count($existe_fri) > 0) {
                        $html = $this->load->view('personal/planilla/' . $existe_fri[0]['fri_archivo'], $row, true);
                    } else {
                        $html = $this->load->view('personal/planilla/rpt_boletas', $row, true);
                    }
                    $html2 .= $html;
                    if($k == 1) {
                        $font = ($empresa == 'isdemu') ? 'pdfahelvetica' : '';
                        $pdf->addBoleta_planilla($html2,null,'P',$font);
                        $html2="";
                        $k=0;
                    } else {
                        $k=1;
                        //cuando es impar
                        if($p == count($datos) and (count($datos) % 2 ) !=0 ) {
                            $font = ($empresa == 'isdemu') ? 'pdfahelvetica' : '';
                            $pdf->addBoleta_planilla($html2,null,'P',$font);
                        }
                    }
                }
                $pdf->boletaPDF('D');
            }else{
                /*$alerta = array('tipo_alerta'=> 'note_error','titulo_alerta'=>"Imposible Generar.",'texto_alerta'=>"Error: Generación de boletas.");
                $this->ci->session->set_flashdata($alerta);*/
                redirect();
            }
        }

    }
    
    /**
    *@author Edith Herrera
    *@return datos para las constancias.
    */
    function constancia_empleado(){
       satelite_validar();
       $id_user = $this->tank_auth->get_user_id();
       $id_emp = $this->gsatelite->get_campo('users', 'usu_id_emp', array('id'=>$id_user));
       $data['emp'] = $id_emp;
       $data['suc'] = $this->gsatelite->get_campo('emp_empleado', 'emp_id_suc', array('emp_id' =>$id_emp ));
       $this->db->join('txe_tipo_planillaxempleado','txe_id_tpl=tpl_id');
       $data['opciones'] = $this->gsatelite->get_dropdown('tpl_tipo_planilla', '{tpl_nombre}','', array('txe_id_emp'=>$id_emp), null, '', 'tpl_id', true);
       //$data["select_tipo_pla"] = str_replace('<option value="0">Seleccione</option>', '',$opciones);
      // print_r($opciones);
       //die();
       $titulo['titulo_personal'] = "Constancias";
       $this->_cargarvista($titulo, $data);

    }

    /**
    *@author Edith Herrera
    *@return Select con los tipos de planilla a las que pertenece el empleado
    */
    public function get_tipo_planilla_empleado() {
        $id_empleado = $this->input->post('emp_id');
        $this->db->join('txe_tipo_planillaxempleado','txe_id_tpl=tpl_id');
        $select = $this->gsatelite->get_dropdown('tpl_tipo_planilla', '{tpl_nombre}','', array('txe_id_emp'=>$id_empleado), null, '', 'tpl_id', true);
        $data["select_tipo_pla"] = str_replace('<option value="0">Seleccione</option>', '',$select);
        die(json_encode($data));
    }

    /**
    *@author Herberth Lucho
    *@return Datos de empleado para gestionar acciones.
    */
 function gestion_acciones_emp($id_emp = null) 
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $id_user = $this->tank_auth->get_user_id(); ///////////////**************************************
            $id_empleado = $this->gsatelite->get_campo('users', 'usu_id_emp', array('id'=>$id_user)); ///////////////**************************************
            $id_emp = ($id_emp)?$id_emp:$id_empleado; ///////////////**************************************
                
            $empleado = $this->gsatelite->get_tabla('emp_empleado', array('emp_id' => $id_emp));
            $dias = $this->gsatelite->get_parametro('DIAS_TRABAJADOS_MES');
            $hora = $this->gsatelite->get_parametro('HORAS_TRABAJADAS_DIA');
            $valor_hora = ($empleado[0]['emp_salario_hora'] != '') ? $empleado[0]['emp_salario_hora'] : ($empleado[0]['emp_salario']/$dias)/$hora;
            try {                
                $this->gsatelite->verificar_registro_real('emp_empleado', $id_emp); ///////////////**************************************
                // $permisos = $this->gsatelite->get_permisos_opcion('auto_gestion/acciones/listado_empleados_auto'); ///////////////**************************************
                $data["permisos"] = $permisos;
                $crud = new grocery_CRUD();
                $crud->set_table('acp_accion_personal')
                        ->set_subject('Acción Empleada/o')
                        ->columns( 'acp_id_tac','acp_fecha_desde', 'acp_fecha_hasta', 'acp_observacion', 'acp_estado')
                        ->where('acp_id_emp', $id_emp)
                        ->where('acp_estado_accion < ', 3)
                        ->set_relation('acp_id_tac', 'tac_tipo_accion', 'tac_nombre', array('tac_estado' => 1))
                        ->set_relation('acp_id_emp', 'emp_empleado', '{emp_nombre} {emp_apellido}')
                        ->add_fields('acp_id_emp', 'acp_id_tac', 'acp_fecha_desde', 'acp_fecha_hasta', 'acp_observacion', 'acp_estado', 'acp_id_usu', 'acp_usu_crea', 'acp_fecha_crea', 'acp_usu_mod', 'acp_fecha_mod')
                        ->edit_fields('acp_id_emp', 'acp_id_tac', 'acp_fecha_desde', 'acp_fecha_hasta', 'acp_observacion', 'acp_estado','acp_id_usu','acp_usu_mod', 'acp_fecha_mod')                        
                        ->display_as('acp_id_tac', 'Tipo Acción')
                        ->display_as('acp_fecha_desde', 'Período Desde')
                        ->display_as('acp_fecha_hasta', 'Período Hasta')
                        ->display_as('acp_observacion', 'Observación')
                        ->display_as('acp_estado', 'Estado')
                        ->display_as('acp_usu_crea', 'acp_usu_crea')
                        ->display_as('acp_fecha_crea', 'acp_fecha_crea')
                        ->display_as('acp_id_emp', 'Empleada/o')
                        ->required_fields('acp_id_tac', 'acp_estado', 'acp_id_emp')
                        ->callback_column('acp_estado', function($value, $row) {
                            $autorizado = ($row->acp_estado_accion == 3) ? "- Anulada<span class='sin_edit' style='display:none;'></span>" : "";
                            return ($value) ? "Activo $autorizado" : "Inactivo $autorizado";
                        })
                        ->field_type('acp_id_emp', 'hidden', $id_emp)
                        ->field_type('acp_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                        ->field_type('acp_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                        ->field_type('acp_usu_crea', 'hidden', $this->tank_auth->get_user_id())
                        ->field_type('acp_fecha_crea', 'hidden', date('Y-m-d H:i:s'))                        
                        ->field_type('acp_id_usu', 'hidden', $this->tank_auth->get_user_id())
                        ->unset_delete()                                             
                        ->add_action('Imprimir', '', 'auto_gestion/acciones/imprimir_accion', 'icomoon-icon-printer imprimir_accion')
                        ->add_action('Anexos', '', 'auto_gestion/acciones/anexos_accion_personal', 'icomoon-icon-file-add')    
                //->unset_print()
                //->unset_export()
                ;
                if (end(explode('/', uri_string())) == 'add') {
                    $crud->field_type('acp_estado', 'hidden', 1);                    
                    $crud->field_type('acp_usu_crea', 'hidden', $this->tank_auth->get_user_id());
                    $crud->field_type('acp_fecha_crea', 'hidden', date('Y-m-d H:i:s'));
                    $crud->field_type('acp_id_usu', 'hidden', $this->tank_auth->get_user_id());
                } else {
                    $crud->field_type('acp_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
                    $crud->field_type('acp_fecha_mod', 'hidden', date('Y-m-d H:i:s'));
                    $crud->callback_edit_field('acp_usu_mod', function($value, $primary_key) {
                        $user = $this->tank_auth->get_user_id();
                        return "<input id='field-acp_usu_mod' type='hidden' name='acp_usu_mod' value='" . $user . "' /><input type='hidden' id='old_tdc'  name='old_tdc' value='' />";
                    });
                }
                if (!$permisos['permite_agregar']) {
                    $crud->unset_add();
                }
                if (!$permisos['permite_editar']) {
                    $crud->unset_edit();
                }
                if (!$permisos['permite_eliminar']) {
                    $crud->unset_delete();
                }
                if (!$permisos['permite_ver']) {
                    $crud->unset_read();
                } 
                          
                $data['titulo_personal'] = "Gestión acciones de personal";
                $emp = $this->gsatelite->get_registro('emp_empleado', 'emp_id', $id_emp);
                //$crud->add_action('Imprimir', '', 'acciones_personal/principal/imprimir_accion', 'icomoon-icon-printer imprimir_accion');
                $data["nombre_empleado"] = $emp->emp_nombre . ' ' . $emp->emp_apellido;
                $data["id_empleado"] = $emp->emp_id;
                $data["valor_hora"] = $valor_hora;
                $output = $crud->render();                
                $this->_cargarvista($data, $output);
            } catch (Exception $e) {
                show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
            }
        }
    }

    public function listado_empleados_auto() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $permisos = $this->gsatelite->get_permisos_opcion();
            $data["permisos"] = $permisos;

            $this->db->join('emp_empleado', 'usu_id_emp = emp_id','left');
            $this->db->join('plz_plaza', 'emp_id_plz = plz_id','left');
            $emp_plz = $this->gsatelite->get_tabla('users',array('id' => $this->tank_auth->get_user_id()))[0];
            $plz_id = $emp_plz["emp_id_plz"];
            $emp_id = $emp_plz["emp_id"];
            $plz_hijo = $this->gsatelite->get_tabla('plz_plaza',array('plz_id_padre' => $plz_id,"plz_estado" => 1));
            $plz_hijo2 = array_column($plz_hijo,"plz_id");
            $plz_hijo_ = implode(",",$plz_hijo2);
            $where = '';
            if ($plz_hijo_ != '') {
                $empleados_subordinados = $this->gsatelite->get_tabla('emp_empleado',array("emp_id_plz IN($plz_hijo_)" => NULL));
            } else {
                $empleados_subordinados = array();
            }
            $empleados_subordinados_ = array_column($empleados_subordinados,"emp_id");
            $fusion = array_values(array_merge($empleados_subordinados_,array($emp_id)));
            $implode = implode(",",$fusion);
            $where["emp_id IN($implode)"] = NULL;
            
            $data['total_empleados'] = $this->personal_model->listado_empleados($where);
            $data['titulo_personal'] = "Acciones de Personal";
            $this->_cargarvista($data, null);
        }
    }

    function imprimir_accion($id_detalle_accion = null, $id_empleado = null, $tipo = 2) {
        satelite_validar();
        if ($id_detalle_accion != 'all' and $id_empleado == null) {
            $this->gsatelite->verificar_registro_real('acp_accion_personal', $id_detalle_accion);
        }
        if ($id_detalle_accion != 'all' and $id_empleado == null) {
            $registro_detalle = $this->gsatelite->get_registro('acp_accion_personal', 'acp_id', $id_detalle_accion);
            $this->db->join('emp_empleado', 'emp_id=acp_id_emp');
            $this->db->join('tac_tipo_accion', 'tac_id=acp_id_tac');
            $this->db->join('are_area', 'are_id=emp_id_are', 'left');
            $datos = $this->gsatelite->get_tabla('acp_accion_personal', array('acp_id' => $id_detalle_accion));
            $data["informacion"] = $datos[0];
            $html = $this->load->view('reporte/header', array('titulo' => 'ACCIÓN DE PERSONAL', 'solotitulo' => true), true);
            $html .= $this->load->view('auto_gestion/acciones/reporte_accion_empleado', $data, true);
        } else {
            $this->db->join('emp_empleado', 'emp_id=acp_id_emp');
            $this->db->join('tac_tipo_accion', 'tac_id=acp_id_tac');
            $this->db->join('are_area', 'are_id=emp_id_are', 'left');
            $data["consulta"] = $this->gsatelite->get_tabla('acp_accion_personal', array('acp_id_emp' => $id_empleado));
            $html = $this->load->view('reporte/header', array('titulo' => 'ACCIÓN DE PERSONAL', 'solotitulo' => true), true);
            $html .= $this->load->view('auto_gestion/acciones/reporte_accion_empleado_all', $data, true);
        }
        if ($tipo == 2) {
            $this->load->library('Pdf'); //libreria pdf
            $this->pdf->setPrintFooter(true);
            $this->pdf->makePDF($html, 'P');
        } else {
            //excel
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header("Content-Disposition: attachment;filename=Reporte_consolidado_acciones.xls");
            header("Pragma: no-cache");
            header("Expires: 0");
            $html_header = $this->load->view('reporte/header', array('titulo' => 'ACCIÓN DE PERSONAL', 'solotitulo' => true), true);
            echo "<h3>ACCIÓN DE PERSONAL</h3>";
            echo str_replace($html_header, '', $html);
        }
    }

    public function anexos_accion_personal($acp_id) {         
        try {
            $crud = new grocery_CRUD;
            $add = array(
                'nap_id_acp',
                'nap_nombre',
                'nap_url',
                'nap_estado',
                'nap_usu_creacion',
                'nap_fecha_creacion',
                'nap_usu_modificacion',
                'nap_fecha_modificacion'
            );
            $edit = array(
                'nap_id_acp',
                'nap_nombre',
                'nap_url',
                'nap_estado',
                'nap_usu_modificacion',
                'nap_fecha_modificacion'
            );
            $required = array(
                'nap_id_acp',
                'nap_nombre',
                'nap_url',
                'nap_estado',
                'nap_usu_modificacion',
                'nap_fecha_modificacion'
            );
            $alias = array(
                'nap_nombre' => 'Nombre',
                'nap_url' => 'Anexo',
                'nap_estado' => 'Estado'
            );

            $columns = array(
                'nap_nombre',
                'nap_url',
                'nap_estado'
            );

            $crud->set_table('nap_anexo_accion_personal')
                    ->set_subject('Anexo')
                    ->add_fields($add)
                    ->edit_fields($edit)
                    ->columns($columns)
                    ->display_as($alias)
                    ->field_type('nap_id_acp', 'hidden', $acp_id)
                    ->required_fields($required)
                    ->set_field_upload('nap_url', 'uploads/anx_accion_personal', 'Anexos')
                    ->field_type('nap_fecha_modificacion', 'hidden', date('Y-m-d H-i-s'))
                    ->field_type('nap_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                    ->where('nap_id_acp', $acp_id)
            ;

            $crud->callback_before_upload(array($this, 'callback_before_upload_document'));

            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('nap_estado', 'hidden', 1)
                        ->field_type('nap_fecha_creacion', 'hidden', date('Y-m-d H-i-s'))
                        ->field_type('nap_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                ;
            } else {
                $crud->field_type('nap_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }

            $row_accion_personal = $this->gsatelite->get_tabla('acp_accion_personal',array('acp_id' =>$acp_id));
            $id_empleado = $row_accion_personal[0]['acp_id_emp'];
            $data['id_empleado'] = $id_empleado;

            $output = $crud->render();                    

            $data['titulo_personal'] = "Anexos de Accion de Personal";

            $this->_cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    /**
     * ====================
     * CALLBACKS
     * ===================
     * files_to_upload = información del archivo
     * field_info = información del path
     */
    function callback_before_upload_document($files_to_upload, $field_info) {

        $encrypted_name = $field_info->encrypted_field_name;

        $search = array("(", ")");

        //$files_to_upload[$encrypted_name]['name'] = str_replace($search, "_", $files_to_upload[$encrypted_name]['name']);

        if (strpos($files_to_upload[$encrypted_name]['name'], '(') || strpos($files_to_upload[$encrypted_name]['name'], ')') || strpos($files_to_upload[$encrypted_name]['name'], '&') || strpos($files_to_upload[$encrypted_name]['name'], '!') || strpos($files_to_upload[$encrypted_name]['name'], '%') || strpos($files_to_upload[$encrypted_name]['name'], '=') || strpos($files_to_upload[$encrypted_name]['name'], '$')) {

            return 'Elimine caracteres especiales en el nombre del archivo';
        } else {
            return true;
        }
    }

    function consulta_horario(){
        satelite_validar();
        $id_user = $this->tank_auth->get_user_id();
        $id_emp = $this->gsatelite->get_campo('users', 'usu_id_emp', array('id'=>$id_user));

                          $this->db->join( 'tur_turno','tur_id=txe_id_tur');
        $data['select'] = $this->gsatelite->get_tabla('txe_turnoxempleado', array('txe_id_emp'=>$id_emp, 'tur_estado'=>'1'));
        $data['titulo_personal'] = "Deatalles de horario";
        $this->_cargarvista($data,null);
    
    }

    function _cargarvista($data=0,$crud=0, $ruta_vista = ""){
        $this->load->view('vacia',$crud);
        if ($data!=0) {
            $data = array_merge($data,$this->masterpage->getUsuario());
        } else {
            $data = $this->masterpage->getUsuario();
        }
        $vista = ($ruta_vista != '') ? $ruta_vista : ($data['modulo'] . '/' . $data['control'] . '/' . $data['funcion']);
        $this->masterpage->setMasterPage('masterpage_default');
        $this->masterpage->addContentPage($vista, 'content',$data);
        $this->masterpage->show();
    }

    public function autoeditar_empleado($emp_id, $tipo, $ver_detalle = null,$precarga = null,$viene_concurso = null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');   
        } else {

            $ver_detalle = ((int) $ver_detalle === 0)?$ver_detalle = null:$ver_detalle;
            $registro = $this->gsatelite->get_registro('emp_empleado', 'emp_id', $emp_id);
            /*************Determinar la cantidad de promociones nivelaciones **********************/
            $num_promos = count($this->gsatelite->get_tabla('pps_promocion_plaza_salarioxemp', array('pps_id_emp' => $emp_id)));            
            $data['num_promos'] = $num_promos;
            //die(print_r($registro,true));
            //$data['genero'] = $this->personal_model->get_genero();
            //$data['nacionalidad'] = $this->personal_model->get_nacionalidad();
            $data['estado_civil'] = $this->personal_model->get_estado_civil();
            $data['profesion'] = $this->personal_model->get_profesion();
            $data['tipo_telefono'] = $this->personal_model->get_tipotelefono();
            $data['afp'] = $this->personal_model->get_afp();
            $data['doc_documentos'] = $this->personal_model->get_documentos();
            $data['parentescos_cat'] = $this->personal_model->get_parentesco();
            $data['precarga'] = $precarga;
            //$data['puesto']=$this->personal_model->get_puesto();
            $arreglo_ids = $this->expediente_personal_model->get_permitidos_plaza($registro->emp_id_plz);
            $this->db->where_not_in('plz_id', $arreglo_ids);
            $this->db->where('plz_id_are',$registro->emp_id_are);
            $this->db->join('mxr_empresaxarea', 'mxr_id_are = plz_id_are');
            $this->db->where('mxr_id_emr', $this->tank_auth->get_empresa_id()); //Added by René Castaneda 
            
            //Si el insert viene de un concurso
           // $plaza_con = $this->gsatelite->get_campo('cnp_concurso_plaza','cnp_id_plz',array('cnp_id' => $viene_concurso));
            //$are_con   = $this->gsatelite->get_campo('cnp_concurso_plaza','cnp_id_are',array('cnp_id' => $viene_concurso));

            $data['plaza'] = $this->gsatelite->get_tabla('plz_plaza', array('plz_estado' => 1));
            $data['departamento'] = $this->personal_model->get_departamento();
            $data['sucursal'] = $this->personal_model->get_sucursal();
            $data['tipo_contrato'] = $this->personal_model->get_tipo_contrato();
            $data['informacion'] = $informacion = $this->personal_model->editar_empleado($emp_id);
            $data['telefonos'] = $this->personal_model->editar_tel_empleado($emp_id);
            //oculta el thead de la tabla, en el caso de que no hayan datos
            $tel_sty = 'style="display:none;"';
            if (!(empty($data['telefonos']))) {
                $tel_sty = '';
            }
            $data['tel_sty'] = $tel_sty;
            $data['alergico'] = $this->gsatelite->get_tabla('cae_componente_alergico_empleado', array('cae_estado' => 1, 'cae_id_emp' => $emp_id));
            $data['enfermedad'] = $this->gsatelite->get_tabla('exe_enfermedadxempleado', array('exe_estado' => 1, 'exe_id_emp' => $emp_id));
            $data['enf_select'] = $this->gsatelite->get_tabla('enf_enfermedad', array('enf_estado' => 1));
            $data['alerg_select'] = $this->gsatelite->get_tabla('coa_componente_alergico', array('coa_estado' => 1));
            $data['parentescos_enf'] = $this->gsatelite->get_tabla('pat_parentesco');
            $data['documentos'] = $this->personal_model->editar_doc_empleado($emp_id);
            $data['parentescos'] = $this->personal_model->editar_fam_empleado($emp_id);
            //oculta el thead de la tabla, en el caso de que no hayan datos
            $paren_sty = "display:none;";
            if (!(empty($data['parentescos']))) {
                $paren_sty = "";
            }
            $data['paren_sty'] = $paren_sty;
            //programas y equipo
            $select = $this->expediente_personal_model->get_dropdown('nie_nivel_experiencia', '{nie_nombre}', '', array('nie_estado' => 1), null, '', 'nie_id', true);
            $data["nivel_programa_select"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            $select = $this->expediente_personal_model->get_dropdown('peq_programa_equipo', '{peq_nombre}', '', array('peq_estado' => 1), null, '', 'peq_id', true);
            $data["tipo_programa_select"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            $select = "";
            $datos = $this->gsatelite->get_tabla('cer_certificacion', array('cer_estado' => 1, 'cer_tipo' => 2));
            foreach ($datos as $key) {
                $select .= '<option value = "' . $key['cer_id'] . '">' . $key['cer_nombre'] . '</option>';
            }
            $data["cert_programa_select"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            $select = $this->expediente_personal_model->get_dropdown('icp_institucion_capacitacion', '{icp_nombre}', '', array('icp_estado' => 1), null, '', 'icp_id', true);
            $data["institucion_select"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            $select = $this->expediente_personal_model->get_dropdown('mde_modalidad_estudio', '{mde_nombre}', '', array('mde_estado' => 1), null, '', 'mde_id', true);
            $data["modalidad_select"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            $data['nivel_programa_select2'] = $this->gsatelite->get_tabla('nie_nivel_experiencia', array('nie_estado' => 1,));
            $data['tipo_programa_select2'] = $this->gsatelite->get_tabla('peq_programa_equipo', array('peq_estado' => 1));
            $data['cert_programa_select2'] = $this->gsatelite->get_tabla('cer_certificacion', array('cer_estado' => 1, 'cer_tipo' => 2));
            $data['institucion_programa_select2'] = $this->gsatelite->get_tabla('icp_institucion_capacitacion', array('icp_estado' => 1));
            $data['modalidad_programa_select2'] = $this->gsatelite->get_tabla('mde_modalidad_estudio', array('mde_estado' => 1));
            $data['programa'] = $this->gsatelite->get_tabla('pxe_programaxempleado', array('pxe_estado' => 1, 'pxe_id_emp' => $emp_id));
            $data['programa_certificacion'] = $this->gsatelite->get_tabla('cep_certificacion_programa', array('cep_estado' => 1, 'cep_id_emp' => $emp_id));
            $program_sty = "display:none;";
            if (!(empty($data['tipo_programa_select2']))) {
                $program_sty = "";
            }
            $data['program_sty'] = $program_sty;
            $program_cert_sty = "display:none;";
            if (!(empty($data['programa_certificacion']))) {
                $program_cert_sty = "";
            }
            $data['program_cert_sty'] = $program_cert_sty;
            /* print_r($this->db->last_query());
              exit();die(); */
            $data['anexos'] = $this->personal_model->anexo_empleado($emp_id);
            $data['foto'] = $this->personal_model->foto_empleado($emp_id);
            $data['tipo'] = $tipo;
            /* ============================================================================================
              =                 DATOS DE LOS IDIOMAS
              ==============================================================================================             */
            //controles para los select
            $select = $this->expediente_personal_model->get_dropdown('idm_idioma', '{idm_nombre}', '', null, null, '', 'idm_id', true);
            $data["idm_idioma"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            $select = $this->expediente_personal_model->get_dropdown('nii_nivel_idioma', '{nii_nombre}', '', null, null, '', 'nii_id', true);
            $data["nivel_idioma"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            $select = "";
            $datos = $this->gsatelite->get_tabla('cer_certificacion', array('cer_estado' => 1, 'cer_tipo' => 1));
            foreach ($datos as $key) {
                $select .= '<option value = "' . $key['cer_id'] . '">' . $key['cer_nombre'] . '</option>';
            }
            $data["cert_idioma_d"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            //fin de controles
            //tablas para mostrar los idiomas y certificacion del empleado
            $data['idiomas'] = $this->gsatelite->get_tabla('iem_idioma_empleado', array('iem_estado' => 1, 'iem_id_emp' => $emp_id));
            $data['certificado'] = $this->gsatelite->get_tabla('cri_certificacion_idioma', array('cri_estado' => 1, 'cri_id_emp' => $emp_id));
            //idiomas
            $data['select_idiomas'] = $this->gsatelite->get_tabla('idm_idioma', array('idm_estado' => 1));
            $data['select_nivel'] = $this->gsatelite->get_tabla('nii_nivel_idioma', array('nii_estado' => 1));
            //certificado
            $data['select_certificacion'] = $this->gsatelite->get_tabla('cer_certificacion', array('cer_estado' => 1, 'cer_tipo' => 1));
            //oculta el thead de la tabla, en el caso de que no hayan datos
            $idi_sty = 'style = "display:none"';
            $cer_sty = 'style = "display:none"';
            if (!(empty($data['idiomas']))) {
                $idi_sty = '';
            }
            if (!(empty($data['certificado']))) {
                $cer_sty = '';
            }
            $data['tabla_idm'] = $idi_sty;
            $data['tabla_cer'] = $cer_sty;
            /* ============================================================================================
              =                 DATOS DE LAS REFERENCIAS PERSONALES
              ============================================================================================             */
            //controles para los select
            $select = $this->expediente_personal_model->get_dropdown('trr_tipo_referencia', '{trr_nombre}', '', array('trr_estado' => 1), null, '', 'trr_id', true);
            $data["tipo_referencia"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            //tabla relacionada con el empleado
            $data["referencia_personal"] = $this->gsatelite->get_tabla('rfp_referencia_personal', array('rfp_estado' => 1, 'rfp_id_emp' => $emp_id));
            //tablas para mostrar los idiomas y certificacion del empleado
            $data['tipo_referencia_select'] = $this->gsatelite->get_tabla('trr_tipo_referencia', array('trr_estado' => 1));
            //oculta el thead de la tabla, en el caso de que no hayan datos
            $refpersonal_sty = 'style = "display:none"';
            if (!(empty($data['referencia_personal']))) {
                $refpersonal_sty = '';
            }
            $data['refpersonal_sty'] = $refpersonal_sty;
            /* ============================================================================================
              =                 DATOS DE LAS REFERENCIAS PERSONALES
              =============================================================================================             */
            //tabla relacionada con el empleado
            $data["referencia_laboral"] = $this->gsatelite->get_tabla('rfl_referencia_laboral', array('rfl_estado' => 1, 'rfl_id_emp' => $emp_id));
            //oculta el thead de la tabla, en el caso de que no hayan datos
            $reflaboral_sty = 'display:none;';
            if (!(empty($data['referencia_laboral']))) {
                $reflaboral_sty = '';
            }
            $data['reflaboral_sty'] = $reflaboral_sty;            
            /* ============================================================================================
              =                 INSUMOS EMPLEADO
              ==============================================================================================
             */                    
            $data["insumos_grid"] = $this->expediente_personal_model->get_insumos(array('ixe_estado' => 1,'ixe_id_emp' => $emp_id));            
            /* ============================================================================================
              =                 INSUMOS EMPLEADO
              ==============================================================================================
             */                    
            $data["capacitaciones_grid"] = $this->expediente_personal_model->get_capacitaciones(array('cpe_estado' => 1,'cpe_id_emp' => $emp_id));            
            /* ============================================================================================
              =                     DATOS ACADEMICOS
              ==============================================================================================
             */
            //tabla relacionada con el empleado
            $data["datos_academicos"] = $this->gsatelite->get_tabla('dac_dato_academico', array('dac_estado' => 1, 'dac_id_emp' => $emp_id));
            //oculta el thead de la tabla, en el caso de que no hayan datos
            $datacademic_sty = 'style = "display:none"';
            if (!(empty($data['datos_academicos']))) {
                $datacademic_sty = '';
            }
            $data['datacademic_sty'] = $datacademic_sty;
            $select = $this->expediente_personal_model->get_dropdown('tie_tipo_educacion', '{tie_nombre}', '', array('tie_estado' => 1), null, '', 'tie_id', true);
            $data["tipo_educacion"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            $select = $this->expediente_personal_model->get_dropdown('pro_profesion', '{pro_nombre}', '', array('pro_estado' => 1), null, '', 'pro_id', true);
            $data["pro_profesion"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            $select = $this->expediente_personal_model->get_dropdown('ina_institucion_academica', '{ina_nombre}', '', array('ina_estado' => 1), null, '', 'ina_id', true);
            $data["institucion_academica"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            $select = $this->expediente_personal_model->get_dropdown('ese_estado_estudio', '{ese_nombre}', '', array('ese_estado' => 1), null, '', 'ese_id', true);
            $data["estado_estudio"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            $select2 = $this->expediente_personal_model->get_dropdown('pai_pais', '{pai_nombre}', '', array('pai_estado' => 1), null, '', 'pai_id', true);
            $data["pai_pais"] = str_replace('<option value="0">Seleccione</option>', '', $select2);
            $select = $this->expediente_personal_model->get_dropdown('exl_experiencia_laboral', '{exl_nombre}', '', array('exl_estado' => 1), null, '', 'exl_id', true);
            $data["experiencia_laboral"] = str_replace('<option value="0">Seleccione</option>', '', $select);
            $data["sel_tipo_educacion"] = $this->expediente_personal_model->get_select('tie_tipo_educacion', array('tie_nombre', 'asc'), array('tie_estado' => 1));
            $data["sel_pro_profesion"] = $this->expediente_personal_model->get_select('pro_profesion', array('pro_nombre', 'asc'), array('pro_estado' => 1));
            $data["sel_institucion_academica"] = $this->expediente_personal_model->get_select('ina_institucion_academica', array('ina_nombre', 'asc'), array('ina_estado' => 1));
            $data["sel_estado_estudio"] = $this->expediente_personal_model->get_select('ese_estado_estudio', array('ese_nombre', 'asc'), array('ese_estado' => 1));
            $data["sel_pai_pais"] = $this->expediente_personal_model->get_select('pai_pais', array('pai_nombre', 'asc'), array('pai_estado' => 1));
            $data["sel_experiencia_laboral"] = $this->expediente_personal_model->get_select('exl_experiencia_laboral', array('exl_nombre', 'asc'), array('exl_estado' => 1));
            $select = $this->gsatelite->get_dropdown('hab_habilidad', '{hab_nombre}', '', array('hab_estado' => 1), null, '', 'hab_id', true);
            $data["habilidad"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            $select = $this->gsatelite->get_dropdown('nih_nivel_habilidad', '{nih_nombre}', '', array('nih_estado' => 1), null, '', 'nih_id', true);
            $data["nivel_habilidad"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            $data['habilidades_emple'] = $this->expediente_personal_model->get_habilidades_emp(array('hxm_id_emp'=>$emp_id));
            $data['agrupaciones_emple'] = $this->gsatelite->get_tabla('age_agrupacion_empleado',array('age_id_emp'=>$emp_id));
            $select = $this->gsatelite->get_dropdown('zon_zona', '{zon_nombre}', '', array('zon_estado' => 1), $registro->emp_id_zon, '', 'zon_id', true);
            $data["slcZona"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            $select = $this->gsatelite->get_dropdown('tiv_tipo_vivienda', '{tiv_nombre}', '', array('tiv_estado' => 1), $registro->emp_id_tiv, '', 'tiv_id', true);
            $data["slcTipoCasa"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            $select = $this->gsatelite->get_dropdown('tcv_tipo_construccion_vivienda', '{tcv_nombre}', '', array('tcv_estado' => 1), $registro->emp_id_tcv, '', 'tcv_id', true);
            $data["slcTipoConstruccion"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            $servicicios_emp  = array();
            $reg_srv = $this->gsatelite->get_tabla('sre_servicio_empleado',array('sre_id_emp'=>$emp_id));
            foreach ($reg_srv as $rs) {
                $servicicios_emp[]=$rs['sre_id_srb'];
            }
            $select = $this->gsatelite->get_dropdown('srb_servicio_basico', '{srb_nombre}', '', array('srb_estado' => 1), $servicicios_emp, '', 'srb_id', true);
            $data["slcServiciosBasicos"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            $reg_municipio = $this->gsatelite->get_tabla('mun_municipio',array('mun_id'=>$registro->emp_id_mun));
            $id_departamento =  ($reg_municipio)? $reg_municipio[0]['mun_id_dep']:null;
            $id_municipio =  ($reg_municipio)? $reg_municipio[0]['mun_id']:null;
            $select = $this->gsatelite->get_dropdown('dep_departamento', '{dep_nombre}', '', array('dep_estado' => 1), $id_departamento, '', 'dep_id', true);
            $data["slcDepartamento"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            $select = $this->gsatelite->get_dropdown('pai_pais', '{pai_nacionalidad}', '', array('pai_estado' => 1), $registro->emp_id_pai, '', 'pai_id', true);
            $data["slcNacionalidad"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            $select = $this->gsatelite->get_dropdown('mun_municipio', '{mun_nombre}', '', array('mun_estado' => 1, 'mun_id_dep' => $id_departamento), $id_municipio, '', 'mun_id', true);
            $data["slcMunicipio"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            $select = $this->gsatelite->get_dropdown('tps_tipo_salario', '{tps_nombre}', '', array('tps_estado' => 1), $registro->emp_id_tps, '', 'tps_id', true);
            $data["slcTipoSalario"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            $select = $this->gsatelite->get_dropdown('cta_categoria_aguinaldo', '{cta_nombre}', '', array('cta_estado' => 1), $registro->emp_id_cta, '', 'cta_id', true);
            $data["slcCatAguinaldo"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            $select = $this->gsatelite->get_dropdown('fnr_fuente_reclutamiento', '{fnr_nombre}', '', array('fnr_estado' => 1), $registro->emp_id_fnr, '', 'fnr_id', true);
            $data["slcFuenteReclutamiento"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            $select = $this->gsatelite->get_dropdown('tpc_tipo_cuenta', '{tpc_nombre}', '', array('tpc_estado' => 1), $registro->emp_id_tpc, '', 'tpc_id', true);
            $data["slcTipoCuenta"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            $select = $this->gsatelite->get_dropdown('gen_genero', '{gen_nombre}', '', array('gen_estado' => 1), $registro->emp_id_gen, '', 'gen_id', true);
            $data["genero"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);

            //Tab insumos
            $select = $this->gsatelite->get_dropdown('tim_tipo_insumo', '{tim_nombre}', '', array('tim_estado' => 1), null, '', 'tim_id', true);
            $data["slcTipoInsumo"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);

            //Tab capacitaciones            
            $select = $this->gsatelite->get_dropdown('icp_institucion_capacitacion', '{icp_nombre}', '', array('icp_estado' => 1), null, '', 'icp_id', true);
            $data["slcInstitucionCapacitacion"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);

            $select = $this->gsatelite->get_dropdown('ese_estado_estudio', '{ese_nombre}', '', array('ese_estado' => 1), null, '', 'ese_id', true);
            $data["slcEstadoEstudio"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            $data['ver_detalle']  = ($ver_detalle == null || $ver_detalle == 0) ? null : $ver_detalle;

            if($informacion[0]['emp_codigo']!=''){
                $data['codigo'] = $informacion[0]['emp_codigo'];
            }else{
                $last=$this->consultas->get_max_codigo('emp_empleado','emp_codigo');
                $code=$last->codigo;
                $cod= (float)$code+1;
                $codigo = str_pad($cod, 4, '0', STR_PAD_LEFT);
                $data['codigo'] = $codigo;
            }
            $dct = $this->input->get('dct');
            if ($dct == 1) {
                $data['dct'] = $dct;
                $titulo['titulo_personal'] = "Editar Docente";
            } else {
                $titulo['titulo_personal'] = "Editar Empleada/o";
            }
            // $titulo['titulo_personal'] = "Gestión de empleados";
            $prox_vac = null;
            if ($informacion[0]['emp_fecha_ult_vacacion']!='') {//Fecha insertada menos 365 dias como ultima Vacacion
                $antigua = formatear_fecha('Y-m-d', $informacion[0]['emp_fecha_ult_vacacion']);
                $antigua = strtotime($antigua);
                $actual = strtotime('+365 day', $antigua);
                $prox_vac =  date('Y-m-d', $actual);
            }
            $data['prox_vac'] = $prox_vac;
            if ($ver_detalle == 1) {
                $titulo['titulo_personal'] = "Ver Datos de Empleada/o";
                cargarvista($titulo, $data, 'auto_gestion/acciones/autoeditar_empleado');
            } else {
                $this->_cargarvista($titulo, $data);
            }            
        }
    }

    function empleado_autoeditar() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else { 
            $emp_id = $this->input->post('id');
            $cod_post = trim($this->input->post('codigo_emp'));
            $reg_cod = $this->gsatelite->get_registro('emp_empleado', array('emp_codigo'=>$cod_post, 'emp_id <>'=>$emp_id));
            if(count($reg_cod)>0){
                $last=$this->consultas->get_max_codigo('emp_empleado','emp_codigo');
                $code=$last->codigo;
                $cod= (float)$code+1;
                $codigo = str_pad($cod, 4, '0', STR_PAD_LEFT);
            }else{
                $codigo = $cod_post;
            }
            if ($this->input->post("fecha_prox_vac")!='') {//Fecha insertada menos 365 dias
                $actual   =  strtotime($this->input->post("fecha_prox_vac"));
                $anterior =  strtotime('-365 day', $actual);
                $fecha_anterior =  date('d-m-Y', $anterior);
            }

            $editar = array(
                'emp_nombre' => $this->input->post('nombres'),
                'emp_apellido' => $this->input->post('apellidos'),
                'emp_direccion' => $this->input->post('direccion'),
                'emp_lugar_nac' => $this->input->post('lugar_nacimiento'),
                'emp_usu_mod' => $this->tank_auth->get_user_id(),
                'emp_fecha_mod' => date('Y-m-d H:i:s'),
                'emp_codigo' => $codigo,
                // 'emp_id_pai' => ($this->input->post('slcNacionalidad') > 0) ? $this->input->post('slcNacionalidad') : null,
                'emp_fecha_nac' => date('Y-m-d', strtotime($this->input->post('fecha_nacimiento'))),
                'emp_id_gen' => ($this->input->post('genero') != "") ? $this->input->post('genero') : null,
                // 'emp_id_cnt' => ($this->input->post('slcCuentaCont') > 0) ? $this->input->post('slcCuentaCont') : null,
                'emp_id_pro' => ($this->input->post('profesion') != "") ? $this->input->post('profesion') : null,
                'emp_id_esc' => ($this->input->post('estado_civil') != "") ? $this->input->post('estado_civil') : null,
                'emp_id_ban' => ($this->input->post('banco') != "") ? $this->input->post('banco') : null,
                'emp_numero_cuenta' => $this->input->post('cuenta_banco'),
                'emp_id_pat_contacto' => ($this->input->post("contact_parentesco") != "") ? $this->input->post("contact_parentesco") : null, //id_parentesco
                'emp_estatura' => ($this->input->post("enf_estatura") != "") ? $this->input->post("enf_estatura") : null,
                'emp_peso' => ($this->input->post("enf_peso") != "") ? $this->input->post("enf_peso") : null,
                'emp_id_tsr' => ($this->input->post("slcTipoSangre") > 0)? $this->input->post("slcTipoSangre"):null,
                'emp_discapacidad' => $this->input->post("enf_discapacidad"),
                'emp_id_tds' => ($this->input->post("enf_discapacidad") == 1 && $this->input->post("slcTipoDiscapacidad") > 0 )? $this->input->post("slcTipoDiscapacidad"):null,
                'emp_observacion_clinica' => $this->input->post("enf_observacion"),
                'emp_direccion_emergencia' => $this->input->post("contact_direccion"),
                'emp_telefono_emergencia' => $this->input->post("contact_telefono"),
                'emp_id_zon' => ($this->input->post("slcZona") > 0)? $this->input->post("slcZona"):null,
                'emp_id_tiv' => ($this->input->post("slcTipoCasa") > 0)? $this->input->post("slcTipoCasa"):null,
                'emp_id_tcv' => ($this->input->post("slcTipoConstruccion") > 0)? $this->input->post("slcTipoConstruccion"):null,
                'emp_expediente' => (trim($this->input->post("expediente_emp")) !='')? trim($this->input->post("expediente_emp")):null,
                'emp_id_mun' => ($this->input->post("slcMunicipio") > 0)? $this->input->post("slcMunicipio"):null,
                'emp_id_pai' => ($this->input->post("slcNacionalidad") > 0)? $this->input->post("slcNacionalidad"):null,
                'emp_es_reingreso' => ($this->input->post("ckcReingreso") > 0)? 1:0,
                'emp_es_jubilado' => ($this->input->post("ckcJubilado") > 0)? 1:0,
                'emp_fecha_jubilado' => ($this->input->post("txtFechaJubilacion") !='' )? formatear_fecha('Y-m-d', $this->input->post('txtFechaJubilacion')):null,
                'emp_id_tpc' => ($this->input->post("slcTipoCuenta") > 0)? $this->input->post("slcTipoCuenta"):null,
                //'emp_estado' => 1, //$this->input->post('estado'),//siempre en uno porque la acción de desactivar es independiente no en el editar
                // 'emp_fecha_contrato' => date('Y-m-d', strtotime($this->input->post('fecha_contratacion'))),
                // 'emp_salario' => ($this->input->post('salario') != "") ? $this->input->post('salario') : 0,
                // 'emp_salario_hora' => ($this->input->post('salario_hora') != "") ? $this->input->post('salario_hora') : null,
                // 'emp_salario_hora_nocturna' => ($this->input->post('salario_hora_noc') != "") ? $this->input->post('salario_hora_noc') : null,
                // 'emp_id_suc' => ($this->input->post('sucursal') > 0) ? $this->input->post('sucursal') : null,
                // 'emp_id_plz' => ($this->input->post('puesto') > 0) ? $this->input->post('puesto') : null,
                // 'emp_id_afp' => ($this->input->post('afp') > 0) ? $this->input->post('afp') : null,
                // 'emp_id_are' => ($this->input->post('departamento') > 0) ? $this->input->post('departamento') : null,
                // 'emp_afp' => $this->input->post('num_afp'),
                // 'emp_fecha_retiro' => (trim($this->input->post('fecha_retiro')) != "") ? date('Y-m-d', strtotime($this->input->post('fecha_retiro'))) : null,
                // 'emp_seguro' => $this->input->post('num_seg'),                
                // 'emp_observacion_contrato' => trim($this->input->post('observacion_contratacion')),
                // 'emp_id_tic' => ($this->input->post('tipo_contrato_empleado') != "") ? $this->input->post('tipo_contrato_empleado') : null,
                // 'emp_metodo_pago' => ($this->input->post('forma_pago_salario') != "") ? $this->input->post('forma_pago_salario') : null,
                //'emp_color_icono' => strtoupper($this->input->post('color_emp')),                
                //'emp_tipo_sangre' => $this->input->post("enf_sangre"),
                // 'emp_id_tps' => ($this->input->post("slcTipoSalario") > 0)? $this->input->post("slcTipoSalario"):null,
                // 'emp_id_cta' => ($this->input->post("slcCatAguinaldo") > 0)? $this->input->post("slcCatAguinaldo"):null,
                // 'emp_id_fnr' => ($this->input->post("slcFuenteReclutamiento") > 0)? $this->input->post("slcFuenteReclutamiento"):null,
                // 'emp_realizo_poligrafo' => ($this->input->post("ckcRealizaPoligrafo") > 0)? 1:0,
                // 'emp_codigo_referencia' => (trim($this->input->post("codigo_referencia")) !='')? trim($this->input->post("codigo_referencia")):null,
                // 'emp_aplica_afp' => ($this->input->post("ckcAplicaAfp") > 0)? 1:0,
                // 'emp_aplica_isss' => ($this->input->post("ckcAplicaIsss") > 0)? 1:0,
                // 'emp_fecha_ult_liquidacion' => ($this->input->post("fecha_ult_liquidacion") !='' )? formatear_fecha('Y-m-d', $this->input->post('fecha_ult_liquidacion')):null,
                // 'emp_fecha_fin_contrato' => ($this->input->post("fecha_fin_contrato") !='' )? formatear_fecha('Y-m-d', $this->input->post('fecha_fin_contrato')):null,
                // 'emp_fecha_antiguedad' => ($this->input->post("fecha_antiguedad") !='' )? formatear_fecha('Y-m-d', $this->input->post('fecha_antiguedad')):null,
                // 'emp_fecha_ult_aguinaldo' => ($this->input->post("fecha_ult_aguinaldo") !='' )? formatear_fecha('Y-m-d', $this->input->post('fecha_ult_aguinaldo')):null,
                // 'emp_fecha_ult_vacacion'=> ($this->input->post("fecha_prox_vac") !='' )? formatear_fecha('Y-m-d', $fecha_anterior):null,
                // 'emp_fecha_poligrafo' => ($this->input->post("txtFecha_poligrafo") !='' )? formatear_fecha('Y-m-d', $this->input->post('txtFecha_poligrafo')):null,
                // 'emp_fecha_prox_poligrafo' => ($this->input->post("txtFecha_prox_poligrafo") !='' )? formatear_fecha('Y-m-d', $this->input->post('txtFecha_prox_poligrafo')):null
                'emp_contacto_emergencia' => $this->input->post("contact_a")


            );
            $this->db->where('emp_id', $emp_id)->update('emp_empleado', $editar);

            /************Ingresar en la tabla promocion_plaza_salarioxemp*********************/
            //Esta edicion solo esta permitida si el empleado solo posee un registro en pps_promocion_plaza_salarioxemp por tal motivo al editar solo se usa
            //el id del empleado para actualizar el registro en dicha tabla, si tienen mas de 2 registros ya no podra actualizarse desde aca
            $num_promos = count($this->gsatelite->get_tabla('pps_promocion_plaza_salarioxemp', array('pps_id_emp' => $emp_id)));
            if($num_promos <= 1 ){
                if($this->input->post('puesto') > 0){
                    $newarea = $this->gsatelite->get_campo('plz_plaza', 'plz_id_are', array('plz_id' => $this->input->post('puesto')));
                    $this->gsatelite->actualizar_array('pps_promocion_plaza_salarioxemp', array('pps_id_plz' => $this->input->post('puesto'),
                                'pps_id_emp' => $emp_id,
                                'pps_id_are' => ($newarea > 0) ? $newarea : null,
                                'pps_tipo' => 0,
                                'pps_salario' => ($this->input->post('salario') != "") ? $this->input->post('salario') : 0,
                                'pps_fecha_efectiva' => formatear_fecha('Y-m-d', $this->input->post('fecha_contratacion')),
                                'pps_fecha_desde' => formatear_fecha('Y-m-d', $this->input->post('fecha_contratacion')),                        
                                'pps_fecha_hasta' => null,                        
                                'pps_estado' => 1,
                                'pps_usu_creacion' => $this->tank_auth->get_user_id(),
                                'pps_fecha_creacion' => date('Y-m-d H:i:s'),
                                'pps_usu_modificacion' => $this->tank_auth->get_user_id(),
                                'pps_fecha_modificacion' => date('Y-m-d H:i:s')
                            ), array('pps_id_emp' => $emp_id));
                }
            } elseif ($num_promos == 0) { //si no existe insertarlo.
                $newarea = $this->gsatelite->get_campo('plz_plaza', 'plz_id_are', array('plz_id' => $this->input->post('puesto')));
                $this->db->insert('pps_promocion_plaza_salarioxemp', array('pps_id_plz' => $this->input->post('puesto'),
                            'pps_id_emp' => $emp_id,
                            'pps_id_are' => ($newarea > 0) ? $newarea : null,
                            'pps_id_emr' => $this->tank_auth->get_empresa_id(),
                            'pps_tipo' => 0,
                            'pps_salario' => ($this->input->post('salario') != "") ? $this->input->post('salario') : 0,
                            'pps_fecha_efectiva' => formatear_fecha('Y-m-d', $this->input->post('fecha_contratacion')),
                            'pps_fecha_desde' => formatear_fecha('Y-m-d', $this->input->post('fecha_contratacion')),                        
                            'pps_fecha_hasta' => null,                        
                            'pps_estado' => 1,
                            'pps_usu_creacion' => $this->tank_auth->get_user_id(),
                            'pps_fecha_creacion' => date('Y-m-d H:i:s'),
                            'pps_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'pps_fecha_modificacion' => date('Y-m-d H:i:s')
                        ));
            }
            /*****************************************************/

            $this->db->where('txe_id_emp', $emp_id)
                    ->delete('txe_tipo_planillaxempleado');

            $tpl = $this->input->post('tipo_contrato');
            for ($i = 0; $i < count($tpl); $i++) {
                if ($tpl[$i] != null) {
                    $this->db->insert('txe_tipo_planillaxempleado', array('txe_id_tpl' => $tpl[$i], 'txe_id_emp' => $emp_id));
                }
            }
            //ACTUALIZAR LOS TIPOS DE SEGURO DEL EMPLEADO
            //preguntar por los existentes
            $consul = $this->gsatelite->get_tabla('sxe_seguroxempleado', array('sxe_id_emp' => $emp_id));
            $seleccionados_activos = array();
            foreach ($consul as $f) {
                $seleccionados_activos[] = $f['sxe_id_seg'];
            }

            $tseg = $this->input->post('tipo_seguro');
            for ($i = 0; $i < count($tseg); $i++) {
                if ($tseg[$i] > 0) {
                    if (!in_array($tseg[$i], $seleccionados_activos)) { //preguntar si se ha elegido uno nuevo
                        $this->db->insert('sxe_seguroxempleado', array('sxe_id_seg' => $tseg[$i],
                            'sxe_id_emp' => $emp_id,
                            'sxe_estado' => 1,
                            'sxe_usu_mod' => $this->tank_auth->get_user_id(),
                            'sxe_fecha_mod' => date('Y-m-d H:i:s')
                        ));
                    } else {// si existe unicamente actualizar los campos de auditoria
                        $cadena = array(
                            'sxe_estado' => 1,
                            'sxe_usu_mod' => $this->tank_auth->get_user_id(),
                            'sxe_fecha_mod' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->actualizar_array('sxe_seguroxempleado', $cadena, array('sxe_id_seg' => $tseg[$i], 'sxe_id_emp' => $emp_id));
                    }
                }
            }

//AHORA RECORRER LOS EXISTENTES Y PREGUNTAR CUAL NO SE HA ELEGIDO
            for ($i = 0; $i < count($seleccionados_activos); $i++) {
                if (!in_array($seleccionados_activos[$i], $tseg)) {
                    $cadena = array(
                        'sxe_estado' => 0
                        , 'sxe_usu_mod' => $this->tank_auth->get_user_id()
                        , 'sxe_fecha_mod' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->actualizar_array('sxe_seguroxempleado', $cadena, array('sxe_id_seg' => $seleccionados_activos[$i], 'sxe_id_emp' => $emp_id));
                }
            }
/////////////////FIN ACTUALIZACIÓN DE TIPOS DE SEGURO
///INICIO ACTUALIZACION DE LOS CORREOS DEL EMPLEADO
            $this->db->where('cxp_id_emp', $emp_id)
                    ->delete('cxp_correoxempleado');

            $correos = $this->input->post('correo_empleado');
            for ($i = 0; $i < count($correos); $i++) {
                if ($correos[$i] != null and trim($correos[$i]) != '') {
                    $this->db->insert('cxp_correoxempleado', array('cxp_id_emp' => $emp_id,
                        'cxp_correo' => $correos[$i],
                        'cxp_estado' => 1,
                        'cxp_usu_mod' => $this->tank_auth->get_user_id(),
                        'cxp_fecha_mod' => date('Y-m-d H:i:s')
                    ));
                }
            }

//FIN DE LA ACTUALIZACION DE LOS CORREOS DEL EMPLEADO
////////Inicio de modificacion de telefonos
            //obtenemos los ids de la relacion del empleado con los telefonos
            $telefonos_empleado = $this->personal_model->get_id_telefono($emp_id);
            $telefonos_seleccionados_ids = array();
            //guardamos los id de los telefonos que el usuario tiene actualmente
            foreach ($telefonos_empleado as $tel_emp) {
                $telefonos_seleccionados_ids[] = $tel_emp['tel_id'];
            }

            //toma de datos del formulario
            $array_ids_telefono = $this->input->post('ids_telefono_empleado');
            $array = $this->input->post('numeros_telefons'); //numeros de telefonos
            $array_tit = $this->input->post('tipos_telefons');

            //verificamos si en el array de los telefonos del usuario coinciden con los del formulario
            for ($x = 0; $x < count($array); $x++) {
                if (trim($array[$x]) != "" && trim($array_tit[$x]) != "") {
                    //si no existe el id en el array se inserta
                    if (!in_array($array_ids_telefono[$x], $telefonos_seleccionados_ids)) {
                        $this->db->insert('tel_telefono', array(
                            'tel_numero' => $array[$x],
                            'tel_id_tit' => $array_tit[$x],
                            'tel_estado' => 1,
                            'tel_usu_crea' => $this->tank_auth->get_user_id(),
                            'tel_usu_mod' => $this->tank_auth->get_user_id(),
                            'tel_fecha_crea' => date('Y-m-d H:i:s'),
                            'tel_fecha_mod' => date('Y-m-d H:i:s')
                        ));
                        $tel_id = $this->db->insert_id();
                        $this->db->insert('txm_telefonoxempleado', array(
                            'txm_id_tel' => $tel_id,
                            'txm_id_emp' => $emp_id
                        ));
                    } else {
                        $cadena_tel = array(
                            'tel_numero' => $array[$x],
                            'tel_id_tit' => $array_tit[$x],
                            'tel_estado' => 1,
                            'tel_usu_mod' => $this->tank_auth->get_user_id(),
                            'tel_fecha_mod' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->actualizar_array('tel_telefono', $cadena_tel, array('tel_id' => $array_ids_telefono[$x]));
                    }
                }
            }
            //Si el id se a eliminado del formulario entonces el estado pasa a 0
            for ($z = 0; $z < count($telefonos_seleccionados_ids); $z++) {
                if (!in_array($telefonos_seleccionados_ids[$z], $array_ids_telefono)) {
                    $cadena = array(
                        'tel_estado' => 0,
                        'tel_usu_mod' => $this->tank_auth->get_user_id(),
                        'tel_fecha_mod' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->actualizar_array('tel_telefono', $cadena, array('tel_id' => $telefonos_seleccionados_ids[$z]));
                }
            }
            /* ====================================================================================================================
              =                             ACTUALIZAR ENFERMEDAD
              ======================================================================================================================
             */
            $enfermedad = $this->gsatelite->get_tabla('exe_enfermedadxempleado', array('exe_estado' => 1, 'exe_id_emp' => $emp_id));
            $exe_enf_ids = array();
            $enf_ids = array();
            foreach ($enfermedad as $key) {
                $exe_enf_ids[] = $key["exe_id"];
                $enf_ids[] = $key["exe_id_enf"];
            }
            $exe_id_enf = $this->input->post("exe_id_enf");
            $enf_tipo = $this->input->post("enf_tipo"); //id_enf_enfermedad

            $exe_id = 0;
            foreach ($enf_tipo as $key) {
                if (trim($key) != "") {
                    if (!in_array($key, $enf_ids)) {
                        $this->db->insert('exe_enfermedadxempleado', array(
                            'exe_id_enf' => $key,
                            'exe_id_emp' => $emp_id,
                            'exe_estado' => 1,
                            'exe_fecha_creacion' => date('Y-m-d H:i:s'),
                            'exe_usu_creacion' => $this->tank_auth->get_user_id(),
                            'exe_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'exe_fecha_modificacion' => date('Y-m-d H:i:s')
                        ));
                    } else {
                        $cadena_enf = array(
                            'exe_estado' => 1,
                            'exe_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'exe_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->actualizar_array('exe_enfermedadxempleado', $cadena_enf, array('exe_id' => $exe_enf_ids[$exe_id]));
                    }
                }
                $exe_id ++;
            }

            for ($enf_del = 0; $enf_del < count($enf_ids); $enf_del++) {
                if (!in_array($enf_ids[$enf_del], $enf_tipo)) {
                    $cadena = array(
                        'exe_estado' => 0,
                        'exe_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'exe_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->actualizar_array('exe_enfermedadxempleado', $cadena, array('exe_id' => $exe_enf_ids[$enf_del]));
                }
            }


            $alergico = $this->gsatelite->get_tabla('cae_componente_alergico_empleado', array('cae_estado' => 1, 'cae_id_emp' => $emp_id));

            $cae_aler_ids = array(); //Se almacenan los ids de la relacion de la alergia con el empleado
            $aler_ids = array(); //Se almacenan los ids de la relacion de la alergia con el empleado
            foreach ($alergico as $key) {
                $cae_aler_ids[] = $key["cae_id"];
                $aler_ids[] = $key["cae_id_coa"];
            }
            $cae_id_enf = $this->input->post("cae_id_enf");
            $enf_alergia = $this->input->post("enf_alergia"); //id_cos_componente

            $cae_id = 0;
            foreach ($enf_alergia as $key) {
                if (trim($key) != "") {
                    if (!in_array($key, $aler_ids)) {
                        $this->db->insert('cae_componente_alergico_empleado', array(
                            'cae_id_coa' => $key,
                            'cae_id_emp' => $emp_id,
                            'cae_estado' => 1,
                            'cae_fecha_creacion' => date('Y-m-d H:i:s'),
                            'cae_usu_creacion' => $this->tank_auth->get_user_id(),
                            'cae_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'cae_fecha_modificacion' => date('Y-m-d H:i:s')
                        ));
                    } else {
                        $cadena_aler = array(
                            'cae_estado' => 1,
                            'cae_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'cae_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->actualizar_array('cae_componente_alergico_empleado', $cadena_aler, array('cae_id' => $cae_id_enf[$cae_id]));
                    }
                }
                $cae_id++;
            }

            for ($aler_del = 0; $aler_del < count($aler_ids); $aler_del++) {
                if (!in_array($aler_ids[$aler_del], $enf_alergia)) {
                    $cadena = array(
                        'cae_estado' => 0,
                        'cae_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'cae_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->actualizar_array('cae_componente_alergico_empleado', $cadena, array('cae_id' => $cae_aler_ids[$aler_del]));
                }
            }

            /* =====================================================================================================================
              =                                 EDITAR DATOS FAMILIARES
              =======================================================================================================================
             */

            /*
              $this->db->where('fam_id_emp',$emp_id)
              ->delete('fam_familiar');
             */

            /* Verificar los familiares que tiene ese empleado */
            $consul = $this->gsatelite->get_tabla('fam_familiar', array('fam_id_emp' => $emp_id, 'fam_estado' => 1));
            $seleccionados_activos = array();
            foreach ($consul as $f) {
                $seleccionados_activos[] = $f['fam_id'];
            }
            
            /* Se obtiene los datos ha capturar de los familiares de empleado */
            $array3 = $this->input->post('nombres_familiares');
            $array3_1 = $this->input->post('apellidos_familiares');
            $array3_2 = $this->input->post('parentesco_familiares');
            $array3_3 = $this->input->post('telefono_familiares');
            $array3_4 = $this->input->post('fechas_familiares');
            $array3_5 = $this->input->post('dependencia_familiares');
            $array3_6 = $this->input->post('institucion_familiares');
            $array3_7 = $this->input->post('id_empleado_familiares');
            $array3_82 = $this->input->post('reside_con_empleado_familiares');
            $array3_8 = $this->input->post('familiar_ids');
            $array3_9 = $this->input->post('beneficiario_familiares');
            $array3_10 = $this->input->post('beneficia_porcentaje_familiares');
            $i = 0;
            foreach ($array3 as $key => $value3) {
                if (trim($value3) != "" && trim($array3_1[$i]) != "" && trim($array3_2[$i]) != "" && trim($array3_5[$i]) != "") {
                    if (in_array($array3_8[$i], $seleccionados_activos)) {
                            $cadena = array(
                            'fam_nombre' => $value3,
                            'fam_apellido' => $array3_1[$i],
                            'fam_fecha_nacimiento' => (trim($array3_4[$i]) != "")? date('Y-m-d', strtotime($array3_4[$i])) : null,
                            'fam_dependiente' => (is_numeric($array3_5[$i]))? $array3_5[$i]:null,
                            'fam_empresa' => (is_numeric($array3_6[$i]))? $array3_6[$i]:null,
                            'fam_estado' => 1,
                            'fam_id_pat' => $array3_2[$i],
                            'fam_telefono' => $array3_3[$i],
                            'fam_beneficiario' =>  (is_numeric($array3_9[$i]))?  $array3_9[$i]:null,
                            'fam_porcentaje_beneficio' =>  (is_numeric($array3_10[$i]))? $array3_10[$i]:null,
                            'fam_reside_empleado' => ($array3_82[$i] > 0) ? $array3_82[$i] :0,
                            'fam_usu_mod' => $this->tank_auth->get_user_id(),
                            'fam_fecha_mod' => date('Y-m-d H:i:s')
                        );
                            /*print_r($cadena);die();*/
                        $this->gsatelite->actualizar_array('fam_familiar', $cadena, array('fam_id' => $array3_8[$i], 'fam_id_emp' => $emp_id));
                    } else {
                        $cadena2 = array(
                            'fam_nombre' => $value3,
                            'fam_apellido' => $array3_1[$i],
                            'fam_fecha_nacimiento' => (trim($array3_4[$i]) != "") ? date('Y-m-d', strtotime($array3_4[$i])) : null,
                            'fam_dependiente' => (is_numeric($array3_5[$i]))? $array3_5[$i]:null, 
                            'fam_empresa' => (is_numeric($array3_6[$i]))? $array3_6[$i]:null, 
                            'fam_estado' => 1,
                            'fam_id_pat' => $array3_2[$i],
                            'fam_id_emp' => $emp_id,
                            'fam_id_emp_familiar' => ($array3_7[$i]) ? $array3_7[$i] : null,
                            'fam_reside_empleado' => ($array3_82[$i] > 0) ? $array3_82[$i] :0,
                            'fam_beneficiario' =>  (is_numeric($array3_9[$i]))? $array3_9[$i]:null, 
                            'fam_porcentaje_beneficio' =>  (is_numeric($array3_10[$i]))? $array3_10[$i]:null, 
                            'fam_telefono' => $array3_3[$i],
                            'fam_usu_crea' => $this->tank_auth->get_user_id(),
                            'fam_fecha_crea' => date('Y-m-d H:i:s'),
                            'fam_usu_mod' => $this->tank_auth->get_user_id(),
                            'fam_fecha_mod' => date('Y-m-d H:i:s'));
                        $fam_id = $this->db->insert('fam_familiar',$cadena2);
                        /*print_r($fam_id);die();*/
                    }
                } 
                $i++;
            }

            for ($j = 0; $j < count($seleccionados_activos); $j++) {
                if (!in_array($seleccionados_activos[$j], $array3_8)) {
                    $cadena = array(
                        'fam_estado' => 0,
                        'fam_usu_mod' => $this->tank_auth->get_user_id(),
                        'fam_fecha_mod' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->actualizar_array('fam_familiar', $cadena, array('fam_id' => $seleccionados_activos[$j], 'fam_id_emp' => $emp_id));
                }
            }

            /* ===============================================================================================================================
              =                                         ACTUALIZACION DE IDIOMAS
              =================================================================================================================================
             */

            $consul_idioma_emp = $this->gsatelite->get_tabla('iem_idioma_empleado', array('iem_id_emp' => $emp_id, 'iem_estado' => 1));
            //se guardan los ids de los familiares existentes
            $ids_idioma_emp = array();
            foreach ($consul_idioma_emp as $key) {
                $ids_idioma_emp[] = $key['iem_id'];
            }

            //Guarda los datos de los idiomas
            $array4 = $this->input->post('idioma');
            $array4_1 = $this->input->post('nivel');
            $array4_2 = $this->input->post('leer');
            $array4_3 = $this->input->post('escribir');
            $array4_4 = $this->input->post('hablar');
            $array4_5 = $this->input->post('traductor');
            $array4_6 = $this->input->post('id_iem_idioma');

            for ($i_d = 0; $i_d < count($array4); $i_d++) {
                if ($array4[$i_d] != "" && $array4_1[$i_d] != "") {
                    if (!in_array($array4_6[$i_d], $ids_idioma_emp)) {
                        $this->db->insert('iem_idioma_empleado', array(
                            'iem_id_nii' => $array4_1[$i_d],
                            'iem_id_idm' => $array4[$i_d],
                            'iem_id_emp' => $emp_id,
                            'iem_leer' => ($array4_2[$i_d] != "") ? $array4_2[$i_d] : 0,
                            'iem_escribir' => ($array4_3[$i_d] != "") ? $array4_3[$i_d] : 0,
                            'iem_hablar' => ($array4_4[$i_d] != "") ? $array4_4[$i_d] : 0,
                            'iem_traductor' => ($array4_5[$i_d] != "") ? $array4_5[$i_d] : 0,
                            'iem_estado' => 1,
                            'iem_usu_creacion' => $this->tank_auth->get_user_id(),
                            'iem_fecha_creacion' => date('Y-m-d H:i:s'),
                            'iem_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'iem_fecha_modificacion' => date('Y-m-d H:i:s'))
                        );
                    } else {
                        $cadena = array(
                            'iem_id_nii' => $array4_1[$i_d],
                            'iem_id_idm' => $array4[$i_d],
                            'iem_leer' => $array4_2[$i_d],
                            'iem_escribir' => $array4_3[$i_d],
                            'iem_hablar' => $array4_4[$i_d],
                            'iem_traductor' => $array4_5[$i_d],
                            'iem_estado' => 1,
                            'iem_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'iem_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->actualizar_array('iem_idioma_empleado', $cadena, array('iem_id' => $array4_6[$i_d], 'iem_id_emp' => $emp_id));
                    }
                }
            }

            for ($i_dd = 0; $i_dd < count($ids_idioma_emp); $i_dd++) {
                if (!in_array($ids_idioma_emp[$i_dd], $array4_6)) {
                    $cadena = array(
                        'iem_estado' => 0,
                        'iem_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'iem_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->actualizar_array('iem_idioma_empleado', $cadena, array('iem_id' => $ids_idioma_emp[$i_dd], 'iem_id_emp' => $emp_id));
                }
            }


            /* ===============================================================================================================================
              =                                         ACTUALIZACION DE CERTIFICADOS DE IDIOMA
              =================================================================================================================================
             */

            $consul_cer_idioma_emp = $this->gsatelite->get_tabla('cri_certificacion_idioma', array('cri_id_emp' => $emp_id, 'cri_estado' => 1));
            $ids_cer_idioma_emp = array();
            foreach ($consul_cer_idioma_emp as $key) {
                $ids_cer_idioma_emp[] = $key['cri_id'];
            }

            $array5 = $this->input->post('idioma_cert');
            $array5_1 = $this->input->post('tipo_cert');
            $array5_2 = $this->input->post('puntaje_cert');
            $array5_3 = $this->input->post('fecha_cert');
            $array5_4 = $this->input->post('id_cri_idioma');

            for ($c_d = 0; $c_d < count($array5); $c_d++) {
                if ($array5[$c_d] != "" && $array5_1[$c_d] != "" && $array5_2[$c_d] != "" && $array5_3[$c_d] != "") {
                    if (!in_array($array5_4[$c_d], $ids_cer_idioma_emp)) {
                        $this->db->insert('cri_certificacion_idioma', array(
                            'cri_id_emp' => $emp_id,
                            'cri_id_cer' => $array5_1[$c_d],
                            'cri_id_idm' => $array5[$c_d],
                            'cri_puntaje' => $array5_2[$c_d],
                            'cri_fecha_certificacion' => (trim($array5_3[$c_d]) != "") ? date('Y-m-d', strtotime($array5_3[$c_d])) : null,
                            'cri_estado' => 1,
                            'cri_usu_creacion' => $this->tank_auth->get_user_id(),
                            'cri_fecha_creacion' => date('Y-m-d H:i:s'),
                            'cri_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'cri_fecha_modificacion' => date('Y-m-d H:i:s')
                        ));
                    } else {
                        $cadena = array(
                            'cri_id_cer' => $array5_1[$c_d],
                            'cri_id_idm' => $array5[$c_d],
                            'cri_puntaje' => $array5_2[$c_d],
                            'cri_fecha_certificacion' => (trim($array5_3[$c_d]) != "") ? date('Y-m-d', strtotime($array5_3[$c_d])) : null,
                            'cri_estado' => 1,
                            'cri_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'cri_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->actualizar_array('cri_certificacion_idioma', $cadena, array('cri_id' => $array5_4[$c_d], 'cri_id_emp' => $emp_id));
                    }
                }
            }

            for ($c_dd = 0; $c_dd < count($ids_cer_idioma_emp); $c_dd++) {
                if (!in_array($ids_cer_idioma_emp[$c_dd], $array5_4)) {
                    $cadena = array(
                        'cri_estado' => 0,
                        'cri_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'cri_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->actualizar_array('cri_certificacion_idioma', $cadena, array('cri_id' => $ids_cer_idioma_emp[$c_dd], 'cri_id_emp' => $emp_id));
                }
            }

            /* ===============================================================================================================================
              =                                         ACTUALIZACION DE PROGRAMAS
              =================================================================================================================================
             */

            $consul_programa_emp = $this->gsatelite->get_tabla('pxe_programaxempleado', array('pxe_id_emp' => $emp_id, 'pxe_estado' => 1));
            //se guardan los ids de los familiares existentes
            $ids_programa_emp = array();
            foreach ($consul_programa_emp as $key) {
                $ids_programa_emp[] = $key['pxe_id'];
            }

            //Guarda los datos de los idiomas
            $array4 = $this->input->post('tipo_program');
            $array4_1 = $this->input->post('nivel_program');

            $array4_2 = $this->input->post('id_pxe_program');

            for ($i_p = 0; $i_p < count($array4); $i_p++) {
                if ($array4[$i_p] != "" && $array4_1[$i_p] != "") {
                    if (!in_array($array4_2[$i_p], $ids_programa_emp)) {
                        $this->db->insert('pxe_programaxempleado', array(
                            'pxe_id_peq' => $array4[$i_p],
                            'pxe_id_emp' => $emp_id,
                            'pxe_id_nie' => $array4_1[$i_p],
                            'pxe_estado' => 1,
                            'pxe_fecha_creacion' => date('Y-m-d H:i:s'),
                            'pxe_usu_creacion' => $this->tank_auth->get_user_id(),
                            'pxe_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'pxe_fecha_modificacion' => date('Y-m-d H:i:s')
                        ));
                    } else {
                        $cadena = array(
                            'pxe_id_peq' => $array4[$i_p],
                            'pxe_id_nie' => $array4_1[$i_p],
                            'pxe_estado' => 1,
                            'pxe_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'pxe_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->actualizar_array('pxe_programaxempleado', $cadena, array('pxe_id' => $array4_2[$i_d], 'pxe_id_emp' => $emp_id));
                    }
                }
            }

            for ($i_pp = 0; $i_pp < count($ids_programa_emp); $i_pp++) {
                if (!in_array($ids_programa_emp[$i_pp], $array4_2)) {
                    $cadena = array(
                        'pxe_estado' => 0,
                        'pxe_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'pxe_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->actualizar_array('pxe_programaxempleado', $cadena, array('pxe_id' => $ids_programa_emp[$i_pp], 'pxe_id_emp' => $emp_id));
                }
            }


            /* ===============================================================================================================================
              =                                         ACTUALIZACION DE CERTIFICADOS DE PROGRAMAS
              =================================================================================================================================
             */

            $consul_cer_program_cep = $this->gsatelite->get_tabla('cep_certificacion_programa', array('cep_id_emp' => $emp_id, 'cep_estado' => 1));
            $ids_cer_program_cep = array();
            foreach ($consul_cer_program_cep as $key) {
                $ids_cer_program_cep[] = $key['cep_id'];
            }

            $array5 = $this->input->post('program_cer');
            $array5_1 = $this->input->post('tipo_program_cer');
            $array5_2 = $this->input->post('program_puntaje_cert');
            $array5_3 = $this->input->post('program_fecha_cert');
            $array5_4 = $this->input->post('program_institucion_cert');
            $array5_5 = $this->input->post('program_modalidad_cert');


            $array5_4 = $this->input->post('id_cep_program_cer');

            for ($c_p = 0; $c_p < count($array5); $c_p++) {
                if ($array5[$c_p] != "" && $array5_1[$c_p] != "" && $array5_2[$c_p] != "" && $array5_3[$c_p] != "" && $array5_4[$c_p] != "") {
                    if (!in_array($array5_4[$c_p], $ids_cer_program_cep)) {
                        $this->db->insert('cep_certificacion_programa', array(
                            'cep_id_emp' => $emp_id,
                            'cep_id_cer' => $array5_1[$c_p],
                            'cep_id_peq' => $array5[$c_p],
                            'cep_puntaje' => $array5_2[$c_p],
                            'cep_id_mde'  => $array5_5[$c_p],
                            'cep_id_icp'  => $array5_4[$c_p],
                            'cep_fecha_certificacion' => (trim($array5_3[$c_p]) != "") ? date('Y-m-d', strtotime($array5_3[$c_p])) : null,
                            'cep_estado' => 1,
                            'cep_usu_creacion' => $this->tank_auth->get_user_id(),
                            'cep_fecha_creacion' => date('Y-m-d H:i:s'),
                            'cep_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'cep_fecha_modificacion' => date('Y-m-d H:i:s')
                        ));
                    } else {
                        $cadena = array(
                            'cep_id_cer' => $array5_1[$c_p],
                            'cep_id_peq' => $array5[$c_p],
                            'cep_puntaje' => $array5_2[$c_p],
                            'cep_id_mde'  => $array5_5[$c_p],
                            'cep_id_icp'  => $array5_4[$c_p],
                            'cep_fecha_certificacion' => (trim($array5_3[$c_p]) != "") ? date('Y-m-d', strtotime($array5_3[$c_p])) : null,
                            'cep_estado' => 1,
                            'cep_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'cep_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->actualizar_array('cep_certificacion_programa', $cadena, array('cep_id' => $array5_4[$c_p], 'cep_id_emp' => $emp_id));
                    }
                }
            }

            for ($c_pp = 0; $c_pp < count($ids_cer_program_cep); $c_pp++) {
                if (!in_array($ids_cer_program_cep[$c_pp], $array5_4)) {
                    $cadena = array(
                        'cep_estado' => 0,
                        'cep_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'cep_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->actualizar_array('cep_certificacion_programa', $cadena, array('cep_id' => $ids_cer_program_cep[$c_pp], 'cep_id_emp' => $emp_id));
                }
            }

            /* =================================================================================================================
              =                                 REFERENCIAS PERSONALES
              ===================================================================================================================
             */
            $array8 = $this->input->post('tipo_refpersonal');
            $array8_1 = $this->input->post('nombre_refpersonal');
            $array8_2 = $this->input->post('ltrabajo_refpersonal');
            $array8_3 = $this->input->post('ocupacion_refpersonal');
            $array8_4 = $this->input->post('telefono_refpersonal');
            $array8_refDescipcion = $this->input->post('referencia_refpersonal');

            $consul_refpersonal = $this->gsatelite->get_tabla('rfp_referencia_personal', array('rfp_estado' => 1, 'rfp_id_emp' => $emp_id));
            $ids_refpersonal = array();
            foreach ($consul_refpersonal as $key) {
                $ids_refpersonal[] = $key['rfp_id'];
            }

            $array8_5 = $this->input->post('id_refpersonal');

            for ($rf = 0; $rf < count($array8); $rf++) {
                if ($array8[$rf] != "" && $array8_1[$rf] != "" && $array8_2[$rf] != "" && $array8_4[$rf] != "") {
                    if (!in_array($array8_5[$rf], $ids_refpersonal)) {
                        $this->db->insert('rfp_referencia_personal', array(
                            'rfp_id_trr' => $array8[$rf],
                            'rfp_id_emp' => $emp_id,
                            'rfp_nombre' => $array8_1[$rf],
                            'rfp_lugar_trabajo' => $array8_2[$rf],
                            'rfp_ocupacion' => (trim($array8_3[$rf]) != "") ? $array8_3[$rf] : null,
                            'rfp_telefono' => $array8_4[$rf],
                            'rfp_descripcion_referencia' => (trim($array8_refDescipcion[$rf]) != '')? $array8_refDescipcion[$rf]:null,
                            'rfp_estado' => 1,
                            'rfp_fecha_creacion' => date('Y-m-d H:i:s'),
                            'rfp_usu_creacion' => $this->tank_auth->get_user_id(),
                            'rfp_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'rfp_fecha_modificacion' => date('Y-m-d H:i:s')
                        ));
                    } else {
                        $cadena = array(
                            'rfp_id_trr' => $array8[$rf],
                            'rfp_nombre' => $array8_1[$rf],
                            'rfp_lugar_trabajo' => $array8_2[$rf],
                            'rfp_ocupacion' => (trim($array8_3[$rf]) != "") ? $array8_3[$rf] : null,
                            'rfp_telefono' => $array8_4[$rf],
                            'rfp_descripcion_referencia' => (trim($array8_refDescipcion[$rf]) != '')? $array8_refDescipcion[$rf]:null,
                            'rfp_estado' => 1,
                            'rfp_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'rfp_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->actualizar_array('rfp_referencia_personal', $cadena, array('rfp_id' => $array8_5[$rf], 'rfp_id_emp' => $emp_id));
                    }
                }
            }

            for ($rff = 0; $rff < count($ids_refpersonal); $rff++) {
                if (!in_array($ids_refpersonal[$rff], $array8_5)) {
                    $cadena = array(
                        'rfp_estado' => 0,
                        'rfp_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'rfp_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->actualizar_array('rfp_referencia_personal', $cadena, array('rfp_id' => $ids_refpersonal[$rff], 'rfp_id_emp' => $emp_id));
                }
            }

            /* =================================================================================================================
              =                                 REFERENCIAS PERSONALES
              ===================================================================================================================
             */
            $array9 = $this->input->post('lugar_tra_reflab');
            $array9_1 = $this->input->post('direccion_reflab');
            $array9_2 = $this->input->post('telefono_reflab');
            $array9_3 = $this->input->post('puesto_reflab');
            $array9_4 = $this->input->post('jefe_inmediato_reflab');
            $array9_5 = $this->input->post('salario_deven_reflab');
            $array9_6 = $this->input->post('mot_retiro_reflab');


            $array9_8 = $this->input->post('nombre_referencia_reflab');
            $array9_9 = $this->input->post('desde_reflab');
            $array9_10 = $this->input->post('hasta_reflab');
            $array9_11 = $this->input->post('referencia_reflab');

            $consul_reflaboral = $this->gsatelite->get_tabla('rfl_referencia_laboral', array('rfl_estado' => 1, 'rfl_id_emp' => $emp_id));
            $ids_reflaboral = array();
            foreach ($consul_reflaboral as $key) {
                $ids_reflaboral[] = $key['rfl_id'];
            }

            $array9_7 = $this->input->post('id_reflaboral');

            for ($rl = 0; $rl < count($array9); $rl++) {
                if ($array9[$rl] != "" && $array9_1[$rl] != "" && $array9_3[$rl] != "") {
                    if (!in_array($array9_7[$rl], $ids_reflaboral)) {
                        $this->db->insert('rfl_referencia_laboral', array(
                            'rfl_id_emp' => $emp_id,
                            'rfl_lugar_trabajo' => $array9[$rl],
                            'rfl_direccion' => $array9_1[$rl],
                            'rfl_telefono' => $array9_2[$rl],
                            'rfl_puesto' => $array9_3[$rl],
                            'rfl_jefe' => $array9_4[$rl],
                            'rfl_salario_devengado' => $array9_5[$rl],
                            'rfl_motivo_retiro' => $array9_6[$rl],
                            'rfl_nombre_ref' => $array9_8[$rl],
                            'rfl_fecha_desde' => (trim($array9_9[$rl]) != '')? formatear_fecha('Y-m-d',$array9_9[$rl]):null,
                            'rfl_fecha_hasta' => (trim($array9_10[$rl]) != '')? formatear_fecha('Y-m-d',$array9_10[$rl]):null,
                            'rfl_referencia' => $array9_11[$rl],
                            'rfl_estado' => 1,
                            'rfl_fecha_creacion' => date('Y-m-d H:i:s'),
                            'rfl_usu_creacion' => $this->tank_auth->get_user_id(),
                            'rfl_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'rfl_fecha_modificacion' => date('Y-m-d H:i:s')
                        ));
                    } else {
                        $cadena = array(
                            'rfl_lugar_trabajo' => $array9[$rl],
                            'rfl_direccion' => $array9_1[$rl],
                            'rfl_telefono' => $array9_2[$rl],
                            'rfl_puesto' => $array9_3[$rl],
                            'rfl_jefe' => $array9_4[$rl],
                            'rfl_salario_devengado' => $array9_5[$rl],
                            'rfl_motivo_retiro' => $array9_6[$rl],
                            'rfl_estado' => 1,
                            'rfl_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'rfl_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->actualizar_array('rfl_referencia_laboral', $cadena, array('rfl_id' => $array9_7[$rl], 'rfl_id_emp' => $emp_id));
                    }
                }
            }

            for ($rll = 0; $rll < count($ids_reflaboral); $rll++) {
                if (!in_array($ids_reflaboral[$rll], $array9_7)) {
                    $cadena = array(
                        'rfl_estado' => 0,
                        'rfl_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'rfl_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->actualizar_array('rfl_referencia_laboral', $cadena, array('rfl_id' => $ids_reflaboral[$rll], 'rfl_id_emp' => $emp_id));
                }
            }

            /* =================================================================================================================
              =                                 DATOS ACADEMICOS
              ===================================================================================================================
             */
            $array10 = $this->input->post('tipo_datacademicos');
            $array10_1 = $this->input->post('profesion_datacademicos');
            $array10_2 = $this->input->post('institucion_datacademicos');
            $array10_3 = $this->input->post('estestudio_datacademicos');
            $array10_4 = $this->input->post('pais_datacademicos');
            $array10_5 = $this->input->post('explaboral_datacademicos');
            $array10_6 = $this->input->post('fecha_datacademicos');
            $array10_7 = $this->input->post('observacion_datacademicos');

            $array10_9 = $this->input->post('anios_cursado_estudio_datacademicos');


            $consul_dacacademic = $this->gsatelite->get_tabla('dac_dato_academico', array('dac_estado' => 1, 'dac_id_emp' => $emp_id));
            $ids_dacacademic = array();
            foreach ($consul_dacacademic as $key) {
                $ids_dacacademic[] = $key['dac_id'];
            }

            $array10_8 = $this->input->post('id_datacademic');

            for ($dta = 0; $dta < count($array10); $dta++) {
                if ($array10[$dta] > 0/* && $array10_3[$dta] != "" && $array10_4[$dta] != "" && $array10_5[$dta] */) {
                    if (!in_array($array10_8[$dta], $ids_dacacademic)) {
                        $this->db->insert('dac_dato_academico', array(
                            'dac_id_pai' => ($array10_4[$dta] > 0)? $array10_4[$dta]:null,
                            'dac_id_tie' => $array10[$dta],
                            'dac_id_pro' => ($array10_1[$dta] > 0)? $array10_1[$dta] : null,
                            'dac_id_ese' => ($array10_3[$dta] > 0)? $array10_3[$dta]:null,
                            'dac_id_emp' => $emp_id,
                            'dac_id_exl' => ($array10_5[$dta] > 0 ) ? $array10_5[$dta] : null,
                            'dac_id_ina' => ($array10_2[$dta] > 0 ) ? $array10_2[$dta] : null,
                            'dac_fecha_finalizacion' => date('Y-m-d', strtotime($array10_6[$dta])),
                            'dac_anios_cursado' => ($array10_9[$dta] > 0 ) ? $array10_9[$dta] : null,
                            'dac_observacion' => $array10_7[$dta],
                            'dac_estado' => 1,
                            'dac_fecha_creacion' => date('Y-m-d H:i:s'),
                            'dac_usu_creacion' => $this->tank_auth->get_user_id(),
                            'dac_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'dac_fecha_modificacion' => date('Y-m-d H:i:s')
                        ));
                    } else {
                        $cadena = array(
                            'dac_id_pai' => ($array10_4[$dta] > 0 )? $array10_4[$dta]:null,
                            'dac_id_tie' => $array10[$dta],
                            'dac_id_pro' => ($array10_1[$dta] != '') ? $array10_1[$dta] : null,
                            'dac_id_ese' => ($array10_3[$dta] > 0)? $array10_3[$dta]:null,
                            'dac_id_exl' => ($array10_5[$dta] != '') ? $array10_5[$dta] : null,
                            'dac_id_ina' => ($array10_2[$dta] != '') ? $array10_2[$dta] : null,
                            'dac_fecha_finalizacion' => (trim($array10_6[$dta]) != "") ? date('Y-m-d', strtotime($array10_6[$dta])) : null,
                            'dac_anios_cursado' => ($array10_9[$dta] > 0 ) ? $array10_9[$dta] : null,
                            'dac_observacion' => $array10_7[$dta],
                            'dac_estado' => 1,
                            'dac_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'dac_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->actualizar_array('dac_dato_academico', $cadena, array('dac_id' => $array10_8[$dta], 'dac_id_emp' => $emp_id));
                    }
                }
            }

            for ($dtaa = 0; $dtaa < count($ids_dacacademic); $dtaa++) {
                if (!in_array($ids_dacacademic[$dtaa], $array10_8)) {
                    $cadena = array(
                        'dac_estado' => 0,
                        'dac_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'dac_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->actualizar_array('dac_dato_academico', $cadena, array('dac_id' => $ids_dacacademic[$dtaa], 'dac_id_emp' => $emp_id));
                }
            }



            /* =================================================================================================================
              =                              INICIO GUARDADO DE HABILIDADES EMPLEADO
              ===================================================================================================================
             */

            $this->gsatelite->borrado_general('hxm_habilidadxempleado',array('hxm_id_emp'=>$emp_id));
            $hablidad_empleado = $this->input->post('hablidad_empleado');
            $nivel_hablidad_empleado = $this->input->post('nivel_hablidad_empleado');
            for ($hab_emp=0; $hab_emp < count($hablidad_empleado) ; $hab_emp++) { 
                if ($hablidad_empleado[$hab_emp] > 0) {
                   $array_insert_reg = array(
                    'hxm_id_hab' => $hablidad_empleado[$hab_emp],
                    'hxm_id_emp' => $emp_id,
                    'hxm_id_nih' => ($nivel_hablidad_empleado[$hab_emp] > 0)? $nivel_hablidad_empleado[$hab_emp]:null,
                    'hxm_estado' => 1,
                    'hxm_usu_creacion' => $this->tank_auth->get_user_id(),
                    'hxm_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'hxm_fecha_creacion' => date('Y-m-d H:i:s'),
                    'hxm_fecha_modificacion' => date('Y-m-d H:i:s')
                   );

                   $id_hxm = $this->gsatelite->ingresar('hxm_habilidadxempleado', $array_insert_reg);
                }
            }

            /* =================================================================================================================
              =                              FIN GUARDADO DE HABILIDADES EMPLEADO
              ===================================================================================================================
             */
              
              /* =================================================================================================================
              =                              INICIO EDITAR INSUMOS
              ===================================================================================================================
             */
              //Contacto
              $new = $this->input->post('txtTablaNew');
              $tipo_insumo_array = $this->input->post('tipo_insumo_array');
              $insumo_array = $this->input->post('insumo_array');
              $cantidad_insumo_array = $this->input->post('cantidad_insumo_array');
              $costo_insumo_array = $this->input->post('costo_insumo_array');
              $fecha_insumo_array = $this->input->post('fecha_insumo_array');            
              
              //obtener los detalles antiguos
              $insumos_antiguos = $this->gsatelite->get_tabla('ixe_insumoxempleado', array('ixe_id_emp' => $emp_id));
              
              //eliminacion de insumos que no existen 
              foreach ($insumos_antiguos as $insu) {
                  if (!in_array($insu['ixe_id'], $new)) {
                      $this->gsatelite->actualizar_array('ixe_insumoxempleado', array('ixe_estado' => 0),array('ixe_id' => $insu['ixe_id']));
                  }
              }

              foreach ($insumo_array as $key => $id_insu) {
                  if(trim($id_insu)){
                      if ( $new[$key] == "" ) {
                          $array_ixe_insumoxempleado = array(                        
                              'ixe_id_inm' => $insumo_array[$key],
                              'ixe_id_emp' => $emp_id,
                              'ixe_cantidad' => $cantidad_insumo_array[$key],
                              'ixe_costo' => $costo_insumo_array[$key],
                              'ixe_fecha_entrega' => formatear_fecha('Y-m-d',$fecha_insumo_array[$key]),
                              'ixe_estado' => 1,
                              'ixe_usu_creacion' => $this->tank_auth->get_user_id(),
                              'ixe_usu_modificacion' => $this->tank_auth->get_user_id(),
                              'ixe_fecha_creacion' => date('Y-m-d H:i:s'),
                              'ixe_fecha_modificacion' => date('Y-m-d H:i:s')
                          );
                          $this->gsatelite->ingresar('ixe_insumoxempleado', $array_ixe_insumoxempleado);
                      } else {
                          $array_ixe_insumoxempleado = array(                        
                              'ixe_id_inm' => $insumo_array[$key],
                              'ixe_id_emp' => $emp_id,
                              'ixe_cantidad' => $cantidad_insumo_array[$key],
                              'ixe_costo' => $costo_insumo_array[$key],
                              'ixe_fecha_entrega' => formatear_fecha('Y-m-d',$fecha_insumo_array[$key]),
                              'ixe_estado' => 1,
                              //'ixe_usu_creacion' => $this->tank_auth->get_user_id(),
                              //'ixe_usu_modificacion' => $this->tank_auth->get_user_id(),
                              'ixe_fecha_creacion' => date('Y-m-d H:i:s'),
                              'ixe_fecha_modificacion' => date('Y-m-d H:i:s')
                          );    
                          $this->gsatelite->actualizar_array('ixe_insumoxempleado', $array_ixe_insumoxempleado,array('ixe_id' => $new[$key]));
                      }                    
                  }
              }            
              /* =================================================================================================================
              =                              FIN EDITAR INSUMOS
              ===================================================================================================================
              */
                
                 /* =================================================================================================================
                 =                              INICIO EDITAR CAPACITACIONES
                 ===================================================================================================================
                */
                 //Contacto
                 $new = $this->input->post('txtTablaNewCapa');
                 $nombre_capa_array = $this->input->post('nombre_capa_array');
                 $institucion_capa_array = $this->input->post('institucion_capa_array');
                 $fecha_inicio_capa_array = $this->input->post('fecha_inicio_capa_array');                 
                 $fecha_fin_capa_array = $this->input->post('fecha_fin_capa_array');
                 $hora_duracion_capa_array = $this->input->post('hora_duracion_capa_array');
                 $costo_capa_array = $this->input->post('costo_capa_array');   
                 $costo_cubierto_insa_array = $this->input->post('costo_cubierto_insa_array');
                 $costo_cubierto_prov_array = $this->input->post('costo_cubierto_prov_array');            
                 $estado_capa_array = $this->input->post('estado_capa_array');            
                 
                 //obtener los detalles antiguos
                 $capacitaciones_antiguos = $this->gsatelite->get_tabla('cpe_capacitacion_empleado', array('cpe_id_emp' => $emp_id));
                 
                 //eliminacion de insumos que no existen 
                 foreach ($capacitaciones_antiguos as $capa) {
                     if (!in_array($capa['cpe_id'], $new)) {
                         $this->gsatelite->actualizar_array('cpe_capacitacion_empleado', array('cpe_estado' => 0),array('cpe_id' => $capa['cpe_id']));
                     }
                 }

                 foreach ($nombre_capa_array as $key => $nomca) {
                     if(trim($nomca)){
                         if ( $new[$key] == "" ) {
                             $array_cpe_capacitacion_empleado = array(                                                         
                                 'cpe_id_emp' => $emp_id,
                                 'cpe_id_ese' => is_numeric($estado_capa_array[$key])? $estado_capa_array[$key]:null,
                                 'cpe_id_icp' => is_numeric($institucion_capa_array[$key])? $institucion_capa_array[$key]:null,
                                 'cpe_nombre' => $nomca,
                                 'cpe_duracion' => $hora_duracion_capa_array[$key],
                                 'cpe_costo_empresa' => $costo_capa_array[$key],
                                 'cpe_costo_insaforp' => $costo_cubierto_insa_array[$key],
                                 'cpe_costo_proveedor' => $costo_cubierto_prov_array[$key],
                                 'cpe_fecha_inicio' => formatear_fecha('Y-m-d', $fecha_inicio_capa_array[$key]),
                                 'cpe_fecha_fin' => formatear_fecha('Y-m-d', $fecha_fin_capa_array[$key]),                                 
                                 'cpe_estado' => 1,
                                 'cpe_usu_creacion' => $this->tank_auth->get_user_id(),
                                 'cpe_usu_modificacion' => $this->tank_auth->get_user_id(),
                                 'cpe_fecha_creacion' => date('Y-m-d H:i:s'),
                                 'cpe_fecha_modificacion' => date('Y-m-d H:i:s')
                             );
                             $this->gsatelite->ingresar('cpe_capacitacion_empleado', $array_cpe_capacitacion_empleado);
                         } else {
                             $array_cpe_capacitacion_empleado = array(                                                         
                                 'cpe_id_emp' => $emp_id,
                                 'cpe_id_ese' => is_numeric($estado_capa_array[$key])? $estado_capa_array[$key]:null,
                                 'cpe_id_icp' => is_numeric($institucion_capa_array[$key])? $institucion_capa_array[$key]:null,
                                 'cpe_nombre' => $nomca,
                                 'cpe_duracion' => $hora_duracion_capa_array[$key],
                                 'cpe_costo_empresa' => $costo_capa_array[$key],
                                 'cpe_costo_insaforp' => $costo_cubierto_insa_array[$key],
                                 'cpe_costo_proveedor' => $costo_cubierto_prov_array[$key],
                                 'cpe_fecha_inicio' => formatear_fecha('Y-m-d', $fecha_inicio_capa_array[$key]),
                                 'cpe_fecha_fin' => formatear_fecha('Y-m-d', $fecha_fin_capa_array[$key]),                                 
                                 'cpe_estado' => 1,
                                 //'cpe_usu_creacion' => $this->tank_auth->get_user_id(),
                                 'cpe_usu_modificacion' => $this->tank_auth->get_user_id(),
                                 //'cpe_fecha_creacion' => date('Y-m-d H:i:s'),
                                 'cpe_fecha_modificacion' => date('Y-m-d H:i:s')
                             );    
                             $this->gsatelite->actualizar_array('cpe_capacitacion_empleado', $array_cpe_capacitacion_empleado, array('cpe_id' => $new[$key]));
                         }                    
                     }
                 }            
                 /* =================================================================================================================
                 =                              FIN EDITAR CAPACITACIONES
                 ===================================================================================================================
                 */                            


              /* =================================================================================================================
                =                              INICIO GUARDADO DE AGRUPACIONES EMPLEADO
                ===================================================================================================================
               */
            $this->gsatelite->borrado_general('age_agrupacion_empleado',array('age_id_emp'=>$emp_id));
              $agrupacion_emp = $this->input->post('agrupacion_emp');
              $anio_afiliacion = $this->input->post('anio_afiliacion');
              $estado_afiliacion = $this->input->post('estado_afiliacion');

              for ($agru_emp=0; $agru_emp < count($agrupacion_emp) ; $agru_emp++) { 
                  if (trim($agrupacion_emp[$agru_emp]) != '') {
                     $array_insert_reg = array(
                      'age_nombre' => $agrupacion_emp[$agru_emp],
                      'age_anio_afiliacion' => ($anio_afiliacion[$agru_emp] >0)? $anio_afiliacion[$agru_emp]:null,
                      'age_estado_agrupacion' => ($estado_afiliacion[$agru_emp] >0)? 1:0,
                      'age_id_emp' => $emp_id,
                      'age_estado' => 1,
                      'age_usu_creacion' => $this->tank_auth->get_user_id(),
                      'age_usu_modificacion' => $this->tank_auth->get_user_id(),
                      'age_fecha_creacion' => date('Y-m-d H:i:s'),
                      'age_fecha_modificacion' => date('Y-m-d H:i:s')
                     );

                     $id_age = $this->gsatelite->ingresar('age_agrupacion_empleado', $array_insert_reg);
                  }
              }

              /* =================================================================================================================
                =                              FIN GUARDADO DE AGRUPACIONES EMPLEADO
                ===================================================================================================================
               */

             /* =================================================================================================================
             =                              INICIO GUARDADO DE SERVICION BASICOS EMPLEADO
             ===================================================================================================================
            */
                $this->gsatelite->borrado_general('sre_servicio_empleado',array('sre_id_emp'=>$emp_id));
                 $slcServiciosBasicos = $this->input->post('slcServiciosBasicos');
                 for ($sbi = 0; $sbi < count($slcServiciosBasicos); $sbi++) {
                     if ($slcServiciosBasicos[$sbi] > 0 ) {
                         $array_insert_reg = array(
                          'sre_id_srb' => $slcServiciosBasicos[$sbi],
                          'sre_id_emp' => $emp_id,
                          'sre_estado' => 1,
                          'sre_usu_creacion' => $this->tank_auth->get_user_id(),
                          'sre_usu_modificacion' => $this->tank_auth->get_user_id(),
                          'sre_fecha_creacion' => date('Y-m-d H:i:s'),
                          'sre_fecha_modificacion' => date('Y-m-d H:i:s')
                         );

                         $id_sre = $this->gsatelite->ingresar('sre_servicio_empleado', $array_insert_reg);
                     }
                 }

              /* =================================================================================================================
              =                              FIN GUARDADO DE SERVICION BASICOS EMPLEADO
              ===================================================================================================================
             */


            /* ===============================================================================================================================
              =                                         ACTUALIZACION
              =================================================================================================================================
             */

            $rutas = $this->input->post("ruta");
            $carpeta = $this->input->post("nombreCarpeta");

            if (count($rutas) > 0) {
                $carpeta = $carpeta;
                for ($i = 0; $i < count($rutas); $i++) {
                    if ($rutas[$i] != "") {
                        $img = $rutas[$i];
                        $titulo = $this->input->post("titulo_doc" . $i);
                        $this->datos_imagen_gral($img, $emp_id, $carpeta, $titulo);
                    }
                }
            }

            $id_foto = $this->input->post('id_foto');
            $foto_editar = $this->input->post('edit_foto');

            if (trim($foto_editar) != "") {
                $img = $foto_editar;
                $titulo = $this->input->post("titulo_edit");
                $eliminar = $this->input->post('foto_eliminar');
                if (!empty($eliminar)) {
                    $this->datos_reemplazar_imagen($img, $id_foto, $carpeta, $titulo, $eliminar);
                } else {
                    $this->datos_imagen_gral($foto_editar, $emp_id, $carpeta, $titulo, 1);
                }
            }

            $dct = $this->input->post('dct');
            if ($dct == 1) {
                $docente_array = array(
                    'dct_estado' => $this->input->post('estado'),
                    'dct_usu_mod' => $this->tank_auth->get_user_id(),
                    'dct_fecha_mod' => date('Y-m-d H:i:s')
                );

                $id = $this->gsatelite->actualizar_array('dct_docente', $docente_array, array('dct_id_emp' => $emp_id));

                if ($id > 0) {
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "El registro fue actualizado correctamente", 'texto_alerta' => "Actualización de datos del docente completo");

                    $this->session->set_flashdata($alerta);
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error", 'texto_alerta' => "Hubo un problema al ingresar el registro");

                    $this->session->set_flashdata($alerta);
                }

                redirect('registro_academico/procesos/index_agregar_docente');
            } else {

                $redireccion = $this->input->post('redireccion');
                $id          = $this->input->post('id');
                $tipo        = $this->input->post('txttipo');
                $alerta      = array('tipo_alerta' => 'success', 'titulo_alerta' => "El registro fue actualizado correctamente", 'texto_alerta' => "Actualización de datos del empleado completo");

                $this->session->set_flashdata($alerta);
                if ($redireccion == 1) {
                    redirect('auto_gestion/acciones/autoeditar_empleado/'.$id.'/'.$tipo);
                } else {
                    redirect('auto_gestion/acciones/datos_empleado');
                }
            }
        }
    }

    public function datos_imagen_gral($img, $id_emp, $carpeta, $titulo_doc, $tipo = 0) {
        $extencion = end(explode(".", $img));
        $datos_1 = $this->session->keep_flashdata('datos_1');
        $nombre = trim($img);
        $ruta = "public/temp/" . $carpeta . "/" . $nombre;
        /* if($extencion=='jpg' || $extencion=='jepg' || $extencion=='png'){
          $tipo=1;
          }
          else{$tipo=0;} */

        $destino = "uploads/anexos_empleados/" . $titulo_doc . time() . "." . trim($extencion) . "";
        $dir = $this->gsatelite->get_campo('anx_anexo', 'anx_url', array('anx_url' => $destino, 'anx_estado' => 1));
        //die(print_r(count($dir)));
        if (count($dir) <= 0) {
            $array_anex = array(
                'anx_url' => $destino,
                'anx_nombre' => $titulo_doc,
                'anx_estado' => 1,
                'anx_usu_crea' => $this->tank_auth->get_user_id(),
                'anx_usu_mod' => $this->tank_auth->get_user_id(),
                'anx_fecha_crea' => date('Y-m-d H:i:s'),
                'anx_fecha_mod' => date('Y-m-d H:i:s'),
                'anx_imagen' => $tipo
            );

            $this->db->insert("anx_anexo", $array_anex);
            $id_anexo = $this->db->insert_id();
            $array_anex_doc = array(
                'axe_id_emp' => $id_emp,
                'axe_id_anx' => $id_anexo,
                'axe_estado' => 1,
                'axe_usu_mod' => $this->tank_auth->get_user_id(),
                'axe_fecha_mod' => date('Y-m-d H:i:s')
            );
            $this->db->insert("axe_anexoxempleado", $array_anex_doc);
            $carpeta_destino = "uploads/anexos_empleados/" . $titulo_doc . time() . "." . trim($extencion) . "";

            copy($ruta, $carpeta_destino);
            unlink($ruta);
        }
    }

    public function datos_anexo_documento($img, $carpeta, $titulo_doc, $url_anexo_base='') {
        
        $extencion = end(explode(".", $img));
        $nombre = trim($img);
        $ruta = "public/temp/" . $carpeta . "/" . $nombre;
        if (trim($url_anexo_base) != '') {
            $carpeta_destino = "uploads/anexos_empleados/" . $url_anexo_base;
        } else {
            $carpeta_destino = "uploads/anexos_empleados/" . $titulo_doc . time() . "." . trim($extencion) . "";
        }
        copy($ruta, $carpeta_destino);
        unlink($ruta);
    }

    function datos_reemplazar_imagen($img, $id_foto, $carpeta, $titulo, $eliminar) {
        unlink($eliminar);
        $extencion = end(explode(".", $img));
        $datos_1 = $this->session->keep_flashdata('datos_1');
        $nombre = trim($img);
        $ruta = "public/temp/" . $carpeta . "/" . $nombre;
        $destino = "uploads/anexos_empleados/" . $titulo . "." . trim($extencion) . "";
        $array = array('anx_nombre' => $titulo,
            'anx_url' => $destino,
            'anx_usu_mod' => $this->tank_auth->get_user_id(),
            'anx_fecha_mod' => date('Y-m-d H:i:s'));
        $this->db->where('anx_id', $id_foto)
                ->update('anx_anexo', $array);
        $carpeta_destino = "uploads/anexos_empleados/" . $titulo . "." . trim($extencion) . "";

        copy($ruta, $carpeta_destino);
        unlink($ruta);
    }

    public function check_documento($tipo = 1) {
        if ($tipo == 1) {
            if ($this->input->post('doc') != null and $this->input->post('doc') != "") {
                $result = $this->gsatelite->get_tabla('dce_documento_emp', array('dce_valor' => $this->input->post('doc')
                    , 'dce_id_tde' => $this->input->post('Tdoc')));

                if (count($result) > 0) {
                    print json_encode(
                                    array('exists' => true)
                    );
                } else {
                    print json_encode(
                                    array('exists' => false)
                    );
                }
            }
        } elseif ($tipo == 2) {
            if ($this->input->post('cod') != null and $this->input->post('cod') != "") {
                $result = $this->gsatelite->get_tabla('emp_empleado', array('emp_codigo' => $this->input->post('cod')));

                if (count($result) > 0) {
                    print json_encode(
                                    array('exists' => true)
                    );
                } else {
                    print json_encode(
                                    array('exists' => false)
                    );
                }
            }
        }
    }

    /**
     * @author René Castaneda
     * @return Mantenimiento documentos por empleado
     */
    function documentos_empleado_crud($id_empleado = null, $ver_detalle = null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            try {

                $crud = new grocery_CRUD();
                $this->load->config('grocery_crud');
                $this->config->set_item('grocery_crud_file_upload_allow_file_types', 'pdf|jpeg|jpg|png');

                $crud->set_table('dce_documento_emp')
                        ->set_subject('Documento')
                        ->where('dce_documento_emp.dce_id_emp', $id_empleado)
                        ->columns('dce_id_tde', 'dce_valor', 'dce_fecha_vence', 'dce_fecha_expedicion', 'dce_lugar_expedicion', 'dce_url','dce_nombre_segun_doc','dce_id_mun')
                        ->set_relation('dce_id_tde', 'tde_tipo_documento', 'tde_nombre', array('tde_estado' => 1))
                        ->set_relation('dce_id_mun','mun_municipio','mun_nombre')
                        ->add_fields('dce_id_tde', 'dce_id_emp', 'dce_valor', 'dce_fecha_vence', 'dce_fecha_expedicion', 'dce_lugar_expedicion', 'dce_fecha_registro', 'dce_url', 'dce_nombre_anexo','dce_nombre_segun_doc','dce_observacion','dce_usu_modificacion', 'dce_fecha_modificacion', 'dce_usu_creacion', 'dce_fecha_creacion','dce_id_mun')
                        ->edit_fields('dce_id_tde', 'dce_id_emp', 'dce_valor', 'dce_fecha_vence', 'dce_fecha_expedicion', 'dce_lugar_expedicion', 'dce_url', 'dce_nombre_anexo','dce_nombre_segun_doc','dce_observacion', 'dce_usu_modificacion', 'dce_fecha_modificacion', 'dce_id_mun')
                        ->display_as('dce_id_tde', 'Documento')
                        ->display_as('dce_valor', 'Valor')
                        ->display_as('dce_fecha_vence', 'Vence')
                        ->display_as('dce_fecha_expedicion', 'Fecha<br/>Expedición')
                        ->display_as('dce_lugar_expedicion', 'Lugar<br/>Expedición')
                        ->display_as('dce_id_mun', 'Municipio<br/>Expedición')
                        ->display_as('dce_url', 'Anexo')
                        ->display_as('dce_nombre_anexo', 'Titulo<br/>Anexo')
                        ->display_as('dce_nombre_segun_doc', 'Nombre<br/>según Doc')
                        ->display_as('dce_observacion', 'Observaciones')
                        ->required_fields('dce_id_tde', 'dce_valor')
                       // ->set_rules('dce_valor', 'Valor', 'trim|required|campo_unico[dce_documento_emp.dce_valor]')
                        ->set_rules('dce_id_tde', 'Documento', "trim|required|campo_unico2[dce_documento_emp.dce_id_tde.dce_id_emp.$id_empleado]")
                        ->field_type('dce_id_emp', 'hidden', $id_empleado)
                        ->field_type('dce_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                        ->field_type('dce_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
                        ->field_type('dce_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                        ->field_type('dce_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
                        ->field_type('dce_fecha_registro', 'hidden', date('Y-m-d'))
                        ->field_type('dce_estado', 'hidden', 1)                        
                        ->set_field_upload('dce_url', 'uploads/anexos_empleados')
                        ->callback_before_insert(function($post_array, $primary_key) {
                            if ($post_array['dce_fecha_vence'] != "") {
                                $post_array['dce_fecha_vence'] = implode('-', array_reverse(explode('-', $post_array['dce_fecha_vence'])));
                            }
                            if ($post_array['dce_fecha_expedicion'] != "") {
                                $post_array['dce_fecha_expedicion'] = implode('-', array_reverse(explode('-', $post_array['dce_fecha_expedicion'])));
                            }
                            return $post_array;
                        })
                        ->callback_before_update(function($post_array, $primary_key) {
                            if ($post_array['dce_fecha_vence'] != "") {
                                $post_array['dce_fecha_vence'] = implode('-', array_reverse(explode('-', $post_array['dce_fecha_vence'])));
                            }
                            if ($post_array['dce_fecha_expedicion'] != "") {
                                $post_array['dce_fecha_expedicion'] = implode('-', array_reverse(explode('-', $post_array['dce_fecha_expedicion'])));
                            }
                            return $post_array;
                        })
                        ->callback_column('dce_fecha_vence', function($value, $row) {
                            if ($value != "") {
                                return implode('-', array_reverse(explode('-', $value)));
                            } else {
                                return '';
                            }
                        })
                        ->callback_column('dce_fecha_expedicion', function($value, $row) {
                            if ($value != "") {
                                return implode('-', array_reverse(explode('-', $value)));
                            } else {
                                return '';
                            }
                        })
                        // ->set_upload_file_types('jpg','jpeg','png','pdf') //pdf|jpg|png|jpeg'
                        //->unset_delete()
                        ->unset_print()
                        ->unset_export()
                ;
                if ($ver_detalle != null and is_numeric($ver_detalle) ) {
                    $crud->unset_edit();
                    $crud->unset_delete();
                    $crud->unset_add();
                }
                $crud->add_action('Ver', 'minia-icon-search', "expediente_personal/empleado/documentos_empleado_crud/$id_empleado/read");
                $data['array_documento'] = $this->gsatelite->get_tabla("tde_tipo_documento");
                $data['id_empleado'] = $id_empleado;
                $output = $crud->render();
                $output = array_merge($data, (array) $output);

                $this->gsatelite->cargar_vista_masterpage('expediente_personal/empleado/documentos_empleado_crud', $output);
            } catch (Exception $e) {
                show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
            }
        }
    }

    /**
     * @author Herberth Lucho
     * @return Auto gestion de horas extras
     */
    public function horas_extra()
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $id_user = $this->tank_auth->get_user_id();
            $id_empleado = $this->gsatelite->get_campo('users', 'usu_id_emp', array('id'=>$id_user));            
            $permisos = $this->gsatelite->get_permisos_opcion('auto_gestion/acciones/horas_extra');
            $data['permisos'] = $permisos;
            $this->verifica_empleado_real($id_empleado);
            $registro_empleado = $this->gsatelite->get_tabla('emp_empleado', array('emp_id' => $id_empleado));
            $data["info_empleado"] = $registro_empleado;
            $data["titulo_personal"] = "Horas extras";
            $data["consulta"] = $this->auto_gestion_model->get_horas_extras(array('hxe_id_emp' => $id_empleado, 'hxe_id_the IS NOT NULL' => NULL));
            $data["id_empleado"] = $id_empleado;
            $this->_cargarvista($data, null);
        }
    }

    public function verifica_empleado_real($id_empleado) {
        if ($id_empleado == null or ! is_numeric($id_empleado) or $id_empleado <= 0) {
            $this->gsatelite->show_dialog('Empleada/o no válido', 'inicio/index', 'error');
        } else {
            $pregunta = $this->gsatelite->get_tabla('emp_empleado', array('emp_id' => $id_empleado));
            if (count($pregunta) <= 0) {
                $this->gsatelite->show_dialog('Empleada/o no válido', 'inicio/index', 'error');
            }
        }
    }

    public function agregar_horas_extras($id_empleado = null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($_POST) {
                //$registro_tipo_hora = $this->gsatelite->get_registro('the_tipo_hora_extra', 'the_id', $this->input->post('tipo_hora_extra'));
                $array_detalle = array(
                     'hxe_id_emp' => $this->input->post('emp_id')
                    , 'hxe_num_hora' => $this->input->post('n_horas')
                    , 'hxe_observacion' => $this->input->post('observaciones')
                    , 'hxe_id_the' => $this->input->post('tipo_hora_extra')
                    , 'hxe_estado' => 1
                    , 'hxe_fecha_mod' => date("Y-m-d H:i:s")
                    , 'hxe_usu_mod' => $this->tank_auth->get_user_id()
                );
                
                $this->gsatelite->ingresar('hxe_hora_extraxempleado', $array_detalle);
                $this->gsatelite->show_dialog("Proceso realizado con éxito", "auto_gestion/acciones/horas_extra");
            } else {
                $this->verifica_empleado_real($id_empleado);
                
                $data["titulo_personal"] = "Gestión de horas extras";
                $data["info_empleado"] = $this->gsatelite->get_tabla('emp_empleado', array('emp_id' => $id_empleado));
                //PLANILLAS AL QUE PERTENECE EL EMPLEADO
                $ids_tpl = array(0);
                $pregunta = $this->gsatelite->get_tabla('txe_tipo_planillaxempleado', array('txe_id_emp' => $id_empleado));
                foreach ($pregunta as $fila) {
                    $ids_tpl[] = $fila['txe_id_tpl'];
                }
                $this->db->where_in('tpl_id', $ids_tpl);
                $select = $this->gsatelite->get_dropdown('tpl_tipo_planilla', '{tpl_nombre}', '', null, null, '', 'tpl_id', true);
                $data["select_tpl_id"] = str_replace('<option value="0">Seleccione</option>', '', $select);

                $select = $this->gsatelite->get_dropdown('the_tipo_hora_extra', '{the_nombre} ({the_factor})', '', array('the_estado' => 1), null, '', 'the_id', true);
                $data["select_tipo_hora_extra"] = str_replace('<option value="0">Seleccione</option>', '', $select);
                $this->_cargarvista($data, null);
            }
        }
    }

    public function editar_horas_extras($id_hora_extra = null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($_POST) {
                $this->gsatelite->get_registro('the_tipo_hora_extra', 'the_id', $this->input->post('tipo_hora_extra'));

                $id_detalle_horas = $this->input->post('hxe_id');
                $array_detalle = array(
                     'hxe_id_the' => $this->input->post('tipo_hora_extra')
                    , 'hxe_id_emp' => $this->input->post('emp_id')
                    , 'hxe_num_hora' => $this->input->post('n_horas')
                    , 'hxe_observacion' => $this->input->post('observaciones')
                    , 'hxe_estado' => $this->input->post('estado')
                    , 'hxe_fecha_mod' => date("Y-m-d H:i:s")
                    , 'hxe_usu_mod' => $this->tank_auth->get_user_id()
                );
                $this->gsatelite->actualizar_array('hxe_hora_extraxempleado', $array_detalle, array('hxe_id' => $id_detalle_horas));
                $this->gsatelite->show_dialog("Proceso realizado con éxito", "auto_gestion/acciones/horas_extra/");
            } else {
                $this->verifica_registro_real('hxe_hora_extraxempleado', $id_hora_extra);
                $registro_hora_extra = $this->auto_gestion_model->get_horas_extras(array('hxe_id' => $id_hora_extra));
                
                $registro_hora_extra = $registro_hora_extra[0];
                $id_empleado = $registro_hora_extra['hxe_id_emp'];
                $data["titulo_personal"] = "Gestión de horas extras";
                $data["registro_hora"] = $registro_hora_extra;
                $data["info_empleado"] = $this->gsatelite->get_tabla('emp_empleado', array('emp_id' => $id_empleado));
                //PLANILLAS AL QUE PERTENECE EL EMPLEADO
                $ids_tpl = array(0);
                $pregunta = $this->gsatelite->get_tabla('txe_tipo_planillaxempleado', array('txe_id_emp' => $id_empleado));
                foreach ($pregunta as $fila) {
                    $ids_tpl[] = $fila['txe_id_tpl'];
                }
                $this->db->where_in('tpl_id', $ids_tpl);
                $select = $this->gsatelite->get_dropdown('tpl_tipo_planilla', '{tpl_nombre}', '', null, $registro_hora_extra['tpl_id'], '', 'tpl_id', true);
                $data["select_tpl_id"] = str_replace('<option value="0">Seleccione</option>', '', $select);

                $select = $this->gsatelite->get_dropdown('the_tipo_hora_extra', '{the_nombre} ({the_factor}%)', '', array('the_estado' => 1), $registro_hora_extra['the_id'], '', 'the_id', true);
                $data["select_tipo_hora_extra"] = str_replace('<option value="0">Seleccione</option>', '', $select);

                $select = $this->gsatelite->get_dropdown('pla_planilla', '{pla_fecha_inicio} # {pla_fecha_fin}', '', array('pla_id_tpl' => $registro_hora_extra['tpl_id'], 'pla_estado >=' => 1, 'pla_estado <=' => 2), $registro_hora_extra['pla_id'], '', 'pla_id', true);
                $data["select_periodo_planilla"] = str_replace('<option value="0">Seleccione</option>', '', $select);

                $this->_cargarvista($data, null);
            }
        }
    }

    public function verifica_registro_real($tabla, $id = null) {
        if ($id == null or ! is_numeric($id) or $id <= 0) {
            $this->gsatelite->show_dialog('Petición no Válida', 'auto_gestion', 'error');
        } else {
            $prefijo = explode('_', $tabla);
            $pregunta = $this->gsatelite->get_tabla($tabla, array($prefijo[0] . '_id' => $id));
            if (count($pregunta) <= 0) {
                $this->gsatelite->show_dialog('Petición no Válida', 'auto_gestion', 'error');
            }
        }
    }

    public function in_desc(){
        satelite_validar();
        $id_user = $this->tank_auth->get_user_id();
        $reg = $this->gsatelite->get_tabla('emp_empleado',array('emp_id_usu' =>$id_user));
        $id = $reg[0]['emp_id'];
        $this->load->model('personal_model');
            $data['info']= $this->personal_model->info_empleado($id);
            $data['id_empleado_crud'] = $id;
            $nombre_empleado = $data['info'][0]['emp_apellido'] .', '.$data['info'][0]['emp_nombre'];
            $data['ver_ingresos']= $this->personal_model->ingresos_empleado($id);
            $data['ver_descuentos']= $this->personal_model->descuentos_empleado($id);

            if($data['info'][0]['emp_salario']<=0){
                $data['tipo_ingreso'] = $this->personal_model->tipo_ingreso(null,null,true);
            }else{
                $data['tipo_ingreso'] = $this->personal_model->tipo_ingreso();
            }
            $data['titulo_personal'] = "Ingresos y descuentos <b style='font-size:14px;'>($nombre_empleado)</b>";
            $data['tipo_descuento'] = $this->personal_model->tipo_descuento();
            $data['estado']= $this->personal_model->tipo_descuento();
            
            $ids_tpl=array(0);
            $pregunta=$this->gsatelite->get_tabla('txe_tipo_planillaxempleado',array('txe_id_emp'=>$id));
            foreach ($pregunta as $fila) {  $ids_tpl[]=$fila['txe_id_tpl']; }
            $this->db->where_in('tpl_id',$ids_tpl);
            $select = $this->gsatelite->get_dropdown('tpl_tipo_planilla', '{tpl_nombre}','', null, null, '', 'tpl_id', true);
            $data["select_tpl_id"] = str_replace('<option value="0">Seleccione</option>', '',$select);
            
            $id_descuento_isss=$this->gsatelite->get_parametro('DESCUENTO_ISS');
            $configuracion_incapacidad=explode('##',$this->gsatelite->get_parametro('CONFIGURACION_INCAPCIDAD_EMPLEADO'));
            $data['n_dias_cubierto_empresa']=$configuracion_incapacidad[0];
            $data['porcentaje_n_dias_cubierto_empresa']=$configuracion_incapacidad[1];
            $data['porcentaje_n_dias_cubierto_empresa_adicionales']=$configuracion_incapacidad[2];
            $data['porcentaje_n_dias_cubierto_seguro_adicionales']=$this->gsatelite->get_parametro('PORCENTAJE_INCAPACIDA_SEGURO');
            
            
            $data['salario_base_calculo']=
            $registro_isss= $this->gsatelite->get_tabla('tdc_tipo_descuento',array('tdc_id'=>$id_descuento_isss));
            //preguntar si el salario del empleado no sobrepasa el techo permitido para cálculo del isss
            $salario_base_calculo=($data['info'][0]['emp_salario']>$registro_isss[0]['tdc_maximo'])? $registro_isss[0]['tdc_maximo']:$data['info'][0]['emp_salario']; 
            $data['salario_base_calculo']=$salario_base_calculo;
            $data['salario_base_empleado']=$data['info'][0]['emp_salario'];

            // Datos de proyectos //////////////////////////
            $per = false;
            $c   = ($this->gsatelite->get_parametro('SYS_PRESUPUESTO_COMPRA') != '')?$this->gsatelite->get_parametro('SYS_PRESUPUESTO_COMPRA'):null;
            if ($c != null) {
                $array_id = explode(',', $c);
                if (in_array($this->tank_auth->get_user_id(), $array_id)) {
                    $per = true;
                }
            }

            $data['permiso_param'] = $per;
             $proyectos_reg = $this->compras_model->get_proyectos(array('pcl_estado'=>1, 'cli_estado'=>1, 'epr_cierre'=>0));
                $select_proyecto = '<option value=""></option>';
                foreach ($proyectos_reg as $key) {
                    $selected = '';
                    if($rxi_id != null){
                        $selected = ($data['requisicion_data'][0]['rxi_id_pcl'] == $key['pcl_id'])?'selected':'';
                    }
                    $nombre_cliente = (trim($key['cli_personeria']) == 1)?trim($key['cli_nombre'].' '.$key['cli_apellido']):trim($key['cli_apellido']);
                    $nombre = $key['pcl_codigo'] . ' - ' . $key['pcl_nombre'];
                    $select_proyecto .= '<option value="'.$key['pcl_id'].'" data-cliente="'.$nombre_cliente.'" '.$selected.'>'.$nombre.'</option>';
                }
                $data['proyectos'] = $select_proyecto;
            ////////////////////////////////////////////////

            cargarvista($data, tue, 'auto_gestion/acciones/ind_desc');

    }

    public function cantidad_acc_personal() {
        satelite_validar();
        $tac_id = $this->input->post("tac_id");
        $fecha_desde = ($this->input->post("fecha_desde") != '') ? formatear_fecha('Y-m-d', $this->input->post("fecha_desde")) : date('Y-m-d');
        $emp_id = $this->input->post("empleado");
        $acciones_personal = $this->gsatelite->get_tabla('acp_accion_personal', array("acp_id_tac"=> $tac_id, "acp_id_emp"=> $emp_id, 'acp_estado'=> 1, "acp_fecha_desde <= '$fecha_desde'" => null));
        echo json_encode(array("cantidad" => count($acciones_personal), 'fecha' => formatear_fecha('d-m-Y', $fecha_desde)));
        die();
    }

    /**
     * @author Marlon Olmedo
     * @since 2020-05-18
     * @return Proceso de edicion de un empleado
     * @description se carga la vista para la edicion de un empleado en grid
      */
    public function ultima_actualizacion() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $this->load->library('../controllers/expediente_personal/empleado');
            $this->empleado->index_agregar_empleado(true,2);
        }
    }

    /**
     * @author Marlon Olmedo
     * @since 2020-05-18
     * @return Proceso de edicion de un empleado
     * @description se carga la vista para la edicion de un empleado en grid
      */
    public function actualizar_ficha($id) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $this->load->library('../controllers/expediente_personal/empleado');
            $this->empleado->editar_empleado($id,1,null,null,null,true,2);
        }
    }


    /** 
     * @author Raul E.
     * @since Jun 2021
     * @return Pantalla de permisos del empleado
     * @description se carga la vista para la edicion de un empleado en grid
      */
    public function lista_permisos_empleado($empleado = null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $id_emp = ($empleado) ? $empleado : $this->gsatelite->get_campo('users', 'usu_id_emp', array('id' => $this->tank_auth->get_user_id()));
            $this->verifica_empleado_real($id_emp);
            $data['permisos'] = $this->gsatelite->get_permisos_opcion();
            $registro_empleado = $this->gsatelite->get_tabla('emp_empleado', array('emp_id' => $id_emp));
            $data["info_empleado"] = $registro_empleado[0];
            $data["titulo_personal"] = "Mis Permisos";
            $data["consulta2"] = $this->accion_personal_model->get_horas_faltantes(array('hxe_id_emp' => $id_emp));//, 'hxe_estado' => 1
            $data["id_empleado"] = $registro_empleado[0]['emp_id'];
            $this->_cargarvista($data);
        }
    }

    /**
     * FUNCIONALIDAD VERSION BETA PARA PANAMA
    */
    public function lista_vacacion_empleado($empleado = null, $autorizar = null) {
        satelite_validar();
        $id_emp = ($empleado) ? $empleado : $this->gsatelite->get_campo('users', 'usu_id_emp', array('id' => $this->tank_auth->get_user_id()));
        $this->verifica_empleado_real($id_emp);
        $data['permisos'] = $this->gsatelite->get_permisos_opcion();
        $factor_m = $this->gsatelite->get_parametro('FACTOR_CALCULO_VACACION') * 100;
        $metodo_vacacion = $this->gsatelite->get_parametro('METODO_CALCULO_VACACION', '1');
        $data['id_empleado'] = $id_emp;
        $data['autorizar'] = $autorizar;
        $data['factor_mul'] = $factor_m;
        $data["info_empleado"] = $this->gsatelite->get_tabla('emp_empleado', array('emp_id' => $id_emp))[0];
        $data["consulta"] = $this->auto_gestion_model->grid_vacaciones_empleado($id_emp);
        $data["titulo_personal"] = "Vacaciones";
        $this->_cargarvista($data);
    }

    public function solicitud_vacacion($id_empleado = null){
        satelite_validar();
        if ($_POST) {
            $array_detalle = array(
                'slv_id_emp' => $_POST['emp_id'],
                'slv_id_vac' => $_POST['id_vac'],
                'slv_fecha_desde' => formatear_fecha('Y-m-d', $_POST['fecha_desde']),
                'slv_fecha_hasta' => formatear_fecha('Y-m-d', $_POST['fecha_hasta']),
                'slv_cantidad_dias' => $_POST['n_dias'],
                'slv_estado' => 1,
                'slv_usu_creacion' => $this->tank_auth->get_user_id(),
                'slv_fecha_creacion' => date("Y-m-d H:i:s"),
                'slv_usu_modificacion' => $this->tank_auth->get_user_id(),
                'slv_fecha_modificacion' => date("Y-m-d H:i:s")
            );
            $solicitud = $this->gsatelite->ingresar('slv_solicitud_vacacion', $array_detalle);
            $this->gsatelite->show_dialog("Proceso realizado con éxito", "auto_gestion/acciones/lista_vacacion_empleado");
        } else {
            $id_empleado = ($id_empleado) ? $id_empleado : $this->gsatelite->get_campo('users', 'usu_id_emp', array('id' => $this->tank_auth->get_user_id()));
            // $this->verifica_empleado_real($id_empleado);
            $data["info_empleado"] = $this->gsatelite->get_tabla('emp_empleado', array('emp_id' => $id_empleado));
                                    $this->db->order_by('prv_desde', 'asc');
                                    $this->db->join('prv_periodo_vacacion', 'prv_id=vac_id_prv');
            $data["vdisponibles"] = $this->gsatelite->get_tabla('vac_vacacion', array('vac_id_emp' => $id_empleado, 'vac_estado' => 1));
            /* NO APLICA EN PANAMA */
            $ids_tpl = array(0);
            $base_calculo_vacacion = $this->accion_personal_model->promedio_salario_vacacion_empleado($id_empleado);
            $data['base_calculo_vacacion'] = $base_calculo_vacacion; // este se tomara como el salario del empleado
            $pregunta = $this->gsatelite->get_tabla('txe_tipo_planillaxempleado', array('txe_id_emp' => $id_empleado));
            foreach ($pregunta as $fila) {
                $ids_tpl[] = $fila['txe_id_tpl'];
            }
                        $this->db->where_in('tpl_id', $ids_tpl);
            $selectPl = $this->gsatelite->get_dropdown('tpl_tipo_planilla', '{tpl_nombre}', '', null, null, '', 'tpl_id', true);
            $data["select_tpl_id"] = str_replace('<option value="0">Seleccione</option>', '', $selectPl);
            $data["factor_calculo_vacacion"] = $this->gsatelite->get_parametro('FACTOR_CALCULO_VACACION');
            $this->_cargarvista($data, null);
        }
    }

    public function borrar_solicitud_vacacion($sltid=null) {
        satelite_validar();
        if ($sltid > 0) {
            $this->gsatelite->borrado_general("slv_solicitud_vacacion", array('slv_id' => $sltid));
            $this->gsatelite->show_dialog("Se ha completado el proceso", "auto_gestion/acciones/lista_vacacion_empleado");
        } else {
            $this->gsatelite->show_dialog("No se pudo completar el proceso", "auto_gestion/acciones/lista_vacacion_empleado", "error", "Ocurrió un error");
        }
    }

    public function permisos_colaboradores(){
        satelite_validar();
                     $this->db->join('emp_empleado', 'usu_id_emp = emp_id','left');
                     $this->db->join('plz_plaza', 'emp_id_plz = plz_id','left');
        $users_plz = $this->gsatelite->get_tabla('users',array('id' => $this->tank_auth->get_user_id(), 'emp_id_plz IS NOT NULL' => null));
        $empleados = (count($users_plz) > 0) ? array(0) : array(0); //como validar si debe salir o no /////////////////////// $users_plz[0]['emp_id']
        $plaza = (isset($users_plz[0]["emp_id_plz"])) ? $users_plz[0]["emp_id_plz"] : null;
        $hijos_plz = $this->gsatelite->get_tabla('plz_plaza',array('plz_id_padre' => $plaza, "plz_estado" => 1));
        if (count($hijos_plz) > 0) {
            $plz_hijos = array_column($hijos_plz, "plz_id");
                            $this->db->where_in('emp_id_plz', $plz_hijos);
            $subordinados = $this->gsatelite->get_tabla('emp_empleado', array('emp_estado' => 1));
            if (count($subordinados) > 0) {
                foreach ($subordinados as $k => $v) {
                    $empleados[] = $v['emp_id'];
                }
            }
        }
                                   $this->db->where_in('emp_id', $empleados);
        $data['total_empleados'] = $this->personal_model->listado_empleados(array('emp_estado'=>1));
        $data["permisos"] = $this->gsatelite->get_permisos_opcion();
        $data['titulo_personal'] = "Permisos Colaboradores";
        $this->_cargarvista($data, null);
    }

    public function vacaciones_colaboradores(){
        satelite_validar();
                     $this->db->join('emp_empleado', 'usu_id_emp = emp_id','left');
                     $this->db->join('plz_plaza', 'emp_id_plz = plz_id','left');
        $users_plz = $this->gsatelite->get_tabla('users',array('id' => $this->tank_auth->get_user_id(), 'emp_id_plz IS NOT NULL' => null));
        $empleados = (count($users_plz) > 0) ? array(0) : array(0); //como validar si debe salir o no /////////////////////// $users_plz[0]['emp_id']
        $plaza = (isset($users_plz[0]["emp_id_plz"])) ? $users_plz[0]["emp_id_plz"] : null;
        $hijos_plz = $this->gsatelite->get_tabla('plz_plaza',array('plz_id_padre' => $plaza, "plz_estado" => 1));
        if (count($hijos_plz) > 0) {
            $plz_hijos = array_column($hijos_plz, "plz_id");
                            $this->db->where_in('emp_id_plz', $plz_hijos);
            $subordinados = $this->gsatelite->get_tabla('emp_empleado', array('emp_estado' => 1));
            if (count($subordinados) > 0) {
                foreach ($subordinados as $k => $v) {
                    $empleados[] = $v['emp_id'];
                }
            }
        }
                             $this->db->where_in('emp_id', $empleados);
        $data['lista_emp'] = $this->personal_model->listado_empleados(array('emp_estado'=>1));
        $data["permisos"] = $this->gsatelite->get_permisos_opcion();
        $data['titulo_personal'] = "Vacaciones Colaboradores";
        $this->_cargarvista($data, null);
    }

    /** 
     * @author Raul E.
     * @since AGO/2021
     * @return Pantalla de evaluaciones del empleado
      */
    public function evaluaciones_empleado() {
        satelite_validar();
        $id_emp = $this->gsatelite->get_campo('users', 'usu_id_emp', array('id' => $this->tank_auth->get_user_id()));
        $this->verifica_empleado_real($id_emp);
        $registro_empleado = $this->gsatelite->get_tabla('emp_empleado', array('emp_id' => $id_emp));
        $data["empleado"] = $registro_empleado[0];
        $data['permisos'] = $this->gsatelite->get_permisos_opcion();
        $data["titulo_personal"] = "Mis Evaluaciones";
                            $this->db->join('pde_periodo_evaluacion', 'pde_id = eve_id_pde');
        $data["consulta"] = $this->gsatelite->get_tabla('eve_evaluacion_empleado', array('eve_id_emp' => $id_emp, 'eve_estado' => 1));
        $this->_cargarvista($data);
    }

    public function ver_evaluacion($eve_id){
        satelite_validar();
        $id_emp = $this->gsatelite->get_campo('users', 'usu_id_emp', array('id' => $this->tank_auth->get_user_id()));
        $registro_evaluacion_empleado = $this->evaluacion_desempeno_model->verificar_empleado_evaluacion(array('eve_id' => $eve_id));
        if ($registro_evaluacion_empleado[0]['eve_id_emp'] != $id_emp) {
            $this->gsatelite->show_dialog("No tiene permitido ver esta evaluación", "auto_gestion/acciones/evaluaciones_empleado", "error");
        } else {
            $data['registro'] = $registro_evaluacion_empleado[0];
            $data['registro_evaluacion'] = $this->evaluacion_desempeno_model->get_datos_evaluacion_empleado(array('dte_id_eve'=>$eve_id));
            $data['ponderaciones'] = $this->gsatelite->get_tabla('pon_ponderacion');
            $data['empleado'] = $this->evaluacion_desempeno_model->informacion_empleado(array('emp_estado' => 1));
            $data['autogestion'] = 1;
            $data['titulo_personal'] = "Ver Evaluación";
            cargarvista($data, null, 'modulo_evaluacion_desempeno/procesos/lectura_evaluacion_empleado');
        }
    }

    public function agregar_permiso_empleado($id_emp, $propio = 0){
        satelite_validar();
        if ($_POST) {
            $ingresado_jefe = $this->input->post('autoservicio');
            $registro_periodo = ($this->input->post('periodo_planilla') > 0) ? $this->gsatelite->get_registro('pla_planilla', 'pla_id', $this->input->post('periodo_planilla')) : null;
            $registro_tipo_hora = $this->gsatelite->get_registro('thf_tipo_hora_faltante', 'thf_id', $this->input->post('tipo_hora_faltante'));
            $array_detalle = array(
                'hxe_id_pla' => (trim($this->input->post('periodo_planilla')) > 0) ? $this->input->post('periodo_planilla') : null,
                'hxe_id_thf' => $this->input->post('tipo_hora_faltante'),
                'hxe_id_emp' => $this->input->post('emp_id'),
                'hxe_id_mtp' => ($this->input->post('motivo') != '') ? $this->input->post('motivo') : null,
                'hxe_num_hora' => $this->input->post('n_horas'),
                'hxe_observacion' => $this->input->post('observaciones_tiempo'),
                'hxe_fecha' => (trim($this->input->post('txtFechaDesde')) !='') ? formatear_fecha('Y-m-d', $this->input->post('txtFechaDesde')) : null,
                'hxe_fecha_fin' => (trim($this->input->post('txtFechaHasta')) !='') ? formatear_fecha('Y-m-d', $this->input->post('txtFechaHasta')) : null,
                'hxe_hora_inicio' => (trim($this->input->post('hora_1')) !='') ? $this->input->post('hora_1') : null,
                'hxe_hora_fin' => (trim($this->input->post('hora_2')) !='') ? $this->input->post('hora_2') : null,
                'hxe_estado' => 1,
                'hxe_fecha_crea' => date("Y-m-d H:i:s"),
                'hxe_usu_crea' => $this->tank_auth->get_user_id(),
                'hxe_fecha_mod' => date("Y-m-d H:i:s"),
                'hxe_usu_mod' => $this->tank_auth->get_user_id()
            );
            $id_detalle_horas = $this->gsatelite->ingresar('hxe_hora_extraxempleado', $array_detalle);

             $tipo_permiso = $this->gsatelite->get_parametro_emp("TIPO_PERMISO_COMPENSATORIO");

            if ($tipo_permiso == $this->input->post('tipo_hora_faltante')) {

                $horas_disponibles = $this->accion_personal_model->get_tiempo_compensatorio([
                    'tce_id_emp' => $id_emp,
                    'tce_disponible > 0' => null
                ]);

                $horas_solicitadas = floatval($this->input->post('n_horas'));
                $horas_acumuladas = 0;

                foreach ($horas_disponibles as $registro) {
                    if ($horas_acumuladas >= $horas_solicitadas) {
                        break;
                    }

                    $id_origen = $registro['tce_id'];
                    $disponible = floatval($registro['tce_disponible']);

                    $a_consumir = min($disponible, $horas_solicitadas - $horas_acumuladas);

                    $this->gsatelite->ingresar("hxc_hora_x_compensatorio", [
                        'hxc_id_hxe' => $id_detalle_horas,
                        'hxc_id_tce' => $id_origen,
                        'hxc_horas' => $a_consumir,
                        'hxc_estado' => 2,
                        'hxc_fecha_crea' => date('Y-m-d H:i:s'),
                        'hxc_usu_crea' => $this->tank_auth->get_user_id(),
                    ]);

                    $horas_acumuladas += $a_consumir;
                }

                if ($horas_acumuladas < $horas_solicitadas) {
                    $this->output
                        ->set_status_header(400)
                        ->set_content_type('application/json', 'utf-8')
                        ->set_output(json_encode([
                            'error' => 'No hay horas suficientes para completar la solicitud.'
                        ]))
                        ->_display();
                    exit;
                }

            }



            $array_uhp = array (
                'uhp_id_hxe' => $id_detalle_horas,
                'uhp_id_thf' => $this->input->post('tipo_hora_faltante'),
                'uhp_numero_horas' => $this->input->post('n_horas'),
                'uhp_fecha_desde' => (trim($this->input->post('txtFechaDesde')) !='') ? formatear_fecha('Y-m-d', $this->input->post('txtFechaDesde')) : null,
                'uhp_fecha_hasta' => (trim($this->input->post('txtFechaHasta')) !='') ? formatear_fecha('Y-m-d', $this->input->post('txtFechaHasta')) : null,
                'uhp_hora_inicio' => (trim($this->input->post('hora_1')) !='') ? $this->input->post('hora_1') : null,
                'uhp_hora_fin' => (trim($this->input->post('hora_2')) !='') ? $this->input->post('hora_2') : null,
                'uhp_autorizado' => 0,
                'uhp_usu_autorizo' => null,
                'uhp_fecha_autorizacion' => null,
                'uhp_observaciones' => null,
                'uhp_estado' => 1,
                'uhp_usu_creacion' => $this->tank_auth->get_user_id(),
                'uhp_fecha_creacion' => date("Y-m-d H:i:s"),
                'uhp_usu_modificacion' => $this->tank_auth->get_user_id(),
                'uhp_fecha_modificacion' => date("Y-m-d H:i:s")
            );

            $uhp_registro = $this->gsatelite->ingresar('uhp_uso_horas_permisos', $array_uhp);
            
            //PENDIENTE
            //ahora ingresar el descuento en planilla si aplica
            if ($this->input->post('tipo_planilla') > 0 && $registro_tipo_hora->thf_id_tdc > 0 && $registro_periodo) {
                $descuento = array(
                    'dss_id_emp' => $this->input->post('emp_id'),
                    'dss_id_tpl' => $this->input->post('tipo_planilla'),
                    'dss_id_tdc' => $registro_tipo_hora->thf_id_tdc,
                    'dss_id_hxe' => $id_detalle_horas,
                    'dss_motivo' => $this->input->post('observaciones'),
                    'dss_observacion' => $this->input->post('observaciones'),
                    'dss_permanente' => 0,
                    'dss_valor' => $this->input->post('calculo_monto'),
                    'dss_fecha_desde' => formatear_fecha("Y-m-d", $registro_periodo->pla_fecha_inicio),
                    'dss_cuota' => 1,
                    'dss_cuota_pagada' => 0,
                    'dss_estado' => 0,/////cuando se autorice que lo  activen
                    'dss_fecha' => date("Y-m-d H:i:s"),
                    'dss_fecha_crea' => date("Y-m-d H:i:s"),
                    'dss_usu_crea' => $this->tank_auth->get_user_id(),
                    'dss_fecha_mod' => date("Y-m-d H:i:s"),
                    'dss_usu_mod' => $this->tank_auth->get_user_id()
                );
                $id_dess = $this->gsatelite->ingresar('dss_descuento', $descuento);
            }
            $ruta_anexos = $this->input->post('ruta');
            $titulo_anexo = $this->input->post('titulo_doc');
            if (!empty($ruta_anexos)) {
                for ($i = 0; $i < count($ruta_anexos); $i++) {
                    $extension = end(explode('.', $ruta_anexos[$i]));
                    $carpeta_temporal_anx = $ruta = "public/temp/anexos_permisos/" . trim($ruta_anexos[$i]);
                    $nombreArchivo = trim($titulo_anexo[$i]) . "." . trim($extension);
                    $carpeta_destino_anx = "uploads/anexos_permisos/" . $nombreArchivo;
                    $documentos_array = array(
                        'anh_id_hxe'             => $id_detalle_horas,
                        'anh_url'                => $carpeta_destino_anx,
                        'anh_nombre'             => $nombreArchivo,
                        'anh_estado'             => 1,
                        'anh_usu_creacion'       => $this->tank_auth->get_user_id(),
                        'anh_fecha_creacion'     => date('Y-m-d H:i:s'),
                        'anh_usu_modificacion'   => $this->tank_auth->get_user_id(),
                        'anh_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $anh_id = $this->gsatelite->ingresar('anh_anexo_hora_extra_empleado', $documentos_array);
                    if ($anh_id > 0) {
                        copy($carpeta_temporal_anx, $carpeta_destino_anx);
                        unlink($carpeta_temporal_anx);
                    }
                }
            }
            $id_emp = $this->input->post('emp_id');
            if ($ingresado_jefe > 0) {
                $this->gsatelite->show_dialog("Proceso realizado con éxito", "auto_gestion/acciones/lista_permiso_colaborador/$id_emp");
            } else {
                $this->gsatelite->show_dialog("Proceso realizado con éxito", "auto_gestion/acciones/lista_permisos_empleado/$id_emp");
            }
        } else {
            $this->verifica_empleado_real($id_emp);
            $motivo = $this->gsatelite->get_dropdown('mtp_motivo_permiso', '{mtp_nombre}', '', array('mtp_estado' => 1),null,'','',true);
            $data['motivo'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $motivo);
            $data["self_service"] = $propio;
            $data["titulo_personal"] = "Gestión de permisos";
            $data["info_empleado"] = $this->gsatelite->get_tabla('emp_empleado', array('emp_id' => $id_emp));
            //PENDIENTE DE VERIFICAR LAS PLANILLAS AL QUE PERTENECE EL EMPLEADO
            // $ids_tpl = array(0);
            // $pregunta = $this->gsatelite->get_tabla('txe_tipo_planillaxempleado', array('txe_id_emp' => $id_emp));
            // foreach ($pregunta as $fila) {
            //     $ids_tpl[] = $fila['txe_id_tpl'];
            // }
            // $this->db->where_in('tpl_id', $ids_tpl);
            // $select = $this->gsatelite->get_dropdown('tpl_tipo_planilla', '{tpl_nombre}', '', null, null, '', 'tpl_id', true);
            $data["select_tpl_id"] = array();// str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            $slc_thf = '<option value=""></option>';
            $tbl_thf =  $this->gsatelite->get_tabla('thf_tipo_hora_faltante', array('thf_estado' => 1));
            foreach ($tbl_thf as $k => $v) {
                $hdisp = $this->horas_consumidas($v['thf_id'], $id_emp);
                $txtdisp = ($hdisp['asignadas'] > 0 && $hdisp['disponible'] > 0) ? '(Disp: ' . $hdisp['disponible'] . ' h)' : '';
                $slc_thf .= '<option value="' . $v['thf_id'] . '">' . $v['thf_nombre'] . ' ' . $txtdisp . '</option>';
            }
            $data["select_tipo_hora_faltante"] = $slc_thf;
            $data["thf_compensa"] = $this->gsatelite->get_parametro_emp("TIPO_PERMISO_COMPENSATORIO", 0);
            $this->_cargarvista($data, null);
        }
    }

    public function horas_consumidas($id_thf = 0, $emp_id = 0) {
        if ($id_thf > 0 && $emp_id > 0) {
            $reg_thf = $this->gsatelite->get_tabla('thf_tipo_hora_faltante', array('thf_id' => $id_thf));
            $reg_hxp = $this->gsatelite->get_tabla('hpe_hora_permiso_x_empleado', array('hpe_id_thf' => $id_thf, 'hpe_id_emp' => $emp_id));
                       $this->db->join('hxe_hora_extraxempleado', 'hxe_id = uhp_id_hxe');
            $sum_hxe = $this->gsatelite->get_suma('uhp_uso_horas_permisos','uhp_numero_horas',array('hxe_id_emp'=>$emp_id,'uhp_id_thf'=>$id_thf,'uhp_estado'=>1,'uhp_autorizado'=>1,'hxe_estado'=>2));
            if ((isset($reg_thf[0]['thf_horas_ley']) && $reg_thf[0]['thf_horas_ley'] > 0) || (isset($reg_hxp[0]['hpe_horas_limite']) && $reg_hxp[0]['hpe_horas_limite'] > 0)) {
                $asignadas = ($reg_thf[0]['thf_horas_ley'] > 0) ? $reg_thf[0]['thf_horas_ley'] : $reg_hxp[0]['hpe_horas_limite'];
                $utilizado = $sum_hxe;
                $disponible = (($asignadas - $utilizado) > 0) ? ($asignadas - $utilizado) : 0;
                $restringe = ($disponible > 0) ? false : true;
            } else {
                $restringe = false;
                $utilizado = $sum_hxe;
                $asignadas = $disponible = 0;
            }            
        } else {
            $restringe = false;
            $asignadas = $utilizado = $disponible = 0;
        }
        $respuesta = array('restringir' => $restringe, 'asignadas' => $asignadas,'usadas' => $utilizado, 'disponible'=> $disponible);
        return $respuesta;
    }

    public function editar_permiso_empleado($id_permiso, $propio = 0, $read = 0){
        satelite_validar();
        if ($_POST) {
                // die(var_dump($_POST));
                $ingresado_jefe = $this->input->post('autoservicio');
                $registro_periodo = ($this->input->post('periodo_planilla') > 0) ? $this->gsatelite->get_registro('pla_planilla', 'pla_id', $this->input->post('periodo_planilla')):null;
                $registro_tipo_hora = $this->gsatelite->get_registro('thf_tipo_hora_faltante', 'thf_id', $this->input->post('tipo_hora_faltante'));
                $id_detalle_horas = $this->input->post('hxe_id');
                $array_detalle = array(
                    'hxe_id_pla' => (trim($this->input->post('periodo_planilla')) > 0) ? $this->input->post('periodo_planilla') : null,
                    'hxe_id_thf' => $this->input->post('tipo_hora_faltante'),
                    'hxe_id_emp' => $this->input->post('emp_id'),
                    'hxe_id_mtp' => ($this->input->post('motivo') != '')? $this->input->post('motivo') : null,
                    'hxe_num_hora' => $this->input->post('n_horas'),
                    'hxe_fecha' => (trim($this->input->post('txtFechaDesde')) !='') ? formatear_fecha('Y-m-d',$this->input->post('txtFechaDesde')) : null,
                    'hxe_fecha_fin' => (trim($this->input->post('txtFechaHasta')) !='') ? formatear_fecha('Y-m-d',$this->input->post('txtFechaHasta')) : null,
                    'hxe_hora_inicio' => (trim($this->input->post('hora_1')) !='') ? $this->input->post('hora_1') : null,
                    'hxe_hora_fin' => (trim($this->input->post('hora_2')) !='') ? $this->input->post('hora_2') : null,
                    'hxe_observacion' => $this->input->post('observaciones_tiempo'),
                    'hxe_estado' => $this->input->post('estado_tiempo'),
                    'hxe_fecha_mod' => date("Y-m-d H:i:s"),
                    'hxe_usu_mod' => $this->tank_auth->get_user_id()
                );
                $update_detalle = $this->gsatelite->actualizar_array('hxe_hora_extraxempleado', $array_detalle, array('hxe_id' => $id_detalle_horas));
                //PENDIENTE 
                //ahora ingresar el descuento en la tabla de descuento si aplica
                if ($this->input->post('tipo_planilla') > 0 && $registro_tipo_hora->thf_id_tdc > 0 && $registro_periodo) {
                    $descuento = array(
                        'dss_id_emp' => $this->input->post('emp_id'),
                        'dss_id_tpl' => $this->input->post('tipo_planilla'),
                        'dss_id_tdc' => $registro_tipo_hora->thf_id_tdc,
                        'dss_id_hxe' => $id_detalle_horas,
                        'dss_motivo' => $this->input->post('observaciones'),
                        'dss_observacion' => $this->input->post('observaciones'),
                        'dss_permanente' => 0,
                        'dss_valor' => $this->input->post('calculo_monto'),
                        'dss_fecha_desde' => date("Y-m-d", strtotime($registro_periodo->pla_fecha_inicio)),
                        'dss_cuota' => 1,
                        'dss_cuota_pagada' => 0,
                        'dss_estado' => ($this->input->post('estado') >=0)? $this->input->post('estado'):0,
                        'dss_fecha_mod' => date("Y-m-d H:i:s"),
                        'dss_usu_mod' => $this->tank_auth->get_user_id()
                    );
                    $existe_des = $this->gsatelite->get_tabla('dss_descuento',array('dss_id_hxe' => $id_detalle_horas));
                    if ($existe_des) {
                        $update_decuento = $this->gsatelite->actualizar_array('dss_descuento', $descuento, array('dss_id_hxe' => $id_detalle_horas));
                    } else {
                        $descuento['dss_estado'] = 1;
                        $descuento['dss_fecha_crea'] = date("Y-m-d H:i:s");
                        $descuento['dss_usu_crea'] = $this->tank_auth->get_user_id();
                        $id_dess = $this->gsatelite->ingresar('dss_descuento', $descuento);
                    }
                }
                $ruta_anexos = $this->input->post('ruta');
                $titulo_anexo = $this->input->post('titulo_doc');
                if (!empty($ruta_anexos)) {
                    for ($i = 0; $i < count($ruta_anexos); $i++) {
                        $extension = end(explode('.', $ruta_anexos[$i]));
                        $carpeta_temporal_anx = $ruta = "public/temp/anexos_permisos/" . trim($ruta_anexos[$i]);
                        $nombreArchivo = trim($titulo_anexo[$i]) . "." . trim($extension);
                        $carpeta_destino_anx = "uploads/anexos_permisos/" . $nombreArchivo;
                        $dir = $this->gsatelite->get_tabla('anh_anexo_hora_extra_empleado', array('anh_url' => $carpeta_destino_anx, 'anh_estado' => 1));
                        if (!(count($dir) > 0)) {
                            $documentos_array = array(
                                'anh_id_hxe'             => $id_detalle_horas,
                                'anh_url'                => $carpeta_destino_anx,
                                'anh_nombre'             => $nombreArchivo,
                                'anh_estado'             => 1,
                                'anh_usu_creacion'       => $this->tank_auth->get_user_id(),
                                'anh_fecha_creacion'     => date('Y-m-d H:i:s'),
                                'anh_usu_modificacion'   => $this->tank_auth->get_user_id(),
                                'anh_fecha_modificacion' => date('Y-m-d H:i:s')
                            );
                            $ant_id = $this->gsatelite->ingresar('anh_anexo_hora_extra_empleado', $documentos_array);
                            if ($ant_id > 0) {
                                copy($carpeta_temporal_anx, $carpeta_destino_anx);
                                unlink($carpeta_temporal_anx);
                            }
                        }
                    }
                }
                $id_emp = $this->input->post('emp_id');
                if ($ingresado_jefe > 0) {
                    $this->gsatelite->show_dialog("Proceso realizado con éxito", "auto_gestion/acciones/lista_permiso_colaborador/$id_emp");
                } else {
                    $this->gsatelite->show_dialog("Proceso realizado con éxito", "auto_gestion/acciones/lista_permisos_empleado/$id_emp");
                }
        } else {
            $this->verifica_registro_real('hxe_hora_extraxempleado', $id_permiso);
            $reg_permiso = $this->accion_personal_model->get_horas_faltantes(array('hxe_id' => $id_permiso));
            $motivo = $this->gsatelite->get_dropdown('mtp_motivo_permiso', '{mtp_nombre}', 'motivo', array('mtp_estado' => 1),$reg_permiso[0]['hxe_id_mtp'] ,'','',true);
            $id_empleado = $reg_permiso[0]['hxe_id_emp'];
            $data['motivo'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $motivo);
            $data["registro_hora"] = $reg_permiso[0];
            $data["self_service"] = $propio;
            $data["lectura"] = $read;
            $data["info_empleado"] = $this->gsatelite->get_tabla('emp_empleado', array('emp_id' => $id_empleado));
            //PENDIENTE DE VERIFICAR LAS PLANILLAS AL QUE PERTENECE EL EMPLEADO
            // $ids_tpl = array(0);
            // $pregunta = $this->gsatelite->get_tabla('txe_tipo_planillaxempleado', array('txe_id_emp' => $id_empleado));
            // foreach ($pregunta as $fila) {
            //     $ids_tpl[] = $fila['txe_id_tpl'];
            // }
            // $this->db->where_in('tpl_id', $ids_tpl);
            // $select = $this->gsatelite->get_dropdown('tpl_tipo_planilla', '{tpl_nombre}', '', null, $reg_permiso['pla_id_tpl'], '', 'tpl_id', true);
            $data["select_tpl_id"] = array();// str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            $select = $this->gsatelite->get_dropdown('thf_tipo_hora_faltante', '{thf_nombre} ({thf_factor})', '', array('thf_estado' => 1), $reg_permiso[0]['thf_id'], '', 'thf_id', true);
            $data["select_tipo_hora_faltante"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            $select = $this->gsatelite->get_dropdown('pla_planilla', '{pla_fecha_inicio} # {pla_fecha_fin}', '', array('pla_id_tpl' => $reg_permiso[0]['pla_id_tpl'], 'pla_estado >=' => 1, 'pla_estado <=' => 2), $reg_permiso['pla_id'], '', 'pla_id', true);
            $data["select_periodo_planilla"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            $data["titulo_personal"] = "Gestión de Permisos";
            $data['anx'] = $this->gsatelite->get_tabla('anh_anexo_hora_extra_empleado', array('anh_id_hxe' => $id_permiso, 'anh_estado' => 1));
            $this->_cargarvista($data, null, 'auto_gestion/acciones/editar_permiso_empleado');
        }
    }

    public function ver_horas_faltantes($id_hora_faltante){
        satelite_validar();
        $this->editar_permiso_empleado($id_hora_faltante, 1, 1);
    }

    public function ver_permisos($id_hora_faltante){
        satelite_validar();
        $this->editar_permiso_empleado($id_hora_faltante, 0, 1);
    }

    public function lista_permiso_colaborador($empleado = null) {
        satelite_validar();
        $data['permisos'] = $this->gsatelite->get_permisos_opcion('auto_gestion/acciones/permisos_colaboradores');
        $id_emp = ($empleado) ? $empleado : $this->gsatelite->get_campo('users', 'usu_id_emp', array('id' => $this->tank_auth->get_user_id()));
        $this->verifica_empleado_real($id_emp);
        $registro_empleado = $this->gsatelite->get_tabla('emp_empleado', array('emp_id' => $id_emp));
        $data["consulta2"] = $this->accion_personal_model->get_horas_faltantes(array('hxe_id_emp' => $id_emp));
        $data["info_empleado"] = $registro_empleado[0];
        $data["titulo_personal"] = "Permisos del Empleada/o";
        $data["id_empleado"] = $registro_empleado[0]['emp_id'];
        $this->_cargarvista($data);
    }

    /* REG ACADEMICO */
    public function datos_generales() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data['datos_alumno'] = $this->gsatelite->get_registro('alm_alumno', 'alm_id_usu', $this->tank_auth->get_user_id());
            $data['telefono_contacto'] = $this->gsatelite->get_registro('tal_telefonoxalumno', 'tal_id_alm', $data['datos_alumno']->alm_id);
            $data['caso_emergencia'] = $this->gsatelite->get_registro('cla_clinico_alumno', 'cla_id_alm', $data['datos_alumno']->alm_id);
            $data['parentesco'] = $this->gsatelite->get_registro('pat_parentesco', 'pat_id', $data['caso_emergencia']->cla_id_pat);
            $data['documentos'] = $this->personal_model->editar_documentos_alm($data['datos_alumno']->alm_id);
            $data['cursos'] = $this->registro_academico_model->get_cursosXalumno(array('lxa_id_alm' => $data['datos_alumno']->alm_id));
            $this->_cargarvista($data);
        }        
    }

    public function consulta_notas() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $alumno = $this->gsatelite->get_registro('alm_alumno', 'alm_id_usu', $this->tank_auth->get_user_id());
            $materias_cursos = $this->registro_academico_model->get_cursosXalumno(array('lxa_id_alm' => $alumno->alm_id, 'lxp_estado' => 1));
            $data['cursos'] = $materias_cursos;
            $this->_cargarvista($data);
        }
    }

    public function cuotas_pago() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $alumno = $this->gsatelite->get_registro('alm_alumno', 'alm_id_usu', $this->tank_auth->get_user_id());
            
            $materias_cursos = $this->registro_academico_model->get_cursosXalumno(array('lxa_id_alm' => $alumno->alm_id, 'lxp_estado' => 1));
            if (count($materias_cursos) > 0) {
                foreach ($materias_cursos as $key => &$value) {
                    $where = array('alm_id' => $alumno->alm_id, 'mod_id' => $value['mod_id'], 'lxp_estado' => 1);
                    $value['pagos'] = $this->registro_academico_model->get_cuotas_curso_libre($where);
                }
            }
            $data['cursos'] = $materias_cursos;
            $this->_cargarvista($data);
        }
    }

    public function pago_cuotas_grado() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $alumno = $this->gsatelite->get_registro('alm_alumno', 'alm_id_usu', $this->tank_auth->get_user_id());
            
            $materias_grados = $this->registro_academico_model->get_gradosxalumno(array('lxa_id_alm' => $alumno->alm_id, 'lxp_estado' => 1));
            if (count($materias_grados) > 0) {
                foreach ($materias_grados as $key => &$value) {
                    $where = array('gxa_id_alm' => $alumno->alm_id, 'grd_id' => $value['grd_id'], 'lxp_estado' => 1);
                    $value['pagos'] = $this->registro_academico_model->get_cuotas_grados($where);
                }
            }
            $data['grados'] = $materias_grados;
            $this->_cargarvista($data);
        }
    }

    public function generarToken() {

        $credenciales_pasarela_pago = json_decode($this->gsatelite->get_parametro('SYS_CREDENCIAL_PASARELA_PAGO'), true);

        $postData = http_build_query(array(
            'grant_type' => 'client_credentials',
            'client_id' => $credenciales_pasarela_pago['WOMPI']['ID'],
            'client_secret' => $credenciales_pasarela_pago['WOMPI']['PASSWORD'],
            'audience' => 'wompi_api'
        ));

        $ch = curl_init();
        curl_setopt_array($ch, array(
            CURLOPT_URL => "https://id.wompi.sv/connect/token",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => $postData,
            CURLOPT_HTTPHEADER => array(
                "content-type: application/x-www-form-urlencoded"
            ),
        ));
        $response = curl_exec($ch);
        $err = curl_error($ch);
        curl_close($ch);
        $responseData = json_decode($response, true);

        return array(
            'access_token' => $responseData['access_token'],
            'aplicativo_id' => $credenciales_pasarela_pago['WOMPI']['ID'],
            'email_notificacion' => $credenciales_pasarela_pago['WOMPI']['EMAIL_NOTIFICACION'],
            'tel_notificacion' => $credenciales_pasarela_pago['WOMPI']['TEL_NOTIFICACION']
        );
    }

    public function generarEnlacePago() {

        $ids_cuotas = $this->input->post("idsSeleccionados");

        $flag_cuota = $this->input->post("flag");

        $nombre_producto = '';
        $cuotas_seleccionadas = '';
        $monto_pagar = 0;

        foreach ($ids_cuotas as $key => $value) {

            if ($flag_cuota == 'curso-libre') {

                    $where = array('cmc_id' => $value);
                $cuota_cmc = $this->registro_academico_model->get_cuotas_curso_libre($where);

                if($key == 0) {
                    $nombre_producto = $cuota_cmc[0]['mod_nombre'];
                }

                $cuotas_seleccionadas .= '-'.$cuota_cmc[0]['cmc_nombre'].' '.$cuota_cmc[0]['cmc_periodo'].' '; 

                $monto_pagar += $cuota_cmc[0]['total_cuota_pagar'];

            } else if ($flag_cuota == 'grado') {

                    $where = array('clg_id' => $value);
                $cuota_cmc = $this->registro_academico_model->get_cuotas_grados($where);

                if($key == 0) {
                    $nombre_producto = $cuota_cmc[0]['grd_nombre'];
                }

                $cuotas_seleccionadas .= '-'.$cuota_cmc[0]['clg_nombre'].' '.$cuota_cmc[0]['clg_periodo'].' ';

                $monto_pagar += $cuota_cmc[0]['total_cuota_pagar'];

            }

        }

        $webhook = $flag_cuota == 'curso-libre' ? 'webHookApiCmc': 'webHookApiClg';

        $informacion_token = $this->generarToken();

        $url = 'https://api.wompi.sv/EnlacePago';
        $data = [
            "idAplicativo" => $informacion_token['aplicativo_id'],
            "identificadorEnlaceComercio" => "".$nombre_producto."",
            "monto" => $monto_pagar,
            "nombreProducto" => "CUOTAS ".$nombre_producto,
            "formaPago" => array(
                "permitirTarjetaCreditoDebido" => true,
                "permitirPagoConPuntoAgricola" => false,
                "permitirPagoEnCuotasAgricola" => false,
                "permitirPagoEnBitcoin" => false
            ),
            "infoProducto" => array(
                "descripcionProducto" => $cuotas_seleccionadas,
            ),
            "configuracion" => array(
                "esMontoEditable" => false,
                "esCantidadEditable" => false,
                "cantidadPorDefecto" => 1,
                "duracionInterfazIntentoMinutos" => 15,
                "emailsNotificacion" => $informacion_token['email_notificacion'],
                "urlWebhook" => base_url()."auto_gestion/acciones/".$webhook,
                "telefonosNotificacion" => $informacion_token['tel_notificacion'],
                "notificarTransaccionCliente" => true
            ),
            "vigencia" => array(
                "fechaInicio" => date('Y-m-d\TH:i:s.000\Z'),
                "fechaFin" => date('Y-m-d\TH:i:s.000\Z', strtotime('+1 day'))
            ),
            "limitesDeUso" => array(
                "cantidadMaximaPagosExitosos" => 1,
                "cantidadMaximaPagosFallidos" => 0
            )
        ];
        $headers = array(
            'Authorization: Bearer ' . $informacion_token['access_token'],
            'Content-Type: application/json-patch+json',
        );

        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        $response = curl_exec($ch);
        curl_close($ch);
        $responseData = json_decode($response, true);

        foreach ($ids_cuotas as $key => $value) {

            if ($flag_cuota == 'curso_libre') {

                $actualizar_cmc = array(
                    'cmc_enlace_pago_externo' => $responseData['idEnlace'],
                );
                $this->gsatelite->actualizar_array('cmc_cargo_alumnoxcurso', $actualizar_cmc, array('cmc_id' => $value));

            } else if ($flag_cuota == 'grado') {

                $actualizar_clg = array(
                    'clg_enlace_pago_externo' => $responseData['idEnlace'],
                );
                $this->gsatelite->actualizar_array('clg_cargo_alumnoxgrado', $actualizar_clg, array('clg_id' => $value));

            }

        }

        echo json_encode(array(
            'idEnlace' => $responseData['idEnlace'],
            'urlEnlace' => $responseData['urlEnlace']
        ));
        die();        
    }

    public function webHookApiCmc() {
        $postData = file_get_contents('php://input');
        // Verificar si el JSON es válido
        $decodedData = json_decode($postData);
        if ($decodedData === null && json_last_error() !== JSON_ERROR_NONE) {
            // Error al decodificar el JSON
            log_message('error', 'Error al decodificar el JSON: ' . json_last_error_msg());
        } else {
            // Loguear los valores
            log_message('info', 'Valores traidos de la API de Wompi: ' . print_r($decodedData, true));

            if($decodedData->ResultadoTransaccion == 'ExitosaAprobada'){
                $idTransaccion = $decodedData->IdTransaccion;
                $idEnlacePago = $decodedData->EnlacePago->Id;
                
                $actualizar_cmc = array(
                    'cmc_confirma_externo' => $idTransaccion,
                    'cmc_estado_cargo' => 2
                );
                $this->gsatelite->actualizar_array('cmc_cargo_alumnoxcurso', $actualizar_cmc, array('cmc_enlace_pago_externo' => $idEnlacePago));
                
                log_message('info', 'Pago realizado correctamente, cuotas actualizadas exitosamente');

            } else {
                log_message('error', 'Problemas en realizar el pago');
            }

        }
        
    }

    /**Funcionalidad de Registro Academico 
     * */
    public function webHookApiClg() {
        $postData = file_get_contents('php://input');
        // Verificar si el JSON es válido
        $decodedData = json_decode($postData);
        if ($decodedData === null && json_last_error() !== JSON_ERROR_NONE) {
            // Error al decodificar el JSON
            log_message('error', 'Error al decodificar el JSON: ' . json_last_error_msg());
        } else {
            // Loguear los valores
            log_message('info', 'Valores traidos de la API de Wompi: ' . print_r($decodedData, true));

            if($decodedData->ResultadoTransaccion == 'ExitosaAprobada'){
                $idTransaccion = $decodedData->IdTransaccion;
                $idEnlacePago = $decodedData->EnlacePago->Id;
                
                $actualizar_clg = array(
                    'clg_confirma_externo' => $idTransaccion,
                    'clg_estado_cargo' => 2
                );
                $this->gsatelite->actualizar_array('clg_cargo_alumnoxgrado', $actualizar_clg, array('clg_enlace_pago_externo' => $idEnlacePago));
                
                log_message('info', 'Pago realizado correctamente, cuotas actualizadas exitosamente');

            } else {
                log_message('error', 'Problemas en realizar el pago');
            }
        }
    }

    public function verificarTransaccionCmc($idEnlace) {
            $this->db->where("cmc_confirma_externo IS NOT NULL");
        $registros_cmc = $this->gsatelite->get_tabla('cmc_cargo_alumnoxcurso', array('cmc_enlace_pago_externo' => $idEnlace));

        echo json_encode(array('verificacion_transaccion' => count($registros_cmc)));
    }

    public function verificarTransaccionClg($idEnlace) {
            $this->db->where("clg_confirma_externo IS NOT NULL");
        $registros_clg = $this->gsatelite->get_tabla('clg_cargo_alumnoxgrado', array('clg_enlace_pago_externo' => $idEnlace));

        echo json_encode(array('verificacion_transaccion' => count($registros_clg)));
    }

    public function tiempo_compensatorio($empleado = null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $id_emp = ($empleado) ? $empleado : $this->gsatelite->get_campo('users', 'usu_id_emp', array('id' => $this->tank_auth->get_user_id()));
            $this->verifica_empleado_real($id_emp);
            $data['permisos'] = $this->gsatelite->get_permisos_opcion();
            $registro_empleado = $this->gsatelite->get_tabla('emp_empleado', array('emp_id' => $id_emp));
            $data["info_empleado"] = $registro_empleado[0];
            $data["titulo_personal"] = "Tiempo Compensatorio";
            $data["tiempos_compensatorios_empleado"] = $this->accion_personal_model->get_tiempo_compensatorio(array('tce_id_emp' => $id_emp));
            $data["id_empleado"] = $registro_empleado[0]['emp_id'];
            $this->_cargarvista($data);
        }
    }

    public function comprobar_tiempo_compensatorio () {
        satelite_validar(true);
        $fecha_limite = "";
        $fecha_actual = date("Y-m-d");
        $fecha_inicio = formatear_fecha('Y-m-d', $this->input->post('fecha_inicio'));
        $dias_parametro = $this->gsatelite->get_parametro_emp('INGRESO_TIEMPO_COMPENSATORIO', 0);
        $total_dias_ingreso = intval($dias_parametro);
        if ($dias_parametro > 0) {
            $fecha_limite = date("Y-m-d",strtotime($fecha_actual."- $dias_parametro days"));
            if ($fecha_inicio < $fecha_limite) {
                $tiempo_valido = 0;
            } else {
                $tiempo_valido = 1;
            }
        } else {
            $tiempo_valido = 1;
        }
        echo json_encode(array('tiempo_compensatorio_valido' => $tiempo_valido, 'total_dias_ingreso' => $total_dias_ingreso, 'fecha_limite_actual' => $fecha_limite));
    }

    public function agregar_tiempo_compensatorio($id_emp){
        satelite_validar();
        if ($_POST) {
            $total_dias_vigencia = $this->gsatelite->get_parametro_emp('VIGENCIA_TIEMPO_COMPENSATORIO', 0);
            $fecha_inicio = (trim($this->input->post('txtFechaDesde')) !='') ? formatear_fecha('Y-m-d', $this->input->post('txtFechaDesde')) : null;
            $fecha_vencimiento = ($total_dias_vigencia > 0) ? date('Y-m-d', strtotime("+ $total_dias_vigencia days", strtotime($fecha_inicio))) : null;
            $array_tce = array(
                'tce_id_emp' => $id_emp,
                'tce_num_hora' => $this->input->post('htotals'),
                'tce_fecha_registro' => date("Y-m-d H:i:s"),
                'tce_motivo' => ($this->input->post('motivo') != '') ? $this->input->post('motivo') : null,
                'tce_observacion' => ($this->input->post('observaciones_tiempo') != '') ? $this->input->post('observaciones_tiempo') : null,
                'tce_fecha_desde' => $fecha_inicio,
                'tce_fecha_hasta' => (trim($this->input->post('txtFechaHasta')) !='') ? formatear_fecha('Y-m-d', $this->input->post('txtFechaHasta')) : null,
                'tce_hora_inicio' => (trim($this->input->post('hora_1')) !='') ? $this->input->post('hora_1') : null,
                'tce_hora_final' => (trim($this->input->post('hora_2')) !='') ? $this->input->post('hora_2') : null,
                'tce_fecha_vencimiento' => $fecha_vencimiento,
                'tce_estado' => 1,
                'tce_usu_creacion' => $this->tank_auth->get_user_id(),
                'tce_fecha_creacion' => date("Y-m-d H:i:s"),
                'tce_usu_modificacion' => $this->tank_auth->get_user_id(),
                'tce_fecha_modificacion' => date("Y-m-d H:i:s")
            );
            $id_tce = $this->gsatelite->ingresar('tce_tiempo_compensatorio_empleado', $array_tce);
            $ruta_anexos = $this->input->post('ruta');
            $titulo_anexo = $this->input->post('titulo_doc');
            if (!empty($ruta_anexos)) {
                for ($i = 0; $i < count($ruta_anexos); $i++) {
                    $extension = end(explode('.', $ruta_anexos[$i]));
                    $carpeta_temporal_anx = $ruta = "public/temp/anexos_tiempo_compensatorio/" . trim($ruta_anexos[$i]);
                    $nombreArchivo = trim($titulo_anexo[$i]) . "." . trim($extension);
                    $carpeta_destino_anx = "uploads/anexos_tiempo_compensatorio/" . $nombreArchivo;
                    $documentos_array = array(
                        'anc_id_tce'             => $id_tce,
                        'anc_url'                => $carpeta_destino_anx,
                        'anc_nombre'             => $nombreArchivo,
                        'anc_estado'             => 1,
                        'anc_usu_creacion'       => $this->tank_auth->get_user_id(),
                        'anc_fecha_creacion'     => date('Y-m-d H:i:s'),
                        'anc_usu_modificacion'   => $this->tank_auth->get_user_id(),
                        'anc_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $anh_id = $this->gsatelite->ingresar('anc_anexo_tiempo_compensar_emp', $documentos_array);
                    if ($anh_id > 0) {
                        copy($carpeta_temporal_anx, $carpeta_destino_anx);
                        unlink($carpeta_temporal_anx);
                    }
                }
            }
            $id_emp = $this->input->post('emp_id');
            if($id_tce > 0) {
                $this->gsatelite->show_dialog("Proceso realizado con éxito", "auto_gestion/acciones/tiempo_compensatorio/$id_emp");
            } else {
                $this->gsatelite->show_dialog("Hubo problemas al realizar el proceso", "auto_gestion/acciones/agregar_tiempo_compensatorio/$id_emp", "error");
            }
        } else {
            $this->verifica_empleado_real($id_emp);
            $data["titulo_personal"] = "Tiempo compensatorio";
            $data["info_empleado"] = $this->gsatelite->get_tabla('emp_empleado', array('emp_id' => $id_emp));
            $this->_cargarvista($data, null);
        }
    }

    public function editar_tiempo_compensatorio($id_compensatorio){
        satelite_validar();
        if ($_POST) {
            $empleado = $this->input->post('id_empleado');
                $array_tce = array(
                'tce_num_hora' => $this->input->post('htotals'),
                    'tce_motivo' => ($this->input->post('motivo') != '') ? $this->input->post('motivo') : null,
                    'tce_observacion' => ($this->input->post('observaciones_tiempo') != '') ? $this->input->post('observaciones_tiempo') : null,
                    'tce_fecha_hasta' => (trim($this->input->post('txtFechaHasta')) !='') ? formatear_fecha('Y-m-d', $this->input->post('txtFechaHasta')) : null,
                    'tce_hora_inicio' => (trim($this->input->post('hora_1')) !='') ? $this->input->post('hora_1') : null,
                    'tce_hora_final' => (trim($this->input->post('hora_2')) !='') ? $this->input->post('hora_2') : null,
                'tce_estado' => $this->input->post('estado_tiempo'),
                    'tce_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'tce_fecha_modificacion' => date("Y-m-d H:i:s")
                );
                $update_tce = $this->gsatelite->actualizar_array('tce_tiempo_compensatorio_empleado', $array_tce, array('tce_id' => $id_compensatorio));

                $ruta_anexos = $this->input->post('ruta');
                $titulo_anexo = $this->input->post('titulo_doc');
                if (!empty($ruta_anexos)) {
                    for ($i = 0; $i < count($ruta_anexos); $i++) {
                        $extension = end(explode('.', $ruta_anexos[$i]));
                        $carpeta_temporal_anx = $ruta = "public/temp/anc_anexo_tiempo_compensar_emp/" . trim($ruta_anexos[$i]);
                        $nombreArchivo = trim($titulo_anexo[$i]) . "." . trim($extension);
                        $carpeta_destino_anx = "uploads/anc_anexo_tiempo_compensar_emp/" . $nombreArchivo;
                        $dir = $this->gsatelite->get_tabla('anc_anexo_tiempo_compensar_emp', array('anc_url' => $carpeta_destino_anx, 'anc_estado' => 1));
                        if (!(count($dir) > 0)) {
                            $documentos_array = array(
                                'anc_id_tce'             => $id_compensatorio,
                                'anc_url'                => $carpeta_destino_anx,
                                'anc_nombre'             => $nombreArchivo,
                                'anc_estado'             => 1,
                                'anc_usu_creacion'       => $this->tank_auth->get_user_id(),
                                'anc_fecha_creacion'     => date('Y-m-d H:i:s'),
                                'anc_usu_modificacion'   => $this->tank_auth->get_user_id(),
                                'anc_fecha_modificacion' => date('Y-m-d H:i:s')
                            );
                            $ant_id = $this->gsatelite->ingresar('anc_anexo_tiempo_compensar_emp', $documentos_array);
                            if ($ant_id > 0) {
                                copy($carpeta_temporal_anx, $carpeta_destino_anx);
                                unlink($carpeta_temporal_anx);
                            }
                        }
                    }
                }
                $id_emp = $this->input->post('emp_id');
                $this->gsatelite->show_dialog("Proceso realizado con éxito", "auto_gestion/acciones/tiempo_compensatorio/$id_emp");
        } else {
            $this->verifica_registro_real("tce_tiempo_compensatorio_empleado", $id_compensatorio);
            $reg_tce = $this->accion_personal_model->get_tiempo_compensatorio(array('tce_id' => $id_compensatorio));
            $id_empleado = $reg_tce[0]['tce_id_emp'];
            if ($reg_tce[0]['tce_fecha_vencimiento'] != "" && date('Ymd') > formatear_fecha('Ymd', $reg_tce[0]['tce_fecha_vencimiento'])) {
                $this->gsatelite->show_dialog("No es posible editar un registro vencido", "auto_gestion/acciones/tiempo_compensatorio", "error");
            }
            $data["registro"] = $reg_tce[0];
            $data["info_empleado"] = $this->gsatelite->get_tabla('emp_empleado', array('emp_id' => $id_empleado));
            $data['anx'] = $this->gsatelite->get_tabla('anc_anexo_tiempo_compensar_emp', array('anc_id_tce' => $id_compensatorio, 'anc_estado' => 1));
            $data['read'] = 0;
            $data["titulo_personal"] = "Tiempo compensatorio";
            $this->_cargarvista($data, null);
        }
    }

    public function ver_compensatorio($id_compensatorio){
        satelite_validar();
        $reg_tce = $this->accion_personal_model->get_tiempo_compensatorio(array('tce_id' => $id_compensatorio));
        $data["registro"] = $reg_tce[0];
        $id_empleado = $reg_tce[0]['tce_id_emp'];
        $data["info_empleado"] = $this->gsatelite->get_tabla('emp_empleado', array('emp_id' => $id_empleado));
        $data['anx'] = $this->gsatelite->get_tabla('anc_anexo_tiempo_compensar_emp', array('anc_id_tce' => $id_compensatorio, 'anc_estado' => 1));
        $data["titulo_personal"] = "Tiempo compensatorio";
        $data['read'] = 1;
        cargarvista($data, null, 'auto_gestion/acciones/editar_tiempo_compensatorio');
    }
    

} // Cierre de clase    