<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Auth extends CI_Controller
{
	function __construct()
	{
		parent::__construct();		
		$this->lang->load('tank_auth');
		$this->load->model('gsatelite');
		$this->load->model('consultas');
		$this->load->model('facturacion_model');
	}


	function landin(){

        redirect('/landing_page/public_controller/index');

    }

	function index()
	{
		if ($message = $this->session->flashdata('message')) {
			$this->load->view('auth/general_message', array('message' => $message));
		} else {
			redirect('/auth/login/');
		}
	}

	/**
	 * Login user on the site
	 *
	 * @return void
	 */
	function login()
	{
		if ($this->tank_auth->is_logged_in()) {									// logged in
			redirect('');

		} elseif ($this->tank_auth->is_logged_in(FALSE)) {						// logged in, not activated
			redirect('/auth/send_again/');
			
		} else {
			$data['login_by_username'] = ($this->config->item('login_by_username', 'tank_auth') AND
					$this->config->item('use_username', 'tank_auth'));
			$data['login_by_email'] = $this->config->item('login_by_email', 'tank_auth');

			$this->form_validation->set_rules('login', 'Login', 'trim|required|xss_clean');
			$this->form_validation->set_rules('password', 'Password', 'trim|required|xss_clean');
			$this->form_validation->set_rules('remember', 'Remember me', 'integer');

			// Get login for counting attempts to login
			if ($this->config->item('login_count_attempts', 'tank_auth') AND
					($login = $this->input->post('login'))) {
				$login = $this->security->xss_clean($login);
				// banned user
				//$this->_show_message($this->lang->line('auth_incorrect_email_or_username')'Usuario incorrecto ');
					
				/*echo'<script type="text/javascript">
					alert("Los datos introducidos son incorrectos");
					</script>';*/
			} else {
				$login = '';
			}

			$data['use_recaptcha'] = $this->config->item('use_recaptcha', 'tank_auth');
			if ($this->tank_auth->is_max_login_attempts_exceeded($login)) {
				if ($data['use_recaptcha'])
					$this->form_validation->set_rules('recaptcha_response_field', 'Confirmation Code', 'trim|xss_clean|required|callback__check_recaptcha');
				else
					$this->form_validation->set_rules('captcha', 'Confirmation Code', 'trim|xss_clean|required|callback__check_captcha');
			}
			$data['errors'] = array();

			if ($this->form_validation->run()) {								// validation ok
				if ($this->tank_auth->login(
						$this->form_validation->set_value('login'),
						$this->form_validation->set_value('password'),
						$this->form_validation->set_value('remember'),
						$data['login_by_username'],
						$data['login_by_email'])) {

						$userName   = mb_strtolower($this->form_validation->set_value('login'), 'UTF-8');
                        $password   = mb_strtolower($this->form_validation->set_value('password'), 'UTF-8');
                        if($this->recordatorio_contra($userName)){
                        	$alerta =   array('tipo_alerta'=> 'info','titulo_alerta'=>"Cambiar contraseña",'texto_alerta'=>"La contraseña ha expirado. <br />Le sugerimos cambiar contraseña.");
                        	$this->session->set_flashdata($alerta); 
                        	redirect(base_url('perfil/perfil/cambiar/'.$this->tank_auth->get_user_id()));
                        }
                        if($userName == $password){
                        	$alerta =   array('tipo_alerta'=> 'info','titulo_alerta'=>"Cambiar contraseña",'texto_alerta'=>"Usuario y Clave son iguales <br />Le sugerimos cambiar contraseña.");
                        	$this->session->set_flashdata($alerta); 
                        	redirect(base_url('perfil/perfil/cambiar/'.$this->tank_auth->get_user_id()));
                        }

                    	// success
						redirect('');

				} else {
					$errors = $this->tank_auth->get_error_message();
					if (isset($errors['banned'])) {								// banned user
						$this->_show_message($this->lang->line('auth_message_banned').' '.$errors['banned']);

					} elseif (isset($errors['not_activated'])) {				// not activated user
						redirect('/auth/send_again/');

					} else {													// fail
						foreach ($errors as $k => $v)	$data['errors'][$k] = $this->lang->line($v);
					}
				}
			}
			$data['show_captcha'] = FALSE;
			if ($this->tank_auth->is_max_login_attempts_exceeded($login)) {
				$data['show_captcha'] = TRUE;
				if ($data['use_recaptcha']) {
					$data['recaptcha_html'] = $this->_create_recaptcha();
				} else {
					$data['captcha_html'] = $this->_create_captcha();
				}
			}
			
			$this->load->view('auth/login_form', $data);
		}
	}

	function recordatorio_contra($usuario){
		$this->load->model('sistema');
		$dias = $this->gsatelite->get_parametro('SYS_DIAS_CAMBIO_CONTRASENA',30);
		$registros = $this->sistema->vencimiento_password($usuario, $dias);
		$regresar = (count($registros) > 0)?true:false;
		return $regresar;
	}

	/**
	 * Logout user
	 *
	 * @return void
	 */
	function logout()
	{
		$this->tank_auth->logout();

		$this->_show_message($this->lang->line('auth_message_logged_out'));
	}

	/**
	 * Register user on the site
	 *
	 * @return void
	 */
	function register()
	{
		if ($this->tank_auth->is_logged_in()) {									// logged in
			redirect('');

		} elseif ($this->tank_auth->is_logged_in(FALSE)) {						// logged in, not activated
			redirect('/auth/send_again/');

		} elseif (!$this->config->item('allow_registration', 'tank_auth')) {	// registration is off
			$this->_show_message($this->lang->line('auth_message_registration_disabled'));

		} else {
			$use_username = $this->config->item('use_username', 'tank_auth');
			if ($use_username) {
				$this->form_validation->set_rules('username', 'Username', 'trim|required|xss_clean|min_length['.$this->config->item('username_min_length', 'tank_auth').']|max_length['.$this->config->item('username_max_length', 'tank_auth').']|alpha_dash');
			}
			$this->form_validation->set_rules('email', 'Email', 'trim|required|xss_clean|valid_email');
			$this->form_validation->set_rules('password', 'Password', 'trim|required|xss_clean|min_length['.$this->config->item('password_min_length', 'tank_auth').']|max_length['.$this->config->item('password_max_length', 'tank_auth').']|alpha_dash');
			$this->form_validation->set_rules('confirm_password', 'Confirm Password', 'trim|required|xss_clean|matches[password]');

			$captcha_registration	= $this->config->item('captcha_registration', 'tank_auth');
			$use_recaptcha			= $this->config->item('use_recaptcha', 'tank_auth');
			if ($captcha_registration) {
				if ($use_recaptcha) {
					$this->form_validation->set_rules('recaptcha_response_field', 'Confirmation Code', 'trim|xss_clean|required|callback__check_recaptcha');
				} else {
					$this->form_validation->set_rules('captcha', 'Confirmation Code', 'trim|xss_clean|required|callback__check_captcha');
				}
			}
			$data['errors'] = array();

			$email_activation = $this->config->item('email_activation', 'tank_auth');

			if ($this->form_validation->run()) {								// validation ok
				if (!is_null($data = $this->tank_auth->create_user(
						$use_username ? $this->form_validation->set_value('username') : '',
						$this->form_validation->set_value('email'),
						$this->form_validation->set_value('password'),
						$email_activation))) {									// success

					$data['site_name'] = $this->config->item('website_name', 'tank_auth');

					if ($email_activation) {									// send "activate" email
						$data['activation_period'] = $this->config->item('email_activation_expire', 'tank_auth') / 3600;

						$this->_send_email('activate', $data['email'], $data);

						unset($data['password']); // Clear password (just for any case)

						$this->_show_message($this->lang->line('auth_message_registration_completed_1'));

					} else {
						if ($this->config->item('email_account_details', 'tank_auth')) {	// send "welcome" email

							$this->_send_email('welcome', $data['email'], $data);
						}
						unset($data['password']); // Clear password (just for any case)

						$this->_show_message($this->lang->line('auth_message_registration_completed_2').' '.anchor('/auth/login/', 'Login'));
					}
				} else {
					$errors = $this->tank_auth->get_error_message();
					foreach ($errors as $k => $v)	$data['errors'][$k] = $this->lang->line($v);
				}
			}

			if ($captcha_registration) {
				if ($use_recaptcha) {
					$data['recaptcha_html'] = $this->_create_recaptcha();
				} else {
					$data['captcha_html'] = $this->_create_captcha();
				}
			}
			$data['use_username'] = $use_username;
			$data['captcha_registration'] = $captcha_registration;
			$data['use_recaptcha'] = $use_recaptcha;
			$this->load->view('auth/register_form', $data);
		}
	}

	/**
	 * Send activation email again, to the same or new email address
	 *
	 * @return void
	 */
	function send_again()
	{
		if (!$this->tank_auth->is_logged_in(FALSE)) {							// not logged in or activated
			redirect('/auth/login/');

		} else {
			$this->form_validation->set_rules('email', 'Email', 'trim|required|xss_clean|valid_email');

			$data['errors'] = array();

			if ($this->form_validation->run()) {								// validation ok
				if (!is_null($data = $this->tank_auth->change_email(
						$this->form_validation->set_value('email')))) {			// success

					$data['site_name']	= $this->config->item('website_name', 'tank_auth');
					$data['activation_period'] = $this->config->item('email_activation_expire', 'tank_auth') / 3600;

					$this->_send_email('activate', $data['email'], $data);

					$this->_show_message(sprintf($this->lang->line('auth_message_activation_email_sent'), $data['email']));

				} else {
					$errors = $this->tank_auth->get_error_message();
					foreach ($errors as $k => $v)	$data['errors'][$k] = $this->lang->line($v);
				}
			}
			$this->load->view('auth/send_again_form', $data);
		}
	}

	/**
	 * Activate user account.
	 * User is verified by user_id and authentication code in the URL.
	 * Can be called by clicking on link in mail.
	 *
	 * @return void
	 */
	function activate()
	{
		$user_id		= $this->uri->segment(3);
		$new_email_key	= $this->uri->segment(4);

		// Activate user
		if ($this->tank_auth->activate_user($user_id, $new_email_key)) {		// success
			$this->tank_auth->logout();
			$this->_show_message($this->lang->line('auth_message_activation_completed').' '.anchor('/auth/login/', 'Login'));

		} else {																// fail
			$this->_show_message($this->lang->line('auth_message_activation_failed'));
		}
	}

	/**
	 * Generate reset code (to change password) and send it to user
	 *
	 * @return void
	 */
	function forgot_password()
	{
		if ($this->tank_auth->is_logged_in()) {								// logged in
			redirect('');

		} elseif ($this->tank_auth->is_logged_in(FALSE)) {						// logged in, not activated
			redirect('/auth/send_again/');

		} else {
			$this->form_validation->set_rules('login', 'Email or login', 'trim|required|xss_clean');

			$data['errors'] = array();

			if ($this->form_validation->run()) {								// validation ok
				if (!is_null($data = $this->tank_auth->forgot_password(
						$this->form_validation->set_value('login')))) {

					$data['site_name'] = $this->config->item('website_name', 'tank_auth');

					// Send email with password activation link
					$this->_send_email('forgot_password', $data['email'], $data);
					//$this->_show_message($this->lang->line('auth_message_new_password_sent'));
					$data['confirmado']=$this->lang->line('auth_message_new_password_sent');

				} else {
					$errors = $this->tank_auth->get_error_message();
					foreach ($errors as $k => $v)	$data['errors'][$k] = $this->lang->line($v);
				}
			}
			//$this->load->view('auth/forgot_password_form', $data);

			$this->load->view('auth/forgot_password_form', $data);

		}
	}

	/**
	 * Replace user password (forgotten) with a new one (set by user).
	 * User is verified by user_id and authentication code in the URL.
	 * Can be called by clicking on link in mail.
	 *
	 * @return void
	 */
	function reset_password()
	{
		$user_id		= $this->uri->segment(3);
		$new_pass_key	= $this->uri->segment(4);

		$this->form_validation->set_rules('new_password', 'New Password', 'trim|required|xss_clean|min_length['.$this->config->item('password_min_length', 'tank_auth').']|max_length['.$this->config->item('password_max_length', 'tank_auth').']|alpha_dash');
		$this->form_validation->set_rules('confirm_new_password', 'Confirm new Password', 'trim|required|xss_clean|matches[new_password]');

		if ($this->form_validation->run()) {								// validation ok
			if (!is_null($data = $this->tank_auth->reset_password(
					$user_id, $new_pass_key,
					$this->form_validation->set_value('new_password')))) {	// success

				$data['site_name'] = $this->config->item('website_name', 'tank_auth');

				// Send email with new password
				$this->_send_email('reset_password', $data['email'], $data);

				$data['mensaje']=$this->lang->line('auth_message_new_password_activated');

			} else {														// fail
				$data['mensaje']=$this->lang->line('auth_message_new_password_failed');
			}
		} else {
			// Try to activate user by password key (if not activated yet)
			if ($this->config->item('email_activation', 'tank_auth')) {
				$this->tank_auth->activate_user($user_id, $new_pass_key, FALSE);
			}

			if (!$this->tank_auth->can_reset_password($user_id, $new_pass_key)) {
				$data['mensaje']=$this->lang->line('auth_message_new_password_failed');
			}
		}
		$this->load->view('auth/reset_password_form', $data);
	}

	/**
	 * Change user password
	 *
	 * @return void
	 */
	function change_password()
	{
		if (!$this->tank_auth->is_logged_in()) {								// not logged in or not activated
			redirect('/auth/login/');

		} else {
			$this->form_validation->set_rules('old_password', 'Old Password', 'trim|required|xss_clean');
			$this->form_validation->set_rules('new_password', 'New Password', 'trim|required|xss_clean|min_length['.$this->config->item('password_min_length', 'tank_auth').']|max_length['.$this->config->item('password_max_length', 'tank_auth').']|alpha_dash');
			$this->form_validation->set_rules('confirm_new_password', 'Confirm new Password', 'trim|required|xss_clean|matches[new_password]');

			$data['errors'] = array();

			if ($this->form_validation->run()) {								// validation ok
				if ($this->tank_auth->change_password(
						$this->form_validation->set_value('old_password'),
						$this->form_validation->set_value('new_password'))) {	// success
					$this->_show_message($this->lang->line('auth_message_password_changed'));

				} else {														// fail
					$errors = $this->tank_auth->get_error_message();
					foreach ($errors as $k => $v)	$data['errors'][$k] = $this->lang->line($v);
				}
			}
			$data=$this->masterpage->getUsuario();
			$this->masterpage->setMasterPage('masterpage_default');
			$this->masterpage->addContentPage('auth/change_password_form', 'content',$data);
			$this->masterpage->show();			
		}
	}

	/**
	 * Change user email
	 *
	 * @return void
	 */
	function change_email()
	{
		if (!$this->tank_auth->is_logged_in()) {								// not logged in or not activated
			redirect('/auth/login/');

		} else {
			$this->form_validation->set_rules('password', 'Password', 'trim|required|xss_clean');
			$this->form_validation->set_rules('email', 'Email', 'trim|required|xss_clean|valid_email');

			$data['errors'] = array();

			if ($this->form_validation->run()) {								// validation ok
				if (!is_null($data = $this->tank_auth->set_new_email(
						$this->form_validation->set_value('email'),
						$this->form_validation->set_value('password')))) {			// success

					$data['site_name'] = $this->config->item('website_name', 'tank_auth');

					// Send email with new email address and its activation link
					$this->_send_email('change_email', $data['new_email'], $data);

					$this->_show_message(sprintf($this->lang->line('auth_message_new_email_sent'), $data['new_email']));

				} else {
					$errors = $this->tank_auth->get_error_message();
					foreach ($errors as $k => $v)	$data['errors'][$k] = $this->lang->line($v);
				}
			}
			$this->load->view('auth/change_email_form', $data);
		}
	}

	/**
	 * Replace user email with a new one.
	 * User is verified by user_id and authentication code in the URL.
	 * Can be called by clicking on link in mail.
	 *
	 * @return void
	 */
	function reset_email()
	{
		$user_id		= $this->uri->segment(3);
		$new_email_key	= $this->uri->segment(4);

		// Reset email
		if ($this->tank_auth->activate_new_email($user_id, $new_email_key)) {	// success
			$this->tank_auth->logout();
			$this->_show_message($this->lang->line('auth_message_new_email_activated').' '.anchor('/auth/login/', 'Login'));

		} else {																// fail
			$this->_show_message($this->lang->line('auth_message_new_email_failed'));
		}
	}

	/**
	 * Delete user from the site (only when user is logged in)
	 *
	 * @return void
	 */
	function unregister()
	{
		if (!$this->tank_auth->is_logged_in()) {								// not logged in or not activated
			redirect('/auth/login/');

		} else {
			$this->form_validation->set_rules('password', 'Password', 'trim|required|xss_clean');

			$data['errors'] = array();

			if ($this->form_validation->run()) {								// validation ok
				if ($this->tank_auth->delete_user(
						$this->form_validation->set_value('password'))) {		// success
					$this->_show_message($this->lang->line('auth_message_unregistered'));

				} else {														// fail
					$errors = $this->tank_auth->get_error_message();
					foreach ($errors as $k => $v)	$data['errors'][$k] = $this->lang->line($v);
				}
			}
			$this->load->view('auth/unregister_form', $data);
		}
	}

	/**
	 * Show info message
	 *
	 * @param	string
	 * @return	void
	 */
	function _show_message($message)
	{
		$this->session->set_flashdata('message', $message);
		redirect('/auth');
	}

	/**
	 * Send email message of given type (activate, forgot_password, etc.)
	 *
	 * @param	string
	 * @param	string
	 * @param	array
	 * @return	void
	 */
	function _send_email($type, $email, &$data)
	{

		$config_g['mailtype'] = "html";
		//Las configuraciones para correo personalizado estan en:
		//---  \bodas\system\libraries\Email.php
	
		$this->load->library('email',$config_g);
		
		$this->email->from($this->config->item('webmaster_email', 'tank_auth'), $this->config->item('website_name', 'tank_auth'));
		$this->email->reply_to($this->config->item('webmaster_email', 'tank_auth'), $this->config->item('website_name', 'tank_auth'));
		$this->email->to($email);
		$this->email->subject(sprintf($this->lang->line('auth_subject_'.$type), $this->config->item('website_name', 'tank_auth')));
		$this->email->message($this->load->view('email/'.$type.'-html', $data, TRUE));
		$this->email->set_alt_message($this->load->view('email/'.$type.'-txt', $data, TRUE));
		$this->email->send();
	}

	/**
	 * Create CAPTCHA image to verify user as a human
	 *
	 * @return	string
	 */
	function _create_captcha()
	{
		$this->load->helper('captcha');

		$cap = create_captcha(array(
			'img_path'		=> './'.$this->config->item('captcha_path', 'tank_auth'),
			'img_url'		=> base_url().$this->config->item('captcha_path', 'tank_auth'),
			'font_path'		=> './'.$this->config->item('captcha_fonts_path', 'tank_auth'),
			'font_size'		=> $this->config->item('captcha_font_size', 'tank_auth'),
			'img_width'		=> $this->config->item('captcha_width', 'tank_auth'),
			'img_height'	=> $this->config->item('captcha_height', 'tank_auth'),
			'show_grid'		=> $this->config->item('captcha_grid', 'tank_auth'),
			'expiration'	=> $this->config->item('captcha_expire', 'tank_auth'),
		));

		// Save captcha params in session
		$this->session->set_flashdata(array(
				'captcha_word' => $cap['word'],
				'captcha_time' => $cap['time'],
		));

		return $cap['image'];
	}

	/**
	 * Callback function. Check if CAPTCHA test is passed.
	 *
	 * @param	string
	 * @return	bool
	 */
	function _check_captcha($code)
	{
		$time = $this->session->flashdata('captcha_time');
		$word = $this->session->flashdata('captcha_word');

		list($usec, $sec) = explode(" ", microtime());
		$now = ((float)$usec + (float)$sec);

		if ($now - $time > $this->config->item('captcha_expire', 'tank_auth')) {
			$this->form_validation->set_message('_check_captcha', $this->lang->line('auth_captcha_expired'));
			return FALSE;

		} elseif (($this->config->item('captcha_case_sensitive', 'tank_auth') AND
				$code != $word) OR
				strtolower($code) != strtolower($word)) {
			$this->form_validation->set_message('_check_captcha', $this->lang->line('auth_incorrect_captcha'));
			return FALSE;
		}
		return TRUE;
	}

	/**
	 * Create reCAPTCHA JS and non-JS HTML to verify user as a human
	 *
	 * @return	string
	 */
	function _create_recaptcha()
	{
		$this->load->helper('recaptcha');

		// Add custom theme so we can get only image
		$options = "<script>var RecaptchaOptions = {theme: 'custom', custom_theme_widget: 'recaptcha_widget'};</script>\n";

		// Get reCAPTCHA JS and non-JS HTML
		$html = recaptcha_get_html($this->config->item('recaptcha_public_key', 'tank_auth'));

		return $options.$html;
	}

	/**
	 * Callback function. Check if reCAPTCHA test is passed.
	 *
	 * @return	bool
	 */
	function _check_recaptcha()
	{
		$this->load->helper('recaptcha');

		$resp = recaptcha_check_answer($this->config->item('recaptcha_private_key', 'tank_auth'),
				$_SERVER['REMOTE_ADDR'],
				$_POST['recaptcha_challenge_field'],
				$_POST['recaptcha_response_field']);

		if (!$resp->is_valid) {
			$this->form_validation->set_message('_check_recaptcha', $this->lang->line('auth_incorrect_captcha'));
			return FALSE;
		}
		return TRUE;
	}

	/**
     * @author Edith Herrera
     * @since  2018-02-26
     * @return Verificar usuario y contraseña correctas
    **/
	function verificar_usuario(){
		$login = $this->input->post('login');
		$password = $this->input->post('password');

		$flagValidarActiveDirectory = $this->gsatelite->get_parametro_emp('SYS_VALIDAR_ACTIVE_DIRECTORY');
		$flagValidarActiveDirectory = boolval($flagValidarActiveDirectory);

		$reg_usuario = $this->gsatelite->get_tabla('users', array('username'=>$login, 'activated'=>1)); // Verifica existencia de usuario
		if(count($reg_usuario)<=0){ echo json_encode( array('tipo'=>'error','title'=>'Acceso denegado', 'mensaje'=>'Usuario incorrecto')); die();}
		
		if (!$flagValidarActiveDirectory) {
			$clave = $reg_usuario[0]['password'];
			$exito = $this->tank_auth->verificar_clave($password, $clave, $login); // verifica clave ingresada
			if (!$exito) {echo json_encode( array('tipo'=>'error','title'=>'Acceso denegado', 'mensaje'=>'Contraseña incorrecta')); die();}

		} else if ($flagValidarActiveDirectory) {
			$exitoLoginActiveDirectory = $this->gsatelite->user_active_directory($login, $password); // verificar usuario active directory
			if(!$exitoLoginActiveDirectory){ echo json_encode( array('tipo'=>'error','title'=>'Acceso denegado', 'mensaje'=>'Usuario o clave incorrecta')); die();}
			
		}

		// Si los datos son correctos
		/*********** verifica empresasa asociadas al usuario **********************/
	
					$this->db->where('emr_estado', 1);
					$this->db->join('emr_empresa', 'uxe_id_emr=emr_id');
		$empresas = $this->gsatelite->get_tabla('uxe_usuarioxempresa', array('uxe_id_usu'=>$reg_usuario[0]['id']));
			

		$drop_emr = '<option value=""></option>';
		$asignada = 0;
		if(count($empresas)>1){ // Si tiene mas de una empresa asociada
			foreach ($empresas as $emr) {
				$drop_emr .= '<option value="'.$emr['emr_id'].'">'.$emr['emr_nombre'].'</option>';
			}
		}else if(count($empresas)==1){ // Si tiene únicamente una empresa asociada.
			$asignada = $empresas[0]['emr_id'];
			$this->gsatelite->actualizar_array('oxr_opcionxrol', array('oxr_id_emr'=>$asignada), array('oxr_id_emr IS NULL'=>null));
		}else{ // Si no tiene empresas asociadas
						  $this->db->order_by('emr_id', 'ASC');
			$existe_emr = $this->gsatelite->get_tabla('emr_empresa', array('emr_estado'=>1));
        	$emp_par = $this->gsatelite->get_parametro('SYS_EMPRESA'); // verificamos que haya registro en el parámetro
        	$user = $reg_usuario[0]['id'];
        	if(count($existe_emr)>0){
        		 $uxe_emr=array(
                        'uxe_id_emr'=>$existe_emr[0]['emr_id'],
                        'uxe_id_usu'=>$user,
                        'uxe_estado'=>1,
                        'uxe_usu_creacion'=>$this->tank_auth->get_user_id(),
                        'uxe_fecha_creacion'=>date('Y-m-d H:i:s'),
                        'uxe_usu_modificacion'=>$this->tank_auth->get_user_id(),
                        'uxe_fecha_modificacion'=>date('Y-m-d H:i:s')
                        );
                $this->gsatelite->ingresar('uxe_usuarioxempresa', $uxe_emr);
            	$asignada = $existe_emr[0]['emr_id'];

            	$this->gsatelite->actualizar_array('oxr_opcionxrol', array('oxr_id_emr'=>$asignada), array('oxr_id_emr IS NULL'=>null));
        	}else{
        		if($emp_par!=''){
                    $last=$this->consultas->get_max_codigo('emr_empresa','emr_codigo');

                    $code=$last->codigo;
                    $cod= (int)$code+1;
                    $codigo = str_pad($cod, 4, '0', STR_PAD_LEFT);

                    $arr_emr=array(
                        'emr_codigo'=>$codigo,
                        'emr_nombre'=>$emp_par,
                        'emr_estado'=>1,
                        'emr_usu_creacion'=>$this->tank_auth->get_user_id(),
                        'emr_fecha_creacion'=>date('Y-m-d H:i:s'),
                        'emr_usu_modificacion'=>$this->tank_auth->get_user_id(),
                        'emr_fecha_modificacion'=>date('Y-m-d H:i:s')
                        );

                    $new_emr = $this->gsatelite->ingresar('emr_empresa', $arr_emr);

                    if($new_emr>0){
                        $uxe_emr=array(
                            'uxe_id_emr'=>$new_emr,
                            'uxe_id_usu'=>$user,
                            'uxe_estado'=>1,
                            'uxe_usu_creacion'=>$this->tank_auth->get_user_id(),
                            'uxe_fecha_creacion'=>date('Y-m-d H:i:s'),
                            'uxe_usu_modificacion'=>$this->tank_auth->get_user_id(),
                            'uxe_fecha_modificacion'=>date('Y-m-d H:i:s')
                            );

                        $this->gsatelite->ingresar('uxe_usuarioxempresa', $uxe_emr);
                    }

                                    $this->db->join('emr_empresa', 'emr_id=uxe_id_emr AND emr_estado=1');
                    $emr_asig =  $this->gsatelite->get_tabla('uxe_usuarioxempresa', array('uxe_id_usu'=>$user));

                    $asignada = $emr_asig[0]['emr_id'];
                    $this->gsatelite->actualizar_array('oxr_opcionxrol', array('oxr_id_emr'=>$asignada), array('oxr_id_emr IS NULL'=>null));

                }else{ // Si no existe en parametro
					echo json_encode( array('tipo'=>'error','title'=>'Acceso denegado', 'mensaje'=>'Es necesario asignar una empresa.')); die(); 
                }
        	}
		}
		
		echo json_encode( array('tipo'=>1, 'drop'=>$drop_emr, 'select'=>$asignada));
	}


	/**
     * @author Edith Herrera
     * @since  2018-02-27
     * @return Verificar usuario y contraseña correctas
    **/ 
	function login_form($user=null, $pass=null, $empr=null){
		$login 	  = ($user!=null)? $user: $this->input->post('hdnUsuario');
		$password = ($pass!=null)? $pass: $this->input->post('hdnPassword');
		$empresa  = ($empr!=null)? $empr: $this->input->post('hdnEmpresa');
		$attempts = $this->tank_auth->is_max_login_attempts_exceeded($login);
		$flagValidarActiveDirectory = $this->gsatelite->get_parametro_emp('SYS_VALIDAR_ACTIVE_DIRECTORY');
		$flagValidarActiveDirectory = boolval($flagValidarActiveDirectory);		
		
		if($attempts){
			$this->gsatelite->show_dialog('Ha excedido los intentos permitidos. Comunicarse con el administrador para reiniciar intentos de inicio de sesión', 'auth/login', 'error', 'Información');
		}else{
			$log = $this->tank_auth->login($login, $password, null, true, true, $empresa, $flagValidarActiveDirectory);
			$this->loggin = $log;
			if($log){
				if($this->recordatorio_contra($login) && !$flagValidarActiveDirectory){
	            	$alerta =   array('tipo_alerta'=> 'info','titulo_alerta'=>"Cambiar contraseña",'texto_alerta'=>"La contraseña ha expirado. <br />Le sugerimos cambiar contraseña.");
	            	$this->session->set_flashdata($alerta); 
	            	redirect(base_url('perfil/perfil/cambiar/'.$this->tank_auth->get_user_id()));
	            }
				// if($login == $password){
		  		//   $alerta =   array('tipo_alerta'=> 'info','titulo_alerta'=>"Cambiar contraseña",'texto_alerta'=>"Usuario y Clave son iguales <br />Le sugerimos cambiar contraseña.");
				//           $this->session->set_flashdata($alerta); 
				//           redirect(base_url('perfil/perfil/cambiar/'.$this->tank_auth->get_user_id()));
				//       }
				// Definir variables
				$id_usuario = $this->tank_auth->get_user_id(); 
				$id_empresa = $this->tank_auth->get_empresa_id();

				// verificar pantalla por defecto
				// Obtener el rol del usuario
				$this->db->order_by('uxr_id_rol', 'asc');$this->db->limit(1);
				$usuario_rol = $this->gsatelite->get_tabla('uxr_usuarioxrol', array('uxr_id_usu'=>$id_usuario)); 

				// Obtener la url
				$this->db->join('oxr_opcionxrol', 'oxr_id_opc = opc_id');
				$get_url = $this->gsatelite->get_tabla('opc_opcion', array('oxr_id_rol'=>$usuario_rol[0]['uxr_id_rol'], 'oxr_id_emr'=>$id_empresa, 'oxr_defecto_inicio'=>1));

				// variables de url
				$modulo  = "";
				$funcion = "";
				$url 	 = "";

		        // Si el logueo es existoso se redirecciona a la pantalla por defecto sino al index
				if (count($get_url) > 0) {
					$es_hijo = $this->gsatelite->get_tabla('opc_opcion', array('opc_id'=>$get_url[0]['opc_padre']));
					
					if ($es_hijo[0]['opc_padre'] == 0) {
						$url = $es_hijo[0]['opc_funcion'].'/'.$get_url[0]['opc_funcion'].'/index';
					} else {
						$es_padre = $this->gsatelite->get_tabla('opc_opcion', array('opc_id'=>$es_hijo[0]['opc_padre']));
						$url = $es_padre[0]['opc_funcion'].'/'.$es_hijo[0]['opc_funcion'].'/'.$get_url[0]['opc_funcion'];
					}
					// Redireccionar a la pantalla por defecto
					// print_r($url);die();
					redirect($url);
				} else {
					// Sino esta definido una pantalla
					redirect('');
				}

			}else{
				redirect('auth/login');
			}
		}
	}

	/**
	*	@author: Mario Marquez 
	*	@since: 2019-06-22
	*   @return: Datos del Usuario autenticado.
	*	@version: 1.0
	*	Devolución de los datos de un usuario al Punto de Venta.
	*/
	public function autenticar_usuario(){
		if($this->input->post()){
			//var_dump($this->input->post());die();
			$login = $this->input->post('login');
			$password = $this->input->post('password');
			$resultado_array = array('tipo' => '','titulo' => '', 'mensaje' => '', 'data' => '');
			$reg_usuario = $this->gsatelite->get_tabla('users', array('username'=>$login, 'activated'=>1)); // Verifica existencia de usuario

			if(count($reg_usuario)<=0){ 
				$resultado_array['tipo'] = 'error';
				$resultado_array['titulo'] = 'Acceso denegado';
				$resultado_array['mensaje'] = 'Usuario incorrecto';
			}

			$clave = $reg_usuario[0]['password'];
			$exito = $this->tank_auth->verificar_clave($password, $clave, $login); // verifica clave ingresada

			if(!$exito){  // Si los datos son incorrectos
				$resultado_array['tipo'] = 'error';
				$resultado_array['titulo'] = 'Acceso denegado';
				$resultado_array['mensaje'] = 'Contraseña incorrecta';
			}
			else{

				$empleado = $this->gsatelite->get_tabla('emp_empleado', array('emp_id' => $reg_usuario[0]['usu_id_emp']));
				//Se verifica la parte del Vendedor y las cajas por Usuario
				$idvendedor = $this->gsatelite->get_tabla('ven_vendedor', array('ven_id_usu'=> $reg_usuario[0]['id']));

				$resultado_array['tipo'] = 'success';
				$resultado_array['titulo'] = 'Usuario Autenticado';
				$resultado_array['mensaje'] = 'Información correcta';
				$resultado_array['data'] = array(
					'id' => $reg_usuario[0]['id'],
					'username' => $reg_usuario[0]['username'],
					'email' => $reg_usuario[0]['email']
				); //$reg_usuario[0];
				$resultado_array['ven_id'] = ( $idvendedor[0]['ven_id'] != null)? $idvendedor[0]['ven_id']:null;

				$this->db->join('uxe_usuarioxempresa','uxe_id_emr = emr_id','inner');
				$empresa = $this->gsatelite->get_tabla('emr_empresa', array('uxe_id_usu' => $reg_usuario[0]['id']));

				 $rol = $this->gsatelite->get_parametro('SYS_ID_ROL_CAJA');
            	 $cajas = $this->facturacion_model->datos_usuario_caja($rol, $reg_usuario[0]['id']);

            	 $sucursal = null;
            	 if((isset($cajas[0]['caj_id_suc']) && $cajas[0]['caj_id_suc'] != null)){
            	 	$sucursal = $this->gsatelite->get_tabla('suc_sucursal', array('suc_id' => $cajas[0]['caj_id_suc']));
            	 }
            	 //print_r($this->db->last_query());die();

				$resultado_array['caja']= array(
					'caj_id' => (isset($cajas[0]['caj_id']) && $cajas[0]['caj_id'] != null) ? $cajas[0]['caj_id'] : 0,
					'usuario_caja' => (isset($cajas[0]['uxc_id']) && $cajas[0]['uxc_id'] != null) ? $cajas[0]['uxc_id'] : null, 
					'correlativoxcaja' => (isset($cajas[0]['caj_id']) && $cajas[0]['caj_id'] != null) ? $cajas[0]['cxj_id'] : 0,
					'correlativo_caja' => (isset($cajas[0]['caj_id']) && $cajas[0]['caj_id'] != null) ? $cajas[0]['cof_id'] : 0,
					'correlativo_inicio' => (isset($cajas[0]['cxj_inicio']) && $cajas[0]['cxj_inicio'] != null) ? $cajas[0]['cxj_inicio'] : 0,
					'correlativo_fin' => (isset($cajas[0]['cxj_fin']) && $cajas[0]['cxj_fin'] != null) ? $cajas[0]['cxj_fin'] : 0,
					'serie_correlativo' => (isset($cajas[0]['cof_id_sef']) && $cajas[0]['cof_id_sef'] != null) ? $cajas[0]['cof_id_sef'] : 0,
					'sucursal_caja' => (isset($cajas[0]['caj_id_suc']) && $cajas[0]['caj_id_suc'] != null) ? $cajas[0]['caj_id_suc'] : $cajas[0]['emp_id_suc'],
					'sucursal_direccion' => ($sucursal != null) ? $sucursal[0]['suc_direccion'] : '',
					'sucursal_nombre' => ($sucursal != null) ? $sucursal[0]['suc_nombre'] : '',
					'fecha_caja' => (isset($cajas[0]['uxc_id']) && $cajas[0]['uxc_id'] != null) ? formatear_fecha('d-m-Y',$cajas[0]['uxc_fecha_proceso']) : date('d-m-Y')
				);


				$resultado_array['nombre_empleado'] = (isset($empleado[0]))?$empleado[0]['emp_nombre'] .' '.$empleado[0]['emp_apellido']:'';
				$resultado_array['empresa'] = $empresa[0]['emr_id'];
				$resultado_array['pais'] = $empresa[0]['emr_id_pai'];
			}

			//Se envia la respuesta
			echo "jsonPHP".preg_replace("/\xEF\xBB\xBF/", "", json_encode($resultado_array, JSON_UNESCAPED_UNICODE  ));

		}else{
			echo "jsonPHP".preg_replace("/\xEF\xBB\xBF/", "", json_encode(array()));
		}
	}

}
/* End of f"ile auth.php */
/* Location: ./application/controllers/auth.php */