<?php
date_default_timezone_set('America/El_Salvador');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');
header("Content-Type: application/json; charset=UTF-8");

if (!defined('BASEPATH')) exit('No direct script access allowed');

class Api_token_login extends CI_Controller
{
    protected $usuario_id;
    protected $expira_en;

    function __construct()
    {
        parent::__construct();
        $this->load->model('api/api_facturacion_model');
        $this->load->library('api/api_facturacion/recursos_validacion');

        $metodo_actual = $this->router->method;

        if (!in_array($metodo_actual, ['refresh_token'])) {
            $this->recursos_validacion->validar_token_bearer();
            $this->usuario_id = $this->recursos_validacion->usuario_id;
            $this->expira_en = $this->recursos_validacion->expira_en;
        }
    }

    public function verify_conn()
    {
        while (ob_get_level() > 0) ob_end_clean();
        ob_implicit_flush(true);

        $token_data = $this->db
            ->where('apt_usu_id', $this->usuario_id)
            ->where('apt_estado', 1)
            ->order_by('apt_id', 'desc')
            ->limit(1)
            ->get('apt_api_tokens')
            ->row_array();

        if ($token_data) {
            $log_actual = json_decode($token_data['apt_log_accion'], true) ?: [];

            $log_actual[] = [
                'accion' => 'verificacion_token',
                'fecha' => date('Y-m-d H:i:s'),
                'ip' => $_SERVER['REMOTE_ADDR'] ? $_SERVER['REMOTE_ADDR'] : 'unknown',
                'user_agent' => $_SERVER['HTTP_USER_AGENT'] ? $_SERVER['HTTP_USER_AGENT'] : 'unknown'
            ];

            $this->db->where('apt_id', $token_data['apt_id']);
            $this->db->update('apt_api_tokens', [
                'apt_log_accion' => json_encode($log_actual, JSON_UNESCAPED_UNICODE)
            ]);
        }

        $usuario = $this->db->get_where('users', ['id' => $this->usuario_id])->row_array();
        ob_clean();
        return $this->output
            ->set_output(json_encode([
                'codse' => 200,
                'status' => 'success',
                'message' => 'Conexión establecida con éxito',
                'expira_en' => $this->expira_en,
                'usuario' => [
                    'id' => $usuario['id'],
                    'username' => $usuario['username'],
                    'email' => $usuario['email']
                ]
            ]));
    }

    public function refresh_token()
    {
        $data = json_decode(file_get_contents('php://input'), true);

        if (!isset($data['refresh_token']) || trim($data['refresh_token']) == '') {
            clean_buffer();
            return $this->output
                ->set_status_header(400)
                ->set_output(json_encode([
                    'status' => 'error',
                    'message' => 'Debe proporcionar el refresh_token'
                ]));
        }

        $refresh_token = trim($data['refresh_token']);
        $token_data = $this->api_facturacion_model->validar_refresh_token($refresh_token);

        if (!$token_data) {
            clean_buffer();
            return $this->output
                ->set_status_header(401)
                ->set_output(json_encode([
                    'status' => 'error',
                    'message' => 'Refresh token inválido o expirado'
                ]));
        }

        $this->db->where('apt_usu_id', $token_data['apt_usu_id']);
        $this->db->update('apt_api_tokens', ['apt_estado' => 0]);

        $nuevo_access_token = bin2hex(openssl_random_pseudo_bytes(32));
        $nuevo_refresh_token = bin2hex(openssl_random_pseudo_bytes(32));
        $nueva_expiracion = date('Y-m-d H:i:s', strtotime('+60 minutes'));
        $refresh_expira_en = date('Y-m-d H:i:s', strtotime('+10 days'));

        $log_accion = [[
            'accion' => 'refresh',
            'fecha' => date('Y-m-d H:i:s'),
            'ip' => $_SERVER['REMOTE_ADDR'] ? $_SERVER['REMOTE_ADDR'] : null,
            'user_agent' => $_SERVER['HTTP_USER_AGENT'] ? $_SERVER['HTTP_USER_AGENT'] : null
        ]];

        $this->db->insert('apt_api_tokens', [
            'apt_usu_id' => $token_data['apt_usu_id'],
            'apt_access_token' => $nuevo_access_token,
            'apt_refresh_token' => $nuevo_refresh_token,
            'apt_fecha_creacion' => date('Y-m-d H:i:s'),
            'apt_expira_en' => $nueva_expiracion,
            'apt_refresh_expira_en' => $refresh_expira_en,
            'apt_estado' => 1,
            'apt_log_accion' => json_encode($log_accion, JSON_UNESCAPED_UNICODE)
        ]);
        clean_buffer();
        return $this->output
            ->set_status_header(200)
            ->set_output(json_encode([
                'status' => 'success',
                'access_token' => $nuevo_access_token,
                'refresh_token' => $nuevo_refresh_token,
                'expira_en' => $nueva_expiracion
            ]));
    }

    public function generar_certificado_empresa()
    {
        $resultado = $this->recursos_validacion->generar_certificado_empresa();
        clean_buffer();
        return $this->output
            ->set_status_header($resultado['code'])
            ->set_content_type('application/json')
            ->set_output(json_encode($resultado, JSON_UNESCAPED_UNICODE));
    }

    public function firmar_json_con_certificado()
    {
        $resultado = $this->recursos_validacion->firmar_json_con_certificado();
        clean_buffer();
        return $this->output
            ->set_status_header($resultado['code']? 200 : 400)
            ->set_content_type('application/json')
            ->set_output(json_encode($resultado, JSON_UNESCAPED_UNICODE));
    }
}
