<?php



date_default_timezone_set('America/El_Salvador');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');
header("Content-Type: application/json; charset=UTF-8");

if (!defined('BASEPATH')) exit('No direct script access allowed');

class Api_tank_login extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->library('tank_auth');
        $this->load->model('api/api_facturacion_model');
        $this->load->model('gsatelite');
        $this->load->library('api/api_facturacion/recursos_validacion');
    }

    public function index()
    {
        $input_raw = file_get_contents("php://input");
        $datos = json_decode($input_raw, true);

        if (!isset($datos['json'], $datos['firma'])) {
            clean_buffer();
            return $this->output
                ->set_status_header(400)
                ->set_output(json_encode([
                    'status' => 'error',
                    'message' => 'Debe enviar el JSON firmado correctamente'
                ]));
        }

        $payload = $datos['json'];
        $firma = $datos['firma'];

        if (!preg_match('/^[a-zA-Z0-9\/\r\n+]*={0,2}$/', $firma)) {
            clean_buffer();
            return $this->output
                ->set_status_header(400)
                ->set_output(json_encode([
                    'status' => 'error',
                    'message' => 'La firma no tiene un formato Base64 válido.'
                ]));
        }

        if (!isset($payload['usuario'], $payload['clave'])) {
            clean_buffer();
            return $this->output
                ->set_status_header(400)
                ->set_output(json_encode([
                    'status' => 'error',
                    'message' => 'Debe proporcionar usuario y clave en el JSON firmado.'
                ]));
        }

        $usuario = $payload['usuario'];
        $clave = $payload['clave'];
        $empresa = 1;

        $log = $this->tank_auth->login($usuario, $clave, null, true, true, $empresa);

        if (!$log) {
            clean_buffer();
            return $this->output
                ->set_status_header(401)
                ->set_output(json_encode([
                    'status' => 'error',
                    'message' => 'Credenciales inválidas'
                ]));
        }

        $usuario_id = $this->tank_auth->get_user_id();

        $valido = $this->recursos_validacion->verificar_firma_directa($payload, $firma, $usuario_id);
        if (!$valido['valido']) {
            clean_buffer();
            return $this->output
                ->set_status_header(401)
                ->set_output(json_encode([
                    'status' => 'error',
                    'message' => $valido['mensaje']
                ]));
        }

        $this->db->where('apt_usu_id', $usuario_id);
        $this->db->update('apt_api_tokens', ['apt_estado' => 0]);

        $access_token = bin2hex(openssl_random_pseudo_bytes(32));
        $refresh_token = bin2hex(openssl_random_pseudo_bytes(32));
        $fecha_creacion = date('Y-m-d H:i:s');
        $expira_en = date('Y-m-d H:i:s', strtotime('+60 minutes'));
        $refresh_expira_en = date('Y-m-d H:i:s', strtotime('+10 days'));

        $log_accion = [[
            'accion' => 'login',
            'fecha' => $fecha_creacion,
            'ip' => $_SERVER['REMOTE_ADDR'] ? $_SERVER['REMOTE_ADDR'] : null,
            'user_agent' => $_SERVER['HTTP_USER_AGENT'] ? $_SERVER['HTTP_USER_AGENT'] : null
        ]];

        $this->db->insert('apt_api_tokens', [
            'apt_usu_id' => $usuario_id,
            'apt_access_token' => $access_token,
            'apt_refresh_token' => $refresh_token,
            'apt_fecha_creacion' => $fecha_creacion,
            'apt_expira_en' => $expira_en,
            'apt_refresh_expira_en' => $refresh_expira_en,
            'apt_estado' => 1,
            'apt_log_accion' => json_encode($log_accion, JSON_UNESCAPED_UNICODE)
        ]);

        $user = $this->db->get_where('users', ['id' => $usuario_id])->row_array();

        clean_buffer();

        return $this->output
            ->set_status_header(200)
            ->set_output(json_encode([
                'status' => 'success',
                'message' => 'Login correcto',
                'access_token' => $access_token,
                'refresh_token' => $refresh_token,
                'expira_en' => $expira_en,
                'usuario' => [
                    'id' => $user['id'],
                    'username' => $user['username'],
                    'email' => $user['email']
                ]
            ]));
    }
}
