<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Traslado extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->model('activo_fijo');
        $this->load->model('gsatelite');
    }

	/**
	 * Traslado de activo fijo
	 * @return html Traslado de activo fijo
	 */
	public function index()
	{
		//Verificar Permisos de acceso
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            //$this->output->enable_profiler(ENVIRONMENT == 'development'); //Testing

            //Preparando la informacion que sera enviada a la vista
            //NOTA: empleados es una vista en mysql.
         $data['traslados'] = $this->activo_fijo->get_registros('empleados'); 
         $data['are_opciones'] = $this->activo_fijo->get_registros('are_area');

            //Cargar vista 
         $this->_cargarvista( null, $data );
     }
     
 }

  /**
   * listado  de activo fijo por ID de Empleado
   * @return html Traslado de activo fijo
   */
  public function listado()
  {
    //Verificar Permisos de acceso
    if (!$this->tank_auth->is_logged_in()) {
        redirect('/auth/login/');
    } else {
            $this->output->enable_profiler(ENVIRONMENT == 'development'); //Testing

            $id_emp = $this->uri->segment(4);
            
            //Preparando la informacion que sera enviada a la vista
            //NOTA: vw_nombre_empleado es una vista en mysql.
            $data['empleado'] = $this->activo_fijo->get_registros_where(
                'vw_nombre_empleado', 
                array( 'emp_id' => $id_emp )
                );
            //Listado de empleados
            $data['emp_opciones'] = $this->activo_fijo->get_registros('vw_nombre_empleado');
            //NOTA: vw_listado_activos es una vista en mysql.
            $data['listado'] = $this->activo_fijo->get_registros_where(
              'vw_listado_activos ', 
              array('axe_id_emp' => $id_emp)
              ); 
            
            //Cargar vista 
            $this->_cargarvista( null, $data );
        }
        
    }
    /**
     * @author Alexis Beltran
     */
    /*public function ver_activos()
    {
        //(new Procesos())->validar_user();
    	try{
            $area = $this->gsatelite->get_campo('vw_empleados', 'are_nombre', array(
                'usu_id' => $this->tank_auth->get_user_id()
            ));
            
            
            //$destinos = $this->get_detalle_accion();
            
            $data = array(
                'solicitante'   => $this->gsatelite->get_campo('vw_empleados', 'nombre_completo', array('usu_id' => $this->tank_auth->get_user_id()) ),
                'area'          => $area,
                'titulo_personal'  => "Traslado de Activo Fijo"
            ); 
           $this->_cargarvista($data,true);
    	}catch(Exception $e){
    		show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
    	}
    }*/

    public function ver_activos()
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data['areas']=$this->activo_fijo->get_areas();
            $data['empleados_con_activos'] = $this->activo_fijo->empleados_con_activos();

            $data['titulo_personal'] = "Traslado de activo fijo";
            $this->_cargarvista($data);
        }
    }
    
    /**
     * @author Alexis Beltran
     */
    /*function get_activos()
    {
        $emp_id = $this->input->post('emp_id_tra');
        //$exd_id = $this->input->post('exd_id');
        if( $emp_id /*|| $exd_id*//* ){
            
            if( is_numeric($emp_id) ){
                $this->db->where('emp_id', $emp_id);
            }
            /*
            if( $exd_id ){
                $pro_id = $this->gsatelite->get_campo('pro_proceso', 'pro_id', array('pro_id_exd' => $exd_id));
                if( $pro_id > 0 ){ $this->db->where('pro_id', $pro_id); }
            }
            */
            /*$datos =  $this->db->get('vw_activos')->result();
            
            if( count($datos) < 1 ){
                ?>
                <tr><td colspan="5" style="text-align: center;">No hay activos asignados.</td></tr>
                <?php
            }else{
                foreach($datos as $row){
            ?>
        <tr>
            <td><?php echo $row->saf; ?></td>
            <td><?php echo $row->codigo; ?></td>
            <td><?php echo $row->nombre; ?></td>
            <td><?php echo number_format($row->valor,2); ?></td>
            <td><input class="ibuttonCheck nostyle" type="checkbox" name="activos[]" value="<?php echo $row->act_id; ?>" /></td>
        </tr>
            <?php
                }   
            }
        }
    }*/

    public function get_activos()
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $this->session->keep_flashdata('activos');
            $emp=$this->input->post('emp_id_tra');
            $activosxempleados = $this->activo_fijo->empleados_con_activos($emp);

            $cadena='';
            foreach ($activosxempleados as $key) {

              $cadena.='<tr><td>'.$key['act_codigo'].'</td>';
              $cadena.='<td>'.$key['act_nombre'].'</td>';
              $cadena.='<td>'.$key['act_valor_cont'].'</td>';
              $cadena.='<td><input class="ibuttonCheck nostyle" type="checkbox" id="activo_sel" name="activos[]" value="'.$key['act_id'].'" /></td></tr>';           
          }
            $cadena.='<tr><td style="text-align:right;" colspan="3"><b>Seleccionar todos</b></td><td><input class="ibuttonCheck nostyle" type="checkbox"  id="select_all" /></td></tr>';


          $arreglo=array(
            'drop' => $cadena);
          echo json_encode($arreglo);
      }
  }

  function existe_sesion(){
    if($this->session->flashdata('nada')=='nada'){echo json_encode(array('existepdf' => true ));
    $alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Traslado de activos",'texto_alerta'=>"El traslado se realizó correctamente");
    $this->session->set_flashdata($alerta);
  }
        //$this->session->keep_flashdata('nada');
    }
  
  public function save_traslado()
  {
    if (!$this->tank_auth->is_logged_in()) {
        redirect('/auth/login/');
    } else {
        $activos       = $this->input->post('activos');
        $emp_id_origen = $this->input->post('emp_origen');
        $area          = $this->input->post('area');
        $obs           = $this->input->post('obs');
        $emp_id_destino= $this->input->post('emp_id');
        $usu_id        = $this->tank_auth->get_user_id();
        
        
        if( is_array($activos) && ( $emp_id_origen || $area ) ){

            foreach ($activos as $activo) {
                $data_update=array(
                    'axe_estado'=> 0,
                    'axe_use_mod'=> $usu_id,
                    'axe_fecha_mod'=>date('Y-m-d h:i:s'));
                $this->db->where('axe_id_act',$activo);
                $this->db->where('axe_id_emp',$emp_id_origen);
                $this->db->where('axe_estado',1);
                $this->db->update('axe_activoxempleado',$data_update);
                $data_insert=array('axe_id_act'=>$activo,
                    'axe_id_emp'=>$emp_id_destino,
                    'axe_id_are'=>$area,
                    'axe_obs'=>$obs,
                    'axe_fecha'=>date('Y-m-d h:i:s'),
                    'axe_estado'=>1,
                    'axe_use_mod'=>$this->tank_auth->get_user_id(),
                    'axe_fecha_mod'=>date('Y:m:d h:i:s'));
                $this->db->insert('axe_activoxempleado',$data_insert);    
            }
            $this->db->join('act_activo_fijo','act_id=axe_id_act');
            $this->db->join('emp_empleado','emp_id=axe_id_emp');
            $this->db->join('are_area','are_id=emp_id_are');
            $this->db->where('axe_estado',1);
            $this->db->where_in('axe_id_act', $activos);
            $activos_data =  $this->db->get('axe_activoxempleado')->result();
            $emp_entrega=$this->db->get_where('emp_empleado',array('emp_id'=>$emp_id_origen))->row_array();
            $this->load->library('pdf');
            $html  = $this->load->view('reporte/header', array('titulo' => 'Traslado de Activos'), true);
            $html .= $this->load->view('activo/traslado/reporte', array('activos' => $activos_data,'entrega'=>$emp_entrega), true);
            $this->session->set_flashdata('nada','nada');
            $reporte=$this->pdf->reportePDF2($html);

            //$this->session->set_flashdata('activos',$activos);
            //$alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Baja de activo",'texto_alerta'=>"La baja de activo se guardó correctamente");
            //$this->session->set_flashdata($alerta);
            redirect('activo/traslado/ver_activos');
        }else{
            $this->gsatelite->show_dialog('Los activos no fueron trasladados.', 'activo/traslado/ver_activos', 'error');
        }
    }
}

  public function pdf_traslado()
  {
    $this->session->flashdata('activos');
    $activos=$this->session->flashdata('activos');
    $this->db->join('act_activo_fijo','act_id=axe_id_act');
            $this->db->join('emp_empleado','emp_id=axe_id_emp');
            $this->db->join('are_area','are_id=emp_id_are');
            $this->db->where('axe_estado',1);
            $this->db->where_in('axe_id_act', $activos);
            $activos_data =  $this->db->get('axe_activoxempleado')->result();
            $this->load->library('pdf');
            $html  = $this->load->view('reporte/header', array('titulo' => 'Traslado de Activos'), true);
            $html .= $this->load->view('activo/traslado/reporte', array('activos' => $activos_data), true);
            $this->pdf->setPageOrientation('P');
            $this->pdf->makePDF($html);
  }

	/**
	 * Trasladar activo fijo a empleado
	 */
	public function trasladar_activo()
	{
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {

    $activos       = $this->input->post('tra_activos'); //ID(s) de activos para traslado
    $asignar_a     = $this->input->post('lst_empleados'); //ID de empleado 
    $observaciones = $this->input->post('tra_observacion');

    $this->form_validation->set_rules('tra_activos', 'Activos', 'required');
    $this->form_validation->set_rules('lst_empleados', 'Empleado', 'required|greater_than[0]');

    $result = false;

    if ( $this->form_validation->run() != FALSE ) {
      //trasladar activo(s)
      $result = $this->activo_fijo->set_traslado_activo( $activos, $asignar_a, $observaciones );
  }

    //Redirigir a la pagina de ingreso de activo fijo
  redirect( base_url( 'activo/traslado?result='.$result ) );
}
}
	/**
	 * AJAX: Obtener detalles de activo fijo para traslado
	 * @return json Detalles del activo fijo por ID
	 */
	public function get_detalles_traslado()
	{
        
	    //Verificar acceso unicamente, mediante AJAX
      if ( !$this->input->is_ajax_request() ) {
          exit('No direct script access allowed');
      }
      //Obtener el id del activo
      $id_activo_fijo = $_GET['id_traslado'];

      $result = $this->activo_fijo->get_detalles_activo_fijo( $id_activo_fijo );

      echo  $result ;
  }

	/**
     * Cargar vista del controlador
     * 
     * @param integer $data
     * @param integer $crud
     * @return HTML vista del controlador
     */
	function _cargarvista($data = 0, $crud = 0, $full = false )
	{	
		$this->load->view('vacia',$crud);	
		if($data!=0)
			$data=array_merge($data,$this->masterpage->getUsuario());
		else
			$data=$this->masterpage->getUsuario();
		$vista=$data['modulo'].'/'.$data['control'].'/'.$data['funcion'];
        if($full){
            $this->masterpage->setMasterPage('masterpage_full');
        }else{
            $this->masterpage->setMasterPage('masterpage_default');
        }
        $this->masterpage->addContentPage($vista, 'content',$data);
        $this->masterpage->show();
    }

}

/* End of file traslado.php */
/* Location: ./application/controllers/traslado.php */