<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Reportes extends CI_Controller 
{

	public function __construct()
	{
		parent::__construct();
		$this->load->model('activo_fijo');
        $this->load->model('consultas');
        $this->load->model('gsatelite');
        $this->load->helper('satelite_helper');
        $this->load->library('pdf');
        $this->load->library('excel/excel_reader.php');
    }

    public function bajas(){
        //Verificar Permisos de acceso
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            //$data['activos'] = $this->activo_fijo->get_listado_depreciacion(null,'0');
            $data['titulo_personal']="Baja de activos";
            $tipo_activo = $this->gsatelite->get_dropdown('tac_tipo_activofijo', '{tac_codigo} - {tac_nombre}', '', array('tac_estado'=>1), null, null, 'tac_id', true);
            $departamento = $this->gsatelite->get_dropdown('are_area', '{are_nombre}', '', array('are_estado' => 1), null, '', 'are_id', true);
            $data['tipo_activo'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $tipo_activo);
            $data['departamento'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $departamento);
            $data['centro_costo'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $this->gsatelite->get_dropdown('cec_centro_costo', ' {cec_nombre}', '', array('cec_estado' => 1), null, '', 'cec_id', true));

            $this->_cargarvista(null, $data);
        }
    }
    

    public function caracteristicasxactivo()
    {
        $data['activos']     = $this->activo_fijo->get_caracteristicas_activos(null, 'cxc_id_act');
        $tac = $this->gsatelite->get_dropdown('tac_tipo_activofijo', '{tac_codigo} - {tac_nombre}', '', array('tac_estado' => '1'), null, '', 'tac_id', true);
        $data['activo_fijo'] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $tac);

        $data['centro_costo'] =str_replace('<option value="0">Seleccione</option>', '',$this->gsatelite->get_dropdown('cec_centro_costo', ' {cec_nombre}', '', array('cec_estado' => 1), null, '', 'cec_id', true));
        $data['titulo_personal'] = "Reporte de características por activo";
        $this->_cargarvista($data);
    }

    public function imprimir_caracteristicas($flag = null)
      { //print_r($_POST);die();
        ini_set( 'memory_limit', '2048M' );
        ini_set('max_execution_time', '9999');

        if($flag) {
            $tipo           = $this->input->post("tipo");
            $tipo_activo    = $this->input->post("tipo_activo");
            $costo_x        = ($this->input->post('slcCosto') != "") ? $this->input->post('slcCosto') : null;
        } else {
            $tipo           = $this->input->post("tipo");
            $tipo_activo    = $this->input->post("filtro_tipo");
             $costo_x        = ($this->input->post('slcCosto') != "") ? $this->input->post('slcCosto') : null;
        }
        $filtros_titulo = '<br><br>';
        if($tipo_activo != null) {
            $where['act_id_tac'] = $tipo_activo;
            $filtros_titulo      .= '<b>Tipo activo: </b>'.$this->gsatelite->get_campo('tac_tipo_activofijo','tac_nombre',array('tac_id' => $tipo_activo)).'<br>';
        }

        if ($costo_x !== null) {
          $where['act_id_cec'] = $this->input->post('slcCosto');
           $filtros_titulo      .= '<b>Centro costo: </b>'.$this->gsatelite->get_campo('cec_centro_costo','cec_nombre',array('cec_id' => $this->input->post('slcCosto'))).'<br>';
         } 


        $data['activos'] = $this->activo_fijo->get_caracteristicas_activos($where, 'cxc_id_act');
        if (empty($data['activos'])) {

            $data['activos'] = $this->gsatelite->get_tabla("act_activo_fijo",$where);

        }
        $data['tipo']    = $tipo;
        
        if($flag) {
            $html = $this->load->view('activo/reportes/caracteristicas_print', $data, true);
            echo json_encode(array('html'=>$html));
        } else {
            if($tipo==1){ // para formato en PDF
                //pdf reporte

                $this->load->library('pdf');
                $html    = $this->load->view('reporte/header', array('titulo' => 'Caracteristicas de activos'.$filtros_titulo.''), true);
                $html   .= $this->load->view('activo/reportes/caracteristicas_print', $data,true);
                
                $reporte=$this->pdf->reportePDF2($html,null,'lanscape','I'); 
            }else if($tipo == 2){ // Para formato en Excel
                 //Nombre del archivo 
                $filename = 'rpt_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);
                $data['table_header'] = "Reporte de características por activo ";
                $data['filename']=$filename;
                
                $data_header = array(
                'titulo' => 'Reporte de características por activo '.$filtros_titulo,
                "solotitulo"=>1,
                "columnas"=> 3
                );
                //$data['filtros'] = $filtros_titulo;
                $heaader  = $this->load->view('reporte/header', $data_header, true);
                $html     = $this->load->view('activo/reportes/caracteristicas_print_excel', $data);
                $html = str_replace(
                array('<table border="0.5"','border="0">'), 
                array('<table border="1"','border="1">'), 
                $html);
                header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                header("Content-Disposition: attachment;filename=caracteristicas".date('d-m-Y_His').".xls"); 
                header("Pragma: no-cache");
                header("Expires: 0");
                echo '<meta charset="utf-8" />';
                echo $heaader.$html;

                
            }
        }                      

        
    }
    
    public function imprimir_bajas($tipo)
    {
        //Verificar Permisos de acceso
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $activos = $this->activo_fijo->get_listado_depreciacion(null,'0');
            $data['titulo_personal']="BAJA DE ACTIVOS";
            if($tipo==1){    
                $this->load->library('pdf');
                $html  = $this->load->view('reporte/header', array('titulo' => 'BAJA DE ACTIVOS'), true);
                $html .= $this->load->view('activo/reportes/reporte_bajas', array('activos' => $activos), true);
                $reporte=$this->pdf->reportePDF2($html);
            }else if($tipo==2){
                //Nombre del archivo 
                $filename = 'rpt_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);
                $data['table_header'] = "Reporte de baja de activos ";
                $data['activos']=$activos;
                 $data['html_header']  = $this->load->view('reporte/header', array('titulo' => 'BAJA DE ACTIVOS'), true);
                $data['filename']=$filename;
                $data['header'] = $this->load->view('reporte/header', array('titulo' => 'BAJA DE ACTIVOS'),true);

                 $this->load->view('activo/reportes/reporte_bajas_excel.php', $data);
            }
        }
    }

    public function traslado_activos($flag = 0)
    {
        if($this->input->post()){ //print_r($_POST);die();

            if ($flag == 1) {

                $fecha_ini  = ($this->input->post('fecha_ini')) ? $this->input->post('fecha_ini') : null;
                $fecha_fin  = ($this->input->post('fecha_fin')) ? $this->input->post('fecha_fin') : null;
                $activo     = (trim($this->input->post('activo')) != "")?trim($this->input->post('activo')):null;
                $responsable= (trim($this->input->post('responsable')) != "")?trim($this->input->post('responsable')):null;
                $sucursal   = (trim($this->input->post('sucursal')) != "")?trim($this->input->post('sucursal')):null;
                $area       = (trim($this->input->post('area')) != "")?trim($this->input->post('area')):null;
                $tipo_activo = (trim($this->input->post('tipo_activo')) != "")?trim($this->input->post('tipo_activo')):null;
                $costo_x = ( $this->input->post('slcCosto') != "") ? $this->input->post('slcCosto') : null;
            } else {

                $fecha_ini  = ($this->input->post('filtro_txtFechaIni')) ? $this->input->post('filtro_txtFechaIni') : null;
                $fecha_fin  = ($this->input->post('filtro_txtFechaFin')) ? $this->input->post('filtro_txtFechaFin') : null;
                $activo     = (trim($this->input->post('filtro_activo')) != "")?trim($this->input->post('filtro_activo')):null;
                $responsable= (trim($this->input->post('filtro_responsable')) != "")?trim($this->input->post('filtro_responsable')):null;
                $sucursal   = (trim($this->input->post('filtro_sucursal')) != "")?trim($this->input->post('filtro_sucursal')):null;
                $area       = (trim($this->input->post('filtro_area')) != "")?trim($this->input->post('filtro_area')):null;
                $tipo_reporte = (trim($this->input->post('tipo_reporte')) != "")?trim($this->input->post('tipo_reporte')):null;
                 $costo_x = ( $this->input->post('slcCosto2') != "") ? $this->formato_fecha($this->input->post('slcCosto2')) : null;
            }

            $where = array();

            


            if ($fecha_ini) {
                $where['axe_fecha >='] = date('Y-m-d', strtotime($fecha_ini));
            }
            if ($fecha_fin) {
                $where['axe_fecha <='] = date('Y-m-d H:i:s', strtotime($fecha_fin." 23:59:59"));
            }


            if($area != null){
                $where['axe_id_are'] = $area;
            }
            if($tipo_activo != null){
                //$where['act_tac'] = $tipo_activo;
                /*
                *@todo Buscar la columna correcta
                */
            }
            if($sucursal != null){
                $where['suc_id']    = $sucursal;
            }
            if($responsable != null){
                $where['emp_id']    = $responsable;
            }
            if($activo != null){
                $where['act_id']    = $activo;
            }

            if($costo_x !== null) {
                $where['act_id_cec'] = $this->input->post('slcCosto');
            } 

            $activos = $this->activo_fijo->get_activo_empleado($where);
            
            $data['activos'] = $activos;

            $detalle          = $this->load->view('activo/reportes/consultar_traslado_activos', $data, true);
            $data['fecha_ini']= $fecha_ini;
            $data['fecha_fin']= $fecha_fin;
            $data['area']     = $this->gsatelite->get_tabla('are_area', array('are_id'=>$area, 'are_estado'=>1));
            $data['sucursal'] = $this->gsatelite->get_tabla('suc_sucursal', array('suc_id'=>$sucursal));
            $data['resp']     = $this->gsatelite->get_tabla('emp_empleado', array('emp_id'=>$responsable, 'emp_estado'=>1));
            $data['activo_fijo'] = $this->gsatelite->get_tabla('act_activo_fijo', array('act_id'=>$activo));

            if ($flag) {

                echo json_encode($detalle);
                die();

            } else {
                if ($tipo_reporte == 'pdf') {

                    $data['titulo'] = 'Traslado de Activos';
                    $data['pdf'] = 1;
                
                    $data['tipo_reporte'] = $tipo_reporte;
                    $header = $this->load->view('reporte/header', $data, true);
                    $GLOBALS['nombre_reporte'] = 'reporte_traslado_activos' . date('dmY');
                    $html = $this->load->view('activo/reportes/consultar_traslado_activos', $data, true);
                    $reporte = $header.$html;

                    // echo $reporte;
                    $this->pdf->makePdf($reporte, 'L', 'reporte_traslado_activos', 'Letter');
                } elseif ($tipo_reporte == 'excel') {

                    $filename = 'rpt_reporte_traslado_activos_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
                    $data['titulo'] = 'Traslado de Activos';

                    $data['tipo_reporte'] = $tipo_reporte;
                    $data['excel'] = 1;
                    $data['filename'] = $filename;
                    $html = $this->load->view('activo/reportes/consultar_traslado_activos', $data, true);
                    echo $html;
                }
            }
        }else{
            $data['titulo_personal']="Reporte de traslados";
            $data['areas']    = $this->activo_fijo->get_areas();

            $personal_reg     = $this->gsatelite->get_dropdown('emp_empleado', '{emp_codigo} - {emp_nombre} {emp_apellido}', '', null, null, null, 'emp_id', true);
            $data['empleado'] =  str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $personal_reg);

            $sucursal_reg     = $this->gsatelite->get_dropdown('suc_sucursal', '{suc_nombre}', '', null, null, null, 'suc_id', true);
            $data['sucursal'] =  str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $sucursal_reg);

            $activo_reg       = $this->gsatelite->get_dropdown('act_activo_fijo', '{act_codigo} - {act_nombre}', '', null, null, null, 'act_id', true);
            $data['activo']   =  str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $activo_reg);
            $data['centro_costo'] =str_replace('<option value="0">Seleccione</option>', '',$this->gsatelite->get_dropdown('cec_centro_costo', ' {cec_nombre}', '', array('cec_estado' => 1), null, '', 'cec_id', true));
            $tipo_activo = $this->gsatelite->get_dropdown('tac_tipo_activofijo',
         '{tac_codigo} - {tac_nombre}', '', array('tac_estado'=>1), null, null, 'tac_id', true);
        $data['tipo_activo'] = str_replace('<option value="0">Seleccione</option>',
         '<option value=""></option>', $tipo_activo);

            $this->_cargarvista($data);
        }
    }

    public function activos_area($id_area=null,$tipo_r=1,$fecha_inicio="",$fecha_final="",$depreciaciones="")
    {
        $data['reporte']=null;
        
        if ($id_area != null and $tipo_r>0) {
             $data['reporte']="reporte";

             if ($depreciaciones == "1") {
                $data['depreciacion'] = "Aplica";
             }else if ($depreciaciones == "2"){
                $data['depreciacion'] = "No aplica";
             }else{
                $data['depreciacion'] = "Todos";
                $depreciaciones = null;
             }   

             if ($id_area == 0) {
                $area[0]['are_nombre'] = "Todos";
                $data['area'] = $area;
                $id_area = null;
             } else {
                $area = $this->gsatelite->get_tabla('are_area',array('are_id' => $id_area));
                $data['area']=$area;
             }           

             $lista=$this->activo_fijo->reporte_activos_area2($id_area,$fecha_inicio,$fecha_final,$depreciaciones);
             $data['lista']=$lista;  
             $data['fecha_inicio'] = $fecha_inicio;
             $data['fecha_fin'] = $fecha_final; 
             
           
            

             if ($tipo_r==1) {
                $this->load->library('pdf');
                $html  = $this->load->view('reporte/header', array('titulo' => 'Activos'), true);
                $html .= $this->load->view('activo/reportes/activos_area_reporte', $data, true);
                $this->pdf->makePDF($html, 'L');
                //$reporte=$this->pdf->reportePDF2($html);  
             } elseif ($tipo_r==2) {
                 $html = $this->load->view('activo/reportes/activos_area_reporte', $data, true);
                 header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                 header("Content-Disposition: attachment;filename=reporte_activo".date('dmY').".xls"); 
                 header("Pragma: no-cache");
                 header("Expires: 0");
                 echo '<meta charset="utf-8" />';
                 echo "<table border='0'>
                      <tr><th colspan='5' align='center' >".
                      mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'),'UTF-8')
                      ."</th></tr>
                      <tr><th colspan='5' align='center' >Reporte de Activos</th></tr>
                      </table>"; 
                 echo $html;   
                 die();
             }
        }
        elseif($_POST){
            $area=$this->input->post('area');
            $fecha_ini=$this->input->post('txtFechaIni');
            $fecha_fin=$this->input->post('txtFechaFin');
            if ($area == 0){
                $area = null;
            }

            $depreciacion= ($this->input->post('depreciacion') == 3)? null:$this->input->post('depreciacion');
            $fecha_ini = date('Y-m-d', strtotime($fecha_ini));
            $fecha_fin = date('Y-m-d', strtotime($fecha_fin));
            $data['lista']=$this->activo_fijo->reporte_activos_area2($area,$fecha_ini,$fecha_fin,$depreciacion);   
            
            /*
            $cadena="";
            if(count($lista)>0){
            foreach ($lista as $key => $value) {
                $cadena.="<tr><td>".$value['act_codigo']."</td>";
                $cadena.="<td>".$value['act_nombre']."</td>";
                $cadena.="<td>".$value['act_fecha_adq']."</td>";
                $cadena.="<td>".$value['act_valor_compra']."</td>";
                $cadena.="<td>".$value['depreciacion_acumulada']."</td></tr>";
            }
        }
        else{
            $cadena.="<tr><td colspan=6>Cero registros encontrados</td></tr>";
        }
            */
            $arreglo=array(
                'listado'=>$this->load->view('activo/reportes/activos_area_reporte', $data, true)
                //,'query'=>$this->db->last_query()
                );
            echo json_encode($arreglo);
        }else{
            $data['areas'] = $this->activo_fijo->get_areas();
            $data['activo'] = $this->activo_fijo->lista_activos();
            $data['titulo_personal']="Listado de activos por área";
            $this->_cargarvista($data);

        }

    }

    public function lista_activos()
    {   
        redirect('activo/reportes/total_activos');
        $data['porcentaje_valor_residual'] = $this->gsatelite->get_parametro('PORCENTAJE_VALOR_RESIDUAL_ACTIVO');
        if($_POST['area']){
            $area=$this->input->post('area');
            $lista=$this->db->select()
                            ->from('act_activo_fijo')
                            ->join('axe_activoxempleado','axe_id_act=act_id')
                            ->join('emp_empleado','axe_id_emp=emp_id')
                            ->join('are_area','axe_id_are=are_id')
                            ->join('suc_sucursal','suc_id=emp_id_suc')
                            ->where('axe_id_are',$area)
                            ->where('axe_estado',1)->get()->result_array();
                           
            $cadena="";
            if(count($lista)>0){
                foreach ($lista as $key => $value) {
                    if($value['act_depreciable']==1) { $var='Depreciable'; } else{ $var='No depreciable';}
                    $cadena.="<tr><td>".$value['act_nombre']."</td>";
                    $cadena.="<td>".$value['suc_nombre']."</td>";
                    $cadena.="<td>".$value['act_fecha_adq']."</td>";
                    $cadena.="<td>".$value['act_valor_compra']."</td>";
                    $cadena.="<td>".$var."</td></tr>";
                }
            }else{
                $cadena.="<tr><td colspan='8'>Cero registros encontrados</td></tr>";
            }
            $arreglo=array('listado'=>$cadena,'query'=>$this->db->last_query());
            echo json_encode($arreglo);

        }else{
            $data['areas'] = $this->activo_fijo->get_areas();
            $data['activo'] = $this->activo_fijo->lista_activos();
            //print_r($this->db->last_query()); die();
            $data['titulo_personal']="Reporte total de activos";
            $this->_cargarvista($data);
        }

    }

    public function reporte_lista_activos($area=null,$tipo=0)
    {
        $data['porcentaje_valor_residual'] = $this->gsatelite->get_parametro('PORCENTAJE_VALOR_RESIDUAL_ACTIVO');
        if($area != 'null' && $area != '' && $area != null){
            $lista =  $lista=$this->db->select("*,(SELECT round(sum(dep_monto), 2) FROM dep_depreciacion WHERE dep_id_act = act_id) AS depreciacion_acumulada
                            , (SELECT MAX(DATE_FORMAT(CONCAT(prd_ano,'-',prd_mes,'-','01'),'%Y-%m')) from dep_depreciacion JOIN prd_periodo_deprec on prd_id=dep_id_prd WHERE dep_id_act = act_id ) ultima_fecha_depreciacion",false)
                            ->from('act_activo_fijo')
                            ->join('axe_activoxempleado','axe_id_act=act_id')
                            ->join('emp_empleado','axe_id_emp=emp_id')
                            ->join('are_area','axe_id_are=are_id')
                            ->join('suc_sucursal','suc_id=emp_id_suc')
                            ->where('axe_id_are',$area)
                            ->where('axe_estado',1)->get()->result_array();
        }
        else if($area == 'null' || $area == ''){
            $lista =  $lista=$this->db->select("*,(SELECT round(sum(dep_monto), 2) FROM dep_depreciacion WHERE dep_id_act = act_id) AS depreciacion_acumulada
                            , (SELECT MAX(DATE_FORMAT(CONCAT(prd_ano,'-',prd_mes,'-','01'),'%Y-%m')) from dep_depreciacion JOIN prd_periodo_deprec on prd_id=dep_id_prd WHERE dep_id_act = act_id ) ultima_fecha_depreciacion",false)
                                ->from('act_activo_fijo')
                                ->join('axe_activoxempleado','axe_id_act=act_id','left')
                                ->join('emp_empleado','emp_id=axe_id_emp','left')
                                ->join('are_area','are_id=emp_id_are','left')
                                ->join('suc_sucursal','suc_id=emp_id_suc','left')
                                ->group_by('act_id')->get()->result_array();
        }
                                // print_r($this->db->last_query()); die();
        if($tipo==1){
            $this->load->library('pdf');
            $html  = $this->load->view('reporte/header', array('titulo' => 'Totalidad de activos'), true);
            $html .= $this->load->view('activo/reportes/print_lista_activos', array('activo' => $lista), true);
            $reporte=$this->pdf->reportePDF2($html);  
        }else if($tipo==2){
            //Nombre del archivo 
            $filename = 'rpt_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);
            $data['table_header'] = "<h2>Reporte de activos </h2>"." - Generación Reporte: ".$this->tank_auth->get_username()." / ".date("d-m-Y");
            $data['activo']=$lista;
            $data['filename']=$filename;

             $this->load->view('activo/reportes/activos_excel.php', $data);

        }
        
    }

    public function reporte_traslado_activos()
    {
        $tabla=$this->input->post('tabla');
        $tipo=$this->input->post('tipo');

        if($tipo==1){    
            $this->load->library('pdf');
            $html  = $this->load->view('reporte/header', array('titulo' => 'Traslado de activos'), true);
            $html .= $tabla;
            //$html=$tabla;
            $this->pdf->reportePDF2($html);
        }else if($tipo==2){
             //Nombre del archivo 
            $filename = 'rpt_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);
            $data['table_header'] = "Reporte de traslados ";
            $data['activo']=$tabla;
            $data['filename']=$filename;

             $this->load->view('activo/reportes/reporte_traslados.php', $data);
        }
        

    }

    public function fecha_adq() {
        $tipo_activo = $this->gsatelite->get_dropdown('tac_tipo_activofijo',
         '{tac_codigo} - {tac_nombre}', '', array('tac_estado'=>1), null, null, 'tac_id', true);
        $data['tipo_activo'] = str_replace('<option value="0">Seleccione</option>',
         '<option value=""></option>', $tipo_activo);

        $departamento = $this->gsatelite->get_dropdown('are_area',
         '{are_nombre}', '', array('are_estado' => 1), null, '', 'are_id', true);
        $data['departamento'] = str_replace('<option value="0">Seleccione</option>',
         '<option value=""></option>', $departamento);
        $data['titulo_personal']="Búsqueda de activos por fecha de adquisición";
        $data['centro_costo'] =str_replace('<option value="0">Seleccione</option>', '',$this->gsatelite->get_dropdown('cec_centro_costo', ' {cec_nombre}', '', array('cec_estado' => 1), null, '', 'cec_id', true));
        $this->_cargarvista($data);
    }

    public function busqueda_fechas()
    {        
       

        $fecha1 = ( $this->input->post('f1') != "") ? $this->formato_fecha($this->input->post('f1')) : null;
        
        $fecha2 = ( $this->input->post('f2') != "") ? $this->formato_fecha($this->input->post('f2')) : null;

        $costo_x = ( $this->input->post('slcCosto') != "") ? $this->input->post('slcCosto') : null;

        $estado = $this->input->post('estado');
        $where = array();
        if ((is_array($estado)) and (count($estado)>0)) {
            $estados = implode(',', $estado);
            $where['act_depreciable IN ('.$estados.')'] = null;
        }

        //Departamento y tipo como filtro de busqueda (Carlos Alberto Noyola 21-03-2019)
        $departamento=$this->input->post('departamento');
        $tipo_activo=$this->input->post('tipo_activo');
        if ($departamento != null ) {
            $where['act_id_are'] = $departamento;
        }
        if($tipo_activo != null) {
            $where['act_id_tac'] = $tipo_activo;
        }
        if ($costo_x !== null) {
            $where['act_id_cec'] = $this->input->post('slcCosto');
        }
        $resultados=$this->activo_fijo->lista_adquisicion($fecha1, $fecha2, $where);
        // var_dump($this->db->last_query()); die();        
        $lista="";
        $total = 0.0;
        $i = 1;
        foreach ($resultados as $key => $value) {
            $lista.='<tr>';
            $lista.='<td style="display:none">'.$i.'</td><td>'.$value['act_codigo'].'</td>';
            $lista.='<td>'.$value['prov'].'</td>';
            $lista.='<td>'.$value['documento'].'</td>';
            $lista.='<td>'.$value['dep'].'</td>';
            $lista.='<td>'.$value['act_nombre'].'</td>';
            $lista.='<td>'.$value['act_fecha_adq'].'</td>';
            $lista.='<td>'.$value['act_valor_compra'].'</td>';
            $lista.='</tr>';
            $total += $value['act_valor_compra'];
            $i++;
        }
            $lista .=  '<tr><td style="display:none">'.($i + 1).'<td></td></td><td></td><td></td><td></td><td></td><td style="font-weight:bold;text-align:right">Total</td><td style="font-weight:bold;text-align:center">$'.$total.'</td></tr>';
        $arreglo=array('lista'=>$lista);
        echo json_encode($arreglo);
    }

    public function reporte_adq()
    {        
        //$fecha1 = $this->formato_fecha($this->input->post('fecha1'));        
        //$fecha2 = $this->formato_fecha($this->input->post('fecha2'));

        $filtros_titulo = '<br>';
        $fecha1 = ( $this->input->post('fecha1') != "") ? $this->formato_fecha($this->input->post('fecha1')) : null;
        
        $fecha2 = ( $this->input->post('fecha2') != "") ? $this->formato_fecha($this->input->post('fecha2')) : null;

        $departamento = ( $this->input->post('slcDepartamento') != "") ? $this->input->post('slcDepartamento') : null;
        $tipo_activo = ( $this->input->post('slcTipoActivo') != "") ? $this->input->post('slcTipoActivo') : null;        
        $costo_x = ( $this->input->post('slcCosto') != "") ? $this->input->post('slcCosto') : null;

        $tipo_rep=$this->input->post('tipo');
        $where = array();

        $estado = $this->input->post('slcStado');
        $where = array();
        if ((is_array($estado)) and (count($estado)>0)) {
            $estados = implode(',', $estado);
            $where['act_depreciable IN ('.$estados.')'] = null;
        }

        if ($departamento != null ) {
                    $where['act_id_are'] = $departamento;
                    $filtros_titulo      .= '<b>Departamento:</b> '.$this->gsatelite->get_campo('are_area','are_nombre',array('are_id' => $departamento)).'<br>';
                }
        if($tipo_activo != null) {
                    $where['act_id_tac'] = $tipo_activo;
                     $filtros_titulo      .= '<b>Tipo activo:</b> '.$this->gsatelite->get_campo('tac_tipo_activofijo','tac_nombre',array('tac_id' => $tipo_activo)).'<br>';
                }

        if ($costo_x !== null) {
           $where['act_id_cec'] = $this->input->post('slcCosto');
           $filtros_titulo      .= 'Centro costo: '.$this->gsatelite->get_campo('cec_centro_costo','cec_nombre',array('cec_id' => $this->input->post('slcCosto'))).'<br>';
      } 

        $resultados=$this->activo_fijo->lista_adquisicion($fecha1,$fecha2, $where);

        if($tipo_rep == 1){    
        $this->load->library('pdf');
        $html  = $this->load->view('reporte/header', array('titulo' => 'Activos por fecha de adquisición'), true);
        $html .= $this->load->view('activo/reportes/print_adq', array('activo' => $resultados), true);
        $reporte=$this->pdf->reportePDF2($html,null,'L','I');
        }else if($tipo_rep == 2){
             //Nombre del archivo 
            $filename = 'rpt_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);

            $data['table_header'] = "Reporte de activos por fecha de adquisición";
            $data['filename']     = $filename;
            $data['activo']       = $resultados;
            
            if($fecha1 == $fecha2){
                $data['fecha1']       = $fecha1;
                $data['fecha_igual']  = true;               
            }else{
                $data['fecha1']       = $fecha1;
                $data['fecha2']       = $fecha2;    
                $data['fecha_igual']  = false;
            }
            
            $data_header = array(
                'titulo' => 'Reporte de fechas de adquisición'.$filtros_titulo,
                "solotitulo"=>1,
                "columnas"=>7
                );
            //$data['filtros'] = $filtros_titulo;
            $heaader  = $this->load->view('reporte/header', $data_header, true);
            $html .= $this->load->view('activo/reportes/print_adq_excel.php', $data);
            $html = str_replace(
                array('<table border="0.5"','border="0">'), 
                array('<table border="1"','border="1">'), 
                $html);
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header("Content-Disposition: attachment;filename=fechas_adquisicion".date('d-m-Y_His').".xls"); 
            header("Pragma: no-cache");
            header("Expires: 0");
            echo '<meta charset="utf-8" />';
            // echo "<table border='0'>
            //   <tr><th colspan='".$colspan."' align='center' >".mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'),'UTF-8')."</th></tr>";
            // echo "<tr><th colspan='".$colspan."' align='center' >Documentos con fecha de vencimiento</th></tr>";
            // echo ($doct_titulo != '')? "<tr><th colspan='".$colspan."' align='center' > $doct_titulo </th></tr>":'';
            // echo "</table>";
            echo $heaader.$html;
        }
    }

    public function empleado_area(){
        satelite_validar();
        $restringe = false;
        $rol_restringir = $this->gsatelite->get_parametro_emp('ROL_CONSULTA_SUCURSAL_AF', 0);
                $this->db->join("uxr_usuarioxrol", "uxr_id_usu = id");
        $rolu = $this->gsatelite->get_tabla("users", array("id" => $this->tank_auth->get_user_id()));
                $this->db->join("usc_usuario_sucursal", "usc_id_usu = id");
        $sucu = $this->gsatelite->get_tabla("users", array("id" => $this->tank_auth->get_user_id(), "usc_estado" => 1));
        $sucursales = array_column($sucu, "usc_id_suc");
        foreach ($rolu as $k => $val) {
            if ($val['uxr_id_rol'] == $rol_restringir) {
                $restringe = true;
            }            
        }
        if($_POST){
            $fecha_ini  = ($this->input->post('fecha_ini')) ? $this->input->post('fecha_ini') : null;
            $fecha_fin  = ($this->input->post('fecha_fin')) ? $this->input->post('fecha_fin') : null;
            $activo     = (trim($this->input->post('activo')) != "")?trim($this->input->post('activo')):null;
            $responsable= (trim($this->input->post('responsable')) != "")?trim($this->input->post('responsable')):null;
            $sucursal   = (trim($this->input->post('sucursal')) != "")?trim($this->input->post('sucursal')):null;
            $area       = (trim($this->input->post('area')) != "")?trim($this->input->post('area')):null;
            $grupo      = ($this->input->post('grupo') > 0) ? $this->input->post('grupo') : null;
            $tipo_activo       = (trim($this->input->post('tipo_activo')) != "")?trim($this->input->post('tipo_activo')):null;
            $costo_x = ( $this->input->post('slcCosto') != "") ? $this->input->post('slcCosto') : null;

            $where = array();
            $where['act_estado'] = 1;
            $where['axe_estado'] = 1;
            if ($grupo) {
                $where['act_id_grp'] = $grupo;
            }
            if ($costo_x !== null) {
                $where['act_id_cec'] = $this->input->post('slcCosto');
            } 
            if ($fecha_ini) {
                $where['axe_fecha >='] = date('Y-m-d', strtotime($fecha_ini));
            }
            if ($fecha_fin) {
                $where['axe_fecha <='] = date('Y-m-d H:i:s', strtotime($fecha_fin." 23:59:59"));
            }
            if($area != null){
                $where['axe_id_are'] = $area;
            }
            if($sucursal != null){
                $where['suc_id']     = $sucursal;
            }elseif ($sucursal == null && $restringe && count($sucu) > 0) {
                $sucursalesVer = implode(',', $sucursales);
                $where["suc_id IN ($sucursalesVer)"] = NULL ;
            }
            if($responsable != null){
                $where['emp_id']     = $responsable;
            }
            if($activo != null){
                $where['act_id']     = $activo;
            }
            if($tipo_activo != null) {
                $where['act_id_tac'] = $tipo_activo;
            }
            $orderby = 'emp_id'; // Ordernar por responsable
            //return 0;
            $activos = $this->activo_fijo->get_activo_empleado($where, $orderby);
            // var_dump($this->db->last_query());die();
            $data['activos'] = $activos; 
            $arreglo = array('lista'=>$this->load->view('activo/reportes/consultar_empleado_area', $data, true));
            echo json_encode($arreglo);            
        } else{
            $data['restringe_suc'] = ($restringe)?1:0;
            $data['suc_restringir'] = implode(',', $sucursales);
            // var_dump($data);die();
            $data['titulo_personal'] = "Listado de asignación de activos";
            if ($restringe && count($sucu) > 0) {
                $this->db->where_in('are_id_suc', $sucursales);
            }
            $data['areas']   = $this->activo_fijo->get_areas();
            if ($restringe && count($sucu) > 0) {
                $this->db->where_in('emp_id_suc', $sucursales);
            }
            $personal_reg    = $this->gsatelite->get_dropdown('emp_empleado', '{emp_codigo} - {emp_nombre} {emp_apellido}', '', null, null, null, 'emp_id', true);
            $data['empleado']=  str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $personal_reg);

            if ($restringe && count($sucu) > 0) {
                $this->db->where_in('suc_id', $sucursales);
            }
            $sucursal_reg    = $this->gsatelite->get_dropdown('suc_sucursal', '{suc_nombre}', '', null, null, null, 'suc_id', true);
            $data['sucursal']=  str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $sucursal_reg);

            $activo_reg      = $this->gsatelite->get_dropdown('act_activo_fijo', '{act_codigo} - {act_nombre}', '', null, null, null, 'act_id', true);
            $data['activo']  =  str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $activo_reg);

            $tipo_activo = $this->gsatelite->get_dropdown('tac_tipo_activofijo', '{tac_codigo} - {tac_nombre}', '', array('tac_estado'=>1), null, null, 'tac_id', true);
            $data['tipo_activo'] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $tipo_activo);
            $grupo_activ = $this->gsatelite->get_dropdown('grp_grupo', '{grp_codigo} - {grp_nombre}', '', null, null, null, 'grp_id', true);
            $data['grp_act'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $grupo_activ);

            $data['centro_costo'] =str_replace('<option value="0">Seleccione</option>', '',$this->gsatelite->get_dropdown('cec_centro_costo', ' {cec_nombre}', '', array('cec_estado' => 1), null, '', 'cec_id', true));

            $this->_cargarvista($data);
        }
    }

    public function reporte_empleado_area(){
        satelite_validar();
        $grupo      = ($this->input->post('grupo') > 0) ? $this->input->post('grupo') : null;
        $fecha_ini  = ($this->input->post('txtFechaIni')) ? $this->input->post('txtFechaIni') : null;
        $fecha_fin  = ($this->input->post('txtFechaFin')) ? $this->input->post('txtFechaFin') : null;

        $activo     = (trim($this->input->post('activo')) != "")?trim($this->input->post('activo')):null;
        $responsable= (trim($this->input->post('responsable')) != "")?trim($this->input->post('responsable')):null;
        $sucursal   = (trim($this->input->post('sucursal')) != "")?trim($this->input->post('sucursal')):null;
        $area       = (trim($this->input->post('area')) != "")?trim($this->input->post('area')):null;
        $tipo_activo       = (trim($this->input->post('slcTipoActivo')) != "")?trim($this->input->post('slcTipoActivo')):null;
        $tipo = trim($this->input->post("tipo"));
        $where = array();
        $costo_x = ( $this->input->post('slcCosto') != "") ? $this->input->post('slcCosto') : null;        
        $filtros_titulo = '<br>';
        $where['act_estado'] = 1;
        $where['axe_estado'] = 1;
        if ($costo_x !== null) {
            $where['act_id_cec'] = $this->input->post('slcCosto');
            $filtros_titulo     .= '<b>Centro de costo: </b>'.$this->gsatelite->get_campo('cec_centro_costo','cec_nombre',array('cec_id' => $this->input->post('slcCosto'))).'<br>'; 
        }
        $where['axe_estado'] = 1;
        if ($grupo) {
            $where['act_id_grp'] = $grupo;
        }
        $fecha1 = '';
        if ($fecha_ini) {
            $where['axe_fecha >='] = date('Y-m-d', strtotime($fecha_ini));
            $fecha1 .= '<b>Desde: </b>'.date_format(date_create($fecha_ini),'d-m-Y').'<br>';
        }
        if ($fecha_fin) {
            $where['axe_fecha <='] = date('Y-m-d H:i:s', strtotime($fecha_fin." 23:59:59"));
            $fecha1 .= '<b>Hasta: </b>'.date_format(date_create($fecha_fin),'d-m-y').'<br>';
        }
        $filtros_titulo .= $fecha1;
        if($area != null){
            $where['axe_id_are'] = $area;
            $filtros_titulo     .= '<b>area: </b>'.$this->gsatelite->get_campo('are_area','are_nombre',array('are_id' => $area)).'<br>'; 
        }
        if($sucursal != null){
            $where['suc_id']     =  $sucursal;
            $filtros_titulo     .= '<b>sucursal: </b>'.$this->gsatelite->get_campo('suc_sucursal','suc_nombre',array('suc_id' => $sucursal)).'<br>'; 
        }
        if($responsable != null){
            $where['emp_id']     = $responsable;
            $filtros_titulo     .= '<b>responsable: </b>'.$this->gsatelite->get_campo('emp_empleado','emp_nombre',array('emp_id' => $responsable)).'<br>'; 
        }
        if($activo != null){
            $where['act_id']     = $activo;
            $filtros_titulo     .= '<b>activo: </b>'.$this->gsatelite->get_campo('act_activo_fijo','act_nombre',array('act_id' => $activo)).'<br>'; 
        }
        if($tipo_activo != null) {
            $where['act_id_tac'] = $tipo_activo;
            $filtros_titulo     .= '<b>tipo activo: </b>'.$this->gsatelite->get_campo('tac_tipo_activofijo','tac_nombre',array('tac_id' => $tipo_activo)).'<br>'; 
        }
        $orderby = 'emp_id'; // Ordernar por responsable
        $resultados = $this->activo_fijo->get_activo_empleado($where, $orderby);
        
        if($tipo=="2"){     
            $this->load->library('pdf');
            $html  = $this->load->view('reporte/header', array('titulo' => 'Asignación de Activos'), true);
            $html .= $this->load->view('activo/reportes/print_empleado_area', array('activo' => $resultados), true);
            $reporte=$this->pdf->reportePDF2($html);
        }
        else
        {
            $filename = 'rpt_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);

            $data['table_header'] = "Reporte por asignación";
            $data['filename']     = $filename;
            $data['activo']       = $resultados;
            

            $data_header = array(
                'titulo' => 'Reporte por asignación'.$filtros_titulo,
                "solotitulo"=>1,
                "columnas"=> 5
                );
            //$data['filtros'] = $filtros_titulo;
            $heaader  = $this->load->view('reporte/header', $data_header, true);
            $html     = $this->load->view('activo/reportes/print_empleado_area_excel.php', $data);
            $html = str_replace(
                array('<table border="0.5"','border="0">'), 
                array('<table border="1"','border="1">'), 
                $html);
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header("Content-Disposition: attachment;filename=por_asignacion".date('d-m-Y_His').".xls"); 
            header("Pragma: no-cache");
            header("Expires: 0");
            echo '<meta charset="utf-8" />';
            echo $heaader.$html;
        }

    }
    // Se comenta ya que es una funcionalidad igual al del reporte tipo activo
    /*
    public function clasificacion_grupos_reporte()
    {
        $data['clasificaciones']=$this->db->get('tac_tipo_activofijo')->result_array();
        $data['titulo_personal']="Reportes de clasificación y grupos de activos";
        //Departamento y tipo como filtro de busqueda (Carlos Alberto Noyola 21-03-2019)
        $departamento = $this->gsatelite->get_dropdown('are_area',
         '{are_nombre}', '', array('are_estado' => 1), null, '', 'are_id', true);
        $data['departamento'] = str_replace('<option value="0">Seleccione</option>',
         '<option value=""></option>', $departamento);
        $data['centro_costo'] =str_replace('<option value="0">Seleccione</option>', '',$this->gsatelite->get_dropdown('cec_centro_costo', ' {cec_nombre}', '', array('cec_estado' => 1), null, '', 'cec_id', true));
        $this->_cargarvista($data);
    }*/
    /*
    public function reporte_clasificacion()
    {

        //Departamento y tipo como filtro de busqueda (Carlos Alberto Noyola 21-03-2019)
        //$clasificacion=$this->input->post('clasificacion');
        //$grupo=$this->input->post('grupo');
        //$departamento=$this->input->post('departamento');

        $clasificacion = ( $this->input->post('clasificacion') != "") ? $this->input->post('clasificacion') : null;
        $grupo = ( $this->input->post('grupo') != "") ? $this->input->post('grupo') : null;
        $departamento = ( $this->input->post('departamento') != "") ? $this->input->post('departamento') : null;
        $estado = ($this->input->post('estado') !== '')?$this->input->post('estado'):1;
        //echo "string".$clasificacion."string".$grupo."string".$departamento."string";
        //return 0;
       // print_r($estado);die();
        $costo_x = ( $this->input->post('slcCosto') != "") ? $this->input->post('slcCosto') : null;

        $activoxclasificacion=$this->activo_fijo->get_activosxclasificacion($clasificacion, $grupo ,$departamento,$estado,$costo_x);
      //  print_r($this->db->last_query());die();
        $cadena="";
        foreach ($activoxclasificacion as $key => $value) {
            $cadena.="<tr><td>".$value['codigo']."</td>";
            $cadena.="<td>".$value['nombre']."</td>";
            $cadena.="<td>".$value['depreciacion_acumulada']."</td>";
            $cadena.="<td>".$value['depreciacion_mes']."</td>";
            $cadena.="</tr>";
        }
        $arreglo=array('drop'=>$cadena);
        echo json_encode($arreglo);
    }

    public function print_reporte_clasificacion()
    {

        //$clasificacion=$_POST['clasificacion'];
        //$grupo=$_POST['grupo'];
        $clasificacion = ( $this->input->post('clasificacion') != "") ? $this->input->post('clasificacion') : null;
        $grupo = ( $this->input->post('grupo') != "") ? $this->input->post('grupo') : null;
        $departamento = ( $this->input->post('slcDepartamento') != "") ? $this->input->post('slcDepartamento') : null;

        $estado = ($this->input->post('slcEstados') !== '')?$this->input->post('slcEstados'):1;
        //($grupo==0) ? $grupo="" : $grupo=$grupo;
        $costo_x = ( $this->input->post('slcCosto') != "") ? $this->input->post('slcCosto') : null;
        $activos=$this->activo_fijo->get_activosxclasificacion($clasificacion, $grupo ,$departamento,$estado,$costo_x);


        $tipo=$this->input->post('tipo');

        $data['clasificaciones']=$this->gsatelite->get_registro('tac_tipo_activofijo','tac_id',$clasificacion);
        $data['grupos']=$this->gsatelite->get_registro('grp_grupo','grp_id', $grupo);
        $data['departamentos']=$this->gsatelite->get_registro('are_area','are_id', $departamento);


        if($tipo==1){
            $this->load->library('pdf');
            $html  = $this->load->view('reporte/header', array('titulo' => 'Reporte de activos por clasificación'), true);
            $html .= $this->load->view('activo/reportes/print_reporte_clasificacion', array('activoxclasificacion'=>$activos , 'clasificaciones'=>$data['clasificaciones'] , 'grupos' => $data['grupos'], 'departamentos' => $data['departamentos']), true);
            
            $reporte=$this->pdf->reportePDF2($html,null,'lanscape','I');
        }else if($tipo==2){
             $filename = 'rpt_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);

            $data['table_header'] = "Reporte de clasificación y grupos de activos";
            $data['filename']     = $filename;
            $data['activoxclasificacion'] = $activos;
            $this->load->view('activo/reportes/print_reporte_clasificacion_excel.php', $data);
        }
        
    }*/



    /*********************** MOSTRAR INVENTARIO ***************************/

    public function index(){
        $data['ubicaciones'] =  $this->consultas->cargar_todo('are_area');
        $data['titulo_personal']="Generar inventario";
        $tipo_activo = $this->gsatelite->get_dropdown('tac_tipo_activofijo', '{tac_codigo} - {tac_nombre}', '', array('tac_estado'=>1), null, null, 'tac_id', true);
        $data['tipo_activo'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $tipo_activo);
        $data['centro_costo'] =str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $this->gsatelite->get_dropdown('cec_centro_costo', ' {cec_nombre}', '', array('cec_estado' => 1), null, '', 'cec_id', true));
        $this->_cargarvista(null,$data);       
    }

    public function inventariosxarea(){

        $area=$this->input->post('area');
        $tipo_activo=($this->input->post('tipo_activo')>0)?$this->input->post('tipo_activo'):null;
        $fecha_inventario=$this->activo_fijo->inventarioxfecha($area, $tipo_activo);
        $cadena='<option value=""></option>';
        foreach ($fecha_inventario as $key => $value) {
            $cadena.="<option value='".$value['inf_id']."'>".$value['inf_id']." | ".$value['inf_fecha']."</option>";
        }
        echo json_encode(array("option"=>$cadena));
    }

    public function obtener_inventario()
    {

        $costo_x = ( $this->input->post('slcCosto') != "") ? $this->input->post('slcCosto') : null;
        $inf_id=$this->input->post('inf_id');
        $where = array();
        if ($costo_x !== null) {
            $where['act_id_cec'] = $costo_x;
        }
        
        $datos=$this->activo_fijo->recuperar_inventario($inf_id,$where );
        $cadena="<tr><td colspan=4><b>Activos con asignación vigente</b></td>";
        $cadena.="<td></td></tr>";
        foreach ($datos['existe_con_ubicacion'] as $key => $value) {
        $cadena.="<tr><td>".$value['act_id']."</td>";
        $cadena.="<td>".$value['act_codigo']."</td>";
        $cadena.="<td>".$value['act_nombre']."</td>";
        $cadena.="<td>".$value['tac_nombre']."</td>";
        $cadena.="<td>".$value['are_nombre']." - ".$value['emp_nombre']." ".$value['emp_apellido']."</td></tr>";
        }
        $cadena.="<tr><td colspan=4><b>Activos sin asignación</b></td>";

        $cadena.="<td></td></tr>";
        foreach ($datos['existe_sin_ubicacion'] as $key => $value) {
        $cadena.="<tr><td>".$value['act_id']."</td>";
        $cadena.="<td>".$value['act_codigo']."</td>";
        $cadena.="<td>".$value['act_nombre']."</td>";
        $cadena.="<td>".$value['tac_nombre']."</td>";
        $cadena.="<td>No asignado</td></tr>";
        }
        $cadena.="<tr><td colspan=4><b>Activos no registrados</b></td>";
        $cadena.="<td></td></tr>";
        foreach ($datos['solo_codigo'] as $key) {
        $cadena.="<tr><td></td>";
        $cadena.="<td>".$key."</td>";
        $cadena.="<td></td>";
        $cadena.="<td></td>";
        $cadena.="<td></td></tr>";
        }

        $arreglo=array(
            'resultado'=>$cadena);
        echo json_encode($arreglo);
    }

    public function reporte_inventario_fisico()
    {
        $inf_id=$_POST['fecha_inf'];
        //$inf_id=$this->input->post('inf_id');
        $filtros_titulo = '<br>';
        $where = array();
        $costo_x = ( $this->input->post('slcCosto') != "") ? $this->input->post('slcCosto') : null;
        
        if ($costo_x !== null) {
          $where['act_id_cec'] = $costo_x;
          $filtros_titulo .= '<b>Centro de costo: </b> '.$this->gsatelite->get_campo('cec_centro_costo','cec_nombre',array('cec_id' => $costo_x)).'<br>';
        } 

         if ($this->input->post('ubicacion_get') != '') {
          $filtros_titulo .= '<b>Departamento: </b> '.$this->gsatelite->get_campo('are_area','are_nombre',array('are_id' => $this->input->post('ubicacion_get'))).'<br>';
        } 

        $datos=$this->activo_fijo->recuperar_inventario($inf_id,$where);
        $data['con_asignacion']=$datos['existe_con_ubicacion'];
        $data['sin_asignacion']=$datos['existe_sin_ubicacion'];
        $data['solo_codigo']=$datos['solo_codigo'];
        $this->load->library('PDF');
        $html  = $this->load->view('reporte/header', array('titulo' => 'Reporte inventario Físico'.$filtros_titulo.'',"solotitulo"=>1), true);
        $html .= $this->load->view('activo/reportes/generar_pdf',$data,true);
        $reporte= $this->pdf->makePdf($html, 'L', 'activo_cuenta_contable', 'Letter');
    }

    /**********************************************************************/

    public function depreciacion_detalle() {
        //Verificar Permisos de acceso
        satelite_validar();
        if($_POST){
            $tipo_activo=($this->input->post('tipo_activo')>0)?$this->input->post('tipo_activo'):null;
            $grupo=($this->input->post('grupo')>0)?$this->input->post('grupo'):null;
            $act_activo = ( $this->input->post('act_activo') > 0 ) ? $this->input->post('act_activo') : null;
            $activo = ( trim($this->input->post('codigo')) != '') ? $this->input->post('codigo'): $act_activo;
            $departamento = ( $this->input->post('slcDepartamento') != "") ? $this->input->post('slcDepartamento') : '';
            if ($departamento != null ) {
                $where['act_id_are'] = $departamento;
            }
            $costo_x = ( $this->input->post('slcCosto') != "") ? $this->input->post('slcCosto') : null;            
            if ($costo_x !== null) {
                $where['act_id_cec'] = $this->input->post('slcCosto');
            }
            $data['act_opciones'] = $this->activo_fijo->get_listado_depreciacion($activo,null, $tipo_activo, $grupo, $departamento,null,null,null,null,$costo_x);
            $html = $this->load->view('activo/reportes/rpt_detalle_depreciacion', $data, true);
            echo $html;
        }else{
            $tipo_activo = $this->gsatelite->get_dropdown('tac_tipo_activofijo', '{tac_codigo} - {tac_nombre}', '', array('tac_estado'=>1), null, null, 'tac_id', true);
            $data['tipo_activo'] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $tipo_activo);
            $grupos = $this->gsatelite->get_dropdown('grp_grupo', '{grp_nombre}', '', null, null, null, 'grp_id', true);
            $data['grupos'] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $grupos);
            
            $activo = $this->gsatelite->get_dropdown('act_activo_fijo', '{act_codigo}', '', array('act_estado'=>1), null, null, 'act_id', true);
            $data['activos'] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $activo);

            $departamento = $this->gsatelite->get_dropdown('are_area',
             '{are_nombre}', '', array('are_estado' => 1), null, '', 'are_id', true);
            $data['departamento'] = str_replace('<option value="0">Seleccione</option>',
             '<option value=""></option>', $departamento);
            $data['centro_costo'] =str_replace('<option value="0">Seleccione</option>', '',$this->gsatelite->get_dropdown('cec_centro_costo', ' {cec_nombre}', '', array('cec_estado' => 1), null, '', 'cec_id', true));

            $data['titulo_personal'] = "Depreciación a detalle por activo fijo";
            $this->_cargarvista( null, $data );     
        }     
    }

    public function imprimir_detalles($act_id, $es_excel=0){
        //Verificar Permisos de acceso
        satelite_validar();
        //print_r($_POST);die();
        $this->load->library('EnLetras');
        $id_activo = $act_id;
        //Verificar acceso unicamente a traves de url
        if ( $id_activo === false || $id_activo == "" || !is_numeric( $id_activo ) ){
            redirect( base_url('activo/nuevo/index_depreciacion') );
        }
        $data['act_id'] = $id_activo;
        $data['info_act'] = $this->activo_fijo->get_info_total_activo(array('act_id'=> $id_activo));
        //echo $this->db->last_query(); die();
        $data['act_detalles'] = $this->activo_fijo->get_detalles_activo_completo( $id_activo )->row();
          
        $data['caracteristicas2'] = $this->activo_fijo->get_caracteristicaxactivo($id_activo); 
        // $data['act_depreciacion'] = $depreciacion =$this->activo_fijo->get_depreciacion_acumulada( $id_activo );
        $data['act_depreciacion'] = $this->activo_fijo->get_depreciacion_acumulada_historico($id_activo);

        $data["es_excel"] = $es_excel;
        
        if ($es_excel) {
            $data_header = array(
                'titulo' => 'Tarjeta Individual de Activo Fijo',
                "solotitulo"=>1,
                "columnas"=>7
                );
            $html  = $this->load->view('reporte/header', $data_header, true);
            $html .= $this->load->view('activo/reportes/imprimir_detalles', $data, true);
            $html = str_replace(
                array('<table border="0.5"','border="0">'), 
                array('<table border="1"','border="1">'), 
                $html);
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header("Content-Disposition: attachment;filename=detalle_deprecicion_activo".date('d-m-Y_His').".xls"); 
            header("Pragma: no-cache");
            header("Expires: 0");
            echo '<meta charset="utf-8" />';
            // echo "<table border='0'>
            //   <tr><th colspan='".$colspan."' align='center' >".mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'),'UTF-8')."</th></tr>";
            // echo "<tr><th colspan='".$colspan."' align='center' >Documentos con fecha de vencimiento</th></tr>";
            // echo ($doct_titulo != '')? "<tr><th colspan='".$colspan."' align='center' > $doct_titulo </th></tr>":'';
            // echo "</table>";
            echo $html;
            die();
        }
          
        $this->load->library('pdf');
        $html  = $this->load->view('reporte/header', array('titulo' => 'Tarjeta Individual de Activo Fijo',"solotitulo"=>1), true);
        $html .= $this->load->view('activo/reportes/imprimir_detalles', $data, true);            
        $reporte=$this->pdf->makePDF($html);
            
        $this->_cargarvista( null, $data );          
    }

    public function imprimir_det_anual($act_id, $es_excel=0){
        satelite_validar();
        $this->load->library('EnLetras');
        $id_activo = $act_id;
        if ( $id_activo === false || $id_activo == "" || !is_numeric( $id_activo ) ){
            redirect( base_url('activo/nuevo/index_depreciacion') );
        }
        $data['act_id'] = $id_activo;
        $data['info_act'] = $this->activo_fijo->get_info_total_activo(array('act_id'=> $id_activo));
        // echo $this->db->last_query(); die();
        $data['act_detalles'] = $this->activo_fijo->get_detalles_activo_completo( $id_activo )->row();          
        $data['caracteristicas2'] = $this->activo_fijo->get_caracteristicaxactivo($id_activo); 
        // $data['act_depreciacion'] = $depreciacion =$this->activo_fijo->get_depreciacion_acumulada( $id_activo );
        $data['act_depreciacion'] = $this->activo_fijo->get_depreciacion_acumulada_historico_anual($id_activo);
        $data["es_excel"] = $es_excel;        
        if ($es_excel) {
            $data_header = array(
                'titulo' => 'Tarjeta Individual de Activo Fijo',
                "solotitulo"=>1,
                "columnas"=>7
                );
            $html  = $this->load->view('reporte/header', $data_header, true);
            $html .= $this->load->view('activo/reportes/imprimir_detalles_anuales', $data, true);
            $html = str_replace(
                array('<table border="0.5"','border="0">'), 
                array('<table border="1"','border="1">'), 
                $html);
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header("Content-Disposition: attachment;filename=detalle_deprecicion_activo".date('d-m-Y_His').".xls"); 
            header("Pragma: no-cache");
            header("Expires: 0");
            echo '<meta charset="utf-8" />';
            echo $html;
            die();
        }          
        $this->load->library('pdf');
        $html  = $this->load->view('reporte/header', array('titulo' => 'Tarjeta Individual de Activo Fijo',"solotitulo"=>1), true);
        $html .= $this->load->view('activo/reportes/imprimir_detalles_anuales', $data, true);            
        $reporte=$this->pdf->makePDF($html);            
        $this->_cargarvista( null, $data );          
    }


    function _cargarvista($data=0,$crud=0,$vista=null)
    {   
        $this->load->view('vacia',$crud);   
        if($data!=0)
            $data=array_merge($data,$this->masterpage->getUsuario());
        else
            $data=$this->masterpage->getUsuario();
        if($vista==null)
            $vista=$data['modulo'].'/'.$data['control'].'/'.$data['funcion'];
        $this->masterpage->setMasterPage('masterpage_default');
        $this->masterpage->addContentPage($vista, 'content',$data);
        $this->masterpage->show();
    }

    public function codigo_activo(){
        satelite_validar();
        $data['titulo_personal'] = "Códigos de activo";
        $data['area'] = $this->gsatelite->get_dropdown('are_area','{are_prefijo} {are_nombre}','',array('are_estado'=>1),null,null,null,true);
        $data['grupo'] = $this->gsatelite->get_dropdown('grp_grupo','{grp_codigo} {grp_nombre}','',null,null,null,null,true);
        $tipo_activo = $this->gsatelite->get_dropdown('tac_tipo_activofijo','{tac_codigo} - {tac_nombre}', '', array('tac_estado'=>1), null, null, 'tac_id', true);
        $data['tipo_activo'] = str_replace('<option value="0">Seleccione</option>','<option value=""></option>', $tipo_activo);
        $data['centro_costo'] =str_replace('<option value="0">Seleccione</option>', '',$this->gsatelite->get_dropdown('cec_centro_costo', ' {cec_nombre}', '', array('cec_estado' => 1), null, '', 'cec_id', true));

        $this->_cargarvista($data);
    }

    // $flag 1 = Indica si el reporte es una consulta Ajax 2 = Impresión
    // $flag 1 = Indica si el reporte es una consulta Ajax 2 = Impresión
    public function reporte_codigo_activo($flag = null){
        if($_POST){
            $post_array = $this->input->post();
            ini_set('memory_limit', '1024M');
            if($flag){
                $fecha_ini = ($post_array['fecha_ini'] != '') ? date('Y-m-d', strtotime($post_array['fecha_ini'])) : null;
                $fecha_fin = ($post_array['fecha_fin'] != '') ? date('Y-m-d', strtotime($post_array['fecha_fin'])) : null;
                $area = ($post_array['area'] != '') ? $post_array['area'] : null;
                $grupo = ($post_array['grupo'] != '') ? $post_array['grupo'] : null;
                $tipo_activo = ($post_array['tipo_activo'] != '') ? $post_array['tipo_activo'] : null;
                $costo_x = ( $this->input->post('slcCosto') != "") ? $this->input->post('slcCosto') : null;
            }else{
                /*
                 * Los valores de filtro vienen concatenados junto a tu texto i.e. Estado = "1#Creado"
                 * Se separan los filtros
                 */
                $grupo_split = ($post_array['filtro_grupo'] != '') ? explode("#",$post_array['filtro_grupo']) : null;
                $area_split = ($post_array['filtro_area'] != '') ? explode("#",$post_array['filtro_area']) : null;

                $tipo_activo_split = ($post_array['filtro_tipo_activo'] != '') ? explode("#",$post_array['filtro_tipo_activo']) : null;
                //Se asignan los valores de filtro 
                $grupo = $grupo_split[0];
                $data['nombreGrupo'] = $grupo_split[1];                
                $area = $area_split[0];
                $data['nombreArea'] = $area_split[1];
                $tipo_activo = $tipo_activo_split[0];
                $data['nombreTipo'] = $tipo_activo_split[1];
                //Las fechas son las unicas que no se concatenan
                $fecha_ini = ($post_array['filtro_inicio'] != '') ? date('Y-m-d', strtotime($post_array['filtro_inicio'])) : null;
                $fecha_fin = ($post_array['filtro_fin'] != '') ? date('Y-m-d', strtotime($post_array['filtro_fin'])) : null;
                $costo_x2 = ( $this->input->post('slcCosto2') != '') ? $this->formato_fecha($this->input->post('slcCosto2')) : null;
            }
            //Tipo de Reportes si sera Excel o Pdf
            $tipo_reporte = $this->input->post('tipo_reporte');
            $where = null;           
            //Se crean las condicionales del reporte
            if($fecha_ini != '' && $fecha_fin != '') {
                
                
            }
            if ($fecha_ini) {
                $where['DATE(act_fecha_adq) >='] = $fecha_ini;
                $data['fecha_inicio'] = $fecha_ini;
            }
            if ($fecha_fin) {
                $where['DATE(act_fecha_adq) <='] = $fecha_fin;
                
                $data['fecha_fin'] = $fecha_fin;
            }
            if(isset($costo_x) && $costo_x !== null) {
                $where['act_id_cec'] = $this->input->post('slcCosto');
            } 
            if(isset($costo_x2) && $costo_x2 !== null) {
                $where['act_id_cec'] = $this->input->post('slcCosto2');
            } 
            if ($grupo) {$where['act_id_grp'] = $grupo;}
            if ($area) {$where['act_id_are'] = $area;}
            if ($tipo_activo) {$where['act_id_tac'] = $tipo_activo;}

            //si existe el id directo resetear el where
            if($post_array['id_activo'] > 0 || substr_count(trim($post_array['id_activo']), ',') > 0) {
                $where = array("act_id IN (".$post_array['id_activo'].")"=>null);
            }    
            $where['act_estado'] = 1;
            $data['reporte'] = $this->activo_fijo->get_reporte_codigo_activo($where);
            // print_r($this->db->last_query());die();
            $data['tipo_reporte'] = $tipo_reporte;            
            $filename = 'rpt_codigo_activo_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

            $data['filename'] = $filename;
            $formato_print = (trim($this->input->post('filtro_formato')) > 0 ) ? $this->input->post('filtro_formato'):1;
            // print_r($formato_print);die();
            // print_r($data); die();            
               
            switch ($formato_print) {
                case 1:
                    $html =  $this->load->view('activo/reportes/reporte_codigo_activo', $data, true);
                    break;                
                case 2:
                     $html = $this->load->view('activo/reportes/reporte_codigo_activo2', $data, true);
                    break;
                case 3:
                case 4:
                    $html = $this->load->view('activo/reportes/reporte_codigo_activo2', $data, true);
                    break;
            }
            if ($flag) {
                echo $html;
            } else {
                if ($tipo_reporte == 'pdf') {
                    ini_set( 'memory_limit', '2048M' );
                    ini_set('max_execution_time', '9999');
                    //die(print_r($formato_print));
                    if ($formato_print == 2) //formato 2 es basdo en requerimiento de  sonsonate
                    {
                       // print_r($data); die();
                       // $html = $this->load->view('activo/reportes/imprimir_vinetas_activo_print', $data, true);  
                        //die($html);  
                        $this->pdf->setPrintFooter(false); 
                        $this->pdf->IncludeJS("print(true)");             
                        $this->pdf->makePDF($html);

                    }

                    if ($formato_print == 3 || $formato_print == 4) // formato C
                    {                       
                        $this->pdf->SetMargins(6,10);
                        $this->pdf->AddPage('L', 'Letter', array(
                            'family' => 'pdfahelvetica') , true
                        );
                        $this->pdf->SetFont('pdfahelvetica', '', 8);
                        $this->pdf->writeHTML($html, true, false, false, false, '');
                        $this->pdf->boletaPDF('I');

                    }
                    $data['titulo'] = 'Códigos de Activos';
                    $header = $this->load->view('reporte/header', $data, true);
                    $GLOBALS['nombre_reporte'] = 'codigo_activo_' . date('dmY');
                    $reporte = $header . $html;
                    //echo $reporte; die();
                    //$this->pdf->makePdf($reporte, 'L', 'codigo_activo', 'Letter');
                   
                    $this->pdf->SetMargins(6,10);
                    $this->pdf->AddPage('L', 'Letter', array(
                        'family' => 'pdfahelvetica') , true
                    );
                    $this->pdf->SetFont('pdfahelvetica', '', 8);
                    $this->pdf->writeHTML($reporte, true, false, false, false, '');
                    $this->pdf->boletaPDF('I');
                } elseif ($tipo_reporte == 'excel') {
                    $filename = 'rpt_requisiciones_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
                    $data['titulo'] = 'Código de Activo';
                    $data['filename'] = $filename;
                    if ($formato_print == 2 || $formato_print == 3 ) //formato 2 es basdo en requerimiento de  sonsonate
                    {
                       header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                       header("Content-Disposition: attachment;filename=codigos_activos_".date('d-m-Y_His').".xls"); 
                       header("Pragma: no-cache");
                       header("Expires: 0");
                       echo '<meta charset="utf-8" />'; 
                       $html = str_replace('border="0"', 'border="1"', $html);
                    }
                    echo $html;
                }
            }
        }
    }

    /**
     * @author Nelson Soriano
     * @since  04-06-2019
     * @return PDF para impresion de codigos de activos
    **/

     public function reporte_codigo_activo_orden($flag=null){
        satelite_validar();
        $data['word'] = 0;
        if($_POST){   
            $activos = $this->input->post('vineta_id_');
            $orden   = $this->input->post('orden_x_');
            $tipo    = $this->input->post('tipo_print');
            $c       = $this->input->post('c');
            $tform   = $this->input->post('tfor');
            $datos   = array();
            if ( (is_array($activos)) && (count($activos) >0) ) {
                for ($i=0; $i < count($activos) ; $i++) { 
                   $id    = $activos[$i];
                   $datos[] = array('orden' =>$orden[$i],'data' =>$this->activo_fijo->get_reporte_codigo_activo(array('act_id'=>$id)));

                }
            }
            $divs = array();
            $data['info'] = $datos;
            $data['word'] = 1;
            if ($tform == 4 || $tform == 5) {
                foreach ($datos as $k => $v) {
                    $divs[$v['orden']] = $v['data'][0];
                }
            } else {
                $html = $this->load->view('activo/reportes/reporte_codigo_activo_orden', $data, true);
            }
            ini_set( 'memory_limit', '2048M' );
            ini_set('max_execution_time', '9999');
            switch ($tipo) {
                case 'word':
                    header('Content-type: application/vnd.ms-word');
                    header('Content-Disposition: attachment;Filename=codigos_activos.doc');
                    header("Pragma: no-cache");
                    header("Expires: 0");
                    echo '<html>';
                    echo '<meta http-equiv=\'Content-Type\' content=\'text/html; charset=Windows-1252\'>';
                    echo '<body style="font-family:Arial;" >';
                    echo '<meta charset="utf-8" />';
                    echo '<style type="text/css"> .inicio_contrato {  font-weight: bold;  }  .parrafo {    text-align: justify;  }</style>';
                    echo $html;
                break;
                
                case 'pdf':
                    if ($c != null) {
                        if ($tform != 4 && $tform != 5) {                        
                           $this->pdf->SetMargins(6,10);
                            $this->pdf->AddPage('L', 'Letter', array(
                                'family' => 'pdfahelvetica') , true
                            );
                            $this->pdf->SetFont('pdfahelvetica', '', 8);
                            $this->pdf->writeHTML($html, true, false, false, false, '');
                            $this->pdf->boletaPDF('I');
                        } else {
                            $i = 0;
                            $borde = 0;
                            $this->pdf->setCellPaddings(0,0,0,0);
                            $this->pdf->SetAutoPageBreak(TRUE, 0);
                            $this->pdf->SetMargins(0, 0, 0);
                            if ( $tform > 4 ) {
                                $this->pdf->AddPage('L', array(24, 100), array(
                                    'family' => 'monospace',
                                    'style' => 'B',
                                    'size' => 8
                                ));
                                $this->pdf->SetFont('courier', 'B', 7.5);
                                foreach ($divs as $k => $v) {
                                    $codigo = $v["act_codigo"];
                                    $style = array(
                                        'align' => 'C',
                                        'border' => $borde,
                                        'hpadding' => 'auto',
                                        'vpadding' => 'auto',
                                        'text' => true,
                                        'font' => 'helvetica',
                                        'fontsize' => 7.5,
                                        'stretchtext' => 4
                                    );
                                    $this->pdf->write1DBarcode($codigo, 'C39', '', '', 105, 25, 0.4, $style, 'N');
                                    $this->pdf->setPrintFooter(false);
                                }
                            } else {
                                $this->pdf->AddPage('P', array(120, 182), array(
                                    'family' => 'monospace',
                                    'style' => 'B',
                                    'size' => 8
                                ));
                                $this->pdf->SetFont('courier', 'B', 7.5);
                                while ($i < 3) {
                                    foreach ($divs as $k => $v) {
                                        $unidad = mb_strtoupper($v["suc_nombre"], 'UTF-8') . ' - '. mb_strtoupper($v["are_nombre"], 'UTF-8');
                                        $area_1 = mb_substr($unidad, 0, 58,'UTF-8');
                                        $area_2 = mb_substr($unidad, 58, 58,'UTF-8');
                                        $codigo = $v["act_codigo"];
                                        $desc_1 = mb_substr(mb_strtoupper($v["act_codigo"] . ' - ' . $v["act_nombre"], 'UTF-8'), 0, 58,'UTF-8');
                                        $desc_2 = mb_substr(mb_strtoupper($v["act_codigo"] . ' - ' . $v["act_nombre"], 'UTF-8'),58, 58,'UTF-8');
                                        $logo_png = $this->gsatelite->get_parametro_emp('SYS_LOGO_FACTURA_DET', 'la_libertad_centro');
                                        $c_base = file_exists(base_url() . 'media/imagenes/sistema/' . $logo_png . '.png');
                                        $s_base = file_exists('media/imagenes/sistema/' . $logo_png . '.png');
                                        $base = (!$c_base && $s_base) ? '' : base_url();
                                        $imgn = $base . 'media/imagenes/sistema/' . $logo_png . '.png';
                                        $style = array(
                                            // 'position' => '',
                                            'align' => 'C',
                                            // 'stretch' => true,
                                            // 'fitwidth' => true,
                                            // 'cellfitalign' => '',
                                            'border' => $borde,
                                            'hpadding' => 'auto',
                                            'vpadding' => 'auto',
                                            // 'fgcolor' => array(0,0,0),
                                            // 'bgcolor' => false, //array(255,255,255),
                                            'text' => false,
                                            'font' => 'helvetica',
                                            'fontsize' => 7.5,
                                            'stretchtext' => 4
                                        );
                                        if ($k==3) {
                                            $this->pdf->SetXY(3, 2, true);
                                            $this->pdf->Image($imgn, '', '', 16, 20, 'PNG', '', '', false, 300, '', false, false, 0, false, false, false);
                                            $this->pdf->SetXY(22, 2, true);
                                            $this->pdf->Cell(95, 6, $area_1, $borde, 0, 'L', false, '', 0, false, 'T', 'B');
                                            $this->pdf->SetXY(22, 10, true);
                                            $this->pdf->Cell(95, 6, $desc_1, $borde, 0, 'L', false, '', 0, false, 'T', 'B');
                                            $this->pdf->SetXY(22, 18, true);
                                            $this->pdf->Cell(95, 6, $desc_2, $borde, 0, 'L', false, '', 0, false, 'T', 'B');
                                            $this->pdf->SetXY(2, 26, true);
                                            $this->pdf->write1DBarcode($codigo, 'C128', '', '', 118, 23, 0.5, $style, 'N');
                                        }
                                        if ($k==2) {
                                            $this->pdf->SetXY(3, 66, true);
                                            $this->pdf->Image($imgn, '', '', 16, 20, 'PNG', '', '', false, 300, '', false, false, 0, false, false, false);
                                            $this->pdf->SetXY(22, 66, true);
                                            $this->pdf->Cell(95, 6, $area_1, $borde, 0, 'L', false, '', 0, false, 'T', 'B');
                                            $this->pdf->SetXY(22, 74, true);
                                            $this->pdf->Cell(95, 6, $desc_1, $borde, 0, 'L', false, '', 0, false, 'T', 'B');
                                            $this->pdf->SetXY(22, 82, true);
                                            $this->pdf->Cell(95, 6, $desc_2, $borde, 0, 'L', false, '', 0, false, 'T', 'B');
                                            $this->pdf->SetXY(2, 90, true);
                                            $this->pdf->write1DBarcode($codigo, 'C128', '', '', 118, 23, 0.5, $style, 'N');
                                        }
                                        if ($k==1) {
                                            $this->pdf->SetXY(3, 128, true);
                                            $this->pdf->Image($imgn, '', '', 16, 20, 'PNG', '', '', false, 300, '', false, false, 0, false, false, false);
                                            $this->pdf->SetXY(22, 128, true);
                                            $this->pdf->Cell(95, 6, $area_1, $borde, 0, 'L', false, '', 0, false, 'T', 'B');
                                            $this->pdf->SetXY(22, 136, true);
                                            $this->pdf->Cell(95, 6, $desc_1, $borde, 0, 'L', false, '', 0, false, 'T', 'B');
                                            $this->pdf->SetXY(22, 144, true);
                                            $this->pdf->Cell(95, 6, $desc_2, $borde, 0, 'L', false, '', 0, false, 'T', 'B');
                                            $this->pdf->SetXY(2, 152, true);
                                            $this->pdf->write1DBarcode($codigo, 'C128', '', '', 118, 23, 0.5, $style, 'N');
                                        }
                                        $i++;
                                    }
                                }
                            }
                            $this->pdf->setPrintFooter(false);
                            $this->pdf->boletaPDF('I');
                        }
                        /*
                        while ($i < 6) {
                            foreach ($divs as $k => $v) {
                                $area_1 = "Área: " . mb_substr(mb_strtoupper($v["are_nombre"], 'UTF-8'),0,18,'UTF-8');
                                $area_2 = mb_substr(mb_strtoupper($v["are_nombre"], 'UTF-8'),18,24,'UTF-8');
                                $codigo = "CÓDIGO: " . $v["act_codigo"];
                                $desc_1 = "DESCRIPCIÓN: " . mb_substr(mb_strtoupper($v["act_nombre"], 'UTF-8'),0,21,'UTF-8');
                                $desc_2 = mb_substr(mb_strtoupper($v["act_nombre"], 'UTF-8'),21,34,'UTF-8');
                                $logo_png = $this->gsatelite->get_parametro_emp('SYS_LOGO_FACTURA_DET', 'la_libertad_centro');
                                $c_base = file_exists(base_url() . 'media/imagenes/sistema/' . $logo_png . '.png');
                                $s_base = file_exists('media/imagenes/sistema/' . $logo_png . '.png');
                                $base = (!$c_base && $s_base) ? '' : base_url();
                                $imgn = $base . 'media/imagenes/sistema/' . $logo_png . '.png';
                                if ($k==3) {
                                    $this->pdf->SetXY(1, 86, true);
                                    $this->pdf->Image($imgn, '', '', 16, 16, 'PNG', '', '', false, 300, '', false, false, 0, false, false, false);
                                    $this->pdf->SetXY(17, 86, true);
                                    $this->pdf->Cell(38, 8, $area_1, $borde, 0, 'L', false, '', 0, false, 'T', 'B');
                                    $this->pdf->SetXY(17, 94, true);
                                    $this->pdf->Cell(38, 8, $area_2, $borde, 0, 'L', false, '', 0, false, 'T', 'B');
                                    $this->pdf->SetXY(1, 102, true);
                                    $this->pdf->Cell(54, 8, $codigo, $borde, 0, 'L', false, '', 0, false, 'T', 'B');
                                    $this->pdf->SetXY(1, 110, true);
                                    $this->pdf->Cell(54, 8, $desc_1, $borde, 0, 'L', false, '', 0, false, 'T', 'B');
                                    $this->pdf->SetXY(1, 118, true);
                                    $this->pdf->Cell(54, 8, $desc_2, $borde, 0, 'L', false, '', 0, false, 'T', 'B');
                                }
                                if ($k==4) {
                                    $this->pdf->SetXY(65, 86, true);
                                    $this->pdf->Image($imgn, '', '', 16, 16, 'PNG', '', '', false, 300, '', false, false, 0, false, false, false);
                                    $this->pdf->SetXY(81, 86, true);
                                    $this->pdf->Cell(38, 8, $area_1, $borde, 0, 'L', false, '', 0, false, 'T', 'B');
                                    $this->pdf->SetXY(81, 94, true);
                                    $this->pdf->Cell(38, 8, $area_2, $borde, 0, 'L', false, '', 0, false, 'T', 'B');
                                    $this->pdf->SetXY(65, 102, true);
                                    $this->pdf->Cell(54, 8, $codigo, $borde, 0, 'L', false, '', 0, false, 'T', 'B');
                                    $this->pdf->SetXY(65, 110, true);
                                    $this->pdf->Cell(54, 8, $desc_1, $borde, 0, 'L', false, '', 0, false, 'T', 'B');
                                    $this->pdf->SetXY(65, 118, true);
                                    $this->pdf->Cell(54, 8, $desc_2, $borde, 0, 'L', false, '', 0, false, 'T', 'B');
                                }
                                if ($k==1) {
                                    $this->pdf->SetXY(1, 136, true);
                                    $this->pdf->Image($imgn, '', '', 16, 16, 'PNG', '', '', false, 300, '', false, false, 0, false, false, false);
                                    $this->pdf->SetXY(17, 136, true);
                                    $this->pdf->Cell(38, 8, $area_1, $borde, 0, 'L', false, '', 0, false, 'T', 'B');
                                    $this->pdf->SetXY(17, 144, true);
                                    $this->pdf->Cell(38, 8, $area_2, $borde, 0, 'L', false, '', 0, false, 'T', 'B');
                                    $this->pdf->SetXY(1, 152, true);
                                    $this->pdf->Cell(54, 8, $codigo, $borde, 0, 'L', false, '', 0, false, 'T', 'B');
                                    $this->pdf->SetXY(1, 160, true);
                                    $this->pdf->Cell(54, 8, $desc_1, $borde, 0, 'L', false, '', 0, false, 'T', 'B');
                                    $this->pdf->SetXY(1, 168, true);
                                    $this->pdf->Cell(54, 8, $desc_2, $borde, 0, 'L', false, '', 0, false, 'T', 'B');
                                }
                                if ($k==2) {
                                    $this->pdf->SetXY(65, 136, true);
                                    $this->pdf->Image($imgn, '', '', 16, 16, 'PNG', '', '', false, 300, '', false, false, 0, false, false, false);
                                    $this->pdf->SetXY(81, 136, true);
                                    $this->pdf->Cell(38, 8, $area_1, $borde, 0, 'L', false, '', 0, false, 'T', 'B');
                                    $this->pdf->SetXY(81, 144, true);
                                    $this->pdf->Cell(38, 8, $area_2, $borde, 0, 'L', false, '', 0, false, 'T', 'B');
                                    $this->pdf->SetXY(65, 152, true);
                                    $this->pdf->Cell(54, 8, $codigo, $borde, 0, 'L', false, '', 0, false, 'T', 'B');
                                    $this->pdf->SetXY(65, 160, true);
                                    $this->pdf->Cell(54, 8, $desc_1, $borde, 0, 'L', false, '', 0, false, 'T', 'B');                                        
                                    $this->pdf->SetXY(65, 168, true);
                                    $this->pdf->Cell(54, 8, $desc_2, $borde, 0, 'L', false, '', 0, false, 'T', 'B');                                        
                                }
                                $i++;
                                */
                    }else{
                        $this->pdf->setPrintFooter(false); 
                        $this->pdf->IncludeJS("print(true)");             
                        $this->pdf->makePDF($html);
                        $data['titulo'] = 'Códigos de Activos';
                        $header = $this->load->view('reporte/header', $data, true);
                        $GLOBALS['nombre_reporte'] = 'codigo_activo_' . date('dmY');
                        $reporte = $header . $html;
                        $this->pdf->SetMargins(6,10);
                        $this->pdf->AddPage('L', 'Letter', array(
                            'family' => 'pdfahelvetica') , true);
                        $this->pdf->SetFont('pdfahelvetica', '', 8);
                        $this->pdf->writeHTML($reporte, true, false, false, false, '');
                        $this->pdf->boletaPDF('I');
                    }
                break;
            }
            
        }
    }

     public function activo_cuenta_contable(){
        satelite_validar();
        $data['titulo_personal'] = "Reporte de activos por cuenta contable";
        $data['tipo'] = $this->gsatelite->get_dropdown('tac_tipo_activofijo','{tac_codigo} - {tac_nombre}','',array('tac_estado'=>1),null,null,null,true);
        $data['grupo'] = $this->gsatelite->get_dropdown('grp_grupo','{grp_nombre}','',null,null,null,null,true);
        $departamento = $this->gsatelite->get_dropdown('are_area',
         '{are_nombre}', '', array('are_estado' => 1), null, '', 'are_id', true);
        $data['departamento'] = str_replace('<option value="0">Seleccione</option>',
         '<option value=""></option>', $departamento);

        $data['centro_costo'] =str_replace('<option value="0">Seleccione</option>', '',$this->gsatelite->get_dropdown('cec_centro_costo', ' {cec_nombre}', '', array('cec_estado' => 1), null, '', 'cec_id', true));
        $this->_cargarvista($data);
    }

     // $flag 1 = Indica si el reporte es una consulta Ajax 2 = Impresión
    public function reporte_activo_cuenta_contable($flag=null){
        if($_POST){
            ini_set( 'memory_limit', '1024M' );
            ini_set('max_execution_time', '999'); 
            $post_array = $this->input->post();
            /*
             * Si es consulta ajax se toman los nombres del Jquery
             * De lo contrario, se toman los filtros de impresión
             */
            if($flag){
               // $fecha_ini = ($post_array['fecha_ini'] != '') ? date('Y-m-d', strtotime($post_array['fecha_ini'])) : null;
               // $fecha_fin = ($post_array['fecha_fin'] != '') ? date('Y-m-d', strtotime($post_array['fecha_fin'])) : null;
                $tipo = ($post_array['tipo'] != '') ? $post_array['tipo'] : null;
                $grupo = ($post_array['grupo'] != '') ? $post_array['grupo'] : null;
                $departamento = ($post_array['departamento'] != '') ? $post_array['departamento'] : null;
                $costo_x = ( $this->input->post('slcCosto') != "") ? $this->input->post('slcCosto') : null;
            }else{
                /*
                 * Los valores de filtro vienen concatenados junto a tu texto i.e. Estado = "1#Creado"
                 * Se separan los filtros
                 */
                 $grupo_split = ($post_array['filtro_grupo'] != '') ? explode("#",$post_array['filtro_grupo']) : null;
                 $tipo_split = ($post_array['filtro_tipo'] != '') ? explode("#",$post_array['filtro_tipo']) : null;
                 $departamento_split = ($post_array['filtro_departamento'] != '') ? explode("#",$post_array['filtro_departamento']) : null;
                 $costo_x2 = ( $this->input->post('slcCosto2') != '') ? $this->formato_fecha($this->input->post('slcCosto2')) : null;
                 //print_r($costo_x); die();
                 //$departamento_split = ($post_array['filtro_departamento'] != '') ? $post_array['filtro_departamento'] : null;
                //Se asignan los valores de filtro 
                $grupo = $grupo_split[0];
                $data['nombreGrupo'] = $grupo_split[1];
                
                $tipo = $tipo_split[0];
                $data['nombreTipo'] = $tipo_split[1];

                $departamento = $departamento_split[0];
                $data['nombreDepartamento'] = $departamento_split[1];
                //Las fechas son las unicas que no se concatenan
                //$fecha_ini = ($post_array['filtro_inicio'] != '') ? date('Y-m-d', strtotime($post_array['filtro_inicio'])) : null;
                //$fecha_fin = ($post_array['filtro_fin'] != '') ? date('Y-m-d', strtotime($post_array['filtro_fin'])) : null;
            }
            //Tipo de Reportes si sera Excel o Pdf
            $tipo_reporte = $this->input->post('tipo_reporte');
            
            $where = null;
           
            //Se crean las condicionales del reporte
          /*  if($fecha_ini != '' && $fecha_fin != '') {
                $where['act_fecha_adq >='] = $fecha_ini;
                $where['act_fecha_adq <='] = $fecha_fin;
                $data['fecha_inicio'] = $fecha_ini;
                $data['fecha_fin'] = $fecha_fin;
            }*/
            if ($costo_x !== null) {
              $where['act_id_cec'] = $this->input->post('slcCosto');
             
             } 

             if ($costo_x2 !== null) {
              $where['act_id_cec'] = $this->input->post('slcCosto2');
             } 
            if ($grupo) {$where['act_id_grp'] = $grupo;}
            if ($tipo) {$where['act_id_tac'] = $tipo;}
            if ($departamento) {$where['act_id_are'] = $departamento;}
            
            $data['reporte'] = $this->activo_fijo->get_reporte_activo_cuenta_contable($where);
            //print_r($this->db->last_query());die();
            $data['tipo_reporte'] = $tipo_reporte;
            
            $filename = 'rpt_activo_cuenta_contable_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

            $data['filename'] = $filename;
            
            $html = $this->load->view('activo/reportes/reporte_activo_cuenta_contable', $data, true);
        
            if ($flag) {
                echo $html;
                
            } else {

                if ($tipo_reporte == 'pdf') {

                    $data['titulo'] = 'Activos por cuenta contable';

                    $header = $this->load->view('reporte/header', $data, true);

                    $GLOBALS['nombre_reporte'] = 'activo_cuenta_contable_' . date('dmY');

                    $reporte = $header . $html;

                    //echo $reporte;
                    $this->pdf->makePdf($reporte, 'L', 'activo_cuenta_contable', 'Letter');
                } elseif ($tipo_reporte == 'excel') {

                    $filename = 'rpt_activo_cuenta_contable_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

                    $data['titulo'] = 'Activos por cuenta contable';

                    $data['filename'] = $filename;

                    echo $html;
                }
            }
        }
    }

    /**
    * 
    * @descripcion: Reporte de activos por área   
    * @modified by Elmer Hernandez
    * @fecha: 30/10/2019
    */

    public function rpt_activo_area() {
        satelite_validar();
        if($_POST){
            $data['tipo_reporte']=$tipo_reporte=$this->input->post('tipo_reporte');
            $area=($this->input->post('area')!=0)?$this->input->post('area'):null;
           
           $fecha_ini=($this->input->post('txtFechaIni') != "")?date('Y-m-d', strtotime($this->input->post('txtFechaIni'))):null;
           $fecha_fin=($this->input->post('txtFechaFin') != "")?date('Y-m-d', strtotime($this->input->post('txtFechaFin'))):null;

           $depreciacion=($this->input->post('depreciacion')!=3)?$this->input->post('depreciacion'):null;
           $data['act_opciones'] = $this->activo_fijo->get_listado_depreciacion(null,'1', null, null, $area, $depreciacion, $fecha_ini, $fecha_fin);
           if($tipo_reporte==null){
               $html = $this->load->view('activo/reportes/rpt_detalle_area', $data, true);
               echo $html;
           }else{
               $filename = 'rpt_listado_activos_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
               $data['filename'] = $filename; 
               $html = $this->load->view('activo/reportes/reporte_listado_activos', $data, true);
               if ($tipo_reporte == 'pdf') {
                   $data['titulo'] = 'Activos por área';
                   $header = $this->load->view('reporte/header', $data, true);
                   $GLOBALS['nombre_reporte'] = 'activo_por_area_' . date('dmY');
                   $reporte = $header . $html;
                   $this->pdf->makePdf($reporte, 'L', 'activo_por_area_', 'Letter');
               } elseif ($tipo_reporte == 'excel') {
                   $filename = 'rpt_activo_por_area_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
                   $data['titulo'] = 'Activos por área';
                   $data['filename'] = $filename;
                   echo $html;
               }
           }

        }else{
            $permisos = $this->gsatelite->get_permisos_opcion();
            $data['permisos']=$permisos;
            //Departamento y tipo como filtro de busqueda (Carlos Alberto Noyola 21-03-2019)
            $tipo_activo = $this->gsatelite->get_dropdown('tac_tipo_activofijo', '{tac_codigo} - {tac_nombre}', '', array('tac_estado'=>1), null, null, 'tac_id', true);
            $data['tipo_activo'] = '<option value="">Todos</option>'.str_replace('<option value="0">Seleccione</option>','<option value=""></option>', $tipo_activo);
            $departamento = $this->gsatelite->get_dropdown('are_area','{are_nombre}', '', array('are_estado' => 1), null, '', 'are_id', true);
            $data['departamento'] = str_replace('<option value="0">Seleccione</option>','<option value=""></option>', $departamento);
            $data['centro_costo'] =str_replace('<option value="0">Seleccione</option>', '',$this->gsatelite->get_dropdown('cec_centro_costo', ' {cec_nombre}', '', array('cec_estado' => 1), null, '', 'cec_id', true));            
            $data['titulo_personal'] = "Listado de activos por área";
            cargarvista($data);   
        }     
    }

    /**
    * @descripcion: Reporte de compra de activos subtotalizado por área   
    * @author: Raul E
    * @since: Sep-2020
    */
    public function rpt_compras_act($flag = null){
        satelite_validar();
        if ($_POST) {
            $where = null;
            $fecha_ini = $this->input->post('fecha_ini');
            $fecha_fin = $this->input->post('fecha_fin');
            $are_unity = $this->input->post('are_unity');
            $carcterst = ($this->input->post('carcterst') != "") ? $this->input->post('carcterst') : 0;
            $tipo_reporte = $this->input->post('tipo_reporte');
            if ($fecha_ini != "") {
                $where['DATE(act_fecha_adq) >= '] = formatear_fecha('Y-m-d', $fecha_ini);
            }
            if ($fecha_fin != "") {
                $where['DATE(act_fecha_adq) <= '] = formatear_fecha('Y-m-d', $fecha_fin);
            }
            if ($are_unity != "") {
                $where['are_id'] = $are_unity;
            }
            if ($tipo_reporte == 'excel' && ($fecha_ini != "" || $fecha_fin != "")) {
                $subtitulo = ($fecha_ini != "") ? " Desde " .  formatear_fecha('d-m-Y', $fecha_ini) . " " : "";
                $subtitulo .= ($fecha_fin != "") ? " Hasta " . formatear_fecha('d-m-Y', $fecha_fin) . " " : "";
                $data['subtitulo'] = $subtitulo;
            }
            $consulta = $this->activo_fijo->get_detalle_rpte_compra_activos($where, $carcterst);
            $data['detalles'] = $consulta;
            $data['filename'] = 'rpt_compra_act_fijo_'.date('dmY');
            $data['tipo_reporte'] = $tipo_reporte;
            $data['tabla_car'] = $this->gsatelite->get_tabla("car_caracteristica", array("car_estado" => 1, "car_id IN ($carcterst)" => null));
            $html = $this->load->view('activo/reportes/detalle_rpte_compra_activos', $data, true);
            if ($flag) {
                echo json_encode(array('tabla' => $html, 'filas' => count($consulta)));
            } else {
                echo $html;
            }            
        } else {
            $select = "";
            $crter = $this->gsatelite->get_tabla('car_caracteristica', array('car_estado' => 1));
            foreach ($crter as $key => $val) {
                $slctd = ($val['car_aplica_reporte'] > 0) ? "selected" : "";
                $select .= '<option value="'.$val['car_id'].'" '.$slctd.'>'.$val['car_nombre'].'</option>';
            }
            $areas = $this->gsatelite->get_dropdown('are_area', '{are_nombre}', '', array('are_estado'=>1), null, null, 'are_id', true);
            $data['caracteristicas'] = $select;
            $data['areas'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $areas);
            $data['titulo_personal'] = "Reporte de Compra de Activos";
            cargarvista($data);   
        }
    }

    /**
    * @descripcion: Reporte de activos subtotalizado por grupo o familia
    * @author: Raul E
    * @since: Sep-2020
    */
    public function rpt_act_grp($flag = null){
        satelite_validar();
        if ($_POST) {
            $where = null;
            $fecha_ini = $this->input->post('fecha_ini');
            $fecha_fin = $this->input->post('fecha_fin');
            $grp_grupo = $this->input->post('grp_grupo');
            $carcterst = ($this->input->post('carcterst') != "") ? $this->input->post('carcterst') : 0;
            $tipo_reporte = $this->input->post('tipo_reporte');
            if ($fecha_ini != "") {
                $where['DATE(act_fecha_adq) >= '] = formatear_fecha('Y-m-d', $fecha_ini);
            }
            if ($fecha_fin != "") {
                $where['DATE(act_fecha_adq) <= '] = formatear_fecha('Y-m-d', $fecha_fin);
            }
            if ($grp_grupo != "") {
                $hijos = $this->gsatelite->get_tabla("grp_grupo", array("grp_padre" => $grp_grupo));
                if (count($hijos) > 0) {
                    $ids = implode(', ', array_column($hijos, "grp_id"));
                    $where["grp_id IN ($grp_grupo, $ids)"] = null;
                } else {
                    $where['grp_id'] = $grp_grupo;
                }
            }
            if ($tipo_reporte == 'excel' && ($fecha_ini != "" || $fecha_fin != "")) {
                $subtitulo = ($fecha_ini != "") ? " Desde " .  formatear_fecha('d-m-Y', $fecha_ini) . " " : "";
                $subtitulo .= ($fecha_fin != "") ? " Hasta " . formatear_fecha('d-m-Y', $fecha_fin) . " " : "";
                $data['subtitulo'] = $subtitulo;
            }
            $consulta = $this->activo_fijo->get_detalle_rpte_activos_grupo($where, $carcterst);
            $data['detalles'] = $consulta;
            $data['filename'] = 'rpt_act_grupos_'.date('dmY');
            $data['tipo_reporte'] = $tipo_reporte;
            $data['tabla_car'] = $this->gsatelite->get_tabla("car_caracteristica", array("car_estado" => 1, "car_id IN ($carcterst)" => null));
            $html = $this->load->view('activo/reportes/detalle_rpte_activos_grupo', $data, true);
            if ($flag) {
                echo json_encode(array('tabla' => $html, 'filas' => count($consulta)));
            } else {
                echo $html;
            }            
        } else {
            $select = "";
            $crter = $this->gsatelite->get_tabla('car_caracteristica', array('car_estado' => 1));
            foreach ($crter as $key => $val) {
                $slctd = ($val['car_aplica_reporte'] > 0) ? "selected" : "";
                $select .= '<option value="'.$val['car_id'].'" '.$slctd.'>'.$val['car_nombre'].'</option>';
            }
                      $this->db->join('tac_tipo_activofijo', 'tac_id = grp_id_tac');
            $grupos = $this->gsatelite->get_dropdown('grp_grupo', '{grp_codigo} - {grp_nombre} ({tac_nombre})', '', null, null, null, 'grp_id', true);
            $data['caracteristicas'] = $select;
            $data['grupos'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $grupos);
            $data['titulo_personal'] = "Reporte de Activos por Grupo";
            cargarvista($data);   
        }
    }

    /**
    * @descripcion: Reporte de asignacion de activos por traslado
    * @author: Raul E
    * @since: Oct-2020
    */
    public function rpt_act_tra_asg($flag = null){
        satelite_validar();
        if ($_POST) {
            $where = null;
            $fecha_ini = $this->input->post('fecha_ini');
            $fecha_fin = $this->input->post('fecha_fin');
            $slc_areas = $this->input->post('slc_areas');
            $carcterst = ($this->input->post('carcterst') != "") ? $this->input->post('carcterst') : 0;
            $tipo_reporte = $this->input->post('tipo_reporte');
            if ($fecha_ini != "") {
                $where['DATE(axe_fecha) >= '] = formatear_fecha('Y-m-d', $fecha_ini);
            }
            if ($fecha_fin != "") {
                $where['DATE(axe_fecha) <= '] = formatear_fecha('Y-m-d', $fecha_fin);
            }
            if ($slc_areas != "") {
                $where['are_id'] = $slc_areas;
            }
            if ($tipo_reporte == 'excel' && ($fecha_ini != "" || $fecha_fin != "")) {
                $subtitulo = ($fecha_ini != "") ? " Desde " .  formatear_fecha('d-m-Y', $fecha_ini) . " " : "";
                $subtitulo .= ($fecha_fin != "") ? " Hasta " . formatear_fecha('d-m-Y', $fecha_fin) . " " : "";
                $data['subtitulo'] = $subtitulo;
            }
            $consulta = $this->activo_fijo->get_detalle_rpte_trasl_asgn($where, $carcterst);
            $data['detalles'] = $consulta;
            $data['filename'] = 'rpt_act_tra_asgn_'.date('dmY');
            $data['tipo_reporte'] = $tipo_reporte;
            $data['tabla_car'] = $this->gsatelite->get_tabla("car_caracteristica", array("car_estado" => 1, "car_id IN ($carcterst)" => null));
            $html = $this->load->view('activo/reportes/detalle_rpte_tra_act_asg', $data, true);
            if ($flag) {
                echo json_encode(array('tabla' => $html, 'filas' => count($consulta)));
            } else {
                echo $html;
            }            
        } else {
            $select = "";
            $crter = $this->gsatelite->get_tabla('car_caracteristica', array('car_estado' => 1));
            foreach ($crter as $key => $val) {
                $slctd = ($val['car_aplica_reporte'] > 0) ? "selected" : "";
                $select .= '<option value="'.$val['car_id'].'" '.$slctd.'>'.$val['car_nombre'].'</option>';
            }
            $areas = $this->gsatelite->get_dropdown('are_area', '{are_nombre}', '', array('are_estado'=>1), null, null, 'are_id', true);
            $data['caracteristicas'] = $select;
            $data['areas'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $areas);
            $data['titulo_personal'] = "Reporte de Traslado de Activos por Asignación";
            cargarvista($data);   
        }
    }

    /**
    * @descripcion: Reporte de asignacion de activos
    * @author: Raul E
    * @since: Oct-2020
    */
    public function rpt_asign_act($flag = null){
        satelite_validar();
        if ($_POST) {
            $where = null;
            $fecha_ini = $this->input->post('fecha_ini');
            $fecha_fin = $this->input->post('fecha_fin');
            $slc_areas = $this->input->post('slc_areas');
            $carcterst = ($this->input->post('carcterst') != "") ? $this->input->post('carcterst') : 0;
            $tipo_reporte = $this->input->post('tipo_reporte');
            if ($fecha_ini != "") {
                $where['DATE(axe_fecha) >= '] = formatear_fecha('Y-m-d', $fecha_ini);
            }
            if ($fecha_fin != "") {
                $where['DATE(axe_fecha) <= '] = formatear_fecha('Y-m-d', $fecha_fin);
            }
            if ($slc_areas != "") {
                $where['are_id'] = $slc_areas;
            }
            if ($tipo_reporte == 'excel' && ($fecha_ini != "" || $fecha_fin != "")) {
                $subtitulo = ($fecha_ini != "") ? " Desde " .  formatear_fecha('d-m-Y', $fecha_ini) . " " : "";
                $subtitulo .= ($fecha_fin != "") ? " Hasta " . formatear_fecha('d-m-Y', $fecha_fin) . " " : "";
                $data['subtitulo'] = $subtitulo;
            }
            $consulta = $this->activo_fijo->get_detalle_rpte_asgn_act($where, $carcterst);
            $data['detalles'] = $consulta;
            $data['filename'] = 'rpt_asgn_act_'.date('dmY');
            $data['tipo_reporte'] = $tipo_reporte;
            $data['tabla_car'] = $this->gsatelite->get_tabla("car_caracteristica", array("car_estado" => 1, "car_id IN ($carcterst)" => null));
            $html = $this->load->view('activo/reportes/detalle_rpte_asgn_act', $data, true);
            if ($flag) {
                echo json_encode(array('tabla' => $html, 'filas' => count($consulta)));
            } else {
                echo $html;
            }            
        } else {
            $select = "";
            $crter = $this->gsatelite->get_tabla('car_caracteristica', array('car_estado' => 1));
            foreach ($crter as $key => $val) {
                $slctd = ($val['car_aplica_reporte'] > 0) ? "selected" : "";
                $select .= '<option value="'.$val['car_id'].'" '.$slctd.'>'.$val['car_nombre'].'</option>';
            }
            $areas = $this->gsatelite->get_dropdown('are_area', '{are_nombre}', '', array('are_estado'=>1), null, null, 'are_id', true);
            $data['caracteristicas'] = $select;
            $data['areas'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $areas);
            $data['titulo_personal'] = "Reporte de Traslado de Activos por Asignación";
            cargarvista($data);   
        }
    }

    public function rpt_act_baja($flag = null){
        satelite_validar();
        if ($_POST) {
            $where = null;
            $fecha_ini = $this->input->post('fecha_ini');
            $fecha_fin = $this->input->post('fecha_fin');
            $moti_baja = $this->input->post('moti_baja');
            $carcterst = ($this->input->post('carcterst') != "") ? $this->input->post('carcterst') : 0;
            $tipo_reporte = $this->input->post('tipo_reporte');
            if ($fecha_ini != "") {
                $where['DATE(act_fecha_desact) >= '] = formatear_fecha('Y-m-d', $fecha_ini);
            }
            if ($fecha_fin != "") {
                $where['DATE(act_fecha_desact) <= '] = formatear_fecha('Y-m-d', $fecha_fin);
            }
            if ($moti_baja != "") {
                $where['mba_id'] = $moti_baja;
            }
            if ($tipo_reporte == 'excel' && ($fecha_ini != "" || $fecha_fin != "")) {
                $subtitulo = ($fecha_ini != "") ? " Desde " .  formatear_fecha('d-m-Y', $fecha_ini) . " " : "";
                $subtitulo .= ($fecha_fin != "") ? " Hasta " . formatear_fecha('d-m-Y', $fecha_fin) . " " : "";
                $data['subtitulo'] = $subtitulo;
            }
            $consulta = $this->activo_fijo->get_detalle_rpte_activos_baja($where, $carcterst);
            $data['detalles'] = $consulta;
            $data['filename'] = 'rpt_baja_act_'.date('dmY');
            $data['tipo_reporte'] = $tipo_reporte;
            $data['tabla_car'] = $this->gsatelite->get_tabla("car_caracteristica", array("car_estado" => 1, "car_id IN ($carcterst)" => null));
            $html = $this->load->view('activo/reportes/detalle_rpte_baja_act', $data, true);
            if ($flag) {
                echo json_encode(array('tabla' => $html, 'filas' => count($consulta)));
            } else {
                echo $html;
            }            
        } else {
            $select = "";
            $crter = $this->gsatelite->get_tabla('car_caracteristica', array('car_estado' => 1));
            foreach ($crter as $key => $val) {
                $slctd = ($val['car_aplica_reporte'] > 0) ? "selected" : "";
                $select .= '<option value="'.$val['car_id'].'" '.$slctd.'>'.$val['car_nombre'].'</option>';
            }
            $motivos = $this->gsatelite->get_dropdown('mba_motivo_baja_activo', '{mba_nombre}', '', array('mba_estado'=>1), null, null, 'mba_id', true);
            $data['caracteristicas'] = $select;
            $data['motivos'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $motivos);
            $data['titulo_personal'] = "Reporte de Activos dados de Baja";
            cargarvista($data);   
        }
    }

    /**
    * @descripcion: Reporte de activos por cuenta de adquisicion separados por depreciables o no
    * @author: Raul E
    * @since: Sep-2020
    */
    public function rpt_act_cta_adq($flag = null){
        satelite_validar();
        if ($_POST) {
            $where = null;
            $fecha_ini = $this->input->post('fecha_ini');
            $fecha_fin = $this->input->post('fecha_fin');
            $cta_adqui = $this->input->post('cta_adqui');
            $carcterst = ($this->input->post('carcterst') != "") ? $this->input->post('carcterst') : 0;
            $tipo_reporte = $this->input->post('tipo_reporte');
            if ($fecha_ini != "") {
                $where['DATE(act_fecha_adq) >= '] = formatear_fecha('Y-m-d', $fecha_ini);
            }
            if ($fecha_fin != "") {
                $where['DATE(act_fecha_adq) <= '] = formatear_fecha('Y-m-d', $fecha_fin);
            }
            if ($cta_adqui != "") {
                $where['cnt_id'] = $cta_adqui;
            }
            if ($tipo_reporte == 'excel' && ($fecha_ini != "" || $fecha_fin != "")) {
                $subtitulo = ($fecha_ini != "") ? " Desde " .  formatear_fecha('d-m-Y', $fecha_ini) . " " : "";
                $subtitulo .= ($fecha_fin != "") ? " Hasta " . formatear_fecha('d-m-Y', $fecha_fin) . " " : "";
                $data['subtitulo'] = $subtitulo;
            }
            $consulta = $this->activo_fijo->get_det_rpte_act_x_cta_adq($where, $carcterst);
            $data['detalles'] = $consulta;
            $data['filename'] = 'rpt_act_cta_adq_'.date('dmY');
            $data['tipo_reporte'] = $tipo_reporte;
            $data['tabla_car'] = $this->gsatelite->get_tabla("car_caracteristica", array("car_estado" => 1, "car_id IN ($carcterst)" => null));
            $html = $this->load->view('activo/reportes/det_rpte_act_x_cta_adq', $data, true);
            if ($flag) {
                echo json_encode(array('tabla' => $html, 'filas' => count($consulta)));
            } else {
                echo $html;
            }            
        } else {
            $select = "";
            $crter = $this->gsatelite->get_tabla('car_caracteristica', array('car_estado' => 1));
            foreach ($crter as $key => $val) {
                $slctd = ($val['car_aplica_reporte'] > 0) ? "selected" : "";
                $select .= '<option value="'.$val['car_id'].'" '.$slctd.'>'.$val['car_nombre'].'</option>';
            }
                    $this->db->join('dtv_detalle_tipo_activo', 'dtv_id_cnt = cnt_id');$this->db->group_by('cnt_id');
            $ctas = $this->gsatelite->get_dropdown('cnt_cuenta_contable', '{cnt_cuenta} - {cnt_nombre}', '', array('cnt_estado'=>1), null, null, 'cnt_id', true);
            $data['cuentas'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $ctas);
            $data['caracteristicas'] = $select;
            $data['titulo_personal'] = "Reporte de Activos por Cuenta de Adquisición";
            cargarvista($data);   
        }
    }

    /**
    * @descripcion: Reporte de activos por tipo de activo
    * @author: Raul E
    * @since: Oct-2020
    */
    public function rpt_act_tipo($flag = null){
        satelite_validar();
        if ($_POST) {
            $where = null;
            $fecha_ini = $this->input->post('fecha_ini');
            $fecha_fin = $this->input->post('fecha_fin');
            $tipo_acti = $this->input->post('tipo_acti');
            $carcterst = ($this->input->post('carcterst') != "") ? $this->input->post('carcterst') : 0;
            $tipo_reporte = $this->input->post('tipo_reporte');
            if ($fecha_ini != "") {
                $where['DATE(act_fecha_adq) >= '] = formatear_fecha('Y-m-d', $fecha_ini);
            }
            if ($fecha_fin != "") {
                $where['DATE(act_fecha_adq) <= '] = formatear_fecha('Y-m-d', $fecha_fin);
            }
            if ($tipo_acti != "") {
                $where['tac_id'] = $tipo_acti;
            }
            if ($tipo_reporte == 'excel' && ($fecha_ini != "" || $fecha_fin != "")) {
                $subtitulo = ($fecha_ini != "") ? " Desde " .  formatear_fecha('d-m-Y', $fecha_ini) . " " : "";
                $subtitulo .= ($fecha_fin != "") ? " Hasta " . formatear_fecha('d-m-Y', $fecha_fin) . " " : "";
                $data['subtitulo'] = $subtitulo;
            }
            $consulta = $this->activo_fijo->get_det_rpte_act_x_tipo($where, $carcterst);
            $data['detalles'] = $consulta;
            $data['filename'] = 'rpt_act_tipo_'.date('dmY');
            $data['tipo_reporte'] = $tipo_reporte;
            $data['tabla_car'] = $this->gsatelite->get_tabla("car_caracteristica", array("car_estado" => 1, "car_id IN ($carcterst)" => null));
            $html = $this->load->view('activo/reportes/det_rpte_act_x_tipo', $data, true);
            if ($flag) {
                echo json_encode(array('tabla' => $html, 'filas' => count($consulta)));
            } else {
                echo $html;
            }            
        } else {
            $select = "";
            $crter = $this->gsatelite->get_tabla('car_caracteristica', array('car_estado' => 1));
            foreach ($crter as $key => $val) {
                $slctd = ($val['car_aplica_reporte'] > 0) ? "selected" : "";
                $select .= '<option value="'.$val['car_id'].'" '.$slctd.'>'.$val['car_nombre'].'</option>';
            }
            $tipos = $this->gsatelite->get_dropdown('tac_tipo_activofijo', '{tac_codigo} - {tac_nombre}', '', array('tac_estado' => 1), null, null, 'tac_id', true);
            $data['tipos'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $tipos);
            $data['caracteristicas'] = $select;
            $data['titulo_personal'] = "Reporte de Activos por Tipo";
            cargarvista($data);   
        }
    }

     public function imprimir_detalles_area($act_id)
    {
        satelite_validar();

          $this->load->library('EnLetras');
          $id_activo = $act_id;
         
          //Verificar acceso unicamente a traves de url
          if ( $id_activo === false || $id_activo == "" || !is_numeric( $id_activo ) ){
              redirect( base_url('activo/reportes/rpt_activo_area') );
          }

          $data['act_id'] = $id_activo;
          $data['act_detalles'] = $this->activo_fijo->get_detalles_activo_completo( $id_activo )->row();
          
          $data['caracteristicas2'] = $this->activo_fijo->get_caracteristicaxactivo($id_activo); 
          $data['act_depreciacion'] = $depreciacion =$this->activo_fijo->get_depreciacion_acumulada( $id_activo );
         
            $this->load->library('pdf');
            $html  = $this->load->view('reporte/header', array('titulo' => 'Activos por área'), true);
            $html .= $this->load->view('activo/reportes/imprimir_detalle_cuentas_mayor_menor', $data, true);            
              
            $reporte=$this->pdf->makePDF($html);
            
          $this->_cargarvista( null, $data );        
    }

    public function formato_fecha($fecha){
        $fecha = explode("-", $fecha);
        return $fecha[2].'-'.$fecha[1].'-'.$fecha[0];
    }

     /**
      * @author Edith Herrera
      * @since 2017-07-10
      * @return Reporte por tipo de activo
     **/
    public function rpt_tipo_activo()
    {
        satelite_validar();
        if($_POST){
            ini_set( 'memory_limit', '2048M' );
            ini_set('max_execution_time', '9999'); 
            $titulo_reporte = '';
            $where = array();
            $data['tipo_activo']=$tipo_activo=($this->input->post('tipo_activo')>0)?$this->input->post('tipo_activo'):null;
            //Departamento y tipo como filtro de busqueda (Carlos Alberto Noyola 21-03-2019)
            $departamento = ( $this->input->post('slcDepartamento') != "") ? $this->input->post('slcDepartamento') : '';
            if ($departamento != null ) {
                $data['departamento'] = $departamento;
                $titulo_reporte       .= '<b>Departamento</b>: '.$this->gsatelite->get_campo('are_area','are_nombre',array('are_id' => $departamento)).'<br>';
            }
            $data['exportar']=$exportar=($this->input->post('exportar')>0)?$this->input->post('exportar'):null;
            $data['tipo_reporte']=$tipo_reporte=$this->input->post('tipo_reporte');

            if($exportar==1){
                $data['tipo_activo']=$tipo_activo=($this->input->post('tipo_activo') >= 0 ) ?$this->input->post('tipo_activo'):$this->input->post('tipo_activo_exp');

            }
            $estado = ($this->input->post('slcEstados'))? $this->input->post('slcEstados'):null;
            //print_r($_POST); die();
            $estados_ = $this->input->post('slcEstados');
            if (count($estados_) > 0) {
            $estados_array = array();
                for ($q=0; $q < count($estados_) ; $q++) { 
                    
                    switch ($estados_[$q]) {
                        case '1':
                            $estados_array[] .= 'Activo'; 
                            break;
                        case '2':
                            $estados_array[] .= 'Depreciado'; 
                            break;
                         case '0':
                            $estados_array[] .= 'Inactivo'; 
                            break;

                    }
                }
            $titulo_reporte .= "<b>Estado(s):</b> ".implode(', ', $estados_array).'<br />';
            }
           

            $costo_x = ( $this->input->post('slcCosto') !== '' ) ? $this->input->post('slcCosto') : null; 
            if ($costo_x) {
                $titulo_reporte .= '<b>Centro de Costo:</b> '.$this->gsatelite->get_campo('cec_centro_costo','cec_nombre',array('cec_id' => $costo_x)).'<br>';
            }
            //print_r($estado); die();
            $tipo_activo = ($this->input->post('tipo_activo') !== '')?$this->input->post('tipo_activo'):null;
            if ($tipo_activo) {
                $titulo_reporte .= '<b>Tipo de activo:</b> '.$this->gsatelite->get_campo('tac_tipo_activofijo','tac_nombre',array('tac_id' => $tipo_activo)).'<br>';
            }elseif($tipo_activo === '0'){
                $titulo_reporte .= '<b>Tipo de activo:</b> Todos<br>';
            }
            $data['act_opciones'] = $this->activo_fijo->get_listado_depreciacion(null,$estado, $tipo_activo, null, $departamento,null,null,null,null,$costo_x);
            //die(print_r($this->db->last_query()));
            $data['titulo_reporte'] = $titulo_reporte;
            if($tipo_reporte==null){
                $html = $this->load->view('activo/reportes/detalle_rpt_tipo_activo', $data, true);
                echo $html;
            }else{
                $filename = 'rpt_tipo_activo_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
                $data['filename'] = $filename; 
                $html = $this->load->view('activo/reportes/reporte_tipo_activo', $data, true);
                if ($tipo_reporte == 'pdf') {
                    $data['titulo'] = 'Activos';
                    $header = $this->load->view('reporte/header', $data, true);
                    $GLOBALS['nombre_reporte'] = 'tipo_activo_' . date('dmY');
                    $reporte = $header .'<div>'.$titulo_reporte.'</div>'.$html;
                    $this->pdf->makePdf($reporte, 'L', 'tipo_activo_', 'Letter');
                } elseif ($tipo_reporte == 'excel') {
                    $filename = 'rpt_tipo_activo_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
                    $data['titulo'] = 'Activos';
                    $data['filename'] = $filename;
                    echo $html;
                }
            }

        }else{
            $activo = $this->gsatelite->get_dropdown('tac_tipo_activofijo', '{tac_codigo} - {tac_nombre}', '', array('tac_estado'=>1), null, null, 'tac_id', true);
            $data['tipos'] = str_replace('<option value="0">Seleccione</option>', '<option value="0">Todos</option>', $activo);

            $departamento = $this->gsatelite->get_dropdown('are_area',
            '{are_nombre}', '', array('are_estado' => 1), null, '', 'are_id', true);
            $data['departamento'] = str_replace('<option value="0">Seleccione</option>',
            '<option value=""></option>', $departamento);
            $data['centro_costo'] =str_replace('<option value="0">Seleccione</option>', '',$this->gsatelite->get_dropdown('cec_centro_costo', ' {cec_nombre}', '', array('cec_estado' => 1), null, '', 'cec_id', true));

            $data['titulo_personal'] = "Reporte por tipo de activo";
            $this->_cargarvista( null, $data );     
        }     
    }

    /**
      * @author Edith Herrera
      * @since 2017-07-11
      * @return Reporte por cuenta contable
     **/
       public function rpt_activo_cuenta()
    {
        satelite_validar();
        $this->load->library('EnLetras');

        if($_POST){

            $exportar=($this->input->post('exportar')>0)?$this->input->post('exportar'):null;
            if($this->input->post('filtro_ini')!='' && $exportar==1){
                $cuenta=($this->input->post('filtro_cuenta')>0)?$this->input->post('filtro_cuenta'):null;
                $desde=($this->input->post('filtro_inicio')>0)?$this->input->post('filtro_inicio'):'0001-01-01';
                $hasta=($this->input->post('filtro_fin')>0)?$this->input->post('filtro_fin'):date("Y-m-d");
                $costo_x = ( $this->input->post('slcCosto') != "") ? $this->input->post('slcCosto') : null;

            }else{
                $cuenta=($this->input->post('cuenta')>0)?$this->input->post('cuenta'):null;
                $desde=($this->input->post('fecha_ini')>0)?$this->input->post('fecha_ini'):'xx-xx-xxxx';
                $hasta=($this->input->post('fecha_fin')>0)?$this->input->post('fecha_fin'):date("Y-m-d");

                $departamento = ( $this->input->post('slcDepartamento') != "") ? $this->input->post('slcDepartamento') : '';
                $tipo_activo = ( $this->input->post('slcTipoActivo') != "") ? $this->input->post('slcTipoActivo') : '';
                $where = array();

                if ($departamento != null ) {
                            $where['act_id_are'] = $departamento;
                        }
                if($tipo_activo != null) {
                            $where['act_id_tac'] = $tipo_activo;
                        }
                $costo_x = ( $this->input->post('slcCosto') != "") ? $this->input->post('slcCosto') : null;
            }

            $data['tipo_reporte']=$tipo_reporte=$this->input->post('tipo_reporte');

            if($desde!=null && $hasta!=null){ 
                $inicio = formatear_fecha('Y-m-d', $desde);
                $fin    = formatear_fecha('Y-m-d', $hasta);

                $mes_ini = formatear_fecha('m', $desde);
                $mes_fin = formatear_fecha('m', $hasta);

                $y1 = formatear_fecha('Y', $desde);
                $y2 = formatear_fecha('Y', $hasta);

                if($mes_ini==$mes_fin && $y1==$y2){
                    $mes = strtolower($this->enletras->mes_anio(null, 3,$mes_ini));
                    $data['periodo'] = $mes.' '.$y1;
                }else{
                    $data['periodo'] = ' del '.$desde.' al '.$hasta;
                }
            }
             if ($costo_x !== null) {
                  $where['act_id_cec'] = $this->input->post('slcCosto');
                } 
            $data['reporte'] = $this->activo_fijo->get_reporte_activo_cuenta($where, $cuenta, $inicio, $fin);
            //print_r($this->db->last_query()); die();
            
            if($exportar==null){
                $html = $this->load->view('activo/reportes/detalle_depreciacionxcuenta', $data, true);
                echo $html;
            }else{
                $filename = 'rpt_tipo_activo_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
                $data['filename'] = $filename; 
                $html = $this->load->view('activo/reportes/reporte_depreciacion_cuenta', $data, true);
                if ($tipo_reporte == 'pdf') {
                    $data['titulo'] = 'depreciación por cuenta contable';
                    $header = $this->load->view('reporte/header', $data, true);
                    $GLOBALS['nombre_reporte'] = 'tipo_activo_' . date('dmY');
                    $reporte = $header . $html;
                    $this->pdf->makePdf($reporte, 'L', 'tipo_activo_', 'Letter');
                } elseif ($tipo_reporte == 'excel') {
                    $filename = 'rpt_tipo_activo_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
                    $data['titulo'] = 'depreciación por cuenta contable';
                    $data['filename'] = $filename;
                    echo $html;
                }
            }

        }else{
            // Se hizo un consulta que muestra las cuentas que solo esten agreggadas al activo fijo
            $this->db->join('dtv_detalle_tipo_activo', 'dtv_id_cnt = cnt_id');$this->db->group_by('cnt_id');
            $cuentas = $this->gsatelite->get_dropdown('cnt_cuenta_contable', '{cnt_cuenta} - {cnt_nombre}', '', array('cnt_estado'=>1), null, null, 'cnt_id', true);
            $data['cuentas'] = str_replace('<option value="0">Seleccione</option>', '<option value="todas">Todas las cuentas contables</option>', $cuentas);

            $data['titulo_personal'] = "Reporte de depreciación por cuenta contable";

            $tipo_activo = $this->gsatelite->get_dropdown('tac_tipo_activofijo',
             '{tac_codigo} - {tac_nombre}', '', array('tac_estado'=>1), null, null, 'tac_id', true);
            $data['tipo_activo'] = str_replace('<option value="0">Seleccione</option>',
             '<option value=""></option>', $tipo_activo);

            $departamento = $this->gsatelite->get_dropdown('are_area',
             '{are_nombre}', '', array('are_estado' => 1), null, '', 'are_id', true);
            $data['departamento'] = str_replace('<option value="0">Seleccione</option>',
             '<option value=""></option>', $departamento);

            $data['centro_costo'] =str_replace('<option value="0">Seleccione</option>', '',$this->gsatelite->get_dropdown('cec_centro_costo', ' {cec_nombre}', '', array('cec_estado' => 1), null, '', 'cec_id', true));

            $this->_cargarvista( null, $data );     
        }     
    }

    /**
    * @author René Castaneda
    * @since 2017-08-08
    * @return/descripción generación de reporte total de activo basado en filtros
     */
    public function total_activos()
    {   
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();
        $data['permisos']=$permisos;
        $data['slcTipoActivo'] = $this->gsatelite->get_dropdown('tac_tipo_activofijo', '{tac_codigo} - {tac_nombre}','', array('tac_estado' => '1'), null, '', 'tac_id', true);
        $data['slcGrupo'] = $this->gsatelite->get_dropdown('grp_grupo', '{grp_codigo} {grp_nombre}','', null, null, '', 'grp_id', true);
        $data['slcSuc'] = $this->gsatelite->get_dropdown('suc_sucursal', '{suc_codigo} {suc_nombre}','', null, null, '', 'suc_id', true);
        $data['slcAdq'] = $this->gsatelite->get_dropdown('tad_tipo_adquisicion', '{tad_codigo} {tad_nombre}','', array('tad_estado' => '1'), null, '', 'tad_id', true);
        $data['slcArea'] = $this->gsatelite->get_dropdown('are_area', '{are_prefijo} - {are_nombre}','', array('are_estado' => '1'), null, '', 'are_id', true);
        $data['centro_costo'] =str_replace('<option value="0">Seleccione</option>', '',$this->gsatelite->get_dropdown('cec_centro_costo', ' {cec_nombre}', '', array('cec_estado' => 1), null, '', 'cec_id', true));
        $nombre_empresa = mb_strtolower($this->gsatelite->get_parametro_emp('SYS_EMPRESA'),'UTF-8');
        $data['es_alcaldia'] = ((substr_count($nombre_empresa,'municipal') > 0) || (substr_count($nombre_empresa,'alcaldia') > 0)) ? 1 : 0;

        $data['titulo_personal'] = "Reporte total de activos";
        cargarvista($data);
    }

    /**
    * @author René Castaneda
    * @since 2017-08-08
    * @return filtrar total activos.
     */

    public function filtrar_total_activos($es_reporte=0){   
        // var_dump($_POST); die();
        satelite_validar();
        $registros = array();
        $permisos = $this->gsatelite->get_permisos_opcion('total_activos');
        $data['permisos']=$permisos;
        $slcTipoActivo =  $this->input->post('slcTipoActivo');
        $slcGrupo = $this->input->post('slcGrupo');
        $slcSuc = $this->input->post('slcSuc');
        $slcAdq = $this->input->post('slcAdq');
        $slcArea = $this->input->post('slcArea');
        $slcDepreciable = $this->input->post('slcDepreciable');
        $slcEstado = $this->input->post('slcState');
        $monto_max  = $this->input->post('limit_monto');
        ini_set( 'memory_limit', '2048M' );
        ini_set('max_execution_time', '9999');
        $where = null;
        if ($this->input->post()) {
            if ($slcTipoActivo>0) {
                $where['act_id_tac']=$slcTipoActivo;
            }
            if ($slcGrupo>0) {
                $where['act_id_grp']=$slcGrupo;
            }
            if ($slcSuc > 0) {
                $where['act_id_suc']=$slcSuc;
            }
            if ($slcAdq>0) {
                $where['act_id_tad']=$slcAdq;
            }
            if ($slcArea>0) {
                $where['act_id_are']=$slcArea;
            }
            if ($slcDepreciable !='') {
                $where['act_depreciable']=$slcDepreciable;
            }
            if ($slcEstado != "" && $slcEstado >= 0) {
                $where['act_estado'] = $slcEstado;
            }
            if ($monto_max > 0) {
                $where['act_valor_compra <= '] = $monto_max;
            }
            $costo_x = ( $this->input->post('slcCosto') != "") ? $this->input->post('slcCosto') : null;
            if ($costo_x !== null) {
                $where['act_id_cec'] = $this->input->post('slcCosto');
            } 
        }
        // print_r($_POST); die();
        $registros=$this->activo_fijo->get_info_total_activo($where,array('act_id_are'=>'ASC'));
        //print_r($this->db->last_query()); die(); 
        $data['es_reporte']=$es_reporte;
        $data['slcTipoActivo'] = $this->input->post('slcTipoActivo');
        $data['slcGrupo'] = $this->input->post('slcGrupo');
        $data['slcAdq'] = $this->input->post('slcAdq');
        $data['slcState'] = $this->input->post('slcState');
        $data['slcArea'] = $this->input->post('slcArea');
        $data['slcSuc'] = $this->input->post('slcSuc');
        $data['slcDepreciable'] = $this->input->post('slcDepreciable');
        $data['monto_limita'] = $this->input->post('limit_monto');
        $data['costo'] = $costo_x;
        $data['registros'] = $registros;
        $html = $this->load->view('activo/reportes/filtrar_total_activos', $data, true);
        if ($es_reporte) {
            $tipo_accion = $this->input->post('tipo_accion');
            $filtro_titulo = (trim($data['slcDepreciable']) != '' )? (($data['slcDepreciable']==0)? 'Activos No Depreciables':'Activos Depreciables'):'';
            if ($tipo_accion) { //excel
                header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                header("Content-Disposition: attachment;filename=total_activos_".date('d-m-Y_His').".xls"); 
                header("Pragma: no-cache");
                header("Expires: 0");
                echo '<meta charset="utf-8" />';
                echo "<table border='0'>
                  <tr><th colspan='10' align='center' >".mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'),'UTF-8')."</th></tr>
                  <tr><th colspan='10' align='center' >Reporte Total de Activos</th></tr>
                  <tr><th colspan='10' align='center' >".$filtro_titulo. "</th></tr>
                  </table>";
                echo $html; die();
            } else { //pdf
                ini_set( 'memory_limit', '2048M' );
                ini_set('max_execution_time', '9999');
                $this->load->library('pdf');
                $html_header=$this->load->view('reporte/header', array('titulo' => "Reporte Total de Activos<br /> $filtro_titulo", 'solotitulo'=> true), true);
                $html = str_replace('border="1" style="margin-left: 4px; width: 99%; font-size:12px;"','border="0.5" style="width: 100%; font-size:9px;"',$html);
                $this->pdf->makePDF($html_header.$html,'lanscape', 'total_activo','Legal');
                die();
            }
        }
        echo json_encode(array('html'=>$html));

    }

    /**
    * @author René Castaneda
    * @since 2017-08-08
    * @return filtrar los grupos dependiendo el tipo
     */
    public function filtrar_grupos_option()
    {
        $where['grp_id_tac'] = $this->input->post('slcTipoActivo');
        if ($where['grp_id_tac'] > 0 ) {
            $data['options'] = $this->gsatelite->get_dropdown('grp_grupo', '{grp_codigo} {grp_nombre}','', $where, null, '', 'grp_id', true);
        } else {
            $data['options'] = $this->gsatelite->get_dropdown('grp_grupo', '{grp_codigo} {grp_nombre}','', null, null, '', 'grp_id', true);
        }
        $data['options'] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $data['options']);
        die(json_encode($data));
    }


    /**
    * @author René Castaneda
    * @since 2017-09-20
    * @return/descripción generación de reporte de depreciación de activos
     */
    public function depreciacion_activo(){   
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();
        $data['permisos']=$permisos;
        $data['slcTipoActivo'] = $this->gsatelite->get_dropdown('tac_tipo_activofijo', '{tac_codigo} - {tac_nombre}','', array('tac_estado' => '1'), null, '', 'tac_id', true);
        $data['slcArea'] = $this->gsatelite->get_dropdown('are_area', '{are_nombre}','', array('are_estado' => '1'), null, '', 'are_id', true);
        $data['centro_costo'] =str_replace('<option value="0">Seleccione</option>', '',$this->gsatelite->get_dropdown('cec_centro_costo', ' {cec_nombre}', '', array('cec_estado' => 1), null, '', 'cec_id', true));
       
        $data['titulo_personal'] = "Reporte depreciación de activos";
        cargarvista($data);
    }

    /**
    * @author René Castaneda
    * @since 2017-09-20
    * @return filtrar los activos y su depreciación.
     */

    public function filtrar_depreciacion_activo($es_reporte=0){
        satelite_validar();
        $registros = array();
        $permisos = $this->gsatelite->get_permisos_opcion('depreciacion_activo');
        $data['permisos']=$permisos;
        //$slcTipoActivo =  $this->input->post('slcTipoActivo');
        //$slcArea = $this->input->post('slcArea');
        $slcArea = ( $this->input->post('slcArea') != "") ? $this->input->post('slcArea') : null;
        $slcTipoActivo = ( $this->input->post('slcTipoActivo') != "") ? $this->input->post('slcTipoActivo') : null;
        $txtFecha_desde = ( $this->input->post('txtFecha_desde') != "") ? $this->input->post('txtFecha_desde') : '01-0001';
        $txtFecha_hasta = ( $this->input->post('txtFecha_hasta') != "") ? $this->input->post('txtFecha_hasta') : date("m-Y");
        $txt_estado     =  $this->input->post('txt_estado');
        $costo_x = ( $this->input->post('slcCosto') != "") ? $this->input->post('slcCosto') : null;
        $hay_agrupacion = $this->gsatelite->count('agr_agrupacion_activos', array('agr_estado' => 1));
        $hay_historicos = $this->gsatelite->count('dph_depreciacion_historica', array('dph_estado' => 1));
        if ($costo_x !== null) {
            $where['act_id_cec'] = $costo_x;
        } 
        if ($txt_estado == 1) {
            $where['act_estado in (1,2)'] = null;
        } else {
            $where['act_estado'] = $txt_estado;
        }
        $where['act_depreciable']   = '1';
        if ($this->input->post()) {                        
            if ($slcTipoActivo>0) {
                $where['act_id_tac']=$slcTipoActivo;
            }
            if ($slcArea>0) {
                $where['act_id_are']=$slcArea;
            }
            if ($txtFecha_desde !='') {
                $txtFecha_desde = '01-'.$txtFecha_desde;
              //  $where['DATE(act_fecha_adq) >=']=formatear_fecha('Y-m-d', $txtFecha_desde);
            }
            if ($txtFecha_hasta !='') {
                $txtFecha_hasta = '01-'.$txtFecha_hasta;
                $txtFecha_hasta = formatear_fecha('t-m-Y', $txtFecha_hasta);/////CASO SERSAPROSA
               // $where['DATE(act_fecha_adq) <=']=formatear_fecha('Y-m-d', $txtFecha_hasta);
            }
        }
        ini_set('post_max_size','4000M');
        ini_set('memory_limit', '4000M' );
        ini_set('max_execution_time', '99999');
        $orderby = ($hay_historicos > 0 && $hay_agrupacion > 0) ? array('agr_orden'=>'ASC','act_id_are'=>'ASC') : array('act_id_tac'=>'ASC','act_id_are'=>'ASC');
        if ($hay_historicos > 0 && $hay_agrupacion > 0) {
            $registros=$this->activo_fijo->get_depreciacion_activo_historico($where, $orderby,$txtFecha_desde, $txtFecha_hasta);
        } else {
            $registros=$this->activo_fijo->get_depreciacion_activo($where, $orderby,$txtFecha_desde, $txtFecha_hasta);
        }
        // var_dump($registros); die(); 
        $data['es_reporte']=$es_reporte;
        $data['slcTipoActivo'] = $this->input->post('slcTipoActivo');
        $data['slcArea'] = $this->input->post('slcArea');
        $data['txtFecha_desde'] = $this->input->post('txtFecha_desde');
        $data['txtFecha_hasta'] = $this->input->post('txtFecha_hasta');
        $data['txt_estado']=$txt_estado;
        $data['costo'] = $costo_x;
        $data['fecha_hasta'] = $txtFecha_hasta;
        $data['anio_hasta'] = formatear_fecha('Y',$txtFecha_hasta);
        $data['registros'] = $registros;
        $sig_emp = strtolower(trim($this->gsatelite->get_parametro('SYS_SIGLAS')));
        if ($sig_emp == 'sersaprosa') {
            $html = $this->load->view('activo/reportes/filtrar_depreciacion_activo_v2', $data, true);
        } else {
            if ($hay_historicos > 0 && $hay_agrupacion > 0) {
                $html = $this->load->view('activo/reportes/filtrar_depreciacion_activo_agr', $data, true);
            } else {
                $html = $this->load->view('activo/reportes/filtrar_depreciacion_activo', $data, true);
            }            
        }
        $filtro_titulo = "";
        if ($es_reporte) {
            //print_r($registros);
            //return 0;
            $tipo_accion = $this->input->post('tipo_accion');

            $reg_area = ($data['slcArea'] > 0 )? $this->gsatelite->get_registro('are_area','are_id',$data['slcArea']):0;
            $reg_tipo = ($data['slcTipoActivo'] > 0 )? $this->gsatelite->get_registro('tac_tipo_activofijo','tac_id',$data['slcTipoActivo']):0;

            $filtro_titulo .= ($reg_area)? "Area: ".$reg_area->are_nombre."<br />":"";
            $filtro_titulo .= ($reg_tipo)? "Tipo: ".$reg_tipo->tac_nombre."<br />":"";
            $filtro_titulo .= ($txtFecha_desde !=''  && $txtFecha_desde != '01-01-0001')? " Desde: ".$txtFecha_desde:"";
            $filtro_titulo .= ($txtFecha_hasta !='' )? " Hasta: ".formatear_fecha('t-m-Y',$txtFecha_hasta):"";
            
            if ($tipo_accion) { //excel
                header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                header("Content-Disposition: attachment;filename=depreciacion_activos_".date('d-m-Y_His').".xls"); 
                header("Pragma: no-cache");
                header("Expires: 0");
                echo '<meta charset="utf-8" />';
                echo "<table border='0'>
                  <tr><th colspan='15' align='center' >".mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'),'UTF-8')."</th></tr>
                  <tr><th colspan='15' align='center' >Reporte Depreciación de Activos</th></tr>
                  <tr><th colspan='15' align='center' >".$filtro_titulo. "</th></tr>
                  </table>";
                echo $html; die();
            } else { //pdf

                $this->load->library('pdf');
                $html_header=$this->load->view('reporte/header', array('titulo' => "Reporte Total de Activos<br /> $filtro_titulo", 'solotitulo'=> true), true);
                $html = str_replace('border="1" style="margin-left: 4px; width: 99%; font-size:12px;"','border="0.5" style="width: 100%; font-size:9px;"',$html);
                $this->pdf->makePDF($html_header.$html,'lanscape', 'total_activo','Legal');
                die();
            }
        }
        echo json_encode(array('html'=>$html));

    }

    public function cuentas_mayor_menor() {
        satelite_validar();
        if($_POST){
            $fecha_ini=($this->input->post('txtFechaIni') != "")?date('Y-m-d', strtotime($this->input->post('txtFechaIni'))):null;
            $fecha_fin=($this->input->post('txtFechaFin') != "")?date('Y-m-d', strtotime($this->input->post('txtFechaFin'))):null;
            $depreciacion= $this->input->post('depreciacion');
            $area=($this->input->post('area')!=0)?$this->input->post('area'):null;            
            $tipo_activo = $this->input->post('tipo_act');
            $grupo_activo = $this->input->post('grupo_act');
            $estado = ($this->input->post('slcEstados') != '')?$this->input->post('slcEstados'):null;
            $costo_x = ( $this->input->post('slcCosto') != "") ? $this->input->post('slcCosto') : null;
            $montobase = ( $this->input->post('txtMontoD') > 0) ? $this->input->post('txtMontoD') : null;
            $depreciable = ( $this->input->post('slcDeprecble') != "") ? $this->input->post('slcDeprecble') : null;
            $data['tipo_reporte']=$tipo_reporte=$this->input->post('tipo_reporte');
            $where = array(
                'fecha_ini' => $fecha_ini, 
                'fecha_fin' => $fecha_fin, 
                'tipo_depr' => $depreciacion,
                'area_actv' => $area,
                'tipo_actv' => $tipo_activo,
                'grpo_actv' => $grupo_activo,
                'stado_act' => $estado,
                'cec_activ' => $costo_x,
                'ver_desde' => $montobase,
                'deprecibl' => $depreciable
            );
            $data['act_opciones'] = $this->activo_fijo->get_cuentas_mayores_menores($where);            

            if($tipo_reporte==null){
                $html = $this->load->view('activo/reportes/rpt_detalle_cuenta_mayor_menor', $data, true);
                echo $html;
            }else{
                $nameFile = "";
                if ($depreciacion == 3) {
                    $nameFile = "cuentas_mayores_menores_";
                } else if($depreciacion == 1) {
                    $nameFile = "cuentas_mayores_";
                } else if($depreciacion == 0) {
                    $nameFile = "cuentas_menores_";
                }
                $filename = $nameFile . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
                $data['filename'] = $filename; 
                $html = $this->load->view('activo/reportes/reporte_cuentas_mayores_menores', $data, true);
                if ($tipo_reporte == 'pdf') {
                    $titulo_pdf = "";
                    if ($depreciacion == 3) {
                        $titulo_pdf = "Activos mayores y menores";
                    } else if($depreciacion == 1) {
                        $titulo_pdf = "Activos mayores";
                    } else if($depreciacion == 0) {
                        $titulo_pdf = "Activos menores";
                    }
                    $data['titulo'] = $titulo_pdf;
                    $header = $this->load->view('reporte/header', $data, true);
                    $GLOBALS['nombre_reporte'] = 'activo_por_area_' . date('dmY');
                    $reporte = $header . $html;
                    $this->pdf->makePdf($reporte, 'L', 'activo_por_area_', 'Letter');
                } elseif ($tipo_reporte == 'excel') {
                    $filename = 'rpt_activo_por_area_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
                    $data['titulo'] = $titulo_pdf;//'Activos por área';
                    $data['filename'] = $filename;
                    echo $html;
                }
            }

        }else{
            $activo = $this->gsatelite->get_dropdown('are_area', '{are_prefijo} {are_nombre}', '', array('are_estado'=>1), null, null, 'are_id', true);
            $data['areas'] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $activo);
            $tipo_activo = $this->gsatelite->get_dropdown('tac_tipo_activofijo', '{tac_codigo} - {tac_nombre}', '', array('tac_estado' => 1), null, null, 'tac_id', true);
            $data['tipo_activo'] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $tipo_activo);
            $grupo = $this->gsatelite->get_dropdown('grp_grupo', '{grp_codigo} {grp_nombre}', '', null, null, null, 'grp_id', true);
            $data['grupo'] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $grupo);
            $data['centro_costo'] =str_replace('<option value="0">Seleccione</option>', '',$this->gsatelite->get_dropdown('cec_centro_costo', ' {cec_nombre}', '', array('cec_estado' => 1), null, '', 'cec_id', true));
            $data['titulo_personal'] = "Listado de cuentas mayores y menores";
            $this->_cargarvista( null, $data );     
        } 
    }

    public function imprimir_detalle_cuentas_mayores_menores($act_id) {
        satelite_validar();

        $this->load->library('EnLetras');
        $id_activo = $act_id;
         
        //Verificar acceso unicamente a traves de url
        if ( $id_activo === false || $id_activo == "" || !is_numeric( $id_activo ) ){
            redirect( base_url('activo/reportes/cuentas_mayor_menor') );
        }

        $data['act_id'] = $id_activo;
        $data['act_detalles'] = $this->activo_fijo->get_detalles_activo_completo( $id_activo )->row();
          
        $data['caracteristicas2'] = $this->activo_fijo->get_caracteristicaxactivo($id_activo); 
        $data['act_depreciacion'] = $depreciacion =$this->activo_fijo->get_depreciacion_acumulada( $id_activo );
         
        $this->load->library('pdf');
        $html  = $this->load->view('reporte/header', array('titulo' => 'Cuentas mayores y menores'), true);
        $html .= $this->load->view('activo/reportes/imprimir_detalle_area', $data, true);                  
        $reporte=$this->pdf->makePDF($html);
            
        $this->_cargarvista( null, $data );  
    }

    /**
    * @author Israel Alfaro
    * @since 2018-09-26
    * @return el o los registros que coincidan con el codigo o nombre del activo que se envia
    */
    public function get_activo_like($xsuc = null) {
        satelite_validar();
        $activo = ($this->input->post("producto") != "") ? $this->input->post("producto") : null;

        $where = null;
        $like = null;

        if ($activo != "") {
            //$where = '(act_estado = 1)';
            $like = "(act_nombre LIKE '%".$activo."%' OR act_codigo LIKE '%".$activo."%')";
        }
        if(trim($this->input->post("estado")) !='' ) {
            $where['act_estado'] = $this->input->post("estado");
        }
        $arreglo = array();
        if ($xsuc > 0) {
            $areasuc = ($this->input->post("are_suc_prm") != "") ? $this->input->post("are_suc_prm") : 0;
            $where["act_id_suc IN ($areasuc)"] = NULL;
        }
        $activos = $this->activo_fijo->get_activos_like($where, $like);
        if (count($activos) > 0) {
            $arreglo = $activos;
        }
        echo json_encode($arreglo);
    }

    public function get_responsable_like() {
        satelite_validar();
        $are_id = ($this->input->post("are_id")!= "") ? $this->input->post("are_id") : null;
        $empleado = ($this->input->post("empleado") != "") ? $this->input->post("empleado") : null;

        $where = null;
        $like = null;

        if ($empleado != "") {            
            $like = "(emp_nombre LIKE '%".$empleado."%' OR emp_apellido LIKE '%".$empleado."%' OR plz_nombre LIKE '%".$empleado."%')";
        }
        if($are_id != null){
            $where['are_id'] = $are_id;
        }
        if(trim($this->input->post("estado")) !='' ) {
            $where['emp_estado'] = $this->input->post("estado");
        }
        $arreglo = array();
        $empleados = $this->activo_fijo->empleados_activos_like($where, $like);
        if (count($empleados) > 0) {
            $arreglo = $empleados;
        }
        echo json_encode($arreglo);
    }

    /**
    * @author Israel Alfaro
    * @since 2018-09-27
    */
    public function toma_fisica_activo_fijo() {
        satelite_validar();
        if($_POST) {
            //$fecha_desde = date('Y-m-d', strtotime($this->input->post('txtFechaIni')));
            //$fecha_hasta = date('Y-m-d', strtotime($this->input->post('txtFechaFin')));
            $fecha_desde = ($this->input->post('txtFechaIni') !== "") ? date_format(date_create($this->input->post('txtFechaIni')),'Y-m-d') : null;        
            $fecha_hasta = ($this->input->post('txtFechaFin') !== "") ? date_format(date_create($this->input->post('txtFechaFin')),'Y-m-d') : null;        
            $sucursal    = ($this->input->post('sucursal') !== '') ? $this->input->post('sucursal') : null;
            $area        = ($this->input->post('area') !== '') ? $this->input->post('area') : null;
            $tipo_activo = ($this->input->post('slcTipoActivo') != "") ? $this->input->post('slcTipoActivo') : null;
            $costo_x     = ($this->input->post('slcCosto') !== '') ? $this->input->post('slcCosto') : null;
            $estado      = ($this->input->post('slcEstados') != '')?$this->input->post('slcEstados'):null;
            $valor_adq   = ($this->input->post('show_adq') != '') ? $this->input->post('show_adq') : null;
            $where = array();
            if ($costo_x !== null) {
                $where['act_id_cec'] = $this->input->post('slcCosto');
            }

            if($sucursal != null) {
                $where['act_id_suc'] = $sucursal;
            }

            if($tipo_activo != null) {
                $where['act_id_tac'] = $tipo_activo;
            }
            // if ($estado && $estado !== null && !is_array($estado)) {
            //     $where['act_estado'] = $estado;
            // } elseif ($estado !==null && is_array($estado) && count($estado) > 0) {
            //      $where['act_estado IN ('.implode(',', $estado).')'] = null;
            // }
            if ($estado != null && !is_array($estado)) {
                $where['act_estado'] = $estado;
            } elseif ($estado != null && is_array($estado) && count($estado) > 0) {
                $where['act_estado in ('.implode(',', $estado).')'] = null;
            }
            $typeReport = $this->input->post('typeReport');

            $activos = $this->activo_fijo->get_toma_fisica_activo_fijo($fecha_desde, $fecha_hasta, $area, $where);
            //echo $this->db->last_query(); die();
            $data['show_adq'] = $valor_adq;
            $data['activos'] = $activos;
            if ($typeReport == 'pdf') {
               // $data['show_adq'] = 0;
                ini_set('memory_limit ',2048);
                ini_set('max_execution_time',9999);
                $this->load->library('pdf');
                $data['tipo_reporte'] = $typeReport;
                $html  = $this->load->view('reporte/header', array('titulo' => 'Toma Física de Activo Fijo'), true);
                $html .= $this->load->view('activo/reportes/reporte_toma_fisica_act_fijo', $data, true);                  
                $reporte=$this->pdf->makePDF($html, 'L');
                $this->_cargarvista( null, $data );
            } else {
                $filename = 'reporte_toma_fisica_activo_fijo_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
                $data['titulo'] = 'Toma Fisica de Activo Fijo';
               // $data['show_adq'] = 0;
                $data['tipo_reporte'] = $typeReport;
                $data['excel'] = 1;
                $data['filename'] = $filename;
                $html = $this->load->view('activo/reportes/reporte_toma_fisica_act_fijo', $data, true);
                echo $html;
            } 
        } else {
            //Tipo como filtro de busqueda (Carlos Alberto Noyola 21-03-2019)
            $sucs = $this->gsatelite->get_dropdown('suc_sucursal', '{suc_codigo} {suc_nombre}', '', null, null, null, 'suc_id', true);
            $data['sucs'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'),'<option value=""></option>', $sucs);
            $tacs = $this->gsatelite->get_dropdown('tac_tipo_activofijo', '{tac_codigo} - {tac_nombre}', '', array('tac_estado'=>1), null, null, 'tac_id', true);
            $data['tact'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'),'<option value=""></option>', $tacs);
            $data['centro_costo'] =str_replace('<option value="0">Seleccione</option>', '',$this->gsatelite->get_dropdown('cec_centro_costo', ' {cec_nombre}', '', array('cec_estado' => 1), null, '', 'cec_id', true));

            $data['titulo_personal'] = "Toma Fisica de Activo Fijo";
            $this->_cargarvista( null, $data );  
        }

    }

    public function get_toma_fisica_activo_fijo() {
        satelite_validar();
        if ($_POST) {
            $where = array();
            $fecha_desde = ($this->input->post('txtFechaIni') != "") ?date_format(date_create($this->input->post('txtFechaIni')),'Y-m-d') : null;        
            $fecha_hasta = ($this->input->post('txtFechaFin') != "") ?date_format(date_create($this->input->post('txtFechaFin')),'Y-m-d') : null;
            $sucursal    = ($this->input->post('sucursal') !== '') ? $this->input->post('sucursal') : null;
            $area        = ($this->input->post('area') !== '') ? $this->input->post('area') : null;
            $tipo_activo = ($this->input->post('slcTipoActivo') != "") ? $this->input->post('slcTipoActivo') : '';
            $costo_x     = ($this->input->post('slcCosto') !== '') ? $this->input->post('slcCosto') : null;
            $estado      = ($this->input->post('slcEstados') !== '')?$this->input->post('slcEstados'):1;
            $valor_adq   = ($this->input->post('show_adq') != null)? $this->input->post('show_adq') : null;

            if ($costo_x !== null) {
                $where['act_id_cec'] = $this->input->post('slcCosto');
            }
            if ($estado && $estado !== null && !is_array($estado)) {
                $where['act_estado'] = $estado;
            } elseif ($estado !==null && is_array($estado) && count($estado) > 0) {
                 $where['act_estado IN ('.implode(',', $estado).')'] = null;
            }
            //Tipo como filtro de busqueda (Carlos Alberto Noyola 21-03-2019)
            if($tipo_activo != null) {
                $where['act_id_tac'] = $tipo_activo;
            }
            if($sucursal != null) {
                $where['act_id_suc'] = $sucursal;
            }

            $activos = $this->activo_fijo->get_toma_fisica_activo_fijo($fecha_desde, $fecha_hasta, $area, $where);
            $data['activos'] = $activos;
            $data['show_adq'] = $valor_adq;
            $html = $this->load->view('activo/reportes/detalle_toma_fisica_activo', $data, true);
            echo $html;
        }
    }

    public function activo_dado_baja_retirado() {
        satelite_validar();
        if ($_POST) {
            //$fecha_desde = date('Y-m-d', strtotime($this->input->post('txtFechaDesde')));
            //$fecha_hasta = date('Y-m-d', strtotime($this->input->post('txtFechaHasta')));
            $fecha_desde = ( $this->input->post('txtFechaDesde') != "") ? date_format(date_create($this->input->post('txtFechaDesde')),'Y-m-d') : null;
            $fecha_hasta = ( $this->input->post('txtFechaHasta') != "") ? date_format(date_create($this->input->post('txtFechaHasta')),'Y-m-d') : null;
            $tipo         = ( $this->input->post('slcTipo') != null) ? $this->input->post('slcTipo') : null;
            $departamento = ( $this->input->post('slcDepartamento') != "") ? $this->input->post('slcDepartamento') : null;
            $tipo_activo  = ( $this->input->post('slcTipoActivo') != "") ? $this->input->post('slcTipoActivo') : null;
            
            $where = array();
            if ($departamento != null ) {
                $where['act_id_are'] = $departamento;
            }
            if($tipo_activo != null) {
                $where['act_id_tac'] = $tipo_activo;
            }
            if (($fecha_desde != '') && ($fecha_hasta != '') ) {
                $filtro_titulo = 'Desde: '.date_format(date_create($fecha_desde),'d-m-Y').' '.'Hasta: '.date_format(date_create($fecha_hasta),'d-m-Y');
            }
            $where['act_estado'] = 0;
            $activos = $this->activo_fijo->get_activos_retirados_dados_baja($fecha_desde, $fecha_hasta, $tipo, $where);
            $tipo_reporte = $this->input->post('tipo_reporte');
            switch ($tipo_reporte) {
                case 'excel':
                    $data['activos'] = $activos;
                    $data['tiporepo'] = $tipo_reporte;
                    $html = $this->load->view('activo/reportes/reporte_activo_baja_retirado', $data, true); 
                    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                    header("Content-Disposition: attachment;filename=activo_dado_baja_retirado".date('d-m-Y_His').".xls");
                    header("Pragma: no-cache");
                    header("Expires: 0");
                    echo '<meta charset="utf-8" />';
                    echo "<table border='0'>
                    <tr><th colspan='10' align='center' >".mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'),'UTF-8')."</th></tr>
                    <tr><th colspan='10' align='center' >Reporte de Activos Fijos Retirados o Dados de Baja</th></tr>
                    <tr><th colspan='10' align='center' >".$filtro_titulo. "</th></tr>
                    </table>";
                    echo $html; die();
                break;                
                case 'pdf':
                    $data['activos'] = $activos;
                    $data['tiporepo'] = $tipo_reporte;
                    $this->load->library('pdf');
                    $html  = $this->load->view('reporte/header', array('titulo' => 'Listado de los Activos Fijos Retirados<br>'.$filtro_titulo.''), true);
                    $html .= $this->load->view('activo/reportes/reporte_activo_baja_retirado', $data, true);                  
                    $reporte=$this->pdf->makePDF($html, 'L');
                break;
            }
            $this->_cargarvista( null, $data );
        } else {
            //Departamento y tipo como filtro de busqueda (Carlos Alberto Noyola 21-03-2019)
            $tipo_activo = $this->gsatelite->get_dropdown('tac_tipo_activofijo', '{tac_codigo} - {tac_nombre}', '', array('tac_estado'=>1), null, null, 'tac_id', true);
            $data['tipo_activo'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $tipo_activo);
            $departamento = $this->gsatelite->get_dropdown('are_area', '{are_nombre}', '', array('are_estado' => 1), null, '', 'are_id', true);
            $data['departamento'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $departamento);
            $data['centro_costo'] =str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '',$this->gsatelite->get_dropdown('cec_centro_costo', ' {cec_nombre}', '', array('cec_estado' => 1), null, '', 'cec_id', true));
            $data['titulo_personal'] = "Reporte de Activos Fijos Retirados o Dados de Baja";
            $this->_cargarvista(null, $data );
        }
    }

    public function get_activo_dado_baja_retirado() {
        satelite_validar();
        $where_activo = array();
        $costo_x = ( $this->input->post('slcCosto') != "") ? $this->input->post('slcCosto') : null;      
        if ($costo_x !== null) {
            $where_activo['act_id_cec'] = $this->input->post('slcCosto');
        } 
        $fecha_desde = ( $this->input->post('txtFechaDesde') != "") ? date_format(date_create($this->input->post('txtFechaDesde')),'Y-m-d') : null;
        $fecha_hasta = ( $this->input->post('txtFechaHasta') != "") ? date_format(date_create($this->input->post('txtFechaHasta')),'Y-m-d') : null;
        //Departamento y tipo como filtro de busqueda (Carlos Alberto Noyola 21-03-2019)
        $departamento = ( $this->input->post('slcDepartamento') != "") ? $this->input->post('slcDepartamento') : null;
        $tipo_activo = ( $this->input->post('slcTipoActivo') != "") ? $this->input->post('slcTipoActivo') : null;
        $where_activo['act_estado'] = 0;
        if ($departamento) {
            $where_activo['act_id_are'] = $departamento;
        }
        if($tipo_activo) {
            $where_activo['act_id_tac'] = $tipo_activo;
        }
        $tipo        = ( $this->input->post('slcTipo') != null) ? $this->input->post('slcTipo') : null;        
        $activos = $this->activo_fijo->get_activos_retirados_dados_baja($fecha_desde, $fecha_hasta, $tipo, $where_activo);
        $data['activos'] = $activos;
        $html = $this->load->view('activo/reportes/detalle_dado_baja_retiro', $data, true);
        echo $html;
    }
    
    /**
    * @author Mario Marquez
    * @since 2018-10-14
    * @return Activos por Area
     */
    // public function rpt_activo_area()
    // {

    //     satelite_validar();
    //     if($_POST){
    //         print_r($_POST);die();
    //     }else{

    //     $permisos = $this->gsatelite->get_permisos_opcion();
    //     $data['permisos']=$permisos;
    //     $data['areas'] = $this->gsatelite->get_dropdown('are_area', '{are_nombre}', '', array('are_estado'=>1), null, null, 'are_id', true);
    //     //Departamento y tipo como filtro de busqueda (Carlos Alberto Noyola 21-03-2019)
    //     $tipo_activo = $this->gsatelite->get_dropdown('tac_tipo_activofijo',
    //      '{tac_nombre}', '', array('tac_estado'=>1), null, null, 'tac_id', true);
    //     $data['tipo_activo'] = '<option value="">Todos</option>'.str_replace('<option value="0">Seleccione</option>',
    //      '<option value=""></option>', $tipo_activo);

    //     $departamento = $this->gsatelite->get_dropdown('are_area',
    //      '{are_nombre}', '', array('are_estado' => 1), null, '', 'are_id', true);
    //     $data['departamento'] = str_replace('<option value="0">Seleccione</option>',
    //      '<option value=""></option>', $departamento);
    //     $data['centro_costo'] =str_replace('<option value="0">Seleccione</option>', '',$this->gsatelite->get_dropdown('cec_centro_costo', ' {cec_nombre}', '', array('cec_estado' => 1), null, '', 'cec_id', true));
    //     }
    //     $data['titulo_personal'] = "Listado de activos por área";
    //     cargarvista($data);
    // }
    
    /**
    * @author Mario Marquez
    * @since 2018-10-15
    * @return filtrar reporte Pagos a factura detallado
     */
    public function filtrar_activo_area($es_reporte=0)
    {   
        //print_r($_POST); die();
        satelite_validar();
        $registros = array();
        //$permisos = $this->gsatelite->get_permisos_opcion('cuentas_cobrar_detallado');
        //$data['permisos']=$permisos;
        $txtFecha_desde = ( $this->input->post('txtFechaIni') != "") ? $this->formato_fecha($this->input->post('txtFechaIni')) : null;
        $txtFecha_hasta = ( $this->input->post('txtFechaFin') != "") ? $this->formato_fecha($this->input->post('txtFechaFin')) : null;

        //$txtFecha_desde =  $this->input->post('txtFechaIni');
        //$txtFecha_hasta = $this->input->post('txtFechaFin');

        $where_activo = array();
        //Departamento y tipo como filtro de busqueda (Carlos Alberto Noyola 21-03-2019)
        $departamento = ( $this->input->post('slcDepartamento') != "") ? $this->input->post('slcDepartamento') : null;
        $tipo_activo = ( $this->input->post('slcTipoActivo') != "") ? $this->input->post('slcTipoActivo') : null;
        //echo $tipo_activo;

        $costo_x = ( $this->input->post('slcCosto') != "") ? $this->input->post('slcCosto') : null;
        
        
            
        if ($costo_x !== null) {
          $where_activo['act_id_cec'] = $this->input->post('slcCosto');
      } 
      // this
        $estado = ($this->input->post('slcEstados')!== null)?$this->input->post('slcEstados'):null;

         if ((is_array($estado)) && (count($estado) >0)) {
                    $estado2 = $estado;
                    $a =array_search('3', $estado2);
                    if($a){
                        $where_activo['act_depreciable'] = 0;
                        unset($estado2[$a]);
                    }
                    $in = implode(',', $estado2);
                    $where_activo['act_estado IN('.$in.')'] = null;
                    
               
            }

          $estate = ($this->input->post('slcEstados2') !=''?$this->input->post('slcEstados2'):null);  

        if ($estate !== null) {
            $est  = explode(',', $estate);
            $a =array_search('3', $est);
            if($a){
                    $where_activo['act_depreciable'] = 0;
                    unset($est[$a]);
                }
                    $in = implode(',', $est);
                    $where_activo['act_estado IN('.$in.')'] = null;
        }

        if ($departamento != null ) {
                    $where_activo['act_id_are'] = $departamento;
                }
        if($tipo_activo != null) {
                    $where_activo['act_id_tac'] = $tipo_activo;
                }
        if($txtFecha_desde!='' || $txtFecha_hasta!=''){
            //$where_activo['DATE(act_fecha_adq) >='] = formatear_fecha('Y-m-d',$txtFecha_desde );
            //$where_activo['DATE(act_fecha_adq) <='] = formatear_fecha('Y-m-d',$txtFecha_hasta );
        }

        if ($txtFecha_desde != null) {
            $where_activo['date_format(act_fecha_adq,"%Y-%m-%d") >='] = date_format(date_create($txtFecha_desde),"Y-m-d");
        }
        if ($txtFecha_hasta != null) {
            $where_activo['date_format(act_fecha_adq,"%Y-%m-%d") <='] = date_format(date_create($txtFecha_hasta),'Y-m-d');
        }
        
        $registros = $this->activo_fijo->get_activos_area($where_activo);
        //print_r($this->db->last_query()); die();
        $data['es_reporte']=$es_reporte;
        
        $data['txtFecha_desde'] = $txtFecha_desde;
        $data['estado']         =  implode(',',$estado);
        $data['txtFecha_hasta'] = $txtFecha_hasta;
        $data['departamento']   = $departamento;
        $data['txtTipo_activo'] = $tipo_activo;
        $data['costo'] = $this->input->post('slcCosto');
        $data['periodo'] = date_format(date_create($txtFecha_desde), 'd-m-Y') . ' A ' . date_format(date_create($txtFecha_hasta), 'd-m-Y');
        $data['registros'] = $registros;
        $html = $this->load->view('activo/reportes/filtrar_activo_area', $data, true);
        if ($es_reporte) {
            $tipo_accion = $this->input->post('tipo_accion');
            $filtro_titulo = ($txtFecha_desde==$txtFecha_hasta)? "De: ".date_format(date_create($txtFecha_desde), 'd-m-Y'):"De: ".$data['periodo'];
            if ($tipo_accion) { //excel
                header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                header("Content-Disposition: attachment;filename=reporte_activos_area".date('d-m-Y_His').".xls");
                header("Pragma: no-cache");
                header("Expires: 0");
                echo '<meta charset="utf-8" />';
                echo "<table border='0'>
                  <tr><th colspan='10' align='center' >".mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'),'UTF-8')."</th></tr>
                  <tr><th colspan='10' align='center' >Reporte Activos por Área</th></tr>
                  <tr><th colspan='10' align='center' >".$filtro_titulo. "</th></tr>
                  </table>";
                echo $html; die();
            } else { //pdf
                $this->load->library('pdf');
                $html_header=$this->load->view('reporte/header', array('titulo' => "Reporte Activos Área <br /> $filtro_titulo", 'solotitulo'=> true), true);
                $html = str_replace('border="1" style="margin-left: 4px; width: 99%; font-size:12px;"','border="0.5" style="width: 100%; font-size:9px;"',$html);
                $this->pdf->makePDF($html_header.$html,'lanscape', 'reporte_activos_area','Legal');
                die();
            }
        }
        echo json_encode(array('html'=>$html));
    }
    
     /**
    * @author Mario Marquez
    * @since 2018-10-14
    * @return Activos por Area
     */
    public function rpt_adquisicion_activo()
    {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();
        //Departamento y tipo como filtro de busqueda (Carlos Alberto Noyola 21-03-2019)
        $tipo_activo = $this->gsatelite->get_dropdown('tac_tipo_activofijo', '{tac_codigo} - {tac_nombre}', '', array('tac_estado'=>1), null, null, 'tac_id', true);
        $departamento = $this->gsatelite->get_dropdown('are_area', '{are_prefijo} {are_nombre}', '', array('are_estado' => 1), null, '', 'are_id', true);
        $data['tipo_activo'] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $tipo_activo);
        $data['departamento'] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $departamento);
        $data['centro_costo'] =str_replace('<option value="0">Seleccione</option>', '',$this->gsatelite->get_dropdown('cec_centro_costo', '{cec_codigo} - {cec_nombre}', '', array('cec_estado' => 1), null, '', 'cec_id', true));
        $data['permisos']=$permisos;
        $data['titulo_personal'] = "Listado de adquisición de activos";
        cargarvista($data);
    }
    
    
    /**
    * @author Mario Marquez
    * @since 2018-10-16
    * @return filtrar reporte Adquisiciones de Activos
     */
    public function filtrar_adquisicion_activo($es_reporte=0){
        satelite_validar();
        ini_set('memory_limit', '1024M');
        ini_set('max_execution_time', '99999');
        $registros = array();
        $txtFecha_desde = ( $this->input->post('txtFechaIni') != "") ? $this->input->post('txtFechaIni') : null;        
        $txtFecha_hasta = ( $this->input->post('txtFechaFin') != "") ? $this->input->post('txtFechaFin') : null;        
        //Departamento y tipo como filtro de busqueda (Carlos Alberto Noyola 21-03-2019)
        $departamento = ( $this->input->post('slcDepartamento') != "") ? $this->input->post('slcDepartamento') : '';
        $tipo_activo = ( $this->input->post('slcTipoActivo') != "") ? $this->input->post('slcTipoActivo') : '';
        $costo_x = ( $this->input->post('slcCosto') != "") ? $this->input->post('slcCosto') : null;        
        $fecha_depre = ( $this->input->post('ini_deprep') != "") ? $this->input->post('ini_deprep') : null;
        $where_activo = array();        
        if ($txtFecha_desde) {
            $where_activo['DATE(act_fecha_adq) >='] = formatear_fecha('Y-m-d',$txtFecha_desde );
        }
        if ($txtFecha_hasta) {
            $where_activo['DATE(act_fecha_adq) <='] = formatear_fecha('Y-m-d',$txtFecha_hasta );
        }
        if ($departamento != null ) {
            $where_activo['act_id_are'] = $departamento;
        }
        if($tipo_activo != null) {
            $where_activo['act_id_tac'] = $tipo_activo;
        }        
        if ($costo_x !== null) {
            $where_activo['act_id_cec'] = $this->input->post('slcCosto');
        }
        if ($fecha_depre != null) {
            $where_activo['DATE(act_fecha_inicia_dep)'] = formatear_fecha('Y-m-d', $fecha_depre );
        } 
        $registros_activos = $this->activo_fijo->get_adquisicion_activo($where_activo);        
        $data['es_reporte']=$es_reporte;
        $data['txtFecha_desde'] = $txtFecha_desde;
        $data['costo'] = $this->input->post('slcCosto');
        $data['departamento'] = $departamento;
        $data['txtFecha_hasta'] = $txtFecha_hasta;
        $data['txtFechaDepre'] = $fecha_depre;
        $data['tipo_activo'] = $tipo_activo;
        $data['periodo'] = date_format(date_create($txtFecha_desde), 'd-m-Y') . ' A ' . date_format(date_create($txtFecha_hasta), 'd-m-Y');
        $data['registros'] = $registros_activos;
        //var_dump($data['registros']);die();
        $html = $this->load->view('activo/reportes/filtrar_adquisicion_activo', $data, true);
        if ($es_reporte) {
            $tipo_accion = $this->input->post('tipo_accion');
            $filtro_titulo = ($txtFecha_desde==$txtFecha_hasta)? "De: ".date_format(date_create($txtFecha_desde), 'd-m-Y'):"De: ".$data['periodo'];
            if ($tipo_accion) { //excel
                header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                header("Content-Disposition: attachment;filename=reporte_adquisicion_activos_".date('d-m-Y_His').".xls");
                header("Pragma: no-cache");
                header("Expires: 0");
                echo '<meta charset="utf-8" />';
                echo "<table border='0'>
                  <tr><th colspan='10' align='center' >".mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'),'UTF-8')."</th></tr>
                  <tr><th colspan='10' align='center' >Reporte Adquisición de Activos</th></tr>
                  <tr><th colspan='10' align='center' >".$filtro_titulo. "</th></tr>
                  </table>";
                echo $html; die();
            } else { //pdf
                $html_header=$this->load->view('reporte/header', array('titulo' => "Reporte Adquisición de Activos <br /> $filtro_titulo", 'solotitulo'=> true), true);
                $html = str_replace('border="1" style="margin-left: 4px; width: 99%; font-size:12px;"','border="0.5" style="width: 100%; font-size:9px;"',$html);
                $this->pdf->makePDF($html_header.$html,'lanscape', 'reporte_adquisicion_activos','Legal');
                die();
            }
        }
        echo json_encode(array('html'=>$html));
    }
    
    
     /**
    * @author Mario Marquez
    * @since 2018-10-14
    * @return Activos por Area
     */
    public function rpt_activos_depreciados()
    {
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();

        $tipo_activo = $this->gsatelite->get_dropdown('tac_tipo_activofijo', '{tac_codigo} - {tac_nombre}', '', array('tac_estado'=>1), null, null, 'tac_id', true);
        $data['tipo_activo'] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $tipo_activo);



        $departamento = $this->gsatelite->get_dropdown('are_area', '{are_nombre}', '', array('are_estado' => 1), null, '', 'are_id', true);
        $data['departamento'] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $departamento);

        $data['centro_costo'] =str_replace('<option value="0">Seleccione</option>', '',$this->gsatelite->get_dropdown('cec_centro_costo', ' {cec_nombre}', '', array('cec_estado' => 1), null, '', 'cec_id', true));

        $data['permisos']=$permisos;
        $data['titulo_personal'] = "Listado de activos depreciados";
        cargarvista($data);
    }
    /**
    * @author Mario Marquez
    * @since 2018-10-16
    * @return filtrar reporte Adquisiciones de Activos
     */
    public function filtrar_activos_depreciados($es_reporte=0)
    {
        satelite_validar();
        $registros = array();
        // print_r($_POST); die();
        //$permisos = $this->gsatelite->get_permisos_opcion('cuentas_cobrar_detallado');
        //$data['permisos']=$permisos;
        //$txtFecha_desde =  $this->formato_fecha($this->input->post('txtFechaIni'));
        //$txtFecha_hasta = $this->formato_fecha($this->input->post('txtFechaFin'));
        $txtFecha_desde = ( $this->input->post('txtFechaIni') != "") ? $this->formato_fecha($this->input->post('txtFechaIni')) : null;        
        $txtFecha_hasta = ( $this->input->post('txtFechaFin') != "") ? $this->formato_fecha($this->input->post('txtFechaFin')) : null;

        //Departamento y tipo como filtro de busqueda (Carlos Alberto Noyola 20-03-2019)
        $departamento = ( $this->input->post('slcDepartamento') != "") ? $this->input->post('slcDepartamento') : '';
        $tipo_activo = ( $this->input->post('slcTipoActivo') != "") ? $this->input->post('slcTipoActivo') : '';
        // estado del activo
        $estado  = ( $this->input->post('slcEstados') != "")?$this->input->post('slcEstados'):null;
        $where_activo = array();
        $costo_x = ( $this->input->post('slcCosto') != "") ? $this->input->post('slcCosto') : null;        
        if ($costo_x !== null) {
            $where_activo['act_id_cec'] = $this->input->post('slcCosto');
        } 
        if($txtFecha_desde){
            $where_activo['date_format(act_fecha_adq,"%Y-%m-%d") >='] =date_format(date_create($txtFecha_desde),'Y-m-d');
        }
        if($txtFecha_hasta){
            $where_activo['date_format(act_fecha_adq,"%Y-%m-%d") <='] = date_format(date_create($txtFecha_hasta),'Y-m-d');
        }
        if ($departamento != null ) {
            $where_activo['act_id_are'] = $departamento;
        }
        if($tipo_activo != null) {
            $where_activo['act_id_tac'] = $tipo_activo;
        }
        if ($estado != null) {
            $where_activo['act_estado'] = $estado;
        }elseif ($estado == 0) {
            $where_activo['act_estado >='] = 0;
        }
    
        $where_activo['act_depreciable'] = 1;
        $where_activo['act_valor_residual = act_valor_residual'] = null;
        $where_activo['act_valor_cont > 0'] = null;        
        $registros_activos = $this->activo_fijo->get_activos_depreciados($where_activo);
        // print_r($this->db->last_query()); die();
        $data['es_reporte']=$es_reporte;
        //var_dump($registros);die();
        $data['txtFecha_desde'] = $txtFecha_desde;
        $data['txtFecha_hasta'] = $txtFecha_hasta;
        $data['departamento'] = $departamento;
        $data['tipo_activo'] = $tipo_activo;
        $data['costo'] = $this->input->post('slcCosto');
        $data['periodo'] = date_format(date_create($txtFecha_desde), 'd-m-Y') . ' A ' . date_format(date_create($txtFecha_hasta), 'd-m-Y');
        $data['registros'] = $registros_activos;
        //var_dump($data['registros']);die();
        $html = $this->load->view('activo/reportes/filtrar_activos_depreciados', $data, true);
        if ($es_reporte) {
            $tipo_accion = $this->input->post('tipo_accion');
            $filtro_titulo = ($txtFecha_desde==$txtFecha_hasta)? "De: ".date_format(date_create($txtFecha_desde), 'd-m-Y'):"De: ".$data['periodo'];
            if ($tipo_accion) { //excel
                header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                header("Content-Disposition: attachment;filename=reporte_activos_depreciados_".date('d-m-Y_His').".xls");
                header("Pragma: no-cache");
                header("Expires: 0");
                echo '<meta charset="utf-8" />';
                echo "<table border='0'>
                  <tr><th colspan='10' align='center' >".mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'),'UTF-8')."</th></tr>
                  <tr><th colspan='10' align='center' >Reporte Activos Depreciados</th></tr>
                  <tr><th colspan='10' align='center' >".$filtro_titulo. "</th></tr>
                  </table>";
                echo $html; die();
            } else { //pdf
                $this->load->library('pdf');
                $html_header=$this->load->view('reporte/header', array('titulo' => "Reporte Activos Depreciados <br /> $filtro_titulo", 'solotitulo'=> true), true);
                $html = str_replace('border="1" style="margin-left: 4px; width: 99%; font-size:12px;"','border="0.5" style="width: 100%; font-size:9px;"',$html);
                $this->pdf->makePDF($html_header.$html,'lanscape', 'reporte_activos_depreciados','Legal');
                die();
            }
        }
        echo json_encode(array('html'=>$html));
    }

    /**
    * @author RENE CASTANEDA
    * @since 2018-10-16
    * @return imprimir viñeta de activo
     */
    public function imprimir_vinetas_activo($id_activo = 0, $num_posicion=1, $genera_pdf = 0)
    {
        satelite_validar();
        $activo = $this->activo_fijo->get_reporte_codigo_activo(array('act_id'=>$id_activo));
        $data['reg_activo'] = $activo[0];
        $data['num_posicion'] = $num_posicion;
        $data["genera_pdf"] = $genera_pdf;
        if ($num_posicion == 0) {
           die("<h2>Seleccione posición</h2>");
        }
        if ($genera_pdf) 
        {
            $this->load->library('pdf');
            $html = $this->load->view('activo/reportes/imprimir_vinetas_activo_print', $data, true);  
            //die($html);  

            $this->pdf->setPrintFooter(false); 
            $this->pdf->IncludeJS("print(true)");             
            //makePDF($output, $orientacion = '', $reporte = '', $formato = 'Letter', $salida = 'I', $margenes = null)
            $arrayName = array('0' => 2, '1' => 20, '2' => 0 );
            try {
                $this->pdf->makePDF($html,'','','Letter','I',$arrayName);
            } catch (Exception $e) {
                echo 'Excepción capturada: ',  $e->getMessage(), "\n";
            }
            
        }

        $this->gsatelite->cargar_vista_masterpage('activo/reportes/imprimir_vinetas_activo', $data);
    }

    /**
    * @author René Castaneda
    * @since 2018-10-17
    * @return/descripción generación de reporte de depreciación de consolidado
     */
    public function depreciacion_consolidada(){   
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();
        $data['permisos'] = $permisos;
        $data['historico'] = $this->gsatelite->count('dph_depreciacion_historica', array('dph_estado' => 1));
        $data['slcTipoActivo'] = $this->gsatelite->get_dropdown('tac_tipo_activofijo', '{tac_codigo} - {tac_nombre}','', array('tac_estado' => '1'), null, '', 'tac_id', true);
        $data['slcArea'] = $this->gsatelite->get_dropdown('are_area', '{are_nombre}','', array('are_estado' => '1'), null, '', 'are_id', true);
        $tipo_activo = $this->gsatelite->get_dropdown('tac_tipo_activofijo', '{tac_codigo} - {tac_nombre}', '', array('tac_estado'=>1), null, null, 'tac_id', true);
        $data['tipo_activo'] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $tipo_activo);
        $departamento = $this->gsatelite->get_dropdown('are_area', '{are_nombre}', '', array('are_estado' => 1), null, '', 'are_id', true);
        $data['departamento'] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $departamento);
        $agrupaciones = $this->gsatelite->get_dropdown('agr_agrupacion_activos','{agr_codigo} {agr_nombre}', '', array('agr_estado'=>1),null,'','agr_id',true);
        $data['agrupaciones'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $agrupaciones);
                    $this->db->join('cnt_cuenta_contable', 'cnt_id = dtv_id_cnt');
        $cntsXact = $this->gsatelite->get_dropdown('dtv_detalle_tipo_activo','{cnt_nombre}', '', array('cnt_estado'=>1,'dtv_estado'=>1),null,'','dtv_id',true);
        $data['ctaContAct'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $cntsXact);
        $data['centro_costo'] = str_replace('<option value="0">Seleccione</option>', '',$this->gsatelite->get_dropdown('cec_centro_costo', ' {cec_nombre}', '', array('cec_estado' => 1), null, '', 'cec_id', true));
        $data['titulo_personal'] = "Reporte depreciación consolidada";
        cargarvista($data);
    }

    /**
    * @author René Castaneda
    * @since 2017-09-20
    * @return filtrar los activos y su depreciación.
     */

    public function filtrar_depreciacion_consolidada($es_reporte=0){   
        satelite_validar();
        $registros = $where = $where2 = array();
        $data['permisos'] = $this->gsatelite->get_permisos_opcion('depreciacion_consolidada');
        $txtFecha_desde = '01-0001';
        $txtFecha_hasta = ($this->input->post('txtFecha_hasta') != "") ? $this->input->post('txtFecha_hasta') : date("m-Y");
        $departamento = ($this->input->post('departamento') != "") ? $this->input->post('departamento') : '';
        $tipo_activo = ( $this->input->post('tipo_activo') != "") ? $this->input->post('tipo_activo') : '';
        $agrupacion = ( $this->input->post('agrupacion') != "") ? $this->input->post('agrupacion') : null;
        $cta_ctble = ( $this->input->post('cta_ctble') > 0) ? $this->input->post('cta_ctble') : null;
        $estado = ($this->input->post('estado') != '') ? $this->input->post('estado') : NULL;
        $costo_x = ( $this->input->post('slcCosto') != "") ? $this->input->post('slcCosto') : null;
        $hay_agrupacion = $this->gsatelite->count('agr_agrupacion_activos', array('agr_estado' => 1));
        $hay_historicos = $this->gsatelite->count('dph_depreciacion_historica', array('dph_estado' => 1));        
        if ($costo_x !== null) {
            $where['act_id_cec'] = $this->input->post('slcCosto');
            $where3['act_id_cec'] = $this->input->post('slcCosto');
        } 
        if (is_null($estado) && $hay_historicos > 0 && $hay_agrupacion > 0) {
            $estado = array("'0'","'1'","'2'");
        }
        $where_baja = "";
        if ($estado !== null) {
            if ((is_array($estado)) and (count($estado)>0)) {
                for ($qe=0; $qe < count($estado) ; $qe++) {
                    if ($estado[$qe] == "'0'") {
                        $hasta_baja = formatear_fecha('Y-m-t',('01-'.$txtFecha_hasta));
                        unset($estado[$qe]);
                        $where_baja = "1";
                        $where2["act_estado IN (0)"] = null;
                        $where2["DATE(act_fecha_desact) >"] = $hasta_baja;
                    }
                }
                $estados = implode(',', $estado);
                $where["act_estado IN (".$estados.")"] = null;
                $where3["act_estado IN (".$estados.")"] = null;
            }
        }
        if ($departamento != null ) {
            $where['act_id_are'] = $departamento;
            $where2['act_id_are'] = $departamento;
            $where3['act_id_are'] = $departamento;
        }
        if($tipo_activo != null) {
            $where['act_id_tac'] = $tipo_activo;
            $where2['act_id_tac'] = $tipo_activo;
            $where3['act_id_tac'] = $tipo_activo;
        }
        if ($cta_ctble > 0) {
            $tacrow = $this->gsatelite->get_registro("dtv_detalle_tipo_activo", array("dtv_id" => $cta_ctble));
            $where['tac_id'] = $tacrow->dtv_id_tac;
            $where2['tac_id'] = $tacrow->dtv_id_tac;
            $where3['tac_id'] = $tacrow->dtv_id_tac;
        }
        if($agrupacion > 0) {
            $where['grp_id_agr'] = $agrupacion;
            $where2['grp_id_agr'] = $agrupacion;
        }
        $where['act_depreciable'] = '1';
        $where2['act_depreciable'] = '1';
        $where3['act_depreciable'] = '1';//CASO SERSAPROSA CON SU VISTA _V2
        $data["anio_periodo"] = date("Y");
        $a_detalle = 0;
        if ($this->input->post()) {
            $a_detalle = ($this->input->post("a_detalle") > 0) ? 1 : 0;
            if ($txtFecha_hasta !='') {
                $txtFecha_desde = formatear_fecha('Y-01-01', ('01-'.$txtFecha_desde));
                $txtFecha_hasta = formatear_fecha('Y-m-d', ('01-'.$txtFecha_hasta));
                $data["anio_periodo"] = formatear_fecha('Y', ($txtFecha_hasta));
            }
        }
        $group_by = ($hay_historicos > 0 && $hay_agrupacion > 0) ? array('agr_orden'=>'ASC','act_id_are'=>'ASC') : array('act_id_tac'=>'ASC','act_id_are'=>'ASC');
        $data['where1'] = (count($where)>0)? json_encode($where):'';
        $data['where2'] =  (count($where2)>0)? json_encode($where2):'';
        $data['where3'] =  (count($where3)>0)? json_encode($where3):'';
        if(trim($this->input->post('where1')) != '') {
            $where = (array) json_decode(trim($this->input->post('where1')));
        }
        if(trim($this->input->post('where2')) != '') {
            $where2 = (array) json_decode(trim($this->input->post('where2')));
        }
        if(trim($this->input->post('where3')) != '') {
            $where3 = (array) json_decode(trim($this->input->post('where3')));
        }
        ini_set('post_max_size','4000M');
        ini_set('memory_limit', '4000M' );
        ini_set('max_execution_time', '99999');
        // CASO SERSAPROSA / CASO GNAL  | DESCOMENTAR UNO U OTRO
        $sig_emp = strtolower(trim($this->gsatelite->get_parametro('SYS_SIGLAS')));
        if ($sig_emp == 'sersaprosa') {
            $registros = $this->activo_fijo->get_depreciacion_activo2($where3, $group_by, $txtFecha_desde, $txtFecha_hasta);//SERSA
        } else {
            if ($hay_historicos > 0 && $hay_agrupacion > 0) {
                $registros = $this->activo_fijo->get_depreciacion_activo_historico($where, $group_by,$txtFecha_desde, $txtFecha_hasta);//GNAL
            } else {
                $registros = $this->activo_fijo->get_depreciacion_activo($where, $group_by,$txtFecha_desde, $txtFecha_hasta);//GNAL            
            }
        }
        if(trim($where_baja) !='') {
            if ($hay_historicos > 0 && $hay_agrupacion > 0) {
                $registros2 = $this->activo_fijo->get_depreciacion_activo_historico($where2, $group_by,$txtFecha_desde, $txtFecha_hasta);//GNAL
            } else {
                $registros2 = $this->activo_fijo->get_depreciacion_activo($where2, $group_by,$txtFecha_desde, $txtFecha_hasta);
            }
            if (count($registros2) > 0) {
                if ($hay_historicos > 0 && $hay_agrupacion > 0) {
                    $registros = array_merge($registros,$registros2); //unificar querys
                    usort($registros, function ($a, $b) { return $a['agr_id'] - $b['agr_id']; });
                } else {
                    $registros = array_merge($registros,$registros2); //unificar querys
                    usort($registros, function ($a, $b) { return $a['act_id_tac'] - $b['act_id_tac']; });
                }                
            }
        }
        $data['es_reporte'] = $es_reporte;
        $data["a_detalle"] = $a_detalle;
        $data['txtFecha_hasta'] = $this->input->post('txtFecha_hasta');
        $data['txtFecha_desde'] = $txtFecha_desde; 
        $data['departamento'] = $departamento;
        $data['tipo_activo'] = $tipo_activo;
        $data['agrupacion'] = $agrupacion;
        $data['cta_contable'] = $cta_ctble;
        $data['tipo_estado'] = (is_array($estado)) ? implode(',', $estado):$estado;
        $data['costo'] = $costo_x;
        $data['registros'] = $registros;
        $data['anio_hasta'] = formatear_fecha('Y',$txtFecha_hasta);
        $data['fecha_hasta'] = $txtFecha_hasta;
        if ($sig_emp == 'sersaprosa') {
            $html = $this->load->view('activo/reportes/filtrar_depreciacion_consolidada_v2', $data, true);
        } elseif ($sig_emp == 'isdemu') {
            $html = $this->load->view('activo/reportes/filtrar_depreciacion_consolidada_isdemu', $data, true);
        } else {
            if ($hay_historicos > 0 && $hay_agrupacion > 0) {
                $html = $this->load->view('activo/reportes/filtrar_depreciacion_consolidada_agr', $data, true);
            } else {
                $html = $this->load->view('activo/reportes/filtrar_depreciacion_consolidada', $data, true);
            }
        }
        // $html2 = str_replace(array("ó", "ó", "ñ", "Ñ"), array("&oacute;", "&Oacute;", "&ntilde;", "&Ntilde;"), $html);
        // var_dump($html2);die();
        $filtro_titulo = "";
        if ($es_reporte) {
            $tipo_accion = $this->input->post('tipo_accion');
            $filtro_titulo .= ($departamento > 0) ? "Área: ".$this->gsatelite->get_campo('are_area','are_nombre',array('are_id'=>$departamento))."<br />" : "Área: Todas las áreas<br />";
            $filtro_titulo .= ($tipo_activo > 0) ? "Tipo: ".$this->gsatelite->get_campo('tac_tipo_activofijo','tac_nombre',array('tac_id'=>$tipo_activo))."<br />" :  "Tipo: Todos los tipos<br />";
            $filtro_titulo .= ($txtFecha_desde != '' && $txtFecha_desde != '0001-01-01') ? " Desde: ".$txtFecha_desde : "";
            $filtro_titulo .= ($txtFecha_hasta !='' ) ? " Hasta: ".formatear_fecha('t-m-Y',$txtFecha_hasta):"";
            if ($tipo_accion) { //excel
                // $this->load->library('excelphp');
                // $this->excelphp->crear_excel('depreciacion_activos',$html2);
                // die();
                header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                header("Content-Disposition: attachment;filename=depreciacion_activos_".date('d-m-Y_His').".xls"); 
                header("Pragma: no-cache");
                header("Expires: 0");
                echo '<meta charset="utf-8" />';
                echo '<img src="'.base_url().'media/imagenes/sistema/'.$this->gsatelite->get_parametro('SYS_LOGOTIPO').'.png" width="108px" height="48">';
                echo "<table border='0'>
                  <tr><th colspan='11' align='center' >".mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'),'UTF-8')."</th></tr>
                  <tr><th colspan='11' align='center' >Reporte de Depreciación Consolidado</th></tr>
                  <tr><th colspan='11' align='center' >".$filtro_titulo. "</th></tr>
                  </table>";
                echo $html; die();
            } else { //pdf
                $this->load->library('pdf');
                $array_hdr = array(
                    'titulo' => "Reporte Consolidado de Depreciación",
                    'solotitulo' => true,
                    'subtitulo' => $filtro_titulo
                );
                $html_header = $this->load->view('reporte/header', $array_hdr, true);
                $html = str_replace('border="1" style="margin-left: 4px; width: 99%; font-size:12px;"','border="0.5" style="width: 100%; font-size:7px;"',$html);
                $this->pdf->makePDF($html_header.$html,'lanscape', 'total_activo','Legal');
                die();
            }
        }
        echo json_encode(array('html'=>$html));
    }

    /**
    * @author Israel Alfaro
    * @since 2018-10-22
    * @return  reporte de los activo fijos
    */
    public function reporte_activo_fijo() {
        satelite_validar();
        if ($_POST) {
            // var_dump($_POST);die();
            $fecha_inicio = ( $this->input->post('txtFechaIni') != "") ? $this->formato_fecha($this->input->post('txtFechaIni')) : null;
            $fecha_fin    = ( $this->input->post('txtFechaFin') != "") ? $this->formato_fecha($this->input->post('txtFechaFin')) : null;
            $sucursal     = ( $this->input->post('slcSucursal') != "") ? $this->input->post('slcSucursal') : null;
            $departamento = ( $this->input->post('slcDepartamento') != "") ? $this->input->post('slcDepartamento') : '';
            $adquisicion  = ( $this->input->post('slcAdquisicion') != "") ? $this->input->post('slcAdquisicion') : null;
            $costo_x      = ( $this->input->post('slcCosto') != "") ? $this->input->post('slcCosto') : null;
            $estado       = ( $this->input->post('slcEstado') != "") ? $this->input->post('slcEstado') : null;
            $tipo_activo  = ( $this->input->post('slcTipoActivo') != "") ? $this->input->post('slcTipoActivo') : '';
            $tipo_reporte = $this->input->post('tipo_reporte');
            $where = array();
            if ($fecha_inicio) {
                $where["DATE(act_fecha_adq)  >= '".$fecha_inicio."'"] = null;
            }
            if ($fecha_fin) {
                $where["DATE(act_fecha_adq)  <= '".$fecha_fin."'"] = null;
            }
            if ($sucursal != null) {
                $where['act_id_suc'] = $sucursal;
            }
            if ($departamento != null) {
                $where['act_id_are'] = $departamento;
            }
            if ($adquisicion != null) {
                $where['act_id_tad'] = $adquisicion;
            }
            if ($costo_x !== null) {
                $where['act_id_cec'] = $this->input->post('slcCosto');
            }
            if ((is_array($estado)) && (count($estado) >0)) {
                    $in = implode(',', $estado);
                    $in = str_replace('3', '0', $in);
                    $where["act_estado IN( $in )"] = null;
            }
            if($tipo_activo != null) {
                $where['act_id_tac'] = $tipo_activo;
            }
            $data['tipo_reporte'] = $tipo_reporte;
            $data['activos'] = $this->gsatelite->get_tabla('act_activo_fijo', $where);
            $tabla = $this->load->view('activo/reportes/rpt_activo_fijo', $data, true);                  
            if ($tipo_reporte == 'pdf') {
                $header  = $this->load->view('reporte/header', array('titulo' => 'Activos Fijos'), true);
                $full_tabla = $header . $tabla;
                $head = '<!DOCTYPE html><html><head><title>Reporte de Activos Fijos</title></head><body><script type="text/javascript">';
                $head .= 'document.title = "' . mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8') . ' - Reporte de Activos Fijos";';
                $head .= 'window.print();</script>';
                $footer = '</body></html>';
                $reporte = $head . $full_tabla . $footer;
                echo $reporte;
            } else {
                echo $tabla;
            }            
        } else {
            $sucursal = $this->gsatelite->get_dropdown('suc_sucursal', '{suc_nombre}', '', array(), null, '', 'suc_id', true);
            $data['sucursal'] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $sucursal);

            $area = $this->gsatelite->get_dropdown('are_area', '{are_nombre}', '', array('are_estado' => 1), null, '', 'are_id', true);
            $data['departamento'] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $area);

            $adq = $this->gsatelite->get_dropdown('tad_tipo_adquisicion', '{tad_nombre}', '', array('tad_estado' => 1), null, '', 'tad_id', true);
            $data['adquisicion'] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $adq);

            $tipo_activo = $this->gsatelite->get_dropdown('tac_tipo_activofijo', '{tac_codigo} - {tac_nombre}', '', array('tac_estado'=>1), null, null, 'tac_id', true);
            $data['tipo_activo'] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $tipo_activo);

            $data['centro_costo'] =str_replace('<option value="0">Seleccione</option>', '',$this->gsatelite->get_dropdown('cec_centro_costo', ' {cec_nombre}', '', array('cec_estado' => 1), null, '', 'cec_id', true));
            $data['titulo_personal'] = "Reporte de Activos Fijos";
            cargarvista($data);
        }
    }

    public function get_reporte_activo_fijo() {
        satelite_validar();
        // var_dump($_POST);die();
        $fecha_inicio = ( $this->input->post('txtFechaIni') != "") ? $this->formato_fecha($this->input->post('txtFechaIni')) : null;
        $fecha_fin = ( $this->input->post('txtFechaFin') != "") ? $this->formato_fecha($this->input->post('txtFechaFin')) : null;
        $sucursal = ( $this->input->post('slcSucursal') != "") ? $this->input->post('slcSucursal') : null;
        $departamento = ( $this->input->post('slcDepartamento') != "") ? $this->input->post('slcDepartamento') : '';
        $tipo_activo = ( $this->input->post('slcTipoActivo') != "") ? $this->input->post('slcTipoActivo') : '';
        $adquisicion = ( $this->input->post('slcAdquisicion') != "") ? $this->input->post('slcAdquisicion') : null;
        $estado = ( $this->input->post('slcEstado') != "") ? $this->input->post('slcEstado') : null;
        $costo_x = ( $this->input->post('slcCosto') != "") ? $this->input->post('slcCosto') : null;

        $where = array();
        if ($fecha_inicio) {
            $where["DATE(act_fecha_adq)  >= '".$fecha_inicio."'"] = null;
        }
        if ($fecha_fin) {
            $where["DATE(act_fecha_adq) <= '".$fecha_fin."'"] = null;
        }
        if ($sucursal != null) {
            $where['act_id_suc'] = $sucursal;
        }
        if ((int)$departamento != 0 && $departamento != "") {
            $where['act_id_are'] = (int)$departamento;
        }
        if ($adquisicion != null) {
            $where['act_id_tad'] = $adquisicion;
        }        
        if ($costo_x !== null) {
            $where['act_id_cec'] = $this->input->post('slcCosto');
        }
        if ((is_array($estado)) && (count($estado) >0)) {
            $in = implode(',', $estado);
            $in = str_replace('3', '0', $in);
            $where['act_estado IN('.$in.')'] = null;
        }
        if($tipo_activo != null) {
            $where['act_id_tac'] = $tipo_activo;
        }

        $activos = $this->gsatelite->get_tabla('act_activo_fijo', $where);
        $data['activos'] = $activos;

        $html = $this->load->view('activo/reportes/detalle_reporte_activo_fijo', $data, true);
        echo $html;
    }

    public function getAreaPorSucursal() {
        $sucursal = $this->input->post('slcSucursal');
        $sucursalData = $this->gsatelite->get_tabla('suc_sucursal', array('suc_id' => $sucursal)); 
        $area = $this->gsatelite->get_dropdown('are_area', '{are_prefijo} {are_nombre}', '', array('are_id_suc' => $sucursal, 'are_id_emr' => $sucursalData[0]['suc_id_emr']), null, '', 'are_id', true);
        $area = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $area);
        echo trim($area);
    }
    /**
      * @author Manuel Anzora
      * @since 19-12-2018
      * @return Reporte de depreciacion historica, filtrado por rango de fecha
      * @param fecha inicio y fecha fin, se envia via ajax
      */
    public function bajas_filter(){
        if($_POST){
            $fecha_ini = ( $this->input->post('txtFechaIni') != "") ? $this->formato_fecha($this->input->post('txtFechaIni')) : null;
            $fecha_fin = ( $this->input->post('txtFechaFin') != "") ? $this->formato_fecha($this->input->post('txtFechaFin')) : null;
            $departamento = ( $this->input->post('departamento') != "") ? $this->input->post('departamento') : '';
            $tipo_activo = ( $this->input->post('tipo_activo') != "") ? $this->input->post('tipo_activo') : '';
            $costo_x = ( $this->input->post('slcCosto') !== '') ? $this->input->post('slcCosto') : null;
            $fecha_campo = 'act_fecha_desact';
            $data['activos'] = $this->activo_fijo->get_listado_depreciacion(null,'0',$tipo_activo, null, $departamento, null, $fecha_ini, $fecha_fin,null,$costo_x,null, $fecha_campo);
            //print_r($this->db->last_query());
        $html = $this->load->view('activo/reportes/rpt_activo_depreciacion', $data, true);
            echo json_encode($html);
        }
    }
    /**
      * @author Manuel Anzora
      * @since 19-12-2018
      * @return Genera pdf o excel del reporte
      * @param fecha de inicio y fecha fin
      */
    public function pdf_baja_filter(){
        //Verificar Permisos de acceso
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if($_POST){
                //$fecha_ini = date('Y-m-d', strtotime($this->input->post('fechaini')));
                //$fecha_fin = date('Y-m-d', strtotime($this->input->post('fechafin')));
                $filtros_titulo = '<br>';
                $fecha_ini = ( $this->input->post('fechaini') != "") ? $this->formato_fecha($this->input->post('fechaini')) : null;
        
                $fecha_fin = ( $this->input->post('fechafin') != "") ? $this->formato_fecha($this->input->post('fechafin')) : null;
                $costo_x = ( $this->input->post('slcCosto2') != "") ? $this->input->post('slcCosto2') : null;


                $departamento = ( $this->input->post('departamento') != "") ? $this->input->post('departamento') : null;
                $tipo_activo = ( $this->input->post('tipo_activo') != "") ? $this->input->post('tipo_activo') : null;


                $tipo = $this->input->post('tipoReport');
                //echo "string1".$departamento."string2".$tipo_activo."string3";
                //return 0;
                $activos = $this->activo_fijo->get_listado_depreciacion(null,'0',$tipo_activo, null, $departamento, null, $fecha_ini, $fecha_fin,null,$costo_x);

                //return 0;

                if ($fecha_ini) {
                    $filtros_titulo .= '<b>Desde: </b>'.date_format(date_create($fecha_ini),'Y-m-d').'<br>';
                }
                if ($fecha_fin) {
                    $filtros_titulo .= '<b>Hasta: </b>'.date_format(date_create($fecha_fin),'Y-m-d').'<br>';
                }
                if ($departamento) {
                    $filtro_titulo .= '<b>Departamento: </b>'.$this->gsatelite->get_campo('are_area','are_nombre',array('are_id' => $departamento)).'<br>';
                }
                if ($costo_x) {
                    $filtros_titulo .= '<b>Centro de costo: </b>'.$this->gsatelite->get_campo('cec_centro_costo','cec_nombre',array('cec_id' => $costo_x)).'<br>';
                }
                if ($tipo_activo) {
                    $filtros_titulo .= '<b>Tipo activo: </b>'.$this->gsatelite->get_campo('tac_tipo_activofijo','tac_nombre',array('tac_id' => $tipo_activo)).'<br>';
                }

                $data['titulo_personal']="BAJA DE ACTIVOS";
                if($tipo==1){
                    //GENERA PDF
                    $this->load->library('pdf');
                    $html  = $this->load->view('reporte/header', array('titulo' => 'Reporte listado de bajas'.$filtros_titulo.''), true);
                    $html .= $this->load->view('activo/reportes/reporte_bajas', array('activos' => $activos), true);
                    $reporte=$this->pdf->reportePDF2($html,null,'lanscape','I');
                }else{
                    //Nombre del archivo 
                    $data_header = array(
                    'titulo' => 'Reporte de listado de bajas '.$filtros_titulo,
                    "solotitulo"=>1,
                    "columnas"=> 3
                     );
                    $filename = 'rpt_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);
                    $heaader  = $this->load->view('reporte/header', $data_header, true);
                    $data['table_header'] = "Reporte de baja de activos ";
                    $data['activos']=$activos;
                    $data['filename']=$filename;
                    $html = $this->load->view('activo/reportes/reporte_bajas_excel.php', $data);
                    
                    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                    header("Content-Disposition: attachment;filename=listado_bajas".date('d-m-Y_His').".xls"); 
                    header("Pragma: no-cache");
                    header("Expires: 0");
                    echo '<meta charset="utf-8" />';
                    echo $heaader.$html;
                }
            }
        }
    }

    /**
      * @author Nelson Soriano
      * @since  08-08-2019
      * @return Genera vista html para procesar reporte
      * @param  none
      */
    public function general_activo(){
        satelite_validar();
        $data['titulo_personal'] = "Reporte general de activos";
        $data['persmisos'] = $this->gsatelite->get_permisos_opcion();
        $data['sucursales'] = str_replace('<option value="0">Seleccione</option>', '',$this->gsatelite->get_dropdown('suc_sucursal','{suc_codigo} - {suc_nombre}','','','','','','prv_id',true));
        $data['cec'] = str_replace('<option value="0">Seleccione</option>', '',$this->gsatelite->get_dropdown('cec_centro_costo','{cec_nombre}','',array('cec_estado' => 1),'','','','cec_id',true));
        $data['tipoA'] = str_replace('<option value="0">Seleccione</option>', '',$this->gsatelite->get_dropdown('tad_tipo_adquisicion','tad_nombre','',array('tad_estado' => 1),'','','','tad_id',true));
        $data['tac'] = str_replace('<option value="0">Seleccione</option>', '',$this->gsatelite->get_dropdown('tac_tipo_activofijo','{tac_codigo} - {tac_nombre}','',array('tac_estado' => 1),'','','','tac_id',true));
        $data['proveedores'] = str_replace('<option value="0">Seleccione</option>', '',$this->gsatelite->get_dropdown('prv_proveedor','{prv_codigo} - {prv_nombre}','',array('prv_estado' => 1),'','','','prv_id',true));
        $data['proyectos'] = str_replace('<option value="0">Seleccione</option>', '',$this->gsatelite->get_dropdown('pcl_proyecto_cliente','{pcl_codigo} - {pcl_nombre}','',array('pcl_estado ' => 1),'','','','pcl_id',true));
        cargarvista($data);
    }

    /**
      * @author Nelson Soriano
      * @since  28-08-2018
      * @return Genera pdf o excel del reporte
      * @param  fecha de inicio y fecha fin
      */
    public function get_valor_filtro($tabla,$where,$campo,$personeria = null,$extra=null){
        $valor = $this->gsatelite->get_tabla($tabla,$where);
        if ($personeria != null) {
           if ($valor[$personeria] == 2) {
               return $valor[0][$campo].' '.$valor[0][$extra];
           }else{
                 return $valor[0][$campo];
           }
        }
        return $valor[0][$campo];
    }

    public function reporte_general_activo($es_reporte = null){
        satelite_validar();
        ini_set('post_max_size','2048M');
        ini_set('memory_limit', '2048M' );
        ini_set('max_execution_time', '99999');
        $prov           = $this->input->post('prov');
        $tipoActivo     = $this->input->post('tipoActivo');
        $sucursal       = $this->input->post('sucursal');
        $tipo_adq       = $this->input->post('tipo_adq');
        $depto          = $this->input->post('depto');
        $cec            = $this->input->post('cec');
        $estado         = $this->input->post('estado');
        $proyecto       = $this->input->post('proyecto');
        $fechai         = $this->input->post('fechai');
        $fechaf         = $this->input->post('fechaf');
        $filtros_titulo = '<br>';
        if ($fechai != '' && $fechaf != '') {
            $filtros_titulo.= '<br>Del: '.date_format(date_create($fechai),'d-m-Y'); 
            $filtros_titulo.= ' Al: '.date_format(date_create($fechaf),'d-m-Y').'<br>'; 
        }
        $where = null;
        if($prov != '') {
            $where['act_id_prv'] = $prov;
            $filtros_titulo.='Proveedor: '.$this->get_valor_filtro('prv_proveedor',array('prv_id' => $prov),'prv_nombre','prv_tipo_pers','prv_apellido');
        }
        if($tipoActivo != '') {
            $where['act_id_tac'] = $tipoActivo;
            $filtros_titulo .= '<br>Tipo Activo: '.$this->get_valor_filtro('tac_tipo_activofijo',array('tac_id' => $tipoActivo),'tac_nombre');
        }
        if($sucursal != '') {
            $where['act_id_suc'] = $sucursal;
            $filtros_titulo .= '<br>Sucursal: '.$this->get_valor_filtro('suc_sucursal',array('suc_id' => $sucursal),'suc_nombre');
        }
        if($tipo_adq != '') {
            $where['act_id_tad'] = $tipo_adq;
            $filtros_titulo .= '<br>Tipo adquisicion: '.$this->get_valor_filtro('tad_tipo_adquisicion',array('tad_id' => $tipo_adq),'tad_nombre');
        }
        if($depto != '') {
            $sig_emp = strtolower(trim($this->gsatelite->get_parametro('SYS_SIGLAS')));
            if ($sig_emp == 'defensoria') {
                $where['axe_id_are'] = $depto;
            } else {
            $where['act_id_are'] = $depto;
            }            
            $filtros_titulo .= '<br>Area: ' . $this->get_valor_filtro('are_area',array('are_id' => $depto),'are_nombre');
        }
        if($cec != '') {
            $where['act_id_cec'] = $cec;
            $filtros_titulo .= '<br>Centro de costo: '.$this->get_valor_filtro('cec_centro_costo',array('cec_id' => $cec),'cec_nombre');
        }
        if(is_array($estado) && count($estado) > 0){ 
            $ids = implode(',', $estado);
            $where['act_estado IN('.$ids.')'] = null;
        }elseif($estado != ''){
            $where['act_estado IN('.$estado.')'] = null;
        }
        if($proyecto != '') {
            $where['act_id_pcl'] = $proyecto;
            $filtros_titulo .= '<br>Proyecto: '.$this->get_valor_filtro('pcl_proyecto_cliente',array('pcl_id' => $proyecto),'pcl_nombre');
        }
        if ($fechai != '' && $fechaf != '') {
            $where['DATE(act_fecha_adq) >='] = date_format(date_create($fechai),'Y-m-d');
            $where['DATE(act_fecha_adq) <='] = date_format(date_create($fechaf),'Y-m-d');
        }
        $consulta     = $this->activo_fijo->get_reporte_general($where);
        $data['info'] = $consulta;
        $data['tipo'] = ($es_reporte) ? $this->input->post('tipo_reporte') : "";
        $html = $this->load->view('activo/reportes/reporte_general_activo.php', $data,true);
        if ($es_reporte != null) {
            $tipo_reporte = $this->input->post('tipo_reporte');
            switch ($tipo_reporte) {
                case 'pdf':
                $this->load->library('pdf');
                    $header  = $this->load->view('reporte/header', array('titulo' => 'general de activos' . '<div style="font-weight:nornal;font-size:9pt;text-align:left" id="x2">'.$filtros_titulo . '</div>','tipo_fuente' => 'pdfahelvetica'), true);
                    $htmlx   = $header.$html;
                    $reporte=$this->pdf->reportePDF2($htmlx, null, 'lanscape','I');
                    break;               
                case 'excel':
                    $data_header = array(
                        'titulo'       => 'Reporte General de Activos '.$filtros_titulo,
                        "solotitulo"   =>1,
                        "columnas"     => 13,
                        "tipo_fuente"  => 'arial'
                    );
                    $filename = 'rpt_'.date('dmY').'_'.substr(uniqid(md5(rand()), true), 0, 7);
                    $heaader  = $this->load->view('reporte/header', $data_header, true);
                    $data['table_header'] = "Reporte General de Activos ";
                    if (isset($activos)) {
                        $data['activos']=$activos;
                    }
                    $data['filename']=$filename;                     
                    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                    header("Content-Disposition: attachment;filename=listado_activos".date('d-m-Y_His').".xls"); 
                    header("Pragma: no-cache");
                    header("Expires: 0");
                    echo '<meta charset="utf-8" />';
                    echo $heaader.$html;
                    die();
                    break;
            }
        }
        echo json_encode(array('html' => $html));
    }

    public function capitalazibles($flag = null) {
        satelite_validar();
        if ($_POST) {
            $export = $_POST['exportar'];
            $fHasta = $_POST['tFecha_hasta'];
            $tac_id = $_POST['sltipo_activo'];
            $are_id = $_POST['sldepartamento'];
            $hasta = null;
            $where = array('act_depreciable' => 1);
            if ($are_id > 0) {
                $where['act_id_are'] = $are_id;
            }
            if ($tac_id > 0) {
                $where['grp_id_agr'] = $tac_id;
            }
            if ($fHasta != "") {
                $ffecha = "01-" . $fHasta;
                $hasta = formatear_fecha("Ym", $ffecha);
                $hasta_baja = formatear_fecha('Y-m-t', $ffecha);
                $where["DATE_FORMAT(act_fecha_adq, '%Y%m') <= "] = formatear_fecha("Ym", $ffecha);
            } else {
                $hasta = date("Ym");
                $hasta_baja = date('Y-m-t');
                $where["DATE_FORMAT(act_fecha_adq, '%Y%m') <= "] = date("Ym");
            }            
            $where["(act_estado > 0 OR (act_estado = 0 AND DATE(act_fecha_desact) > '$hasta_baja'))" ] = NULL;
            $registros = $this->activo_fijo->get_capitalizacion($where, $hasta);
            $data['fec_hasta'] = $ffecha;
            $data['tipo_repo'] = $export;
            $data['registros'] = $registros;
            $html = $this->load->view('activo/reportes/detalle_activo_capitalaziables', $data, true);
            if ($flag) {
                echo json_encode(array('html' => $html, 'filas' => count($registros)));
            } else {
                if ($export == 'pdf') {
                    $header = $this->load->view('reporte/header', array('titulo' => 'Bienes Capitalizables'), true);
                    $reporte = $header . $html;
                    $this->pdf->makePdf($reporte, 'P', 'bienes_capitalizables', 'Letter');                    
                } else {
                    echo $html;
                }
            }
        } else {
            $data['permisos'] = $this->gsatelite->get_permisos_opcion();
            $sl_are = $this->gsatelite->get_dropdown('are_area', '{are_prefijo} {are_nombre}','', array('are_estado' => 1), null, '', 'are_id', true);
            $sl_tac = $this->gsatelite->get_dropdown('agr_agrupacion_activos','{agr_codigo} {agr_nombre}', '', array('agr_estado'=>1),null,'','agr_id',true);
            $data['areas'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $sl_are);
            $data['tipo_activo'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $sl_tac);
            $data['titulo_personal'] = "Bienes Capitalizables";
            cargarvista($data);
        }        
    }

    public function det_capitalizable($flag=null) {
        satelite_validar();
        if ($_POST) {
            ini_set('post_max_size','4000M');
            ini_set('memory_limit', '1024M' );
            ini_set('max_execution_time', '99999');
            $hasta = $year = null;
            $export = $_POST['exportar'];
            $fHasta = $_POST['tFecha_hasta'];
            $agr_id = $_POST['t_agrupacion'];
            $hasta_baja = formatear_fecha('Y-m-t', '01-' . $fHasta);
            $where = array('act_depreciable' => 1);
            $where["(act_estado > 0 OR (act_estado = 0 AND DATE(act_fecha_desact) > '$hasta_baja'))" ] = NULL;
            if ($fHasta != "") {
                $ffecha = "01-" . $fHasta;
                $year = formatear_fecha("Y", $ffecha);
                $hasta = formatear_fecha("Ym", $ffecha);
                $where["DATE_FORMAT(act_fecha_adq, '%Y%m') <= "] = formatear_fecha("Ym", $ffecha);
            } else {
                $ffecha = date("d-m-Y");
                $year = date("Y");
                $hasta = date("Ym");
                $where["DATE_FORMAT(act_fecha_adq, '%Y%m') <= "] = date("Ym");
            }
            if ($agr_id > 0) {
                $where["agr_id"] = $agr_id;
            }
            $registros = $this->activo_fijo->get_det_capitaliza($where, $hasta, $year);
            // var_dump($this->db->last_query());die();
            $data['fec_hasta'] = $ffecha;
            $data['tipo_repo'] = $export;
            $data['registros'] = $registros;
            $html = $this->load->view('activo/reportes/tabla_detalle_capitalaziables', $data, true);
            if ($flag) {
                echo json_encode(array('html' => $html, 'filas' => count($registros)));
            } else {
                echo $html;
            }
        } else {
            $data['permisos'] = $this->gsatelite->get_permisos_opcion();
            $data['agrupaciones'] = $this->gsatelite->get_dropdown('agr_agrupacion_activos','{agr_codigo} {agr_nombre}', '', array('agr_estado'=>1),null,'','agr_id',true);
            $data['titulo_personal'] = "Detalle Bienes Capitalizables";
            cargarvista($data);
        }        
    }

    public function exp_det_capitalizable($value='') {
        satelite_validar();
        if ($_POST) {
            ini_set('post_max_size','4000M');
            ini_set('memory_limit', '1024M' );
            ini_set('max_execution_time', '99999');
            $hasta = $year = null;
            $fHasta = $_POST['full_fecha_hasta'];
            $agr_id = $_POST['full_tagrupacion'];
            $where = array('act_depreciable' => 1, 'act_estado' => 1);
            if ($fHasta != "") {
                $ffecha = "01-" . $fHasta;
                $year = formatear_fecha("Y", $ffecha);
                $hasta = formatear_fecha("Ym", $ffecha);
                $where["DATE_FORMAT(act_fecha_adq, '%Y%m') <= "] = formatear_fecha("Ym", $ffecha);
            } else {
                $ffecha = date("d-m-Y");
                $year = date("Y");
                $hasta = date("Ym");
                $where["DATE_FORMAT(act_fecha_adq, '%Y%m') <= "] = date("Ym");
            }
            if ($agr_id > 0) {
                $where["agr_id"] = $agr_id;
            }
            $registros = $this->activo_fijo->get_det_capitaliza($where, $hasta, $year, 1);
            $data['fec_hasta'] = $ffecha;
            $data['registros'] = $registros;
            $this->load->view('activo/reportes/tabla_det_capitalaziables_full', $data);
        }
    }

    

    public function rpt_dep_act_mej($flag = null) {
        if ($_POST) {
            $where3 = array();
            $txtFecha_desde = '01-1900';
            $txtFecha_hasta = ($this->input->post('fechas_hasta') != "") ? $this->input->post('fechas_hasta') : date("m-Y");
            $costo_x = ( $this->input->post('centro_costo') != "") ? $this->input->post('centro_costo') : null;
            $departamento = ($this->input->post('departamento') != "") ? $this->input->post('departamento') : null;
            $tipo_activo = ( $this->input->post('tipo_activos') != "") ? $this->input->post('tipo_activos') : "";
            if ($txtFecha_hasta != '') {
                $txtFecha_desde = formatear_fecha('Y-01-01', ('01-' . $txtFecha_desde));
                $txtFecha_hasta = formatear_fecha('Y-m-d', ('01-' . $txtFecha_hasta));
                $data["anio_periodo"] = formatear_fecha('Y', ($txtFecha_hasta));
            }
            if($tipo_activo != "") {
                $where3["act_id_tac IN ($tipo_activo)"] = null;
            }
            if ($departamento != null ) {
                $where3['act_id_are'] = $departamento;
            }
            if ($costo_x !== null) {
                $where3['act_id_cec'] = $costo_x;
            }
            $where3['act_depreciable'] = '1';

            $data["anio_periodo"] = date("Y");

            ini_set('post_max_size','4000M');
            ini_set('memory_limit', '4000M' );
            ini_set('max_execution_time', '99999');
            $group_by = array('act_id_tac'=>'ASC','act_id_are'=>'ASC');
            $registros = $this->activo_fijo->get_depreciacion_activo2($where3, $group_by, $txtFecha_desde, $txtFecha_hasta);
            $activos = array();
            $mejoras = array();
            $max_mej = array();
            foreach ($registros as $key => $value) {
                if ($value['act_id_act_dependencia'] > 0) {
                    if (isset($mejoras[$value['act_id_act_dependencia']])) {
                        $mejoras[$value['act_id_act_dependencia']][] = $value;
                        $max_mej[$value['act_id_act_dependencia']] = $max_mej[$value['act_id_act_dependencia']] + 1;
                    } else {
                        $mejoras[$value['act_id_act_dependencia']][] = $value;
                        $max_mej[$value['act_id_act_dependencia']] = 1;
                    }                    
                } else {
                    $activos[$value['act_id']] = $value;
                }                
            }
            $max_mejoras = max($max_mej);
            
            $data['registros'] = $activos;
            $data['activos_hijos'] = $mejoras;
            $data['maximo_mejora'] = $max_mejoras;

            $data['anio_hasta'] = formatear_fecha('Y',$txtFecha_hasta);
            $data['fecha_hasta'] = $txtFecha_hasta;
            
            $html = $this->load->view('activo/reportes/filtrar_depreciacion_con_mejoras', $data, true);
            if ($flag) {
                echo json_encode(array('html' => $html, 'filas' => count($registros)));
            } else {
                $filtro_titulo = "";
                $filtro_titulo .= ($departamento > 0) ? "Área: ".$this->gsatelite->get_campo('are_area','are_nombre',array('are_id'=>$departamento))."<br />" : "Área: Todas las áreas<br />";
                $filtro_titulo .= ($tipo_activo > 0) ? "Tipo: ".$this->gsatelite->get_campo('tac_tipo_activofijo','tac_nombre',array('tac_id'=>$tipo_activo))."<br />" :  "Tipo: Todos los tipos<br />";
                $filtro_titulo .= ($txtFecha_hasta !='' ) ? " Hasta: ".formatear_fecha('t-m-Y',$txtFecha_hasta):"";

                header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                header("Content-Disposition: attachment;filename=depreciacion_activos_".date('d-m-Y_His').".xls"); 
                header("Pragma: no-cache");
                header("Expires: 0");
                echo '<meta charset="utf-8" />';
                echo '<img src="'.base_url().'media/imagenes/sistema/'.$this->gsatelite->get_parametro('SYS_LOGOTIPO').'.png" width="108px" height="48">';
                echo "<table border='0'>
                  <tr><th colspan='11' align='center' >".mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'),'UTF-8')."</th></tr>
                  <tr><th colspan='11' align='center' >Reporte de Depreciación Consolidado</th></tr>
                  <tr><th colspan='11' align='center' >".$filtro_titulo. "</th></tr>
                  </table>";
                echo $html; die();
            } 
        } else {
            $slc_are = $this->gsatelite->get_dropdown('are_area', '{are_nombre}','', array('are_estado' => 1), null, '', 'are_id', true);
            $slc_cec = $this->gsatelite->get_dropdown('cec_centro_costo', ' {cec_nombre}', '', array('cec_estado' => 1), null, '', 'cec_id', true);
            $slc_tac = $this->gsatelite->get_dropdown('tac_tipo_activofijo', '{tac_codigo} - {tac_nombre}','', array('tac_estado' => '1'), null, '', 'tac_id', true);
            $data['permisos'] = $this->gsatelite->get_permisos_opcion();
            $data['tipo_activo'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $slc_tac);
            $data['centro_costo'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $slc_cec);
            $data['departamento'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $slc_are);
            $data['titulo_personal'] = "Reporte Dependencias";
            cargarvista($data);
        }        
    }

    public function solicitud_traslados() {
        cargarvista();        
    }

    public function filtrar_solicitud_traslados($es_reporte = 0) {
        $txtFechaIni = $this->input->post('txtFechaIni');
        $txtFechaFin = $this->input->post('txtFechaFin');

        if ($txtFechaIni != '') {
            $where['DATE(slt_fecha_aprobacion) >='] = formatear_fecha("Y-m-d", $txtFechaIni);
        }
        if ($txtFechaFin != '') {
            $where['DATE(slt_fecha_aprobacion) <='] = formatear_fecha("Y-m-d", $txtFechaFin);
        }

        // Estado quemado de solicitudes aprobadas
        $where['slt_estado'] = 2;

        $datos = $this->activo_fijo->reporte_solicitud_traslado($where);

        $data['datos'] = $datos;
        $data['txtFechaIni'] = $txtFechaIni;
        $data['txtFechaFin'] = $txtFechaFin;
        $data['es_reporte'] = $es_reporte;
        $html = $this->load->view('activo/reportes/filtrar_solicitud_traslado', $data, true);
        if ($es_reporte) {
            $tipo_accion = $this->input->post('tipo_accion');

                
            $data['tabla_detalle_lista'] = $html;

            $filtros = "";
            $txtFechaInicio = formatear_fecha("Y-m-d", $txtFechaInicio);
            $txtFechaFin = formatear_fecha("Y-m-d", $txtFechaFin);
            $fecha_ini = str_replace('-', '/', $txtFechaIni);
            $fecha_fin = str_replace('-', '/', $txtFechaFin);
            $filtros .= "<b>Fecha inicio:</b> {$fecha_ini} <b>Fecha fin:</b> {$fecha_fin}, ";

            $filtros = rtrim($filtros, ', ');        

            if ($tipo_accion) { 
                //excel
                $time = time();
                header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                header("Content-Disposition: attachment;filename=reporte_traslados_activos_{$time}.xls");
                header("Pragma: no-cache");
                header("Expires: 0");
                echo '<meta charset="utf-8" />';
                echo "<table border='1'>
                      <tr><th colspan='3' align='center' >" .
                mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8')
                . "</th></tr>
                    <tr><th colspan='3' align='center' >Reporte de Traslados de Activos</th></tr>";            

                $fecha_actual = str_replace('-', '/', formatear_fecha("d-m-Y", date("Y-m-d")));
                $usuario = $this->gsatelite->get_tabla('users', ['id' => $this->tank_auth->get_user_id()]);
                $usuario = (count($usuario) > 0) ? $usuario[0]['username'] : '-';
                echo "<tr><td colspan='3' align='center'><b>Fecha</b>: {$fecha_actual} <b>Usuario</b>: {$usuario}</td></tr>";

                if ($filtros != '') {
                    echo "<tr><td colspan='3' align='center'>{$filtros}</td></tr>";
                }

                echo "<tr><th colspan='3' align='center' ></th></tr>
                      <tr><td colspan='3'>" . $data['tabla_detalle_lista'] . "</td></tr>    
                      </table>";
                die();   

            } else { 
                //pdf
                ini_set( 'memory_limit', '2048M' );
                ini_set('max_execution_time', '9999');

                $data['cabezera'] = null;
                $data['filtros'] = $filtros;
                $header = $this->load->view('reporte/header', $data, true);


                $this->load->library('pdf');
                $this->pdf->SetAuthor('Grupo Satelite');
                $this->pdf->SetTitle('Faltas por sucursal');
                $this->pdf->makePdf($header.$html, 'L', 'reporte_traslado_activos', 'Letter');
                die();
            }
        }        

        echo json_encode(array('html' => $html, 'totalRegistros' => count($datos)));
        die();
    }

} // End class

