<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Nuevo extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->model('gsatelite');
        $this->load->library('grocery_CRUD');
        $this->load->library('tank_auth');
        $this->load->library('session');
        $this->load->model('activo_fijo');
        $this->load->model('consultas');
        $this->load->helper('satelite_helper');
        $this->load->library('EnLetras');
        $this->load->library('pdf');
    }
    
    function existe_sesion(){
        if($this->session->flashdata('nada')=='nada'){echo json_encode(array('existepdf' => true ));
        $alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Registro de activos",'texto_alerta'=>" El registro del activo se guardó correctamente");
        $this->session->set_flashdata($alerta);
        }
        //$this->session->keep_flashdata('nada');
    }
    /**
     * Registro de Activo Fijo - Pantalla Principal
     * @return get pantalla de registro de activo fijo
     */

    public function caracteristicasxtac($id=null){
        $tac_id=$this->input->post('tac_id');

        if(!empty($id)) {
            $this->db->where('cxi_id_tac', $id);
        } else {
            $this->db->where('cxi_id_tac', $tac_id);
        }
        $caracteristicasxtac=$this->db->select()
                                      ->from('cxi_caracteristicaxtipo')
                                      ->join('car_caracteristica','car_id=cxi_id_car')
                                      // ->where('cxi_id_tac',$tac_id)
                                      ->get()->result_array();
        $options="<option value='0'>Seleccione</option>";
        foreach ($caracteristicasxtac as $key => $value) {
            $options.="<option data-tipocar='".$value['car_tipo']."' value='".$value['cxi_id']."'>".$value['car_nombre']."</option>";
        }
        $arreglo = array('lista' =>$options );
       if(!empty($id)){
        return $options;
       } else {
            echo json_encode($arreglo);
       }    
    }

    public function index_activos($imp = 0){
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');   
        } else {
            if($_POST){
                $codigo = ($this->input->post('codigo')>0) ? $this->input->post('codigo') : 0;
                $fecha_ini = ($this->input->post('fecha_ini')>0) ? $this->input->post('fecha_ini') : null;
                $fecha_fin = ($this->input->post('fecha_fin')>0) ? $this->input->post('fecha_fin') : null;
                $tipo = ($this->input->post('tipo')>0) ? $this->input->post('tipo') : null;
                $grupo = ($this->input->post('grupo')>0) ? $this->input->post('grupo') : null;

                if($codigo>0){
                    $this->db->where('act_id', $codigo);
                }

                if($tipo>0 && $codigo<=0){
                    $this->db->where('act_id_tac', $tipo);
                }

                if($grupo>0 && $codigo<=0){
                    $this->db->where('act_id_grp', $grupo);
                }

                if($fecha_ini!='' && $fecha_fin!=''  && $codigo<=0){
                    $desde=formatear_fecha('Y-m-d', $fecha_ini); 
                    $hasta=formatear_fecha('Y-m-d', $fecha_fin); 
                    $where=array('date_format(act_fecha_adq,"%Y-%m-%d") >='=>$desde, 'date_format(act_fecha_adq,"%Y-%m-%d") <='=>$hasta);
                    $this->db->where($where);
                }

                $this->db->join('dxd_detalle_documento_proveedor', 'dxd_id = act_id_dxd', 'LEFT');
                $data['activos']=$this->gsatelite->get_tabla('act_activo_fijo');
                //die(print_r($this->db->last_query()));
                $html = $this->load->view('activo/nuevo/detalle_activos', $data, true);
                //die(print_r($html));
                echo $html;
                die();
            }else{
                // SE COMENTA PUES NO SE UTILIZA EN LA VISTA
                // $data['activos']=$this->gsatelite->get_tabla('act_activo_fijo');

                $tipo = $this->gsatelite->get_dropdown('tac_tipo_activofijo', '{tac_nombre}','', null, null, '', 'tac_id', true);
                $grupo = $this->gsatelite->get_dropdown('grp_grupo', '{grp_nombre}','', null, null, '', 'grp_id', true);
                // YA NO SE UTILIZA PUES SE SUSTITUYO POR UN SELECT AJAX
                // $codigo = $this->gsatelite->get_dropdown('act_activo_fijo', '{act_codigo}','', null, null, '', 'act_id', true);

                $data['tipo'] =  str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>',$tipo);
                $data['grupo'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $grupo);
                // YA NO SE UTILIZA PUES SE SUSTITUYO POR UN SELECT AJAX
                // $data['codigo'] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>',$codigo);

                $data['titulo_personal']="Listado de activos";

                if($imp > 0){ 
                    $nuevo_act = $this->activo_fijo->get_activo($imp);
                    $full_info = $this->activo_fijo->get_info_total_activo(array('act_id' => $imp));
                    $caracteristicas=$this->activo_fijo->get_caracteristicaxactivo($imp);
                    $this->load->library('pdf');
                    $html  = $this->load->view('reporte/header', array('titulo' => 'Activo fijo'), true);
                    $html .= $this->load->view('activo/nuevo/nuevo_act', array('activo' => $nuevo_act, 'full_info'=>$full_info[0],'caracteristicas'=>$caracteristicas), true);            
                    $reporte=$this->pdf->makePDF($html);
                }
                $this->_cargarvista($data);
            }
        }
    }


    public function activo_edit($activo=null){
        $flag = $this->input->post('flag');
        if(!empty($flag)){
            $activo = $this->input->post('id_tipo');
        }
        //Listado de cuentas contables
        $cnt_contable = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_estado' => 1));
        $options='<option value=""></option>';
        foreach ($cnt_contable as $key) {
            $options.='<option value="'.$key['cnt_id'].'">'.$key['cnt_cuenta'].' - '.trim($key['cnt_nombre']).'</option>';
        }
        $data['cnt_contable'] = $options;
        $depreciacion_act = $this->gsatelite->get_tabla('dda_distribucion_depreciacion_activo', array('dda_id_act' => $activo, 'dda_estado' => 1));
        $data['depreciacion_act'] = $depreciacion_act;        
        $data['titulo_personal']="Edición de activo";
        $data['cabezera']= $cabezera =$this->db->where('act_id',$activo)->get('act_activo_fijo')->row_array();
        $data['caracxact']=$this->db->join('cxi_caracteristicaxtipo','cxi_id=cxc_id_cxi')
            ->join('car_caracteristica','car_id=cxi_id_car')
            ->where('cxc_id_act', $activo)
            ->where('cxc_estado', 1)
            ->get('cxc_caracterxactivo')->result_array();
        $data['caracxtac']=$this->db->join('car_caracteristica','car_id=cxi_id_car')  // caracteristicas seg[un el tipo de activo
            ->where('cxi_id_tac',$data['cabezera']['act_id_tac'])
            ->get('cxi_caracteristicaxtipo')->result_array();
        $data['grupos'] = $this->db->get_where('grp_grupo', array('grp_id_tac' => $data['cabezera']['act_id_tac']))->result_array();
        $data['opciones'] = $this->caracteristicasxtac($data['cabezera']['act_id_tac']);
        $data['anexos'] = $this->activo_fijo->foto_activo($activo);
        //print_r($data['caracxact']);
        $fecha_ini=($cabezera['act_fecha_adq']!='')? formatear_fecha('d-m-Y', $cabezera['act_fecha_adq']):null;
        $fecha_fin=($cabezera['act_fecha_vence_garantia']!='')? formatear_fecha('d-m-Y', $cabezera['act_fecha_vence_garantia']):null;
        $data['act_dep_monto']=$this->gsatelite->get_parametro('ACT_DEP_MONTO');
        $data['dias'] = $this->get_dias($fecha_ini,$fecha_fin, 1);
        $doc=$this->gsatelite->get_tabla('dxd_detalle_documento_proveedor', array('dxd_id'=>$cabezera['act_id_dxd']));
        //die(print_r($doc[0]['dxd_id_dpv']));
        $where=null;
        if(count($doc)>0 && $doc[0]['dxd_id_dpv']!=''){
            $where=array('dpv_id'=>$doc[0]['dxd_id_dpv']);
        }        
        $data['prv_opciones'] = $this->gsatelite->get_dropdown('prv_proveedor', '[CASE WHEN prv_tipo_pers = 1 THEN CONCAT(prv_nombre," ",prv_apellido) ELSE prv_nombre END]', '', array('prv_estado'=>1) ,$data['cabezera']['act_id_prv'],null,'prv_id',true);
        //SUCURSALES
        $data['suc_sucursales'] = $this->gsatelite->get_dropdown('suc_sucursal', '{suc_codigo}::{suc_nombre}', '', [] ,$data['cabezera']['act_id_suc'],null,'suc_id',true);
            //proyectos(centro de costo)
        $data['pcl_proyecto_cliente'] = $this->gsatelite->get_dropdown('pcl_proyecto_cliente', '{pcl_codigo}::{pcl_nombre}', '', array('pcl_estado'=>1) ,$data['cabezera']['act_id_pcl'],null,'pcl_id',true);
        $act_mejora = $this->activo_fijo->get_activo_mejora(['act_id'=>$cabezera['act_id_act_dependencia']]);
        $data['act_mejora'] = (count($act_mejora)>0)?$act_mejora:0;
        //Centro de costo select
        $centro_costo = $this->gsatelite->get_dropdown('cec_centro_costo', '{cec_codigo} - {cec_nombre}', '', array('cec_estado' => 1), $data['cabezera']['act_id_cec'], '', 'cec_id', true);
        // var_dump($centro_costo);die();
        $data["centro_costo"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $centro_costo);        
        $documentos = $this->activo_fijo->documentoxproveedor(1, $where);    
        $options='<option value=""></option>';
        foreach ($documentos as $dxp) {
            $proveedor = trim($dxp['prv_apellido']);
            if($dxp['prv_tipo_pers'] == 1){
                $proveedor = trim($dxp['prv_nombre'].' '.$dxp['prv_apellido']);
            }            
            if(count($doc)>0 && $dxp['dpv_id']==$doc[0]['dxd_id_dpv']){
                $options.='<option value="'.$dxp['dpv_id'].'" selected="selected">'.$dxp['dpv_numero_documento'].' - '.$proveedor.'</option>';
            } else{
                if ($dxp['cant'] > 0){
                    $options.='<option value="'.$dxp['dpv_id'].'">'.$dxp['dpv_numero_documento'].' - '.$proveedor.'</option>';
                }
            }
        }
        // die(print_r($options));
        $data['dxd_item'] = (isset($documentos[0]['dxd_id']))?$documentos[0]['dxd_id']:'';
        $data['documentos'] = $options;
        $data['read']=0;
        if($cabezera['act_id_dxd']>0){
            $data['read']=1;
            $data['detalles']=$this->get_detalles_documento($doc[0]['dxd_id_dpv'], $cabezera['act_id_dxd']);//Detalles
        }
        //Proceso para obtener proveedores
        $dataPrv = $this->activo_fijo->get_prv('prv_proveedor', array('prv_estado' => 1), 'prv_id, prv_codigo, prv_nombre, prv_apellido');          
        $optionPrv='<option></option>';
        foreach ($dataPrv as $value) {
            $optionPrv .= '<option value="'.$value['prv_id'].'">'.$value['prv_codigo'].' - '.$value['prv_nombre'].' '.$value['prv_apellido'].'</option>';
        }
        $data['optionPrv'] = $optionPrv;
        $clasificacion = $this->gsatelite->get_campo('tac_tipo_activofijo', 'tac_nombre', array('tac_id'=>$data['cabezera']['act_id_tac']));
        $depto = $this->gsatelite->get_campo('are_area', 'are_nombre', array('are_id'=>$data['cabezera']['act_id_are']));
                                $this->db->join('tcn_tipo_cuenta','tcn_id = dfv_id_tcn');
                                $this->db->join('cec_centro_costo','cec_id = dfv_id_cec');
                                $this->db->join('cnt_cuenta_contable','cnt_id = dfv_id_cnt');
        $data['info_finanza'] = $this->gsatelite->get_tabla('dfv_detalle_finanza_activo',array('dfv_id_act' => $activo));
        $data['tipo_cuenta']  = $this->gsatelite->get_dropdown('tcn_tipo_cuenta','tcn_nombre','',array('tcn_estado' =>1),'','','tcn_id',true);
        $data['cuen_con']     = $this->gsatelite->get_dropdown('cnt_cuenta_contable','cnt_nombre','',array('cnt_estado' =>1),'','','cnt_id',true);
        $data['centro_costo_finanzas'] = $this->gsatelite->get_dropdown('cec_centro_costo','cec_nombre','',array('cec_estado' =>1),'','','cec_id',true);
        $unbicaciones_activos = $this->gsatelite->get_dropdown('uba_ubicacion_activo','{uba_codigo} {uba_nombre}','',array('uba_estado' =>1),$data['cabezera']['act_id_uba'],'','uba_id',true);
        $data['ubicacion_activo'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '',  $unbicaciones_activos);
        $data['caneditcode'] = intval($this->gsatelite->get_parametro('SYS_CONFIGURACION_CODIGO_ACTIVO', null, false, array('EDITABLE')));
        if (!empty($flag)) {
            $respuesta = array(
                'response'      =>  true,
                'cabezera'      =>  $data['cabezera'],
                'cla_activo'    =>  $clasificacion,
                'area'          =>  $depto 
            );
            echo json_encode($respuesta);
        } else {
            $this->_cargarvista($data);  
        }
    }

    public function mejoras_activos(){
        if($_POST){
            $revaluacion = array(
                    'mej_id_act'        => $this->input->post('activo'),
                    'mej_descripcion'   => $this->input->post('concepto'),
                    'mej_valor'         => $this->input->post('revaluacion'),
                    'mej_estado'        => 1,
                    'mej_usu_mod'       => $this->tank_auth->get_user_id(),
                    'mej_fecha_mod'     => date('Y-m-d H:i:s')  
                );

            $registro =  $this->gsatelite->ingresar('mej_mejora_activo',$revaluacion);
            $registro2 = $this->gsatelite->actualizar_array('act_activo_fijo',array('act_valor_cont'=>$_POST['rev_total']), array('act_id'=>$_POST['activo']));    

            if($registro>0 && $registro2>0){
                $alerta=array('registro'=>$registro,'tipo_alerta'=> 'success','titulo_alerta'=>"Registro actualizado",'texto_alerta'=>"El registro se ha actualizado correctamente.");
            }
            else {
                $alerta=array('tipo_alerta'=> 'error','titulo_alerta'=>"Registro no actualizado",'texto_alerta'=>"El registro no pudo ser actualizado, verifique la información ingresada.");
            }
            
            $this->session->set_flashdata($alerta); 
            redirect('activo/nuevo/mejoras_activos');

        } else {
            $activos = $this->gsatelite->get_dropdown('act_activo_fijo', '{act_codigo} {act_nombre}','', array('act_estado' => '1'), null, '', 'act_id', true);
            $data["activos"] = str_replace('<option value=""></option>', '',$activos);
            $data['titulo_personal'] = "Mejoras Activos fijos";
            $this->_cargarvista($data);
        }
    }

    public function get_activos_ajx(){
        $act = $this->input->post('activo');
        $resultado = null;
        $where = array('act_estado' => 1);
        $like = array("CONCAT_WS(' ', act_codigo, act_nombre)" => $act);
        $resultado = $this->activo_fijo->get_acts_ajx($where, $like);
        echo json_encode($resultado);
    }

    public function actualizar_activo(){
        // die(print_r($_POST));
        satelite_validar();    
        $post_array = $this->input->post();
        $fec_adq   = $this->input->post('act_fecha_adq');
        $fecha_adq = ($fec_adq!='')? formatear_fecha('Y-m-d', $fec_adq):null;
        $fecha_adq = date($fecha_adq.' H:i:s');
        $fecha_ven = $this->input->post('fecha_ven');
        $fecha_v   = ($fecha_ven!='')? formatear_fecha('Y-m-d', $fecha_ven):null;
        $fecha_v   = ($fecha_v)? date($fecha_v.' H:i:s'):null;
        $fecha_ini_dep=$this->input->post('fecha_ini_dep');
        $fecha_ini=($fecha_ini_dep!='')? formatear_fecha('Y-m-d', $fecha_ini_dep):null;
        $activo=$this->input->post('activo_id');    
        $slcProveedor = ($post_array['slcProveedor']!='')?$post_array['slcProveedor'] : null;
        $txtNumFactura = ($post_array['txtNumFactura']!='')?$post_array['txtNumFactura'] : null;
        $txtReferenciaPago = ($post_array['txtReferenciaPago']!='')?$post_array['txtReferenciaPago'] : null;
        ($this->input->post('act_afecta_contabilidad') == 'on' ) ? $afec_conta=1 : $afec_conta=0;
        $cabezera=array(
            'act_id_tac'=>($this->input->post('act_tipo_activo') >0)? $this->input->post('act_tipo_activo'):null,
            'act_id_grp'=>($this->input->post('act_grupo')>0)? $this->input->post('act_grupo'):null,
            'act_id_are'=>($this->input->post('departamento') >0)? $this->input->post('departamento'):null,
            'act_id_cec'=>($this->input->post('centro_costo')>0)? $this->input->post('centro_costo'):null,
            'act_id_tad'=>($this->input->post('act_tipo_tad')>0)? $this->input->post('act_tipo_tad'):null,
            'act_id_uba' => ($this->input->post('slc_ubica') > 0) ? $this->input->post('slc_ubica') : null,
            'act_uso' => (trim($this->input->post('act_usos')) != '') ? trim($this->input->post('act_usos')) : null,
            'act_id_prv'=>($slcProveedor >0)? $slcProveedor:null,
            'act_codigo'=>$this->input->post('act_codigo'),
            'act_afecta_contabilidad'=>$afec_conta,
            'act_id_suc'=>($this->input->post('act_id_suc')>0)? $this->input->post('act_id_suc'):null,
            'act_id_dxd'=>($this->input->post('doc_id_det')>0)?$this->input->post('doc_id_det'):null,
            'act_id_act_dependencia'=>($this->input->post('activo_dxd')>0)?$this->input->post('activo_dxd'):null,
            'act_id_pcl'=>($this->input->post('act_id_pcl')>0)?$this->input->post('act_id_pcl'):null,
            'act_referencia_activo'=>($this->input->post('act_referencia_activo')!='')?$this->input->post('act_referencia_activo'):null,
            'act_nombre'=>$this->input->post('act_nombre'),
            'act_correlativo' => $this->input->post('correlativo'),
            'act_descripcion'=>$this->input->post('descripcion'),
            'act_fecha_adq'=>$fecha_adq,
            'act_depreciable'=>$estado=($this->input->post('act_depreciacion')=='on') ? 1 : 0,
            'act_valor_compra'=>$this->input->post('act_valor_compra'),
            'act_foto'=>($this->input->post('edit_foto')!='')?$this->input->post('edit_foto'):$this->input->post('foto_eliminar'),
            'act_vida_util' => ($this->input->post('act_vida_util')>0)? $this->input->post('act_vida_util'):0,
            'act_fecha_inicia_dep'=>$fecha_ini,  
            'act_fecha_vence_garantia'=>$fecha_v,
            'act_dias_garantia'=>(is_numeric($this->input->post('dias_gar')))? $this->input->post('dias_gar'):0,
            'act_observacion_garantia'=>$this->input->post('observacion_gar'),
            //'act_valor_cont'=>$this->input->post('act_valor_cont'),
            'act_valor_residual'=>($this->input->post('act_valor_residual')>0)? $this->input->post('act_valor_residual'):0,
            'act_porcentaje_dep'=>$this->input->post('act_porcentaje_dep'),
            'act_observacion'=>$this->input->post('act_observacion'),
            'act_factura_compra' => $txtNumFactura,
            'act_referencia_pago' => $txtReferenciaPago,  
            'act_aplica_flujo_proyecto'=> ($this->input->post('act_proyecto')=='on') ? 1 : 0,
            'act_estado'=> $estado=($this->input->post('act_estado')=='on') ? 1 : 0,
            'act_usu_modificacion'=>$this->tank_auth->get_user_id(),
            'act_fecha_modificacion'=>date('Y-m-d H:i:s')
        );
        
        if ($cabezera['act_depreciable'] == 0 && $this->input->post('act_valor_compra') > 0) {
            $cabezera['act_valor_cont'] = $this->input->post('act_valor_compra');
        }

        $existe = 0;
        if (isset($_POST['activo_dxd']) && $this->input->post('activo_dxd')>0) {
            $existe = $this->gsatelite->get_tabla('dxd_detalle_documento_proveedor',array('dxd_id'=>$_POST['activo_dxd']));
            if ($existe) {
                $cabezera['act_id_dxd']=$this->input->post('activo_dxd');
            }
        }        
        $registro = $this->db->where('act_id',$activo)->update('act_activo_fijo',$cabezera);
        //******* Actualizar tabla dxd_detalle_documento_proveedor ********************/
        if (isset($_POST['activo_dxd']) && $this->input->post('activo_dxd')>0 && $existe) {
            $det_act=$this->input->post('activo_dxd');
            if ($registro>0 && $det_act>0 ) {
                $cant=$this->gsatelite->get_campo('dxd_detalle_documento_proveedor', 'dxd_procesado_inventario', array('dxd_id'=>$det_act));
                $sum=(int)$cant+1;
                $this->gsatelite->actualizar_array('dxd_detalle_documento_proveedor', array('dxd_procesado_inventario'=>$sum), array('dxd_id'=>$det_act));
            }
        }

        //Aplicamos los diferentes centros de costo por activo//
                    $costo = $this->input->post('cCosto');
                    $tnc   = $this->input->post('tCuenta');
                    $cnt   = $this->input->post('cCuenta');
                    $por   = $this->input->post('pPorciento');
                     $this->gsatelite->borrado_general('dfv_detalle_finanza_activo',array('dfv_id_act' => $activo));
                    if (is_array($costo) && (count($costo) > 0)) {
                        foreach ($costo as $key => $valor) {
                            $arreglo = array(         
                                'dfv_id_act'             => $activo,
                                'dfv_id_cec'             => $costo[$key],
                                'dfv_id_tcn'             => $tnc[$key],
                                'dfv_id_cnt'             => $cnt[$key],
                                'dfv_porcentaje'         => $por[$key],
                                'dfv_estado'             => 1,
                                'dfv_usu_creacion'       => $this->tank_auth->get_user_id(),
                                'dfv_fecha_creacion'     => date('Y-m-d H:i:s'),
                                'dfv_usu_modificacion'   => $this->tank_auth->get_user_id(),
                                'dfv_fecha_modificacion' => date('Y-m-d H:i:s')

                            );
                            $this->gsatelite->ingresar('dfv_detalle_finanza_activo',$arreglo);
                        }
                    }
                /////---------------------------------------------------///

        /*************************** first caracteristicas **************************************/
        /*$caracteristicas = ($this->input->post('caracteristicas')[0]==0) ? NULL : $this->input->post('caracteristicas'); 
        $estado_cxc=$this->input->post('estado_cxc');
        $valor=$this->input->post('valor_cxc');
        if($_POST['caracteristicas'][0]>0){
            $activo=$this->input->post('activo_id');
            $this->gsatelite->borrado_general('cxc_caracterxactivo', array('cxc_id_act'=>$activo));        
            for ($i=0; $i < count($caracteristicas) ; $i++) { 
                $carxart = array('cxc_id_cxi' =>$caracteristicas[$i] ,
                                 'cxc_id_act' =>$activo,
                                 'cxc_valor'  =>$valor[$i],
                                 'cxc_estado' =>$estado_cxc[$i],
                                 'cxc_usu_creacion'=>$this->tank_auth->get_user_id(),
                                 'cxc_fecha_creacion'=>date('Y-m-d H:i:s'),
                                 'cxc_usu_modificacion'=>$this->tank_auth->get_user_id(),
                                 'cxc_fecha_modificacion'=>date('Y-m-d H:i:s') );
                $this->db->insert('cxc_caracterxactivo',$carxart);
            }
        } // End if*/
        /*******************************************************************************************/
         /* ============================================================================================
              =                                      GRID TAB 1
              ==========================================================================================
          */
        $id_cxc = $this->input->post('id_cxc');  //array id_cxa
        $cxc_id_cxi = $this->input->post('tipo_caracteristica');  //array
        $cxc_valor = $this->input->post('nombre_caracteristica');  //array       
        $consula_cxc = $this->gsatelite->get_tabla('cxc_caracterxactivo', array('cxc_id_act' => $activo, 'cxc_estado' => 1));
        $registros_cxc = array();
        foreach ($consula_cxc as $rcxu) {
            $registros_cxc[] = $rcxu['cxc_id'];
        }
        for ($x = 0; $x < count($cxc_id_cxi); $x++) {
            if (trim($cxc_id_cxi[$x]) != "" && trim($cxc_valor[$x]) != "") {
                if (!in_array($id_cxc[$x], $registros_cxc)) { //preguntar si se ha elegido uno nuevo
                    $this->db->insert('cxc_caracterxactivo', array(
                        'cxc_id_act' => $activo,
                        'cxc_id_cxi' => $cxc_id_cxi[$x],
                        'cxc_valor' => $cxc_valor[$x],
                        'cxc_estado' => 1,
                        'cxc_usu_creacion' => $this->tank_auth->get_user_id(),
                        'cxc_fecha_creacion' => date('Y-m-d H:i:s'),
                        'cxc_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'cxc_fecha_modificacion' => date('Y-m-d H:i:s')
                    ));
                } else {// si existe unicamente actualizar los campos de auditoria
                    $cadena = array(
                        //'cxu_id_art' => $art_id,
                        'cxc_id_cxi' => $cxc_id_cxi[$x],
                        'cxc_valor' => $cxc_valor[$x],
                        'cxc_estado' => 1,
                        'cxc_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'cxc_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->actualizar_array('cxc_caracterxactivo', $cadena, array('cxc_id_act' => $activo, 'cxc_id' => $id_cxc[$x], 'cxc_estado' => 1));
                }
            }
        }      
        for ($kcxu = 0; $kcxu < count($registros_cxc); $kcxu++) {
            if (!in_array($registros_cxc[$kcxu], $id_cxc)) {
                $this->gsatelite->borrado_general('cxc_caracterxactivo', array('cxc_id' => $registros_cxc[$kcxu]));                  
                /*$cadena = array(
                    'cxc_estado' => 0,
                    'cxc_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'cxc_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                $this->gsatelite->actualizar_array('cxc_caracterxactivo', $cadena, array('cxc_id_act' => $activo, 'cxc_id' => $registros_cxc[$kcxu], 'cxc_estado' => 1));*/
            }
        }
        /***********************************************************************************************/
        $foto_eliminar=$this->input->post('foto_eliminar');
        $ruta= "uploads/anexos_activos/".$foto_eliminar;
        unlink($ruta);
        $carpeta = $this->input->post("nombre_carpeta");
        if($this->input->post('edit_foto')!="" ){ //guardar la foto del activo
            $img=$this->input->post('edit_foto');
            $this->guardar_anx($img, $carpeta, 1); //,$titulo
        }
        /***************************************************************************************************************/
        /*                                          Segmento Depreciacion
        /**************************************************************************************************************/
        $fechas_desde      = $this->input->post('fech_inicio_depr');
        $fechas_hasta      = $this->input->post('fech_fin_depr');
        $cuentas_contables = $this->input->post('cnt_cuentas_depr');
        $observaciones     = $this->input->post('observaciones_depr');
        //Si envia las fecha desde se sabe que si hay data que insertar
        if (is_array($cuentas_contables) && count($cuentas_contables)>0) {
            //ELIMINAR LOS DDA DEL ACTIVO ACTUAL
            $this->gsatelite->borrado_general('dda_distribucion_depreciacion_activo', array('dda_id_act' => $activo));
            for ($i = 0; $i < count($cuentas_contables); $i++) {
                $fecha_hasta_dep = $fechas_hasta[$i] != "" ? $fechas_hasta[$i] : null;
                if ($fecha_hasta_dep) {
                    $fecha_hasta_dep = explode("-", $fecha_hasta_dep);
                    $fecha_hasta_dep = $fecha_hasta_dep[1]."-".$fecha_hasta_dep[0];
                    $fecha_hasta_dep = formatear_fecha("Y-m-d", $fecha_hasta_dep);
                }
                $fecha_desde_dep = $fechas_desde[$i] != "" ? $fechas_desde[$i] : null;
                $fecha_desde_dep = explode("-", $fecha_desde_dep);
                $fecha_desde_dep = $fecha_desde_dep[1]."-".$fecha_desde_dep[0];
                $fecha_desde_dep = formatear_fecha("Y-m-d", $fecha_desde_dep);
                $observacion_dep = $observaciones[$i] != "" ? $observaciones[$i] : null;
                $data_dep_insert = array(
                    'dda_id_act' => $activo,
                    'dda_id_cnt' => $cuentas_contables[$i],
                    'dda_fecha_desde' => $fecha_desde_dep,
                    'dda_fecha_hasta' => $fecha_hasta_dep,
                    'dda_observacion' => $observacion_dep,
                    'dda_estado' => 1,
                    'dda_usu_creacion' => $this->tank_auth->get_user_id(),
                    'dda_fecha_creacion' => date('Y-m-d H:i:s'),
                    'dda_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'dda_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                if (trim($fecha_hasta_dep) != "" && $cuentas_contables[$i] > 0) {
                    $this->gsatelite->ingresar('dda_distribucion_depreciacion_activo', $data_dep_insert);
                }
            }
        }
        // Guardar los Anexos
        $rutas_anx    = $this->input->post("ruta");
        $carpeta_anx  = $this->input->post("nombreCarpeta");
        $nuevo_activo =$activo;
        if (count($rutas_anx) > 0) {
            $carpeta_anx = $carpeta_anx;
            for ($i = 0; $i < count($rutas_anx); $i++) {
               if ($rutas_anx[$i] != "") {
                    $doc = $rutas_anx[$i];
                    $nombre = $this->input->post("titulo_doc" . $i);
                    $this->datos_imagen_gral($doc,$nuevo_activo,$carpeta_anx,$nombre);
                }
            }
		} // End guardar anexos
        if($registro>0){
            $alerta=array('registro'=>$registro,'tipo_alerta'=> 'success','titulo_alerta'=>"Registro actualizado ",'texto_alerta'=>"El registro se ha actualizado correctamente.");
        } else {
            $alerta=array('tipo_alerta'=> 'error','titulo_alerta'=>"Registro no actualizado",'texto_alerta'=>"El registro no pudo ser actualizado, verifique la informacion ingresada.");
        }
        $btn=$this->input->post("boton");
        $activo=$this->input->post('activo_id');
        $this->session->set_flashdata($alerta);        
        if($btn==0){
            redirect('activo/nuevo/activo_edit/'.$activo);
        }else{
            redirect('activo/nuevo/index_activos');
        }
    }

function datos_reemplazar_imagen($img,$id_foto,$carpeta,$titulo,$eliminar)
{
    unlink($eliminar);
    $extencion =end(explode(".",$img));
    $datos_1 = $this->session->keep_flashdata('datos_1');
    $nombre= trim($img);
    $ruta= "public/temp/".$carpeta."/".$nombre;
    $destino= "uploads/anexos_activos/".$titulo.".".trim($extencion)."";
    $array=array('anx_nombre'=>$titulo,
                 'anx_url'=>$destino,
                 'anx_usu_mod'=>$this->tank_auth->get_user_id(),
                 'anx_fecha_mod'=>date('Y-m-d H:i:s'));
    $this->db->where('anx_id',$id_foto)
             ->update('anx_anexo',$array);
    $carpeta_destino="uploads/anexos_activos/".$titulo.".".trim($extencion)."";

    copy($ruta,$carpeta_destino);
    unlink($ruta);

}


    public function index(){
        //Verificar Permisos de acceso
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            //Listado de Opciones de Adquicision
            $data['acq_opciones'] = $this->activo_fijo->get_registros_where( 'tad_tipo_adquisicion', array( 'tad_estado' => 1 ));
            //Listado de Grupos de Compra
            $data['grp_opciones'] = $this->activo_fijo->get_registros( 'grp_grupo' );
            //Listado de cuentas contables
            $cnt_contable = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_estado' => 1));
            $options='<option value=""></option>';
            foreach ($cnt_contable as $key) {
                $options.='<option value="'.$key['cnt_id'].'">'.$key['cnt_cuenta'].' - '.trim($key['cnt_nombre']).'</option>';
            }
            $data['cnt_contable'] = $options;
            //Listado de Tipos de Activo
            $data['tac_opciones'] = $this->gsatelite->get_dropdown('tac_tipo_activofijo','{tac_codigo}::{tac_nombre}','',array('tac_estado'=>1) ,null,null,'tac_id',true);
            //Listado de catalogo padre
            $data['cat_opciones'] = $this->activo_fijo->get_registros_where( 'cat_catalogo', array('cat_padre' => 1,'cat_sistema' => 0));
            $data['prv_opciones'] = $this->gsatelite->get_dropdown('prv_proveedor', '[CASE WHEN prv_tipo_pers = 1 THEN CONCAT(prv_nombre," ",prv_apellido) ELSE prv_nombre END]', '', array('prv_estado'=>1) ,null,null,'prv_id',true);
             //SUCURSALES
            $data['suc_sucursales'] = $this->gsatelite->get_dropdown('suc_sucursal', '{suc_codigo}::{suc_nombre}', '', [] ,null,null,'suc_id',true);
            //proyectos(centro de costo)
            $data['pcl_proyecto_cliente'] = $this->gsatelite->get_dropdown('pcl_proyecto_cliente', '{pcl_codigo}::{pcl_nombre}', '', array('pcl_estado'=>1) ,null,null,'pcl_id',true);
            $centro_costo = $this->gsatelite->get_dropdown('cec_centro_costo', '{cec_codigo} - {cec_nombre}', '', array('cec_estado' => 1), 1, '', 'cec_id', true);
            $data["centro_costo"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $centro_costo);
            $documentos = $this->activo_fijo->documentoxproveedor(1);
            //die(print_r($this->db->last_query()));
            $options='<option value=""></option>';
            foreach ($documentos as $doc) {
                //dpv_id
                if($doc['cant'] > 0){
                    if($doc['prv_tipo_pers'] == 1){
                        $options.='<option value="'.$doc['dpv_id'].'">'.$doc['dpv_numero_documento'].' - '.trim($doc['prv_nombre'].' '.$doc['prv_apellido']).'</option>';
                    } else{
                        $options.='<option value="'.$doc['dpv_id'].'">'.$doc['dpv_numero_documento'].' - '.trim($doc['prv_apellido']).'</option>';
                    }
                }
            }
            $data['documentos'] = $options;
            //Proceso para obtener proveedores
            $dataPrv = $this->activo_fijo->get_prv('prv_proveedor', array('prv_estado' => 1), 'prv_id, prv_codigo, prv_nombre, prv_apellido');          
            $optionPrv='<option></option>';
            foreach ($dataPrv as $value) {
                $optionPrv .= '<option value="'.$value['prv_id'].'">'.$value['prv_codigo'].' - '.$value['prv_nombre'].' '.$value['prv_apellido'].'</option>';
            }
            $data['optionPrv'] = $optionPrv;
            //Verificando Tipo de Envio
            if( $_POST ) {
                $token    = trim($this->input->post('act_codigo'));
                $validate = $this->gsatelite->get_tabla('act_activo_fijo',array('act_codigo' => $token));
                $prm_dpnd = json_decode($data['act_dep_monto']=$this->gsatelite->get_parametro('SYS_CONFIGURACION_CODIGO_ACTIVO'), true);
                /* CASO DE ISDEMU , ACTIVO ASOCIADO CON MISMO CODIGO */
                $actDpndc = ($validate > 0 && isset($prm_dpnd['DEPENDENCIA_COPIA_CODIGO']) && $prm_dpnd['DEPENDENCIA_COPIA_CODIGO'] == 1) ? true : false;

                if (count($validate) === 0 || $actDpndc) {
                    $nuevo_act=$this->registrar();
                }else{
                    $nuevo_act = 0;
                }                
                if($nuevo_act > 0) {
                    $alerta=array('registro'=>$registro,'tipo_alerta'=> 'success','titulo_alerta'=>"Registro actualizado ",'texto_alerta'=>"El registro se guardó correctamente.");
                } else {
                    $alerta=array('tipo_alerta'=> 'error','titulo_alerta'=>"Registro no actualizado",'texto_alerta'=>"El registro no pudo ser guardado, verifique la información ingresada.");
                }                
                $this->session->set_flashdata($alerta); 
                $volver=$this->input->post('volver_');
                if($volver==1) {
                    redirect('activo/nuevo/index_activos');
                } else {
                    redirect('activo/nuevo/index');
                }
            } else {
                $data['act_dep_monto']=$this->gsatelite->get_parametro('ACT_DEP_MONTO');
                //Cargar vista 
                $data['titulo_personal'] = "Nuevo activo fijo";
                $a = $this->get_max_codigo('act_activo_fijo','act_id');
                $data['token'] = date('ymd').$a->codigo;
                $cabecera = (isset($data['cabezera']['act_id_uba'])) ? $data['cabezera']['act_id_uba'] : null;
                $unbicaciones_activos = $this->gsatelite->get_dropdown('uba_ubicacion_activo','{uba_codigo} {uba_nombre}','',array('uba_estado' =>1),$cabecera,'','uba_id',true);
                $data['ubicacion_activo'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '',  $unbicaciones_activos);
                $data['tipo_cuenta'] = $this->gsatelite->get_dropdown('tcn_tipo_cuenta','tcn_nombre','',array('tcn_estado' => 1),null,null,'tcn_id',true);
                $data['cuen_con'] = $this->gsatelite->get_dropdown('cnt_cuenta_contable','cnt_nombre','',array('cnt_estado' => 1),null,null,'cnt_id',true);
                $this->_cargarvista( null, $data );    
            }
        }
    }


    public function get_max_codigo($tabla, $campo) {
        $this->db->select('MAX( CAST(' . $campo . ' as unsigned integer)) as codigo', FALSE)
                ->from($tabla)
        ;
        $result = $this->db->get();
        return $result->row();
    }
    
    function _check_proyectos()
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
        if( $this->input->post('act_proyecto') ){
            return ( $this->input->post('act_proyecto') > 0 );
        }
        return false;
    }
    }
    
    function check_saf($valores = 0, $return_ids = false)
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
        if(!$valores){ $valores = $this->input->get_post('act_correlativo'); }
        $data = explode(',', $valores);
        $correlativos = array();
        foreach($data as $row){
            if( strlen($row)>0 && is_numeric($row) && $row > 0 ){
                $correlativos[] = $row;
            }
        }
        $this->db->select('Group_Concat(act_correlativo) as ids');
        $this->db->where_in('act_correlativo', $correlativos);
        $very_corre = $this->db->get('act_activo_fijo')->row();
        if($return_ids){
            return $very_corre->ids;
        }else{
            return !( $very_corre && $very_corre->ids );
        }
    }
    }

    /**
     * Registro de Activo Fijo - Registrar Nuevo Activo Fijo
     */

    public function registrar(){ 
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {  
            // var_dump($_POST);die();
            $token    = trim($this->input->post('act_codigo'));
            
            $validate = $this->gsatelite->get_tabla('act_activo_fijo',array('act_codigo' => $token));
            $prm_dpnd = json_decode($data['act_dep_monto']=$this->gsatelite->get_parametro('SYS_CONFIGURACION_CODIGO_ACTIVO'), true);
            /* CASO DE ISDEMU , ACTIVO ASOCIADO CON MISMO CODIGO */
            $actDpndc = ($validate > 0 && isset($prm_dpnd['DEPENDENCIA_COPIA_CODIGO']) && $prm_dpnd['DEPENDENCIA_COPIA_CODIGO'] == 1) ? true : false;
            
            if ((count($validate) === 0)) {
                $a = true;
            }else{
                if ($validate[0]['act_codigo'] == $token) {
                    $a = (isset($prm_dpnd['DEPENDENCIA_COPIA_CODIGO']) && $prm_dpnd['DEPENDENCIA_COPIA_CODIGO'] == 1) ? true : false;
                }else{
                    $a = true;
                }
            }
            if ((count($validate) === 0 || $actDpndc) && ($token != '' && $a)) {
                $post_array = $this->input->post();
                ($this->input->post('act_estado') == 'on' ) ? $estado = 1 : $estado = 0;
                ($this->input->post('act_proyecto') == 'on' ) ? $flu_proy = 1 : $flu_proy = 0;
                ($this->input->post('act_depreciacion') == 'on' ) ? $depreciacion = 1 : $depreciacion = 0;
                $fec_adq    = $this->input->post('act_fecha_adq');
                $fecha_adq  = ($fec_adq != '')? formatear_fecha('Y-m-d', $fec_adq):null;
                $fecha_adq  = date($fecha_adq.' H:i:s');
                $fecha_ven =  $this->input->post('fecha_ven');
                $fecha_v   = ($fecha_ven!='')? formatear_fecha('Y-m-d', $fecha_ven):null;
                $fecha_v   = ($fecha_v)? date($fecha_v.' H:i:s'):null;
                $fecha_ini_dep = $this->input->post('fecha_ini_dep');
                $fecha_ini     = ($fecha_ini_dep!='')?  formatear_fecha('Y-m-d', $fecha_ini_dep):null;
                $slcProveedor  = ($post_array['act_id_prv']!='')?$post_array['act_id_prv'] : null;
                $txtNumFactura = ($post_array['txtNumFactura']!='')?$post_array['txtNumFactura'] : null;
                $txtReferenciaPago = ($post_array['txtReferenciaPago']!='')?$post_array['txtReferenciaPago'] : null;
                //Campos nuevo
                ($this->input->post('act_afecta_contabilidad') == 'on' ) ? $afec_conta=1 : $afec_conta=0;
                $suc_id = $post_array['act_id_suc'];
                $doc_id = $post_array['doc_proveedor'];
                $doc_id_dxd = $post_array['doc_id_det'];
                $datos=array(
                    'act_id_tac'=>($this->input->post('act_tipo_activo')>0)? $this->input->post('act_tipo_activo'):null,
                    'act_id_grp'=>($this->input->post('act_grupo')>0)? $this->input->post('act_grupo'):null,
                    'act_id_tad'=>($this->input->post('act_tipo_tad')!='')? $this->input->post('act_tipo_tad'):null,
                    'act_id_are'=>($this->input->post('departamento')>0)? $this->input->post('departamento'):null,
                    'act_id_cec'=>($this->input->post('centro_costo')>0)? $this->input->post('centro_costo'):null,
                    'act_id_uba' => ($this->input->post('slc_ubica') > 0) ? $this->input->post('slc_ubica') : null,
                    'act_uso' => (trim($this->input->post('act_usos')) != '') ? trim($this->input->post('act_usos')) : null,
                    'act_id_prv' => ($slcProveedor != '')? $slcProveedor:null,
                    'act_afecta_contabilidad'=>$afec_conta,
                    'act_id_suc'=>($suc_id>0)? $suc_id:null,
                    'act_referencia_activo'=>($this->input->post('act_referencia_activo')!='')?$this->input->post('act_referencia_activo'):null,
                    'act_id_pcl'=>($this->input->post('act_id_pcl')!='')?$this->input->post('act_id_pcl'):NULL,
                    'act_id_act_dependencia'=>($this->input->post('activo_dxd')>0)?$this->input->post('activo_dxd'):null,
                    'act_correlativo' => $this->input->post('correlativo'),
                    'act_id_dxd'=>($this->input->post('doc_id_det')>0)?$this->input->post('doc_id_det'):null,
                    'act_codigo'=>$this->input->post('act_codigo'),
                    'act_nombre'=>$this->input->post('act_nombre'),
                    'act_descripcion'=>$this->input->post('descripcion'),
                    'act_fecha_adq'=>$fecha_adq,
                    'act_depreciable'=>$depreciacion,
                    'act_valor_compra'=>$this->input->post('act_valor_compra'),
                    'act_valor_cont'=>$this->input->post('act_valor_compra'), //el valor de contable en un inicio siempre sera el valor de compra
                    'act_valor_residual'=>($this->input->post('act_valor_residual')>0)? $this->input->post('act_valor_residual'):0,
                    'act_porcentaje_dep'=>$this->input->post('act_porcentaje_dep'),
                    'act_observacion'=>$this->input->post('act_observacion'),
                    'act_aplica_flujo_proyecto'=> $flu_proy,
                    'act_valor_dep' => 0, //DEPRECIACION A ESE MOMENTO
                    //'act_fecha_dep'=>$fecha_ini_dep,
                    //'act_fecha_desact'=>null,
                    //'act_obs_desact'=>null,
                    //'act_valor_libro'=>null,
                    'act_vida_util'=>$this->input->post('act_vida_util'),
                    'act_fecha_inicia_dep'=>$fecha_ini,
                    'act_foto'=>$this->input->post('foto_activo'),
                    'act_fecha_vence_garantia'=>$fecha_v,
                    'act_dias_garantia'=>($this->input->post('dias_gar') > 0)? $this->input->post('dias_gar'):null,
                    'act_observacion_garantia'=>$this->input->post('observacion_gar'),
                    'act_factura_compra' => $txtNumFactura,
                    'act_referencia_pago' => $txtReferenciaPago,
                    'act_estado'=>$estado,
                    'act_usu_creacion'=>$this->tank_auth->get_user_id(),
                    'act_fecha_creacion'=>date('Y-m-d H:i:s'),
                    'act_usu_modificacion'=>$this->tank_auth->get_user_id(),
                    'act_fecha_modificacion'=>date('Y-m-d H:i:s')
                );              
                $alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Registro de activos",'texto_alerta'=>"El registro se guardo correctamente");
                $this->session->set_flashdata($alerta);
                $this->db->insert('act_activo_fijo',$datos);
                $nuevo_activo=$this->db->insert_id();


                    //Aplicamos los diferentes centros de costo por activo//
                    $costo = $this->input->post('cCosto');
                    $tnc   = $this->input->post('tCuenta');
                    $cnt   = $this->input->post('cCuenta');
                    $por   = $this->input->post('pPorciento');
                    if (is_array($costo) && (count($costo) > 0)) {
                        foreach ($costo as $key => $valor) {
                            $arreglo = array(         
                                'dfv_id_act'             => $nuevo_activo,
                                'dfv_id_cec'             => $costo[$key],
                                'dfv_id_tcn'             => $tnc[$key],
                                'dfv_id_cnt'             => $cnt[$key],
                                'dfv_porcentaje'         => $por[$key],
                                'dfv_estado'             => 1,
                                'dfv_usu_creacion'       => $this->tank_auth->get_user_id(),
                                'dfv_fecha_creacion'     => date('Y-m-d H:i:s'),
                                'dfv_usu_modificacion'   => $this->tank_auth->get_user_id(),
                                'dfv_fecha_modificacion' => date('Y-m-d H:i:s')

                            );
                            $this->gsatelite->ingresar('dfv_detalle_finanza_activo',$arreglo);
                        }
                    }
                /////---------------------------------------------------///


                //******* Actualizar tabla dxd_detalle_documento_proveedor ********************/
                $activo=$this->input->post('activo_dxd');
                if ($nuevo_activo>0 && $activo>0 ) {
                    $cant=$this->gsatelite->get_campo('dxd_detalle_documento_proveedor', 'dxd_procesado_inventario', array('dxd_id'=>$activo));
                    $sum=(int)$cant+1;
                    $this->gsatelite->actualizar_array('dxd_detalle_documento_proveedor', array('dxd_procesado_inventario'=>$sum), array('dxd_id'=>$activo));
                }           
                $caracteristicas = $_POST['tipo_caracteristica'];
                $valor           = $_POST['nombre_caracteristica'];            
                $estado_cxc=$_POST['estado_cxc'];
                for ($i=0; $i < count($caracteristicas) ; $i++) {
                    if ($caracteristicas[$i] > 0) {
                        $carxart = array('cxc_id_cxi' =>$caracteristicas[$i] ,
                            'cxc_id_act' =>$nuevo_activo,
                            'cxc_valor'  =>$valor[$i],
                            'cxc_estado' =>1,
                            'cxc_usu_creacion'=>$this->tank_auth->get_user_id(),
                            'cxc_fecha_creacion'=>date('Y-m-d H:i:s'),
                            'cxc_usu_modificacion'=>$this->tank_auth->get_user_id(),
                            'cxc_fecha_modificacion'=>date('Y-m-d H:i:s') 
                        );
                        $this->db->insert('cxc_caracterxactivo',$carxart);
                    }      
                }
                /*=========================================================================================================
                =                                        Fotografía
                =============================================================================================================*/
                //$rutas = $this->input->post("ruta");
                $carpeta = $this->input->post("nombreCarpeta");
                if($this->input->post('foto_activo')!="" and $this->input->post('titulo_foto_activo')!=""){ //guardar la foto del activo
                    $titulo=$this->input->post('titulo_foto_activo');
                    $img=$this->input->post('foto_activo');           
                    $this->guardar_anx($img,$carpeta); //,$titulo
                }
                /*=========================================================================================================
                =                                        ANEXOS
                =============================================================================================================*/
                $rutas_anx = $this->input->post("ruta");
                $carpeta_anx   = $this->input->post("nombreCarpeta_anx");                
                if (count($rutas_anx) > 0) {
                    $carpeta_anx = $carpeta_anx;
                    for ($i = 0; $i < count($rutas_anx); $i++) {
                        if ($rutas_anx[$i] != "") {
                            $doc = $rutas_anx[$i];
                            $nombre = $this->input->post("titulo_doc" . $i);
                            $this->datos_imagen_gral($doc,$nuevo_activo,$carpeta_anx,$nombre);
                        }
                    }
                }                

                //=============================== End guardar anexos =========================================================
                

          

                /*============================================================================================================
                =                                      Distribucion de depreciacion
                =============================================================================================================*/
                $fechas_desde      = $this->input->post('fech_inicio_depr');
                $fechas_hasta      = $this->input->post('fech_fin_depr');
                $cuentas_contables = $this->input->post('cnt_cuentas_depr');
                $observaciones     = $this->input->post('observaciones_depr');
                if (is_array($cuentas_contables) && count($cuentas_contables) > 0) {
                    for ($i = 0; $i < count($cuentas_contables); $i++) {
                        if ($cuentas_contables[$i] > 0) {
                            $fecha_hasta_dep = ($fechas_hasta[$i] != "") ? $fechas_hasta[$i] : null;
                            if ($fecha_hasta_dep) {
                                $fecha_hasta_dep = explode("-", $fecha_hasta_dep);
                                $fecha_hasta_dep = $fecha_hasta_dep[1]."-".$fecha_hasta_dep[0];
                                $fecha_hasta_dep = formatear_fecha("Y-m-d", $fecha_hasta_dep);
                            }
                            $fecha_desde_dep = ($fechas_desde[$i] != "") ? $fechas_desde[$i] : null;
                            $fecha_desde_dep = explode("-", $fecha_desde_dep);
                            $fecha_desde_dep = $fecha_desde_dep[1]."-".$fecha_desde_dep[0];
                            $fecha_desde_dep = formatear_fecha("Y-m-d", $fecha_desde_dep);
                            $observacion_dep = $observaciones[$i] != "" ? $observaciones[$i] : null;
                            $data_dep_insert = array(
                                'dda_id_act'      => $nuevo_activo,
                                'dda_id_cnt'      => $cuentas_contables[$i],
                                'dda_fecha_desde' => $fecha_desde_dep,
                                'dda_fecha_hasta' => $fecha_hasta_dep,
                                'dda_observacion' => $observacion_dep,
                                'dda_estado'      => 1,
                                'dda_usu_creacion'       => $this->tank_auth->get_user_id(),
                                'dda_fecha_creacion'     => date('Y-m-d H:i:s'),
                                'dda_usu_modificacion'   => $this->tank_auth->get_user_id(),
                                'dda_fecha_modificacion' => date('Y-m-d H:i:s')
                            );
                            $this->gsatelite->ingresar('dda_distribucion_depreciacion_activo', $data_dep_insert);
                        }
                    }
                }    
                $datos=$this->db->select()
                                ->from('act_activo_fijo')
                                ->where('act_id',$nuevo_activo)
                                ->join('tad_tipo_adquisicion','tad_id=act_id_tad','left')
                                ->join('tac_tipo_activofijo','tac_id=act_id_tac','left')
                                ->get()->row_array()
                ;
                return $datos;
            }else{
                $alerta=array('tipo_alerta'=> 'info','titulo_alerta'=>"Registro de activos",'texto_alerta'=>"Registro con codigo:".$token." ya existente ");
                $this->session->set_flashdata($alerta);
                return 0;
            }
        }      
    }
    
    public function guardar_gral($parametros, $carpeta=null)
    {
        if ($this->session->flashdata("propietario_id")) {
            $this->session->keep_flashdata("propietario_id");
        }
        if ($this->session->flashdata("datos_inmueble")) {
            $this->session->keep_flashdata("datos_inmueble");
        }
        if ($this->session->flashdata("uso_inmueble")) {
            $this->session->keep_flashdata("uso_inmueble");
        }
        $datos= @explode($parametros);
        $carpeta=$parametros;
       
        $image = $this->upload_gral($carpeta);
        $this->session->keep_flashdata('datos_1');
        echo $image['upload_data']['raw_name'] . $image['upload_data']['file_ext'];
    }

    function upload_gral($carpeta)
    {

        if ($this->session->flashdata("propietario_id")) {
            $this->session->keep_flashdata("propietario_id");
        }
        if ($this->session->flashdata("datos_inmueble")) {
            $this->session->keep_flashdata("datos_inmueble");
        }
        if ($this->session->flashdata("uso_inmueble")) {
            $this->session->keep_flashdata("uso_inmueble");
        }
        if ($this->session->flashdata("datos_1")) {
            $this->session->keep_flashdata("datos_1");
        }

        $ruta=FCPATH . "public/temp/" . $carpeta;
        if(!file_exists($ruta)){
            mkdir($ruta, 0777);
        }

        $this->session->keep_flashdata('datos_1');
        $obj = &get_instance();
        $config['upload_path'] = $ruta;
        $config['allowed_types'] = 'pdf|jpg|png|jpeg';
        $obj->load->library('upload', $config);
        if (!$obj->upload->do_upload()) {
            $error = array('error' => $obj->upload->display_errors());
            return true;
        } else {
            $data = array('upload_data' => $obj->upload->data());
            return $data;
        }
        print_r($data);
    }
    function eliminar_imagen_gral($carpeta="")
    {
        if ($this->session->flashdata("propietario_id")) {
            $this->session->keep_flashdata("propietario_id");
        }
        if ($this->session->flashdata("datos_inmueble")) {
            $this->session->keep_flashdata("datos_inmueble");
        }
        if ($this->session->flashdata("uso_inmueble")) {
            $this->session->keep_flashdata("uso_inmueble");
        }
        $this->session->keep_flashdata('datos_1');
        $url = $this->input->post("url");
        echo $url;
        $carp = ($carpeta != "") ? $carpeta : "documentos";
        
        unlink("./public/temp/$carp/" . $url);
    }

    public function datos_imagen_gral($img,$nuevo_activo,$carpeta,$titulo_doc){
    $extencion =end(explode(".",$img));
    $datos_1 = $this->session->keep_flashdata('datos_1');
    $nombre= trim($img);
    $ruta= "public/temp/".$carpeta."/".$nombre;
    if($extencion=='jpg' || $extencion=='jpeg' || $extencion=='png'){
        $tipo=1;
    }
    else{$tipo=0;}

    $destino= "uploads/anexos_activos/".$titulo_doc.".".trim($extencion)."";
    $array_anex=array(
        'anx_url'=> $destino,
        'anx_nombre'=>$titulo_doc,
        'anx_estado'=>1,
        'anx_usu_mod'=>$this->tank_auth->get_user_id(),
        'anx_fecha_mod'=>date('Y-m-d H:i:s'),
        'anx_usu_crea'=>$this->tank_auth->get_user_id(),
        'anx_fecha_crea'=>date('Y-m-d H:i:s'),
        'anx_imagen'=>$tipo
        );
    $this->db->insert("anx_anexo",$array_anex);
    $id_anexo= $this->db->insert_id();
    $array_anex_doc=array(
        'axa_id_act'=> $nuevo_activo,
        'axa_id_anx' => $id_anexo,
        'axa_estado'=>1,
        'axa_usu_mod'=>$this->tank_auth->get_user_id(),
        'axa_fecha_mod'=>date('Y-m-d H:i:s')

        );
    $this->db->insert("axa_anexoxactivo",$array_anex_doc);
    $carpeta_destino="uploads/anexos_activos/".$titulo_doc.".".trim($extencion)."";

    copy($ruta,$carpeta_destino);
    unlink($ruta);

 


}

    /**
     * Obtiene porcentaje de depreciacion por ID de tipo de activo
     * @return json porcentaje de depreciacion
     */
    public function porcentaje_depreciacion()
    {
        //Verificar acceso unicamente, mediante AJAX
        if ( !$this->input->is_ajax_request() ) {
            exit('No direct script access allowed');
        }

        $id_tipo = $this->input->get('id_tipo');

        $result = $this->activo_fijo->get_porcentaje_depreaciacion( $id_tipo );

        echo $result;
    }

    public function porcentaje_depreciacion2()
    {
        //Verificar acceso unicamente, mediante AJAX
        if ( !$this->input->is_ajax_request() ) {
            exit('No direct script access allowed');
        }

        $id_tipo = $this->input->get('id_tipo');

        $result = $this->activo_fijo->get_porcentaje_depreaciacion2( $id_tipo );

        echo $result;
    }
    
    /**
     * 
     * @author Alexis Beltran
     * @since  2013-10-02
     */
    public function get_saf()
    {   if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
        $codigo     = $this->activo_fijo->get_nuevo_correlativo();
        $codigos    = array();
        $cantidad   = $this->input->post('cantidad');
        for($i= $codigo; $i <= $codigo + $cantidad - 1; $i++ ){
            $codigos[] = $i;
        }
        
        $respuesta = array(
            'response'      => true,
            'correlativo'   => implode(',', $codigos) 
        );
        die(json_encode($respuesta));
    }
}
    
    public function get_codigo()
    {

        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {        
        
        $codigo     = $this->activo_fijo->get_nuevo_correlativo();
        $codigos    = array();
        $cantidad   = $this->input->post('cantidad');
        for($i= $codigo; $i <= $codigo + $cantidad - 1; $i++ ){
            $codigos[] = $i;
        }
        
        $respuesta = array(
            'response'      => true,
            'correlativo'   => implode(',', $codigos) 
        );
        die(json_encode($respuesta));
    }
}


  public function eliminar_activo($activo){
    satelite_validar();

                $this->db->where('act_id', $activo);
                $this->db->where('axe_id_act IS NULL', null, false);
                $this->db->where('act_fecha_desact IS NULL', null, false);
                $this->db->join('axe_activoxempleado', 'axe_id_act=act_id', 'left');
    $activo_del=$this->gsatelite->get_tabla('act_activo_fijo');

    if(count($activo_del)>0){
              $this->gsatelite->borrado_general('cxc_caracterxactivo', array('cxc_id_act'=>$activo));
              $this->gsatelite->borrado_general('axa_anexoxactivo', array('axa_id_act'=>$activo));
      $delete=$this->gsatelite->borrado_general('act_activo_fijo', array('act_id'=>$activo));
    }

    if($delete>0){
        $alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Proceso ejecutado",'texto_alerta'=>"El registro se eliminó correctamente");
        $this->session->set_flashdata($alerta);
    }else{
        $alerta=array('tipo_alerta'=> 'error','titulo_alerta'=>"Proceso no ejecutado",'texto_alerta'=>"Otros registros dependen de éste, por lo que no podrá ser eliminado");
        $this->session->set_flashdata($alerta);
    }

    redirect('activo/nuevo/index_activos');
  }


    function get_dias($fecha_ini=null, $fecha_fin=null, $return = 0){
        satelite_validar();
        if($fecha_ini!=null and $fecha_ini != "0000-00-00 00:00:00" and $fecha_fin!=null and $fecha_fin != "0000-00-00 00:00:00"){
            $inicio=$fecha_ini;
            $fin=$fecha_fin;

            $fecha_ini=new DateTime($inicio);
            $fecha_fin=new DateTime($fin);

            $intervalo = $fecha_ini->diff($fecha_fin);
            $dias=$intervalo->format('%a');

            return $dias;
        }else{
            $inicio=$this->input->post('inicio');
            $fin=$this->input->post('vence');
            //die(print_r($inicio.'*'.$fin));
            $fecha_ini=new DateTime($inicio);
            $fecha_fin=new DateTime($fin);

            $intervalo = $fecha_ini->diff($fecha_fin);
            $dias=$intervalo->format('%a');
            if ($return > 0) {
                return $dias;
            } else {
                echo json_encode($dias);
            }
        }
    }

public function obtener_codigo()
{
    $tac=$this->input->post('tac');
    $grp=$this->input->post('grp');
    $dep=$this->input->post('dep');
    $act=$this->input->post('act');
    $fecha=$this->input->post('fecha');
    $id_dep = $this->input->post('dep_id');
    $tac_abbr= explode("::", trim($tac));
    $grp_abbr = explode("::", trim($grp));
    $dep_abbr = explode("::", trim($dep));
    $act_abbr = explode("::", trim($act));
    $fecha_array = explode("-", $fecha);
    $fecha_abbr = implode('', $fecha_array);
    $id_activo = ($this->input->post('id_activo') > 0)? $this->input->post('id_activo'):0;
    //$correlativo_max=$this->activo_fijo->get_nuevo_correlativo($id_dep);
    
    if ($id_activo>0) {
      $where_correlativo = array('act_id <=' => $id_activo);
      $correlativo_max=$this->gsatelite->count('act_activo_fijo',$where_correlativo);
    } else {
      $correlativo_max=$this->gsatelite->count('act_activo_fijo');
      $correlativo_max = ( $correlativo_max > 0 )?  $correlativo_max+1:1;
    }
    $correlativo=str_pad($correlativo_max,4, "0", STR_PAD_LEFT);
    if($this->gsatelite->get_parametro("FORMATO_CODIGO_ACTIVO")==1){
      $empresa_abbr=$this->gsatelite->get_parametro("ACT_ABBR_EMPRESA");
      $resultado=$empresa_abbr.'-'.$dep_abbr[0].'-'.$tac_abbr[0].'-'.$grp_abbr[0].'-'.$correlativo.'-'.$act_abbr[0].'-'.$fecha_abbr;
    }else{
      $resultado=$grp_abbr[0].'-'.$act_abbr[0].'-'.$correlativo;
    }
    $arreglo = array('codigo' => $resultado );
    echo json_encode($arreglo);
}    


    public function get_grupos()
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
        $tac_id = $this->input->post('id_tipo');
        $grupos = $this->gsatelite->get_tabla( 'grp_grupo', array('grp_id_tac' => $tac_id));
       
        $empleados=$this->activo_fijo->empleados_con_activos();
        $cadena='<option value="" selected></option>';

        foreach ($grupos as $row) {
            $cadena .='<option value="'.$row['grp_id'].'">'.$row['grp_codigo']. '::' .$row['grp_nombre'].'</option>';
        }

        $cadena2='<option value="0" selected> Seleccione una opción </option>';
        foreach ($empleados as $key) {
            $cadena2 .='<option value="'.$key['emp_id'].'">'.$key['emp_apellido'].' '.$key['emp_nombre'].'</option>';
        }

        $arreglo = array(
            'grupo' => $cadena,
            'empleado' => $cadena2,
            'response'  => true,
            'opciones'  => $cadena);
        echo json_encode($arreglo);
     }
 }
    
    /**
     * 
     * @author Alexis Beltran
     */
    public function caracteristicas()
    {
        //Verificar acceso unicamente, mediante AJAX
        if ( !$this->input->is_ajax_request() ) {
            exit('No direct script access allowed');
        }
        
        $id_tipo    = $this->input->post('id_tipo');
        
        $tipo = $this->gsatelite->get_campo('tac_tipo_activofijo', 'tac_codigo', array('tac_id' => $id_tipo));

        $data['detalle'] = $this->activo_fijo->get_caracteristicas($id_tipo);
        $html = $this->load->view('activo/nuevo/caracteristicas', $data, true);
        
        $respod = array(
            'response'  => true,
            'html'      => $html,
            'tipo'      => $tipo
        );
        die(json_encode($respod));
    }
    
    public function search_orden() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
        $data['ordenes'] =  $this->activo_fijo->get_ordenes();
        $this->load->view('activo/nuevo/search_orden', $data);
        }
    }
    
    public function search_facturas()
    {
        
        $data['facturas'] = $this->activo_fijo->get_facturas();
    }
    
    public function documentos() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            
            $activosId = $this->input->get_post('activos');
            if( strlen($activosId) < 1 ){
                $activosId = $this->session->userdata('activos_id');    
            }
            $this->session->set_userdata('activos_id', $activosId);
            
            if( strlen($activosId) > 0 ){
                $activosId = explode('|', $activosId);
                $this->db->where_in('act_id', $activosId);
            }
            
            $activos =  $this->db->get('act_activo_fijo')->result();
            
            $data = array(
                'activosId' => $activosId,
                'activos'   => $activos
            );

            $display_as = array(
                'doc_id_tia'    => 'Tipo de documento',
                'doc_nombre'    => 'Nombre del documento',
                'doc_fecha'     => 'Fecha de documento',
                'doc_desc'      => 'Descripción del documento',
                'doc_archivo'   => 'Archivo'
            );

            $columns = array(
                "doc_nombre", 
                "doc_fecha" , 
                "doc_desc"  , 
                "doc_archivo", 
                'doc_id_tia'
            );

            $add_fields = array(
                "doc_id_tia", 
                "doc_nombre",
                "doc_fecha" ,
                "doc_desc"  ,
                "doc_archivo"
            );

            $edit_columns = array(
                "doc_id_tia", 
                "doc_nombre",
                "doc_fecha" ,
                "doc_desc"  ,
                "doc_archivo"
            );

            $required = array(
                'doc_id_tia',
                "doc_nombre",
                "doc_fecha" ,
                "doc_archivo"

            );
            
            //por defecto siempre es el post llamado valor.
		    //id del mantenimiento
		    //sera necesario un after insert para insertar en la tabla relacional.
            // 1: tabla, 2: id, 3: fk 0: registro
            $dat = "0-dxa_documentosxactivos-dxa_id_act-dxa_id_doc";
            $tabla = explode('-', $dat);
            $this->tabla = $tabla;
            $registro = $tabla[0];
            
		    $crud = new grocery_CRUD();
            $crud->set_table('doc_documento');
            $crud->set_primary_key($tabla[3], $tabla[1]);
            $crud->set_relation("doc_id", $tabla[1], $tabla[3]);           
            $crud->set_subject('Documento');
            $crud->set_relation('doc_id_tia', 'tia_tipo_anexo', '{tia_nombre}');
            $crud->columns($columns);
            $crud->add_fields($add_fields);
            $crud->edit_fields($edit_columns);
            $crud->display_as($display_as);
            $crud->required_fields($required);
            $crud->or_where($tabla[2], $activosId[0]);
            $crud->set_field_upload('doc_archivo', 'assets/uploads/files');
            $crud->callback_after_insert(function($post_array, $primary_key){
                $activos = explode('|', $this->session->userdata('activos_id'));
                foreach ($activos as $act_id) {
                    $this->db->insert($this->tabla[1], array(
			        $this->tabla[2] => $act_id,
			        $this->tabla[3] => $primary_key
			    ));
                }
			    return true;
			});
           
           $crud->unset_export()
                ->unset_print()
                ->unset_read();

           $output = $crud->render();
            
           // $this->_cargarvista($data, $crud->render());
           $this->gsatelite->cargar_vista_masterpage('activo/nuevo/documentos', $data, $output);
    
        }
    }



/********************* ANEXOS DE ACTIVOS *****************************/
	/*
	* Edith Herrera
	*/
    public function guardar_anx($parametros, $carpeta=null, $editar=null){
        $datos= @explode($parametros);        
        // if($editar>0){
        //   $image = $this->upload_anx($parametros, $carpeta);
        // }else{
        $carpeta=$parametros;
        $image = $this->upload_anx($carpeta);
        //}        
        echo $image['upload_data']['raw_name'] . $image['upload_data']['file_ext'];
    }

    /*
	* Edith Herrera
	*/
    function upload_anx($carpeta, $titulo=null) {
        //die(print_r($carpeta));
        if ($carpeta=="assets") {
            $ruta=FCPATH . "uploads/anexos_activos";
            $config['allowed_types'] = 'pdf|jpg|png|jpeg';
        }else{
            $ruta=FCPATH . "public/temp/" . $carpeta;
            $config['allowed_types'] = 'pdf|jpg|png|jpeg|doc|xls|docx|xlsx';
        }
        //die(print_r($ruta));
        if(!file_exists($ruta)){
            mkdir($ruta, 0777);
        }
        $obj = &get_instance();
        $config['upload_path'] = $ruta;
        $obj->load->library('upload', $config);
        if (!$obj->upload->do_upload()) {
            $error = array('error' => $obj->upload->display_errors());
            return true;
        } else {
            $data = array('upload_data' => $obj->upload->data());
            return $data;
        }
        if($titulo!=''){
            $ruta=FCPATH . "public/temp/" . $carpeta."/".$titulo;
            $config['allowed_types'] = 'pdf|jpg|png|jpeg';
        }
        // $carpeta_destino="uploads/anexos_activos/";
        // copy($ruta,$carpeta_destino);
        //unlink($ruta);
        print_r($data);
    }

    /*
	* Edith Herrera
	*/
    function eliminar_imagen_anx($carpeta="") {
        $url = $this->input->post("url");
        $edicion = $this->input->post('edicion');
        /*$anx_id = $this->input->post('anx_id');
        if(isset($anx_id) && !empty($anx_id)){
      	$this->db->delete('axt_anexoxticket', array('axt_id_anx' => $anx_id));
      	$this->db->delete('anx_anexo', array('anx_id' => $anx_id));
        }*/
        if(!empty($edicion)){
            unlink("uploads/anexos_activos/".$url);
        } else {
            $carp = ($carpeta != "") ? $carpeta : "activos";  
            unlink("public/temp/$carp/" . $url);
        }
        echo $url;
    }

   
   public function eliminar_anxaxa($anexo=null,$act=null){
  		if($_POST){
  			$anexo = $this->input->post('anexo');
  			$act = $this->input->post('act');
  		}
		
		if($anexo!=null && $act!=null){
			$where_anx = array('axa_id_act'=>$act, 'axa_id_anx'=>$anexo);
		
			$url = $this->gsatelite->get_campo('anx_anexo','anx_url', array('anx_id'=>$anexo));

			$result = $this->gsatelite->borrado_general('axa_anexoxactivo',$where_anx);
			$result1 = $this->gsatelite->borrado_general('anx_anexo',array('anx_id'=>$anexo));

			if(unlink($url)){
				echo $result;
			}
		}
	}


  public function validar_codigo_activo()
  {
    $codigo = $this->input->post('codigo');
    $id = $this->input->post('id');
    $query = $this->gsatelite->get_tabla('act_activo_fijo',array('act_codigo'=>$codigo,'act_id !='=>$id));
    $registro = $this->gsatelite->get_tabla('act_activo_fijo',array('act_id'=>$id));
    $existe = 0;
    $registro_actual = $registro[0];
    if (count($query)>0) {
      $existe = 1;
    }
    die(json_encode(array('existe'=>$existe,'registro'=>$registro_actual)));
  }

/*********************************************************************/


    /************************ BUSCAR ACTIVO *****************************/
    public function index_buscar(){
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data['centros_costo'] = $this->gsatelite->get_dropdown('cec_centro_costo', '{cec_codigo} - {cec_nombre}', '', array('cec_estado' => 1), null, '', 'cec_id', true);
            $data['clasificacion'] = $this->activo_fijo->get_registros( 'tac_tipo_activofijo' );
            $data['departamento']  = $this->activo_fijo->get_registros('are_area'); 
            $data['titulo_personal']="Búsqueda de activos";
            $this->_cargarvista($data);
        }
    }

    public function get_activos(){
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $departamento     = $this->input->post('depto');
            $clasificacion    = $this->input->post('tipo');
            $subclasificacion = $this->input->post('grupo');
            $empleado         = $this->input->post('emp_id');
            $slcEstado        = (is_array($this->input->post('slcEstado'))) ? $this->input->post('slcEstado') : null;
            $centro_costo     = $this->input->post('slcCenCosto');           
            $parametro        = $this->input->post('inputbusqueda');
            $nombre_activo    = $this->input->post('input_nombres');
            $resultado        = $this->activo_fijo->busqueda_activos($clasificacion, $subclasificacion, $empleado, $parametro, $departamento, $centro_costo, $nombre_activo, $slcEstado);
            $cadena           = '';

            // Impresion de tabla
            foreach ($resultado as $key) {
                $cadena .= '<tr><td>'.$key['act_codigo'].'</td>';
                $cadena .= '<td>'.$key['act_nombre'].'</td>';
                $cadena .= '<td>'.$key['emp_apellido'].' '.$key['emp_nombre'].'</td>';            
                $cadena .= '<td>'.$key['act_valor_cont'].'</td>';            
                $cadena .= '<td>';
                $cadena .= '<div class"tools">';
                $cadena .= '<div class="btn-group">';
                $cadena .= '<button class="btn"><span class="icon16 icomoon-icon-cog-2"></span></button><button class="btn dropdown-toggle" data-toggle="dropdown">';
                $cadena .= '<span class="caret"></span></button>';
                $cadena .= '<ul class="dropdown-menu">';
                $cadena .= '<li>';
                $cadena .= '<a class="" href="'.base_url('activo/nuevo/detalles?id='.$key['act_id']).'">';
                $cadena .= '<span aria-hidden="true" class="icomoon-icon-stack"></span>';
                $cadena .= 'Detalles</a>';
                $cadena .= '</li>';
                $cadena .= '<li>';
                $cadena .= '<a class="ver-accion-modal" href="'.base_url('activo/nuevo/documentos?activos='.$key['act_id']).'">';
                $cadena .= '<span aria-hidden="true" class="entypo-icon-document"></span>';
                $cadena .= 'Anexar Documentos</a>';
                $cadena .= '</li>';
                $cadena .= '</ul>';
                $cadena .= '</div>';
                $cadena .= '</div>';
                $cadena .= '</td></tr>';
            }

            $arreglo = array(
                'datos'     => $cadena,
                'consulta'  => $this->db->last_query(),
                'post'      => $_POST
            );
            echo json_encode($arreglo);
        }
    }
    
    public function save_baja()
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $activos    = $this->input->post('activos');
            $emp_id     = $this->input->post('emp_id');
            $ubi_id     = $this->input->post('ubi_id');
            $obs        = $this->input->post('obs');
            $usu_id     = $this->tank_auth->get_user_id();
            
            if( is_array($activos) && ( $emp_id || $ubi_id  ) ){
                
                if( is_numeric($emp_id) && $emp_id > 0 ){
                    $empleado = $this->gsatelite->get_registro('vw_empleados', array('emp_id' => $emp_id));
                }
                
                foreach( $activos as $activo ){
                    if( !isset($empleado) ){
                        echo $activo;
                        $this->db->select("vw_empleados.*")->join('vw_empleados', 'vw_activos.emp_id = vw_activos.emp_id');
                        $empleado = $this->gsatelite->get_registro('vw_activos', array('act_id' => $activo));
                    }
                    
                    $this->db->update('axe_activoxempleado', 
                        array('axe_estado' => 0, 'axe_use_mod' => $usu_id), array('axe_id_act' => $activo));
                    $this->db->insert('axe_activoxempleado', array(
                        'axe_id_act'    => $activo,
                        'axe_id_emp'    => $empleado->emp_id,
                        'axe_id_are'    => $empleado->are_id,
                        'axe_id_are'    => ($ubi_id)? $ubi_id : $empleado->ubi_id,
                        'axe_fecha'     => date('Y-m-d'),
                        'axe_obs'       => $obs,
                        'axe_use_mod'   => $usu_id
                        ));
                }
                
                $this->db->where_in('act_id', $activos);
                $activos_data =  $this->db->get('vw_activos')->result();
                
                $this->load->library('pdf');
                $html  = $this->load->view('reporte/header', array('titulo' => 'Traslado de Activos'), true);
                $html .= $this->load->view('activo/nuevo/reporte', array('activos' => $activos_data), true);
                $this->pdf->setPageOrientation('P');
                $this->pdf->makePDF($html);
            }else{
                $this->gsatelite->show_dialog('Activos Trasladados.', 'activo/nuevo/ver_activos', 'error');
            }
        }
    }
/***************************************************************************************************************/

/*******************************************  DEPRECIACIÓN *****************************************************/
    public function index_depreciacion(){
    //Verificar Permisos de acceso
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            // $data['act_opciones'] = $this->activo_fijo->get_listado_depreciacion(null, '1', null, null, null, null, null, null, 1);
            $areas = $this->gsatelite->get_dropdown('are_area', '{are_prefijo}::{are_nombre}','', null, null, '', 'are_id', true);
            $tipo_act = $this->gsatelite->get_dropdown('tac_tipo_activofijo', '{tac_codigo}::{tac_nombre}', '', array('tac_estado'=>1), null, null, 'tac_id', true);
            // var_dump($this->db->last_query());die();
            $data['areas'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $areas);
            $data['tipos_activo'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $tipo_act);
            $data['titulo_personal'] = "Depreciación";
            $this->_cargarvista( null, $data );
        }
        
    }
    /**
     * @author Manuel Anzora
     * @date 20-12-2018
     * @descripcion: Metodo para obtener  detalle de depreciacion filtrado por fechas
     * @return retorna detalle de depreciacion de activos en html
     */
    public function depreciacion_detalle_filter(){
        if($_POST){
            $fechaini = $this->input->post('txtFechaIni');
            $fechafin = $this->input->post('txtFechaFin');
            $tac_act = ($this->input->post('tipo_activo') > 0) ? $this->input->post('tipo_activo') : null;
            $grp_act = ($this->input->post('grupo_activo') > 0) ? $this->input->post('grupo_activo') : null;
            $are_act = ($this->input->post('unidad') > 0) ? $this->input->post('unidad') : null;
            if($fechaini == '' && $fechafin == ''){
                $data['act_opciones'] = $this->activo_fijo->get_listado_depreciacion(null,'1',$tac_act,$grp_act,$are_act, null, null, null, 1);
            }else{
                $fechaini = date('Y-m-d', strtotime($fechaini));
                $fechafin = date('Y-m-d', strtotime($fechafin));
                $data['act_opciones'] = $this->activo_fijo->get_listado_depreciacion(null,'1',$tac_act,$grp_act,$are_act, null, $fechaini, $fechafin, 1);
            }
            $data['titulo_personal'] = "Depreciación";
            $html = $this->load->view('activo/nuevo/rpt_depreciacion_detalle_filter', $data, true);
            echo json_encode($html);
        }
    }

    public function reporte_depreciacion($band = null) {
      //DATOS GENERALES
      ini_set( 'memory_limit', '2048M' );
      ini_set('max_execution_time', '9999');
      if($band!=null){
        //ES ENVIADO DESDE EL SUBMIT DE UN FORM
        $fechaini = $this->input->post('fechaini');
        $fechafin = $this->input->post('fechafin');
        $tac_act = ($this->input->post('tacActiv') > 0) ? $this->input->post('tacActiv') : null;
        $grp_act = ($this->input->post('grpActiv') > 0) ? $this->input->post('grpActiv') : null;
        $are_act = ($this->input->post('areActiv') > 0) ? $this->input->post('areActiv') : null;
        
        if($fechaini == '' && $fechafin == ''){
        
          $lista = $this->activo_fijo->get_listado_depreciacion(null,'1',$tac_act,$grp_act,$are_act, null, null, null, 1);
        }else{
          $fechaini = date('Y-m-d', strtotime($fechaini));
          $fechafin = date('Y-m-d', strtotime($fechafin));
          $lista = $this->activo_fijo->get_listado_depreciacion(null,'1',$tac_act,$grp_act,$are_act, null, $fechaini, $fechafin, 1);
        }
        /*----------------------*/
        $data['titulo'] = 'Detalle depreciación';
        $data['activo'] = $lista;
        $header = $this->load->view('reporte/header', $data, true);
        
        $html .= $this->load->view('activo/nuevo/print_depreciacion', $data, true);
        $GLOBALS['nombre_reporte'] = 'Reporte_Detalle_Depreciacion_' . date('dmY');
        $reporte = $header . $html;
        //echo $reporte;die();
        $this->pdf->SetMargins(10, 10, 10, 50);
        $this->pdf->makePdf($reporte, 'P', 'Detalle_depreciacion', 'Letter');
      }else{
        $lista = $this->activo_fijo->get_listado_depreciacion(null, '1', null, null, null, null, null, null, 1);
        /**--------------------------------------*/
        $data['titulo'] = 'Detalle depreciación';
        $data['activo'] = $lista;
        $header = $this->load->view('reporte/header', $data, true);
        
        $html .= $this->load->view('activo/nuevo/print_depreciacion', $data, true);
        $GLOBALS['nombre_reporte'] = 'Reporte_Detalle_Depreciacion_' . date('dmY');
        $reporte = $header . $html;
        //echo $reporte;die();
        $this->pdf->SetMargins(10, 10, 10, 50);
        $this->pdf->makePdf($reporte, 'P', 'Detalle_depreciacion', 'Letter');




        //$this->load->library('pdf');
        //$html  = $this->load->view('reporte/header', array('titulo' => 'Depreciación generada'), true);
        //$html .= $this->load->view('activo/nuevo/print_depreciacion', array('activo' => $lista), true);
        //$reporte=$this->pdf->reportePDF2($html);
      }

    }
    public function run_depreciacion(){ 
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            ini_set( 'memory_limit', '2048M' );
            ini_set('max_execution_time', '9999');            
            if(!empty($_POST['periodo']) && is_array($_POST['periodo']) && count($_POST['periodo'])>0){   
                $id_user = $this->tank_auth->get_user_id();
                $msj_respuesta = "";
                             $this->db->order_by("prd_codigo","ASC");
                $registros = $this->gsatelite->get_tabla('prd_periodo_deprec',array('prd_id IN ('.implode(',', $_POST['periodo']).')'=>null));
                $sp_usa_dp = $this->gsatelite->get_parametro_emp('DEP_FRECUENCIA', '2');
                $n=0;
                foreach ($registros as $fila) {
                    $fecha_dep = $fila['prd_ano'] . '-' . $fila['prd_mes'] . '-01';
                    $fecha_dep = formatear_fecha('Y-m-t', $fecha_dep); // CASO SERSAPROSA / EN SP SE AGREGO OTRO CASE WHEN VIDA_UTIL = 0 THEN 0 EN EL dep_monto                    
                    if (isset($_POST['slcActivo']) && count($_POST['slcActivo']) > 0 && is_array($_POST['slcActivo']) && $_POST['slcActivo'][0] > 0) {
                        $datosAct = explode(",", $_POST['slcActivo'][0]);
                        for ($k=0; $k < count($datosAct); $k++) { 
                            if ($sp_usa_dp == 1) {
                                $cuentas = $this->db->query('CALL sp_ejecutar_depreciacion_mensual_diaria_act("'.$fila['prd_id'].'","'.$id_user.'","'.$fecha_dep.'","'.$datosAct[$k].'");'); /* CALCULO DIARIO = (V_DEPRECIABLE / TOTAL DIAS) X DIAS_MES */
                            } else {
                                $cuentas = $this->db->query('CALL sp_ejecutar_depreciacion_mensual_act("'.$fila['prd_id'].'","'.$id_user.'","'.$fecha_dep.'","'.$datosAct[$k].'");');
                            }                            
                            clean_mysqli_connection($this->db->conn_id);
                        }
                    } else {
                        if ($sp_usa_dp == 1) {
                            $cuentas = $this->db->query('CALL sp_ejecutar_depreciacion_mensual_diaria("'.$fila['prd_id'].'","'.$id_user.'","'.$fecha_dep.'");');
                        } else {
                        $cuentas = $this->db->query('CALL sp_ejecutar_depreciacion_mensual("'.$fila['prd_id'].'","'.$id_user.'","'.$fecha_dep.'");');
                        }                        
                        clean_mysqli_connection($this->db->conn_id);
                    }
                    $n++;
                }
                $msj_respuesta=" Se procesaron " . $n . " periodo(s)";
                //$registro = $this->gsatelite->get_registro('prd_periodo_deprec','prd_id',$_POST['periodo']);
                //$fecha_dep = $registro->prd_ano . '-' . $registro->prd_mes . '-01';
                //$cuentas = $this->db->query('CALL sp_ejecutar_depreciacion_mensual("'.$_POST['periodo'].'","'.$id_user.'","'.$fecha_dep.'");');
                //clean_mysqli_connection($this->db->conn_id);
                if ($_POST["tipo_accion"] == 1) {
                    $this->gsatelite->show_dialog("Depreciación Generada con éxito $msj_respuesta", 'activo/nuevo/generar_depreciacion','success');
                } else {  
                    $this->gsatelite->show_dialog("Depreciación Generada con éxito $msj_respuesta", 'activo/nuevo/index_depreciacion','success');
                }
            }

        }
    }

    public function generar_depreciacion()
    {
       if (!$this->tank_auth->is_logged_in()) {
        redirect('/auth/login/');
        } else {
            $this->load->library('EnLetras');
                  $this->db->order_by("prd_codigo","ASC");
        $periodos=$this->gsatelite->get_tabla('prd_periodo_deprec', array('prd_estado'=>1)); 

            $var = '';
            $mes = '';
            foreach ($periodos as $key => $value ) {
                    $mes=$this->enletras->mes_anio(null,3,$value['prd_mes']);
                    $var .= "<option value='".$value['prd_id']."' fperiodo1='". $value['prd_ano'] . '-' . str_pad($value['prd_mes'], 2, '0', STR_PAD_LEFT)."-01' fperiodo2='". $value['prd_ano'] .  str_pad($value['prd_mes'], 2, '0', STR_PAD_LEFT)."' >".$mes." -- ".$value['prd_ano']."</option>";    
                    }
        $data['periodos'] = $var;
        $data["titulo_personal"]="Generar depreciación";
        $this->_cargarvista(null,$data);
        }
    }

    public function detalles(){
        //Verificar Permisos de acceso
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $this->load->library('EnLetras');
            $id_activo = $this->input->get('id');
            //Verificar acceso unicamente a traves de url
            if ( $id_activo === false || $id_activo == "" || !is_numeric( $id_activo ) ){
                redirect( base_url('activo/nuevo/index_depreciacion') );
            }
            $url = $this->input->get('u');
            $data['redirecto_to']     = ($url == "d") ? "index_depreciacion" : "index_buscar";
            $data['act_id']           = $id_activo;
            $data['act_detalles']     = $this->activo_fijo->get_detalles_activo_completo( $id_activo )->row();
            $data['caracteristicas2'] = $this->activo_fijo->get_caracteristicaxactivo($id_activo); 
            $data['act_depreciacion'] = $this->activo_fijo->get_depreciacion_acumulada( $id_activo );
            $permisoExporta = $this->gsatelite->get_permisos_opcion('activo/reportes/depreciacion_detalle', null, null, true);
            $data['exportacion'] = is_array($permisoExporta) ? 1 : 0;
            $data['titulo_personal']  ="Detalles";
          $data['editar_monto_dep'] = ($this->gsatelite->get_parametro('SYS_EDITAR_MONTO_DEP')>0) ? 1 : 0;
          $this->_cargarvista( null, $data );        
      }
        
    }

    
    public function add_detalle()
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            extract($this->input->post());
            
            if( $act_id && $fecha && $monto ){
                $this->db->insert('dep_depreciacion', array(
                    'dep_id_act'    => $act_id,
                    'dep_monto'     => $monto,
                    'dep_fecha'     => $fecha
                    ));
            }
            
            $this->gsatelite->show_dialog('Depreciaciones', '/activo/nuevo/detalles?id=' . $act_id);
        }
    }
    
    public function dep_update()
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $dep_id = $this->input->post('registro');
            $valor  = $this->input->post('valor');
            $result = false;
            $monto  = 0.0; 
            
            if( $dep_id && is_numeric($dep_id) && $dep_id > 0 && $valor > 0 ){
                $result = $this->db->update('dep_depreciacion', array('dep_monto' => $valor), array('dep_id' => $dep_id), 1);
                $monto  = $this->gsatelite->get_campo('dep_depreciacion', 'dep_monto', array('dep_id' => $dep_id));
                $data = $this->gsatelite->get_campo('dep_depreciacion', '*', array('dep_id' => $dep_id));
            }
            
            $ret['response']    = $result;
            $ret['monto']       = (float) $monto;
            $ret['o_monto']     = $monto;
            $ret['all_shit']    = $data;
            
            die(json_encode($ret));
        }
    }

    public function simulacion(){
        //Verificar Permisos de acceso
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            // $this->output->enable_profiler( ENVIRONMENT == 'development' );
            $tipo = $grupo = null;
            $listado = array();
            $filtros = array('fecha_ini' => '', 'fecha_fin' => '');
            if ($_POST) {
                // var_dump($_POST);die();
                if ($_POST['codigo'] > 0) {
                    $act = $_POST['codigo'];
                    $filtros['activo_selected'] = $this->gsatelite->get_registro('act_activo_fijo', array('act_id' => $_POST['codigo']));
                } else {
                    $act = null;
                }
                if ($_POST['tipo_activo'] > 0) {
                    $tipo = $tip = $_POST['tipo_activo'];
                } else {
                    $tip = null;
                }
                if ($_POST['grupo'] > 0) {
                    $grupo = $grp = $_POST['grupo'];
                } else {
                    $grp = null;
                }
                if ($_POST['fecha_ini'] != "") {
                    $filtros['fecha_ini'] = $_POST['fecha_ini'];
                    $fini = formatear_fecha('Y-m-d', $_POST['fecha_ini']);
                } else {
                    $fini = null;
                }
                if ($_POST['fecha_fin'] != "") {
                    $filtros['fecha_fin'] = $_POST['fecha_fin'];
                    $ffin = formatear_fecha('Y-m-d', $_POST['fecha_fin']);
                } else {
                    $ffin = null;
                }                
                $listado =  $this->activo_fijo->get_listado_depreciacion($act, 1, $tip, $grp, null, null, $fini, $ffin, 1);
            }
            $grupo = $this->gsatelite->get_dropdown('grp_grupo', '{grp_codigo} - {grp_nombre}','', null, $grupo, '', 'grp_id', true);
            $tipo_activo = $this->gsatelite->get_dropdown('tac_tipo_activofijo', '{tac_codigo} - {tac_nombre}', '', array('tac_estado'=>1), $tipo, null, 'tac_id', true);
            $data['filtro'] = $filtros;
            $data['act_opciones'] = $listado;
            $data['grupo'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $grupo);
            $data['tipo_activo'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $tipo_activo);
            $this->_cargarvista( null, $data );    
            
        }
        
    }

    public function generar()
    {
        //Verificar Permisos de acceso
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $permisos = $this->gsatelite->get_permisos_opcion('activo/nuevo/simulacion');
            $data['permisos']=$permisos;
            //Obtener ID de activo fijo
            $id_activo = $this->input->get('id');
            $data['registro_act'] = $this->gsatelite->get_registro('act_activo_fijo','act_id',$id_activo);
             //Verificar acceso unicamente a traves de url
            if ( $id_activo === false || $id_activo == "" || !is_numeric( $id_activo ) ){
                redirect( base_url('activo/nuevo/simulacion/') );
            }
            $meses_suma = (formatear_fecha('d',$data['registro_act']->act_fecha_inicia_dep) != '01')? 1:0;
            //Generar simulacion de depreciacion y guardarla en des_simulacion_dep
            $this->activo_fijo->generar_simulacion( $id_activo, $meses_suma );
            //Preparar informacion a enviar a la vista
            $data['id_activo'] = $id_activo;
            $data['titulo_personal'] = "GENERAR SIMULACIÓN";
            $this->_cargarvista( null, $data );    
        }
    }

    public function iniciar_simulacion($es_reporte=0)
    {
        //Verificar acceso unicamente, mediante AJAX
        if ( !$this->input->is_ajax_request() and $es_reporte==0) {
            exit('No direct script access allowed');
        }
        //print_r('aca voy');
        //die();

        //Inicializando variables a usar
        $id_activo    = $this->input->post('id_activo' );
        $fecha_inicio = formatear_fecha('Y-m-d', $this->input->post('gen_fecha_inicio'));
        $fecha_fin    = formatear_fecha('Y-m-d', $this->input->post('gen_fecha_fin'));
        $slcAgrupar    =  $this->input->post('slcAgrupar');
        $result = $this->activo_fijo->get_datos_simulacion($id_activo, $fecha_inicio, $fecha_fin, $slcAgrupar );
        //print_r($this->db->last_query()); die();
        $result = ($result)? (array) json_decode($result):array();
        $datos['datos_simulacion'] = $result;
        $datos['gen_fecha_inicio'] = $fecha_inicio;
        $datos['gen_fecha_fin'] = $fecha_fin;
        $datos['slcAgrupar'] = $slcAgrupar;
        $datos['id_activo'] = $id_activo;
        $datos['es_reporte']=$es_reporte;
        $activo = $this->activo_fijo->get_info_activo(array('act_id'=>$id_activo));
        $datos['datos_activo'] = $activo[0];

        $registro_asignacion = $this->activo_fijo->get_info_activo_asignacion(array('axe_id_act'=>$id_activo,'axe_estado'=>1));
        $datos['responsable'] = ($registro_asignacion)? $registro_asignacion[0]: array("emp_nombre"=>'',"emp_apellido"=>'');
        $datos['encargado_activo'] = explode(',', $this->gsatelite->get_parametro('SYS_ENCARGADO_ACTIVO_FIJO'));

        //print_r($datos['datos_simulacion']['message']); die();
        $html = $this->load->view('activo/nuevo/iniciar_simulacion', $datos, true);
        //print_r($result); die();
        $datos['periodo'] = (($fecha_inicio)?  'De: '.formatear_fecha('Y-m-d', $fecha_inicio):'') . (($fecha_fin)?  ' Hasta: '.formatear_fecha('Y-m-d', $fecha_fin):( ($result['response'] == 1)? ' Hasta: '.($result['message'][(count($result['message'])-1)]->ultima_fecha):''));
        if ($es_reporte) {
            $tipo_accion = $this->input->post('tipo_accion');
            $filtro_titulo = ($fecha_inicio==$fecha_fin)? "De: ".date_format(date_create($fecha_inicio), 'd-m-Y'):"".$datos['periodo'];

            if ($tipo_accion) { //excel
                header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                header("Content-Disposition: attachment;filename=simulacion_depreciacion".date('d-m-Y_His').".xls"); 
                header("Pragma: no-cache");
                header("Expires: 0");
                echo '<meta charset="utf-8" />';
                echo "<table border='0'>
                  <tr><th colspan='4' align='center' >".mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'),'UTF-8')."</th></tr>
                  <tr><th colspan='4' align='center' >Simulación de depreciación de Activo</th></tr>
                  <tr><th colspan='4' align='center' >".$filtro_titulo. "</th></tr>
                  </table>";
                echo $html; die();
            } else { //pdf
                ini_set( 'memory_limit', '2048M' );
                ini_set('max_execution_time', '9999');

                $this->load->library('pdf');
                $html_header=$this->load->view('reporte/header', array('titulo' => "Reporte Simulación de Depreciación de Activo<br /> $filtro_titulo", 'solotitulo'=> true), true);
                $html = str_replace('border="1" style="margin-left: 4px; width: 99%; font-size:12px;"','border="0.5" style="width: 100%; font-size:9px;"',$html);
                $this->pdf->makePDF($html_header.$html,'L',''.'Letter');
               // $this->pdf->makePdf($reporte, 'L', 'Reporte_asignacion_activos', 'Letter');
                die();
            }
        }

        echo json_encode(array('html'=>$html, 'response'=>$result['response']));
        exit();
        
    }



    /**
     * CALLBACKS
     * 
     * @author Mario Marquez
     * @since 04/12/2015
     */
    function validar_fechas_periodo($f_hasta,$f_desde){
        //Obtengo las fechas
        $f_desde = $this->input->post('prd_desde');
        $f_hasta = $this->input->post('prd_hasta');
        $f_1 = explode('-', $f_desde);
        $f_2 = explode('-', $f_hasta);
        //convierto las fechas en juliano para mejor comparación
        $diasPrimeraJuliano = gregoriantojd($f_1[1], $f_1[2], $f_1[0]); 
        $diasSegundaJuliano = gregoriantojd($f_2[1], $f_2[2], $f_2[0]); 

        $f_diff = $diasSegundaJuliano - $diasPrimeraJuliano;
        if($f_diff<0){
            $this->form_validation->set_message('validar_fechas_periodo','Fecha de finalización no puede ser menor que fecha de inicio');
            return false;
        }else{
            return true;
        }
    }


    

    /*********************************************** BAJAS *********************************************************/
    public function index_bajas(){
        //Verificar Permisos de acceso
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $activo = $this->gsatelite->get_dropdown('tac_tipo_activofijo', '{tac_codigo} - {tac_nombre}', '', array('tac_estado' => 1), null, null, 'tac_id', true);
            $data['tipos'] = str_replace('<option value="0">Seleccione</option>', '<option value="0">Todos</option>', $activo);
            $data['activos'] = null;//$this->activo_fijo->get_listado_depreciacion(null,'2');
            $data['titulo_personal'] = "Baja/Reactivación de activos";
            $this->_cargarvista(null, $data);
        }
    }

    /**
    * Depreciacion A-F: Obtiene listado de activos, costo, monto de depreciacion acumulado 
    * y los meses depreciados 
    * @author Carlos Alberto Noyola
    * @since 2018-03-20
    * @param integer $tipo_activo  ID del tipo de activo a buscar
    * @return Vista parcial de la tabla de activos de baja
    */
    public function index_bajas_busqueda(){
        if($_POST){
            $tipo_activo = ($this->input->post('tipo_activo') > 0) ? $this->input->post('tipo_activo') : null;
            $codigo   =  ($this->input->post('codigo_activo') !== '') ? $this->input->post('codigo_activo') : null;
            if ($codigo !== null) {
                $codigo  = $this->gsatelite->get_campo('act_activo_fijo', 'act_codigo', array('act_id' => $codigo));
            }
            if ($tipo_activo) {
                $data['activos'] = $this->activo_fijo->get_listado_depreciacion_busqueda(null, null, $tipo_activo,null,$codigo);
            } else {
                $data['activos'] = $this->activo_fijo->get_listado_depreciacion_busqueda(null, null, null, null,$codigo);
            }
            $html = $this->load->view('activo/nuevo/index_bajas_busqueda',$data,true);
            echo $html;
        } 
    }

    /**
        * @author Habby Lovo
        * @date 25/09/2017
    */
    public function dar_baja_activo($id_act=null,$masivas = null) {
        if($_POST){
            // var_dump($_POST);die();
            // Preguntamos si son masivas
            if ($masivas) {
                $ids_activos = explode(',', $this->input->post('ids_procesar'));
                $motivo      = $this->input->post('motivo_masivo');
                $fecha       = date('Y-m-d H:i:s');
                $observacion = $this->input->post('obs_masivo');
                $arrayrutas  = json_decode($this->input->post('ruta_archivos'), true);
                $arraynombre = json_decode($this->input->post('nombre_archivo'), true);
                foreach ($ids_activos as $key => $activo) {
                    $result = $this->activo_fijo->set_baja_activo($activo, $observacion, $motivo, $fecha);   
                }
                if (count($arrayrutas) > 0) {
                    foreach ($arrayrutas as $k => $val) {
                        $xarry = explode(".", $val);
                        $extension = end($xarry);
                        $nevo_name = $arraynombre[$k];
                        $f_procede = 'public/temp/activos/' . $val;
                        $f_destino = 'uploads/anx_baja_activos/'.$nevo_name.'.'.trim($extension);
                        $anx_baj = array(
                            'aba_id_mba' => $motivo,
                            'aba_nombre' => $nevo_name,
                            'aba_anexo' => $f_destino,
                            'aba_estado' => 1,
                            'aba_usu_creacion' => $this->tank_auth->get_user_id(),
                            'aba_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'aba_fecha_creacion' => date('Y-m-d H:i:s'),
                            'aba_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        foreach ($ids_activos as $ka => $act) {
                            $anx_baj['aba_id_act'] = $act;
                            $this->db->insert("aba_anexo_baja_activo", $anx_baj);
                        }
                        copy($f_procede, $f_destino);
                        unlink($f_procede);
                    }
                }
                if ($result['message']['resultado']) {
                    echo json_encode(array('respuesta'=>true,'ids'=>$this->input->post('ids_procesar')));
                    die();
                }
            }
            // Baja individual de activos
            $id_activo   = $this->input->post('id_act');
            $motivo      = $this->input->post('motivo');
            $observacion = $this->input->post('obs');
            $fecha       = formatear_fecha('Y-m-d', $this->input->post('fecha_baja'));
            $result      = $this->activo_fijo->set_baja_activo($id_activo, $observacion, $motivo, $fecha);
            $rutas_anexo = $this->input->post('ruta');
            if (count($rutas_anexo) > 0) {
                foreach ($rutas_anexo as $k => $val) {
                    $xarry = explode(".", $val);
                    $exten = end($xarry);
                    $new_name = $this->input->post("titulo_doc$k");
                    $destino = 'uploads/anx_baja_activos/'.$new_name.'.'.trim($exten);
                    $procede = 'public/temp/activos/' . $val;
                    $anx_baj = array(
                        'aba_id_mba' => $motivo,
                        'aba_id_act' => $id_activo,
                        'aba_nombre' => $new_name,
                        'aba_anexo' => $destino,
                        'aba_estado' => 1,
                        'aba_usu_creacion' => $this->tank_auth->get_user_id(),
                        'aba_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'aba_fecha_creacion' => date('Y-m-d H:i:s'),
                        'aba_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $this->db->insert("aba_anexo_baja_activo", $anx_baj);
                    copy($procede, $destino);
                    unlink($procede);
                }
            }
            $alerta      = array('tipo_alerta'=> 'success','titulo_alerta'=>"Baja de activo",'texto_alerta'=>"La baja del activo se guardó correctamente");
            $this->session->set_flashdata($alerta);
            redirect('activo/nuevo/index_bajas?baja='.$id_activo);
        } else{
            $data['id_activo']  = $id_act;
            $data['dato_activo']= $this->activo_fijo->obtener_activos_fijo_dar_baja(array('act_id'=>$id_act, 'act_estado'=>1));
            $motivos_reg        = $this->gsatelite->get_dropdown('mba_motivo_baja_activo', '{mba_nombre}', '', array('mba_estado'=>1), null, '', 'mba_id', true);
            $data['motivos']    = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $motivos_reg);
            $this->load->view('activo/nuevo/observaciones', $data);
        }
    }

    public function get_motivos(){
       $motivos_reg        = $this->gsatelite->get_dropdown('mba_motivo_baja_activo', '{mba_nombre}', '', array('mba_estado'=>1), null, '', 'mba_id', true);
       $motivos_reg = str_replace('<option value="0">Seleccione</option>','', $motivos_reg);

      echo json_encode(array('options'=>$motivos_reg));
      die();
    }

    public function pdf_baja($id_act,$es_masiva = null)
    {
        if ( $id_act > 0 ) {
            //$data['activo'] = $this->activo_fijo->get_listado_depreciacion_baja($id_act);
            if ($es_masiva) {
                $ids = $this->input->post('to_pdf_ids');
                if ($ids) {
                    $array_id   = explode(',', $ids);
                    foreach ($array_id as $key => $activo) {
                        $registro        = $this->activo_fijo->get_info_activo(array('act_id'=>$activo));
                        $activo_masivo[] = $registro[0];
                        $registro2       = $this->activo_fijo->get_info_activo_asignacion(array('axe_id_act'=>$activo,'axe_estado'=>1));
                        $array_asig      = $registro2[0];
                    }
                    //die(print_r($activo_masivo));
                    $data['datos_activo']   = $activo_masivo;
                    $data['es_masivo'] = 1;
                    $data['encargado_activo'] = $array_asig;
                    $data['encargado_activo'] = explode(',', $this->gsatelite->get_parametro('SYS_ENCARGADO_ACTIVO_FIJO'));
                    //$data['usuario']= $this->db->where('emp_id_usu',$data['activo']['act_usu_modificacion'])->get('emp_empleado')->result_array();
                    $this->load->library('pdf');
                    $html = $this->load->view('reporte/header',array('titulo'=>'Reporte - Baja de Activo Fijo','solotitulo'=>true),true);
                    $html .= $this->load->view('activo/nuevo/constancia_baja',$data,true);
                    $this->pdf->makePDF($html);
                }
            }
            $activo = $this->activo_fijo->get_info_activo(array('act_id'=>$id_act));
            $data['datos_activo'] = $activo[0];
            $registro_asignacion = $this->activo_fijo->get_info_activo_asignacion(array('axe_id_act'=>$id_act,'axe_estado'=>1));
            $data['responsable'] = $registro_asignacion[0];
            $data['encargado_activo'] = explode(',', $this->gsatelite->get_parametro('SYS_ENCARGADO_ACTIVO_FIJO'));
            $data['usuario']= $this->db->where('emp_id_usu',$data['activo']['act_usu_modificacion'])->get('emp_empleado')->result_array();
            $this->load->library('pdf');
            $html = $this->load->view('reporte/header',array('titulo'=>'Reporte - Baja de Activo Fijo','solotitulo'=>true),true);
            $html .= $this->load->view('activo/nuevo/constancia_baja',$data,true);
            $this->pdf->makePDF($html);
            //$reporte=$this->pdf->reportePDF2($html);
        } else {
            $this->gsatelite->show_dialog('Error en envio de inf. para la generación del reporte', 'activo/nuevo/bajas', 'error');
        }
    }


    public function bajas(){
        //Verificar Permisos de acceso
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data['activos'] = $this->activo_fijo->get_listado_depreciacion(null,'0');
            $data['titulo_personal']="Baja de activos";
            $this->_cargarvista(null, $data);
        }
    }
/***************************************************************************************************************/


/************************************ INVENTARIO FÍSICO ********************************************************/
  public function index_inv_fisico()
  {
   $obtener_id = $this->consultas->cargar_todo('are_area');
   $data['ubicaciones'] = $obtener_id;
   $data['are_opciones'] = $this->activo_fijo->get_registros('are_area');
   $data['titulo_personal']="Inventario físico";
   $this->_cargarvista(null,$data); 
  }

   
  function generar_inventario()
  {
    $archivo_enviado = $this->input->pot('archivo');

    if(isset($archivo_enviado)){
      echo "Existe archivo";
    }
  }

  function do_upload()
  {
    $ubicacion = $_POST['ubicacion'];
    $fecha= $_POST['fecha_inventario'];
    $nombre = 'inventario_'.date("Y-m-d_His");
    $config['upload_path'] = './uploads/archivos/inventario/';
    $config['allowed_types'] = 'txt';
    $config['max_size'] = '4096';
    $config['file_name'] = $nombre;

    $this->load->library('upload', $config);

    if ( ! $this->upload->do_upload())
    {
      $data['error'] = array('error' => $this->upload->display_errors());
      $data['titulo_personal'] = 'Carga de archivo';
      $this->_cargarvista($data);
    }
    else
    {
      $data = array('upload_data' => $this->upload->data());
      $data['archivo'] = 'uploads/archivos/inventario/'.$nombre.'.txt';
            $data['ubicacion'] =$ubicacion;
            $data['fecha']=$fecha;
      $data['titulo_personal'] = 'Carga de archivo';
      $this->_cargarvista($data);
    }
  }

  public function do_upload_excel(){   
    satelite_validar();
    if (!$_FILES) {
        $this->gsatelite->show_dialog('No es posible cargar el detalle del inventario', 'activo/nuevo/index_inv_fisico', 'error' );
    }
    $this->load->library('excel/excel_reader.php');
    $excel = new Excel_reader;
    $excel->read($_FILES["excelfile"]["tmp_name"]);

    $data['ubicacion']         = $_POST['ubicacion'];
    $data['fecha_inventario']  = date_format(date_create($_POST['fecha_inventario']),'Y-m-d H:i:s');

    $datos_excel= $excel->sheets[0];
    $registros  = $datos_excel['cells'];
    $exis_asig  = '';
    $exist_no_a = '';
    $no_existe  = '';
    unset($registros[1]);// se quita primera linea de tiulos
     foreach ($registros as $fila) {
                $codigo_area   = $fila[1];
                $codigo_activo = $fila[2];
                $nombre        = $fila[3];
                $are_nombre    = $this->gsatelite->get_campo('are_area','are_nombre',array('are_id' => $codigo_area));
                $activo        = $this->gsatelite->get_tabla("act_activo_fijo", array("act_codigo" => $codigo_activo) );
                $id_activo     = $activo[0]['act_id'];
                

                $inf_inventario = array(
                    'inf_id_usu' => $this->tank_auth->get_user_id(),
                    'inf_id_are' => $data['ubicacion'], 
                    'inf_fecha' => $data['fecha_inventario'],
                    'inf_usu_mod'=>$this->tank_auth->get_user_id(),
                    'inf_fecha_mod'=> date('Y:m:d h:i:s'));
                $inf = $this->gsatelite->ingresar('inf_inventario_fisico',$inf_inventario);




                if($activo[0]['act_codigo'] != null) {
                    $asignado  = $this->activo_fijo->get_activosxempleado(array('act_id' => $id_activo,'axe_id_are' => $codigo_area));
                    $tipo      = $this->gsatelite->get_tabla('tac_tipo_activofijo',array('tac_id' => $activo[0]['act_id_tac']));
                    if ((count($asignado)>0)) {
                        $datos = array( 
                        'dif_id_inf'=>$inf,
                        'dif_id_act'=>$id_activo,
                        'dif_codigo'=>$codigo_activo,
                        'dif_usu_mod'=>$this->tank_auth->get_user_id(),
                        'dif_fecha_mod'=>date('Y-m-d h:i:s'));
                        $this->db->insert('dif_detalle_inventario_fisico',$datos);
                        $id_dif=$this->db->insert_id();
                        $exis_asig[] = array('are_nombre' =>$are_nombre,'asignado' => $asignado,'nombre' => $activo[0]['act_nombre'],'codigo' => $codigo_activo,'id' => $id_activo,'area' => $codigo_area,'tipo' => $tipo[0]['tac_nombre']); 
                    }else{
                        $datos = array(
                        'dif_id_inf'=>$inf,
                        'dif_id_act'=>$id_activo,
                        'dif_codigo'=>$codigo_activo,
                        'dif_usu_mod'=>$this->tank_auth->get_user_id(),
                        'dif_fecha_mod'=>date('Y-m-d h:i:s'));
                        $this->db->insert('dif_detalle_inventario_fisico',$datos);
                        $id_dif=$this->db->insert_id();

                        $exist_no_a[] = array('are_nombre' =>$are_nombre,'asignado' => '','nombre' => $activo[0]['act_nombre'],'codigo' => $codigo_activo,'id' => $id_activo,'area' => $codigo_area,'tipo' => $tipo[0]['tac_nombre']); 
                    }
                   
                }else{
                    $datos = array( 
                    'dif_id_inf'=>$inf,
                    'dif_codigo'=>$codigo_activo,
                    'dif_usu_mod'=>$this->tank_auth->get_user_id(),
                    'dif_fecha_mod'=>date('Y-m-d h:i:s'));
                    $this->db->insert('dif_detalle_inventario_fisico',$datos);
                    $id_dif=$this->db->insert_id();
                    $no_existe[] = array('codigo' =>$codigo_activo);
                }
            }
      $data['existen']       = $exis_asig;
      $data['no_asignado']   = $exist_no_a;
      $data['noexiste']      = $no_existe;
      $data['titulo_personal'] = 'Carga de archivo';
      $this->_cargarvista($data);    
  }

  function procesar()
  {
    if ($_POST) {
      $ubicacion=$_POST['ubicacion'];
      $fecha=$_POST['fecha_inventario'];
      $archivo=$_POST['archivo'];
      $data['resultado'] = $this->activo_fijo->procesarProductos($archivo,$fecha,$ubicacion);
      $data['ubicacion']=$ubicacion;
      $data['titulo_personal'] = 'Productos procesados correctamente';
      $this->_cargarvista($data);
    }
    else
      redirect('archivos/productos');
  }

    public function reasignar($activo,$empleado_anterior)
    {
      //Verificar Permisos de acceso
        if ( !$this->tank_auth->is_logged_in() ) {
            redirect('/auth/login/');
        } else {
            $data['activo']=$activo;
            $data['emp_origen']=$empleado_anterior;
            $data['are_opciones'] = $this->activo_fijo->get_registros('are_area');
            $this->load->view('activo/nuevo/reasignar',$data);
        }
    }

    public function asignar($activo)
    {
      if ( !$this->tank_auth->is_logged_in() ) {
        redirect('/auth/login/');
      } else {
        $data['activo']=$activo;
        $data['are_opciones'] = $this->activo_fijo->get_registros('are_area');
        $this->load->view('activo/nuevo/reasignar',$data);
      }
    }


    public function listado_asignacion($imp=0){
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');   
        } else {
            if($_POST){
              $codigo=($this->input->post('codigo')>0) ? $this->input->post('codigo') : null;
              $fecha_ini=($this->input->post('fecha_ini')>0) ? $this->input->post('fecha_ini') : null;
              $fecha_fin=($this->input->post('fecha_fin')>0) ? $this->input->post('fecha_fin') : null;
              
              $where = null;
              $having = null;

              if($fecha_ini!='' && $fecha_fin!=''){
                $desde=formatear_fecha('Y-m-d', $fecha_ini);
                $hasta=formatear_fecha('Y-m-d', $fecha_fin);
                  $where=array('date_format(axe_fecha,"%Y-%m-%d") >='=>$desde, 'date_format(axe_fecha,"%Y-%m-%d") <='=>$hasta);
              }

              $where['axe_estado'] = "1";
              $having['veces ='] = 1;
              //Se agrego funcion para verificar obtener lista de empleados con activos asignados (Francisco Orozco 2017-04-28)
              $data['activos']= $activos = $this->activo_fijo->listado_empleados_asignacion($where, $having,'act_id');
              $html = $this->load->view('activo/nuevo/detalle_listado_asignacion', $data, true);
              echo $html;
              die();
          }else{              
              $data['areas']=$this->activo_fijo->get_areas();
              $data['activos']=$this->activo_fijo->listado_asignacion();
              $data['titulo_personal']="Listado de asignaciones";
              
              if($imp>0){
                    $nuevo_act=$this->activo_fijo->get_activo($imp);
                    $caracteristicas=$this->activo_fijo->get_caracteristicaxactivo($imp);
                    $this->load->library('pdf');
                    $html  = $this->load->view('reporte/header', array('titulo' => 'Nuevo activo fijo'), true);
                    $html .= $this->load->view('activo/nuevo/nuevo_act', array('activo' => $nuevo_act,'caracteristicas'=>$caracteristicas), true);            
                  
                    $reporte=$this->pdf->makePDF($html);
              }
              $this->_cargarvista($data);
          }
        }
      }
/***************************************************************************************************************/

/************************************************** ASIGNAR ****************************************************/
    /**
     * Asignacion de activo fijo
     * @return html Pantalla de asignacion de activo fijo
     */
    public function index_asignacion()
    {
    //Verificar Permisos de acceso
        if ( !$this->tank_auth->is_logged_in() ) {
            redirect('/auth/login/');
        } else {
            $this->output->enable_profiler(ENVIRONMENT == 'development'); //Testing
            
            //Preparar datos a mostrar en la vista
            $data['act_opciones'] = $this->activo_fijo->get_listado_asignacion();
            $data['are_opciones'] = $this->activo_fijo->get_registros('are_area');

            if( $_POST ){

                //Reglas de validacion
                $this->form_validation->set_rules('asi_area', 'Área', 'required|greater_than[0]');
                $this->form_validation->set_rules('asi_empleado', 'Empleada/o', 'required|greater_than[0]');
                $this->form_validation->set_rules('asi_listado[]', 'Activo', 'required|greater_than[0]');
                $this->form_validation->set_rules('asi_ubicacion', 'Ubicaci&oacute;n ', 'required|greater_than[0]');
                $this->form_validation->set_message('greater_than', 'Por favor, selecciona una opci&oacute;n' );

                //Verificando
                if ( !$this->form_validation->run() ){
                    $this->_cargarvista( null, $data );
                } else {
                    $this->asignar_activo_fijo();
                }
                
            } else {
                //Cargar vista 
                $this->_cargarvista( null, $data );
            }
        }
    }

    public function empleados_oficinas($are_id=null, $emp_id=null)
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if($are_id!=null){
                $empleados=$this->activo_fijo->get_empleados_sucursal($are_id);

                $select='';
                $emp = '<option value=""></option>';
                foreach($empleados as $fila){
                  if($emp_id==$fila['emp_id']){
                    $select="selected";
                  }else{ $select=''; }

                    $emp .= "<option value='". $fila['emp_id']."' ".$select."> ".$fila['emp_nombre']." ".$fila['emp_apellido']." - ".$fila['plz_nombre']."</option>";
                }
               return $emp;
            }else{
                $area=$this->input->post('area_sel');
                $empleados=$this->activo_fijo->get_empleados_sucursal($area);
                
                $emp = '<option value=""></option>';
                foreach($empleados as $fila){
                    $emp .= "<option value='". $fila['emp_id']."'> ".$fila['emp_nombre']." ".$fila['emp_apellido']." - ".$fila['plz_nombre']."</option>";
                }
                
                $arreglo = array( 
                    "drop"=>$emp,
                    
                    );
                
                echo json_encode($arreglo);
            }
        }
    }


    public function empleados_oficinasxasig($are_id=null, $emp_id=null){
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if($are_id!=null){
                $empleados=$this->activo_fijo->empleados_con_activos($emp_id,$are_id);

                $select='';
                $emp = '<option value=""></option>';
                foreach($empleados as $fila){
                  if($emp_id==$fila['emp_id']){
                    $select="selected";
                  }else{ $select=''; }

                    $emp .= "<option value='". $fila['emp_id']."' ".$select."> ".$fila['emp_nombre']." ".$fila['emp_apellido']." - ".$fila['plz_nombre']."</option>";
                }

               return $emp;
            }else{
                $area=$this->input->post('area_sel');
                $empleados=$this->activo_fijo->empleados_con_activos(null,$area);
                //die(print_r($this->db->last_query()));
                
                $emp = '<option value=""></option>';
                foreach($empleados as $fila){
                    $emp .= "<option value='". $fila['emp_id']."'> ".$fila['emp_nombre']." ".$fila['emp_apellido']." - ".$fila['plz_nombre']."</option>";
                }
                
                $arreglo = array( 
                    "drop"=>$emp,
                    
                    );
              
                echo json_encode($arreglo);
            }
        }
    }


    /**
     * Get ubicaciones por area
     * @return json listado de ubicaciones por area
     */
    public function get_ubicaciones()
    {
        //Verificar acceso unicamente, mediante AJAX
        if ( !$this->input->is_ajax_request() ) {
            exit('No direct script access allowed');
        }
        
        $id_area = $_GET['id_area'];

        //Obtener ID de la ubicacion
        $id = $this->activo_fijo->get_ubicaciones_area( $id_area );

        if( isset( $id ) && $id != false ){
            //Obtener Ubicacion padre de la ubicacion seleccionada
            $result = $this->consultas->get_padre( $id );    
        } else {
            $id = 0;
            $result = false;
        }

        //Inicializando variables de respuesta json
        $data['response'] = true;

        //Verificar Respuesta del servidor
        if( is_string( $result ) ){
            $data['message'] = array( 
                'ubicacion' => $result,
                'id'        => $id
                );
        } else {
            $data['message'] = array( 'ubicacion' => 'Ubicaci&oacute;n no encontrada' );
        }
        
        echo json_encode( $data );
    }

    /**
     * Asignar Activo Fijo por Empleado
     */
    public function asignar_activo_fijo()
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            extract($_POST);

        //Obtener el resultado de la asignacion de activo Fijo
            $result = $this->activo_fijo->set_activo_fijo_x_empleado($asi_empleado, $asi_area, 
                $asi_listado, $asi_ubicacion,
                $asi_observacion );
            
        //Redirigir a la pagina de asignacion de activo fijo
            redirect( base_url( 'activo/asignar?result='.$result ) );
        }
    }

    public function get_deptos(){
        satelite_validar();
        $suc    = $this->input->post('suc');
        $where['are_estado'] = 1;
        $where['are_id_suc'] = $suc;
        $options = "<option value=''></option>";
        $data   = $this->gsatelite->get_tabla('are_area',$where);
        while (list($key,$val) = each($data)) {
            $options .= '<option value="'.$val['are_id'].'">'.$val['are_prefijo'].' '.$val['are_nombre'].'</option>';
        }
        echo json_encode(array('options' => $options));
    }

    public function ver_activos(){
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if($_POST){
                $area  = $this->input->post('are_id');
                $usados= $this->input->post('asig');
                $suc   = $this->input->post('suc');
                $data['used'] = $used = ($usados) ? explode(',', $usados) : null;
                $data['activos']= $activos =$this->activo_fijo->activoxarea($area, null, $used,null,$suc);

                $html = $this->load->view('activo/nuevo/activosxasignar', $data, true);
                echo $html;
            }else{
                //$data['areas']=$this->activo_fijo->get_areas();
                $areas = $this->gsatelite->get_dropdown('are_area', '{are_prefijo} {are_nombre}', '', null, null, null, 'are_id', true);
                $data['areas'] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $areas);
                $sucs = $this->gsatelite->get_dropdown('suc_sucursal','{suc_codigo} {suc_nombre}', '',null,null,null,'suc_id',true);
                $data['sucursales'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $sucs);
                // $data['activos']=$this->activo_fijo->activoxempleado();
                $data['titulo_personal'] = "Asignación de activo fijo";
                $this->_cargarvista($data);
            }
        }
    }

    public function ver_activo_edit($emp_id){
      satelite_validar();
        if($_POST){
          $area=$this->input->post('are_id');
          if($area>0){
            $usados= $this->input->post('asig');
            $data['used'] = $used=explode(',', $usados);
            $data['activos']= $activos =$this->activo_fijo->activoxarea($area);

            $html = $this->load->view('activo/nuevo/activosxasignar_edit', $data, true);
            echo $html;
          }else{
            $activos    = $this->input->post('activos_asig');
            $emp_id     = $this->input->post('emp_id');
            $area       = $this->input->post('area');
            $obs        = $this->input->post('obs');
            $usados     = $this->input->post('act_usados');
            $volver     = $this->input->post('volver');

            $usado = explode(',', $usados);

            if( is_array($activos) && $emp_id && $area  ){
                $borrado = false;
                $this->db->where_in('axe_id_act',$usado);
                $this->gsatelite->borrado_general('axe_activoxempleado', array('axe_id_emp'=>$emp_id));

                // activos que poosee actualmnte
                $activos_actuales =$this->activo_fijo->activoxarea_trs(null, $emp_id, null);

                //se buscan los activos asignados del mismo dia
                $existentes = $this->gsatelite->get_tabla('axe_activoxempleado', array('axe_id_emp'=>$emp_id, 'axe_estado' => 1 , 'axe_fecha >='=>date('Y-m-d')));
                foreach ($existentes as $actual) {
                    if ( !in_array($actual['axe_id_act'], $activos) ) {
                        $borrado = true;
                        $this->gsatelite->borrado_general('axe_activoxempleado', array('axe_id' => $actual['axe_id'], 'axe_id_emp'=>$emp_id,'axe_id_act'=>$actual['axe_id_act']));
                    }
                }
                
                foreach( $activos as $activo ){
                    $new = true;        
                    foreach ($activos_actuales as $actual) {
                        if ( $actual['axe_id_act'] == $activo) {
                                $new = false;                     
                        }
                    }

                    if ( $new == true ){     
                        $nuevo=$this->db->insert('axe_activoxempleado', array(
                            'axe_id_act'    => $activo,
                            'axe_id_emp'    => $emp_id,
                            'axe_id_are'    => $area,
                            'axe_fecha'     => date('Y-m-d H:i:s'),
                            'axe_obs'       => $obs,
                            'axe_use_mod'   => $this->tank_auth->get_user_id(),
                            'axe_fecha_mod' => date('Y-m-d h:i:s')
                        ));
                    }
                      
                }


            if($nuevo>0){
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Proceso realizado", 'texto_alerta' => "Registros actualizados correctamente");
            } else {
                if ( $borrado == true){

                }else{
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error de inserción", 'texto_alerta' => "No se pudo realizar la operación");
                }
            }

            $this->session->set_flashdata($alerta);
            if($volver>0){
              redirect("activo/nuevo/listado_asignacion");
            }else{
              redirect("activo/nuevo/ver_activo_edit/".$emp_id);
            }

          }
        }
        }else{
          $ultima_asig=$this->gsatelite->get_max('axe_activoxempleado', 'axe_id', array('axe_id_emp'=>$emp_id));
          $fecha_asig=$this->gsatelite->get_campo('axe_activoxempleado', 'axe_fecha', array('axe_id'=>$ultima_asig));
          $data['fecha_asig']=$fecha_asig;

                                       $this->db->where('emp_id', $emp_id);
          $data['activos']= $detalles = $this->activo_fijo->activoxarea(null, 1);


          $data['boton']=1;
          $data['html'] = $html = $this->load->view('activo/nuevo/activosxasignar_edit', $data, true);

          $acti='';
          foreach ($detalles as $det) {
            $acti.=$det['axe_id_act'].',';
          }
          
          $data['usados']=$acti;
          
          $acti='';
          foreach ($detalles as $det) {
            $acti.=$det['axe_id_act'].',';
          }

          $data['usados']=$acti;

          $this->db->where('emp_id', $emp_id);
          $data['info']= $info = $this->activo_fijo->listado_asignacion();
          //print_r($data['info']); die();
          //$areas = $this->gsatelite->get_dropdown('are_area', '{are_nombre}', '', null, null, null, 'are_id', true);
          //$data['areas'] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $areas);
          $areas = $this->gsatelite->get_dropdown('are_area', '{are_nombre}', '', null, $info[0]['axe_id_are'], null, 'are_id', true);
          $data['areas_sel']  = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $areas);
          $are_info           = $this->gsatelite->get_tabla('are_area',array('are_id' => $info[0]['axe_id_are']));
          $data['empleados']  = $this->empleados_oficinas($info[0]['axe_id_are'], $emp_id);
          $data['empleado']   = $emp_id;
          $data['sucursales'] = str_replace('<option value="0">Seleccione</option>', '',$this->gsatelite->get_dropdown('suc_sucursal','{suc_codigo} - {suc_nombre}','',null,$are_info[0]['are_id_suc'],null,'suc_id',true));
              
          $data['titulo_personal'] = "Editar Asignación de activo fijo";
          $this->_cargarvista($data);
        }
    }

    function get_activosxasignar(){
        satelite_validar();
        $ids=$this->input->post('array');
                                    $this->db->where_in('act_id', $ids);
        $data['activos']= $activos =$this->activo_fijo->activoxarea($area,null,null,1);
      
        $data['boton']=1;
        $html = $this->load->view('activo/nuevo/activosxasignar', $data, true);
        echo $html;
    }

    function get_activosxasignar_edit(){
        satelite_validar();
        $ids=$this->input->post('array');
       // $id_emp = $this->input->post('id_emp');
        $this->db->where_in('act_id', $ids);
        $data['activos']= $activos =$this->activo_fijo->activoxarea($area,null,null,1);
      
        $data['ajax'] = 1;
        $data['boton']=1;
        $html = $this->load->view('activo/nuevo/activosxasignar_edit', $data, true);

        /*$data['ajax'] = null;
        $data['activos'] =  $activos = $this->activo_fijo->activoxarea_trs(null, $id_emp, null);
        $data['boton']= 1;
        $data['html'] = $html_original = $this->load->view('activo/nuevo/activosxasignar_edit', $data, true);*/

        echo $html;
    }

    function buscar_datos()
    {
      //Verificar acceso unicamente, mediante AJAX
        if ( !$this->input->is_ajax_request() ) {
            exit('No direct script access allowed');
        }
        
        $suc_id = $this->input->post('id');
        
        
        $data['response']   = true;
        
        $data['oficinas']   = $this->gsatelite->get_dropdown('vw_oficina', '{nivel} >> {oficina}', '', array('regional_id' => $suc_id), null, '', 'ubi_id', true);
        
        
        $this->db->select('are_id, are_nombre');
        $this->db->from('are_area');
        $this->db->join('axu_areaxubicacion','axu_id_are = are_id');
        $this->db->join('vw_oficina', 'ubi_id = axu_id_ubi');
        $this->db->where('regional_id', $suc_id);
        $this->db->group_by('are_id');
        $query = $this->db->get();
        
        if($query->num_rows()>0) $areas = array( 0 => 'Seleccione'); else $areas= array( 0 => 'Sin Registros');
        foreach ($query->result() as $row) {
            $areas[$row->are_id] = $row->are_nombre;
        }
        
        $data['areas']      = $this->gsatelite->get_dropdown_options($areas);
        
        $this->db->join('vw_oficina', 'vw_oficina.ubi_id = vw_empleados.ubi_id');
        $query = $this->db->get_where('vw_empleados', array('regional_id' => $suc_id));
        print_r($this->db->last_query());
        exit();
        if($query->num_rows()>0) $empleados = array( 0 => 'Seleccione'); else $empleados= array( 0 => 'Sin Registros');
        foreach ($query->result() as $row) {
            $empleados[$row->emp_id] = $row->codigo . ' ' . $row->nombre;
        }
        
        $data['empleados']  = $this->gsatelite->get_dropdown_options($empleados);

        
        die(json_encode($data));
    }

    public function save_asignar(){
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $activos    = $this->input->post('activos_asig');
            $emp_id     = $this->input->post('emp_id');
            $area       = $this->input->post('area');
            $obs        = $this->input->post('obs');
            $volver     = $this->input->post('volver');
            $fecha      = (trim($this->input->post('fecha_ad'))!='')? formatear_fecha("Y-m-d",$this->input->post('fecha_ad')):date('Y-m-d');
            if( is_array($activos) && $emp_id  && $area ){
                $tipo_flujo = $this->gsatelite->get_parametro_emp('SYS_ASIGNAR_AUTORIZAR_AF');
                if ($tipo_flujo > 0) {
                    $sucid = $this->gsatelite->get_campo('are_area','are_id_suc',array('are_id' => $area));
                    $solicitud = array(
                        'slt_id_emp' => $emp_id,
                        'slt_id_are' => $area,
                        'slt_id_suc' => ($sucid > 0)?$sucid:null,
                        'slt_fecha' => $fecha . ' ' . date('H:i:s'),
                        'slt_tipo_solicitud' => 0,
                        'slt_estado' => 1,
                        'slt_usu_creacion' => $this->tank_auth->get_user_id(),
                        'slt_usu_modifica' => $this->tank_auth->get_user_id(),
                        'slt_fecha_creacion' => date('Y-m-d H:i:s'),
                        'slt_fecha_modifica'  => date('Y-m-d H:i:s')
                    );
                    $nuevo = $this->gsatelite->ingresar('slt_solicitud_activos', $solicitud);
                    foreach ($activos as $k => $va) {
                        $activoSolic = array(
                            'axs_id_act' => $va,
                            'axs_id_slt' => $nuevo,
                            'axs_estado' => 1,
                            'axs_fecha_cre' => date('Y-m-d H:i:s'),
                            'axs_usu_crea' => $this->tank_auth->get_user_id(),
                            'azs_usu_modifica' => $this->tank_auth->get_user_id(),
                            'axs_fecha_modifica' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('axs_activo_solicitud', $activoSolic);
                    }
                } else {
                    foreach( $activos as $activo ){
                        $nuevo = $this->db->insert('axe_activoxempleado', array(
                            'axe_id_act'    => $activo,
                            'axe_id_emp'    => $emp_id,
                            'axe_id_are'    => $area,
                            'axe_fecha'     => ($fecha .' '. date('H:i:s')),
                            'axe_obs'       => $obs,
                            'axe_use_mod'   => $this->tank_auth->get_user_id(),
                            'axe_fecha_mod' => date('Y-m-d H:i:s')
                        ));
                    }
                }                
                if($nuevo > 0){
                    $texto_mensaje = "Registros guardados correctamente<br>";
                    $texto_mensaje .= ($tipo_flujo > 0) ? "Pendiente de aprobación" : "";
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Proceso realizado", 'texto_alerta' => $texto_mensaje);
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error de inserción", 'texto_alerta' => "No se pudo realizar la operación");
                }
                $this->session->set_flashdata($alerta);
                if($volver > 0){
                    redirect("activo/nuevo/listado_asignacion");
                }else{
                    redirect("activo/nuevo/ver_activos");
                }
            } else {
                $this->gsatelite->show_dialog('Activos No Asignados.', 'activo/nuevo/ver_activos', 'error');
            }
        }
    }

    public function solicitud_asigna_traslado(){
        satelite_validar();
        if ($_POST) {
            $html = '';
            $where = array();
            $estado_permiso = (is_numeric($this->input->post('estado'))) ? $this->input->post('estado') : '';
            $fecha_ini = ($this->input->post('fecha_ini') != '') ? $this->input->post('fecha_ini') : '';
            $fecha_fin = ($this->input->post('fecha_fin') != '') ? $this->input->post('fecha_fin') : '';
            if(is_numeric($estado_permiso)) {
                $where['slt_estado'] = $estado_permiso;
            }
            if ($fecha_ini != '') {
                $where['DATE(slt_fecha_creacion) >= '] = formatear_fecha('Y-m-d', $fecha_ini);
            }
            if($fecha_fin != ''){
                $where['DATE(slt_fecha_creacion) <= '] = formatear_fecha('Y-m-d', $fecha_fin);
            }
                                    $this->db->join('emp_empleado', 'emp_id = slt_id_emp');
            $data['asignaciones'] = $this->gsatelite->get_tabla('slt_solicitud_activos', $where);
            $html = $this->load->view('activo/nuevo/detalle_asignaciones_pdtes', $data, true);            
            echo $html;
            die();
        } else {
            $data['titulo_personal'] = "Gestión de Asignaciones";
            $this->_cargarvista($data);
        }        
    }

    public function asignacion_pendiente($id = null, $ver = null){
        satelite_validar();
        if($this->input->post()) {   
            $estado        = $this->input->post('nuevo_estado');
            $observaciones = $this->input->post('aprobar_observacion');
            $id_registro   = ($id > 0) ? $id : $this->input->post('solicitud_id');
            if (!($id_registro > 0)) {
                die('No se ha seleccionado ningun id para procesar la aprobacion');
            }
            if ($estado == 2) { //Aprobado
                $actualizar_per = array(
                    'slt_usu_aprueba' => $this->tank_auth->get_user_id(),
                    'slt_fecha_aprobacion' => date('Y-m-d H:i:s'),
                    'slt_estado' => 2, 
                    'slt_usu_modifica' => $this->tank_auth->get_user_id(),
                    'slt_fecha_modifica' => date('Y-m-d H:i:s'),
                    'slt_observacion' => $observaciones
                );
                $registro = $this->gsatelite->actualizar_array('slt_solicitud_activos', $actualizar_per, array('slt_id' => $id_registro));

                $solicitud = $this->gsatelite->get_tabla('slt_solicitud_activos', ['slt_id' => $id_registro]);
                // Asignar correlativo solo a tipo de solicitud traslado
                if ($solicitud[0]['slt_tipo_solicitud'] == 1) {
                    $this->activo_fijo->asignarCorrelativo($id_registro);
                }

                                $this->db->join('slt_solicitud_activos', 'slt_id = axs_id_slt');
                                $this->db->join('act_activo_fijo', 'act_id = axs_id_act');
                                $this->db->join('emp_empleado', 'emp_id = slt_id_emp');
                $tabla_detail = $this->gsatelite->get_tabla('axs_activo_solicitud', array('axs_id_slt' => $id_registro));
                foreach ($tabla_detail as $k => $v) {
                    if ($v['slt_tipo_solicitud'] == 1) {
                        $data_update=array(
                            'axe_estado'=> 0,
                            'axe_use_mod'=> $this->tank_auth->get_user_id(),
                            'axe_fecha_mod'=>date('Y-m-d H:i:s')
                        );
                        $this->db->where('axe_id_act',$v['act_id']);
                        $this->db->where('axe_estado',1);
                        $this->db->update('axe_activoxempleado',$data_update);
                    }
                    $axerow = array(
                        'axe_id_act' => $v['act_id'],
                        'axe_id_emp' => $v['slt_id_emp'],
                        'axe_id_are' => $v['slt_id_are'],
                        'axe_fecha'  => date('Y-m-d H:i:s'),
                        'axe_obs'    => $observaciones,
                        'axe_use_mod' => $this->tank_auth->get_user_id(),
                        'axe_fecha_mod' => date('Y-m-d H:i:s')
                    );
                    $nuevo = $this->db->insert('axe_activoxempleado', $axerow);
                    if ($v['slt_tipo_solicitud'] == 1) {
                        $actualiza = array(
                            "act_id_are" => $v['slt_id_are'],
                            "act_usu_modificacion" => $this->tank_auth->get_user_id(),
                            "act_fecha_modificacion" => date("Y-m-d H:i:s")
                        );
                        $resp = $this->gsatelite->actualizar_array('act_activo_fijo', $actualiza, array('act_id' => $v['act_id']));
                    }
                }

                // Actualizar area de activo segun empleado
                $activos_array = array_column($tabla_detail, 'act_id');
                $this->consultas->actualizar_area_activos($solicitud[0]['slt_id_are'], $activos_array);                

            } else if($estado == 3) { //Rechazado
                $actualizar_per = array(
                    'slt_usu_rechaza' => $this->tank_auth->get_user_id(),
                    'slt_fecha_denegado' => date('Y-m-d H:i:s'),
                    'slt_estado' => 0, 
                    'slt_usu_modifica' => $this->tank_auth->get_user_id(),
                    'slt_fecha_modifica' => date('Y-m-d H:i:s'),
                    'slt_observacion' => $observaciones
                );
                $registro = $this->gsatelite->actualizar_array('slt_solicitud_activos', $actualizar_per, array('slt_id' => $id_registro));                
            } else {
                die("No se han recibido los datos de forma correcta");
                redirect('');
            }

            // Notificar por correo
            $this->notificacion_correo($id_registro);
            $titulo = ($estado == 2) ? 'Aprobado' : 'Rechazado';
            $this->session->set_flashdata('registro', $registro);
            $this->session->set_flashdata('titulo', $titulo);
            redirect('activo/nuevo/asignacion_pendiente');
            // $ctas = $this->db->query('CALL sp_ejecutar_depreciacion_mensual("'.$fila['prd_id'].'","'.$id_user.'","'.$fecha_dep.'");');
            // clean_mysqli_connection($this->db->conn_id);
        } else {
            $data['id'] = $id;
            $data['ver']= ($ver > 0) ? 1 : 0;
            $data['autorizacion'] = ($ver == 2) ? 1 : 0;
            $reg_pdte = $this->activo_fijo->lista_pdte_asignar($id);
            $data['detalles'] = $reg_pdte;
            $data['emps_now'] = $this->gsatelite->get_tabla('emp_empleado', ['emp_id' => $data['detalles'][0]['slt_id_emp_origen']]);                                 
            $this->gsatelite->cargar_vista_masterpage('activo/nuevo/estado_aprobacion_asignacion', $data);
        }        
    }

    function imprimir_asignacion($emp_id){
        satelite_validar();
        $where['emp_id ='] = $emp_id;
        $where['axe_estado'] = 1;
        $where['act_estado > '] = 0;
        $detalles = $this->activo_fijo->get_reporte_asignacion($where);
        $act=array();
        foreach ($detalles as $det) {
            $act[]= $det['axe_id_act'];
        }
        $activos_data = $this->activo_fijo->activo_report($act,$emp_id);
        /************************* REPORTE PDF *****************************/
        $nuevo_act = $this->activo_fijo->get_activo($imp);
        $full_info = $this->activo_fijo->get_info_total_activo(array('act_id' => $imp));
        $caracteristicas=$this->activo_fijo->get_caracteristicaxactivo($imp);
        $data['titulo'] = 'Asignación de activos';
        $header = $this->load->view('reporte/header', $data, true);
        $activos_data = $this->activo_fijo->activo_report($act,$emp_id);
        // var_dump($activos_data);die();
        $GLOBALS['nombre_reporte'] = 'Acta de Asignación de Activos Fijos por Responsable ' . date('dmY');
        $reporte = $this->load->view('activo/nuevo/acta_reporte_asignacion', array('activos' => $activos_data), true);
        $this->pdf->makePdf($reporte, 'P', 'acta_de_asignacion', 'Letter');
    }

    function imprimir_asignacion2($axe_id){
        satelite_validar();
        $rowaxe = $this->gsatelite->get_registro('axe_activoxempleado', array('axe_id' => $axe_id));
        $tblaxe = $this->gsatelite->get_tabla('axe_activoxempleado', array('axe_fecha' => $rowaxe->axe_fecha, 'axe_id_emp' => $rowaxe->axe_id_emp));
        $emp_id = $rowaxe->axe_id_emp;
        $where['emp_id ='] = $rowaxe->axe_id_emp;
        $where['axe_estado'] = 1;
        $where['act_estado > '] = 0;
        if (count($tblaxe) > 0) {
            $ids = implode(",", array_column($tblaxe, 'axe_id'));
            $where["axe_id IN (0,$ids)"] = null;
        }
        $detalles = $this->activo_fijo->get_reporte_asignacion($where);
        if (count($detalles) > 0) {
            $act=array();
            foreach ($detalles as $det) {
                $act[]= $det['axe_id_act'];
            }
            $activos_data = $this->activo_fijo->activo_report($act,$emp_id);
        } else {
            $activos_data = array();
        }        
        $titulo = 'Acta de Asignación de Activos Fijos por Responsable<br>De fecha ' . formatear_fecha('d-m-Y', $rowaxe->axe_fecha);
        $GLOBALS['nombre_reporte'] = 'Acta de Asignación de Activos Fijos por Responsable de fecha ' . formatear_fecha('d-m-Y', $rowaxe->axe_fecha);
        $reporte = $this->load->view('activo/nuevo/acta_reporte_asignacion', array('activos' => $activos_data, 'tituloPerson' => $titulo), true);
        $this->pdf->makePdf($reporte, 'P', 'acta_de_asignacion', 'Letter');
    }

    function acta_asignacion($emp_id){
        satelite_validar();
        $where['emp_id'] = $emp_id;
        $where['axe_estado'] = 1;
        $where['act_estado >'] = 0;
        $detalles = $this->activo_fijo->get_reporte_asignacion($where);
        $act=array();
        foreach ($detalles as $det) {
            $act[]= $det['axe_id_act'];
        }
        $activos_data = $this->activo_fijo->activo_report($act,$emp_id);
        // var_dump($activos_data);die();
        $GLOBALS['nombre_reporte'] = 'Acta de Asignación de Activos Fijos por Responsable ' . date('dmY');
        $reporte = $this->load->view('activo/nuevo/acta_reporte_defensoria', array('activos' => $activos_data), true);
        $this->pdf->makePdf($reporte, 'L', 'acta_de_asignacion', 'Letter');
    }

    function acta_traslado($axeid){
        satelite_validar();
        $datos_generar_reporte = array();
        $inf = $this->gsatelite->get_tabla('axe_activoxempleado',array('axe_id' => $axeid))[0];
        $dato_trs = $this->gsatelite->get_tabla('axe_activoxempleado', array("axe_id_emp" => $inf['axe_id_emp'], "DATE(axe_fecha)" => formatear_fecha('Y-m-d',$inf['axe_fecha'])));
        foreach ($dato_trs as $f) {
            $info_ant = $this->activo_fijo->get_info_activo_asignacion(array('axe_id_act' => $f['axe_id_act'], 'axe_id < ' => $f['axe_id']))[0] ;
            $activos_data = $this->activo_fijo->activo_report($f['axe_id_act'], $f['axe_id_emp']);
            $info_ant['caracteristicas'] = $activos_data[0]->caracteristicas;
            $datos_generar_reporte[] = $info_ant; 
        }
        $data['actual'] = $dato_trs;
        $data['anterior'] = $datos_generar_reporte;

        $this->load->model('sqlserver_model');

        $puesto_responsable_actual = null;
        $puesto_responsable_recibe = null;
        $oficina = '';

        // Verificación de la extensión y conexión
        if (extension_loaded('sqlsrv') && $this->sqlserver_model->check_connection()) {

            // Obtener datos del empleado actual
            if (!empty($datos_generar_reporte)) {
                $empleado_actual = $this->sqlserver_model->getEmpleadosSinco($datos_generar_reporte[0]['axe_id_emp']);
                if (!empty($empleado_actual)) {
                    $puesto_responsable_actual = $empleado_actual[0]['NOMBREPUESTO'];
                }              
            }

            // Obtener datos del empleado que recibe
            if (!empty($dato_trs)) {
                $empleado_recibe = $this->sqlserver_model->getEmpleadosSinco($dato_trs[0]['emp_codigo']);
                if (!empty($empleado_recibe)) {
                    $puesto_responsable_recibe = $empleado_recibe[0]['NOMBREPUESTO'];
                }
            }
        } 

        // Get oficina empleado entrega
        if (!empty($datos_generar_reporte)) {
            $emp_empleado = $this->gsatelite->get_tabla('emp_empleado', ['emp_id' => $datos_generar_reporte[0]['axe_id_emp']]);

                        $this->db->join('dis_distrito', 'suc_id_dis = dis_id');
                        $this->db->join('mun_municipio', 'suc_id_mun = mun_id');
            $sucursal = $this->gsatelite->get_tabla('suc_sucursal', ['suc_id' => $emp_empleado[0]['emp_id_suc']]);
            if (!empty($sucursal)) {
                $oficina = "{$sucursal[0]['mun_nombre']}, {$sucursal[0]['dis_nombre']}";
            }                
        }

        $data['puesto_responsable_actual'] = $puesto_responsable_actual;
        $data['puesto_responsable_recibe'] = $puesto_responsable_recibe; 
        $data['oficina'] = $oficina;
        // var_dump($dato_trs);die();
        $reporte = $this->load->view('activo/nuevo/acta_traslado_defensoria', $data, true);
        $GLOBALS['nombre_reporte'] = 'Formato de Movimiento de Activos Fijos' . date('dmY');
        $this->pdf->makePdf($reporte, 'P', 'fotmato_de_movimiento', 'Letter');

    }

    function acta_control_cambios($axeid){
        satelite_validar();
        $datos_generar_reporte = array();
        $inf = $this->gsatelite->get_tabla('axe_activoxempleado',array('axe_id' => $axeid))[0];
        $dato_trs = $this->gsatelite->get_tabla('axe_activoxempleado',array("axe_id_emp"=>$inf['axe_id_emp'], "DATE(axe_fecha)" => formatear_fecha('Y-m-d',$inf['axe_fecha'])));
        foreach ($dato_trs as $f) {
            $info_ant = $this->activo_fijo->get_info_activo_asignacion(array('axe_id_act' => $f['axe_id_act'], 'axe_id < ' => $f['axe_id']))[0];
            $activos_data = $this->activo_fijo->activo_report($f['axe_id_act'], $f['axe_id_emp']);
            $info_ant['caracteristicas'] = $activos_data[0]->caracteristicas;
            $datos_generar_reporte[] = $info_ant;
        }        
        $data['transfactual'] = $inf;
        $data['activos'] = $datos_generar_reporte;
        $reporte = $this->load->view('activo/nuevo/acta_traslado_isdemu', $data, true);
        $GLOBALS['nombre_reporte'] = 'Control de Cambios de Activos Fijos' . date('dmY');
        $this->pdf->setPrintFooter(false);
        $this->pdf->makePdf($reporte, 'P', 'control_cambios', 'Letter');
    }

/***************************************************************************************************************/


/************************************** TRASLADOS *************************************************************/
    /**
     * Traslado de activo fijo
     * @return html Traslado de activo fijo
     */
    public function index_traslado()
    {
      //Verificar Permisos de acceso
          if (!$this->tank_auth->is_logged_in()) {
              redirect('/auth/login/');
          } else {
              //Preparando la informacion que sera enviada a la vista
              //NOTA: empleados es una vista en mysql.
            $data['traslados'] = $this->activo_fijo->get_registros('empleados'); 
            $data['are_opciones'] = $this->activo_fijo->get_registros('are_area');

            //Cargar vista 
            $this->_cargarvista( null, $data );
       }  
   }


    public function listado_asignacion_trs($imp=0){
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');   
        } else {
            if($_POST){
                $codigo=($this->input->post('codigo')>0) ? $this->input->post('codigo') : null;
                $fecha_ini=($this->input->post('fecha_ini')>0) ? $this->input->post('fecha_ini') : null;
                $fecha_fin=($this->input->post('fecha_fin')>0) ? $this->input->post('fecha_fin') : null;                
                $where =null;
                $having = null;
                if($fecha_ini!='' && $fecha_fin!=''){
                    $desde=formatear_fecha('Y-m-d', $fecha_ini); 
                    $hasta=formatear_fecha('Y-m-d', $fecha_fin); 
                    $where['DATE(axe_fecha) >='] = $desde;
                    $where['DATE(axe_fecha) <='] = $hasta;
                }
                $where['axe_estado'] = "1";
                $having['veces >'] = 1;
                //se agrego funcion para verificar obtener lista de empleados con activos asignados (Francisco Orozco 2017-04-28)
                $data['activos']= $activos = $this->activo_fijo->listado_empleados_asignacion($where,$having,'axe_id_act');
                //echo $this->db->last_query(); die();
                $html = $this->load->view('activo/nuevo/det_asignacion_trs', $data, true);
                echo $html;
                die();
            }else{
                $data['areas']=$this->activo_fijo->get_areas();
                $data['activos']=$this->activo_fijo->listado_asignacion();
                $data['titulo_personal']="Listado de traslados";
                $this->_cargarvista($data);
            }
        }
    }

    /**
     * listado  de activo fijo por ID de Empleado
     * @return html Traslado de activo fijo
     */
    public function listado()
    {
      //Verificar Permisos de acceso
      if (!$this->tank_auth->is_logged_in()) {
          redirect('/auth/login/');
      } else {
              $this->output->enable_profiler(ENVIRONMENT == 'development'); //Testing

              $id_emp = $this->uri->segment(4);
              
              //Preparando la informacion que sera enviada a la vista
              //NOTA: vw_nombre_empleado es una vista en mysql.
              $data['empleado'] = $this->activo_fijo->get_registros_where(
                  'vw_nombre_empleado', 
                  array( 'emp_id' => $id_emp )
                  );
              //Listado de empleados
              $data['emp_opciones'] = $this->activo_fijo->get_registros('vw_nombre_empleado');
              //NOTA: vw_listado_activos es una vista en mysql.
              $data['listado'] = $this->activo_fijo->get_registros_where(
                'vw_listado_activos ', 
                array('axe_id_emp' => $id_emp)
                ); 
              
              //Cargar vista 
              $this->_cargarvista( null, $data );
          }
          
      }

      

    public function ver_activos_trs(){
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if($_POST){
                $area  = ($this->input->post('are_id')!='')?$this->input->post('are_id'):null;
                $emp_id = $this->input->post('emp_id');
                $usados= ($this->input->post('asig')!='')?$this->input->post('asig'):null;
                $data['used'] = $used=explode(',', $usados);

                $rol_administrador = $this->gsatelite->get_parametro_emp('ADMINISTRADOR_TRASLADOS_AF', 0);
                $rol_administrador_array = explode(",", $rol_administrador);
                        $this->db->join("uxr_usuarioxrol", "uxr_id_usu = id");
                $rolu = $this->gsatelite->get_tabla("users", array("id" => $this->tank_auth->get_user_id()));
                foreach ($rolu as $k => $val) {
                    if (in_array($val['uxr_id_rol'], $rol_administrador_array)) {
                        $area = null;
                    }            
                }
                $data['activos']= $activos =$this->activo_fijo->activoxarea_trs_empleado($area, $emp_id, $usados);
                //die(print_r($this->db->last_query()));
                $html = $this->load->view('activo/nuevo/activosxasignar', $data, true);
                echo $html;
            }else{
                $areas = $this->gsatelite->get_dropdown('are_area', '{are_prefijo} {are_nombre}', '', array('are_estado' => 1), null, null, 'are_id', true);
                $data['areas'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $areas);
                $sucs = $this->gsatelite->get_dropdown('suc_sucursal','{suc_codigo} {suc_nombre}', '',null,null,null,'suc_id',true);
                $data['sucursales'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $sucs);
                // Permite seleccionar activos de multiples empleados
                $data['sys_activos_multiemp']= $this->gsatelite->get_parametro("SYS_ACTIVOS_MULTIEMP", 1);
                $data['titulo_personal'] = "Traslado de activo fijo";
                $this->_cargarvista($data);
            }
        }
    }


      public function ver_activo_trs_edit($emp_id=null){
      satelite_validar();
        if($_POST){
          $area=$this->input->post('are_id');
          if($area>0){
            $data['activos']= $activos =$this->activo_fijo->activoxarea($area);

            $html = $this->load->view('activo/nuevo/activosxasignar', $data, true);
            echo $html;
          }else{
          //die(print_r($_POST));
            $activos       = $this->input->post('activos_asig');
            $emp_id_origen = $this->input->post('origen_emp');
            $area          = $this->input->post('area_origen');
            $obs           = $this->input->post('obs');
            $emp_id_destino= $this->input->post('emp_id');
            $usu_id        = $this->tank_auth->get_user_id();
            $act_usados    = $this->input->post('act_usados');
            $area_sel      = $this->input->post('area_sel');
            $emp_sel      = $this->input->post('emp_sel');
            $usado= explode(',', $act_usados); 
                  
            $fecha     = (trim($this->input->post('fecha_ad'))!='')? formatear_fecha("Y-m-d",$this->input->post('fecha_ad')):date('Y-m-d');

            if( is_array($activos) && ( $emp_id_origen || $area ) ){
                foreach ($activos as $activo) {
                  if(!in_array($activo, $usado)){
                    $data_update=array(
                        'axe_estado'=> 0,
                        'axe_use_mod'=> $usu_id,
                        'axe_fecha_mod'=>date('Y-m-d h:i:s'));
                    $this->db->where('axe_id_act',$activo);
                    $this->db->where('axe_id_emp',$emp_id_origen);
                    $this->db->where('axe_estado',1);
                    $this->db->update('axe_activoxempleado',$data_update);



                     $data_insert=array('axe_id_act'=>$activo,
                        'axe_id_emp'=>$emp_id_destino,
                        'axe_id_are'=>$area,
                        'axe_obs'=>$obs,
                        'axe_fecha'=>($fecha .' '. date('H:i:s')),
                        'axe_estado'=>1,
                        'axe_use_mod'=>$this->tank_auth->get_user_id(),
                        'axe_fecha_mod'=>date('Y:m:d H:i:s'));
                    $nuevo=$this->db->insert('axe_activoxempleado',$data_insert); 

                  }

                  if(in_array($activo, $usado)){
                    $data_update=array(
                        'axe_id_emp'=>$emp_id_destino,
                        'axe_id_are'=>$area,
                        'axe_estado'=> 1,
                        'axe_use_mod'=> $usu_id,
                        'axe_fecha_mod'=>date('Y-m-d h:i:s'));
                    $this->db->where('axe_id_act',$activo);
                    $this->db->where('axe_id_emp',$emp_id_origen);
                    $this->db->where('axe_estado',1);
                    $nuevo=$this->db->update('axe_activoxempleado',$data_update);
                  }

                }

                foreach ($usado as $usd) {
                  if(!in_array($usd, $activos)){
                    $registro=$this->gsatelite->get_tabla('axe_activoxempleado', array('axe_id_act'=>$usd,'axe_id_emp'=>$emp_sel,'axe_id_are'=>$area_sel));
                    $this->gsatelite->borrado_general('axe_activoxempleado', array('axe_id_act'=>$usd, 'axe_id_are'=>$area_sel,'axe_id_emp'=>$emp_sel,'axe_estado'=>1));
                    $nuevo=$this->gsatelite->actualizar_array('axe_activoxempleado', array('axe_estado'=>1), array('axe_id'=>$registro[0]['axe_id']));
                  }
                }


            if($nuevo>0){
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Proceso realizado", 'texto_alerta' => "Registros actualizados correctamente");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error de inserción", 'texto_alerta' => "No se pudo realizar la operación");
            }
            $volver=$this->input->post('volver');
            $this->session->set_flashdata($alerta);
            if($volver>0){
              redirect("activo/nuevo/listado_asignacion_trs");
            }else{
              redirect("activo/nuevo/ver_activo_trs_edit/".$emp_id_destino);
            }

          }
        }
        }else{
                                      // $this->db->where('emp_id', $emp_id);
          $data['activos']= $detalles = $this->activo_fijo->activoxarea_trs(null,$emp_id);
          $data['boton']=1;
          $data['html'] = $html = $this->load->view('activo/nuevo/activosxasignar', $data, true);
          
          $acti='';
          foreach ($detalles as $det) {
            $acti.=$det['axe_id_act'].',';
          }
          

          $data['usados']=$acti;

                                 $this->db->where('emp_id', $emp_id);
          $data['info']= $info = $this->activo_fijo->listado_traslado();
          //die(print_r($info));
          
          $areas = $this->gsatelite->get_dropdown('are_area', '{are_nombre}', '', null, null, null, 'are_id', true);
          $data['areas'] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $areas);
          $areas = $this->gsatelite->get_dropdown('are_area', '{are_nombre}', '', null, $info[0]['axe_id_are'], null, 'are_id', true);
          $data['area_sel']=$info[0]['axe_id_are'];
          $data['emp_sel']=$emp_id;
          $data['areas_sel'] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $areas);
          $data['empleados']=$this->empleados_oficinasxasig($info[0]['axe_id_are'], $emp_id);
          
          $data['titulo_personal'] = "Editar Asignación de activo fijo";
          $this->_cargarvista($data);
        }
    }
      
  

    public function get_activos_trs(){
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $this->session->keep_flashdata('activos');
            $emp=$this->input->post('emp_id_tra');
            $activosxempleados = $this->activo_fijo->empleados_con_activos($emp);

            $cadena='';
            foreach ($activosxempleados as $key) {
                $cadena.='<tr><td>'.$key['act_codigo'].'</td>';
                $cadena.='<td>'.$key['act_nombre'].'</td>';
                $cadena.='<td>'.$key['act_valor_cont'].'</td>';
                $cadena.='<td><input class="ibuttonCheck nostyle" type="checkbox" id="activo_sel" name="activos[]" value="'.$key['act_id'].'" /></td></tr>';           
            }
            $cadena.='<tr><td style="text-align:right;" colspan="3"><b>Seleccionar todos</b></td><td><input class="ibuttonCheck nostyle" type="checkbox"  id="select_all" /></td></tr>';

            $arreglo=array('drop' => $cadena);
            echo json_encode($arreglo);
        }
    }

    function get_activosxtraslado(){
        satelite_validar();
        $ids=$this->input->post('array');
                                    $this->db->where_in('axe_id_act', $ids);
        $data['activos']= $activos =$this->activo_fijo->activoxarea_trs($area,null,null,1);
        $data['boton']=1;
        $data['responsables'] = $activos;
        $html = $this->load->view('activo/nuevo/activosxasignar', $data, true);
        echo $html;
    }
    
    public function save_traslado(){
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            // die(var_dump($_POST));
            $counter = 0;
            $preview = $this->input->post('ids_selected');
            $acts_ids = explode(",", $preview[0]); //Se hiz porque ahora son mas activos que los que se mandan en checkbox
            $areas_to_send = $this->input->post('acts_selected'); //Areas que se enviaran en el form en la parte inferior al momento q sale el toaste se envian
            $emps_to_send  = $preview[0]; //Ids de empleados que se envian al momento de guardar y se mandan al momento q se da en generar reporte en el toast
            $activos       = $acts_ids;
            $emp_id_origen = $this->input->post('origen_emp');
            $other = $this->input->post("acts_selected");
            $emps_ids_origens = explode(",", $other);
            $area           = $this->input->post('area');
            $obs            = $this->input->post('obs');
            $emp_id_destino = $this->input->post('emp_id');
            $usu_id         = $this->tank_auth->get_user_id();
            $fecha     = (trim($this->input->post('fecha_ad'))!='') ? formatear_fecha("Y-m-d",$this->input->post('fecha_ad')) : date('Y-m-d');
            $tipo_movimiento = ($this->input->post('slc_tipo_movimiento') != null) ? $this->input->post('slc_tipo_movimiento') : 1;

            $nuevo_ids = array();
            if( is_array($activos) && ( $emp_id_origen || $area ) ){
                $tipo_flujo = $this->gsatelite->get_parametro_emp('SYS_ASIGNAR_AUTORIZAR_AF');
                if ($tipo_flujo > 0) {
                    $sucid = $this->gsatelite->get_campo('are_area','are_id_suc',array('are_id' => $area));
                    $solicitud = array(
                        'slt_id_emp' => $emp_id_destino,
                        'slt_id_are' => $area,
                        'slt_id_suc' => ($sucid > 0)?$sucid:null,
                        'slt_fecha' => $fecha . ' ' . date('H:i:s'),
                        'slt_tipo_solicitud' => 1,
                        'slt_tipo_movimiento' => $tipo_movimiento,
                        'slt_id_emp_origen' => $emp_id_origen,                        
                        'slt_estado' => 1,
                        'slt_usu_creacion' => $this->tank_auth->get_user_id(),
                        'slt_usu_modifica' => $this->tank_auth->get_user_id(),
                        'slt_fecha_creacion' => date('Y-m-d H:i:s'),
                        'slt_fecha_modifica'  => date('Y-m-d H:i:s')
                    );
                    $nuevo = $this->gsatelite->ingresar('slt_solicitud_activos', $solicitud);
                    foreach ($activos as $k => $va) {
                        $activoSolic = array(
                            'axs_id_act' => $va,
                            'axs_id_slt' => $nuevo,
                            'axs_estado' => 1,
                            'axs_fecha_cre' => date('Y-m-d H:i:s'),
                            'axs_usu_crea' => $this->tank_auth->get_user_id(),
                            'azs_usu_modifica' => $this->tank_auth->get_user_id(),
                            'axs_fecha_modifica' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('axs_activo_solicitud', $activoSolic);
                    }
                    if($nuevo>0){                      
                        $texto_mensaje = "Registros guardados correctamente<br>Pendiente de aprobación";
                        $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Proceso realizado", 'texto_alerta' => $texto_mensaje);
                    } else {
                        $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error de inserción", 'texto_alerta' => "No se pudo realizar la operación");
                    }
                } else {                    
                    $datos_generar_reporte= array();
                    for ($i = 0 ; $i < count($activos) ; $i++) {
                        $data_update=array(
                            'axe_estado'=> 0,
                            'axe_use_mod'=> $usu_id,
                            'axe_fecha_mod'=>date('Y-m-d H:i:s')
                        );
                                $this->db->where('axe_id_act',$activos[$i]);
                                $this->db->where('axe_id_emp', $emps_ids_origens[$i]);
                                $this->db->where('axe_estado',1);
                        $nuevo= $this->db->update('axe_activoxempleado',$data_update);

                        $data_insert = array(
                            'axe_id_act'=>$activos[$i],
                            'axe_id_emp'=>$emp_id_destino,
                            'axe_id_are'=>$area,
                            'axe_obs'=>$obs,
                            'axe_fecha'=>($fecha .' '. date('H:i:s')),
                            'axe_estado'=>1,
                            'axe_use_mod'=>$this->tank_auth->get_user_id(),
                            'axe_fecha_mod'=>date('Y:m:d H:i:s')
                        );
                        $nuevo = $this->gsatelite->ingresar('axe_activoxempleado',$data_insert);
                        $datos_generar_reporte[] = $nuevo."==".$activos[$i]."/".(int)$emp_id_origen; 
                        $nuevo_ids[] = $nuevo;  
                        $counter++;
                    }
                    /*
                    $datos_generar_reporte= array();
                    foreach ($activos as $activo) {
                        $data_update=array(
                          'axe_estado'=> 0,
                          'axe_use_mod'=> $usu_id,
                          'axe_fecha_mod'=>date('Y-m-d H:i:s'));
                        $this->db->where('axe_id_act',$activo);
                        $this->db->where('axe_id_emp', $emp_id_origen);
                        $this->db->where('axe_estado',1);
                        $nuevo= $this->db->update('axe_activoxempleado',$data_update);
                        $data_insert=array('axe_id_act'=>$activo,
                            'axe_id_emp'=>$emp_id_destino,
                            'axe_id_are'=>$area,
                            'axe_obs'=>$obs,
                            'axe_fecha'=>date('Y-m-d H:i:s'),
                            'axe_estado'=>1,
                            'axe_use_mod'=>$this->tank_auth->get_user_id(),
                            'axe_fecha_mod'=>date('Y:m:d H:i:s'));
                        //$nuevo=$this->db->insert('axe_activoxempleado',$data_insert);   
                        $nuevo = $this->gsatelite->ingresar('axe_activoxempleado',$data_insert);
                        $datos_generar_reporte[] = $nuevo."==".$activo."/".(int)$emp_id_origen; 
                        $nuevo_ids[] = $nuevo;  
                        $counter++;
                    }
                    */
                    if($nuevo>0){
                        $formulario = '<a href="#" style="color:blue;" onclick="generar_reporte();" ><b>Generar Reporte</b></a>';
                        $this->session->set_flashdata('datos_generar_reporte',implode('##',$datos_generar_reporte));
                        $this->session->set_flashdata('send_areas', (count($areas_to_send) > 1) ? $areas_to_send[0] : $areas_to_send);
                        $this->session->set_flashdata('send_emps', (count($emps_to_send) > 1) ? $emps_to_send[0] : $emps_to_send);
                        $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Proceso realizado", 'texto_alerta' => "Registros guardados correctamente $formulario ");
                    } else {
                        $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error de inserción", 'texto_alerta' => "No se pudo realizar la operación");
                    }
                    //============================================================================
                    // INICIO -   LUEGO DEL TRASLADO ACTUALIZAR EL CÓDIGO DE LOS ACTIVOS SI APLICA add by René Castaneda
                    //============================================================================
                    $actualiza = $this->gsatelite->get_parametro('SYS_CONFIGURACION_CODIGO_ACTIVO', null, false, array('ACTUALIZAR_TRASLADOS'));
                    if ($actualiza > 0) {
                        $this->activo_fijo->actualizar_codigo_area_activo($nuevo_ids);
                    } else {
                        if (count($nuevo_ids) > 0) {
                            $this->db->where_in("axe_id", $nuevo_ids);
                            $a_movido = $this->gsatelite->get_tabla("axe_activoxempleado");
                            if (count($a_movido) > 0) {
                                foreach ($a_movido as $k => $val) {
                                    $actualiza = array(
                                        "act_id_are" => $val["axe_id_are"],
                                        "act_usu_modificacion" => $this->tank_auth->get_user_id(),
                                        "act_fecha_modificacion" => date("Y-m-d H:i:s")
                                    );
                                    $resp = $this->gsatelite->actualizar_array('act_activo_fijo', $actualiza, array('act_id' => $val["axe_id_act"]));
                                }
                            }
                        }        
                    }                
                    //==========================================================================
                    //   FIN - LUEGO DEL TRASLADO ACTUALIZAR EL CÓDIGO DE LOS ACTIVOS SI APLICA add by René Castaneda
                    //==========================================================================
                }
                $this->session->set_flashdata($alerta);
                $volver = $this->input->post('volver');
                if($volver > 0){
                    redirect("activo/nuevo/listado_asignacion_trs");
                }else{
                    redirect("activo/nuevo/ver_activos_trs");
                }
            }else{
                $this->gsatelite->show_dialog('Los activos no fueron trasladados.', 'activo/nuevo/ver_activos_trs', 'error');
            }
        }
    }

    public function pdf_traslado()
    {
      $this->session->flashdata('activos');
      $activos=$this->session->flashdata('activos');
      $this->db->join('act_activo_fijo','act_id=axe_id_act');
              $this->db->join('emp_empleado','emp_id=axe_id_emp');
              $this->db->join('are_area','are_id=emp_id_are');
              $this->db->where('axe_estado',1);
              $this->db->where_in('axe_id_act', $activos);
              $activos_data =  $this->db->get('axe_activoxempleado')->result();
              $this->load->library('pdf');
              $html  = $this->load->view('reporte/header', array('titulo' => 'Traslado de Activos'), true);
              $html .= $this->load->view('activo/nuevo/reporte', array('activos' => $activos_data), true);
              $this->pdf->setPageOrientation('P');
              $this->pdf->makePDF($html);
    }

    function imprimir_traslado($emp_id){
        satelite_validar();
        $where['axe_id_emp'] = $emp_id;
        $where['axe_estado'] = "1";
        $having['veces >'] = 1;
        $detalle = $this->activo_fijo->listado_empleados_asignacion($where,$having,null);
        /* $act=array();
        foreach ($detalles as $det) {
          $act[]= $det['axe_id_act'];
        }*/
        $activos_data =  $detalle;//$this->activo_fijo->activo_report($act);       
        /************************* REPORTE PDF *****************************/
        $data['titulo'] = 'Traslado de activos';
        $header = $this->load->view('reporte/header', $data, true);
        $html = $this->load->view('activo/nuevo/imprimir_traslado', array('activos' => $detalle,'traslado'=>1), true);
        $GLOBALS['nombre_reporte'] = 'Reporte_traslado_activos' . date('dmY');
        $reporte = $header . $html;
        $this->pdf->makePdf($reporte, 'L', 'Reporte_traslado_activos', 'Letter');
       // redirect('activo/nuevo/ver_activos');
    }


    /**
     * Trasladar activo fijo a empleado
     */
    public function trasladar_activo()
    {
          if (!$this->tank_auth->is_logged_in()) {
              redirect('/auth/login/');
          } else {

      $activos       = $this->input->post('tra_activos'); //ID(s) de activos para traslado
      $asignar_a     = $this->input->post('lst_empleados'); //ID de empleado 
      $observaciones = $this->input->post('tra_observacion');

      $this->form_validation->set_rules('tra_activos', 'Activos', 'required');
      $this->form_validation->set_rules('lst_empleados', 'Empleada/o', 'required|greater_than[0]');

      $result = false;

      if ( $this->form_validation->run() != FALSE ) {
        //trasladar activo(s)
        $result = $this->activo_fijo->set_traslado_activo( $activos, $asignar_a, $observaciones );
    }

      //Redirigir a la pagina de ingreso de activo fijo
    redirect( base_url( 'activo/nuevo?result='.$result ) );
  }
  }
    /**
     * AJAX: Obtener detalles de activo fijo para traslado
     * @return json Detalles del activo fijo por ID
     */
    public function get_detalles_traslado()
    {
          
        //Verificar acceso unicamente, mediante AJAX
        if ( !$this->input->is_ajax_request() ) {
            exit('No direct script access allowed');
        }
        //Obtener el id del activo
        $id_activo_fijo = $_GET['id_traslado'];

        $result = $this->activo_fijo->get_detalles_activo_fijo( $id_activo_fijo );

        echo  $result ;
    }


/**************************************************************************************************************/

   public function get_codigoxactivo()
      {
        satelite_validar();
        $grupo = $this->input->post('grupo');
        $codigos = $this->gsatelite->get_tabla( 'act_activo_fijo', array('act_id_grp' => $grupo));
       
        $cadena='<option value="" selected></option>';
        foreach ($codigos as $row) {
            $cadena .='<option value="'.$row['act_id'].'">'.$row['act_codigo'].'</option>';
        }
        echo $cadena;  
   }


    public function duplicar_activo($activo=null){
        satelite_validar();
        if ($_POST) {
            $ajax = true;
            $act_id = $this->input->post('id_act');
            $cantidad = $this->input->post('cantidad');
        }
                    $this->db->join('are_area', 'are_id=act_id_are', 'left'); 
                    $this->db->join('tad_tipo_adquisicion', 'tad_id=act_id_tad', 'left');      
                    $this->db->join('grp_grupo', 'grp_id=act_id_grp', 'left'); 
                    $this->db->join('tac_tipo_activofijo', 'tac_id=act_id_tac', 'left');                
        $cabezera = $this->db->where('act_id',$activo)->get('act_activo_fijo')->row_array();
        //print_r($this->db->last_query());die();
        $caracteristicas=$this->gsatelite->get_tabla('cxc_caracterxactivo', array('cxc_id_act'=>$activo));

        $exito=0;
        $resultado=""; 

        /****************************************** REGISTRO *********************************************************/  
        /********************* SE GENERA EL CÓDIGO DEL NUEVO ACTIVO ***********************************************/
        for ($i=0; $i < $cantidad; $i++) {
            $codigo=$cabezera['act_codigo'];
            $guion=substr_count($codigo, '-');

            $fecha=formatear_fecha('d-m-Y', $cabezera['act_fecha_adq']);
            $id_dep = $cabezera['act_id_are'];

            $tac_abbr= $cabezera['tac_codigo'];
            $grp_abbr = $cabezera['grp_codigo'];
            $dep_abbr = $cabezera['are_prefijo'];
            $act_abbr = $cabezera['tad_codigo'];
            $fecha_array = explode("-", $fecha);
            $fecha_abbr = implode('', $fecha_array);

            $correlativo_max=$this->activo_fijo->get_nuevo_correlativo($id_dep);  
            $correlativo=str_pad($correlativo_max,4, "0", STR_PAD_LEFT);

            if($guion>2){
                $empresa_abbr=$this->gsatelite->get_parametro("ACT_ABBR_EMPRESA");
                $resultado=$empresa_abbr.'-'.$dep_abbr.'-'.$tac_abbr.'-'.$grp_abbr.'-'.$correlativo.'-'.$act_abbr.'-'.$fecha_abbr;
            }else{
                $resultado=$grp_abbr.'-'.$act_abbr.'-'.$correlativo;
            }
            $resultado = $this->generar_codigo_administrativo($act_id);
            
            if(count($resultado)>0){
                $t = $i + 1;
                $fechacreacion = date("Y-m-d H:i:s", strtotime("+$t sec"));                
                $array_act=array(
                    'act_id_tac'=>$cabezera['act_id_tac'],
                    'act_id_grp'=>$cabezera['act_id_grp'],
                    'act_id_are'=>$cabezera['act_id_are'],
                    'act_id_tad'=>$cabezera['act_id_tad'],
                    'act_id_suc'=>$cabezera['act_id_suc'],
                    'act_id_dxd'=>$cabezera['act_id_dxd'],
                    'act_id_pcl'=>$cabezera['act_id_pcl'],
                    'act_id_prv'=>$cabezera['act_id_prv'],
                    'act_id_cec'=>$cabezera['act_id_cec'],
                    'act_afecta_contabilidad'=>$cabezera['act_afecta_contabilidad'],
                    'act_referencia_activo'=>$cabezera['act_referencia_activo'],
                    'act_id_act_dependencia'=>$cabezera['act_id_act_dependencia'],
                    'act_codigo'=>$resultado['codigo'],
                    'act_correlativo'=>$resultado['correlativo'],
                    'act_nombre'=>$cabezera['act_nombre'],
                    'act_descripcion'=>$cabezera['act_descripcion'],
                    'act_fecha_adq'=>$cabezera['act_fecha_adq'],
                    'act_depreciable'=>$cabezera['act_depreciable'],
                    'act_valor_compra'=>$cabezera['act_valor_compra'],
                    'act_valor_cont'=>$cabezera['act_valor_cont'],
                    'act_valor_residual'=>$cabezera['act_valor_residual'],
                    'act_valor_dep'=>$cabezera['act_valor_dep'],
                    'act_porcentaje_dep'=>$cabezera['act_porcentaje_dep'],
                    'act_fecha_dep'=>$cabezera['act_fecha_dep'],
                    'act_observacion'=>$cabezera['act_observacion'],
                    'act_fecha_desact'=>$cabezera['act_fecha_desact'],
                    'act_obs_desact'=>$cabezera['act_obs_desact'],
                    'act_valor_libro'=>$cabezera['act_valor_libro'],
                    'act_vida_util'=>$cabezera['act_vida_util'],
                    'act_fecha_inicia_dep'=>$cabezera['act_fecha_inicia_dep'],  
                    'act_foto'=>$cabezera['act_foto'],
                    'act_fecha_vence_garantia'=>$cabezera['act_fecha_vence_garantia'],
                    'act_dias_garantia'=>$cabezera['act_dias_garantia'],
                    'act_observacion_garantia'=>$cabezera['act_observacion_garantia'],
                    'act_estado'=> $cabezera['act_estado'],
                    'act_usu_creacion'=>$this->tank_auth->get_user_id(),
                    'act_fecha_creacion'=>$fechacreacion,//date('Y-m-d H:i:s'),
                    'act_usu_modificacion'=>$this->tank_auth->get_user_id(),
                    'act_fecha_modificacion'=>$fechacreacion//date('Y-m-d H:i:s')
                );
                //die(print_r($array_act));
                $registro = $this->gsatelite->ingresar('act_activo_fijo', $array_act);

                if(count($caracteristicas)>0){   
                    for ($j=0; $j < count($caracteristicas) ; $j++) {
                        $carxart = array('cxc_id_cxi' =>$caracteristicas[$j]['cxc_id_cxi'] ,
                            'cxc_id_act' =>$registro,
                            'cxc_valor'  =>$caracteristicas[$j]['cxc_valor'],
                            'cxc_estado' =>$caracteristicas[$j]['cxc_estado'],
                            'cxc_usu_creacion'=>$this->tank_auth->get_user_id(),
                            'cxc_fecha_creacion'=>date('Y-m-d H:i:s'),
                            'cxc_usu_modificacion'=>$this->tank_auth->get_user_id(),
                            'cxc_fecha_modificacion'=>date('Y-m-d H:i:s')
                        );
                        $this->db->insert('cxc_caracterxactivo',$carxart);
                    }
                } // End if

            }else{
                $alerta=array('tipo_alerta'=> 'error','titulo_alerta'=>"Registro no duplicado",'texto_alerta'=>"El nuevo código no pudo ser generado, verifique la información que lo compone.");
                $this->session->set_flashdata($alerta); 
                redirect('activo/nuevo/index_activos');
            }
            $exito++;
        }


        if ($registro > 0) {
            $alerta = array(
                'tipo_alerta' => 'success',
                'titulo_alerta' => 'Éxito',
                'texto_alerta' => "<b>$exito</b> Nuevo(s) activo(s) duplicado(s) con éxito."
            );
            $this->session->set_flashdata($alerta);
        }
        if ($registro){
            echo json_encode(array('exito' => $exito));
            die();
        }
    }


    function get_detalles_documento($document=null, $dxd_id=null){
        if($document != null){
        
          $where      = array('dpv_id'=>$document);
          $documentos = $this->activo_fijo->documentoxproveedor(2, $where);


            $options = '<option value=""></option>';  
            foreach ($documentos as $doc) {
              if( $dxd_id>0 ) {
                if( $doc['dxd_id'] == $dxd_id ){
                 $options.='<option value="'.$doc['dxd_id'].'" selected="selected" data-monto="'.$doc['dxd_total'].'" >'.$doc['act_nombre'].' </option>';
                }
              
              } else {
                if( (int)$doc['cant']>0 ){
                  $options.='<option value="'.$doc['dxd_id'].'" data-monto="'.$doc['dxd_total'].'" >'.$doc['act_nombre'].' ('.(int)$doc['cant'].') </option>';
                }
              }

            }

            return $options;
            
        } else {
            // Se obtiene la variable por POST
            $dpv_id     = $this->input->post('doc');
            $where      = array('dpv_id'=>$dpv_id);
            $documentos = $this->activo_fijo->documentoxproveedor(2, $where);

            $options  = '<option value=""></option>';
            foreach ($documentos as $doc) {
                if((int)$doc['cant']>0){
                    $options .= '<option value="'.$doc['dxd_id'].'" data-precio-unitario="'.$doc['dxd_precio_unitario'].'" data-categoria="'.$doc['tac_id'].'" data-monto="'.$doc['dxd_total'].'">'.$doc['act_nombre'].' ('.(int)$doc['cant'].') </option>';
                }
            }

            echo  json_encode($options);
        }
    }

    /**
    * @author René Castaneda
    * @since 2017-08-02
    * @return/descripción: generar reporte de traslado
     */
    public function generar_reporte_traslado($id_traslado=null) {
        $id_emps = (trim($this->input->post("send_areas")) != "") ? $this->input->post("send_areas") : ""; 
        $id_acts = (trim($this->input->post("send_emps")) != "") ? $this->input->post("send_emps") : "";
        ini_set( 'memory_limit', '2048M' );
        ini_set('max_execution_time', '9999');
        $html_header=$this->load->view('reporte/header', array('titulo' => "Reporte - Traslado de Activo Fijo", 'solotitulo'=> true), true);
        $html = '';
        $datos_reporte_id = '';
        $datos_generar_reporte = array();
        if ( $id_traslado > 0 ) {
            $info = $this->gsatelite->get_tabla('axe_activoxempleado',array('axe_id'=>$id_traslado));
            $datos_traslados = $this->gsatelite->get_tabla('axe_activoxempleado', array("axe_id_emp"=>$info[0]['axe_id_emp'], "DATE_FORMAT(axe_fecha,'%Y-%m-%d') =" => formatear_fecha('Y-m-d',$info[0]['axe_fecha'])));        
            foreach ($datos_traslados as $f) {
                $info_ant = $this->activo_fijo->get_info_activo_asignacion(array('axe_id !='=>$f['axe_id'], 'axe_id_act'=>$f['axe_id_act'], 'axe_id <'=>$f['axe_id']));
                $datos_generar_reporte[] = $f['axe_id']."==".$f['axe_id_act']."/".$info_ant[0]['axe_id_emp']; 
            }        
            $datos_reporte_id = (count($datos_generar_reporte) > 0 )? implode('##', $datos_generar_reporte):'';
        }
        if ($this->input->post() or trim($datos_reporte_id) != ''/* && $id_emps != null && $id_acts != null*/) 
        {
            // echo "<br>";
            // var_dump($id_emps);
            // echo "<br>";
            // var_dump($id_acts);
            $id_emps = explode(",", $id_emps[0]);
            $id_acts = explode(",", $id_acts[0]);
            // echo "<br>";
            // var_dump($id_emps);
            // echo "<br>";
            // var_dump($id_acts);
            //die();
            $datos_reporte = ($this->input->post())? explode('##', $this->input->post('datos_traslado')):explode('##', $datos_reporte_id);
            $n = count($datos_reporte);
            for ($i=0; $i < $n; $i++) {
                echo "<br>"; 
                var_dump($id_emps[$i]);
                echo "<br>";
                var_dump($id_acts[$i]);
                $registro = explode('==',$datos_reporte[$i]);
                $registro_ante = explode('/',$registro[1]);
                $id_actual = $registro[0];
                $id_activo = $registro_ante[0];
                $id_emp_anterior = $registro_ante[1];
                $activo = $this->activo_fijo->get_info_activo(array('act_id'=>$id_activo));
                $registro_traslado = $this->activo_fijo->get_info_activo_asignacion(array('axe_id'=>$id_actual));
                //$condicion = ($i == ($n -1)) ?  'axe_estado' : 'axe_estado <>';
                $registro_traslado_anterior = $this->activo_fijo->get_info_activo_asignacion(array('axe_id_emp'=>$id_emp_anterior,'axe_id_act'=>$registro_ante[0], 'axe_estado'=>0));
                $data['datos_activo'] = $activo[0];
                $data['registro_traslado'] = $registro_traslado[0];
                $data['registro_traslado_anterior'] = $registro_traslado_anterior[0];
                $html .= $html_header.$this->load->view('activo/nuevo/generar_reporte_traslado', $data, true);
                $html .= (($i+1)!=$n)? '<br style="page-break-after: always;" />':''; 
            }
            $this->load->library('pdf');
            $this->pdf->makePDF($html);
        } else {
            $this->gsatelite->show_dialog('Error en envio de inf. para la generación del reporte', 'activo/nuevo/listado_asignacion_trs', 'error');
        }
    }


  function get_tipocaracteristica(){
    $cxi_id = $this->input->post('cxi_id');
    $origen = $this->input->post('origen');

    //$cxr_id = $this->input->post('cxr_id');

    //$tipo_car = $this->gsatelite->get_tabla('cxr_caractxtipo_articulo', array('cxr_id'=>$cxr_id));
    //print_r($tipo_car); die();
    //$idcar = $tipo_car[0]['cxr_id_car'];
    //print_r($tipo_car); die();

    /*$this->join->('','');
    $tidato_car = $this->gsatelite->get_tabla('car_caracteristica',array('car_id'=> $idcar));*/
    ////////$this->db->join('cxr_caractxtipo_articulo','cxu_id_cxr = cxr_id');
    ////////$tidato_car = $this->gsatelite->get_tabla('cxu_caracxarticulo',array('cxr_id'=> $cxr_id, 'cxu_id_art'=> $idart, 'cxu_estado' => 1));
    
    if(!$cxi_id){
      $tipo_car = 9;
    }else{
      if($origen == 'nuevo'){
        $this->db->join('cxi_caracteristicaxtipo','car_id = cxi_id_car');    
        $this->db->join('vrl_valores_lista','car_id = vrl_id_car','left');
        //$this->db->join('cxc_caracterxactivo','cxi_id = cxc_id_cxi', 'left');
        //$tidato_car = $this->gsatelite->get_tabla('car_caracteristica',array('cxi_id'=> $cxi_id, 'cxi_estado' => 1, 'cxc_estado' => 1));      
        $tidato_car = $this->gsatelite->get_tabla('car_caracteristica',array('cxi_id'=> $cxi_id, 'cxi_estado' => 1));      
        $tipo_car = $tidato_car[0]['car_tipo'];
      }else{
        $this->db->join('cxi_caracteristicaxtipo','car_id = cxi_id_car');    
        $this->db->join('vrl_valores_lista','car_id = vrl_id_car', 'left');
        //$this->db->join('cxc_caracterxactivo','cxi_id = cxc_id_cxi', 'left');
        $tidato_car = $this->gsatelite->get_tabla('car_caracteristica',array('cxi_id'=> $cxi_id, 'cxi_estado' => 1));
        $tipo_car = $tidato_car[0]['car_tipo'];
        //print_r($tidato_car); die();
      }
    }
    
    /*if(!empty($tidato_car[0]['cxu_valor'])){
      
    }else{
      $tidato_car = $this->inventario_model->get_caracteristicas($idcar); 
      $tipo_car = $tidato_car[0]['car_tipo'];
    }*/
    //print_r($tipo_car); die();
    $html = "";
    $tip = "";
    switch ($tipo_car) {
      case 1://Lista multiple       
        $html .= '<select id="1" multiple class="valorprin">';        
        foreach ($tidato_car as $key => $value) {
          $html .= '<option value="'.$value['vrl_id'].'">'.$value['vrl_valor'].'</option>';
        }
        $html .= '</select>';
        $tip = 1;       
        break;
      case 2://Lista desplegable              
        $html .= '<select id="2" class="valorprin valorCaracteristica" placeholder="Seleccione">';
        $html .= '<option value></option>';
        foreach ($tidato_car as $key => $value) {
          $html .= '<option value="'.$value['vrl_id'].'">'.$value['vrl_valor'].'</option>';
        }
        $html .= '</select>';
        $tip = 2;
        break;
      case 3://Numerico
        $html .= '<input id="3" type="text" value="" class="valorprin valorCaracteristica soloNumeros">';
        $tip = 3;
        break;
      case 4://Decimal
        $html .= '<input id="4" type="text" value="" class="valorprin valorCaracteristica soloDecimales">';
        $tip = 4;
        break;
      case 5://Texto
        $html .= '<input id="5" type="text" value="" class="valorprin valorCaracteristica">';
        $tip = 5;
        break;
      case 6://Checkbox
        //$html .= '<input id="6" type="checkbox" class="valorprin nostyle ibuttonCheck ibutton">';
        $html .= '<input type="checkbox" id="6"  class="valorprin valorCaracteristica nostyle ibuttonCheck ibutton" >';
        $tip = 6;
        break;
      case 9:
        $html .= '<input id="9" type="text" value="" class="valorprin valorCaracteristica" readonly>';
        $tip = 9;        
      default:
        //$html .= '<input id="9" type="text" value="'.$tidato_car[0]['cxu_valor'].'" class="valorprin valorCaracteristica" readonly>';
        $html .= '<input id="5" type="text" value="" class="valorprin valorCaracteristica">';
        $tip = 5;
        break;
    }
    //print_r($html); die();
    $arreglo = array('tag' => $html, 'tipo' => $tip);
    echo json_encode($arreglo);
    //return $html;
  }

    /**
    * @author Habby Lovo
    * @date 25/09/2017
    */
    public function activar_reactivar_activo()
    {
        if($_POST){
            $id_activo = $this->input->post('id');
            $estado = $this->input->post('estado');
            $nuevo_estado = ($estado == 1)?-1:1;
            $resp = $this->gsatelite->actualizar_array('act_activo_fijo', array('act_estado' => $nuevo_estado), array('act_id'=>$id_activo));
            
            $mensaje = ($estado == 1)?"El activo se inactivo correctamente":"El activo se activo correctamente";
            $alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Baja de activo",'texto_alerta'=>$mensaje);
            $this->session->set_flashdata($alerta);
            echo json_encode(array('estado' => $resp));
        }
    }

    /**
    * @author Luis Navarro
    * @since  06-02-2018
    * @return validar fecha que sea antes de la depreciación de activo fijo.
    **/
    public function validar_fecha_activo_depre() {

        if ($this->input->post()) {
            $id       = $this->input->post('act_id');
            $fecha    = $this->input->post('fecha');

            $consulta = $this->gsatelite->get_tabla('act_activo_fijo', array('act_id'=>$id));
            if (trim($consulta[0]['act_fecha_inicia_dep']) == "") {
             echo json_encode(array('resp'=>1)); die(); // si esta vacia la fecha que no valide
            }
            $fecha_ini_depre = new DateTime(formatear_fecha('Y-m-d', $consulta[0]['act_fecha_inicia_dep']));
            $fecha_seleccion = new DateTime(formatear_fecha('Y-m-d', $fecha));

            if ($fecha_seleccion >= $fecha_ini_depre) {
                echo json_encode(array('resp'=>1));
            } else {
                echo json_encode(array('resp'=>0));
            }
        }
    }

    /**
    * @author Israel Alfaro
    * @since  06-09-2018
    * @param  serialize con todos los campos del formulario.
    * @return el nuevo codigo administrativo en activo fijo.
    **/
    public function generar_codigo_administrativo($id = null) {
        /*verifica si el parametro $id es diferente a null*/
        if($id!=null){
            $data = $this->activo_fijo->get_act_fijo(array('act_id' => $id));
            $data_act = $data[0];
        }
        if (($this->input->post()) || $id!=null) {
            $data_send = array();
            if($id!=null){
                /****CUANDO EL METODO ES LLAMADO DESDE OTRA FUNCIONA EN EL CONTROLADOR*******/
                $data_send = $data_act;
                $estado = $data_send['act_estado'];
                $depreciacion = $data_send['act_depreciacion'];
                $fecha_ven=$data_send['fecha_ven'];
                $fecha_ini_dep=$data_send['fecha_ini_dep'];         
            }else{
                /****CUANDO EL PROCESO ES LLAMADO VIA AJAX***/
                parse_str($_POST['input_data'], $data_send);
                ($data_send['act_estado'] == 'on' ) ? $estado=1 : $estado=0;
                (isset($data_send['act_depreciacion']) && $data_send['act_depreciacion'] == 'on' ) ? $depreciacion=1 : $depreciacion=0;
                $fecha_ven=$data_send['fecha_ven'];
                $fecha_ini_dep=$data_send['fecha_ini_dep'];
            }
            $generar_codigo = "";
            $input_array = array(
                'codigo_mun' => $this->gsatelite->get_parametro('ACT_ABBR_EMPRESA'),
                'act_correlativo' => (isset($data_send['correlativo'])) ? $data_send['correlativo'] : 1,
                'act_id_tac' => $data_send['act_tipo_activo'],//
                'act_id_grp' => $data_send['act_grupo'],
                'act_id_tad' => $data_send['act_tipo_tad'],
                'act_id_suc' => $data_send['act_id_suc'],
                'act_id_cec' => $data_send['centro_costo'],
                'act_id_are' => (isset($data_send['departamento'])) ? $data_send['departamento'] : null,
                'act_id_dxd' => ($data_send['activo_dxd']>0)?$data_send['activo_dxd']:null,
                'act_codigo' => $data_send['act_codigo'],
                'act_nombre' => $data_send['act_nombre'],
                'act_descripcion'=> $data_send['descripcion'],
                'act_fecha_adq'=> (isset($data_send['act_fecha_adq'])) ? formatear_fecha("dmY",$data_send['act_fecha_adq']) : date('dmY'),//
                'act_depreciable'=>$depreciacion,
                'act_valor_compra'=>$data_send['act_valor_compra'],
                'act_valor_cont'=>$data_send['act_valor_compra'], //el valor de contable en un inicio siempre sera el valor de compra
                'act_valor_residual'=>($data_send['act_valor_residual'] > 0) ? $data_send['act_valor_residual']:0,
                'act_porcentaje_dep'=>$data_send['act_porcentaje_dep'],
                'act_observacion'=>$data_send['act_observacion'],
                //'act_valor_dep'=>0,
                //'act_fecha_dep'=>$fecha_ini_dep,
                //'act_fecha_desact'=>null,
                //'act_obs_desact'=>null,
                //'act_valor_libro'=>null,
                'act_vida_util'=>$data_send['act_vida_util'],
                'act_fecha_inicia_dep'=> (isset($fecha_ini)) ? $fecha_ini : null,
                'act_foto'=> (isset($data_send['foto_activo'])) ? $data_send['foto_activo'] : null,
                'act_fecha_vence_garantia'=>$fecha_ven,
                'act_dias_garantia'=> $data_send['dias_gar'],
                'act_observacion_garantia'=> $data_send['observacion_gar'],
                'act_estado'=>$estado,
                'act_usu_creacion'=>$this->tank_auth->get_user_id(),
                'act_fecha_creacion'=>date('Y-m-d H:i:s'),
                'act_usu_modificacion'=>$this->tank_auth->get_user_id(),
                'act_fecha_modificacion'=>date('Y-m-d H:i:s')
            ); 
            $correlativo = "";
            //Parametro donde se tiene el tipo de formato que tendra el codigo administrativo
            $config_act_fij = $this->gsatelite->get_parametro('SYS_CONFIGURACION_CODIGO_ACTIVO', null, false, array('ESTRUCTURA_CODIGO'));
            //Parametro donde se obtiene el separador que se ira agregando al ir concatenando en $generar_codigo
            $config_act_separacion = $this->gsatelite->get_parametro('SYS_CONFIGURACION_CODIGO_ACTIVO', null, false, array('SEPARACION_CODIGO'));
            //Parametro donde se obtiene el dato que se tomara como correlativo(SOLO CAMPOS PERTENECIENTES A LA TABLA "act_activo_fijo")
            $config_agrupar_correlativo = $this->gsatelite->get_parametro('SYS_CONFIGURACION_CODIGO_ACTIVO', null, false, array('AGRUPAMIENTO_CORRELATIVO'));
            $long_corr = $this->gsatelite->get_parametro('SYS_CONFIGURACION_CODIGO_ACTIVO', null, false, array('LONG_CORRELATIVO'));
            $largo = ($long_corr != null) ? $long_corr : 2; 
            $copiar_codigo_depend = $this->gsatelite->get_parametro('SYS_CONFIGURACION_CODIGO_ACTIVO', null, false, array('DEPENDENCIA_COPIA_CODIGO'));
            //Hacemos un array de todos los campos que se tomara como correlativo
            $config_agrupar_correlativo = explode(",", $config_agrupar_correlativo);
            //Hacemos un array con todos los campos que se concatenaran en el codigo administrativo
            $config_array = explode(",", $config_act_fij);
            //===================== Arrays de todas las tablas que tienen relacion con activo fijo ============================================
            //Array de donde se obtiene todos los datos del area
            /*
            $input_array_area = $this->gsatelite->get_tabla('are_area', array('are_id' => $data_send['departamento']));
            $input_array_area = ($input_array_area)? $input_array_area[0]:array();
            */
            if (isset($data_send['departamento'])) {
                $input_array_area = $this->gsatelite->get_tabla('are_area', array('are_id' => $data_send['departamento']));
                $input_array_area = ($input_array_area)? $input_array_area[0]:array();
            } else {
                $input_array_area = array();
            }            
            //Array donde se obtiene todos los datos del grupo
            $input_array_grupo = $this->gsatelite->get_tabla('grp_grupo', array('grp_id' => $data_send['act_grupo']));
            $input_array_grupo = ($input_array_grupo)? $input_array_grupo[0]:array();
            //Array donde se obtiene todos los datos del tipo de activo
            $input_array_tipo = $this->gsatelite->get_tabla('tac_tipo_activofijo', array('tac_id' => $data_send['act_tipo_activo']));
            $input_array_tipo = ($input_array_tipo)? $input_array_tipo[0]:array();
            //Array donde se obtiene todos los datos del tipo de adquisicion
            $tipo_adqui = (isset($data_send['act_tipo_tad'])) ? $data_send['act_tipo_tad'] : $data_send['act_id_tad'];
            $input_array_tipo_adq = $this->gsatelite->get_tabla('tad_tipo_adquisicion', array('tad_id' => $tipo_adqui));
            $input_array_tipo_adq = ($input_array_tipo_adq) ? $input_array_tipo_adq[0] : array();
            //Array donde se obtiene todos los datos del detalle documento proveedor //PDTE VERIFY
            /*
            $input_array_detalle_doc_prov = $this->gsatelite->get_tabla('dxd_detalle_documento_proveedor', array('dxd_id' => $data_send['act_id_dxd']));
            $input_array_detalle_doc_prov = ($input_array_detalle_doc_prov) ? $input_array_detalle_doc_prov : array();
            */
            if (isset($data_send['act_id_dxd'])) {
                $input_array_detalle_doc_prov = $this->gsatelite->get_tabla('dxd_detalle_documento_proveedor', array('dxd_id' => $data_send['act_id_dxd']));
                $input_array_detalle_doc_prov = ($input_array_detalle_doc_prov) ? $input_array_detalle_doc_prov : array();
            } else {
                $input_array_detalle_doc_prov = array();
            }
            //Array data sucursal
            $input_array_sucursal = $this->gsatelite->get_tabla('suc_sucursal', array('suc_id' => $data_send['act_id_suc']));
            $input_array_sucursal = ($input_array_sucursal) ? $input_array_sucursal[0] : array();
            //Array data Centro Costo
            /*
             $input_array_centro_costo = $this->gsatelite->get_tabla('cec_centro_costo', array('cec_id' => $data_send['centro_costo']));
             $input_array_centro_costo = ($input_array_centro_costo) ? $input_array_centro_costo[0] : array();
            */
            if (isset($data_send['centro_costo'])) {
                $input_array_centro_costo = $this->gsatelite->get_tabla('cec_centro_costo', array('cec_id' => $data_send['centro_costo']));
                $input_array_centro_costo = ($input_array_centro_costo) ? $input_array_centro_costo[0] : array();
            } else {
                $input_array_centro_costo = array();
            }
             
            for ($i = 0; $i < count($config_array); $i++) {
                if ( isset($input_array[$config_array[$i]]) ) { 
                    $generar_codigo .= $input_array[$config_array[$i]] . $config_act_separacion;
                } else if($config_array[$i] == "correlativo") {
                    //Por defecto se sabe que el correlativo no vendra en el post de todo el form, entonces realizamos lo siguiente cuandp busque el correlativo
                    $where = null;
                    $code = (isset($data_send['activo_id'])) ? $data_send['activo_id'] : null;
                    $sig_emp = strtolower(trim($this->gsatelite->get_parametro('SYS_SIGLAS')));
                    if ($code != null) {
                        $num = 1;
                        $data_act = $this->gsatelite->get_tabla('act_activo_fijo', array('act_id' => $code));
                        // $correlativo = $data_act[0]['act_correlativo'];
                        // // if($data_act[0][])
                        // $generar_codigo .= $correlativo.$config_act_separacion;
                        //Recoremos todos los datos que se requiren sean correlativos
                        for ($k = 0; $k < count($config_agrupar_correlativo); $k++) {
                            //Buscamos en el POST el valor o valores que se requiren como correlativos
                            if(isset($input_array[$config_agrupar_correlativo[$k]])) {
                                //Realizamos un where, segun el campo obtenido en el parametro, asignamos el valor obtenido del POST que coincida al del parametro
                                $where[$config_agrupar_correlativo[$k]] = $input_array[$config_agrupar_correlativo[$k]];
                                //print_r($config_agrupar_correlativo);
                                if($id!=null){
                                    $num=1;
                                }else{
                                    if($input_array[$config_agrupar_correlativo[$k]] == $data_act[0][$config_agrupar_correlativo[$k]]) {
                                        $num = 0;
                                    }  
                                }
                            }
                        }
                                        $this->db->order_by('CAST(act_codigo AS UNSIGNED)','DESC');
                                        if ($sig_emp != 'defensoria') {
                                            $this->db->where("LEFT(act_codigo,LENGTH('$generar_codigo')) = '$generar_codigo'", null, false);
                                        }                                       
                        $correlativo  = $this->gsatelite->get_tabla('act_activo_fijo',$where);
                        // var_dump($this->db->last_query());die();
                        // $correlativo = count($correlativo) + $num;
                        // var_dump($correlativo);die();

                        /////////// DEBE ESTAR COMENTADO EN SERSAPROSA ///////////
                        if ($sig_emp == 'defensoria') {
                            $this->db->_protect_identifiers = FALSE; // forzar el escape para que no coloque la comilla " ` "  en el query
                            $orderby = "CAST(SUBSTRING_INDEX(act_codigo, " . $this->db->escape($config_act_separacion) . ", -1) AS UNSIGNED) DESC";
                            $this->db->order_by($orderby, '', FALSE);
                            $correlativo = $this->gsatelite->get_tabla('act_activo_fijo',$where);
                            $this->db->_protect_identifiers = TRUE;
                        } else {
                                           $this->db->order_by("act_codigo","DESC");
                                           $this->db->where("LEFT(act_codigo,LENGTH('$generar_codigo')) = '$generar_codigo'", null, false);
                            $correlativo = $this->gsatelite->get_tabla('act_activo_fijo');                        
                        }
                        /// COMENTADO EN SERSAPROSA 

                        if ($sig_emp == 'defensoria') {
                            $parts_codigo = explode($config_act_separacion, $correlativo[0]['act_codigo']);
                            $correlativo_ = end($parts_codigo);
                        } else {
                            $correlativo_ = str_replace($generar_codigo, '', $correlativo[0]['act_codigo']);
                        }
                        $correlativo_ = intval($correlativo_) + 1;
                        $correlativo = str_pad($correlativo_, $largo, '0', STR_PAD_LEFT);                        
                        //print_r($num);
                        //Se concatena el correlativo el valor obtenido de la consulta con el where aplicado
                        $generar_codigo .= trim($correlativo.$config_act_separacion);
                    } else {
                        //Recoremos todos los datos que se requiren sean correlativos
                        for ($k = 0; $k < count($config_agrupar_correlativo); $k++) {
                            //Buscamos en el POST el valor o valores que se requiren como correlativos
                            if(isset($input_array[$config_agrupar_correlativo[$k]])) {
                                //Realizamos un where, segun el campo obtenido en el parametro, asignamos el valor obtenido del POST que coincida al del parametro
                                $where[$config_agrupar_correlativo[$k]] = $input_array[$config_agrupar_correlativo[$k]];                     
                            }
                        }
                                       $this->db->order_by('CAST(act_codigo AS UNSIGNED)','DESC');
                                       if ($sig_emp != 'defensoria') {
                                       $this->db->where("LEFT(act_codigo,LENGTH('$generar_codigo')) = '$generar_codigo'", null, false);
                                       }                                       
                        $correlativo = $this->gsatelite->get_tabla('act_activo_fijo',$where);
                        // echo $this->db->last_query(); die();
                        $x = (-1 * $largo);
                        /*EN SERSAPROSA SE COMENTO LA "PARTE 2" PUES SE LES CAMBIO EL CORRELATIVO A 6 DECIMALES, PERO ALGUNOS ANTIGUOS NO LOS ORDENABA BIEN 
                        Y QUEDABA UN NUMERO DISTINTO Y SOLO ORDENABA COMO NUMERO EN LA PRIMERA CONSULTA // JUNIO/2022 */ 

                        /////////// DEBE ESTAR COMENTADO EN SERSAPROSA ///////////
                        //if($correlativo) { //si la query anterior posee datos consultar nuevamente por el último
                        if (!(preg_match('/^\d+$/', $generar_codigo))) {
                            // OTRA OPCION ctype_digit($generar_codigo)) //
                            if ($sig_emp == 'defensoria') {
                                $this->db->_protect_identifiers = FALSE; // forzar el escape para que no coloque la comilla " ` "  en el query
                                $orderby = "CAST(SUBSTRING_INDEX(act_codigo, " . $this->db->escape($config_act_separacion) . ", -1) AS UNSIGNED) DESC";
                                $this->db->order_by($orderby, '', FALSE);
                                $correlativo = $this->gsatelite->get_tabla('act_activo_fijo',$where);
                                $this->db->_protect_identifiers = TRUE; // volver a dejar como estaba
                            } else {
                                            // $this->db->order_by("SUBSTRING(act_codigo, CAST($x AS SIGNED))","DESC");
                                               $this->db->order_by("act_codigo","DESC");
                                               $this->db->where("LEFT(act_codigo,LENGTH('$generar_codigo')) = '$generar_codigo'", null, false);
                                $correlativo = $this->gsatelite->get_tabla('act_activo_fijo',$where);
                            }
                        }
                        // echo $this->db->last_query(); die();
                        // }
                        // COMENTADO EN SERSAPROSA

                        if (count($correlativo) > 0) {
                            if ($sig_emp == 'defensoria') {
                                $parts_codigo = explode($config_act_separacion, $correlativo[0]['act_codigo']);
                                $correlativo_ = end($parts_codigo);
                            } else {
                                $correlativo_ = str_replace($generar_codigo, '', $correlativo[0]['act_codigo']);
                            }
                            $correlativo_ = intval($correlativo_) + 1;
                        } else {
                            $correlativo_ = 1;
                        }
                        $correlativo = str_pad($correlativo_, $largo, '0', STR_PAD_LEFT);                        
                        //Se concatena el correlativo el valor obtenido de la consulta con el where aplicado
                        $generar_codigo .= trim($correlativo.$config_act_separacion);
                    }
                    //Aqui se aplica lo dinamico en el correlativo, en dado caso se quiere obtener por ejemplo "are_prefijo" de la tabla are_area;
                    //que es un campo que no esta esta la tabla act_activo_fijo, se podra acceder a el mediente los arreglos definidos $input_array_REF_TABLA
                    //Se busca los campos de la tabla are_area si en dado caso son requeridos agregarlos al correlativo
                } else if(isset($input_array_area[$config_array[$i]])) {
                    $generar_codigo .= trim($input_array_area[$config_array[$i]]) . $config_act_separacion;
                } else if(isset($input_array_grupo[$config_array[$i]])) {
                    //Se busca los campos de la tabla gr_grupo si en dado caso son requeridos agregarlos al correlativo
                    $generar_codigo .= trim($input_array_grupo[$config_array[$i]]) . $config_act_separacion;
                } else if(isset($input_array_tipo[$config_array[$i]])) {
                    //Se busca los campos de la tabla tac_tipo_activofijo si en dado caso son requeridos agregarlos al correlativo
                    $separacion = ($this->gsatelite->get_parametro('ACT_ABBR_EMPRESA') == 4118) ? "" : $config_act_separacion;
                    $generar_codigo .= trim($input_array_tipo[$config_array[$i]]) . $separacion;
                } else if(isset($input_array_tipo_adq[$config_array[$i]])) {
                    //Se busca los campos de la tabla tad_tipo_adquisicion si en dado caso son requeridos agregarlos al correlativo
                    $generar_codigo .= trim($input_array_tipo_adq[$config_array[$i]]) . $config_act_separacion;
                } else if(isset($input_array_detalle_doc_prov[$config_array[$i]])) {
                    //Se busca los campos de la tabla dxd_detalle_documento_proveedor si en dado caso son requeridos agregarlos al correlativo
                    $generar_codigo .= trim($input_array_detalle_doc_prov[$config_array[$i]]) . $config_act_separacion;
                } else if(isset($input_array_sucursal[$config_array[$i]])) {
                    //Se busca los campos de la tabla dxd_detalle_documento_proveedor si en dado caso son requeridos agregarlos al correlativo
                    $generar_codigo .= trim($input_array_sucursal[$config_array[$i]]) . $config_act_separacion;
                } else if(isset($input_array_centro_costo[$config_array[$i]])) {
                    //Se busca los campos de la tabla dxd_detalle_documento_proveedor si en dado caso son requeridos agregarlos al correlativo
                    $generar_codigo .= trim($input_array_centro_costo[$config_array[$i]]) . $config_act_separacion;
                }
                else{$generar_codigo .= "";}

            }
            if (is_numeric($copiar_codigo_depend) && $copiar_codigo_depend == 1 && $data_send['activo_dxd'] > 0 && is_null($id)) {
                $generar_codigo = $this->gsatelite->get_campo("act_activo_fijo","act_codigo", array("act_id" => $data_send['activo_dxd']));
            }
            if($id != null){
                $data = array('codigo' => (trim($config_act_separacion) != "") ? substr($generar_codigo, 0, -1) : $generar_codigo, 'correlativo' => $correlativo);
                return $data;
            }else{
                $data = array('new_code' => ((trim($config_act_separacion) !="")? substr($generar_codigo,0,-1):$generar_codigo), 'correlativo' => $correlativo);
                echo json_encode($data);
            }
        }
    }

    public function get_last_code(){
        if ($_POST) {
            $tipo_activo = $this->input->post("tipo_act");
            $grupo_activ = $this->input->post("gpo_acti");
            $tipo_adquis = $this->input->post("tipo_adq");
            $estructura = explode(',', $this->gsatelite->get_parametro('SYS_CONFIGURACION_CODIGO_ACTIVO', null, false, array('ESTRUCTURA_CODIGO')));
            $separacion = $this->gsatelite->get_parametro('SYS_CONFIGURACION_CODIGO_ACTIVO', null, false, array('SEPARACION_CODIGO'));
            $longitud = $this->gsatelite->get_parametro('SYS_CONFIGURACION_CODIGO_ACTIVO', null, false, array('LONG_CORRELATIVO'));
            $codigo_tadqu = $this->gsatelite->get_campo('tad_tipo_adquisicion', 'tad_codigo', array('tad_id' => $tipo_adquis));
            $codigo_tacti = $this->gsatelite->get_campo('tac_tipo_activofijo', 'tac_codigo', array('tac_id' => $tipo_activo));
            $codigo_grupo = $this->gsatelite->get_campo('grp_grupo', 'grp_codigo', array('grp_id' => $grupo_activ));
            $largo = ($longitud != null) ? $longitud : 2;
            $x = (-1 * $largo);
            $generated_codigo = "";
            foreach ($estructura as $key => $value) {
                if ($value != "correlativo") {
                    switch ($value) {
                        case "tad_codigo":
                            $generated_codigo .= $codigo_tadqu . $separacion;
                            break;
                        case "tac_codigo":
                            $generated_codigo .= $codigo_tacti . $separacion;
                            break;
                        case "grp_codigo":
                            $generated_codigo .= $codigo_grupo . $separacion;
                            break;                        
                    }
                }
            }            
                        // $this->db->order_by("SUBSTRING(act_codigo, CAST($x AS SIGNED))","DESC");
                        $this->db->order_by("act_codigo DESC");
                        $this->db->where("LEFT(act_codigo,LENGTH('$generated_codigo')) = '$generated_codigo'", null, false);
            $code_all = $this->gsatelite->get_tabla('act_activo_fijo');
            $ultimo = $posible = "";
            if (count($code_all) > 0) {
                $ultimo_usado = str_replace($generated_codigo, '', $code_all[0]['act_codigo']);
                $proximo_usar = intval($ultimo_usado) + 1;
                $correlativo = str_pad($proximo_usar, $largo, '0', STR_PAD_LEFT);
                $ultimo = $code_all[0]['act_codigo'];
                $posible = $generated_codigo . $correlativo;
            }
            echo json_encode(array('last_code' => $ultimo, 'disponible' => $posible));
        }
    }
    

    function obtener_cuentas_contables() {
      $cnt_contables = $this->gsatelite->get_tabla('cnt_cuenta_contable', array('cnt_estado' => 1));
      echo json_decode('cnt_');
    }
        
    //Crear activo mejorado apartir de otro
    public function crear_dependencia_mejorada($id_activo){
        //preguntar por el post y generar la mejora
        if ($this->input->post("txtId_activo") > 0 ) {
            $id_activo = $this->input->post("txtId_activo") ;
            // $registro_mej =  $this->gsatelite->ingresar('mej_mejora_activo',$mejora);
            $cabezera        = $this->db->where('act_id',$id_activo)->get('act_activo_fijo')->row_array();
            $caracteristicas = $this->gsatelite->get_tabla('cxc_caracterxactivo', array('cxc_id_act'=>$id_activo, 'cxc_estado' => 1));
            $depreciaciones  = $this->gsatelite->get_tabla('dep_depreciacion', array('dep_id_act'=>$id_activo));
            $distribuccion   = $this->gsatelite->get_tabla('dda_distribucion_depreciacion_activo', array('dda_id_act'=>$id_activo));
            $anexos          = $this->gsatelite->get_tabla('axa_anexoxactivo', array('axa_id_act'=>$id_activo)); 
            $array_act=array(
                'act_id_tac'                => $cabezera['act_id_tac'],
                'act_id_grp'                => $cabezera['act_id_grp'],
                'act_id_tad'                => $cabezera['act_id_tad'],
                'act_id_are'                => $cabezera['act_id_are'],                
                'act_id_cec'                => $this->input->post("slcCentroCosto"),
                'act_id_prv'                => $cabezera['act_id_prv'], 
                'act_afecta_contabilidad'   => $cabezera['act_afecta_contabilidad'],
                'act_id_suc'                => $cabezera['act_id_suc'],
                'act_referencia_activo'     => $cabezera['act_referencia_activo'],
                'act_id_pcl'                => $cabezera['act_id_pcl'],                
                'act_id_act_dependencia'    => $id_activo,
                'act_correlativo'           => $cabezera['act_correlativo'], 
                'act_id_dxd'                => $cabezera['act_id_dxd'],                
                'act_codigo'                => $cabezera['act_codigo'],                
                'act_nombre'                => $cabezera['act_nombre'],
                'act_descripcion'           => $this->input->post("txtDescripcion"),
                'act_fecha_adq'             => $cabezera['act_fecha_adq'],                
                'act_depreciable'           => $cabezera['act_depreciable'],                
                'act_valor_compra'          => $cabezera['act_valor_compra'],                 
                'act_valor_cont'            => $cabezera['act_valor_cont'],                
                'act_valor_residual'        => $cabezera['act_valor_residual'],
                'act_porcentaje_dep'        => $cabezera['act_porcentaje_dep'],
                'act_observacion'           => $this->input->post("txtObservacion"),
                'act_aplica_flujo_proyecto' => 0,
                'act_valor_dep'             => $cabezera['act_valor_dep'],                
                'act_fecha_dep'             => $cabezera['act_fecha_dep'],                               
                'act_valor_libro'           => $cabezera['act_valor_libro'],
                'act_vida_util'             => $cabezera['act_vida_util'],
                'act_fecha_inicia_dep'      => $cabezera['act_fecha_inicia_dep'],
                'act_foto'                  => $cabezera['act_foto'],
                'act_fecha_vence_garantia'  => $cabezera['act_fecha_vence_garantia'],                
                'act_dias_garantia'         => $cabezera['act_dias_garantia'],                
                'act_observacion_garantia'  => $cabezera['act_observacion_garantia'],
                'act_factura_compra'        => $cabezera['act_factura_compra'],
                'act_referencia_pago'       => $cabezera['act_referencia_pago'],                
                'act_estado'                => 1,                
                'act_usu_creacion'=>$this->tank_auth->get_user_id(),                
                'act_fecha_creacion'=>date('Y-m-d H:i:s'),                
                'act_usu_modificacion'=>$this->tank_auth->get_user_id(),                
                'act_fecha_modificacion'=>date('Y-m-d H:i:s'),
            );
            $registro = $this->gsatelite->ingresar('act_activo_fijo', $array_act);
            if(count($caracteristicas)>0){   
                for ($j=0; $j < count($caracteristicas) ; $j++) {
                    $carxart = array(
                        'cxc_id_act'             => $registro,
                        'cxc_id_cxi'             => $caracteristicas[$j]['cxc_id_cxi'],                        
                        'cxc_valor'              => $caracteristicas[$j]['cxc_valor'],
                        'cxc_estado'             => 1,                        
                        'cxc_usu_creacion'       => $this->tank_auth->get_user_id(),
                        'cxc_fecha_creacion'     => date('Y-m-d H:i:s'),
                        'cxc_usu_modificacion'   => $this->tank_auth->get_user_id(),
                        'cxc_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $this->db->insert('cxc_caracterxactivo',$carxart);
                }
            } 
            if ($cabezera['act_depreciable'] == 1 && count($distribuccion) > 0) {
                for ($k=0; $k < count($distribuccion) ; $k++) { 
                    $dda_art = array(
                        'dda_id_act'    => $registro,
                        'dda_id_cnt'      => $distribuccion[$k]['dda_id_cnt'],
                        'dda_fecha_desde' => $distribuccion[$k]['dda_fecha_desde'],
                        'dda_fecha_hasta' => $distribuccion[$k]['dda_fecha_hasta'],
                        'dda_observacion' => $distribuccion[$k]['dda_observacion'],
                        'dda_estado'      => $distribuccion[$k]['dda_estado'],
                        'dda_usu_creacion' => $this->tank_auth->get_user_id(),
                        'dda_fecha_creacion' => date('Y-m-d H:i:s'),
                        'dda_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'dda_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $this->db->insert('dda_distribucion_depreciacion_activo',$dda_art);
                }
            }
            if ($cabezera['act_depreciable'] == 1 && count($depreciaciones) > 0) {
                for ($i=0; $i < count($depreciaciones) ; $i++) { 
                    $dep_art = array(
                        'dep_id_act'    => $registro,
                        'dep_id_prd'    => $depreciaciones[$i]['dep_id_prd'],
                        'dep_monto'     => $depreciaciones[$i]['dep_monto'],
                        'dep_fecha'     => $depreciaciones[$i]['dep_fecha'],
                        'dep_estado'    => $depreciaciones[$i]['dep_estado'],
                        'dep_usu_mod'   => $this->tank_auth->get_user_id(),
                        'dep_fecha_mod' => date('Y-m-d H:i:s')
                    );
                    $this->db->insert('dep_depreciacion',$dep_art);
                }
            }
            if(count($anexos)>0){ 
                foreach ($anexos as $key => $value) {
                    $anx_art = array(
                        'axa_id_act'    => $registro,
                        'axa_id_anx'    => $value['axa_id_anx'],
                        'axa_estado'    => $value['axa_estado'],
                        'axa_usu_mod'   => $this->tank_auth->get_user_id(),
                        'axa_fecha_mod' => date('Y-m-d H:i:s')
                    );
                    $this->db->insert('axa_anexoxactivo',$anx_art);
                }
            }
            // $activo = $cabezera['act_id_dxd']
            // if ($registro > 0 && $activo > 0) {
            //     $cant = $this->gsatelite->get_campo('dxd_detalle_documento_proveedor', 'dxd_procesado_inventario', array('dxd_id'=>$activo));
            //     $sum = (int)$cant+1;
            //     $this->gsatelite->actualizar_array('dxd_detalle_documento_proveedor', array('dxd_procesado_inventario'=>$sum), array('dxd_id'=>$activo));
            // }             
            // $mejora = array(
            //     'mej_id_act'        => $this->input->post('txtId_activo'),
            //     'mej_descripcion'   => $this->input->post('txtObservacion'),
            //     'mej_valor'         => $this->input->post('txtMonto'),
            //     'mej_fecha_registro'=> date('Y-m-d H:i:s'),
            //     'mej_estado'        => 1,
            //     'mej_usu_mod'       => $this->tank_auth->get_user_id(),
            //     'mej_fecha_mod'     => date('Y-m-d H:i:s'),
            //     'mej_id_act_generado' => $registro  
            // );
            // $registro_mej =  $this->gsatelite->ingresar('mej_mejora_activo',$mejora);        
            $alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Registro de dependencia ingresado con éxito",'texto_alerta'=>"El nuevo activo ha sido creado.");
            $this->session->set_flashdata($alerta); 
            redirect('activo/nuevo/bajas_proyecto');
        }
        satelite_validar();
        $reg = $this->activo_fijo->get_depreciacion_activo(array("act_id"=>$id_activo));
        $data["registro_activo"] = $reg[0];
        $html = $this->load->view("activo/nuevo/crear_dependencia_mejorada",$data,true);
        echo $html;
    }

    /**
     * @author Luis Navarro - Grupo Satélite
     * @since  2018-11-19
     * @return Es una redireccion al proceso de Baja de activos
    */
    public function reactivar_activo() {
      satelite_validar();
      $this->gsatelite->show_dialog("Se ha deshabilitado esta opción, se redireccionara a Baja de Activos", "activo/nuevo/index_bajas", "error", "Activo Fijo");
    }

  /**
   * Cargar vista del controlador
   * 
   * @param integer $data
   * @param integer $crud
   * @return HTML vista del controlador
   */
  function _cargarvista($data = 0, $crud = 0, $full = false )
  { 
    $this->load->view('vacia',$crud); 
    if($data!=0)
      $data=array_merge($data,$this->masterpage->getUsuario());
    else
      $data=$this->masterpage->getUsuario();
    $vista=$data['modulo'].'/'.$data['control'].'/'.$data['funcion'];
        if($full){
            $this->masterpage->setMasterPage('masterpage_full');
        }else{
            $this->masterpage->setMasterPage('masterpage_default');
        }
    $this->masterpage->addContentPage($vista, 'content',$data);
    $this->masterpage->show();
  }

  /**
     * Author Manuel Anzora
     * date 03/12/2018
     * Proceso para obtener documento de proveedor, metodo llamado via ajax
     */
    function get_doc_prv(){
        //DPV_TIPO ES 3 PORQUE SE FILTRA SOLO LOS QUE SON ACTIVO FIJO
        $proveedor = $this->input->post('proveedor');
        $data = $this->gsatelite->get_dropdown('dpv_documento_proveedor', '{dpv_numero_documento}::{dpv_concepto}', '', array('dpv_tipo'=>3,'dpv_estado'=>1,'dpv_id_prv' => $proveedor) ,null,null,'dpv_id',true);
        /*$dataPrv = $this->activo_fijo->get_prv('dpv_documento_proveedor', array('dpv_id_prv' => $proveedor,'dpv_tipo'=>3, 'dpv_estado'=>1), 'dpv_id, dpv_numero_documento, dpv_concepto');
        $options = '<option></option>';
        foreach ($dataPrv as $value) {
            $options .= '<option value="'.$value['dpv_id'].'">'.$value['dpv_numero_documento'].'- '.$value['dpv_concepto'].'</option>';
        }*/
        echo str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $data);
    }
    
    /**
     * Author Manuel Anzora
     * date 03/12/2018
     * Proceso para obtener iten de documento, metodo llamado via ajax
     */
    function get_det_doc(){
        $doc_proveedor = $this->input->post('doc_prv');
        $prv           = $this->input->post('prv');
        $dataDet       = $this->activo_fijo->get_dxd_document($doc_proveedor);
        $options       = '<option></option>';
        $cantidad = $ctdad_total = $ctdad_activos = 0;
        // print_r($dataDet);die();
        if(count($dataDet) > 0){
            foreach ($dataDet as $value) {
                if($value['cantidad_act'] < $value['dxd_cantidad']){
                    $options .= '<option value="'.$value['dxd_id'].'" data-precio-unitario="'.$value['dxd_precio_unitario'].'" data-categoria="'.$value['tac_id'].'" data-monto="'.$value['dxd_total'].'">'.$value['nombre'].'</option>';
                    $cantidad++;
                    $ctdad_total += $value['dxd_total'];
                    $ctdad_activos += $value['cantidad_act'];
                }
            }
        }
        echo json_encode(array('option' => $options, 'cantidad' => $cantidad, 'cantidad activos' => $ctdad_activos, 'cantidad total' => $ctdad_total));
    }
    
    /**
     * Author Manuel Anzora
     * date 03/12/2018
     * Proceso para obtener departamentos de la sucursal seleccionada, metodo llamado via ajax
     */
    public function get_depto(){
        $suc_id = $this->input->post('suc_id');
        $data = $this->gsatelite->get_dropdown('are_area', '{are_prefijo}::{are_nombre}', '', array('are_id_suc'=>$suc_id,'are_estado'=>1) ,null,null,'are_id',true);
        echo str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $data);
    }
    /**
     * Author Manuel Anzora
     * date 03/12/2018
     * Proceso para obtener activos por la sucursal y el departamento, metodo llamado via ajax
     */
    public function get_activo_fijo(){
        $suc_id = $this->input->post('sucursal');
        $depto = $this->input->post('depto');
        $activo = $this->input->post('activo');
        //ID DEL ACTIVO CUANDO ES EDITADO
        $activo_id = $this->input->post('act_id');
        $where = null;
        if ($depto != '') {
            $where['act_id_are'] = $depto;
        }
        if($suc_id != ''){
            $where['act_id_suc'] = $suc_id;
        }
        if($activo_id > 0){
            $where['act_id != '] = $activo_id;
        }
        $like = array("CONCAT(act_codigo,' - ',act_nombre)" => $activo);
        $resultado = $this->activo_fijo->search_activo_like($where, $like);
        echo json_encode($resultado);       
    }

  public function reactivacion_activos(){
    $respuesta     = false;
    $id_to_update  = $this->input->post('id_activo');
    $array_update  = array(
      'act_estado'             => 1,
      'act_fecha_modificacion' => date('Y-m-d H:i:s'),
      'act_usu_modificacion'   => $this->tank_auth->get_user_id()
    );

    if($this->gsatelite->actualizar_array('act_activo_fijo',$array_update,array('act_id' => $id_to_update))) {
      $respuesta = true;
    }

    echo json_encode(array('respuesta'=>$respuesta));
    die();
  }

    /**
     * @author Nelson David Soriano
     * @since  12-04-2019
     * @return confirmacion de cambios aplicados
     * Descripcion: Funcion para actualizar los codigos de areas en activo fijo para el erp de Sonsonate
    */
    public function actualizar_codigos_areas(){
        satelite_validar();
        $data =  array(
            'are_prefijo1' => 831501,
            'are_prefijo2' => 831503,
            'are_prefijo3' => 831553,
            'are_prefijo4' => 831504,
            'are_prefijo5' => 831505,
            'are_prefijo6' => 831505,
            'are_prefijo7' => 831537,
            'are_prefijo8' => 831502,
            'are_prefijo9' => 831506,
            'are_prefijo10' => 831509,
            'are_prefijo11' => 831509,
            'are_prefijo12' => 831509,
            'are_prefijo13' => 831509,
            'are_prefijo14' => 831513,
            'are_prefijo15' => 831511,
            'are_prefijo16' => 831507,
            'are_prefijo17' => 831560,
            'are_prefijo18' => 831512,
            'are_prefijo19' => 831512,
            'are_prefijo20' => 831516,
            'are_prefijo21' => 831530,
            'are_prefijo22' => 831530,
            'are_prefijo23' => 831514,
            'are_prefijo24' => 831543,
            'are_prefijo25' => 831538,
            'are_prefijo26' => 831549,
            'are_prefijo27' => 831533,
            'are_prefijo28' => 831539,
            'are_prefijo29' => 831542,
            'are_prefijo30' => 831562,
            'are_prefijo31' => 831559,
            'are_prefijo32' => 831563,
            'are_prefijo33' => 831567,
            'are_prefijo34' => 831536,
            'are_prefijo35' => 831541,
            'are_prefijo36' => 831548,
            'are_prefijo37' => 831550,
            'are_prefijo38' => 831551,
            'are_prefijo39' => 831552,
            'are_prefijo40' => 831564,
            'are_prefijo41' => 831565,
            'are_prefijo42' => 831517,
            'are_prefijo43' => 831519,
            'are_prefijo44' => 831520,
            'are_prefijo45' => 831521,
            'are_prefijo46' => 831522,
            'are_prefijo47' => 831522,
            'are_prefijo48' => 831554,
            'are_prefijo50' => 831525,
            'are_prefijo51' => 831532,
            'are_prefijo52' => 831531,
            'are_prefijo53' => 831544,
            'are_prefijo54' => 831566,
            'are_prefijo55' => 831540,
            'are_prefijo56' => 831556,
            'are_prefijo57' => 831570,
            'are_prefijo58' => 831547,
            'are_prefijo59' => 831528,
            'are_prefijo60' => 831545,
            'are_prefijo61' => 831546,
            'are_prefijo62' => 831515,
            'are_prefijo63' => 831534,
            'are_prefijo64' => 831535,
            'are_prefijo65' => 831558,
            'are_prefijo66' => 831555,
            'are_prefijo49' => 831526
        );
        $where = array('10','36','44','2','34','64','1','14','9','5','52','62','65','32','19','22','55','17','51','39','30','54','27','4','20','18','38','40','7','56','53','57','61','15','3','31','28','33','42','59','60','11','37','6','8','13','46','47','29','21','25','41','43','45','12','66','49','16','58','35','63','24','23','50','48','26');
        $i = 0;
        $resultado = array();
        foreach ($data as $key => $valor) { 
            $resultado[] = $this->gsatelite->actualizar('are_area',array('are_prefijo' => $valor),'are_id',$where[$i]);
            $i++;
        }
        if (count($resultado)>0) {
            $alerta=array('tipo_alerta'=> 'success','titulo_alerta'=>"Registros actualizados",'texto_alerta'=>"".count($resultado)." Registros fueron actualizados");
            $this->session->set_flashdata($alerta); 
            redirect('activo/nuevo/index_activos');
        }else{
            $alerta=array('tipo_alerta'=> 'error','titulo_alerta'=>"Registro no actualizado",'texto_alerta'=>"El registro no pudo ser actualizado, verifique la información ingresada.");
            $this->session->set_flashdata($alerta); 
            redirect('activo/nuevo/index_activos');
        }
    }

    public function bajas_proyecto(){
        //Verificar Permisos de acceso
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $data['activos'] = $this->activo_fijo->get_listado_depreciacion(null,'0',null,null,null,null,null,null,null,null,'1');
            // print_r($this->db->last_query());die();   //para ver la query que se uso
            $data['titulo_personal']="Baja de activos";
            $this->_cargarvista(null, $data);
        }
    }

    public function iniciar_simulacion_real($id_activo = 0 ,$es_reporte=0)
    {

        if($id_activo==0)
            exit('No direct script access allowed');
        //print_r('aca voy');
        //die();
        
        //Inicializando variables a usar
        $id_activo    = $id_activo;
        $registro = $this->gsatelite->get_tabla('act_activo_fijo', array('act_id'=>$id_activo));
        $fecha_inicio = (trim($registro[0]['act_fecha_inicia_dep']) != '')? formatear_fecha('Y-m-d',$registro[0]['act_fecha_inicia_dep']):date('Y-m-d');
        $dia_inicio = formatear_fecha('d',$fecha_inicio); 
        $years = ($registro[0]['act_vida_util']>0)? round($registro[0]['act_vida_util'],2):1;
        $ndias_inicio = 0;
        $extra_mes = 0;
        if(formatear_fecha('d', $fecha_inicio) != "01")
        {
            $q_ndias_inicio =  $this->db->select("DATEDIFF(LAST_DAY('$fecha_inicio'), '$fecha_inicio') dias_inicio", false)->get()->row_array();
            $ndias_inicio = $q_ndias_inicio["dias_inicio"]; // tomar en cuenta el dia de origen
            $fecha_f = $this->db->select("DATE_ADD('$fecha_inicio',INTERVAL $years YEAR ) fecha_fin", false)->get()->row_array();
            $fecha_fin    = formatear_fecha('Y-m-d', $fecha_f["fecha_fin"]);

            $qfecha_f = $this->db->select("DATE_ADD('$fecha_fin',INTERVAL 1 MONTH ) fecha_fin", false)->get()->row_array();
            $fecha_fin    = formatear_fecha('Y-m-d', $qfecha_f["fecha_fin"]);
            //print_r($qfecha_f); die();
            $extra_mes = 1;
        }
        else {
            $fecha_f = $this->db->select("DATE_ADD('$fecha_inicio',INTERVAL $years YEAR ) fecha_fin", false)->get()->row_array();
            $fecha_fin    = formatear_fecha('Y-m-d', $fecha_f["fecha_fin"]);
        }
        $this->activo_fijo->generar_simulacion( $id_activo,$extra_mes);
        //echo($ndias_inicio); die();
        $datos["ndias_inicio"] = $ndias_inicio;
        $slcAgrupar    =  $this->input->post('slcAgrupar');
        $result = $this->activo_fijo->get_datos_simulacion($id_activo, $fecha_inicio, $fecha_fin, $slcAgrupar );
       // print_r($this->db->last_query()); die();
        $result = ($result)? (array) json_decode($result):array();
        $datos['datos_simulacion'] = $result;
        $datos['gen_fecha_inicio'] = $fecha_inicio;
        $datos['gen_fecha_fin'] = $fecha_fin;
        $datos['slcAgrupar'] = $slcAgrupar;
        $datos['id_activo'] = $id_activo;
        $datos['reg_activo'] = $registro[0];
        $datos['es_reporte']=$es_reporte;
        $datos['info_act'] = $this->activo_fijo->get_info_total_activo(array('act_id'=> $id_activo));
        $datos['act_detalles'] = $this->activo_fijo->get_detalles_activo_completo($id_activo)->row();
        $datos['datos_activo'] = $datos['info_act'][0];
        $tipo_accion2 = ($es_reporte == 1)? 0:1; //0= pdf, diferente de 0 = excel
        $datos['es_excel'] = ($tipo_accion2)? true:false;
        $registro_asignacion = $this->activo_fijo->get_info_activo_asignacion(array('axe_id_act'=>$id_activo,'axe_estado'=>1));
        $datos['responsable'] = ($registro_asignacion)? $registro_asignacion[0]: array("emp_nombre"=>'',"emp_apellido"=>'');
        $datos['encargado_activo'] = explode(',', $this->gsatelite->get_parametro('SYS_ENCARGADO_ACTIVO_FIJO'));

        //print_r($datos['datos_simulacion']['message']); die();
        $html = $this->load->view('activo/nuevo/iniciar_simulacion_real', $datos, true);
        //print_r($result); die();
        $datos['periodo'] = (($fecha_inicio)?  'De: '.formatear_fecha('Y-m-d', $fecha_inicio):'') . (($fecha_fin)?  ' Hasta: '.formatear_fecha('Y-m-d', $fecha_fin):( ($result['response'] == 1)? ' Hasta: '.($result['message'][(count($result['message'])-1)]->ultima_fecha):''));
        if ($es_reporte) {
            $tipo_accion = ($this->input->post('tipo_accion'))? $this->input->post('tipo_accion'):$tipo_accion2;
            $filtro_titulo = ($fecha_inicio==$fecha_fin)? "De: ".date_format(date_create($fecha_inicio), 'd-m-Y'):"".$datos['periodo'];

            if ($tipo_accion) { //excel
                header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
                header("Content-Disposition: attachment;filename=simulacion_depreciacion".date('d-m-Y_His').".xls"); 
                header("Pragma: no-cache");
                header("Expires: 0");
                echo '<meta charset="utf-8" />';
                echo "<table border='0'>
                  <tr><th colspan='4' align='center' >".mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'),'UTF-8')."</th></tr>
                  <tr><th colspan='4' align='center' >Simulación de depreciación de Activo</th></tr>
                  <tr><th colspan='4' align='center' >".$filtro_titulo. "</th></tr>
                  </table>";
                echo $html; die();
            } else { //pdf
                ini_set( 'memory_limit', '2048M' );
                ini_set('max_execution_time', '9999');

                $this->load->library('pdf');
                $html_header=$this->load->view('reporte/header', array('titulo' => "Simulación - Tarjeta Individual de Activo Fijo", 'solotitulo'=> true), true); //<br /> $filtro_titulo
                $html = str_replace('border="1" style="margin-left: 4px; width: 99%; font-size:12px;"','border="0.5" style="width: 100%; font-size:9px;"',$html);
                $this->pdf->makePDF($html_header.$html,'P',''.'Letter');
               // $this->pdf->makePdf($reporte, 'L', 'Reporte_asignacion_activos', 'Letter');
                die();
            }
        }

        echo json_encode(array('html'=>$html, 'response'=>$result['response']));
        exit();
        
    }

    /**
     * @author Marlon olmedo
     * @since  12-09-2019
     * @return cantidad de activos fijos dependientes del detalle del documento proveedor
     * Descripcion: si la cantidad de activos fijos sea menor o igual 
    */

    public function validar_cantidad($act_id=null){

        $cantidad = $this->input->post('cantidad');

        $dxd_id = $this->gsatelite->get_campo('act_activo_fijo','act_id_dxd', array('act_id' => $act_id));

        $validar = $this->activo_fijo->validar_cantidades(array('act_id_dxd' => $dxd_id));
        //print_r($validar);die();
        if ($cantidad >= $validar[0]['dxd_cantidad']) {
            $cantidad_nueva = array('cantidad' => ($validar[0]['dxd_cantidad'] - $validar[0]['registros']) , 'rechazar' => 1);
            echo json_encode($cantidad_nueva);
        } else {
            $cantidad_nueva = array('rechazar' => 0);
            echo json_encode($cantidad_nueva);
        }
    }

    public function solicitud_traslado_empleado(){
        satelite_validar();
        if ($_POST) {
            $html = '';
            $where = array();
            $estado_permiso = (is_numeric($this->input->post('estado'))) ? $this->input->post('estado') : '';
            $fecha_ini = ($this->input->post('fecha_ini') != '') ? $this->input->post('fecha_ini') : '';
            $fecha_fin = ($this->input->post('fecha_fin') != '') ? $this->input->post('fecha_fin') : '';
            if(is_numeric($estado_permiso)) {
                $where['slt_estado'] = $estado_permiso;
            }
            if ($fecha_ini != '') {
                $where['DATE(slt_fecha_creacion) >= '] = formatear_fecha('Y-m-d', $fecha_ini);
            }
            if($fecha_fin != ''){
                $where['DATE(slt_fecha_creacion) <= '] = formatear_fecha('Y-m-d', $fecha_fin);
            }

            $user_id = $this->tank_auth->get_user_id();
            if ($user_id > 0) {
                $where['slt_usu_creacion'] = $user_id;
            }

            $where['slt_tipo_solicitud'] = 1;
                                    $this->db->join('emp_empleado', 'emp_id = slt_id_emp');
                                    $this->db->join('users', 'id = slt_usu_creacion');
            $data['asignaciones'] = $this->gsatelite->get_tabla('slt_solicitud_activos', $where);
            $html = $this->load->view('activo/nuevo/detalle_traslado_pendientes_empleado', $data, true);            
            echo $html;
            die();
        } else {
            $data['titulo_personal'] = "Gestión de Asignaciones";

            // Consultar empleado para acta de asignacion
            $usuario_id = $this->tank_auth->get_user_id();
                        $this->db->join('users', 'usu_id_emp = emp_id');
                        $this->db->join('are_area', 'emp_id_are = are_id');
            $empleado = $this->gsatelite->get_tabla('emp_empleado', ['id' => $usuario_id]);
            $emp_id = (count($empleado) > 0) ? $empleado[0]['emp_id'] : 0;
            $data['emp_id'] = $emp_id;

            $where['emp_id'] = $emp_id;
            $where['axe_estado'] = 1;
            $detalles = $this->activo_fijo->get_reporte_asignacion($where);
            $data['detalles'] = $detalles;
            $this->_cargarvista($data);
        }        
    }  

    public function ver_activos_trs_empleado(){
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if($_POST){
                $area  = ($this->input->post('are_id')!='')?$this->input->post('are_id'):null;
                $emp_id  = $this->input->post('emp_id');
                $usados= ($this->input->post('asig')!='')?$this->input->post('asig'):null;
                $data['used'] = $used=explode(',', $usados);

                $rol_administrador = $this->gsatelite->get_parametro_emp('ADMINISTRADOR_TRASLADOS_AF', 0);
                $rol_administrador_array = explode(",", $rol_administrador);
                        $this->db->join("uxr_usuarioxrol", "uxr_id_usu = id");
                $rolu = $this->gsatelite->get_tabla("users", array("id" => $this->tank_auth->get_user_id()));
                foreach ($rolu as $k => $val) {
                    if (in_array($val['uxr_id_rol'], $rol_administrador_array)) {
                        $area = null;
                    }            
                }
                //Verifica que los activos no esten en otra solicitud
                $data['activos']= $activos =$this->activo_fijo->activoxarea_trs_empleado($area, $emp_id, $usados);
                // die(print_r($this->db->last_query()));
                $html = $this->load->view('activo/nuevo/activosxasignar', $data, true);
                echo $html;
            }else{

                // Precargar el empleado del usuario en sesion
                $usuario_id = $this->tank_auth->get_user_id();
                            $this->db->join('users', 'usu_id_emp = emp_id');
                            $this->db->join('are_area', 'emp_id_are = are_id');
                $empleado = $this->gsatelite->get_tabla('emp_empleado', ['id' => $usuario_id]);

                if(empty($empleado)) {
                    // El usuario debe tener area y empleado asignado al usuario
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Solicitud traslado", 'texto_alerta' => "Debe tener empleado y area asociado a su usuario");
                    $this->session->set_flashdata($alerta);                    
                    redirect("activo/nuevo/solicitud_traslado_empleado");

                }

                // Obtener area actual
                $areas = $this->gsatelite->get_dropdown('are_area', '{are_prefijo} {are_nombre}', '', array('are_estado' => 1, 'are_id' => $empleado[0]['emp_id_are']), $empleado[0]['emp_id_are'], null, 'are_id', true);

                $data['areas_origen'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $areas);

                // Obtener destino
                $areas = $this->gsatelite->get_dropdown('are_area', '{are_prefijo} {are_nombre}', '', array('are_estado' => 1), '', null, 'are_id', true);

                $data['areas'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $areas);                

                // Obtener empleado
                $empleados = $this->gsatelite->get_dropdown('emp_empleado', '{emp_nombre} {emp_apellido}', '', array('emp_estado' => 1, 'emp_id' => $empleado[0]['emp_id']), $empleado[0]['emp_id'], null, 'emp_id', true);
                $data['empleados'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $empleados);

                $data['titulo_personal'] = "Traslado de activo fijo";
                $this->_cargarvista($data);
            }
        }
    }

    public function save_traslado_empleado(){
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            // die(var_dump($_POST));
            $counter = 0;
            $preview = $this->input->post('ids_selected');
            $acts_ids = explode(",", $preview[0]); //Se hiz porque ahora son mas activos que los que se mandan en checkbox
            $areas_to_send = $this->input->post('acts_selected'); //Areas que se enviaran en el form en la parte inferior al momento q sale el toaste se envian
            $emps_to_send  = $preview[0]; //Ids de empleados que se envian al momento de guardar y se mandan al momento q se da en generar reporte en el toast
            $activos       = $acts_ids;
            $emp_id_origen = $this->input->post('origen_emp');
            $other = $this->input->post("acts_selected");
            $emps_ids_origens = explode(",", $other);
            $area           = $this->input->post('area');
            $obs            = $this->input->post('obs');
            $emp_id_destino = $this->input->post('emp_id');
            $usu_id         = $this->tank_auth->get_user_id();
            $fecha     = (trim($this->input->post('fecha_ad'))!='') ? formatear_fecha("Y-m-d",$this->input->post('fecha_ad')) : date('Y-m-d');
            $tipo_movimiento = ($this->input->post('slc_tipo_movimiento')!= null) ? $this->input->post('slc_tipo_movimiento') : 1;


            $nuevo_ids = array();
            if( is_array($activos) && ( $emp_id_origen || $area ) ){
                $tipo_flujo = $this->gsatelite->get_parametro_emp('SYS_ASIGNAR_AUTORIZAR_AF');
                if ($tipo_flujo > 0) {
                    $sucid = $this->gsatelite->get_campo('are_area','are_id_suc',array('are_id' => $area));
                    $solicitud = array(
                        'slt_id_emp' => $emp_id_destino,
                        'slt_id_are' => $area,
                        'slt_id_suc' => ($sucid > 0)?$sucid:null,
                        'slt_fecha' => $fecha . ' ' . date('H:i:s'),
                        'slt_tipo_solicitud' => 1,
                        'slt_tipo_movimiento' => $tipo_movimiento,                        
                        'slt_id_emp_origen' => $emp_id_origen,
                        'slt_estado' => 1,
                        'slt_usu_creacion' => $this->tank_auth->get_user_id(),
                        'slt_usu_modifica' => $this->tank_auth->get_user_id(),
                        'slt_fecha_creacion' => date('Y-m-d H:i:s'),
                        'slt_fecha_modifica'  => date('Y-m-d H:i:s')
                    );
                    $nuevo = $this->gsatelite->ingresar('slt_solicitud_activos', $solicitud);
                    foreach ($activos as $k => $va) {
                        $activoSolic = array(
                            'axs_id_act' => $va,
                            'axs_id_slt' => $nuevo,
                            'axs_estado' => 1,
                            'axs_fecha_cre' => date('Y-m-d H:i:s'),
                            'axs_usu_crea' => $this->tank_auth->get_user_id(),
                            'azs_usu_modifica' => $this->tank_auth->get_user_id(),
                            'axs_fecha_modifica' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('axs_activo_solicitud', $activoSolic);
                    }
                    if($nuevo>0){
                        // Notificar por correo
                        $this->notificacion_correo($nuevo);                                                  
                        $texto_mensaje = "Registros guardados correctamente<br>Pendiente de aprobación";
                        $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Proceso realizado", 'texto_alerta' => $texto_mensaje);
                    } else {
                        $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error de inserción", 'texto_alerta' => "No se pudo realizar la operación");
                    }
                } else {                    
                    $datos_generar_reporte= array();
                    for ($i = 0 ; $i < count($activos) ; $i++) {
                        $data_update=array(
                            'axe_estado'=> 0,
                            'axe_use_mod'=> $usu_id,
                            'axe_fecha_mod'=>date('Y-m-d H:i:s')
                        );
                                $this->db->where('axe_id_act',$activos[$i]);
                                $this->db->where('axe_id_emp', $emps_ids_origens[$i]);
                                $this->db->where('axe_estado',1);
                        $nuevo= $this->db->update('axe_activoxempleado',$data_update);

                        $data_insert = array(
                            'axe_id_act'=>$activos[$i],
                            'axe_id_emp'=>$emp_id_destino,
                            'axe_id_are'=>$area,
                            'axe_obs'=>$obs,
                            'axe_fecha'=>($fecha .' '. date('H:i:s')),
                            'axe_estado'=>1,
                            'axe_use_mod'=>$this->tank_auth->get_user_id(),
                            'axe_fecha_mod'=>date('Y:m:d H:i:s')
                        );
                        $nuevo = $this->gsatelite->ingresar('axe_activoxempleado',$data_insert);
                        $datos_generar_reporte[] = $nuevo."==".$activos[$i]."/".(int)$emp_id_origen; 
                        $nuevo_ids[] = $nuevo;  
                        $counter++;
                    }
                    /*
                    $datos_generar_reporte= array();
                    foreach ($activos as $activo) {
                        $data_update=array(
                          'axe_estado'=> 0,
                          'axe_use_mod'=> $usu_id,
                          'axe_fecha_mod'=>date('Y-m-d H:i:s'));
                        $this->db->where('axe_id_act',$activo);
                        $this->db->where('axe_id_emp', $emp_id_origen);
                        $this->db->where('axe_estado',1);
                        $nuevo= $this->db->update('axe_activoxempleado',$data_update);
                        $data_insert=array('axe_id_act'=>$activo,
                            'axe_id_emp'=>$emp_id_destino,
                            'axe_id_are'=>$area,
                            'axe_obs'=>$obs,
                            'axe_fecha'=>date('Y-m-d H:i:s'),
                            'axe_estado'=>1,
                            'axe_use_mod'=>$this->tank_auth->get_user_id(),
                            'axe_fecha_mod'=>date('Y:m:d H:i:s'));
                        //$nuevo=$this->db->insert('axe_activoxempleado',$data_insert);   
                        $nuevo = $this->gsatelite->ingresar('axe_activoxempleado',$data_insert);
                        $datos_generar_reporte[] = $nuevo."==".$activo."/".(int)$emp_id_origen; 
                        $nuevo_ids[] = $nuevo;  
                        $counter++;
                    }
                    */
                    if($nuevo>0){
                        $formulario = '<a href="#" style="color:blue;" onclick="generar_reporte();" ><b>Generar Reporte</b></a>';
                        $this->session->set_flashdata('datos_generar_reporte',implode('##',$datos_generar_reporte));
                        $this->session->set_flashdata('send_areas', (count($areas_to_send) > 1) ? $areas_to_send[0] : $areas_to_send);
                        $this->session->set_flashdata('send_emps', (count($emps_to_send) > 1) ? $emps_to_send[0] : $emps_to_send);
                        $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Proceso realizado", 'texto_alerta' => "Registros guardados correctamente $formulario ");
                    } else {
                        $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Error de inserción", 'texto_alerta' => "No se pudo realizar la operación");
                    }
                    //============================================================================
                    // INICIO -   LUEGO DEL TRASLADO ACTUALIZAR EL CÓDIGO DE LOS ACTIVOS SI APLICA add by René Castaneda
                    //============================================================================
                    $actualiza = $this->gsatelite->get_parametro('SYS_CONFIGURACION_CODIGO_ACTIVO', null, false, array('ACTUALIZAR_TRASLADOS'));
                    if ($actualiza > 0) {
                        $this->activo_fijo->actualizar_codigo_area_activo($nuevo_ids);
                    } else {
                        if (count($nuevo_ids) > 0) {
                            $this->db->where_in("axe_id", $nuevo_ids);
                            $a_movido = $this->gsatelite->get_tabla("axe_activoxempleado");
                            if (count($a_movido) > 0) {
                                foreach ($a_movido as $k => $val) {
                                    $actualiza = array(
                                        "act_id_are" => $val["axe_id_are"],
                                        "act_usu_modificacion" => $this->tank_auth->get_user_id(),
                                        "act_fecha_modificacion" => date("Y-m-d H:i:s")
                                    );
                                    $resp = $this->gsatelite->actualizar_array('act_activo_fijo', $actualiza, array('act_id' => $val["axe_id_act"]));
                                }
                            }
                        }        
                    }                
                    //==========================================================================
                    //   FIN - LUEGO DEL TRASLADO ACTUALIZAR EL CÓDIGO DE LOS ACTIVOS SI APLICA add by René Castaneda
                    //==========================================================================
                }
                $this->session->set_flashdata($alerta);
                $volver = $this->input->post('volver');
                if($volver > 0){
                    redirect("activo/nuevo/solicitud_traslado_empleado");
                }else{
                    redirect("activo/nuevo/ver_activos_trs_empleado");
                }
            }else{
                $this->gsatelite->show_dialog('Los activos no fueron trasladados.', 'activo/nuevo/ver_activos_trs', 'error');
            }
        }
    }    

    public function sincronizarEmpleadosSinco($id_empleado_sinco = null){
        satelite_validar();
        $respuesta['exito'] = 0;  

        if (!extension_loaded('sqlsrv')) {
            log_message('error', 'No esta instalado driver sqlsrv');
            $respuesta['msj'] = 'No esta instalado driver sqlsrv';
            return $respuesta;    
        }            

        $this->load->model('sqlserver_model');

        if (!$this->sqlserver_model->check_connection()) {
            log_message('error', 'No se logro conectar a la base MSSQL');
            $respuesta['msj'] = 'No se logro conectar a la base MSSQL';
            return $respuesta;  
        }

        // Verificar si existen parametros para crear usuario SINCO
        $rolUsuarioSinco = $this->gsatelite->get_parametro('SYS_ROL_USUARIO_SINCO');
        $usuarioCreacion = $this->gsatelite->get_parametro('SYS_USU_CREACION_USUARIO_SINCO');

        if ($rolUsuarioSinco == "" && $usuarioCreacion == "") {
            log_message('error', 'No existe parametro para usuario creacion y rol por defecto para crear usuario SINCO');
            $respuesta['msj'] = 'No existe parametro para usuario creacion y rol por defecto para crear usuario SINCO';
            return $respuesta;              
        }
        
        $empleadosSinco = $this->sqlserver_model->getEmpleadosSinco($id_empleado_sinco);
        $empleados = $this->gsatelite->get_tabla('emp_empleado');
        $areas = $this->gsatelite->get_tabla('are_area', ['are_estado' => 1]);

        $emp_codigo = array_filter(array_column($empleados, 'emp_codigo'));

        // Organizar áreas por prefijo para hacer la búsqueda más eficiente
        $areasPorPrefijo = [];
        foreach ($areas as $area) {
            $areasPorPrefijo[$area['are_prefijo']] = $area;
        }   

        $empleadosInsertados = [];

        $count = 0;      

        $this->db->trans_begin();

        try {
            foreach ($empleadosSinco as $empleadoSinco) {
                if (in_array($empleadoSinco['IDEMPLEADO'], $emp_codigo)) {
                    // Si ya existe el empleado, continuar al siguiente
                    continue;
                }

                // Buscar área por prefijo
                $codigoArea = $empleadoSinco['IDSUBDIRECCION'];
                if (!isset($areasPorPrefijo[$codigoArea])) {
                    log_message('error', "No existe el area con prefijo: {$codigoArea} en el ERP para el empleado {$empleadoSinco['IDEMPLEADO']}");
                    continue; // Si no existe el área, saltar este empleado
                }       

                $areaSinco = $areasPorPrefijo[$codigoArea];
                
                $insert = [
                    'emp_codigo' => $empleadoSinco['IDEMPLEADO'],
                    'emp_nombre' => $empleadoSinco['NOMBREEMPLEADO'],
                    'emp_apellido' => $empleadoSinco['APELLIDOEMPLEADO'],
                    'emp_email' => $empleadoSinco['CORREO'],
                    'emp_id_are' => $areaSinco['are_id'],
                    'emp_id_suc' => $areaSinco['are_id_suc'],
                    'emp_estado' => 1,
                    'emp_fecha_mod' => date('Y-m-d H:i:s'),
                    'emp_fecha_crea' => date('Y-m-d H:i:s'),
                    'emp_usu_mod' => $usuarioCreacion,
                    'emp_usu_crea' => $usuarioCreacion,
                ];

                $emp_id = $this->gsatelite->ingresar('emp_empleado', $insert);
                if (!$emp_id) {
                    // Si hubo un error en la inserción, continuar con siguiente empleado
                    log_message('error', "No se pudo crear empleado con ID {$empleadoSinco['IDEMPLEADO']}");                
                    continue;
                }            
                
                // Obtener nombre de usuario
                $nombreUsuario = strstr($empleadoSinco['CORREO'], '@', true);

                // Crear contraseña
                $hasher = new PasswordHash(
                $this->config->item('phpass_hash_strength', 'tank_auth'), $this->config->item('phpass_hash_portable', 'tank_auth'));

                // Crear usuario 
                $hashed_password = $hasher->HashPassword(strtolower($nombreUsuario));   

                $usuario_insert = [
                    'username' => $nombreUsuario,
                    'password' => $hashed_password,
                    'email' => $empleadoSinco['CORREO'],
                    'activated' => 1,
                    'banned' => 0,
                    'last_login' => date('Y-m-d H:i:s'),
                    'created' => date('Y-m-d H:i:s'),
                    'modified' => date('Y-m-d H:i:s'),
                    'usu_id_emp' => $emp_id,
                ];
                $id = $this->gsatelite->ingresar('users', $usuario_insert);
                $this->gsatelite->actualizar_array('emp_empleado', ['emp_id_usu' => $id], ['emp_id' => $emp_id]);

                $uxr_usuarioxrol = [
                    'uxr_id_usu' => $id,
                    'uxr_id_rol' => $rolUsuarioSinco
                ];
                
                $this->gsatelite->ingresar('uxr_usuarioxrol', $uxr_usuarioxrol);
                $empleadosInsertados[] = $empleadoSinco['IDEMPLEADO'];
                $count++;
            }

            if ($this->db->trans_status() === FALSE) {
                throw new Exception("La transacción no fue completada correctamente.");
            } else {
                $this->db->trans_commit();
                foreach ($empleadosInsertados as $key => $empleadoUpdate) {
                    $this->sqlserver_model->actualizarEmpleadoMigrado($empleadoUpdate);
                }

            }          
        } catch (Exception $e) {
            $count = 0;
            $this->db->trans_rollback();
            log_message('error', "No se pudo crear empleado con ID {$empleadoSinco['IDEMPLEADO']}");                
            log_message('error', "Error: {$e->getMessage()}");                
        }  

        $respuesta['exito'] = 1;
        $respuesta['msj'] =  "Usuarios creados: {$count}";
        return $respuesta;
    } 

    public function notificacion_correo($slt_id){
        satelite_validar();
        $respuesta['exito'] = 0;
        $solicitud = $this->gsatelite->get_tabla('slt_solicitud_activos', ['slt_id'=>$slt_id]);

        if(!$solicitud) {
            $respuesta['msj'] = 'Registro no valido.';
            return $respuesta;
        }

        $solicitud = $solicitud[0];

        if($solicitud['slt_tipo_solicitud'] != 1) {
            $respuesta['msj'] = 'Notificación aplica solo a traslado.';
            return $respuesta;
        }    

        $correos = [];

        // Enviar correo a empleado responsable actual y anterior 
                    $this->db->join('emp_empleado', 'emp_id = usu_id_emp');
        $emp_empleado = $this->gsatelite->get_tabla('users', ['emp_id' => $solicitud['slt_id_emp_origen']]);

                    $this->db->join('emp_empleado', 'emp_id = usu_id_emp');
        $emp_empleado_recibe = $this->gsatelite->get_tabla('users', ['emp_id' => $solicitud['slt_id_emp']]);

        
        if ($solicitud['slt_estado'] != 1) {
            // El estado es aprobado o rechazado se le notifica al creador de la solicitud
            if (count($emp_empleado) > 0) {
                $correos[] = trim($emp_empleado[0]['email']);
            }

            if (count($emp_empleado_recibe) > 0) {
                $correos[] = trim($emp_empleado_recibe[0]['email']);
            }
        } else {
            // Obtener email de jefe de area
            if (extension_loaded('sqlsrv')) {            
                $this->load->model('sqlserver_model');
                // Verificar si tenemos conexion a sqlserver
                if ($this->sqlserver_model->check_connection()) {
                    $area = $this->gsatelite->get_tabla('are_area', ['are_id' => $emp_empleado[0]['emp_id_are']]);
                    $are_prefijo = (count($area) > 0) ? $area[0]['are_prefijo'] : 0;
                    $jefe_area = $this->sqlserver_model->getJefeArea($are_prefijo);
                    if (count($jefe_area) > 0) {
                        $correos[] = trim($jefe_area[0]['CORREO']);
                    }
                } else {
                    log_message('error', 'No se logro conectar a la base MSSQL');
                    $respuesta['msj'] = 'No se logro conectar a la base MSSQL';
                    return $respuesta;                    

                }
            } else {
                log_message('error', 'No esta instalado el driver sqlsrv');
                $respuesta['msj'] = 'No esta instalado el driver sqlsrv';
                return $respuesta;                    

            }                
        }

        if(count($correos) == 0) {
            $respuesta['msj'] = 'Sin correos configurados';
            return $respuesta;
        }

        $empleado_recibe = $this->gsatelite->get_tabla('emp_empleado', ['emp_id' => $solicitud['slt_id_emp']]);
        $emp_nombre_recibe = (count($empleado_recibe) > 0) ? $empleado_recibe[0]['emp_nombre'].' '.$empleado_recibe[0]['emp_apellido'] : '-';

        $reg_pdte = $this->activo_fijo->lista_pdte_asignar($slt_id);   

        $table_html = '<table border="1" style="border-collapse:collapse;" width="100%" >';
        $table_html .= '<thead>';
        $table_html .= '<tr style="background-color: #a0c0dc;">';
        $table_html .= '<th align="center">Código</th>';
        $table_html .= '<th align="center">Nombre Activo</th>';
        $table_html .= '</tr>';
        $table_html .= '</thead>';
        $table_html .= '<tbody>';
        foreach ($reg_pdte as $key => $registro) {
            $table_html .= '<tr>';
            $table_html .= "<td>${registro['act_codigo']}</td>";
            $table_html .= "<td>${registro['act_nombre']}</td>";
            $table_html .= '</tr>';
        }
        $table_html .= '</tbody>';
        $table_html .= '</table>';

        $para = $correos;
        $mensaje = '<h4>Notificación - Solicitud de traslado Activo Fijo </h4>';

        if (ENVIRONMENT == "development") {
            $mensaje .= '<h3>Correo ambiente de prueba</h3><br />';
        }

        $mensaje .= $table_html;  
        $mensaje .= '<br />';  
        $mensaje .= '<p>Responsable entrega: ' . $emp_empleado[0]['emp_nombre'].' '.$emp_empleado[0]['emp_apellido']. '</p>';
        $mensaje .= '<p>Responsable recibe: ' . $emp_nombre_recibe. '</p>';
        $mensaje .= '<p>Fecha solicitud: ' . formatear_fecha('d-m-Y', $solicitud['slt_fecha_creacion']). '</p>';

        if ($solicitud['slt_estado'] != 1) {
            $mensaje .= '<p>Estado: ' . (($solicitud['slt_estado'] == 2) ? 'Aprobado' : 'Rechazado') .'</p>';
        }
        
        $mensaje .= '<p>Observaciones: ' . $solicitud['slt_observacion'] . '</p>';

        $anexoAdjunto = null;
        if ($solicitud['slt_estado'] == 2) {
            $rutaAnexoActaTrasladoSolicitud = $this->acta_traslado_solicitud($slt_id, true);
            if (file_exists($rutaAnexoActaTrasladoSolicitud)) {
                $anexoAdjunto = $rutaAnexoActaTrasladoSolicitud;
            } 
        }

        $mensaje .= '<hr /><p style="font-size:12px;"><b>Nota:</b> Correo enviado de forma automática, favor no responder. <br />' . date('d-m-Y H:i:s') . '</p>';

        $enviarCorreo = $this->gsatelite->envio_correo_v2("notificacion@defensoria.gob.sv", "Defensoría del consumidor", $para, "Notificación solicitud traslado", $mensaje, null, $anexoAdjunto, true);


        $respuesta['exito'] = $enviarCorreo;
        $respuesta['msj'] =  ($enviarCorreo)? 'Notificación enviado con éxito':'Error al enviar notificación';

        if (file_exists($rutaAnexoActaTrasladoSolicitud)) {
            unlink($anexoAdjunto);
        }         
        
        return $respuesta;
    }

    public function sincronizar_empleados($id_empleado_sinco = null){
        satelite_validar();
        die(json_encode($this->sincronizarEmpleadosSinco($id_empleado_sinco), \JSON_UNESCAPED_UNICODE));
    }

    public function sendNotificacionSolicitud($id = 0)
    {
        satelite_validar();
        die(json_encode($this->notificacion_correo($id), \JSON_UNESCAPED_UNICODE));
    } 

    function acta_traslado_solicitud($slt_id, $return = false){
        satelite_validar();

        // Obtener solicitud
        $solicitud = $this->gsatelite->get_tabla('slt_solicitud_activos', ['slt_id' => $slt_id]);
        $solicitud = $solicitud[0];

        // Obtener activo y luego asignarle caracteristicas 
                    $this->db->join('act_activo_fijo', 'act_id = axs_id_act');
        $activos = $this->gsatelite->get_tabla('axs_activo_solicitud', ['axs_id_slt' => $slt_id]);

        foreach($activos as $key => $activo) {
            $caracteristicas = $this->activo_fijo->get_caracteristicaxactivo($activo['act_id']);
            $str_caracteristicas = null;
            
            foreach ($caracteristicas as $value) {
                $str_caracteristicas .= "{$value['car_nombre']}: {$value['cxc_valor']}; ";
            }

            $str_caracteristicas = rtrim($str_caracteristicas, "; ");
            $activos[$key]['caracteristicas'] = $str_caracteristicas;
        }

        // Obtener sucursal empleado que crea la solicitud para obtener municipio y distrito
        // Del empleado que tenia anteriormente el activo se estara obteniendo el empleado
                                $this->db->join('are_area', 'are_id = emp_id_are', 'LEFT');
        $emp_empleado_origen = $this->gsatelite->get_tabla('emp_empleado', ['emp_id' => $solicitud['slt_id_emp_origen']]);

                                $this->db->join('are_area', 'are_id = emp_id_are', 'LEFT');
        $emp_empleado_recibe = $this->gsatelite->get_tabla('emp_empleado', ['emp_id' => $solicitud['slt_id_emp']]); 

        $data['solicitud'] = $solicitud;
        $data['activos'] = $activos;
        $data['emp_empleado_origen'] = $emp_empleado_origen;
        $data['emp_empleado_recibe'] = $emp_empleado_recibe;

        // Valor para mostrar lugar donde se extiende la presente
        $oficina = '';
        if (count($emp_empleado_origen) > 0) {
                        $this->db->join('dis_distrito', 'suc_id_dis = dis_id');
                        $this->db->join('mun_municipio', 'suc_id_mun = mun_id');
            $sucursal = $this->gsatelite->get_tabla('suc_sucursal', ['suc_id' => $emp_empleado_origen[0]['emp_id_suc']]);
            if (!empty($sucursal)) {
                $oficina = "{$sucursal[0]['mun_nombre']}, {$sucursal[0]['dis_nombre']}";
            }

        }
        $data['oficina'] = $oficina;

        $this->load->model('sqlserver_model');

        $puesto_responsable_actual = null;
        $puesto_responsable_recibe = null;

        // Verificación de la extensión y conexión
        if (extension_loaded('sqlsrv') && $this->sqlserver_model->check_connection()) {

            // Obtener datos del empleado actual
            if (!empty($emp_empleado_origen)) {
                $empleado_actual = $this->sqlserver_model->getEmpleadosSinco($emp_empleado_origen[0]['emp_codigo']);
                if (!empty($empleado_actual)) {
                    $puesto_responsable_actual = $empleado_actual[0]['NOMBREPUESTO'];
                }
            }

            // Obtener datos del empleado que recibe de la solicitud de activo
            if (!empty($emp_empleado_recibe)) {
                $empleado_recibe = $this->sqlserver_model->getEmpleadosSinco($emp_empleado_recibe[0]['emp_codigo']);
                if (!empty($empleado_recibe)) {
                    $puesto_responsable_recibe = $empleado_recibe[0]['NOMBREPUESTO'];
                }
            }
        }            
        $data['puesto_responsable_actual'] = $puesto_responsable_actual;
        $data['puesto_responsable_recibe'] = $puesto_responsable_recibe;

        $reporte = $this->load->view('activo/nuevo/acta_traslado_defensoria', $data, true);
        $ruta = FCPATH . "public/temp/activos/acta_traslado_solicitud/";
        $rutaArchivo = $ruta . 'Formato de Movimiento de Activos Fijos' . uniqid('_');

        if ($return) {
            $GLOBALS['nombre_reporte'] = $rutaArchivo;
            $this->pdf->makePdf2($reporte, 'P', 'de_movimiento', 'Letter', 'F'); 
            return $rutaArchivo . '.pdf';                       
        } else {
            $GLOBALS['nombre_reporte'] = 'Formato de Movimiento de Activos Fijos' . date('dmY');
            $this->pdf->makePdf($reporte, 'P', 'de_movimiento', 'Letter');                        
        }

    }

    public function dar_codigo_migracion($code_actual = "") {
        $hechas = 0;
        $activos = $this->gsatelite->get_tabla("act_activo_fijo", array("act_codigo RLIKE '$code_actual'" => NULL));
        if (count($activos) > 0) {
            foreach ($activos as $k => $v) {
                $new_code = $this->generar_codigo_administrativo($v['act_id']);
                if (count($new_code) > 0) {
                    $this->gsatelite->actualizar_array('act_activo_fijo',array('act_codigo'=>$new_code['codigo']), array('act_id'=>$v['act_id']));
                    $hechas++;
                }
            }
        }
        echo "Se procesaron " . $hechas;
    }
    
}

/* End of file nuevo.php */
/* Location: ./application/controllers/nuevo.php */