<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Editar extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->model('activo_fijo');
        $this->load->model('gsatelite');
        $this->load->library('grocery_crud');
        $this->load->library('session');
    }
    
    /**
     * Registro de Activo Fijo - Pantalla Principal
     * @return get pantalla de registro de activo fijo
     */
    public function index($id_activo=0)
    {
        //Verificar Permisos de acceso
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $crud = new grocery_crud();

            $displays= array(
                'act_id_tac'=>'Clasificación de activo',
                'act_id_grp'=>'Sub Clasificación activo',
                'act_id_tad'=>'Tipo de adquisición',
                'act_correlativo'=>'Comentarios',
                'act_codigo'=>'Código',
                'act_nombre'=>'Nombre',
                'act_valor_compra'=>'Valor de compra',
                'act_valor_dep'=>'Porcentaje de depreciación anual',
                'act_valor_cont'=>'Valor contable',
                'act_correlativo'=>'Correlativo'
                );

            $fields_edit= array(
                'act_id_tac',
                'act_id_grp',
                'act_id_tad',
                'act_correlativo',
                'act_codigo',
                'act_nombre',
                'act_valor_compra',
                'act_valor_cont',
                'act_valor_dep',
                'act_usu_mod',
                'act_fecha_mod'
                );
             $fields_colums= array(
                'act_id_tac',
                'act_id_grp',
                'act_id_tad',
                'act_correlativo',
                'act_codigo',
                'act_nombre',
                'act_valor_compra',
                'act_valor_cont',
                'act_valor_dep'
                );

            //$fields_edit=array_merge(array('cam_fecha_mod','cam_usu_mod','cam_id'),$columnas,array('cam_comentario','cam_id_reg'));

            //Obtiendo el parametro de edicion de la URL
            //$campana_id = explode("/", $_SERVER['REQUEST_URI']);
            //echo end($parts);

                $crud->set_table('act_activo_fijo')//Info general del crud
                ->set_subject('Activos')//Titulo del crud tabla
                ->columns($fields_colums)
                ->required_fields('act_codigo','act_nombre','act_valor_compra','act_valor_dep','act_estado')
                ->set_rules('act_codigo','Código','required|trim|xss_clean')
                ->unset_delete()
                ->unset_add()
                ->unset_export()
                ->set_relation('act_id_tac','tac_tipo_activofijo','tac_nombre')
                ->set_relation('act_id_tad','tad_tipo_adquisicion','tad_nombre')
                ->set_relation('act_id_grp','grp_grupo','grp_nombre')
                ->field_type("act_fecha_mod","hidden",date("Y-m-d H:i:s"))
                ->field_type("act_usu_mod","hidden",$this->tank_auth->get_user_id())

                ->display_as($displays)//Titulos de campos
                //->columns($columnas);//Columnas ON Select

                //->add_fields($fields_add)//Campos ON Insert
                ->edit_fields($fields_edit);//Campos ON Update

                
                //->field_type('cam_fecha', 'hidden', date('Y-m-d'))//Fecha de ingreso al sistema
                //->field_type('cam_fecha_mod', 'hidden', date('Y-m-d'))//Fecha de ultima modificacion
                
                //->field_type('act_id_tac','dropdown',array('1' => 'active', '2' => 'private'))//Definiendo el tipo de dato para campaña
                //->field_type('act_id_tad', 'dropdown',array('1' => 'active', '2' => 'private'))//Usuario que lo solicito
                //->field_type('act_id_grp', 'dropdown',array('1' => 'active', '2' => 'private'));//Fecha de ingreso al sistema

                //->set_relation('cam_id_reg', 'reg_region', 'reg_nombre')
                //Relacion foranea de cam_id_suc: 1]Sucursal-> M]Campanas

               /* ->set_rules('cam_inicial', 'campo inicial', 'required|exact_length[3]')
                
                ->callback_before_insert(array($this,'_verificar_fechas'))
                ->callback_before_update(array($this,'_verificar_fechas'))
                ->callback_add_field('cam_estado',array($this,'add_field_callback_estado'))

                ->add_action('Cambiar Estado', '', 'campana/campana/estado/ini',' icomoon-icon-flag-2')

                ->field_type('cam_id_reg','dropdown', $dropdown)
                 //Observa las reglas de fechas anteriores*/
                 
                //->unset_delete();
                
                $data['titulo_personal'] = 'Activos'; //Titulo modificable

                //Extrae el elemento cam_comentario como requerido
                /*array_pop($fields_edit);
                array_pop($fields_edit);
                

                $crud->required_fields(array_merge($fields_edit,array('cam_id_reg')));*/
                $crud->callback_before_update(function($post_array,$primary_key){
                        //VERIFICAR QUE NO EXISTA EL CODIGO INSERTADO
                        if(count($this->gsatelite->get_registro("act_activo_fijo", null,null, array('act_codigo' => $post_array['act_codigo'], 'act_id !=' => $primary_key ))) > 0 ){
                            return false;
                        }

                    });
                $crud->set_lang_string('update_error','Error!\nFavor Verificar lo Siguiente:\n\n*El Código no puede estar repetido. ');
                     
                $output = $crud->render();

               $this->_cargarvista($data,$output);
        }   
    }
    
    function _check_proyectos()
    {
        if( $this->input->post('act_proyecto') ){
            return ( $this->input->post('act_proyecto') > 0 );
        }
        return false;
    }
    
    function check_saf($valores = 0, $return_ids = false)
    {
        if(!$valores){ $valores = $this->input->get_post('act_correlativo'); }
        $data = explode(',', $valores);
        $correlativos = array();
        foreach($data as $row){
            if( strlen($row)>0 && is_numeric($row) && $row > 0 ){
                $correlativos[] = $row;
            }
        }
        $this->db->select('Group_Concat(act_correlativo) as ids');
        $this->db->where_in('act_correlativo', $correlativos);
        $very_corre = $this->db->get('act_activo_fijo')->row();
        if($return_ids){
            return $very_corre->ids;
        }else{
            return !( $very_corre && $very_corre->ids );
        }
    }

    /**
     * Registro de Activo Fijo - Registrar Nuevo Activo Fijo
     */
    public function registrar()
    { 
        extract($_POST);
        //verificar tipo de insercion (Singular | Lotes)
        $cantidad = ( isset( $act_cantidad ) && $act_cantidad != "" && isset( $act_lotes ) ) 
                    ? $act_cantidad 
                    : 1;
        //Calcular el valor contable
        $act_valor_cont = $act_valor_compra - ($act_porcentaje_dep * $act_valor_compra );
        
        //valore de correlativos
        $data = explode(',', $act_correlativo);
        $correlativos = array();
        foreach($data as $row){
            if( strlen($row)>0 && is_numeric($row) && $row > 0 ){
                $correlativos[] = $row;
            }
        }
        $act_correlativo    = $correlativos[0];
        
        //validamos si los correlativos no estan en base
        $ids = $this->check_saf(0, true);
        if( $ids ){
            $this->gsatelite->show_dialog('Los siguientes Codigos SAF ya se encuentran en la DB.' . $ids , 'activo/nuevo', 'error');
        }
        
        $unicos = array();
        foreach( $carac as $ind => $car ){
            $valores = explode(',', $car);
            if( is_array($valores) && count($valores) == $cantidad ){
                $unicos[ $ind ] = $valores;
            }
        }

        $activo_fijo = array(
            'act_id_tac'          => $act_tipo_activo,
            'act_id_grp'          => $act_grupo,
            'act_id_tad'          => $act_tipo_adq,
            'act_codigo'          => $act_codigo,
            'act_correlativo'     => $act_correlativo,
            'act_nombre'          => $act_nombre,
            'act_fecha_act'       => $act_fecha_compra,
            'act_fecha_cont'       => ( $act_fecha_depreciacion )? $act_fecha_depreciacion : $act_fecha_compra,
            'act_valor_compra'    => $act_valor_compra,
            'act_valor_dep'       => $act_porcentaje_dep,
            'act_valor_cont'      => $act_valor_cont,
            'act_estado'          => ( isset( $act_estado ) ) ? 1 : 0,
            'act_proyecto_id'     => $act_proyecto_id,
            'con_id'              => $con_id 
            );
        $tipos = $this->db->get_where('cxt_caracteristicaxtipo', array('cxt_id_tac' => $act_tipo_activo))->result();
        foreach( $tipos as $tac ){
            //
            if( !array_key_exists($tac->cxt_id, $unicos) ){
                $activo_fijo['act_caracteristicas'][ $tac->cxt_id ] = (object) array(
                    'cxt_id'    => $tac->cxt_id,
                    'cat'       => ( $tac->cxt_id_cat > 0 ),
                    'value'     => $carac[ $tac->cxt_id ]  
                );
            }
        }
        
        $result = array();
        while ( $cantidad != 0 ) {
            
            //aplicacion de la data unica para cada activo
            foreach( $unicos as $ind => $dat ){
                    $valor = array_shift($unicos[$ind]);
                    
                    $activo_fijo['act_caracteristicas'][ $ind ] = (object) array(
                        'cxt_id'    => $ind,
                        'cat'       => false,
                        'value'     => $valor  
                    );        
            }
            
            //print_r($valor); print_r( $activo_fijo ); print_r( $unicos ); //die(); 
            
            //Obtener el resultado de la insercion
            $result[] = $this->activo_fijo->registrar_activo( $activo_fijo );
            //
            if( count($correlativos) > 1 ){
                $index = count($correlativos) - $cantidad + 1;
                if( $index > 0 && $index < count($correlativos) ){
                    $activo_fijo['act_correlativo'] = $correlativos[ $index ];
                }
            }else{
                $activo_fijo['act_correlativo'] =  ( $activo_fijo['act_correlativo'] + 1 );
            }
            $cantidad--;
        }
        
        //Redirigir a la pagina de ingreso de activo fijo
        redirect( base_url( 'activo/nuevo/documentos?'.implode('|', $result) ) );
                   
    }

    /**
     * Obtiene porcentaje de depreciacion por ID de tipo de activo
     * @return json porcentaje de depreciacion
     */
    public function porcentaje_depreciacion()
    {
        //Verificar acceso unicamente, mediante AJAX
        if ( !$this->input->is_ajax_request() ) {
            exit('No direct script access allowed');
        }

        $id_tipo = $this->input->get('id_tipo');

        $result = $this->activo_fijo->get_porcentaje_depreaciacion( $id_tipo );

        echo $result;
    }
    
    /**
     * 
     * @author Alexis Beltran
     * @since  2013-10-02
     */
    public function get_saf()
    {   
        $codigo     = $this->activo_fijo->get_nuevo_correlativo();
        $codigos    = array();
        $cantidad   = $this->input->post('cantidad');
        for($i= $codigo; $i <= $codigo + $cantidad - 1; $i++ ){
            $codigos[] = $i;
        }
        
        $respuesta = array(
            'response'      => true,
            'correlativo'   => implode(',', $codigos) 
        );
        die(json_encode($respuesta));
    }
    
    public function get_codigo()
    {
        
        
        $codigo     = $this->activo_fijo->get_nuevo_correlativo();
        $codigos    = array();
        $cantidad   = $this->input->post('cantidad');
        for($i= $codigo; $i <= $codigo + $cantidad - 1; $i++ ){
            $codigos[] = $i;
        }
        
        $respuesta = array(
            'response'      => true,
            'correlativo'   => implode(',', $codigos) 
        );
        die(json_encode($respuesta));
    }
    
    
    public function get_grupos()
    {
        $tipo       = $this->input->post('id_tipo');
        $opciones   = $this->gsatelite->get_dropdown('grp_grupo', 'grp_nombre', '', array('grp_id_tac' => $tipo), null, '', '', true);
        
        $respuesta = array(
            'response'  => true,
            'opciones'  => $opciones 
        );
        die(json_encode($respuesta));
    }
    
    /**
     * 
     * @author Alexis Beltran
     */
    public function caracteristicas()
    {
        //Verificar acceso unicamente, mediante AJAX
        if ( !$this->input->is_ajax_request() ) {
            exit('No direct script access allowed');
        }
        
        $id_tipo    = $this->input->post('id_tipo');
        
        $tipo = $this->gsatelite->get_campo('tac_tipo_activofijo', 'tac_codigo', array('tac_id' => $id_tipo));
        $data['detalle'] = $this->activo_fijo->get_caracteristicas($id_tipo);
        $html = $this->load->view('activo/nuevo/caracteristicas', $data, true);
        
        $respod = array(
            'response'  => true,
            'html'      => $html,
            'tipo'      => $tipo
        );
        die(json_encode($respod));
    }
    
    public function search_orden()
    {
        $data['ordenes'] =  $this->activo_fijo->get_ordenes();
        $this->load->view('activo/nuevo/search_orden', $data);
    }
    
    public function search_facturas()
    {
        
        $data['facturas'] = $this->activo_fijo->get_facturas();
    }
    
    public function documentos()
    {
        (new Procesos())->validar_user();
    	try{
            
            $activosId = $this->input->get_post('activos');
            if( strlen($activosId) <= 0){
                $activosId = $this->session->userdata('activos_id');    
            }
            $this->session->set_userdata('activos_id', $activosId);
            
            if( strlen($activosId) > 0 ){
                $activosId = explode('|', $activosId);
                $this->db->where_in('act_id', $activosId);
            }
            $this->db->where('emp_id IS NULL', null);
            $this->db->order_by('saf');
            $activos =  $this->db->get('vw_activos')->result();
            
            $data = array(
                'activosId' => $activosId,
                'activos'   => $activos
            );
            
          //por defecto siempre es el post llamado valor.
		  //id del mantenimiento
		  //sera necesario un after insert para insertar en la tabla relacional.
            
            // 1: tabla, 2: id, 3: fk 0: registro
            $dat = "0-dxa_documentosxactivos-dxa_id_act-dxa_id_doc";
            $tabla = explode('-', $dat);
            $this->tabla = $tabla;
            $registro = $tabla[0];
            
		   $crud = new grocery_CRUD();
           $crud->set_table('doc_documento');
          // $crud->set_relation_n_n("docs","dxm_documentoxmantenimiento","mtv_mantenimiento_vehiculo","dxm_id_doc","dxm_id_mtv","mtv_costo","dxm_id_mtv");
           $crud->set_primary_key($tabla[3], $tabla[1]);
           $crud->set_relation("doc_id",$tabla[1], $tabla[3]);
           $crud->set_relation("doc_tipo","cat_catalogo","cat_nombre",array("cat_tipo"=>64,"cat_padre"=>0));
           $crud->set_subject('Documento');
            //$crud->callback_after_insert(array($this, 'relacionar_documento_mantenimiento',$valor));
            
            $crud->columns("doc_tipo","doc_nombre","doc_fecha","doc_desc","doc_archivo");
            $crud->display_as("doc_tipo","Tipo de documento");
            $crud->display_as("doc_nombre","Nombre del documento");
            $crud->display_as("doc_fecha","Fecha de documento");
            $crud->display_as("doc_desc","Descripcion del documento");
            $crud->display_as("doc_archivo","Archivo");
            
            //foreach ($activosId as $activo_id) {
                $crud->or_where($tabla[2], $activosId[0]);
            //}
            
             
            $crud->set_field_upload('doc_archivo', 'assets/uploads/files');
            $crud->callback_after_insert(function($post_array, $primary_key){
                $activos = explode('|', $this->session->userdata('activos_id'));
                foreach ($activos as $act_id) {
                    $this->db->insert($this->tabla[1], array(
			        $this->tabla[2] => $act_id,
			        $this->tabla[3] => $primary_key
			    ));
                }
			    return true;
			});
           
           $crud->unset_export()->unset_print();
            
           $this->_cargarvista($data, $crud->render(), true);
    	}catch(Exception $e){
    		show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
    	}
    }

    /**
     * Cargar vista del controlador
     * 
     * @param integer $data
     * @param integer $crud
     * @return HTML vista del controlador
     */
	function _cargarvista($data = 0, $crud = 0, $full = false )
	{	
        //print_r($data);
        $direccion=$this->uri->segment(1).'/'.$this->uri->segment(2).'/'.$this->uri->segment(3).'/'.$this->uri->segment(4);
        //echo $direccion;

        if($direccion == "activo/editar/index/update")
        {
            $data['redirect']=1;
            redirect( base_url('activo/depreciacion/detalles?id=11'));
        }else{
            //exit();
        }

		$this->load->view('vacia',$crud);	
		if($data!=0)
			$data=array_merge($data,$this->masterpage->getUsuario());
		else
			$data=$this->masterpage->getUsuario();
		$vista=$data['modulo'].'/'.$data['control'].'/'.$data['funcion'];
        if($full){
            $this->masterpage->setMasterPage('masterpage_full');
        }else{
            $this->masterpage->setMasterPage('masterpage_default');
        }
		$this->masterpage->addContentPage($vista, 'content',$data);
		$this->masterpage->show();
	}
}

/* End of file nuevo.php */
/* Location: ./application/controllers/nuevo.php */