<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Catalogo_activo extends CI_Controller {

	public function __construct()
	{
        parent::__construct();
        $this->load->database();
        $this->load->helper('url');
        $this->load->model('consultas');
        $this->load->model('gsatelite');
        $this->load->model('inventario_model');
        $this->load->library('grocery_CRUD');
        $this->load->helper('satelite_helper');
        //$this->load->library('../controllers/inventario/mantenimiento');
        $this->load->dbutil();
        // if(ob_get_contents()) ob_end_clean();
    }

    public function index()
    {
        $this->_cargarvista();
    }

    public function sucursal_activo()
    {
        try{
            $crud = new grocery_CRUD();

            //Columnas a mostrar en READ
            $columns = array(
              'suc_codigo',
              'suc_nombre',
              'suc_id_mun',
              'suc_direccion'
          );

            //Alias para las columnas
            $alias = array(
        //'suc_id_zon' => 'Zona',
              'suc_id_mun' => 'Ubicación',
              'suc_codigo' => 'Código Sucursal',
              'suc_nombre' => 'Nombre Sucursal',
              'suc_direccion' => 'Dirección'
          );

            //Columnas a mostrar en ADD
            $add_columns = array(
        //'suc_id_zon',
              'suc_id_mun',
              'suc_codigo',
              'suc_nombre',
              'suc_direccion',
              'suc_usu_mod',
              'suc_fecha_mod'
          );

             //Columnas a mostrar en EDIT
            $edit_columns = array(

              'suc_id_mun',
              'suc_codigo',
              'suc_nombre',
              'suc_direccion',
              'suc_usu_mod',
              'suc_fecha_mod'
          );

            $crud->set_table('suc_sucursal')
            ->set_subject('Sucursal')
            ->columns($columns)
            ->display_as($alias)
            ->add_fields($add_columns)
            ->edit_fields($edit_columns)
            ->required_fields($edit_columns)
            ->field_type('suc_usu_mod','hidden',$this->tank_auth->get_user_id())
            ->field_type('suc_fecha_mod','hidden',date('Y-m-d h:i:s'))
            ->set_rules('suc_nombre','Nombre','callback_username_check_insert')
            ->set_rules('suc_codigo','Nombre','callback_username_check_insert_suc_codigo')
            ->set_relation('suc_id_mun', 'mun_municipio', 'mun_nombre');

            $crud->callback_add_field('suc_codigo', function () {

                $tabla='suc_sucursal';
                $campo='suc_codigo';
                $last=$this->consultas->get_max_codigo($tabla,$campo);

                $code=$last->codigo;
                $cod= (int)$code+1;
                $codigo = str_pad($cod, 3, '0', STR_PAD_LEFT);

                return '<input id="field-suc_codigo" name="suc_codigo" type="text" maxlength="99" value="'.$codigo.'" >';
            });

            $crud->callback_edit_field('suc_codigo', function ($value, $primary_key) {

                if($value==''){
                  $tabla='suc_sucursal';
                  $campo='suc_codigo';
                  $last=$this->consultas->get_max_codigo($tabla,$campo);

                  $code=$last->codigo;
                  $cod= (int)$code+1;
                  $codigo = str_pad($cod, 3, '0', STR_PAD_LEFT);
                  return '<input id="field-suc_codigo" name="suc_codigo" type="text" maxlength="99" value="'.$codigo.'" >';
              }else{
                 return '<input id="field-suc_codigo" name="suc_codigo" type="text" maxlength="99" value="'.$value.'" >';
             }
         });

            $output = $crud->render();
            $data['titulo_personal']="Sucursales";

            $this->_cargarvista($data,$output);

        }
        catch(Exception $e){
            show_error($e->getMessage().' --- '.$e->getTraceAsString());
        }
    }

    function gestion_plaza(){
        satelite_validar();

        $crud = new grocery_CRUD();
        $crud->set_table('plz_plaza')
        ->set_subject('plazas')
        ->columns('plz_codigo','plz_nombre','plz_id_pto','plz_id_are','plz_salario_base','plz_id_padre','plz_id_cec','plz_estado')
        ->display_as('plz_codigo', 'Código')
        ->display_as('plz_nombre', 'Nombre')
        ->display_as('plz_id_pto', 'Puesto')
        ->display_as('plz_id_are', 'Área')
        ->display_as('plz_salario_base', 'Salario')
        ->display_as('plz_id_padre', 'Padre')
        ->display_as('plz_id_cec', 'Centro Costo')
        ->display_as('plz_estado', 'Estado')
        ->required_fields('plz_nombre','plz_estado')
        ->set_rules('plz_nombre','Nombre','trim|required|campo_unico[plz_plaza.plz_nombre]')    
        ->field_type('plz_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
        ->field_type('plz_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
        ->field_type('plz_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
        ->field_type('plz_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
        ;
        $crud->unset_delete();

        $crud->add_fields('plz_codigo','plz_nombre','plz_id_pto','plz_id_are','plz_id_padre','plz_salario_base','plz_id_cec','plz_estado','plz_usu_modificacion','plz_fecha_modificacion', 'plz_usu_creacion','plz_fecha_creacion');
        $crud->edit_fields('plz_codigo','plz_nombre','plz_id_pto','plz_id_are','plz_id_padre','plz_salario_base','plz_id_cec','plz_estado','plz_usu_modificacion','plz_fecha_modificacion');

         // Relacion de 1 - n 
        $crud->set_relation('plz_id_pto','pto_puesto','pto_nombre',array('pto_estado'=>'1'));
        $crud->set_relation('plz_id_are','are_area','are_nombre',array('are_estado'=>'1'));
        $crud->set_relation('plz_id_padre','plz_plaza','plz_nombre',array('plz_estado'=>'1'));
        $crud->set_relation('plz_id_cec','cec_centro_costo','cec_nombre', array('cec_estado'=>'1'));
        
        if(end(explode('/',uri_string()))=='add') {
            $crud->field_type('plz_estado','hidden',1);
        }
         else {  // Editar
            $crud->field_type('plz_estado','dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        }

        $crud->callback_add_field('plz_codigo', function () {
            $tabla='plz_plaza';
            $campo='plz_codigo';
            $last=$this->consultas->get_max_codigo($tabla,$campo);

            $code=$last->codigo;
            $cod= (int)$code+1;
            $codigo = str_pad($cod, 3, '0', STR_PAD_LEFT);

            return '<input id="field-plz_codigo" name="plz_codigo" type="text" maxlength="99" value="'.$codigo.'" >';
        });

        $crud->callback_edit_field('plz_codigo', function ($value, $primary_key) {   
            if($value==''){
              $tabla='plz_plaza';
              $campo='plz_codigo';
              $last=$this->consultas->get_max_codigo($tabla,$campo);

              $code=$last->codigo;
              $cod= (int)$code+1;
              $codigo = str_pad($cod, 3, '0', STR_PAD_LEFT);
              return '<input id="field-plz_codigo" name="plz_codigo" type="text" maxlength="99" value="'.$codigo.'" >';
          }else{
             return '<input id="field-plz_codigo" name="plz_codigo" type="text" maxlength="99" value="'.$value.'" >';
         }
        });

        $data['titulo_personal'] = "Plazas";

        $output = $crud->render();
        $this->_cargarvista($data,$output);

    }

    function area_empresa() {
        satelite_validar();
        $this->load->library('../controllers/expediente_personal/catalogos');
        $this->catalogos->area_empresa();
    }

    public function empleado()
    {
      if (!$this->tank_auth->is_logged_in()) {
          redirect('/auth/login/');
      } else {
          
        $crud = new grocery_CRUD;

            //Columnas a mostrar en READ
        $columns = array(

          'emp_id_suc',
          'emp_id_are',
          'emp_codigo',
          'emp_nombre',
          'emp_apellido',              
          );

            //Alias para las columnas
        $alias = array(
          'emp_id_plz' => 'Plaza',
          'emp_id_are' => 'Área',
          'emp_codigo' => 'Código',
          'emp_nombre' => 'Nombres',
          'emp_apellido' => 'Apellidos',
          'emp_estado' => 'Estado',
          'emp_direccion' => 'Dirección',
          'emp_telefono' => 'Teléfono',          
          'emp_lugar_nac' => 'Lugar de nacimiento',
          'emp_fecha_nac' => 'Fecha d nacimiento',
          'emp_id_gen' => 'Sexo',
          'emp_id_pro' => 'Profesión',
          'emp_id_esc' => 'Estado civil',
          'emp_fecha_ingreso' => 'Fecha de ingreso',
          'emp_fecha_retiro' => 'Fecha de retiro',
          'emp_salario' => 'Salario',
          'emp_id_usu' => 'Usuario de sistema',
          'emp_id_suc' => 'Sucursal'                
          );

            //Columnas a mostrar en ADD
        $add_columns = array(
          'emp_id_plz',
          'emp_id_are',
          'emp_codigo',
          'emp_nombre',
          'emp_apellido',
          'emp_direccion',
          'emp_estado',
          'emp_id_suc',
          'emp_telefono',
          //'emp_lugar_nac',
          'emp_usu_mod',
          //'emp_id_gen',
          //'emp_id_pro',
          //'emp_id_esc',
          'emp_fecha_mod',
          //'emp_salario',
          //'emp_id_usu',
          );

            //Columnas a mostrar en EDIT
        $edit_columns = array(        
          'emp_id_plz',
          'emp_id_are',
          'emp_codigo',
          'emp_nombre',
          'emp_apellido',
          'emp_direccion',
          'emp_estado',
          'emp_telefono',          
          //'emp_lugar_nac',
          //'emp_id_gen',
          //'emp_id_pro',
          //'emp_id_esc',
          'emp_id_suc',
          'emp_usu_mod',
          'emp_fecha_mod',
          //'emp_salario',
          //'emp_id_usu',
          );

        $required_fields=array(
          'emp_nombre',
          'emp_apellido',
          'emp_id_suc',
          'emp_codigo',
          'emp_id_usu',
          'emp_estado');

        $empleado=explode('/',uri_string());
        
        $empleado=$empleado[count($empleado)-1];

        if(is_numeric($empleado)){
          $usu_empleado=$this->db->select('emp_id_usu')->from('emp_empleado')->where('emp_id',$empleado)->get()->result_array();
      }

      $resultado=$this->db->select('emp_id_usu')->from('emp_empleado')->get()->result_array();

      $cadena_in='';
      if(isset($usu_empleado[0]['emp_id_usu'])){
          foreach ($resultado as $key ) {
            if(isset($key['emp_id_usu']) && $key['emp_id_usu'] != $usu_empleado[0]['emp_id_usu']){
               $cadena_in.=$key['emp_id_usu'].',';
           }
       }
      }
         else{
          foreach ($resultado as $key ) {
            if(isset($key['emp_id_usu'])){
               $cadena_in.=$key['emp_id_usu'].',';
           }
       }
      }


        $final=substr($cadena_in,0,-1);
        if(strlen($final)<=0){
          $final=0;
        }


         $crud->set_table('emp_empleado')
         ->set_subject('responsable')
         ->columns($columns)
         ->display_as($alias)
         ->add_fields($add_columns)
         ->edit_fields($edit_columns)
         ->set_relation('emp_id_plz', 'plz_plaza', 'plz_nombre')
         ->set_relation('emp_id_are', 'are_area', '{are_prefijo} {are_nombre}')
         ->set_relation('emp_id_pro', 'pro_profesion', 'pro_nombre')
         ->set_relation('emp_id_esc', 'esc_estado_civil', 'esc_nombre')
         ->set_relation('emp_id_suc', 'suc_sucursal', 'suc_nombre')
         ->set_relation('emp_id_usu', 'users', 'username',"id not in ({$final})")
         ->field_type('emp_usu_mod','hidden',$this->tank_auth->get_user_id())
         ->field_type('emp_fecha_mod','hidden',date('Y-m-d h:i:s'))
         ->required_fields($required_fields)
         ->set_rules('emp_codigo','Código','callback_username_check_insert9|required')
         ->set_relation('emp_id_gen', 'gen_genero','gen_nombre');

        if(end(explode('/',uri_string()))=='add') {
          $crud->field_type('emp_estado','hidden',1);
        }else {
          $crud->field_type('emp_estado','dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        } 

      $crud->callback_add_field('emp_codigo', function () {

        $tabla='emp_empleado';
        $campo='emp_codigo';
        $last=$this->consultas->get_max_codigo($tabla,$campo);

        $code=$last->codigo;
        $cod= (int)$code+1;
        $codigo = str_pad($cod, 3, '0', STR_PAD_LEFT);

        return '<input id="field-emp_codigo" name="emp_codigo" type="text" maxlength="99" value="'.$codigo.'" >';
      });

      $crud->callback_edit_field('emp_codigo', function ($value, $primary_key) {
       
        if($value==''){
          $tabla='emp_empleado';
          $campo='emp_codigo';
          $last=$this->consultas->get_max_codigo($tabla,$campo);

          $code=$last->codigo;
          $cod= (int)$code+1;
          $codigo = str_pad($cod, 3, '0', STR_PAD_LEFT);
          return '<input id="field-emp_codigo" name="emp_codigo" type="text" maxlength="99" value="'.$codigo.'" >';
        }else{
           return '<input id="field-emp_codigo" name="emp_codigo" type="text" maxlength="99" value="'.$value.'" >';
        }
      });

      $crud->callback_after_update(function ($post_array, $primary_key) {
        if (isset($post_array['emp_id_are']) && $post_array['emp_id_are'] != "") {

          $sigEmp = strtolower(trim($this->gsatelite->get_parametro('SYS_SIGLAS')));
          if ($sigEmp == 'defensoria') {
            $this->gsatelite->actualizar_array('axe_activoxempleado',array('axe_id_are' => $post_array['emp_id_are']),array('axe_estado' => 1,'axe_id_emp' => $primary_key));
            $this->consultas->actualizar_area_activos($post_array['emp_id_are'], null, $primary_key);
          }
        }
        return $post_array;
      });

         $output = $crud->render();
         $data['titulo_personal']="Responsable";
         $this->_cargarvista($data,$output);

     }   
 }

	public function ingresar_tipo_adquisicion()
 		{
	 	$objeto_crud = new grocery_CRUD;
	 	$objeto_crud->set_table('tad_tipo_adquisicion');
    	$objeto_crud->set_subject('Tipo de adquisición');

    $objeto_crud->field_type('tad_fecha_mod','hidden',date('Y-m-d H:i:s')); 
	 	$objeto_crud->add_fields('tad_codigo','tad_nombre','tad_estado');
	 	$objeto_crud->columns('tad_codigo','tad_nombre','tad_estado');
	 	$objeto_crud->edit_fields('tad_codigo','tad_nombre','tad_estado','tad_fecha_mod');
	 	$objeto_crud->required_fields('tad_codigo','tad_nombre','tad_estado');

	 	$objeto_crud->display_as('tad_nombre','Tipo de Adquisición');
    $objeto_crud->display_as('tad_estado','Estado');
    $objeto_crud->display_as('tad_codigo','Código');

 //   	$objeto_crud->field_type('tad_estado', 'dropdown', array( 0 => 'Inactivo', 1 => 'Activo'));
    	$objeto_crud->set_rules('tad_estado', 'Estado','required|xss_clean');
    	$objeto_crud->set_rules('tad_nombre', 'Tipo de Adquisición','required|xss_clean');
      $objeto_crud->set_rules('tad_codigo', 'Tipo de Código','required|xss_clean');
      $objeto_crud->set_rules('tad_nombre','Tipo de Adquisición','trim|required|campo_unico[tad_tipo_adquisicion.tad_nombre]');
      $objeto_crud->set_rules('tad_codigo','Tipo de código','trim|required|campo_unico[tad_tipo_adquisicion.tad_codigo]');
		$objeto_crud->unset_delete();

     if(end(explode('/',uri_string()))=='add') {
    $objeto_crud->field_type('tad_estado','hidden',1);
    }
    else {
    $objeto_crud->field_type('tad_estado','dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
    } 

    $objeto_crud->callback_add_field('tad_codigo', function () {

        $tabla='tad_tipo_adquisicion';
        $campo='tad_codigo';
        $last=$this->consultas->get_max_codigo($tabla,$campo);

        $code=$last->codigo;
        $cod= (int)$code+1;
        $codigo = str_pad($cod, 3, '0', STR_PAD_LEFT);

        return '<input id="field-tad_codigo" name="tad_codigo" type="text" maxlength="99" value="'.$codigo.'" >';
      });

      $objeto_crud->callback_edit_field('tad_codigo', function ($value, $primary_key) {
       
        if($value==''){
          $tabla='tad_tipo_adquisicion';
          $campo='tad_codigo';
          $last=$this->consultas->get_max_codigo($tabla,$campo);

          $code=$last->codigo;
          $cod= (int)$code+1;
          $codigo = str_pad($cod, 3, '0', STR_PAD_LEFT);
          return '<input id="field-tad_codigo" name="tad_codigo" type="text" maxlength="99" value="'.$codigo.'" >';
        }else{
           return '<input id="field-tad_codigo" name="tad_codigo" type="text" maxlength="99" value="'.$value.'" >';
        }
      });

	    $output = $objeto_crud->render();
	    $data["titulo_personal"]="Tipos de aquisiciones";
	    $this->_cargarvista($data,$output);
 		}

 	function guardar_usuario($post_array,$primary_key)
 		{
	   	$datos = 	array(
				        "tad_usr_mod" =>$this->tank_auth->get_user_id(),
				        "tad_fecha_mod" => date('Y-m-d')
					 	);
		$this->gsatelite->actualizar('tad_tipo_adquisicion', $datos, 'tad_id', $primary_key);
		return true;
 		}



    public function ingresar_tipo_activo()
    {

      $permisos = $this->gsatelite->get_permisos_opcion('activo/catalogo_activo/ingresar_tipo_activo');

      $crud = new grocery_CRUD;
      $crud->set_table('tac_tipo_activofijo');
      $crud->set_subject('Tipo de activo fijo');

      if($this->gsatelite->get_parametro("ACT_DEPREC_GRUPOS")==1){
        $crud->fields('tac_codigo','tac_nombre','tac_vida_util', 'carac','tac_estado','tac_usu_mod','tac_fecha_mod');
        $crud->columns('tac_codigo','tac_nombre','cuenta','tac_vida_util', 'carac', 'tac_estado');
      }else{
        $crud->fields('tac_codigo','tac_nombre','tac_vida_util','tac_depreciacion', 'carac','tac_estado','tac_usu_mod','tac_fecha_mod');
        $crud->columns('tac_codigo','tac_nombre','cuenta','tac_depreciacion','tac_vida_util', 'carac', 'tac_estado');
      }

      $crud->display_as('tac_nombre','Nombre');
      $crud->display_as('tac_depreciacion','% Depreciación');
      $crud->display_as('tac_vida_util','Vida útil');
      $crud->display_as('tac_estado','Estado');
      $crud->display_as('tac_codigo','Código');
      $crud->display_as('carac','Características');

      $crud->field_type('tac_usu_mod','hidden',$this->tank_auth->get_user_id());
      $crud->field_type('tac_fecha_mod','hidden',date('Y-m-d H:i:s'));
     
    $crud->set_relation_n_n('carac','cxi_caracteristicaxtipo', 'car_caracteristica', 
      'cxi_id_tac', 'cxi_id_car', '{car_nombre}', null,null);
      $crud->set_rules('tac_nombre','Nombre del tipo de activo fijo','required');
    if($this->gsatelite->get_parametro("ACT_DEPREC_GRUPOS")==0){
      $crud->set_rules('tac_depreciacion','Porcentaje de Depreciación','required|is_numeric');
    }
     $crud->set_rules('tac_vida_util','Vida útil','required|is_numeric');
     $crud->set_relation_n_n('cuenta', 'dtv_detalle_tipo_activo', 'cnt_cuenta_contable', 'dtv_id_tac', 'dtv_id_cnt', '{cnt_cuenta} - {cnt_nombre}');
     $crud->required_fields('tac_nombre','tac_depreciacion','tac_vida_util');
     $crud->callback_after_insert(array($this,'insertar_auditoria'));

    if(end(explode('/',uri_string()))=='add') {
      $crud->field_type('tac_estado','hidden',1);
    }
    else {
      $crud->field_type('tac_estado','dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
    } 


     $crud->unset_edit();
     $crud->unset_delete();

      if($permisos["permite_ver"]){
        $crud->add_action('&nbsp;&nbsp;Ver', '', 'activo/catalogo_activo/ver_tipo_activo','icomoon-icon-search-3');
      }
      if($permisos["permite_editar"]){
        $crud->add_action('Editar', '', 'activo/catalogo_activo/editar_tipo_activo','icomoon-icon-pencil-5');
      }
      if($permisos["permite_eliminar"]){
        $crud->add_action('Elminar', '', 'activo/catalogo_activo/eliminar_tipo_activo','icomoon-icon-remove');
      }
      if(!$permisos["permite_agregar"]){
        $crud->unset_add();
      }

     

     $output = $crud->render();
     $data["titulo_personal"] = "Tipo de activos";
     $this->_cargarvista($data,$output);
   }

   public function tipo_activo_uso()
   {
     $crud = new grocery_CRUD;
     $crud->set_table('tua_tipo_usu_activo');
     $crud->set_subject('Tipo de activo');
     $crud->display_as('tua_nombre','Nombre');
     $crud->display_as('tua_estado','Estado');
     $crud->fields('tua_nombre','tua_estado','tua_usu_mod','tua_fecha_mod');
     $crud->required_fields('tua_nombre','tua_estado');
     $crud->columns('tua_nombre','tua_estado');
     $crud->field_type('tua_usu_mod','hidden',$this->tank_auth->get_user_id());
     $crud->field_type('tua_fecha_mod','hidden',date('Y-m-d H:i:s'));
      if(end(explode('/',uri_string()))=='add') {
     $crud->field_type('tua_estado','hidden',1);
     }
     else {
     $crud->field_type('tua_estado','dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
     } 
     $output = $crud->render();
     $data["titulo_personal"] = "Tipo de Activos";
     $this->_cargarvista($data,$output);
   }

   public function insertar_auditoria($post_array,$key){
    //print_r($key)
    $actualizar=array('cxi_estado'=>1,
                      'cxi_usu_mod'=>$this->tank_auth->get_user_id(),
                      'cxi_fecha_mod'=>date('Y-m-d H:i:s'));
    $this->db->where('cxi_id_tac',$key)
         ->update('cxi_caracteristicaxtipo',$actualizar);

    return true;
   }
        
   public function add_carac($registro)
   {
   	
   $data['registro'] = $registro;
   	

        $nombre = $this->input->post('nombre');
        if( $registro > 0 && strlen($nombre) > 0 ){
            $this->db->insert('cxt_caracteristicaxtipo', array(
                'cxt_id_tac'    => $registro,
                'cxt_id_cat'    => $nombre
            ));
            $this->gsatelite->show_dialog('Registro Guardado.', "activo/catalogo_activo/add_carac/$registro");
        }elseif( $nombre ){
            $this->gsatelite->show_dialog('', "activo/catalogo_activo/add_carac/$registro", 'error');
        }
        
        $this->db->select('cxt_id as id, cat_catalogo.cat_nombre as valor');
        $this->db->join('cat_catalogo','cxt_caracteristicaxtipo.cxt_id_cat = cat_catalogo.cat_id');
        $data['caracs'] = $this->db->get_where('cxt_caracteristicaxtipo', array('cxt_id_tac' => $registro))->result();
        $data['nombre'] =  $this->gsatelite->get_dropdown('cat_catalogo', 'cat_nombre', 'nombre', array('cat_padre'=> 1,'cat_sistema' => 0 ), null,"id=\"nombre\"");
        $data["titulo_personal"]="Características";
        $this->_cargarvista(null, $data);
   

   }

    public function caracteristicas(){
        satelite_validar();
        try {
            $permisos = $this->gsatelite->get_permisos_opcion();
            $url_array = explode('/', uri_string());
            $crud = $this->new_crud();

            //Columnas a mostrar en READ
            $columns = array(
                //'car_codigo',
                'car_nombre',
                'car_descripcion'
            );
            //Alias para las columnas
            $alias = array(
                //'car_codigo' => 'Código',
                'car_nombre' => 'Nombre',
                'car_descripcion' => 'Descripción',
                'car_estado' => 'Estado'
            );
            //Columnas a mostrar en ADD
            $add_columns = array(
                  //  'car_codigo',
                'car_nombre',
                'car_descripcion',
                'car_estado',
                'car_usu_mod',
                'car_fecha_mod',
                'car_usu_crea',
                'car_fecha_crea'
            );
            $req_columns = array(
                'car_nombre',
                'car_estado'
            );
            $crud->set_table('car_caracteristica')->set_subject('Característica')->columns($columns)->display_as($alias)->add_fields($add_columns)->required_fields($req_columns)->field_type('car_usu_mod', 'hidden', $this->tank_auth->get_user_id())->field_type('car_fecha_mod', 'hidden', date('Y-m-d H:i:s'))->field_type('car_usu_crea', 'hidden', $this->tank_auth->get_user_id())->field_type('car_fecha_crea', 'hidden', date('Y-m-d H:i:s'))->set_rules('car_nombre', 'Nombre de la característica', 'trim|required|callback_caracteristica_nombre_unico');            
            if (end($url_array) == 'add') {
                $crud->field_type('car_estado', 'hidden', 1);
            } else {
                $crud->field_type('car_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }
            $crud->callback_add_field('car_codigo', function () {
                $tabla = 'car_caracteristica';
                $campo = 'car_codigo';
                $last = $this->inventario_model->get_max_codigo($tabla, $campo);
                $code = $last->codigo;
                $cod = (int) $code + 1;
                $codigo = str_pad($cod, 3, '0', STR_PAD_LEFT);
                return '<input id="field-car_codigo" name="car_codigo" type="text" maxlength="99" value="' . $codigo . '" >';
            });
            $crud->callback_edit_field('car_codigo', function ($value, $primary_key) {
                if ($value == '') {
                    $tabla = 'car_caracteristica';
                    $campo = 'car_codigo';
                    $last = $this->inventario_model->get_max_codigo($tabla, $campo);

                    $code = $last->codigo;
                    $cod = (int) $code + 1;
                    $codigo = str_pad($cod, 3, '0', STR_PAD_LEFT);
                    return '<input id="field-car_codigo" name="car_codigo" type="text" maxlength="99" value="' . $codigo . '" >';
                } else {
                    return '<input id="field-car_codigo" name="car_codigo" type="text" maxlength="99" value="' . $value . '" >';
                }
            });
            $crud->edit_fields($add_columns);
            // Validaciones
            $crud->unset_add();
            $crud->unset_edit();
            $crud->unset_delete();
            $data['agregar'] = true;
            if (!$permisos['permite_agregar']) {
                $data['agregar'] = false;
            }            
            if ($permisos['permite_editar']) {
                $crud->add_action('Editar', 'minia-icon-pencil', base_url().'activo/catalogo_activo/caracteristicas_editar/');
            }            
            if ($permisos['permite_eliminar']) {
                $crud->add_action('Eliminar', 'icon16 icomoon-icon-remove', base_url().'activo/catalogo_activo/caracteristicas_eliminar/');
            }
            if ($permisos['permite_ver']) {
                $crud->add_action('Ver', 'minia-icon-search', base_url().'activo/catalogo_activo/caracteristicas_ver/');
            }
            $output = $crud->render();
            $data['titulo_personal'] = "Catálogo de características";
            $this->_cargarvista($data, $output);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }

    }
   
   public function delete_carac( $registro,$padre )
   {
        if( $registro > 0 ){
            $this->db->delete('cxt_caracteristicaxtipo', array(
                'cxt_id'    => $registro
            ),1);
            $this->gsatelite->show_dialog('Registro Eliminado.', "activo/catalogo_activo/add_carac/$padre");
        }else{
            $this->gsatelite->show_dialog('', "activo/catalogo_activo/add_carac/$padre", 'error');
        }
   }

   public function ingresar_grupo()
   {
     $objeto_crud = new grocery_CRUD;
     if($this->gsatelite->get_parametro("ACT_DEPREC_GRUPOS")==1){
      $columns=array('grp_codigo','grp_nombre','grp_id_tac','grp_padre','grp_depreciacion');
    }else{
      $columns=array('grp_codigo','grp_nombre','grp_id_tac','grp_padre');
    }
     
     $objeto_crud->set_table('grp_grupo');
     $objeto_crud->set_subject('grupo');

     $objeto_crud->set_relation('grp_padre','grp_grupo','grp_nombre');
     $objeto_crud->add_fields($columns);
     $objeto_crud->columns($columns);
     $objeto_crud->edit_fields($columns);
     $objeto_crud->display_as('grp_depreciacion','Porcentaje depreciación');
     $objeto_crud->display_as('grp_codigo','Código');
     $objeto_crud->display_as('grp_nombre','Nombre del Grupo');
     $objeto_crud->display_as('grp_padre','Padre');
     $objeto_crud->display_as('grp_id_tac','Tipo de Activo');
     $objeto_crud->required_fields('grp_nombre','grp_codigo','grp_id_tac');
     $objeto_crud->set_rules('grp_nombre','Nombre del Grupo','required');
      if($this->gsatelite->get_parametro("ACT_DEPREC_GRUPOS")==1){
       $objeto_crud->set_rules('grp_depreciacion','Valor de depreciación','required');
       $objeto_crud->required_fields('grp_nombre','grp_codigo','grp_id_tac','grp_depreciacion');
      }

      $objeto_crud->callback_add_field('grp_codigo', function () {

        $tabla='grp_grupo';
        $campo='grp_codigo';
        $last=$this->consultas->get_max_codigo($tabla,$campo);

        $code=$last->codigo;
        $cod= (int)$code+1;
        $codigo = str_pad($cod, 3, '0', STR_PAD_LEFT);

        return '<input id="field-grp_codigo" name="grp_codigo" type="text" maxlength="99" value="'.$codigo.'" >';
      });

      $objeto_crud->callback_edit_field('grp_codigo', function ($value, $primary_key) {
       
        if($value==''){
          $tabla='grp_grupo';
          $campo='grp_codigo';
          $last=$this->consultas->get_max_codigo($tabla,$campo);

          $code=$last->codigo;
          $cod= (int)$code+1;
          $codigo = str_pad($cod, 3, '0', STR_PAD_LEFT);
          return '<input id="field-grp_codigo" name="grp_codigo" type="text" maxlength="99" value="'.$codigo.'" >';
        }else{
           return '<input id="field-grp_codigo" name="grp_codigo" type="text" maxlength="99" value="'.$value.'" >';
        }
      });

     $objeto_crud->set_rules('grp_codigo','Código','required');
     $objeto_crud->set_rules('grp_id_tac','Tipo de Activo','required');

     $objeto_crud->set_relation('grp_id_tac', 'tac_tipo_activofijo', '{tac_codigo} - {tac_nombre}');

     $objeto_crud->unset_delete();

     $output = $objeto_crud->render();

     $data['titulo_personal']='Gestión de grupos';
     $this->_cargarvista($data,$output);
   }

 	function generar_estado2($value, $row)
		{
		if($value==1 || $value=="")
			{
			$estado1='selected="selected"';	
			$estado2="";
			}
		else
			{
			$estado1="";
			$estado2='selected="selected"';	
			}
		$cc='<div class="form-field-box" id="tac_deprec_field_box">'.
			'	<div class="form-input-box" id="tac_deprec_input_box">'.
			'		<select name="tac_deprec" id="tac_deprec" class="chosen-select" style="display:inline-block; width:300px;">'.
			'			<option value="1" '.$estado1.'>Activo</option>'.
			'			<option value="0" '.$estado2.'>No Activo</option>'.
			'		</select>'.
			'	</div>'.
			'</div>';
 		return $cc;
		}


 function cuenta_depreciacion() 
    {
      satelite_validar();                
                $crud = new grocery_CRUD();
                $crud->set_table('cde_cuenta_depreciacion')
                     ->set_subject('Cuentas Depreciables')
                     ->columns('cde_codigo','cde_nombre')
                     ->fields('cde_codigo','cde_nombre','cde_usu_mod','cde_fecha_mod')
                     ->display_as('cde_nombre','Nombre')
                     ->display_as('cde_codigo', 'Código')
                     ->required_fields('cde_nombre','cde_codigo')
                     ->set_rules('cde_nombre','Nombre','trim|required|campo_unico[cde_cuenta_depreciacion.cde_nombre]')
                     ->field_type('tre_estado','dropdown',array('1' => 'Activado', '0' => 'Desactivado'))
                     ->field_type('tre_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                     ->field_type('tre_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                     ->unset_delete()
                     ;
                     $data['titulo_personal'] = "UBICACIONES";

                $output = $crud->render();
                $this->_cargarvista($data,$output);
    
    }

    function gestion_cuenta_contable() {
        satelite_validar();
        $this->load->library('../controllers/modulo_contabilidad/catalogos');
        $this->catalogos->cuenta_contable('activo/catalogo_activo/gestion_cuenta_contable', 3);        
    }

    /*
    * Funcionalidad compartida del modulo de Contabilidad(Funcion de Agregar cuenta contable tabla: cnt_cuenta_contable)
    */
    function agregar_cuenta() {
        satelite_validar();
        $this->load->library('../controllers/modulo_contabilidad/catalogos');
        $this->catalogos->agregar_cuenta('activo/catalogo_activo',3);
    }

    /*
    * Funcionalidad compartida del modulo de Contabilidad(Funcion de editar cuenta contable tabla: cnt_cuenta_contable)
    */
    function editar_cuenta($id_cuenta = null) {
        satelite_validar();
        $this->load->library('../controllers/modulo_contabilidad/catalogos');        
        $this->catalogos->editar_cuenta($id_cuenta, 'activo/catalogo_activo');
    }

    /*function gestion_cuenta_contable()
    {
      satelite_validar();
      $crud = new grocery_CRUD();

     $columns=array('cco_codigo','cco_nombre','cco_id_cpr_egr','cco_id_cpr_ing','cco_padre','cco_deudor','cco_acreedor');
     $crud->set_table('cco_cuenta_contable');
     $crud->set_subject('cuentas contables');
     $crud->add_fields($columns);
     $crud->columns($columns);
     $crud->edit_fields($columns);
     $crud->display_as('cco_id_cpr_egr','Egreso');
     $crud->display_as('cco_id_cpr_ing','Ingreso');
     $crud->display_as('cco_codigo','Código');
     $crud->display_as('cco_nombre','Nombre');
     $crud->display_as('cco_padre','Padre');
     $crud->display_as('cco_deudor','Deudor');
     $crud->display_as('cco_acreedor','Acreedor');
     $crud->required_fields('cco_codigo','cco_nombre','cco_deudor','cco_acreedor');
     $crud->field_type('cco_deudor','dropdown', array('1' => 'Si', '0' => 'No'));
     $crud->field_type('cco_acreedor','dropdown', array('1' => 'Si', '0' => 'No'));

     $crud->set_relation('cco_id_cpr_egr','cpr_cuenta_presupuesto','cpr_nombre');
     $crud->set_relation('cco_id_cpr_ing','cpr_cuenta_presupuesto','cpr_nombre');
     $crud->set_relation('cco_padre','cco_cuenta_contable','cco_nombre');
     $crud->unset_delete();

     $output = $crud->render();

     $data['titulo_personal']='Gestión de cuentas contables';
     $this->_cargarvista($data,$output);
    }*/

  function gestion_cuenta_presupuesto()
    {
      satelite_validar();
      $crud = new grocery_CRUD();

     $columns=array('cpr_numero','cpr_rubro','cpr_cuenta','cpr_nombre','cpr_desc','cpr_padre');
     
     $crud->set_table('cpr_cuenta_presupuesto');
     $crud->set_subject('Cuenta presupuesto');
     $crud->add_fields($columns);
     $crud->columns($columns);
     $crud->edit_fields($columns);
     $crud->display_as('cpr_numero','Número');
     $crud->display_as('cpr_rubro','Rubro');
     $crud->display_as('cpr_cuenta','Cuenta');
     $crud->display_as('cpr_nombre','Nombre');
     $crud->display_as('cpr_desc','Descripción');
     $crud->display_as('cpr_padre','Padre');
     $crud->required_fields('cpr_numero','cpr_nombre');
     $crud->set_relation('cpr_padre','cpr_cuenta_presupuesto','cpr_nombre'); 
     $crud->set_rules('cpr_numero','Número', 'trim|required|is_numeric');

     $crud->unset_delete();
    if ($crud->getState() == 'edit' || $crud->getState() == 'add') {
    $crud->field_type('cpr_rubro', 'hidden',0);
    $crud->field_type('cpr_cuenta', 'hidden',0);
    }

     $output = $crud->render();

     $data['titulo_personal']='Gestión de cuenta presupuesto';
     $this->_cargarvista($data,$output);
    }  

    function agregar_tipo_activo(){
        satelite_validar();
        if($_POST){
            // die(var_dump($_POST));
            $codigo=($this->input->post('codigo')!='') ? $this->input->post('codigo') : null;
            $nombre=($this->input->post('nombre')!='') ? $this->input->post('nombre') : null;
            $vida_util=($this->input->post('vida_util')!='') ? $this->input->post('vida_util') : null;
            $porcentaje=($this->input->post('porcentaje')!='') ? $this->input->post('porcentaje') : null;
            $caracteristica=($this->input->post('caracteristica')!='') ? $this->input->post('caracteristica') : null;

            $det_centro_costo=($this->input->post('detalle_cc')!='') ? $this->input->post('detalle_cc') : null;
            $det_tipo_cnt=($this->input->post('detalle_tc')!='') ? $this->input->post('detalle_tc') : null;
            $det_cnt_contable=($this->input->post('detalle_cu')!='') ? $this->input->post('detalle_cu') : null;
            $det_tipo_process=($this->input->post('detalle_pr')!='') ? $this->input->post('detalle_pr') : null;

            $tipo_activo=array(
                'tac_nombre'=>$nombre,
                'tac_codigo'=>$codigo,
                'tac_depreciacion'=>$porcentaje,
                'tac_vida_util'=>$vida_util,
                'tac_estado'=>1,
                'tac_usu_creacion'=>$this->tank_auth->get_user_id(),
                'tac_fecha_creacion'=>date('Y-m-d'),
                'tac_usu_modificacion'=>$this->tank_auth->get_user_id(),
                'tac_fecha_modificacion'=>date('Y-m-d')
            );


            $tac_id=$this->gsatelite->ingresar('tac_tipo_activofijo', $tipo_activo);

            foreach ($caracteristica as $car => $value) {
                $caracteristicas=array(
                    'cxi_id_tac'=>$tac_id,
                    'cxi_id_car'=>$value,
                    'cxi_estado'=>1,
                    'cxi_usu_creacion'=>$this->tank_auth->get_user_id(),
                    'cxi_fecha_creacion'=>date('Y-m-d'),
                    'cxi_usu_modificacion'=>$this->tank_auth->get_user_id(),
                    'cxi_fecha_modificacion'=>date('Y-m-d')
                );

                $this->gsatelite->ingresar('cxi_caracteristicaxtipo', $caracteristicas);
            }

            foreach ($det_centro_costo as $cec => $valor) {
                $detalles=array(
                    'dtv_id_cec'=>$valor,
                    'dtv_id_tcn'=>$det_tipo_cnt[$cec],
                    'dtv_id_cnt'=>$det_cnt_contable[$cec],
                    'dtv_id_tac'=>$tac_id,
                    'dtv_tipo_proceso'=>($det_tipo_process[$cec]) ? $det_tipo_process[$cec] : null,
                    'dtv_estado'=>1,
                    'dtv_usu_creacion'=>$this->tank_auth->get_user_id(),
                    'dtv_fecha_creacion'=>date('Y-m-d'),
                    'dtv_usu_modificacion'=>$this->tank_auth->get_user_id(),
                    'dtv_fecha_modificacion'=>date('Y-m-d')
                );

                $this->gsatelite->ingresar('dtv_detalle_tipo_activo', $detalles);
            }

            if ($tac_id > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Acción ejecutada", 'texto_alerta' => "Los registros fueron guardados correctamente");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Acción no ejecutada", 'texto_alerta' => "No se pudo realizar la acción, favor de verificar la información");
            }
            $volver=$this->input->post('volver');
            if ($volver == 1) {
                $this->session->set_flashdata($alerta);
                redirect('activo/catalogo_activo/ingresar_tipo_activo');
            } else {
                $this->session->set_flashdata($alerta);
                redirect('activo/catalogo_activo/agregar_tipo_activo');
            }
        }else{
            $select = $this->gsatelite->get_dropdown('car_caracteristica', '{car_nombre}', '', array('car_estado' => 1), null, '', 'car_id', true);
            $data["caracteristica"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $select);

            $centro_costo = $this->gsatelite->get_dropdown('cec_centro_costo', '{cec_nombre}', '', array('cec_estado' => 1), null, '', 'cec_id', true);
            $data["centro_costo"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $centro_costo);

            $tipo_cuenta = $this->gsatelite->get_dropdown('tcn_tipo_cuenta', '{tcn_nombre}', '', array('tcn_estado' => 1), null, '', 'tcn_id', true);
            $data["tipo_cuenta"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $tipo_cuenta);

            $cnt_contable = $this->gsatelite->get_dropdown('cnt_cuenta_contable', '{cnt_cuenta} - {cnt_nombre}', '', array('cnt_estado' => 1), null, '', 'cnt_id', true);
            $data["cnt_contable"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $cnt_contable);
            /******************** ÚLTIMO CÓDIGO ******************/
            $tabla='tac_tipo_activofijo';
            $campo='tac_codigo';
            $last=$this->consultas->get_max_codigo($tabla,$campo);

            $code=$last->codigo;
            $cod= (int)$code+1;
            $data['codigo'] = str_pad($cod, 3, '0', STR_PAD_LEFT);
            $data['titulo_personal']="Tipo de activo fijo";
        }
        $this->_cargarvista($data);
    }

    function validar_info(){
      satelite_validar();

        $codigo=$this->input->post('codigo');
        $nombre=$this->input->post('nombre');
        $id=$this->input->post('id');
        

        if($codigo!=''){
          if($id>0){
            $get_codigo=$this->gsatelite->get_tabla('tac_tipo_activofijo', array('tac_codigo'=>$codigo, 'tac_id <>'=>$id));
          }else{
            $get_codigo=$this->gsatelite->get_tabla('tac_tipo_activofijo', array('tac_codigo'=>$codigo));
          }

          if(count($get_codigo)>0){
            $cant_codigo=1;
          }else{
            $cant_codigo=0;
          }
        }
        if($nombre!=''){
          if($id>0){            $get_nombre=$this->gsatelite->get_tabla('tac_tipo_activofijo', array('tac_nombre'=>$nombre, 'tac_id <>'=>$id));
          }else{
            $get_nombre=$this->gsatelite->get_tabla('tac_tipo_activofijo', array('tac_nombre'=>$nombre));
          }

          if(count($get_nombre)>0){
            $cant_nombre=1;
          }else{
            $cant_nombre=0;
          }
        }

        echo json_encode(array('codigo'=>$cant_codigo, 'nombre'=>$cant_nombre));

    }

    function editar_tipo_activo($tipo){
        satelite_validar();
        if($_POST){
            $codigo=($this->input->post('codigo')!='') ? $this->input->post('codigo') : null;
            $nombre=($this->input->post('nombre')!='') ? $this->input->post('nombre') : null;
            $vida_util=($this->input->post('vida_util')!='') ? $this->input->post('vida_util') : null;
            $porcentaje=($this->input->post('porcentaje')!='') ? floatval($this->input->post('porcentaje')) : null;
            $tipo_id=($this->input->post('tipo_id')!='') ? $this->input->post('tipo_id') : null;
            $estado=($this->input->post('estado')!='') ? $this->input->post('estado') : null;
            $caracteristica=($this->input->post('caracteristica')!='') ? $this->input->post('caracteristica') : null;          
            $det_centro_costo=($this->input->post('detalle_cc')!='') ? $this->input->post('detalle_cc') : null;
            $det_tipo_cnt=($this->input->post('detalle_tc')!='') ? $this->input->post('detalle_tc') : null;
            $det_cnt_contable=($this->input->post('detalle_cu')!='') ? $this->input->post('detalle_cu') : null;
            $det_tipo_process=($this->input->post('detalle_pr')!='') ? $this->input->post('detalle_pr') : null;
            $tipo_activo=array(
                'tac_nombre'=>$nombre,
                'tac_codigo'=>$codigo,
                'tac_depreciacion'=>$porcentaje,
                'tac_vida_util'=>$vida_util,
                'tac_estado'=>$estado,
                'tac_usu_modificacion'=>$this->tank_auth->get_user_id(),
                'tac_fecha_modificacion'=>date('Y-m-d')
            );
            $tac_id=$this->gsatelite->actualizar_array('tac_tipo_activofijo', $tipo_activo, array('tac_id'=>$tipo_id));
            // ACTUALIZAR LOS ACTIVOS QUE YA ESTEN GUARDADOS, PARA ESE TIPO DE ACTIVO
            $where_activo = array('act_estado' => 1, 'act_depreciable' => 1, 'act_id_tac' => $tipo);
            $this->gsatelite->actualizar_array('act_activo_fijo', array('act_vida_util' => $vida_util, 'act_porcentaje_dep' => $porcentaje), $where_activo);

            $no_del=0;
            $caracter=$this->gsatelite->get_tabla('cxi_caracteristicaxtipo', array('cxi_id_tac'=>$tipo_id));            
            foreach ($caracter as $carac ) {
                $existe=$this->gsatelite->get_tabla('cxc_caracterxactivo',array('cxc_id_cxi'=>$carac['cxi_id']));                                  
                if(count($existe)<=0){
                    $this->gsatelite->borrado_general('cxi_caracteristicaxtipo', array('cxi_id'=>$carac['cxi_id']));                                                            
                }else{                    
                    if(!in_array($carac['cxi_id_car'], $caracteristica)){
                        $no_del++;
                    }
                }                
            } 
            /*Despues de haber eliminado los registros que no tienen hijos, ahora se comparan los
            * que quedaron en la BD con los recibidos del formulario, ingresando solo los nuevos */  
            $caracter2 = $this->gsatelite->get_tabla('cxi_caracteristicaxtipo', array('cxi_id_tac'=>$tipo_id));
            foreach ($caracteristica as $carac ) {
                if(!in_array($carac, $caracter2[0])){
                    $caracteristicas=array( 
                        'cxi_id_tac'=>$tipo_id,
                        'cxi_id_car'=>$carac,
                        'cxi_estado'=>1,
                        'cxi_usu_creacion'=>$this->tank_auth->get_user_id(),
                        'cxi_fecha_creacion'=>date('Y-m-d'),
                        'cxi_usu_modificacion'=>$this->tank_auth->get_user_id(),
                        'cxi_fecha_modificacion'=>date('Y-m-d')
                    );
                    $this->gsatelite->ingresar('cxi_caracteristicaxtipo', $caracteristicas);
                }                
            }
            $this->gsatelite->borrado_general('dtv_detalle_tipo_activo', array('dtv_id_tac'=>$tipo_id));
            foreach ($det_centro_costo as $cec => $valor) {
                $detalles=array(
                    'dtv_id_cec'=>$valor,
                    'dtv_id_tcn'=>$det_tipo_cnt[$cec],
                    'dtv_id_cnt'=>$det_cnt_contable[$cec],
                    'dtv_id_tac'=>$tipo_id,
                    'dtv_tipo_proceso'=>($det_tipo_process[$cec]) ? $det_tipo_process[$cec] : null,
                    'dtv_estado'=>1,
                    'dtv_usu_creacion'=>$this->tank_auth->get_user_id(),
                    'dtv_fecha_creacion'=>date('Y-m-d'),
                    'dtv_usu_modificacion'=>$this->tank_auth->get_user_id(),
                    'dtv_fecha_modificacion'=>date('Y-m-d')
                );
                $this->gsatelite->ingresar('dtv_detalle_tipo_activo', $detalles);
            }
            if ($tipo_id > 0) {
                if($no_del>0){
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Registros no eliminados", 'texto_alerta' => "Algunas características no pudieron ser eliminadas debido a que otros registros dependen de éstas.");
                }else{
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Acción ejecutada", 'texto_alerta' => "Los registros fueron actualizados correctamente");
                }
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Acción no ejecutada", 'texto_alerta' => "No se pudo realizar la acción, favor de verificar la información");
            }
            $volver=$this->input->post('volver');
            if ($volver == 1) {
                if($no_del>0){
                    $this->session->set_flashdata($integridad);
                }
                $this->session->set_flashdata($alerta);
                redirect('activo/catalogo_activo/ingresar_tipo_activo');
            } else {
                if($no_del>0){
                    $this->session->set_flashdata($integridad);
                }
                $this->session->set_flashdata($alerta);
                redirect('activo/catalogo_activo/editar_tipo_activo/'.$tipo_id);
            }
        }else{
            $data['activos']=$activos=$this->consultas->get_tipo_activo($tipo);
            $data['detalles']=$detalles=$this->consultas->get_detalle_tipo_activo($tipo);

            $caract= explode(',', $activos->caracteristicas);
            $select = $this->gsatelite->get_dropdown('car_caracteristica', '{car_nombre}', '', array('car_estado' => 1), $caract, '', 'car_id', true);
            $data["caracteristica"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $select);

            $centro_costo = $this->gsatelite->get_dropdown('cec_centro_costo', '{cec_nombre}', '', array('cec_estado' => 1), null, '', 'cec_id', true);
            $data["centro_costo"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $centro_costo);

            $tipo_cuenta = $this->gsatelite->get_dropdown('tcn_tipo_cuenta', '{tcn_nombre}', '', array('tcn_estado' => 1), null, '', 'tcn_id', true);
            $data["tipo_cuenta"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $tipo_cuenta);

            $cnt_contable = $this->gsatelite->get_dropdown('cnt_cuenta_contable', '{cnt_cuenta} - {cnt_nombre}', '', array('cnt_estado' => 1), null, '', 'cnt_id', true);
            $data["cnt_contable"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $cnt_contable);

            /******************** ÚLTIMO CÓDIGO ******************/
            $tac_codigo=$this->gsatelite->get_campo('tac_tipo_activofijo','tac_codigo', array('tac_id'=>$tipo));
            if($tac_codigo==''){
                $tabla='tac_tipo_activofijo';
                $campo='tac_codigo';
                $last=$this->consultas->get_max_codigo($tabla,$campo);

                $code=$last->codigo;
                $cod= (int)$code+1;
                $data['codigo'] = str_pad($cod, 3, '0', STR_PAD_LEFT);
            }else{
                $data['codigo'] = $tac_codigo;
            }
            $data['titulo_personal']="Editar tipo de activo fijo";
        }
        $this->_cargarvista($data);
    }

    function ver_tipo_activo($tipo){
      satelite_validar();
          $data['activos']=$activos=$this->consultas->get_tipo_activo($tipo);
         
          $data['detalles']=$detalles=$this->consultas->get_detalle_tipo_activo($tipo);
         
          $caract= explode(',', $activos->caracteristicas);
          $select = $this->gsatelite->get_dropdown('car_caracteristica', '{car_nombre}', '', array('car_estado' => 1), $caract, '', 'car_id', true);
          $data["caracteristica"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $select);

          $centro_costo = $this->gsatelite->get_dropdown('cec_centro_costo', '{cec_nombre}', '', array('cec_estado' => 1), null, '', 'cec_id', true);
           $data["centro_costo"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $centro_costo);

          $tipo_cuenta = $this->gsatelite->get_dropdown('tcn_tipo_cuenta', '{tcn_nombre}', '', array('tcn_estado' => 1), null, '', 'tcn_id', true);
          $data["tipo_cuenta"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $tipo_cuenta);

          $cnt_contable = $this->gsatelite->get_dropdown('cnt_cuenta_contable', '{cnt_nombre}', '', array('cnt_estado' => 1), null, '', 'cnt_id', true);
          $data["cnt_contable"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $cnt_contable);


        $data['titulo_personal']="Tipo de activo fijo";
      

      $this->_cargarvista($data);
    }

    function eliminar_tipo_activo($tipo){
      satelite_validar();
                        
      $activo=$this->db->select()->from('tac_tipo_activofijo')->join('act_activo_fijo', 'act_id_tac=tac_id')->where('tac_id',$tipo)->limit(1)->get()->row();
      $actxgrupo=$this->db->select()->from('tac_tipo_activofijo')->join('grp_grupo', 'grp_id_tac=tac_id')->where('tac_id',$tipo)->limit(1)->get()->row();
      

      if(count($activo)>0 || count($actxgrupo)>0){
        $alerta=array('tipo_alerta'=> 'error','titulo_alerta'=>"Acción no ejecutada",'texto_alerta'=>"Otros registros dependen de éste, por lo que no podrá ser eliminado");
      }else{
                $this->gsatelite->borrado_general('cxi_caracteristicaxtipo', array('cxi_id_tac'=>$tipo));
                $this->gsatelite->borrado_general('dtv_detalle_tipo_activo', array('dtv_id_tac'=>$tipo));
        $delete=$this->gsatelite->borrado_general('tac_tipo_activofijo', array('tac_id'=>$tipo));

        if($delete>0){
          $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Acción ejecutada", 'texto_alerta' => "Los registros fueron eliminados correctamente");
        }
      }

      $this->session->set_flashdata($alerta);
      redirect('activo/catalogo_activo/ingresar_tipo_activo');
    }

    /**
  *====================
  *CALLBACKS
  *===================
  **/

  /**
  *====================
  *@Autor: Mario Marquez
  *===================
  **/
   function caracteristica_nombre_unico(){
        $nom_carac = trim($this->input->post('car_nombre'));
        $mod_carac = $this->input->post('car_modulo');

        if(end(explode('/',uri_string()))=='add') {
            $where = array('car_caracteristica.car_nombre'=>$nom_carac,'car_caracteristica.car_modulo'=>$mod_carac);
            $query = $this->db->select('car_caracteristica.car_id')
                          ->from('car_caracteristica');
            $this->db->where($where);
        }

        else{
            $id_carac = end(explode('/',uri_string()));
            $where = array('car_caracteristica.car_nombre'=>$nom_carac,'car_caracteristica.car_modulo'=>$mod_carac);
            $query = $this->db->select('car_caracteristica.car_id')
                          ->from('car_caracteristica');
            $this->db->where($where);
            $this->db->where_not_in('car_caracteristica.car_id',$id_carac);
        }
        $result = $query->get()->result();
        if(count($result)>0){
            $this->form_validation->set_message('caracteristica_nombre_unico','El campo Nombre debe ser único.');  
            return false;
        }
        else{
            return true;
        }
   }
   //=============================================================================================================//
   //=============================================================================================================//

   
     function get_codigo_correlativo(){
      $tabla=$this->input->post('tabla'); 
      $campo=$this->input->post('campo');
      $long = $this->input->post('longitud');
        $last=$this->consultas->get_max_codigo($tabla,$campo);

        $cant = ($long!='')? $long : 3;
        $code=$last->codigo;
        $cod= (int)$code+1;
        $codigo = str_pad($cod, $cant, '0', STR_PAD_LEFT);
        echo json_encode($codigo);
    }

    function generar_periodo($year_seleccionado='') {
        $year_seleccionado=($year_seleccionado>0 && strlen($year_seleccionado)==4)? $year_seleccionado:date('Y');
        $crud = new grocery_crud();
        $crud->set_table('prd_periodo_deprec');
        $crud->set_subject('');
        $columns = array('prd_ano','prd_mes','prd_estado');
        $add_fields = array('prd_ano','prd_mes','prd_codigo','prd_estado','prd_usu_crea','prd_fecha_crea','prd_usu_mod','prd_fecha_mod');
        $edit_fields = array('prd_ano','prd_mes','prd_codigo','prd_estado','prd_usu_mod','prd_fecha_mod');
        $required = array('prd_ano','prd_mes','prd_codigo','prd_estado');
        $display_as = array(
            'prd_ano'=>'Año',
            'prd_mes'=>'Mes',
            'prd_codigo'=>'Código',
            'prd_estado'=>'Estado'
        );
        $meses_list = array(
            '1'=>'Enero',
            '2'=>'Febrero',
            '3'=>'Marzo',
            '4'=>'Abril',
            '5'=>'Mayo',
            '6'=>'Junio',
            '7'=>'Julio',
            '8'=>'Agosto',
            '9'=>'Septiembre',
            '10'=>'Octubre',
            '11'=>'Noviembre',
            '12'=>'Diciembre'
        );
        $actual=date('Y');
        $seleccionado = $year_seleccionado;
        $inicio=$actual-50;
        $fin=$actual+20;
        $data['seleccionado']=$seleccionado;
        $data['inicio']=$inicio;
        $data['fin']=$fin;
        if($_POST) {
            $tipo_accion=$this->input->post('tipo_accion');
            $prd_seleccionado=$this->input->post('select_ano');
            if($tipo_accion==1) {
                $np = $this->cargar_periodos($prd_seleccionado);
                if($np>0){
                    $alerta = array(
                        'tipo_alerta' => 'success',
                        'titulo_alerta' => "Periodos creados con Éxito",
                        'texto_alerta' => ""
                    );
                    $this->session->set_flashdata($alerta);
                    redirect("activo/catalogo_activo/generar_periodo/$prd_seleccionado");
                }
            } else {
                $exito = $this->eliminar_periodos($prd_seleccionado); 
                if($exito>0) {
                    $alerta = array(
                        'tipo_alerta' => 'success',
                        'titulo_alerta' => "Periodos eliminados con Éxito",
                        'texto_alerta' => "");
                    $this->session->set_flashdata($alerta);
                } else {
                    $alerta = array(
                        'tipo_alerta' => 'error',
                        'titulo_alerta' => "Los Periodos no podran ser eliminados",
                        'texto_alerta' => "");
                    $this->session->set_flashdata($alerta);
                }
            }
            redirect("activo/catalogo_activo/generar_periodo/$prd_seleccionado");
            $seleccionado=$prd_seleccionado;
        }
        $crud->where('prd_ano',$seleccionado);
        $crud->columns($columns)
            ->display_as($display_as)
            ->required_fields($required)
            ->add_fields($add_fields)
            ->edit_fields($edit_fields)
            ->field_type('prd_usu_crea', 'hidden', $this->tank_auth->get_user_id())
            ->field_type('prd_usu_mod', 'hidden', $this->tank_auth->get_user_id())
            ->field_type('prd_fecha_crea', 'hidden', date('Y-m-d H:i:s'))
            ->field_type('prd_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
        ;        
        $crud->set_rules('prd_mes','Mes','required|trim|callback_validar_mes');
        $crud->set_rules('prd_codigo','Código','required|trim|campo_unico[prd_periodo_deprec.prd_codigo]');
        $crud->field_type('prd_mes', 'dropdown',$meses_list);

        if (end(explode('/', uri_string())) == 'add') {
            $crud->field_type('prd_estado', 'hidden', 1);
        } else {
            $crud->field_type('prd_estado', 'dropdown', array(1 => 'Activo', 0 => 'Inactivo'));
        }
        $crud->add_action('Act / Desact', 'icomoon-icon-blocked', 'activo/catalogo_activo/desactivar_periodo', 'desactivar_periodo');
        $crud->unset_add()->unset_edit()->unset_delete();
        $output = $crud->render();

        $data['titulo_personal'] = "Periodos";

        $this->_cargarvista($data, $output);
    } // End  Periodos

    function cargar_periodos($year=null) {
        $n=0;
        $year = ($year>0)? $year:date('Y');
        $meses=12;
        $usuario=$this->tank_auth->get_user_id();
        $fecha=date('Y-m-d H:i:s');
        $data_=array();
        for ($j=1; $j <= 12 ; $j++) {
            $cm=($j<10)? "0".$j:$j;  
            $codigo=$year.$cm;
            $q=$this->gsatelite->get_tabla('prd_periodo_deprec',array('prd_ano'=>$year,'prd_mes'=>$j));
            if(count($q)<=0) { //si no existe registrarlo
                $data_[] = array(
                    'prd_ano'=>$year,
                    'prd_mes'=>$j,
                    'prd_codigo'=>$codigo,
                    'prd_estado'=>1,
                    'prd_usu_crea'=>$usuario,
                    'prd_fecha_crea'=>$fecha,
                    'prd_usu_mod'=>$usuario,
                    'prd_fecha_mod'=>$fecha 
                );
            }
        }        
        if(count($data_)>0) {
            //realizar los insert
            $n=  $this->gsatelite->ingresar('prd_periodo_deprec',$data_,true); 
        }
        return $n;
    }

    function eliminar_periodos($year=null) {
        $exito=0;
        $q=$this->gsatelite->get_tabla('prd_periodo_deprec',array('prd_ano'=>$year));
        if(count($q)>0) {
                $this->db->join('prd_periodo_deprec', 'prd_id = dep_id_prd');
                $this->db->where('prd_ano', $year); 
            $q2=$this->gsatelite->get_tabla('dep_depreciacion');
            if(count($q2)<=0) {
                $exito=$this->gsatelite->borrado_general('prd_periodo_deprec',array('prd_ano'=>$year));
            }
        }
        return $exito;
    }

    public function desactivar_periodo($prdid) {
        $prd = $this->gsatelite->get_registro("prd_periodo_deprec", array("prd_id" => $prdid));
        $new = ($prd->prd_estado > 0) ? 0 : 1;
        $this->gsatelite->actualizar_array("prd_periodo_deprec", array("prd_estado" => $new, 'prd_fecha_mod' =>  date('Y-m-d H:i:s'), 'prd_usu_mod' => $this->tank_auth->get_user_id()), array("prd_id" => $prdid));
        $this->gsatelite->show_dialog('Período procesado de forma correcta', 'activo/catalogo_activo/generar_periodo');
    }


    /**
    * @author Elman Ortiz
    * @date 17/08/2017
    */
    function caracteristicas_agregar(){        
        satelite_validar();        
        if ($this->input->post('tipoboton') == 'cancel') {
            redirect('activo/catalogo_activo/caracteristicas');
        }
        if ($this->input->post()) {//Para guardar las caracteristicas            
            //Crear arreglo caracteristicas 
            $caracteristica_array = array(
                'car_codigo' => ($this->input->post('car_codigo')) ? $this->input->post('car_codigo') : null,
                'car_nombre' => $this->input->post('inpNombre'),
                'car_descripcion' => $this->input->post('inpDescripcion'),
                'car_tipo' => $this->input->post('slcTipo'),
                'car_aplica_reporte' => ($this->input->post('aplica_rpt') != "") ? $this->input->post('aplica_rpt') : 0,
                'car_estado' => 1,
                'car_usu_crea' => $this->tank_auth->get_user_id(),
                'car_fecha_crea' => date('Y-m-d H:i:s'),
                'car_usu_mod' => $this->tank_auth->get_user_id(),
                'car_fecha_mod' => date('Y-m-d H:i:s')
            );
            $car_id = $this->gsatelite->ingresar('car_caracteristica', $caracteristica_array);
            $lista = $this->input->post('valores');           
            if ($lista) {
                //$elem = " ";
                foreach ($lista as $key => $value) {                    
                    //vrl_valores_lista
                    $valores_lista_array = array(                
                        'vrl_id_car' => $car_id,
                        'vrl_valor' => $value,
                        'vrl_estado' => 1,
                        'vrl_usu_creacion' => $this->tank_auth->get_user_id(),
                        'vrl_fecha_creacion' => date('Y-m-d H:i:s'),
                        'vrl_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'vrl_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $result = $this->gsatelite->ingresar('vrl_valores_lista', $valores_lista_array);
                }                                
            }/*else{
                //vrl_valores_lista
                $valores_lista_array = array(                
                    'vrl_id_car' => $car_id,
                    'vrl_valor' => ($this->input->post('inpValorUnico')) ? $this->input->post('inpValorUnico') : null,
                    'vrl_estado' => 1,
                    'vrl_usu_creacion' => $this->tank_auth->get_user_id(),
                    'vrl_fecha_creacion' => date('Y-m-d H:i:s'),
                    'vrl_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'vrl_fecha_modificacion' => date('Y-m-d H:i:s')
                );  
            }*/
            if ($car_id > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Agregar caracteristica", 'texto_alerta' => "El registro se guardó correctamente.");
            }else{
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Agregar caracteristica", 'texto_alerta' => "Ocurrio un problema al crear el registro.");
            }
            $this->session->set_flashdata($alerta);
            if ($this->input->post('tipoboton') == 'save') {
                redirect('activo/catalogo_activo/caracteristicas_agregar/');
            } else {
                redirect('activo/catalogo_activo/caracteristicas/');
            }
        }else{//Mostrar vista para caracteristicas            
            $last = $this->inventario_model->get_max_codigo('car_caracteristica', 'car_codigo');
            $code = $last->codigo;
            $cod = (int) $code + 1;
            $codigo = str_pad($cod, 3, '0', STR_PAD_LEFT); 
            $data['titulo_personal'] = "Catálogo de características";
            $data['codigo'] = $codigo;
            $this->_cargarvista($data);
        }
    }

    /**
     * @author Elman Ortiz
     * @date 17/08/2017
     */
    function caracteristicas_ver($car_id){                                    
        satelite_validar();    
        $carac = $this->inventario_model->get_caracteristicas($car_id);
        $data['caracteristica'] = $carac;
        $data['titulo_personal'] = "Ver características";                    
        $this->_cargarvista($data);
    }

  /**
   * @author Elman Ortiz
   * @date 17/08/2017
   */
  function caracteristicas_eliminar($car_id){        
    $tbl_vrl = $this->gsatelite->get_tabla('vrl_valores_lista', array('vrl_id_car' => $car_id));        
    $result1 = $this->gsatelite->borrado_general('vrl_valores_lista', array('vrl_id_car' => $car_id));        
    $result2 = $this->inventario_model->delete_caracteristica(array('car_id' => $car_id));        
    if ($result2 < 1 && count($tbl_vrl) > 0) {//No se pudo borrar y reversion de los datos eliminados
        $vrl_array = array(                
            'vrl_id_car' => $tbl_vrl[0]['vrl_id_car'],
            'vrl_valor' => $tbl_vrl[0]['vrl_valor'],                
            'vrl_estado' => $tbl_vrl[0]['vrl_estado'],
            'vrl_usu_modificacion' => $tbl_vrl[0]['vrl_usu_modificacion'],
            'vrl_fecha_modificacion' => $tbl_vrl[0]['vrl_fecha_modificacion'],
            'vrl_usu_creacion' => $tbl_vrl[0]['vrl_usu_creacion'],
            'vrl_fecha_creacion' => $tbl_vrl[0]['vrl_fecha_creacion']
        );
        $registro = $this->gsatelite->ingresar('vrl_valores_lista', $vrl_array);
        $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Eliminar caracteristica", 'texto_alerta' => "No se puede eliminar porque esta asignado.");
    }else{
        if($result2 == 0){
            $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Eliminar caracteristica", 'texto_alerta' => "No se puede eliminar porque esta asignado.");
        }else{
            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Eliminar caracteristica", 'texto_alerta' => "El registro se elimino correctamente.");
        }            
    }
    $this->session->set_flashdata($alerta);
    redirect('activo/catalogo_activo/caracteristicas');
  }

    /**
     * @author Elman Ortiz
     * @date 21/08/2017
     */
    function caracteristicas_editar($car_id = null){        
        satelite_validar();
        if($_POST){//Guardar datos
            $car_id = $this->input->post('car_id');            
            //Crear arreglo caracteristicas            
            $caracteristica_array = array(
                'car_codigo' => ($this->input->post('car_codigo')) ? $this->input->post('car_codigo') : null,
                'car_nombre' => $this->input->post('inpNombre'),
                'car_descripcion' => $this->input->post('inpDescripcion'),
                'car_tipo' => $this->input->post('slcTipo'),
                'car_aplica_reporte' => $this->input->post('aplica_rpt'),
                'car_estado' => $this->input->post('slcEstado'),
                'car_usu_crea' => $this->tank_auth->get_user_id(),
                'car_fecha_crea' => date('Y-m-d H:i:s'),
                'car_usu_mod' => $this->tank_auth->get_user_id(),
                'car_fecha_mod' => date('Y-m-d H:i:s')
            );
            $this->gsatelite->actualizar_array('car_caracteristica', $caracteristica_array, array('car_id'=>$car_id));
            $res = $this->gsatelite->borrado_general('vrl_valores_lista', array('vrl_id_car' => $car_id));                            
            $lista = $this->input->post('valores');
            //print_r(count($lista)); die();
            if ($lista) {           
                foreach ($lista as $key => $value) {                    
                    $valores_lista_array = array(                
                        'vrl_id_car' => $car_id,
                        'vrl_valor' => $value,
                        'vrl_estado' => 1,
                        'vrl_usu_creacion' => $this->tank_auth->get_user_id(),
                        'vrl_fecha_creacion' => date('Y-m-d H:i:s'),
                        'vrl_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'vrl_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $result = $this->gsatelite->ingresar('vrl_valores_lista', $valores_lista_array);
                }                
            }
            if ($car_id > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Agregar caracteristica", 'texto_alerta' => "El registro se guardó correctamente.");
            }else{
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Agregar caracteristica", 'texto_alerta' => "Ocurrio un problema al crear el registro.");
            }
            $this->session->set_flashdata($alerta);            
            if ($this->input->post('tipoboton') == 'save') {
                redirect('activo/catalogo_activo/caracteristicas_editar/'.$car_id);
            } else {
                redirect('activo/catalogo_activo/caracteristicas/');
            }
        }else{//Cargar datos
                     $this->db->join('vrl_valores_lista','car_id = vrl_id_car','left');
            $carac = $this->gsatelite->get_tabla('car_caracteristica', array('car_id' => $car_id));
            $data['caracteristica'] = $carac;
            $data['car_id'] = $car_id;
            $data['car_codigo'] = $carac[0]['car_codigo'];
            $data['titulo_personal'] = "Editar características";                    
            $this->_cargarvista($data);
        }            
    }//caracteristicas editar

    /**
        * @author Habby Lovo
        * @date 25/09/2017
    */
    function motivo_baja(){
    if(!$this->tank_auth->is_logged_in()){
            redirect('/auth/login/');
        } else {
            $permisos = $this->gsatelite->get_permisos_opcion('activo/catalogo_activo/motivo_baja');
            
            $crud =  new grocery_CRUD();
            $crud->set_subject('Motivo de baja')->set_table('mba_motivo_baja_activo');
            $crud->columns('mba_nombre', 'mba_descripcion', 'mba_estado');
            $crud->display_as('mba_nombre', 'Nombre')
            ->display_as('mba_descripcion', 'Descripción')
            ->display_as('mba_estado', 'Estado');
            $crud->add_fields('mba_nombre','mba_descripcion','mba_estado','mba_usu_modificacion','mba_fecha_modificacion','mba_usu_creacion','mba_fecha_creacion');
            $crud->edit_fields('mba_nombre','mba_descripcion','mba_estado','mba_usu_modificacion','mba_fecha_modificacion');
            $crud->required_fields('mba_nombre','mba_estado');
            $crud->set_rules('mba_nombre','nombre','trim|required|campo_unico[mba_motivo_baja_activo.mba_nombre]');
            $crud->set_rules('mba_estado','estado','trim|required');
            $crud->field_type('mba_usu_creacion','hidden',$this->tank_auth->get_user_id());
            $crud->field_type('mba_usu_modificacion','hidden',$this->tank_auth->get_user_id());
            $crud->field_type('mba_fecha_creacion','hidden',date('Y-m-d H:i:s'));
            $crud->field_type('mba_fecha_modificacion','hidden',date('Y-m-d H:i:s'));
            if(end(explode('/',uri_string()))=='add') {
                $crud->field_type('mba_estado','hidden',1);
            }else {
                $crud->field_type('mba_estado','dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }
            
            if(!$permisos["permite_editar"]){
                $crud->unset_edit();
            }
            if(!$permisos["permite_eliminar"]){
                $crud->unset_delete();
            }
            if(!$permisos["permite_agregar"]){
                $crud->unset_add();
            }
            if($permisos["permite_ver"]){
                $crud->add_action('&nbsp;&nbsp;Ver', '', 'activo/catalogo_activo/motivo_baja/read','icomoon-icon-search-3');
            }
            $output = $crud->render();
            $data['titulo_personal']="Motivos de baja";
            $this->_cargarvista($data, $output);
        }
    }
  
  public function new_crud() {
        $db_driver = $this->db->platform();
        $model_name = 'grocery_crud_model_' . $db_driver;
        $model_alias = 'm' . substr(md5(rand()), 0, rand(4, 15));

        unset($this->{$model_name});
        $this->load->library('grocery_CRUD');
        $crud = new Grocery_CRUD();
        if (file_exists(APPPATH . '/models/' . $model_name . '.php')) {
            $this->load->model('grocery_crud_generic_model');
            $this->load->model($model_name, $model_alias);
            $crud->basic_model = $this->{$model_alias};
        }
        return $crud;
    }

	function _cargarvista($data=0,$crud=0)
	{	
		$this->load->view('vacia',$crud);	
		if($data!=0)
			$data=array_merge($data,$this->masterpage->getUsuario());
		else
			$data=$this->masterpage->getUsuario();
		$vista=$data['modulo'].'/'.$data['control'].'/'.$data['funcion'];
		$this->masterpage->setMasterPage('masterpage_default');
		$this->masterpage->addContentPage($vista, 'content',$data);
		$this->masterpage->show();
	}
        
        
    public function proveedores($consulta = null) {
        satelite_validar();

        $this->load->library('../controllers/modulo_compras/catalogos');
        $this->catalogos->proveedores(null,array('activo/catalogo_activo/proveedores','modulo_compras/catalogos/proveedores'));
        die('éxito');

        try {
            if ($consulta) {
                $post_array = $this->input->post();
                $data = null;
                $personeria = $post_array['personeria'];
                $actividad_eco = $post_array['actividad'];
                $data['permisos'] = $this->gsatelite->get_permisos_opcion('modulo_compras/catalogos/proveedores');
                $where = null;
                if ($personeria != '') {
                    $where['prv_tipo_pers'] = $personeria;
                }
                if ($actividad_eco != '') {
                    $where['prv_id_acp'] = $actividad_eco;
                }

                $data['proveedores'] = $this->cuentas_pagar_model->get_proveedores($where);
                //var_dump($data['permisos']);die();
                $html = $this->load->view('modulo_cuentas_pagar/catalogo/consultar_proveedores', $data, true);

                echo $html;
                die();
            }
            $data['permisos'] = $this->gsatelite->get_permisos_opcion('modulo_compras/catalogos/proveedores');
            $data['actividades_eco'] = $this->gsatelite->get_dropdown('acp_act_economica_prov', 'acp_nombre', 'actividades', array('acp_estado' => 1), null, null, null, true);
            $data['titulo_personal'] = "Mantenimiento de Proveedores";
            $this->_cargarvista($data);
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }
    
     public function agregar_proveedor() {
        satelite_validar();
        $this->load->library('../controllers/modulo_compras/catalogos');
        $this->catalogos->agregar_proveedor(null,array('activo/catalogo_activo/proveedores','modulo_compras/catalogos/agregar_proveedor'));
        die('éxito');
        $data['permisos'] = $this->gsatelite->get_permisos_opcion('modulo_cuentas_pagar/catalogo/proveedores', 'agregar');        
        $this->load->library('../controllers/modulo_compras/catalogos',NULL,'catalogo_compras');
        $informacion = $this->catalogo_compras->agregar_proveedor('cuentas');        
        $data['html']=$this->load->view('modulo_compras/catalogos/agregar_proveedor',$informacion, true);                        
        $this->_cargarvista($data);
    }
    
    public function editar_proveedor($prv_id){
        satelite_validar();
        $this->load->library('../controllers/modulo_compras/catalogos');
        $this->catalogos->editar_proveedor($prv_id,null, array('activo/catalogo_activo/proveedores','modulo_compras/catalogos/editar_proveedor'));
        die('éxito');


        $data['permisos'] = $this->gsatelite->get_permisos_opcion('modulo_cuentas_pagar/catalogo/proveedores', 'editar');
        $this->load->library('../controllers/modulo_compras/catalogos',NULL,'catalogo_compras');
        $informacion = $this->catalogo_compras->editar_proveedor($prv_id,'cuentas');
        $data['html']=$this->load->view('modulo_compras/catalogos/editar_proveedor',$informacion, true);
        $this->_cargarvista($data);
    }

    public function tipo_mejora() {
        try{
            $crud = new grocery_CRUD();
            $permisos = $this->gsatelite->get_permisos_opcion();
            $columns = array('tpm_nombre', 'tpm_descripcion', 'tpm_estado');
            $add_columns = array('tpm_codigo','tpm_nombre','tpm_descripcion','tpm_estado','tpm_usu_creacion','tpm_usu_modificacion','tpm_fecha_creacion','tpm_fecha_modificacion');
            $edit_columns = array('tpm_codigo','tpm_nombre','tpm_descripcion','tpm_estado','tpm_usu_modificacion','tpm_fecha_modificacion');
            $alias = array(
                'tpm_codigo' => 'Código',
                'tpm_nombre' => 'Nombre',
                'tpm_descripcion' => 'Descripción',
                'tpm_estado' => 'Estado'
            );
            $urlx = explode('/', uri_string());
            if (end($urlx) == 'add') {
                $crud->field_type('tpm_estado', 'hidden', 1);
                $crud->field_type('tpm_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
                $crud->field_type('tpm_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
            } else {
                $crud->field_type('tpm_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }
            $crud->field_type('tpm_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'));
            $crud->field_type('tpm_usu_modificacion', 'hidden', $this->tank_auth->get_user_id());
            $crud->set_table('tpm_tipo_mejora')
                ->set_subject('Mejora')
                ->columns($columns)
                ->add_fields($add_columns)
                ->edit_fields($edit_columns)
                ->display_as($alias)
                ->required_fields(array('tpm_nombre'))
            ;
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_ver']) {
                $crud->unset_read();
                $crud->unset_print();
                $crud->unset_export();
            }
            $output = $crud->render();
            $data['titulo_personal'] = "Tipos de Mejoras";
            $this->_cargarvista($data,$output);
        } catch(Exception $e){
            show_error($e->getMessage().' --- '.$e->getTraceAsString());
        }
    }

    public function get_niveles_hijos($id_padre=null){
        $cadena_ids = "";
        $q = $this->gsatelite->get_tabla('are_area', array('are_estado' => 1, 'are_id_emr' => $this->tank_auth->get_empresa_id(), 'are_padre' => $id_padre));
        if ($q){
            foreach ($q as $fila) {
                $cadena_ids .= $fila['are_id'] . ',';
                $cadena_ids .= $this->get_niveles_hijos($fila['are_id']);
            }
        }
        return $cadena_ids;
    }
    public function delete_mxr($primary_key) {
        $this->db->where('mxr_id_are', $primary_key);
        $this->db->delete('mxr_empresaxarea');
        return true;
    }
    function verificar_nivel() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $id = $this->input->post('id');
            if ($id > 0) {
                $pregunta = $this->gsatelite->get_tabla('are_area', array('are_id' => $id));
                //nivel hijo
                $nivel = $pregunta[0]['are_nivel'] + 1;
                echo json_encode(array('nivel' => $nivel));
            }
        }
    }

    /**
    *@author: Nelson Soriano
    *@since:  08-04-2019
    *@Descripcion: Mantenimiento de centro de costos
    **/
    public function centro_costos(){
      satelite_validar();
       if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            try {
                $permisos = $this->gsatelite->get_permisos_opcion();
                $crud = new grocery_CRUD();
                $crud->set_table('cec_centro_costo')
                        ->set_subject('Centro de costo')
                        //->columns('cec_nombre', 'cec_observacion', 'cec_cuenta_contable', 'cec_estado')
                        ->columns('cec_nombre', 'cec_observacion', 'cec_estado')
                        //->fields('cec_nombre', 'cec_observacion', 'cec_cuenta_contable', 'cec_estado', 'cec_usu_mod', 'cec_fecha_mod')
                        ->fields('cec_nombre', 'cec_observacion', 'cec_estado', 'cec_usu_mod', 'cec_fecha_mod')
                        ->display_as('cec_nombre', 'Nombre')
                        ->display_as('cec_observacion', 'Observación')
                        ->display_as('cec_cuenta_contable', 'Cuenta Contable')
                        ->display_as('cec_estado', 'Estado')
                        ->required_fields('cec_nombre', 'cec_estado')
                        ->set_rules('cec_nombre', 'Nombre', 'trim|required|campo_unico[cec_centro_costo.cec_nombre]')
                        ->field_type('cec_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                        ->field_type('cec_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                ;
                if (end(explode('/', uri_string())) == 'add') {
                    $crud->field_type('cec_estado', 'hidden', 1);
                } else {
                    $crud->field_type('cec_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
                }

                 // Validaciones
                if (!$permisos['permite_agregar']) {
                    $crud->unset_add();
                }

                if (!$permisos['permite_editar']) {
                    $crud->unset_edit();
                }

                if (!$permisos['permite_eliminar']) {
                    $crud->unset_delete();
                }

                if ($permisos['permite_ver']) {
                    $crud->add_action('Ver', 'minia-icon-search', 'modulo_compras/catalogos/centro_costos/read');
                }

                $data['titulo_personal'] = "Centro de costos";

                $output = $crud->render();
                $this->_cargarvista($data, $output);
            } catch (Exception $e) {
                show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
            }
        }
    }

    public function ubicacion_activo(){
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();
        try{
            $crud = new grocery_CRUD();
            $urlx = explode('/', uri_string());
            $columns = array(
                'uba_codigo',
                'uba_nombre',
                'uba_estado'
            );
            $alias = array(
                'uba_codigo' => 'Código',
                'uba_nombre' => 'Nombre',
                'uba_estado' => 'Estado'
            );
            $add_columns = array(
                'uba_codigo',
                'uba_nombre',
                'uba_estado',
                'uba_user_crea',
                'uba_fecha_crea',
                'uba_user_mod',
                'uba_fecha_mod'
            );
            $edit_columns = array(
                'uba_codigo',
                'uba_nombre',
                'uba_estado',
                'uba_user_mod',
                'uba_fecha_mod'
            );
            $crud->set_table('uba_ubicacion_activo')
                ->set_subject('Ubicación')
                ->columns($columns)
                ->display_as($alias)
                ->add_fields($add_columns)
                ->edit_fields($edit_columns)
                ->required_fields('uba_nombre')
                ->field_type('uba_user_mod','hidden',$this->tank_auth->get_user_id())
                ->field_type('uba_fecha_mod','hidden',date('Y-m-d h:i:s'))
                ->set_rules('uba_nombre','Nombre', 'trim|required|campo_unico[uba_ubicacion_activo.uba_nombre]')
            ;
            if (end($urlx) == 'add') {
                $crud->field_type('uba_estado', 'hidden', 1)
                    ->field_type('uba_user_crea', 'hidden', $this->tank_auth->get_user_id())
                    ->field_type('uba_fecha_crea', 'hidden', date('Y-m-d h:i:s'));
            } else {
                $crud->field_type('uba_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            if (!$permisos['permite_ver']) {
                $crud->unset_read();
                $crud->unset_print();
                $crud->unset_export();
            }
            $output = $crud->render();
            $data['titulo_personal'] = "Ubicaciones";
            $this->_cargarvista($data,$output);
        } catch(Exception $e){
            show_error($e->getMessage().' --- '.$e->getTraceAsString());
        }
    }

}  
/* End of file vales_crud.php */
/* Location: ./application/controllers/transporte/vales_crud.php */