<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Baja extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->model('activo_fijo');
	}

	public function index()
	{
		//Verificar Permisos de acceso
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            //$this->output->enable_profiler(ENVIRONMENT == 'development'); //Testing
        	//Preparar informacion a mostrar en la vista
        	$data['activos'] = $this->activo_fijo->get_registros_where( 'act_activo_fijo', array( 'act_estado' => 1 ) );
            //Cargar vista 
            $this->_cargarvista(null, $data);
        }
	}
    
    public function dar_baja_obs()
    {
        $data['registro'] = $this->input->post('id_activo');
        $this->load->view('activo/baja/obs', $data);
    }

	public function dar_baja_activo()
	{

	    $id_activo = $this->input->post('id_activo');
        $obs = $this->input->post('obs');

	    $result = $this->activo_fijo->set_baja_activo( $id_activo, $obs );

	    if( $result ){
	       $this->gsatelite->show_dialog('Dado de Baja.', 'activo/baja/');
	    }else{
	       $this->gsatelite->show_dialog('Dado de Baja.', 'activo/baja/', 'error');
	    }

	}
    
        /**
     * @author Alexis Beltran
     */
    public function ver_activos()
    {
        //(new Procesos())->validar_user();
    	try{
            $area = $this->gsatelite->get_campo('empleados', 'are_nombre', array(
                'usu_id' => $this->tank_auth->get_user_id()
            ));
            
            
            //$destinos = $this->get_detalle_accion();
            
            $data = array(
                'solicitante'   => $this->gsatelite->get_campo('empleados', 'nombre_completo', array('usu_id' => $this->tank_auth->get_user_id()) ),
                'area'          => $area,
            ); 
           $this->_cargarvista($data, 0, true);
    	}catch(Exception $e){
    		show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
    	}
    }
    
    /**
     * @author Alexis Beltran
     */
    function get_activos()
    {
        $emp_id = $this->input->post('emp_id');
        //$exd_id = $this->input->post('exd_id');
        if( $emp_id /*|| $exd_id*/ ){
            
            if( is_numeric($emp_id) ){
                $this->db->where('emp_id', $emp_id);
            }
            /*
            if( $exd_id ){
                $pro_id = $this->gsatelite->get_campo('pro_proceso', 'pro_id', array('pro_id_exd' => $exd_id));
                if( $pro_id > 0 ){ $this->db->where('pro_id', $pro_id); }
            }
            */
            $datos =  $this->db->get('vw_activos')->result();
            
            foreach($datos as $row){
            ?>
        <tr>
            <td><?php echo $row->saf; ?></td>
            <td><?php echo $row->codigo; ?></td>
            <td><?php echo $row->nombre; ?></td>
            <td><?php echo number_format($row->valor,2); ?></td>
            <td><span class="custom_checkbox checkbox_1 mint"><input type="checkbox" name="activos[]" value="<?php echo $row->act_id; ?>" /></span></td>
        </tr>
            <?php
            }   
        }
    }
    
    public function save_traslado()
    {
        $activos    = $this->input->post('activos');
        $emp_id     = $this->input->post('emp_id');
        $ubi_id     = $this->input->post('ubi_id');
        $obs        = $this->input->post('obs');
        $usu_id     = $this->tank_auth->get_user_id();
        
        if( is_array($activos) && ( $emp_id || $ubi_id  ) ){
            
            if( is_numeric($emp_id) && $emp_id > 0 ){
                $empleado = $this->gsatelite->get_registro('vw_empleados', array('emp_id' => $emp_id));
            }
            
            //print_r($empleado);
            
            foreach( $activos as $activo ){
                if( !isset($empleado) ){
                    echo $activo;
                    $this->db->select("vw_empleados.*")->join('vw_empleados', 'vw_activos.emp_id = vw_activos.emp_id');
                    $empleado = $this->gsatelite->get_registro('vw_activos', array('act_id' => $activo));
                }
                //print_r($empleado);
                
                $this->db->update('axe_activoxempleado', 
                    array('axe_estado' => 0, 'axe_use_mod' => $usu_id), array('axe_id_act' => $activo));
                $this->db->insert('axe_activoxempleado', array(
                    'axe_id_act'    => $activo,
                    'axe_id_emp'    => $empleado->emp_id,
                    'axe_id_are'    => $empleado->are_id,
                    'axe_id_are'    => ($ubi_id)? $ubi_id : $empleado->ubi_id,
                    'axe_fecha'     => date('Y-m-d'),
                    'axe_obs'       => $obs,
                    'axe_use_mod'   => $usu_id
                ));
            }
            
            //$this->db->join('vw_empleados', 'vw_activos.emp_id = vw_activos.emp_id');
            $this->db->where_in('act_id', $activos);
            $activos_data =  $this->db->get('vw_activos')->result();
            
            //print_r($activos_data);
            
            $this->load->library('pdf');
            $html  = $this->load->view('reporte/header', array('titulo' => 'Traslado de Activos'), true);
            $html .= $this->load->view('activo/traslado/reporte', array('activos' => $activos_data), true);
            $this->pdf->setPageOrientation('P');
            $this->pdf->makePDF($html);
            
            //$this->gsatelite->show_dialog('Activos Trasladados.', 'activo/traslado/ver_activos');
        }else{
            $this->gsatelite->show_dialog('Activos Trasladados.', 'activo/traslado/ver_activos', 'error');
        }
    }

	/**
     * Cargar vista del controlador
     * 
     * @param integer $data
     * @param integer $crud
     * @return HTML vista del controlador
     */
    function _cargarvista($data=0,$crud=0)
    {   
        $this->load->view('vacia',$crud);   
        if($data!=0)
            $data=array_merge($data,$this->masterpage->getUsuario());
        else
            $data=$this->masterpage->getUsuario();
        $vista=$data['modulo'].'/'.$data['control'].'/'.$data['funcion'];
        $this->masterpage->setMasterPage('masterpage_default');
        $this->masterpage->addContentPage($vista, 'content',$data);
        $this->masterpage->show();
    }

}

/* End of file baja.php */
/* Location: ./application/controllers/baja.php */