<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Principal extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->library('grocery_CRUD');
        $this->load->library('tank_auth');
        $this->load->model('gsatelite');
        $this->load->model('planilla_model');
        $this->load->model('personal_model');
        $this->load->model('accion_personal_model');
        $this->load->model('expediente_personal_model');
        $this->load->model('estructura_organizativa_model');
        $this->load->library('EnLetras');
        $this->load->library('pdf');
    }

    public function listado_empleados() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $permisos = $this->gsatelite->get_permisos_opcion();
            $data["permisos"] = $permisos;
            $data['total_empleados'] = $this->personal_model->listado_empleados(array('emp_estado'=>1));
            $data['titulo_personal'] = "Acciones de Personal";
            $this->_cargarvista($data, null);
        }
    }

    //@author René Castaneda
    public function gestion_horas_extras($id_empleado = null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $permisos = $this->gsatelite->get_permisos_opcion('acciones_personal/principal/empleado_tiempo_trabajado');
            $data['permisos'] = $permisos;
            $this->verifica_empleado_real($id_empleado);
            $registro_empleado = $this->gsatelite->get_tabla('emp_empleado', array('emp_id' => $id_empleado));
            $data["info_empleado"] = $registro_empleado;
            $data["titulo_personal"] = "Horas extras";  
            $data["consulta"] = $this->accion_personal_model->get_horas_extras(array('hxe_id_emp' => $id_empleado));
            $data["id_empleado"] = $registro_empleado[0]['emp_id'];
            $this->_cargarvista($data, null);
        }
    }

    /**
    * @author Raul Escalante
    * @since  Sep/2020
    * Descripcion: Grid con las incapacidades de un empleado
    */
    public function gestion_incapacidad($emp_id = null) {
        satelite_validar();
                                 $this->db->join('pla_planilla', 'pla_id = inc_id_pla', 'left');
        $data['incapacidades'] = $this->gsatelite->get_tabla('inc_incapacidad', array('inc_id_emp' => $emp_id, 'inc_estado' => 1)); 
        $empleado = $this->gsatelite->get_tabla('emp_empleado', array('emp_id' => $emp_id));
        $data['permisos'] = $this->gsatelite->get_permisos_opcion('incapacidad_empleado');
        $data['emp'] = $empleado[0];
        $data['titulo_personal'] = "Gestión de Incapacidad";
        $this->_cargarvista($data);                
    }

    public function agregar_incapacidad($id = null) {
        satelite_validar();
        $id_emple = $id;
        $data['info'] = $this->personal_model->info_empleado($id);
        $ids_tpl = array(0);
        $pregunta = $this->gsatelite->get_tabla('txe_tipo_planillaxempleado', array('txe_id_emp' => $id));
        foreach ($pregunta as $fila) {
            $ids_tpl[] = $fila['txe_id_tpl'];
        }
        $this->db->where_in('tpl_id', $ids_tpl);
        $select = $this->gsatelite->get_dropdown('tpl_tipo_planilla', '{tpl_nombre}', '', null, null, '', 'tpl_id', true);
        $data["select_tpl_id"] = str_replace('<option value="0">Seleccione</option>', '', $select);
        $id_descuento_isss = $this->gsatelite->get_parametro('DESCUENTO_ISS');
        $configuracion_incapacidad = explode('##', $this->gsatelite->get_parametro('CONFIGURACION_INCAPCIDAD_EMPLEADO'));
        $data['n_dias_cubierto_empresa'] = $configuracion_incapacidad[0];
        $data['porcentaje_n_dias_cubierto_empresa'] = $configuracion_incapacidad[1];
        $data['porcentaje_n_dias_cubierto_empresa_adicionales'] = $configuracion_incapacidad[2];
        $data['porcentaje_n_dias_cubierto_seguro_adicionales'] = $this->gsatelite->get_parametro('PORCENTAJE_INCAPACIDA_SEGURO');
        $data['tnc'] = $this->gsatelite->get_dropdown('tnc_tipo_incapacidad', '{tnc_nombre}', '', array('tnc_estado' => 1), null, '', 'tnc_id', true);
        $data['salario_base_calculo'] = $registro_isss = $this->gsatelite->get_tabla('tdc_tipo_descuento', array('tdc_id' => $id_descuento_isss));
        $data["salary_by_incomes"] = $salary_by_incomes = $this->planilla_model->get_salary_from_incomes($id_emple);
        // preguntar si el salario del empleado no sobrepasa el techo permitido para cálculo del isss
        $salario_base = ($data['info'][0]['emp_salario'] > 0) ? $data['info'][0]['emp_salario'] : $salary_by_incomes;// ;
        $salario_base_calculo = ($salario_base > $registro_isss[0]['tdc_maximo']) ? $registro_isss[0]['tdc_maximo'] : $salario_base;
        $data['salario_base_calculo'] = $salario_base_calculo;
        $data['salario_base_empleado'] = $salario_base;
        $data["titulo_personal"] = "Procesar incapacidad";
        $data['id_emple'] = $id_emple;
        $this->_cargarvista($data, null);
    }

    public function edit_incapacidad($emp_id, $inc_id){
        satelite_validar();
        if ($_POST) {
            $pdo_inc = ($this->input->post('periodo_incapacidad') > 0) ? $this->input->post('periodo_incapacidad') : 0;
            $registro_periodo = $this->gsatelite->get_tabla('pla_planilla', array('pla_id' => $pdo_inc));
            $tinc = $this->gsatelite->get_registro('tnc_tipo_incapacidad', array('tnc_id' => $this->input->post('tnc')));
            if (count($registro_periodo) > 0) {
                $fecha_inicio = $registro_periodo[0]['pla_fecha_inicio'];
                $fecha1 = date("Y-m-d", strtotime("$fecha_inicio +1 day"));
            } else {
                $fecha1 = date("Y-m-d");
            }
            $aplica_planilla = ($this->input->post('show_planillas') > 0) ? true : false;
            $estado_planilla = $this->input->post('plan_estado');
            $emp = $this->input->post('empleado_id');
            if ($aplica_planilla) {
                if ($estado_planilla != 3) {
                    $inn_id_actual = $this->input->post('ingr_actual');
                    $id_tipo_ingreso_incapacidad = ($tinc->tnc_id_tig != "") ? $tinc->tnc_id_tig : $this->gsatelite->get_parametro('ID_TIPO_INGRESO_INCAPACIDAD');
                    if (trim($this->input->post('tipo_inns')) != "") {
                        $innXrow = explode("&&", $this->input->post('tipo_inns'));
                        $hay_inn_payed = $this->gsatelite->get_tabla('inn_ingreso', array('inn_cuota_pagada > ' => 0, 'inn_id_inc' => $inc_id));
                        if (count($hay_inn_payed) > 0) {
                            $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Incapacidad / Planilla", 'texto_alerta' => "Ingreso ya aplicado. No puede editarse.");
                            $this->session->set_flashdata($alerta);
                            redirect('acciones_personal/principal/gestion_incapacidad/' . $emp);
                        }
                        if (count($innXrow) > 0) {
                            $hay_inns = $this->gsatelite->get_tabla('inn_ingreso', array('inn_id_inc' => $inc_id));
                            if (count($hay_inns) > 0) {
                                foreach ($hay_inns as $k => $val) {
                                    $tiene_detalle = $this->gsatelite->get_tabla('ddi_detalle_ingreso', array('ddi_id_inn' => $val["inn_id"]));
                                    if (count($tiene_detalle) > 0) {
                                        $this->gsatelite->borrado_general('ddi_detalle_ingreso', array('ddi_id_inn' => $val["inn_id"]));
                                        $this->gsatelite->borrado_general('inn_ingreso', array('inn_id' => $val["inn_id"]));
                                    }
                                }
                            }
                            foreach ($innXrow as $k => $val) {
                                $detaXrow = explode("##", $val);
                                $ingreso = array(
                                    'inn_id_emp' => $emp,
                                    'inn_id_inc' => $inc_id,
                                    'inn_id_tpl' => $this->input->post('tipo_planilla_incapacidad'),
                                    'inn_id_tig' => ($detaXrow[0] > 0)? $detaXrow[0] : $id_tipo_ingreso_incapacidad,
                                    'inn_motivo' => $this->input->post('con_incapacidad'),
                                    'inn_observacion' => $this->input->post('observaciones_incapacidad'),
                                    'inn_permanente' => 0,
                                    'inn_valor' => $detaXrow[1],
                                    'inn_fecha_desde' => $fecha1,
                                    'inn_cuota' => 1,
                                    'inn_cuota_pagada' => 0,
                                    'inn_estado' => 1,
                                    'inn_fecha_crea' => date("Y-m-d H:i:s"),
                                    'inn_usu_crea' => $this->tank_auth->get_user_id(),
                                    'inn_fecha_mod' => date("Y-m-d H:i:s"),
                                    'inn_usu_mod' => $this->tank_auth->get_user_id()
                                );
                                $this->db->insert('inn_ingreso', $ingreso);
                            }
                        }
                        $inn_id = null;
                    } else {
                        $ingreso = array(
                            'inn_id_emp' => $emp,
                            'inn_id_tpl' => $this->input->post('tipo_planilla_incapacidad'),
                            'inn_id_tig' => $id_tipo_ingreso_incapacidad,
                            'inn_motivo' => $this->input->post('con_incapacidad'),
                            'inn_observacion' => $this->input->post('observaciones_incapacidad'),
                            'inn_permanente' => 0,
                            'inn_valor' => $this->input->post('monto_empresa'),
                            'inn_fecha_desde' => $fecha1,
                            'inn_cuota' => 1,
                            'inn_cuota_pagada' => 0,
                            'inn_estado' => 1,
                            'inn_fecha_mod' => date("Y-m-d H:i:s"),
                            'inn_usu_mod' => $this->tank_auth->get_user_id()
                        );                    
                        $cuota_pagada = $this->gsatelite->get_campo('inn_ingreso', 'inn_cuota_pagada', array('inn_id' => $inn_id_actual));
                        if ($cuota_pagada < 1) {
                            if ($inn_id_actual > 0) {
                                if ($tinc->tnc_id_tig != "") {
                                    $this->gsatelite->actualizar_array('inn_ingreso', $ingreso, array('inn_id' => $inn_id_actual));
                                    $inn_id = $inn_id_actual;
                                } else {
                                    $tiene_detalle = $this->gsatelite->get_tabla('ddi_detalle_ingreso',array('ddi_id_inn' => $inn_id_actual));
                                    if (count($tiene_detalle) > 0) {
                                        $this->gsatelite->borrado_general('ddi_detalle_ingreso', array('ddi_id_inn' => $inn_id_actual));
                                    }
                                    $this->gsatelite->actualizar_array('inc_incapacidad', array('inc_id_inn' => null), array('inc_id' => $inc_id));
                                    $this->gsatelite->borrado_general('inn_ingreso', array('inn_id' => $inn_id_actual));
                                    $inn_id = null;
                                }
                            }else{
                                if ($tinc->tnc_id_tig != "") {
                                    $inn_id = $this->gsatelite->ingresar('inn_ingreso', $ingreso);
                                }else{
                                    $inn_id = null;
                                }
                            }
                        } else {
                            $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Incapacidad / Planilla", 'texto_alerta' => "Ingreso ya aplicado. No puede editarse.");
                            $this->session->set_flashdata($alerta);
                            redirect('acciones_personal/principal/gestion_incapacidad/' . $emp);
                        }
                    }
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Incapacidad / Planilla", 'texto_alerta' => "Planilla Autorizada No Aplica Edición");
                    $this->session->set_flashdata($alerta);
                    redirect('acciones_personal/principal/gestion_incapacidad/' . $emp);
                }
            } else {
                $inn_id = null;
            }
            if (trim($this->input->post('fecha_final_incapacidad')) != "") {
                $f_fin_inc = formatear_fecha('Y-m-d', $this->input->post('fecha_final_incapacidad'));
            } else {
                $d = ($this->input->post('dias_incapacidad') - 1);
                $f_ini_inc = date("Y-m-d", strtotime($this->input->post('fecha_inicio_incapacidad')));
                $f_fin_inc = date("Y-m-d", strtotime("$f_ini_inc +$d day"));
            }
            $incapacidad = array(
                'inc_id_inn' => $inn_id,
                'inc_id_emp' => $emp,
                'inc_id_pla' => ($aplica_planilla) ? $this->input->post('periodo_incapacidad') : null,
                'inc_id_tnc' => ($this->input->post('tnc') > 0) ? $this->input->post('tnc') : null,
                'inc_dias' => $this->input->post('dias_incapacidad'),
                'inc_fecha_inicio' => date("Y-m-d", strtotime($this->input->post('fecha_inicio_incapacidad'))),
                'inc_fecha_fin' => $f_fin_inc,
                'inc_concepto' => $this->input->post('con_incapacidad'),
                'inc_base_calculo' => ($aplica_planilla) ? $this->input->post('salario_base_calculo') : 0,
                'inc_nuevo_salario_base' => ($aplica_planilla) ? $this->input->post('nuevo_salario_base') : 0,
                'inc_monto_empresa' => ($aplica_planilla) ? $this->input->post('monto_empresa') : 0,
                'inc_monto_seguro' => ($aplica_planilla) ? $this->input->post('monto_seguro') : 0,
                'inc_monto_pendiente' => ($aplica_planilla) ? $this->input->post('monto_empresa') : 0,
                'inc_observacion' => $this->input->post('observaciones_incapacidad'),
                'inc_estado' => 1,
                'inc_fecha_mod' => date("Y-m-d H:i:s"),
                'inc_usu_mod' => $this->tank_auth->get_user_id()
            );
            $update_inc = $this->gsatelite->actualizar_array('inc_incapacidad', $incapacidad, array('inc_id' => $inc_id));
            $ruta_anexos = $this->input->post('ruta');
            $titulo_anexo = $this->input->post('titulo_doc');
            if (!empty($ruta_anexos)) {
                for ($i = 0; $i < count($ruta_anexos); $i++) {
                    $extension = end(explode('.', $ruta_anexos[$i]));
                    $carpeta_temporal_anx = $ruta = "public/temp/anexos_incapacidades/" . trim($ruta_anexos[$i]);
                    $nombreArchivo = trim($titulo_anexo[$i]) . "." . trim($extension);
                    $carpeta_destino_anx = "uploads/anexos_incapacidades/" . $nombreArchivo;
                    $dir = $this->gsatelite->get_tabla('ain_anexo_incapacidad', array('ain_url' => $carpeta_destino_anx, 'ain_estado' => 1));
                    if (!(count($dir) > 0)) {
                        $documentos_array = array(
                            'ain_id_inc'             => $inc_id,
                            'ain_url'                => $carpeta_destino_anx,
                            'ain_nombre'             => $nombreArchivo,
                            'ain_estado'             => 1,
                            'ain_usu_creacion'       => $this->tank_auth->get_user_id(),
                            'ain_fecha_creacion'     => date('Y-m-d H:i:s'),
                            'ain_usu_modificacion'   => $this->tank_auth->get_user_id(),
                            'ain_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $ant_id = $this->gsatelite->ingresar('ain_anexo_incapacidad', $documentos_array);
                        if ($ant_id > 0) {
                            copy($carpeta_temporal_anx, $carpeta_destino_anx);
                            unlink($carpeta_temporal_anx);
                        }
                    }
                }
            }
            if (!empty($inn_id) && $update_inc > 0) {
                $ingreso = '<a href="'.base_url().'personal/empleado/ingreso_descuento_empleado/'.$emp.'/0"><b>ingresos y descuentos</b></a>';
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Incapacidad editada con éxito.", 'texto_alerta' => "Puede revisar el ingreso por incapacidad en  $ingreso");
                $this->session->set_flashdata($alerta);
            }elseif ($update_inc > 0 && !$aplica_planilla) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Incapacidad", 'texto_alerta' => "Incapacidad editada con éxito.");
                $this->session->set_flashdata($alerta);
            }else{
                if (empty($tinc->tnc_id_tig) && empty($inn_id) && !empty($update_inc)) {
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Incapacidad", 'texto_alerta' => "Incapacidad editada con éxito.");
                    $this->session->set_flashdata($alerta);
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "No se pudo editar la incapacidad", 'texto_alerta' => "Verifique la información a ingresar");
                    $this->session->set_flashdata($alerta);
                }
            }
            redirect('acciones_personal/principal/gestion_incapacidad/' . $emp);
        } else {
            $info_empleado = $this->personal_model->info_empleado($emp_id);
                           $this->db->join('pla_planilla', 'pla_id = inc_id_pla', 'left');
                           $this->db->join('inn_ingreso', 'inn_id = inc_id_inn', 'left');
            $incapacidad = $this->gsatelite->get_tabla('inc_incapacidad', array('inc_id' => $inc_id, 'inc_estado' => 1)); 
            $plan_x_emp = $this->gsatelite->get_tabla('txe_tipo_planillaxempleado', array('txe_id_emp' => $emp_id));
            $ids_tpl = array(0);
            foreach ($plan_x_emp as $fila) {
                $ids_tpl[] = $fila['txe_id_tpl'];
            }
            if ($incapacidad[0]['inn_id_tpl'] != "") {
                $slctpl = $incapacidad[0]['inn_id_tpl'];
            } else {
                $aplica = $this->gsatelite->get_campo('tnc_tipo_incapacidad', 'tnc_aplica_planilla', array('tnc_id' => $incapacidad[0]['inc_id_tnc']));
                if ($aplica > 0) {                    
                    $slctpl = $this->gsatelite->get_campo('pla_planilla', 'pla_id_tpl', array('pla_id' => $incapacidad[0]['inc_id_pla']));
                } else {
                    $slctpl = null;
                }
            }
                        $this->db->where_in('tpl_id', $ids_tpl);
            $selectpl = $this->gsatelite->get_dropdown('tpl_tipo_planilla', '{tpl_nombre}', '', null, $slctpl, '', 'tpl_id', true);
            $id_descuento_isss = $this->gsatelite->get_parametro('DESCUENTO_ISS');
            $registro_isss = $this->gsatelite->get_tabla('tdc_tipo_descuento', array('tdc_id' => $id_descuento_isss));
            $sl_pl ="";
            $planilla = $this->gsatelite->get_tabla('pla_planilla', array('pla_id_tpl' => $slctpl, 'pla_estado < ' => 3));
            foreach ($planilla as $key => $value) {
                $sltd = ($value['pla_id'] == $incapacidad[0]['inc_id_pla']) ? "selected" : "";
                $sl_pl .= '<option ' . $sltd . ' data-fec_ini="' . formatear_fecha('d-m-Y', $value['pla_fecha_inicio']) . '" data-fec_fin="' . formatear_fecha('d-m-Y', $value['pla_fecha_fin']);
                $sl_pl .= '" value="' . $value['pla_id'] . '">' . formatear_fecha('d-m-Y', $value['pla_fecha_inicio']) . ' -- ' . formatear_fecha('d-m-Y', $value['pla_fecha_fin']);
                $sl_pl .= ($value['pla_id'] < 2) ? " Creada" : " Generada";
                $sl_pl .= '</option>';
            }            
            $configuracion_incapacidad = explode('##', $this->gsatelite->get_parametro('CONFIGURACION_INCAPCIDAD_EMPLEADO'));
            $tncselct = $this->gsatelite->get_dropdown('tnc_tipo_incapacidad', '{tnc_nombre}', '', array('tnc_estado' => 1), $incapacidad[0]['inc_id_tnc'], '', 'tnc_id', true);
            $data['n_dias_cubierto_empresa'] = $configuracion_incapacidad[0];
            $data['porcentaje_n_dias_cubierto_empresa'] = $configuracion_incapacidad[1];
            $data['porcentaje_n_dias_cubierto_empresa_adicionales'] = $configuracion_incapacidad[2];
            $data['porcentaje_n_dias_cubierto_seguro_adicionales'] = $this->gsatelite->get_parametro('PORCENTAJE_INCAPACIDA_SEGURO');
            $data["select_tpl_id"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $selectpl); 
            $data["salary_by_incomes"] = $salary_by_incomes = $this->planilla_model->get_salary_from_incomes($emp_id);
            $data['emp'] = $info_empleado[0];
            $data['slc_planilla'] = $sl_pl;
            $data['id_emple'] = $emp_id;
            $data['tnc'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $tncselct); 
            $sueldo = ($info_empleado[0]['emp_salario'] > 0) ? $info_empleado[0]['emp_salario'] : $salary_by_incomes;//;
            $data['salario_base_calculo'] = ($sueldo > $registro_isss[0]['tdc_maximo']) ? $registro_isss[0]['tdc_maximo'] : $sueldo;
            $data['salario_base_empleado'] = $sueldo;
            $data["titulo_personal"] = "Editar incapacidad";
            $data["aplica_pla"] = $this->gsatelite->get_campo('tnc_tipo_incapacidad', 'tnc_aplica_planilla', array('tnc_id' => $incapacidad[0]['inc_id_tnc']));
            $data['anx'] = $this->gsatelite->get_tabla('ain_anexo_incapacidad', array('ain_id_inc' => $inc_id));
            $data['inc'] = $incapacidad[0];
            $this->_cargarvista($data, null);
        }        
    }

    public function ver_incapacidad($emp_id, $inc_id) {
        satelite_validar();
                       $this->db->join('inn_ingreso', 'inn_id = inc_id_inn', 'left'); //YA NO SE USA
        $incapacidad = $this->gsatelite->get_tabla('inc_incapacidad', array('inc_id' => $inc_id, 'inc_estado' => 1)); 
        $pla = $this->gsatelite->get_tabla('pla_planilla', array('pla_id' => $incapacidad[0]['inc_id_pla'])); 
        $ingresos = $this->gsatelite->get_tabla('inn_ingreso', array('inn_id_inc' => $inc_id));
        $estado = ($pla[0]['pla_estado'] > 2) ? 'Autorizada' : (($pla[0]['pla_estado'] > 1) ? 'Generada' : 'Creada');
        $data['anx'] = $this->gsatelite->get_tabla('ain_anexo_incapacidad', array('ain_id_inc' => $inc_id));
        $data['pla'] = '<option value="1" selected>'.formatear_fecha('d-m-Y',$pla[0]['pla_fecha_inicio']).'  --  '.formatear_fecha('d-m-Y',$pla[0]['pla_fecha_fin']).' '.$estado."</option>";
        $data['tnc'] = $this->gsatelite->get_dropdown('tnc_tipo_incapacidad', '{tnc_nombre}', '', array('tnc_estado' => 1), $incapacidad[0]['inc_id_tnc'], '', 'tnc_id', true);
        $data['tpl'] = $this->gsatelite->get_dropdown('tpl_tipo_planilla', '{tpl_nombre}', '', null, $incapacidad[0]['inn_id_tpl'], '', 'tpl_id', true);
        $data['emp'] = $this->personal_model->info_empleado($emp_id);
        $data['inc'] = $incapacidad[0];
        $data['inns'] = $ingresos;
        $data["titulo_personal"] = "Ver incapacidad";
        $this->_cargarvista($data, null);
    }

    public function del_inc($emp_id, $inc_id){
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
                        $this->db->join('inn_ingreso', 'inn_id = inc_id_inn', 'left');
                        $this->db->join('pla_planilla', 'pla_id = inc_id_pla', 'left');
            $incapaci = $this->gsatelite->get_tabla('inc_incapacidad', array('inc_id' => $inc_id, 'inc_estado' => 1)); 

            $ingresos = $this->gsatelite->get_tabla('inn_ingreso', array('inn_id_inc' => $inc_id)); 

            if ($incapaci[0]['inc_id_pla'] != "" && ($incapaci[0]['inc_id_inn'] || count($ingresos) > 0)) {
                $estado_pla = $this->gsatelite->get_campo('pla_planilla', 'pla_estado', array('pla_id' => $incapaci[0]['inc_id_pla']));
                if ($estado_pla < 3) {
                    if ($incapaci[0]['inc_id_inn']) {                    
                    $cuota_pagada = $this->gsatelite->get_campo('inn_ingreso', 'inn_cuota_pagada', array('inn_id' => $incapaci[0]['inc_id_inn']));
                    if ($cuota_pagada < 1) {
                        $tiene_ddi = $this->gsatelite->get_tabla('ddi_detalle_ingreso', array('ddi_id_inn' => $incapaci[0]['inc_id_inn']));
                        if(count($tiene_ddi) > 0) {
                            $registro_pla = $this->gsatelite->get_tabla('pla_planilla', array('pla_id' => $tiene_ddi[0]['ddi_id_pla']));
                            if($registro_pla[0]['pla_estado'] > 2) {
                                $alerta = array('tipo_alerta'=> 'error','titulo_alerta'=>"El registro no ha sido eliminado",'texto_alerta'=>"El ingreso ya ha sido autorizado en una planilla");
                                $this->session->set_flashdata($alerta);
                                redirect('acciones_personal/principal/gestion_incapacidad/' . $emp_id);
                            }
                        }
                        if($incapaci[0]['inn_id_hxe'] != ""){
                            $this->gsatelite->borrado_general('hxe_hora_extraxempleado', array('hxe_id' => $incapaci[0]['inn_id_hxe']));
                        }
                        if($incapaci[0]['inn_id_gva'] != ""){
                            $this->gsatelite->actualizar_array('gva_goce_vacacion',array('gva_estado' => 0), array('gva_id' => $incapaci[0]['inn_id_gva']));
                        }
                        $this->gsatelite->actualizar_array('inn_ingreso', array('inn_estado' => 0), array('inn_id' => $incapaci[0]['inc_id_inn']));
                    } else {
                        $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Incapacidad / Planilla", 'texto_alerta' => "Ingreso ya aplicado. No se puede eliminarse.");
                        $this->session->set_flashdata($alerta);
                        redirect('acciones_personal/principal/gestion_incapacidad/' . $emp_id);
                    }                    
                    } else {
                        $cp = array_sum(array_column($ingresos, "inn_cuota_pagada"));
                        if ($cp > 0) {
                            $alerta = array('tipo_alerta'=> 'error', 'titulo_alerta'=> "Incapacidad / Planilla", 'texto_alerta'=> "Ingreso ya aplicado. No se puede eliminarse.");
                            $this->session->set_flashdata($alerta);
                            redirect('acciones_personal/principal/gestion_incapacidad/' . $emp_id);
                        } else {
                            foreach ($ingresos as $k => $val) {
                                $tiene_detalle = $this->gsatelite->get_tabla('ddi_detalle_ingreso', array('ddi_id_inn' => $val["inn_id"]));
                                if (count($tiene_detalle) > 0) {
                                    $this->gsatelite->borrado_general('ddi_detalle_ingreso', array('ddi_id_inn' => $val["inn_id"]));
                                }
                                $this->gsatelite->actualizar_array('inn_ingreso', array('inn_estado' => 0), array('inn_id' => $val["inn_id"]));
                            }
                        }
                    }
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Incapacidad / Planilla", 'texto_alerta' => "Planilla Autorizada. No se eliminará regitro.");
                    $this->session->set_flashdata($alerta);
                    redirect('acciones_personal/principal/gestion_incapacidad/' . $emp_id);
                }
            }
            $concept = $this->gsatelite->get_campo('inc_incapacidad', 'inc_concepto', array('inc_id' => $inc_id));
            $incapacidad = array(
                'inc_dias' => 0,
                'inc_concepto' => $concept . " ** Eliminado el " . date("d-m-Y") . " **",
                'inc_estado' => 0,
                'inc_fecha_mod' => date("Y-m-d H:i:s"),
                'inc_usu_mod' => $this->tank_auth->get_user_id()
            );
            $del_inc = $this->gsatelite->actualizar_array('inc_incapacidad', $incapacidad, array('inc_id' => $inc_id));
            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Incapacidad", 'texto_alerta' => "Incapacidad eliminada con éxito.");
            $this->session->set_flashdata($alerta);
            redirect('acciones_personal/principal/gestion_incapacidad/' . $emp_id);
        }        
    }

    function procesar_incapacidad() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if($_POST){
                $periodo_incapacidad = ($this->input->post('periodo_incapacidad') > 0) ? $this->input->post('periodo_incapacidad') : 0;
                $registro_periodo = $this->gsatelite->get_tabla('pla_planilla', array('pla_id' => $periodo_incapacidad));
                $tinc = $this->gsatelite->get_registro('tnc_tipo_incapacidad', array('tnc_id' => $this->input->post('tnc')));
                if (count($registro_periodo) > 0) {
                    $fecha_inicio = $registro_periodo[0]['pla_fecha_inicio'];
                    $fecha1 = date("Y-m-d", strtotime("$fecha_inicio +1 day")); //sumo un dia para estar mas que seguro que encaje en el periodo seleccionado
                } else {
                    $fecha1 = date("Y-m-d");
                }
                $aplica_planilla = ($this->input->post('show_planillas') > 0) ? true : false;
                $emp = $this->input->post('empleado_id');
                $id_tipo_ingreso_incapacidad = ($tinc->tnc_id_tig != "") ? $tinc->tnc_id_tig : $this->gsatelite->get_parametro('ID_TIPO_INGRESO_INCAPACIDAD');
                $innsid = array();
                if (trim($this->input->post('tipo_inns')) != "" && $aplica_planilla) {
                    $innXrow = explode("&&", $this->input->post('tipo_inns'));
                    if (count($innXrow) > 0) {
                        foreach ($innXrow as $k => $val) {
                            $detaXrow = explode("##", $val);
                            $ingreso = array(
                                'inn_id_emp' => $emp,
                                'inn_id_tpl' => $this->input->post('tipo_planilla_incapacidad'),
                                'inn_id_tig' => ($detaXrow[0] > 0)? $detaXrow[0] : $id_tipo_ingreso_incapacidad,
                                'inn_motivo' => $this->input->post('con_incapacidad'),
                                'inn_observacion' => $this->input->post('observaciones_incapacidad'),
                                'inn_permanente' => 0,
                                'inn_valor' => $detaXrow[1],
                                'inn_fecha_desde' => $fecha1,
                                'inn_cuota' => 1,
                                'inn_cuota_pagada' => 0,
                                'inn_estado' => 1,
                                'inn_fecha_crea' => date("Y-m-d H:i:s"),
                                'inn_usu_crea' => $this->tank_auth->get_user_id(),
                                'inn_fecha_mod' => date("Y-m-d H:i:s"),
                                'inn_usu_mod' => $this->tank_auth->get_user_id()
                            );
                            $this->db->insert('inn_ingreso', $ingreso);
                            $innsid[] = $this->db->insert_id();
                            $inn_id = null;
                        }
                    }
                } else {
                    $ingreso = array(
                        'inn_id_emp' => $emp,
                        'inn_id_tpl' => $this->input->post('tipo_planilla_incapacidad'),
                        'inn_id_tig' => $id_tipo_ingreso_incapacidad,
                        'inn_motivo' => $this->input->post('con_incapacidad'),
                        'inn_observacion' => $this->input->post('observaciones_incapacidad'),
                        'inn_permanente' => 0,
                        'inn_valor' => $this->input->post('monto_empresa'),
                        'inn_fecha_desde' => $fecha1,
                        'inn_cuota' => 1,
                        'inn_cuota_pagada' => 0,
                        'inn_estado' => 1,
                        'inn_fecha_crea' => date("Y-m-d H:i:s"),
                        'inn_usu_crea' => $this->tank_auth->get_user_id(),
                        'inn_fecha_mod' => date("Y-m-d H:i:s"),
                        'inn_usu_mod' => $this->tank_auth->get_user_id()
                    );
                    if ($aplica_planilla && $tinc->tnc_id_tig != "") {
                        $this->db->insert('inn_ingreso', $ingreso);
                        $inn_id = $this->db->insert_id();
                    } else {
                        $inn_id = null;
                    }                
                }
                if (trim($this->input->post('fecha_final_incapacidad')) != "") {
                    $f_fin_inc = formatear_fecha('Y-m-d', $this->input->post('fecha_final_incapacidad'));
                } else {
                    $d = ($this->input->post('dias_incapacidad') - 1);
                    $f_ini_inc = date("Y-m-d", strtotime($this->input->post('fecha_inicio_incapacidad')));
                    $f_fin_inc = date("Y-m-d", strtotime("$f_ini_inc +$d day"));
                }
                $incapacidad = array(
                    'inc_id_inn' => $inn_id,
                    'inc_id_emp' => $emp,
                    'inc_id_pla' => ($aplica_planilla) ? $this->input->post('periodo_incapacidad') : null,
                    'inc_id_tnc' => ($this->input->post('tnc') > 0) ? $this->input->post('tnc') : null,
                    'inc_dias' => $this->input->post('dias_incapacidad'),
                    'inc_fecha_inicio' => date("Y-m-d", strtotime($this->input->post('fecha_inicio_incapacidad'))),
                    'inc_fecha_fin' => $f_fin_inc,
                    'inc_concepto' => $this->input->post('con_incapacidad'),
                    'inc_base_calculo' => ($aplica_planilla) ? $this->input->post('salario_base_calculo') : 0,
                    'inc_nuevo_salario_base' => ($aplica_planilla) ? $this->input->post('nuevo_salario_base') : 0,
                    'inc_monto_empresa' => ($aplica_planilla) ? $this->input->post('monto_empresa') : 0,
                    'inc_monto_seguro' => ($aplica_planilla) ? $this->input->post('monto_seguro') : 0,
                    'inc_monto_pendiente' => $this->input->post('monto_empresa'),
                    'inc_monto_abonado' => 0,
                    'inc_observacion' => $this->input->post('observaciones_incapacidad'),
                    'inc_estado' => 1,
                    'inc_fecha_crea' => date("Y-m-d H:i:s"),
                    'inc_usu_crea' => $this->tank_auth->get_user_id(),
                    'inc_fecha_mod' => date("Y-m-d H:i:s"),
                    'inc_usu_mod' => $this->tank_auth->get_user_id()
                );
                $this->db->insert('inc_incapacidad', $incapacidad);
                $inc_id = $this->db->insert_id();
                if (count($innsid) > 0) {
                    $ids = implode(",", $innsid);
                    $this->gsatelite->actualizar_array('inn_ingreso', array("inn_id_inc" => $inc_id), array("inn_id IN ($ids)" => null));
                }
                $ruta_anexos = $this->input->post('ruta');
                $titulo_anexo = $this->input->post('titulo_doc');

                //Si vienen anexos
                if (!empty($ruta_anexos)) {
                    for ($i = 0; $i < count($ruta_anexos); $i++) {

                        $extension = end(explode('.', $ruta_anexos[$i]));
                        $carpeta_temporal_anx = $ruta = "public/temp/anexos_incapacidades/" . trim($ruta_anexos[$i]);
                        $nombreArchivo = trim($titulo_anexo[$i]) . "." . trim($extension);
                        $carpeta_destino_anx = "uploads/anexos_incapacidades/" . $nombreArchivo;

                        $documentos_array = array(
                            'ain_id_inc'             => $inc_id,
                            'ain_url'                => $carpeta_destino_anx,
                            'ain_nombre'             => $nombreArchivo,
                            'ain_estado'             => 1,
                            'ain_usu_creacion'       => $this->tank_auth->get_user_id(),
                            'ain_fecha_creacion'     => date('Y-m-d H:i:s'),
                            'ain_usu_modificacion'   => $this->tank_auth->get_user_id(),
                            'ain_fecha_modificacion' => date('Y-m-d H:i:s')
                        );

                        $ant_id = $this->gsatelite->ingresar('ain_anexo_incapacidad', $documentos_array);
                        if ($ant_id > 0) {
                            copy($carpeta_temporal_anx, $carpeta_destino_anx);
                            unlink($carpeta_temporal_anx);
                        }
                    }
                }
                if (!empty($inn_id) && !empty($inc_id)) {
                    $ingreso = '<a href="' . base_url() . 'personal/empleado/ingreso_descuento_empleado/' . $emp . '/0"><b>ingresos y descuentos</b></a>';
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Incapacidad registrada con éxito.", 'texto_alerta' => "Puede ver reflejado un nuevo ingreso por incapacidad en  $ingreso");
                    $this->session->set_flashdata($alerta);
                }elseif (!empty($inc_id) && !$aplica_planilla) {
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Incapacidad", 'texto_alerta' => "Incapacidad registrada con éxito.");
                    $this->session->set_flashdata($alerta);
                }else{
                    if (empty($tinc->tnc_id_tig) && empty($inn_id) && !empty($inc_id)) {
                        $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Incapacidad", 'texto_alerta' => "Incapacidad registrada con éxito.");
                        $this->session->set_flashdata($alerta);
                    } else {
                        $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "No se registro la incapacidad", 'texto_alerta' => "Verifique la informacion a ingresar");
                        $this->session->set_flashdata($alerta);
                    }
                }
                redirect('acciones_personal/principal/gestion_incapacidad/' . $emp);
            }
        }
    }

    //@author René Castaneda
    public function agregar_horas_extras($id_empleado = null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($_POST) {
                $registro_periodo = $this->gsatelite->get_registro('pla_planilla', 'pla_id', $this->input->post('periodo_planilla'));
                $registro_tipo_hora = $this->gsatelite->get_registro('the_tipo_hora_extra', 'the_id', $this->input->post('tipo_hora_extra'));

                $array_detalle = array(
                    'hxe_id_pla' => $this->input->post('periodo_planilla')
                    , 'hxe_id_the' => $this->input->post('tipo_hora_extra')
                    , 'hxe_id_emp' => $this->input->post('emp_id')
                    , 'hxe_fecha' => formatear_fecha('Y-m-d', $this->input->post('fecha_registro'))
                    , 'hxe_num_hora' => $this->input->post('n_horas')
                    , 'hxe_observacion' => $this->input->post('observaciones')
                    , 'hxe_estado' => 1
                    , 'hxe_fecha_crea' => date("Y-m-d H:i:s")
                    , 'hxe_usu_crea' => $this->tank_auth->get_user_id()
                    , 'hxe_fecha_mod' => date("Y-m-d H:i:s")
                    , 'hxe_usu_mod' => $this->tank_auth->get_user_id()
                );
                $id_detalle_horas = $this->gsatelite->ingresar('hxe_hora_extraxempleado', $array_detalle);
                //ahora ingresar el ingreso en la tabla ingreso si existe el tipo de ingreso
                if ($registro_tipo_hora->the_id_tig != null && $registro_tipo_hora->the_id_tig != "") {
                    $ingreso = array(
                        'inn_id_emp' => $this->input->post('emp_id'),
                        'inn_id_tpl' => $this->input->post('tipo_planilla'),
                        'inn_id_tig' => $registro_tipo_hora->the_id_tig,
                        'inn_id_hxe' => $id_detalle_horas,
                        'inn_motivo' => $this->input->post('observaciones'),
                        'inn_observacion' => $this->input->post('observaciones'),
                        'inn_permanente' => 0,
                        'inn_valor' => $this->input->post('calculo_monto'),
                        'inn_fecha_desde' => date("Y-m-d", strtotime($registro_periodo->pla_fecha_inicio)),
                        'inn_cuota' => 1,
                        'inn_cuota_pagada' => 0,
                        'inn_estado' => 1,
                        'inn_fecha_mod' => date("Y-m-d H:i:s"),
                        'inn_usu_mod' => $this->tank_auth->get_user_id()
                    );
                    $id_ingreso = $this->gsatelite->ingresar('inn_ingreso', $ingreso);
                }
                $id_emp = $this->input->post('emp_id');
                $this->gsatelite->show_dialog("Proceso realizado con éxito", "acciones_personal/principal/gestion_horas_extras/$id_emp");
            } else {
                $this->verifica_empleado_real($id_empleado);
                $data["titulo_personal"] = "Gestión de horas extras";
                $data["info_empleado"] = $this->gsatelite->get_tabla('emp_empleado', array('emp_id' => $id_empleado));
                $data["salary_by_incomes"] = $this->planilla_model->get_salary_from_incomes($id_empleado);
                //PLANILLAS AL QUE PERTENECE EL EMPLEADO
                $ids_tpl = array(0);
                $pregunta = $this->gsatelite->get_tabla('txe_tipo_planillaxempleado', array('txe_id_emp' => $id_empleado));
                foreach ($pregunta as $fila) {
                    $ids_tpl[] = $fila['txe_id_tpl'];
                }
                          $this->db->where_in('tpl_id', $ids_tpl);
                $select = $this->gsatelite->get_dropdown('tpl_tipo_planilla', '{tpl_nombre}', '', null, null, '', 'tpl_id', true);
                $data["select_tpl_id"] = str_replace('<option value="0">Seleccione</option>', '', $select);
                $select = $this->gsatelite->get_dropdown('the_tipo_hora_extra', '{the_nombre} ({the_factor})', '', array('the_estado' => 1), null, '', 'the_id', true);
                $data["select_tipo_hora_extra"] = str_replace('<option value="0">Seleccione</option>', '', $select);
                $this->_cargarvista($data, null);
            }
        }
    }

    //@author René Castaneda
    public function agregar_horas_faltantes($id_empleado = null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($_POST) {
                // var_dump($_POST);die();
                $registro_periodo = ($this->input->post('periodo_planilla') > 0) ? $this->gsatelite->get_registro('pla_planilla', 'pla_id', $this->input->post('periodo_planilla')) : null;
                $registro_tipo_hora = $this->gsatelite->get_registro('thf_tipo_hora_faltante', 'thf_id', $this->input->post('tipo_hora_faltante'));
                $array_detalle = array(
                    'hxe_id_pla' => (trim($this->input->post('periodo_planilla')) > 0) ? $this->input->post('periodo_planilla') : null,
                    'hxe_id_thf' => $this->input->post('tipo_hora_faltante'),
                    'hxe_id_emp' => $this->input->post('emp_id'),
                    'hxe_id_mtp' => ($this->input->post('motivo') != '') ? $this->input->post('motivo') : null,
                    'hxe_num_hora' => $this->input->post('n_horas'),
                    'hxe_observacion' => $this->input->post('observaciones_tiempo'),
                    'hxe_fecha' => (trim($this->input->post('txtFechaDesde')) !='') ? formatear_fecha('Y-m-d', $this->input->post('txtFechaDesde')) : null,
                    'hxe_fecha_fin' => (trim($this->input->post('txtFechaHasta')) !='') ? formatear_fecha('Y-m-d', $this->input->post('txtFechaHasta')) : null,
                    'hxe_hora_inicio' => (trim($this->input->post('hora_1')) !='') ? $this->input->post('hora_1') : null,
                    'hxe_hora_fin' => (trim($this->input->post('hora_2')) !='') ? $this->input->post('hora_2') : null,
                    'hxe_estado' => 1,
                    'hxe_fecha_crea' => date("Y-m-d H:i:s"),
                    'hxe_usu_crea' => $this->tank_auth->get_user_id(),
                    'hxe_fecha_mod' => date("Y-m-d H:i:s"),
                    'hxe_usu_mod' => $this->tank_auth->get_user_id()
                );
                $id_detalle_horas = $this->gsatelite->ingresar('hxe_hora_extraxempleado', $array_detalle);
                // PARCHE TEMPORAL ISDEMU
                if (!($this->input->post('hora_1') && $this->input->post('hora_2')) && ($this->input->post('txtFechaDesde') == $this->input->post('txtFechaHasta')) && ($this->input->post('n_horas') == $this->gsatelite->get_parametro('HORAS_TRABAJADAS_DIA'))) {
                    $dia = formatear_fecha("N", $this->input->post('txtFechaDesde'));
                    $fech = formatear_fecha('Y-m-d', $this->input->post('txtFechaDesde'));
                    $where = array('txe_estado' => 1,'dxt_id_dia' => $dia,'txe_id_emp' => $this->input->post('emp_id'),'txe_desde <= ' => $fech,"(txe_hasta IS NULL OR txe_hasta >= '$fech')" => null);
                    $tur = $this->personal_model->buscarturno($where);
                    if (count($tur) == 1) {
                        $updh = array('hxe_hora_inicio' => $tur[0]['deh_hora_entrada'], 'hxe_hora_fin' => $tur[0]['deh_hora_salida']);
                        $this->gsatelite->actualizar_array('hxe_hora_extraxempleado', $updh, array('hxe_id' => $id_detalle_horas));
                    }
                }
                if ($id_detalle_horas > 0 && $registro_tipo_hora->thf_recurrente == 1 && $this->input->post('thf_recurrentes') > 0) {
                    $iniciaPer = formatear_fecha('Y-m-d', $this->input->post('txtFechaDesde'));
                    $acabarPer = formatear_fecha('Y-m-d', $this->input->post('txtFechaHasta'));
                    $tipo_rept = $this->input->post('tipo_fin_repite');
                    $dif = $this->input->post('ctdad_tipo_repite'); //repetir cada X dias, meses, etc
                    $ini_array = $fin_array = array();
                    switch ($this->input->post('tipo_recurrencia')) {
                        case '1':
                            // DIARIO
                            if ($tipo_rept > 1) {
                                //POR EVENTOS
                                $eventos = $this->input->post('ctd_fin_rpt');
                                for ($i = 0; $i < $eventos; $i++) {
                                    $d = $dif + $i; 
                                    $ini_array[] = date("Y-m-d", strtotime($iniciaPer . "+$d days")); 
                                    $fin_array[] = date("Y-m-d", strtotime($acabarPer . "+$d days")); 
                                }
                            } else {
                                //HASTA UNA FECHA
                                $ini1 = $iniciaPer;
                                $ini2 = $acabarPer;
                                $flmt = formatear_fecha('Y-m-d', $this->input->post('fecha_tipo_fin_rpt'));
                                while (strtotime($iniciaPer) <= strtotime($flmt)) {
                                    $ini1 = date("Y-m-d", strtotime($iniciaPer . "+$dif days"));
                                    $ini2 = date("Y-m-d", strtotime($acabarPer . "+$dif days"));
                                    if (strtotime($ini1) <= strtotime($flmt)) {
                                        $ini_array[] = $ini1;
                                        $fin_array[] = $ini2;
                                    }
                                    $iniciaPer = $ini1;
                                    $acabarPer = $ini2;
                                }
                            }
                            break;
                        case '2':
                            // SEMANAL
                            break;
                        case '3':
                            // MENSUAL
                            break;
                        case '4':
                            // ANUAL
                            break;
                    }
                    if (count($ini_array) > 0) {
                        $insertar_array = array();
                        foreach ($ini_array as $k => $value) {
                            $temp_array = array(
                                'dpr_id_emp' => $this->input->post('emp_id'),
                                "dpr_id_hxe" => $id_detalle_horas,
                                "dpr_id_thf" => $this->input->post('tipo_hora_faltante'),
                                "dpr_tipo_repite" => $this->input->post('tipo_recurrencia'),
                                "dpr_repeticiones" => $this->input->post('ctdad_tipo_repite'),
                                "dpr_numero_eventos" => ($tipo_rept > 1) ? $this->input->post('ctd_fin_rpt') : null,
                                "dpr_fecha_limite" => ($tipo_rept > 1) ? null : formatear_fecha('Y-m-d', $this->input->post('fecha_tipo_fin_rpt')),
                                "dpr_fecha_inicio_permiso" => $value,
                                "dpr_fecha_final_permiso" => $fin_array[$k],
                                "dpr_hora_desde_permiso" => formatear_fecha('H:i:s', $this->input->post('hora_1')),
                                "dpr_hora_hasta_permiso" => formatear_fecha('H:i:s', $this->input->post('hora_2')),
                                "dpr_correlativo" => ($k+1),
                                "dpr_autorizado" => 0,
                                "dpr_estado" => 1,
                                "dpr_usu_creacion" => $this->tank_auth->get_user_id(),
                                "dpr_fecha_creacion" => date('Y-m-d H:i:s'),
                                "dpr_usu_modificacion" => $this->tank_auth->get_user_id(),
                                "dpr_fecha_modificacion" => date('Y-m-d H:i:s')
                            );
                            array_push($insertar_array, $temp_array);
                        }
                        @$this->db->insert_batch('dpr_detalle_permiso_recurrente', $insertar_array);
                    }                
                }
                $array_uhp = array (
                    'uhp_id_hxe' => $id_detalle_horas,
                    'uhp_id_thf' => $this->input->post('tipo_hora_faltante'),
                    'uhp_numero_horas' => $this->input->post('n_horas'),
                    'uhp_fecha_desde' => (trim($this->input->post('txtFechaDesde')) !='') ? formatear_fecha('Y-m-d', $this->input->post('txtFechaDesde')) : null,
                    'uhp_fecha_hasta' => (trim($this->input->post('txtFechaHasta')) !='') ? formatear_fecha('Y-m-d', $this->input->post('txtFechaHasta')) : null,
                    'uhp_hora_inicio' => (trim($this->input->post('hora_1')) !='') ? $this->input->post('hora_1') : null,
                    'uhp_hora_fin' => (trim($this->input->post('hora_2')) !='') ? $this->input->post('hora_2') : null,
                    'uhp_autorizado' => 0,
                    'uhp_usu_autorizo' => null,
                    'uhp_fecha_autorizacion' => null,
                    'uhp_observaciones' => null,
                    'uhp_estado' => 1,
                    'uhp_usu_creacion' => $this->tank_auth->get_user_id(),
                    'uhp_fecha_creacion' => date("Y-m-d H:i:s"),
                    'uhp_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'uhp_fecha_modificacion' => date("Y-m-d H:i:s")
                );    
                $uhp_registro = $this->gsatelite->ingresar('uhp_uso_horas_permisos', $array_uhp);

                //ahora ingresar el descuento en planilla si aplica
                if ($this->input->post('tipo_planilla') > 0 && $registro_tipo_hora->thf_id_tdc > 0 && $registro_periodo) {
                    $descuento = array(
                        'dss_id_emp' => $this->input->post('emp_id'),
                        'dss_id_tpl' => $this->input->post('tipo_planilla'),
                        'dss_id_tdc' => $registro_tipo_hora->thf_id_tdc,
                        'dss_id_hxe' => $id_detalle_horas,
                        'dss_motivo' => $this->input->post('observaciones'),
                        'dss_observacion' => $this->input->post('observaciones'),
                        'dss_permanente' => 0,
                        'dss_valor' => $this->input->post('calculo_monto'),
                        'dss_fecha_desde' => formatear_fecha("Y-m-d", $registro_periodo->pla_fecha_inicio),
                        'dss_cuota' => 1,
                        'dss_cuota_pagada' => 0,
                        'dss_estado' => 1,
                        'dss_fecha' => date("Y-m-d H:i:s"),
                        'dss_fecha_crea' => date("Y-m-d H:i:s"),
                        'dss_usu_crea' => $this->tank_auth->get_user_id(),
                        'dss_fecha_mod' => date("Y-m-d H:i:s"),
                        'dss_usu_mod' => $this->tank_auth->get_user_id()
                    );
                    $id_dess = $this->gsatelite->ingresar('dss_descuento', $descuento);
                }
                $ruta_anexos = $this->input->post('ruta');
                $titulo_anexo = $this->input->post('titulo_doc');
                if (!empty($ruta_anexos)) {
                    for ($i = 0; $i < count($ruta_anexos); $i++) {
                        $extension = end(explode('.', $ruta_anexos[$i]));
                        $carpeta_temporal_anx = $ruta = "public/temp/anexos_permisos/" . trim($ruta_anexos[$i]);
                        $nombreArchivo = trim($titulo_anexo[$i]) . "." . trim($extension);
                        $carpeta_destino_anx = "uploads/anexos_permisos/" . $nombreArchivo;
                        $documentos_array = array(
                            'anh_id_hxe'             => $id_detalle_horas,
                            'anh_url'                => $carpeta_destino_anx,
                            'anh_nombre'             => $nombreArchivo,
                            'anh_estado'             => 1,
                            'anh_usu_creacion'       => $this->tank_auth->get_user_id(),
                            'anh_fecha_creacion'     => date('Y-m-d H:i:s'),
                            'anh_usu_modificacion'   => $this->tank_auth->get_user_id(),
                            'anh_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $anh_id = $this->gsatelite->ingresar('anh_anexo_hora_extra_empleado', $documentos_array);
                        if ($anh_id > 0) {
                            copy($carpeta_temporal_anx, $carpeta_destino_anx);
                            unlink($carpeta_temporal_anx);
                        }
                    }
                }
                $id_emp = $this->input->post('emp_id');
                $this->gsatelite->show_dialog("Proceso realizado con éxito", "acciones_personal/principal/gestion_horas_notrabajadas/$id_emp");
            } else {
                $this->verifica_empleado_real($id_empleado);
                $motivo = $this->gsatelite->get_dropdown('mtp_motivo_permiso', '{mtp_nombre}', 'motivo', array('mtp_estado' => 1),null ,'','',true);
                $data['motivo'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $motivo);
                $data["info_empleado"] = $this->gsatelite->get_tabla('emp_empleado', array('emp_id' => $id_empleado));
                $data["salary_by_incomes"] = $this->planilla_model->get_salary_from_incomes($id_empleado);
                //PLANILLAS AL QUE PERTENECE EL EMPLEADO
                $ids_tpl = array(0);
                $pregunta = $this->gsatelite->get_tabla('txe_tipo_planillaxempleado', array('txe_id_emp' => $id_empleado));
                foreach ($pregunta as $fila) {
                    $ids_tpl[] = $fila['txe_id_tpl'];
                }
                          $this->db->where_in('tpl_id', $ids_tpl);
                $select = $this->gsatelite->get_dropdown('tpl_tipo_planilla', '{tpl_nombre}', '', null, null, '', 'tpl_id', true);
                $data["select_tpl_id"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);  
                $slct = $this->gsatelite->get_tabla('thf_tipo_hora_faltante', array('thf_estado' => 1));
                $thfslct = '<option value=""></option>';
                if (count($slct) > 0) {
                    foreach ($slct as $k => $v) {
                        $thfslct .= '<option value="' . $v['thf_id'] . '" data-repite="' . intval($v['thf_recurrente']) . '">' . $v['thf_nombre'] . '</option>';
                        //// antes llevaba el thf_factor pero ya no se usa
                    }
                }
                $data["select_tipo_hora_faltante"] = $thfslct; 
                $data["titulo_personal"] = "Gestión de permisos";
                $this->_cargarvista($data, null);
            }
        }
    }

    //@author René Castaneda
    public function editar_horas_extras($id_hora_extra = null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($_POST) {
                // die(print_r($_POST));
                $registro_periodo = $this->gsatelite->get_registro('pla_planilla', 'pla_id', $this->input->post('periodo_planilla'));
                $registro_tipo_hora = $this->gsatelite->get_registro('the_tipo_hora_extra', 'the_id', $this->input->post('tipo_hora_extra'));

                $id_detalle_horas = $this->input->post('hxe_id');
                $array_detalle = array(
                    'hxe_id_pla' => $this->input->post('periodo_planilla')
                    , 'hxe_id_the' => $this->input->post('tipo_hora_extra')
                    , 'hxe_id_emp' => $this->input->post('emp_id')
                    , 'hxe_num_hora' => $this->input->post('n_horas')
                    , 'hxe_fecha' => formatear_fecha('Y-m-d', $this->input->post('fecha_registro'))
                    , 'hxe_observacion' => $this->input->post('observaciones')
                    , 'hxe_estado' => $this->input->post('estado')
                    , 'hxe_fecha_mod' => date("Y-m-d H:i:s")
                    , 'hxe_usu_mod' => $this->tank_auth->get_user_id()
                );
                $update_detalle = $this->gsatelite->actualizar_array('hxe_hora_extraxempleado', $array_detalle, array('hxe_id' => $id_detalle_horas));
                //ahora actualizar el ingreso en la tabla ingreso si existe
                if ($registro_tipo_hora->the_id_tig != null && $registro_tipo_hora->the_id_tig != "") {
                    $ingreso = array(
                        'inn_id_emp' => $this->input->post('emp_id'),
                        'inn_id_tpl' => $this->input->post('tipo_planilla'),
                        'inn_id_tig' => $registro_tipo_hora->the_id_tig,
                        'inn_motivo' => $this->input->post('observaciones'),
                        'inn_observacion' => $this->input->post('observaciones'),
                        'inn_permanente' => 0,
                        'inn_valor' => $this->input->post('calculo_monto'),
                        'inn_fecha_desde' => date("Y-m-d", strtotime($registro_periodo->pla_fecha_inicio)),
                        'inn_cuota' => 1,
                        'inn_cuota_pagada' => 0,
                        'inn_estado' => $this->input->post('estado'),
                        'inn_fecha_mod' => date("Y-m-d H:i:s"),
                        'inn_usu_mod' => $this->tank_auth->get_user_id()
                    );
                    $update_ingreso = $this->gsatelite->actualizar_array('inn_ingreso', $ingreso, array('inn_id_hxe' => $id_detalle_horas));
                }
                $id_emp = $this->input->post('emp_id');
                $this->gsatelite->show_dialog("Proceso realizado con éxito", "acciones_personal/principal/gestion_horas_extras/$id_emp");
            } else {
                $this->verifica_registro_real('hxe_hora_extraxempleado', $id_hora_extra);
                $registro_hora_extra = $this->accion_personal_model->get_horas_extras(array('hxe_id' => $id_hora_extra));
                $registro_hora_extra = $registro_hora_extra[0];
                $id_empleado = $registro_hora_extra['hxe_id_emp'];
                $data["titulo_personal"] = "Gestión de horas extras";
                $data["registro_hora"] = $registro_hora_extra;
                $data["info_empleado"] = $this->gsatelite->get_tabla('emp_empleado', array('emp_id' => $id_empleado));
                $data["salary_by_incomes"] = $this->planilla_model->get_salary_from_incomes($id_empleado);
                //PLANILLAS AL QUE PERTENECE EL EMPLEADO
                $ids_tpl = array(0);
                $pregunta = $this->gsatelite->get_tabla('txe_tipo_planillaxempleado', array('txe_id_emp' => $id_empleado));
                foreach ($pregunta as $fila) {
                    $ids_tpl[] = $fila['txe_id_tpl'];
                }
                $this->db->where_in('tpl_id', $ids_tpl);
                $sltpl = ($registro_hora_extra['tpl_id'] != "") ? $registro_hora_extra['tpl_id'] : $registro_hora_extra['pla_id_tpl'];
                $selectpl = $this->gsatelite->get_dropdown('tpl_tipo_planilla', '{tpl_nombre}', '', null, $sltpl, '', 'tpl_id', true);
                $data["select_tpl_id"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $selectpl);
                $selectxe = $this->gsatelite->get_dropdown('the_tipo_hora_extra', '{the_nombre} ({the_factor}%)', '', array('the_estado' => 1), $registro_hora_extra['the_id'], '', 'the_id', true);
                $data["select_tipo_hora_extra"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $selectxe);
                $select = $this->gsatelite->get_dropdown('pla_planilla', '{pla_fecha_inicio} # {pla_fecha_fin}', '', array('pla_id_tpl' => $sltpl, 'pla_estado >=' => 1, 'pla_estado <=' => 2), $registro_hora_extra['pla_id'], '', 'pla_id', true);
                $data["select_periodo_planilla"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
                $this->_cargarvista($data, null);
            }
        }
    }

    //@author René Castaneda
    public function editar_horas_faltantes($id_hora_faltante = null, $read = null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {           
            if ($_POST) {
                // die(var_dump($_POST));
                $registro_periodo = ($this->input->post('periodo_planilla') > 0)? $this->gsatelite->get_registro('pla_planilla', 'pla_id', $this->input->post('periodo_planilla')):null;
                $registro_tipo_hora = $this->gsatelite->get_registro('thf_tipo_hora_faltante', 'thf_id', $this->input->post('tipo_hora_faltante'));
                $id_detalle_horas = $this->input->post('hxe_id');
                $array_detalle = array(
                    'hxe_id_pla' => (trim($this->input->post('periodo_planilla')) > 0) ? $this->input->post('periodo_planilla') : null,
                    'hxe_id_thf' => $this->input->post('tipo_hora_faltante'),
                    'hxe_id_emp' => $this->input->post('emp_id'),
                    'hxe_id_mtp' => ($this->input->post('motivo') != '')? $this->input->post('motivo') : null,
                    'hxe_num_hora' => $this->input->post('n_horas'),
                    'hxe_fecha' => (trim($this->input->post('txtFechaDesde')) !='') ? formatear_fecha('Y-m-d',$this->input->post('txtFechaDesde')) : null,
                    'hxe_fecha_fin' => (trim($this->input->post('txtFechaHasta')) !='') ? formatear_fecha('Y-m-d',$this->input->post('txtFechaHasta')) : null,
                    'hxe_hora_inicio' => (trim($this->input->post('hora_1')) !='') ? $this->input->post('hora_1') : null,
                    'hxe_hora_fin' => (trim($this->input->post('hora_2')) !='') ? $this->input->post('hora_2') : null,
                    'hxe_observacion' => $this->input->post('observaciones_tiempo'),
                    'hxe_estado' => $this->input->post('estado_tiempo'),
                    'hxe_fecha_mod' => date("Y-m-d H:i:s"),
                    'hxe_usu_mod' => $this->tank_auth->get_user_id()
                );
                $update_detalle = $this->gsatelite->actualizar_array('hxe_hora_extraxempleado', $array_detalle, array('hxe_id' => $id_detalle_horas));
                //ahora ingresar el descuento en la tabla de descuento si aplica
                if ($this->input->post('tipo_planilla') > 0 && $registro_tipo_hora->thf_id_tdc > 0 && $registro_periodo) {
                    $descuento = array(
                        'dss_id_emp' => $this->input->post('emp_id'),
                        'dss_id_tpl' => $this->input->post('tipo_planilla'),
                        'dss_id_tdc' => $registro_tipo_hora->thf_id_tdc,
                        'dss_id_hxe' => $id_detalle_horas,
                        'dss_motivo' => $this->input->post('observaciones'),
                        'dss_observacion' => $this->input->post('observaciones'),
                        'dss_permanente' => 0,
                        'dss_valor' => $this->input->post('calculo_monto'),
                        'dss_fecha' => date("Y-m-d H:i:s"),
                        'dss_fecha_desde' => date("Y-m-d", strtotime($registro_periodo->pla_fecha_inicio)),
                        'dss_cuota' => 1,
                        'dss_cuota_pagada' => 0,
                        'dss_estado' => ($this->input->post('estado') >=0)? $this->input->post('estado'):0,
                        'dss_fecha_mod' => date("Y-m-d H:i:s"),
                        'dss_usu_mod' => $this->tank_auth->get_user_id()
                    );
                    $existe_des = $this->gsatelite->get_tabla('dss_descuento',array('dss_id_hxe' => $id_detalle_horas));
                    if ($existe_des) {
                        $update_decuento = $this->gsatelite->actualizar_array('dss_descuento', $descuento, array('dss_id_hxe' => $id_detalle_horas));
                    } else {
                        $descuento['dss_estado'] = 1;
                        $descuento['dss_fecha_crea'] = date("Y-m-d H:i:s");
                        $descuento['dss_usu_crea'] = $this->tank_auth->get_user_id();
                        $id_dess = $this->gsatelite->ingresar('dss_descuento', $descuento);
                    }
                }
                $ruta_anexos = $this->input->post('ruta');
                $titulo_anexo = $this->input->post('titulo_doc');
                if (!empty($ruta_anexos)) {
                    for ($i = 0; $i < count($ruta_anexos); $i++) {
                        $extension = end(explode('.', $ruta_anexos[$i]));
                        $carpeta_temporal_anx = $ruta = "public/temp/anexos_permisos/" . trim($ruta_anexos[$i]);
                        $nombreArchivo = trim($titulo_anexo[$i]) . "." . trim($extension);
                        $carpeta_destino_anx = "uploads/anexos_permisos/" . $nombreArchivo;
                        $dir = $this->gsatelite->get_tabla('anh_anexo_hora_extra_empleado', array('anh_url' => $carpeta_destino_anx, 'anh_estado' => 1));
                        if (!(count($dir) > 0)) {
                            $documentos_array = array(
                                'anh_id_hxe'             => $id_detalle_horas,
                                'anh_url'                => $carpeta_destino_anx,
                                'anh_nombre'             => $nombreArchivo,
                                'anh_estado'             => 1,
                                'anh_usu_creacion'       => $this->tank_auth->get_user_id(),
                                'anh_fecha_creacion'     => date('Y-m-d H:i:s'),
                                'anh_usu_modificacion'   => $this->tank_auth->get_user_id(),
                                'anh_fecha_modificacion' => date('Y-m-d H:i:s')
                            );
                            $ant_id = $this->gsatelite->ingresar('anh_anexo_hora_extra_empleado', $documentos_array);
                            if ($ant_id > 0) {
                                copy($carpeta_temporal_anx, $carpeta_destino_anx);
                                unlink($carpeta_temporal_anx);
                            }
                        }
                    }
                }
                $id_emp = $this->input->post('emp_id');
                $this->session->set_flashdata('tab_id', 'faltantes_tab');
                $this->gsatelite->show_dialog("Proceso realizado con éxito", "acciones_personal/principal/gestion_horas_notrabajadas/$id_emp");
            } else {
                $this->verifica_registro_real('hxe_hora_extraxempleado', $id_hora_faltante);
                $registro_hora_faltante = $this->accion_personal_model->get_horas_faltantes(array('hxe_id' => $id_hora_faltante));

                $data['motivo'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'),'', 
                $this->gsatelite->get_dropdown('mtp_motivo_permiso', '{mtp_nombre}', 'motivo', array('mtp_estado' => 1),$registro_hora_faltante[0]['hxe_id_mtp'] ,'','',true));
                $registro_hora_faltante = $registro_hora_faltante[0];
                $id_empleado = $registro_hora_faltante['hxe_id_emp'];
                $data["titulo_personal"] = "Gestión de Permisos";
                $data["registro_hora"] = $registro_hora_faltante;
                $data["info_empleado"] = $this->gsatelite->get_tabla('emp_empleado', array('emp_id' => $id_empleado));
                $data["salary_by_incomes"] = $this->planilla_model->get_salary_from_incomes($id_empleado);
                //PLANILLAS AL QUE PERTENECE EL EMPLEADO
                $ids_tpl = array(0);
                $pregunta = $this->gsatelite->get_tabla('txe_tipo_planillaxempleado', array('txe_id_emp' => $id_empleado));
                foreach ($pregunta as $fila) {
                    $ids_tpl[] = $fila['txe_id_tpl'];
                }
                $this->db->where_in('tpl_id', $ids_tpl);
                $select = $this->gsatelite->get_dropdown('tpl_tipo_planilla', '{tpl_nombre}', '', null, $registro_hora_faltante['pla_id_tpl'], '', 'tpl_id', true);
                $data["select_tpl_id"] = str_replace('<option value="0">Seleccione</option>', '', $select);
                $select = $this->gsatelite->get_dropdown('thf_tipo_hora_faltante', '{thf_nombre} ({thf_factor})', '', array('thf_estado' => 1), $registro_hora_faltante['thf_id'], '', 'thf_id', true);
                $data["select_tipo_hora_faltante"] = str_replace('<option value="0">Seleccione</option>', '', $select);
                $data["mostrar_tab_descuento"] = $this->gsatelite->get_campo('thf_tipo_hora_faltante', 'thf_id_tdc', array('thf_id' => $registro_hora_faltante['hxe_id_thf']));
                $select = $this->gsatelite->get_dropdown('pla_planilla', '{pla_fecha_inicio} # {pla_fecha_fin}', '', array('pla_id_tpl' => $registro_hora_faltante['pla_id_tpl'], 'pla_estado >=' => 1, 'pla_estado <=' => 2), $registro_hora_faltante['pla_id'], '', 'pla_id', true);
                $data["select_periodo_planilla"] = str_replace('<option value="0">Seleccione</option>', '', $select);
                $data['anx'] = $this->gsatelite->get_tabla('anh_anexo_hora_extra_empleado', array('anh_id_hxe' => $id_hora_faltante, 'anh_estado' => 1));
                $data['leer'] = ($read) ? 1 : 0;
                $this->_cargarvista($data, null, 'acciones_personal/principal/editar_horas_faltantes');
            }
        }
    }

    public function ver_horas_faltantes($id_hora_faltante){
        satelite_validar();
        $this->editar_horas_faltantes($id_hora_faltante, 1);
    }

    public function verifica_empleado_real($id_empleado) {
        if ($id_empleado == null or ! is_numeric($id_empleado) or $id_empleado <= 0) {
            $this->gsatelite->show_dialog('Empleada/o no válido', 'acciones_personal/principal/listado_empleados', 'error');
        } else {
            $pregunta = $this->gsatelite->get_tabla('emp_empleado', array('emp_id' => $id_empleado));
            if (count($pregunta) <= 0) {
                $this->gsatelite->show_dialog('Empleada/o no válido', 'acciones_personal/principal/listado_empleados', 'error');
            }
        }
    }

    public function verifica_registro_real($tabla, $id = null) {
        if ($id == null or ! is_numeric($id) or $id <= 0) {
            $this->gsatelite->show_dialog('Petición no Válida', 'acciones_personal', 'error');
        } else {
            $prefijo = explode('_', $tabla);
            $pregunta = $this->gsatelite->get_tabla($tabla, array($prefijo[0] . '_id' => $id));
            if (count($pregunta) <= 0) {
                $this->gsatelite->show_dialog('Petición no Válida', 'acciones_personal', 'error');
            }
        }
    }

    /**
     * @author René Castaneda
     */
    function periodos_planilla($desc = null) { //peticion por ajax
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $id = $this->input->post('idpla');
            $posee = false; //(bandera)
            $select = "";
            if ($id > 0) {
                //filtrar las planillas creadas o generadas. y omitir las autorizadas
                $pregunta = $this->gsatelite->get_tabla('pla_planilla', array('pla_id_tpl' => $id, 'pla_estado >=' => 1, 'pla_estado <=' => 2));
                if (count($pregunta) > 0) {
                    $where = array('pla_id_tpl' => $id, 'pla_estado >= ' => 1, 'pla_estado <= ' => 2);
                    if ($desc) {
                                $this->db->order_by('pla_fecha_inicio', 'DESC');
                        $slct = $this->gsatelite->get_dropdown('pla_planilla','{pla_fecha_inicio} # {pla_fecha_fin}', '', $where, null, '', '', true);
                    } else {
                                $this->db->order_by('pla_fecha_inicio', 'DESC');
                        $slct = $this->gsatelite->get_dropdown('pla_planilla','{pla_fecha_inicio} # {pla_fecha_fin}','periodo_planilla',$where,null,'id="periodo_planilla" class="nostyle"');
                    }
                    $select = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $slct);
                    $posee = true;
                }

                echo json_encode(array('posee' => $posee, 'select' => $select));
            }
        }
    }

    /**
     * @author René Castaneda
     * @return retornar el registro de las horas extras.
     */
    function registro_tipo_hora_extra() { //peticion por ajax
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $id = $this->input->post('id_tipo');
            if ($id > 0) {
                            $this->db->join('tig_tipo_ingreso', 'tig_id = the_id_tig');
                $registro = $this->gsatelite->get_registro('the_tipo_hora_extra', 'the_id', $id);
                echo json_encode(array('factor_multiplica' => $registro->the_factor, 'aplica_fijo' => intval($registro->tig_aplica_valor_fijo), 'monto_fijo' => $registro->tig_valor_fijo ));
            }
        }
    }

    public function validar_fecha_limite(){
        $limitar = 0;
        $estedia = date_create("now");
        date_add($estedia, date_interval_create_from_date_string("-1 month"));
        $unmesatras = date_format($estedia, 'Y-m-d'); 
        $mes_pasado = formatear_fecha('Ym', $unmesatras);
        $fecha = $this->input->post('fecha');
        $this_mes = formatear_fecha('Ym', $fecha);
        $hoy = date('j');
        $dia_limite = $this->gsatelite->get_parametro_emp('BLOQUEO_INGRESO_PERMISOS', '');
        if (is_numeric($dia_limite) && $dia_limite > 0) {
            if ($this_mes < $mes_pasado) {
                $limitar++;
            }
            if ($this_mes == $mes_pasado && $hoy > $dia_limite) {
                $limitar++;
            }
        }
        echo $limitar;
    }

    /**
     * @author René Castaneda
     * @return retornar el registro de las horas faltante.
     */
    function registro_tipo_hora_faltante() { //peticion por ajax
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $id = $this->input->post('id_tipo');
            if ($id > 0) {
                $registro = $this->gsatelite->get_registro('thf_tipo_hora_faltante', 'thf_id', $id);
                //$descuento = $this->gsatelite->get_registro('thf_tipo_hora_faltante', 'thf_id_tdc', $id);
                echo json_encode(array('factor_multiplica' => $registro->thf_factor,"descuento" => $registro->thf_id_tdc));
            }
        }
    }

    function buscar_horas_consumidas() {
        $thf = $this->input->post('id_tipo');
        $emp = $this->input->post('id_empl');
        if ($thf > 0 && $emp > 0) {
            $tipo_permiso = $this->gsatelite->get_parametro_emp("TIPO_PERMISO_COMPENSATORIO");
            if ($tipo_permiso == $thf) {
                $horas = $this->accion_personal_model->get_tiempo_compensatorio(array('tce_id_emp' => $emp, 'tce_disponible > 0' => null));
                if (ob_get_length()) {
                    ob_clean(); 
                }

                $this->output
                    ->set_status_header(200)  
                    ->set_content_type('application/json', 'utf-8')
                    ->set_output(json_encode([
                        'tipo' => 'V2_COM',
                        'horas' => $horas
                    ]))
                    ->_display()
                ;
                exit;
            }else{
                $reg_thf = $this->gsatelite->get_tabla('thf_tipo_hora_faltante', array('thf_id' => $thf));
                $reg_hxp = $this->gsatelite->get_tabla('hpe_hora_permiso_x_empleado', array('hpe_id_thf' => $thf, 'hpe_id_emp' => $emp));
                           $this->db->join('hxe_hora_extraxempleado', 'hxe_id = uhp_id_hxe');
                $sum_hxe = $this->gsatelite->get_suma('uhp_uso_horas_permisos', 'uhp_numero_horas', array('hxe_id_emp'=>$emp, 'uhp_id_thf'=>$thf, 'uhp_estado'=>1, 'uhp_autorizado'=>1, 'hxe_estado'=>2));
                #thf_commpensatorio
                $compensatorio = 0;
                $empresa = strtolower(trim($this->gsatelite->get_parametro('SYS_SIGLAS', '')));
                if ((isset($reg_thf[0]['thf_horas_ley']) && $reg_thf[0]['thf_horas_ley'] > 0) || (isset($reg_hxp[0]['hpe_horas_limite']) && $reg_hxp[0]['hpe_horas_limite'] > 0)) {
                    $asignadas = ($reg_thf[0]['thf_horas_ley'] > 0) ? $reg_thf[0]['thf_horas_ley'] : $reg_hxp[0]['hpe_horas_limite'];
                    $utilizado = $sum_hxe;
                    $disponible = (($asignadas - $utilizado) > 0) ? ($asignadas - $utilizado) : 0;
                        $restringe = ($disponible > 0) ? false : true;
                    } else {
                    $restringe = false;
                    $utilizado = $sum_hxe;
                    $asignadas = $disponible = 0;
                } 
                if ($empresa == 'midem') {
                    $sumdias = 0;
                    $fini = date('Y') . '-01-01';
                    $ffin = date('Y') . '-12-31';
                    $horas_d = $this->gsatelite->get_parametro('HORAS_TRABAJADAS_DIA', '8');
                    $emp_row = $this->gsatelite->get_registro('emp_empleado', array('emp_id' => $emp)); 
                    $inc = $this->gsatelite->get_suma('inc_incapacidad', 'inc_dias', array('inc_estado' => 1, 'inc_id_emp' => $emp, "inc_fecha_inicio BETWEEN '$fini' AND '$ffin'" => null));
                           $this->db->join('thf_tipo_hora_faltante', 'thf_id = hxe_id_thf');
                    $hxe = $this->gsatelite->get_suma("hxe_hora_extraxempleado", "hxe_num_hora", array("hxe_id_thf IS NOT NULL" => null, "hxe_estado >" => 1, "hxe_id_emp" => $emp, "hxe_fecha BETWEEN '$fini' AND '$ffin'" => null, '(thf_licencia = 0 OR thf_licencia IS NULL)' => null));
                    $sumdias += floor(floatval($hxe) / $horas_d);
                    $sumdias += $inc;
                    $dias_limite = ($emp_row->emp_discapacidad == 1) ? 24 : 18;
                    $limit_panama = $dias_limite . "##" . $sumdias;
                    if ($sumdias >= $dias_limite) {
                        $disponible = 0;
                        $restringe = true;
            }                      
                }
            }
            $empDisc = $this->gsatelite->get_registro('emp_empleado', 'emp_id', $emp);
            $apliDisc = $this->gsatelite->get_registro('cfp_configuracion_tipo_permiso', 'cfp_id_thf', $thf);
            if (is_object($apliDisc) && $apliDisc->cfp_tipo_empleado == 1) {
                $just_disc = ($empDisc->emp_discapacidad == 1) ? false : true;
        } else {
                $just_disc = false;
            }            
        } else {
            $restringe = $just_disc = false;
            $asignadas = $utilizado = $disponible = $compensatorio = 0;
        }
        echo json_encode(array('restringir' => $restringe, 'stopXdisca' => $just_disc, 'asignadas' => $asignadas,'usadas' => $utilizado, 'disponible'=> $disponible, 'compensatorio' => $compensatorio));
    }

    //@author René Castaneda
    public function generar_vacacion() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($_POST) {
                //	die(var_dump($_POST));
                $empleados = $this->input->post('empleados_grid');
                $periodos = $this->input->post('periodo_vacacion_grid');
                $dias = $this->input->post('dias_grid');
                if ($empleados == false or $empleados == null) {
                    $this->gsatelite->show_dialog("No se ha procesado a ningun empleado", "acciones_personal/principal/generar_vacacion", 'error');
                }
                $generar_resolucion = $this->gsatelite->get_parametro('SYS_CONFIGURACION_VACACION',null,null,array('GENERAR_RESOLUCION'));
                for ($i = 0; $i < count($empleados); $i++) {
                    $array_detalle = array(
                        'vac_id_emp' => $empleados[$i]
                        , 'vac_id_prv' => $periodos[$i]
                        , 'vac_dia_ganado' => $dias[$i]
                        , 'vac_dia_gozado' => 0
                        , 'vac_estado' => 1
                        , 'vac_fecha_creacion' => date("Y-m-d H:i:s")
                        , 'vac_usu_creacion' => $this->tank_auth->get_user_id()
                        , 'vac_fecha_modificacion' => date("Y-m-d H:i:s")
                        , 'vac_usu_modificacion' => $this->tank_auth->get_user_id()
                    );
                    $id_detalle_vac = $this->gsatelite->ingresar('vac_vacacion', $array_detalle);
                    if ($generar_resolucion > 0) {
                        $tipo_resolucion = $generar_resolucion;////parametro
                                    $this->db->join("trs_tipo_resolucion", "trs_id = rsl_id_trs");
                        $formatos = $this->gsatelite->get_tabla("rsl_resolucion", array("rsl_id" => $tipo_resolucion));
                        $data['fecha_resol'] = date("Y-m-d");
                        $data['id_vacacion'] = $id_detalle_vac;
                        $data['slc_empleado'] = $empleados[$i];
                        $data['nresolucion'] = $this->correlativo_resolucion($tipo_resolucion);
                        $data['institucion'] = $this->gsatelite->get_tabla('emr_empresa', array('emr_id' => $this->tank_auth->get_empresa_id()))[0];
                        $html = $this->load->view('acciones_personal/principal/' . $formatos[0]['rsl_formato'], $data, true);
                        $new_res = array(
                            'rxe_id_rsl' => $tipo_resolucion,
                            'rxe_num_resolucion' => $data['nresolucion'],
                            'rxe_id_emp' => $empleados[$i],
                            'rxe_fecha_generado' => date("Y-m-d H:i:s"),
                            'rxe_html' => $html,
                            'rxe_estado' => 1,
                            'rxe_usu_creacion' => $this->tank_auth->get_user_id(),
                            'rxe_fecha_creacion' => date("Y-m-d H:i:s"),
                            'rxe_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'rxe_fecha_modificacion' => date("Y-m-d H:i:s")
                        );
                        $id_res = $this->gsatelite->ingresar('rxe_resolucionxempleado', $new_res);
                    }
                }
                $this->gsatelite->show_dialog("Proceso realizado con éxito para $i empleados", "acciones_personal/principal/listado_empleados_vacacion");
            } else {
                $data["titulo_personal"] = "Generar goce vacación"; // ({prv_desde} # {prv_hasta})
                $select = $this->gsatelite->get_dropdown('prv_periodo_vacacion', '{prv_nombre}', '', array('prv_estado' => 1), null, '', 'prv_id', true);
                $data['slc_areas'] = $this->gsatelite->get_dropdown('are_area', '{are_nombre}', '', array('are_estado' => 1), null, '', 'are_id', true);
                $data['slc_sucsl'] = $this->gsatelite->get_dropdown('suc_sucursal', '{suc_nombre}', '', array('suc_id_emr' => $this->tank_auth->get_empresa_id()), null, '', 'suc_id', true);
                $data["select_periodo_vaca"] = str_replace('<option value="0">Seleccione</option>', '', $select);
                $data["select_periodo_vaca"] = str_replace('<option value="0">Sin Registros</option>', '', $select);
                $this->_cargarvista($data, null);
            }
        }
    }

    /**
     * @author René Castaneda
     */
    function datos_periodo_vacacion() {
        $id = $this->input->post('id');
        $registro = (array) $this->gsatelite->get_registro('prv_periodo_vacacion', 'prv_id', $id);
        $ndias = $this->gsatelite->get_parametro('SYS_CONFIGURACION_VACACION',null,null,array('DIAS_LEY_VACACION'));
        //$ndias = $this->gsatelite->get_intervalo_dias($registro['prv_desde'], $registro['prv_hasta']);
        $registro['ndias'] = $ndias;
        echo json_encode($registro);
    }

    /**
     * @author René Castaneda
     * llena la grid en la pantalla de generar vacación.
     */
    function datos_empleados() {
        $data["f1"] = $this->input->post('f1');
        $data["f2"] = $this->input->post('f2');
        $data["nd"] = $this->input->post('nd');
        $id_periodo = $this->input->post('id_p');
        $data["periodo"] = (array) $this->gsatelite->get_registro('prv_periodo_vacacion', 'prv_id', $this->input->post('id_p'));
        $fecha_verificar = formatear_fecha("Y-m-d", $this->input->post('f1'));
        $fecha_verificar2 = formatear_fecha("Y-m-d", $this->input->post('f2'));
        $are = $this->input->post('ar');
        $suc = $this->input->post('sc');
        //preguntar a los cuantos dias de laborar se le pude aplicar vacación al empleado
        //$num_dias_aplica_vacacion = $this->gsatelite->get_parametro('NUM_DIAS_APLICA_VACACION');
        //$this->db->where("DATEDIFF('$fecha_verificar', emp_empleado.emp_fecha_contrato) >= $num_dias_aplica_vacacion", null, false);
        $empresa = strtolower(trim($this->gsatelite->get_parametro('SYS_SIGLAS', '')));
        if ($empresa == 'midem') {
            $num_dias_aplY_vac = $this->gsatelite->get_parametro('NUM_DIAS_APLICA_VACACION',365);//MIDEM SON 335 DIAS (11 MESES)
            $daysbach = $num_dias_aplY_vac + 1;
            $fecPrvOtros = date_create($fecha_verificar);
            date_add($fecPrvOtros, date_interval_create_from_date_string("-$daysbach day"));
            $fOtroPrv = date_format($fecPrvOtros, 'Y-m-d'); 
            $otrosprvsids = $this->gsatelite->get_tabla('prv_periodo_vacacion', array("prv_estado"=>1,"prv_desde >= "=>$fOtroPrv,"prv_desde < "=>$fecha_verificar));
            $idsOtros = (count($otrosprvsids) > 0) ? implode(",", array_column($otrosprvsids, "prv_id")) : 0 ;
            $this->db->where("(IFNULL(DATEDIFF('$fecha_verificar', emp_fecha_ult_vacacion), DATEDIFF('$fecha_verificar', emp_fecha_contrato)) > $num_dias_aplY_vac)", null, false);
            // $this->db->where("emp_empleado.emp_id NOT IN (SELECT vac_id_emp FROM vac_vacacion WHERE vac_id_prv NOT IN ($idsOtros)) ", null, false);
            /* CONSULTAR, SINO, QUE NOS DEN FECHA ULTIMA VACACION */
        } else {
            //VERIFICAR LOS EMPLEADOS QUE CUMPLEN ANIVERSARIO EN EL RANGO DE FECHA DETERMINADO.
            $this->db->where("emp_fecha_antiguedad IS NOT NULL AND DATE_FORMAT(emp_fecha_antiguedad, '%m-%d') BETWEEN DATE_FORMAT('$fecha_verificar', '%m-%d') AND DATE_FORMAT('$fecha_verificar2', '%m-%d') AND YEAR(emp_fecha_antiguedad) < YEAR('$fecha_verificar')", null, false);
        }
        //EXCLUIR A LOS EMPLEADOS AQUIENES YA SE LES GENERÓ VACACION PARA ESE PERIODO
        $this->db->where("emp_empleado.emp_id NOT IN (SELECT vac_id_emp FROM vac_vacacion WHERE vac_id_prv=$id_periodo) ", null, false);
        // AGREGAR FILTROS
        if ($are > 0) {
            $this->db->where("emp_id_are", $are);
        }
        if ($suc > 0) {
            $this->db->where("emp_id_suc", $suc);
        }
        $data["consulta"] = $this->planilla_model->get_empleados_reporte(array('emp_empleado.emp_estado' => 1));
        //print_r($this->db->last_query());die();
        $html = $this->load->view('acciones_personal/principal/vacaciones_empleados', $data, true);
        echo json_encode(array("html" => $html));
    }

    public function resoluciones(){
        satelite_validar();
        $permisos = $this->gsatelite->get_permisos_opcion();
        $sltd = null;
        $crud = new grocery_CRUD();
        $crud->set_table('rxe_resolucionxempleado')
            ->set_subject('Resoluciones por Empleado')
            ->columns('rxe_id_rsl','rxe_num_resolucion','rxe_id_emp','rxe_fecha_generado','rxe_estado')
            ->display_as('rxe_id_rsl', 'Tipo Resolución')
            ->display_as('rxe_num_resolucion', 'Resolución')
            ->display_as('rxe_id_emp', 'Empleado')
            ->display_as('rxe_fecha_generado', 'Fecha')
            ->display_as('rxe_estado', 'Estado')
            ->callback_column('rxe_fecha_generado', function($value, $row) {
                return '<span style="display:none;">'.formatear_fecha('YmdHis',$value).'</span><span>'.formatear_fecha('d-m-Y',$value).'</span>';
            })
            ->callback_column('rxe_id_emp', function($value, $row) {
                $CI = &get_instance();
                $emp = $CI->gsatelite->get_registro('emp_empleado', array('emp_id' => $value));
                $nombre = $emp->emp_codigo . ' - ' . $emp->emp_nombre . ' ' . $emp->emp_apellido;
                return $nombre;
            })
            ->callback_column('rxe_id_rsl', function($value, $row) {
                $CI = &get_instance();
                        $this->db->join('rsl_resolucion', 'trs_id = rsl_id_trs');
                $name = $CI->gsatelite->get_campo('trs_tipo_resolucion', 'trs_nombre', array('rsl_id' => $value));
                return $name;
            })
            ->unset_delete()
            ->unset_read()
            ->unset_edit()
        ;
        $crud->field_type('rxe_estado','dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
        if ($_POST) {
            $fini = $_POST['txtfechadesde'];
            $ffin = $_POST['txtfechahasta'];
            $tipo = $_POST['slcTipoReso'];
            $empl = $_POST['slcEmpleado'];
            if ($fini != "") {
                $data["fech_ini"] = formatear_fecha('d-m-Y', $fini);
                $crud->where('rxe_fecha_generado >= ', formatear_fecha('Y-m-d H:i:s', $fini . " 00:00:00"));
            }
            if ($ffin != "") {
                $data["fech_fin"] = formatear_fecha('d-m-Y', $ffin);
                $crud->where('rxe_fecha_generado <= ', formatear_fecha('Y-m-d H:i:s', $ffin . " 23:59:59"));
            }            
            if ($empl > 0) {
               $crud->where('rxe_id_emp', $empl);
               $data["emp_slctd"] = $this->gsatelite->get_registro('emp_empleado', array('emp_id'=>$empl));
            }
            if ($tipo > 0) {
                $sltd = $tipo;
                $crud->where('rxe_id_rsl', $tipo);
            }
        } else {
            $crud->where('rxe_id IS NULL');
        }        
        $crud->unset_print()->unset_export()->unset_add();
        if ($permisos['permite_ver']) {
            $crud->add_action('Imprimir', '', 'acciones_personal/principal/print_resol', 'icomoon-icon-copy-2', null,'target="_blank"', "[rxe_estado] == 'Activo'");
        }
        $output = $crud->render();
                                $this->db->join('trs_tipo_resolucion', 'trs_id = rsl_id_trs');
        $data["resoluciones"] = $this->gsatelite->get_dropdown('rsl_resolucion','{trs_nombre}','', array('trs_estado'=>1,'rsl_estado'=>1),$sltd,'','rsl_id',true);
        $data["permisos"] = $permisos;
        $data["titulo_personal"] = "Resoluciones";
        $this->_cargarvista($data, $output);
    }

    public function nueva_resolucion() {
        satelite_validar();
        if ($_POST) {
            $post_array = $_POST;
            // var_dump($post_array);die();
            $tipo_resolucion = $post_array['tipo_documento'];
                        $this->db->join("trs_tipo_resolucion", "trs_id = rsl_id_trs");
            $formatos = $this->gsatelite->get_tabla("rsl_resolucion", array("rsl_id" => $tipo_resolucion));
            if ($formatos[0]['rsl_formato'] != "") {
                $fecha = $post_array['fecha_resol'] . ' ' . date('H:i:s');
                foreach ($post_array as $k => $val) {
                    $data[$k] = $val;
                }
                $data['institucion'] = $this->gsatelite->get_tabla('emr_empresa', array('emr_id' => $this->tank_auth->get_empresa_id()))[0];
                $html = $this->load->view('acciones_personal/principal/' . $formatos[0]['rsl_formato'], $data, true);
                // var_dump($html);die();
                $new_res = array(
                    'rxe_id_rsl' => $tipo_resolucion,
                    'rxe_num_resolucion' => $post_array['nresolucion'],
                    'rxe_id_emp' => $post_array['slc_empleado'],
                    'rxe_fecha_generado' => formatear_fecha('Y-m-d H:i:s', $fecha),
                    'rxe_html' => $html,
                    'rxe_estado' => 1,
                    'rxe_usu_creacion' => $this->tank_auth->get_user_id(),
                    'rxe_fecha_creacion' => date("Y-m-d H:i:s"),
                    'rxe_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'rxe_fecha_modificacion' => date("Y-m-d H:i:s")
                );
                $id_res = $this->gsatelite->ingresar('rxe_resolucionxempleado', $new_res);
                $this->session->set_flashdata('id_imprimir', $id_res);
                $this->gsatelite->show_dialog("Se ha generado el formulario solicitado", "acciones_personal/principal/resoluciones");
            } else {
                $this->gsatelite->show_dialog("No se puede generar el formulario solicitado", "acciones_personal/principal/resoluciones", "error");
            }            
        } else {
            $slc_res = '<option value=""></option>';
                         $this->db->join('trs_tipo_resolucion', 'trs_id = rsl_id_trs');
            $tipo_reso = $this->gsatelite->get_tabla('rsl_resolucion', array('rsl_estado' => 1, 'trs_estado' => 1));
            foreach ($tipo_reso as $k => $r) {
                $slc_res .= '<option value="'.$r['rsl_id'].'" data-extra="'.$r['trs_codigo'].'" >'.$r['trs_nombre'].'</option>';
            }
            $data['slc_resoluc'] = $slc_res;
            $empleados = $this->gsatelite->get_tabla('emp_empleado', array('emp_estado' => 1));
            $slc_emp = '<option value=""></option>';
            foreach ($empleados as $k => $e) {
                $state = ($e['emp_estado'] > 0) ? '' : ' (INACTIVO)';
                $slc_emp .= '<option value="'.$e['emp_id'].'">'.$e['emp_codigo'].' - '.$e['emp_nombre'].' '.$e['emp_apellido'].$state.'</option>';
            }
            $data['slc_empleados'] = $slc_emp;
            $data['parentescos'] = $this->gsatelite->get_dropdown('pat_parentesco', '{pat_nombre}','', array('pat_estado'=>1), null, '', 'pat_id', true);
            $data['titulo_personal'] = "Agregar Resolución";
            $this->_cargarvista($data, null);
        }
    }

    public function print_resol($rxeid=null) {
        satelite_validar();
        $docid = ($rxeid) ? $rxeid : $this->input->post('id_resoluc');
        if ($docid > 0) {
            $tabla_html = $this->gsatelite->get_tabla("rxe_resolucionxempleado", array("rxe_id" => $docid));
            if (count($tabla_html) > 0) {
                $html = $tabla_html[0]['rxe_html'];
                $this->pdf->setPrintFooter(false);
                $this->pdf->makePDF($html, 'P');
            } else {
                $this->gsatelite->show_dialog("No se puede Imprimir el formulario solicitado", "acciones_personal/principal/resoluciones", "error");
            }
        }
    }

    public function get_tipo_permisos(){
        $thfi = $this->input->post('id_tipo');
        $slic = $this->gsatelite->get_campo("thf_tipo_hora_faltante",'thf_licencia', array('thf_id' => $thfi));
        $whre = array('mtp_estado' => 1);
        if (intval($slic) > 0) {
            $whre["mtp_licencia"] = 1;
        } else {
            $whre["(mtp_licencia = 0 OR mtp_licencia IS NULL)"] = null;
        }
        $motivo = $this->gsatelite->get_dropdown('mtp_motivo_permiso', '{mtp_nombre}', '', $whre, null, '', 'mtp_id',true);
        $tipoPermiso = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $motivo);
        echo json_encode(array('dropdown' => $tipoPermiso));
    }

    public function correlativo_resolucion($tipo=null){
        satelite_validar();
        $tipoRes = ($tipo) ? $tipo : $this->input->post('tipo_res');
        $num = ($this->gsatelite->count('rxe_resolucionxempleado', array('rxe_id_rsl' => $tipoRes, 'YEAR(rxe_fecha_generado)' => date('Y')))) + 1;
        $prefijo = $this->gsatelite->get_campo('rsl_resolucion','rsl_correlativo_inicial', array('rsl_id' => $tipoRes));
        $numeric = str_pad($num, 3, '0', STR_PAD_LEFT);
        $codigor = $prefijo . $numeric;
        if ($tipo) {
            return $codigor;
        } else {
            echo json_encode(array('codigo' => $codigor));
        }        
    }

    //@author René Castaneda
    public function gestion_vacaciones_empleado($id_empleado = null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $permisos = $this->gsatelite->get_permisos_opcion('listado_empleados_vacacion');
            $data['permisos'] =  $permisos;
            $funcion_agregar_vacacion = "agregar_solicitud_vacacion2";
            $factor_m = '0';
            if ($this->gsatelite->get_parametro('METODO_CALCULO_VACACION') == 1) {
                $funcion_agregar_vacacion = "agregar_solicitud_vacacion2";
                $factor_m = $this->gsatelite->get_parametro('FACTOR_CALCULO_VACACION') * 100;
            }
            $factor_m = $this->gsatelite->get_parametro('FACTOR_CALCULO_VACACION') * 100;
            $this->verifica_empleado_real($id_empleado);
            $registro_empleado = $this->gsatelite->get_tabla('emp_empleado', array('emp_id' => $id_empleado));
            $data["info_empleado"] = $registro_empleado;
            $data["titulo_personal"] = "Gestión de Vacaciones empleado";
            $data["consulta"] = $this->accion_personal_model->get_vacaciones_empleado(array('gva_id_emp' => $id_empleado));
            $data["id_empleado"] = $registro_empleado[0]['emp_id'];
            $data['funcion_agregar_vacacion'] = $funcion_agregar_vacacion;
            $data['factor_mul'] = $factor_m;
            $this->_cargarvista($data, null);
        }
    }

    public function pago_vacacion($id_empleado, $gva_id){
        if ($_POST) {
            // var_dump($_POST);die();
            $registro_periodo = $this->gsatelite->get_registro('pla_planilla', 'pla_id', $this->input->post('periodo_planilla'));
            $registro_periodo2 = $this->gsatelite->get_registro('pla_planilla', 'pla_id', $this->input->post('periodo_planilla2'));
            $id_emp = $this->input->post('emp_id');
            if ($this->input->post('tipo_planilla') > 0 && $this->input->post('periodo_planilla') > 0) {
                $ingreso = array(
                    'inn_id_emp' => $id_emp,
                    'inn_id_tpl' => $this->input->post('tipo_planilla'),
                    'inn_id_tig' => $this->gsatelite->get_parametro('ID_TIG_VACACION'),
                    'inn_id_gva' => $this->input->post('gva_id'),
                    'inn_motivo' => $this->input->post('observaciones'),
                    'inn_observacion' => $this->input->post('observaciones'),
                    'inn_permanente' => 0,
                    'inn_valor' => $this->input->post('monto'),
                    'inn_fecha_desde' => formatear_fecha("Y-m-d", $registro_periodo->pla_fecha_inicio),
                    'inn_cuota' => 1,
                    'inn_cuota_pagada' => 0,
                    'inn_estado' => 1,
                    'inn_fecha_crea' => date("Y-m-d H:i:s"),
                    'inn_usu_crea' => $this->tank_auth->get_user_id(),
                    'inn_fecha_mod' => date("Y-m-d H:i:s"),
                    'inn_usu_mod' => $this->tank_auth->get_user_id()
                );
                $id_ingreso = $this->gsatelite->ingresar('inn_ingreso', $ingreso);
            }
            if ($this->input->post('tipo_planilla') > 0 && $this->input->post('periodo_planilla2') > 0) {  
                $desc_pgr = 0;
                $ingreso2 = array(
                    'inn_id_emp' => $id_emp,
                    'inn_id_tpl' => $this->input->post('tipo_planilla'),
                    'inn_id_tig' => $this->gsatelite->get_parametro('ID_INGRESO_PRIMA_VACACION'),
                    'inn_id_gva' => $this->input->post('gva_id'),
                    'inn_motivo' => $this->input->post('observaciones'),
                    'inn_observacion' => $this->input->post('observaciones'),
                    'inn_permanente' => 0,
                    'inn_valor' => $this->input->post('monto_factor'),
                    'inn_fecha_desde' => formatear_fecha("Y-m-d", $registro_periodo2->pla_fecha_inicio),
                    'inn_cuota' => 1,
                    'inn_cuota_pagada' => 0,
                    'inn_estado' => 1,
                    'inn_fecha_crea' => date("Y-m-d H:i:s"),
                    'inn_usu_crea' => $this->tank_auth->get_user_id(),
                    'inn_fecha_mod' => date("Y-m-d H:i:s"),
                    'inn_usu_mod' => $this->tank_auth->get_user_id()
                );
                $id_ingreso2 = $this->gsatelite->ingresar('inn_ingreso', $ingreso2);
                $tdc_pgr_id = $this->gsatelite->get_parametro_emp('SYS_DESCUENTO_PGR', null, null, array('TIPO_DESCUENTO_ID'));//TIPO DE DESCUENTO DE PROCURADURIA GNAL DE LA REP.
                $porc_pgr = $this->gsatelite->get_parametro_emp('SYS_DESCUENTO_PGR', null, null, array('PORCENTAJE'));
                if ($tdc_pgr_id > 0) {
                    $posee_desc = $this->gsatelite->get_tabla('dss_descuento', array('dss_estado' => 1, 'dss_permanente' => 1, 'dss_id_emp' => $id_emp, 'dss_id_tdc' => $tdc_pgr_id));
                    if (count($posee_desc) > 0) {
                        //SI EL EMPLEADO POSEE DESCUENTO PGR SE LE RETIENE UN PORCENTAJE DEL PORCENTAJE DE VACACIONES                        
                        $porc_pgr = (trim($porc_pgr) != "") ? trim($porc_pgr) : 0;
                        $desc_pgr = $this->input->post('monto_factor') * ($porc_pgr / 100);
                    }
                }
                if ($desc_pgr > 0) {
                    $descuentopgr = array(
                        'dss_id_emp' => $id_emp,
                        'dss_id_tpl' => $this->input->post('tipo_planilla'),
                        'dss_id_tdc' => $tdc_pgr_id,
                        'dss_id_gva' => $this->input->post('gva_id'),
                        'dss_referencia' => 'Descuento del ' . $porc_pgr . ' % aplicado sobre porcentaje vacacional',
                        'dss_motivo' => $this->input->post('observaciones'),
                        'dss_observacion' => $this->input->post('observaciones'),
                        'dss_valor' => $desc_pgr,
                        'dss_permanente' => 0,
                        'dss_fecha' => date("Y-m-d H:i:s"),
                        'dss_fecha_desde' => formatear_fecha("Y-m-d", $registro_periodo2->pla_fecha_inicio),
                        'dss_cuota' => 1,
                        'dss_cuota_pagada' => 0,
                        'dss_estado' => 1,
                        'dss_usu_crea' => $this->tank_auth->get_user_id(),
                        'dss_fecha_crea' => date("Y-m-d H:i:s"),
                        'dss_usu_mod' => $this->tank_auth->get_user_id(),
                        'dss_fecha_mod' => date("Y-m-d H:i:s")
                    );
                    $id_descuento = $this->gsatelite->ingresar('dss_descuento', $descuentopgr);
                }
            }
            if ($this->input->post('tipo_planilla_desc') > 0 && $this->input->post('periodo_planilla_desc') > 0) {  
                $tipo_desc = $this->gsatelite->get_parametro('ID_TDC_VACACION');
                $registro_pdo_desc = $this->gsatelite->get_registro('pla_planilla', 'pla_id', $this->input->post('periodo_planilla_desc'));
                //SI EL MONTO DE LAS VACAIONES ES MAYOR QUE LA QUINCENA NORMAL POR LAS COMISIONES, SOLO DESCUENTA LOS DIAS EN BASE AL EMP_SALARIO 
                $emp_salario = $this->gsatelite->get_campo('emp_empleado', 'emp_salario', array('emp_id' => $id_emp));
                $dias_mes = $this->gsatelite->get_parametro('DIAS_TRABAJADOS_MES', 30);
                $sal_vaca = (floatval($emp_salario) / $dias_mes) * $this->input->post('n_dias');
                $descuento = ($this->input->post('monto') > $sal_vaca) ? $sal_vaca : $this->input->post('monto');
                $datos_gva = $this->gsatelite->get_registro('gva_goce_vacacion', array('gva_id' => $gva_id));
                if (trim($tipo_desc) != "") {
                    $descuento = array(
                        'dss_id_emp' => $id_emp,
                        'dss_id_tpl' => $this->input->post('tipo_planilla_desc'),
                        'dss_id_tdc' => $tipo_desc,
                        'dss_id_gva' => $this->input->post('gva_id'),
                        'dss_referencia' => 'Inactivar ingreso corriente durante período vacacional (' . $datos_gva->gva_dias . ' días)',
                        'dss_motivo' => $this->input->post('observaciones'),
                        'dss_observacion' => $this->input->post('observaciones'),
                        'dss_valor' => $descuento,
                        'dss_permanente' => 0,
                        'dss_fecha' => date("Y-m-d H:i:s"),
                        'dss_fecha_desde' => formatear_fecha("Y-m-d", $registro_pdo_desc->pla_fecha_inicio),
                        'dss_cuota' => 1,
                        'dss_cuota_pagada' => 0,
                        'dss_estado' => 1,
                        'dss_usu_crea' => $this->tank_auth->get_user_id(),
                        'dss_fecha_crea' => date("Y-m-d H:i:s"),
                        'dss_usu_mod' => $this->tank_auth->get_user_id(),
                        'dss_fecha_mod' => date("Y-m-d H:i:s")
                    );
                    $id_descuento = $this->gsatelite->ingresar('dss_descuento', $descuento);
                }
            }
            $array_detalle = array(
                'gva_id_pla_pago' => ($this->input->post('periodo_planilla') > 0) ? $this->input->post('periodo_planilla') : null,
                'gva_id_pla_pago_factor' => ($this->input->post('periodo_planilla2') > 0) ? $this->input->post('periodo_planilla2') : null,
                'gva_usu_modificacion' => $this->tank_auth->get_user_id(),
                'gva_fecha_modificacion' => date("Y-m-d H:i:s")
            );
            $this->gsatelite->actualizar_array('gva_goce_vacacion', $array_detalle, array('gva_id' => $this->input->post('gva_id')));
            $this->gsatelite->show_dialog("Proceso realizado con éxito", "acciones_personal/principal/gestion_vacaciones_empleado/$id_emp");
        } else {
            $this->verifica_empleado_real($id_empleado);
            $base_calculo_vacacion = $this->accion_personal_model->promedio_salario_vacacion_empleado($id_empleado);
            $base_salary_by_income = $this->planilla_model->get_salary_from_incomes($id_empleado);
            $data['base_calculo_vacacion'] = ($base_calculo_vacacion > 0) ? $base_calculo_vacacion : $base_salary_by_income;
            $data["titulo_personal"] = "Pago de Vacaciones empleado";
            $data["info_empleado"] = $this->gsatelite->get_tabla('emp_empleado', array('emp_id' => $id_empleado));
            $data["info_vacacion"] = $this->gsatelite->get_tabla('gva_goce_vacacion', array('gva_id' => $gva_id));
            $ids_tpl = array(0);
            $pregunta = $this->gsatelite->get_tabla('txe_tipo_planillaxempleado', array('txe_id_emp' => $id_empleado));
            foreach ($pregunta as $fila) {
                $ids_tpl[] = $fila['txe_id_tpl'];
            }
                      $this->db->where_in('tpl_id', $ids_tpl);
            $select = $this->gsatelite->get_dropdown('tpl_tipo_planilla', '{tpl_nombre}', '', null, null, '', 'tpl_id', true);
            $data["select_tpl_id"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
            $data["factor_calculo_vacacion"] = $this->gsatelite->get_parametro('FACTOR_CALCULO_VACACION');
            $this->_cargarvista($data, null);
        }
    }

    public function pago_vacacion_edit($id_emp, $gva_id){
        satelite_validar();
        $tig_vac = $this->gsatelite->get_parametro('ID_TIG_VACACION');
        $tig_vpr = $this->gsatelite->get_parametro('ID_INGRESO_PRIMA_VACACION');
        $tig_des = $this->gsatelite->get_parametro('ID_TDC_VACACION');
        if ($_POST) {
            $pla_org_vac = $this->input->post('pla_org1');
            $pla_org_por = $this->input->post('pla_org2');
            $pla_org_des = $this->input->post('pla_orgd');
            if ($this->input->post('periodo_planilla') != $pla_org_vac) {
                $pla_org = $this->gsatelite->get_registro('pla_planilla', 'pla_id', $pla_org_vac);
                // SI LA PLANILLA NO ESTA AUTORIZADA
                if ($pla_org->pla_estado != 3) {
                    // BORRAR LOS DETALLES Y SI APLICA SE AGREGA EL NUEVO INGRESO
                    $ask_ing = $this->gsatelite->get_tabla('inn_ingreso', array('inn_id_gva' => $gva_id, 'inn_id_emp' => $id_emp, 'inn_id_tig' => $tig_vac));
                    foreach ($ask_ing as $key => $value) {
                        $this->gsatelite->borrado_general('ddi_detalle_ingreso', array('ddi_id_inn' => $value['inn_id']));
                    }
                    $this->gsatelite->borrado_general('inn_ingreso', array('inn_id' => $ask_ing[0]['inn_id']));
                    // SI LLEGA UNA NUEVA PLANILLA SE AGREGA EL INGRESO
                    if ($this->input->post('tipo_planilla') > 0 && $this->input->post('periodo_planilla') > 0) {
                        $registro_periodo = $this->gsatelite->get_registro('pla_planilla', 'pla_id', $this->input->post('periodo_planilla'));
                        $ingreso = array(
                            'inn_id_emp' => $id_emp,
                            'inn_id_tpl' => $this->input->post('tipo_planilla'),
                            'inn_id_tig' => $tig_vac,
                            'inn_id_gva' => $this->input->post('gva_id'),
                            'inn_motivo' => $this->input->post('observaciones'),
                            'inn_observacion' => $this->input->post('observaciones'),
                            'inn_permanente' => 0,
                            'inn_valor' => $this->input->post('monto'),
                            'inn_fecha_desde' => formatear_fecha("Y-m-d", $registro_periodo->pla_fecha_inicio),
                            'inn_cuota' => 1,
                            'inn_cuota_pagada' => 0,
                            'inn_estado' => 1,
                            'inn_fecha_crea' => date("Y-m-d H:i:s"),
                            'inn_usu_crea' => $this->tank_auth->get_user_id(),
                            'inn_fecha_mod' => date("Y-m-d H:i:s"),
                            'inn_usu_mod' => $this->tank_auth->get_user_id()
                        );
                        $id_ingreso = $this->gsatelite->ingresar('inn_ingreso', $ingreso);
                    }
                }
            }
            if ($this->input->post('periodo_planilla2') != $pla_org_por) {
                $pla_org = $this->gsatelite->get_registro('pla_planilla', 'pla_id', $pla_org_por);
                // SI LA PLANILLA NO ESTA AUTORIZADA
                if ($pla_org->pla_estado != 3) {
                    // BORRAR LOS DETALLES Y SI APLICA SE AGREGA EL NUEVO INGRESO
                    $ask_ing = $this->gsatelite->get_tabla('inn_ingreso', array('inn_id_gva' => $gva_id, 'inn_id_emp' => $id_emp, 'inn_id_tig' => $tig_vpr));
                    foreach ($ask_ing as $key => $value) {
                        $this->gsatelite->borrado_general('ddi_detalle_ingreso', array('ddi_id_inn' => $value['inn_id']));
                    }
                    $this->gsatelite->borrado_general('inn_ingreso', array('inn_id' => $ask_ing[0]['inn_id']));
                    // SI LLEGA UNA NUEVA PLANILLA SE AGREGA EL INGRESO
                    if ($this->input->post('tipo_planilla') > 0 && $this->input->post('periodo_planilla2') > 0) {
                        $registro_periodo2 = $this->gsatelite->get_registro('pla_planilla', 'pla_id', $this->input->post('periodo_planilla2'));
                        $ingreso2 = array(
                            'inn_id_emp' => $id_emp,
                            'inn_id_tpl' => $this->input->post('tipo_planilla'),
                            'inn_id_tig' => $tig_vpr,
                            'inn_id_gva' => $this->input->post('gva_id'),
                            'inn_motivo' => $this->input->post('observaciones'),
                            'inn_observacion' => $this->input->post('observaciones'),
                            'inn_permanente' => 0,
                            'inn_valor' => $this->input->post('monto_factor'),
                            'inn_fecha_desde' => formatear_fecha("Y-m-d", $registro_periodo2->pla_fecha_inicio),
                            'inn_cuota' => 1,
                            'inn_cuota_pagada' => 0,
                            'inn_estado' => 1,
                            'inn_fecha_crea' => date("Y-m-d H:i:s"),
                            'inn_usu_crea' => $this->tank_auth->get_user_id(),
                            'inn_fecha_mod' => date("Y-m-d H:i:s"),
                            'inn_usu_mod' => $this->tank_auth->get_user_id()
                        );
                        $id_ingreso2 = $this->gsatelite->ingresar('inn_ingreso', $ingreso2);
                    }
                }
            }
            if ($this->input->post('periodo_planilla_desc') != $pla_org_des) {
                $pla_org = $this->gsatelite->get_registro('pla_planilla', 'pla_id', $pla_org_des);
                // SI LA PLANILLA NO ESTA AUTORIZADA
                if ($pla_org->pla_estado != 3) {
                    // BORRAR LOS DETALLES Y SI APLICA SE AGREGA EL NUEVO DESCUENTO
                    $ask_des = $this->gsatelite->get_tabla('dss_descuento', array('dss_id_gva' => $gva_id, 'dss_id_emp' => $id_emp, 'dss_id_tdc' => $tig_des));
                    foreach ($ask_des as $key => $value) {
                        $this->gsatelite->borrado_general('ddd_detalle_descuento', array('ddd_id_dss' => $value['dss_id']));
                    }
                    $this->gsatelite->borrado_general('dss_descuento', array('dss_id_gva' => $gva_id));
                    // SI LLEGA UNA NUEVA PLANILLA SE AGREGA EL DESCUENTO
                    if ($this->input->post('tipo_planilla_desc') > 0 && $this->input->post('periodo_planilla_desc') > 0) {
                        $registro_pdo_desc = $this->gsatelite->get_registro('pla_planilla', 'pla_id', $this->input->post('periodo_planilla_desc'));
                        $datos_gva = $this->gsatelite->get_registro('gva_goce_vacacion', array('gva_id' => $gva_id));
                        $descuento = array(
                            'dss_id_emp' => $id_emp,
                            'dss_id_tpl' => $this->input->post('tipo_planilla_desc'),
                            'dss_id_tdc' => $tig_des,
                            'dss_id_gva' => $this->input->post('gva_id'),
                            'dss_referencia' => 'Inactivar ingreso corriente durante período vacacional (' . $datos_gva->gva_dias . ' días)',
                            'dss_motivo' => $this->input->post('observaciones'),
                            'dss_observacion' => $this->input->post('observaciones'),
                            'dss_valor' => $this->input->post('monto'),
                            'dss_permanente' => 0,
                            'dss_fecha' => date("Y-m-d H:i:s"),
                            'dss_fecha_desde' => formatear_fecha("Y-m-d", $registro_pdo_desc->pla_fecha_inicio),
                            'dss_cuota' => 1,
                            'dss_cuota_pagada' => 0,
                            'dss_estado' => 1,
                            'dss_usu_crea' => $this->tank_auth->get_user_id(),
                            'dss_fecha_crea' => date("Y-m-d H:i:s"),
                            'dss_usu_mod' => $this->tank_auth->get_user_id(),
                            'dss_fecha_mod' => date("Y-m-d H:i:s")
                        );
                        $id_descuento = $this->gsatelite->ingresar('dss_descuento', $descuento);
                    }
                }
            }
            // SI NO HAY PLANILLA SE PASA A NULL
            $pla_org_vac_old = ($pla_org_por > 0) ? $pla_org_por : null;
            $pla_org_por_old = ($pla_org_por > 0) ? $pla_org_por : null;
            $pla_org_vac_new = ($this->input->post('periodo_planilla') > 0) ? $this->input->post('periodo_planilla') : null;
            $pla_org_por_new = ($this->input->post('periodo_planilla2') > 0) ? $this->input->post('periodo_planilla2') : null;
            $array_detalle = array(
                'gva_id_pla_pago' => ($this->input->post('periodo_planilla') != $pla_org_vac) ? $pla_org_vac_new : $pla_org_vac_old,
                'gva_id_pla_pago_factor' => ($this->input->post('periodo_planilla2') != $pla_org_por) ? $pla_org_por_new : $pla_org_por_old,
                'gva_usu_modificacion' => $this->tank_auth->get_user_id(),
                'gva_fecha_modificacion' => date("Y-m-d H:i:s")
            );
            $this->gsatelite->actualizar_array('gva_goce_vacacion', $array_detalle, array('gva_id' => $this->input->post('gva_id')));
            $this->gsatelite->show_dialog("Recuerde generar las planillas correspondientes.", "acciones_personal/principal/gestion_vacaciones_empleado/$id_emp", "success", "Proceso realizado con éxito");
        } else {
            $this->verifica_empleado_real($id_emp);
            $data["titulo_personal"] = "Pago de Vacaciones empleado";
            $data["info_empleado"] = $this->gsatelite->get_tabla('emp_empleado', array('emp_id' => $id_emp));
            $data["info_vacacion"] = $this->gsatelite->get_tabla('gva_goce_vacacion', array('gva_id' => $gva_id));
            $ids_tpl = array(0);
            $pregunta = $this->gsatelite->get_tabla('txe_tipo_planillaxempleado', array('txe_id_emp' => $id_emp));
            foreach ($pregunta as $fila) {
                $ids_tpl[] = $fila['txe_id_tpl'];
            }
            $tpl_inn = $this->accion_personal_model->get_tpl_vac_inn(array("gva_id_emp" => $id_emp, "gva_id" => $gva_id, "inn_id_tig IN ($tig_vac, $tig_vpr)" => null));
            $tpl_dss = $this->accion_personal_model->get_tpl_vac_dss(array("gva_id_emp" => $id_emp, "gva_id" => $gva_id, "dss_id_tdc" => $tig_des));
                        $this->db->where_in('tpl_id', $ids_tpl);
            $slct_inn = $this->gsatelite->get_dropdown('tpl_tipo_planilla', '{tpl_nombre}', '', null, $tpl_inn->tpl_id, '', 'tpl_id', true);
                        $this->db->where_in('tpl_id', $ids_tpl);
            $slct_des = $this->gsatelite->get_dropdown('tpl_tipo_planilla', '{tpl_nombre}', '', null, $tpl_dss->tpl_id, '', 'tpl_id', true);
            $plaslct1 = $this->accion_personal_model->get_pla_slctd(array('inn_id_emp'=>$id_emp,'inn_id_gva'=>$gva_id,'inn_id_tig'=>$tig_vac,'tpl_id'=>$tpl_inn->tpl_id),"I");
            $plaslct2 = $this->accion_personal_model->get_pla_slctd(array('inn_id_emp'=>$id_emp,'inn_id_gva'=>$gva_id,'inn_id_tig'=>$tig_vpr,'tpl_id'=>$tpl_inn->tpl_id),"I");
            $plaslct3 = $this->accion_personal_model->get_pla_slctd(array('dss_id_emp'=>$id_emp,'dss_id_gva'=>$gva_id,'dss_id_tdc'=>$tig_des,'tpl_id'=>$tpl_dss->tpl_id),"E");
            $data["inn_1"] = $plaslct1->inn_id;
            $data["inn_2"] = $plaslct2->inn_id;
            $data["dss_1"] = $plaslct3->dss_id;
            $data["pla_1"] = $plaslct1->pla_id;
            $data["pla_2"] = $plaslct2->pla_id;
            $data["pla_d"] = $plaslct3->pla_id;
            $where1 = array('pla_estado > ' => 0, 'pla_estado < ' => 3, 'pla_id_tpl' => $tpl_inn->tpl_id);
                        $this->db->order_by('pla_fecha_inicio', 'DESC');
            $slc_inn1 = $this->gsatelite->get_dropdown('pla_planilla', '{pla_fecha_inicio} # {pla_fecha_fin}', '', $where1, $plaslct1->pla_id, '', '', true);
            $where2 = array('pla_estado > ' => 0, 'pla_estado < ' => 3, 'pla_id_tpl' => $tpl_inn->tpl_id);
                        $this->db->order_by('pla_fecha_inicio', 'DESC');
            $slc_inn2 = $this->gsatelite->get_dropdown('pla_planilla', '{pla_fecha_inicio} # {pla_fecha_fin}', '', $where2, $plaslct2->pla_id, '', '', true);
            $where3 = array('pla_estado > ' => 0, 'pla_estado < ' => 3, 'pla_id_tpl' => $tpl_dss->tpl_id);
                        $this->db->order_by('pla_fecha_inicio', 'DESC');
            $slc_inn3 = $this->gsatelite->get_dropdown('pla_planilla', '{pla_fecha_inicio} # {pla_fecha_fin}', '', $where3, $plaslct3->pla_id, '', '', true);
            $obs = $this->db->select('DISTINCT inn_observacion',false)->from('inn_ingreso')->where(array('inn_id_gva'=>$gva_id,'inn_id_emp'=>$id_emp))->get()->row();
            $base_calculo_vacacion = $this->accion_personal_model->promedio_salario_vacacion_empleado($id_emp);
            $base_salary_by_income = $this->planilla_model->get_salary_from_incomes($id_emp);
            $data['base_calculo_vacacion'] = ($base_calculo_vacacion > 0) ? $base_calculo_vacacion : $base_salary_by_income;
            $data["observaciones"] = $obs->inn_observacion; 
            $data["select_tpl_id"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $slct_inn);
            $data["select_tpl_ds"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $slct_des);
            $data["slct_pla_innv"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $slc_inn1);
            $data["slct_pla_innp"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $slc_inn2);
            $data["slct_pla_desc"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $slc_inn3);
            $data["factor_calculo_vacacion"] = $this->gsatelite->get_parametro('FACTOR_CALCULO_VACACION');
            $this->_cargarvista($data, null);
        }
    }

    //@author René Castaneda
    //funcion utilizada para el caso de calculos segun Ylufa.
    public function agregar_solicitud_vacacion($id_empleado = null) {
        redirect("acciones_personal/principal/agregar_solicitud_vacacion2/$id_empleado");
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($_POST) {
                //die(var_dump($_POST));
                //ingreso
                $registro_periodo = $this->gsatelite->get_registro('pla_planilla', 'pla_id', $this->input->post('periodo_planilla'));
                //descuento
                $registro_periodo2 = $this->gsatelite->get_registro('pla_planilla', 'pla_id', $this->input->post('periodo_planilla2'));

                $array_detalle = array(
                    'gva_id_emp' => $this->input->post('emp_id')
                    , 'gva_id_vac' => $this->input->post('id_vac')
                    , 'gva_desde' => date("Y-m-d", strtotime($this->input->post('fecha_desde')))
                    , 'gva_hasta' => date("Y-m-d", strtotime($this->input->post('fecha_hasta')))
                    , 'gva_id_pla_pago' => $this->input->post('periodo_planilla')
                    , 'gva_id_pla_goce' => $this->input->post('periodo_planilla2')
                    , 'gva_tipo_calculo' => 3 // unificacion del registro de ambos montos en un solo registro 
                    , 'gva_estado' => 1
                    , 'gva_fecha_mod' => date("Y-m-d H:i:s")
                    , 'gva_usu_mod' => $this->tank_auth->get_user_id()
                );
                $id_detalle_gva = $this->gsatelite->ingresar('gva_goce_vacacion', $array_detalle);
                //ahora ingresar el ingreso en la tabla ingreso
                $ingreso = array(
                    'inn_id_emp' => $this->input->post('emp_id'),
                    'inn_id_tpl' => $this->input->post('tipo_planilla'),
                    'inn_id_tig' => $this->gsatelite->get_parametro('ID_TIG_VACACION'),
                    'inn_id_gva' => $id_detalle_gva,
                    'inn_motivo' => $this->input->post('observaciones'),
                    'inn_observacion' => $this->input->post('observaciones'),
                    'inn_permanente' => 0,
                    'inn_valor' => $this->input->post('monto'),
                    'inn_fecha_desde' => date("Y-m-d", strtotime($registro_periodo->pla_fecha_inicio)),
                    'inn_cuota' => 1,
                    'inn_cuota_pagada' => 0,
                    'inn_estado' => 1,
                    'inn_fecha_mod' => date("Y-m-d H:i:s"),
                    'inn_usu_mod' => $this->tank_auth->get_user_id()
                );
                $id_ingreso = $this->gsatelite->ingresar('inn_ingreso', $ingreso);

                $descuento = array(
                    'dss_id_emp' => $this->input->post('emp_id'),
                    'dss_id_tpl' => $this->input->post('tipo_planilla'),
                    'dss_id_tdc' => $this->gsatelite->get_parametro('ID_TDC_VACACION'),
                    'dss_id_gva' => $id_detalle_gva,
                    'dss_referencia' => $this->input->post('observaciones'),
                    'dss_motivo' => $this->input->post('observaciones'),
                    'dss_observacion' => $this->input->post('observaciones'),
                    'dss_permanente' => 0,
                    'dss_valor' => $this->input->post('monto'),
                    'dss_fecha' => date('Y-m-d H:i:s'),
                    'dss_fecha_desde' => date("Y-m-d", strtotime($registro_periodo2->pla_fecha_inicio)),
                    'dss_cuota' => 1,
                    'dss_cuota_pagada' => 0,
                    'dss_estado' => 1,
                    'dss_fecha_mod' => date("Y-m-d H:i:s"),
                    'dss_usu_mod' => $this->tank_auth->get_user_id()
                );
                $id_descuento = $this->gsatelite->ingresar('dss_descuento', $descuento);
                //actualizar el registro de la vacacion
                $registro_vacacion = $this->gsatelite->get_registro('vac_vacacion', 'vac_id', $this->input->post('id_vac'));
                $nDias = $this->input->post('n_dias');
                $ngozado = $nDias + $registro_vacacion->vac_dia_gozado;
                $nresta = $registro_vacacion->vac_dia_ganado - $ngozado;
                $estado = ($nresta == 0) ? 0 : 1;
                $update_vac = array(
                    'vac_dia_gozado' => $ngozado
                    , 'vac_estado' => $estado
                );
                $this->gsatelite->actualizar_array('vac_vacacion', $update_vac, array('vac_id' => $this->input->post('id_vac')));

                $id_emp = $this->input->post('emp_id');
                $this->gsatelite->show_dialog("Proceso realizado con éxito", "acciones_personal/principal/gestion_vacaciones_empleado/$id_emp");
            } else {
                $this->verifica_empleado_real($id_empleado);
                $data["titulo_personal"] = "Gestión de Vacaciones empleado";
                $data["info_empleado"] = $this->gsatelite->get_tabla('emp_empleado', array('emp_id' => $id_empleado));

                $this->db->join('prv_periodo_vacacion', 'prv_id=vac_id_prv');
                $this->db->order_by('prv_desde', 'asc');
                $data["vacaciones_empleado"] = $this->gsatelite->get_tabla('vac_vacacion', array('vac_id_emp' => $id_empleado, 'vac_estado' => 1));

                //PLANILLAS AL QUE PERTENECE EL EMPLEADO
                $ids_tpl = array(0);
                $pregunta = $this->gsatelite->get_tabla('txe_tipo_planillaxempleado', array('txe_id_emp' => $id_empleado));
                foreach ($pregunta as $fila) {
                    $ids_tpl[] = $fila['txe_id_tpl'];
                }
                $this->db->where_in('tpl_id', $ids_tpl);
                $select = $this->gsatelite->get_dropdown('tpl_tipo_planilla', '{tpl_nombre}', '', null, null, '', 'tpl_id', true);
                $data["select_tpl_id"] = str_replace('<option value="0">Seleccione</option>', '', $select);

                $data["factor_calculo_vacacion"] = $this->gsatelite->get_parametro('FACTOR_CALCULO_VACACION');

                $this->_cargarvista($data, null);
            }
        }
    }

    //@author René Castaneda
    //funcion utilizada para el caso de calculos segun EMI
    public function agregar_solicitud_vacacion2($id_empleado = null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            if ($_POST) {
                //ingreso vacación
                $registro_periodo = $this->gsatelite->get_registro('pla_planilla', 'pla_id', $this->input->post('periodo_planilla'));
                //ingreso prima vacación.
                $registro_periodo2 = $this->gsatelite->get_registro('pla_planilla', 'pla_id', $this->input->post('periodo_planilla2'));
                //registro del detalle para el ingreso del monto de la vacacion.
                $array_detalle = array(
                    'gva_id_emp' => $this->input->post('emp_id'),
                    'gva_id_vac' => $this->input->post('id_vac'),
                    'gva_desde' => formatear_fecha("Y-m-d", $this->input->post('fecha_desde')),
                    'gva_hasta' => formatear_fecha("Y-m-d", $this->input->post('fecha_hasta')),
                    'gva_dias' => $this->input->post('n_dias'),
                    'gva_id_pla_pago' => ($this->input->post('periodo_planilla') > 0)? $this->input->post('periodo_planilla') : null,
                    'gva_id_pla_pago_factor' => ($this->input->post('periodo_planilla2') > 0)? $this->input->post('periodo_planilla2') : null,
                    'gva_id_pla_goce' => null,
                    'gva_tipo_calculo' => 1, // tipo de cálculo 1 (registro de la transaccion del monto de vacacion)
                    'gva_estado' => 1,
                    'gva_fecha_creacion' => date("Y-m-d H:i:s"),
                    'gva_usu_creacion' => $this->tank_auth->get_user_id(),
                    'gva_fecha_modificacion' => date("Y-m-d H:i:s"),
                    'gva_usu_modificacion' => $this->tank_auth->get_user_id()
                );
                $id_detalle_gva1 = $this->gsatelite->ingresar('gva_goce_vacacion', $array_detalle);
                //registro del detalle para el ingreso del monto del factor de multiplicacion (llamada prima 30% ). (el 30% es un parametro)
                /*
                $array_detalle2 = array(
                    'gva_id_emp' => $this->input->post('emp_id')
                    , 'gva_id_vac' => $this->input->post('id_vac')
                    , 'gva_desde' => date("Y-m-d", strtotime($this->input->post('fecha_desde')))
                    , 'gva_hasta' => date("Y-m-d", strtotime($this->input->post('fecha_hasta')))
                    , 'gva_id_pla_pago' => $this->input->post('periodo_planilla2')
                    , 'gva_id_pla_goce' => null
                    , 'gva_tipo_calculo' => 2 // tipo de cálculo 2 (registro de la transaccion del factor de multiplicacion (30%))
                    , 'gva_estado' => 1
                    , 'gva_fecha_mod' => date("Y-m-d H:i:s")
                    , 'gva_usu_mod' => $this->tank_auth->get_user_id()
                );
                $id_detalle_gva2 = $this->gsatelite->ingresar('gva_goce_vacacion', $array_detalle2);
                */
                if ($this->input->post('tipo_planilla') > 0 && $this->input->post('periodo_planilla') > 0) {             
                    //ahora ingresar el ingreso en la tabla inn_ingreso correspondiente al monto de la vacación
                    $ingreso = array(
                        'inn_id_emp' => $this->input->post('emp_id'),
                        'inn_id_tpl' => $this->input->post('tipo_planilla'),
                        'inn_id_tig' => $this->gsatelite->get_parametro('ID_TIG_VACACION'),
                        'inn_id_gva' => $id_detalle_gva1,
                        'inn_motivo' => $this->input->post('observaciones'),
                        'inn_observacion' => $this->input->post('observaciones'),
                        'inn_permanente' => 0,
                        'inn_valor' => $this->input->post('monto'),
                        'inn_fecha_desde' => formatear_fecha("Y-m-d", $registro_periodo->pla_fecha_inicio),
                        'inn_cuota' => 1,
                        'inn_cuota_pagada' => 0,
                        'inn_estado' => 1,
                        'inn_fecha_crea' => date("Y-m-d H:i:s"),
                        'inn_usu_crea' => $this->tank_auth->get_user_id(),
                        'inn_fecha_mod' => date("Y-m-d H:i:s"),
                        'inn_usu_mod' => $this->tank_auth->get_user_id()
                    );
                    $id_ingreso = $this->gsatelite->ingresar('inn_ingreso', $ingreso);
                }
                //ahora ingresar el ingreso en la tabla inn_ingreso correspondiente al monto del factor de multiplicacion
                if ($this->input->post('tipo_planilla') > 0 && $this->input->post('periodo_planilla2') > 0) {
                    $ingreso2 = array(
                        'inn_id_emp' => $this->input->post('emp_id'),
                        'inn_id_tpl' => $this->input->post('tipo_planilla'),
                        'inn_id_tig' => $this->gsatelite->get_parametro('ID_INGRESO_PRIMA_VACACION'),
                        'inn_id_gva' => $id_detalle_gva1,//$id_detalle_gva2,
                        'inn_motivo' => $this->input->post('observaciones'),
                        'inn_observacion' => $this->input->post('observaciones'),
                        'inn_permanente' => 0,
                        'inn_valor' => $this->input->post('monto_factor'),
                        'inn_fecha_desde' => formatear_fecha("Y-m-d", $registro_periodo2->pla_fecha_inicio),
                        'inn_cuota' => 1,
                        'inn_cuota_pagada' => 0,
                        'inn_estado' => 1,
                        'inn_fecha_crea' => date("Y-m-d H:i:s"),
                        'inn_usu_crea' => $this->tank_auth->get_user_id(),
                        'inn_fecha_mod' => date("Y-m-d H:i:s"),
                        'inn_usu_mod' => $this->tank_auth->get_user_id()
                    );
                    $id_ingreso2 = $this->gsatelite->ingresar('inn_ingreso', $ingreso2);
                }
                //actualizar el registro de la vacacion
                $registro_vacacion = $this->gsatelite->get_registro('vac_vacacion', 'vac_id', $this->input->post('id_vac'));
                $nDias = $this->input->post('n_dias');
                $ngozado = $nDias + (($registro_vacacion->vac_dia_gozado)? $registro_vacacion->vac_dia_gozado: 0 );
                $nresta = $registro_vacacion->vac_dia_ganado - $ngozado;
                $estado = ($nresta == 0) ? 0 : 1;
                $update_vac = array(
                    'vac_dia_gozado' => $ngozado,
                    'vac_estado' => $estado,
                    'vac_fecha_modificacion' => date("Y-m-d H:i:s"),
                    'vac_usu_modificacion' => $this->tank_auth->get_user_id()
                );
                $this->gsatelite->actualizar_array('vac_vacacion', $update_vac, array('vac_id' => $this->input->post('id_vac')));
                $id_emp = $this->input->post('emp_id');
                $empresa = strtolower(trim($this->gsatelite->get_parametro('SYS_SIGLAS', '')));
                if ($empresa == 'midem') {
                    $update_emp = array(
                        'emp_fecha_ult_vacacion' => formatear_fecha("Y-m-d", $this->input->post('fecha_hasta')),
                        'emp_usu_mod' => $this->tank_auth->get_user_id(),
                        'emp_fecha_mod' => date("Y-m-d H:i:s")
                    );
                    $this->gsatelite->actualizar_array('emp_empleado', $update_emp, array('emp_id' => $id_emp));
                }
                $this->gsatelite->show_dialog("Proceso realizado con éxito", "acciones_personal/principal/gestion_vacaciones_empleado/$id_emp");
            } else {
                $this->verifica_empleado_real($id_empleado);
                //ESTA VARIABLE OBTENDRA EL VALOR CORRESPONDIENTE AL VALOR BASE PARA EL CALCULO DE LA VACACION
                $base_calculo_vacacion = $this->accion_personal_model->promedio_salario_vacacion_empleado($id_empleado);
                $data['base_calculo_vacacion'] = $base_calculo_vacacion; // este se tomara como el salario del empleado
                $data["titulo_personal"] = "Gestión de Vacaciones empleado";
                $data["info_empleado"] = $this->gsatelite->get_tabla('emp_empleado', array('emp_id' => $id_empleado));

                                               $this->db->order_by('prv_desde', 'asc');
                                               $this->db->join('prv_periodo_vacacion', 'prv_id=vac_id_prv');
                $data["vacaciones_empleado"] = $this->gsatelite->get_tabla('vac_vacacion', array('vac_id_emp' => $id_empleado, 'vac_estado' => 1));

                //PLANILLAS AL QUE PERTENECE EL EMPLEADO
                $ids_tpl = array(0);
                $pregunta = $this->gsatelite->get_tabla('txe_tipo_planillaxempleado', array('txe_id_emp' => $id_empleado));
                foreach ($pregunta as $fila) {
                    $ids_tpl[] = $fila['txe_id_tpl'];
                }
                          $this->db->where_in('tpl_id', $ids_tpl);
                $select = $this->gsatelite->get_dropdown('tpl_tipo_planilla', '{tpl_nombre}', '', null, null, '', 'tpl_id', true);
                $data["select_tpl_id"] = str_replace('<option value="0">Seleccione</option>', '', $select);
                $data["factor_calculo_vacacion"] = $this->gsatelite->get_parametro('FACTOR_CALCULO_VACACION');
                $this->_cargarvista($data, null);
            }
        }
    }

    public function editar_detalle_vacacion($id_vacacion = 0){
        satelite_validar();
        if ($_POST) {
            $tig_vac = $this->gsatelite->get_parametro('ID_TIG_VACACION');
            $tig_por = $this->gsatelite->get_parametro('ID_INGRESO_PRIMA_VACACION');
            $tdc_dsc = $this->gsatelite->get_parametro('ID_TDC_VACACION');
            $nDias = $this->input->post('n_dias');
            $id_emp = $this->input->post('emp_id');
            $id_vac = $this->input->post('id_vac');
            $array_detalle = array(
                'gva_id_emp' => $this->input->post('emp_id'),
                'gva_id_vac' => $this->input->post('id_vac'),
                'gva_desde' => formatear_fecha("Y-m-d", $this->input->post('fecha_desde')),
                'gva_hasta' => formatear_fecha("Y-m-d", $this->input->post('fecha_hasta')),
                'gva_dias' => $nDias,
                'gva_fecha_modificacion' => date("Y-m-d H:i:s"),
                'gva_usu_modificacion' => $this->tank_auth->get_user_id()
            );
            $upd_gva = $this->gsatelite->actualizar_array('gva_goce_vacacion', $array_detalle, array('gva_id' => $id_vacacion));                
            $registro_vacacion = $this->gsatelite->get_registro('vac_vacacion', 'vac_id', $id_vac);
            $otros = $this->gsatelite->get_suma('gva_goce_vacacion', 'gva_dias', array('gva_estado'=>1,'gva_id_emp'=> $id_emp,'gva_id_vac'=>$id_vac,'gva_id <> '=>$id_vacacion));
            $gozado = ($registro_vacacion->vac_dia_gozado > 0) ? $registro_vacacion->vac_dia_gozado : 0;
            $ngozado = $nDias + $otros;
            $nresta = $registro_vacacion->vac_dia_ganado - $ngozado;
            $update_vac = array(
                'vac_dia_gozado' => $ngozado,
                'vac_estado' => ($nresta == 0) ? 0 : 1,
                'vac_fecha_modificacion' => date("Y-m-d H:i:s"),
                'vac_usu_modificacion' => $this->tank_auth->get_user_id()
            );
            $this->gsatelite->actualizar_array('vac_vacacion', $update_vac, array('vac_id' => $id_vac));
            if ($this->input->post('monto') > 0 && $this->input->post('monto_orig') > 0 && ($this->input->post('monto') != $this->input->post('monto_orig'))) {
                            $this->db->join('ddi_detalle_ingreso' ,'ddi_id_inn = inn_id', 'left');
                            $this->db->join('pla_planilla', 'pla_id = ddi_id_pla', 'left');
                $exst_inn = $this->gsatelite->get_tabla('inn_ingreso', array('inn_id_emp' => $id_emp, 'inn_id_gva' => $id_vacacion, 'inn_id_tig' => $tig_vac));
                            $this->db->join('ddd_detalle_descuento' ,'ddd_id_dss = dss_id', 'left');
                            $this->db->join('pla_planilla', 'pla_id = ddd_id_pla', 'left');
                $exst_dss = $this->gsatelite->get_tabla('dss_descuento', array('dss_id_emp' => $id_emp, 'dss_id_gva' => $id_vacacion, 'dss_id_tdc' => $tdc_dsc));
                if (count($exst_inn) > 0) {
                    if ($exst_inn[0]['pla_estado'] != 3) {
                        if ($exst_inn[0]['ddi_id'] != "") {
                            $this->gsatelite->borrado_general('ddi_detalle_ingreso', array('ddi_id_inn' => $exst_inn[0]['inn_id']));
                        }
                        $upd_inn_vac = array(
                            'inn_valor' => $this->input->post('monto'),
                            'inn_estado' => 1,
                            'inn_fecha_mod' => date("Y-m-d H:i:s"),
                            'inn_usu_mod' => $this->tank_auth->get_user_id()
                        );
                        $this->gsatelite->actualizar_array('inn_ingreso', $upd_inn_vac, array('inn_id' => $exst_inn[0]['inn_id']));
                        $txt_ingreso = "";
                    } else {
                        $txt_ingreso = "No se pudo cambiar el ingreso, Planilla ya autorizada";
                    }
                }
                if (count($exst_dss) > 0) {
                    if ($exst_dss[0]['pla_estado'] != 3) {
                        if ($exst_dss[0]['ddd_id'] != "") {
                            $this->gsatelite->borrado_general('ddd_detalle_descuento', array('ddd_id_dss' => $exst_dss[0]['dss_id']));
                        }
                        $upd_inn_dsc = array(
                            'dss_valor' => $this->input->post('monto'),
                            'dss_estado' => 1,
                            'dss_usu_mod' => $this->tank_auth->get_user_id(),
                            'dss_fecha_mod' => date("Y-m-d H:i:s")
                        );
                        $this->gsatelite->actualizar_array('dss_descuento', $upd_inn_dsc, array('dss_id' => $exst_dss[0]['dss_id']));
                    }
                }
            }
            if ($this->input->post('monto_factor') > 0 && $this->input->post('monto_factor_orig') > 0 && ($this->input->post('monto_factor') != $this->input->post('monto_factor_orig'))) {
                            $this->db->join('ddi_detalle_ingreso' ,'ddi_id_inn = inn_id', 'left');
                            $this->db->join('pla_planilla', 'pla_id = ddi_id_pla', 'left');
                $exst_in2 = $this->gsatelite->get_tabla('inn_ingreso', array('inn_id_emp' => $id_emp, 'inn_id_gva' => $id_vacacion, 'inn_id_tig' => $tig_por));
                if (count($exst_in2) > 0) {
                    if ($exst_in2[0]['pla_estado'] != 3 ) {
                        if ($exst_in2[0]['ddi_id'] != "") {
                            $this->gsatelite->borrado_general('ddi_detalle_ingreso', array('ddi_id_inn' => $exst_in2[0]['inn_id']));
                        }
                        $upd_inn_por = array(
                            'inn_valor' => $this->input->post('monto_factor'),
                            'inn_estado' => 1,
                            'inn_fecha_mod' => date("Y-m-d H:i:s"),
                            'inn_usu_mod' => $this->tank_auth->get_user_id()
                        );
                        $this->gsatelite->actualizar_array('inn_ingreso', $upd_inn_por, array('inn_id' => $exst_in2[0]['inn_id']));
                        $txt_ingreso = "";
                    } else {
                        $txt_ingreso = "No se pudo cambiar el ingreso, Planilla ya autorizada";
                    }                    
                }
            }
            if ($upd_gva > 0) {
                $mensaje = 'Proceso realizado con éxito';
                $tipo = 'success';
            } else {
                $mensaje = 'Ocurrio un error en el proceso';
                $tipo = 'error';                    
            }
            $this->gsatelite->show_dialog("", "acciones_personal/principal/gestion_vacaciones_empleado/$id_emp", $tipo, $mensaje);
        } else {
            $registro_detalle = $this->gsatelite->accion_personal_model->get_detalle_vacacion(array('gva_id' => $id_vacacion));
            $data['base_calculo_vacacion'] = $this->accion_personal_model->promedio_salario_vacacion_empleado($registro_detalle[0]['gva_id_emp']);
            $data["factor_calculo_vacacion"] = $this->gsatelite->get_parametro('FACTOR_CALCULO_VACACION');
            $this->db->order_by('prv_desde', 'ASC');
            $this->db->join('prv_periodo_vacacion', 'prv_id = vac_id_prv');
            $data["vacaciones"] = $this->gsatelite->get_tabla('vac_vacacion', array('vac_id_emp' => $registro_detalle[0]['gva_id_emp']));
            $data["registro"] = $registro_detalle[0];
            $data["titulo_personal"] = "Editar Detalle Vacaciones Empleada/o";
            $this->_cargarvista($data, null);
        }
    }

    function n_dias_fechas($fecha1 = null, $fecha2 = null) {
        //fecha1 (menor), fecha2 (mayor)
        $f1 = ($fecha1 != null) ? $fecha1 : $this->input->post('f1');
        $f2 = ($fecha2 != null) ? $fecha2 : $this->input->post('f2');
        $n = $this->gsatelite->get_intervalo_dias($f1, $f2);
        $n = (is_numeric($n))? ($n + 1): $n; //tomar en cuenta el dia de inicio
        $id_empleado = $this->input->post('id_empleado');
        if ($id_empleado) {
            //Preguntar por la generacion de las 6 ultimas planillas del empleado
            $existen_periodos = false;
            $where = array(
                "gva_id_emp" => $id_empleado,
                "(('".formatear_fecha('Y-m-d',$f1)."' BETWEEN gva_desde AND gva_hasta) OR ('".formatear_fecha('Y-m-d',$f2)."' BETWEEN gva_desde AND gva_hasta))" => null
            );
            if ($this->input->post('editar_gvas') != null) {
                $where['gva_id != '] = $this->input->post('editar_gvas');
            }
            $pregunta = $this->gsatelite->get_tabla('gva_goce_vacacion', $where);
            if (count($pregunta) > 0) {
                $existen_periodos = true; //Existen otros periodos que se traslapan
            }
            if ($fecha1 == null and $fecha2 == null) {
                echo json_encode(array('num_dias' => $n, 'error_per' => $existen_periodos));
            } else {
                return $n;
            }
        } else {
            if ($fecha1 == null and $fecha2 == null) {
                echo json_encode(array('num_dias' => $n, 'error_per' => $existen_periodos));
            } else {
                return $n;
            }
        }
    }

    //René Castaneda
    function eliminar_detalle_vacacion($id_gva) {
        $this->gsatelite->verificar_registro_real('gva_goce_vacacion',$id_gva);
        $registro_eliminar = $this->gsatelite->get_registro('gva_goce_vacacion', 'gva_id', $id_gva);
        $registro_vacacion = $this->gsatelite->get_registro('vac_vacacion', 'vac_id', $registro_eliminar->gva_id_vac);

        //PREGUNTAR POR EL INGRESO Y EL DESCUENTO
        $preguntar_ing = $this->gsatelite->get_tabla('inn_ingreso', array('inn_id_gva' => $registro_eliminar->gva_id));
        $inn_id = (count($preguntar_ing) > 0) ? $preguntar_ing[0]['inn_id'] : 0;
        $preguntar_dsc = $this->gsatelite->get_tabla('dss_descuento', array('dss_id_gva' => $registro_eliminar->gva_id));
        $dsc_id = (count($preguntar_dsc) > 0) ? $preguntar_dsc[0]['dss_id'] : 0;

        //consultar si ya poseen registro en la tabla de detalles de ingreso y descuentos en la generacion de planilla
        $this->db->join('pla_planilla', 'pla_id=ddi_id_pla');
        $detalle_ing = $this->gsatelite->get_tabla('ddi_detalle_ingreso', array('ddi_id_inn' => $inn_id));

        $this->db->join('pla_planilla', 'pla_id = ddd_id_pla');
        $detalle_des = $this->gsatelite->get_tabla('ddd_detalle_descuento', array('ddd_id_dss' => $dsc_id));

        $se_puede = true;
        if (count($detalle_ing) > 0) {
            if ($detalle_ing[0]['pla_estado'] == 3 ) { //preguntar si la planilla esta autorizada
                $se_puede = false;
            }
        }

        if ($se_puede) {
            //ACTUALIZAR EL REGISTRO DE LA VACACIÓN. (DESCONTAR LOS DIAS GOZADOS -YA QUE SE ELIMINARÁ EL REGISTRO- )
            $nDias = $this->gsatelite->get_intervalo_dias($registro_eliminar->gva_desde, $registro_eliminar->gva_hasta);
            $nDias = $nDias + 1;
            $ngozado = $registro_vacacion->vac_dia_gozado - $nDias;
            $nresta = $registro_vacacion->vac_dia_ganado - $ngozado;
            $estado = ($nresta == 0) ? 0 : 1;
            $update_vac = array(
                'vac_dia_gozado' => $ngozado
                , 'vac_estado' => $estado
                , 'vac_fecha_modificacion' => date("Y-m-d H:i:s")
                , 'vac_usu_modificacion' => $this->tank_auth->get_user_id()
            );
            $this->gsatelite->actualizar_array('vac_vacacion', $update_vac, array('vac_id' => $registro_vacacion->vac_id));
            //ACTUALIZAR
            //ELIMINAR EL DETALLE ASI COMO TAMBIEN EL INGRESO Y EL DESCUENTO QUE ESE DETALLE GENERO
            //eliminar los detalles de planilla (si la planilla ya se genero.)
            if (count($preguntar_ing) > 0 ) {
                foreach ($preguntar_ing as $registro_inn) {
                    $this->gsatelite->borrado_general('ddi_detalle_ingreso',array('ddi_id_inn'=>$registro_inn['inn_id']));
                }
                $this->gsatelite->borrado_general('inn_ingreso',array('inn_id_gva'=>$registro_eliminar->gva_id));
            }
            if (count($preguntar_dsc) > 0) {
                foreach ($preguntar_dsc as $k => $reg_dsc) {
                    $this->gsatelite->borrado_general('ddd_detalle_descuento',array('ddd_id_dss' => $reg_dsc['dss_id']));
                }
                $this->gsatelite->borrado_general('dss_descuento', array('dss_id_gva' => $registro_eliminar->gva_id));
            }
            $this->gsatelite->borrado_general('gva_goce_vacacion', array('gva_id'=>$registro_eliminar->gva_id));
        } else {
            $id_emp = $registro_eliminar->gva_id_emp;
            $this->gsatelite->show_dialog("El registro ya ha sido procesado y autorizado en planilla", "acciones_personal/principal/gestion_vacaciones_empleado/$id_emp", 'error');
        }

        $id_emp = $registro_eliminar->gva_id_emp;
        $this->gsatelite->show_dialog("Proceso realizado con éxito", "acciones_personal/principal/gestion_vacaciones_empleado/$id_emp");
    }

    /**
     * @author René Castaneda
     * @return Mantenimiento acp_accion_personal
     */
    function gestion_acciones_empleado($id_empleado) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $empleado = $this->gsatelite->get_tabla('emp_empleado', array('emp_id' => $id_empleado));
            $dias = $this->gsatelite->get_parametro('DIAS_TRABAJADOS_MES');
            $hora = $this->gsatelite->get_parametro('HORAS_TRABAJADAS_DIA');
            $valor_hora = ($empleado[0]['emp_salario_hora'] != '') ? $empleado[0]['emp_salario_hora'] : ($empleado[0]['emp_salario']/$dias)/$hora;
            try {                
                $this->gsatelite->verificar_registro_real('emp_empleado', $id_empleado);
                $permisos = $this->gsatelite->get_permisos_opcion('acciones_personal/principal/listado_empleados');
                $data["permisos"] = $permisos;
                $crud = new grocery_CRUD();
                $crud->set_table('acp_accion_personal')
                        ->set_subject('Acción Empleada/o')
                        ->columns( 'acp_id_tac','acp_id_emp','acp_fecha_desde', 'acp_observacion', 'acp_estado')
                        ->where('acp_id_emp', $id_empleado)
                        ->set_relation('acp_id_tac', 'tac_tipo_accion', 'tac_nombre', array('tac_estado' => 1))
                        ->set_relation('acp_id_emp', 'emp_empleado', '{emp_nombre} {emp_apellido}')
                        ->add_fields('acp_id_emp', 'acp_id_tac', 'acp_fecha_desde', 'acp_fecha_hasta', 'acp_observacion', 'acp_estado', 'acp_id_usu', 'acp_usu_crea', 'acp_fecha_crea', 'acp_usu_mod', 'acp_fecha_mod', 'acp_estado_accion', 'acp_id_autoriza', 'acp_fecha_autorizacion')
                        ->edit_fields('acp_id_emp', 'acp_id_tac', 'acp_fecha_desde', 'acp_fecha_hasta', 'acp_observacion', 'acp_estado', 'acp_id_usu','acp_usu_mod', 'acp_fecha_mod')
                        ->display_as('acp_id_tac', 'Tipo Acción')
                        ->display_as('acp_fecha_desde', 'Período Desde')
                        ->display_as('acp_fecha_hasta', 'Período Hasta')
                        ->display_as('acp_observacion', 'Observación')
                        ->display_as('acp_estado', 'Estado')
                        ->display_as('acp_usu_crea', 'acp_usu_crea')
                        ->display_as('acp_fecha_crea', 'acp_fecha_crea')
                        ->display_as('acp_id_emp', 'Empleada/o')
                        ->required_fields('acp_id_tac', 'acp_estado', 'acp_id_emp')
                        // ->callback_field('acp_goce_sueldo', function($value, $primary_key) {
                        //     $value = ($value != '') ? $value : 1;
                        //     $defecto = ($value)?'checked':'';
                        //     return '<input type="checkbox" id="chk_goce_sueldo" '.$defecto.' class="nostyle"><input type="hidden" id="field-acp_goce_sueldo" name="acp_goce_sueldo" value="'.$value.'">';
                        // })
                        // ->callback_field('acp_reposicion_horas', function($value, $primary_key) {
                        //     $value = ($value != '') ? $value : 0;
                        //     $defecto = ($value)?'checked':'';
                        //     return '<input type="checkbox" id="chk_rep_horas" '.$defecto.' class="nostyle"><input type="hidden" id="field-acp_reposicion_horas" name="acp_reposicion_horas" value="'.$value.'">';
                        // })
                        ->callback_column('acp_estado', function($value, $row) {
                            $autorizado = ($row->acp_estado_accion == 3) ? "- Anulada<span class='sin_edit' style='display:none;'></span>" : "";
                            return ($value) ? "Activo $autorizado" : "Inactivo $autorizado";
                        })
                        ->field_type('acp_id_emp', 'hidden', $id_empleado)
                        ->field_type('acp_observacion', 'text')
                        ->field_type('acp_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                        ->field_type('acp_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                        ->field_type('acp_usu_crea', 'hidden', $this->tank_auth->get_user_id())
                        ->field_type('acp_fecha_crea', 'hidden', date('Y-m-d H:i:s'))                        
                        ->field_type('acp_id_usu', 'hidden', $this->tank_auth->get_user_id())
                        ->unset_delete()
                        ->add_action('Imprimir', '', 'acciones_personal/principal/imprimir_accion', 'icomoon-icon-printer imprimir_accion', null, null, array('acp_estado_accion' => 1))
                        ->add_action('Anexos', '', 'acciones_personal/principal/anexos_accion_personal/0', 'icomoon-icon-file-add', null, null, array('acp_estado_accion' => 1))
                //->unset_print()
                //->unset_export()
                ;
                $crud->callback_edit_field('acp_fecha_desde', function ($value, $row) {
                    return '<input id="field-acp_fecha_desde" name="acp_fecha_desde" type="text" value="' . formatear_fecha('Y-m-d', $value) . '" maxlength="10" class="datePicker">';
                });
                $crud->callback_edit_field('acp_fecha_hasta', function ($value, $row) {
                    return '<input id="field-acp_fecha_hasta" name="acp_fecha_hasta" type="text" value="' . formatear_fecha('Y-m-d', $value) . '" maxlength="10" class="datePicker">';
                });

                if ($permisos['permite_eliminar']) {
                    $crud->add_action('Anular', '', 'acciones_personal/principal/eliminar_acp','icomoon-icon-remove dlt');
                } 
                if (end(explode('/', uri_string())) == 'add') {
                    $crud->field_type('acp_estado', 'hidden', 1);
                    $crud->field_type('acp_estado_accion', 'hidden', 1);
                    $crud->field_type('acp_usu_crea', 'hidden', $this->tank_auth->get_user_id());
                    $crud->field_type('acp_id_autoriza', 'hidden', $this->tank_auth->get_user_id());
                    $crud->field_type('acp_fecha_crea', 'hidden', date('Y-m-d H:i:s'));
                    $crud->field_type('acp_fecha_autorizacion', 'hidden', date('Y-m-d H:i:s'));
                    $crud->field_type('acp_id_usu', 'hidden', $this->tank_auth->get_user_id());
                } else {
                    $crud->field_type('acp_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
                    $crud->field_type('acp_fecha_mod', 'hidden', date('Y-m-d H:i:s'));
                    $crud->callback_edit_field('acp_usu_mod', function($value, $primary_key) {
                        $user = $this->tank_auth->get_user_id();
                        return "<input id='field-acp_usu_mod' type='hidden' name='acp_usu_mod' value='" . $user . "' /><input type='hidden' id='old_tdc'  name='old_tdc' value='' />";
                    });
                }
                if (!$permisos['permite_agregar']) {
                    $crud->unset_add();
                }
                if (!$permisos['permite_editar']) {
                    $crud->unset_edit();
                }
                if (!$permisos['permite_ver']) {
                    $crud->unset_read();
                }
                // $crud->callback_after_insert(function($post_array, $primary_key) {
                //     $tdc = $this->gsatelite->get_campo('tac_tipo_accion', 'tac_id_tdc', array('tac_id'=>$post_array['acp_id_tac']));
                //     if ($post_array['acp_goce_sueldo'] == 0 && $tdc != "") {                            
                //         $empleado = $this->gsatelite->get_tabla('emp_empleado', array('emp_id' => $post_array['acp_id_emp']));
                //         if ($empleado[0]['emp_salario_hora'] != '') {
                //             $valor_desc = round(($empleado[0]['emp_salario_hora'] * $post_array['acp_horas']),2);
                //         } else {
                //             $dias = $this->gsatelite->get_parametro('DIAS_TRABAJADOS_MES');
                //             $hora = $this->gsatelite->get_parametro('HORAS_TRABAJADAS_DIA');
                //             $valor_desc = round(((($empleado[0]['emp_salario']/$dias)/$hora) * $post_array['acp_horas']),2);
                //         }
                //         $array_insert = array(
                //             'dss_id_emp' => $post_array['acp_id_emp'],
                //             'dss_id_tpl' => 1,//1 es provisional ya que esta con estado -1 y al aprobarlo cambiara a la que planilla que le corresponde
                //             'dss_id_tdc' => $tdc,
                //             'dss_observacion' => $post_array['acp_observacion'],
                //             'dss_valor' => $valor_desc, 
                //             'dss_permanente' => 0,
                //             'dss_fecha' => date('Y-m-d H:i:s'),
                //             'dss_fecha_desde' => $post_array['acp_fecha_desde'],
                //             'dss_cuota' => 1,
                //             'dss_cuota_pagada' => 0,
                //             'dss_estado' => -1,
                //             'dss_usu_crea' => $this->tank_auth->get_user_id(), 
                //             'dss_fecha_crea' => date('Y-m-d H:i:s'),
                //             'dss_usu_mod' => $this->tank_auth->get_user_id(), 
                //             'dss_fecha_mod' => date('Y-m-d H:i:s')
                //         );
                //         $dss_id = $this->gsatelite->ingresar('dss_descuento', $array_insert);
                //         $datos = array("acp_id_dss" => $dss_id);
                //         $this->gsatelite->actualizar('acp_accion_personal', $datos, 'acp_id', $primary_key);
                //     }
                //     return TRUE;
                // });           
                // $crud->callback_after_update(function($post_array, $primary_key) {
                //     $old_tdc = (isset($post_array["old_tdc"])) ? $post_array["old_tdc"] : 0;
                //     $dss_id = $this->gsatelite->get_campo('acp_accion_personal', 'acp_id_dss', array('acp_id'=>$primary_key));                  //ID del DESCUENTO
                //     $dss_estado = ($dss_id != '') ? $this->gsatelite->get_campo('dss_descuento', 'dss_estado', array('dss_id'=>$dss_id)) : -1;  //ESTADO del DESCUENTO
                //     $activo = ($post_array["acp_estado"] == 1) ? TRUE : FALSE ;
                //     $empleado = $this->gsatelite->get_tabla('emp_empleado', array('emp_id' => $post_array['acp_id_emp']));                    
                //     if ($empleado[0]['emp_salario_hora'] != '') {
                //         $valor_desc = round(($empleado[0]['emp_salario_hora'] * $post_array['acp_horas']),2);
                //     } else {
                //         $dias = $this->gsatelite->get_parametro('DIAS_TRABAJADOS_MES');
                //         $hora = $this->gsatelite->get_parametro('HORAS_TRABAJADAS_DIA');
                //         $valor_desc = round(((($empleado[0]['emp_salario']/$dias)/$hora) * $post_array['acp_horas']),2);
                //     }
                //     if ($activo) {
                //         //ACCION DE PERSONAL ACTIVA
                //         if ($post_array["acp_id_tac"] == $old_tdc) {    
                //             //MISMO tac_id
                //             if ($post_array["acp_goce_sueldo"] == 1) { 
                //                 //CON GOCE DE SUELDO
                //                 if ($dss_id != "" && $dss_estado < 0 ) {
                //                     //EXISTE UN DESCUENTO, BORRARLO
                //                     $this->gsatelite->actualizar('acp_accion_personal', array("acp_id_dss" => NULL), 'acp_id', $primary_key);
                //                     $this->gsatelite->borrado_general('dss_descuento', array('dss_id' => $dss_id));
                //                     return TRUE;
                //                 }
                //             } else {
                //                 //SIN GOCE DE SUELDO
                //                 if ($dss_id != "" && $dss_estado < 0) { 
                //                     //YA EXISTE DESCUENTO, SOLO ACTUALIZAR
                //                     $update_array = array(
                //                         'dss_id_tpl' => 1,
                //                         'dss_observacion' => $post_array['acp_observacion'],
                //                         'dss_valor' => $valor_desc, 
                //                         'dss_fecha_desde' => $post_array['acp_fecha_desde'],
                //                         'dss_usu_mod' => $this->tank_auth->get_user_id(), 
                //                         'dss_fecha_mod' => date('Y-m-d H:i:s')
                //                     );
                //                     $this->gsatelite->actualizar_array('dss_descuento', $update_array, array('dss_id' => $dss_id));
                //                     return TRUE;
                //                 } else {  
                //                     //NO HAY DESCUENTO, CREAR NUEVO 
                //                     $tdc = $this->gsatelite->get_campo('tac_tipo_accion', 'tac_id_tdc', array('tac_id'=>$post_array['acp_id_tac']));
                //                     if ($tdc != '') {                                    
                //                         $array_insert = array(
                //                             'dss_id_emp' => $post_array['acp_id_emp'],
                //                             'dss_id_tpl' => 1,
                //                             'dss_id_tdc' => $tdc,
                //                             'dss_observacion' => $post_array['acp_observacion'],
                //                             'dss_valor' => $valor_desc, 
                //                             'dss_permanente' => 0,
                //                             'dss_fecha' => date('Y-m-d H:i:s'),
                //                             'dss_fecha_desde' => $post_array['acp_fecha_desde'],
                //                             'dss_cuota' => 1,
                //                             'dss_cuota_pagada' => 0,
                //                             'dss_estado' => -1,
                //                             'dss_usu_crea' => $this->tank_auth->get_user_id(), 
                //                             'dss_fecha_crea' => date('Y-m-d H:i:s'),
                //                             'dss_usu_mod' => $this->tank_auth->get_user_id(), 
                //                             'dss_fecha_mod' => date('Y-m-d H:i:s')
                //                         );
                //                         $dss_id = $this->gsatelite->ingresar('dss_descuento', $array_insert);
                //                         $datos = array("acp_id_dss" => $dss_id);
                //                         $this->gsatelite->actualizar('acp_accion_personal', $datos, 'acp_id', $primary_key);
                //                         return TRUE;
                //                     }
                //                 }
                //             }                            
                //         } else {
                //             //DISTINTO id_tac
                //             if ($post_array["acp_goce_sueldo"] == 1) {
                //                 //CON GOCE DE SUELDO
                //                 if ($dss_id != "" && $dss_estado < 0 ) {
                //                     //EXISTE UN DESCUENTO, BORRARLO
                //                     $this->gsatelite->actualizar('acp_accion_personal', array("acp_id_dss" => NULL), 'acp_id', $primary_key);
                //                     $this->gsatelite->borrado_general('dss_descuento', array('dss_id' => $dss_id));
                //                     return TRUE;
                //                 }
                //             } else {
                //                 //SIN GOCE DE SUELDO
                //                 $tdc = $this->gsatelite->get_campo('tac_tipo_accion', 'tac_id_tdc', array('tac_id'=>$post_array['acp_id_tac']));
                //                 if ($tdc != '') {
                //                     //SI EL NUEVO tac_id aplica a DESCUENTO
                //                     if ($dss_id != "" && $dss_estado < 0) {
                //                         //YA EXISTE DESCUENTO, SOLO ACTUALIZAR
                //                         $update_array = array(
                //                             'dss_id_tpl' => 1,
                //                             'dss_id_tdc' => $tdc,
                //                             'dss_observacion' => $post_array['acp_observacion'],
                //                             'dss_valor' => $valor_desc, 
                //                             'dss_permanente' => 0,
                //                             'dss_fecha' => date('Y-m-d H:i:s'),
                //                             'dss_fecha_desde' => $post_array['acp_fecha_desde'],
                //                             'dss_cuota' => 1,
                //                             'dss_cuota_pagada' => 0,
                //                             'dss_usu_mod' => $this->tank_auth->get_user_id(), 
                //                             'dss_fecha_mod' => date('Y-m-d H:i:s')
                //                         );
                //                         $this->gsatelite->actualizar_array('dss_descuento', $update_array, array('dss_id' => $dss_id));
                //                         return TRUE;
                //                     } else { 
                //                         //NO HAY DESCUENTO, CREAR NUEVO 
                //                         $array_insert = array(
                //                             'dss_id_emp' => $post_array['acp_id_emp'],
                //                             'dss_id_tpl' => 1,
                //                             'dss_id_tdc' => $tdc,
                //                             'dss_observacion' => $post_array['acp_observacion'],
                //                             'dss_valor' => $valor_desc, 
                //                             'dss_permanente' => 0,
                //                             'dss_fecha' => date('Y-m-d H:i:s'),
                //                             'dss_fecha_desde' => $post_array['acp_fecha_desde'],
                //                             'dss_cuota' => 1,
                //                             'dss_cuota_pagada' => 0,
                //                             'dss_estado' => -1,
                //                             'dss_usu_crea' => $this->tank_auth->get_user_id(), 
                //                             'dss_fecha_crea' => date('Y-m-d H:i:s'),
                //                             'dss_usu_mod' => $this->tank_auth->get_user_id(), 
                //                             'dss_fecha_mod' => date('Y-m-d H:i:s')
                //                         );
                //                         $dss_id = $this->gsatelite->ingresar('dss_descuento', $array_insert);
                //                         $datos = array("acp_id_dss" => $dss_id);
                //                         $this->gsatelite->actualizar('acp_accion_personal', $datos, 'acp_id', $primary_key);
                //                         return TRUE;
                //                     }                                
                //                 }                                
                //             }                            
                //         }                        
                //     } else {
                //         //ACCION DE PERSONAL INACTIVA SE ELIMINAN EL DESCUENTO
                //         if ($dss_id != "" && $dss_estado < 0 ) {
                //             $this->gsatelite->actualizar('acp_accion_personal', array("acp_id_dss" => NULL), 'acp_id', $primary_key);
                //             $this->gsatelite->borrado_general('dss_descuento', array('dss_id' => $dss_id));
                //             return TRUE;
                //         }
                //     }
                // });
                $emp = $this->gsatelite->get_registro('emp_empleado', 'emp_id', $id_empleado);
                $data['titulo_personal'] = "Gestión acciones de personal";
                //$crud->add_action('Imprimir', '', 'acciones_personal/principal/imprimir_accion', 'icomoon-icon-printer imprimir_accion');
                $data["nombre_empleado"] = $emp->emp_nombre . ' ' . $emp->emp_apellido;
                $data["id_empleado"] = $emp->emp_id;
                $data["valor_hora"] = $valor_hora;
                $output = $crud->render();                
                $this->_cargarvista($data, $output);
            } catch (Exception $e) {
                show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
            }
        }
    }

    public function eliminar_acp($acp_id = 0){
        satelite_validar();
        $acp = $this->gsatelite->get_registro('acp_accion_personal', 'acp_id', $acp_id);
        $emp = $acp->acp_id_emp;
        $actualiza = array(
            'acp_id_usu_anula' => $this->tank_auth->get_user_id(),
            'acp_fecha_anulacion' => date('Y-m-d H:i:s'),
            'acp_observacion_anulacion' => 'ANULADA EN FECHA ' . date('d/m/Y'),
            'acp_estado_accion' => 3,
            'acp_estado' => 0,
            'acp_usu_mod' => $this->tank_auth->get_user_id(),
            'acp_fecha_mod' => date('Y-m-d H:i:s')
        );
        $this->gsatelite->actualizar_array('acp_accion_personal', $actualiza, array('acp_id' => $acp_id));
        $this->gsatelite->show_dialog("Registro anulado con éxito.", "acciones_personal/principal/gestion_acciones_empleado/$emp");
    }

    function imprimir_accion($id_detalle_accion = null, $id_empleado = null, $tipo = 2) {
        satelite_validar();
        if ($id_detalle_accion != 'all' and $id_empleado == null) {
            $this->gsatelite->verificar_registro_real('acp_accion_personal', $id_detalle_accion);
        }

        if ($id_detalle_accion != 'all' and $id_empleado == null) {
            $registro_detalle = $this->gsatelite->get_registro('acp_accion_personal', 'acp_id', $id_detalle_accion);
            //$data["empleado_info"] = $this->gsatelite->get_tabla('emp_empleado',array('emp_id'=>$registro_detalle->acp_id_emp));
            $this->db->join('emp_empleado', 'emp_id=acp_id_emp');
            $this->db->join('tac_tipo_accion', 'tac_id=acp_id_tac');
            $this->db->join('are_area', 'are_id=emp_id_are', 'left');
            $datos = $this->gsatelite->get_tabla('acp_accion_personal', array('acp_id' => $id_detalle_accion));
            $data["informacion"] = $datos[0];
            $html = $this->load->view('reporte/header', array('titulo' => 'ACCIÓN DE PERSONAL', 'solotitulo' => true), true);
            $html .= $this->load->view('acciones_personal/principal/reporte_accion_empleado', $data, true);
        } else {
            $this->db->join('emp_empleado', 'emp_id=acp_id_emp');
            $this->db->join('tac_tipo_accion', 'tac_id=acp_id_tac');
            $this->db->join('are_area', 'are_id=emp_id_are', 'left');
            $data["consulta"] = $this->gsatelite->get_tabla('acp_accion_personal', array('acp_id_emp' => $id_empleado));
            $html = $this->load->view('reporte/header', array('titulo' => 'ACCIÓN DE PERSONAL', 'solotitulo' => true), true);
            $html .= $this->load->view('acciones_personal/principal/reporte_accion_empleado_all', $data, true);
        }
        if ($tipo == 2) {
            $this->load->library('Pdf'); //libreria pdf
            $this->pdf->setPrintFooter(true);
            $this->pdf->makePDF($html, 'P');
        } else {
            //excel
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header("Content-Disposition: attachment;filename=Reporte_consolidado_acciones.xls");
            header("Pragma: no-cache");
            header("Expires: 0");
            $html_header = $this->load->view('reporte/header', array('titulo' => 'ACCIÓN DE PERSONAL', 'solotitulo' => true), true);
            echo "<h3>ACCIÓN DE PERSONAL</h3>";
            echo str_replace($html_header, '', $html);
        }
    }

    /**
     * @author Edith Herrera / René Castaneda (proceso de compartir funcionalidad 21-12-2017)
     * @return Mantenimiento rte_retiro_empleado
     * @param string $ruta_modulo (ruta del modulo)
     * @description funcionalidad compartida en: expediente_personal/empleado (funcion: retiro_personal )
     */
    public function retiro_personal($ruta_modulo = "") {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $permisos = $this->gsatelite->get_permisos_opcion();
            $ruta_modulo = ( trim($ruta_modulo) != '' )? trim($ruta_modulo):"acciones_personal/principal";
            $data['ruta_modulo'] = $ruta_modulo;
            $data['permisos'] = $permisos;
            $data['total_empleados'] = $this->personal_model->retiro_empleado();
            $data['titulo_personal'] = "Retiro de personal";
            //$this->_cargarvista($data, null);
            cargarvista($data,null,'acciones_personal/principal/retiro_personal'); //add by rené Castaneda 21-12-2017
        }
    }

    public function exportar_retirados($tipo = 0){
        $data['tipo'] = $tipo;
                                   $this->db->order_by('emp_nombre');
        $data['total_empleados'] = $this->personal_model->retiro_empleado();
        $html = $this->load->view('acciones_personal/principal/detalle_retirados', $data, true);
        if ($tipo > 0) {            
            $header = $this->load->view('reporte/header', array('titulo' => 'empleados retirados'), true);
            $GLOBALS['nombre_reporte'] = 'empleados_retirados_' . date('dmY');
            $reporte = $header . $html;
            $this->pdf->SetTitle('reporte_empleados_retirados');
            $this->pdf->makePdf($reporte, 'P', 'reporte_empleados_retirados', 'Letter');
        } else {
            echo $html;
        }        
    }

    /**
     * @author Edith Herrera
     * @return Agregar a rte_retiro_empleado (formulario).
     * @description funcionalidad compartida en: expediente_personal/empleado (funcion: agregar_retiro )
     */
    public function agregar_retiro($ruta_modulo = "") {
        satelite_validar();
        try {
            $ruta_modulo = ( trim($ruta_modulo) != '' )? trim($ruta_modulo):"acciones_personal/principal";
            $data['ruta_modulo'] = $ruta_modulo;
            if ($this->input->post()) {
                $id_emp = $this->input->post('empleado');
                $empleados = $this->personal_model->listado_empleados(array('emp_id' => $id_emp));

                for ($i = 0; $i < count($empleados); $i++) {
                    $id_plaza = $empleados[$i]['plz_id'];
                    $plaza = $empleados[$i]['plz_nombre'];
                    $depto = $empleados[$i]['are_nombre'];
                    $ingreso = $empleados[$i]['emp_fecha_contrato'];
                }
                echo json_encode(array('id_plaza' => $id_plaza, 'plaza' => $plaza, 'depto' => $depto, 'ingreso' => formatear_fecha('d-m-Y', $ingreso)));
                die();
            }

            $select = $this->gsatelite->get_dropdown('emp_empleado', '{emp_codigo} - {emp_nombre} {emp_apellido}', '', array('emp_estado' => 1), null, '', 'emp_id', true);
            $data["empleados"] = str_replace('<option value="0">Seleccione</option>', '', $select);

            $select = $this->gsatelite->get_dropdown('ctr_categoria_retiro', '{ctr_nombre}', '', array('ctr_estado' => 1), null, '', 'ctr_id', true);
            $data["categorias"] = str_replace('<option value="0">Seleccione</option>', '', $select);

            $data['titulo_personal'] = "Retiro de personal";
            //$this->_cargarvista($data, null);
            cargarvista($data,null,'acciones_personal/principal/agregar_retiro'); //add by rené Castaneda 21-12-2017
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    /**
     * @author Edith Herrera
     * @return guardar el Agregar a rte_retiro_empleado (formulario).
     * @description funcionalidad compartida en: expediente_personal/empleado (funcion: guardar_retiro )
     */
    public function guardar_retiro($ruta_modulo = "") {
        satelite_validar();
        try {
            $ruta_modulo = ( trim($ruta_modulo) != '' )? trim($ruta_modulo):"acciones_personal/principal";
            $data['ruta_modulo'] = $ruta_modulo;
            if ($_POST) {
                $fecha = date('Y-m-d', strtotime($this->input->post('fecha_retiro')));
                $hora = date('H:i:s');
                $fecha_retiro = $fecha . ' ' . $hora;

                $empleado = $this->input->post('empleado');

                /*$data['emp_id'] = $empleado;
                $data['nresolucion'] = $this->correlativo_resolucion(7);
                $data['motivo_retiro'] = $this->input->post('motivo_retiro');
                $data['causal_derecho'] = $this->input->post('causal_derecho');
                $data['interponer_recurso'] = $this->input->post('interponer_recurso');
                $data['interponer_ante'] = $this->input->post('interponer_ante');
                $data['plazo_maximo_recurso'] = $this->input->post('plazo_maximo_recurso');                
            
                        $this->db->join("trs_tipo_resolucion", "trs_id = rsl_id_trs");
                $formatos = $this->gsatelite->get_tabla("rsl_resolucion", array("rsl_id" => 7));
                $html = $this->load->view('acciones_personal/principal/' . $formatos[0]['rsl_formato'], $data, true);
                $new_res = array(
                    'rxe_id_rsl' => 7,
                    'rxe_num_resolucion' => $data['nresolucion'],
                    'rxe_id_emp' => $empleado,
                    'rxe_fecha_generado' => date("Y-m-d H:i:s"),
                    'rxe_html' => $html,
                    'rxe_estado' => 1,
                    'rxe_usu_creacion' => $this->tank_auth->get_user_id(),
                    'rxe_fecha_creacion' => date("Y-m-d H:i:s"),
                    'rxe_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'rxe_fecha_modificacion' => date("Y-m-d H:i:s")
                );
                $id_res = $this->gsatelite->ingresar('rxe_resolucionxempleado', $new_res);*/

                $retiro = array(
                    'rte_id_ctr'        => $this->input->post('categoria'),
                    'rte_id_emp'        => $this->input->post('empleado'),
                    'rte_fecha_retiro'  => $fecha_retiro,
                    'rte_motivo_retiro' => $this->input->post('motivo_retiro'),
                    'rte_observacion'   => $this->input->post('observaciones_retiro'),
                    'rte_autorizar_ret' => 0,
                    'rte_desactivar_plaza' => $this->input->post('plz_desactivar_hidden'),  //1=conservar plaza  0=eliminar plaza
                    'rte_recontratable' => $this->input->post('rte_recontratable_hidden'),
                    'rte_estado'        => 1,
                    'rte_id_emr'        => $this->tank_auth->get_empresa_id(),
                    'rte_usu_mod'       => $this->tank_auth->get_user_id(),
                    'rte_fecha_mod'     => date('Y-m-d H:i:s'),
                    'rte_usu_creacion'  => $this->tank_auth->get_user_id(),
                    'rte_fecha_creacion'=> date('Y-m-d H:i:s'),
                    //'rte_id_rxe'        => $id_res,
                    'rte_casual_derecho'=> $this->input->post('causal_derecho'),
                    'rte_interponer_recurso'=> $this->input->post('interponer_recurso'),
                    'rte_interponer_ante'=> $this->input->post('interponer_ante'),
                    'rte_plazo_maximo_recurso'=> $this->input->post('plazo_maximo_recurso'),
                );
                $ingreso = $this->gsatelite->ingresar('rte_retiro_empleado', $retiro);

               /* if($ingreso>0){
                    $plaza = $this->gsatelite->get_campo('emp_empleado', 'emp_id_plz', array('emp_id'=>$empleado));
                    $this->gsatelite->actualizar_array('emp_empleado', array('emp_fecha_retiro'=>$fecha_retiro, 'emp_estado'=>0), array('emp_id'=>$empleado));
                }*/

				// if($ingreso>0){
                    /* VERIFICAR CASO DE USO PUES SE DEBE AUTORIZAR EL RETIRO PARA CAMBIAR ESTADO */
                    // $this->gsatelite->actualizar_array('emp_empleado', array('emp_fecha_retiro'=>$fecha_retiro, 'emp_estado'=>0), array('emp_id'=>$empleado));
                // }

                
                if ($ingreso > 0) {
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Información", 'texto_alerta' => "Retiro registrado con éxito.");
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "No se registro el retiro", 'texto_alerta' => "Verifique la información a ingresar");
                }

                $this->session->set_flashdata($alerta);

                $boton = $this->input->post("tipo");

                if ($boton == 1) {
                    redirect("$ruta_modulo/agregar_retiro");
                } else if ($boton == 2) {
                    redirect("$ruta_modulo/retiro_personal");
                }
            }
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    /**
     * @author Edith Herrera
     * @return Editar a rte_retiro_empleado (formulario).
     * @description funcionalidad compartida en: expediente_personal/empleado (funcion: editar_retiro_personal )
     */
    public function editar_retiro_personal($id_rte=0, $ruta_modulo = "") {
        satelite_validar();
        try {
            $ruta_modulo = ( trim($ruta_modulo) != '' )? trim($ruta_modulo):"acciones_personal/principal";
            $data['ruta_modulo'] = $ruta_modulo;

            $retiro=$this->gsatelite->get_tabla('rte_retiro_empleado', array('rte_id'=>$id_rte));
           
            $total_empleados = $this->personal_model->retiro_empleado(array('emp_id' => $retiro[0]['rte_id_emp'], 'rte_id' => $id_rte));
            $data['total_empleados'] = $total_empleados;
            $total_empleados = $total_empleados[0];

                      $this->db->where('emp_estado', 1);
                      $this->db->or_where('emp_id', $total_empleados['emp_id']);
            $select = $this->gsatelite->get_dropdown('emp_empleado', '{emp_codigo} - {emp_nombre} {emp_apellido}', '',null, $total_empleados['emp_id'], '', 'emp_id', true);
            $data["empleados"] = str_replace('<option value="0">Seleccione</option>', '', $select);

            $data['emp_id']=$total_empleados['emp_id'];
            $data['id_rte']=$total_empleados['id_rte'];
            $select = $this->gsatelite->get_dropdown('ctr_categoria_retiro', '{ctr_nombre}', '', array('ctr_estado' => 1), $total_empleados['ctr_id'], '', 'ctr_id', true);
            $data["categorias"] = str_replace('<option value="0">Seleccione</option>', '', $select);

            $data['titulo_personal'] = "Retiro de personal";
            //$this->_cargarvista($data, null);
            cargarvista($data,null,'acciones_personal/principal/editar_retiro_personal'); //add by rené Castaneda 21-12-2017
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    /**
     * @author Edith Herrera
     * @return Guardar el Editar a rte_retiro_empleado (formulario).
     * @description funcionalidad compartida en: expediente_personal/empleado (funcion: actualizar_retiro )
     */
    public function actualizar_retiro($ruta_modulo = "") {
        satelite_validar();
        try {
            $ruta_modulo = ( trim($ruta_modulo) != '' )? trim($ruta_modulo):"acciones_personal/principal";
            $data['ruta_modulo'] = $ruta_modulo;

            if ($_POST) {
                $fecha = date('Y-m-d', strtotime($this->input->post('fecha_retiro')));
                $hora = date('H:i:s');
                $fecha_retiro = $fecha . ' ' . $hora;

                $emp_id = $this->input->post('emp_id');
                $empleado = $this->input->post('empleado');

                $retiro_mod = array(
                    'rte_id_ctr'    => $this->input->post('categoria'),
                    'rte_id_emp'    => $empleado,
                    'rte_fecha_retiro'  => $fecha_retiro,
                    'rte_motivo_retiro' => $this->input->post('motivo_retiro'),
                    'rte_observacion'   => $this->input->post('observaciones_retiro'),
                    'rte_recontratable' => $this->input->post('rte_recontratable_hidden'),
                    'rte_autorizar_ret' => 0,
                    'rte_desactivar_plaza' => $this->input->post('plz_desactivar_hidden'),
                    'rte_estado'        => $this->input->post('estado'),
                    'rte_usu_mod'       => $this->tank_auth->get_user_id(),
                    'rte_fecha_mod'     => date('Y-m-d H:i:s'),
                    'rte_usu_creacion'  => $this->input->post('usuario'),
                    'rte_fecha_creacion'=> $this->input->post('creacion')
                    );

                $ingreso = $this->gsatelite->actualizar_array('rte_retiro_empleado', $retiro_mod, array('rte_id' => $this->input->post('registro')));

               /* if($ingreso>0){
                    if($emp_id!=$empleado){*/
                    /****************  SE INACTIVA AL NUEVO EMPLEADO Y SE LIBERA LA PLAZA ******************/
                        /* $plaza = $this->gsatelite->get_campo('emp_empleado', 'emp_id_plz', array('emp_id'=>$empleado));
                                 $this->gsatelite->actualizar_array('emp_empleado', array('emp_fecha_retiro'=>$fecha_retiro, 'emp_estado'=>0), array('emp_id'=>$empleado));
                        */

                    /***** SE ACTIVA AL EMPLEADO ANTERIOR Y SE ASOCIA LA PLAZA MIENTRAS SE ENCUENTRE DISPONIBLE ******/
                    /*    $plaza_ant = $this->gsatelite->get_campo('emp_empleado', 'emp_id_plz', array('emp_id'=>$emp_id));

                            $this->gsatelite->actualizar_array('emp_empleado', array('emp_fecha_retiro'=>null, 'emp_estado'=>1), array('emp_id'=>$emp_id));
                    }
                }*/

                if ($ingreso > 0) {
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Información", 'texto_alerta' => "Retiro actualizado con éxito.");
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "No se actualizó el retiro", 'texto_alerta' => "Verifique la información a modificar");
                }
                $this->session->set_flashdata($alerta);

                $boton = $this->input->post("tipo");
                $id_emp = $this->input->post('empleado');
                $rte_id = $this->input->post('registro');
                if ($boton == 1) {
                    redirect("$ruta_modulo/editar_retiro_personal/" . $rte_id);
                } else if ($boton == 2) {
                    redirect("$ruta_modulo/retiro_personal");
                }
            }
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    /**
     * @author Edith Herrera
     * @return Pasamos el estado del retiro a cero para inactivarlo.
     * @description funcionalidad compartida en: expediente_personal/empleado (funcion: inactivar_retiro )
     */
    function inactivar_retiro($retiro_id=0, $ruta_modulo = "") {
        satelite_validar();
        $ruta_modulo = ( trim($ruta_modulo) != '' )? trim($ruta_modulo):"acciones_personal/principal";
        $data['ruta_modulo'] = $ruta_modulo;
        $info = $this->gsatelite->get_tabla('rte_retiro_empleado', array('rte_id' => $retiro_id));
        $retiro = $this->gsatelite->actualizar_array('rte_retiro_empleado', array('rte_estado' => 0), array('rte_id' => $retiro_id));
        if($retiro > 0){
            $plaza = $this->gsatelite->get_campo('emp_empleado', 'emp_id_plz', array('emp_id'=>$info[0]['rte_id_emp']));
            $this->gsatelite->actualizar_array('emp_empleado', array('emp_fecha_retiro' => null, 'emp_estado' => 1), array('emp_id' => $info[0]['rte_id_emp']));
            $plz_empleado = $this->gsatelite->get_tabla('plz_plaza', array('plz_id' => $plaza));
            // SI LA PLAZA YA NO EXISTE BORRARSELA AL EMPLEADO
            if(!(count($plz_empleado) > 0)){
                $this->gsatelite->actualizar_array('emp_empleado', array('emp_id_plz' => null), array('emp_id'=>$info[0]['rte_id_emp']));
            }
        }
        if ($retiro > 0) {
            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Eliminar retiro", 'texto_alerta' => "El retiro de personal fue eliminado correctamente.");
        } else {
            $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Eliminar retiro", 'texto_alerta' => "Ocurrió un error, inténtelo de nuevo");
        }        
        $this->session->set_flashdata($alerta);
        redirect("$ruta_modulo/retiro_personal");
    }

    /**
     * @author Edith Herrera
     * @return Se coloca el campo de autorizar retiro (rte_autorizar_ret) a 1 
     *         y el estado del empleado (emp_estado) a 0.
     * @description funcionalidad compartida en: expediente_personal/empleado (funcion: autorizar_retiro )
     */
    function autorizar_retiro($empleado_id=0, $retiro_id=0, $ruta_modulo = "") {
        satelite_validar();
        $ruta_modulo = ( trim($ruta_modulo) != '' )? trim($ruta_modulo):"acciones_personal/principal";
        $data['ruta_modulo'] = $ruta_modulo;
        $info   = $this->gsatelite->get_tabla('rte_retiro_empleado', array('rte_id'=>$retiro_id));
        $fecha  = formatear_fecha('Y-m-d H:i:s', $info[0]['rte_fecha_retiro']);
        $retiro = $this->gsatelite->actualizar_array('rte_retiro_empleado', array('rte_autorizar_ret' => 1), array('rte_id'=>$retiro_id));
        $empleado = $this->gsatelite->actualizar_array('emp_empleado', array('emp_estado' => 0), array('emp_id'=> $empleado_id));
        if($retiro > 0) {
            $plaza = $this->gsatelite->get_campo('emp_empleado', 'emp_id_plz', array('emp_id'=>$empleado_id));

            // Determinar si se desactivara la plaza al empleado 0=ELIMINAR PLAZA 1=MANTENER PLAZA
            if ($info[0]['rte_desactivar_plaza'] > 0) {
                $this->gsatelite->actualizar_array('emp_empleado', array('emp_fecha_retiro'=>$fecha, 'emp_estado'=>0), array('emp_id'=>$empleado_id));
                $this->duplicar_plaza($plaza, 1, '');
                $this->gsatelite->actualizar_array('plz_plaza', array('plz_estado' => 0), array('plz_id' => $plaza));
            } else {
                $this->gsatelite->actualizar_array('emp_empleado', array('emp_fecha_retiro'=>$fecha, 'emp_estado'=>0), array('emp_id'=>$empleado_id));
                $this->gsatelite->actualizar_array('plz_plaza', array('plz_estado' => 0), array('plz_id' => $plaza));
            }
            $this->gsatelite->actualizar_array('txe_tipo_planillaxempleado', array('txe_estado'=>0), array('txe_id_emp'=>$empleado_id));
        }
        $empresa = strtolower(trim($this->gsatelite->get_parametro('SYS_SIGLAS', '')));
        if ($empresa == 'midem') {
            $data['emp_id'] = $empleado_id;
                    // $data['fecha_resol'] = date("Y-m-d");
                    // $data['slc_empleado'] = $hxe_row->hxe_id_emp;
            $data['nresolucion'] = $this->correlativo_resolucion(7);
                    // $data['institucion'] = $this->gsatelite->get_tabla('emr_empresa', array('emr_id' => $this->tank_auth->get_empresa_id()))[0];
            $html = $this->load->view('acciones_personal/principal/notificacion_destitucion', $data, true);
            // var_dump($html);die();
                    $new_res = array(
                        'rxe_id_rsl' => 7,
                        'rxe_num_resolucion' => $data['nresolucion'],
                        'rxe_id_emp' => $empleado_id,
                        'rxe_fecha_generado' => date("Y-m-d H:i:s"),
                        'rxe_html' => $html,
                        'rxe_estado' => 1,
                        'rxe_usu_creacion' => $this->tank_auth->get_user_id(),
                        'rxe_fecha_creacion' => date("Y-m-d H:i:s"),
                        'rxe_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'rxe_fecha_modificacion' => date("Y-m-d H:i:s")
                    );
                    $id_res = $this->gsatelite->ingresar('rxe_resolucionxempleado', $new_res);
                    $this->gsatelite->actualizar_array('rte_retiro_empleado', array('rte_id_rxe' => $id_res), array('rte_id'=>$retiro_id));
                }
        if ($retiro > 0 && $empleado > 0) {
            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Información", 'texto_alerta' => "Registro autorizado correctamente.");
        }
        $this->session->set_flashdata($alerta);
        redirect("$ruta_modulo/retiro_personal");
    }


    public function calculo_liquidacion($consulta = null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $permisos = $this->gsatelite->get_permisos_opcion();
            if ($consulta) {
                if ($this->input->post()) {
                    $fecha_ini = date("Y-m-d", strtotime($this->input->post('fecha_ini')));
                    $fecha_fin = date("Y-m-d", strtotime($this->input->post('fecha_fin')));
                    //APLICAN EMPLEADOS ESTADO 0 CON RETIRO AUTORIZADO & ESTADO 1 CON RETIRO PDTE
                    $where = array("(((DATE(emp_fecha_retiro) >= '$fecha_ini' AND DATE(emp_fecha_retiro) <= '$fecha_fin') AND rte_autorizar_ret = 1) OR ((DATE(rte_fecha_retiro) BETWEEN '$fecha_ini' AND '$fecha_fin') AND emp_estado = 1 AND rte_autorizar_ret = 0))" => null);
                    
                                               $this->db->join('rte_retiro_empleado', 'rte_id_emp = emp_id');
                                               $this->db->join('lqe_liquidacion_empleado', 'lqe_id_rte = rte_id', 'left');
                    $data['total_empleados'] = $this->personal_model->listado_empleados($where);
                    // echo $this->db->last_query(); die();
                    $html = $this->load->view('acciones_personal/principal/busqueda_empleados', $data, true);
                    echo $html;
                }
                die();
            } else {
                $this->db->where('emp_id', 0);
                $data['total_empleados'] = $this->personal_model->listado_empleados();
            }
            $data['titulo_personal'] = "Cálculo de liquidación";
            $this->_cargarvista($data, null);
        }
    }

    public function calculo_indemnizacion(){
        satelite_validar();
        $data['permisos'] = $this->gsatelite->get_permisos_opcion();
        $data['lista_empleados'] = $this->personal_model->elegibles_indemnizar();
        $data['titulo_personal'] = "Cálculo de Indemnizacion";
        $this->_cargarvista($data);
    }

    /**
     * @author Elman Ortiz 
     * @return Funcion llamada desde ajax para cargar los select de planilla y periodo en el modal 
     * 		 para las horas que no han sido procesada
     * */
    function procesar_hora_extra($id_hora_extra = null) {
        $id_hora_extra = $this->input->post('hxe_id');
        $this->verifica_registro_real('hxe_hora_extraxempleado', $id_hora_extra);
        $registro_hora_extra = $this->accion_personal_model->get_horas_extras(array('hxe_id' => $id_hora_extra));
        $registro_hora_extra = $registro_hora_extra[0];
        $id_empleado = $registro_hora_extra['hxe_id_emp'];
        $data["titulo_personal"] = "Gestión de horas extras";
        $data["registro_hora"] = $registro_hora_extra;
        $data["info_empleado"] = $this->gsatelite->get_tabla('emp_empleado', array('emp_id' => $id_empleado));
        //PLANILLAS AL QUE PERTENECE EL EMPLEADO		
        $ids_tpl = array(0);
        $pregunta = $this->gsatelite->get_tabla('txe_tipo_planillaxempleado', array('txe_id_emp' => $id_empleado));
        foreach ($pregunta as $fila) {
            $ids_tpl[] = $fila['txe_id_tpl'];
        }
        $this->db->where_in('tpl_id', $ids_tpl);
        $select = $this->gsatelite->get_dropdown('tpl_tipo_planilla', '{tpl_nombre}', '', null, $registro_hora_extra['tpl_id'], '', 'tpl_id', true);
        $data["select_tpl_id"] = str_replace('<option value="0">Seleccione</option>', '', $select);

        $select = $this->gsatelite->get_dropdown('the_tipo_hora_extra', '{the_nombre} ({the_factor}%)', '', array('the_estado' => 1), $registro_hora_extra['the_id'], '', 'the_id', true);
        $data["select_tipo_hora_extra"] = str_replace('<option value="0">Seleccione</option>', '', $select);

        $select = $this->gsatelite->get_dropdown('pla_planilla', '{pla_fecha_inicio} # {pla_fecha_fin}', '', array('pla_id_tpl' => $registro_hora_extra['tpl_id'], 'pla_estado >=' => 1, 'pla_estado <=' => 2), $registro_hora_extra['pla_id'], '', 'pla_id', true);
        $data["select_periodo_planilla"] = str_replace('<option value="0">Seleccione</option>', '', $select);
        $data["id_hora_extra"] = $id_hora_extra;
        $data["id_empleado"] = $id_empleado;

        echo $this->load->view('acciones_personal/principal/gestion_horas_extras_modal', $data, true);
    }

    /**
     * @author Elman Ortiz 
     * @return Funcion que actualiza la tabla de horas extras por empleado y crea un nuevo 
     * 		 registro en inn_ingreso
     * */
    function update_procesar_hora_extra() {

        if ($_POST) {
            $id_hora_ex = $this->input->post('id_hora_ex'); //Id de hora extra
            $id_empleado = $this->input->post('id_empleado'); //Id del empleado
            $pla_id = $this->input->post('periodo_planilla'); //Id de la planilla
            $tipo_planilla = $this->input->post('tipo_planilla'); //Tipo de planilla
            //Obtener factor y tig tipo hora extra
            $tb_ho_extra = $this->gsatelite->get_tabla('hxe_hora_extraxempleado', array('hxe_id' => $id_hora_ex, 'hxe_estado' => 1));
            $tb_tp_ho_extra = $this->gsatelite->get_tabla('the_tipo_hora_extra', array('the_id' => $tb_ho_extra[0]['hxe_id_the'], 'the_estado' => 1));
            $tb_pla = $this->gsatelite->get_tabla('pla_planilla', array('pla_id' => $pla_id));

            $h_inicio = $tb_ho_extra[0]['hxe_hora_inicio'];
            $h_fin = $tb_ho_extra[0]['hxe_hora_fin'];

            $factor = $tb_tp_ho_extra[0]['the_factor'];
            $tig = $tb_tp_ho_extra[0]['the_id_tig'];
            $num_horas = ($this->RestarHoras($h_inicio, $h_fin) / 3600);

            $monto = $num_horas * $factor;
            $monto = number_format((float) $monto, 2, '.', '');
            $fe_inicio = $tb_pla[0]['pla_fecha_inicio'];
            $observacion = $tb_ho_extra[0]['hxe_observacion'];
            $motivo = $tb_tp_ho_extra[0]['the_nombre'];
            if ($tig != null && $tig != "") {
                //Insert en la tabla inn_ingreso
                $array_inn_ingreso = array(
                    'inn_id_tig' => $tig,
                    'inn_id_emp' => $id_empleado,
                    'inn_id_hxe' => $id_hora_ex,
                    'inn_id_gva' => null,
                    'inn_motivo' => $motivo, //Este campo tiene el tipo hora y cantidad de hora
                    'inn_valor' => $monto,
                    'inn_fecha_desde' => $fe_inicio,
                    'inn_cuota' => 1,
                    'inn_cuota_pagada' => 0,
                    'inn_id_tpl' => $tipo_planilla,
                    'inn_observacion' => $observacion,
                    'inn_permanente' => 0,
                    'inn_estado' => 1,
                    'inn_usu_crea' => $this->tank_auth->get_user_id(),
                    'inn_fecha_crea' => date("Y-m-d H:i:s"),
                    'inn_usu_mod' => $this->tank_auth->get_user_id(),
                    'inn_fecha_mod' => date("Y-m-d H:i:s")
                );
                $create_inn = $this->gsatelite->ingresar('inn_ingreso', $array_inn_ingreso);
            } else {
                $create_inn = 0;
            }
            if ($create_inn > 0) {
                //Update de la tabla hxe_hora_extraxempleado
                $array_detalle = array(
                    'hxe_id_pla' => $pla_id
                );
                $update_hxe = $this->gsatelite->actualizar_array('hxe_hora_extraxempleado', $array_detalle, array('hxe_id' => $id_hora_ex));
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Procesar horas", 'texto_alerta' => "La hora fue procesada con éxito");
                $this->session->set_flashdata($alerta);
                redirect('acciones_personal/principal/gestion_horas_extras/' . $id_empleado);
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Procesar horas", 'texto_alerta' => "Hubo un error al procesar la hora extra");
                $this->session->set_flashdata($alerta);
                redirect('acciones_personal/principal/gestion_horas_extras/' . $id_empleado);
            }
        }//Fin post		
    }

//Fin funcion update_procesar_hora_extra

    function RestarHoras($horaini, $horafin) {
        $horai = substr($horaini, 0, 2);
        $mini = substr($horaini, 3, 2);
        $segi = substr($horaini, 6, 2);

        $horaf = substr($horafin, 0, 2);
        $minf = substr($horafin, 3, 2);
        $segf = substr($horafin, 6, 2);

        $ini = ((($horai * 60) * 60) + ($mini * 60) + $segi);
        $fin = ((($horaf * 60) * 60) + ($minf * 60) + $segf);

        $dif = $fin - $ini;

        $difh = floor($dif / 3600);
        $difm = floor(($dif - ($difh * 3600)) / 60);
        $difs = $dif - ($difm * 60) - ($difh * 3600);
        return $dif;
        //return date("H:i:s",mktime($difh,$difm,$difs));
    }




     /**
     * Descripción:
     * Función para obtener los empleados en la pantalla de promociones y nivelaciones
     * @author Elman Ortiz - Grupo Satélite
     * @since 2017-12-28
     * @param ninguno
     * @return Obtener array de los empleados
     */
    public function promocion_nivelacion($modulo = null, $ruta_modulo = null) {
        satelite_validar();

        $data['total_empleados'] = $this->personal_model->listado_empleados();
        $data['titulo_personal'] = "Promociones / Nivelaciones";

        //OBTENER RUTA
        $obtener_ruta = $this->gsatelite->get_valores_url();
        $data['url'] = $obtener_ruta['modulo'].'/'.$obtener_ruta['control'];
        if($modulo){ return $data; }
        
        cargarvista($data, null, 'acciones_personal/principal/promocion_nivelacion');
        
    }

    /**
     * Descripción:
     * Función para obtener los empleados en la pantalla de promociones y nivelaciones
     * @author Elman Ortiz - Grupo Satélite
     * @since 2017-12-28
     * @param id_emp es el id del empleado en base al cual se filtran los registros
     * @return Obtener array de los empleados
     */
    public function promocion_nivelacion_empleado($id_emp) {
        satelite_validar();  
        $data['proniv_empleados'] = $this->expediente_personal_model->reporte_promociones_niveles(array('pps_id_emp' => $id_emp));
        $row_emp = $this->gsatelite->get_tabla('emp_empleado', array('emp_id' => $id_emp));
        $data['id_empleado'] = $row_emp[0]['emp_id'];        
        $data['nom_ape_emp'] = $row_emp[0]['emp_nombre'] .' '. $row_emp[0]['emp_apellido'];        
        $data['titulo_personal'] = "Promociones de puestos/salarios";
        $data['id_emp'] = $id_emp;
        // var_dump($data);die();
        //OBTENER RUTA
        $obtener_ruta = $this->gsatelite->get_valores_url();
        $data['url'] = $obtener_ruta['modulo'].'/'.$obtener_ruta['control'];
        if($modulo){ return $data; }
        
        cargarvista($data, null, 'acciones_personal/principal/promocion_nivelacion_empleado');

        //$this->_cargarvista($data, null);        
    }

    /**
     * Descripción:
     * Función para obtener los empleados en la pantalla de promociones y nivelaciones
     * @author Elman Ortiz - Grupo Satélite
     * @since 2017-12-29
     * @param ninguno
     * @return ninguno
     */
    public function nueva_promocion_nivelacion($id_emp) {
        satelite_validar(); 
        $modulo = false;
        $row_emp = $this->gsatelite->get_tabla('emp_empleado', array('emp_id' => $id_emp));
        $data['nom_ape_emp'] = $row_emp[0]['emp_nombre'] .' '. $row_emp[0]['emp_apellido'];
        $plaza_actual =  $this->gsatelite->get_tabla('plz_plaza', array('plz_id' => $row_emp[0]['emp_id_plz']));
        //OBTENER RUTA
        $obtener_ruta = $this->gsatelite->get_valores_url();
        if (count($plaza_actual) == 0) {
            $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Acción no ejecutada", 'texto_alerta' => "No se puede realizar la acción, favor de verificar que el empleado posee una plaza / cargo funcional asignada.");
            $this->session->set_flashdata($alerta);
            $url_back = $obtener_ruta['modulo'] . '/' . $obtener_ruta['control'];
            redirect($url_back . '/promocion_nivelacion_empleado/' . $id_emp);
        }
        $data['id_plaza_actual'] = $plaza_actual[0]['plz_id'];
        $data['id_area_actual'] = $row_emp[0]['emp_id_are'];
        $data['name_area_actual'] = $this->gsatelite->get_campo('are_area', 'are_nombre', array('are_id' => $row_emp[0]['emp_id_are']));
        $data['plaza_actual'] = $plaza_actual[0]['plz_nombre'];
        $salario_actual = $row_emp[0]['emp_salario'];
        $data['id_empleado'] = $row_emp[0]['emp_id'];
        $data['salario_actual'] = $salario_actual;
        $arreglo_ids = $this->expediente_personal_model->get_permitidos_plaza(0);
        $this->db->where_not_in('plz_id', $arreglo_ids);
        if ($row_emp[0]['emp_id_are'] != "") {
            // $this->db->where('plz_id_are',$row_emp[0]['emp_id_are']);
        }
                         $this->db->where('mxr_id_emr', $this->tank_auth->get_empresa_id());
                         $this->db->join('mxr_empresaxarea', 'mxr_id_are = plz_id_are');
        $data['plaza'] = $this->gsatelite->get_tabla('plz_plaza', array('plz_estado' => 1));
                  $this->db->where("plz_id not in (select emp_id_plz from emp_empleado  WHERE emp_id_plz is not null)",null, false);
        $plazas = $this->gsatelite->get_dropdown('plz_plaza', '{plz_nombre}', '', array('plz_estado' => 1), null, null, 'plz_id', true);
        $data['plazas_area'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $plazas);
        $data['departamento'] = $this->personal_model->get_departamento();
        $data['titulo_personal'] = "Promociones de puestos/salarios";
        $data['url'] = $obtener_ruta['modulo'].'/'.$obtener_ruta['control'];
        if($modulo){ return $data; }        
        cargarvista($data, null, 'acciones_personal/principal/nueva_promocion_nivelacion');
        
    }

    function promocion_nivelacion_exportar() {
        satelite_validar();  
        if ($_POST) {
            $id_emp   = $this->input->post('id_empleado');
            $reporte   = $this->input->post('tipo_reporte');
            $data['proniv_empleados'] = $this->expediente_personal_model->reporte_promociones_niveles(array('pps_id_emp' => $id_emp));
            $row_emp = $this->gsatelite->get_tabla('emp_empleado', array('emp_id' => $id_emp));
            
            $data['reporte'] = $reporte;
            $data['id_empleado'] = $row_emp[0]['emp_id'];        
            $data['nom_ape_emp'] = $row_emp[0]['emp_nombre'] .' '. $row_emp[0]['emp_apellido'];        
            $data['titulo_personal'] = "Promociones de puestos/salarios";
            $data['filename'] = 'promocion_nivelacion_empleado_' . $row_emp[0]['emp_nombre'] .' '. $row_emp[0]['emp_apellido'] . '_' . date('dmY') . substr(uniqid(md5(rand()), true), 0, 5);
            $data['id_emp'] = $id_emp;
            $html = $this->load->view('acciones_personal/principal/tabla_pdf_promocion_nivelacion_empleado', $data, true);
            
            if ($reporte == 'pdf') {
                // var_dump($html);die();
                ini_set('memory_limit', '512M' );
                ini_set('max_execution_time', '9999');
                $header = $this->load->view('reporte/header',  array('titulo' => 'Promociones de Puestos/Salarios ', 'subtitulo' => 'Empleada/o - ' . $row_emp[0]['emp_nombre'] .' '. $row_emp[0]['emp_apellido']), true);
                $documento = $header . $html;
                // var_dump($documento);die();
                $this->pdf->makePdf($documento);
            } else {
                echo $html;
            }
            // var_dump($data);die();
        }
    }

    /**
     * Descripción:
     * Función para obtener los empleados en la pantalla de promociones y nivelaciones
     * @author Elman Ortiz - Grupo Satélite
     * @since 2017-12-29
     * @param ninguno
     * @return ninguno
     */
    public function guardar_nueva_promocion_nivelacion() {
        // var_dump($_POST);die();
        satelite_validar();
        $volver = $this->input->post('tipo_boton');
        $id_empleado = $this->input->post('id_empleado');

        $ruta_anexos = $this->input->post('ruta');
        $titulo_anexo = $this->input->post('titulo_doc');

                         $this->db->order_by('pps_id','DESC');
        $promo_anteior = $this->gsatelite->get_tabla('pps_promocion_plaza_salarioxemp', array('pps_id_emp' => $id_empleado));

        $fecha_efectiva = (trim($this->input->post('fecha_efectiva')) != '' ) ? $this->input->post('fecha_efectiva') : date('Y-m-d');
        $fecha = date(formatear_fecha('Y-m-d', $fecha_efectiva));
        $nuevafecha = strtotime ( '-1 day' , strtotime ( $fecha ) ) ;
        $nuevafecha = date ( 'Y-m-d' , $nuevafecha ); 
        $total_promo_anterior = count($promo_anteior);
        $reg_emp = $this->gsatelite->get_registro('emp_empleado',array('emp_id'=>$id_empleado));
        if($total_promo_anterior > 0){
            $id_pps_anterior = $promo_anteior[0]['pps_id'];
        } else {
            //si no existe crearlo automaticamente
            $total_promo_anterior = 1;
            if ($reg_emp->emp_id_plz != '' || $reg_emp->emp_id_plz != null) {
                $promo_nivel = array(
                    'pps_id_plz' => $reg_emp->emp_id_plz,
                    'pps_id_emp' => $reg_emp->emp_id,
                    'pps_id_are' => $reg_emp->emp_id_are,
                    'pps_id_emr' => $this->tank_auth->get_empresa_id(),
                    'pps_tipo' => 0,
                    'pps_salario' => $reg_emp->emp_salario,
                    'pps_fecha_efectiva' => formatear_fecha('Y-m-d',  $reg_emp->emp_fecha_contrato),
                    'pps_fecha_desde' => formatear_fecha('Y-m-d', $reg_emp->emp_fecha_contrato),
                    'pps_fecha_hasta' => $nuevafecha,
                    'pps_estado' => 1,
                    'pps_usu_creacion' => $this->tank_auth->get_user_id(),
                    'pps_fecha_creacion' => date('Y-m-d H:i:s'),
                    'pps_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'pps_fecha_modificacion' => date('Y-m-d H:i:s')            
                );    
                $id_pps_anterior = $this->gsatelite->ingresar('pps_promocion_plaza_salarioxemp', $promo_nivel);
            } 
        }        
        $promo_nivel = array(
            'pps_id_plz' => ($this->input->post('puesto') != "") ? $this->input->post('puesto') : $this->input->post('id_plaza_actual'),
            'pps_id_emp' => $this->input->post('id_empleado'),
            'pps_id_are' => ($this->input->post('departamento') != "") ? $this->input->post('departamento') : $this->input->post('id_area_actual'),
            'pps_id_emr' => $this->tank_auth->get_empresa_id(),
            'pps_tipo' => $this->input->post('tipo_promocion'),
            'pps_salario' => $this->input->post('salario'),
            'pps_fecha_efectiva' => formatear_fecha('Y-m-d', $this->input->post('fecha_efectiva')),
            'pps_fecha_desde' => formatear_fecha('Y-m-d', $this->input->post('fecha_efectiva')),
            'pps_fecha_hasta' => null,
            'pps_autorizacion_hacienda' => ($this->input->post('autorizacion_mh') != '') ? $this->input->post('autorizacion_mh') : null,
            'pps_resolucion_interna' => ($this->input->post('resolucion_interna') != '') ? $this->input->post('resolucion_interna') : null,
            'pps_observaciones' => $this->input->post('observaciones'),
            'pps_estado' => 1,
            'pps_usu_creacion' => $this->tank_auth->get_user_id(),
            'pps_fecha_creacion' => date('Y-m-d H:i:s'),
            'pps_usu_modificacion' => $this->tank_auth->get_user_id(),
            'pps_fecha_modificacion' => date('Y-m-d H:i:s')            
        );    
        $promocion_nivelacion = $this->gsatelite->ingresar('pps_promocion_plaza_salarioxemp', $promo_nivel);
        /*Si tiene por lo menos 1 registro en pps_promocion_plaza_salarioxemp se debe de actualizar la fecha fin del anterior*/
        if($promocion_nivelacion > 0){
            //Se actualiza la nueva plaza del empleado
            $actualizacion_empleado = array(
                'emp_salario' => $this->input->post('salario'), 
                'emp_id_are' => ($this->input->post('departamento') != "") ? $this->input->post('departamento') : $reg_emp->emp_id_are,
                'emp_id_plz' => ($this->input->post('puesto') != "") ? $this->input->post('puesto') : $this->input->post('id_plaza_actual')
            );            
            $this->gsatelite->actualizar_array('emp_empleado', $actualizacion_empleado , array('emp_id' => $id_empleado));
            // SI SOLO ES TRASLADO CON MISMA PLAZA SE ACTUALIZA EL AREA DE LA PLAZA TAMBIEN
            if ($this->input->post('tipo_promocion') == 3) {
                $actualizacion_plaza = array(
                    'plz_id_are' => ($this->input->post('departamento') != "") ? $this->input->post('departamento') : $reg_emp->emp_id_are
                );
                $this->gsatelite->actualizar_array('plz_plaza',$actualizacion_plaza , array('plz_id' => $this->input->post('id_plaza_actual')));
            }
            if($total_promo_anterior > 0){
                $this->gsatelite->actualizar_array('pps_promocion_plaza_salarioxemp', array('pps_fecha_hasta' => $nuevafecha,'pps_estado' => 0), array('pps_id' => $id_pps_anterior));             
            }   
        }

        //Si vienen anexos
        if (!empty($ruta_anexos)) {
            for ($i = 0; $i < count($ruta_anexos); $i++) {
                $extension = end(explode('.', $ruta_anexos[$i]));
                $carpeta_temporal_anx = $ruta = "public/temp/anexos_promocion_nivelacion/" . trim($ruta_anexos[$i]);
                $nombreArchivo = trim($titulo_anexo[$i]) . "." . trim($extension);
                $carpeta_destino_anx = "uploads/anexos_promocion_nivelacion/" . $nombreArchivo;
                $documentos_array = array(
                    'axr_id_pps'             => $promocion_nivelacion,
                    'axr_nombre'             => $nombreArchivo,
                    'axr_url'                => $carpeta_destino_anx,
                    'axr_estado'             => 1,
                    'axr_usu_creacion'       => $this->tank_auth->get_user_id(),
                    'axr_fecha_creacion'     => date('Y-m-d H:i:s'),
                    'axr_usu_modificacion'   => $this->tank_auth->get_user_id(),
                    'axr_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                $ant_id = $this->gsatelite->ingresar('axr_anexos_promocion_nivelacion', $documentos_array);
                if ($ant_id > 0) {
                    copy($carpeta_temporal_anx, $carpeta_destino_anx);
                    unlink($carpeta_temporal_anx);
                }
            }
        }

        if ($promocion_nivelacion > 0) {
            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Acción ejecutada", 'texto_alerta' => "Los registros fueron guardados corectamente");
        } else {
            $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Acción no ejecutada", 'texto_alerta' => "No se pudo realizar la acción, favor de verificar la información");
        }
        $url = $this->input->post('url');
        if ($volver == 'guardar') {
            $this->session->set_flashdata($alerta);
            redirect($url.'/nueva_promocion_nivelacion/'.$id_empleado);//Crear nueva promocion
        } else {
            $this->session->set_flashdata($alerta);
            redirect($url.'/promocion_nivelacion_empleado/'.$id_empleado);//Lista de promociones de empleado
        }
        
    }

    /**
     * Descripción:
     * Función para obtener los empleados en la pantalla de promociones y nivelaciones
     * @author Elman Ortiz - Grupo Satélite
     * @since 2018-01-03
     * @param ninguno
     * @return ninguno
     */
    public function editar_promocion_nivelacion($id_emp, $id_pps) {
        satelite_validar();
        $modulo = false;     
        $row_emp = $this->gsatelite->get_tabla('emp_empleado', array('emp_id' => $id_emp));
        $data['nom_ape_emp'] = $row_emp[0]['emp_nombre'] .' '. $row_emp[0]['emp_apellido'];
        $pps_promo = $this->gsatelite->get_tabla('pps_promocion_plaza_salarioxemp', array('pps_id'=> $id_pps));        
        $plaza_actual = $this->gsatelite->get_tabla('plz_plaza', array('plz_id' => $row_emp[0]['emp_id_plz']));
        $plz_tomadas = $this->expediente_personal_model->get_permitidos_plaza(0);
        $plz_tom_act = $this->expediente_personal_model->get_permitidos_plaza($plaza_actual[0]['plz_id']);        
        $empresa = $this->tank_auth->get_empresa_id();
                        $this->db->where_not_in('plz_id', $plz_tom_act);
                        $this->db->join('mxr_empresaxarea', 'mxr_id_are = plz_id_are');
        $slc_plz_act = $this->gsatelite->get_dropdown('plz_plaza', '{plz_nombre}', '', array('plz_estado' => 1, 'mxr_id_emr' => $empresa), $row_emp[0]['emp_id_plz'], null, 'plz_id', true);        
                        $this->db->where_not_in('plz_id', $plz_tomadas);
                        $this->db->join('mxr_empresaxarea', 'mxr_id_are = plz_id_are');
        $slc_plz_disp = $this->gsatelite->get_dropdown('plz_plaza', '{plz_nombre}', '', array('plz_estado' => 1, 'mxr_id_emr' => $empresa), null, null, 'plz_id', true);
        $data['id_plaza_actual'] = $plaza_actual[0]['plz_id'];//ok
        $data['id_area_actual'] = $row_emp[0]['emp_id_are'];
        $data['name_area_actual'] = $this->gsatelite->get_campo('are_area', 'are_nombre', array('are_id' => $row_emp[0]['emp_id_are']));
        $data['plaza_actual'] = $plaza_actual[0]['plz_nombre'];//ok
        $data['slc_plz_actl'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $slc_plz_act);
        $data['slc_plz_disp'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $slc_plz_disp);
        $data['id_empleado'] = $row_emp[0]['emp_id'];
        $data['salario_actual'] = $row_emp[0]['emp_salario'];
        $data['departamento'] = $this->personal_model->get_departamento();
        //Datos de la promocion/nivelacion        
        $data['pps_promo'] = $pps_promo;
        $area_actual = $this->gsatelite->get_tabla('plz_plaza', array('plz_id' => $data['id_plaza_actual']));
        $data['id_area_actual'] = $area_actual[0]['plz_id_are'];
                        $this->db->join('mxr_empresaxarea', 'mxr_id_are = are_id');
        $slc_are_actl = $this->gsatelite->get_dropdown('are_area', '{are_nombre}', '', array('are_estado' => 1, 'mxr_id_emr' => $empresa), $area_actual[0]['plz_id_are'], null, 'are_id', true);
        $data['slc_are_actl'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $slc_are_actl);
        $data['titulo_personal'] = "Editar promociones de puestos/salarios";
        $arreglo_ids = $this->expediente_personal_model->get_permitidos_plaza($row_emp[0]['emp_id_plz']);
        $this->db->where_not_in('plz_id', $arreglo_ids);
        if ($row_emp[0]['emp_id_are'] != "") {
            $this->db->where('plz_id_are',$row_emp[0]['emp_id_are']);
        }
                         $this->db->where('mxr_id_emr', $this->tank_auth->get_empresa_id());
                         $this->db->join('mxr_empresaxarea', 'mxr_id_are = plz_id_are');
        $data['plaza'] = $this->gsatelite->get_tabla('plz_plaza', array('plz_estado' => 1));

        //OBTENER RUTA
        $obtener_ruta = $this->gsatelite->get_valores_url();
        $data['url'] = $obtener_ruta['modulo'].'/'.$obtener_ruta['control'];

        //OBTENER ANEXOS
        $anexos_cita = $this->gsatelite->get_tabla("axr_anexos_promocion_nivelacion",array("axr_id_pps" => $id_pps));
        $data['anexos'] = $anexos_cita;

        if($modulo){ return $data; }
        cargarvista($data, null, 'acciones_personal/principal/editar_promocion_nivelacion');
    }

    /***************************************************************************************************/
    /**
     * Descripción:
     * Función para obtener los empleados en la pantalla de promociones y nivelaciones
     * @author Elman Ortiz - Grupo Satélite
     * @since 2017-12-29
     * @param ninguno
     * @return ninguno
     */
    public function guardar_editar_promocion_nivelacion($id_pps) {
        // var_dump($_POST);die();
        satelite_validar();
        $volver = $this->input->post('tipo_boton');
        $id_empleado = $this->input->post('id_empleado');

        $ruta_anexos = $this->input->post('ruta');
        $titulo_anexo = $this->input->post('titulo_doc');

                         $this->db->order_by('pps_id','DESC');
        $promo_anteior = $this->gsatelite->get_tabla('pps_promocion_plaza_salarioxemp', array('pps_id_emp' => $id_empleado,"pps_id NOT IN($id_pps)" => NULL));

        $total_promo_anterior = count($promo_anteior);
        $reg_emp = $this->gsatelite->get_registro('emp_empleado',array('emp_id'=>$id_empleado));
        if($total_promo_anterior > 0){
            $id_pps_anterior = $promo_anteior[0]['pps_id'];
        }        
        $promo_nivel = array(
            'pps_id_plz' => ($this->input->post('puesto') != "") ? $this->input->post('puesto') : $this->input->post('id_plaza_actual'),
            'pps_id_are' => ($this->input->post('departamento') != "") ? $this->input->post('departamento') : $this->input->post('id_area_actual'),
            'pps_id_emp' => $this->input->post('id_empleado'),
            'pps_tipo' => $this->input->post('tipo_promocion'),
            'pps_salario' => $this->input->post('salario'),
            'pps_fecha_efectiva' => ($this->input->post('fecha_efectiva')!='')?formatear_fecha('Y-m-d', $this->input->post('fecha_efectiva')):null,
            'pps_fecha_desde' => ($this->input->post('fecha_efectiva')!='')?formatear_fecha('Y-m-d', $this->input->post('fecha_efectiva')):null,
            'pps_fecha_hasta' => null,
            'pps_autorizacion_hacienda' => ($this->input->post('autorizacion_mh') != '') ? $this->input->post('autorizacion_mh') : null,
            'pps_resolucion_interna' => ($this->input->post('resolucion_interna') != '') ? $this->input->post('resolucion_interna') : null,
            'pps_observaciones' => $this->input->post('observaciones'),
            'pps_estado' => 1,            
            'pps_usu_modificacion' => $this->tank_auth->get_user_id(),
            'pps_fecha_modificacion' => date('Y-m-d H:i:s')            
        );           
        $promocion_nivelacion = $this->gsatelite->actualizar_array('pps_promocion_plaza_salarioxemp', $promo_nivel, array('pps_id' => $id_pps));
        /*Si tiene por lo menos 1 registro en pps_promocion_plaza_salarioxemp se debe de actualizar la fecha fin del anterior*/
        if($promocion_nivelacion > 0){
            //Se actualiza la nueva plaza del empleado            
            $actualizacion_empleado = array(
                'emp_salario' => $this->input->post('salario'), 
                'emp_id_are' => ($this->input->post('departamento') != "") ? $this->input->post('departamento') :$reg_emp->emp_id_are,
                'emp_id_plz' => ($this->input->post('puesto') != "") ? $this->input->post('puesto') : $this->input->post('id_plaza_actual')
            );
            $this->gsatelite->actualizar_array('emp_empleado', $actualizacion_empleado , array('emp_id' => $id_empleado));
            // SI SOLO ES TRASLADO CON MISMA PLAZA SE ACTUALIZA EL AREA DE LA PLAZA TAMBIEN
            if ($this->input->post('tipo_promocion') == 3) {
                $actualizacion_plaza = array(
                    'plz_id_are' => ($this->input->post('departamento') != "") ? $this->input->post('departamento') : $reg_emp->emp_id_are
                );
                $this->gsatelite->actualizar_array('plz_plaza',$actualizacion_plaza , array('plz_id' => $this->input->post('id_plaza_actual')));
            }            
            if($total_promo_anterior > 0){
                if($this->input->post('fecha_efectiva')!=''){ 
                    $fecha = date(formatear_fecha('Y-m-d', $this->input->post('fecha_efectiva')));
                    $nuevafecha = strtotime ( '-1 day' , strtotime ( $fecha ) ) ;
                    $nuevafecha = date ( 'Y-m-d' , $nuevafecha );            
                    $this->gsatelite->actualizar_array('pps_promocion_plaza_salarioxemp', array('pps_fecha_hasta' => $nuevafecha), array('pps_id' => $id_pps_anterior));
                }
                //$this->gsatelite->actualizar_array('pps_promocion_plaza_salarioxemp', array('pps_estado' => 0), array('pps_id' => $promo_anteior[0]['pps_id']));                
            }
        }

        //Si vienen anexos
        if (!empty($ruta_anexos)) {
            for ($i = 0; $i < count($ruta_anexos); $i++) {
                $extension = end(explode('.', $ruta_anexos[$i]));
                $carpeta_temporal_anx = $ruta = "public/temp/anexos_promocion_nivelacion/" . trim($ruta_anexos[$i]);
                $nombreArchivo = trim($titulo_anexo[$i]) . "." . trim($extension);
                $carpeta_destino_anx = "uploads/anexos_promocion_nivelacion/" . $nombreArchivo;
                $documentos_array = array(
                    'axr_id_pps'             => $id_pps,
                    'axr_nombre'             => $nombreArchivo,
                    'axr_url'                => $carpeta_destino_anx,
                    'axr_estado'             => 1,
                    'axr_usu_creacion'       => $this->tank_auth->get_user_id(),
                    'axr_fecha_creacion'     => date('Y-m-d H:i:s'),
                    'axr_usu_modificacion'   => $this->tank_auth->get_user_id(),
                    'axr_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                $ant_id = $this->gsatelite->ingresar('axr_anexos_promocion_nivelacion', $documentos_array);
                if ($ant_id > 0) {
                    copy($carpeta_temporal_anx, $carpeta_destino_anx);
                    unlink($carpeta_temporal_anx);
                }
            }
        }

        if ($promocion_nivelacion > 0) {
            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Acción ejecutada", 'texto_alerta' => "Los registros fueron guardados corectamente");
        } else {
            $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Acción no ejecutada", 'texto_alerta' => "No se pudo realizar la acción, favor de verificar la información");
        }

        $url = $this->input->post('url');

        if ($volver == 'guardar') {
            $this->session->set_flashdata($alerta);
            redirect($url.'/editar_promocion_nivelacion/'.$id_empleado.'/'.$id_pps);
        } else {
            $this->session->set_flashdata($alerta);
            redirect($url.'/promocion_nivelacion_empleado/'.$id_empleado);
        }
        
    }
    /***************************************************************************************************/

    /**
    * @author René Castaneda
    * @since 2018-01-11
    * @return Lectura del detalle de vacación del empleado
     */
    public function ver_detalle_vacacion($id_vacacion = 0)
    {

        $registro_detalle = $this->gsatelite->accion_personal_model->get_detalle_vacacion(array('gva_id' => $id_vacacion));
        $data['base_calculo_vacacion'] = $registro_detalle[0]['emp_salario']; 
        $data["titulo_personal"] = "Ver detalle de Vacaciones empleado";
        $data["factor_calculo_vacacion"] = $this->gsatelite->get_parametro('FACTOR_CALCULO_VACACION');
        $data["info_registro"] = $registro_detalle;
        $this->_cargarvista($data, null);
    }

    /**
    * @author René Castaneda
    * @since 2018-01-12
    * @return  Listado de empleados (para gestionar vacaciones)
     */
    public function listado_empleados_vacacion() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {

            $permisos = $this->gsatelite->get_permisos_opcion();
            $data["permisos"] = $permisos;
            $data['total_empleados'] = $this->personal_model->listado_empleados(array('emp_estado'=>1));
            $data['titulo_personal'] = "Vacaciones Empleadas/os";
            $this->_cargarvista($data, null);
        }
    }

    public function imprimir_memo($emp_id) {
        $this->load->library('pdf');

		$data = [];

        $data['emp_id'] = $emp_id;
		$html_header = ''; 
		$html = $this->load->view('acciones_personal/principal/memorando', $data, true);
	  	
        $this->pdf->makePDF($html_header.$html, 'P');
    }

    public function notificacion_reincorporacion($id_permiso, $emp_id) {
        satelite_validar();
        $this->verifica_registro_real('hxe_hora_extraxempleado', $id_permiso);
        $this->load->library('Pdf');
        $data["consulta"] = $this->accion_personal_model->get_datos_permiso_unico(array('hxe_id' => $id_permiso));
        
        $data["emp_id"] = $emp_id;

        $html_header = ''; 
        $html = $this->load->view('acciones_personal/principal/notificacion_reincorporacion', $data, true);
        
        $this->pdf->setPrintFooter(false);
        $this->pdf->makePDF($html_header.$html, 'P');
    }

    public function notificacion_destitucion($emp_id, $rte_id) {
        satelite_validar();
        
        $rte_info = $this->gsatelite->get_registro('rte_retiro_empleado', array('rte_id' => $rte_id));

        $docid = $rte_info->rte_id_rxe;

        if ($docid > 0) {
            $tabla_html = $this->gsatelite->get_tabla("rxe_resolucionxempleado", array("rxe_id" => $docid));
            if (count($tabla_html) > 0) {
                $html = $tabla_html[0]['rxe_html'];
                $this->pdf->setPrintFooter(false);
                $this->pdf->makePDF($html, 'P');
            } else {
                $this->gsatelite->show_dialog("No se puede Imprimir el formulario solicitado", "expediente_personal/empleado/retiro_personal", "error");
            }
        }
    }

    /**
    * @author René Castaneda
    * @since 2018-01-12
    * @return  Listado de empleados (para gestionar horas extras)
     */
    public function empleado_tiempo_trabajado() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {

            $permisos = $this->gsatelite->get_permisos_opcion();
            $data["permisos"] = $permisos;
            $data['total_empleados'] = $this->personal_model->listado_empleados(array('emp_estado'=>1));
            $data['titulo_personal'] = "Horas extra empleado";
            $this->_cargarvista($data, null);
        }
    }

    /**
    * @author René Castaneda
    * @since 2018-01-12
    * @return  Listado de empleados (para gestionar horas no trabajadas)
     */
    public function empleado_tiempo_notrabajado() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $permisos = $this->gsatelite->get_permisos_opcion();
            $data["permisos"] = $permisos;
            $data['total_empleados'] = $this->personal_model->listado_empleados(array('emp_estado'=>1));
            $data['titulo_personal'] = "Permisos";
            $this->_cargarvista($data, null);
        }
    }

    /**
    * @author René Castaneda
    * @since 2018-01-12
    * @return  Listado de empleados (para gestionar horas no trabajadas)
     */
    public function gestion_horas_notrabajadas($id_empleado = null) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $this->verifica_empleado_real($id_empleado);
            $data['permisos'] = $this->gsatelite->get_permisos_opcion('acciones_personal/principal/empleado_tiempo_notrabajado');
            $data["info_empleado"] = $this->gsatelite->get_tabla('emp_empleado', array('emp_id' => $id_empleado));
            $data["consulta2"] = $this->accion_personal_model->get_horas_faltantes(array('hxe_id_emp' => $id_empleado));
            $data["titulo_personal"] = "Permisos";
            $data["id_empleado"] = $id_empleado;
            $this->_cargarvista($data, null);
        }
    }

    /**
    * @author René Castaneda
    * @since 2018-01-27
    * @return  Listado de empleados (para gestionar las incapacidades)
     */
    public function incapacidad_empleado() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $permisos = $this->gsatelite->get_permisos_opcion();
            $data["permisos"] = $permisos;
            $data['total_empleados'] = $this->personal_model->listado_empleados(array('emp_estado'=>1));
            $data['titulo_personal'] = "Incapacidad Empleadas/os";
            $this->_cargarvista($data, null);
        }
    }

    /**
    * @author Edith Herrera - Grupo Satélite
    * @since  2018-07-18
    * @return vista para la Carga masiva de Horas extras
     */
    public function horas_extras_masivas(){
        satelite_validar();
        if($_FILES){
            // Memory
            ini_set( 'memory_limit', '2048M' );
            ini_set('max_execution_time', '9999');  
            // Datos agregados en json - POST
            $datos = json_decode($_POST['data']);
            $id_pla = $datos[0]->csv_planilla;
            $id_prd = $datos[0]->csv_periodo;
            $tipo = $datos[0]->csv_tipo;
            // CSV
            $file = fopen($_FILES['csv_extras']['tmp_name'], "r");
            $cabezera = fgetcsv($file);
            if(count($cabezera) == 3){
                $extras_array = array();
                while (! feof($file)){
                    $datos_reg = fgetcsv($file);
                    if (count($datos_reg) == 3 ) {
                        //validar que es un registro valido
                        $valido = 1;
                        $reg_emp = $this->gsatelite->get_registro('emp_empleado',array('emp_codigo'=>trim($datos_reg[0]), 'emp_id_emr' => $this->tank_auth->get_empresa_id()));
                        if(count($reg_emp) > 0){
                            $planillas = $this->gsatelite->get_tabla('txe_tipo_planillaxempleado',array('txe_id_emp'=>$reg_emp->emp_id));
                            $pla_ids = array_column($planillas, 'txe_id_tpl');
                            $tipo_reg = $this->gsatelite->get_registro('the_tipo_hora_extra', array('the_id'=>$tipo));
                            $tipo_ing = $this->gsatelite->get_registro('tig_tipo_ingreso', array('tig_id' => $tipo_reg->the_id_tig));
                        }
                        $fecha_inicio = $this->gsatelite->get_campo('pla_planilla','pla_fecha_inicio',array('pla_id'=>$id_prd));

                        // Parámetros de días y horas laborales.
                        $dias_trabajados_mes = $this->gsatelite->get_parametro('DIAS_TRABAJADOS_MES');
                        $horas_trabajadas_dia = $this->gsatelite->get_parametro('HORAS_TRABAJADAS_DIA');

                        /*********************** Cálculo de monto por horas extras *****************************/
                        $salario=$reg_emp->emp_salario;
                        if ($tipo_ing->tig_aplica_valor_fijo == 1 && $tipo_ing->tig_valor_fijo > 0) {
                            $calcula = ($tipo_ing->tig_valor_fijo * $datos_reg[1]);
                        } else {
                            $calcula = (($salario / ($dias_trabajados_mes * $horas_trabajadas_dia)) * $datos_reg[1]);
                        }                        
                        // $calcula= (($salario / ($dias_trabajados_mes*$horas_trabajadas_dia)) * $datos_reg[1]);
                        if(count($tipo_reg)>0){
                            $n_calculo=$calcula  * ( $tipo_reg->the_factor);
                        }else{
                            $valido = 0;
                        }
                        /***************************************************************************************/

                        if ( count($reg_emp) <= 0 || !in_array($id_pla, $pla_ids) || $dias_trabajados_mes <= 0 || $horas_trabajadas_dia <= 0 || $n_calculo <= 0) {
                           $valido = 0;
                        }
                        
                        //Datos necesarios para registros de horas e ingreso a planilla.
                        $array_datos['the_id'] = (count($tipo_reg)>0)? $tipo_reg->the_id:0;
                        $array_datos['periodo'] = $id_prd;
                        $array_datos['tipo_pla'] = $id_pla;
                        $array_datos['tipo_ing'] = (count($tipo_reg)>0)? $tipo_reg->the_id_tig:0;
                        $array_datos['id_empleado'] = ($reg_emp)? $reg_emp->emp_id:0;
                        $array_datos['fecha_inicio'] = formatear_fecha("Y-m-d",$fecha_inicio);


                        //Datos CSV
                        $array_datos['codigo_emp'] = $datos_reg[0]; 
                        $array_datos['horas'] = $datos_reg[1]; 
                        $array_datos['observacion'] = $datos_reg[2];

                        $array_datos['codigo_empleado'] = ($reg_emp)? $reg_emp->emp_codigo:'no encontrado';
                        $array_datos['nombre_empleado'] = ($reg_emp)? $reg_emp->emp_nombre.' '.$reg_emp->emp_apellido:'no encontrado';
                        $array_datos['tipo'] = (count($tipo_reg)>0)? $tipo_reg->the_nombre:'no encontrado';
                        $array_datos['monto'] = (count($n_calculo)>0)? $n_calculo:'';
                        
                        $array_datos['valido'] = $valido; 
                        $extras_array[] = $array_datos;
                    }
                }                
                $data['extras_array'] = $extras_array;
                $excel_data = '<br/><center><h4>(<em>'. $_FILES["csv_extras"]["name"] .'</em>)</h4></center><br/>';
                $excel_data .='<div class="span6" style="margin-left:2%"><div style="width:15px;height:15px;background:rgb(242, 161, 161);"></div><div style="width:100%; margin:-3% 0 1% 6%"><h5>Los registros marcados en rojo son inválidos y no seran procesados.</h5></div></div><br/><br></div>';
                $excel_data.= $this->load->view('acciones_personal/principal/tabla_csv_horas_extras',$data,true);
            } else {
                $excel_data .='<br/><center><h4>(<em>'. $_FILES["csv_extras"]["name"] .'</em>)</h4></center><br/><center><h3>';
                $excel_data .='La hoja actual no cumple con el formato de columnas</h3><br/>';
                $excel_data .='<h4>Favor revisar documento csv y cantidad de columnas</h4></center><br/>';
            }
            fclose($file);
            $tabla_html = $excel_data;
            $datajson = array('drop'=>$tabla_html);
            $json = json_encode($datajson);
            echo $json;
            die();
        } else {
            $select = $this->gsatelite->get_dropdown('tpl_tipo_planilla', '{tpl_nombre}', '', null, null, '', 'tpl_id', true);
            $data["select_tpl_id"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $select);
            $select = $this->gsatelite->get_dropdown('the_tipo_hora_extra', '{the_nombre} ({the_factor})', '', array('the_estado' => 1), null, '', 'the_id', true);
            $data["select_tipo_hora_extra"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $select);
            $data['titulo_personal'] = "Gestión de horas extras masivas";
            cargarvista($data);
        }
    }


    /**
    * @author Edith Herrera - Grupo satélite
    * @since  2018-07-19
    * @return Procesamiento de datos de carga masiva de horas extras
    **/
    public function procesar_carga_extra(){
        if ($this->input->post()) {
            $datos_horas = $this->input->post('datos_horas');
            $n = count($datos_horas);
            $datos_ingreso = $this->input->post('datos_ingreso');
            $n = count($datos_ingreso);
            $auditoria = array(
                'hxe_estado' => 1,
                'hxe_usu_crea' => $this->tank_auth->get_user_id(),
                'hxe_fecha_crea' => date('Y-m-d H:i:s'),
                'hxe_usu_mod' => $this->tank_auth->get_user_id(),
                'hxe_fecha_mod' => date('Y-m-d H:i:s')
            );
            $exito = 0;
            for ($i=0; $i < $n ; $i++) { 
                $datos_array = (trim($datos_horas[$i]) != '')? ((array) json_decode($datos_horas[$i])):null;
                if (is_array($datos_array)) {
                    $array_insert = array_merge($datos_array, $auditoria);
                    $id = $this->gsatelite->ingresar('hxe_hora_extraxempleado',$array_insert);
                    // Ingresos por horas extras
                    $datos_array_inn = (trim($datos_ingreso[$i]) != '')? ((array) json_decode($datos_ingreso[$i])):null;
                    if (is_array($datos_array_inn) && $datos_array_inn['inn_id_tig'] != "" && $datos_array_inn['inn_id_tig'] != null) {
                        $auditoria_inn = array(
                            'inn_id_hxe' => $id,
                            'inn_estado' => 1,
                            'inn_fecha_crea' => date("Y-m-d H:i:s"),
                            'inn_usu_crea' => $this->tank_auth->get_user_id(),
                            'inn_fecha_mod' => date("Y-m-d H:i:s"),
                            'inn_usu_mod' => $this->tank_auth->get_user_id()
                        );
                        $array_insert_inn = array_merge($datos_array_inn, $auditoria_inn);
                        $innid = $this->gsatelite->ingresar('inn_ingreso',$array_insert_inn);
                    }
                    $exito++;
                }
            }
            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Carga masiva horas extras", 'texto_alerta' => "La operación a sido realizada con éxito ($exito registros procesados)");
            $this->session->set_flashdata($alerta);
            redirect('acciones_personal/principal/horas_extras_masivas');


        } else {
            redirect('acciones_personal/principal/horas_extras_masivas');
        }
    }


    /**
    * @author Edith Herrera - Grupo Satélite
    * @since  2018-07-20
    * @return vista para la carga masiva de Horas no trabajadas
     */
    public function horas_notrabajadas_masivas()
    {
        satelite_validar();
        if($_FILES){
            // Memory
            ini_set( 'memory_limit', '2048M' );
            ini_set('max_execution_time', '9999');  

            // Datos agregados en json - POST
            $datos = json_decode($_POST['data']);
            $id_pla = $datos[0]->csv_planilla;
            $id_prd = $datos[0]->csv_periodo;
            $tipo = $datos[0]->csv_tipo;

            // CSV
            $file = fopen($_FILES['csv_notrabajado']['tmp_name'], "r");
            $cabezera = fgetcsv($file);
            
            if(count($cabezera) == 5){
                $extras_array = array();
                while (! feof($file)){
                    $datos_reg = fgetcsv($file);
                    if (count($datos_reg) == 5 ) {
                        //validar que es un registro valido
                        $valido = 1;
                        $reg_emp = $this->gsatelite->get_registro('emp_empleado',array('emp_codigo'=>trim($datos_reg[0]), 'emp_id_emr' => $this->tank_auth->get_empresa_id()));
                        if(count($reg_emp)>0){
                            $planillas = $this->gsatelite->get_tabla('txe_tipo_planillaxempleado',array('txe_id_emp'=>$reg_emp->emp_id));
                            $pla_ids = array_column($planillas, 'txe_id_tpl');
                            $tipo_reg = $this->gsatelite->get_registro('thf_tipo_hora_faltante', array('thf_id'=>$tipo));
                        }

                        $fecha_inicio = $this->gsatelite->get_campo('pla_planilla','pla_fecha_inicio',array('pla_id'=>$id_prd));

                        // Parámetros de días y horas laborales.
                        $dias_trabajados_mes = $this->gsatelite->get_parametro('DIAS_TRABAJADOS_MES');
                        $horas_trabajadas_dia = $this->gsatelite->get_parametro('HORAS_TRABAJADAS_DIA');
                        //die(print_r($reg_emp->emp_salario));

                        

                        /*********************** Cálculo de monto por horas no trabajadas *****************************/
                        $salario=$reg_emp->emp_salario;
                        $calcula= (($salario / ($dias_trabajados_mes*$horas_trabajadas_dia)) * $datos_reg[3]);
                        if(count($tipo_reg)>0){
                            $n_calculo=$calcula  * (float)( $tipo_reg->thf_factor);
                        }else{
                            $valido = 0;
                        }
                        /***************************************************************************************/

                        if ( count($reg_emp) <= 0 || !in_array($id_pla, $pla_ids) || $dias_trabajados_mes <= 0 || $horas_trabajadas_dia <= 0 || $n_calculo <= 0) {
                           $valido = 0;
                        }
                        
                        //Datos necesarios para registros de horas e ingreso a planilla.
                        $array_datos['periodo'] = $id_prd;
                        $array_datos['thf_id'] = (count($tipo_reg)>0)? $tipo_reg->thf_id:0;
                        $array_datos['id_empleado'] = ($reg_emp)? $reg_emp->emp_id:0;
                        $array_datos['tipo_pla'] = $id_pla;
                        $array_datos['tipo_tdc'] = (count($tipo_reg)>0)? $tipo_reg->thf_id_tdc:0;
                        //$array_datos['fecha_inicio'] = formatear_fecha("Y-m-d",$fecha_inicio);


                        //Datos CSV
                        $array_datos['codigo_emp'] = $datos_reg[0]; 
                        $array_datos['fecha_ini'] = $datos_reg[1];
                        $array_datos['fecha_fin'] = $datos_reg[2];
                        $array_datos['horas'] = $datos_reg[3]; 
                        $array_datos['observacion'] = $datos_reg[4];

                        $array_datos['codigo_empleado'] = ($reg_emp)? $reg_emp->emp_codigo:'no encontrado';
                        $array_datos['nombre_empleado'] = ($reg_emp)? $reg_emp->emp_nombre.' '.$reg_emp->emp_apellido:'no encontrado';
                        $array_datos['tipo'] = (count($tipo_reg)>0)? $tipo_reg->thf_nombre:'no encontrado';
                        $array_datos['monto'] = (count($n_calculo)>0)? $n_calculo:'';
                        
                        $array_datos['valido'] = $valido; 
                        $notrabajadas_array[] = $array_datos;
                    }
                }
                
                $data['notrabajadas_array'] = $notrabajadas_array;

                $excel_data = '<br/><center><h4>(<em>'. $_FILES["csv_notrabajado"]["name"] .'</em>)</h4></center><br/>';
                $excel_data .='<div class="span6" style="margin-left:2%"><div style="width:15px;height:15px;background:rgb(242, 161, 161);"></div><div style="width:100%; margin:-3% 0 1% 6%"><h5>Los registros marcados en rojo son inválidos y no seran procesados.</h5></div></div><br/><br>
                               </div>';
                $excel_data.= $this->load->view('acciones_personal/principal/tabla_horas_notrabajadas',$data,true);
            }
            else{
                $excel_data .='<br/><center><h4>(<em>'. $_FILES["csv_notrabajado"]["name"] .'</em>)</h4></center><br/><center><h3>';
                $excel_data .='La hoja actual no cumple con el formato de columnas</h3><br/>';
                $excel_data .='<h4>Favor revisar documento csv y cantidad de columnas</h4></center><br/>';
            }

            fclose($file);

            $tabla_html = $excel_data;

            echo json_encode(array('drop'=>$tabla_html));
        } else {    

            $select = $this->gsatelite->get_dropdown('tpl_tipo_planilla', '{tpl_nombre}', '', null, null, '', 'tpl_id', true);
            $data["select_tpl_id"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $select);

            $select = $this->gsatelite->get_dropdown('thf_tipo_hora_faltante', '{thf_nombre} ({thf_factor})', '', array('thf_estado' => 1), null, '', 'thf_id', true);
             $data["select_tipo_hora_faltante"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option', $select);

            $data['titulo_personal'] = "Gestión de horas no trabajadas";
            cargarvista($data);
        }
    }


    /**
    * @author Edith Herrera - Grupo satélite
    * @since  2018-07-20
    * @return Procesamiento de datos de carga masiva de horas no trabajadas
    **/
    public function procesar_carga_notrabajadas(){
        if ($this->input->post()) {
            
            $datos_horas = $this->input->post('datos_horas');
            $n = count($datos_horas);
            $datos_ingreso = $this->input->post('datos_descuento');
            $n = count($datos_ingreso);

            $auditoria = array(
                'hxe_estado' => 1,
                'hxe_usu_crea' => $this->tank_auth->get_user_id(),
                'hxe_fecha_crea' => date('Y-m-d H:i:s'),
                'hxe_usu_mod' => $this->tank_auth->get_user_id(),
                'hxe_fecha_mod' => date('Y-m-d H:i:s')
            );

            $exito = 0;
            for ($i=0; $i < $n ; $i++) { 
                $datos_array = (trim($datos_horas[$i]) != '')? ((array) json_decode($datos_horas[$i])):null;
                if (is_array($datos_array)) {
                    $array_insert =     array_merge($datos_array, $auditoria);
                    
                    $id = $this->gsatelite->ingresar('hxe_hora_extraxempleado',$array_insert);
                    
                    // Ingresos por horas extras
                    $datos_array_inn = (trim($datos_ingreso[$i]) != '')? ((array) json_decode($datos_ingreso[$i])):null;
                    if (is_array($datos_array_inn)) {
                        $auditoria_inn = array(
                            'dss_id_hxe' => $id,
                            'dss_estado' => 1,
                            'dss_fecha_crea' => date("Y-m-d H:i:s"),
                            'dss_usu_crea' => $this->tank_auth->get_user_id(),
                            'dss_fecha_mod' => date("Y-m-d H:i:s"),
                            'dss_usu_mod' => $this->tank_auth->get_user_id()
                        );

                        $array_insert_inn =     array_merge($datos_array_inn, $auditoria_inn);
                        $id = $this->gsatelite->ingresar('dss_descuento',$array_insert_inn);
                    }
                    $exito++;
                }
            }

            $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Carga de horas no trabajadas", 'texto_alerta' => "La operación a sido realizada con éxito ($exito registros procesados)");
            $this->session->set_flashdata($alerta);
            redirect('acciones_personal/principal/horas_notrabajadas_masivas');


        } else {
            redirect('acciones_personal/principal/horas_notrabajadas_masivas');
        }
    }

    
    /**
      * @author René Castaneda
      * @since 24-08-2018
      * @return Gestión de liquidación realizada a empleado
      */
    public function gestion_liquidacion_emp($id_retiro = null) {
        satelite_validar();
        $id_retiro = ($this->input->post()) ? $this->input->post('id_retiro') : $id_retiro;
        $info = $this->accion_personal_model->get_info_empleado_liquidacion(array('rte_id' => $id_retiro));
        // var_dump($this->db->last_query());die();
        $configuracion_liquidacion = json_decode($this->gsatelite->get_parametro('SYS_CONFIGURACION_LIQUIDACION'));
        // OBJ ["ID_TIPO_PLANILLA_LIQ"]=>  string(1) "4"  ["NUMERO_MESES_SALARIO_PROMEDIO"]=>  string(1) "6"  ["ID_AGRUPADOR_INDEMNIZACION"]=>  string(2) "11"
        $registro_tipo_pla = $this->gsatelite->get_tabla('tpl_tipo_planilla',array('tpl_id' => $configuracion_liquidacion->ID_TIPO_PLANILLA_LIQ));
        // var_dump($registro_tipo_pla);die();

                          $this->db->join('pla_planilla', 'pla_id_tpl = tpl_id', 'left');
        $existe_tpl_liq = $this->gsatelite->get_tabla('tpl_tipo_planilla', array('tpl_tipo_liquidacion' => 1, 'tpl_estado' => 1));
        if (!($configuracion_liquidacion->ID_TIPO_PLANILLA_LIQ != "" && count($registro_tipo_pla) > 0)){
            if (count($existe_tpl_liq) > 0) {                
                $this->gsatelite->show_dialog('Favor revisar configuración de planillas', 'acciones_personal/principal/calculo_liquidacion', 'error', 'Error configuración');
            }
        }
        if ($_POST) {
            // var_dump($_POST);die();
            $id_planilla_liq = null;
            $procesar = ($this->input->post('do_nothing') != null) ? false : true;/// si viene el donothig es false sino es true
            $emp_id = $this->input->post('id_empleado_liquidacion');
            //BUSCAR ingresos anteriores
            $where_inn_old = array('ddi_id_emp' => $emp_id, 'inn_id_lqe' => $info[0]['lqe_id']);
            if ($info[0]['pla_id'] != "") {
                $where_inn_old['ddi_id_pla'] = $info[0]['pla_id'];
            }
                        $this->db->join('inn_ingreso', 'inn_id = ddi_id_inn', 'left');
            $ingresos = $this->gsatelite->get_tabla('ddi_detalle_ingreso', $where_inn_old);
            //BUSCAR descuentos anteriores
            $where_dss_old = array('ddd_id_emp' => $emp_id, 'dss_id_lqe' => $info[0]['lqe_id']);
            if ($info[0]['pla_id'] != "") {
                $where_dss_old['ddd_id_pla'] = $info[0]['pla_id'];
            }            
                        $this->db->join('dss_descuento', 'dss_id = ddd_id_dss', 'left');
            $descuent = $this->gsatelite->get_tabla('ddd_detalle_descuento', $where_dss_old);
            $ingresos_liq_id = $this->input->post('ingresos_liq_id');
            $ingresos_liq_monto = $this->input->post('ingresos_liq_monto');
            $ingresos_liq_porcent = $this->input->post('ingresos_liq_porcent');
            $descuento_liq_id = $this->input->post('descuento_liq_id');
            $descuento_liq_monto = $this->input->post('descuento_liq_monto');
            $descuento_liq_porcent = $this->input->post('descuento_liq_porcent');
            $observaciones = $this->input->post('observaciones');
            $id_planilla_liq = ($info[0]['lqe_id_pla'] > 0) ? $info[0]['lqe_id_pla'] : null;
            if ($this->input->post('pla_pagar') != $info[0]['lqe_id_pla']) {
                $estado_actual = $this->gsatelite->get_campo('pla_planilla', 'pla_estado', array('pla_id' => $info[0]['lqe_id_pla']));
                if ($estado_actual > 2) {
                    $this->gsatelite->show_dialog('No se pueden editar los registros', 'acciones_personal/principal/calculo_liquidacion', 'error', 'Planilla Autorizada');
                }
                $id_planilla_liq = $this->input->post('pla_pagar');
                $misma_pla = false;
            } else {
                $id_planilla_liq = $info[0]['lqe_id_pla'];
                $misma_pla = true;
            }
            $fec_ini_pla = ($this->input->post('inicio_pla') != "") ? $this->input->post('inicio_pla') : null;
            $fec_fin_pla = ($this->input->post('fin_pla') != "") ? $this->input->post('fin_pla') : null;
            $liq_array = array(
                'lqe_id_rte' => $id_retiro,
                'lqe_id_pla' => $id_planilla_liq,
                'lqe_fecha_desde' => ($procesar) ? $fec_ini_pla : $info[0]['pla_fecha_inicio'],
                'lqe_fecha_hasta' => ($procesar) ? $fec_fin_pla : $info[0]['pla_fecha_fin'],
                'lqe_total_ingreso' => ($procesar) ? $this->input->post('total_ingreso') : $info[0]['lqe_total_ingreso'],
                'lqe_total_descuento' => ($procesar) ? $this->input->post('total_descuento') : $info[0]['lqe_total_descuento'] ,
                'lqe_total_pagar' => ($procesar) ? $this->input->post('total_pagar') : $info[0]['lqe_total_pagar'] ,
                'lqe_observaciones' => $this->input->post('observaciones'),
                'lqe_estado'        => 1,
                'lqe_usu_creacion'  => $this->tank_auth->get_user_id(),
                'lqe_fecha_creacion'=> date('Y-m-d H:i:s'),
                'lqe_usu_modificacion' => $this->tank_auth->get_user_id(),
                'lqe_fecha_modificacion' => date('Y-m-d H:i:s')
            );
            if ($info[0]['lqe_id'] > 0) {
                unset($liq_array['lqe_usu_creacion']); //omitir la auditoria
                unset($liq_array['lqe_fecha_creacion']); //omitir la auditoria
                $lqe_id = $info[0]['lqe_id'];
                $this->gsatelite->actualizar_array('lqe_liquidacion_empleado', $liq_array, array('lqe_id' => $lqe_id));
            } else {
                $lqe_id = $this->gsatelite->ingresar('lqe_liquidacion_empleado', $liq_array);
            }
            if ($procesar) {
                if ($info[0]['lqe_id'] > 0) {
                    //BORRAR DDI & DDD ANTERIORES
                    foreach ($ingresos as $key => $value) {
                        if ($value['inn_id'] != "") {
                            $this->gsatelite->borrado_general('ddi_detalle_ingreso', array('ddi_id_inn' => $value['inn_id']));
                        }
                        $this->gsatelite->borrado_general('inn_ingreso', array('inn_id_lqe' => $lqe_id, 'inn_id' => $value['inn_id']));
                    }
                    foreach ($descuent as $key => $value) {
                        if ($value['dss_id'] != "") {
                            $this->gsatelite->borrado_general('ddd_detalle_descuento', array('ddd_id_dss' => $value['dss_id']));
                        }
                        $this->gsatelite->borrado_general('dss_descuento', array('dss_id_lqe' => $lqe_id, 'dss_id' => $value['dss_id']));
                    }
                }
                $inn_id = $ddi_id = $dss_id = $ddd_id = array();
                foreach ($ingresos_liq_id as $k => $val) {
                    $array_insert_ingresos = array(
                        'inn_id_tig' => $val,
                        'inn_id_emp' => $emp_id,
                        'inn_id_lqe' => $lqe_id,
                        'inn_motivo' => 'Liquidación Empleada/o',
                        'inn_valor' => $ingresos_liq_monto[$k],
                        'inn_fecha_desde' => formatear_fecha('Y-m-d', $this->input->post('txtFretiro')),
                        'inn_cuota' => 1,
                        'inn_cuota_pagada' => 0,
                        'inn_id_tpl' => ($registro_tipo_pla[0]['tpl_id'] > 0) ? $registro_tipo_pla[0]['tpl_id'] : null,
                        'inn_observacion' => $observaciones,
                        'inn_permanente' => 0,
                        'inn_estado' => 1,
                        'inn_usu_crea' => $this->tank_auth->get_user_id(),
                        'inn_fecha_crea' => date('Y-m-d H:i:s'),
                        'inn_usu_mod' => $this->tank_auth->get_user_id(),
                        'inn_fecha_mod' => date('Y-m-d H:i:s')
                    );
                    $inn_id[] = $id_inn = $this->gsatelite->ingresar('inn_ingreso', $array_insert_ingresos);
                    $array_insert_detalles = array(
                        'ddi_id_inn' => $id_inn,
                        'ddi_id_pla' => ($id_planilla_liq > 0) ? $id_planilla_liq : null,
                        'ddi_id_emp' => $emp_id,
                        'ddi_id_tig' => $val,
                        'ddi_valor' => $ingresos_liq_monto[$k],
                        'ddi_observacion' => ($ingresos_liq_porcent[$k] < 100) ? ($ingresos_liq_porcent[$k].'%') : null, //guardar si el porcentaje es difernete de 100%
                        'ddi_usu_mod'   => $this->tank_auth->get_user_id(),
                        'ddi_fecha_mod' => date('Y-m-d H:i:s')
                    );
                    $ddi_id[] = $this->gsatelite->ingresar('ddi_detalle_ingreso', $array_insert_detalles);                    
                }
                foreach ($descuento_liq_id as $j => $val) {
                    $array_insert_descuento = array(
                        'dss_id_emp' => $emp_id,
                        'dss_id_tpl' => ($registro_tipo_pla[0]['tpl_id'] > 0) ? $registro_tipo_pla[0]['tpl_id'] : null,                        
                        'dss_id_tdc' => $val,
                        'dss_id_lqe' => $lqe_id,
                        'dss_motivo' => 'Liquidación Empleada/o',
                        'dss_observacion' => $observaciones,
                        'dss_valor' => $descuento_liq_monto[$j],
                        'dss_permanente' => 0,
                        'dss_fecha' => date('Y-m-d H:i:s'),
                        'dss_fecha_desde' => formatear_fecha('Y-m-d', $this->input->post('txtFretiro')),
                        'dss_cuota' => 1,
                        'dss_cuota_pagada' => 0,
                        'dss_estado' => 1,
                        'dss_usu_crea' => $this->tank_auth->get_user_id(),
                        'dss_fecha_crea' => date('Y-m-d H:i:s'),
                        'dss_usu_mod' => $this->tank_auth->get_user_id(),
                        'dss_fecha_mod' => date('Y-m-d H:i:s')
                    );
                    $dss_id[] = $id_dss = $this->gsatelite->ingresar('dss_descuento', $array_insert_descuento);
                    $array_insert_det_desc = array(
                        'ddd_id_dss' => $id_dss, 
                        'ddd_observaciones' => $observaciones,
                        'ddd_id_pla'    => $id_planilla_liq,
                        'ddd_id_emp'    => $emp_id,
                        'ddd_id_tdc'    => $val,
                        'ddd_valor'     => $descuento_liq_monto[$j],
                        'ddd_usu_mod'   => $this->tank_auth->get_user_id(),
                        'ddd_fecha_mod' => date('Y-m-d H:i:s')
                    );
                    $ddd_id[] = $this->gsatelite->ingresar('ddd_detalle_descuento', $array_insert_det_desc);
                }
            } else {                
                foreach ($ingresos as $key => $value) {
                    $this->gsatelite->actualizar_array('inn_ingreso', array('inn_observacion' => $observaciones), array('inn_id' => $value['inn_id']));
                }
                foreach ($descuent as $key => $value) {
                    $this->gsatelite->actualizar_array('dss_descuento', array('dss_observacion' => $observaciones), array('dss_id' => $value['dss_id']));
                }
            }
            if ($lqe_id) {
                $this->gsatelite->show_dialog('Se agregaron los registros a la planilla.', 'acciones_personal/principal/calculo_liquidacion', 'success', 'Liquidación realizada con éxito.');
            } else {
                $this->gsatelite->show_dialog('Error', 'acciones_personal/principal/calculo_liquidacion', 'error', 'Error al generar la liquidación, favor intentar nuevamente');
            }            
        } else {
            $periodo_planilla = "";            
                        $this->db->order_by('pla_fecha_inicio', 'DESC');
            $reg_plan = $this->gsatelite->get_tabla('pla_planilla',array('pla_id_tpl' => $configuracion_liquidacion->ID_TIPO_PLANILLA_LIQ, 'pla_estado > ' => 0, 'pla_estado < ' => 3));
            foreach ($reg_plan as $key => $val) {
                $sltd = ($val['pla_id'] == $info[0]['pla_id']) ? "selected" : "";
                $stat = ($val['pla_estado'] > 1) ? "Generada" : "Creada";
                $periodo_planilla .= '<option value="'.$val['pla_id'].'" '.$sltd.' data-cod="'.$val['pla_codigo'].'" data-ini="'.$val['pla_fecha_inicio'].'" data-fin="'.$val['pla_fecha_fin'].'">';
                $periodo_planilla .= formatear_fecha('d-m-Y', $val['pla_fecha_inicio']).' -- '.formatear_fecha('d-m-Y', $val['pla_fecha_fin']) . ' ' . $stat.'</option>';
            }
            $configuracion_aguinaldo = $this->gsatelite->get_parametro('SYS_CONFIGURACION_AGUINALDO'); 
            $configuracion_aguinaldo = (array) json_decode($configuracion_aguinaldo);
            $dias_anio_aguinaldo = (trim($configuracion_aguinaldo['DIAS_ANIO_AGUINALDO']) > 0 ) ? $configuracion_aguinaldo['DIAS_ANIO_AGUINALDO'] : 365;
            $aguinaldo_fecha_corte = (trim($info[0]['emp_fecha_ult_aguinaldo']) != '') ? $info[0]['emp_fecha_ult_aguinaldo'] : $info[0]['emp_fecha_contrato'];
            $rte_fecha_retiro = ($info[0]['rte_fecha_retiro'] != "") ? formatear_fecha('Y-m-d', $info[0]['rte_fecha_retiro']) : date('Y-m-d');
            $emp_fecha_retiro = (trim($info[0]['emp_fecha_retiro']) != '') ? $info[0]['emp_fecha_retiro'] : $rte_fecha_retiro;
            $aguinaldo_fecha_corte = formatear_fecha('Y-m-d',$aguinaldo_fecha_corte);
            $n_dias_ = $this->gsatelite->get_intervalo_dias($aguinaldo_fecha_corte, $emp_fecha_retiro);   
            $n_dias_ = $n_dias_ + 1;
            $dias_aguinaldo = ($n_dias_ >= $dias_anio_aguinaldo) ? $dias_anio_aguinaldo : $n_dias_; 
            if ($info[0]['lqe_id'] != "") {
                $where_inn = array('ddi_id_emp' => $info[0]['emp_id'], 'inn_id_lqe' => $info[0]['lqe_id']);
                if ($info[0]['pla_id'] != "") {
                    $where_inn['ddi_id_pla'] = $info[0]['pla_id'];
                }
                                     $this->db->join('inn_ingreso', 'inn_id = ddi_id_inn', 'left');
                                     $this->db->join('tig_tipo_ingreso', 'tig_id = ddi_id_tig');
                $data['inngresos'] = $this->gsatelite->get_tabla('ddi_detalle_ingreso', $where_inn); 

                $where_dss = array('ddd_id_emp' => $info[0]['emp_id'], 'dss_id_lqe' => $info[0]['lqe_id']);
                if ($info[0]['pla_id'] != "") {
                    $where_dss['ddd_id_pla'] = $info[0]['pla_id'];
                }
                                     $this->db->join('dss_descuento', 'dss_id = ddd_id_dss', 'left');
                                     $this->db->join('tdc_tipo_descuento', 'tdc_id = ddd_id_tdc');
                $data['dsscuento'] = $this->gsatelite->get_tabla('ddd_detalle_descuento', $where_dss); 
            } else {
                $data['inngresos'] = array(); 
                $data['dsscuento'] = array(); 
            }            
            $data['info'] = $info; 
            $data['pedir_plan'] = (count($reg_plan) > 0 && count($existe_tpl_liq) > 0) ? 1 : 0;
            $data['id_tipo_planilla'] = ($registro_tipo_pla[0]['tpl_id'] > 0)? $registro_tipo_pla[0]['tpl_id']:0;
            $data['codigo_pla'] = "LIQ-".$info[0]['emp_codigo']."-".(formatear_fecha('dmY',$periodo_planilla_ini))."_".(formatear_fecha('dmY',$periodo_planilla_fin));
            $data['inicio_pla'] = formatear_fecha('Y-m-d',$periodo_planilla_ini);
            $data['fin_pla'] = formatear_fecha('Y-m-d',$periodo_planilla_fin);
            $data['configuracion'] = $configuracion_liquidacion;
            $data['tipo_planilla_conf'] = $registro_tipo_pla[0]['tpl_nombre'];
            $data['periodo_planilla'] = $periodo_planilla;
            $data['dias_aguinaldo'] = $dias_aguinaldo;
            $data["titulo_personal"] = "Procesar cálculo de liquidación";
            $this->_cargarvista($data, null);
        }
    }

    public function indemnizacion_individual($id_emp = null) {
        satelite_validar();
        $configuracion = json_decode($this->gsatelite->get_parametro('SYS_CONFIGURACION_INDEMNIZACION_VOLUNTARIA'));
        if (is_null($configuracion)) {
            $this->gsatelite->show_dialog('No se encontró el parámetro requerido', 'acciones_personal/principal/calculo_indemnizacion', 'error', 'Error de configuración');
        }
        $tipo_planilla_indem = ($configuracion->ID_TIPO_PLANILLA_INDEMNIZACION > 0) ? $configuracion->ID_TIPO_PLANILLA_INDEMNIZACION : 0;

                             $this->db->join('pla_planilla', 'pla_id_tpl = tpl_id', 'left');
        $registro_tipo_pla = $this->gsatelite->get_tabla('tpl_tipo_planilla',array('tpl_id' => $tipo_planilla_indem));
        if (!($tipo_planilla_indem > 0 && count($registro_tipo_pla) > 0)){
            $this->gsatelite->show_dialog('Favor revisar la configuración de planillas', 'acciones_personal/principal/calculo_indemnizacion', 'error', 'Error de configuración');
        }
        $info_emp = $this->accion_personal_model->get_info_empleado_indem(array('emp_id' => $id_emp));
        if ($_POST) {
            // var_dump($_POST);die();
            $id_planilla_liq = null;
            $procesar = ($this->input->post('do_nothing') != null) ? false : true;/// si viene el donothig es false sino es true
            $emp_id = $this->input->post('id_empleado');
            //BUSCAR ingresos anteriores
            $where_inn_old = array('ddi_id_emp' => $emp_id, 'inn_id_tpl' => $tipo_planilla_indem, 'inn_id_lqe' => $info_emp[0]['lqe_id']);
            if ($info_emp[0]['pla_id'] != "") {
                $where_inn_old['ddi_id_pla'] = $info_emp[0]['pla_id'];
            }
                        $this->db->join('inn_ingreso', 'inn_id = ddi_id_inn', 'left');
            $ingresos = $this->gsatelite->get_tabla('ddi_detalle_ingreso', $where_inn_old);

            //BUSCAR descuentos anteriores
            $where_dss_old = array('ddd_id_emp' => $emp_id, 'dss_id_tpl' => $tipo_planilla_indem, 'dss_id_lqe' => $info_emp[0]['lqe_id']);
            if ($info_emp[0]['pla_id'] != "") {
                $where_dss_old['ddd_id_pla'] = $info_emp[0]['pla_id'];
            }            
                        $this->db->join('dss_descuento', 'dss_id = ddd_id_dss', 'left');
            $descuent = $this->gsatelite->get_tabla('ddd_detalle_descuento', $where_dss_old);

            $ingresos_liq_id = $this->input->post('ingresos_liq_id');
            $ingresos_liq_monto = $this->input->post('ingresos_liq_monto');
            $ingresos_liq_porcent = $this->input->post('ingresos_liq_porcent');
            $descuento_liq_id = $this->input->post('descuento_liq_id');
            $descuento_liq_monto = $this->input->post('descuento_liq_monto');
            $descuento_liq_porcent = $this->input->post('descuento_liq_porcent');
            $observaciones = $this->input->post('observaciones');
            $id_planilla_liq = ($info_emp[0]['lqe_id_pla'] > 0) ? $info_emp[0]['lqe_id_pla'] : null;
            if ($this->input->post('pla_pagar') != $info_emp[0]['lqe_id_pla']) {
                $estado_actual = $this->gsatelite->get_campo('pla_planilla', 'pla_estado', array('pla_id' => $info_emp[0]['lqe_id_pla']));
                if ($estado_actual > 2) {
                    $this->gsatelite->show_dialog('No se pueden editar los registros', 'acciones_personal/principal/calculo_liquidacion', 'error', 'Planilla Autorizada');
                }
                $id_planilla_liq = $this->input->post('pla_pagar');
                $misma_pla = false;
            } else {
                $id_planilla_liq = $info_emp[0]['lqe_id_pla'];
                $misma_pla = true;
            }
            $fec_ini_pla = ($this->input->post('inicio_pla') != "") ? $this->input->post('inicio_pla') : null;
            $fec_fin_pla = ($this->input->post('fin_pla') != "") ? $this->input->post('fin_pla') : null;
            $fecha_calculo = formatear_fecha('Y-m-d', $this->input->post('txt_calculo_hasta'));
            $in_volunt = array(
                'inv_id_emp' => $emp_id,
                'inv_fecha_calculo' => ($procesar) ? $fecha_calculo : $info_emp[0]['inv_fecha_calculo'],
                'inv_observacion' => $observaciones, 
                'inv_estado' => ($procesar) ? 1 : $info_emp[0]['inv_estado'], 
                'inv_usu_modificacion' => $this->tank_auth->get_user_id(),
                'inv_fecha_modificacion' => date('Y-m-d H:i:s')
            );
            if ($info_emp[0]['inv_id'] > 0) {
                $inv_id = $info_emp[0]['inv_id'];
                $this->gsatelite->actualizar_array('inv_indemnizacion_voluntaria', $in_volunt, array('inv_id' => $inv_id));
            } else {
                $in_volunt['inv_usu_creacion'] = $this->tank_auth->get_user_id();
                $in_volunt['inv_fecha_creacion'] = date('Y-m-d H:i:s');
                $inv_id = $this->gsatelite->ingresar('inv_indemnizacion_voluntaria', $in_volunt);
            }
            $finipla = ($misma_pla) ? $info_emp[0]['pla_fecha_inicio'] : $fec_ini_pla;
            $ffinpla = ($misma_pla) ? $info_emp[0]['pla_fecha_fin'] : $fec_ini_pla;
            $liq_array = array(
                'lqe_id_inv' => $inv_id,
                'lqe_id_pla' => $id_planilla_liq,
                'lqe_fecha_desde' => ($procesar) ? $fec_ini_pla : $finipla,
                'lqe_fecha_hasta' => ($procesar) ? $fec_fin_pla : $ffinpla,
                'lqe_total_ingreso' => ($procesar) ? $this->input->post('total_ingreso') : $info_emp[0]['lqe_total_ingreso'],
                'lqe_total_descuento' => ($procesar) ? $this->input->post('total_descuento') : $info_emp[0]['lqe_total_descuento'] ,
                'lqe_total_pagar' => ($procesar) ? $this->input->post('total_pagar') : $info_emp[0]['lqe_total_pagar'] ,
                'lqe_observaciones' => $observaciones,
                'lqe_estado'        => 1,
                'lqe_usu_creacion'  => $this->tank_auth->get_user_id(),
                'lqe_fecha_creacion'=> date('Y-m-d H:i:s'),
                'lqe_usu_modificacion' => $this->tank_auth->get_user_id(),
                'lqe_fecha_modificacion' => date('Y-m-d H:i:s')
            );
            if ($info_emp[0]['lqe_id'] > 0) {
                unset($liq_array['lqe_usu_creacion']); //omitir la auditoria
                unset($liq_array['lqe_fecha_creacion']); //omitir la auditoria
                $lqe_id = $info_emp[0]['lqe_id'];
                $this->gsatelite->actualizar_array('lqe_liquidacion_empleado', $liq_array, array('lqe_id' => $lqe_id));
            } else {
                $lqe_id = $this->gsatelite->ingresar('lqe_liquidacion_empleado', $liq_array);
            }
            if ($procesar) {
                if ($info_emp[0]['lqe_id'] > 0) {
                    //BORRAR DDI & DDD ANTERIORES
                    foreach ($ingresos as $key => $value) {
                        if ($value['inn_id'] != "") {
                            $this->gsatelite->borrado_general('ddi_detalle_ingreso', array('ddi_id_inn' => $value['inn_id']));
                        }
                        $this->gsatelite->borrado_general('inn_ingreso', array('inn_id_lqe' => $lqe_id, 'inn_id' => $value['inn_id']));
                    }
                    foreach ($descuent as $key => $value) {
                        if ($value['dss_id'] != "") {
                            $this->gsatelite->borrado_general('ddd_detalle_descuento', array('ddd_id_dss' => $value['dss_id']));
                        }
                        $this->gsatelite->borrado_general('dss_descuento', array('dss_id_lqe' => $lqe_id, 'dss_id' => $value['dss_id']));
                    }
                }
                $inn_id = $ddi_id = $dss_id = $ddd_id = array();
                foreach ($ingresos_liq_id as $k => $val) {
                    $array_insert_ingresos = array(
                        'inn_id_tig' => $val,
                        'inn_id_emp' => $emp_id,
                        'inn_id_lqe' => $lqe_id,
                        'inn_motivo' => 'Indemnización de Empleada/o',
                        'inn_valor' => $ingresos_liq_monto[$k],
                        'inn_fecha_desde' => $fecha_calculo,
                        'inn_cuota' => 1,
                        'inn_cuota_pagada' => 0,
                        'inn_id_tpl' => ($registro_tipo_pla[0]['tpl_id'] > 0) ? $registro_tipo_pla[0]['tpl_id'] : null,
                        'inn_observacion' => $observaciones,
                        'inn_permanente' => 0,
                        'inn_estado' => 1,
                        'inn_usu_crea' => $this->tank_auth->get_user_id(),
                        'inn_fecha_crea' => date('Y-m-d H:i:s'),
                        'inn_usu_mod' => $this->tank_auth->get_user_id(),
                        'inn_fecha_mod' => date('Y-m-d H:i:s')
                    );
                    $inn_id[] = $id_inn = $this->gsatelite->ingresar('inn_ingreso', $array_insert_ingresos);
                    $array_insert_detalles = array(
                        'ddi_id_inn' => $id_inn,
                        'ddi_id_pla' => ($id_planilla_liq > 0) ? $id_planilla_liq : null,
                        'ddi_id_emp' => $emp_id,
                        'ddi_id_tig' => $val,
                        'ddi_valor' => $ingresos_liq_monto[$k],
                        'ddi_observacion' => ($ingresos_liq_porcent[$k] < 100) ? ($ingresos_liq_porcent[$k].'%') : null, //guardar si el porcentaje es difernete de 100%
                        'ddi_usu_mod'   => $this->tank_auth->get_user_id(),
                        'ddi_fecha_mod' => date('Y-m-d H:i:s')
                    );
                    $ddi_id[] = $this->gsatelite->ingresar('ddi_detalle_ingreso', $array_insert_detalles);                    
                }
                foreach ($descuento_liq_id as $j => $val) {
                    $array_insert_descuento = array(
                        'dss_id_tdc' => $val,
                        'dss_id_emp' => $emp_id,
                        'dss_id_lqe' => $lqe_id,
                        'dss_motivo' => 'Indemnización de Empleada/o',
                        'dss_id_tpl' => ($registro_tipo_pla[0]['tpl_id'] > 0) ? $registro_tipo_pla[0]['tpl_id'] : null,                        
                        'dss_observacion' => $observaciones,
                        'dss_valor' => $descuento_liq_monto[$j],
                        'dss_permanente' => 0,
                        'dss_fecha' => date('Y-m-d H:i:s'),
                        'dss_fecha_desde' => $fecha_calculo,
                        'dss_cuota' => 1,
                        'dss_cuota_pagada' => 0,
                        'dss_estado' => 1,
                        'dss_usu_crea' => $this->tank_auth->get_user_id(),
                        'dss_fecha_crea' => date('Y-m-d H:i:s'),
                        'dss_usu_mod' => $this->tank_auth->get_user_id(),
                        'dss_fecha_mod' => date('Y-m-d H:i:s')
                    );
                    $dss_id[] = $id_dss = $this->gsatelite->ingresar('dss_descuento', $array_insert_descuento);
                    $array_insert_det_desc = array(
                        'ddd_id_dss' => $id_dss, 
                        'ddd_observaciones' => $observaciones,
                        'ddd_id_pla'    => $id_planilla_liq,
                        'ddd_id_emp'    => $emp_id,
                        'ddd_id_tdc'    => $val,
                        'ddd_valor'     => $descuento_liq_monto[$j],
                        'ddd_usu_mod'   => $this->tank_auth->get_user_id(),
                        'ddd_fecha_mod' => date('Y-m-d H:i:s')
                    );
                    $ddd_id[] = $this->gsatelite->ingresar('ddd_detalle_descuento', $array_insert_det_desc);
                }
            } else {
                foreach ($ingresos as $key => $value) {
                    $inn_upd = array('inn_observacion' => $observaciones, 'inn_usu_mod' => $this->tank_auth->get_user_id(), 'inn_fecha_mod' => date('Y-m-d H:i:s'));
                    $ddi_upt = array('ddi_id_pla' => $id_planilla_liq, 'ddi_usu_mod' => $this->tank_auth->get_user_id(), 'ddi_fecha_mod' => date('Y-m-d H:i:s'));
                    $this->gsatelite->actualizar_array('inn_ingreso', $inn_upd, array('inn_id' => $value['inn_id']));
                    $this->gsatelite->actualizar_array('ddi_detalle_ingreso', $ddi_upt, array('ddi_id' => $value['ddi_id']));
                }
                foreach ($descuent as $key => $value) {
                    $dss_upd = array('dss_observacion' => $observaciones, 'dss_usu_mod' => $this->tank_auth->get_user_id(), 'dss_fecha_mod' => date('Y-m-d H:i:s'));
                    $ddd_upt = array('ddd_id_pla' => $id_planilla_liq, 'ddd_usu_mod' => $this->tank_auth->get_user_id(), 'ddd_fecha_mod' => date('Y-m-d H:i:s'));
                    $this->gsatelite->actualizar_array('dss_descuento', $dss_upd, array('dss_id' => $value['dss_id']));
                    $this->gsatelite->actualizar_array('ddd_detalle_descuento', $ddd_upt, array('ddd_id' => $value['ddd_id']));
                }
            }
            if (is_null($lqe_id) || is_null($inv_id)) {
                $this->gsatelite->show_dialog('Error', 'acciones_personal/principal/calculo_indemnizacion', 'error', 'Error al generar la liquidación, favor intentar nuevamente');
            } else {
                $this->gsatelite->show_dialog('Se agregaron los registros a la planilla.', 'acciones_personal/principal/calculo_indemnizacion', 'success', 'Liquidación realizada con éxito.');
            }            
        } else {
            $periodo_planilla = "";
                        $this->db->order_by('pla_fecha_inicio', 'DESC');
            $reg_plan = $this->gsatelite->get_tabla('pla_planilla',array('pla_id_tpl' => $tipo_planilla_indem, 'pla_estado > ' => 0, 'pla_estado < ' => 3));
            foreach ($reg_plan as $key => $v) {
                $sltd = ($v['pla_id'] == $info_emp[0]['pla_id']) ? "selected" : "";
                $stat = ($v['pla_estado'] > 1) ? "Generada" : "Creada";
                $periodo_planilla .= '<option value="'.$v['pla_id'].'" '.$sltd.' data-cod="'.$v['pla_codigo'].'" data-ini="'.$v['pla_fecha_inicio'].'" data-fin="'.$v['pla_fecha_fin'].'">';
                $periodo_planilla .= formatear_fecha('d-m-Y', $v['pla_fecha_inicio']).' -- '.formatear_fecha('d-m-Y', $v['pla_fecha_fin']) . ' ' . $stat.'</option>';
            }
            if ($info_emp[0]['lqe_id'] != "") {
                $where_inn = array('ddi_id_emp' => $info_emp[0]['emp_id'], 'inn_id_lqe' => $info_emp[0]['lqe_id']);
                if ($info_emp[0]['pla_id'] != "") {
                    $where_inn['ddi_id_pla'] = $info_emp[0]['pla_id'];
                }
                                     $this->db->join('inn_ingreso', 'inn_id = ddi_id_inn', 'left');
                                     $this->db->join('tig_tipo_ingreso', 'tig_id = ddi_id_tig');
                $data['inngresos'] = $this->gsatelite->get_tabla('ddi_detalle_ingreso', $where_inn); 

                $where_dss = array('ddd_id_emp' => $info_emp[0]['emp_id'], 'dss_id_lqe' => $info_emp[0]['lqe_id']);
                if ($info_emp[0]['pla_id'] != "") {
                    $where_dss['ddd_id_pla'] = $info_emp[0]['pla_id'];
                }
                                     $this->db->join('dss_descuento', 'dss_id = ddd_id_dss', 'left');
                                     $this->db->join('tdc_tipo_descuento', 'tdc_id = ddd_id_tdc');
                $data['dsscuento'] = $this->gsatelite->get_tabla('ddd_detalle_descuento', $where_dss); 
            } else {
                $data['inngresos'] = array(); 
                $data['dsscuento'] = array(); 
            }
            $data['info'] = $info_emp[0]; 
            $data['id_tipo_planilla'] = $registro_tipo_pla[0]['tpl_id'];
            $data['configuracion'] = $configuracion;
            $data['periodo_planilla'] = $periodo_planilla;
            $data["titulo_personal"] = "Procesar Cálculo de Indemnización";
            $this->_cargarvista($data, null);
        }
    }

    public function anular_permiso($hxe_id, $emp_id, $autogestion = 0, $por_jefe = 0){
        satelite_validar();
                $this->db->join('dss_descuento', 'dss_id_hxe = hxe_id', 'LEFT');
        $reg =  $this->gsatelite->get_tabla('hxe_hora_extraxempleado', array('hxe_id_emp' => $emp_id, 'hxe_id' => $hxe_id));
        if ($reg[0]['hxe_id_pla'] != "") {
            $plan = $this->gsatelite->get_campo('pla_planilla', 'pla_estado', array('pla_id' => $reg[0]['hxe_id_pla']));
            if ($plan > 2) {
                if ($autogestion > 0) {
                    $this->gsatelite->show_dialog("No se puede eliminar el registro.", "auto_gestion/acciones/lista_permisos_empleado/$emp_id", "error", "Planilla Ya Autorizada");
                } else {
                    $this->gsatelite->show_dialog("No se puede eliminar el registro.", "acciones_personal/principal/gestion_horas_notrabajadas/$emp_id", "error", "Planilla Ya Autorizada");
                }
            }
        }
        if ($reg[0]['dss_id'] != "") {
            $con_detalle = $this->gsatelite->get_tabla('ddd_detalle_descuento',array('ddd_id_dss' => $reg[0]['dss_id']));
            if (count($con_detalle) > 0) {
                $this->gsatelite->borrado_general('ddd_detalle_descuento', array('ddd_id_dss' => $reg[0]['dss_id']));
            }
            $this->gsatelite->borrado_general('dss_descuento', array('dss_id' => $reg[0]['dss_id']));
        }
        $anexos = $this->gsatelite->get_tabla('anh_anexo_hora_extra_empleado', array('anh_id_hxe' => $hxe_id));
        if (count($anexos) > 0) {
            foreach ($anexos as $k => $value) {
                unlink($value['anh_url']);
            }
            $this->gsatelite->borrado_general('anh_anexo_hora_extra_empleado', array('anh_id_hxe' => $hxe_id));
        }
        $uso_horas = $this->gsatelite->get_tabla('uhp_uso_horas_permisos', array('uhp_id_hxe' => $hxe_id));
        if (count($uso_horas) > 0) {
            $this->gsatelite->borrado_general('uhp_uso_horas_permisos', array('uhp_id_hxe' => $hxe_id));
        }
        $this->gsatelite->borrado_general('hxe_hora_extraxempleado', array('hxe_id' => $hxe_id));
        if ($autogestion > 0) {
            if ($por_jefe > 0) {
                $this->gsatelite->show_dialog("Proceso realizado con éxito", "auto_gestion/acciones/lista_permiso_colaborador/$emp_id");
            } else {
                $this->gsatelite->show_dialog("Proceso realizado con éxito", "auto_gestion/acciones/lista_permisos_empleado/$emp_id");
            }
        } else {
            $this->gsatelite->show_dialog("Proceso realizado con éxito", "acciones_personal/principal/gestion_horas_notrabajadas/$emp_id");
        }
    }

    public function anular_compensatorio($tce_id, $autogestion = 0){
        satelite_validar();
        $reg =  $this->gsatelite->get_registro("tce_tiempo_compensatorio_empleado", array('tce_id' => $tce_id));
        $emp_id = $reg->tce_id_emp;
        if ($reg->tce_estado == 2) {
            $this->gsatelite->show_dialog("No se puede eliminar un registro autorizado.", "auto_gestion/acciones/tiempo_compensatorio/$emp_id", "error", "Registro Autorizado");
        }
        $anexos = $this->gsatelite->get_tabla('anc_anexo_tiempo_compensar_emp', array('anc_id_tce' => $tce_id));
        if (count($anexos) > 0) {
            foreach ($anexos as $k => $value) {
                unlink($value['anc_url']);
            }
            $this->gsatelite->borrado_general('anc_anexo_tiempo_compensar_emp', array('anc_id_tce' => $tce_id));
        }        
        $this->gsatelite->borrado_general('tce_tiempo_compensatorio_empleado', array('tce_id' => $tce_id));
        if ($autogestion > 0) {
            $this->gsatelite->show_dialog("Proceso realizado con éxito", "auto_gestion/acciones/tiempo_compensatorio/$emp_id");
        } else {
        //     $this->gsatelite->show_dialog("Proceso realizado con éxito", "acciones_personal/principal/tiempo_compensatorio/$emp_id");
        }
    }

    /**
      * @author Raul E
      * @since jun/2021
      * @return Imprime copia del permiso en PDF
      */
    public function print_permiso($id_permiso){
        satelite_validar();
        $this->verifica_registro_real('hxe_hora_extraxempleado', $id_permiso);
        $this->load->library('Pdf');
        $empresa = strtolower(trim($this->gsatelite->get_parametro('SYS_SIGLAS')));
        $data["consulta"] = $this->accion_personal_model->get_datos_permiso(array('hxe_id' => $id_permiso));
        $permiso_licencia = (isset($data["consulta"][0]['thf_licencia']) && $data["consulta"][0]['thf_licencia'] > 0) ? 6 : 4; //4=permiso normal \ 6=licencias
        $existe_fri = $this->gsatelite->get_tabla('fri_formato_impresion', array('fri_estado' => 1, 'fri_activo' => 1, 'fri_tipo_formato' => $permiso_licencia));
        $tipos_permiso = $this->gsatelite->get_tabla('thf_tipo_hora_faltante', array('thf_estado' => 1));
        $motivo_permiso = $this->gsatelite->get_tabla('mtp_motivo_permiso', array('mtp_estado' => 1));
        if ($empresa == 'midem') {
            // code...
        } else {
            $data["tipo_perm"] = array_chunk(array_column($tipos_permiso, 'thf_nombre', 'thf_id'), 4, true);
        $data["motivo_perm"] = array_chunk(array_column($motivo_permiso, 'mtp_nombre', 'mtp_id'), 4, true);
        }
        if (count($existe_fri) > 0) {
            $data["config"] = json_decode($existe_fri[0]['fri_configuraciones_formato'], true);
            $html .= $this->load->view('acciones_personal/principal/' . $existe_fri[0]['fri_archivo'], $data, true);
        } else {
            $html = $this->load->view('reporte/header', array('titulo' => 'Permiso Laboral', 'solotitulo' => true), true);
            $html .= $this->load->view('acciones_personal/principal/print_permiso_empleado', $data, true);
        }
        $this->pdf->setPrintFooter(false);
        $this->pdf->makePDF($html, 'P');
    }


    /**
      * @author René Castaneda
      * @since 24-08-2018
      * @return Realizar cálculos para la liquidación.
      */
    public function get_calculos_liquidacion(){
        $respuesta = array(
            'html_ingreso'    => '<tr><td colspan="2" style="text-align:center">Sin registros</td></tr>',
            'html_descuento'  => '<tr><td colspan="2" style="text-align:center">Sin registros</td></tr>',
            'total_ingreso'   => 0,
            'total_descuento' => 0,
            'total_pagar'     => 0
        );
        if ($this->input->post()) {
            // var_dump($_POST);die();
            extract($this->input->post()); //estracción de todas las variables del post
            $registro_emp = $this->accion_personal_model->get_info_empleado_liquidacion(array('emp_id' => $id_empleado_liquidacion));
            $registro_emp = $registro_emp[0];
            $fecha_ingreso = $registro_emp['emp_fecha_contrato'];
            $fecha_ult_liq = ($registro_emp['emp_fecha_ult_liquidacion']) ? $registro_emp['emp_fecha_ult_liquidacion'] : $fecha_ingreso;
            $fecha_aguinaldo =  ($registro_emp['emp_fecha_ult_aguinaldo'])? $registro_emp['emp_fecha_ult_aguinaldo'] : $fecha_ingreso;
            $fecha_antiguedad =  ($registro_emp['emp_fecha_antiguedad']) ? $registro_emp['emp_fecha_antiguedad'] : $fecha_ingreso;
            
            $rte_fecha_retiro = $this->gsatelite->get_tabla('rte_retiro_empleado', array('rte_estado' => 1, 'rte_id_emp' => $registro_emp['emp_id']));
            $fecha_retiro =  (trim($registro_emp['emp_fecha_retiro']) != "") ? $registro_emp['emp_fecha_retiro'] : formatear_fecha('Y-m-d', $rte_fecha_retiro[0]['rte_fecha_retiro']);            

            $html_ingreso = "";
            $total_ingreso = 0;
            $emp = (object) $registro_emp;
            //preguntar por los tipos de ingresos parametrizados
            $id_tig_aguinaldo = (trim($this->gsatelite->get_parametro('ID_TIPO_INGRESO_AGUINALDO')) > 0 )? $this->gsatelite->get_parametro('ID_TIPO_INGRESO_AGUINALDO') : 0;
            $reg_aguinaldo = $this->gsatelite->get_tabla('tig_tipo_ingreso',array('tig_id'=>$id_tig_aguinaldo));
            $id_tig_vacacion = (trim($this->gsatelite->get_parametro('ID_TIG_VACACION')) > 0 )? $this->gsatelite->get_parametro('ID_TIG_VACACION') : 0;
            $reg_vacacion = $this->gsatelite->get_tabla('tig_tipo_ingreso',array('tig_id'=>$id_tig_vacacion)); 
            $id_tig_vacacion_prima = (trim($this->gsatelite->get_parametro('ID_INGRESO_PRIMA_VACACION')) > 0 )? $this->gsatelite->get_parametro('ID_INGRESO_PRIMA_VACACION') : 0;
            $reg_vacacion_prima = $this->gsatelite->get_tabla('tig_tipo_ingreso',array('tig_id'=>$id_tig_vacacion_prima));
            $id_tig_indemnizacion = (trim($this->gsatelite->get_parametro('ID_TIPO_INGRESO_INDEMNIZACION')) > 0 )? $this->gsatelite->get_parametro('ID_TIPO_INGRESO_INDEMNIZACION') : 0;
            $reg_indemnizacion= $this->gsatelite->get_tabla('tig_tipo_ingreso',array('tig_id'=>$id_tig_indemnizacion)); 
            $id_tig_salario = (trim($this->gsatelite->get_parametro('INGRESO_SALARIO')) > 0 )? $this->gsatelite->get_parametro('INGRESO_SALARIO') : 0;
            $reg_salario= $this->gsatelite->get_tabla('tig_tipo_ingreso',array('tig_id'=>$id_tig_salario)); 

            $id_array_ingresos["$id_tig_aguinaldo"] = 0;
            $id_array_ingresos["$id_tig_vacacion"] = 0;
            $id_array_ingresos["$id_tig_vacacion_prima"] = 0;
            $id_array_ingresos["$id_tig_indemnizacion"] = 0;
            $id_array_ingresos["$id_tig_salario"] = 0;

            $monto_aguinaldo = 0;
            if ($ckcAplicaAguinaldo && count($reg_aguinaldo) > 0){ 
                $dias_considerados = ($this->input->post('txtAguiDias') > 0) ? intval($this->input->post('txtAguiDias')) : 0;
                $dias_considerados = 0; //por el momento se no se usará así
                $base_dias_laboral_agui = ($ckcAplicaDiasLaboralesAguinaldo == 1) ? 1 : 0;
                $fecha_corte_aguinaldo = $emp->emp_fecha_ult_aguinaldo;
                $monto_aguinaldo = $this->accion_personal_model->calculo_aguinaldo_empleado($emp, $fecha_antiguedad, $fecha_retiro, $fecha_corte_aguinaldo, $dias_considerados, $base_dias_laboral_agui);
                $monto_aguinaldo = round(($monto_aguinaldo * $txtPorcentajeAgui),2);

                $input_aguinaldo  = '<input type="hidden" value="' . $id_tig_aguinaldo . '" name="ingresos_liq_id[]" />';
                $input_aguinaldo .= '<input type="hidden" value="'. ($txtPorcentajeAgui * 100) . '" name="ingresos_liq_porcent[]" />';
                $input_aguinaldo .= '<input type="hidden" value="' . $monto_aguinaldo . '" name="ingresos_liq_monto[]" />';
                $total_ingreso   += $monto_aguinaldo;
                // var_dump($monto_aguinaldo);die();
                $html_ingreso    .= "<tr><td>$input_aguinaldo" . $reg_aguinaldo[0]['tig_nombre'] . " (" . ($txtPorcentajeAgui * 100) . "%)</td>";
                $html_ingreso    .= "<td style='text-align: right;'>" . number_format($monto_aguinaldo, 2) . "</td></tr>";   
            }
            $id_array_ingresos["$id_tig_aguinaldo"] = $monto_aguinaldo;

            $vacacion = $prima = 0;
            if ($ckcAplicaVacacion && count($reg_vacacion) > 0 && count($reg_vacacion_prima) > 0){
                $base_dias_laboral = ($ckcAplicaDiasLaboralesVaca == 1) ? 1 : 0;
                //$fecha_ult_vaca = emp_fecha_ult_vacacion -> emp_fecha_ult_liquidacion -> emp_fecha_contrato /// != ""
                $fecha_ult_vaca = (trim($emp->emp_fecha_ult_vacacion) != "") ? formatear_fecha('Y-m-d', $emp->emp_fecha_ult_vacacion) : $fecha_ult_liq;
                $monto_vacacion =  $this->accion_personal_model->calculo_vacacion_empleado($emp, $fecha_ult_vaca, $fecha_retiro, $base_dias_laboral);
                $vacacion = round(($monto_vacacion['vacacion'] * $txtPorcentajeVaca), 2);
                $prima = round(($monto_vacacion['prima'] * $txtPorcentajeVaca), 2);
                $total_ingreso += $vacacion;
                $total_ingreso += $prima;
                $input_vacacion = '<input type="hidden" value="'.$id_tig_vacacion.'" name="ingresos_liq_id[]" />';
                $input_vacacion .= '<input type="hidden" value="'.($txtPorcentajeVaca*100).'" name="ingresos_liq_porcent[]" />';
                $input_vacacion .= '<input type="hidden" value="'.$vacacion.'" name="ingresos_liq_monto[]" />';
                $input_vacacion .= '<input type="hidden" value="'.$id_tig_vacacion_prima.'" name="ingresos_liq_id[]" />';
                $input_vacacion .= '<input type="hidden" value="'.($txtPorcentajeVaca*100).'" name="ingresos_liq_porcent[]" />';
                $input_vacacion .= '<input type="hidden" value="'.$prima.'" name="ingresos_liq_monto[]" />';
                $html_ingreso .= "<tr><td>$input_vacacion".$reg_vacacion[0]['tig_nombre']." (".($txtPorcentajeVaca*100)."%)</td><td style='text-align: right;'>".number_format($vacacion,2)."</td></tr>";
                $html_ingreso .= "<tr><td>".$reg_vacacion_prima[0]['tig_nombre']." (".($txtPorcentajeVaca*100)."%)</td><td style='text-align: right;'>".number_format($prima,2)."</td></tr>";
            }
            $id_array_ingresos["$id_tig_vacacion"] = $vacacion;
            $id_array_ingresos["$id_tig_vacacion_prima"] = $prima;

            $monto_indemnizacion = 0;
            if ($ckcAplicaIndemnizacion && count($reg_indemnizacion) > 0 ) {
                $base_salario_min = ($ckcAplicaIndem_salario_minimo == 1) ? 1 : 0;
                $renuncia_voluntaria = ($ckcAplica_renuncia_voluntaria == 1) ? 1 : 0;
                $base_dias_laboral_indem = ($ckcAplicaDiasLaboralesIndem == 1) ? 1 : 0;
                $fecha_antiguedad_ = $fecha_ult_liq;
                $monto_indemnizacion = $this->accion_personal_model->calculo_indemnizacion_empleado($emp, $fecha_antiguedad_, $base_salario_min, $base_dias_laboral_indem, $renuncia_voluntaria);
                $monto_indemnizacion = round(($monto_indemnizacion * $txtPorcentajeIndem),2);
                $total_ingreso += $monto_indemnizacion;

                $input_indem = '<input type="hidden" value="'.$id_tig_indemnizacion.'" name="ingresos_liq_id[]" />';
                $input_indem .= '<input type="hidden" value="'.($txtPorcentajeIndem*100).'" name="ingresos_liq_porcent[]" />';
                $input_indem .= '<input type="hidden" value="'.$monto_indemnizacion.'" name="ingresos_liq_monto[]" />';


                $html_ingreso .= "<tr><td>$input_indem".$reg_indemnizacion[0]['tig_nombre']." (".($txtPorcentajeIndem*100)."%)</td><td style='text-align: right;'>".number_format($monto_indemnizacion,2)."</td></tr>";
            }
            $id_array_ingresos["$id_tig_indemnizacion"] = $monto_indemnizacion;

            $monto_salario = 0;
            if ($ckcAplicaSalario && count($reg_salario) > 0 ){
                $monto_salario =  $this->accion_personal_model->calculo_salario_empleado_liq($emp);
                $monto_salario = round(($monto_salario*$txtPorcentajeSala),2);
                $total_ingreso += $monto_salario;

                $input_salario = '<input type="hidden" value="'.$id_tig_salario.'" name="ingresos_liq_id[]" />';
                $input_salario .= '<input type="hidden" value="'.($txtPorcentajeSala*100).'" name="ingresos_liq_porcent[]" />';
                $input_salario .= '<input type="hidden" value="'.$monto_salario.'" name="ingresos_liq_monto[]" />';

                $html_ingreso .= "<tr><td>$input_salario".$reg_salario[0]['tig_nombre']." (".($txtPorcentajeSala*100).'%)</td><td style="text-align: right;">'.number_format($monto_salario,2).'</td></tr>';
            }
            $id_array_ingresos["$id_tig_salario"] = $monto_salario;
            if ($total_ingreso > 0 ){
                $html_ingreso .= "<tr><td style='text-align:center;'><b><big>Total $</big></b></td><td style='text-align: right;'><b><big>" . number_format($total_ingreso,2) . "</big></b></td></tr>";
            }
            $html_descuento = "";
            $total_descuento = 0;
            //for- bucle para los descuentos según el tipo de planilla
            $descuentos_liquidacion = $this->accion_personal_model->descuentos_liquidacion($id_tipo_planilla);

            //posibles descuentos de ley.
            $id_descuento_isss = $this->gsatelite->get_parametro('DESCUENTO_ISS');
            $id_descuento_afp = $this->gsatelite->get_parametro('DESCUENTO_AFP');
            $id_descuento_renta10 = $this->gsatelite->get_parametro('DESCUENTO_ISR10');
            $id_descuento_renta= $this->gsatelite->get_parametro('DESCUENTO_ISR');
            $id_agrupador_isss = $this->gsatelite->get_parametro('AGRUPADOR_ISS');
            $id_agrupador_afp = $this->gsatelite->get_parametro('ID_AGRUPADOR_AFP');
            $id_agrupador_renta10 = $this->gsatelite->get_parametro('AGRUPADOR_ISR10');
            $id_agrupador_renta= $this->gsatelite->get_parametro('AGRUPADOR_ISR');
            $desc_pgr_id = $this->gsatelite->get_parametro_emp('SYS_DESCUENTO_PGR', null, null, array('TIPO_DESCUENTO_ID'));
            $desc_pgr_pc = $this->gsatelite->get_parametro_emp('SYS_DESCUENTO_PGR', null, null, array('PORCENTAJE'));
            $q_tipo_tabla = $this->gsatelite->get_tabla('txt_tipo_planillaxtipo_isr',array('txt_id_tpl'=>$id_tipo_planilla));
            $tipo_tabla = ($q_tipo_tabla) ? $q_tipo_tabla[0]['txt_id_tis'] : 0;
            $monto_des_iss_afp = 0;
            foreach ($descuentos_liquidacion as $des) {
                $monto_descuento = 0;
                $nombre_descuento = "";
                $reg_des = $this->gsatelite->get_tabla('tdc_tipo_descuento',array('tdc_id'=>$des['dtp_id_tdc']));
                $reg_des = $reg_des[0];
                switch ($des['dtp_id_tdc']) {
                    case $id_descuento_isss:
                        // SOLO SI EL EMPLEADO APLICA A ISSS
                        if ($emp->emp_aplica_isss > 0) {
                            $nombre_descuento = "ISSS ".round($reg_des['tdc_porcentaje'],2).'%';
                            $total_ingreso_calculo = 0;
                            $agrupador_datos = $this->gsatelite->get_tabla('deg_detalle_agrupador',array('deg_id_tag'=>$id_agrupador_isss, 'deg_id_tig >'=>0));
                            foreach ($agrupador_datos as $fila) {
                                if(array_key_exists($fila['deg_id_tig'], $id_array_ingresos)) {
                                    $total_ingreso_calculo += $id_array_ingresos[$fila['deg_id_tig']]; 
                                }
                            }
                            //MAXIMO A COBRAR EN EL MES = $30
                            $descuento_max_emp = (($reg_des['tdc_maximo'] * $reg_des['tdc_porcentaje']) / 100); 
                            $total_ingreso_paraisss = ($total_ingreso_calculo > $reg_des['tdc_maximo']) ? $reg_des['tdc_maximo'] : $total_ingreso_calculo;
                            //CALCULO DE ESTE DESCUENTO EJ. $6
                            $este_descuento = round(($total_ingreso_paraisss * ($reg_des['tdc_porcentaje'] / 100)), 2);
                            //BUSCAR SI EN EL MISMO MES HAY MAS PLANILLAS AUTORIZADAS DONDE SE LE HA DESCONTADO ISSS Y CALCULAR LA DIFERENCIA
                            $ya_descontado = $this->planilla_model->get_isss_mes_act($fecha_retiro, $registro_emp['emp_id']);
                            // EJ. $25 COBRADOS EN EL RESTO DE PLANILLAS PARA LLEGAR AL MAXIMO DE $30 FALTAN $5
                            $des_pendiente_emp = (($descuento_max_emp - $ya_descontado['empleado']) < 0) ? 0 : ($descuento_max_emp - $ya_descontado['empleado']);
                            //SE TOMA EL MENOR DE LOS 2, EJ. FALTAN 5 Y CALCULAMOS 6, DEJAMOS 5 / FALTAN 8 Y CALCULAMOS 4 DEJAMOS 4
                            $monto_descuento = ($este_descuento > $des_pendiente_emp) ? $des_pendiente_emp : $este_descuento;
                            $monto_des_iss_afp += $monto_descuento;

                            $input_descuento  = '<input type="hidden" value="' . $id_descuento_isss.'" name="descuento_liq_id[]" />';
                            $input_descuento .= '<input type="hidden" value="' . round($reg_des['tdc_porcentaje'],2).'" name="descuento_liq_porcent[]" />';
                            $input_descuento .= '<input type="hidden" value="' . $monto_descuento.'" name="descuento_liq_monto[]" />';
                        }
                    break;
                    case $id_descuento_afp:
                        // SOLO SI EL EMPLEADO APLICA A AFP
                        if ($emp->emp_aplica_afp > 0) {
                            $nombre_descuento = "AFP " .round($reg_des['tdc_porcentaje'],2).'%';
                            $total_ingreso_calculo = 0;
                            $agrupador_datos = $this->gsatelite->get_tabla('deg_detalle_agrupador',array('deg_id_tag'=>$id_agrupador_afp, 'deg_id_tig >'=>0));
                            foreach ($agrupador_datos as $fila) {
                                if(array_key_exists($fila['deg_id_tig'], $id_array_ingresos)) {
                                    $total_ingreso_calculo += $id_array_ingresos[$fila['deg_id_tig']]; 
                                }
                            }

                            $monto_descuento = round(($total_ingreso_calculo*($reg_des['tdc_porcentaje']/100)),2);
                            $monto_des_iss_afp += $monto_descuento;

                            $input_descuento  = '<input type="hidden" value="'.$id_descuento_afp.'" name="descuento_liq_id[]" />';
                            $input_descuento .= '<input type="hidden" value="'.round($reg_des['tdc_porcentaje'],2).'" name="descuento_liq_porcent[]" />';
                            $input_descuento .= '<input type="hidden" value="'.$monto_descuento.'" name="descuento_liq_monto[]" />';
                        }
                    break;
                    case $id_descuento_renta10:
                            $nombre_descuento = "RENTA ".round($reg_des['tdc_porcentaje'],2).'%';

                            $total_ingreso_calculo = 0;
                            $agrupador_datos = $this->gsatelite->get_tabla('deg_detalle_agrupador',array('deg_id_tag'=>$id_agrupador_renta10, 'deg_id_tig >'=>0));
                            foreach ($agrupador_datos as $fila) {
                              if(array_key_exists($fila['deg_id_tig'], $id_array_ingresos)) {
                                $total_ingreso_calculo += $id_array_ingresos[$fila['deg_id_tig']]; 
                            }
                        }

                        $monto_descuento = round(($total_ingreso_calculo*($reg_des['tdc_porcentaje']/100)),2);

                        $input_descuento = '<input type="hidden" value="'.$id_descuento_renta10.'" name="descuento_liq_id[]" />';
                        $input_descuento .= '<input type="hidden" value="'.round($reg_des['tdc_porcentaje'],2).'" name="descuento_liq_porcent[]" />';
                        $input_descuento .= '<input type="hidden" value="'.$monto_descuento.'" name="descuento_liq_monto[]" />';
                    break;
                    case $id_descuento_renta:
                        if ($tipo_tabla > 0) {
                            $total_ingreso_calculo = 0;
                            $agrupador_datos = $this->gsatelite->get_tabla('deg_detalle_agrupador',array('deg_id_tag'=>$id_agrupador_renta, 'deg_id_tig >'=>0));
                            foreach ($agrupador_datos as $fila) {
                                if(array_key_exists($fila['deg_id_tig'], $id_array_ingresos)) {
                                    $total_ingreso_calculo += $id_array_ingresos[$fila['deg_id_tig']]; 
                                }
                            }
                            //$total_ingreso_calculo ES EL MONTO SUJETO DE AHORITA
                            $nombre_descuento = "RENTA";
                            $sujeto_renta = $total_ingreso_calculo - $monto_des_iss_afp;

                            $configuracion_liquidacion = json_decode($this->gsatelite->get_parametro('SYS_CONFIGURACION_LIQUIDACION'));
                            $tpl = ($configuracion_liquidacion->ID_TIPO_PLANILLA_LIQ > 0) ? $configuracion_liquidacion->ID_TIPO_PLANILLA_LIQ : 0;
                            //preguntar por la renta anterior
                            $where_renta_ant = array(
                                'ddd_id_emp' => $emp->emp_id,
                                'ddd_id_tdc' =>$id_descuento_renta,
                                'pla_estado' => 3,
                                'pla_id_tpl <> ' => $tpl,
                                "DATE_FORMAT(pla_fecha_inicio,'%Y%m')"=>formatear_fecha('Ym',$fecha_retiro)
                            );
                            //              $this->db->join('pla_planilla', 'pla_id=ddd_id_pla');
                            // $renta_ant = $this->gsatelite->get_tabla('ddd_detalle_descuento',$where_renta_ant);
                            //YA EXISTIA UN PROCESO PERO SE LE AMPLIO LA COBERTURA
                            $monto_calc_ant = 0;
                            $monto_sujeto_ant = 0;
                            $renta_ant = $this->accion_personal_model->suma_isr_mes($emp->emp_id, $fecha_retiro, $tpl);
                            $monto_calc_ant = $renta_ant['isr'];
                            $monto_sujeto_ant = ($renta_ant['ingreso'] - ($renta_ant['isss'] + $renta_ant['afp']));
                            //YA EXISTIA UN PROCESO PERO SE LE AMPLIO LA COBERTURA
                            // if (count($renta_ant) > 0) {
                            //     $monto_sujeto_ant = array_sum(array_column($renta_ant, 'ddd_ingreso_afecto'));
                            //     $monto_calc_ant = array_sum(array_column($renta_ant, 'ddd_valor'));
                            // }                            
                            $sujeto_renta = $sujeto_renta + $monto_sujeto_ant; //sumar el anterior
                            $tabla_renta = $this->gsatelite->get_tabla('isr_isr',array('isr_id_tis' => $tipo_tabla));
                            foreach ($tabla_renta as $tramo) {
                                if ($sujeto_renta >= $tramo['isr_desde'] && $sujeto_renta <= $tramo['isr_hasta']) {
                                    $renta = $tramo['isr_cuota'] + ($sujeto_renta - $tramo['isr_exceso']) * $tramo['isr_porcentaje'] / 100;
                                    $renta = $renta - $monto_calc_ant; //restar el anterior
                                    $monto_descuento = round($renta,2);
                                    $input_descuento  = '<input type="hidden" value="'.$id_descuento_renta.'" name="descuento_liq_id[]" />';
                                    $input_descuento .= '<input type="hidden" value="100" name="descuento_liq_porcent[]" />';
                                    $input_descuento .= '<input type="hidden" value="'.$monto_descuento.'" name="descuento_liq_monto[]" />';
                                }
                            }
                        }
                    break;                  
                    default:
                        # code...
                    break;
                }
                $total_descuento += $monto_descuento;
                $html_descuento .= ($monto_descuento > 0)? "<tr><td>$input_descuento $nombre_descuento</td><td style='text-align: right;'>".number_format($monto_descuento,2)."</td></tr>":'';
            }
            $desc_pgr = 0;
            if ($desc_pgr_id > 0) {
                $posee_desc = $this->gsatelite->get_tabla('dss_descuento', array('dss_estado' => 1, 'dss_permanente' => 1, 'dss_id_emp' => $emp->emp_id, 'dss_id_tdc' => $desc_pgr_id));
                if (count($posee_desc) > 0) {
                    //SI EL EMPLEADO POSEE DESCUENTO PGR SE LE RETIENE UN PORCENTAJE DEL TOTAL
                    $desc_pgr_pc = (trim($desc_pgr_pc) != "") ? trim($desc_pgr_pc) : 0;
                    $desc_pgr = round(($total_ingreso * ($desc_pgr_pc / 100)), 2);
                }
            }
            if ($desc_pgr > 0) {
                $nombre_descuento  = $this->gsatelite->get_campo('tdc_tipo_descuento', 'tdc_nombre', array('tdc_id' => $desc_pgr_id));
                $nombre_descuento .= ' ' . round($desc_pgr_pc, 2) . '%';
                $input_descuento  = '<input type="hidden" value="' . $desc_pgr_id . '" name="descuento_liq_id[]" />';
                $input_descuento .= '<input type="hidden" value="' . round($desc_pgr_pc, 2) . '" name="descuento_liq_porcent[]" />';
                $input_descuento .= '<input type="hidden" value="' . $desc_pgr . '" name="descuento_liq_monto[]" />';
                $html_descuento  .= "<tr><td>$input_descuento $nombre_descuento</td><td style='text-align: right;'>$desc_pgr</td></tr>";
                $total_descuento += $desc_pgr;
            }

            if ($total_descuento > 0 ){
                $html_descuento .= '<tr><td style="text-align:center;"><b><big>Total $</big></b></td><td style="text-align: right;"><b><big>';
                $html_descuento .= number_format($total_descuento, 2)  . '</big></b></td></tr>';
            }


            if (trim($html_ingreso) != "") {
                $respuesta['html_ingreso'] = $html_ingreso;
            }
            if (trim($html_descuento) != "") {
                $respuesta['html_descuento'] = $html_descuento;
            }
            if ($total_ingreso > 0 ) {
                $respuesta['total_pagar'] = ($total_ingreso - $total_descuento);
                $respuesta['total_ingreso'] = $total_ingreso;
                $respuesta['total_descuento'] = $total_descuento;
            }

       //   print_r($_POST); die();

       }

       echo json_encode($respuesta);
       die();
    }

    public function get_calculos_indemnizacion(){
        $respuesta = array(
            'html_ingreso'    => '<tr><td colspan="2" style="text-align:center">Sin registros</td></tr>',
            'html_descuento'  => '<tr><td colspan="2" style="text-align:center">Sin registros</td></tr>',
            'total_ingreso'   => 0,
            'total_descuento' => 0,
            'total_pagar'     => 0
        );
        if ($this->input->post()) {
            // var_dump($_POST);die();
            extract($this->input->post());
            $registro_emp = $this->accion_personal_model->get_info_empleado_indem(array('emp_id' => $id_empleado_liquidacion))[0];
            $fecha_ingreso    = $registro_emp['emp_fecha_contrato'];
            $fecha_ult_liq    = ($registro_emp['emp_fecha_ult_liquidacion']) ? $registro_emp['emp_fecha_ult_liquidacion'] : $fecha_ingreso;
            $fecha_aguinaldo  = ($registro_emp['emp_fecha_ult_aguinaldo']) ? $registro_emp['emp_fecha_ult_aguinaldo'] : $fecha_ingreso;
            $fecha_antiguedad = ($registro_emp['emp_fecha_antiguedad']) ? $registro_emp['emp_fecha_antiguedad'] : $fecha_ingreso;
            $fecha_retiro =  (trim($txtFechaHasta) != "") ? formatear_fecha('Y-m-d', $txtFechaHasta) : date('Y-m-d 00:00:00');
            
            $html_ingreso = "";
            $total_ingreso = 0;
            $emp = (object) $registro_emp;

            //preguntar por los tipos de ingresos parametrizados
            $id_tig_salario = (trim($this->gsatelite->get_parametro('INGRESO_SALARIO')) > 0 )? $this->gsatelite->get_parametro('INGRESO_SALARIO') : 0;
            $id_tig_vacacion = (trim($this->gsatelite->get_parametro('ID_TIG_VACACION')) > 0) ? $this->gsatelite->get_parametro('ID_TIG_VACACION') : 0;
            $id_tig_aguinaldo = (trim($this->gsatelite->get_parametro('ID_TIPO_INGRESO_AGUINALDO')) > 0) ? $this->gsatelite->get_parametro('ID_TIPO_INGRESO_AGUINALDO') : 0;
            $id_tig_vacacion_prima = (trim($this->gsatelite->get_parametro('ID_INGRESO_PRIMA_VACACION')) > 0) ? $this->gsatelite->get_parametro('ID_INGRESO_PRIMA_VACACION') : 0;
            $id_tig_indemnizacion = (trim($this->gsatelite->get_parametro('ID_TIPO_INGRESO_INDEMNIZACION')) > 0)? $this->gsatelite->get_parametro('ID_TIPO_INGRESO_INDEMNIZACION') : 0;
            $reg_salario= $this->gsatelite->get_tabla('tig_tipo_ingreso',array('tig_id'=>$id_tig_salario)); 
            $reg_vacacion = $this->gsatelite->get_tabla('tig_tipo_ingreso',array('tig_id'=>$id_tig_vacacion)); 
            $reg_aguinaldo = $this->gsatelite->get_tabla('tig_tipo_ingreso',array('tig_id'=>$id_tig_aguinaldo));
            $reg_indemnizacion = $this->gsatelite->get_tabla('tig_tipo_ingreso',array('tig_id'=>$id_tig_indemnizacion)); 
            $reg_vacacion_prima = $this->gsatelite->get_tabla('tig_tipo_ingreso',array('tig_id'=>$id_tig_vacacion_prima));

            $id_array_ingresos["$id_tig_aguinaldo"] = 0;
            $id_array_ingresos["$id_tig_vacacion"] = 0;
            $id_array_ingresos["$id_tig_vacacion_prima"] = 0;
            $id_array_ingresos["$id_tig_indemnizacion"] = 0;
            $id_array_ingresos["$id_tig_salario"] = 0;

            $monto_aguinaldo = 0;//OK
            if ($ckcAplicaAguinaldo && count($reg_aguinaldo) > 0){ 
                $base_dias_laboral_agui = ($ckcAplicaDiasLaboralesAguinaldo == 1) ? 1 : 0;
                $fecha_corte_aguinaldo = $emp->emp_fecha_ult_aguinaldo;
                $monto_aguinaldo = $this->accion_personal_model->calculo_aguinaldo_empleado($emp, $fecha_antiguedad, $fecha_retiro, $fecha_corte_aguinaldo, 0, $base_dias_laboral_agui);
                $monto_aguinaldo = round(($monto_aguinaldo * $txtPorcentajeAgui),2);
                $input_aguinaldo  = '<input type="hidden" value="' . $id_tig_aguinaldo . '" name="ingresos_liq_id[]" />';
                $input_aguinaldo .= '<input type="hidden" value="'. ($txtPorcentajeAgui * 100) . '" name="ingresos_liq_porcent[]" />';
                $input_aguinaldo .= '<input type="hidden" value="' . $monto_aguinaldo . '" name="ingresos_liq_monto[]" />';
                $total_ingreso   += $monto_aguinaldo;
                $html_ingreso    .= "<tr><td>$input_aguinaldo" . $reg_aguinaldo[0]['tig_nombre'] . " (" . ($txtPorcentajeAgui * 100) . "%)</td>";
                $html_ingreso    .= "<td style='text-align: right;'>" . number_format($monto_aguinaldo, 2) . "</td></tr>";   
            }
            $id_array_ingresos["$id_tig_aguinaldo"] = $monto_aguinaldo;

            $vacacion = $prima = 0;//OK
            if ($ckcAplicaVacacion && count($reg_vacacion) > 0 && count($reg_vacacion_prima) > 0){
                $base_dias_laboral = ($ckcAplicaDiasLaboralesVaca == 1) ? 1 : 0;
                $fecha_ult_vaca = (trim($emp->emp_fecha_ult_vacacion) != "") ? formatear_fecha('Y-m-d', $emp->emp_fecha_ult_vacacion) : $fecha_ult_liq;
                $monto_vacacion =  $this->accion_personal_model->calculo_vacacion_empleado($emp, $fecha_ult_vaca, $fecha_retiro, $base_dias_laboral);
                $vacacion = round(($monto_vacacion['vacacion'] * $txtPorcentajeVaca), 2);
                $prima = round(($monto_vacacion['prima'] * $txtPorcentajeVaca), 2);
                $total_ingreso += $vacacion;
                $total_ingreso += $prima;
                $input_vacacion = '<input type="hidden" value="'.$id_tig_vacacion.'" name="ingresos_liq_id[]" />';
                $input_vacacion .= '<input type="hidden" value="'.($txtPorcentajeVaca*100).'" name="ingresos_liq_porcent[]" />';
                $input_vacacion .= '<input type="hidden" value="'.$vacacion.'" name="ingresos_liq_monto[]" />';
                $input_vacacion .= '<input type="hidden" value="'.$id_tig_vacacion_prima.'" name="ingresos_liq_id[]" />';
                $input_vacacion .= '<input type="hidden" value="'.($txtPorcentajeVaca*100).'" name="ingresos_liq_porcent[]" />';
                $input_vacacion .= '<input type="hidden" value="'.$prima.'" name="ingresos_liq_monto[]" />';
                $html_ingreso .= "<tr><td>$input_vacacion".$reg_vacacion[0]['tig_nombre']." (".($txtPorcentajeVaca*100)."%)</td><td style='text-align: right;'>".number_format($vacacion,2)."</td></tr>";
                $html_ingreso .= "<tr><td>".$reg_vacacion_prima[0]['tig_nombre']." (".($txtPorcentajeVaca*100)."%)</td><td style='text-align: right;'>".number_format($prima,2)."</td></tr>";
            }
            $id_array_ingresos["$id_tig_vacacion"] = $vacacion;
            $id_array_ingresos["$id_tig_vacacion_prima"] = $prima;

            $monto_indemnizacion = 0;
            if ($ckcAplicaIndemnizacion && count($reg_indemnizacion) > 0 ) {
                $base_dias_laboral_indem = ($ckcAplicaDiasLaboralesIndem == 1) ? 1 : 0;
                $monto_indemnizacion = $this->accion_personal_model->calculo_indemnizacion_empleado($emp, $fecha_ult_liq, 0, $base_dias_laboral_indem, 0, $fecha_retiro);
                $monto_indemnizacion = round(($monto_indemnizacion * $txtPorcentajeIndem),2);
                $total_ingreso += $monto_indemnizacion;

                $input_indem = '<input type="hidden" value="'.$id_tig_indemnizacion.'" name="ingresos_liq_id[]" />';
                $input_indem .= '<input type="hidden" value="'.($txtPorcentajeIndem*100).'" name="ingresos_liq_porcent[]" />';
                $input_indem .= '<input type="hidden" value="'.$monto_indemnizacion.'" name="ingresos_liq_monto[]" />';

                $html_ingreso .= "<tr><td>$input_indem".$reg_indemnizacion[0]['tig_nombre']." (".($txtPorcentajeIndem*100)."%)</td><td style='text-align: right;'>".number_format($monto_indemnizacion,2)."</td></tr>";
            }
            $id_array_ingresos["$id_tig_indemnizacion"] = $monto_indemnizacion;

            $monto_salario = 0;//OK
            if ($ckcAplicaSalario && count($reg_salario) > 0 ){
                $monto_salario =  $this->accion_personal_model->calculo_salario_empleado_liq($emp, $fecha_retiro);
                $monto_salario = round(($monto_salario*$txtPorcentajeSala),2);
                $total_ingreso += $monto_salario;

                $input_salario = '<input type="hidden" value="'.$id_tig_salario.'" name="ingresos_liq_id[]" />';
                $input_salario .= '<input type="hidden" value="'.($txtPorcentajeSala*100).'" name="ingresos_liq_porcent[]" />';
                $input_salario .= '<input type="hidden" value="'.$monto_salario.'" name="ingresos_liq_monto[]" />';

                $html_ingreso .= "<tr><td>$input_salario".$reg_salario[0]['tig_nombre']." (".($txtPorcentajeSala*100).'%)</td><td style="text-align: right;">'.number_format($monto_salario,2).'</td></tr>';
            }
            $id_array_ingresos["$id_tig_salario"] = $monto_salario;
            if ($total_ingreso > 0 ){
                $html_ingreso .= "<tr><td style='text-align:center;'><b><big>Total $</big></b></td><td style='text-align: right;'><b><big>" . number_format($total_ingreso,2) . "</big></b></td></tr>";
            }
            $html_descuento = "";
            $total_descuento = 0;
            //for- bucle para los descuentos según el tipo de planilla
            $descuentos_liquidacion = $this->accion_personal_model->descuentos_liquidacion($id_tipo_planilla);

            //posibles descuentos de ley.
            $id_descuento_isss = $this->gsatelite->get_parametro('DESCUENTO_ISS');
            $id_descuento_afp = $this->gsatelite->get_parametro('DESCUENTO_AFP');
            $id_descuento_renta10 = $this->gsatelite->get_parametro('DESCUENTO_ISR10');
            $id_descuento_renta= $this->gsatelite->get_parametro('DESCUENTO_ISR');
            $id_agrupador_isss = $this->gsatelite->get_parametro('AGRUPADOR_ISS');
            $id_agrupador_afp = $this->gsatelite->get_parametro('ID_AGRUPADOR_AFP');
            $id_agrupador_renta10 = $this->gsatelite->get_parametro('AGRUPADOR_ISR10');
            $id_agrupador_renta= $this->gsatelite->get_parametro('AGRUPADOR_ISR');
            $desc_pgr_id = $this->gsatelite->get_parametro_emp('SYS_DESCUENTO_PGR', null, null, array('TIPO_DESCUENTO_ID'));
            $desc_pgr_pc = $this->gsatelite->get_parametro_emp('SYS_DESCUENTO_PGR', null, null, array('PORCENTAJE'));
            $q_tipo_tabla = $this->gsatelite->get_tabla('txt_tipo_planillaxtipo_isr',array('txt_id_tpl'=>$id_tipo_planilla));
            $tipo_tabla = ($q_tipo_tabla) ? $q_tipo_tabla[0]['txt_id_tis'] : 0;
            $monto_des_iss_afp = 0;
            foreach ($descuentos_liquidacion as $des) {
                $monto_descuento = 0;
                $nombre_descuento = "";
                $reg_des = $this->gsatelite->get_tabla('tdc_tipo_descuento',array('tdc_id'=>$des['dtp_id_tdc']));
                $reg_des = $reg_des[0];
                switch ($des['dtp_id_tdc']) {
                    case $id_descuento_isss:
                        // SOLO SI EL EMPLEADO APLICA A ISSS
                        if ($emp->emp_aplica_isss > 0) {
                            $nombre_descuento = "ISSS ".round($reg_des['tdc_porcentaje'],2).'%';
                            $total_ingreso_calculo = 0;
                            $agrupador_datos = $this->gsatelite->get_tabla('deg_detalle_agrupador',array('deg_id_tag'=>$id_agrupador_isss, 'deg_id_tig >'=>0));
                            foreach ($agrupador_datos as $fila) {
                                if(array_key_exists($fila['deg_id_tig'], $id_array_ingresos)) {
                                    $total_ingreso_calculo += $id_array_ingresos[$fila['deg_id_tig']]; 
                                }
                            }
                            //MAXIMO A COBRAR EN EL MES = $30
                            $descuento_max_emp = (($reg_des['tdc_maximo'] * $reg_des['tdc_porcentaje']) / 100); 
                            $total_ingreso_paraisss = ($total_ingreso_calculo > $reg_des['tdc_maximo']) ? $reg_des['tdc_maximo'] : $total_ingreso_calculo;
                            //CALCULO DE ESTE DESCUENTO EJ. $6
                            $este_descuento = round(($total_ingreso_paraisss * ($reg_des['tdc_porcentaje'] / 100)), 2);
                            //BUSCAR SI EN EL MISMO MES HAY MAS PLANILLAS AUTORIZADAS DONDE SE LE HA DESCONTADO ISSS Y CALCULAR LA DIFERENCIA
                            $ya_descontado = $this->planilla_model->get_isss_mes_act($fecha_retiro, $registro_emp['emp_id']);
                            // EJ. $25 COBRADOS EN EL RESTO DE PLANILLAS PARA LLEGAR AL MAXIMO DE $30 FALTAN $5
                            $des_pendiente_emp = (($descuento_max_emp - $ya_descontado['empleado']) < 0) ? 0 : ($descuento_max_emp - $ya_descontado['empleado']);
                            //SE TOMA EL MENOR DE LOS 2, EJ. FALTAN 5 Y CALCULAMOS 6, DEJAMOS 5 / FALTAN 8 Y CALCULAMOS 4 DEJAMOS 4
                            $monto_descuento = ($este_descuento > $des_pendiente_emp) ? $des_pendiente_emp : $este_descuento;
                            $monto_des_iss_afp += $monto_descuento;

                            $input_descuento  = '<input type="hidden" value="' . $id_descuento_isss.'" name="descuento_liq_id[]" />';
                            $input_descuento .= '<input type="hidden" value="' . round($reg_des['tdc_porcentaje'],2).'" name="descuento_liq_porcent[]" />';
                            $input_descuento .= '<input type="hidden" value="' . $monto_descuento.'" name="descuento_liq_monto[]" />';
                        }
                    break;
                    case $id_descuento_afp:
                        // SOLO SI EL EMPLEADO APLICA A AFP
                        if ($emp->emp_aplica_afp > 0) {
                            $nombre_descuento = "AFP " .round($reg_des['tdc_porcentaje'],2).'%';
                            $total_ingreso_calculo = 0;
                            $agrupador_datos = $this->gsatelite->get_tabla('deg_detalle_agrupador',array('deg_id_tag'=>$id_agrupador_afp, 'deg_id_tig >'=>0));
                            foreach ($agrupador_datos as $fila) {
                                if(array_key_exists($fila['deg_id_tig'], $id_array_ingresos)) {
                                    $total_ingreso_calculo += $id_array_ingresos[$fila['deg_id_tig']]; 
                                }
                            }

                            $monto_descuento = round(($total_ingreso_calculo*($reg_des['tdc_porcentaje']/100)),2);
                            $monto_des_iss_afp += $monto_descuento;

                            $input_descuento  = '<input type="hidden" value="'.$id_descuento_afp.'" name="descuento_liq_id[]" />';
                            $input_descuento .= '<input type="hidden" value="'.round($reg_des['tdc_porcentaje'],2).'" name="descuento_liq_porcent[]" />';
                            $input_descuento .= '<input type="hidden" value="'.$monto_descuento.'" name="descuento_liq_monto[]" />';
                        }
                    break;
                    case $id_descuento_renta10:
                            $nombre_descuento = "RENTA ".round($reg_des['tdc_porcentaje'],2).'%';

                            $total_ingreso_calculo = 0;
                            $agrupador_datos = $this->gsatelite->get_tabla('deg_detalle_agrupador',array('deg_id_tag'=>$id_agrupador_renta10, 'deg_id_tig >'=>0));
                            foreach ($agrupador_datos as $fila) {
                              if(array_key_exists($fila['deg_id_tig'], $id_array_ingresos)) {
                                $total_ingreso_calculo += $id_array_ingresos[$fila['deg_id_tig']]; 
                            }
                        }

                        $monto_descuento = round(($total_ingreso_calculo*($reg_des['tdc_porcentaje']/100)),2);

                        $input_descuento = '<input type="hidden" value="'.$id_descuento_renta10.'" name="descuento_liq_id[]" />';
                        $input_descuento .= '<input type="hidden" value="'.round($reg_des['tdc_porcentaje'],2).'" name="descuento_liq_porcent[]" />';
                        $input_descuento .= '<input type="hidden" value="'.$monto_descuento.'" name="descuento_liq_monto[]" />';
                    break;
                    case $id_descuento_renta:
                        if ($tipo_tabla > 0) {
                            $total_ingreso_calculo = 0;
                            $agrupador_datos = $this->gsatelite->get_tabla('deg_detalle_agrupador',array('deg_id_tag'=>$id_agrupador_renta, 'deg_id_tig >'=>0));
                            foreach ($agrupador_datos as $fila) {
                                if(array_key_exists($fila['deg_id_tig'], $id_array_ingresos)) {
                                    $total_ingreso_calculo += $id_array_ingresos[$fila['deg_id_tig']]; 
                                }
                            }
                            //$total_ingreso_calculo ES EL MONTO SUJETO DE AHORITA
                            $nombre_descuento = "RENTA";
                            $sujeto_renta = $total_ingreso_calculo - $monto_des_iss_afp;

                            $configuracion_liquidacion = json_decode($this->gsatelite->get_parametro('SYS_CONFIGURACION_LIQUIDACION'));
                            $tpl = ($configuracion_liquidacion->ID_TIPO_PLANILLA_LIQ > 0) ? $configuracion_liquidacion->ID_TIPO_PLANILLA_LIQ : 0;
                            //preguntar por la renta anterior
                            $where_renta_ant = array(
                                'ddd_id_emp' => $emp->emp_id,
                                'ddd_id_tdc' =>$id_descuento_renta,
                                'pla_estado' => 3,
                                'pla_id_tpl <> ' => $tpl,
                                "DATE_FORMAT(pla_fecha_inicio,'%Y%m')"=>formatear_fecha('Ym',$fecha_retiro)
                            );
                            //              $this->db->join('pla_planilla', 'pla_id=ddd_id_pla');
                            // $renta_ant = $this->gsatelite->get_tabla('ddd_detalle_descuento',$where_renta_ant);
                            //YA EXISTIA UN PROCESO PERO SE LE AMPLIO LA COBERTURA
                            $monto_calc_ant = 0;
                            $monto_sujeto_ant = 0;
                            $renta_ant = $this->accion_personal_model->suma_isr_mes($emp->emp_id, $fecha_retiro, $tpl);
                            $monto_calc_ant = $renta_ant['isr'];
                            $monto_sujeto_ant = ($renta_ant['ingreso'] - ($renta_ant['isss'] + $renta_ant['afp']));
                            //YA EXISTIA UN PROCESO PERO SE LE AMPLIO LA COBERTURA
                            // if (count($renta_ant) > 0) {
                            //     $monto_sujeto_ant = array_sum(array_column($renta_ant, 'ddd_ingreso_afecto'));
                            //     $monto_calc_ant = array_sum(array_column($renta_ant, 'ddd_valor'));
                            // }                            
                            $sujeto_renta = $sujeto_renta + $monto_sujeto_ant; //sumar el anterior
                            $tabla_renta = $this->gsatelite->get_tabla('isr_isr',array('isr_id_tis' => $tipo_tabla));
                            foreach ($tabla_renta as $tramo) {
                                if ($sujeto_renta >= $tramo['isr_desde'] && $sujeto_renta <= $tramo['isr_hasta']) {
                                    $renta = $tramo['isr_cuota'] + ($sujeto_renta - $tramo['isr_exceso']) * $tramo['isr_porcentaje'] / 100;
                                    $renta = $renta - $monto_calc_ant; //restar el anterior
                                    $monto_descuento = round($renta,2);
                                    $input_descuento  = '<input type="hidden" value="'.$id_descuento_renta.'" name="descuento_liq_id[]" />';
                                    $input_descuento .= '<input type="hidden" value="100" name="descuento_liq_porcent[]" />';
                                    $input_descuento .= '<input type="hidden" value="'.$monto_descuento.'" name="descuento_liq_monto[]" />';
                                }
                            }
                        }
                    break;                  
                    default:
                    break;
                }
                $total_descuento += $monto_descuento;
                $html_descuento .= ($monto_descuento > 0)? "<tr><td>$input_descuento $nombre_descuento</td><td style='text-align: right;'>".number_format($monto_descuento,2)."</td></tr>" : '';
            }
            $desc_pgr = 0;
            if ($desc_pgr_id > 0) {
                $posee_desc = $this->gsatelite->get_tabla('dss_descuento', array('dss_estado' => 1, 'dss_permanente' => 1, 'dss_id_emp' => $emp->emp_id, 'dss_id_tdc' => $desc_pgr_id));
                if (count($posee_desc) > 0) {
                    //SI EL EMPLEADO POSEE DESCUENTO PGR SE LE RETIENE UN PORCENTAJE DEL TOTAL
                    $desc_pgr_pc = (trim($desc_pgr_pc) != "") ? trim($desc_pgr_pc) : 0;
                    $desc_pgr = round(($total_ingreso * ($desc_pgr_pc / 100)), 2);
                }
            }
            if ($desc_pgr > 0) {
                $nombre_descuento  = $this->gsatelite->get_campo('tdc_tipo_descuento', 'tdc_nombre', array('tdc_id' => $desc_pgr_id));
                $nombre_descuento .= ' ' . round($desc_pgr_pc, 2) . '%';
                $input_descuento  = '<input type="hidden" value="' . $desc_pgr_id . '" name="descuento_liq_id[]" />';
                $input_descuento .= '<input type="hidden" value="' . round($desc_pgr_pc, 2) . '" name="descuento_liq_porcent[]" />';
                $input_descuento .= '<input type="hidden" value="' . $desc_pgr . '" name="descuento_liq_monto[]" />';
                $html_descuento  .= "<tr><td>$input_descuento $nombre_descuento</td><td style='text-align: right;'>$desc_pgr</td></tr>";
                $total_descuento += $desc_pgr;
            }
            if ($total_descuento > 0 ){
                $html_descuento .= '<tr><td style="text-align:center;"><b><big>Total $</big></b></td><td style="text-align: right;"><b><big>';
                $html_descuento .= number_format($total_descuento, 2)  . '</big></b></td></tr>';
            }
            if (trim($html_ingreso) != "") {
                $respuesta['html_ingreso'] = $html_ingreso;
            }
            if (trim($html_descuento) != "") {
                $respuesta['html_descuento'] = $html_descuento;
            }
            if ($total_ingreso > 0 ) {
                $respuesta['total_pagar'] = ($total_ingreso - $total_descuento);
                $respuesta['total_ingreso'] = $total_ingreso;
                $respuesta['total_descuento'] = $total_descuento;
            }
        }
       echo json_encode($respuesta);
       die();
    }


    /**
      * @author René Castaneda
      * @since 11-09-2018
      * @return Generación de boleta
      */
    public function generar_boleta_liq($id_retiro = 0)
    {
        satelite_validar();
        $id_retiro = ($this->input->post())? $this->input->post('id_retiro'):$id_retiro;
        $info = $this->accion_personal_model->get_info_empleado_liquidacion(array('rte_id'=>$id_retiro));
        //generar la boleta, usando la función ya desarrollada en el módulo de planilla
        $this->load->library('../controllers/personal/planilla');
        $this->planilla->generar_boletas($info[0]['lqe_id_pla'],1);
    }

    function _cargarvista($data = 0, $crud = 0, $ruta_vista = "") {
        $this->load->view('vacia', $crud);
        if ($data != 0)
            $data = array_merge($data, $this->masterpage->getUsuario());
        else
            $data = $this->masterpage->getUsuario();
        $vista = ($ruta_vista != '') ? $ruta_vista : ($data['modulo'] . '/' . $data['control'] . '/' . $data['funcion']);
        $this->masterpage->setMasterPage('masterpage_default');
        $this->masterpage->addContentPage($vista, 'content', $data);
        $this->masterpage->show();
    }
    /**
     * Descripción:
     * Función verificar las dependencias de una plaza
     * @author Manuel Anzora - Grupo Satélite
     * @since  2018-12-07
     * @param  $emp: id del empleado
     * @return Finiquito de empleado retirado, despedido en doc word
     **/
    public function finiquito_empleado($emp_id=null, $id=null){
        $html = "";
        if($emp_id != null){
            $where = ['emp_id'=>$emp_id];
            $group = 'emp_id';
            $data=[];
            $notario['nombre'] = $this->gsatelite->get_campo('prm_parametro_empresa', 'prm_valor', array('prm_codigo'=>'SYS_NOMBRE_NOTARIO', 'prm_id_emr'=>$this->tank_auth->get_empresa_id()));
            $notario['domicilio'] = $this->gsatelite->get_campo('prm_parametro_empresa', 'prm_valor', array('prm_codigo'=>'SYS_DOMICILIO_NOTARIO', 'prm_id_emr'=>$this->tank_auth->get_empresa_id()));
            $data_emp = $this->expediente_personal_model->get_empleado_retirado($where,$group);
            $representante = $this->gsatelite->get_parametro_emp('ID_REPRESENTANTE_LEGAL');
            $band=0;
            if($representante!=''){
                $condition = ['emp_id'=>$representante];
                $data_rep = $this->expediente_personal_model->get_empleado_retirado($condition,null);
            }else{
                $band=1;
            }
            $repre_legal=[];
            foreach ($data_rep as $value) {
                $repre_legal=[
                    'nombre'=>$value['fullname'],
                    'direccion'=>$value['emp_direccion']
                ];
            }
            $data['representante_legal'] = $repre_legal;
            $data['notario'] = $notario;
            $info=[];
            $year = $this->enletras->num2letras(date('Y'));
            $dia = $this->enletras->num2letras(date('j'));
            $hora = $this->enletras->num2letras(date('H'));
            $minutos = $this->enletras->num2letras(date('i',strtotime(date('H:i:s'))));
            //UBICACION DE LA EMPRESA
            $info_emp = $this->gsatelite->get_registro('emr_empresa', array('emr_id' => $this->tank_auth->get_empresa_id()));
            $municipio = json_decode(json_encode($this->gsatelite->get_registro('mun_municipio', 'mun_id', $info_emp->emr_id_mun)), True);
            $data['municipio'] = $municipio;
            $data['pais'] = $this->gsatelite->get_registro('pai_pais', 'pai_id', $info_emp->emr_id_pai);            
            foreach ($data_emp as $value) {
                $age = '';
                $f_nac = $value['emp_fecha_nac'];
                if ($f_nac != '') {
                    $fec_n = explode('-', $f_nac);
                    $anio = date('Y');
                    $mes = date('m');
                    $day = date('d');
                    if ($fec_n[1] == $mes && $fec_n[2] > $day) {
                        $anio = $anio - 1;
                    }
                    if ($fec_n[1] > $mes) {
                        $anio = $anio - 1;
                    }
                    $age = $anio - $fec_n[0];
                }
                $edad = ($age != '') ? $this->enletras->num2letras($age) : '';
                $info=[
                    'empleado'=>$value['fullname'],
                    'profesion'=>$value['pro_nombre'],
                    'direccion'=>$value['emp_direccion'],
                    'documento'=>$value['dce_valor'],
                    'pais'=>$value['pai_nombre'],
                    'edad'         => $edad,
                    'puesto'       => $value['pto_nombre'],
                    'contratacion' => formatear_fecha('d-n-Y', $value['emp_fecha_contrato']),
                    'departamento'=>$value['dep_nombre'],
                    'municipio'=>$value['mun_nombre']
                ];
            }
            $data['empleado'] = $info;
            $data['year'] = strtolower($year);
            $data['dia'] = strtolower($dia);
            $data['hora'] = strtolower($hora);
            $data['minutos'] = strtolower($minutos);
            // $html .= $this->load->view('expediente_personal/empleado/finiquito_empleado', $data, true);     
            $empresa = strtolower(trim($this->gsatelite->get_parametro('SYS_SIGLAS')));
            if ($empresa != 'fya') {
                $html .= $this->load->view('expediente_personal/empleado/finiquito_empleado', $data, true);     
            } else {
                $empleado_data = array($info);
                $data['municipio'] = $this->gsatelite->get_registro('mun_municipio', 'mun_id', $info_emp->emr_id_mun);
                $data['empleados'] = $empleado_data;
                $data['siglas'] = $empresa;
                $html .= $this->load->view('expediente_personal/reportes/finiquito_empleado_masa', $data, true);     
            }
        }
        header('Content-type: application/vnd.ms-word');
        header('Content-Disposition: attachment;Filename=finiquito_empleado.doc');
        header("Pragma: no-cache");
        header("Expires: 0");
        echo '<html>';
        echo '<meta http-equiv=\'Content-Type\' content=\'text/html; charset=Windows-1252\'>';
        echo '<body style="font-family:Arial;" >';
        echo '<meta charset="utf-8" />';
        echo '<style type="text/css"> .inicio_contrato {  font-weight: bold;  }  .parrafo {    text-align: justify;  }</style>';
        echo $html;
        echo '</body></html>'; 
    }

    /*************************************************************************/
    // SE CAMBIA EL ORDEN DE LOS PARAMETROS, CUANDO $tipo_vista = 1 ES PORQUE SOLO SE MOSTRARA LA GRID DESDE UN REPORTE, $tipo_vista = 0 ES EL FLUJO NORMAL 
    public function anexos_accion_personal($tipo_vista, $acp_id) {
        try {
            $crud = new grocery_CRUD;
            $add = array(
                'nap_id_acp',
                'nap_nombre',
                'nap_url',
                'nap_estado',
                'nap_usu_creacion',
                'nap_fecha_creacion',
                'nap_usu_modificacion',
                'nap_fecha_modificacion'
            );
            $edit = array(
                'nap_id_acp',
                'nap_nombre',
                'nap_url',
                'nap_estado',
                'nap_usu_modificacion',
                'nap_fecha_modificacion'
            );
            $required = array(
                'nap_id_acp',
                'nap_nombre',
                'nap_url',
                'nap_estado',
                'nap_usu_modificacion',
                'nap_fecha_modificacion'
            );
            $alias = array(
                'nap_nombre' => 'Nombre',
                'nap_url' => 'Anexo',
                'nap_estado' => 'Estado'
            );
            $columns = array(
                'nap_nombre',
                'nap_url',
                'nap_estado'
            );
            $crud->set_table('nap_anexo_accion_personal')
                    ->set_subject('Anexo')
                    ->add_fields($add)
                    ->edit_fields($edit)
                    ->columns($columns)
                    ->display_as($alias)
                    ->field_type('nap_id_acp', 'hidden', $acp_id)
                    ->required_fields($required)
                    ->set_field_upload('nap_url', 'uploads/anx_accion_personal', 'Anexos')
                    ->field_type('nap_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
                    ->field_type('nap_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                    ->where('nap_id_acp', $acp_id)
            ;
            $crud->callback_before_upload(array($this, 'callback_before_upload_document'));
            if (end(explode('/', uri_string())) == 'add') {
                $crud->field_type('nap_estado', 'hidden', 1)
                        ->field_type('nap_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
                        ->field_type('nap_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                ;
            } else {
                $crud->field_type('nap_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }
            if ($tipo_vista > 0) {
                $crud->unset_export();
                $crud->unset_print();
                $crud->unset_read();
                $crud->unset_edit();
                $crud->unset_delete();
                $crud->unset_add();
            }
            $row_accion_personal = $this->gsatelite->get_tabla('acp_accion_personal',array('acp_id' =>$acp_id));
            $id_empleado = $row_accion_personal[0]['acp_id_emp'];
            $data['id_empleado'] = $id_empleado;
            $emp = $this->gsatelite->get_registro('emp_empleado', array('emp_id' => $id_empleado));
            $data['nombre_empleado'] = $emp->emp_nombre . ' ' . $emp->emp_apellido;
            $output = $crud->render();                    
            $data['titulo_personal'] = "Anexos de Accion de Personal";
            if ($tipo_vista > 0) {
                // SE MANDA A LLAMAR DESDE UN REPORTE, SOLO LA GRID DE ANEXOS
                $this->gsatelite->cargar_vista_masterpage('acciones_personal/principal/anexos_accion_personal',$data,$output);
            } else {
                $this->_cargarvista($data, $output);
            }            
        } catch (Exception $e) {
            show_error($e->getMessage() . ' --- ' . $e->getTraceAsString());
        }
    }

    /**
     * ====================
     * CALLBACKS
     * ===================
     * */

    /**
     * files_to_upload = información del archivo
     * field_info = información del path
     */
    function callback_before_upload_document($files_to_upload, $field_info) {

        $encrypted_name = $field_info->encrypted_field_name;

        $search = array("(", ")");

        //$files_to_upload[$encrypted_name]['name'] = str_replace($search, "_", $files_to_upload[$encrypted_name]['name']);

        if (strpos($files_to_upload[$encrypted_name]['name'], '(') || strpos($files_to_upload[$encrypted_name]['name'], ')') || strpos($files_to_upload[$encrypted_name]['name'], '&') || strpos($files_to_upload[$encrypted_name]['name'], '!') || strpos($files_to_upload[$encrypted_name]['name'], '%') || strpos($files_to_upload[$encrypted_name]['name'], '=') || strpos($files_to_upload[$encrypted_name]['name'], '$')) {

            return 'Elimine caracteres especiales en el nombre del archivo';
        } else {
            return true;
        }
    }

    /***********************************************************************************/
     /**
     * @author Elman Ortiz - Grupo Satélite
     * @since  2018-10-10
     * @author Raul E - Grupo Satélite
     * @since  2021-05-31
     * Se cambio la logica y los permisos que antes se guardaban en la acp_accion_personal vienen en realidad de la hxe_hora_extraxempleado JOIN thf_tipo_hora_faltante
     * @return Aprobacion de permisos
     */
    function aprobacion_permiso() {
        satelite_validar();
        if($this->input->post()) {
            $where = array();
            $html = '';
            $estado_permiso = (is_numeric($this->input->post('estado'))) ? $this->input->post('estado') : '';
            $fecha_ini = ($this->input->post('fecha_ini') != '') ? $this->input->post('fecha_ini') : '';
            $fecha_fin = ($this->input->post('fecha_fin') != '') ? $this->input->post('fecha_fin') : '';
            if(is_numeric($estado_permiso)) {
                $where['hxe_estado'] = $estado_permiso;
            }
            if ($fecha_ini != '') {
                $where['DATE(hxe_fecha) >= '] = formatear_fecha('Y-m-d', $fecha_ini);
            }
            if($fecha_fin != ''){
                $where['DATE(hxe_fecha) <= '] = formatear_fecha('Y-m-d', $fecha_fin);
            }
            $data['permisos_empleado'] = $this->accion_personal_model->get_permisos_empleado($where);            
            $html = $this->load->view('acciones_personal/principal/detalle_aprobacion_permiso', $data, true);
            
            echo $html;
            die();

        } else {
            $data['titulo_personal'] = "Autorización de Permiso";
            $this->_cargarvista($data);
        }        
    }

    function aprobar_compensatorios() {
        satelite_validar();
        if($this->input->post()) {
            $where = array();
            $estado_permiso = (is_numeric($this->input->post('estado'))) ? $this->input->post('estado') : '';
            $fecha_ini = ($this->input->post('fecha_ini') != '') ? $this->input->post('fecha_ini') : '';
            $fecha_fin = ($this->input->post('fecha_fin') != '') ? $this->input->post('fecha_fin') : '';
            if(is_numeric($estado_permiso)) {
                $where['tce_estado'] = $estado_permiso;
            }
            if ($fecha_ini != '') {
                $where['DATE(tce_fecha_creacion) >= '] = formatear_fecha('Y-m-d', $fecha_ini);
            }
            if($fecha_fin != ''){
                $where['DATE(tce_fecha_creacion) <= '] = formatear_fecha('Y-m-d', $fecha_fin);
            }
            $data['permisos_empleado'] = $this->accion_personal_model->get_compensatorios_empleado($where);            
            $html = $this->load->view('acciones_personal/principal/detalle_aprobacion_compensatorio', $data, true);
            echo $html;
            die();
        } else {
            $data['titulo_personal'] = "Autorización de Tiempos Compensatorios";
            $this->_cargarvista($data);
        }        
    }

     /**
     * @author Elman Ortiz - Grupo Satélite
     * @since  2019-05-02
     * @return Aprobacion de permisos
     */
    public function estado_aprobacion_permiso($id = null, $ver = null) {
        if($this->input->post()) {   
            // var_dump($_POST);die();            
            $estado        = $this->input->post('nuevo_estado');
            $observaciones = $this->input->post('aprobar_observacion');
            $tipo_planilla = ($this->input->post('tpl_descontar') != '') ? $this->input->post('tpl_descontar') : 0;
            $aplica        = $this->input->post('thf_id_tdc');
            $id_registro   = ($id > 0) ? $id : die('No se ha seleccionado ningun id para procesar la aprobacion');
            $verificar_uhp_registro = $this->gsatelite->get_registro('uhp_uso_horas_permisos', array('uhp_id_hxe' => $id_registro));
            if ($estado == 2) { //Aprobado
                $actualizar_per = array(
                    'hxe_id_usu_autoriza' => $this->tank_auth->get_user_id(),
                    'hxe_fecha_autorizacion' => date('Y-m-d H:i:s'),
                    'hxe_observacion_revision' => $observaciones,
                    'hxe_estado' => 2, 
                    'hxe_usu_mod' => $this->tank_auth->get_user_id(),
                    'hxe_fecha_mod' => date('Y-m-d H:i:s')
                );
                $registro = $this->gsatelite->actualizar_array('hxe_hora_extraxempleado', $actualizar_per, array('hxe_id' => $id_registro));
                $permiso = (array)$this->gsatelite->get_registro('hxe_hora_extraxempleado', array('hxe_id' => $id_registro));
                $verificar_reserva_horas = $this->gsatelite->get_tabla("hxc_hora_x_compensatorio", [
                    "hxc_id_hxe" => $id_registro,
                    "hxc_estado" => 2
                ]);
                if ($verificar_reserva_horas) {
                    foreach ($verificar_reserva_horas as $rev) {
                        $reg = $this->gsatelite->get_registro("tce_tiempo_compensatorio_empleado", [
                            "tce_id" => $rev["hxc_id_tce"]
                        ]);

                        $total = floatval($reg->tce_disponible);
                        $consumo = floatval($rev["hxc_horas"]);

                        $upArr = [
                            "tce_disponible" => $total - $consumo
                        ];

                        $this->gsatelite->actualizar_array('tce_tiempo_compensatorio_empleado', $upArr, ['tce_id' => $rev["hxc_id_tce"]]);
                        $this->gsatelite->actualizar_array('hxc_hora_x_compensatorio', ['hxc_estado' => 1], ['hxc_id' => $rev["hxc_id"]]);
                    }
                }

                // if ($permiso['dss_id_hxe'] != NULL && $tipo_planilla > 0 && $aplica > 0) {
                //     $activar_dss = array(
                //         'dss_id_tpl' => $planilla,
                //         'dss_estado' => 1,
                //         'dss_usu_mod' => $this->tank_auth->get_user_id(),
                //         'dss_fecha_mod' => date('Y-m-d H:i:s')
                //     );
                //     $resultado = $this->gsatelite->actualizar_array('dss_descuento', $activar_dss, array('dss_id' => $permiso['acp_id_dss']));
                // }
                if ($verificar_uhp_registro) {
                    $actualizar_uhp = array(
                        'uhp_autorizado' => 1,
                        'uhp_usu_autorizo' => $this->tank_auth->get_user_id(),
                        'uhp_fecha_autorizacion' => date('Y-m-d H:i:s'),
                        'uhp_observaciones' => $observaciones,
                        'uhp_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'uhp_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $actualizacion_uhp = $this->gsatelite->actualizar_array('uhp_uso_horas_permisos', $actualizar_uhp, array('uhp_id' => $verificar_uhp_registro->uhp_id));
                }                
                $hxpe = $this->gsatelite->get_tabla('hpe_hora_permiso_x_empleado', array('hpe_id_emp' => $permiso['hxe_id_emp'], 'hpe_id_thf' => $permiso['hxe_id_thf'])); 
                if (count($hxpe) > 0) {
                            $this->db->join('hxe_hora_extraxempleado', 'hxe_id = uhp_id_hxe');
                    $suma = $this->gsatelite->get_suma("uhp_uso_horas_permisos", 'uhp_numero_horas', array('hxe_id_emp' => $permiso['hxe_id_emp'], 'uhp_id_thf' => $permiso['hxe_id_thf'], 'uhp_autorizado' => 1, 'hxe_estado' => 2));
                    $actualizar_hpe = array(
                        'hpe_horas_utilizadas' => $suma,
                        'hpe_horas_disponible' => (($hxpe[0]['hpe_horas_limite'] - $suma) > 0) ? ($hxpe[0]['hpe_horas_limite'] - $suma) : 0,
                        'hpe_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'hpe_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->actualizar_array('hpe_hora_permiso_x_empleado', $actualizar_hpe, array('hpe_id' => $hxpe[0]['hpe_id']));
                }
                $empresa = strtolower(trim($this->gsatelite->get_parametro('SYS_SIGLAS', '')));
                $hxe_row = $this->gsatelite->get_registro('hxe_hora_extraxempleado', array('hxe_id' => $id_registro));
                $eslicen = $this->gsatelite->get_campo("thf_tipo_hora_faltante",'thf_licencia', array('thf_id' => $hxe_row->hxe_id_thf));
                if ($empresa == 'midem' && intval($eslicen) > 0) {
                    $data['id_licencia'] = $hxe_row->hxe_id;
                    $data['fecha_resol'] = date("Y-m-d");
                    $data['slc_empleado'] = $hxe_row->hxe_id_emp;
                    $data['nresolucion'] = $this->correlativo_resolucion(6);
                    $data['institucion'] = $this->gsatelite->get_tabla('emr_empresa', array('emr_id' => $this->tank_auth->get_empresa_id()))[0];
                    $html = $this->load->view('acciones_personal/principal/resol_concede_licencia_panama', $data, true);
                    $new_res = array(
                        'rxe_id_rsl' => 6,
                        'rxe_num_resolucion' => $data['nresolucion'],
                        'rxe_id_emp' => $hxe_row->hxe_id_emp,
                        'rxe_fecha_generado' => date("Y-m-d H:i:s"),
                        'rxe_html' => $html,
                        'rxe_estado' => 1,
                        'rxe_usu_creacion' => $this->tank_auth->get_user_id(),
                        'rxe_fecha_creacion' => date("Y-m-d H:i:s"),
                        'rxe_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'rxe_fecha_modificacion' => date("Y-m-d H:i:s")
                    );
                    $id_res = $this->gsatelite->ingresar('rxe_resolucionxempleado', $new_res);
                }
            } else if($estado == 3) { //Rechazado
                $actualizar_per = array(
                    'hxe_id_usu_anula' => $this->tank_auth->get_user_id(),
                    'hxe_fecha_anulacion' => date('Y-m-d H:i:s'),
                    'hxe_observacion_anulacion' => $observaciones,
                    'hxe_estado' => 0, 
                    'hxe_usu_mod' => $this->tank_auth->get_user_id(),
                    'hxe_fecha_mod' => date('Y-m-d H:i:s')
                );
                $registro = $this->gsatelite->actualizar_array('hxe_hora_extraxempleado', $actualizar_per, array('hxe_id' => $id_registro));
                $permiso = (array)$this->gsatelite->get_registro('hxe_hora_extraxempleado', array('hxe_id' => $id_registro)); 
                // if ($permiso['dss_id_hxe'] != NULL && $tipo_planilla > 0 && $aplica > 0) {
                //     $activar_dss = array(
                //         'dss_id_tpl' => $planilla,
                //         'dss_estado' => 1,
                //         'dss_usu_mod' => $this->tank_auth->get_user_id(),
                //         'dss_fecha_mod' => date('Y-m-d H:i:s')
                //     );
                //     $resultado = $this->gsatelite->actualizar_array('dss_descuento', $activar_dss, array('dss_id' => $permiso['acp_id_dss']));
                // }
                if ($verificar_uhp_registro) {
                    $actualizar_uhp = array(
                        //'uhp_usu_autorizo' => $this->tank_auth->get_user_id(),
                        //'uhp_fecha_autorizacion' => date('Y-m-d H:i:s'),
                        'uhp_observaciones' => $observaciones,
                        'uhp_estado' => 0,
                        'uhp_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'uhp_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $actualizacion_uhp = $this->gsatelite->actualizar_array('uhp_uso_horas_permisos', $actualizar_uhp, array('uhp_id' => $verificar_uhp_registro->uhp_id));
                }
                $hxpe = $this->gsatelite->get_tabla('hpe_hora_permiso_x_empleado', array('hpe_id_emp' => $permiso['hxe_id_emp'], 'hpe_id_thf' => $permiso['hxe_id_thf'])); 
                if (count($hxpe) > 0) {
                            $this->db->join('hxe_hora_extraxempleado', 'hxe_id = uhp_id_hxe');
                    $suma = $this->gsatelite->get_suma("uhp_uso_horas_permisos", 'uhp_numero_horas', array('hxe_id_emp' => $permiso['hxe_id_emp'], 'uhp_id_thf' => $permiso['hxe_id_thf'], 'uhp_autorizado' => 1, 'hxe_estado' => 2));
                    $actualizar_hpe = array(
                        'hpe_horas_utilizadas' => $suma,
                        'hpe_horas_disponible' => (($hxpe[0]['hpe_horas_limite'] - $suma) > 0) ? ($hxpe[0]['hpe_horas_limite'] - $suma) : 0,
                        'hpe_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'hpe_fecha_modificacion' => date('Y-m-d H:i:s')
                    );
                    $this->gsatelite->actualizar_array('hpe_hora_permiso_x_empleado', $actualizar_hpe, array('hpe_id' => $hxpe[0]['hpe_id']));
                }
            } else {
                die("No se ha seleccionado ningun estado para el permiso");
                redirect('');
            }
            $titulo = ($estado == 2) ? 'Aprobado' : 'Rechazado';
            $this->session->set_flashdata('registro', $registro);
            $this->session->set_flashdata('titulo', $titulo);
            redirect('acciones_personal/principal/estado_aprobacion_permiso');
        } else {
            $data['id'] = $id;
            $data['ver']= ($ver > 0) ? 1 : 0;
            $data['autorizacion'] = ($ver == 2) ? 1 : 0;
            $reg_permiso = $this->accion_personal_model->get_permisos_empleado(array('hxe_id' => $id));
            $data['det_permiso'] = $reg_permiso;
            $registro_documento =  $this->gsatelite->get_tabla('anh_anexo_hora_extra_empleado',array('anh_id_hxe' => @$reg_permiso[0]['hxe_id']));
            $data['archivos'] = $registro_documento; 
            $array_archivos = [];
            foreach ($registro_documento as $key => $documento) {
                $nombre_archivo = explode("/", $documento['anh_url']);
                if(isset($nombre_archivo) && $nombre_archivo != ""){ 
                    $extension_imagen = '';
                    $es_imagen = 0;
                    $es_pdf    = 0;
                    $elementos_de_archivo = [];
                    $ext_data = explode(".", end($nombre_archivo));
                    switch (strtolower(trim($ext_data[1]))) {
                        case 'docx':
                            $extension_imagen = 'docx';
                            break;
                        case 'doc':
                            $extension_imagen = 'doc';
                            break;
                        case 'pdf':
                            $extension_imagen = 'pdf';
                            $es_pdf = 1;
                            break;
                        case 'xlsx':
                            $extension_imagen = 'xlsx';
                            break;
                        case 'xls':
                            $extension_imagen = 'xls';
                            break;
                        case 'txt':
                            $extension_imagen = 'txt';
                            break;
                        case 'rar':
                            $extension_imagen = 'rar';
                            break;
                        case 'png':
                            $extension_imagen = 'png';
                            $es_imagen = 1;
                            break;
                        case 'jpg':
                            $extension_imagen = 'jpg';
                            $es_imagen = 1;
                            break;    
                        case 'jpeg':
                            $extension_imagen = 'jpeg';
                            $es_imagen = 1;
                            break;
                        default:
                            $extension_imagen = 'txt';
                            break;                    
                    }
                    $data['es_pdf'] = $es_pdf;
                    $data['es_imagen'] = $es_imagen;
                    $data['extension_imagen'] = $extension_imagen;
                    $elementos_de_archivo['es_imagen']        = $es_imagen;
                    $elementos_de_archivo['es_pdf']           = $es_pdf;
                    $elementos_de_archivo['extension_imagen'] = $extension_imagen;
                    $elementos_de_archivo['nombre_archivo']   = end($nombre_archivo);
                    array_push($array_archivos, $elementos_de_archivo);
                }
            }
            $data['array_archivos'] = $array_archivos;
                   $this->db->join('txe_tipo_planillaxempleado','tpl_id = txe_id_tpl');
            $pla = $this->gsatelite->get_dropdown('tpl_tipo_planilla','{tpl_prefijo} - {tpl_nombre}','',array('txe_id_emp'=>@$reg_permiso[0]['id_emp'],'tpl_estado'=>1), null, null,null,true);
            $data['tipo_planillas'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $pla);
            $data['titulo_personal'] = "Autorización de Permiso";
            $this->gsatelite->cargar_vista_masterpage('acciones_personal/principal/estado_aprobacion_permiso', $data);
        }        
    }

    public function estado_aprobacion_vacacion($sltid=null, $autogestion=null){
        satelite_validar();
        if($this->input->post()) {      
            $estado        = $this->input->post('nuevo_estado');
            $observaciones = $this->input->post('aprobar_observacion');
            $id_registro   = $this->input->post('id_solicitud');
            $empresa = strtolower(trim($this->gsatelite->get_parametro('SYS_SIGLAS', '')));
            if ($estado > 2) {
                //RECHAZADO
                $actualizar = array(
                    'slv_id_usu_rechaza' => $this->tank_auth->get_user_id(),
                    'slv_comentario_rechaza'  => $observaciones,
                    'slv_estado' => 0,
                    'slv_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'slv_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                $registro = $this->gsatelite->actualizar_array('slv_solicitud_vacacion', $actualizar, array('slv_id' => $id_registro));
            } else {
                //autorizado
                $solicitud_vacacion = $this->gsatelite->get_registro('slv_solicitud_vacacion', array('slv_id' => $id_registro));
                $array_detalle = array(
                    'gva_id_emp' => $solicitud_vacacion->slv_id_emp,
                    'gva_id_vac' => $solicitud_vacacion->slv_id_vac,
                    'gva_desde' => $solicitud_vacacion->slv_fecha_desde,
                    'gva_hasta' => $solicitud_vacacion->slv_fecha_hasta,
                    'gva_dias' => $solicitud_vacacion->slv_cantidad_dias,
                    'gva_tipo_calculo' => 1, // tipo de cálculo 1 (registro de la transaccion del monto de vacacion)
                    'gva_estado' => 1,
                    'gva_fecha_creacion' => date("Y-m-d H:i:s"),
                    'gva_usu_creacion' => $this->tank_auth->get_user_id(),
                    'gva_fecha_modificacion' => date("Y-m-d H:i:s"),
                    'gva_usu_modificacion' => $this->tank_auth->get_user_id()
                );
                $id_detalle_gva = $this->gsatelite->ingresar('gva_goce_vacacion', $array_detalle);
                $registro_vacacion = $this->gsatelite->get_registro('vac_vacacion', array('vac_id' => $solicitud_vacacion->slv_id_vac));
                $nDias = $solicitud_vacacion->slv_cantidad_dias;                
                $ngozado = $nDias + (($registro_vacacion->vac_dia_gozado) ? $registro_vacacion->vac_dia_gozado : 0);
                $nresta = $registro_vacacion->vac_dia_ganado - $ngozado;
                $estado = ($nresta == 0) ? 0 : 1;
                $update_vac = array(
                    'vac_dia_gozado' => $ngozado,
                    'vac_estado' => $estado,
                    'vac_fecha_modificacion' => date("Y-m-d H:i:s"),
                    'vac_usu_modificacion' => $this->tank_auth->get_user_id()
                );
                $this->gsatelite->actualizar_array('vac_vacacion', $update_vac, array('vac_id' => $solicitud_vacacion->slv_id_vac));
                $actualizar = array(
                    'slv_id_gva' => $id_detalle_gva,
                    'slv_id_usu_autoriza' => $this->tank_auth->get_user_id(),
                    'slv_comentario_autoriza'  => $observaciones,
                    'slv_estado' => 2,
                    'slv_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'slv_fecha_modificacion' => date('Y-m-d H:i:s')
                );
                $registro = $this->gsatelite->actualizar_array('slv_solicitud_vacacion', $actualizar, array('slv_id' => $id_registro));
                $id_emp = $solicitud_vacacion->slv_id_emp;                
                $empresa = strtolower(trim($this->gsatelite->get_parametro('SYS_SIGLAS', '')));
                if ($empresa == 'midem') {
                    $update_emp = array(
                        'emp_fecha_ult_vacacion' => formatear_fecha("Y-m-d", $solicitud_vacacion->slv_fecha_hasta),
                        'emp_usu_mod' => $this->tank_auth->get_user_id(),
                        'emp_fecha_mod' => date("Y-m-d H:i:s")
                    );
                    $this->gsatelite->actualizar_array('emp_empleado', $update_emp, array('emp_id' => $id_emp));
                }
            }
            $titulo = ($estado > 2) ? 'Rechazado' : 'Aprobado';
            $this->session->set_flashdata('registro', $registro);
            $this->session->set_flashdata('titulo', $titulo);
            redirect('acciones_personal/principal/estado_aprobacion_vacacion');
        } else {
            $data['id'] = $sltid;
            // $data['ver']= ($ver > 0) ? 1 : 0;
            $data['autogestion'] = ($autogestion == 1) ? 1 : 0;
            $solicitud_vaca = $this->accion_personal_model->get_info_solicitud(array('slv_id' => $sltid));
            $data['vdisponibles'] = $solicitud_vaca;
            $data['titulo_personal'] = "Autorización de Vacaciones";
            $this->gsatelite->cargar_vista_masterpage('acciones_personal/principal/estado_aprobacion_vacaciones', $data);
        }        
    }

    public function vistobueno($id = null){
        satelite_validar();
        if($this->input->post()) {      
            $id_permiso = $this->input->post('idHxe');
            $observaciones = $this->input->post('aprobar_observacion');
            $registro = $this->gsatelite->get_registro('hxe_hora_extraxempleado', array('hxe_id' => $id_permiso));
            $txt = $registro->hxe_observacion_revision . " || (" . date('d-m-Y') . ") ";
            $update_hxe = array(
                'hxe_observacion_revision' => $txt . trim($observaciones),
                'hxe_enterado_rrhh' => 1,
                'hxe_usu_mod' => $this->tank_auth->get_user_id(),
                'hxe_fecha_mod' => date("Y-m-d H:i:s")
            );
            $upd = $this->gsatelite->actualizar('hxe_hora_extraxempleado', $update_hxe, 'hxe_id', $id_permiso);
            $this->session->set_flashdata('registro', ($upd + 1));
            redirect('acciones_personal/principal/vistobueno');
        } else {
            $data['id'] = $id;
            $reg_permiso = $this->accion_personal_model->get_permisos_empleado(array('hxe_id' => $id));
            $registro_documento =  $this->gsatelite->get_tabla('anh_anexo_hora_extra_empleado',array('anh_id_hxe' => @$reg_permiso[0]['hxe_id']));
            $data['det_permiso'] = $reg_permiso;
            $data['archivos'] = $registro_documento; 
            $array_archivos = [];
            if (count($registro_documento) > 0) {
                foreach ($registro_documento as $key => $documento) {
                    $nombre_archivo = explode("/", $documento['anh_url']);
                    if(isset($nombre_archivo) && $nombre_archivo != ""){ 
                        $extension_imagen = '';
                        $es_imagen = 0;
                        $es_pdf    = 0;
                        $elementos_de_archivo = [];
                        $ext_data = explode(".", end($nombre_archivo));
                        switch (strtolower(trim($ext_data[1]))) {
                            case 'docx':
                            $extension_imagen = 'docx';
                            break;
                            case 'doc':
                            $extension_imagen = 'doc';
                            break;
                            case 'pdf':
                            $extension_imagen = 'pdf';
                            $es_pdf = 1;
                            break;
                            case 'xlsx':
                            $extension_imagen = 'xlsx';
                            break;
                            case 'xls':
                            $extension_imagen = 'xls';
                            break;
                            case 'txt':
                            $extension_imagen = 'txt';
                            break;
                            case 'rar':
                            $extension_imagen = 'rar';
                            break;
                            case 'png':
                            $extension_imagen = 'png';
                            $es_imagen = 1;
                            break;
                            case 'jpg':
                            $extension_imagen = 'jpg';
                            $es_imagen = 1;
                            break;    
                            case 'jpeg':
                            $extension_imagen = 'jpeg';
                            $es_imagen = 1;
                            break;
                            default:
                            $extension_imagen = 'txt';
                            break;                    
                        }
                        $data['es_pdf'] = $es_pdf;
                        $data['es_imagen'] = $es_imagen;
                        $data['extension_imagen'] = $extension_imagen;
                        $elementos_de_archivo['es_imagen']        = $es_imagen;
                        $elementos_de_archivo['es_pdf']           = $es_pdf;
                        $elementos_de_archivo['extension_imagen'] = $extension_imagen;
                        $elementos_de_archivo['nombre_archivo']   = end($nombre_archivo);
                        array_push($array_archivos, $elementos_de_archivo);
                    }
                }
            }
            $data['array_archivos'] = $array_archivos;
            $data['titulo_personal'] = "Valiación de Permiso";
            $this->gsatelite->cargar_vista_masterpage('acciones_personal/principal/vistobueno', $data);
        }        
    }


    public function estado_aprobacion_compensatorio($id = null, $ver = null) {
        if($this->input->post()) {   
            // var_dump($_POST);die();            
            $estado        = $this->input->post('nuevo_estado');
            $observaciones = $this->input->post('aprobar_observacion');
            $id_registro   = ($id > 0) ? $id : die('No se ha seleccionado ningun id para procesar la aprobacion');
            // $verificar_uhp_registro = $this->gsatelite->get_registro('uhp_uso_horas_permisos', array('uhp_id_hxe' => $id_registro));////?????????
            if ($estado == 2) { //Aprobado
                $horas = $this->input->post('ctdad_horas');
                $actualizar_per = array(
                    "tce_disponible" => $horas,
                    "tce_id_usu_autoriza" => $this->tank_auth->get_user_id(),
                    "tce_fecha_autorizacion" => date('Y-m-d H:i:s'),
                    "tce_observacion_aprobar_anular" => $observaciones,
                    "tce_estado" => 2,
                    "tce_usu_modificacion" => $this->tank_auth->get_user_id(),
                    "tce_fecha_modificacion" =>  date('Y-m-d H:i:s')
                );
                $registro = $this->gsatelite->actualizar_array('tce_tiempo_compensatorio_empleado', $actualizar_per, array('tce_id' => $id_registro));                
            } else if($estado == 0) { //Rechazado
                $actualizar_per = array(
                    "tce_id_usu_anula" => $this->tank_auth->get_user_id(),
                    "tce_fecha_anulacion" => date('Y-m-d H:i:s'),
                    "tce_observacion_aprobar_anular" =>  $observaciones,
                    "tce_estado" => 0,
                    "tce_usu_modificacion" =>  $this->tank_auth->get_user_id(),
                    "tce_fecha_modificacion" =>  date('Y-m-d H:i:s')
                );
                $registro = $this->gsatelite->actualizar_array('tce_tiempo_compensatorio_empleado', $actualizar_per, array('tce_id' => $id_registro));
            } else {
                die("No se ha seleccionado ningun estado para el permiso");
                redirect('');
            }
            $titulo = ($estado == 2) ? 'Aprobado' : 'Rechazado';
            $this->session->set_flashdata('registro', $registro);
            $this->session->set_flashdata('titulo', $titulo);
            redirect("acciones_personal/principal/estado_aprobacion_compensatorio/$id_registro");
        } else {
            $data['id'] = $id;
            $data['ver']= ($ver > 0) ? 1 : 0;
            $data['autorizacion'] = (is_null($ver)) ? 1 : 0;
            $reg_permiso = $this->accion_personal_model->get_compensatorios_empleado(array('tce_id' => $id));
            $data['det_permiso'] = $reg_permiso;
            $array_archivos = array();
            $anexo_documento =  $this->gsatelite->get_tabla('anc_anexo_tiempo_compensar_emp',array('anc_id_tce' => $reg_permiso[0]['tce_id']));
            foreach ($anexo_documento as $key => $documento) {
                $nombre_archivo = explode("/", $documento['anh_url']);
                if(isset($nombre_archivo) && $nombre_archivo != ""){
                    $extension_imagen = '';
                    $es_imagen = 0;
                    $es_pdf    = 0;
                    $elementos_de_archivo = [];
                    $ext_data = explode(".", end($nombre_archivo));
                    switch (strtolower(trim($ext_data[1]))) {
                        case 'docx':
                            $extension_imagen = 'docx';
                            break;
                        case 'doc':
                            $extension_imagen = 'doc';
                            break;
                        case 'pdf':
                            $extension_imagen = 'pdf';
                            $es_pdf = 1;
                            break;
                        case 'xlsx':
                            $extension_imagen = 'xlsx';
                            break;
                        case 'xls':
                            $extension_imagen = 'xls';
                            break;
                        case 'txt':
                            $extension_imagen = 'txt';
                            break;
                        case 'rar':
                            $extension_imagen = 'rar';
                            break;
                        case 'png':
                            $extension_imagen = 'png';
                            $es_imagen = 1;
                            break;
                        case 'jpg':
                            $extension_imagen = 'jpg';
                            $es_imagen = 1;
                            break;    
                        case 'jpeg':
                            $extension_imagen = 'jpeg';
                            $es_imagen = 1;
                            break;
                        default:
                            $extension_imagen = 'txt';
                            break;                    
                    }
                    $data['es_pdf'] = $es_pdf;
                    $data['es_imagen'] = $es_imagen;
                    $data['extension_imagen'] = $extension_imagen;
                    $elementos_de_archivo['es_imagen']        = $es_imagen;
                    $elementos_de_archivo['es_pdf']           = $es_pdf;
                    $elementos_de_archivo['extension_imagen'] = $extension_imagen;
                    $elementos_de_archivo['nombre_archivo']   = end($nombre_archivo);
                    array_push($array_archivos, $elementos_de_archivo);
                }
            }            
            $data['archivos'] = $anexo_documento; 
            $data['array_archivos'] = $array_archivos;
            $data['titulo_personal'] = "Autorización de Tiempo Compensatorio";
            $this->gsatelite->cargar_vista_masterpage('acciones_personal/principal/state_aprobacion_compensatorio', $data);
        }        
    }

    public function get_tipo_incapacidad(){
        $tnc   = $this->input->post('tnc');
        $emple = $this->input->post('emple');
        $dias  = $this->input->post('dias');
        $inicio  = $this->input->post('inicia');
        if ($tnc !== '') {
            $where['tnc_id'] = $tnc;
            $info   = $this->accion_personal_model->get_configuracion_incapacidad(array('tnc_id' => $tnc));
            //si aplica planilla se hara el descuento de dias y el ingreso si aplica
            $aplica_planilla = ($info[0]['tnc_aplica_planilla'] > 0) ? true : false;
            $emp = $this->gsatelite->get_tabla('emp_empleado', array('emp_id' => $emple));
            $salary_by_incomes = $this->planilla_model->get_salary_from_incomes($emple);
            $sueldo = ($emp[0]['emp_salario'] > 0) ? $emp[0]['emp_salario'] : $salary_by_incomes;
            $exito  = 1;
            if ((is_array($info)) && (count($info) >0) ) {
                //construimos las variables
                $salario           = $sueldo;
                $salario_calculado = ($sueldo > $info[0]['tnc_salario_maximo']) ? $info[0]['tnc_salario_maximo'] : $sueldo;
                $limite            = $info[0]['tnc_salario_maximo'];
                $exceso            = (($salario - $limite) < 0) ? 0 : abs($salario - $limite);
                $monto_empresa     = 0;
                $monto_diferen     = 0;
                $monto_seguro      = 0;
                $a_pagar_empr      = 0;
                $decimales         = $this->gsatelite->get_parametro('NUMERO_DECIMALES');
                $dias_mes          = $this->gsatelite->get_parametro('DIAS_TRABAJADOS_MES', 30);
                $id_descuento_isss = $this->gsatelite->get_parametro('DESCUENTO_ISS');
                $pago_diario       = $salario / $dias_mes;
                $nuevo_salario     = ($salario) - ($dias * $pago_diario);
                $total1 = $total2 = $total3 = 0;
                $inns = array();
                if ($dias !== '') {
                    foreach ($info as $key => $reg) {
                        $montorow = 0;
                        $dias_ini   = $reg['cti_cantidad_desde'];
                        $dias_final = $reg['cti_cantidad_hasta'];
                        if ($dias >= $dias_ini && $dias >= $dias_final) {
                            $dias_ = ($dias_final - $dias_ini) + 1;
                            // $caso = 'cubre todo';
                        } elseif ($dias >= $dias_ini && $dias <= $dias_final) {
                            $dias_ = ($dias - $dias_ini) + 1;
                            // $caso = 'cubre parcial';
                        } else {
                            $dias_ = 0;
                            // $caso = 'no aplica';
                        }
                        // Calculo empresa
                        if ($reg['cti_porcentaje_subsidio'] > 0) {
                            $total1        = ((($salario_calculado / $dias_mes) * ($reg['cti_porcentaje_subsidio'] / 100)) * $dias_);
                            $monto_empresa += $total1;
                            $a_pagar_empr  += $total1;
                            $montorow += $total1;
                        }
                        // Calculo del seguro
                        if ($reg['cti_porcentaje_seguro'] > 0) {
                            $total3        = ($dias_ * (($salario_calculado / $dias_mes) * ($reg['cti_porcentaje_seguro'] / 100)));                            
                            $monto_seguro  += $total3;
                        }
                        // Calculo diferencia empresa
                        if ($reg['cti_porcentaje_diferencia'] > 0) {
                            $total2        = ($dias_ * (($exceso / $dias_mes) * ($reg['cti_porcentaje_diferencia'] / 100)));
                            $monto_diferen += $total2;
                            $a_pagar_empr  += $total2;
                            $montorow += $total2;
                        }
                        if ($reg['cti_id_tig'] > 0) {
                            $inns[$key] = $reg['cti_id_tig'] . '##' .  $montorow;
                        }
                    }
                }   
            }else{
                $exito = 0;
            }
            $ingresos = implode("&&", $inns);
            $termina = "";
            if (trim($inicio) != "" && $dias != "") {
                $d = ($dias - 1);
                $f_ini_inc = date("Y-m-d", strtotime($inicio));
                $f_fin_inc = date("Y-m-d", strtotime("$f_ini_inc +$d day"));
                $termina = formatear_fecha('d-m-Y', $f_fin_inc);
            }
            $empresa = strtolower(trim($this->gsatelite->get_parametro('SYS_SIGLAS', '')));
            if ($empresa == 'midem') {
                $fini = date('Y') . '-01-01';
                $ffin = date('Y') . '-12-31';
                $sumdias = 0;
                $horas_d = $this->gsatelite->get_parametro('HORAS_TRABAJADAS_DIA', '8');
                $emp_row = $this->gsatelite->get_registro('emp_empleado', array('emp_id' => $emple)); 
                $inc = $this->gsatelite->get_suma('inc_incapacidad', 'inc_dias', array('inc_estado' => 1, 'inc_id_emp' => $emple, "inc_fecha_inicio BETWEEN '$fini' AND '$ffin'" => null));
                       $this->db->join('thf_tipo_hora_faltante', 'thf_id = hxe_id_thf');
                $hxe = $this->gsatelite->get_suma("hxe_hora_extraxempleado", "hxe_num_hora", array("hxe_id_thf IS NOT NULL" => null, "hxe_estado >" => 1, "hxe_id_emp" => $emple, "hxe_fecha BETWEEN '$fini' AND '$ffin'" => null, '(thf_licencia = 0 OR thf_licencia IS NULL)' => null));
                $sumdias += floor($hxe / $horas_d);
                $sumdias += $inc;
                $sumdias += intval($dias);
                $dias_limite = ($emp_row->emp_discapacidad == 1) ? 24 : 18;
                if ($sumdias <= $dias_limite) {
                    $restringe_incapacidad = 0;
                } else {
                    $restringe_incapacidad = 1;
                }
            } else {
                $restringe_incapacidad = 0;
            }
            $respueta = array(
                'estado' => $exito,
                'aplica_planilla' => $aplica_planilla,
                'monto_seguro' => number_format($monto_seguro,$decimales,'.',''),
                'monto_empresa' => number_format($a_pagar_empr,$decimales,'.',''),
                'salario' => number_format($salario,$decimales,'.',''),
                'nuevo_salario' => ($nuevo_salario > 0) ? number_format($nuevo_salario,$decimales,'.','') : 0,
                'dias' => $dias,
                'final' => $termina,
                'restringe' => $restringe_incapacidad,
                'detalle_tigs' => $ingresos,
                'porcentaje_subsidio' => number_format($monto_empresa, $decimales, '.', ''),
                'porcentaje_diferencia' => number_format($monto_diferen, $decimales, '.', '')
            );
            echo json_encode($respueta);
        }
    }

    /**
      * @author Marlon Olmedo
      * @since 03-08-2020
      * @return validacion de existencia de 
      */
    public function validar_fecha_promocion(){
        satelite_validar();

        $fecha = ($this->input->post('fecha'))? formatear_fecha('Y-m-d',$this->input->post('fecha')):NULL;
        $id_emp = ($this->input->post('id_emp'))? $this->input->post('id_emp'):NULL;
        $id_pps = ($this->input->post('id_pps'))? $this->input->post('id_pps'):NULL;

        $where["date( pps_fecha_desde ) >= '$fecha'"] =NULL;
        $where["pps_id_emp"] = $id_emp;

        if ($id_pps != null) {
            $where["pps_id NOT IN($id_pps)"] = NULL;
        }
        
        $this->db->where($where, null,false);
        $info = $this->gsatelite->get_tabla("pps_promocion_plaza_salarioxemp");
        //print_r($this->db->last_query());die();
        if (!empty($info)) {
            echo count($info);
        } else {
            echo 0;
        }
        die();
    }


    function duplicar_plaza($id_plaza = null, $num_plazas = null, $retornar_valor = null) {
        satelite_validar();
        $plz_id = 0;
        $cantidad = 0;
        $ajax = false;

        $plz_id = $id_plaza;
        $cantidad = $num_plazas;
        // if ($_POST) {
        //     $ajax = true;
        //     $plz_id = $this->input->post('id_plaza');
        //     $cantidad = $this->input->post('cantidad');
        // }
        
        //var_dump($cantidad);die();
        $this->gsatelite->verificar_registro_real('plz_plaza', $plz_id);
        $plaza = $this->gsatelite->get_tabla('plz_plaza', array('plz_id' => $plz_id));
        $plaza = $plaza[0];
        
        //Se obtienen los generos por plaza
        $generos_plaza = $this->gsatelite->get_tabla('gxp_generoxplaza', array('gxp_id_plz' => $plz_id));

        //Se obtienen los grados academicos por plaza
        $profesion_plaza = $this->gsatelite->get_tabla('prp_profesion_plaza', array('prp_id_plz' => $plz_id));
        
        $funciones_plaza = $this->gsatelite->get_tabla('fxl_funcionxplaza', array('fxl_id_plz' => $plz_id));
        $espacios_plaza = $this->gsatelite->get_tabla('exp_espacioxplaza', array('exp_id_plz' => $plz_id));
        $herramientas_plaza = $this->gsatelite->get_tabla('hxp_herramientaxplaza', array('hxp_id_plz' => $plz_id));
        $prestaciones_plaza = $this->gsatelite->get_tabla('pxz_prestacionxplaza', array('pxz_id_plz' => $plz_id));

        $competencias_plaza = $this->estructura_organizativa_model->get_competencias_plaza(array('cpz_id_plz' => $plz_id));
        $logros_plaza = $this->estructura_organizativa_model->get_logros_plaza(array('arp_id_plz' => $plz_id));
        $riesgos_plaza = $this->estructura_organizativa_model->get_riesgos_plaza(array('rxl_id_plz' => $plz_id));
        $anexos_plaza = $this->gsatelite->get_tabla('axp_anexoxplaza', array('axp_id_plz' => $plz_id));

        $exito = 0;
        for ($j = 0; $j < $cantidad; $j++) {
            $plaza_array = array(
                'plz_nombre' => $plaza['plz_nombre'],
                'plz_id_pto' => $plaza['plz_id_pto'],
                'plz_id_are' => $plaza['plz_id_are'],
                'plz_id_cec' => $plaza['plz_id_cec'],
                'plz_id_padre' => $plaza['plz_id_padre'],
                'plz_edad_maxima' => $plaza['plz_edad_maxima'],
                'plz_edad_minima' => $plaza['plz_edad_minima'],
                'plz_id_org' => $plaza['plz_id_org'],
                'plz_ubicacion_especifica' => $plaza['plz_ubicacion_especifica'],
                'plz_id_tie' => $plaza['plz_id_tie'],
                //'plz_id_gen' => $plaza['plz_id_gen'],
                //'plz_id_pro' => $plaza['plz_id_pro'],
                'plz_id_deh' => $plaza['plz_id_deh'],
                'plz_bono' => $plaza['plz_bono'],
                'plz_pago_hora_extra' => $plaza['plz_pago_hora_extra'],
                'plz_descripcion_mejora' => $plaza['plz_descripcion_mejora'],
                'plz_salario_base' => $plaza['plz_salario_base'],
                //'plz_horario' => $plaza['plz_horario'],
                'plz_alcance_decision' => $plaza['plz_alcance_decision'],
                'plz_competencia_basica' => $plaza['plz_competencia_basica'],
                'plz_plan_carrera' => $plaza['plz_plan_carrera'],
                'plz_estado' => 1,
                'plz_id_emr' => $this->tank_auth->get_empresa_id(),
                'plz_usu_creacion' => $this->tank_auth->get_user_id(),
                'plz_fecha_creacion' => date('Y-m-d H:i:s'),
                'plz_usu_modificacion' => $this->tank_auth->get_user_id(),
                'plz_fecha_modificacion' => date('Y-m-d H:i:s')
            );

            //Se ingresa la plaza
            $plz_nueva = $this->gsatelite->ingresar('plz_plaza', $plaza_array);
            if ($plz_nueva > 0) {
                
                //Se procesan los generos
                if (count($generos_plaza) > 0) {
                    for ($i = 0; $i < count($generos_plaza); $i++) {
                        $generos_array = array(
                            'gxp_id_gen' => $generos_plaza[$i]['gxp_id_gen'],
                            'gxp_id_plz' => $plz_nueva,
                            'gxp_estado' => 1,
                            'gxp_usu_creacion' => $this->tank_auth->get_user_id(),
                            'gxp_fecha_creacion' => date('Y-m-d H:i:s'),
                            'gxp_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'gxp_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('gxp_generoxplaza', $generos_array);
                    }
                }
                
                //Se procesan los grados academicos.
                if (count($profesion_plaza) > 0) {
                    for ($i = 0; $i < count($profesion_plaza); $i++) {
                        $grados_array = array(
                            'prp_id_pro' => $profesion_plaza[$i]['prp_id_pro'],
                            'prp_id_plz' => $plz_nueva,
                            'prp_estado' => 1,
                            'prp_usu_creacion' => $this->tank_auth->get_user_id(),
                            'prp_fecha_creacion' => date('Y-m-d H:i:s'),
                            'prp_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'prp_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('prp_profesion_plaza', $grados_array);
                    }
                }
                
                
                //Se procesan las funciones
                if (count($funciones_plaza) > 0) {
                    for ($i = 0; $i < count($funciones_plaza); $i++) {
                        $funciones_array = array(
                            'fxl_id_fun' => $funciones_plaza[$i]['fxl_id_fun'],
                            'fxl_id_plz' => $plz_nueva,
                            'fxl_estado' => 1,
                            'fxl_usu_creacion' => $this->tank_auth->get_user_id(),
                            'fxl_fecha_creacion' => date('Y-m-d H:i:s'),
                            'fxl_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'fxl_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('fxl_funcionxplaza', $funciones_array);
                    }
                }

                //Se procesan las competencias
                if (count($competencias_plaza) > 0) {
                    for ($i = 0; $i < count($competencias_plaza); $i++) {
                        $competencias_array = array(
                            'cpz_id_com' => $competencias_plaza[$i]['cpz_id_com'],
                            'cpz_id_cls' => $competencias_plaza[$i]['cpz_id_cls'],
                            'cpz_id_plz' => $plz_nueva,
                            'cpz_estado' => 1,
                            'cpz_usu_creacion' => $this->tank_auth->get_user_id(),
                            'cpz_fecha_creacion' => date('Y-m-d H:i:s'),
                            'cpz_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'cpz_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('cpz_competencia_plaza', $competencias_array);
                    }
                }

                //se procesan los logros
                if (count($logros_plaza) > 0) {
                    for ($i = 0; $i < count($logros_plaza); $i++) {
                        $logros_array = array(
                            'arp_id_are' => $logros_plaza[$i]['arp_id_are'],
                            'arp_id_acl' => $logros_plaza[$i]['arp_id_acl'],
                            'arp_id_pot' => $logros_plaza[$i]['arp_id_pot'],
                            'arp_id_plz' => $plz_nueva,
                            'arp_estado' => 1,
                            'arp_usu_creacion' => $this->tank_auth->get_user_id(),
                            'arp_fecha_creacion' => date('Y-m-d H:i:s'),
                            'arp_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'arp_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('arp_area_resultadoxplaza', $logros_array);
                    }
                }

                //Se procesan los espacios
                if (count($espacios_plaza) > 0) {
                    for ($i = 0; $i < count($espacios_plaza); $i++) {
                        $espacios_array = array(
                            'exp_id_ept' => $espacios_plaza[$i]['exp_id_ept'],
                            'exp_id_plz' => $plz_nueva,
                            'exp_estado' => 1,
                            'exp_usu_creacion' => $this->tank_auth->get_user_id(),
                            'exp_fecha_creacion' => date('Y-m-d H:i:s'),
                            'exp_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'exp_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('exp_espacioxplaza', $espacios_array);
                    }
                }


                //Se procesan las herramientas
                if (count($herramientas_plaza) > 0) {
                    for ($i = 0; $i < count($herramientas_plaza); $i++) {
                        $herramientas_array = array(
                            'hxp_id_hrt' => $herramientas_plaza[$i]['hxp_id_hrt'],
                            'hxp_id_plz' => $plz_nueva,
                            'hxp_estado' => 1,
                            'hxp_usu_creacion' => $this->tank_auth->get_user_id(),
                            'hxp_fecha_creacion' => date('Y-m-d H:i:s'),
                            'hxp_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'hxp_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('hxp_herramientaxplaza', $herramientas_array);
                    }
                }

                //Se procesan los riesgos de la plaza
                if (count($riesgos_plaza) > 0) {
                    for ($i = 0; $i < count($riesgos_plaza); $i++) {
                        $riesgos_array = array(
                            'rxl_id_tri' => $riesgos_plaza[$i]['rxl_id_tri'],
                            'rxl_id_nir' => $riesgos_plaza[$i]['rxl_id_nir'],
                            'rxl_id_plz' => $plz_nueva,
                            'rxl_estado' => 1,
                            'rxl_usu_creacion' => $this->tank_auth->get_user_id(),
                            'rxl_fecha_creacion' => date('Y-m-d H:i:s'),
                            'rxl_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'rxl_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('rxl_riesgoxplaza', $riesgos_array);
                    }
                }

                //Se procesan las prestaciones
                if (count($prestaciones_plaza) > 0) {
                    for ($i = 0; $i < count($prestaciones_plaza); $i++) {
                        $prestaciones_array = array(
                            'pxz_id_prt' => $prestaciones_plaza[$i]['pxz_id_prt'],
                            'pxz_id_plz' => $plz_nueva,
                            'pxz_estado' => 1,
                            'pxz_usu_creacion' => $this->tank_auth->get_user_id(),
                            'pxz_fecha_creacion' => date('Y-m-d H:i:s'),
                            'pxz_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'pxz_fecha_modificacion' => date('Y-m-d H:i:s')
                        );
                        $this->gsatelite->ingresar('pxz_prestacionxplaza', $prestaciones_array);
                    }
                }

                if (count($anexos_plaza) > 0) {
                    for ($i = 0; $i < count($anexos_plaza); $i++) {
                        $nombreAnexo = end(explode('/', $anexos_plaza[$i]['axp_url']));
                        $tituloAnexo = explode('.', $nombreAnexo);

                        $extension = end(explode('.', $nombreAnexo));
                        $carpeta_temporal_anx = $ruta = "uploads/anx_plazas/" . trim($nombreAnexo);

                        $nombreArchivo = trim($tituloAnexo[0]) . $plz_nueva . "." . trim($extension);

                        $carpeta_destino_anx = "uploads/anx_plazas/" . $nombreArchivo;

                        $documentos_array = array(
                            'axp_id_plz' => $plz_nueva,
                            'axp_url' => $carpeta_destino_anx,
                            'axp_nombre' => $anexos_plaza[$i]['axp_nombre'],
                            'axp_estado' => 1,
                            'axp_usu_creacion' => $this->tank_auth->get_user_id(),
                            'axp_fecha_creacion' => date('Y-m-d H:i:s'),
                            'axp_usu_modificacion' => $this->tank_auth->get_user_id(),
                            'axp_fecha_modificacion' => date('Y-m-d H:i:s'),
                        );

                        $nxp_id = $this->gsatelite->ingresar('axp_anexoxplaza', $documentos_array);

                        if ($nxp_id > 0) {
                            copy($carpeta_temporal_anx, $carpeta_destino_anx);
                        }
                    }
                }

                $exito++;
            }
        }
        if ($exito > 0) {
            $alerta = array(
                'tipo_alerta' => 'success'
                , 'titulo_alerta' => 'Éxito'
                , 'texto_alerta' => "<b>$exito</b> Nueva(s) plaza(s) / cargo(s) funcional(es) duplicada(s) con éxito."
            );
            $this->session->set_flashdata($alerta);
        }
        if ($ajax) {
            echo json_encode(array('exito' => $exito));
            die();
        } else {

            if ($plz_nueva > 0) {
                // $this->gsatelite->show_dialog('Nueva plaza ingresada con éxito.', 'acciones_personal/principal/autorizar_retiro');
            } else {
                // $this->gsatelite->show_dialog('Error en duplicar plaza', 'acciones_personal/principal/autorizar_retiro', 'error');
            }
        }
        return $retornar_valor;
    }

    public function empleado_tiempo_compensatorio() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            $permisos = $this->gsatelite->get_permisos_opcion();
            $data["permisos"] = $permisos;
            $data['empleados'] = $this->personal_model->listado_empleados(array('emp_estado'=>1));
            $data['titulo_personal'] = "Permisos";
            $this->_cargarvista($data, null);
        }
    }

    public function tiempo_compensatorio($id_emp) {
        satelite_validar();
        $this->verifica_empleado_real($id_emp);
        $registro_empleado = $this->gsatelite->get_tabla('emp_empleado', array('emp_id' => $id_emp));
        $data["info_empleado"] = $registro_empleado[0];
        $data["titulo_personal"] = "Tiempo Compensatorio";
        $data["tiempos_compensatorios_empleado"] = $this->accion_personal_model->get_tiempo_compensatorio(array('tce_id_emp' => $id_emp));
        $data["id_empleado"] = $registro_empleado[0]['emp_id'];
        $this->_cargarvista($data, null);
    }

    public function agregar_tiempo_compensatorio($id_emp){
        satelite_validar();
        if ($_POST) {

            $fecha_inicio = (trim($this->input->post('txtFechaDesde')) !='') ? formatear_fecha('Y-m-d', $this->input->post('txtFechaDesde')) : null;

            $total_dias_vigencia = ($this->gsatelite->get_parametro('VIGENCIA_TIEMPO_COMPENSATORIO')!='')? $this->gsatelite->get_parametro('VIGENCIA_TIEMPO_COMPENSATORIO'): 0;

            $fecha_vencimiento = date('Y-m-d', strtotime( '+'.$total_dias_vigencia.' day' , strtotime ($fecha_inicio)));

            $array_tce = array(
                'tce_id_emp' => $id_emp,
                'tce_num_hora' => $this->input->post('n_horas'),
                'tce_motivo' => ($this->input->post('motivo') != '') ? $this->input->post('motivo') : null,
                'tce_observacion' => ($this->input->post('observaciones_tiempo') != '') ? $this->input->post('observaciones_tiempo') : null,
                'tce_fecha_desde' => $fecha_inicio,
                'tce_fecha_hasta' => (trim($this->input->post('txtFechaHasta')) !='') ? formatear_fecha('Y-m-d', $this->input->post('txtFechaHasta')) : null,
                'tce_hora_inicio' => (trim($this->input->post('hora_1')) !='') ? $this->input->post('hora_1') : null,
                'tce_hora_final' => (trim($this->input->post('hora_2')) !='') ? $this->input->post('hora_2') : null,
                'tce_fecha_vencimiento' => $fecha_vencimiento,
                'tce_estado' => 1,
                'tce_usu_creacion' => $this->tank_auth->get_user_id(),
                'tce_fecha_creacion' => $this->input->post('fecha_registro'),
                'tce_usu_modificacion' => $this->tank_auth->get_user_id(),
                'tce_fecha_modificacion' => date("Y-m-d H:i:s")
            );
            $id_tce = $this->gsatelite->ingresar('tce_tiempo_compensatorio_empleado', $array_tce);

            $id_emp = $this->input->post('emp_id');
         
            $this->gsatelite->show_dialog("Proceso realizado con éxito", "acciones_personal/principal/tiempo_compensatorio/$id_emp");
            
        } else {
            $this->verifica_empleado_real($id_emp);
            $data["self_service"] = 0;
            $data["titulo_personal"] = "Tiempo compensatorio";
            $data["info_empleado"] = $this->gsatelite->get_tabla('emp_empleado', array('emp_id' => $id_emp));
            $this->_cargarvista($data, null);
        }
    }

    public function editar_tiempo_compensatorio($id_compensatorio){
        satelite_validar();
        if ($_POST) {
                $array_tce = array(
                    'tce_id_emp' => $this->input->post('id_empleado'),
                    'tce_num_hora' => $this->input->post('n_horas'),
                    'tce_motivo' => ($this->input->post('motivo') != '') ? $this->input->post('motivo') : null,
                    'tce_observacion' => ($this->input->post('observaciones_tiempo') != '') ? $this->input->post('observaciones_tiempo') : null,
                    'tce_fecha_desde' => (trim($this->input->post('txtFechaDesde')) !='') ? formatear_fecha('Y-m-d', $this->input->post('txtFechaDesde')) : null,
                    'tce_fecha_hasta' => (trim($this->input->post('txtFechaHasta')) !='') ? formatear_fecha('Y-m-d', $this->input->post('txtFechaHasta')) : null,
                    'tce_hora_inicio' => (trim($this->input->post('hora_1')) !='') ? $this->input->post('hora_1') : null,
                    'tce_hora_final' => (trim($this->input->post('hora_2')) !='') ? $this->input->post('hora_2') : null,
                    'tce_estado' => 1,
                    'tce_usu_modificacion' => $this->tank_auth->get_user_id(),
                    'tce_fecha_modificacion' => date("Y-m-d H:i:s")
                );
                $update_tce = $this->gsatelite->actualizar_array('tce_tiempo_compensatorio_empleado', $array_tce, array('tce_id' => $id_compensatorio));

                $id_emp = $this->input->post('emp_id');
                
                $this->gsatelite->show_dialog("Proceso realizado con éxito", "auto_gestion/acciones/tiempo_compensatorio/$id_emp");
                
        } else {
            $this->verifica_registro_real('tce_tiempo_compensatorio_empleado', $id_compensatorio);
            $reg_tce = $this->accion_personal_model->get_tiempo_compensatorio(array('tce_id' => $id_compensatorio));

            $id_empleado = $reg_tce[0]['tce_id_emp'];

            $data["registro"] = $reg_tce[0];
            $data["self_service"] = 0;
            $data["info_empleado"] = $this->gsatelite->get_tabla('emp_empleado', array('emp_id' => $id_empleado));
            $data["titulo_personal"] = "Tiempo compensatorio";
            $this->_cargarvista($data, null);
        }
    }

    public function solicitud_permiso_rrhh() {
        satelite_validar();
    
        $data = [];

        $html_header = ''; 
        $html = $this->load->view('acciones_personal/principal/solicitud_permiso_rrhh', $data, true);

        $this->pdf->setPrintFooter(false);
        $this->pdf->makePDF($html_header.$html, 'P');
}

    public function solicitud_licencia() {
        satelite_validar();
        
        $data = [];

        $html_header = ''; 
        $html = $this->load->view('acciones_personal/principal/solicitud_licencia', $data, true);
        
        $this->pdf->setPrintFooter(false);
        $this->pdf->makePDF($html_header.$html, 'P');
    }


}

?>