<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Mantenimientos extends CI_Controller
{
	function __construct()
	{
		parent::__construct();
		$this->load->library('grocery_CRUD');
        $this->load->model('gsatelite');
        $this->load->model('accion_personal_model');
        $this->load->model('personal_model');
	}

	function index()
	{
		if (!$this->tank_auth->is_logged_in()) {
			redirect('/auth/login/');
		} else {			
            $this->_cargarvista();
		}
	}



    /**
    * @author René Castaneda
    * @return Mantenimiento the_tipo_hora_extra
    */
    function tipo_hora_extra() 
    {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            try
            {
                //ids delos tipos de horas segun los parametros
                $ids_tipos = $this->gsatelite->get_parametro('INGRESO_HED').','.$this->gsatelite->get_parametro('INGRESO_HEN');
                $crud = new grocery_CRUD();
                $permisos = $this->gsatelite->get_permisos_opcion();
                $crud->set_table('the_tipo_hora_extra')
                     ->set_subject('Tipo hora extra')
                     ->columns('the_nombre','the_factor','the_id_tig','the_estado')
                     ->set_relation('the_id_tig','tig_tipo_ingreso','tig_nombre')//,"tig_id in ($ids_tipos)"
                     ->fields('the_nombre','the_factor','the_id_tig','the_estado','the_usu_mod','the_fecha_mod')//,'the_inicio','the_fin'
                     ->display_as('the_nombre', 'Nombre')
                     ->display_as('the_factor', 'Factor Multiplicación')
                     ->display_as('the_estado', 'Estado')
                     // ->display_as('the_inicio', 'Inicio')
                     // ->display_as('the_fin', 'Fin')
                     ->display_as('the_id_tig', 'Tipo Ingreso')
                     ->required_fields('the_nombre','the_factor','the_estado')//,'the_id_tig'
                     ->set_rules('the_nombre','Nombre','trim|required|campo_unico[the_tipo_hora_extra.the_nombre]')
                     ->field_type('the_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                     ->field_type('the_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                     ->unset_delete()
                     ;
                     $urlx = explode('/',uri_string());
                      if(end($urlx)=='add') {
                     $crud->field_type('the_estado','hidden',1);
                     }
                     else {
                     $crud->field_type('the_estado','dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
                     }
                // Validar permisos. Agregado por Luis Navarro
                if (!$permisos['permite_agregar']) {
                    $crud->unset_add();
                }
                if (!$permisos['permite_editar']) {
                    $crud->unset_edit();
                }
                if (!$permisos['permite_eliminar']) {
                    $crud->unset_delete();
                }
                if (!$permisos['permite_ver']) {
                    $crud->unset_read();
                }
                     $data['titulo_personal'] = "Tipos de horas extras";

                $output = $crud->render();
                $this->_cargarvista($data,$output);
            }
            catch(Exception $e)
            {
                show_error($e->getMessage().' --- '.$e->getTraceAsString());
            }
            
        }
    }


    /**
    * @author René Castaneda
    * @return Mantenimiento thf_tipo_hora_faltante
    */
    function tipo_hora_faltante() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            try {
                // $ids_tipos = $this->gsatelite->get_parametro('INGRESO_HED').','.$this->gsatelite->get_parametro('INGRESO_HEN');
                $crud = new grocery_CRUD();
                $permisos = $this->gsatelite->get_permisos_opcion();
                $crud->set_table('thf_tipo_hora_faltante')
                     ->set_subject('Tipo de Permiso')
                     ->columns('thf_nombre','thf_factor','thf_id_tdc','thf_estado')
                     ->set_relation('thf_id_tdc','tdc_tipo_descuento','tdc_nombre')
                     ->fields('thf_id_tdc','thf_nombre','thf_factor','thf_recurrente','thf_estado','thf_usu_mod','thf_fecha_mod')
                     ->display_as('thf_nombre', 'Nombre')
                     ->display_as('thf_horas_ley', 'Horas Asignadas según Ley')
                     ->display_as('thf_factor', 'Factor Multiplicación')
                     ->display_as('thf_recurrente', 'Aplica Recurrencia')
                     ->display_as('thf_estado', 'Estado')
                     ->display_as('thf_id_tdc', 'Tipo Descuento')
                     ->required_fields('thf_nombre','thf_factor','thf_estado')
                     ->set_rules('thf_nombre','Nombre','trim|required|campo_unico[thf_tipo_hora_faltante.thf_nombre]')
                     ->field_type('thf_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                     ->field_type('thf_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                     ->callback_add_field('thf_recurrente', function () {
                        return '<input type="checkbox" id="chkrecurrente" class="nostyle"><input type="hidden" id="field-thf_recurrente" name="thf_recurrente" value="0">';
                     })
                     ->callback_edit_field('thf_recurrente', function ($value, $primary_key) {
                        $leer    = ($this->uri->rsegments[3] == 'read') ? 'iButton' : '';
                        $defecto = ($value > 0) ? 'checked' : '';
                        return '<input type="checkbox" id="chkrecurrente" '.$defecto.' class="'.$leer.' nostyle"><input type="hidden" id="field-thf_recurrente" name="thf_recurrente" value="' . $value . '">';
                    })

                ;
                $uri_exploded = explode('/',uri_string());

                if(end($uri_exploded) == 'add') {
                    $crud->field_type('thf_estado', 'hidden', 1);
                } else {
                    $crud->field_type('thf_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
                }
                // Validar Permisos. Agregado por Luis Navaro
                if (!$permisos['permite_agregar']) {
                    $crud->unset_add();
                }
                if (!$permisos['permite_ver']) {
                    $crud->unset_read();
                }
                if (!$permisos['permite_editar']) {
                    $crud->unset_edit();
                }
                if (!$permisos['permite_eliminar']) {
                    $crud->unset_delete();
                }
                $crud->add_action(' Configuración', '', 'acciones_personal/mantenimientos/configuracion_tipo_permiso', 'brocco-icon-list', null, "",  null);
                $crud->add_action(' Gestion de Horas', '', 'acciones_personal/mantenimientos/gestion_horas', 'brocco-icon-list', null, '', null);

                $data['titulo_personal'] = "Tipo de Permiso";
                $output = $crud->render();
                $this->_cargarvista($data,$output);
            } catch(Exception $e) {
                show_error($e->getMessage().' --- '.$e->getTraceAsString());
            }
            
        }
    }

    public function gestion_horas($id_thf = 0, $id_emp = 0) {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            try {
                $urlx = explode('/',uri_string());
                $row = $this->gsatelite->get_registro("thf_tipo_hora_faltante", array("thf_id" => $id_thf));
                $add_fields = array(
                    "hpe_id_emp",
                    "hpe_id_thf",
                    "hpe_horas_utilizadas",
                    "hpe_horas_limite",
                    "hpe_horas_disponible",
                    "hpe_ultimo_reinicio",
                    "hpe_estado",
                    "hpe_usu_creacion",
                    "hpe_fecha_creacion",
                    "hpe_usu_modificacion",
                    "hpe_fecha_modificacion"
                );
                $edit_fields = array(
                    "hpe_id_emp",
                    "hpe_id_thf",
                    "hpe_horas_utilizadas",
                    "hpe_horas_limite",
                    "hpe_horas_disponible",
                    "hpe_ultimo_reinicio",
                    "hpe_estado",
                    "hpe_usu_modificacion",
                    "hpe_fecha_modificacion"
                );
                $columns = array(
                    "hpe_id_emp",
                    "hpe_horas_utilizadas",
                    "hpe_horas_limite",
                    "hpe_horas_disponible",
                    "hpe_estado"
                );


                $crud = new grocery_CRUD();
                $crud->set_table('hpe_hora_permiso_x_empleado')
                        ->set_subject($row->thf_nombre)
                        ->columns($columns)
                        ->add_fields($add_fields)
                        ->edit_fields($edit_fields)
                        ->set_relation('hpe_id_emp', 'emp_empleado','{emp_codigo} - {emp_nombre} {emp_apellido}')
                        ->set_rules("hpe_id_emp", "Empleado", "required|campo_unico2[hpe_hora_permiso_x_empleado.hpe_id_emp.hpe_id_thf.$id_thf]")
                        ->field_type('hpe_id_thf', 'hidden', $id_thf)
                        ->where("hpe_id_thf", $id_thf)

                        ->display_as('hpe_id_emp', 'Empleado')
                        ->display_as('hpe_id_thf', 'Tipo de Hora Faltante')
                        ->display_as('hpe_horas_utilizadas', 'Horas Utilizadas')
                        ->display_as('hpe_horas_limite', 'Horas Limite')
                        ->display_as('hpe_horas_disponible', 'Horas Disponible')
                        ->display_as('hpe_ultimo_reinicio', 'Ultimo reinicio')
                        ->display_as('hpe_estado', 'Estado')
                        ->required_fields('hpe_id_emp', 'hpe_id_thf')
                        ->field_type('hpe_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                        ->field_type('hpe_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
                ;

                $crud->callback_edit_field('hpe_ultimo_reinicio', function ($value, $row) {
                    $campo = '<span>' . formatear_fecha('d-m-Y', $value) . '</span>';
                    $campo .= '<input id="field-hpe_ultimo_reinicio" name="hpe_ultimo_reinicio" type="hidden" value="'.$value.'">';
                    return $campo;
                     // '<input id="field-hpe_ultimo_reinicio" name="hpe_ultimo_reinicio" type="text" value="' . formatear_fecha() . '" maxlength="10" class="datePicker">';
                });



                if(end($urlx) == 'add') {
                    $crud->field_type('hpe_estado', 'hidden', 1)
                        ->field_type('hpe_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                        ->field_type('hpe_ultimo_reinicio', 'hidden', date('Y-m-d'))
                        ->field_type('hpe_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
                } else {
                    $crud->field_type('hpe_estado', 'dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
                }
                
                //$crud->unset_delete();
                
                $data['nombre_permiso'] = $row->thf_nombre;
                $data['titulo_personal'] = "Horas por Tipo Permiso";

                $data['id_thf'] = $id_thf;
                $data['id_emp'] = $id_emp;
                $output = $crud->render();
                $this->_cargarvista($data, $output);
            } catch(Exception $e) {
                show_error($e->getMessage().' --- '.$e->getTraceAsString());
            }
            
        }
    }

    function configuracion_tipo_permiso($id) {
        satelite_validar();
        if ($_POST) {
            $verificar_restriccion = $this->input->post('restriccion');
            $aplica_a = ($this->input->post("slcAplica") != '') ? $this->input->post("slcAplica") : null;
            $permiso_grupal = $this->input->post('grupal');//0
            $sindicato = ($this->input->post("slcSindicato") != '') ? $this->input->post("slcSindicato") : null;//""
            $frecuencia_periodo = ($this->input->post('slcFrecuenciaPeriodo') != '') ? $this->input->post('slcFrecuenciaPeriodo') : null;
            $cantidad_maxima = ($this->input->post("cantidad_maxima") != '') ? $this->input->post("cantidad_maxima") : null;
            $frecuencia_cantidad = ($this->input->post("slcFrecuenciaCantidad") != '') ? $this->input->post("slcFrecuenciaCantidad") : null;
            $acumulable = $this->input->post('acumulable');
            $maximo_eventos = ($this->input->post("maximo_eventos") != '') ? $this->input->post("maximo_eventos") : null;
            $frecuencia_eventos = ($this->input->post("slcFrecuenciaEventos") != '') ? $this->input->post("slcFrecuenciaEventos") : null;

            $verificar_registro_cfp = $this->gsatelite->get_registro('cfp_configuracion_tipo_permiso', array('cfp_id_thf' => $id));
            $array_cfp = array(
                'cfp_id_thf' => $id,
                'cfp_id_sin' => $sindicato,
                'cfp_grupal' => $permiso_grupal,
                'cfp_frecuencia_periodo' => $frecuencia_periodo,
                'cfp_acumulable' => $acumulable,
                'cfp_cantidad_maxima' => $cantidad_maxima,
                'cfp_frecuencia_maximo' => $frecuencia_cantidad,
                'cfp_cantidad_limite' => $maximo_eventos,
                'cfp_frecuencia_limite' => $frecuencia_eventos,
                'cfp_estado' => $verificar_registro_cfp ? $verificar_restriccion: 1,
                'cfp_usu_modificacion' => $this->tank_auth->get_user_id(),
                'cfp_fecha_modificacion' => date('Y-m-d H:i:s'),
                'cfp_tipo_empleado' => $aplica_a
            );
            if (is_object($verificar_registro_cfp)) {
                if ($verificar_restriccion > 0) {
                    $cfp_registro = $this->gsatelite->actualizar_array('cfp_configuracion_tipo_permiso', $array_cfp, array('cfp_id' => $verificar_registro_cfp->cfp_id, 'cfp_id_thf' => $id));
            } else {
                    $cfp_registro = $this->gsatelite->borrado_general('cfp_configuracion_tipo_permiso', array('cfp_id' => $verificar_registro_cfp->cfp_id, 'cfp_id_thf' => $id)); 
                }
            } else {
                if ($verificar_restriccion) {
                    $array_cfp['cfp_fecha_creacion'] = date('Y-m-d H:i:s');
                    $array_cfp['cfp_usu_creacion'] = $this->tank_auth->get_user_id();
                    $cfp_registro = $this->gsatelite->ingresar('cfp_configuracion_tipo_permiso', $array_cfp);
                }
            }
            if ( $verificar_restriccion || $verificar_registro_cfp ) {
                if ( $cfp_registro > 0 ) {
                    $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Configuración guardada con exito.", 'texto_alerta' => "Los registros fueron guardados corectamente");
                    $this->session->set_flashdata($alerta);
                    redirect('acciones_personal/mantenimientos/tipo_hora_faltante');
                } else {
                    $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "La configuración no ha podido guardarse.", 'texto_alerta' => "No se pudo realizar la acción, favor de verificar la información");
                    $this->session->set_flashdata($alerta);
                    redirect('acciones_personal/mantenimientos/configuracion_tipo_permiso/'.$id);
                }
            } else {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Configuración guardada con exito.", 'texto_alerta' => "Los registros fueron guardados corectamente");
                $this->session->set_flashdata($alerta);
                redirect('acciones_personal/mantenimientos/tipo_hora_faltante');
            }
    
        } else {
            $data['tipo_permiso_id'] = $id;
            $data['info_tipo_permiso'] = $this->gsatelite->get_registro('thf_tipo_hora_faltante', array('thf_id' => $id));

            $data['registro'] = $this->gsatelite->get_registro('cfp_configuracion_tipo_permiso', array('cfp_id_thf' => $id));

            $sindicato_id = ($data['registro'] && $data['registro']->cfp_id_sin) ? $data['registro']->cfp_id_sin : null;

            $sindicatos = $this->gsatelite->get_dropdown('sin_sindicato', '{sin_codigo} - {sin_nombre}', '', array('sin_estado' => '1'), $sindicato_id, '', 'sin_id', true);
		
		    $data['sindicatos'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $sindicatos);
    
            $titulo['titulo_personal'] = "Configuración tipo de permiso / licencia";
            $this->_cargarvista($titulo, $data);
        }

    }


    /**
    * @author René Castaneda
    * @return Mantenimiento tac_tipo_accion
    */
    function tipo_accion_personal(){
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            try{
                $crud = new grocery_CRUD();                
                // Variable para Permisos. Agregado por Luis Navarro
                $permisos = $this->gsatelite->get_permisos_opcion();
                $crud->set_table('tac_tipo_accion')
                     ->set_subject('Tipo Acción')
                     // ->set_relation('tac_id_tdc','tdc_tipo_descuento','tdc_nombre')
                     ->columns('tac_nombre','tac_observacion','tac_estado')
                     ->add_fields('tac_nombre','tac_observacion','tac_estado','tac_usu_mod','tac_fecha_mod','tac_usu_crea','tac_fecha_crea')
                     ->edit_fields('tac_nombre','tac_observacion','tac_estado','tac_usu_mod','tac_fecha_mod')
                     //->fields('tac_nombre','tac_observacion','tac_estado','tac_usu_mod','tac_fecha_mod','tac_id_tdc','tac_usu_crea','tac_fecha_crea')
                     // ->display_as('tac_id_tdc', 'Tipo Descuento')
                     ->display_as('tac_nombre', 'Nombre')
                     ->display_as('tac_observacion', 'Observación')
                     ->display_as('tac_estado', 'Estado')
                     ->required_fields('tac_nombre','tac_estado')
                     ->set_rules('tac_nombre','Nombre','trim|required|campo_unico[tac_tipo_accion.tac_nombre]')
                     ->field_type('tac_usu_crea', 'hidden', $this->tank_auth->get_user_id())
                     ->field_type('tac_fecha_crea', 'hidden', date('Y-m-d H:i:s'))                     
                     ->field_type('tac_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                     ->field_type('tac_fecha_mod', 'hidden', date('Y-m-d H:i:s'))                     
                     ->unset_delete()
                     ;
                     $urlx = explode('/',uri_string());
                if(end($urlx)=='add') {
                    $crud->field_type('tac_estado','hidden',1);
                } else {
                    $crud->field_type('tac_estado','dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
                }
                // Validar Permiisos. Agregado por Luis Navarro
                if (!$permisos['permite_agregar']) {
                    $crud->unset_add();
                }
                if (!$permisos['permite_editar']) {
                    $crud->unset_edit();
                }
                if (!$permisos['permite_eliminar']) {
                    $crud->unset_delete();
                }
                $data['titulo_personal'] = "Tipos de acciones de personal";
                $output = $crud->render();
                $this->_cargarvista($data,$output);
            } catch(Exception $e) {
                show_error($e->getMessage().' --- '.$e->getTraceAsString());
            }
        }
    }


   /**
   * @author René Castaneda
   * @return Mantenimiento prv_periodo_vacacion
   */
    function periodos_vacacion() {
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            try {
                $crud = new grocery_CRUD();
                // Variable para Permisos. Agregado por Luis Navarro
                $permisos = $this->gsatelite->get_permisos_opcion();
                $crud->set_table('prv_periodo_vacacion')
                     ->set_subject('Periodos Vacación')
                     ->columns('prv_nombre','prv_desde','prv_hasta','prv_estado')
                     ->fields('prv_nombre','prv_desde','prv_hasta','prv_estado','prv_usu_mod','prv_fecha_mod')
                     ->display_as('prv_nombre', 'Nombre')
                     ->display_as('prv_desde', 'Desde')
                     ->display_as('prv_hasta', 'Hasta')
                     ->display_as('prv_estado', 'Estado')
                     ->required_fields('prv_nombre','prv_desde','prv_hasta','prv_estado')
                     ->set_rules('prv_nombre','Nombre','trim|required|campo_unico[prv_periodo_vacacion.prv_nombre]')
                     ->set_rules('prv_desde','Desde','trim|callback_validacion_fechas|required')
                     ->field_type('prv_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                     ->field_type('prv_fecha_mod', 'hidden', date('Y-m-d H:i:s'))
                     ->unset_delete()
                     ;
                     $urlx = explode('/',uri_string());
                      if(end($urlx)=='add') {
                     $crud->field_type('prv_estado','hidden',1);
                     }
                     else {
                     $crud->field_type('prv_estado','dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
                     }
                     // Validar Permisos. Agregado por Luis Navarro
                    if (!$permisos['permite_agregar']) {
                        $crud->unset_add();
                    }
                    if (!$permisos['permite_editar']) {
                        $crud->unset_edit();
                    }
                    if (!$permisos['permite_eliminar']) {
                        $crud->unset_delete();
                    }
                     $data['titulo_personal'] = "Periodos de vacación";

                $output = $crud->render();
                $this->_cargarvista($data,$output);
            }
            catch(Exception $e)
            {
                show_error($e->getMessage().' --- '.$e->getTraceAsString());
            }
            
        }
    }

    function tipo_resolucion() {
        satelite_validar();
        try {
            $crud = new grocery_CRUD();
            $permisos = $this->gsatelite->get_permisos_opcion();
            $urlx = explode('/',uri_string()); 
            $crud->set_table('trs_tipo_resolucion')
                ->set_subject('Tipo de Resolución')
                ->columns('trs_nombre','trs_estado')
                ->edit_fields('trs_codigo','trs_nombre','trs_estado','trs_usu_modificacion','trs_fecha_modificacion')
                ->add_fields('trs_codigo','trs_nombre','trs_estado','trs_usu_modificacion','trs_fecha_modificacion','trs_usu_creacion','trs_fecha_creacion')
                ->display_as('trs_codigo', 'Código')
                ->display_as('trs_nombre', 'Nombre')
                ->display_as('trs_estado', 'Estado')
                ->required_fields('trs_nombre','trs_estado')
                ->field_type('trs_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
                ->field_type('trs_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                ->set_rules('trs_nombre','Nombre','trim|required|campo_unico[trs_tipo_resolucion.trs_nombre]')
            ;
            if(end($urlx)=='add') {
                $crud->field_type('trs_estado','hidden',1);
                $crud->field_type('trs_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
                $crud->field_type('trs_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
            } else {
                $crud->field_type('trs_estado','dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_ver']) {
                $crud->unset_read();
                $crud->unset_print();
                $crud->unset_export();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            $data['titulo_personal'] = "Tipo de Resolución";
            $output = $crud->render();
            $this->_cargarvista($data,$output);
        } catch(Exception $e) {
            show_error($e->getMessage().' --- '.$e->getTraceAsString());
        }
    }

    function resolucion() {
        satelite_validar();
        try {
            $crud = new grocery_CRUD();
            $permisos = $this->gsatelite->get_permisos_opcion();
            $urlx = explode('/',uri_string()); 
            $crud->set_table('rsl_resolucion')
                ->set_subject('Resolución')
                ->columns('rsl_id_trs','rsl_correlativo_inicial','rsl_estado')
                ->edit_fields('rsl_id_trs','rsl_correlativo_inicial','rsl_estado','rsl_usu_modificacion','rsl_fecha_modificacion')
                ->add_fields('rsl_id_trs','rsl_correlativo_inicial','rsl_estado','rsl_usu_modificacion','rsl_fecha_modificacion','rsl_usu_creacion','rsl_fecha_creacion')
                ->display_as('rsl_id_trs', 'Tipo Resolución')
                ->display_as('rsl_correlativo_inicial', 'Prefijo')
                ->display_as('rsl_estado', 'Estado')
                ->required_fields('rsl_id_trs','rsl_estado')
                ->field_type('rsl_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
                ->field_type('rsl_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                ->set_relation('rsl_id_trs', 'trs_tipo_resolucion', '{trs_nombre}', array('trs_estado' => 1))
            ;
            if(end($urlx)=='add') {
                $crud->field_type('rsl_estado','hidden',1);
                $crud->field_type('rsl_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
                $crud->field_type('rsl_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
            } else {
                $crud->field_type('rsl_estado','dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
            }
            if (!$permisos['permite_agregar']) {
                $crud->unset_add();
            }
            if (!$permisos['permite_editar']) {
                $crud->unset_edit();
            }
            if (!$permisos['permite_ver']) {
                $crud->unset_read();
                $crud->unset_print();
                $crud->unset_export();
            }
            if (!$permisos['permite_eliminar']) {
                $crud->unset_delete();
            }
            $data['titulo_personal'] = "Formato Resolución";
            $output = $crud->render();
            $this->_cargarvista($data,$output);
        } catch(Exception $e) {
            show_error($e->getMessage().' --- '.$e->getTraceAsString());
        }
    }

     public function validacion_fechas($data){
        if($data != '' ) {
            $validado1 = false; //variable que cambiará de valor cuando no se cumpla una condición de validación
            $validado2 = false; //variable que cambiará de valor cuando no se cumpla la segunda condición de validación
            $f1 = $this->input->post('prv_desde');
            $f2 = $this->input->post('prv_hasta');
            $n_dias = $this->gsatelite->get_intervalo_dias($f1,$f2);    
            if($n_dias > 0) { 
                //primera condición
                $validado1 = true; 
            } else { 
                $this->form_validation->set_message('validacion_fechas', 'Fecha desde debe ser menor a fecha hasta');
                return false; 
            }
            //PREGUNTAR SI EXISTEN REGISTROS DE FECHA DESDE MAYOR A LA INGRESADA. (PARA EVITAR REGISTRO CRUZADOS) 
            //en el caso de edit
            $url_array = explode('/', uri_string());
            $no_incluir = (is_numeric(end($url_array)) and end($url_array) > 0 ) ? end($url_array) : 0;  
            $pregunta = $this->accion_personal_model->validar_periodo_vacacion($no_incluir, $f1, $f2);
            if(count($pregunta) > 0){
                $this->form_validation->set_message('validacion_fechas', 'Ya existen otros periodos que contienen la fecha desde');
                return false; 
            } else {
                $validado2 = true; 
            }
            return ($validado1 and $validado2) ? true : false;
        } else {
            return true;
        }
    }

    function categoria_retiro($ruta_modulo = "")
    {
         if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            try
            {
                $ruta_modulo = ( trim($ruta_modulo) != '' )? trim($ruta_modulo):"acciones_personal/mantenimientos";
                $data['ruta_modulo'] = $ruta_modulo;
                $crud = new grocery_CRUD();
                // Variable para Permisos. Agregado por Luis Navarro
                $permisos = $this->gsatelite->get_permisos_opcion();
                $crud->set_table('ctr_categoria_retiro')
                     ->set_subject('Categoría de retiro')
                     ->columns('ctr_nombre','ctr_descripcion','ctr_estado')
                     ->fields('ctr_nombre','ctr_descripcion','ctr_estado','ctr_usu_mod','ctr_fecha_mod', 'ctr_usu_creacion','ctr_fecha_creacion')
                     ->display_as('ctr_nombre', 'Nombre')
                     ->display_as('ctr_descripcion', 'Descripción')
                     ->display_as('ctr_estado', 'Estado')
                     ->required_fields('ctr_nombre','ctr_estado')
                     ->set_rules('ctr_nombre','Nombre','trim|required|campo_unico[ctr_categoria_retiro.ctr_nombre]')
                     ->field_type('ctr_usu_mod', 'hidden', $this->tank_auth->get_user_id())
                     ->field_type('ctr_fecha_mod', 'hidden', date('Y-m-d H:i:s'))

                     //->unset_delete()
                     ;
                     $urlx = explode('/',uri_string());
                      if(end($urlx)=='add') {
                     $crud->field_type('ctr_estado','hidden',1);
                     $crud->field_type('ctr_fecha_creacion', 'hidden', date('Y-m-d H:i:s'));
                     $crud->field_type('ctr_usu_creacion', 'hidden', $this->tank_auth->get_user_id());
                     }
                     else {
                     $crud->field_type('ctr_estado','dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
                     $crud->field_type('ctr_fecha_creacion', 'hidden');
                     $crud->field_type('ctr_usu_creacion', 'hidden');
                     }
                     // Validar Permisos. Agregado por Luis Navarro
                    if (!$permisos['permite_agregar']) {
                        $crud->unset_add();
                    }
                    if (!$permisos['permite_editar']) {
                        $crud->unset_edit();
                    }
                    if (!$permisos['permite_eliminar']) {
                        $crud->unset_delete();
                    }
                    if (!$permisos['permite_ver']) {
                        $crud->unset_read();
                    }
                     $data['titulo_personal'] = "Categorías de retiro";

                $output = $crud->render();
                //$this->_cargarvista($data,$output);
                cargarvista($data,$output,'acciones_personal/mantenimientos/categoria_retiro');
            }
            catch(Exception $e)
            {
                show_error($e->getMessage().' --- '.$e->getTraceAsString());
            }
            
        }
    } 


    //=====================================================================
    // MIGRACIÓN DE TIPO INCAPACIDAD DE PROCESOS A MANTENIMIENTO By René Castaneda
    //=====================================================================

    /**
     * @author Edith Herrera
     * @since 2017-07-04
     * @return Grid de tipos de incapacidad
     * */
    public function tipo_incapacidad() {
        satelite_validar();
        if ($_POST) {
            
        } else {
            $data['tipos'] = $this->accion_personal_model->tipos_incapacidad();
            $data['permisos'] = $permisos = $this->gsatelite->get_permisos_opcion('tipo_incapacidad');
            $titulo['titulo_personal'] = "Tipos de incapacidad";
            $this->_cargarvista($titulo, $data);
        }
    }

    /**
     * @author Edith Herrera
     * @since 2017-07-10
     * @return Formulario para agregar tipos de incapacidad
     * */
    function agregar_tipo_inc() {
        satelite_validar();
        if ($_POST) {
            $nombre = $this->input->post('nombre');
            $salario_max = $this->input->post('salario_max');
            $aplica_planilla = ($this->input->post('aplica_planilla') > 0) ? true : false;
            $tipo_desc = ($this->input->post('descuento') > 0 && $aplica_planilla) ? $this->input->post('descuento') : null;
            $tipo_ing = ($this->input->post('ingreso') > 0 && $aplica_planilla) ? $this->input->post('ingreso') : null;
            $hora_ley = ($this->input->post('horas_ley') > 0) ? $this->input->post('horas_ley') : null;

            $array_inc = array(
                'tnc_id_tig' => $tipo_ing,
                'tnc_id_tdc' => $tipo_desc,
                'tnc_nombre' => $nombre,
                'tnc_aplica_planilla' => $this->input->post('aplica_planilla'),
                'tnc_salario_maximo' => $salario_max,
                'tnc_estado' => 1,
                'tnc_horas_ley' => $hora_ley,
                'tnc_fecha_creacion' => date('Y-m-d H:i:s'),
                'tnc_usu_creacion' => $this->tank_auth->get_user_id(),
                'tnc_fecha_modificacion' => date('Y-m-d H:i:s'),
                'tnc_usu_modificacion' => $this->tank_auth->get_user_id()
            );
            $ing_tipo = $this->gsatelite->ingresar('tnc_tipo_incapacidad', $array_inc);

            /*             * ****************** Detalle *************** */
            $dias_ini = $this->input->post('detalle_i');
            $dias_fin = $this->input->post('detalle_f');
            $porc_sobre = $this->input->post('detalle_s');
            $porc_hasta = ($this->input->post('detalle_h') != '') ? $this->input->post('detalle_h') : null; // Seguro, no requerido
            $diferencia = $this->input->post('detalle_d');
            $tipos_ings = $this->input->post('tipo_ing');

            if (count($dias_ini) > 0) {
                foreach ($dias_ini as $key => $value) {
                    $pregunta = array(
                        'cti_id_tnc' => $ing_tipo,
                        'cti_id_tig' => ($tipos_ings[$key] > 0) ? $tipos_ings[$key] : null,
                        'cti_cantidad_desde' => $value,
                        'cti_cantidad_hasta' => $dias_fin[$key],
                        'cti_porcentaje_subsidio' => $porc_sobre[$key],
                        'cti_porcentaje_seguro' => $porc_hasta[$key], //$preguntas[$key],
                        'cti_porcentaje_diferencia' => $diferencia[$key],
                        'cti_estado' => 1,
                        'cti_fecha_modificacion' => date('Y-m-d H:i:s'),
                        'cti_usu_modificacion' => $this->tank_auth->get_user_id(),
                        'cti_fecha_creacion' => date('Y-m-d H:i:s'),
                        'cti_usu_creacion' => $this->tank_auth->get_user_id()
                    );
                    $ing_detalle = $this->gsatelite->ingresar('cti_configuracion_tipo_incapacidad', $pregunta);
                }
            }

            $volver = $this->input->post('volver');
            if ($ing_tipo > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Acción ejecutada", 'texto_alerta' => "Los registros fueron guardados corectamente");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Acción no ejecutada", 'texto_alerta' => "No se pudo realizar la acción, favor de verificar la información");
            }

            if ($volver == 1) {
                $this->session->set_flashdata($alerta);
                redirect('acciones_personal/mantenimientos/agregar_tipo_inc');
            } else {
                $this->session->set_flashdata($alerta);
                redirect('acciones_personal/mantenimientos/tipo_incapacidad');
            }
        } else {
            $ingresos = $this->gsatelite->get_dropdown('tig_tipo_ingreso', '{tig_nombre}', '', array('tig_estado' => 1), null, '', 'tig_id', true);
            $data["ingresos"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $ingresos);

            $descuentos = $this->gsatelite->get_dropdown('tdc_tipo_descuento', '{tdc_nombre}', '', null, null, '', 'tdc_id', true);
            $data["descuentos"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $descuentos);

            $data['titulo_personal'] = "Agregar tipo de incapacidad";
            $this->_cargarvista($data);
        }
    }

    /**
     * @author Edith Herrera
     * @since 2017-07-10
     * @return Formulario para editar tipos de incapacidad
     * */
    function editar_tipo_inc($id_inc) {
        satelite_validar();
        if ($_POST) {
            $nombre = $this->input->post('nombre');
            $salario_max = $this->input->post('salario_max');
            $aplica_planilla = ($this->input->post('aplica_planilla') > 0) ? true : false;
            $tipo_desc = ($this->input->post('descuento') > 0 && $aplica_planilla) ? $this->input->post('descuento') : null;
            $tipo_ing = ($this->input->post('ingreso') > 0 && $aplica_planilla) ? $this->input->post('ingreso') : null;
            $hora_ley = ($this->input->post('horas_ley') > 0) ? $this->input->post('horas_ley') : null;
            $id_inc = $this->input->post('id_inc');

            $array_inc = array(
                'tnc_id_tig' => $tipo_ing,
                'tnc_id_tdc' => $tipo_desc,
                'tnc_nombre' => $nombre,
                'tnc_aplica_planilla' => $this->input->post('aplica_planilla'),
                'tnc_horas_ley' => $hora_ley,
                'tnc_salario_maximo' => $salario_max,
                'tnc_fecha_modificacion' => date('Y-m-d H:i:s'),
                'tnc_usu_modificacion' => $this->tank_auth->get_user_id()
            );

            $act_tipo = $this->gsatelite->actualizar_array('tnc_tipo_incapacidad', $array_inc, array('tnc_id' => $id_inc));

            /*             * ****************** Detalle *************** */
            $this->gsatelite->borrado_general('cti_configuracion_tipo_incapacidad', array('cti_id_tnc' => $id_inc));


            /// INGRESO DE DETALLES
            $dias_ini = $this->input->post('detalle_i');
            $dias_fin = $this->input->post('detalle_f');
            $porc_sobre = $this->input->post('detalle_s');
            $porc_hasta = ($this->input->post('detalle_h') != '') ? $this->input->post('detalle_h') : null; // Seguro, no requerido
            $diferencia = $this->input->post('detalle_d');
            $tipos_ings = $this->input->post('tipo_ing');

            if (count($dias_ini) > 0) {
                foreach ($dias_ini as $key => $value) {
                    $detalle = array(
                        'cti_id_tnc' => $id_inc,
                        'cti_id_tig' => ($tipos_ings[$key] > 0) ? $tipos_ings[$key] : null,
                        'cti_cantidad_desde' => $value,
                        'cti_cantidad_hasta' => $dias_fin[$key],
                        'cti_porcentaje_subsidio' => $porc_sobre[$key],
                        'cti_porcentaje_seguro' => $porc_hasta[$key], //$preguntas[$key],
                        'cti_porcentaje_diferencia' => $diferencia[$key],
                        'cti_estado' => 1,
                        'cti_fecha_creacion' => date('Y-m-d H:i:s'),
                        'cti_usu_creacion' => $this->tank_auth->get_user_id(),
                        'cti_fecha_modificacion' => date('Y-m-d H:i:s'),
                        'cti_usu_modificacion' => $this->tank_auth->get_user_id()
                    );
                    $act_detalle = $this->gsatelite->ingresar('cti_configuracion_tipo_incapacidad', $detalle);
                }
            }

            $volver = $this->input->post('volver');
            if ($id_inc > 0) {
                $alerta = array('tipo_alerta' => 'success', 'titulo_alerta' => "Acción ejecutada", 'texto_alerta' => "Los registros fueron guardados corectamente");
            } else {
                $alerta = array('tipo_alerta' => 'error', 'titulo_alerta' => "Acción no ejecutada", 'texto_alerta' => "No se pudo realizar la acción, favor de verificar la información");
            }

            if ($volver == 1) {
                $this->session->set_flashdata($alerta);
                redirect('acciones_personal/mantenimientos/editar_tipo_inc/' . $id_inc);
            } else {
                $this->session->set_flashdata($alerta);
                redirect('acciones_personal/mantenimientos/tipo_incapacidad');
            }
        } else {
            $info_inc = $this->accion_personal_model->tipos_incapacidad(array('tnc_id' => $id_inc));
            $data['info'] = $info_inc[0];
            $data['detalles'] = $detalles = $this->gsatelite->get_tabla('cti_configuracion_tipo_incapacidad', array('cti_id_tnc' => $id_inc));
            $data['id_inc'] = $id_inc;
            $ultimo = $this->gsatelite->get_max('cti_configuracion_tipo_incapacidad', 'cti_cantidad_hasta', array('cti_id_tnc' => $id_inc));
            $mayor = $this->gsatelite->get_tabla('cti_configuracion_tipo_incapacidad', array('cti_id_tnc' => $id_inc, 'cti_cantidad_hasta' => $ultimo));
            $data['mayor'] = $mayor[0];
            // ANTES ERA EN LA INCAACIDAD, AHORA SERA EN LOS DETALLES
            $ingresos = $this->gsatelite->get_dropdown('tig_tipo_ingreso', '{tig_nombre}', '', array('tig_estado' => 1), null, '', 'tig_id', true);
            $data["ingresos"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $ingresos);
            $descuentos = $this->gsatelite->get_dropdown('tdc_tipo_descuento', '{tdc_nombre}', '', null, $info_inc[0]['tdc_id'], '', 'tdc_id', true);
            $data["descuentos"] = str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $descuentos);
            $data['titulo_personal'] = "Editar tipo de incapacidad";
            $this->_cargarvista($data);
        }
    }

    //=====================================================================
    // FIN MIGRACIÓN DE TIPO INCAPACIDAD DE PROCESOS A MANTENIMIENTO
    //=====================================================================


	function _cargarvista($data=0,$crud=0){	
		$this->load->view('vacia',$crud);	
		if($data!=0)
			$data=array_merge($data,$this->masterpage->getUsuario());
		else
			$data=$this->masterpage->getUsuario();		
		$vista=$data['modulo'].'/'.$data['control'].'/'.$data['funcion'];
		$this->masterpage->setMasterPage('masterpage_default');
		$this->masterpage->addContentPage($vista, 'content',$data);
		$this->masterpage->show();
	}

    /**
    * @author Raul Escalante
    * @return Mantenimiento mtp_motivo_permiso
    */
    function motivo_permiso(){
        if (!$this->tank_auth->is_logged_in()) {
            redirect('/auth/login/');
        } else {
            try{
                $crud = new grocery_CRUD();                
                $permisos = $this->gsatelite->get_permisos_opcion();
                $crud->set_table('mtp_motivo_permiso')
                     ->set_subject('Motivo Permiso')
                     ->columns('mtp_nombre','mtp_descripcion','mtp_estado')
                     ->add_fields('mtp_nombre','mtp_descripcion','mtp_estado','mtp_usu_modificacion','mtp_fecha_modificacion','mtp_usu_creacion','mtp_fecha_creacion')
                     ->edit_fields('mtp_nombre','mtp_descripcion','mtp_estado','mtp_usu_modificacion','mtp_fecha_modificacion')
                     ->display_as('mtp_nombre', 'Motivo')
                     ->display_as('mtp_descripcion', 'Descripción')
                     ->display_as('mtp_estado', 'Estado')
                     ->required_fields('mtp_nombre','mtp_estado')
                     ->set_rules('mtp_nombre','Motivo','trim|required|campo_unico[mtp_motivo_permiso.mtp_nombre]')
                     ->field_type('mtp_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                     ->field_type('mtp_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))                     
                     ->field_type('mtp_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                     ->field_type('mtp_fecha_modificacion', 'hidden', date('Y-m-d H:i:s')) 
                     //->unset_delete()
                     ;
                     $urlx = explode('/',uri_string());
                if(end($urlx)=='add') {
                    $crud->field_type('mtp_estado','hidden',1);
                } else {
                    $crud->field_type('mtp_estado','dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
                }
                if (!$permisos['permite_agregar']) {
                    $crud->unset_add();
                }
                if (!$permisos['permite_editar']) {
                    $crud->unset_edit();
                }
                if (!$permisos['permite_eliminar']) {
                    $crud->unset_delete();
                }
                $data['titulo_personal'] = "Motivo de Permiso";
                $output = $crud->render();
                $this->_cargarvista($data,$output);
            } catch(Exception $e) {
                show_error($e->getMessage().' --- '.$e->getTraceAsString());
            }
        }
    }

      /** 
      * @author René Castaneda
      * @return Mantenimiento djm_dias_trajado_mes
      */
    function dias_mes($en_modal=0) 
       {
           if (!$this->tank_auth->is_logged_in()) {
               redirect('/auth/login/');
           } else {
               try
               {
                   $crud = new grocery_CRUD();
                   $permisos = $this->gsatelite->get_permisos_opcion();
                   $crud->set_table('djm_dias_trajado_mes')
                        ->set_subject('Días por mes')
                        ->columns('djm_periodo','djm_dias','djm_observaciones','djm_estado')
                        ->fields('djm_periodo','djm_fecha_periodo','djm_dias','djm_observaciones','djm_estado','djm_usu_creacion','djm_fecha_creacion','djm_usu_modificacion','djm_fecha_modificacion')
                        ->display_as('djm_periodo', 'Periodo')
                        ->display_as('djm_dias', 'Cantidad días')
                        ->display_as('djm_observaciones', 'Observación')
                        ->display_as('djm_estado', 'Estado')
                        ->required_fields('djm_periodo','djm_dias','djm_estado')
                        ->set_rules('djm_periodo','Periodo','trim|required|campo_unico[djm_dias_trajado_mes.djm_periodo]')
                        ->field_type('djm_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                        ->field_type('djm_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
                        ->field_type('djm_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                        ->field_type('djm_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
                        ->field_type('djm_fecha_periodo', 'hidden', date('Y-m-d H:i:s'))
                        ->callback_before_insert(function($post_array, $primary_key) {
                           $fecha_ = '2000-01-01';
                            if(strlen($post_array['djm_periodo']) == 6 && is_numeric($post_array['djm_periodo'])) {
                               $fecha_ = substr($post_array['djm_periodo'], 0, 4) . '-'.substr($post_array['djm_periodo'], 4, 2).'-01';
                            }
                            $post_array['djm_fecha_periodo'] = $fecha_;
                            return $post_array;
                        })
                        ;
                        $urlx = explode('/',uri_string()); 
                        if(end($urlx)=='add') {
                        $crud->field_type('djm_estado','hidden',1);
                        }
                        else {
                        $crud->field_type('djm_estado','dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
                        }
                    $crud->unset_print();
                    $crud->unset_export();
                   // Validar permisos. Agregado por Luis Navarro
                   if (!$permisos['permite_agregar']) {
                       $crud->unset_add();
                   }
                   if (!$permisos['permite_editar']) {
                       $crud->unset_edit();
                   }
                   if (!$permisos['permite_eliminar']) {
                       $crud->unset_delete();
                   }
                   if (!$permisos['permite_ver']) {
                       $crud->unset_read();
                   }
                        $data['titulo_personal'] = "Días por mes";

                   $output = $crud->render();
                   //die('llego');
                   if($en_modal == 1)
                        cargarvista_modal($data,$output);
                    else
                        cargarvista($data,$output);
               }
               catch(Exception $e)
               {
                   show_error($e->getMessage().' --- '.$e->getTraceAsString());
               }
               
           }
       }
        /** 
      * @author René Castaneda
      * @return Mantenimiento djv_dias_trajado_vacacion 
      */
    function dias_mes_vacacion($en_modal=0) 
       {
           if (!$this->tank_auth->is_logged_in()) {
               redirect('/auth/login/');
           } else {
               try
               {
                   $crud = new grocery_CRUD();
                   $permisos = $this->gsatelite->get_permisos_opcion('acciones_personal/mantenimientos/dias_mes_vacacion', null, null, true);
                   $crud->set_table('djv_dias_trajado_vacacion')
                        ->set_subject('Días por mes (vacación)')
                        ->columns('djv_periodo','djv_dias','djv_observaciones','djv_estado')
                        ->fields('djv_periodo','djv_fecha_periodo','djv_dias','djv_observaciones','djv_estado','djv_usu_creacion','djv_fecha_creacion','djv_usu_modificacion','djv_fecha_modificacion')
                        ->display_as('djv_periodo', 'Periodo')
                        ->display_as('djv_dias', 'Cantidad días')
                        ->display_as('djv_observaciones', 'Observación')
                        ->display_as('djv_estado', 'Estado')
                        ->required_fields('djv_periodo','djv_dias','djv_estado')
                        ->set_rules('djv_periodo','Periodo','trim|required|campo_unico[djv_dias_trajado_vacacion.djv_periodo]')
                        ->field_type('djv_usu_creacion', 'hidden', $this->tank_auth->get_user_id())
                        ->field_type('djv_fecha_creacion', 'hidden', date('Y-m-d H:i:s'))
                        ->field_type('djv_usu_modificacion', 'hidden', $this->tank_auth->get_user_id())
                        ->field_type('djv_fecha_modificacion', 'hidden', date('Y-m-d H:i:s'))
                        ->field_type('djv_fecha_periodo', 'hidden', date('Y-m-d H:i:s'))
                        ->callback_before_insert(function($post_array, $primary_key) {
                           $fecha_ = '2000-01-01';
                            if(strlen($post_array['djv_periodo']) == 6 && is_numeric($post_array['djv_periodo'])) {
                               $fecha_ = substr($post_array['djv_periodo'], 0, 4) . '-'.substr($post_array['djv_periodo'], 4, 2).'-01';
                            }
                            $post_array['djv_fecha_periodo'] = $fecha_;
                            return $post_array;
                        })
                        ;
                        $urlx = explode('/',uri_string()); 
                        if(end($urlx)=='add') {
                        $crud->field_type('djv_estado','hidden',1);
                        }
                        else {
                        $crud->field_type('djv_estado','dropdown', array('1' => 'Activo', '0' => 'Inactivo'));
                        }
                    $crud->unset_print();
                    $crud->unset_export();
                   // Validar permisos. Agregado por Luis Navarro
                   if (!$permisos['permite_agregar']) {
                       $crud->unset_add();
                   }
                   if (!$permisos['permite_editar']) {
                       $crud->unset_edit();
                   }
                   if (!$permisos['permite_eliminar']) {
                       $crud->unset_delete();
                   }
                   if (!$permisos['permite_ver']) {
                       $crud->unset_read();
                   }
                        $data['titulo_personal'] = "Días por mes";

                   $output = $crud->render();
                    if ($en_modal == 1) {
                        if (!(is_array($permisos))) {
                            $output->output = '<table width="100%" style="text-align: center;"><tr><td><h2>Sin permisos para esta opción<h2></td></tr></table>';
                        }
                        cargarvista_modal($data,$output);
                    } else {
                        cargarvista($data,$output);
                    }
               }
               catch(Exception $e)
               {
                   show_error($e->getMessage().' --- '.$e->getTraceAsString());
               }
               
           }
       }





}



/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */