<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Consultas extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();
		$this->load->library('grocery_CRUD');
		$this->load->library('tank_auth');
		$this->load->model('gsatelite');
		$this->load->model('planilla_model');
		$this->load->model('personal_model');
		$this->load->model('marcacion_model');
		$this->load->model('accion_personal_model');
		$this->load->library('pdf');
		$this->load->library('excel/excel_reader.php');
		      	      	
	}

	function boleta_vacacion() {
		satelite_validar();
		$data['titulo_personal'] = "Boleta de vacación";
		$this->_cargarvista(null,$data); 
	}

	function get_empleado_boleta_vacacion() {
		satelite_validar();
		$mes = $this->input->post('mes_elegido');
		$tipo = $this->input->post('tipo');
		if($this->input->post('mes_elegido') != "" and $this->input->post('mes_elegido') > 0 ) {
			$data['esreporte'] = ($tipo != "" and $tipo != null) ? 1 : 0;
			$mes = ($mes < 10) ? '0' . $mes : $mes;
			$fecha = date('Y-'.$mes.'-01');
	  		//$data['consulta'] = $this->planilla_model->get_cumplen_anio_laboral($fecha);
	  		$ids_emps = $this->planilla_model->get_cumplen_anio_laboral($fecha,true);
	  		// print_r($this->db->last_query());die();
	  		$data['consulta'] = $this->accion_personal_model->get_empleados_vacaciones_generadas($ids_emps);
	  		$data['mes'] = $mes;
	  		$html = $this->load->view('acciones_personal/consultas/get_empleado_boleta_vacacion', $data, true);
	  	}	  	
	  	if($tipo==null or $tipo=="") {
	  		echo $html;
	  	} else if($tipo==2) {
	  		$this->load->library('pdf');
	  		$html_header  = $this->load->view('reporte/header', array('titulo' => 'Empleadas/os con año laboral'), true);
	  		$reporte=$this->pdf->makePDF($html_header.$html,'L');
	  	} else { 
	  		header("Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
	  		header("Content-Disposition: attachment;filename=Reporte_empleados_anio_laboral.xls"); 
	  		header("Pragma: no-cache");
	  		header("Expires: 0");
	  		echo $html;
	  	}
	}

	function generar_boleta_vacacion($id_empleado,$id_vac) {
		satelite_validar();
		$this->gsatelite->verificar_registro_real('emp_empleado',$id_empleado);
		$this->gsatelite->verificar_registro_real('vac_vacacion',$id_vac);
		$this->load->library('EnLetras');
		$registro_emp = $this->gsatelite->get_registro('emp_empleado','emp_id',$id_empleado);
		//el salario de 15 dias división entre 2
		$factor_vacacion = $this->gsatelite->get_parametro('FACTOR_CALCULO_VACACION');

		$quince = $this->accion_personal_model->get_empleados_vacaciones_generadas($id_empleado,$id_vac);
		$mas = ($quince[0]['monto'] * $factor_vacacion) / (1 + $factor_vacacion );
		$quince_monto = $quince[0]['monto'] - $mas;
		$mas = round($mas,2);
		$ntotal = $quince_monto + $mas;

		//calculo del isss y afp por separado.
		$ntotal_isss = ($ntotal>685.70)? 685.70:$ntotal; //estableciendo el limite para el seguro
		$isss = 0.03 * $ntotal_isss;
		$afp = 0.0625 *  $ntotal;
		$isss_afp = $isss + $afp;
		$total_p = $ntotal - $isss_afp;

		$deci = (string) number_format($total_p,2);
		$decimal = str_replace('.','',substr( $deci, strpos( $deci, "." )));

		$data['sueldo_prom'] = number_format($quince_monto,2);
		$data['mas'] = number_format($mas,2);
		$data['total1'] = number_format($ntotal,2);
		$data['apf_isss'] = number_format($isss_afp,2); //pendiente
		$data['total_pagar'] = number_format($total_p,2);
		$data['empleado']= $registro_emp;
		$data['cantidad_letras']= $this->enletras->ValorEnLetras(floor($total_p),"");
		$data['fraccion']= "$decimal/100";

		$this->load->library('pdf');
		$html_header = '';
		//$html_header  = $this->load->view('reporte/header', array('titulo' => 'Productos más vendidos'), true);
		$html = $this->load->view('acciones_personal/consultas/detalle_boleta_vacacion', $data, true);
	  	$reporte=$this->pdf->makePDF($html_header.$html,'P');

	}

	function reporte_horas(){	
		satelite_validar();
		$data['empleados'] = $this->gsatelite->get_dropdown('emp_empleado', '{emp_nombre}'.' '.'{emp_apellido}','',array('emp_estado'=>1), null, '', 'emp_id', true);
		$data['titulo_personal'] = 'Reporte de permisos';
		$this->_cargarvista($data);
	}

	public function print_calculo($rte_id, $tipo = 0){
		satelite_validar();
		// DATOS DEL EMPLEADO
		$data['tipo'] = $tipo;//PDF = 0 / EXCEL = 1
		$data['datos_retiro'] = $this->accion_personal_model->datos_retiro_emp(array('rte_id' => $rte_id));
		$html = $this->load->view('acciones_personal/consultas/detalle_calculos_liquidacion', $data, true);
		if ($tipo > 0) {
			echo $html;
		} else {
			$datos = $this->load->view('reporte/header', array('titulo' => 'Cálculo de Liquidación'), true);
			$datos .= $html;
			$this->pdf->makePDF($datos, 'P');
		}
		
	}

	public function rpte_horas_xtras($flag = null){
		satelite_validar();
		if ($_POST) {
			// var_dump($_POST);die();	
			$fecha_ini = formatear_fecha('Y-m-d', $this->input->post('fecha_inicio'));
			$fecha_fin = formatear_fecha('Y-m-d', $this->input->post('fecha_final'));
			$empleado = ($this->input->post('slcempleado') != '') ? $this->input->post('slcempleado') : null;
			$reporte = $this->input->post('reporte');
			$horas_extras = $this->accion_personal_model->get_horas_extras_reporte($empleado, $fecha_ini, $fecha_fin);
			$subtitulo = 'Del ' . formatear_fecha('d/m/Y', $fecha_ini) . ' Al ' . formatear_fecha('d/m/Y', $fecha_fin);
			$data['subtitle'] = $subtitulo;
			$data['reporte'] = $reporte;
			$data['horas_extra'] = $horas_extras;
			$html = $this->load->view('acciones_personal/consultas/consulta_horas_extras', $data, true);
			if ($flag) {
				echo json_encode(array('tabla' => $html, 'filas' => count($horas_extras)));
			} else {
				if ($reporte == 'pdf') {
					$datos = $this->load->view('reporte/header', array('titulo' => 'Reporte de Horas Extras', 'subtitulo' => $subtitulo), true);
            		$datos .= $html;
					$this->pdf->makePDF($datos, 'P');
				} else {
					echo $html;
				}				
			}
		} else {
			$data['empleados'] = $this->gsatelite->get_dropdown('emp_empleado', '{emp_codigo} - {emp_nombre} {emp_apellido}','',array('emp_estado'=>1), null, '', 'emp_id', true);
			$data['titulo_personal'] = 'Reporte de horas extras';
			$this->_cargarvista($data);
		}		
	}

	function consulta_horas(){
		$where = array();
		$fecha_ini = $this->input->post('fecha_ini');
		$fecha_fin = $this->input->post('fecha_fin');
		$empleado = $this->input->post('empleado');
		$estado = $this->input->post('estado');
		if ($fecha_ini!='') {
			$where['DATE(hxe_fecha) >= '] = formatear_fecha('Y-m-d', $fecha_ini);
		}
		if ($fecha_fin!='') {
			$where['DATE(hxe_fecha) <= '] = formatear_fecha('Y-m-d', $fecha_fin);
		}
		if ($empleado > 0) {
			$where['emp_id'] = $empleado;
		}
		if ($estado != '') {
			$where['hxe_estado'] = $estado;
		}
		$data['horas_extra'] = $this->accion_personal_model->get_horas_faltantes_reporte($where);
		$html = $this->load->view('acciones_personal/consultas/consulta_horas', $data, true);
		echo json_encode(array('tabla' => $html));
	}

	function print_reporte_horas($id){
		$where = array();
		$fecha_ini = $this->input->post('fecha_ini');
		$fecha_fin = $this->input->post('fecha_fin');
		$empleado = $this->input->post('empleado');
		$estado = $this->input->post('estado');
		if ($fecha_ini!='') {
			$where['DATE(hxe_fecha) >= '] = formatear_fecha('Y-m-d', $fecha_ini);
		}
		if ($fecha_fin!='') {
			$where['DATE(hxe_fecha) <= '] = formatear_fecha('Y-m-d', $fecha_fin);
		}
		if ($empleado > 0) {
			$where['emp_id'] = $empleado;
		}
		if ($estado != '') {
			$where['hxe_estado'] = $estado;
		}
		$data['horas_extra'] = $this->accion_personal_model->get_horas_faltantes_reporte($where);
		if ($id == 1) {
			$html = '';
			$data['pdf']=1;
			$this->load->library('pdf');
			$html.=$this->load->view('acciones_personal/consultas/print_consulta_horas', $data, true);
			$this->pdf->makePDF($html, 'L');
		}else{
			$data['excel'] = 1;
			$this->load->view('acciones_personal/consultas/print_consulta_horas', $data);			
		}
	}

	/* Similar a reporte_horas pero sin validar factor o monto descuento */
	public function horas_permisos($flag = null){
		satelite_validar();
		if ($_POST) {
			$where = array();
			$fecha_ini 	= $this->input->post('txt_fecha_ini');
			$fecha_fin 	= $this->input->post('txt_fecha_fin');
			$empleado 	= $this->input->post('txt_empleado');
			$estado 	= $this->input->post('txt_estado');
			$reporte 	= $this->input->post('reporte');
			if ($fecha_ini!='') {
				$where['DATE(hxe_fecha) >= '] = formatear_fecha('y-m-d', $fecha_ini);
			}
			if ($fecha_fin!='') {
				$where['DATE(hxe_fecha) <= '] = formatear_fecha('y-m-d', $fecha_fin);
			}
			if ($empleado > 0) {
				$where['emp_id'] = $empleado;
			}
			if ($estado != '') {
				$where['hxe_estado'] = $estado;
			}
			$registros =  $this->accion_personal_model->get_horas_faltantes_reporte($where);
			$data['reporte'] = $reporte;
			$data['registros'] = $registros;
			$html = $this->load->view('acciones_personal/consultas/det_permisos_horas', $data, true);
			if ($flag) {
				echo json_encode(array('tabla' => $html, 'filas' => count($registros)));
			} else {
				if ($reporte == 'pdf') {
					$datos = $this->load->view('reporte/header', array('titulo' => 'Tiempo de permisos'), true);
                    $datos .= $html;
                    $this->pdf->makePDF($datos, 'P');
				} else {
					echo $html;
				}
			}
			
		} else {
			satelite_validar();
			$data['empleados'] = $this->gsatelite->get_dropdown('emp_empleado', '{emp_nombre}'.' '.'{emp_apellido}','',array('emp_estado'=>1), null, '', 'emp_id', true);
			$data['titulo_personal'] = 'Reporte de permisos';
			$this->_cargarvista($data);
		}		
	}

	/* Reporte con la sumatoria de horas de permiso por empleado */
	public function resumen_permisos($flag = null){
		satelite_validar();
		if ($_POST) {
			$year = $this->input->post('year');
			$area = $this->input->post('area');
			$empl = $this->input->post('empl');
			$tipo_reporte = $this->input->post('tipo_reporte');
			$respuesta = array();
			$where = null;
			if ($area != "") {
				$where['emp_id_are'] = $area;
			}
			if ($empl != "") {
				$where['emp_id'] = $empl;
			}
			$registros_permisos = $this->accion_personal_model->get_resumen_permisos($year, $where);
			$data['detalles'] = $registros_permisos; 
			$data['permisos'] = $this->gsatelite->get_tabla('thf_tipo_hora_faltante', array('thf_estado' => 1));
			$data['incapacidad'] = $this->gsatelite->get_tabla('tnc_tipo_incapacidad', array('tnc_estado' => 1));
			$where['emp_estado > '] = 0;
			$data['empleados'] = $this->gsatelite->get_tabla('emp_empleado', $where);
			$data['anio'] = $year;
			$data['tipo_reporte'] = $tipo_reporte;
			$html = $this->load->view('acciones_personal/consultas/detalle_resumen_permisos', $data, true);
			if ($flag) {
				echo json_encode(array('tabla' => $html, 'filas' => count($registros_permisos)));
			} else {
				echo $html;
			}			
		} else {
			$years = "";
			$actual = date('Y');
			for ($i = 0; $i < 10; $i++) { 
				$selected = ($i > 0) ? "" : "selected";
				$years .= '<option value="'.($actual - $i).'" '.$selected.'>'.($actual - $i).'</option>';
			}
			$areas = $this->gsatelite->get_dropdown('are_area', '{are_nombre}', '', array('are_estado' => 1), null, '', 'are_id', true);
			$empleados = $this->gsatelite->get_dropdown('emp_empleado', '{emp_codigo} - {emp_nombre} {emp_apellido}','',array('emp_estado'=>1), null, '', 'emp_id', true);
			$data['years'] = $years;
			$data['areas'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $areas);
			$data['empleados'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $empleados);
			$data['titulo_personal'] = 'Resumen de Permisos por Empleada/o';
			$this->_cargarvista($data);
		}		
	}

	public function empleados_area() {
		$area = $this->input->post('area');
		if ($area > 0) {
			$empleados = $this->gsatelite->get_dropdown('emp_empleado', '{emp_codigo} - {emp_nombre} {emp_apellido}','',array('emp_estado' => 1, 'emp_id_are' => $area), null, '', 'emp_id', true);
		} else {
			$empleados = $this->gsatelite->get_dropdown('emp_empleado', '{emp_codigo} - {emp_nombre} {emp_apellido}','',array('emp_estado'=>1), null, '', 'emp_id', true);
		}
		$select = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '<option value=""></option>', $empleados);
		echo $select;		
	}

	function reporte_vacaciones(){	
		$data['factor'] = $this->gsatelite->get_parametro('FACTOR_CALCULO_VACACION') * 100;
		$dropdown = $this->gsatelite->get_dropdown('emp_empleado', '{emp_codigo} - {emp_nombre} {emp_apellido}','',array('emp_estado'=>1), null, '', 'emp_id', true);
		$data['empleados'] =str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $dropdown);
		$data['titulo_personal'] = 'Reporte de vacaciones por empleado';
		$this->_cargarvista($data);
	}

	function consultar_vacaciones(){
		$where = null;
		$fecha_ini = ($this->input->post('fecha_ini') != "") ? formatear_fecha('Y-m-d', $this->input->post('fecha_ini')) : "";
		$fecha_fin = ($this->input->post('fecha_fin') != "") ? formatear_fecha('Y-m-d', $this->input->post('fecha_fin')) : "";
		$empleado  = $this->input->post('empleado');
		$tipo 	   = $this->input->post('tipo');
		if ($fecha_ini != '' && $fecha_fin != '') {
			$where['DATE(gva_desde) >= '] = $fecha_ini;
			$where['DATE(gva_hasta) <= '] = $fecha_fin;
		}
		if ($empleado > 0) {
			$where['gva_id_emp'] = $empleado;   
		}
		if ($tipo > 0) {
			$where['gva_tipo_calculo'] = $tipo;
		}
		$data['factor'] = $this->gsatelite->get_parametro('FACTOR_CALCULO_VACACION') * 100;
		$data["consulta"] = $this->accion_personal_model->get_vacaciones_empleado_reporte($where);
		// print_r($this->db->last_query());die();
		$html = $this->load->view('acciones_personal/consultas/consultar_vacaciones', $data, true);
		echo json_encode(array('tabla' =>$html));
	}

	function print_reporte_vacaciones($id){
		$where = null;
		$fecha_ini = ($this->input->post('fecha_ini') != "") ? formatear_fecha('Y-m-d', $this->input->post('fecha_ini')) : "";
		$fecha_fin = ($this->input->post('fecha_fin') != "") ? formatear_fecha('Y-m-d', $this->input->post('fecha_fin')) : "";
		$empleado  = $this->input->post('empleado');
		$tipo 	   = $this->input->post('tipo');
		if ($fecha_ini != '' && $fecha_fin != '') {
			$where['DATE(gva_desde) >= '] = $fecha_ini;
			$where['DATE(gva_hasta) <= '] = $fecha_fin;
		}
		if ($empleado > 0) {
			$where['gva_id_emp'] = $empleado;   
		}
		if ($tipo > 0) {
			$where['gva_tipo_calculo'] = $tipo;
		}
		$data['factor'] = $this->gsatelite->get_parametro('FACTOR_CALCULO_VACACION') * 100;
		$data["consulta"] = $this->accion_personal_model->get_vacaciones_empleado_reporte($where);
		if ($id == 1) {
			$data['pdf'] = 1;
			$this->load->library('pdf');
			$html=$this->load->view('reporte/header', array('titulo' => 'Reporte de pago de vacaciones', 'solotitulo' => true), true);
			$html.=$this->load->view('acciones_personal/consultas/print_consultar_vacaciones', $data, true);
			$this->pdf->makePDF($html, 'L');
		}else{
			$data['excel'] = 1;
			$this->load->view('acciones_personal/consultas/print_consultar_vacaciones', $data);
		}
	}


	function reporte_acciones(){
		$data['empleados'] = str_replace(array('<option value="0">Sin Registros</option>', '<option value="0">Seleccione</option>'),'',$this->gsatelite->get_dropdown('emp_empleado', '{emp_nombre}'.' '.'{emp_apellido}','',array('emp_estado'=>1), null, '', 'emp_id', true));
		$data['tipos'] = str_replace(array('<option value="0">Sin Registros</option>', '<option value="0">Seleccione</option>'),'',$this->gsatelite->get_dropdown('tac_tipo_accion', '{tac_nombre}','',array('tac_estado'=>1), null, '', 'tac_id', true));
		$data['titulo_personal'] = 'Reporte de acciones por empleado';
		$this->_cargarvista($data);
	}

	function consultar_acciones(){
		$fecha_ini = $this->input->post('fecha_ini');
		$fecha_fin = $this->input->post('fecha_fin');
		$empleado  = ($this->input->post('empleado') != "") ? $this->input->post('empleado') : null;
		$tipo 	   = ($this->input->post('tipo') != "") ? $this->input->post('tipo') : null;
		if ($fecha_ini != '') {
			$fecha_ini = date('Y-m-d', strtotime($fecha_ini));
		}
		if ($fecha_fin != '') {
			$fecha_fin = date('Y-m-d', strtotime($fecha_fin));
		}
		$data['acciones'] = $this->accion_personal_model->get_acciones_personal_reporte($empleado, $tipo, $fecha_ini, $fecha_fin);
		$html = $this->load->view('acciones_personal/consultas/consultar_acciones', $data, true);
		echo json_encode(array('tabla' =>$html));
	}

	function print_reporte_acciones($id){
		$fecha_ini=$this->input->post('fecha_ini');
		$fecha_fin=$this->input->post('fecha_fin');
		$empleado=$this->input->post('empleado');
		$tipo = (is_array($this->input->post('tipo'))) ? implode(',', $this->input->post('tipo')) : null;
		if ($fecha_ini!='') {
			$fecha_ini=date('Y-m-d', strtotime($fecha_ini));
		}
		if ($fecha_fin!='') {
			$fecha_fin=date('Y-m-d', strtotime($fecha_fin));
		}
		$data['acciones'] = $this->accion_personal_model->get_acciones_personal_reporte($empleado, $tipo, $fecha_ini, $fecha_fin);
		if ($id == 1) {
			$data['pdf']=1;
            $this->load->library('pdf');
            $html=$this->load->view('reporte/header', array('titulo' => 'Reporte acciones', 'solotitulo' => true), true);
            $html.=$this->load->view('acciones_personal/consultas/print_consultar_acciones', $data, true);
            $this->pdf->makePDF($html, 'L');
        }else{
        	$data['excel'] = 1;
            $this->load->view('acciones_personal/consultas/print_consultar_acciones', $data);            
        }
	}

	public function retiro_personal(){
        satelite_validar();
		$data['areas']              = $this->gsatelite->get_tabla('are_area',array('are_estado' => 1, 'are_padre' => null));
		$data['titulo_personal']    = "Reporte de retiro de personal";
		$this->_cargarvista($data);
	}
	
	public function reporte_retiro_personal($flag = null){
        satelite_validar();
        if ($_POST){
            $post_array = $this->input->post();
            /*
             * Si es consulta ajax se toman los nombres del Jquery
             * De lo contrario, se toman los filtros de impresión
            */

            if ($flag) {
                $area           = ($post_array['area'] != '') ? $post_array['area'] : null;
				$nombre_area    = ($post_array['nombre_area'] != '') ? $post_array['nombre_area'] : "todos";
				$fecha_ini = ($post_array['fecha_ini'] != '') ? date('Y-m-d', strtotime($post_array['fecha_ini'])) : null;
                $fecha_fin = ($post_array['fecha_fin'] != '') ? date('Y-m-d', strtotime($post_array['fecha_fin'])) : null;
            } else {
                $area = ($post_array['filtro_area'] != '') ? $post_array['filtro_area'] : null;
				$nombre_area    = ($post_array['filtro_area_nombre'] != '') ? $post_array['filtro_area_nombre'] : "todos";
				$fecha_ini = ($post_array['filtro_inicio'] != '') ? date('Y-m-d', strtotime($post_array['filtro_inicio'])) : null;
                $fecha_fin = ($post_array['filtro_fin'] != '') ? date('Y-m-d', strtotime($post_array['filtro_fin'])) : null;
            }

            //Tipo de Reportes si sera Excel o Pdf
            $tipo_reporte = $this->input->post('tipo_reporte');

            $where = null;

            if ($area != null) {
                $where['emp_id_are'] = $area;
			}
			
			if ($fecha_ini != '' && $fecha_fin != '') {
                $where['rte_fecha_retiro >='] = $fecha_ini;
                $where['rte_fecha_retiro <='] = $fecha_fin;
                $data['fecha_inicio'] = $fecha_ini;
                $data['fecha_fin'] = $fecha_fin;
            }

			$reporte = $this->accion_personal_model->get_retiro_empleados($where);
		
            $filename = 'rpt_reporte_retiro_personal' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename'] = $filename;
            $data['reporte'] = $reporte;
            $data['tipo_reporte'] = $tipo_reporte;
            $data['area_nombre']  = $nombre_area;
			$html = $this->load->view('acciones_personal/consultas/reporte_retiro_personal', $data, true);

            if ($flag) {
                $dato["html"] = $html;
				echo json_encode($dato);
				die();
            } else {
                if ($tipo_reporte == 'pdf') {

                    $data['titulo'] = 'retiro de personal';

                    $header = $this->load->view('reporte/header', $data, true);

                    $GLOBALS['nombre_reporte'] = 'reporte_retiro_personal' . date('dmY');

                    $reporte = $header . $html;

                    //echo $reporte;
                    $this->pdf->makePdf($reporte, 'L', 'reporte_retiro_personal', 'Letter');
                } elseif ($tipo_reporte == 'excel') {

                    $filename = 'rpt_reporte_retiro_personal_' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);

                    $data['titulo'] = 'retiro personal';

                    $data['filename'] = $filename;

                    echo $html;
                }
            }
            
        } else{
            redirect('acciones_personal/consultas/retiro_personal');
		}
	}

	public function consumos_permisos($flag = null){
		satelite_validar();
		if ($_POST) {
			$tipo_perm = $this->input->post('tipo_p');
			$tipo_repo = $this->input->post('tipo_reporte');
			$where = array('hxe_estado > ' => 0, 'uhp_autorizado' => 1);
			if ($tipo_perm > 0) {
				$where['thf_id'] = $tipo_perm;
			}
			$datos = $this->accion_personal_model->get_consumo_permisos($where);
			$data['registros'] = $datos;
			$data['tipo_repo'] = $tipo_repo;
			$html = $this->load->view('acciones_personal/consultas/detalle_consumo_permisos', $data, true);
			if ($flag) {
				echo json_encode(array('tabla' => $html, 'filas' => count($datos)));
			} else {
				// code...
			}
		} else {
			$are_drop = $this->gsatelite->get_dropdown('are_area', '{are_nombre}', '', array('are_estado' => 1), null, '', 'are_id', true);
			$per_drop = $this->gsatelite->get_dropdown('thf_tipo_hora_faltante', '{thf_nombre}', '', array('thf_estado' => 1), null, '', 'thf_id', true);
			$data['areas'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $are_drop);
			$data['permisos'] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $per_drop);
			$data['titulo_personal']    = "Consumo de permisos por tipo";
			$this->_cargarvista($data);
		}
	}

	function _cargarvista($data=0,$crud=0)
	{	
		$this->load->view('vacia',$crud);	
		if($data!=0)
			$data=array_merge($data,$this->masterpage->getUsuario());
		else
			$data=$this->masterpage->getUsuario();
		$vista=$data['modulo'].'/'.$data['control'].'/'.$data['funcion'];
		$this->masterpage->setMasterPage('masterpage_default');
		$this->masterpage->addContentPage($vista, 'content',$data);
		$this->masterpage->show();
	}

	function reporte_trimestral() {
	  	satelite_validar();
	  	if ($_POST) {
	  		$area = $this->input->post('slc_area');
	  		$fecha_desde = formatear_fecha("Y-m-d", $this->input->post('txtFechaIni'));
	  		$fecha_hasta = formatear_fecha("Y-m-d", $this->input->post('txtFechaFin'));
	  		$tipo = $this->input->post('tipo_reporte');
	  		$where["are_id != ''"] = null;
	  		$where2["are_id != ''"] = null;
	  		if ($area != '') {
	  			$where["are_id"] = $area;
	  			$where2["are_id"] = $area;
	  		}
	  		if ($fecha_desde != '' && $fecha_hasta != '') {
	  			$where["date(hxe_fecha) >= '$fecha_desde'"] = null;
	  			$where["date(hxe_fecha) <= '$fecha_hasta'"] = null;
	  			$where2["date(inc_fecha_inicio) >= '$fecha_desde'"] = null;
	  			$where2["date(inc_fecha_inicio) <= '$fecha_hasta'"] = null;
	  		} else {
	  			$fecha =  date("Y-m-d",strtotime("- 3 month"));
	  			$where["date(hxe_fecha) <= '$fecha'"] = null;
	  			$where2["date(inc_fecha_inicio) <= '$fecha'"] = null;
	  		}
	  		$group_by = 'hxe_id_mtp, are_id';
	  		$groupby2 = 'tnc_id, are_id';
	  		$consulta = $this->accion_personal_model->get_informe_trimestral($where,$group_by);
	  		$reg_tard = $this->llegadas_tarde_area($fecha_desde, $fecha_hasta, $area);
	  		$incapacd = $this->accion_personal_model->get_inc_inf_trimestral($where2,$groupby2);
	  		$data["tipo"] = $tipo;
	  		$data["consulta"] = $consulta;
	  		$data["incapacidad"] = $incapacd;
	  		$data["tardias"] = $reg_tard;
	  		$html = $this->load->view('acciones_personal/consultas/tabla_reporte_trimestral', $data, true);
	  		$html_header  = $this->load->view('reporte/header', array('titulo' => 'Informe trimestral por area'), true);
	  		if($tipo == null or $tipo == "") {
	  			echo json_encode(array("html" => $html));
	  			die();
	  		} else if($tipo=='pdf') { 
	  			$this->load->library('pdf');
	  			$reporte=$this->pdf->makePDF($html_header.$html,'L');
	  		} else {
	  			header("Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
	  			header("Content-Disposition: attachment;filename=Informe_trimestral_por_area.xls"); 
	  			header("Pragma: no-cache");
	  			header("Expires: 0");
	  			echo $html_header.$html;
	  		}
	  		die();
	  	}
	  	$select = $this->gsatelite->get_dropdown('are_area', '{are_nombre}', '', array('are_estado' => 1), null, '', 'are_id', true);
	  	$data["slc_area"] = str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $select);
	  	$data['titulo_personal']    = "Informe trimestral por area";
	  	$this->_cargarvista($data);
	}

	public function llegadas_tarde_area($fecha_ini, $fecha_fin, $area = null){
		$repuesta = array();
		$array_where = array('mar_fecha_entrada >=' => formatear_fecha('Y-m-d', $fecha_ini), 'mar_fecha_entrada <=' => formatear_fecha('Y-m-d', $fecha_fin), 'mar_revisado' => 1);
		if ($area != null && $area != "") {
			$array_where['emp_id_are'] = $area;
		} else {
			$array_where['emp_id_are IS NOT NULL'] = null;
		}
		$marcaciones = $this->marcacion_model->get_marcacion_area($array_where, 'emp_id, dxt_id, mar_fecha_entrada');
		if (count($marcaciones) > 0) {
			foreach ($marcaciones as $key => $value) {
				$tiempo_gracia = $this->marcacion_model->get_tiempo_gratis(array('tur_id' => $value['dxt_id_tur'], 'cot_estado' => 1, 'cot_id_fre' => $value['che_id_fre']));
				$hora_in_gracia = 0;
				$hora_out_gracia = 0;
				$aply_ret_inn = $aply_ret_out = false;
				foreach ($tiempo_gracia as $key2 => $value2) {
					if($value2['cot_tipo']==1){
						$aply_ret_inn = true;
						$hora_in_gracia = $value2['cot_minutos'];
					}
					if($value2['cot_tipo']==2){
						$aply_ret_out = true;
						$hora_out_gracia = $value2['cot_minutos'];
					} 
				}
				$hora_entrada = $this->marcacion_model->hora_a_minutos($value['mar_hora_entrada']);
				$hora_salida = $this->marcacion_model->hora_a_minutos($value['mar_hora_salida']);
				$hora_in_asignada = $this->marcacion_model->hora_a_minutos($value['deh_hora_entrada']);
				$hora_out_asignada = $this->marcacion_model->hora_a_minutos($value['deh_hora_salida']); 
				$permiso_inicia = $this->marcacion_model->hora_a_minutos($value['inicia_permiso']);
				$permiso_termina = $this->marcacion_model->hora_a_minutos($value['termina_permiso']);
				$hora_in = ($hora_in_asignada + $hora_in_gracia);
				$hora_out = ($hora_out_asignada - $hora_out_gracia);
				if ($permiso_termina > 0 && $permiso_termina > $hora_in && $permiso_termina <= $hora_out && $permiso_inicia <= $hora_in) {
					$hora_in = $permiso_termina;
				}
				if ($permiso_inicia > 0 && $permiso_inicia < $hora_out && $permiso_inicia >= $hora_in && $permiso_termina >= $hora_out) {
					$hora_out = $permiso_inicia;
				}
				$hora_entro = $hora_in + (59/60);//SI ENTRA 8:00:00, TAMBIEN SE RECIBE COMO VALIDO HASTA 8:00:59
				$retraso_inn = $retraso_out = 0;
				if($aply_ret_inn && $hora_entrada > $hora_entro){
					$retraso_inn += intval(($hora_entrada - $hora_in));
				}
				if($aply_ret_out && $hora_salida < $hora_out){
					$retraso_out += ceil(($hora_out - $hora_salida));
				}
				if ($retraso_inn > 0) {
					if (isset($repuesta[$value['are_id']]['entrada'])) {
						$repuesta[$value['are_id']]['entrada'] += round($retraso_inn);
						$repuesta[$value['are_id']]['inn_ctda'] += 1;
					} else {
						$repuesta[$value['are_id']]['entrada'] = round($retraso_inn);
						$repuesta[$value['are_id']]['are_nombre'] = $value['are_nombre'];
						$repuesta[$value['are_id']]['inn_ctda'] = 1;
					}					
				}
				if ($retraso_out > 0) {
					if (isset($repuesta[$value['are_id']]['salida'])) {
						$repuesta[$value['are_id']]['salida'] += round($retraso_out);
						$repuesta[$value['are_id']]['out_ctda'] += 1;
					} else {
						$repuesta[$value['are_id']]['salida'] = round($retraso_out);
						$repuesta[$value['are_id']]['are_nombre'] = $value['are_nombre'];
						$repuesta[$value['are_id']]['out_ctda'] = 1;
					}					
				}
			}
		}
		return $repuesta;
	}

	function estadistica_tiempo() {
	  satelite_validar();
	  if ($_POST) {
		//print_r($_POST);die();

		$fecha_desde = formatear_fecha("Y-m-d", $this->input->post('fecha_desde'));
		$fecha_hasta = formatear_fecha("Y-m-d", $this->input->post('fecha_hasta'));
		$motivo = $this->input->post('slc_motivo');
		$area = $this->input->post('slc_area');

		$tipo = $this->input->post('tipo_reporte');

		//$where["are_id != ''"] = null;
		
		if ($fecha_desde != '' && $fecha_hasta != '') {
			$where["date(hxe_fecha) >= '$fecha_desde'"] = null;
			$where["date(hxe_fecha_fin) <= '$fecha_hasta'"] = null;
		} else {
			$fecha =  date("Y-m-d",strtotime("- 3 month"));
			$where["date(hxe_fecha_fin) <= '$fecha'"] = null;
		}
		if ($area != '') {
			$where["are_id"] = $area;
			$where_esp["emp_id_are"] = $area;
		}
		if	($motivo != '') {
			$where["hxe_id_mtp"] = $motivo;
		}
 		$group_by = ($motivo != '')? 'emp_id' : 'mtp_id';
		$consulta = $this->accion_personal_model->get_informe_trimestral($where,$group_by);
		//print_r($this->db->last_query());die();
		$cant_total = array_sum(array_column($consulta,"cantidad"));
		$all_cod_js = '';
		
		if ($motivo == '') {
			foreach ($consulta as $key => $value) {
				$porcentaje = round((($value["cantidad"] * 100) / $cant_total),2);
				$coma = ((count($consulta) - 1) == $key)? '' : ',' ;
				$nombre = ($value["mtp_nombre"] != null)? $value["mtp_nombre"] : 'otros';

				$cod_js = "{
				name: '$nombre',
				y: $porcentaje}
				$coma";
				
				$all_cod_js .= $cod_js;
			}
		} else {
			$where_esp["emp_estado"] = 1; 
			$empleados = $this->gsatelite->get_tabla('emp_empleado', $where_esp);
			$motivo_name = $this->gsatelite->get_campo('mtp_motivo_permiso','mtp_nombre',Array('mtp_id' => $motivo));
			$array = array("Empleada/o NO pidieron permiso por $motivo_name" => 0,
							"Empleadas/os que pidieron por $motivo_name (1 a 3 veces)" => 0,
							"Empleadas/os que pidieron por $motivo_name  (mas de 5 veces)" => 0
						);

			foreach ($consulta as $key2 => $value2) {
				if ($value2["cantidad"] >= 1 && $value2["cantidad"] < 5) {
					$array["Empleadas/os que pidieron por $motivo_name (1 a 3 veces)"] ++;
				} elseif ($value2["cantidad"] > 5) {
					$array["Empleadas/os que pidieron por $motivo_name  (mas de 5 veces)"] ++;
				}
			}
			$array["Empleada/o NO pidieron permiso por $motivo_name"] = (count($empleados) - count($consulta));
			foreach ($array as $key => $value) {
				$coma = ((count($array) - 1) == $key)? '' : ',' ;
				$porcentaje = round((($value * 100) / $cant_total),2);
				$cod_js = "{
				name: '$key',
				y: $porcentaje}
				$coma";
				
				$all_cod_js .= $cod_js;
				$consulta_[$key] = array("mtp_nombre" =>  $key,"cantidad" => $value);
			}
			$consulta = $consulta_;
		}
		
		$data["fecha_desde"] = $this->input->post('fecha_desde');
		$data["fecha_hasta"] = $this->input->post('fecha_hasta');
		
		$data["tipo"] = $tipo;
		$data["consulta"] = $consulta;

		$data["cod_js"] = $all_cod_js;

		$html = $this->load->view('acciones_personal/consultas/grid_estadistica_tiempo', $data, true);
		
		//var_dump($tipo);die();
		$html_header  = $this->load->view('reporte/header', array('titulo' => 'Informe trimestral por area'), true);
		if($tipo==null or $tipo=="") {
			echo json_encode(array("html" => $html));
			die();
		}
		else if($tipo==1) { 
			$this->load->library('pdf');
			$reporte=$this->pdf->makePDF($html_header.$html,'L');
		}
		else {
			header("Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
			header("Content-Disposition: attachment;filename=Informe_trimestral_por_area.xls"); 
			header("Pragma: no-cache");
			header("Expires: 0");
			echo $html_header.$html;
		}
		die();
	  }
		  $dropdown = $this->gsatelite->get_dropdown('mtp_motivo_permiso', '{mtp_nombre}', '', '', '', '', 'mtp_id', true);
		$data['motivo']     = str_replace(array('<option value="0">Seleccione</option>','<option value=""></option>'), '', $dropdown);
		$dropdown = $this->gsatelite->get_dropdown('are_area', '{are_nombre}', '', '', '', '', 'are_id', true);
		$data['area']     = str_replace(array('<option value="0">Seleccione</option>','<option value=""></option>'), '', $dropdown);
		//print_r($data['motivo']);die();
		$data['titulo_personal']    = "Estadistica de tiempo no trabajado";
		$this->_cargarvista($data);

	}
	
	public function reporte_incapacidad($flag = null){
        satelite_validar();
        if ($_POST){
			//print_r($this->input->post());die();
            $post_array = $this->input->post();
			$fecha_inicio     = ($post_array['txtFechaIni'] != '') ? formatear_fecha("Y-m-d",$post_array['txtFechaIni']) : null;
			$fecha_fin    	  = ($post_array['txtFechaFin'] != '') ? formatear_fecha("Y-m-d",$post_array['txtFechaFin']) : NULL;
			$empleado 		  = ($post_array['slc_empleado'] != '') ? $post_array['slc_empleado'] : null;
			$tipo_incapacidad = ($post_array['slc_tip_incapacidad'] != '') ? $post_array['slc_tip_incapacidad'] : null;
            //Tipo de Reportes si sera Excel o Pdf
            $tipo_reporte = $this->input->post('tipo_reporte');
			$where = null;			
			if ($fecha_inicio != '' && $fecha_fin != '') {
                $where["inc_fecha_inicio BETWEEN '$fecha_inicio' AND '$fecha_fin'"] = null;
                $data['fecha_inicio'] = $fecha_inicio;
                $data['fecha_fin'] = $fecha_fin;
            }

            if ($empleado != null) {
                $where['inc_id_emp'] = $empleado;
			}

			if ($tipo_incapacidad != null) {
                $where['inc_id_tnc'] = $tipo_incapacidad;
			}

			$reporte = $this->accion_personal_model->get_incapacidad($where);
            $filename = 'rpt_reporte_incapacidad' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename'] = $filename;
            $data['reporte'] = $reporte;
            $data['tipo_reporte'] = $tipo_reporte;
            $data['area_nombre']  = $nombre_area;
            $data['titulo'] = 'Incapacidades';
			$html = $this->load->view('acciones_personal/consultas/grid_incapacidades', $data, true);
			// print_r($html);die();
            if ($flag) {
                $dato["html"] = $html;
				echo json_encode($dato);
				die();
            } else {
                if ($tipo_reporte == 'pdf') {
                    $data['titulo'] = 'Incapacidades';
                    $header = $this->load->view('reporte/header', $data, true);
                    $GLOBALS['nombre_reporte'] = 'reporte_incapacidades' . date('dmY');
                    $reporte = $header . $html;
                    //echo $reporte;
                    $this->pdf->makePdf($reporte, 'L', 'reporte_retiro_personal', 'Letter');
                } elseif ($tipo_reporte == 'excel') {
                    echo $html;
                }
            }
            die();
		} 
		$empleado_dropdown = $this->gsatelite->get_dropdown('emp_empleado', '{emp_codigo} - {emp_nombre} {emp_apellido}', '', '','', '', 'emp_id', true);
		$empleado_dropdown = str_replace('<option value="0">Sin Registros</option>', '', $empleado_dropdown); 
		$data['empleado']  = str_replace('<option value="0">Seleccione</option>', '', $empleado_dropdown);
		$tipo_incapacidad_dropdown = $this->gsatelite->get_dropdown('tnc_tipo_incapacidad', '{tnc_nombre}', '', null, null, '', 'tnc_id', true);
		$tipo_incapacidad_dropdown = str_replace('<option value="0">Sin Registros</option>', '', $tipo_incapacidad_dropdown); 
		$data['tipo_incapacidad']  = str_replace('<option value="0">Seleccione</option>', '', $tipo_incapacidad_dropdown);
		$data['titulo_personal']   = "Reporte de retiro de personal";
		$this->_cargarvista($data);
	}

	/*
    * @author Raul E.
    * @since 2020-sep
    * @return reporte dias disponibles para goze de vacacion
    */
	public function rpt_goce_vacaciones($flag = null){
		satelite_validar();
		if ($_POST) {
			$where = null;
			$fecha_inicio = ($flag) ? $this->input->post("fecha_ini") : $this->input->post("h_fecha_ini");
			$fecha_final  = ($flag) ? $this->input->post("fecha_fin") : $this->input->post("h_fecha_fin"); 
			$empleado  	  = ($flag) ? $this->input->post("empleado") : $this->input->post("h_empleado");
			$tipo_reporte = $this->input->post("tipo_reporte"); 
			if ($fecha_inicio != "" && $fecha_final != "") {
                $where["prv_desde >= "] = formatear_fecha("Y-m-d", $fecha_inicio);
                $where["prv_hasta <= "] = formatear_fecha("Y-m-d", $fecha_final);
                $data['fecha_inicio'] = $fecha_inicio;
                $data['fecha_final'] = $fecha_final;
            }
            if ($empleado != "") {
                $where['emp_id'] = $empleado;
            }
            $consulta = $this->accion_personal_model->get_goce_vacacion_reporte($where);
            $data['detalles'] = $consulta;
            $data['tipo_reporte'] = $tipo_reporte;
            $html = $this->load->view('acciones_personal/consultas/detalle_goce_vacacion', $data, true);
            if ($flag) {
            	echo json_encode(array('tabla' => $html, 'filas' => count($consulta)));
            } else {
            	if ($tipo_reporte == "excel") {
            		echo $html;
            	} elseif ($tipo_reporte == "panama") {
                    $reporte = $this->load->view('acciones_personal/consultas/detalle_goce_vacacion_panama', $data, true);
                    //echo $reporte;
                    $this->pdf->makePdf($reporte, 'P', 'reporte_retiro_personal', 'Letter');
            	} else {
            		$datos['titulo'] = 'goce de vacaciones';
                    $header = $this->load->view('reporte/header', $datos, true);
                    $GLOBALS['nombre_reporte'] = 'reporte_goce_vacaciones';
                    $reporte = $header . $html;
                    $this->pdf->SetTitle('Reporte');
                    $this->pdf->makePdf($reporte, 'L', 'reporte_goce_vacaciones', 'Letter');
            	}
            	
            }
		} else {
			$dropdown = $this->gsatelite->get_dropdown('emp_empleado', '{emp_codigo} - {emp_nombre} {emp_apellido}','',array('emp_estado'=>1), null, '', 'emp_id', true);
			$data['empleados'] =str_replace(array('<option value="0">Seleccione</option>','<option value="0">Sin Registros</option>'), '', $dropdown);
			$data['titulo_personal']   = "Reporte de Goce de Vacación";
			$this->_cargarvista($data);
		}		
	}

	function control_tiempo_compensatorio(){

		$data['titulo_personal']   = "Control del uso de tiempo compensatorio";

		$empleado_dropdown = $this->gsatelite->get_dropdown('emp_empleado', '{emp_codigo} - {emp_nombre} {emp_apellido}', '', '','', '', 'emp_id', true);
		$empleado_dropdown = str_replace('<option value="0">Sin Registros</option>', '', $empleado_dropdown); 
		$data['empleado']  = str_replace('<option value="0">Seleccione</option>', '', $empleado_dropdown);

		$this->_cargarvista($data);

	}

	function consulta_tiempo_compensatorio($flag = null){

		if ($_POST){
			//print_r($this->input->post());die();
            $post_array = $this->input->post();
			$fecha_inicio     = ($post_array['txtFechaIni'] != '') ? formatear_fecha("Y-m-d",$post_array['txtFechaIni']) : null;
			$fecha_fin    	  = ($post_array['txtFechaFin'] != '') ? formatear_fecha("Y-m-d",$post_array['txtFechaFin']) : NULL;
			$empleado 		  = ($post_array['slc_empleado'] != '') ? $post_array['slc_empleado'] : null;
            //Tipo de Reportes si sera Excel o Pdf
            $tipo_reporte = $this->input->post('tipo_reporte');
			$where = null;			
			if ($fecha_inicio != '' && $fecha_fin != '') {
                $where["tce_fecha_desde BETWEEN '$fecha_inicio' AND '$fecha_fin'"] = null;
                $data['fecha_inicio'] = $fecha_inicio;
                $data['fecha_fin'] = $fecha_fin;
            }

            if ($empleado != null) {
                $where['tce.tce_id_emp'] = $empleado;
			}



			$reporte = $this->accion_personal_model->obtener_tiempo_x_empleado($where);

			// echo json_encode($reporte);exit;


            $filename = 'rpt_uso_tiempo_compensado' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename'] = $filename;
            $data['reporte'] = $reporte;
            $data['tipo_reporte'] = $tipo_reporte;
            $data['area_nombre']  = $nombre_area;
            $data['titulo'] = 'Uso de tiempo compensatorio';
			$html = $this->load->view('acciones_personal/consultas/grid_tiempo_compensado', $data, true);
			// print_r($html);die();
            if ($flag) {
                $dato["html"] = $html;
				echo json_encode($dato);
				die();
            } else {
                if ($tipo_reporte == 'pdf') {
                    $data['titulo'] = 'Uso de tiempo compensatorio';
                    $GLOBALS['nombre_reporte'] = 'rpt_uso_tiempo_compensado' . date('dmY');
                    $reporte = $header . $html;
                    //echo $reporte;
                    $this->pdf->makePdf($reporte, 'P', 'rpt_uso_tiempo_compensado', 'Letter');
                } elseif ($tipo_reporte == 'excel') {
                    echo $html;
                }
            }
            die();
		} 

	}











	function control_tiempo_permisos(){

		$data['titulo_personal']   = "Control del tiempo de permisos";

		$empleado_dropdown = $this->gsatelite->get_dropdown('emp_empleado', '{emp_codigo} - {emp_nombre} {emp_apellido}', '', '','', '', 'emp_id', true);
		$empleado_dropdown = str_replace('<option value="0">Sin Registros</option>', '', $empleado_dropdown); 
		$data['empleado']  = str_replace('<option value="0">Seleccione</option>', '', $empleado_dropdown);

		$this->_cargarvista($data);

	}

	function consulta_tiempo_permisos($flag = null){

		if ($_POST){
			//print_r($this->input->post());die();
            $post_array = $this->input->post();
			$fecha_inicio     = ($post_array['txtFechaIni'] != '') ? formatear_fecha("Y-m-d",$post_array['txtFechaIni']) : null;
			$fecha_fin    	  = ($post_array['txtFechaFin'] != '') ? formatear_fecha("Y-m-d",$post_array['txtFechaFin']) : NULL;
			$empleado 		  = ($post_array['slc_empleado'] != '') ? $post_array['slc_empleado'] : null;
            //Tipo de Reportes si sera Excel o Pdf
            $tipo_reporte = $this->input->post('tipo_reporte');
			$where = null;			
			if ($fecha_inicio != '' && $fecha_fin != '') {
                $where["tce_fecha_desde BETWEEN '$fecha_inicio' AND '$fecha_fin'"] = null;
                $data['fecha_inicio'] = $fecha_inicio;
                $data['fecha_fin'] = $fecha_fin;
            }

            if ($empleado != null) {
                $where['tce.tce_id_emp'] = $empleado;
			}

			$where['hxc.hxc_estado'] = 1;



			$reporte = $this->accion_personal_model->consulta_tiempo_permisos($where);

			// echo json_encode($reporte);exit;


            $filename = 'rpt_uso_tiempo_permisos' . date('dmY') . '_' . substr(uniqid(md5(rand()), true), 0, 7);
            $data['filename'] = $filename;
            $data['reporte'] = $reporte;
            $data['tipo_reporte'] = $tipo_reporte;
            $data['area_nombre']  = $nombre_area;
            $data['titulo'] = 'Control del tiempo de permisos';
			$html = $this->load->view('acciones_personal/consultas/grid_tiempo_permisos', $data, true);
			// print_r($html);die();
            if ($flag) {
                $dato["html"] = $html;
				echo json_encode($dato);
				die();
            } else {
                if ($tipo_reporte == 'pdf') {
                    $data['titulo'] = 'Control del tiempo de permisos';
                    $GLOBALS['nombre_reporte'] = 'rpt_uso_tiempo_permisos' . date('dmY');
                    $reporte = $header . $html;
                    //echo $reporte;
                    $this->pdf->makePdf($reporte, 'P', 'rpt_uso_tiempo_permisos', 'Letter');
                } elseif ($tipo_reporte == 'excel') {
                    echo $html;
                }
            }
            die();
		} 

	}

	function plantillas_imprimibles(){
		if ($_POST){
			$plantilla = $this->input->post("slc_plantilla");
			$this->load->library('pdf');
			$this->pdf->setPrintFooter(false);
			$data = [];
			$html_header = '';		
			switch ($plantilla) {
				case 2:
					$html = $this->load->view('acciones_personal/consultas/informe_mision_oficial', $data, true);
					break;				
				case 3:
					$html = $this->load->view('acciones_personal/consultas/informe_entradas_salidas', $data, true);
					break;
					default:
					$html = $this->load->view('acciones_personal/consultas/informe_registro_tiempo_extraordinario', $data, true);
					break;
			}
			$this->pdf->makePDF($html_header.$html, 'L');
		} else {
			$data['titulo_personal']   = "Reporte de registro de tiempo extraordinario";
			$this->_cargarvista($data);
		}
	}

	function informe_registro_tiempo_extraordinario(){
		$this->load->library('pdf');
		$data = [];
		$html_header = '';		
		$html = $this->load->view('acciones_personal/consultas/informe_registro_tiempo_extraordinario', $data, true);
	  	$this->pdf->makePDF($html_header.$html, 'L');
}

}
?>